#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SPM_CORE_FI_H
#define SPM_CORE_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "spm_core_fi_types.h"
#include "spm_core_fi_typesConst.h"
#include "spm_diag_defset_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'SPM_CORE_FI'
 *
 * Fullname: System Power Management Service, Application Functional Interface
 *
 * Version: $Revision:   1.15  $
 *
 * Author: Klaus-Peter Kollai
 *
 * Date: $Date:  08.08.2018  $
 *
 * Department: CM-CI1/ERN2-E
 *
 * Title: SPM_CORE_FI
 *
 * <b>Description of 'SPM_CORE_FI':</b>
 *
 * public interface of the LCM component. Provided by procbaseearly.
 */

namespace SPM_CORE_FI {

static const int SERVICE_ID = 256;

static const int FID_SystemState = 1;

static const int FID_SystemMode = 4096;

static const int FID_DownloadLockState = 4097;

static const int FID_DownloadLockStates = 4098;

static const int FID_UpdateLock = 4099;

static const int FID_UpdateLockStates = 4100;

static const int FID_OnOffTrigger = 4111;

static const int FID_ActiveOnOffTrigger = 4367;

static const int FID_SubStates = 15;

static const int FID_HistoryTrigger = 32;

static const int FID_InsertState = 33;

static const int FID_MediaEjectState = 34;

static const int FID_PhoneMuteState = 35;

static const int FID_OnTipperState = 37;

static const int FID_IgnitionCycles = 515;

static const int FID_SysPwrMode = 516;

static const int FID_SysPwrSaveMode = 517;

static const int FID_MapDownloadLockState = 518;

static const int FID_StandbyTime = 5;

static const int FID_PersitentStandbyTime = 6;

static const int FID_IgnitionOffTime = 8;

static const int FID_DoorOpenTime = 10;

static const int FID_ClockDisplayTime = 11;

static const int FID_SystemStateTime = 232;

static const int FID_ProcessList = 511;

static const int FID_StartProcess = 510;

static const int FID_StopProcess = 509;

static const int FID_RestartProcess = 508;

static const int FID_WakeupReason = 112;

static const int FID_StartupReason = 113;

static const int FID_ConnectToBattery = 114;

static const int FID_CodeRequestState = 96;

static const int FID_StartUpSyncPointReached = 352;

static const int FID_ActiveStartUpSyncPoints = 353;

static const int FID_CvmEvent = 56;

static const int FID_UBatSense = 131;

static const int FID_CoproState = 49;

static const int FID_DevicePowerOnTime = 24;

static const int FID_LastSystemRuntime = 4352;

static const int FID_CurrentSystemRuntime = 4353;

static const int FID_ResetList = 65;

static const int FID_ResetCounter = 4161;

static const int FID_TransportModeList = 67;

static const int FID_ResetHistory = 68;

static const int FID_WakeupHistory = 69;

static const int FID_StateHistory = 70;

static const int FID_ErrStateHistory01 = 71;

static const int FID_ErrStateHistory02 = 72;

static const int FID_ErrStateHistory03 = 73;

static const int FID_ErrStateHistory04 = 74;

static const int FID_ErrStateHistory05 = 75;

static const int FID_SwitchOnHistory = 76;

static const int FID_ClearList = 4160;

static const int FID_DeviceOnCounter = 4176;

static const int FID_VoltageEventCounter = 4177;

static const int FID_VoltageRangeHistogram = 4178;

static const int FID_CpuUsageStatistic = 4179;

static const int FID_RamUsageStatistic = 4180;

static const int FID_StartupTimeStatistic = 4181;

static const int FID_SWVersionStatistic = 4182;

static const int FID_SpecificSWVersionStatistic = 4183;

static const int FID_RestartSystem = 4162;

static const int FID_RunlevelState = 4417;

static const int FID_Restart = 64;

static const int FID_Lifesign = 629;

static const int FID_HmiState = 16;

static const int FID_SystemPowerBehaviour = 4112;

static const int FID_AudioSourceChange = 4119;

static const int FID_DimState = 17;

static const int FID_DimmingState = 4113;

static const int FID_BluetoothState = 19;

static const int FID_ChangeBluetoothState = 1043;

static const int FID_AudioState = 20;

static const int FID_ChangeAudioState = 1044;

static const int FID_SpiState = 21;

static const int FID_ChangeSpiState = 1045;

static const int FID_TunerState = 23;

static const int FID_ChangeTunerState = 1047;

static const int FID_WifiState = 25;

static const int FID_ChangeWifiState = 1049;

static const int FID_ShutdownAndTerminateCcaApps = 4;

static const int FID_OnOffReason = 2;

static const int FID_WakeupList = 66;

static const int FID_StartupFinished = 261;

static const int FID_SysState = 770;

static const int FID_MostState = 771;

static const int FID_MostVersion = 772;

static const int FID_RVCState = 565;

static const int FID_TriggerMostRemoteReset = 1793;

static const int FID_Partnumber = 1794;

static const int FID_Partnumbers = 1795;

static const int FID_Alphacode = 1796;

static const int FID_Alphacodes = 1797;

static const int FID_SetFactorySettingsNew = 137;

static const int FID_ManufacturersEnableCounter = 1540;

static const int FID_NoCalibrationState = 1541;

static const int FID_SecurityCommError = 132;

static const int FID_SecurityMoreThan10Vin = 133;

static const int FID_SecurityInvalidVin = 134;

static const int FID_SecurityCurrentVin = 135;

static const int FID_SecurityVinHistory = 136;

static const int FID_ClearVIN = 1314;

static const int FID_VIN = 1313;

static const int FID_SecurityState = 1315;

static const int FID_VehicleID = 1316;

static const int FID_DisplayVariant = 1030;

static const int FID_ReductionLevel = 2050;

static const int FID_PrepareDownload = 2304;

static const int FID_EndDownload = 2305;

static const int FID_SetOnConfiguration = 2306;

static const int FID_SetProcessConfiguration = 2307;

static const int FID_StartupState = 3;

static const int FID_EntertainMute = 22;

static const int FID_EntertainDeMute = 4118;

static const int FID_EntertainMuteRequest = 4117;

static const int FID_WelcomeAudioActivation = 4133;

static const int FID_WelcomeAudioState = 8230;

static const int FID_UnballastTimeFromEngineStopped = 1888;

static const int FID_UnballastTimeBeforeUnballast = 1889;

static const int FID_UnballastWarningTime = 1890;

static const int FID_DegradedCount = 1891;

static const int FID_DegradedTime = 1892;

static const int FID_PhoneHandoverWarnTime = 4120;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 4;

static const int VERSION_PATCH = 0;

// forward declarations
class SystemStateStatus;

class SystemModeStart;

class SystemModeResult;

class DownloadLockStateStart;

class DownloadLockStateResult;

class DownloadLockStatesStatus;

class UpdateLockStart;

class UpdateLockResult;

class UpdateLockStatesStatus;

class OnOffTriggerStart;

class ActiveOnOffTriggerStatus;

class SubStatesStatus;

class SubStatesSet;

class HistoryTriggerStatus;

class InsertStateStatus;

class MediaEjectStateStatus;

class PhoneMuteStateStatus;

class OnTipperStateStatus;

class IgnitionCyclesStatus;

class SysPwrModeStatus;

class SysPwrSaveModeStatus;

class MapDownloadLockStateStatus;

class StandbyTimeStatus;

class StandbyTimeSet;

class PersitentStandbyTimeStatus;

class PersitentStandbyTimeSet;

class IgnitionOffTimeStatus;

class IgnitionOffTimeSet;

class DoorOpenTimeStatus;

class DoorOpenTimeSet;

class ClockDisplayTimeStatus;

class ClockDisplayTimeSet;

class SystemStateTimeStatus;

class SystemStateTimeSet;

class SystemStateTimeGet;

class ProcessListStatus;

class StartProcessStart;

class StartProcessResult;

class StopProcessStart;

class StopProcessResult;

class RestartProcessStart;

class RestartProcessResult;

class WakeupReasonStatus;

class StartupReasonStatus;

class ConnectToBatteryStatus;

class CodeRequestStateStatus;

class CodeRequestStateSet;

class StartUpSyncPointReachedStart;

class ActiveStartUpSyncPointsStatus;

class CvmEventStatus;

class UBatSenseStatus;

class CoproStateStatus;

class CoproStateSet;

class DevicePowerOnTimeStatus;

class DevicePowerOnTimeSet;

class LastSystemRuntimeStatus;

class CurrentSystemRuntimeStatus;

class ResetListStatus;

class ResetListSet;

class ResetCounterStatus;

class ResetCounterSet;

class TransportModeListStatus;

class TransportModeListSet;

class ResetHistoryStatus;

class WakeupHistoryStatus;

class StateHistoryStatus;

class ErrStateHistory01Status;

class ErrStateHistory02Status;

class ErrStateHistory03Status;

class ErrStateHistory04Status;

class ErrStateHistory05Status;

class SwitchOnHistoryStatus;

class ClearListStart;

class DeviceOnCounterStatus;

class VoltageEventCounterStatus;

class VoltageRangeHistogramStatus;

class CpuUsageStatisticStatus;

class RamUsageStatisticStatus;

class StartupTimeStatisticStatus;

class SWVersionStatisticStatus;

class SpecificSWVersionStatisticStart;

class SpecificSWVersionStatisticResult;

class RestartSystemStart;

class RestartSystemResult;

class RunlevelStateStatus;

class RestartStatus;

class RestartSet;

class LifesignStatus;

class HmiStateStatus;

class SystemPowerBehaviourStatus;

class AudioSourceChangeStart;

class DimStateStatus;

class DimmingStateStatus;

class BluetoothStateStatus;

class ChangeBluetoothStateStart;

class AudioStateStatus;

class ChangeAudioStateStart;

class SpiStateStatus;

class ChangeSpiStateStart;

class TunerStateStatus;

class ChangeTunerStateStart;

class WifiStateStatus;

class ChangeWifiStateStart;

class ShutdownAndTerminateCcaAppsStart;

class OnOffReasonStatus;

class OnOffReasonSet;

class WakeupListStatus;

class WakeupListSet;

class StartupFinishedStatus;

class SysStateStatus;

class MostStateStatus;

class MostVersionStatus;

class RVCStateStatus;

class RVCStateSet;

class TriggerMostRemoteResetStatus;

class PartnumberStatus;

class PartnumberSet;

class PartnumberGet;

class PartnumbersStatus;

class AlphacodeStatus;

class AlphacodeSet;

class AlphacodeGet;

class AlphacodesStatus;

class SetFactorySettingsNewStart;

class SetFactorySettingsNewResult;

class ManufacturersEnableCounterStatus;

class ManufacturersEnableCounterSet;

class NoCalibrationStateStatus;

class NoCalibrationStateSet;

class SecurityCommErrorStatus;

class SecurityMoreThan10VinStatus;

class SecurityInvalidVinStatus;

class SecurityCurrentVinStatus;

class SecurityVinHistoryStatus;

class ClearVINResult;

class VINStatus;

class SecurityStateStatus;

class VehicleIDStatus;

class DisplayVariantStatus;

class DisplayVariantSet;

class ReductionLevelStatus;

class PrepareDownloadStart;

class PrepareDownloadResult;

class EndDownloadResult;

class SetOnConfigurationStart;

class SetOnConfigurationResult;

class SetProcessConfigurationStart;

class SetProcessConfigurationResult;

class StartupStateStatus;

class EntertainMuteStatus;

class EntertainDeMuteResult;

class EntertainMuteRequestResult;

class WelcomeAudioActivationStart;

class WelcomeAudioActivationResult;

class WelcomeAudioStateStatus;

class UnballastTimeFromEngineStoppedStatus;

class UnballastTimeBeforeUnballastStatus;

class UnballastTimeBeforeUnballastSet;

class UnballastWarningTimeStatus;

class UnballastWarningTimeSet;

class DegradedCountStatus;

class DegradedTimeStatus;

class PhoneHandoverWarnTimeStatus;

class PhoneHandoverWarnTimeSet;

// type definitions
/**
 * The get message of the property "SystemState"
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStateGet;

/**
 * The upreg message of the property "SystemState"
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStateUpReg;

/**
 * The relUpReg message of the property "SystemState"
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStateRelUpReg;

/**
 * The error message of 'SystemState'
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemStateError;

/**
 * The abort error message of the method "SystemMode"
 * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemModeAbortError;

/**
 * The error message of 'SystemMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemModeError;

/**
 * The abort error message of the method "DownloadLockState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLock !!!
 * Method to lock specific resources for restricted downloads.
 */
typedef ::asf::cca::CcaTypes::DefaultError DownloadLockStateAbortError;

/**
 * The error message of 'DownloadLockState'
 */
typedef ::asf::cca::CcaTypes::DefaultError DownloadLockStateError;

/**
 * The get message of the property "DownloadLockStates"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLockStates !!!
 * Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadLockStatesGet;

/**
 * The upreg message of the property "DownloadLockStates"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLockStates !!!
 * Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadLockStatesUpReg;

/**
 * The relUpReg message of the property "DownloadLockStates"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLockStates !!!
 * Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DownloadLockStatesRelUpReg;

/**
 * The error message of 'DownloadLockStates'
 */
typedef ::asf::cca::CcaTypes::DefaultError DownloadLockStatesError;

/**
 * The abort error message of the method "UpdateLock"
 * Method to modify a lock.
 * Not existing locks will be created.
 * Locks that are no longer owned nor used will be deleted.
 * Owner and state of a lock will be stored persistently
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateLockAbortError;

/**
 * The error message of 'UpdateLock'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateLockError;

/**
 * The get message of the property "UpdateLockStates"
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area
 * or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateLockStatesGet;

/**
 * The upreg message of the property "UpdateLockStates"
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area
 * or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateLockStatesUpReg;

/**
 * The relUpReg message of the property "UpdateLockStates"
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area
 * or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UpdateLockStatesRelUpReg;

/**
 * The error message of 'UpdateLockStates'
 */
typedef ::asf::cca::CcaTypes::DefaultError UpdateLockStatesError;

/**
 * The result message of the method "OnOffTrigger"
 * Set a new OnOff reason. A new system state will be calculated.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnOffTriggerResult;

/**
 * The abort error message of the method "OnOffTrigger"
 * Set a new OnOff reason. A new system state will be calculated.
 */
typedef ::asf::cca::CcaTypes::DefaultError OnOffTriggerAbortError;

/**
 * The error message of 'OnOffTrigger'
 */
typedef ::asf::cca::CcaTypes::DefaultError OnOffTriggerError;

/**
 * The get message of the property "ActiveOnOffTrigger"
 * A list of all active trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveOnOffTriggerGet;

/**
 * The upreg message of the property "ActiveOnOffTrigger"
 * A list of all active trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveOnOffTriggerUpReg;

/**
 * The relUpReg message of the property "ActiveOnOffTrigger"
 * A list of all active trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveOnOffTriggerRelUpReg;

/**
 * The error message of 'ActiveOnOffTrigger'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActiveOnOffTriggerError;

/**
 * The get message of the property "SubStates"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use method "OnOffTrigger (0x100f)" to trigger new on/off reasons.</p>
 * <p>-- Use property "ActiveOnOffTrigger (0x110f)" to get active trigger. Even better: For detailed information about trigger e.g. ignition key, OnTipper, eject, ... use the corresponding properties.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Set a new OnOff reason. New system state will be calculated.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubStatesGet;

/**
 * The upreg message of the property "SubStates"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use method "OnOffTrigger (0x100f)" to trigger new on/off reasons.</p>
 * <p>-- Use property "ActiveOnOffTrigger (0x110f)" to get active trigger. Even better: For detailed information about trigger e.g. ignition key, OnTipper, eject, ... use the corresponding properties.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Set a new OnOff reason. New system state will be calculated.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubStatesUpReg;

/**
 * The relUpReg message of the property "SubStates"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use method "OnOffTrigger (0x100f)" to trigger new on/off reasons.</p>
 * <p>-- Use property "ActiveOnOffTrigger (0x110f)" to get active trigger. Even better: For detailed information about trigger e.g. ignition key, OnTipper, eject, ... use the corresponding properties.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Set a new OnOff reason. New system state will be calculated.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SubStatesRelUpReg;

/**
 * The error message of 'SubStates'
 */
typedef ::asf::cca::CcaTypes::DefaultError SubStatesError;

/**
 * The get message of the property "HistoryTrigger"
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HistoryTriggerGet;

/**
 * The upreg message of the property "HistoryTrigger"
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HistoryTriggerUpReg;

/**
 * The relUpReg message of the property "HistoryTrigger"
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HistoryTriggerRelUpReg;

/**
 * The error message of 'HistoryTrigger'
 */
typedef ::asf::cca::CcaTypes::DefaultError HistoryTriggerError;

/**
 * The get message of the property "InsertState"
 * Insert key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InsertStateGet;

/**
 * The upreg message of the property "InsertState"
 * Insert key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InsertStateUpReg;

/**
 * The relUpReg message of the property "InsertState"
 * Insert key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InsertStateRelUpReg;

/**
 * The error message of 'InsertState'
 */
typedef ::asf::cca::CcaTypes::DefaultError InsertStateError;

/**
 * The get message of the property "MediaEjectState"
 * Media Eject key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaEjectStateGet;

/**
 * The upreg message of the property "MediaEjectState"
 * Media Eject key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaEjectStateUpReg;

/**
 * The relUpReg message of the property "MediaEjectState"
 * Media Eject key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MediaEjectStateRelUpReg;

/**
 * The error message of 'MediaEjectState'
 */
typedef ::asf::cca::CcaTypes::DefaultError MediaEjectStateError;

/**
 * The get message of the property "PhoneMuteState"
 * State of the hard-wired phone line.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneMuteStateGet;

/**
 * The upreg message of the property "PhoneMuteState"
 * State of the hard-wired phone line.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneMuteStateUpReg;

/**
 * The relUpReg message of the property "PhoneMuteState"
 * State of the hard-wired phone line.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneMuteStateRelUpReg;

/**
 * The error message of 'PhoneMuteState'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneMuteStateError;

/**
 * The get message of the property "OnTipperState"
 * Media Eject key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnTipperStateGet;

/**
 * The upreg message of the property "OnTipperState"
 * Media Eject key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnTipperStateUpReg;

/**
 * The relUpReg message of the property "OnTipperState"
 * Media Eject key state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnTipperStateRelUpReg;

/**
 * The error message of 'OnTipperState'
 */
typedef ::asf::cca::CcaTypes::DefaultError OnTipperStateError;

/**
 * The get message of the property "IgnitionCycles"
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionCyclesGet;

/**
 * The upreg message of the property "IgnitionCycles"
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionCyclesUpReg;

/**
 * The relUpReg message of the property "IgnitionCycles"
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionCyclesRelUpReg;

/**
 * The error message of 'IgnitionCycles'
 */
typedef ::asf::cca::CcaTypes::DefaultError IgnitionCyclesError;

/**
 * The get message of the property "SysPwrMode"
 * <p>This property informs about the powermode the vehicle is currently in (key position).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysPwrModeGet;

/**
 * The upreg message of the property "SysPwrMode"
 * <p>This property informs about the powermode the vehicle is currently in (key position).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysPwrModeUpReg;

/**
 * The relUpReg message of the property "SysPwrMode"
 * <p>This property informs about the powermode the vehicle is currently in (key position).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysPwrModeRelUpReg;

/**
 * The error message of 'SysPwrMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SysPwrModeError;

/**
 * The get message of the property "SysPwrSaveMode"
 * <p>This property informs about an active power save mode e.g. Transportmode, FactoryMode ....</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysPwrSaveModeGet;

/**
 * The upreg message of the property "SysPwrSaveMode"
 * <p>This property informs about an active power save mode e.g. Transportmode, FactoryMode ....</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysPwrSaveModeUpReg;

/**
 * The relUpReg message of the property "SysPwrSaveMode"
 * <p>This property informs about an active power save mode e.g. Transportmode, FactoryMode ....</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysPwrSaveModeRelUpReg;

/**
 * The error message of 'SysPwrSaveMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError SysPwrSaveModeError;

/**
 * The get message of the property "MapDownloadLockState"
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDownloadLockStateGet;

/**
 * The upreg message of the property "MapDownloadLockState"
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDownloadLockStateUpReg;

/**
 * The relUpReg message of the property "MapDownloadLockState"
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MapDownloadLockStateRelUpReg;

/**
 * The error message of 'MapDownloadLockState'
 */
typedef ::asf::cca::CcaTypes::DefaultError MapDownloadLockStateError;

/**
 * The get message of the property "StandbyTime"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StandbyTimeGet;

/**
 * The upreg message of the property "StandbyTime"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StandbyTimeUpReg;

/**
 * The relUpReg message of the property "StandbyTime"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StandbyTimeRelUpReg;

/**
 * The error message of 'StandbyTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError StandbyTimeError;

/**
 * The get message of the property "PersitentStandbyTime"
 * Set standby time persistent. Must be set before entering the standby state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PersitentStandbyTimeGet;

/**
 * The upreg message of the property "PersitentStandbyTime"
 * Set standby time persistent. Must be set before entering the standby state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PersitentStandbyTimeUpReg;

/**
 * The relUpReg message of the property "PersitentStandbyTime"
 * Set standby time persistent. Must be set before entering the standby state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PersitentStandbyTimeRelUpReg;

/**
 * The error message of 'PersitentStandbyTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError PersitentStandbyTimeError;

/**
 * The get message of the property "IgnitionOffTime"
 * Set ignition off time. A restart is necessary.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionOffTimeGet;

/**
 * The upreg message of the property "IgnitionOffTime"
 * Set ignition off time. A restart is necessary.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionOffTimeUpReg;

/**
 * The relUpReg message of the property "IgnitionOffTime"
 * Set ignition off time. A restart is necessary.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage IgnitionOffTimeRelUpReg;

/**
 * The error message of 'IgnitionOffTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError IgnitionOffTimeError;

/**
 * The get message of the property "DoorOpenTime"
 * Set door open time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoorOpenTimeGet;

/**
 * The upreg message of the property "DoorOpenTime"
 * Set door open time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoorOpenTimeUpReg;

/**
 * The relUpReg message of the property "DoorOpenTime"
 * Set door open time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DoorOpenTimeRelUpReg;

/**
 * The error message of 'DoorOpenTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError DoorOpenTimeError;

/**
 * The get message of the property "ClockDisplayTime"
 * Set clock display time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClockDisplayTimeGet;

/**
 * The upreg message of the property "ClockDisplayTime"
 * Set clock display time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClockDisplayTimeUpReg;

/**
 * The relUpReg message of the property "ClockDisplayTime"
 * Set clock display time.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClockDisplayTimeRelUpReg;

/**
 * The error message of 'ClockDisplayTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClockDisplayTimeError;

/**
 * The upreg message of the property "SystemStateTime"
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStateTimeUpReg;

/**
 * The relUpReg message of the property "SystemStateTime"
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemStateTimeRelUpReg;

/**
 * The error message of 'SystemStateTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemStateTimeError;

/**
 * The get message of the property "ProcessList"
 * Informs about all processes configured in start configuration of SPM.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProcessListGet;

/**
 * The upreg message of the property "ProcessList"
 * Informs about all processes configured in start configuration of SPM.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProcessListUpReg;

/**
 * The relUpReg message of the property "ProcessList"
 * Informs about all processes configured in start configuration of SPM.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProcessListRelUpReg;

/**
 * The error message of 'ProcessList'
 */
typedef ::asf::cca::CcaTypes::DefaultError ProcessListError;

/**
 * The abort error message of the method "StartProcess"
 * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartProcessAbortError;

/**
 * The error message of 'StartProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartProcessError;

/**
 * The abort error message of the method "StopProcess"
 * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes.
 */
typedef ::asf::cca::CcaTypes::DefaultError StopProcessAbortError;

/**
 * The error message of 'StopProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError StopProcessError;

/**
 * The abort error message of the method "RestartProcess"
 * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes.
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartProcessAbortError;

/**
 * The error message of 'RestartProcess'
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartProcessError;

/**
 * The get message of the property "WakeupReason"
 * <p>The current wakeup reason of the ApplicationProcessor is provided by this property. Also for devices with a RadioUnit this property will only display the ApplicationProcessor wakeup reason. Is the RU waked up by CAN the wakeup reason COPRO_REQ is shown.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupReasonGet;

/**
 * The upreg message of the property "WakeupReason"
 * <p>The current wakeup reason of the ApplicationProcessor is provided by this property. Also for devices with a RadioUnit this property will only display the ApplicationProcessor wakeup reason. Is the RU waked up by CAN the wakeup reason COPRO_REQ is shown.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupReasonUpReg;

/**
 * The relUpReg message of the property "WakeupReason"
 * <p>The current wakeup reason of the ApplicationProcessor is provided by this property. Also for devices with a RadioUnit this property will only display the ApplicationProcessor wakeup reason. Is the RU waked up by CAN the wakeup reason COPRO_REQ is shown.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupReasonRelUpReg;

/**
 * The error message of 'WakeupReason'
 */
typedef ::asf::cca::CcaTypes::DefaultError WakeupReasonError;

/**
 * The get message of the property "StartupReason"
 * <p>All incoming On/Off reasons will be accumulated in this property. This property is bit-coded and is not cleared at runtime.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupReasonGet;

/**
 * The upreg message of the property "StartupReason"
 * <p>All incoming On/Off reasons will be accumulated in this property. This property is bit-coded and is not cleared at runtime.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupReasonUpReg;

/**
 * The relUpReg message of the property "StartupReason"
 * <p>All incoming On/Off reasons will be accumulated in this property. This property is bit-coded and is not cleared at runtime.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupReasonRelUpReg;

/**
 * The error message of 'StartupReason'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupReasonError;

/**
 * The get message of the property "ConnectToBattery"
 * <p>Connect to battery counter.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectToBatteryGet;

/**
 * The upreg message of the property "ConnectToBattery"
 * <p>Connect to battery counter.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectToBatteryUpReg;

/**
 * The relUpReg message of the property "ConnectToBattery"
 * <p>Connect to battery counter.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ConnectToBatteryRelUpReg;

/**
 * The error message of 'ConnectToBattery'
 */
typedef ::asf::cca::CcaTypes::DefaultError ConnectToBatteryError;

/**
 * The get message of the property "CodeRequestState"
 * Current code request state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CodeRequestStateGet;

/**
 * The upreg message of the property "CodeRequestState"
 * Current code request state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CodeRequestStateUpReg;

/**
 * The relUpReg message of the property "CodeRequestState"
 * Current code request state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CodeRequestStateRelUpReg;

/**
 * The error message of 'CodeRequestState'
 */
typedef ::asf::cca::CcaTypes::DefaultError CodeRequestStateError;

/**
 * The result message of the method "StartUpSyncPointReached"
 * Inform about a new reached sync point.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartUpSyncPointReachedResult;

/**
 * The abort error message of the method "StartUpSyncPointReached"
 * Inform about a new reached sync point.
 */
typedef ::asf::cca::CcaTypes::DefaultError StartUpSyncPointReachedAbortError;

/**
 * The error message of 'StartUpSyncPointReached'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartUpSyncPointReachedError;

/**
 * The get message of the property "ActiveStartUpSyncPoints"
 * Informs about all StartupSyncPoints since last wakeup.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveStartUpSyncPointsGet;

/**
 * The upreg message of the property "ActiveStartUpSyncPoints"
 * Informs about all StartupSyncPoints since last wakeup.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveStartUpSyncPointsUpReg;

/**
 * The relUpReg message of the property "ActiveStartUpSyncPoints"
 * Informs about all StartupSyncPoints since last wakeup.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ActiveStartUpSyncPointsRelUpReg;

/**
 * The error message of 'ActiveStartUpSyncPoints'
 */
typedef ::asf::cca::CcaTypes::DefaultError ActiveStartUpSyncPointsError;

/**
 * The get message of the property "CvmEvent"
 * <p>This property informs about voltage level changes. The old CCA CVM mechanism is replaced by this property. If an application is interested in voltage changes an upreg to this property is needed.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CvmEventGet;

/**
 * The upreg message of the property "CvmEvent"
 * <p>This property informs about voltage level changes. The old CCA CVM mechanism is replaced by this property. If an application is interested in voltage changes an upreg to this property is needed.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CvmEventUpReg;

/**
 * The relUpReg message of the property "CvmEvent"
 * <p>This property informs about voltage level changes. The old CCA CVM mechanism is replaced by this property. If an application is interested in voltage changes an upreg to this property is needed.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CvmEventRelUpReg;

/**
 * The error message of 'CvmEvent'
 */
typedef ::asf::cca::CcaTypes::DefaultError CvmEventError;

/**
 * The get message of the property "UBatSense"
 * Current measured voltage level in mV.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UBatSenseGet;

/**
 * The upreg message of the property "UBatSense"
 * Current measured voltage level in mV.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UBatSenseUpReg;

/**
 * The relUpReg message of the property "UBatSense"
 * Current measured voltage level in mV.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UBatSenseRelUpReg;

/**
 * The error message of 'UBatSense'
 */
typedef ::asf::cca::CcaTypes::DefaultError UBatSenseError;

/**
 * The get message of the property "CoproState"
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CoproStateGet;

/**
 * The upreg message of the property "CoproState"
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CoproStateUpReg;

/**
 * The relUpReg message of the property "CoproState"
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CoproStateRelUpReg;

/**
 * The error message of 'CoproState'
 */
typedef ::asf::cca::CcaTypes::DefaultError CoproStateError;

/**
 * The get message of the property "DevicePowerOnTime"
 * <p>Operation hour counter. It counts the device power on time in seconds until the end of the products life cycle.</p>
 * <p>- it never has an overflow error</p>
 * <p>- it is not counting when the processor is in "power mode OFF/SLEEP"</p>
 * <p>- it continues counting after a battery loss</p>
 * <p>- it never will be cleared/resetted (only by diagnostic command)</p>
 * <p>values for this counter will be stored:</p>
 * <p>- every 15 minutes</p>
 * <p>- and whenever the processor changes to "power mode OFF/SLEEP"</p>
 * <p>- and after each BurnIn cycle</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePowerOnTimeGet;

/**
 * The upreg message of the property "DevicePowerOnTime"
 * <p>Operation hour counter. It counts the device power on time in seconds until the end of the products life cycle.</p>
 * <p>- it never has an overflow error</p>
 * <p>- it is not counting when the processor is in "power mode OFF/SLEEP"</p>
 * <p>- it continues counting after a battery loss</p>
 * <p>- it never will be cleared/resetted (only by diagnostic command)</p>
 * <p>values for this counter will be stored:</p>
 * <p>- every 15 minutes</p>
 * <p>- and whenever the processor changes to "power mode OFF/SLEEP"</p>
 * <p>- and after each BurnIn cycle</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePowerOnTimeUpReg;

/**
 * The relUpReg message of the property "DevicePowerOnTime"
 * <p>Operation hour counter. It counts the device power on time in seconds until the end of the products life cycle.</p>
 * <p>- it never has an overflow error</p>
 * <p>- it is not counting when the processor is in "power mode OFF/SLEEP"</p>
 * <p>- it continues counting after a battery loss</p>
 * <p>- it never will be cleared/resetted (only by diagnostic command)</p>
 * <p>values for this counter will be stored:</p>
 * <p>- every 15 minutes</p>
 * <p>- and whenever the processor changes to "power mode OFF/SLEEP"</p>
 * <p>- and after each BurnIn cycle</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevicePowerOnTimeRelUpReg;

/**
 * The error message of 'DevicePowerOnTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevicePowerOnTimeError;

/**
 * The get message of the property "LastSystemRuntime"
 * Time in s the system was running in the last power cycle.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LastSystemRuntimeGet;

/**
 * The upreg message of the property "LastSystemRuntime"
 * Time in s the system was running in the last power cycle.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LastSystemRuntimeUpReg;

/**
 * The relUpReg message of the property "LastSystemRuntime"
 * Time in s the system was running in the last power cycle.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LastSystemRuntimeRelUpReg;

/**
 * The error message of 'LastSystemRuntime'
 */
typedef ::asf::cca::CcaTypes::DefaultError LastSystemRuntimeError;

/**
 * The get message of the property "CurrentSystemRuntime"
 * Time in s the system is currently active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentSystemRuntimeGet;

/**
 * The upreg message of the property "CurrentSystemRuntime"
 * Time in s the system is currently active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentSystemRuntimeUpReg;

/**
 * The relUpReg message of the property "CurrentSystemRuntime"
 * Time in s the system is currently active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CurrentSystemRuntimeRelUpReg;

/**
 * The error message of 'CurrentSystemRuntime'
 */
typedef ::asf::cca::CcaTypes::DefaultError CurrentSystemRuntimeError;

/**
 * The get message of the property "ResetList"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use property "ResetCounter (0x1041)" to get Reset information.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Reset information.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetListGet;

/**
 * The upreg message of the property "ResetList"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use property "ResetCounter (0x1041)" to get Reset information.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Reset information.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetListUpReg;

/**
 * The relUpReg message of the property "ResetList"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use property "ResetCounter (0x1041)" to get Reset information.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Reset information.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetListRelUpReg;

/**
 * The error message of 'ResetList'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetListError;

/**
 * The get message of the property "ResetCounter"
 * Information about detected reset reasons.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetCounterGet;

/**
 * The upreg message of the property "ResetCounter"
 * Information about detected reset reasons.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetCounterUpReg;

/**
 * The relUpReg message of the property "ResetCounter"
 * Information about detected reset reasons.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetCounterRelUpReg;

/**
 * The error message of 'ResetCounter'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetCounterError;

/**
 * The get message of the property "TransportModeList"
 * History of recent Transportmode trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TransportModeListGet;

/**
 * The upreg message of the property "TransportModeList"
 * History of recent Transportmode trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TransportModeListUpReg;

/**
 * The relUpReg message of the property "TransportModeList"
 * History of recent Transportmode trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TransportModeListRelUpReg;

/**
 * The error message of 'TransportModeList'
 */
typedef ::asf::cca::CcaTypes::DefaultError TransportModeListError;

/**
 * The set message of the property "ResetHistory"
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistorySet;

/**
 * The get message of the property "ResetHistory"
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryGet;

/**
 * The upreg message of the property "ResetHistory"
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryUpReg;

/**
 * The relUpReg message of the property "ResetHistory"
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ResetHistoryRelUpReg;

/**
 * The error message of 'ResetHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError ResetHistoryError;

/**
 * The set message of the property "WakeupHistory"
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupHistorySet;

/**
 * The get message of the property "WakeupHistory"
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupHistoryGet;

/**
 * The upreg message of the property "WakeupHistory"
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupHistoryUpReg;

/**
 * The relUpReg message of the property "WakeupHistory"
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupHistoryRelUpReg;

/**
 * The error message of 'WakeupHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError WakeupHistoryError;

/**
 * The set message of the property "StateHistory"
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StateHistorySet;

/**
 * The get message of the property "StateHistory"
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StateHistoryGet;

/**
 * The upreg message of the property "StateHistory"
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StateHistoryUpReg;

/**
 * The relUpReg message of the property "StateHistory"
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StateHistoryRelUpReg;

/**
 * The error message of 'StateHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError StateHistoryError;

/**
 * The set message of the property "ErrStateHistory01"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory01Set;

/**
 * The get message of the property "ErrStateHistory01"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory01Get;

/**
 * The upreg message of the property "ErrStateHistory01"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory01UpReg;

/**
 * The relUpReg message of the property "ErrStateHistory01"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory01RelUpReg;

/**
 * The error message of 'ErrStateHistory01'
 */
typedef ::asf::cca::CcaTypes::DefaultError ErrStateHistory01Error;

/**
 * The set message of the property "ErrStateHistory02"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory02Set;

/**
 * The get message of the property "ErrStateHistory02"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory02Get;

/**
 * The upreg message of the property "ErrStateHistory02"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory02UpReg;

/**
 * The relUpReg message of the property "ErrStateHistory02"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory02RelUpReg;

/**
 * The error message of 'ErrStateHistory02'
 */
typedef ::asf::cca::CcaTypes::DefaultError ErrStateHistory02Error;

/**
 * The set message of the property "ErrStateHistory03"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory03Set;

/**
 * The get message of the property "ErrStateHistory03"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory03Get;

/**
 * The upreg message of the property "ErrStateHistory03"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory03UpReg;

/**
 * The relUpReg message of the property "ErrStateHistory03"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory03RelUpReg;

/**
 * The error message of 'ErrStateHistory03'
 */
typedef ::asf::cca::CcaTypes::DefaultError ErrStateHistory03Error;

/**
 * The set message of the property "ErrStateHistory04"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory04Set;

/**
 * The get message of the property "ErrStateHistory04"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory04Get;

/**
 * The upreg message of the property "ErrStateHistory04"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory04UpReg;

/**
 * The relUpReg message of the property "ErrStateHistory04"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory04RelUpReg;

/**
 * The error message of 'ErrStateHistory04'
 */
typedef ::asf::cca::CcaTypes::DefaultError ErrStateHistory04Error;

/**
 * The set message of the property "ErrStateHistory05"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory05Set;

/**
 * The get message of the property "ErrStateHistory05"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory05Get;

/**
 * The upreg message of the property "ErrStateHistory05"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory05UpReg;

/**
 * The relUpReg message of the property "ErrStateHistory05"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ErrStateHistory05RelUpReg;

/**
 * The error message of 'ErrStateHistory05'
 */
typedef ::asf::cca::CcaTypes::DefaultError ErrStateHistory05Error;

/**
 * The set message of the property "SwitchOnHistory"
 * List of ON reasons why target is switched on (display on).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwitchOnHistorySet;

/**
 * The get message of the property "SwitchOnHistory"
 * List of ON reasons why target is switched on (display on).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwitchOnHistoryGet;

/**
 * The upreg message of the property "SwitchOnHistory"
 * List of ON reasons why target is switched on (display on).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwitchOnHistoryUpReg;

/**
 * The relUpReg message of the property "SwitchOnHistory"
 * List of ON reasons why target is switched on (display on).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SwitchOnHistoryRelUpReg;

/**
 * The error message of 'SwitchOnHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError SwitchOnHistoryError;

/**
 * The result message of the method "ClearList"
 * Method to clear engineering date (All at once or a selected one).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearListResult;

/**
 * The abort error message of the method "ClearList"
 * Method to clear engineering date (All at once or a selected one).
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearListAbortError;

/**
 * The error message of 'ClearList'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearListError;

/**
 * The get message of the property "DeviceOnCounter"
 * <p>Counts how often the device was turned ON.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceOnCounterGet;

/**
 * The upreg message of the property "DeviceOnCounter"
 * <p>Counts how often the device was turned ON.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceOnCounterUpReg;

/**
 * The relUpReg message of the property "DeviceOnCounter"
 * <p>Counts how often the device was turned ON.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DeviceOnCounterRelUpReg;

/**
 * The error message of 'DeviceOnCounter'
 */
typedef ::asf::cca::CcaTypes::DefaultError DeviceOnCounterError;

/**
 * The get message of the property "VoltageEventCounter"
 * Counts system voltage events.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltageEventCounterGet;

/**
 * The upreg message of the property "VoltageEventCounter"
 * Counts system voltage events.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltageEventCounterUpReg;

/**
 * The relUpReg message of the property "VoltageEventCounter"
 * Counts system voltage events.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltageEventCounterRelUpReg;

/**
 * The error message of 'VoltageEventCounter'
 */
typedef ::asf::cca::CcaTypes::DefaultError VoltageEventCounterError;

/**
 * The get message of the property "VoltageRangeHistogram"
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltageRangeHistogramGet;

/**
 * The upreg message of the property "VoltageRangeHistogram"
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltageRangeHistogramUpReg;

/**
 * The relUpReg message of the property "VoltageRangeHistogram"
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VoltageRangeHistogramRelUpReg;

/**
 * The error message of 'VoltageRangeHistogram'
 */
typedef ::asf::cca::CcaTypes::DefaultError VoltageRangeHistogramError;

/**
 * The get message of the property "CpuUsageStatistic"
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).
 * The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CpuUsageStatisticGet;

/**
 * The upreg message of the property "CpuUsageStatistic"
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).
 * The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CpuUsageStatisticUpReg;

/**
 * The relUpReg message of the property "CpuUsageStatistic"
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).
 * The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CpuUsageStatisticRelUpReg;

/**
 * The error message of 'CpuUsageStatistic'
 */
typedef ::asf::cca::CcaTypes::DefaultError CpuUsageStatisticError;

/**
 * The get message of the property "RamUsageStatistic"
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).
 * The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RamUsageStatisticGet;

/**
 * The upreg message of the property "RamUsageStatistic"
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).
 * The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RamUsageStatisticUpReg;

/**
 * The relUpReg message of the property "RamUsageStatistic"
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).
 * The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RamUsageStatisticRelUpReg;

/**
 * The error message of 'RamUsageStatistic'
 */
typedef ::asf::cca::CcaTypes::DefaultError RamUsageStatisticError;

/**
 * The get message of the property "StartupTimeStatistic"
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.
 * The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupTimeStatisticGet;

/**
 * The upreg message of the property "StartupTimeStatistic"
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.
 * The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupTimeStatisticUpReg;

/**
 * The relUpReg message of the property "StartupTimeStatistic"
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.
 * The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupTimeStatisticRelUpReg;

/**
 * The error message of 'StartupTimeStatistic'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupTimeStatisticError;

/**
 * The get message of the property "SWVersionStatistic"
 * Get all SWVersion Statistic Data which was collected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SWVersionStatisticGet;

/**
 * The upreg message of the property "SWVersionStatistic"
 * Get all SWVersion Statistic Data which was collected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SWVersionStatisticUpReg;

/**
 * The relUpReg message of the property "SWVersionStatistic"
 * Get all SWVersion Statistic Data which was collected.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SWVersionStatisticRelUpReg;

/**
 * The error message of 'SWVersionStatistic'
 */
typedef ::asf::cca::CcaTypes::DefaultError SWVersionStatisticError;

/**
 * The abort error message of the method "SpecificSWVersionStatistic"
 * Method request a specific SWVersion Statistic Data  with the index from (0x00 - 0x13)
 */
typedef ::asf::cca::CcaTypes::DefaultError SpecificSWVersionStatisticAbortError;

/**
 * The error message of 'SpecificSWVersionStatistic'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpecificSWVersionStatisticError;

/**
 * The abort error message of the method "RestartSystem"
 * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartSystemAbortError;

/**
 * The error message of 'RestartSystem'
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartSystemError;

/**
 * The get message of the property "RunlevelState"
 * Informs about the current runlevel of the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RunlevelStateGet;

/**
 * The upreg message of the property "RunlevelState"
 * Informs about the current runlevel of the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RunlevelStateUpReg;

/**
 * The relUpReg message of the property "RunlevelState"
 * Informs about the current runlevel of the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RunlevelStateRelUpReg;

/**
 * The error message of 'RunlevelState'
 */
typedef ::asf::cca::CcaTypes::DefaultError RunlevelStateError;

/**
 * The get message of the property "Restart"
 * OBSOLETE do not use anymore, replaced by Method RestartSystem
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RestartGet;

/**
 * The upreg message of the property "Restart"
 * OBSOLETE do not use anymore, replaced by Method RestartSystem
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RestartUpReg;

/**
 * The relUpReg message of the property "Restart"
 * OBSOLETE do not use anymore, replaced by Method RestartSystem
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RestartRelUpReg;

/**
 * The error message of 'Restart'
 */
typedef ::asf::cca::CcaTypes::DefaultError RestartError;

/**
 * The get message of the property "Lifesign"
 * <p>This lifesign reflects the value received by the FC_SPMSLV.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LifesignGet;

/**
 * The upreg message of the property "Lifesign"
 * <p>This lifesign reflects the value received by the FC_SPMSLV.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LifesignUpReg;

/**
 * The relUpReg message of the property "Lifesign"
 * <p>This lifesign reflects the value received by the FC_SPMSLV.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage LifesignRelUpReg;

/**
 * The error message of 'Lifesign'
 */
typedef ::asf::cca::CcaTypes::DefaultError LifesignError;

/**
 * The get message of the property "HmiState"
 * Set substate of the HMI application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HmiStateGet;

/**
 * The upreg message of the property "HmiState"
 * Set substate of the HMI application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HmiStateUpReg;

/**
 * The relUpReg message of the property "HmiState"
 * Set substate of the HMI application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage HmiStateRelUpReg;

/**
 * The error message of 'HmiState'
 */
typedef ::asf::cca::CcaTypes::DefaultError HmiStateError;

/**
 * The get message of the property "SystemPowerBehaviour"
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemPowerBehaviourGet;

/**
 * The upreg message of the property "SystemPowerBehaviour"
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemPowerBehaviourUpReg;

/**
 * The relUpReg message of the property "SystemPowerBehaviour"
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SystemPowerBehaviourRelUpReg;

/**
 * The error message of 'SystemPowerBehaviour'
 */
typedef ::asf::cca::CcaTypes::DefaultError SystemPowerBehaviourError;

/**
 * The result message of the method "AudioSourceChange"
 * Method to trigger a source change by HMI. Used to change start configuration for next start-up.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioSourceChangeResult;

/**
 * The abort error message of the method "AudioSourceChange"
 * Method to trigger a source change by HMI. Used to change start configuration for next start-up.
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioSourceChangeAbortError;

/**
 * The error message of 'AudioSourceChange'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioSourceChangeError;

/**
 * The get message of the property "DimState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality.
 * Set substate of the DIMMING application.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DimStateGet;

/**
 * The upreg message of the property "DimState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality.
 * Set substate of the DIMMING application.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DimStateUpReg;

/**
 * The relUpReg message of the property "DimState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality.
 * Set substate of the DIMMING application.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DimStateRelUpReg;

/**
 * The error message of 'DimState'
 */
typedef ::asf::cca::CcaTypes::DefaultError DimStateError;

/**
 * The get message of the property "DimmingState"
 * Information about dimming states from LCM point of view for e.g. backlight.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DimmingStateGet;

/**
 * The upreg message of the property "DimmingState"
 * Information about dimming states from LCM point of view for e.g. backlight.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DimmingStateUpReg;

/**
 * The relUpReg message of the property "DimmingState"
 * Information about dimming states from LCM point of view for e.g. backlight.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DimmingStateRelUpReg;

/**
 * The error message of 'DimmingState'
 */
typedef ::asf::cca::CcaTypes::DefaultError DimmingStateError;

/**
 * The get message of the property "BluetoothState"
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothStateGet;

/**
 * The upreg message of the property "BluetoothState"
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothStateUpReg;

/**
 * The relUpReg message of the property "BluetoothState"
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage BluetoothStateRelUpReg;

/**
 * The error message of 'BluetoothState'
 */
typedef ::asf::cca::CcaTypes::DefaultError BluetoothStateError;

/**
 * The result message of the method "ChangeBluetoothState"
 * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeBluetoothStateResult;

/**
 * The abort error message of the method "ChangeBluetoothState"
 * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeBluetoothStateAbortError;

/**
 * The error message of 'ChangeBluetoothState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeBluetoothStateError;

/**
 * The get message of the property "AudioState"
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioStateGet;

/**
 * The upreg message of the property "AudioState"
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioStateUpReg;

/**
 * The relUpReg message of the property "AudioState"
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AudioStateRelUpReg;

/**
 * The error message of 'AudioState'
 */
typedef ::asf::cca::CcaTypes::DefaultError AudioStateError;

/**
 * The result message of the method "ChangeAudioState"
 * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeAudioStateResult;

/**
 * The abort error message of the method "ChangeAudioState"
 * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeAudioStateAbortError;

/**
 * The error message of 'ChangeAudioState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeAudioStateError;

/**
 * The get message of the property "SpiState"
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpiStateGet;

/**
 * The upreg message of the property "SpiState"
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpiStateUpReg;

/**
 * The relUpReg message of the property "SpiState"
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SpiStateRelUpReg;

/**
 * The error message of 'SpiState'
 */
typedef ::asf::cca::CcaTypes::DefaultError SpiStateError;

/**
 * The result message of the method "ChangeSpiState"
 * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeSpiStateResult;

/**
 * The abort error message of the method "ChangeSpiState"
 * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeSpiStateAbortError;

/**
 * The error message of 'ChangeSpiState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeSpiStateError;

/**
 * The get message of the property "TunerState"
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TunerStateGet;

/**
 * The upreg message of the property "TunerState"
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TunerStateUpReg;

/**
 * The relUpReg message of the property "TunerState"
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TunerStateRelUpReg;

/**
 * The error message of 'TunerState'
 */
typedef ::asf::cca::CcaTypes::DefaultError TunerStateError;

/**
 * The result message of the method "ChangeTunerState"
 * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeTunerStateResult;

/**
 * The abort error message of the method "ChangeTunerState"
 * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeTunerStateAbortError;

/**
 * The error message of 'ChangeTunerState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeTunerStateError;

/**
 * The get message of the property "WifiState"
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiStateGet;

/**
 * The upreg message of the property "WifiState"
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiStateUpReg;

/**
 * The relUpReg message of the property "WifiState"
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WifiStateRelUpReg;

/**
 * The error message of 'WifiState'
 */
typedef ::asf::cca::CcaTypes::DefaultError WifiStateError;

/**
 * The result message of the method "ChangeWifiState"
 * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ChangeWifiStateResult;

/**
 * The abort error message of the method "ChangeWifiState"
 * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeWifiStateAbortError;

/**
 * The error message of 'ChangeWifiState'
 */
typedef ::asf::cca::CcaTypes::DefaultError ChangeWifiStateError;

/**
 * The result message of the method "ShutdownAndTerminateCcaApps"
 * <p>Shutdown (request change to CCA application state AMT_C_U32_STATE_OFF) and terminate (send power message AMT_C_U16_PWR_PROXY_END_APP) all CCA applications which are defined by the passed list of application IDs.</p>
 * <p>After all CCA applications are terminated remove their related software blocks.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ShutdownAndTerminateCcaAppsResult;

/**
 * The abort error message of the method "ShutdownAndTerminateCcaApps"
 * <p>Shutdown (request change to CCA application state AMT_C_U32_STATE_OFF) and terminate (send power message AMT_C_U16_PWR_PROXY_END_APP) all CCA applications which are defined by the passed list of application IDs.</p>
 * <p>After all CCA applications are terminated remove their related software blocks.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError ShutdownAndTerminateCcaAppsAbortError;

/**
 * The error message of 'ShutdownAndTerminateCcaApps'
 */
typedef ::asf::cca::CcaTypes::DefaultError ShutdownAndTerminateCcaAppsError;

/**
 * The get message of the property "OnOffReason"
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon!
 * Set a new OnOff reason. New system state will be calculated.
 * FUNCID = FID_SPM_SUBSTATE,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnOffReasonGet;

/**
 * The upreg message of the property "OnOffReason"
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon!
 * Set a new OnOff reason. New system state will be calculated.
 * FUNCID = FID_SPM_SUBSTATE,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnOffReasonUpReg;

/**
 * The relUpReg message of the property "OnOffReason"
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon!
 * Set a new OnOff reason. New system state will be calculated.
 * FUNCID = FID_SPM_SUBSTATE,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD
 */
typedef ::asf::cca::CcaTypes::DefaultMessage OnOffReasonRelUpReg;

/**
 * The error message of 'OnOffReason'
 */
typedef ::asf::cca::CcaTypes::DefaultError OnOffReasonError;

/**
 * The get message of the property "WakeupList"
 * Get reset count.
 * FUNCID = FID_SPM_WAKEUP_LIST,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupListGet;

/**
 * The upreg message of the property "WakeupList"
 * Get reset count.
 * FUNCID = FID_SPM_WAKEUP_LIST,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupListUpReg;

/**
 * The relUpReg message of the property "WakeupList"
 * Get reset count.
 * FUNCID = FID_SPM_WAKEUP_LIST,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WakeupListRelUpReg;

/**
 * The error message of 'WakeupList'
 */
typedef ::asf::cca::CcaTypes::DefaultError WakeupListError;

/**
 * The get message of the property "StartupFinished"
 * FUNCID = FID_SPM_STARTUP_FINISHED,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_xx
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupFinishedGet;

/**
 * The upreg message of the property "StartupFinished"
 * FUNCID = FID_SPM_STARTUP_FINISHED,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_xx
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupFinishedUpReg;

/**
 * The relUpReg message of the property "StartupFinished"
 * FUNCID = FID_SPM_STARTUP_FINISHED,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_xx
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupFinishedRelUpReg;

/**
 * The error message of 'StartupFinished'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupFinishedError;

/**
 * The get message of the property "SysState"
 * Set substate of the HMI application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysStateGet;

/**
 * The upreg message of the property "SysState"
 * Set substate of the HMI application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysStateUpReg;

/**
 * The relUpReg message of the property "SysState"
 * Set substate of the HMI application.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SysStateRelUpReg;

/**
 * The error message of 'SysState'
 */
typedef ::asf::cca::CcaTypes::DefaultError SysStateError;

/**
 * The get message of the property "MostState"
 * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MostStateGet;

/**
 * The upreg message of the property "MostState"
 * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MostStateUpReg;

/**
 * The relUpReg message of the property "MostState"
 * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MostStateRelUpReg;

/**
 * The error message of 'MostState'
 */
typedef ::asf::cca::CcaTypes::DefaultError MostStateError;

/**
 * The get message of the property "MostVersion"
 * The MOST version of the MOST stack used in the system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MostVersionGet;

/**
 * The upreg message of the property "MostVersion"
 * The MOST version of the MOST stack used in the system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MostVersionUpReg;

/**
 * The relUpReg message of the property "MostVersion"
 * The MOST version of the MOST stack used in the system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage MostVersionRelUpReg;

/**
 * The error message of 'MostVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError MostVersionError;

/**
 * The get message of the property "RVCState"
 * Rear View Camera state of the system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCStateGet;

/**
 * The upreg message of the property "RVCState"
 * Rear View Camera state of the system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCStateUpReg;

/**
 * The relUpReg message of the property "RVCState"
 * Rear View Camera state of the system
 */
typedef ::asf::cca::CcaTypes::DefaultMessage RVCStateRelUpReg;

/**
 * The error message of 'RVCState'
 */
typedef ::asf::cca::CcaTypes::DefaultError RVCStateError;

/**
 * The set message of the property "TriggerMostRemoteReset"
 * <p>The property values goes to 1 to indicate that a MostRemoteReset trigger was sent to the Enhanced Test FBlock.
 * FC DIAGNOSIS can reset this value to 0 after having finished the action.</p>
 * This command resets the trigger to 0.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TriggerMostRemoteResetSet;

/**
 * The get message of the property "TriggerMostRemoteReset"
 * <p>The property values goes to 1 to indicate that a MostRemoteReset trigger was sent to the Enhanced Test FBlock.
 * FC DIAGNOSIS can reset this value to 0 after having finished the action.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TriggerMostRemoteResetGet;

/**
 * The upreg message of the property "TriggerMostRemoteReset"
 * <p>The property values goes to 1 to indicate that a MostRemoteReset trigger was sent to the Enhanced Test FBlock.
 * FC DIAGNOSIS can reset this value to 0 after having finished the action.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TriggerMostRemoteResetUpReg;

/**
 * The relUpReg message of the property "TriggerMostRemoteReset"
 * <p>The property values goes to 1 to indicate that a MostRemoteReset trigger was sent to the Enhanced Test FBlock.
 * FC DIAGNOSIS can reset this value to 0 after having finished the action.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TriggerMostRemoteResetRelUpReg;

/**
 * The error message of 'TriggerMostRemoteReset'
 */
typedef ::asf::cca::CcaTypes::DefaultError TriggerMostRemoteResetError;

/**
 * The upreg message of the property "Partnumber"
 * <p>The system consists of several sw and data parts which are always mapped uniquely to a partnumber
 * to have the possibility to identify the current version.
 * This fid provides functionality for setting a new number for a part or getting the current number
 * of a part.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartnumberUpReg;

/**
 * The relUpReg message of the property "Partnumber"
 * <p>The system consists of several sw and data parts which are always mapped uniquely to a partnumber
 * to have the possibility to identify the current version.
 * This fid provides functionality for setting a new number for a part or getting the current number
 * of a part.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartnumberRelUpReg;

/**
 * The error message of 'Partnumber'
 * If part is not found or partnumber could not be correctly written.
 */
typedef ::asf::cca::CcaTypes::DefaultError PartnumberError;

/**
 * The get message of the property "Partnumbers"
 * <p>Get all parts of the system and their partnumbers.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartnumbersGet;

/**
 * The upreg message of the property "Partnumbers"
 * <p>Get all parts of the system and their partnumbers.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartnumbersUpReg;

/**
 * The relUpReg message of the property "Partnumbers"
 * <p>Get all parts of the system and their partnumbers.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PartnumbersRelUpReg;

/**
 * The error message of 'Partnumbers'
 */
typedef ::asf::cca::CcaTypes::DefaultError PartnumbersError;

/**
 * The upreg message of the property "Alphacode"
 * <p>Set or get the alphacodes needed for diagnosis.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlphacodeUpReg;

/**
 * The relUpReg message of the property "Alphacode"
 * <p>Set or get the alphacodes needed for diagnosis.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlphacodeRelUpReg;

/**
 * The error message of 'Alphacode'
 * If part is not found or alphacode could not be correctly written.
 */
typedef ::asf::cca::CcaTypes::DefaultError AlphacodeError;

/**
 * The get message of the property "Alphacodes"
 * <p>Get all parts of the system and their alphacodes.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlphacodesGet;

/**
 * The upreg message of the property "Alphacodes"
 * <p>Get all parts of the system and their alphacodes.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlphacodesUpReg;

/**
 * The relUpReg message of the property "Alphacodes"
 * <p>Get all parts of the system and their alphacodes.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage AlphacodesRelUpReg;

/**
 * The error message of 'Alphacodes'
 */
typedef ::asf::cca::CcaTypes::DefaultError AlphacodesError;

/**
 * The abort error message of the method "SetFactorySettingsNew"
 * <p>This function request the component to set all Variables (depending on USER, TEF or OEM) to default</p>
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>Service ID - CCA_C_U16_SRV_SPM,</p>
 * <p>App ID - CCA_C_U16_APP_SPM</p>
 * <p>Function ID - MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new request if the process is still running. The Component itself must decide what to do. Normally the component itself have do decide if it has to re-trigger or wait for the last answer. Independent of that it has to confirm the new request.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsNewAbortError;

/**
 * The error message of 'SetFactorySettingsNew'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsNewError;

/**
 * The get message of the property "ManufacturersEnableCounter"
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).
 * Get message for the MEC value
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ManufacturersEnableCounterGet;

/**
 * The upreg message of the property "ManufacturersEnableCounter"
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ManufacturersEnableCounterUpReg;

/**
 * The relUpReg message of the property "ManufacturersEnableCounter"
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ManufacturersEnableCounterRelUpReg;

/**
 * The error message of 'ManufacturersEnableCounter'
 */
typedef ::asf::cca::CcaTypes::DefaultError ManufacturersEnableCounterError;

/**
 * The get message of the property "NoCalibrationState"
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS).
 * Get the current No Calibration state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NoCalibrationStateGet;

/**
 * The upreg message of the property "NoCalibrationState"
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NoCalibrationStateUpReg;

/**
 * The relUpReg message of the property "NoCalibrationState"
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage NoCalibrationStateRelUpReg;

/**
 * The error message of 'NoCalibrationState'
 */
typedef ::asf::cca::CcaTypes::DefaultError NoCalibrationStateError;

/**
 * The get message of the property "SecurityCommError"
 * Communication error count detected by SPM security component.
 * FUNCID = FID_SPM_SEC_COMM_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityCommErrorGet;

/**
 * The upreg message of the property "SecurityCommError"
 * Communication error count detected by SPM security component.
 * FUNCID = FID_SPM_SEC_COMM_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityCommErrorUpReg;

/**
 * The relUpReg message of the property "SecurityCommError"
 * Communication error count detected by SPM security component.
 * FUNCID = FID_SPM_SEC_COMM_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityCommErrorRelUpReg;

/**
 * The error message of 'SecurityCommError'
 */
typedef ::asf::cca::CcaTypes::DefaultError SecurityCommErrorError;

/**
 * The get message of the property "SecurityMoreThan10Vin"
 * More than 10 VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityMoreThan10VinGet;

/**
 * The upreg message of the property "SecurityMoreThan10Vin"
 * More than 10 VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityMoreThan10VinUpReg;

/**
 * The relUpReg message of the property "SecurityMoreThan10Vin"
 * More than 10 VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityMoreThan10VinRelUpReg;

/**
 * The error message of 'SecurityMoreThan10Vin'
 */
typedef ::asf::cca::CcaTypes::DefaultError SecurityMoreThan10VinError;

/**
 * The get message of the property "SecurityInvalidVin"
 * Number of invalid VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityInvalidVinGet;

/**
 * The upreg message of the property "SecurityInvalidVin"
 * Number of invalid VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityInvalidVinUpReg;

/**
 * The relUpReg message of the property "SecurityInvalidVin"
 * Number of invalid VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityInvalidVinRelUpReg;

/**
 * The error message of 'SecurityInvalidVin'
 */
typedef ::asf::cca::CcaTypes::DefaultError SecurityInvalidVinError;

/**
 * The get message of the property "SecurityCurrentVin"
 * Current VIN detected by SPM security component (17 bytes).
 * FUNCID = FID_SPM_SEC_CURRENT_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityCurrentVinGet;

/**
 * The upreg message of the property "SecurityCurrentVin"
 * Current VIN detected by SPM security component (17 bytes).
 * FUNCID = FID_SPM_SEC_CURRENT_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityCurrentVinUpReg;

/**
 * The relUpReg message of the property "SecurityCurrentVin"
 * Current VIN detected by SPM security component (17 bytes).
 * FUNCID = FID_SPM_SEC_CURRENT_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityCurrentVinRelUpReg;

/**
 * The error message of 'SecurityCurrentVin'
 */
typedef ::asf::cca::CcaTypes::DefaultError SecurityCurrentVinError;

/**
 * The get message of the property "SecurityVinHistory"
 * List of received VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_VIN_HISTORY,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityVinHistoryGet;

/**
 * The upreg message of the property "SecurityVinHistory"
 * List of received VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_VIN_HISTORY,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityVinHistoryUpReg;

/**
 * The relUpReg message of the property "SecurityVinHistory"
 * List of received VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_VIN_HISTORY,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityVinHistoryRelUpReg;

/**
 * The error message of 'SecurityVinHistory'
 */
typedef ::asf::cca::CcaTypes::DefaultError SecurityVinHistoryError;

/**
 * The start message of the method "ClearVIN"
 * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.
 * This method clears the internal manufacturersenablecounter if conditions are met otherwise an error result is returned.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ClearVINStart;

/**
 * The abort error message of the method "ClearVIN"
 * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearVINAbortError;

/**
 * The error message of 'ClearVIN'
 * An error occurred during calling the method. ClearVIN was not executed.
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearVINError;

/**
 * The get message of the property "VIN"
 * Vehicle Identification Number.
 * FUNCID = FID_SPM_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= ...
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VINGet;

/**
 * The upreg message of the property "VIN"
 * Vehicle Identification Number.
 * FUNCID = FID_SPM_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= ...
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VINUpReg;

/**
 * The relUpReg message of the property "VIN"
 * Vehicle Identification Number.
 * FUNCID = FID_SPM_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= ...
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VINRelUpReg;

/**
 * The error message of 'VIN'
 * If the vehicle identification number is not available then an error occurs.
 */
typedef ::asf::cca::CcaTypes::DefaultError VINError;

/**
 * The get message of the property "SecurityState"
 * The SPM tells registered clients the current security state of the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityStateGet;

/**
 * The upreg message of the property "SecurityState"
 * The SPM tells registered clients the current security state of the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityStateUpReg;

/**
 * The relUpReg message of the property "SecurityState"
 * The SPM tells registered clients the current security state of the system.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SecurityStateRelUpReg;

/**
 * The error message of 'SecurityState'
 */
typedef ::asf::cca::CcaTypes::DefaultError SecurityStateError;

/**
 * The get message of the property "VehicleID"
 * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleIDGet;

/**
 * The upreg message of the property "VehicleID"
 * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleIDUpReg;

/**
 * The relUpReg message of the property "VehicleID"
 * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage VehicleIDRelUpReg;

/**
 * The error message of 'VehicleID'
 */
typedef ::asf::cca::CcaTypes::DefaultError VehicleIDError;

/**
 * The get message of the property "DisplayVariant"
 * Sets the given display variant number in the datapool and performs a restart of the system.
 * FUNCID = FID_SPM_DISPLAY_VARIANT,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	=
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisplayVariantGet;

/**
 * The upreg message of the property "DisplayVariant"
 * Sets the given display variant number in the datapool and performs a restart of the system.
 * FUNCID = FID_SPM_DISPLAY_VARIANT,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	=
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisplayVariantUpReg;

/**
 * The relUpReg message of the property "DisplayVariant"
 * Sets the given display variant number in the datapool and performs a restart of the system.
 * FUNCID = FID_SPM_DISPLAY_VARIANT,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	=
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisplayVariantRelUpReg;

/**
 * The error message of 'DisplayVariant'
 */
typedef ::asf::cca::CcaTypes::DefaultError DisplayVariantError;

/**
 * The get message of the property "ReductionLevel"
 * The reduction level is used to tell components to provide normal operation or a reduced operation level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReductionLevelGet;

/**
 * The upreg message of the property "ReductionLevel"
 * The reduction level is used to tell components to provide normal operation or a reduced operation level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReductionLevelUpReg;

/**
 * The relUpReg message of the property "ReductionLevel"
 * The reduction level is used to tell components to provide normal operation or a reduced operation level.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ReductionLevelRelUpReg;

/**
 * The error message of 'ReductionLevel'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReductionLevelError;

/**
 * The abort error message of the method "PrepareDownload"
 * This function prepares the system for download. All components that are not needed are unloaded.
 * <p>FUNCID = FID_SPM_PREPARE_DOWNLOAD,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_SPM,</p>
 * <p>APPID = CCA_C_U16_APP_SPM,</p>
 * <p>TARGETID	= CCA_C_U16_APP_FC_DOWNLOAD</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError PrepareDownloadAbortError;

/**
 * The error message of 'PrepareDownload'
 */
typedef ::asf::cca::CcaTypes::DefaultError PrepareDownloadError;

/**
 * The start message of the method "EndDownload"
 * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.
 * <p>FUNCID = FID_SPM_END_DOWNLOAD,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_SPM,</p>
 * <p>APPID = CCA_C_U16_APP_SPM,</p>
 * <p>TARGETID	= CCA_C_U16_APP_FC_DOWNLOAD</p>
 * The method ends the DOWNLOAD state and goes back to a state according to environmental data.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EndDownloadStart;

/**
 * The abort error message of the method "EndDownload"
 * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.
 * <p>FUNCID = FID_SPM_END_DOWNLOAD,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_SPM,</p>
 * <p>APPID = CCA_C_U16_APP_SPM,</p>
 * <p>TARGETID	= CCA_C_U16_APP_FC_DOWNLOAD</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError EndDownloadAbortError;

/**
 * The error message of 'EndDownload'
 */
typedef ::asf::cca::CcaTypes::DefaultError EndDownloadError;

/**
 * The abort error message of the method "SetOnConfiguration"
 * <p>This function is used to prepare the correct application configuration for the NAVCOPY download. If end is needed then set
 * the configuration back to 0. Otherwise use the configuration numbers defined in the base.reg. See there for the possible
 * configurations available. If a configuration is not available then SPM switches on the default configuration which is always 0.</p>
 * <p>If the ON state is left and reentered again then the configuration is always set to 0.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetOnConfigurationAbortError;

/**
 * The error message of 'SetOnConfiguration'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetOnConfigurationError;

/**
 * The abort error message of the method "SetProcessConfiguration"
 * <p>This function is used to remove certain processes from the system. All components of this process are sent to OFF
 * before the enclosing process is ended to make sure that LMM data is stored to persistent memory.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProcessConfigurationAbortError;

/**
 * The error message of 'SetProcessConfiguration'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetProcessConfigurationError;

/**
 * The get message of the property "StartupState"
 * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupStateGet;

/**
 * The upreg message of the property "StartupState"
 * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupStateUpReg;

/**
 * The relUpReg message of the property "StartupState"
 * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".
 */
typedef ::asf::cca::CcaTypes::DefaultMessage StartupStateRelUpReg;

/**
 * The error message of 'StartupState'
 */
typedef ::asf::cca::CcaTypes::DefaultError StartupStateError;

/**
 * The get message of the property "EntertainMute"
 * NISSAN related mute handling. SPM handles Tipper and calculates MuteState.
 * HMI has to follow mute state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntertainMuteGet;

/**
 * The upreg message of the property "EntertainMute"
 * NISSAN related mute handling. SPM handles Tipper and calculates MuteState.
 * HMI has to follow mute state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntertainMuteUpReg;

/**
 * The relUpReg message of the property "EntertainMute"
 * NISSAN related mute handling. SPM handles Tipper and calculates MuteState.
 * HMI has to follow mute state.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntertainMuteRelUpReg;

/**
 * The error message of 'EntertainMute'
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainMuteError;

/**
 * The start message of the method "EntertainDeMute"
 * Method to trigger a demute by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntertainDeMuteStart;

/**
 * The abort error message of the method "EntertainDeMute"
 * Method to trigger a demute by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainDeMuteAbortError;

/**
 * The error message of 'EntertainDeMute'
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainDeMuteError;

/**
 * The start message of the method "EntertainMuteRequest"
 * Method to trigger a mute by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EntertainMuteRequestStart;

/**
 * The abort error message of the method "EntertainMuteRequest"
 * Method to trigger a mute by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainMuteRequestAbortError;

/**
 * The error message of 'EntertainMuteRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError EntertainMuteRequestError;

/**
 * The abort error message of the method "WelcomeAudioActivation"
 * Method to trigger a mute by HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError WelcomeAudioActivationAbortError;

/**
 * The error message of 'WelcomeAudioActivation'
 */
typedef ::asf::cca::CcaTypes::DefaultError WelcomeAudioActivationError;

/**
 * The get message of the property "WelcomeAudioState"
 * Welcome audio is currently enabled or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WelcomeAudioStateGet;

/**
 * The upreg message of the property "WelcomeAudioState"
 * Welcome audio is currently enabled or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WelcomeAudioStateUpReg;

/**
 * The relUpReg message of the property "WelcomeAudioState"
 * Welcome audio is currently enabled or not.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage WelcomeAudioStateRelUpReg;

/**
 * The error message of 'WelcomeAudioState'
 */
typedef ::asf::cca::CcaTypes::DefaultError WelcomeAudioStateError;

/**
 * The get message of the property "UnballastTimeFromEngineStopped"
 * Timer which starts when engine is not running before unballast.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastTimeFromEngineStoppedGet;

/**
 * The upreg message of the property "UnballastTimeFromEngineStopped"
 * Timer which starts when engine is not running before unballast.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastTimeFromEngineStoppedUpReg;

/**
 * The relUpReg message of the property "UnballastTimeFromEngineStopped"
 * Timer which starts when engine is not running before unballast.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastTimeFromEngineStoppedRelUpReg;

/**
 * The error message of 'UnballastTimeFromEngineStopped'
 */
typedef ::asf::cca::CcaTypes::DefaultError UnballastTimeFromEngineStoppedError;

/**
 * The get message of the property "UnballastTimeBeforeUnballast"
 * Time before unballast. Configuration parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastTimeBeforeUnballastGet;

/**
 * The upreg message of the property "UnballastTimeBeforeUnballast"
 * Time before unballast. Configuration parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastTimeBeforeUnballastUpReg;

/**
 * The relUpReg message of the property "UnballastTimeBeforeUnballast"
 * Time before unballast. Configuration parameter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastTimeBeforeUnballastRelUpReg;

/**
 * The error message of 'UnballastTimeBeforeUnballast'
 */
typedef ::asf::cca::CcaTypes::DefaultError UnballastTimeBeforeUnballastError;

/**
 * The get message of the property "UnballastWarningTime"
 * Time warning message is displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastWarningTimeGet;

/**
 * The upreg message of the property "UnballastWarningTime"
 * Time warning message is displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastWarningTimeUpReg;

/**
 * The relUpReg message of the property "UnballastWarningTime"
 * Time warning message is displayed.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage UnballastWarningTimeRelUpReg;

/**
 * The error message of 'UnballastWarningTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError UnballastWarningTimeError;

/**
 * The get message of the property "DegradedCount"
 * Number of Unballast trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DegradedCountGet;

/**
 * The upreg message of the property "DegradedCount"
 * Number of Unballast trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DegradedCountUpReg;

/**
 * The relUpReg message of the property "DegradedCount"
 * Number of Unballast trigger.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DegradedCountRelUpReg;

/**
 * The error message of 'DegradedCount'
 */
typedef ::asf::cca::CcaTypes::DefaultError DegradedCountError;

/**
 * The get message of the property "DegradedTime"
 * Accumulated time in Unballast situation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DegradedTimeGet;

/**
 * The upreg message of the property "DegradedTime"
 * Accumulated time in Unballast situation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DegradedTimeUpReg;

/**
 * The relUpReg message of the property "DegradedTime"
 * Accumulated time in Unballast situation.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DegradedTimeRelUpReg;

/**
 * The error message of 'DegradedTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError DegradedTimeError;

/**
 * The get message of the property "PhoneHandoverWarnTime"
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneHandoverWarnTimeGet;

/**
 * The upreg message of the property "PhoneHandoverWarnTime"
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneHandoverWarnTimeUpReg;

/**
 * The relUpReg message of the property "PhoneHandoverWarnTime"
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PhoneHandoverWarnTimeRelUpReg;

/**
 * The error message of 'PhoneHandoverWarnTime'
 */
typedef ::asf::cca::CcaTypes::DefaultError PhoneHandoverWarnTimeError;


/**
 * The status message of the property "SystemState"
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).
 */
class SystemStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateStatus ();

    /**
     * Copy constructor
     */
    inline  SystemStateStatus (const SystemStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateStatus (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES SystemState_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateStatus();

    /**
     * Assignment operator
     */
    inline SystemStateStatus& operator = (const SystemStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemState"

    static const int kSystemState = 0;

    /**
     * Clears the field "SystemState".
     *
     * The field will be set to its default value. The hasSystemState()
     * method will return false.
     */
    inline void clearSystemState();

    /**
     * Checks whether the field "SystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemState()). Otherwise it will return false.
     */
    inline bool hasSystemState () const;

    /**
     * Returns the value of the member "SystemState".
     *
     * Currently active/reached system state.
     *
     * @return The value of the field "SystemState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES getSystemState () const;

    /**
     * Sets the value of the member "SystemState".
     *
     * Currently active/reached system state.
     *
     * @param SystemState The value which will be set
     */
    inline void setSystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES SystemState_);

    static const SystemStateStatus &getDefaultInstance();

private:

    inline void set_has_SystemState ();

    inline void clear_has_SystemState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES _SystemState;

};

/**
 * The start message of the method "SystemMode"
 * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.
 */
class SystemModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemModeStart ();

    /**
     * Copy constructor
     */
    inline  SystemModeStart (const SystemModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  SystemModeStart (::spm_core_fi_types::T_e8_StateModes eSystemMode_);

    /**
     * Destructor
     */
    inline virtual  ~SystemModeStart();

    /**
     * Assignment operator
     */
    inline SystemModeStart& operator = (const SystemModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eSystemMode"

    static const int kESystemMode = 0;

    /**
     * Clears the field "eSystemMode".
     *
     * The field will be set to its default value. The hasESystemMode()
     * method will return false.
     */
    inline void clearESystemMode();

    /**
     * Checks whether the field "eSystemMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESystemMode()). Otherwise it will return false.
     */
    inline bool hasESystemMode () const;

    /**
     * Returns the value of the member "eSystemMode".
     *
     * If the meaning of "eSystemMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eSystemMode"
     */
    inline ::spm_core_fi_types::T_e8_StateModes getESystemMode () const;

    /**
     * Sets the value of the member "eSystemMode".
     *
     * If the meaning of "eSystemMode" isn't clear, then there should be a description here.
     *
     * @param eSystemMode The value which will be set
     */
    inline void setESystemMode (::spm_core_fi_types::T_e8_StateModes eSystemMode_);

    static const SystemModeStart &getDefaultInstance();

private:

    inline void set_has_eSystemMode ();

    inline void clear_has_eSystemMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_e8_StateModes _eSystemMode;

};

/**
 * The result message of the method "SystemMode"
 * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.
 */
class SystemModeResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemModeResult ();

    /**
     * Copy constructor
     */
    inline  SystemModeResult (const SystemModeResult &rhs);

    /**
     * All fields constructor
     */
    inline  SystemModeResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~SystemModeResult();

    /**
     * Assignment operator
     */
    inline SystemModeResult& operator = (const SystemModeResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemModeResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemModeResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemModeResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemModeResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const SystemModeResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The start message of the method "DownloadLockState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLock !!!
 * Method to lock specific resources for restricted downloads.
 */
class DownloadLockStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStateStart ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStateStart (const DownloadLockStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadLockStateStart (const ::std::string& strRestrictedDlState_, ::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStateStart();

    /**
     * Assignment operator
     */
    inline DownloadLockStateStart& operator = (const DownloadLockStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strRestrictedDlState"

    static const int kStrRestrictedDlState = 0;

    /**
     * Clears the field "strRestrictedDlState".
     *
     * The field will be set to its default value. The hasStrRestrictedDlState()
     * method will return false.
     */
    inline void clearStrRestrictedDlState();

    /**
     * Checks whether the field "strRestrictedDlState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrRestrictedDlState()). Otherwise it will return false.
     */
    inline bool hasStrRestrictedDlState () const;

    /**
     * Returns the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strRestrictedDlState"
     */
    inline const ::std::string& getStrRestrictedDlState () const;

    /**
     * Retrieves the value of the field "strRestrictedDlState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strRestrictedDlState".
     */
    inline ::std::string& getStrRestrictedDlStateMutable ();

    /**
     * Sets the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @param strRestrictedDlState The value which will be set
     */
    inline void setStrRestrictedDlState (const ::std::string& strRestrictedDlState_);

    /**
     * Sets the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @param strRestrictedDlState The value which will be set
     */
    inline void setStrRestrictedDlState (const char* strRestrictedDlState_);

    /**
     * Sets the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @param strRestrictedDlState The value which will be set
     */
    inline void setStrRestrictedDlState (const char* value, size_t size);

    /**
     * Release the object stored in the field "strRestrictedDlState".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strRestrictedDlState"
     */
    inline ::std::string* releaseStrRestrictedDlState();

    /**
     * Replace the field "strRestrictedDlState".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrRestrictedDlState (::std::string* strRestrictedDlState_);

    // API of field "eRestrictedDlMode"

    static const int kERestrictedDlMode = 1;

    /**
     * Clears the field "eRestrictedDlMode".
     *
     * The field will be set to its default value. The hasERestrictedDlMode()
     * method will return false.
     */
    inline void clearERestrictedDlMode();

    /**
     * Checks whether the field "eRestrictedDlMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERestrictedDlMode()). Otherwise it will return false.
     */
    inline bool hasERestrictedDlMode () const;

    /**
     * Returns the value of the member "eRestrictedDlMode".
     *
     * If the meaning of "eRestrictedDlMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eRestrictedDlMode"
     */
    inline ::spm_core_fi_types::T_e8_DownloadLockStates getERestrictedDlMode () const;

    /**
     * Sets the value of the member "eRestrictedDlMode".
     *
     * If the meaning of "eRestrictedDlMode" isn't clear, then there should be a description here.
     *
     * @param eRestrictedDlMode The value which will be set
     */
    inline void setERestrictedDlMode (::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode_);

    static const DownloadLockStateStart &getDefaultInstance();

private:

    inline void set_has_strRestrictedDlState ();

    inline void clear_has_strRestrictedDlState ();

    inline void set_has_eRestrictedDlMode ();

    inline void clear_has_eRestrictedDlMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _strRestrictedDlState;

    ::spm_core_fi_types::T_e8_DownloadLockStates _eRestrictedDlMode;

};

/**
 * The result message of the method "DownloadLockState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLock !!!
 * Method to lock specific resources for restricted downloads.
 */
class DownloadLockStateResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStateResult ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStateResult (const DownloadLockStateResult &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadLockStateResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStateResult();

    /**
     * Assignment operator
     */
    inline DownloadLockStateResult& operator = (const DownloadLockStateResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStateResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStateResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStateResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStateResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const DownloadLockStateResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The status message of the property "DownloadLockStates"
 * !!! OBSOLETE DO NOT USE ANYMORE !!!
 * !!! replaced by UpdateLockStates !!!
 * Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
class DownloadLockStatesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStatesStatus ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStatesStatus (const DownloadLockStatesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadLockStatesStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& listRestrictedLock_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStatesStatus();

    /**
     * Assignment operator
     */
    inline DownloadLockStatesStatus& operator = (const DownloadLockStatesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStatesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStatesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStatesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStatesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "listRestrictedLock"

    static const int kListRestrictedLock = 0;

    /**
     * Clears the field "listRestrictedLock".
     *
     * The field will be set to its default value. The hasListRestrictedLock()
     * method will return false.
     */
    inline void clearListRestrictedLock();

    /**
     * Checks whether the field "listRestrictedLock" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListRestrictedLock()). Otherwise it will return false.
     */
    inline bool hasListRestrictedLock () const;

    /**
     * Returns the value of the member "listRestrictedLock".
     *
     * List of all restricted lock areas.
     *
     * @return The value of the field "listRestrictedLock"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& getListRestrictedLock () const;

    /**
     * Retrieves the value of the field "listRestrictedLock" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listRestrictedLock".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& getListRestrictedLockMutable ();

    /**
     * Sets the value of the member "listRestrictedLock".
     *
     * List of all restricted lock areas.
     *
     * @param listRestrictedLock The value which will be set
     */
    inline void setListRestrictedLock (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& listRestrictedLock_);

    /**
     * Release the object stored in the field "listRestrictedLock".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "listRestrictedLock"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >* releaseListRestrictedLock();

    /**
     * Replace the field "listRestrictedLock".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceListRestrictedLock (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >* listRestrictedLock_);

    static const DownloadLockStatesStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& getT_SPM_RestrictedDlLockPointerList_DefaultInstance ();

    inline void set_has_listRestrictedLock ();

    inline void clear_has_listRestrictedLock ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >* _listRestrictedLock;

};

/**
 * The start message of the method "UpdateLock"
 * Method to modify a lock.
 * Not existing locks will be created.
 * Locks that are no longer owned nor used will be deleted.
 * Owner and state of a lock will be stored persistently
 */
class UpdateLockStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockStart ();

    /**
     * Copy constructor
     */
    inline  UpdateLockStart (const UpdateLockStart &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateLockStart (const ::std::string& strLockName_, ::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockStart();

    /**
     * Assignment operator
     */
    inline UpdateLockStart& operator = (const UpdateLockStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLockName"

    static const int kStrLockName = 0;

    /**
     * Clears the field "strLockName".
     *
     * The field will be set to its default value. The hasStrLockName()
     * method will return false.
     */
    inline void clearStrLockName();

    /**
     * Checks whether the field "strLockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLockName()). Otherwise it will return false.
     */
    inline bool hasStrLockName () const;

    /**
     * Returns the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLockName"
     */
    inline const ::std::string& getStrLockName () const;

    /**
     * Retrieves the value of the field "strLockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLockName".
     */
    inline ::std::string& getStrLockNameMutable ();

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const ::std::string& strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* value, size_t size);

    /**
     * Release the object stored in the field "strLockName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strLockName"
     */
    inline ::std::string* releaseStrLockName();

    /**
     * Replace the field "strLockName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrLockName (::std::string* strLockName_);

    // API of field "eLockRequest"

    static const int kELockRequest = 1;

    /**
     * Clears the field "eLockRequest".
     *
     * The field will be set to its default value. The hasELockRequest()
     * method will return false.
     */
    inline void clearELockRequest();

    /**
     * Checks whether the field "eLockRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setELockRequest()). Otherwise it will return false.
     */
    inline bool hasELockRequest () const;

    /**
     * Returns the value of the member "eLockRequest".
     *
     * If the meaning of "eLockRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eLockRequest"
     */
    inline ::spm_core_fi_types::T_e8_UpdateLockCommand getELockRequest () const;

    /**
     * Sets the value of the member "eLockRequest".
     *
     * If the meaning of "eLockRequest" isn't clear, then there should be a description here.
     *
     * @param eLockRequest The value which will be set
     */
    inline void setELockRequest (::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest_);

    static const UpdateLockStart &getDefaultInstance();

private:

    inline void set_has_strLockName ();

    inline void clear_has_strLockName ();

    inline void set_has_eLockRequest ();

    inline void clear_has_eLockRequest ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _strLockName;

    ::spm_core_fi_types::T_e8_UpdateLockCommand _eLockRequest;

};

/**
 * The result message of the method "UpdateLock"
 * Method to modify a lock.
 * Not existing locks will be created.
 * Locks that are no longer owned nor used will be deleted.
 * Owner and state of a lock will be stored persistently
 */
class UpdateLockResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockResult ();

    /**
     * Copy constructor
     */
    inline  UpdateLockResult (const UpdateLockResult &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateLockResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockResult();

    /**
     * Assignment operator
     */
    inline UpdateLockResult& operator = (const UpdateLockResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const UpdateLockResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The status message of the property "UpdateLockStates"
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area
 * or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
class UpdateLockStatesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockStatesStatus ();

    /**
     * Copy constructor
     */
    inline  UpdateLockStatesStatus (const UpdateLockStatesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateLockStatesStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& lLocks_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockStatesStatus();

    /**
     * Assignment operator
     */
    inline UpdateLockStatesStatus& operator = (const UpdateLockStatesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockStatesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockStatesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockStatesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockStatesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "lLocks"

    static const int kLLocks = 0;

    /**
     * Clears the field "lLocks".
     *
     * The field will be set to its default value. The hasLLocks()
     * method will return false.
     */
    inline void clearLLocks();

    /**
     * Checks whether the field "lLocks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLLocks()). Otherwise it will return false.
     */
    inline bool hasLLocks () const;

    /**
     * Returns the value of the member "lLocks".
     *
     * List of all restricted locks.
     * if lock the is neither owned nor used will be deleted from list.
     *
     * @return The value of the field "lLocks"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& getLLocks () const;

    /**
     * Retrieves the value of the field "lLocks" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "lLocks".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& getLLocksMutable ();

    /**
     * Sets the value of the member "lLocks".
     *
     * List of all restricted locks.
     * if lock the is neither owned nor used will be deleted from list.
     *
     * @param lLocks The value which will be set
     */
    inline void setLLocks (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& lLocks_);

    /**
     * Release the object stored in the field "lLocks".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "lLocks"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >* releaseLLocks();

    /**
     * Replace the field "lLocks".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceLLocks (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >* lLocks_);

    static const UpdateLockStatesStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& getT_SPM_UpdateLockStatePointerList_DefaultInstance ();

    inline void set_has_lLocks ();

    inline void clear_has_lLocks ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >* _lLocks;

};

/**
 * The start message of the method "OnOffTrigger"
 * Set a new OnOff reason. A new system state will be calculated.
 */
class OnOffTriggerStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffTriggerStart ();

    /**
     * Copy constructor
     */
    inline  OnOffTriggerStart (const OnOffTriggerStart &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffTriggerStart (::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger_, bool bState_);

    /**
     * Destructor
     */
    inline virtual  ~OnOffTriggerStart();

    /**
     * Assignment operator
     */
    inline OnOffTriggerStart& operator = (const OnOffTriggerStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffTriggerStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffTriggerStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffTriggerStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffTriggerStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eSwitchOnTrigger"

    static const int kESwitchOnTrigger = 0;

    /**
     * Clears the field "eSwitchOnTrigger".
     *
     * The field will be set to its default value. The hasESwitchOnTrigger()
     * method will return false.
     */
    inline void clearESwitchOnTrigger();

    /**
     * Checks whether the field "eSwitchOnTrigger" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESwitchOnTrigger()). Otherwise it will return false.
     */
    inline bool hasESwitchOnTrigger () const;

    /**
     * Returns the value of the member "eSwitchOnTrigger".
     *
     * Set new OnOff reasons.
     *
     * @return The value of the field "eSwitchOnTrigger"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SubStateType getESwitchOnTrigger () const;

    /**
     * Sets the value of the member "eSwitchOnTrigger".
     *
     * Set new OnOff reasons.
     *
     * @param eSwitchOnTrigger The value which will be set
     */
    inline void setESwitchOnTrigger (::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger_);

    // API of field "bState"

    static const int kBState = 1;

    /**
     * Clears the field "bState".
     *
     * The field will be set to its default value. The hasBState()
     * method will return false.
     */
    inline void clearBState();

    /**
     * Checks whether the field "bState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBState()). Otherwise it will return false.
     */
    inline bool hasBState () const;

    /**
     * Returns the value of the member "bState".
     *
     * Set or release requested OnOff reason.
     *
     * @return The value of the field "bState"
     */
    inline bool getBState () const;

    /**
     * Sets the value of the member "bState".
     *
     * Set or release requested OnOff reason.
     *
     * @param bState The value which will be set
     */
    inline void setBState (bool bState_);

    static const OnOffTriggerStart &getDefaultInstance();

private:

    inline void set_has_eSwitchOnTrigger ();

    inline void clear_has_eSwitchOnTrigger ();

    inline void set_has_bState ();

    inline void clear_has_bState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SubStateType _eSwitchOnTrigger;

    bool _bState;

};

/**
 * The status message of the property "ActiveOnOffTrigger"
 * A list of all active trigger.
 */
class ActiveOnOffTriggerStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveOnOffTriggerStatus ();

    /**
     * Copy constructor
     */
    inline  ActiveOnOffTriggerStatus (const ActiveOnOffTriggerStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveOnOffTriggerStatus (const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& tOnOffTriggerList_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveOnOffTriggerStatus();

    /**
     * Assignment operator
     */
    inline ActiveOnOffTriggerStatus& operator = (const ActiveOnOffTriggerStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveOnOffTriggerStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveOnOffTriggerStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveOnOffTriggerStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveOnOffTriggerStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tOnOffTriggerList"

    static const int kTOnOffTriggerList = 0;

    /**
     * Clears the field "tOnOffTriggerList".
     *
     * The field will be set to its default value. The hasTOnOffTriggerList()
     * method will return false.
     */
    inline void clearTOnOffTriggerList();

    /**
     * Checks whether the field "tOnOffTriggerList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTOnOffTriggerList()). Otherwise it will return false.
     */
    inline bool hasTOnOffTriggerList () const;

    /**
     * Returns the value of the member "tOnOffTriggerList".
     *
     * List of all active trigger.
     *
     * @return The value of the field "tOnOffTriggerList"
     */
    inline const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& getTOnOffTriggerList () const;

    /**
     * Retrieves the value of the field "tOnOffTriggerList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tOnOffTriggerList".
     */
    inline ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& getTOnOffTriggerListMutable ();

    /**
     * Sets the value of the member "tOnOffTriggerList".
     *
     * List of all active trigger.
     *
     * @param tOnOffTriggerList The value which will be set
     */
    inline void setTOnOffTriggerList (const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& tOnOffTriggerList_);

    /**
     * Release the object stored in the field "tOnOffTriggerList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tOnOffTriggerList"
     */
    inline ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >* releaseTOnOffTriggerList();

    /**
     * Replace the field "tOnOffTriggerList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTOnOffTriggerList (::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >* tOnOffTriggerList_);

    static const ActiveOnOffTriggerStatus &getDefaultInstance();

private:

    static const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& getT_SPM_e32_SubStateTypeList_DefaultInstance ();

    inline void set_has_tOnOffTriggerList ();

    inline void clear_has_tOnOffTriggerList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >* _tOnOffTriggerList;

};

/**
 * The status message of the property "SubStates"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use method "OnOffTrigger (0x100f)" to trigger new on/off reasons.</p>
 * <p>-- Use property "ActiveOnOffTrigger (0x110f)" to get active trigger. Even better: For detailed information about trigger e.g. ignition key, OnTipper, eject, ... use the corresponding properties.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Set a new OnOff reason. New system state will be calculated.</p>
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>No update will be send. Use property "ActiveOnOffTrigger (0x110f)" to be informed about On/off trigger changes.</p>
 * <p>Even better: For detailed information about trigger e.g. ignition key, OnTipper, eject, ... use the corresponding properties.</p>
 */
class SubStatesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubStatesStatus ();

    /**
     * Copy constructor
     */
    inline  SubStatesStatus (const SubStatesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SubStatesStatus (uint32 SubState_, uint32 HwSubState_, uint32 InternSubState_);

    /**
     * Destructor
     */
    inline virtual  ~SubStatesStatus();

    /**
     * Assignment operator
     */
    inline SubStatesStatus& operator = (const SubStatesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubStatesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubStatesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubStatesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubStatesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubState"

    static const int kSubState = 0;

    /**
     * Clears the field "SubState".
     *
     * The field will be set to its default value. The hasSubState()
     * method will return false.
     */
    inline void clearSubState();

    /**
     * Checks whether the field "SubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubState()). Otherwise it will return false.
     */
    inline bool hasSubState () const;

    /**
     * Returns the value of the member "SubState".
     *
     * If the meaning of "SubState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SubState"
     */
    inline uint32 getSubState () const;

    /**
     * Sets the value of the member "SubState".
     *
     * If the meaning of "SubState" isn't clear, then there should be a description here.
     *
     * @param SubState The value which will be set
     */
    inline void setSubState (uint32 SubState_);

    // API of field "HwSubState"

    static const int kHwSubState = 1;

    /**
     * Clears the field "HwSubState".
     *
     * The field will be set to its default value. The hasHwSubState()
     * method will return false.
     */
    inline void clearHwSubState();

    /**
     * Checks whether the field "HwSubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHwSubState()). Otherwise it will return false.
     */
    inline bool hasHwSubState () const;

    /**
     * Returns the value of the member "HwSubState".
     *
     * If the meaning of "HwSubState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HwSubState"
     */
    inline uint32 getHwSubState () const;

    /**
     * Sets the value of the member "HwSubState".
     *
     * If the meaning of "HwSubState" isn't clear, then there should be a description here.
     *
     * @param HwSubState The value which will be set
     */
    inline void setHwSubState (uint32 HwSubState_);

    // API of field "InternSubState"

    static const int kInternSubState = 2;

    /**
     * Clears the field "InternSubState".
     *
     * The field will be set to its default value. The hasInternSubState()
     * method will return false.
     */
    inline void clearInternSubState();

    /**
     * Checks whether the field "InternSubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInternSubState()). Otherwise it will return false.
     */
    inline bool hasInternSubState () const;

    /**
     * Returns the value of the member "InternSubState".
     *
     * If the meaning of "InternSubState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "InternSubState"
     */
    inline uint32 getInternSubState () const;

    /**
     * Sets the value of the member "InternSubState".
     *
     * If the meaning of "InternSubState" isn't clear, then there should be a description here.
     *
     * @param InternSubState The value which will be set
     */
    inline void setInternSubState (uint32 InternSubState_);

    static const SubStatesStatus &getDefaultInstance();

private:

    inline void set_has_SubState ();

    inline void clear_has_SubState ();

    inline void set_has_HwSubState ();

    inline void clear_has_HwSubState ();

    inline void set_has_InternSubState ();

    inline void clear_has_InternSubState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _SubState;

    uint32 _HwSubState;

    uint32 _InternSubState;

};

/**
 * The set message of the property "SubStates"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use method "OnOffTrigger (0x100f)" to trigger new on/off reasons.</p>
 * <p>-- Use property "ActiveOnOffTrigger (0x110f)" to get active trigger. Even better: For detailed information about trigger e.g. ignition key, OnTipper, eject, ... use the corresponding properties.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Set a new OnOff reason. New system state will be calculated.</p>
 */
class SubStatesSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubStatesSet ();

    /**
     * Copy constructor
     */
    inline  SubStatesSet (const SubStatesSet &rhs);

    /**
     * All fields constructor
     */
    inline  SubStatesSet (::spm_core_fi_types::T_SPM_e32_SubStateType SubStateType_, bool SubStateData_);

    /**
     * Destructor
     */
    inline virtual  ~SubStatesSet();

    /**
     * Assignment operator
     */
    inline SubStatesSet& operator = (const SubStatesSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubStatesSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubStatesSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubStatesSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubStatesSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubStateType"

    static const int kSubStateType = 0;

    /**
     * Clears the field "SubStateType".
     *
     * The field will be set to its default value. The hasSubStateType()
     * method will return false.
     */
    inline void clearSubStateType();

    /**
     * Checks whether the field "SubStateType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubStateType()). Otherwise it will return false.
     */
    inline bool hasSubStateType () const;

    /**
     * Returns the value of the member "SubStateType".
     *
     * Set new OnOff reasons.
     *
     * @return The value of the field "SubStateType"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SubStateType getSubStateType () const;

    /**
     * Sets the value of the member "SubStateType".
     *
     * Set new OnOff reasons.
     *
     * @param SubStateType The value which will be set
     */
    inline void setSubStateType (::spm_core_fi_types::T_SPM_e32_SubStateType SubStateType_);

    // API of field "SubStateData"

    static const int kSubStateData = 1;

    /**
     * Clears the field "SubStateData".
     *
     * The field will be set to its default value. The hasSubStateData()
     * method will return false.
     */
    inline void clearSubStateData();

    /**
     * Checks whether the field "SubStateData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubStateData()). Otherwise it will return false.
     */
    inline bool hasSubStateData () const;

    /**
     * Returns the value of the member "SubStateData".
     *
     * Set or release substate for requested substate.
     *
     * @return The value of the field "SubStateData"
     */
    inline bool getSubStateData () const;

    /**
     * Sets the value of the member "SubStateData".
     *
     * Set or release substate for requested substate.
     *
     * @param SubStateData The value which will be set
     */
    inline void setSubStateData (bool SubStateData_);

    static const SubStatesSet &getDefaultInstance();

private:

    inline void set_has_SubStateType ();

    inline void clear_has_SubStateType ();

    inline void set_has_SubStateData ();

    inline void clear_has_SubStateData ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SubStateType _SubStateType;

    bool _SubStateData;

};

/**
 * The status message of the property "HistoryTrigger"
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list.
 */
class HistoryTriggerStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HistoryTriggerStatus ();

    /**
     * Copy constructor
     */
    inline  HistoryTriggerStatus (const HistoryTriggerStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HistoryTriggerStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& tTriggeredStates_);

    /**
     * Destructor
     */
    inline virtual  ~HistoryTriggerStatus();

    /**
     * Assignment operator
     */
    inline HistoryTriggerStatus& operator = (const HistoryTriggerStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HistoryTriggerStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HistoryTriggerStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HistoryTriggerStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HistoryTriggerStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tTriggeredStates"

    static const int kTTriggeredStates = 0;

    /**
     * Clears the field "tTriggeredStates".
     *
     * The field will be set to its default value. The hasTTriggeredStates()
     * method will return false.
     */
    inline void clearTTriggeredStates();

    /**
     * Checks whether the field "tTriggeredStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTriggeredStates()). Otherwise it will return false.
     */
    inline bool hasTTriggeredStates () const;

    /**
     * Returns the value of the member "tTriggeredStates".
     *
     * List of triggered states while runtime.
     *
     * @return The value of the field "tTriggeredStates"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& getTTriggeredStates () const;

    /**
     * Retrieves the value of the field "tTriggeredStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tTriggeredStates".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& getTTriggeredStatesMutable ();

    /**
     * Sets the value of the member "tTriggeredStates".
     *
     * List of triggered states while runtime.
     *
     * @param tTriggeredStates The value which will be set
     */
    inline void setTTriggeredStates (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& tTriggeredStates_);

    /**
     * Release the object stored in the field "tTriggeredStates".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tTriggeredStates"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >* releaseTTriggeredStates();

    /**
     * Replace the field "tTriggeredStates".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTTriggeredStates (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >* tTriggeredStates_);

    static const HistoryTriggerStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& getT_SPM_HistoryTriggerPointerList_DefaultInstance ();

    inline void set_has_tTriggeredStates ();

    inline void clear_has_tTriggeredStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >* _tTriggeredStates;

};

/**
 * The status message of the property "InsertState"
 * Insert key state.
 */
class InsertStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InsertStateStatus ();

    /**
     * Copy constructor
     */
    inline  InsertStateStatus (const InsertStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  InsertStateStatus (::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE InsertState_);

    /**
     * Destructor
     */
    inline virtual  ~InsertStateStatus();

    /**
     * Assignment operator
     */
    inline InsertStateStatus& operator = (const InsertStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InsertStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InsertStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InsertStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InsertStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InsertState"

    static const int kInsertState = 0;

    /**
     * Clears the field "InsertState".
     *
     * The field will be set to its default value. The hasInsertState()
     * method will return false.
     */
    inline void clearInsertState();

    /**
     * Checks whether the field "InsertState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInsertState()). Otherwise it will return false.
     */
    inline bool hasInsertState () const;

    /**
     * Returns the value of the member "InsertState".
     *
     * State of the insert key.
     *
     * @return The value of the field "InsertState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE getInsertState () const;

    /**
     * Sets the value of the member "InsertState".
     *
     * State of the insert key.
     *
     * @param InsertState The value which will be set
     */
    inline void setInsertState (::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE InsertState_);

    static const InsertStateStatus &getDefaultInstance();

private:

    inline void set_has_InsertState ();

    inline void clear_has_InsertState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE _InsertState;

};

/**
 * The status message of the property "MediaEjectState"
 * Media Eject key state.
 */
class MediaEjectStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaEjectStateStatus ();

    /**
     * Copy constructor
     */
    inline  MediaEjectStateStatus (const MediaEjectStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MediaEjectStateStatus (::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE MediaEjectState_);

    /**
     * Destructor
     */
    inline virtual  ~MediaEjectStateStatus();

    /**
     * Assignment operator
     */
    inline MediaEjectStateStatus& operator = (const MediaEjectStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaEjectStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaEjectStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaEjectStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaEjectStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaEjectState"

    static const int kMediaEjectState = 0;

    /**
     * Clears the field "MediaEjectState".
     *
     * The field will be set to its default value. The hasMediaEjectState()
     * method will return false.
     */
    inline void clearMediaEjectState();

    /**
     * Checks whether the field "MediaEjectState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaEjectState()). Otherwise it will return false.
     */
    inline bool hasMediaEjectState () const;

    /**
     * Returns the value of the member "MediaEjectState".
     *
     * State of the eject key.
     *
     * @return The value of the field "MediaEjectState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE getMediaEjectState () const;

    /**
     * Sets the value of the member "MediaEjectState".
     *
     * State of the eject key.
     *
     * @param MediaEjectState The value which will be set
     */
    inline void setMediaEjectState (::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE MediaEjectState_);

    static const MediaEjectStateStatus &getDefaultInstance();

private:

    inline void set_has_MediaEjectState ();

    inline void clear_has_MediaEjectState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE _MediaEjectState;

};

/**
 * The status message of the property "PhoneMuteState"
 * State of the hard-wired phone line.
 */
class PhoneMuteStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneMuteStateStatus ();

    /**
     * Copy constructor
     */
    inline  PhoneMuteStateStatus (const PhoneMuteStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneMuteStateStatus (::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE PhoneMuteState_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneMuteStateStatus();

    /**
     * Assignment operator
     */
    inline PhoneMuteStateStatus& operator = (const PhoneMuteStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneMuteStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneMuteStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneMuteStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneMuteStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneMuteState"

    static const int kPhoneMuteState = 0;

    /**
     * Clears the field "PhoneMuteState".
     *
     * The field will be set to its default value. The hasPhoneMuteState()
     * method will return false.
     */
    inline void clearPhoneMuteState();

    /**
     * Checks whether the field "PhoneMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneMuteState()). Otherwise it will return false.
     */
    inline bool hasPhoneMuteState () const;

    /**
     * Returns the value of the member "PhoneMuteState".
     *
     * State of the hard-wired phone line.
     *
     * @return The value of the field "PhoneMuteState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE getPhoneMuteState () const;

    /**
     * Sets the value of the member "PhoneMuteState".
     *
     * State of the hard-wired phone line.
     *
     * @param PhoneMuteState The value which will be set
     */
    inline void setPhoneMuteState (::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE PhoneMuteState_);

    static const PhoneMuteStateStatus &getDefaultInstance();

private:

    inline void set_has_PhoneMuteState ();

    inline void clear_has_PhoneMuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE _PhoneMuteState;

};

/**
 * The status message of the property "OnTipperState"
 * Media Eject key state.
 */
class OnTipperStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnTipperStateStatus ();

    /**
     * Copy constructor
     */
    inline  OnTipperStateStatus (const OnTipperStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  OnTipperStateStatus (::spm_core_fi_types::T_SPM_e32_KEY_STATE OnTipperState_);

    /**
     * Destructor
     */
    inline virtual  ~OnTipperStateStatus();

    /**
     * Assignment operator
     */
    inline OnTipperStateStatus& operator = (const OnTipperStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnTipperStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnTipperStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnTipperStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnTipperStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnTipperState"

    static const int kOnTipperState = 0;

    /**
     * Clears the field "OnTipperState".
     *
     * The field will be set to its default value. The hasOnTipperState()
     * method will return false.
     */
    inline void clearOnTipperState();

    /**
     * Checks whether the field "OnTipperState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnTipperState()). Otherwise it will return false.
     */
    inline bool hasOnTipperState () const;

    /**
     * Returns the value of the member "OnTipperState".
     *
     * State of the OnTipper key.
     *
     * @return The value of the field "OnTipperState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_KEY_STATE getOnTipperState () const;

    /**
     * Sets the value of the member "OnTipperState".
     *
     * State of the OnTipper key.
     *
     * @param OnTipperState The value which will be set
     */
    inline void setOnTipperState (::spm_core_fi_types::T_SPM_e32_KEY_STATE OnTipperState_);

    static const OnTipperStateStatus &getDefaultInstance();

private:

    inline void set_has_OnTipperState ();

    inline void clear_has_OnTipperState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_KEY_STATE _OnTipperState;

};

/**
 * The status message of the property "IgnitionCycles"
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen.
 */
class IgnitionCyclesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionCyclesStatus ();

    /**
     * Copy constructor
     */
    inline  IgnitionCyclesStatus (const IgnitionCyclesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IgnitionCyclesStatus (uint32 IgnitionCycle_);

    /**
     * Destructor
     */
    inline virtual  ~IgnitionCyclesStatus();

    /**
     * Assignment operator
     */
    inline IgnitionCyclesStatus& operator = (const IgnitionCyclesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionCyclesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionCyclesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionCyclesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionCyclesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnitionCycle"

    static const int kIgnitionCycle = 0;

    /**
     * Clears the field "IgnitionCycle".
     *
     * The field will be set to its default value. The hasIgnitionCycle()
     * method will return false.
     */
    inline void clearIgnitionCycle();

    /**
     * Checks whether the field "IgnitionCycle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnitionCycle()). Otherwise it will return false.
     */
    inline bool hasIgnitionCycle () const;

    /**
     * Returns the value of the member "IgnitionCycle".
     *
     * Current number of ignition cycles.
     *
     * @return The value of the field "IgnitionCycle"
     */
    inline uint32 getIgnitionCycle () const;

    /**
     * Sets the value of the member "IgnitionCycle".
     *
     * Current number of ignition cycles.
     *
     * @param IgnitionCycle The value which will be set
     */
    inline void setIgnitionCycle (uint32 IgnitionCycle_);

    static const IgnitionCyclesStatus &getDefaultInstance();

private:

    inline void set_has_IgnitionCycle ();

    inline void clear_has_IgnitionCycle ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _IgnitionCycle;

};

/**
 * The status message of the property "SysPwrMode"
 * <p>This property informs about the powermode the vehicle is currently in (key position).</p>
 */
class SysPwrModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysPwrModeStatus ();

    /**
     * Copy constructor
     */
    inline  SysPwrModeStatus (const SysPwrModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SysPwrModeStatus (::spm_core_fi_types::T_SPM_e32_SYSPWRMODE SysPwrMode_);

    /**
     * Destructor
     */
    inline virtual  ~SysPwrModeStatus();

    /**
     * Assignment operator
     */
    inline SysPwrModeStatus& operator = (const SysPwrModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysPwrModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysPwrModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysPwrModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysPwrModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SysPwrMode"

    static const int kSysPwrMode = 0;

    /**
     * Clears the field "SysPwrMode".
     *
     * The field will be set to its default value. The hasSysPwrMode()
     * method will return false.
     */
    inline void clearSysPwrMode();

    /**
     * Checks whether the field "SysPwrMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysPwrMode()). Otherwise it will return false.
     */
    inline bool hasSysPwrMode () const;

    /**
     * Returns the value of the member "SysPwrMode".
     *
     * Current powermode of the vehicle.
     *
     * @return The value of the field "SysPwrMode"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYSPWRMODE getSysPwrMode () const;

    /**
     * Sets the value of the member "SysPwrMode".
     *
     * Current powermode of the vehicle.
     *
     * @param SysPwrMode The value which will be set
     */
    inline void setSysPwrMode (::spm_core_fi_types::T_SPM_e32_SYSPWRMODE SysPwrMode_);

    static const SysPwrModeStatus &getDefaultInstance();

private:

    inline void set_has_SysPwrMode ();

    inline void clear_has_SysPwrMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYSPWRMODE _SysPwrMode;

};

/**
 * The status message of the property "SysPwrSaveMode"
 * <p>This property informs about an active power save mode e.g. Transportmode, FactoryMode ....</p>
 */
class SysPwrSaveModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysPwrSaveModeStatus ();

    /**
     * Copy constructor
     */
    inline  SysPwrSaveModeStatus (const SysPwrSaveModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SysPwrSaveModeStatus (const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& SysPwrSaveMode_);

    /**
     * Destructor
     */
    inline virtual  ~SysPwrSaveModeStatus();

    /**
     * Assignment operator
     */
    inline SysPwrSaveModeStatus& operator = (const SysPwrSaveModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysPwrSaveModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysPwrSaveModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysPwrSaveModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysPwrSaveModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SysPwrSaveMode"

    static const int kSysPwrSaveMode = 0;

    /**
     * Clears the field "SysPwrSaveMode".
     *
     * The field will be set to its default value. The hasSysPwrSaveMode()
     * method will return false.
     */
    inline void clearSysPwrSaveMode();

    /**
     * Checks whether the field "SysPwrSaveMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysPwrSaveMode()). Otherwise it will return false.
     */
    inline bool hasSysPwrSaveMode () const;

    /**
     * Returns the value of the member "SysPwrSaveMode".
     *
     * Current powersavemode of the vehicle. Parameter is bit-coded -- More than one mode possibly active.
     *
     * @return The value of the field "SysPwrSaveMode"
     */
    inline const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& getSysPwrSaveMode () const;

    /**
     * Retrieves the value of the field "SysPwrSaveMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SysPwrSaveMode".
     */
    inline ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& getSysPwrSaveModeMutable ();

    /**
     * Sets the value of the member "SysPwrSaveMode".
     *
     * Current powersavemode of the vehicle. Parameter is bit-coded -- More than one mode possibly active.
     *
     * @param SysPwrSaveMode The value which will be set
     */
    inline void setSysPwrSaveMode (const ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE& SysPwrSaveMode_);

    /**
     * Release the object stored in the field "SysPwrSaveMode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "SysPwrSaveMode"
     */
    inline ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE* releaseSysPwrSaveMode();

    /**
     * Replace the field "SysPwrSaveMode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSysPwrSaveMode (::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE* SysPwrSaveMode_);

    static const SysPwrSaveModeStatus &getDefaultInstance();

private:

    inline void set_has_SysPwrSaveMode ();

    inline void clear_has_SysPwrSaveMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_b32_SYSPWRSAVEMODE* _SysPwrSaveMode;

};

/**
 * The status message of the property "MapDownloadLockState"
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.
 */
class MapDownloadLockStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapDownloadLockStateStatus ();

    /**
     * Copy constructor
     */
    inline  MapDownloadLockStateStatus (const MapDownloadLockStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MapDownloadLockStateStatus (uint16 u16AppIdLockOwner_);

    /**
     * Destructor
     */
    inline virtual  ~MapDownloadLockStateStatus();

    /**
     * Assignment operator
     */
    inline MapDownloadLockStateStatus& operator = (const MapDownloadLockStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapDownloadLockStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapDownloadLockStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapDownloadLockStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapDownloadLockStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16AppIdLockOwner"

    static const int kU16AppIdLockOwner = 0;

    /**
     * Clears the field "u16AppIdLockOwner".
     *
     * The field will be set to its default value. The hasU16AppIdLockOwner()
     * method will return false.
     */
    inline void clearU16AppIdLockOwner();

    /**
     * Checks whether the field "u16AppIdLockOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AppIdLockOwner()). Otherwise it will return false.
     */
    inline bool hasU16AppIdLockOwner () const;

    /**
     * Returns the value of the member "u16AppIdLockOwner".
     *
     * CCA application ID of the LOCK owner.
     *
     * @return The value of the field "u16AppIdLockOwner"
     */
    inline uint16 getU16AppIdLockOwner () const;

    /**
     * Sets the value of the member "u16AppIdLockOwner".
     *
     * CCA application ID of the LOCK owner.
     *
     * @param u16AppIdLockOwner The value which will be set
     */
    inline void setU16AppIdLockOwner (uint16 u16AppIdLockOwner_);

    static const MapDownloadLockStateStatus &getDefaultInstance();

private:

    inline void set_has_u16AppIdLockOwner ();

    inline void clear_has_u16AppIdLockOwner ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16AppIdLockOwner;

};

/**
 * The status message of the property "StandbyTime"
 */
class StandbyTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StandbyTimeStatus ();

    /**
     * Copy constructor
     */
    inline  StandbyTimeStatus (const StandbyTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StandbyTimeStatus (uint32 StandbyTime_);

    /**
     * Destructor
     */
    inline virtual  ~StandbyTimeStatus();

    /**
     * Assignment operator
     */
    inline StandbyTimeStatus& operator = (const StandbyTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StandbyTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StandbyTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StandbyTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StandbyTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StandbyTime"

    static const int kStandbyTime = 0;

    /**
     * Clears the field "StandbyTime".
     *
     * The field will be set to its default value. The hasStandbyTime()
     * method will return false.
     */
    inline void clearStandbyTime();

    /**
     * Checks whether the field "StandbyTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStandbyTime()). Otherwise it will return false.
     */
    inline bool hasStandbyTime () const;

    /**
     * Returns the value of the member "StandbyTime".
     *
     * Current standby time in minutes.
     *
     * @return The value of the field "StandbyTime"
     */
    inline uint32 getStandbyTime () const;

    /**
     * Sets the value of the member "StandbyTime".
     *
     * Current standby time in minutes.
     *
     * @param StandbyTime The value which will be set
     */
    inline void setStandbyTime (uint32 StandbyTime_);

    static const StandbyTimeStatus &getDefaultInstance();

private:

    inline void set_has_StandbyTime ();

    inline void clear_has_StandbyTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _StandbyTime;

};

/**
 * The set message of the property "StandbyTime"
 */
class StandbyTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StandbyTimeSet ();

    /**
     * Copy constructor
     */
    inline  StandbyTimeSet (const StandbyTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  StandbyTimeSet (uint32 StandbyTime_);

    /**
     * Destructor
     */
    inline virtual  ~StandbyTimeSet();

    /**
     * Assignment operator
     */
    inline StandbyTimeSet& operator = (const StandbyTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StandbyTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StandbyTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StandbyTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StandbyTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StandbyTime"

    static const int kStandbyTime = 0;

    /**
     * Clears the field "StandbyTime".
     *
     * The field will be set to its default value. The hasStandbyTime()
     * method will return false.
     */
    inline void clearStandbyTime();

    /**
     * Checks whether the field "StandbyTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStandbyTime()). Otherwise it will return false.
     */
    inline bool hasStandbyTime () const;

    /**
     * Returns the value of the member "StandbyTime".
     *
     * Current standby time in minutes.
     *
     * @return The value of the field "StandbyTime"
     */
    inline uint32 getStandbyTime () const;

    /**
     * Sets the value of the member "StandbyTime".
     *
     * Current standby time in minutes.
     *
     * @param StandbyTime The value which will be set
     */
    inline void setStandbyTime (uint32 StandbyTime_);

    static const StandbyTimeSet &getDefaultInstance();

private:

    inline void set_has_StandbyTime ();

    inline void clear_has_StandbyTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _StandbyTime;

};

/**
 * The status message of the property "PersitentStandbyTime"
 * Set standby time persistent. Must be set before entering the standby state.
 */
class PersitentStandbyTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PersitentStandbyTimeStatus ();

    /**
     * Copy constructor
     */
    inline  PersitentStandbyTimeStatus (const PersitentStandbyTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PersitentStandbyTimeStatus (uint32 PersitentStandbyTime_);

    /**
     * Destructor
     */
    inline virtual  ~PersitentStandbyTimeStatus();

    /**
     * Assignment operator
     */
    inline PersitentStandbyTimeStatus& operator = (const PersitentStandbyTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PersitentStandbyTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PersitentStandbyTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PersitentStandbyTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PersitentStandbyTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PersitentStandbyTime"

    static const int kPersitentStandbyTime = 0;

    /**
     * Clears the field "PersitentStandbyTime".
     *
     * The field will be set to its default value. The hasPersitentStandbyTime()
     * method will return false.
     */
    inline void clearPersitentStandbyTime();

    /**
     * Checks whether the field "PersitentStandbyTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPersitentStandbyTime()). Otherwise it will return false.
     */
    inline bool hasPersitentStandbyTime () const;

    /**
     * Returns the value of the member "PersitentStandbyTime".
     *
     * Current persistent standby time in seconds.
     *
     * @return The value of the field "PersitentStandbyTime"
     */
    inline uint32 getPersitentStandbyTime () const;

    /**
     * Sets the value of the member "PersitentStandbyTime".
     *
     * Current persistent standby time in seconds.
     *
     * @param PersitentStandbyTime The value which will be set
     */
    inline void setPersitentStandbyTime (uint32 PersitentStandbyTime_);

    static const PersitentStandbyTimeStatus &getDefaultInstance();

private:

    inline void set_has_PersitentStandbyTime ();

    inline void clear_has_PersitentStandbyTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _PersitentStandbyTime;

};

/**
 * The set message of the property "PersitentStandbyTime"
 * Set standby time persistent. Must be set before entering the standby state.
 */
class PersitentStandbyTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PersitentStandbyTimeSet ();

    /**
     * Copy constructor
     */
    inline  PersitentStandbyTimeSet (const PersitentStandbyTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  PersitentStandbyTimeSet (uint32 PersitentStandbyTime_);

    /**
     * Destructor
     */
    inline virtual  ~PersitentStandbyTimeSet();

    /**
     * Assignment operator
     */
    inline PersitentStandbyTimeSet& operator = (const PersitentStandbyTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PersitentStandbyTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PersitentStandbyTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PersitentStandbyTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PersitentStandbyTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PersitentStandbyTime"

    static const int kPersitentStandbyTime = 0;

    /**
     * Clears the field "PersitentStandbyTime".
     *
     * The field will be set to its default value. The hasPersitentStandbyTime()
     * method will return false.
     */
    inline void clearPersitentStandbyTime();

    /**
     * Checks whether the field "PersitentStandbyTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPersitentStandbyTime()). Otherwise it will return false.
     */
    inline bool hasPersitentStandbyTime () const;

    /**
     * Returns the value of the member "PersitentStandbyTime".
     *
     * Current persistent standby time in seconds.
     *
     * @return The value of the field "PersitentStandbyTime"
     */
    inline uint32 getPersitentStandbyTime () const;

    /**
     * Sets the value of the member "PersitentStandbyTime".
     *
     * Current persistent standby time in seconds.
     *
     * @param PersitentStandbyTime The value which will be set
     */
    inline void setPersitentStandbyTime (uint32 PersitentStandbyTime_);

    static const PersitentStandbyTimeSet &getDefaultInstance();

private:

    inline void set_has_PersitentStandbyTime ();

    inline void clear_has_PersitentStandbyTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _PersitentStandbyTime;

};

/**
 * The status message of the property "IgnitionOffTime"
 * Set ignition off time. A restart is necessary.
 */
class IgnitionOffTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionOffTimeStatus ();

    /**
     * Copy constructor
     */
    inline  IgnitionOffTimeStatus (const IgnitionOffTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  IgnitionOffTimeStatus (uint32 IgnitionOffTime_);

    /**
     * Destructor
     */
    inline virtual  ~IgnitionOffTimeStatus();

    /**
     * Assignment operator
     */
    inline IgnitionOffTimeStatus& operator = (const IgnitionOffTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionOffTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionOffTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionOffTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionOffTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnitionOffTime"

    static const int kIgnitionOffTime = 0;

    /**
     * Clears the field "IgnitionOffTime".
     *
     * The field will be set to its default value. The hasIgnitionOffTime()
     * method will return false.
     */
    inline void clearIgnitionOffTime();

    /**
     * Checks whether the field "IgnitionOffTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnitionOffTime()). Otherwise it will return false.
     */
    inline bool hasIgnitionOffTime () const;

    /**
     * Returns the value of the member "IgnitionOffTime".
     *
     * Current ignition off time in minutes.
     *
     * @return The value of the field "IgnitionOffTime"
     */
    inline uint32 getIgnitionOffTime () const;

    /**
     * Sets the value of the member "IgnitionOffTime".
     *
     * Current ignition off time in minutes.
     *
     * @param IgnitionOffTime The value which will be set
     */
    inline void setIgnitionOffTime (uint32 IgnitionOffTime_);

    static const IgnitionOffTimeStatus &getDefaultInstance();

private:

    inline void set_has_IgnitionOffTime ();

    inline void clear_has_IgnitionOffTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _IgnitionOffTime;

};

/**
 * The set message of the property "IgnitionOffTime"
 * Set ignition off time. A restart is necessary.
 */
class IgnitionOffTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionOffTimeSet ();

    /**
     * Copy constructor
     */
    inline  IgnitionOffTimeSet (const IgnitionOffTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  IgnitionOffTimeSet (uint32 IgnitionOffTime_);

    /**
     * Destructor
     */
    inline virtual  ~IgnitionOffTimeSet();

    /**
     * Assignment operator
     */
    inline IgnitionOffTimeSet& operator = (const IgnitionOffTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionOffTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionOffTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionOffTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionOffTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnitionOffTime"

    static const int kIgnitionOffTime = 0;

    /**
     * Clears the field "IgnitionOffTime".
     *
     * The field will be set to its default value. The hasIgnitionOffTime()
     * method will return false.
     */
    inline void clearIgnitionOffTime();

    /**
     * Checks whether the field "IgnitionOffTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnitionOffTime()). Otherwise it will return false.
     */
    inline bool hasIgnitionOffTime () const;

    /**
     * Returns the value of the member "IgnitionOffTime".
     *
     * Current ignition off time in minutes.
     *
     * @return The value of the field "IgnitionOffTime"
     */
    inline uint32 getIgnitionOffTime () const;

    /**
     * Sets the value of the member "IgnitionOffTime".
     *
     * Current ignition off time in minutes.
     *
     * @param IgnitionOffTime The value which will be set
     */
    inline void setIgnitionOffTime (uint32 IgnitionOffTime_);

    static const IgnitionOffTimeSet &getDefaultInstance();

private:

    inline void set_has_IgnitionOffTime ();

    inline void clear_has_IgnitionOffTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _IgnitionOffTime;

};

/**
 * The status message of the property "DoorOpenTime"
 * Set door open time.
 */
class DoorOpenTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoorOpenTimeStatus ();

    /**
     * Copy constructor
     */
    inline  DoorOpenTimeStatus (const DoorOpenTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DoorOpenTimeStatus (uint32 DoorOpenTime_);

    /**
     * Destructor
     */
    inline virtual  ~DoorOpenTimeStatus();

    /**
     * Assignment operator
     */
    inline DoorOpenTimeStatus& operator = (const DoorOpenTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoorOpenTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoorOpenTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoorOpenTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoorOpenTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DoorOpenTime"

    static const int kDoorOpenTime = 0;

    /**
     * Clears the field "DoorOpenTime".
     *
     * The field will be set to its default value. The hasDoorOpenTime()
     * method will return false.
     */
    inline void clearDoorOpenTime();

    /**
     * Checks whether the field "DoorOpenTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoorOpenTime()). Otherwise it will return false.
     */
    inline bool hasDoorOpenTime () const;

    /**
     * Returns the value of the member "DoorOpenTime".
     *
     * Current door open time in minutes.
     *
     * @return The value of the field "DoorOpenTime"
     */
    inline uint32 getDoorOpenTime () const;

    /**
     * Sets the value of the member "DoorOpenTime".
     *
     * Current door open time in minutes.
     *
     * @param DoorOpenTime The value which will be set
     */
    inline void setDoorOpenTime (uint32 DoorOpenTime_);

    static const DoorOpenTimeStatus &getDefaultInstance();

private:

    inline void set_has_DoorOpenTime ();

    inline void clear_has_DoorOpenTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DoorOpenTime;

};

/**
 * The set message of the property "DoorOpenTime"
 * Set door open time.
 */
class DoorOpenTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoorOpenTimeSet ();

    /**
     * Copy constructor
     */
    inline  DoorOpenTimeSet (const DoorOpenTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  DoorOpenTimeSet (uint32 DoorOpenTime_);

    /**
     * Destructor
     */
    inline virtual  ~DoorOpenTimeSet();

    /**
     * Assignment operator
     */
    inline DoorOpenTimeSet& operator = (const DoorOpenTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoorOpenTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoorOpenTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoorOpenTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoorOpenTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DoorOpenTime"

    static const int kDoorOpenTime = 0;

    /**
     * Clears the field "DoorOpenTime".
     *
     * The field will be set to its default value. The hasDoorOpenTime()
     * method will return false.
     */
    inline void clearDoorOpenTime();

    /**
     * Checks whether the field "DoorOpenTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoorOpenTime()). Otherwise it will return false.
     */
    inline bool hasDoorOpenTime () const;

    /**
     * Returns the value of the member "DoorOpenTime".
     *
     * Current door open time in minutes.
     *
     * @return The value of the field "DoorOpenTime"
     */
    inline uint32 getDoorOpenTime () const;

    /**
     * Sets the value of the member "DoorOpenTime".
     *
     * Current door open time in minutes.
     *
     * @param DoorOpenTime The value which will be set
     */
    inline void setDoorOpenTime (uint32 DoorOpenTime_);

    static const DoorOpenTimeSet &getDefaultInstance();

private:

    inline void set_has_DoorOpenTime ();

    inline void clear_has_DoorOpenTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DoorOpenTime;

};

/**
 * The status message of the property "ClockDisplayTime"
 * Set clock display time.
 */
class ClockDisplayTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClockDisplayTimeStatus ();

    /**
     * Copy constructor
     */
    inline  ClockDisplayTimeStatus (const ClockDisplayTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ClockDisplayTimeStatus (uint32 ClockDisplayTime_);

    /**
     * Destructor
     */
    inline virtual  ~ClockDisplayTimeStatus();

    /**
     * Assignment operator
     */
    inline ClockDisplayTimeStatus& operator = (const ClockDisplayTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClockDisplayTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClockDisplayTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClockDisplayTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClockDisplayTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClockDisplayTime"

    static const int kClockDisplayTime = 0;

    /**
     * Clears the field "ClockDisplayTime".
     *
     * The field will be set to its default value. The hasClockDisplayTime()
     * method will return false.
     */
    inline void clearClockDisplayTime();

    /**
     * Checks whether the field "ClockDisplayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClockDisplayTime()). Otherwise it will return false.
     */
    inline bool hasClockDisplayTime () const;

    /**
     * Returns the value of the member "ClockDisplayTime".
     *
     * Current clock display time in minutes.
     *
     * @return The value of the field "ClockDisplayTime"
     */
    inline uint32 getClockDisplayTime () const;

    /**
     * Sets the value of the member "ClockDisplayTime".
     *
     * Current clock display time in minutes.
     *
     * @param ClockDisplayTime The value which will be set
     */
    inline void setClockDisplayTime (uint32 ClockDisplayTime_);

    static const ClockDisplayTimeStatus &getDefaultInstance();

private:

    inline void set_has_ClockDisplayTime ();

    inline void clear_has_ClockDisplayTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ClockDisplayTime;

};

/**
 * The set message of the property "ClockDisplayTime"
 * Set clock display time.
 */
class ClockDisplayTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClockDisplayTimeSet ();

    /**
     * Copy constructor
     */
    inline  ClockDisplayTimeSet (const ClockDisplayTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  ClockDisplayTimeSet (uint32 ClockDisplayTime_);

    /**
     * Destructor
     */
    inline virtual  ~ClockDisplayTimeSet();

    /**
     * Assignment operator
     */
    inline ClockDisplayTimeSet& operator = (const ClockDisplayTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClockDisplayTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClockDisplayTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClockDisplayTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClockDisplayTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClockDisplayTime"

    static const int kClockDisplayTime = 0;

    /**
     * Clears the field "ClockDisplayTime".
     *
     * The field will be set to its default value. The hasClockDisplayTime()
     * method will return false.
     */
    inline void clearClockDisplayTime();

    /**
     * Checks whether the field "ClockDisplayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClockDisplayTime()). Otherwise it will return false.
     */
    inline bool hasClockDisplayTime () const;

    /**
     * Returns the value of the member "ClockDisplayTime".
     *
     * Current clock display time in minutes.
     *
     * @return The value of the field "ClockDisplayTime"
     */
    inline uint32 getClockDisplayTime () const;

    /**
     * Sets the value of the member "ClockDisplayTime".
     *
     * Current clock display time in minutes.
     *
     * @param ClockDisplayTime The value which will be set
     */
    inline void setClockDisplayTime (uint32 ClockDisplayTime_);

    static const ClockDisplayTimeSet &getDefaultInstance();

private:

    inline void set_has_ClockDisplayTime ();

    inline void clear_has_ClockDisplayTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ClockDisplayTime;

};

/**
 * The status message of the property "SystemStateTime"
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger.
 */
class SystemStateTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateTimeStatus ();

    /**
     * Copy constructor
     */
    inline  SystemStateTimeStatus (const SystemStateTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateTimeStatus (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState_, uint32 tStateTimerValue_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateTimeStatus();

    /**
     * Assignment operator
     */
    inline SystemStateTimeStatus& operator = (const SystemStateTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSystemState"

    static const int kTSystemState = 0;

    /**
     * Clears the field "tSystemState".
     *
     * The field will be set to its default value. The hasTSystemState()
     * method will return false.
     */
    inline void clearTSystemState();

    /**
     * Checks whether the field "tSystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSystemState()). Otherwise it will return false.
     */
    inline bool hasTSystemState () const;

    /**
     * Returns the value of the member "tSystemState".
     *
     * If the meaning of "tSystemState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSystemState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES getTSystemState () const;

    /**
     * Sets the value of the member "tSystemState".
     *
     * If the meaning of "tSystemState" isn't clear, then there should be a description here.
     *
     * @param tSystemState The value which will be set
     */
    inline void setTSystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState_);

    // API of field "tStateTimerValue"

    static const int kTStateTimerValue = 1;

    /**
     * Clears the field "tStateTimerValue".
     *
     * The field will be set to its default value. The hasTStateTimerValue()
     * method will return false.
     */
    inline void clearTStateTimerValue();

    /**
     * Checks whether the field "tStateTimerValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateTimerValue()). Otherwise it will return false.
     */
    inline bool hasTStateTimerValue () const;

    /**
     * Returns the value of the member "tStateTimerValue".
     *
     * Timeout value in seconds.
     *
     * @return The value of the field "tStateTimerValue"
     */
    inline uint32 getTStateTimerValue () const;

    /**
     * Sets the value of the member "tStateTimerValue".
     *
     * Timeout value in seconds.
     *
     * @param tStateTimerValue The value which will be set
     */
    inline void setTStateTimerValue (uint32 tStateTimerValue_);

    static const SystemStateTimeStatus &getDefaultInstance();

private:

    inline void set_has_tSystemState ();

    inline void clear_has_tSystemState ();

    inline void set_has_tStateTimerValue ();

    inline void clear_has_tStateTimerValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES _tSystemState;

    uint32 _tStateTimerValue;

};

/**
 * The set message of the property "SystemStateTime"
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger.
 */
class SystemStateTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateTimeSet ();

    /**
     * Copy constructor
     */
    inline  SystemStateTimeSet (const SystemStateTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateTimeSet (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState_, uint32 tStateTimerValue_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateTimeSet();

    /**
     * Assignment operator
     */
    inline SystemStateTimeSet& operator = (const SystemStateTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSystemState"

    static const int kTSystemState = 0;

    /**
     * Clears the field "tSystemState".
     *
     * The field will be set to its default value. The hasTSystemState()
     * method will return false.
     */
    inline void clearTSystemState();

    /**
     * Checks whether the field "tSystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSystemState()). Otherwise it will return false.
     */
    inline bool hasTSystemState () const;

    /**
     * Returns the value of the member "tSystemState".
     *
     * If the meaning of "tSystemState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSystemState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES getTSystemState () const;

    /**
     * Sets the value of the member "tSystemState".
     *
     * If the meaning of "tSystemState" isn't clear, then there should be a description here.
     *
     * @param tSystemState The value which will be set
     */
    inline void setTSystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState_);

    // API of field "tStateTimerValue"

    static const int kTStateTimerValue = 1;

    /**
     * Clears the field "tStateTimerValue".
     *
     * The field will be set to its default value. The hasTStateTimerValue()
     * method will return false.
     */
    inline void clearTStateTimerValue();

    /**
     * Checks whether the field "tStateTimerValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateTimerValue()). Otherwise it will return false.
     */
    inline bool hasTStateTimerValue () const;

    /**
     * Returns the value of the member "tStateTimerValue".
     *
     * Timeout value in seconds.
     *
     * @return The value of the field "tStateTimerValue"
     */
    inline uint32 getTStateTimerValue () const;

    /**
     * Sets the value of the member "tStateTimerValue".
     *
     * Timeout value in seconds.
     *
     * @param tStateTimerValue The value which will be set
     */
    inline void setTStateTimerValue (uint32 tStateTimerValue_);

    static const SystemStateTimeSet &getDefaultInstance();

private:

    inline void set_has_tSystemState ();

    inline void clear_has_tSystemState ();

    inline void set_has_tStateTimerValue ();

    inline void clear_has_tStateTimerValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES _tSystemState;

    uint32 _tStateTimerValue;

};

/**
 * The get message of the property "SystemStateTime"
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger.
 */
class SystemStateTimeGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateTimeGet ();

    /**
     * Copy constructor
     */
    inline  SystemStateTimeGet (const SystemStateTimeGet &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateTimeGet (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateTimeGet();

    /**
     * Assignment operator
     */
    inline SystemStateTimeGet& operator = (const SystemStateTimeGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateTimeGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateTimeGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateTimeGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateTimeGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSystemState"

    static const int kTSystemState = 0;

    /**
     * Clears the field "tSystemState".
     *
     * The field will be set to its default value. The hasTSystemState()
     * method will return false.
     */
    inline void clearTSystemState();

    /**
     * Checks whether the field "tSystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSystemState()). Otherwise it will return false.
     */
    inline bool hasTSystemState () const;

    /**
     * Returns the value of the member "tSystemState".
     *
     * If the meaning of "tSystemState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tSystemState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES getTSystemState () const;

    /**
     * Sets the value of the member "tSystemState".
     *
     * If the meaning of "tSystemState" isn't clear, then there should be a description here.
     *
     * @param tSystemState The value which will be set
     */
    inline void setTSystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState_);

    static const SystemStateTimeGet &getDefaultInstance();

private:

    inline void set_has_tSystemState ();

    inline void clear_has_tSystemState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES _tSystemState;

};

/**
 * The status message of the property "ProcessList"
 * Informs about all processes configured in start configuration of SPM.
 */
class ProcessListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProcessListStatus ();

    /**
     * Copy constructor
     */
    inline  ProcessListStatus (const ProcessListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ProcessListStatus (const ::spm_core_fi_types::T_SPM_ProcessInfo& tProcesses_);

    /**
     * Destructor
     */
    inline virtual  ~ProcessListStatus();

    /**
     * Assignment operator
     */
    inline ProcessListStatus& operator = (const ProcessListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProcessListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProcessListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProcessListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProcessListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tProcesses"

    static const int kTProcesses = 0;

    /**
     * Clears the field "tProcesses".
     *
     * The field will be set to its default value. The hasTProcesses()
     * method will return false.
     */
    inline void clearTProcesses();

    /**
     * Checks whether the field "tProcesses" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTProcesses()). Otherwise it will return false.
     */
    inline bool hasTProcesses () const;

    /**
     * Returns the value of the member "tProcesses".
     *
     * List of all processes configured in start configuration of SPM.
     *
     * @return The value of the field "tProcesses"
     */
    inline const ::spm_core_fi_types::T_SPM_ProcessInfo& getTProcesses () const;

    /**
     * Retrieves the value of the field "tProcesses" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tProcesses".
     */
    inline ::spm_core_fi_types::T_SPM_ProcessInfo& getTProcessesMutable ();

    /**
     * Sets the value of the member "tProcesses".
     *
     * List of all processes configured in start configuration of SPM.
     *
     * @param tProcesses The value which will be set
     */
    inline void setTProcesses (const ::spm_core_fi_types::T_SPM_ProcessInfo& tProcesses_);

    /**
     * Release the object stored in the field "tProcesses".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tProcesses"
     */
    inline ::spm_core_fi_types::T_SPM_ProcessInfo* releaseTProcesses();

    /**
     * Replace the field "tProcesses".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTProcesses (::spm_core_fi_types::T_SPM_ProcessInfo* tProcesses_);

    static const ProcessListStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_ProcessElement >& getT_ProcessElementPointerList_DefaultInstance ();

    inline void set_has_tProcesses ();

    inline void clear_has_tProcesses ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_ProcessInfo* _tProcesses;

};

/**
 * The start message of the method "StartProcess"
 * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes.
 */
class StartProcessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartProcessStart ();

    /**
     * Copy constructor
     */
    inline  StartProcessStart (const StartProcessStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartProcessStart (const ::std::string& strLocation_, uint32 u32Prio_, uint32 u32Affinity_, uint32 u32AffinityEnd_, uint32 u32NiceLevel_, uint32 u32NiceLevelEnd_, ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE u32Type_, uint32 u32Info_);

    /**
     * Destructor
     */
    inline virtual  ~StartProcessStart();

    /**
     * Assignment operator
     */
    inline StartProcessStart& operator = (const StartProcessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartProcessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartProcessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartProcessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartProcessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    /**
     * Release the object stored in the field "strLocation".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strLocation"
     */
    inline ::std::string* releaseStrLocation();

    /**
     * Replace the field "strLocation".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrLocation (::std::string* strLocation_);

    // API of field "u32Prio"

    static const int kU32Prio = 1;

    /**
     * Clears the field "u32Prio".
     *
     * The field will be set to its default value. The hasU32Prio()
     * method will return false.
     */
    inline void clearU32Prio();

    /**
     * Checks whether the field "u32Prio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Prio()). Otherwise it will return false.
     */
    inline bool hasU32Prio () const;

    /**
     * Returns the value of the member "u32Prio".
     *
     * If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Prio"
     */
    inline uint32 getU32Prio () const;

    /**
     * Sets the value of the member "u32Prio".
     *
     * If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @param u32Prio The value which will be set
     */
    inline void setU32Prio (uint32 u32Prio_);

    // API of field "u32Affinity"

    static const int kU32Affinity = 2;

    /**
     * Clears the field "u32Affinity".
     *
     * The field will be set to its default value. The hasU32Affinity()
     * method will return false.
     */
    inline void clearU32Affinity();

    /**
     * Checks whether the field "u32Affinity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Affinity()). Otherwise it will return false.
     */
    inline bool hasU32Affinity () const;

    /**
     * Returns the value of the member "u32Affinity".
     *
     * If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Affinity"
     */
    inline uint32 getU32Affinity () const;

    /**
     * Sets the value of the member "u32Affinity".
     *
     * If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @param u32Affinity The value which will be set
     */
    inline void setU32Affinity (uint32 u32Affinity_);

    // API of field "u32AffinityEnd"

    static const int kU32AffinityEnd = 3;

    /**
     * Clears the field "u32AffinityEnd".
     *
     * The field will be set to its default value. The hasU32AffinityEnd()
     * method will return false.
     */
    inline void clearU32AffinityEnd();

    /**
     * Checks whether the field "u32AffinityEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AffinityEnd()). Otherwise it will return false.
     */
    inline bool hasU32AffinityEnd () const;

    /**
     * Returns the value of the member "u32AffinityEnd".
     *
     * If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AffinityEnd"
     */
    inline uint32 getU32AffinityEnd () const;

    /**
     * Sets the value of the member "u32AffinityEnd".
     *
     * If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @param u32AffinityEnd The value which will be set
     */
    inline void setU32AffinityEnd (uint32 u32AffinityEnd_);

    // API of field "u32NiceLevel"

    static const int kU32NiceLevel = 4;

    /**
     * Clears the field "u32NiceLevel".
     *
     * The field will be set to its default value. The hasU32NiceLevel()
     * method will return false.
     */
    inline void clearU32NiceLevel();

    /**
     * Checks whether the field "u32NiceLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NiceLevel()). Otherwise it will return false.
     */
    inline bool hasU32NiceLevel () const;

    /**
     * Returns the value of the member "u32NiceLevel".
     *
     * If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NiceLevel"
     */
    inline uint32 getU32NiceLevel () const;

    /**
     * Sets the value of the member "u32NiceLevel".
     *
     * If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevel The value which will be set
     */
    inline void setU32NiceLevel (uint32 u32NiceLevel_);

    // API of field "u32NiceLevelEnd"

    static const int kU32NiceLevelEnd = 5;

    /**
     * Clears the field "u32NiceLevelEnd".
     *
     * The field will be set to its default value. The hasU32NiceLevelEnd()
     * method will return false.
     */
    inline void clearU32NiceLevelEnd();

    /**
     * Checks whether the field "u32NiceLevelEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NiceLevelEnd()). Otherwise it will return false.
     */
    inline bool hasU32NiceLevelEnd () const;

    /**
     * Returns the value of the member "u32NiceLevelEnd".
     *
     * If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NiceLevelEnd"
     */
    inline uint32 getU32NiceLevelEnd () const;

    /**
     * Sets the value of the member "u32NiceLevelEnd".
     *
     * If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevelEnd The value which will be set
     */
    inline void setU32NiceLevelEnd (uint32 u32NiceLevelEnd_);

    // API of field "u32Type"

    static const int kU32Type = 6;

    /**
     * Clears the field "u32Type".
     *
     * The field will be set to its default value. The hasU32Type()
     * method will return false.
     */
    inline void clearU32Type();

    /**
     * Checks whether the field "u32Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Type()). Otherwise it will return false.
     */
    inline bool hasU32Type () const;

    /**
     * Returns the value of the member "u32Type".
     *
     * If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Type"
     */
    inline ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE getU32Type () const;

    /**
     * Sets the value of the member "u32Type".
     *
     * If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @param u32Type The value which will be set
     */
    inline void setU32Type (::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE u32Type_);

    // API of field "u32Info"

    static const int kU32Info = 7;

    /**
     * Clears the field "u32Info".
     *
     * The field will be set to its default value. The hasU32Info()
     * method will return false.
     */
    inline void clearU32Info();

    /**
     * Checks whether the field "u32Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Info()). Otherwise it will return false.
     */
    inline bool hasU32Info () const;

    /**
     * Returns the value of the member "u32Info".
     *
     * If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Info"
     */
    inline uint32 getU32Info () const;

    /**
     * Sets the value of the member "u32Info".
     *
     * If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @param u32Info The value which will be set
     */
    inline void setU32Info (uint32 u32Info_);

    static const StartProcessStart &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32Prio ();

    inline void clear_has_u32Prio ();

    inline void set_has_u32Affinity ();

    inline void clear_has_u32Affinity ();

    inline void set_has_u32AffinityEnd ();

    inline void clear_has_u32AffinityEnd ();

    inline void set_has_u32NiceLevel ();

    inline void clear_has_u32NiceLevel ();

    inline void set_has_u32NiceLevelEnd ();

    inline void clear_has_u32NiceLevelEnd ();

    inline void set_has_u32Type ();

    inline void clear_has_u32Type ();

    inline void set_has_u32Info ();

    inline void clear_has_u32Info ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string* _strLocation;

    uint32 _u32Prio;

    uint32 _u32Affinity;

    uint32 _u32AffinityEnd;

    uint32 _u32NiceLevel;

    uint32 _u32NiceLevelEnd;

    ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE _u32Type;

    uint32 _u32Info;

};

/**
 * The result message of the method "StartProcess"
 * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes.
 */
class StartProcessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartProcessResult ();

    /**
     * Copy constructor
     */
    inline  StartProcessResult (const StartProcessResult &rhs);

    /**
     * All fields constructor
     */
    inline  StartProcessResult (int32 s32ReturnVal_, const ::std::string& strLocation_, uint32 u32ProcId_, uint32 u32SpawnDuration_);

    /**
     * Destructor
     */
    inline virtual  ~StartProcessResult();

    /**
     * Assignment operator
     */
    inline StartProcessResult& operator = (const StartProcessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartProcessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartProcessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartProcessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartProcessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    // API of field "strLocation"

    static const int kStrLocation = 1;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    /**
     * Release the object stored in the field "strLocation".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strLocation"
     */
    inline ::std::string* releaseStrLocation();

    /**
     * Replace the field "strLocation".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrLocation (::std::string* strLocation_);

    // API of field "u32ProcId"

    static const int kU32ProcId = 2;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    // API of field "u32SpawnDuration"

    static const int kU32SpawnDuration = 3;

    /**
     * Clears the field "u32SpawnDuration".
     *
     * The field will be set to its default value. The hasU32SpawnDuration()
     * method will return false.
     */
    inline void clearU32SpawnDuration();

    /**
     * Checks whether the field "u32SpawnDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SpawnDuration()). Otherwise it will return false.
     */
    inline bool hasU32SpawnDuration () const;

    /**
     * Returns the value of the member "u32SpawnDuration".
     *
     * If the meaning of "u32SpawnDuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SpawnDuration"
     */
    inline uint32 getU32SpawnDuration () const;

    /**
     * Sets the value of the member "u32SpawnDuration".
     *
     * If the meaning of "u32SpawnDuration" isn't clear, then there should be a description here.
     *
     * @param u32SpawnDuration The value which will be set
     */
    inline void setU32SpawnDuration (uint32 u32SpawnDuration_);

    static const StartProcessResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    inline void set_has_u32SpawnDuration ();

    inline void clear_has_u32SpawnDuration ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _s32ReturnVal;

    ::std::string* _strLocation;

    uint32 _u32ProcId;

    uint32 _u32SpawnDuration;

};

/**
 * The start message of the method "StopProcess"
 * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes.
 */
class StopProcessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopProcessStart ();

    /**
     * Copy constructor
     */
    inline  StopProcessStart (const StopProcessStart &rhs);

    /**
     * All fields constructor
     */
    inline  StopProcessStart (const ::std::string& strLocation_, uint32 u32ProcId_);

    /**
     * Destructor
     */
    inline virtual  ~StopProcessStart();

    /**
     * Assignment operator
     */
    inline StopProcessStart& operator = (const StopProcessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopProcessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopProcessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopProcessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopProcessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    /**
     * Release the object stored in the field "strLocation".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strLocation"
     */
    inline ::std::string* releaseStrLocation();

    /**
     * Replace the field "strLocation".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrLocation (::std::string* strLocation_);

    // API of field "u32ProcId"

    static const int kU32ProcId = 1;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    static const StopProcessStart &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _strLocation;

    uint32 _u32ProcId;

};

/**
 * The result message of the method "StopProcess"
 * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes.
 */
class StopProcessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopProcessResult ();

    /**
     * Copy constructor
     */
    inline  StopProcessResult (const StopProcessResult &rhs);

    /**
     * All fields constructor
     */
    inline  StopProcessResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~StopProcessResult();

    /**
     * Assignment operator
     */
    inline StopProcessResult& operator = (const StopProcessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopProcessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopProcessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopProcessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopProcessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const StopProcessResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The start message of the method "RestartProcess"
 * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes.
 */
class RestartProcessStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartProcessStart ();

    /**
     * Copy constructor
     */
    inline  RestartProcessStart (const RestartProcessStart &rhs);

    /**
     * All fields constructor
     */
    inline  RestartProcessStart (const ::std::string& strLocation_, uint32 u32ProcId_);

    /**
     * Destructor
     */
    inline virtual  ~RestartProcessStart();

    /**
     * Assignment operator
     */
    inline RestartProcessStart& operator = (const RestartProcessStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartProcessStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartProcessStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartProcessStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartProcessStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    /**
     * Release the object stored in the field "strLocation".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strLocation"
     */
    inline ::std::string* releaseStrLocation();

    /**
     * Replace the field "strLocation".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrLocation (::std::string* strLocation_);

    // API of field "u32ProcId"

    static const int kU32ProcId = 1;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    static const RestartProcessStart &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _strLocation;

    uint32 _u32ProcId;

};

/**
 * The result message of the method "RestartProcess"
 * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes.
 */
class RestartProcessResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartProcessResult ();

    /**
     * Copy constructor
     */
    inline  RestartProcessResult (const RestartProcessResult &rhs);

    /**
     * All fields constructor
     */
    inline  RestartProcessResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~RestartProcessResult();

    /**
     * Assignment operator
     */
    inline RestartProcessResult& operator = (const RestartProcessResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartProcessResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartProcessResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartProcessResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartProcessResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const RestartProcessResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The status message of the property "WakeupReason"
 * <p>The current wakeup reason of the ApplicationProcessor is provided by this property. Also for devices with a RadioUnit this property will only display the ApplicationProcessor wakeup reason. Is the RU waked up by CAN the wakeup reason COPRO_REQ is shown.</p>
 */
class WakeupReasonStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupReasonStatus ();

    /**
     * Copy constructor
     */
    inline  WakeupReasonStatus (const WakeupReasonStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupReasonStatus (::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON WakeupReason_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupReasonStatus();

    /**
     * Assignment operator
     */
    inline WakeupReasonStatus& operator = (const WakeupReasonStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupReasonStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupReasonStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupReasonStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupReasonStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeupReason"

    static const int kWakeupReason = 0;

    /**
     * Clears the field "WakeupReason".
     *
     * The field will be set to its default value. The hasWakeupReason()
     * method will return false.
     */
    inline void clearWakeupReason();

    /**
     * Checks whether the field "WakeupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeupReason()). Otherwise it will return false.
     */
    inline bool hasWakeupReason () const;

    /**
     * Returns the value of the member "WakeupReason".
     *
     * Current detected WakeupReason.
     *
     * @return The value of the field "WakeupReason"
     */
    inline ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON getWakeupReason () const;

    /**
     * Sets the value of the member "WakeupReason".
     *
     * Current detected WakeupReason.
     *
     * @param WakeupReason The value which will be set
     */
    inline void setWakeupReason (::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON WakeupReason_);

    static const WakeupReasonStatus &getDefaultInstance();

private:

    inline void set_has_WakeupReason ();

    inline void clear_has_WakeupReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_WAKEUP_REASON _WakeupReason;

};

/**
 * The status message of the property "StartupReason"
 * <p>All incoming On/Off reasons will be accumulated in this property. This property is bit-coded and is not cleared at runtime.</p>
 */
class StartupReasonStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupReasonStatus ();

    /**
     * Copy constructor
     */
    inline  StartupReasonStatus (const StartupReasonStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StartupReasonStatus (::spm_core_fi_types::T_SPM_e32_STARTUP_REASON StartupReason_);

    /**
     * Destructor
     */
    inline virtual  ~StartupReasonStatus();

    /**
     * Assignment operator
     */
    inline StartupReasonStatus& operator = (const StartupReasonStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupReasonStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupReasonStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupReasonStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupReasonStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupReason"

    static const int kStartupReason = 0;

    /**
     * Clears the field "StartupReason".
     *
     * The field will be set to its default value. The hasStartupReason()
     * method will return false.
     */
    inline void clearStartupReason();

    /**
     * Checks whether the field "StartupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupReason()). Otherwise it will return false.
     */
    inline bool hasStartupReason () const;

    /**
     * Returns the value of the member "StartupReason".
     *
     * Current detected StartupReasons.
     *
     * @return The value of the field "StartupReason"
     */
    inline ::spm_core_fi_types::T_SPM_e32_STARTUP_REASON getStartupReason () const;

    /**
     * Sets the value of the member "StartupReason".
     *
     * Current detected StartupReasons.
     *
     * @param StartupReason The value which will be set
     */
    inline void setStartupReason (::spm_core_fi_types::T_SPM_e32_STARTUP_REASON StartupReason_);

    static const StartupReasonStatus &getDefaultInstance();

private:

    inline void set_has_StartupReason ();

    inline void clear_has_StartupReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_STARTUP_REASON _StartupReason;

};

/**
 * The status message of the property "ConnectToBattery"
 * <p>Connect to battery counter.</p>
 */
class ConnectToBatteryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectToBatteryStatus ();

    /**
     * Copy constructor
     */
    inline  ConnectToBatteryStatus (const ConnectToBatteryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectToBatteryStatus (bool ConnectToBatteryState_, uint16 ConnectToBatteryCount_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectToBatteryStatus();

    /**
     * Assignment operator
     */
    inline ConnectToBatteryStatus& operator = (const ConnectToBatteryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectToBatteryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectToBatteryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectToBatteryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectToBatteryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectToBatteryState"

    static const int kConnectToBatteryState = 0;

    /**
     * Clears the field "ConnectToBatteryState".
     *
     * The field will be set to its default value. The hasConnectToBatteryState()
     * method will return false.
     */
    inline void clearConnectToBatteryState();

    /**
     * Checks whether the field "ConnectToBatteryState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectToBatteryState()). Otherwise it will return false.
     */
    inline bool hasConnectToBatteryState () const;

    /**
     * Returns the value of the member "ConnectToBatteryState".
     *
     * Connected to battery is detected.
     *
     * @return The value of the field "ConnectToBatteryState"
     */
    inline bool getConnectToBatteryState () const;

    /**
     * Sets the value of the member "ConnectToBatteryState".
     *
     * Connected to battery is detected.
     *
     * @param ConnectToBatteryState The value which will be set
     */
    inline void setConnectToBatteryState (bool ConnectToBatteryState_);

    // API of field "ConnectToBatteryCount"

    static const int kConnectToBatteryCount = 1;

    /**
     * Clears the field "ConnectToBatteryCount".
     *
     * The field will be set to its default value. The hasConnectToBatteryCount()
     * method will return false.
     */
    inline void clearConnectToBatteryCount();

    /**
     * Checks whether the field "ConnectToBatteryCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectToBatteryCount()). Otherwise it will return false.
     */
    inline bool hasConnectToBatteryCount () const;

    /**
     * Returns the value of the member "ConnectToBatteryCount".
     *
     * Connect to battery count.
     *
     * @return The value of the field "ConnectToBatteryCount"
     */
    inline uint16 getConnectToBatteryCount () const;

    /**
     * Sets the value of the member "ConnectToBatteryCount".
     *
     * Connect to battery count.
     *
     * @param ConnectToBatteryCount The value which will be set
     */
    inline void setConnectToBatteryCount (uint16 ConnectToBatteryCount_);

    static const ConnectToBatteryStatus &getDefaultInstance();

private:

    inline void set_has_ConnectToBatteryState ();

    inline void clear_has_ConnectToBatteryState ();

    inline void set_has_ConnectToBatteryCount ();

    inline void clear_has_ConnectToBatteryCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _ConnectToBatteryState;

    uint16 _ConnectToBatteryCount;

};

/**
 * The status message of the property "CodeRequestState"
 * Current code request state.
 */
class CodeRequestStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CodeRequestStateStatus ();

    /**
     * Copy constructor
     */
    inline  CodeRequestStateStatus (const CodeRequestStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CodeRequestStateStatus (::spm_core_fi_types::T_SPM_e32_CODE_REQUEST CodeRequestState_);

    /**
     * Destructor
     */
    inline virtual  ~CodeRequestStateStatus();

    /**
     * Assignment operator
     */
    inline CodeRequestStateStatus& operator = (const CodeRequestStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CodeRequestStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CodeRequestStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CodeRequestStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CodeRequestStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CodeRequestState"

    static const int kCodeRequestState = 0;

    /**
     * Clears the field "CodeRequestState".
     *
     * The field will be set to its default value. The hasCodeRequestState()
     * method will return false.
     */
    inline void clearCodeRequestState();

    /**
     * Checks whether the field "CodeRequestState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCodeRequestState()). Otherwise it will return false.
     */
    inline bool hasCodeRequestState () const;

    /**
     * Returns the value of the member "CodeRequestState".
     *
     * State of code request.
     *
     * @return The value of the field "CodeRequestState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST getCodeRequestState () const;

    /**
     * Sets the value of the member "CodeRequestState".
     *
     * State of code request.
     *
     * @param CodeRequestState The value which will be set
     */
    inline void setCodeRequestState (::spm_core_fi_types::T_SPM_e32_CODE_REQUEST CodeRequestState_);

    static const CodeRequestStateStatus &getDefaultInstance();

private:

    inline void set_has_CodeRequestState ();

    inline void clear_has_CodeRequestState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST _CodeRequestState;

};

/**
 * The set message of the property "CodeRequestState"
 * Current code request state.
 */
class CodeRequestStateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CodeRequestStateSet ();

    /**
     * Copy constructor
     */
    inline  CodeRequestStateSet (const CodeRequestStateSet &rhs);

    /**
     * All fields constructor
     */
    inline  CodeRequestStateSet (::spm_core_fi_types::T_SPM_e32_CODE_REQUEST CodeRequestState_);

    /**
     * Destructor
     */
    inline virtual  ~CodeRequestStateSet();

    /**
     * Assignment operator
     */
    inline CodeRequestStateSet& operator = (const CodeRequestStateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CodeRequestStateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CodeRequestStateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CodeRequestStateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CodeRequestStateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CodeRequestState"

    static const int kCodeRequestState = 0;

    /**
     * Clears the field "CodeRequestState".
     *
     * The field will be set to its default value. The hasCodeRequestState()
     * method will return false.
     */
    inline void clearCodeRequestState();

    /**
     * Checks whether the field "CodeRequestState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCodeRequestState()). Otherwise it will return false.
     */
    inline bool hasCodeRequestState () const;

    /**
     * Returns the value of the member "CodeRequestState".
     *
     * SPM_U32_CODE_PROCESSED has to be set if key code is entered correctly.
     *
     * @return The value of the field "CodeRequestState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST getCodeRequestState () const;

    /**
     * Sets the value of the member "CodeRequestState".
     *
     * SPM_U32_CODE_PROCESSED has to be set if key code is entered correctly.
     *
     * @param CodeRequestState The value which will be set
     */
    inline void setCodeRequestState (::spm_core_fi_types::T_SPM_e32_CODE_REQUEST CodeRequestState_);

    static const CodeRequestStateSet &getDefaultInstance();

private:

    inline void set_has_CodeRequestState ();

    inline void clear_has_CodeRequestState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_CODE_REQUEST _CodeRequestState;

};

/**
 * The start message of the method "StartUpSyncPointReached"
 * Inform about a new reached sync point.
 */
class StartUpSyncPointReachedStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUpSyncPointReachedStart ();

    /**
     * Copy constructor
     */
    inline  StartUpSyncPointReachedStart (const StartUpSyncPointReachedStart &rhs);

    /**
     * All fields constructor
     */
    inline  StartUpSyncPointReachedStart (const ::std::string& strNewSyncPoint_);

    /**
     * Destructor
     */
    inline virtual  ~StartUpSyncPointReachedStart();

    /**
     * Assignment operator
     */
    inline StartUpSyncPointReachedStart& operator = (const StartUpSyncPointReachedStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUpSyncPointReachedStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUpSyncPointReachedStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUpSyncPointReachedStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUpSyncPointReachedStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strNewSyncPoint"

    static const int kStrNewSyncPoint = 0;

    /**
     * Clears the field "strNewSyncPoint".
     *
     * The field will be set to its default value. The hasStrNewSyncPoint()
     * method will return false.
     */
    inline void clearStrNewSyncPoint();

    /**
     * Checks whether the field "strNewSyncPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrNewSyncPoint()). Otherwise it will return false.
     */
    inline bool hasStrNewSyncPoint () const;

    /**
     * Returns the value of the member "strNewSyncPoint".
     *
     * <p>StartUpSyncPointReached has to be set if a new sync point is reached during start-up.</p>
     * <p>SyncPoints are string based e.g. 'LCMEARLY_STARTED', 'RVC_AVAILABLE', 'PHONE_CONNECTED', ... !</p>
     * <p>To synchronize the startup it is possible to delay processes by waiting for SyncPoints. Configuration is possible by OSAL registry.</p>
     *
     * @return The value of the field "strNewSyncPoint"
     */
    inline const ::std::string& getStrNewSyncPoint () const;

    /**
     * Retrieves the value of the field "strNewSyncPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strNewSyncPoint".
     */
    inline ::std::string& getStrNewSyncPointMutable ();

    /**
     * Sets the value of the member "strNewSyncPoint".
     *
     * <p>StartUpSyncPointReached has to be set if a new sync point is reached during start-up.</p>
     * <p>SyncPoints are string based e.g. 'LCMEARLY_STARTED', 'RVC_AVAILABLE', 'PHONE_CONNECTED', ... !</p>
     * <p>To synchronize the startup it is possible to delay processes by waiting for SyncPoints. Configuration is possible by OSAL registry.</p>
     *
     * @param strNewSyncPoint The value which will be set
     */
    inline void setStrNewSyncPoint (const ::std::string& strNewSyncPoint_);

    /**
     * Sets the value of the member "strNewSyncPoint".
     *
     * <p>StartUpSyncPointReached has to be set if a new sync point is reached during start-up.</p>
     * <p>SyncPoints are string based e.g. 'LCMEARLY_STARTED', 'RVC_AVAILABLE', 'PHONE_CONNECTED', ... !</p>
     * <p>To synchronize the startup it is possible to delay processes by waiting for SyncPoints. Configuration is possible by OSAL registry.</p>
     *
     * @param strNewSyncPoint The value which will be set
     */
    inline void setStrNewSyncPoint (const char* strNewSyncPoint_);

    /**
     * Sets the value of the member "strNewSyncPoint".
     *
     * <p>StartUpSyncPointReached has to be set if a new sync point is reached during start-up.</p>
     * <p>SyncPoints are string based e.g. 'LCMEARLY_STARTED', 'RVC_AVAILABLE', 'PHONE_CONNECTED', ... !</p>
     * <p>To synchronize the startup it is possible to delay processes by waiting for SyncPoints. Configuration is possible by OSAL registry.</p>
     *
     * @param strNewSyncPoint The value which will be set
     */
    inline void setStrNewSyncPoint (const char* value, size_t size);

    /**
     * Release the object stored in the field "strNewSyncPoint".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "strNewSyncPoint"
     */
    inline ::std::string* releaseStrNewSyncPoint();

    /**
     * Replace the field "strNewSyncPoint".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStrNewSyncPoint (::std::string* strNewSyncPoint_);

    static const StartUpSyncPointReachedStart &getDefaultInstance();

private:

    inline void set_has_strNewSyncPoint ();

    inline void clear_has_strNewSyncPoint ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _strNewSyncPoint;

};

/**
 * The status message of the property "ActiveStartUpSyncPoints"
 * Informs about all StartupSyncPoints since last wakeup.
 */
class ActiveStartUpSyncPointsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveStartUpSyncPointsStatus ();

    /**
     * Copy constructor
     */
    inline  ActiveStartUpSyncPointsStatus (const ActiveStartUpSyncPointsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveStartUpSyncPointsStatus (const ::boost::ptr_vector< ::std::string >& tStartupSyncPointList_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveStartUpSyncPointsStatus();

    /**
     * Assignment operator
     */
    inline ActiveStartUpSyncPointsStatus& operator = (const ActiveStartUpSyncPointsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveStartUpSyncPointsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveStartUpSyncPointsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveStartUpSyncPointsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveStartUpSyncPointsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStartupSyncPointList"

    static const int kTStartupSyncPointList = 0;

    /**
     * Clears the field "tStartupSyncPointList".
     *
     * The field will be set to its default value. The hasTStartupSyncPointList()
     * method will return false.
     */
    inline void clearTStartupSyncPointList();

    /**
     * Checks whether the field "tStartupSyncPointList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStartupSyncPointList()). Otherwise it will return false.
     */
    inline bool hasTStartupSyncPointList () const;

    /**
     * Returns the value of the member "tStartupSyncPointList".
     *
     * List of all set StartupSyncPoints since last wakeup.
     *
     * @return The value of the field "tStartupSyncPointList"
     */
    inline const ::boost::ptr_vector< ::std::string >& getTStartupSyncPointList () const;

    /**
     * Retrieves the value of the field "tStartupSyncPointList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStartupSyncPointList".
     */
    inline ::boost::ptr_vector< ::std::string >& getTStartupSyncPointListMutable ();

    /**
     * Sets the value of the member "tStartupSyncPointList".
     *
     * List of all set StartupSyncPoints since last wakeup.
     *
     * @param tStartupSyncPointList The value which will be set
     */
    inline void setTStartupSyncPointList (const ::boost::ptr_vector< ::std::string >& tStartupSyncPointList_);

    /**
     * Release the object stored in the field "tStartupSyncPointList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStartupSyncPointList"
     */
    inline ::boost::ptr_vector< ::std::string >* releaseTStartupSyncPointList();

    /**
     * Replace the field "tStartupSyncPointList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStartupSyncPointList (::boost::ptr_vector< ::std::string >* tStartupSyncPointList_);

    static const ActiveStartUpSyncPointsStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::std::string >& getStringPointerList_DefaultInstance ();

    inline void set_has_tStartupSyncPointList ();

    inline void clear_has_tStartupSyncPointList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::std::string >* _tStartupSyncPointList;

};

/**
 * The status message of the property "CvmEvent"
 * <p>This property informs about voltage level changes. The old CCA CVM mechanism is replaced by this property. If an application is interested in voltage changes an upreg to this property is needed.</p>
 */
class CvmEventStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CvmEventStatus ();

    /**
     * Copy constructor
     */
    inline  CvmEventStatus (const CvmEventStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CvmEventStatus (::spm_core_fi_types::T_SPM_e32_CVM_EVENT CvmEvent_);

    /**
     * Destructor
     */
    inline virtual  ~CvmEventStatus();

    /**
     * Assignment operator
     */
    inline CvmEventStatus& operator = (const CvmEventStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CvmEventStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CvmEventStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CvmEventStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CvmEventStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CvmEvent"

    static const int kCvmEvent = 0;

    /**
     * Clears the field "CvmEvent".
     *
     * The field will be set to its default value. The hasCvmEvent()
     * method will return false.
     */
    inline void clearCvmEvent();

    /**
     * Checks whether the field "CvmEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCvmEvent()). Otherwise it will return false.
     */
    inline bool hasCvmEvent () const;

    /**
     * Returns the value of the member "CvmEvent".
     *
     * Current critical voltage event.
     *
     * @return The value of the field "CvmEvent"
     */
    inline ::spm_core_fi_types::T_SPM_e32_CVM_EVENT getCvmEvent () const;

    /**
     * Sets the value of the member "CvmEvent".
     *
     * Current critical voltage event.
     *
     * @param CvmEvent The value which will be set
     */
    inline void setCvmEvent (::spm_core_fi_types::T_SPM_e32_CVM_EVENT CvmEvent_);

    static const CvmEventStatus &getDefaultInstance();

private:

    inline void set_has_CvmEvent ();

    inline void clear_has_CvmEvent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_CVM_EVENT _CvmEvent;

};

/**
 * The status message of the property "UBatSense"
 * Current measured voltage level in mV.
 */
class UBatSenseStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UBatSenseStatus ();

    /**
     * Copy constructor
     */
    inline  UBatSenseStatus (const UBatSenseStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UBatSenseStatus (uint16 UBatSense_);

    /**
     * Destructor
     */
    inline virtual  ~UBatSenseStatus();

    /**
     * Assignment operator
     */
    inline UBatSenseStatus& operator = (const UBatSenseStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UBatSenseStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UBatSenseStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UBatSenseStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UBatSenseStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UBatSense"

    static const int kUBatSense = 0;

    /**
     * Clears the field "UBatSense".
     *
     * The field will be set to its default value. The hasUBatSense()
     * method will return false.
     */
    inline void clearUBatSense();

    /**
     * Checks whether the field "UBatSense" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUBatSense()). Otherwise it will return false.
     */
    inline bool hasUBatSense () const;

    /**
     * Returns the value of the member "UBatSense".
     *
     * ADC value of current battery voltage (in mV).
     *
     * @return The value of the field "UBatSense"
     */
    inline uint16 getUBatSense () const;

    /**
     * Sets the value of the member "UBatSense".
     *
     * ADC value of current battery voltage (in mV).
     *
     * @param UBatSense The value which will be set
     */
    inline void setUBatSense (uint16 UBatSense_);

    static const UBatSenseStatus &getDefaultInstance();

private:

    inline void set_has_UBatSense ();

    inline void clear_has_UBatSense ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _UBatSense;

};

/**
 * The status message of the property "CoproState"
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.
 */
class CoproStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CoproStateStatus ();

    /**
     * Copy constructor
     */
    inline  CoproStateStatus (const CoproStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CoproStateStatus (::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE CoproState_);

    /**
     * Destructor
     */
    inline virtual  ~CoproStateStatus();

    /**
     * Assignment operator
     */
    inline CoproStateStatus& operator = (const CoproStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CoproStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CoproStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CoproStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CoproStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CoproState"

    static const int kCoproState = 0;

    /**
     * Clears the field "CoproState".
     *
     * The field will be set to its default value. The hasCoproState()
     * method will return false.
     */
    inline void clearCoproState();

    /**
     * Checks whether the field "CoproState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproState()). Otherwise it will return false.
     */
    inline bool hasCoproState () const;

    /**
     * Returns the value of the member "CoproState".
     *
     * State of COPRO.
     *
     * @return The value of the field "CoproState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE getCoproState () const;

    /**
     * Sets the value of the member "CoproState".
     *
     * State of COPRO.
     *
     * @param CoproState The value which will be set
     */
    inline void setCoproState (::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE CoproState_);

    static const CoproStateStatus &getDefaultInstance();

private:

    inline void set_has_CoproState ();

    inline void clear_has_CoproState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE _CoproState;

};

/**
 * The set message of the property "CoproState"
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.
 */
class CoproStateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CoproStateSet ();

    /**
     * Copy constructor
     */
    inline  CoproStateSet (const CoproStateSet &rhs);

    /**
     * All fields constructor
     */
    inline  CoproStateSet (::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE CoproState_);

    /**
     * Destructor
     */
    inline virtual  ~CoproStateSet();

    /**
     * Assignment operator
     */
    inline CoproStateSet& operator = (const CoproStateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CoproStateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CoproStateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CoproStateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CoproStateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CoproState"

    static const int kCoproState = 0;

    /**
     * Clears the field "CoproState".
     *
     * The field will be set to its default value. The hasCoproState()
     * method will return false.
     */
    inline void clearCoproState();

    /**
     * Checks whether the field "CoproState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproState()). Otherwise it will return false.
     */
    inline bool hasCoproState () const;

    /**
     * Returns the value of the member "CoproState".
     *
     * Set state of COPRO.
     *
     * @return The value of the field "CoproState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE getCoproState () const;

    /**
     * Sets the value of the member "CoproState".
     *
     * Set state of COPRO.
     *
     * @param CoproState The value which will be set
     */
    inline void setCoproState (::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE CoproState_);

    static const CoproStateSet &getDefaultInstance();

private:

    inline void set_has_CoproState ();

    inline void clear_has_CoproState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE _CoproState;

};

/**
 * The status message of the property "DevicePowerOnTime"
 * <p>Operation hour counter. It counts the device power on time in seconds until the end of the products life cycle.</p>
 * <p>- it never has an overflow error</p>
 * <p>- it is not counting when the processor is in "power mode OFF/SLEEP"</p>
 * <p>- it continues counting after a battery loss</p>
 * <p>- it never will be cleared/resetted (only by diagnostic command)</p>
 * <p>values for this counter will be stored:</p>
 * <p>- every 15 minutes</p>
 * <p>- and whenever the processor changes to "power mode OFF/SLEEP"</p>
 * <p>- and after each BurnIn cycle</p>
 */
class DevicePowerOnTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevicePowerOnTimeStatus ();

    /**
     * Copy constructor
     */
    inline  DevicePowerOnTimeStatus (const DevicePowerOnTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DevicePowerOnTimeStatus (uint32 DevicePowerOnTime_);

    /**
     * Destructor
     */
    inline virtual  ~DevicePowerOnTimeStatus();

    /**
     * Assignment operator
     */
    inline DevicePowerOnTimeStatus& operator = (const DevicePowerOnTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePowerOnTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePowerOnTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePowerOnTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePowerOnTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DevicePowerOnTime"

    static const int kDevicePowerOnTime = 0;

    /**
     * Clears the field "DevicePowerOnTime".
     *
     * The field will be set to its default value. The hasDevicePowerOnTime()
     * method will return false.
     */
    inline void clearDevicePowerOnTime();

    /**
     * Checks whether the field "DevicePowerOnTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevicePowerOnTime()). Otherwise it will return false.
     */
    inline bool hasDevicePowerOnTime () const;

    /**
     * Returns the value of the member "DevicePowerOnTime".
     *
     * Current Device Power on time in sec.
     *
     * @return The value of the field "DevicePowerOnTime"
     */
    inline uint32 getDevicePowerOnTime () const;

    /**
     * Sets the value of the member "DevicePowerOnTime".
     *
     * Current Device Power on time in sec.
     *
     * @param DevicePowerOnTime The value which will be set
     */
    inline void setDevicePowerOnTime (uint32 DevicePowerOnTime_);

    static const DevicePowerOnTimeStatus &getDefaultInstance();

private:

    inline void set_has_DevicePowerOnTime ();

    inline void clear_has_DevicePowerOnTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DevicePowerOnTime;

};

/**
 * The set message of the property "DevicePowerOnTime"
 * <p>Operation hour counter. It counts the device power on time in seconds until the end of the products life cycle.</p>
 * <p>- it never has an overflow error</p>
 * <p>- it is not counting when the processor is in "power mode OFF/SLEEP"</p>
 * <p>- it continues counting after a battery loss</p>
 * <p>- it never will be cleared/resetted (only by diagnostic command)</p>
 * <p>values for this counter will be stored:</p>
 * <p>- every 15 minutes</p>
 * <p>- and whenever the processor changes to "power mode OFF/SLEEP"</p>
 * <p>- and after each BurnIn cycle</p>
 */
class DevicePowerOnTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevicePowerOnTimeSet ();

    /**
     * Copy constructor
     */
    inline  DevicePowerOnTimeSet (const DevicePowerOnTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  DevicePowerOnTimeSet (uint32 DevicePowerOnTime_);

    /**
     * Destructor
     */
    inline virtual  ~DevicePowerOnTimeSet();

    /**
     * Assignment operator
     */
    inline DevicePowerOnTimeSet& operator = (const DevicePowerOnTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePowerOnTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePowerOnTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePowerOnTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePowerOnTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DevicePowerOnTime"

    static const int kDevicePowerOnTime = 0;

    /**
     * Clears the field "DevicePowerOnTime".
     *
     * The field will be set to its default value. The hasDevicePowerOnTime()
     * method will return false.
     */
    inline void clearDevicePowerOnTime();

    /**
     * Checks whether the field "DevicePowerOnTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevicePowerOnTime()). Otherwise it will return false.
     */
    inline bool hasDevicePowerOnTime () const;

    /**
     * Returns the value of the member "DevicePowerOnTime".
     *
     * Reset Device Power on time.
     *
     * @return The value of the field "DevicePowerOnTime"
     */
    inline uint32 getDevicePowerOnTime () const;

    /**
     * Sets the value of the member "DevicePowerOnTime".
     *
     * Reset Device Power on time.
     *
     * @param DevicePowerOnTime The value which will be set
     */
    inline void setDevicePowerOnTime (uint32 DevicePowerOnTime_);

    static const DevicePowerOnTimeSet &getDefaultInstance();

private:

    inline void set_has_DevicePowerOnTime ();

    inline void clear_has_DevicePowerOnTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DevicePowerOnTime;

};

/**
 * The status message of the property "LastSystemRuntime"
 * Time in s the system was running in the last power cycle.
 */
class LastSystemRuntimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LastSystemRuntimeStatus ();

    /**
     * Copy constructor
     */
    inline  LastSystemRuntimeStatus (const LastSystemRuntimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LastSystemRuntimeStatus (uint32 u32RunTime_);

    /**
     * Destructor
     */
    inline virtual  ~LastSystemRuntimeStatus();

    /**
     * Assignment operator
     */
    inline LastSystemRuntimeStatus& operator = (const LastSystemRuntimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LastSystemRuntimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LastSystemRuntimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LastSystemRuntimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LastSystemRuntimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32RunTime"

    static const int kU32RunTime = 0;

    /**
     * Clears the field "u32RunTime".
     *
     * The field will be set to its default value. The hasU32RunTime()
     * method will return false.
     */
    inline void clearU32RunTime();

    /**
     * Checks whether the field "u32RunTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32RunTime()). Otherwise it will return false.
     */
    inline bool hasU32RunTime () const;

    /**
     * Returns the value of the member "u32RunTime".
     *
     * If the meaning of "u32RunTime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32RunTime"
     */
    inline uint32 getU32RunTime () const;

    /**
     * Sets the value of the member "u32RunTime".
     *
     * If the meaning of "u32RunTime" isn't clear, then there should be a description here.
     *
     * @param u32RunTime The value which will be set
     */
    inline void setU32RunTime (uint32 u32RunTime_);

    static const LastSystemRuntimeStatus &getDefaultInstance();

private:

    inline void set_has_u32RunTime ();

    inline void clear_has_u32RunTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32RunTime;

};

/**
 * The status message of the property "CurrentSystemRuntime"
 * Time in s the system is currently active.
 */
class CurrentSystemRuntimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentSystemRuntimeStatus ();

    /**
     * Copy constructor
     */
    inline  CurrentSystemRuntimeStatus (const CurrentSystemRuntimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentSystemRuntimeStatus (uint32 u32RunTime_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentSystemRuntimeStatus();

    /**
     * Assignment operator
     */
    inline CurrentSystemRuntimeStatus& operator = (const CurrentSystemRuntimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentSystemRuntimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentSystemRuntimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentSystemRuntimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentSystemRuntimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32RunTime"

    static const int kU32RunTime = 0;

    /**
     * Clears the field "u32RunTime".
     *
     * The field will be set to its default value. The hasU32RunTime()
     * method will return false.
     */
    inline void clearU32RunTime();

    /**
     * Checks whether the field "u32RunTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32RunTime()). Otherwise it will return false.
     */
    inline bool hasU32RunTime () const;

    /**
     * Returns the value of the member "u32RunTime".
     *
     * If the meaning of "u32RunTime" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32RunTime"
     */
    inline uint32 getU32RunTime () const;

    /**
     * Sets the value of the member "u32RunTime".
     *
     * If the meaning of "u32RunTime" isn't clear, then there should be a description here.
     *
     * @param u32RunTime The value which will be set
     */
    inline void setU32RunTime (uint32 u32RunTime_);

    static const CurrentSystemRuntimeStatus &getDefaultInstance();

private:

    inline void set_has_u32RunTime ();

    inline void clear_has_u32RunTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32RunTime;

};

/**
 * The status message of the property "ResetList"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use property "ResetCounter (0x1041)" to get Reset information.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Reset information.</p>
 */
class ResetListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetListStatus ();

    /**
     * Copy constructor
     */
    inline  ResetListStatus (const ResetListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ResetListStatus (::spm_core_fi_types::T_e8_LcmResetReason LastResetReason_, uint8 DateHour_, uint8 DateMinute_, uint8 DateDay_, uint8 DateMonth_, uint16 DateYear_, uint8 CoproResetByHmi_, uint8 CoproResetByUndervoltage_, uint8 HmiResetByCoproStartup_, uint8 HmiResetByCoproRun_, uint8 HmiResetByCoproShutdown_, uint8 HmiResetByHmiWdg_, uint8 HmiResetByHmiApp_, uint8 HmiResetByHmiException_, uint8 HmiResetByHmiExtern_, uint8 HmiResetByHmiDownload_, uint8 HmiResetByHmiDiag_, uint8 FgsResetByHmi_);

    /**
     * Destructor
     */
    inline virtual  ~ResetListStatus();

    /**
     * Assignment operator
     */
    inline ResetListStatus& operator = (const ResetListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LastResetReason"

    static const int kLastResetReason = 0;

    /**
     * Clears the field "LastResetReason".
     *
     * The field will be set to its default value. The hasLastResetReason()
     * method will return false.
     */
    inline void clearLastResetReason();

    /**
     * Checks whether the field "LastResetReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastResetReason()). Otherwise it will return false.
     */
    inline bool hasLastResetReason () const;

    /**
     * Returns the value of the member "LastResetReason".
     *
     * last detected reset reason
     *
     * @return The value of the field "LastResetReason"
     */
    inline ::spm_core_fi_types::T_e8_LcmResetReason getLastResetReason () const;

    /**
     * Sets the value of the member "LastResetReason".
     *
     * last detected reset reason
     *
     * @param LastResetReason The value which will be set
     */
    inline void setLastResetReason (::spm_core_fi_types::T_e8_LcmResetReason LastResetReason_);

    // API of field "DateHour"

    static const int kDateHour = 1;

    /**
     * Clears the field "DateHour".
     *
     * The field will be set to its default value. The hasDateHour()
     * method will return false.
     */
    inline void clearDateHour();

    /**
     * Checks whether the field "DateHour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateHour()). Otherwise it will return false.
     */
    inline bool hasDateHour () const;

    /**
     * Returns the value of the member "DateHour".
     *
     * Date: hour format HH:mm dd.mm.yyyy
     *
     * @return The value of the field "DateHour"
     */
    inline uint8 getDateHour () const;

    /**
     * Sets the value of the member "DateHour".
     *
     * Date: hour format HH:mm dd.mm.yyyy
     *
     * @param DateHour The value which will be set
     */
    inline void setDateHour (uint8 DateHour_);

    // API of field "DateMinute"

    static const int kDateMinute = 2;

    /**
     * Clears the field "DateMinute".
     *
     * The field will be set to its default value. The hasDateMinute()
     * method will return false.
     */
    inline void clearDateMinute();

    /**
     * Checks whether the field "DateMinute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateMinute()). Otherwise it will return false.
     */
    inline bool hasDateMinute () const;

    /**
     * Returns the value of the member "DateMinute".
     *
     * Date: minute format hh:MM dd.mm.yyyy
     *
     * @return The value of the field "DateMinute"
     */
    inline uint8 getDateMinute () const;

    /**
     * Sets the value of the member "DateMinute".
     *
     * Date: minute format hh:MM dd.mm.yyyy
     *
     * @param DateMinute The value which will be set
     */
    inline void setDateMinute (uint8 DateMinute_);

    // API of field "DateDay"

    static const int kDateDay = 3;

    /**
     * Clears the field "DateDay".
     *
     * The field will be set to its default value. The hasDateDay()
     * method will return false.
     */
    inline void clearDateDay();

    /**
     * Checks whether the field "DateDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateDay()). Otherwise it will return false.
     */
    inline bool hasDateDay () const;

    /**
     * Returns the value of the member "DateDay".
     *
     * Date: Day format hh:mm DD.mm.yyyy
     *
     * @return The value of the field "DateDay"
     */
    inline uint8 getDateDay () const;

    /**
     * Sets the value of the member "DateDay".
     *
     * Date: Day format hh:mm DD.mm.yyyy
     *
     * @param DateDay The value which will be set
     */
    inline void setDateDay (uint8 DateDay_);

    // API of field "DateMonth"

    static const int kDateMonth = 4;

    /**
     * Clears the field "DateMonth".
     *
     * The field will be set to its default value. The hasDateMonth()
     * method will return false.
     */
    inline void clearDateMonth();

    /**
     * Checks whether the field "DateMonth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateMonth()). Otherwise it will return false.
     */
    inline bool hasDateMonth () const;

    /**
     * Returns the value of the member "DateMonth".
     *
     * Date: month format hh:mm dd.MM.yyyy
     *
     * @return The value of the field "DateMonth"
     */
    inline uint8 getDateMonth () const;

    /**
     * Sets the value of the member "DateMonth".
     *
     * Date: month format hh:mm dd.MM.yyyy
     *
     * @param DateMonth The value which will be set
     */
    inline void setDateMonth (uint8 DateMonth_);

    // API of field "DateYear"

    static const int kDateYear = 5;

    /**
     * Clears the field "DateYear".
     *
     * The field will be set to its default value. The hasDateYear()
     * method will return false.
     */
    inline void clearDateYear();

    /**
     * Checks whether the field "DateYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateYear()). Otherwise it will return false.
     */
    inline bool hasDateYear () const;

    /**
     * Returns the value of the member "DateYear".
     *
     * Date: year format hh:mm dd.mm.YYYY
     *
     * @return The value of the field "DateYear"
     */
    inline uint16 getDateYear () const;

    /**
     * Sets the value of the member "DateYear".
     *
     * Date: year format hh:mm dd.mm.YYYY
     *
     * @param DateYear The value which will be set
     */
    inline void setDateYear (uint16 DateYear_);

    // API of field "CoproResetByHmi"

    static const int kCoproResetByHmi = 6;

    /**
     * Clears the field "CoproResetByHmi".
     *
     * The field will be set to its default value. The hasCoproResetByHmi()
     * method will return false.
     */
    inline void clearCoproResetByHmi();

    /**
     * Checks whether the field "CoproResetByHmi" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproResetByHmi()). Otherwise it will return false.
     */
    inline bool hasCoproResetByHmi () const;

    /**
     * Returns the value of the member "CoproResetByHmi".
     *
     * Count of all Copro resets triggered by HMI.
     *
     * @return The value of the field "CoproResetByHmi"
     */
    inline uint8 getCoproResetByHmi () const;

    /**
     * Sets the value of the member "CoproResetByHmi".
     *
     * Count of all Copro resets triggered by HMI.
     *
     * @param CoproResetByHmi The value which will be set
     */
    inline void setCoproResetByHmi (uint8 CoproResetByHmi_);

    // API of field "CoproResetByUndervoltage"

    static const int kCoproResetByUndervoltage = 7;

    /**
     * Clears the field "CoproResetByUndervoltage".
     *
     * The field will be set to its default value. The hasCoproResetByUndervoltage()
     * method will return false.
     */
    inline void clearCoproResetByUndervoltage();

    /**
     * Checks whether the field "CoproResetByUndervoltage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproResetByUndervoltage()). Otherwise it will return false.
     */
    inline bool hasCoproResetByUndervoltage () const;

    /**
     * Returns the value of the member "CoproResetByUndervoltage".
     *
     * Count of all Copro resets caused by undervoltage.
     *
     * @return The value of the field "CoproResetByUndervoltage"
     */
    inline uint8 getCoproResetByUndervoltage () const;

    /**
     * Sets the value of the member "CoproResetByUndervoltage".
     *
     * Count of all Copro resets caused by undervoltage.
     *
     * @param CoproResetByUndervoltage The value which will be set
     */
    inline void setCoproResetByUndervoltage (uint8 CoproResetByUndervoltage_);

    // API of field "HmiResetByCoproStartup"

    static const int kHmiResetByCoproStartup = 8;

    /**
     * Clears the field "HmiResetByCoproStartup".
     *
     * The field will be set to its default value. The hasHmiResetByCoproStartup()
     * method will return false.
     */
    inline void clearHmiResetByCoproStartup();

    /**
     * Checks whether the field "HmiResetByCoproStartup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByCoproStartup()). Otherwise it will return false.
     */
    inline bool hasHmiResetByCoproStartup () const;

    /**
     * Returns the value of the member "HmiResetByCoproStartup".
     *
     * Count of all in the startup detected resets triggered by the Copro.
     *
     * @return The value of the field "HmiResetByCoproStartup"
     */
    inline uint8 getHmiResetByCoproStartup () const;

    /**
     * Sets the value of the member "HmiResetByCoproStartup".
     *
     * Count of all in the startup detected resets triggered by the Copro.
     *
     * @param HmiResetByCoproStartup The value which will be set
     */
    inline void setHmiResetByCoproStartup (uint8 HmiResetByCoproStartup_);

    // API of field "HmiResetByCoproRun"

    static const int kHmiResetByCoproRun = 9;

    /**
     * Clears the field "HmiResetByCoproRun".
     *
     * The field will be set to its default value. The hasHmiResetByCoproRun()
     * method will return false.
     */
    inline void clearHmiResetByCoproRun();

    /**
     * Checks whether the field "HmiResetByCoproRun" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByCoproRun()). Otherwise it will return false.
     */
    inline bool hasHmiResetByCoproRun () const;

    /**
     * Returns the value of the member "HmiResetByCoproRun".
     *
     * Count of all in normal running mode detected resets triggered by the Copro.
     *
     * @return The value of the field "HmiResetByCoproRun"
     */
    inline uint8 getHmiResetByCoproRun () const;

    /**
     * Sets the value of the member "HmiResetByCoproRun".
     *
     * Count of all in normal running mode detected resets triggered by the Copro.
     *
     * @param HmiResetByCoproRun The value which will be set
     */
    inline void setHmiResetByCoproRun (uint8 HmiResetByCoproRun_);

    // API of field "HmiResetByCoproShutdown"

    static const int kHmiResetByCoproShutdown = 10;

    /**
     * Clears the field "HmiResetByCoproShutdown".
     *
     * The field will be set to its default value. The hasHmiResetByCoproShutdown()
     * method will return false.
     */
    inline void clearHmiResetByCoproShutdown();

    /**
     * Checks whether the field "HmiResetByCoproShutdown" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByCoproShutdown()). Otherwise it will return false.
     */
    inline bool hasHmiResetByCoproShutdown () const;

    /**
     * Returns the value of the member "HmiResetByCoproShutdown".
     *
     * Count of all in the shutdown detected resets triggered by the Copro.
     *
     * @return The value of the field "HmiResetByCoproShutdown"
     */
    inline uint8 getHmiResetByCoproShutdown () const;

    /**
     * Sets the value of the member "HmiResetByCoproShutdown".
     *
     * Count of all in the shutdown detected resets triggered by the Copro.
     *
     * @param HmiResetByCoproShutdown The value which will be set
     */
    inline void setHmiResetByCoproShutdown (uint8 HmiResetByCoproShutdown_);

    // API of field "HmiResetByHmiWdg"

    static const int kHmiResetByHmiWdg = 11;

    /**
     * Clears the field "HmiResetByHmiWdg".
     *
     * The field will be set to its default value. The hasHmiResetByHmiWdg()
     * method will return false.
     */
    inline void clearHmiResetByHmiWdg();

    /**
     * Checks whether the field "HmiResetByHmiWdg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiWdg()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiWdg () const;

    /**
     * Returns the value of the member "HmiResetByHmiWdg".
     *
     * Count of all ApplicationProcessor watchdog resets.
     *
     * @return The value of the field "HmiResetByHmiWdg"
     */
    inline uint8 getHmiResetByHmiWdg () const;

    /**
     * Sets the value of the member "HmiResetByHmiWdg".
     *
     * Count of all ApplicationProcessor watchdog resets.
     *
     * @param HmiResetByHmiWdg The value which will be set
     */
    inline void setHmiResetByHmiWdg (uint8 HmiResetByHmiWdg_);

    // API of field "HmiResetByHmiApp"

    static const int kHmiResetByHmiApp = 12;

    /**
     * Clears the field "HmiResetByHmiApp".
     *
     * The field will be set to its default value. The hasHmiResetByHmiApp()
     * method will return false.
     */
    inline void clearHmiResetByHmiApp();

    /**
     * Checks whether the field "HmiResetByHmiApp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiApp()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiApp () const;

    /**
     * Returns the value of the member "HmiResetByHmiApp".
     *
     * Count of all ApplicationProcessor resets caused by application fault.
     *
     * @return The value of the field "HmiResetByHmiApp"
     */
    inline uint8 getHmiResetByHmiApp () const;

    /**
     * Sets the value of the member "HmiResetByHmiApp".
     *
     * Count of all ApplicationProcessor resets caused by application fault.
     *
     * @param HmiResetByHmiApp The value which will be set
     */
    inline void setHmiResetByHmiApp (uint8 HmiResetByHmiApp_);

    // API of field "HmiResetByHmiException"

    static const int kHmiResetByHmiException = 13;

    /**
     * Clears the field "HmiResetByHmiException".
     *
     * The field will be set to its default value. The hasHmiResetByHmiException()
     * method will return false.
     */
    inline void clearHmiResetByHmiException();

    /**
     * Checks whether the field "HmiResetByHmiException" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiException()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiException () const;

    /**
     * Returns the value of the member "HmiResetByHmiException".
     *
     * Count of all ApplicationProcessor resets caused by an exception.
     *
     * @return The value of the field "HmiResetByHmiException"
     */
    inline uint8 getHmiResetByHmiException () const;

    /**
     * Sets the value of the member "HmiResetByHmiException".
     *
     * Count of all ApplicationProcessor resets caused by an exception.
     *
     * @param HmiResetByHmiException The value which will be set
     */
    inline void setHmiResetByHmiException (uint8 HmiResetByHmiException_);

    // API of field "HmiResetByHmiExtern"

    static const int kHmiResetByHmiExtern = 14;

    /**
     * Clears the field "HmiResetByHmiExtern".
     *
     * The field will be set to its default value. The hasHmiResetByHmiExtern()
     * method will return false.
     */
    inline void clearHmiResetByHmiExtern();

    /**
     * Checks whether the field "HmiResetByHmiExtern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiExtern()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiExtern () const;

    /**
     * Returns the value of the member "HmiResetByHmiExtern".
     *
     * Count of all ApplicationProcessor resets caused by extern/unknown.
     *
     * @return The value of the field "HmiResetByHmiExtern"
     */
    inline uint8 getHmiResetByHmiExtern () const;

    /**
     * Sets the value of the member "HmiResetByHmiExtern".
     *
     * Count of all ApplicationProcessor resets caused by extern/unknown.
     *
     * @param HmiResetByHmiExtern The value which will be set
     */
    inline void setHmiResetByHmiExtern (uint8 HmiResetByHmiExtern_);

    // API of field "HmiResetByHmiDownload"

    static const int kHmiResetByHmiDownload = 15;

    /**
     * Clears the field "HmiResetByHmiDownload".
     *
     * The field will be set to its default value. The hasHmiResetByHmiDownload()
     * method will return false.
     */
    inline void clearHmiResetByHmiDownload();

    /**
     * Checks whether the field "HmiResetByHmiDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiDownload()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiDownload () const;

    /**
     * Returns the value of the member "HmiResetByHmiDownload".
     *
     * Count of all ApplicationProcessor resets caused by download.
     *
     * @return The value of the field "HmiResetByHmiDownload"
     */
    inline uint8 getHmiResetByHmiDownload () const;

    /**
     * Sets the value of the member "HmiResetByHmiDownload".
     *
     * Count of all ApplicationProcessor resets caused by download.
     *
     * @param HmiResetByHmiDownload The value which will be set
     */
    inline void setHmiResetByHmiDownload (uint8 HmiResetByHmiDownload_);

    // API of field "HmiResetByHmiDiag"

    static const int kHmiResetByHmiDiag = 16;

    /**
     * Clears the field "HmiResetByHmiDiag".
     *
     * The field will be set to its default value. The hasHmiResetByHmiDiag()
     * method will return false.
     */
    inline void clearHmiResetByHmiDiag();

    /**
     * Checks whether the field "HmiResetByHmiDiag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiDiag()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiDiag () const;

    /**
     * Returns the value of the member "HmiResetByHmiDiag".
     *
     * Count of all ApplicationProcessor resets caused by diagnostics.
     *
     * @return The value of the field "HmiResetByHmiDiag"
     */
    inline uint8 getHmiResetByHmiDiag () const;

    /**
     * Sets the value of the member "HmiResetByHmiDiag".
     *
     * Count of all ApplicationProcessor resets caused by diagnostics.
     *
     * @param HmiResetByHmiDiag The value which will be set
     */
    inline void setHmiResetByHmiDiag (uint8 HmiResetByHmiDiag_);

    // API of field "FgsResetByHmi"

    static const int kFgsResetByHmi = 17;

    /**
     * Clears the field "FgsResetByHmi".
     *
     * The field will be set to its default value. The hasFgsResetByHmi()
     * method will return false.
     */
    inline void clearFgsResetByHmi();

    /**
     * Checks whether the field "FgsResetByHmi" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFgsResetByHmi()). Otherwise it will return false.
     */
    inline bool hasFgsResetByHmi () const;

    /**
     * Returns the value of the member "FgsResetByHmi".
     *
     * Count of all FGS resets triggered by the HMI.
     *
     * @return The value of the field "FgsResetByHmi"
     */
    inline uint8 getFgsResetByHmi () const;

    /**
     * Sets the value of the member "FgsResetByHmi".
     *
     * Count of all FGS resets triggered by the HMI.
     *
     * @param FgsResetByHmi The value which will be set
     */
    inline void setFgsResetByHmi (uint8 FgsResetByHmi_);

    static const ResetListStatus &getDefaultInstance();

private:

    inline void set_has_LastResetReason ();

    inline void clear_has_LastResetReason ();

    inline void set_has_DateHour ();

    inline void clear_has_DateHour ();

    inline void set_has_DateMinute ();

    inline void clear_has_DateMinute ();

    inline void set_has_DateDay ();

    inline void clear_has_DateDay ();

    inline void set_has_DateMonth ();

    inline void clear_has_DateMonth ();

    inline void set_has_DateYear ();

    inline void clear_has_DateYear ();

    inline void set_has_CoproResetByHmi ();

    inline void clear_has_CoproResetByHmi ();

    inline void set_has_CoproResetByUndervoltage ();

    inline void clear_has_CoproResetByUndervoltage ();

    inline void set_has_HmiResetByCoproStartup ();

    inline void clear_has_HmiResetByCoproStartup ();

    inline void set_has_HmiResetByCoproRun ();

    inline void clear_has_HmiResetByCoproRun ();

    inline void set_has_HmiResetByCoproShutdown ();

    inline void clear_has_HmiResetByCoproShutdown ();

    inline void set_has_HmiResetByHmiWdg ();

    inline void clear_has_HmiResetByHmiWdg ();

    inline void set_has_HmiResetByHmiApp ();

    inline void clear_has_HmiResetByHmiApp ();

    inline void set_has_HmiResetByHmiException ();

    inline void clear_has_HmiResetByHmiException ();

    inline void set_has_HmiResetByHmiExtern ();

    inline void clear_has_HmiResetByHmiExtern ();

    inline void set_has_HmiResetByHmiDownload ();

    inline void clear_has_HmiResetByHmiDownload ();

    inline void set_has_HmiResetByHmiDiag ();

    inline void clear_has_HmiResetByHmiDiag ();

    inline void set_has_FgsResetByHmi ();

    inline void clear_has_FgsResetByHmi ();

    uint32 _has_bits_[ (18 + 31) / 32];

    ::spm_core_fi_types::T_e8_LcmResetReason _LastResetReason;

    uint8 _DateHour;

    uint8 _DateMinute;

    uint8 _DateDay;

    uint8 _DateMonth;

    uint16 _DateYear;

    uint8 _CoproResetByHmi;

    uint8 _CoproResetByUndervoltage;

    uint8 _HmiResetByCoproStartup;

    uint8 _HmiResetByCoproRun;

    uint8 _HmiResetByCoproShutdown;

    uint8 _HmiResetByHmiWdg;

    uint8 _HmiResetByHmiApp;

    uint8 _HmiResetByHmiException;

    uint8 _HmiResetByHmiExtern;

    uint8 _HmiResetByHmiDownload;

    uint8 _HmiResetByHmiDiag;

    uint8 _FgsResetByHmi;

};

/**
 * The set message of the property "ResetList"
 * <p>!!! OBSOLETE DO NOT USE ANYMORE !!!</p>
 * <p>-- Use property "ResetCounter (0x1041)" to get Reset information.</p>
 * <p>---------------------------------------------------------------------------------------------------------------------</p>
 * <p>Reset information.</p>
 */
class ResetListSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetListSet ();

    /**
     * Copy constructor
     */
    inline  ResetListSet (const ResetListSet &rhs);

    /**
     * All fields constructor
     */
    inline  ResetListSet (uint32 ResetResetList_);

    /**
     * Destructor
     */
    inline virtual  ~ResetListSet();

    /**
     * Assignment operator
     */
    inline ResetListSet& operator = (const ResetListSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetListSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetListSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetListSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetListSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetResetList"

    static const int kResetResetList = 0;

    /**
     * Clears the field "ResetResetList".
     *
     * The field will be set to its default value. The hasResetResetList()
     * method will return false.
     */
    inline void clearResetResetList();

    /**
     * Checks whether the field "ResetResetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetResetList()). Otherwise it will return false.
     */
    inline bool hasResetResetList () const;

    /**
     * Returns the value of the member "ResetResetList".
     *
     * Reset the reset list (value is not checked ).
     *
     * @return The value of the field "ResetResetList"
     */
    inline uint32 getResetResetList () const;

    /**
     * Sets the value of the member "ResetResetList".
     *
     * Reset the reset list (value is not checked ).
     *
     * @param ResetResetList The value which will be set
     */
    inline void setResetResetList (uint32 ResetResetList_);

    static const ResetListSet &getDefaultInstance();

private:

    inline void set_has_ResetResetList ();

    inline void clear_has_ResetResetList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResetResetList;

};

/**
 * The status message of the property "ResetCounter"
 * Information about detected reset reasons.
 */
class ResetCounterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetCounterStatus ();

    /**
     * Copy constructor
     */
    inline  ResetCounterStatus (const ResetCounterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ResetCounterStatus (const ::spm_core_fi_types::TTimeDate& tLastResetDate_, ::spm_core_fi_types::T_e8_LcmResetReason tLastResetReason_, uint32 u32ApApplicationError_, uint32 u32ApSoftware_, uint32 u32ApEcuReset_, uint32 u32ApDownload_, uint32 u32ApDownloadError_, uint32 u32ApOvertemperature_, uint32 u32ApUser_, uint32 u32ApLcmIntern_, uint32 u32ApWarmstartCount_, uint32 u32ApPowerOnCount_, uint32 u32ApPowerLossCount_, uint32 u32ApPowerOffCount_, uint32 u32ApSccCount_, uint32 u32ApUnknownCount_, uint32 u32SccHwWdtCount_, uint32 u32SccPowerOnCount_, uint32 u32SccColdstartCount_, uint32 u32SccAppmodeChangeCount_, uint32 u32SccDuringLpwCount_, uint32 u32SccDuringPllOszCount_, uint32 u32SccDuringSWCount_, uint32 u32SccWarmstartCount_);

    /**
     * Destructor
     */
    inline virtual  ~ResetCounterStatus();

    /**
     * Assignment operator
     */
    inline ResetCounterStatus& operator = (const ResetCounterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetCounterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetCounterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetCounterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetCounterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tLastResetDate"

    static const int kTLastResetDate = 0;

    /**
     * Clears the field "tLastResetDate".
     *
     * The field will be set to its default value. The hasTLastResetDate()
     * method will return false.
     */
    inline void clearTLastResetDate();

    /**
     * Checks whether the field "tLastResetDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetDate()). Otherwise it will return false.
     */
    inline bool hasTLastResetDate () const;

    /**
     * Returns the value of the member "tLastResetDate".
     *
     * If the meaning of "tLastResetDate" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tLastResetDate"
     */
    inline const ::spm_core_fi_types::TTimeDate& getTLastResetDate () const;

    /**
     * Retrieves the value of the field "tLastResetDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tLastResetDate".
     */
    inline ::spm_core_fi_types::TTimeDate& getTLastResetDateMutable ();

    /**
     * Sets the value of the member "tLastResetDate".
     *
     * If the meaning of "tLastResetDate" isn't clear, then there should be a description here.
     *
     * @param tLastResetDate The value which will be set
     */
    inline void setTLastResetDate (const ::spm_core_fi_types::TTimeDate& tLastResetDate_);

    /**
     * Release the object stored in the field "tLastResetDate".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tLastResetDate"
     */
    inline ::spm_core_fi_types::TTimeDate* releaseTLastResetDate();

    /**
     * Replace the field "tLastResetDate".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTLastResetDate (::spm_core_fi_types::TTimeDate* tLastResetDate_);

    // API of field "tLastResetReason"

    static const int kTLastResetReason = 1;

    /**
     * Clears the field "tLastResetReason".
     *
     * The field will be set to its default value. The hasTLastResetReason()
     * method will return false.
     */
    inline void clearTLastResetReason();

    /**
     * Checks whether the field "tLastResetReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetReason()). Otherwise it will return false.
     */
    inline bool hasTLastResetReason () const;

    /**
     * Returns the value of the member "tLastResetReason".
     *
     * If the meaning of "tLastResetReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tLastResetReason"
     */
    inline ::spm_core_fi_types::T_e8_LcmResetReason getTLastResetReason () const;

    /**
     * Sets the value of the member "tLastResetReason".
     *
     * If the meaning of "tLastResetReason" isn't clear, then there should be a description here.
     *
     * @param tLastResetReason The value which will be set
     */
    inline void setTLastResetReason (::spm_core_fi_types::T_e8_LcmResetReason tLastResetReason_);

    // API of field "u32ApApplicationError"

    static const int kU32ApApplicationError = 2;

    /**
     * Clears the field "u32ApApplicationError".
     *
     * The field will be set to its default value. The hasU32ApApplicationError()
     * method will return false.
     */
    inline void clearU32ApApplicationError();

    /**
     * Checks whether the field "u32ApApplicationError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApApplicationError()). Otherwise it will return false.
     */
    inline bool hasU32ApApplicationError () const;

    /**
     * Returns the value of the member "u32ApApplicationError".
     *
     * If the meaning of "u32ApApplicationError" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApApplicationError"
     */
    inline uint32 getU32ApApplicationError () const;

    /**
     * Sets the value of the member "u32ApApplicationError".
     *
     * If the meaning of "u32ApApplicationError" isn't clear, then there should be a description here.
     *
     * @param u32ApApplicationError The value which will be set
     */
    inline void setU32ApApplicationError (uint32 u32ApApplicationError_);

    // API of field "u32ApSoftware"

    static const int kU32ApSoftware = 3;

    /**
     * Clears the field "u32ApSoftware".
     *
     * The field will be set to its default value. The hasU32ApSoftware()
     * method will return false.
     */
    inline void clearU32ApSoftware();

    /**
     * Checks whether the field "u32ApSoftware" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSoftware()). Otherwise it will return false.
     */
    inline bool hasU32ApSoftware () const;

    /**
     * Returns the value of the member "u32ApSoftware".
     *
     * If the meaning of "u32ApSoftware" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApSoftware"
     */
    inline uint32 getU32ApSoftware () const;

    /**
     * Sets the value of the member "u32ApSoftware".
     *
     * If the meaning of "u32ApSoftware" isn't clear, then there should be a description here.
     *
     * @param u32ApSoftware The value which will be set
     */
    inline void setU32ApSoftware (uint32 u32ApSoftware_);

    // API of field "u32ApEcuReset"

    static const int kU32ApEcuReset = 4;

    /**
     * Clears the field "u32ApEcuReset".
     *
     * The field will be set to its default value. The hasU32ApEcuReset()
     * method will return false.
     */
    inline void clearU32ApEcuReset();

    /**
     * Checks whether the field "u32ApEcuReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApEcuReset()). Otherwise it will return false.
     */
    inline bool hasU32ApEcuReset () const;

    /**
     * Returns the value of the member "u32ApEcuReset".
     *
     * If the meaning of "u32ApEcuReset" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApEcuReset"
     */
    inline uint32 getU32ApEcuReset () const;

    /**
     * Sets the value of the member "u32ApEcuReset".
     *
     * If the meaning of "u32ApEcuReset" isn't clear, then there should be a description here.
     *
     * @param u32ApEcuReset The value which will be set
     */
    inline void setU32ApEcuReset (uint32 u32ApEcuReset_);

    // API of field "u32ApDownload"

    static const int kU32ApDownload = 5;

    /**
     * Clears the field "u32ApDownload".
     *
     * The field will be set to its default value. The hasU32ApDownload()
     * method will return false.
     */
    inline void clearU32ApDownload();

    /**
     * Checks whether the field "u32ApDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownload()). Otherwise it will return false.
     */
    inline bool hasU32ApDownload () const;

    /**
     * Returns the value of the member "u32ApDownload".
     *
     * If the meaning of "u32ApDownload" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApDownload"
     */
    inline uint32 getU32ApDownload () const;

    /**
     * Sets the value of the member "u32ApDownload".
     *
     * If the meaning of "u32ApDownload" isn't clear, then there should be a description here.
     *
     * @param u32ApDownload The value which will be set
     */
    inline void setU32ApDownload (uint32 u32ApDownload_);

    // API of field "u32ApDownloadError"

    static const int kU32ApDownloadError = 6;

    /**
     * Clears the field "u32ApDownloadError".
     *
     * The field will be set to its default value. The hasU32ApDownloadError()
     * method will return false.
     */
    inline void clearU32ApDownloadError();

    /**
     * Checks whether the field "u32ApDownloadError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownloadError()). Otherwise it will return false.
     */
    inline bool hasU32ApDownloadError () const;

    /**
     * Returns the value of the member "u32ApDownloadError".
     *
     * If the meaning of "u32ApDownloadError" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApDownloadError"
     */
    inline uint32 getU32ApDownloadError () const;

    /**
     * Sets the value of the member "u32ApDownloadError".
     *
     * If the meaning of "u32ApDownloadError" isn't clear, then there should be a description here.
     *
     * @param u32ApDownloadError The value which will be set
     */
    inline void setU32ApDownloadError (uint32 u32ApDownloadError_);

    // API of field "u32ApOvertemperature"

    static const int kU32ApOvertemperature = 7;

    /**
     * Clears the field "u32ApOvertemperature".
     *
     * The field will be set to its default value. The hasU32ApOvertemperature()
     * method will return false.
     */
    inline void clearU32ApOvertemperature();

    /**
     * Checks whether the field "u32ApOvertemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApOvertemperature()). Otherwise it will return false.
     */
    inline bool hasU32ApOvertemperature () const;

    /**
     * Returns the value of the member "u32ApOvertemperature".
     *
     * If the meaning of "u32ApOvertemperature" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApOvertemperature"
     */
    inline uint32 getU32ApOvertemperature () const;

    /**
     * Sets the value of the member "u32ApOvertemperature".
     *
     * If the meaning of "u32ApOvertemperature" isn't clear, then there should be a description here.
     *
     * @param u32ApOvertemperature The value which will be set
     */
    inline void setU32ApOvertemperature (uint32 u32ApOvertemperature_);

    // API of field "u32ApUser"

    static const int kU32ApUser = 8;

    /**
     * Clears the field "u32ApUser".
     *
     * The field will be set to its default value. The hasU32ApUser()
     * method will return false.
     */
    inline void clearU32ApUser();

    /**
     * Checks whether the field "u32ApUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUser()). Otherwise it will return false.
     */
    inline bool hasU32ApUser () const;

    /**
     * Returns the value of the member "u32ApUser".
     *
     * If the meaning of "u32ApUser" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApUser"
     */
    inline uint32 getU32ApUser () const;

    /**
     * Sets the value of the member "u32ApUser".
     *
     * If the meaning of "u32ApUser" isn't clear, then there should be a description here.
     *
     * @param u32ApUser The value which will be set
     */
    inline void setU32ApUser (uint32 u32ApUser_);

    // API of field "u32ApLcmIntern"

    static const int kU32ApLcmIntern = 9;

    /**
     * Clears the field "u32ApLcmIntern".
     *
     * The field will be set to its default value. The hasU32ApLcmIntern()
     * method will return false.
     */
    inline void clearU32ApLcmIntern();

    /**
     * Checks whether the field "u32ApLcmIntern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApLcmIntern()). Otherwise it will return false.
     */
    inline bool hasU32ApLcmIntern () const;

    /**
     * Returns the value of the member "u32ApLcmIntern".
     *
     * If the meaning of "u32ApLcmIntern" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApLcmIntern"
     */
    inline uint32 getU32ApLcmIntern () const;

    /**
     * Sets the value of the member "u32ApLcmIntern".
     *
     * If the meaning of "u32ApLcmIntern" isn't clear, then there should be a description here.
     *
     * @param u32ApLcmIntern The value which will be set
     */
    inline void setU32ApLcmIntern (uint32 u32ApLcmIntern_);

    // API of field "u32ApWarmstartCount"

    static const int kU32ApWarmstartCount = 10;

    /**
     * Clears the field "u32ApWarmstartCount".
     *
     * The field will be set to its default value. The hasU32ApWarmstartCount()
     * method will return false.
     */
    inline void clearU32ApWarmstartCount();

    /**
     * Checks whether the field "u32ApWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32ApWarmstartCount () const;

    /**
     * Returns the value of the member "u32ApWarmstartCount".
     *
     * If the meaning of "u32ApWarmstartCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApWarmstartCount"
     */
    inline uint32 getU32ApWarmstartCount () const;

    /**
     * Sets the value of the member "u32ApWarmstartCount".
     *
     * If the meaning of "u32ApWarmstartCount" isn't clear, then there should be a description here.
     *
     * @param u32ApWarmstartCount The value which will be set
     */
    inline void setU32ApWarmstartCount (uint32 u32ApWarmstartCount_);

    // API of field "u32ApPowerOnCount"

    static const int kU32ApPowerOnCount = 11;

    /**
     * Clears the field "u32ApPowerOnCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOnCount()
     * method will return false.
     */
    inline void clearU32ApPowerOnCount();

    /**
     * Checks whether the field "u32ApPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOnCount () const;

    /**
     * Returns the value of the member "u32ApPowerOnCount".
     *
     * If the meaning of "u32ApPowerOnCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApPowerOnCount"
     */
    inline uint32 getU32ApPowerOnCount () const;

    /**
     * Sets the value of the member "u32ApPowerOnCount".
     *
     * If the meaning of "u32ApPowerOnCount" isn't clear, then there should be a description here.
     *
     * @param u32ApPowerOnCount The value which will be set
     */
    inline void setU32ApPowerOnCount (uint32 u32ApPowerOnCount_);

    // API of field "u32ApPowerLossCount"

    static const int kU32ApPowerLossCount = 12;

    /**
     * Clears the field "u32ApPowerLossCount".
     *
     * The field will be set to its default value. The hasU32ApPowerLossCount()
     * method will return false.
     */
    inline void clearU32ApPowerLossCount();

    /**
     * Checks whether the field "u32ApPowerLossCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerLossCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerLossCount () const;

    /**
     * Returns the value of the member "u32ApPowerLossCount".
     *
     * If the meaning of "u32ApPowerLossCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApPowerLossCount"
     */
    inline uint32 getU32ApPowerLossCount () const;

    /**
     * Sets the value of the member "u32ApPowerLossCount".
     *
     * If the meaning of "u32ApPowerLossCount" isn't clear, then there should be a description here.
     *
     * @param u32ApPowerLossCount The value which will be set
     */
    inline void setU32ApPowerLossCount (uint32 u32ApPowerLossCount_);

    // API of field "u32ApPowerOffCount"

    static const int kU32ApPowerOffCount = 13;

    /**
     * Clears the field "u32ApPowerOffCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOffCount()
     * method will return false.
     */
    inline void clearU32ApPowerOffCount();

    /**
     * Checks whether the field "u32ApPowerOffCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOffCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOffCount () const;

    /**
     * Returns the value of the member "u32ApPowerOffCount".
     *
     * If the meaning of "u32ApPowerOffCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApPowerOffCount"
     */
    inline uint32 getU32ApPowerOffCount () const;

    /**
     * Sets the value of the member "u32ApPowerOffCount".
     *
     * If the meaning of "u32ApPowerOffCount" isn't clear, then there should be a description here.
     *
     * @param u32ApPowerOffCount The value which will be set
     */
    inline void setU32ApPowerOffCount (uint32 u32ApPowerOffCount_);

    // API of field "u32ApSccCount"

    static const int kU32ApSccCount = 14;

    /**
     * Clears the field "u32ApSccCount".
     *
     * The field will be set to its default value. The hasU32ApSccCount()
     * method will return false.
     */
    inline void clearU32ApSccCount();

    /**
     * Checks whether the field "u32ApSccCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSccCount()). Otherwise it will return false.
     */
    inline bool hasU32ApSccCount () const;

    /**
     * Returns the value of the member "u32ApSccCount".
     *
     * If the meaning of "u32ApSccCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApSccCount"
     */
    inline uint32 getU32ApSccCount () const;

    /**
     * Sets the value of the member "u32ApSccCount".
     *
     * If the meaning of "u32ApSccCount" isn't clear, then there should be a description here.
     *
     * @param u32ApSccCount The value which will be set
     */
    inline void setU32ApSccCount (uint32 u32ApSccCount_);

    // API of field "u32ApUnknownCount"

    static const int kU32ApUnknownCount = 15;

    /**
     * Clears the field "u32ApUnknownCount".
     *
     * The field will be set to its default value. The hasU32ApUnknownCount()
     * method will return false.
     */
    inline void clearU32ApUnknownCount();

    /**
     * Checks whether the field "u32ApUnknownCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUnknownCount()). Otherwise it will return false.
     */
    inline bool hasU32ApUnknownCount () const;

    /**
     * Returns the value of the member "u32ApUnknownCount".
     *
     * If the meaning of "u32ApUnknownCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ApUnknownCount"
     */
    inline uint32 getU32ApUnknownCount () const;

    /**
     * Sets the value of the member "u32ApUnknownCount".
     *
     * If the meaning of "u32ApUnknownCount" isn't clear, then there should be a description here.
     *
     * @param u32ApUnknownCount The value which will be set
     */
    inline void setU32ApUnknownCount (uint32 u32ApUnknownCount_);

    // API of field "u32SccHwWdtCount"

    static const int kU32SccHwWdtCount = 16;

    /**
     * Clears the field "u32SccHwWdtCount".
     *
     * The field will be set to its default value. The hasU32SccHwWdtCount()
     * method will return false.
     */
    inline void clearU32SccHwWdtCount();

    /**
     * Checks whether the field "u32SccHwWdtCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccHwWdtCount()). Otherwise it will return false.
     */
    inline bool hasU32SccHwWdtCount () const;

    /**
     * Returns the value of the member "u32SccHwWdtCount".
     *
     * If the meaning of "u32SccHwWdtCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccHwWdtCount"
     */
    inline uint32 getU32SccHwWdtCount () const;

    /**
     * Sets the value of the member "u32SccHwWdtCount".
     *
     * If the meaning of "u32SccHwWdtCount" isn't clear, then there should be a description here.
     *
     * @param u32SccHwWdtCount The value which will be set
     */
    inline void setU32SccHwWdtCount (uint32 u32SccHwWdtCount_);

    // API of field "u32SccPowerOnCount"

    static const int kU32SccPowerOnCount = 17;

    /**
     * Clears the field "u32SccPowerOnCount".
     *
     * The field will be set to its default value. The hasU32SccPowerOnCount()
     * method will return false.
     */
    inline void clearU32SccPowerOnCount();

    /**
     * Checks whether the field "u32SccPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32SccPowerOnCount () const;

    /**
     * Returns the value of the member "u32SccPowerOnCount".
     *
     * If the meaning of "u32SccPowerOnCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccPowerOnCount"
     */
    inline uint32 getU32SccPowerOnCount () const;

    /**
     * Sets the value of the member "u32SccPowerOnCount".
     *
     * If the meaning of "u32SccPowerOnCount" isn't clear, then there should be a description here.
     *
     * @param u32SccPowerOnCount The value which will be set
     */
    inline void setU32SccPowerOnCount (uint32 u32SccPowerOnCount_);

    // API of field "u32SccColdstartCount"

    static const int kU32SccColdstartCount = 18;

    /**
     * Clears the field "u32SccColdstartCount".
     *
     * The field will be set to its default value. The hasU32SccColdstartCount()
     * method will return false.
     */
    inline void clearU32SccColdstartCount();

    /**
     * Checks whether the field "u32SccColdstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccColdstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccColdstartCount () const;

    /**
     * Returns the value of the member "u32SccColdstartCount".
     *
     * If the meaning of "u32SccColdstartCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccColdstartCount"
     */
    inline uint32 getU32SccColdstartCount () const;

    /**
     * Sets the value of the member "u32SccColdstartCount".
     *
     * If the meaning of "u32SccColdstartCount" isn't clear, then there should be a description here.
     *
     * @param u32SccColdstartCount The value which will be set
     */
    inline void setU32SccColdstartCount (uint32 u32SccColdstartCount_);

    // API of field "u32SccAppmodeChangeCount"

    static const int kU32SccAppmodeChangeCount = 19;

    /**
     * Clears the field "u32SccAppmodeChangeCount".
     *
     * The field will be set to its default value. The hasU32SccAppmodeChangeCount()
     * method will return false.
     */
    inline void clearU32SccAppmodeChangeCount();

    /**
     * Checks whether the field "u32SccAppmodeChangeCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccAppmodeChangeCount()). Otherwise it will return false.
     */
    inline bool hasU32SccAppmodeChangeCount () const;

    /**
     * Returns the value of the member "u32SccAppmodeChangeCount".
     *
     * If the meaning of "u32SccAppmodeChangeCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccAppmodeChangeCount"
     */
    inline uint32 getU32SccAppmodeChangeCount () const;

    /**
     * Sets the value of the member "u32SccAppmodeChangeCount".
     *
     * If the meaning of "u32SccAppmodeChangeCount" isn't clear, then there should be a description here.
     *
     * @param u32SccAppmodeChangeCount The value which will be set
     */
    inline void setU32SccAppmodeChangeCount (uint32 u32SccAppmodeChangeCount_);

    // API of field "u32SccDuringLpwCount"

    static const int kU32SccDuringLpwCount = 20;

    /**
     * Clears the field "u32SccDuringLpwCount".
     *
     * The field will be set to its default value. The hasU32SccDuringLpwCount()
     * method will return false.
     */
    inline void clearU32SccDuringLpwCount();

    /**
     * Checks whether the field "u32SccDuringLpwCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringLpwCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringLpwCount () const;

    /**
     * Returns the value of the member "u32SccDuringLpwCount".
     *
     * If the meaning of "u32SccDuringLpwCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccDuringLpwCount"
     */
    inline uint32 getU32SccDuringLpwCount () const;

    /**
     * Sets the value of the member "u32SccDuringLpwCount".
     *
     * If the meaning of "u32SccDuringLpwCount" isn't clear, then there should be a description here.
     *
     * @param u32SccDuringLpwCount The value which will be set
     */
    inline void setU32SccDuringLpwCount (uint32 u32SccDuringLpwCount_);

    // API of field "u32SccDuringPllOszCount"

    static const int kU32SccDuringPllOszCount = 21;

    /**
     * Clears the field "u32SccDuringPllOszCount".
     *
     * The field will be set to its default value. The hasU32SccDuringPllOszCount()
     * method will return false.
     */
    inline void clearU32SccDuringPllOszCount();

    /**
     * Checks whether the field "u32SccDuringPllOszCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringPllOszCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringPllOszCount () const;

    /**
     * Returns the value of the member "u32SccDuringPllOszCount".
     *
     * If the meaning of "u32SccDuringPllOszCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccDuringPllOszCount"
     */
    inline uint32 getU32SccDuringPllOszCount () const;

    /**
     * Sets the value of the member "u32SccDuringPllOszCount".
     *
     * If the meaning of "u32SccDuringPllOszCount" isn't clear, then there should be a description here.
     *
     * @param u32SccDuringPllOszCount The value which will be set
     */
    inline void setU32SccDuringPllOszCount (uint32 u32SccDuringPllOszCount_);

    // API of field "u32SccDuringSWCount"

    static const int kU32SccDuringSWCount = 22;

    /**
     * Clears the field "u32SccDuringSWCount".
     *
     * The field will be set to its default value. The hasU32SccDuringSWCount()
     * method will return false.
     */
    inline void clearU32SccDuringSWCount();

    /**
     * Checks whether the field "u32SccDuringSWCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringSWCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringSWCount () const;

    /**
     * Returns the value of the member "u32SccDuringSWCount".
     *
     * If the meaning of "u32SccDuringSWCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccDuringSWCount"
     */
    inline uint32 getU32SccDuringSWCount () const;

    /**
     * Sets the value of the member "u32SccDuringSWCount".
     *
     * If the meaning of "u32SccDuringSWCount" isn't clear, then there should be a description here.
     *
     * @param u32SccDuringSWCount The value which will be set
     */
    inline void setU32SccDuringSWCount (uint32 u32SccDuringSWCount_);

    // API of field "u32SccWarmstartCount"

    static const int kU32SccWarmstartCount = 23;

    /**
     * Clears the field "u32SccWarmstartCount".
     *
     * The field will be set to its default value. The hasU32SccWarmstartCount()
     * method will return false.
     */
    inline void clearU32SccWarmstartCount();

    /**
     * Checks whether the field "u32SccWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccWarmstartCount () const;

    /**
     * Returns the value of the member "u32SccWarmstartCount".
     *
     * If the meaning of "u32SccWarmstartCount" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SccWarmstartCount"
     */
    inline uint32 getU32SccWarmstartCount () const;

    /**
     * Sets the value of the member "u32SccWarmstartCount".
     *
     * If the meaning of "u32SccWarmstartCount" isn't clear, then there should be a description here.
     *
     * @param u32SccWarmstartCount The value which will be set
     */
    inline void setU32SccWarmstartCount (uint32 u32SccWarmstartCount_);

    static const ResetCounterStatus &getDefaultInstance();

private:

    inline void set_has_tLastResetDate ();

    inline void clear_has_tLastResetDate ();

    inline void set_has_tLastResetReason ();

    inline void clear_has_tLastResetReason ();

    inline void set_has_u32ApApplicationError ();

    inline void clear_has_u32ApApplicationError ();

    inline void set_has_u32ApSoftware ();

    inline void clear_has_u32ApSoftware ();

    inline void set_has_u32ApEcuReset ();

    inline void clear_has_u32ApEcuReset ();

    inline void set_has_u32ApDownload ();

    inline void clear_has_u32ApDownload ();

    inline void set_has_u32ApDownloadError ();

    inline void clear_has_u32ApDownloadError ();

    inline void set_has_u32ApOvertemperature ();

    inline void clear_has_u32ApOvertemperature ();

    inline void set_has_u32ApUser ();

    inline void clear_has_u32ApUser ();

    inline void set_has_u32ApLcmIntern ();

    inline void clear_has_u32ApLcmIntern ();

    inline void set_has_u32ApWarmstartCount ();

    inline void clear_has_u32ApWarmstartCount ();

    inline void set_has_u32ApPowerOnCount ();

    inline void clear_has_u32ApPowerOnCount ();

    inline void set_has_u32ApPowerLossCount ();

    inline void clear_has_u32ApPowerLossCount ();

    inline void set_has_u32ApPowerOffCount ();

    inline void clear_has_u32ApPowerOffCount ();

    inline void set_has_u32ApSccCount ();

    inline void clear_has_u32ApSccCount ();

    inline void set_has_u32ApUnknownCount ();

    inline void clear_has_u32ApUnknownCount ();

    inline void set_has_u32SccHwWdtCount ();

    inline void clear_has_u32SccHwWdtCount ();

    inline void set_has_u32SccPowerOnCount ();

    inline void clear_has_u32SccPowerOnCount ();

    inline void set_has_u32SccColdstartCount ();

    inline void clear_has_u32SccColdstartCount ();

    inline void set_has_u32SccAppmodeChangeCount ();

    inline void clear_has_u32SccAppmodeChangeCount ();

    inline void set_has_u32SccDuringLpwCount ();

    inline void clear_has_u32SccDuringLpwCount ();

    inline void set_has_u32SccDuringPllOszCount ();

    inline void clear_has_u32SccDuringPllOszCount ();

    inline void set_has_u32SccDuringSWCount ();

    inline void clear_has_u32SccDuringSWCount ();

    inline void set_has_u32SccWarmstartCount ();

    inline void clear_has_u32SccWarmstartCount ();

    uint32 _has_bits_[ (24 + 31) / 32];

    ::spm_core_fi_types::TTimeDate* _tLastResetDate;

    ::spm_core_fi_types::T_e8_LcmResetReason _tLastResetReason;

    uint32 _u32ApApplicationError;

    uint32 _u32ApSoftware;

    uint32 _u32ApEcuReset;

    uint32 _u32ApDownload;

    uint32 _u32ApDownloadError;

    uint32 _u32ApOvertemperature;

    uint32 _u32ApUser;

    uint32 _u32ApLcmIntern;

    uint32 _u32ApWarmstartCount;

    uint32 _u32ApPowerOnCount;

    uint32 _u32ApPowerLossCount;

    uint32 _u32ApPowerOffCount;

    uint32 _u32ApSccCount;

    uint32 _u32ApUnknownCount;

    uint32 _u32SccHwWdtCount;

    uint32 _u32SccPowerOnCount;

    uint32 _u32SccColdstartCount;

    uint32 _u32SccAppmodeChangeCount;

    uint32 _u32SccDuringLpwCount;

    uint32 _u32SccDuringPllOszCount;

    uint32 _u32SccDuringSWCount;

    uint32 _u32SccWarmstartCount;

};

/**
 * The set message of the property "ResetCounter"
 * Information about detected reset reasons.
 */
class ResetCounterSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetCounterSet ();

    /**
     * Copy constructor
     */
    inline  ResetCounterSet (const ResetCounterSet &rhs);

    /**
     * All fields constructor
     */
    inline  ResetCounterSet (uint32 ResetCounter_);

    /**
     * Destructor
     */
    inline virtual  ~ResetCounterSet();

    /**
     * Assignment operator
     */
    inline ResetCounterSet& operator = (const ResetCounterSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetCounterSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetCounterSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetCounterSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetCounterSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetCounter"

    static const int kResetCounter = 0;

    /**
     * Clears the field "ResetCounter".
     *
     * The field will be set to its default value. The hasResetCounter()
     * method will return false.
     */
    inline void clearResetCounter();

    /**
     * Checks whether the field "ResetCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetCounter()). Otherwise it will return false.
     */
    inline bool hasResetCounter () const;

    /**
     * Returns the value of the member "ResetCounter".
     *
     * Reset the reset list (value is not checked ).
     *
     * @return The value of the field "ResetCounter"
     */
    inline uint32 getResetCounter () const;

    /**
     * Sets the value of the member "ResetCounter".
     *
     * Reset the reset list (value is not checked ).
     *
     * @param ResetCounter The value which will be set
     */
    inline void setResetCounter (uint32 ResetCounter_);

    static const ResetCounterSet &getDefaultInstance();

private:

    inline void set_has_ResetCounter ();

    inline void clear_has_ResetCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResetCounter;

};

/**
 * The status message of the property "TransportModeList"
 * History of recent Transportmode trigger.
 */
class TransportModeListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransportModeListStatus ();

    /**
     * Copy constructor
     */
    inline  TransportModeListStatus (const TransportModeListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TransportModeListStatus (const ::spm_core_fi_types::T_SPM_TransPortModeList& TransportModeList_);

    /**
     * Destructor
     */
    inline virtual  ~TransportModeListStatus();

    /**
     * Assignment operator
     */
    inline TransportModeListStatus& operator = (const TransportModeListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransportModeListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransportModeListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransportModeListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransportModeListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TransportModeList"

    static const int kTransportModeList = 0;

    /**
     * Clears the field "TransportModeList".
     *
     * The field will be set to its default value. The hasTransportModeList()
     * method will return false.
     */
    inline void clearTransportModeList();

    /**
     * Checks whether the field "TransportModeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransportModeList()). Otherwise it will return false.
     */
    inline bool hasTransportModeList () const;

    /**
     * Returns the value of the member "TransportModeList".
     *
     * List of last 10 transportmode requests.
     *
     * @return The value of the field "TransportModeList"
     */
    inline const ::spm_core_fi_types::T_SPM_TransPortModeList& getTransportModeList () const;

    /**
     * Retrieves the value of the field "TransportModeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TransportModeList".
     */
    inline ::spm_core_fi_types::T_SPM_TransPortModeList& getTransportModeListMutable ();

    /**
     * Sets the value of the member "TransportModeList".
     *
     * List of last 10 transportmode requests.
     *
     * @param TransportModeList The value which will be set
     */
    inline void setTransportModeList (const ::spm_core_fi_types::T_SPM_TransPortModeList& TransportModeList_);

    /**
     * Release the object stored in the field "TransportModeList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "TransportModeList"
     */
    inline ::spm_core_fi_types::T_SPM_TransPortModeList* releaseTransportModeList();

    /**
     * Replace the field "TransportModeList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTransportModeList (::spm_core_fi_types::T_SPM_TransPortModeList* TransportModeList_);

    static const TransportModeListStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_TransPortMode >& getT_SPM_TransPortModePointerList_DefaultInstance ();

    inline void set_has_TransportModeList ();

    inline void clear_has_TransportModeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_TransPortModeList* _TransportModeList;

};

/**
 * The set message of the property "TransportModeList"
 * History of recent Transportmode trigger.
 */
class TransportModeListSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransportModeListSet ();

    /**
     * Copy constructor
     */
    inline  TransportModeListSet (const TransportModeListSet &rhs);

    /**
     * All fields constructor
     */
    inline  TransportModeListSet (uint32 TransPortList_);

    /**
     * Destructor
     */
    inline virtual  ~TransportModeListSet();

    /**
     * Assignment operator
     */
    inline TransportModeListSet& operator = (const TransportModeListSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransportModeListSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransportModeListSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransportModeListSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransportModeListSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TransPortList"

    static const int kTransPortList = 0;

    /**
     * Clears the field "TransPortList".
     *
     * The field will be set to its default value. The hasTransPortList()
     * method will return false.
     */
    inline void clearTransPortList();

    /**
     * Checks whether the field "TransPortList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransPortList()). Otherwise it will return false.
     */
    inline bool hasTransPortList () const;

    /**
     * Returns the value of the member "TransPortList".
     *
     * Reset the TransportMode history list (value is not checked ).
     *
     * @return The value of the field "TransPortList"
     */
    inline uint32 getTransPortList () const;

    /**
     * Sets the value of the member "TransPortList".
     *
     * Reset the TransportMode history list (value is not checked ).
     *
     * @param TransPortList The value which will be set
     */
    inline void setTransPortList (uint32 TransPortList_);

    static const TransportModeListSet &getDefaultInstance();

private:

    inline void set_has_TransPortList ();

    inline void clear_has_TransPortList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _TransPortList;

};

/**
 * The status message of the property "ResetHistory"
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).
 */
class ResetHistoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetHistoryStatus ();

    /**
     * Copy constructor
     */
    inline  ResetHistoryStatus (const ResetHistoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ResetHistoryStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& tResetList_);

    /**
     * Destructor
     */
    inline virtual  ~ResetHistoryStatus();

    /**
     * Assignment operator
     */
    inline ResetHistoryStatus& operator = (const ResetHistoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetHistoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetHistoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetHistoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetHistoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tResetList"

    static const int kTResetList = 0;

    /**
     * Clears the field "tResetList".
     *
     * The field will be set to its default value. The hasTResetList()
     * method will return false.
     */
    inline void clearTResetList();

    /**
     * Checks whether the field "tResetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTResetList()). Otherwise it will return false.
     */
    inline bool hasTResetList () const;

    /**
     * Returns the value of the member "tResetList".
     *
     *
     *
     * @return The value of the field "tResetList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& getTResetList () const;

    /**
     * Retrieves the value of the field "tResetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tResetList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& getTResetListMutable ();

    /**
     * Sets the value of the member "tResetList".
     *
     *
     *
     * @param tResetList The value which will be set
     */
    inline void setTResetList (const ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& tResetList_);

    /**
     * Release the object stored in the field "tResetList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tResetList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >* releaseTResetList();

    /**
     * Replace the field "tResetList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTResetList (::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >* tResetList_);

    static const ResetHistoryStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >& getT_ResetElementPointerList_DefaultInstance ();

    inline void set_has_tResetList ();

    inline void clear_has_tResetList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_ResetElement >* _tResetList;

};

/**
 * The status message of the property "WakeupHistory"
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).
 */
class WakeupHistoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupHistoryStatus ();

    /**
     * Copy constructor
     */
    inline  WakeupHistoryStatus (const WakeupHistoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupHistoryStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& tWakeupList_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupHistoryStatus();

    /**
     * Assignment operator
     */
    inline WakeupHistoryStatus& operator = (const WakeupHistoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupHistoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupHistoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupHistoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupHistoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tWakeupList"

    static const int kTWakeupList = 0;

    /**
     * Clears the field "tWakeupList".
     *
     * The field will be set to its default value. The hasTWakeupList()
     * method will return false.
     */
    inline void clearTWakeupList();

    /**
     * Checks whether the field "tWakeupList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeupList()). Otherwise it will return false.
     */
    inline bool hasTWakeupList () const;

    /**
     * Returns the value of the member "tWakeupList".
     *
     *
     *
     * @return The value of the field "tWakeupList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& getTWakeupList () const;

    /**
     * Retrieves the value of the field "tWakeupList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tWakeupList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& getTWakeupListMutable ();

    /**
     * Sets the value of the member "tWakeupList".
     *
     *
     *
     * @param tWakeupList The value which will be set
     */
    inline void setTWakeupList (const ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& tWakeupList_);

    /**
     * Release the object stored in the field "tWakeupList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tWakeupList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >* releaseTWakeupList();

    /**
     * Replace the field "tWakeupList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTWakeupList (::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >* tWakeupList_);

    static const WakeupHistoryStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >& getT_WakeupElementPointerList_DefaultInstance ();

    inline void set_has_tWakeupList ();

    inline void clear_has_tWakeupList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_WakeupElement >* _tWakeupList;

};

/**
 * The status message of the property "StateHistory"
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).
 */
class StateHistoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateHistoryStatus ();

    /**
     * Copy constructor
     */
    inline  StateHistoryStatus (const StateHistoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StateHistoryStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Destructor
     */
    inline virtual  ~StateHistoryStatus();

    /**
     * Assignment operator
     */
    inline StateHistoryStatus& operator = (const StateHistoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateHistoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateHistoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateHistoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateHistoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStateList"

    static const int kTStateList = 0;

    /**
     * Clears the field "tStateList".
     *
     * The field will be set to its default value. The hasTStateList()
     * method will return false.
     */
    inline void clearTStateList();

    /**
     * Checks whether the field "tStateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateList()). Otherwise it will return false.
     */
    inline bool hasTStateList () const;

    /**
     * Returns the value of the member "tStateList".
     *
     *
     *
     * @return The value of the field "tStateList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateList () const;

    /**
     * Retrieves the value of the field "tStateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateListMutable ();

    /**
     * Sets the value of the member "tStateList".
     *
     *
     *
     * @param tStateList The value which will be set
     */
    inline void setTStateList (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Release the object stored in the field "tStateList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* releaseTStateList();

    /**
     * Replace the field "tStateList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateList (::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* tStateList_);

    static const StateHistoryStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_tStateList ();

    inline void clear_has_tStateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* _tStateList;

};

/**
 * The status message of the property "ErrStateHistory01"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
class ErrStateHistory01Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory01Status ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory01Status (const ErrStateHistory01Status &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory01Status (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory01Status();

    /**
     * Assignment operator
     */
    inline ErrStateHistory01Status& operator = (const ErrStateHistory01Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory01Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory01Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory01Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory01Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStateList"

    static const int kTStateList = 0;

    /**
     * Clears the field "tStateList".
     *
     * The field will be set to its default value. The hasTStateList()
     * method will return false.
     */
    inline void clearTStateList();

    /**
     * Checks whether the field "tStateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateList()). Otherwise it will return false.
     */
    inline bool hasTStateList () const;

    /**
     * Returns the value of the member "tStateList".
     *
     *
     *
     * @return The value of the field "tStateList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateList () const;

    /**
     * Retrieves the value of the field "tStateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateListMutable ();

    /**
     * Sets the value of the member "tStateList".
     *
     *
     *
     * @param tStateList The value which will be set
     */
    inline void setTStateList (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Release the object stored in the field "tStateList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* releaseTStateList();

    /**
     * Replace the field "tStateList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateList (::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* tStateList_);

    static const ErrStateHistory01Status &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_tStateList ();

    inline void clear_has_tStateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* _tStateList;

};

/**
 * The status message of the property "ErrStateHistory02"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
class ErrStateHistory02Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory02Status ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory02Status (const ErrStateHistory02Status &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory02Status (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory02Status();

    /**
     * Assignment operator
     */
    inline ErrStateHistory02Status& operator = (const ErrStateHistory02Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory02Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory02Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory02Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory02Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStateList"

    static const int kTStateList = 0;

    /**
     * Clears the field "tStateList".
     *
     * The field will be set to its default value. The hasTStateList()
     * method will return false.
     */
    inline void clearTStateList();

    /**
     * Checks whether the field "tStateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateList()). Otherwise it will return false.
     */
    inline bool hasTStateList () const;

    /**
     * Returns the value of the member "tStateList".
     *
     *
     *
     * @return The value of the field "tStateList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateList () const;

    /**
     * Retrieves the value of the field "tStateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateListMutable ();

    /**
     * Sets the value of the member "tStateList".
     *
     *
     *
     * @param tStateList The value which will be set
     */
    inline void setTStateList (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Release the object stored in the field "tStateList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* releaseTStateList();

    /**
     * Replace the field "tStateList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateList (::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* tStateList_);

    static const ErrStateHistory02Status &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_tStateList ();

    inline void clear_has_tStateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* _tStateList;

};

/**
 * The status message of the property "ErrStateHistory03"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
class ErrStateHistory03Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory03Status ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory03Status (const ErrStateHistory03Status &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory03Status (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory03Status();

    /**
     * Assignment operator
     */
    inline ErrStateHistory03Status& operator = (const ErrStateHistory03Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory03Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory03Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory03Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory03Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStateList"

    static const int kTStateList = 0;

    /**
     * Clears the field "tStateList".
     *
     * The field will be set to its default value. The hasTStateList()
     * method will return false.
     */
    inline void clearTStateList();

    /**
     * Checks whether the field "tStateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateList()). Otherwise it will return false.
     */
    inline bool hasTStateList () const;

    /**
     * Returns the value of the member "tStateList".
     *
     *
     *
     * @return The value of the field "tStateList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateList () const;

    /**
     * Retrieves the value of the field "tStateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateListMutable ();

    /**
     * Sets the value of the member "tStateList".
     *
     *
     *
     * @param tStateList The value which will be set
     */
    inline void setTStateList (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Release the object stored in the field "tStateList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* releaseTStateList();

    /**
     * Replace the field "tStateList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateList (::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* tStateList_);

    static const ErrStateHistory03Status &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_tStateList ();

    inline void clear_has_tStateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* _tStateList;

};

/**
 * The status message of the property "ErrStateHistory04"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
class ErrStateHistory04Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory04Status ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory04Status (const ErrStateHistory04Status &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory04Status (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory04Status();

    /**
     * Assignment operator
     */
    inline ErrStateHistory04Status& operator = (const ErrStateHistory04Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory04Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory04Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory04Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory04Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStateList"

    static const int kTStateList = 0;

    /**
     * Clears the field "tStateList".
     *
     * The field will be set to its default value. The hasTStateList()
     * method will return false.
     */
    inline void clearTStateList();

    /**
     * Checks whether the field "tStateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateList()). Otherwise it will return false.
     */
    inline bool hasTStateList () const;

    /**
     * Returns the value of the member "tStateList".
     *
     *
     *
     * @return The value of the field "tStateList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateList () const;

    /**
     * Retrieves the value of the field "tStateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateListMutable ();

    /**
     * Sets the value of the member "tStateList".
     *
     *
     *
     * @param tStateList The value which will be set
     */
    inline void setTStateList (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Release the object stored in the field "tStateList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* releaseTStateList();

    /**
     * Replace the field "tStateList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateList (::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* tStateList_);

    static const ErrStateHistory04Status &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_tStateList ();

    inline void clear_has_tStateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* _tStateList;

};

/**
 * The status message of the property "ErrStateHistory05"
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).
 */
class ErrStateHistory05Status  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory05Status ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory05Status (const ErrStateHistory05Status &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory05Status (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory05Status();

    /**
     * Assignment operator
     */
    inline ErrStateHistory05Status& operator = (const ErrStateHistory05Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory05Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory05Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory05Status& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory05Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStateList"

    static const int kTStateList = 0;

    /**
     * Clears the field "tStateList".
     *
     * The field will be set to its default value. The hasTStateList()
     * method will return false.
     */
    inline void clearTStateList();

    /**
     * Checks whether the field "tStateList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateList()). Otherwise it will return false.
     */
    inline bool hasTStateList () const;

    /**
     * Returns the value of the member "tStateList".
     *
     *
     *
     * @return The value of the field "tStateList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateList () const;

    /**
     * Retrieves the value of the field "tStateList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStateList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getTStateListMutable ();

    /**
     * Sets the value of the member "tStateList".
     *
     *
     *
     * @param tStateList The value which will be set
     */
    inline void setTStateList (const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& tStateList_);

    /**
     * Release the object stored in the field "tStateList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStateList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* releaseTStateList();

    /**
     * Replace the field "tStateList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStateList (::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* tStateList_);

    static const ErrStateHistory05Status &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >& getT_StateChangeElementPointerList_DefaultInstance ();

    inline void set_has_tStateList ();

    inline void clear_has_tStateList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_StateChangeElement >* _tStateList;

};

/**
 * The status message of the property "SwitchOnHistory"
 * List of ON reasons why target is switched on (display on).
 */
class SwitchOnHistoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchOnHistoryStatus ();

    /**
     * Copy constructor
     */
    inline  SwitchOnHistoryStatus (const SwitchOnHistoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchOnHistoryStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& tSwitchOnList_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchOnHistoryStatus();

    /**
     * Assignment operator
     */
    inline SwitchOnHistoryStatus& operator = (const SwitchOnHistoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchOnHistoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchOnHistoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchOnHistoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchOnHistoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSwitchOnList"

    static const int kTSwitchOnList = 0;

    /**
     * Clears the field "tSwitchOnList".
     *
     * The field will be set to its default value. The hasTSwitchOnList()
     * method will return false.
     */
    inline void clearTSwitchOnList();

    /**
     * Checks whether the field "tSwitchOnList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwitchOnList()). Otherwise it will return false.
     */
    inline bool hasTSwitchOnList () const;

    /**
     * Returns the value of the member "tSwitchOnList".
     *
     *
     *
     * @return The value of the field "tSwitchOnList"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& getTSwitchOnList () const;

    /**
     * Retrieves the value of the field "tSwitchOnList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwitchOnList".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& getTSwitchOnListMutable ();

    /**
     * Sets the value of the member "tSwitchOnList".
     *
     *
     *
     * @param tSwitchOnList The value which will be set
     */
    inline void setTSwitchOnList (const ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& tSwitchOnList_);

    /**
     * Release the object stored in the field "tSwitchOnList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSwitchOnList"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >* releaseTSwitchOnList();

    /**
     * Replace the field "tSwitchOnList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSwitchOnList (::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >* tSwitchOnList_);

    static const SwitchOnHistoryStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >& getT_SwitchOnElementPointerList_DefaultInstance ();

    inline void set_has_tSwitchOnList ();

    inline void clear_has_tSwitchOnList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_SwitchOnElement >* _tSwitchOnList;

};

/**
 * The start message of the method "ClearList"
 * Method to clear engineering date (All at once or a selected one).
 */
class ClearListStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearListStart ();

    /**
     * Copy constructor
     */
    inline  ClearListStart (const ClearListStart &rhs);

    /**
     * All fields constructor
     */
    inline  ClearListStart (::spm_core_fi_types::T_SPM_e32_CLEAR_LIST eList2Clear_);

    /**
     * Destructor
     */
    inline virtual  ~ClearListStart();

    /**
     * Assignment operator
     */
    inline ClearListStart& operator = (const ClearListStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearListStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearListStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearListStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearListStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eList2Clear"

    static const int kEList2Clear = 0;

    /**
     * Clears the field "eList2Clear".
     *
     * The field will be set to its default value. The hasEList2Clear()
     * method will return false.
     */
    inline void clearEList2Clear();

    /**
     * Checks whether the field "eList2Clear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEList2Clear()). Otherwise it will return false.
     */
    inline bool hasEList2Clear () const;

    /**
     * Returns the value of the member "eList2Clear".
     *
     * If the meaning of "eList2Clear" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eList2Clear"
     */
    inline ::spm_core_fi_types::T_SPM_e32_CLEAR_LIST getEList2Clear () const;

    /**
     * Sets the value of the member "eList2Clear".
     *
     * If the meaning of "eList2Clear" isn't clear, then there should be a description here.
     *
     * @param eList2Clear The value which will be set
     */
    inline void setEList2Clear (::spm_core_fi_types::T_SPM_e32_CLEAR_LIST eList2Clear_);

    static const ClearListStart &getDefaultInstance();

private:

    inline void set_has_eList2Clear ();

    inline void clear_has_eList2Clear ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_CLEAR_LIST _eList2Clear;

};

/**
 * The status message of the property "DeviceOnCounter"
 * <p>Counts how often the device was turned ON.</p>
 */
class DeviceOnCounterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceOnCounterStatus ();

    /**
     * Copy constructor
     */
    inline  DeviceOnCounterStatus (const DeviceOnCounterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceOnCounterStatus (uint32 u32DeviceWakeupCount_, uint32 u32DeviceUserOnCount_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceOnCounterStatus();

    /**
     * Assignment operator
     */
    inline DeviceOnCounterStatus& operator = (const DeviceOnCounterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceOnCounterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceOnCounterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceOnCounterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceOnCounterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceWakeupCount"

    static const int kU32DeviceWakeupCount = 0;

    /**
     * Clears the field "u32DeviceWakeupCount".
     *
     * The field will be set to its default value. The hasU32DeviceWakeupCount()
     * method will return false.
     */
    inline void clearU32DeviceWakeupCount();

    /**
     * Checks whether the field "u32DeviceWakeupCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceWakeupCount()). Otherwise it will return false.
     */
    inline bool hasU32DeviceWakeupCount () const;

    /**
     * Returns the value of the member "u32DeviceWakeupCount".
     *
     * Counts how often the application processor was woken up.
     *
     * @return The value of the field "u32DeviceWakeupCount"
     */
    inline uint32 getU32DeviceWakeupCount () const;

    /**
     * Sets the value of the member "u32DeviceWakeupCount".
     *
     * Counts how often the application processor was woken up.
     *
     * @param u32DeviceWakeupCount The value which will be set
     */
    inline void setU32DeviceWakeupCount (uint32 u32DeviceWakeupCount_);

    // API of field "u32DeviceUserOnCount"

    static const int kU32DeviceUserOnCount = 1;

    /**
     * Clears the field "u32DeviceUserOnCount".
     *
     * The field will be set to its default value. The hasU32DeviceUserOnCount()
     * method will return false.
     */
    inline void clearU32DeviceUserOnCount();

    /**
     * Checks whether the field "u32DeviceUserOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceUserOnCount()). Otherwise it will return false.
     */
    inline bool hasU32DeviceUserOnCount () const;

    /**
     * Returns the value of the member "u32DeviceUserOnCount".
     *
     * Counts how often the device was turned UserOn. This might be increased multiple times for one Wakeup.
     *
     * @return The value of the field "u32DeviceUserOnCount"
     */
    inline uint32 getU32DeviceUserOnCount () const;

    /**
     * Sets the value of the member "u32DeviceUserOnCount".
     *
     * Counts how often the device was turned UserOn. This might be increased multiple times for one Wakeup.
     *
     * @param u32DeviceUserOnCount The value which will be set
     */
    inline void setU32DeviceUserOnCount (uint32 u32DeviceUserOnCount_);

    static const DeviceOnCounterStatus &getDefaultInstance();

private:

    inline void set_has_u32DeviceWakeupCount ();

    inline void clear_has_u32DeviceWakeupCount ();

    inline void set_has_u32DeviceUserOnCount ();

    inline void clear_has_u32DeviceUserOnCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32DeviceWakeupCount;

    uint32 _u32DeviceUserOnCount;

};

/**
 * The status message of the property "VoltageEventCounter"
 * Counts system voltage events.
 */
class VoltageEventCounterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltageEventCounterStatus ();

    /**
     * Copy constructor
     */
    inline  VoltageEventCounterStatus (const VoltageEventCounterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VoltageEventCounterStatus (const ::spm_core_fi_types::T_SPM_VoltageEventCounter& tVoltageEventCounter_);

    /**
     * Destructor
     */
    inline virtual  ~VoltageEventCounterStatus();

    /**
     * Assignment operator
     */
    inline VoltageEventCounterStatus& operator = (const VoltageEventCounterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltageEventCounterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltageEventCounterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltageEventCounterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltageEventCounterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tVoltageEventCounter"

    static const int kTVoltageEventCounter = 0;

    /**
     * Clears the field "tVoltageEventCounter".
     *
     * The field will be set to its default value. The hasTVoltageEventCounter()
     * method will return false.
     */
    inline void clearTVoltageEventCounter();

    /**
     * Checks whether the field "tVoltageEventCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTVoltageEventCounter()). Otherwise it will return false.
     */
    inline bool hasTVoltageEventCounter () const;

    /**
     * Returns the value of the member "tVoltageEventCounter".
     *
     * Counter of voltage event (low, cr low, high, cr high) was occurred.
     *
     * @return The value of the field "tVoltageEventCounter"
     */
    inline const ::spm_core_fi_types::T_SPM_VoltageEventCounter& getTVoltageEventCounter () const;

    /**
     * Retrieves the value of the field "tVoltageEventCounter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tVoltageEventCounter".
     */
    inline ::spm_core_fi_types::T_SPM_VoltageEventCounter& getTVoltageEventCounterMutable ();

    /**
     * Sets the value of the member "tVoltageEventCounter".
     *
     * Counter of voltage event (low, cr low, high, cr high) was occurred.
     *
     * @param tVoltageEventCounter The value which will be set
     */
    inline void setTVoltageEventCounter (const ::spm_core_fi_types::T_SPM_VoltageEventCounter& tVoltageEventCounter_);

    /**
     * Release the object stored in the field "tVoltageEventCounter".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tVoltageEventCounter"
     */
    inline ::spm_core_fi_types::T_SPM_VoltageEventCounter* releaseTVoltageEventCounter();

    /**
     * Replace the field "tVoltageEventCounter".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTVoltageEventCounter (::spm_core_fi_types::T_SPM_VoltageEventCounter* tVoltageEventCounter_);

    static const VoltageEventCounterStatus &getDefaultInstance();

private:

    inline void set_has_tVoltageEventCounter ();

    inline void clear_has_tVoltageEventCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_VoltageEventCounter* _tVoltageEventCounter;

};

/**
 * The status message of the property "VoltageRangeHistogram"
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec
 */
class VoltageRangeHistogramStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltageRangeHistogramStatus ();

    /**
     * Copy constructor
     */
    inline  VoltageRangeHistogramStatus (const VoltageRangeHistogramStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VoltageRangeHistogramStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >& listVoltageRangeHistogram_);

    /**
     * Destructor
     */
    inline virtual  ~VoltageRangeHistogramStatus();

    /**
     * Assignment operator
     */
    inline VoltageRangeHistogramStatus& operator = (const VoltageRangeHistogramStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltageRangeHistogramStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltageRangeHistogramStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltageRangeHistogramStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltageRangeHistogramStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "listVoltageRangeHistogram"

    static const int kListVoltageRangeHistogram = 0;

    /**
     * Clears the field "listVoltageRangeHistogram".
     *
     * The field will be set to its default value. The hasListVoltageRangeHistogram()
     * method will return false.
     */
    inline void clearListVoltageRangeHistogram();

    /**
     * Checks whether the field "listVoltageRangeHistogram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListVoltageRangeHistogram()). Otherwise it will return false.
     */
    inline bool hasListVoltageRangeHistogram () const;

    /**
     * Returns the value of the member "listVoltageRangeHistogram".
     *
     * List of all voltage ranges. The stepsize of range is 1000mV. The histogram starts from (0mV, 999mV) to (49000mV, 49999mV)
     *
     * @return The value of the field "listVoltageRangeHistogram"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >& getListVoltageRangeHistogram () const;

    /**
     * Retrieves the value of the field "listVoltageRangeHistogram" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listVoltageRangeHistogram".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >& getListVoltageRangeHistogramMutable ();

    /**
     * Sets the value of the member "listVoltageRangeHistogram".
     *
     * List of all voltage ranges. The stepsize of range is 1000mV. The histogram starts from (0mV, 999mV) to (49000mV, 49999mV)
     *
     * @param listVoltageRangeHistogram The value which will be set
     */
    inline void setListVoltageRangeHistogram (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >& listVoltageRangeHistogram_);

    /**
     * Release the object stored in the field "listVoltageRangeHistogram".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "listVoltageRangeHistogram"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >* releaseListVoltageRangeHistogram();

    /**
     * Replace the field "listVoltageRangeHistogram".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceListVoltageRangeHistogram (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >* listVoltageRangeHistogram_);

    static const VoltageRangeHistogramStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >& getT_SPM_VoltageRangePointerList_DefaultInstance ();

    inline void set_has_listVoltageRangeHistogram ();

    inline void clear_has_listVoltageRangeHistogram ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_VoltageRange >* _listVoltageRangeHistogram;

};

/**
 * The status message of the property "CpuUsageStatistic"
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).
 * The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).
 */
class CpuUsageStatisticStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CpuUsageStatisticStatus ();

    /**
     * Copy constructor
     */
    inline  CpuUsageStatisticStatus (const CpuUsageStatisticStatus &rhs);

    /**
     * All fields constructor
     */
    inline  CpuUsageStatisticStatus (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& tCpuUsageStatisticsData_);

    /**
     * Destructor
     */
    inline virtual  ~CpuUsageStatisticStatus();

    /**
     * Assignment operator
     */
    inline CpuUsageStatisticStatus& operator = (const CpuUsageStatisticStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CpuUsageStatisticStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CpuUsageStatisticStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CpuUsageStatisticStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CpuUsageStatisticStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tCpuUsageStatisticsData"

    static const int kTCpuUsageStatisticsData = 0;

    /**
     * Clears the field "tCpuUsageStatisticsData".
     *
     * The field will be set to its default value. The hasTCpuUsageStatisticsData()
     * method will return false.
     */
    inline void clearTCpuUsageStatisticsData();

    /**
     * Checks whether the field "tCpuUsageStatisticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTCpuUsageStatisticsData()). Otherwise it will return false.
     */
    inline bool hasTCpuUsageStatisticsData () const;

    /**
     * Returns the value of the member "tCpuUsageStatisticsData".
     *
     * Max/Average/Min overall CPU usage of device in %.
     *
     * @return The value of the field "tCpuUsageStatisticsData"
     */
    inline const ::spm_core_fi_types::T_SPM_SystemStatisticsData& getTCpuUsageStatisticsData () const;

    /**
     * Retrieves the value of the field "tCpuUsageStatisticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tCpuUsageStatisticsData".
     */
    inline ::spm_core_fi_types::T_SPM_SystemStatisticsData& getTCpuUsageStatisticsDataMutable ();

    /**
     * Sets the value of the member "tCpuUsageStatisticsData".
     *
     * Max/Average/Min overall CPU usage of device in %.
     *
     * @param tCpuUsageStatisticsData The value which will be set
     */
    inline void setTCpuUsageStatisticsData (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& tCpuUsageStatisticsData_);

    /**
     * Release the object stored in the field "tCpuUsageStatisticsData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tCpuUsageStatisticsData"
     */
    inline ::spm_core_fi_types::T_SPM_SystemStatisticsData* releaseTCpuUsageStatisticsData();

    /**
     * Replace the field "tCpuUsageStatisticsData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTCpuUsageStatisticsData (::spm_core_fi_types::T_SPM_SystemStatisticsData* tCpuUsageStatisticsData_);

    static const CpuUsageStatisticStatus &getDefaultInstance();

private:

    inline void set_has_tCpuUsageStatisticsData ();

    inline void clear_has_tCpuUsageStatisticsData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_SystemStatisticsData* _tCpuUsageStatisticsData;

};

/**
 * The status message of the property "RamUsageStatistic"
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).
 * The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).
 */
class RamUsageStatisticStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RamUsageStatisticStatus ();

    /**
     * Copy constructor
     */
    inline  RamUsageStatisticStatus (const RamUsageStatisticStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RamUsageStatisticStatus (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& tRamUsageStatisticsData_);

    /**
     * Destructor
     */
    inline virtual  ~RamUsageStatisticStatus();

    /**
     * Assignment operator
     */
    inline RamUsageStatisticStatus& operator = (const RamUsageStatisticStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RamUsageStatisticStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RamUsageStatisticStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RamUsageStatisticStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RamUsageStatisticStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tRamUsageStatisticsData"

    static const int kTRamUsageStatisticsData = 0;

    /**
     * Clears the field "tRamUsageStatisticsData".
     *
     * The field will be set to its default value. The hasTRamUsageStatisticsData()
     * method will return false.
     */
    inline void clearTRamUsageStatisticsData();

    /**
     * Checks whether the field "tRamUsageStatisticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTRamUsageStatisticsData()). Otherwise it will return false.
     */
    inline bool hasTRamUsageStatisticsData () const;

    /**
     * Returns the value of the member "tRamUsageStatisticsData".
     *
     * Max/Average/Min overall RAM usage of device in %.
     *
     * @return The value of the field "tRamUsageStatisticsData"
     */
    inline const ::spm_core_fi_types::T_SPM_SystemStatisticsData& getTRamUsageStatisticsData () const;

    /**
     * Retrieves the value of the field "tRamUsageStatisticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tRamUsageStatisticsData".
     */
    inline ::spm_core_fi_types::T_SPM_SystemStatisticsData& getTRamUsageStatisticsDataMutable ();

    /**
     * Sets the value of the member "tRamUsageStatisticsData".
     *
     * Max/Average/Min overall RAM usage of device in %.
     *
     * @param tRamUsageStatisticsData The value which will be set
     */
    inline void setTRamUsageStatisticsData (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& tRamUsageStatisticsData_);

    /**
     * Release the object stored in the field "tRamUsageStatisticsData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tRamUsageStatisticsData"
     */
    inline ::spm_core_fi_types::T_SPM_SystemStatisticsData* releaseTRamUsageStatisticsData();

    /**
     * Replace the field "tRamUsageStatisticsData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTRamUsageStatisticsData (::spm_core_fi_types::T_SPM_SystemStatisticsData* tRamUsageStatisticsData_);

    static const RamUsageStatisticStatus &getDefaultInstance();

private:

    inline void set_has_tRamUsageStatisticsData ();

    inline void clear_has_tRamUsageStatisticsData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_SystemStatisticsData* _tRamUsageStatisticsData;

};

/**
 * The status message of the property "StartupTimeStatistic"
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.
 * The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.
 */
class StartupTimeStatisticStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupTimeStatisticStatus ();

    /**
     * Copy constructor
     */
    inline  StartupTimeStatisticStatus (const StartupTimeStatisticStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StartupTimeStatisticStatus (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& tStartupTimeStatisticsData_);

    /**
     * Destructor
     */
    inline virtual  ~StartupTimeStatisticStatus();

    /**
     * Assignment operator
     */
    inline StartupTimeStatisticStatus& operator = (const StartupTimeStatisticStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupTimeStatisticStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupTimeStatisticStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupTimeStatisticStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupTimeStatisticStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tStartupTimeStatisticsData"

    static const int kTStartupTimeStatisticsData = 0;

    /**
     * Clears the field "tStartupTimeStatisticsData".
     *
     * The field will be set to its default value. The hasTStartupTimeStatisticsData()
     * method will return false.
     */
    inline void clearTStartupTimeStatisticsData();

    /**
     * Checks whether the field "tStartupTimeStatisticsData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStartupTimeStatisticsData()). Otherwise it will return false.
     */
    inline bool hasTStartupTimeStatisticsData () const;

    /**
     * Returns the value of the member "tStartupTimeStatisticsData".
     *
     * Max/Average/Min overall Startup time of device in milliseconds.
     *
     * @return The value of the field "tStartupTimeStatisticsData"
     */
    inline const ::spm_core_fi_types::T_SPM_SystemStatisticsData& getTStartupTimeStatisticsData () const;

    /**
     * Retrieves the value of the field "tStartupTimeStatisticsData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tStartupTimeStatisticsData".
     */
    inline ::spm_core_fi_types::T_SPM_SystemStatisticsData& getTStartupTimeStatisticsDataMutable ();

    /**
     * Sets the value of the member "tStartupTimeStatisticsData".
     *
     * Max/Average/Min overall Startup time of device in milliseconds.
     *
     * @param tStartupTimeStatisticsData The value which will be set
     */
    inline void setTStartupTimeStatisticsData (const ::spm_core_fi_types::T_SPM_SystemStatisticsData& tStartupTimeStatisticsData_);

    /**
     * Release the object stored in the field "tStartupTimeStatisticsData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tStartupTimeStatisticsData"
     */
    inline ::spm_core_fi_types::T_SPM_SystemStatisticsData* releaseTStartupTimeStatisticsData();

    /**
     * Replace the field "tStartupTimeStatisticsData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTStartupTimeStatisticsData (::spm_core_fi_types::T_SPM_SystemStatisticsData* tStartupTimeStatisticsData_);

    static const StartupTimeStatisticStatus &getDefaultInstance();

private:

    inline void set_has_tStartupTimeStatisticsData ();

    inline void clear_has_tStartupTimeStatisticsData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_SystemStatisticsData* _tStartupTimeStatisticsData;

};

/**
 * The status message of the property "SWVersionStatistic"
 * Get all SWVersion Statistic Data which was collected.
 */
class SWVersionStatisticStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SWVersionStatisticStatus ();

    /**
     * Copy constructor
     */
    inline  SWVersionStatisticStatus (const SWVersionStatisticStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SWVersionStatisticStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >& listSWVersionStatistic_);

    /**
     * Destructor
     */
    inline virtual  ~SWVersionStatisticStatus();

    /**
     * Assignment operator
     */
    inline SWVersionStatisticStatus& operator = (const SWVersionStatisticStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SWVersionStatisticStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SWVersionStatisticStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SWVersionStatisticStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SWVersionStatisticStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "listSWVersionStatistic"

    static const int kListSWVersionStatistic = 0;

    /**
     * Clears the field "listSWVersionStatistic".
     *
     * The field will be set to its default value. The hasListSWVersionStatistic()
     * method will return false.
     */
    inline void clearListSWVersionStatistic();

    /**
     * Checks whether the field "listSWVersionStatistic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListSWVersionStatistic()). Otherwise it will return false.
     */
    inline bool hasListSWVersionStatistic () const;

    /**
     * Returns the value of the member "listSWVersionStatistic".
     *
     * List all currently stored SW-Versions Statistic Data. The max size of list is 20 elements
     *
     * @return The value of the field "listSWVersionStatistic"
     */
    inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >& getListSWVersionStatistic () const;

    /**
     * Retrieves the value of the field "listSWVersionStatistic" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "listSWVersionStatistic".
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >& getListSWVersionStatisticMutable ();

    /**
     * Sets the value of the member "listSWVersionStatistic".
     *
     * List all currently stored SW-Versions Statistic Data. The max size of list is 20 elements
     *
     * @param listSWVersionStatistic The value which will be set
     */
    inline void setListSWVersionStatistic (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >& listSWVersionStatistic_);

    /**
     * Release the object stored in the field "listSWVersionStatistic".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "listSWVersionStatistic"
     */
    inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >* releaseListSWVersionStatistic();

    /**
     * Replace the field "listSWVersionStatistic".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceListSWVersionStatistic (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >* listSWVersionStatistic_);

    static const SWVersionStatisticStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >& getT_SPM_SWVersionStatisticDataPointerList_DefaultInstance ();

    inline void set_has_listSWVersionStatistic ();

    inline void clear_has_listSWVersionStatistic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_SWVersionStatisticData >* _listSWVersionStatistic;

};

/**
 * The start message of the method "SpecificSWVersionStatistic"
 * Method request a specific SWVersion Statistic Data  with the index from (0x00 - 0x13)
 */
class SpecificSWVersionStatisticStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpecificSWVersionStatisticStart ();

    /**
     * Copy constructor
     */
    inline  SpecificSWVersionStatisticStart (const SpecificSWVersionStatisticStart &rhs);

    /**
     * All fields constructor
     */
    inline  SpecificSWVersionStatisticStart (uint32 u32Index_);

    /**
     * Destructor
     */
    inline virtual  ~SpecificSWVersionStatisticStart();

    /**
     * Assignment operator
     */
    inline SpecificSWVersionStatisticStart& operator = (const SpecificSWVersionStatisticStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpecificSWVersionStatisticStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpecificSWVersionStatisticStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpecificSWVersionStatisticStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpecificSWVersionStatisticStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Index"

    static const int kU32Index = 0;

    /**
     * Clears the field "u32Index".
     *
     * The field will be set to its default value. The hasU32Index()
     * method will return false.
     */
    inline void clearU32Index();

    /**
     * Checks whether the field "u32Index" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Index()). Otherwise it will return false.
     */
    inline bool hasU32Index () const;

    /**
     * Returns the value of the member "u32Index".
     *
     * If the meaning of "u32Index" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Index"
     */
    inline uint32 getU32Index () const;

    /**
     * Sets the value of the member "u32Index".
     *
     * If the meaning of "u32Index" isn't clear, then there should be a description here.
     *
     * @param u32Index The value which will be set
     */
    inline void setU32Index (uint32 u32Index_);

    static const SpecificSWVersionStatisticStart &getDefaultInstance();

private:

    inline void set_has_u32Index ();

    inline void clear_has_u32Index ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Index;

};

/**
 * The result message of the method "SpecificSWVersionStatistic"
 * Method request a specific SWVersion Statistic Data  with the index from (0x00 - 0x13)
 */
class SpecificSWVersionStatisticResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpecificSWVersionStatisticResult ();

    /**
     * Copy constructor
     */
    inline  SpecificSWVersionStatisticResult (const SpecificSWVersionStatisticResult &rhs);

    /**
     * All fields constructor
     */
    inline  SpecificSWVersionStatisticResult (const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& tSWVersionStatistic_);

    /**
     * Destructor
     */
    inline virtual  ~SpecificSWVersionStatisticResult();

    /**
     * Assignment operator
     */
    inline SpecificSWVersionStatisticResult& operator = (const SpecificSWVersionStatisticResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpecificSWVersionStatisticResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpecificSWVersionStatisticResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpecificSWVersionStatisticResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpecificSWVersionStatisticResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSWVersionStatistic"

    static const int kTSWVersionStatistic = 0;

    /**
     * Clears the field "tSWVersionStatistic".
     *
     * The field will be set to its default value. The hasTSWVersionStatistic()
     * method will return false.
     */
    inline void clearTSWVersionStatistic();

    /**
     * Checks whether the field "tSWVersionStatistic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSWVersionStatistic()). Otherwise it will return false.
     */
    inline bool hasTSWVersionStatistic () const;

    /**
     * Returns the value of the member "tSWVersionStatistic".
     *
     * SW statistic data and software version information.
     *
     * @return The value of the field "tSWVersionStatistic"
     */
    inline const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& getTSWVersionStatistic () const;

    /**
     * Retrieves the value of the field "tSWVersionStatistic" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSWVersionStatistic".
     */
    inline ::spm_core_fi_types::T_SPM_SWVersionStatisticData& getTSWVersionStatisticMutable ();

    /**
     * Sets the value of the member "tSWVersionStatistic".
     *
     * SW statistic data and software version information.
     *
     * @param tSWVersionStatistic The value which will be set
     */
    inline void setTSWVersionStatistic (const ::spm_core_fi_types::T_SPM_SWVersionStatisticData& tSWVersionStatistic_);

    /**
     * Release the object stored in the field "tSWVersionStatistic".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tSWVersionStatistic"
     */
    inline ::spm_core_fi_types::T_SPM_SWVersionStatisticData* releaseTSWVersionStatistic();

    /**
     * Replace the field "tSWVersionStatistic".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTSWVersionStatistic (::spm_core_fi_types::T_SPM_SWVersionStatisticData* tSWVersionStatistic_);

    static const SpecificSWVersionStatisticResult &getDefaultInstance();

private:

    inline void set_has_tSWVersionStatistic ();

    inline void clear_has_tSWVersionStatistic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_SWVersionStatisticData* _tSWVersionStatistic;

};

/**
 * The start message of the method "RestartSystem"
 * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.
 */
class RestartSystemStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartSystemStart ();

    /**
     * Copy constructor
     */
    inline  RestartSystemStart (const RestartSystemStart &rhs);

    /**
     * All fields constructor
     */
    inline  RestartSystemStart (::spm_core_fi_types::T_SPM_e32_RESTART_TYPE eRestartType_);

    /**
     * Destructor
     */
    inline virtual  ~RestartSystemStart();

    /**
     * Assignment operator
     */
    inline RestartSystemStart& operator = (const RestartSystemStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartSystemStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartSystemStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartSystemStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartSystemStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eRestartType"

    static const int kERestartType = 0;

    /**
     * Clears the field "eRestartType".
     *
     * The field will be set to its default value. The hasERestartType()
     * method will return false.
     */
    inline void clearERestartType();

    /**
     * Checks whether the field "eRestartType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERestartType()). Otherwise it will return false.
     */
    inline bool hasERestartType () const;

    /**
     * Returns the value of the member "eRestartType".
     *
     * If the meaning of "eRestartType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eRestartType"
     */
    inline ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE getERestartType () const;

    /**
     * Sets the value of the member "eRestartType".
     *
     * If the meaning of "eRestartType" isn't clear, then there should be a description here.
     *
     * @param eRestartType The value which will be set
     */
    inline void setERestartType (::spm_core_fi_types::T_SPM_e32_RESTART_TYPE eRestartType_);

    static const RestartSystemStart &getDefaultInstance();

private:

    inline void set_has_eRestartType ();

    inline void clear_has_eRestartType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE _eRestartType;

};

/**
 * The result message of the method "RestartSystem"
 * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.
 */
class RestartSystemResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartSystemResult ();

    /**
     * Copy constructor
     */
    inline  RestartSystemResult (const RestartSystemResult &rhs);

    /**
     * All fields constructor
     */
    inline  RestartSystemResult (::spm_core_fi_types::T_SPM_e32_MRESULT e32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~RestartSystemResult();

    /**
     * Assignment operator
     */
    inline RestartSystemResult& operator = (const RestartSystemResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartSystemResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartSystemResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartSystemResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartSystemResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e32ReturnVal"

    static const int kE32ReturnVal = 0;

    /**
     * Clears the field "e32ReturnVal".
     *
     * The field will be set to its default value. The hasE32ReturnVal()
     * method will return false.
     */
    inline void clearE32ReturnVal();

    /**
     * Checks whether the field "e32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasE32ReturnVal () const;

    /**
     * Returns the value of the member "e32ReturnVal".
     *
     * If the meaning of "e32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e32ReturnVal"
     */
    inline ::spm_core_fi_types::T_SPM_e32_MRESULT getE32ReturnVal () const;

    /**
     * Sets the value of the member "e32ReturnVal".
     *
     * If the meaning of "e32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param e32ReturnVal The value which will be set
     */
    inline void setE32ReturnVal (::spm_core_fi_types::T_SPM_e32_MRESULT e32ReturnVal_);

    static const RestartSystemResult &getDefaultInstance();

private:

    inline void set_has_e32ReturnVal ();

    inline void clear_has_e32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_MRESULT _e32ReturnVal;

};

/**
 * The status message of the property "RunlevelState"
 * Informs about the current runlevel of the system.
 */
class RunlevelStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RunlevelStateStatus ();

    /**
     * Copy constructor
     */
    inline  RunlevelStateStatus (const RunlevelStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RunlevelStateStatus (::spm_core_fi_types::T_SPM_e32_RUNLEVEL eRunlevel_);

    /**
     * Destructor
     */
    inline virtual  ~RunlevelStateStatus();

    /**
     * Assignment operator
     */
    inline RunlevelStateStatus& operator = (const RunlevelStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RunlevelStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RunlevelStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RunlevelStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RunlevelStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eRunlevel"

    static const int kERunlevel = 0;

    /**
     * Clears the field "eRunlevel".
     *
     * The field will be set to its default value. The hasERunlevel()
     * method will return false.
     */
    inline void clearERunlevel();

    /**
     * Checks whether the field "eRunlevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERunlevel()). Otherwise it will return false.
     */
    inline bool hasERunlevel () const;

    /**
     * Returns the value of the member "eRunlevel".
     *
     * If the meaning of "eRunlevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eRunlevel"
     */
    inline ::spm_core_fi_types::T_SPM_e32_RUNLEVEL getERunlevel () const;

    /**
     * Sets the value of the member "eRunlevel".
     *
     * If the meaning of "eRunlevel" isn't clear, then there should be a description here.
     *
     * @param eRunlevel The value which will be set
     */
    inline void setERunlevel (::spm_core_fi_types::T_SPM_e32_RUNLEVEL eRunlevel_);

    static const RunlevelStateStatus &getDefaultInstance();

private:

    inline void set_has_eRunlevel ();

    inline void clear_has_eRunlevel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_RUNLEVEL _eRunlevel;

};

/**
 * The status message of the property "Restart"
 * OBSOLETE do not use anymore, replaced by Method RestartSystem
 */
class RestartStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartStatus ();

    /**
     * Copy constructor
     */
    inline  RestartStatus (const RestartStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RestartStatus (::spm_core_fi_types::T_SPM_e32_RESTART_TYPE Restart_);

    /**
     * Destructor
     */
    inline virtual  ~RestartStatus();

    /**
     * Assignment operator
     */
    inline RestartStatus& operator = (const RestartStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Restart"

    static const int kRestart = 0;

    /**
     * Clears the field "Restart".
     *
     * The field will be set to its default value. The hasRestart()
     * method will return false.
     */
    inline void clearRestart();

    /**
     * Checks whether the field "Restart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestart()). Otherwise it will return false.
     */
    inline bool hasRestart () const;

    /**
     * Returns the value of the member "Restart".
     *
     * Restart type.
     *
     * @return The value of the field "Restart"
     */
    inline ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE getRestart () const;

    /**
     * Sets the value of the member "Restart".
     *
     * Restart type.
     *
     * @param Restart The value which will be set
     */
    inline void setRestart (::spm_core_fi_types::T_SPM_e32_RESTART_TYPE Restart_);

    static const RestartStatus &getDefaultInstance();

private:

    inline void set_has_Restart ();

    inline void clear_has_Restart ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE _Restart;

};

/**
 * The set message of the property "Restart"
 * OBSOLETE do not use anymore, replaced by Method RestartSystem
 */
class RestartSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartSet ();

    /**
     * Copy constructor
     */
    inline  RestartSet (const RestartSet &rhs);

    /**
     * All fields constructor
     */
    inline  RestartSet (::spm_core_fi_types::T_SPM_e32_RESTART_TYPE Restart_);

    /**
     * Destructor
     */
    inline virtual  ~RestartSet();

    /**
     * Assignment operator
     */
    inline RestartSet& operator = (const RestartSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Restart"

    static const int kRestart = 0;

    /**
     * Clears the field "Restart".
     *
     * The field will be set to its default value. The hasRestart()
     * method will return false.
     */
    inline void clearRestart();

    /**
     * Checks whether the field "Restart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestart()). Otherwise it will return false.
     */
    inline bool hasRestart () const;

    /**
     * Returns the value of the member "Restart".
     *
     * Restart type (e.g. ECU/watchdog).
     *
     * @return The value of the field "Restart"
     */
    inline ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE getRestart () const;

    /**
     * Sets the value of the member "Restart".
     *
     * Restart type (e.g. ECU/watchdog).
     *
     * @param Restart The value which will be set
     */
    inline void setRestart (::spm_core_fi_types::T_SPM_e32_RESTART_TYPE Restart_);

    static const RestartSet &getDefaultInstance();

private:

    inline void set_has_Restart ();

    inline void clear_has_Restart ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_RESTART_TYPE _Restart;

};

/**
 * The status message of the property "Lifesign"
 * <p>This lifesign reflects the value received by the FC_SPMSLV.</p>
 */
class LifesignStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifesignStatus ();

    /**
     * Copy constructor
     */
    inline  LifesignStatus (const LifesignStatus &rhs);

    /**
     * All fields constructor
     */
    inline  LifesignStatus (uint32 Lifesign_);

    /**
     * Destructor
     */
    inline virtual  ~LifesignStatus();

    /**
     * Assignment operator
     */
    inline LifesignStatus& operator = (const LifesignStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifesignStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifesignStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifesignStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifesignStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Lifesign"

    static const int kLifesign = 0;

    /**
     * Clears the field "Lifesign".
     *
     * The field will be set to its default value. The hasLifesign()
     * method will return false.
     */
    inline void clearLifesign();

    /**
     * Checks whether the field "Lifesign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLifesign()). Otherwise it will return false.
     */
    inline bool hasLifesign () const;

    /**
     * Returns the value of the member "Lifesign".
     *
     * Reflected lifesign from FC_SPMSLV. Parameter 'Lifesign' is incremented with each trigger. Trigger interval currently every 2s.
     *
     * @return The value of the field "Lifesign"
     */
    inline uint32 getLifesign () const;

    /**
     * Sets the value of the member "Lifesign".
     *
     * Reflected lifesign from FC_SPMSLV. Parameter 'Lifesign' is incremented with each trigger. Trigger interval currently every 2s.
     *
     * @param Lifesign The value which will be set
     */
    inline void setLifesign (uint32 Lifesign_);

    static const LifesignStatus &getDefaultInstance();

private:

    inline void set_has_Lifesign ();

    inline void clear_has_Lifesign ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Lifesign;

};

/**
 * The status message of the property "HmiState"
 * Set substate of the HMI application.
 */
class HmiStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HmiStateStatus ();

    /**
     * Copy constructor
     */
    inline  HmiStateStatus (const HmiStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  HmiStateStatus (::spm_core_fi_types::T_SPM_e32_HMI_STATE HmiState_);

    /**
     * Destructor
     */
    inline virtual  ~HmiStateStatus();

    /**
     * Assignment operator
     */
    inline HmiStateStatus& operator = (const HmiStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HmiStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HmiStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HmiStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HmiStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HmiState"

    static const int kHmiState = 0;

    /**
     * Clears the field "HmiState".
     *
     * The field will be set to its default value. The hasHmiState()
     * method will return false.
     */
    inline void clearHmiState();

    /**
     * Checks whether the field "HmiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiState()). Otherwise it will return false.
     */
    inline bool hasHmiState () const;

    /**
     * Returns the value of the member "HmiState".
     *
     * Substate of the HMI application.
     *
     * @return The value of the field "HmiState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_HMI_STATE getHmiState () const;

    /**
     * Sets the value of the member "HmiState".
     *
     * Substate of the HMI application.
     *
     * @param HmiState The value which will be set
     */
    inline void setHmiState (::spm_core_fi_types::T_SPM_e32_HMI_STATE HmiState_);

    static const HmiStateStatus &getDefaultInstance();

private:

    inline void set_has_HmiState ();

    inline void clear_has_HmiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_HMI_STATE _HmiState;

};

/**
 * The status message of the property "SystemPowerBehaviour"
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.
 */
class SystemPowerBehaviourStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPowerBehaviourStatus ();

    /**
     * Copy constructor
     */
    inline  SystemPowerBehaviourStatus (const SystemPowerBehaviourStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SystemPowerBehaviourStatus (::spm_core_fi_types::T_SPM_e32_SYSPWR_BEHAVIOUR eSystemPowerBehaviour_);

    /**
     * Destructor
     */
    inline virtual  ~SystemPowerBehaviourStatus();

    /**
     * Assignment operator
     */
    inline SystemPowerBehaviourStatus& operator = (const SystemPowerBehaviourStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPowerBehaviourStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPowerBehaviourStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPowerBehaviourStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPowerBehaviourStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eSystemPowerBehaviour"

    static const int kESystemPowerBehaviour = 0;

    /**
     * Clears the field "eSystemPowerBehaviour".
     *
     * The field will be set to its default value. The hasESystemPowerBehaviour()
     * method will return false.
     */
    inline void clearESystemPowerBehaviour();

    /**
     * Checks whether the field "eSystemPowerBehaviour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESystemPowerBehaviour()). Otherwise it will return false.
     */
    inline bool hasESystemPowerBehaviour () const;

    /**
     * Returns the value of the member "eSystemPowerBehaviour".
     *
     * If the meaning of "eSystemPowerBehaviour" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eSystemPowerBehaviour"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYSPWR_BEHAVIOUR getESystemPowerBehaviour () const;

    /**
     * Sets the value of the member "eSystemPowerBehaviour".
     *
     * If the meaning of "eSystemPowerBehaviour" isn't clear, then there should be a description here.
     *
     * @param eSystemPowerBehaviour The value which will be set
     */
    inline void setESystemPowerBehaviour (::spm_core_fi_types::T_SPM_e32_SYSPWR_BEHAVIOUR eSystemPowerBehaviour_);

    static const SystemPowerBehaviourStatus &getDefaultInstance();

private:

    inline void set_has_eSystemPowerBehaviour ();

    inline void clear_has_eSystemPowerBehaviour ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYSPWR_BEHAVIOUR _eSystemPowerBehaviour;

};

/**
 * The start message of the method "AudioSourceChange"
 * Method to trigger a source change by HMI. Used to change start configuration for next start-up.
 */
class AudioSourceChangeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioSourceChangeStart ();

    /**
     * Copy constructor
     */
    inline  AudioSourceChangeStart (const AudioSourceChangeStart &rhs);

    /**
     * All fields constructor
     */
    inline  AudioSourceChangeStart (::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE eAudioSrc_);

    /**
     * Destructor
     */
    inline virtual  ~AudioSourceChangeStart();

    /**
     * Assignment operator
     */
    inline AudioSourceChangeStart& operator = (const AudioSourceChangeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioSourceChangeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioSourceChangeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioSourceChangeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioSourceChangeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eAudioSrc"

    static const int kEAudioSrc = 0;

    /**
     * Clears the field "eAudioSrc".
     *
     * The field will be set to its default value. The hasEAudioSrc()
     * method will return false.
     */
    inline void clearEAudioSrc();

    /**
     * Checks whether the field "eAudioSrc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEAudioSrc()). Otherwise it will return false.
     */
    inline bool hasEAudioSrc () const;

    /**
     * Returns the value of the member "eAudioSrc".
     *
     * If the meaning of "eAudioSrc" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eAudioSrc"
     */
    inline ::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE getEAudioSrc () const;

    /**
     * Sets the value of the member "eAudioSrc".
     *
     * If the meaning of "eAudioSrc" isn't clear, then there should be a description here.
     *
     * @param eAudioSrc The value which will be set
     */
    inline void setEAudioSrc (::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE eAudioSrc_);

    static const AudioSourceChangeStart &getDefaultInstance();

private:

    inline void set_has_eAudioSrc ();

    inline void clear_has_eAudioSrc ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE _eAudioSrc;

};

/**
 * The status message of the property "DimState"
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality.
 * Set substate of the DIMMING application.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
class DimStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimStateStatus ();

    /**
     * Copy constructor
     */
    inline  DimStateStatus (const DimStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DimStateStatus (::spm_core_fi_types::T_SPM_e32_DIM_STATE DimState_);

    /**
     * Destructor
     */
    inline virtual  ~DimStateStatus();

    /**
     * Assignment operator
     */
    inline DimStateStatus& operator = (const DimStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimState"

    static const int kDimState = 0;

    /**
     * Clears the field "DimState".
     *
     * The field will be set to its default value. The hasDimState()
     * method will return false.
     */
    inline void clearDimState();

    /**
     * Checks whether the field "DimState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimState()). Otherwise it will return false.
     */
    inline bool hasDimState () const;

    /**
     * Returns the value of the member "DimState".
     *
     * Substate of the DIMMING application.
     *
     * @return The value of the field "DimState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_DIM_STATE getDimState () const;

    /**
     * Sets the value of the member "DimState".
     *
     * Substate of the DIMMING application.
     *
     * @param DimState The value which will be set
     */
    inline void setDimState (::spm_core_fi_types::T_SPM_e32_DIM_STATE DimState_);

    static const DimStateStatus &getDefaultInstance();

private:

    inline void set_has_DimState ();

    inline void clear_has_DimState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_DIM_STATE _DimState;

};

/**
 * The status message of the property "DimmingState"
 * Information about dimming states from LCM point of view for e.g. backlight.
 * <p>The application VD DIMMING has to register for this property. The following illumination states will be controlled by the SPM.</p>
 * Bezel illumination is enabled in the system state "SYSTEM_ON"
 * Backlight illumination is enabled in the system state "SYSTEM_ON", "SYSTEM_DIAGNOSIS", "SYSTEM_DOWNLOAD" and when ever the clock should be displayed (see property "HmiState")
 * Climate illumination is enabled if ignition is active
 */
class DimmingStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimmingStateStatus ();

    /**
     * Copy constructor
     */
    inline  DimmingStateStatus (const DimmingStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DimmingStateStatus (const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& DimState_);

    /**
     * Destructor
     */
    inline virtual  ~DimmingStateStatus();

    /**
     * Assignment operator
     */
    inline DimmingStateStatus& operator = (const DimmingStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimmingStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimmingStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimmingStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimmingStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimState"

    static const int kDimState = 0;

    /**
     * Clears the field "DimState".
     *
     * The field will be set to its default value. The hasDimState()
     * method will return false.
     */
    inline void clearDimState();

    /**
     * Checks whether the field "DimState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimState()). Otherwise it will return false.
     */
    inline bool hasDimState () const;

    /**
     * Returns the value of the member "DimState".
     *
     * Bit-coded states for dimming r.g. backlight, ....
     *
     * @return The value of the field "DimState"
     */
    inline const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& getDimState () const;

    /**
     * Retrieves the value of the field "DimState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DimState".
     */
    inline ::spm_core_fi_types::T_SPM_b32_DIM_STATE& getDimStateMutable ();

    /**
     * Sets the value of the member "DimState".
     *
     * Bit-coded states for dimming r.g. backlight, ....
     *
     * @param DimState The value which will be set
     */
    inline void setDimState (const ::spm_core_fi_types::T_SPM_b32_DIM_STATE& DimState_);

    /**
     * Release the object stored in the field "DimState".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "DimState"
     */
    inline ::spm_core_fi_types::T_SPM_b32_DIM_STATE* releaseDimState();

    /**
     * Replace the field "DimState".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDimState (::spm_core_fi_types::T_SPM_b32_DIM_STATE* DimState_);

    static const DimmingStateStatus &getDefaultInstance();

private:

    inline void set_has_DimState ();

    inline void clear_has_DimState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_b32_DIM_STATE* _DimState;

};

/**
 * The status message of the property "BluetoothState"
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.
 */
class BluetoothStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothStateStatus ();

    /**
     * Copy constructor
     */
    inline  BluetoothStateStatus (const BluetoothStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothStateStatus (::spm_core_fi_types::T_SPM_e32_BT_STATE BtState_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothStateStatus();

    /**
     * Assignment operator
     */
    inline BluetoothStateStatus& operator = (const BluetoothStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BtState"

    static const int kBtState = 0;

    /**
     * Clears the field "BtState".
     *
     * The field will be set to its default value. The hasBtState()
     * method will return false.
     */
    inline void clearBtState();

    /**
     * Checks whether the field "BtState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBtState()). Otherwise it will return false.
     */
    inline bool hasBtState () const;

    /**
     * Returns the value of the member "BtState".
     *
     * If the meaning of "BtState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BtState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_BT_STATE getBtState () const;

    /**
     * Sets the value of the member "BtState".
     *
     * If the meaning of "BtState" isn't clear, then there should be a description here.
     *
     * @param BtState The value which will be set
     */
    inline void setBtState (::spm_core_fi_types::T_SPM_e32_BT_STATE BtState_);

    static const BluetoothStateStatus &getDefaultInstance();

private:

    inline void set_has_BtState ();

    inline void clear_has_BtState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_BT_STATE _BtState;

};

/**
 * The start message of the method "ChangeBluetoothState"
 * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
class ChangeBluetoothStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeBluetoothStateStart ();

    /**
     * Copy constructor
     */
    inline  ChangeBluetoothStateStart (const ChangeBluetoothStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeBluetoothStateStart (::spm_core_fi_types::T_SPM_e32_BT_STATE BtState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeBluetoothStateStart();

    /**
     * Assignment operator
     */
    inline ChangeBluetoothStateStart& operator = (const ChangeBluetoothStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeBluetoothStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeBluetoothStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeBluetoothStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeBluetoothStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BtState"

    static const int kBtState = 0;

    /**
     * Clears the field "BtState".
     *
     * The field will be set to its default value. The hasBtState()
     * method will return false.
     */
    inline void clearBtState();

    /**
     * Checks whether the field "BtState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBtState()). Otherwise it will return false.
     */
    inline bool hasBtState () const;

    /**
     * Returns the value of the member "BtState".
     *
     * If the meaning of "BtState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BtState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_BT_STATE getBtState () const;

    /**
     * Sets the value of the member "BtState".
     *
     * If the meaning of "BtState" isn't clear, then there should be a description here.
     *
     * @param BtState The value which will be set
     */
    inline void setBtState (::spm_core_fi_types::T_SPM_e32_BT_STATE BtState_);

    static const ChangeBluetoothStateStart &getDefaultInstance();

private:

    inline void set_has_BtState ();

    inline void clear_has_BtState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_BT_STATE _BtState;

};

/**
 * The status message of the property "AudioState"
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.
 */
class AudioStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateStatus ();

    /**
     * Copy constructor
     */
    inline  AudioStateStatus (const AudioStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AudioStateStatus (::spm_core_fi_types::T_SPM_e32_AUDIO_STATE AudioState_);

    /**
     * Destructor
     */
    inline virtual  ~AudioStateStatus();

    /**
     * Assignment operator
     */
    inline AudioStateStatus& operator = (const AudioStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioState"

    static const int kAudioState = 0;

    /**
     * Clears the field "AudioState".
     *
     * The field will be set to its default value. The hasAudioState()
     * method will return false.
     */
    inline void clearAudioState();

    /**
     * Checks whether the field "AudioState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioState()). Otherwise it will return false.
     */
    inline bool hasAudioState () const;

    /**
     * Returns the value of the member "AudioState".
     *
     * If the meaning of "AudioState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudioState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE getAudioState () const;

    /**
     * Sets the value of the member "AudioState".
     *
     * If the meaning of "AudioState" isn't clear, then there should be a description here.
     *
     * @param AudioState The value which will be set
     */
    inline void setAudioState (::spm_core_fi_types::T_SPM_e32_AUDIO_STATE AudioState_);

    static const AudioStateStatus &getDefaultInstance();

private:

    inline void set_has_AudioState ();

    inline void clear_has_AudioState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE _AudioState;

};

/**
 * The start message of the method "ChangeAudioState"
 * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
class ChangeAudioStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeAudioStateStart ();

    /**
     * Copy constructor
     */
    inline  ChangeAudioStateStart (const ChangeAudioStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeAudioStateStart (::spm_core_fi_types::T_SPM_e32_AUDIO_STATE AudioState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeAudioStateStart();

    /**
     * Assignment operator
     */
    inline ChangeAudioStateStart& operator = (const ChangeAudioStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAudioStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAudioStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAudioStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAudioStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioState"

    static const int kAudioState = 0;

    /**
     * Clears the field "AudioState".
     *
     * The field will be set to its default value. The hasAudioState()
     * method will return false.
     */
    inline void clearAudioState();

    /**
     * Checks whether the field "AudioState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioState()). Otherwise it will return false.
     */
    inline bool hasAudioState () const;

    /**
     * Returns the value of the member "AudioState".
     *
     * If the meaning of "AudioState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudioState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE getAudioState () const;

    /**
     * Sets the value of the member "AudioState".
     *
     * If the meaning of "AudioState" isn't clear, then there should be a description here.
     *
     * @param AudioState The value which will be set
     */
    inline void setAudioState (::spm_core_fi_types::T_SPM_e32_AUDIO_STATE AudioState_);

    static const ChangeAudioStateStart &getDefaultInstance();

private:

    inline void set_has_AudioState ();

    inline void clear_has_AudioState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_AUDIO_STATE _AudioState;

};

/**
 * The status message of the property "SpiState"
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.
 */
class SpiStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpiStateStatus ();

    /**
     * Copy constructor
     */
    inline  SpiStateStatus (const SpiStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SpiStateStatus (::spm_core_fi_types::T_SPM_e32_SPI_STATE SpiState_);

    /**
     * Destructor
     */
    inline virtual  ~SpiStateStatus();

    /**
     * Assignment operator
     */
    inline SpiStateStatus& operator = (const SpiStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpiStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpiStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpiStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpiStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpiState"

    static const int kSpiState = 0;

    /**
     * Clears the field "SpiState".
     *
     * The field will be set to its default value. The hasSpiState()
     * method will return false.
     */
    inline void clearSpiState();

    /**
     * Checks whether the field "SpiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpiState()). Otherwise it will return false.
     */
    inline bool hasSpiState () const;

    /**
     * Returns the value of the member "SpiState".
     *
     * If the meaning of "SpiState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SpiState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SPI_STATE getSpiState () const;

    /**
     * Sets the value of the member "SpiState".
     *
     * If the meaning of "SpiState" isn't clear, then there should be a description here.
     *
     * @param SpiState The value which will be set
     */
    inline void setSpiState (::spm_core_fi_types::T_SPM_e32_SPI_STATE SpiState_);

    static const SpiStateStatus &getDefaultInstance();

private:

    inline void set_has_SpiState ();

    inline void clear_has_SpiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SPI_STATE _SpiState;

};

/**
 * The start message of the method "ChangeSpiState"
 * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
class ChangeSpiStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeSpiStateStart ();

    /**
     * Copy constructor
     */
    inline  ChangeSpiStateStart (const ChangeSpiStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeSpiStateStart (::spm_core_fi_types::T_SPM_e32_SPI_STATE SpiState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeSpiStateStart();

    /**
     * Assignment operator
     */
    inline ChangeSpiStateStart& operator = (const ChangeSpiStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeSpiStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeSpiStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeSpiStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeSpiStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpiState"

    static const int kSpiState = 0;

    /**
     * Clears the field "SpiState".
     *
     * The field will be set to its default value. The hasSpiState()
     * method will return false.
     */
    inline void clearSpiState();

    /**
     * Checks whether the field "SpiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpiState()). Otherwise it will return false.
     */
    inline bool hasSpiState () const;

    /**
     * Returns the value of the member "SpiState".
     *
     * If the meaning of "SpiState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SpiState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SPI_STATE getSpiState () const;

    /**
     * Sets the value of the member "SpiState".
     *
     * If the meaning of "SpiState" isn't clear, then there should be a description here.
     *
     * @param SpiState The value which will be set
     */
    inline void setSpiState (::spm_core_fi_types::T_SPM_e32_SPI_STATE SpiState_);

    static const ChangeSpiStateStart &getDefaultInstance();

private:

    inline void set_has_SpiState ();

    inline void clear_has_SpiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SPI_STATE _SpiState;

};

/**
 * The status message of the property "TunerState"
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.
 */
class TunerStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TunerStateStatus ();

    /**
     * Copy constructor
     */
    inline  TunerStateStatus (const TunerStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TunerStateStatus (::spm_core_fi_types::T_SPM_e32_TUNER_STATE TunerState_);

    /**
     * Destructor
     */
    inline virtual  ~TunerStateStatus();

    /**
     * Assignment operator
     */
    inline TunerStateStatus& operator = (const TunerStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TunerStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TunerStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TunerStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TunerStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerState"

    static const int kTunerState = 0;

    /**
     * Clears the field "TunerState".
     *
     * The field will be set to its default value. The hasTunerState()
     * method will return false.
     */
    inline void clearTunerState();

    /**
     * Checks whether the field "TunerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerState()). Otherwise it will return false.
     */
    inline bool hasTunerState () const;

    /**
     * Returns the value of the member "TunerState".
     *
     * If the meaning of "TunerState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_TUNER_STATE getTunerState () const;

    /**
     * Sets the value of the member "TunerState".
     *
     * If the meaning of "TunerState" isn't clear, then there should be a description here.
     *
     * @param TunerState The value which will be set
     */
    inline void setTunerState (::spm_core_fi_types::T_SPM_e32_TUNER_STATE TunerState_);

    static const TunerStateStatus &getDefaultInstance();

private:

    inline void set_has_TunerState ();

    inline void clear_has_TunerState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_TUNER_STATE _TunerState;

};

/**
 * The start message of the method "ChangeTunerState"
 * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
class ChangeTunerStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeTunerStateStart ();

    /**
     * Copy constructor
     */
    inline  ChangeTunerStateStart (const ChangeTunerStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeTunerStateStart (::spm_core_fi_types::T_SPM_e32_TUNER_STATE TunerState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeTunerStateStart();

    /**
     * Assignment operator
     */
    inline ChangeTunerStateStart& operator = (const ChangeTunerStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeTunerStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeTunerStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeTunerStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeTunerStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerState"

    static const int kTunerState = 0;

    /**
     * Clears the field "TunerState".
     *
     * The field will be set to its default value. The hasTunerState()
     * method will return false.
     */
    inline void clearTunerState();

    /**
     * Checks whether the field "TunerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerState()). Otherwise it will return false.
     */
    inline bool hasTunerState () const;

    /**
     * Returns the value of the member "TunerState".
     *
     * If the meaning of "TunerState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_TUNER_STATE getTunerState () const;

    /**
     * Sets the value of the member "TunerState".
     *
     * If the meaning of "TunerState" isn't clear, then there should be a description here.
     *
     * @param TunerState The value which will be set
     */
    inline void setTunerState (::spm_core_fi_types::T_SPM_e32_TUNER_STATE TunerState_);

    static const ChangeTunerStateStart &getDefaultInstance();

private:

    inline void set_has_TunerState ();

    inline void clear_has_TunerState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_TUNER_STATE _TunerState;

};

/**
 * The status message of the property "WifiState"
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.
 */
class WifiStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiStateStatus ();

    /**
     * Copy constructor
     */
    inline  WifiStateStatus (const WifiStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WifiStateStatus (::spm_core_fi_types::T_SPM_e32_WIFI_STATE WiFiState_);

    /**
     * Destructor
     */
    inline virtual  ~WifiStateStatus();

    /**
     * Assignment operator
     */
    inline WifiStateStatus& operator = (const WifiStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WiFiState"

    static const int kWiFiState = 0;

    /**
     * Clears the field "WiFiState".
     *
     * The field will be set to its default value. The hasWiFiState()
     * method will return false.
     */
    inline void clearWiFiState();

    /**
     * Checks whether the field "WiFiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWiFiState()). Otherwise it will return false.
     */
    inline bool hasWiFiState () const;

    /**
     * Returns the value of the member "WiFiState".
     *
     * If the meaning of "WiFiState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WiFiState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_WIFI_STATE getWiFiState () const;

    /**
     * Sets the value of the member "WiFiState".
     *
     * If the meaning of "WiFiState" isn't clear, then there should be a description here.
     *
     * @param WiFiState The value which will be set
     */
    inline void setWiFiState (::spm_core_fi_types::T_SPM_e32_WIFI_STATE WiFiState_);

    static const WifiStateStatus &getDefaultInstance();

private:

    inline void set_has_WiFiState ();

    inline void clear_has_WiFiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_WIFI_STATE _WiFiState;

};

/**
 * The start message of the method "ChangeWifiState"
 * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.
 */
class ChangeWifiStateStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeWifiStateStart ();

    /**
     * Copy constructor
     */
    inline  ChangeWifiStateStart (const ChangeWifiStateStart &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeWifiStateStart (::spm_core_fi_types::T_SPM_e32_WIFI_STATE WiFiState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeWifiStateStart();

    /**
     * Assignment operator
     */
    inline ChangeWifiStateStart& operator = (const ChangeWifiStateStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiStateStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiStateStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiStateStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiStateStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WiFiState"

    static const int kWiFiState = 0;

    /**
     * Clears the field "WiFiState".
     *
     * The field will be set to its default value. The hasWiFiState()
     * method will return false.
     */
    inline void clearWiFiState();

    /**
     * Checks whether the field "WiFiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWiFiState()). Otherwise it will return false.
     */
    inline bool hasWiFiState () const;

    /**
     * Returns the value of the member "WiFiState".
     *
     * If the meaning of "WiFiState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WiFiState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_WIFI_STATE getWiFiState () const;

    /**
     * Sets the value of the member "WiFiState".
     *
     * If the meaning of "WiFiState" isn't clear, then there should be a description here.
     *
     * @param WiFiState The value which will be set
     */
    inline void setWiFiState (::spm_core_fi_types::T_SPM_e32_WIFI_STATE WiFiState_);

    static const ChangeWifiStateStart &getDefaultInstance();

private:

    inline void set_has_WiFiState ();

    inline void clear_has_WiFiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_WIFI_STATE _WiFiState;

};

/**
 * The start message of the method "ShutdownAndTerminateCcaApps"
 * <p>Shutdown (request change to CCA application state AMT_C_U32_STATE_OFF) and terminate (send power message AMT_C_U16_PWR_PROXY_END_APP) all CCA applications which are defined by the passed list of application IDs.</p>
 * <p>After all CCA applications are terminated remove their related software blocks.</p>
 */
class ShutdownAndTerminateCcaAppsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownAndTerminateCcaAppsStart ();

    /**
     * Copy constructor
     */
    inline  ShutdownAndTerminateCcaAppsStart (const ShutdownAndTerminateCcaAppsStart &rhs);

    /**
     * All fields constructor
     */
    inline  ShutdownAndTerminateCcaAppsStart (const ::spm_core_fi_types::T_SPM_AppIdList& tAppIdList_);

    /**
     * Destructor
     */
    inline virtual  ~ShutdownAndTerminateCcaAppsStart();

    /**
     * Assignment operator
     */
    inline ShutdownAndTerminateCcaAppsStart& operator = (const ShutdownAndTerminateCcaAppsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownAndTerminateCcaAppsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownAndTerminateCcaAppsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownAndTerminateCcaAppsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownAndTerminateCcaAppsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tAppIdList"

    static const int kTAppIdList = 0;

    /**
     * Clears the field "tAppIdList".
     *
     * The field will be set to its default value. The hasTAppIdList()
     * method will return false.
     */
    inline void clearTAppIdList();

    /**
     * Checks whether the field "tAppIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTAppIdList()). Otherwise it will return false.
     */
    inline bool hasTAppIdList () const;

    /**
     * Returns the value of the member "tAppIdList".
     *
     * List of CCA application IDs.
     *
     * @return The value of the field "tAppIdList"
     */
    inline const ::spm_core_fi_types::T_SPM_AppIdList& getTAppIdList () const;

    /**
     * Retrieves the value of the field "tAppIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tAppIdList".
     */
    inline ::spm_core_fi_types::T_SPM_AppIdList& getTAppIdListMutable ();

    /**
     * Sets the value of the member "tAppIdList".
     *
     * List of CCA application IDs.
     *
     * @param tAppIdList The value which will be set
     */
    inline void setTAppIdList (const ::spm_core_fi_types::T_SPM_AppIdList& tAppIdList_);

    /**
     * Release the object stored in the field "tAppIdList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "tAppIdList"
     */
    inline ::spm_core_fi_types::T_SPM_AppIdList* releaseTAppIdList();

    /**
     * Replace the field "tAppIdList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTAppIdList (::spm_core_fi_types::T_SPM_AppIdList* tAppIdList_);

    static const ShutdownAndTerminateCcaAppsStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_tAppIdList ();

    inline void clear_has_tAppIdList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_AppIdList* _tAppIdList;

};

/**
 * The status message of the property "OnOffReason"
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon!
 * Set a new OnOff reason. New system state will be calculated.
 * FUNCID = FID_SPM_SUBSTATE,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD
 */
class OnOffReasonStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffReasonStatus ();

    /**
     * Copy constructor
     */
    inline  OnOffReasonStatus (const OnOffReasonStatus &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffReasonStatus (::spm_core_fi_types::T_SPM_e32_OnOffReason OnOffReason_);

    /**
     * Destructor
     */
    inline virtual  ~OnOffReasonStatus();

    /**
     * Assignment operator
     */
    inline OnOffReasonStatus& operator = (const OnOffReasonStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffReasonStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffReasonStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffReasonStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffReasonStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnOffReason"

    static const int kOnOffReason = 0;

    /**
     * Clears the field "OnOffReason".
     *
     * The field will be set to its default value. The hasOnOffReason()
     * method will return false.
     */
    inline void clearOnOffReason();

    /**
     * Checks whether the field "OnOffReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnOffReason()). Otherwise it will return false.
     */
    inline bool hasOnOffReason () const;

    /**
     * Returns the value of the member "OnOffReason".
     *
     * Currently active OnOff reasons.
     *
     * @return The value of the field "OnOffReason"
     */
    inline ::spm_core_fi_types::T_SPM_e32_OnOffReason getOnOffReason () const;

    /**
     * Sets the value of the member "OnOffReason".
     *
     * Currently active OnOff reasons.
     *
     * @param OnOffReason The value which will be set
     */
    inline void setOnOffReason (::spm_core_fi_types::T_SPM_e32_OnOffReason OnOffReason_);

    static const OnOffReasonStatus &getDefaultInstance();

private:

    inline void set_has_OnOffReason ();

    inline void clear_has_OnOffReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_OnOffReason _OnOffReason;

};

/**
 * The set message of the property "OnOffReason"
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon!
 * Set a new OnOff reason. New system state will be calculated.
 * FUNCID = FID_SPM_SUBSTATE,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD
 */
class OnOffReasonSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffReasonSet ();

    /**
     * Copy constructor
     */
    inline  OnOffReasonSet (const OnOffReasonSet &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffReasonSet (::spm_core_fi_types::T_SPM_e32_OnOffReason OnOffReason_);

    /**
     * Destructor
     */
    inline virtual  ~OnOffReasonSet();

    /**
     * Assignment operator
     */
    inline OnOffReasonSet& operator = (const OnOffReasonSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffReasonSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffReasonSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffReasonSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffReasonSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnOffReason"

    static const int kOnOffReason = 0;

    /**
     * Clears the field "OnOffReason".
     *
     * The field will be set to its default value. The hasOnOffReason()
     * method will return false.
     */
    inline void clearOnOffReason();

    /**
     * Checks whether the field "OnOffReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnOffReason()). Otherwise it will return false.
     */
    inline bool hasOnOffReason () const;

    /**
     * Returns the value of the member "OnOffReason".
     *
     * Set new OnOff reasons.
     *
     * @return The value of the field "OnOffReason"
     */
    inline ::spm_core_fi_types::T_SPM_e32_OnOffReason getOnOffReason () const;

    /**
     * Sets the value of the member "OnOffReason".
     *
     * Set new OnOff reasons.
     *
     * @param OnOffReason The value which will be set
     */
    inline void setOnOffReason (::spm_core_fi_types::T_SPM_e32_OnOffReason OnOffReason_);

    static const OnOffReasonSet &getDefaultInstance();

private:

    inline void set_has_OnOffReason ();

    inline void clear_has_OnOffReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_OnOffReason _OnOffReason;

};

/**
 * The status message of the property "WakeupList"
 * Get reset count.
 * FUNCID = FID_SPM_WAKEUP_LIST,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class WakeupListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupListStatus ();

    /**
     * Copy constructor
     */
    inline  WakeupListStatus (const WakeupListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupListStatus (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason1_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason2_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason3_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason4_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason5_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason6_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason7_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason8_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason9_, ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason10_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupListStatus();

    /**
     * Assignment operator
     */
    inline WakeupListStatus& operator = (const WakeupListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeUpReason1"

    static const int kWakeUpReason1 = 0;

    /**
     * Clears the field "WakeUpReason1".
     *
     * The field will be set to its default value. The hasWakeUpReason1()
     * method will return false.
     */
    inline void clearWakeUpReason1();

    /**
     * Checks whether the field "WakeUpReason1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason1()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason1 () const;

    /**
     * Returns the value of the member "WakeUpReason1".
     *
     * last detected wakeup reason
     *
     * @return The value of the field "WakeUpReason1"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason1 () const;

    /**
     * Sets the value of the member "WakeUpReason1".
     *
     * last detected wakeup reason
     *
     * @param WakeUpReason1 The value which will be set
     */
    inline void setWakeUpReason1 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason1_);

    // API of field "WakeUpReason2"

    static const int kWakeUpReason2 = 1;

    /**
     * Clears the field "WakeUpReason2".
     *
     * The field will be set to its default value. The hasWakeUpReason2()
     * method will return false.
     */
    inline void clearWakeUpReason2();

    /**
     * Checks whether the field "WakeUpReason2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason2()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason2 () const;

    /**
     * Returns the value of the member "WakeUpReason2".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason2"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason2 () const;

    /**
     * Sets the value of the member "WakeUpReason2".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason2 The value which will be set
     */
    inline void setWakeUpReason2 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason2_);

    // API of field "WakeUpReason3"

    static const int kWakeUpReason3 = 2;

    /**
     * Clears the field "WakeUpReason3".
     *
     * The field will be set to its default value. The hasWakeUpReason3()
     * method will return false.
     */
    inline void clearWakeUpReason3();

    /**
     * Checks whether the field "WakeUpReason3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason3()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason3 () const;

    /**
     * Returns the value of the member "WakeUpReason3".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason3"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason3 () const;

    /**
     * Sets the value of the member "WakeUpReason3".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason3 The value which will be set
     */
    inline void setWakeUpReason3 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason3_);

    // API of field "WakeUpReason4"

    static const int kWakeUpReason4 = 3;

    /**
     * Clears the field "WakeUpReason4".
     *
     * The field will be set to its default value. The hasWakeUpReason4()
     * method will return false.
     */
    inline void clearWakeUpReason4();

    /**
     * Checks whether the field "WakeUpReason4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason4()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason4 () const;

    /**
     * Returns the value of the member "WakeUpReason4".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason4"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason4 () const;

    /**
     * Sets the value of the member "WakeUpReason4".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason4 The value which will be set
     */
    inline void setWakeUpReason4 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason4_);

    // API of field "WakeUpReason5"

    static const int kWakeUpReason5 = 4;

    /**
     * Clears the field "WakeUpReason5".
     *
     * The field will be set to its default value. The hasWakeUpReason5()
     * method will return false.
     */
    inline void clearWakeUpReason5();

    /**
     * Checks whether the field "WakeUpReason5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason5()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason5 () const;

    /**
     * Returns the value of the member "WakeUpReason5".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason5"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason5 () const;

    /**
     * Sets the value of the member "WakeUpReason5".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason5 The value which will be set
     */
    inline void setWakeUpReason5 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason5_);

    // API of field "WakeUpReason6"

    static const int kWakeUpReason6 = 5;

    /**
     * Clears the field "WakeUpReason6".
     *
     * The field will be set to its default value. The hasWakeUpReason6()
     * method will return false.
     */
    inline void clearWakeUpReason6();

    /**
     * Checks whether the field "WakeUpReason6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason6()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason6 () const;

    /**
     * Returns the value of the member "WakeUpReason6".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason6"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason6 () const;

    /**
     * Sets the value of the member "WakeUpReason6".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason6 The value which will be set
     */
    inline void setWakeUpReason6 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason6_);

    // API of field "WakeUpReason7"

    static const int kWakeUpReason7 = 6;

    /**
     * Clears the field "WakeUpReason7".
     *
     * The field will be set to its default value. The hasWakeUpReason7()
     * method will return false.
     */
    inline void clearWakeUpReason7();

    /**
     * Checks whether the field "WakeUpReason7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason7()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason7 () const;

    /**
     * Returns the value of the member "WakeUpReason7".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason7"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason7 () const;

    /**
     * Sets the value of the member "WakeUpReason7".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason7 The value which will be set
     */
    inline void setWakeUpReason7 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason7_);

    // API of field "WakeUpReason8"

    static const int kWakeUpReason8 = 7;

    /**
     * Clears the field "WakeUpReason8".
     *
     * The field will be set to its default value. The hasWakeUpReason8()
     * method will return false.
     */
    inline void clearWakeUpReason8();

    /**
     * Checks whether the field "WakeUpReason8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason8()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason8 () const;

    /**
     * Returns the value of the member "WakeUpReason8".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason8"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason8 () const;

    /**
     * Sets the value of the member "WakeUpReason8".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason8 The value which will be set
     */
    inline void setWakeUpReason8 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason8_);

    // API of field "WakeUpReason9"

    static const int kWakeUpReason9 = 8;

    /**
     * Clears the field "WakeUpReason9".
     *
     * The field will be set to its default value. The hasWakeUpReason9()
     * method will return false.
     */
    inline void clearWakeUpReason9();

    /**
     * Checks whether the field "WakeUpReason9" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason9()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason9 () const;

    /**
     * Returns the value of the member "WakeUpReason9".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason9"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason9 () const;

    /**
     * Sets the value of the member "WakeUpReason9".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason9 The value which will be set
     */
    inline void setWakeUpReason9 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason9_);

    // API of field "WakeUpReason10"

    static const int kWakeUpReason10 = 9;

    /**
     * Clears the field "WakeUpReason10".
     *
     * The field will be set to its default value. The hasWakeUpReason10()
     * method will return false.
     */
    inline void clearWakeUpReason10();

    /**
     * Checks whether the field "WakeUpReason10" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason10()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason10 () const;

    /**
     * Returns the value of the member "WakeUpReason10".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason10"
     */
    inline ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason10 () const;

    /**
     * Sets the value of the member "WakeUpReason10".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason10 The value which will be set
     */
    inline void setWakeUpReason10 (::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason10_);

    static const WakeupListStatus &getDefaultInstance();

private:

    inline void set_has_WakeUpReason1 ();

    inline void clear_has_WakeUpReason1 ();

    inline void set_has_WakeUpReason2 ();

    inline void clear_has_WakeUpReason2 ();

    inline void set_has_WakeUpReason3 ();

    inline void clear_has_WakeUpReason3 ();

    inline void set_has_WakeUpReason4 ();

    inline void clear_has_WakeUpReason4 ();

    inline void set_has_WakeUpReason5 ();

    inline void clear_has_WakeUpReason5 ();

    inline void set_has_WakeUpReason6 ();

    inline void clear_has_WakeUpReason6 ();

    inline void set_has_WakeUpReason7 ();

    inline void clear_has_WakeUpReason7 ();

    inline void set_has_WakeUpReason8 ();

    inline void clear_has_WakeUpReason8 ();

    inline void set_has_WakeUpReason9 ();

    inline void clear_has_WakeUpReason9 ();

    inline void set_has_WakeUpReason10 ();

    inline void clear_has_WakeUpReason10 ();

    uint32 _has_bits_[ (10 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason1;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason2;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason3;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason4;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason5;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason6;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason7;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason8;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason9;

    ::spm_core_fi_types::T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason10;

};

/**
 * The set message of the property "WakeupList"
 * Get reset count.
 * FUNCID = FID_SPM_WAKEUP_LIST,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class WakeupListSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupListSet ();

    /**
     * Copy constructor
     */
    inline  WakeupListSet (const WakeupListSet &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupListSet (uint32 WakeupList_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupListSet();

    /**
     * Assignment operator
     */
    inline WakeupListSet& operator = (const WakeupListSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupListSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupListSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupListSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupListSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeupList"

    static const int kWakeupList = 0;

    /**
     * Clears the field "WakeupList".
     *
     * The field will be set to its default value. The hasWakeupList()
     * method will return false.
     */
    inline void clearWakeupList();

    /**
     * Checks whether the field "WakeupList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeupList()). Otherwise it will return false.
     */
    inline bool hasWakeupList () const;

    /**
     * Returns the value of the member "WakeupList".
     *
     * Reset the wakeup list (value is not checked ).
     *
     * @return The value of the field "WakeupList"
     */
    inline uint32 getWakeupList () const;

    /**
     * Sets the value of the member "WakeupList".
     *
     * Reset the wakeup list (value is not checked ).
     *
     * @param WakeupList The value which will be set
     */
    inline void setWakeupList (uint32 WakeupList_);

    static const WakeupListSet &getDefaultInstance();

private:

    inline void set_has_WakeupList ();

    inline void clear_has_WakeupList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _WakeupList;

};

/**
 * The status message of the property "StartupFinished"
 * FUNCID = FID_SPM_STARTUP_FINISHED,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_xx
 */
class StartupFinishedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFinishedStatus ();

    /**
     * Copy constructor
     */
    inline  StartupFinishedStatus (const StartupFinishedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFinishedStatus (bool StartupFinishedState_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFinishedStatus();

    /**
     * Assignment operator
     */
    inline StartupFinishedStatus& operator = (const StartupFinishedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupFinishedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupFinishedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupFinishedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupFinishedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupFinishedState"

    static const int kStartupFinishedState = 0;

    /**
     * Clears the field "StartupFinishedState".
     *
     * The field will be set to its default value. The hasStartupFinishedState()
     * method will return false.
     */
    inline void clearStartupFinishedState();

    /**
     * Checks whether the field "StartupFinishedState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupFinishedState()). Otherwise it will return false.
     */
    inline bool hasStartupFinishedState () const;

    /**
     * Returns the value of the member "StartupFinishedState".
     *
     * The startup is finished.
     *
     * @return The value of the field "StartupFinishedState"
     */
    inline bool getStartupFinishedState () const;

    /**
     * Sets the value of the member "StartupFinishedState".
     *
     * The startup is finished.
     *
     * @param StartupFinishedState The value which will be set
     */
    inline void setStartupFinishedState (bool StartupFinishedState_);

    static const StartupFinishedStatus &getDefaultInstance();

private:

    inline void set_has_StartupFinishedState ();

    inline void clear_has_StartupFinishedState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _StartupFinishedState;

};

/**
 * The status message of the property "SysState"
 * Set substate of the HMI application.
 */
class SysStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysStateStatus ();

    /**
     * Copy constructor
     */
    inline  SysStateStatus (const SysStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SysStateStatus (::spm_core_fi_types::T_SPM_e32_SYS_STATE SysState_);

    /**
     * Destructor
     */
    inline virtual  ~SysStateStatus();

    /**
     * Assignment operator
     */
    inline SysStateStatus& operator = (const SysStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SysState"

    static const int kSysState = 0;

    /**
     * Clears the field "SysState".
     *
     * The field will be set to its default value. The hasSysState()
     * method will return false.
     */
    inline void clearSysState();

    /**
     * Checks whether the field "SysState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysState()). Otherwise it will return false.
     */
    inline bool hasSysState () const;

    /**
     * Returns the value of the member "SysState".
     *
     * State of the GM G2 system.
     *
     * @return The value of the field "SysState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SYS_STATE getSysState () const;

    /**
     * Sets the value of the member "SysState".
     *
     * State of the GM G2 system.
     *
     * @param SysState The value which will be set
     */
    inline void setSysState (::spm_core_fi_types::T_SPM_e32_SYS_STATE SysState_);

    static const SysStateStatus &getDefaultInstance();

private:

    inline void set_has_SysState ();

    inline void clear_has_SysState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SYS_STATE _SysState;

};

/**
 * The status message of the property "MostState"
 * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.
 */
class MostStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MostStateStatus ();

    /**
     * Copy constructor
     */
    inline  MostStateStatus (const MostStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MostStateStatus (::spm_core_fi_types::T_SPM_e32_MOST_EVENT MostEvent_, ::spm_core_fi_types::T_SPM_e32_MOST_CONFIG_STATE MostConfigurationState_, uint32 FirstReceiveTime_, ::spm_core_fi_types::T_SPM_e32_TLA_STATE TLAState_, bool OvertemperatureMostOff_);

    /**
     * Destructor
     */
    inline virtual  ~MostStateStatus();

    /**
     * Assignment operator
     */
    inline MostStateStatus& operator = (const MostStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MostStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MostStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MostStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MostStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MostEvent"

    static const int kMostEvent = 0;

    /**
     * Clears the field "MostEvent".
     *
     * The field will be set to its default value. The hasMostEvent()
     * method will return false.
     */
    inline void clearMostEvent();

    /**
     * Checks whether the field "MostEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMostEvent()). Otherwise it will return false.
     */
    inline bool hasMostEvent () const;

    /**
     * Returns the value of the member "MostEvent".
     *
     * Latest MOST Event of the system.
     *
     * @return The value of the field "MostEvent"
     */
    inline ::spm_core_fi_types::T_SPM_e32_MOST_EVENT getMostEvent () const;

    /**
     * Sets the value of the member "MostEvent".
     *
     * Latest MOST Event of the system.
     *
     * @param MostEvent The value which will be set
     */
    inline void setMostEvent (::spm_core_fi_types::T_SPM_e32_MOST_EVENT MostEvent_);

    // API of field "MostConfigurationState"

    static const int kMostConfigurationState = 1;

    /**
     * Clears the field "MostConfigurationState".
     *
     * The field will be set to its default value. The hasMostConfigurationState()
     * method will return false.
     */
    inline void clearMostConfigurationState();

    /**
     * Checks whether the field "MostConfigurationState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMostConfigurationState()). Otherwise it will return false.
     */
    inline bool hasMostConfigurationState () const;

    /**
     * Returns the value of the member "MostConfigurationState".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent.
     *
     * @return The value of the field "MostConfigurationState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_MOST_CONFIG_STATE getMostConfigurationState () const;

    /**
     * Sets the value of the member "MostConfigurationState".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent.
     *
     * @param MostConfigurationState The value which will be set
     */
    inline void setMostConfigurationState (::spm_core_fi_types::T_SPM_e32_MOST_CONFIG_STATE MostConfigurationState_);

    // API of field "FirstReceiveTime"

    static const int kFirstReceiveTime = 2;

    /**
     * Clears the field "FirstReceiveTime".
     *
     * The field will be set to its default value. The hasFirstReceiveTime()
     * method will return false.
     */
    inline void clearFirstReceiveTime();

    /**
     * Checks whether the field "FirstReceiveTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirstReceiveTime()). Otherwise it will return false.
     */
    inline bool hasFirstReceiveTime () const;

    /**
     * Returns the value of the member "FirstReceiveTime".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent. It indicates the point in time when the first configuration was sent by the network master.
     * If not valid then the time information is set to 0. Resolution is always in ms.
     *
     * @return The value of the field "FirstReceiveTime"
     */
    inline uint32 getFirstReceiveTime () const;

    /**
     * Sets the value of the member "FirstReceiveTime".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent. It indicates the point in time when the first configuration was sent by the network master.
     * If not valid then the time information is set to 0. Resolution is always in ms.
     *
     * @param FirstReceiveTime The value which will be set
     */
    inline void setFirstReceiveTime (uint32 FirstReceiveTime_);

    // API of field "TLAState"

    static const int kTLAState = 3;

    /**
     * Clears the field "TLAState".
     *
     * The field will be set to its default value. The hasTLAState()
     * method will return false.
     */
    inline void clearTLAState();

    /**
     * Checks whether the field "TLAState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLAState()). Otherwise it will return false.
     */
    inline bool hasTLAState () const;

    /**
     * Returns the value of the member "TLAState".
     *
     * Gives back the current TLA connected state
     *
     * @return The value of the field "TLAState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_TLA_STATE getTLAState () const;

    /**
     * Sets the value of the member "TLAState".
     *
     * Gives back the current TLA connected state
     *
     * @param TLAState The value which will be set
     */
    inline void setTLAState (::spm_core_fi_types::T_SPM_e32_TLA_STATE TLAState_);

    // API of field "OvertemperatureMostOff"

    static const int kOvertemperatureMostOff = 4;

    /**
     * Clears the field "OvertemperatureMostOff".
     *
     * The field will be set to its default value. The hasOvertemperatureMostOff()
     * method will return false.
     */
    inline void clearOvertemperatureMostOff();

    /**
     * Checks whether the field "OvertemperatureMostOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOvertemperatureMostOff()). Otherwise it will return false.
     */
    inline bool hasOvertemperatureMostOff () const;

    /**
     * Returns the value of the member "OvertemperatureMostOff".
     *
     * If set then all applications have reached "OFF" state. The CMA is requested to send all Netblocks off, and then disallows further communication between CCA and most. This state is stable until restart of the system.
     *
     * @return The value of the field "OvertemperatureMostOff"
     */
    inline bool getOvertemperatureMostOff () const;

    /**
     * Sets the value of the member "OvertemperatureMostOff".
     *
     * If set then all applications have reached "OFF" state. The CMA is requested to send all Netblocks off, and then disallows further communication between CCA and most. This state is stable until restart of the system.
     *
     * @param OvertemperatureMostOff The value which will be set
     */
    inline void setOvertemperatureMostOff (bool OvertemperatureMostOff_);

    static const MostStateStatus &getDefaultInstance();

private:

    inline void set_has_MostEvent ();

    inline void clear_has_MostEvent ();

    inline void set_has_MostConfigurationState ();

    inline void clear_has_MostConfigurationState ();

    inline void set_has_FirstReceiveTime ();

    inline void clear_has_FirstReceiveTime ();

    inline void set_has_TLAState ();

    inline void clear_has_TLAState ();

    inline void set_has_OvertemperatureMostOff ();

    inline void clear_has_OvertemperatureMostOff ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_MOST_EVENT _MostEvent;

    ::spm_core_fi_types::T_SPM_e32_MOST_CONFIG_STATE _MostConfigurationState;

    uint32 _FirstReceiveTime;

    ::spm_core_fi_types::T_SPM_e32_TLA_STATE _TLAState;

    bool _OvertemperatureMostOff;

};

/**
 * The status message of the property "MostVersion"
 * The MOST version of the MOST stack used in the system
 */
class MostVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MostVersionStatus ();

    /**
     * Copy constructor
     */
    inline  MostVersionStatus (const MostVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  MostVersionStatus (const ::std::string& MostVersion_);

    /**
     * Destructor
     */
    inline virtual  ~MostVersionStatus();

    /**
     * Assignment operator
     */
    inline MostVersionStatus& operator = (const MostVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MostVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MostVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MostVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MostVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MostVersion"

    static const int kMostVersion = 0;

    /**
     * Clears the field "MostVersion".
     *
     * The field will be set to its default value. The hasMostVersion()
     * method will return false.
     */
    inline void clearMostVersion();

    /**
     * Checks whether the field "MostVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMostVersion()). Otherwise it will return false.
     */
    inline bool hasMostVersion () const;

    /**
     * Returns the value of the member "MostVersion".
     *
     * <p>The current MOST version used in the system.</p>
     * <p>It has the form xx.xx.xx e.g. 03.00.03</p>
     *
     * @return The value of the field "MostVersion"
     */
    inline const ::std::string& getMostVersion () const;

    /**
     * Retrieves the value of the field "MostVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MostVersion".
     */
    inline ::std::string& getMostVersionMutable ();

    /**
     * Sets the value of the member "MostVersion".
     *
     * <p>The current MOST version used in the system.</p>
     * <p>It has the form xx.xx.xx e.g. 03.00.03</p>
     *
     * @param MostVersion The value which will be set
     */
    inline void setMostVersion (const ::std::string& MostVersion_);

    /**
     * Sets the value of the member "MostVersion".
     *
     * <p>The current MOST version used in the system.</p>
     * <p>It has the form xx.xx.xx e.g. 03.00.03</p>
     *
     * @param MostVersion The value which will be set
     */
    inline void setMostVersion (const char* MostVersion_);

    /**
     * Sets the value of the member "MostVersion".
     *
     * <p>The current MOST version used in the system.</p>
     * <p>It has the form xx.xx.xx e.g. 03.00.03</p>
     *
     * @param MostVersion The value which will be set
     */
    inline void setMostVersion (const char* value, size_t size);

    /**
     * Release the object stored in the field "MostVersion".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "MostVersion"
     */
    inline ::std::string* releaseMostVersion();

    /**
     * Replace the field "MostVersion".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMostVersion (::std::string* MostVersion_);

    static const MostVersionStatus &getDefaultInstance();

private:

    inline void set_has_MostVersion ();

    inline void clear_has_MostVersion ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _MostVersion;

};

/**
 * The status message of the property "RVCState"
 * Rear View Camera state of the system
 */
class RVCStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCStateStatus ();

    /**
     * Copy constructor
     */
    inline  RVCStateStatus (const RVCStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  RVCStateStatus (bool State_);

    /**
     * Destructor
     */
    inline virtual  ~RVCStateStatus();

    /**
     * Assignment operator
     */
    inline RVCStateStatus& operator = (const RVCStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Current rear view camera state: TRUE -- CAMERA ON, FALSE -- CAMERA OFF.
     *
     * @return The value of the field "State"
     */
    inline bool getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Current rear view camera state: TRUE -- CAMERA ON, FALSE -- CAMERA OFF.
     *
     * @param State The value which will be set
     */
    inline void setState (bool State_);

    static const RVCStateStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _State;

};

/**
 * The set message of the property "RVCState"
 * Rear View Camera state of the system
 */
class RVCStateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RVCStateSet ();

    /**
     * Copy constructor
     */
    inline  RVCStateSet (const RVCStateSet &rhs);

    /**
     * All fields constructor
     */
    inline  RVCStateSet (bool State_);

    /**
     * Destructor
     */
    inline virtual  ~RVCStateSet();

    /**
     * Assignment operator
     */
    inline RVCStateSet& operator = (const RVCStateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RVCStateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RVCStateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RVCStateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RVCStateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Set state of rear view camera: TRUE -- CAMERA ON, FALSE -- CAMERA OFF.
     *
     * @return The value of the field "State"
     */
    inline bool getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Set state of rear view camera: TRUE -- CAMERA ON, FALSE -- CAMERA OFF.
     *
     * @param State The value which will be set
     */
    inline void setState (bool State_);

    static const RVCStateSet &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _State;

};

/**
 * The status message of the property "TriggerMostRemoteReset"
 * <p>The property values goes to 1 to indicate that a MostRemoteReset trigger was sent to the Enhanced Test FBlock.
 * FC DIAGNOSIS can reset this value to 0 after having finished the action.</p>
 */
class TriggerMostRemoteResetStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TriggerMostRemoteResetStatus ();

    /**
     * Copy constructor
     */
    inline  TriggerMostRemoteResetStatus (const TriggerMostRemoteResetStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TriggerMostRemoteResetStatus (uint32 Trigger_);

    /**
     * Destructor
     */
    inline virtual  ~TriggerMostRemoteResetStatus();

    /**
     * Assignment operator
     */
    inline TriggerMostRemoteResetStatus& operator = (const TriggerMostRemoteResetStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TriggerMostRemoteResetStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TriggerMostRemoteResetStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TriggerMostRemoteResetStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TriggerMostRemoteResetStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Trigger"

    static const int kTrigger = 0;

    /**
     * Clears the field "Trigger".
     *
     * The field will be set to its default value. The hasTrigger()
     * method will return false.
     */
    inline void clearTrigger();

    /**
     * Checks whether the field "Trigger" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrigger()). Otherwise it will return false.
     */
    inline bool hasTrigger () const;

    /**
     * Returns the value of the member "Trigger".
     *
     * If set to 1 then a trigger is active.
     *
     * @return The value of the field "Trigger"
     */
    inline uint32 getTrigger () const;

    /**
     * Sets the value of the member "Trigger".
     *
     * If set to 1 then a trigger is active.
     *
     * @param Trigger The value which will be set
     */
    inline void setTrigger (uint32 Trigger_);

    static const TriggerMostRemoteResetStatus &getDefaultInstance();

private:

    inline void set_has_Trigger ();

    inline void clear_has_Trigger ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Trigger;

};

/**
 * The status message of the property "Partnumber"
 * <p>The system consists of several sw and data parts which are always mapped uniquely to a partnumber
 * to have the possibility to identify the current version.
 * This fid provides functionality for setting a new number for a part or getting the current number
 * of a part.</p>
 */
class PartnumberStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartnumberStatus ();

    /**
     * Copy constructor
     */
    inline  PartnumberStatus (const PartnumberStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PartnumberStatus (uint32 Partnumber_);

    /**
     * Destructor
     */
    inline virtual  ~PartnumberStatus();

    /**
     * Assignment operator
     */
    inline PartnumberStatus& operator = (const PartnumberStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartnumberStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartnumberStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartnumberStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartnumberStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Partnumber"

    static const int kPartnumber = 0;

    /**
     * Clears the field "Partnumber".
     *
     * The field will be set to its default value. The hasPartnumber()
     * method will return false.
     */
    inline void clearPartnumber();

    /**
     * Checks whether the field "Partnumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPartnumber()). Otherwise it will return false.
     */
    inline bool hasPartnumber () const;

    /**
     * Returns the value of the member "Partnumber".
     *
     * Returns the partnumber.
     *
     * @return The value of the field "Partnumber"
     */
    inline uint32 getPartnumber () const;

    /**
     * Sets the value of the member "Partnumber".
     *
     * Returns the partnumber.
     *
     * @param Partnumber The value which will be set
     */
    inline void setPartnumber (uint32 Partnumber_);

    static const PartnumberStatus &getDefaultInstance();

private:

    inline void set_has_Partnumber ();

    inline void clear_has_Partnumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Partnumber;

};

/**
 * The set message of the property "Partnumber"
 * <p>The system consists of several sw and data parts which are always mapped uniquely to a partnumber
 * to have the possibility to identify the current version.
 * This fid provides functionality for setting a new number for a part or getting the current number
 * of a part.</p>
 */
class PartnumberSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartnumberSet ();

    /**
     * Copy constructor
     */
    inline  PartnumberSet (const PartnumberSet &rhs);

    /**
     * All fields constructor
     */
    inline  PartnumberSet (const ::std::string& Part_, uint32 Number_);

    /**
     * Destructor
     */
    inline virtual  ~PartnumberSet();

    /**
     * Assignment operator
     */
    inline PartnumberSet& operator = (const PartnumberSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartnumberSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartnumberSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartnumberSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartnumberSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     * The part for which the new partnumber shall be set for.
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the new partnumber shall be set for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the new partnumber shall be set for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the new partnumber shall be set for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    /**
     * Release the object stored in the field "Part".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Part"
     */
    inline ::std::string* releasePart();

    /**
     * Replace the field "Part".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePart (::std::string* Part_);

    // API of field "Number"

    static const int kNumber = 1;

    /**
     * Clears the field "Number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "Number".
     *
     * The new partnumber.
     *
     * @return The value of the field "Number"
     */
    inline uint32 getNumber () const;

    /**
     * Sets the value of the member "Number".
     *
     * The new partnumber.
     *
     * @param Number The value which will be set
     */
    inline void setNumber (uint32 Number_);

    static const PartnumberSet &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    inline void set_has_Number ();

    inline void clear_has_Number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string* _Part;

    uint32 _Number;

};

/**
 * The get message of the property "Partnumber"
 * <p>The system consists of several sw and data parts which are always mapped uniquely to a partnumber
 * to have the possibility to identify the current version.
 * This fid provides functionality for setting a new number for a part or getting the current number
 * of a part.</p>
 */
class PartnumberGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartnumberGet ();

    /**
     * Copy constructor
     */
    inline  PartnumberGet (const PartnumberGet &rhs);

    /**
     * All fields constructor
     */
    inline  PartnumberGet (const ::std::string& Part_);

    /**
     * Destructor
     */
    inline virtual  ~PartnumberGet();

    /**
     * Assignment operator
     */
    inline PartnumberGet& operator = (const PartnumberGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartnumberGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartnumberGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartnumberGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartnumberGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     * The part for which the partnumber is requested for.
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the partnumber is requested for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the partnumber is requested for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the partnumber is requested for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    /**
     * Release the object stored in the field "Part".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Part"
     */
    inline ::std::string* releasePart();

    /**
     * Replace the field "Part".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePart (::std::string* Part_);

    static const PartnumberGet &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _Part;

};

/**
 * The status message of the property "Partnumbers"
 * <p>Get all parts of the system and their partnumbers.</p>
 */
class PartnumbersStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PartnumbersStatus ();

    /**
     * Copy constructor
     */
    inline  PartnumbersStatus (const PartnumbersStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PartnumbersStatus (const ::spm_core_fi_types::T_SPM_PartnumberList& Parts_);

    /**
     * Destructor
     */
    inline virtual  ~PartnumbersStatus();

    /**
     * Assignment operator
     */
    inline PartnumbersStatus& operator = (const PartnumbersStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PartnumbersStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PartnumbersStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PartnumbersStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PartnumbersStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Parts"

    static const int kParts = 0;

    /**
     * Clears the field "Parts".
     *
     * The field will be set to its default value. The hasParts()
     * method will return false.
     */
    inline void clearParts();

    /**
     * Checks whether the field "Parts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParts()). Otherwise it will return false.
     */
    inline bool hasParts () const;

    /**
     * Returns the value of the member "Parts".
     *
     * Returns all parts and their corresponding partnumbers.
     *
     * @return The value of the field "Parts"
     */
    inline const ::spm_core_fi_types::T_SPM_PartnumberList& getParts () const;

    /**
     * Retrieves the value of the field "Parts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Parts".
     */
    inline ::spm_core_fi_types::T_SPM_PartnumberList& getPartsMutable ();

    /**
     * Sets the value of the member "Parts".
     *
     * Returns all parts and their corresponding partnumbers.
     *
     * @param Parts The value which will be set
     */
    inline void setParts (const ::spm_core_fi_types::T_SPM_PartnumberList& Parts_);

    /**
     * Release the object stored in the field "Parts".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Parts"
     */
    inline ::spm_core_fi_types::T_SPM_PartnumberList* releaseParts();

    /**
     * Replace the field "Parts".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceParts (::spm_core_fi_types::T_SPM_PartnumberList* Parts_);

    static const PartnumbersStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_PartnumberItem >& getT_SPM_PartnumberItemPointerList_DefaultInstance ();

    inline void set_has_Parts ();

    inline void clear_has_Parts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_PartnumberList* _Parts;

};

/**
 * The status message of the property "Alphacode"
 * <p>Set or get the alphacodes needed for diagnosis.</p>
 */
class AlphacodeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AlphacodeStatus ();

    /**
     * Copy constructor
     */
    inline  AlphacodeStatus (const AlphacodeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AlphacodeStatus (uint8 Alphacode1_, uint8 Alphacode2_);

    /**
     * Destructor
     */
    inline virtual  ~AlphacodeStatus();

    /**
     * Assignment operator
     */
    inline AlphacodeStatus& operator = (const AlphacodeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AlphacodeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AlphacodeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AlphacodeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AlphacodeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Alphacode1"

    static const int kAlphacode1 = 0;

    /**
     * Clears the field "Alphacode1".
     *
     * The field will be set to its default value. The hasAlphacode1()
     * method will return false.
     */
    inline void clearAlphacode1();

    /**
     * Checks whether the field "Alphacode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode1()). Otherwise it will return false.
     */
    inline bool hasAlphacode1 () const;

    /**
     * Returns the value of the member "Alphacode1".
     *
     * First character of alphacode.
     *
     * @return The value of the field "Alphacode1"
     */
    inline uint8 getAlphacode1 () const;

    /**
     * Sets the value of the member "Alphacode1".
     *
     * First character of alphacode.
     *
     * @param Alphacode1 The value which will be set
     */
    inline void setAlphacode1 (uint8 Alphacode1_);

    // API of field "Alphacode2"

    static const int kAlphacode2 = 1;

    /**
     * Clears the field "Alphacode2".
     *
     * The field will be set to its default value. The hasAlphacode2()
     * method will return false.
     */
    inline void clearAlphacode2();

    /**
     * Checks whether the field "Alphacode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode2()). Otherwise it will return false.
     */
    inline bool hasAlphacode2 () const;

    /**
     * Returns the value of the member "Alphacode2".
     *
     * Second character of alphacode.
     *
     * @return The value of the field "Alphacode2"
     */
    inline uint8 getAlphacode2 () const;

    /**
     * Sets the value of the member "Alphacode2".
     *
     * Second character of alphacode.
     *
     * @param Alphacode2 The value which will be set
     */
    inline void setAlphacode2 (uint8 Alphacode2_);

    static const AlphacodeStatus &getDefaultInstance();

private:

    inline void set_has_Alphacode1 ();

    inline void clear_has_Alphacode1 ();

    inline void set_has_Alphacode2 ();

    inline void clear_has_Alphacode2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Alphacode1;

    uint8 _Alphacode2;

};

/**
 * The set message of the property "Alphacode"
 * <p>Set or get the alphacodes needed for diagnosis.</p>
 */
class AlphacodeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AlphacodeSet ();

    /**
     * Copy constructor
     */
    inline  AlphacodeSet (const AlphacodeSet &rhs);

    /**
     * All fields constructor
     */
    inline  AlphacodeSet (const ::std::string& Part_, uint8 Alphacode1_, uint8 Alphacode2_);

    /**
     * Destructor
     */
    inline virtual  ~AlphacodeSet();

    /**
     * Assignment operator
     */
    inline AlphacodeSet& operator = (const AlphacodeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AlphacodeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AlphacodeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AlphacodeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AlphacodeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     * The part for which the new alphacode shall be set for.
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the new alphacode shall be set for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the new alphacode shall be set for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the new alphacode shall be set for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    /**
     * Release the object stored in the field "Part".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Part"
     */
    inline ::std::string* releasePart();

    /**
     * Replace the field "Part".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePart (::std::string* Part_);

    // API of field "Alphacode1"

    static const int kAlphacode1 = 1;

    /**
     * Clears the field "Alphacode1".
     *
     * The field will be set to its default value. The hasAlphacode1()
     * method will return false.
     */
    inline void clearAlphacode1();

    /**
     * Checks whether the field "Alphacode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode1()). Otherwise it will return false.
     */
    inline bool hasAlphacode1 () const;

    /**
     * Returns the value of the member "Alphacode1".
     *
     * First character of alphacode.
     *
     * @return The value of the field "Alphacode1"
     */
    inline uint8 getAlphacode1 () const;

    /**
     * Sets the value of the member "Alphacode1".
     *
     * First character of alphacode.
     *
     * @param Alphacode1 The value which will be set
     */
    inline void setAlphacode1 (uint8 Alphacode1_);

    // API of field "Alphacode2"

    static const int kAlphacode2 = 2;

    /**
     * Clears the field "Alphacode2".
     *
     * The field will be set to its default value. The hasAlphacode2()
     * method will return false.
     */
    inline void clearAlphacode2();

    /**
     * Checks whether the field "Alphacode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode2()). Otherwise it will return false.
     */
    inline bool hasAlphacode2 () const;

    /**
     * Returns the value of the member "Alphacode2".
     *
     * Second character of alphacode.
     *
     * @return The value of the field "Alphacode2"
     */
    inline uint8 getAlphacode2 () const;

    /**
     * Sets the value of the member "Alphacode2".
     *
     * Second character of alphacode.
     *
     * @param Alphacode2 The value which will be set
     */
    inline void setAlphacode2 (uint8 Alphacode2_);

    static const AlphacodeSet &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    inline void set_has_Alphacode1 ();

    inline void clear_has_Alphacode1 ();

    inline void set_has_Alphacode2 ();

    inline void clear_has_Alphacode2 ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _Part;

    uint8 _Alphacode1;

    uint8 _Alphacode2;

};

/**
 * The get message of the property "Alphacode"
 * <p>Set or get the alphacodes needed for diagnosis.</p>
 */
class AlphacodeGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AlphacodeGet ();

    /**
     * Copy constructor
     */
    inline  AlphacodeGet (const AlphacodeGet &rhs);

    /**
     * All fields constructor
     */
    inline  AlphacodeGet (const ::std::string& Part_);

    /**
     * Destructor
     */
    inline virtual  ~AlphacodeGet();

    /**
     * Assignment operator
     */
    inline AlphacodeGet& operator = (const AlphacodeGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AlphacodeGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AlphacodeGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AlphacodeGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AlphacodeGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     * The part for which the alphacode is requested for.
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the alphacode is requested for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the alphacode is requested for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     * The part for which the alphacode is requested for.
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    /**
     * Release the object stored in the field "Part".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Part"
     */
    inline ::std::string* releasePart();

    /**
     * Replace the field "Part".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePart (::std::string* Part_);

    static const AlphacodeGet &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _Part;

};

/**
 * The status message of the property "Alphacodes"
 * <p>Get all parts of the system and their alphacodes.</p>
 */
class AlphacodesStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AlphacodesStatus ();

    /**
     * Copy constructor
     */
    inline  AlphacodesStatus (const AlphacodesStatus &rhs);

    /**
     * All fields constructor
     */
    inline  AlphacodesStatus (const ::spm_core_fi_types::T_SPM_AlphacodeList& Parts_);

    /**
     * Destructor
     */
    inline virtual  ~AlphacodesStatus();

    /**
     * Assignment operator
     */
    inline AlphacodesStatus& operator = (const AlphacodesStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AlphacodesStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AlphacodesStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AlphacodesStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AlphacodesStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Parts"

    static const int kParts = 0;

    /**
     * Clears the field "Parts".
     *
     * The field will be set to its default value. The hasParts()
     * method will return false.
     */
    inline void clearParts();

    /**
     * Checks whether the field "Parts" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setParts()). Otherwise it will return false.
     */
    inline bool hasParts () const;

    /**
     * Returns the value of the member "Parts".
     *
     * Returns all parts and their corresponding alphacodes.
     *
     * @return The value of the field "Parts"
     */
    inline const ::spm_core_fi_types::T_SPM_AlphacodeList& getParts () const;

    /**
     * Retrieves the value of the field "Parts" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Parts".
     */
    inline ::spm_core_fi_types::T_SPM_AlphacodeList& getPartsMutable ();

    /**
     * Sets the value of the member "Parts".
     *
     * Returns all parts and their corresponding alphacodes.
     *
     * @param Parts The value which will be set
     */
    inline void setParts (const ::spm_core_fi_types::T_SPM_AlphacodeList& Parts_);

    /**
     * Release the object stored in the field "Parts".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Parts"
     */
    inline ::spm_core_fi_types::T_SPM_AlphacodeList* releaseParts();

    /**
     * Replace the field "Parts".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceParts (::spm_core_fi_types::T_SPM_AlphacodeList* Parts_);

    static const AlphacodesStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_AlphacodeItem >& getT_SPM_AlphacodeItemPointerList_DefaultInstance ();

    inline void set_has_Parts ();

    inline void clear_has_Parts ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_AlphacodeList* _Parts;

};

/**
 * The start message of the method "SetFactorySettingsNew"
 * <p>This function request the component to set all Variables (depending on USER, TEF or OEM) to default</p>
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>Service ID - CCA_C_U16_SRV_SPM,</p>
 * <p>App ID - CCA_C_U16_APP_SPM</p>
 * <p>Function ID - MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new request if the process is still running. The Component itself must decide what to do. Normally the component itself have do decide if it has to re-trigger or wait for the last answer. Independent of that it has to confirm the new request.
 */
class SetFactorySettingsNewStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewStart ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewStart (const SetFactorySettingsNewStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewStart (::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_, ::spm_diag_defset_fi_types::T_e8_DefSetMode DefSetStateMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewStart();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewStart& operator = (const SetFactorySettingsNewStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Unique Diaglog Group
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Unique Diaglog Group
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::spm_diag_defset_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::spm_diag_defset_fi_types::T_e8_DefSetMode DefSetStateMode_);

    static const SetFactorySettingsNewStart &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType _DefSetStateGroup;

    ::spm_diag_defset_fi_types::T_e8_DefSetMode _DefSetStateMode;

};

/**
 * The result message of the method "SetFactorySettingsNew"
 * <p>This function request the component to set all Variables (depending on USER, TEF or OEM) to default</p>
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS,</p>
 * <p>Service ID - CCA_C_U16_SRV_SPM,</p>
 * <p>App ID - CCA_C_U16_APP_SPM</p>
 * <p>Function ID - MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components, else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new request if the process is still running. The Component itself must decide what to do. Normally the component itself have do decide if it has to re-trigger or wait for the last answer. Independent of that it has to confirm the new request.
 */
class SetFactorySettingsNewResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewResult ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewResult (const SetFactorySettingsNewResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewResult (::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_, ::spm_diag_defset_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewResult();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewResult& operator = (const SetFactorySettingsNewResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>Unique Diaglog Group</p>
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>Unique Diaglog Group</p>
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::spm_diag_defset_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER, TEF, OEM, GET</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::spm_diag_defset_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    // API of field "DefSetStateFirstDifferentParameterId"

    static const int kDefSetStateFirstDifferentParameterId = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterId".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterId()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterId();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterId()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterId () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>not supported.</p>
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterId"
     */
    inline uint16 getDefSetStateFirstDifferentParameterId () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>not supported.</p>
     *
     * @param DefSetStateFirstDifferentParameterId The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_);

    static const SetFactorySettingsNewResult &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    inline void set_has_DefSetStateFirstDifferentParameterId ();

    inline void clear_has_DefSetStateFirstDifferentParameterId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType _DefSetStateGroup;

    ::spm_diag_defset_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _DefSetStateSuccessful;

    uint16 _DefSetStateFirstDifferentParameterId;

};

/**
 * The status message of the property "ManufacturersEnableCounter"
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).
 * Status message with the MEC value
 */
class ManufacturersEnableCounterStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManufacturersEnableCounterStatus ();

    /**
     * Copy constructor
     */
    inline  ManufacturersEnableCounterStatus (const ManufacturersEnableCounterStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ManufacturersEnableCounterStatus (uint8 MEC_);

    /**
     * Destructor
     */
    inline virtual  ~ManufacturersEnableCounterStatus();

    /**
     * Assignment operator
     */
    inline ManufacturersEnableCounterStatus& operator = (const ManufacturersEnableCounterStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManufacturersEnableCounterStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManufacturersEnableCounterStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManufacturersEnableCounterStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManufacturersEnableCounterStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MEC"

    static const int kMEC = 0;

    /**
     * Clears the field "MEC".
     *
     * The field will be set to its default value. The hasMEC()
     * method will return false.
     */
    inline void clearMEC();

    /**
     * Checks whether the field "MEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMEC()). Otherwise it will return false.
     */
    inline bool hasMEC () const;

    /**
     * Returns the value of the member "MEC".
     *
     * Value of internalMEC
     *
     * @return The value of the field "MEC"
     */
    inline uint8 getMEC () const;

    /**
     * Sets the value of the member "MEC".
     *
     * Value of internalMEC
     *
     * @param MEC The value which will be set
     */
    inline void setMEC (uint8 MEC_);

    static const ManufacturersEnableCounterStatus &getDefaultInstance();

private:

    inline void set_has_MEC ();

    inline void clear_has_MEC ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MEC;

};

/**
 * The set message of the property "ManufacturersEnableCounter"
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).
 * Set message for the MEC value
 */
class ManufacturersEnableCounterSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ManufacturersEnableCounterSet ();

    /**
     * Copy constructor
     */
    inline  ManufacturersEnableCounterSet (const ManufacturersEnableCounterSet &rhs);

    /**
     * All fields constructor
     */
    inline  ManufacturersEnableCounterSet (uint8 MEC_);

    /**
     * Destructor
     */
    inline virtual  ~ManufacturersEnableCounterSet();

    /**
     * Assignment operator
     */
    inline ManufacturersEnableCounterSet& operator = (const ManufacturersEnableCounterSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ManufacturersEnableCounterSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ManufacturersEnableCounterSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ManufacturersEnableCounterSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ManufacturersEnableCounterSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MEC"

    static const int kMEC = 0;

    /**
     * Clears the field "MEC".
     *
     * The field will be set to its default value. The hasMEC()
     * method will return false.
     */
    inline void clearMEC();

    /**
     * Checks whether the field "MEC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMEC()). Otherwise it will return false.
     */
    inline bool hasMEC () const;

    /**
     * Returns the value of the member "MEC".
     *
     * Value for diagnose
     *
     * @return The value of the field "MEC"
     */
    inline uint8 getMEC () const;

    /**
     * Sets the value of the member "MEC".
     *
     * Value for diagnose
     *
     * @param MEC The value which will be set
     */
    inline void setMEC (uint8 MEC_);

    static const ManufacturersEnableCounterSet &getDefaultInstance();

private:

    inline void set_has_MEC ();

    inline void clear_has_MEC ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _MEC;

};

/**
 * The status message of the property "NoCalibrationState"
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS).
 * Current No Calibration state.
 */
class NoCalibrationStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NoCalibrationStateStatus ();

    /**
     * Copy constructor
     */
    inline  NoCalibrationStateStatus (const NoCalibrationStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  NoCalibrationStateStatus (bool State_);

    /**
     * Destructor
     */
    inline virtual  ~NoCalibrationStateStatus();

    /**
     * Assignment operator
     */
    inline NoCalibrationStateStatus& operator = (const NoCalibrationStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NoCalibrationStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NoCalibrationStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NoCalibrationStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NoCalibrationStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Current No Calibration state.
     *
     * @return The value of the field "State"
     */
    inline bool getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Current No Calibration state.
     *
     * @param State The value which will be set
     */
    inline void setState (bool State_);

    static const NoCalibrationStateStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _State;

};

/**
 * The set message of the property "NoCalibrationState"
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS).
 * Set the current No Calibration state.
 */
class NoCalibrationStateSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NoCalibrationStateSet ();

    /**
     * Copy constructor
     */
    inline  NoCalibrationStateSet (const NoCalibrationStateSet &rhs);

    /**
     * All fields constructor
     */
    inline  NoCalibrationStateSet (bool State_);

    /**
     * Destructor
     */
    inline virtual  ~NoCalibrationStateSet();

    /**
     * Assignment operator
     */
    inline NoCalibrationStateSet& operator = (const NoCalibrationStateSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NoCalibrationStateSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NoCalibrationStateSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NoCalibrationStateSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NoCalibrationStateSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * Value coming from Diagnosis: TRUE=NoCalibration, FALSE=Device is calibrated.
     *
     * @return The value of the field "State"
     */
    inline bool getState () const;

    /**
     * Sets the value of the member "State".
     *
     * Value coming from Diagnosis: TRUE=NoCalibration, FALSE=Device is calibrated.
     *
     * @param State The value which will be set
     */
    inline void setState (bool State_);

    static const NoCalibrationStateSet &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _State;

};

/**
 * The status message of the property "SecurityCommError"
 * Communication error count detected by SPM security component.
 * FUNCID = FID_SPM_SEC_COMM_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class SecurityCommErrorStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityCommErrorStatus ();

    /**
     * Copy constructor
     */
    inline  SecurityCommErrorStatus (const SecurityCommErrorStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityCommErrorStatus (uint16 CommErrorCount_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityCommErrorStatus();

    /**
     * Assignment operator
     */
    inline SecurityCommErrorStatus& operator = (const SecurityCommErrorStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityCommErrorStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityCommErrorStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityCommErrorStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityCommErrorStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CommErrorCount"

    static const int kCommErrorCount = 0;

    /**
     * Clears the field "CommErrorCount".
     *
     * The field will be set to its default value. The hasCommErrorCount()
     * method will return false.
     */
    inline void clearCommErrorCount();

    /**
     * Checks whether the field "CommErrorCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCommErrorCount()). Otherwise it will return false.
     */
    inline bool hasCommErrorCount () const;

    /**
     * Returns the value of the member "CommErrorCount".
     *
     * Number of Communication errors.
     *
     * @return The value of the field "CommErrorCount"
     */
    inline uint16 getCommErrorCount () const;

    /**
     * Sets the value of the member "CommErrorCount".
     *
     * Number of Communication errors.
     *
     * @param CommErrorCount The value which will be set
     */
    inline void setCommErrorCount (uint16 CommErrorCount_);

    static const SecurityCommErrorStatus &getDefaultInstance();

private:

    inline void set_has_CommErrorCount ();

    inline void clear_has_CommErrorCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _CommErrorCount;

};

/**
 * The status message of the property "SecurityMoreThan10Vin"
 * More than 10 VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class SecurityMoreThan10VinStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityMoreThan10VinStatus ();

    /**
     * Copy constructor
     */
    inline  SecurityMoreThan10VinStatus (const SecurityMoreThan10VinStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityMoreThan10VinStatus (uint16 MoreThan10VinCount_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityMoreThan10VinStatus();

    /**
     * Assignment operator
     */
    inline SecurityMoreThan10VinStatus& operator = (const SecurityMoreThan10VinStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityMoreThan10VinStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityMoreThan10VinStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityMoreThan10VinStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityMoreThan10VinStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MoreThan10VinCount"

    static const int kMoreThan10VinCount = 0;

    /**
     * Clears the field "MoreThan10VinCount".
     *
     * The field will be set to its default value. The hasMoreThan10VinCount()
     * method will return false.
     */
    inline void clearMoreThan10VinCount();

    /**
     * Checks whether the field "MoreThan10VinCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMoreThan10VinCount()). Otherwise it will return false.
     */
    inline bool hasMoreThan10VinCount () const;

    /**
     * Returns the value of the member "MoreThan10VinCount".
     *
     * More than 10 VINs count.
     *
     * @return The value of the field "MoreThan10VinCount"
     */
    inline uint16 getMoreThan10VinCount () const;

    /**
     * Sets the value of the member "MoreThan10VinCount".
     *
     * More than 10 VINs count.
     *
     * @param MoreThan10VinCount The value which will be set
     */
    inline void setMoreThan10VinCount (uint16 MoreThan10VinCount_);

    static const SecurityMoreThan10VinStatus &getDefaultInstance();

private:

    inline void set_has_MoreThan10VinCount ();

    inline void clear_has_MoreThan10VinCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _MoreThan10VinCount;

};

/**
 * The status message of the property "SecurityInvalidVin"
 * Number of invalid VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class SecurityInvalidVinStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityInvalidVinStatus ();

    /**
     * Copy constructor
     */
    inline  SecurityInvalidVinStatus (const SecurityInvalidVinStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityInvalidVinStatus (uint16 InvalidVinCount_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityInvalidVinStatus();

    /**
     * Assignment operator
     */
    inline SecurityInvalidVinStatus& operator = (const SecurityInvalidVinStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityInvalidVinStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityInvalidVinStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityInvalidVinStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityInvalidVinStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InvalidVinCount"

    static const int kInvalidVinCount = 0;

    /**
     * Clears the field "InvalidVinCount".
     *
     * The field will be set to its default value. The hasInvalidVinCount()
     * method will return false.
     */
    inline void clearInvalidVinCount();

    /**
     * Checks whether the field "InvalidVinCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInvalidVinCount()). Otherwise it will return false.
     */
    inline bool hasInvalidVinCount () const;

    /**
     * Returns the value of the member "InvalidVinCount".
     *
     * Number of invalid VINs.
     *
     * @return The value of the field "InvalidVinCount"
     */
    inline uint16 getInvalidVinCount () const;

    /**
     * Sets the value of the member "InvalidVinCount".
     *
     * Number of invalid VINs.
     *
     * @param InvalidVinCount The value which will be set
     */
    inline void setInvalidVinCount (uint16 InvalidVinCount_);

    static const SecurityInvalidVinStatus &getDefaultInstance();

private:

    inline void set_has_InvalidVinCount ();

    inline void clear_has_InvalidVinCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _InvalidVinCount;

};

/**
 * The status message of the property "SecurityCurrentVin"
 * Current VIN detected by SPM security component (17 bytes).
 * FUNCID = FID_SPM_SEC_CURRENT_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class SecurityCurrentVinStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityCurrentVinStatus ();

    /**
     * Copy constructor
     */
    inline  SecurityCurrentVinStatus (const SecurityCurrentVinStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityCurrentVinStatus (const ::spm_core_fi_types::T_SPM_Vin& CurrentVin_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityCurrentVinStatus();

    /**
     * Assignment operator
     */
    inline SecurityCurrentVinStatus& operator = (const SecurityCurrentVinStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityCurrentVinStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityCurrentVinStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityCurrentVinStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityCurrentVinStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentVin"

    static const int kCurrentVin = 0;

    /**
     * Clears the field "CurrentVin".
     *
     * The field will be set to its default value. The hasCurrentVin()
     * method will return false.
     */
    inline void clearCurrentVin();

    /**
     * Checks whether the field "CurrentVin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentVin()). Otherwise it will return false.
     */
    inline bool hasCurrentVin () const;

    /**
     * Returns the value of the member "CurrentVin".
     *
     * current received VIN.
     *
     * @return The value of the field "CurrentVin"
     */
    inline const ::spm_core_fi_types::T_SPM_Vin& getCurrentVin () const;

    /**
     * Retrieves the value of the field "CurrentVin" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentVin".
     */
    inline ::spm_core_fi_types::T_SPM_Vin& getCurrentVinMutable ();

    /**
     * Sets the value of the member "CurrentVin".
     *
     * current received VIN.
     *
     * @param CurrentVin The value which will be set
     */
    inline void setCurrentVin (const ::spm_core_fi_types::T_SPM_Vin& CurrentVin_);

    /**
     * Release the object stored in the field "CurrentVin".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CurrentVin"
     */
    inline ::spm_core_fi_types::T_SPM_Vin* releaseCurrentVin();

    /**
     * Replace the field "CurrentVin".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCurrentVin (::spm_core_fi_types::T_SPM_Vin* CurrentVin_);

    static const SecurityCurrentVinStatus &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_CurrentVin ();

    inline void clear_has_CurrentVin ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_Vin* _CurrentVin;

};

/**
 * The status message of the property "SecurityVinHistory"
 * List of received VINs detected by SPM security component.
 * FUNCID = FID_SPM_SEC_VIN_HISTORY,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= CCA_C_U16_APP_DIAG
 */
class SecurityVinHistoryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityVinHistoryStatus ();

    /**
     * Copy constructor
     */
    inline  SecurityVinHistoryStatus (const SecurityVinHistoryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityVinHistoryStatus (const ::spm_core_fi_types::T_SPM_VinHistory& VinHistory_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityVinHistoryStatus();

    /**
     * Assignment operator
     */
    inline SecurityVinHistoryStatus& operator = (const SecurityVinHistoryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityVinHistoryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityVinHistoryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityVinHistoryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityVinHistoryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VinHistory"

    static const int kVinHistory = 0;

    /**
     * Clears the field "VinHistory".
     *
     * The field will be set to its default value. The hasVinHistory()
     * method will return false.
     */
    inline void clearVinHistory();

    /**
     * Checks whether the field "VinHistory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVinHistory()). Otherwise it will return false.
     */
    inline bool hasVinHistory () const;

    /**
     * Returns the value of the member "VinHistory".
     *
     * List of VINs.
     *
     * @return The value of the field "VinHistory"
     */
    inline const ::spm_core_fi_types::T_SPM_VinHistory& getVinHistory () const;

    /**
     * Retrieves the value of the field "VinHistory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VinHistory".
     */
    inline ::spm_core_fi_types::T_SPM_VinHistory& getVinHistoryMutable ();

    /**
     * Sets the value of the member "VinHistory".
     *
     * List of VINs.
     *
     * @param VinHistory The value which will be set
     */
    inline void setVinHistory (const ::spm_core_fi_types::T_SPM_VinHistory& VinHistory_);

    /**
     * Release the object stored in the field "VinHistory".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "VinHistory"
     */
    inline ::spm_core_fi_types::T_SPM_VinHistory* releaseVinHistory();

    /**
     * Replace the field "VinHistory".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceVinHistory (::spm_core_fi_types::T_SPM_VinHistory* VinHistory_);

    static const SecurityVinHistoryStatus &getDefaultInstance();

private:

    static const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_Vin >& getT_SPM_VinPointerList_DefaultInstance ();

    inline void set_has_VinHistory ();

    inline void clear_has_VinHistory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_VinHistory* _VinHistory;

};

/**
 * The result message of the method "ClearVIN"
 * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.
 * The result of the method. (TRUE = successful, FALSE not successful)
 */
class ClearVINResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearVINResult ();

    /**
     * Copy constructor
     */
    inline  ClearVINResult (const ClearVINResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVINResult (uint32 Result_);

    /**
     * Destructor
     */
    inline virtual  ~ClearVINResult();

    /**
     * Assignment operator
     */
    inline ClearVINResult& operator = (const ClearVINResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVINResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVINResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVINResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVINResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * If the meaning of "Result" isn't clear, then there should be a description here.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint32 Result_);

    static const ClearVINResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Result;

};

/**
 * The status message of the property "VIN"
 * Vehicle Identification Number.
 * FUNCID = FID_SPM_VIN,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	= ...
 */
class VINStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VINStatus ();

    /**
     * Copy constructor
     */
    inline  VINStatus (const VINStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VINStatus (const ::std::string& VehicleIdentificationNumber_);

    /**
     * Destructor
     */
    inline virtual  ~VINStatus();

    /**
     * Assignment operator
     */
    inline VINStatus& operator = (const VINStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VINStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VINStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VINStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VINStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VehicleIdentificationNumber"

    static const int kVehicleIdentificationNumber = 0;

    /**
     * Clears the field "VehicleIdentificationNumber".
     *
     * The field will be set to its default value. The hasVehicleIdentificationNumber()
     * method will return false.
     */
    inline void clearVehicleIdentificationNumber();

    /**
     * Checks whether the field "VehicleIdentificationNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVehicleIdentificationNumber()). Otherwise it will return false.
     */
    inline bool hasVehicleIdentificationNumber () const;

    /**
     * Returns the value of the member "VehicleIdentificationNumber".
     *
     * <p>The current vehicle identification number of this device. Due to the fact that a string can not hold the zero character
     * the representation of VIN is hexadecimal.</p>
     * <p>Therefore the VIN looks like this: "00313233343536373839303132333435"</p>
     *
     * @return The value of the field "VehicleIdentificationNumber"
     */
    inline const ::std::string& getVehicleIdentificationNumber () const;

    /**
     * Retrieves the value of the field "VehicleIdentificationNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VehicleIdentificationNumber".
     */
    inline ::std::string& getVehicleIdentificationNumberMutable ();

    /**
     * Sets the value of the member "VehicleIdentificationNumber".
     *
     * <p>The current vehicle identification number of this device. Due to the fact that a string can not hold the zero character
     * the representation of VIN is hexadecimal.</p>
     * <p>Therefore the VIN looks like this: "00313233343536373839303132333435"</p>
     *
     * @param VehicleIdentificationNumber The value which will be set
     */
    inline void setVehicleIdentificationNumber (const ::std::string& VehicleIdentificationNumber_);

    /**
     * Sets the value of the member "VehicleIdentificationNumber".
     *
     * <p>The current vehicle identification number of this device. Due to the fact that a string can not hold the zero character
     * the representation of VIN is hexadecimal.</p>
     * <p>Therefore the VIN looks like this: "00313233343536373839303132333435"</p>
     *
     * @param VehicleIdentificationNumber The value which will be set
     */
    inline void setVehicleIdentificationNumber (const char* VehicleIdentificationNumber_);

    /**
     * Sets the value of the member "VehicleIdentificationNumber".
     *
     * <p>The current vehicle identification number of this device. Due to the fact that a string can not hold the zero character
     * the representation of VIN is hexadecimal.</p>
     * <p>Therefore the VIN looks like this: "00313233343536373839303132333435"</p>
     *
     * @param VehicleIdentificationNumber The value which will be set
     */
    inline void setVehicleIdentificationNumber (const char* value, size_t size);

    /**
     * Release the object stored in the field "VehicleIdentificationNumber".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "VehicleIdentificationNumber"
     */
    inline ::std::string* releaseVehicleIdentificationNumber();

    /**
     * Replace the field "VehicleIdentificationNumber".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceVehicleIdentificationNumber (::std::string* VehicleIdentificationNumber_);

    static const VINStatus &getDefaultInstance();

private:

    inline void set_has_VehicleIdentificationNumber ();

    inline void clear_has_VehicleIdentificationNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string* _VehicleIdentificationNumber;

};

/**
 * The status message of the property "SecurityState"
 * The SPM tells registered clients the current security state of the system.
 */
class SecurityStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SecurityStateStatus ();

    /**
     * Copy constructor
     */
    inline  SecurityStateStatus (const SecurityStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SecurityStateStatus (::spm_core_fi_types::T_SPM_e32_SECURITY_STATE State_);

    /**
     * Destructor
     */
    inline virtual  ~SecurityStateStatus();

    /**
     * Assignment operator
     */
    inline SecurityStateStatus& operator = (const SecurityStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SecurityStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SecurityStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SecurityStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SecurityStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * The current protection state of the system.
     *
     * @return The value of the field "State"
     */
    inline ::spm_core_fi_types::T_SPM_e32_SECURITY_STATE getState () const;

    /**
     * Sets the value of the member "State".
     *
     * The current protection state of the system.
     *
     * @param State The value which will be set
     */
    inline void setState (::spm_core_fi_types::T_SPM_e32_SECURITY_STATE State_);

    static const SecurityStateStatus &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_SECURITY_STATE _State;

};

/**
 * The status message of the property "VehicleID"
 * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).
 */
class VehicleIDStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VehicleIDStatus ();

    /**
     * Copy constructor
     */
    inline  VehicleIDStatus (const VehicleIDStatus &rhs);

    /**
     * All fields constructor
     */
    inline  VehicleIDStatus (uint32 u32VehicleID_);

    /**
     * Destructor
     */
    inline virtual  ~VehicleIDStatus();

    /**
     * Assignment operator
     */
    inline VehicleIDStatus& operator = (const VehicleIDStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VehicleIDStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VehicleIDStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VehicleIDStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VehicleIDStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32VehicleID"

    static const int kU32VehicleID = 0;

    /**
     * Clears the field "u32VehicleID".
     *
     * The field will be set to its default value. The hasU32VehicleID()
     * method will return false.
     */
    inline void clearU32VehicleID();

    /**
     * Checks whether the field "u32VehicleID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32VehicleID()). Otherwise it will return false.
     */
    inline bool hasU32VehicleID () const;

    /**
     * Returns the value of the member "u32VehicleID".
     *
     * If the meaning of "u32VehicleID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32VehicleID"
     */
    inline uint32 getU32VehicleID () const;

    /**
     * Sets the value of the member "u32VehicleID".
     *
     * If the meaning of "u32VehicleID" isn't clear, then there should be a description here.
     *
     * @param u32VehicleID The value which will be set
     */
    inline void setU32VehicleID (uint32 u32VehicleID_);

    static const VehicleIDStatus &getDefaultInstance();

private:

    inline void set_has_u32VehicleID ();

    inline void clear_has_u32VehicleID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32VehicleID;

};

/**
 * The status message of the property "DisplayVariant"
 * Sets the given display variant number in the datapool and performs a restart of the system.
 * FUNCID = FID_SPM_DISPLAY_VARIANT,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	=
 */
class DisplayVariantStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayVariantStatus ();

    /**
     * Copy constructor
     */
    inline  DisplayVariantStatus (const DisplayVariantStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayVariantStatus (uint32 DisplayVariantNumber_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayVariantStatus();

    /**
     * Assignment operator
     */
    inline DisplayVariantStatus& operator = (const DisplayVariantStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayVariantStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayVariantStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayVariantStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayVariantStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayVariantNumber"

    static const int kDisplayVariantNumber = 0;

    /**
     * Clears the field "DisplayVariantNumber".
     *
     * The field will be set to its default value. The hasDisplayVariantNumber()
     * method will return false.
     */
    inline void clearDisplayVariantNumber();

    /**
     * Checks whether the field "DisplayVariantNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayVariantNumber()). Otherwise it will return false.
     */
    inline bool hasDisplayVariantNumber () const;

    /**
     * Returns the value of the member "DisplayVariantNumber".
     *
     * Display variant used
     *
     * @return The value of the field "DisplayVariantNumber"
     */
    inline uint32 getDisplayVariantNumber () const;

    /**
     * Sets the value of the member "DisplayVariantNumber".
     *
     * Display variant used
     *
     * @param DisplayVariantNumber The value which will be set
     */
    inline void setDisplayVariantNumber (uint32 DisplayVariantNumber_);

    static const DisplayVariantStatus &getDefaultInstance();

private:

    inline void set_has_DisplayVariantNumber ();

    inline void clear_has_DisplayVariantNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DisplayVariantNumber;

};

/**
 * The set message of the property "DisplayVariant"
 * Sets the given display variant number in the datapool and performs a restart of the system.
 * FUNCID = FID_SPM_DISPLAY_VARIANT,
 * SERVICEID = CCA_C_U16_SRV_SPM,
 * APPID = CCA_C_U16_APP_SPM,
 * TARGETID	=
 */
class DisplayVariantSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayVariantSet ();

    /**
     * Copy constructor
     */
    inline  DisplayVariantSet (const DisplayVariantSet &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayVariantSet (uint32 DisplayVariantNumber_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayVariantSet();

    /**
     * Assignment operator
     */
    inline DisplayVariantSet& operator = (const DisplayVariantSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayVariantSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayVariantSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayVariantSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayVariantSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisplayVariantNumber"

    static const int kDisplayVariantNumber = 0;

    /**
     * Clears the field "DisplayVariantNumber".
     *
     * The field will be set to its default value. The hasDisplayVariantNumber()
     * method will return false.
     */
    inline void clearDisplayVariantNumber();

    /**
     * Checks whether the field "DisplayVariantNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisplayVariantNumber()). Otherwise it will return false.
     */
    inline bool hasDisplayVariantNumber () const;

    /**
     * Returns the value of the member "DisplayVariantNumber".
     *
     * Display variant number to use.
     *
     * @return The value of the field "DisplayVariantNumber"
     */
    inline uint32 getDisplayVariantNumber () const;

    /**
     * Sets the value of the member "DisplayVariantNumber".
     *
     * Display variant number to use.
     *
     * @param DisplayVariantNumber The value which will be set
     */
    inline void setDisplayVariantNumber (uint32 DisplayVariantNumber_);

    static const DisplayVariantSet &getDefaultInstance();

private:

    inline void set_has_DisplayVariantNumber ();

    inline void clear_has_DisplayVariantNumber ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DisplayVariantNumber;

};

/**
 * The status message of the property "ReductionLevel"
 * The reduction level is used to tell components to provide normal operation or a reduced operation level.
 */
class ReductionLevelStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReductionLevelStatus ();

    /**
     * Copy constructor
     */
    inline  ReductionLevelStatus (const ReductionLevelStatus &rhs);

    /**
     * All fields constructor
     */
    inline  ReductionLevelStatus (::spm_core_fi_types::T_SPM_e32_REDUCTION_LEVEL ReductionLevelState_);

    /**
     * Destructor
     */
    inline virtual  ~ReductionLevelStatus();

    /**
     * Assignment operator
     */
    inline ReductionLevelStatus& operator = (const ReductionLevelStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReductionLevelStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReductionLevelStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReductionLevelStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReductionLevelStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReductionLevelState"

    static const int kReductionLevelState = 0;

    /**
     * Clears the field "ReductionLevelState".
     *
     * The field will be set to its default value. The hasReductionLevelState()
     * method will return false.
     */
    inline void clearReductionLevelState();

    /**
     * Checks whether the field "ReductionLevelState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReductionLevelState()). Otherwise it will return false.
     */
    inline bool hasReductionLevelState () const;

    /**
     * Returns the value of the member "ReductionLevelState".
     *
     * Reduction level state.
     *
     * @return The value of the field "ReductionLevelState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_REDUCTION_LEVEL getReductionLevelState () const;

    /**
     * Sets the value of the member "ReductionLevelState".
     *
     * Reduction level state.
     *
     * @param ReductionLevelState The value which will be set
     */
    inline void setReductionLevelState (::spm_core_fi_types::T_SPM_e32_REDUCTION_LEVEL ReductionLevelState_);

    static const ReductionLevelStatus &getDefaultInstance();

private:

    inline void set_has_ReductionLevelState ();

    inline void clear_has_ReductionLevelState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_REDUCTION_LEVEL _ReductionLevelState;

};

/**
 * The start message of the method "PrepareDownload"
 * This function prepares the system for download. All components that are not needed are unloaded.
 * <p>FUNCID = FID_SPM_PREPARE_DOWNLOAD,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_SPM,</p>
 * <p>APPID = CCA_C_U16_APP_SPM,</p>
 * <p>TARGETID	= CCA_C_U16_APP_FC_DOWNLOAD</p>
 * The method prepares the system for download. If the method succeeds then the system is in state DOWNLOAD.
 */
class PrepareDownloadStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrepareDownloadStart ();

    /**
     * Copy constructor
     */
    inline  PrepareDownloadStart (const PrepareDownloadStart &rhs);

    /**
     * All fields constructor
     */
    inline  PrepareDownloadStart (uint32 Configuration_, bool SuspendBusShutdown_, uint32 Timeout_);

    /**
     * Destructor
     */
    inline virtual  ~PrepareDownloadStart();

    /**
     * Assignment operator
     */
    inline PrepareDownloadStart& operator = (const PrepareDownloadStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareDownloadStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareDownloadStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareDownloadStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareDownloadStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * In the registry different configurations for DOWNLOAD state have to be defined. With this parameter
     * you can select which configuration shall be used. 0 is the default configuration for SPM.
     *
     * @return The value of the field "Configuration"
     */
    inline uint32 getConfiguration () const;

    /**
     * Sets the value of the member "Configuration".
     *
     * In the registry different configurations for DOWNLOAD state have to be defined. With this parameter
     * you can select which configuration shall be used. 0 is the default configuration for SPM.
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (uint32 Configuration_);

    // API of field "SuspendBusShutdown"

    static const int kSuspendBusShutdown = 1;

    /**
     * Clears the field "SuspendBusShutdown".
     *
     * The field will be set to its default value. The hasSuspendBusShutdown()
     * method will return false.
     */
    inline void clearSuspendBusShutdown();

    /**
     * Checks whether the field "SuspendBusShutdown" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuspendBusShutdown()). Otherwise it will return false.
     */
    inline bool hasSuspendBusShutdown () const;

    /**
     * Returns the value of the member "SuspendBusShutdown".
     *
     * If FC SPM works in MOST slave mode then FC SPM sends always a ResultAck(SUSPEND) after receiving a NetBlock.Shut-down.Query command from network master.
     * This prevents the system from shutting down while a download is active.
     *
     * @return The value of the field "SuspendBusShutdown"
     */
    inline bool getSuspendBusShutdown () const;

    /**
     * Sets the value of the member "SuspendBusShutdown".
     *
     * If FC SPM works in MOST slave mode then FC SPM sends always a ResultAck(SUSPEND) after receiving a NetBlock.Shut-down.Query command from network master.
     * This prevents the system from shutting down while a download is active.
     *
     * @param SuspendBusShutdown The value which will be set
     */
    inline void setSuspendBusShutdown (bool SuspendBusShutdown_);

    // API of field "Timeout"

    static const int kTimeout = 2;

    /**
     * Clears the field "Timeout".
     *
     * The field will be set to its default value. The hasTimeout()
     * method will return false.
     */
    inline void clearTimeout();

    /**
     * Checks whether the field "Timeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeout()). Otherwise it will return false.
     */
    inline bool hasTimeout () const;

    /**
     * Returns the value of the member "Timeout".
     *
     * Timeout is described in seconds. The timeout parameter is the time until which a download has be completely finished. If system is running into this timeout
     * then the download is terminated by SPM supervision logic. If timeout value is 0 it is ignored.
     *
     * @return The value of the field "Timeout"
     */
    inline uint32 getTimeout () const;

    /**
     * Sets the value of the member "Timeout".
     *
     * Timeout is described in seconds. The timeout parameter is the time until which a download has be completely finished. If system is running into this timeout
     * then the download is terminated by SPM supervision logic. If timeout value is 0 it is ignored.
     *
     * @param Timeout The value which will be set
     */
    inline void setTimeout (uint32 Timeout_);

    static const PrepareDownloadStart &getDefaultInstance();

private:

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    inline void set_has_SuspendBusShutdown ();

    inline void clear_has_SuspendBusShutdown ();

    inline void set_has_Timeout ();

    inline void clear_has_Timeout ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _Configuration;

    bool _SuspendBusShutdown;

    uint32 _Timeout;

};

/**
 * The result message of the method "PrepareDownload"
 * This function prepares the system for download. All components that are not needed are unloaded.
 * <p>FUNCID = FID_SPM_PREPARE_DOWNLOAD,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_SPM,</p>
 * <p>APPID = CCA_C_U16_APP_SPM,</p>
 * <p>TARGETID	= CCA_C_U16_APP_FC_DOWNLOAD</p>
 */
class PrepareDownloadResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrepareDownloadResult ();

    /**
     * Copy constructor
     */
    inline  PrepareDownloadResult (const PrepareDownloadResult &rhs);

    /**
     * All fields constructor
     */
    inline  PrepareDownloadResult (uint32 Result_);

    /**
     * Destructor
     */
    inline virtual  ~PrepareDownloadResult();

    /**
     * Assignment operator
     */
    inline PrepareDownloadResult& operator = (const PrepareDownloadResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareDownloadResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareDownloadResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareDownloadResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareDownloadResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * Result of the method.
     *
     * @return The value of the field "Result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * Result of the method.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint32 Result_);

    static const PrepareDownloadResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Result;

};

/**
 * The result message of the method "EndDownload"
 * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.
 * <p>FUNCID = FID_SPM_END_DOWNLOAD,</p>
 * <p>SERVICEID = CCA_C_U16_SRV_SPM,</p>
 * <p>APPID = CCA_C_U16_APP_SPM,</p>
 * <p>TARGETID	= CCA_C_U16_APP_FC_DOWNLOAD</p>
 */
class EndDownloadResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EndDownloadResult ();

    /**
     * Copy constructor
     */
    inline  EndDownloadResult (const EndDownloadResult &rhs);

    /**
     * All fields constructor
     */
    inline  EndDownloadResult (uint32 Result_);

    /**
     * Destructor
     */
    inline virtual  ~EndDownloadResult();

    /**
     * Assignment operator
     */
    inline EndDownloadResult& operator = (const EndDownloadResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EndDownloadResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EndDownloadResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EndDownloadResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EndDownloadResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * Result of the method.
     *
     * @return The value of the field "Result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * Result of the method.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint32 Result_);

    static const EndDownloadResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Result;

};

/**
 * The start message of the method "SetOnConfiguration"
 * <p>This function is used to prepare the correct application configuration for the NAVCOPY download. If end is needed then set
 * the configuration back to 0. Otherwise use the configuration numbers defined in the base.reg. See there for the possible
 * configurations available. If a configuration is not available then SPM switches on the default configuration which is always 0.</p>
 * <p>If the ON state is left and reentered again then the configuration is always set to 0.</p>
 * This method is used to set different application configurations so that a download can be successfully started.
 * If download has finished the configuration set to 0 is used to set all applications back to its default state during
 * ON.
 */
class SetOnConfigurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOnConfigurationStart ();

    /**
     * Copy constructor
     */
    inline  SetOnConfigurationStart (const SetOnConfigurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetOnConfigurationStart (uint32 Configuration_);

    /**
     * Destructor
     */
    inline virtual  ~SetOnConfigurationStart();

    /**
     * Assignment operator
     */
    inline SetOnConfigurationStart& operator = (const SetOnConfigurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOnConfigurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOnConfigurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOnConfigurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOnConfigurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * In the registry different configurations for ON state have to be defined. With this parameter
     * you can select which configuration shall be used. 0 is the default configuration for SPM. This can be used
     * to set all applications back to its normal mode during ON state.
     *
     * @return The value of the field "Configuration"
     */
    inline uint32 getConfiguration () const;

    /**
     * Sets the value of the member "Configuration".
     *
     * In the registry different configurations for ON state have to be defined. With this parameter
     * you can select which configuration shall be used. 0 is the default configuration for SPM. This can be used
     * to set all applications back to its normal mode during ON state.
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (uint32 Configuration_);

    static const SetOnConfigurationStart &getDefaultInstance();

private:

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Configuration;

};

/**
 * The result message of the method "SetOnConfiguration"
 * <p>This function is used to prepare the correct application configuration for the NAVCOPY download. If end is needed then set
 * the configuration back to 0. Otherwise use the configuration numbers defined in the base.reg. See there for the possible
 * configurations available. If a configuration is not available then SPM switches on the default configuration which is always 0.</p>
 * <p>If the ON state is left and reentered again then the configuration is always set to 0.</p>
 */
class SetOnConfigurationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOnConfigurationResult ();

    /**
     * Copy constructor
     */
    inline  SetOnConfigurationResult (const SetOnConfigurationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetOnConfigurationResult (uint32 Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetOnConfigurationResult();

    /**
     * Assignment operator
     */
    inline SetOnConfigurationResult& operator = (const SetOnConfigurationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOnConfigurationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOnConfigurationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOnConfigurationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOnConfigurationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * Result of the method.
     *
     * @return The value of the field "Result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * Result of the method.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint32 Result_);

    static const SetOnConfigurationResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Result;

};

/**
 * The start message of the method "SetProcessConfiguration"
 * <p>This function is used to remove certain processes from the system. All components of this process are sent to OFF
 * before the enclosing process is ended to make sure that LMM data is stored to persistent memory.</p>
 * This method is used to remove processes from the system which are defined in the SPM section of a registry. (Normally base.reg)
 */
class SetProcessConfigurationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProcessConfigurationStart ();

    /**
     * Copy constructor
     */
    inline  SetProcessConfigurationStart (const SetProcessConfigurationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetProcessConfigurationStart (uint32 Configuration_);

    /**
     * Destructor
     */
    inline virtual  ~SetProcessConfigurationStart();

    /**
     * Assignment operator
     */
    inline SetProcessConfigurationStart& operator = (const SetProcessConfigurationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProcessConfigurationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProcessConfigurationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProcessConfigurationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProcessConfigurationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * Selects the configuration to apply to SPM.
     *
     * @return The value of the field "Configuration"
     */
    inline uint32 getConfiguration () const;

    /**
     * Sets the value of the member "Configuration".
     *
     * Selects the configuration to apply to SPM.
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (uint32 Configuration_);

    static const SetProcessConfigurationStart &getDefaultInstance();

private:

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Configuration;

};

/**
 * The result message of the method "SetProcessConfiguration"
 * <p>This function is used to remove certain processes from the system. All components of this process are sent to OFF
 * before the enclosing process is ended to make sure that LMM data is stored to persistent memory.</p>
 */
class SetProcessConfigurationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProcessConfigurationResult ();

    /**
     * Copy constructor
     */
    inline  SetProcessConfigurationResult (const SetProcessConfigurationResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetProcessConfigurationResult (uint32 Result_);

    /**
     * Destructor
     */
    inline virtual  ~SetProcessConfigurationResult();

    /**
     * Assignment operator
     */
    inline SetProcessConfigurationResult& operator = (const SetProcessConfigurationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProcessConfigurationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProcessConfigurationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProcessConfigurationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProcessConfigurationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Result"

    static const int kResult = 0;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * Indicates the result of this method. If 0 then removing of all processes failed. Other values indicate success.
     *
     * @return The value of the field "Result"
     */
    inline uint32 getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * Indicates the result of this method. If 0 then removing of all processes failed. Other values indicate success.
     *
     * @param Result The value which will be set
     */
    inline void setResult (uint32 Result_);

    static const SetProcessConfigurationResult &getDefaultInstance();

private:

    inline void set_has_Result ();

    inline void clear_has_Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Result;

};

/**
 * The status message of the property "StartupState"
 * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".
 */
class StartupStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupStateStatus ();

    /**
     * Copy constructor
     */
    inline  StartupStateStatus (const StartupStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  StartupStateStatus (::spm_core_fi_types::T_SPM_e32_STARTUP_STATE StartupState_);

    /**
     * Destructor
     */
    inline virtual  ~StartupStateStatus();

    /**
     * Assignment operator
     */
    inline StartupStateStatus& operator = (const StartupStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupState"

    static const int kStartupState = 0;

    /**
     * Clears the field "StartupState".
     *
     * The field will be set to its default value. The hasStartupState()
     * method will return false.
     */
    inline void clearStartupState();

    /**
     * Checks whether the field "StartupState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupState()). Otherwise it will return false.
     */
    inline bool hasStartupState () const;

    /**
     * Returns the value of the member "StartupState".
     *
     * Initialized sw blocks (bitcoded).
     *
     * @return The value of the field "StartupState"
     */
    inline ::spm_core_fi_types::T_SPM_e32_STARTUP_STATE getStartupState () const;

    /**
     * Sets the value of the member "StartupState".
     *
     * Initialized sw blocks (bitcoded).
     *
     * @param StartupState The value which will be set
     */
    inline void setStartupState (::spm_core_fi_types::T_SPM_e32_STARTUP_STATE StartupState_);

    static const StartupStateStatus &getDefaultInstance();

private:

    inline void set_has_StartupState ();

    inline void clear_has_StartupState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::spm_core_fi_types::T_SPM_e32_STARTUP_STATE _StartupState;

};

/**
 * The status message of the property "EntertainMute"
 * NISSAN related mute handling. SPM handles Tipper and calculates MuteState.
 * HMI has to follow mute state.
 */
class EntertainMuteStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainMuteStatus ();

    /**
     * Copy constructor
     */
    inline  EntertainMuteStatus (const EntertainMuteStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainMuteStatus (bool bMuteState_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainMuteStatus();

    /**
     * Assignment operator
     */
    inline EntertainMuteStatus& operator = (const EntertainMuteStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainMuteStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainMuteStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainMuteStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainMuteStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bMuteState"

    static const int kBMuteState = 0;

    /**
     * Clears the field "bMuteState".
     *
     * The field will be set to its default value. The hasBMuteState()
     * method will return false.
     */
    inline void clearBMuteState();

    /**
     * Checks whether the field "bMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMuteState()). Otherwise it will return false.
     */
    inline bool hasBMuteState () const;

    /**
     * Returns the value of the member "bMuteState".
     *
     * Current mute state.
     *
     * @return The value of the field "bMuteState"
     */
    inline bool getBMuteState () const;

    /**
     * Sets the value of the member "bMuteState".
     *
     * Current mute state.
     *
     * @param bMuteState The value which will be set
     */
    inline void setBMuteState (bool bMuteState_);

    static const EntertainMuteStatus &getDefaultInstance();

private:

    inline void set_has_bMuteState ();

    inline void clear_has_bMuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bMuteState;

};

/**
 * The result message of the method "EntertainDeMute"
 * Method to trigger a demute by HMI.
 */
class EntertainDeMuteResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainDeMuteResult ();

    /**
     * Copy constructor
     */
    inline  EntertainDeMuteResult (const EntertainDeMuteResult &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainDeMuteResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainDeMuteResult();

    /**
     * Assignment operator
     */
    inline EntertainDeMuteResult& operator = (const EntertainDeMuteResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainDeMuteResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainDeMuteResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainDeMuteResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainDeMuteResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const EntertainDeMuteResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The result message of the method "EntertainMuteRequest"
 * Method to trigger a mute by HMI.
 */
class EntertainMuteRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainMuteRequestResult ();

    /**
     * Copy constructor
     */
    inline  EntertainMuteRequestResult (const EntertainMuteRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainMuteRequestResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainMuteRequestResult();

    /**
     * Assignment operator
     */
    inline EntertainMuteRequestResult& operator = (const EntertainMuteRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainMuteRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainMuteRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainMuteRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainMuteRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const EntertainMuteRequestResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The start message of the method "WelcomeAudioActivation"
 * Method to trigger a mute by HMI.
 */
class WelcomeAudioActivationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeAudioActivationStart ();

    /**
     * Copy constructor
     */
    inline  WelcomeAudioActivationStart (const WelcomeAudioActivationStart &rhs);

    /**
     * All fields constructor
     */
    inline  WelcomeAudioActivationStart (bool bActivateState_);

    /**
     * Destructor
     */
    inline virtual  ~WelcomeAudioActivationStart();

    /**
     * Assignment operator
     */
    inline WelcomeAudioActivationStart& operator = (const WelcomeAudioActivationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeAudioActivationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeAudioActivationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeAudioActivationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeAudioActivationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bActivateState"

    static const int kBActivateState = 0;

    /**
     * Clears the field "bActivateState".
     *
     * The field will be set to its default value. The hasBActivateState()
     * method will return false.
     */
    inline void clearBActivateState();

    /**
     * Checks whether the field "bActivateState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActivateState()). Otherwise it will return false.
     */
    inline bool hasBActivateState () const;

    /**
     * Returns the value of the member "bActivateState".
     *
     * Activate/Deactivate welcome audio for Renault.
     *
     * @return The value of the field "bActivateState"
     */
    inline bool getBActivateState () const;

    /**
     * Sets the value of the member "bActivateState".
     *
     * Activate/Deactivate welcome audio for Renault.
     *
     * @param bActivateState The value which will be set
     */
    inline void setBActivateState (bool bActivateState_);

    static const WelcomeAudioActivationStart &getDefaultInstance();

private:

    inline void set_has_bActivateState ();

    inline void clear_has_bActivateState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bActivateState;

};

/**
 * The result message of the method "WelcomeAudioActivation"
 * Method to trigger a mute by HMI.
 */
class WelcomeAudioActivationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeAudioActivationResult ();

    /**
     * Copy constructor
     */
    inline  WelcomeAudioActivationResult (const WelcomeAudioActivationResult &rhs);

    /**
     * All fields constructor
     */
    inline  WelcomeAudioActivationResult (int32 s32ReturnVal_);

    /**
     * Destructor
     */
    inline virtual  ~WelcomeAudioActivationResult();

    /**
     * Assignment operator
     */
    inline WelcomeAudioActivationResult& operator = (const WelcomeAudioActivationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeAudioActivationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeAudioActivationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeAudioActivationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeAudioActivationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnVal"

    static const int kS32ReturnVal = 0;

    /**
     * Clears the field "s32ReturnVal".
     *
     * The field will be set to its default value. The hasS32ReturnVal()
     * method will return false.
     */
    inline void clearS32ReturnVal();

    /**
     * Checks whether the field "s32ReturnVal" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnVal()). Otherwise it will return false.
     */
    inline bool hasS32ReturnVal () const;

    /**
     * Returns the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnVal"
     */
    inline int32 getS32ReturnVal () const;

    /**
     * Sets the value of the member "s32ReturnVal".
     *
     * If the meaning of "s32ReturnVal" isn't clear, then there should be a description here.
     *
     * @param s32ReturnVal The value which will be set
     */
    inline void setS32ReturnVal (int32 s32ReturnVal_);

    static const WelcomeAudioActivationResult &getDefaultInstance();

private:

    inline void set_has_s32ReturnVal ();

    inline void clear_has_s32ReturnVal ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnVal;

};

/**
 * The status message of the property "WelcomeAudioState"
 * Welcome audio is currently enabled or not.
 */
class WelcomeAudioStateStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeAudioStateStatus ();

    /**
     * Copy constructor
     */
    inline  WelcomeAudioStateStatus (const WelcomeAudioStateStatus &rhs);

    /**
     * All fields constructor
     */
    inline  WelcomeAudioStateStatus (bool bEnabled_);

    /**
     * Destructor
     */
    inline virtual  ~WelcomeAudioStateStatus();

    /**
     * Assignment operator
     */
    inline WelcomeAudioStateStatus& operator = (const WelcomeAudioStateStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeAudioStateStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeAudioStateStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeAudioStateStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeAudioStateStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bEnabled"

    static const int kBEnabled = 0;

    /**
     * Clears the field "bEnabled".
     *
     * The field will be set to its default value. The hasBEnabled()
     * method will return false.
     */
    inline void clearBEnabled();

    /**
     * Checks whether the field "bEnabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEnabled()). Otherwise it will return false.
     */
    inline bool hasBEnabled () const;

    /**
     * Returns the value of the member "bEnabled".
     *
     * Activation state.
     *
     * @return The value of the field "bEnabled"
     */
    inline bool getBEnabled () const;

    /**
     * Sets the value of the member "bEnabled".
     *
     * Activation state.
     *
     * @param bEnabled The value which will be set
     */
    inline void setBEnabled (bool bEnabled_);

    static const WelcomeAudioStateStatus &getDefaultInstance();

private:

    inline void set_has_bEnabled ();

    inline void clear_has_bEnabled ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bEnabled;

};

/**
 * The status message of the property "UnballastTimeFromEngineStopped"
 * Timer which starts when engine is not running before unballast.
 */
class UnballastTimeFromEngineStoppedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnballastTimeFromEngineStoppedStatus ();

    /**
     * Copy constructor
     */
    inline  UnballastTimeFromEngineStoppedStatus (const UnballastTimeFromEngineStoppedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UnballastTimeFromEngineStoppedStatus (uint32 u32TimeFromEngineStopped_);

    /**
     * Destructor
     */
    inline virtual  ~UnballastTimeFromEngineStoppedStatus();

    /**
     * Assignment operator
     */
    inline UnballastTimeFromEngineStoppedStatus& operator = (const UnballastTimeFromEngineStoppedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnballastTimeFromEngineStoppedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnballastTimeFromEngineStoppedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnballastTimeFromEngineStoppedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnballastTimeFromEngineStoppedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32TimeFromEngineStopped"

    static const int kU32TimeFromEngineStopped = 0;

    /**
     * Clears the field "u32TimeFromEngineStopped".
     *
     * The field will be set to its default value. The hasU32TimeFromEngineStopped()
     * method will return false.
     */
    inline void clearU32TimeFromEngineStopped();

    /**
     * Checks whether the field "u32TimeFromEngineStopped" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TimeFromEngineStopped()). Otherwise it will return false.
     */
    inline bool hasU32TimeFromEngineStopped () const;

    /**
     * Returns the value of the member "u32TimeFromEngineStopped".
     *
     * Time in minutes.
     *
     * @return The value of the field "u32TimeFromEngineStopped"
     */
    inline uint32 getU32TimeFromEngineStopped () const;

    /**
     * Sets the value of the member "u32TimeFromEngineStopped".
     *
     * Time in minutes.
     *
     * @param u32TimeFromEngineStopped The value which will be set
     */
    inline void setU32TimeFromEngineStopped (uint32 u32TimeFromEngineStopped_);

    static const UnballastTimeFromEngineStoppedStatus &getDefaultInstance();

private:

    inline void set_has_u32TimeFromEngineStopped ();

    inline void clear_has_u32TimeFromEngineStopped ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32TimeFromEngineStopped;

};

/**
 * The status message of the property "UnballastTimeBeforeUnballast"
 * Time before unballast. Configuration parameter.
 */
class UnballastTimeBeforeUnballastStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnballastTimeBeforeUnballastStatus ();

    /**
     * Copy constructor
     */
    inline  UnballastTimeBeforeUnballastStatus (const UnballastTimeBeforeUnballastStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UnballastTimeBeforeUnballastStatus (uint32 u32UnballastTime_);

    /**
     * Destructor
     */
    inline virtual  ~UnballastTimeBeforeUnballastStatus();

    /**
     * Assignment operator
     */
    inline UnballastTimeBeforeUnballastStatus& operator = (const UnballastTimeBeforeUnballastStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnballastTimeBeforeUnballastStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnballastTimeBeforeUnballastStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnballastTimeBeforeUnballastStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnballastTimeBeforeUnballastStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32UnballastTime"

    static const int kU32UnballastTime = 0;

    /**
     * Clears the field "u32UnballastTime".
     *
     * The field will be set to its default value. The hasU32UnballastTime()
     * method will return false.
     */
    inline void clearU32UnballastTime();

    /**
     * Checks whether the field "u32UnballastTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UnballastTime()). Otherwise it will return false.
     */
    inline bool hasU32UnballastTime () const;

    /**
     * Returns the value of the member "u32UnballastTime".
     *
     * Time in minutes (min=0, max=30, step=1).
     *
     * @return The value of the field "u32UnballastTime"
     */
    inline uint32 getU32UnballastTime () const;

    /**
     * Sets the value of the member "u32UnballastTime".
     *
     * Time in minutes (min=0, max=30, step=1).
     *
     * @param u32UnballastTime The value which will be set
     */
    inline void setU32UnballastTime (uint32 u32UnballastTime_);

    static const UnballastTimeBeforeUnballastStatus &getDefaultInstance();

private:

    inline void set_has_u32UnballastTime ();

    inline void clear_has_u32UnballastTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32UnballastTime;

};

/**
 * The set message of the property "UnballastTimeBeforeUnballast"
 * Time before unballast. Configuration parameter.
 */
class UnballastTimeBeforeUnballastSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnballastTimeBeforeUnballastSet ();

    /**
     * Copy constructor
     */
    inline  UnballastTimeBeforeUnballastSet (const UnballastTimeBeforeUnballastSet &rhs);

    /**
     * All fields constructor
     */
    inline  UnballastTimeBeforeUnballastSet (uint32 u32UnballastTime_);

    /**
     * Destructor
     */
    inline virtual  ~UnballastTimeBeforeUnballastSet();

    /**
     * Assignment operator
     */
    inline UnballastTimeBeforeUnballastSet& operator = (const UnballastTimeBeforeUnballastSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnballastTimeBeforeUnballastSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnballastTimeBeforeUnballastSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnballastTimeBeforeUnballastSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnballastTimeBeforeUnballastSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32UnballastTime"

    static const int kU32UnballastTime = 0;

    /**
     * Clears the field "u32UnballastTime".
     *
     * The field will be set to its default value. The hasU32UnballastTime()
     * method will return false.
     */
    inline void clearU32UnballastTime();

    /**
     * Checks whether the field "u32UnballastTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UnballastTime()). Otherwise it will return false.
     */
    inline bool hasU32UnballastTime () const;

    /**
     * Returns the value of the member "u32UnballastTime".
     *
     * Time in minutes (min=0, max=30, step=1).
     *
     * @return The value of the field "u32UnballastTime"
     */
    inline uint32 getU32UnballastTime () const;

    /**
     * Sets the value of the member "u32UnballastTime".
     *
     * Time in minutes (min=0, max=30, step=1).
     *
     * @param u32UnballastTime The value which will be set
     */
    inline void setU32UnballastTime (uint32 u32UnballastTime_);

    static const UnballastTimeBeforeUnballastSet &getDefaultInstance();

private:

    inline void set_has_u32UnballastTime ();

    inline void clear_has_u32UnballastTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32UnballastTime;

};

/**
 * The status message of the property "UnballastWarningTime"
 * Time warning message is displayed.
 */
class UnballastWarningTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnballastWarningTimeStatus ();

    /**
     * Copy constructor
     */
    inline  UnballastWarningTimeStatus (const UnballastWarningTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  UnballastWarningTimeStatus (uint32 u32UnballastWarningTime_);

    /**
     * Destructor
     */
    inline virtual  ~UnballastWarningTimeStatus();

    /**
     * Assignment operator
     */
    inline UnballastWarningTimeStatus& operator = (const UnballastWarningTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnballastWarningTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnballastWarningTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnballastWarningTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnballastWarningTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32UnballastWarningTime"

    static const int kU32UnballastWarningTime = 0;

    /**
     * Clears the field "u32UnballastWarningTime".
     *
     * The field will be set to its default value. The hasU32UnballastWarningTime()
     * method will return false.
     */
    inline void clearU32UnballastWarningTime();

    /**
     * Checks whether the field "u32UnballastWarningTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UnballastWarningTime()). Otherwise it will return false.
     */
    inline bool hasU32UnballastWarningTime () const;

    /**
     * Returns the value of the member "u32UnballastWarningTime".
     *
     * Time in seconds (min=0sec, max=3min, step=1sec).
     *
     * @return The value of the field "u32UnballastWarningTime"
     */
    inline uint32 getU32UnballastWarningTime () const;

    /**
     * Sets the value of the member "u32UnballastWarningTime".
     *
     * Time in seconds (min=0sec, max=3min, step=1sec).
     *
     * @param u32UnballastWarningTime The value which will be set
     */
    inline void setU32UnballastWarningTime (uint32 u32UnballastWarningTime_);

    static const UnballastWarningTimeStatus &getDefaultInstance();

private:

    inline void set_has_u32UnballastWarningTime ();

    inline void clear_has_u32UnballastWarningTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32UnballastWarningTime;

};

/**
 * The set message of the property "UnballastWarningTime"
 * Time warning message is displayed.
 */
class UnballastWarningTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UnballastWarningTimeSet ();

    /**
     * Copy constructor
     */
    inline  UnballastWarningTimeSet (const UnballastWarningTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  UnballastWarningTimeSet (uint32 u32UnballastWarningTime_);

    /**
     * Destructor
     */
    inline virtual  ~UnballastWarningTimeSet();

    /**
     * Assignment operator
     */
    inline UnballastWarningTimeSet& operator = (const UnballastWarningTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UnballastWarningTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UnballastWarningTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UnballastWarningTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UnballastWarningTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32UnballastWarningTime"

    static const int kU32UnballastWarningTime = 0;

    /**
     * Clears the field "u32UnballastWarningTime".
     *
     * The field will be set to its default value. The hasU32UnballastWarningTime()
     * method will return false.
     */
    inline void clearU32UnballastWarningTime();

    /**
     * Checks whether the field "u32UnballastWarningTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32UnballastWarningTime()). Otherwise it will return false.
     */
    inline bool hasU32UnballastWarningTime () const;

    /**
     * Returns the value of the member "u32UnballastWarningTime".
     *
     * Time in seconds (min=0sec, max=3min, step=1sec).
     *
     * @return The value of the field "u32UnballastWarningTime"
     */
    inline uint32 getU32UnballastWarningTime () const;

    /**
     * Sets the value of the member "u32UnballastWarningTime".
     *
     * Time in seconds (min=0sec, max=3min, step=1sec).
     *
     * @param u32UnballastWarningTime The value which will be set
     */
    inline void setU32UnballastWarningTime (uint32 u32UnballastWarningTime_);

    static const UnballastWarningTimeSet &getDefaultInstance();

private:

    inline void set_has_u32UnballastWarningTime ();

    inline void clear_has_u32UnballastWarningTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32UnballastWarningTime;

};

/**
 * The status message of the property "DegradedCount"
 * Number of Unballast trigger.
 */
class DegradedCountStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DegradedCountStatus ();

    /**
     * Copy constructor
     */
    inline  DegradedCountStatus (const DegradedCountStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DegradedCountStatus (uint32 u32DegradedCount_);

    /**
     * Destructor
     */
    inline virtual  ~DegradedCountStatus();

    /**
     * Assignment operator
     */
    inline DegradedCountStatus& operator = (const DegradedCountStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DegradedCountStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DegradedCountStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DegradedCountStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DegradedCountStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DegradedCount"

    static const int kU32DegradedCount = 0;

    /**
     * Clears the field "u32DegradedCount".
     *
     * The field will be set to its default value. The hasU32DegradedCount()
     * method will return false.
     */
    inline void clearU32DegradedCount();

    /**
     * Checks whether the field "u32DegradedCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DegradedCount()). Otherwise it will return false.
     */
    inline bool hasU32DegradedCount () const;

    /**
     * Returns the value of the member "u32DegradedCount".
     *
     * .
     *
     * @return The value of the field "u32DegradedCount"
     */
    inline uint32 getU32DegradedCount () const;

    /**
     * Sets the value of the member "u32DegradedCount".
     *
     * .
     *
     * @param u32DegradedCount The value which will be set
     */
    inline void setU32DegradedCount (uint32 u32DegradedCount_);

    static const DegradedCountStatus &getDefaultInstance();

private:

    inline void set_has_u32DegradedCount ();

    inline void clear_has_u32DegradedCount ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32DegradedCount;

};

/**
 * The status message of the property "DegradedTime"
 * Accumulated time in Unballast situation.
 */
class DegradedTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DegradedTimeStatus ();

    /**
     * Copy constructor
     */
    inline  DegradedTimeStatus (const DegradedTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DegradedTimeStatus (uint32 u32DegradedTime_);

    /**
     * Destructor
     */
    inline virtual  ~DegradedTimeStatus();

    /**
     * Assignment operator
     */
    inline DegradedTimeStatus& operator = (const DegradedTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DegradedTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DegradedTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DegradedTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DegradedTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DegradedTime"

    static const int kU32DegradedTime = 0;

    /**
     * Clears the field "u32DegradedTime".
     *
     * The field will be set to its default value. The hasU32DegradedTime()
     * method will return false.
     */
    inline void clearU32DegradedTime();

    /**
     * Checks whether the field "u32DegradedTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DegradedTime()). Otherwise it will return false.
     */
    inline bool hasU32DegradedTime () const;

    /**
     * Returns the value of the member "u32DegradedTime".
     *
     * Time in seconds.
     *
     * @return The value of the field "u32DegradedTime"
     */
    inline uint32 getU32DegradedTime () const;

    /**
     * Sets the value of the member "u32DegradedTime".
     *
     * Time in seconds.
     *
     * @param u32DegradedTime The value which will be set
     */
    inline void setU32DegradedTime (uint32 u32DegradedTime_);

    static const DegradedTimeStatus &getDefaultInstance();

private:

    inline void set_has_u32DegradedTime ();

    inline void clear_has_u32DegradedTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32DegradedTime;

};

/**
 * The status message of the property "PhoneHandoverWarnTime"
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active.
 */
class PhoneHandoverWarnTimeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneHandoverWarnTimeStatus ();

    /**
     * Copy constructor
     */
    inline  PhoneHandoverWarnTimeStatus (const PhoneHandoverWarnTimeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneHandoverWarnTimeStatus (uint32 u32Time_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneHandoverWarnTimeStatus();

    /**
     * Assignment operator
     */
    inline PhoneHandoverWarnTimeStatus& operator = (const PhoneHandoverWarnTimeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneHandoverWarnTimeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneHandoverWarnTimeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneHandoverWarnTimeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneHandoverWarnTimeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Time"

    static const int kU32Time = 0;

    /**
     * Clears the field "u32Time".
     *
     * The field will be set to its default value. The hasU32Time()
     * method will return false.
     */
    inline void clearU32Time();

    /**
     * Checks whether the field "u32Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Time()). Otherwise it will return false.
     */
    inline bool hasU32Time () const;

    /**
     * Returns the value of the member "u32Time".
     *
     * If the meaning of "u32Time" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Time"
     */
    inline uint32 getU32Time () const;

    /**
     * Sets the value of the member "u32Time".
     *
     * If the meaning of "u32Time" isn't clear, then there should be a description here.
     *
     * @param u32Time The value which will be set
     */
    inline void setU32Time (uint32 u32Time_);

    static const PhoneHandoverWarnTimeStatus &getDefaultInstance();

private:

    inline void set_has_u32Time ();

    inline void clear_has_u32Time ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Time;

};

/**
 * The set message of the property "PhoneHandoverWarnTime"
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active.
 */
class PhoneHandoverWarnTimeSet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneHandoverWarnTimeSet ();

    /**
     * Copy constructor
     */
    inline  PhoneHandoverWarnTimeSet (const PhoneHandoverWarnTimeSet &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneHandoverWarnTimeSet (uint32 u32Time_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneHandoverWarnTimeSet();

    /**
     * Assignment operator
     */
    inline PhoneHandoverWarnTimeSet& operator = (const PhoneHandoverWarnTimeSet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneHandoverWarnTimeSet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneHandoverWarnTimeSet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneHandoverWarnTimeSet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneHandoverWarnTimeSet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Time"

    static const int kU32Time = 0;

    /**
     * Clears the field "u32Time".
     *
     * The field will be set to its default value. The hasU32Time()
     * method will return false.
     */
    inline void clearU32Time();

    /**
     * Checks whether the field "u32Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Time()). Otherwise it will return false.
     */
    inline bool hasU32Time () const;

    /**
     * Returns the value of the member "u32Time".
     *
     * If the meaning of "u32Time" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Time"
     */
    inline uint32 getU32Time () const;

    /**
     * Sets the value of the member "u32Time".
     *
     * If the meaning of "u32Time" isn't clear, then there should be a description here.
     *
     * @param u32Time The value which will be set
     */
    inline void setU32Time (uint32 u32Time_);

    static const PhoneHandoverWarnTimeSet &getDefaultInstance();

private:

    inline void set_has_u32Time ();

    inline void clear_has_u32Time ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Time;

};

inline  SystemStateStatus::SystemStateStatus ()  :
    _SystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemStateStatus::SystemStateStatus (const SystemStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemStateStatus::SystemStateStatus (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES SystemState_)  :
    _SystemState (SystemState_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_IsValid(SystemState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SystemState_, "T_SPM_e32_SYSTEM_STATES", "SystemState", "SystemStateStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemStateStatus::~SystemStateStatus() {
}

inline SystemStateStatus& SystemStateStatus::operator = (const SystemStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSystemState()) {
            setSystemState(rhs.getSystemState());
        } else {
            clearSystemState();
        }
    }
    return *this;
}

inline bool SystemStateStatus::operator == (const SystemStateStatus& rhs) const {
    return (((!hasSystemState() && !rhs.hasSystemState()) || getSystemState() == rhs.getSystemState()));
}

inline bool SystemStateStatus::operator != (const SystemStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemStateStatus::operator < (const SystemStateStatus& rhs) const {
    if (hasSystemState() || rhs.hasSystemState()) {
        if ((uint32)getSystemState() < (uint32)rhs.getSystemState()) return true;
        if ((uint32)getSystemState() > (uint32)rhs.getSystemState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemStateStatus::clone() {
    return new SystemStateStatus(*this);
}

inline bool SystemStateStatus::operator > (const SystemStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemStateStatus::clear() {
    clearSystemState();
}

inline void SystemStateStatus::clearSystemState() {
    if (hasSystemState()) {
         clear_has_SystemState();
        _SystemState = ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES__SPM_SYSTEM_BACKGROUND;
     }
}

inline bool SystemStateStatus::hasSystemState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES SystemStateStatus::getSystemState () const {
    return _SystemState;
}

inline void SystemStateStatus::setSystemState (::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES SystemState_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES_IsValid(SystemState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SystemState_, "T_SPM_e32_SYSTEM_STATES", "SystemState", "SystemStateStatus");
    }
    #endif
    set_has_SystemState();
    this->_SystemState = SystemState_;
}

inline void SystemStateStatus::set_has_SystemState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemStateStatus::clear_has_SystemState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SystemModeStart::SystemModeStart ()  :
    _eSystemMode (::spm_core_fi_types::T_e8_StateModes__SPM_e8_SysModeDownload)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemModeStart::SystemModeStart (const SystemModeStart &rhs)  :
    ::asf::core::Payload(rhs),
    _eSystemMode (::spm_core_fi_types::T_e8_StateModes__SPM_e8_SysModeDownload)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemModeStart::SystemModeStart (::spm_core_fi_types::T_e8_StateModes eSystemMode_)  :
    _eSystemMode (eSystemMode_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_e8_StateModes_IsValid(eSystemMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSystemMode_, "T_e8_StateModes", "eSystemMode", "SystemModeStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemModeStart::~SystemModeStart() {
}

inline SystemModeStart& SystemModeStart::operator = (const SystemModeStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasESystemMode()) {
            setESystemMode(rhs.getESystemMode());
        } else {
            clearESystemMode();
        }
    }
    return *this;
}

inline bool SystemModeStart::operator == (const SystemModeStart& rhs) const {
    return (((!hasESystemMode() && !rhs.hasESystemMode()) || getESystemMode() == rhs.getESystemMode()));
}

inline bool SystemModeStart::operator != (const SystemModeStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemModeStart::operator < (const SystemModeStart& rhs) const {
    if (hasESystemMode() || rhs.hasESystemMode()) {
        if ((uint32)getESystemMode() < (uint32)rhs.getESystemMode()) return true;
        if ((uint32)getESystemMode() > (uint32)rhs.getESystemMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemModeStart::clone() {
    return new SystemModeStart(*this);
}

inline bool SystemModeStart::operator > (const SystemModeStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemModeStart::clear() {
    clearESystemMode();
}

inline void SystemModeStart::clearESystemMode() {
    if (hasESystemMode()) {
         clear_has_eSystemMode();
        _eSystemMode = ::spm_core_fi_types::T_e8_StateModes__SPM_e8_SysModeDownload;
     }
}

inline bool SystemModeStart::hasESystemMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_e8_StateModes SystemModeStart::getESystemMode () const {
    return _eSystemMode;
}

inline void SystemModeStart::setESystemMode (::spm_core_fi_types::T_e8_StateModes eSystemMode_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_e8_StateModes_IsValid(eSystemMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSystemMode_, "T_e8_StateModes", "eSystemMode", "SystemModeStart");
    }
    #endif
    set_has_eSystemMode();
    this->_eSystemMode = eSystemMode_;
}

inline void SystemModeStart::set_has_eSystemMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemModeStart::clear_has_eSystemMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SystemModeResult::SystemModeResult ()  :
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SystemModeResult::SystemModeResult (const SystemModeResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SystemModeResult::SystemModeResult (int32 s32ReturnVal_)  :
    _s32ReturnVal (s32ReturnVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SystemModeResult::~SystemModeResult() {
}

inline SystemModeResult& SystemModeResult::operator = (const SystemModeResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
    }
    return *this;
}

inline bool SystemModeResult::operator == (const SystemModeResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()));
}

inline bool SystemModeResult::operator != (const SystemModeResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SystemModeResult::operator < (const SystemModeResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SystemModeResult::clone() {
    return new SystemModeResult(*this);
}

inline bool SystemModeResult::operator > (const SystemModeResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SystemModeResult::clear() {
    clearS32ReturnVal();
}

inline void SystemModeResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool SystemModeResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SystemModeResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void SystemModeResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void SystemModeResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void SystemModeResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DownloadLockStateStart::DownloadLockStateStart ()  :
    _strRestrictedDlState (NULL),
    _eRestrictedDlMode (::spm_core_fi_types::T_e8_DownloadLockStates__SPM_e8_DownloadLock)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DownloadLockStateStart::DownloadLockStateStart (const DownloadLockStateStart &rhs)  :
    ::asf::core::Payload(rhs),
    _strRestrictedDlState (NULL),
    _eRestrictedDlMode (::spm_core_fi_types::T_e8_DownloadLockStates__SPM_e8_DownloadLock)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DownloadLockStateStart::DownloadLockStateStart (const ::std::string& strRestrictedDlState_, ::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode_)  :
    _strRestrictedDlState (new ::std::string(strRestrictedDlState_)),
    _eRestrictedDlMode (eRestrictedDlMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strRestrictedDlState_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_e8_DownloadLockStates_IsValid(eRestrictedDlMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRestrictedDlMode_, "T_e8_DownloadLockStates", "eRestrictedDlMode", "DownloadLockStateStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DownloadLockStateStart::~DownloadLockStateStart() {
    delete _strRestrictedDlState;
}

inline DownloadLockStateStart& DownloadLockStateStart::operator = (const DownloadLockStateStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrRestrictedDlState()) {
            setStrRestrictedDlState(rhs.getStrRestrictedDlState());
        } else {
            clearStrRestrictedDlState();
        }
        if (rhs.hasERestrictedDlMode()) {
            setERestrictedDlMode(rhs.getERestrictedDlMode());
        } else {
            clearERestrictedDlMode();
        }
    }
    return *this;
}

inline bool DownloadLockStateStart::operator == (const DownloadLockStateStart& rhs) const {
    return (((!hasStrRestrictedDlState() && !rhs.hasStrRestrictedDlState()) || getStrRestrictedDlState() == rhs.getStrRestrictedDlState()) &&
        ((!hasERestrictedDlMode() && !rhs.hasERestrictedDlMode()) || getERestrictedDlMode() == rhs.getERestrictedDlMode()));
}

inline bool DownloadLockStateStart::operator != (const DownloadLockStateStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DownloadLockStateStart::operator < (const DownloadLockStateStart& rhs) const {
    if (hasStrRestrictedDlState() || rhs.hasStrRestrictedDlState()) {
        if (getStrRestrictedDlState() < rhs.getStrRestrictedDlState()) return true;
        if (getStrRestrictedDlState() > rhs.getStrRestrictedDlState()) return false;
    }
    if (hasERestrictedDlMode() || rhs.hasERestrictedDlMode()) {
        if ((uint32)getERestrictedDlMode() < (uint32)rhs.getERestrictedDlMode()) return true;
        if ((uint32)getERestrictedDlMode() > (uint32)rhs.getERestrictedDlMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DownloadLockStateStart::clone() {
    return new DownloadLockStateStart(*this);
}

inline bool DownloadLockStateStart::operator > (const DownloadLockStateStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DownloadLockStateStart::clear() {
    clearStrRestrictedDlState();
    clearERestrictedDlMode();
}

inline void DownloadLockStateStart::clearStrRestrictedDlState() {
    if (hasStrRestrictedDlState()) {
         clear_has_strRestrictedDlState();
        if (_strRestrictedDlState != NULL) {
            _strRestrictedDlState->clear();
        }
     }
}

inline bool DownloadLockStateStart::hasStrRestrictedDlState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DownloadLockStateStart::getStrRestrictedDlState () const {
    if (_strRestrictedDlState == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strRestrictedDlState;
}

inline ::std::string& DownloadLockStateStart::getStrRestrictedDlStateMutable () {
    set_has_strRestrictedDlState();
    if (_strRestrictedDlState == NULL) {
        _strRestrictedDlState = new ::std::string ();
        CHECK_ALLOCATION( _strRestrictedDlState );
    }
    return *_strRestrictedDlState;
}

inline void DownloadLockStateStart::setStrRestrictedDlState (const ::std::string& strRestrictedDlState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strRestrictedDlState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strRestrictedDlState();
    if (this->_strRestrictedDlState == NULL) {
        this->_strRestrictedDlState = new ::std::string (strRestrictedDlState_);
        CHECK_ALLOCATION( this->_strRestrictedDlState );
    } else {
        *this->_strRestrictedDlState = strRestrictedDlState_;
    }
}

inline void DownloadLockStateStart::setStrRestrictedDlState (const char* strRestrictedDlState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strRestrictedDlState_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strRestrictedDlState();
    if (this->_strRestrictedDlState == NULL) {
        this->_strRestrictedDlState = new ::std::string (strRestrictedDlState_);
        CHECK_ALLOCATION( this->_strRestrictedDlState );
    } else {
        this->_strRestrictedDlState->assign(strRestrictedDlState_);
    }
}

inline void DownloadLockStateStart::setStrRestrictedDlState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strRestrictedDlState();
    if (this->_strRestrictedDlState == NULL) {
        this->_strRestrictedDlState = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strRestrictedDlState );
    } else {
        this->_strRestrictedDlState->assign(value, size);
    }
}

inline ::std::string* DownloadLockStateStart::releaseStrRestrictedDlState() {
    clear_has_strRestrictedDlState();
    ::std::string* temp = _strRestrictedDlState;
    this->_strRestrictedDlState = NULL;
    return temp;
}

inline void DownloadLockStateStart::replaceStrRestrictedDlState (::std::string* strRestrictedDlState_) {
    set_has_strRestrictedDlState();
    if (this->_strRestrictedDlState != strRestrictedDlState_) {
        if (this->_strRestrictedDlState != NULL) {
            delete this->_strRestrictedDlState;
        }
        this->_strRestrictedDlState = strRestrictedDlState_;
    }
}

inline void DownloadLockStateStart::clearERestrictedDlMode() {
    if (hasERestrictedDlMode()) {
         clear_has_eRestrictedDlMode();
        _eRestrictedDlMode = ::spm_core_fi_types::T_e8_DownloadLockStates__SPM_e8_DownloadLock;
     }
}

inline bool DownloadLockStateStart::hasERestrictedDlMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::spm_core_fi_types::T_e8_DownloadLockStates DownloadLockStateStart::getERestrictedDlMode () const {
    return _eRestrictedDlMode;
}

inline void DownloadLockStateStart::setERestrictedDlMode (::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_e8_DownloadLockStates_IsValid(eRestrictedDlMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eRestrictedDlMode_, "T_e8_DownloadLockStates", "eRestrictedDlMode", "DownloadLockStateStart");
    }
    #endif
    set_has_eRestrictedDlMode();
    this->_eRestrictedDlMode = eRestrictedDlMode_;
}

inline void DownloadLockStateStart::set_has_strRestrictedDlState () {
    _has_bits_[0] |= 1u << 0;
}

inline void DownloadLockStateStart::clear_has_strRestrictedDlState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DownloadLockStateStart::set_has_eRestrictedDlMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void DownloadLockStateStart::clear_has_eRestrictedDlMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DownloadLockStateResult::DownloadLockStateResult ()  :
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DownloadLockStateResult::DownloadLockStateResult (const DownloadLockStateResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DownloadLockStateResult::DownloadLockStateResult (int32 s32ReturnVal_)  :
    _s32ReturnVal (s32ReturnVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DownloadLockStateResult::~DownloadLockStateResult() {
}

inline DownloadLockStateResult& DownloadLockStateResult::operator = (const DownloadLockStateResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
    }
    return *this;
}

inline bool DownloadLockStateResult::operator == (const DownloadLockStateResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()));
}

inline bool DownloadLockStateResult::operator != (const DownloadLockStateResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DownloadLockStateResult::operator < (const DownloadLockStateResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DownloadLockStateResult::clone() {
    return new DownloadLockStateResult(*this);
}

inline bool DownloadLockStateResult::operator > (const DownloadLockStateResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DownloadLockStateResult::clear() {
    clearS32ReturnVal();
}

inline void DownloadLockStateResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool DownloadLockStateResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 DownloadLockStateResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void DownloadLockStateResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void DownloadLockStateResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void DownloadLockStateResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DownloadLockStatesStatus::DownloadLockStatesStatus ()  :
    _listRestrictedLock (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DownloadLockStatesStatus::DownloadLockStatesStatus (const DownloadLockStatesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _listRestrictedLock (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DownloadLockStatesStatus::DownloadLockStatesStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& listRestrictedLock_)  :
    _listRestrictedLock (new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >(listRestrictedLock_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DownloadLockStatesStatus::~DownloadLockStatesStatus() {
    delete _listRestrictedLock;
}

inline DownloadLockStatesStatus& DownloadLockStatesStatus::operator = (const DownloadLockStatesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasListRestrictedLock()) {
            setListRestrictedLock(rhs.getListRestrictedLock());
        } else {
            clearListRestrictedLock();
        }
    }
    return *this;
}

inline bool DownloadLockStatesStatus::operator == (const DownloadLockStatesStatus& rhs) const {
    return (((!hasListRestrictedLock() && !rhs.hasListRestrictedLock()) || getListRestrictedLock() == rhs.getListRestrictedLock()));
}

inline bool DownloadLockStatesStatus::operator != (const DownloadLockStatesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DownloadLockStatesStatus::operator < (const DownloadLockStatesStatus& rhs) const {
    if (hasListRestrictedLock() || rhs.hasListRestrictedLock()) {
        if (getListRestrictedLock() < rhs.getListRestrictedLock()) return true;
        if (getListRestrictedLock() > rhs.getListRestrictedLock()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DownloadLockStatesStatus::clone() {
    return new DownloadLockStatesStatus(*this);
}

inline bool DownloadLockStatesStatus::operator > (const DownloadLockStatesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DownloadLockStatesStatus::clear() {
    clearListRestrictedLock();
}

inline void DownloadLockStatesStatus::clearListRestrictedLock() {
    if (hasListRestrictedLock()) {
         clear_has_listRestrictedLock();
        if (_listRestrictedLock != NULL) {
            _listRestrictedLock->clear();
        }
     }
}

inline bool DownloadLockStatesStatus::hasListRestrictedLock () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& DownloadLockStatesStatus::getListRestrictedLock () const {
    if (_listRestrictedLock == NULL) {
        return getT_SPM_RestrictedDlLockPointerList_DefaultInstance();
    }
    return *_listRestrictedLock;
}

inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& DownloadLockStatesStatus::getListRestrictedLockMutable () {
    set_has_listRestrictedLock();
    if (_listRestrictedLock == NULL) {
        _listRestrictedLock = new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock > ();
        CHECK_ALLOCATION( _listRestrictedLock );
    }
    return *_listRestrictedLock;
}

inline void DownloadLockStatesStatus::setListRestrictedLock (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >& listRestrictedLock_) {
    set_has_listRestrictedLock();
    if (this->_listRestrictedLock == NULL) {
        this->_listRestrictedLock = new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock > (listRestrictedLock_);
        CHECK_ALLOCATION( this->_listRestrictedLock );
    } else {
        *this->_listRestrictedLock = listRestrictedLock_;
    }
}

inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >* DownloadLockStatesStatus::releaseListRestrictedLock() {
    clear_has_listRestrictedLock();
    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >* temp = _listRestrictedLock;
    this->_listRestrictedLock = NULL;
    return temp;
}

inline void DownloadLockStatesStatus::replaceListRestrictedLock (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_RestrictedDlLock >* listRestrictedLock_) {
    set_has_listRestrictedLock();
    if (this->_listRestrictedLock != listRestrictedLock_) {
        if (this->_listRestrictedLock != NULL) {
            delete this->_listRestrictedLock;
        }
        this->_listRestrictedLock = listRestrictedLock_;
    }
}

inline void DownloadLockStatesStatus::set_has_listRestrictedLock () {
    _has_bits_[0] |= 1u << 0;
}

inline void DownloadLockStatesStatus::clear_has_listRestrictedLock () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateLockStart::UpdateLockStart ()  :
    _strLockName (NULL),
    _eLockRequest (::spm_core_fi_types::T_e8_UpdateLockCommand__SPM_e8_Use)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateLockStart::UpdateLockStart (const UpdateLockStart &rhs)  :
    ::asf::core::Payload(rhs),
    _strLockName (NULL),
    _eLockRequest (::spm_core_fi_types::T_e8_UpdateLockCommand__SPM_e8_Use)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateLockStart::UpdateLockStart (const ::std::string& strLockName_, ::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest_)  :
    _strLockName (new ::std::string(strLockName_)),
    _eLockRequest (eLockRequest_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLockName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_e8_UpdateLockCommand_IsValid(eLockRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eLockRequest_, "T_e8_UpdateLockCommand", "eLockRequest", "UpdateLockStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateLockStart::~UpdateLockStart() {
    delete _strLockName;
}

inline UpdateLockStart& UpdateLockStart::operator = (const UpdateLockStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStrLockName()) {
            setStrLockName(rhs.getStrLockName());
        } else {
            clearStrLockName();
        }
        if (rhs.hasELockRequest()) {
            setELockRequest(rhs.getELockRequest());
        } else {
            clearELockRequest();
        }
    }
    return *this;
}

inline bool UpdateLockStart::operator == (const UpdateLockStart& rhs) const {
    return (((!hasStrLockName() && !rhs.hasStrLockName()) || getStrLockName() == rhs.getStrLockName()) &&
        ((!hasELockRequest() && !rhs.hasELockRequest()) || getELockRequest() == rhs.getELockRequest()));
}

inline bool UpdateLockStart::operator != (const UpdateLockStart& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateLockStart::operator < (const UpdateLockStart& rhs) const {
    if (hasStrLockName() || rhs.hasStrLockName()) {
        if (getStrLockName() < rhs.getStrLockName()) return true;
        if (getStrLockName() > rhs.getStrLockName()) return false;
    }
    if (hasELockRequest() || rhs.hasELockRequest()) {
        if ((uint32)getELockRequest() < (uint32)rhs.getELockRequest()) return true;
        if ((uint32)getELockRequest() > (uint32)rhs.getELockRequest()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateLockStart::clone() {
    return new UpdateLockStart(*this);
}

inline bool UpdateLockStart::operator > (const UpdateLockStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateLockStart::clear() {
    clearStrLockName();
    clearELockRequest();
}

inline void UpdateLockStart::clearStrLockName() {
    if (hasStrLockName()) {
         clear_has_strLockName();
        if (_strLockName != NULL) {
            _strLockName->clear();
        }
     }
}

inline bool UpdateLockStart::hasStrLockName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& UpdateLockStart::getStrLockName () const {
    if (_strLockName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_strLockName;
}

inline ::std::string& UpdateLockStart::getStrLockNameMutable () {
    set_has_strLockName();
    if (_strLockName == NULL) {
        _strLockName = new ::std::string ();
        CHECK_ALLOCATION( _strLockName );
    }
    return *_strLockName;
}

inline void UpdateLockStart::setStrLockName (const ::std::string& strLockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLockName();
    if (this->_strLockName == NULL) {
        this->_strLockName = new ::std::string (strLockName_);
        CHECK_ALLOCATION( this->_strLockName );
    } else {
        *this->_strLockName = strLockName_;
    }
}

inline void UpdateLockStart::setStrLockName (const char* strLockName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strLockName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLockName();
    if (this->_strLockName == NULL) {
        this->_strLockName = new ::std::string (strLockName_);
        CHECK_ALLOCATION( this->_strLockName );
    } else {
        this->_strLockName->assign(strLockName_);
    }
}

inline void UpdateLockStart::setStrLockName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strLockName();
    if (this->_strLockName == NULL) {
        this->_strLockName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_strLockName );
    } else {
        this->_strLockName->assign(value, size);
    }
}

inline ::std::string* UpdateLockStart::releaseStrLockName() {
    clear_has_strLockName();
    ::std::string* temp = _strLockName;
    this->_strLockName = NULL;
    return temp;
}

inline void UpdateLockStart::replaceStrLockName (::std::string* strLockName_) {
    set_has_strLockName();
    if (this->_strLockName != strLockName_) {
        if (this->_strLockName != NULL) {
            delete this->_strLockName;
        }
        this->_strLockName = strLockName_;
    }
}

inline void UpdateLockStart::clearELockRequest() {
    if (hasELockRequest()) {
         clear_has_eLockRequest();
        _eLockRequest = ::spm_core_fi_types::T_e8_UpdateLockCommand__SPM_e8_Use;
     }
}

inline bool UpdateLockStart::hasELockRequest () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::spm_core_fi_types::T_e8_UpdateLockCommand UpdateLockStart::getELockRequest () const {
    return _eLockRequest;
}

inline void UpdateLockStart::setELockRequest (::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_e8_UpdateLockCommand_IsValid(eLockRequest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eLockRequest_, "T_e8_UpdateLockCommand", "eLockRequest", "UpdateLockStart");
    }
    #endif
    set_has_eLockRequest();
    this->_eLockRequest = eLockRequest_;
}

inline void UpdateLockStart::set_has_strLockName () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateLockStart::clear_has_strLockName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void UpdateLockStart::set_has_eLockRequest () {
    _has_bits_[0] |= 1u << 1;
}

inline void UpdateLockStart::clear_has_eLockRequest () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  UpdateLockResult::UpdateLockResult ()  :
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateLockResult::UpdateLockResult (const UpdateLockResult &rhs)  :
    ::asf::core::Payload(rhs),
    _s32ReturnVal (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateLockResult::UpdateLockResult (int32 s32ReturnVal_)  :
    _s32ReturnVal (s32ReturnVal_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateLockResult::~UpdateLockResult() {
}

inline UpdateLockResult& UpdateLockResult::operator = (const UpdateLockResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32ReturnVal()) {
            setS32ReturnVal(rhs.getS32ReturnVal());
        } else {
            clearS32ReturnVal();
        }
    }
    return *this;
}

inline bool UpdateLockResult::operator == (const UpdateLockResult& rhs) const {
    return (((!hasS32ReturnVal() && !rhs.hasS32ReturnVal()) || getS32ReturnVal() == rhs.getS32ReturnVal()));
}

inline bool UpdateLockResult::operator != (const UpdateLockResult& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateLockResult::operator < (const UpdateLockResult& rhs) const {
    if (hasS32ReturnVal() || rhs.hasS32ReturnVal()) {
        if (getS32ReturnVal() < rhs.getS32ReturnVal()) return true;
        if (getS32ReturnVal() > rhs.getS32ReturnVal()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateLockResult::clone() {
    return new UpdateLockResult(*this);
}

inline bool UpdateLockResult::operator > (const UpdateLockResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateLockResult::clear() {
    clearS32ReturnVal();
}

inline void UpdateLockResult::clearS32ReturnVal() {
    if (hasS32ReturnVal()) {
         clear_has_s32ReturnVal();
        _s32ReturnVal = 0;
     }
}

inline bool UpdateLockResult::hasS32ReturnVal () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 UpdateLockResult::getS32ReturnVal () const {
    return _s32ReturnVal;
}

inline void UpdateLockResult::setS32ReturnVal (int32 s32ReturnVal_) {
    set_has_s32ReturnVal();
    this->_s32ReturnVal = s32ReturnVal_;
}

inline void UpdateLockResult::set_has_s32ReturnVal () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateLockResult::clear_has_s32ReturnVal () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  UpdateLockStatesStatus::UpdateLockStatesStatus ()  :
    _lLocks (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  UpdateLockStatesStatus::UpdateLockStatesStatus (const UpdateLockStatesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _lLocks (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  UpdateLockStatesStatus::UpdateLockStatesStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& lLocks_)  :
    _lLocks (new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >(lLocks_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  UpdateLockStatesStatus::~UpdateLockStatesStatus() {
    delete _lLocks;
}

inline UpdateLockStatesStatus& UpdateLockStatesStatus::operator = (const UpdateLockStatesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLLocks()) {
            setLLocks(rhs.getLLocks());
        } else {
            clearLLocks();
        }
    }
    return *this;
}

inline bool UpdateLockStatesStatus::operator == (const UpdateLockStatesStatus& rhs) const {
    return (((!hasLLocks() && !rhs.hasLLocks()) || getLLocks() == rhs.getLLocks()));
}

inline bool UpdateLockStatesStatus::operator != (const UpdateLockStatesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool UpdateLockStatesStatus::operator < (const UpdateLockStatesStatus& rhs) const {
    if (hasLLocks() || rhs.hasLLocks()) {
        if (getLLocks() < rhs.getLLocks()) return true;
        if (getLLocks() > rhs.getLLocks()) return false;
    }
    return false;
}

inline ::asf::core::Payload* UpdateLockStatesStatus::clone() {
    return new UpdateLockStatesStatus(*this);
}

inline bool UpdateLockStatesStatus::operator > (const UpdateLockStatesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void UpdateLockStatesStatus::clear() {
    clearLLocks();
}

inline void UpdateLockStatesStatus::clearLLocks() {
    if (hasLLocks()) {
         clear_has_lLocks();
        if (_lLocks != NULL) {
            _lLocks->clear();
        }
     }
}

inline bool UpdateLockStatesStatus::hasLLocks () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& UpdateLockStatesStatus::getLLocks () const {
    if (_lLocks == NULL) {
        return getT_SPM_UpdateLockStatePointerList_DefaultInstance();
    }
    return *_lLocks;
}

inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& UpdateLockStatesStatus::getLLocksMutable () {
    set_has_lLocks();
    if (_lLocks == NULL) {
        _lLocks = new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState > ();
        CHECK_ALLOCATION( _lLocks );
    }
    return *_lLocks;
}

inline void UpdateLockStatesStatus::setLLocks (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >& lLocks_) {
    set_has_lLocks();
    if (this->_lLocks == NULL) {
        this->_lLocks = new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState > (lLocks_);
        CHECK_ALLOCATION( this->_lLocks );
    } else {
        *this->_lLocks = lLocks_;
    }
}

inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >* UpdateLockStatesStatus::releaseLLocks() {
    clear_has_lLocks();
    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >* temp = _lLocks;
    this->_lLocks = NULL;
    return temp;
}

inline void UpdateLockStatesStatus::replaceLLocks (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_UpdateLockState >* lLocks_) {
    set_has_lLocks();
    if (this->_lLocks != lLocks_) {
        if (this->_lLocks != NULL) {
            delete this->_lLocks;
        }
        this->_lLocks = lLocks_;
    }
}

inline void UpdateLockStatesStatus::set_has_lLocks () {
    _has_bits_[0] |= 1u << 0;
}

inline void UpdateLockStatesStatus::clear_has_lLocks () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  OnOffTriggerStart::OnOffTriggerStart ()  :
    _eSwitchOnTrigger (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS),
    _bState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnOffTriggerStart::OnOffTriggerStart (const OnOffTriggerStart &rhs)  :
    ::asf::core::Payload(rhs),
    _eSwitchOnTrigger (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS),
    _bState (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnOffTriggerStart::OnOffTriggerStart (::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger_, bool bState_)  :
    _eSwitchOnTrigger (eSwitchOnTrigger_),
    _bState (bState_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_SubStateType_IsValid(eSwitchOnTrigger_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSwitchOnTrigger_, "T_SPM_e32_SubStateType", "eSwitchOnTrigger", "OnOffTriggerStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnOffTriggerStart::~OnOffTriggerStart() {
}

inline OnOffTriggerStart& OnOffTriggerStart::operator = (const OnOffTriggerStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasESwitchOnTrigger()) {
            setESwitchOnTrigger(rhs.getESwitchOnTrigger());
        } else {
            clearESwitchOnTrigger();
        }
        if (rhs.hasBState()) {
            setBState(rhs.getBState());
        } else {
            clearBState();
        }
    }
    return *this;
}

inline bool OnOffTriggerStart::operator == (const OnOffTriggerStart& rhs) const {
    return (((!hasESwitchOnTrigger() && !rhs.hasESwitchOnTrigger()) || getESwitchOnTrigger() == rhs.getESwitchOnTrigger()) &&
        ((!hasBState() && !rhs.hasBState()) || getBState() == rhs.getBState()));
}

inline bool OnOffTriggerStart::operator != (const OnOffTriggerStart& rhs) const {
    return ! (*this == rhs);
}

inline bool OnOffTriggerStart::operator < (const OnOffTriggerStart& rhs) const {
    if (hasESwitchOnTrigger() || rhs.hasESwitchOnTrigger()) {
        if ((uint32)getESwitchOnTrigger() < (uint32)rhs.getESwitchOnTrigger()) return true;
        if ((uint32)getESwitchOnTrigger() > (uint32)rhs.getESwitchOnTrigger()) return false;
    }
    if (hasBState() || rhs.hasBState()) {
        if (getBState() < rhs.getBState()) return true;
        if (getBState() > rhs.getBState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnOffTriggerStart::clone() {
    return new OnOffTriggerStart(*this);
}

inline bool OnOffTriggerStart::operator > (const OnOffTriggerStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnOffTriggerStart::clear() {
    clearESwitchOnTrigger();
    clearBState();
}

inline void OnOffTriggerStart::clearESwitchOnTrigger() {
    if (hasESwitchOnTrigger()) {
         clear_has_eSwitchOnTrigger();
        _eSwitchOnTrigger = ::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS;
     }
}

inline bool OnOffTriggerStart::hasESwitchOnTrigger () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_SubStateType OnOffTriggerStart::getESwitchOnTrigger () const {
    return _eSwitchOnTrigger;
}

inline void OnOffTriggerStart::setESwitchOnTrigger (::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_SubStateType_IsValid(eSwitchOnTrigger_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSwitchOnTrigger_, "T_SPM_e32_SubStateType", "eSwitchOnTrigger", "OnOffTriggerStart");
    }
    #endif
    set_has_eSwitchOnTrigger();
    this->_eSwitchOnTrigger = eSwitchOnTrigger_;
}

inline void OnOffTriggerStart::clearBState() {
    if (hasBState()) {
         clear_has_bState();
        _bState = false;
     }
}

inline bool OnOffTriggerStart::hasBState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool OnOffTriggerStart::getBState () const {
    return _bState;
}

inline void OnOffTriggerStart::setBState (bool bState_) {
    set_has_bState();
    this->_bState = bState_;
}

inline void OnOffTriggerStart::set_has_eSwitchOnTrigger () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnOffTriggerStart::clear_has_eSwitchOnTrigger () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void OnOffTriggerStart::set_has_bState () {
    _has_bits_[0] |= 1u << 1;
}

inline void OnOffTriggerStart::clear_has_bState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ActiveOnOffTriggerStatus::ActiveOnOffTriggerStatus ()  :
    _tOnOffTriggerList (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ActiveOnOffTriggerStatus::ActiveOnOffTriggerStatus (const ActiveOnOffTriggerStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tOnOffTriggerList (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ActiveOnOffTriggerStatus::ActiveOnOffTriggerStatus (const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& tOnOffTriggerList_)  :
    _tOnOffTriggerList (new ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >(tOnOffTriggerList_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ActiveOnOffTriggerStatus::~ActiveOnOffTriggerStatus() {
    delete _tOnOffTriggerList;
}

inline ActiveOnOffTriggerStatus& ActiveOnOffTriggerStatus::operator = (const ActiveOnOffTriggerStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTOnOffTriggerList()) {
            setTOnOffTriggerList(rhs.getTOnOffTriggerList());
        } else {
            clearTOnOffTriggerList();
        }
    }
    return *this;
}

inline bool ActiveOnOffTriggerStatus::operator == (const ActiveOnOffTriggerStatus& rhs) const {
    return (((!hasTOnOffTriggerList() && !rhs.hasTOnOffTriggerList()) || getTOnOffTriggerList() == rhs.getTOnOffTriggerList()));
}

inline bool ActiveOnOffTriggerStatus::operator != (const ActiveOnOffTriggerStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool ActiveOnOffTriggerStatus::operator < (const ActiveOnOffTriggerStatus& rhs) const {
    if (hasTOnOffTriggerList() || rhs.hasTOnOffTriggerList()) {
        if (getTOnOffTriggerList() < rhs.getTOnOffTriggerList()) return true;
        if (getTOnOffTriggerList() > rhs.getTOnOffTriggerList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ActiveOnOffTriggerStatus::clone() {
    return new ActiveOnOffTriggerStatus(*this);
}

inline bool ActiveOnOffTriggerStatus::operator > (const ActiveOnOffTriggerStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ActiveOnOffTriggerStatus::clear() {
    clearTOnOffTriggerList();
}

inline void ActiveOnOffTriggerStatus::clearTOnOffTriggerList() {
    if (hasTOnOffTriggerList()) {
         clear_has_tOnOffTriggerList();
        if (_tOnOffTriggerList != NULL) {
            _tOnOffTriggerList->clear();
        }
     }
}

inline bool ActiveOnOffTriggerStatus::hasTOnOffTriggerList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& ActiveOnOffTriggerStatus::getTOnOffTriggerList () const {
    if (_tOnOffTriggerList == NULL) {
        return getT_SPM_e32_SubStateTypeList_DefaultInstance();
    }
    return *_tOnOffTriggerList;
}

inline ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& ActiveOnOffTriggerStatus::getTOnOffTriggerListMutable () {
    set_has_tOnOffTriggerList();
    if (_tOnOffTriggerList == NULL) {
        _tOnOffTriggerList = new ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType > ();
        CHECK_ALLOCATION( _tOnOffTriggerList );
    }
    return *_tOnOffTriggerList;
}

inline void ActiveOnOffTriggerStatus::setTOnOffTriggerList (const ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >& tOnOffTriggerList_) {
    set_has_tOnOffTriggerList();
    if (this->_tOnOffTriggerList == NULL) {
        this->_tOnOffTriggerList = new ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType > (tOnOffTriggerList_);
        CHECK_ALLOCATION( this->_tOnOffTriggerList );
    } else {
        *this->_tOnOffTriggerList = tOnOffTriggerList_;
    }
}

inline ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >* ActiveOnOffTriggerStatus::releaseTOnOffTriggerList() {
    clear_has_tOnOffTriggerList();
    ::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >* temp = _tOnOffTriggerList;
    this->_tOnOffTriggerList = NULL;
    return temp;
}

inline void ActiveOnOffTriggerStatus::replaceTOnOffTriggerList (::std::vector< ::spm_core_fi_types::T_SPM_e32_SubStateType >* tOnOffTriggerList_) {
    set_has_tOnOffTriggerList();
    if (this->_tOnOffTriggerList != tOnOffTriggerList_) {
        if (this->_tOnOffTriggerList != NULL) {
            delete this->_tOnOffTriggerList;
        }
        this->_tOnOffTriggerList = tOnOffTriggerList_;
    }
}

inline void ActiveOnOffTriggerStatus::set_has_tOnOffTriggerList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ActiveOnOffTriggerStatus::clear_has_tOnOffTriggerList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SubStatesStatus::SubStatesStatus ()  :
    _SubState (0u),
    _HwSubState (0u),
    _InternSubState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubStatesStatus::SubStatesStatus (const SubStatesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _SubState (0u),
    _HwSubState (0u),
    _InternSubState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubStatesStatus::SubStatesStatus (uint32 SubState_, uint32 HwSubState_, uint32 InternSubState_)  :
    _SubState (SubState_),
    _HwSubState (HwSubState_),
    _InternSubState (InternSubState_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubStatesStatus::~SubStatesStatus() {
}

inline SubStatesStatus& SubStatesStatus::operator = (const SubStatesStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSubState()) {
            setSubState(rhs.getSubState());
        } else {
            clearSubState();
        }
        if (rhs.hasHwSubState()) {
            setHwSubState(rhs.getHwSubState());
        } else {
            clearHwSubState();
        }
        if (rhs.hasInternSubState()) {
            setInternSubState(rhs.getInternSubState());
        } else {
            clearInternSubState();
        }
    }
    return *this;
}

inline bool SubStatesStatus::operator == (const SubStatesStatus& rhs) const {
    return (((!hasSubState() && !rhs.hasSubState()) || getSubState() == rhs.getSubState()) &&
        ((!hasHwSubState() && !rhs.hasHwSubState()) || getHwSubState() == rhs.getHwSubState()) &&
        ((!hasInternSubState() && !rhs.hasInternSubState()) || getInternSubState() == rhs.getInternSubState()));
}

inline bool SubStatesStatus::operator != (const SubStatesStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SubStatesStatus::operator < (const SubStatesStatus& rhs) const {
    if (hasSubState() || rhs.hasSubState()) {
        if (getSubState() < rhs.getSubState()) return true;
        if (getSubState() > rhs.getSubState()) return false;
    }
    if (hasHwSubState() || rhs.hasHwSubState()) {
        if (getHwSubState() < rhs.getHwSubState()) return true;
        if (getHwSubState() > rhs.getHwSubState()) return false;
    }
    if (hasInternSubState() || rhs.hasInternSubState()) {
        if (getInternSubState() < rhs.getInternSubState()) return true;
        if (getInternSubState() > rhs.getInternSubState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubStatesStatus::clone() {
    return new SubStatesStatus(*this);
}

inline bool SubStatesStatus::operator > (const SubStatesStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubStatesStatus::clear() {
    clearSubState();
    clearHwSubState();
    clearInternSubState();
}

inline void SubStatesStatus::clearSubState() {
    if (hasSubState()) {
         clear_has_SubState();
        _SubState = 0u;
     }
}

inline bool SubStatesStatus::hasSubState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 SubStatesStatus::getSubState () const {
    return _SubState;
}

inline void SubStatesStatus::setSubState (uint32 SubState_) {
    set_has_SubState();
    this->_SubState = SubState_;
}

inline void SubStatesStatus::clearHwSubState() {
    if (hasHwSubState()) {
         clear_has_HwSubState();
        _HwSubState = 0u;
     }
}

inline bool SubStatesStatus::hasHwSubState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 SubStatesStatus::getHwSubState () const {
    return _HwSubState;
}

inline void SubStatesStatus::setHwSubState (uint32 HwSubState_) {
    set_has_HwSubState();
    this->_HwSubState = HwSubState_;
}

inline void SubStatesStatus::clearInternSubState() {
    if (hasInternSubState()) {
         clear_has_InternSubState();
        _InternSubState = 0u;
     }
}

inline bool SubStatesStatus::hasInternSubState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 SubStatesStatus::getInternSubState () const {
    return _InternSubState;
}

inline void SubStatesStatus::setInternSubState (uint32 InternSubState_) {
    set_has_InternSubState();
    this->_InternSubState = InternSubState_;
}

inline void SubStatesStatus::set_has_SubState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubStatesStatus::clear_has_SubState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SubStatesStatus::set_has_HwSubState () {
    _has_bits_[0] |= 1u << 1;
}

inline void SubStatesStatus::clear_has_HwSubState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SubStatesStatus::set_has_InternSubState () {
    _has_bits_[0] |= 1u << 2;
}

inline void SubStatesStatus::clear_has_InternSubState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SubStatesSet::SubStatesSet ()  :
    _SubStateType (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS),
    _SubStateData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SubStatesSet::SubStatesSet (const SubStatesSet &rhs)  :
    ::asf::core::Payload(rhs),
    _SubStateType (::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS),
    _SubStateData (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SubStatesSet::SubStatesSet (::spm_core_fi_types::T_SPM_e32_SubStateType SubStateType_, bool SubStateData_)  :
    _SubStateType (SubStateType_),
    _SubStateData (SubStateData_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_SubStateType_IsValid(SubStateType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SubStateType_, "T_SPM_e32_SubStateType", "SubStateType", "SubStatesSet");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SubStatesSet::~SubStatesSet() {
}

inline SubStatesSet& SubStatesSet::operator = (const SubStatesSet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSubStateType()) {
            setSubStateType(rhs.getSubStateType());
        } else {
            clearSubStateType();
        }
        if (rhs.hasSubStateData()) {
            setSubStateData(rhs.getSubStateData());
        } else {
            clearSubStateData();
        }
    }
    return *this;
}

inline bool SubStatesSet::operator == (const SubStatesSet& rhs) const {
    return (((!hasSubStateType() && !rhs.hasSubStateType()) || getSubStateType() == rhs.getSubStateType()) &&
        ((!hasSubStateData() && !rhs.hasSubStateData()) || getSubStateData() == rhs.getSubStateData()));
}

inline bool SubStatesSet::operator != (const SubStatesSet& rhs) const {
    return ! (*this == rhs);
}

inline bool SubStatesSet::operator < (const SubStatesSet& rhs) const {
    if (hasSubStateType() || rhs.hasSubStateType()) {
        if ((uint32)getSubStateType() < (uint32)rhs.getSubStateType()) return true;
        if ((uint32)getSubStateType() > (uint32)rhs.getSubStateType()) return false;
    }
    if (hasSubStateData() || rhs.hasSubStateData()) {
        if (getSubStateData() < rhs.getSubStateData()) return true;
        if (getSubStateData() > rhs.getSubStateData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SubStatesSet::clone() {
    return new SubStatesSet(*this);
}

inline bool SubStatesSet::operator > (const SubStatesSet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SubStatesSet::clear() {
    clearSubStateType();
    clearSubStateData();
}

inline void SubStatesSet::clearSubStateType() {
    if (hasSubStateType()) {
         clear_has_SubStateType();
        _SubStateType = ::spm_core_fi_types::T_SPM_e32_SubStateType__SPM_U32_SUBSTATE_SET_SD_CARD_ACCESS;
     }
}

inline bool SubStatesSet::hasSubStateType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_SubStateType SubStatesSet::getSubStateType () const {
    return _SubStateType;
}

inline void SubStatesSet::setSubStateType (::spm_core_fi_types::T_SPM_e32_SubStateType SubStateType_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_SubStateType_IsValid(SubStateType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SubStateType_, "T_SPM_e32_SubStateType", "SubStateType", "SubStatesSet");
    }
    #endif
    set_has_SubStateType();
    this->_SubStateType = SubStateType_;
}

inline void SubStatesSet::clearSubStateData() {
    if (hasSubStateData()) {
         clear_has_SubStateData();
        _SubStateData = false;
     }
}

inline bool SubStatesSet::hasSubStateData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SubStatesSet::getSubStateData () const {
    return _SubStateData;
}

inline void SubStatesSet::setSubStateData (bool SubStateData_) {
    set_has_SubStateData();
    this->_SubStateData = SubStateData_;
}

inline void SubStatesSet::set_has_SubStateType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SubStatesSet::clear_has_SubStateType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SubStatesSet::set_has_SubStateData () {
    _has_bits_[0] |= 1u << 1;
}

inline void SubStatesSet::clear_has_SubStateData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  HistoryTriggerStatus::HistoryTriggerStatus ()  :
    _tTriggeredStates (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  HistoryTriggerStatus::HistoryTriggerStatus (const HistoryTriggerStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tTriggeredStates (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  HistoryTriggerStatus::HistoryTriggerStatus (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& tTriggeredStates_)  :
    _tTriggeredStates (new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >(tTriggeredStates_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  HistoryTriggerStatus::~HistoryTriggerStatus() {
    delete _tTriggeredStates;
}

inline HistoryTriggerStatus& HistoryTriggerStatus::operator = (const HistoryTriggerStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTriggeredStates()) {
            setTTriggeredStates(rhs.getTTriggeredStates());
        } else {
            clearTTriggeredStates();
        }
    }
    return *this;
}

inline bool HistoryTriggerStatus::operator == (const HistoryTriggerStatus& rhs) const {
    return (((!hasTTriggeredStates() && !rhs.hasTTriggeredStates()) || getTTriggeredStates() == rhs.getTTriggeredStates()));
}

inline bool HistoryTriggerStatus::operator != (const HistoryTriggerStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool HistoryTriggerStatus::operator < (const HistoryTriggerStatus& rhs) const {
    if (hasTTriggeredStates() || rhs.hasTTriggeredStates()) {
        if (getTTriggeredStates() < rhs.getTTriggeredStates()) return true;
        if (getTTriggeredStates() > rhs.getTTriggeredStates()) return false;
    }
    return false;
}

inline ::asf::core::Payload* HistoryTriggerStatus::clone() {
    return new HistoryTriggerStatus(*this);
}

inline bool HistoryTriggerStatus::operator > (const HistoryTriggerStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void HistoryTriggerStatus::clear() {
    clearTTriggeredStates();
}

inline void HistoryTriggerStatus::clearTTriggeredStates() {
    if (hasTTriggeredStates()) {
         clear_has_tTriggeredStates();
        if (_tTriggeredStates != NULL) {
            _tTriggeredStates->clear();
        }
     }
}

inline bool HistoryTriggerStatus::hasTTriggeredStates () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& HistoryTriggerStatus::getTTriggeredStates () const {
    if (_tTriggeredStates == NULL) {
        return getT_SPM_HistoryTriggerPointerList_DefaultInstance();
    }
    return *_tTriggeredStates;
}

inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& HistoryTriggerStatus::getTTriggeredStatesMutable () {
    set_has_tTriggeredStates();
    if (_tTriggeredStates == NULL) {
        _tTriggeredStates = new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger > ();
        CHECK_ALLOCATION( _tTriggeredStates );
    }
    return *_tTriggeredStates;
}

inline void HistoryTriggerStatus::setTTriggeredStates (const ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >& tTriggeredStates_) {
    set_has_tTriggeredStates();
    if (this->_tTriggeredStates == NULL) {
        this->_tTriggeredStates = new ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger > (tTriggeredStates_);
        CHECK_ALLOCATION( this->_tTriggeredStates );
    } else {
        *this->_tTriggeredStates = tTriggeredStates_;
    }
}

inline ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >* HistoryTriggerStatus::releaseTTriggeredStates() {
    clear_has_tTriggeredStates();
    ::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >* temp = _tTriggeredStates;
    this->_tTriggeredStates = NULL;
    return temp;
}

inline void HistoryTriggerStatus::replaceTTriggeredStates (::boost::ptr_vector< ::spm_core_fi_types::T_SPM_HistoryTrigger >* tTriggeredStates_) {
    set_has_tTriggeredStates();
    if (this->_tTriggeredStates != tTriggeredStates_) {
        if (this->_tTriggeredStates != NULL) {
            delete this->_tTriggeredStates;
        }
        this->_tTriggeredStates = tTriggeredStates_;
    }
}

inline void HistoryTriggerStatus::set_has_tTriggeredStates () {
    _has_bits_[0] |= 1u << 0;
}

inline void HistoryTriggerStatus::clear_has_tTriggeredStates () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InsertStateStatus::InsertStateStatus ()  :
    _InsertState (::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE__SPM_U32_CD_INSERT_INACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InsertStateStatus::InsertStateStatus (const InsertStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _InsertState (::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE__SPM_U32_CD_INSERT_INACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InsertStateStatus::InsertStateStatus (::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE InsertState_)  :
    _InsertState (InsertState_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE_IsValid(InsertState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", InsertState_, "T_SPM_e32_CD_INSERT_STATE", "InsertState", "InsertStateStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InsertStateStatus::~InsertStateStatus() {
}

inline InsertStateStatus& InsertStateStatus::operator = (const InsertStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInsertState()) {
            setInsertState(rhs.getInsertState());
        } else {
            clearInsertState();
        }
    }
    return *this;
}

inline bool InsertStateStatus::operator == (const InsertStateStatus& rhs) const {
    return (((!hasInsertState() && !rhs.hasInsertState()) || getInsertState() == rhs.getInsertState()));
}

inline bool InsertStateStatus::operator != (const InsertStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool InsertStateStatus::operator < (const InsertStateStatus& rhs) const {
    if (hasInsertState() || rhs.hasInsertState()) {
        if ((uint32)getInsertState() < (uint32)rhs.getInsertState()) return true;
        if ((uint32)getInsertState() > (uint32)rhs.getInsertState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InsertStateStatus::clone() {
    return new InsertStateStatus(*this);
}

inline bool InsertStateStatus::operator > (const InsertStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InsertStateStatus::clear() {
    clearInsertState();
}

inline void InsertStateStatus::clearInsertState() {
    if (hasInsertState()) {
         clear_has_InsertState();
        _InsertState = ::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE__SPM_U32_CD_INSERT_INACTIVE;
     }
}

inline bool InsertStateStatus::hasInsertState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE InsertStateStatus::getInsertState () const {
    return _InsertState;
}

inline void InsertStateStatus::setInsertState (::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE InsertState_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_CD_INSERT_STATE_IsValid(InsertState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", InsertState_, "T_SPM_e32_CD_INSERT_STATE", "InsertState", "InsertStateStatus");
    }
    #endif
    set_has_InsertState();
    this->_InsertState = InsertState_;
}

inline void InsertStateStatus::set_has_InsertState () {
    _has_bits_[0] |= 1u << 0;
}

inline void InsertStateStatus::clear_has_InsertState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MediaEjectStateStatus::MediaEjectStateStatus ()  :
    _MediaEjectState (::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE__SPM_U32_EJECT_RELEASED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MediaEjectStateStatus::MediaEjectStateStatus (const MediaEjectStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _MediaEjectState (::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE__SPM_U32_EJECT_RELEASED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MediaEjectStateStatus::MediaEjectStateStatus (::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE MediaEjectState_)  :
    _MediaEjectState (MediaEjectState_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE_IsValid(MediaEjectState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MediaEjectState_, "T_SPM_e32_MEDIA_EJECT_STATE", "MediaEjectState", "MediaEjectStateStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MediaEjectStateStatus::~MediaEjectStateStatus() {
}

inline MediaEjectStateStatus& MediaEjectStateStatus::operator = (const MediaEjectStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMediaEjectState()) {
            setMediaEjectState(rhs.getMediaEjectState());
        } else {
            clearMediaEjectState();
        }
    }
    return *this;
}

inline bool MediaEjectStateStatus::operator == (const MediaEjectStateStatus& rhs) const {
    return (((!hasMediaEjectState() && !rhs.hasMediaEjectState()) || getMediaEjectState() == rhs.getMediaEjectState()));
}

inline bool MediaEjectStateStatus::operator != (const MediaEjectStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool MediaEjectStateStatus::operator < (const MediaEjectStateStatus& rhs) const {
    if (hasMediaEjectState() || rhs.hasMediaEjectState()) {
        if ((uint32)getMediaEjectState() < (uint32)rhs.getMediaEjectState()) return true;
        if ((uint32)getMediaEjectState() > (uint32)rhs.getMediaEjectState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MediaEjectStateStatus::clone() {
    return new MediaEjectStateStatus(*this);
}

inline bool MediaEjectStateStatus::operator > (const MediaEjectStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MediaEjectStateStatus::clear() {
    clearMediaEjectState();
}

inline void MediaEjectStateStatus::clearMediaEjectState() {
    if (hasMediaEjectState()) {
         clear_has_MediaEjectState();
        _MediaEjectState = ::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE__SPM_U32_EJECT_RELEASED;
     }
}

inline bool MediaEjectStateStatus::hasMediaEjectState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE MediaEjectStateStatus::getMediaEjectState () const {
    return _MediaEjectState;
}

inline void MediaEjectStateStatus::setMediaEjectState (::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE MediaEjectState_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_MEDIA_EJECT_STATE_IsValid(MediaEjectState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", MediaEjectState_, "T_SPM_e32_MEDIA_EJECT_STATE", "MediaEjectState", "MediaEjectStateStatus");
    }
    #endif
    set_has_MediaEjectState();
    this->_MediaEjectState = MediaEjectState_;
}

inline void MediaEjectStateStatus::set_has_MediaEjectState () {
    _has_bits_[0] |= 1u << 0;
}

inline void MediaEjectStateStatus::clear_has_MediaEjectState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PhoneMuteStateStatus::PhoneMuteStateStatus ()  :
    _PhoneMuteState (::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE__SPM_U32_PHONEMUTE_INACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PhoneMuteStateStatus::PhoneMuteStateStatus (const PhoneMuteStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _PhoneMuteState (::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE__SPM_U32_PHONEMUTE_INACTIVE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PhoneMuteStateStatus::PhoneMuteStateStatus (::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE PhoneMuteState_)  :
    _PhoneMuteState (PhoneMuteState_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE_IsValid(PhoneMuteState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PhoneMuteState_, "T_SPM_e32_PHONE_MUTE_STATE", "PhoneMuteState", "PhoneMuteStateStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PhoneMuteStateStatus::~PhoneMuteStateStatus() {
}

inline PhoneMuteStateStatus& PhoneMuteStateStatus::operator = (const PhoneMuteStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPhoneMuteState()) {
            setPhoneMuteState(rhs.getPhoneMuteState());
        } else {
            clearPhoneMuteState();
        }
    }
    return *this;
}

inline bool PhoneMuteStateStatus::operator == (const PhoneMuteStateStatus& rhs) const {
    return (((!hasPhoneMuteState() && !rhs.hasPhoneMuteState()) || getPhoneMuteState() == rhs.getPhoneMuteState()));
}

inline bool PhoneMuteStateStatus::operator != (const PhoneMuteStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool PhoneMuteStateStatus::operator < (const PhoneMuteStateStatus& rhs) const {
    if (hasPhoneMuteState() || rhs.hasPhoneMuteState()) {
        if ((uint32)getPhoneMuteState() < (uint32)rhs.getPhoneMuteState()) return true;
        if ((uint32)getPhoneMuteState() > (uint32)rhs.getPhoneMuteState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PhoneMuteStateStatus::clone() {
    return new PhoneMuteStateStatus(*this);
}

inline bool PhoneMuteStateStatus::operator > (const PhoneMuteStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PhoneMuteStateStatus::clear() {
    clearPhoneMuteState();
}

inline void PhoneMuteStateStatus::clearPhoneMuteState() {
    if (hasPhoneMuteState()) {
         clear_has_PhoneMuteState();
        _PhoneMuteState = ::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE__SPM_U32_PHONEMUTE_INACTIVE;
     }
}

inline bool PhoneMuteStateStatus::hasPhoneMuteState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE PhoneMuteStateStatus::getPhoneMuteState () const {
    return _PhoneMuteState;
}

inline void PhoneMuteStateStatus::setPhoneMuteState (::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE PhoneMuteState_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_PHONE_MUTE_STATE_IsValid(PhoneMuteState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PhoneMuteState_, "T_SPM_e32_PHONE_MUTE_STATE", "PhoneMuteState", "PhoneMuteStateStatus");
    }
    #endif
    set_has_PhoneMuteState();
    this->_PhoneMuteState = PhoneMuteState_;
}

inline void PhoneMuteStateStatus::set_has_PhoneMuteState () {
    _has_bits_[0] |= 1u << 0;
}

inline void PhoneMuteStateStatus::clear_has_PhoneMuteState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  OnTipperStateStatus::OnTipperStateStatus ()  :
    _OnTipperState (::spm_core_fi_types::T_SPM_e32_KEY_STATE__SPM_U32_RELEASED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  OnTipperStateStatus::OnTipperStateStatus (const OnTipperStateStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _OnTipperState (::spm_core_fi_types::T_SPM_e32_KEY_STATE__SPM_U32_RELEASED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  OnTipperStateStatus::OnTipperStateStatus (::spm_core_fi_types::T_SPM_e32_KEY_STATE OnTipperState_)  :
    _OnTipperState (OnTipperState_)
{
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_KEY_STATE_IsValid(OnTipperState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OnTipperState_, "T_SPM_e32_KEY_STATE", "OnTipperState", "OnTipperStateStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  OnTipperStateStatus::~OnTipperStateStatus() {
}

inline OnTipperStateStatus& OnTipperStateStatus::operator = (const OnTipperStateStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasOnTipperState()) {
            setOnTipperState(rhs.getOnTipperState());
        } else {
            clearOnTipperState();
        }
    }
    return *this;
}

inline bool OnTipperStateStatus::operator == (const OnTipperStateStatus& rhs) const {
    return (((!hasOnTipperState() && !rhs.hasOnTipperState()) || getOnTipperState() == rhs.getOnTipperState()));
}

inline bool OnTipperStateStatus::operator != (const OnTipperStateStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool OnTipperStateStatus::operator < (const OnTipperStateStatus& rhs) const {
    if (hasOnTipperState() || rhs.hasOnTipperState()) {
        if ((uint32)getOnTipperState() < (uint32)rhs.getOnTipperState()) return true;
        if ((uint32)getOnTipperState() > (uint32)rhs.getOnTipperState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* OnTipperStateStatus::clone() {
    return new OnTipperStateStatus(*this);
}

inline bool OnTipperStateStatus::operator > (const OnTipperStateStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void OnTipperStateStatus::clear() {
    clearOnTipperState();
}

inline void OnTipperStateStatus::clearOnTipperState() {
    if (hasOnTipperState()) {
         clear_has_OnTipperState();
        _OnTipperState = ::spm_core_fi_types::T_SPM_e32_KEY_STATE__SPM_U32_RELEASED;
     }
}

inline bool OnTipperStateStatus::hasOnTipperState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::spm_core_fi_types::T_SPM_e32_KEY_STATE OnTipperStateStatus::getOnTipperState () const {
    return _OnTipperState;
}

inline void OnTipperStateStatus::setOnTipperState (::spm_core_fi_types::T_SPM_e32_KEY_STATE OnTipperState_) {
    #ifndef NDEBUG
    if (!(::spm_core_fi_types::T_SPM_e32_KEY_STATE_IsValid(OnTipperState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", OnTipperState_, "T_SPM_e32_KEY_STATE", "OnTipperState", "OnTipperStateStatus");
    }
    #endif
    set_has_OnTipperState();
    this->_OnTipperState = OnTipperState_;
}

inline void OnTipperStateStatus::set_has_OnTipperState () {
    _has_bits_[0] |= 1u << 0;
}

inline void OnTipperStateStatus::clear_has_OnTipperState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  IgnitionCyclesStatus::IgnitionCyclesStatus ()  :
    _IgnitionCycle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IgnitionCyclesStatus::IgnitionCyclesStatus (const IgnitionCyclesStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _IgnitionCycle (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
