/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "speaud_main_fiCca.h"
#include "speaud_main_fiJson.h"
#include "speaud_main_fiProxy.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace speaud_main_fi {

/*static*/ ::asf::core::Logger Speaud_main_fiProxy::_logger ("/speaud_main_fi/Speaud_main_fiProxy");


class Speaud_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Speaud_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Speaud_main_fiProxy> proxy = ::boost::static_pointer_cast<Speaud_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_InternMsg: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::speaud_main_fi::InternMsgStatus);
                                setActAndLogStatus(message, "InternMsg", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<InternMsgStatus> payload = ::boost::static_pointer_cast<InternMsgStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< InternMsgStatus >& refNullableStatus = proxy->_internMsg;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((InternMsgCallbackIF*) _callback)->onInternMsgStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::speaud_main_fi::InternMsgError);
                                setActAndLogError(message, "InternMsg", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((InternMsgCallbackIF*) _callback)->onInternMsgError(proxy, ::boost::static_pointer_cast<InternMsgError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Speaud_main_fiProxy> proxy = ::boost::static_pointer_cast<Speaud_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_InternMsg: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< InternMsgError > payload (new InternMsgError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "InternMsg", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((InternMsgCallbackIF*) _callback)->onInternMsgError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Speaud_main_fiProxyCallback::_logger (Speaud_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Speaud_main_fiProxy > Speaud_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Speaud_main_fiProxy >  proxyNew(new Speaud_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Speaud_main_fiProxy > Speaud_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Speaud_main_fiProxy >  proxyNew(new Speaud_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Speaud_main_fiProxy > Speaud_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Speaud_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Speaud_main_fiProxy >  proxyNew(new Speaud_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Speaud_main_fiProxy::Speaud_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Speaud_main_fiProxy::~Speaud_main_fiProxy()
{
    LOG_INFO ("Entering ~Speaud_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Speaud_main_fiProxy::sendInternMsgUpReg(InternMsgCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_InternMsg);
        ::boost::shared_ptr< InternMsgUpReg > payload (new InternMsgUpReg());
        CCA_MESSAGE(ccaMessage,header,InternMsgUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< InternMsgRelUpReg > payloadRelUpRegHeap (new InternMsgRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_InternMsg, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::speaud_main_fi::InternMsgRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_InternMsg, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "InternMsg", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "InternMsg", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasInternMsg()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_InternMsg, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< InternMsgStatus > payloadLoopback (new InternMsgStatus(getInternMsg()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,InternMsgStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_InternMsg);
        ::boost::shared_ptr< InternMsgError > payload (new InternMsgError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,InternMsgError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "InternMsg", &cb);
    }
}

bool Speaud_main_fiProxy::sendInternMsgRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_InternMsg,"InternMsg");
}

void Speaud_main_fiProxy::sendInternMsgRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_InternMsg);
}

const InternMsgStatus& Speaud_main_fiProxy::getInternMsg() const {
    return _internMsg.get();
}

bool Speaud_main_fiProxy::hasInternMsg() const {
    return _internMsg.hasValue();
}


void Speaud_main_fiProxy::clearAllProperties ()
{
    _internMsg = ::asf::core::nullable<InternMsgStatus>();
}

void Speaud_main_fiProxy::sendRelUpRegAll()
{
    sendInternMsgRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Speaud_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Speaud_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace speaud_main_fi
