#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SPEAUD_MAIN_FI_H
#define SPEAUD_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "speaud_main_fi_typesConst.h"
#include <cstring>

/**
 * CCA Functional Interface 'speaud_main_fi'
 *
 * Fullname: Dummy CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.0.0  $
 *
 * Author: xxx
 *
 * Date: $Date:  17.04.2015  $
 *
 * Department:
 *
 * Title: speaud_main_fi
 *
 * <b>Description of 'speaud_main_fi':</b>
 *
 * Interface for accessing RVC (Rear View Camera), AVM (Around View Monitor) and IPA (Intelligent Park Assistant) functionalities.
 */

namespace speaud_main_fi {

static const int SERVICE_ID = 623;

static const int FID_InternMsg = 1;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class InternMsgStatus;

// type definitions
/**
 * The upreg message of the property "InternMsg"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InternMsgUpReg;

/**
 * The relUpReg message of the property "InternMsg"
 */
typedef ::asf::cca::CcaTypes::DefaultMessage InternMsgRelUpReg;

/**
 * The error message of 'InternMsg'
 */
typedef ::asf::cca::CcaTypes::DefaultError InternMsgError;


/**
 * The status message of the property "InternMsg"
 */
class InternMsgStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InternMsgStatus ();

    /**
     * Copy constructor
     */
    inline  InternMsgStatus (const InternMsgStatus &rhs);

    /**
     * All fields constructor
     */
    inline  InternMsgStatus (::speaud_main_fi_types::T_e8_SPEAUD_TEST eTest_);

    /**
     * Destructor
     */
    inline virtual  ~InternMsgStatus();

    /**
     * Assignment operator
     */
    inline InternMsgStatus& operator = (const InternMsgStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InternMsgStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InternMsgStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InternMsgStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InternMsgStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eTest"

    static const int kETest = 0;

    /**
     * Clears the field "eTest".
     *
     * The field will be set to its default value. The hasETest()
     * method will return false.
     */
    inline void clearETest();

    /**
     * Checks whether the field "eTest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setETest()). Otherwise it will return false.
     */
    inline bool hasETest () const;

    /**
     * Returns the value of the member "eTest".
     *
     * If the meaning of "eTest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eTest"
     */
    inline ::speaud_main_fi_types::T_e8_SPEAUD_TEST getETest () const;

    /**
     * Sets the value of the member "eTest".
     *
     * If the meaning of "eTest" isn't clear, then there should be a description here.
     *
     * @param eTest The value which will be set
     */
    inline void setETest (::speaud_main_fi_types::T_e8_SPEAUD_TEST eTest_);

    static const InternMsgStatus &getDefaultInstance();

private:

    inline void set_has_eTest ();

    inline void clear_has_eTest ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::speaud_main_fi_types::T_e8_SPEAUD_TEST _eTest;

};

inline  InternMsgStatus::InternMsgStatus ()  :
    _eTest (::speaud_main_fi_types::T_e8_SPEAUD_TEST__TEST_0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InternMsgStatus::InternMsgStatus (const InternMsgStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _eTest (::speaud_main_fi_types::T_e8_SPEAUD_TEST__TEST_0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InternMsgStatus::InternMsgStatus (::speaud_main_fi_types::T_e8_SPEAUD_TEST eTest_)  :
    _eTest (eTest_)
{
    #ifndef NDEBUG
    if (!(::speaud_main_fi_types::T_e8_SPEAUD_TEST_IsValid(eTest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eTest_, "T_e8_SPEAUD_TEST", "eTest", "InternMsgStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InternMsgStatus::~InternMsgStatus() {
}

inline InternMsgStatus& InternMsgStatus::operator = (const InternMsgStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasETest()) {
            setETest(rhs.getETest());
        } else {
            clearETest();
        }
    }
    return *this;
}

inline bool InternMsgStatus::operator == (const InternMsgStatus& rhs) const {
    return (((!hasETest() && !rhs.hasETest()) || getETest() == rhs.getETest()));
}

inline bool InternMsgStatus::operator != (const InternMsgStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool InternMsgStatus::operator < (const InternMsgStatus& rhs) const {
    if (hasETest() || rhs.hasETest()) {
        if ((uint32)getETest() < (uint32)rhs.getETest()) return true;
        if ((uint32)getETest() > (uint32)rhs.getETest()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InternMsgStatus::clone() {
    return new InternMsgStatus(*this);
}

inline bool InternMsgStatus::operator > (const InternMsgStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InternMsgStatus::clear() {
    clearETest();
}

inline void InternMsgStatus::clearETest() {
    if (hasETest()) {
         clear_has_eTest();
        _eTest = ::speaud_main_fi_types::T_e8_SPEAUD_TEST__TEST_0;
     }
}

inline bool InternMsgStatus::hasETest () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::speaud_main_fi_types::T_e8_SPEAUD_TEST InternMsgStatus::getETest () const {
    return _eTest;
}

inline void InternMsgStatus::setETest (::speaud_main_fi_types::T_e8_SPEAUD_TEST eTest_) {
    #ifndef NDEBUG
    if (!(::speaud_main_fi_types::T_e8_SPEAUD_TEST_IsValid(eTest_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eTest_, "T_e8_SPEAUD_TEST", "eTest", "InternMsgStatus");
    }
    #endif
    set_has_eTest();
    this->_eTest = eTest_;
}

inline void InternMsgStatus::set_has_eTest () {
    _has_bits_[0] |= 1u << 0;
}

inline void InternMsgStatus::clear_has_eTest () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace speaud_main_fi

#endif // SPEAUD_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
