/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "smartphoneint_main_fi_types.h"
#include "smartphoneint_main_fi_typesCca.h"
#include "smartphoneint_main_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::smartphoneint_main_fi_types::T_ProjectionCapability& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnUSBPortType();
    out << (uint8) in.getEnDeviceType();
    out << (uint8) in.getEnCarplayProjection();
    out << (uint8) in.getEnAndroidProjection();
    out << (uint8) in.getEnMirrorlinkProjection();
    out << (uint8) in.getEnMySPINProjection();
    out << (uint8) in.getEnCarlifeProjection();
    out << (uint8) in.getEnOnCarProjection();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_ProjectionCapability& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    out.setEnUSBPortType((::smartphoneint_main_fi_types::T_e8_USBPortType)o0);
    uint8 o1;
    in >> o1;
    out.setEnDeviceType((::smartphoneint_main_fi_types::T_e8_DeviceType)o1);
    uint8 o2;
    in >> o2;
    out.setEnCarplayProjection((::smartphoneint_main_fi_types::T_e8_SupportInfo)o2);
    uint8 o3;
    in >> o3;
    out.setEnAndroidProjection((::smartphoneint_main_fi_types::T_e8_SupportInfo)o3);
    uint8 o4;
    in >> o4;
    out.setEnMirrorlinkProjection((::smartphoneint_main_fi_types::T_e8_SupportInfo)o4);
    uint8 o5;
    in >> o5;
    out.setEnMySPINProjection((::smartphoneint_main_fi_types::T_e8_SupportInfo)o5);
    uint8 o6;
    in >> o6;
    out.setEnCarlifeProjection((::smartphoneint_main_fi_types::T_e8_SupportInfo)o6);
    uint8 o7;
    in >> o7;
    out.setEnOnCarProjection((::smartphoneint_main_fi_types::T_e8_SupportInfo)o7);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DeviceSelectionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnDeviceSelectionState();
    out << (uint8) in.getEnDeviceSelectionErrorType();
    out << (uint8) in.getEnDeviceSelectionProgressState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DeviceSelectionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o8;
    in >> o8;
    out.setEnDeviceSelectionState((::smartphoneint_main_fi_types::T_e8_DeviceSelectionState)o8);
    uint8 o9;
    in >> o9;
    out.setEnDeviceSelectionErrorType((::smartphoneint_main_fi_types::T_e8_DeviceSelectionErrorType)o9);
    uint8 o10;
    in >> o10;
    out.setEnDeviceSelectionProgressState((::smartphoneint_main_fi_types::T_e8_DeviceSelectionProgressState)o10);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DeviceDetails& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32DeviceHandle();
    out << in.getSzDeviceName();
    out << (uint8) in.getEnDeviceCategory();
    out << in.getSzDeviceModelName();
    out << in.getSzDeviceManufacturerName();
    out << (uint8) in.getEnDeviceConnectionStatus();
    out << (uint8) in.getEnDeviceConnectionType();
    serializeCca(in.getRVersionInfo(), out, majorVersion);
    out << (uint8) in.getEnDeviceUsageEnabled();
    out << (uint8) in.getBSelectedDevice();
    out << (uint8) in.getBDAPSupport();
    serializeCca(in.getRProjectionCapability(), out, majorVersion);
    out << in.getSzBTAddress();
    serializeCca(in.getRDeviceSelectionInfo(), out, majorVersion);
    out << in.getSzSerialNumber();
    out << (uint8) in.getEnUserAuthorizationStatus();
    out << (uint8) in.getEnSessionTransportType();
    out << in.getU32VendorID();
    out << in.getU32ProductID();
    out << in.getSzSystemPath();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DeviceDetails& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o11;
    in >> o11;
    out.setU32DeviceHandle(o11);
    ::std::string o12;
    in >> o12;
    out.setSzDeviceName(o12);
    uint8 o13;
    in >> o13;
    out.setEnDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o13);
    ::std::string o14;
    in >> o14;
    out.setSzDeviceModelName(o14);
    ::std::string o15;
    in >> o15;
    out.setSzDeviceManufacturerName(o15);
    uint8 o16;
    in >> o16;
    out.setEnDeviceConnectionStatus((::smartphoneint_main_fi_types::T_e8_DeviceConnectionStatus)o16);
    uint8 o17;
    in >> o17;
    out.setEnDeviceConnectionType((::smartphoneint_main_fi_types::T_e8_DeviceConnectionType)o17);
    deserializeCca(in, out.getRVersionInfoMutable(), majorVersion);
    uint8 o18;
    in >> o18;
    out.setEnDeviceUsageEnabled((::smartphoneint_main_fi_types::T_e8_EnabledInfo)o18);
    bool o19;
    in >> o19;
    out.setBSelectedDevice(o19);
    bool o20;
    in >> o20;
    out.setBDAPSupport(o20);
    deserializeCca(in, out.getRProjectionCapabilityMutable(), majorVersion);
    ::std::string o21;
    in >> o21;
    out.setSzBTAddress(o21);
    deserializeCca(in, out.getRDeviceSelectionInfoMutable(), majorVersion);
    ::std::string o22;
    in >> o22;
    out.setSzSerialNumber(o22);
    uint8 o23;
    in >> o23;
    out.setEnUserAuthorizationStatus((::smartphoneint_main_fi_types::T_e8_UserAuthorizationStatus)o23);
    uint8 o24;
    in >> o24;
    out.setEnSessionTransportType((::smartphoneint_main_fi_types::T_e8_SessionTransportType)o24);
    uint32 o25;
    in >> o25;
    out.setU32VendorID(o25);
    uint32 o26;
    in >> o26;
    out.setU32ProductID(o26);
    ::std::string o27;
    in >> o27;
    out.setSzSystemPath(o27);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AppDetails& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32AppHandle();
    out << in.getSzAppName();
    out << (uint8) in.getEnAppStatus();
    out << in.getSzAppVariant();
    out << in.getSzAppProviderName();
    out << in.getSzAppProviderURL();
    out << in.getSzAppDescription();
    {
        uint32 o28 = static_cast<uint32>(in.getAppAllowedProfiles().size());
        out << o28;
        ::std::vector< ::std::string >::const_iterator o29;
        for (o29 = in.getAppAllowedProfiles().begin(); o29 != in.getAppAllowedProfiles().end(); ++o29) {
            out << (*o29);
        }
    }
    out << in.getSzAppCertificateURL();
    out << (uint32) in.getEnAppCategory();
    out << (uint16) in.getEnTrustLevel();
    out << (uint8) in.getE8AppCertificationInfo();
    serializeCca(in.getRAppDisplayInfo(), out, majorVersion);
    serializeCca(in.getRAppAudioInfo(), out, majorVersion);
    serializeCca(in.getRAppRemotingInfo(), out, majorVersion);
    out << in.getU16NumAppIcons();
    {
        uint32 o30 = static_cast<uint32>(in.getAppIconList().size());
        out << o30;
        ::std::vector< ::smartphoneint_main_fi_types::T_IconAttributes >::const_iterator o31;
        for (o31 = in.getAppIconList().begin(); o31 != in.getAppIconList().end(); ++o31) {
            serializeCca((*o31), out, majorVersion);
        }
    }
    out << (uint8) in.getE8AppCertificationEntity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AppDetails& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o32;
    in >> o32;
    out.setU32AppHandle(o32);
    ::std::string o33;
    in >> o33;
    out.setSzAppName(o33);
    uint8 o34;
    in >> o34;
    out.setEnAppStatus((::smartphoneint_main_fi_types::T_e8_AppStatus)o34);
    ::std::string o35;
    in >> o35;
    out.setSzAppVariant(o35);
    ::std::string o36;
    in >> o36;
    out.setSzAppProviderName(o36);
    ::std::string o37;
    in >> o37;
    out.setSzAppProviderURL(o37);
    ::std::string o38;
    in >> o38;
    out.setSzAppDescription(o38);
    {
        uint32 o39;
        in >> o39;
        out.getAppAllowedProfilesMutable().clear ();
        out.getAppAllowedProfilesMutable().reserve (o39);
        for (uint32 o40 = 0; o40 < o39; o40++) {
            ::std::string o41;
            in >> o41;
            out.getAppAllowedProfilesMutable().push_back (o41);

        }
    }
    ::std::string o42;
    in >> o42;
    out.setSzAppCertificateURL(o42);
    uint32 o43;
    in >> o43;
    out.setEnAppCategory((::smartphoneint_main_fi_types::T_e32_AppCategory)o43);
    uint16 o44;
    in >> o44;
    out.setEnTrustLevel((::smartphoneint_main_fi_types::T_e16_TrustLevel)o44);
    uint8 o45;
    in >> o45;
    out.setE8AppCertificationInfo((::smartphoneint_main_fi_types::T_e8_AppCertificationInfo)o45);
    deserializeCca(in, out.getRAppDisplayInfoMutable(), majorVersion);
    deserializeCca(in, out.getRAppAudioInfoMutable(), majorVersion);
    deserializeCca(in, out.getRAppRemotingInfoMutable(), majorVersion);
    uint16 o46;
    in >> o46;
    out.setU16NumAppIcons(o46);
    {
        uint32 o47;
        in >> o47;
        out.getAppIconListMutable().clear ();
        out.getAppIconListMutable().reserve (o47);
        for (uint32 o48 = 0; o48 < o47; o48++) {
            ::smartphoneint_main_fi_types::T_IconAttributes o49;
            deserializeCca(in, o49, majorVersion);
            out.getAppIconListMutable().push_back (o49);
        }
    }
    uint8 o50;
    in >> o50;
    out.setE8AppCertificationEntity((::smartphoneint_main_fi_types::T_e8_AppCertificationEntity)o50);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AppRemotingInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzRemotingProtocolID();
    out << in.getSzRemotingFormat();
    out << in.getSzRemotingDirection();
    out << in.getU32RemotingAudioIPL();
    out << in.getU32RemotingAudioMPL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AppRemotingInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o51;
    in >> o51;
    out.setSzRemotingProtocolID(o51);
    ::std::string o52;
    in >> o52;
    out.setSzRemotingFormat(o52);
    ::std::string o53;
    in >> o53;
    out.setSzRemotingDirection(o53);
    uint32 o54;
    in >> o54;
    out.setU32RemotingAudioIPL(o54);
    uint32 o55;
    in >> o55;
    out.setU32RemotingAudioMPL(o55);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AppDisplayInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint32) in.getEnAppDisplayCategory();
    out << (uint16) in.getEnTrustLevel();
    out << in.getU32AppDisplayRules();
    out << in.getSzAppDisplayOrientation();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AppDisplayInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o56;
    in >> o56;
    out.setEnAppDisplayCategory((::smartphoneint_main_fi_types::T_e32_AppDisplayCategory)o56);
    uint16 o57;
    in >> o57;
    out.setEnTrustLevel((::smartphoneint_main_fi_types::T_e16_TrustLevel)o57);
    uint32 o58;
    in >> o58;
    out.setU32AppDisplayRules(o58);
    ::std::string o59;
    in >> o59;
    out.setSzAppDisplayOrientation(o59);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AppAudioInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzAppAudioType();
    out << (uint32) in.getEnAppAudioCategory();
    out << (uint16) in.getEnTrustLevel();
    out << in.getU32AppAudioRules();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AppAudioInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o60;
    in >> o60;
    out.setSzAppAudioType(o60);
    uint32 o61;
    in >> o61;
    out.setEnAppAudioCategory((::smartphoneint_main_fi_types::T_e32_AppAudioCategory)o61);
    uint16 o62;
    in >> o62;
    out.setEnTrustLevel((::smartphoneint_main_fi_types::T_e16_TrustLevel)o62);
    uint32 o63;
    in >> o63;
    out.setU32AppAudioRules(o63);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_VersionInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzMinorVersion();
    out << in.getSzMajorVersion();
    out << in.getSzPatchVersion();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_VersionInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o64;
    in >> o64;
    out.setSzMinorVersion(o64);
    ::std::string o65;
    in >> o65;
    out.setSzMajorVersion(o65);
    ::std::string o66;
    in >> o66;
    out.setSzPatchVersion(o66);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_EAPAppInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzAppName();
    out << in.getSzProtocol();
    out << in.getSzBundleID();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_EAPAppInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o67;
    in >> o67;
    out.setSzAppName(o67);
    ::std::string o68;
    in >> o68;
    out.setSzProtocol(o68);
    ::std::string o69;
    in >> o69;
    out.setSzBundleID(o69);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_IconAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32IconWidth();
    out << in.getU32IconHeight();
    out << in.getU32IconDepth();
    out << (uint8) in.getEnIconMimeType();
    out << in.getSzIconURL();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_IconAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o70;
    in >> o70;
    out.setU32IconWidth(o70);
    uint32 o71;
    in >> o71;
    out.setU32IconHeight(o71);
    uint32 o72;
    in >> o72;
    out.setU32IconDepth(o72);
    uint8 o73;
    in >> o73;
    out.setEnIconMimeType((::smartphoneint_main_fi_types::T_e8_IconMimeType)o73);
    ::std::string o74;
    in >> o74;
    out.setSzIconURL(o74);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_TouchData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16TouchDescriptors();
    {
        uint32 o75 = static_cast<uint32>(in.getTouchInfoList().size());
        out << o75;
        ::std::vector< ::smartphoneint_main_fi_types::T_TouchInfo >::const_iterator o76;
        for (o76 = in.getTouchInfoList().begin(); o76 != in.getTouchInfoList().end(); ++o76) {
            {
                uint32 o77 = static_cast<uint32>((*o76).size());
                out << o77;
                ::std::vector< ::smartphoneint_main_fi_types::T_TouchCoordinates >::const_iterator o78;
                for (o78 = (*o76).begin(); o78 != (*o76).end(); ++o78) {
                    serializeCca((*o78), out, majorVersion);
                }
            }
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_TouchData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o79;
    in >> o79;
    out.setU16TouchDescriptors(o79);
    {
        uint32 o80;
        in >> o80;
        out.getTouchInfoListMutable().clear ();
        out.getTouchInfoListMutable().reserve (o80);
        for (uint32 o81 = 0; o81 < o80; o81++) {
            ::smartphoneint_main_fi_types::T_TouchInfo o82;
            {
                uint32 o83;
                in >> o83;
                o82.clear ();
                o82.reserve (o83);
                for (uint32 o84 = 0; o84 < o83; o84++) {
                    ::smartphoneint_main_fi_types::T_TouchCoordinates o85;
                    deserializeCca(in, o85, majorVersion);
                    o82.push_back (o85);
                }
            }
            out.getTouchInfoListMutable().push_back (o82);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi_types::T_TouchCoordinates& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnTouchMode();
    out << in.getU16XCoordinate();
    out << in.getU16YCoordinate();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_TouchCoordinates& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o86;
    in >> o86;
    out.setEnTouchMode((::smartphoneint_main_fi_types::T_e8_TouchMode)o86);
    uint16 o87;
    in >> o87;
    out.setU16XCoordinate(o87);
    uint16 o88;
    in >> o88;
    out.setU16YCoordinate(o88);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_VideoAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnOrientationMode();
    serializeCca(in.getRScreenAttributes(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_VideoAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o89;
    in >> o89;
    out.setEnOrientationMode((::smartphoneint_main_fi_types::T_e8_OrientationMode)o89);
    deserializeCca(in, out.getRScreenAttributesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_NotificationEnable& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32AppHandle();
    out << (uint8) in.getEnEnabledInfo();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_NotificationEnable& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o90;
    in >> o90;
    out.setU32AppHandle(o90);
    uint8 o91;
    in >> o91;
    out.setEnEnabledInfo((::smartphoneint_main_fi_types::T_e8_EnabledInfo)o91);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_NotificationData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16NotificationID();
    out << in.getSzNotificationTitle();
    out << in.getSzNotificationBody();
    out << in.getU16NotificationIconCount();
    {
        uint32 o92 = static_cast<uint32>(in.getNotificationIconList().size());
        out << o92;
        ::std::vector< ::smartphoneint_main_fi_types::T_IconAttributes >::const_iterator o93;
        for (o93 = in.getNotificationIconList().begin(); o93 != in.getNotificationIconList().end(); ++o93) {
            serializeCca((*o93), out, majorVersion);
        }
    }
    out << in.getU16NotificationAppID();
    {
        uint32 o94 = static_cast<uint32>(in.getNotificationActionList().size());
        out << o94;
        ::std::vector< ::smartphoneint_main_fi_types::T_NotificationAction >::const_iterator o95;
        for (o95 = in.getNotificationActionList().begin(); o95 != in.getNotificationActionList().end(); ++o95) {
            serializeCca((*o95), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_NotificationData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o96;
    in >> o96;
    out.setU16NotificationID(o96);
    ::std::string o97;
    in >> o97;
    out.setSzNotificationTitle(o97);
    ::std::string o98;
    in >> o98;
    out.setSzNotificationBody(o98);
    uint16 o99;
    in >> o99;
    out.setU16NotificationIconCount(o99);
    {
        uint32 o100;
        in >> o100;
        out.getNotificationIconListMutable().clear ();
        out.getNotificationIconListMutable().reserve (o100);
        for (uint32 o101 = 0; o101 < o100; o101++) {
            ::smartphoneint_main_fi_types::T_IconAttributes o102;
            deserializeCca(in, o102, majorVersion);
            out.getNotificationIconListMutable().push_back (o102);
        }
    }
    uint16 o103;
    in >> o103;
    out.setU16NotificationAppID(o103);
    {
        uint32 o104;
        in >> o104;
        out.getNotificationActionListMutable().clear ();
        out.getNotificationActionListMutable().reserve (o104);
        for (uint32 o105 = 0; o105 < o104; o105++) {
            ::smartphoneint_main_fi_types::T_NotificationAction o106;
            deserializeCca(in, o106, majorVersion);
            out.getNotificationActionListMutable().push_back (o106);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi_types::T_NotificationAction& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16NotificationActionID();
    out << in.getSzNotificationActionName();
    out << in.getU16NotificationActionIconCount();
    {
        uint32 o107 = static_cast<uint32>(in.getNotificationActionIconList().size());
        out << o107;
        ::std::vector< ::smartphoneint_main_fi_types::T_IconAttributes >::const_iterator o108;
        for (o108 = in.getNotificationActionIconList().begin(); o108 != in.getNotificationActionIconList().end(); ++o108) {
            serializeCca((*o108), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_NotificationAction& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o109;
    in >> o109;
    out.setU16NotificationActionID(o109);
    ::std::string o110;
    in >> o110;
    out.setSzNotificationActionName(o110);
    uint16 o111;
    in >> o111;
    out.setU16NotificationActionIconCount(o111);
    {
        uint32 o112;
        in >> o112;
        out.getNotificationActionIconListMutable().clear ();
        out.getNotificationActionIconListMutable().reserve (o112);
        for (uint32 o113 = 0; o113 < o112; o113++) {
            ::smartphoneint_main_fi_types::T_IconAttributes o114;
            deserializeCca(in, o114, majorVersion);
            out.getNotificationActionIconListMutable().push_back (o114);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi_types::T_ScreenAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16ScreenHeight();
    out << in.getU16ScreenWidth();
    out << (uint8) in.getEnScreenAspectRatio();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_ScreenAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o115;
    in >> o115;
    out.setU16ScreenHeight(o115);
    uint16 o116;
    in >> o116;
    out.setU16ScreenWidth(o116);
    uint8 o117;
    in >> o117;
    out.setEnScreenAspectRatio((::smartphoneint_main_fi_types::T_e8_ScreenAspectRatio)o117);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_ClientCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRKeyCapabilities(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_ClientCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRKeyCapabilitiesMutable(), majorVersion);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_XDeviceKeys& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSzName();
    out << (uint8) in.getBMandatory();
    out << (uint32) in.getE32SymbolValue();
    {
        uint32 o118 = static_cast<uint32>(in.getIconList().size());
        out << o118;
        ::std::vector< ::smartphoneint_main_fi_types::T_IconAttributes >::const_iterator o119;
        for (o119 = in.getIconList().begin(); o119 != in.getIconList().end(); ++o119) {
            serializeCca((*o119), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_XDeviceKeys& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o120;
    in >> o120;
    out.setSzName(o120);
    bool o121;
    in >> o121;
    out.setBMandatory(o121);
    uint32 o122;
    in >> o122;
    out.setE32SymbolValue((::smartphoneint_main_fi_types::T_e32_KeyCode)o122);
    {
        uint32 o123;
        in >> o123;
        out.getIconListMutable().clear ();
        out.getIconListMutable().reserve (o123);
        for (uint32 o124 = 0; o124 < o123; o124++) {
            ::smartphoneint_main_fi_types::T_IconAttributes o125;
            deserializeCca(in, o125, majorVersion);
            out.getIconListMutable().push_back (o125);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi_types::T_KeyCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32KnobKeySupport();
    out << in.getU32DeviceKeySupport();
    out << in.getU32MultimediaKeySupport();
    out << in.getU32MiscKeySupport();
    out << in.getU32PointerTouchSupport();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_KeyCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o126;
    in >> o126;
    out.setU32KnobKeySupport(o126);
    uint32 o127;
    in >> o127;
    out.setU32DeviceKeySupport(o127);
    uint32 o128;
    in >> o128;
    out.setU32MultimediaKeySupport(o128);
    uint32 o129;
    in >> o129;
    out.setU32MiscKeySupport(o129);
    uint32 o130;
    in >> o130;
    out.setU32PointerTouchSupport(o130);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AudioCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16BTHFPSupport();
    out << in.getU16BTA2DPSupport();
    out << in.getU16RTPInSupport();
    out << in.getU16RTPOutSupport();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AudioCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o131;
    in >> o131;
    out.setU16BTHFPSupport(o131);
    uint16 o132;
    in >> o132;
    out.setU16BTA2DPSupport(o132);
    uint16 o133;
    in >> o133;
    out.setU16RTPInSupport(o133);
    uint16 o134;
    in >> o134;
    out.setU16RTPOutSupport(o134);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DisplayCapabilities& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16FrameBufferConfiguration();
    out << in.getU16PixelFormat();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DisplayCapabilities& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o135;
    in >> o135;
    out.setU16FrameBufferConfiguration(o135);
    uint16 o136;
    in >> o136;
    out.setU16PixelFormat(o136);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_ApplicationMediaMetaData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getAppName();
    out << in.getTitle();
    out << in.getArtist();
    out << in.getAlbum();
    out << in.getAlbumArtist();
    out << in.getGenre();
    out << in.getComposer();
    out << in.getTrackNumber();
    out << in.getAlbumTrackCount();
    out << in.getAlbumDiscNumber();
    out << in.getAlbumDiscCount();
    out << in.getChapterCount();
    out << in.getU32QueueIndex();
    out << in.getU32QueueCount();
    out << in.getImageMIMEType();
    out << in.getImageSize();
    out << in.getImageUrl();
    {
        uint32 o137 = static_cast<uint32>(in.getOImageData().size());
        out << o137;
        ::std::vector< uint8 >::const_iterator o138;
        for (o138 = in.getOImageData().begin(); o138 != in.getOImageData().end(); ++o138) {
            out << (*o138);
        }
    }
    out << (uint8) in.getPlayBackState();
    out << (uint8) in.getShuffleState();
    out << (uint8) in.getRepeatState();
    out << (uint8) in.getMediaType();
    out << (uint8) in.getITunesRadioAd();
    out << in.getITunesRadioStationName();
    out << in.getMediaRating();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_ApplicationMediaMetaData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o139;
    in >> o139;
    out.setAppName(o139);
    ::std::string o140;
    in >> o140;
    out.setTitle(o140);
    ::std::string o141;
    in >> o141;
    out.setArtist(o141);
    ::std::string o142;
    in >> o142;
    out.setAlbum(o142);
    ::std::string o143;
    in >> o143;
    out.setAlbumArtist(o143);
    ::std::string o144;
    in >> o144;
    out.setGenre(o144);
    ::std::string o145;
    in >> o145;
    out.setComposer(o145);
    uint32 o146;
    in >> o146;
    out.setTrackNumber(o146);
    uint32 o147;
    in >> o147;
    out.setAlbumTrackCount(o147);
    uint32 o148;
    in >> o148;
    out.setAlbumDiscNumber(o148);
    uint32 o149;
    in >> o149;
    out.setAlbumDiscCount(o149);
    uint32 o150;
    in >> o150;
    out.setChapterCount(o150);
    uint32 o151;
    in >> o151;
    out.setU32QueueIndex(o151);
    uint32 o152;
    in >> o152;
    out.setU32QueueCount(o152);
    ::std::string o153;
    in >> o153;
    out.setImageMIMEType(o153);
    uint32 o154;
    in >> o154;
    out.setImageSize(o154);
    ::std::string o155;
    in >> o155;
    out.setImageUrl(o155);
    {
        uint32 o156;
        in >> o156;
        out.getOImageDataMutable().clear ();
        out.getOImageDataMutable().reserve (o156);
        for (uint32 o157 = 0; o157 < o156; o157++) {
            uint8 o158;
            in >> o158;
            out.getOImageDataMutable().push_back(o158);
        }
    }
    uint8 o159;
    in >> o159;
    out.setPlayBackState((::smartphoneint_main_fi_types::T_e8_PlayBackState)o159);
    uint8 o160;
    in >> o160;
    out.setShuffleState((::smartphoneint_main_fi_types::T_e8_PlayBackShuffleState)o160);
    uint8 o161;
    in >> o161;
    out.setRepeatState((::smartphoneint_main_fi_types::T_e8_PlayBackRepeatState)o161);
    uint8 o162;
    in >> o162;
    out.setMediaType((::smartphoneint_main_fi_types::T_e8_PlayBackMediaType)o162);
    bool o163;
    in >> o163;
    out.setITunesRadioAd(o163);
    ::std::string o164;
    in >> o164;
    out.setITunesRadioStationName(o164);
    uint8 o165;
    in >> o165;
    out.setMediaRating(o165);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_ApplicationPhoneCallMetadata& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getPhoneNumber();
    out << in.getDisplayName();
    out << (uint8) in.getCallState();
    out << (uint8) in.getCallDirection();
    out << in.getCallDuration();
    out << in.getCallerLabel();
    out << (uint8) in.getConferencedCall();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_ApplicationPhoneCallMetadata& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o166;
    in >> o166;
    out.setPhoneNumber(o166);
    ::std::string o167;
    in >> o167;
    out.setDisplayName(o167);
    uint8 o168;
    in >> o168;
    out.setCallState((::smartphoneint_main_fi_types::T_e8_PhoneCallState)o168);
    uint8 o169;
    in >> o169;
    out.setCallDirection((::smartphoneint_main_fi_types::T_e8_PhoneCallDirection)o169);
    uint32 o170;
    in >> o170;
    out.setCallDuration(o170);
    ::std::string o171;
    in >> o171;
    out.setCallerLabel(o171);
    bool o172;
    in >> o172;
    out.setConferencedCall(o172);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AccessoryDisplayContext& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getDisplayContext();
    out << (uint8) in.getDisplayFlag();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AccessoryDisplayContext& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o173;
    in >> o173;
    out.setDisplayContext((::smartphoneint_main_fi_types::T_e8_DisplayContext)o173);
    bool o174;
    in >> o174;
    out.setDisplayFlag(o174);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DisplayConstraint& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getTransferType();
    out << (uint8) in.getTransferPriority();
    out << (uint8) in.getTakeConstraint();
    out << (uint8) in.getBorrowConstraint();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DisplayConstraint& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o175;
    in >> o175;
    out.setTransferType((::smartphoneint_main_fi_types::T_e8_ResourceTransferType)o175);
    uint8 o176;
    in >> o176;
    out.setTransferPriority((::smartphoneint_main_fi_types::T_e8_ResourceTransferPriority)o176);
    uint8 o177;
    in >> o177;
    out.setTakeConstraint((::smartphoneint_main_fi_types::T_e8_ResourceTransferConstraint)o177);
    uint8 o178;
    in >> o178;
    out.setBorrowConstraint((::smartphoneint_main_fi_types::T_e8_ResourceTransferConstraint)o178);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DisplayLayerAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEnDeviceCategory();
    out << in.getU16TouchLayerID();
    out << in.getU16TouchSurfaceID();
    out << in.getU16VideoLayerID();
    out << in.getU16VideoSurfaceID();
    out << in.getU16LayerWidth();
    out << in.getU16LayerHeight();
    out << in.getU16LayerWidthInMM();
    out << in.getU16LayerHeightInMM();
    out << in.getSzPixelAspectRatio();
    out << in.getU16DPI();
    out << (uint8) in.getEnDisplayTouchType();
    out << in.getU16PriorityIndex();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DisplayLayerAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o179;
    in >> o179;
    out.setEnDeviceCategory((::smartphoneint_main_fi_types::T_e8_DeviceCategory)o179);
    uint16 o180;
    in >> o180;
    out.setU16TouchLayerID(o180);
    uint16 o181;
    in >> o181;
    out.setU16TouchSurfaceID(o181);
    uint16 o182;
    in >> o182;
    out.setU16VideoLayerID(o182);
    uint16 o183;
    in >> o183;
    out.setU16VideoSurfaceID(o183);
    uint16 o184;
    in >> o184;
    out.setU16LayerWidth(o184);
    uint16 o185;
    in >> o185;
    out.setU16LayerHeight(o185);
    uint16 o186;
    in >> o186;
    out.setU16LayerWidthInMM(o186);
    uint16 o187;
    in >> o187;
    out.setU16LayerHeightInMM(o187);
    ::std::string o188;
    in >> o188;
    out.setSzPixelAspectRatio(o188);
    uint16 o189;
    in >> o189;
    out.setU16DPI(o189);
    uint8 o190;
    in >> o190;
    out.setEnDisplayTouchType((::smartphoneint_main_fi_types::T_e8_DisplayTouchType)o190);
    uint16 o191;
    in >> o191;
    out.setU16PriorityIndex(o191);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DisplayAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16ScreenHeight();
    out << in.getU16ScreenWidth();
    out << in.getU16ScreenHeightMm();
    out << in.getU16ScreenWidthMm();
    out << (uint8) in.getEnDisplayType();
    {
        uint32 o192 = static_cast<uint32>(in.getDisplayLayerAttributes().size());
        out << o192;
        ::std::vector< ::smartphoneint_main_fi_types::T_DisplayLayerAttributes >::const_iterator o193;
        for (o193 = in.getDisplayLayerAttributes().begin(); o193 != in.getDisplayLayerAttributes().end(); ++o193) {
            serializeCca((*o193), out, majorVersion);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DisplayAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o194;
    in >> o194;
    out.setU16ScreenHeight(o194);
    uint16 o195;
    in >> o195;
    out.setU16ScreenWidth(o195);
    uint16 o196;
    in >> o196;
    out.setU16ScreenHeightMm(o196);
    uint16 o197;
    in >> o197;
    out.setU16ScreenWidthMm(o197);
    uint8 o198;
    in >> o198;
    out.setEnDisplayType((::smartphoneint_main_fi_types::T_e8_DisplayType)o198);
    {
        uint32 o199;
        in >> o199;
        out.getDisplayLayerAttributesMutable().clear ();
        out.getDisplayLayerAttributesMutable().reserve (o199);
        for (uint32 o200 = 0; o200 < o199; o200++) {
            ::smartphoneint_main_fi_types::T_DisplayLayerAttributes o201;
            deserializeCca(in, o201, majorVersion);
            out.getDisplayLayerAttributesMutable().push_back (o201);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AccessoryAudioContext& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getAudioContext();
    out << (uint8) in.getAudioFlag();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AccessoryAudioContext& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o202;
    in >> o202;
    out.setAudioContext((::smartphoneint_main_fi_types::T_e8_AudioContext)o202);
    bool o203;
    in >> o203;
    out.setAudioFlag(o203);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DeviceAuthInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDeviceHandle();
    out << (uint8) in.getDeviceType();
    out << (uint8) in.getUserAuthorizationStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DeviceAuthInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o204;
    in >> o204;
    out.setDeviceHandle(o204);
    uint8 o205;
    in >> o205;
    out.setDeviceType((::smartphoneint_main_fi_types::T_e8_DeviceType)o205);
    uint8 o206;
    in >> o206;
    out.setUserAuthorizationStatus((::smartphoneint_main_fi_types::T_e8_UserAuthorizationStatus)o206);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_FeatureRestriction& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getFeatureLockout();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_FeatureRestriction& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o207;
    in >> o207;
    out.setFeatureLockout(o207);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_WiFiAPCredentials& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSSID();
    out << in.getPassPhrase();
    out << in.getChannelNo();
    out << (uint8) in.getSecurityType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_WiFiAPCredentials& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o208;
    in >> o208;
    out.setSSID(o208);
    ::std::string o209;
    in >> o209;
    out.setPassPhrase(o209);
    uint16 o210;
    in >> o210;
    out.setChannelNo(o210);
    uint8 o211;
    in >> o211;
    out.setSecurityType((::smartphoneint_main_fi_types::T_e8_WiFiSecurityType)o211);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_OEMICONDetails& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getOEMIconName();
    out << in.getOEMIconpath();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_OEMICONDetails& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o212;
    in >> o212;
    out.setOEMIconName(o212);
    ::std::string o213;
    in >> o213;
    out.setOEMIconpath(o213);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_CarPlayRouteGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBRouteGuidanceDisplayComponentIDsAvailable();
    {
        uint32 o214 = static_cast<uint32>(in.getE8RouteGuidanceDisplayComponentIDs().size());
        out << o214;
        ::std::vector< ::smartphoneint_main_fi_types::T_e8_ComponentID >::const_iterator o215;
        for (o215 = in.getE8RouteGuidanceDisplayComponentIDs().begin(); o215 != in.getE8RouteGuidanceDisplayComponentIDs().end(); ++o215) {
            out << (uint8) (*o215);
        }
    }
    out << (uint8) in.getBRouteGuidanceStateAvailable();
    out << (uint8) in.getE8RouteGuidanceState();
    out << (uint8) in.getBManeuverStateAvailable();
    out << (uint8) in.getE8ManeuverState();
    out << (uint8) in.getBCurrentRoadNameAvailable();
    out << in.getSzCurrentRoadName();
    out << (uint8) in.getBDestinationNameAvailable();
    out << in.getSzDestinationName();
    out << (uint8) in.getBEstimatedTimeOfArrivalAvailable();
    out << in.getU64EstimatedTimeOfArrival();
    out << (uint8) in.getBTimeRemainingToDestinationAvailable();
    out << in.getU64TimeRemainingToDestination();
    out << (uint8) in.getBDistanceRemainingAvailable();
    out << in.getU32DistanceRemaining();
    out << (uint8) in.getBDistanceRemainingDisplayStrAvailable();
    out << in.getSzDistanceRemainingDisplayStr();
    out << (uint8) in.getBDistanceRemainingDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceRemainingDisplayUnits();
    out << (uint8) in.getBDistanceToNextManeuverAvailable();
    out << in.getU32DistanceToNextManeuver();
    out << (uint8) in.getBDistanceToNextManeuverDisplayStrAvailable();
    out << in.getSzDistanceToNextManeuverDisplayStr();
    out << (uint8) in.getBDistanceToNextManeuverDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceToNextManeuverDisplayUnits();
    out << (uint8) in.getBRouteGuidanceManeuverCurrentListAvailable();
    {
        uint32 o216 = static_cast<uint32>(in.getU16RouteGuidanceManeuverCurrentList().size());
        out << o216;
        ::std::vector< uint16 >::const_iterator o217;
        for (o217 = in.getU16RouteGuidanceManeuverCurrentList().begin(); o217 != in.getU16RouteGuidanceManeuverCurrentList().end(); ++o217) {
            out << (*o217);
        }
    }
    out << (uint8) in.getBRouteGuidanceManeuverCountAvailable();
    out << in.getU16RouteGuidanceManeuverCount();
    out << (uint8) in.getBRouteGuidanceVisibleInAppAvailable();
    out << (uint8) in.getBIsRouteGuidanceVisibleInApp();
    out << (uint8) in.getBSourceNameAvailable();
    out << in.getSourceName();
    out << (uint8) in.getBSourceSupportsRouteGuidanceAvailable();
    out << (uint8) in.getSourceSupportsRouteGuidance();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_CarPlayRouteGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o218;
    in >> o218;
    out.setBRouteGuidanceDisplayComponentIDsAvailable(o218);
    {
        uint32 o219;
        in >> o219;
        out.getE8RouteGuidanceDisplayComponentIDsMutable().clear ();
        out.getE8RouteGuidanceDisplayComponentIDsMutable().reserve (o219);
        for (uint32 o220 = 0; o220 < o219; o220++) {
            uint8 o221;
            in >> o221;
            out.getE8RouteGuidanceDisplayComponentIDsMutable().push_back((::smartphoneint_main_fi_types::T_e8_ComponentID) o221);
        }
    }
    bool o222;
    in >> o222;
    out.setBRouteGuidanceStateAvailable(o222);
    uint8 o223;
    in >> o223;
    out.setE8RouteGuidanceState((::smartphoneint_main_fi_types::T_e8_DiPoRouteGuidanceState)o223);
    bool o224;
    in >> o224;
    out.setBManeuverStateAvailable(o224);
    uint8 o225;
    in >> o225;
    out.setE8ManeuverState((::smartphoneint_main_fi_types::T_e8_DiPoManeuverState)o225);
    bool o226;
    in >> o226;
    out.setBCurrentRoadNameAvailable(o226);
    ::std::string o227;
    in >> o227;
    out.setSzCurrentRoadName(o227);
    bool o228;
    in >> o228;
    out.setBDestinationNameAvailable(o228);
    ::std::string o229;
    in >> o229;
    out.setSzDestinationName(o229);
    bool o230;
    in >> o230;
    out.setBEstimatedTimeOfArrivalAvailable(o230);
    uint64 o231;
    in >> o231;
    out.setU64EstimatedTimeOfArrival(o231);
    bool o232;
    in >> o232;
    out.setBTimeRemainingToDestinationAvailable(o232);
    uint64 o233;
    in >> o233;
    out.setU64TimeRemainingToDestination(o233);
    bool o234;
    in >> o234;
    out.setBDistanceRemainingAvailable(o234);
    uint32 o235;
    in >> o235;
    out.setU32DistanceRemaining(o235);
    bool o236;
    in >> o236;
    out.setBDistanceRemainingDisplayStrAvailable(o236);
    ::std::string o237;
    in >> o237;
    out.setSzDistanceRemainingDisplayStr(o237);
    bool o238;
    in >> o238;
    out.setBDistanceRemainingDisplayUnitsAvailable(o238);
    uint8 o239;
    in >> o239;
    out.setE8DistanceRemainingDisplayUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o239);
    bool o240;
    in >> o240;
    out.setBDistanceToNextManeuverAvailable(o240);
    uint32 o241;
    in >> o241;
    out.setU32DistanceToNextManeuver(o241);
    bool o242;
    in >> o242;
    out.setBDistanceToNextManeuverDisplayStrAvailable(o242);
    ::std::string o243;
    in >> o243;
    out.setSzDistanceToNextManeuverDisplayStr(o243);
    bool o244;
    in >> o244;
    out.setBDistanceToNextManeuverDisplayUnitsAvailable(o244);
    uint8 o245;
    in >> o245;
    out.setE8DistanceToNextManeuverDisplayUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o245);
    bool o246;
    in >> o246;
    out.setBRouteGuidanceManeuverCurrentListAvailable(o246);
    {
        uint32 o247;
        in >> o247;
        out.getU16RouteGuidanceManeuverCurrentListMutable().clear ();
        out.getU16RouteGuidanceManeuverCurrentListMutable().reserve (o247);
        for (uint32 o248 = 0; o248 < o247; o248++) {
            uint16 o249;
            in >> o249;
            out.getU16RouteGuidanceManeuverCurrentListMutable().push_back(o249);
        }
    }
    bool o250;
    in >> o250;
    out.setBRouteGuidanceManeuverCountAvailable(o250);
    uint16 o251;
    in >> o251;
    out.setU16RouteGuidanceManeuverCount(o251);
    bool o252;
    in >> o252;
    out.setBRouteGuidanceVisibleInAppAvailable(o252);
    bool o253;
    in >> o253;
    out.setBIsRouteGuidanceVisibleInApp(o253);
    bool o254;
    in >> o254;
    out.setBSourceNameAvailable(o254);
    ::std::string o255;
    in >> o255;
    out.setSourceName(o255);
    bool o256;
    in >> o256;
    out.setBSourceSupportsRouteGuidanceAvailable(o256);
    bool o257;
    in >> o257;
    out.setSourceSupportsRouteGuidance(o257);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBRouteGuidanceDisplayComponentIDsAvailable();
    {
        uint32 o258 = static_cast<uint32>(in.getRouteGuidanceDisplayComponentIDs().size());
        out << o258;
        ::std::vector< ::smartphoneint_main_fi_types::T_e8_ComponentID >::const_iterator o259;
        for (o259 = in.getRouteGuidanceDisplayComponentIDs().begin(); o259 != in.getRouteGuidanceDisplayComponentIDs().end(); ++o259) {
            out << (uint8) (*o259);
        }
    }
    out << (uint8) in.getBIndexAvailable();
    out << in.getU16Index();
    out << (uint8) in.getBManeuverDescriptionAvailable();
    out << in.getSzManeuverDescription();
    out << (uint8) in.getBManeuverTypeAvailable();
    out << (uint8) in.getE8ManeuverType();
    out << (uint8) in.getBAfterManeuverRoadNameAvailable();
    out << in.getSzAfterManeuverRoadName();
    out << (uint8) in.getBDistanceBetweenManeuverAvailable();
    out << in.getU32DistanceBetweenManeuver();
    out << (uint8) in.getBDistanceBetweenManeuverDisplayStrAvailable();
    out << in.getSzDistanceBetweenManeuverDisplayStr();
    out << (uint8) in.getBDistanceBetweenManeuverDisplayUnitsAvailable();
    out << (uint8) in.getE8DistanceBetweenManeuverDisplayUnits();
    out << (uint8) in.getBDrivingSideAvailable();
    out << (uint8) in.getE8DrivingSide();
    out << (uint8) in.getBJunctionTypeAvailable();
    out << (uint8) in.getE8JunctionType();
    out << (uint8) in.getBJunctionElementAngleAvailable();
    {
        uint32 o260 = static_cast<uint32>(in.getS16JunctionElementAngleList().size());
        out << o260;
        ::std::vector< int16 >::const_iterator o261;
        for (o261 = in.getS16JunctionElementAngleList().begin(); o261 != in.getS16JunctionElementAngleList().end(); ++o261) {
            out << (*o261);
        }
    }
    out << (uint8) in.getBJunctionElementExitAngleAvailable();
    out << in.getS16JunctionElementExitAngle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_CarPlayRouteGuidanceManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o262;
    in >> o262;
    out.setBRouteGuidanceDisplayComponentIDsAvailable(o262);
    {
        uint32 o263;
        in >> o263;
        out.getRouteGuidanceDisplayComponentIDsMutable().clear ();
        out.getRouteGuidanceDisplayComponentIDsMutable().reserve (o263);
        for (uint32 o264 = 0; o264 < o263; o264++) {
            uint8 o265;
            in >> o265;
            out.getRouteGuidanceDisplayComponentIDsMutable().push_back((::smartphoneint_main_fi_types::T_e8_ComponentID) o265);
        }
    }
    bool o266;
    in >> o266;
    out.setBIndexAvailable(o266);
    uint16 o267;
    in >> o267;
    out.setU16Index(o267);
    bool o268;
    in >> o268;
    out.setBManeuverDescriptionAvailable(o268);
    ::std::string o269;
    in >> o269;
    out.setSzManeuverDescription(o269);
    bool o270;
    in >> o270;
    out.setBManeuverTypeAvailable(o270);
    uint8 o271;
    in >> o271;
    out.setE8ManeuverType((::smartphoneint_main_fi_types::T_e8_DiPoManeuverType)o271);
    bool o272;
    in >> o272;
    out.setBAfterManeuverRoadNameAvailable(o272);
    ::std::string o273;
    in >> o273;
    out.setSzAfterManeuverRoadName(o273);
    bool o274;
    in >> o274;
    out.setBDistanceBetweenManeuverAvailable(o274);
    uint32 o275;
    in >> o275;
    out.setU32DistanceBetweenManeuver(o275);
    bool o276;
    in >> o276;
    out.setBDistanceBetweenManeuverDisplayStrAvailable(o276);
    ::std::string o277;
    in >> o277;
    out.setSzDistanceBetweenManeuverDisplayStr(o277);
    bool o278;
    in >> o278;
    out.setBDistanceBetweenManeuverDisplayUnitsAvailable(o278);
    uint8 o279;
    in >> o279;
    out.setE8DistanceBetweenManeuverDisplayUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o279);
    bool o280;
    in >> o280;
    out.setBDrivingSideAvailable(o280);
    uint8 o281;
    in >> o281;
    out.setE8DrivingSide((::smartphoneint_main_fi_types::T_e8_DiPoDrivingSide)o281);
    bool o282;
    in >> o282;
    out.setBJunctionTypeAvailable(o282);
    uint8 o283;
    in >> o283;
    out.setE8JunctionType((::smartphoneint_main_fi_types::T_e8_DiPoJunctionType)o283);
    bool o284;
    in >> o284;
    out.setBJunctionElementAngleAvailable(o284);
    {
        uint32 o285;
        in >> o285;
        out.getS16JunctionElementAngleListMutable().clear ();
        out.getS16JunctionElementAngleListMutable().reserve (o285);
        for (uint32 o286 = 0; o286 < o285; o286++) {
            int16 o287;
            in >> o287;
            out.getS16JunctionElementAngleListMutable().push_back(o287);
        }
    }
    bool o288;
    in >> o288;
    out.setBJunctionElementExitAngleAvailable(o288);
    int16 o289;
    in >> o289;
    out.setS16JunctionElementExitAngle(o289);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DiPORouteGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8RouteGuidanceState();
    out << (uint8) in.getE8ManeuverState();
    out << in.getSzCurrentRoadName();
    out << in.getSzDestinationName();
    out << in.getU64EstimatedTimeOfArrival();
    out << in.getU64TimeRemainingToDestination();
    out << in.getU32DistanceRemaining();
    out << in.getSzDistanceRemainingDisplayStr();
    out << (uint8) in.getE8DistanceRemainingDisplayUnits();
    out << in.getU32DistanceToNextManeuver();
    out << in.getSzDistanceToNextManeuverDisplayStr();
    out << (uint8) in.getE8DistanceToNextManeuverDisplayUnits();
    {
        uint32 o290 = static_cast<uint32>(in.getU16RouteGuidanceManeuverCurrentList().size());
        out << o290;
        ::std::vector< uint16 >::const_iterator o291;
        for (o291 = in.getU16RouteGuidanceManeuverCurrentList().begin(); o291 != in.getU16RouteGuidanceManeuverCurrentList().end(); ++o291) {
            out << (*o291);
        }
    }
    out << in.getU16RouteGuidanceManeuverCount();
    out << (uint8) in.getBIsRouteGuidanceVisibleInApp();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DiPORouteGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o292;
    in >> o292;
    out.setE8RouteGuidanceState((::smartphoneint_main_fi_types::T_e8_DiPoRouteGuidanceState)o292);
    uint8 o293;
    in >> o293;
    out.setE8ManeuverState((::smartphoneint_main_fi_types::T_e8_DiPoManeuverState)o293);
    ::std::string o294;
    in >> o294;
    out.setSzCurrentRoadName(o294);
    ::std::string o295;
    in >> o295;
    out.setSzDestinationName(o295);
    uint64 o296;
    in >> o296;
    out.setU64EstimatedTimeOfArrival(o296);
    uint64 o297;
    in >> o297;
    out.setU64TimeRemainingToDestination(o297);
    uint32 o298;
    in >> o298;
    out.setU32DistanceRemaining(o298);
    ::std::string o299;
    in >> o299;
    out.setSzDistanceRemainingDisplayStr(o299);
    uint8 o300;
    in >> o300;
    out.setE8DistanceRemainingDisplayUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o300);
    uint32 o301;
    in >> o301;
    out.setU32DistanceToNextManeuver(o301);
    ::std::string o302;
    in >> o302;
    out.setSzDistanceToNextManeuverDisplayStr(o302);
    uint8 o303;
    in >> o303;
    out.setE8DistanceToNextManeuverDisplayUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o303);
    {
        uint32 o304;
        in >> o304;
        out.getU16RouteGuidanceManeuverCurrentListMutable().clear ();
        out.getU16RouteGuidanceManeuverCurrentListMutable().reserve (o304);
        for (uint32 o305 = 0; o305 < o304; o305++) {
            uint16 o306;
            in >> o306;
            out.getU16RouteGuidanceManeuverCurrentListMutable().push_back(o306);
        }
    }
    uint16 o307;
    in >> o307;
    out.setU16RouteGuidanceManeuverCount(o307);
    bool o308;
    in >> o308;
    out.setBIsRouteGuidanceVisibleInApp(o308);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_DiPORouteGuidanceManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16Index();
    out << in.getSzManeuverDescription();
    out << (uint8) in.getE8ManeuverType();
    out << in.getSzAfterManeuverRoadName();
    out << in.getU32DistanceBetweenManeuver();
    out << in.getSzDistanceBetweenManeuverDisplayStr();
    out << (uint8) in.getE8DistanceBetweenManeuverDisplayUnits();
    out << (uint8) in.getE8DrivingSide();
    out << (uint8) in.getE8JunctionType();
    out << in.getS16JunctionElementAngle();
    out << in.getS16JunctionElementExitAngle();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_DiPORouteGuidanceManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o309;
    in >> o309;
    out.setU16Index(o309);
    ::std::string o310;
    in >> o310;
    out.setSzManeuverDescription(o310);
    uint8 o311;
    in >> o311;
    out.setE8ManeuverType((::smartphoneint_main_fi_types::T_e8_DiPoManeuverType)o311);
    ::std::string o312;
    in >> o312;
    out.setSzAfterManeuverRoadName(o312);
    uint32 o313;
    in >> o313;
    out.setU32DistanceBetweenManeuver(o313);
    ::std::string o314;
    in >> o314;
    out.setSzDistanceBetweenManeuverDisplayStr(o314);
    uint8 o315;
    in >> o315;
    out.setE8DistanceBetweenManeuverDisplayUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o315);
    uint8 o316;
    in >> o316;
    out.setE8DrivingSide((::smartphoneint_main_fi_types::T_e8_DiPoDrivingSide)o316);
    uint8 o317;
    in >> o317;
    out.setE8JunctionType((::smartphoneint_main_fi_types::T_e8_DiPoJunctionType)o317);
    int16 o318;
    in >> o318;
    out.setS16JunctionElementAngle(o318);
    int16 o319;
    in >> o319;
    out.setS16JunctionElementExitAngle(o319);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_CarPlayTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getDiPoRouteGuidanceUpdate(), out, majorVersion);
    out << (uint8) in.getIsDiPoRouteGuidanceUpdateValid();
    serializeCca(in.getDiPoRouteGuidanceManeuverUpdate(), out, majorVersion);
    out << (uint8) in.getIsDiPoRouteGuidanceManeuverUpdateValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_CarPlayTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getDiPoRouteGuidanceUpdateMutable(), majorVersion);
    bool o320;
    in >> o320;
    out.setIsDiPoRouteGuidanceUpdateValid(o320);
    deserializeCca(in, out.getDiPoRouteGuidanceManeuverUpdateMutable(), majorVersion);
    bool o321;
    in >> o321;
    out.setIsDiPoRouteGuidanceManeuverUpdateValid(o321);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AAutoNavigationNextTurnData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getRoadName();
    out << (uint8) in.getTurnSide();
    out << (uint8) in.getNextTurnEvent();
    {
        uint32 o322 = static_cast<uint32>(in.getImage().size());
        out << o322;
        ::std::vector< uint8 >::const_iterator o323;
        for (o323 = in.getImage().begin(); o323 != in.getImage().end(); ++o323) {
            out << (*o323);
        }
    }
    out << in.getTurnAngle();
    out << in.getTurnNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AAutoNavigationNextTurnData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o324;
    in >> o324;
    out.setRoadName(o324);
    uint8 o325;
    in >> o325;
    out.setTurnSide((::smartphoneint_main_fi_types::T_e8_AAutoTurnSide)o325);
    uint8 o326;
    in >> o326;
    out.setNextTurnEvent((::smartphoneint_main_fi_types::T_e8_AAutoNextTurnEvent)o326);
    {
        uint32 o327;
        in >> o327;
        out.getImageMutable().clear ();
        out.getImageMutable().reserve (o327);
        for (uint32 o328 = 0; o328 < o327; o328++) {
            uint8 o329;
            in >> o329;
            out.getImageMutable().push_back(o329);
        }
    }
    int32 o330;
    in >> o330;
    out.setTurnAngle(o330);
    int32 o331;
    in >> o331;
    out.setTurnNumber(o331);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AAutoNavigationNextTurnDistanceData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDistanceInMeters();
    out << in.getTimeInSec();
    out << in.getDistanceToManeuver();
    out << (uint8) in.getManeuverDistanceUnits();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AAutoNavigationNextTurnDistanceData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    int32 o332;
    in >> o332;
    out.setDistanceInMeters(o332);
    int32 o333;
    in >> o333;
    out.setTimeInSec(o333);
    int32 o334;
    in >> o334;
    out.setDistanceToManeuver(o334);
    uint8 o335;
    in >> o335;
    out.setManeuverDistanceUnits((::smartphoneint_main_fi_types::T_e8_DistanceUnits)o335);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AAutoTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getAAutoNavigationNextTurnData(), out, majorVersion);
    out << (uint8) in.getIsAAutoNavigationNextTurnDataValid();
    serializeCca(in.getAAutoNavigationNextTurnDistanceData(), out, majorVersion);
    out << (uint8) in.getIsAAutoNavigationNextTurnDistanceDataValid();
    out << (uint8) in.getAAutoNavigationStatus();
    out << (uint8) in.getIsAAutoNavigationStatusValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AAutoTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getAAutoNavigationNextTurnDataMutable(), majorVersion);
    bool o336;
    in >> o336;
    out.setIsAAutoNavigationNextTurnDataValid(o336);
    deserializeCca(in, out.getAAutoNavigationNextTurnDistanceDataMutable(), majorVersion);
    bool o337;
    in >> o337;
    out.setIsAAutoNavigationNextTurnDistanceDataValid(o337);
    uint8 o338;
    in >> o338;
    out.setAAutoNavigationStatus((::smartphoneint_main_fi_types::T_e8_AAutoNavigationAppState)o338);
    bool o339;
    in >> o339;
    out.setIsAAutoNavigationStatusValid(o339);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_CarlifeNaviNextTurnInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBDCLNavigationAppState();
    out << (uint8) in.getBDCLNaviTurnType();
    out << in.getRoadName();
    out << in.getTotalDistance();
    out << in.getRemainDistance();
    {
        uint32 o340 = static_cast<uint32>(in.getTurnIconData().size());
        out << o340;
        ::std::vector< uint8 >::const_iterator o341;
        for (o341 = in.getTurnIconData().begin(); o341 != in.getTurnIconData().end(); ++o341) {
            out << (*o341);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_CarlifeNaviNextTurnInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o342;
    in >> o342;
    out.setBDCLNavigationAppState((::smartphoneint_main_fi_types::T_e8_BDCLNavigationAppState)o342);
    uint8 o343;
    in >> o343;
    out.setBDCLNaviTurnType((::smartphoneint_main_fi_types::T_e8_BDCLNextTurnType)o343);
    ::std::string o344;
    in >> o344;
    out.setRoadName(o344);
    uint32 o345;
    in >> o345;
    out.setTotalDistance(o345);
    uint32 o346;
    in >> o346;
    out.setRemainDistance(o346);
    {
        uint32 o347;
        in >> o347;
        out.getTurnIconDataMutable().clear ();
        out.getTurnIconDataMutable().reserve (o347);
        for (uint32 o348 = 0; o348 < o347; o348++) {
            uint8 o349;
            in >> o349;
            out.getTurnIconDataMutable().push_back(o349);
        }
    }
}

void serializeCca(const ::smartphoneint_main_fi_types::T_CarlifeNaviAssistantGuideInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getBDCLAssistantGuideAppState();
    out << (uint8) in.getAssistantType();
    out << (uint8) in.getTrafficSignType();
    out << in.getTotalDistance();
    out << in.getRemainDistance();
    out << in.getCameraSpeed();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_CarlifeNaviAssistantGuideInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o350;
    in >> o350;
    out.setBDCLAssistantGuideAppState((::smartphoneint_main_fi_types::T_e8_BDCLNavigationAppState)o350);
    uint8 o351;
    in >> o351;
    out.setAssistantType((::smartphoneint_main_fi_types::T_e8_BDCLAssistantType)o351);
    uint8 o352;
    in >> o352;
    out.setTrafficSignType((::smartphoneint_main_fi_types::T_e8_BDCLTrafficSignType)o352);
    uint32 o353;
    in >> o353;
    out.setTotalDistance(o353);
    uint32 o354;
    in >> o354;
    out.setRemainDistance(o354);
    uint32 o355;
    in >> o355;
    out.setCameraSpeed(o355);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_BDCLTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getCarlifeNaviNextTurnInfo(), out, majorVersion);
    out << (uint8) in.getIsCarlifeNaviNextTurnInfoValid();
    serializeCca(in.getCarlifeNaviAssistantGuideInfo(), out, majorVersion);
    out << (uint8) in.getIsCarlifeNaviAssistantGuideInfoValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_BDCLTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getCarlifeNaviNextTurnInfoMutable(), majorVersion);
    bool o356;
    in >> o356;
    out.setIsCarlifeNaviNextTurnInfoValid(o356);
    deserializeCca(in, out.getCarlifeNaviAssistantGuideInfoMutable(), majorVersion);
    bool o357;
    in >> o357;
    out.setIsCarlifeNaviAssistantGuideInfoValid(o357);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_ProjectionVideoAttributes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16UIResolutionHeight();
    out << in.getU16UIResolutionWidth();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_ProjectionVideoAttributes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o358;
    in >> o358;
    out.setU16UIResolutionHeight(o358);
    uint16 o359;
    in >> o359;
    out.setU16UIResolutionWidth(o359);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLTBTUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getMLNavigationInfoUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationInfoUpdateValid();
    serializeCca(in.getMLNavigationNextManeuverUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationNextManeuverUpdateValid();
    serializeCca(in.getMLSpeedLimitUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLSpeedLimitUpdateValid();
    serializeCca(in.getMLNavigationNextDistanceUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationNextDistanceUpdateValid();
    serializeCca(in.getMLNavigationLaneGuidanceUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationLaneGuidanceUpdateValid();
    serializeCca(in.getMLNavigationTripInfoUpdate(), out, majorVersion);
    out << (uint8) in.getIsMLNavigationTripInfoUpdateValid();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLTBTUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getMLNavigationInfoUpdateMutable(), majorVersion);
    bool o360;
    in >> o360;
    out.setIsMLNavigationInfoUpdateValid(o360);
    deserializeCca(in, out.getMLNavigationNextManeuverUpdateMutable(), majorVersion);
    bool o361;
    in >> o361;
    out.setIsMLNavigationNextManeuverUpdateValid(o361);
    deserializeCca(in, out.getMLSpeedLimitUpdateMutable(), majorVersion);
    bool o362;
    in >> o362;
    out.setIsMLSpeedLimitUpdateValid(o362);
    deserializeCca(in, out.getMLNavigationNextDistanceUpdateMutable(), majorVersion);
    bool o363;
    in >> o363;
    out.setIsMLNavigationNextDistanceUpdateValid(o363);
    deserializeCca(in, out.getMLNavigationLaneGuidanceUpdateMutable(), majorVersion);
    bool o364;
    in >> o364;
    out.setIsMLNavigationLaneGuidanceUpdateValid(o364);
    deserializeCca(in, out.getMLNavigationTripInfoUpdateMutable(), majorVersion);
    bool o365;
    in >> o365;
    out.setIsMLNavigationTripInfoUpdateValid(o365);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLNavigationInfoUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getNavAppName();
    out << (uint8) in.getGuidanceState();
    out << (uint32) in.getGuidanceActive();
    out << (uint8) in.getMetricSystem();
    out << (uint8) in.getRightDriving();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLNavigationInfoUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o366;
    in >> o366;
    out.setNavAppName(o366);
    uint8 o367;
    in >> o367;
    out.setGuidanceState((::smartphoneint_main_fi_types::T_e8_MLGuidanceState)o367);
    uint32 o368;
    in >> o368;
    out.setGuidanceActive((::smartphoneint_main_fi_types::T_e8_MLGuidanceActive)o368);
    bool o369;
    in >> o369;
    out.setMetricSystem(o369);
    bool o370;
    in >> o370;
    out.setRightDriving(o370);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLNavigationNextManeuverUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint32) in.getNextDirection();
    out << in.getNextManeuverIndex();
    out << in.getNextAngle();
    {
        uint32 o371 = static_cast<uint32>(in.getNextSideStreetAngles_1().size());
        out << o371;
        ::std::vector< uint32 >::const_iterator o372;
        for (o372 = in.getNextSideStreetAngles_1().begin(); o372 != in.getNextSideStreetAngles_1().end(); ++o372) {
            out << (*o372);
        }
    }
    {
        uint32 o373 = static_cast<uint32>(in.getNextSideStreetAngles_2().size());
        out << o373;
        ::std::vector< uint32 >::const_iterator o374;
        for (o374 = in.getNextSideStreetAngles_2().begin(); o374 != in.getNextSideStreetAngles_2().end(); ++o374) {
            out << (*o374);
        }
    }
    {
        uint32 o375 = static_cast<uint32>(in.getNextSideStreetAngles_3().size());
        out << o375;
        ::std::vector< uint32 >::const_iterator o376;
        for (o376 = in.getNextSideStreetAngles_3().begin(); o376 != in.getNextSideStreetAngles_3().end(); ++o376) {
            out << (*o376);
        }
    }
    out << in.getNextStreetName();
    out << in.getCurrentStreetName();
    out << in.getNumOfSideStreetAngles_1();
    out << in.getNumOfSideStreetAngles_2();
    out << in.getNumOfSideStreetAngles_3();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLNavigationNextManeuverUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o377;
    in >> o377;
    out.setNextDirection((::smartphoneint_main_fi_types::T_e8_MLNextDirection)o377);
    uint32 o378;
    in >> o378;
    out.setNextManeuverIndex(o378);
    uint32 o379;
    in >> o379;
    out.setNextAngle(o379);
    {
        uint32 o380;
        in >> o380;
        out.getNextSideStreetAngles_1Mutable().clear ();
        out.getNextSideStreetAngles_1Mutable().reserve (o380);
        for (uint32 o381 = 0; o381 < o380; o381++) {
            uint32 o382;
            in >> o382;
            out.getNextSideStreetAngles_1Mutable().push_back(o382);
        }
    }
    {
        uint32 o383;
        in >> o383;
        out.getNextSideStreetAngles_2Mutable().clear ();
        out.getNextSideStreetAngles_2Mutable().reserve (o383);
        for (uint32 o384 = 0; o384 < o383; o384++) {
            uint32 o385;
            in >> o385;
            out.getNextSideStreetAngles_2Mutable().push_back(o385);
        }
    }
    {
        uint32 o386;
        in >> o386;
        out.getNextSideStreetAngles_3Mutable().clear ();
        out.getNextSideStreetAngles_3Mutable().reserve (o386);
        for (uint32 o387 = 0; o387 < o386; o387++) {
            uint32 o388;
            in >> o388;
            out.getNextSideStreetAngles_3Mutable().push_back(o388);
        }
    }
    ::std::string o389;
    in >> o389;
    out.setNextStreetName(o389);
    ::std::string o390;
    in >> o390;
    out.setCurrentStreetName(o390);
    uint32 o391;
    in >> o391;
    out.setNumOfSideStreetAngles_1(o391);
    uint32 o392;
    in >> o392;
    out.setNumOfSideStreetAngles_2(o392);
    uint32 o393;
    in >> o393;
    out.setNumOfSideStreetAngles_3(o393);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLSpeedLimitUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getCurrentSpeedLimit();
    out << in.getNextSpeedLimit();
    out << in.getDistance();
    out << (uint8) in.getDistanceUnit();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLSpeedLimitUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o394;
    in >> o394;
    out.setCurrentSpeedLimit(o394);
    uint32 o395;
    in >> o395;
    out.setNextSpeedLimit(o395);
    uint32 o396;
    in >> o396;
    out.setDistance(o396);
    uint8 o397;
    in >> o397;
    out.setDistanceUnit((::smartphoneint_main_fi_types::T_e8_DistanceUnit)o397);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLNavigationNextDistanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDistance();
    out << (uint8) in.getDistanceUnit();
    out << in.getTime();
    out << in.getPercentage();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLNavigationNextDistanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o398;
    in >> o398;
    out.setDistance(o398);
    uint8 o399;
    in >> o399;
    out.setDistanceUnit((::smartphoneint_main_fi_types::T_e8_DistanceUnit)o399);
    uint64 o400;
    in >> o400;
    out.setTime(o400);
    uint32 o401;
    in >> o401;
    out.setPercentage(o401);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLNavigationLaneGuidanceUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o402 = static_cast<uint32>(in.getNextLaneGuidances().size());
        out << o402;
        ::std::vector< uint32 >::const_iterator o403;
        for (o403 = in.getNextLaneGuidances().begin(); o403 != in.getNextLaneGuidances().end(); ++o403) {
            out << (*o403);
        }
    }
    out << in.getNumOfLaneGuidances();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLNavigationLaneGuidanceUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    {
        uint32 o404;
        in >> o404;
        out.getNextLaneGuidancesMutable().clear ();
        out.getNextLaneGuidancesMutable().reserve (o404);
        for (uint32 o405 = 0; o405 < o404; o405++) {
            uint32 o406;
            in >> o406;
            out.getNextLaneGuidancesMutable().push_back(o406);
        }
    }
    uint32 o407;
    in >> o407;
    out.setNumOfLaneGuidances(o407);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_MLNavigationTripInfoUpdate& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getDestination();
    out << in.getDistance();
    out << (uint8) in.getDistanceUnit();
    out << in.getRemainingTravelTime();
    out << in.getRemainingTrafficTime();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_MLNavigationTripInfoUpdate& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o408;
    in >> o408;
    out.setDestination(o408);
    uint32 o409;
    in >> o409;
    out.setDistance(o409);
    uint8 o410;
    in >> o410;
    out.setDistanceUnit((::smartphoneint_main_fi_types::T_e8_DistanceUnit)o410);
    uint64 o411;
    in >> o411;
    out.setRemainingTravelTime(o411);
    uint64 o412;
    in >> o412;
    out.setRemainingTrafficTime(o412);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_AmbientColourData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getFRed();
    out << in.getFGreen();
    out << in.getFBlue();
    out << in.getFAlpha();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_AmbientColourData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    float o413;
    in >> o413;
    out.setFRed(o413);
    float o414;
    in >> o414;
    out.setFGreen(o414);
    float o415;
    in >> o415;
    out.setFBlue(o415);
    float o416;
    in >> o416;
    out.setFAlpha(o416);
}

void serializeCca(const ::smartphoneint_main_fi_types::T_RouteGuidanceDisplayComponent& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getComponentID();
    out << in.getDisplayName();
    out << in.getU16MaxCurrentRoadNameLength();
    out << in.getU16MaxDestinationNameLength();
    out << in.getU16MaxAfterManeuverRoadNameLength();
    out << in.getU16MaxManeuverDescriptionLength();
    out << in.getU16MaxGuidanceManeuverCapacity();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::smartphoneint_main_fi_types::T_RouteGuidanceDisplayComponent& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o417;
    in >> o417;
    out.setComponentID((::smartphoneint_main_fi_types::T_e8_ComponentID)o417);
    ::std::string o418;
    in >> o418;
    out.setDisplayName(o418);
    uint16 o419;
    in >> o419;
    out.setU16MaxCurrentRoadNameLength(o419);
    uint16 o420;
    in >> o420;
    out.setU16MaxDestinationNameLength(o420);
    uint16 o421;
    in >> o421;
    out.setU16MaxAfterManeuverRoadNameLength(o421);
    uint16 o422;
    in >> o422;
    out.setU16MaxManeuverDescriptionLength(o422);
    uint16 o423;
    in >> o423;
    out.setU16MaxGuidanceManeuverCapacity(o423);
}

