/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef SMARTPHONEINT_MAIN_FIPROXY_H
#define SMARTPHONEINT_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "smartphoneint_main_fi.h"
#include "smartphoneint_main_fi_types.h"
#include "smartphoneint_main_fi_typesConst.h"
#include <string>
#include <vector>

namespace smartphoneint_main_fi {

class Smartphoneint_main_fiProxy;

class AAPNotificationEventCallbackIF {
public:
    virtual ~AAPNotificationEventCallbackIF() {}

    virtual void onAAPNotificationEventError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AAPNotificationEventError >& error) = 0;

    virtual void onAAPNotificationEventStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AAPNotificationEventStatus >& status) = 0;
};

class AAutoTurnByTurnInfoCallbackIF {
public:
    virtual ~AAutoTurnByTurnInfoCallbackIF() {}

    virtual void onAAutoTurnByTurnInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AAutoTurnByTurnInfoError >& error) = 0;

    virtual void onAAutoTurnByTurnInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AAutoTurnByTurnInfoStatus >& status) = 0;
};

class AccessoryAppStateCallbackIF {
public:
    virtual ~AccessoryAppStateCallbackIF() {}

    virtual void onAccessoryAppStateError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AccessoryAppStateError >& error) = 0;

    virtual void onAccessoryAppStateResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AccessoryAppStateResult >& result) = 0;
};

class AccessoryAudioContextCallbackIF {
public:
    virtual ~AccessoryAudioContextCallbackIF() {}

    virtual void onAccessoryAudioContextError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AccessoryAudioContextError >& error) = 0;

    virtual void onAccessoryAudioContextResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AccessoryAudioContextResult >& result) = 0;
};

class AccessoryDisplayContextCallbackIF {
public:
    virtual ~AccessoryDisplayContextCallbackIF() {}

    virtual void onAccessoryDisplayContextError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AccessoryDisplayContextError >& error) = 0;

    virtual void onAccessoryDisplayContextResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AccessoryDisplayContextResult >& result) = 0;
};

class AppStatusInfoCallbackIF {
public:
    virtual ~AppStatusInfoCallbackIF() {}

    virtual void onAppStatusInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AppStatusInfoError >& error) = 0;

    virtual void onAppStatusInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< AppStatusInfoStatus >& status) = 0;
};

class ApplicationMediaMetaDataCallbackIF {
public:
    virtual ~ApplicationMediaMetaDataCallbackIF() {}

    virtual void onApplicationMediaMetaDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ApplicationMediaMetaDataError >& error) = 0;

    virtual void onApplicationMediaMetaDataStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ApplicationMediaMetaDataStatus >& status) = 0;
};

class ApplicationPhoneDataCallbackIF {
public:
    virtual ~ApplicationPhoneDataCallbackIF() {}

    virtual void onApplicationPhoneDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ApplicationPhoneDataError >& error) = 0;

    virtual void onApplicationPhoneDataStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ApplicationPhoneDataStatus >& status) = 0;
};

class BDCLTurnByTurnInfoCallbackIF {
public:
    virtual ~BDCLTurnByTurnInfoCallbackIF() {}

    virtual void onBDCLTurnByTurnInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< BDCLTurnByTurnInfoError >& error) = 0;

    virtual void onBDCLTurnByTurnInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< BDCLTurnByTurnInfoStatus >& status) = 0;
};

class BTPairingRequiredCallbackIF {
public:
    virtual ~BTPairingRequiredCallbackIF() {}

    virtual void onBTPairingRequiredError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< BTPairingRequiredError >& error) = 0;

    virtual void onBTPairingRequiredStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< BTPairingRequiredStatus >& status) = 0;
};

class BluetoothDeviceStatusCallbackIF {
public:
    virtual ~BluetoothDeviceStatusCallbackIF() {}

    virtual void onBluetoothDeviceStatusError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< BluetoothDeviceStatusError >& error) = 0;

    virtual void onBluetoothDeviceStatusStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< BluetoothDeviceStatusStatus >& status) = 0;
};

class CarplayRouteGuidanceManeuverUpdateCallbackIF {
public:
    virtual ~CarplayRouteGuidanceManeuverUpdateCallbackIF() {}

    virtual void onCarplayRouteGuidanceManeuverUpdateError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< CarplayRouteGuidanceManeuverUpdateError >& error) = 0;

    virtual void onCarplayRouteGuidanceManeuverUpdateStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< CarplayRouteGuidanceManeuverUpdateStatus >& status) = 0;
};

class CarplayRouteGuidanceUpdateCallbackIF {
public:
    virtual ~CarplayRouteGuidanceUpdateCallbackIF() {}

    virtual void onCarplayRouteGuidanceUpdateError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< CarplayRouteGuidanceUpdateError >& error) = 0;

    virtual void onCarplayRouteGuidanceUpdateStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< CarplayRouteGuidanceUpdateStatus >& status) = 0;
};

class DAPStatusInfoCallbackIF {
public:
    virtual ~DAPStatusInfoCallbackIF() {}

    virtual void onDAPStatusInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DAPStatusInfoError >& error) = 0;

    virtual void onDAPStatusInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DAPStatusInfoStatus >& status) = 0;
};

class DeleteDeviceCallbackIF {
public:
    virtual ~DeleteDeviceCallbackIF() {}

    virtual void onDeleteDeviceError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteDeviceError >& error) = 0;

    virtual void onDeleteDeviceResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeleteDeviceResult >& result) = 0;
};

class DeviceAudioContextCallbackIF {
public:
    virtual ~DeviceAudioContextCallbackIF() {}

    virtual void onDeviceAudioContextError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceAudioContextError >& error) = 0;

    virtual void onDeviceAudioContextStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceAudioContextStatus >& status) = 0;
};

class DeviceDisplayContextCallbackIF {
public:
    virtual ~DeviceDisplayContextCallbackIF() {}

    virtual void onDeviceDisplayContextError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceDisplayContextError >& error) = 0;

    virtual void onDeviceDisplayContextStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceDisplayContextStatus >& status) = 0;
};

class DeviceLockStatusCallbackIF {
public:
    virtual ~DeviceLockStatusCallbackIF() {}

    virtual void onDeviceLockStatusError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceLockStatusError >& error) = 0;

    virtual void onDeviceLockStatusStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceLockStatusStatus >& status) = 0;
};

class DeviceStatusInfoCallbackIF {
public:
    virtual ~DeviceStatusInfoCallbackIF() {}

    virtual void onDeviceStatusInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceStatusInfoError >& error) = 0;

    virtual void onDeviceStatusInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DeviceStatusInfoStatus >& status) = 0;
};

class DiPOAppStatusInfoCallbackIF {
public:
    virtual ~DiPOAppStatusInfoCallbackIF() {}

    virtual void onDiPOAppStatusInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DiPOAppStatusInfoError >& error) = 0;

    virtual void onDiPOAppStatusInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DiPOAppStatusInfoStatus >& status) = 0;
};

class DiPORoleSwitchRequiredCallbackIF {
public:
    virtual ~DiPORoleSwitchRequiredCallbackIF() {}

    virtual void onDiPORoleSwitchRequiredError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DiPORoleSwitchRequiredError >& error) = 0;

    virtual void onDiPORoleSwitchRequiredResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DiPORoleSwitchRequiredResult >& result) = 0;
};

class DialCallbackIF {
public:
    virtual ~DialCallbackIF() {}

    virtual void onDialError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DialError >& error) = 0;

    virtual void onDialStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DialStatus >& status) = 0;
};

class DistanceToEmptyTankCallbackIF {
public:
    virtual ~DistanceToEmptyTankCallbackIF() {}

    virtual void onDistanceToEmptyTankError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DistanceToEmptyTankError >& error) = 0;

    virtual void onDistanceToEmptyTankResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< DistanceToEmptyTankResult >& result) = 0;
};

class GetAppIconDataCallbackIF {
public:
    virtual ~GetAppIconDataCallbackIF() {}

    virtual void onGetAppIconDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAppIconDataError >& error) = 0;

    virtual void onGetAppIconDataResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAppIconDataResult >& result) = 0;
};

class GetAppListCallbackIF {
public:
    virtual ~GetAppListCallbackIF() {}

    virtual void onGetAppListError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAppListError >& error) = 0;

    virtual void onGetAppListResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetAppListResult >& result) = 0;
};

class GetDeviceInfoListCallbackIF {
public:
    virtual ~GetDeviceInfoListCallbackIF() {}

    virtual void onGetDeviceInfoListError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoListError >& error) = 0;

    virtual void onGetDeviceInfoListResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDeviceInfoListResult >& result) = 0;
};

class GetDeviceListCallbackIF {
public:
    virtual ~GetDeviceListCallbackIF() {}

    virtual void onGetDeviceListError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDeviceListError >& error) = 0;

    virtual void onGetDeviceListResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDeviceListResult >& result) = 0;
};

class GetDeviceUsagePreferenceCallbackIF {
public:
    virtual ~GetDeviceUsagePreferenceCallbackIF() {}

    virtual void onGetDeviceUsagePreferenceError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDeviceUsagePreferenceError >& error) = 0;

    virtual void onGetDeviceUsagePreferenceResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDeviceUsagePreferenceResult >& result) = 0;
};

class GetKeyIconDataCallbackIF {
public:
    virtual ~GetKeyIconDataCallbackIF() {}

    virtual void onGetKeyIconDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetKeyIconDataError >& error) = 0;

    virtual void onGetKeyIconDataResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetKeyIconDataResult >& result) = 0;
};

class GetMediaObjectAlbumArtCallbackIF {
public:
    virtual ~GetMediaObjectAlbumArtCallbackIF() {}

    virtual void onGetMediaObjectAlbumArtError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetMediaObjectAlbumArtError >& error) = 0;

    virtual void onGetMediaObjectAlbumArtResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetMediaObjectAlbumArtResult >& result) = 0;
};

class GetSPIVersionInfoCallbackIF {
public:
    virtual ~GetSPIVersionInfoCallbackIF() {}

    virtual void onGetSPIVersionInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSPIVersionInfoError >& error) = 0;

    virtual void onGetSPIVersionInfoResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSPIVersionInfoResult >& result) = 0;
};

class GetTechnologyPreferenceCallbackIF {
public:
    virtual ~GetTechnologyPreferenceCallbackIF() {}

    virtual void onGetTechnologyPreferenceError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTechnologyPreferenceError >& error) = 0;

    virtual void onGetTechnologyPreferenceResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetTechnologyPreferenceResult >& result) = 0;
};

class GetVideoSettingsCallbackIF {
public:
    virtual ~GetVideoSettingsCallbackIF() {}

    virtual void onGetVideoSettingsError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVideoSettingsError >& error) = 0;

    virtual void onGetVideoSettingsResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetVideoSettingsResult >& result) = 0;
};

class GetWiFiCredentialsCallbackIF {
public:
    virtual ~GetWiFiCredentialsCallbackIF() {}

    virtual void onGetWiFiCredentialsError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWiFiCredentialsError >& error) = 0;

    virtual void onGetWiFiCredentialsResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< GetWiFiCredentialsResult >& result) = 0;
};

class InitiateWirelessDiscoveryCallbackIF {
public:
    virtual ~InitiateWirelessDiscoveryCallbackIF() {}

    virtual void onInitiateWirelessDiscoveryError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< InitiateWirelessDiscoveryError >& error) = 0;

    virtual void onInitiateWirelessDiscoveryResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< InitiateWirelessDiscoveryResult >& result) = 0;
};

class InvokeBluetoothDeviceActionCallbackIF {
public:
    virtual ~InvokeBluetoothDeviceActionCallbackIF() {}

    virtual void onInvokeBluetoothDeviceActionError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< InvokeBluetoothDeviceActionError >& error) = 0;

    virtual void onInvokeBluetoothDeviceActionResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< InvokeBluetoothDeviceActionResult >& result) = 0;
};

class InvokeNotificationActionCallbackIF {
public:
    virtual ~InvokeNotificationActionCallbackIF() {}

    virtual void onInvokeNotificationActionError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< InvokeNotificationActionError >& error) = 0;

    virtual void onInvokeNotificationActionResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< InvokeNotificationActionResult >& result) = 0;
};

class LaunchAppCallbackIF {
public:
    virtual ~LaunchAppCallbackIF() {}

    virtual void onLaunchAppError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< LaunchAppError >& error) = 0;

    virtual void onLaunchAppResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< LaunchAppResult >& result) = 0;
};

class MLServerKeyCapabilitiesCallbackIF {
public:
    virtual ~MLServerKeyCapabilitiesCallbackIF() {}

    virtual void onMLServerKeyCapabilitiesError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MLServerKeyCapabilitiesError >& error) = 0;

    virtual void onMLServerKeyCapabilitiesStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MLServerKeyCapabilitiesStatus >& status) = 0;
};

class MLTurnByTurnInfoCallbackIF {
public:
    virtual ~MLTurnByTurnInfoCallbackIF() {}

    virtual void onMLTurnByTurnInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MLTurnByTurnInfoError >& error) = 0;

    virtual void onMLTurnByTurnInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MLTurnByTurnInfoStatus >& status) = 0;
};

class MediaPlayBackTimeCallbackIF {
public:
    virtual ~MediaPlayBackTimeCallbackIF() {}

    virtual void onMediaPlayBackTimeError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MediaPlayBackTimeError >& error) = 0;

    virtual void onMediaPlayBackTimeStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MediaPlayBackTimeStatus >& status) = 0;
};

class MySPINBluetoothVoiceRecInfoCallbackIF {
public:
    virtual ~MySPINBluetoothVoiceRecInfoCallbackIF() {}

    virtual void onMySPINBluetoothVoiceRecInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MySPINBluetoothVoiceRecInfoError >& error) = 0;

    virtual void onMySPINBluetoothVoiceRecInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< MySPINBluetoothVoiceRecInfoStatus >& status) = 0;
};

class NavigationNextTurnDataCallbackIF {
public:
    virtual ~NavigationNextTurnDataCallbackIF() {}

    virtual void onNavigationNextTurnDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NavigationNextTurnDataError >& error) = 0;

    virtual void onNavigationNextTurnDataStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NavigationNextTurnDataStatus >& status) = 0;
};

class NavigationNextTurnDistanceDataCallbackIF {
public:
    virtual ~NavigationNextTurnDistanceDataCallbackIF() {}

    virtual void onNavigationNextTurnDistanceDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NavigationNextTurnDistanceDataError >& error) = 0;

    virtual void onNavigationNextTurnDistanceDataStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NavigationNextTurnDistanceDataStatus >& status) = 0;
};

class NavigationStatusInfoCallbackIF {
public:
    virtual ~NavigationStatusInfoCallbackIF() {}

    virtual void onNavigationStatusInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NavigationStatusInfoError >& error) = 0;

    virtual void onNavigationStatusInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NavigationStatusInfoStatus >& status) = 0;
};

class NotificationInfoCallbackIF {
public:
    virtual ~NotificationInfoCallbackIF() {}

    virtual void onNotificationInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NotificationInfoError >& error) = 0;

    virtual void onNotificationInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< NotificationInfoStatus >& status) = 0;
};

class ProjectedVideoInfoCallbackIF {
public:
    virtual ~ProjectedVideoInfoCallbackIF() {}

    virtual void onProjectedVideoInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ProjectedVideoInfoError >& error) = 0;

    virtual void onProjectedVideoInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ProjectedVideoInfoStatus >& status) = 0;
};

class ProjectionDeviceAuthorizationCallbackIF {
public:
    virtual ~ProjectionDeviceAuthorizationCallbackIF() {}

    virtual void onProjectionDeviceAuthorizationError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ProjectionDeviceAuthorizationError >& error) = 0;

    virtual void onProjectionDeviceAuthorizationStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< ProjectionDeviceAuthorizationStatus >& status) = 0;
};

class RegisterRouteGuidanceDisplayConfigurationCallbackIF {
public:
    virtual ~RegisterRouteGuidanceDisplayConfigurationCallbackIF() {}

    virtual void onRegisterRouteGuidanceDisplayConfigurationError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< RegisterRouteGuidanceDisplayConfigurationError >& error) = 0;

    virtual void onRegisterRouteGuidanceDisplayConfigurationResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< RegisterRouteGuidanceDisplayConfigurationResult >& result) = 0;
};

class RelativelyActiveMediaAppCallbackIF {
public:
    virtual ~RelativelyActiveMediaAppCallbackIF() {}

    virtual void onRelativelyActiveMediaAppError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< RelativelyActiveMediaAppError >& error) = 0;

    virtual void onRelativelyActiveMediaAppStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< RelativelyActiveMediaAppStatus >& status) = 0;
};

class RotaryControllerEventCallbackIF {
public:
    virtual ~RotaryControllerEventCallbackIF() {}

    virtual void onRotaryControllerEventError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< RotaryControllerEventError >& error) = 0;

    virtual void onRotaryControllerEventResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< RotaryControllerEventResult >& result) = 0;
};

class SelectDeviceCallbackIF {
public:
    virtual ~SelectDeviceCallbackIF() {}

    virtual void onSelectDeviceError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SelectDeviceError >& error) = 0;

    virtual void onSelectDeviceResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SelectDeviceResult >& result) = 0;
};

class SendAmbientColourCallbackIF {
public:
    virtual ~SendAmbientColourCallbackIF() {}

    virtual void onSendAmbientColourError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendAmbientColourError >& error) = 0;

    virtual void onSendAmbientColourResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendAmbientColourResult >& result) = 0;
};

class SendKeyEventCallbackIF {
public:
    virtual ~SendKeyEventCallbackIF() {}

    virtual void onSendKeyEventError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendKeyEventError >& error) = 0;

    virtual void onSendKeyEventResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendKeyEventResult >& result) = 0;
};

class SendLanguageSettingCallbackIF {
public:
    virtual ~SendLanguageSettingCallbackIF() {}

    virtual void onSendLanguageSettingError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendLanguageSettingError >& error) = 0;

    virtual void onSendLanguageSettingResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendLanguageSettingResult >& result) = 0;
};

class SendTouchEventCallbackIF {
public:
    virtual ~SendTouchEventCallbackIF() {}

    virtual void onSendTouchEventError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendTouchEventError >& error) = 0;

    virtual void onSendTouchEventResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendTouchEventResult >& result) = 0;
};

class SendVehiclePowerModeStateCallbackIF {
public:
    virtual ~SendVehiclePowerModeStateCallbackIF() {}

    virtual void onSendVehiclePowerModeStateError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendVehiclePowerModeStateError >& error) = 0;

    virtual void onSendVehiclePowerModeStateResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SendVehiclePowerModeStateResult >& result) = 0;
};

class SessionStatusInfoCallbackIF {
public:
    virtual ~SessionStatusInfoCallbackIF() {}

    virtual void onSessionStatusInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SessionStatusInfoError >& error) = 0;

    virtual void onSessionStatusInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SessionStatusInfoStatus >& status) = 0;
};

class SetAccessoryAudioContextCallbackIF {
public:
    virtual ~SetAccessoryAudioContextCallbackIF() {}

    virtual void onSetAccessoryAudioContextError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAccessoryAudioContextError >& error) = 0;

    virtual void onSetAccessoryAudioContextResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAccessoryAudioContextResult >& result) = 0;
};

class SetAccessoryDisplayContextCallbackIF {
public:
    virtual ~SetAccessoryDisplayContextCallbackIF() {}

    virtual void onSetAccessoryDisplayContextError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAccessoryDisplayContextError >& error) = 0;

    virtual void onSetAccessoryDisplayContextResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAccessoryDisplayContextResult >& result) = 0;
};

class SetAppIconAttributesCallbackIF {
public:
    virtual ~SetAppIconAttributesCallbackIF() {}

    virtual void onSetAppIconAttributesError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAppIconAttributesError >& error) = 0;

    virtual void onSetAppIconAttributesResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAppIconAttributesResult >& result) = 0;
};

class SetAudioBlockingModeCallbackIF {
public:
    virtual ~SetAudioBlockingModeCallbackIF() {}

    virtual void onSetAudioBlockingModeError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAudioBlockingModeError >& error) = 0;

    virtual void onSetAudioBlockingModeResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetAudioBlockingModeResult >& result) = 0;
};

class SetClientCapabilitiesCallbackIF {
public:
    virtual ~SetClientCapabilitiesCallbackIF() {}

    virtual void onSetClientCapabilitiesError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetClientCapabilitiesError >& error) = 0;

    virtual void onSetClientCapabilitiesResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetClientCapabilitiesResult >& result) = 0;
};

class SetDeviceSelectionModeCallbackIF {
public:
    virtual ~SetDeviceSelectionModeCallbackIF() {}

    virtual void onSetDeviceSelectionModeError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetDeviceSelectionModeError >& error) = 0;

    virtual void onSetDeviceSelectionModeResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetDeviceSelectionModeResult >& result) = 0;
};

class SetDeviceUsagePreferenceCallbackIF {
public:
    virtual ~SetDeviceUsagePreferenceCallbackIF() {}

    virtual void onSetDeviceUsagePreferenceError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetDeviceUsagePreferenceError >& error) = 0;

    virtual void onSetDeviceUsagePreferenceResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetDeviceUsagePreferenceResult >& result) = 0;
};

class SetDisplayAttributesCallbackIF {
public:
    virtual ~SetDisplayAttributesCallbackIF() {}

    virtual void onSetDisplayAttributesError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetDisplayAttributesError >& error) = 0;

    virtual void onSetDisplayAttributesResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetDisplayAttributesResult >& result) = 0;
};

class SetETCStatusCallbackIF {
public:
    virtual ~SetETCStatusCallbackIF() {}

    virtual void onSetETCStatusError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetETCStatusError >& error) = 0;

    virtual void onSetETCStatusResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetETCStatusResult >& result) = 0;
};

class SetEnvironmentDataCallbackIF {
public:
    virtual ~SetEnvironmentDataCallbackIF() {}

    virtual void onSetEnvironmentDataError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetEnvironmentDataError >& error) = 0;

    virtual void onSetEnvironmentDataResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetEnvironmentDataResult >& result) = 0;
};

class SetFeatureRestrictionsCallbackIF {
public:
    virtual ~SetFeatureRestrictionsCallbackIF() {}

    virtual void onSetFeatureRestrictionsError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFeatureRestrictionsError >& error) = 0;

    virtual void onSetFeatureRestrictionsResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFeatureRestrictionsResult >& result) = 0;
};

class SetMLNotificationEnabledInfoCallbackIF {
public:
    virtual ~SetMLNotificationEnabledInfoCallbackIF() {}

    virtual void onSetMLNotificationEnabledInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetMLNotificationEnabledInfoError >& error) = 0;

    virtual void onSetMLNotificationEnabledInfoResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetMLNotificationEnabledInfoResult >& result) = 0;
};

class SetOrientationModeCallbackIF {
public:
    virtual ~SetOrientationModeCallbackIF() {}

    virtual void onSetOrientationModeError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetOrientationModeError >& error) = 0;

    virtual void onSetOrientationModeResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetOrientationModeResult >& result) = 0;
};

class SetRegionCallbackIF {
public:
    virtual ~SetRegionCallbackIF() {}

    virtual void onSetRegionError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetRegionError >& error) = 0;

    virtual void onSetRegionResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetRegionResult >& result) = 0;
};

class SetScreenSizeCallbackIF {
public:
    virtual ~SetScreenSizeCallbackIF() {}

    virtual void onSetScreenSizeError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetScreenSizeError >& error) = 0;

    virtual void onSetScreenSizeResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetScreenSizeResult >& result) = 0;
};

class SetTechnologyPreferenceCallbackIF {
public:
    virtual ~SetTechnologyPreferenceCallbackIF() {}

    virtual void onSetTechnologyPreferenceError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetTechnologyPreferenceError >& error) = 0;

    virtual void onSetTechnologyPreferenceResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetTechnologyPreferenceResult >& result) = 0;
};

class SetVehicleBTAddressCallbackIF {
public:
    virtual ~SetVehicleBTAddressCallbackIF() {}

    virtual void onSetVehicleBTAddressError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleBTAddressError >& error) = 0;

    virtual void onSetVehicleBTAddressResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleBTAddressResult >& result) = 0;
};

class SetVehicleConfigurationCallbackIF {
public:
    virtual ~SetVehicleConfigurationCallbackIF() {}

    virtual void onSetVehicleConfigurationError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleConfigurationError >& error) = 0;

    virtual void onSetVehicleConfigurationResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleConfigurationResult >& result) = 0;
};

class SetVehicleManufacturerInformationCallbackIF {
public:
    virtual ~SetVehicleManufacturerInformationCallbackIF() {}

    virtual void onSetVehicleManufacturerInformationError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleManufacturerInformationError >& error) = 0;

    virtual void onSetVehicleManufacturerInformationResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleManufacturerInformationResult >& result) = 0;
};

class SetVehicleMovementStateCallbackIF {
public:
    virtual ~SetVehicleMovementStateCallbackIF() {}

    virtual void onSetVehicleMovementStateError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleMovementStateError >& error) = 0;

    virtual void onSetVehicleMovementStateResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVehicleMovementStateResult >& result) = 0;
};

class SetVideoBlockingModeCallbackIF {
public:
    virtual ~SetVideoBlockingModeCallbackIF() {}

    virtual void onSetVideoBlockingModeError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVideoBlockingModeError >& error) = 0;

    virtual void onSetVideoBlockingModeResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVideoBlockingModeResult >& result) = 0;
};

class StartRouteGuidanceUpdatesCallbackIF {
public:
    virtual ~StartRouteGuidanceUpdatesCallbackIF() {}

    virtual void onStartRouteGuidanceUpdatesError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< StartRouteGuidanceUpdatesError >& error) = 0;

    virtual void onStartRouteGuidanceUpdatesResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< StartRouteGuidanceUpdatesResult >& result) = 0;
};

class StopRouteGuidanceUpdatesCallbackIF {
public:
    virtual ~StopRouteGuidanceUpdatesCallbackIF() {}

    virtual void onStopRouteGuidanceUpdatesError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< StopRouteGuidanceUpdatesError >& error) = 0;

    virtual void onStopRouteGuidanceUpdatesResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< StopRouteGuidanceUpdatesResult >& result) = 0;
};

class TechnologySelectionCallbackIF {
public:
    virtual ~TechnologySelectionCallbackIF() {}

    virtual void onTechnologySelectionError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< TechnologySelectionError >& error) = 0;

    virtual void onTechnologySelectionStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< TechnologySelectionStatus >& status) = 0;
};

class TerminateAppCallbackIF {
public:
    virtual ~TerminateAppCallbackIF() {}

    virtual void onTerminateAppError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< TerminateAppError >& error) = 0;

    virtual void onTerminateAppResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< TerminateAppResult >& result) = 0;
};

class TurnByTurnInfoCallbackIF {
public:
    virtual ~TurnByTurnInfoCallbackIF() {}

    virtual void onTurnByTurnInfoError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< TurnByTurnInfoError >& error) = 0;

    virtual void onTurnByTurnInfoStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< TurnByTurnInfoStatus >& status) = 0;
};

class VehicleMechanicalSpeedCallbackIF {
public:
    virtual ~VehicleMechanicalSpeedCallbackIF() {}

    virtual void onVehicleMechanicalSpeedError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< VehicleMechanicalSpeedError >& error) = 0;

    virtual void onVehicleMechanicalSpeedResult(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< VehicleMechanicalSpeedResult >& result) = 0;
};

class WiFiCredentialsCallbackIF {
public:
    virtual ~WiFiCredentialsCallbackIF() {}

    virtual void onWiFiCredentialsError(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< WiFiCredentialsError >& error) = 0;

    virtual void onWiFiCredentialsStatus(const ::boost::shared_ptr< Smartphoneint_main_fiProxy >& proxy, const ::boost::shared_ptr< WiFiCredentialsStatus >& status) = 0;
};

class Smartphoneint_main_fiProxyCallback;

/**
 * Smartphoneint_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'smartphoneint_main_fi' (specified in file
 * smartphoneint_main_fi.xml).
 *
 * CCA Functional Interface 'smartphoneint_main_fi'
 *
 * Fullname: Smart Phone Integration (SPI) Application Functional Interface
 *
 * Version: $Revision:   4.2  $
 *
 * Author: Dhiraj Asopa (RBEI/ECO21)
 *
 * Date: $Date:  DEC 06 2017   $
 *
 * Department: RBEI/ECO
 *
 * Title: smartphoneint_main_fi
 *
 * <b>Description of 'smartphoneint_main_fi':</b>
 *
 * ..
 */
class Smartphoneint_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Smartphoneint_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Smartphoneint_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Smartphoneint_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Smartphoneint_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Smartphoneint_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Smartphoneint_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Smartphoneint_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Smartphoneint_main_fiProxy();

    // Method 'GetDeviceInfoList'

    /**
     * Call the method 'GetDeviceInfoList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetDeviceInfoList'</b>:
     *
     * It provides a list of connected devices and device history with the information for each device.
     * This method is deprecated instead use GetDeviceList.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDeviceInfoListStart(GetDeviceInfoListCallbackIF& cb);

    // Method 'SelectDevice'

    /**
     * Call the method 'SelectDevice'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SelectDevice'</b>:
     *
     * Scope: ML, Carplay, Android Auto, Myspin and Carlife
     * It provides a mechanism to select a device from SPI device List to establish a session.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Uniquely identifies the target Device.
     *
     * @param DeviceConnectionType Identifies the Connection Type.
     *
     * @param DeviceConnectionReq Identifies the Connection Request.
     *
     * @param DAPUsage Scope: Only for ML
     * Identifies Usage of DAP for the selected Mirror Link device. This value is not considered for de-selection of device.
     *
     * @param CDBUsage Scope: Only for ML
     * Identifies Usage of CDB for the selected Mirror Link device. This value is not considered for de-selection of device.
     *
     * @param DeviceCategory Device category Information. Informs the technology to which device has to be activated/selected.
     *
     * @param SelectionType Informs if the device selection/ deselection is done based on user action or was internally triggered by HMI
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSelectDeviceStart(SelectDeviceCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_DeviceConnectionType deviceConnectionType, ::smartphoneint_main_fi_types::T_e8_DeviceConnectionReq deviceConnectionReq, ::smartphoneint_main_fi_types::T_e8_EnabledInfo dAPUsage, ::smartphoneint_main_fi_types::T_e8_EnabledInfo cDBUsage, ::smartphoneint_main_fi_types::T_e8_DeviceCategory deviceCategory, ::smartphoneint_main_fi_types::T_e8_SelectionType selectionType);

    // Method 'LaunchApp'

    /**
     * Call the method 'LaunchApp'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'LaunchApp'</b>:
     *
     * Scope: ML, Carplay, Android Auto, Myspin and Carlife
     * It launches a remote application from the selected device
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Uniquely identifies the target Device.
     *
     * @param DeviceCategory Device Type Information.
     *
     * @param AppHandle Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @param DiPOAppType Identifies the application to be launched on a DiPO device. This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param TelephoneNumber Number to be dialed if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to NULL, zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
     *
     * @param EcnrSetting Sets voice or server echo cancellation and noise reduction settings if the DiPO application to be launched is a phone application. If not valid to be used, this will be set to ECNR_NOCHANGE.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLaunchAppStart(LaunchAppCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_DeviceCategory deviceCategory, uint32 appHandle, ::smartphoneint_main_fi_types::T_e8_DiPOAppType diPOAppType, const ::std::string& telephoneNumber, ::smartphoneint_main_fi_types::T_e8_EcnrSetting ecnrSetting);

    // Method 'TerminateApp'

    /**
     * Call the method 'TerminateApp'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'TerminateApp'</b>:
     *
     * Scope: Only for ML
     * It terminates the remote application running on the Mirror Link device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Uniquely identifies the target Device.
     *
     * @param AppHandle Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTerminateAppStart(TerminateAppCallbackIF& cb, uint32 deviceHandle, uint32 appHandle);

    // Method 'GetAppList'

    /**
     * Call the method 'GetAppList'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetAppList'</b>:
     *
     * Scope: Only for ML
     * It retrieves list of supported applications for the Device Handle provided.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Uniquely identifies the target Device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAppListStart(GetAppListCallbackIF& cb, uint32 deviceHandle);

    // Method 'GetAppIconData'

    /**
     * Call the method 'GetAppIconData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetAppIconData'</b>:
     *
     * Scope: Only for ML
     * It retrieves icon data referenced by the icon URL provided in the application list.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AppIconURL Application Icon URL for which the icon data is required.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetAppIconDataStart(GetAppIconDataCallbackIF& cb, const ::std::string& appIconURL);

    // Method 'SetAppIconAttributes'

    /**
     * Call the method 'SetAppIconAttributes'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetAppIconAttributes'</b>:
     *
     * Scope: Only for ML
     * It sets application icon attributes for retrieval of application icons for a Mirror Link device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Handle uniquely identifies a device.
     *
     * @param AppHandle Uniquely identifies an Application on the target Device. This value will be obtained from AppList Interface.
     *
     * @param IconAttributes Provides the Icon details.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAppIconAttributesStart(SetAppIconAttributesCallbackIF& cb, uint32 deviceHandle, uint32 appHandle, const ::smartphoneint_main_fi_types::T_IconAttributes& iconAttributes);

    // Method 'SetDeviceUsagePreference'

    /**
     * Call the method 'SetDeviceUsagePreference'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetDeviceUsagePreference'</b>:
     *
     * Scope: ML, Carplay, Android Auto, Myspin and Carlife
     * Interface to set the preference for the usage of the connected device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function sets the overall preference usage for Mirror Link/DiPO/Android Auto.
     *
     * @param DeviceCategory Provides Device Type Information.
     *
     * @param EnabledInfo Provides Enable Information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDeviceUsagePreferenceStart(SetDeviceUsagePreferenceCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_DeviceCategory deviceCategory, ::smartphoneint_main_fi_types::T_e8_EnabledInfo enabledInfo);

    // Method 'SetMLNotificationEnabledInfo'

    /**
     * Call the method 'SetMLNotificationEnabledInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetMLNotificationEnabledInfo'</b>:
     *
     * Scope: Only for ML
     * Interface to set the device notification preference for applications.
     * If notification for all the applications has to be:
     * Enabled - Set NumNotificationEnableList to 0xFF and NotificationEnableList should be empty.
     * Disabled - Set NumNotificationEnableList to 0x00 and NotificationEnableList should be empty.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Handle uniquely identifies a device.
     *
     * @param NumNotificationEnableList Total number of records in NotificationEnableList.
     *
     * @param NotificationEnableList List of NotificationEnable records.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMLNotificationEnabledInfoStart(SetMLNotificationEnabledInfoCallbackIF& cb, uint32 deviceHandle, uint16 numNotificationEnableList, const ::std::vector< ::smartphoneint_main_fi_types::T_NotificationEnable >& notificationEnableList);

    // Method 'InvokeNotificationAction'

    /**
     * Call the method 'InvokeNotificationAction'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'InvokeNotificationAction'</b>:
     *
     * Scope: Only ML
     * Interface to invoke the respective action for the received Notification Event.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Handle uniquely identifies a device.
     *
     * @param AppHandle Handle uniquely identifies an application on the device.
     *
     * @param NotificationID Notification Identifier.
     *
     * @param NotificationActionID Notification action Identifier.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInvokeNotificationActionStart(InvokeNotificationActionCallbackIF& cb, uint32 deviceHandle, uint32 appHandle, uint16 notificationID, uint16 notificationActionID);

    // Method 'GetVideoSettings'

    /**
     * Call the method 'GetVideoSettings'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetVideoSettings'</b>:
     *
     * It provides current Video Settings.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetVideoSettingsStart(GetVideoSettingsCallbackIF& cb, uint32 deviceHandle);

    // Method 'SetOrientationMode'

    /**
     * Call the method 'SetOrientationMode'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetOrientationMode'</b>:
     *
     * Interface to set the orientation mode of the projected display.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param OrientationMode Orientation Mode Value.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetOrientationModeStart(SetOrientationModeCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_OrientationMode orientationMode);

    // Method 'SetScreenSize'

    /**
     * Call the method 'SetScreenSize'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetScreenSize'</b>:
     *
     * Interface to set the screen size of Head Unit.
     * -- This method is deprecated instead use SetDisplayAttributes.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ScreenAttributes Screen Setting attributes.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetScreenSizeStart(SetScreenSizeCallbackIF& cb, const ::smartphoneint_main_fi_types::T_ScreenAttributes& screenAttributes);

    // Method 'SetVideoBlockingMode'

    /**
     * Call the method 'SetVideoBlockingMode'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetVideoBlockingMode'</b>:
     *
     * Scope: Only for ML, for other technologies use SetAccessoryDisplayContext
     * Interface to set the display blocking mode.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param BlockingMode Identifies the Blocking Mode.
     *
     * @param VideoBlockingReason Identifies the reason for Video Blocking
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVideoBlockingModeStart(SetVideoBlockingModeCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_BlockingMode blockingMode, ::smartphoneint_main_fi_types::T_e8_VideoBlockingReason videoBlockingReason);

    // Method 'SetAudioBlockingMode'

    /**
     * Call the method 'SetAudioBlockingMode'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetAudioBlockingMode'</b>:
     *
     * Scope: Only for ML
     * Interface to set the audio blocking mode.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param GlobalMuteEnable Identifies whether Global mute is enabled or not
     *
     * @param MediaAudioBlockingEnable Identifies whether Media Audio Blocking is enabled or not
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAudioBlockingModeStart(SetAudioBlockingModeCallbackIF& cb, bool globalMuteEnable, bool mediaAudioBlockingEnable);

    // Method 'SetVehicleConfiguration'

    /**
     * Call the method 'SetVehicleConfiguration'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetVehicleConfiguration'</b>:
     *
     * Scope: ML, Carplay, Android Auto, Myspin and Carlife
     * Interface to set the Vehicle configurations.
     * Use method SetVehicleMovementState to provide Park/Drive Mode Info.
     * The Drive or park mode information is deprecated from T_e8_Vehicle_Configuration.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VehicleConfiguration Identifies the Vehicle configuration.It contains DAY or NIGHT MODE, and Right/left hand drive.
     * currently all these parameters are enabled by default.
     *
     * @param SetConfiguration Identifies whether to enable/disable vehicle configuration.
     * For currently supported configurations it is unused.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVehicleConfigurationStart(SetVehicleConfigurationCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_Vehicle_Configuration vehicleConfiguration, bool setConfiguration);

    // Method 'SendTouchEvent'

    /**
     * Call the method 'SendTouchEvent'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendTouchEvent'</b>:
     *
     * Interface to set the Touch or Pointer events.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param TouchData Contains Touch information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendTouchEventStart(SendTouchEventCallbackIF& cb, uint32 deviceHandle, const ::smartphoneint_main_fi_types::T_TouchData& touchData);

    // Method 'SendKeyEvent'

    /**
     * Call the method 'SendKeyEvent'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SendKeyEvent'</b>:
     *
     * Interface to set the Touch or Pointer events.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param KeyMode Key Mode Value.
     *
     * @param KeyCode Key Code Value.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendKeyEventStart(SendKeyEventCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_KeyMode keyMode, ::smartphoneint_main_fi_types::T_e32_KeyCode keyCode);

    // Method 'SetClientCapabilities'

    /**
     * Call the method 'SetClientCapabilities'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetClientCapabilities'</b>:
     *
     * Scope : only for ML
     * Interface to set client capabilities.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ClientCapabilities Capabilities of the client.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetClientCapabilitiesStart(SetClientCapabilitiesCallbackIF& cb, const ::smartphoneint_main_fi_types::T_ClientCapabilities& clientCapabilities);

    // Method 'AccessoryDisplayContext'

    /**
     * Call the method 'AccessoryDisplayContext'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AccessoryDisplayContext'</b>:
     *
     * This interface is used by the client to inform the DiPO device about its current display context.
     * --This method is deprecated, instead use SetAccessoryDisplayContext
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param DisplayFlag TRUE - Start Native display Projection( Projection screen to Native screen), FALSE - Stop Native Display Projection(Native screen to Projection screen ) .
     *
     * @param DisplayContext Display context of the client (e.g. HMI).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccessoryDisplayContextStart(AccessoryDisplayContextCallbackIF& cb, uint32 deviceHandle, bool displayFlag, ::smartphoneint_main_fi_types::T_e8_DisplayContext displayContext);

    // Method 'GetDeviceUsagePreference'

    /**
     * Call the method 'GetDeviceUsagePreference'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetDeviceUsagePreference'</b>:
     *
     * Scope: ML, Carplay, Android Auto, Myspin and Carlife
     * Interface to get the preference for the usage of the connected devices device during startup.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference usage for Mirror Link/DiPO.
     *
     * @param DeviceCategory Provides Device Type Information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDeviceUsagePreferenceStart(GetDeviceUsagePreferenceCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_DeviceCategory deviceCategory);

    // Method 'SetVehicleBTAddress'

    /**
     * Call the method 'SetVehicleBTAddress'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetVehicleBTAddress'</b>:
     *
     * Interface to set the vehicle Bluetooth address.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param BTAddress Identifies Vehicle BT Address. It is represented by 12 hexadecimal characters.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVehicleBTAddressStart(SetVehicleBTAddressCallbackIF& cb, const ::std::string& bTAddress);

    // Method 'InvokeBluetoothDeviceAction'

    /**
     * Call the method 'InvokeBluetoothDeviceAction'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'InvokeBluetoothDeviceAction'</b>:
     *
     * Interface to inform SPI about user's selected action for a device switch operation between a BT and a Projection device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param BluetoothDeviceHandle Identifies a BT device from BT Settings device list.
     *
     * @param ProjectionDeviceHandle Identifies a Projection device from SPI device list.
     *
     * @param BTChangeInfo Identifies the user selected BT device change.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInvokeBluetoothDeviceActionStart(InvokeBluetoothDeviceActionCallbackIF& cb, uint32 bluetoothDeviceHandle, uint32 projectionDeviceHandle, ::smartphoneint_main_fi_types::T_e8_BTChangeInfo bTChangeInfo);

    // Method 'AccessoryAudioContext'

    /**
     * Call the method 'AccessoryAudioContext'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AccessoryAudioContext'</b>:
     *
     * This interface is used by the client to inform the DiPO device about its current Audio context.
     * This interface is deprecated. Use SetAccessoryAudioContext to provide Audio context information.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param AudioFlag TRUE - Accessory wants Audio resource, FALSE - Phone can take Audio resource.
     *
     * @param AudioContext Audio context of the client (e.g. HMI).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccessoryAudioContextStart(AccessoryAudioContextCallbackIF& cb, uint32 deviceHandle, bool audioFlag, ::smartphoneint_main_fi_types::T_e8_AudioContext audioContext);

    // Method 'AccessoryAppState'

    /**
     * Call the method 'AccessoryAppState'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AccessoryAppState'</b>:
     *
     * Scope: Dipo- for speech, Phone and Navigation states, AAP - only Navigation state
     * This interface is used by the client to inform to the connected device about the HU application states
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AppStateSpeech specifies the different speech operation.
     * SPI_APP_STATE_SPEECH_NA = No speech session active.Hence no app state for speech
     * SPI_APP_STATE_SPEECH_NONE = The state is send to inform that an already active speech state is terminated.
     * SPI_APP_STATE_SPEECH_SPEAKING = The app device is speaking to the user.
     * SPI_APP_STATE_SPEECH_RECOGNISING = The device is recording audio to recognise speech from the user.
     *
     * @param AppStatePhone specifies the different Phone State.
     * SPI_APP_STATE_PHONE_NA = No phone call is active.Hence no app state for phone
     * SPI_APP_STATE_PHONE_ACTIVE = Phone call is active.
     * SPI_APP_STATE_PHONE_NOTACTIVE = The state is send to inform that an already active phone call has ended. ie,an app state change from active to not active.
     *
     * @param AppStateNavigation specifies the different Navigation App State.
     * SPI_APP_STATE_NAV_NA = No navigation APP is active.Hence no app state for navigation
     * SPI_APP_STATE_NAV_ACTIVE = Navigation APP is active.
     * SPI_APP_STATE_NAV_NOTACTIVE = The state is send to inform that an already active TBT navigation has ended. ie,an app state change from active to not active.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccessoryAppStateStart(AccessoryAppStateCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_SpeechAppState appStateSpeech, ::smartphoneint_main_fi_types::T_e8_PhoneAppState appStatePhone, ::smartphoneint_main_fi_types::T_e8_NavigationAppState appStateNavigation);

    // Method 'SetRegion'

    /**
     * Call the method 'SetRegion'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'SetRegion'</b>:
     *
     * Interface to inform SPI about which region guidelines should be followed to check the application
     * certification.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Region Identifies the vehicle region.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRegionStart(SetRegionCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_Region region);

    // Method 'DiPORoleSwitchRequired'

    /**
     * Call the method 'DiPORoleSwitchRequired'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DiPORoleSwitchRequired'</b>:
     *
     * Scope : Carplay, Carlife, Myspin
     * Interface to check whether an automatic role switch is required for the currently connected apple device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8DeviceTag Unique identifier of the device.
     *
     * @param USBSerialNumber USB Serial Number of the device.
     *
     * @param DeviceCarplayCapability Whether currently connected apple device is capable of carPlay.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPORoleSwitchRequiredStart(DiPORoleSwitchRequiredCallbackIF& cb, uint8 u8DeviceTag, const ::std::string& uSBSerialNumber, bool deviceCarplayCapability);

    // Method 'SetAccessoryDisplayContext'

    /**
     * Call the method 'SetAccessoryDisplayContext'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetAccessoryDisplayContext'</b>:
     *
     * Scope : ML, carPlay, AAP, MySPIN, Carlife.
     * This interface is used by the client to inform the projection device about Head Units current display context. And whenever Head Unit wants to request for the display resource.
     * The video resource management can either be done by HMI(SPI's client) or by SPI service. Normally it is SPI service responsibility.
     * If for what ever reason, HMI have to do video resource  management, then HMI should populate parameter "DisplayConstraintInfo"
     * Otherwise, if it is SPI service responsibility, HMI should populate parameter "DisplayContextInfo".
     * HMI should populate parameter "ContextResponsibility", based on which SPI service will know whether it is SPI or HMI responsibility.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param DisplayContextInfo Display context info. This information should be populated by HMI, if handling video resource management is SPI responsibility.
     *
     * @param DisplayConstraintInfo Display Resource ownership info. This information should be populated by HMI, if handling video resource management is HMI responsibility.
     * For carPlay devices: The information will be directly forwarded to Phone without any interpretation.
     * For Android devices: There are two possible cases for using this.
     * 1) When HMI needs or return the display resource. This can be informed to SPI by populating below parameter, other parameters to be populated to NA
     * HMI request for display resource (Projection device to HMI) : 										                                     DisplayConstraintInfo.TransferType = TRANSFER_TYPE_TAKE or TRANSFER_TYPE_BORROW
     * HMI releases the display resource ( HMI to projection device) : DisplayConstraintInfo.TransferType = TRANSFER_TYPE_UNTAKE or TRANSFER_TYPE_UNBORROW
     * 2) HMI should always update the below parameter based on its current display context. This information will be used by SPI to take a decision whenever
     * Phone request for display. If Take/Borrow constraint set by HMI is TRANSFER_CONSTRAINT_NEVER. SPI service will deny the display resource.
     * Otherwise if Take/Borrow constraint is TRANSFER_CONSTRAINT_ANYTIME or TRANSFER_CONSTRAINT_USERINITIATED, SPI service will grant the display to projection device.
     * DisplayConstraintInfo.TransferType = TAKE/BORROW (TAKE/BORROW- HU needs display), UNTAKE - No effect from SPI side, HMI should do launch app. UNBORROW: SPI will release resource to Android device
     * DisplayConstraintInfo.TransferPriority = TRANSFER_PRIORITY_NA
     * DisplayConstraintInfo.TakeConstraint =  TRANSFER_CONSTRAINT_ANYTIME/TRANSFER_CONSTRAINT_USERINITIATED/TRANSFER_CONSTRAINT_NEVER
     * DisplayConstraintInfo.BorrowConstraint = TRANSFER_CONSTRAINT_ANYTIME/TRANSFER_CONSTRAINT_USERINITIATED/TRANSFER_CONSTRAINT_NEVER
     *
     * @param ContextResponsibility Identify the responsible component to handle the context mapping, .
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAccessoryDisplayContextStart(SetAccessoryDisplayContextCallbackIF& cb, uint32 deviceHandle, const ::smartphoneint_main_fi_types::T_AccessoryDisplayContext& displayContextInfo, const ::smartphoneint_main_fi_types::T_DisplayConstraint& displayConstraintInfo, ::smartphoneint_main_fi_types::T_e8_DisplayInfo contextResponsibility);

    // Method 'GetKeyIconData'

    /**
     * Call the method 'GetKeyIconData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetKeyIconData'</b>:
     *
     * Scope : Only for ML
     * It retrieves key icon data referenced by the icon URL provided in the XDeviceKeysList.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Uniquely identifies the target Device.
     *
     * @param KeyIconURL Key Icon URL for which the icon data is required.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetKeyIconDataStart(GetKeyIconDataCallbackIF& cb, uint32 deviceHandle, const ::std::string& keyIconURL);

    // Method 'SetDisplayAttributes'

    /**
     * Call the method 'SetDisplayAttributes'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetDisplayAttributes'</b>:
     *
     * Scope : ML, carPlay, AAP, MySPIN, Carlife.
     * Interface to set the different display attributes of the HU. Normally these setting can also be read by SPI through KDS/diagnosis.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DisplayAttributes Method to initiates setting the display attributes.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDisplayAttributesStart(SetDisplayAttributesCallbackIF& cb, const ::smartphoneint_main_fi_types::T_DisplayAttributes& displayAttributes);

    // Method 'RotaryControllerEvent'

    /**
     * Call the method 'RotaryControllerEvent'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RotaryControllerEvent'</b>:
     *
     * Interface to send Rotary Controller Events when any projection session is active.
     * It should be called with nonzero controller Delta Counts which indicate a movement of the rotary controller by the user.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param ControllerDeltaCounts Change in controller value counts from the last received faceplate input.
     * The value is +127 (CW)/-128 (CCW) delta counts which have been accumulated since the last time the change in this controller was reported
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRotaryControllerEventStart(RotaryControllerEventCallbackIF& cb, uint32 deviceHandle, int8 controllerDeltaCounts);

    // Method 'SetAccessoryAudioContext'

    /**
     * Call the method 'SetAccessoryAudioContext'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetAccessoryAudioContext'</b>:
     *
     * Scope : ML, carPlay, AAP, MySPIN, Carlife.
     * This interface is used by the HU to inform the projection device about its current Audio context.
     * If projection session is not active set the DeviceHandle to 0xFFFFFFFF.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param AudioContextInfo Provides a list of active audio channels at any instance
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetAccessoryAudioContextStart(SetAccessoryAudioContextCallbackIF& cb, uint32 deviceHandle, const ::std::vector< ::smartphoneint_main_fi_types::T_AccessoryAudioContext >& audioContextInfo);

    // Method 'SetVehicleMovementState'

    /**
     * Call the method 'SetVehicleMovementState'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetVehicleMovementState'</b>:
     *
     * This interface is used by the HU to inform the projection device about vehicle movement state.
     * Client should provide this information irrespective of projection session state.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ParkBrakeInfo Provides vehicle Handbrake is applied or not. This information will be sent directly to phone.
     *
     * @param GearInfo Provides Vehicle Gear status. This information will be sent directly to phone.
     *
     * @param VehicleState Provides Vehicle State(Park/Drive).
     * This information will be used by SPI to enable or disable the Phone usage restriction, when in drive or park mode.
     * E.g If projects wants to enable restriction in drive and only after crossing x speed. Then, HMI can send vehicle is in drive after crossing the x speed, so that the restriction is applied only after x speed, not just when vehicle is in drive mode.
     * The kind of restriction that will be applied when in drive or park mode can be set through method SetFeatureRestrictions.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVehicleMovementStateStart(SetVehicleMovementStateCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_ParkBrake parkBrakeInfo, ::smartphoneint_main_fi_types::T_e8_GearState gearInfo, ::smartphoneint_main_fi_types::T_e8_VehicleState vehicleState);

    // Method 'SetFeatureRestrictions'

    /**
     * Call the method 'SetFeatureRestrictions'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetFeatureRestrictions'</b>:
     *
     * This interface is used by the HU to inform the projection device the feature restrictions to be applied when vehicle is in Park/Drive Mode.
     * Client should set the restrictions as soon as SPI service is up and running.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceCategory Projection technology for which feature restrictions has to be applied.
     *
     * @param ParkModeRestrictionInfo This parameter says what features to be restricted when vehicle is in Park Mode.
     * This parameter is applicable for Android audio only. Restriction for carplay in park mode is not applicable.
     * And also for Mirror Link restriction is not possible through this interface, it is only based on the apps certification.
     *
     * @param DriveModeRestrictionInfo This parameter says what features to be restricted when vehicle is in Drive Mode.
     * For Mirror Link restriction is not possible through this interface, it is only based on the apps certification.
     * For CarPlay and Android Auto, it is based on the parameter value, see types "T_FeatureRestriction" for more info on what feature can be enabled or disable.
     *
     * @param GeneralRestrictionInfo This parameter says what features are to set as a part of general restrictions irrespective of gear status.
     * Values are in little endian format.
     *
     * Restrictions for AAP
     * 0 bit - Hide battery level(If the bit = true , battery level will not be displayed; if bit = false, battery level( is displayed)
     * 1 bit - Hide clock(If the bit = true , clock will not be displayed; if bit = false, clock is displayed)
     * 2 bit - Hide phone signal(If the bit = true , phone signal will not be displayed; if bit = false, phone signal is displayed)
     * 3 bit - BT limitation mode bit(If the bit = true , the bt pairing will be delayed until AOC is accepted; if bit = false ,the pairing is done without delay)
     * 4 Bit - ETC Feature - (If bit = 1, ETC(Electronic Toll Collection) Feature Enabled. Else If bit = 0 , ETC Feature is Disabled.)
     * All the other bits are not defined.
     *
     * Restrictions for CP
     * 0 bit - ETC feature  - (If bit = 1, ETC(Electronic Toll Collection) Feature Enabled. Else If bit = 0 , ETC Feature is Disabled.)
     * All the other bits are not defined.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFeatureRestrictionsStart(SetFeatureRestrictionsCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_DeviceCategory deviceCategory, const ::smartphoneint_main_fi_types::T_FeatureRestriction& parkModeRestrictionInfo, const ::smartphoneint_main_fi_types::T_FeatureRestriction& driveModeRestrictionInfo, uint16 generalRestrictionInfo);

    // Method 'VehicleMechanicalSpeed'

    /**
     * Call the method 'VehicleMechanicalSpeed'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'VehicleMechanicalSpeed'</b>:
     *
     * Scope: AAP, CarPlay, Carlife.
     * This interface is used by the client to update the vehicle mechanical speed that is derived from non GPS sources(i.e from wheels).
     * This data needs to be sent only when device is selected and speed data is changed, SPI will take care of sending the data at the required rate to the devices.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VehicleSpeed Vehicle speed in cm(centimeters)/sec.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVehicleMechanicalSpeedStart(VehicleMechanicalSpeedCallbackIF& cb, int32 vehicleSpeed);

    // Method 'SetVehicleManufacturerInformation'

    /**
     * Call the method 'SetVehicleManufacturerInformation'. This method sends
     * a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetVehicleManufacturerInformation'</b>:
     *
     * This interface is used by the client to update the various vehicle information.
     * Please note some information are mandatory that needs to be provided by the client.
     * Client should populate this information as soon as SPI service is available.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VehicleMake Its Mandatory. Vehicle manufacture name.
     *
     * @param VehicleModel Its Mandatory. Vehicle model, it changes based on vehicle variant
     *
     * @param VehicleModelYear Its Mandatory. Vehicle mode1 year, it is distinct from year of manufacturer
     *
     * @param VehicleHUSwVersion Its Mandatory.  Vehicle Head Unit software version
     *
     * @param VehicleHUHwVersion Its Optional.  Vehicle Head Unit Hardware version
     *
     * @param VehicleHUMake Vehicle's Head Unit Manufacture name.
     *
     * @param VehicleHUModel Vehicle's Head Unit Model name.
     *
     * @param VehicleHUSwBuild Vehicle's Head Unit software build
     *
     * @param DriverSideInfo Vehicle's Driver Side Information
     *
     * @param isNativeNavSupported Native Navigation Enabled Information
     *
     * @param OEMICONDetails OEMICON Information
     *
     * @param isRotaryCtrlSupported Rotary Control Supported Information
     *
     * @param FidelityType Information about HIGH Fidelity / LOW Fidelity
     *
     * @param SupportedSPITechnologiesInfo SPI Features Enabled - Values representing Technologies - BitWise Operation
     * MirrorLink = 1,CARPLAY=2,AndroidAuto=4, MySpIn=8,CARPLAYWIRELESS=16,AAPWIRELESS=32,CARLIFE = 64
     * For Example: If MirrorLink, Carplay and AndroidAuto to be Enabled - then set this field to 7 (that is mirrorlink -1, carplay-2 and androidauto - 4)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVehicleManufacturerInformationStart(SetVehicleManufacturerInformationCallbackIF& cb, const ::std::string& vehicleMake, const ::std::string& vehicleModel, const ::std::string& vehicleModelYear, const ::std::string& vehicleHUSwVersion, const ::std::string& vehicleHUHwVersion, const ::std::string& vehicleHUMake, const ::std::string& vehicleHUModel, const ::std::string& vehicleHUSwBuild, ::smartphoneint_main_fi_types::T_e8_Vehicle_Configuration driverSideInfo, bool isNativeNavSupported, const ::smartphoneint_main_fi_types::T_OEMICONDetails& oEMICONDetails, bool isRotaryCtrlSupported, ::smartphoneint_main_fi_types::T_e8_FidelityType fidelityType, uint16 supportedSPITechnologiesInfo);

    // Method 'SetEnvironmentData'

    /**
     * Call the method 'SetEnvironmentData'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetEnvironmentData'</b>:
     *
     * Scope : AAP
     * This method is used to update the Outside Temperature and the Barometric Pressure to the Phone.
     * HMI needs to update this when SPI process becomes active and whenever there is a change either in Temperature or Pressure.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param OutsideTemperature Outside Temperature value in Degree Celcius.
     *
     * @param ValidTemperature TRUE  - Valid temperature update.
     * FALSE - Invalid temperature update.
     *
     * @param BarometricPressure Barometric Pressure value in kPA.
     *
     * @param ValidPressure TRUE  - Valid pressure update.
     * FALSE - Invalid pressure update.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetEnvironmentDataStart(SetEnvironmentDataCallbackIF& cb, double outsideTemperature, bool validTemperature, double barometricPressure, bool validPressure);

    // Method 'GetMediaObjectAlbumArt'

    /**
     * Call the method 'GetMediaObjectAlbumArt'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetMediaObjectAlbumArt'</b>:
     *
     * Scope : Only for CarPlay.
     * For AAP, Carlife : It is populated as part of Applicationmetadata itself
     *
     * The GetMediaObjectAlbumArt method is called to retrieve the album art
     * image, if it exists, for a particular media object. The image is returned
     * in a MIME-typed image format and size of image will be as informed in Applicationmetadata.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param sAlbumArt Filename (URL) of the image to display for a given song
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetMediaObjectAlbumArtStart(GetMediaObjectAlbumArtCallbackIF& cb, uint32 deviceHandle, const ::std::string& sAlbumArt);

    // Method 'SetTechnologyPreference'

    /**
     * Call the method 'SetTechnologyPreference'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetTechnologyPreference'</b>:
     *
     * Scope: ML, Android Auto, Carlife.
     * This method is valid only if AutoSelect is enabled in SPI service (through policy), if it is not enabled this preference will not have any impact.
     * This interface can be used to set the SPI technology preference for the Mobile devices for successive connections,
     * if the device supports more than one SPI technology like Mirrorlink, Android Auto.
     * Based on this information, SPI service will decide(only if Auto select is enabled in SPI policy)to switch the device to particular technology and auto select, when the phone is connected to HMI. If preference order list is empty, than Android Auto will be first technology of preference.
     * Currently only first item in the list "PreferenceOrderList" is considered, if the selection fails than by default other technology would be preferred e.g If AAP is first preferred technology, if it fails than Mirror Link would be select.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function sets the overall preference for new SPI devices, there will not be any technology preference changes for known devices.
     * If the value is other the 0xFFFFFFFF, then that particular device technology preference would be changed.
     *
     * @param NumofPreferences Total number of preference in PreferenceOrderList. Deprecreated.
     *
     * @param PreferenceOrderList List of the SPI technologies in the preferred order. Only Top of list would be considered.
     *
     * @param DeviceType Device Type indicates the Smartphone platform(Apple, Android) type on which preference to be set
     * If the device handle is 0xFFFFFFF(overall setting), DeviceType must be  populated as AppleDevice/AndroidDevice. DeviceType unknown is ignored.
     * If the device handle is populated with a specific device ID(Per device setting), DeviceType is ignored.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetTechnologyPreferenceStart(SetTechnologyPreferenceCallbackIF& cb, uint32 deviceHandle, uint16 numofPreferences, const ::std::vector< ::smartphoneint_main_fi_types::T_e8_DeviceCategory >& preferenceOrderList, ::smartphoneint_main_fi_types::T_e8_DeviceType deviceType);

    // Method 'GetTechnologyPreference'

    /**
     * Call the method 'GetTechnologyPreference'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GetTechnologyPreference'</b>:
     *
     * Scope: ML, Android Auto, Carlife.
     * Interface to get the SPI technology preference last set. Can be used on start up to restore settings.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     * If the value is 0xFFFFFFFF, then this function gets the overall preference for new SPI devices, there will not be any technology preference changes for known devices.
     * If the value is other the 0xFFFFFFFF, then that particular device technology preference would be returned.
     *
     * @param DeviceType Device Type indicates the Smartphone platform(Apple, Android) type on which preference to be returned.
     * If the device handle is 0xFFFFFFF(overall setting), DeviceType must be  populated as AppleDevice/AndroidDevice. DeviceType unknown is ignored.
     * If the device handle is populated with a specific device ID(Per device setting), DeviceType is ignored.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTechnologyPreferenceStart(GetTechnologyPreferenceCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_DeviceType deviceType);

    // Method 'SetDeviceSelectionMode'

    /**
     * Call the method 'SetDeviceSelectionMode'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetDeviceSelectionMode'</b>:
     *
     * Interface to set the Device selection mode. Can be used to switch device between automatic and manual modes.
     * The selection mode will be applicable on successive device connections.
     * This value will be persistently stored by service.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceSelectionMode Determines the selection mode to be set
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetDeviceSelectionModeStart(SetDeviceSelectionModeCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_DeviceSelectionMode deviceSelectionMode);

    // Method 'GetSPIVersionInfo'

    /**
     * Call the method 'GetSPIVersionInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetSPIVersionInfo'</b>:
     *
     * Interface to get the SPI Version Info.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSPIVersionInfoStart(GetSPIVersionInfoCallbackIF& cb);

    // Method 'InitiateWirelessDiscovery'

    /**
     * Call the method 'InitiateWirelessDiscovery'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'InitiateWirelessDiscovery'</b>:
     *
     * Scope: Carplay over wireless for now.
     * Interface to initiate SPI wireless device discovery.
     * This is used to estbalish wireless session, if a valid device is available.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param BTMACAddress Unique ID of the device for which Bluetooth discovery should be started.
     *
     * @param Technology Determines the SPI Technology for which wireless discovey to be initiated.
     *
     * @param isKnownDevice Determines whether this request is for fresh device or known device.
     * TRUE - for known device.
     * FALSE - for fresh device.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitiateWirelessDiscoveryStart(InitiateWirelessDiscoveryCallbackIF& cb, const ::std::string& bTMACAddress, ::smartphoneint_main_fi_types::T_e8_DeviceCategory technology, bool isKnownDevice);

    // Method 'DeleteDevice'

    /**
     * Call the method 'DeleteDevice'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'DeleteDevice'</b>:
     *
     * Interface to delete device permanently from SPI device list
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceList List of device handles to be deleted.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeleteDeviceStart(DeleteDeviceCallbackIF& cb, const ::std::vector< uint32 >& deviceList);

    // Method 'GetWiFiCredentials'

    /**
     * Call the method 'GetWiFiCredentials'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetWiFiCredentials'</b>:
     *
     * Interface to get the WiFi Credentials for Wireless.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param BTMACAddress BT MAC Address of the device requested for Wi-Fi credentials.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetWiFiCredentialsStart(GetWiFiCredentialsCallbackIF& cb, const ::std::string& bTMACAddress);

    // Method 'SetETCStatus'

    /**
     * Call the method 'SetETCStatus'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetETCStatus'</b>:
     *
     * Scope: CarPlay and AAP
     * Interface to set the Electronic Toll Collection (ETC) enabling status.
     * If the ETC feature is enabled (in the head unit restrictions), this method can be used to enable or disable the status while CarPlay session is active.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ETCStatus Identifies whether to enable/disable the ETC (Electronic Toll Collection) icon.
     * True: Enable ETC. False: Disable ETC.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetETCStatusStart(SetETCStatusCallbackIF& cb, bool eTCStatus);

    // Method 'DistanceToEmptyTank'

    /**
     * Call the method 'DistanceToEmptyTank'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DistanceToEmptyTank'</b>:
     *
     * Scope: MirrorLink.
     * DistanceToEmptyTank Interface determines the distance that can be travelled by the vehicle with
     * the amount of fuel left in the vehicle. Suppose a vehicle travels 60km with one litre of fuel present
     * and now the vehicle is left with 3 litres of fuel in the tank then the DistanceToEmptyTank  is 180km.
     * This interface is used by the client to update the distance to empty tank that is derived from vehicle CAN interface.
     * This data needs to be sent only when device is selected and DistanceToEmptyTank data is changed, SPI will take care of
     * sending the data at the required rate to the devices.
     * Valid Data Range(DistanceToEmptyTank) - 0 to 0x7FFFFFFF i.e;2,147,483,647 km
     * If DistanceToEmptyTank = 0xFFFFFFFF, then it is invalid data
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DistanceToEmptyTank DistanceToEmptyTank in km.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDistanceToEmptyTankStart(DistanceToEmptyTankCallbackIF& cb, int32 distanceToEmptyTank);

    // Method 'SendLanguageSetting'

    /**
     * Call the method 'SendLanguageSetting'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendLanguageSetting'</b>:
     *
     * Scope: MirrorLink.
     * Interface to send the system language information.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param LanguageSetting LanguageSetting Value.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendLanguageSettingStart(SendLanguageSettingCallbackIF& cb, ::smartphoneint_main_fi_types::T_e32_Language languageSetting);

    // Method 'SendVehiclePowerModeState'

    /**
     * Call the method 'SendVehiclePowerModeState'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SendVehiclePowerModeState'</b>:
     *
     * Scope: MirrorLink.
     * VehiclePowerMode Interface determines the position of the ignition switch. It represents vehicle power mode state.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param VehiclePowerModeState Provides VehiclePowerMode State Information.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendVehiclePowerModeStateStart(SendVehiclePowerModeStateCallbackIF& cb, ::smartphoneint_main_fi_types::T_e8_VehiclePowerModeState vehiclePowerModeState);

    // Method 'SendAmbientColour'

    /**
     * Call the method 'SendAmbientColour'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SendAmbientColour'</b>:
     *
     * Scope: MirrorLink.
     * It is used to send ambient colour details of the HU like Red, Green, Blue, Alpha etc. for a Mirror Link device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param AmbientColourData Provides the AmbientColour details.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendAmbientColourStart(SendAmbientColourCallbackIF& cb, const ::smartphoneint_main_fi_types::T_AmbientColourData& ambientColourData);

    // Method 'RegisterRouteGuidanceDisplayConfiguration'

    /**
     * Call the method 'RegisterRouteGuidanceDisplayConfiguration'. This
     * method sends a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'RegisterRouteGuidanceDisplayConfiguration'</b>:
     *
     * Scope: CarPlay
     * This interface is to register various display components for projecting route guidance on multiple displays.
     * Based on the different componentID and its pararmeters device is provides updates accordingly.
     * Hence, clients to check what is the widest charater length that is possible to display before register for the devices.
     * Information from this method will be used to inform device on RouteGuidanceDisplayComponent in iAP2 identification.
     * Note: ID's allocated are of static ID, which means clients should take care of having non overlapping IDs
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param RouteGuidanceDisplayComponents Display components information configured for route guidance display.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterRouteGuidanceDisplayConfigurationStart(RegisterRouteGuidanceDisplayConfigurationCallbackIF& cb, const ::std::vector< ::smartphoneint_main_fi_types::T_RouteGuidanceDisplayComponent >& routeGuidanceDisplayComponents);

    // Method 'StartRouteGuidanceUpdates'

    /**
     * Call the method 'StartRouteGuidanceUpdates'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StartRouteGuidanceUpdates'</b>:
     *
     * Scope: CarPlay
     * StartRouteGuidanceUpdate must be sent when accessory is ready to display navigation route guidance.
     * To get updates for RouteGuidance, client should register for properties CarplayRouteGuidanceUpdate and CarplayRouteGuidanceManeuverUpdate
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param RoutGuidanceComponentID List of registered display component IDs which are ready to display route guidance updates.
     * If none are specified, assume all such components are being started.
     *
     * @param SourceName Must be included to receive SourceName in RouteGuidanceUpdate.
     *
     * @param SourceSupportsRouteGuidance Must be included to receive SourceSupportsRouteGuidance in RouteGuidanceUpdate.
     *
     * @param NeedAutoStartStopTBTUpdates True indicates that SPI has to auto start route guidance updates on start of CarPlay session and end the updates on end of CarPlay session.
     * However, if the client needs to start or stop in between(E.g.based on the themes different componentIDs can be started and stopped) the client has to send StartRouteGuidanceUpdates / StopRouteGuidanceUpdates explicitly.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartRouteGuidanceUpdatesStart(StartRouteGuidanceUpdatesCallbackIF& cb, const ::std::vector< ::smartphoneint_main_fi_types::T_e8_ComponentID >& routGuidanceComponentID, bool sourceName, bool sourceSupportsRouteGuidance, bool needAutoStartStopTBTUpdates);

    // Method 'StopRouteGuidanceUpdates'

    /**
     * Call the method 'StopRouteGuidanceUpdates'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'StopRouteGuidanceUpdates'</b>:
     *
     * Scope: CarPlay
     * StopRouteGuidanceUpdate must be sent when navigation route guidance is not being displayed by the accessory.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param RoutGuidanceComponentID List of registered display component IDs that are displaying route guidance updates.
     * If none(list is empty) are specified, assume all such components are to be stopped.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopRouteGuidanceUpdatesStart(StopRouteGuidanceUpdatesCallbackIF& cb, const ::std::vector< ::smartphoneint_main_fi_types::T_e8_ComponentID >& routGuidanceComponentID);

    // Method 'GetDeviceList'

    /**
     * Call the method 'GetDeviceList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GetDeviceList'</b>:
     *
     * It provides a list of connected devices and device history with the information for each device.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceHandle Uniquely identifies the target Device.
     * If the value is 0 or 0xFFFFFFFF, gives device info of all the devices.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDeviceListStart(GetDeviceListCallbackIF& cb, uint32 deviceHandle);

    // Property 'DeviceStatusInfo'

    /**
     * Notify on the property 'DeviceStatusInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DeviceStatusInfo'</b>:
     *
     * It notifies the client upon device list change. The client can retrieve the detailed information of the device via the methods provided.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceStatusInfoUpReg(DeviceStatusInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeviceStatusInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceStatusInfo'</b>:
     *
     * It notifies the client upon device list change. The client can retrieve the detailed information of the device via the methods provided.
     *
     * @param act The act which was previously returned by the
     * sendDeviceStatusInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeviceStatusInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeviceStatusInfo'.
     */
    void sendDeviceStatusInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeviceStatusInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDeviceStatusInfo() returns true.
     *
     * @return the previously received value of the property 'DeviceStatusInfo'.
     */
    const DeviceStatusInfoStatus& getDeviceStatusInfo() const;

    /**
     * Determines whether a status message for the property 'DeviceStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceStatusInfo() const;

    // Property 'AppStatusInfo'

    /**
     * Notify on the property 'AppStatusInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AppStatusInfo'</b>:
     *
     * It notifies the client upon application list change of a Mirror Link device.
     * The client can retrieve the detailed information of the applications via the methods provided.
     * If a Mirror Link device is disconnected, Device Handle is set to 0xFFFF and DeviceConnectionType is set to UNKNOWN_CONNECTION.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppStatusInfoUpReg(AppStatusInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AppStatusInfo'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AppStatusInfo'</b>:
     *
     * It notifies the client upon application list change of a Mirror Link device.
     * The client can retrieve the detailed information of the applications via the methods provided.
     * If a Mirror Link device is disconnected, Device Handle is set to 0xFFFF and DeviceConnectionType is set to UNKNOWN_CONNECTION.
     *
     * @param act The act which was previously returned by the
     * sendAppStatusInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAppStatusInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AppStatusInfo'.
     */
    void sendAppStatusInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'AppStatusInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAppStatusInfo() returns true.
     *
     * @return the previously received value of the property 'AppStatusInfo'.
     */
    const AppStatusInfoStatus& getAppStatusInfo() const;

    /**
     * Determines whether a status message for the property 'AppStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAppStatusInfo() const;

    // Property 'DAPStatusInfo'

    /**
     * Notify on the property 'DAPStatusInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DAPStatusInfo'</b>:
     *
     * Scope: Only for ML
     * It notifies the client about DAP authentication progress information for a Mirror Link device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDAPStatusInfoUpReg(DAPStatusInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DAPStatusInfo'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DAPStatusInfo'</b>:
     *
     * Scope: Only for ML
     * It notifies the client about DAP authentication progress information for a Mirror Link device.
     *
     * @param act The act which was previously returned by the
     * sendDAPStatusInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDAPStatusInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DAPStatusInfo'.
     */
    void sendDAPStatusInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'DAPStatusInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDAPStatusInfo() returns true.
     *
     * @return the previously received value of the property 'DAPStatusInfo'.
     */
    const DAPStatusInfoStatus& getDAPStatusInfo() const;

    /**
     * Determines whether a status message for the property 'DAPStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDAPStatusInfo() const;

    // Property 'NotificationInfo'

    /**
     * Notify on the property 'NotificationInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'NotificationInfo'</b>:
     *
     * Interface to provide Notification Information received from the Mirror Link server (only for Mirror Link devices).
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotificationInfoUpReg(NotificationInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NotificationInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NotificationInfo'</b>:
     *
     * Interface to provide Notification Information received from the Mirror Link server (only for Mirror Link devices).
     *
     * @param act The act which was previously returned by the
     * sendNotificationInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNotificationInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NotificationInfo'.
     */
    void sendNotificationInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'NotificationInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNotificationInfo() returns true.
     *
     * @return the previously received value of the property 'NotificationInfo'.
     */
    const NotificationInfoStatus& getNotificationInfo() const;

    /**
     * Determines whether a status message for the property 'NotificationInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNotificationInfo() const;

    // Property 'ApplicationMediaMetaData'

    /**
     * Notify on the property 'ApplicationMediaMetaData'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ApplicationMediaMetaData'</b>:
     *
     * Scope : CarPlay, AAP, Carlife
     * Interface to notify media application metadata to the client.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendApplicationMediaMetaDataUpReg(ApplicationMediaMetaDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ApplicationMediaMetaData'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ApplicationMediaMetaData'</b>:
     *
     * Scope : CarPlay, AAP, Carlife
     * Interface to notify media application metadata to the client.
     *
     * @param act The act which was previously returned by the
     * sendApplicationMediaMetaDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendApplicationMediaMetaDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ApplicationMediaMetaData'.
     */
    void sendApplicationMediaMetaDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'ApplicationMediaMetaData'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasApplicationMediaMetaData() returns true.
     *
     * @return the previously received value of the property 'ApplicationMediaMetaData'.
     */
    const ApplicationMediaMetaDataStatus& getApplicationMediaMetaData() const;

    /**
     * Determines whether a status message for the property 'ApplicationMediaMetaData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasApplicationMediaMetaData() const;

    // Property 'DeviceDisplayContext'

    /**
     * Notify on the property 'DeviceDisplayContext'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceDisplayContext'</b>:
     *
     * This interface is used by native HMI and the Mirror Link/DiPO/Android Auto device to inform each other regarding the current display context. This interface is bidirectional. The parameter field will be used by HMI to inform SPI and the result field will be used by SPI to inform HMI.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceDisplayContextUpReg(DeviceDisplayContextCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeviceDisplayContext'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceDisplayContext'</b>:
     *
     * This interface is used by native HMI and the Mirror Link/DiPO/Android Auto device to inform each other regarding the current display context. This interface is bidirectional. The parameter field will be used by HMI to inform SPI and the result field will be used by SPI to inform HMI.
     *
     * @param act The act which was previously returned by the
     * sendDeviceDisplayContextUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeviceDisplayContextRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeviceDisplayContext'.
     */
    void sendDeviceDisplayContextRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeviceDisplayContext' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeviceDisplayContext() returns true.
     *
     * @return the previously received value of the property 'DeviceDisplayContext'.
     */
    const DeviceDisplayContextStatus& getDeviceDisplayContext() const;

    /**
     * Determines whether a status message for the property 'DeviceDisplayContext' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceDisplayContext() const;

    // Property 'ApplicationPhoneData'

    /**
     * Notify on the property 'ApplicationPhoneData'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'ApplicationPhoneData'</b>:
     *
     * Scope : CarPlay
     * Interface to notify Phone application data like, call status, signal strength to the client.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendApplicationPhoneDataUpReg(ApplicationPhoneDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ApplicationPhoneData'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ApplicationPhoneData'</b>:
     *
     * Scope : CarPlay
     * Interface to notify Phone application data like, call status, signal strength to the client.
     *
     * @param act The act which was previously returned by the
     * sendApplicationPhoneDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendApplicationPhoneDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ApplicationPhoneData'.
     */
    void sendApplicationPhoneDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'ApplicationPhoneData' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasApplicationPhoneData() returns true.
     *
     * @return the previously received value of the property 'ApplicationPhoneData'.
     */
    const ApplicationPhoneDataStatus& getApplicationPhoneData() const;

    /**
     * Determines whether a status message for the property 'ApplicationPhoneData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasApplicationPhoneData() const;

    // Property 'BluetoothDeviceStatus'

    /**
     * Notify on the property 'BluetoothDeviceStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothDeviceStatus'</b>:
     *
     * Used to notify HMI when there is a device switch operation being performed between a BT and a Projection device, as a result of user action or due to device selection strategy applied by Bluetooth/SPI service.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBluetoothDeviceStatusUpReg(BluetoothDeviceStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BluetoothDeviceStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BluetoothDeviceStatus'</b>:
     *
     * Used to notify HMI when there is a device switch operation being performed between a BT and a Projection device, as a result of user action or due to device selection strategy applied by Bluetooth/SPI service.
     *
     * @param act The act which was previously returned by the
     * sendBluetoothDeviceStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBluetoothDeviceStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BluetoothDeviceStatus'.
     */
    void sendBluetoothDeviceStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'BluetoothDeviceStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBluetoothDeviceStatus() returns true.
     *
     * @return the previously received value of the property 'BluetoothDeviceStatus'.
     */
    const BluetoothDeviceStatusStatus& getBluetoothDeviceStatus() const;

    /**
     * Determines whether a status message for the property 'BluetoothDeviceStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBluetoothDeviceStatus() const;

    // Property 'DeviceAudioContext'

    /**
     * Notify on the property 'DeviceAudioContext'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DeviceAudioContext'</b>:
     *
     * Used to notify HMI when there is a Audio context change in the device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceAudioContextUpReg(DeviceAudioContextCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeviceAudioContext'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceAudioContext'</b>:
     *
     * Used to notify HMI when there is a Audio context change in the device.
     *
     * @param act The act which was previously returned by the
     * sendDeviceAudioContextUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeviceAudioContextRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeviceAudioContext'.
     */
    void sendDeviceAudioContextRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeviceAudioContext' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasDeviceAudioContext() returns true.
     *
     * @return the previously received value of the property 'DeviceAudioContext'.
     */
    const DeviceAudioContextStatus& getDeviceAudioContext() const;

    /**
     * Determines whether a status message for the property 'DeviceAudioContext' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceAudioContext() const;

    // Property 'DiPOAppStatusInfo'

    /**
     * Notify on the property 'DiPOAppStatusInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DiPOAppStatusInfo'</b>:
     *
     * It notifies the client upon DiPO device app state change. The client should check the status for all the specified Apps.currently 3 app states are specified.
     * According to Apple more App states are expected in future versions.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiPOAppStatusInfoUpReg(DiPOAppStatusInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DiPOAppStatusInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DiPOAppStatusInfo'</b>:
     *
     * It notifies the client upon DiPO device app state change. The client should check the status for all the specified Apps.currently 3 app states are specified.
     * According to Apple more App states are expected in future versions.
     *
     * @param act The act which was previously returned by the
     * sendDiPOAppStatusInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDiPOAppStatusInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DiPOAppStatusInfo'.
     */
    void sendDiPOAppStatusInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'DiPOAppStatusInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiPOAppStatusInfo() returns true.
     *
     * @return the previously received value of the property 'DiPOAppStatusInfo'.
     */
    const DiPOAppStatusInfoStatus& getDiPOAppStatusInfo() const;

    /**
     * Determines whether a status message for the property 'DiPOAppStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiPOAppStatusInfo() const;

    // Property 'SessionStatusInfo'

    /**
     * Notify on the property 'SessionStatusInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SessionStatusInfo'</b>:
     *
     * Scope: ML, CarPlay, AAP and MySPIN
     * It notifies the client about Session status information for a projected device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSessionStatusInfoUpReg(SessionStatusInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SessionStatusInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SessionStatusInfo'</b>:
     *
     * Scope: ML, CarPlay, AAP and MySPIN
     * It notifies the client about Session status information for a projected device.
     *
     * @param act The act which was previously returned by the
     * sendSessionStatusInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSessionStatusInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SessionStatusInfo'.
     */
    void sendSessionStatusInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'SessionStatusInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSessionStatusInfo() returns true.
     *
     * @return the previously received value of the property 'SessionStatusInfo'.
     */
    const SessionStatusInfoStatus& getSessionStatusInfo() const;

    /**
     * Determines whether a status message for the property 'SessionStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSessionStatusInfo() const;

    // Property 'BTPairingRequired'

    /**
     * Notify on the property 'BTPairingRequired'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'BTPairingRequired'</b>:
     *
     * Used to notify the client if BT pairing has to be initiated.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBTPairingRequiredUpReg(BTPairingRequiredCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BTPairingRequired'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BTPairingRequired'</b>:
     *
     * Used to notify the client if BT pairing has to be initiated.
     *
     * @param act The act which was previously returned by the
     * sendBTPairingRequiredUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBTPairingRequiredRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BTPairingRequired'.
     */
    void sendBTPairingRequiredRelUpRegAll ();

    /**
     * Returns the current value of the property 'BTPairingRequired' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasBTPairingRequired() returns true.
     *
     * @return the previously received value of the property 'BTPairingRequired'.
     */
    const BTPairingRequiredStatus& getBTPairingRequired() const;

    /**
     * Determines whether a status message for the property 'BTPairingRequired' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBTPairingRequired() const;

    // Property 'MLServerKeyCapabilities'

    /**
     * Notify on the property 'MLServerKeyCapabilities'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'MLServerKeyCapabilities'</b>:
     *
     * Interface to notify Server Key Capabilities to Clients.
     * Applicable only for MirrorLink device.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMLServerKeyCapabilitiesUpReg(MLServerKeyCapabilitiesCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MLServerKeyCapabilities'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MLServerKeyCapabilities'</b>:
     *
     * Interface to notify Server Key Capabilities to Clients.
     * Applicable only for MirrorLink device.
     *
     * @param act The act which was previously returned by the
     * sendMLServerKeyCapabilitiesUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMLServerKeyCapabilitiesRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MLServerKeyCapabilities'.
     */
    void sendMLServerKeyCapabilitiesRelUpRegAll ();

    /**
     * Returns the current value of the property 'MLServerKeyCapabilities' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMLServerKeyCapabilities() returns true.
     *
     * @return the previously received value of the property 'MLServerKeyCapabilities'.
     */
    const MLServerKeyCapabilitiesStatus& getMLServerKeyCapabilities() const;

    /**
     * Determines whether a status message for the property 'MLServerKeyCapabilities' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMLServerKeyCapabilities() const;

    // Property 'Dial'

    /**
     * Notify on the property 'Dial'. This method sends a UpReg message to the
     * CCA server.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
     * Currently this API is used only for MySpin technology.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDialUpReg(DialCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Dial'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
     * Currently this API is used only for MySpin technology.
     *
     * @param act The act which was previously returned by the sendDialUpReg()
     * method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDialRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Dial'.
     */
    void sendDialRelUpRegAll ();

    /**
     * Returns the current value of the property 'Dial' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDial()
     * returns true.
     *
     * @return the previously received value of the property 'Dial'.
     */
    const DialStatus& getDial() const;

    /**
     * Determines whether a status message for the property 'Dial' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDial() const;

    /**
     * Set the value of the property 'Dial'. This method sends a Set message
     * to the CCA server.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * This interface is used by the client to inform HMI to start an outgoing call with the provided details(TelephoneNumber and DisplayInfo).
     * Currently this API is used only for MySpin technology.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param PhoneCallState Identifies the Phone Call State.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDialSet(DialCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_PhoneCallState phoneCallState);

    // Property 'MediaPlayBackTime'

    /**
     * Notify on the property 'MediaPlayBackTime'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MediaPlayBackTime'</b>:
     *
     * Scope : CarPlay, AAP, Carlife
     * Interface to notify playback time of the current playing media song.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMediaPlayBackTimeUpReg(MediaPlayBackTimeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MediaPlayBackTime'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MediaPlayBackTime'</b>:
     *
     * Scope : CarPlay, AAP, Carlife
     * Interface to notify playback time of the current playing media song.
     *
     * @param act The act which was previously returned by the
     * sendMediaPlayBackTimeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMediaPlayBackTimeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MediaPlayBackTime'.
     */
    void sendMediaPlayBackTimeRelUpRegAll ();

    /**
     * Returns the current value of the property 'MediaPlayBackTime' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMediaPlayBackTime() returns true.
     *
     * @return the previously received value of the property 'MediaPlayBackTime'.
     */
    const MediaPlayBackTimeStatus& getMediaPlayBackTime() const;

    /**
     * Determines whether a status message for the property 'MediaPlayBackTime' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMediaPlayBackTime() const;

    // Property 'ProjectionDeviceAuthorization'

    /**
     * Notify on the property 'ProjectionDeviceAuthorization'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'ProjectionDeviceAuthorization'</b>:
     *
     * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
     * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProjectionDeviceAuthorizationUpReg(ProjectionDeviceAuthorizationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ProjectionDeviceAuthorization'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ProjectionDeviceAuthorization'</b>:
     *
     * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
     * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
     *
     * @param act The act which was previously returned by the
     * sendProjectionDeviceAuthorizationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProjectionDeviceAuthorizationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ProjectionDeviceAuthorization'.
     */
    void sendProjectionDeviceAuthorizationRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'ProjectionDeviceAuthorization' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasProjectionDeviceAuthorization()
     * returns true.
     *
     * @return the previously received value of the property 'ProjectionDeviceAuthorization'.
     */
    const ProjectionDeviceAuthorizationStatus& getProjectionDeviceAuthorization() const;

    /**
     * Determines whether a status message for the property 'ProjectionDeviceAuthorization' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProjectionDeviceAuthorization() const;

    /**
     * Set the value of the property 'ProjectionDeviceAuthorization'. This
     * method sends a Set message to the CCA server.
     *
     * <b>Documentation of 'ProjectionDeviceAuthorization'</b>:
     *
     * Used to notify client about authorization status of projection device. Also used to change the authorization state of a device after user consent action.
     * If usage preference of projection is Enabled, client has to authorize the projection device without user consent.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param UserAuthorizationStatus Identifies the user authorization state.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProjectionDeviceAuthorizationSet(ProjectionDeviceAuthorizationCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_UserAuthorizationStatus userAuthorizationStatus);

    // Property 'NavigationStatusInfo'

    /**
     * Notify on the property 'NavigationStatusInfo'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'NavigationStatusInfo'</b>:
     *
     * Scope: AAP
     * Interface to update the Projection Navigation status Information(ACTIVE, INACTIVE, UNAVAILABLE) to the client.
     * -- This property is deprecated instead use TurnByTurnInfo.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavigationStatusInfoUpReg(NavigationStatusInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NavigationStatusInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NavigationStatusInfo'</b>:
     *
     * Scope: AAP
     * Interface to update the Projection Navigation status Information(ACTIVE, INACTIVE, UNAVAILABLE) to the client.
     * -- This property is deprecated instead use TurnByTurnInfo.
     *
     * @param act The act which was previously returned by the
     * sendNavigationStatusInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNavigationStatusInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NavigationStatusInfo'.
     */
    void sendNavigationStatusInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'NavigationStatusInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasNavigationStatusInfo() returns true.
     *
     * @return the previously received value of the property 'NavigationStatusInfo'.
     */
    const NavigationStatusInfoStatus& getNavigationStatusInfo() const;

    /**
     * Determines whether a status message for the property 'NavigationStatusInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNavigationStatusInfo() const;

    // Property 'NavigationNextTurnData'

    /**
     * Notify on the property 'NavigationNextTurnData'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'NavigationNextTurnData'</b>:
     *
     * Scope: AAP
     * Updates Turn-By-Turn Projection Navigation Information to the client.
     * -- This property is deprecated instead use TurnByTurnInfo.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavigationNextTurnDataUpReg(NavigationNextTurnDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NavigationNextTurnData'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NavigationNextTurnData'</b>:
     *
     * Scope: AAP
     * Updates Turn-By-Turn Projection Navigation Information to the client.
     * -- This property is deprecated instead use TurnByTurnInfo.
     *
     * @param act The act which was previously returned by the
     * sendNavigationNextTurnDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNavigationNextTurnDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NavigationNextTurnData'.
     */
    void sendNavigationNextTurnDataRelUpRegAll ();

    /**
     * Returns the current value of the property 'NavigationNextTurnData' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasNavigationNextTurnData() returns true.
     *
     * @return the previously received value of the property 'NavigationNextTurnData'.
     */
    const NavigationNextTurnDataStatus& getNavigationNextTurnData() const;

    /**
     * Determines whether a status message for the property 'NavigationNextTurnData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNavigationNextTurnData() const;

    // Property 'NavigationNextTurnDistanceData'

    /**
     * Notify on the property 'NavigationNextTurnDistanceData'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'NavigationNextTurnDistanceData'</b>:
     *
     * Scope: AAP
     * Interface to update the Projection Navigation Next Turn Distance Data to the clients.
     * -- This property is deprecated instead use TurnByTurnInfo.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNavigationNextTurnDistanceDataUpReg(NavigationNextTurnDistanceDataCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NavigationNextTurnDistanceData'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NavigationNextTurnDistanceData'</b>:
     *
     * Scope: AAP
     * Interface to update the Projection Navigation Next Turn Distance Data to the clients.
     * -- This property is deprecated instead use TurnByTurnInfo.
     *
     * @param act The act which was previously returned by the
     * sendNavigationNextTurnDistanceDataUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNavigationNextTurnDistanceDataRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NavigationNextTurnDistanceData'.
     */
    void sendNavigationNextTurnDistanceDataRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'NavigationNextTurnDistanceData' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasNavigationNextTurnDistanceData() returns true.
     *
     * @return the previously received value of the property 'NavigationNextTurnDistanceData'.
     */
    const NavigationNextTurnDistanceDataStatus& getNavigationNextTurnDistanceData() const;

    /**
     * Determines whether a status message for the property 'NavigationNextTurnDistanceData' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNavigationNextTurnDistanceData() const;

    // Property 'AAPNotificationEvent'

    /**
     * Notify on the property 'AAPNotificationEvent'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AAPNotificationEvent'</b>:
     *
     * Scope: AAP
     * Interface to provide details of the notification received from the projection device
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAAPNotificationEventUpReg(AAPNotificationEventCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AAPNotificationEvent'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AAPNotificationEvent'</b>:
     *
     * Scope: AAP
     * Interface to provide details of the notification received from the projection device
     *
     * @param act The act which was previously returned by the
     * sendAAPNotificationEventUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAAPNotificationEventRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AAPNotificationEvent'.
     */
    void sendAAPNotificationEventRelUpRegAll ();

    /**
     * Returns the current value of the property 'AAPNotificationEvent' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAAPNotificationEvent() returns true.
     *
     * @return the previously received value of the property 'AAPNotificationEvent'.
     */
    const AAPNotificationEventStatus& getAAPNotificationEvent() const;

    /**
     * Determines whether a status message for the property 'AAPNotificationEvent' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAAPNotificationEvent() const;

    /**
     * Set the value of the property 'AAPNotificationEvent'. This method sends
     * a Set message to the CCA server.
     *
     * <b>Documentation of 'AAPNotificationEvent'</b>:
     *
     * Scope: AAP
     * Interface to provide details of the notification received from the projection device
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param AAPNotificationId Unique identifier of the notification that was acknowledged.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAAPNotificationEventSet(AAPNotificationEventCallbackIF& cb, const ::std::string& aAPNotificationId);

    // Property 'mySPINBluetoothVoiceRecInfo'

    /**
     * Notify on the property 'mySPINBluetoothVoiceRecInfo'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'mySPINBluetoothVoiceRecInfo'</b>:
     *
     * This interface is used for mySPIN VR for Android Phones to inform HMI
     * a) If Bluetooth VR session can be started based on BT Match Status
     * b) The current request to process w.r.t BT Voice Recognition
     *
     * HMI should use this interface to set the response w.r.t the request made by SPI.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMySPINBluetoothVoiceRecInfoUpReg(MySPINBluetoothVoiceRecInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'mySPINBluetoothVoiceRecInfo'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'mySPINBluetoothVoiceRecInfo'</b>:
     *
     * This interface is used for mySPIN VR for Android Phones to inform HMI
     * a) If Bluetooth VR session can be started based on BT Match Status
     * b) The current request to process w.r.t BT Voice Recognition
     *
     * HMI should use this interface to set the response w.r.t the request made by SPI.
     *
     * @param act The act which was previously returned by the
     * sendMySPINBluetoothVoiceRecInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMySPINBluetoothVoiceRecInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'mySPINBluetoothVoiceRecInfo'.
     */
    void sendMySPINBluetoothVoiceRecInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'mySPINBluetoothVoiceRecInfo'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMySPINBluetoothVoiceRecInfo() returns true.
     *
     * @return the previously received value of the property 'mySPINBluetoothVoiceRecInfo'.
     */
    const MySPINBluetoothVoiceRecInfoStatus& getMySPINBluetoothVoiceRecInfo() const;

    /**
     * Determines whether a status message for the property 'mySPINBluetoothVoiceRecInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMySPINBluetoothVoiceRecInfo() const;

    /**
     * Set the value of the property 'mySPINBluetoothVoiceRecInfo'. This
     * method sends a Set message to the CCA server.
     *
     * <b>Documentation of 'mySPINBluetoothVoiceRecInfo'</b>:
     *
     * This interface is used for mySPIN VR for Android Phones to inform HMI
     * a) If Bluetooth VR session can be started based on BT Match Status
     * b) The current request to process w.r.t BT Voice Recognition
     *
     * HMI should use this interface to set the response w.r.t the request made by SPI.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param BTVoiceRecReqResponse Identifies the response to the request made.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMySPINBluetoothVoiceRecInfoSet(MySPINBluetoothVoiceRecInfoCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_BTVoiceRecRequestResponse bTVoiceRecReqResponse);

    // Property 'TechnologySelection'

    /**
     * Notify on the property 'TechnologySelection'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TechnologySelection'</b>:
     *
     * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
     * The client can choose the required technology for selection
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTechnologySelectionUpReg(TechnologySelectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TechnologySelection'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TechnologySelection'</b>:
     *
     * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
     * The client can choose the required technology for selection
     *
     * @param act The act which was previously returned by the
     * sendTechnologySelectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTechnologySelectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TechnologySelection'.
     */
    void sendTechnologySelectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'TechnologySelection' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTechnologySelection() returns true.
     *
     * @return the previously received value of the property 'TechnologySelection'.
     */
    const TechnologySelectionStatus& getTechnologySelection() const;

    /**
     * Determines whether a status message for the property 'TechnologySelection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTechnologySelection() const;

    /**
     * Set the value of the property 'TechnologySelection'. This method sends
     * a Set message to the CCA server.
     *
     * <b>Documentation of 'TechnologySelection'</b>:
     *
     * Used to notify client about device connection when the device usage preference setting is USER_CONF_REQD.
     * The client can choose the required technology for selection
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param DeviceHandle Unique handle which identifies the device.
     *
     * @param SelectedTechnology Technology client wishes to select, Can be set to DEV_TYPE_DEFAULT if device will not be used for any technology
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTechnologySelectionSet(TechnologySelectionCallbackIF& cb, uint32 deviceHandle, ::smartphoneint_main_fi_types::T_e8_DeviceCategory selectedTechnology);

    // Property 'WiFiCredentials'

    /**
     * Notify on the property 'WiFiCredentials'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'WiFiCredentials'</b>:
     *
     * Scope: Carplay over wireless for now.
     * Interface to get the WiFi Credentials of the Access Point.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWiFiCredentialsUpReg(WiFiCredentialsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'WiFiCredentials'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'WiFiCredentials'</b>:
     *
     * Scope: Carplay over wireless for now.
     * Interface to get the WiFi Credentials of the Access Point.
     *
     * @param act The act which was previously returned by the
     * sendWiFiCredentialsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendWiFiCredentialsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'WiFiCredentials'.
     */
    void sendWiFiCredentialsRelUpRegAll ();

    /**
     * Returns the current value of the property 'WiFiCredentials' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasWiFiCredentials() returns true.
     *
     * @return the previously received value of the property 'WiFiCredentials'.
     */
    const WiFiCredentialsStatus& getWiFiCredentials() const;

    /**
     * Determines whether a status message for the property 'WiFiCredentials' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWiFiCredentials() const;

    /**
     * Request the value of the property 'WiFiCredentials' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'WiFiCredentials'</b>:
     *
     * Scope: Carplay over wireless for now.
     * Interface to get the WiFi Credentials of the Access Point.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWiFiCredentialsGet(WiFiCredentialsCallbackIF& cb);

    // Property 'TurnByTurnInfo'

    /**
     * Notify on the property 'TurnByTurnInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'TurnByTurnInfo'</b>:
     *
     * Obsolete:
     * Instead use CarplayRouteGuidanceUpdate, AAutoTurnByTurnInfo, BDCLTurnByTurnInfo and MLTurnByTurnInfo respectively for CarPlay, Androidauto, Baidu, Mirrorlink
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTurnByTurnInfoUpReg(TurnByTurnInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TurnByTurnInfo'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TurnByTurnInfo'</b>:
     *
     * Obsolete:
     * Instead use CarplayRouteGuidanceUpdate, AAutoTurnByTurnInfo, BDCLTurnByTurnInfo and MLTurnByTurnInfo respectively for CarPlay, Androidauto, Baidu, Mirrorlink
     *
     * @param act The act which was previously returned by the
     * sendTurnByTurnInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTurnByTurnInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TurnByTurnInfo'.
     */
    void sendTurnByTurnInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'TurnByTurnInfo' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTurnByTurnInfo() returns true.
     *
     * @return the previously received value of the property 'TurnByTurnInfo'.
     */
    const TurnByTurnInfoStatus& getTurnByTurnInfo() const;

    /**
     * Determines whether a status message for the property 'TurnByTurnInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTurnByTurnInfo() const;

    // Property 'ProjectedVideoInfo'

    /**
     * Notify on the property 'ProjectedVideoInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ProjectedVideoInfo'</b>:
     *
     * Scope: AAP, Carlife
     * Provides information about the attributes of the video about to be rendered on the display once projection technology has chosen a display resolution. This information can be
     * used by HMI to position/ rescale the video as per the UI requirements.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProjectedVideoInfoUpReg(ProjectedVideoInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ProjectedVideoInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ProjectedVideoInfo'</b>:
     *
     * Scope: AAP, Carlife
     * Provides information about the attributes of the video about to be rendered on the display once projection technology has chosen a display resolution. This information can be
     * used by HMI to position/ rescale the video as per the UI requirements.
     *
     * @param act The act which was previously returned by the
     * sendProjectedVideoInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProjectedVideoInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ProjectedVideoInfo'.
     */
    void sendProjectedVideoInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'ProjectedVideoInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProjectedVideoInfo() returns true.
     *
     * @return the previously received value of the property 'ProjectedVideoInfo'.
     */
    const ProjectedVideoInfoStatus& getProjectedVideoInfo() const;

    /**
     * Determines whether a status message for the property 'ProjectedVideoInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProjectedVideoInfo() const;

    // Property 'DeviceLockStatus'

    /**
     * Notify on the property 'DeviceLockStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DeviceLockStatus'</b>:
     *
     * Used to notify the HMI if Mobile Device has Enabled/Disabled Device Lock.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceLockStatusUpReg(DeviceLockStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DeviceLockStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DeviceLockStatus'</b>:
     *
     * Used to notify the HMI if Mobile Device has Enabled/Disabled Device Lock.
     *
     * @param act The act which was previously returned by the
     * sendDeviceLockStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDeviceLockStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DeviceLockStatus'.
     */
    void sendDeviceLockStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'DeviceLockStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDeviceLockStatus() returns true.
     *
     * @return the previously received value of the property 'DeviceLockStatus'.
     */
    const DeviceLockStatusStatus& getDeviceLockStatus() const;

    /**
     * Determines whether a status message for the property 'DeviceLockStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDeviceLockStatus() const;

    // Property 'RelativelyActiveMediaApp'

    /**
     * Notify on the property 'RelativelyActiveMediaApp'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'RelativelyActiveMediaApp'</b>:
     *
     * Scope: MirrorLink.
     * Used to notify the HMI regarding the relatively active media app among online music(APP_MEDIA_MUSIC)/online radio(APP_MEDIA)/VIDEO/GAMING/IMAGE
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRelativelyActiveMediaAppUpReg(RelativelyActiveMediaAppCallbackIF& cb);

    /**
     * Remove the notifcation on property 'RelativelyActiveMediaApp'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'RelativelyActiveMediaApp'</b>:
     *
     * Scope: MirrorLink.
     * Used to notify the HMI regarding the relatively active media app among online music(APP_MEDIA_MUSIC)/online radio(APP_MEDIA)/VIDEO/GAMING/IMAGE
     *
     * @param act The act which was previously returned by the
     * sendRelativelyActiveMediaAppUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendRelativelyActiveMediaAppRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'RelativelyActiveMediaApp'.
     */
    void sendRelativelyActiveMediaAppRelUpRegAll ();

    /**
     * Returns the current value of the property 'RelativelyActiveMediaApp'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasRelativelyActiveMediaApp() returns true.
     *
     * @return the previously received value of the property 'RelativelyActiveMediaApp'.
     */
    const RelativelyActiveMediaAppStatus& getRelativelyActiveMediaApp() const;

    /**
     * Determines whether a status message for the property 'RelativelyActiveMediaApp' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRelativelyActiveMediaApp() const;

    // Property 'CarplayRouteGuidanceUpdate'

    /**
     * Notify on the property 'CarplayRouteGuidanceUpdate'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'CarplayRouteGuidanceUpdate'</b>:
     *
     * Updates Carplay Turn-By-Turn Route Guidance update to the client.
     * The client have to cache the data and display the updated data by checking the available flag.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCarplayRouteGuidanceUpdateUpReg(CarplayRouteGuidanceUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CarplayRouteGuidanceUpdate'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CarplayRouteGuidanceUpdate'</b>:
     *
     * Updates Carplay Turn-By-Turn Route Guidance update to the client.
     * The client have to cache the data and display the updated data by checking the available flag.
     *
     * @param act The act which was previously returned by the
     * sendCarplayRouteGuidanceUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCarplayRouteGuidanceUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CarplayRouteGuidanceUpdate'.
     */
    void sendCarplayRouteGuidanceUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property 'CarplayRouteGuidanceUpdate'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCarplayRouteGuidanceUpdate() returns true.
     *
     * @return the previously received value of the property 'CarplayRouteGuidanceUpdate'.
     */
    const CarplayRouteGuidanceUpdateStatus& getCarplayRouteGuidanceUpdate() const;

    /**
     * Determines whether a status message for the property 'CarplayRouteGuidanceUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCarplayRouteGuidanceUpdate() const;

    // Property 'CarplayRouteGuidanceManeuverUpdate'

    /**
     * Notify on the property 'CarplayRouteGuidanceManeuverUpdate'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'CarplayRouteGuidanceManeuverUpdate'</b>:
     *
     * Updates Carplay Turn-By-Turn Route Guidance Maneuver update to the client.
     * The client have to cache the data and display the updated data by checking the available flag.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCarplayRouteGuidanceManeuverUpdateUpReg(CarplayRouteGuidanceManeuverUpdateCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'CarplayRouteGuidanceManeuverUpdate'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CarplayRouteGuidanceManeuverUpdate'</b>:
     *
     * Updates Carplay Turn-By-Turn Route Guidance Maneuver update to the client.
     * The client have to cache the data and display the updated data by checking the available flag.
     *
     * @param act The act which was previously returned by the
     * sendCarplayRouteGuidanceManeuverUpdateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCarplayRouteGuidanceManeuverUpdateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CarplayRouteGuidanceManeuverUpdate'.
     */
    void sendCarplayRouteGuidanceManeuverUpdateRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'CarplayRouteGuidanceManeuverUpdate' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasCarplayRouteGuidanceManeuverUpdate() returns true.
     *
     * @return the previously received value of the property 'CarplayRouteGuidanceManeuverUpdate'.
     */
    const CarplayRouteGuidanceManeuverUpdateStatus& getCarplayRouteGuidanceManeuverUpdate() const;

    /**
     * Determines whether a status message for the property 'CarplayRouteGuidanceManeuverUpdate' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCarplayRouteGuidanceManeuverUpdate() const;

    // Property 'AAutoTurnByTurnInfo'

    /**
     * Notify on the property 'AAutoTurnByTurnInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AAutoTurnByTurnInfo'</b>:
     *
     * Updates Android Auto Turn-By-Turn Projection Navigation Information to the client.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAAutoTurnByTurnInfoUpReg(AAutoTurnByTurnInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AAutoTurnByTurnInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AAutoTurnByTurnInfo'</b>:
     *
     * Updates Android Auto Turn-By-Turn Projection Navigation Information to the client.
     *
     * @param act The act which was previously returned by the
     * sendAAutoTurnByTurnInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAAutoTurnByTurnInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AAutoTurnByTurnInfo'.
     */
    void sendAAutoTurnByTurnInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'AAutoTurnByTurnInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAAutoTurnByTurnInfo() returns true.
     *
     * @return the previously received value of the property 'AAutoTurnByTurnInfo'.
     */
    const AAutoTurnByTurnInfoStatus& getAAutoTurnByTurnInfo() const;

    /**
     * Determines whether a status message for the property 'AAutoTurnByTurnInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAAutoTurnByTurnInfo() const;

    // Property 'BDCLTurnByTurnInfo'

    /**
     * Notify on the property 'BDCLTurnByTurnInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'BDCLTurnByTurnInfo'</b>:
     *
     * Updates Baidu Carlife Turn-By-Turn Projection Navigation Information to the client.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBDCLTurnByTurnInfoUpReg(BDCLTurnByTurnInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'BDCLTurnByTurnInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'BDCLTurnByTurnInfo'</b>:
     *
     * Updates Baidu Carlife Turn-By-Turn Projection Navigation Information to the client.
     *
     * @param act The act which was previously returned by the
     * sendBDCLTurnByTurnInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendBDCLTurnByTurnInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'BDCLTurnByTurnInfo'.
     */
    void sendBDCLTurnByTurnInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'BDCLTurnByTurnInfo' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasBDCLTurnByTurnInfo() returns true.
     *
     * @return the previously received value of the property 'BDCLTurnByTurnInfo'.
     */
    const BDCLTurnByTurnInfoStatus& getBDCLTurnByTurnInfo() const;

    /**
     * Determines whether a status message for the property 'BDCLTurnByTurnInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasBDCLTurnByTurnInfo() const;

    // Property 'MLTurnByTurnInfo'

    /**
     * Notify on the property 'MLTurnByTurnInfo'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MLTurnByTurnInfo'</b>:
     *
     * Updates Mirrorlink Turn-By-Turn Projection Navigation Information to the client.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMLTurnByTurnInfoUpReg(MLTurnByTurnInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MLTurnByTurnInfo'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MLTurnByTurnInfo'</b>:
     *
     * Updates Mirrorlink Turn-By-Turn Projection Navigation Information to the client.
     *
     * @param act The act which was previously returned by the
     * sendMLTurnByTurnInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMLTurnByTurnInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MLTurnByTurnInfo'.
     */
    void sendMLTurnByTurnInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'MLTurnByTurnInfo' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMLTurnByTurnInfo() returns true.
     *
     * @return the previously received value of the property 'MLTurnByTurnInfo'.
     */
    const MLTurnByTurnInfoStatus& getMLTurnByTurnInfo() const;

    /**
     * Determines whether a status message for the property 'MLTurnByTurnInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMLTurnByTurnInfo() const;

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Smartphoneint_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'DeviceStatusInfo'

    ::asf::core::nullable< DeviceStatusInfoStatus > _deviceStatusInfo;

    // Property 'AppStatusInfo'

    ::asf::core::nullable< AppStatusInfoStatus > _appStatusInfo;

    // Property 'DAPStatusInfo'

    ::asf::core::nullable< DAPStatusInfoStatus > _dAPStatusInfo;

    // Property 'NotificationInfo'

    ::asf::core::nullable< NotificationInfoStatus > _notificationInfo;

    // Property 'ApplicationMediaMetaData'

    ::asf::core::nullable< ApplicationMediaMetaDataStatus > _applicationMediaMetaData;

    // Property 'DeviceDisplayContext'

    ::asf::core::nullable< DeviceDisplayContextStatus > _deviceDisplayContext;

    // Property 'ApplicationPhoneData'

    ::asf::core::nullable< ApplicationPhoneDataStatus > _applicationPhoneData;

    // Property 'BluetoothDeviceStatus'

    ::asf::core::nullable< BluetoothDeviceStatusStatus > _bluetoothDeviceStatus;

    // Property 'DeviceAudioContext'

    ::asf::core::nullable< DeviceAudioContextStatus > _deviceAudioContext;

    // Property 'DiPOAppStatusInfo'

    ::asf::core::nullable< DiPOAppStatusInfoStatus > _diPOAppStatusInfo;

    // Property 'SessionStatusInfo'

    ::asf::core::nullable< SessionStatusInfoStatus > _sessionStatusInfo;

    // Property 'BTPairingRequired'

    ::asf::core::nullable< BTPairingRequiredStatus > _bTPairingRequired;

    // Property 'MLServerKeyCapabilities'

    ::asf::core::nullable< MLServerKeyCapabilitiesStatus > _mLServerKeyCapabilities;

    // Property 'Dial'

    ::asf::core::nullable< DialStatus > _dial;

    // Property 'MediaPlayBackTime'

    ::asf::core::nullable< MediaPlayBackTimeStatus > _mediaPlayBackTime;

    // Property 'ProjectionDeviceAuthorization'

    ::asf::core::nullable< ProjectionDeviceAuthorizationStatus > _projectionDeviceAuthorization;

    // Property 'NavigationStatusInfo'

    ::asf::core::nullable< NavigationStatusInfoStatus > _navigationStatusInfo;

    // Property 'NavigationNextTurnData'

    ::asf::core::nullable< NavigationNextTurnDataStatus > _navigationNextTurnData;

    // Property 'NavigationNextTurnDistanceData'

    ::asf::core::nullable< NavigationNextTurnDistanceDataStatus > _navigationNextTurnDistanceData;

    // Property 'AAPNotificationEvent'

    ::asf::core::nullable< AAPNotificationEventStatus > _aAPNotificationEvent;

    // Property 'mySPINBluetoothVoiceRecInfo'

    ::asf::core::nullable< MySPINBluetoothVoiceRecInfoStatus > _mySPINBluetoothVoiceRecInfo;

    // Property 'TechnologySelection'

    ::asf::core::nullable< TechnologySelectionStatus > _technologySelection;

    // Property 'WiFiCredentials'

    ::asf::core::nullable< WiFiCredentialsStatus > _wiFiCredentials;

    // Property 'TurnByTurnInfo'

    ::asf::core::nullable< TurnByTurnInfoStatus > _turnByTurnInfo;

    // Property 'ProjectedVideoInfo'

    ::asf::core::nullable< ProjectedVideoInfoStatus > _projectedVideoInfo;

    // Property 'DeviceLockStatus'

    ::asf::core::nullable< DeviceLockStatusStatus > _deviceLockStatus;

    // Property 'RelativelyActiveMediaApp'

    ::asf::core::nullable< RelativelyActiveMediaAppStatus > _relativelyActiveMediaApp;

    // Property 'CarplayRouteGuidanceUpdate'

    ::asf::core::nullable< CarplayRouteGuidanceUpdateStatus > _carplayRouteGuidanceUpdate;

    // Property 'CarplayRouteGuidanceManeuverUpdate'

    ::asf::core::nullable< CarplayRouteGuidanceManeuverUpdateStatus > _carplayRouteGuidanceManeuverUpdate;

    // Property 'AAutoTurnByTurnInfo'

    ::asf::core::nullable< AAutoTurnByTurnInfoStatus > _aAutoTurnByTurnInfo;

    // Property 'BDCLTurnByTurnInfo'

    ::asf::core::nullable< BDCLTurnByTurnInfoStatus > _bDCLTurnByTurnInfo;

    // Property 'MLTurnByTurnInfo'

    ::asf::core::nullable< MLTurnByTurnInfoStatus > _mLTurnByTurnInfo;

    DECLARE_CLASS_LOGGER();

    friend class Smartphoneint_main_fiProxyCallback;
};

} // namespace smartphoneint_main_fi

#endif // SMARTPHONEINT_MAIN_FIPROXY_H
