/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef RVC_CCA_FIPROXY_H
#define RVC_CCA_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "rvc_cca_fi.h"
#include "rvc_cca_fi_types.h"
#include "rvc_cca_fi_typesConst.h"
#include <vector>

namespace rvc_cca_fi {

class Rvc_cca_fiProxy;

class AVM3_ClearCommunicationErrorsCallbackIF {
public:
    virtual ~AVM3_ClearCommunicationErrorsCallbackIF() {}

    virtual void onAVM3_ClearCommunicationErrorsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ClearCommunicationErrorsError >& error) = 0;

    virtual void onAVM3_ClearCommunicationErrorsResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ClearCommunicationErrorsResult >& result) = 0;
};

class AVM3_CommunicationErrorsCallbackIF {
public:
    virtual ~AVM3_CommunicationErrorsCallbackIF() {}

    virtual void onAVM3_CommunicationErrorsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_CommunicationErrorsError >& error) = 0;

    virtual void onAVM3_CommunicationErrorsStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_CommunicationErrorsStatus >& status) = 0;
};

class AVM3_ConfigurationCallbackIF {
public:
    virtual ~AVM3_ConfigurationCallbackIF() {}

    virtual void onAVM3_ConfigurationError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ConfigurationError >& error) = 0;

    virtual void onAVM3_ConfigurationStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ConfigurationStatus >& status) = 0;
};

class AVM3_DispStatusCallbackIF {
public:
    virtual ~AVM3_DispStatusCallbackIF() {}

    virtual void onAVM3_DispStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_DispStatusError >& error) = 0;

    virtual void onAVM3_DispStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_DispStatusStatus >& status) = 0;
};

class AVM3_ErrorMessageCallbackIF {
public:
    virtual ~AVM3_ErrorMessageCallbackIF() {}

    virtual void onAVM3_ErrorMessageError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ErrorMessageError >& error) = 0;

    virtual void onAVM3_ErrorMessageStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ErrorMessageStatus >& status) = 0;
};

class AVM3_GetCommunicationErrorsCallbackIF {
public:
    virtual ~AVM3_GetCommunicationErrorsCallbackIF() {}

    virtual void onAVM3_GetCommunicationErrorsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_GetCommunicationErrorsError >& error) = 0;

    virtual void onAVM3_GetCommunicationErrorsResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_GetCommunicationErrorsResult >& result) = 0;
};

class AVM3_GetVersionInfoCallbackIF {
public:
    virtual ~AVM3_GetVersionInfoCallbackIF() {}

    virtual void onAVM3_GetVersionInfoError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_GetVersionInfoError >& error) = 0;

    virtual void onAVM3_GetVersionInfoResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_GetVersionInfoResult >& result) = 0;
};

class AVM3_Hardware_VersionCallbackIF {
public:
    virtual ~AVM3_Hardware_VersionCallbackIF() {}

    virtual void onAVM3_Hardware_VersionError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Hardware_VersionError >& error) = 0;

    virtual void onAVM3_Hardware_VersionStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Hardware_VersionStatus >& status) = 0;
};

class AVM3_SetSonarBuzzerStatusCallbackIF {
public:
    virtual ~AVM3_SetSonarBuzzerStatusCallbackIF() {}

    virtual void onAVM3_SetSonarBuzzerStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_SetSonarBuzzerStatusError >& error) = 0;

    virtual void onAVM3_SetSonarBuzzerStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_SetSonarBuzzerStatusResult >& result) = 0;
};

class AVM3_SetSwitchCallbackIF {
public:
    virtual ~AVM3_SetSwitchCallbackIF() {}

    virtual void onAVM3_SetSwitchError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_SetSwitchError >& error) = 0;

    virtual void onAVM3_SetSwitchResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_SetSwitchResult >& result) = 0;
};

class AVM3_Settings_DetailedCallbackIF {
public:
    virtual ~AVM3_Settings_DetailedCallbackIF() {}

    virtual void onAVM3_Settings_DetailedError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_DetailedError >& error) = 0;

    virtual void onAVM3_Settings_DetailedStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_DetailedStatus >& status) = 0;
};

class AVM3_Settings_Detailed_SendReqCallbackIF {
public:
    virtual ~AVM3_Settings_Detailed_SendReqCallbackIF() {}

    virtual void onAVM3_Settings_Detailed_SendReqError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_Detailed_SendReqError >& error) = 0;

    virtual void onAVM3_Settings_Detailed_SendReqResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_Detailed_SendReqResult >& result) = 0;
};

class AVM3_Settings_PrimaryCallbackIF {
public:
    virtual ~AVM3_Settings_PrimaryCallbackIF() {}

    virtual void onAVM3_Settings_PrimaryError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_PrimaryError >& error) = 0;

    virtual void onAVM3_Settings_PrimaryStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_PrimaryStatus >& status) = 0;
};

class AVM3_Settings_Primary_SendReqCallbackIF {
public:
    virtual ~AVM3_Settings_Primary_SendReqCallbackIF() {}

    virtual void onAVM3_Settings_Primary_SendReqError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_Primary_SendReqError >& error) = 0;

    virtual void onAVM3_Settings_Primary_SendReqResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Settings_Primary_SendReqResult >& result) = 0;
};

class AVM3_Software_VersionCallbackIF {
public:
    virtual ~AVM3_Software_VersionCallbackIF() {}

    virtual void onAVM3_Software_VersionError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Software_VersionError >& error) = 0;

    virtual void onAVM3_Software_VersionStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_Software_VersionStatus >& status) = 0;
};

class AVM3_SonarBuzzerStatusCallbackIF {
public:
    virtual ~AVM3_SonarBuzzerStatusCallbackIF() {}

    virtual void onAVM3_SonarBuzzerStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_SonarBuzzerStatusError >& error) = 0;

    virtual void onAVM3_SonarBuzzerStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_SonarBuzzerStatusStatus >& status) = 0;
};

class AVM3_ViewSetupCallbackIF {
public:
    virtual ~AVM3_ViewSetupCallbackIF() {}

    virtual void onAVM3_ViewSetupError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ViewSetupError >& error) = 0;

    virtual void onAVM3_ViewSetupStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AVM3_ViewSetupStatus >& status) = 0;
};

class Affordable_ITSCallbackIF {
public:
    virtual ~Affordable_ITSCallbackIF() {}

    virtual void onAffordable_ITSError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_ITSError >& error) = 0;

    virtual void onAffordable_ITSStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_ITSStatus >& status) = 0;
};

class Affordable_Its_SetupBswCallbackIF {
public:
    virtual ~Affordable_Its_SetupBswCallbackIF() {}

    virtual void onAffordable_Its_SetupBswError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_Its_SetupBswError >& error) = 0;

    virtual void onAffordable_Its_SetupBswResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_Its_SetupBswResult >& result) = 0;
};

class Affordable_Its_SetupLdwCallbackIF {
public:
    virtual ~Affordable_Its_SetupLdwCallbackIF() {}

    virtual void onAffordable_Its_SetupLdwError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_Its_SetupLdwError >& error) = 0;

    virtual void onAffordable_Its_SetupLdwResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_Its_SetupLdwResult >& result) = 0;
};

class Affordable_Its_SetupModCallbackIF {
public:
    virtual ~Affordable_Its_SetupModCallbackIF() {}

    virtual void onAffordable_Its_SetupModError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_Its_SetupModError >& error) = 0;

    virtual void onAffordable_Its_SetupModResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Affordable_Its_SetupModResult >& result) = 0;
};

class AvmR_Current_ViewCallbackIF {
public:
    virtual ~AvmR_Current_ViewCallbackIF() {}

    virtual void onAvmR_Current_ViewError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AvmR_Current_ViewError >& error) = 0;

    virtual void onAvmR_Current_ViewStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< AvmR_Current_ViewStatus >& status) = 0;
};

class CANFrameStatusCallbackIF {
public:
    virtual ~CANFrameStatusCallbackIF() {}

    virtual void onCANFrameStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< CANFrameStatusError >& error) = 0;

    virtual void onCANFrameStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< CANFrameStatusStatus >& status) = 0;
};

class CameraButtonCallbackIF {
public:
    virtual ~CameraButtonCallbackIF() {}

    virtual void onCameraButtonError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< CameraButtonError >& error) = 0;

    virtual void onCameraButtonResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< CameraButtonResult >& result) = 0;
};

class Camera_PwrSupplyStatusCallbackIF {
public:
    virtual ~Camera_PwrSupplyStatusCallbackIF() {}

    virtual void onCamera_PwrSupplyStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Camera_PwrSupplyStatusError >& error) = 0;

    virtual void onCamera_PwrSupplyStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Camera_PwrSupplyStatusStatus >& status) = 0;
};

class Camera_SetupBeepCallbackIF {
public:
    virtual ~Camera_SetupBeepCallbackIF() {}

    virtual void onCamera_SetupBeepError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Camera_SetupBeepError >& error) = 0;

    virtual void onCamera_SetupBeepResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Camera_SetupBeepResult >& result) = 0;
};

class ChangeViewRequestCallbackIF {
public:
    virtual ~ChangeViewRequestCallbackIF() {}

    virtual void onChangeViewRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ChangeViewRequestError >& error) = 0;

    virtual void onChangeViewRequestResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ChangeViewRequestResult >& result) = 0;
};

class ConfirmSystemStatusCallbackIF {
public:
    virtual ~ConfirmSystemStatusCallbackIF() {}

    virtual void onConfirmSystemStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ConfirmSystemStatusError >& error) = 0;

    virtual void onConfirmSystemStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ConfirmSystemStatusResult >& result) = 0;
};

class FAPGuidanceStateCallbackIF {
public:
    virtual ~FAPGuidanceStateCallbackIF() {}

    virtual void onFAPGuidanceStateError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAPGuidanceStateError >& error) = 0;

    virtual void onFAPGuidanceStateStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAPGuidanceStateStatus >& status) = 0;
};

class FAPModeCallbackIF {
public:
    virtual ~FAPModeCallbackIF() {}

    virtual void onFAPModeError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAPModeError >& error) = 0;

    virtual void onFAPModeStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAPModeStatus >& status) = 0;
};

class FAPSettingsCallbackIF {
public:
    virtual ~FAPSettingsCallbackIF() {}

    virtual void onFAPSettingsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAPSettingsError >& error) = 0;

    virtual void onFAPSettingsStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAPSettingsStatus >& status) = 0;
};

class FAP_SetButtonCallbackIF {
public:
    virtual ~FAP_SetButtonCallbackIF() {}

    virtual void onFAP_SetButtonError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAP_SetButtonError >& error) = 0;

    virtual void onFAP_SetButtonResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FAP_SetButtonResult >& result) = 0;
};

class FapLearnParkPositionCallbackIF {
public:
    virtual ~FapLearnParkPositionCallbackIF() {}

    virtual void onFapLearnParkPositionError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FapLearnParkPositionError >& error) = 0;

    virtual void onFapLearnParkPositionResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< FapLearnParkPositionResult >& result) = 0;
};

class GPSInfoCallbackIF {
public:
    virtual ~GPSInfoCallbackIF() {}

    virtual void onGPSInfoError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GPSInfoError >& error) = 0;

    virtual void onGPSInfoResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GPSInfoResult >& result) = 0;
};

class GdlAdj_AdjustButtonCallbackIF {
public:
    virtual ~GdlAdj_AdjustButtonCallbackIF() {}

    virtual void onGdlAdj_AdjustButtonError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_AdjustButtonError >& error) = 0;

    virtual void onGdlAdj_AdjustButtonResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_AdjustButtonResult >& result) = 0;
};

class GdlAdj_AdjustmentCompleteCallbackIF {
public:
    virtual ~GdlAdj_AdjustmentCompleteCallbackIF() {}

    virtual void onGdlAdj_AdjustmentCompleteError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_AdjustmentCompleteError >& error) = 0;

    virtual void onGdlAdj_AdjustmentCompleteResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_AdjustmentCompleteResult >& result) = 0;
};

class GdlAdj_CameraAngleCallbackIF {
public:
    virtual ~GdlAdj_CameraAngleCallbackIF() {}

    virtual void onGdlAdj_CameraAngleError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_CameraAngleError >& error) = 0;

    virtual void onGdlAdj_CameraAngleStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_CameraAngleStatus >& status) = 0;
};

class GdlAdj_ConfigurationDataCallbackIF {
public:
    virtual ~GdlAdj_ConfigurationDataCallbackIF() {}

    virtual void onGdlAdj_ConfigurationDataError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_ConfigurationDataError >& error) = 0;

    virtual void onGdlAdj_ConfigurationDataResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_ConfigurationDataResult >& result) = 0;
};

class GdlAdj_SteeringAngleCallbackIF {
public:
    virtual ~GdlAdj_SteeringAngleCallbackIF() {}

    virtual void onGdlAdj_SteeringAngleError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_SteeringAngleError >& error) = 0;

    virtual void onGdlAdj_SteeringAngleStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< GdlAdj_SteeringAngleStatus >& status) = 0;
};

class IPAConfigurationCallbackIF {
public:
    virtual ~IPAConfigurationCallbackIF() {}

    virtual void onIPAConfigurationError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAConfigurationError >& error) = 0;

    virtual void onIPAConfigurationStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAConfigurationStatus >& status) = 0;
};

class IPADirectionIndicatorCallbackIF {
public:
    virtual ~IPADirectionIndicatorCallbackIF() {}

    virtual void onIPADirectionIndicatorError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPADirectionIndicatorError >& error) = 0;

    virtual void onIPADirectionIndicatorStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPADirectionIndicatorStatus >& status) = 0;
};

class IPAMessageRequestCallbackIF {
public:
    virtual ~IPAMessageRequestCallbackIF() {}

    virtual void onIPAMessageRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAMessageRequestError >& error) = 0;

    virtual void onIPAMessageRequestStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAMessageRequestStatus >& status) = 0;
};

class IPAPatternRequestCallbackIF {
public:
    virtual ~IPAPatternRequestCallbackIF() {}

    virtual void onIPAPatternRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAPatternRequestError >& error) = 0;

    virtual void onIPAPatternRequestStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAPatternRequestStatus >& status) = 0;
};

class IPAStatusCallbackIF {
public:
    virtual ~IPAStatusCallbackIF() {}

    virtual void onIPAStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAStatusError >& error) = 0;

    virtual void onIPAStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPAStatusStatus >& status) = 0;
};

class IPASwitchGreyOutRequestCallbackIF {
public:
    virtual ~IPASwitchGreyOutRequestCallbackIF() {}

    virtual void onIPASwitchGreyOutRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPASwitchGreyOutRequestError >& error) = 0;

    virtual void onIPASwitchGreyOutRequestStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPASwitchGreyOutRequestStatus >& status) = 0;
};

class IPASwitchMaskRequestCallbackIF {
public:
    virtual ~IPASwitchMaskRequestCallbackIF() {}

    virtual void onIPASwitchMaskRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPASwitchMaskRequestError >& error) = 0;

    virtual void onIPASwitchMaskRequestStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPASwitchMaskRequestStatus >& status) = 0;
};

class IPA_SetButtonCallbackIF {
public:
    virtual ~IPA_SetButtonCallbackIF() {}

    virtual void onIPA_SetButtonError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPA_SetButtonError >& error) = 0;

    virtual void onIPA_SetButtonResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPA_SetButtonResult >& result) = 0;
};

class IPA_SetHMIStatusCallbackIF {
public:
    virtual ~IPA_SetHMIStatusCallbackIF() {}

    virtual void onIPA_SetHMIStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPA_SetHMIStatusError >& error) = 0;

    virtual void onIPA_SetHMIStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPA_SetHMIStatusResult >& result) = 0;
};

class IPA_Voice_TextsCallbackIF {
public:
    virtual ~IPA_Voice_TextsCallbackIF() {}

    virtual void onIPA_Voice_TextsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPA_Voice_TextsError >& error) = 0;

    virtual void onIPA_Voice_TextsResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< IPA_Voice_TextsResult >& result) = 0;
};

class InitializeCallbackIF {
public:
    virtual ~InitializeCallbackIF() {}

    virtual void onInitializeError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< InitializeError >& error) = 0;

    virtual void onInitializeResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< InitializeResult >& result) = 0;
};

class MVC_HMI_ViewRequestCallbackIF {
public:
    virtual ~MVC_HMI_ViewRequestCallbackIF() {}

    virtual void onMVC_HMI_ViewRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MVC_HMI_ViewRequestError >& error) = 0;

    virtual void onMVC_HMI_ViewRequestResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MVC_HMI_ViewRequestResult >& result) = 0;
};

class MapMatchedInfoCallbackIF {
public:
    virtual ~MapMatchedInfoCallbackIF() {}

    virtual void onMapMatchedInfoError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MapMatchedInfoError >& error) = 0;

    virtual void onMapMatchedInfoResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MapMatchedInfoResult >& result) = 0;
};

class Microphone_PwrSupplyStatusCallbackIF {
public:
    virtual ~Microphone_PwrSupplyStatusCallbackIF() {}

    virtual void onMicrophone_PwrSupplyStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Microphone_PwrSupplyStatusError >& error) = 0;

    virtual void onMicrophone_PwrSupplyStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Microphone_PwrSupplyStatusStatus >& status) = 0;
};

class MvcAlertRequestCallbackIF {
public:
    virtual ~MvcAlertRequestCallbackIF() {}

    virtual void onMvcAlertRequestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MvcAlertRequestError >& error) = 0;

    virtual void onMvcAlertRequestStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MvcAlertRequestStatus >& status) = 0;
};

class MvcViewStatusCallbackIF {
public:
    virtual ~MvcViewStatusCallbackIF() {}

    virtual void onMvcViewStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MvcViewStatusError >& error) = 0;

    virtual void onMvcViewStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< MvcViewStatusStatus >& status) = 0;
};

class ReverseSignalStatusCallbackIF {
public:
    virtual ~ReverseSignalStatusCallbackIF() {}

    virtual void onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ReverseSignalStatusError >& error) = 0;

    virtual void onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status) = 0;
};

class RunExtDevicePowerSupplyTestCallbackIF {
public:
    virtual ~RunExtDevicePowerSupplyTestCallbackIF() {}

    virtual void onRunExtDevicePowerSupplyTestError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< RunExtDevicePowerSupplyTestError >& error) = 0;

    virtual void onRunExtDevicePowerSupplyTestResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< RunExtDevicePowerSupplyTestResult >& result) = 0;
};

class SetCamerastateCallbackIF {
public:
    virtual ~SetCamerastateCallbackIF() {}

    virtual void onSetCamerastateError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetCamerastateError >& error) = 0;

    virtual void onSetCamerastateResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetCamerastateResult >& result) = 0;
};

class SetFapGuidanceCallbackIF {
public:
    virtual ~SetFapGuidanceCallbackIF() {}

    virtual void onSetFapGuidanceError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetFapGuidanceError >& error) = 0;

    virtual void onSetFapGuidanceResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetFapGuidanceResult >& result) = 0;
};

class SetMicrophoneStateCallbackIF {
public:
    virtual ~SetMicrophoneStateCallbackIF() {}

    virtual void onSetMicrophoneStateError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetMicrophoneStateError >& error) = 0;

    virtual void onSetMicrophoneStateResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetMicrophoneStateResult >& result) = 0;
};

class SetRVCStatusCallbackIF {
public:
    virtual ~SetRVCStatusCallbackIF() {}

    virtual void onSetRVCStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetRVCStatusError >& error) = 0;

    virtual void onSetRVCStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetRVCStatusResult >& result) = 0;
};

class SetStatusHmiCallbackIF {
public:
    virtual ~SetStatusHmiCallbackIF() {}

    virtual void onSetStatusHmiError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetStatusHmiError >& error) = 0;

    virtual void onSetStatusHmiResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetStatusHmiResult >& result) = 0;
};

class SetSystemStatusCallbackIF {
public:
    virtual ~SetSystemStatusCallbackIF() {}

    virtual void onSetSystemStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetSystemStatusError >& error) = 0;

    virtual void onSetSystemStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetSystemStatusResult >& result) = 0;
};

class SetupGuideLineCallbackIF {
public:
    virtual ~SetupGuideLineCallbackIF() {}

    virtual void onSetupGuideLineError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupGuideLineError >& error) = 0;

    virtual void onSetupGuideLineResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupGuideLineResult >& result) = 0;
};

class SetupLanguageCallbackIF {
public:
    virtual ~SetupLanguageCallbackIF() {}

    virtual void onSetupLanguageError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupLanguageError >& error) = 0;

    virtual void onSetupLanguageResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupLanguageResult >& result) = 0;
};

class SetupUserConfigurationCallbackIF {
public:
    virtual ~SetupUserConfigurationCallbackIF() {}

    virtual void onSetupUserConfigurationError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupUserConfigurationError >& error) = 0;

    virtual void onSetupUserConfigurationResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupUserConfigurationResult >& result) = 0;
};

class SetupVideoControlsCallbackIF {
public:
    virtual ~SetupVideoControlsCallbackIF() {}

    virtual void onSetupVideoControlsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupVideoControlsError >& error) = 0;

    virtual void onSetupVideoControlsResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupVideoControlsResult >& result) = 0;
};

class SystemConfigurationsCallbackIF {
public:
    virtual ~SystemConfigurationsCallbackIF() {}

    virtual void onSystemConfigurationsError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SystemConfigurationsError >& error) = 0;

    virtual void onSystemConfigurationsStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SystemConfigurationsStatus >& status) = 0;
};

class SystemStatusCallbackIF {
public:
    virtual ~SystemStatusCallbackIF() {}

    virtual void onSystemStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SystemStatusError >& error) = 0;

    virtual void onSystemStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SystemStatusStatus >& status) = 0;
};

class Tailgate_StatusCallbackIF {
public:
    virtual ~Tailgate_StatusCallbackIF() {}

    virtual void onTailgate_StatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Tailgate_StatusError >& error) = 0;

    virtual void onTailgate_StatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< Tailgate_StatusStatus >& status) = 0;
};

class ToggleGpioPinOnOffCallbackIF {
public:
    virtual ~ToggleGpioPinOnOffCallbackIF() {}

    virtual void onToggleGpioPinOnOffError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ToggleGpioPinOnOffError >& error) = 0;

    virtual void onToggleGpioPinOnOffResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ToggleGpioPinOnOffResult >& result) = 0;
};

class TouchEventCallbackIF {
public:
    virtual ~TouchEventCallbackIF() {}

    virtual void onTouchEventError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< TouchEventError >& error) = 0;

    virtual void onTouchEventResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< TouchEventResult >& result) = 0;
};

class VideoSignalStatusCallbackIF {
public:
    virtual ~VideoSignalStatusCallbackIF() {}

    virtual void onVideoSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< VideoSignalStatusError >& error) = 0;

    virtual void onVideoSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< VideoSignalStatusStatus >& status) = 0;
};

class View_Close_AuthorizedCallbackIF {
public:
    virtual ~View_Close_AuthorizedCallbackIF() {}

    virtual void onView_Close_AuthorizedError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< View_Close_AuthorizedError >& error) = 0;

    virtual void onView_Close_AuthorizedStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< View_Close_AuthorizedStatus >& status) = 0;
};

class Rvc_cca_fiProxyCallback;

/**
 * Rvc_cca_fiProxy is the client side representation of the CCA Functional
 * Interface 'rvc_cca_fi' (specified in file rvc_cca_fi.xml).
 *
 * CCA Functional Interface 'rvc_cca_fi'
 *
 * Fullname: RVC CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.0.0  $
 *
 * Author: Niemann, Wenzel
 *
 * Date: $Date:  17.04.2015  $
 *
 * Department:
 *
 * Title: rvc_cca_fi
 *
 * <b>Description of 'rvc_cca_fi':</b>
 *
 * Interface for accessing RVC (Rear View Camera), AVM (Around View Monitor), IPA (Intelligent Park Assistant), MVC (Multi View Camera) related functionalities.
 */
class Rvc_cca_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Rvc_cca_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Rvc_cca_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Rvc_cca_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Rvc_cca_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Rvc_cca_fiProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< Rvc_cca_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Rvc_cca_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Rvc_cca_fiProxy();

    // Method 'CameraButton'

    /**
     * Call the method 'CameraButton'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'CameraButton'</b>:
     *
     * To inform the vd_rvc component about user presses on the camera button within certain HMI states related to RVC/AVM.
     * <p>FUNCID = RVC_CCAFI_C_U16_CAMERABUTTON</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8ButtonState To inform about camera button state changes (pressed/released).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCameraButtonStart(CameraButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonState);

    // Method 'SetStatusHmi'

    /**
     * Call the method 'SetStatusHmi'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetStatusHmi'</b>:
     *
     * To inform the vd_rvc component about the availibilty of HMI.
     * VD_RVC will use this information to differentiate for early or normal video activation.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8StatusHmi HMI availability status.
     * If available, HMI can handle the normal RVC/AVM screen activation.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetStatusHmiStart(SetStatusHmiCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_Status e8StatusHmi);

    // Method 'SetupLanguage'

    /**
     * Call the method 'SetupLanguage'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetupLanguage'</b>:
     *
     * To inform the vd_rvc component about the Language setup done by the user.
     * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
     * <p>FUNCID = RVC_CCAFI_C_U16_SETUPLANGUAGE</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Language To set the language.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetupLanguageStart(SetupLanguageCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_Language e8Language);

    // Method 'SetupGuideLine'

    /**
     * Call the method 'SetupGuideLine'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetupGuideLine'</b>:
     *
     * To inform the vd_rvc component about the Camera visibility and GuideLine setup done by the user.
     * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
     * <p>FUNCID = RVC_CCAFI_C_U16_SETGUIDELINE</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8GuideLine Set user configuration for GuideLine visibility (ON/Off value) for both Static and Dynamic.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetupGuideLineStart(SetupGuideLineCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine);

    // Method 'SetupVideoControls'

    /**
     * Call the method 'SetupVideoControls'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetupVideoControls'</b>:
     *
     * This method is to inform the vd_rvc component about the Brightness, Contrast, Color Hue/Tint and Black Level setup for the video signal done by the user.
     * This method has to be called by HMI once after system startup and in case of a change of the setup done by the user.
     * <p>FUNCID = RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8HMIDimmingMode current HMI dimming state
     *
     * @param arVideoControlParameter List with parameters for the video analog levels to
     * set the analog levels of the video signal.
     *
     * @param e8MVCViewingState current MVC viewing state
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetupVideoControlsStart(SetupVideoControlsCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& arVideoControlParameter, ::rvc_cca_fi_types::T_e8_MVCViewingState e8MVCViewingState);

    // Method 'SetSystemStatus'

    /**
     * Call the method 'SetSystemStatus'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetSystemStatus'</b>:
     *
     * Can be used to switch ON/OFF the vision system.
     * <p>FUNCID = RVC_CCAFI_C_U16_SETSYSTEMSTATUS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8SystemStatus <p>requested activation status of the vision sytem,</p>
     * <p>only the states</p>
     * <p>"VISUALISATION_OFF",</p>
     * <p>"RVC_VISUALISATION_ON"</p>
     * <p>"AVM_VISUALISATION_ON"</p>
     * <p>"MVC_VISUALISATION_FRONT_VIEW</p>
     * <p>"MVC_VISUALISATION_REAR_VIEW"</p>
     * <p>"MVC_VISUALISATION_RIGHT_VIEW"</p>
     * <p>"MVC_VISUALISATION_LEFT_VIEW"</p>
     * <p>are supported</p>
     *
     * @param e8GuideLine With this parameter decission could be made to show the guidelines or not when visualization is requested.
     *
     * @param e8WarningText With this parameter decission could be made to show the warning text or not when visualization is requested.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetSystemStatusStart(SetSystemStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus, ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine, ::rvc_cca_fi_types::T_e8_RVC_StatusWarningText e8WarningText);

    // Method 'runExtDevicePowerSupplyTest'

    /**
     * Call the method 'runExtDevicePowerSupplyTest'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'runExtDevicePowerSupplyTest'</b>:
     *
     * If the meaning of "runExtDevicePowerSupplyTest" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param pwrSupplyID If the meaning of "pwrSupplyID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRunExtDevicePowerSupplyTestStart(RunExtDevicePowerSupplyTestCallbackIF& cb, uint16 pwrSupplyID);

    // Method 'Initialize'

    /**
     * Call the method 'Initialize'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'Initialize'</b>:
     *
     * If the meaning of "Initialize" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Module <p>Module (part odf the component) to (re)initialize</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInitializeStart(InitializeCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_Module e8Module);

    // Method 'ConfirmSystemStatus'

    /**
     * Call the method 'ConfirmSystemStatus'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ConfirmSystemStatus'</b>:
     *
     * If the meaning of "ConfirmSystemStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8SystemStatus <p>Confirm system status after each system status change.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConfirmSystemStatusStart(ConfirmSystemStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus);

    // Method 'SetupUserConfiguration'

    /**
     * Call the method 'SetupUserConfiguration'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetupUserConfiguration'</b>:
     *
     * This method is to inform the Park Assist component about user setup.
     * This method has to be called by HMI once after system start up and in case of a change of the setup done by the user.
     * On start up  the list should be filled with all relevant parameter. Later on an user change, only the current modified list entry must be filled.
     * <p>FUNCID = RVC_CCAFI_C_U16_SETUPUSERCONFIGURATION</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param arUserConfiguration List with user configuration(s) (e.g. Guideline visibility).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetupUserConfigurationStart(SetupUserConfigurationCallbackIF& cb, const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& arUserConfiguration);

    // Method 'SetMicrophoneState'

    /**
     * Call the method 'SetMicrophoneState'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetMicrophoneState'</b>:
     *
     * <p>Switches the Microphone state ON/OFF via ELMOS IC</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8RequestState Microphone new State request
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetMicrophoneStateStart(SetMicrophoneStateCallbackIF& cb, ::rvc_cca_fi_types::T_e8_Set_MicState e8RequestState);

    // Method 'SetRVCStatus'

    /**
     * Call the method 'SetRVCStatus'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'SetRVCStatus'</b>:
     *
     * <p>HMI could set the RVC Status</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8RequestState RVC new State request
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetRVCStatusStart(SetRVCStatusCallbackIF& cb, uint8 e8RequestState);

    // Method 'Camera_SetupBeep'

    /**
     * Call the method 'Camera_SetupBeep'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'Camera_SetupBeep'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_SETUPBEEP</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8SetupBeep Activate or deactivate the AVM beeps.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCamera_SetupBeepStart(Camera_SetupBeepCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVM_StatusBeep e8SetupBeep);

    // Method 'SetCamerastate'

    /**
     * Call the method 'SetCamerastate'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetCamerastate'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_SETCAMERASTATE</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param CameraState New state into RVC shall be brought.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetCamerastateStart(SetCamerastateCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_CameraState cameraState);

    // Method 'ChangeViewRequest'

    /**
     * Call the method 'ChangeViewRequest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ChangeViewRequest'</b>:
     *
     * This method has to be called by HMI to request a change in AVM View
     * <p>FUNCID = RVC_CCAFI_C_U16_CHANGE_VIEW_REQUEST</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8Status HMI should request the view selected by the User on HMI buttons.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChangeViewRequestStart(ChangeViewRequestCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVM_View_Request u8Status);

    // Method 'Affordable_Its_SetupBsw'

    /**
     * Call the method 'Affordable_Its_SetupBsw'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Affordable_Its_SetupBsw'</b>:
     *
     * This method has to be called by HMI to inform about a change in configuration for the Blind Spot Warning feature.
     * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPBSW</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8Status Depending on the required implementation the values have following meaning:
     * <p>Implementation variant 1:</p>
     * <p>0 = BSW configuration no change request</p>
     * <p>1 = BSW configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = BSW configuration change to off</p>
     * <p>1 = BSW configuration change to on</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAffordable_Its_SetupBswStart(Affordable_Its_SetupBswCallbackIF& cb, uint8 u8Status);

    // Method 'Affordable_Its_SetupMod'

    /**
     * Call the method 'Affordable_Its_SetupMod'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Affordable_Its_SetupMod'</b>:
     *
     * This method has to be called by HMI to inform about a change in configuration for the Motion Object Detection feature.
     * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPMOD</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8Status Depending on the required implementation the values have following meaning
     * <p>Implementation variant 1:</p>
     * <p>0 = MOD configuration no change request</p>
     * <p>1 = MOD configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = MOD configuration change to off</p>
     * <p>1 = MOD configuration change to on</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAffordable_Its_SetupModStart(Affordable_Its_SetupModCallbackIF& cb, uint8 u8Status);

    // Method 'Affordable_Its_SetupLdw'

    /**
     * Call the method 'Affordable_Its_SetupLdw'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Affordable_Its_SetupLdw'</b>:
     *
     * This method has to be called by HMI to inform about a change in configuration for the Lane Departure Warning feature.
     * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS_SETUPLDW</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8Status Depending on the required implementation the values have following meaning
     * <p>Implementation variant 1:</p>
     * <p>0 = LDW configuration no change request</p>
     * <p>1 = LDW configuration change request</p>
     * <p>The property Affordable_ITS reflects the current Affordable ITS configuration.</p>
     * <p></p>
     * <p>Implementation variant 2:</p>
     * <p>0 = LDW configuration change to off</p>
     * <p>1 = LDW configuration change to on</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAffordable_Its_SetupLdwStart(Affordable_Its_SetupLdwCallbackIF& cb, uint8 u8Status);

    // Method 'IPA_SetHMIStatus'

    /**
     * Call the method 'IPA_SetHMIStatus'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'IPA_SetHMIStatus'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASETHMISTATUS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8IPAStatus HMI status of IPA
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPA_SetHMIStatusStart(IPA_SetHMIStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_IPA_HMIStatus e8IPAStatus);

    // Method 'IPA_SetButton'

    /**
     * Call the method 'IPA_SetButton'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'IPA_SetButton'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASETBUTTON</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8ButtonIdentifier The identifier of the button
     *
     * @param e8ButtonStatus The status of the button
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPA_SetButtonStart(IPA_SetButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID e8ButtonIdentifier, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonStatus);

    // Method 'IPA_Voice_Texts'

    /**
     * Call the method 'IPA_Voice_Texts'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'IPA_Voice_Texts'</b>:
     *
     * <p>IPA Voice strings has to be read out in all different Languages</p>
     * <p>the text of these strings is fetched from HMI Translation table and used in TTS</p>
     * <p>FUNCID = RVC_CCAFI_C_U16_IPA_VOICE_TEXTS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param arTexts The list of the Strings for each Voice Request ID
     *
     * @param Language Current translation is for this language
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPA_Voice_TextsStart(IPA_Voice_TextsCallbackIF& cb, const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& arTexts, ::rvc_cca_fi_types::T_e8_RVC_Language language);

    // Method 'MVC_HMI_ViewRequest'

    /**
     * Call the method 'MVC_HMI_ViewRequest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'MVC_HMI_ViewRequest'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_MVC_HMI_VIEWREQUEST</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Request MVC View Request from HMI
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMVC_HMI_ViewRequestStart(MVC_HMI_ViewRequestCallbackIF& cb, ::rvc_cca_fi_types::T_e8_MVCViewingState e8Request);

    // Method 'GdlAdj_AdjustmentComplete'

    /**
     * Call the method 'GdlAdj_AdjustmentComplete'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_AdjustmentComplete'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTMENTCOMPLETE</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Completion to inform about the completion action
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGdlAdj_AdjustmentCompleteStart(GdlAdj_AdjustmentCompleteCallbackIF& cb, ::rvc_cca_fi_types::T_e8_GdlAdj_Completion e8Completion);

    // Method 'GdlAdj_AdjustButton'

    /**
     * Call the method 'GdlAdj_AdjustButton'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_AdjustButton'</b>:
     *
     * This method has to be called by HMI to inform about a button press in Guideline Adjustment Screen.
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_ADJUSTBUTTON</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Button to inform about a Adjust Button press
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGdlAdj_AdjustButtonStart(GdlAdj_AdjustButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton e8Button);

    // Method 'GdlAdj_ConfigurationData'

    /**
     * Call the method 'GdlAdj_ConfigurationData'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_ConfigurationData'</b>:
     *
     * Method to get, to get all or to set configuration value(s).
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CONFIGURATIONDATA</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Request <p>In case of GET_ALL request, the Item/Value pair list should be not filled (is "empty" by default).</p>
     * <p>In case of GET, the value of the Item/Value pair should be not set (is "0.0" by default).</p>
     *
     * @param arConfigParameterData List with parameter data (Item/Value pair(s)).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGdlAdj_ConfigurationDataStart(GdlAdj_ConfigurationDataCallbackIF& cb, ::rvc_cca_fi_types::T_e8_GdlAdj_Request e8Request, const ::std::vector< ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData >& arConfigParameterData);

    // Method 'FAP_SetButton'

    /**
     * Call the method 'FAP_SetButton'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'FAP_SetButton'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_FAP_SETBUTTON</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8ButtonIdentifier The identifier of the button
     *
     * @param e8ButtonStatus The status of the button
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFAP_SetButtonStart(FAP_SetButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID e8ButtonIdentifier, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonStatus);

    // Method 'TouchEvent'

    /**
     * Call the method 'TouchEvent'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'TouchEvent'</b>:
     *
     * <p>Touch events detected on HMI are sent to Middleware needed for Full Auto Parking</p>
     * <p>this might not be used at all due to the latency requirements for FAP</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param arTouchData Every touch detected in HMI should have this data
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTouchEventStart(TouchEventCallbackIF& cb, const ::rvc_cca_fi_types::T_Touch_Data& arTouchData);

    // Method 'GPSInfo'

    /**
     * Call the method 'GPSInfo'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'GPSInfo'</b>:
     *
     * <p>GPS Data received from Navi Client used for FAP only</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param arGpsData Every GPS Data (relevant according to the "T_GPS_Data" structure) received from Navi
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGPSInfoStart(GPSInfoCallbackIF& cb, const ::rvc_cca_fi_types::T_GPS_Data& arGpsData);

    // Method 'MapMatchedInfo'

    /**
     * Call the method 'MapMatchedInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'MapMatchedInfo'</b>:
     *
     * <p>Map Matched Data calculated by Navi for every GPS data received used for FAP only</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param arMapMatchedData Every Map Matched Data (relevant according to the "T_MapMatched_Data" structure) received from Navi
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapMatchedInfoStart(MapMatchedInfoCallbackIF& cb, const ::rvc_cca_fi_types::T_MapMatched_Data& arMapMatchedData);

    // Method 'FapLearnParkPosition'

    /**
     * Call the method 'FapLearnParkPosition'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'FapLearnParkPosition'</b>:
     *
     * <p>HMI Requests to begin Learning of the Parking Position to be sent to FAP (AVM) unit</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param RequestOn When requesting for Start learning of the Parking Position this should be sent as True, otherwise, False
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFapLearnParkPositionStart(FapLearnParkPositionCallbackIF& cb, bool requestOn);

    // Method 'SetFapGuidance'

    /**
     * Call the method 'SetFapGuidance'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SetFapGuidance'</b>:
     *
     * <p>HMI Requests to set the Fap Guidance On/Off</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Request Set the FAP guidance is On or Off from System Settings
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFapGuidanceStart(SetFapGuidanceCallbackIF& cb, bool request);

    // Method 'AVM3_SetSwitch'

    /**
     * Call the method 'AVM3_SetSwitch'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AVM3_SetSwitch'</b>:
     *
     * This method serves to send a key/switch/touch button event to the AVM phase3.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETSWITCH</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8SwitchId The identifier of the switch or touch button which was actuated or pressed
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_SetSwitchStart(AVM3_SetSwitchCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_SwitchId e8SwitchId);

    // Method 'AVM3_SetSonarBuzzerStatus'

    /**
     * Call the method 'AVM3_SetSonarBuzzerStatus'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AVM3_SetSonarBuzzerStatus'</b>:
     *
     * This method serves to send a request to the AVM phase3 to change the Sonar Buzzer ON/OFF state.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETSONARBUZZERSTATUS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8BuzzerStatus <p>0 = Buzzer setting OFF / 1 = Buzzer setting ON</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_SetSonarBuzzerStatusStart(AVM3_SetSonarBuzzerStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus e8BuzzerStatus);

    // Method 'AVM3_Settings_Detailed_SendReq'

    /**
     * Call the method 'AVM3_Settings_Detailed_SendReq'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Settings_Detailed_SendReq'</b>:
     *
     * This method serves to send a request to the AVM phase3 to either send the current states/values of all its
     * settings items, or to change the state/value of one or more of them.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED_SENDREQ</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8RequestType <p>In the case of a 'Get' request, the parameter arChangedItems is not evaluated and can be set to an empty list.</p>
     * <p>In the case of a 'Set' request, it specifies the settings items to update/change.</p>
     * <p>In both cases, a AVM3_Settings_Detailed.Status message will be sent once the AVM phase3 ECU has responded.</p>
     *
     * @param arChangedItems List of camera settings items to be changed/updated
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_Settings_Detailed_SendReqStart(AVM3_Settings_Detailed_SendReqCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_RequestType e8RequestType, const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Item >& arChangedItems);

    // Method 'AVM3_Settings_Primary_SendReq'

    /**
     * Call the method 'AVM3_Settings_Primary_SendReq'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Settings_Primary_SendReq'</b>:
     *
     * This method serves to send a request to the AVM phase3 either to send the current states of the
     * settings items on the camera primary settings screen, or to set new states.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY_SENDREQ</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8RequestType <p>In the case of a 'Get' request, the remaining parameters are not evaluated and can be set to zeroes.</p>
     * <p>In the case of a 'Set' request, they must all be set to the values to be sent to the AVM phase3 ECU.</p>
     * <p>In both cases, a AVM3_Settings_Primary.Status message will be sent once the AVM phase3 ECU has responded.</p>
     *
     * @param e8AvmSonarBuzzer Unavailable/OFF/ON state of the AVM Sonar Buzzer setting.
     *
     * @param bDetailsSettingsAvail <p>FALSE/TRUE = Details Settings unavailable / available</p>
     *
     * @param bImageQualitySettingAvail <p>FALSE/TRUE = Image Quality Settings unavailable / available</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_Settings_Primary_SendReqStart(AVM3_Settings_Primary_SendReqCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_RequestType e8RequestType, ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, bool bDetailsSettingsAvail, bool bImageQualitySettingAvail);

    // Method 'AVM3_GetVersionInfo'

    /**
     * Call the method 'AVM3_GetVersionInfo'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'AVM3_GetVersionInfo'</b>:
     *
     * This method serves to retrieve hardware or/and software version information from the AVM phase3 ECU.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_GETVERSIONINFO</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8VersionType Specifies which type of version info to request from the AVM phase3 ECU (HW, SW, or both).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_GetVersionInfoStart(AVM3_GetVersionInfoCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_VersionInfoType e8VersionType);

    // Method 'AVM3_GetCommunicationErrors'

    /**
     * Call the method 'AVM3_GetCommunicationErrors'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AVM3_GetCommunicationErrors'</b>:
     *
     * This method serves to reques the MCAN communication error parameters from the AVM phase3 ECU.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_GETCOMMUNICATIONERRORS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_GetCommunicationErrorsStart(AVM3_GetCommunicationErrorsCallbackIF& cb);

    // Method 'AVM3_ClearCommunicationErrors'

    /**
     * Call the method 'AVM3_ClearCommunicationErrors'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'AVM3_ClearCommunicationErrors'</b>:
     *
     * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CLEARCOMMUNICATIONERRORS</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_ClearCommunicationErrorsStart(AVM3_ClearCommunicationErrorsCallbackIF& cb);

    // Method 'ToggleGpioPinOnOff'

    /**
     * Call the method 'ToggleGpioPinOnOff'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ToggleGpioPinOnOff'</b>:
     *
     * This method serves to clear the MCAN communication error parameters in the AVM phase3 ECU.
     * <p>FUNCID = RVC_CCAFI_C_U16_TOGGLEGPIOPINONOFF</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendToggleGpioPinOnOffStart(ToggleGpioPinOnOffCallbackIF& cb);

    // Property 'SystemConfigurations'

    /**
     * Notify on the property 'SystemConfigurations'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SystemConfigurations'</b>:
     *
     * Information about configurations which are relevant for the Rear and Around View vision system.
     * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemConfigurationsUpReg(SystemConfigurationsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SystemConfigurations'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SystemConfigurations'</b>:
     *
     * Information about configurations which are relevant for the Rear and Around View vision system.
     * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMCONFIGURATIONS</p>
     *
     * @param act The act which was previously returned by the
     * sendSystemConfigurationsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSystemConfigurationsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SystemConfigurations'.
     */
    void sendSystemConfigurationsRelUpRegAll ();

    /**
     * Returns the current value of the property 'SystemConfigurations' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSystemConfigurations() returns true.
     *
     * @return the previously received value of the property 'SystemConfigurations'.
     */
    const SystemConfigurationsStatus& getSystemConfigurations() const;

    /**
     * Determines whether a status message for the property 'SystemConfigurations' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSystemConfigurations() const;

    // Property 'SystemStatus'

    /**
     * Notify on the property 'SystemStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SystemStatus'</b>:
     *
     * Gives the information about the activation state of the vision system.
     * <p>Client application should use the following parameters :</p>
     * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMSTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSystemStatusUpReg(SystemStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SystemStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SystemStatus'</b>:
     *
     * Gives the information about the activation state of the vision system.
     * <p>Client application should use the following parameters :</p>
     * <p>FUNCID = RVC_CCAFI_C_U16_SYSTEMSTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendSystemStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSystemStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SystemStatus'.
     */
    void sendSystemStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'SystemStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSystemStatus() returns true.
     *
     * @return the previously received value of the property 'SystemStatus'.
     */
    const SystemStatusStatus& getSystemStatus() const;

    /**
     * Determines whether a status message for the property 'SystemStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSystemStatus() const;

    // Property 'VideoSignalStatus'

    /**
     * Notify on the property 'VideoSignalStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'VideoSignalStatus'</b>:
     *
     * This Property informs about the video signal state after RVC/AVM visualisation was requested.
     * <p>FUNCID = RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVideoSignalStatusUpReg(VideoSignalStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'VideoSignalStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'VideoSignalStatus'</b>:
     *
     * This Property informs about the video signal state after RVC/AVM visualisation was requested.
     * <p>FUNCID = RVC_CCAFI_C_U16_VIDEOSIGNALSTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendVideoSignalStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendVideoSignalStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'VideoSignalStatus'.
     */
    void sendVideoSignalStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'VideoSignalStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasVideoSignalStatus() returns true.
     *
     * @return the previously received value of the property 'VideoSignalStatus'.
     */
    const VideoSignalStatusStatus& getVideoSignalStatus() const;

    /**
     * Determines whether a status message for the property 'VideoSignalStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVideoSignalStatus() const;

    // Property 'ReverseSignalStatus'

    /**
     * Notify on the property 'ReverseSignalStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'ReverseSignalStatus'</b>:
     *
     * This Property informs about the reverse signal state.
     * <p>FUNCID = RVC_CCAFI_C_U16_REVERSESIGNALSTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReverseSignalStatusUpReg(ReverseSignalStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'ReverseSignalStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'ReverseSignalStatus'</b>:
     *
     * This Property informs about the reverse signal state.
     * <p>FUNCID = RVC_CCAFI_C_U16_REVERSESIGNALSTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendReverseSignalStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendReverseSignalStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'ReverseSignalStatus'.
     */
    void sendReverseSignalStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'ReverseSignalStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasReverseSignalStatus() returns true.
     *
     * @return the previously received value of the property 'ReverseSignalStatus'.
     */
    const ReverseSignalStatusStatus& getReverseSignalStatus() const;

    /**
     * Determines whether a status message for the property 'ReverseSignalStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasReverseSignalStatus() const;

    // Property 'Camera_PwrSupplyStatus'

    /**
     * Notify on the property 'Camera_PwrSupplyStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Camera_PwrSupplyStatus'</b>:
     *
     * This Property informs about the current Camera State (used mainly by Diagnosis)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCamera_PwrSupplyStatusUpReg(Camera_PwrSupplyStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Camera_PwrSupplyStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Camera_PwrSupplyStatus'</b>:
     *
     * This Property informs about the current Camera State (used mainly by Diagnosis)
     *
     * @param act The act which was previously returned by the
     * sendCamera_PwrSupplyStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCamera_PwrSupplyStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Camera_PwrSupplyStatus'.
     */
    void sendCamera_PwrSupplyStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'Camera_PwrSupplyStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasCamera_PwrSupplyStatus() returns true.
     *
     * @return the previously received value of the property 'Camera_PwrSupplyStatus'.
     */
    const Camera_PwrSupplyStatusStatus& getCamera_PwrSupplyStatus() const;

    /**
     * Determines whether a status message for the property 'Camera_PwrSupplyStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCamera_PwrSupplyStatus() const;

    /**
     * Request the value of the property 'Camera_PwrSupplyStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Camera_PwrSupplyStatus'</b>:
     *
     * This Property informs about the current Camera State (used mainly by Diagnosis)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCamera_PwrSupplyStatusGet(Camera_PwrSupplyStatusCallbackIF& cb);

    // Property 'Microphone_PwrSupplyStatus'

    /**
     * Notify on the property 'Microphone_PwrSupplyStatus'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Microphone_PwrSupplyStatus'</b>:
     *
     * This Property informs about the current Microphone State (used mainly by Diagnosis)
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMicrophone_PwrSupplyStatusUpReg(Microphone_PwrSupplyStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Microphone_PwrSupplyStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Microphone_PwrSupplyStatus'</b>:
     *
     * This Property informs about the current Microphone State (used mainly by Diagnosis)
     *
     * @param act The act which was previously returned by the
     * sendMicrophone_PwrSupplyStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMicrophone_PwrSupplyStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Microphone_PwrSupplyStatus'.
     */
    void sendMicrophone_PwrSupplyStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'Microphone_PwrSupplyStatus'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasMicrophone_PwrSupplyStatus() returns true.
     *
     * @return the previously received value of the property 'Microphone_PwrSupplyStatus'.
     */
    const Microphone_PwrSupplyStatusStatus& getMicrophone_PwrSupplyStatus() const;

    /**
     * Determines whether a status message for the property 'Microphone_PwrSupplyStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMicrophone_PwrSupplyStatus() const;

    /**
     * Request the value of the property 'Microphone_PwrSupplyStatus' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Microphone_PwrSupplyStatus'</b>:
     *
     * This Property informs about the current Microphone State (used mainly by Diagnosis)
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMicrophone_PwrSupplyStatusGet(Microphone_PwrSupplyStatusCallbackIF& cb);

    // Property 'Tailgate_Status'

    /**
     * Notify on the property 'Tailgate_Status'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Tailgate_Status'</b>:
     *
     * This Property informs about the current Tailgate State
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTailgate_StatusUpReg(Tailgate_StatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Tailgate_Status'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Tailgate_Status'</b>:
     *
     * This Property informs about the current Tailgate State
     *
     * @param act The act which was previously returned by the
     * sendTailgate_StatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTailgate_StatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Tailgate_Status'.
     */
    void sendTailgate_StatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'Tailgate_Status' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTailgate_Status() returns true.
     *
     * @return the previously received value of the property 'Tailgate_Status'.
     */
    const Tailgate_StatusStatus& getTailgate_Status() const;

    /**
     * Determines whether a status message for the property 'Tailgate_Status' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTailgate_Status() const;

    /**
     * Request the value of the property 'Tailgate_Status' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Tailgate_Status'</b>:
     *
     * This Property informs about the current Tailgate State
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTailgate_StatusGet(Tailgate_StatusCallbackIF& cb);

    // Property 'View_Close_Authorized'

    /**
     * Notify on the property 'View_Close_Authorized'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'View_Close_Authorized'</b>:
     *
     * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
     * <p>FUNCID = RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendView_Close_AuthorizedUpReg(View_Close_AuthorizedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'View_Close_Authorized'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'View_Close_Authorized'</b>:
     *
     * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
     * <p>FUNCID = RVC_CCAFI_C_U16_VIEW_CLOSE_AUTHORIZED</p>
     *
     * @param act The act which was previously returned by the
     * sendView_Close_AuthorizedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendView_Close_AuthorizedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'View_Close_Authorized'.
     */
    void sendView_Close_AuthorizedRelUpRegAll ();

    /**
     * Returns the current value of the property 'View_Close_Authorized' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasView_Close_Authorized() returns true.
     *
     * @return the previously received value of the property 'View_Close_Authorized'.
     */
    const View_Close_AuthorizedStatus& getView_Close_Authorized() const;

    /**
     * Determines whether a status message for the property 'View_Close_Authorized' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasView_Close_Authorized() const;

    // Property 'AvmR_Current_View'

    /**
     * Notify on the property 'AvmR_Current_View'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AvmR_Current_View'</b>:
     *
     * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
     * <p>FUNCID = RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAvmR_Current_ViewUpReg(AvmR_Current_ViewCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AvmR_Current_View'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AvmR_Current_View'</b>:
     *
     * This property informs about the availability of an AVM exit through the HMI (Applicable only for Renault specific AVM)
     * <p>FUNCID = RVC_CCAFI_C_U16_AVMR_CURRENT_VIEW</p>
     *
     * @param act The act which was previously returned by the
     * sendAvmR_Current_ViewUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAvmR_Current_ViewRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AvmR_Current_View'.
     */
    void sendAvmR_Current_ViewRelUpRegAll ();

    /**
     * Returns the current value of the property 'AvmR_Current_View' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAvmR_Current_View() returns true.
     *
     * @return the previously received value of the property 'AvmR_Current_View'.
     */
    const AvmR_Current_ViewStatus& getAvmR_Current_View() const;

    /**
     * Determines whether a status message for the property 'AvmR_Current_View' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAvmR_Current_View() const;

    // Property 'Affordable_ITS'

    /**
     * Notify on the property 'Affordable_ITS'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Affordable_ITS'</b>:
     *
     * This property informs about the availability of an Affordable ITS unit and it's configuration states
     * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAffordable_ITSUpReg(Affordable_ITSCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Affordable_ITS'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Affordable_ITS'</b>:
     *
     * This property informs about the availability of an Affordable ITS unit and it's configuration states
     * <p>FUNCID = RVC_CCAFI_C_U16_AFFORDABLE_ITS</p>
     *
     * @param act The act which was previously returned by the
     * sendAffordable_ITSUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAffordable_ITSRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Affordable_ITS'.
     */
    void sendAffordable_ITSRelUpRegAll ();

    /**
     * Returns the current value of the property 'Affordable_ITS' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAffordable_ITS() returns true.
     *
     * @return the previously received value of the property 'Affordable_ITS'.
     */
    const Affordable_ITSStatus& getAffordable_ITS() const;

    /**
     * Determines whether a status message for the property 'Affordable_ITS' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAffordable_ITS() const;

    // Property 'IPAConfiguration'

    /**
     * Notify on the property 'IPAConfiguration'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'IPAConfiguration'</b>:
     *
     * This Property informs about the IPA configuration
     * <p>FUNCID = RVC_CCAFI_C_U16_IPACONFIGURATION</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPAConfigurationUpReg(IPAConfigurationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPAConfiguration'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPAConfiguration'</b>:
     *
     * This Property informs about the IPA configuration
     * <p>FUNCID = RVC_CCAFI_C_U16_IPACONFIGURATION</p>
     *
     * @param act The act which was previously returned by the
     * sendIPAConfigurationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPAConfigurationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPAConfiguration'.
     */
    void sendIPAConfigurationRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPAConfiguration' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIPAConfiguration() returns true.
     *
     * @return the previously received value of the property 'IPAConfiguration'.
     */
    const IPAConfigurationStatus& getIPAConfiguration() const;

    /**
     * Determines whether a status message for the property 'IPAConfiguration' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPAConfiguration() const;

    // Property 'IPAStatus'

    /**
     * Notify on the property 'IPAStatus'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'IPAStatus'</b>:
     *
     * This Property informs about the IPA status.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPAStatusUpReg(IPAStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPAStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPAStatus'</b>:
     *
     * This Property informs about the IPA status.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendIPAStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPAStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPAStatus'.
     */
    void sendIPAStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPAStatus' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasIPAStatus()
     * returns true.
     *
     * @return the previously received value of the property 'IPAStatus'.
     */
    const IPAStatusStatus& getIPAStatus() const;

    /**
     * Determines whether a status message for the property 'IPAStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPAStatus() const;

    // Property 'IPAPatternRequest'

    /**
     * Notify on the property 'IPAPatternRequest'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'IPAPatternRequest'</b>:
     *
     * This Property informs about the current requested screen pattern by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPAPATTERNREQUEST</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPAPatternRequestUpReg(IPAPatternRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPAPatternRequest'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPAPatternRequest'</b>:
     *
     * This Property informs about the current requested screen pattern by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPAPATTERNREQUEST</p>
     *
     * @param act The act which was previously returned by the
     * sendIPAPatternRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPAPatternRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPAPatternRequest'.
     */
    void sendIPAPatternRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPAPatternRequest' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIPAPatternRequest() returns true.
     *
     * @return the previously received value of the property 'IPAPatternRequest'.
     */
    const IPAPatternRequestStatus& getIPAPatternRequest() const;

    /**
     * Determines whether a status message for the property 'IPAPatternRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPAPatternRequest() const;

    // Property 'IPAMessageRequest'

    /**
     * Notify on the property 'IPAMessageRequest'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'IPAMessageRequest'</b>:
     *
     * This Property informs about the current requested message lines by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPAMESSAGEREQUEST</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPAMessageRequestUpReg(IPAMessageRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPAMessageRequest'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPAMessageRequest'</b>:
     *
     * This Property informs about the current requested message lines by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPAMESSAGEREQUEST</p>
     *
     * @param act The act which was previously returned by the
     * sendIPAMessageRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPAMessageRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPAMessageRequest'.
     */
    void sendIPAMessageRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPAMessageRequest' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIPAMessageRequest() returns true.
     *
     * @return the previously received value of the property 'IPAMessageRequest'.
     */
    const IPAMessageRequestStatus& getIPAMessageRequest() const;

    /**
     * Determines whether a status message for the property 'IPAMessageRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPAMessageRequest() const;

    // Property 'IPASwitchMaskRequest'

    /**
     * Notify on the property 'IPASwitchMaskRequest'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'IPASwitchMaskRequest'</b>:
     *
     * This Property informs about the current requested switch mask by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPASwitchMaskRequestUpReg(IPASwitchMaskRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPASwitchMaskRequest'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPASwitchMaskRequest'</b>:
     *
     * This Property informs about the current requested switch mask by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHMASKREQUEST</p>
     *
     * @param act The act which was previously returned by the
     * sendIPASwitchMaskRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPASwitchMaskRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPASwitchMaskRequest'.
     */
    void sendIPASwitchMaskRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPASwitchMaskRequest' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasIPASwitchMaskRequest() returns true.
     *
     * @return the previously received value of the property 'IPASwitchMaskRequest'.
     */
    const IPASwitchMaskRequestStatus& getIPASwitchMaskRequest() const;

    /**
     * Determines whether a status message for the property 'IPASwitchMaskRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPASwitchMaskRequest() const;

    // Property 'IPASwitchGreyOutRequest'

    /**
     * Notify on the property 'IPASwitchGreyOutRequest'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'IPASwitchGreyOutRequest'</b>:
     *
     * This Property informs about the current requested switch grey out by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPASwitchGreyOutRequestUpReg(IPASwitchGreyOutRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPASwitchGreyOutRequest'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPASwitchGreyOutRequest'</b>:
     *
     * This Property informs about the current requested switch grey out by IPA.
     * <p>FUNCID = RVC_CCAFI_C_U16_IPASWITCHGREYOUTREQUEST</p>
     *
     * @param act The act which was previously returned by the
     * sendIPASwitchGreyOutRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPASwitchGreyOutRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPASwitchGreyOutRequest'.
     */
    void sendIPASwitchGreyOutRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPASwitchGreyOutRequest' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasIPASwitchGreyOutRequest() returns true.
     *
     * @return the previously received value of the property 'IPASwitchGreyOutRequest'.
     */
    const IPASwitchGreyOutRequestStatus& getIPASwitchGreyOutRequest() const;

    /**
     * Determines whether a status message for the property 'IPASwitchGreyOutRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPASwitchGreyOutRequest() const;

    // Property 'IPADirectionIndicator'

    /**
     * Notify on the property 'IPADirectionIndicator'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'IPADirectionIndicator'</b>:
     *
     * This property informs about the current direction for the RearViewIcon
     * <p>FUNCID = RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIPADirectionIndicatorUpReg(IPADirectionIndicatorCallbackIF& cb);

    /**
     * Remove the notifcation on property 'IPADirectionIndicator'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'IPADirectionIndicator'</b>:
     *
     * This property informs about the current direction for the RearViewIcon
     * <p>FUNCID = RVC_CCAFI_C_U16_IPADIRECTIONINDICATOR</p>
     *
     * @param act The act which was previously returned by the
     * sendIPADirectionIndicatorUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendIPADirectionIndicatorRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'IPADirectionIndicator'.
     */
    void sendIPADirectionIndicatorRelUpRegAll ();

    /**
     * Returns the current value of the property 'IPADirectionIndicator' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasIPADirectionIndicator() returns true.
     *
     * @return the previously received value of the property 'IPADirectionIndicator'.
     */
    const IPADirectionIndicatorStatus& getIPADirectionIndicator() const;

    /**
     * Determines whether a status message for the property 'IPADirectionIndicator' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIPADirectionIndicator() const;

    // Property 'GdlAdj_SteeringAngle'

    /**
     * Notify on the property 'GdlAdj_SteeringAngle'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_SteeringAngle'</b>:
     *
     * This Property informs about the Steering Angle and Status to be used for the Guideline Adjustment screens.
     * The parameter will be updated only when the screen is activated.
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGdlAdj_SteeringAngleUpReg(GdlAdj_SteeringAngleCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GdlAdj_SteeringAngle'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_SteeringAngle'</b>:
     *
     * This Property informs about the Steering Angle and Status to be used for the Guideline Adjustment screens.
     * The parameter will be updated only when the screen is activated.
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_STEERINGANGLE</p>
     *
     * @param act The act which was previously returned by the
     * sendGdlAdj_SteeringAngleUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGdlAdj_SteeringAngleRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GdlAdj_SteeringAngle'.
     */
    void sendGdlAdj_SteeringAngleRelUpRegAll ();

    /**
     * Returns the current value of the property 'GdlAdj_SteeringAngle' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGdlAdj_SteeringAngle() returns true.
     *
     * @return the previously received value of the property 'GdlAdj_SteeringAngle'.
     */
    const GdlAdj_SteeringAngleStatus& getGdlAdj_SteeringAngle() const;

    /**
     * Determines whether a status message for the property 'GdlAdj_SteeringAngle' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGdlAdj_SteeringAngle() const;

    // Property 'GdlAdj_CameraAngle'

    /**
     * Notify on the property 'GdlAdj_CameraAngle'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_CameraAngle'</b>:
     *
     * This Property informs about the Camera Angle values to be used for the Guideline Adjustment screens.
     * The parameter will be updated only when the screen is activated.
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGdlAdj_CameraAngleUpReg(GdlAdj_CameraAngleCallbackIF& cb);

    /**
     * Remove the notifcation on property 'GdlAdj_CameraAngle'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'GdlAdj_CameraAngle'</b>:
     *
     * This Property informs about the Camera Angle values to be used for the Guideline Adjustment screens.
     * The parameter will be updated only when the screen is activated.
     * <p>FUNCID = RVC_CCAFI_C_U16_GDLADJ_CAMERAANGLE</p>
     *
     * @param act The act which was previously returned by the
     * sendGdlAdj_CameraAngleUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendGdlAdj_CameraAngleRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'GdlAdj_CameraAngle'.
     */
    void sendGdlAdj_CameraAngleRelUpRegAll ();

    /**
     * Returns the current value of the property 'GdlAdj_CameraAngle' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasGdlAdj_CameraAngle() returns true.
     *
     * @return the previously received value of the property 'GdlAdj_CameraAngle'.
     */
    const GdlAdj_CameraAngleStatus& getGdlAdj_CameraAngle() const;

    /**
     * Determines whether a status message for the property 'GdlAdj_CameraAngle' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasGdlAdj_CameraAngle() const;

    // Property 'CANFrameStatus'

    /**
     * Notify on the property 'CANFrameStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'CANFrameStatus'</b>:
     *
     * This Property informs about the CAN(Controller Area Network) frame status after MVC view requested.
     * <p>FUNCID = RVC_CCAFI_C_U16_CANFRAMESTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCANFrameStatusUpReg(CANFrameStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'CANFrameStatus'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'CANFrameStatus'</b>:
     *
     * This Property informs about the CAN(Controller Area Network) frame status after MVC view requested.
     * <p>FUNCID = RVC_CCAFI_C_U16_CANFRAMESTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendCANFrameStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendCANFrameStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'CANFrameStatus'.
     */
    void sendCANFrameStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'CANFrameStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasCANFrameStatus() returns true.
     *
     * @return the previously received value of the property 'CANFrameStatus'.
     */
    const CANFrameStatusStatus& getCANFrameStatus() const;

    /**
     * Determines whether a status message for the property 'CANFrameStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCANFrameStatus() const;

    // Property 'MvcViewStatus'

    /**
     * Notify on the property 'MvcViewStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MvcViewStatus'</b>:
     *
     * This Property informs about the current MVC view status.
     * <p>FUNCID = RVC_CCAFI_C_U16_MVCVIEWSTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMvcViewStatusUpReg(MvcViewStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MvcViewStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MvcViewStatus'</b>:
     *
     * This Property informs about the current MVC view status.
     * <p>FUNCID = RVC_CCAFI_C_U16_MVCVIEWSTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendMvcViewStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMvcViewStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MvcViewStatus'.
     */
    void sendMvcViewStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'MvcViewStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMvcViewStatus() returns true.
     *
     * @return the previously received value of the property 'MvcViewStatus'.
     */
    const MvcViewStatusStatus& getMvcViewStatus() const;

    /**
     * Determines whether a status message for the property 'MvcViewStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMvcViewStatus() const;

    // Property 'MvcAlertRequest'

    /**
     * Notify on the property 'MvcAlertRequest'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'MvcAlertRequest'</b>:
     *
     * This Property informs about the current MVC Alert Requested State.
     * <p>FUNCID = RVC_CCAFI_C_U16_MVCALERTREQUEST</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMvcAlertRequestUpReg(MvcAlertRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'MvcAlertRequest'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'MvcAlertRequest'</b>:
     *
     * This Property informs about the current MVC Alert Requested State.
     * <p>FUNCID = RVC_CCAFI_C_U16_MVCALERTREQUEST</p>
     *
     * @param act The act which was previously returned by the
     * sendMvcAlertRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendMvcAlertRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'MvcAlertRequest'.
     */
    void sendMvcAlertRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'MvcAlertRequest' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasMvcAlertRequest() returns true.
     *
     * @return the previously received value of the property 'MvcAlertRequest'.
     */
    const MvcAlertRequestStatus& getMvcAlertRequest() const;

    /**
     * Determines whether a status message for the property 'MvcAlertRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasMvcAlertRequest() const;

    // Property 'FAPMode'

    /**
     * Notify on the property 'FAPMode'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'FAPMode'</b>:
     *
     * This Property informs about the whether we are in FAP mode or not.
     * <p>FUNCID = RVC_CCAFI_C_U16_FAPMODE</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFAPModeUpReg(FAPModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FAPMode'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FAPMode'</b>:
     *
     * This Property informs about the whether we are in FAP mode or not.
     * <p>FUNCID = RVC_CCAFI_C_U16_FAPMODE</p>
     *
     * @param act The act which was previously returned by the
     * sendFAPModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFAPModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FAPMode'.
     */
    void sendFAPModeRelUpRegAll ();

    /**
     * Returns the current value of the property 'FAPMode' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasFAPMode()
     * returns true.
     *
     * @return the previously received value of the property 'FAPMode'.
     */
    const FAPModeStatus& getFAPMode() const;

    /**
     * Determines whether a status message for the property 'FAPMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFAPMode() const;

    // Property 'FAPSettings'

    /**
     * Notify on the property 'FAPSettings'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'FAPSettings'</b>:
     *
     * This Property informs about the current FAP Setting State
     * <p>FUNCID = RVC_CCAFI_C_U16_FAPSETTINGS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFAPSettingsUpReg(FAPSettingsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FAPSettings'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FAPSettings'</b>:
     *
     * This Property informs about the current FAP Setting State
     * <p>FUNCID = RVC_CCAFI_C_U16_FAPSETTINGS</p>
     *
     * @param act The act which was previously returned by the
     * sendFAPSettingsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFAPSettingsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FAPSettings'.
     */
    void sendFAPSettingsRelUpRegAll ();

    /**
     * Returns the current value of the property 'FAPSettings' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFAPSettings() returns true.
     *
     * @return the previously received value of the property 'FAPSettings'.
     */
    const FAPSettingsStatus& getFAPSettings() const;

    /**
     * Determines whether a status message for the property 'FAPSettings' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFAPSettings() const;

    // Property 'FAPGuidanceState'

    /**
     * Notify on the property 'FAPGuidanceState'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FAPGuidanceState'</b>:
     *
     * This Property informs about the whether we are in FAP Guidance or not.
     * <p>FUNCID = RVC_CCAFI_C_U16_FAPGUIDANCESTATE</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFAPGuidanceStateUpReg(FAPGuidanceStateCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FAPGuidanceState'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FAPGuidanceState'</b>:
     *
     * This Property informs about the whether we are in FAP Guidance or not.
     * <p>FUNCID = RVC_CCAFI_C_U16_FAPGUIDANCESTATE</p>
     *
     * @param act The act which was previously returned by the
     * sendFAPGuidanceStateUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFAPGuidanceStateRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FAPGuidanceState'.
     */
    void sendFAPGuidanceStateRelUpRegAll ();

    /**
     * Returns the current value of the property 'FAPGuidanceState' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasFAPGuidanceState() returns true.
     *
     * @return the previously received value of the property 'FAPGuidanceState'.
     */
    const FAPGuidanceStateStatus& getFAPGuidanceState() const;

    /**
     * Determines whether a status message for the property 'FAPGuidanceState' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFAPGuidanceState() const;

    // Property 'AVM3_DispStatus'

    /**
     * Notify on the property 'AVM3_DispStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AVM3_DispStatus'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_DISPSTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_DispStatusUpReg(AVM3_DispStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_DispStatus'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_DispStatus'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_DISPSTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_DispStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_DispStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_DispStatus'.
     */
    void sendAVM3_DispStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_DispStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAVM3_DispStatus() returns true.
     *
     * @return the previously received value of the property 'AVM3_DispStatus'.
     */
    const AVM3_DispStatusStatus& getAVM3_DispStatus() const;

    /**
     * Determines whether a status message for the property 'AVM3_DispStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_DispStatus() const;

    // Property 'AVM3_ViewSetup'

    /**
     * Notify on the property 'AVM3_ViewSetup'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AVM3_ViewSetup'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_VIEWCHANGE</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_ViewSetupUpReg(AVM3_ViewSetupCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_ViewSetup'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_ViewSetup'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_VIEWCHANGE</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_ViewSetupUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_ViewSetupRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_ViewSetup'.
     */
    void sendAVM3_ViewSetupRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_ViewSetup' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAVM3_ViewSetup() returns true.
     *
     * @return the previously received value of the property 'AVM3_ViewSetup'.
     */
    const AVM3_ViewSetupStatus& getAVM3_ViewSetup() const;

    /**
     * Determines whether a status message for the property 'AVM3_ViewSetup' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_ViewSetup() const;

    // Property 'AVM3_ErrorMessage'

    /**
     * Notify on the property 'AVM3_ErrorMessage'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AVM3_ErrorMessage'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_ErrorMessageUpReg(AVM3_ErrorMessageCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_ErrorMessage'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_ErrorMessage'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_ERRORMESSAGE</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_ErrorMessageUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_ErrorMessageRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_ErrorMessage'.
     */
    void sendAVM3_ErrorMessageRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_ErrorMessage' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAVM3_ErrorMessage() returns true.
     *
     * @return the previously received value of the property 'AVM3_ErrorMessage'.
     */
    const AVM3_ErrorMessageStatus& getAVM3_ErrorMessage() const;

    /**
     * Determines whether a status message for the property 'AVM3_ErrorMessage' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_ErrorMessage() const;

    // Property 'AVM3_SonarBuzzerStatus'

    /**
     * Notify on the property 'AVM3_SonarBuzzerStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_SonarBuzzerStatus'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_BUZZERSTATUS</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_SonarBuzzerStatusUpReg(AVM3_SonarBuzzerStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_SonarBuzzerStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_SonarBuzzerStatus'</b>:
     *
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_BUZZERSTATUS</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_SonarBuzzerStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_SonarBuzzerStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_SonarBuzzerStatus'.
     */
    void sendAVM3_SonarBuzzerStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_SonarBuzzerStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_SonarBuzzerStatus() returns true.
     *
     * @return the previously received value of the property 'AVM3_SonarBuzzerStatus'.
     */
    const AVM3_SonarBuzzerStatusStatus& getAVM3_SonarBuzzerStatus() const;

    /**
     * Determines whether a status message for the property 'AVM3_SonarBuzzerStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_SonarBuzzerStatus() const;

    // Property 'AVM3_Settings_Detailed'

    /**
     * Notify on the property 'AVM3_Settings_Detailed'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Settings_Detailed'</b>:
     *
     * This property holds the availability and states of all AVM3 settings items, as received from the AVM phase3.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_Settings_DetailedUpReg(AVM3_Settings_DetailedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_Settings_Detailed'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Settings_Detailed'</b>:
     *
     * This property holds the availability and states of all AVM3 settings items, as received from the AVM phase3.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_DETAILED</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_Settings_DetailedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_Settings_DetailedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_Settings_Detailed'.
     */
    void sendAVM3_Settings_DetailedRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_Settings_Detailed' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_Settings_Detailed() returns true.
     *
     * @return the previously received value of the property 'AVM3_Settings_Detailed'.
     */
    const AVM3_Settings_DetailedStatus& getAVM3_Settings_Detailed() const;

    /**
     * Determines whether a status message for the property 'AVM3_Settings_Detailed' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_Settings_Detailed() const;

    // Property 'AVM3_Settings_Primary'

    /**
     * Notify on the property 'AVM3_Settings_Primary'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Settings_Primary'</b>:
     *
     * This property holds the availability and states of all AVM3 settings items in the camera primary settings display.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_Settings_PrimaryUpReg(AVM3_Settings_PrimaryCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_Settings_Primary'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Settings_Primary'</b>:
     *
     * This property holds the availability and states of all AVM3 settings items in the camera primary settings display.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SETTINGS_PRIMARY</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_Settings_PrimaryUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_Settings_PrimaryRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_Settings_Primary'.
     */
    void sendAVM3_Settings_PrimaryRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_Settings_Primary' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_Settings_Primary() returns true.
     *
     * @return the previously received value of the property 'AVM3_Settings_Primary'.
     */
    const AVM3_Settings_PrimaryStatus& getAVM3_Settings_Primary() const;

    /**
     * Determines whether a status message for the property 'AVM3_Settings_Primary' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_Settings_Primary() const;

    // Property 'AVM3_Configuration'

    /**
     * Notify on the property 'AVM3_Configuration'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Configuration'</b>:
     *
     * This property holds the basic configuration parameters of the AVM3 ECU as received from the ECU via MCAN during connection setup.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CONFIGURATION</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_ConfigurationUpReg(AVM3_ConfigurationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_Configuration'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Configuration'</b>:
     *
     * This property holds the basic configuration parameters of the AVM3 ECU as received from the ECU via MCAN during connection setup.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_CONFIGURATION</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_ConfigurationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_ConfigurationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_Configuration'.
     */
    void sendAVM3_ConfigurationRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_Configuration' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_Configuration() returns true.
     *
     * @return the previously received value of the property 'AVM3_Configuration'.
     */
    const AVM3_ConfigurationStatus& getAVM3_Configuration() const;

    /**
     * Determines whether a status message for the property 'AVM3_Configuration' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_Configuration() const;

    // Property 'AVM3_Software_Version'

    /**
     * Notify on the property 'AVM3_Software_Version'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Software_Version'</b>:
     *
     * This property holds the AVM3 software version information.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_Software_VersionUpReg(AVM3_Software_VersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_Software_Version'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Software_Version'</b>:
     *
     * This property holds the AVM3 software version information.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_SOFTWARE_VERSION</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_Software_VersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_Software_VersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_Software_Version'.
     */
    void sendAVM3_Software_VersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_Software_Version' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_Software_Version() returns true.
     *
     * @return the previously received value of the property 'AVM3_Software_Version'.
     */
    const AVM3_Software_VersionStatus& getAVM3_Software_Version() const;

    /**
     * Determines whether a status message for the property 'AVM3_Software_Version' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_Software_Version() const;

    // Property 'AVM3_Hardware_Version'

    /**
     * Notify on the property 'AVM3_Hardware_Version'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Hardware_Version'</b>:
     *
     * This property holds the AVM3 hardware version information.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_Hardware_VersionUpReg(AVM3_Hardware_VersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_Hardware_Version'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_Hardware_Version'</b>:
     *
     * This property holds the AVM3 hardware version information.
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_HARDWARE_VERSION</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_Hardware_VersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_Hardware_VersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_Hardware_Version'.
     */
    void sendAVM3_Hardware_VersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_Hardware_Version' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_Hardware_Version() returns true.
     *
     * @return the previously received value of the property 'AVM3_Hardware_Version'.
     */
    const AVM3_Hardware_VersionStatus& getAVM3_Hardware_Version() const;

    /**
     * Determines whether a status message for the property 'AVM3_Hardware_Version' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_Hardware_Version() const;

    // Property 'AVM3_CommunicationErrors'

    /**
     * Notify on the property 'AVM3_CommunicationErrors'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_CommunicationErrors'</b>:
     *
     * This property holds the MCAN communication error related parameters (ref. 25953NDS06).
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_COMMUNICATION_ERROR</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAVM3_CommunicationErrorsUpReg(AVM3_CommunicationErrorsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AVM3_CommunicationErrors'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AVM3_CommunicationErrors'</b>:
     *
     * This property holds the MCAN communication error related parameters (ref. 25953NDS06).
     * <p>FUNCID = RVC_CCAFI_C_U16_AVM3_COMMUNICATION_ERROR</p>
     *
     * @param act The act which was previously returned by the
     * sendAVM3_CommunicationErrorsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAVM3_CommunicationErrorsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AVM3_CommunicationErrors'.
     */
    void sendAVM3_CommunicationErrorsRelUpRegAll ();

    /**
     * Returns the current value of the property 'AVM3_CommunicationErrors'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAVM3_CommunicationErrors() returns true.
     *
     * @return the previously received value of the property 'AVM3_CommunicationErrors'.
     */
    const AVM3_CommunicationErrorsStatus& getAVM3_CommunicationErrors() const;

    /**
     * Determines whether a status message for the property 'AVM3_CommunicationErrors' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAVM3_CommunicationErrors() const;

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Rvc_cca_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'SystemConfigurations'

    ::asf::core::nullable< SystemConfigurationsStatus > _systemConfigurations;

    // Property 'SystemStatus'

    ::asf::core::nullable< SystemStatusStatus > _systemStatus;

    // Property 'VideoSignalStatus'

    ::asf::core::nullable< VideoSignalStatusStatus > _videoSignalStatus;

    // Property 'ReverseSignalStatus'

    ::asf::core::nullable< ReverseSignalStatusStatus > _reverseSignalStatus;

    // Property 'Camera_PwrSupplyStatus'

    ::asf::core::nullable< Camera_PwrSupplyStatusStatus > _camera_PwrSupplyStatus;

    // Property 'Microphone_PwrSupplyStatus'

    ::asf::core::nullable< Microphone_PwrSupplyStatusStatus > _microphone_PwrSupplyStatus;

    // Property 'Tailgate_Status'

    ::asf::core::nullable< Tailgate_StatusStatus > _tailgate_Status;

    // Property 'View_Close_Authorized'

    ::asf::core::nullable< View_Close_AuthorizedStatus > _view_Close_Authorized;

    // Property 'AvmR_Current_View'

    ::asf::core::nullable< AvmR_Current_ViewStatus > _avmR_Current_View;

    // Property 'Affordable_ITS'

    ::asf::core::nullable< Affordable_ITSStatus > _affordable_ITS;

    // Property 'IPAConfiguration'

    ::asf::core::nullable< IPAConfigurationStatus > _iPAConfiguration;

    // Property 'IPAStatus'

    ::asf::core::nullable< IPAStatusStatus > _iPAStatus;

    // Property 'IPAPatternRequest'

    ::asf::core::nullable< IPAPatternRequestStatus > _iPAPatternRequest;

    // Property 'IPAMessageRequest'

    ::asf::core::nullable< IPAMessageRequestStatus > _iPAMessageRequest;

    // Property 'IPASwitchMaskRequest'

    ::asf::core::nullable< IPASwitchMaskRequestStatus > _iPASwitchMaskRequest;

    // Property 'IPASwitchGreyOutRequest'

    ::asf::core::nullable< IPASwitchGreyOutRequestStatus > _iPASwitchGreyOutRequest;

    // Property 'IPADirectionIndicator'

    ::asf::core::nullable< IPADirectionIndicatorStatus > _iPADirectionIndicator;

    // Property 'GdlAdj_SteeringAngle'

    ::asf::core::nullable< GdlAdj_SteeringAngleStatus > _gdlAdj_SteeringAngle;

    // Property 'GdlAdj_CameraAngle'

    ::asf::core::nullable< GdlAdj_CameraAngleStatus > _gdlAdj_CameraAngle;

    // Property 'CANFrameStatus'

    ::asf::core::nullable< CANFrameStatusStatus > _cANFrameStatus;

    // Property 'MvcViewStatus'

    ::asf::core::nullable< MvcViewStatusStatus > _mvcViewStatus;

    // Property 'MvcAlertRequest'

    ::asf::core::nullable< MvcAlertRequestStatus > _mvcAlertRequest;

    // Property 'FAPMode'

    ::asf::core::nullable< FAPModeStatus > _fAPMode;

    // Property 'FAPSettings'

    ::asf::core::nullable< FAPSettingsStatus > _fAPSettings;

    // Property 'FAPGuidanceState'

    ::asf::core::nullable< FAPGuidanceStateStatus > _fAPGuidanceState;

    // Property 'AVM3_DispStatus'

    ::asf::core::nullable< AVM3_DispStatusStatus > _aVM3_DispStatus;

    // Property 'AVM3_ViewSetup'

    ::asf::core::nullable< AVM3_ViewSetupStatus > _aVM3_ViewSetup;

    // Property 'AVM3_ErrorMessage'

    ::asf::core::nullable< AVM3_ErrorMessageStatus > _aVM3_ErrorMessage;

    // Property 'AVM3_SonarBuzzerStatus'

    ::asf::core::nullable< AVM3_SonarBuzzerStatusStatus > _aVM3_SonarBuzzerStatus;

    // Property 'AVM3_Settings_Detailed'

    ::asf::core::nullable< AVM3_Settings_DetailedStatus > _aVM3_Settings_Detailed;

    // Property 'AVM3_Settings_Primary'

    ::asf::core::nullable< AVM3_Settings_PrimaryStatus > _aVM3_Settings_Primary;

    // Property 'AVM3_Configuration'

    ::asf::core::nullable< AVM3_ConfigurationStatus > _aVM3_Configuration;

    // Property 'AVM3_Software_Version'

    ::asf::core::nullable< AVM3_Software_VersionStatus > _aVM3_Software_Version;

    // Property 'AVM3_Hardware_Version'

    ::asf::core::nullable< AVM3_Hardware_VersionStatus > _aVM3_Hardware_Version;

    // Property 'AVM3_CommunicationErrors'

    ::asf::core::nullable< AVM3_CommunicationErrorsStatus > _aVM3_CommunicationErrors;

    DECLARE_CLASS_LOGGER();

    friend class Rvc_cca_fiProxyCallback;
};

} // namespace rvc_cca_fi

#endif // RVC_CCA_FIPROXY_H
