/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "rvc_cca_fiCca.h"
#include "rvc_cca_fiJson.h"
#include "rvc_cca_fiProxy.h"
#include "rvc_cca_fi_types.h"
#include "rvc_cca_fi_typesConst.h"
#include <vector>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace rvc_cca_fi {

/*static*/ ::asf::core::Logger Rvc_cca_fiProxy::_logger ("/rvc_cca_fi/Rvc_cca_fiProxy");


class Rvc_cca_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Rvc_cca_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Rvc_cca_fiProxy> proxy = ::boost::static_pointer_cast<Rvc_cca_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_CameraButton: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::CameraButtonResult);
                                setActAndLogResult(message, "CameraButton", reinterpret_cast<act_t>(this), _logger);
                                ((CameraButtonCallbackIF*) _callback)->onCameraButtonResult (proxy, ::boost::static_pointer_cast<CameraButtonResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::CameraButtonError);
                                setActAndLogError(message, "CameraButton", reinterpret_cast<act_t>(this), _logger);
                                ((CameraButtonCallbackIF*) _callback)->onCameraButtonError (proxy, ::boost::static_pointer_cast<CameraButtonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetStatusHmi: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetStatusHmiResult);
                                setActAndLogResult(message, "SetStatusHmi", reinterpret_cast<act_t>(this), _logger);
                                ((SetStatusHmiCallbackIF*) _callback)->onSetStatusHmiResult (proxy, ::boost::static_pointer_cast<SetStatusHmiResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetStatusHmiError);
                                setActAndLogError(message, "SetStatusHmi", reinterpret_cast<act_t>(this), _logger);
                                ((SetStatusHmiCallbackIF*) _callback)->onSetStatusHmiError (proxy, ::boost::static_pointer_cast<SetStatusHmiError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetupLanguage: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupLanguageResult);
                                setActAndLogResult(message, "SetupLanguage", reinterpret_cast<act_t>(this), _logger);
                                ((SetupLanguageCallbackIF*) _callback)->onSetupLanguageResult (proxy, ::boost::static_pointer_cast<SetupLanguageResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupLanguageError);
                                setActAndLogError(message, "SetupLanguage", reinterpret_cast<act_t>(this), _logger);
                                ((SetupLanguageCallbackIF*) _callback)->onSetupLanguageError (proxy, ::boost::static_pointer_cast<SetupLanguageError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetupGuideLine: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupGuideLineResult);
                                setActAndLogResult(message, "SetupGuideLine", reinterpret_cast<act_t>(this), _logger);
                                ((SetupGuideLineCallbackIF*) _callback)->onSetupGuideLineResult (proxy, ::boost::static_pointer_cast<SetupGuideLineResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupGuideLineError);
                                setActAndLogError(message, "SetupGuideLine", reinterpret_cast<act_t>(this), _logger);
                                ((SetupGuideLineCallbackIF*) _callback)->onSetupGuideLineError (proxy, ::boost::static_pointer_cast<SetupGuideLineError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetupVideoControls: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupVideoControlsResult);
                                setActAndLogResult(message, "SetupVideoControls", reinterpret_cast<act_t>(this), _logger);
                                ((SetupVideoControlsCallbackIF*) _callback)->onSetupVideoControlsResult (proxy, ::boost::static_pointer_cast<SetupVideoControlsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupVideoControlsError);
                                setActAndLogError(message, "SetupVideoControls", reinterpret_cast<act_t>(this), _logger);
                                ((SetupVideoControlsCallbackIF*) _callback)->onSetupVideoControlsError (proxy, ::boost::static_pointer_cast<SetupVideoControlsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetSystemStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetSystemStatusResult);
                                setActAndLogResult(message, "SetSystemStatus", reinterpret_cast<act_t>(this), _logger);
                                ((SetSystemStatusCallbackIF*) _callback)->onSetSystemStatusResult (proxy, ::boost::static_pointer_cast<SetSystemStatusResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetSystemStatusError);
                                setActAndLogError(message, "SetSystemStatus", reinterpret_cast<act_t>(this), _logger);
                                ((SetSystemStatusCallbackIF*) _callback)->onSetSystemStatusError (proxy, ::boost::static_pointer_cast<SetSystemStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_runExtDevicePowerSupplyTest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::RunExtDevicePowerSupplyTestResult);
                                setActAndLogResult(message, "RunExtDevicePowerSupplyTest", reinterpret_cast<act_t>(this), _logger);
                                ((RunExtDevicePowerSupplyTestCallbackIF*) _callback)->onRunExtDevicePowerSupplyTestResult (proxy, ::boost::static_pointer_cast<RunExtDevicePowerSupplyTestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::RunExtDevicePowerSupplyTestError);
                                setActAndLogError(message, "RunExtDevicePowerSupplyTest", reinterpret_cast<act_t>(this), _logger);
                                ((RunExtDevicePowerSupplyTestCallbackIF*) _callback)->onRunExtDevicePowerSupplyTestError (proxy, ::boost::static_pointer_cast<RunExtDevicePowerSupplyTestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Initialize: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::InitializeResult);
                                setActAndLogResult(message, "Initialize", reinterpret_cast<act_t>(this), _logger);
                                ((InitializeCallbackIF*) _callback)->onInitializeResult (proxy, ::boost::static_pointer_cast<InitializeResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::InitializeError);
                                setActAndLogError(message, "Initialize", reinterpret_cast<act_t>(this), _logger);
                                ((InitializeCallbackIF*) _callback)->onInitializeError (proxy, ::boost::static_pointer_cast<InitializeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ConfirmSystemStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ConfirmSystemStatusResult);
                                setActAndLogResult(message, "ConfirmSystemStatus", reinterpret_cast<act_t>(this), _logger);
                                ((ConfirmSystemStatusCallbackIF*) _callback)->onConfirmSystemStatusResult (proxy, ::boost::static_pointer_cast<ConfirmSystemStatusResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ConfirmSystemStatusError);
                                setActAndLogError(message, "ConfirmSystemStatus", reinterpret_cast<act_t>(this), _logger);
                                ((ConfirmSystemStatusCallbackIF*) _callback)->onConfirmSystemStatusError (proxy, ::boost::static_pointer_cast<ConfirmSystemStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetupUserConfiguration: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupUserConfigurationResult);
                                setActAndLogResult(message, "SetupUserConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ((SetupUserConfigurationCallbackIF*) _callback)->onSetupUserConfigurationResult (proxy, ::boost::static_pointer_cast<SetupUserConfigurationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetupUserConfigurationError);
                                setActAndLogError(message, "SetupUserConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ((SetupUserConfigurationCallbackIF*) _callback)->onSetupUserConfigurationError (proxy, ::boost::static_pointer_cast<SetupUserConfigurationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetMicrophoneState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetMicrophoneStateResult);
                                setActAndLogResult(message, "SetMicrophoneState", reinterpret_cast<act_t>(this), _logger);
                                ((SetMicrophoneStateCallbackIF*) _callback)->onSetMicrophoneStateResult (proxy, ::boost::static_pointer_cast<SetMicrophoneStateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetMicrophoneStateError);
                                setActAndLogError(message, "SetMicrophoneState", reinterpret_cast<act_t>(this), _logger);
                                ((SetMicrophoneStateCallbackIF*) _callback)->onSetMicrophoneStateError (proxy, ::boost::static_pointer_cast<SetMicrophoneStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetRVCStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetRVCStatusResult);
                                setActAndLogResult(message, "SetRVCStatus", reinterpret_cast<act_t>(this), _logger);
                                ((SetRVCStatusCallbackIF*) _callback)->onSetRVCStatusResult (proxy, ::boost::static_pointer_cast<SetRVCStatusResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetRVCStatusError);
                                setActAndLogError(message, "SetRVCStatus", reinterpret_cast<act_t>(this), _logger);
                                ((SetRVCStatusCallbackIF*) _callback)->onSetRVCStatusError (proxy, ::boost::static_pointer_cast<SetRVCStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Camera_SetupBeep: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Camera_SetupBeepResult);
                                setActAndLogResult(message, "Camera_SetupBeep", reinterpret_cast<act_t>(this), _logger);
                                ((Camera_SetupBeepCallbackIF*) _callback)->onCamera_SetupBeepResult (proxy, ::boost::static_pointer_cast<Camera_SetupBeepResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Camera_SetupBeepError);
                                setActAndLogError(message, "Camera_SetupBeep", reinterpret_cast<act_t>(this), _logger);
                                ((Camera_SetupBeepCallbackIF*) _callback)->onCamera_SetupBeepError (proxy, ::boost::static_pointer_cast<Camera_SetupBeepError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetCamerastate: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetCamerastateResult);
                                setActAndLogResult(message, "SetCamerastate", reinterpret_cast<act_t>(this), _logger);
                                ((SetCamerastateCallbackIF*) _callback)->onSetCamerastateResult (proxy, ::boost::static_pointer_cast<SetCamerastateResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetCamerastateError);
                                setActAndLogError(message, "SetCamerastate", reinterpret_cast<act_t>(this), _logger);
                                ((SetCamerastateCallbackIF*) _callback)->onSetCamerastateError (proxy, ::boost::static_pointer_cast<SetCamerastateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ChangeViewRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ChangeViewRequestResult);
                                setActAndLogResult(message, "ChangeViewRequest", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeViewRequestCallbackIF*) _callback)->onChangeViewRequestResult (proxy, ::boost::static_pointer_cast<ChangeViewRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ChangeViewRequestError);
                                setActAndLogError(message, "ChangeViewRequest", reinterpret_cast<act_t>(this), _logger);
                                ((ChangeViewRequestCallbackIF*) _callback)->onChangeViewRequestError (proxy, ::boost::static_pointer_cast<ChangeViewRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Affordable_Its_SetupBsw: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_Its_SetupBswResult);
                                setActAndLogResult(message, "Affordable_Its_SetupBsw", reinterpret_cast<act_t>(this), _logger);
                                ((Affordable_Its_SetupBswCallbackIF*) _callback)->onAffordable_Its_SetupBswResult (proxy, ::boost::static_pointer_cast<Affordable_Its_SetupBswResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_Its_SetupBswError);
                                setActAndLogError(message, "Affordable_Its_SetupBsw", reinterpret_cast<act_t>(this), _logger);
                                ((Affordable_Its_SetupBswCallbackIF*) _callback)->onAffordable_Its_SetupBswError (proxy, ::boost::static_pointer_cast<Affordable_Its_SetupBswError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Affordable_Its_SetupMod: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_Its_SetupModResult);
                                setActAndLogResult(message, "Affordable_Its_SetupMod", reinterpret_cast<act_t>(this), _logger);
                                ((Affordable_Its_SetupModCallbackIF*) _callback)->onAffordable_Its_SetupModResult (proxy, ::boost::static_pointer_cast<Affordable_Its_SetupModResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_Its_SetupModError);
                                setActAndLogError(message, "Affordable_Its_SetupMod", reinterpret_cast<act_t>(this), _logger);
                                ((Affordable_Its_SetupModCallbackIF*) _callback)->onAffordable_Its_SetupModError (proxy, ::boost::static_pointer_cast<Affordable_Its_SetupModError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Affordable_Its_SetupLdw: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_Its_SetupLdwResult);
                                setActAndLogResult(message, "Affordable_Its_SetupLdw", reinterpret_cast<act_t>(this), _logger);
                                ((Affordable_Its_SetupLdwCallbackIF*) _callback)->onAffordable_Its_SetupLdwResult (proxy, ::boost::static_pointer_cast<Affordable_Its_SetupLdwResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_Its_SetupLdwError);
                                setActAndLogError(message, "Affordable_Its_SetupLdw", reinterpret_cast<act_t>(this), _logger);
                                ((Affordable_Its_SetupLdwCallbackIF*) _callback)->onAffordable_Its_SetupLdwError (proxy, ::boost::static_pointer_cast<Affordable_Its_SetupLdwError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPA_SetHMIStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPA_SetHMIStatusResult);
                                setActAndLogResult(message, "IPA_SetHMIStatus", reinterpret_cast<act_t>(this), _logger);
                                ((IPA_SetHMIStatusCallbackIF*) _callback)->onIPA_SetHMIStatusResult (proxy, ::boost::static_pointer_cast<IPA_SetHMIStatusResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPA_SetHMIStatusError);
                                setActAndLogError(message, "IPA_SetHMIStatus", reinterpret_cast<act_t>(this), _logger);
                                ((IPA_SetHMIStatusCallbackIF*) _callback)->onIPA_SetHMIStatusError (proxy, ::boost::static_pointer_cast<IPA_SetHMIStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPA_SetButton: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPA_SetButtonResult);
                                setActAndLogResult(message, "IPA_SetButton", reinterpret_cast<act_t>(this), _logger);
                                ((IPA_SetButtonCallbackIF*) _callback)->onIPA_SetButtonResult (proxy, ::boost::static_pointer_cast<IPA_SetButtonResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPA_SetButtonError);
                                setActAndLogError(message, "IPA_SetButton", reinterpret_cast<act_t>(this), _logger);
                                ((IPA_SetButtonCallbackIF*) _callback)->onIPA_SetButtonError (proxy, ::boost::static_pointer_cast<IPA_SetButtonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPA_Voice_Texts: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPA_Voice_TextsResult);
                                setActAndLogResult(message, "IPA_Voice_Texts", reinterpret_cast<act_t>(this), _logger);
                                ((IPA_Voice_TextsCallbackIF*) _callback)->onIPA_Voice_TextsResult (proxy, ::boost::static_pointer_cast<IPA_Voice_TextsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPA_Voice_TextsError);
                                setActAndLogError(message, "IPA_Voice_Texts", reinterpret_cast<act_t>(this), _logger);
                                ((IPA_Voice_TextsCallbackIF*) _callback)->onIPA_Voice_TextsError (proxy, ::boost::static_pointer_cast<IPA_Voice_TextsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MVC_HMI_ViewRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MVC_HMI_ViewRequestResult);
                                setActAndLogResult(message, "MVC_HMI_ViewRequest", reinterpret_cast<act_t>(this), _logger);
                                ((MVC_HMI_ViewRequestCallbackIF*) _callback)->onMVC_HMI_ViewRequestResult (proxy, ::boost::static_pointer_cast<MVC_HMI_ViewRequestResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MVC_HMI_ViewRequestError);
                                setActAndLogError(message, "MVC_HMI_ViewRequest", reinterpret_cast<act_t>(this), _logger);
                                ((MVC_HMI_ViewRequestCallbackIF*) _callback)->onMVC_HMI_ViewRequestError (proxy, ::boost::static_pointer_cast<MVC_HMI_ViewRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GdlAdj_AdjustmentComplete: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_AdjustmentCompleteResult);
                                setActAndLogResult(message, "GdlAdj_AdjustmentComplete", reinterpret_cast<act_t>(this), _logger);
                                ((GdlAdj_AdjustmentCompleteCallbackIF*) _callback)->onGdlAdj_AdjustmentCompleteResult (proxy, ::boost::static_pointer_cast<GdlAdj_AdjustmentCompleteResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_AdjustmentCompleteError);
                                setActAndLogError(message, "GdlAdj_AdjustmentComplete", reinterpret_cast<act_t>(this), _logger);
                                ((GdlAdj_AdjustmentCompleteCallbackIF*) _callback)->onGdlAdj_AdjustmentCompleteError (proxy, ::boost::static_pointer_cast<GdlAdj_AdjustmentCompleteError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GdlAdj_AdjustButton: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_AdjustButtonResult);
                                setActAndLogResult(message, "GdlAdj_AdjustButton", reinterpret_cast<act_t>(this), _logger);
                                ((GdlAdj_AdjustButtonCallbackIF*) _callback)->onGdlAdj_AdjustButtonResult (proxy, ::boost::static_pointer_cast<GdlAdj_AdjustButtonResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_AdjustButtonError);
                                setActAndLogError(message, "GdlAdj_AdjustButton", reinterpret_cast<act_t>(this), _logger);
                                ((GdlAdj_AdjustButtonCallbackIF*) _callback)->onGdlAdj_AdjustButtonError (proxy, ::boost::static_pointer_cast<GdlAdj_AdjustButtonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GdlAdj_ConfigurationData: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_ConfigurationDataResult);
                                setActAndLogResult(message, "GdlAdj_ConfigurationData", reinterpret_cast<act_t>(this), _logger);
                                ((GdlAdj_ConfigurationDataCallbackIF*) _callback)->onGdlAdj_ConfigurationDataResult (proxy, ::boost::static_pointer_cast<GdlAdj_ConfigurationDataResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_ConfigurationDataError);
                                setActAndLogError(message, "GdlAdj_ConfigurationData", reinterpret_cast<act_t>(this), _logger);
                                ((GdlAdj_ConfigurationDataCallbackIF*) _callback)->onGdlAdj_ConfigurationDataError (proxy, ::boost::static_pointer_cast<GdlAdj_ConfigurationDataError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FAP_SetButton: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAP_SetButtonResult);
                                setActAndLogResult(message, "FAP_SetButton", reinterpret_cast<act_t>(this), _logger);
                                ((FAP_SetButtonCallbackIF*) _callback)->onFAP_SetButtonResult (proxy, ::boost::static_pointer_cast<FAP_SetButtonResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAP_SetButtonError);
                                setActAndLogError(message, "FAP_SetButton", reinterpret_cast<act_t>(this), _logger);
                                ((FAP_SetButtonCallbackIF*) _callback)->onFAP_SetButtonError (proxy, ::boost::static_pointer_cast<FAP_SetButtonError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TouchEvent: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::TouchEventResult);
                                setActAndLogResult(message, "TouchEvent", reinterpret_cast<act_t>(this), _logger);
                                ((TouchEventCallbackIF*) _callback)->onTouchEventResult (proxy, ::boost::static_pointer_cast<TouchEventResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::TouchEventError);
                                setActAndLogError(message, "TouchEvent", reinterpret_cast<act_t>(this), _logger);
                                ((TouchEventCallbackIF*) _callback)->onTouchEventError (proxy, ::boost::static_pointer_cast<TouchEventError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GPSInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GPSInfoResult);
                                setActAndLogResult(message, "GPSInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GPSInfoCallbackIF*) _callback)->onGPSInfoResult (proxy, ::boost::static_pointer_cast<GPSInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GPSInfoError);
                                setActAndLogError(message, "GPSInfo", reinterpret_cast<act_t>(this), _logger);
                                ((GPSInfoCallbackIF*) _callback)->onGPSInfoError (proxy, ::boost::static_pointer_cast<GPSInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MapMatchedInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MapMatchedInfoResult);
                                setActAndLogResult(message, "MapMatchedInfo", reinterpret_cast<act_t>(this), _logger);
                                ((MapMatchedInfoCallbackIF*) _callback)->onMapMatchedInfoResult (proxy, ::boost::static_pointer_cast<MapMatchedInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MapMatchedInfoError);
                                setActAndLogError(message, "MapMatchedInfo", reinterpret_cast<act_t>(this), _logger);
                                ((MapMatchedInfoCallbackIF*) _callback)->onMapMatchedInfoError (proxy, ::boost::static_pointer_cast<MapMatchedInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FapLearnParkPosition: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FapLearnParkPositionResult);
                                setActAndLogResult(message, "FapLearnParkPosition", reinterpret_cast<act_t>(this), _logger);
                                ((FapLearnParkPositionCallbackIF*) _callback)->onFapLearnParkPositionResult (proxy, ::boost::static_pointer_cast<FapLearnParkPositionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FapLearnParkPositionError);
                                setActAndLogError(message, "FapLearnParkPosition", reinterpret_cast<act_t>(this), _logger);
                                ((FapLearnParkPositionCallbackIF*) _callback)->onFapLearnParkPositionError (proxy, ::boost::static_pointer_cast<FapLearnParkPositionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SetFapGuidance: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetFapGuidanceResult);
                                setActAndLogResult(message, "SetFapGuidance", reinterpret_cast<act_t>(this), _logger);
                                ((SetFapGuidanceCallbackIF*) _callback)->onSetFapGuidanceResult (proxy, ::boost::static_pointer_cast<SetFapGuidanceResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SetFapGuidanceError);
                                setActAndLogError(message, "SetFapGuidance", reinterpret_cast<act_t>(this), _logger);
                                ((SetFapGuidanceCallbackIF*) _callback)->onSetFapGuidanceError (proxy, ::boost::static_pointer_cast<SetFapGuidanceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_SetSwitch: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_SetSwitchResult);
                                setActAndLogResult(message, "AVM3_SetSwitch", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_SetSwitchCallbackIF*) _callback)->onAVM3_SetSwitchResult (proxy, ::boost::static_pointer_cast<AVM3_SetSwitchResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_SetSwitchError);
                                setActAndLogError(message, "AVM3_SetSwitch", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_SetSwitchCallbackIF*) _callback)->onAVM3_SetSwitchError (proxy, ::boost::static_pointer_cast<AVM3_SetSwitchError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_SetSonarBuzzerStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusResult);
                                setActAndLogResult(message, "AVM3_SetSonarBuzzerStatus", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_SetSonarBuzzerStatusCallbackIF*) _callback)->onAVM3_SetSonarBuzzerStatusResult (proxy, ::boost::static_pointer_cast<AVM3_SetSonarBuzzerStatusResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusError);
                                setActAndLogError(message, "AVM3_SetSonarBuzzerStatus", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_SetSonarBuzzerStatusCallbackIF*) _callback)->onAVM3_SetSonarBuzzerStatusError (proxy, ::boost::static_pointer_cast<AVM3_SetSonarBuzzerStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Settings_Detailed_SendReq: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqResult);
                                setActAndLogResult(message, "AVM3_Settings_Detailed_SendReq", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_Settings_Detailed_SendReqCallbackIF*) _callback)->onAVM3_Settings_Detailed_SendReqResult (proxy, ::boost::static_pointer_cast<AVM3_Settings_Detailed_SendReqResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqError);
                                setActAndLogError(message, "AVM3_Settings_Detailed_SendReq", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_Settings_Detailed_SendReqCallbackIF*) _callback)->onAVM3_Settings_Detailed_SendReqError (proxy, ::boost::static_pointer_cast<AVM3_Settings_Detailed_SendReqError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Settings_Primary_SendReq: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_Primary_SendReqResult);
                                setActAndLogResult(message, "AVM3_Settings_Primary_SendReq", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_Settings_Primary_SendReqCallbackIF*) _callback)->onAVM3_Settings_Primary_SendReqResult (proxy, ::boost::static_pointer_cast<AVM3_Settings_Primary_SendReqResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_Primary_SendReqError);
                                setActAndLogError(message, "AVM3_Settings_Primary_SendReq", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_Settings_Primary_SendReqCallbackIF*) _callback)->onAVM3_Settings_Primary_SendReqError (proxy, ::boost::static_pointer_cast<AVM3_Settings_Primary_SendReqError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_GetVersionInfo: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_GetVersionInfoResult);
                                setActAndLogResult(message, "AVM3_GetVersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_GetVersionInfoCallbackIF*) _callback)->onAVM3_GetVersionInfoResult (proxy, ::boost::static_pointer_cast<AVM3_GetVersionInfoResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_GetVersionInfoError);
                                setActAndLogError(message, "AVM3_GetVersionInfo", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_GetVersionInfoCallbackIF*) _callback)->onAVM3_GetVersionInfoError (proxy, ::boost::static_pointer_cast<AVM3_GetVersionInfoError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_GetCommunicationErrors: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_GetCommunicationErrorsResult);
                                setActAndLogResult(message, "AVM3_GetCommunicationErrors", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_GetCommunicationErrorsCallbackIF*) _callback)->onAVM3_GetCommunicationErrorsResult (proxy, ::boost::static_pointer_cast<AVM3_GetCommunicationErrorsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_GetCommunicationErrorsError);
                                setActAndLogError(message, "AVM3_GetCommunicationErrors", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_GetCommunicationErrorsCallbackIF*) _callback)->onAVM3_GetCommunicationErrorsError (proxy, ::boost::static_pointer_cast<AVM3_GetCommunicationErrorsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_ClearCommunicationErrors: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ClearCommunicationErrorsResult);
                                setActAndLogResult(message, "AVM3_ClearCommunicationErrors", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_ClearCommunicationErrorsCallbackIF*) _callback)->onAVM3_ClearCommunicationErrorsResult (proxy, ::boost::static_pointer_cast<AVM3_ClearCommunicationErrorsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ClearCommunicationErrorsError);
                                setActAndLogError(message, "AVM3_ClearCommunicationErrors", reinterpret_cast<act_t>(this), _logger);
                                ((AVM3_ClearCommunicationErrorsCallbackIF*) _callback)->onAVM3_ClearCommunicationErrorsError (proxy, ::boost::static_pointer_cast<AVM3_ClearCommunicationErrorsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ToggleGpioPinOnOff: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ToggleGpioPinOnOffResult);
                                setActAndLogResult(message, "ToggleGpioPinOnOff", reinterpret_cast<act_t>(this), _logger);
                                ((ToggleGpioPinOnOffCallbackIF*) _callback)->onToggleGpioPinOnOffResult (proxy, ::boost::static_pointer_cast<ToggleGpioPinOnOffResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ToggleGpioPinOnOffError);
                                setActAndLogError(message, "ToggleGpioPinOnOff", reinterpret_cast<act_t>(this), _logger);
                                ((ToggleGpioPinOnOffCallbackIF*) _callback)->onToggleGpioPinOnOffError (proxy, ::boost::static_pointer_cast<ToggleGpioPinOnOffError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SystemConfigurations: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SystemConfigurationsStatus);
                                setActAndLogStatus(message, "SystemConfigurations", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SystemConfigurationsStatus> payload = ::boost::static_pointer_cast<SystemConfigurationsStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SystemConfigurationsStatus >& refNullableStatus = proxy->_systemConfigurations;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SystemConfigurationsCallbackIF*) _callback)->onSystemConfigurationsStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SystemConfigurationsError);
                                setActAndLogError(message, "SystemConfigurations", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((SystemConfigurationsCallbackIF*) _callback)->onSystemConfigurationsError(proxy, ::boost::static_pointer_cast<SystemConfigurationsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SystemStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SystemStatusStatus);
                                setActAndLogStatus(message, "SystemStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SystemStatusStatus> payload = ::boost::static_pointer_cast<SystemStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SystemStatusStatus >& refNullableStatus = proxy->_systemStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SystemStatusCallbackIF*) _callback)->onSystemStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::SystemStatusError);
                                setActAndLogError(message, "SystemStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((SystemStatusCallbackIF*) _callback)->onSystemStatusError(proxy, ::boost::static_pointer_cast<SystemStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VideoSignalStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::VideoSignalStatusStatus);
                                setActAndLogStatus(message, "VideoSignalStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VideoSignalStatusStatus> payload = ::boost::static_pointer_cast<VideoSignalStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VideoSignalStatusStatus >& refNullableStatus = proxy->_videoSignalStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VideoSignalStatusCallbackIF*) _callback)->onVideoSignalStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::VideoSignalStatusError);
                                setActAndLogError(message, "VideoSignalStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((VideoSignalStatusCallbackIF*) _callback)->onVideoSignalStatusError(proxy, ::boost::static_pointer_cast<VideoSignalStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ReverseSignalStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ReverseSignalStatusStatus);
                                setActAndLogStatus(message, "ReverseSignalStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ReverseSignalStatusStatus> payload = ::boost::static_pointer_cast<ReverseSignalStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ReverseSignalStatusStatus >& refNullableStatus = proxy->_reverseSignalStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ReverseSignalStatusCallbackIF*) _callback)->onReverseSignalStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::ReverseSignalStatusError);
                                setActAndLogError(message, "ReverseSignalStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((ReverseSignalStatusCallbackIF*) _callback)->onReverseSignalStatusError(proxy, ::boost::static_pointer_cast<ReverseSignalStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Camera_PwrSupplyStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Camera_PwrSupplyStatusStatus);
                                setActAndLogStatus(message, "Camera_PwrSupplyStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Camera_PwrSupplyStatusStatus> payload = ::boost::static_pointer_cast<Camera_PwrSupplyStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Camera_PwrSupplyStatusStatus >& refNullableStatus = proxy->_camera_PwrSupplyStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Camera_PwrSupplyStatusCallbackIF*) _callback)->onCamera_PwrSupplyStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Camera_PwrSupplyStatusCallbackIF*) _callback)->onCamera_PwrSupplyStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Camera_PwrSupplyStatusError);
                                setActAndLogError(message, "Camera_PwrSupplyStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Camera_PwrSupplyStatusCallbackIF*) _callback)->onCamera_PwrSupplyStatusError(proxy, ::boost::static_pointer_cast<Camera_PwrSupplyStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Microphone_PwrSupplyStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Microphone_PwrSupplyStatusStatus);
                                setActAndLogStatus(message, "Microphone_PwrSupplyStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Microphone_PwrSupplyStatusStatus> payload = ::boost::static_pointer_cast<Microphone_PwrSupplyStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Microphone_PwrSupplyStatusStatus >& refNullableStatus = proxy->_microphone_PwrSupplyStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Microphone_PwrSupplyStatusCallbackIF*) _callback)->onMicrophone_PwrSupplyStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Microphone_PwrSupplyStatusCallbackIF*) _callback)->onMicrophone_PwrSupplyStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Microphone_PwrSupplyStatusError);
                                setActAndLogError(message, "Microphone_PwrSupplyStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Microphone_PwrSupplyStatusCallbackIF*) _callback)->onMicrophone_PwrSupplyStatusError(proxy, ::boost::static_pointer_cast<Microphone_PwrSupplyStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Tailgate_Status: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Tailgate_StatusStatus);
                                setActAndLogStatus(message, "Tailgate_Status", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Tailgate_StatusStatus> payload = ::boost::static_pointer_cast<Tailgate_StatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Tailgate_StatusStatus >& refNullableStatus = proxy->_tailgate_Status;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Tailgate_StatusCallbackIF*) _callback)->onTailgate_StatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Tailgate_StatusCallbackIF*) _callback)->onTailgate_StatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Tailgate_StatusError);
                                setActAndLogError(message, "Tailgate_Status", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((Tailgate_StatusCallbackIF*) _callback)->onTailgate_StatusError(proxy, ::boost::static_pointer_cast<Tailgate_StatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_View_Close_Authorized: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::View_Close_AuthorizedStatus);
                                setActAndLogStatus(message, "View_Close_Authorized", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<View_Close_AuthorizedStatus> payload = ::boost::static_pointer_cast<View_Close_AuthorizedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< View_Close_AuthorizedStatus >& refNullableStatus = proxy->_view_Close_Authorized;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((View_Close_AuthorizedCallbackIF*) _callback)->onView_Close_AuthorizedStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::View_Close_AuthorizedError);
                                setActAndLogError(message, "View_Close_Authorized", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((View_Close_AuthorizedCallbackIF*) _callback)->onView_Close_AuthorizedError(proxy, ::boost::static_pointer_cast<View_Close_AuthorizedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AvmR_Current_View: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AvmR_Current_ViewStatus);
                                setActAndLogStatus(message, "AvmR_Current_View", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AvmR_Current_ViewStatus> payload = ::boost::static_pointer_cast<AvmR_Current_ViewStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AvmR_Current_ViewStatus >& refNullableStatus = proxy->_avmR_Current_View;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AvmR_Current_ViewCallbackIF*) _callback)->onAvmR_Current_ViewStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AvmR_Current_ViewError);
                                setActAndLogError(message, "AvmR_Current_View", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AvmR_Current_ViewCallbackIF*) _callback)->onAvmR_Current_ViewError(proxy, ::boost::static_pointer_cast<AvmR_Current_ViewError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_Affordable_ITS: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_ITSStatus);
                                setActAndLogStatus(message, "Affordable_ITS", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<Affordable_ITSStatus> payload = ::boost::static_pointer_cast<Affordable_ITSStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< Affordable_ITSStatus >& refNullableStatus = proxy->_affordable_ITS;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((Affordable_ITSCallbackIF*) _callback)->onAffordable_ITSStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::Affordable_ITSError);
                                setActAndLogError(message, "Affordable_ITS", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((Affordable_ITSCallbackIF*) _callback)->onAffordable_ITSError(proxy, ::boost::static_pointer_cast<Affordable_ITSError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPAConfiguration: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAConfigurationStatus);
                                setActAndLogStatus(message, "IPAConfiguration", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPAConfigurationStatus> payload = ::boost::static_pointer_cast<IPAConfigurationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPAConfigurationStatus >& refNullableStatus = proxy->_iPAConfiguration;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPAConfigurationCallbackIF*) _callback)->onIPAConfigurationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAConfigurationError);
                                setActAndLogError(message, "IPAConfiguration", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPAConfigurationCallbackIF*) _callback)->onIPAConfigurationError(proxy, ::boost::static_pointer_cast<IPAConfigurationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPAStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAStatusStatus);
                                setActAndLogStatus(message, "IPAStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPAStatusStatus> payload = ::boost::static_pointer_cast<IPAStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPAStatusStatus >& refNullableStatus = proxy->_iPAStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPAStatusCallbackIF*) _callback)->onIPAStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAStatusError);
                                setActAndLogError(message, "IPAStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPAStatusCallbackIF*) _callback)->onIPAStatusError(proxy, ::boost::static_pointer_cast<IPAStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPAPatternRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAPatternRequestStatus);
                                setActAndLogStatus(message, "IPAPatternRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPAPatternRequestStatus> payload = ::boost::static_pointer_cast<IPAPatternRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPAPatternRequestStatus >& refNullableStatus = proxy->_iPAPatternRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPAPatternRequestCallbackIF*) _callback)->onIPAPatternRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAPatternRequestError);
                                setActAndLogError(message, "IPAPatternRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPAPatternRequestCallbackIF*) _callback)->onIPAPatternRequestError(proxy, ::boost::static_pointer_cast<IPAPatternRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPAMessageRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAMessageRequestStatus);
                                setActAndLogStatus(message, "IPAMessageRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPAMessageRequestStatus> payload = ::boost::static_pointer_cast<IPAMessageRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPAMessageRequestStatus >& refNullableStatus = proxy->_iPAMessageRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPAMessageRequestCallbackIF*) _callback)->onIPAMessageRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPAMessageRequestError);
                                setActAndLogError(message, "IPAMessageRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPAMessageRequestCallbackIF*) _callback)->onIPAMessageRequestError(proxy, ::boost::static_pointer_cast<IPAMessageRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPASwitchMaskRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPASwitchMaskRequestStatus);
                                setActAndLogStatus(message, "IPASwitchMaskRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPASwitchMaskRequestStatus> payload = ::boost::static_pointer_cast<IPASwitchMaskRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPASwitchMaskRequestStatus >& refNullableStatus = proxy->_iPASwitchMaskRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPASwitchMaskRequestCallbackIF*) _callback)->onIPASwitchMaskRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPASwitchMaskRequestError);
                                setActAndLogError(message, "IPASwitchMaskRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPASwitchMaskRequestCallbackIF*) _callback)->onIPASwitchMaskRequestError(proxy, ::boost::static_pointer_cast<IPASwitchMaskRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPASwitchGreyOutRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPASwitchGreyOutRequestStatus);
                                setActAndLogStatus(message, "IPASwitchGreyOutRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPASwitchGreyOutRequestStatus> payload = ::boost::static_pointer_cast<IPASwitchGreyOutRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPASwitchGreyOutRequestStatus >& refNullableStatus = proxy->_iPASwitchGreyOutRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPASwitchGreyOutRequestCallbackIF*) _callback)->onIPASwitchGreyOutRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPASwitchGreyOutRequestError);
                                setActAndLogError(message, "IPASwitchGreyOutRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPASwitchGreyOutRequestCallbackIF*) _callback)->onIPASwitchGreyOutRequestError(proxy, ::boost::static_pointer_cast<IPASwitchGreyOutRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_IPADirectionIndicator: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPADirectionIndicatorStatus);
                                setActAndLogStatus(message, "IPADirectionIndicator", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<IPADirectionIndicatorStatus> payload = ::boost::static_pointer_cast<IPADirectionIndicatorStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< IPADirectionIndicatorStatus >& refNullableStatus = proxy->_iPADirectionIndicator;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((IPADirectionIndicatorCallbackIF*) _callback)->onIPADirectionIndicatorStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::IPADirectionIndicatorError);
                                setActAndLogError(message, "IPADirectionIndicator", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((IPADirectionIndicatorCallbackIF*) _callback)->onIPADirectionIndicatorError(proxy, ::boost::static_pointer_cast<IPADirectionIndicatorError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GdlAdj_SteeringAngle: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_SteeringAngleStatus);
                                setActAndLogStatus(message, "GdlAdj_SteeringAngle", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GdlAdj_SteeringAngleStatus> payload = ::boost::static_pointer_cast<GdlAdj_SteeringAngleStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GdlAdj_SteeringAngleStatus >& refNullableStatus = proxy->_gdlAdj_SteeringAngle;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GdlAdj_SteeringAngleCallbackIF*) _callback)->onGdlAdj_SteeringAngleStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_SteeringAngleError);
                                setActAndLogError(message, "GdlAdj_SteeringAngle", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((GdlAdj_SteeringAngleCallbackIF*) _callback)->onGdlAdj_SteeringAngleError(proxy, ::boost::static_pointer_cast<GdlAdj_SteeringAngleError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GdlAdj_CameraAngle: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_CameraAngleStatus);
                                setActAndLogStatus(message, "GdlAdj_CameraAngle", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<GdlAdj_CameraAngleStatus> payload = ::boost::static_pointer_cast<GdlAdj_CameraAngleStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< GdlAdj_CameraAngleStatus >& refNullableStatus = proxy->_gdlAdj_CameraAngle;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((GdlAdj_CameraAngleCallbackIF*) _callback)->onGdlAdj_CameraAngleStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_CameraAngleError);
                                setActAndLogError(message, "GdlAdj_CameraAngle", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((GdlAdj_CameraAngleCallbackIF*) _callback)->onGdlAdj_CameraAngleError(proxy, ::boost::static_pointer_cast<GdlAdj_CameraAngleError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CANFrameStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::CANFrameStatusStatus);
                                setActAndLogStatus(message, "CANFrameStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CANFrameStatusStatus> payload = ::boost::static_pointer_cast<CANFrameStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CANFrameStatusStatus >& refNullableStatus = proxy->_cANFrameStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CANFrameStatusCallbackIF*) _callback)->onCANFrameStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::CANFrameStatusError);
                                setActAndLogError(message, "CANFrameStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((CANFrameStatusCallbackIF*) _callback)->onCANFrameStatusError(proxy, ::boost::static_pointer_cast<CANFrameStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MvcViewStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MvcViewStatusStatus);
                                setActAndLogStatus(message, "MvcViewStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MvcViewStatusStatus> payload = ::boost::static_pointer_cast<MvcViewStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MvcViewStatusStatus >& refNullableStatus = proxy->_mvcViewStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MvcViewStatusCallbackIF*) _callback)->onMvcViewStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MvcViewStatusError);
                                setActAndLogError(message, "MvcViewStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((MvcViewStatusCallbackIF*) _callback)->onMvcViewStatusError(proxy, ::boost::static_pointer_cast<MvcViewStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_MvcAlertRequest: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MvcAlertRequestStatus);
                                setActAndLogStatus(message, "MvcAlertRequest", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<MvcAlertRequestStatus> payload = ::boost::static_pointer_cast<MvcAlertRequestStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< MvcAlertRequestStatus >& refNullableStatus = proxy->_mvcAlertRequest;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((MvcAlertRequestCallbackIF*) _callback)->onMvcAlertRequestStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::MvcAlertRequestError);
                                setActAndLogError(message, "MvcAlertRequest", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((MvcAlertRequestCallbackIF*) _callback)->onMvcAlertRequestError(proxy, ::boost::static_pointer_cast<MvcAlertRequestError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FAPMode: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAPModeStatus);
                                setActAndLogStatus(message, "FAPMode", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FAPModeStatus> payload = ::boost::static_pointer_cast<FAPModeStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FAPModeStatus >& refNullableStatus = proxy->_fAPMode;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FAPModeCallbackIF*) _callback)->onFAPModeStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAPModeError);
                                setActAndLogError(message, "FAPMode", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((FAPModeCallbackIF*) _callback)->onFAPModeError(proxy, ::boost::static_pointer_cast<FAPModeError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FAPSettings: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAPSettingsStatus);
                                setActAndLogStatus(message, "FAPSettings", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FAPSettingsStatus> payload = ::boost::static_pointer_cast<FAPSettingsStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FAPSettingsStatus >& refNullableStatus = proxy->_fAPSettings;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FAPSettingsCallbackIF*) _callback)->onFAPSettingsStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAPSettingsError);
                                setActAndLogError(message, "FAPSettings", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((FAPSettingsCallbackIF*) _callback)->onFAPSettingsError(proxy, ::boost::static_pointer_cast<FAPSettingsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FAPGuidanceState: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAPGuidanceStateStatus);
                                setActAndLogStatus(message, "FAPGuidanceState", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FAPGuidanceStateStatus> payload = ::boost::static_pointer_cast<FAPGuidanceStateStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FAPGuidanceStateStatus >& refNullableStatus = proxy->_fAPGuidanceState;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FAPGuidanceStateCallbackIF*) _callback)->onFAPGuidanceStateStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::FAPGuidanceStateError);
                                setActAndLogError(message, "FAPGuidanceState", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((FAPGuidanceStateCallbackIF*) _callback)->onFAPGuidanceStateError(proxy, ::boost::static_pointer_cast<FAPGuidanceStateError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_DispStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_DispStatusStatus);
                                setActAndLogStatus(message, "AVM3_DispStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_DispStatusStatus> payload = ::boost::static_pointer_cast<AVM3_DispStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_DispStatusStatus >& refNullableStatus = proxy->_aVM3_DispStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_DispStatusCallbackIF*) _callback)->onAVM3_DispStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_DispStatusError);
                                setActAndLogError(message, "AVM3_DispStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_DispStatusCallbackIF*) _callback)->onAVM3_DispStatusError(proxy, ::boost::static_pointer_cast<AVM3_DispStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_ViewSetup: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ViewSetupStatus);
                                setActAndLogStatus(message, "AVM3_ViewSetup", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_ViewSetupStatus> payload = ::boost::static_pointer_cast<AVM3_ViewSetupStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_ViewSetupStatus >& refNullableStatus = proxy->_aVM3_ViewSetup;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_ViewSetupCallbackIF*) _callback)->onAVM3_ViewSetupStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ViewSetupError);
                                setActAndLogError(message, "AVM3_ViewSetup", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_ViewSetupCallbackIF*) _callback)->onAVM3_ViewSetupError(proxy, ::boost::static_pointer_cast<AVM3_ViewSetupError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_ErrorMessage: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ErrorMessageStatus);
                                setActAndLogStatus(message, "AVM3_ErrorMessage", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_ErrorMessageStatus> payload = ::boost::static_pointer_cast<AVM3_ErrorMessageStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_ErrorMessageStatus >& refNullableStatus = proxy->_aVM3_ErrorMessage;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_ErrorMessageCallbackIF*) _callback)->onAVM3_ErrorMessageStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ErrorMessageError);
                                setActAndLogError(message, "AVM3_ErrorMessage", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_ErrorMessageCallbackIF*) _callback)->onAVM3_ErrorMessageError(proxy, ::boost::static_pointer_cast<AVM3_ErrorMessageError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_SonarBuzzerStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_SonarBuzzerStatusStatus);
                                setActAndLogStatus(message, "AVM3_SonarBuzzerStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_SonarBuzzerStatusStatus> payload = ::boost::static_pointer_cast<AVM3_SonarBuzzerStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_SonarBuzzerStatusStatus >& refNullableStatus = proxy->_aVM3_SonarBuzzerStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_SonarBuzzerStatusCallbackIF*) _callback)->onAVM3_SonarBuzzerStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_SonarBuzzerStatusError);
                                setActAndLogError(message, "AVM3_SonarBuzzerStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_SonarBuzzerStatusCallbackIF*) _callback)->onAVM3_SonarBuzzerStatusError(proxy, ::boost::static_pointer_cast<AVM3_SonarBuzzerStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Settings_Detailed: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_DetailedStatus);
                                setActAndLogStatus(message, "AVM3_Settings_Detailed", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_Settings_DetailedStatus> payload = ::boost::static_pointer_cast<AVM3_Settings_DetailedStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_Settings_DetailedStatus >& refNullableStatus = proxy->_aVM3_Settings_Detailed;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_Settings_DetailedCallbackIF*) _callback)->onAVM3_Settings_DetailedStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_DetailedError);
                                setActAndLogError(message, "AVM3_Settings_Detailed", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_Settings_DetailedCallbackIF*) _callback)->onAVM3_Settings_DetailedError(proxy, ::boost::static_pointer_cast<AVM3_Settings_DetailedError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Settings_Primary: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_PrimaryStatus);
                                setActAndLogStatus(message, "AVM3_Settings_Primary", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_Settings_PrimaryStatus> payload = ::boost::static_pointer_cast<AVM3_Settings_PrimaryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_Settings_PrimaryStatus >& refNullableStatus = proxy->_aVM3_Settings_Primary;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_Settings_PrimaryCallbackIF*) _callback)->onAVM3_Settings_PrimaryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_PrimaryError);
                                setActAndLogError(message, "AVM3_Settings_Primary", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_Settings_PrimaryCallbackIF*) _callback)->onAVM3_Settings_PrimaryError(proxy, ::boost::static_pointer_cast<AVM3_Settings_PrimaryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Configuration: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ConfigurationStatus);
                                setActAndLogStatus(message, "AVM3_Configuration", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_ConfigurationStatus> payload = ::boost::static_pointer_cast<AVM3_ConfigurationStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_ConfigurationStatus >& refNullableStatus = proxy->_aVM3_Configuration;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_ConfigurationCallbackIF*) _callback)->onAVM3_ConfigurationStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_ConfigurationError);
                                setActAndLogError(message, "AVM3_Configuration", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_ConfigurationCallbackIF*) _callback)->onAVM3_ConfigurationError(proxy, ::boost::static_pointer_cast<AVM3_ConfigurationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Software_Version: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Software_VersionStatus);
                                setActAndLogStatus(message, "AVM3_Software_Version", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_Software_VersionStatus> payload = ::boost::static_pointer_cast<AVM3_Software_VersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_Software_VersionStatus >& refNullableStatus = proxy->_aVM3_Software_Version;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_Software_VersionCallbackIF*) _callback)->onAVM3_Software_VersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Software_VersionError);
                                setActAndLogError(message, "AVM3_Software_Version", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_Software_VersionCallbackIF*) _callback)->onAVM3_Software_VersionError(proxy, ::boost::static_pointer_cast<AVM3_Software_VersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_Hardware_Version: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Hardware_VersionStatus);
                                setActAndLogStatus(message, "AVM3_Hardware_Version", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_Hardware_VersionStatus> payload = ::boost::static_pointer_cast<AVM3_Hardware_VersionStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_Hardware_VersionStatus >& refNullableStatus = proxy->_aVM3_Hardware_Version;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_Hardware_VersionCallbackIF*) _callback)->onAVM3_Hardware_VersionStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_Hardware_VersionError);
                                setActAndLogError(message, "AVM3_Hardware_Version", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_Hardware_VersionCallbackIF*) _callback)->onAVM3_Hardware_VersionError(proxy, ::boost::static_pointer_cast<AVM3_Hardware_VersionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AVM3_CommunicationErrors: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_CommunicationErrorsStatus);
                                setActAndLogStatus(message, "AVM3_CommunicationErrors", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AVM3_CommunicationErrorsStatus> payload = ::boost::static_pointer_cast<AVM3_CommunicationErrorsStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AVM3_CommunicationErrorsStatus >& refNullableStatus = proxy->_aVM3_CommunicationErrors;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AVM3_CommunicationErrorsCallbackIF*) _callback)->onAVM3_CommunicationErrorsStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::rvc_cca_fi::AVM3_CommunicationErrorsError);
                                setActAndLogError(message, "AVM3_CommunicationErrors", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    {
                                        ((AVM3_CommunicationErrorsCallbackIF*) _callback)->onAVM3_CommunicationErrorsError(proxy, ::boost::static_pointer_cast<AVM3_CommunicationErrorsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Rvc_cca_fiProxy> proxy = ::boost::static_pointer_cast<Rvc_cca_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_CameraButton: {
                ::boost::shared_ptr< CameraButtonError > payload (new CameraButtonError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CameraButton", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((CameraButtonCallbackIF*) _callback)->onCameraButtonError (proxy, payload);
                return true;
            }
            case FID_SetStatusHmi: {
                ::boost::shared_ptr< SetStatusHmiError > payload (new SetStatusHmiError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetStatusHmi", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetStatusHmiCallbackIF*) _callback)->onSetStatusHmiError (proxy, payload);
                return true;
            }
            case FID_SetupLanguage: {
                ::boost::shared_ptr< SetupLanguageError > payload (new SetupLanguageError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetupLanguage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetupLanguageCallbackIF*) _callback)->onSetupLanguageError (proxy, payload);
                return true;
            }
            case FID_SetupGuideLine: {
                ::boost::shared_ptr< SetupGuideLineError > payload (new SetupGuideLineError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetupGuideLine", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetupGuideLineCallbackIF*) _callback)->onSetupGuideLineError (proxy, payload);
                return true;
            }
            case FID_SetupVideoControls: {
                ::boost::shared_ptr< SetupVideoControlsError > payload (new SetupVideoControlsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetupVideoControls", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetupVideoControlsCallbackIF*) _callback)->onSetupVideoControlsError (proxy, payload);
                return true;
            }
            case FID_SetSystemStatus: {
                ::boost::shared_ptr< SetSystemStatusError > payload (new SetSystemStatusError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetSystemStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetSystemStatusCallbackIF*) _callback)->onSetSystemStatusError (proxy, payload);
                return true;
            }
            case FID_runExtDevicePowerSupplyTest: {
                ::boost::shared_ptr< RunExtDevicePowerSupplyTestError > payload (new RunExtDevicePowerSupplyTestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RunExtDevicePowerSupplyTest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((RunExtDevicePowerSupplyTestCallbackIF*) _callback)->onRunExtDevicePowerSupplyTestError (proxy, payload);
                return true;
            }
            case FID_Initialize: {
                ::boost::shared_ptr< InitializeError > payload (new InitializeError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Initialize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((InitializeCallbackIF*) _callback)->onInitializeError (proxy, payload);
                return true;
            }
            case FID_ConfirmSystemStatus: {
                ::boost::shared_ptr< ConfirmSystemStatusError > payload (new ConfirmSystemStatusError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ConfirmSystemStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ConfirmSystemStatusCallbackIF*) _callback)->onConfirmSystemStatusError (proxy, payload);
                return true;
            }
            case FID_SetupUserConfiguration: {
                ::boost::shared_ptr< SetupUserConfigurationError > payload (new SetupUserConfigurationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetupUserConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetupUserConfigurationCallbackIF*) _callback)->onSetupUserConfigurationError (proxy, payload);
                return true;
            }
            case FID_SetMicrophoneState: {
                ::boost::shared_ptr< SetMicrophoneStateError > payload (new SetMicrophoneStateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetMicrophoneState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetMicrophoneStateCallbackIF*) _callback)->onSetMicrophoneStateError (proxy, payload);
                return true;
            }
            case FID_SetRVCStatus: {
                ::boost::shared_ptr< SetRVCStatusError > payload (new SetRVCStatusError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetRVCStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetRVCStatusCallbackIF*) _callback)->onSetRVCStatusError (proxy, payload);
                return true;
            }
            case FID_Camera_SetupBeep: {
                ::boost::shared_ptr< Camera_SetupBeepError > payload (new Camera_SetupBeepError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Camera_SetupBeep", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Camera_SetupBeepCallbackIF*) _callback)->onCamera_SetupBeepError (proxy, payload);
                return true;
            }
            case FID_SetCamerastate: {
                ::boost::shared_ptr< SetCamerastateError > payload (new SetCamerastateError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCamerastate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetCamerastateCallbackIF*) _callback)->onSetCamerastateError (proxy, payload);
                return true;
            }
            case FID_ChangeViewRequest: {
                ::boost::shared_ptr< ChangeViewRequestError > payload (new ChangeViewRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ChangeViewRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ChangeViewRequestCallbackIF*) _callback)->onChangeViewRequestError (proxy, payload);
                return true;
            }
            case FID_Affordable_Its_SetupBsw: {
                ::boost::shared_ptr< Affordable_Its_SetupBswError > payload (new Affordable_Its_SetupBswError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Affordable_Its_SetupBsw", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Affordable_Its_SetupBswCallbackIF*) _callback)->onAffordable_Its_SetupBswError (proxy, payload);
                return true;
            }
            case FID_Affordable_Its_SetupMod: {
                ::boost::shared_ptr< Affordable_Its_SetupModError > payload (new Affordable_Its_SetupModError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Affordable_Its_SetupMod", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Affordable_Its_SetupModCallbackIF*) _callback)->onAffordable_Its_SetupModError (proxy, payload);
                return true;
            }
            case FID_Affordable_Its_SetupLdw: {
                ::boost::shared_ptr< Affordable_Its_SetupLdwError > payload (new Affordable_Its_SetupLdwError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Affordable_Its_SetupLdw", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((Affordable_Its_SetupLdwCallbackIF*) _callback)->onAffordable_Its_SetupLdwError (proxy, payload);
                return true;
            }
            case FID_IPA_SetHMIStatus: {
                ::boost::shared_ptr< IPA_SetHMIStatusError > payload (new IPA_SetHMIStatusError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPA_SetHMIStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((IPA_SetHMIStatusCallbackIF*) _callback)->onIPA_SetHMIStatusError (proxy, payload);
                return true;
            }
            case FID_IPA_SetButton: {
                ::boost::shared_ptr< IPA_SetButtonError > payload (new IPA_SetButtonError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPA_SetButton", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((IPA_SetButtonCallbackIF*) _callback)->onIPA_SetButtonError (proxy, payload);
                return true;
            }
            case FID_IPA_Voice_Texts: {
                ::boost::shared_ptr< IPA_Voice_TextsError > payload (new IPA_Voice_TextsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPA_Voice_Texts", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((IPA_Voice_TextsCallbackIF*) _callback)->onIPA_Voice_TextsError (proxy, payload);
                return true;
            }
            case FID_MVC_HMI_ViewRequest: {
                ::boost::shared_ptr< MVC_HMI_ViewRequestError > payload (new MVC_HMI_ViewRequestError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MVC_HMI_ViewRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((MVC_HMI_ViewRequestCallbackIF*) _callback)->onMVC_HMI_ViewRequestError (proxy, payload);
                return true;
            }
            case FID_GdlAdj_AdjustmentComplete: {
                ::boost::shared_ptr< GdlAdj_AdjustmentCompleteError > payload (new GdlAdj_AdjustmentCompleteError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GdlAdj_AdjustmentComplete", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GdlAdj_AdjustmentCompleteCallbackIF*) _callback)->onGdlAdj_AdjustmentCompleteError (proxy, payload);
                return true;
            }
            case FID_GdlAdj_AdjustButton: {
                ::boost::shared_ptr< GdlAdj_AdjustButtonError > payload (new GdlAdj_AdjustButtonError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GdlAdj_AdjustButton", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GdlAdj_AdjustButtonCallbackIF*) _callback)->onGdlAdj_AdjustButtonError (proxy, payload);
                return true;
            }
            case FID_GdlAdj_ConfigurationData: {
                ::boost::shared_ptr< GdlAdj_ConfigurationDataError > payload (new GdlAdj_ConfigurationDataError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GdlAdj_ConfigurationData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GdlAdj_ConfigurationDataCallbackIF*) _callback)->onGdlAdj_ConfigurationDataError (proxy, payload);
                return true;
            }
            case FID_FAP_SetButton: {
                ::boost::shared_ptr< FAP_SetButtonError > payload (new FAP_SetButtonError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FAP_SetButton", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((FAP_SetButtonCallbackIF*) _callback)->onFAP_SetButtonError (proxy, payload);
                return true;
            }
            case FID_TouchEvent: {
                ::boost::shared_ptr< TouchEventError > payload (new TouchEventError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TouchEvent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((TouchEventCallbackIF*) _callback)->onTouchEventError (proxy, payload);
                return true;
            }
            case FID_GPSInfo: {
                ::boost::shared_ptr< GPSInfoError > payload (new GPSInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GPSInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GPSInfoCallbackIF*) _callback)->onGPSInfoError (proxy, payload);
                return true;
            }
            case FID_MapMatchedInfo: {
                ::boost::shared_ptr< MapMatchedInfoError > payload (new MapMatchedInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MapMatchedInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((MapMatchedInfoCallbackIF*) _callback)->onMapMatchedInfoError (proxy, payload);
                return true;
            }
            case FID_FapLearnParkPosition: {
                ::boost::shared_ptr< FapLearnParkPositionError > payload (new FapLearnParkPositionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FapLearnParkPosition", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((FapLearnParkPositionCallbackIF*) _callback)->onFapLearnParkPositionError (proxy, payload);
                return true;
            }
            case FID_SetFapGuidance: {
                ::boost::shared_ptr< SetFapGuidanceError > payload (new SetFapGuidanceError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFapGuidance", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SetFapGuidanceCallbackIF*) _callback)->onSetFapGuidanceError (proxy, payload);
                return true;
            }
            case FID_AVM3_SetSwitch: {
                ::boost::shared_ptr< AVM3_SetSwitchError > payload (new AVM3_SetSwitchError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_SetSwitch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_SetSwitchCallbackIF*) _callback)->onAVM3_SetSwitchError (proxy, payload);
                return true;
            }
            case FID_AVM3_SetSonarBuzzerStatus: {
                ::boost::shared_ptr< AVM3_SetSonarBuzzerStatusError > payload (new AVM3_SetSonarBuzzerStatusError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_SetSonarBuzzerStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_SetSonarBuzzerStatusCallbackIF*) _callback)->onAVM3_SetSonarBuzzerStatusError (proxy, payload);
                return true;
            }
            case FID_AVM3_Settings_Detailed_SendReq: {
                ::boost::shared_ptr< AVM3_Settings_Detailed_SendReqError > payload (new AVM3_Settings_Detailed_SendReqError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Settings_Detailed_SendReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_Settings_Detailed_SendReqCallbackIF*) _callback)->onAVM3_Settings_Detailed_SendReqError (proxy, payload);
                return true;
            }
            case FID_AVM3_Settings_Primary_SendReq: {
                ::boost::shared_ptr< AVM3_Settings_Primary_SendReqError > payload (new AVM3_Settings_Primary_SendReqError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Settings_Primary_SendReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_Settings_Primary_SendReqCallbackIF*) _callback)->onAVM3_Settings_Primary_SendReqError (proxy, payload);
                return true;
            }
            case FID_AVM3_GetVersionInfo: {
                ::boost::shared_ptr< AVM3_GetVersionInfoError > payload (new AVM3_GetVersionInfoError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_GetVersionInfo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_GetVersionInfoCallbackIF*) _callback)->onAVM3_GetVersionInfoError (proxy, payload);
                return true;
            }
            case FID_AVM3_GetCommunicationErrors: {
                ::boost::shared_ptr< AVM3_GetCommunicationErrorsError > payload (new AVM3_GetCommunicationErrorsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_GetCommunicationErrors", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_GetCommunicationErrorsCallbackIF*) _callback)->onAVM3_GetCommunicationErrorsError (proxy, payload);
                return true;
            }
            case FID_AVM3_ClearCommunicationErrors: {
                ::boost::shared_ptr< AVM3_ClearCommunicationErrorsError > payload (new AVM3_ClearCommunicationErrorsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_ClearCommunicationErrors", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((AVM3_ClearCommunicationErrorsCallbackIF*) _callback)->onAVM3_ClearCommunicationErrorsError (proxy, payload);
                return true;
            }
            case FID_ToggleGpioPinOnOff: {
                ::boost::shared_ptr< ToggleGpioPinOnOffError > payload (new ToggleGpioPinOnOffError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ToggleGpioPinOnOff", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((ToggleGpioPinOnOffCallbackIF*) _callback)->onToggleGpioPinOnOffError (proxy, payload);
                return true;
            }
            case FID_SystemConfigurations: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< SystemConfigurationsError > payload (new SystemConfigurationsError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemConfigurations", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SystemConfigurationsCallbackIF*) _callback)->onSystemConfigurationsError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SystemStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< SystemStatusError > payload (new SystemStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SystemStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SystemStatusCallbackIF*) _callback)->onSystemStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VideoSignalStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< VideoSignalStatusError > payload (new VideoSignalStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VideoSignalStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VideoSignalStatusCallbackIF*) _callback)->onVideoSignalStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ReverseSignalStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< ReverseSignalStatusError > payload (new ReverseSignalStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReverseSignalStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ReverseSignalStatusCallbackIF*) _callback)->onReverseSignalStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Camera_PwrSupplyStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< Camera_PwrSupplyStatusError > payload (new Camera_PwrSupplyStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Camera_PwrSupplyStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Camera_PwrSupplyStatusCallbackIF*) _callback)->onCamera_PwrSupplyStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Microphone_PwrSupplyStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< Microphone_PwrSupplyStatusError > payload (new Microphone_PwrSupplyStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Microphone_PwrSupplyStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Microphone_PwrSupplyStatusCallbackIF*) _callback)->onMicrophone_PwrSupplyStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Tailgate_Status: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< Tailgate_StatusError > payload (new Tailgate_StatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Tailgate_Status", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Tailgate_StatusCallbackIF*) _callback)->onTailgate_StatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_View_Close_Authorized: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< View_Close_AuthorizedError > payload (new View_Close_AuthorizedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "View_Close_Authorized", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((View_Close_AuthorizedCallbackIF*) _callback)->onView_Close_AuthorizedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AvmR_Current_View: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AvmR_Current_ViewError > payload (new AvmR_Current_ViewError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AvmR_Current_View", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AvmR_Current_ViewCallbackIF*) _callback)->onAvmR_Current_ViewError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_Affordable_ITS: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< Affordable_ITSError > payload (new Affordable_ITSError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Affordable_ITS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((Affordable_ITSCallbackIF*) _callback)->onAffordable_ITSError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPAConfiguration: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPAConfigurationError > payload (new IPAConfigurationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPAConfiguration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPAConfigurationCallbackIF*) _callback)->onIPAConfigurationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPAStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPAStatusError > payload (new IPAStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPAStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPAStatusCallbackIF*) _callback)->onIPAStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPAPatternRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPAPatternRequestError > payload (new IPAPatternRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPAPatternRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPAPatternRequestCallbackIF*) _callback)->onIPAPatternRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPAMessageRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPAMessageRequestError > payload (new IPAMessageRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPAMessageRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPAMessageRequestCallbackIF*) _callback)->onIPAMessageRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPASwitchMaskRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPASwitchMaskRequestError > payload (new IPASwitchMaskRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPASwitchMaskRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPASwitchMaskRequestCallbackIF*) _callback)->onIPASwitchMaskRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPASwitchGreyOutRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPASwitchGreyOutRequestError > payload (new IPASwitchGreyOutRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPASwitchGreyOutRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPASwitchGreyOutRequestCallbackIF*) _callback)->onIPASwitchGreyOutRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_IPADirectionIndicator: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< IPADirectionIndicatorError > payload (new IPADirectionIndicatorError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "IPADirectionIndicator", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((IPADirectionIndicatorCallbackIF*) _callback)->onIPADirectionIndicatorError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GdlAdj_SteeringAngle: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< GdlAdj_SteeringAngleError > payload (new GdlAdj_SteeringAngleError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GdlAdj_SteeringAngle", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GdlAdj_SteeringAngleCallbackIF*) _callback)->onGdlAdj_SteeringAngleError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_GdlAdj_CameraAngle: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< GdlAdj_CameraAngleError > payload (new GdlAdj_CameraAngleError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GdlAdj_CameraAngle", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((GdlAdj_CameraAngleCallbackIF*) _callback)->onGdlAdj_CameraAngleError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CANFrameStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< CANFrameStatusError > payload (new CANFrameStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CANFrameStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CANFrameStatusCallbackIF*) _callback)->onCANFrameStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MvcViewStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< MvcViewStatusError > payload (new MvcViewStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MvcViewStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MvcViewStatusCallbackIF*) _callback)->onMvcViewStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_MvcAlertRequest: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< MvcAlertRequestError > payload (new MvcAlertRequestError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MvcAlertRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((MvcAlertRequestCallbackIF*) _callback)->onMvcAlertRequestError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FAPMode: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< FAPModeError > payload (new FAPModeError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FAPMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FAPModeCallbackIF*) _callback)->onFAPModeError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FAPSettings: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< FAPSettingsError > payload (new FAPSettingsError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FAPSettings", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FAPSettingsCallbackIF*) _callback)->onFAPSettingsError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FAPGuidanceState: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< FAPGuidanceStateError > payload (new FAPGuidanceStateError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FAPGuidanceState", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FAPGuidanceStateCallbackIF*) _callback)->onFAPGuidanceStateError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_DispStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_DispStatusError > payload (new AVM3_DispStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_DispStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_DispStatusCallbackIF*) _callback)->onAVM3_DispStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_ViewSetup: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_ViewSetupError > payload (new AVM3_ViewSetupError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_ViewSetup", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_ViewSetupCallbackIF*) _callback)->onAVM3_ViewSetupError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_ErrorMessage: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_ErrorMessageError > payload (new AVM3_ErrorMessageError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_ErrorMessage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_ErrorMessageCallbackIF*) _callback)->onAVM3_ErrorMessageError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_SonarBuzzerStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_SonarBuzzerStatusError > payload (new AVM3_SonarBuzzerStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_SonarBuzzerStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_SonarBuzzerStatusCallbackIF*) _callback)->onAVM3_SonarBuzzerStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_Settings_Detailed: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_Settings_DetailedError > payload (new AVM3_Settings_DetailedError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Settings_Detailed", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_Settings_DetailedCallbackIF*) _callback)->onAVM3_Settings_DetailedError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_Settings_Primary: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_Settings_PrimaryError > payload (new AVM3_Settings_PrimaryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Settings_Primary", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_Settings_PrimaryCallbackIF*) _callback)->onAVM3_Settings_PrimaryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_Configuration: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_ConfigurationError > payload (new AVM3_ConfigurationError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Configuration", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_ConfigurationCallbackIF*) _callback)->onAVM3_ConfigurationError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_Software_Version: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_Software_VersionError > payload (new AVM3_Software_VersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Software_Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_Software_VersionCallbackIF*) _callback)->onAVM3_Software_VersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_Hardware_Version: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_Hardware_VersionError > payload (new AVM3_Hardware_VersionError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_Hardware_Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_Hardware_VersionCallbackIF*) _callback)->onAVM3_Hardware_VersionError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AVM3_CommunicationErrors: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    {
                        ::boost::shared_ptr< AVM3_CommunicationErrorsError > payload (new AVM3_CommunicationErrorsError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AVM3_CommunicationErrors", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AVM3_CommunicationErrorsCallbackIF*) _callback)->onAVM3_CommunicationErrorsError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Rvc_cca_fiProxyCallback::_logger (Rvc_cca_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Rvc_cca_fiProxy > Rvc_cca_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Rvc_cca_fiProxy >  proxyNew(new Rvc_cca_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Rvc_cca_fiProxy > Rvc_cca_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Rvc_cca_fiProxy >  proxyNew(new Rvc_cca_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Rvc_cca_fiProxy > Rvc_cca_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Rvc_cca_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Rvc_cca_fiProxy >  proxyNew(new Rvc_cca_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Rvc_cca_fiProxy::Rvc_cca_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Rvc_cca_fiProxy::~Rvc_cca_fiProxy()
{
    LOG_INFO ("Entering ~Rvc_cca_fiProxy");
    sendRelUpRegAll ();
}

act_t Rvc_cca_fiProxy::sendCameraButtonStart(CameraButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_CameraButton);
        ::boost::shared_ptr< CameraButtonStart > payload (new CameraButtonStart());
        payload->setE8ButtonState(e8ButtonState);
        CCA_MESSAGE(ccaMessage,header,CameraButtonStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "CameraButton", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CameraButton);
        ::boost::shared_ptr< CameraButtonError > payload (new CameraButtonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CameraButtonError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "CameraButton", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetStatusHmiStart(SetStatusHmiCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_Status e8StatusHmi) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetStatusHmi);
        ::boost::shared_ptr< SetStatusHmiStart > payload (new SetStatusHmiStart());
        payload->setE8StatusHmi(e8StatusHmi);
        CCA_MESSAGE(ccaMessage,header,SetStatusHmiStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetStatusHmi", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetStatusHmi);
        ::boost::shared_ptr< SetStatusHmiError > payload (new SetStatusHmiError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetStatusHmiError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetStatusHmi", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetupLanguageStart(SetupLanguageCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_Language e8Language) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetupLanguage);
        ::boost::shared_ptr< SetupLanguageStart > payload (new SetupLanguageStart());
        payload->setE8Language(e8Language);
        CCA_MESSAGE(ccaMessage,header,SetupLanguageStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetupLanguage", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetupLanguage);
        ::boost::shared_ptr< SetupLanguageError > payload (new SetupLanguageError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetupLanguageError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetupLanguage", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetupGuideLineStart(SetupGuideLineCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetupGuideLine);
        ::boost::shared_ptr< SetupGuideLineStart > payload (new SetupGuideLineStart());
        payload->setE8GuideLine(e8GuideLine);
        CCA_MESSAGE(ccaMessage,header,SetupGuideLineStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetupGuideLine", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetupGuideLine);
        ::boost::shared_ptr< SetupGuideLineError > payload (new SetupGuideLineError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetupGuideLineError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetupGuideLine", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetupVideoControlsStart(SetupVideoControlsCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode e8HMIDimmingMode, const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& arVideoControlParameter, ::rvc_cca_fi_types::T_e8_MVCViewingState e8MVCViewingState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetupVideoControls);
        ::boost::shared_ptr< SetupVideoControlsStart > payload (new SetupVideoControlsStart());
        payload->setE8HMIDimmingMode(e8HMIDimmingMode);
        payload->setArVideoControlParameter(arVideoControlParameter);
        payload->setE8MVCViewingState(e8MVCViewingState);
        CCA_MESSAGE(ccaMessage,header,SetupVideoControlsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetupVideoControls", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetupVideoControls);
        ::boost::shared_ptr< SetupVideoControlsError > payload (new SetupVideoControlsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetupVideoControlsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetupVideoControls", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetSystemStatusStart(SetSystemStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus, ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine e8GuideLine, ::rvc_cca_fi_types::T_e8_RVC_StatusWarningText e8WarningText) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetSystemStatus);
        ::boost::shared_ptr< SetSystemStatusStart > payload (new SetSystemStatusStart());
        payload->setE8SystemStatus(e8SystemStatus);
        payload->setE8GuideLine(e8GuideLine);
        payload->setE8WarningText(e8WarningText);
        CCA_MESSAGE(ccaMessage,header,SetSystemStatusStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetSystemStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetSystemStatus);
        ::boost::shared_ptr< SetSystemStatusError > payload (new SetSystemStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetSystemStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetSystemStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendRunExtDevicePowerSupplyTestStart(RunExtDevicePowerSupplyTestCallbackIF& cb, uint16 pwrSupplyID) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_runExtDevicePowerSupplyTest);
        ::boost::shared_ptr< RunExtDevicePowerSupplyTestStart > payload (new RunExtDevicePowerSupplyTestStart());
        payload->setPwrSupplyID(pwrSupplyID);
        CCA_MESSAGE(ccaMessage,header,RunExtDevicePowerSupplyTestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "RunExtDevicePowerSupplyTest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_runExtDevicePowerSupplyTest);
        ::boost::shared_ptr< RunExtDevicePowerSupplyTestError > payload (new RunExtDevicePowerSupplyTestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RunExtDevicePowerSupplyTestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "RunExtDevicePowerSupplyTest", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendInitializeStart(InitializeCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_Module e8Module) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Initialize);
        ::boost::shared_ptr< InitializeStart > payload (new InitializeStart());
        payload->setE8Module(e8Module);
        CCA_MESSAGE(ccaMessage,header,InitializeStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Initialize", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Initialize);
        ::boost::shared_ptr< InitializeError > payload (new InitializeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,InitializeError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Initialize", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendConfirmSystemStatusStart(ConfirmSystemStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_SystemStatus e8SystemStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ConfirmSystemStatus);
        ::boost::shared_ptr< ConfirmSystemStatusStart > payload (new ConfirmSystemStatusStart());
        payload->setE8SystemStatus(e8SystemStatus);
        CCA_MESSAGE(ccaMessage,header,ConfirmSystemStatusStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ConfirmSystemStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ConfirmSystemStatus);
        ::boost::shared_ptr< ConfirmSystemStatusError > payload (new ConfirmSystemStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ConfirmSystemStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ConfirmSystemStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetupUserConfigurationStart(SetupUserConfigurationCallbackIF& cb, const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& arUserConfiguration) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetupUserConfiguration);
        ::boost::shared_ptr< SetupUserConfigurationStart > payload (new SetupUserConfigurationStart());
        payload->setArUserConfiguration(arUserConfiguration);
        CCA_MESSAGE(ccaMessage,header,SetupUserConfigurationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetupUserConfiguration", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetupUserConfiguration);
        ::boost::shared_ptr< SetupUserConfigurationError > payload (new SetupUserConfigurationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetupUserConfigurationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetupUserConfiguration", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetMicrophoneStateStart(SetMicrophoneStateCallbackIF& cb, ::rvc_cca_fi_types::T_e8_Set_MicState e8RequestState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetMicrophoneState);
        ::boost::shared_ptr< SetMicrophoneStateStart > payload (new SetMicrophoneStateStart());
        payload->setE8RequestState(e8RequestState);
        CCA_MESSAGE(ccaMessage,header,SetMicrophoneStateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetMicrophoneState", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetMicrophoneState);
        ::boost::shared_ptr< SetMicrophoneStateError > payload (new SetMicrophoneStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetMicrophoneStateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetMicrophoneState", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetRVCStatusStart(SetRVCStatusCallbackIF& cb, uint8 e8RequestState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetRVCStatus);
        ::boost::shared_ptr< SetRVCStatusStart > payload (new SetRVCStatusStart());
        payload->setE8RequestState(e8RequestState);
        CCA_MESSAGE(ccaMessage,header,SetRVCStatusStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetRVCStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetRVCStatus);
        ::boost::shared_ptr< SetRVCStatusError > payload (new SetRVCStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetRVCStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetRVCStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendCamera_SetupBeepStart(Camera_SetupBeepCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVM_StatusBeep e8SetupBeep) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Camera_SetupBeep);
        ::boost::shared_ptr< Camera_SetupBeepStart > payload (new Camera_SetupBeepStart());
        payload->setE8SetupBeep(e8SetupBeep);
        CCA_MESSAGE(ccaMessage,header,Camera_SetupBeepStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Camera_SetupBeep", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Camera_SetupBeep);
        ::boost::shared_ptr< Camera_SetupBeepError > payload (new Camera_SetupBeepError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Camera_SetupBeepError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Camera_SetupBeep", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetCamerastateStart(SetCamerastateCallbackIF& cb, ::rvc_cca_fi_types::T_e8_RVC_CameraState cameraState) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetCamerastate);
        ::boost::shared_ptr< SetCamerastateStart > payload (new SetCamerastateStart());
        payload->setCameraState(cameraState);
        CCA_MESSAGE(ccaMessage,header,SetCamerastateStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetCamerastate", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetCamerastate);
        ::boost::shared_ptr< SetCamerastateError > payload (new SetCamerastateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetCamerastateError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetCamerastate", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendChangeViewRequestStart(ChangeViewRequestCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVM_View_Request u8Status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ChangeViewRequest);
        ::boost::shared_ptr< ChangeViewRequestStart > payload (new ChangeViewRequestStart());
        payload->setU8Status(u8Status);
        CCA_MESSAGE(ccaMessage,header,ChangeViewRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ChangeViewRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ChangeViewRequest);
        ::boost::shared_ptr< ChangeViewRequestError > payload (new ChangeViewRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ChangeViewRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ChangeViewRequest", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAffordable_Its_SetupBswStart(Affordable_Its_SetupBswCallbackIF& cb, uint8 u8Status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Affordable_Its_SetupBsw);
        ::boost::shared_ptr< Affordable_Its_SetupBswStart > payload (new Affordable_Its_SetupBswStart());
        payload->setU8Status(u8Status);
        CCA_MESSAGE(ccaMessage,header,Affordable_Its_SetupBswStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Affordable_Its_SetupBsw", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Affordable_Its_SetupBsw);
        ::boost::shared_ptr< Affordable_Its_SetupBswError > payload (new Affordable_Its_SetupBswError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Affordable_Its_SetupBswError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Affordable_Its_SetupBsw", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAffordable_Its_SetupModStart(Affordable_Its_SetupModCallbackIF& cb, uint8 u8Status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Affordable_Its_SetupMod);
        ::boost::shared_ptr< Affordable_Its_SetupModStart > payload (new Affordable_Its_SetupModStart());
        payload->setU8Status(u8Status);
        CCA_MESSAGE(ccaMessage,header,Affordable_Its_SetupModStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Affordable_Its_SetupMod", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Affordable_Its_SetupMod);
        ::boost::shared_ptr< Affordable_Its_SetupModError > payload (new Affordable_Its_SetupModError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Affordable_Its_SetupModError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Affordable_Its_SetupMod", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAffordable_Its_SetupLdwStart(Affordable_Its_SetupLdwCallbackIF& cb, uint8 u8Status) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_Affordable_Its_SetupLdw);
        ::boost::shared_ptr< Affordable_Its_SetupLdwStart > payload (new Affordable_Its_SetupLdwStart());
        payload->setU8Status(u8Status);
        CCA_MESSAGE(ccaMessage,header,Affordable_Its_SetupLdwStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "Affordable_Its_SetupLdw", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Affordable_Its_SetupLdw);
        ::boost::shared_ptr< Affordable_Its_SetupLdwError > payload (new Affordable_Its_SetupLdwError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Affordable_Its_SetupLdwError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "Affordable_Its_SetupLdw", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendIPA_SetHMIStatusStart(IPA_SetHMIStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_IPA_HMIStatus e8IPAStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_IPA_SetHMIStatus);
        ::boost::shared_ptr< IPA_SetHMIStatusStart > payload (new IPA_SetHMIStatusStart());
        payload->setE8IPAStatus(e8IPAStatus);
        CCA_MESSAGE(ccaMessage,header,IPA_SetHMIStatusStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "IPA_SetHMIStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPA_SetHMIStatus);
        ::boost::shared_ptr< IPA_SetHMIStatusError > payload (new IPA_SetHMIStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPA_SetHMIStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "IPA_SetHMIStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendIPA_SetButtonStart(IPA_SetButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID e8ButtonIdentifier, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_IPA_SetButton);
        ::boost::shared_ptr< IPA_SetButtonStart > payload (new IPA_SetButtonStart());
        payload->setE8ButtonIdentifier(e8ButtonIdentifier);
        payload->setE8ButtonStatus(e8ButtonStatus);
        CCA_MESSAGE(ccaMessage,header,IPA_SetButtonStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "IPA_SetButton", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPA_SetButton);
        ::boost::shared_ptr< IPA_SetButtonError > payload (new IPA_SetButtonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPA_SetButtonError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "IPA_SetButton", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendIPA_Voice_TextsStart(IPA_Voice_TextsCallbackIF& cb, const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& arTexts, ::rvc_cca_fi_types::T_e8_RVC_Language language) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_IPA_Voice_Texts);
        ::boost::shared_ptr< IPA_Voice_TextsStart > payload (new IPA_Voice_TextsStart());
        payload->setArTexts(arTexts);
        payload->setLanguage(language);
        CCA_MESSAGE(ccaMessage,header,IPA_Voice_TextsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "IPA_Voice_Texts", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPA_Voice_Texts);
        ::boost::shared_ptr< IPA_Voice_TextsError > payload (new IPA_Voice_TextsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPA_Voice_TextsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "IPA_Voice_Texts", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendMVC_HMI_ViewRequestStart(MVC_HMI_ViewRequestCallbackIF& cb, ::rvc_cca_fi_types::T_e8_MVCViewingState e8Request) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_MVC_HMI_ViewRequest);
        ::boost::shared_ptr< MVC_HMI_ViewRequestStart > payload (new MVC_HMI_ViewRequestStart());
        payload->setE8Request(e8Request);
        CCA_MESSAGE(ccaMessage,header,MVC_HMI_ViewRequestStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "MVC_HMI_ViewRequest", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MVC_HMI_ViewRequest);
        ::boost::shared_ptr< MVC_HMI_ViewRequestError > payload (new MVC_HMI_ViewRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MVC_HMI_ViewRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "MVC_HMI_ViewRequest", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendGdlAdj_AdjustmentCompleteStart(GdlAdj_AdjustmentCompleteCallbackIF& cb, ::rvc_cca_fi_types::T_e8_GdlAdj_Completion e8Completion) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GdlAdj_AdjustmentComplete);
        ::boost::shared_ptr< GdlAdj_AdjustmentCompleteStart > payload (new GdlAdj_AdjustmentCompleteStart());
        payload->setE8Completion(e8Completion);
        CCA_MESSAGE(ccaMessage,header,GdlAdj_AdjustmentCompleteStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GdlAdj_AdjustmentComplete", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GdlAdj_AdjustmentComplete);
        ::boost::shared_ptr< GdlAdj_AdjustmentCompleteError > payload (new GdlAdj_AdjustmentCompleteError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GdlAdj_AdjustmentCompleteError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GdlAdj_AdjustmentComplete", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendGdlAdj_AdjustButtonStart(GdlAdj_AdjustButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton e8Button) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GdlAdj_AdjustButton);
        ::boost::shared_ptr< GdlAdj_AdjustButtonStart > payload (new GdlAdj_AdjustButtonStart());
        payload->setE8Button(e8Button);
        CCA_MESSAGE(ccaMessage,header,GdlAdj_AdjustButtonStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GdlAdj_AdjustButton", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GdlAdj_AdjustButton);
        ::boost::shared_ptr< GdlAdj_AdjustButtonError > payload (new GdlAdj_AdjustButtonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GdlAdj_AdjustButtonError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GdlAdj_AdjustButton", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendGdlAdj_ConfigurationDataStart(GdlAdj_ConfigurationDataCallbackIF& cb, ::rvc_cca_fi_types::T_e8_GdlAdj_Request e8Request, const ::std::vector< ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData >& arConfigParameterData) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GdlAdj_ConfigurationData);
        ::boost::shared_ptr< GdlAdj_ConfigurationDataStart > payload (new GdlAdj_ConfigurationDataStart());
        payload->setE8Request(e8Request);
        payload->setArConfigParameterData(arConfigParameterData);
        CCA_MESSAGE(ccaMessage,header,GdlAdj_ConfigurationDataStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GdlAdj_ConfigurationData", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GdlAdj_ConfigurationData);
        ::boost::shared_ptr< GdlAdj_ConfigurationDataError > payload (new GdlAdj_ConfigurationDataError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GdlAdj_ConfigurationDataError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GdlAdj_ConfigurationData", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendFAP_SetButtonStart(FAP_SetButtonCallbackIF& cb, ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID e8ButtonIdentifier, ::rvc_cca_fi_types::T_e8_RVC_ButtonState e8ButtonStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_FAP_SetButton);
        ::boost::shared_ptr< FAP_SetButtonStart > payload (new FAP_SetButtonStart());
        payload->setE8ButtonIdentifier(e8ButtonIdentifier);
        payload->setE8ButtonStatus(e8ButtonStatus);
        CCA_MESSAGE(ccaMessage,header,FAP_SetButtonStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "FAP_SetButton", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FAP_SetButton);
        ::boost::shared_ptr< FAP_SetButtonError > payload (new FAP_SetButtonError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FAP_SetButtonError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "FAP_SetButton", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendTouchEventStart(TouchEventCallbackIF& cb, const ::rvc_cca_fi_types::T_Touch_Data& arTouchData) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_TouchEvent);
        ::boost::shared_ptr< TouchEventStart > payload (new TouchEventStart());
        payload->setArTouchData(arTouchData);
        CCA_MESSAGE(ccaMessage,header,TouchEventStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "TouchEvent", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TouchEvent);
        ::boost::shared_ptr< TouchEventError > payload (new TouchEventError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TouchEventError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "TouchEvent", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendGPSInfoStart(GPSInfoCallbackIF& cb, const ::rvc_cca_fi_types::T_GPS_Data& arGpsData) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GPSInfo);
        ::boost::shared_ptr< GPSInfoStart > payload (new GPSInfoStart());
        payload->setArGpsData(arGpsData);
        CCA_MESSAGE(ccaMessage,header,GPSInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GPSInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GPSInfo);
        ::boost::shared_ptr< GPSInfoError > payload (new GPSInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GPSInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GPSInfo", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendMapMatchedInfoStart(MapMatchedInfoCallbackIF& cb, const ::rvc_cca_fi_types::T_MapMatched_Data& arMapMatchedData) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_MapMatchedInfo);
        ::boost::shared_ptr< MapMatchedInfoStart > payload (new MapMatchedInfoStart());
        payload->setArMapMatchedData(arMapMatchedData);
        CCA_MESSAGE(ccaMessage,header,MapMatchedInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "MapMatchedInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MapMatchedInfo);
        ::boost::shared_ptr< MapMatchedInfoError > payload (new MapMatchedInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MapMatchedInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "MapMatchedInfo", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendFapLearnParkPositionStart(FapLearnParkPositionCallbackIF& cb, bool requestOn) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_FapLearnParkPosition);
        ::boost::shared_ptr< FapLearnParkPositionStart > payload (new FapLearnParkPositionStart());
        payload->setRequestOn(requestOn);
        CCA_MESSAGE(ccaMessage,header,FapLearnParkPositionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "FapLearnParkPosition", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FapLearnParkPosition);
        ::boost::shared_ptr< FapLearnParkPositionError > payload (new FapLearnParkPositionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FapLearnParkPositionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "FapLearnParkPosition", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSetFapGuidanceStart(SetFapGuidanceCallbackIF& cb, bool request) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_SetFapGuidance);
        ::boost::shared_ptr< SetFapGuidanceStart > payload (new SetFapGuidanceStart());
        payload->setRequest(request);
        CCA_MESSAGE(ccaMessage,header,SetFapGuidanceStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SetFapGuidance", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SetFapGuidance);
        ::boost::shared_ptr< SetFapGuidanceError > payload (new SetFapGuidanceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SetFapGuidanceError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SetFapGuidance", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_SetSwitchStart(AVM3_SetSwitchCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_SwitchId e8SwitchId) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_SetSwitch);
        ::boost::shared_ptr< AVM3_SetSwitchStart > payload (new AVM3_SetSwitchStart());
        payload->setE8SwitchId(e8SwitchId);
        CCA_MESSAGE(ccaMessage,header,AVM3_SetSwitchStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_SetSwitch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_SetSwitch);
        ::boost::shared_ptr< AVM3_SetSwitchError > payload (new AVM3_SetSwitchError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_SetSwitchError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_SetSwitch", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_SetSonarBuzzerStatusStart(AVM3_SetSonarBuzzerStatusCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus e8BuzzerStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_SetSonarBuzzerStatus);
        ::boost::shared_ptr< AVM3_SetSonarBuzzerStatusStart > payload (new AVM3_SetSonarBuzzerStatusStart());
        payload->setE8BuzzerStatus(e8BuzzerStatus);
        CCA_MESSAGE(ccaMessage,header,AVM3_SetSonarBuzzerStatusStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_SetSonarBuzzerStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_SetSonarBuzzerStatus);
        ::boost::shared_ptr< AVM3_SetSonarBuzzerStatusError > payload (new AVM3_SetSonarBuzzerStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_SetSonarBuzzerStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_SetSonarBuzzerStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_Settings_Detailed_SendReqStart(AVM3_Settings_Detailed_SendReqCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_RequestType e8RequestType, const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Item >& arChangedItems) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_Settings_Detailed_SendReq);
        ::boost::shared_ptr< AVM3_Settings_Detailed_SendReqStart > payload (new AVM3_Settings_Detailed_SendReqStart());
        payload->setE8RequestType(e8RequestType);
        payload->setArChangedItems(arChangedItems);
        CCA_MESSAGE(ccaMessage,header,AVM3_Settings_Detailed_SendReqStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_Settings_Detailed_SendReq", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Settings_Detailed_SendReq);
        ::boost::shared_ptr< AVM3_Settings_Detailed_SendReqError > payload (new AVM3_Settings_Detailed_SendReqError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_Settings_Detailed_SendReqError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_Settings_Detailed_SendReq", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_Settings_Primary_SendReqStart(AVM3_Settings_Primary_SendReqCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_RequestType e8RequestType, ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState e8AvmSonarBuzzer, bool bDetailsSettingsAvail, bool bImageQualitySettingAvail) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_Settings_Primary_SendReq);
        ::boost::shared_ptr< AVM3_Settings_Primary_SendReqStart > payload (new AVM3_Settings_Primary_SendReqStart());
        payload->setE8RequestType(e8RequestType);
        payload->setE8AvmSonarBuzzer(e8AvmSonarBuzzer);
        payload->setBDetailsSettingsAvail(bDetailsSettingsAvail);
        payload->setBImageQualitySettingAvail(bImageQualitySettingAvail);
        CCA_MESSAGE(ccaMessage,header,AVM3_Settings_Primary_SendReqStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_Settings_Primary_SendReq", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Settings_Primary_SendReq);
        ::boost::shared_ptr< AVM3_Settings_Primary_SendReqError > payload (new AVM3_Settings_Primary_SendReqError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_Settings_Primary_SendReqError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_Settings_Primary_SendReq", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_GetVersionInfoStart(AVM3_GetVersionInfoCallbackIF& cb, ::rvc_cca_fi_types::T_e8_AVMph3_VersionInfoType e8VersionType) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_GetVersionInfo);
        ::boost::shared_ptr< AVM3_GetVersionInfoStart > payload (new AVM3_GetVersionInfoStart());
        payload->setE8VersionType(e8VersionType);
        CCA_MESSAGE(ccaMessage,header,AVM3_GetVersionInfoStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_GetVersionInfo", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_GetVersionInfo);
        ::boost::shared_ptr< AVM3_GetVersionInfoError > payload (new AVM3_GetVersionInfoError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_GetVersionInfoError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_GetVersionInfo", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_GetCommunicationErrorsStart(AVM3_GetCommunicationErrorsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_GetCommunicationErrors);
        ::boost::shared_ptr< AVM3_GetCommunicationErrorsStart > payload (new AVM3_GetCommunicationErrorsStart());
        CCA_MESSAGE(ccaMessage,header,AVM3_GetCommunicationErrorsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_GetCommunicationErrors", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_GetCommunicationErrors);
        ::boost::shared_ptr< AVM3_GetCommunicationErrorsError > payload (new AVM3_GetCommunicationErrorsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_GetCommunicationErrorsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_GetCommunicationErrors", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendAVM3_ClearCommunicationErrorsStart(AVM3_ClearCommunicationErrorsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_AVM3_ClearCommunicationErrors);
        ::boost::shared_ptr< AVM3_ClearCommunicationErrorsStart > payload (new AVM3_ClearCommunicationErrorsStart());
        CCA_MESSAGE(ccaMessage,header,AVM3_ClearCommunicationErrorsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "AVM3_ClearCommunicationErrors", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_ClearCommunicationErrors);
        ::boost::shared_ptr< AVM3_ClearCommunicationErrorsError > payload (new AVM3_ClearCommunicationErrorsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_ClearCommunicationErrorsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "AVM3_ClearCommunicationErrors", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendToggleGpioPinOnOffStart(ToggleGpioPinOnOffCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_ToggleGpioPinOnOff);
        ::boost::shared_ptr< ToggleGpioPinOnOffStart > payload (new ToggleGpioPinOnOffStart());
        CCA_MESSAGE(ccaMessage,header,ToggleGpioPinOnOffStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "ToggleGpioPinOnOff", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ToggleGpioPinOnOff);
        ::boost::shared_ptr< ToggleGpioPinOnOffError > payload (new ToggleGpioPinOnOffError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ToggleGpioPinOnOffError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "ToggleGpioPinOnOff", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendSystemConfigurationsUpReg(SystemConfigurationsCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SystemConfigurations);
        ::boost::shared_ptr< SystemConfigurationsUpReg > payload (new SystemConfigurationsUpReg());
        CCA_MESSAGE(ccaMessage,header,SystemConfigurationsUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SystemConfigurationsRelUpReg > payloadRelUpRegHeap (new SystemConfigurationsRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SystemConfigurations, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::SystemConfigurationsRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SystemConfigurations, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SystemConfigurations", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SystemConfigurations", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSystemConfigurations()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SystemConfigurations, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SystemConfigurationsStatus > payloadLoopback (new SystemConfigurationsStatus(getSystemConfigurations()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SystemConfigurationsStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemConfigurations);
        ::boost::shared_ptr< SystemConfigurationsError > payload (new SystemConfigurationsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemConfigurationsError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SystemConfigurations", &cb);
    }
}

bool Rvc_cca_fiProxy::sendSystemConfigurationsRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SystemConfigurations,"SystemConfigurations");
}

void Rvc_cca_fiProxy::sendSystemConfigurationsRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SystemConfigurations);
}

const SystemConfigurationsStatus& Rvc_cca_fiProxy::getSystemConfigurations() const {
    return _systemConfigurations.get();
}

bool Rvc_cca_fiProxy::hasSystemConfigurations() const {
    return _systemConfigurations.hasValue();
}

act_t Rvc_cca_fiProxy::sendSystemStatusUpReg(SystemStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SystemStatus);
        ::boost::shared_ptr< SystemStatusUpReg > payload (new SystemStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SystemStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SystemStatusRelUpReg > payloadRelUpRegHeap (new SystemStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SystemStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::SystemStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SystemStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SystemStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SystemStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSystemStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SystemStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SystemStatusStatus > payloadLoopback (new SystemStatusStatus(getSystemStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SystemStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SystemStatus);
        ::boost::shared_ptr< SystemStatusError > payload (new SystemStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SystemStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SystemStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendSystemStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SystemStatus,"SystemStatus");
}

void Rvc_cca_fiProxy::sendSystemStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SystemStatus);
}

const SystemStatusStatus& Rvc_cca_fiProxy::getSystemStatus() const {
    return _systemStatus.get();
}

bool Rvc_cca_fiProxy::hasSystemStatus() const {
    return _systemStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendVideoSignalStatusUpReg(VideoSignalStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VideoSignalStatus);
        ::boost::shared_ptr< VideoSignalStatusUpReg > payload (new VideoSignalStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,VideoSignalStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VideoSignalStatusRelUpReg > payloadRelUpRegHeap (new VideoSignalStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VideoSignalStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::VideoSignalStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VideoSignalStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VideoSignalStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VideoSignalStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVideoSignalStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VideoSignalStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VideoSignalStatusStatus > payloadLoopback (new VideoSignalStatusStatus(getVideoSignalStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VideoSignalStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VideoSignalStatus);
        ::boost::shared_ptr< VideoSignalStatusError > payload (new VideoSignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VideoSignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VideoSignalStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendVideoSignalStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VideoSignalStatus,"VideoSignalStatus");
}

void Rvc_cca_fiProxy::sendVideoSignalStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VideoSignalStatus);
}

const VideoSignalStatusStatus& Rvc_cca_fiProxy::getVideoSignalStatus() const {
    return _videoSignalStatus.get();
}

bool Rvc_cca_fiProxy::hasVideoSignalStatus() const {
    return _videoSignalStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendReverseSignalStatusUpReg(ReverseSignalStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ReverseSignalStatus);
        ::boost::shared_ptr< ReverseSignalStatusUpReg > payload (new ReverseSignalStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,ReverseSignalStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ReverseSignalStatusRelUpReg > payloadRelUpRegHeap (new ReverseSignalStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ReverseSignalStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::ReverseSignalStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ReverseSignalStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ReverseSignalStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ReverseSignalStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasReverseSignalStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ReverseSignalStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ReverseSignalStatusStatus > payloadLoopback (new ReverseSignalStatusStatus(getReverseSignalStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ReverseSignalStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ReverseSignalStatus);
        ::boost::shared_ptr< ReverseSignalStatusError > payload (new ReverseSignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ReverseSignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ReverseSignalStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendReverseSignalStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ReverseSignalStatus,"ReverseSignalStatus");
}

void Rvc_cca_fiProxy::sendReverseSignalStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ReverseSignalStatus);
}

const ReverseSignalStatusStatus& Rvc_cca_fiProxy::getReverseSignalStatus() const {
    return _reverseSignalStatus.get();
}

bool Rvc_cca_fiProxy::hasReverseSignalStatus() const {
    return _reverseSignalStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendCamera_PwrSupplyStatusUpReg(Camera_PwrSupplyStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Camera_PwrSupplyStatus);
        ::boost::shared_ptr< Camera_PwrSupplyStatusUpReg > payload (new Camera_PwrSupplyStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,Camera_PwrSupplyStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Camera_PwrSupplyStatusRelUpReg > payloadRelUpRegHeap (new Camera_PwrSupplyStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Camera_PwrSupplyStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::Camera_PwrSupplyStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Camera_PwrSupplyStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Camera_PwrSupplyStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Camera_PwrSupplyStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCamera_PwrSupplyStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Camera_PwrSupplyStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Camera_PwrSupplyStatusStatus > payloadLoopback (new Camera_PwrSupplyStatusStatus(getCamera_PwrSupplyStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Camera_PwrSupplyStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Camera_PwrSupplyStatus);
        ::boost::shared_ptr< Camera_PwrSupplyStatusError > payload (new Camera_PwrSupplyStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Camera_PwrSupplyStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Camera_PwrSupplyStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendCamera_PwrSupplyStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Camera_PwrSupplyStatus,"Camera_PwrSupplyStatus");
}

void Rvc_cca_fiProxy::sendCamera_PwrSupplyStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Camera_PwrSupplyStatus);
}

const Camera_PwrSupplyStatusStatus& Rvc_cca_fiProxy::getCamera_PwrSupplyStatus() const {
    return _camera_PwrSupplyStatus.get();
}

bool Rvc_cca_fiProxy::hasCamera_PwrSupplyStatus() const {
    return _camera_PwrSupplyStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendCamera_PwrSupplyStatusGet(Camera_PwrSupplyStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Camera_PwrSupplyStatus);
        ::boost::shared_ptr< Camera_PwrSupplyStatusGet > payload (new Camera_PwrSupplyStatusGet());
        CCA_MESSAGE(ccaMessage,header,Camera_PwrSupplyStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Camera_PwrSupplyStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Camera_PwrSupplyStatus);
        ::boost::shared_ptr< Camera_PwrSupplyStatusError > payload (new Camera_PwrSupplyStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Camera_PwrSupplyStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Camera_PwrSupplyStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendMicrophone_PwrSupplyStatusUpReg(Microphone_PwrSupplyStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Microphone_PwrSupplyStatus);
        ::boost::shared_ptr< Microphone_PwrSupplyStatusUpReg > payload (new Microphone_PwrSupplyStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,Microphone_PwrSupplyStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Microphone_PwrSupplyStatusRelUpReg > payloadRelUpRegHeap (new Microphone_PwrSupplyStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Microphone_PwrSupplyStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::Microphone_PwrSupplyStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Microphone_PwrSupplyStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Microphone_PwrSupplyStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Microphone_PwrSupplyStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMicrophone_PwrSupplyStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Microphone_PwrSupplyStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Microphone_PwrSupplyStatusStatus > payloadLoopback (new Microphone_PwrSupplyStatusStatus(getMicrophone_PwrSupplyStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Microphone_PwrSupplyStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Microphone_PwrSupplyStatus);
        ::boost::shared_ptr< Microphone_PwrSupplyStatusError > payload (new Microphone_PwrSupplyStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Microphone_PwrSupplyStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Microphone_PwrSupplyStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendMicrophone_PwrSupplyStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Microphone_PwrSupplyStatus,"Microphone_PwrSupplyStatus");
}

void Rvc_cca_fiProxy::sendMicrophone_PwrSupplyStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Microphone_PwrSupplyStatus);
}

const Microphone_PwrSupplyStatusStatus& Rvc_cca_fiProxy::getMicrophone_PwrSupplyStatus() const {
    return _microphone_PwrSupplyStatus.get();
}

bool Rvc_cca_fiProxy::hasMicrophone_PwrSupplyStatus() const {
    return _microphone_PwrSupplyStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendMicrophone_PwrSupplyStatusGet(Microphone_PwrSupplyStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Microphone_PwrSupplyStatus);
        ::boost::shared_ptr< Microphone_PwrSupplyStatusGet > payload (new Microphone_PwrSupplyStatusGet());
        CCA_MESSAGE(ccaMessage,header,Microphone_PwrSupplyStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Microphone_PwrSupplyStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Microphone_PwrSupplyStatus);
        ::boost::shared_ptr< Microphone_PwrSupplyStatusError > payload (new Microphone_PwrSupplyStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Microphone_PwrSupplyStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Microphone_PwrSupplyStatus", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendTailgate_StatusUpReg(Tailgate_StatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Tailgate_Status);
        ::boost::shared_ptr< Tailgate_StatusUpReg > payload (new Tailgate_StatusUpReg());
        CCA_MESSAGE(ccaMessage,header,Tailgate_StatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Tailgate_StatusRelUpReg > payloadRelUpRegHeap (new Tailgate_StatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Tailgate_Status, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::Tailgate_StatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Tailgate_Status, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Tailgate_Status", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Tailgate_Status", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTailgate_Status()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Tailgate_Status, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Tailgate_StatusStatus > payloadLoopback (new Tailgate_StatusStatus(getTailgate_Status()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Tailgate_StatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Tailgate_Status);
        ::boost::shared_ptr< Tailgate_StatusError > payload (new Tailgate_StatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Tailgate_StatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Tailgate_Status", &cb);
    }
}

bool Rvc_cca_fiProxy::sendTailgate_StatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Tailgate_Status,"Tailgate_Status");
}

void Rvc_cca_fiProxy::sendTailgate_StatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Tailgate_Status);
}

const Tailgate_StatusStatus& Rvc_cca_fiProxy::getTailgate_Status() const {
    return _tailgate_Status.get();
}

bool Rvc_cca_fiProxy::hasTailgate_Status() const {
    return _tailgate_Status.hasValue();
}

act_t Rvc_cca_fiProxy::sendTailgate_StatusGet(Tailgate_StatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_Tailgate_Status);
        ::boost::shared_ptr< Tailgate_StatusGet > payload (new Tailgate_StatusGet());
        CCA_MESSAGE(ccaMessage,header,Tailgate_StatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "Tailgate_Status", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Tailgate_Status);
        ::boost::shared_ptr< Tailgate_StatusError > payload (new Tailgate_StatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Tailgate_StatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "Tailgate_Status", &cb);
    }
}

act_t Rvc_cca_fiProxy::sendView_Close_AuthorizedUpReg(View_Close_AuthorizedCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_View_Close_Authorized);
        ::boost::shared_ptr< View_Close_AuthorizedUpReg > payload (new View_Close_AuthorizedUpReg());
        CCA_MESSAGE(ccaMessage,header,View_Close_AuthorizedUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< View_Close_AuthorizedRelUpReg > payloadRelUpRegHeap (new View_Close_AuthorizedRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_View_Close_Authorized, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::View_Close_AuthorizedRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_View_Close_Authorized, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "View_Close_Authorized", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "View_Close_Authorized", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasView_Close_Authorized()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_View_Close_Authorized, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< View_Close_AuthorizedStatus > payloadLoopback (new View_Close_AuthorizedStatus(getView_Close_Authorized()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,View_Close_AuthorizedStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_View_Close_Authorized);
        ::boost::shared_ptr< View_Close_AuthorizedError > payload (new View_Close_AuthorizedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,View_Close_AuthorizedError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "View_Close_Authorized", &cb);
    }
}

bool Rvc_cca_fiProxy::sendView_Close_AuthorizedRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_View_Close_Authorized,"View_Close_Authorized");
}

void Rvc_cca_fiProxy::sendView_Close_AuthorizedRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_View_Close_Authorized);
}

const View_Close_AuthorizedStatus& Rvc_cca_fiProxy::getView_Close_Authorized() const {
    return _view_Close_Authorized.get();
}

bool Rvc_cca_fiProxy::hasView_Close_Authorized() const {
    return _view_Close_Authorized.hasValue();
}

act_t Rvc_cca_fiProxy::sendAvmR_Current_ViewUpReg(AvmR_Current_ViewCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AvmR_Current_View);
        ::boost::shared_ptr< AvmR_Current_ViewUpReg > payload (new AvmR_Current_ViewUpReg());
        CCA_MESSAGE(ccaMessage,header,AvmR_Current_ViewUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AvmR_Current_ViewRelUpReg > payloadRelUpRegHeap (new AvmR_Current_ViewRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AvmR_Current_View, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AvmR_Current_ViewRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AvmR_Current_View, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AvmR_Current_View", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AvmR_Current_View", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAvmR_Current_View()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AvmR_Current_View, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AvmR_Current_ViewStatus > payloadLoopback (new AvmR_Current_ViewStatus(getAvmR_Current_View()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AvmR_Current_ViewStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AvmR_Current_View);
        ::boost::shared_ptr< AvmR_Current_ViewError > payload (new AvmR_Current_ViewError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AvmR_Current_ViewError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AvmR_Current_View", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAvmR_Current_ViewRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AvmR_Current_View,"AvmR_Current_View");
}

void Rvc_cca_fiProxy::sendAvmR_Current_ViewRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AvmR_Current_View);
}

const AvmR_Current_ViewStatus& Rvc_cca_fiProxy::getAvmR_Current_View() const {
    return _avmR_Current_View.get();
}

bool Rvc_cca_fiProxy::hasAvmR_Current_View() const {
    return _avmR_Current_View.hasValue();
}

act_t Rvc_cca_fiProxy::sendAffordable_ITSUpReg(Affordable_ITSCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_Affordable_ITS);
        ::boost::shared_ptr< Affordable_ITSUpReg > payload (new Affordable_ITSUpReg());
        CCA_MESSAGE(ccaMessage,header,Affordable_ITSUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< Affordable_ITSRelUpReg > payloadRelUpRegHeap (new Affordable_ITSRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_Affordable_ITS, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::Affordable_ITSRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_Affordable_ITS, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "Affordable_ITS", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "Affordable_ITS", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAffordable_ITS()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_Affordable_ITS, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< Affordable_ITSStatus > payloadLoopback (new Affordable_ITSStatus(getAffordable_ITS()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,Affordable_ITSStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_Affordable_ITS);
        ::boost::shared_ptr< Affordable_ITSError > payload (new Affordable_ITSError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,Affordable_ITSError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "Affordable_ITS", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAffordable_ITSRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_Affordable_ITS,"Affordable_ITS");
}

void Rvc_cca_fiProxy::sendAffordable_ITSRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_Affordable_ITS);
}

const Affordable_ITSStatus& Rvc_cca_fiProxy::getAffordable_ITS() const {
    return _affordable_ITS.get();
}

bool Rvc_cca_fiProxy::hasAffordable_ITS() const {
    return _affordable_ITS.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPAConfigurationUpReg(IPAConfigurationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPAConfiguration);
        ::boost::shared_ptr< IPAConfigurationUpReg > payload (new IPAConfigurationUpReg());
        CCA_MESSAGE(ccaMessage,header,IPAConfigurationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPAConfigurationRelUpReg > payloadRelUpRegHeap (new IPAConfigurationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPAConfiguration, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPAConfigurationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPAConfiguration, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPAConfiguration", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPAConfiguration", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPAConfiguration()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPAConfiguration, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPAConfigurationStatus > payloadLoopback (new IPAConfigurationStatus(getIPAConfiguration()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPAConfigurationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPAConfiguration);
        ::boost::shared_ptr< IPAConfigurationError > payload (new IPAConfigurationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPAConfigurationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPAConfiguration", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPAConfigurationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPAConfiguration,"IPAConfiguration");
}

void Rvc_cca_fiProxy::sendIPAConfigurationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPAConfiguration);
}

const IPAConfigurationStatus& Rvc_cca_fiProxy::getIPAConfiguration() const {
    return _iPAConfiguration.get();
}

bool Rvc_cca_fiProxy::hasIPAConfiguration() const {
    return _iPAConfiguration.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPAStatusUpReg(IPAStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPAStatus);
        ::boost::shared_ptr< IPAStatusUpReg > payload (new IPAStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,IPAStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPAStatusRelUpReg > payloadRelUpRegHeap (new IPAStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPAStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPAStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPAStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPAStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPAStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPAStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPAStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPAStatusStatus > payloadLoopback (new IPAStatusStatus(getIPAStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPAStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPAStatus);
        ::boost::shared_ptr< IPAStatusError > payload (new IPAStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPAStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPAStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPAStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPAStatus,"IPAStatus");
}

void Rvc_cca_fiProxy::sendIPAStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPAStatus);
}

const IPAStatusStatus& Rvc_cca_fiProxy::getIPAStatus() const {
    return _iPAStatus.get();
}

bool Rvc_cca_fiProxy::hasIPAStatus() const {
    return _iPAStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPAPatternRequestUpReg(IPAPatternRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPAPatternRequest);
        ::boost::shared_ptr< IPAPatternRequestUpReg > payload (new IPAPatternRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,IPAPatternRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPAPatternRequestRelUpReg > payloadRelUpRegHeap (new IPAPatternRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPAPatternRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPAPatternRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPAPatternRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPAPatternRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPAPatternRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPAPatternRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPAPatternRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPAPatternRequestStatus > payloadLoopback (new IPAPatternRequestStatus(getIPAPatternRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPAPatternRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPAPatternRequest);
        ::boost::shared_ptr< IPAPatternRequestError > payload (new IPAPatternRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPAPatternRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPAPatternRequest", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPAPatternRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPAPatternRequest,"IPAPatternRequest");
}

void Rvc_cca_fiProxy::sendIPAPatternRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPAPatternRequest);
}

const IPAPatternRequestStatus& Rvc_cca_fiProxy::getIPAPatternRequest() const {
    return _iPAPatternRequest.get();
}

bool Rvc_cca_fiProxy::hasIPAPatternRequest() const {
    return _iPAPatternRequest.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPAMessageRequestUpReg(IPAMessageRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPAMessageRequest);
        ::boost::shared_ptr< IPAMessageRequestUpReg > payload (new IPAMessageRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,IPAMessageRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPAMessageRequestRelUpReg > payloadRelUpRegHeap (new IPAMessageRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPAMessageRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPAMessageRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPAMessageRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPAMessageRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPAMessageRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPAMessageRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPAMessageRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPAMessageRequestStatus > payloadLoopback (new IPAMessageRequestStatus(getIPAMessageRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPAMessageRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPAMessageRequest);
        ::boost::shared_ptr< IPAMessageRequestError > payload (new IPAMessageRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPAMessageRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPAMessageRequest", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPAMessageRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPAMessageRequest,"IPAMessageRequest");
}

void Rvc_cca_fiProxy::sendIPAMessageRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPAMessageRequest);
}

const IPAMessageRequestStatus& Rvc_cca_fiProxy::getIPAMessageRequest() const {
    return _iPAMessageRequest.get();
}

bool Rvc_cca_fiProxy::hasIPAMessageRequest() const {
    return _iPAMessageRequest.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPASwitchMaskRequestUpReg(IPASwitchMaskRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPASwitchMaskRequest);
        ::boost::shared_ptr< IPASwitchMaskRequestUpReg > payload (new IPASwitchMaskRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,IPASwitchMaskRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPASwitchMaskRequestRelUpReg > payloadRelUpRegHeap (new IPASwitchMaskRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPASwitchMaskRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPASwitchMaskRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPASwitchMaskRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPASwitchMaskRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPASwitchMaskRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPASwitchMaskRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPASwitchMaskRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPASwitchMaskRequestStatus > payloadLoopback (new IPASwitchMaskRequestStatus(getIPASwitchMaskRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPASwitchMaskRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPASwitchMaskRequest);
        ::boost::shared_ptr< IPASwitchMaskRequestError > payload (new IPASwitchMaskRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPASwitchMaskRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPASwitchMaskRequest", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPASwitchMaskRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPASwitchMaskRequest,"IPASwitchMaskRequest");
}

void Rvc_cca_fiProxy::sendIPASwitchMaskRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPASwitchMaskRequest);
}

const IPASwitchMaskRequestStatus& Rvc_cca_fiProxy::getIPASwitchMaskRequest() const {
    return _iPASwitchMaskRequest.get();
}

bool Rvc_cca_fiProxy::hasIPASwitchMaskRequest() const {
    return _iPASwitchMaskRequest.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPASwitchGreyOutRequestUpReg(IPASwitchGreyOutRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPASwitchGreyOutRequest);
        ::boost::shared_ptr< IPASwitchGreyOutRequestUpReg > payload (new IPASwitchGreyOutRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,IPASwitchGreyOutRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPASwitchGreyOutRequestRelUpReg > payloadRelUpRegHeap (new IPASwitchGreyOutRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPASwitchGreyOutRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPASwitchGreyOutRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPASwitchGreyOutRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPASwitchGreyOutRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPASwitchGreyOutRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPASwitchGreyOutRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPASwitchGreyOutRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPASwitchGreyOutRequestStatus > payloadLoopback (new IPASwitchGreyOutRequestStatus(getIPASwitchGreyOutRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPASwitchGreyOutRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPASwitchGreyOutRequest);
        ::boost::shared_ptr< IPASwitchGreyOutRequestError > payload (new IPASwitchGreyOutRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPASwitchGreyOutRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPASwitchGreyOutRequest", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPASwitchGreyOutRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPASwitchGreyOutRequest,"IPASwitchGreyOutRequest");
}

void Rvc_cca_fiProxy::sendIPASwitchGreyOutRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPASwitchGreyOutRequest);
}

const IPASwitchGreyOutRequestStatus& Rvc_cca_fiProxy::getIPASwitchGreyOutRequest() const {
    return _iPASwitchGreyOutRequest.get();
}

bool Rvc_cca_fiProxy::hasIPASwitchGreyOutRequest() const {
    return _iPASwitchGreyOutRequest.hasValue();
}

act_t Rvc_cca_fiProxy::sendIPADirectionIndicatorUpReg(IPADirectionIndicatorCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_IPADirectionIndicator);
        ::boost::shared_ptr< IPADirectionIndicatorUpReg > payload (new IPADirectionIndicatorUpReg());
        CCA_MESSAGE(ccaMessage,header,IPADirectionIndicatorUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< IPADirectionIndicatorRelUpReg > payloadRelUpRegHeap (new IPADirectionIndicatorRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_IPADirectionIndicator, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::IPADirectionIndicatorRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_IPADirectionIndicator, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "IPADirectionIndicator", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "IPADirectionIndicator", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasIPADirectionIndicator()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_IPADirectionIndicator, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< IPADirectionIndicatorStatus > payloadLoopback (new IPADirectionIndicatorStatus(getIPADirectionIndicator()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,IPADirectionIndicatorStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_IPADirectionIndicator);
        ::boost::shared_ptr< IPADirectionIndicatorError > payload (new IPADirectionIndicatorError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,IPADirectionIndicatorError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "IPADirectionIndicator", &cb);
    }
}

bool Rvc_cca_fiProxy::sendIPADirectionIndicatorRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_IPADirectionIndicator,"IPADirectionIndicator");
}

void Rvc_cca_fiProxy::sendIPADirectionIndicatorRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_IPADirectionIndicator);
}

const IPADirectionIndicatorStatus& Rvc_cca_fiProxy::getIPADirectionIndicator() const {
    return _iPADirectionIndicator.get();
}

bool Rvc_cca_fiProxy::hasIPADirectionIndicator() const {
    return _iPADirectionIndicator.hasValue();
}

act_t Rvc_cca_fiProxy::sendGdlAdj_SteeringAngleUpReg(GdlAdj_SteeringAngleCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GdlAdj_SteeringAngle);
        ::boost::shared_ptr< GdlAdj_SteeringAngleUpReg > payload (new GdlAdj_SteeringAngleUpReg());
        CCA_MESSAGE(ccaMessage,header,GdlAdj_SteeringAngleUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GdlAdj_SteeringAngleRelUpReg > payloadRelUpRegHeap (new GdlAdj_SteeringAngleRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GdlAdj_SteeringAngle, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_SteeringAngleRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GdlAdj_SteeringAngle, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GdlAdj_SteeringAngle", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GdlAdj_SteeringAngle", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGdlAdj_SteeringAngle()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GdlAdj_SteeringAngle, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GdlAdj_SteeringAngleStatus > payloadLoopback (new GdlAdj_SteeringAngleStatus(getGdlAdj_SteeringAngle()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GdlAdj_SteeringAngleStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GdlAdj_SteeringAngle);
        ::boost::shared_ptr< GdlAdj_SteeringAngleError > payload (new GdlAdj_SteeringAngleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GdlAdj_SteeringAngleError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GdlAdj_SteeringAngle", &cb);
    }
}

bool Rvc_cca_fiProxy::sendGdlAdj_SteeringAngleRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GdlAdj_SteeringAngle,"GdlAdj_SteeringAngle");
}

void Rvc_cca_fiProxy::sendGdlAdj_SteeringAngleRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GdlAdj_SteeringAngle);
}

const GdlAdj_SteeringAngleStatus& Rvc_cca_fiProxy::getGdlAdj_SteeringAngle() const {
    return _gdlAdj_SteeringAngle.get();
}

bool Rvc_cca_fiProxy::hasGdlAdj_SteeringAngle() const {
    return _gdlAdj_SteeringAngle.hasValue();
}

act_t Rvc_cca_fiProxy::sendGdlAdj_CameraAngleUpReg(GdlAdj_CameraAngleCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_GdlAdj_CameraAngle);
        ::boost::shared_ptr< GdlAdj_CameraAngleUpReg > payload (new GdlAdj_CameraAngleUpReg());
        CCA_MESSAGE(ccaMessage,header,GdlAdj_CameraAngleUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< GdlAdj_CameraAngleRelUpReg > payloadRelUpRegHeap (new GdlAdj_CameraAngleRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_GdlAdj_CameraAngle, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::GdlAdj_CameraAngleRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_GdlAdj_CameraAngle, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "GdlAdj_CameraAngle", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "GdlAdj_CameraAngle", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasGdlAdj_CameraAngle()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_GdlAdj_CameraAngle, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< GdlAdj_CameraAngleStatus > payloadLoopback (new GdlAdj_CameraAngleStatus(getGdlAdj_CameraAngle()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,GdlAdj_CameraAngleStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GdlAdj_CameraAngle);
        ::boost::shared_ptr< GdlAdj_CameraAngleError > payload (new GdlAdj_CameraAngleError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GdlAdj_CameraAngleError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "GdlAdj_CameraAngle", &cb);
    }
}

bool Rvc_cca_fiProxy::sendGdlAdj_CameraAngleRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_GdlAdj_CameraAngle,"GdlAdj_CameraAngle");
}

void Rvc_cca_fiProxy::sendGdlAdj_CameraAngleRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_GdlAdj_CameraAngle);
}

const GdlAdj_CameraAngleStatus& Rvc_cca_fiProxy::getGdlAdj_CameraAngle() const {
    return _gdlAdj_CameraAngle.get();
}

bool Rvc_cca_fiProxy::hasGdlAdj_CameraAngle() const {
    return _gdlAdj_CameraAngle.hasValue();
}

act_t Rvc_cca_fiProxy::sendCANFrameStatusUpReg(CANFrameStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CANFrameStatus);
        ::boost::shared_ptr< CANFrameStatusUpReg > payload (new CANFrameStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,CANFrameStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CANFrameStatusRelUpReg > payloadRelUpRegHeap (new CANFrameStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CANFrameStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::CANFrameStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CANFrameStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CANFrameStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CANFrameStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCANFrameStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CANFrameStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CANFrameStatusStatus > payloadLoopback (new CANFrameStatusStatus(getCANFrameStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CANFrameStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CANFrameStatus);
        ::boost::shared_ptr< CANFrameStatusError > payload (new CANFrameStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CANFrameStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CANFrameStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendCANFrameStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CANFrameStatus,"CANFrameStatus");
}

void Rvc_cca_fiProxy::sendCANFrameStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CANFrameStatus);
}

const CANFrameStatusStatus& Rvc_cca_fiProxy::getCANFrameStatus() const {
    return _cANFrameStatus.get();
}

bool Rvc_cca_fiProxy::hasCANFrameStatus() const {
    return _cANFrameStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendMvcViewStatusUpReg(MvcViewStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MvcViewStatus);
        ::boost::shared_ptr< MvcViewStatusUpReg > payload (new MvcViewStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,MvcViewStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MvcViewStatusRelUpReg > payloadRelUpRegHeap (new MvcViewStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MvcViewStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::MvcViewStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MvcViewStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MvcViewStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MvcViewStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMvcViewStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MvcViewStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MvcViewStatusStatus > payloadLoopback (new MvcViewStatusStatus(getMvcViewStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MvcViewStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MvcViewStatus);
        ::boost::shared_ptr< MvcViewStatusError > payload (new MvcViewStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MvcViewStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MvcViewStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendMvcViewStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MvcViewStatus,"MvcViewStatus");
}

void Rvc_cca_fiProxy::sendMvcViewStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MvcViewStatus);
}

const MvcViewStatusStatus& Rvc_cca_fiProxy::getMvcViewStatus() const {
    return _mvcViewStatus.get();
}

bool Rvc_cca_fiProxy::hasMvcViewStatus() const {
    return _mvcViewStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendMvcAlertRequestUpReg(MvcAlertRequestCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_MvcAlertRequest);
        ::boost::shared_ptr< MvcAlertRequestUpReg > payload (new MvcAlertRequestUpReg());
        CCA_MESSAGE(ccaMessage,header,MvcAlertRequestUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< MvcAlertRequestRelUpReg > payloadRelUpRegHeap (new MvcAlertRequestRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_MvcAlertRequest, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::MvcAlertRequestRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_MvcAlertRequest, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "MvcAlertRequest", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "MvcAlertRequest", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasMvcAlertRequest()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_MvcAlertRequest, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< MvcAlertRequestStatus > payloadLoopback (new MvcAlertRequestStatus(getMvcAlertRequest()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,MvcAlertRequestStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_MvcAlertRequest);
        ::boost::shared_ptr< MvcAlertRequestError > payload (new MvcAlertRequestError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,MvcAlertRequestError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "MvcAlertRequest", &cb);
    }
}

bool Rvc_cca_fiProxy::sendMvcAlertRequestRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_MvcAlertRequest,"MvcAlertRequest");
}

void Rvc_cca_fiProxy::sendMvcAlertRequestRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_MvcAlertRequest);
}

const MvcAlertRequestStatus& Rvc_cca_fiProxy::getMvcAlertRequest() const {
    return _mvcAlertRequest.get();
}

bool Rvc_cca_fiProxy::hasMvcAlertRequest() const {
    return _mvcAlertRequest.hasValue();
}

act_t Rvc_cca_fiProxy::sendFAPModeUpReg(FAPModeCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FAPMode);
        ::boost::shared_ptr< FAPModeUpReg > payload (new FAPModeUpReg());
        CCA_MESSAGE(ccaMessage,header,FAPModeUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FAPModeRelUpReg > payloadRelUpRegHeap (new FAPModeRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FAPMode, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::FAPModeRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FAPMode, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FAPMode", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FAPMode", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFAPMode()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FAPMode, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FAPModeStatus > payloadLoopback (new FAPModeStatus(getFAPMode()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FAPModeStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FAPMode);
        ::boost::shared_ptr< FAPModeError > payload (new FAPModeError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FAPModeError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FAPMode", &cb);
    }
}

bool Rvc_cca_fiProxy::sendFAPModeRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FAPMode,"FAPMode");
}

void Rvc_cca_fiProxy::sendFAPModeRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FAPMode);
}

const FAPModeStatus& Rvc_cca_fiProxy::getFAPMode() const {
    return _fAPMode.get();
}

bool Rvc_cca_fiProxy::hasFAPMode() const {
    return _fAPMode.hasValue();
}

act_t Rvc_cca_fiProxy::sendFAPSettingsUpReg(FAPSettingsCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FAPSettings);
        ::boost::shared_ptr< FAPSettingsUpReg > payload (new FAPSettingsUpReg());
        CCA_MESSAGE(ccaMessage,header,FAPSettingsUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FAPSettingsRelUpReg > payloadRelUpRegHeap (new FAPSettingsRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FAPSettings, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::FAPSettingsRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FAPSettings, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FAPSettings", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FAPSettings", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFAPSettings()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FAPSettings, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FAPSettingsStatus > payloadLoopback (new FAPSettingsStatus(getFAPSettings()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FAPSettingsStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FAPSettings);
        ::boost::shared_ptr< FAPSettingsError > payload (new FAPSettingsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FAPSettingsError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FAPSettings", &cb);
    }
}

bool Rvc_cca_fiProxy::sendFAPSettingsRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FAPSettings,"FAPSettings");
}

void Rvc_cca_fiProxy::sendFAPSettingsRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FAPSettings);
}

const FAPSettingsStatus& Rvc_cca_fiProxy::getFAPSettings() const {
    return _fAPSettings.get();
}

bool Rvc_cca_fiProxy::hasFAPSettings() const {
    return _fAPSettings.hasValue();
}

act_t Rvc_cca_fiProxy::sendFAPGuidanceStateUpReg(FAPGuidanceStateCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FAPGuidanceState);
        ::boost::shared_ptr< FAPGuidanceStateUpReg > payload (new FAPGuidanceStateUpReg());
        CCA_MESSAGE(ccaMessage,header,FAPGuidanceStateUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FAPGuidanceStateRelUpReg > payloadRelUpRegHeap (new FAPGuidanceStateRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FAPGuidanceState, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::FAPGuidanceStateRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FAPGuidanceState, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FAPGuidanceState", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FAPGuidanceState", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFAPGuidanceState()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FAPGuidanceState, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FAPGuidanceStateStatus > payloadLoopback (new FAPGuidanceStateStatus(getFAPGuidanceState()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FAPGuidanceStateStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FAPGuidanceState);
        ::boost::shared_ptr< FAPGuidanceStateError > payload (new FAPGuidanceStateError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FAPGuidanceStateError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FAPGuidanceState", &cb);
    }
}

bool Rvc_cca_fiProxy::sendFAPGuidanceStateRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FAPGuidanceState,"FAPGuidanceState");
}

void Rvc_cca_fiProxy::sendFAPGuidanceStateRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FAPGuidanceState);
}

const FAPGuidanceStateStatus& Rvc_cca_fiProxy::getFAPGuidanceState() const {
    return _fAPGuidanceState.get();
}

bool Rvc_cca_fiProxy::hasFAPGuidanceState() const {
    return _fAPGuidanceState.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_DispStatusUpReg(AVM3_DispStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_DispStatus);
        ::boost::shared_ptr< AVM3_DispStatusUpReg > payload (new AVM3_DispStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_DispStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_DispStatusRelUpReg > payloadRelUpRegHeap (new AVM3_DispStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_DispStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_DispStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_DispStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_DispStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_DispStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_DispStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_DispStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_DispStatusStatus > payloadLoopback (new AVM3_DispStatusStatus(getAVM3_DispStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_DispStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_DispStatus);
        ::boost::shared_ptr< AVM3_DispStatusError > payload (new AVM3_DispStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_DispStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_DispStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_DispStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_DispStatus,"AVM3_DispStatus");
}

void Rvc_cca_fiProxy::sendAVM3_DispStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_DispStatus);
}

const AVM3_DispStatusStatus& Rvc_cca_fiProxy::getAVM3_DispStatus() const {
    return _aVM3_DispStatus.get();
}

bool Rvc_cca_fiProxy::hasAVM3_DispStatus() const {
    return _aVM3_DispStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_ViewSetupUpReg(AVM3_ViewSetupCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_ViewSetup);
        ::boost::shared_ptr< AVM3_ViewSetupUpReg > payload (new AVM3_ViewSetupUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_ViewSetupUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_ViewSetupRelUpReg > payloadRelUpRegHeap (new AVM3_ViewSetupRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_ViewSetup, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_ViewSetupRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_ViewSetup, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_ViewSetup", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_ViewSetup", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_ViewSetup()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_ViewSetup, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_ViewSetupStatus > payloadLoopback (new AVM3_ViewSetupStatus(getAVM3_ViewSetup()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_ViewSetupStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_ViewSetup);
        ::boost::shared_ptr< AVM3_ViewSetupError > payload (new AVM3_ViewSetupError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_ViewSetupError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_ViewSetup", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_ViewSetupRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_ViewSetup,"AVM3_ViewSetup");
}

void Rvc_cca_fiProxy::sendAVM3_ViewSetupRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_ViewSetup);
}

const AVM3_ViewSetupStatus& Rvc_cca_fiProxy::getAVM3_ViewSetup() const {
    return _aVM3_ViewSetup.get();
}

bool Rvc_cca_fiProxy::hasAVM3_ViewSetup() const {
    return _aVM3_ViewSetup.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_ErrorMessageUpReg(AVM3_ErrorMessageCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_ErrorMessage);
        ::boost::shared_ptr< AVM3_ErrorMessageUpReg > payload (new AVM3_ErrorMessageUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_ErrorMessageUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_ErrorMessageRelUpReg > payloadRelUpRegHeap (new AVM3_ErrorMessageRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_ErrorMessage, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_ErrorMessageRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_ErrorMessage, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_ErrorMessage", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_ErrorMessage", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_ErrorMessage()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_ErrorMessage, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_ErrorMessageStatus > payloadLoopback (new AVM3_ErrorMessageStatus(getAVM3_ErrorMessage()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_ErrorMessageStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_ErrorMessage);
        ::boost::shared_ptr< AVM3_ErrorMessageError > payload (new AVM3_ErrorMessageError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_ErrorMessageError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_ErrorMessage", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_ErrorMessageRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_ErrorMessage,"AVM3_ErrorMessage");
}

void Rvc_cca_fiProxy::sendAVM3_ErrorMessageRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_ErrorMessage);
}

const AVM3_ErrorMessageStatus& Rvc_cca_fiProxy::getAVM3_ErrorMessage() const {
    return _aVM3_ErrorMessage.get();
}

bool Rvc_cca_fiProxy::hasAVM3_ErrorMessage() const {
    return _aVM3_ErrorMessage.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_SonarBuzzerStatusUpReg(AVM3_SonarBuzzerStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_SonarBuzzerStatus);
        ::boost::shared_ptr< AVM3_SonarBuzzerStatusUpReg > payload (new AVM3_SonarBuzzerStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_SonarBuzzerStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_SonarBuzzerStatusRelUpReg > payloadRelUpRegHeap (new AVM3_SonarBuzzerStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_SonarBuzzerStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_SonarBuzzerStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_SonarBuzzerStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_SonarBuzzerStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_SonarBuzzerStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_SonarBuzzerStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_SonarBuzzerStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_SonarBuzzerStatusStatus > payloadLoopback (new AVM3_SonarBuzzerStatusStatus(getAVM3_SonarBuzzerStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_SonarBuzzerStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_SonarBuzzerStatus);
        ::boost::shared_ptr< AVM3_SonarBuzzerStatusError > payload (new AVM3_SonarBuzzerStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_SonarBuzzerStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_SonarBuzzerStatus", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_SonarBuzzerStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_SonarBuzzerStatus,"AVM3_SonarBuzzerStatus");
}

void Rvc_cca_fiProxy::sendAVM3_SonarBuzzerStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_SonarBuzzerStatus);
}

const AVM3_SonarBuzzerStatusStatus& Rvc_cca_fiProxy::getAVM3_SonarBuzzerStatus() const {
    return _aVM3_SonarBuzzerStatus.get();
}

bool Rvc_cca_fiProxy::hasAVM3_SonarBuzzerStatus() const {
    return _aVM3_SonarBuzzerStatus.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_Settings_DetailedUpReg(AVM3_Settings_DetailedCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_Settings_Detailed);
        ::boost::shared_ptr< AVM3_Settings_DetailedUpReg > payload (new AVM3_Settings_DetailedUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_Settings_DetailedUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_Settings_DetailedRelUpReg > payloadRelUpRegHeap (new AVM3_Settings_DetailedRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_Settings_Detailed, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_DetailedRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_Settings_Detailed, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_Settings_Detailed", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_Settings_Detailed", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_Settings_Detailed()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_Settings_Detailed, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_Settings_DetailedStatus > payloadLoopback (new AVM3_Settings_DetailedStatus(getAVM3_Settings_Detailed()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_Settings_DetailedStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Settings_Detailed);
        ::boost::shared_ptr< AVM3_Settings_DetailedError > payload (new AVM3_Settings_DetailedError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_Settings_DetailedError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_Settings_Detailed", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_Settings_DetailedRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_Settings_Detailed,"AVM3_Settings_Detailed");
}

void Rvc_cca_fiProxy::sendAVM3_Settings_DetailedRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_Settings_Detailed);
}

const AVM3_Settings_DetailedStatus& Rvc_cca_fiProxy::getAVM3_Settings_Detailed() const {
    return _aVM3_Settings_Detailed.get();
}

bool Rvc_cca_fiProxy::hasAVM3_Settings_Detailed() const {
    return _aVM3_Settings_Detailed.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_Settings_PrimaryUpReg(AVM3_Settings_PrimaryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_Settings_Primary);
        ::boost::shared_ptr< AVM3_Settings_PrimaryUpReg > payload (new AVM3_Settings_PrimaryUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_Settings_PrimaryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_Settings_PrimaryRelUpReg > payloadRelUpRegHeap (new AVM3_Settings_PrimaryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_Settings_Primary, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_Settings_PrimaryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_Settings_Primary, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_Settings_Primary", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_Settings_Primary", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_Settings_Primary()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_Settings_Primary, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_Settings_PrimaryStatus > payloadLoopback (new AVM3_Settings_PrimaryStatus(getAVM3_Settings_Primary()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_Settings_PrimaryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Settings_Primary);
        ::boost::shared_ptr< AVM3_Settings_PrimaryError > payload (new AVM3_Settings_PrimaryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_Settings_PrimaryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_Settings_Primary", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_Settings_PrimaryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_Settings_Primary,"AVM3_Settings_Primary");
}

void Rvc_cca_fiProxy::sendAVM3_Settings_PrimaryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_Settings_Primary);
}

const AVM3_Settings_PrimaryStatus& Rvc_cca_fiProxy::getAVM3_Settings_Primary() const {
    return _aVM3_Settings_Primary.get();
}

bool Rvc_cca_fiProxy::hasAVM3_Settings_Primary() const {
    return _aVM3_Settings_Primary.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_ConfigurationUpReg(AVM3_ConfigurationCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_Configuration);
        ::boost::shared_ptr< AVM3_ConfigurationUpReg > payload (new AVM3_ConfigurationUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_ConfigurationUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_ConfigurationRelUpReg > payloadRelUpRegHeap (new AVM3_ConfigurationRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_Configuration, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_ConfigurationRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_Configuration, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_Configuration", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_Configuration", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_Configuration()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_Configuration, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_ConfigurationStatus > payloadLoopback (new AVM3_ConfigurationStatus(getAVM3_Configuration()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_ConfigurationStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Configuration);
        ::boost::shared_ptr< AVM3_ConfigurationError > payload (new AVM3_ConfigurationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_ConfigurationError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_Configuration", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_ConfigurationRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_Configuration,"AVM3_Configuration");
}

void Rvc_cca_fiProxy::sendAVM3_ConfigurationRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_Configuration);
}

const AVM3_ConfigurationStatus& Rvc_cca_fiProxy::getAVM3_Configuration() const {
    return _aVM3_Configuration.get();
}

bool Rvc_cca_fiProxy::hasAVM3_Configuration() const {
    return _aVM3_Configuration.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_Software_VersionUpReg(AVM3_Software_VersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_Software_Version);
        ::boost::shared_ptr< AVM3_Software_VersionUpReg > payload (new AVM3_Software_VersionUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_Software_VersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_Software_VersionRelUpReg > payloadRelUpRegHeap (new AVM3_Software_VersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_Software_Version, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_Software_VersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_Software_Version, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_Software_Version", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_Software_Version", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_Software_Version()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_Software_Version, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_Software_VersionStatus > payloadLoopback (new AVM3_Software_VersionStatus(getAVM3_Software_Version()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_Software_VersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Software_Version);
        ::boost::shared_ptr< AVM3_Software_VersionError > payload (new AVM3_Software_VersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_Software_VersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_Software_Version", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_Software_VersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_Software_Version,"AVM3_Software_Version");
}

void Rvc_cca_fiProxy::sendAVM3_Software_VersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_Software_Version);
}

const AVM3_Software_VersionStatus& Rvc_cca_fiProxy::getAVM3_Software_Version() const {
    return _aVM3_Software_Version.get();
}

bool Rvc_cca_fiProxy::hasAVM3_Software_Version() const {
    return _aVM3_Software_Version.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_Hardware_VersionUpReg(AVM3_Hardware_VersionCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_Hardware_Version);
        ::boost::shared_ptr< AVM3_Hardware_VersionUpReg > payload (new AVM3_Hardware_VersionUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_Hardware_VersionUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_Hardware_VersionRelUpReg > payloadRelUpRegHeap (new AVM3_Hardware_VersionRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_Hardware_Version, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_Hardware_VersionRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_Hardware_Version, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_Hardware_Version", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_Hardware_Version", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_Hardware_Version()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_Hardware_Version, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_Hardware_VersionStatus > payloadLoopback (new AVM3_Hardware_VersionStatus(getAVM3_Hardware_Version()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_Hardware_VersionStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_Hardware_Version);
        ::boost::shared_ptr< AVM3_Hardware_VersionError > payload (new AVM3_Hardware_VersionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_Hardware_VersionError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_Hardware_Version", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_Hardware_VersionRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_Hardware_Version,"AVM3_Hardware_Version");
}

void Rvc_cca_fiProxy::sendAVM3_Hardware_VersionRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_Hardware_Version);
}

const AVM3_Hardware_VersionStatus& Rvc_cca_fiProxy::getAVM3_Hardware_Version() const {
    return _aVM3_Hardware_Version.get();
}

bool Rvc_cca_fiProxy::hasAVM3_Hardware_Version() const {
    return _aVM3_Hardware_Version.hasValue();
}

act_t Rvc_cca_fiProxy::sendAVM3_CommunicationErrorsUpReg(AVM3_CommunicationErrorsCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AVM3_CommunicationErrors);
        ::boost::shared_ptr< AVM3_CommunicationErrorsUpReg > payload (new AVM3_CommunicationErrorsUpReg());
        CCA_MESSAGE(ccaMessage,header,AVM3_CommunicationErrorsUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AVM3_CommunicationErrorsRelUpReg > payloadRelUpRegHeap (new AVM3_CommunicationErrorsRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AVM3_CommunicationErrors, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::rvc_cca_fi::AVM3_CommunicationErrorsRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AVM3_CommunicationErrors, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AVM3_CommunicationErrors", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AVM3_CommunicationErrors", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAVM3_CommunicationErrors()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AVM3_CommunicationErrors, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AVM3_CommunicationErrorsStatus > payloadLoopback (new AVM3_CommunicationErrorsStatus(getAVM3_CommunicationErrors()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AVM3_CommunicationErrorsStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AVM3_CommunicationErrors);
        ::boost::shared_ptr< AVM3_CommunicationErrorsError > payload (new AVM3_CommunicationErrorsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AVM3_CommunicationErrorsError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AVM3_CommunicationErrors", &cb);
    }
}

bool Rvc_cca_fiProxy::sendAVM3_CommunicationErrorsRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AVM3_CommunicationErrors,"AVM3_CommunicationErrors");
}

void Rvc_cca_fiProxy::sendAVM3_CommunicationErrorsRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AVM3_CommunicationErrors);
}

const AVM3_CommunicationErrorsStatus& Rvc_cca_fiProxy::getAVM3_CommunicationErrors() const {
    return _aVM3_CommunicationErrors.get();
}

bool Rvc_cca_fiProxy::hasAVM3_CommunicationErrors() const {
    return _aVM3_CommunicationErrors.hasValue();
}


void Rvc_cca_fiProxy::clearAllProperties ()
{
    _systemConfigurations = ::asf::core::nullable<SystemConfigurationsStatus>();
    _systemStatus = ::asf::core::nullable<SystemStatusStatus>();
    _videoSignalStatus = ::asf::core::nullable<VideoSignalStatusStatus>();
    _reverseSignalStatus = ::asf::core::nullable<ReverseSignalStatusStatus>();
    _camera_PwrSupplyStatus = ::asf::core::nullable<Camera_PwrSupplyStatusStatus>();
    _microphone_PwrSupplyStatus = ::asf::core::nullable<Microphone_PwrSupplyStatusStatus>();
    _tailgate_Status = ::asf::core::nullable<Tailgate_StatusStatus>();
    _view_Close_Authorized = ::asf::core::nullable<View_Close_AuthorizedStatus>();
    _avmR_Current_View = ::asf::core::nullable<AvmR_Current_ViewStatus>();
    _affordable_ITS = ::asf::core::nullable<Affordable_ITSStatus>();
    _iPAConfiguration = ::asf::core::nullable<IPAConfigurationStatus>();
    _iPAStatus = ::asf::core::nullable<IPAStatusStatus>();
    _iPAPatternRequest = ::asf::core::nullable<IPAPatternRequestStatus>();
    _iPAMessageRequest = ::asf::core::nullable<IPAMessageRequestStatus>();
    _iPASwitchMaskRequest = ::asf::core::nullable<IPASwitchMaskRequestStatus>();
    _iPASwitchGreyOutRequest = ::asf::core::nullable<IPASwitchGreyOutRequestStatus>();
    _iPADirectionIndicator = ::asf::core::nullable<IPADirectionIndicatorStatus>();
    _gdlAdj_SteeringAngle = ::asf::core::nullable<GdlAdj_SteeringAngleStatus>();
    _gdlAdj_CameraAngle = ::asf::core::nullable<GdlAdj_CameraAngleStatus>();
    _cANFrameStatus = ::asf::core::nullable<CANFrameStatusStatus>();
    _mvcViewStatus = ::asf::core::nullable<MvcViewStatusStatus>();
    _mvcAlertRequest = ::asf::core::nullable<MvcAlertRequestStatus>();
    _fAPMode = ::asf::core::nullable<FAPModeStatus>();
    _fAPSettings = ::asf::core::nullable<FAPSettingsStatus>();
    _fAPGuidanceState = ::asf::core::nullable<FAPGuidanceStateStatus>();
    _aVM3_DispStatus = ::asf::core::nullable<AVM3_DispStatusStatus>();
    _aVM3_ViewSetup = ::asf::core::nullable<AVM3_ViewSetupStatus>();
    _aVM3_ErrorMessage = ::asf::core::nullable<AVM3_ErrorMessageStatus>();
    _aVM3_SonarBuzzerStatus = ::asf::core::nullable<AVM3_SonarBuzzerStatusStatus>();
    _aVM3_Settings_Detailed = ::asf::core::nullable<AVM3_Settings_DetailedStatus>();
    _aVM3_Settings_Primary = ::asf::core::nullable<AVM3_Settings_PrimaryStatus>();
    _aVM3_Configuration = ::asf::core::nullable<AVM3_ConfigurationStatus>();
    _aVM3_Software_Version = ::asf::core::nullable<AVM3_Software_VersionStatus>();
    _aVM3_Hardware_Version = ::asf::core::nullable<AVM3_Hardware_VersionStatus>();
    _aVM3_CommunicationErrors = ::asf::core::nullable<AVM3_CommunicationErrorsStatus>();
}

void Rvc_cca_fiProxy::sendRelUpRegAll()
{
    sendSystemConfigurationsRelUpRegAll();
    sendSystemStatusRelUpRegAll();
    sendVideoSignalStatusRelUpRegAll();
    sendReverseSignalStatusRelUpRegAll();
    sendCamera_PwrSupplyStatusRelUpRegAll();
    sendMicrophone_PwrSupplyStatusRelUpRegAll();
    sendTailgate_StatusRelUpRegAll();
    sendView_Close_AuthorizedRelUpRegAll();
    sendAvmR_Current_ViewRelUpRegAll();
    sendAffordable_ITSRelUpRegAll();
    sendIPAConfigurationRelUpRegAll();
    sendIPAStatusRelUpRegAll();
    sendIPAPatternRequestRelUpRegAll();
    sendIPAMessageRequestRelUpRegAll();
    sendIPASwitchMaskRequestRelUpRegAll();
    sendIPASwitchGreyOutRequestRelUpRegAll();
    sendIPADirectionIndicatorRelUpRegAll();
    sendGdlAdj_SteeringAngleRelUpRegAll();
    sendGdlAdj_CameraAngleRelUpRegAll();
    sendCANFrameStatusRelUpRegAll();
    sendMvcViewStatusRelUpRegAll();
    sendMvcAlertRequestRelUpRegAll();
    sendFAPModeRelUpRegAll();
    sendFAPSettingsRelUpRegAll();
    sendFAPGuidanceStateRelUpRegAll();
    sendAVM3_DispStatusRelUpRegAll();
    sendAVM3_ViewSetupRelUpRegAll();
    sendAVM3_ErrorMessageRelUpRegAll();
    sendAVM3_SonarBuzzerStatusRelUpRegAll();
    sendAVM3_Settings_DetailedRelUpRegAll();
    sendAVM3_Settings_PrimaryRelUpRegAll();
    sendAVM3_ConfigurationRelUpRegAll();
    sendAVM3_Software_VersionRelUpRegAll();
    sendAVM3_Hardware_VersionRelUpRegAll();
    sendAVM3_CommunicationErrorsRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Rvc_cca_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Rvc_cca_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace rvc_cca_fi
