/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/CcaTypesConst.h"
#include "asf/stream/json.h"
#include "rvc_cca_fi.h"
#include "rvc_cca_fiJson.h"
#include "rvc_cca_fiJsonPrivate.h"
#include "rvc_cca_fi_types.h"
#include "rvc_cca_fi_typesConst.h"
#include "rvc_cca_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "SystemConfigurationsStatus"

void serializeJson (const ::rvc_cca_fi::SystemConfigurationsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8CameraSystem()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CameraSystem" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_Camera_System_Type_Name(value.getE8CameraSystem());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CameraSystem());
    }
    if (!isSparse || value.hasU8RVCGuideLine()) {
        yajl_gen_string(g, (const unsigned char*)  "u8RVCGuideLine" , 14);
        yajl_gen_integer(g, (long long)value.getU8RVCGuideLine());
    }
    if (!isSparse || value.hasU8Brightness()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Brightness" , 12);
        yajl_gen_integer(g, (long long)value.getU8Brightness());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SystemConfigurationsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemConfigurationsErrorStructure"

void serializeJson (const ::rvc_cca_fi::SystemConfigurationsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SystemConfigurationsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemConfigurationsError"

void serializeJson (const ::rvc_cca_fi::SystemConfigurationsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SystemConfigurationsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SystemConfigurationsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SystemConfigurationsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStatusStatus"

void serializeJson (const ::rvc_cca_fi::SystemStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SystemStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SystemStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_SystemStatus_Name(value.getE8SystemStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SystemStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SystemStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::SystemStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SystemStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SystemStatusError"

void serializeJson (const ::rvc_cca_fi::SystemStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SystemStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SystemStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SystemStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSignalStatusStatus"

void serializeJson (const ::rvc_cca_fi::VideoSignalStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8StatusVideoSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "e8StatusVideoSignal" , 19);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_SignalStatus_Name(value.getE8StatusVideoSignal());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8StatusVideoSignal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::VideoSignalStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSignalStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::VideoSignalStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::VideoSignalStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "VideoSignalStatusError"

void serializeJson (const ::rvc_cca_fi::VideoSignalStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::VideoSignalStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::VideoSignalStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::VideoSignalStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReverseSignalStatusStatus"

void serializeJson (const ::rvc_cca_fi::ReverseSignalStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8StatusReverseSignal()) {
        yajl_gen_string(g, (const unsigned char*)  "e8StatusReverseSignal" , 21);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_ReverseSignalStatus_Name(value.getE8StatusReverseSignal());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8StatusReverseSignal());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ReverseSignalStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReverseSignalStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::ReverseSignalStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ReverseSignalStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ReverseSignalStatusError"

void serializeJson (const ::rvc_cca_fi::ReverseSignalStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::ReverseSignalStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::ReverseSignalStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::ReverseSignalStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_PwrSupplyStatusStatus"

void serializeJson (const ::rvc_cca_fi::Camera_PwrSupplyStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPwrSupplyID()) {
        yajl_gen_string(g, (const unsigned char*)  "pwrSupplyID" , 11);
        yajl_gen_integer(g, (long long)value.getPwrSupplyID());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasCurrent()) {
        yajl_gen_string(g, (const unsigned char*)  "current" , 7);
        yajl_gen_integer(g, (long long)value.getCurrent());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Camera_PwrSupplyStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_PwrSupplyStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::Camera_PwrSupplyStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Camera_PwrSupplyStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_PwrSupplyStatusError"

void serializeJson (const ::rvc_cca_fi::Camera_PwrSupplyStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Camera_PwrSupplyStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Camera_PwrSupplyStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Camera_PwrSupplyStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Microphone_PwrSupplyStatusStatus"

void serializeJson (const ::rvc_cca_fi::Microphone_PwrSupplyStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPwrSupplyID()) {
        yajl_gen_string(g, (const unsigned char*)  "pwrSupplyID" , 11);
        yajl_gen_integer(g, (long long)value.getPwrSupplyID());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_Microphone_PowerSupplyStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasCurrent()) {
        yajl_gen_string(g, (const unsigned char*)  "current" , 7);
        yajl_gen_integer(g, (long long)value.getCurrent());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Microphone_PwrSupplyStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Microphone_PwrSupplyStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::Microphone_PwrSupplyStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Microphone_PwrSupplyStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Microphone_PwrSupplyStatusError"

void serializeJson (const ::rvc_cca_fi::Microphone_PwrSupplyStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Microphone_PwrSupplyStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Microphone_PwrSupplyStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Microphone_PwrSupplyStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Tailgate_StatusStatus"

void serializeJson (const ::rvc_cca_fi::Tailgate_StatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasState()) {
        yajl_gen_string(g, (const unsigned char*)  "State" , 5);
        const char* s = ::rvc_cca_fi_types::T_e8_Tailgate_State_Name(value.getState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Tailgate_StatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Tailgate_StatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::Tailgate_StatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Tailgate_StatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Tailgate_StatusError"

void serializeJson (const ::rvc_cca_fi::Tailgate_StatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Tailgate_StatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Tailgate_StatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Tailgate_StatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "View_Close_AuthorizedStatus"

void serializeJson (const ::rvc_cca_fi::View_Close_AuthorizedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Allowed()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Allowed" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_Exit_Authorized_Name(value.getE8Allowed());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Allowed());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::View_Close_AuthorizedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "View_Close_AuthorizedErrorStructure"

void serializeJson (const ::rvc_cca_fi::View_Close_AuthorizedErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::View_Close_AuthorizedErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "View_Close_AuthorizedError"

void serializeJson (const ::rvc_cca_fi::View_Close_AuthorizedError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::View_Close_AuthorizedError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::View_Close_AuthorizedError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::View_Close_AuthorizedError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvmR_Current_ViewStatus"

void serializeJson (const ::rvc_cca_fi::AvmR_Current_ViewStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8View()) {
        yajl_gen_string(g, (const unsigned char*)  "e8View" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_View_Status_Name(value.getE8View());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8View());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AvmR_Current_ViewStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvmR_Current_ViewErrorStructure"

void serializeJson (const ::rvc_cca_fi::AvmR_Current_ViewErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AvmR_Current_ViewErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AvmR_Current_ViewError"

void serializeJson (const ::rvc_cca_fi::AvmR_Current_ViewError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AvmR_Current_ViewError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AvmR_Current_ViewError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AvmR_Current_ViewError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_ITSStatus"

void serializeJson (const ::rvc_cca_fi::Affordable_ITSStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8AffordableItsAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AffordableItsAvailable" , 24);
        const char* s = ::rvc_cca_fi_types::T_e8_AffordableIts_Status_Name(value.getE8AffordableItsAvailable());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AffordableItsAvailable());
    }
    if (!isSparse || value.hasE8BswStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8BswStatus" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature_Name(value.getE8BswStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8BswStatus());
    }
    if (!isSparse || value.hasE8ModStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ModStatus" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature_Name(value.getE8ModStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ModStatus());
    }
    if (!isSparse || value.hasE8LdwStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LdwStatus" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_AffordableIts_StatusFeature_Name(value.getE8LdwStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LdwStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_ITSStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_ITSErrorStructure"

void serializeJson (const ::rvc_cca_fi::Affordable_ITSErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_ITSErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_ITSError"

void serializeJson (const ::rvc_cca_fi::Affordable_ITSError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Affordable_ITSError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Affordable_ITSError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Affordable_ITSError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAConfigurationStatus"

void serializeJson (const ::rvc_cca_fi::IPAConfigurationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8AvailabilityStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AvailabilityStatus" , 20);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_AvailabilityStatus_Name(value.getE8AvailabilityStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AvailabilityStatus());
    }
    if (!isSparse || value.hasE8RegionalSelection()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RegionalSelection" , 19);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_RegionalSelection_Name(value.getE8RegionalSelection());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RegionalSelection());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAConfigurationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAConfigurationErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPAConfigurationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAConfigurationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAConfigurationError"

void serializeJson (const ::rvc_cca_fi::IPAConfigurationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPAConfigurationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPAConfigurationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPAConfigurationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAStatusStatus"

void serializeJson (const ::rvc_cca_fi::IPAStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8OperationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8OperationStatus" , 17);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_OperationStatus_Name(value.getE8OperationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8OperationStatus());
    }
    if (!isSparse || value.hasE8Request()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Request" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_ModeChangeRequest_Name(value.getE8Request());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Request());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPAStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAStatusError"

void serializeJson (const ::rvc_cca_fi::IPAStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPAStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPAStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPAStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAPatternRequestStatus"

void serializeJson (const ::rvc_cca_fi::IPAPatternRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DisplayPattern()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DisplayPattern" , 16);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_PatternID_Name(value.getE8DisplayPattern());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DisplayPattern());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAPatternRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAPatternRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPAPatternRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAPatternRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAPatternRequestError"

void serializeJson (const ::rvc_cca_fi::IPAPatternRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPAPatternRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPAPatternRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPAPatternRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAMessageRequestStatus"

void serializeJson (const ::rvc_cca_fi::IPAMessageRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8MessageID()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MessageID" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_MessageID_Name(value.getE8MessageID());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MessageID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAMessageRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAMessageRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPAMessageRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPAMessageRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPAMessageRequestError"

void serializeJson (const ::rvc_cca_fi::IPAMessageRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPAMessageRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPAMessageRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPAMessageRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPASwitchMaskRequestStatus"

void serializeJson (const ::rvc_cca_fi::IPASwitchMaskRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SwitchMask()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SwitchMask" , 12);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_SwitchMask_Name(value.getE8SwitchMask());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SwitchMask());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPASwitchMaskRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPASwitchMaskRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPASwitchMaskRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPASwitchMaskRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPASwitchMaskRequestError"

void serializeJson (const ::rvc_cca_fi::IPASwitchMaskRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPASwitchMaskRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPASwitchMaskRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPASwitchMaskRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPASwitchGreyOutRequestStatus"

void serializeJson (const ::rvc_cca_fi::IPASwitchGreyOutRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8SwitchGreyOut()) {
        yajl_gen_string(g, (const unsigned char*)  "u8SwitchGreyOut" , 15);
        yajl_gen_integer(g, (long long)value.getU8SwitchGreyOut());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPASwitchGreyOutRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPASwitchGreyOutRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPASwitchGreyOutRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPASwitchGreyOutRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPASwitchGreyOutRequestError"

void serializeJson (const ::rvc_cca_fi::IPASwitchGreyOutRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPASwitchGreyOutRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPASwitchGreyOutRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPASwitchGreyOutRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPADirectionIndicatorStatus"

void serializeJson (const ::rvc_cca_fi::IPADirectionIndicatorStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Direction()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Direction" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_DirectionIndicator_Name(value.getE8Direction());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Direction());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPADirectionIndicatorStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPADirectionIndicatorErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPADirectionIndicatorErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPADirectionIndicatorErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPADirectionIndicatorError"

void serializeJson (const ::rvc_cca_fi::IPADirectionIndicatorError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPADirectionIndicatorError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPADirectionIndicatorError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPADirectionIndicatorError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_SteeringAngleStatus"

void serializeJson (const ::rvc_cca_fi::GdlAdj_SteeringAngleStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBShowValues()) {
        yajl_gen_string(g, (const unsigned char*)  "bShowValues" , 11);
        yajl_gen_bool(g, (bool)value.getBShowValues());
    }
    if (!isSparse || value.hasU8CentreAdjustmentState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8CentreAdjustmentState" , 23);
        yajl_gen_integer(g, (long long)value.getU8CentreAdjustmentState());
    }
    if (!isSparse || value.hasS32SteeringAngleCentreAdjusted()) {
        yajl_gen_string(g, (const unsigned char*)  "s32SteeringAngleCentreAdjusted" , 30);
        yajl_gen_integer(g, (long long)value.getS32SteeringAngleCentreAdjusted());
    }
    if (!isSparse || value.hasSteeringAngleSignalState()) {
        yajl_gen_string(g, (const unsigned char*)  "SteeringAngleSignalState" , 24);
        const char *s = value.getSteeringAngleSignalState().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_SteeringAngleStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_SteeringAngleErrorStructure"

void serializeJson (const ::rvc_cca_fi::GdlAdj_SteeringAngleErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_SteeringAngleErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_SteeringAngleError"

void serializeJson (const ::rvc_cca_fi::GdlAdj_SteeringAngleError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::GdlAdj_SteeringAngleError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::GdlAdj_SteeringAngleError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::GdlAdj_SteeringAngleError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_CameraAngleStatus"

void serializeJson (const ::rvc_cca_fi::GdlAdj_CameraAngleStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasF32CameraRollAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "f32CameraRollAngle" , 18);
        yajl_gen_double(g, (double)value.getF32CameraRollAngle());
    }
    if (!isSparse || value.hasF32CameraYawAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "f32CameraYawAngle" , 17);
        yajl_gen_double(g, (double)value.getF32CameraYawAngle());
    }
    if (!isSparse || value.hasF32CameraPitchAngle()) {
        yajl_gen_string(g, (const unsigned char*)  "f32CameraPitchAngle" , 19);
        yajl_gen_double(g, (double)value.getF32CameraPitchAngle());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_CameraAngleStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_CameraAngleErrorStructure"

void serializeJson (const ::rvc_cca_fi::GdlAdj_CameraAngleErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_CameraAngleErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_CameraAngleError"

void serializeJson (const ::rvc_cca_fi::GdlAdj_CameraAngleError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::GdlAdj_CameraAngleError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::GdlAdj_CameraAngleError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::GdlAdj_CameraAngleError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CANFrameStatusStatus"

void serializeJson (const ::rvc_cca_fi::CANFrameStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8StatusCANFrame()) {
        yajl_gen_string(g, (const unsigned char*)  "e8StatusCANFrame" , 16);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_SignalStatus_Name(value.getE8StatusCANFrame());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8StatusCANFrame());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::CANFrameStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CANFrameStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::CANFrameStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::CANFrameStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CANFrameStatusError"

void serializeJson (const ::rvc_cca_fi::CANFrameStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::CANFrameStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::CANFrameStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::CANFrameStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MvcViewStatusStatus"

void serializeJson (const ::rvc_cca_fi::MvcViewStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8View()) {
        yajl_gen_string(g, (const unsigned char*)  "e8View" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_MVCViewingState_Name(value.getE8View());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8View());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MvcViewStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MvcViewStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::MvcViewStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MvcViewStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MvcViewStatusError"

void serializeJson (const ::rvc_cca_fi::MvcViewStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::MvcViewStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::MvcViewStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::MvcViewStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MvcAlertRequestStatus"

void serializeJson (const ::rvc_cca_fi::MvcAlertRequestStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "bRequest" , 8);
        yajl_gen_bool(g, (bool)value.getBRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MvcAlertRequestStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MvcAlertRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::MvcAlertRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MvcAlertRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MvcAlertRequestError"

void serializeJson (const ::rvc_cca_fi::MvcAlertRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::MvcAlertRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::MvcAlertRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::MvcAlertRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPModeStatus"

void serializeJson (const ::rvc_cca_fi::FAPModeStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        yajl_gen_bool(g, (bool)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAPModeStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPModeErrorStructure"

void serializeJson (const ::rvc_cca_fi::FAPModeErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAPModeErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPModeError"

void serializeJson (const ::rvc_cca_fi::FAPModeError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::FAPModeError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::FAPModeError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::FAPModeError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPSettingsStatus"

void serializeJson (const ::rvc_cca_fi::FAPSettingsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArFapSettingState()) {
        yajl_gen_string(g, (const unsigned char*)  "arFapSettingState" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >& o1 = value.getArFapSettingState();
        {
            ::std::vector< ::rvc_cca_fi_types::T_FAP_Settings_State >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                serializeJson((*o0), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasArAvmSettingState()) {
        yajl_gen_string(g, (const unsigned char*)  "arAvmSettingState" , 17);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >& o3 = value.getArAvmSettingState();
        {
            ::std::vector< ::rvc_cca_fi_types::T_AVM_Settings_State >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                serializeJson((*o2), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAPSettingsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPSettingsErrorStructure"

void serializeJson (const ::rvc_cca_fi::FAPSettingsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAPSettingsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPSettingsError"

void serializeJson (const ::rvc_cca_fi::FAPSettingsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::FAPSettingsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::FAPSettingsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::FAPSettingsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPGuidanceStateStatus"

void serializeJson (const ::rvc_cca_fi::FAPGuidanceStateStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8State()) {
        yajl_gen_string(g, (const unsigned char*)  "e8State" , 7);
        yajl_gen_bool(g, (bool)value.getE8State());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAPGuidanceStateStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPGuidanceStateErrorStructure"

void serializeJson (const ::rvc_cca_fi::FAPGuidanceStateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAPGuidanceStateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAPGuidanceStateError"

void serializeJson (const ::rvc_cca_fi::FAPGuidanceStateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::FAPGuidanceStateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::FAPGuidanceStateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::FAPGuidanceStateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_DispStatusStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_DispStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8DispStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8DispStatus" , 12);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_DispStatus_Name(value.getE8DispStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8DispStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_DispStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_DispStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_DispStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_DispStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_DispStatusError"

void serializeJson (const ::rvc_cca_fi::AVM3_DispStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_DispStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_DispStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_DispStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ViewSetupStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_ViewSetupStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ViewPattern()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ViewPattern" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_ViewPattern_Name(value.getE8ViewPattern());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ViewPattern());
    }
    if (!isSparse || value.hasE8CautionId()) {
        yajl_gen_string(g, (const unsigned char*)  "e8CautionId" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_CautionId_Name(value.getE8CautionId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8CautionId());
    }
    if (!isSparse || value.hasSwitch1()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch1" , 7);
        serializeJson(value.getSwitch1(), g, options);
    }
    if (!isSparse || value.hasSwitch2()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch2" , 7);
        serializeJson(value.getSwitch2(), g, options);
    }
    if (!isSparse || value.hasSwitch3()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch3" , 7);
        serializeJson(value.getSwitch3(), g, options);
    }
    if (!isSparse || value.hasSwitch4()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch4" , 7);
        serializeJson(value.getSwitch4(), g, options);
    }
    if (!isSparse || value.hasSwitch5()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch5" , 7);
        serializeJson(value.getSwitch5(), g, options);
    }
    if (!isSparse || value.hasSwitch6()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch6" , 7);
        serializeJson(value.getSwitch6(), g, options);
    }
    if (!isSparse || value.hasSwitch7()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch7" , 7);
        serializeJson(value.getSwitch7(), g, options);
    }
    if (!isSparse || value.hasSwitch8()) {
        yajl_gen_string(g, (const unsigned char*)  "Switch8" , 7);
        serializeJson(value.getSwitch8(), g, options);
    }
    if (!isSparse || value.hasE8IconId()) {
        yajl_gen_string(g, (const unsigned char*)  "e8IconId" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_IconId_Name(value.getE8IconId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8IconId());
    }
    if (!isSparse || value.hasE8BuzzerStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8BuzzerStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus_Name(value.getE8BuzzerStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8BuzzerStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ViewSetupStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ViewSetupErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_ViewSetupErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ViewSetupErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ViewSetupError"

void serializeJson (const ::rvc_cca_fi::AVM3_ViewSetupError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_ViewSetupError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_ViewSetupError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_ViewSetupError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ErrorMessageStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_ErrorMessageStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorMessage()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorMessage" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_ErrorMessage_Name(value.getE8ErrorMessage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorMessage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ErrorMessageStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ErrorMessageErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_ErrorMessageErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ErrorMessageErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ErrorMessageError"

void serializeJson (const ::rvc_cca_fi::AVM3_ErrorMessageError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_ErrorMessageError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_ErrorMessageError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_ErrorMessageError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SonarBuzzerStatusStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_SonarBuzzerStatusStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8BuzzerStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8BuzzerStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus_Name(value.getE8BuzzerStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8BuzzerStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SonarBuzzerStatusStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SonarBuzzerStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_SonarBuzzerStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SonarBuzzerStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SonarBuzzerStatusError"

void serializeJson (const ::rvc_cca_fi::AVM3_SonarBuzzerStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_SonarBuzzerStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_SonarBuzzerStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_SonarBuzzerStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_DetailedStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_DetailedStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArSettingsOption()) {
        yajl_gen_string(g, (const unsigned char*)  "arSettingsOption" , 16);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >& o5 = value.getArSettingsOption();
        {
            ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Option >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                serializeJson((*o4), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasE8PriorityView()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PriorityView" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioView_Name(value.getE8PriorityView());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PriorityView());
    }
    if (!isSparse || value.hasE8PriorityWide()) {
        yajl_gen_string(g, (const unsigned char*)  "e8PriorityWide" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_Setting_PrioWide_Name(value.getE8PriorityWide());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8PriorityWide());
    }
    if (!isSparse || value.hasE8AutoCamPos()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AutoCamPos" , 12);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_Setting_AutoCamPos_Name(value.getE8AutoCamPos());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AutoCamPos());
    }
    if (!isSparse || value.hasRCornerSonarSensLvl()) {
        yajl_gen_string(g, (const unsigned char*)  "rCornerSonarSensLvl" , 19);
        serializeJson(value.getRCornerSonarSensLvl(), g, options);
    }
    if (!isSparse || value.hasRSonarSensLvl()) {
        yajl_gen_string(g, (const unsigned char*)  "rSonarSensLvl" , 13);
        serializeJson(value.getRSonarSensLvl(), g, options);
    }
    if (!isSparse || value.hasRBuzzerSoundLvl()) {
        yajl_gen_string(g, (const unsigned char*)  "rBuzzerSoundLvl" , 15);
        serializeJson(value.getRBuzzerSoundLvl(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_DetailedStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_DetailedErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_DetailedErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_DetailedErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_DetailedError"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_DetailedError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_Settings_DetailedError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_Settings_DetailedError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_Settings_DetailedError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_PrimaryStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_PrimaryStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8AvmSonarBuzzer()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AvmSonarBuzzer" , 16);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState_Name(value.getE8AvmSonarBuzzer());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AvmSonarBuzzer());
    }
    if (!isSparse || value.hasBDetailsSettingsAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bDetailsSettingsAvail" , 21);
        yajl_gen_bool(g, (bool)value.getBDetailsSettingsAvail());
    }
    if (!isSparse || value.hasBImageQualitySettingAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bImageQualitySettingAvail" , 25);
        yajl_gen_bool(g, (bool)value.getBImageQualitySettingAvail());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_PrimaryStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_PrimaryErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_PrimaryErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_PrimaryErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_PrimaryError"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_PrimaryError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_Settings_PrimaryError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_Settings_PrimaryError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_Settings_PrimaryError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ConfigurationStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_ConfigurationStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ConfigStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConfigStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_ConfigurationStatus_Name(value.getE8ConfigStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConfigStatus());
    }
    if (!isSparse || value.hasRUnit_ID()) {
        yajl_gen_string(g, (const unsigned char*)  "rUnit_ID" , 8);
        serializeJson(value.getRUnit_ID(), g, options);
    }
    if (!isSparse || value.hasRMsgSetVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "rMsgSetVersion" , 14);
        serializeJson(value.getRMsgSetVersion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ConfigurationStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ConfigurationErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_ConfigurationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ConfigurationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ConfigurationError"

void serializeJson (const ::rvc_cca_fi::AVM3_ConfigurationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_ConfigurationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_ConfigurationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_ConfigurationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Software_VersionStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_Software_VersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRSW_Version_AVM()) {
        yajl_gen_string(g, (const unsigned char*)  "rSW_Version_AVM" , 15);
        serializeJson(value.getRSW_Version_AVM(), g, options);
    }
    if (!isSparse || value.hasRSW_Version_Sonar()) {
        yajl_gen_string(g, (const unsigned char*)  "rSW_Version_Sonar" , 17);
        serializeJson(value.getRSW_Version_Sonar(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Software_VersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Software_VersionErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_Software_VersionErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Software_VersionErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Software_VersionError"

void serializeJson (const ::rvc_cca_fi::AVM3_Software_VersionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_Software_VersionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_Software_VersionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_Software_VersionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Hardware_VersionStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_Hardware_VersionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRHW_Version_AVM()) {
        yajl_gen_string(g, (const unsigned char*)  "rHW_Version_AVM" , 15);
        serializeJson(value.getRHW_Version_AVM(), g, options);
    }
    if (!isSparse || value.hasRHW_Version_Sonar()) {
        yajl_gen_string(g, (const unsigned char*)  "rHW_Version_Sonar" , 17);
        serializeJson(value.getRHW_Version_Sonar(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Hardware_VersionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Hardware_VersionErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_Hardware_VersionErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Hardware_VersionErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Hardware_VersionError"

void serializeJson (const ::rvc_cca_fi::AVM3_Hardware_VersionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_Hardware_VersionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_Hardware_VersionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_Hardware_VersionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_CommunicationErrorsStatus"

void serializeJson (const ::rvc_cca_fi::AVM3_CommunicationErrorsStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRCommErrors()) {
        yajl_gen_string(g, (const unsigned char*)  "rCommErrors" , 11);
        serializeJson(value.getRCommErrors(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_CommunicationErrorsStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_CommunicationErrorsErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_CommunicationErrorsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_CommunicationErrorsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_CommunicationErrorsError"

void serializeJson (const ::rvc_cca_fi::AVM3_CommunicationErrorsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_CommunicationErrorsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_CommunicationErrorsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_CommunicationErrorsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CameraButtonStart"

void serializeJson (const ::rvc_cca_fi::CameraButtonStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ButtonState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ButtonState" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_ButtonState_Name(value.getE8ButtonState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ButtonState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::CameraButtonStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CameraButtonResult"

void serializeJson (const ::rvc_cca_fi::CameraButtonResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::CameraButtonResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CameraButtonErrorStructure"

void serializeJson (const ::rvc_cca_fi::CameraButtonErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::CameraButtonErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CameraButtonError"

void serializeJson (const ::rvc_cca_fi::CameraButtonError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::CameraButtonError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::CameraButtonError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::CameraButtonError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStatusHmiStart"

void serializeJson (const ::rvc_cca_fi::SetStatusHmiStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8StatusHmi()) {
        yajl_gen_string(g, (const unsigned char*)  "e8StatusHmi" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_Status_Name(value.getE8StatusHmi());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8StatusHmi());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetStatusHmiStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStatusHmiResult"

void serializeJson (const ::rvc_cca_fi::SetStatusHmiResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SystemStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SystemStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_SystemStatus_Name(value.getE8SystemStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SystemStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetStatusHmiResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStatusHmiErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetStatusHmiErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetStatusHmiErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetStatusHmiError"

void serializeJson (const ::rvc_cca_fi::SetStatusHmiError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetStatusHmiError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetStatusHmiError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetStatusHmiError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupLanguageStart"

void serializeJson (const ::rvc_cca_fi::SetupLanguageStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Language()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Language" , 10);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_Language_Name(value.getE8Language());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Language());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupLanguageStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupLanguageResult"

void serializeJson (const ::rvc_cca_fi::SetupLanguageResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupLanguageResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupLanguageErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetupLanguageErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupLanguageErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupLanguageError"

void serializeJson (const ::rvc_cca_fi::SetupLanguageError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetupLanguageError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetupLanguageError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetupLanguageError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupGuideLineStart"

void serializeJson (const ::rvc_cca_fi::SetupGuideLineStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8GuideLine()) {
        yajl_gen_string(g, (const unsigned char*)  "e8GuideLine" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine_Name(value.getE8GuideLine());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8GuideLine());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupGuideLineStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupGuideLineResult"

void serializeJson (const ::rvc_cca_fi::SetupGuideLineResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupGuideLineResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupGuideLineErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetupGuideLineErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupGuideLineErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupGuideLineError"

void serializeJson (const ::rvc_cca_fi::SetupGuideLineError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetupGuideLineError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetupGuideLineError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetupGuideLineError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupVideoControlsStart"

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8HMIDimmingMode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8HMIDimmingMode" , 16);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_VideoParameterDimmingMode_Name(value.getE8HMIDimmingMode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8HMIDimmingMode());
    }
    if (!isSparse || value.hasArVideoControlParameter()) {
        yajl_gen_string(g, (const unsigned char*)  "arVideoControlParameter" , 23);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >& o7 = value.getArVideoControlParameter();
        {
            ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels >::const_iterator o6;
            for (o6 = o7.begin(); o6 != o7.end(); ++o6) {
                serializeJson((*o6), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasE8MVCViewingState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MVCViewingState" , 17);
        const char* s = ::rvc_cca_fi_types::T_e8_MVCViewingState_Name(value.getE8MVCViewingState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MVCViewingState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupVideoControlsResult"

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupVideoControlsErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupVideoControlsError"

void serializeJson (const ::rvc_cca_fi::SetupVideoControlsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetupVideoControlsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetupVideoControlsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetupVideoControlsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSystemStatusStart"

void serializeJson (const ::rvc_cca_fi::SetSystemStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SystemStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SystemStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_SystemStatus_Name(value.getE8SystemStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SystemStatus());
    }
    if (!isSparse || value.hasE8GuideLine()) {
        yajl_gen_string(g, (const unsigned char*)  "e8GuideLine" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_StatusGuideLine_Name(value.getE8GuideLine());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8GuideLine());
    }
    if (!isSparse || value.hasE8WarningText()) {
        yajl_gen_string(g, (const unsigned char*)  "e8WarningText" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_StatusWarningText_Name(value.getE8WarningText());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8WarningText());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetSystemStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSystemStatusResult"

void serializeJson (const ::rvc_cca_fi::SetSystemStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetSystemStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSystemStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetSystemStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetSystemStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetSystemStatusError"

void serializeJson (const ::rvc_cca_fi::SetSystemStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetSystemStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetSystemStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetSystemStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RunExtDevicePowerSupplyTestStart"

void serializeJson (const ::rvc_cca_fi::RunExtDevicePowerSupplyTestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPwrSupplyID()) {
        yajl_gen_string(g, (const unsigned char*)  "pwrSupplyID" , 11);
        yajl_gen_integer(g, (long long)value.getPwrSupplyID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::RunExtDevicePowerSupplyTestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RunExtDevicePowerSupplyTestResult"

void serializeJson (const ::rvc_cca_fi::RunExtDevicePowerSupplyTestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPwrSupplyID()) {
        yajl_gen_string(g, (const unsigned char*)  "pwrSupplyID" , 11);
        yajl_gen_integer(g, (long long)value.getPwrSupplyID());
    }
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::rvc_cca_fi_types::T_e8_Camera_PowerSupplyStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    if (!isSparse || value.hasCurrent()) {
        yajl_gen_string(g, (const unsigned char*)  "current" , 7);
        yajl_gen_integer(g, (long long)value.getCurrent());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::RunExtDevicePowerSupplyTestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitializeStart"

void serializeJson (const ::rvc_cca_fi::InitializeStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Module()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Module" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_Module_Name(value.getE8Module());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Module());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::InitializeStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "InitializeResult"

void serializeJson (const ::rvc_cca_fi::InitializeResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::InitializeResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConfirmSystemStatusStart"

void serializeJson (const ::rvc_cca_fi::ConfirmSystemStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SystemStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SystemStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_SystemStatus_Name(value.getE8SystemStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SystemStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ConfirmSystemStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ConfirmSystemStatusResult"

void serializeJson (const ::rvc_cca_fi::ConfirmSystemStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ConfirmSystemStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupUserConfigurationStart"

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArUserConfiguration()) {
        yajl_gen_string(g, (const unsigned char*)  "arUserConfiguration" , 19);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >& o9 = value.getArUserConfiguration();
        {
            ::std::vector< ::rvc_cca_fi_types::T_ParkAssist_UserConfiguration >::const_iterator o8;
            for (o8 = o9.begin(); o8 != o9.end(); ++o8) {
                serializeJson((*o8), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupUserConfigurationResult"

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupUserConfigurationErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetupUserConfigurationError"

void serializeJson (const ::rvc_cca_fi::SetupUserConfigurationError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetupUserConfigurationError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetupUserConfigurationError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetupUserConfigurationError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMicrophoneStateStart"

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8RequestState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RequestState" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_Set_MicState_Name(value.getE8RequestState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RequestState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMicrophoneStateResult"

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMicrophoneStateErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetMicrophoneStateError"

void serializeJson (const ::rvc_cca_fi::SetMicrophoneStateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetMicrophoneStateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetMicrophoneStateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetMicrophoneStateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCStatusStart"

void serializeJson (const ::rvc_cca_fi::SetRVCStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8RequestState()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RequestState" , 14);
        yajl_gen_integer(g, (long long)value.getE8RequestState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetRVCStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCStatusResult"

void serializeJson (const ::rvc_cca_fi::SetRVCStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetRVCStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetRVCStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetRVCStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRVCStatusError"

void serializeJson (const ::rvc_cca_fi::SetRVCStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetRVCStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetRVCStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetRVCStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_SetupBeepStart"

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SetupBeep()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SetupBeep" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_StatusBeep_Name(value.getE8SetupBeep());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SetupBeep());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_SetupBeepResult"

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8StatusBeep()) {
        yajl_gen_string(g, (const unsigned char*)  "e8StatusBeep" , 12);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_StatusBeep_Name(value.getE8StatusBeep());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8StatusBeep());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_SetupBeepErrorStructure"

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Camera_SetupBeepError"

void serializeJson (const ::rvc_cca_fi::Camera_SetupBeepError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Camera_SetupBeepError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Camera_SetupBeepError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Camera_SetupBeepError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetCamerastateStart"

void serializeJson (const ::rvc_cca_fi::SetCamerastateStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCameraState()) {
        yajl_gen_string(g, (const unsigned char*)  "CameraState" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CameraState_Name(value.getCameraState());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCameraState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetCamerastateStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetCamerastateResult"

void serializeJson (const ::rvc_cca_fi::SetCamerastateResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetCamerastateResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetCamerastateErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetCamerastateErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "ErrorCode" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetCamerastateErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetCamerastateError"

void serializeJson (const ::rvc_cca_fi::SetCamerastateError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetCamerastateError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetCamerastateError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetCamerastateError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeViewRequestStart"

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Status" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_AVM_View_Request_Name(value.getU8Status());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getU8Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeViewRequestResult"

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeViewRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ChangeViewRequestError"

void serializeJson (const ::rvc_cca_fi::ChangeViewRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::ChangeViewRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::ChangeViewRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::ChangeViewRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupBswStart"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Status" , 8);
        yajl_gen_integer(g, (long long)value.getU8Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupBswResult"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupBswErrorStructure"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupBswError"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupBswError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Affordable_Its_SetupBswError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Affordable_Its_SetupBswError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Affordable_Its_SetupBswError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupModStart"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Status" , 8);
        yajl_gen_integer(g, (long long)value.getU8Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupModResult"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupModErrorStructure"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupModError"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupModError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Affordable_Its_SetupModError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Affordable_Its_SetupModError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Affordable_Its_SetupModError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupLdwStart"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Status()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Status" , 8);
        yajl_gen_integer(g, (long long)value.getU8Status());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupLdwResult"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupLdwErrorStructure"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Affordable_Its_SetupLdwError"

void serializeJson (const ::rvc_cca_fi::Affordable_Its_SetupLdwError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::Affordable_Its_SetupLdwError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::Affordable_Its_SetupLdwError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::Affordable_Its_SetupLdwError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetHMIStatusStart"

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8IPAStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8IPAStatus" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_HMIStatus_Name(value.getE8IPAStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8IPAStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetHMIStatusResult"

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetHMIStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetHMIStatusError"

void serializeJson (const ::rvc_cca_fi::IPA_SetHMIStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPA_SetHMIStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPA_SetHMIStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPA_SetHMIStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetButtonStart"

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ButtonIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ButtonIdentifier" , 18);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID_Name(value.getE8ButtonIdentifier());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ButtonIdentifier());
    }
    if (!isSparse || value.hasE8ButtonStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ButtonStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_ButtonState_Name(value.getE8ButtonStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ButtonStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetButtonResult"

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetButtonErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_SetButtonError"

void serializeJson (const ::rvc_cca_fi::IPA_SetButtonError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPA_SetButtonError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPA_SetButtonError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPA_SetButtonError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_Voice_TextsStart"

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArTexts()) {
        yajl_gen_string(g, (const unsigned char*)  "arTexts" , 7);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >& o11 = value.getArTexts();
        {
            ::std::vector< ::rvc_cca_fi_types::T_IPA_Voice_Text_Strings >::const_iterator o10;
            for (o10 = o11.begin(); o10 != o11.end(); ++o10) {
                serializeJson((*o10), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    if (!isSparse || value.hasLanguage()) {
        yajl_gen_string(g, (const unsigned char*)  "Language" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_Language_Name(value.getLanguage());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getLanguage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_Voice_TextsResult"

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_Voice_TextsErrorStructure"

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "IPA_Voice_TextsError"

void serializeJson (const ::rvc_cca_fi::IPA_Voice_TextsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::IPA_Voice_TextsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::IPA_Voice_TextsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::IPA_Voice_TextsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MVC_HMI_ViewRequestStart"

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Request()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Request" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_MVCViewingState_Name(value.getE8Request());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Request());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MVC_HMI_ViewRequestResult"

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MVC_HMI_ViewRequestErrorStructure"

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MVC_HMI_ViewRequestError"

void serializeJson (const ::rvc_cca_fi::MVC_HMI_ViewRequestError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::MVC_HMI_ViewRequestError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::MVC_HMI_ViewRequestError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::MVC_HMI_ViewRequestError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustmentCompleteStart"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Completion()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Completion" , 12);
        const char* s = ::rvc_cca_fi_types::T_e8_GdlAdj_Completion_Name(value.getE8Completion());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Completion());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustmentCompleteResult"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustmentCompleteErrorStructure"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustmentCompleteError"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::GdlAdj_AdjustmentCompleteError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::GdlAdj_AdjustmentCompleteError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustButtonStart"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Button()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Button" , 8);
        const char* s = ::rvc_cca_fi_types::T_e8_GdlAdj_AdjustButton_Name(value.getE8Button());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Button());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustButtonResult"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustButtonErrorStructure"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_AdjustButtonError"

void serializeJson (const ::rvc_cca_fi::GdlAdj_AdjustButtonError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::GdlAdj_AdjustButtonError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::GdlAdj_AdjustButtonError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::GdlAdj_AdjustButtonError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_ConfigurationDataStart"

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Request()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Request" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_GdlAdj_Request_Name(value.getE8Request());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Request());
    }
    if (!isSparse || value.hasArConfigParameterData()) {
        yajl_gen_string(g, (const unsigned char*)  "arConfigParameterData" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData >& o13 = value.getArConfigParameterData();
        {
            ::std::vector< ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData >::const_iterator o12;
            for (o12 = o13.begin(); o12 != o13.end(); ++o12) {
                serializeJson((*o12), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_ConfigurationDataResult"

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    if (!isSparse || value.hasE8Request()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Request" , 9);
        const char* s = ::rvc_cca_fi_types::T_e8_GdlAdj_Request_Name(value.getE8Request());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Request());
    }
    if (!isSparse || value.hasArConfigParameterData()) {
        yajl_gen_string(g, (const unsigned char*)  "arConfigParameterData" , 21);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData >& o15 = value.getArConfigParameterData();
        {
            ::std::vector< ::rvc_cca_fi_types::T_GdlAdj_ConfigParameterData >::const_iterator o14;
            for (o14 = o15.begin(); o14 != o15.end(); ++o14) {
                serializeJson((*o14), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_ConfigurationDataErrorStructure"

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GdlAdj_ConfigurationDataError"

void serializeJson (const ::rvc_cca_fi::GdlAdj_ConfigurationDataError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::GdlAdj_ConfigurationDataError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::GdlAdj_ConfigurationDataError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::GdlAdj_ConfigurationDataError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAP_SetButtonStart"

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ButtonIdentifier()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ButtonIdentifier" , 18);
        const char* s = ::rvc_cca_fi_types::T_e8_IPA_BUTTON_ID_Name(value.getE8ButtonIdentifier());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ButtonIdentifier());
    }
    if (!isSparse || value.hasE8ButtonStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ButtonStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_ButtonState_Name(value.getE8ButtonStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ButtonStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAP_SetButtonResult"

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAP_SetButtonErrorStructure"

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FAP_SetButtonError"

void serializeJson (const ::rvc_cca_fi::FAP_SetButtonError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::FAP_SetButtonError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::FAP_SetButtonError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::FAP_SetButtonError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchEventStart"

void serializeJson (const ::rvc_cca_fi::TouchEventStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArTouchData()) {
        yajl_gen_string(g, (const unsigned char*)  "arTouchData" , 11);
        serializeJson(value.getArTouchData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::TouchEventStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchEventResult"

void serializeJson (const ::rvc_cca_fi::TouchEventResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::TouchEventResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchEventErrorStructure"

void serializeJson (const ::rvc_cca_fi::TouchEventErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::TouchEventErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "TouchEventError"

void serializeJson (const ::rvc_cca_fi::TouchEventError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::TouchEventError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::TouchEventError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::TouchEventError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPSInfoStart"

void serializeJson (const ::rvc_cca_fi::GPSInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArGpsData()) {
        yajl_gen_string(g, (const unsigned char*)  "arGpsData" , 9);
        serializeJson(value.getArGpsData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GPSInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPSInfoResult"

void serializeJson (const ::rvc_cca_fi::GPSInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GPSInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPSInfoErrorStructure"

void serializeJson (const ::rvc_cca_fi::GPSInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::GPSInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GPSInfoError"

void serializeJson (const ::rvc_cca_fi::GPSInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::GPSInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::GPSInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::GPSInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapMatchedInfoStart"

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasArMapMatchedData()) {
        yajl_gen_string(g, (const unsigned char*)  "arMapMatchedData" , 16);
        serializeJson(value.getArMapMatchedData(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapMatchedInfoResult"

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapMatchedInfoErrorStructure"

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MapMatchedInfoError"

void serializeJson (const ::rvc_cca_fi::MapMatchedInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::MapMatchedInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::MapMatchedInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::MapMatchedInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FapLearnParkPositionStart"

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequestOn()) {
        yajl_gen_string(g, (const unsigned char*)  "RequestOn" , 9);
        yajl_gen_bool(g, (bool)value.getRequestOn());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FapLearnParkPositionResult"

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FapLearnParkPositionErrorStructure"

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "FapLearnParkPositionError"

void serializeJson (const ::rvc_cca_fi::FapLearnParkPositionError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::FapLearnParkPositionError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::FapLearnParkPositionError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::FapLearnParkPositionError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFapGuidanceStart"

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasRequest()) {
        yajl_gen_string(g, (const unsigned char*)  "Request" , 7);
        yajl_gen_bool(g, (bool)value.getRequest());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFapGuidanceResult"

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        yajl_gen_bool(g, (bool)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFapGuidanceErrorStructure"

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetFapGuidanceError"

void serializeJson (const ::rvc_cca_fi::SetFapGuidanceError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::SetFapGuidanceError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::SetFapGuidanceError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::SetFapGuidanceError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSwitchStart"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8SwitchId()) {
        yajl_gen_string(g, (const unsigned char*)  "e8SwitchId" , 10);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SwitchId_Name(value.getE8SwitchId());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8SwitchId());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSwitchResult"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSwitchErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSwitchError"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSwitchError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_SetSwitchError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_SetSwitchError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_SetSwitchError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSonarBuzzerStatusStart"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8BuzzerStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8BuzzerStatus" , 14);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_BuzzerStatus_Name(value.getE8BuzzerStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8BuzzerStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSonarBuzzerStatusResult"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSonarBuzzerStatusErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_SetSonarBuzzerStatusError"

void serializeJson (const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Detailed_SendReqStart"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8RequestType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RequestType" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_RequestType_Name(value.getE8RequestType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RequestType());
    }
    if (!isSparse || value.hasArChangedItems()) {
        yajl_gen_string(g, (const unsigned char*)  "arChangedItems" , 14);
        yajl_gen_array_open(g);
        const ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Item >& o17 = value.getArChangedItems();
        {
            ::std::vector< ::rvc_cca_fi_types::T_AVMph3_Setting_Item >::const_iterator o16;
            for (o16 = o17.begin(); o16 != o17.end(); ++o16) {
                serializeJson((*o16), g, options);
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Detailed_SendReqResult"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Detailed_SendReqErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Detailed_SendReqError"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Primary_SendReqStart"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8RequestType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RequestType" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_RequestType_Name(value.getE8RequestType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RequestType());
    }
    if (!isSparse || value.hasE8AvmSonarBuzzer()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AvmSonarBuzzer" , 16);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_SettingOptionState_Name(value.getE8AvmSonarBuzzer());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AvmSonarBuzzer());
    }
    if (!isSparse || value.hasBDetailsSettingsAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bDetailsSettingsAvail" , 21);
        yajl_gen_bool(g, (bool)value.getBDetailsSettingsAvail());
    }
    if (!isSparse || value.hasBImageQualitySettingAvail()) {
        yajl_gen_string(g, (const unsigned char*)  "bImageQualitySettingAvail" , 25);
        yajl_gen_bool(g, (bool)value.getBImageQualitySettingAvail());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Primary_SendReqResult"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Primary_SendReqErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_Settings_Primary_SendReqError"

void serializeJson (const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_Settings_Primary_SendReqError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_Settings_Primary_SendReqError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetVersionInfoStart"

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoStart& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8VersionType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8VersionType" , 13);
        const char* s = ::rvc_cca_fi_types::T_e8_AVMph3_VersionInfoType_Name(value.getE8VersionType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8VersionType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoStart& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetVersionInfoResult"

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetVersionInfoErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetVersionInfoError"

void serializeJson (const ::rvc_cca_fi::AVM3_GetVersionInfoError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_GetVersionInfoError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_GetVersionInfoError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_GetVersionInfoError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetCommunicationErrorsResult"

void serializeJson (const ::rvc_cca_fi::AVM3_GetCommunicationErrorsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_GetCommunicationErrorsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetCommunicationErrorsErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_GetCommunicationErrorsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_GetCommunicationErrorsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_GetCommunicationErrorsError"

void serializeJson (const ::rvc_cca_fi::AVM3_GetCommunicationErrorsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_GetCommunicationErrorsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_GetCommunicationErrorsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_GetCommunicationErrorsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ClearCommunicationErrorsResult"

void serializeJson (const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsResult& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBResult()) {
        yajl_gen_string(g, (const unsigned char*)  "bResult" , 7);
        yajl_gen_bool(g, (bool)value.getBResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsResult& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ClearCommunicationErrorsErrorStructure"

void serializeJson (const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "AVM3_ClearCommunicationErrorsError"

void serializeJson (const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::AVM3_ClearCommunicationErrorsError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::AVM3_ClearCommunicationErrorsError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ToggleGpioPinOnOffErrorStructure"

void serializeJson (const ::rvc_cca_fi::ToggleGpioPinOnOffErrorStructure& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8ErrorCode()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ErrorCode" , 11);
        const char* s = ::rvc_cca_fi_types::T_e8_RVC_CCAError_Name(value.getE8ErrorCode());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ErrorCode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::rvc_cca_fi::ToggleGpioPinOnOffErrorStructure& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ToggleGpioPinOnOffError"

void serializeJson (const ::rvc_cca_fi::ToggleGpioPinOnOffError& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::rvc_cca_fi::ToggleGpioPinOnOffError::E_CCA_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "ccaErrorCode" , 12);
            serializeJson(value.getCcaErrorCode(), g, options);
            break;
        }
    case ::rvc_cca_fi::ToggleGpioPinOnOffError::E_SYSTEM_ERROR_CODE:
        {
            yajl_gen_string(g, (const unsigned char*)  "systemErrorCode" , 15);
            const char* s = ::asf::cca::CcaTypes::SystemErrorCode_Name(value.getSystemErrorCode());
            if (s != NULL)
                yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
            else
                yajl_gen_integer(g, (long long)value.getSystemErrorCode());
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::rvc_cca_fi::ToggleGpioPinOnOffError& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SystemConfigurationsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SystemConfigurationsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SystemConfigurationsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SystemStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SystemStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SystemStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::VideoSignalStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::VideoSignalStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::VideoSignalStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ReverseSignalStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ReverseSignalStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ReverseSignalStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_PwrSupplyStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_PwrSupplyStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_PwrSupplyStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Microphone_PwrSupplyStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Microphone_PwrSupplyStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Microphone_PwrSupplyStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Tailgate_StatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Tailgate_StatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Tailgate_StatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::View_Close_AuthorizedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::View_Close_AuthorizedErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::View_Close_AuthorizedError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AvmR_Current_ViewStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AvmR_Current_ViewErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AvmR_Current_ViewError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_ITSStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_ITSErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_ITSError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAConfigurationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAConfigurationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAConfigurationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAPatternRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAPatternRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAPatternRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAMessageRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAMessageRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPAMessageRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPASwitchMaskRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPASwitchMaskRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPASwitchMaskRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPASwitchGreyOutRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPASwitchGreyOutRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPASwitchGreyOutRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPADirectionIndicatorStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPADirectionIndicatorErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPADirectionIndicatorError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_SteeringAngleStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_SteeringAngleErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_SteeringAngleError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_CameraAngleStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_CameraAngleErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_CameraAngleError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CANFrameStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CANFrameStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CANFrameStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MvcViewStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MvcViewStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MvcViewStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MvcAlertRequestStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MvcAlertRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MvcAlertRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPModeStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPModeErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPModeError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPSettingsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPSettingsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPSettingsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPGuidanceStateStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPGuidanceStateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAPGuidanceStateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_DispStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_DispStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_DispStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ViewSetupStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ViewSetupErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ViewSetupError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ErrorMessageStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ErrorMessageErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ErrorMessageError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SonarBuzzerStatusStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SonarBuzzerStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SonarBuzzerStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_DetailedStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_DetailedErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_DetailedError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_PrimaryStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_PrimaryErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_PrimaryError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ConfigurationStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ConfigurationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ConfigurationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Software_VersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Software_VersionErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Software_VersionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Hardware_VersionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Hardware_VersionErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Hardware_VersionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_CommunicationErrorsStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_CommunicationErrorsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_CommunicationErrorsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CameraButtonStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CameraButtonResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CameraButtonErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::CameraButtonError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetStatusHmiStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetStatusHmiResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetStatusHmiErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetStatusHmiError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupLanguageStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupLanguageResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupLanguageErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupLanguageError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupGuideLineStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupGuideLineResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupGuideLineErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupGuideLineError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupVideoControlsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupVideoControlsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupVideoControlsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupVideoControlsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetSystemStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetSystemStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetSystemStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetSystemStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::RunExtDevicePowerSupplyTestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::RunExtDevicePowerSupplyTestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::InitializeStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::InitializeResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ConfirmSystemStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ConfirmSystemStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupUserConfigurationStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupUserConfigurationResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupUserConfigurationErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetupUserConfigurationError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetMicrophoneStateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetMicrophoneStateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetMicrophoneStateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetMicrophoneStateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetRVCStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetRVCStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetRVCStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetRVCStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_SetupBeepStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_SetupBeepResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_SetupBeepErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Camera_SetupBeepError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetCamerastateStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetCamerastateResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetCamerastateErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetCamerastateError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ChangeViewRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ChangeViewRequestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ChangeViewRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ChangeViewRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupBswStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupBswResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupBswErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupBswError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupModStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupModResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupModErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupModError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupLdwStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupLdwResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupLdwErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::Affordable_Its_SetupLdwError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetHMIStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetHMIStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetHMIStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetHMIStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetButtonStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetButtonResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetButtonErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_SetButtonError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_Voice_TextsStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_Voice_TextsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_Voice_TextsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::IPA_Voice_TextsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MVC_HMI_ViewRequestStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MVC_HMI_ViewRequestResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MVC_HMI_ViewRequestErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MVC_HMI_ViewRequestError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustmentCompleteError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustButtonStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustButtonResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustButtonErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_AdjustButtonError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_ConfigurationDataStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_ConfigurationDataResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_ConfigurationDataErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GdlAdj_ConfigurationDataError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAP_SetButtonStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAP_SetButtonResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAP_SetButtonErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FAP_SetButtonError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::TouchEventStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::TouchEventResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::TouchEventErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::TouchEventError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GPSInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GPSInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GPSInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::GPSInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MapMatchedInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MapMatchedInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MapMatchedInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::MapMatchedInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FapLearnParkPositionStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FapLearnParkPositionResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FapLearnParkPositionErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::FapLearnParkPositionError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetFapGuidanceStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetFapGuidanceResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetFapGuidanceErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::SetFapGuidanceError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSwitchStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSwitchResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSwitchErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSwitchError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_SetSonarBuzzerStatusError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Detailed_SendReqError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_Settings_Primary_SendReqError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetVersionInfoStart& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetVersionInfoResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetVersionInfoErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetVersionInfoError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetCommunicationErrorsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetCommunicationErrorsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_GetCommunicationErrorsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsResult& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::AVM3_ClearCommunicationErrorsError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ToggleGpioPinOnOffErrorStructure& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi
using namespace ::asf::stream::json;

namespace rvc_cca_fi {

std::ostream& operator<<(std::ostream& o, const ::rvc_cca_fi::ToggleGpioPinOnOffError& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace rvc_cca_fi

