/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profilePIVI.h"
#include "bosch/cm/profilePIVIConst.h"
#include "bosch/cm/profilePIVIDBus.h"
#include "bosch/cm/profilePIVIJson.h"
#include "bosch/cm/profilePIVIStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace profilePIVI {

DEFINE_CLASS_LOGGER("/bosch/cm/bosch/cm/profilePIVI", ProfilePIVIStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "getKeylist", 3 },
    { 22, "mapKeyToCurrentProfile", 0 },
    { 22, "setLoginKeyLinkSetting", 2 },
    { 24, "SetWelcomeGuidanceActive", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "keyID", 2 },
    { 11, "keyIsMapped", 0 },
    { 16, "ProfilekeyIIndex", 3 },
    { 17, "IsStartupSequence", 6 },
    { 18, "keyMappingPossible", 1 },
    { 18, "loginKeyLinkStatus", 5 },
    { 21, "welcomeGuidanceActive", 4 },
};

class ProfilePIVIStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ProfilePIVIStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ProfilePIVIStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ProfilePIVIStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.profilePIVI"),
          _logger(logger) {}

    virtual ~ProfilePIVIStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ProfilePIVIStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'mapKeyToCurrentProfile'

            LOG_DEBUG_STUB("process method '%s'", "mapKeyToCurrentProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapKeyToCurrentProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MapKeyToCurrentProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MapKeyToCurrentProfileRequest > payload = ::boost::static_pointer_cast<MapKeyToCurrentProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfilePIVIStub*>(getStub())->onMapKeyToCurrentProfileRequest(payload);
            return;
        }
        case 1: {

            // method 'SetWelcomeGuidanceActive'

            LOG_DEBUG_STUB("process method '%s'", "SetWelcomeGuidanceActive");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetWelcomeGuidanceActiveRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetWelcomeGuidanceActive", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetWelcomeGuidanceActiveRequest > payload = ::boost::static_pointer_cast<SetWelcomeGuidanceActiveRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfilePIVIStub*>(getStub())->onSetWelcomeGuidanceActiveRequest(payload);
            return;
        }
        case 2: {

            // method 'setLoginKeyLinkSetting'

            LOG_DEBUG_STUB("process method '%s'", "setLoginKeyLinkSetting");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLoginKeyLinkSettingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetLoginKeyLinkSetting", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetLoginKeyLinkSettingRequest > payload = ::boost::static_pointer_cast<SetLoginKeyLinkSettingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfilePIVIStub*>(getStub())->onSetLoginKeyLinkSettingRequest(payload);
            return;
        }
        case 3: {

            // method 'getKeylist'

            LOG_DEBUG_STUB("process method '%s'", "getKeylist");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetKeylistRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetKeylist", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetKeylistRequest > payload = ::boost::static_pointer_cast<GetKeylistRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfilePIVIStub*>(getStub())->onGetKeylistRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ProfilePIVIStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.profilePIVI\">\n"
            "    <property access=\"read\" name=\"keyIsMapped\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"keyMappingPossible\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"keyID\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ProfilekeyIIndex\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"welcomeGuidanceActive\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"loginKeyLinkStatus\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"IsStartupSequence\" type=\"b\"/>\n"
            "    <method name=\"mapKeyToCurrentProfile\">\n"
            "      <doc>\n"
            "        <line>mapKeyToCurrentProfile = map the current KeyID to the active Profile</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"Result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetWelcomeGuidanceActive\">\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"wgActive\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>wgActive = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"setLoginKeyLinkSetting\">\n"
            "      <arg direction=\"in\" name=\"loginKeyLinkSetting\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>loginKeyLinkSetting = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"getKeylist\">\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"keylist\" type=\"ay\">\n"
            "        <doc>\n"
            "          <line>keylist = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void ProfilePIVIStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ProfilePIVIStub*>(getStub()))->onGetAll (properties);
}

void ProfilePIVIStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 7, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "keyIsMapped");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "keyMappingPossible");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "keyID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ProfilekeyIIndex");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "welcomeGuidanceActive");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "loginKeyLinkStatus");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "IsStartupSequence");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ProfilePIVIStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 7, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "keyIsMapped");
            ::boost::shared_ptr< KeyIsMappedGet > payload(new KeyIsMappedGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onKeyIsMappedGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "keyMappingPossible");
            ::boost::shared_ptr< KeyMappingPossibleGet > payload(new KeyMappingPossibleGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onKeyMappingPossibleGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "keyID");
            ::boost::shared_ptr< KeyIDGet > payload(new KeyIDGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onKeyIDGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ProfilekeyIIndex");
            ::boost::shared_ptr< ProfilekeyIIndexGet > payload(new ProfilekeyIIndexGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onProfilekeyIIndexGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "welcomeGuidanceActive");
            ::boost::shared_ptr< WelcomeGuidanceActiveGet > payload(new WelcomeGuidanceActiveGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onWelcomeGuidanceActiveGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "loginKeyLinkStatus");
            ::boost::shared_ptr< LoginKeyLinkStatusGet > payload(new LoginKeyLinkStatusGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onLoginKeyLinkStatusGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "IsStartupSequence");
            ::boost::shared_ptr< IsStartupSequenceGet > payload(new IsStartupSequenceGet());
            payload->setAct(act);
            static_cast<ProfilePIVIStub*>(getStub())->onIsStartupSequenceGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ProfilePIVIStub::ProfilePIVIStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ProfilePIVIStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ProfilePIVIStub::ProfilePIVIStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ProfilePIVIStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ProfilePIVIStub::~ProfilePIVIStub() {
    delete _stubDelegate;
}

void ProfilePIVIStub::sendKeyIsMappedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KeyIsMappedUpdate payload(_keyIsMappedProperty);

        LOG_INFO ("-> send%s", "KeyIsMappedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("keyIsMapped", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KeyIsMappedUpdate");
    }
}

void ProfilePIVIStub::onKeyIsMappedGet(const ::boost::shared_ptr< KeyIsMappedGet >& keyIsMapped) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KeyIsMappedGet", keyIsMapped->getAct());
    sendKeyIsMappedGetUpdate(_keyIsMappedProperty.getKeyIsMapped(), keyIsMapped->getAct());
}

void ProfilePIVIStub::sendKeyIsMappedGetUpdate(bool keyIsMapped, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KeyIsMappedGet payload(keyIsMapped);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KeyIsMappedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setKeyIsMapped(bool keyIsMapped) {
    if(keyIsMapped!=_keyIsMappedProperty.getKeyIsMapped()) {
        _keyIsMappedProperty.setKeyIsMapped(keyIsMapped);
        sendKeyIsMappedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ProfilePIVIStub::getKeyIsMapped() const {
    return _keyIsMappedProperty.getKeyIsMapped();
}

void ProfilePIVIStub::sendKeyMappingPossibleUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KeyMappingPossibleUpdate payload(_keyMappingPossibleProperty);

        LOG_INFO ("-> send%s", "KeyMappingPossibleUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("keyMappingPossible", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KeyMappingPossibleUpdate");
    }
}

void ProfilePIVIStub::onKeyMappingPossibleGet(const ::boost::shared_ptr< KeyMappingPossibleGet >& keyMappingPossible) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KeyMappingPossibleGet", keyMappingPossible->getAct());
    sendKeyMappingPossibleGetUpdate(_keyMappingPossibleProperty.getKeyMappingPossible(), keyMappingPossible->getAct());
}

void ProfilePIVIStub::sendKeyMappingPossibleGetUpdate(bool keyMappingPossible, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KeyMappingPossibleGet payload(keyMappingPossible);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KeyMappingPossibleGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setKeyMappingPossible(bool keyMappingPossible) {
    if(keyMappingPossible!=_keyMappingPossibleProperty.getKeyMappingPossible()) {
        _keyMappingPossibleProperty.setKeyMappingPossible(keyMappingPossible);
        sendKeyMappingPossibleUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ProfilePIVIStub::getKeyMappingPossible() const {
    return _keyMappingPossibleProperty.getKeyMappingPossible();
}

void ProfilePIVIStub::sendKeyIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KeyIDUpdate payload(_keyIDProperty);

        LOG_INFO ("-> send%s", "KeyIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("keyID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KeyIDUpdate");
    }
}

void ProfilePIVIStub::onKeyIDGet(const ::boost::shared_ptr< KeyIDGet >& keyID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KeyIDGet", keyID->getAct());
    sendKeyIDGetUpdate(_keyIDProperty.getKeyID(), keyID->getAct());
}

void ProfilePIVIStub::sendKeyIDGetUpdate(uint32 keyID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KeyIDGet payload(keyID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KeyIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setKeyID(uint32 keyID) {
    if(keyID!=_keyIDProperty.getKeyID()) {
        _keyIDProperty.setKeyID(keyID);
        sendKeyIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 ProfilePIVIStub::getKeyID() const {
    return _keyIDProperty.getKeyID();
}

void ProfilePIVIStub::sendProfilekeyIIndexUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProfilekeyIIndexUpdate payload(_ProfilekeyIIndexProperty);

        LOG_INFO ("-> send%s", "ProfilekeyIIndexUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ProfilekeyIIndex", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProfilekeyIIndexUpdate");
    }
}

void ProfilePIVIStub::onProfilekeyIIndexGet(const ::boost::shared_ptr< ProfilekeyIIndexGet >& profilekeyIIndex) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProfilekeyIIndexGet", profilekeyIIndex->getAct());
    sendProfilekeyIIndexGetUpdate(_ProfilekeyIIndexProperty.getProfilekeyIIndex(), profilekeyIIndex->getAct());
}

void ProfilePIVIStub::sendProfilekeyIIndexGetUpdate(uint8 profilekeyIIndex, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProfilekeyIIndexGet payload(profilekeyIIndex);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProfilekeyIIndexGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setProfilekeyIIndex(uint8 profilekeyIIndex) {
    if(profilekeyIIndex!=_ProfilekeyIIndexProperty.getProfilekeyIIndex()) {
        _ProfilekeyIIndexProperty.setProfilekeyIIndex(profilekeyIIndex);
        sendProfilekeyIIndexUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 ProfilePIVIStub::getProfilekeyIIndex() const {
    return _ProfilekeyIIndexProperty.getProfilekeyIIndex();
}

void ProfilePIVIStub::sendWelcomeGuidanceActiveUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WelcomeGuidanceActiveUpdate payload(_welcomeGuidanceActiveProperty);

        LOG_INFO ("-> send%s", "WelcomeGuidanceActiveUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("welcomeGuidanceActive", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WelcomeGuidanceActiveUpdate");
    }
}

void ProfilePIVIStub::onWelcomeGuidanceActiveGet(const ::boost::shared_ptr< WelcomeGuidanceActiveGet >& welcomeGuidanceActive) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WelcomeGuidanceActiveGet", welcomeGuidanceActive->getAct());
    sendWelcomeGuidanceActiveGetUpdate(_welcomeGuidanceActiveProperty.getWelcomeGuidanceActive(), welcomeGuidanceActive->getAct());
}

void ProfilePIVIStub::sendWelcomeGuidanceActiveGetUpdate(bool welcomeGuidanceActive, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WelcomeGuidanceActiveGet payload(welcomeGuidanceActive);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WelcomeGuidanceActiveGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setWelcomeGuidanceActive(bool welcomeGuidanceActive) {
    if(welcomeGuidanceActive!=_welcomeGuidanceActiveProperty.getWelcomeGuidanceActive()) {
        _welcomeGuidanceActiveProperty.setWelcomeGuidanceActive(welcomeGuidanceActive);
        sendWelcomeGuidanceActiveUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ProfilePIVIStub::getWelcomeGuidanceActive() const {
    return _welcomeGuidanceActiveProperty.getWelcomeGuidanceActive();
}

void ProfilePIVIStub::sendLoginKeyLinkStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LoginKeyLinkStatusUpdate payload(_loginKeyLinkStatusProperty);

        LOG_INFO ("-> send%s", "LoginKeyLinkStatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("loginKeyLinkStatus", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LoginKeyLinkStatusUpdate");
    }
}

void ProfilePIVIStub::onLoginKeyLinkStatusGet(const ::boost::shared_ptr< LoginKeyLinkStatusGet >& loginKeyLinkStatus) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LoginKeyLinkStatusGet", loginKeyLinkStatus->getAct());
    sendLoginKeyLinkStatusGetUpdate(_loginKeyLinkStatusProperty.getLoginKeyLinkStatus(), loginKeyLinkStatus->getAct());
}

void ProfilePIVIStub::sendLoginKeyLinkStatusGetUpdate(bool loginKeyLinkStatus, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LoginKeyLinkStatusGet payload(loginKeyLinkStatus);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LoginKeyLinkStatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setLoginKeyLinkStatus(bool loginKeyLinkStatus) {
    if(loginKeyLinkStatus!=_loginKeyLinkStatusProperty.getLoginKeyLinkStatus()) {
        _loginKeyLinkStatusProperty.setLoginKeyLinkStatus(loginKeyLinkStatus);
        sendLoginKeyLinkStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ProfilePIVIStub::getLoginKeyLinkStatus() const {
    return _loginKeyLinkStatusProperty.getLoginKeyLinkStatus();
}

void ProfilePIVIStub::sendIsStartupSequenceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IsStartupSequenceUpdate payload(_IsStartupSequenceProperty);

        LOG_INFO ("-> send%s", "IsStartupSequenceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IsStartupSequence", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profilePIVI", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IsStartupSequenceUpdate");
    }
}

void ProfilePIVIStub::onIsStartupSequenceGet(const ::boost::shared_ptr< IsStartupSequenceGet >& isStartupSequence) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IsStartupSequenceGet", isStartupSequence->getAct());
    sendIsStartupSequenceGetUpdate(_IsStartupSequenceProperty.getIsStartupSequence(), isStartupSequence->getAct());
}

void ProfilePIVIStub::sendIsStartupSequenceGetUpdate(bool isStartupSequence, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IsStartupSequenceGet payload(isStartupSequence);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IsStartupSequenceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfilePIVIStub::setIsStartupSequence(bool isStartupSequence) {
    if(isStartupSequence!=_IsStartupSequenceProperty.getIsStartupSequence()) {
        _IsStartupSequenceProperty.setIsStartupSequence(isStartupSequence);
        sendIsStartupSequenceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ProfilePIVIStub::getIsStartupSequence() const {
    return _IsStartupSequenceProperty.getIsStartupSequence();
}

void  ProfilePIVIStub::sendMapKeyToCurrentProfileResponse (serverResult result, act_t act) {
    MapKeyToCurrentProfileResponse* payload = new MapKeyToCurrentProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "mapKeyToCurrentProfile", MapKeyToCurrentProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MapKeyToCurrentProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendMapKeyToCurrentProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MapKeyToCurrentProfileError* payload = new MapKeyToCurrentProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "mapKeyToCurrentProfile", MapKeyToCurrentProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MapKeyToCurrentProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendSetWelcomeGuidanceActiveResponse (serverResult result, act_t act) {
    SetWelcomeGuidanceActiveResponse* payload = new SetWelcomeGuidanceActiveResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetWelcomeGuidanceActive", SetWelcomeGuidanceActiveResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetWelcomeGuidanceActive", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendSetWelcomeGuidanceActiveError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetWelcomeGuidanceActiveError* payload = new SetWelcomeGuidanceActiveError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetWelcomeGuidanceActive", SetWelcomeGuidanceActiveError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetWelcomeGuidanceActive", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendSetLoginKeyLinkSettingResponse (serverResult result, act_t act) {
    SetLoginKeyLinkSettingResponse* payload = new SetLoginKeyLinkSettingResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "setLoginKeyLinkSetting", SetLoginKeyLinkSettingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetLoginKeyLinkSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendSetLoginKeyLinkSettingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetLoginKeyLinkSettingError* payload = new SetLoginKeyLinkSettingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "setLoginKeyLinkSetting", SetLoginKeyLinkSettingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetLoginKeyLinkSetting", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendGetKeylistResponse (const ::std::vector< uint8 >& keylist, act_t act) {
    GetKeylistResponse* payload = new GetKeylistResponse(keylist);
    DBUS_MESSAGE_REPLY(dbusMessage, "getKeylist", GetKeylistResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetKeylist", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfilePIVIStub::sendGetKeylistError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetKeylistError* payload = new GetKeylistError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "getKeylist", GetKeylistError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetKeylist", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ProfilePIVIStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'keyIsMapped'
    {
        ::asf::dbus::DBusVariant variant;
        KeyIsMappedGet payload(_keyIsMappedProperty.getKeyIsMapped());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("keyIsMapped", variant));
    }

    //property 'keyMappingPossible'
    {
        ::asf::dbus::DBusVariant variant;
        KeyMappingPossibleGet payload(_keyMappingPossibleProperty.getKeyMappingPossible());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("keyMappingPossible", variant));
    }

    //property 'keyID'
    {
        ::asf::dbus::DBusVariant variant;
        KeyIDGet payload(_keyIDProperty.getKeyID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("keyID", variant));
    }

    //property 'ProfilekeyIIndex'
    {
        ::asf::dbus::DBusVariant variant;
        ProfilekeyIIndexGet payload(_ProfilekeyIIndexProperty.getProfilekeyIIndex());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ProfilekeyIIndex", variant));
    }

    //property 'welcomeGuidanceActive'
    {
        ::asf::dbus::DBusVariant variant;
        WelcomeGuidanceActiveGet payload(_welcomeGuidanceActiveProperty.getWelcomeGuidanceActive());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("welcomeGuidanceActive", variant));
    }

    //property 'loginKeyLinkStatus'
    {
        ::asf::dbus::DBusVariant variant;
        LoginKeyLinkStatusGet payload(_loginKeyLinkStatusProperty.getLoginKeyLinkStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("loginKeyLinkStatus", variant));
    }

    //property 'IsStartupSequence'
    {
        ::asf::dbus::DBusVariant variant;
        IsStartupSequenceGet payload(_IsStartupSequenceProperty.getIsStartupSequence());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IsStartupSequence", variant));
    }
}

} // namespace profilePIVI
} // namespace cm
} // namespace bosch
