/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILEPIVIPROXY_H
#define BOSCH_CM_PROFILEPIVIPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profilePIVI.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

namespace bosch {
namespace cm {
namespace profilePIVI {

class ProfilePIVIProxy;

class GetKeylistCallbackIF {
public:
    virtual ~GetKeylistCallbackIF() {}

    virtual void onGetKeylistError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< GetKeylistError >& error) = 0;

    virtual void onGetKeylistResponse(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< GetKeylistResponse >& response) = 0;
};

class IsStartupSequenceCallbackIF {
public:
    virtual ~IsStartupSequenceCallbackIF() {}

    virtual void onIsStartupSequenceError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< IsStartupSequenceError >& error) = 0;

    virtual void onIsStartupSequenceUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< IsStartupSequenceUpdate >& update) = 0;
};

class KeyIDCallbackIF {
public:
    virtual ~KeyIDCallbackIF() {}

    virtual void onKeyIDError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< KeyIDError >& error) = 0;

    virtual void onKeyIDUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< KeyIDUpdate >& update) = 0;
};

class KeyIsMappedCallbackIF {
public:
    virtual ~KeyIsMappedCallbackIF() {}

    virtual void onKeyIsMappedError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< KeyIsMappedError >& error) = 0;

    virtual void onKeyIsMappedUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< KeyIsMappedUpdate >& update) = 0;
};

class KeyMappingPossibleCallbackIF {
public:
    virtual ~KeyMappingPossibleCallbackIF() {}

    virtual void onKeyMappingPossibleError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< KeyMappingPossibleError >& error) = 0;

    virtual void onKeyMappingPossibleUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< KeyMappingPossibleUpdate >& update) = 0;
};

class LoginKeyLinkStatusCallbackIF {
public:
    virtual ~LoginKeyLinkStatusCallbackIF() {}

    virtual void onLoginKeyLinkStatusError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< LoginKeyLinkStatusError >& error) = 0;

    virtual void onLoginKeyLinkStatusUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< LoginKeyLinkStatusUpdate >& update) = 0;
};

class MapKeyToCurrentProfileCallbackIF {
public:
    virtual ~MapKeyToCurrentProfileCallbackIF() {}

    virtual void onMapKeyToCurrentProfileError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< MapKeyToCurrentProfileError >& error) = 0;

    virtual void onMapKeyToCurrentProfileResponse(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< MapKeyToCurrentProfileResponse >& response) = 0;
};

class ProfilekeyIIndexCallbackIF {
public:
    virtual ~ProfilekeyIIndexCallbackIF() {}

    virtual void onProfilekeyIIndexError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< ProfilekeyIIndexError >& error) = 0;

    virtual void onProfilekeyIIndexUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< ProfilekeyIIndexUpdate >& update) = 0;
};

class SetLoginKeyLinkSettingCallbackIF {
public:
    virtual ~SetLoginKeyLinkSettingCallbackIF() {}

    virtual void onSetLoginKeyLinkSettingError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< SetLoginKeyLinkSettingError >& error) = 0;

    virtual void onSetLoginKeyLinkSettingResponse(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< SetLoginKeyLinkSettingResponse >& response) = 0;
};

class SetWelcomeGuidanceActiveCallbackIF {
public:
    virtual ~SetWelcomeGuidanceActiveCallbackIF() {}

    virtual void onSetWelcomeGuidanceActiveError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< SetWelcomeGuidanceActiveError >& error) = 0;

    virtual void onSetWelcomeGuidanceActiveResponse(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< SetWelcomeGuidanceActiveResponse >& response) = 0;
};

class WelcomeGuidanceActiveCallbackIF {
public:
    virtual ~WelcomeGuidanceActiveCallbackIF() {}

    virtual void onWelcomeGuidanceActiveError(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< WelcomeGuidanceActiveError >& error) = 0;

    virtual void onWelcomeGuidanceActiveUpdate(const ::boost::shared_ptr< ProfilePIVIProxy >& proxy, const ::boost::shared_ptr< WelcomeGuidanceActiveUpdate >& update) = 0;
};


/**
 * ProfilePIVIProxy is the client side representation of the D-Bus service
 * interface 'bosch.cm.profilePIVI' (specified in file Profile-PIVI_.xml).
 *
 * basic attributes for User Profile Management
 */
class ProfilePIVIProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ProfilePIVIProxy.
     */
    static ::boost::shared_ptr< ProfilePIVIProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ProfilePIVIProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ProfilePIVIProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ProfilePIVIProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ProfilePIVIProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ProfilePIVIProxy > proxyNew(new ProfilePIVIProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ProfilePIVIProxy ();



    // Property 'keyIsMapped'

    /**
     * Notify on the property 'keyIsMapped'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyIsMappedRegister(KeyIsMappedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'keyIsMapped'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param act The act which was previously returned by the
     * sendKeyIsMappedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKeyIsMappedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'keyIsMapped'.
     */
    void sendKeyIsMappedDeregisterAll() const;

    /**
     * Request the value of the property 'keyIsMapped' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'keyIsMapped'</b>:
     *
     * current user Profile. Updated only on user change.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyIsMappedGet(KeyIsMappedCallbackIF& cb);


    /**
     * Returns the current value of the property 'keyIsMapped' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasKeyIsMapped() returns true.
     *
     * @return the previously received value of the property 'keyIsMapped'.
     */
    bool getKeyIsMapped() const;

    /**
     * Determines whether a status message for the property 'keyIsMapped' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKeyIsMapped() const;

    // Property 'keyMappingPossible'

    /**
     * Notify on the property 'keyMappingPossible'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyMappingPossibleRegister(KeyMappingPossibleCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'keyMappingPossible'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendKeyMappingPossibleRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKeyMappingPossibleDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'keyMappingPossible'.
     */
    void sendKeyMappingPossibleDeregisterAll() const;

    /**
     * Request the value of the property 'keyMappingPossible' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'keyMappingPossible'</b>:
     *
     * If the meaning of "keyMappingPossible" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyMappingPossibleGet(KeyMappingPossibleCallbackIF& cb);


    /**
     * Returns the current value of the property 'keyMappingPossible' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasKeyMappingPossible() returns true.
     *
     * @return the previously received value of the property 'keyMappingPossible'.
     */
    bool getKeyMappingPossible() const;

    /**
     * Determines whether a status message for the property
     * 'keyMappingPossible' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKeyMappingPossible() const;

    // Property 'keyID'

    /**
     * Notify on the property 'keyID'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyIDRegister(KeyIDCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'keyID'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendKeyIDRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKeyIDDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'keyID'.
     */
    void sendKeyIDDeregisterAll() const;

    /**
     * Request the value of the property 'keyID' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'keyID'</b>:
     *
     * If the meaning of "keyID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKeyIDGet(KeyIDCallbackIF& cb);


    /**
     * Returns the current value of the property 'keyID' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasKeyID()
     * returns true.
     *
     * @return the previously received value of the property 'keyID'.
     */
    uint32 getKeyID() const;

    /**
     * Determines whether a status message for the property 'keyID' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKeyID() const;

    // Property 'ProfilekeyIIndex'

    /**
     * Notify on the property 'ProfilekeyIIndex'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProfilekeyIIndexRegister(ProfilekeyIIndexCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'ProfilekeyIIndex'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendProfilekeyIIndexRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendProfilekeyIIndexDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'ProfilekeyIIndex'.
     */
    void sendProfilekeyIIndexDeregisterAll() const;

    /**
     * Request the value of the property 'ProfilekeyIIndex' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'ProfilekeyIIndex'</b>:
     *
     * If the meaning of "ProfilekeyIIndex" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProfilekeyIIndexGet(ProfilekeyIIndexCallbackIF& cb);


    /**
     * Returns the current value of the property 'ProfilekeyIIndex' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasProfilekeyIIndex() returns true.
     *
     * @return the previously received value of the property 'ProfilekeyIIndex'.
     */
    uint8 getProfilekeyIIndex() const;

    /**
     * Determines whether a status message for the property 'ProfilekeyIIndex'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProfilekeyIIndex() const;

    // Property 'welcomeGuidanceActive'

    /**
     * Notify on the property 'welcomeGuidanceActive'. This method registers
     * for property changes by D-Bus service.
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWelcomeGuidanceActiveRegister(WelcomeGuidanceActiveCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'welcomeGuidanceActive'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendWelcomeGuidanceActiveRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendWelcomeGuidanceActiveDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'welcomeGuidanceActive'.
     */
    void sendWelcomeGuidanceActiveDeregisterAll() const;

    /**
     * Request the value of the property 'welcomeGuidanceActive' from the
     * D-Bus server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'welcomeGuidanceActive'</b>:
     *
     * If the meaning of "welcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWelcomeGuidanceActiveGet(WelcomeGuidanceActiveCallbackIF& cb);


    /**
     * Returns the current value of the property 'welcomeGuidanceActive' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasWelcomeGuidanceActive() returns true.
     *
     * @return the previously received value of the property 'welcomeGuidanceActive'.
     */
    bool getWelcomeGuidanceActive() const;

    /**
     * Determines whether a status message for the property
     * 'welcomeGuidanceActive' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasWelcomeGuidanceActive() const;

    // Property 'loginKeyLinkStatus'

    /**
     * Notify on the property 'loginKeyLinkStatus'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoginKeyLinkStatusRegister(LoginKeyLinkStatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'loginKeyLinkStatus'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLoginKeyLinkStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLoginKeyLinkStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'loginKeyLinkStatus'.
     */
    void sendLoginKeyLinkStatusDeregisterAll() const;

    /**
     * Request the value of the property 'loginKeyLinkStatus' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'loginKeyLinkStatus'</b>:
     *
     * If the meaning of "loginKeyLinkStatus" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLoginKeyLinkStatusGet(LoginKeyLinkStatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'loginKeyLinkStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasLoginKeyLinkStatus() returns true.
     *
     * @return the previously received value of the property 'loginKeyLinkStatus'.
     */
    bool getLoginKeyLinkStatus() const;

    /**
     * Determines whether a status message for the property
     * 'loginKeyLinkStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasLoginKeyLinkStatus() const;

    // Property 'IsStartupSequence'

    /**
     * Notify on the property 'IsStartupSequence'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIsStartupSequenceRegister(IsStartupSequenceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'IsStartupSequence'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIsStartupSequenceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIsStartupSequenceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'IsStartupSequence'.
     */
    void sendIsStartupSequenceDeregisterAll() const;

    /**
     * Request the value of the property 'IsStartupSequence' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'IsStartupSequence'</b>:
     *
     * If the meaning of "IsStartupSequence" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIsStartupSequenceGet(IsStartupSequenceCallbackIF& cb);


    /**
     * Returns the current value of the property 'IsStartupSequence' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasIsStartupSequence() returns true.
     *
     * @return the previously received value of the property 'IsStartupSequence'.
     */
    bool getIsStartupSequence() const;

    /**
     * Determines whether a status message for the property
     * 'IsStartupSequence' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIsStartupSequence() const;


    // Method 'mapKeyToCurrentProfile'

    /**
     * Call the method 'mapKeyToCurrentProfile'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'mapKeyToCurrentProfile'</b>:
     *
     * map the current KeyID to the active Profile
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMapKeyToCurrentProfileRequest(MapKeyToCurrentProfileCallbackIF& cb) const;

    // Method 'SetWelcomeGuidanceActive'

    /**
     * Call the method 'SetWelcomeGuidanceActive'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'SetWelcomeGuidanceActive'</b>:
     *
     * If the meaning of "SetWelcomeGuidanceActive" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @param wgActive If the meaning of "wgActive" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetWelcomeGuidanceActiveRequest(SetWelcomeGuidanceActiveCallbackIF& cb, uint8 userID, bool wgActive) const;

    // Method 'setLoginKeyLinkSetting'

    /**
     * Call the method 'setLoginKeyLinkSetting'. This method sends a message
     * to the D-Bus server.
     *
     * <b>Documentation of 'setLoginKeyLinkSetting'</b>:
     *
     * If the meaning of "setLoginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param loginKeyLinkSetting If the meaning of "loginKeyLinkSetting" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetLoginKeyLinkSettingRequest(SetLoginKeyLinkSettingCallbackIF& cb, bool loginKeyLinkSetting) const;

    // Method 'getKeylist'

    /**
     * Call the method 'getKeylist'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'getKeylist'</b>:
     *
     * If the meaning of "getKeylist" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetKeylistRequest(GetKeylistCallbackIF& cb, uint8 userID) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ProfilePIVIProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'keyIsMapped'

    ::asf::core::nullable< KeyIsMappedUpdate > _keyIsMapped;

    // Property 'keyMappingPossible'

    ::asf::core::nullable< KeyMappingPossibleUpdate > _keyMappingPossible;

    // Property 'keyID'

    ::asf::core::nullable< KeyIDUpdate > _keyID;

    // Property 'ProfilekeyIIndex'

    ::asf::core::nullable< ProfilekeyIIndexUpdate > _profilekeyIIndex;

    // Property 'welcomeGuidanceActive'

    ::asf::core::nullable< WelcomeGuidanceActiveUpdate > _welcomeGuidanceActive;

    // Property 'loginKeyLinkStatus'

    ::asf::core::nullable< LoginKeyLinkStatusUpdate > _loginKeyLinkStatus;

    // Property 'IsStartupSequence'

    ::asf::core::nullable< IsStartupSequenceUpdate > _isStartupSequence;

    DECLARE_CLASS_LOGGER();

    friend class ProfilePIVIProxyCallback;
};

} // namespace profilePIVI
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILEPIVIPROXY_H
