/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profilePIVI.h"
#include "bosch/cm/profilePIVIDBus.h"
#include "bosch/cm/profilePIVIJson.h"
#include "bosch/cm/profilePIVIProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace profilePIVI {

DEFINE_CLASS_LOGGER("/bosch/cm/bosch/cm/profilePIVI", ProfilePIVIProxy);

class ProfilePIVIProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ProfilePIVIProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ProfilePIVIProxy >& proxyShared = ::boost::static_pointer_cast< ProfilePIVIProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_keyIsMapped:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyIsMappedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyIsMapped", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KeyIsMappedError> payload = ::boost::static_pointer_cast<KeyIsMappedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KeyIsMappedCallbackIF*) _callback)->onKeyIsMappedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyIsMappedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyIsMapped", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KeyIsMappedUpdate> payload = ::boost::static_pointer_cast<KeyIsMappedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KeyIsMappedCallbackIF*) _callback)->onKeyIsMappedUpdate(proxyShared, payload);
                        proxyShared->_keyIsMapped = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_keyMappingPossible:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyMappingPossibleError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyMappingPossible", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KeyMappingPossibleError> payload = ::boost::static_pointer_cast<KeyMappingPossibleError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KeyMappingPossibleCallbackIF*) _callback)->onKeyMappingPossibleError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyMappingPossibleUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyMappingPossible", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KeyMappingPossibleUpdate> payload = ::boost::static_pointer_cast<KeyMappingPossibleUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KeyMappingPossibleCallbackIF*) _callback)->onKeyMappingPossibleUpdate(proxyShared, payload);
                        proxyShared->_keyMappingPossible = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_keyID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KeyIDError> payload = ::boost::static_pointer_cast<KeyIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KeyIDCallbackIF*) _callback)->onKeyIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KeyIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KeyID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KeyIDUpdate> payload = ::boost::static_pointer_cast<KeyIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KeyIDCallbackIF*) _callback)->onKeyIDUpdate(proxyShared, payload);
                        proxyShared->_keyID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ProfilekeyIIndex:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfilekeyIIndexError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfilekeyIIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProfilekeyIIndexError> payload = ::boost::static_pointer_cast<ProfilekeyIIndexError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProfilekeyIIndexCallbackIF*) _callback)->onProfilekeyIIndexError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfilekeyIIndexUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfilekeyIIndex", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProfilekeyIIndexUpdate> payload = ::boost::static_pointer_cast<ProfilekeyIIndexUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProfilekeyIIndexCallbackIF*) _callback)->onProfilekeyIIndexUpdate(proxyShared, payload);
                        proxyShared->_profilekeyIIndex = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_welcomeGuidanceActive:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WelcomeGuidanceActiveError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WelcomeGuidanceActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WelcomeGuidanceActiveError> payload = ::boost::static_pointer_cast<WelcomeGuidanceActiveError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WelcomeGuidanceActiveCallbackIF*) _callback)->onWelcomeGuidanceActiveError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WelcomeGuidanceActiveUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WelcomeGuidanceActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WelcomeGuidanceActiveUpdate> payload = ::boost::static_pointer_cast<WelcomeGuidanceActiveUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WelcomeGuidanceActiveCallbackIF*) _callback)->onWelcomeGuidanceActiveUpdate(proxyShared, payload);
                        proxyShared->_welcomeGuidanceActive = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_loginKeyLinkStatus:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoginKeyLinkStatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoginKeyLinkStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoginKeyLinkStatusError> payload = ::boost::static_pointer_cast<LoginKeyLinkStatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((LoginKeyLinkStatusCallbackIF*) _callback)->onLoginKeyLinkStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LoginKeyLinkStatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LoginKeyLinkStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<LoginKeyLinkStatusUpdate> payload = ::boost::static_pointer_cast<LoginKeyLinkStatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((LoginKeyLinkStatusCallbackIF*) _callback)->onLoginKeyLinkStatusUpdate(proxyShared, payload);
                        proxyShared->_loginKeyLinkStatus = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_IsStartupSequence:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsStartupSequenceError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsStartupSequence", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsStartupSequenceError> payload = ::boost::static_pointer_cast<IsStartupSequenceError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IsStartupSequenceCallbackIF*) _callback)->onIsStartupSequenceError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IsStartupSequenceUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IsStartupSequence", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IsStartupSequenceUpdate> payload = ::boost::static_pointer_cast<IsStartupSequenceUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IsStartupSequenceCallbackIF*) _callback)->onIsStartupSequenceUpdate(proxyShared, payload);
                        proxyShared->_isStartupSequence = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_mapKeyToCurrentProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MapKeyToCurrentProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MapKeyToCurrentProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapKeyToCurrentProfileError> payload = ::boost::static_pointer_cast<MapKeyToCurrentProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MapKeyToCurrentProfileCallbackIF*) _callback)->onMapKeyToCurrentProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapKeyToCurrentProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MapKeyToCurrentProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MapKeyToCurrentProfileResponse> payload = ::boost::static_pointer_cast<MapKeyToCurrentProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MapKeyToCurrentProfileCallbackIF*) _callback)->onMapKeyToCurrentProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetWelcomeGuidanceActive:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetWelcomeGuidanceActiveError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetWelcomeGuidanceActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetWelcomeGuidanceActiveError> payload = ::boost::static_pointer_cast<SetWelcomeGuidanceActiveError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetWelcomeGuidanceActiveCallbackIF*) _callback)->onSetWelcomeGuidanceActiveError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetWelcomeGuidanceActiveResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetWelcomeGuidanceActive", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetWelcomeGuidanceActiveResponse> payload = ::boost::static_pointer_cast<SetWelcomeGuidanceActiveResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetWelcomeGuidanceActiveCallbackIF*) _callback)->onSetWelcomeGuidanceActiveResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_setLoginKeyLinkSetting:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetLoginKeyLinkSettingError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLoginKeyLinkSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLoginKeyLinkSettingError> payload = ::boost::static_pointer_cast<SetLoginKeyLinkSettingError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLoginKeyLinkSettingCallbackIF*) _callback)->onSetLoginKeyLinkSettingError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetLoginKeyLinkSettingResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetLoginKeyLinkSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetLoginKeyLinkSettingResponse> payload = ::boost::static_pointer_cast<SetLoginKeyLinkSettingResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetLoginKeyLinkSettingCallbackIF*) _callback)->onSetLoginKeyLinkSettingResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getKeylist:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetKeylistError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetKeylist", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetKeylistError> payload = ::boost::static_pointer_cast<GetKeylistError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetKeylistCallbackIF*) _callback)->onGetKeylistError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetKeylistResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetKeylist", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetKeylistResponse> payload = ::boost::static_pointer_cast<GetKeylistResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetKeylistCallbackIF*) _callback)->onGetKeylistResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_keyIsMapped: {
                ::boost::shared_ptr< KeyIsMappedError > payload = ::boost::shared_ptr< KeyIsMappedError >
                (new KeyIsMappedError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KeyIsMapped", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KeyIsMappedCallbackIF*) _callback)->onKeyIsMappedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_keyMappingPossible: {
                ::boost::shared_ptr< KeyMappingPossibleError > payload = ::boost::shared_ptr< KeyMappingPossibleError >
                (new KeyMappingPossibleError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KeyMappingPossible", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KeyMappingPossibleCallbackIF*) _callback)->onKeyMappingPossibleError (proxyShared,payload);
                return true;
            }
            break;
            case ID_keyID: {
                ::boost::shared_ptr< KeyIDError > payload = ::boost::shared_ptr< KeyIDError >
                (new KeyIDError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KeyID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KeyIDCallbackIF*) _callback)->onKeyIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProfilekeyIIndex: {
                ::boost::shared_ptr< ProfilekeyIIndexError > payload = ::boost::shared_ptr< ProfilekeyIIndexError >
                (new ProfilekeyIIndexError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfilekeyIIndex", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfilekeyIIndexCallbackIF*) _callback)->onProfilekeyIIndexError (proxyShared,payload);
                return true;
            }
            break;
            case ID_welcomeGuidanceActive: {
                ::boost::shared_ptr< WelcomeGuidanceActiveError > payload = ::boost::shared_ptr< WelcomeGuidanceActiveError >
                (new WelcomeGuidanceActiveError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WelcomeGuidanceActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WelcomeGuidanceActiveCallbackIF*) _callback)->onWelcomeGuidanceActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_loginKeyLinkStatus: {
                ::boost::shared_ptr< LoginKeyLinkStatusError > payload = ::boost::shared_ptr< LoginKeyLinkStatusError >
                (new LoginKeyLinkStatusError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LoginKeyLinkStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LoginKeyLinkStatusCallbackIF*) _callback)->onLoginKeyLinkStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_IsStartupSequence: {
                ::boost::shared_ptr< IsStartupSequenceError > payload = ::boost::shared_ptr< IsStartupSequenceError >
                (new IsStartupSequenceError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IsStartupSequence", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IsStartupSequenceCallbackIF*) _callback)->onIsStartupSequenceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_mapKeyToCurrentProfile: {
                ::boost::shared_ptr< MapKeyToCurrentProfileError > payload = ::boost::shared_ptr< MapKeyToCurrentProfileError >
                (new MapKeyToCurrentProfileError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapKeyToCurrentProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapKeyToCurrentProfileCallbackIF*) _callback)->onMapKeyToCurrentProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetWelcomeGuidanceActive: {
                ::boost::shared_ptr< SetWelcomeGuidanceActiveError > payload = ::boost::shared_ptr< SetWelcomeGuidanceActiveError >
                (new SetWelcomeGuidanceActiveError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetWelcomeGuidanceActive", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetWelcomeGuidanceActiveCallbackIF*) _callback)->onSetWelcomeGuidanceActiveError (proxyShared,payload);
                return true;
            }
            break;
            case ID_setLoginKeyLinkSetting: {
                ::boost::shared_ptr< SetLoginKeyLinkSettingError > payload = ::boost::shared_ptr< SetLoginKeyLinkSettingError >
                (new SetLoginKeyLinkSettingError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetLoginKeyLinkSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetLoginKeyLinkSettingCallbackIF*) _callback)->onSetLoginKeyLinkSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getKeylist: {
                ::boost::shared_ptr< GetKeylistError > payload = ::boost::shared_ptr< GetKeylistError >
                (new GetKeylistError(DBUS_ERROR_NO_SERVER, "The DBus service ProfilePIVI is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetKeylist", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfilePIVIProxy> proxyShared = ::boost::static_pointer_cast<ProfilePIVIProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetKeylistCallbackIF*) _callback)->onGetKeylistError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ProfilePIVIProxyCallback::_logger (ProfilePIVIProxy::_logger);

ProfilePIVIProxy::ProfilePIVIProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.profilePIVI", serviceAvailable, _logger) {
}

ProfilePIVIProxy::~ProfilePIVIProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ProfilePIVIProxy > ProfilePIVIProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ProfilePIVIProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ProfilePIVIProxy > proxyNew(new ProfilePIVIProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ProfilePIVIProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ProfilePIVIProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfilePIVIProxy::clearAllProperties ()
{
    _keyIsMapped = ::asf::core::nullable< KeyIsMappedUpdate >();
    _keyMappingPossible = ::asf::core::nullable< KeyMappingPossibleUpdate >();
    _keyID = ::asf::core::nullable< KeyIDUpdate >();
    _profilekeyIIndex = ::asf::core::nullable< ProfilekeyIIndexUpdate >();
    _welcomeGuidanceActive = ::asf::core::nullable< WelcomeGuidanceActiveUpdate >();
    _loginKeyLinkStatus = ::asf::core::nullable< LoginKeyLinkStatusUpdate >();
    _isStartupSequence = ::asf::core::nullable< IsStartupSequenceUpdate >();
}

void ProfilePIVIProxy::sendDeregisterAll () const
{
    sendKeyIsMappedDeregisterAll();
    sendKeyMappingPossibleDeregisterAll();
    sendKeyIDDeregisterAll();
    sendProfilekeyIIndexDeregisterAll();
    sendWelcomeGuidanceActiveDeregisterAll();
    sendLoginKeyLinkStatusDeregisterAll();
    sendIsStartupSequenceDeregisterAll();
}

act_t ProfilePIVIProxy::sendKeyIsMappedRegister(KeyIsMappedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_keyIsMapped, "keyIsMapped", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KeyIsMapped", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendKeyIsMappedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("keyIsMapped", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KeyIsMapped", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendKeyIsMappedGet(KeyIsMappedCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_keyIsMapped, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KeyIsMapped", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("keyIsMapped", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ProfilePIVIProxy::getKeyIsMapped() const {
    return _keyIsMapped.get().getKeyIsMapped();
}

bool ProfilePIVIProxy::hasKeyIsMapped() const {
    return _keyIsMapped.hasValue();
}

void ProfilePIVIProxy::sendKeyIsMappedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KeyIsMapped");
    _dbusProxyDelegate->deregisterSignalCallback("keyIsMapped", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendKeyMappingPossibleRegister(KeyMappingPossibleCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_keyMappingPossible, "keyMappingPossible", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KeyMappingPossible", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendKeyMappingPossibleDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("keyMappingPossible", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KeyMappingPossible", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendKeyMappingPossibleGet(KeyMappingPossibleCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_keyMappingPossible, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KeyMappingPossible", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("keyMappingPossible", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ProfilePIVIProxy::getKeyMappingPossible() const {
    return _keyMappingPossible.get().getKeyMappingPossible();
}

bool ProfilePIVIProxy::hasKeyMappingPossible() const {
    return _keyMappingPossible.hasValue();
}

void ProfilePIVIProxy::sendKeyMappingPossibleDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KeyMappingPossible");
    _dbusProxyDelegate->deregisterSignalCallback("keyMappingPossible", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendKeyIDRegister(KeyIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_keyID, "keyID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KeyID", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendKeyIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("keyID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KeyID", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendKeyIDGet(KeyIDCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_keyID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KeyID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("keyID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 ProfilePIVIProxy::getKeyID() const {
    return _keyID.get().getKeyID();
}

bool ProfilePIVIProxy::hasKeyID() const {
    return _keyID.hasValue();
}

void ProfilePIVIProxy::sendKeyIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KeyID");
    _dbusProxyDelegate->deregisterSignalCallback("keyID", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendProfilekeyIIndexRegister(ProfilekeyIIndexCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ProfilekeyIIndex, "ProfilekeyIIndex", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfilekeyIIndex", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendProfilekeyIIndexDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ProfilekeyIIndex", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfilekeyIIndex", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendProfilekeyIIndexGet(ProfilekeyIIndexCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_ProfilekeyIIndex, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ProfilekeyIIndex", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ProfilekeyIIndex", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 ProfilePIVIProxy::getProfilekeyIIndex() const {
    return _profilekeyIIndex.get().getProfilekeyIIndex();
}

bool ProfilePIVIProxy::hasProfilekeyIIndex() const {
    return _profilekeyIIndex.hasValue();
}

void ProfilePIVIProxy::sendProfilekeyIIndexDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfilekeyIIndex");
    _dbusProxyDelegate->deregisterSignalCallback("ProfilekeyIIndex", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendWelcomeGuidanceActiveRegister(WelcomeGuidanceActiveCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_welcomeGuidanceActive, "welcomeGuidanceActive", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WelcomeGuidanceActive", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendWelcomeGuidanceActiveDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("welcomeGuidanceActive", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WelcomeGuidanceActive", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendWelcomeGuidanceActiveGet(WelcomeGuidanceActiveCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_welcomeGuidanceActive, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WelcomeGuidanceActive", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("welcomeGuidanceActive", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ProfilePIVIProxy::getWelcomeGuidanceActive() const {
    return _welcomeGuidanceActive.get().getWelcomeGuidanceActive();
}

bool ProfilePIVIProxy::hasWelcomeGuidanceActive() const {
    return _welcomeGuidanceActive.hasValue();
}

void ProfilePIVIProxy::sendWelcomeGuidanceActiveDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WelcomeGuidanceActive");
    _dbusProxyDelegate->deregisterSignalCallback("welcomeGuidanceActive", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendLoginKeyLinkStatusRegister(LoginKeyLinkStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_loginKeyLinkStatus, "loginKeyLinkStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LoginKeyLinkStatus", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendLoginKeyLinkStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("loginKeyLinkStatus", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LoginKeyLinkStatus", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendLoginKeyLinkStatusGet(LoginKeyLinkStatusCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_loginKeyLinkStatus, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "LoginKeyLinkStatus", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("loginKeyLinkStatus", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ProfilePIVIProxy::getLoginKeyLinkStatus() const {
    return _loginKeyLinkStatus.get().getLoginKeyLinkStatus();
}

bool ProfilePIVIProxy::hasLoginKeyLinkStatus() const {
    return _loginKeyLinkStatus.hasValue();
}

void ProfilePIVIProxy::sendLoginKeyLinkStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LoginKeyLinkStatus");
    _dbusProxyDelegate->deregisterSignalCallback("loginKeyLinkStatus", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendIsStartupSequenceRegister(IsStartupSequenceCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IsStartupSequence, "IsStartupSequence", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IsStartupSequence", &cb, act);
    return act;
}

bool ProfilePIVIProxy::sendIsStartupSequenceDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IsStartupSequence", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IsStartupSequence", act, static_cast<int>(rv));
    return rv;
}

act_t ProfilePIVIProxy::sendIsStartupSequenceGet(IsStartupSequenceCallbackIF& cb) {
    ProfilePIVIProxyCallback* callback = new ProfilePIVIProxyCallback(ID_IsStartupSequence, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IsStartupSequence", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IsStartupSequence", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ProfilePIVIProxy::getIsStartupSequence() const {
    return _isStartupSequence.get().getIsStartupSequence();
}

bool ProfilePIVIProxy::hasIsStartupSequence() const {
    return _isStartupSequence.hasValue();
}

void ProfilePIVIProxy::sendIsStartupSequenceDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IsStartupSequence");
    _dbusProxyDelegate->deregisterSignalCallback("IsStartupSequence", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfilePIVIProxy::sendMapKeyToCurrentProfileRequest(MapKeyToCurrentProfileCallbackIF& cb) const {
    MapKeyToCurrentProfileRequest* payload = new MapKeyToCurrentProfileRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "mapKeyToCurrentProfile", MapKeyToCurrentProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_mapKeyToCurrentProfile, dbusMessage.getUniqueSerial(), "mapKeyToCurrentProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MapKeyToCurrentProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfilePIVIProxy::sendSetWelcomeGuidanceActiveRequest(SetWelcomeGuidanceActiveCallbackIF& cb, uint8 userID, bool wgActive) const {
    SetWelcomeGuidanceActiveRequest* payload = new SetWelcomeGuidanceActiveRequest();
    CHECK_ALLOCATION(payload);
    payload->setUserID(userID);
    payload->setWgActive(wgActive);
    DBUS_MESSAGE_CALL(dbusMessage, "SetWelcomeGuidanceActive", SetWelcomeGuidanceActiveRequest, payload, true)
    act_t act = addMethodCallback(ID_SetWelcomeGuidanceActive, dbusMessage.getUniqueSerial(), "SetWelcomeGuidanceActive", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetWelcomeGuidanceActive", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfilePIVIProxy::sendSetLoginKeyLinkSettingRequest(SetLoginKeyLinkSettingCallbackIF& cb, bool loginKeyLinkSetting) const {
    SetLoginKeyLinkSettingRequest* payload = new SetLoginKeyLinkSettingRequest();
    CHECK_ALLOCATION(payload);
    payload->setLoginKeyLinkSetting(loginKeyLinkSetting);
    DBUS_MESSAGE_CALL(dbusMessage, "setLoginKeyLinkSetting", SetLoginKeyLinkSettingRequest, payload, true)
    act_t act = addMethodCallback(ID_setLoginKeyLinkSetting, dbusMessage.getUniqueSerial(), "setLoginKeyLinkSetting", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetLoginKeyLinkSetting", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfilePIVIProxy::sendGetKeylistRequest(GetKeylistCallbackIF& cb, uint8 userID) const {
    GetKeylistRequest* payload = new GetKeylistRequest();
    CHECK_ALLOCATION(payload);
    payload->setUserID(userID);
    DBUS_MESSAGE_CALL(dbusMessage, "getKeylist", GetKeylistRequest, payload, true)
    act_t act = addMethodCallback(ID_getKeylist, dbusMessage.getUniqueSerial(), "getKeylist", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetKeylist", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace profilePIVI
} // namespace cm
} // namespace bosch
