/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/json.h"
#include "bosch/cm/profile.h"
#include "bosch/cm/profileConst.h"
#include "bosch/cm/profileJson.h"
#include "bosch/cm/profileJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

using namespace ::asf::stream::json;


// Json serialization of "copyInfo"

void serializeJson (const ::bosch::cm::profile::copyInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSource()) {
        yajl_gen_string(g, (const unsigned char*)  "source" , 6);
        yajl_gen_integer(g, (long long)value.getSource());
    }
    if (!isSparse || value.hasDestination()) {
        yajl_gen_string(g, (const unsigned char*)  "destination" , 11);
        yajl_gen_integer(g, (long long)value.getDestination());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::copyInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoRegisterAppRequest"

void serializeJson (const ::bosch::cm::profile::DoRegisterAppRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAppName()) {
        yajl_gen_string(g, (const unsigned char*)  "AppName" , 7);
        const char *s = value.getAppName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoRegisterAppRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoRegisterAppResponse"

void serializeJson (const ::bosch::cm::profile::DoRegisterAppResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasAppID()) {
        yajl_gen_string(g, (const unsigned char*)  "AppID" , 5);
        yajl_gen_integer(g, (long long)value.getAppID());
    }
    if (!isSparse || value.hasApplName()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplName" , 8);
        const char *s = value.getApplName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasReloadData()) {
        yajl_gen_string(g, (const unsigned char*)  "reloadData" , 10);
        yajl_gen_bool(g, (bool)value.getReloadData());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoRegisterAppResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnDataChangedRequest"

void serializeJson (const ::bosch::cm::profile::OnDataChangedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasApplicationPID()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplicationPID" , 14);
        yajl_gen_integer(g, (long long)value.getApplicationPID());
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::dataChangedResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::OnDataChangedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnProfileDeletedRequest"

void serializeJson (const ::bosch::cm::profile::OnProfileDeletedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasApplicationPID()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplicationPID" , 14);
        yajl_gen_integer(g, (long long)value.getApplicationPID());
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::clientResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::OnProfileDeletedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnProfileCopiedRequest"

void serializeJson (const ::bosch::cm::profile::OnProfileCopiedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasApplicationPID()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplicationPID" , 14);
        yajl_gen_integer(g, (long long)value.getApplicationPID());
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::clientResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::OnProfileCopiedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "OnProfileCreatedRequest"

void serializeJson (const ::bosch::cm::profile::OnProfileCreatedRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasApplicationPID()) {
        yajl_gen_string(g, (const unsigned char*)  "ApplicationPID" , 14);
        yajl_gen_integer(g, (long long)value.getApplicationPID());
    }
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::clientResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::OnProfileCreatedRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoCopyProfileRequest"

void serializeJson (const ::bosch::cm::profile::DoCopyProfileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourceUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "sourceUserID" , 12);
        yajl_gen_integer(g, (long long)value.getSourceUserID());
    }
    if (!isSparse || value.hasDestUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "destUserID" , 10);
        yajl_gen_integer(g, (long long)value.getDestUserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoCopyProfileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoCopyProfileResponse"

void serializeJson (const ::bosch::cm::profile::DoCopyProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoCopyProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoDeleteProfileRequest"

void serializeJson (const ::bosch::cm::profile::DoDeleteProfileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "userID" , 6);
        yajl_gen_integer(g, (long long)value.getUserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoDeleteProfileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoDeleteProfileResponse"

void serializeJson (const ::bosch::cm::profile::DoDeleteProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoDeleteProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoChangeToProfileRequest"

void serializeJson (const ::bosch::cm::profile::DoChangeToProfileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "userID" , 6);
        yajl_gen_integer(g, (long long)value.getUserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoChangeToProfileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoChangeToProfileResponse"

void serializeJson (const ::bosch::cm::profile::DoChangeToProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoChangeToProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoCreateProfileRequest"

void serializeJson (const ::bosch::cm::profile::DoCreateProfileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNewName()) {
        yajl_gen_string(g, (const unsigned char*)  "newName" , 7);
        const char *s = value.getNewName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasImageID()) {
        yajl_gen_string(g, (const unsigned char*)  "imageID" , 7);
        yajl_gen_integer(g, (long long)value.getImageID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoCreateProfileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoCreateProfileResponse"

void serializeJson (const ::bosch::cm::profile::DoCreateProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    if (!isSparse || value.hasNewUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "newUserID" , 9);
        yajl_gen_integer(g, (long long)value.getNewUserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoCreateProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Do_SetProfileNameRequest"

void serializeJson (const ::bosch::cm::profile::Do_SetProfileNameRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNewName()) {
        yajl_gen_string(g, (const unsigned char*)  "newName" , 7);
        const char *s = value.getNewName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "userID" , 6);
        yajl_gen_integer(g, (long long)value.getUserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::Do_SetProfileNameRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "Do_SetProfileNameResponse"

void serializeJson (const ::bosch::cm::profile::Do_SetProfileNameResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "Result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::Do_SetProfileNameResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProfileNamesResponse"

void serializeJson (const ::bosch::cm::profile::GetProfileNamesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNames()) {
        yajl_gen_string(g, (const unsigned char*)  "names" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::std::string >& o1 = value.getNames();
        {
            ::std::vector< ::std::string >::const_iterator o0;
            for (o0 = o1.begin(); o0 != o1.end(); ++o0) {
                const char *s = (*o0).c_str();
                genStringAndCheck(g, (const unsigned char*) s , strlen(s));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::GetProfileNamesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoImportProfileImageRequest"

void serializeJson (const ::bosch::cm::profile::DoImportProfileImageRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSourcePath()) {
        yajl_gen_string(g, (const unsigned char*)  "sourcePath" , 10);
        const char *s = value.getSourcePath().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasWidth()) {
        yajl_gen_string(g, (const unsigned char*)  "width" , 5);
        yajl_gen_integer(g, (long long)value.getWidth());
    }
    if (!isSparse || value.hasHeight()) {
        yajl_gen_string(g, (const unsigned char*)  "height" , 6);
        yajl_gen_integer(g, (long long)value.getHeight());
    }
    if (!isSparse || value.hasSlotIdx()) {
        yajl_gen_string(g, (const unsigned char*)  "slotIdx" , 7);
        yajl_gen_integer(g, (long long)value.getSlotIdx());
    }
    if (!isSparse || value.hasBSetForCurrentProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "bSetForCurrentProfile" , 21);
        yajl_gen_bool(g, (bool)value.getBSetForCurrentProfile());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoImportProfileImageRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoImportProfileImageResponse"

void serializeJson (const ::bosch::cm::profile::DoImportProfileImageResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoImportProfileImageResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoveUserImageRequest"

void serializeJson (const ::bosch::cm::profile::RemoveUserImageRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasSlotIdx()) {
        yajl_gen_string(g, (const unsigned char*)  "slotIdx" , 7);
        yajl_gen_integer(g, (long long)value.getSlotIdx());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::RemoveUserImageRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "RemoveUserImageResponse"

void serializeJson (const ::bosch::cm::profile::RemoveUserImageResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::RemoveUserImageResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoSetProfileImageRequest"

void serializeJson (const ::bosch::cm::profile::DoSetProfileImageRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasImageID()) {
        yajl_gen_string(g, (const unsigned char*)  "imageID" , 7);
        yajl_gen_integer(g, (long long)value.getImageID());
    }
    if (!isSparse || value.hasUserID()) {
        yajl_gen_string(g, (const unsigned char*)  "userID" , 6);
        yajl_gen_integer(g, (long long)value.getUserID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoSetProfileImageRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DoSetProfileImageResponse"

void serializeJson (const ::bosch::cm::profile::DoSetProfileImageResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DoSetProfileImageResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProfileImagesResponse"

void serializeJson (const ::bosch::cm::profile::GetProfileImagesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasImages()) {
        yajl_gen_string(g, (const unsigned char*)  "images" , 6);
        yajl_gen_array_open(g);
        const ::std::vector< uint8 >& o3 = value.getImages();
        {
            ::std::vector< uint8 >::const_iterator o2;
            for (o2 = o3.begin(); o2 != o3.end(); ++o2) {
                yajl_gen_integer(g, (long long)(*o2));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::GetProfileImagesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "GetProfileTypesResponse"

void serializeJson (const ::bosch::cm::profile::GetProfileTypesResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTypes()) {
        yajl_gen_string(g, (const unsigned char*)  "types" , 5);
        yajl_gen_array_open(g);
        const ::std::vector< ::bosch::cm::profile::profileType >& o5 = value.getTypes();
        {
            ::std::vector< ::bosch::cm::profile::profileType >::const_iterator o4;
            for (o4 = o5.begin(); o4 != o5.end(); ++o4) {
                const char* s = ::bosch::cm::profile::profileType_Name((*o4));
                if (s != NULL)
                    yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
                else
                    yajl_gen_integer(g, (long long)(*o4));
            }
        }
        yajl_gen_array_close(g);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::GetProfileTypesResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProfilePinRequest"

void serializeJson (const ::bosch::cm::profile::SetProfilePinRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProfileID()) {
        yajl_gen_string(g, (const unsigned char*)  "profileID" , 9);
        yajl_gen_integer(g, (long long)value.getProfileID());
    }
    if (!isSparse || value.hasPin()) {
        yajl_gen_string(g, (const unsigned char*)  "Pin" , 3);
        const char *s = value.getPin().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::SetProfilePinRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetProfilePinResponse"

void serializeJson (const ::bosch::cm::profile::SetProfilePinResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::SetProfilePinResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRememberMeRequest"

void serializeJson (const ::bosch::cm::profile::SetRememberMeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProfileID()) {
        yajl_gen_string(g, (const unsigned char*)  "profileID" , 9);
        yajl_gen_integer(g, (long long)value.getProfileID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::SetRememberMeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetRememberMeResponse"

void serializeJson (const ::bosch::cm::profile::SetRememberMeResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::SetRememberMeResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CheckPinRequest"

void serializeJson (const ::bosch::cm::profile::CheckPinRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProfileID()) {
        yajl_gen_string(g, (const unsigned char*)  "profileID" , 9);
        yajl_gen_integer(g, (long long)value.getProfileID());
    }
    if (!isSparse || value.hasPIN()) {
        yajl_gen_string(g, (const unsigned char*)  "PIN" , 3);
        const char *s = value.getPIN().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::CheckPinRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CheckPinResponse"

void serializeJson (const ::bosch::cm::profile::CheckPinResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::CheckPinResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnProtectProfileRequest"

void serializeJson (const ::bosch::cm::profile::UnProtectProfileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProfileID()) {
        yajl_gen_string(g, (const unsigned char*)  "profileID" , 9);
        yajl_gen_integer(g, (long long)value.getProfileID());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::UnProtectProfileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "UnProtectProfileResponse"

void serializeJson (const ::bosch::cm::profile::UnProtectProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::UnProtectProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LinkProfileRequest"

void serializeJson (const ::bosch::cm::profile::LinkProfileRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBSetLink()) {
        yajl_gen_string(g, (const unsigned char*)  "bSetLink" , 8);
        yajl_gen_bool(g, (bool)value.getBSetLink());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::LinkProfileRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "LinkProfileResponse"

void serializeJson (const ::bosch::cm::profile::LinkProfileResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::LinkProfileResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetValetModeRequest"

void serializeJson (const ::bosch::cm::profile::SetValetModeRequest& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBEnableValetMode()) {
        yajl_gen_string(g, (const unsigned char*)  "bEnableValetMode" , 16);
        yajl_gen_bool(g, (bool)value.getBEnableValetMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::SetValetModeRequest& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "SetValetModeResponse"

void serializeJson (const ::bosch::cm::profile::SetValetModeResponse& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasResult()) {
        yajl_gen_string(g, (const unsigned char*)  "result" , 6);
        const char* s = ::bosch::cm::profile::serverResult_Name(value.getResult());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getResult());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::SetValetModeResponse& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveProfileUpdate"

void serializeJson (const ::bosch::cm::profile::ActiveProfileUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "activeProfile" , 13);
        yajl_gen_integer(g, (long long)value.getActiveProfile());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ActiveProfileUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveProfileRegister"

void serializeJson (const ::bosch::cm::profile::ActiveProfileRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ActiveProfileRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StatusUpdate"

void serializeJson (const ::bosch::cm::profile::StatusUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "status" , 6);
        const char* s = ::bosch::cm::profile::ProfileStatus_Name(value.getStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getStatus());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::StatusUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "StatusRegister"

void serializeJson (const ::bosch::cm::profile::StatusRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::StatusRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CopyProfileUpdate"

void serializeJson (const ::bosch::cm::profile::CopyProfileUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCopyProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "copyProfile" , 11);
        serializeJson(value.getCopyProfile(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::CopyProfileUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CopyProfileRegister"

void serializeJson (const ::bosch::cm::profile::CopyProfileRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::CopyProfileRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteProfileUpdate"

void serializeJson (const ::bosch::cm::profile::DeleteProfileUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDeleteProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "deleteProfile" , 13);
        yajl_gen_integer(g, (long long)value.getDeleteProfile());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DeleteProfileUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DeleteProfileRegister"

void serializeJson (const ::bosch::cm::profile::DeleteProfileRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DeleteProfileRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataChangedUpdate"

void serializeJson (const ::bosch::cm::profile::DataChangedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasDataChanged()) {
        yajl_gen_string(g, (const unsigned char*)  "dataChanged" , 11);
        const char* s = ::bosch::cm::profile::dataChangeReason_Name(value.getDataChanged());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getDataChanged());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DataChangedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "DataChangedRegister"

void serializeJson (const ::bosch::cm::profile::DataChangedRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::DataChangedRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateProfileUpdate"

void serializeJson (const ::bosch::cm::profile::CreateProfileUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasCreateProfile()) {
        yajl_gen_string(g, (const unsigned char*)  "createProfile" , 13);
        yajl_gen_integer(g, (long long)value.getCreateProfile());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::CreateProfileUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "CreateProfileRegister"

void serializeJson (const ::bosch::cm::profile::CreateProfileRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::CreateProfileRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivacyModeUpdate"

void serializeJson (const ::bosch::cm::profile::PrivacyModeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPrivacyMode()) {
        yajl_gen_string(g, (const unsigned char*)  "privacyMode" , 11);
        yajl_gen_integer(g, (long long)value.getPrivacyMode());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PrivacyModeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PrivacyModeRegister"

void serializeJson (const ::bosch::cm::profile::PrivacyModeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PrivacyModeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProfileNameUpdate"

void serializeJson (const ::bosch::cm::profile::ProfileNameUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProfileName()) {
        yajl_gen_string(g, (const unsigned char*)  "profileName" , 11);
        const char *s = value.getProfileName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ProfileNameUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProfileNameRegister"

void serializeJson (const ::bosch::cm::profile::ProfileNameRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ProfileNameRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProfileImageUpdate"

void serializeJson (const ::bosch::cm::profile::ProfileImageUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasProfileImage()) {
        yajl_gen_string(g, (const unsigned char*)  "profileImage" , 12);
        yajl_gen_integer(g, (long long)value.getProfileImage());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ProfileImageUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ProfileImageRegister"

void serializeJson (const ::bosch::cm::profile::ProfileImageRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ProfileImageRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PinRequestedUpdate"

void serializeJson (const ::bosch::cm::profile::PinRequestedUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPinRequested()) {
        yajl_gen_string(g, (const unsigned char*)  "pinRequested" , 12);
        yajl_gen_integer(g, (long long)value.getPinRequested());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PinRequestedUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PinRequestedRegister"

void serializeJson (const ::bosch::cm::profile::PinRequestedRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PinRequestedRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaxPINAttemptsUpdate"

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMaxPINAttempts()) {
        yajl_gen_string(g, (const unsigned char*)  "maxPINAttempts" , 14);
        yajl_gen_integer(g, (long long)value.getMaxPINAttempts());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaxPINAttemptsRegister"

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaxPINAttemptsBeforeDelayUpdate"

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasMaxPINAttemptsBeforeDelay()) {
        yajl_gen_string(g, (const unsigned char*)  "maxPINAttemptsBeforeDelay" , 25);
        yajl_gen_integer(g, (long long)value.getMaxPINAttemptsBeforeDelay());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "MaxPINAttemptsBeforeDelayRegister"

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PinAuthenticationDelayTimeUpdate"

void serializeJson (const ::bosch::cm::profile::PinAuthenticationDelayTimeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPinAuthenticationDelayTime()) {
        yajl_gen_string(g, (const unsigned char*)  "pinAuthenticationDelayTime" , 26);
        yajl_gen_integer(g, (long long)value.getPinAuthenticationDelayTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PinAuthenticationDelayTimeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PinAuthenticationDelayTimeRegister"

void serializeJson (const ::bosch::cm::profile::PinAuthenticationDelayTimeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PinAuthenticationDelayTimeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PinVerificationValidityTimeUpdate"

void serializeJson (const ::bosch::cm::profile::PinVerificationValidityTimeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasPinVerificationValidityTime()) {
        yajl_gen_string(g, (const unsigned char*)  "pinVerificationValidityTime" , 27);
        yajl_gen_integer(g, (long long)value.getPinVerificationValidityTime());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PinVerificationValidityTimeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "PinVerificationValidityTimeRegister"

void serializeJson (const ::bosch::cm::profile::PinVerificationValidityTimeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::PinVerificationValidityTimeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveProfileTypeUpdate"

void serializeJson (const ::bosch::cm::profile::ActiveProfileTypeUpdate& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasActiveProfileType()) {
        yajl_gen_string(g, (const unsigned char*)  "activeProfileType" , 17);
        const char* s = ::bosch::cm::profile::profileType_Name(value.getActiveProfileType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getActiveProfileType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ActiveProfileTypeUpdate& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "ActiveProfileTypeRegister"

void serializeJson (const ::bosch::cm::profile::ActiveProfileTypeRegister& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::bosch::cm::profile::ActiveProfileTypeRegister& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::copyInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoRegisterAppRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoRegisterAppResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::OnDataChangedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::OnProfileDeletedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::OnProfileCopiedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::OnProfileCreatedRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoCopyProfileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoCopyProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoDeleteProfileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoDeleteProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoChangeToProfileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoChangeToProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoCreateProfileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoCreateProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::Do_SetProfileNameRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::Do_SetProfileNameResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::GetProfileNamesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoImportProfileImageRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoImportProfileImageResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::RemoveUserImageRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::RemoveUserImageResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoSetProfileImageRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DoSetProfileImageResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::GetProfileImagesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::GetProfileTypesResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::SetProfilePinRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::SetProfilePinResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::SetRememberMeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::SetRememberMeResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::CheckPinRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::CheckPinResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::UnProtectProfileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::UnProtectProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::LinkProfileRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::LinkProfileResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::SetValetModeRequest& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::SetValetModeResponse& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ActiveProfileUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ActiveProfileRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::StatusUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::StatusRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::CopyProfileUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::CopyProfileRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DeleteProfileUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DeleteProfileRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DataChangedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::DataChangedRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::CreateProfileUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::CreateProfileRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PrivacyModeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PrivacyModeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ProfileNameUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ProfileNameRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ProfileImageUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ProfileImageRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PinRequestedUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PinRequestedRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::MaxPINAttemptsUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::MaxPINAttemptsRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::MaxPINAttemptsBeforeDelayRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PinAuthenticationDelayTimeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PinAuthenticationDelayTimeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PinVerificationValidityTimeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::PinVerificationValidityTimeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ActiveProfileTypeUpdate& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch
using namespace ::asf::stream::json;

namespace bosch {
namespace cm {
namespace profile {

std::ostream& operator<<(std::ostream& o, const ::bosch::cm::profile::ActiveProfileTypeRegister& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace profile
} // namespace cm
} // namespace bosch

