/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profileConnected.h"
#include "bosch/cm/profileConnectedConst.h"
#include "bosch/cm/profileConnectedDBus.h"
#include "bosch/cm/profileConnectedJson.h"
#include "bosch/cm/profileConnectedStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace profileConnected {

DEFINE_CLASS_LOGGER("/bosch/cm/bosch/cm/profileConnected", ProfileConnectedStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "doLinkProfile", 1 },
    { 15, "doUnlinkProfile", 2 },
    { 20, "doSynchronizeProfile", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 3, "kID", 2 },
    { 6, "status", 0 },
    { 11, "accountName", 1 },
    { 31, "remoteVehicleSettingsActivation", 3 },
};

class ProfileConnectedStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ProfileConnectedStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ProfileConnectedStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ProfileConnectedStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "bosch.cm.profileConnected"),
          _logger(logger) {}

    virtual ~ProfileConnectedStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ProfileConnectedStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'doSynchronizeProfile'

            LOG_DEBUG_STUB("process method '%s'", "doSynchronizeProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoSynchronizeProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoSynchronizeProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoSynchronizeProfileRequest > payload = ::boost::static_pointer_cast<DoSynchronizeProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileConnectedStub*>(getStub())->onDoSynchronizeProfileRequest(payload);
            return;
        }
        case 1: {

            // method 'doLinkProfile'

            LOG_DEBUG_STUB("process method '%s'", "doLinkProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoLinkProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoLinkProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoLinkProfileRequest > payload = ::boost::static_pointer_cast<DoLinkProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileConnectedStub*>(getStub())->onDoLinkProfileRequest(payload);
            return;
        }
        case 2: {

            // method 'doUnlinkProfile'

            LOG_DEBUG_STUB("process method '%s'", "doUnlinkProfile");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoUnlinkProfileRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DoUnlinkProfile", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DoUnlinkProfileRequest > payload = ::boost::static_pointer_cast<DoUnlinkProfileRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ProfileConnectedStub*>(getStub())->onDoUnlinkProfileRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ProfileConnectedStubDelegate::introspect() const {
    return     "<interface name=\"bosch.cm.profileConnected\">\n"
            "    <property access=\"read\" name=\"status\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"accountName\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"kID\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"remoteVehicleSettingsActivation\" type=\"b\"/>\n"
            "    <method name=\"doSynchronizeProfile\">\n"
            "      <doc>\n"
            "        <line>doSynchronizeProfile = Will mark the profile at ProfileIndex to be synchronized.</line>\n"
            "        <line>Synchronization is done if the profile is active and no other synchronization is pending.</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"profileIndex\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>profileIndex = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doLinkProfile\">\n"
            "      <doc>\n"
            "        <line>doLinkProfile = Request to Link a Profile. Shall result in setting the profile to type LINKED</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"accountName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>accountName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"pwd\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>pwd = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"doUnlinkProfile\">\n"
            "      <doc>\n"
            "        <line>doUnlinkProfile = Request to Unlink a Profile. Shall result in setting the profile to type LOCAL</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"userID\" type=\"y\">\n"
            "        <doc>\n"
            "          <line>userID = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"result\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>result = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void ProfileConnectedStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ProfileConnectedStub*>(getStub()))->onGetAll (properties);
}

void ProfileConnectedStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "status");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "accountName");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "kID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "remoteVehicleSettingsActivation");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ProfileConnectedStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "status");
            ::boost::shared_ptr< StatusGet > payload(new StatusGet());
            payload->setAct(act);
            static_cast<ProfileConnectedStub*>(getStub())->onStatusGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "accountName");
            ::boost::shared_ptr< AccountNameGet > payload(new AccountNameGet());
            payload->setAct(act);
            static_cast<ProfileConnectedStub*>(getStub())->onAccountNameGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "kID");
            ::boost::shared_ptr< KIDGet > payload(new KIDGet());
            payload->setAct(act);
            static_cast<ProfileConnectedStub*>(getStub())->onKIDGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "remoteVehicleSettingsActivation");
            ::boost::shared_ptr< RemoteVehicleSettingsActivationGet > payload(new RemoteVehicleSettingsActivationGet());
            payload->setAct(act);
            static_cast<ProfileConnectedStub*>(getStub())->onRemoteVehicleSettingsActivationGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ProfileConnectedStub::ProfileConnectedStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ProfileConnectedStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ProfileConnectedStub::ProfileConnectedStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ProfileConnectedStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ProfileConnectedStub::~ProfileConnectedStub() {
    delete _stubDelegate;
}

void ProfileConnectedStub::sendStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StatusUpdate payload(_statusProperty);

        LOG_INFO ("-> send%s", "StatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("status", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profileConnected", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StatusUpdate");
    }
}

void ProfileConnectedStub::onStatusGet(const ::boost::shared_ptr< StatusGet >& status) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StatusGet", status->getAct());
    sendStatusGetUpdate(_statusProperty.getStatus(), status->getAct());
}

void ProfileConnectedStub::sendStatusGetUpdate(appStatus status, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StatusGet payload(status);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileConnectedStub::setStatus(appStatus status) {
    if(status!=_statusProperty.getStatus()) {
        _statusProperty.setStatus(status);
        sendStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

appStatus ProfileConnectedStub::getStatus() const {
    return _statusProperty.getStatus();
}

void ProfileConnectedStub::sendAccountNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AccountNameUpdate payload(_accountNameProperty);

        LOG_INFO ("-> send%s", "AccountNameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("accountName", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profileConnected", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AccountNameUpdate");
    }
}

void ProfileConnectedStub::onAccountNameGet(const ::boost::shared_ptr< AccountNameGet >& accountName) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AccountNameGet", accountName->getAct());
    sendAccountNameGetUpdate(_accountNameProperty.getAccountName(), accountName->getAct());
}

void ProfileConnectedStub::sendAccountNameGetUpdate(const ::std::string& accountName, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AccountNameGet payload(accountName);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AccountNameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileConnectedStub::setAccountName(const ::std::string& accountName) {
    if(accountName!=_accountNameProperty.getAccountName()) {
        _accountNameProperty.setAccountName(accountName);
        sendAccountNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ProfileConnectedStub::getAccountName() const {
    return _accountNameProperty.getAccountName();
}

::std::string& ProfileConnectedStub::getAccountNameMutable() {
    return _accountNameProperty.getAccountNameMutable();
}

void ProfileConnectedStub::sendKIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        KIDUpdate payload(_kIDProperty);

        LOG_INFO ("-> send%s", "KIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("kID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profileConnected", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "KIDUpdate");
    }
}

void ProfileConnectedStub::onKIDGet(const ::boost::shared_ptr< KIDGet >& kID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "KIDGet", kID->getAct());
    sendKIDGetUpdate(_kIDProperty.getKID(), kID->getAct());
}

void ProfileConnectedStub::sendKIDGetUpdate(const ::std::string& kID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    KIDGet payload(kID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "KIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileConnectedStub::setKID(const ::std::string& kID) {
    if(kID!=_kIDProperty.getKID()) {
        _kIDProperty.setKID(kID);
        sendKIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& ProfileConnectedStub::getKID() const {
    return _kIDProperty.getKID();
}

::std::string& ProfileConnectedStub::getKIDMutable() {
    return _kIDProperty.getKIDMutable();
}

void ProfileConnectedStub::sendRemoteVehicleSettingsActivationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RemoteVehicleSettingsActivationUpdate payload(_remoteVehicleSettingsActivationProperty);

        LOG_INFO ("-> send%s", "RemoteVehicleSettingsActivationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("remoteVehicleSettingsActivation", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("bosch.cm.profileConnected", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RemoteVehicleSettingsActivationUpdate");
    }
}

void ProfileConnectedStub::onRemoteVehicleSettingsActivationGet(const ::boost::shared_ptr< RemoteVehicleSettingsActivationGet >& remoteVehicleSettingsActivation) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RemoteVehicleSettingsActivationGet", remoteVehicleSettingsActivation->getAct());
    sendRemoteVehicleSettingsActivationGetUpdate(_remoteVehicleSettingsActivationProperty.getRemoteVehicleSettingsActivation(), remoteVehicleSettingsActivation->getAct());
}

void ProfileConnectedStub::sendRemoteVehicleSettingsActivationGetUpdate(bool remoteVehicleSettingsActivation, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RemoteVehicleSettingsActivationGet payload(remoteVehicleSettingsActivation);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RemoteVehicleSettingsActivationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void ProfileConnectedStub::setRemoteVehicleSettingsActivation(bool remoteVehicleSettingsActivation) {
    if(remoteVehicleSettingsActivation!=_remoteVehicleSettingsActivationProperty.getRemoteVehicleSettingsActivation()) {
        _remoteVehicleSettingsActivationProperty.setRemoteVehicleSettingsActivation(remoteVehicleSettingsActivation);
        sendRemoteVehicleSettingsActivationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool ProfileConnectedStub::getRemoteVehicleSettingsActivation() const {
    return _remoteVehicleSettingsActivationProperty.getRemoteVehicleSettingsActivation();
}

void  ProfileConnectedStub::sendDoSynchronizeProfileResponse (serverResult result, act_t act) {
    DoSynchronizeProfileResponse* payload = new DoSynchronizeProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doSynchronizeProfile", DoSynchronizeProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoSynchronizeProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileConnectedStub::sendDoSynchronizeProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoSynchronizeProfileError* payload = new DoSynchronizeProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doSynchronizeProfile", DoSynchronizeProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoSynchronizeProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileConnectedStub::sendDoLinkProfileResponse (serverResult result, act_t act) {
    DoLinkProfileResponse* payload = new DoLinkProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doLinkProfile", DoLinkProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoLinkProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileConnectedStub::sendDoLinkProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoLinkProfileError* payload = new DoLinkProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doLinkProfile", DoLinkProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoLinkProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileConnectedStub::sendDoUnlinkProfileResponse (serverResult result, act_t act) {
    DoUnlinkProfileResponse* payload = new DoUnlinkProfileResponse(result);
    DBUS_MESSAGE_REPLY(dbusMessage, "doUnlinkProfile", DoUnlinkProfileResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DoUnlinkProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ProfileConnectedStub::sendDoUnlinkProfileError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DoUnlinkProfileError* payload = new DoUnlinkProfileError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "doUnlinkProfile", DoUnlinkProfileError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DoUnlinkProfile", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ProfileConnectedStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'status'
    {
        ::asf::dbus::DBusVariant variant;
        StatusGet payload(_statusProperty.getStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("status", variant));
    }

    //property 'accountName'
    {
        ::asf::dbus::DBusVariant variant;
        AccountNameGet payload(_accountNameProperty.getAccountName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("accountName", variant));
    }

    //property 'kID'
    {
        ::asf::dbus::DBusVariant variant;
        KIDGet payload(_kIDProperty.getKID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("kID", variant));
    }

    //property 'remoteVehicleSettingsActivation'
    {
        ::asf::dbus::DBusVariant variant;
        RemoteVehicleSettingsActivationGet payload(_remoteVehicleSettingsActivationProperty.getRemoteVehicleSettingsActivation());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("remoteVehicleSettingsActivation", variant));
    }
}

} // namespace profileConnected
} // namespace cm
} // namespace bosch
