/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef BOSCH_CM_PROFILECONNECTEDPROXY_H
#define BOSCH_CM_PROFILECONNECTEDPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profileConnected.h"
#include "bosch/cm/profileConnectedConst.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>
#include <string>

namespace bosch {
namespace cm {
namespace profileConnected {

class ProfileConnectedProxy;

class AccountNameCallbackIF {
public:
    virtual ~AccountNameCallbackIF() {}

    virtual void onAccountNameError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< AccountNameError >& error) = 0;

    virtual void onAccountNameUpdate(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< AccountNameUpdate >& update) = 0;
};

class DoLinkProfileCallbackIF {
public:
    virtual ~DoLinkProfileCallbackIF() {}

    virtual void onDoLinkProfileError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< DoLinkProfileError >& error) = 0;

    virtual void onDoLinkProfileResponse(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< DoLinkProfileResponse >& response) = 0;
};

class DoSynchronizeProfileCallbackIF {
public:
    virtual ~DoSynchronizeProfileCallbackIF() {}

    virtual void onDoSynchronizeProfileError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< DoSynchronizeProfileError >& error) = 0;

    virtual void onDoSynchronizeProfileResponse(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< DoSynchronizeProfileResponse >& response) = 0;
};

class DoUnlinkProfileCallbackIF {
public:
    virtual ~DoUnlinkProfileCallbackIF() {}

    virtual void onDoUnlinkProfileError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< DoUnlinkProfileError >& error) = 0;

    virtual void onDoUnlinkProfileResponse(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< DoUnlinkProfileResponse >& response) = 0;
};

class KIDCallbackIF {
public:
    virtual ~KIDCallbackIF() {}

    virtual void onKIDError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< KIDError >& error) = 0;

    virtual void onKIDUpdate(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< KIDUpdate >& update) = 0;
};

class RemoteVehicleSettingsActivationCallbackIF {
public:
    virtual ~RemoteVehicleSettingsActivationCallbackIF() {}

    virtual void onRemoteVehicleSettingsActivationError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< RemoteVehicleSettingsActivationError >& error) = 0;

    virtual void onRemoteVehicleSettingsActivationUpdate(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< RemoteVehicleSettingsActivationUpdate >& update) = 0;
};

class StatusCallbackIF {
public:
    virtual ~StatusCallbackIF() {}

    virtual void onStatusError(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< StatusError >& error) = 0;

    virtual void onStatusUpdate(const ::boost::shared_ptr< ProfileConnectedProxy >& proxy, const ::boost::shared_ptr< StatusUpdate >& update) = 0;
};


/**
 * ProfileConnectedProxy is the client side representation of the D-Bus
 * service interface 'bosch.cm.profileConnected' (specified in file
 * Profile-connected_.xml).
 *
 * attributes for connected User Profile Management
 */
class ProfileConnectedProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ProfileConnectedProxy.
     */
    static ::boost::shared_ptr< ProfileConnectedProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ProfileConnectedProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ProfileConnectedProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ProfileConnectedProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ProfileConnectedProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ProfileConnectedProxy > proxyNew(new ProfileConnectedProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ProfileConnectedProxy ();



    // Property 'status'

    /**
     * Notify on the property 'status'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusRegister(StatusCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'status'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     *
     * @param act The act which was previously returned by the
     * sendStatusRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStatusDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'status'.
     */
    void sendStatusDeregisterAll() const;

    /**
     * Request the value of the property 'status' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'status'</b>:
     *
     * connected profile application status
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStatusGet(StatusCallbackIF& cb);


    /**
     * Returns the current value of the property 'status' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasStatus()
     * returns true.
     *
     * @return the previously received value of the property 'status'.
     */
    appStatus getStatus() const;

    /**
     * Determines whether a status message for the property 'status' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStatus() const;

    // Property 'accountName'

    /**
     * Notify on the property 'accountName'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccountNameRegister(AccountNameCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'accountName'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param act The act which was previously returned by the
     * sendAccountNameRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAccountNameDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'accountName'.
     */
    void sendAccountNameDeregisterAll() const;

    /**
     * Request the value of the property 'accountName' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'accountName'</b>:
     *
     * accountName of the currently Logged on Profile.Valid Name is sent if logon is successful.Otherwise Empty name is sent
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAccountNameGet(AccountNameCallbackIF& cb);


    /**
     * Returns the current value of the property 'accountName' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAccountName() returns true.
     *
     * @return the previously received value of the property 'accountName'.
     */
    const ::std::string& getAccountName() const;

    /**
     * Determines whether a status message for the property 'accountName' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAccountName() const;

    // Property 'kID'

    /**
     * Notify on the property 'kID'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKIDRegister(KIDCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'kID'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendKIDRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendKIDDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'kID'.
     */
    void sendKIDDeregisterAll() const;

    /**
     * Request the value of the property 'kID' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'kID'</b>:
     *
     * If the meaning of "kID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendKIDGet(KIDCallbackIF& cb);


    /**
     * Returns the current value of the property 'kID' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasKID()
     * returns true.
     *
     * @return the previously received value of the property 'kID'.
     */
    const ::std::string& getKID() const;

    /**
     * Determines whether a status message for the property 'kID' was received
     * before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasKID() const;

    // Property 'remoteVehicleSettingsActivation'

    /**
     * Notify on the property 'remoteVehicleSettingsActivation'. This method
     * registers for property changes by D-Bus service.
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteVehicleSettingsActivationRegister(RemoteVehicleSettingsActivationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'remoteVehicleSettingsActivation'.
     * This method deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     *
     * @param act The act which was previously returned by the
     * sendRemoteVehicleSettingsActivationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRemoteVehicleSettingsActivationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property
     * 'remoteVehicleSettingsActivation'.
     */
    void sendRemoteVehicleSettingsActivationDeregisterAll() const;

    /**
     * Request the value of the property 'remoteVehicleSettingsActivation'
     * from the D-Bus server. This method sends a Get message to the D-Bus
     * server.
     *
     * <b>Documentation of 'remoteVehicleSettingsActivation'</b>:
     *
     * RVS is a Configuration Manager Setting Item maintained by PM. TRUE:Subscription is Active. FALSE: subscription is Inactive
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteVehicleSettingsActivationGet(RemoteVehicleSettingsActivationCallbackIF& cb);


    /**
     * Returns the current value of the property
     * 'remoteVehicleSettingsActivation' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasRemoteVehicleSettingsActivation() returns true.
     *
     * @return the previously received value of the property 'remoteVehicleSettingsActivation'.
     */
    bool getRemoteVehicleSettingsActivation() const;

    /**
     * Determines whether a status message for the property
     * 'remoteVehicleSettingsActivation' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRemoteVehicleSettingsActivation() const;


    // Method 'doSynchronizeProfile'

    /**
     * Call the method 'doSynchronizeProfile'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'doSynchronizeProfile'</b>:
     *
     * Will mark the profile at ProfileIndex to be synchronized.
     *                        Synchronization is done if the profile is active and no other synchronization is pending.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param profileIndex If the meaning of "profileIndex" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoSynchronizeProfileRequest(DoSynchronizeProfileCallbackIF& cb, uint8 profileIndex) const;

    // Method 'doLinkProfile'

    /**
     * Call the method 'doLinkProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doLinkProfile'</b>:
     *
     * Request to Link a Profile. Shall result in setting the profile to type LINKED
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param accountName If the meaning of "accountName" isn't clear, then there should be a description here.
     *
     * @param pwd If the meaning of "pwd" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoLinkProfileRequest(DoLinkProfileCallbackIF& cb, const ::std::string& accountName, const ::std::string& pwd) const;

    // Method 'doUnlinkProfile'

    /**
     * Call the method 'doUnlinkProfile'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'doUnlinkProfile'</b>:
     *
     * Request to Unlink a Profile. Shall result in setting the profile to type LOCAL
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param userID If the meaning of "userID" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDoUnlinkProfileRequest(DoUnlinkProfileCallbackIF& cb, uint8 userID) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ProfileConnectedProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'status'

    ::asf::core::nullable< StatusUpdate > _status;

    // Property 'accountName'

    ::asf::core::nullable< AccountNameUpdate > _accountName;

    // Property 'kID'

    ::asf::core::nullable< KIDUpdate > _kID;

    // Property 'remoteVehicleSettingsActivation'

    ::asf::core::nullable< RemoteVehicleSettingsActivationUpdate > _remoteVehicleSettingsActivation;

    DECLARE_CLASS_LOGGER();

    friend class ProfileConnectedProxyCallback;
};

} // namespace profileConnected
} // namespace cm
} // namespace bosch

#endif // BOSCH_CM_PROFILECONNECTEDPROXY_H
