/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "bosch/cm/profileConnected.h"
#include "bosch/cm/profileConnectedConst.h"
#include "bosch/cm/profileConnectedDBus.h"
#include "bosch/cm/profileConnectedJson.h"
#include "bosch/cm/profileConnectedProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace bosch {
namespace cm {
namespace profileConnected {

DEFINE_CLASS_LOGGER("/bosch/cm/bosch/cm/profileConnected", ProfileConnectedProxy);

class ProfileConnectedProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ProfileConnectedProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ProfileConnectedProxy >& proxyShared = ::boost::static_pointer_cast< ProfileConnectedProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_status:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusError> payload = ::boost::static_pointer_cast<StatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StatusCallbackIF*) _callback)->onStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusUpdate> payload = ::boost::static_pointer_cast<StatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StatusCallbackIF*) _callback)->onStatusUpdate(proxyShared, payload);
                        proxyShared->_status = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_accountName:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccountNameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AccountName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AccountNameError> payload = ::boost::static_pointer_cast<AccountNameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AccountNameCallbackIF*) _callback)->onAccountNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccountNameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AccountName", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AccountNameUpdate> payload = ::boost::static_pointer_cast<AccountNameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AccountNameCallbackIF*) _callback)->onAccountNameUpdate(proxyShared, payload);
                        proxyShared->_accountName = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_kID:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KIDError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KIDError> payload = ::boost::static_pointer_cast<KIDError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((KIDCallbackIF*) _callback)->onKIDError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), KIDUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "KID", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<KIDUpdate> payload = ::boost::static_pointer_cast<KIDUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((KIDCallbackIF*) _callback)->onKIDUpdate(proxyShared, payload);
                        proxyShared->_kID = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_remoteVehicleSettingsActivation:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteVehicleSettingsActivationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemoteVehicleSettingsActivation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoteVehicleSettingsActivationError> payload = ::boost::static_pointer_cast<RemoteVehicleSettingsActivationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RemoteVehicleSettingsActivationCallbackIF*) _callback)->onRemoteVehicleSettingsActivationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteVehicleSettingsActivationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemoteVehicleSettingsActivation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoteVehicleSettingsActivationUpdate> payload = ::boost::static_pointer_cast<RemoteVehicleSettingsActivationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RemoteVehicleSettingsActivationCallbackIF*) _callback)->onRemoteVehicleSettingsActivationUpdate(proxyShared, payload);
                        proxyShared->_remoteVehicleSettingsActivation = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_doSynchronizeProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoSynchronizeProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSynchronizeProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoSynchronizeProfileError> payload = ::boost::static_pointer_cast<DoSynchronizeProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoSynchronizeProfileCallbackIF*) _callback)->onDoSynchronizeProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoSynchronizeProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoSynchronizeProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoSynchronizeProfileResponse> payload = ::boost::static_pointer_cast<DoSynchronizeProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoSynchronizeProfileCallbackIF*) _callback)->onDoSynchronizeProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doLinkProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoLinkProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoLinkProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoLinkProfileError> payload = ::boost::static_pointer_cast<DoLinkProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoLinkProfileCallbackIF*) _callback)->onDoLinkProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoLinkProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoLinkProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoLinkProfileResponse> payload = ::boost::static_pointer_cast<DoLinkProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoLinkProfileCallbackIF*) _callback)->onDoLinkProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_doUnlinkProfile:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DoUnlinkProfileError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoUnlinkProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoUnlinkProfileError> payload = ::boost::static_pointer_cast<DoUnlinkProfileError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoUnlinkProfileCallbackIF*) _callback)->onDoUnlinkProfileError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DoUnlinkProfileResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoUnlinkProfile", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DoUnlinkProfileResponse> payload = ::boost::static_pointer_cast<DoUnlinkProfileResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DoUnlinkProfileCallbackIF*) _callback)->onDoUnlinkProfileResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_status: {
                ::boost::shared_ptr< StatusError > payload = ::boost::shared_ptr< StatusError >
                (new StatusError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Status", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StatusCallbackIF*) _callback)->onStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_accountName: {
                ::boost::shared_ptr< AccountNameError > payload = ::boost::shared_ptr< AccountNameError >
                (new AccountNameError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AccountName", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AccountNameCallbackIF*) _callback)->onAccountNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_kID: {
                ::boost::shared_ptr< KIDError > payload = ::boost::shared_ptr< KIDError >
                (new KIDError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "KID", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((KIDCallbackIF*) _callback)->onKIDError (proxyShared,payload);
                return true;
            }
            break;
            case ID_remoteVehicleSettingsActivation: {
                ::boost::shared_ptr< RemoteVehicleSettingsActivationError > payload = ::boost::shared_ptr< RemoteVehicleSettingsActivationError >
                (new RemoteVehicleSettingsActivationError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoteVehicleSettingsActivation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoteVehicleSettingsActivationCallbackIF*) _callback)->onRemoteVehicleSettingsActivationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doSynchronizeProfile: {
                ::boost::shared_ptr< DoSynchronizeProfileError > payload = ::boost::shared_ptr< DoSynchronizeProfileError >
                (new DoSynchronizeProfileError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoSynchronizeProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoSynchronizeProfileCallbackIF*) _callback)->onDoSynchronizeProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doLinkProfile: {
                ::boost::shared_ptr< DoLinkProfileError > payload = ::boost::shared_ptr< DoLinkProfileError >
                (new DoLinkProfileError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoLinkProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoLinkProfileCallbackIF*) _callback)->onDoLinkProfileError (proxyShared,payload);
                return true;
            }
            break;
            case ID_doUnlinkProfile: {
                ::boost::shared_ptr< DoUnlinkProfileError > payload = ::boost::shared_ptr< DoUnlinkProfileError >
                (new DoUnlinkProfileError(DBUS_ERROR_NO_SERVER, "The DBus service ProfileConnected is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DoUnlinkProfile", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ProfileConnectedProxy> proxyShared = ::boost::static_pointer_cast<ProfileConnectedProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DoUnlinkProfileCallbackIF*) _callback)->onDoUnlinkProfileError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ProfileConnectedProxyCallback::_logger (ProfileConnectedProxy::_logger);

ProfileConnectedProxy::ProfileConnectedProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "bosch.cm.profileConnected", serviceAvailable, _logger) {
}

ProfileConnectedProxy::~ProfileConnectedProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ProfileConnectedProxy > ProfileConnectedProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ProfileConnectedProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ProfileConnectedProxy > proxyNew(new ProfileConnectedProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t ProfileConnectedProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ProfileConnectedProxyCallback* callback = new ProfileConnectedProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ProfileConnectedProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ProfileConnectedProxyCallback* callback = new ProfileConnectedProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void ProfileConnectedProxy::clearAllProperties ()
{
    _status = ::asf::core::nullable< StatusUpdate >();
    _accountName = ::asf::core::nullable< AccountNameUpdate >();
    _kID = ::asf::core::nullable< KIDUpdate >();
    _remoteVehicleSettingsActivation = ::asf::core::nullable< RemoteVehicleSettingsActivationUpdate >();
}

void ProfileConnectedProxy::sendDeregisterAll () const
{
    sendStatusDeregisterAll();
    sendAccountNameDeregisterAll();
    sendKIDDeregisterAll();
    sendRemoteVehicleSettingsActivationDeregisterAll();
}

act_t ProfileConnectedProxy::sendStatusRegister(StatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_status, "status", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Status", &cb, act);
    return act;
}

bool ProfileConnectedProxy::sendStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("status", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Status", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileConnectedProxy::sendStatusGet(StatusCallbackIF& cb) {
    ProfileConnectedProxyCallback* callback = new ProfileConnectedProxyCallback(ID_status, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Status", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("status", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


appStatus ProfileConnectedProxy::getStatus() const {
    return _status.get().getStatus();
}

bool ProfileConnectedProxy::hasStatus() const {
    return _status.hasValue();
}

void ProfileConnectedProxy::sendStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Status");
    _dbusProxyDelegate->deregisterSignalCallback("status", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileConnectedProxy::sendAccountNameRegister(AccountNameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_accountName, "accountName", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AccountName", &cb, act);
    return act;
}

bool ProfileConnectedProxy::sendAccountNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("accountName", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AccountName", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileConnectedProxy::sendAccountNameGet(AccountNameCallbackIF& cb) {
    ProfileConnectedProxyCallback* callback = new ProfileConnectedProxyCallback(ID_accountName, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AccountName", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("accountName", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ProfileConnectedProxy::getAccountName() const {
    return _accountName.get().getAccountName();
}

bool ProfileConnectedProxy::hasAccountName() const {
    return _accountName.hasValue();
}

void ProfileConnectedProxy::sendAccountNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AccountName");
    _dbusProxyDelegate->deregisterSignalCallback("accountName", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileConnectedProxy::sendKIDRegister(KIDCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_kID, "kID", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "KID", &cb, act);
    return act;
}

bool ProfileConnectedProxy::sendKIDDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("kID", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "KID", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileConnectedProxy::sendKIDGet(KIDCallbackIF& cb) {
    ProfileConnectedProxyCallback* callback = new ProfileConnectedProxyCallback(ID_kID, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "KID", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("kID", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& ProfileConnectedProxy::getKID() const {
    return _kID.get().getKID();
}

bool ProfileConnectedProxy::hasKID() const {
    return _kID.hasValue();
}

void ProfileConnectedProxy::sendKIDDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "KID");
    _dbusProxyDelegate->deregisterSignalCallback("kID", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileConnectedProxy::sendRemoteVehicleSettingsActivationRegister(RemoteVehicleSettingsActivationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_remoteVehicleSettingsActivation, "remoteVehicleSettingsActivation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemoteVehicleSettingsActivation", &cb, act);
    return act;
}

bool ProfileConnectedProxy::sendRemoteVehicleSettingsActivationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("remoteVehicleSettingsActivation", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemoteVehicleSettingsActivation", act, static_cast<int>(rv));
    return rv;
}

act_t ProfileConnectedProxy::sendRemoteVehicleSettingsActivationGet(RemoteVehicleSettingsActivationCallbackIF& cb) {
    ProfileConnectedProxyCallback* callback = new ProfileConnectedProxyCallback(ID_remoteVehicleSettingsActivation, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RemoteVehicleSettingsActivation", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("remoteVehicleSettingsActivation", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool ProfileConnectedProxy::getRemoteVehicleSettingsActivation() const {
    return _remoteVehicleSettingsActivation.get().getRemoteVehicleSettingsActivation();
}

bool ProfileConnectedProxy::hasRemoteVehicleSettingsActivation() const {
    return _remoteVehicleSettingsActivation.hasValue();
}

void ProfileConnectedProxy::sendRemoteVehicleSettingsActivationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemoteVehicleSettingsActivation");
    _dbusProxyDelegate->deregisterSignalCallback("remoteVehicleSettingsActivation", 0, _dbusDaemonProxy.get(), true);
}

act_t ProfileConnectedProxy::sendDoSynchronizeProfileRequest(DoSynchronizeProfileCallbackIF& cb, uint8 profileIndex) const {
    DoSynchronizeProfileRequest* payload = new DoSynchronizeProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setProfileIndex(profileIndex);
    DBUS_MESSAGE_CALL(dbusMessage, "doSynchronizeProfile", DoSynchronizeProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doSynchronizeProfile, dbusMessage.getUniqueSerial(), "doSynchronizeProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoSynchronizeProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileConnectedProxy::sendDoLinkProfileRequest(DoLinkProfileCallbackIF& cb, const ::std::string& accountName, const ::std::string& pwd) const {
    DoLinkProfileRequest* payload = new DoLinkProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setAccountName(accountName);
    payload->setPwd(pwd);
    DBUS_MESSAGE_CALL(dbusMessage, "doLinkProfile", DoLinkProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doLinkProfile, dbusMessage.getUniqueSerial(), "doLinkProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoLinkProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ProfileConnectedProxy::sendDoUnlinkProfileRequest(DoUnlinkProfileCallbackIF& cb, uint8 userID) const {
    DoUnlinkProfileRequest* payload = new DoUnlinkProfileRequest();
    CHECK_ALLOCATION(payload);
    payload->setUserID(userID);
    DBUS_MESSAGE_CALL(dbusMessage, "doUnlinkProfile", DoUnlinkProfileRequest, payload, true)
    act_t act = addMethodCallback(ID_doUnlinkProfile, dbusMessage.getUniqueSerial(), "doUnlinkProfile", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DoUnlinkProfile", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace profileConnected
} // namespace cm
} // namespace bosch
