/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "midw_tunermaster_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types midw_tunermaster_fi_types
 */

using namespace ::asf::stream::json;

namespace midw_tunermaster_fi_types {

bool T_e8_Band_Parse (const char *str, size_t length, T_e8_Band &value)
{
    static stringEntry entries[] = {
        {16,"TUN_MSTR_BAND_FM", 0U},
        {16,"TUN_MSTR_BAND_LW", 3U},
        {16,"TUN_MSTR_BAND_MW", 2U},
        {16,"TUN_MSTR_BAND_WB", 18U},
        {17,"TUN_MSTR_BAND_CB1", 20U},
        {17,"TUN_MSTR_BAND_DAB", 1U},
        {17,"TUN_MSTR_BAND_SXM", 4U},
        {17,"TUN_MSTR_BAND_TRF", 17U},
        {18,"TUN_MSTR_BAND_NONE", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_Band_Name (T_e8_Band value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_BAND_FM",
        "TUN_MSTR_BAND_DAB",
        "TUN_MSTR_BAND_MW",
        "TUN_MSTR_BAND_LW",
        "TUN_MSTR_BAND_SXM",
        "TUN_MSTR_BAND_TRF",
        "TUN_MSTR_BAND_WB",
        "TUN_MSTR_BAND_CB1",
        "TUN_MSTR_BAND_NONE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        17U,
        18U,
        20U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 9, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Band_IsValid (T_e8_Band value)
{
    switch (value) {
    case T_e8_Band__TUN_MSTR_BAND_FM:
    case T_e8_Band__TUN_MSTR_BAND_DAB:
    case T_e8_Band__TUN_MSTR_BAND_MW:
    case T_e8_Band__TUN_MSTR_BAND_LW:
    case T_e8_Band__TUN_MSTR_BAND_SXM:
    case T_e8_Band__TUN_MSTR_BAND_TRF:
    case T_e8_Band__TUN_MSTR_BAND_WB:
    case T_e8_Band__TUN_MSTR_BAND_CB1:
    case T_e8_Band__TUN_MSTR_BAND_NONE:
        return true;
    default:
        return false;
    }
}

bool T_e8_Preset_Option_Parse (const char *str, size_t length, T_e8_Preset_Option &value)
{
    static stringEntry entries[] = {
        {34,"TUN_MSTR_PRESET_OPTION_KEEP_OTHERS", 0U},
        {36,"TUN_MSTR_PRESET_OPTION_DELETE_OTHERS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_Preset_Option_Name (T_e8_Preset_Option value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_Preset_Option_Keep_Others",
        "TUN_MSTR_Preset_Option_Delete_Others",
    };

    if (T_e8_Preset_Option_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Preset_Option_IsValid (T_e8_Preset_Option value)
{
    switch (value) {
    case T_e8_Preset_Option__TUN_MSTR_Preset_Option_Keep_Others:
    case T_e8_Preset_Option__TUN_MSTR_Preset_Option_Delete_Others:
        return true;
    default:
        return false;
    }
}

bool T_e8_Source_Parse (const char *str, size_t length, T_e8_Source &value)
{
    static stringEntry entries[] = {
        {18,"TUN_MSTR_SOURCE_AM", 2U},
        {19,"TUN_MSTR_SOURCE_DAB", 3U},
        {19,"TUN_MSTR_SOURCE_DRM", 12U},
        {19,"TUN_MSTR_SOURCE_FM1", 0U},
        {19,"TUN_MSTR_SOURCE_FM2", 1U},
        {19,"TUN_MSTR_SOURCE_SXM", 13U},
        {20,"TUN_MSTR_SOURCE_NONE", 255U},
        {21,"TUN_MSTR_SOURCE_FM_TA", 4U},
        {22,"TUN_MSTR_SOURCE_DAB_TA", 5U},
        {23,"TUN_MSTR_SOURCE_NO_ANNO", 11U},
        {24,"TUN_MSTR_SOURCE_PTY31_FM", 8U},
        {25,"TUN_MSTR_SOURCE_DAB_FM_SF", 6U},
        {25,"TUN_MSTR_SOURCE_NON_RADIO", 7U},
        {25,"TUN_MSTR_SOURCE_PTY31_DAB", 9U},
        {29,"TUN_MSTR_SOURCE_WEATHER_ALERT", 14U},
        {30,"TUN_MSTR_SOURCE_DAB_OTHER_ANNO", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 16, (unsigned int&) value);
}

const char* T_e8_Source_Name (T_e8_Source value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_SOURCE_FM1",
        "TUN_MSTR_SOURCE_FM2",
        "TUN_MSTR_SOURCE_AM",
        "TUN_MSTR_SOURCE_DAB",
        "TUN_MSTR_SOURCE_FM_TA",
        "TUN_MSTR_SOURCE_DAB_TA",
        "TUN_MSTR_SOURCE_DAB_FM_SF",
        "TUN_MSTR_SOURCE_NON_RADIO",
        "TUN_MSTR_SOURCE_PTY31_FM",
        "TUN_MSTR_SOURCE_PTY31_DAB",
        "TUN_MSTR_SOURCE_DAB_OTHER_ANNO",
        "TUN_MSTR_SOURCE_NO_ANNO",
        "TUN_MSTR_SOURCE_DRM",
        "TUN_MSTR_SOURCE_SXM",
        "TUN_MSTR_SOURCE_WEATHER_ALERT",
        "TUN_MSTR_SOURCE_NONE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 16, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Source_IsValid (T_e8_Source value)
{
    switch (value) {
    case T_e8_Source__TUN_MSTR_SOURCE_FM1:
    case T_e8_Source__TUN_MSTR_SOURCE_FM2:
    case T_e8_Source__TUN_MSTR_SOURCE_AM:
    case T_e8_Source__TUN_MSTR_SOURCE_DAB:
    case T_e8_Source__TUN_MSTR_SOURCE_FM_TA:
    case T_e8_Source__TUN_MSTR_SOURCE_DAB_TA:
    case T_e8_Source__TUN_MSTR_SOURCE_DAB_FM_SF:
    case T_e8_Source__TUN_MSTR_SOURCE_NON_RADIO:
    case T_e8_Source__TUN_MSTR_SOURCE_PTY31_FM:
    case T_e8_Source__TUN_MSTR_SOURCE_PTY31_DAB:
    case T_e8_Source__TUN_MSTR_SOURCE_DAB_OTHER_ANNO:
    case T_e8_Source__TUN_MSTR_SOURCE_NO_ANNO:
    case T_e8_Source__TUN_MSTR_SOURCE_DRM:
    case T_e8_Source__TUN_MSTR_SOURCE_SXM:
    case T_e8_Source__TUN_MSTR_SOURCE_WEATHER_ALERT:
    case T_e8_Source__TUN_MSTR_SOURCE_NONE:
        return true;
    default:
        return false;
    }
}

bool T_e8_Action_Parse (const char *str, size_t length, T_e8_Action &value)
{
    static stringEntry entries[] = {
        {13,"TUN_MSTR_NONE", 255U},
        {13,"TUN_MSTR_PLAY", 0U},
        {13,"TUN_MSTR_STOP", 2U},
        {14,"TUN_MSTR_PAUSE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_Action_Name (T_e8_Action value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_PLAY",
        "TUN_MSTR_PAUSE",
        "TUN_MSTR_STOP",
        "TUN_MSTR_NONE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Action_IsValid (T_e8_Action value)
{
    switch (value) {
    case T_e8_Action__TUN_MSTR_PLAY:
    case T_e8_Action__TUN_MSTR_PAUSE:
    case T_e8_Action__TUN_MSTR_STOP:
    case T_e8_Action__TUN_MSTR_NONE:
        return true;
    default:
        return false;
    }
}

bool T_e8_WhichTuner_Parse (const char *str, size_t length, T_e8_WhichTuner &value)
{
    static stringEntry entries[] = {
        {16,"TUN_MSTR_TUNER_0", 0U},
        {16,"TUN_MSTR_TUNER_1", 1U},
        {16,"TUN_MSTR_TUNER_2", 2U},
        {16,"TUN_MSTR_TUNER_3", 3U},
        {18,"TUN_MSTR_AUTO_MODE", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_WhichTuner_Name (T_e8_WhichTuner value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_TUNER_0",
        "TUN_MSTR_TUNER_1",
        "TUN_MSTR_TUNER_2",
        "TUN_MSTR_TUNER_3",
        "TUN_MSTR_AUTO_MODE",
    };

    if (T_e8_WhichTuner_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_WhichTuner_IsValid (T_e8_WhichTuner value)
{
    switch (value) {
    case T_e8_WhichTuner__TUN_MSTR_TUNER_0:
    case T_e8_WhichTuner__TUN_MSTR_TUNER_1:
    case T_e8_WhichTuner__TUN_MSTR_TUNER_2:
    case T_e8_WhichTuner__TUN_MSTR_TUNER_3:
    case T_e8_WhichTuner__TUN_MSTR_AUTO_MODE:
        return true;
    default:
        return false;
    }
}

bool T_StopAnnouncements_Parse (const char *str, size_t length, T_StopAnnouncements &value)
{
    static stringEntry entries[] = {
        {17,"TUN_MSTR_STOP_ALL", 1U},
        {21,"TUN_MSTR_STOP_CURRENT", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_StopAnnouncements_Name (T_StopAnnouncements value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_STOP_CURRENT",
        "TUN_MSTR_STOP_ALL",
    };

    if (T_StopAnnouncements_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_StopAnnouncements_IsValid (T_StopAnnouncements value)
{
    switch (value) {
    case T_StopAnnouncements__TUN_MSTR_STOP_CURRENT:
    case T_StopAnnouncements__TUN_MSTR_STOP_ALL:
        return true;
    default:
        return false;
    }
}

bool T_e8_TunMstr_ResponseStatus_Parse (const char *str, size_t length, T_e8_TunMstr_ResponseStatus &value)
{
    static stringEntry entries[] = {
        {21,"TUN_MSTR_RES_REQ_FAIL", 1U},
        {24,"TUN_MSTR_RES_REQ_SUCCEED", 0U},
        {31,"TUN_MSTR_RES_PREV_REQ_INPROCESS", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_TunMstr_ResponseStatus_Name (T_e8_TunMstr_ResponseStatus value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_RES_REQ_SUCCEED",
        "TUN_MSTR_RES_REQ_FAIL",
        "TUN_MSTR_RES_PREV_REQ_INPROCESS",
    };

    if (T_e8_TunMstr_ResponseStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TunMstr_ResponseStatus_IsValid (T_e8_TunMstr_ResponseStatus value)
{
    switch (value) {
    case T_e8_TunMstr_ResponseStatus__TUN_MSTR_RES_REQ_SUCCEED:
    case T_e8_TunMstr_ResponseStatus__TUN_MSTR_RES_REQ_FAIL:
    case T_e8_TunMstr_ResponseStatus__TUN_MSTR_RES_PREV_REQ_INPROCESS:
        return true;
    default:
        return false;
    }
}

bool T_e8_TunMstr_RadioProfileSetting_Response_Parse (const char *str, size_t length, T_e8_TunMstr_RadioProfileSetting_Response &value)
{
    static stringEntry entries[] = {
        {40,"TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED", 0U},
        {47,"TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_DAB", 2U},
        {47,"TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_SXM", 1U},
        {48,"TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TunMstr_RadioProfileSetting_Response_Name (T_e8_TunMstr_RadioProfileSetting_Response value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_RadioProfileSetting_Res_Succeed",
        "TUN_MSTR_RadioProfileSetting_Res_Failed_For_SXM",
        "TUN_MSTR_RadioProfileSetting_Res_Failed_For_DAB",
        "TUN_MSTR_RadioProfileSetting_Res_Failed_For_AMFM",
    };

    if (T_e8_TunMstr_RadioProfileSetting_Response_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TunMstr_RadioProfileSetting_Response_IsValid (T_e8_TunMstr_RadioProfileSetting_Response value)
{
    switch (value) {
    case T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Succeed:
    case T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Failed_For_SXM:
    case T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Failed_For_DAB:
    case T_e8_TunMstr_RadioProfileSetting_Response__TUN_MSTR_RadioProfileSetting_Res_Failed_For_AMFM:
        return true;
    default:
        return false;
    }
}

bool T_e8_TunMstr_RadioProfileSetting_ErrorCode_Parse (const char *str, size_t length, T_e8_TunMstr_RadioProfileSetting_ErrorCode &value)
{
    static stringEntry entries[] = {
        {43,"TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE", 255U},
        {46,"TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_UNKNOWN", 4U},
        {55,"TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_BANDNOTSUPPORTED", 0U},
        {55,"TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDFREQUENCY", 1U},
        {58,"TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_PRESETNOTCONFIGURED", 2U},
        {60,"TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDSID_ENSEMBLEID", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_TunMstr_RadioProfileSetting_ErrorCode_Name (T_e8_TunMstr_RadioProfileSetting_ErrorCode value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_RadioProfileSetting_ErrorCode_BandNotSupported",
        "TUN_MSTR_RadioProfileSetting_ErrorCode_InvalidFrequency",
        "TUN_MSTR_RadioProfileSetting_ErrorCode_PresetNotConfigured",
        "TUN_MSTR_RadioProfileSetting_ErrorCode_InvalidSID_EnsembleID",
        "TUN_MSTR_RadioProfileSetting_ErrorCode_Unknown",
        "TUN_MSTR_RadioProfileSetting_ErrorCode_None",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_TunMstr_RadioProfileSetting_ErrorCode_IsValid (T_e8_TunMstr_RadioProfileSetting_ErrorCode value)
{
    switch (value) {
    case T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_BandNotSupported:
    case T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_InvalidFrequency:
    case T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_PresetNotConfigured:
    case T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_InvalidSID_EnsembleID:
    case T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_Unknown:
    case T_e8_TunMstr_RadioProfileSetting_ErrorCode__TUN_MSTR_RadioProfileSetting_ErrorCode_None:
        return true;
    default:
        return false;
    }
}

bool T_e8_List_Parse (const char *str, size_t length, T_e8_List &value)
{
    static stringEntry entries[] = {
        {8,"BANK_FM1", 0U},
        {8,"BANK_FM2", 1U},
        {8,"BANK_FM3", 2U},
        {9,"BANK_DAB1", 13U},
        {9,"BANK_DAB2", 14U},
        {9,"BANK_DAB3", 15U},
        {9,"BANK_DRM1", 21U},
        {9,"BANK_MIX1", 17U},
        {9,"BANK_MIX2", 18U},
        {9,"BANK_MIX3", 19U},
        {9,"BANK_NONE", 255U},
        {10,"BANK_FMAST", 3U},
        {11,"BANK_AM_AST", 12U},
        {11,"BANK_AM_LW1", 8U},
        {11,"BANK_AM_LW2", 9U},
        {11,"BANK_AM_LW3", 10U},
        {11,"BANK_AM_MW1", 4U},
        {11,"BANK_AM_MW2", 5U},
        {11,"BANK_AM_MW3", 6U},
        {11,"BANK_DABAST", 16U},
        {12,"BANK_DRM_AST", 22U},
        {12,"BANK_MIX_AST", 20U},
        {13,"BANK_AM_LWAST", 11U},
        {13,"BANK_AM_MWAST", 7U},
    };

    return lookupInStringEntryTable (str, length, entries, 24, (unsigned int&) value);
}

const char* T_e8_List_Name (T_e8_List value)
{
    static const char* enumerationLiterals[] = {
        "BANK_FM1",
        "BANK_FM2",
        "BANK_FM3",
        "BANK_FMAST",
        "BANK_AM_MW1",
        "BANK_AM_MW2",
        "BANK_AM_MW3",
        "BANK_AM_MWAST",
        "BANK_AM_LW1",
        "BANK_AM_LW2",
        "BANK_AM_LW3",
        "BANK_AM_LWAST",
        "BANK_AM_AST",
        "BANK_DAB1",
        "BANK_DAB2",
        "BANK_DAB3",
        "BANK_DABAST",
        "BANK_MIX1",
        "BANK_MIX2",
        "BANK_MIX3",
        "BANK_MIX_AST",
        "BANK_DRM1",
        "BANK_DRM_AST",
        "BANK_NONE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 24, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_List_IsValid (T_e8_List value)
{
    switch (value) {
    case T_e8_List__BANK_FM1:
    case T_e8_List__BANK_FM2:
    case T_e8_List__BANK_FM3:
    case T_e8_List__BANK_FMAST:
    case T_e8_List__BANK_AM_MW1:
    case T_e8_List__BANK_AM_MW2:
    case T_e8_List__BANK_AM_MW3:
    case T_e8_List__BANK_AM_MWAST:
    case T_e8_List__BANK_AM_LW1:
    case T_e8_List__BANK_AM_LW2:
    case T_e8_List__BANK_AM_LW3:
    case T_e8_List__BANK_AM_LWAST:
    case T_e8_List__BANK_AM_AST:
    case T_e8_List__BANK_DAB1:
    case T_e8_List__BANK_DAB2:
    case T_e8_List__BANK_DAB3:
    case T_e8_List__BANK_DABAST:
    case T_e8_List__BANK_MIX1:
    case T_e8_List__BANK_MIX2:
    case T_e8_List__BANK_MIX3:
    case T_e8_List__BANK_MIX_AST:
    case T_e8_List__BANK_DRM1:
    case T_e8_List__BANK_DRM_AST:
    case T_e8_List__BANK_NONE:
        return true;
    default:
        return false;
    }
}

bool T_e8_AntennaTest_Parse (const char *str, size_t length, T_e8_AntennaTest &value)
{
    static stringEntry entries[] = {
        {11,"GPS_ANTENNA", 3U},
        {12,"DAB_ANTENNA1", 2U},
        {12,"DAB_ANTENNA2", 8U},
        {12,"DTV_ANTENNA1", 4U},
        {12,"DTV_ANTENNA2", 5U},
        {12,"DTV_ANTENNA3", 6U},
        {12,"DTV_ANTENNA4", 7U},
        {13,"AMFM_ANTENNA1", 0U},
        {13,"AMFM_ANTENNA2", 1U},
        {15,"UNKNOWN_ANTENNA", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_AntennaTest_Name (T_e8_AntennaTest value)
{
    static const char* enumerationLiterals[] = {
        "AMFM_Antenna1",
        "AMFM_Antenna2",
        "DAB_Antenna1",
        "GPS_Antenna",
        "DTV_Antenna1",
        "DTV_Antenna2",
        "DTV_Antenna3",
        "DTV_Antenna4",
        "DAB_Antenna2",
        "Unknown_Antenna",
    };

    if (T_e8_AntennaTest_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AntennaTest_IsValid (T_e8_AntennaTest value)
{
    switch (value) {
    case T_e8_AntennaTest__AMFM_Antenna1:
    case T_e8_AntennaTest__AMFM_Antenna2:
    case T_e8_AntennaTest__DAB_Antenna1:
    case T_e8_AntennaTest__GPS_Antenna:
    case T_e8_AntennaTest__DTV_Antenna1:
    case T_e8_AntennaTest__DTV_Antenna2:
    case T_e8_AntennaTest__DTV_Antenna3:
    case T_e8_AntennaTest__DTV_Antenna4:
    case T_e8_AntennaTest__DAB_Antenna2:
    case T_e8_AntennaTest__Unknown_Antenna:
        return true;
    default:
        return false;
    }
}

bool T_e8_RFAntenna_Parse (const char *str, size_t length, T_e8_RFAntenna &value)
{
    static stringEntry entries[] = {
        {28,"TUN_MSTR_RF_ANTENNA_STATE_OK", 1U},
        {30,"TUN_MSTR_RF_ANTENNA_STATE_OPEN", 2U},
        {31,"TUN_MSTR_RF_ANTENNA_STATE_SHORT", 3U},
        {33,"TUN_MSTR_RF_ANTENNA_STATE_PASSIVE", 8U},
        {33,"TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN", 0U},
        {37,"TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED", 4U},
        {40,"TUN_MSTR_RF_ANTENNA_STATE_NUMBER_OF_ITEM", 9U},
        {40,"TUN_MSTR_RF_ANTENNA_STATE_OPEN_AMPLIFIER", 7U},
        {44,"TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_LOW_VG", 5U},
        {45,"TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_HIGH_VG", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 10, (unsigned int&) value);
}

const char* T_e8_RFAntenna_Name (T_e8_RFAntenna value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN",
        "TUN_MSTR_RF_ANTENNA_STATE_OK",
        "TUN_MSTR_RF_ANTENNA_STATE_OPEN",
        "TUN_MSTR_RF_ANTENNA_STATE_SHORT",
        "TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED",
        "TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_LOW_VG",
        "TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_HIGH_VG",
        "TUN_MSTR_RF_ANTENNA_STATE_OPEN_AMPLIFIER",
        "TUN_MSTR_RF_ANTENNA_STATE_PASSIVE",
        "TUN_MSTR_RF_ANTENNA_STATE_NUMBER_OF_ITEM",
    };

    if (T_e8_RFAntenna_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RFAntenna_IsValid (T_e8_RFAntenna value)
{
    switch (value) {
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_OK:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_OPEN:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_SHORT:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_LOW_VG:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_DEACTIVATED_HIGH_VG:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_OPEN_AMPLIFIER:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_PASSIVE:
    case T_e8_RFAntenna__TUN_MSTR_RF_ANTENNA_STATE_NUMBER_OF_ITEM:
        return true;
    default:
        return false;
    }
}

bool T_e8_RequestResult_Parse (const char *str, size_t length, T_e8_RequestResult &value)
{
    static stringEntry entries[] = {
        {25,"TUN_MSTR_REQUEST_ACCEPTED", 1U},
        {25,"TUN_MSTR_REQUEST_REJECTED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_RequestResult_Name (T_e8_RequestResult value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_REQUEST_REJECTED",
        "TUN_MSTR_REQUEST_ACCEPTED",
    };

    if (T_e8_RequestResult_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_RequestResult_IsValid (T_e8_RequestResult value)
{
    switch (value) {
    case T_e8_RequestResult__TUN_MSTR_REQUEST_REJECTED:
    case T_e8_RequestResult__TUN_MSTR_REQUEST_ACCEPTED:
        return true;
    default:
        return false;
    }
}

bool T_e8_AST_Types_Parse (const char *str, size_t length, T_e8_AST_Types &value)
{
    static stringEntry entries[] = {
        {10,"NORMAL_AST", 0U},
        {11,"INITIAL_AST", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_AST_Types_Name (T_e8_AST_Types value)
{
    static const char* enumerationLiterals[] = {
        "NORMAL_AST",
        "INITIAL_AST",
    };

    if (T_e8_AST_Types_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_AST_Types_IsValid (T_e8_AST_Types value)
{
    switch (value) {
    case T_e8_AST_Types__NORMAL_AST:
    case T_e8_AST_Types__INITIAL_AST:
        return true;
    default:
        return false;
    }
}

bool T_e8_HDAudioProgram_Parse (const char *str, size_t length, T_e8_HDAudioProgram &value)
{
    static stringEntry entries[] = {
        {26,"TUN_MSTR_AUDIO_PROGRAM_ONE", 0U},
        {26,"TUN_MSTR_AUDIO_PROGRAM_SIX", 5U},
        {26,"TUN_MSTR_AUDIO_PROGRAM_TWO", 1U},
        {27,"TUN_MSTR_AUDIO_PROGRAM_FIVE", 4U},
        {27,"TUN_MSTR_AUDIO_PROGRAM_FOUR", 3U},
        {28,"TUN_MSTR_AUDIO_PROGRAM_EIGHT", 7U},
        {28,"TUN_MSTR_AUDIO_PROGRAM_SEVEN", 6U},
        {28,"TUN_MSTR_AUDIO_PROGRAM_THREE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_HDAudioProgram_Name (T_e8_HDAudioProgram value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_AUDIO_PROGRAM_ONE",
        "TUN_MSTR_AUDIO_PROGRAM_TWO",
        "TUN_MSTR_AUDIO_PROGRAM_THREE",
        "TUN_MSTR_AUDIO_PROGRAM_FOUR",
        "TUN_MSTR_AUDIO_PROGRAM_FIVE",
        "TUN_MSTR_AUDIO_PROGRAM_SIX",
        "TUN_MSTR_AUDIO_PROGRAM_SEVEN",
        "TUN_MSTR_AUDIO_PROGRAM_EIGHT",
    };

    if (T_e8_HDAudioProgram_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_HDAudioProgram_IsValid (T_e8_HDAudioProgram value)
{
    switch (value) {
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_ONE:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_TWO:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_THREE:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_FOUR:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_FIVE:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_SIX:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_SEVEN:
    case T_e8_HDAudioProgram__TUN_MSTR_AUDIO_PROGRAM_EIGHT:
        return true;
    default:
        return false;
    }
}

bool T_e8_ModulationType_Parse (const char *str, size_t length, T_e8_ModulationType &value)
{
    static stringEntry entries[] = {
        {21,"TUN_MSTR_INVALID_TYPE", 255U},
        {22,"TUN_MSTR_MODULATION_HD", 1U},
        {23,"TUN_MSTR_MODULATION_DRM", 2U},
        {26,"TUN_MSTR_MODULATION_ANALOG", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_ModulationType_Name (T_e8_ModulationType value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_MODULATION_ANALOG",
        "TUN_MSTR_MODULATION_HD",
        "TUN_MSTR_MODULATION_DRM",
        "TUN_MSTR_INVALID_TYPE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_ModulationType_IsValid (T_e8_ModulationType value)
{
    switch (value) {
    case T_e8_ModulationType__TUN_MSTR_MODULATION_ANALOG:
    case T_e8_ModulationType__TUN_MSTR_MODULATION_HD:
    case T_e8_ModulationType__TUN_MSTR_MODULATION_DRM:
    case T_e8_ModulationType__TUN_MSTR_INVALID_TYPE:
        return true;
    default:
        return false;
    }
}

bool T_e8_HDTextEncoding_Parse (const char *str, size_t length, T_e8_HDTextEncoding &value)
{
    static stringEntry entries[] = {
        {17,"TUN_MSTR_RESERVED", 1U},
        {21,"TUN_MSTR_INVALID_TYPE", 255U},
        {28,"TUN_MSTR_ISO_IEC_8859_1_1998", 0U},
        {35,"TUN_MSTR_ISO_IEC_10646_1_2000_UCS_2", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_HDTextEncoding_Name (T_e8_HDTextEncoding value)
{
    static const char* enumerationLiterals[] = {
        "TUN_MSTR_ISO_IEC_8859_1_1998",
        "TUN_MSTR_RESERVED",
        "TUN_MSTR_ISO_IEC_10646_1_2000_UCS_2",
        "TUN_MSTR_INVALID_TYPE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 4, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_HDTextEncoding_IsValid (T_e8_HDTextEncoding value)
{
    switch (value) {
    case T_e8_HDTextEncoding__TUN_MSTR_ISO_IEC_8859_1_1998:
    case T_e8_HDTextEncoding__TUN_MSTR_ISO_IEC_10646_1_2000_UCS_2:
    case T_e8_HDTextEncoding__TUN_MSTR_RESERVED:
    case T_e8_HDTextEncoding__TUN_MSTR_INVALID_TYPE:
        return true;
    default:
        return false;
    }
}

bool T_e8_Graphics_Parse (const char *str, size_t length, T_e8_Graphics &value)
{
    static stringEntry entries[] = {
        {22,"GRAPHICS_NEEDS_DEFAULT", 2U},
        {22,"GRAPHICS_NEEDS_REFRESH", 1U},
        {24,"GRAPHICS_NEEDS_NOREFRESH", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_Graphics_Name (T_e8_Graphics value)
{
    static const char* enumerationLiterals[] = {
        "GRAPHICS_NEEDS_NOREFRESH",
        "GRAPHICS_NEEDS_REFRESH",
        "GRAPHICS_NEEDS_DEFAULT",
    };

    if (T_e8_Graphics_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_Graphics_IsValid (T_e8_Graphics value)
{
    switch (value) {
    case T_e8_Graphics__GRAPHICS_NEEDS_NOREFRESH:
    case T_e8_Graphics__GRAPHICS_NEEDS_REFRESH:
    case T_e8_Graphics__GRAPHICS_NEEDS_DEFAULT:
        return true;
    default:
        return false;
    }
}

bool T_e8_PresetType_Parse (const char *str, size_t length, T_e8_PresetType &value)
{
    static stringEntry entries[] = {
        {4,"SHOW", 2U},
        {7,"EPISODE", 4U},
        {7,"INVALID", 0U},
        {10,"SPORTSTEAM", 3U},
        {11,"LIVECHANNEL", 1U},
        {18,"ARTISTRADIOCHANNEL", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_PresetType_Name (T_e8_PresetType value)
{
    static const char* enumerationLiterals[] = {
        "Invalid",
        "LiveChannel",
        "Show",
        "SportsTeam",
        "Episode",
        "ArtistRadioChannel",
    };

    if (T_e8_PresetType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_PresetType_IsValid (T_e8_PresetType value)
{
    switch (value) {
    case T_e8_PresetType__Invalid:
    case T_e8_PresetType__LiveChannel:
    case T_e8_PresetType__Show:
    case T_e8_PresetType__SportsTeam:
    case T_e8_PresetType__Episode:
    case T_e8_PresetType__ArtistRadioChannel:
        return true;
    default:
        return false;
    }
}

bool T_e8_PSFreeze_Mode_Parse (const char *str, size_t length, T_e8_PSFreeze_Mode &value)
{
    static stringEntry entries[] = {
        {6,"FREEZE", 0U},
        {8,"UNFREEZE", 1U},
        {12,"INVALID_TYPE", 255U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_PSFreeze_Mode_Name (T_e8_PSFreeze_Mode value)
{
    static const char* enumerationLiterals[] = {
        "FREEZE",
        "UNFREEZE",
        "INVALID_TYPE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 3, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_PSFreeze_Mode_IsValid (T_e8_PSFreeze_Mode value)
{
    switch (value) {
    case T_e8_PSFreeze_Mode__FREEZE:
    case T_e8_PSFreeze_Mode__UNFREEZE:
    case T_e8_PSFreeze_Mode__INVALID_TYPE:
        return true;
    default:
        return false;
    }
}

bool T_e8_Preset_Action_Parse (const char *str, size_t length, T_e8_Preset_Action &value)
{
    static stringEntry entries[] = {
        {16,"TUNMSTR_PRESETUP", 8U},
        {17,"TUNMSTR_GETPRESET", 5U},
        {18,"TUNMSTR_PRESETDOWN", 9U},
        {18,"TUNMSTR_PRESETSAVE", 1U},
        {20,"TUNMSTR_PRESETRECALL", 0U},
        {21,"TUNMSTR_GETPRESETLIST", 6U},
        {24,"TUNMSTR_PRESETDELETE_ALL", 3U},
        {24,"TUNMSTR_PRESETDELETE_ONE", 2U},
        {25,"TUNMSTR_SPECIALPRESETSAVE", 4U},
        {27,"TUNMSTR_PRESETPROFILEUPDATE", 7U},
        {28,"TUNMSTR_PRESETACTION_INVALID", 255U},
        {29,"TUNMSTR_PRESETDELETE_MULTIPLE", 10U},
    };

    return lookupInStringEntryTable (str, length, entries, 12, (unsigned int&) value);
}

const char* T_e8_Preset_Action_Name (T_e8_Preset_Action value)
{
    static const char* enumerationLiterals[] = {
        "TUNMSTR_PresetRecall",
        "TUNMSTR_PresetSave",
        "TUNMSTR_PresetDelete_One",
        "TUNMSTR_PresetDelete_ALL",
        "TUNMSTR_SpecialPresetSave",
        "TUNMSTR_GetPreset",
        "TUNMSTR_GetPresetList",
        "TUNMSTR_PresetProfileUpdate",
        "TUNMSTR_PresetUp",
        "TUNMSTR_PresetDown",
        "TUNMSTR_PresetDelete_Multiple",
        "TUNMSTR_PresetAction_Invalid",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 12, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_Preset_Action_IsValid (T_e8_Preset_Action value)
{
    switch (value) {
    case T_e8_Preset_Action__TUNMSTR_PresetRecall:
    case T_e8_Preset_Action__TUNMSTR_PresetSave:
    case T_e8_Preset_Action__TUNMSTR_PresetDelete_One:
    case T_e8_Preset_Action__TUNMSTR_PresetDelete_ALL:
    case T_e8_Preset_Action__TUNMSTR_SpecialPresetSave:
    case T_e8_Preset_Action__TUNMSTR_GetPreset:
    case T_e8_Preset_Action__TUNMSTR_GetPresetList:
    case T_e8_Preset_Action__TUNMSTR_PresetProfileUpdate:
    case T_e8_Preset_Action__TUNMSTR_PresetUp:
    case T_e8_Preset_Action__TUNMSTR_PresetDown:
    case T_e8_Preset_Action__TUNMSTR_PresetDelete_Multiple:
    case T_e8_Preset_Action__TUNMSTR_PresetAction_Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_StationSelection_Option_Parse (const char *str, size_t length, T_e8_StationSelection_Option &value)
{
    static stringEntry entries[] = {
        {12,"PRESET_INPUT", 1U},
        {15,"FREQUENCY_INPUT", 0U},
        {17,"STATIONNAME_INPUT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_StationSelection_Option_Name (T_e8_StationSelection_Option value)
{
    static const char* enumerationLiterals[] = {
        "Frequency_Input",
        "Preset_Input",
        "StationName_Input",
    };

    if (T_e8_StationSelection_Option_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_StationSelection_Option_IsValid (T_e8_StationSelection_Option value)
{
    switch (value) {
    case T_e8_StationSelection_Option__Frequency_Input:
    case T_e8_StationSelection_Option__Preset_Input:
    case T_e8_StationSelection_Option__StationName_Input:
        return true;
    default:
        return false;
    }
}

bool T_e8_AnnoTypes_Parse (const char *str, size_t length, T_e8_AnnoTypes &value)
{
    static stringEntry entries[] = {
        {19,"TUNMSTR_ANNOTYPE_TA", 1U},
        {21,"TUNMSTR_ANNOTYPE_NEWS", 5U},
        {22,"TUNMSTR_ANNOTYPE_EVENT", 7U},
        {22,"TUNMSTR_ANNOTYPE_OTHER", 2U},
        {22,"TUNMSTR_ANNOTYPE_PTY31", 0U},
        {22,"TUNMSTR_ANNOTYPE_SPORT", 10U},
        {24,"TUNMSTR_ANNOTYPE_FINANCE", 11U},
        {24,"TUNMSTR_ANNOTYPE_INVALID", 255U},
        {24,"TUNMSTR_ANNOTYPE_WARNING", 4U},
        {24,"TUNMSTR_ANNOTYPE_WEATHER", 6U},
        {26,"TUNMSTR_ANNOTYPE_PROGRAMME", 9U},
        {26,"TUNMSTR_ANNOTYPE_TRANSPORT", 3U},
        {29,"TUNMSTR_ANNOTYPE_SPECIALEVENT", 8U},
        {30,"TUNMSTR_ANNOTYPE_WEATHER_ALERT", 12U},
    };

    return lookupInStringEntryTable (str, length, entries, 14, (unsigned int&) value);
}

const char* T_e8_AnnoTypes_Name (T_e8_AnnoTypes value)
{
    static const char* enumerationLiterals[] = {
        "TUNMSTR_ANNOTYPE_PTY31",
        "TUNMSTR_ANNOTYPE_TA",
        "TUNMSTR_ANNOTYPE_OTHER",
        "TUNMSTR_ANNOTYPE_TRANSPORT",
        "TUNMSTR_ANNOTYPE_WARNING",
        "TUNMSTR_ANNOTYPE_NEWS",
        "TUNMSTR_ANNOTYPE_WEATHER",
        "TUNMSTR_ANNOTYPE_EVENT",
        "TUNMSTR_ANNOTYPE_SPECIALEVENT",
        "TUNMSTR_ANNOTYPE_PROGRAMME",
        "TUNMSTR_ANNOTYPE_SPORT",
        "TUNMSTR_ANNOTYPE_FINANCE",
        "TUNMSTR_ANNOTYPE_WEATHER_ALERT",
        "TUNMSTR_ANNOTYPE_INVALID",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 14, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_AnnoTypes_IsValid (T_e8_AnnoTypes value)
{
    switch (value) {
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_PTY31:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_TA:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_OTHER:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_TRANSPORT:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_WARNING:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_NEWS:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_WEATHER:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_EVENT:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_SPECIALEVENT:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_PROGRAMME:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_SPORT:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_FINANCE:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_WEATHER_ALERT:
    case T_e8_AnnoTypes__TUNMSTR_ANNOTYPE_INVALID:
        return true;
    default:
        return false;
    }
}

bool T_e8_TunerAvailability_Parse (const char *str, size_t length, T_e8_TunerAvailability &value)
{
    static stringEntry entries[] = {
        {30,"TUNMSTR_FM_TUNER_NOW_AVAILABLE", 0U},
        {31,"TUNMSTR_DAB_TUNER_NOW_AVAILABLE", 1U},
        {32,"TUNMSTR_BOTH_TUNER_NOT_AVAILABLE", 2U},
        {32,"TUNMSTR_BOTH_TUNER_NOW_AVAILABLE", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_TunerAvailability_Name (T_e8_TunerAvailability value)
{
    static const char* enumerationLiterals[] = {
        "TUNMSTR_FM_TUNER_NOW_AVAILABLE",
        "TUNMSTR_DAB_TUNER_NOW_AVAILABLE",
        "TUNMSTR_BOTH_TUNER_NOT_AVAILABLE",
        "TUNMSTR_BOTH_TUNER_NOW_AVAILABLE",
    };

    if (T_e8_TunerAvailability_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TunerAvailability_IsValid (T_e8_TunerAvailability value)
{
    switch (value) {
    case T_e8_TunerAvailability__TUNMSTR_FM_TUNER_NOW_AVAILABLE:
    case T_e8_TunerAvailability__TUNMSTR_DAB_TUNER_NOW_AVAILABLE:
    case T_e8_TunerAvailability__TUNMSTR_BOTH_TUNER_NOT_AVAILABLE:
    case T_e8_TunerAvailability__TUNMSTR_BOTH_TUNER_NOW_AVAILABLE:
        return true;
    default:
        return false;
    }
}

bool T_e8_StationType_Parse (const char *str, size_t length, T_e8_StationType &value)
{
    static stringEntry entries[] = {
        {22,"TUNMSTR_STATIONTYPE_FM", 1U},
        {23,"TUNMSTR_STATIONTYPE_DAB", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_StationType_Name (T_e8_StationType value)
{
    static const char* enumerationLiterals[] = {
        "TUNMSTR_StationType_DAB",
        "TUNMSTR_StationType_FM",
    };

    if (T_e8_StationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_StationType_IsValid (T_e8_StationType value)
{
    switch (value) {
    case T_e8_StationType__TUNMSTR_StationType_DAB:
    case T_e8_StationType__TUNMSTR_StationType_FM:
        return true;
    default:
        return false;
    }
}

bool T_e8_TunMst_RadioType_Parse (const char *str, size_t length, T_e8_TunMst_RadioType &value)
{
    static stringEntry entries[] = {
        {12,"RADIOTYPE_AM", 3U},
        {12,"RADIOTYPE_FM", 2U},
        {13,"RADIOTYPE_DAB", 1U},
        {13,"RADIOTYPE_DRM", 7U},
        {13,"RADIOTYPE_SXM", 4U},
        {14,"RADIOTYPE_AMHD", 5U},
        {14,"RADIOTYPE_FMHD", 6U},
        {14,"RADIOTYPE_NONE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 8, (unsigned int&) value);
}

const char* T_e8_TunMst_RadioType_Name (T_e8_TunMst_RadioType value)
{
    static const char* enumerationLiterals[] = {
        "RadioType_None",
        "RadioType_DAB",
        "RadioType_FM",
        "RadioType_AM",
        "RadioType_SXM",
        "RadioType_AMHD",
        "RadioType_FMHD",
        "RadioType_DRM",
    };

    if (T_e8_TunMst_RadioType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TunMst_RadioType_IsValid (T_e8_TunMst_RadioType value)
{
    switch (value) {
    case T_e8_TunMst_RadioType__RadioType_None:
    case T_e8_TunMst_RadioType__RadioType_DAB:
    case T_e8_TunMst_RadioType__RadioType_FM:
    case T_e8_TunMst_RadioType__RadioType_AM:
    case T_e8_TunMst_RadioType__RadioType_SXM:
    case T_e8_TunMst_RadioType__RadioType_AMHD:
    case T_e8_TunMst_RadioType__RadioType_FMHD:
    case T_e8_TunMst_RadioType__RadioType_DRM:
        return true;
    default:
        return false;
    }
}

bool T_e8_TunerErrorType_Parse (const char *str, size_t length, T_e8_TunerErrorType &value)
{
    static stringEntry entries[] = {
        {19,"MESSAGENOTSUPPORTED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* T_e8_TunerErrorType_Name (T_e8_TunerErrorType value)
{
    static const char* enumerationLiterals[] = {
        "Messagenotsupported",
    };

    if (T_e8_TunerErrorType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TunerErrorType_IsValid (T_e8_TunerErrorType value)
{
    switch (value) {
    case T_e8_TunerErrorType__Messagenotsupported:
        return true;
    default:
        return false;
    }
}

bool T_e8SXMChannelArtErrorTypes_Parse (const char *str, size_t length, T_e8SXMChannelArtErrorTypes &value)
{
    static stringEntry entries[] = {
        {24,"CHANNELART_SERVICE_ERROR", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 1, (unsigned int&) value);
}

const char* T_e8SXMChannelArtErrorTypes_Name (T_e8SXMChannelArtErrorTypes value)
{
    static const char* enumerationLiterals[] = {
        "CHANNELART_SERVICE_ERROR",
    };

    if (T_e8SXMChannelArtErrorTypes_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8SXMChannelArtErrorTypes_IsValid (T_e8SXMChannelArtErrorTypes value)
{
    switch (value) {
    case T_e8SXMChannelArtErrorTypes__CHANNELART_SERVICE_ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_SXMSystemMessage_Parse (const char *str, size_t length, T_e8_SXMSystemMessage &value)
{
    static stringEntry entries[] = {
        {25,"XMTUN_SYSTEM_MSG_NO_ERROR", 0U},
        {26,"XMTUN_SYSTEM_MSG_NO_SIGNAL", 10U},
        {27,"XMTUN_SYSTEM_MSG_LOADING_XM", 1U},
        {31,"XMTUN_SYSTEM_MSG_CHANNEL_LOCKED", 7U},
        {31,"XMTUN_SYSTEM_MSG_CHANNEL_MATURE", 6U},
        {31,"XMTUN_SYSTEM_MSG_CHANNEL_OFFAIR", 3U},
        {31,"XMTUN_SYSTEM_MSG_HARDWARE_ERROR", 11U},
        {33,"XMTUN_SYSTEM_MSG_SXM_INITIALIZING", 12U},
        {35,"XMTUN_SYSTEM_MSG_CATEGORY_NOT_FOUND", 2U},
        {36,"XMTUN_SYSTEM_MSG_CHANNEL_UNAVAILABLE", 4U},
        {37,"XMTUN_SYSTEM_MSG_ANTENNA_DISCONNECTED", 9U},
        {37,"XMTUN_SYSTEM_MSG_CHANNEL_UNAUTHORIZED", 5U},
        {37,"XMTUN_SYSTEM_MSG_SUBSCRIPTION_UPDATED", 8U},
    };

    return lookupInStringEntryTable (str, length, entries, 13, (unsigned int&) value);
}

const char* T_e8_SXMSystemMessage_Name (T_e8_SXMSystemMessage value)
{
    static const char* enumerationLiterals[] = {
        "XMTUN_SYSTEM_MSG_NO_ERROR",
        "XMTUN_SYSTEM_MSG_LOADING_XM",
        "XMTUN_SYSTEM_MSG_CATEGORY_NOT_FOUND",
        "XMTUN_SYSTEM_MSG_CHANNEL_OFFAIR",
        "XMTUN_SYSTEM_MSG_CHANNEL_UNAVAILABLE",
        "XMTUN_SYSTEM_MSG_CHANNEL_UNAUTHORIZED",
        "XMTUN_SYSTEM_MSG_CHANNEL_MATURE",
        "XMTUN_SYSTEM_MSG_CHANNEL_LOCKED",
        "XMTUN_SYSTEM_MSG_SUBSCRIPTION_UPDATED",
        "XMTUN_SYSTEM_MSG_ANTENNA_DISCONNECTED",
        "XMTUN_SYSTEM_MSG_NO_SIGNAL",
        "XMTUN_SYSTEM_MSG_HARDWARE_ERROR",
        "XMTUN_SYSTEM_MSG_SXM_INITIALIZING",
    };

    if (T_e8_SXMSystemMessage_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_SXMSystemMessage_IsValid (T_e8_SXMSystemMessage value)
{
    switch (value) {
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_NO_ERROR:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_LOADING_XM:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_CATEGORY_NOT_FOUND:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_CHANNEL_OFFAIR:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_CHANNEL_UNAVAILABLE:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_CHANNEL_UNAUTHORIZED:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_CHANNEL_MATURE:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_CHANNEL_LOCKED:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_SUBSCRIPTION_UPDATED:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_ANTENNA_DISCONNECTED:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_NO_SIGNAL:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_HARDWARE_ERROR:
    case T_e8_SXMSystemMessage__XMTUN_SYSTEM_MSG_SXM_INITIALIZING:
        return true;
    default:
        return false;
    }
}

bool T_ProfileStatus_Parse (const char *str, size_t length, T_ProfileStatus &value)
{
    static stringEntry entries[] = {
        {4,"IDLE", 0U},
        {5,"RESET", 3U},
        {7,"CHANGED", 2U},
        {7,"PREPARE", 1U},
        {8,"DOWNLOAD", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_ProfileStatus_Name (T_ProfileStatus value)
{
    static const char* enumerationLiterals[] = {
        "Idle",
        "Prepare",
        "Changed",
        "Reset",
        "Download",
    };

    if (T_ProfileStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_ProfileStatus_IsValid (T_ProfileStatus value)
{
    switch (value) {
    case T_ProfileStatus__Idle:
    case T_ProfileStatus__Prepare:
    case T_ProfileStatus__Changed:
    case T_ProfileStatus__Reset:
    case T_ProfileStatus__Download:
        return true;
    default:
        return false;
    }
}

bool T_ProfileAction_Parse (const char *str, size_t length, T_ProfileAction &value)
{
    static stringEntry entries[] = {
        {10,"DATACHANGE", 1U},
        {11,"COPYPROFILE", 2U},
        {13,"ACTIVEPROFILE", 0U},
        {13,"DELETEPROFILE", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_ProfileAction_Name (T_ProfileAction value)
{
    static const char* enumerationLiterals[] = {
        "ActiveProfile",
        "DataChange",
        "CopyProfile",
        "DeleteProfile",
    };

    if (T_ProfileAction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_ProfileAction_IsValid (T_ProfileAction value)
{
    switch (value) {
    case T_ProfileAction__ActiveProfile:
    case T_ProfileAction__DataChange:
    case T_ProfileAction__CopyProfile:
    case T_ProfileAction__DeleteProfile:
        return true;
    default:
        return false;
    }
}

bool T_ProfileActionStatus_Parse (const char *str, size_t length, T_ProfileActionStatus &value)
{
    static stringEntry entries[] = {
        {6,"FAILED", 0U},
        {7,"SUCCESS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_ProfileActionStatus_Name (T_ProfileActionStatus value)
{
    static const char* enumerationLiterals[] = {
        "Failed",
        "Success",
    };

    if (T_ProfileActionStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_ProfileActionStatus_IsValid (T_ProfileActionStatus value)
{
    switch (value) {
    case T_ProfileActionStatus__Failed:
    case T_ProfileActionStatus__Success:
        return true;
    default:
        return false;
    }
}

} // namespace midw_tunermaster_fi_types
