/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "midw_tuner_fi_types.h"
#include "midw_tuner_fi_typesCca.h"
#include "midw_tuner_fi_typesConst.h"
#include <string>
#include <vector>


void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_AFSwitch& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getRDS_AFBEST()) {
        bitmask |= (1 << 0);
    }
    if (in.getUnused()) {
        bitmask |= (1 << 1);
    }
    if (in.getDRM_AFBEST()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_AFSwitch& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o0;
    in >> o0;
    uint8 bitmask(o0);

    if (bitmask & (1 << 0)) {
        out.setRDS_AFBEST (true);
    }
    if (bitmask & (1 << 1)) {
        out.setUnused (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDRM_AFBEST (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_AudioSink& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getUSR1_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 0);
    }
    if (in.getTA_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 1);
    }
    if (in.getTIM_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 2);
    }
    if (in.getPTY_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 3);
    }
    if (in.getNEWS_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 4);
    }
    if (in.getDABTEMP_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 5);
    }
    if (in.getTEMPFM_SWITCHED_TUN_TOFG()) {
        bitmask |= (1 << 6);
    }
    if (in.getRESERVED1()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_AudioSink& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o1;
    in >> o1;
    uint8 bitmask(o1);

    if (bitmask & (1 << 0)) {
        out.setUSR1_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTA_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTIM_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 3)) {
        out.setPTY_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 4)) {
        out.setNEWS_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDABTEMP_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 6)) {
        out.setTEMPFM_SWITCHED_TUN_TOFG (true);
    }
    if (bitmask & (1 << 7)) {
        out.setRESERVED1 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_AtStationInfoBits& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getMONO_OR_STEREO_BIT()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPEECH_OR_MUSIC_BIT()) {
        bitmask |= (1 << 1);
    }
    if (in.getRADIOTEXT_POSSIBLE_BIT()) {
        bitmask |= (1 << 2);
    }
    if (in.getALTERNATE_FREQUENCY_BIT()) {
        bitmask |= (1 << 3);
    }
    if (in.getRADIOTEXT_AVAILABLE_BIT()) {
        bitmask |= (1 << 4);
    }
    if (in.getAF_AVAILABLE_BIT()) {
        bitmask |= (1 << 5);
    }
    if (in.getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE()) {
        bitmask |= (1 << 6);
    }
    if (in.getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_AtStationInfoBits& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o2;
    in >> o2;
    uint8 bitmask(o2);

    if (bitmask & (1 << 0)) {
        out.setMONO_OR_STEREO_BIT (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPEECH_OR_MUSIC_BIT (true);
    }
    if (bitmask & (1 << 2)) {
        out.setRADIOTEXT_POSSIBLE_BIT (true);
    }
    if (bitmask & (1 << 3)) {
        out.setALTERNATE_FREQUENCY_BIT (true);
    }
    if (bitmask & (1 << 4)) {
        out.setRADIOTEXT_AVAILABLE_BIT (true);
    }
    if (bitmask & (1 << 5)) {
        out.setAF_AVAILABLE_BIT (true);
    }
    if (bitmask & (1 << 6)) {
        out.setHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE (true);
    }
    if (bitmask & (1 << 7)) {
        out.setMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_Tunerbandbits& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDDAMASTER_OR_NOT_A_DDAMASTER()) {
        bitmask |= (1 << 0);
    }
    if (in.getDDASLAVE_OR_NOT_A_DDASLAVE()) {
        bitmask |= (1 << 1);
    }
    if (in.getFM_SUPPORTED_OR_FM_NOTSUPPORTED()) {
        bitmask |= (1 << 2);
    }
    if (in.getAM_SUPPORTED_OR_AM_NOTSUPPORTED()) {
        bitmask |= (1 << 3);
    }
    if (in.getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED()) {
        bitmask |= (1 << 4);
    }
    if (in.getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED()) {
        bitmask |= (1 << 5);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_Tunerbandbits& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o3;
    in >> o3;
    uint8 bitmask(o3);

    if (bitmask & (1 << 0)) {
        out.setDDAMASTER_OR_NOT_A_DDAMASTER (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDDASLAVE_OR_NOT_A_DDASLAVE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setFM_SUPPORTED_OR_FM_NOTSUPPORTED (true);
    }
    if (bitmask & (1 << 3)) {
        out.setAM_SUPPORTED_OR_AM_NOTSUPPORTED (true);
    }
    if (bitmask & (1 << 4)) {
        out.setDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED (true);
    }
    if (bitmask & (1 << 5)) {
        out.setDABL_SUPPORTED_OR_DABL_NOTSUPPORTED (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_Audio_FG_BG& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8SubCommand();
    out << (uint8) in.getU8AudioSink();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Audio_FG_BG& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o4;
    in >> o4;
    out.setU8SubCommand((::midw_tuner_fi_types::T_e8_Tun_SubCommand)o4);
    uint8 o5;
    in >> o5;
    out.setU8AudioSink((::midw_tuner_fi_types::T_e8_Tun_AudioSink)o5);
}

void serializeCca(const ::midw_tuner_fi_types::T_u16CalibrationData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8DataLength();
    {
        uint32 o6 = static_cast<uint32>(in.getCalibrationValues().size());
        out << o6;
        ::std::vector< uint16 >::const_iterator o7;
        for (o7 = in.getCalibrationValues().begin(); o7 != in.getCalibrationValues().end(); ++o7) {
            out << (*o7);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_u16CalibrationData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o8;
    in >> o8;
    out.setU8DataLength(o8);
    {
        uint32 o9;
        in >> o9;
        out.getCalibrationValuesMutable().clear ();
        out.getCalibrationValuesMutable().reserve (o9);
        for (uint32 o10 = 0; o10 < o9; o10++) {
            uint16 o11;
            in >> o11;
            out.getCalibrationValuesMutable().push_back(o11);
        }
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_Aud_FGBG_New& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8_TunerHeader();
    out << (uint8) in.getU8SubCommand();
    out << (uint8) in.getU8AudioSink();
    out << (uint8) in.getBTunerState();
    out << (uint8) in.getU8_PhysicalTuner();
    out << (uint8) in.getE8Band();
    out << (uint8) in.getE8MTCAudioSource();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Aud_FGBG_New& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o12;
    in >> o12;
    out.setU8_TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o12);
    uint8 o13;
    in >> o13;
    out.setU8SubCommand((::midw_tuner_fi_types::T_e8_Tun_SubCommand)o13);
    uint8 o14;
    in >> o14;
    out.setU8AudioSink((::midw_tuner_fi_types::T_e8_Tun_AudioSink)o14);
    bool o15;
    in >> o15;
    out.setBTunerState(o15);
    uint8 o16;
    in >> o16;
    out.setU8_PhysicalTuner((::midw_tuner_fi_types::T_e8_Tun_PhysicalTuner)o16);
    uint8 o17;
    in >> o17;
    out.setE8Band((::midw_tuner_fi_types::T_e8_Tun_TunerBand)o17);
    uint8 o18;
    in >> o18;
    out.setE8MTCAudioSource((::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource)o18);
}

void serializeCca(const ::midw_tuner_fi_types::T_AudFGBGStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8_TunerHeader();
    serializeCca(in.getU8AudioSink(), out, majorVersion);
    out << (uint8) in.getE8MTCAudioSource();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_AudFGBGStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o19;
    in >> o19;
    out.setU8_TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o19);
    deserializeCca(in, out.getU8AudioSinkMutable(), majorVersion);
    uint8 o20;
    in >> o20;
    out.setE8MTCAudioSource((::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource)o20);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerServer_StatusResponse& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerStatus();
    out << (uint8) in.getU8TunerState();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerServer_StatusResponse& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o21;
    in >> o21;
    out.setU8TunerStatus((::midw_tuner_fi_types::T_e8_Tun_ResponseStatus)o21);
    uint8 o22;
    in >> o22;
    out.setU8TunerState((::midw_tuner_fi_types::T_e8_Tun_ResponseState)o22);
}

void serializeCca(const ::midw_tuner_fi_types::T_b32_Tun_AvailFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getTUN_FRQ_AVAILABLE()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_PS_AVAILABLE()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_PI_AVAILABLE()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_PTY_AVAILABLE()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_CT_AVAILABLE()) {
        bitmask |= (1 << 4);
    }
    if (in.getTUN_TMC_AVAILABLE()) {
        bitmask |= (1 << 5);
    }
    if (in.getTUN_RDS_AVAILABLE()) {
        bitmask |= (1 << 6);
    }
    if (in.getTUN_REG_AVAILABLE()) {
        bitmask |= (1 << 7);
    }
    if (in.getTUN_AF_AVAILABLE()) {
        bitmask |= (1 << 8);
    }
    if (in.getTUN_PTY_EON_AVAILABLE()) {
        bitmask |= (1 << 9);
    }
    if (in.getTUN_RT_AVAILABLE()) {
        bitmask |= (1 << 10);
    }
    if (in.getTUN_JAPAN_PS_AVAILABLE()) {
        bitmask |= (1 << 11);
    }
    if (in.getTUN_AUTO_COMPARE_AVAILABLE()) {
        bitmask |= (1 << 12);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b32_Tun_AvailFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o23;
    in >> o23;
    uint32 bitmask(o23);

    if (bitmask & (1 << 0)) {
        out.setTUN_FRQ_AVAILABLE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_PS_AVAILABLE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_PI_AVAILABLE (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_PTY_AVAILABLE (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_CT_AVAILABLE (true);
    }
    if (bitmask & (1 << 5)) {
        out.setTUN_TMC_AVAILABLE (true);
    }
    if (bitmask & (1 << 6)) {
        out.setTUN_RDS_AVAILABLE (true);
    }
    if (bitmask & (1 << 7)) {
        out.setTUN_REG_AVAILABLE (true);
    }
    if (bitmask & (1 << 8)) {
        out.setTUN_AF_AVAILABLE (true);
    }
    if (bitmask & (1 << 9)) {
        out.setTUN_PTY_EON_AVAILABLE (true);
    }
    if (bitmask & (1 << 10)) {
        out.setTUN_RT_AVAILABLE (true);
    }
    if (bitmask & (1 << 11)) {
        out.setTUN_JAPAN_PS_AVAILABLE (true);
    }
    if (bitmask & (1 << 12)) {
        out.setTUN_AUTO_COMPARE_AVAILABLE (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b32_Tun_Features& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getTUN_FEATURE_AF_MODE()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_FEATURE_CT_MODE()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_FEATURE_LOC_MODE()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_FEATURE_unused()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_FEATURE_MONO_MODE()) {
        bitmask |= (1 << 4);
    }
    if (in.getTUN_FEATURE_PSFIX_MODE()) {
        bitmask |= (1 << 5);
    }
    if (in.getTUN_FEATURE_REG_MODE()) {
        bitmask |= (1 << 7);
    }
    if (in.getTUN_FEATURE_RT_MODE()) {
        bitmask |= (1 << 8);
    }
    if (in.getTUN_FEATURE_SEARCH_MODE()) {
        bitmask |= (1 << 9);
    }
    if (in.getTUN_FEATURE_SEEK_SENSE_MODE()) {
        bitmask |= (1 << 10);
    }
    if (in.getTUN_FEATURE_SHARX_MODE()) {
        bitmask |= (1 << 11);
    }
    if (in.getTUN_FEATURE_TM_DATA_MODE()) {
        bitmask |= (1 << 12);
    }
    if (in.getTUN_FEATURE_TMC_MODE()) {
        bitmask |= (1 << 14);
    }
    if (in.getTUN_FEATURE_KHZ50_MODE()) {
        bitmask |= (1 << 15);
    }
    if (in.getTUN_FEATURE_REG_AUTO_MODE()) {
        bitmask |= (1 << 16);
    }
    if (in.getTUN_FEATURE_NEWS_MODE()) {
        bitmask |= (1 << 17);
    }
    if (in.getTUN_FEATURE_RDS_AUTO_MODE()) {
        bitmask |= (1 << 18);
    }
    if (in.getTUN_FEATURE_DDA_MODE()) {
        bitmask |= (1 << 19);
    }
    if (in.getTUN_FEATURE_DDS_MODE()) {
        bitmask |= (1 << 20);
    }
    if (in.getTUN_FEATURE_reserved()) {
        bitmask |= (1 << 21);
    }
    if (in.getTUN_FEATURE_MEASURE_MODE()) {
        bitmask |= (1 << 22);
    }
    if (in.getTUN_FEATURE_AMFMSETUP_MODE()) {
        bitmask |= (1 << 23);
    }
    if (in.getTUN_FEATURE_PERSISTENTSTORAGE_MODE()) {
        bitmask |= (1 << 24);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b32_Tun_Features& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o24;
    in >> o24;
    uint32 bitmask(o24);

    if (bitmask & (1 << 0)) {
        out.setTUN_FEATURE_AF_MODE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_FEATURE_CT_MODE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_FEATURE_LOC_MODE (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_FEATURE_unused (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_FEATURE_MONO_MODE (true);
    }
    if (bitmask & (1 << 5)) {
        out.setTUN_FEATURE_PSFIX_MODE (true);
    }
    if (bitmask & (1 << 7)) {
        out.setTUN_FEATURE_REG_MODE (true);
    }
    if (bitmask & (1 << 8)) {
        out.setTUN_FEATURE_RT_MODE (true);
    }
    if (bitmask & (1 << 9)) {
        out.setTUN_FEATURE_SEARCH_MODE (true);
    }
    if (bitmask & (1 << 10)) {
        out.setTUN_FEATURE_SEEK_SENSE_MODE (true);
    }
    if (bitmask & (1 << 11)) {
        out.setTUN_FEATURE_SHARX_MODE (true);
    }
    if (bitmask & (1 << 12)) {
        out.setTUN_FEATURE_TM_DATA_MODE (true);
    }
    if (bitmask & (1 << 14)) {
        out.setTUN_FEATURE_TMC_MODE (true);
    }
    if (bitmask & (1 << 15)) {
        out.setTUN_FEATURE_KHZ50_MODE (true);
    }
    if (bitmask & (1 << 16)) {
        out.setTUN_FEATURE_REG_AUTO_MODE (true);
    }
    if (bitmask & (1 << 17)) {
        out.setTUN_FEATURE_NEWS_MODE (true);
    }
    if (bitmask & (1 << 18)) {
        out.setTUN_FEATURE_RDS_AUTO_MODE (true);
    }
    if (bitmask & (1 << 19)) {
        out.setTUN_FEATURE_DDA_MODE (true);
    }
    if (bitmask & (1 << 20)) {
        out.setTUN_FEATURE_DDS_MODE (true);
    }
    if (bitmask & (1 << 21)) {
        out.setTUN_FEATURE_reserved (true);
    }
    if (bitmask & (1 << 22)) {
        out.setTUN_FEATURE_MEASURE_MODE (true);
    }
    if (bitmask & (1 << 23)) {
        out.setTUN_FEATURE_AMFMSETUP_MODE (true);
    }
    if (bitmask & (1 << 24)) {
        out.setTUN_FEATURE_PERSISTENTSTORAGE_MODE (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_Antenna& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTUNER_ANTENNA1()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUNER_ANTENNA2()) {
        bitmask |= (1 << 1);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_Antenna& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o25;
    in >> o25;
    uint8 bitmask(o25);

    if (bitmask & (1 << 0)) {
        out.setTUNER_ANTENNA1 (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUNER_ANTENNA2 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerStationData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    out << in.getU8PTY();
    out << in.getU16PackedInfo();
    serializeCca(in.getU32AvailFlags(), out, majorVersion);
    out << in.getU32Frequency();
    out << in.getU32PI();
    out << in.getU8PSName1();
    out << in.getU8PSName2();
    out << in.getU8PSName3();
    out << in.getU8PSName4();
    out << in.getU8PSName5();
    out << in.getU8PSName6();
    out << in.getU8PSName7();
    out << in.getU8PSName8();
    out << in.getSPSName();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerStationData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o26;
    in >> o26;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o26);
    uint8 o27;
    in >> o27;
    out.setU8PTY(o27);
    uint16 o28;
    in >> o28;
    out.setU16PackedInfo(o28);
    deserializeCca(in, out.getU32AvailFlagsMutable(), majorVersion);
    uint32 o29;
    in >> o29;
    out.setU32Frequency(o29);
    uint32 o30;
    in >> o30;
    out.setU32PI(o30);
    uint8 o31;
    in >> o31;
    out.setU8PSName1(o31);
    uint8 o32;
    in >> o32;
    out.setU8PSName2(o32);
    uint8 o33;
    in >> o33;
    out.setU8PSName3(o33);
    uint8 o34;
    in >> o34;
    out.setU8PSName4(o34);
    uint8 o35;
    in >> o35;
    out.setU8PSName5(o35);
    uint8 o36;
    in >> o36;
    out.setU8PSName6(o36);
    uint8 o37;
    in >> o37;
    out.setU8PSName7(o37);
    uint8 o38;
    in >> o38;
    out.setU8PSName8(o38);
    ::std::string o39;
    in >> o39;
    out.setSPSName(o39);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerFeature& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getB32Features(), out, majorVersion);
    serializeCca(in.getB32MaskFeatures(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerFeature& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getB32FeaturesMutable(), majorVersion);
    deserializeCca(in, out.getB32MaskFeaturesMutable(), majorVersion);
}

void serializeCca(const ::midw_tuner_fi_types::T_b32_Tun_AvailableFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 bitmask = 0;
    if (in.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_AVAILABLE_FLAGS_reserved()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b32_Tun_AvailableFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o40;
    in >> o40;
    uint32 bitmask(o40);

    if (bitmask & (1 << 0)) {
        out.setTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_AVAILABLE_FLAGS_reserved (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_AVAILABLE_FLAGS_PS_AVAILABLE (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerManualSingleStep& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getManualFreqAdjustment();
    out << in.getU8NumberOfTicks();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerManualSingleStep& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o41;
    in >> o41;
    out.setManualFreqAdjustment((::midw_tuner_fi_types::T_e8_Tun_ManualFreqAdjustment)o41);
    uint8 o42;
    in >> o42;
    out.setU8NumberOfTicks(o42);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_OperationFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTUN_OPERATION_AFBEST()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_OPERATION_PTY()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_OPERATION_SEARCH()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_OPERATION_TA()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_OPERATION_TPSEEK()) {
        bitmask |= (1 << 4);
    }
    if (in.getTUN_OPERATION_ACTION()) {
        bitmask |= (1 << 5);
    }
    if (in.getTUN_OPERATION_SEEK_LEVEL_LOGIC()) {
        bitmask |= (1 << 6);
    }
    if (in.getTUN_OPERATION_reserved()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_OperationFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o43;
    in >> o43;
    uint8 bitmask(o43);

    if (bitmask & (1 << 0)) {
        out.setTUN_OPERATION_AFBEST (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_OPERATION_PTY (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_OPERATION_SEARCH (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_OPERATION_TA (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_OPERATION_TPSEEK (true);
    }
    if (bitmask & (1 << 5)) {
        out.setTUN_OPERATION_ACTION (true);
    }
    if (bitmask & (1 << 6)) {
        out.setTUN_OPERATION_SEEK_LEVEL_LOGIC (true);
    }
    if (bitmask & (1 << 7)) {
        out.setTUN_OPERATION_reserved (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerOperation& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8EnableOrDisable();
    out << (uint8) in.getU8OperationFlags();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerOperation& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o44;
    in >> o44;
    out.setU8EnableOrDisable((::midw_tuner_fi_types::T_e8_Tun_EnableOrDisable)o44);
    uint8 o45;
    in >> o45;
    out.setU8OperationFlags((::midw_tuner_fi_types::T_e8_Tun_OperationFlags)o45);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerAFList& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    out << in.getU8AFListElementID();
    out << in.getU32AFFrequency();
    out << in.getU8AFQualityLevel();
    out << in.getU8AFFieldStrength();
    out << in.getU8AFBitErrorRate();
    out << (uint8) in.getU8AFInfo();
    out << in.getU16AFPI();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerAFList& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o46;
    in >> o46;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o46);
    uint8 o47;
    in >> o47;
    out.setU8AFListElementID(o47);
    uint32 o48;
    in >> o48;
    out.setU32AFFrequency(o48);
    uint8 o49;
    in >> o49;
    out.setU8AFQualityLevel(o49);
    uint8 o50;
    in >> o50;
    out.setU8AFFieldStrength(o50);
    uint8 o51;
    in >> o51;
    out.setU8AFBitErrorRate(o51);
    uint8 o52;
    in >> o52;
    out.setU8AFInfo((::midw_tuner_fi_types::T_e8_Tun_AFInformation)o52);
    uint16 o53;
    in >> o53;
    out.setU16AFPI(o53);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_TestmodeBits& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTUN_TP_BIT()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_TA_BIT()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_TMC_BIT()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_UNUSED_BIT()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_AUDIO_TUNER_BIT()) {
        bitmask |= (1 << 4);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_TestmodeBits& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o54;
    in >> o54;
    uint8 bitmask(o54);

    if (bitmask & (1 << 0)) {
        out.setTUN_TP_BIT (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_TA_BIT (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_TMC_BIT (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_UNUSED_BIT (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_AUDIO_TUNER_BIT (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerTestModeData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    out << (uint8) in.getU8AdditionalInfo();
    out << in.getU32AFFrequency();
    out << in.getU32PI();
    out << in.getU8Quality();
    out << in.getU8Fieldstrength();
    out << in.getU8Multipath();
    out << in.getU8Neighbour();
    out << in.getU8AFListLength();
    serializeCca(in.getU8TestmodeBits(), out, majorVersion);
    out << in.getU8TMCStationCount();
    out << (uint8) in.getU8TMCGroupState();
    out << (uint8) in.getU8AntennaState();
    out << in.getU8PSName1();
    out << in.getU8PSName2();
    out << in.getU8PSName3();
    out << in.getU8PSName4();
    out << in.getU8PSName5();
    out << in.getU8PSName6();
    out << in.getU8PSName7();
    out << in.getU8PSName8();
    out << in.getSPSName();
    out << (uint8) in.getU8IFState();
    out << in.getU8ChannelSeparation();
    out << in.getU8Hub();
    out << in.getU8RdsErrorRate();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerTestModeData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o55;
    in >> o55;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o55);
    uint8 o56;
    in >> o56;
    out.setU8AdditionalInfo((::midw_tuner_fi_types::T_e8_Tun_AdditionalInfo)o56);
    uint32 o57;
    in >> o57;
    out.setU32AFFrequency(o57);
    uint32 o58;
    in >> o58;
    out.setU32PI(o58);
    uint8 o59;
    in >> o59;
    out.setU8Quality(o59);
    uint8 o60;
    in >> o60;
    out.setU8Fieldstrength(o60);
    uint8 o61;
    in >> o61;
    out.setU8Multipath(o61);
    uint8 o62;
    in >> o62;
    out.setU8Neighbour(o62);
    uint8 o63;
    in >> o63;
    out.setU8AFListLength(o63);
    deserializeCca(in, out.getU8TestmodeBitsMutable(), majorVersion);
    uint8 o64;
    in >> o64;
    out.setU8TMCStationCount(o64);
    uint8 o65;
    in >> o65;
    out.setU8TMCGroupState((::midw_tuner_fi_types::T_e8_Tun_TMCGroupState)o65);
    uint8 o66;
    in >> o66;
    out.setU8AntennaState((::midw_tuner_fi_types::T_e8_Tun_AntennaState)o66);
    uint8 o67;
    in >> o67;
    out.setU8PSName1(o67);
    uint8 o68;
    in >> o68;
    out.setU8PSName2(o68);
    uint8 o69;
    in >> o69;
    out.setU8PSName3(o69);
    uint8 o70;
    in >> o70;
    out.setU8PSName4(o70);
    uint8 o71;
    in >> o71;
    out.setU8PSName5(o71);
    uint8 o72;
    in >> o72;
    out.setU8PSName6(o72);
    uint8 o73;
    in >> o73;
    out.setU8PSName7(o73);
    uint8 o74;
    in >> o74;
    out.setU8PSName8(o74);
    ::std::string o75;
    in >> o75;
    out.setSPSName(o75);
    uint8 o76;
    in >> o76;
    out.setU8IFState((::midw_tuner_fi_types::T_e8_Tun_IfState)o76);
    uint8 o77;
    in >> o77;
    out.setU8ChannelSeparation(o77);
    uint8 o78;
    in >> o78;
    out.setU8Hub(o78);
    uint8 o79;
    in >> o79;
    out.setU8RdsErrorRate(o79);
}

void serializeCca(const ::midw_tuner_fi_types::T_Sel_List_Elem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    out << (uint8) in.getEConfigListID();
    out << in.getU32Frequency();
    out << in.getU16PICode();
    out << in.getU8ListElementID();
    out << (uint8) in.getU8Listtype();
    out << in.getU32HDStnID_DRMSrvID();
    out << (uint8) in.getE8ModulationType();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Sel_List_Elem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o80;
    in >> o80;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o80);
    uint8 o81;
    in >> o81;
    out.setEConfigListID((::midw_tuner_fi_types::T_e8_Tun_ConfigListID)o81);
    uint32 o82;
    in >> o82;
    out.setU32Frequency(o82);
    uint16 o83;
    in >> o83;
    out.setU16PICode(o83);
    uint8 o84;
    in >> o84;
    out.setU8ListElementID(o84);
    uint8 o85;
    in >> o85;
    out.setU8Listtype((::midw_tuner_fi_types::T_e8_Tun_ListType)o85);
    uint32 o86;
    in >> o86;
    out.setU32HDStnID_DRMSrvID(o86);
    uint8 o87;
    in >> o87;
    out.setE8ModulationType((::midw_tuner_fi_types::T_e8_Tun_ModulationType)o87);
}

void serializeCca(const ::midw_tuner_fi_types::T_Tun_MakeConfigList& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEConfigListID();
    out << in.getU32PTY();
    out << (uint8) in.getESortingCriteria();
    serializeCca(in.getU8DigitalFilters(), out, majorVersion);
    out << (uint8) in.getBFrozenList();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Tun_MakeConfigList& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o88;
    in >> o88;
    out.setEConfigListID((::midw_tuner_fi_types::T_e8_Tun_ConfigListID)o88);
    uint32 o89;
    in >> o89;
    out.setU32PTY(o89);
    uint8 o90;
    in >> o90;
    out.setESortingCriteria((::midw_tuner_fi_types::T_e8_Tun_SortingCriteria)o90);
    deserializeCca(in, out.getU8DigitalFiltersMutable(), majorVersion);
    bool o91;
    in >> o91;
    out.setBFrozenList(o91);
}

void serializeCca(const ::midw_tuner_fi_types::T_Encryption& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getEncrypted();
    out << in.getEncid();
    out << in.getTestBits();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Encryption& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    bool o92;
    in >> o92;
    out.setEncrypted(o92);
    uint8 o93;
    in >> o93;
    out.setEncid(o93);
    uint8 o94;
    in >> o94;
    out.setTestBits(o94);
}

void serializeCca(const ::midw_tuner_fi_types::T_MsgSource& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getMediumTypeId();
    out << in.getNumber();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_MsgSource& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o95;
    in >> o95;
    out.setMediumTypeId((::midw_tuner_fi_types::T_e8_TmcMediumType)o95);
    uint8 o96;
    in >> o96;
    out.setNumber(o96);
}

void serializeCca(const ::midw_tuner_fi_types::T_Tun_RDBID_Value& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8RdbidCC();
    out << in.getU8RdbidLTN();
    out << in.getU8RdbidSID();
    out << (uint8) in.getBEncFlag();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Tun_RDBID_Value& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o97;
    in >> o97;
    out.setU8RdbidCC(o97);
    uint8 o98;
    in >> o98;
    out.setU8RdbidLTN(o98);
    uint8 o99;
    in >> o99;
    out.setU8RdbidSID(o99);
    bool o100;
    in >> o100;
    out.setBEncFlag(o100);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerRdbId& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getTMCCountryCode();
    out << in.getTableNo();
    out << in.getServiceID();
    out << (uint8) in.getEncrypted();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerRdbId& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o101;
    in >> o101;
    out.setTMCCountryCode(o101);
    uint8 o102;
    in >> o102;
    out.setTableNo(o102);
    uint8 o103;
    in >> o103;
    out.setServiceID(o103);
    bool o104;
    in >> o104;
    out.setEncrypted(o104);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerGetDataTMC& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    out << in.getU16TMCData1();
    out << in.getU16TMCData2();
    out << in.getU16TMCData3();
    out << in.getU16TMCData4();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerGetDataTMC& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o105;
    in >> o105;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o105);
    uint16 o106;
    in >> o106;
    out.setU16TMCData1(o106);
    uint16 o107;
    in >> o107;
    out.setU16TMCData2(o107);
    uint16 o108;
    in >> o108;
    out.setU16TMCData3(o108);
    uint16 o109;
    in >> o109;
    out.setU16TMCData4(o109);
}

void serializeCca(const ::midw_tuner_fi_types::T_TrafficInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getRDBId(), out, majorVersion);
    out << in.getECC();
    out << (uint16) in.getApplicationId();
    {
        uint32 o110 = static_cast<uint32>(in.getListOf8AData().size());
        out << o110;
        ::std::vector< uint8 >::const_iterator o111;
        for (o111 = in.getListOf8AData().begin(); o111 != in.getListOf8AData().end(); ++o111) {
            out << (*o111);
        }
    }
    out << in.getProgramID();
    serializeCca(in.getEncryption(), out, majorVersion);
    serializeCca(in.getMsgSource(), out, majorVersion);
    out << in.getProgramServiceName();
    out << in.getServiceProviderName();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TrafficInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getRDBIdMutable(), majorVersion);
    int16 o112;
    in >> o112;
    out.setECC(o112);
    uint16 o113;
    in >> o113;
    out.setApplicationId((::midw_tuner_fi_types::T_e16_TmcApplicationId)o113);
    {
        uint32 o114;
        in >> o114;
        out.getListOf8ADataMutable().clear ();
        out.getListOf8ADataMutable().reserve (o114);
        for (uint32 o115 = 0; o115 < o114; o115++) {
            uint8 o116;
            in >> o116;
            out.getListOf8ADataMutable().push_back(o116);
        }
    }
    uint16 o117;
    in >> o117;
    out.setProgramID(o117);
    deserializeCca(in, out.getEncryptionMutable(), majorVersion);
    deserializeCca(in, out.getMsgSourceMutable(), majorVersion);
    ::std::string o118;
    in >> o118;
    out.setProgramServiceName(o118);
    ::std::string o119;
    in >> o119;
    out.setServiceProviderName(o119);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_PackedInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTUN_TP()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_TP_SELF()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_PTY_DYNAMIC()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_PS_DYNAMIC()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_TMC_reserved()) {
        bitmask |= (1 << 4);
    }
    if (in.getTUN_TMC_YES()) {
        bitmask |= (1 << 5);
    }
    if (in.getTUN_TMC_NO()) {
        bitmask |= (1 << 6);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_PackedInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o120;
    in >> o120;
    uint8 bitmask(o120);

    if (bitmask & (1 << 0)) {
        out.setTUN_TP (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_TP_SELF (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_PTY_DYNAMIC (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_PS_DYNAMIC (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_TMC_reserved (true);
    }
    if (bitmask & (1 << 5)) {
        out.setTUN_TMC_YES (true);
    }
    if (bitmask & (1 << 6)) {
        out.setTUN_TMC_NO (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_MakeConfigListElem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ListID();
    out << in.getU8NumOfElementsInList();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_MakeConfigListElem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o121;
    in >> o121;
    out.setE8ListID((::midw_tuner_fi_types::T_e8_Tun_ConfigListID)o121);
    uint8 o122;
    in >> o122;
    out.setU8NumOfElementsInList(o122);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_AvailFlags& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_AVAILABLE_FLAGS_PI_AVAILABLE()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_AVAILABLE_FLAGS_PTY_AVAILABLE()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_AVAILABLE_FLAGS_CT_AVAILABLE()) {
        bitmask |= (1 << 4);
    }
    if (in.getTUN_AVAILABLE_FLAGS_RT_AVAILABLE()) {
        bitmask |= (1 << 5);
    }
    if (in.getTUN_AVAILABLE_FLAGS_reserved()) {
        bitmask |= (1 << 6);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_AvailFlags& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o123;
    in >> o123;
    uint8 bitmask(o123);

    if (bitmask & (1 << 0)) {
        out.setTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_AVAILABLE_FLAGS_PI_AVAILABLE (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_AVAILABLE_FLAGS_PS_AVAILABLE (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_AVAILABLE_FLAGS_PTY_AVAILABLE (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_AVAILABLE_FLAGS_CT_AVAILABLE (true);
    }
    if (bitmask & (1 << 5)) {
        out.setTUN_AVAILABLE_FLAGS_RT_AVAILABLE (true);
    }
    if (bitmask & (1 << 6)) {
        out.setTUN_AVAILABLE_FLAGS_reserved (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerConfigListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ConfigListID();
    out << in.getU8ElementID();
    out << in.getU8ElementSelected();
    out << in.getU32Frequency();
    out << in.getU32PI();
    out << in.getSPSName();
    out << in.getU8PTY();
    out << in.getU8ECC();
    out << in.getU8SID();
    out << in.getU8LTN();
    out << in.getU8Quality();
    out << in.getU8PositionInPresetList();
    out << (uint8) in.getE8SendernameInfo();
    out << (uint8) in.getBTpInfo();
    out << (uint8) in.getE8TMCType();
    out << (uint8) in.getE8PresetListForAcmp();
    out << in.getS8LevelCompensation();
    out << in.getStationLogo();
    out << (uint8) in.getE8ModulationType();
    out << in.getU8PTY_HDPTY_DRMPty();
    out << in.getU32PI_HDStnId_DRMSrvId();
    serializeCca(in.getB8StationInfo(), out, majorVersion);
    out << (uint8) in.getE8HDTextEncoding();
    serializeCca(in.getB8HDNumOfAudioPrograms(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerConfigListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o124;
    in >> o124;
    out.setE8ConfigListID((::midw_tuner_fi_types::T_e8_Tun_ConfigListID)o124);
    uint8 o125;
    in >> o125;
    out.setU8ElementID(o125);
    uint8 o126;
    in >> o126;
    out.setU8ElementSelected(o126);
    uint32 o127;
    in >> o127;
    out.setU32Frequency(o127);
    uint32 o128;
    in >> o128;
    out.setU32PI(o128);
    ::std::string o129;
    in >> o129;
    out.setSPSName(o129);
    uint8 o130;
    in >> o130;
    out.setU8PTY(o130);
    uint8 o131;
    in >> o131;
    out.setU8ECC(o131);
    uint8 o132;
    in >> o132;
    out.setU8SID(o132);
    uint8 o133;
    in >> o133;
    out.setU8LTN(o133);
    uint8 o134;
    in >> o134;
    out.setU8Quality(o134);
    uint8 o135;
    in >> o135;
    out.setU8PositionInPresetList(o135);
    uint8 o136;
    in >> o136;
    out.setE8SendernameInfo((::midw_tuner_fi_types::T_e8_Tun_SendernameInfo)o136);
    bool o137;
    in >> o137;
    out.setBTpInfo(o137);
    uint8 o138;
    in >> o138;
    out.setE8TMCType((::midw_tuner_fi_types::T_e8_Tun_TMCType)o138);
    uint8 o139;
    in >> o139;
    out.setE8PresetListForAcmp((::midw_tuner_fi_types::T_e8_Tun_ListID)o139);
    int8 o140;
    in >> o140;
    out.setS8LevelCompensation(o140);
    ::std::string o141;
    in >> o141;
    out.setStationLogo(o141);
    uint8 o142;
    in >> o142;
    out.setE8ModulationType((::midw_tuner_fi_types::T_e8_Tun_ModulationType)o142);
    uint8 o143;
    in >> o143;
    out.setU8PTY_HDPTY_DRMPty(o143);
    uint32 o144;
    in >> o144;
    out.setU32PI_HDStnId_DRMSrvId(o144);
    deserializeCca(in, out.getB8StationInfoMutable(), majorVersion);
    uint8 o145;
    in >> o145;
    out.setE8HDTextEncoding((::midw_tuner_fi_types::T_e8_Tun_HD_TextEncodingType)o145);
    deserializeCca(in, out.getB8HDNumOfAudioProgramsMutable(), majorVersion);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_StationInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTP()) {
        bitmask |= (1 << 0);
    }
    if (in.getAF()) {
        bitmask |= (1 << 1);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_StationInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o146;
    in >> o146;
    uint8 bitmask(o146);

    if (bitmask & (1 << 0)) {
        out.setTP (true);
    }
    if (bitmask & (1 << 1)) {
        out.setAF (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_Tun_Set_PI& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8AbsOrRel();
    out << (uint8) in.getU8RelSteps();
    out << (uint8) in.getU8Direction();
    out << in.getU8Nsteps();
    out << in.getU16PI();
    out << in.getU32Frequency();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Tun_Set_PI& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o147;
    in >> o147;
    out.setU8AbsOrRel((::midw_tuner_fi_types::T_e8_Tun_Abs_Or_Rel)o147);
    uint8 o148;
    in >> o148;
    out.setU8RelSteps((::midw_tuner_fi_types::T_e8_Tun_Rel_Steps)o148);
    uint8 o149;
    in >> o149;
    out.setU8Direction((::midw_tuner_fi_types::T_e8_Tun_Direction)o149);
    uint8 o150;
    in >> o150;
    out.setU8Nsteps(o150);
    uint16 o151;
    in >> o151;
    out.setU16PI(o151);
    uint32 o152;
    in >> o152;
    out.setU32Frequency(o152);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerStaticListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ListID();
    out << in.getU8ElementID();
    out << (uint8) in.getBSelected();
    out << in.getU32Frequency();
    out << in.getSPSName();
    out << in.getU16PI();
    out << (uint8) in.getE8SendernameInfo();
    out << in.getU8TpTmcInfo();
    out << in.getU32PTY();
    out << in.getS8LevelCompensation();
    out << (uint8) in.getE8Modulation();
    out << in.getU32HDStationId_DRMServiceId();
    out << in.getSHDCallSign_DRMServiceLabel();
    out << (uint8) in.getE8HDTextEncoding();
    out << in.getU8HDStationGenre_DRMPty();
    out << in.getU8HDAudioProgram_DRMShortID();
    out << in.getStationLogo();
    out << in.getU32DRMServiceId();
    out << in.getSDRMServiceLabel();
    out << in.getU8DRMPTY();
    out << in.getU8DRMServiceShortId();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerStaticListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o153;
    in >> o153;
    out.setE8ListID((::midw_tuner_fi_types::T_e8_Tun_ListID)o153);
    uint8 o154;
    in >> o154;
    out.setU8ElementID(o154);
    bool o155;
    in >> o155;
    out.setBSelected(o155);
    uint32 o156;
    in >> o156;
    out.setU32Frequency(o156);
    ::std::string o157;
    in >> o157;
    out.setSPSName(o157);
    uint16 o158;
    in >> o158;
    out.setU16PI(o158);
    uint8 o159;
    in >> o159;
    out.setE8SendernameInfo((::midw_tuner_fi_types::T_e8_Tun_SendernameInfo)o159);
    uint8 o160;
    in >> o160;
    out.setU8TpTmcInfo(o160);
    uint32 o161;
    in >> o161;
    out.setU32PTY(o161);
    int8 o162;
    in >> o162;
    out.setS8LevelCompensation(o162);
    uint8 o163;
    in >> o163;
    out.setE8Modulation((::midw_tuner_fi_types::T_e8_Tun_ModulationType)o163);
    uint32 o164;
    in >> o164;
    out.setU32HDStationId_DRMServiceId(o164);
    ::std::string o165;
    in >> o165;
    out.setSHDCallSign_DRMServiceLabel(o165);
    uint8 o166;
    in >> o166;
    out.setE8HDTextEncoding((::midw_tuner_fi_types::T_e8_Tun_HD_TextEncodingType)o166);
    uint8 o167;
    in >> o167;
    out.setU8HDStationGenre_DRMPty(o167);
    uint8 o168;
    in >> o168;
    out.setU8HDAudioProgram_DRMShortID(o168);
    ::std::string o169;
    in >> o169;
    out.setStationLogo(o169);
    uint32 o170;
    in >> o170;
    out.setU32DRMServiceId(o170);
    ::std::string o171;
    in >> o171;
    out.setSDRMServiceLabel(o171);
    uint8 o172;
    in >> o172;
    out.setU8DRMPTY(o172);
    uint8 o173;
    in >> o173;
    out.setU8DRMServiceShortId(o173);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerTestRoutineParameter& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint16) in.getTroubleCode();
    out << (uint8) in.getWriteToRM();
    out << (uint8) in.getMonitoringMode();
    out << (uint8) in.getSupervisionControl();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerTestRoutineParameter& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o174;
    in >> o174;
    out.setTroubleCode((::midw_tuner_fi_types::T_e16_Tun_TroubleCode)o174);
    bool o175;
    in >> o175;
    out.setWriteToRM(o175);
    uint8 o176;
    in >> o176;
    out.setMonitoringMode((::midw_tuner_fi_types::T_e8_Tun_MonitoringMode)o176);
    uint8 o177;
    in >> o177;
    out.setSupervisionControl((::midw_tuner_fi_types::T_e8_Tun_SupervisionControl)o177);
}

void serializeCca(const ::midw_tuner_fi_types::T_Tun_TestTroubleCodeStatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint16) in.getTroubleCode();
    out << (uint8) in.getErrorStatus();
    out << (uint8) in.getRoutineStatus();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Tun_TestTroubleCodeStatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o178;
    in >> o178;
    out.setTroubleCode((::midw_tuner_fi_types::T_e16_Tun_TroubleCode)o178);
    uint8 o179;
    in >> o179;
    out.setErrorStatus((::midw_tuner_fi_types::T_e8_Tun_ErrorStatus)o179);
    uint8 o180;
    in >> o180;
    out.setRoutineStatus((::midw_tuner_fi_types::T_e8_Tun_RoutineStatus)o180);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerFieldstrength& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8Band();
    out << in.getU32Frequency();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerFieldstrength& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o181;
    in >> o181;
    out.setU8Band(o181);
    uint32 o182;
    in >> o182;
    out.setU32Frequency(o182);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerRadioText& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    out << (uint8) in.getU8TunerSource();
    out << in.getU8TextType();
    out << in.getSRadioTextData();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerRadioText& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o183;
    in >> o183;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o183);
    uint8 o184;
    in >> o184;
    out.setU8TunerSource((::midw_tuner_fi_types::T_e8_Tun_Source)o184);
    uint8 o185;
    in >> o185;
    out.setU8TextType(o185);
    ::std::string o186;
    in >> o186;
    out.setSRadioTextData(o186);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerBandAndStationInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Band();
    out << in.getU32Frequency();
    out << in.getU16PI();
    out << in.getSPSName();
    out << in.getU16StaticListElementID();
    out << in.getSHDCallSign();
    out << in.getU32HDStationId();
    out << (uint8) in.getE8HDAudioProgram();
    out << in.getU8PresetAutocompare();
    out << in.getSDRMServiceLabel();
    out << in.getU32DRMServiceId();
    out << in.getU8DRMServiceShortId();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerBandAndStationInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o187;
    in >> o187;
    out.setE8Band((::midw_tuner_fi_types::T_e8_Tun_TunerBand)o187);
    uint32 o188;
    in >> o188;
    out.setU32Frequency(o188);
    uint16 o189;
    in >> o189;
    out.setU16PI(o189);
    ::std::string o190;
    in >> o190;
    out.setSPSName(o190);
    uint16 o191;
    in >> o191;
    out.setU16StaticListElementID(o191);
    ::std::string o192;
    in >> o192;
    out.setSHDCallSign(o192);
    uint32 o193;
    in >> o193;
    out.setU32HDStationId(o193);
    uint8 o194;
    in >> o194;
    out.setE8HDAudioProgram((::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram)o194);
    uint8 o195;
    in >> o195;
    out.setU8PresetAutocompare(o195);
    ::std::string o196;
    in >> o196;
    out.setSDRMServiceLabel(o196);
    uint32 o197;
    in >> o197;
    out.setU32DRMServiceId(o197);
    uint8 o198;
    in >> o198;
    out.setU8DRMServiceShortId(o198);
}

void serializeCca(const ::midw_tuner_fi_types::T_Tun_AutoCompParam& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8FirstElemId();
    out << in.getU8LastElemID();
    out << (uint8) in.getU8Mode();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Tun_AutoCompParam& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o199;
    in >> o199;
    out.setU8FirstElemId(o199);
    uint8 o200;
    in >> o200;
    out.setU8LastElemID(o200);
    uint8 o201;
    in >> o201;
    out.setU8Mode((::midw_tuner_fi_types::T_e8_Tun_Autocompare_Mode)o201);
}

void serializeCca(const ::midw_tuner_fi_types::T_Component_Status& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU8AudioSinkTUN1();
    out << in.getU8BGModeTuner();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Component_Status& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o202;
    in >> o202;
    out.setU8AudioSinkTUN1(o202);
    uint8 o203;
    in >> o203;
    out.setU8BGModeTuner(o203);
}

void serializeCca(const ::midw_tuner_fi_types::T_Atstationinfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8TunerHeader();
    serializeCca(in.getU32AvailFlags(), out, majorVersion);
    out << in.getU32Frequency();
    out << in.getU16PI();
    out << in.getSPSName();
    out << (uint8) in.getE8Band();
    out << (uint8) in.getE8AtStationTPinfo();
    out << in.getU16PresetListID();
    out << in.getU8ActiveStationList();
    out << in.getU16StaticListElementID();
    out << in.getU16ConfigListElementID();
    serializeCca(in.getU8AtStationInfoBits(), out, majorVersion);
    out << in.getU8PTY();
    out << in.getU8FieldStrngth();
    out << in.getU8Quality();
    serializeCca(in.getB8HDStationInfoBits(), out, majorVersion);
    out << in.getU32StationInfoHDStationID();
    out << in.getSHDCallSign();
    out << (uint8) in.getE8HDCallSignTextEncoding();
    out << in.getU8HDStationGenre();
    serializeCca(in.getB8HDAudioPrgmAvail(), out, majorVersion);
    out << in.getU8HDQuality();
    out << (uint8) in.getE8ActiveHDAudPrgm();
    out << in.getStationLogo();
    serializeCca(in.getB8DRMStationInfoBits(), out, majorVersion);
    out << in.getU32DRMServiceId();
    out << in.getSDRMServiceLabel();
    out << in.getU8DRMPTY();
    serializeCca(in.getB16DRMAnnouBits(), out, majorVersion);
    serializeCca(in.getB8DRMNumberOfAudioServices(), out, majorVersion);
    out << in.getU8DRMQuality();
    out << in.getU8DRMServiceShortId();
    out << in.getU8Drmlanguage();
    out << in.getU32DrmlanguageCode();
    out << in.getU16DrmCountryCode();
    out << in.getS8DrmFrequencyCorrection();
    out << in.getU8JapanStationCount();
    out << (uint8) in.getBUserPresetAction();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Atstationinfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o204;
    in >> o204;
    out.setU8TunerHeader((::midw_tuner_fi_types::T_e8_Tun_TunerHeader)o204);
    deserializeCca(in, out.getU32AvailFlagsMutable(), majorVersion);
    uint32 o205;
    in >> o205;
    out.setU32Frequency(o205);
    uint16 o206;
    in >> o206;
    out.setU16PI(o206);
    ::std::string o207;
    in >> o207;
    out.setSPSName(o207);
    uint8 o208;
    in >> o208;
    out.setE8Band((::midw_tuner_fi_types::T_e8_Tun_TunerBand)o208);
    uint8 o209;
    in >> o209;
    out.setE8AtStationTPinfo((::midw_tuner_fi_types::T_e8_AtStationTPinfo)o209);
    uint16 o210;
    in >> o210;
    out.setU16PresetListID(o210);
    uint8 o211;
    in >> o211;
    out.setU8ActiveStationList(o211);
    uint16 o212;
    in >> o212;
    out.setU16StaticListElementID(o212);
    uint16 o213;
    in >> o213;
    out.setU16ConfigListElementID(o213);
    deserializeCca(in, out.getU8AtStationInfoBitsMutable(), majorVersion);
    uint8 o214;
    in >> o214;
    out.setU8PTY(o214);
    uint8 o215;
    in >> o215;
    out.setU8FieldStrngth(o215);
    uint8 o216;
    in >> o216;
    out.setU8Quality(o216);
    deserializeCca(in, out.getB8HDStationInfoBitsMutable(), majorVersion);
    uint32 o217;
    in >> o217;
    out.setU32StationInfoHDStationID(o217);
    ::std::string o218;
    in >> o218;
    out.setSHDCallSign(o218);
    uint8 o219;
    in >> o219;
    out.setE8HDCallSignTextEncoding((::midw_tuner_fi_types::T_e8_Tun_HD_TextEncodingType)o219);
    uint8 o220;
    in >> o220;
    out.setU8HDStationGenre(o220);
    deserializeCca(in, out.getB8HDAudioPrgmAvailMutable(), majorVersion);
    uint8 o221;
    in >> o221;
    out.setU8HDQuality(o221);
    uint8 o222;
    in >> o222;
    out.setE8ActiveHDAudPrgm((::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram)o222);
    ::std::string o223;
    in >> o223;
    out.setStationLogo(o223);
    deserializeCca(in, out.getB8DRMStationInfoBitsMutable(), majorVersion);
    uint32 o224;
    in >> o224;
    out.setU32DRMServiceId(o224);
    ::std::string o225;
    in >> o225;
    out.setSDRMServiceLabel(o225);
    uint8 o226;
    in >> o226;
    out.setU8DRMPTY(o226);
    deserializeCca(in, out.getB16DRMAnnouBitsMutable(), majorVersion);
    deserializeCca(in, out.getB8DRMNumberOfAudioServicesMutable(), majorVersion);
    uint8 o227;
    in >> o227;
    out.setU8DRMQuality(o227);
    uint8 o228;
    in >> o228;
    out.setU8DRMServiceShortId(o228);
    uint8 o229;
    in >> o229;
    out.setU8Drmlanguage(o229);
    uint32 o230;
    in >> o230;
    out.setU32DrmlanguageCode(o230);
    uint16 o231;
    in >> o231;
    out.setU16DrmCountryCode(o231);
    int8 o232;
    in >> o232;
    out.setS8DrmFrequencyCorrection(o232);
    uint8 o233;
    in >> o233;
    out.setU8JapanStationCount(o233);
    bool o234;
    in >> o234;
    out.setBUserPresetAction(o234);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerTestModeData_DDADDS& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getU8PhysicalTuner();
    out << (uint8) in.getU8Source();
    out << in.getU32AFFrequency();
    out << in.getU16CurrentPI();
    out << in.getU16TargetPI();
    out << in.getU8Quality();
    out << in.getU8Fieldstrength();
    out << in.getU8Multipath();
    out << in.getU8Neighbour();
    out << in.getU8AFListLength();
    out << in.getU8HiCut();
    out << in.getU8Sharx();
    out << in.getSCurrentStationName();
    out << in.getSFixPSName();
    out << (uint8) in.getBScrollPSStatus();
    out << (uint8) in.getBAFStatus();
    out << in.getU8FMDeviation();
    out << in.getU8RDSDeviation();
    out << in.getS8IFOffset();
    out << in.getS8RDSOffset();
    out << in.getU8CoChannelStatus();
    out << in.getU8AGC();
    out << in.getU8ChannelSeparation();
    out << in.getU8RdsErrorRate();
    out << (uint8) in.getE8DiversityState();
    out << (uint8) in.getE8AntennaPathSwitch1();
    out << (uint8) in.getE8AntennaPathSwitch2();
    serializeCca(in.getU8TestmodeBits(), out, majorVersion);
    out << in.getU8HicutExtender();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerTestModeData_DDADDS& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o235;
    in >> o235;
    out.setU8PhysicalTuner((::midw_tuner_fi_types::T_e8_Tun_PhysicalTuner)o235);
    uint8 o236;
    in >> o236;
    out.setU8Source((::midw_tuner_fi_types::T_e8_Tun_Testmode_TunerBand)o236);
    uint32 o237;
    in >> o237;
    out.setU32AFFrequency(o237);
    uint16 o238;
    in >> o238;
    out.setU16CurrentPI(o238);
    uint16 o239;
    in >> o239;
    out.setU16TargetPI(o239);
    uint8 o240;
    in >> o240;
    out.setU8Quality(o240);
    uint8 o241;
    in >> o241;
    out.setU8Fieldstrength(o241);
    uint8 o242;
    in >> o242;
    out.setU8Multipath(o242);
    uint8 o243;
    in >> o243;
    out.setU8Neighbour(o243);
    uint8 o244;
    in >> o244;
    out.setU8AFListLength(o244);
    uint8 o245;
    in >> o245;
    out.setU8HiCut(o245);
    uint8 o246;
    in >> o246;
    out.setU8Sharx(o246);
    ::std::string o247;
    in >> o247;
    out.setSCurrentStationName(o247);
    ::std::string o248;
    in >> o248;
    out.setSFixPSName(o248);
    bool o249;
    in >> o249;
    out.setBScrollPSStatus(o249);
    bool o250;
    in >> o250;
    out.setBAFStatus(o250);
    uint8 o251;
    in >> o251;
    out.setU8FMDeviation(o251);
    uint8 o252;
    in >> o252;
    out.setU8RDSDeviation(o252);
    int8 o253;
    in >> o253;
    out.setS8IFOffset(o253);
    int8 o254;
    in >> o254;
    out.setS8RDSOffset(o254);
    uint8 o255;
    in >> o255;
    out.setU8CoChannelStatus(o255);
    uint8 o256;
    in >> o256;
    out.setU8AGC(o256);
    uint8 o257;
    in >> o257;
    out.setU8ChannelSeparation(o257);
    uint8 o258;
    in >> o258;
    out.setU8RdsErrorRate(o258);
    uint8 o259;
    in >> o259;
    out.setE8DiversityState((::midw_tuner_fi_types::T_e8_Tun_DiversityState)o259);
    uint8 o260;
    in >> o260;
    out.setE8AntennaPathSwitch1((::midw_tuner_fi_types::T_e8_Tun_AntennaPathSwitch1)o260);
    uint8 o261;
    in >> o261;
    out.setE8AntennaPathSwitch2((::midw_tuner_fi_types::T_e8_Tun_AntennaPathSwitch2)o261);
    deserializeCca(in, out.getU8TestmodeBitsMutable(), majorVersion);
    uint8 o262;
    in >> o262;
    out.setU8HicutExtender(o262);
}

void serializeCca(const ::midw_tuner_fi_types::T_TuningActionConfigParam& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ConfigParamType();
    out << in.getU32ConfigParamValue();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TuningActionConfigParam& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o263;
    in >> o263;
    out.setE8ConfigParamType((::midw_tuner_fi_types::T_e8_Tun_ConfigParam_Type)o263);
    uint32 o264;
    in >> o264;
    out.setU32ConfigParamValue(o264);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_AnnoTypes& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTP()) {
        bitmask |= (1 << 0);
    }
    if (in.getPTY()) {
        bitmask |= (1 << 1);
    }
    if (in.getWeatherAlert()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_AnnoTypes& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o265;
    in >> o265;
    uint8 bitmask(o265);

    if (bitmask & (1 << 0)) {
        out.setTP (true);
    }
    if (bitmask & (1 << 1)) {
        out.setPTY (true);
    }
    if (bitmask & (1 << 2)) {
        out.setWeatherAlert (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Anno_Message& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTA()) {
        bitmask |= (1 << 0);
    }
    if (in.getPTY31()) {
        bitmask |= (1 << 1);
    }
    if (in.getWeatherAlert()) {
        bitmask |= (1 << 2);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Anno_Message& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o266;
    in >> o266;
    uint8 bitmask(o266);

    if (bitmask & (1 << 0)) {
        out.setTA (true);
    }
    if (bitmask & (1 << 1)) {
        out.setPTY31 (true);
    }
    if (bitmask & (1 << 2)) {
        out.setWeatherAlert (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_AnnoInfostatus& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSAnnoStationName();
    out << in.getU32Frequency();
    out << in.getU16PI();
    out << in.getU8Quality();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_AnnoInfostatus& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o267;
    in >> o267;
    out.setSAnnoStationName(o267);
    uint32 o268;
    in >> o268;
    out.setU32Frequency(o268);
    uint16 o269;
    in >> o269;
    out.setU16PI(o269);
    uint8 o270;
    in >> o270;
    out.setU8Quality(o270);
}

void serializeCca(const ::midw_tuner_fi_types::T_Tun_Engg_Param_List_Elem& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ParameterID();
    out << in.getU32ParameterValue();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_Tun_Engg_Param_List_Elem& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o271;
    in >> o271;
    out.setE8ParameterID((::midw_tuner_fi_types::T_e8_Tun_Engg_Param_ID)o271);
    uint32 o272;
    in >> o272;
    out.setU32ParameterValue(o272);
}

void serializeCca(const ::midw_tuner_fi_types::T_AvailableBandInfoElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8Band();
    out << in.getU32HighFrequency();
    out << in.getU32LowFrequency();
    out << in.getU16AutoSeekStepWidth();
    out << in.getU16ManualStepWidth();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_AvailableBandInfoElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o273;
    in >> o273;
    out.setE8Band((::midw_tuner_fi_types::T_e8_Tun_TunerBand)o273);
    uint32 o274;
    in >> o274;
    out.setU32HighFrequency(o274);
    uint32 o275;
    in >> o275;
    out.setU32LowFrequency(o275);
    uint16 o276;
    in >> o276;
    out.setU16AutoSeekStepWidth(o276);
    uint16 o277;
    in >> o277;
    out.setU16ManualStepWidth(o277);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_DemodSwitch& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getFM_AM()) {
        bitmask |= (1 << 0);
    }
    if (in.getFM_HD()) {
        bitmask |= (1 << 1);
    }
    if (in.getAM_HD()) {
        bitmask |= (1 << 2);
    }
    if (in.getDRM30()) {
        bitmask |= (1 << 3);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_DemodSwitch& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o278;
    in >> o278;
    uint8 bitmask(o278);

    if (bitmask & (1 << 0)) {
        out.setFM_AM (true);
    }
    if (bitmask & (1 << 1)) {
        out.setFM_HD (true);
    }
    if (bitmask & (1 << 2)) {
        out.setAM_HD (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDRM30 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_HDInfoBits& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getHD_MODULATION_DETECTION()) {
        bitmask |= (1 << 0);
    }
    if (in.getHD_DATA_DECODING()) {
        bitmask |= (1 << 1);
    }
    if (in.getHD_AUDIO_DECODING()) {
        bitmask |= (1 << 2);
    }
    if (in.getHD_BLEND_ANALOG()) {
        bitmask |= (1 << 3);
    }
    if (in.getHD_DIGITAL_AUDIO_MUTE()) {
        bitmask |= (1 << 4);
    }
    if (in.getHD_BALLGAME_MODE()) {
        bitmask |= (1 << 5);
    }
    if (in.getRESERVED_1()) {
        bitmask |= (1 << 6);
    }
    if (in.getRESERVED_2()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_HDInfoBits& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o279;
    in >> o279;
    uint8 bitmask(o279);

    if (bitmask & (1 << 0)) {
        out.setHD_MODULATION_DETECTION (true);
    }
    if (bitmask & (1 << 1)) {
        out.setHD_DATA_DECODING (true);
    }
    if (bitmask & (1 << 2)) {
        out.setHD_AUDIO_DECODING (true);
    }
    if (bitmask & (1 << 3)) {
        out.setHD_BLEND_ANALOG (true);
    }
    if (bitmask & (1 << 4)) {
        out.setHD_DIGITAL_AUDIO_MUTE (true);
    }
    if (bitmask & (1 << 5)) {
        out.setHD_BALLGAME_MODE (true);
    }
    if (bitmask & (1 << 6)) {
        out.setRESERVED_1 (true);
    }
    if (bitmask & (1 << 7)) {
        out.setRESERVED_2 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_HDPrgmAvail& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getMPS_AVAIL()) {
        bitmask |= (1 << 0);
    }
    if (in.getSPS_1_AVAIL()) {
        bitmask |= (1 << 1);
    }
    if (in.getSPS_2_AVAIL()) {
        bitmask |= (1 << 2);
    }
    if (in.getSPS_3_AVAIL()) {
        bitmask |= (1 << 3);
    }
    if (in.getSPS_4_AVAIL()) {
        bitmask |= (1 << 4);
    }
    if (in.getSPS_5_AVAIL()) {
        bitmask |= (1 << 5);
    }
    if (in.getSPS_6_AVAIL()) {
        bitmask |= (1 << 6);
    }
    if (in.getSPS_7_AVAIL()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_HDPrgmAvail& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o280;
    in >> o280;
    uint8 bitmask(o280);

    if (bitmask & (1 << 0)) {
        out.setMPS_AVAIL (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSPS_1_AVAIL (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSPS_2_AVAIL (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSPS_3_AVAIL (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSPS_4_AVAIL (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSPS_5_AVAIL (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSPS_6_AVAIL (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSPS_7_AVAIL (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_DRMStationInfoBits& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getDRM_MODULATION_DETECTION()) {
        bitmask |= (1 << 0);
    }
    if (in.getDRM_MULTIPLEX_INFO_DECODING()) {
        bitmask |= (1 << 1);
    }
    if (in.getDRM_AUDIO_DECODING()) {
        bitmask |= (1 << 2);
    }
    if (in.getDRM_AUDIO_MUTE()) {
        bitmask |= (1 << 3);
    }
    if (in.getRESERVED_1()) {
        bitmask |= (1 << 4);
    }
    if (in.getRESERVED_2()) {
        bitmask |= (1 << 5);
    }
    if (in.getRESERVED_3()) {
        bitmask |= (1 << 6);
    }
    if (in.getRESERVED_4()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_DRMStationInfoBits& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o281;
    in >> o281;
    uint8 bitmask(o281);

    if (bitmask & (1 << 0)) {
        out.setDRM_MODULATION_DETECTION (true);
    }
    if (bitmask & (1 << 1)) {
        out.setDRM_MULTIPLEX_INFO_DECODING (true);
    }
    if (bitmask & (1 << 2)) {
        out.setDRM_AUDIO_DECODING (true);
    }
    if (bitmask & (1 << 3)) {
        out.setDRM_AUDIO_MUTE (true);
    }
    if (bitmask & (1 << 4)) {
        out.setRESERVED_1 (true);
    }
    if (bitmask & (1 << 5)) {
        out.setRESERVED_2 (true);
    }
    if (bitmask & (1 << 6)) {
        out.setRESERVED_3 (true);
    }
    if (bitmask & (1 << 7)) {
        out.setRESERVED_4 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b16_Tun_DRMAnnouBits& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 bitmask = 0;
    if (in.getRESERVED_1()) {
        bitmask |= (1 << 0);
    }
    if (in.getRESERVED_2()) {
        bitmask |= (1 << 1);
    }
    if (in.getRESERVED_3()) {
        bitmask |= (1 << 2);
    }
    if (in.getRESERVED_4()) {
        bitmask |= (1 << 3);
    }
    if (in.getRESERVED_5()) {
        bitmask |= (1 << 4);
    }
    if (in.getRESERVED_6()) {
        bitmask |= (1 << 5);
    }
    if (in.getRESERVED_7()) {
        bitmask |= (1 << 6);
    }
    if (in.getRESERVED_8()) {
        bitmask |= (1 << 7);
    }
    if (in.getRESERVED_9()) {
        bitmask |= (1 << 8);
    }
    if (in.getRESERVED_10()) {
        bitmask |= (1 << 9);
    }
    if (in.getRESERVED_11()) {
        bitmask |= (1 << 10);
    }
    if (in.getRESERVED_12()) {
        bitmask |= (1 << 11);
    }
    if (in.getRESERVED_13()) {
        bitmask |= (1 << 12);
    }
    if (in.getRESERVED_14()) {
        bitmask |= (1 << 13);
    }
    if (in.getRESERVED_15()) {
        bitmask |= (1 << 14);
    }
    if (in.getRESERVED_16()) {
        bitmask |= (1 << 15);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b16_Tun_DRMAnnouBits& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o282;
    in >> o282;
    uint16 bitmask(o282);

    if (bitmask & (1 << 0)) {
        out.setRESERVED_1 (true);
    }
    if (bitmask & (1 << 1)) {
        out.setRESERVED_2 (true);
    }
    if (bitmask & (1 << 2)) {
        out.setRESERVED_3 (true);
    }
    if (bitmask & (1 << 3)) {
        out.setRESERVED_4 (true);
    }
    if (bitmask & (1 << 4)) {
        out.setRESERVED_5 (true);
    }
    if (bitmask & (1 << 5)) {
        out.setRESERVED_6 (true);
    }
    if (bitmask & (1 << 6)) {
        out.setRESERVED_7 (true);
    }
    if (bitmask & (1 << 7)) {
        out.setRESERVED_8 (true);
    }
    if (bitmask & (1 << 8)) {
        out.setRESERVED_9 (true);
    }
    if (bitmask & (1 << 9)) {
        out.setRESERVED_10 (true);
    }
    if (bitmask & (1 << 10)) {
        out.setRESERVED_11 (true);
    }
    if (bitmask & (1 << 11)) {
        out.setRESERVED_12 (true);
    }
    if (bitmask & (1 << 12)) {
        out.setRESERVED_13 (true);
    }
    if (bitmask & (1 << 13)) {
        out.setRESERVED_14 (true);
    }
    if (bitmask & (1 << 14)) {
        out.setRESERVED_15 (true);
    }
    if (bitmask & (1 << 15)) {
        out.setRESERVED_16 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_DRMNumberOfAudioServices& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getAUDIO_PROGRAM_1()) {
        bitmask |= (1 << 0);
    }
    if (in.getAUDIO_PROGRAM_2()) {
        bitmask |= (1 << 1);
    }
    if (in.getAUDIO_PROGRAM_3()) {
        bitmask |= (1 << 2);
    }
    if (in.getAUDIO_PROGRAM_4()) {
        bitmask |= (1 << 3);
    }
    if (in.getRESERVED_1()) {
        bitmask |= (1 << 4);
    }
    if (in.getRESERVED_2()) {
        bitmask |= (1 << 5);
    }
    if (in.getRESERVED_3()) {
        bitmask |= (1 << 6);
    }
    if (in.getRESERVED_4()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_DRMNumberOfAudioServices& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o283;
    in >> o283;
    uint8 bitmask(o283);

    if (bitmask & (1 << 0)) {
        out.setAUDIO_PROGRAM_1 (true);
    }
    if (bitmask & (1 << 1)) {
        out.setAUDIO_PROGRAM_2 (true);
    }
    if (bitmask & (1 << 2)) {
        out.setAUDIO_PROGRAM_3 (true);
    }
    if (bitmask & (1 << 3)) {
        out.setAUDIO_PROGRAM_4 (true);
    }
    if (bitmask & (1 << 4)) {
        out.setRESERVED_1 (true);
    }
    if (bitmask & (1 << 5)) {
        out.setRESERVED_2 (true);
    }
    if (bitmask & (1 << 6)) {
        out.setRESERVED_3 (true);
    }
    if (bitmask & (1 << 7)) {
        out.setRESERVED_4 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_Digital_Filters& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getSTATIONLIST_WITHONLY_HDMPS()) {
        bitmask |= (1 << 0);
    }
    if (in.getSTATIONLIST_WITH_HDMPS_SPS()) {
        bitmask |= (1 << 1);
    }
    if (in.getSTATIONLIST_WITH_DRM()) {
        bitmask |= (1 << 2);
    }
    if (in.getRESERVED_1()) {
        bitmask |= (1 << 3);
    }
    if (in.getRESERVED_2()) {
        bitmask |= (1 << 4);
    }
    if (in.getRESERVED_3()) {
        bitmask |= (1 << 5);
    }
    if (in.getRESERVED_4()) {
        bitmask |= (1 << 6);
    }
    if (in.getRESERVED_5()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_Digital_Filters& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o284;
    in >> o284;
    uint8 bitmask(o284);

    if (bitmask & (1 << 0)) {
        out.setSTATIONLIST_WITHONLY_HDMPS (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSTATIONLIST_WITH_HDMPS_SPS (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSTATIONLIST_WITH_DRM (true);
    }
    if (bitmask & (1 << 3)) {
        out.setRESERVED_1 (true);
    }
    if (bitmask & (1 << 4)) {
        out.setRESERVED_2 (true);
    }
    if (bitmask & (1 << 5)) {
        out.setRESERVED_3 (true);
    }
    if (bitmask & (1 << 6)) {
        out.setRESERVED_4 (true);
    }
    if (bitmask & (1 << 7)) {
        out.setRESERVED_5 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_HDNumOfAudioPrograms& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getTUN_HD_AUDIOPROGRAM_MPS()) {
        bitmask |= (1 << 0);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS1()) {
        bitmask |= (1 << 1);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS2()) {
        bitmask |= (1 << 2);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS3()) {
        bitmask |= (1 << 3);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS4()) {
        bitmask |= (1 << 4);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS5()) {
        bitmask |= (1 << 5);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS6()) {
        bitmask |= (1 << 6);
    }
    if (in.getTUN_HD_AUDIOPROGRAM_SPS7()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_HDNumOfAudioPrograms& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o285;
    in >> o285;
    uint8 bitmask(o285);

    if (bitmask & (1 << 0)) {
        out.setTUN_HD_AUDIOPROGRAM_MPS (true);
    }
    if (bitmask & (1 << 1)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS1 (true);
    }
    if (bitmask & (1 << 2)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS2 (true);
    }
    if (bitmask & (1 << 3)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS3 (true);
    }
    if (bitmask & (1 << 4)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS4 (true);
    }
    if (bitmask & (1 << 5)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS5 (true);
    }
    if (bitmask & (1 << 6)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS6 (true);
    }
    if (bitmask & (1 << 7)) {
        out.setTUN_HD_AUDIOPROGRAM_SPS7 (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerHDTestModeData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8PhysicalTuner();
    out << in.getSHDCallSign();
    out << in.getU32HDStationId();
    serializeCca(in.getB8HDAvailableAudioPrograms(), out, majorVersion);
    out << (uint8) in.getE8HDActiveAudioProgram();
    out << in.getU8AudioQuality();
    serializeCca(in.getB8HDStationInfoBits(), out, majorVersion);
    out << in.getU8ACQStates();
    out << in.getU8CD_NO();
    out << in.getU8TransitionCount();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerHDTestModeData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o286;
    in >> o286;
    out.setE8PhysicalTuner((::midw_tuner_fi_types::T_e8_Tun_PhysicalTuner)o286);
    ::std::string o287;
    in >> o287;
    out.setSHDCallSign(o287);
    uint32 o288;
    in >> o288;
    out.setU32HDStationId(o288);
    deserializeCca(in, out.getB8HDAvailableAudioProgramsMutable(), majorVersion);
    uint8 o289;
    in >> o289;
    out.setE8HDActiveAudioProgram((::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram)o289);
    uint8 o290;
    in >> o290;
    out.setU8AudioQuality(o290);
    deserializeCca(in, out.getB8HDStationInfoBitsMutable(), majorVersion);
    uint8 o291;
    in >> o291;
    out.setU8ACQStates(o291);
    uint8 o292;
    in >> o292;
    out.setU8CD_NO(o292);
    uint8 o293;
    in >> o293;
    out.setU8TransitionCount(o293);
}

void serializeCca(const ::midw_tuner_fi_types::T_ImageFileInfo& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU32HDStationId();
    out << (uint8) in.getE8HDImageType();
    out << (uint8) in.getE8HDImageCoding();
    out << (uint8) in.getE8HDAudioProgram();
    out << in.getU32NoOfImageFileBytes();
    {
        uint32 o294 = static_cast<uint32>(in.getImageFileBytes().size());
        out << o294;
        ::std::vector< uint8 >::const_iterator o295;
        for (o295 = in.getImageFileBytes().begin(); o295 != in.getImageFileBytes().end(); ++o295) {
            out << (*o295);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_ImageFileInfo& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint32 o296;
    in >> o296;
    out.setU32HDStationId(o296);
    uint8 o297;
    in >> o297;
    out.setE8HDImageType((::midw_tuner_fi_types::T_e8_Tun_HDImageType)o297);
    uint8 o298;
    in >> o298;
    out.setE8HDImageCoding((::midw_tuner_fi_types::T_e8_Tun_HDImageCoding)o298);
    uint8 o299;
    in >> o299;
    out.setE8HDAudioProgram((::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram)o299);
    uint32 o300;
    in >> o300;
    out.setU32NoOfImageFileBytes(o300);
    {
        uint32 o301;
        in >> o301;
        out.getImageFileBytesMutable().clear ();
        out.getImageFileBytesMutable().reserve (o301);
        for (uint32 o302 = 0; o302 < o301; o302++) {
            uint8 o303;
            in >> o303;
            out.getImageFileBytesMutable().push_back(o303);
        }
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunPSDCommercial& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSPriceString();
    out << in.getSValidUntil();
    out << in.getSContactURL();
    out << in.getSReceivedAs();
    out << in.getSNameOfSeller();
    out << in.getSDescription();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunPSDCommercial& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o304;
    in >> o304;
    out.setSPriceString(o304);
    ::std::string o305;
    in >> o305;
    out.setSValidUntil(o305);
    ::std::string o306;
    in >> o306;
    out.setSContactURL(o306);
    ::std::string o307;
    in >> o307;
    out.setSReceivedAs(o307);
    ::std::string o308;
    in >> o308;
    out.setSNameOfSeller(o308);
    ::std::string o309;
    in >> o309;
    out.setSDescription(o309);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunPSDComment& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getSLanguage();
    out << in.getSShortContentDescription();
    out << in.getSActualText();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunPSDComment& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    ::std::string o310;
    in >> o310;
    out.setSLanguage(o310);
    ::std::string o311;
    in >> o311;
    out.setSShortContentDescription(o311);
    ::std::string o312;
    in >> o312;
    out.setSActualText(o312);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunPSDData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8HDAudioProgram();
    out << in.getSTitle();
    out << in.getSArtist();
    out << in.getSAlbum();
    out << in.getSGenre();
    serializeCca(in.getTunPSDCommercial(), out, majorVersion);
    serializeCca(in.getTunPSDComment(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunPSDData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o313;
    in >> o313;
    out.setE8HDAudioProgram((::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram)o313);
    ::std::string o314;
    in >> o314;
    out.setSTitle(o314);
    ::std::string o315;
    in >> o315;
    out.setSArtist(o315);
    ::std::string o316;
    in >> o316;
    out.setSAlbum(o316);
    ::std::string o317;
    in >> o317;
    out.setSGenre(o317);
    deserializeCca(in, out.getTunPSDCommercialMutable(), majorVersion);
    deserializeCca(in, out.getTunPSDCommentMutable(), majorVersion);
}

void serializeCca(const ::midw_tuner_fi_types::T_CalibrationData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getPhysicalTunerOne(), out, majorVersion);
    serializeCca(in.getPhysicalTunerTwo(), out, majorVersion);
    serializeCca(in.getPhysicalTunerThree(), out, majorVersion);
    serializeCca(in.getPhysicalTunerFour(), out, majorVersion);
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_CalibrationData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getPhysicalTunerOneMutable(), majorVersion);
    deserializeCca(in, out.getPhysicalTunerTwoMutable(), majorVersion);
    deserializeCca(in, out.getPhysicalTunerThreeMutable(), majorVersion);
    deserializeCca(in, out.getPhysicalTunerFourMutable(), majorVersion);
}

void serializeCca(const ::midw_tuner_fi_types::T_PhysicalTunerCalibData& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getB8AvailableBands(), out, majorVersion);
    out << in.getU16FMCalibrationValue();
    out << in.getU16AMCalibrationValue();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_PhysicalTunerCalibData& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getB8AvailableBandsMutable(), majorVersion);
    uint16 o318;
    in >> o318;
    out.setU16FMCalibrationValue(o318);
    uint16 o319;
    in >> o319;
    out.setU16AMCalibrationValue(o319);
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerJapanStationName& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << in.getU16IndexID();
    out << in.getSJapanStationName();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerJapanStationName& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint16 o320;
    in >> o320;
    out.setU16IndexID(o320);
    ::std::string o321;
    in >> o321;
    out.setSJapanStationName(o321);
}

void serializeCca(const ::midw_tuner_fi_types::T_DARCDataBlock& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    serializeCca(in.getSTAT_Status_Register(), out, majorVersion);
    out << in.getBlock_Number_Register();
    {
        uint32 o322 = static_cast<uint32>(in.getDARCDataList().size());
        out << o322;
        ::std::vector< uint8 >::const_iterator o323;
        for (o323 = in.getDARCDataList().begin(); o323 != in.getDARCDataList().end(); ++o323) {
            out << (*o323);
        }
    }
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_DARCDataBlock& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    deserializeCca(in, out.getSTAT_Status_RegisterMutable(), majorVersion);
    uint8 o324;
    in >> o324;
    out.setBlock_Number_Register(o324);
    {
        uint32 o325;
        in >> o325;
        out.getDARCDataListMutable().clear ();
        out.getDARCDataListMutable().reserve (o325);
        for (uint32 o326 = 0; o326 < o325; o326++) {
            uint8 o327;
            in >> o327;
            out.getDARCDataListMutable().push_back(o327);
        }
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_STATStatusRegister& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getReserved()) {
        bitmask |= (1 << 0);
    }
    if (in.getSTAT_CRC4()) {
        bitmask |= (1 << 1);
    }
    if (in.getSTAT_HEAD()) {
        bitmask |= (1 << 2);
    }
    if (in.getSTAT_PRI()) {
        bitmask |= (1 << 3);
    }
    if (in.getSTAT_ERR()) {
        bitmask |= (1 << 4);
    }
    if (in.getSTAT_FRM()) {
        bitmask |= (1 << 5);
    }
    if (in.getSTAT_BLK()) {
        bitmask |= (1 << 6);
    }
    if (in.getSTAT_VH()) {
        bitmask |= (1 << 7);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_STATStatusRegister& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o328;
    in >> o328;
    uint8 bitmask(o328);

    if (bitmask & (1 << 0)) {
        out.setReserved (true);
    }
    if (bitmask & (1 << 1)) {
        out.setSTAT_CRC4 (true);
    }
    if (bitmask & (1 << 2)) {
        out.setSTAT_HEAD (true);
    }
    if (bitmask & (1 << 3)) {
        out.setSTAT_PRI (true);
    }
    if (bitmask & (1 << 4)) {
        out.setSTAT_ERR (true);
    }
    if (bitmask & (1 << 5)) {
        out.setSTAT_FRM (true);
    }
    if (bitmask & (1 << 6)) {
        out.setSTAT_BLK (true);
    }
    if (bitmask & (1 << 7)) {
        out.setSTAT_VH (true);
    }
}

void serializeCca(const ::midw_tuner_fi_types::T_TunerListElement& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    out << (uint8) in.getE8ListID();
    out << in.getU8ElementID();
    out << (uint8) in.getE8Modulation();
    out << in.getU32Frequency();
    out << in.getU32SID();
    out << in.getU8NumOfCharactersInStationName();
    out << in.getSStationName();
    out << in.getU8StationNameEncoding();
    out << in.getU8ProgramService();
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_TunerListElement& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o329;
    in >> o329;
    out.setE8ListID((::midw_tuner_fi_types::T_e8_Tun_ListID)o329);
    uint8 o330;
    in >> o330;
    out.setU8ElementID(o330);
    uint8 o331;
    in >> o331;
    out.setE8Modulation((::midw_tuner_fi_types::T_e8_Tun_ModulationType)o331);
    uint32 o332;
    in >> o332;
    out.setU32Frequency(o332);
    uint32 o333;
    in >> o333;
    out.setU32SID(o333);
    uint8 o334;
    in >> o334;
    out.setU8NumOfCharactersInStationName(o334);
    ::std::string o335;
    in >> o335;
    out.setSStationName(o335);
    uint8 o336;
    in >> o336;
    out.setU8StationNameEncoding(o336);
    uint8 o337;
    in >> o337;
    out.setU8ProgramService(o337);
}

void serializeCca(const ::midw_tuner_fi_types::T_b8_Tun_SwitchingFrequency& in, ::asf::stream::MemoryStream& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 bitmask = 0;
    if (in.getFREQUENCY_384kHz()) {
        bitmask |= (1 << 0);
    }
    if (in.getFREQUENCY_432kHz()) {
        bitmask |= (1 << 1);
    }
    out << bitmask;
}

void deserializeCca(::asf::stream::MemoryStream& in, ::midw_tuner_fi_types::T_b8_Tun_SwitchingFrequency& out, unsigned int majorVersion) {
    (void)majorVersion; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    uint8 o338;
    in >> o338;
    uint8 bitmask(o338);

    if (bitmask & (1 << 0)) {
        out.setFREQUENCY_384kHz (true);
    }
    if (bitmask & (1 << 1)) {
        out.setFREQUENCY_432kHz (true);
    }
}

