#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_TUNER_FI_TYPES_H
#define MIDW_TUNER_FI_TYPES_H

#include "asf/core/Internal.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "midw_tuner_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types midw_tuner_fi_types
 */

namespace midw_tuner_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_b8_Tun_AFSwitch;

class T_b8_Tun_AudioSink;

class T_b8_Tun_AtStationInfoBits;

class T_b8_Tun_Tunerbandbits;

class T_Audio_FG_BG;

class T_u16CalibrationData;

class T_Aud_FGBG_New;

class T_AudFGBGStatus;

class T_TunerServer_StatusResponse;

class T_b32_Tun_AvailFlags;

class T_b32_Tun_Features;

class T_b8_Tun_Antenna;

class T_TunerStationData;

class T_TunerFeature;

class T_b32_Tun_AvailableFlags;

class T_TunerManualSingleStep;

class T_b8_Tun_OperationFlags;

class T_TunerOperation;

class T_TunerAFList;

class T_b8_Tun_TestmodeBits;

class T_TunerTestModeData;

class T_Sel_List_Elem;

class T_b8_Tun_Digital_Filters;

class T_Tun_MakeConfigList;

class T_Encryption;

class T_MsgSource;

class T_Tun_RDBID_Value;

class T_TunerRdbId;

class T_TunerGetDataTMC;

class T_TrafficInfo;

class T_b8_Tun_PackedInfo;

class T_MakeConfigListElem;

class T_b8_Tun_AvailFlags;

class T_b8_Tun_StationInfo;

class T_b8_Tun_HDNumOfAudioPrograms;

class T_TunerConfigListElement;

class T_Tun_Set_PI;

class T_TunerStaticListElement;

class T_TunerTestRoutineParameter;

class T_Tun_TestTroubleCodeStatus;

class T_TunerFieldstrength;

class T_TunerRadioText;

class T_TunerBandAndStationInfo;

class T_Tun_AutoCompParam;

class T_Component_Status;

class T_b8_Tun_HDInfoBits;

class T_b8_Tun_HDPrgmAvail;

class T_b8_Tun_DRMStationInfoBits;

class T_b16_Tun_DRMAnnouBits;

class T_b8_Tun_DRMNumberOfAudioServices;

class T_Atstationinfo;

class T_TunerTestModeData_DDADDS;

class T_TuningActionConfigParam;

class T_b8_AnnoTypes;

class T_b8_Anno_Message;

class T_AnnoInfostatus;

class T_Tun_Engg_Param_List_Elem;

class T_AvailableBandInfoElement;

class T_b8_Tun_DemodSwitch;

class T_TunerHDTestModeData;

class T_ImageFileInfo;

class T_TunPSDCommercial;

class T_TunPSDComment;

class T_TunPSDData;

class T_PhysicalTunerCalibData;

class T_CalibrationData;

class T_TunerJapanStationName;

class T_b8_Tun_STATStatusRegister;

class T_DARCDataBlock;

class T_TunerListElement;

class T_b8_Tun_SwitchingFrequency;

// type definitions
/**
 * If the meaning of "T_TunerConfigListElementList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_TunerConfigListElement > T_TunerConfigListElementList;

/**
 * If the meaning of "T_TunerStaticListElementList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_TunerStaticListElement > T_TunerStaticListElementList;

/**
 * If the meaning of "T_TunerTestRoutineParameterList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_TunerTestRoutineParameter > T_TunerTestRoutineParameterList;

/**
 * If the meaning of "T_Tun_TestTroubleCodeStatusList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_Tun_TestTroubleCodeStatus > T_Tun_TestTroubleCodeStatusList;

/**
 * If the meaning of "T_AvailableBandInfoList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_AvailableBandInfoElement > T_AvailableBandInfoList;

/**
 * If the meaning of "T_TunerJapanStationNameList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_TunerJapanStationName > T_TunerJapanStationNameList;

/**
 * If the meaning of "T_u32FrequencyList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_u32FrequencyList;

/**
 * If the meaning of "T_DARCDataBlockList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_DARCDataBlock > T_DARCDataBlockList;

/**
 * If the meaning of "T_TunerListElementList" isn't clear, then there should be a description here.
 */
typedef ::boost::ptr_vector< T_TunerListElement > T_TunerListElementList;


/**
 * .
 */
class T_b8_Tun_AFSwitch {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_AFSwitch ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_AFSwitch (const T_b8_Tun_AFSwitch &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_AFSwitch (bool RDS_AFBEST, bool unused, bool DRM_AFBEST);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_AFSwitch& operator = (const T_b8_Tun_AFSwitch& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_AFSwitch& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_AFSwitch& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_AFSwitch& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_AFSwitch& rhs) const;

    /**
     * Sets the value of the member "RDS_AFBEST".
     *
     * If the meaning of "RDS_AFBEST" isn't clear, then there should be a description here.
     *
     * @param RDS_AFBEST The value which will be set
     */
    inline void setRDS_AFBEST (bool RDS_AFBEST);

    /**
     * Returns the value of the member "RDS_AFBEST".
     *
     * If the meaning of "RDS_AFBEST" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RDS_AFBEST"
     */
    inline bool getRDS_AFBEST () const;

    /**
     * Sets the value of the member "unused".
     *
     * If the meaning of "unused" isn't clear, then there should be a description here.
     *
     * @param unused The value which will be set
     */
    inline void setUnused (bool unused);

    /**
     * Returns the value of the member "unused".
     *
     * If the meaning of "unused" isn't clear, then there should be a description here.
     *
     * @return The value of the field "unused"
     */
    inline bool getUnused () const;

    /**
     * Sets the value of the member "DRM_AFBEST".
     *
     * If the meaning of "DRM_AFBEST" isn't clear, then there should be a description here.
     *
     * @param DRM_AFBEST The value which will be set
     */
    inline void setDRM_AFBEST (bool DRM_AFBEST);

    /**
     * Returns the value of the member "DRM_AFBEST".
     *
     * If the meaning of "DRM_AFBEST" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DRM_AFBEST"
     */
    inline bool getDRM_AFBEST () const;

    static const T_b8_Tun_AFSwitch &getDefaultInstance();

private:

    bool _RDS_AFBEST:1;

    bool _unused:1;

    bool _DRM_AFBEST:1;

};

/**
 * .
 */
class T_b8_Tun_AudioSink {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_AudioSink ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_AudioSink (const T_b8_Tun_AudioSink &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_AudioSink (bool USR1_SWITCHED_TUN_TOFG, bool TA_SWITCHED_TUN_TOFG, bool TIM_SWITCHED_TUN_TOFG, bool PTY_SWITCHED_TUN_TOFG, bool NEWS_SWITCHED_TUN_TOFG, bool DABTEMP_SWITCHED_TUN_TOFG, bool TEMPFM_SWITCHED_TUN_TOFG, bool RESERVED1);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_AudioSink& operator = (const T_b8_Tun_AudioSink& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_AudioSink& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_AudioSink& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_AudioSink& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_AudioSink& rhs) const;

    /**
     * Sets the value of the member "USR1_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "USR1_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param USR1_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setUSR1_SWITCHED_TUN_TOFG (bool USR1_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "USR1_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "USR1_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "USR1_SWITCHED_TUN_TOFG"
     */
    inline bool getUSR1_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "TA_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "TA_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param TA_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setTA_SWITCHED_TUN_TOFG (bool TA_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "TA_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "TA_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TA_SWITCHED_TUN_TOFG"
     */
    inline bool getTA_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "TIM_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "TIM_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param TIM_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setTIM_SWITCHED_TUN_TOFG (bool TIM_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "TIM_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "TIM_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TIM_SWITCHED_TUN_TOFG"
     */
    inline bool getTIM_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "PTY_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "PTY_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param PTY_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setPTY_SWITCHED_TUN_TOFG (bool PTY_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "PTY_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "PTY_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PTY_SWITCHED_TUN_TOFG"
     */
    inline bool getPTY_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "NEWS_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "NEWS_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param NEWS_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setNEWS_SWITCHED_TUN_TOFG (bool NEWS_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "NEWS_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "NEWS_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "NEWS_SWITCHED_TUN_TOFG"
     */
    inline bool getNEWS_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "DABTEMP_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "DABTEMP_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param DABTEMP_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setDABTEMP_SWITCHED_TUN_TOFG (bool DABTEMP_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "DABTEMP_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "DABTEMP_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DABTEMP_SWITCHED_TUN_TOFG"
     */
    inline bool getDABTEMP_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "TEMPFM_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "TEMPFM_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @param TEMPFM_SWITCHED_TUN_TOFG The value which will be set
     */
    inline void setTEMPFM_SWITCHED_TUN_TOFG (bool TEMPFM_SWITCHED_TUN_TOFG);

    /**
     * Returns the value of the member "TEMPFM_SWITCHED_TUN_TOFG".
     *
     * If the meaning of "TEMPFM_SWITCHED_TUN_TOFG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TEMPFM_SWITCHED_TUN_TOFG"
     */
    inline bool getTEMPFM_SWITCHED_TUN_TOFG () const;

    /**
     * Sets the value of the member "RESERVED1".
     *
     * If the meaning of "RESERVED1" isn't clear, then there should be a description here.
     *
     * @param RESERVED1 The value which will be set
     */
    inline void setRESERVED1 (bool RESERVED1);

    /**
     * Returns the value of the member "RESERVED1".
     *
     * If the meaning of "RESERVED1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED1"
     */
    inline bool getRESERVED1 () const;

    static const T_b8_Tun_AudioSink &getDefaultInstance();

private:

    bool _USR1_SWITCHED_TUN_TOFG:1;

    bool _TA_SWITCHED_TUN_TOFG:1;

    bool _TIM_SWITCHED_TUN_TOFG:1;

    bool _PTY_SWITCHED_TUN_TOFG:1;

    bool _NEWS_SWITCHED_TUN_TOFG:1;

    bool _DABTEMP_SWITCHED_TUN_TOFG:1;

    bool _TEMPFM_SWITCHED_TUN_TOFG:1;

    bool _RESERVED1:1;

};

/**
 * .
 */
class T_b8_Tun_AtStationInfoBits {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_AtStationInfoBits ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_AtStationInfoBits (const T_b8_Tun_AtStationInfoBits &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_AtStationInfoBits (bool MONO_OR_STEREO_BIT, bool SPEECH_OR_MUSIC_BIT, bool RADIOTEXT_POSSIBLE_BIT, bool ALTERNATE_FREQUENCY_BIT, bool RADIOTEXT_AVAILABLE_BIT, bool AF_AVAILABLE_BIT, bool HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE, bool MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_AtStationInfoBits& operator = (const T_b8_Tun_AtStationInfoBits& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_AtStationInfoBits& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_AtStationInfoBits& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_AtStationInfoBits& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_AtStationInfoBits& rhs) const;

    /**
     * Sets the value of the member "MONO_OR_STEREO_BIT".
     *
     * If the meaning of "MONO_OR_STEREO_BIT" isn't clear, then there should be a description here.
     *
     * @param MONO_OR_STEREO_BIT The value which will be set
     */
    inline void setMONO_OR_STEREO_BIT (bool MONO_OR_STEREO_BIT);

    /**
     * Returns the value of the member "MONO_OR_STEREO_BIT".
     *
     * If the meaning of "MONO_OR_STEREO_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MONO_OR_STEREO_BIT"
     */
    inline bool getMONO_OR_STEREO_BIT () const;

    /**
     * Sets the value of the member "SPEECH_OR_MUSIC_BIT".
     *
     * If the meaning of "SPEECH_OR_MUSIC_BIT" isn't clear, then there should be a description here.
     *
     * @param SPEECH_OR_MUSIC_BIT The value which will be set
     */
    inline void setSPEECH_OR_MUSIC_BIT (bool SPEECH_OR_MUSIC_BIT);

    /**
     * Returns the value of the member "SPEECH_OR_MUSIC_BIT".
     *
     * If the meaning of "SPEECH_OR_MUSIC_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPEECH_OR_MUSIC_BIT"
     */
    inline bool getSPEECH_OR_MUSIC_BIT () const;

    /**
     * Sets the value of the member "RADIOTEXT_POSSIBLE_BIT".
     *
     * If the meaning of "RADIOTEXT_POSSIBLE_BIT" isn't clear, then there should be a description here.
     *
     * @param RADIOTEXT_POSSIBLE_BIT The value which will be set
     */
    inline void setRADIOTEXT_POSSIBLE_BIT (bool RADIOTEXT_POSSIBLE_BIT);

    /**
     * Returns the value of the member "RADIOTEXT_POSSIBLE_BIT".
     *
     * If the meaning of "RADIOTEXT_POSSIBLE_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RADIOTEXT_POSSIBLE_BIT"
     */
    inline bool getRADIOTEXT_POSSIBLE_BIT () const;

    /**
     * Sets the value of the member "ALTERNATE_FREQUENCY_BIT".
     *
     * If the meaning of "ALTERNATE_FREQUENCY_BIT" isn't clear, then there should be a description here.
     *
     * @param ALTERNATE_FREQUENCY_BIT The value which will be set
     */
    inline void setALTERNATE_FREQUENCY_BIT (bool ALTERNATE_FREQUENCY_BIT);

    /**
     * Returns the value of the member "ALTERNATE_FREQUENCY_BIT".
     *
     * If the meaning of "ALTERNATE_FREQUENCY_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ALTERNATE_FREQUENCY_BIT"
     */
    inline bool getALTERNATE_FREQUENCY_BIT () const;

    /**
     * Sets the value of the member "RADIOTEXT_AVAILABLE_BIT".
     *
     * If the meaning of "RADIOTEXT_AVAILABLE_BIT" isn't clear, then there should be a description here.
     *
     * @param RADIOTEXT_AVAILABLE_BIT The value which will be set
     */
    inline void setRADIOTEXT_AVAILABLE_BIT (bool RADIOTEXT_AVAILABLE_BIT);

    /**
     * Returns the value of the member "RADIOTEXT_AVAILABLE_BIT".
     *
     * If the meaning of "RADIOTEXT_AVAILABLE_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RADIOTEXT_AVAILABLE_BIT"
     */
    inline bool getRADIOTEXT_AVAILABLE_BIT () const;

    /**
     * Sets the value of the member "AF_AVAILABLE_BIT".
     *
     * If the meaning of "AF_AVAILABLE_BIT" isn't clear, then there should be a description here.
     *
     * @param AF_AVAILABLE_BIT The value which will be set
     */
    inline void setAF_AVAILABLE_BIT (bool AF_AVAILABLE_BIT);

    /**
     * Returns the value of the member "AF_AVAILABLE_BIT".
     *
     * If the meaning of "AF_AVAILABLE_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AF_AVAILABLE_BIT"
     */
    inline bool getAF_AVAILABLE_BIT () const;

    /**
     * Sets the value of the member "HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE".
     *
     * If the meaning of "HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE" isn't clear, then there should be a description here.
     *
     * @param HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE The value which will be set
     */
    inline void setHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE (bool HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE);

    /**
     * Returns the value of the member "HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE".
     *
     * If the meaning of "HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE"
     */
    inline bool getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE () const;

    /**
     * Sets the value of the member "MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL".
     *
     * If the meaning of "MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL" isn't clear, then there should be a description here.
     *
     * @param MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL The value which will be set
     */
    inline void setMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL (bool MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL);

    /**
     * Returns the value of the member "MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL".
     *
     * If the meaning of "MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL"
     */
    inline bool getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL () const;

    static const T_b8_Tun_AtStationInfoBits &getDefaultInstance();

private:

    bool _MONO_OR_STEREO_BIT:1;

    bool _SPEECH_OR_MUSIC_BIT:1;

    bool _RADIOTEXT_POSSIBLE_BIT:1;

    bool _ALTERNATE_FREQUENCY_BIT:1;

    bool _RADIOTEXT_AVAILABLE_BIT:1;

    bool _AF_AVAILABLE_BIT:1;

    bool _HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE:1;

    bool _MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL:1;

};

/**
 * .
 */
class T_b8_Tun_Tunerbandbits {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_Tunerbandbits ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_Tunerbandbits (const T_b8_Tun_Tunerbandbits &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_Tunerbandbits (bool DDAMASTER_OR_NOT_A_DDAMASTER, bool DDASLAVE_OR_NOT_A_DDASLAVE, bool FM_SUPPORTED_OR_FM_NOTSUPPORTED, bool AM_SUPPORTED_OR_AM_NOTSUPPORTED, bool DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED, bool DABL_SUPPORTED_OR_DABL_NOTSUPPORTED);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_Tunerbandbits& operator = (const T_b8_Tun_Tunerbandbits& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_Tunerbandbits& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_Tunerbandbits& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_Tunerbandbits& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_Tunerbandbits& rhs) const;

    /**
     * Sets the value of the member "DDAMASTER_OR_NOT_A_DDAMASTER".
     *
     * If the meaning of "DDAMASTER_OR_NOT_A_DDAMASTER" isn't clear, then there should be a description here.
     *
     * @param DDAMASTER_OR_NOT_A_DDAMASTER The value which will be set
     */
    inline void setDDAMASTER_OR_NOT_A_DDAMASTER (bool DDAMASTER_OR_NOT_A_DDAMASTER);

    /**
     * Returns the value of the member "DDAMASTER_OR_NOT_A_DDAMASTER".
     *
     * If the meaning of "DDAMASTER_OR_NOT_A_DDAMASTER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DDAMASTER_OR_NOT_A_DDAMASTER"
     */
    inline bool getDDAMASTER_OR_NOT_A_DDAMASTER () const;

    /**
     * Sets the value of the member "DDASLAVE_OR_NOT_A_DDASLAVE".
     *
     * If the meaning of "DDASLAVE_OR_NOT_A_DDASLAVE" isn't clear, then there should be a description here.
     *
     * @param DDASLAVE_OR_NOT_A_DDASLAVE The value which will be set
     */
    inline void setDDASLAVE_OR_NOT_A_DDASLAVE (bool DDASLAVE_OR_NOT_A_DDASLAVE);

    /**
     * Returns the value of the member "DDASLAVE_OR_NOT_A_DDASLAVE".
     *
     * If the meaning of "DDASLAVE_OR_NOT_A_DDASLAVE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DDASLAVE_OR_NOT_A_DDASLAVE"
     */
    inline bool getDDASLAVE_OR_NOT_A_DDASLAVE () const;

    /**
     * Sets the value of the member "FM_SUPPORTED_OR_FM_NOTSUPPORTED".
     *
     * If the meaning of "FM_SUPPORTED_OR_FM_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @param FM_SUPPORTED_OR_FM_NOTSUPPORTED The value which will be set
     */
    inline void setFM_SUPPORTED_OR_FM_NOTSUPPORTED (bool FM_SUPPORTED_OR_FM_NOTSUPPORTED);

    /**
     * Returns the value of the member "FM_SUPPORTED_OR_FM_NOTSUPPORTED".
     *
     * If the meaning of "FM_SUPPORTED_OR_FM_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FM_SUPPORTED_OR_FM_NOTSUPPORTED"
     */
    inline bool getFM_SUPPORTED_OR_FM_NOTSUPPORTED () const;

    /**
     * Sets the value of the member "AM_SUPPORTED_OR_AM_NOTSUPPORTED".
     *
     * If the meaning of "AM_SUPPORTED_OR_AM_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @param AM_SUPPORTED_OR_AM_NOTSUPPORTED The value which will be set
     */
    inline void setAM_SUPPORTED_OR_AM_NOTSUPPORTED (bool AM_SUPPORTED_OR_AM_NOTSUPPORTED);

    /**
     * Returns the value of the member "AM_SUPPORTED_OR_AM_NOTSUPPORTED".
     *
     * If the meaning of "AM_SUPPORTED_OR_AM_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AM_SUPPORTED_OR_AM_NOTSUPPORTED"
     */
    inline bool getAM_SUPPORTED_OR_AM_NOTSUPPORTED () const;

    /**
     * Sets the value of the member "DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED".
     *
     * If the meaning of "DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @param DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED The value which will be set
     */
    inline void setDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED (bool DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED);

    /**
     * Returns the value of the member "DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED".
     *
     * If the meaning of "DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED"
     */
    inline bool getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED () const;

    /**
     * Sets the value of the member "DABL_SUPPORTED_OR_DABL_NOTSUPPORTED".
     *
     * If the meaning of "DABL_SUPPORTED_OR_DABL_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @param DABL_SUPPORTED_OR_DABL_NOTSUPPORTED The value which will be set
     */
    inline void setDABL_SUPPORTED_OR_DABL_NOTSUPPORTED (bool DABL_SUPPORTED_OR_DABL_NOTSUPPORTED);

    /**
     * Returns the value of the member "DABL_SUPPORTED_OR_DABL_NOTSUPPORTED".
     *
     * If the meaning of "DABL_SUPPORTED_OR_DABL_NOTSUPPORTED" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DABL_SUPPORTED_OR_DABL_NOTSUPPORTED"
     */
    inline bool getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED () const;

    static const T_b8_Tun_Tunerbandbits &getDefaultInstance();

private:

    bool _DDAMASTER_OR_NOT_A_DDAMASTER:1;

    bool _DDASLAVE_OR_NOT_A_DDASLAVE:1;

    bool _FM_SUPPORTED_OR_FM_NOTSUPPORTED:1;

    bool _AM_SUPPORTED_OR_AM_NOTSUPPORTED:1;

    bool _DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED:1;

    bool _DABL_SUPPORTED_OR_DABL_NOTSUPPORTED:1;

};

/**
 * This structure describes a clusterid and the level of the cluster.
 */
class T_Audio_FG_BG {
public:

    /**
     * Default constructor
     */
    inline  T_Audio_FG_BG ();

    /**
     * Copy constructor
     */
    inline  T_Audio_FG_BG (const T_Audio_FG_BG &rhs);

    /**
     * All fields constructor
     */
    inline  T_Audio_FG_BG (T_e8_Tun_SubCommand u8SubCommand_, T_e8_Tun_AudioSink u8AudioSink_);

    /**
     * Destructor
     */
    inline  ~T_Audio_FG_BG();

    /**
     * Assignment operator
     */
    inline T_Audio_FG_BG& operator = (const T_Audio_FG_BG& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Audio_FG_BG& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Audio_FG_BG& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Audio_FG_BG& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Audio_FG_BG& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8SubCommand"

    static const int kU8SubCommand = 0;

    /**
     * Clears the field "u8SubCommand".
     *
     * The field will be set to its default value. The hasU8SubCommand()
     * method will return false.
     */
    inline void clearU8SubCommand();

    /**
     * Checks whether the field "u8SubCommand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SubCommand()). Otherwise it will return false.
     */
    inline bool hasU8SubCommand () const;

    /**
     * Returns the value of the member "u8SubCommand".
     *
     * This element describes the id of the file of the cluster.
     *
     * @return The value of the field "u8SubCommand"
     */
    inline T_e8_Tun_SubCommand getU8SubCommand () const;

    /**
     * Sets the value of the member "u8SubCommand".
     *
     * This element describes the id of the file of the cluster.
     *
     * @param u8SubCommand The value which will be set
     */
    inline void setU8SubCommand (T_e8_Tun_SubCommand u8SubCommand_);

    // API of field "u8AudioSink"

    static const int kU8AudioSink = 1;

    /**
     * Clears the field "u8AudioSink".
     *
     * The field will be set to its default value. The hasU8AudioSink()
     * method will return false.
     */
    inline void clearU8AudioSink();

    /**
     * Checks whether the field "u8AudioSink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioSink()). Otherwise it will return false.
     */
    inline bool hasU8AudioSink () const;

    /**
     * Returns the value of the member "u8AudioSink".
     *
     * This element describes the level of the cluster.
     *
     * @return The value of the field "u8AudioSink"
     */
    inline T_e8_Tun_AudioSink getU8AudioSink () const;

    /**
     * Sets the value of the member "u8AudioSink".
     *
     * This element describes the level of the cluster.
     *
     * @param u8AudioSink The value which will be set
     */
    inline void setU8AudioSink (T_e8_Tun_AudioSink u8AudioSink_);

    static const T_Audio_FG_BG &getDefaultInstance();

private:

    inline void set_has_u8SubCommand ();

    inline void clear_has_u8SubCommand ();

    inline void set_has_u8AudioSink ();

    inline void clear_has_u8AudioSink ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_SubCommand _u8SubCommand;

    T_e8_Tun_AudioSink _u8AudioSink;

};

/**
 * Gives the current tuners calibartion values
 */
class T_u16CalibrationData {
public:

    /**
     * Default constructor
     */
    inline  T_u16CalibrationData ();

    /**
     * Copy constructor
     */
    inline  T_u16CalibrationData (const T_u16CalibrationData &rhs);

    /**
     * All fields constructor
     */
    inline  T_u16CalibrationData (uint8 u8DataLength_, const ::std::vector< uint16 >& CalibrationValues_);

    /**
     * Destructor
     */
    inline  ~T_u16CalibrationData();

    /**
     * Assignment operator
     */
    inline T_u16CalibrationData& operator = (const T_u16CalibrationData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_u16CalibrationData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_u16CalibrationData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_u16CalibrationData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_u16CalibrationData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8DataLength"

    static const int kU8DataLength = 0;

    /**
     * Clears the field "u8DataLength".
     *
     * The field will be set to its default value. The hasU8DataLength()
     * method will return false.
     */
    inline void clearU8DataLength();

    /**
     * Checks whether the field "u8DataLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DataLength()). Otherwise it will return false.
     */
    inline bool hasU8DataLength () const;

    /**
     * Returns the value of the member "u8DataLength".
     *
     * This gives the length of calibration data. This field is invalid. Will be removed.
     * Please consider size of CalibrationValues list to get the length(each list element it 2 byte).
     *
     * @return The value of the field "u8DataLength"
     */
    inline uint8 getU8DataLength () const;

    /**
     * Sets the value of the member "u8DataLength".
     *
     * This gives the length of calibration data. This field is invalid. Will be removed.
     * Please consider size of CalibrationValues list to get the length(each list element it 2 byte).
     *
     * @param u8DataLength The value which will be set
     */
    inline void setU8DataLength (uint8 u8DataLength_);

    // API of field "CalibrationValues"

    static const int kCalibrationValues = 1;

    /**
     * Clears the field "CalibrationValues".
     *
     * The field will be set to its default value. The hasCalibrationValues()
     * method will return false.
     */
    inline void clearCalibrationValues();

    /**
     * Checks whether the field "CalibrationValues" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalibrationValues()). Otherwise it will return false.
     */
    inline bool hasCalibrationValues () const;

    /**
     * Returns the value of the member "CalibrationValues".
     *
     * List of calibration values. first 4 are for FM front ends. 5th one is for AM
     *
     * @return The value of the field "CalibrationValues"
     */
    inline const ::std::vector< uint16 >& getCalibrationValues () const;

    /**
     * Retrieves the value of the field "CalibrationValues" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CalibrationValues".
     */
    inline ::std::vector< uint16 >& getCalibrationValuesMutable ();

    /**
     * Sets the value of the member "CalibrationValues".
     *
     * List of calibration values. first 4 are for FM front ends. 5th one is for AM
     *
     * @param CalibrationValues The value which will be set
     */
    inline void setCalibrationValues (const ::std::vector< uint16 >& CalibrationValues_);

    /**
     * Release the object stored in the field "CalibrationValues".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "CalibrationValues"
     */
    inline ::std::vector< uint16 >* releaseCalibrationValues();

    /**
     * Replace the field "CalibrationValues".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCalibrationValues (::std::vector< uint16 >* CalibrationValues_);

    static const T_u16CalibrationData &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_u8DataLength ();

    inline void clear_has_u8DataLength ();

    inline void set_has_CalibrationValues ();

    inline void clear_has_CalibrationValues ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8DataLength;

    ::std::vector< uint16 >* _CalibrationValues;

};

/**
 * This structure describes a clusterid and the level of the cluster.
 */
class T_Aud_FGBG_New {
public:

    /**
     * Default constructor
     */
    inline  T_Aud_FGBG_New ();

    /**
     * Copy constructor
     */
    inline  T_Aud_FGBG_New (const T_Aud_FGBG_New &rhs);

    /**
     * All fields constructor
     */
    inline  T_Aud_FGBG_New (T_e8_Tun_TunerHeader u8_TunerHeader_, T_e8_Tun_SubCommand u8SubCommand_, T_e8_Tun_AudioSink u8AudioSink_, bool bTunerState_, T_e8_Tun_PhysicalTuner u8_PhysicalTuner_, T_e8_Tun_TunerBand e8Band_, T_e8_Tun_MTCAudioSource e8MTCAudioSource_);

    /**
     * Destructor
     */
    inline  ~T_Aud_FGBG_New();

    /**
     * Assignment operator
     */
    inline T_Aud_FGBG_New& operator = (const T_Aud_FGBG_New& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Aud_FGBG_New& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Aud_FGBG_New& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Aud_FGBG_New& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Aud_FGBG_New& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8_TunerHeader"

    static const int kU8_TunerHeader = 0;

    /**
     * Clears the field "u8_TunerHeader".
     *
     * The field will be set to its default value. The hasU8_TunerHeader()
     * method will return false.
     */
    inline void clearU8_TunerHeader();

    /**
     * Checks whether the field "u8_TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8_TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8_TunerHeader () const;

    /**
     * Returns the value of the member "u8_TunerHeader".
     *
     * This element describes the id of the Tuner to be put into
     * foreground or Background.
     *
     * @return The value of the field "u8_TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8_TunerHeader () const;

    /**
     * Sets the value of the member "u8_TunerHeader".
     *
     * This element describes the id of the Tuner to be put into
     * foreground or Background.
     *
     * @param u8_TunerHeader The value which will be set
     */
    inline void setU8_TunerHeader (T_e8_Tun_TunerHeader u8_TunerHeader_);

    // API of field "u8SubCommand"

    static const int kU8SubCommand = 1;

    /**
     * Clears the field "u8SubCommand".
     *
     * The field will be set to its default value. The hasU8SubCommand()
     * method will return false.
     */
    inline void clearU8SubCommand();

    /**
     * Checks whether the field "u8SubCommand" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SubCommand()). Otherwise it will return false.
     */
    inline bool hasU8SubCommand () const;

    /**
     * Returns the value of the member "u8SubCommand".
     *
     * This element describes the FG BG command.
     *
     * @return The value of the field "u8SubCommand"
     */
    inline T_e8_Tun_SubCommand getU8SubCommand () const;

    /**
     * Sets the value of the member "u8SubCommand".
     *
     * This element describes the FG BG command.
     *
     * @param u8SubCommand The value which will be set
     */
    inline void setU8SubCommand (T_e8_Tun_SubCommand u8SubCommand_);

    // API of field "u8AudioSink"

    static const int kU8AudioSink = 2;

    /**
     * Clears the field "u8AudioSink".
     *
     * The field will be set to its default value. The hasU8AudioSink()
     * method will return false.
     */
    inline void clearU8AudioSink();

    /**
     * Checks whether the field "u8AudioSink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioSink()). Otherwise it will return false.
     */
    inline bool hasU8AudioSink () const;

    /**
     * Returns the value of the member "u8AudioSink".
     *
     * This element describes the which user is to be put into FG BG.
     *
     * @return The value of the field "u8AudioSink"
     */
    inline T_e8_Tun_AudioSink getU8AudioSink () const;

    /**
     * Sets the value of the member "u8AudioSink".
     *
     * This element describes the which user is to be put into FG BG.
     *
     * @param u8AudioSink The value which will be set
     */
    inline void setU8AudioSink (T_e8_Tun_AudioSink u8AudioSink_);

    // API of field "bTunerState"

    static const int kBTunerState = 3;

    /**
     * Clears the field "bTunerState".
     *
     * The field will be set to its default value. The hasBTunerState()
     * method will return false.
     */
    inline void clearBTunerState();

    /**
     * Checks whether the field "bTunerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTunerState()). Otherwise it will return false.
     */
    inline bool hasBTunerState () const;

    /**
     * Returns the value of the member "bTunerState".
     *
     * Gives the FG/BG status of Tuner1. 00= FG, 01= BG
     *
     * @return The value of the field "bTunerState"
     */
    inline bool getBTunerState () const;

    /**
     * Sets the value of the member "bTunerState".
     *
     * Gives the FG/BG status of Tuner1. 00= FG, 01= BG
     *
     * @param bTunerState The value which will be set
     */
    inline void setBTunerState (bool bTunerState_);

    // API of field "u8_PhysicalTuner"

    static const int kU8_PhysicalTuner = 4;

    /**
     * Clears the field "u8_PhysicalTuner".
     *
     * The field will be set to its default value. The hasU8_PhysicalTuner()
     * method will return false.
     */
    inline void clearU8_PhysicalTuner();

    /**
     * Checks whether the field "u8_PhysicalTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8_PhysicalTuner()). Otherwise it will return false.
     */
    inline bool hasU8_PhysicalTuner () const;

    /**
     * Returns the value of the member "u8_PhysicalTuner".
     *
     * This element describes which physical tuner is to be used.
     *
     * @return The value of the field "u8_PhysicalTuner"
     */
    inline T_e8_Tun_PhysicalTuner getU8_PhysicalTuner () const;

    /**
     * Sets the value of the member "u8_PhysicalTuner".
     *
     * This element describes which physical tuner is to be used.
     *
     * @param u8_PhysicalTuner The value which will be set
     */
    inline void setU8_PhysicalTuner (T_e8_Tun_PhysicalTuner u8_PhysicalTuner_);

    // API of field "e8Band"

    static const int kE8Band = 5;

    /**
     * Clears the field "e8Band".
     *
     * The field will be set to its default value. The hasE8Band()
     * method will return false.
     */
    inline void clearE8Band();

    /**
     * Checks whether the field "e8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Band()). Otherwise it will return false.
     */
    inline bool hasE8Band () const;

    /**
     * Returns the value of the member "e8Band".
     *
     *
     *
     * @return The value of the field "e8Band"
     */
    inline T_e8_Tun_TunerBand getE8Band () const;

    /**
     * Sets the value of the member "e8Band".
     *
     *
     *
     * @param e8Band The value which will be set
     */
    inline void setE8Band (T_e8_Tun_TunerBand e8Band_);

    // API of field "e8MTCAudioSource"

    static const int kE8MTCAudioSource = 6;

    /**
     * Clears the field "e8MTCAudioSource".
     *
     * The field will be set to its default value. The hasE8MTCAudioSource()
     * method will return false.
     */
    inline void clearE8MTCAudioSource();

    /**
     * Checks whether the field "e8MTCAudioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MTCAudioSource()). Otherwise it will return false.
     */
    inline bool hasE8MTCAudioSource () const;

    /**
     * Returns the value of the member "e8MTCAudioSource".
     *
     * This element describes MTC sources to be put to foreground. This parameter used only Gen4 onwards with SBR.
     *
     * @return The value of the field "e8MTCAudioSource"
     */
    inline T_e8_Tun_MTCAudioSource getE8MTCAudioSource () const;

    /**
     * Sets the value of the member "e8MTCAudioSource".
     *
     * This element describes MTC sources to be put to foreground. This parameter used only Gen4 onwards with SBR.
     *
     * @param e8MTCAudioSource The value which will be set
     */
    inline void setE8MTCAudioSource (T_e8_Tun_MTCAudioSource e8MTCAudioSource_);

    static const T_Aud_FGBG_New &getDefaultInstance();

private:

    inline void set_has_u8_TunerHeader ();

    inline void clear_has_u8_TunerHeader ();

    inline void set_has_u8SubCommand ();

    inline void clear_has_u8SubCommand ();

    inline void set_has_u8AudioSink ();

    inline void clear_has_u8AudioSink ();

    inline void set_has_bTunerState ();

    inline void clear_has_bTunerState ();

    inline void set_has_u8_PhysicalTuner ();

    inline void clear_has_u8_PhysicalTuner ();

    inline void set_has_e8Band ();

    inline void clear_has_e8Band ();

    inline void set_has_e8MTCAudioSource ();

    inline void clear_has_e8MTCAudioSource ();

    uint32 _has_bits_[ (7 + 31) / 32];

    T_e8_Tun_TunerHeader _u8_TunerHeader;

    T_e8_Tun_SubCommand _u8SubCommand;

    T_e8_Tun_AudioSink _u8AudioSink;

    bool _bTunerState;

    T_e8_Tun_PhysicalTuner _u8_PhysicalTuner;

    T_e8_Tun_TunerBand _e8Band;

    T_e8_Tun_MTCAudioSource _e8MTCAudioSource;

};

/**
 * This structure describes a clusterid and the level of the cluster.
 */
class T_AudFGBGStatus {
public:

    /**
     * Default constructor
     */
    inline  T_AudFGBGStatus ();

    /**
     * Copy constructor
     */
    inline  T_AudFGBGStatus (const T_AudFGBGStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_AudFGBGStatus (T_e8_Tun_TunerHeader u8_TunerHeader_, const T_b8_Tun_AudioSink& u8AudioSink_, T_e8_Tun_MTCAudioSource e8MTCAudioSource_);

    /**
     * Destructor
     */
    inline  ~T_AudFGBGStatus();

    /**
     * Assignment operator
     */
    inline T_AudFGBGStatus& operator = (const T_AudFGBGStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AudFGBGStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AudFGBGStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AudFGBGStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AudFGBGStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8_TunerHeader"

    static const int kU8_TunerHeader = 0;

    /**
     * Clears the field "u8_TunerHeader".
     *
     * The field will be set to its default value. The hasU8_TunerHeader()
     * method will return false.
     */
    inline void clearU8_TunerHeader();

    /**
     * Checks whether the field "u8_TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8_TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8_TunerHeader () const;

    /**
     * Returns the value of the member "u8_TunerHeader".
     *
     * This element describes the id of the Tuner to be put into
     * foreground or Background.
     *
     * @return The value of the field "u8_TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8_TunerHeader () const;

    /**
     * Sets the value of the member "u8_TunerHeader".
     *
     * This element describes the id of the Tuner to be put into
     * foreground or Background.
     *
     * @param u8_TunerHeader The value which will be set
     */
    inline void setU8_TunerHeader (T_e8_Tun_TunerHeader u8_TunerHeader_);

    // API of field "u8AudioSink"

    static const int kU8AudioSink = 1;

    /**
     * Clears the field "u8AudioSink".
     *
     * The field will be set to its default value. The hasU8AudioSink()
     * method will return false.
     */
    inline void clearU8AudioSink();

    /**
     * Checks whether the field "u8AudioSink" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioSink()). Otherwise it will return false.
     */
    inline bool hasU8AudioSink () const;

    /**
     * Returns the value of the member "u8AudioSink".
     *
     * This element describes the level of the cluster.
     *
     * @return The value of the field "u8AudioSink"
     */
    inline const T_b8_Tun_AudioSink& getU8AudioSink () const;

    /**
     * Retrieves the value of the field "u8AudioSink" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u8AudioSink".
     */
    inline T_b8_Tun_AudioSink& getU8AudioSinkMutable ();

    /**
     * Sets the value of the member "u8AudioSink".
     *
     * This element describes the level of the cluster.
     *
     * @param u8AudioSink The value which will be set
     */
    inline void setU8AudioSink (const T_b8_Tun_AudioSink& u8AudioSink_);

    /**
     * Release the object stored in the field "u8AudioSink".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u8AudioSink"
     */
    inline T_b8_Tun_AudioSink* releaseU8AudioSink();

    /**
     * Replace the field "u8AudioSink".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU8AudioSink (T_b8_Tun_AudioSink* u8AudioSink_);

    // API of field "e8MTCAudioSource"

    static const int kE8MTCAudioSource = 2;

    /**
     * Clears the field "e8MTCAudioSource".
     *
     * The field will be set to its default value. The hasE8MTCAudioSource()
     * method will return false.
     */
    inline void clearE8MTCAudioSource();

    /**
     * Checks whether the field "e8MTCAudioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MTCAudioSource()). Otherwise it will return false.
     */
    inline bool hasE8MTCAudioSource () const;

    /**
     * Returns the value of the member "e8MTCAudioSource".
     *
     * This element describes MTC sources put to foreground. This parameter used only Gen4 onwards with SBR.
     *
     * @return The value of the field "e8MTCAudioSource"
     */
    inline T_e8_Tun_MTCAudioSource getE8MTCAudioSource () const;

    /**
     * Sets the value of the member "e8MTCAudioSource".
     *
     * This element describes MTC sources put to foreground. This parameter used only Gen4 onwards with SBR.
     *
     * @param e8MTCAudioSource The value which will be set
     */
    inline void setE8MTCAudioSource (T_e8_Tun_MTCAudioSource e8MTCAudioSource_);

    static const T_AudFGBGStatus &getDefaultInstance();

private:

    inline void set_has_u8_TunerHeader ();

    inline void clear_has_u8_TunerHeader ();

    inline void set_has_u8AudioSink ();

    inline void clear_has_u8AudioSink ();

    inline void set_has_e8MTCAudioSource ();

    inline void clear_has_e8MTCAudioSource ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_Tun_TunerHeader _u8_TunerHeader;

    T_b8_Tun_AudioSink* _u8AudioSink;

    T_e8_Tun_MTCAudioSource _e8MTCAudioSource;

};

/**
 * Tuner Server sends status back to the client.
 */
class T_TunerServer_StatusResponse {
public:

    /**
     * Default constructor
     */
    inline  T_TunerServer_StatusResponse ();

    /**
     * Copy constructor
     */
    inline  T_TunerServer_StatusResponse (const T_TunerServer_StatusResponse &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerServer_StatusResponse (T_e8_Tun_ResponseStatus u8TunerStatus_, T_e8_Tun_ResponseState u8TunerState_);

    /**
     * Destructor
     */
    inline  ~T_TunerServer_StatusResponse();

    /**
     * Assignment operator
     */
    inline T_TunerServer_StatusResponse& operator = (const T_TunerServer_StatusResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerServer_StatusResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerServer_StatusResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerServer_StatusResponse& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerServer_StatusResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerStatus"

    static const int kU8TunerStatus = 0;

    /**
     * Clears the field "u8TunerStatus".
     *
     * The field will be set to its default value. The hasU8TunerStatus()
     * method will return false.
     */
    inline void clearU8TunerStatus();

    /**
     * Checks whether the field "u8TunerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerStatus()). Otherwise it will return false.
     */
    inline bool hasU8TunerStatus () const;

    /**
     * Returns the value of the member "u8TunerStatus".
     *
     * Indictaes the status of the client request.
     *
     * @return The value of the field "u8TunerStatus"
     */
    inline T_e8_Tun_ResponseStatus getU8TunerStatus () const;

    /**
     * Sets the value of the member "u8TunerStatus".
     *
     * Indictaes the status of the client request.
     *
     * @param u8TunerStatus The value which will be set
     */
    inline void setU8TunerStatus (T_e8_Tun_ResponseStatus u8TunerStatus_);

    // API of field "u8TunerState"

    static const int kU8TunerState = 1;

    /**
     * Clears the field "u8TunerState".
     *
     * The field will be set to its default value. The hasU8TunerState()
     * method will return false.
     */
    inline void clearU8TunerState();

    /**
     * Checks whether the field "u8TunerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerState()). Otherwise it will return false.
     */
    inline bool hasU8TunerState () const;

    /**
     * Returns the value of the member "u8TunerState".
     *
     * Indicates the current Tuner server status.
     *
     * @return The value of the field "u8TunerState"
     */
    inline T_e8_Tun_ResponseState getU8TunerState () const;

    /**
     * Sets the value of the member "u8TunerState".
     *
     * Indicates the current Tuner server status.
     *
     * @param u8TunerState The value which will be set
     */
    inline void setU8TunerState (T_e8_Tun_ResponseState u8TunerState_);

    static const T_TunerServer_StatusResponse &getDefaultInstance();

private:

    inline void set_has_u8TunerStatus ();

    inline void clear_has_u8TunerStatus ();

    inline void set_has_u8TunerState ();

    inline void clear_has_u8TunerState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_ResponseStatus _u8TunerStatus;

    T_e8_Tun_ResponseState _u8TunerState;

};

/**
 * Tuner Avail Flags .
 */
class T_b32_Tun_AvailFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b32_Tun_AvailFlags ();

    /**
     * Copy constructor
     */
    inline  T_b32_Tun_AvailFlags (const T_b32_Tun_AvailFlags &c);

    /**
     * Field constructor
     */
    inline  T_b32_Tun_AvailFlags (bool TUN_FRQ_AVAILABLE, bool TUN_PS_AVAILABLE, bool TUN_PI_AVAILABLE, bool TUN_PTY_AVAILABLE, bool TUN_CT_AVAILABLE, bool TUN_TMC_AVAILABLE, bool TUN_RDS_AVAILABLE, bool TUN_REG_AVAILABLE, bool TUN_AF_AVAILABLE, bool TUN_PTY_EON_AVAILABLE, bool TUN_RT_AVAILABLE, bool TUN_JAPAN_PS_AVAILABLE, bool TUN_AUTO_COMPARE_AVAILABLE);

    /**
     * Assignment operator
     */
    inline T_b32_Tun_AvailFlags& operator = (const T_b32_Tun_AvailFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_Tun_AvailFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_Tun_AvailFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_Tun_AvailFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_Tun_AvailFlags& rhs) const;

    /**
     * Sets the value of the member "TUN_FRQ_AVAILABLE".
     *
     * If the meaning of "TUN_FRQ_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_FRQ_AVAILABLE The value which will be set
     */
    inline void setTUN_FRQ_AVAILABLE (bool TUN_FRQ_AVAILABLE);

    /**
     * Returns the value of the member "TUN_FRQ_AVAILABLE".
     *
     * If the meaning of "TUN_FRQ_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FRQ_AVAILABLE"
     */
    inline bool getTUN_FRQ_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_PS_AVAILABLE".
     *
     * If the meaning of "TUN_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_PS_AVAILABLE The value which will be set
     */
    inline void setTUN_PS_AVAILABLE (bool TUN_PS_AVAILABLE);

    /**
     * Returns the value of the member "TUN_PS_AVAILABLE".
     *
     * If the meaning of "TUN_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_PS_AVAILABLE"
     */
    inline bool getTUN_PS_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_PI_AVAILABLE".
     *
     * If the meaning of "TUN_PI_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_PI_AVAILABLE The value which will be set
     */
    inline void setTUN_PI_AVAILABLE (bool TUN_PI_AVAILABLE);

    /**
     * Returns the value of the member "TUN_PI_AVAILABLE".
     *
     * If the meaning of "TUN_PI_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_PI_AVAILABLE"
     */
    inline bool getTUN_PI_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_PTY_AVAILABLE".
     *
     * If the meaning of "TUN_PTY_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_PTY_AVAILABLE The value which will be set
     */
    inline void setTUN_PTY_AVAILABLE (bool TUN_PTY_AVAILABLE);

    /**
     * Returns the value of the member "TUN_PTY_AVAILABLE".
     *
     * If the meaning of "TUN_PTY_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_PTY_AVAILABLE"
     */
    inline bool getTUN_PTY_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_CT_AVAILABLE".
     *
     * If the meaning of "TUN_CT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_CT_AVAILABLE The value which will be set
     */
    inline void setTUN_CT_AVAILABLE (bool TUN_CT_AVAILABLE);

    /**
     * Returns the value of the member "TUN_CT_AVAILABLE".
     *
     * If the meaning of "TUN_CT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_CT_AVAILABLE"
     */
    inline bool getTUN_CT_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_TMC_AVAILABLE".
     *
     * If the meaning of "TUN_TMC_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_TMC_AVAILABLE The value which will be set
     */
    inline void setTUN_TMC_AVAILABLE (bool TUN_TMC_AVAILABLE);

    /**
     * Returns the value of the member "TUN_TMC_AVAILABLE".
     *
     * If the meaning of "TUN_TMC_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TMC_AVAILABLE"
     */
    inline bool getTUN_TMC_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_RDS_AVAILABLE".
     *
     * If the meaning of "TUN_RDS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_RDS_AVAILABLE The value which will be set
     */
    inline void setTUN_RDS_AVAILABLE (bool TUN_RDS_AVAILABLE);

    /**
     * Returns the value of the member "TUN_RDS_AVAILABLE".
     *
     * If the meaning of "TUN_RDS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_RDS_AVAILABLE"
     */
    inline bool getTUN_RDS_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_REG_AVAILABLE".
     *
     * If the meaning of "TUN_REG_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_REG_AVAILABLE The value which will be set
     */
    inline void setTUN_REG_AVAILABLE (bool TUN_REG_AVAILABLE);

    /**
     * Returns the value of the member "TUN_REG_AVAILABLE".
     *
     * If the meaning of "TUN_REG_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_REG_AVAILABLE"
     */
    inline bool getTUN_REG_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AF_AVAILABLE".
     *
     * If the meaning of "TUN_AF_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AF_AVAILABLE The value which will be set
     */
    inline void setTUN_AF_AVAILABLE (bool TUN_AF_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AF_AVAILABLE".
     *
     * If the meaning of "TUN_AF_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AF_AVAILABLE"
     */
    inline bool getTUN_AF_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_PTY_EON_AVAILABLE".
     *
     * If the meaning of "TUN_PTY_EON_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_PTY_EON_AVAILABLE The value which will be set
     */
    inline void setTUN_PTY_EON_AVAILABLE (bool TUN_PTY_EON_AVAILABLE);

    /**
     * Returns the value of the member "TUN_PTY_EON_AVAILABLE".
     *
     * If the meaning of "TUN_PTY_EON_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_PTY_EON_AVAILABLE"
     */
    inline bool getTUN_PTY_EON_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_RT_AVAILABLE".
     *
     * If the meaning of "TUN_RT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_RT_AVAILABLE The value which will be set
     */
    inline void setTUN_RT_AVAILABLE (bool TUN_RT_AVAILABLE);

    /**
     * Returns the value of the member "TUN_RT_AVAILABLE".
     *
     * If the meaning of "TUN_RT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_RT_AVAILABLE"
     */
    inline bool getTUN_RT_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_JAPAN_PS_AVAILABLE".
     *
     * If the meaning of "TUN_JAPAN_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_JAPAN_PS_AVAILABLE The value which will be set
     */
    inline void setTUN_JAPAN_PS_AVAILABLE (bool TUN_JAPAN_PS_AVAILABLE);

    /**
     * Returns the value of the member "TUN_JAPAN_PS_AVAILABLE".
     *
     * If the meaning of "TUN_JAPAN_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_JAPAN_PS_AVAILABLE"
     */
    inline bool getTUN_JAPAN_PS_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AUTO_COMPARE_AVAILABLE".
     *
     * If the meaning of "TUN_AUTO_COMPARE_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AUTO_COMPARE_AVAILABLE The value which will be set
     */
    inline void setTUN_AUTO_COMPARE_AVAILABLE (bool TUN_AUTO_COMPARE_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AUTO_COMPARE_AVAILABLE".
     *
     * If the meaning of "TUN_AUTO_COMPARE_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AUTO_COMPARE_AVAILABLE"
     */
    inline bool getTUN_AUTO_COMPARE_AVAILABLE () const;

    static const T_b32_Tun_AvailFlags &getDefaultInstance();

private:

    bool _TUN_FRQ_AVAILABLE:1;

    bool _TUN_PS_AVAILABLE:1;

    bool _TUN_PI_AVAILABLE:1;

    bool _TUN_PTY_AVAILABLE:1;

    bool _TUN_CT_AVAILABLE:1;

    bool _TUN_TMC_AVAILABLE:1;

    bool _TUN_RDS_AVAILABLE:1;

    bool _TUN_REG_AVAILABLE:1;

    bool _TUN_AF_AVAILABLE:1;

    bool _TUN_PTY_EON_AVAILABLE:1;

    bool _TUN_RT_AVAILABLE:1;

    bool _TUN_JAPAN_PS_AVAILABLE:1;

    bool _TUN_AUTO_COMPARE_AVAILABLE:1;

};

/**
 * Tuner features. The bits TUN_FEATURE_TA_MODE and TUN_FEATURE_PTY_MODE  removed .
 * Use FID_TUN_S_ANNOUNCEMENT_SWITCH instead.
 */
class T_b32_Tun_Features {
public:

    /**
     * Default constructor
     */
    inline  T_b32_Tun_Features ();

    /**
     * Copy constructor
     */
    inline  T_b32_Tun_Features (const T_b32_Tun_Features &c);

    /**
     * Field constructor
     */
    inline  T_b32_Tun_Features (bool TUN_FEATURE_AF_MODE, bool TUN_FEATURE_CT_MODE, bool TUN_FEATURE_LOC_MODE, bool TUN_FEATURE_unused, bool TUN_FEATURE_MONO_MODE, bool TUN_FEATURE_PSFIX_MODE, bool TUN_FEATURE_REG_MODE, bool TUN_FEATURE_RT_MODE, bool TUN_FEATURE_SEARCH_MODE, bool TUN_FEATURE_SEEK_SENSE_MODE, bool TUN_FEATURE_SHARX_MODE, bool TUN_FEATURE_TM_DATA_MODE, bool TUN_FEATURE_TMC_MODE, bool TUN_FEATURE_KHZ50_MODE, bool TUN_FEATURE_REG_AUTO_MODE, bool TUN_FEATURE_NEWS_MODE, bool TUN_FEATURE_RDS_AUTO_MODE, bool TUN_FEATURE_DDA_MODE, bool TUN_FEATURE_DDS_MODE, bool TUN_FEATURE_reserved, bool TUN_FEATURE_MEASURE_MODE, bool TUN_FEATURE_AMFMSETUP_MODE, bool TUN_FEATURE_PERSISTENTSTORAGE_MODE);

    /**
     * Assignment operator
     */
    inline T_b32_Tun_Features& operator = (const T_b32_Tun_Features& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_Tun_Features& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_Tun_Features& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_Tun_Features& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_Tun_Features& rhs) const;

    /**
     * Sets the value of the member "TUN_FEATURE_AF_MODE".
     *
     * If the meaning of "TUN_FEATURE_AF_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_AF_MODE The value which will be set
     */
    inline void setTUN_FEATURE_AF_MODE (bool TUN_FEATURE_AF_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_AF_MODE".
     *
     * If the meaning of "TUN_FEATURE_AF_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_AF_MODE"
     */
    inline bool getTUN_FEATURE_AF_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_CT_MODE".
     *
     * If the meaning of "TUN_FEATURE_CT_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_CT_MODE The value which will be set
     */
    inline void setTUN_FEATURE_CT_MODE (bool TUN_FEATURE_CT_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_CT_MODE".
     *
     * If the meaning of "TUN_FEATURE_CT_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_CT_MODE"
     */
    inline bool getTUN_FEATURE_CT_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_LOC_MODE".
     *
     * If the meaning of "TUN_FEATURE_LOC_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_LOC_MODE The value which will be set
     */
    inline void setTUN_FEATURE_LOC_MODE (bool TUN_FEATURE_LOC_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_LOC_MODE".
     *
     * If the meaning of "TUN_FEATURE_LOC_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_LOC_MODE"
     */
    inline bool getTUN_FEATURE_LOC_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_unused".
     *
     * If the meaning of "TUN_FEATURE_unused" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_unused The value which will be set
     */
    inline void setTUN_FEATURE_unused (bool TUN_FEATURE_unused);

    /**
     * Returns the value of the member "TUN_FEATURE_unused".
     *
     * If the meaning of "TUN_FEATURE_unused" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_unused"
     */
    inline bool getTUN_FEATURE_unused () const;

    /**
     * Sets the value of the member "TUN_FEATURE_MONO_MODE".
     *
     * If the meaning of "TUN_FEATURE_MONO_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_MONO_MODE The value which will be set
     */
    inline void setTUN_FEATURE_MONO_MODE (bool TUN_FEATURE_MONO_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_MONO_MODE".
     *
     * If the meaning of "TUN_FEATURE_MONO_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_MONO_MODE"
     */
    inline bool getTUN_FEATURE_MONO_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_PSFIX_MODE".
     *
     * If the meaning of "TUN_FEATURE_PSFIX_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_PSFIX_MODE The value which will be set
     */
    inline void setTUN_FEATURE_PSFIX_MODE (bool TUN_FEATURE_PSFIX_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_PSFIX_MODE".
     *
     * If the meaning of "TUN_FEATURE_PSFIX_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_PSFIX_MODE"
     */
    inline bool getTUN_FEATURE_PSFIX_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_REG_MODE".
     *
     * If the meaning of "TUN_FEATURE_REG_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_REG_MODE The value which will be set
     */
    inline void setTUN_FEATURE_REG_MODE (bool TUN_FEATURE_REG_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_REG_MODE".
     *
     * If the meaning of "TUN_FEATURE_REG_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_REG_MODE"
     */
    inline bool getTUN_FEATURE_REG_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_RT_MODE".
     *
     * If the meaning of "TUN_FEATURE_RT_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_RT_MODE The value which will be set
     */
    inline void setTUN_FEATURE_RT_MODE (bool TUN_FEATURE_RT_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_RT_MODE".
     *
     * If the meaning of "TUN_FEATURE_RT_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_RT_MODE"
     */
    inline bool getTUN_FEATURE_RT_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_SEARCH_MODE".
     *
     * If the meaning of "TUN_FEATURE_SEARCH_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_SEARCH_MODE The value which will be set
     */
    inline void setTUN_FEATURE_SEARCH_MODE (bool TUN_FEATURE_SEARCH_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_SEARCH_MODE".
     *
     * If the meaning of "TUN_FEATURE_SEARCH_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_SEARCH_MODE"
     */
    inline bool getTUN_FEATURE_SEARCH_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_SEEK_SENSE_MODE".
     *
     * If the meaning of "TUN_FEATURE_SEEK_SENSE_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_SEEK_SENSE_MODE The value which will be set
     */
    inline void setTUN_FEATURE_SEEK_SENSE_MODE (bool TUN_FEATURE_SEEK_SENSE_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_SEEK_SENSE_MODE".
     *
     * If the meaning of "TUN_FEATURE_SEEK_SENSE_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_SEEK_SENSE_MODE"
     */
    inline bool getTUN_FEATURE_SEEK_SENSE_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_SHARX_MODE".
     *
     * If the meaning of "TUN_FEATURE_SHARX_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_SHARX_MODE The value which will be set
     */
    inline void setTUN_FEATURE_SHARX_MODE (bool TUN_FEATURE_SHARX_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_SHARX_MODE".
     *
     * If the meaning of "TUN_FEATURE_SHARX_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_SHARX_MODE"
     */
    inline bool getTUN_FEATURE_SHARX_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_TM_DATA_MODE".
     *
     * If the meaning of "TUN_FEATURE_TM_DATA_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_TM_DATA_MODE The value which will be set
     */
    inline void setTUN_FEATURE_TM_DATA_MODE (bool TUN_FEATURE_TM_DATA_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_TM_DATA_MODE".
     *
     * If the meaning of "TUN_FEATURE_TM_DATA_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_TM_DATA_MODE"
     */
    inline bool getTUN_FEATURE_TM_DATA_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_TMC_MODE".
     *
     * If the meaning of "TUN_FEATURE_TMC_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_TMC_MODE The value which will be set
     */
    inline void setTUN_FEATURE_TMC_MODE (bool TUN_FEATURE_TMC_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_TMC_MODE".
     *
     * If the meaning of "TUN_FEATURE_TMC_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_TMC_MODE"
     */
    inline bool getTUN_FEATURE_TMC_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_KHZ50_MODE".
     *
     * If the meaning of "TUN_FEATURE_KHZ50_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_KHZ50_MODE The value which will be set
     */
    inline void setTUN_FEATURE_KHZ50_MODE (bool TUN_FEATURE_KHZ50_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_KHZ50_MODE".
     *
     * If the meaning of "TUN_FEATURE_KHZ50_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_KHZ50_MODE"
     */
    inline bool getTUN_FEATURE_KHZ50_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_REG_AUTO_MODE".
     *
     * If the meaning of "TUN_FEATURE_REG_AUTO_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_REG_AUTO_MODE The value which will be set
     */
    inline void setTUN_FEATURE_REG_AUTO_MODE (bool TUN_FEATURE_REG_AUTO_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_REG_AUTO_MODE".
     *
     * If the meaning of "TUN_FEATURE_REG_AUTO_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_REG_AUTO_MODE"
     */
    inline bool getTUN_FEATURE_REG_AUTO_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_NEWS_MODE".
     *
     * If the meaning of "TUN_FEATURE_NEWS_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_NEWS_MODE The value which will be set
     */
    inline void setTUN_FEATURE_NEWS_MODE (bool TUN_FEATURE_NEWS_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_NEWS_MODE".
     *
     * If the meaning of "TUN_FEATURE_NEWS_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_NEWS_MODE"
     */
    inline bool getTUN_FEATURE_NEWS_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_RDS_AUTO_MODE".
     *
     * If the meaning of "TUN_FEATURE_RDS_AUTO_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_RDS_AUTO_MODE The value which will be set
     */
    inline void setTUN_FEATURE_RDS_AUTO_MODE (bool TUN_FEATURE_RDS_AUTO_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_RDS_AUTO_MODE".
     *
     * If the meaning of "TUN_FEATURE_RDS_AUTO_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_RDS_AUTO_MODE"
     */
    inline bool getTUN_FEATURE_RDS_AUTO_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_DDA_MODE".
     *
     * If the meaning of "TUN_FEATURE_DDA_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_DDA_MODE The value which will be set
     */
    inline void setTUN_FEATURE_DDA_MODE (bool TUN_FEATURE_DDA_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_DDA_MODE".
     *
     * If the meaning of "TUN_FEATURE_DDA_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_DDA_MODE"
     */
    inline bool getTUN_FEATURE_DDA_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_DDS_MODE".
     *
     * If the meaning of "TUN_FEATURE_DDS_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_DDS_MODE The value which will be set
     */
    inline void setTUN_FEATURE_DDS_MODE (bool TUN_FEATURE_DDS_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_DDS_MODE".
     *
     * If the meaning of "TUN_FEATURE_DDS_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_DDS_MODE"
     */
    inline bool getTUN_FEATURE_DDS_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_reserved".
     *
     * If the meaning of "TUN_FEATURE_reserved" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_reserved The value which will be set
     */
    inline void setTUN_FEATURE_reserved (bool TUN_FEATURE_reserved);

    /**
     * Returns the value of the member "TUN_FEATURE_reserved".
     *
     * If the meaning of "TUN_FEATURE_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_reserved"
     */
    inline bool getTUN_FEATURE_reserved () const;

    /**
     * Sets the value of the member "TUN_FEATURE_MEASURE_MODE".
     *
     * If the meaning of "TUN_FEATURE_MEASURE_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_MEASURE_MODE The value which will be set
     */
    inline void setTUN_FEATURE_MEASURE_MODE (bool TUN_FEATURE_MEASURE_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_MEASURE_MODE".
     *
     * If the meaning of "TUN_FEATURE_MEASURE_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_MEASURE_MODE"
     */
    inline bool getTUN_FEATURE_MEASURE_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_AMFMSETUP_MODE".
     *
     * If the meaning of "TUN_FEATURE_AMFMSETUP_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_AMFMSETUP_MODE The value which will be set
     */
    inline void setTUN_FEATURE_AMFMSETUP_MODE (bool TUN_FEATURE_AMFMSETUP_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_AMFMSETUP_MODE".
     *
     * If the meaning of "TUN_FEATURE_AMFMSETUP_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_AMFMSETUP_MODE"
     */
    inline bool getTUN_FEATURE_AMFMSETUP_MODE () const;

    /**
     * Sets the value of the member "TUN_FEATURE_PERSISTENTSTORAGE_MODE".
     *
     * If the meaning of "TUN_FEATURE_PERSISTENTSTORAGE_MODE" isn't clear, then there should be a description here.
     *
     * @param TUN_FEATURE_PERSISTENTSTORAGE_MODE The value which will be set
     */
    inline void setTUN_FEATURE_PERSISTENTSTORAGE_MODE (bool TUN_FEATURE_PERSISTENTSTORAGE_MODE);

    /**
     * Returns the value of the member "TUN_FEATURE_PERSISTENTSTORAGE_MODE".
     *
     * If the meaning of "TUN_FEATURE_PERSISTENTSTORAGE_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_FEATURE_PERSISTENTSTORAGE_MODE"
     */
    inline bool getTUN_FEATURE_PERSISTENTSTORAGE_MODE () const;

    static const T_b32_Tun_Features &getDefaultInstance();

private:

    bool _TUN_FEATURE_AF_MODE:1;

    bool _TUN_FEATURE_CT_MODE:1;

    bool _TUN_FEATURE_LOC_MODE:1;

    bool _TUN_FEATURE_unused:1;

    bool _TUN_FEATURE_MONO_MODE:1;

    bool _TUN_FEATURE_PSFIX_MODE:1;

    bool _TUN_FEATURE_REG_MODE:1;

    bool _TUN_FEATURE_RT_MODE:1;

    bool _TUN_FEATURE_SEARCH_MODE:1;

    bool _TUN_FEATURE_SEEK_SENSE_MODE:1;

    bool _TUN_FEATURE_SHARX_MODE:1;

    bool _TUN_FEATURE_TM_DATA_MODE:1;

    bool _TUN_FEATURE_TMC_MODE:1;

    bool _TUN_FEATURE_KHZ50_MODE:1;

    bool _TUN_FEATURE_REG_AUTO_MODE:1;

    bool _TUN_FEATURE_NEWS_MODE:1;

    bool _TUN_FEATURE_RDS_AUTO_MODE:1;

    bool _TUN_FEATURE_DDA_MODE:1;

    bool _TUN_FEATURE_DDS_MODE:1;

    bool _TUN_FEATURE_reserved:1;

    bool _TUN_FEATURE_MEASURE_MODE:1;

    bool _TUN_FEATURE_AMFMSETUP_MODE:1;

    bool _TUN_FEATURE_PERSISTENTSTORAGE_MODE:1;

};

/**
 * Tuner Antennas.
 */
class T_b8_Tun_Antenna {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_Antenna ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_Antenna (const T_b8_Tun_Antenna &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_Antenna (bool TUNER_ANTENNA1, bool TUNER_ANTENNA2);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_Antenna& operator = (const T_b8_Tun_Antenna& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_Antenna& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_Antenna& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_Antenna& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_Antenna& rhs) const;

    /**
     * Sets the value of the member "TUNER_ANTENNA1".
     *
     * If the meaning of "TUNER_ANTENNA1" isn't clear, then there should be a description here.
     *
     * @param TUNER_ANTENNA1 The value which will be set
     */
    inline void setTUNER_ANTENNA1 (bool TUNER_ANTENNA1);

    /**
     * Returns the value of the member "TUNER_ANTENNA1".
     *
     * If the meaning of "TUNER_ANTENNA1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNER_ANTENNA1"
     */
    inline bool getTUNER_ANTENNA1 () const;

    /**
     * Sets the value of the member "TUNER_ANTENNA2".
     *
     * If the meaning of "TUNER_ANTENNA2" isn't clear, then there should be a description here.
     *
     * @param TUNER_ANTENNA2 The value which will be set
     */
    inline void setTUNER_ANTENNA2 (bool TUNER_ANTENNA2);

    /**
     * Returns the value of the member "TUNER_ANTENNA2".
     *
     * If the meaning of "TUNER_ANTENNA2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUNER_ANTENNA2"
     */
    inline bool getTUNER_ANTENNA2 () const;

    static const T_b8_Tun_Antenna &getDefaultInstance();

private:

    bool _TUNER_ANTENNA1:1;

    bool _TUNER_ANTENNA2:1;

};

/**
 * Tuner station data is contained in this structure .
 */
class T_TunerStationData {
public:

    /**
     * Default constructor
     */
    inline  T_TunerStationData ();

    /**
     * Copy constructor
     */
    inline  T_TunerStationData (const T_TunerStationData &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerStationData (T_e8_Tun_TunerHeader u8TunerHeader_, uint8 u8PTY_, uint16 u16PackedInfo_, const T_b32_Tun_AvailFlags& u32AvailFlags_, uint32 u32Frequency_, uint32 u32PI_, uint8 u8PSName1_, uint8 u8PSName2_, uint8 u8PSName3_, uint8 u8PSName4_, uint8 u8PSName5_, uint8 u8PSName6_, uint8 u8PSName7_, uint8 u8PSName8_, const ::std::string& sPSName_);

    /**
     * Destructor
     */
    inline  ~T_TunerStationData();

    /**
     * Assignment operator
     */
    inline T_TunerStationData& operator = (const T_TunerStationData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerStationData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerStationData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerStationData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerStationData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * .
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * .
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u8PTY"

    static const int kU8PTY = 1;

    /**
     * Clears the field "u8PTY".
     *
     * The field will be set to its default value. The hasU8PTY()
     * method will return false.
     */
    inline void clearU8PTY();

    /**
     * Checks whether the field "u8PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PTY()). Otherwise it will return false.
     */
    inline bool hasU8PTY () const;

    /**
     * Returns the value of the member "u8PTY".
     *
     * .
     *
     * @return The value of the field "u8PTY"
     */
    inline uint8 getU8PTY () const;

    /**
     * Sets the value of the member "u8PTY".
     *
     * .
     *
     * @param u8PTY The value which will be set
     */
    inline void setU8PTY (uint8 u8PTY_);

    // API of field "u16PackedInfo"

    static const int kU16PackedInfo = 2;

    /**
     * Clears the field "u16PackedInfo".
     *
     * The field will be set to its default value. The hasU16PackedInfo()
     * method will return false.
     */
    inline void clearU16PackedInfo();

    /**
     * Checks whether the field "u16PackedInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PackedInfo()). Otherwise it will return false.
     */
    inline bool hasU16PackedInfo () const;

    /**
     * Returns the value of the member "u16PackedInfo".
     *
     * .
     *
     * @return The value of the field "u16PackedInfo"
     */
    inline uint16 getU16PackedInfo () const;

    /**
     * Sets the value of the member "u16PackedInfo".
     *
     * .
     *
     * @param u16PackedInfo The value which will be set
     */
    inline void setU16PackedInfo (uint16 u16PackedInfo_);

    // API of field "u32AvailFlags"

    static const int kU32AvailFlags = 3;

    /**
     * Clears the field "u32AvailFlags".
     *
     * The field will be set to its default value. The hasU32AvailFlags()
     * method will return false.
     */
    inline void clearU32AvailFlags();

    /**
     * Checks whether the field "u32AvailFlags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AvailFlags()). Otherwise it will return false.
     */
    inline bool hasU32AvailFlags () const;

    /**
     * Returns the value of the member "u32AvailFlags".
     *
     * .
     *
     * @return The value of the field "u32AvailFlags"
     */
    inline const T_b32_Tun_AvailFlags& getU32AvailFlags () const;

    /**
     * Retrieves the value of the field "u32AvailFlags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u32AvailFlags".
     */
    inline T_b32_Tun_AvailFlags& getU32AvailFlagsMutable ();

    /**
     * Sets the value of the member "u32AvailFlags".
     *
     * .
     *
     * @param u32AvailFlags The value which will be set
     */
    inline void setU32AvailFlags (const T_b32_Tun_AvailFlags& u32AvailFlags_);

    /**
     * Release the object stored in the field "u32AvailFlags".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u32AvailFlags"
     */
    inline T_b32_Tun_AvailFlags* releaseU32AvailFlags();

    /**
     * Replace the field "u32AvailFlags".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU32AvailFlags (T_b32_Tun_AvailFlags* u32AvailFlags_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 4;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * .
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * .
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u32PI"

    static const int kU32PI = 5;

    /**
     * Clears the field "u32PI".
     *
     * The field will be set to its default value. The hasU32PI()
     * method will return false.
     */
    inline void clearU32PI();

    /**
     * Checks whether the field "u32PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PI()). Otherwise it will return false.
     */
    inline bool hasU32PI () const;

    /**
     * Returns the value of the member "u32PI".
     *
     * .
     *
     * @return The value of the field "u32PI"
     */
    inline uint32 getU32PI () const;

    /**
     * Sets the value of the member "u32PI".
     *
     * .
     *
     * @param u32PI The value which will be set
     */
    inline void setU32PI (uint32 u32PI_);

    // API of field "u8PSName1"

    static const int kU8PSName1 = 6;

    /**
     * Clears the field "u8PSName1".
     *
     * The field will be set to its default value. The hasU8PSName1()
     * method will return false.
     */
    inline void clearU8PSName1();

    /**
     * Checks whether the field "u8PSName1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName1()). Otherwise it will return false.
     */
    inline bool hasU8PSName1 () const;

    /**
     * Returns the value of the member "u8PSName1".
     *
     * .
     *
     * @return The value of the field "u8PSName1"
     */
    inline uint8 getU8PSName1 () const;

    /**
     * Sets the value of the member "u8PSName1".
     *
     * .
     *
     * @param u8PSName1 The value which will be set
     */
    inline void setU8PSName1 (uint8 u8PSName1_);

    // API of field "u8PSName2"

    static const int kU8PSName2 = 7;

    /**
     * Clears the field "u8PSName2".
     *
     * The field will be set to its default value. The hasU8PSName2()
     * method will return false.
     */
    inline void clearU8PSName2();

    /**
     * Checks whether the field "u8PSName2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName2()). Otherwise it will return false.
     */
    inline bool hasU8PSName2 () const;

    /**
     * Returns the value of the member "u8PSName2".
     *
     * .
     *
     * @return The value of the field "u8PSName2"
     */
    inline uint8 getU8PSName2 () const;

    /**
     * Sets the value of the member "u8PSName2".
     *
     * .
     *
     * @param u8PSName2 The value which will be set
     */
    inline void setU8PSName2 (uint8 u8PSName2_);

    // API of field "u8PSName3"

    static const int kU8PSName3 = 8;

    /**
     * Clears the field "u8PSName3".
     *
     * The field will be set to its default value. The hasU8PSName3()
     * method will return false.
     */
    inline void clearU8PSName3();

    /**
     * Checks whether the field "u8PSName3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName3()). Otherwise it will return false.
     */
    inline bool hasU8PSName3 () const;

    /**
     * Returns the value of the member "u8PSName3".
     *
     * .
     *
     * @return The value of the field "u8PSName3"
     */
    inline uint8 getU8PSName3 () const;

    /**
     * Sets the value of the member "u8PSName3".
     *
     * .
     *
     * @param u8PSName3 The value which will be set
     */
    inline void setU8PSName3 (uint8 u8PSName3_);

    // API of field "u8PSName4"

    static const int kU8PSName4 = 9;

    /**
     * Clears the field "u8PSName4".
     *
     * The field will be set to its default value. The hasU8PSName4()
     * method will return false.
     */
    inline void clearU8PSName4();

    /**
     * Checks whether the field "u8PSName4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName4()). Otherwise it will return false.
     */
    inline bool hasU8PSName4 () const;

    /**
     * Returns the value of the member "u8PSName4".
     *
     * .
     *
     * @return The value of the field "u8PSName4"
     */
    inline uint8 getU8PSName4 () const;

    /**
     * Sets the value of the member "u8PSName4".
     *
     * .
     *
     * @param u8PSName4 The value which will be set
     */
    inline void setU8PSName4 (uint8 u8PSName4_);

    // API of field "u8PSName5"

    static const int kU8PSName5 = 10;

    /**
     * Clears the field "u8PSName5".
     *
     * The field will be set to its default value. The hasU8PSName5()
     * method will return false.
     */
    inline void clearU8PSName5();

    /**
     * Checks whether the field "u8PSName5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName5()). Otherwise it will return false.
     */
    inline bool hasU8PSName5 () const;

    /**
     * Returns the value of the member "u8PSName5".
     *
     * .
     *
     * @return The value of the field "u8PSName5"
     */
    inline uint8 getU8PSName5 () const;

    /**
     * Sets the value of the member "u8PSName5".
     *
     * .
     *
     * @param u8PSName5 The value which will be set
     */
    inline void setU8PSName5 (uint8 u8PSName5_);

    // API of field "u8PSName6"

    static const int kU8PSName6 = 11;

    /**
     * Clears the field "u8PSName6".
     *
     * The field will be set to its default value. The hasU8PSName6()
     * method will return false.
     */
    inline void clearU8PSName6();

    /**
     * Checks whether the field "u8PSName6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName6()). Otherwise it will return false.
     */
    inline bool hasU8PSName6 () const;

    /**
     * Returns the value of the member "u8PSName6".
     *
     * .
     *
     * @return The value of the field "u8PSName6"
     */
    inline uint8 getU8PSName6 () const;

    /**
     * Sets the value of the member "u8PSName6".
     *
     * .
     *
     * @param u8PSName6 The value which will be set
     */
    inline void setU8PSName6 (uint8 u8PSName6_);

    // API of field "u8PSName7"

    static const int kU8PSName7 = 12;

    /**
     * Clears the field "u8PSName7".
     *
     * The field will be set to its default value. The hasU8PSName7()
     * method will return false.
     */
    inline void clearU8PSName7();

    /**
     * Checks whether the field "u8PSName7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName7()). Otherwise it will return false.
     */
    inline bool hasU8PSName7 () const;

    /**
     * Returns the value of the member "u8PSName7".
     *
     * .
     *
     * @return The value of the field "u8PSName7"
     */
    inline uint8 getU8PSName7 () const;

    /**
     * Sets the value of the member "u8PSName7".
     *
     * .
     *
     * @param u8PSName7 The value which will be set
     */
    inline void setU8PSName7 (uint8 u8PSName7_);

    // API of field "u8PSName8"

    static const int kU8PSName8 = 13;

    /**
     * Clears the field "u8PSName8".
     *
     * The field will be set to its default value. The hasU8PSName8()
     * method will return false.
     */
    inline void clearU8PSName8();

    /**
     * Checks whether the field "u8PSName8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName8()). Otherwise it will return false.
     */
    inline bool hasU8PSName8 () const;

    /**
     * Returns the value of the member "u8PSName8".
     *
     * .
     *
     * @return The value of the field "u8PSName8"
     */
    inline uint8 getU8PSName8 () const;

    /**
     * Sets the value of the member "u8PSName8".
     *
     * .
     *
     * @param u8PSName8 The value which will be set
     */
    inline void setU8PSName8 (uint8 u8PSName8_);

    // API of field "sPSName"

    static const int kSPSName = 14;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPSName"
     */
    inline ::std::string* releaseSPSName();

    /**
     * Replace the field "sPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPSName (::std::string* sPSName_);

    static const T_TunerStationData &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u8PTY ();

    inline void clear_has_u8PTY ();

    inline void set_has_u16PackedInfo ();

    inline void clear_has_u16PackedInfo ();

    inline void set_has_u32AvailFlags ();

    inline void clear_has_u32AvailFlags ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u32PI ();

    inline void clear_has_u32PI ();

    inline void set_has_u8PSName1 ();

    inline void clear_has_u8PSName1 ();

    inline void set_has_u8PSName2 ();

    inline void clear_has_u8PSName2 ();

    inline void set_has_u8PSName3 ();

    inline void clear_has_u8PSName3 ();

    inline void set_has_u8PSName4 ();

    inline void clear_has_u8PSName4 ();

    inline void set_has_u8PSName5 ();

    inline void clear_has_u8PSName5 ();

    inline void set_has_u8PSName6 ();

    inline void clear_has_u8PSName6 ();

    inline void set_has_u8PSName7 ();

    inline void clear_has_u8PSName7 ();

    inline void set_has_u8PSName8 ();

    inline void clear_has_u8PSName8 ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    uint32 _has_bits_[ (15 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    uint8 _u8PTY;

    uint16 _u16PackedInfo;

    T_b32_Tun_AvailFlags* _u32AvailFlags;

    uint32 _u32Frequency;

    uint32 _u32PI;

    uint8 _u8PSName1;

    uint8 _u8PSName2;

    uint8 _u8PSName3;

    uint8 _u8PSName4;

    uint8 _u8PSName5;

    uint8 _u8PSName6;

    uint8 _u8PSName7;

    uint8 _u8PSName8;

    ::std::string* _sPSName;

};

/**
 * Tuner feature can be switched ON OR OFF.
 */
class T_TunerFeature {
public:

    /**
     * Default constructor
     */
    inline  T_TunerFeature ();

    /**
     * Copy constructor
     */
    inline  T_TunerFeature (const T_TunerFeature &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerFeature (const T_b32_Tun_Features& b32Features_, const T_b32_Tun_Features& b32MaskFeatures_);

    /**
     * Destructor
     */
    inline  ~T_TunerFeature();

    /**
     * Assignment operator
     */
    inline T_TunerFeature& operator = (const T_TunerFeature& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerFeature& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerFeature& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerFeature& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerFeature& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b32Features"

    static const int kB32Features = 0;

    /**
     * Clears the field "b32Features".
     *
     * The field will be set to its default value. The hasB32Features()
     * method will return false.
     */
    inline void clearB32Features();

    /**
     * Checks whether the field "b32Features" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32Features()). Otherwise it will return false.
     */
    inline bool hasB32Features () const;

    /**
     * Returns the value of the member "b32Features".
     *
     * .
     *
     * @return The value of the field "b32Features"
     */
    inline const T_b32_Tun_Features& getB32Features () const;

    /**
     * Retrieves the value of the field "b32Features" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32Features".
     */
    inline T_b32_Tun_Features& getB32FeaturesMutable ();

    /**
     * Sets the value of the member "b32Features".
     *
     * .
     *
     * @param b32Features The value which will be set
     */
    inline void setB32Features (const T_b32_Tun_Features& b32Features_);

    /**
     * Release the object stored in the field "b32Features".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b32Features"
     */
    inline T_b32_Tun_Features* releaseB32Features();

    /**
     * Replace the field "b32Features".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB32Features (T_b32_Tun_Features* b32Features_);

    // API of field "b32MaskFeatures"

    static const int kB32MaskFeatures = 1;

    /**
     * Clears the field "b32MaskFeatures".
     *
     * The field will be set to its default value. The hasB32MaskFeatures()
     * method will return false.
     */
    inline void clearB32MaskFeatures();

    /**
     * Checks whether the field "b32MaskFeatures" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32MaskFeatures()). Otherwise it will return false.
     */
    inline bool hasB32MaskFeatures () const;

    /**
     * Returns the value of the member "b32MaskFeatures".
     *
     * .
     *
     * @return The value of the field "b32MaskFeatures"
     */
    inline const T_b32_Tun_Features& getB32MaskFeatures () const;

    /**
     * Retrieves the value of the field "b32MaskFeatures" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32MaskFeatures".
     */
    inline T_b32_Tun_Features& getB32MaskFeaturesMutable ();

    /**
     * Sets the value of the member "b32MaskFeatures".
     *
     * .
     *
     * @param b32MaskFeatures The value which will be set
     */
    inline void setB32MaskFeatures (const T_b32_Tun_Features& b32MaskFeatures_);

    /**
     * Release the object stored in the field "b32MaskFeatures".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b32MaskFeatures"
     */
    inline T_b32_Tun_Features* releaseB32MaskFeatures();

    /**
     * Replace the field "b32MaskFeatures".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB32MaskFeatures (T_b32_Tun_Features* b32MaskFeatures_);

    static const T_TunerFeature &getDefaultInstance();

private:

    inline void set_has_b32Features ();

    inline void clear_has_b32Features ();

    inline void set_has_b32MaskFeatures ();

    inline void clear_has_b32MaskFeatures ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_b32_Tun_Features* _b32Features;

    T_b32_Tun_Features* _b32MaskFeatures;

};

/**
 * Tuner Avail Flags .
 */
class T_b32_Tun_AvailableFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b32_Tun_AvailableFlags ();

    /**
     * Copy constructor
     */
    inline  T_b32_Tun_AvailableFlags (const T_b32_Tun_AvailableFlags &c);

    /**
     * Field constructor
     */
    inline  T_b32_Tun_AvailableFlags (bool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE, bool TUN_AVAILABLE_FLAGS_reserved, bool TUN_AVAILABLE_FLAGS_PS_AVAILABLE);

    /**
     * Assignment operator
     */
    inline T_b32_Tun_AvailableFlags& operator = (const T_b32_Tun_AvailableFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_Tun_AvailableFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_Tun_AvailableFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_Tun_AvailableFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_Tun_AvailableFlags& rhs) const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (bool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_reserved".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_reserved" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_reserved The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_reserved (bool TUN_AVAILABLE_FLAGS_reserved);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_reserved".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_reserved"
     */
    inline bool getTUN_AVAILABLE_FLAGS_reserved () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_PS_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_PS_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_PS_AVAILABLE (bool TUN_AVAILABLE_FLAGS_PS_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_PS_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_PS_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_PS_AVAILABLE () const;

    static const T_b32_Tun_AvailableFlags &getDefaultInstance();

private:

    bool _TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_reserved:1;

    bool _TUN_AVAILABLE_FLAGS_PS_AVAILABLE:1;

};

/**
 * Manual single or number of ticks steps is incremented in up or down direction. .
 */
class T_TunerManualSingleStep {
public:

    /**
     * Default constructor
     */
    inline  T_TunerManualSingleStep ();

    /**
     * Copy constructor
     */
    inline  T_TunerManualSingleStep (const T_TunerManualSingleStep &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerManualSingleStep (T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_, uint8 u8NumberOfTicks_);

    /**
     * Destructor
     */
    inline  ~T_TunerManualSingleStep();

    /**
     * Assignment operator
     */
    inline T_TunerManualSingleStep& operator = (const T_TunerManualSingleStep& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerManualSingleStep& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerManualSingleStep& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerManualSingleStep& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerManualSingleStep& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ManualFreqAdjustment"

    static const int kManualFreqAdjustment = 0;

    /**
     * Clears the field "ManualFreqAdjustment".
     *
     * The field will be set to its default value. The hasManualFreqAdjustment()
     * method will return false.
     */
    inline void clearManualFreqAdjustment();

    /**
     * Checks whether the field "ManualFreqAdjustment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setManualFreqAdjustment()). Otherwise it will return false.
     */
    inline bool hasManualFreqAdjustment () const;

    /**
     * Returns the value of the member "ManualFreqAdjustment".
     *
     * .
     *
     * @return The value of the field "ManualFreqAdjustment"
     */
    inline T_e8_Tun_ManualFreqAdjustment getManualFreqAdjustment () const;

    /**
     * Sets the value of the member "ManualFreqAdjustment".
     *
     * .
     *
     * @param ManualFreqAdjustment The value which will be set
     */
    inline void setManualFreqAdjustment (T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_);

    // API of field "u8NumberOfTicks"

    static const int kU8NumberOfTicks = 1;

    /**
     * Clears the field "u8NumberOfTicks".
     *
     * The field will be set to its default value. The hasU8NumberOfTicks()
     * method will return false.
     */
    inline void clearU8NumberOfTicks();

    /**
     * Checks whether the field "u8NumberOfTicks" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfTicks()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfTicks () const;

    /**
     * Returns the value of the member "u8NumberOfTicks".
     *
     * Number of ticks manual steps needs to be done.
     *
     * @return The value of the field "u8NumberOfTicks"
     */
    inline uint8 getU8NumberOfTicks () const;

    /**
     * Sets the value of the member "u8NumberOfTicks".
     *
     * Number of ticks manual steps needs to be done.
     *
     * @param u8NumberOfTicks The value which will be set
     */
    inline void setU8NumberOfTicks (uint8 u8NumberOfTicks_);

    static const T_TunerManualSingleStep &getDefaultInstance();

private:

    inline void set_has_ManualFreqAdjustment ();

    inline void clear_has_ManualFreqAdjustment ();

    inline void set_has_u8NumberOfTicks ();

    inline void clear_has_u8NumberOfTicks ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_ManualFreqAdjustment _ManualFreqAdjustment;

    uint8 _u8NumberOfTicks;

};

/**
 * .
 */
class T_b8_Tun_OperationFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_OperationFlags ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_OperationFlags (const T_b8_Tun_OperationFlags &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_OperationFlags (bool TUN_OPERATION_AFBEST, bool TUN_OPERATION_PTY, bool TUN_OPERATION_SEARCH, bool TUN_OPERATION_TA, bool TUN_OPERATION_TPSEEK, bool TUN_OPERATION_ACTION, bool TUN_OPERATION_SEEK_LEVEL_LOGIC, bool TUN_OPERATION_reserved);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_OperationFlags& operator = (const T_b8_Tun_OperationFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_OperationFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_OperationFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_OperationFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_OperationFlags& rhs) const;

    /**
     * Sets the value of the member "TUN_OPERATION_AFBEST".
     *
     * If the meaning of "TUN_OPERATION_AFBEST" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_AFBEST The value which will be set
     */
    inline void setTUN_OPERATION_AFBEST (bool TUN_OPERATION_AFBEST);

    /**
     * Returns the value of the member "TUN_OPERATION_AFBEST".
     *
     * If the meaning of "TUN_OPERATION_AFBEST" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_AFBEST"
     */
    inline bool getTUN_OPERATION_AFBEST () const;

    /**
     * Sets the value of the member "TUN_OPERATION_PTY".
     *
     * If the meaning of "TUN_OPERATION_PTY" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_PTY The value which will be set
     */
    inline void setTUN_OPERATION_PTY (bool TUN_OPERATION_PTY);

    /**
     * Returns the value of the member "TUN_OPERATION_PTY".
     *
     * If the meaning of "TUN_OPERATION_PTY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_PTY"
     */
    inline bool getTUN_OPERATION_PTY () const;

    /**
     * Sets the value of the member "TUN_OPERATION_SEARCH".
     *
     * If the meaning of "TUN_OPERATION_SEARCH" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_SEARCH The value which will be set
     */
    inline void setTUN_OPERATION_SEARCH (bool TUN_OPERATION_SEARCH);

    /**
     * Returns the value of the member "TUN_OPERATION_SEARCH".
     *
     * If the meaning of "TUN_OPERATION_SEARCH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_SEARCH"
     */
    inline bool getTUN_OPERATION_SEARCH () const;

    /**
     * Sets the value of the member "TUN_OPERATION_TA".
     *
     * If the meaning of "TUN_OPERATION_TA" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_TA The value which will be set
     */
    inline void setTUN_OPERATION_TA (bool TUN_OPERATION_TA);

    /**
     * Returns the value of the member "TUN_OPERATION_TA".
     *
     * If the meaning of "TUN_OPERATION_TA" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_TA"
     */
    inline bool getTUN_OPERATION_TA () const;

    /**
     * Sets the value of the member "TUN_OPERATION_TPSEEK".
     *
     * If the meaning of "TUN_OPERATION_TPSEEK" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_TPSEEK The value which will be set
     */
    inline void setTUN_OPERATION_TPSEEK (bool TUN_OPERATION_TPSEEK);

    /**
     * Returns the value of the member "TUN_OPERATION_TPSEEK".
     *
     * If the meaning of "TUN_OPERATION_TPSEEK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_TPSEEK"
     */
    inline bool getTUN_OPERATION_TPSEEK () const;

    /**
     * Sets the value of the member "TUN_OPERATION_ACTION".
     *
     * If the meaning of "TUN_OPERATION_ACTION" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_ACTION The value which will be set
     */
    inline void setTUN_OPERATION_ACTION (bool TUN_OPERATION_ACTION);

    /**
     * Returns the value of the member "TUN_OPERATION_ACTION".
     *
     * If the meaning of "TUN_OPERATION_ACTION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_ACTION"
     */
    inline bool getTUN_OPERATION_ACTION () const;

    /**
     * Sets the value of the member "TUN_OPERATION_SEEK_LEVEL_LOGIC".
     *
     * If the meaning of "TUN_OPERATION_SEEK_LEVEL_LOGIC" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_SEEK_LEVEL_LOGIC The value which will be set
     */
    inline void setTUN_OPERATION_SEEK_LEVEL_LOGIC (bool TUN_OPERATION_SEEK_LEVEL_LOGIC);

    /**
     * Returns the value of the member "TUN_OPERATION_SEEK_LEVEL_LOGIC".
     *
     * If the meaning of "TUN_OPERATION_SEEK_LEVEL_LOGIC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_SEEK_LEVEL_LOGIC"
     */
    inline bool getTUN_OPERATION_SEEK_LEVEL_LOGIC () const;

    /**
     * Sets the value of the member "TUN_OPERATION_reserved".
     *
     * If the meaning of "TUN_OPERATION_reserved" isn't clear, then there should be a description here.
     *
     * @param TUN_OPERATION_reserved The value which will be set
     */
    inline void setTUN_OPERATION_reserved (bool TUN_OPERATION_reserved);

    /**
     * Returns the value of the member "TUN_OPERATION_reserved".
     *
     * If the meaning of "TUN_OPERATION_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_OPERATION_reserved"
     */
    inline bool getTUN_OPERATION_reserved () const;

    static const T_b8_Tun_OperationFlags &getDefaultInstance();

private:

    bool _TUN_OPERATION_AFBEST:1;

    bool _TUN_OPERATION_PTY:1;

    bool _TUN_OPERATION_SEARCH:1;

    bool _TUN_OPERATION_TA:1;

    bool _TUN_OPERATION_TPSEEK:1;

    bool _TUN_OPERATION_ACTION:1;

    bool _TUN_OPERATION_SEEK_LEVEL_LOGIC:1;

    bool _TUN_OPERATION_reserved:1;

};

/**
 * Various operations like AFBEST, TP SEEK,TA can be enabled or Disabled by Tuner .
 */
class T_TunerOperation {
public:

    /**
     * Default constructor
     */
    inline  T_TunerOperation ();

    /**
     * Copy constructor
     */
    inline  T_TunerOperation (const T_TunerOperation &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerOperation (T_e8_Tun_EnableOrDisable u8EnableOrDisable_, T_e8_Tun_OperationFlags u8OperationFlags_);

    /**
     * Destructor
     */
    inline  ~T_TunerOperation();

    /**
     * Assignment operator
     */
    inline T_TunerOperation& operator = (const T_TunerOperation& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerOperation& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerOperation& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerOperation& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerOperation& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8EnableOrDisable"

    static const int kU8EnableOrDisable = 0;

    /**
     * Clears the field "u8EnableOrDisable".
     *
     * The field will be set to its default value. The hasU8EnableOrDisable()
     * method will return false.
     */
    inline void clearU8EnableOrDisable();

    /**
     * Checks whether the field "u8EnableOrDisable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EnableOrDisable()). Otherwise it will return false.
     */
    inline bool hasU8EnableOrDisable () const;

    /**
     * Returns the value of the member "u8EnableOrDisable".
     *
     * .
     *
     * @return The value of the field "u8EnableOrDisable"
     */
    inline T_e8_Tun_EnableOrDisable getU8EnableOrDisable () const;

    /**
     * Sets the value of the member "u8EnableOrDisable".
     *
     * .
     *
     * @param u8EnableOrDisable The value which will be set
     */
    inline void setU8EnableOrDisable (T_e8_Tun_EnableOrDisable u8EnableOrDisable_);

    // API of field "u8OperationFlags"

    static const int kU8OperationFlags = 1;

    /**
     * Clears the field "u8OperationFlags".
     *
     * The field will be set to its default value. The hasU8OperationFlags()
     * method will return false.
     */
    inline void clearU8OperationFlags();

    /**
     * Checks whether the field "u8OperationFlags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8OperationFlags()). Otherwise it will return false.
     */
    inline bool hasU8OperationFlags () const;

    /**
     * Returns the value of the member "u8OperationFlags".
     *
     * .
     *
     * @return The value of the field "u8OperationFlags"
     */
    inline T_e8_Tun_OperationFlags getU8OperationFlags () const;

    /**
     * Sets the value of the member "u8OperationFlags".
     *
     * .
     *
     * @param u8OperationFlags The value which will be set
     */
    inline void setU8OperationFlags (T_e8_Tun_OperationFlags u8OperationFlags_);

    static const T_TunerOperation &getDefaultInstance();

private:

    inline void set_has_u8EnableOrDisable ();

    inline void clear_has_u8EnableOrDisable ();

    inline void set_has_u8OperationFlags ();

    inline void clear_has_u8OperationFlags ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_EnableOrDisable _u8EnableOrDisable;

    T_e8_Tun_OperationFlags _u8OperationFlags;

};

/**
 * Tuner Af List Data .
 */
class T_TunerAFList {
public:

    /**
     * Default constructor
     */
    inline  T_TunerAFList ();

    /**
     * Copy constructor
     */
    inline  T_TunerAFList (const T_TunerAFList &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerAFList (T_e8_Tun_TunerHeader u8TunerHeader_, uint8 u8AFListElementID_, uint32 u32AFFrequency_, uint8 u8AFQualityLevel_, uint8 u8AFFieldStrength_, uint8 u8AFBitErrorRate_, T_e8_Tun_AFInformation u8AFInfo_, uint16 u16AFPI_);

    /**
     * Destructor
     */
    inline  ~T_TunerAFList();

    /**
     * Assignment operator
     */
    inline T_TunerAFList& operator = (const T_TunerAFList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerAFList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerAFList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerAFList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerAFList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * This parameter will be removed from Fi in CW50
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * This parameter will be removed from Fi in CW50
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u8AFListElementID"

    static const int kU8AFListElementID = 1;

    /**
     * Clears the field "u8AFListElementID".
     *
     * The field will be set to its default value. The hasU8AFListElementID()
     * method will return false.
     */
    inline void clearU8AFListElementID();

    /**
     * Checks whether the field "u8AFListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFListElementID()). Otherwise it will return false.
     */
    inline bool hasU8AFListElementID () const;

    /**
     * Returns the value of the member "u8AFListElementID".
     *
     * .
     *
     * @return The value of the field "u8AFListElementID"
     */
    inline uint8 getU8AFListElementID () const;

    /**
     * Sets the value of the member "u8AFListElementID".
     *
     * .
     *
     * @param u8AFListElementID The value which will be set
     */
    inline void setU8AFListElementID (uint8 u8AFListElementID_);

    // API of field "u32AFFrequency"

    static const int kU32AFFrequency = 2;

    /**
     * Clears the field "u32AFFrequency".
     *
     * The field will be set to its default value. The hasU32AFFrequency()
     * method will return false.
     */
    inline void clearU32AFFrequency();

    /**
     * Checks whether the field "u32AFFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AFFrequency()). Otherwise it will return false.
     */
    inline bool hasU32AFFrequency () const;

    /**
     * Returns the value of the member "u32AFFrequency".
     *
     * .
     *
     * @return The value of the field "u32AFFrequency"
     */
    inline uint32 getU32AFFrequency () const;

    /**
     * Sets the value of the member "u32AFFrequency".
     *
     * .
     *
     * @param u32AFFrequency The value which will be set
     */
    inline void setU32AFFrequency (uint32 u32AFFrequency_);

    // API of field "u8AFQualityLevel"

    static const int kU8AFQualityLevel = 3;

    /**
     * Clears the field "u8AFQualityLevel".
     *
     * The field will be set to its default value. The hasU8AFQualityLevel()
     * method will return false.
     */
    inline void clearU8AFQualityLevel();

    /**
     * Checks whether the field "u8AFQualityLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFQualityLevel()). Otherwise it will return false.
     */
    inline bool hasU8AFQualityLevel () const;

    /**
     * Returns the value of the member "u8AFQualityLevel".
     *
     * .
     *
     * @return The value of the field "u8AFQualityLevel"
     */
    inline uint8 getU8AFQualityLevel () const;

    /**
     * Sets the value of the member "u8AFQualityLevel".
     *
     * .
     *
     * @param u8AFQualityLevel The value which will be set
     */
    inline void setU8AFQualityLevel (uint8 u8AFQualityLevel_);

    // API of field "u8AFFieldStrength"

    static const int kU8AFFieldStrength = 4;

    /**
     * Clears the field "u8AFFieldStrength".
     *
     * The field will be set to its default value. The hasU8AFFieldStrength()
     * method will return false.
     */
    inline void clearU8AFFieldStrength();

    /**
     * Checks whether the field "u8AFFieldStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFFieldStrength()). Otherwise it will return false.
     */
    inline bool hasU8AFFieldStrength () const;

    /**
     * Returns the value of the member "u8AFFieldStrength".
     *
     * .
     *
     * @return The value of the field "u8AFFieldStrength"
     */
    inline uint8 getU8AFFieldStrength () const;

    /**
     * Sets the value of the member "u8AFFieldStrength".
     *
     * .
     *
     * @param u8AFFieldStrength The value which will be set
     */
    inline void setU8AFFieldStrength (uint8 u8AFFieldStrength_);

    // API of field "u8AFBitErrorRate"

    static const int kU8AFBitErrorRate = 5;

    /**
     * Clears the field "u8AFBitErrorRate".
     *
     * The field will be set to its default value. The hasU8AFBitErrorRate()
     * method will return false.
     */
    inline void clearU8AFBitErrorRate();

    /**
     * Checks whether the field "u8AFBitErrorRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFBitErrorRate()). Otherwise it will return false.
     */
    inline bool hasU8AFBitErrorRate () const;

    /**
     * Returns the value of the member "u8AFBitErrorRate".
     *
     * .
     *
     * @return The value of the field "u8AFBitErrorRate"
     */
    inline uint8 getU8AFBitErrorRate () const;

    /**
     * Sets the value of the member "u8AFBitErrorRate".
     *
     * .
     *
     * @param u8AFBitErrorRate The value which will be set
     */
    inline void setU8AFBitErrorRate (uint8 u8AFBitErrorRate_);

    // API of field "u8AFInfo"

    static const int kU8AFInfo = 6;

    /**
     * Clears the field "u8AFInfo".
     *
     * The field will be set to its default value. The hasU8AFInfo()
     * method will return false.
     */
    inline void clearU8AFInfo();

    /**
     * Checks whether the field "u8AFInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFInfo()). Otherwise it will return false.
     */
    inline bool hasU8AFInfo () const;

    /**
     * Returns the value of the member "u8AFInfo".
     *
     * .
     *
     * @return The value of the field "u8AFInfo"
     */
    inline T_e8_Tun_AFInformation getU8AFInfo () const;

    /**
     * Sets the value of the member "u8AFInfo".
     *
     * .
     *
     * @param u8AFInfo The value which will be set
     */
    inline void setU8AFInfo (T_e8_Tun_AFInformation u8AFInfo_);

    // API of field "u16AFPI"

    static const int kU16AFPI = 7;

    /**
     * Clears the field "u16AFPI".
     *
     * The field will be set to its default value. The hasU16AFPI()
     * method will return false.
     */
    inline void clearU16AFPI();

    /**
     * Checks whether the field "u16AFPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AFPI()). Otherwise it will return false.
     */
    inline bool hasU16AFPI () const;

    /**
     * Returns the value of the member "u16AFPI".
     *
     * .
     *
     * @return The value of the field "u16AFPI"
     */
    inline uint16 getU16AFPI () const;

    /**
     * Sets the value of the member "u16AFPI".
     *
     * .
     *
     * @param u16AFPI The value which will be set
     */
    inline void setU16AFPI (uint16 u16AFPI_);

    static const T_TunerAFList &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u8AFListElementID ();

    inline void clear_has_u8AFListElementID ();

    inline void set_has_u32AFFrequency ();

    inline void clear_has_u32AFFrequency ();

    inline void set_has_u8AFQualityLevel ();

    inline void clear_has_u8AFQualityLevel ();

    inline void set_has_u8AFFieldStrength ();

    inline void clear_has_u8AFFieldStrength ();

    inline void set_has_u8AFBitErrorRate ();

    inline void clear_has_u8AFBitErrorRate ();

    inline void set_has_u8AFInfo ();

    inline void clear_has_u8AFInfo ();

    inline void set_has_u16AFPI ();

    inline void clear_has_u16AFPI ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    uint8 _u8AFListElementID;

    uint32 _u32AFFrequency;

    uint8 _u8AFQualityLevel;

    uint8 _u8AFFieldStrength;

    uint8 _u8AFBitErrorRate;

    T_e8_Tun_AFInformation _u8AFInfo;

    uint16 _u16AFPI;

};

/**
 * Test Mode Bits
 */
class T_b8_Tun_TestmodeBits {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_TestmodeBits ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_TestmodeBits (const T_b8_Tun_TestmodeBits &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_TestmodeBits (bool TUN_TP_BIT, bool TUN_TA_BIT, bool TUN_TMC_BIT, bool TUN_UNUSED_BIT, bool TUN_AUDIO_TUNER_BIT);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_TestmodeBits& operator = (const T_b8_Tun_TestmodeBits& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_TestmodeBits& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_TestmodeBits& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_TestmodeBits& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_TestmodeBits& rhs) const;

    /**
     * Sets the value of the member "TUN_TP_BIT".
     *
     * If the meaning of "TUN_TP_BIT" isn't clear, then there should be a description here.
     *
     * @param TUN_TP_BIT The value which will be set
     */
    inline void setTUN_TP_BIT (bool TUN_TP_BIT);

    /**
     * Returns the value of the member "TUN_TP_BIT".
     *
     * If the meaning of "TUN_TP_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TP_BIT"
     */
    inline bool getTUN_TP_BIT () const;

    /**
     * Sets the value of the member "TUN_TA_BIT".
     *
     * If the meaning of "TUN_TA_BIT" isn't clear, then there should be a description here.
     *
     * @param TUN_TA_BIT The value which will be set
     */
    inline void setTUN_TA_BIT (bool TUN_TA_BIT);

    /**
     * Returns the value of the member "TUN_TA_BIT".
     *
     * If the meaning of "TUN_TA_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TA_BIT"
     */
    inline bool getTUN_TA_BIT () const;

    /**
     * Sets the value of the member "TUN_TMC_BIT".
     *
     * If the meaning of "TUN_TMC_BIT" isn't clear, then there should be a description here.
     *
     * @param TUN_TMC_BIT The value which will be set
     */
    inline void setTUN_TMC_BIT (bool TUN_TMC_BIT);

    /**
     * Returns the value of the member "TUN_TMC_BIT".
     *
     * If the meaning of "TUN_TMC_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TMC_BIT"
     */
    inline bool getTUN_TMC_BIT () const;

    /**
     * Sets the value of the member "TUN_UNUSED_BIT".
     *
     * If the meaning of "TUN_UNUSED_BIT" isn't clear, then there should be a description here.
     *
     * @param TUN_UNUSED_BIT The value which will be set
     */
    inline void setTUN_UNUSED_BIT (bool TUN_UNUSED_BIT);

    /**
     * Returns the value of the member "TUN_UNUSED_BIT".
     *
     * If the meaning of "TUN_UNUSED_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_UNUSED_BIT"
     */
    inline bool getTUN_UNUSED_BIT () const;

    /**
     * Sets the value of the member "TUN_AUDIO_TUNER_BIT".
     *
     * If the meaning of "TUN_AUDIO_TUNER_BIT" isn't clear, then there should be a description here.
     *
     * @param TUN_AUDIO_TUNER_BIT The value which will be set
     */
    inline void setTUN_AUDIO_TUNER_BIT (bool TUN_AUDIO_TUNER_BIT);

    /**
     * Returns the value of the member "TUN_AUDIO_TUNER_BIT".
     *
     * If the meaning of "TUN_AUDIO_TUNER_BIT" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AUDIO_TUNER_BIT"
     */
    inline bool getTUN_AUDIO_TUNER_BIT () const;

    static const T_b8_Tun_TestmodeBits &getDefaultInstance();

private:

    bool _TUN_TP_BIT:1;

    bool _TUN_TA_BIT:1;

    bool _TUN_TMC_BIT:1;

    bool _TUN_UNUSED_BIT:1;

    bool _TUN_AUDIO_TUNER_BIT:1;

};

/**
 * TunerTest Mode Data .
 */
class T_TunerTestModeData {
public:

    /**
     * Default constructor
     */
    inline  T_TunerTestModeData ();

    /**
     * Copy constructor
     */
    inline  T_TunerTestModeData (const T_TunerTestModeData &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerTestModeData (T_e8_Tun_TunerHeader u8TunerHeader_, T_e8_Tun_AdditionalInfo u8AdditionalInfo_, uint32 u32AFFrequency_, uint32 u32PI_, uint8 u8Quality_, uint8 u8Fieldstrength_, uint8 u8Multipath_, uint8 u8Neighbour_, uint8 u8AFListLength_, const T_b8_Tun_TestmodeBits& u8TestmodeBits_, uint8 u8TMCStationCount_, T_e8_Tun_TMCGroupState u8TMCGroupState_, T_e8_Tun_AntennaState u8AntennaState_, uint8 u8PSName1_, uint8 u8PSName2_, uint8 u8PSName3_, uint8 u8PSName4_, uint8 u8PSName5_, uint8 u8PSName6_, uint8 u8PSName7_, uint8 u8PSName8_, const ::std::string& sPSName_, T_e8_Tun_IfState u8IFState_, uint8 u8ChannelSeparation_, uint8 u8Hub_, uint8 u8RdsErrorRate_);

    /**
     * Destructor
     */
    inline  ~T_TunerTestModeData();

    /**
     * Assignment operator
     */
    inline T_TunerTestModeData& operator = (const T_TunerTestModeData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerTestModeData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerTestModeData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerTestModeData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerTestModeData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * .
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * .
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u8AdditionalInfo"

    static const int kU8AdditionalInfo = 1;

    /**
     * Clears the field "u8AdditionalInfo".
     *
     * The field will be set to its default value. The hasU8AdditionalInfo()
     * method will return false.
     */
    inline void clearU8AdditionalInfo();

    /**
     * Checks whether the field "u8AdditionalInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AdditionalInfo()). Otherwise it will return false.
     */
    inline bool hasU8AdditionalInfo () const;

    /**
     * Returns the value of the member "u8AdditionalInfo".
     *
     * RDS_SYNC                   (0x01),
     * AF_CHANGE_REQUEST         (0x02).
     *
     * @return The value of the field "u8AdditionalInfo"
     */
    inline T_e8_Tun_AdditionalInfo getU8AdditionalInfo () const;

    /**
     * Sets the value of the member "u8AdditionalInfo".
     *
     * RDS_SYNC                   (0x01),
     * AF_CHANGE_REQUEST         (0x02).
     *
     * @param u8AdditionalInfo The value which will be set
     */
    inline void setU8AdditionalInfo (T_e8_Tun_AdditionalInfo u8AdditionalInfo_);

    // API of field "u32AFFrequency"

    static const int kU32AFFrequency = 2;

    /**
     * Clears the field "u32AFFrequency".
     *
     * The field will be set to its default value. The hasU32AFFrequency()
     * method will return false.
     */
    inline void clearU32AFFrequency();

    /**
     * Checks whether the field "u32AFFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AFFrequency()). Otherwise it will return false.
     */
    inline bool hasU32AFFrequency () const;

    /**
     * Returns the value of the member "u32AFFrequency".
     *
     * .
     *
     * @return The value of the field "u32AFFrequency"
     */
    inline uint32 getU32AFFrequency () const;

    /**
     * Sets the value of the member "u32AFFrequency".
     *
     * .
     *
     * @param u32AFFrequency The value which will be set
     */
    inline void setU32AFFrequency (uint32 u32AFFrequency_);

    // API of field "u32PI"

    static const int kU32PI = 3;

    /**
     * Clears the field "u32PI".
     *
     * The field will be set to its default value. The hasU32PI()
     * method will return false.
     */
    inline void clearU32PI();

    /**
     * Checks whether the field "u32PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PI()). Otherwise it will return false.
     */
    inline bool hasU32PI () const;

    /**
     * Returns the value of the member "u32PI".
     *
     * .
     *
     * @return The value of the field "u32PI"
     */
    inline uint32 getU32PI () const;

    /**
     * Sets the value of the member "u32PI".
     *
     * .
     *
     * @param u32PI The value which will be set
     */
    inline void setU32PI (uint32 u32PI_);

    // API of field "u8Quality"

    static const int kU8Quality = 4;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * .
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * .
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    // API of field "u8Fieldstrength"

    static const int kU8Fieldstrength = 5;

    /**
     * Clears the field "u8Fieldstrength".
     *
     * The field will be set to its default value. The hasU8Fieldstrength()
     * method will return false.
     */
    inline void clearU8Fieldstrength();

    /**
     * Checks whether the field "u8Fieldstrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Fieldstrength()). Otherwise it will return false.
     */
    inline bool hasU8Fieldstrength () const;

    /**
     * Returns the value of the member "u8Fieldstrength".
     *
     * .
     *
     * @return The value of the field "u8Fieldstrength"
     */
    inline uint8 getU8Fieldstrength () const;

    /**
     * Sets the value of the member "u8Fieldstrength".
     *
     * .
     *
     * @param u8Fieldstrength The value which will be set
     */
    inline void setU8Fieldstrength (uint8 u8Fieldstrength_);

    // API of field "u8Multipath"

    static const int kU8Multipath = 6;

    /**
     * Clears the field "u8Multipath".
     *
     * The field will be set to its default value. The hasU8Multipath()
     * method will return false.
     */
    inline void clearU8Multipath();

    /**
     * Checks whether the field "u8Multipath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Multipath()). Otherwise it will return false.
     */
    inline bool hasU8Multipath () const;

    /**
     * Returns the value of the member "u8Multipath".
     *
     * .
     *
     * @return The value of the field "u8Multipath"
     */
    inline uint8 getU8Multipath () const;

    /**
     * Sets the value of the member "u8Multipath".
     *
     * .
     *
     * @param u8Multipath The value which will be set
     */
    inline void setU8Multipath (uint8 u8Multipath_);

    // API of field "u8Neighbour"

    static const int kU8Neighbour = 7;

    /**
     * Clears the field "u8Neighbour".
     *
     * The field will be set to its default value. The hasU8Neighbour()
     * method will return false.
     */
    inline void clearU8Neighbour();

    /**
     * Checks whether the field "u8Neighbour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Neighbour()). Otherwise it will return false.
     */
    inline bool hasU8Neighbour () const;

    /**
     * Returns the value of the member "u8Neighbour".
     *
     * .
     *
     * @return The value of the field "u8Neighbour"
     */
    inline uint8 getU8Neighbour () const;

    /**
     * Sets the value of the member "u8Neighbour".
     *
     * .
     *
     * @param u8Neighbour The value which will be set
     */
    inline void setU8Neighbour (uint8 u8Neighbour_);

    // API of field "u8AFListLength"

    static const int kU8AFListLength = 8;

    /**
     * Clears the field "u8AFListLength".
     *
     * The field will be set to its default value. The hasU8AFListLength()
     * method will return false.
     */
    inline void clearU8AFListLength();

    /**
     * Checks whether the field "u8AFListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFListLength()). Otherwise it will return false.
     */
    inline bool hasU8AFListLength () const;

    /**
     * Returns the value of the member "u8AFListLength".
     *
     * .
     *
     * @return The value of the field "u8AFListLength"
     */
    inline uint8 getU8AFListLength () const;

    /**
     * Sets the value of the member "u8AFListLength".
     *
     * .
     *
     * @param u8AFListLength The value which will be set
     */
    inline void setU8AFListLength (uint8 u8AFListLength_);

    // API of field "u8TestmodeBits"

    static const int kU8TestmodeBits = 9;

    /**
     * Clears the field "u8TestmodeBits".
     *
     * The field will be set to its default value. The hasU8TestmodeBits()
     * method will return false.
     */
    inline void clearU8TestmodeBits();

    /**
     * Checks whether the field "u8TestmodeBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TestmodeBits()). Otherwise it will return false.
     */
    inline bool hasU8TestmodeBits () const;

    /**
     * Returns the value of the member "u8TestmodeBits".
     *
     * TP_BIT      (BIT1)
     * TA_BIT      (BIT2)
     *
     * @return The value of the field "u8TestmodeBits"
     */
    inline const T_b8_Tun_TestmodeBits& getU8TestmodeBits () const;

    /**
     * Retrieves the value of the field "u8TestmodeBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u8TestmodeBits".
     */
    inline T_b8_Tun_TestmodeBits& getU8TestmodeBitsMutable ();

    /**
     * Sets the value of the member "u8TestmodeBits".
     *
     * TP_BIT      (BIT1)
     * TA_BIT      (BIT2)
     *
     * @param u8TestmodeBits The value which will be set
     */
    inline void setU8TestmodeBits (const T_b8_Tun_TestmodeBits& u8TestmodeBits_);

    /**
     * Release the object stored in the field "u8TestmodeBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u8TestmodeBits"
     */
    inline T_b8_Tun_TestmodeBits* releaseU8TestmodeBits();

    /**
     * Replace the field "u8TestmodeBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU8TestmodeBits (T_b8_Tun_TestmodeBits* u8TestmodeBits_);

    // API of field "u8TMCStationCount"

    static const int kU8TMCStationCount = 10;

    /**
     * Clears the field "u8TMCStationCount".
     *
     * The field will be set to its default value. The hasU8TMCStationCount()
     * method will return false.
     */
    inline void clearU8TMCStationCount();

    /**
     * Checks whether the field "u8TMCStationCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TMCStationCount()). Otherwise it will return false.
     */
    inline bool hasU8TMCStationCount () const;

    /**
     * Returns the value of the member "u8TMCStationCount".
     *
     * .
     *
     * @return The value of the field "u8TMCStationCount"
     */
    inline uint8 getU8TMCStationCount () const;

    /**
     * Sets the value of the member "u8TMCStationCount".
     *
     * .
     *
     * @param u8TMCStationCount The value which will be set
     */
    inline void setU8TMCStationCount (uint8 u8TMCStationCount_);

    // API of field "u8TMCGroupState"

    static const int kU8TMCGroupState = 11;

    /**
     * Clears the field "u8TMCGroupState".
     *
     * The field will be set to its default value. The hasU8TMCGroupState()
     * method will return false.
     */
    inline void clearU8TMCGroupState();

    /**
     * Checks whether the field "u8TMCGroupState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TMCGroupState()). Otherwise it will return false.
     */
    inline bool hasU8TMCGroupState () const;

    /**
     * Returns the value of the member "u8TMCGroupState".
     *
     * NO_DATA_AVAILABLE       (0x00),
     * DATA_NOT_REPEATED       (0x01),
     * TWO_GROUPS_IDENTICAL      (0x02),
     * THREE_GROUPS_IDENTICAL      (0x03),
     * AFI_BIT             (0x80),
     * GROUP_3A_DETECTED       (0x40)  .
     *
     * @return The value of the field "u8TMCGroupState"
     */
    inline T_e8_Tun_TMCGroupState getU8TMCGroupState () const;

    /**
     * Sets the value of the member "u8TMCGroupState".
     *
     * NO_DATA_AVAILABLE       (0x00),
     * DATA_NOT_REPEATED       (0x01),
     * TWO_GROUPS_IDENTICAL      (0x02),
     * THREE_GROUPS_IDENTICAL      (0x03),
     * AFI_BIT             (0x80),
     * GROUP_3A_DETECTED       (0x40)  .
     *
     * @param u8TMCGroupState The value which will be set
     */
    inline void setU8TMCGroupState (T_e8_Tun_TMCGroupState u8TMCGroupState_);

    // API of field "u8AntennaState"

    static const int kU8AntennaState = 12;

    /**
     * Clears the field "u8AntennaState".
     *
     * The field will be set to its default value. The hasU8AntennaState()
     * method will return false.
     */
    inline void clearU8AntennaState();

    /**
     * Checks whether the field "u8AntennaState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AntennaState()). Otherwise it will return false.
     */
    inline bool hasU8AntennaState () const;

    /**
     * Returns the value of the member "u8AntennaState".
     *
     * PHANTOM_SUPPLY_OFF      (0x00),
     * PHANTOM_SUPPLY_ON       (0x01),
     * PHANTOM_SUPPLY_UNKNOWN    (0x02).
     *
     * @return The value of the field "u8AntennaState"
     */
    inline T_e8_Tun_AntennaState getU8AntennaState () const;

    /**
     * Sets the value of the member "u8AntennaState".
     *
     * PHANTOM_SUPPLY_OFF      (0x00),
     * PHANTOM_SUPPLY_ON       (0x01),
     * PHANTOM_SUPPLY_UNKNOWN    (0x02).
     *
     * @param u8AntennaState The value which will be set
     */
    inline void setU8AntennaState (T_e8_Tun_AntennaState u8AntennaState_);

    // API of field "u8PSName1"

    static const int kU8PSName1 = 13;

    /**
     * Clears the field "u8PSName1".
     *
     * The field will be set to its default value. The hasU8PSName1()
     * method will return false.
     */
    inline void clearU8PSName1();

    /**
     * Checks whether the field "u8PSName1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName1()). Otherwise it will return false.
     */
    inline bool hasU8PSName1 () const;

    /**
     * Returns the value of the member "u8PSName1".
     *
     * .
     *
     * @return The value of the field "u8PSName1"
     */
    inline uint8 getU8PSName1 () const;

    /**
     * Sets the value of the member "u8PSName1".
     *
     * .
     *
     * @param u8PSName1 The value which will be set
     */
    inline void setU8PSName1 (uint8 u8PSName1_);

    // API of field "u8PSName2"

    static const int kU8PSName2 = 14;

    /**
     * Clears the field "u8PSName2".
     *
     * The field will be set to its default value. The hasU8PSName2()
     * method will return false.
     */
    inline void clearU8PSName2();

    /**
     * Checks whether the field "u8PSName2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName2()). Otherwise it will return false.
     */
    inline bool hasU8PSName2 () const;

    /**
     * Returns the value of the member "u8PSName2".
     *
     * .
     *
     * @return The value of the field "u8PSName2"
     */
    inline uint8 getU8PSName2 () const;

    /**
     * Sets the value of the member "u8PSName2".
     *
     * .
     *
     * @param u8PSName2 The value which will be set
     */
    inline void setU8PSName2 (uint8 u8PSName2_);

    // API of field "u8PSName3"

    static const int kU8PSName3 = 15;

    /**
     * Clears the field "u8PSName3".
     *
     * The field will be set to its default value. The hasU8PSName3()
     * method will return false.
     */
    inline void clearU8PSName3();

    /**
     * Checks whether the field "u8PSName3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName3()). Otherwise it will return false.
     */
    inline bool hasU8PSName3 () const;

    /**
     * Returns the value of the member "u8PSName3".
     *
     * .
     *
     * @return The value of the field "u8PSName3"
     */
    inline uint8 getU8PSName3 () const;

    /**
     * Sets the value of the member "u8PSName3".
     *
     * .
     *
     * @param u8PSName3 The value which will be set
     */
    inline void setU8PSName3 (uint8 u8PSName3_);

    // API of field "u8PSName4"

    static const int kU8PSName4 = 16;

    /**
     * Clears the field "u8PSName4".
     *
     * The field will be set to its default value. The hasU8PSName4()
     * method will return false.
     */
    inline void clearU8PSName4();

    /**
     * Checks whether the field "u8PSName4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName4()). Otherwise it will return false.
     */
    inline bool hasU8PSName4 () const;

    /**
     * Returns the value of the member "u8PSName4".
     *
     * .
     *
     * @return The value of the field "u8PSName4"
     */
    inline uint8 getU8PSName4 () const;

    /**
     * Sets the value of the member "u8PSName4".
     *
     * .
     *
     * @param u8PSName4 The value which will be set
     */
    inline void setU8PSName4 (uint8 u8PSName4_);

    // API of field "u8PSName5"

    static const int kU8PSName5 = 17;

    /**
     * Clears the field "u8PSName5".
     *
     * The field will be set to its default value. The hasU8PSName5()
     * method will return false.
     */
    inline void clearU8PSName5();

    /**
     * Checks whether the field "u8PSName5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName5()). Otherwise it will return false.
     */
    inline bool hasU8PSName5 () const;

    /**
     * Returns the value of the member "u8PSName5".
     *
     * .
     *
     * @return The value of the field "u8PSName5"
     */
    inline uint8 getU8PSName5 () const;

    /**
     * Sets the value of the member "u8PSName5".
     *
     * .
     *
     * @param u8PSName5 The value which will be set
     */
    inline void setU8PSName5 (uint8 u8PSName5_);

    // API of field "u8PSName6"

    static const int kU8PSName6 = 18;

    /**
     * Clears the field "u8PSName6".
     *
     * The field will be set to its default value. The hasU8PSName6()
     * method will return false.
     */
    inline void clearU8PSName6();

    /**
     * Checks whether the field "u8PSName6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName6()). Otherwise it will return false.
     */
    inline bool hasU8PSName6 () const;

    /**
     * Returns the value of the member "u8PSName6".
     *
     * .
     *
     * @return The value of the field "u8PSName6"
     */
    inline uint8 getU8PSName6 () const;

    /**
     * Sets the value of the member "u8PSName6".
     *
     * .
     *
     * @param u8PSName6 The value which will be set
     */
    inline void setU8PSName6 (uint8 u8PSName6_);

    // API of field "u8PSName7"

    static const int kU8PSName7 = 19;

    /**
     * Clears the field "u8PSName7".
     *
     * The field will be set to its default value. The hasU8PSName7()
     * method will return false.
     */
    inline void clearU8PSName7();

    /**
     * Checks whether the field "u8PSName7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName7()). Otherwise it will return false.
     */
    inline bool hasU8PSName7 () const;

    /**
     * Returns the value of the member "u8PSName7".
     *
     * .
     *
     * @return The value of the field "u8PSName7"
     */
    inline uint8 getU8PSName7 () const;

    /**
     * Sets the value of the member "u8PSName7".
     *
     * .
     *
     * @param u8PSName7 The value which will be set
     */
    inline void setU8PSName7 (uint8 u8PSName7_);

    // API of field "u8PSName8"

    static const int kU8PSName8 = 20;

    /**
     * Clears the field "u8PSName8".
     *
     * The field will be set to its default value. The hasU8PSName8()
     * method will return false.
     */
    inline void clearU8PSName8();

    /**
     * Checks whether the field "u8PSName8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PSName8()). Otherwise it will return false.
     */
    inline bool hasU8PSName8 () const;

    /**
     * Returns the value of the member "u8PSName8".
     *
     * .
     *
     * @return The value of the field "u8PSName8"
     */
    inline uint8 getU8PSName8 () const;

    /**
     * Sets the value of the member "u8PSName8".
     *
     * .
     *
     * @param u8PSName8 The value which will be set
     */
    inline void setU8PSName8 (uint8 u8PSName8_);

    // API of field "sPSName"

    static const int kSPSName = 21;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPSName"
     */
    inline ::std::string* releaseSPSName();

    /**
     * Replace the field "sPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPSName (::std::string* sPSName_);

    // API of field "u8IFState"

    static const int kU8IFState = 22;

    /**
     * Clears the field "u8IFState".
     *
     * The field will be set to its default value. The hasU8IFState()
     * method will return false.
     */
    inline void clearU8IFState();

    /**
     * Checks whether the field "u8IFState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8IFState()). Otherwise it will return false.
     */
    inline bool hasU8IFState () const;

    /**
     * Returns the value of the member "u8IFState".
     *
     * OFF     (0x00),
     * ON      (0x01),
     * UNKNOWN (0x02).
     *
     * @return The value of the field "u8IFState"
     */
    inline T_e8_Tun_IfState getU8IFState () const;

    /**
     * Sets the value of the member "u8IFState".
     *
     * OFF     (0x00),
     * ON      (0x01),
     * UNKNOWN (0x02).
     *
     * @param u8IFState The value which will be set
     */
    inline void setU8IFState (T_e8_Tun_IfState u8IFState_);

    // API of field "u8ChannelSeparation"

    static const int kU8ChannelSeparation = 23;

    /**
     * Clears the field "u8ChannelSeparation".
     *
     * The field will be set to its default value. The hasU8ChannelSeparation()
     * method will return false.
     */
    inline void clearU8ChannelSeparation();

    /**
     * Checks whether the field "u8ChannelSeparation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChannelSeparation()). Otherwise it will return false.
     */
    inline bool hasU8ChannelSeparation () const;

    /**
     * Returns the value of the member "u8ChannelSeparation".
     *
     * 0x00 - 0xff.
     *
     * @return The value of the field "u8ChannelSeparation"
     */
    inline uint8 getU8ChannelSeparation () const;

    /**
     * Sets the value of the member "u8ChannelSeparation".
     *
     * 0x00 - 0xff.
     *
     * @param u8ChannelSeparation The value which will be set
     */
    inline void setU8ChannelSeparation (uint8 u8ChannelSeparation_);

    // API of field "u8Hub"

    static const int kU8Hub = 24;

    /**
     * Clears the field "u8Hub".
     *
     * The field will be set to its default value. The hasU8Hub()
     * method will return false.
     */
    inline void clearU8Hub();

    /**
     * Checks whether the field "u8Hub" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hub()). Otherwise it will return false.
     */
    inline bool hasU8Hub () const;

    /**
     * Returns the value of the member "u8Hub".
     *
     * 0x00 - 0xff.
     *
     * @return The value of the field "u8Hub"
     */
    inline uint8 getU8Hub () const;

    /**
     * Sets the value of the member "u8Hub".
     *
     * 0x00 - 0xff.
     *
     * @param u8Hub The value which will be set
     */
    inline void setU8Hub (uint8 u8Hub_);

    // API of field "u8RdsErrorRate"

    static const int kU8RdsErrorRate = 25;

    /**
     * Clears the field "u8RdsErrorRate".
     *
     * The field will be set to its default value. The hasU8RdsErrorRate()
     * method will return false.
     */
    inline void clearU8RdsErrorRate();

    /**
     * Checks whether the field "u8RdsErrorRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RdsErrorRate()). Otherwise it will return false.
     */
    inline bool hasU8RdsErrorRate () const;

    /**
     * Returns the value of the member "u8RdsErrorRate".
     *
     * 0x00 - 0x64.
     *
     * @return The value of the field "u8RdsErrorRate"
     */
    inline uint8 getU8RdsErrorRate () const;

    /**
     * Sets the value of the member "u8RdsErrorRate".
     *
     * 0x00 - 0x64.
     *
     * @param u8RdsErrorRate The value which will be set
     */
    inline void setU8RdsErrorRate (uint8 u8RdsErrorRate_);

    static const T_TunerTestModeData &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u8AdditionalInfo ();

    inline void clear_has_u8AdditionalInfo ();

    inline void set_has_u32AFFrequency ();

    inline void clear_has_u32AFFrequency ();

    inline void set_has_u32PI ();

    inline void clear_has_u32PI ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    inline void set_has_u8Fieldstrength ();

    inline void clear_has_u8Fieldstrength ();

    inline void set_has_u8Multipath ();

    inline void clear_has_u8Multipath ();

    inline void set_has_u8Neighbour ();

    inline void clear_has_u8Neighbour ();

    inline void set_has_u8AFListLength ();

    inline void clear_has_u8AFListLength ();

    inline void set_has_u8TestmodeBits ();

    inline void clear_has_u8TestmodeBits ();

    inline void set_has_u8TMCStationCount ();

    inline void clear_has_u8TMCStationCount ();

    inline void set_has_u8TMCGroupState ();

    inline void clear_has_u8TMCGroupState ();

    inline void set_has_u8AntennaState ();

    inline void clear_has_u8AntennaState ();

    inline void set_has_u8PSName1 ();

    inline void clear_has_u8PSName1 ();

    inline void set_has_u8PSName2 ();

    inline void clear_has_u8PSName2 ();

    inline void set_has_u8PSName3 ();

    inline void clear_has_u8PSName3 ();

    inline void set_has_u8PSName4 ();

    inline void clear_has_u8PSName4 ();

    inline void set_has_u8PSName5 ();

    inline void clear_has_u8PSName5 ();

    inline void set_has_u8PSName6 ();

    inline void clear_has_u8PSName6 ();

    inline void set_has_u8PSName7 ();

    inline void clear_has_u8PSName7 ();

    inline void set_has_u8PSName8 ();

    inline void clear_has_u8PSName8 ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    inline void set_has_u8IFState ();

    inline void clear_has_u8IFState ();

    inline void set_has_u8ChannelSeparation ();

    inline void clear_has_u8ChannelSeparation ();

    inline void set_has_u8Hub ();

    inline void clear_has_u8Hub ();

    inline void set_has_u8RdsErrorRate ();

    inline void clear_has_u8RdsErrorRate ();

    uint32 _has_bits_[ (26 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    T_e8_Tun_AdditionalInfo _u8AdditionalInfo;

    uint32 _u32AFFrequency;

    uint32 _u32PI;

    uint8 _u8Quality;

    uint8 _u8Fieldstrength;

    uint8 _u8Multipath;

    uint8 _u8Neighbour;

    uint8 _u8AFListLength;

    T_b8_Tun_TestmodeBits* _u8TestmodeBits;

    uint8 _u8TMCStationCount;

    T_e8_Tun_TMCGroupState _u8TMCGroupState;

    T_e8_Tun_AntennaState _u8AntennaState;

    uint8 _u8PSName1;

    uint8 _u8PSName2;

    uint8 _u8PSName3;

    uint8 _u8PSName4;

    uint8 _u8PSName5;

    uint8 _u8PSName6;

    uint8 _u8PSName7;

    uint8 _u8PSName8;

    ::std::string* _sPSName;

    T_e8_Tun_IfState _u8IFState;

    uint8 _u8ChannelSeparation;

    uint8 _u8Hub;

    uint8 _u8RdsErrorRate;

};

/**
 * Select list element Data
 */
class T_Sel_List_Elem {
public:

    /**
     * Default constructor
     */
    inline  T_Sel_List_Elem ();

    /**
     * Copy constructor
     */
    inline  T_Sel_List_Elem (const T_Sel_List_Elem &rhs);

    /**
     * All fields constructor
     */
    inline  T_Sel_List_Elem (T_e8_Tun_TunerHeader u8TunerHeader_, T_e8_Tun_ConfigListID eConfigListID_, uint32 u32Frequency_, uint16 u16PICode_, uint8 u8ListElementID_, T_e8_Tun_ListType u8Listtype_, uint32 u32HDStnID_DRMSrvID_, T_e8_Tun_ModulationType e8ModulationType_);

    /**
     * Destructor
     */
    inline  ~T_Sel_List_Elem();

    /**
     * Assignment operator
     */
    inline T_Sel_List_Elem& operator = (const T_Sel_List_Elem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Sel_List_Elem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Sel_List_Elem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Sel_List_Elem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Sel_List_Elem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * This element describes the id of the Tuner to be put into
     * foreground or Background.
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * This element describes the id of the Tuner to be put into
     * foreground or Background.
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "eConfigListID"

    static const int kEConfigListID = 1;

    /**
     * Clears the field "eConfigListID".
     *
     * The field will be set to its default value. The hasEConfigListID()
     * method will return false.
     */
    inline void clearEConfigListID();

    /**
     * Checks whether the field "eConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEConfigListID()). Otherwise it will return false.
     */
    inline bool hasEConfigListID () const;

    /**
     * Returns the value of the member "eConfigListID".
     *
     * Config List ID
     *
     * @return The value of the field "eConfigListID"
     */
    inline T_e8_Tun_ConfigListID getEConfigListID () const;

    /**
     * Sets the value of the member "eConfigListID".
     *
     * Config List ID
     *
     * @param eConfigListID The value which will be set
     */
    inline void setEConfigListID (T_e8_Tun_ConfigListID eConfigListID_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 2;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency of selected element
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency of selected element
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u16PICode"

    static const int kU16PICode = 3;

    /**
     * Clears the field "u16PICode".
     *
     * The field will be set to its default value. The hasU16PICode()
     * method will return false.
     */
    inline void clearU16PICode();

    /**
     * Checks whether the field "u16PICode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PICode()). Otherwise it will return false.
     */
    inline bool hasU16PICode () const;

    /**
     * Returns the value of the member "u16PICode".
     *
     * PI Code of selected element
     *
     * @return The value of the field "u16PICode"
     */
    inline uint16 getU16PICode () const;

    /**
     * Sets the value of the member "u16PICode".
     *
     * PI Code of selected element
     *
     * @param u16PICode The value which will be set
     */
    inline void setU16PICode (uint16 u16PICode_);

    // API of field "u8ListElementID"

    static const int kU8ListElementID = 4;

    /**
     * Clears the field "u8ListElementID".
     *
     * The field will be set to its default value. The hasU8ListElementID()
     * method will return false.
     */
    inline void clearU8ListElementID();

    /**
     * Checks whether the field "u8ListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ListElementID()). Otherwise it will return false.
     */
    inline bool hasU8ListElementID () const;

    /**
     * Returns the value of the member "u8ListElementID".
     *
     * One of the element from maximum no of elements can be selected.But the maximum number varies from project to project.
     *
     * @return The value of the field "u8ListElementID"
     */
    inline uint8 getU8ListElementID () const;

    /**
     * Sets the value of the member "u8ListElementID".
     *
     * One of the element from maximum no of elements can be selected.But the maximum number varies from project to project.
     *
     * @param u8ListElementID The value which will be set
     */
    inline void setU8ListElementID (uint8 u8ListElementID_);

    // API of field "u8Listtype"

    static const int kU8Listtype = 5;

    /**
     * Clears the field "u8Listtype".
     *
     * The field will be set to its default value. The hasU8Listtype()
     * method will return false.
     */
    inline void clearU8Listtype();

    /**
     * Checks whether the field "u8Listtype" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Listtype()). Otherwise it will return false.
     */
    inline bool hasU8Listtype () const;

    /**
     * Returns the value of the member "u8Listtype".
     *
     * TUN_LIST_TYPE_STATIC      (0x00)
     * TUN_LIST_TYPE_CONFIG      (0x01).
     *
     * @return The value of the field "u8Listtype"
     */
    inline T_e8_Tun_ListType getU8Listtype () const;

    /**
     * Sets the value of the member "u8Listtype".
     *
     * TUN_LIST_TYPE_STATIC      (0x00)
     * TUN_LIST_TYPE_CONFIG      (0x01).
     *
     * @param u8Listtype The value which will be set
     */
    inline void setU8Listtype (T_e8_Tun_ListType u8Listtype_);

    // API of field "u32HDStnID_DRMSrvID"

    static const int kU32HDStnID_DRMSrvID = 6;

    /**
     * Clears the field "u32HDStnID_DRMSrvID".
     *
     * The field will be set to its default value. The hasU32HDStnID_DRMSrvID()
     * method will return false.
     */
    inline void clearU32HDStnID_DRMSrvID();

    /**
     * Checks whether the field "u32HDStnID_DRMSrvID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStnID_DRMSrvID()). Otherwise it will return false.
     */
    inline bool hasU32HDStnID_DRMSrvID () const;

    /**
     * Returns the value of the member "u32HDStnID_DRMSrvID".
     *
     * PI Code of selected element
     *
     * @return The value of the field "u32HDStnID_DRMSrvID"
     */
    inline uint32 getU32HDStnID_DRMSrvID () const;

    /**
     * Sets the value of the member "u32HDStnID_DRMSrvID".
     *
     * PI Code of selected element
     *
     * @param u32HDStnID_DRMSrvID The value which will be set
     */
    inline void setU32HDStnID_DRMSrvID (uint32 u32HDStnID_DRMSrvID_);

    // API of field "e8ModulationType"

    static const int kE8ModulationType = 7;

    /**
     * Clears the field "e8ModulationType".
     *
     * The field will be set to its default value. The hasE8ModulationType()
     * method will return false.
     */
    inline void clearE8ModulationType();

    /**
     * Checks whether the field "e8ModulationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ModulationType()). Otherwise it will return false.
     */
    inline bool hasE8ModulationType () const;

    /**
     * Returns the value of the member "e8ModulationType".
     *
     * Modulation type (FMAM ANALOG/HD/DRM) of selected element
     *
     * @return The value of the field "e8ModulationType"
     */
    inline T_e8_Tun_ModulationType getE8ModulationType () const;

    /**
     * Sets the value of the member "e8ModulationType".
     *
     * Modulation type (FMAM ANALOG/HD/DRM) of selected element
     *
     * @param e8ModulationType The value which will be set
     */
    inline void setE8ModulationType (T_e8_Tun_ModulationType e8ModulationType_);

    static const T_Sel_List_Elem &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_eConfigListID ();

    inline void clear_has_eConfigListID ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u16PICode ();

    inline void clear_has_u16PICode ();

    inline void set_has_u8ListElementID ();

    inline void clear_has_u8ListElementID ();

    inline void set_has_u8Listtype ();

    inline void clear_has_u8Listtype ();

    inline void set_has_u32HDStnID_DRMSrvID ();

    inline void clear_has_u32HDStnID_DRMSrvID ();

    inline void set_has_e8ModulationType ();

    inline void clear_has_e8ModulationType ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    T_e8_Tun_ConfigListID _eConfigListID;

    uint32 _u32Frequency;

    uint16 _u16PICode;

    uint8 _u8ListElementID;

    T_e8_Tun_ListType _u8Listtype;

    uint32 _u32HDStnID_DRMSrvID;

    T_e8_Tun_ModulationType _e8ModulationType;

};

/**
 * Digital filter criteria
 */
class T_b8_Tun_Digital_Filters {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_Digital_Filters ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_Digital_Filters (const T_b8_Tun_Digital_Filters &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_Digital_Filters (bool STATIONLIST_WITHONLY_HDMPS, bool STATIONLIST_WITH_HDMPS_SPS, bool STATIONLIST_WITH_DRM, bool RESERVED_1, bool RESERVED_2, bool RESERVED_3, bool RESERVED_4, bool RESERVED_5);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_Digital_Filters& operator = (const T_b8_Tun_Digital_Filters& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_Digital_Filters& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_Digital_Filters& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_Digital_Filters& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_Digital_Filters& rhs) const;

    /**
     * Sets the value of the member "STATIONLIST_WITHONLY_HDMPS".
     *
     * If the meaning of "STATIONLIST_WITHONLY_HDMPS" isn't clear, then there should be a description here.
     *
     * @param STATIONLIST_WITHONLY_HDMPS The value which will be set
     */
    inline void setSTATIONLIST_WITHONLY_HDMPS (bool STATIONLIST_WITHONLY_HDMPS);

    /**
     * Returns the value of the member "STATIONLIST_WITHONLY_HDMPS".
     *
     * If the meaning of "STATIONLIST_WITHONLY_HDMPS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STATIONLIST_WITHONLY_HDMPS"
     */
    inline bool getSTATIONLIST_WITHONLY_HDMPS () const;

    /**
     * Sets the value of the member "STATIONLIST_WITH_HDMPS_SPS".
     *
     * If the meaning of "STATIONLIST_WITH_HDMPS_SPS" isn't clear, then there should be a description here.
     *
     * @param STATIONLIST_WITH_HDMPS_SPS The value which will be set
     */
    inline void setSTATIONLIST_WITH_HDMPS_SPS (bool STATIONLIST_WITH_HDMPS_SPS);

    /**
     * Returns the value of the member "STATIONLIST_WITH_HDMPS_SPS".
     *
     * If the meaning of "STATIONLIST_WITH_HDMPS_SPS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STATIONLIST_WITH_HDMPS_SPS"
     */
    inline bool getSTATIONLIST_WITH_HDMPS_SPS () const;

    /**
     * Sets the value of the member "STATIONLIST_WITH_DRM".
     *
     * If the meaning of "STATIONLIST_WITH_DRM" isn't clear, then there should be a description here.
     *
     * @param STATIONLIST_WITH_DRM The value which will be set
     */
    inline void setSTATIONLIST_WITH_DRM (bool STATIONLIST_WITH_DRM);

    /**
     * Returns the value of the member "STATIONLIST_WITH_DRM".
     *
     * If the meaning of "STATIONLIST_WITH_DRM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STATIONLIST_WITH_DRM"
     */
    inline bool getSTATIONLIST_WITH_DRM () const;

    /**
     * Sets the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @param RESERVED_1 The value which will be set
     */
    inline void setRESERVED_1 (bool RESERVED_1);

    /**
     * Returns the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_1"
     */
    inline bool getRESERVED_1 () const;

    /**
     * Sets the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @param RESERVED_2 The value which will be set
     */
    inline void setRESERVED_2 (bool RESERVED_2);

    /**
     * Returns the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_2"
     */
    inline bool getRESERVED_2 () const;

    /**
     * Sets the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @param RESERVED_3 The value which will be set
     */
    inline void setRESERVED_3 (bool RESERVED_3);

    /**
     * Returns the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_3"
     */
    inline bool getRESERVED_3 () const;

    /**
     * Sets the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @param RESERVED_4 The value which will be set
     */
    inline void setRESERVED_4 (bool RESERVED_4);

    /**
     * Returns the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_4"
     */
    inline bool getRESERVED_4 () const;

    /**
     * Sets the value of the member "RESERVED_5".
     *
     * If the meaning of "RESERVED_5" isn't clear, then there should be a description here.
     *
     * @param RESERVED_5 The value which will be set
     */
    inline void setRESERVED_5 (bool RESERVED_5);

    /**
     * Returns the value of the member "RESERVED_5".
     *
     * If the meaning of "RESERVED_5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_5"
     */
    inline bool getRESERVED_5 () const;

    static const T_b8_Tun_Digital_Filters &getDefaultInstance();

private:

    bool _STATIONLIST_WITHONLY_HDMPS:1;

    bool _STATIONLIST_WITH_HDMPS_SPS:1;

    bool _STATIONLIST_WITH_DRM:1;

    bool _RESERVED_1:1;

    bool _RESERVED_2:1;

    bool _RESERVED_3:1;

    bool _RESERVED_4:1;

    bool _RESERVED_5:1;

};

/**
 * Filter type used for making the config list.
 */
class T_Tun_MakeConfigList {
public:

    /**
     * Default constructor
     */
    inline  T_Tun_MakeConfigList ();

    /**
     * Copy constructor
     */
    inline  T_Tun_MakeConfigList (const T_Tun_MakeConfigList &rhs);

    /**
     * All fields constructor
     */
    inline  T_Tun_MakeConfigList (T_e8_Tun_ConfigListID eConfigListID_, uint32 u32PTY_, T_e8_Tun_SortingCriteria eSortingCriteria_, const T_b8_Tun_Digital_Filters& u8DigitalFilters_, bool bFrozenList_);

    /**
     * Destructor
     */
    inline  ~T_Tun_MakeConfigList();

    /**
     * Assignment operator
     */
    inline T_Tun_MakeConfigList& operator = (const T_Tun_MakeConfigList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Tun_MakeConfigList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Tun_MakeConfigList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Tun_MakeConfigList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Tun_MakeConfigList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eConfigListID"

    static const int kEConfigListID = 0;

    /**
     * Clears the field "eConfigListID".
     *
     * The field will be set to its default value. The hasEConfigListID()
     * method will return false.
     */
    inline void clearEConfigListID();

    /**
     * Checks whether the field "eConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEConfigListID()). Otherwise it will return false.
     */
    inline bool hasEConfigListID () const;

    /**
     * Returns the value of the member "eConfigListID".
     *
     * Number of configurable list that has to be configured
     *
     * @return The value of the field "eConfigListID"
     */
    inline T_e8_Tun_ConfigListID getEConfigListID () const;

    /**
     * Sets the value of the member "eConfigListID".
     *
     * Number of configurable list that has to be configured
     *
     * @param eConfigListID The value which will be set
     */
    inline void setEConfigListID (T_e8_Tun_ConfigListID eConfigListID_);

    // API of field "u32PTY"

    static const int kU32PTY = 1;

    /**
     * Clears the field "u32PTY".
     *
     * The field will be set to its default value. The hasU32PTY()
     * method will return false.
     */
    inline void clearU32PTY();

    /**
     * Checks whether the field "u32PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PTY()). Otherwise it will return false.
     */
    inline bool hasU32PTY () const;

    /**
     * Returns the value of the member "u32PTY".
     *
     * 0		-	No programme type or undefined
     * 1		-	News
     * 2		-	Current Affairs
     * 3		-	Information
     * 4		-	Sport
     * 5		-	Education
     * 6		-	Drama
     * 7		-	Culture
     * 8		-	Science
     * 9		-	Varied
     * 10	-	Pop Music
     * 11	-	Rock Music
     * 12	-	Easy Listening Music
     * 13	-	Light classical
     * 14	-	Serious classical
     * 15	-	Other Music
     * 16	-	Weather
     * 17	-	Finance
     * 18	-	Childrens programmes
     * 19	-	Social Affairs
     * 20	-	Religion
     * 21	-	Phone In
     * 22	-	Travel
     * 23	-	Leisure
     * 24	-	Jazz Music
     * 25	-	Country Music
     * 26	-	National Music
     * 27	-	Oldies Music
     * 28	-	Folk Music
     * 29	-	Documentary
     * 30	-	Alarm Test
     * 31	-	Alarm
     *
     * @return The value of the field "u32PTY"
     */
    inline uint32 getU32PTY () const;

    /**
     * Sets the value of the member "u32PTY".
     *
     * 0		-	No programme type or undefined
     * 1		-	News
     * 2		-	Current Affairs
     * 3		-	Information
     * 4		-	Sport
     * 5		-	Education
     * 6		-	Drama
     * 7		-	Culture
     * 8		-	Science
     * 9		-	Varied
     * 10	-	Pop Music
     * 11	-	Rock Music
     * 12	-	Easy Listening Music
     * 13	-	Light classical
     * 14	-	Serious classical
     * 15	-	Other Music
     * 16	-	Weather
     * 17	-	Finance
     * 18	-	Childrens programmes
     * 19	-	Social Affairs
     * 20	-	Religion
     * 21	-	Phone In
     * 22	-	Travel
     * 23	-	Leisure
     * 24	-	Jazz Music
     * 25	-	Country Music
     * 26	-	National Music
     * 27	-	Oldies Music
     * 28	-	Folk Music
     * 29	-	Documentary
     * 30	-	Alarm Test
     * 31	-	Alarm
     *
     * @param u32PTY The value which will be set
     */
    inline void setU32PTY (uint32 u32PTY_);

    // API of field "eSortingCriteria"

    static const int kESortingCriteria = 2;

    /**
     * Clears the field "eSortingCriteria".
     *
     * The field will be set to its default value. The hasESortingCriteria()
     * method will return false.
     */
    inline void clearESortingCriteria();

    /**
     * Checks whether the field "eSortingCriteria" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESortingCriteria()). Otherwise it will return false.
     */
    inline bool hasESortingCriteria () const;

    /**
     * Returns the value of the member "eSortingCriteria".
     *
     * SortingCriteria
     *
     * @return The value of the field "eSortingCriteria"
     */
    inline T_e8_Tun_SortingCriteria getESortingCriteria () const;

    /**
     * Sets the value of the member "eSortingCriteria".
     *
     * SortingCriteria
     *
     * @param eSortingCriteria The value which will be set
     */
    inline void setESortingCriteria (T_e8_Tun_SortingCriteria eSortingCriteria_);

    // API of field "u8DigitalFilters"

    static const int kU8DigitalFilters = 3;

    /**
     * Clears the field "u8DigitalFilters".
     *
     * The field will be set to its default value. The hasU8DigitalFilters()
     * method will return false.
     */
    inline void clearU8DigitalFilters();

    /**
     * Checks whether the field "u8DigitalFilters" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DigitalFilters()). Otherwise it will return false.
     */
    inline bool hasU8DigitalFilters () const;

    /**
     * Returns the value of the member "u8DigitalFilters".
     *
     * If the meaning of "u8DigitalFilters" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DigitalFilters"
     */
    inline const T_b8_Tun_Digital_Filters& getU8DigitalFilters () const;

    /**
     * Retrieves the value of the field "u8DigitalFilters" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u8DigitalFilters".
     */
    inline T_b8_Tun_Digital_Filters& getU8DigitalFiltersMutable ();

    /**
     * Sets the value of the member "u8DigitalFilters".
     *
     * If the meaning of "u8DigitalFilters" isn't clear, then there should be a description here.
     *
     * @param u8DigitalFilters The value which will be set
     */
    inline void setU8DigitalFilters (const T_b8_Tun_Digital_Filters& u8DigitalFilters_);

    /**
     * Release the object stored in the field "u8DigitalFilters".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u8DigitalFilters"
     */
    inline T_b8_Tun_Digital_Filters* releaseU8DigitalFilters();

    /**
     * Replace the field "u8DigitalFilters".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU8DigitalFilters (T_b8_Tun_Digital_Filters* u8DigitalFilters_);

    // API of field "bFrozenList"

    static const int kBFrozenList = 4;

    /**
     * Clears the field "bFrozenList".
     *
     * The field will be set to its default value. The hasBFrozenList()
     * method will return false.
     */
    inline void clearBFrozenList();

    /**
     * Checks whether the field "bFrozenList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBFrozenList()). Otherwise it will return false.
     */
    inline bool hasBFrozenList () const;

    /**
     * Returns the value of the member "bFrozenList".
     *
     * Clients that require frozen station list should set this field to true.
     * And all others should set this field to false.
     *
     * @return The value of the field "bFrozenList"
     */
    inline bool getBFrozenList () const;

    /**
     * Sets the value of the member "bFrozenList".
     *
     * Clients that require frozen station list should set this field to true.
     * And all others should set this field to false.
     *
     * @param bFrozenList The value which will be set
     */
    inline void setBFrozenList (bool bFrozenList_);

    static const T_Tun_MakeConfigList &getDefaultInstance();

private:

    inline void set_has_eConfigListID ();

    inline void clear_has_eConfigListID ();

    inline void set_has_u32PTY ();

    inline void clear_has_u32PTY ();

    inline void set_has_eSortingCriteria ();

    inline void clear_has_eSortingCriteria ();

    inline void set_has_u8DigitalFilters ();

    inline void clear_has_u8DigitalFilters ();

    inline void set_has_bFrozenList ();

    inline void clear_has_bFrozenList ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_Tun_ConfigListID _eConfigListID;

    uint32 _u32PTY;

    T_e8_Tun_SortingCriteria _eSortingCriteria;

    T_b8_Tun_Digital_Filters* _u8DigitalFilters;

    bool _bFrozenList;

};

/**
 * Type identifying the encryption type and values of a TMC message
 */
class T_Encryption {
public:

    /**
     * Default constructor
     */
    inline  T_Encryption ();

    /**
     * Copy constructor
     */
    inline  T_Encryption (const T_Encryption &rhs);

    /**
     * All fields constructor
     */
    inline  T_Encryption (bool Encrypted_, uint8 Encid_, uint8 TestBits_);

    /**
     * Destructor
     */
    inline  ~T_Encryption();

    /**
     * Assignment operator
     */
    inline T_Encryption& operator = (const T_Encryption& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Encryption& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Encryption& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Encryption& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Encryption& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Encrypted"

    static const int kEncrypted = 0;

    /**
     * Clears the field "Encrypted".
     *
     * The field will be set to its default value. The hasEncrypted()
     * method will return false.
     */
    inline void clearEncrypted();

    /**
     * Checks whether the field "Encrypted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncrypted()). Otherwise it will return false.
     */
    inline bool hasEncrypted () const;

    /**
     * Returns the value of the member "Encrypted".
     *
     * <p>Encryped = "FALSE": Message not encrypted</p>
     * <p>Encrypted = "TRUE": Message encrypted</p>
     *
     * @return The value of the field "Encrypted"
     */
    inline bool getEncrypted () const;

    /**
     * Sets the value of the member "Encrypted".
     *
     * <p>Encryped = "FALSE": Message not encrypted</p>
     * <p>Encrypted = "TRUE": Message encrypted</p>
     *
     * @param Encrypted The value which will be set
     */
    inline void setEncrypted (bool Encrypted_);

    // API of field "Encid"

    static const int kEncid = 1;

    /**
     * Clears the field "Encid".
     *
     * The field will be set to its default value. The hasEncid()
     * method will return false.
     */
    inline void clearEncid();

    /**
     * Checks whether the field "Encid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncid()). Otherwise it will return false.
     */
    inline bool hasEncid () const;

    /**
     * Returns the value of the member "Encid".
     *
     * Identifying the index of the encryption value in the used service
     * key table (EPVS), 0 if message not encrypted
     *
     * @return The value of the field "Encid"
     */
    inline uint8 getEncid () const;

    /**
     * Sets the value of the member "Encid".
     *
     * Identifying the index of the encryption value in the used service
     * key table (EPVS), 0 if message not encrypted
     *
     * @param Encid The value which will be set
     */
    inline void setEncid (uint8 Encid_);

    // API of field "TestBits"

    static const int kTestBits = 2;

    /**
     * Clears the field "TestBits".
     *
     * The field will be set to its default value. The hasTestBits()
     * method will return false.
     */
    inline void clearTestBits();

    /**
     * Checks whether the field "TestBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestBits()). Otherwise it will return false.
     */
    inline bool hasTestBits () const;

    /**
     * Returns the value of the member "TestBits".
     *
     * Test bits for encrypted messages, 0 if message not encrypted
     *
     * @return The value of the field "TestBits"
     */
    inline uint8 getTestBits () const;

    /**
     * Sets the value of the member "TestBits".
     *
     * Test bits for encrypted messages, 0 if message not encrypted
     *
     * @param TestBits The value which will be set
     */
    inline void setTestBits (uint8 TestBits_);

    static const T_Encryption &getDefaultInstance();

private:

    inline void set_has_Encrypted ();

    inline void clear_has_Encrypted ();

    inline void set_has_Encid ();

    inline void clear_has_Encid ();

    inline void set_has_TestBits ();

    inline void clear_has_TestBits ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _Encrypted;

    uint8 _Encid;

    uint8 _TestBits;

};

/**
 * Type identifying the (tuner) source of a TMC message
 */
class T_MsgSource {
public:

    /**
     * Default constructor
     */
    inline  T_MsgSource ();

    /**
     * Copy constructor
     */
    inline  T_MsgSource (const T_MsgSource &rhs);

    /**
     * All fields constructor
     */
    inline  T_MsgSource (T_e8_TmcMediumType MediumTypeId_, uint8 Number_);

    /**
     * Destructor
     */
    inline  ~T_MsgSource();

    /**
     * Assignment operator
     */
    inline T_MsgSource& operator = (const T_MsgSource& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MsgSource& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MsgSource& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MsgSource& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MsgSource& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediumTypeId"

    static const int kMediumTypeId = 0;

    /**
     * Clears the field "MediumTypeId".
     *
     * The field will be set to its default value. The hasMediumTypeId()
     * method will return false.
     */
    inline void clearMediumTypeId();

    /**
     * Checks whether the field "MediumTypeId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediumTypeId()). Otherwise it will return false.
     */
    inline bool hasMediumTypeId () const;

    /**
     * Returns the value of the member "MediumTypeId".
     *
     * Unique ID specifying the medium the message was transmitted with
     *
     * @return The value of the field "MediumTypeId"
     */
    inline T_e8_TmcMediumType getMediumTypeId () const;

    /**
     * Sets the value of the member "MediumTypeId".
     *
     * Unique ID specifying the medium the message was transmitted with
     *
     * @param MediumTypeId The value which will be set
     */
    inline void setMediumTypeId (T_e8_TmcMediumType MediumTypeId_);

    // API of field "Number"

    static const int kNumber = 1;

    /**
     * Clears the field "Number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "Number".
     *
     * Identifies one of n sources of the same medium type
     * (e.g. for two FM tuners)
     *
     * @return The value of the field "Number"
     */
    inline uint8 getNumber () const;

    /**
     * Sets the value of the member "Number".
     *
     * Identifies one of n sources of the same medium type
     * (e.g. for two FM tuners)
     *
     * @param Number The value which will be set
     */
    inline void setNumber (uint8 Number_);

    static const T_MsgSource &getDefaultInstance();

private:

    inline void set_has_MediumTypeId ();

    inline void clear_has_MediumTypeId ();

    inline void set_has_Number ();

    inline void clear_has_Number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_TmcMediumType _MediumTypeId;

    uint8 _Number;

};

/**
 * This structure gives RDBID details, sent from TIMA.
 */
class T_Tun_RDBID_Value {
public:

    /**
     * Default constructor
     */
    inline  T_Tun_RDBID_Value ();

    /**
     * Copy constructor
     */
    inline  T_Tun_RDBID_Value (const T_Tun_RDBID_Value &rhs);

    /**
     * All fields constructor
     */
    inline  T_Tun_RDBID_Value (uint8 u8RdbidCC_, uint8 u8RdbidLTN_, uint8 u8RdbidSID_, bool bEncFlag_);

    /**
     * Destructor
     */
    inline  ~T_Tun_RDBID_Value();

    /**
     * Assignment operator
     */
    inline T_Tun_RDBID_Value& operator = (const T_Tun_RDBID_Value& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Tun_RDBID_Value& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Tun_RDBID_Value& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Tun_RDBID_Value& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Tun_RDBID_Value& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8RdbidCC"

    static const int kU8RdbidCC = 0;

    /**
     * Clears the field "u8RdbidCC".
     *
     * The field will be set to its default value. The hasU8RdbidCC()
     * method will return false.
     */
    inline void clearU8RdbidCC();

    /**
     * Checks whether the field "u8RdbidCC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RdbidCC()). Otherwise it will return false.
     */
    inline bool hasU8RdbidCC () const;

    /**
     * Returns the value of the member "u8RdbidCC".
     *
     * 0-n,Value of n is 0 to 0x0F
     *
     * @return The value of the field "u8RdbidCC"
     */
    inline uint8 getU8RdbidCC () const;

    /**
     * Sets the value of the member "u8RdbidCC".
     *
     * 0-n,Value of n is 0 to 0x0F
     *
     * @param u8RdbidCC The value which will be set
     */
    inline void setU8RdbidCC (uint8 u8RdbidCC_);

    // API of field "u8RdbidLTN"

    static const int kU8RdbidLTN = 1;

    /**
     * Clears the field "u8RdbidLTN".
     *
     * The field will be set to its default value. The hasU8RdbidLTN()
     * method will return false.
     */
    inline void clearU8RdbidLTN();

    /**
     * Checks whether the field "u8RdbidLTN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RdbidLTN()). Otherwise it will return false.
     */
    inline bool hasU8RdbidLTN () const;

    /**
     * Returns the value of the member "u8RdbidLTN".
     *
     * 0-n,Value of n is 0 to 0x3F
     *
     * @return The value of the field "u8RdbidLTN"
     */
    inline uint8 getU8RdbidLTN () const;

    /**
     * Sets the value of the member "u8RdbidLTN".
     *
     * 0-n,Value of n is 0 to 0x3F
     *
     * @param u8RdbidLTN The value which will be set
     */
    inline void setU8RdbidLTN (uint8 u8RdbidLTN_);

    // API of field "u8RdbidSID"

    static const int kU8RdbidSID = 2;

    /**
     * Clears the field "u8RdbidSID".
     *
     * The field will be set to its default value. The hasU8RdbidSID()
     * method will return false.
     */
    inline void clearU8RdbidSID();

    /**
     * Checks whether the field "u8RdbidSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RdbidSID()). Otherwise it will return false.
     */
    inline bool hasU8RdbidSID () const;

    /**
     * Returns the value of the member "u8RdbidSID".
     *
     * 0-n,Value of n is 0 to 0x3F
     *
     * @return The value of the field "u8RdbidSID"
     */
    inline uint8 getU8RdbidSID () const;

    /**
     * Sets the value of the member "u8RdbidSID".
     *
     * 0-n,Value of n is 0 to 0x3F
     *
     * @param u8RdbidSID The value which will be set
     */
    inline void setU8RdbidSID (uint8 u8RdbidSID_);

    // API of field "bEncFlag"

    static const int kBEncFlag = 3;

    /**
     * Clears the field "bEncFlag".
     *
     * The field will be set to its default value. The hasBEncFlag()
     * method will return false.
     */
    inline void clearBEncFlag();

    /**
     * Checks whether the field "bEncFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBEncFlag()). Otherwise it will return false.
     */
    inline bool hasBEncFlag () const;

    /**
     * Returns the value of the member "bEncFlag".
     *
     * <p>Encryped = "FALSE": Message not encrypted</p>
     * <p>Encrypted = "TRUE": Message encrypted</p>
     *
     * @return The value of the field "bEncFlag"
     */
    inline bool getBEncFlag () const;

    /**
     * Sets the value of the member "bEncFlag".
     *
     * <p>Encryped = "FALSE": Message not encrypted</p>
     * <p>Encrypted = "TRUE": Message encrypted</p>
     *
     * @param bEncFlag The value which will be set
     */
    inline void setBEncFlag (bool bEncFlag_);

    static const T_Tun_RDBID_Value &getDefaultInstance();

private:

    inline void set_has_u8RdbidCC ();

    inline void clear_has_u8RdbidCC ();

    inline void set_has_u8RdbidLTN ();

    inline void clear_has_u8RdbidLTN ();

    inline void set_has_u8RdbidSID ();

    inline void clear_has_u8RdbidSID ();

    inline void set_has_bEncFlag ();

    inline void clear_has_bEncFlag ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _u8RdbidCC;

    uint8 _u8RdbidLTN;

    uint8 _u8RdbidSID;

    bool _bEncFlag;

};

/**
 * ID of regional database (containig service-ID and identifier for encrypted
 * TMC)
 */
class T_TunerRdbId {
public:

    /**
     * Default constructor
     */
    inline  T_TunerRdbId ();

    /**
     * Copy constructor
     */
    inline  T_TunerRdbId (const T_TunerRdbId &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerRdbId (uint8 TMCCountryCode_, uint8 TableNo_, uint8 ServiceID_, bool Encrypted_);

    /**
     * Destructor
     */
    inline  ~T_TunerRdbId();

    /**
     * Assignment operator
     */
    inline T_TunerRdbId& operator = (const T_TunerRdbId& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerRdbId& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerRdbId& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerRdbId& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerRdbId& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TMCCountryCode"

    static const int kTMCCountryCode = 0;

    /**
     * Clears the field "TMCCountryCode".
     *
     * The field will be set to its default value. The hasTMCCountryCode()
     * method will return false.
     */
    inline void clearTMCCountryCode();

    /**
     * Checks whether the field "TMCCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTMCCountryCode()). Otherwise it will return false.
     */
    inline bool hasTMCCountryCode () const;

    /**
     * Returns the value of the member "TMCCountryCode".
     *
     * Country code
     *
     * @return The value of the field "TMCCountryCode"
     */
    inline uint8 getTMCCountryCode () const;

    /**
     * Sets the value of the member "TMCCountryCode".
     *
     * Country code
     *
     * @param TMCCountryCode The value which will be set
     */
    inline void setTMCCountryCode (uint8 TMCCountryCode_);

    // API of field "TableNo"

    static const int kTableNo = 1;

    /**
     * Clears the field "TableNo".
     *
     * The field will be set to its default value. The hasTableNo()
     * method will return false.
     */
    inline void clearTableNo();

    /**
     * Checks whether the field "TableNo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTableNo()). Otherwise it will return false.
     */
    inline bool hasTableNo () const;

    /**
     * Returns the value of the member "TableNo".
     *
     * Location table number
     *
     * @return The value of the field "TableNo"
     */
    inline uint8 getTableNo () const;

    /**
     * Sets the value of the member "TableNo".
     *
     * Location table number
     *
     * @param TableNo The value which will be set
     */
    inline void setTableNo (uint8 TableNo_);

    // API of field "ServiceID"

    static const int kServiceID = 2;

    /**
     * Clears the field "ServiceID".
     *
     * The field will be set to its default value. The hasServiceID()
     * method will return false.
     */
    inline void clearServiceID();

    /**
     * Checks whether the field "ServiceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceID()). Otherwise it will return false.
     */
    inline bool hasServiceID () const;

    /**
     * Returns the value of the member "ServiceID".
     *
     * Service identifier (0 means do not care)
     *
     * @return The value of the field "ServiceID"
     */
    inline uint8 getServiceID () const;

    /**
     * Sets the value of the member "ServiceID".
     *
     * Service identifier (0 means do not care)
     *
     * @param ServiceID The value which will be set
     */
    inline void setServiceID (uint8 ServiceID_);

    // API of field "Encrypted"

    static const int kEncrypted = 3;

    /**
     * Clears the field "Encrypted".
     *
     * The field will be set to its default value. The hasEncrypted()
     * method will return false.
     */
    inline void clearEncrypted();

    /**
     * Checks whether the field "Encrypted" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncrypted()). Otherwise it will return false.
     */
    inline bool hasEncrypted () const;

    /**
     * Returns the value of the member "Encrypted".
     *
     * <p>Encryped = "FALSE": Message not encrypted</p>
     * <p>Encrypted = "TRUE": Message encrypted</p>
     *
     * @return The value of the field "Encrypted"
     */
    inline bool getEncrypted () const;

    /**
     * Sets the value of the member "Encrypted".
     *
     * <p>Encryped = "FALSE": Message not encrypted</p>
     * <p>Encrypted = "TRUE": Message encrypted</p>
     *
     * @param Encrypted The value which will be set
     */
    inline void setEncrypted (bool Encrypted_);

    static const T_TunerRdbId &getDefaultInstance();

private:

    inline void set_has_TMCCountryCode ();

    inline void clear_has_TMCCountryCode ();

    inline void set_has_TableNo ();

    inline void clear_has_TableNo ();

    inline void set_has_ServiceID ();

    inline void clear_has_ServiceID ();

    inline void set_has_Encrypted ();

    inline void clear_has_Encrypted ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint8 _TMCCountryCode;

    uint8 _TableNo;

    uint8 _ServiceID;

    bool _Encrypted;

};

/**
 * This structure gives RDBID details, sent from TIMA.
 */
class T_TunerGetDataTMC {
public:

    /**
     * Default constructor
     */
    inline  T_TunerGetDataTMC ();

    /**
     * Copy constructor
     */
    inline  T_TunerGetDataTMC (const T_TunerGetDataTMC &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerGetDataTMC (T_e8_Tun_TunerHeader u8TunerHeader_, uint16 u16TMCData1_, uint16 u16TMCData2_, uint16 u16TMCData3_, uint16 u16TMCData4_);

    /**
     * Destructor
     */
    inline  ~T_TunerGetDataTMC();

    /**
     * Assignment operator
     */
    inline T_TunerGetDataTMC& operator = (const T_TunerGetDataTMC& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerGetDataTMC& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerGetDataTMC& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerGetDataTMC& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerGetDataTMC& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * This element describes which tuner is used foreground or Background.
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * This element describes which tuner is used foreground or Background.
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u16TMCData1"

    static const int kU16TMCData1 = 1;

    /**
     * Clears the field "u16TMCData1".
     *
     * The field will be set to its default value. The hasU16TMCData1()
     * method will return false.
     */
    inline void clearU16TMCData1();

    /**
     * Checks whether the field "u16TMCData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TMCData1()). Otherwise it will return false.
     */
    inline bool hasU16TMCData1 () const;

    /**
     * Returns the value of the member "u16TMCData1".
     *
     * 1st packet of TMC data, PI Code
     *
     * @return The value of the field "u16TMCData1"
     */
    inline uint16 getU16TMCData1 () const;

    /**
     * Sets the value of the member "u16TMCData1".
     *
     * 1st packet of TMC data, PI Code
     *
     * @param u16TMCData1 The value which will be set
     */
    inline void setU16TMCData1 (uint16 u16TMCData1_);

    // API of field "u16TMCData2"

    static const int kU16TMCData2 = 2;

    /**
     * Clears the field "u16TMCData2".
     *
     * The field will be set to its default value. The hasU16TMCData2()
     * method will return false.
     */
    inline void clearU16TMCData2();

    /**
     * Checks whether the field "u16TMCData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TMCData2()). Otherwise it will return false.
     */
    inline bool hasU16TMCData2 () const;

    /**
     * Returns the value of the member "u16TMCData2".
     *
     * 2nd packet of TMC data
     *
     * @return The value of the field "u16TMCData2"
     */
    inline uint16 getU16TMCData2 () const;

    /**
     * Sets the value of the member "u16TMCData2".
     *
     * 2nd packet of TMC data
     *
     * @param u16TMCData2 The value which will be set
     */
    inline void setU16TMCData2 (uint16 u16TMCData2_);

    // API of field "u16TMCData3"

    static const int kU16TMCData3 = 3;

    /**
     * Clears the field "u16TMCData3".
     *
     * The field will be set to its default value. The hasU16TMCData3()
     * method will return false.
     */
    inline void clearU16TMCData3();

    /**
     * Checks whether the field "u16TMCData3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TMCData3()). Otherwise it will return false.
     */
    inline bool hasU16TMCData3 () const;

    /**
     * Returns the value of the member "u16TMCData3".
     *
     * 3rd packet of TMC data
     *
     * @return The value of the field "u16TMCData3"
     */
    inline uint16 getU16TMCData3 () const;

    /**
     * Sets the value of the member "u16TMCData3".
     *
     * 3rd packet of TMC data
     *
     * @param u16TMCData3 The value which will be set
     */
    inline void setU16TMCData3 (uint16 u16TMCData3_);

    // API of field "u16TMCData4"

    static const int kU16TMCData4 = 4;

    /**
     * Clears the field "u16TMCData4".
     *
     * The field will be set to its default value. The hasU16TMCData4()
     * method will return false.
     */
    inline void clearU16TMCData4();

    /**
     * Checks whether the field "u16TMCData4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TMCData4()). Otherwise it will return false.
     */
    inline bool hasU16TMCData4 () const;

    /**
     * Returns the value of the member "u16TMCData4".
     *
     * 4th packet of TMC data
     *
     * @return The value of the field "u16TMCData4"
     */
    inline uint16 getU16TMCData4 () const;

    /**
     * Sets the value of the member "u16TMCData4".
     *
     * 4th packet of TMC data
     *
     * @param u16TMCData4 The value which will be set
     */
    inline void setU16TMCData4 (uint16 u16TMCData4_);

    static const T_TunerGetDataTMC &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u16TMCData1 ();

    inline void clear_has_u16TMCData1 ();

    inline void set_has_u16TMCData2 ();

    inline void clear_has_u16TMCData2 ();

    inline void set_has_u16TMCData3 ();

    inline void clear_has_u16TMCData3 ();

    inline void set_has_u16TMCData4 ();

    inline void clear_has_u16TMCData4 ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    uint16 _u16TMCData1;

    uint16 _u16TMCData2;

    uint16 _u16TMCData3;

    uint16 _u16TMCData4;

};

/**
 * Type containing all data related to a TMC message
 */
class T_TrafficInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TrafficInfo ();

    /**
     * Copy constructor
     */
    inline  T_TrafficInfo (const T_TrafficInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TrafficInfo (const T_TunerRdbId& RDBId_, int16 ECC_, T_e16_TmcApplicationId ApplicationId_, const ::std::vector< uint8 >& ListOf8AData_, uint16 ProgramID_, const T_Encryption& Encryption_, const T_MsgSource& MsgSource_, const ::std::string& ProgramServiceName_, const ::std::string& ServiceProviderName_);

    /**
     * Destructor
     */
    inline  ~T_TrafficInfo();

    /**
     * Assignment operator
     */
    inline T_TrafficInfo& operator = (const T_TrafficInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TrafficInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TrafficInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TrafficInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TrafficInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RDBId"

    static const int kRDBId = 0;

    /**
     * Clears the field "RDBId".
     *
     * The field will be set to its default value. The hasRDBId()
     * method will return false.
     */
    inline void clearRDBId();

    /**
     * Checks whether the field "RDBId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRDBId()). Otherwise it will return false.
     */
    inline bool hasRDBId () const;

    /**
     * Returns the value of the member "RDBId".
     *
     * The Tuner-RDB-ID of this message,
     * containing CC, LTN, SID and Encryption Flag
     *
     * @return The value of the field "RDBId"
     */
    inline const T_TunerRdbId& getRDBId () const;

    /**
     * Retrieves the value of the field "RDBId" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RDBId".
     */
    inline T_TunerRdbId& getRDBIdMutable ();

    /**
     * Sets the value of the member "RDBId".
     *
     * The Tuner-RDB-ID of this message,
     * containing CC, LTN, SID and Encryption Flag
     *
     * @param RDBId The value which will be set
     */
    inline void setRDBId (const T_TunerRdbId& RDBId_);

    /**
     * Release the object stored in the field "RDBId".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "RDBId"
     */
    inline T_TunerRdbId* releaseRDBId();

    /**
     * Replace the field "RDBId".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceRDBId (T_TunerRdbId* RDBId_);

    // API of field "ECC"

    static const int kECC = 1;

    /**
     * Clears the field "ECC".
     *
     * The field will be set to its default value. The hasECC()
     * method will return false.
     */
    inline void clearECC();

    /**
     * Checks whether the field "ECC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setECC()). Otherwise it will return false.
     */
    inline bool hasECC () const;

    /**
     * Returns the value of the member "ECC".
     *
     * Extended country code (-1 means invalid)
     *
     * @return The value of the field "ECC"
     */
    inline int16 getECC () const;

    /**
     * Sets the value of the member "ECC".
     *
     * Extended country code (-1 means invalid)
     *
     * @param ECC The value which will be set
     */
    inline void setECC (int16 ECC_);

    // API of field "ApplicationId"

    static const int kApplicationId = 2;

    /**
     * Clears the field "ApplicationId".
     *
     * The field will be set to its default value. The hasApplicationId()
     * method will return false.
     */
    inline void clearApplicationId();

    /**
     * Checks whether the field "ApplicationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setApplicationId()). Otherwise it will return false.
     */
    inline bool hasApplicationId () const;

    /**
     * Returns the value of the member "ApplicationId".
     *
     * ApplicationID of this message, has to be TMCData (0xCD46)
     * for TMC data messages
     *
     * @return The value of the field "ApplicationId"
     */
    inline T_e16_TmcApplicationId getApplicationId () const;

    /**
     * Sets the value of the member "ApplicationId".
     *
     * ApplicationID of this message, has to be TMCData (0xCD46)
     * for TMC data messages
     *
     * @param ApplicationId The value which will be set
     */
    inline void setApplicationId (T_e16_TmcApplicationId ApplicationId_);

    // API of field "ListOf8AData"

    static const int kListOf8AData = 3;

    /**
     * Clears the field "ListOf8AData".
     *
     * The field will be set to its default value. The hasListOf8AData()
     * method will return false.
     */
    inline void clearListOf8AData();

    /**
     * Checks whether the field "ListOf8AData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setListOf8AData()). Otherwise it will return false.
     */
    inline bool hasListOf8AData () const;

    /**
     * Returns the value of the member "ListOf8AData".
     *
     * List containing up to 25 bytes (up to five 8A groups combined).
     * 8A groups can be combined only for an MGM.
     *
     * @return The value of the field "ListOf8AData"
     */
    inline const ::std::vector< uint8 >& getListOf8AData () const;

    /**
     * Retrieves the value of the field "ListOf8AData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ListOf8AData".
     */
    inline ::std::vector< uint8 >& getListOf8ADataMutable ();

    /**
     * Sets the value of the member "ListOf8AData".
     *
     * List containing up to 25 bytes (up to five 8A groups combined).
     * 8A groups can be combined only for an MGM.
     *
     * @param ListOf8AData The value which will be set
     */
    inline void setListOf8AData (const ::std::vector< uint8 >& ListOf8AData_);

    /**
     * Release the object stored in the field "ListOf8AData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ListOf8AData"
     */
    inline ::std::vector< uint8 >* releaseListOf8AData();

    /**
     * Replace the field "ListOf8AData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceListOf8AData (::std::vector< uint8 >* ListOf8AData_);

    // API of field "ProgramID"

    static const int kProgramID = 4;

    /**
     * Clears the field "ProgramID".
     *
     * The field will be set to its default value. The hasProgramID()
     * method will return false.
     */
    inline void clearProgramID();

    /**
     * Checks whether the field "ProgramID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgramID()). Otherwise it will return false.
     */
    inline bool hasProgramID () const;

    /**
     * Returns the value of the member "ProgramID".
     *
     * Program ID (PI-Code), identifying the program service,
     * the message is sent from.
     *
     * @return The value of the field "ProgramID"
     */
    inline uint16 getProgramID () const;

    /**
     * Sets the value of the member "ProgramID".
     *
     * Program ID (PI-Code), identifying the program service,
     * the message is sent from.
     *
     * @param ProgramID The value which will be set
     */
    inline void setProgramID (uint16 ProgramID_);

    // API of field "Encryption"

    static const int kEncryption = 5;

    /**
     * Clears the field "Encryption".
     *
     * The field will be set to its default value. The hasEncryption()
     * method will return false.
     */
    inline void clearEncryption();

    /**
     * Checks whether the field "Encryption" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEncryption()). Otherwise it will return false.
     */
    inline bool hasEncryption () const;

    /**
     * Returns the value of the member "Encryption".
     *
     * Identifying the encryption type and values of this message
     *
     * @return The value of the field "Encryption"
     */
    inline const T_Encryption& getEncryption () const;

    /**
     * Retrieves the value of the field "Encryption" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Encryption".
     */
    inline T_Encryption& getEncryptionMutable ();

    /**
     * Sets the value of the member "Encryption".
     *
     * Identifying the encryption type and values of this message
     *
     * @param Encryption The value which will be set
     */
    inline void setEncryption (const T_Encryption& Encryption_);

    /**
     * Release the object stored in the field "Encryption".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "Encryption"
     */
    inline T_Encryption* releaseEncryption();

    /**
     * Replace the field "Encryption".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceEncryption (T_Encryption* Encryption_);

    // API of field "MsgSource"

    static const int kMsgSource = 6;

    /**
     * Clears the field "MsgSource".
     *
     * The field will be set to its default value. The hasMsgSource()
     * method will return false.
     */
    inline void clearMsgSource();

    /**
     * Checks whether the field "MsgSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMsgSource()). Otherwise it will return false.
     */
    inline bool hasMsgSource () const;

    /**
     * Returns the value of the member "MsgSource".
     *
     * Identifying the (tuner) source of the message
     *
     * @return The value of the field "MsgSource"
     */
    inline const T_MsgSource& getMsgSource () const;

    /**
     * Retrieves the value of the field "MsgSource" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "MsgSource".
     */
    inline T_MsgSource& getMsgSourceMutable ();

    /**
     * Sets the value of the member "MsgSource".
     *
     * Identifying the (tuner) source of the message
     *
     * @param MsgSource The value which will be set
     */
    inline void setMsgSource (const T_MsgSource& MsgSource_);

    /**
     * Release the object stored in the field "MsgSource".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "MsgSource"
     */
    inline T_MsgSource* releaseMsgSource();

    /**
     * Replace the field "MsgSource".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceMsgSource (T_MsgSource* MsgSource_);

    // API of field "ProgramServiceName"

    static const int kProgramServiceName = 7;

    /**
     * Clears the field "ProgramServiceName".
     *
     * The field will be set to its default value. The hasProgramServiceName()
     * method will return false.
     */
    inline void clearProgramServiceName();

    /**
     * Checks whether the field "ProgramServiceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProgramServiceName()). Otherwise it will return false.
     */
    inline bool hasProgramServiceName () const;

    /**
     * Returns the value of the member "ProgramServiceName".
     *
     * Name of the program service
     *
     * @return The value of the field "ProgramServiceName"
     */
    inline const ::std::string& getProgramServiceName () const;

    /**
     * Retrieves the value of the field "ProgramServiceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ProgramServiceName".
     */
    inline ::std::string& getProgramServiceNameMutable ();

    /**
     * Sets the value of the member "ProgramServiceName".
     *
     * Name of the program service
     *
     * @param ProgramServiceName The value which will be set
     */
    inline void setProgramServiceName (const ::std::string& ProgramServiceName_);

    /**
     * Sets the value of the member "ProgramServiceName".
     *
     * Name of the program service
     *
     * @param ProgramServiceName The value which will be set
     */
    inline void setProgramServiceName (const char* ProgramServiceName_);

    /**
     * Sets the value of the member "ProgramServiceName".
     *
     * Name of the program service
     *
     * @param ProgramServiceName The value which will be set
     */
    inline void setProgramServiceName (const char* value, size_t size);

    /**
     * Release the object stored in the field "ProgramServiceName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ProgramServiceName"
     */
    inline ::std::string* releaseProgramServiceName();

    /**
     * Replace the field "ProgramServiceName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceProgramServiceName (::std::string* ProgramServiceName_);

    // API of field "ServiceProviderName"

    static const int kServiceProviderName = 8;

    /**
     * Clears the field "ServiceProviderName".
     *
     * The field will be set to its default value. The hasServiceProviderName()
     * method will return false.
     */
    inline void clearServiceProviderName();

    /**
     * Checks whether the field "ServiceProviderName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceProviderName()). Otherwise it will return false.
     */
    inline bool hasServiceProviderName () const;

    /**
     * Returns the value of the member "ServiceProviderName".
     *
     * Name of the service provider
     *
     * @return The value of the field "ServiceProviderName"
     */
    inline const ::std::string& getServiceProviderName () const;

    /**
     * Retrieves the value of the field "ServiceProviderName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServiceProviderName".
     */
    inline ::std::string& getServiceProviderNameMutable ();

    /**
     * Sets the value of the member "ServiceProviderName".
     *
     * Name of the service provider
     *
     * @param ServiceProviderName The value which will be set
     */
    inline void setServiceProviderName (const ::std::string& ServiceProviderName_);

    /**
     * Sets the value of the member "ServiceProviderName".
     *
     * Name of the service provider
     *
     * @param ServiceProviderName The value which will be set
     */
    inline void setServiceProviderName (const char* ServiceProviderName_);

    /**
     * Sets the value of the member "ServiceProviderName".
     *
     * Name of the service provider
     *
     * @param ServiceProviderName The value which will be set
     */
    inline void setServiceProviderName (const char* value, size_t size);

    /**
     * Release the object stored in the field "ServiceProviderName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ServiceProviderName"
     */
    inline ::std::string* releaseServiceProviderName();

    /**
     * Replace the field "ServiceProviderName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceServiceProviderName (::std::string* ServiceProviderName_);

    static const T_TrafficInfo &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_RDBId ();

    inline void clear_has_RDBId ();

    inline void set_has_ECC ();

    inline void clear_has_ECC ();

    inline void set_has_ApplicationId ();

    inline void clear_has_ApplicationId ();

    inline void set_has_ListOf8AData ();

    inline void clear_has_ListOf8AData ();

    inline void set_has_ProgramID ();

    inline void clear_has_ProgramID ();

    inline void set_has_Encryption ();

    inline void clear_has_Encryption ();

    inline void set_has_MsgSource ();

    inline void clear_has_MsgSource ();

    inline void set_has_ProgramServiceName ();

    inline void clear_has_ProgramServiceName ();

    inline void set_has_ServiceProviderName ();

    inline void clear_has_ServiceProviderName ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_TunerRdbId* _RDBId;

    int16 _ECC;

    T_e16_TmcApplicationId _ApplicationId;

    ::std::vector< uint8 >* _ListOf8AData;

    uint16 _ProgramID;

    T_Encryption* _Encryption;

    T_MsgSource* _MsgSource;

    ::std::string* _ProgramServiceName;

    ::std::string* _ServiceProviderName;

};

/**
 * .
 */
class T_b8_Tun_PackedInfo {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_PackedInfo ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_PackedInfo (const T_b8_Tun_PackedInfo &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_PackedInfo (bool TUN_TP, bool TUN_TP_SELF, bool TUN_PTY_DYNAMIC, bool TUN_PS_DYNAMIC, bool TUN_TMC_reserved, bool TUN_TMC_YES, bool TUN_TMC_NO);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_PackedInfo& operator = (const T_b8_Tun_PackedInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_PackedInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_PackedInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_PackedInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_PackedInfo& rhs) const;

    /**
     * Sets the value of the member "TUN_TP".
     *
     * If the meaning of "TUN_TP" isn't clear, then there should be a description here.
     *
     * @param TUN_TP The value which will be set
     */
    inline void setTUN_TP (bool TUN_TP);

    /**
     * Returns the value of the member "TUN_TP".
     *
     * If the meaning of "TUN_TP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TP"
     */
    inline bool getTUN_TP () const;

    /**
     * Sets the value of the member "TUN_TP_SELF".
     *
     * If the meaning of "TUN_TP_SELF" isn't clear, then there should be a description here.
     *
     * @param TUN_TP_SELF The value which will be set
     */
    inline void setTUN_TP_SELF (bool TUN_TP_SELF);

    /**
     * Returns the value of the member "TUN_TP_SELF".
     *
     * If the meaning of "TUN_TP_SELF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TP_SELF"
     */
    inline bool getTUN_TP_SELF () const;

    /**
     * Sets the value of the member "TUN_PTY_DYNAMIC".
     *
     * If the meaning of "TUN_PTY_DYNAMIC" isn't clear, then there should be a description here.
     *
     * @param TUN_PTY_DYNAMIC The value which will be set
     */
    inline void setTUN_PTY_DYNAMIC (bool TUN_PTY_DYNAMIC);

    /**
     * Returns the value of the member "TUN_PTY_DYNAMIC".
     *
     * If the meaning of "TUN_PTY_DYNAMIC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_PTY_DYNAMIC"
     */
    inline bool getTUN_PTY_DYNAMIC () const;

    /**
     * Sets the value of the member "TUN_PS_DYNAMIC".
     *
     * If the meaning of "TUN_PS_DYNAMIC" isn't clear, then there should be a description here.
     *
     * @param TUN_PS_DYNAMIC The value which will be set
     */
    inline void setTUN_PS_DYNAMIC (bool TUN_PS_DYNAMIC);

    /**
     * Returns the value of the member "TUN_PS_DYNAMIC".
     *
     * If the meaning of "TUN_PS_DYNAMIC" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_PS_DYNAMIC"
     */
    inline bool getTUN_PS_DYNAMIC () const;

    /**
     * Sets the value of the member "TUN_TMC_reserved".
     *
     * If the meaning of "TUN_TMC_reserved" isn't clear, then there should be a description here.
     *
     * @param TUN_TMC_reserved The value which will be set
     */
    inline void setTUN_TMC_reserved (bool TUN_TMC_reserved);

    /**
     * Returns the value of the member "TUN_TMC_reserved".
     *
     * If the meaning of "TUN_TMC_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TMC_reserved"
     */
    inline bool getTUN_TMC_reserved () const;

    /**
     * Sets the value of the member "TUN_TMC_YES".
     *
     * If the meaning of "TUN_TMC_YES" isn't clear, then there should be a description here.
     *
     * @param TUN_TMC_YES The value which will be set
     */
    inline void setTUN_TMC_YES (bool TUN_TMC_YES);

    /**
     * Returns the value of the member "TUN_TMC_YES".
     *
     * If the meaning of "TUN_TMC_YES" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TMC_YES"
     */
    inline bool getTUN_TMC_YES () const;

    /**
     * Sets the value of the member "TUN_TMC_NO".
     *
     * If the meaning of "TUN_TMC_NO" isn't clear, then there should be a description here.
     *
     * @param TUN_TMC_NO The value which will be set
     */
    inline void setTUN_TMC_NO (bool TUN_TMC_NO);

    /**
     * Returns the value of the member "TUN_TMC_NO".
     *
     * If the meaning of "TUN_TMC_NO" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_TMC_NO"
     */
    inline bool getTUN_TMC_NO () const;

    static const T_b8_Tun_PackedInfo &getDefaultInstance();

private:

    bool _TUN_TP:1;

    bool _TUN_TP_SELF:1;

    bool _TUN_PTY_DYNAMIC:1;

    bool _TUN_PS_DYNAMIC:1;

    bool _TUN_TMC_reserved:1;

    bool _TUN_TMC_YES:1;

    bool _TUN_TMC_NO:1;

};

/**
 * This structure gives info about number of elements in the config list.
 */
class T_MakeConfigListElem {
public:

    /**
     * Default constructor
     */
    inline  T_MakeConfigListElem ();

    /**
     * Copy constructor
     */
    inline  T_MakeConfigListElem (const T_MakeConfigListElem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MakeConfigListElem (T_e8_Tun_ConfigListID e8ListID_, uint8 u8NumOfElementsInList_);

    /**
     * Destructor
     */
    inline  ~T_MakeConfigListElem();

    /**
     * Assignment operator
     */
    inline T_MakeConfigListElem& operator = (const T_MakeConfigListElem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MakeConfigListElem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MakeConfigListElem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MakeConfigListElem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MakeConfigListElem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListID"

    static const int kE8ListID = 0;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * List ID's for station list
     *
     * @return The value of the field "e8ListID"
     */
    inline T_e8_Tun_ConfigListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * List ID's for station list
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (T_e8_Tun_ConfigListID e8ListID_);

    // API of field "u8NumOfElementsInList"

    static const int kU8NumOfElementsInList = 1;

    /**
     * Clears the field "u8NumOfElementsInList".
     *
     * The field will be set to its default value. The hasU8NumOfElementsInList()
     * method will return false.
     */
    inline void clearU8NumOfElementsInList();

    /**
     * Checks whether the field "u8NumOfElementsInList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumOfElementsInList()). Otherwise it will return false.
     */
    inline bool hasU8NumOfElementsInList () const;

    /**
     * Returns the value of the member "u8NumOfElementsInList".
     *
     *
     *
     * @return The value of the field "u8NumOfElementsInList"
     */
    inline uint8 getU8NumOfElementsInList () const;

    /**
     * Sets the value of the member "u8NumOfElementsInList".
     *
     *
     *
     * @param u8NumOfElementsInList The value which will be set
     */
    inline void setU8NumOfElementsInList (uint8 u8NumOfElementsInList_);

    static const T_MakeConfigListElem &getDefaultInstance();

private:

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    inline void set_has_u8NumOfElementsInList ();

    inline void clear_has_u8NumOfElementsInList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_ConfigListID _e8ListID;

    uint8 _u8NumOfElementsInList;

};

/**
 * Tuner Avail Flags .
 */
class T_b8_Tun_AvailFlags {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_AvailFlags ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_AvailFlags (const T_b8_Tun_AvailFlags &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_AvailFlags (bool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE, bool TUN_AVAILABLE_FLAGS_PI_AVAILABLE, bool TUN_AVAILABLE_FLAGS_PS_AVAILABLE, bool TUN_AVAILABLE_FLAGS_PTY_AVAILABLE, bool TUN_AVAILABLE_FLAGS_CT_AVAILABLE, bool TUN_AVAILABLE_FLAGS_RT_AVAILABLE, bool TUN_AVAILABLE_FLAGS_reserved);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_AvailFlags& operator = (const T_b8_Tun_AvailFlags& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_AvailFlags& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_AvailFlags& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_AvailFlags& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_AvailFlags& rhs) const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (bool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_PI_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PI_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_PI_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_PI_AVAILABLE (bool TUN_AVAILABLE_FLAGS_PI_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_PI_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PI_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_PI_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_PI_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_PS_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_PS_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_PS_AVAILABLE (bool TUN_AVAILABLE_FLAGS_PS_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_PS_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PS_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_PS_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_PS_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_PTY_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PTY_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_PTY_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_PTY_AVAILABLE (bool TUN_AVAILABLE_FLAGS_PTY_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_PTY_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_PTY_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_PTY_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_PTY_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_CT_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_CT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_CT_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_CT_AVAILABLE (bool TUN_AVAILABLE_FLAGS_CT_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_CT_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_CT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_CT_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_CT_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_RT_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_RT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_RT_AVAILABLE The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_RT_AVAILABLE (bool TUN_AVAILABLE_FLAGS_RT_AVAILABLE);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_RT_AVAILABLE".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_RT_AVAILABLE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_RT_AVAILABLE"
     */
    inline bool getTUN_AVAILABLE_FLAGS_RT_AVAILABLE () const;

    /**
     * Sets the value of the member "TUN_AVAILABLE_FLAGS_reserved".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_reserved" isn't clear, then there should be a description here.
     *
     * @param TUN_AVAILABLE_FLAGS_reserved The value which will be set
     */
    inline void setTUN_AVAILABLE_FLAGS_reserved (bool TUN_AVAILABLE_FLAGS_reserved);

    /**
     * Returns the value of the member "TUN_AVAILABLE_FLAGS_reserved".
     *
     * If the meaning of "TUN_AVAILABLE_FLAGS_reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_AVAILABLE_FLAGS_reserved"
     */
    inline bool getTUN_AVAILABLE_FLAGS_reserved () const;

    static const T_b8_Tun_AvailFlags &getDefaultInstance();

private:

    bool _TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_PI_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_PS_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_PTY_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_CT_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_RT_AVAILABLE:1;

    bool _TUN_AVAILABLE_FLAGS_reserved:1;

};

/**
 * provides TP and AF information for the station
 */
class T_b8_Tun_StationInfo {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_StationInfo ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_StationInfo (const T_b8_Tun_StationInfo &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_StationInfo (bool TP, bool AF);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_StationInfo& operator = (const T_b8_Tun_StationInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_StationInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_StationInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_StationInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_StationInfo& rhs) const;

    /**
     * Sets the value of the member "TP".
     *
     * If the meaning of "TP" isn't clear, then there should be a description here.
     *
     * @param TP The value which will be set
     */
    inline void setTP (bool TP);

    /**
     * Returns the value of the member "TP".
     *
     * If the meaning of "TP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TP"
     */
    inline bool getTP () const;

    /**
     * Sets the value of the member "AF".
     *
     * If the meaning of "AF" isn't clear, then there should be a description here.
     *
     * @param AF The value which will be set
     */
    inline void setAF (bool AF);

    /**
     * Returns the value of the member "AF".
     *
     * If the meaning of "AF" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AF"
     */
    inline bool getAF () const;

    static const T_b8_Tun_StationInfo &getDefaultInstance();

private:

    bool _TP:1;

    bool _AF:1;

};

/**
 * If the meaning of "T_b8_Tun_HDNumOfAudioPrograms" isn't clear, then there should be a description here.
 */
class T_b8_Tun_HDNumOfAudioPrograms {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_HDNumOfAudioPrograms ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_HDNumOfAudioPrograms (const T_b8_Tun_HDNumOfAudioPrograms &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_HDNumOfAudioPrograms (bool TUN_HD_AUDIOPROGRAM_MPS, bool TUN_HD_AUDIOPROGRAM_SPS1, bool TUN_HD_AUDIOPROGRAM_SPS2, bool TUN_HD_AUDIOPROGRAM_SPS3, bool TUN_HD_AUDIOPROGRAM_SPS4, bool TUN_HD_AUDIOPROGRAM_SPS5, bool TUN_HD_AUDIOPROGRAM_SPS6, bool TUN_HD_AUDIOPROGRAM_SPS7);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_HDNumOfAudioPrograms& operator = (const T_b8_Tun_HDNumOfAudioPrograms& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_HDNumOfAudioPrograms& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_HDNumOfAudioPrograms& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_HDNumOfAudioPrograms& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_HDNumOfAudioPrograms& rhs) const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_MPS".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_MPS" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_MPS The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_MPS (bool TUN_HD_AUDIOPROGRAM_MPS);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_MPS".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_MPS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_MPS"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_MPS () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS1".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS1" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS1 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS1 (bool TUN_HD_AUDIOPROGRAM_SPS1);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS1".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS1"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS1 () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS2".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS2" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS2 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS2 (bool TUN_HD_AUDIOPROGRAM_SPS2);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS2".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS2"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS2 () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS3".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS3" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS3 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS3 (bool TUN_HD_AUDIOPROGRAM_SPS3);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS3".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS3"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS3 () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS4".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS4" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS4 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS4 (bool TUN_HD_AUDIOPROGRAM_SPS4);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS4".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS4"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS4 () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS5".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS5" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS5 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS5 (bool TUN_HD_AUDIOPROGRAM_SPS5);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS5".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS5"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS5 () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS6".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS6" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS6 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS6 (bool TUN_HD_AUDIOPROGRAM_SPS6);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS6".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS6"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS6 () const;

    /**
     * Sets the value of the member "TUN_HD_AUDIOPROGRAM_SPS7".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS7" isn't clear, then there should be a description here.
     *
     * @param TUN_HD_AUDIOPROGRAM_SPS7 The value which will be set
     */
    inline void setTUN_HD_AUDIOPROGRAM_SPS7 (bool TUN_HD_AUDIOPROGRAM_SPS7);

    /**
     * Returns the value of the member "TUN_HD_AUDIOPROGRAM_SPS7".
     *
     * If the meaning of "TUN_HD_AUDIOPROGRAM_SPS7" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TUN_HD_AUDIOPROGRAM_SPS7"
     */
    inline bool getTUN_HD_AUDIOPROGRAM_SPS7 () const;

    static const T_b8_Tun_HDNumOfAudioPrograms &getDefaultInstance();

private:

    bool _TUN_HD_AUDIOPROGRAM_MPS:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS1:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS2:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS3:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS4:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS5:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS6:1;

    bool _TUN_HD_AUDIOPROGRAM_SPS7:1;

};

/**
 * This structure describes config list element for the VW projects.
 */
class T_TunerConfigListElement {
public:

    /**
     * Default constructor
     */
    inline  T_TunerConfigListElement ();

    /**
     * Copy constructor
     */
    inline  T_TunerConfigListElement (const T_TunerConfigListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerConfigListElement (T_e8_Tun_ConfigListID e8ConfigListID_, uint8 u8ElementID_, uint8 u8ElementSelected_, uint32 u32Frequency_, uint32 u32PI_, const ::std::string& sPSName_, uint8 u8PTY_, uint8 u8ECC_, uint8 u8SID_, uint8 u8LTN_, uint8 u8Quality_, uint8 u8PositionInPresetList_, T_e8_Tun_SendernameInfo e8SendernameInfo_, bool bTpInfo_, T_e8_Tun_TMCType e8TMCType_, T_e8_Tun_ListID e8PresetListForAcmp_, int8 s8LevelCompensation_, const ::std::string& StationLogo_, T_e8_Tun_ModulationType e8ModulationType_, uint8 u8PTY_HDPTY_DRMPty_, uint32 u32PI_HDStnId_DRMSrvId_, const T_b8_Tun_StationInfo& b8StationInfo_, T_e8_Tun_HD_TextEncodingType e8HDTextEncoding_, const T_b8_Tun_HDNumOfAudioPrograms& b8HDNumOfAudioPrograms_);

    /**
     * Destructor
     */
    inline  ~T_TunerConfigListElement();

    /**
     * Assignment operator
     */
    inline T_TunerConfigListElement& operator = (const T_TunerConfigListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerConfigListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerConfigListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerConfigListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerConfigListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigListID"

    static const int kE8ConfigListID = 0;

    /**
     * Clears the field "e8ConfigListID".
     *
     * The field will be set to its default value. The hasE8ConfigListID()
     * method will return false.
     */
    inline void clearE8ConfigListID();

    /**
     * Checks whether the field "e8ConfigListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigListID()). Otherwise it will return false.
     */
    inline bool hasE8ConfigListID () const;

    /**
     * Returns the value of the member "e8ConfigListID".
     *
     * Station List ID's. This field will be removed in future.
     * Please use parameter e8ConfigListID present outside this structure to get list id
     *
     * @return The value of the field "e8ConfigListID"
     */
    inline T_e8_Tun_ConfigListID getE8ConfigListID () const;

    /**
     * Sets the value of the member "e8ConfigListID".
     *
     * Station List ID's. This field will be removed in future.
     * Please use parameter e8ConfigListID present outside this structure to get list id
     *
     * @param e8ConfigListID The value which will be set
     */
    inline void setE8ConfigListID (T_e8_Tun_ConfigListID e8ConfigListID_);

    // API of field "u8ElementID"

    static const int kU8ElementID = 1;

    /**
     * Clears the field "u8ElementID".
     *
     * The field will be set to its default value. The hasU8ElementID()
     * method will return false.
     */
    inline void clearU8ElementID();

    /**
     * Checks whether the field "u8ElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ElementID()). Otherwise it will return false.
     */
    inline bool hasU8ElementID () const;

    /**
     * Returns the value of the member "u8ElementID".
     *
     *
     *
     * @return The value of the field "u8ElementID"
     */
    inline uint8 getU8ElementID () const;

    /**
     * Sets the value of the member "u8ElementID".
     *
     *
     *
     * @param u8ElementID The value which will be set
     */
    inline void setU8ElementID (uint8 u8ElementID_);

    // API of field "u8ElementSelected"

    static const int kU8ElementSelected = 2;

    /**
     * Clears the field "u8ElementSelected".
     *
     * The field will be set to its default value. The hasU8ElementSelected()
     * method will return false.
     */
    inline void clearU8ElementSelected();

    /**
     * Checks whether the field "u8ElementSelected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ElementSelected()). Otherwise it will return false.
     */
    inline bool hasU8ElementSelected () const;

    /**
     * Returns the value of the member "u8ElementSelected".
     *
     * .
     *
     * @return The value of the field "u8ElementSelected"
     */
    inline uint8 getU8ElementSelected () const;

    /**
     * Sets the value of the member "u8ElementSelected".
     *
     * .
     *
     * @param u8ElementSelected The value which will be set
     */
    inline void setU8ElementSelected (uint8 u8ElementSelected_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 3;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * .
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * .
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u32PI"

    static const int kU32PI = 4;

    /**
     * Clears the field "u32PI".
     *
     * The field will be set to its default value. The hasU32PI()
     * method will return false.
     */
    inline void clearU32PI();

    /**
     * Checks whether the field "u32PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PI()). Otherwise it will return false.
     */
    inline bool hasU32PI () const;

    /**
     * Returns the value of the member "u32PI".
     *
     * .
     *
     * @return The value of the field "u32PI"
     */
    inline uint32 getU32PI () const;

    /**
     * Sets the value of the member "u32PI".
     *
     * .
     *
     * @param u32PI The value which will be set
     */
    inline void setU32PI (uint32 u32PI_);

    // API of field "sPSName"

    static const int kSPSName = 5;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName / HD Callsign / DRM Service Label based on the type of modulation.
     * max Length of string is 64 bytes
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName / HD Callsign / DRM Service Label based on the type of modulation.
     * max Length of string is 64 bytes
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName / HD Callsign / DRM Service Label based on the type of modulation.
     * max Length of string is 64 bytes
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName / HD Callsign / DRM Service Label based on the type of modulation.
     * max Length of string is 64 bytes
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPSName"
     */
    inline ::std::string* releaseSPSName();

    /**
     * Replace the field "sPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPSName (::std::string* sPSName_);

    // API of field "u8PTY"

    static const int kU8PTY = 6;

    /**
     * Clears the field "u8PTY".
     *
     * The field will be set to its default value. The hasU8PTY()
     * method will return false.
     */
    inline void clearU8PTY();

    /**
     * Checks whether the field "u8PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PTY()). Otherwise it will return false.
     */
    inline bool hasU8PTY () const;

    /**
     * Returns the value of the member "u8PTY".
     *
     *
     *
     * @return The value of the field "u8PTY"
     */
    inline uint8 getU8PTY () const;

    /**
     * Sets the value of the member "u8PTY".
     *
     *
     *
     * @param u8PTY The value which will be set
     */
    inline void setU8PTY (uint8 u8PTY_);

    // API of field "u8ECC"

    static const int kU8ECC = 7;

    /**
     * Clears the field "u8ECC".
     *
     * The field will be set to its default value. The hasU8ECC()
     * method will return false.
     */
    inline void clearU8ECC();

    /**
     * Checks whether the field "u8ECC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ECC()). Otherwise it will return false.
     */
    inline bool hasU8ECC () const;

    /**
     * Returns the value of the member "u8ECC".
     *
     *
     *
     * @return The value of the field "u8ECC"
     */
    inline uint8 getU8ECC () const;

    /**
     * Sets the value of the member "u8ECC".
     *
     *
     *
     * @param u8ECC The value which will be set
     */
    inline void setU8ECC (uint8 u8ECC_);

    // API of field "u8SID"

    static const int kU8SID = 8;

    /**
     * Clears the field "u8SID".
     *
     * The field will be set to its default value. The hasU8SID()
     * method will return false.
     */
    inline void clearU8SID();

    /**
     * Checks whether the field "u8SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8SID()). Otherwise it will return false.
     */
    inline bool hasU8SID () const;

    /**
     * Returns the value of the member "u8SID".
     *
     *
     *
     * @return The value of the field "u8SID"
     */
    inline uint8 getU8SID () const;

    /**
     * Sets the value of the member "u8SID".
     *
     *
     *
     * @param u8SID The value which will be set
     */
    inline void setU8SID (uint8 u8SID_);

    // API of field "u8LTN"

    static const int kU8LTN = 9;

    /**
     * Clears the field "u8LTN".
     *
     * The field will be set to its default value. The hasU8LTN()
     * method will return false.
     */
    inline void clearU8LTN();

    /**
     * Checks whether the field "u8LTN" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LTN()). Otherwise it will return false.
     */
    inline bool hasU8LTN () const;

    /**
     * Returns the value of the member "u8LTN".
     *
     *
     *
     * @return The value of the field "u8LTN"
     */
    inline uint8 getU8LTN () const;

    /**
     * Sets the value of the member "u8LTN".
     *
     *
     *
     * @param u8LTN The value which will be set
     */
    inline void setU8LTN (uint8 u8LTN_);

    // API of field "u8Quality"

    static const int kU8Quality = 10;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     *
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     *
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    // API of field "u8PositionInPresetList"

    static const int kU8PositionInPresetList = 11;

    /**
     * Clears the field "u8PositionInPresetList".
     *
     * The field will be set to its default value. The hasU8PositionInPresetList()
     * method will return false.
     */
    inline void clearU8PositionInPresetList();

    /**
     * Checks whether the field "u8PositionInPresetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PositionInPresetList()). Otherwise it will return false.
     */
    inline bool hasU8PositionInPresetList () const;

    /**
     * Returns the value of the member "u8PositionInPresetList".
     *
     * Gives the position of the FM station in Preset list.
     *
     * @return The value of the field "u8PositionInPresetList"
     */
    inline uint8 getU8PositionInPresetList () const;

    /**
     * Sets the value of the member "u8PositionInPresetList".
     *
     * Gives the position of the FM station in Preset list.
     *
     * @param u8PositionInPresetList The value which will be set
     */
    inline void setU8PositionInPresetList (uint8 u8PositionInPresetList_);

    // API of field "e8SendernameInfo"

    static const int kE8SendernameInfo = 12;

    /**
     * Clears the field "e8SendernameInfo".
     *
     * The field will be set to its default value. The hasE8SendernameInfo()
     * method will return false.
     */
    inline void clearE8SendernameInfo();

    /**
     * Checks whether the field "e8SendernameInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SendernameInfo()). Otherwise it will return false.
     */
    inline bool hasE8SendernameInfo () const;

    /**
     * Returns the value of the member "e8SendernameInfo".
     *
     * Gives more info on station name
     *
     * @return The value of the field "e8SendernameInfo"
     */
    inline T_e8_Tun_SendernameInfo getE8SendernameInfo () const;

    /**
     * Sets the value of the member "e8SendernameInfo".
     *
     * Gives more info on station name
     *
     * @param e8SendernameInfo The value which will be set
     */
    inline void setE8SendernameInfo (T_e8_Tun_SendernameInfo e8SendernameInfo_);

    // API of field "bTpInfo"

    static const int kBTpInfo = 13;

    /**
     * Clears the field "bTpInfo".
     *
     * The field will be set to its default value. The hasBTpInfo()
     * method will return false.
     */
    inline void clearBTpInfo();

    /**
     * Checks whether the field "bTpInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTpInfo()). Otherwise it will return false.
     */
    inline bool hasBTpInfo () const;

    /**
     * Returns the value of the member "bTpInfo".
     *
     * Gives the TP status
     *
     * @return The value of the field "bTpInfo"
     */
    inline bool getBTpInfo () const;

    /**
     * Sets the value of the member "bTpInfo".
     *
     * Gives the TP status
     *
     * @param bTpInfo The value which will be set
     */
    inline void setBTpInfo (bool bTpInfo_);

    // API of field "e8TMCType"

    static const int kE8TMCType = 14;

    /**
     * Clears the field "e8TMCType".
     *
     * The field will be set to its default value. The hasE8TMCType()
     * method will return false.
     */
    inline void clearE8TMCType();

    /**
     * Checks whether the field "e8TMCType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TMCType()). Otherwise it will return false.
     */
    inline bool hasE8TMCType () const;

    /**
     * Returns the value of the member "e8TMCType".
     *
     * Gives the TMC mode
     *
     * @return The value of the field "e8TMCType"
     */
    inline T_e8_Tun_TMCType getE8TMCType () const;

    /**
     * Sets the value of the member "e8TMCType".
     *
     * Gives the TMC mode
     *
     * @param e8TMCType The value which will be set
     */
    inline void setE8TMCType (T_e8_Tun_TMCType e8TMCType_);

    // API of field "e8PresetListForAcmp"

    static const int kE8PresetListForAcmp = 15;

    /**
     * Clears the field "e8PresetListForAcmp".
     *
     * The field will be set to its default value. The hasE8PresetListForAcmp()
     * method will return false.
     */
    inline void clearE8PresetListForAcmp();

    /**
     * Checks whether the field "e8PresetListForAcmp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PresetListForAcmp()). Otherwise it will return false.
     */
    inline bool hasE8PresetListForAcmp () const;

    /**
     * Returns the value of the member "e8PresetListForAcmp".
     *
     * The preset list, the given station was found in first.
     *
     * @return The value of the field "e8PresetListForAcmp"
     */
    inline T_e8_Tun_ListID getE8PresetListForAcmp () const;

    /**
     * Sets the value of the member "e8PresetListForAcmp".
     *
     * The preset list, the given station was found in first.
     *
     * @param e8PresetListForAcmp The value which will be set
     */
    inline void setE8PresetListForAcmp (T_e8_Tun_ListID e8PresetListForAcmp_);

    // API of field "s8LevelCompensation"

    static const int kS8LevelCompensation = 16;

    /**
     * Clears the field "s8LevelCompensation".
     *
     * The field will be set to its default value. The hasS8LevelCompensation()
     * method will return false.
     */
    inline void clearS8LevelCompensation();

    /**
     * Checks whether the field "s8LevelCompensation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8LevelCompensation()). Otherwise it will return false.
     */
    inline bool hasS8LevelCompensation () const;

    /**
     * Returns the value of the member "s8LevelCompensation".
     *
     *
     *
     * @return The value of the field "s8LevelCompensation"
     */
    inline int8 getS8LevelCompensation () const;

    /**
     * Sets the value of the member "s8LevelCompensation".
     *
     *
     *
     * @param s8LevelCompensation The value which will be set
     */
    inline void setS8LevelCompensation (int8 s8LevelCompensation_);

    // API of field "StationLogo"

    static const int kStationLogo = 17;

    /**
     * Clears the field "StationLogo".
     *
     * The field will be set to its default value. The hasStationLogo()
     * method will return false.
     */
    inline void clearStationLogo();

    /**
     * Checks whether the field "StationLogo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationLogo()). Otherwise it will return false.
     */
    inline bool hasStationLogo () const;

    /**
     * Returns the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @return The value of the field "StationLogo"
     */
    inline const ::std::string& getStationLogo () const;

    /**
     * Retrieves the value of the field "StationLogo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationLogo".
     */
    inline ::std::string& getStationLogoMutable ();

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const ::std::string& StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* value, size_t size);

    /**
     * Release the object stored in the field "StationLogo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "StationLogo"
     */
    inline ::std::string* releaseStationLogo();

    /**
     * Replace the field "StationLogo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStationLogo (::std::string* StationLogo_);

    // API of field "e8ModulationType"

    static const int kE8ModulationType = 18;

    /**
     * Clears the field "e8ModulationType".
     *
     * The field will be set to its default value. The hasE8ModulationType()
     * method will return false.
     */
    inline void clearE8ModulationType();

    /**
     * Checks whether the field "e8ModulationType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ModulationType()). Otherwise it will return false.
     */
    inline bool hasE8ModulationType () const;

    /**
     * Returns the value of the member "e8ModulationType".
     *
     * determines the type of modulation (Analog/HD/DRM).
     *
     * @return The value of the field "e8ModulationType"
     */
    inline T_e8_Tun_ModulationType getE8ModulationType () const;

    /**
     * Sets the value of the member "e8ModulationType".
     *
     * determines the type of modulation (Analog/HD/DRM).
     *
     * @param e8ModulationType The value which will be set
     */
    inline void setE8ModulationType (T_e8_Tun_ModulationType e8ModulationType_);

    // API of field "u8PTY_HDPTY_DRMPty"

    static const int kU8PTY_HDPTY_DRMPty = 19;

    /**
     * Clears the field "u8PTY_HDPTY_DRMPty".
     *
     * The field will be set to its default value. The hasU8PTY_HDPTY_DRMPty()
     * method will return false.
     */
    inline void clearU8PTY_HDPTY_DRMPty();

    /**
     * Checks whether the field "u8PTY_HDPTY_DRMPty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PTY_HDPTY_DRMPty()). Otherwise it will return false.
     */
    inline bool hasU8PTY_HDPTY_DRMPty () const;

    /**
     * Returns the value of the member "u8PTY_HDPTY_DRMPty".
     *
     * Gives the PTY / HD PTY / DRMPty based on the type of modulation.
     *
     * @return The value of the field "u8PTY_HDPTY_DRMPty"
     */
    inline uint8 getU8PTY_HDPTY_DRMPty () const;

    /**
     * Sets the value of the member "u8PTY_HDPTY_DRMPty".
     *
     * Gives the PTY / HD PTY / DRMPty based on the type of modulation.
     *
     * @param u8PTY_HDPTY_DRMPty The value which will be set
     */
    inline void setU8PTY_HDPTY_DRMPty (uint8 u8PTY_HDPTY_DRMPty_);

    // API of field "u32PI_HDStnId_DRMSrvId"

    static const int kU32PI_HDStnId_DRMSrvId = 20;

    /**
     * Clears the field "u32PI_HDStnId_DRMSrvId".
     *
     * The field will be set to its default value. The hasU32PI_HDStnId_DRMSrvId()
     * method will return false.
     */
    inline void clearU32PI_HDStnId_DRMSrvId();

    /**
     * Checks whether the field "u32PI_HDStnId_DRMSrvId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PI_HDStnId_DRMSrvId()). Otherwise it will return false.
     */
    inline bool hasU32PI_HDStnId_DRMSrvId () const;

    /**
     * Returns the value of the member "u32PI_HDStnId_DRMSrvId".
     *
     * Gives the PI / HDStationId / DRMServiceId based on the type of modulation.
     *
     * @return The value of the field "u32PI_HDStnId_DRMSrvId"
     */
    inline uint32 getU32PI_HDStnId_DRMSrvId () const;

    /**
     * Sets the value of the member "u32PI_HDStnId_DRMSrvId".
     *
     * Gives the PI / HDStationId / DRMServiceId based on the type of modulation.
     *
     * @param u32PI_HDStnId_DRMSrvId The value which will be set
     */
    inline void setU32PI_HDStnId_DRMSrvId (uint32 u32PI_HDStnId_DRMSrvId_);

    // API of field "b8StationInfo"

    static const int kB8StationInfo = 21;

    /**
     * Clears the field "b8StationInfo".
     *
     * The field will be set to its default value. The hasB8StationInfo()
     * method will return false.
     */
    inline void clearB8StationInfo();

    /**
     * Checks whether the field "b8StationInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8StationInfo()). Otherwise it will return false.
     */
    inline bool hasB8StationInfo () const;

    /**
     * Returns the value of the member "b8StationInfo".
     *
     * Bit 0 False TP Off
     * True  TP ON
     * Bit 1 False Af(s) not available
     * True  At least one Af available
     * Bit 2-7 reserved
     *
     * @return The value of the field "b8StationInfo"
     */
    inline const T_b8_Tun_StationInfo& getB8StationInfo () const;

    /**
     * Retrieves the value of the field "b8StationInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8StationInfo".
     */
    inline T_b8_Tun_StationInfo& getB8StationInfoMutable ();

    /**
     * Sets the value of the member "b8StationInfo".
     *
     * Bit 0 False TP Off
     * True  TP ON
     * Bit 1 False Af(s) not available
     * True  At least one Af available
     * Bit 2-7 reserved
     *
     * @param b8StationInfo The value which will be set
     */
    inline void setB8StationInfo (const T_b8_Tun_StationInfo& b8StationInfo_);

    /**
     * Release the object stored in the field "b8StationInfo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8StationInfo"
     */
    inline T_b8_Tun_StationInfo* releaseB8StationInfo();

    /**
     * Replace the field "b8StationInfo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8StationInfo (T_b8_Tun_StationInfo* b8StationInfo_);

    // API of field "e8HDTextEncoding"

    static const int kE8HDTextEncoding = 22;

    /**
     * Clears the field "e8HDTextEncoding".
     *
     * The field will be set to its default value. The hasE8HDTextEncoding()
     * method will return false.
     */
    inline void clearE8HDTextEncoding();

    /**
     * Checks whether the field "e8HDTextEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDTextEncoding()). Otherwise it will return false.
     */
    inline bool hasE8HDTextEncoding () const;

    /**
     * Returns the value of the member "e8HDTextEncoding".
     *
     *
     *
     * @return The value of the field "e8HDTextEncoding"
     */
    inline T_e8_Tun_HD_TextEncodingType getE8HDTextEncoding () const;

    /**
     * Sets the value of the member "e8HDTextEncoding".
     *
     *
     *
     * @param e8HDTextEncoding The value which will be set
     */
    inline void setE8HDTextEncoding (T_e8_Tun_HD_TextEncodingType e8HDTextEncoding_);

    // API of field "b8HDNumOfAudioPrograms"

    static const int kB8HDNumOfAudioPrograms = 23;

    /**
     * Clears the field "b8HDNumOfAudioPrograms".
     *
     * The field will be set to its default value. The hasB8HDNumOfAudioPrograms()
     * method will return false.
     */
    inline void clearB8HDNumOfAudioPrograms();

    /**
     * Checks whether the field "b8HDNumOfAudioPrograms" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8HDNumOfAudioPrograms()). Otherwise it will return false.
     */
    inline bool hasB8HDNumOfAudioPrograms () const;

    /**
     * Returns the value of the member "b8HDNumOfAudioPrograms".
     *
     *
     *
     * @return The value of the field "b8HDNumOfAudioPrograms"
     */
    inline const T_b8_Tun_HDNumOfAudioPrograms& getB8HDNumOfAudioPrograms () const;

    /**
     * Retrieves the value of the field "b8HDNumOfAudioPrograms" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8HDNumOfAudioPrograms".
     */
    inline T_b8_Tun_HDNumOfAudioPrograms& getB8HDNumOfAudioProgramsMutable ();

    /**
     * Sets the value of the member "b8HDNumOfAudioPrograms".
     *
     *
     *
     * @param b8HDNumOfAudioPrograms The value which will be set
     */
    inline void setB8HDNumOfAudioPrograms (const T_b8_Tun_HDNumOfAudioPrograms& b8HDNumOfAudioPrograms_);

    /**
     * Release the object stored in the field "b8HDNumOfAudioPrograms".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8HDNumOfAudioPrograms"
     */
    inline T_b8_Tun_HDNumOfAudioPrograms* releaseB8HDNumOfAudioPrograms();

    /**
     * Replace the field "b8HDNumOfAudioPrograms".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8HDNumOfAudioPrograms (T_b8_Tun_HDNumOfAudioPrograms* b8HDNumOfAudioPrograms_);

    static const T_TunerConfigListElement &getDefaultInstance();

private:

    inline void set_has_e8ConfigListID ();

    inline void clear_has_e8ConfigListID ();

    inline void set_has_u8ElementID ();

    inline void clear_has_u8ElementID ();

    inline void set_has_u8ElementSelected ();

    inline void clear_has_u8ElementSelected ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u32PI ();

    inline void clear_has_u32PI ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    inline void set_has_u8PTY ();

    inline void clear_has_u8PTY ();

    inline void set_has_u8ECC ();

    inline void clear_has_u8ECC ();

    inline void set_has_u8SID ();

    inline void clear_has_u8SID ();

    inline void set_has_u8LTN ();

    inline void clear_has_u8LTN ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    inline void set_has_u8PositionInPresetList ();

    inline void clear_has_u8PositionInPresetList ();

    inline void set_has_e8SendernameInfo ();

    inline void clear_has_e8SendernameInfo ();

    inline void set_has_bTpInfo ();

    inline void clear_has_bTpInfo ();

    inline void set_has_e8TMCType ();

    inline void clear_has_e8TMCType ();

    inline void set_has_e8PresetListForAcmp ();

    inline void clear_has_e8PresetListForAcmp ();

    inline void set_has_s8LevelCompensation ();

    inline void clear_has_s8LevelCompensation ();

    inline void set_has_StationLogo ();

    inline void clear_has_StationLogo ();

    inline void set_has_e8ModulationType ();

    inline void clear_has_e8ModulationType ();

    inline void set_has_u8PTY_HDPTY_DRMPty ();

    inline void clear_has_u8PTY_HDPTY_DRMPty ();

    inline void set_has_u32PI_HDStnId_DRMSrvId ();

    inline void clear_has_u32PI_HDStnId_DRMSrvId ();

    inline void set_has_b8StationInfo ();

    inline void clear_has_b8StationInfo ();

    inline void set_has_e8HDTextEncoding ();

    inline void clear_has_e8HDTextEncoding ();

    inline void set_has_b8HDNumOfAudioPrograms ();

    inline void clear_has_b8HDNumOfAudioPrograms ();

    uint32 _has_bits_[ (24 + 31) / 32];

    T_e8_Tun_ConfigListID _e8ConfigListID;

    uint8 _u8ElementID;

    uint8 _u8ElementSelected;

    uint32 _u32Frequency;

    uint32 _u32PI;

    ::std::string* _sPSName;

    uint8 _u8PTY;

    uint8 _u8ECC;

    uint8 _u8SID;

    uint8 _u8LTN;

    uint8 _u8Quality;

    uint8 _u8PositionInPresetList;

    T_e8_Tun_SendernameInfo _e8SendernameInfo;

    bool _bTpInfo;

    T_e8_Tun_TMCType _e8TMCType;

    T_e8_Tun_ListID _e8PresetListForAcmp;

    int8 _s8LevelCompensation;

    ::std::string* _StationLogo;

    T_e8_Tun_ModulationType _e8ModulationType;

    uint8 _u8PTY_HDPTY_DRMPty;

    uint32 _u32PI_HDStnId_DRMSrvId;

    T_b8_Tun_StationInfo* _b8StationInfo;

    T_e8_Tun_HD_TextEncodingType _e8HDTextEncoding;

    T_b8_Tun_HDNumOfAudioPrograms* _b8HDNumOfAudioPrograms;

};

/**
 * This structure gives info about parameter for both PI stepping and selecting absolute PI.
 * The PI stepping can either be step-up or step-down (use u8Direction). The number of steps have to be mentioned(u8Nsteps).
 * For Absolute PI, u16PI and u32Frequency are to be set.
 */
class T_Tun_Set_PI {
public:

    /**
     * Default constructor
     */
    inline  T_Tun_Set_PI ();

    /**
     * Copy constructor
     */
    inline  T_Tun_Set_PI (const T_Tun_Set_PI &rhs);

    /**
     * All fields constructor
     */
    inline  T_Tun_Set_PI (T_e8_Tun_Abs_Or_Rel u8AbsOrRel_, T_e8_Tun_Rel_Steps u8RelSteps_, T_e8_Tun_Direction u8Direction_, uint8 u8Nsteps_, uint16 u16PI_, uint32 u32Frequency_);

    /**
     * Destructor
     */
    inline  ~T_Tun_Set_PI();

    /**
     * Assignment operator
     */
    inline T_Tun_Set_PI& operator = (const T_Tun_Set_PI& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Tun_Set_PI& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Tun_Set_PI& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Tun_Set_PI& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Tun_Set_PI& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AbsOrRel"

    static const int kU8AbsOrRel = 0;

    /**
     * Clears the field "u8AbsOrRel".
     *
     * The field will be set to its default value. The hasU8AbsOrRel()
     * method will return false.
     */
    inline void clearU8AbsOrRel();

    /**
     * Checks whether the field "u8AbsOrRel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsOrRel()). Otherwise it will return false.
     */
    inline bool hasU8AbsOrRel () const;

    /**
     * Returns the value of the member "u8AbsOrRel".
     *
     * ABS    (0x00)
     * REL    (0x01)
     * NEXT_AVAIL (0x02)
     * This value should be set to 0 if absolute PI and frequency are to be set.
     * Else it should be set to 1 for setting relative PI.
     *
     * @return The value of the field "u8AbsOrRel"
     */
    inline T_e8_Tun_Abs_Or_Rel getU8AbsOrRel () const;

    /**
     * Sets the value of the member "u8AbsOrRel".
     *
     * ABS    (0x00)
     * REL    (0x01)
     * NEXT_AVAIL (0x02)
     * This value should be set to 0 if absolute PI and frequency are to be set.
     * Else it should be set to 1 for setting relative PI.
     *
     * @param u8AbsOrRel The value which will be set
     */
    inline void setU8AbsOrRel (T_e8_Tun_Abs_Or_Rel u8AbsOrRel_);

    // API of field "u8RelSteps"

    static const int kU8RelSteps = 1;

    /**
     * Clears the field "u8RelSteps".
     *
     * The field will be set to its default value. The hasU8RelSteps()
     * method will return false.
     */
    inline void clearU8RelSteps();

    /**
     * Checks whether the field "u8RelSteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RelSteps()). Otherwise it will return false.
     */
    inline bool hasU8RelSteps () const;

    /**
     * Returns the value of the member "u8RelSteps".
     *
     * INC  (0x01)
     * DEC  (0xff)
     * This parameter should not be used. Instead use u8Direction for setting the direction.
     *
     * @return The value of the field "u8RelSteps"
     */
    inline T_e8_Tun_Rel_Steps getU8RelSteps () const;

    /**
     * Sets the value of the member "u8RelSteps".
     *
     * INC  (0x01)
     * DEC  (0xff)
     * This parameter should not be used. Instead use u8Direction for setting the direction.
     *
     * @param u8RelSteps The value which will be set
     */
    inline void setU8RelSteps (T_e8_Tun_Rel_Steps u8RelSteps_);

    // API of field "u8Direction"

    static const int kU8Direction = 2;

    /**
     * Clears the field "u8Direction".
     *
     * The field will be set to its default value. The hasU8Direction()
     * method will return false.
     */
    inline void clearU8Direction();

    /**
     * Checks whether the field "u8Direction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Direction()). Otherwise it will return false.
     */
    inline bool hasU8Direction () const;

    /**
     * Returns the value of the member "u8Direction".
     *
     * UP   (0x01)
     * DOWN (0xff)
     * This value is used if u8AbsOrRel is set to 1 (Relative). This parameter indicates if the Pi stepping is step-up or step-down.
     *
     * @return The value of the field "u8Direction"
     */
    inline T_e8_Tun_Direction getU8Direction () const;

    /**
     * Sets the value of the member "u8Direction".
     *
     * UP   (0x01)
     * DOWN (0xff)
     * This value is used if u8AbsOrRel is set to 1 (Relative). This parameter indicates if the Pi stepping is step-up or step-down.
     *
     * @param u8Direction The value which will be set
     */
    inline void setU8Direction (T_e8_Tun_Direction u8Direction_);

    // API of field "u8Nsteps"

    static const int kU8Nsteps = 3;

    /**
     * Clears the field "u8Nsteps".
     *
     * The field will be set to its default value. The hasU8Nsteps()
     * method will return false.
     */
    inline void clearU8Nsteps();

    /**
     * Checks whether the field "u8Nsteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Nsteps()). Otherwise it will return false.
     */
    inline bool hasU8Nsteps () const;

    /**
     * Returns the value of the member "u8Nsteps".
     *
     * This value is used if e8AbsOrRel is set to 1 (Relative). This parameter indicates the number of steps.
     *
     * @return The value of the field "u8Nsteps"
     */
    inline uint8 getU8Nsteps () const;

    /**
     * Sets the value of the member "u8Nsteps".
     *
     * This value is used if e8AbsOrRel is set to 1 (Relative). This parameter indicates the number of steps.
     *
     * @param u8Nsteps The value which will be set
     */
    inline void setU8Nsteps (uint8 u8Nsteps_);

    // API of field "u16PI"

    static const int kU16PI = 4;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     * This value is used if e8AbsOrRel is set to 0 (Absolute). This parameter is used to specify the absolute PI.
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     * This value is used if e8AbsOrRel is set to 0 (Absolute). This parameter is used to specify the absolute PI.
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 5;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * This value is used if e8AbsOrRel is set to 0 (Absolute). This parameter is used to specify the absolute Frequency.
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * This value is used if e8AbsOrRel is set to 0 (Absolute). This parameter is used to specify the absolute Frequency.
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    static const T_Tun_Set_PI &getDefaultInstance();

private:

    inline void set_has_u8AbsOrRel ();

    inline void clear_has_u8AbsOrRel ();

    inline void set_has_u8RelSteps ();

    inline void clear_has_u8RelSteps ();

    inline void set_has_u8Direction ();

    inline void clear_has_u8Direction ();

    inline void set_has_u8Nsteps ();

    inline void clear_has_u8Nsteps ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    uint32 _has_bits_[ (6 + 31) / 32];

    T_e8_Tun_Abs_Or_Rel _u8AbsOrRel;

    T_e8_Tun_Rel_Steps _u8RelSteps;

    T_e8_Tun_Direction _u8Direction;

    uint8 _u8Nsteps;

    uint16 _u16PI;

    uint32 _u32Frequency;

};

/**
 * Tuner static list elements are contained in this structure.
 */
class T_TunerStaticListElement {
public:

    /**
     * Default constructor
     */
    inline  T_TunerStaticListElement ();

    /**
     * Copy constructor
     */
    inline  T_TunerStaticListElement (const T_TunerStaticListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerStaticListElement (T_e8_Tun_ListID e8ListID_, uint8 u8ElementID_, bool bSelected_, uint32 u32Frequency_, const ::std::string& sPSName_, uint16 u16PI_, T_e8_Tun_SendernameInfo e8SendernameInfo_, uint8 u8TpTmcInfo_, uint32 u32PTY_, int8 s8LevelCompensation_, T_e8_Tun_ModulationType e8Modulation_, uint32 u32HDStationId_DRMServiceId_, const ::std::string& sHDCallSign_DRMServiceLabel_, T_e8_Tun_HD_TextEncodingType e8HDTextEncoding_, uint8 u8HDStationGenre_DRMPty_, uint8 u8HDAudioProgram_DRMShortID_, const ::std::string& StationLogo_, uint32 u32DRMServiceId_, const ::std::string& sDRMServiceLabel_, uint8 u8DRMPTY_, uint8 u8DRMServiceShortId_);

    /**
     * Destructor
     */
    inline  ~T_TunerStaticListElement();

    /**
     * Assignment operator
     */
    inline T_TunerStaticListElement& operator = (const T_TunerStaticListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerStaticListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerStaticListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerStaticListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerStaticListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListID"

    static const int kE8ListID = 0;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     * This parameter will be removed in coming releases
     *
     * @return The value of the field "e8ListID"
     */
    inline T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     * This parameter will be removed in coming releases
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (T_e8_Tun_ListID e8ListID_);

    // API of field "u8ElementID"

    static const int kU8ElementID = 1;

    /**
     * Clears the field "u8ElementID".
     *
     * The field will be set to its default value. The hasU8ElementID()
     * method will return false.
     */
    inline void clearU8ElementID();

    /**
     * Checks whether the field "u8ElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ElementID()). Otherwise it will return false.
     */
    inline bool hasU8ElementID () const;

    /**
     * Returns the value of the member "u8ElementID".
     *
     *
     *
     * @return The value of the field "u8ElementID"
     */
    inline uint8 getU8ElementID () const;

    /**
     * Sets the value of the member "u8ElementID".
     *
     *
     *
     * @param u8ElementID The value which will be set
     */
    inline void setU8ElementID (uint8 u8ElementID_);

    // API of field "bSelected"

    static const int kBSelected = 2;

    /**
     * Clears the field "bSelected".
     *
     * The field will be set to its default value. The hasBSelected()
     * method will return false.
     */
    inline void clearBSelected();

    /**
     * Checks whether the field "bSelected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSelected()). Otherwise it will return false.
     */
    inline bool hasBSelected () const;

    /**
     * Returns the value of the member "bSelected".
     *
     *
     *
     * @return The value of the field "bSelected"
     */
    inline bool getBSelected () const;

    /**
     * Sets the value of the member "bSelected".
     *
     *
     *
     * @param bSelected The value which will be set
     */
    inline void setBSelected (bool bSelected_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 3;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     *
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     *
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "sPSName"

    static const int kSPSName = 4;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPSName"
     */
    inline ::std::string* releaseSPSName();

    /**
     * Replace the field "sPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPSName (::std::string* sPSName_);

    // API of field "u16PI"

    static const int kU16PI = 5;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     *
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     *
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "e8SendernameInfo"

    static const int kE8SendernameInfo = 6;

    /**
     * Clears the field "e8SendernameInfo".
     *
     * The field will be set to its default value. The hasE8SendernameInfo()
     * method will return false.
     */
    inline void clearE8SendernameInfo();

    /**
     * Checks whether the field "e8SendernameInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SendernameInfo()). Otherwise it will return false.
     */
    inline bool hasE8SendernameInfo () const;

    /**
     * Returns the value of the member "e8SendernameInfo".
     *
     * Gives more info on station name
     *
     * @return The value of the field "e8SendernameInfo"
     */
    inline T_e8_Tun_SendernameInfo getE8SendernameInfo () const;

    /**
     * Sets the value of the member "e8SendernameInfo".
     *
     * Gives more info on station name
     *
     * @param e8SendernameInfo The value which will be set
     */
    inline void setE8SendernameInfo (T_e8_Tun_SendernameInfo e8SendernameInfo_);

    // API of field "u8TpTmcInfo"

    static const int kU8TpTmcInfo = 7;

    /**
     * Clears the field "u8TpTmcInfo".
     *
     * The field will be set to its default value. The hasU8TpTmcInfo()
     * method will return false.
     */
    inline void clearU8TpTmcInfo();

    /**
     * Checks whether the field "u8TpTmcInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TpTmcInfo()). Otherwise it will return false.
     */
    inline bool hasU8TpTmcInfo () const;

    /**
     * Returns the value of the member "u8TpTmcInfo".
     *
     *
     *
     * @return The value of the field "u8TpTmcInfo"
     */
    inline uint8 getU8TpTmcInfo () const;

    /**
     * Sets the value of the member "u8TpTmcInfo".
     *
     *
     *
     * @param u8TpTmcInfo The value which will be set
     */
    inline void setU8TpTmcInfo (uint8 u8TpTmcInfo_);

    // API of field "u32PTY"

    static const int kU32PTY = 8;

    /**
     * Clears the field "u32PTY".
     *
     * The field will be set to its default value. The hasU32PTY()
     * method will return false.
     */
    inline void clearU32PTY();

    /**
     * Checks whether the field "u32PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PTY()). Otherwise it will return false.
     */
    inline bool hasU32PTY () const;

    /**
     * Returns the value of the member "u32PTY".
     *
     *
     *
     * @return The value of the field "u32PTY"
     */
    inline uint32 getU32PTY () const;

    /**
     * Sets the value of the member "u32PTY".
     *
     *
     *
     * @param u32PTY The value which will be set
     */
    inline void setU32PTY (uint32 u32PTY_);

    // API of field "s8LevelCompensation"

    static const int kS8LevelCompensation = 9;

    /**
     * Clears the field "s8LevelCompensation".
     *
     * The field will be set to its default value. The hasS8LevelCompensation()
     * method will return false.
     */
    inline void clearS8LevelCompensation();

    /**
     * Checks whether the field "s8LevelCompensation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8LevelCompensation()). Otherwise it will return false.
     */
    inline bool hasS8LevelCompensation () const;

    /**
     * Returns the value of the member "s8LevelCompensation".
     *
     *
     *
     * @return The value of the field "s8LevelCompensation"
     */
    inline int8 getS8LevelCompensation () const;

    /**
     * Sets the value of the member "s8LevelCompensation".
     *
     *
     *
     * @param s8LevelCompensation The value which will be set
     */
    inline void setS8LevelCompensation (int8 s8LevelCompensation_);

    // API of field "e8Modulation"

    static const int kE8Modulation = 10;

    /**
     * Clears the field "e8Modulation".
     *
     * The field will be set to its default value. The hasE8Modulation()
     * method will return false.
     */
    inline void clearE8Modulation();

    /**
     * Checks whether the field "e8Modulation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Modulation()). Otherwise it will return false.
     */
    inline bool hasE8Modulation () const;

    /**
     * Returns the value of the member "e8Modulation".
     *
     * 0- AMFM, 1- HD, 2 - DRM
     *
     * @return The value of the field "e8Modulation"
     */
    inline T_e8_Tun_ModulationType getE8Modulation () const;

    /**
     * Sets the value of the member "e8Modulation".
     *
     * 0- AMFM, 1- HD, 2 - DRM
     *
     * @param e8Modulation The value which will be set
     */
    inline void setE8Modulation (T_e8_Tun_ModulationType e8Modulation_);

    // API of field "u32HDStationId_DRMServiceId"

    static const int kU32HDStationId_DRMServiceId = 11;

    /**
     * Clears the field "u32HDStationId_DRMServiceId".
     *
     * The field will be set to its default value. The hasU32HDStationId_DRMServiceId()
     * method will return false.
     */
    inline void clearU32HDStationId_DRMServiceId();

    /**
     * Checks whether the field "u32HDStationId_DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId_DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId_DRMServiceId () const;

    /**
     * Returns the value of the member "u32HDStationId_DRMServiceId".
     *
     *
     *
     * @return The value of the field "u32HDStationId_DRMServiceId"
     */
    inline uint32 getU32HDStationId_DRMServiceId () const;

    /**
     * Sets the value of the member "u32HDStationId_DRMServiceId".
     *
     *
     *
     * @param u32HDStationId_DRMServiceId The value which will be set
     */
    inline void setU32HDStationId_DRMServiceId (uint32 u32HDStationId_DRMServiceId_);

    // API of field "sHDCallSign_DRMServiceLabel"

    static const int kSHDCallSign_DRMServiceLabel = 12;

    /**
     * Clears the field "sHDCallSign_DRMServiceLabel".
     *
     * The field will be set to its default value. The hasSHDCallSign_DRMServiceLabel()
     * method will return false.
     */
    inline void clearSHDCallSign_DRMServiceLabel();

    /**
     * Checks whether the field "sHDCallSign_DRMServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDCallSign_DRMServiceLabel()). Otherwise it will return false.
     */
    inline bool hasSHDCallSign_DRMServiceLabel () const;

    /**
     * Returns the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * .
     *
     * @return The value of the field "sHDCallSign_DRMServiceLabel"
     */
    inline const ::std::string& getSHDCallSign_DRMServiceLabel () const;

    /**
     * Retrieves the value of the field "sHDCallSign_DRMServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDCallSign_DRMServiceLabel".
     */
    inline ::std::string& getSHDCallSign_DRMServiceLabelMutable ();

    /**
     * Sets the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * .
     *
     * @param sHDCallSign_DRMServiceLabel The value which will be set
     */
    inline void setSHDCallSign_DRMServiceLabel (const ::std::string& sHDCallSign_DRMServiceLabel_);

    /**
     * Sets the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * .
     *
     * @param sHDCallSign_DRMServiceLabel The value which will be set
     */
    inline void setSHDCallSign_DRMServiceLabel (const char* sHDCallSign_DRMServiceLabel_);

    /**
     * Sets the value of the member "sHDCallSign_DRMServiceLabel".
     *
     * .
     *
     * @param sHDCallSign_DRMServiceLabel The value which will be set
     */
    inline void setSHDCallSign_DRMServiceLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sHDCallSign_DRMServiceLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sHDCallSign_DRMServiceLabel"
     */
    inline ::std::string* releaseSHDCallSign_DRMServiceLabel();

    /**
     * Replace the field "sHDCallSign_DRMServiceLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSHDCallSign_DRMServiceLabel (::std::string* sHDCallSign_DRMServiceLabel_);

    // API of field "e8HDTextEncoding"

    static const int kE8HDTextEncoding = 13;

    /**
     * Clears the field "e8HDTextEncoding".
     *
     * The field will be set to its default value. The hasE8HDTextEncoding()
     * method will return false.
     */
    inline void clearE8HDTextEncoding();

    /**
     * Checks whether the field "e8HDTextEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDTextEncoding()). Otherwise it will return false.
     */
    inline bool hasE8HDTextEncoding () const;

    /**
     * Returns the value of the member "e8HDTextEncoding".
     *
     *
     *
     * @return The value of the field "e8HDTextEncoding"
     */
    inline T_e8_Tun_HD_TextEncodingType getE8HDTextEncoding () const;

    /**
     * Sets the value of the member "e8HDTextEncoding".
     *
     *
     *
     * @param e8HDTextEncoding The value which will be set
     */
    inline void setE8HDTextEncoding (T_e8_Tun_HD_TextEncodingType e8HDTextEncoding_);

    // API of field "u8HDStationGenre_DRMPty"

    static const int kU8HDStationGenre_DRMPty = 14;

    /**
     * Clears the field "u8HDStationGenre_DRMPty".
     *
     * The field will be set to its default value. The hasU8HDStationGenre_DRMPty()
     * method will return false.
     */
    inline void clearU8HDStationGenre_DRMPty();

    /**
     * Checks whether the field "u8HDStationGenre_DRMPty" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HDStationGenre_DRMPty()). Otherwise it will return false.
     */
    inline bool hasU8HDStationGenre_DRMPty () const;

    /**
     * Returns the value of the member "u8HDStationGenre_DRMPty".
     *
     *
     *
     * @return The value of the field "u8HDStationGenre_DRMPty"
     */
    inline uint8 getU8HDStationGenre_DRMPty () const;

    /**
     * Sets the value of the member "u8HDStationGenre_DRMPty".
     *
     *
     *
     * @param u8HDStationGenre_DRMPty The value which will be set
     */
    inline void setU8HDStationGenre_DRMPty (uint8 u8HDStationGenre_DRMPty_);

    // API of field "u8HDAudioProgram_DRMShortID"

    static const int kU8HDAudioProgram_DRMShortID = 15;

    /**
     * Clears the field "u8HDAudioProgram_DRMShortID".
     *
     * The field will be set to its default value. The hasU8HDAudioProgram_DRMShortID()
     * method will return false.
     */
    inline void clearU8HDAudioProgram_DRMShortID();

    /**
     * Checks whether the field "u8HDAudioProgram_DRMShortID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HDAudioProgram_DRMShortID()). Otherwise it will return false.
     */
    inline bool hasU8HDAudioProgram_DRMShortID () const;

    /**
     * Returns the value of the member "u8HDAudioProgram_DRMShortID".
     *
     *
     *
     * @return The value of the field "u8HDAudioProgram_DRMShortID"
     */
    inline uint8 getU8HDAudioProgram_DRMShortID () const;

    /**
     * Sets the value of the member "u8HDAudioProgram_DRMShortID".
     *
     *
     *
     * @param u8HDAudioProgram_DRMShortID The value which will be set
     */
    inline void setU8HDAudioProgram_DRMShortID (uint8 u8HDAudioProgram_DRMShortID_);

    // API of field "StationLogo"

    static const int kStationLogo = 16;

    /**
     * Clears the field "StationLogo".
     *
     * The field will be set to its default value. The hasStationLogo()
     * method will return false.
     */
    inline void clearStationLogo();

    /**
     * Checks whether the field "StationLogo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationLogo()). Otherwise it will return false.
     */
    inline bool hasStationLogo () const;

    /**
     * Returns the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @return The value of the field "StationLogo"
     */
    inline const ::std::string& getStationLogo () const;

    /**
     * Retrieves the value of the field "StationLogo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationLogo".
     */
    inline ::std::string& getStationLogoMutable ();

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const ::std::string& StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* value, size_t size);

    /**
     * Release the object stored in the field "StationLogo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "StationLogo"
     */
    inline ::std::string* releaseStationLogo();

    /**
     * Replace the field "StationLogo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStationLogo (::std::string* StationLogo_);

    // API of field "u32DRMServiceId"

    static const int kU32DRMServiceId = 17;

    /**
     * Clears the field "u32DRMServiceId".
     *
     * The field will be set to its default value. The hasU32DRMServiceId()
     * method will return false.
     */
    inline void clearU32DRMServiceId();

    /**
     * Checks whether the field "u32DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32DRMServiceId () const;

    /**
     * Returns the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32DRMServiceId"
     */
    inline uint32 getU32DRMServiceId () const;

    /**
     * Sets the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @param u32DRMServiceId The value which will be set
     */
    inline void setU32DRMServiceId (uint32 u32DRMServiceId_);

    // API of field "sDRMServiceLabel"

    static const int kSDRMServiceLabel = 18;

    /**
     * Clears the field "sDRMServiceLabel".
     *
     * The field will be set to its default value. The hasSDRMServiceLabel()
     * method will return false.
     */
    inline void clearSDRMServiceLabel();

    /**
     * Checks whether the field "sDRMServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMServiceLabel()). Otherwise it will return false.
     */
    inline bool hasSDRMServiceLabel () const;

    /**
     * Returns the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @return The value of the field "sDRMServiceLabel"
     */
    inline const ::std::string& getSDRMServiceLabel () const;

    /**
     * Retrieves the value of the field "sDRMServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMServiceLabel".
     */
    inline ::std::string& getSDRMServiceLabelMutable ();

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const ::std::string& sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sDRMServiceLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sDRMServiceLabel"
     */
    inline ::std::string* releaseSDRMServiceLabel();

    /**
     * Replace the field "sDRMServiceLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSDRMServiceLabel (::std::string* sDRMServiceLabel_);

    // API of field "u8DRMPTY"

    static const int kU8DRMPTY = 19;

    /**
     * Clears the field "u8DRMPTY".
     *
     * The field will be set to its default value. The hasU8DRMPTY()
     * method will return false.
     */
    inline void clearU8DRMPTY();

    /**
     * Checks whether the field "u8DRMPTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMPTY()). Otherwise it will return false.
     */
    inline bool hasU8DRMPTY () const;

    /**
     * Returns the value of the member "u8DRMPTY".
     *
     * If the meaning of "u8DRMPTY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMPTY"
     */
    inline uint8 getU8DRMPTY () const;

    /**
     * Sets the value of the member "u8DRMPTY".
     *
     * If the meaning of "u8DRMPTY" isn't clear, then there should be a description here.
     *
     * @param u8DRMPTY The value which will be set
     */
    inline void setU8DRMPTY (uint8 u8DRMPTY_);

    // API of field "u8DRMServiceShortId"

    static const int kU8DRMServiceShortId = 20;

    /**
     * Clears the field "u8DRMServiceShortId".
     *
     * The field will be set to its default value. The hasU8DRMServiceShortId()
     * method will return false.
     */
    inline void clearU8DRMServiceShortId();

    /**
     * Checks whether the field "u8DRMServiceShortId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMServiceShortId()). Otherwise it will return false.
     */
    inline bool hasU8DRMServiceShortId () const;

    /**
     * Returns the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMServiceShortId"
     */
    inline uint8 getU8DRMServiceShortId () const;

    /**
     * Sets the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @param u8DRMServiceShortId The value which will be set
     */
    inline void setU8DRMServiceShortId (uint8 u8DRMServiceShortId_);

    static const T_TunerStaticListElement &getDefaultInstance();

private:

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    inline void set_has_u8ElementID ();

    inline void clear_has_u8ElementID ();

    inline void set_has_bSelected ();

    inline void clear_has_bSelected ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_e8SendernameInfo ();

    inline void clear_has_e8SendernameInfo ();

    inline void set_has_u8TpTmcInfo ();

    inline void clear_has_u8TpTmcInfo ();

    inline void set_has_u32PTY ();

    inline void clear_has_u32PTY ();

    inline void set_has_s8LevelCompensation ();

    inline void clear_has_s8LevelCompensation ();

    inline void set_has_e8Modulation ();

    inline void clear_has_e8Modulation ();

    inline void set_has_u32HDStationId_DRMServiceId ();

    inline void clear_has_u32HDStationId_DRMServiceId ();

    inline void set_has_sHDCallSign_DRMServiceLabel ();

    inline void clear_has_sHDCallSign_DRMServiceLabel ();

    inline void set_has_e8HDTextEncoding ();

    inline void clear_has_e8HDTextEncoding ();

    inline void set_has_u8HDStationGenre_DRMPty ();

    inline void clear_has_u8HDStationGenre_DRMPty ();

    inline void set_has_u8HDAudioProgram_DRMShortID ();

    inline void clear_has_u8HDAudioProgram_DRMShortID ();

    inline void set_has_StationLogo ();

    inline void clear_has_StationLogo ();

    inline void set_has_u32DRMServiceId ();

    inline void clear_has_u32DRMServiceId ();

    inline void set_has_sDRMServiceLabel ();

    inline void clear_has_sDRMServiceLabel ();

    inline void set_has_u8DRMPTY ();

    inline void clear_has_u8DRMPTY ();

    inline void set_has_u8DRMServiceShortId ();

    inline void clear_has_u8DRMServiceShortId ();

    uint32 _has_bits_[ (21 + 31) / 32];

    T_e8_Tun_ListID _e8ListID;

    uint8 _u8ElementID;

    bool _bSelected;

    uint32 _u32Frequency;

    ::std::string* _sPSName;

    uint16 _u16PI;

    T_e8_Tun_SendernameInfo _e8SendernameInfo;

    uint8 _u8TpTmcInfo;

    uint32 _u32PTY;

    int8 _s8LevelCompensation;

    T_e8_Tun_ModulationType _e8Modulation;

    uint32 _u32HDStationId_DRMServiceId;

    ::std::string* _sHDCallSign_DRMServiceLabel;

    T_e8_Tun_HD_TextEncodingType _e8HDTextEncoding;

    uint8 _u8HDStationGenre_DRMPty;

    uint8 _u8HDAudioProgram_DRMShortID;

    ::std::string* _StationLogo;

    uint32 _u32DRMServiceId;

    ::std::string* _sDRMServiceLabel;

    uint8 _u8DRMPTY;

    uint8 _u8DRMServiceShortId;

};

/**
 * If the meaning of "T_TunerTestRoutineParameter" isn't clear, then there should be a description here.
 */
class T_TunerTestRoutineParameter {
public:

    /**
     * Default constructor
     */
    inline  T_TunerTestRoutineParameter ();

    /**
     * Copy constructor
     */
    inline  T_TunerTestRoutineParameter (const T_TunerTestRoutineParameter &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerTestRoutineParameter (T_e16_Tun_TroubleCode TroubleCode_, bool WriteToRM_, T_e8_Tun_MonitoringMode MonitoringMode_, T_e8_Tun_SupervisionControl SupervisionControl_);

    /**
     * Destructor
     */
    inline  ~T_TunerTestRoutineParameter();

    /**
     * Assignment operator
     */
    inline T_TunerTestRoutineParameter& operator = (const T_TunerTestRoutineParameter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerTestRoutineParameter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerTestRoutineParameter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerTestRoutineParameter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerTestRoutineParameter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCode"

    static const int kTroubleCode = 0;

    /**
     * Clears the field "TroubleCode".
     *
     * The field will be set to its default value. The hasTroubleCode()
     * method will return false.
     */
    inline void clearTroubleCode();

    /**
     * Checks whether the field "TroubleCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCode()). Otherwise it will return false.
     */
    inline bool hasTroubleCode () const;

    /**
     * Returns the value of the member "TroubleCode".
     *
     * Trouble codes for FM SEEK Test
     *
     * @return The value of the field "TroubleCode"
     */
    inline T_e16_Tun_TroubleCode getTroubleCode () const;

    /**
     * Sets the value of the member "TroubleCode".
     *
     * Trouble codes for FM SEEK Test
     *
     * @param TroubleCode The value which will be set
     */
    inline void setTroubleCode (T_e16_Tun_TroubleCode TroubleCode_);

    // API of field "WriteToRM"

    static const int kWriteToRM = 1;

    /**
     * Clears the field "WriteToRM".
     *
     * The field will be set to its default value. The hasWriteToRM()
     * method will return false.
     */
    inline void clearWriteToRM();

    /**
     * Checks whether the field "WriteToRM" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWriteToRM()). Otherwise it will return false.
     */
    inline bool hasWriteToRM () const;

    /**
     * Returns the value of the member "WriteToRM".
     *
     * It represents whether to the report error to memory or no.
     *
     * @return The value of the field "WriteToRM"
     */
    inline bool getWriteToRM () const;

    /**
     * Sets the value of the member "WriteToRM".
     *
     * It represents whether to the report error to memory or no.
     *
     * @param WriteToRM The value which will be set
     */
    inline void setWriteToRM (bool WriteToRM_);

    // API of field "MonitoringMode"

    static const int kMonitoringMode = 2;

    /**
     * Clears the field "MonitoringMode".
     *
     * The field will be set to its default value. The hasMonitoringMode()
     * method will return false.
     */
    inline void clearMonitoringMode();

    /**
     * Checks whether the field "MonitoringMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMonitoringMode()). Otherwise it will return false.
     */
    inline bool hasMonitoringMode () const;

    /**
     * Returns the value of the member "MonitoringMode".
     *
     * It controls the execution duration of the test routine.
     *
     * @return The value of the field "MonitoringMode"
     */
    inline T_e8_Tun_MonitoringMode getMonitoringMode () const;

    /**
     * Sets the value of the member "MonitoringMode".
     *
     * It controls the execution duration of the test routine.
     *
     * @param MonitoringMode The value which will be set
     */
    inline void setMonitoringMode (T_e8_Tun_MonitoringMode MonitoringMode_);

    // API of field "SupervisionControl"

    static const int kSupervisionControl = 3;

    /**
     * Clears the field "SupervisionControl".
     *
     * The field will be set to its default value. The hasSupervisionControl()
     * method will return false.
     */
    inline void clearSupervisionControl();

    /**
     * Checks whether the field "SupervisionControl" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSupervisionControl()). Otherwise it will return false.
     */
    inline bool hasSupervisionControl () const;

    /**
     * Returns the value of the member "SupervisionControl".
     *
     * Supervision of the Test.
     *
     * @return The value of the field "SupervisionControl"
     */
    inline T_e8_Tun_SupervisionControl getSupervisionControl () const;

    /**
     * Sets the value of the member "SupervisionControl".
     *
     * Supervision of the Test.
     *
     * @param SupervisionControl The value which will be set
     */
    inline void setSupervisionControl (T_e8_Tun_SupervisionControl SupervisionControl_);

    static const T_TunerTestRoutineParameter &getDefaultInstance();

private:

    inline void set_has_TroubleCode ();

    inline void clear_has_TroubleCode ();

    inline void set_has_WriteToRM ();

    inline void clear_has_WriteToRM ();

    inline void set_has_MonitoringMode ();

    inline void clear_has_MonitoringMode ();

    inline void set_has_SupervisionControl ();

    inline void clear_has_SupervisionControl ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e16_Tun_TroubleCode _TroubleCode;

    bool _WriteToRM;

    T_e8_Tun_MonitoringMode _MonitoringMode;

    T_e8_Tun_SupervisionControl _SupervisionControl;

};

/**
 * The TroubleCodeStatus contains information about the status of the trouble code.
 */
class T_Tun_TestTroubleCodeStatus {
public:

    /**
     * Default constructor
     */
    inline  T_Tun_TestTroubleCodeStatus ();

    /**
     * Copy constructor
     */
    inline  T_Tun_TestTroubleCodeStatus (const T_Tun_TestTroubleCodeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_Tun_TestTroubleCodeStatus (T_e16_Tun_TroubleCode TroubleCode_, T_e8_Tun_ErrorStatus ErrorStatus_, T_e8_Tun_RoutineStatus RoutineStatus_);

    /**
     * Destructor
     */
    inline  ~T_Tun_TestTroubleCodeStatus();

    /**
     * Assignment operator
     */
    inline T_Tun_TestTroubleCodeStatus& operator = (const T_Tun_TestTroubleCodeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Tun_TestTroubleCodeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Tun_TestTroubleCodeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Tun_TestTroubleCodeStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Tun_TestTroubleCodeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCode"

    static const int kTroubleCode = 0;

    /**
     * Clears the field "TroubleCode".
     *
     * The field will be set to its default value. The hasTroubleCode()
     * method will return false.
     */
    inline void clearTroubleCode();

    /**
     * Checks whether the field "TroubleCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCode()). Otherwise it will return false.
     */
    inline bool hasTroubleCode () const;

    /**
     * Returns the value of the member "TroubleCode".
     *
     * TroubleCode whose result has come
     *
     * @return The value of the field "TroubleCode"
     */
    inline T_e16_Tun_TroubleCode getTroubleCode () const;

    /**
     * Sets the value of the member "TroubleCode".
     *
     * TroubleCode whose result has come
     *
     * @param TroubleCode The value which will be set
     */
    inline void setTroubleCode (T_e16_Tun_TroubleCode TroubleCode_);

    // API of field "ErrorStatus"

    static const int kErrorStatus = 1;

    /**
     * Clears the field "ErrorStatus".
     *
     * The field will be set to its default value. The hasErrorStatus()
     * method will return false.
     */
    inline void clearErrorStatus();

    /**
     * Checks whether the field "ErrorStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorStatus()). Otherwise it will return false.
     */
    inline bool hasErrorStatus () const;

    /**
     * Returns the value of the member "ErrorStatus".
     *
     * Status of a TroubleCode
     *
     * @return The value of the field "ErrorStatus"
     */
    inline T_e8_Tun_ErrorStatus getErrorStatus () const;

    /**
     * Sets the value of the member "ErrorStatus".
     *
     * Status of a TroubleCode
     *
     * @param ErrorStatus The value which will be set
     */
    inline void setErrorStatus (T_e8_Tun_ErrorStatus ErrorStatus_);

    // API of field "RoutineStatus"

    static const int kRoutineStatus = 2;

    /**
     * Clears the field "RoutineStatus".
     *
     * The field will be set to its default value. The hasRoutineStatus()
     * method will return false.
     */
    inline void clearRoutineStatus();

    /**
     * Checks whether the field "RoutineStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRoutineStatus()). Otherwise it will return false.
     */
    inline bool hasRoutineStatus () const;

    /**
     * Returns the value of the member "RoutineStatus".
     *
     * Status of test routine
     *
     * @return The value of the field "RoutineStatus"
     */
    inline T_e8_Tun_RoutineStatus getRoutineStatus () const;

    /**
     * Sets the value of the member "RoutineStatus".
     *
     * Status of test routine
     *
     * @param RoutineStatus The value which will be set
     */
    inline void setRoutineStatus (T_e8_Tun_RoutineStatus RoutineStatus_);

    static const T_Tun_TestTroubleCodeStatus &getDefaultInstance();

private:

    inline void set_has_TroubleCode ();

    inline void clear_has_TroubleCode ();

    inline void set_has_ErrorStatus ();

    inline void clear_has_ErrorStatus ();

    inline void set_has_RoutineStatus ();

    inline void clear_has_RoutineStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e16_Tun_TroubleCode _TroubleCode;

    T_e8_Tun_ErrorStatus _ErrorStatus;

    T_e8_Tun_RoutineStatus _RoutineStatus;

};

/**
 * .
 */
class T_TunerFieldstrength {
public:

    /**
     * Default constructor
     */
    inline  T_TunerFieldstrength ();

    /**
     * Copy constructor
     */
    inline  T_TunerFieldstrength (const T_TunerFieldstrength &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerFieldstrength (uint8 u8Band_, uint32 u32Frequency_);

    /**
     * Destructor
     */
    inline  ~T_TunerFieldstrength();

    /**
     * Assignment operator
     */
    inline T_TunerFieldstrength& operator = (const T_TunerFieldstrength& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerFieldstrength& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerFieldstrength& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerFieldstrength& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerFieldstrength& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Band"

    static const int kU8Band = 0;

    /**
     * Clears the field "u8Band".
     *
     * The field will be set to its default value. The hasU8Band()
     * method will return false.
     */
    inline void clearU8Band();

    /**
     * Checks whether the field "u8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Band()). Otherwise it will return false.
     */
    inline bool hasU8Band () const;

    /**
     * Returns the value of the member "u8Band".
     *
     * Band of the Signal.
     *
     * @return The value of the field "u8Band"
     */
    inline uint8 getU8Band () const;

    /**
     * Sets the value of the member "u8Band".
     *
     * Band of the Signal.
     *
     * @param u8Band The value which will be set
     */
    inline void setU8Band (uint8 u8Band_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 1;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Frequency of the signal
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Frequency of the signal
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    static const T_TunerFieldstrength &getDefaultInstance();

private:

    inline void set_has_u8Band ();

    inline void clear_has_u8Band ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Band;

    uint32 _u32Frequency;

};

/**
 * Tuner Radio Text data is contained in this structure .
 */
class T_TunerRadioText {
public:

    /**
     * Default constructor
     */
    inline  T_TunerRadioText ();

    /**
     * Copy constructor
     */
    inline  T_TunerRadioText (const T_TunerRadioText &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerRadioText (T_e8_Tun_TunerHeader u8TunerHeader_, T_e8_Tun_Source u8TunerSource_, uint8 u8TextType_, const ::std::string& sRadioTextData_);

    /**
     * Destructor
     */
    inline  ~T_TunerRadioText();

    /**
     * Assignment operator
     */
    inline T_TunerRadioText& operator = (const T_TunerRadioText& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerRadioText& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerRadioText& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerRadioText& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerRadioText& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * .
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * .
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u8TunerSource"

    static const int kU8TunerSource = 1;

    /**
     * Clears the field "u8TunerSource".
     *
     * The field will be set to its default value. The hasU8TunerSource()
     * method will return false.
     */
    inline void clearU8TunerSource();

    /**
     * Checks whether the field "u8TunerSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerSource()). Otherwise it will return false.
     */
    inline bool hasU8TunerSource () const;

    /**
     * Returns the value of the member "u8TunerSource".
     *
     * .
     *
     * @return The value of the field "u8TunerSource"
     */
    inline T_e8_Tun_Source getU8TunerSource () const;

    /**
     * Sets the value of the member "u8TunerSource".
     *
     * .
     *
     * @param u8TunerSource The value which will be set
     */
    inline void setU8TunerSource (T_e8_Tun_Source u8TunerSource_);

    // API of field "u8TextType"

    static const int kU8TextType = 2;

    /**
     * Clears the field "u8TextType".
     *
     * The field will be set to its default value. The hasU8TextType()
     * method will return false.
     */
    inline void clearU8TextType();

    /**
     * Checks whether the field "u8TextType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TextType()). Otherwise it will return false.
     */
    inline bool hasU8TextType () const;

    /**
     * Returns the value of the member "u8TextType".
     *
     * Type A = 0, Type B = 1, With change from type A to type B
     * or vice versa clear the R-Text message in display.
     *
     * @return The value of the field "u8TextType"
     */
    inline uint8 getU8TextType () const;

    /**
     * Sets the value of the member "u8TextType".
     *
     * Type A = 0, Type B = 1, With change from type A to type B
     * or vice versa clear the R-Text message in display.
     *
     * @param u8TextType The value which will be set
     */
    inline void setU8TextType (uint8 u8TextType_);

    // API of field "sRadioTextData"

    static const int kSRadioTextData = 3;

    /**
     * Clears the field "sRadioTextData".
     *
     * The field will be set to its default value. The hasSRadioTextData()
     * method will return false.
     */
    inline void clearSRadioTextData();

    /**
     * Checks whether the field "sRadioTextData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSRadioTextData()). Otherwise it will return false.
     */
    inline bool hasSRadioTextData () const;

    /**
     * Returns the value of the member "sRadioTextData".
     *
     * Gives the Radio Text data in UTF8 Format. Max Length: 64
     *
     * @return The value of the field "sRadioTextData"
     */
    inline const ::std::string& getSRadioTextData () const;

    /**
     * Retrieves the value of the field "sRadioTextData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sRadioTextData".
     */
    inline ::std::string& getSRadioTextDataMutable ();

    /**
     * Sets the value of the member "sRadioTextData".
     *
     * Gives the Radio Text data in UTF8 Format. Max Length: 64
     *
     * @param sRadioTextData The value which will be set
     */
    inline void setSRadioTextData (const ::std::string& sRadioTextData_);

    /**
     * Sets the value of the member "sRadioTextData".
     *
     * Gives the Radio Text data in UTF8 Format. Max Length: 64
     *
     * @param sRadioTextData The value which will be set
     */
    inline void setSRadioTextData (const char* sRadioTextData_);

    /**
     * Sets the value of the member "sRadioTextData".
     *
     * Gives the Radio Text data in UTF8 Format. Max Length: 64
     *
     * @param sRadioTextData The value which will be set
     */
    inline void setSRadioTextData (const char* value, size_t size);

    /**
     * Release the object stored in the field "sRadioTextData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sRadioTextData"
     */
    inline ::std::string* releaseSRadioTextData();

    /**
     * Replace the field "sRadioTextData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSRadioTextData (::std::string* sRadioTextData_);

    static const T_TunerRadioText &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u8TunerSource ();

    inline void clear_has_u8TunerSource ();

    inline void set_has_u8TextType ();

    inline void clear_has_u8TextType ();

    inline void set_has_sRadioTextData ();

    inline void clear_has_sRadioTextData ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    T_e8_Tun_Source _u8TunerSource;

    uint8 _u8TextType;

    ::std::string* _sRadioTextData;

};

/**
 * Tuner Band and station info are sent together. Info sent together
 * is used for synchronisation purposes.
 */
class T_TunerBandAndStationInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TunerBandAndStationInfo ();

    /**
     * Copy constructor
     */
    inline  T_TunerBandAndStationInfo (const T_TunerBandAndStationInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerBandAndStationInfo (T_e8_Tun_TunerBand e8Band_, uint32 u32Frequency_, uint16 u16PI_, const ::std::string& sPSName_, uint16 u16StaticListElementID_, const ::std::string& sHDCallSign_, uint32 u32HDStationId_, T_e8_Tun_HDAudioProgram e8HDAudioProgram_, uint8 u8PresetAutocompare_, const ::std::string& sDRMServiceLabel_, uint32 u32DRMServiceId_, uint8 u8DRMServiceShortId_);

    /**
     * Destructor
     */
    inline  ~T_TunerBandAndStationInfo();

    /**
     * Assignment operator
     */
    inline T_TunerBandAndStationInfo& operator = (const T_TunerBandAndStationInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerBandAndStationInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerBandAndStationInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerBandAndStationInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerBandAndStationInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Band"

    static const int kE8Band = 0;

    /**
     * Clears the field "e8Band".
     *
     * The field will be set to its default value. The hasE8Band()
     * method will return false.
     */
    inline void clearE8Band();

    /**
     * Checks whether the field "e8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Band()). Otherwise it will return false.
     */
    inline bool hasE8Band () const;

    /**
     * Returns the value of the member "e8Band".
     *
     *
     *
     * @return The value of the field "e8Band"
     */
    inline T_e8_Tun_TunerBand getE8Band () const;

    /**
     * Sets the value of the member "e8Band".
     *
     *
     *
     * @param e8Band The value which will be set
     */
    inline void setE8Band (T_e8_Tun_TunerBand e8Band_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 1;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * .
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * .
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u16PI"

    static const int kU16PI = 2;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     * .
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     * .
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "sPSName"

    static const int kSPSName = 3;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPSName"
     */
    inline ::std::string* releaseSPSName();

    /**
     * Replace the field "sPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPSName (::std::string* sPSName_);

    // API of field "u16StaticListElementID"

    static const int kU16StaticListElementID = 4;

    /**
     * Clears the field "u16StaticListElementID".
     *
     * The field will be set to its default value. The hasU16StaticListElementID()
     * method will return false.
     */
    inline void clearU16StaticListElementID();

    /**
     * Checks whether the field "u16StaticListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16StaticListElementID()). Otherwise it will return false.
     */
    inline bool hasU16StaticListElementID () const;

    /**
     * Returns the value of the member "u16StaticListElementID".
     *
     * .
     *
     * @return The value of the field "u16StaticListElementID"
     */
    inline uint16 getU16StaticListElementID () const;

    /**
     * Sets the value of the member "u16StaticListElementID".
     *
     * .
     *
     * @param u16StaticListElementID The value which will be set
     */
    inline void setU16StaticListElementID (uint16 u16StaticListElementID_);

    // API of field "sHDCallSign"

    static const int kSHDCallSign = 5;

    /**
     * Clears the field "sHDCallSign".
     *
     * The field will be set to its default value. The hasSHDCallSign()
     * method will return false.
     */
    inline void clearSHDCallSign();

    /**
     * Checks whether the field "sHDCallSign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDCallSign()). Otherwise it will return false.
     */
    inline bool hasSHDCallSign () const;

    /**
     * Returns the value of the member "sHDCallSign".
     *
     * Gives HD Call Sign string
     *
     * @return The value of the field "sHDCallSign"
     */
    inline const ::std::string& getSHDCallSign () const;

    /**
     * Retrieves the value of the field "sHDCallSign" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDCallSign".
     */
    inline ::std::string& getSHDCallSignMutable ();

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Gives HD Call Sign string
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const ::std::string& sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Gives HD Call Sign string
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Gives HD Call Sign string
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* value, size_t size);

    /**
     * Release the object stored in the field "sHDCallSign".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sHDCallSign"
     */
    inline ::std::string* releaseSHDCallSign();

    /**
     * Replace the field "sHDCallSign".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSHDCallSign (::std::string* sHDCallSign_);

    // API of field "u32HDStationId"

    static const int kU32HDStationId = 6;

    /**
     * Clears the field "u32HDStationId".
     *
     * The field will be set to its default value. The hasU32HDStationId()
     * method will return false.
     */
    inline void clearU32HDStationId();

    /**
     * Checks whether the field "u32HDStationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId () const;

    /**
     * Returns the value of the member "u32HDStationId".
     *
     * .
     *
     * @return The value of the field "u32HDStationId"
     */
    inline uint32 getU32HDStationId () const;

    /**
     * Sets the value of the member "u32HDStationId".
     *
     * .
     *
     * @param u32HDStationId The value which will be set
     */
    inline void setU32HDStationId (uint32 u32HDStationId_);

    // API of field "e8HDAudioProgram"

    static const int kE8HDAudioProgram = 7;

    /**
     * Clears the field "e8HDAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDAudioProgram()
     * method will return false.
     */
    inline void clearE8HDAudioProgram();

    /**
     * Checks whether the field "e8HDAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioProgram () const;

    /**
     * Returns the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @return The value of the field "e8HDAudioProgram"
     */
    inline T_e8_Tun_HDAudioProgram getE8HDAudioProgram () const;

    /**
     * Sets the value of the member "e8HDAudioProgram".
     *
     *
     *
     * @param e8HDAudioProgram The value which will be set
     */
    inline void setE8HDAudioProgram (T_e8_Tun_HDAudioProgram e8HDAudioProgram_);

    // API of field "u8PresetAutocompare"

    static const int kU8PresetAutocompare = 8;

    /**
     * Clears the field "u8PresetAutocompare".
     *
     * The field will be set to its default value. The hasU8PresetAutocompare()
     * method will return false.
     */
    inline void clearU8PresetAutocompare();

    /**
     * Checks whether the field "u8PresetAutocompare" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetAutocompare()). Otherwise it will return false.
     */
    inline bool hasU8PresetAutocompare () const;

    /**
     * Returns the value of the member "u8PresetAutocompare".
     *
     * .
     *
     * @return The value of the field "u8PresetAutocompare"
     */
    inline uint8 getU8PresetAutocompare () const;

    /**
     * Sets the value of the member "u8PresetAutocompare".
     *
     * .
     *
     * @param u8PresetAutocompare The value which will be set
     */
    inline void setU8PresetAutocompare (uint8 u8PresetAutocompare_);

    // API of field "sDRMServiceLabel"

    static const int kSDRMServiceLabel = 9;

    /**
     * Clears the field "sDRMServiceLabel".
     *
     * The field will be set to its default value. The hasSDRMServiceLabel()
     * method will return false.
     */
    inline void clearSDRMServiceLabel();

    /**
     * Checks whether the field "sDRMServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMServiceLabel()). Otherwise it will return false.
     */
    inline bool hasSDRMServiceLabel () const;

    /**
     * Returns the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @return The value of the field "sDRMServiceLabel"
     */
    inline const ::std::string& getSDRMServiceLabel () const;

    /**
     * Retrieves the value of the field "sDRMServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMServiceLabel".
     */
    inline ::std::string& getSDRMServiceLabelMutable ();

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const ::std::string& sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * Gives the DRMServiceLabel
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sDRMServiceLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sDRMServiceLabel"
     */
    inline ::std::string* releaseSDRMServiceLabel();

    /**
     * Replace the field "sDRMServiceLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSDRMServiceLabel (::std::string* sDRMServiceLabel_);

    // API of field "u32DRMServiceId"

    static const int kU32DRMServiceId = 10;

    /**
     * Clears the field "u32DRMServiceId".
     *
     * The field will be set to its default value. The hasU32DRMServiceId()
     * method will return false.
     */
    inline void clearU32DRMServiceId();

    /**
     * Checks whether the field "u32DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32DRMServiceId () const;

    /**
     * Returns the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32DRMServiceId"
     */
    inline uint32 getU32DRMServiceId () const;

    /**
     * Sets the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @param u32DRMServiceId The value which will be set
     */
    inline void setU32DRMServiceId (uint32 u32DRMServiceId_);

    // API of field "u8DRMServiceShortId"

    static const int kU8DRMServiceShortId = 11;

    /**
     * Clears the field "u8DRMServiceShortId".
     *
     * The field will be set to its default value. The hasU8DRMServiceShortId()
     * method will return false.
     */
    inline void clearU8DRMServiceShortId();

    /**
     * Checks whether the field "u8DRMServiceShortId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMServiceShortId()). Otherwise it will return false.
     */
    inline bool hasU8DRMServiceShortId () const;

    /**
     * Returns the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMServiceShortId"
     */
    inline uint8 getU8DRMServiceShortId () const;

    /**
     * Sets the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @param u8DRMServiceShortId The value which will be set
     */
    inline void setU8DRMServiceShortId (uint8 u8DRMServiceShortId_);

    static const T_TunerBandAndStationInfo &getDefaultInstance();

private:

    inline void set_has_e8Band ();

    inline void clear_has_e8Band ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    inline void set_has_u16StaticListElementID ();

    inline void clear_has_u16StaticListElementID ();

    inline void set_has_sHDCallSign ();

    inline void clear_has_sHDCallSign ();

    inline void set_has_u32HDStationId ();

    inline void clear_has_u32HDStationId ();

    inline void set_has_e8HDAudioProgram ();

    inline void clear_has_e8HDAudioProgram ();

    inline void set_has_u8PresetAutocompare ();

    inline void clear_has_u8PresetAutocompare ();

    inline void set_has_sDRMServiceLabel ();

    inline void clear_has_sDRMServiceLabel ();

    inline void set_has_u32DRMServiceId ();

    inline void clear_has_u32DRMServiceId ();

    inline void set_has_u8DRMServiceShortId ();

    inline void clear_has_u8DRMServiceShortId ();

    uint32 _has_bits_[ (12 + 31) / 32];

    T_e8_Tun_TunerBand _e8Band;

    uint32 _u32Frequency;

    uint16 _u16PI;

    ::std::string* _sPSName;

    uint16 _u16StaticListElementID;

    ::std::string* _sHDCallSign;

    uint32 _u32HDStationId;

    T_e8_Tun_HDAudioProgram _e8HDAudioProgram;

    uint8 _u8PresetAutocompare;

    ::std::string* _sDRMServiceLabel;

    uint32 _u32DRMServiceId;

    uint8 _u8DRMServiceShortId;

};

/**
 * If the meaning of "T_Tun_AutoCompParam" isn't clear, then there should be a description here.
 */
class T_Tun_AutoCompParam {
public:

    /**
     * Default constructor
     */
    inline  T_Tun_AutoCompParam ();

    /**
     * Copy constructor
     */
    inline  T_Tun_AutoCompParam (const T_Tun_AutoCompParam &rhs);

    /**
     * All fields constructor
     */
    inline  T_Tun_AutoCompParam (uint8 u8FirstElemId_, uint8 u8LastElemID_, T_e8_Tun_Autocompare_Mode u8Mode_);

    /**
     * Destructor
     */
    inline  ~T_Tun_AutoCompParam();

    /**
     * Assignment operator
     */
    inline T_Tun_AutoCompParam& operator = (const T_Tun_AutoCompParam& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Tun_AutoCompParam& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Tun_AutoCompParam& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Tun_AutoCompParam& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Tun_AutoCompParam& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8FirstElemId"

    static const int kU8FirstElemId = 0;

    /**
     * Clears the field "u8FirstElemId".
     *
     * The field will be set to its default value. The hasU8FirstElemId()
     * method will return false.
     */
    inline void clearU8FirstElemId();

    /**
     * Checks whether the field "u8FirstElemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FirstElemId()). Otherwise it will return false.
     */
    inline bool hasU8FirstElemId () const;

    /**
     * Returns the value of the member "u8FirstElemId".
     *
     * This parameter is used to set the First element ID for the preset
     * list of FM1,FM2 or AM.
     *
     * @return The value of the field "u8FirstElemId"
     */
    inline uint8 getU8FirstElemId () const;

    /**
     * Sets the value of the member "u8FirstElemId".
     *
     * This parameter is used to set the First element ID for the preset
     * list of FM1,FM2 or AM.
     *
     * @param u8FirstElemId The value which will be set
     */
    inline void setU8FirstElemId (uint8 u8FirstElemId_);

    // API of field "u8LastElemID"

    static const int kU8LastElemID = 1;

    /**
     * Clears the field "u8LastElemID".
     *
     * The field will be set to its default value. The hasU8LastElemID()
     * method will return false.
     */
    inline void clearU8LastElemID();

    /**
     * Checks whether the field "u8LastElemID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LastElemID()). Otherwise it will return false.
     */
    inline bool hasU8LastElemID () const;

    /**
     * Returns the value of the member "u8LastElemID".
     *
     * This parameter is used to the last element ID for the preset list
     * of FM1, FM2 or AM.
     *
     * @return The value of the field "u8LastElemID"
     */
    inline uint8 getU8LastElemID () const;

    /**
     * Sets the value of the member "u8LastElemID".
     *
     * This parameter is used to the last element ID for the preset list
     * of FM1, FM2 or AM.
     *
     * @param u8LastElemID The value which will be set
     */
    inline void setU8LastElemID (uint8 u8LastElemID_);

    // API of field "u8Mode"

    static const int kU8Mode = 2;

    /**
     * Clears the field "u8Mode".
     *
     * The field will be set to its default value. The hasU8Mode()
     * method will return false.
     */
    inline void clearU8Mode();

    /**
     * Checks whether the field "u8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Mode()). Otherwise it will return false.
     */
    inline bool hasU8Mode () const;

    /**
     * Returns the value of the member "u8Mode".
     *
     * This parameter is used when there same station is store at 2
     * different position in preset list. If the station appears in 2 different
     * Band range then either the Preset ID of the selected band will be used or the
     * First preset element ID will be used.
     *
     * @return The value of the field "u8Mode"
     */
    inline T_e8_Tun_Autocompare_Mode getU8Mode () const;

    /**
     * Sets the value of the member "u8Mode".
     *
     * This parameter is used when there same station is store at 2
     * different position in preset list. If the station appears in 2 different
     * Band range then either the Preset ID of the selected band will be used or the
     * First preset element ID will be used.
     *
     * @param u8Mode The value which will be set
     */
    inline void setU8Mode (T_e8_Tun_Autocompare_Mode u8Mode_);

    static const T_Tun_AutoCompParam &getDefaultInstance();

private:

    inline void set_has_u8FirstElemId ();

    inline void clear_has_u8FirstElemId ();

    inline void set_has_u8LastElemID ();

    inline void clear_has_u8LastElemID ();

    inline void set_has_u8Mode ();

    inline void clear_has_u8Mode ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8FirstElemId;

    uint8 _u8LastElemID;

    T_e8_Tun_Autocompare_Mode _u8Mode;

};

/**
 * If the meaning of "T_Component_Status" isn't clear, then there should be a description here.
 */
class T_Component_Status {
public:

    /**
     * Default constructor
     */
    inline  T_Component_Status ();

    /**
     * Copy constructor
     */
    inline  T_Component_Status (const T_Component_Status &rhs);

    /**
     * All fields constructor
     */
    inline  T_Component_Status (uint8 u8AudioSinkTUN1_, uint8 u8BGModeTuner_);

    /**
     * Destructor
     */
    inline  ~T_Component_Status();

    /**
     * Assignment operator
     */
    inline T_Component_Status& operator = (const T_Component_Status& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Component_Status& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Component_Status& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Component_Status& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Component_Status& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8AudioSinkTUN1"

    static const int kU8AudioSinkTUN1 = 0;

    /**
     * Clears the field "u8AudioSinkTUN1".
     *
     * The field will be set to its default value. The hasU8AudioSinkTUN1()
     * method will return false.
     */
    inline void clearU8AudioSinkTUN1();

    /**
     * Checks whether the field "u8AudioSinkTUN1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioSinkTUN1()). Otherwise it will return false.
     */
    inline bool hasU8AudioSinkTUN1 () const;

    /**
     * Returns the value of the member "u8AudioSinkTUN1".
     *
     * If the meaning of "u8AudioSinkTUN1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8AudioSinkTUN1"
     */
    inline uint8 getU8AudioSinkTUN1 () const;

    /**
     * Sets the value of the member "u8AudioSinkTUN1".
     *
     * If the meaning of "u8AudioSinkTUN1" isn't clear, then there should be a description here.
     *
     * @param u8AudioSinkTUN1 The value which will be set
     */
    inline void setU8AudioSinkTUN1 (uint8 u8AudioSinkTUN1_);

    // API of field "u8BGModeTuner"

    static const int kU8BGModeTuner = 1;

    /**
     * Clears the field "u8BGModeTuner".
     *
     * The field will be set to its default value. The hasU8BGModeTuner()
     * method will return false.
     */
    inline void clearU8BGModeTuner();

    /**
     * Checks whether the field "u8BGModeTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BGModeTuner()). Otherwise it will return false.
     */
    inline bool hasU8BGModeTuner () const;

    /**
     * Returns the value of the member "u8BGModeTuner".
     *
     * If the meaning of "u8BGModeTuner" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8BGModeTuner"
     */
    inline uint8 getU8BGModeTuner () const;

    /**
     * Sets the value of the member "u8BGModeTuner".
     *
     * If the meaning of "u8BGModeTuner" isn't clear, then there should be a description here.
     *
     * @param u8BGModeTuner The value which will be set
     */
    inline void setU8BGModeTuner (uint8 u8BGModeTuner_);

    static const T_Component_Status &getDefaultInstance();

private:

    inline void set_has_u8AudioSinkTUN1 ();

    inline void clear_has_u8AudioSinkTUN1 ();

    inline void set_has_u8BGModeTuner ();

    inline void clear_has_u8BGModeTuner ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8AudioSinkTUN1;

    uint8 _u8BGModeTuner;

};

/**
 * HD modulation and decoding information
 */
class T_b8_Tun_HDInfoBits {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_HDInfoBits ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_HDInfoBits (const T_b8_Tun_HDInfoBits &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_HDInfoBits (bool HD_MODULATION_DETECTION, bool HD_DATA_DECODING, bool HD_AUDIO_DECODING, bool HD_BLEND_ANALOG, bool HD_DIGITAL_AUDIO_MUTE, bool HD_BALLGAME_MODE, bool RESERVED_1, bool RESERVED_2);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_HDInfoBits& operator = (const T_b8_Tun_HDInfoBits& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_HDInfoBits& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_HDInfoBits& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_HDInfoBits& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_HDInfoBits& rhs) const;

    /**
     * Sets the value of the member "HD_MODULATION_DETECTION".
     *
     * If the meaning of "HD_MODULATION_DETECTION" isn't clear, then there should be a description here.
     *
     * @param HD_MODULATION_DETECTION The value which will be set
     */
    inline void setHD_MODULATION_DETECTION (bool HD_MODULATION_DETECTION);

    /**
     * Returns the value of the member "HD_MODULATION_DETECTION".
     *
     * If the meaning of "HD_MODULATION_DETECTION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_MODULATION_DETECTION"
     */
    inline bool getHD_MODULATION_DETECTION () const;

    /**
     * Sets the value of the member "HD_DATA_DECODING".
     *
     * If the meaning of "HD_DATA_DECODING" isn't clear, then there should be a description here.
     *
     * @param HD_DATA_DECODING The value which will be set
     */
    inline void setHD_DATA_DECODING (bool HD_DATA_DECODING);

    /**
     * Returns the value of the member "HD_DATA_DECODING".
     *
     * If the meaning of "HD_DATA_DECODING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_DATA_DECODING"
     */
    inline bool getHD_DATA_DECODING () const;

    /**
     * Sets the value of the member "HD_AUDIO_DECODING".
     *
     * If the meaning of "HD_AUDIO_DECODING" isn't clear, then there should be a description here.
     *
     * @param HD_AUDIO_DECODING The value which will be set
     */
    inline void setHD_AUDIO_DECODING (bool HD_AUDIO_DECODING);

    /**
     * Returns the value of the member "HD_AUDIO_DECODING".
     *
     * If the meaning of "HD_AUDIO_DECODING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_AUDIO_DECODING"
     */
    inline bool getHD_AUDIO_DECODING () const;

    /**
     * Sets the value of the member "HD_BLEND_ANALOG".
     *
     * If the meaning of "HD_BLEND_ANALOG" isn't clear, then there should be a description here.
     *
     * @param HD_BLEND_ANALOG The value which will be set
     */
    inline void setHD_BLEND_ANALOG (bool HD_BLEND_ANALOG);

    /**
     * Returns the value of the member "HD_BLEND_ANALOG".
     *
     * If the meaning of "HD_BLEND_ANALOG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_BLEND_ANALOG"
     */
    inline bool getHD_BLEND_ANALOG () const;

    /**
     * Sets the value of the member "HD_DIGITAL_AUDIO_MUTE".
     *
     * If the meaning of "HD_DIGITAL_AUDIO_MUTE" isn't clear, then there should be a description here.
     *
     * @param HD_DIGITAL_AUDIO_MUTE The value which will be set
     */
    inline void setHD_DIGITAL_AUDIO_MUTE (bool HD_DIGITAL_AUDIO_MUTE);

    /**
     * Returns the value of the member "HD_DIGITAL_AUDIO_MUTE".
     *
     * If the meaning of "HD_DIGITAL_AUDIO_MUTE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_DIGITAL_AUDIO_MUTE"
     */
    inline bool getHD_DIGITAL_AUDIO_MUTE () const;

    /**
     * Sets the value of the member "HD_BALLGAME_MODE".
     *
     * If the meaning of "HD_BALLGAME_MODE" isn't clear, then there should be a description here.
     *
     * @param HD_BALLGAME_MODE The value which will be set
     */
    inline void setHD_BALLGAME_MODE (bool HD_BALLGAME_MODE);

    /**
     * Returns the value of the member "HD_BALLGAME_MODE".
     *
     * If the meaning of "HD_BALLGAME_MODE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "HD_BALLGAME_MODE"
     */
    inline bool getHD_BALLGAME_MODE () const;

    /**
     * Sets the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @param RESERVED_1 The value which will be set
     */
    inline void setRESERVED_1 (bool RESERVED_1);

    /**
     * Returns the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_1"
     */
    inline bool getRESERVED_1 () const;

    /**
     * Sets the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @param RESERVED_2 The value which will be set
     */
    inline void setRESERVED_2 (bool RESERVED_2);

    /**
     * Returns the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_2"
     */
    inline bool getRESERVED_2 () const;

    static const T_b8_Tun_HDInfoBits &getDefaultInstance();

private:

    bool _HD_MODULATION_DETECTION:1;

    bool _HD_DATA_DECODING:1;

    bool _HD_AUDIO_DECODING:1;

    bool _HD_BLEND_ANALOG:1;

    bool _HD_DIGITAL_AUDIO_MUTE:1;

    bool _HD_BALLGAME_MODE:1;

    bool _RESERVED_1:1;

    bool _RESERVED_2:1;

};

/**
 * HD program availability information
 */
class T_b8_Tun_HDPrgmAvail {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_HDPrgmAvail ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_HDPrgmAvail (const T_b8_Tun_HDPrgmAvail &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_HDPrgmAvail (bool MPS_AVAIL, bool SPS_1_AVAIL, bool SPS_2_AVAIL, bool SPS_3_AVAIL, bool SPS_4_AVAIL, bool SPS_5_AVAIL, bool SPS_6_AVAIL, bool SPS_7_AVAIL);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_HDPrgmAvail& operator = (const T_b8_Tun_HDPrgmAvail& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_HDPrgmAvail& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_HDPrgmAvail& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_HDPrgmAvail& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_HDPrgmAvail& rhs) const;

    /**
     * Sets the value of the member "MPS_AVAIL".
     *
     * If the meaning of "MPS_AVAIL" isn't clear, then there should be a description here.
     *
     * @param MPS_AVAIL The value which will be set
     */
    inline void setMPS_AVAIL (bool MPS_AVAIL);

    /**
     * Returns the value of the member "MPS_AVAIL".
     *
     * If the meaning of "MPS_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MPS_AVAIL"
     */
    inline bool getMPS_AVAIL () const;

    /**
     * Sets the value of the member "SPS_1_AVAIL".
     *
     * If the meaning of "SPS_1_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_1_AVAIL The value which will be set
     */
    inline void setSPS_1_AVAIL (bool SPS_1_AVAIL);

    /**
     * Returns the value of the member "SPS_1_AVAIL".
     *
     * If the meaning of "SPS_1_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_1_AVAIL"
     */
    inline bool getSPS_1_AVAIL () const;

    /**
     * Sets the value of the member "SPS_2_AVAIL".
     *
     * If the meaning of "SPS_2_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_2_AVAIL The value which will be set
     */
    inline void setSPS_2_AVAIL (bool SPS_2_AVAIL);

    /**
     * Returns the value of the member "SPS_2_AVAIL".
     *
     * If the meaning of "SPS_2_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_2_AVAIL"
     */
    inline bool getSPS_2_AVAIL () const;

    /**
     * Sets the value of the member "SPS_3_AVAIL".
     *
     * If the meaning of "SPS_3_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_3_AVAIL The value which will be set
     */
    inline void setSPS_3_AVAIL (bool SPS_3_AVAIL);

    /**
     * Returns the value of the member "SPS_3_AVAIL".
     *
     * If the meaning of "SPS_3_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_3_AVAIL"
     */
    inline bool getSPS_3_AVAIL () const;

    /**
     * Sets the value of the member "SPS_4_AVAIL".
     *
     * If the meaning of "SPS_4_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_4_AVAIL The value which will be set
     */
    inline void setSPS_4_AVAIL (bool SPS_4_AVAIL);

    /**
     * Returns the value of the member "SPS_4_AVAIL".
     *
     * If the meaning of "SPS_4_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_4_AVAIL"
     */
    inline bool getSPS_4_AVAIL () const;

    /**
     * Sets the value of the member "SPS_5_AVAIL".
     *
     * If the meaning of "SPS_5_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_5_AVAIL The value which will be set
     */
    inline void setSPS_5_AVAIL (bool SPS_5_AVAIL);

    /**
     * Returns the value of the member "SPS_5_AVAIL".
     *
     * If the meaning of "SPS_5_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_5_AVAIL"
     */
    inline bool getSPS_5_AVAIL () const;

    /**
     * Sets the value of the member "SPS_6_AVAIL".
     *
     * If the meaning of "SPS_6_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_6_AVAIL The value which will be set
     */
    inline void setSPS_6_AVAIL (bool SPS_6_AVAIL);

    /**
     * Returns the value of the member "SPS_6_AVAIL".
     *
     * If the meaning of "SPS_6_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_6_AVAIL"
     */
    inline bool getSPS_6_AVAIL () const;

    /**
     * Sets the value of the member "SPS_7_AVAIL".
     *
     * If the meaning of "SPS_7_AVAIL" isn't clear, then there should be a description here.
     *
     * @param SPS_7_AVAIL The value which will be set
     */
    inline void setSPS_7_AVAIL (bool SPS_7_AVAIL);

    /**
     * Returns the value of the member "SPS_7_AVAIL".
     *
     * If the meaning of "SPS_7_AVAIL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SPS_7_AVAIL"
     */
    inline bool getSPS_7_AVAIL () const;

    static const T_b8_Tun_HDPrgmAvail &getDefaultInstance();

private:

    bool _MPS_AVAIL:1;

    bool _SPS_1_AVAIL:1;

    bool _SPS_2_AVAIL:1;

    bool _SPS_3_AVAIL:1;

    bool _SPS_4_AVAIL:1;

    bool _SPS_5_AVAIL:1;

    bool _SPS_6_AVAIL:1;

    bool _SPS_7_AVAIL:1;

};

/**
 * DRM modulation and decoding information
 */
class T_b8_Tun_DRMStationInfoBits {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_DRMStationInfoBits ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_DRMStationInfoBits (const T_b8_Tun_DRMStationInfoBits &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_DRMStationInfoBits (bool DRM_MODULATION_DETECTION, bool DRM_MULTIPLEX_INFO_DECODING, bool DRM_AUDIO_DECODING, bool DRM_AUDIO_MUTE, bool RESERVED_1, bool RESERVED_2, bool RESERVED_3, bool RESERVED_4);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_DRMStationInfoBits& operator = (const T_b8_Tun_DRMStationInfoBits& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_DRMStationInfoBits& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_DRMStationInfoBits& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_DRMStationInfoBits& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_DRMStationInfoBits& rhs) const;

    /**
     * Sets the value of the member "DRM_MODULATION_DETECTION".
     *
     * If the meaning of "DRM_MODULATION_DETECTION" isn't clear, then there should be a description here.
     *
     * @param DRM_MODULATION_DETECTION The value which will be set
     */
    inline void setDRM_MODULATION_DETECTION (bool DRM_MODULATION_DETECTION);

    /**
     * Returns the value of the member "DRM_MODULATION_DETECTION".
     *
     * If the meaning of "DRM_MODULATION_DETECTION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DRM_MODULATION_DETECTION"
     */
    inline bool getDRM_MODULATION_DETECTION () const;

    /**
     * Sets the value of the member "DRM_MULTIPLEX_INFO_DECODING".
     *
     * If the meaning of "DRM_MULTIPLEX_INFO_DECODING" isn't clear, then there should be a description here.
     *
     * @param DRM_MULTIPLEX_INFO_DECODING The value which will be set
     */
    inline void setDRM_MULTIPLEX_INFO_DECODING (bool DRM_MULTIPLEX_INFO_DECODING);

    /**
     * Returns the value of the member "DRM_MULTIPLEX_INFO_DECODING".
     *
     * If the meaning of "DRM_MULTIPLEX_INFO_DECODING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DRM_MULTIPLEX_INFO_DECODING"
     */
    inline bool getDRM_MULTIPLEX_INFO_DECODING () const;

    /**
     * Sets the value of the member "DRM_AUDIO_DECODING".
     *
     * If the meaning of "DRM_AUDIO_DECODING" isn't clear, then there should be a description here.
     *
     * @param DRM_AUDIO_DECODING The value which will be set
     */
    inline void setDRM_AUDIO_DECODING (bool DRM_AUDIO_DECODING);

    /**
     * Returns the value of the member "DRM_AUDIO_DECODING".
     *
     * If the meaning of "DRM_AUDIO_DECODING" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DRM_AUDIO_DECODING"
     */
    inline bool getDRM_AUDIO_DECODING () const;

    /**
     * Sets the value of the member "DRM_AUDIO_MUTE".
     *
     * If the meaning of "DRM_AUDIO_MUTE" isn't clear, then there should be a description here.
     *
     * @param DRM_AUDIO_MUTE The value which will be set
     */
    inline void setDRM_AUDIO_MUTE (bool DRM_AUDIO_MUTE);

    /**
     * Returns the value of the member "DRM_AUDIO_MUTE".
     *
     * If the meaning of "DRM_AUDIO_MUTE" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DRM_AUDIO_MUTE"
     */
    inline bool getDRM_AUDIO_MUTE () const;

    /**
     * Sets the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @param RESERVED_1 The value which will be set
     */
    inline void setRESERVED_1 (bool RESERVED_1);

    /**
     * Returns the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_1"
     */
    inline bool getRESERVED_1 () const;

    /**
     * Sets the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @param RESERVED_2 The value which will be set
     */
    inline void setRESERVED_2 (bool RESERVED_2);

    /**
     * Returns the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_2"
     */
    inline bool getRESERVED_2 () const;

    /**
     * Sets the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @param RESERVED_3 The value which will be set
     */
    inline void setRESERVED_3 (bool RESERVED_3);

    /**
     * Returns the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_3"
     */
    inline bool getRESERVED_3 () const;

    /**
     * Sets the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @param RESERVED_4 The value which will be set
     */
    inline void setRESERVED_4 (bool RESERVED_4);

    /**
     * Returns the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_4"
     */
    inline bool getRESERVED_4 () const;

    static const T_b8_Tun_DRMStationInfoBits &getDefaultInstance();

private:

    bool _DRM_MODULATION_DETECTION:1;

    bool _DRM_MULTIPLEX_INFO_DECODING:1;

    bool _DRM_AUDIO_DECODING:1;

    bool _DRM_AUDIO_MUTE:1;

    bool _RESERVED_1:1;

    bool _RESERVED_2:1;

    bool _RESERVED_3:1;

    bool _RESERVED_4:1;

};

/**
 * DRM Announcement information
 */
class T_b16_Tun_DRMAnnouBits {
public:

    /**
     * Default constructor
     */
    inline  T_b16_Tun_DRMAnnouBits ();

    /**
     * Copy constructor
     */
    inline  T_b16_Tun_DRMAnnouBits (const T_b16_Tun_DRMAnnouBits &c);

    /**
     * Field constructor
     */
    inline  T_b16_Tun_DRMAnnouBits (bool RESERVED_1, bool RESERVED_2, bool RESERVED_3, bool RESERVED_4, bool RESERVED_5, bool RESERVED_6, bool RESERVED_7, bool RESERVED_8, bool RESERVED_9, bool RESERVED_10, bool RESERVED_11, bool RESERVED_12, bool RESERVED_13, bool RESERVED_14, bool RESERVED_15, bool RESERVED_16);

    /**
     * Assignment operator
     */
    inline T_b16_Tun_DRMAnnouBits& operator = (const T_b16_Tun_DRMAnnouBits& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b16_Tun_DRMAnnouBits& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b16_Tun_DRMAnnouBits& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b16_Tun_DRMAnnouBits& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b16_Tun_DRMAnnouBits& rhs) const;

    /**
     * Sets the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @param RESERVED_1 The value which will be set
     */
    inline void setRESERVED_1 (bool RESERVED_1);

    /**
     * Returns the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_1"
     */
    inline bool getRESERVED_1 () const;

    /**
     * Sets the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @param RESERVED_2 The value which will be set
     */
    inline void setRESERVED_2 (bool RESERVED_2);

    /**
     * Returns the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_2"
     */
    inline bool getRESERVED_2 () const;

    /**
     * Sets the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @param RESERVED_3 The value which will be set
     */
    inline void setRESERVED_3 (bool RESERVED_3);

    /**
     * Returns the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_3"
     */
    inline bool getRESERVED_3 () const;

    /**
     * Sets the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @param RESERVED_4 The value which will be set
     */
    inline void setRESERVED_4 (bool RESERVED_4);

    /**
     * Returns the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_4"
     */
    inline bool getRESERVED_4 () const;

    /**
     * Sets the value of the member "RESERVED_5".
     *
     * If the meaning of "RESERVED_5" isn't clear, then there should be a description here.
     *
     * @param RESERVED_5 The value which will be set
     */
    inline void setRESERVED_5 (bool RESERVED_5);

    /**
     * Returns the value of the member "RESERVED_5".
     *
     * If the meaning of "RESERVED_5" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_5"
     */
    inline bool getRESERVED_5 () const;

    /**
     * Sets the value of the member "RESERVED_6".
     *
     * If the meaning of "RESERVED_6" isn't clear, then there should be a description here.
     *
     * @param RESERVED_6 The value which will be set
     */
    inline void setRESERVED_6 (bool RESERVED_6);

    /**
     * Returns the value of the member "RESERVED_6".
     *
     * If the meaning of "RESERVED_6" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_6"
     */
    inline bool getRESERVED_6 () const;

    /**
     * Sets the value of the member "RESERVED_7".
     *
     * If the meaning of "RESERVED_7" isn't clear, then there should be a description here.
     *
     * @param RESERVED_7 The value which will be set
     */
    inline void setRESERVED_7 (bool RESERVED_7);

    /**
     * Returns the value of the member "RESERVED_7".
     *
     * If the meaning of "RESERVED_7" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_7"
     */
    inline bool getRESERVED_7 () const;

    /**
     * Sets the value of the member "RESERVED_8".
     *
     * If the meaning of "RESERVED_8" isn't clear, then there should be a description here.
     *
     * @param RESERVED_8 The value which will be set
     */
    inline void setRESERVED_8 (bool RESERVED_8);

    /**
     * Returns the value of the member "RESERVED_8".
     *
     * If the meaning of "RESERVED_8" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_8"
     */
    inline bool getRESERVED_8 () const;

    /**
     * Sets the value of the member "RESERVED_9".
     *
     * If the meaning of "RESERVED_9" isn't clear, then there should be a description here.
     *
     * @param RESERVED_9 The value which will be set
     */
    inline void setRESERVED_9 (bool RESERVED_9);

    /**
     * Returns the value of the member "RESERVED_9".
     *
     * If the meaning of "RESERVED_9" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_9"
     */
    inline bool getRESERVED_9 () const;

    /**
     * Sets the value of the member "RESERVED_10".
     *
     * If the meaning of "RESERVED_10" isn't clear, then there should be a description here.
     *
     * @param RESERVED_10 The value which will be set
     */
    inline void setRESERVED_10 (bool RESERVED_10);

    /**
     * Returns the value of the member "RESERVED_10".
     *
     * If the meaning of "RESERVED_10" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_10"
     */
    inline bool getRESERVED_10 () const;

    /**
     * Sets the value of the member "RESERVED_11".
     *
     * If the meaning of "RESERVED_11" isn't clear, then there should be a description here.
     *
     * @param RESERVED_11 The value which will be set
     */
    inline void setRESERVED_11 (bool RESERVED_11);

    /**
     * Returns the value of the member "RESERVED_11".
     *
     * If the meaning of "RESERVED_11" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_11"
     */
    inline bool getRESERVED_11 () const;

    /**
     * Sets the value of the member "RESERVED_12".
     *
     * If the meaning of "RESERVED_12" isn't clear, then there should be a description here.
     *
     * @param RESERVED_12 The value which will be set
     */
    inline void setRESERVED_12 (bool RESERVED_12);

    /**
     * Returns the value of the member "RESERVED_12".
     *
     * If the meaning of "RESERVED_12" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_12"
     */
    inline bool getRESERVED_12 () const;

    /**
     * Sets the value of the member "RESERVED_13".
     *
     * If the meaning of "RESERVED_13" isn't clear, then there should be a description here.
     *
     * @param RESERVED_13 The value which will be set
     */
    inline void setRESERVED_13 (bool RESERVED_13);

    /**
     * Returns the value of the member "RESERVED_13".
     *
     * If the meaning of "RESERVED_13" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_13"
     */
    inline bool getRESERVED_13 () const;

    /**
     * Sets the value of the member "RESERVED_14".
     *
     * If the meaning of "RESERVED_14" isn't clear, then there should be a description here.
     *
     * @param RESERVED_14 The value which will be set
     */
    inline void setRESERVED_14 (bool RESERVED_14);

    /**
     * Returns the value of the member "RESERVED_14".
     *
     * If the meaning of "RESERVED_14" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_14"
     */
    inline bool getRESERVED_14 () const;

    /**
     * Sets the value of the member "RESERVED_15".
     *
     * If the meaning of "RESERVED_15" isn't clear, then there should be a description here.
     *
     * @param RESERVED_15 The value which will be set
     */
    inline void setRESERVED_15 (bool RESERVED_15);

    /**
     * Returns the value of the member "RESERVED_15".
     *
     * If the meaning of "RESERVED_15" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_15"
     */
    inline bool getRESERVED_15 () const;

    /**
     * Sets the value of the member "RESERVED_16".
     *
     * If the meaning of "RESERVED_16" isn't clear, then there should be a description here.
     *
     * @param RESERVED_16 The value which will be set
     */
    inline void setRESERVED_16 (bool RESERVED_16);

    /**
     * Returns the value of the member "RESERVED_16".
     *
     * If the meaning of "RESERVED_16" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_16"
     */
    inline bool getRESERVED_16 () const;

    static const T_b16_Tun_DRMAnnouBits &getDefaultInstance();

private:

    bool _RESERVED_1:1;

    bool _RESERVED_2:1;

    bool _RESERVED_3:1;

    bool _RESERVED_4:1;

    bool _RESERVED_5:1;

    bool _RESERVED_6:1;

    bool _RESERVED_7:1;

    bool _RESERVED_8:1;

    bool _RESERVED_9:1;

    bool _RESERVED_10:1;

    bool _RESERVED_11:1;

    bool _RESERVED_12:1;

    bool _RESERVED_13:1;

    bool _RESERVED_14:1;

    bool _RESERVED_15:1;

    bool _RESERVED_16:1;

};

/**
 * DRM modulation and decoding information
 */
class T_b8_Tun_DRMNumberOfAudioServices {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_DRMNumberOfAudioServices ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_DRMNumberOfAudioServices (const T_b8_Tun_DRMNumberOfAudioServices &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_DRMNumberOfAudioServices (bool AUDIO_PROGRAM_1, bool AUDIO_PROGRAM_2, bool AUDIO_PROGRAM_3, bool AUDIO_PROGRAM_4, bool RESERVED_1, bool RESERVED_2, bool RESERVED_3, bool RESERVED_4);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_DRMNumberOfAudioServices& operator = (const T_b8_Tun_DRMNumberOfAudioServices& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_DRMNumberOfAudioServices& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_DRMNumberOfAudioServices& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_DRMNumberOfAudioServices& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_DRMNumberOfAudioServices& rhs) const;

    /**
     * Sets the value of the member "AUDIO_PROGRAM_1".
     *
     * If the meaning of "AUDIO_PROGRAM_1" isn't clear, then there should be a description here.
     *
     * @param AUDIO_PROGRAM_1 The value which will be set
     */
    inline void setAUDIO_PROGRAM_1 (bool AUDIO_PROGRAM_1);

    /**
     * Returns the value of the member "AUDIO_PROGRAM_1".
     *
     * If the meaning of "AUDIO_PROGRAM_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AUDIO_PROGRAM_1"
     */
    inline bool getAUDIO_PROGRAM_1 () const;

    /**
     * Sets the value of the member "AUDIO_PROGRAM_2".
     *
     * If the meaning of "AUDIO_PROGRAM_2" isn't clear, then there should be a description here.
     *
     * @param AUDIO_PROGRAM_2 The value which will be set
     */
    inline void setAUDIO_PROGRAM_2 (bool AUDIO_PROGRAM_2);

    /**
     * Returns the value of the member "AUDIO_PROGRAM_2".
     *
     * If the meaning of "AUDIO_PROGRAM_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AUDIO_PROGRAM_2"
     */
    inline bool getAUDIO_PROGRAM_2 () const;

    /**
     * Sets the value of the member "AUDIO_PROGRAM_3".
     *
     * If the meaning of "AUDIO_PROGRAM_3" isn't clear, then there should be a description here.
     *
     * @param AUDIO_PROGRAM_3 The value which will be set
     */
    inline void setAUDIO_PROGRAM_3 (bool AUDIO_PROGRAM_3);

    /**
     * Returns the value of the member "AUDIO_PROGRAM_3".
     *
     * If the meaning of "AUDIO_PROGRAM_3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AUDIO_PROGRAM_3"
     */
    inline bool getAUDIO_PROGRAM_3 () const;

    /**
     * Sets the value of the member "AUDIO_PROGRAM_4".
     *
     * If the meaning of "AUDIO_PROGRAM_4" isn't clear, then there should be a description here.
     *
     * @param AUDIO_PROGRAM_4 The value which will be set
     */
    inline void setAUDIO_PROGRAM_4 (bool AUDIO_PROGRAM_4);

    /**
     * Returns the value of the member "AUDIO_PROGRAM_4".
     *
     * If the meaning of "AUDIO_PROGRAM_4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AUDIO_PROGRAM_4"
     */
    inline bool getAUDIO_PROGRAM_4 () const;

    /**
     * Sets the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @param RESERVED_1 The value which will be set
     */
    inline void setRESERVED_1 (bool RESERVED_1);

    /**
     * Returns the value of the member "RESERVED_1".
     *
     * If the meaning of "RESERVED_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_1"
     */
    inline bool getRESERVED_1 () const;

    /**
     * Sets the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @param RESERVED_2 The value which will be set
     */
    inline void setRESERVED_2 (bool RESERVED_2);

    /**
     * Returns the value of the member "RESERVED_2".
     *
     * If the meaning of "RESERVED_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_2"
     */
    inline bool getRESERVED_2 () const;

    /**
     * Sets the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @param RESERVED_3 The value which will be set
     */
    inline void setRESERVED_3 (bool RESERVED_3);

    /**
     * Returns the value of the member "RESERVED_3".
     *
     * If the meaning of "RESERVED_3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_3"
     */
    inline bool getRESERVED_3 () const;

    /**
     * Sets the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @param RESERVED_4 The value which will be set
     */
    inline void setRESERVED_4 (bool RESERVED_4);

    /**
     * Returns the value of the member "RESERVED_4".
     *
     * If the meaning of "RESERVED_4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RESERVED_4"
     */
    inline bool getRESERVED_4 () const;

    static const T_b8_Tun_DRMNumberOfAudioServices &getDefaultInstance();

private:

    bool _AUDIO_PROGRAM_1:1;

    bool _AUDIO_PROGRAM_2:1;

    bool _AUDIO_PROGRAM_3:1;

    bool _AUDIO_PROGRAM_4:1;

    bool _RESERVED_1:1;

    bool _RESERVED_2:1;

    bool _RESERVED_3:1;

    bool _RESERVED_4:1;

};

/**
 * CM_AtStationinfo data is contained in this structure .
 */
class T_Atstationinfo {
public:

    /**
     * Default constructor
     */
    inline  T_Atstationinfo ();

    /**
     * Copy constructor
     */
    inline  T_Atstationinfo (const T_Atstationinfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_Atstationinfo (T_e8_Tun_TunerHeader u8TunerHeader_, const T_b32_Tun_AvailFlags& u32AvailFlags_, uint32 u32Frequency_, uint16 u16PI_, const ::std::string& sPSName_, T_e8_Tun_TunerBand e8Band_, T_e8_AtStationTPinfo e8AtStationTPinfo_, uint16 u16PresetListID_, uint8 u8ActiveStationList_, uint16 u16StaticListElementID_, uint16 u16ConfigListElementID_, const T_b8_Tun_AtStationInfoBits& u8AtStationInfoBits_, uint8 u8PTY_, uint8 u8FieldStrngth_, uint8 u8Quality_, const T_b8_Tun_HDInfoBits& b8HDStationInfoBits_, uint32 u32StationInfoHDStationID_, const ::std::string& sHDCallSign_, T_e8_Tun_HD_TextEncodingType e8HDCallSignTextEncoding_, uint8 u8HDStationGenre_, const T_b8_Tun_HDPrgmAvail& b8HDAudioPrgmAvail_, uint8 u8HDQuality_, T_e8_Tun_HDAudioProgram e8ActiveHDAudPrgm_, const ::std::string& StationLogo_, const T_b8_Tun_DRMStationInfoBits& b8DRMStationInfoBits_, uint32 u32DRMServiceId_, const ::std::string& sDRMServiceLabel_, uint8 u8DRMPTY_, const T_b16_Tun_DRMAnnouBits& b16DRMAnnouBits_, const T_b8_Tun_DRMNumberOfAudioServices& b8DRMNumberOfAudioServices_, uint8 u8DRMQuality_, uint8 u8DRMServiceShortId_, uint8 u8Drmlanguage_, uint32 u32DrmlanguageCode_, uint16 u16DrmCountryCode_, int8 s8DrmFrequencyCorrection_, uint8 u8JapanStationCount_, bool bUserPresetAction_);

    /**
     * Destructor
     */
    inline  ~T_Atstationinfo();

    /**
     * Assignment operator
     */
    inline T_Atstationinfo& operator = (const T_Atstationinfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Atstationinfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Atstationinfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Atstationinfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Atstationinfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8TunerHeader"

    static const int kU8TunerHeader = 0;

    /**
     * Clears the field "u8TunerHeader".
     *
     * The field will be set to its default value. The hasU8TunerHeader()
     * method will return false.
     */
    inline void clearU8TunerHeader();

    /**
     * Checks whether the field "u8TunerHeader" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TunerHeader()). Otherwise it will return false.
     */
    inline bool hasU8TunerHeader () const;

    /**
     * Returns the value of the member "u8TunerHeader".
     *
     * .
     *
     * @return The value of the field "u8TunerHeader"
     */
    inline T_e8_Tun_TunerHeader getU8TunerHeader () const;

    /**
     * Sets the value of the member "u8TunerHeader".
     *
     * .
     *
     * @param u8TunerHeader The value which will be set
     */
    inline void setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_);

    // API of field "u32AvailFlags"

    static const int kU32AvailFlags = 1;

    /**
     * Clears the field "u32AvailFlags".
     *
     * The field will be set to its default value. The hasU32AvailFlags()
     * method will return false.
     */
    inline void clearU32AvailFlags();

    /**
     * Checks whether the field "u32AvailFlags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AvailFlags()). Otherwise it will return false.
     */
    inline bool hasU32AvailFlags () const;

    /**
     * Returns the value of the member "u32AvailFlags".
     *
     * The parameter is currently not used and will be removed shortly.
     *
     * @return The value of the field "u32AvailFlags"
     */
    inline const T_b32_Tun_AvailFlags& getU32AvailFlags () const;

    /**
     * Retrieves the value of the field "u32AvailFlags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u32AvailFlags".
     */
    inline T_b32_Tun_AvailFlags& getU32AvailFlagsMutable ();

    /**
     * Sets the value of the member "u32AvailFlags".
     *
     * The parameter is currently not used and will be removed shortly.
     *
     * @param u32AvailFlags The value which will be set
     */
    inline void setU32AvailFlags (const T_b32_Tun_AvailFlags& u32AvailFlags_);

    /**
     * Release the object stored in the field "u32AvailFlags".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u32AvailFlags"
     */
    inline T_b32_Tun_AvailFlags* releaseU32AvailFlags();

    /**
     * Replace the field "u32AvailFlags".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU32AvailFlags (T_b32_Tun_AvailFlags* u32AvailFlags_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 2;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * .
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * .
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u16PI"

    static const int kU16PI = 3;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     * .
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     * .
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "sPSName"

    static const int kSPSName = 4;

    /**
     * Clears the field "sPSName".
     *
     * The field will be set to its default value. The hasSPSName()
     * method will return false.
     */
    inline void clearSPSName();

    /**
     * Checks whether the field "sPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPSName()). Otherwise it will return false.
     */
    inline bool hasSPSName () const;

    /**
     * Returns the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1. But For IVI japan variant, more bytes can be expected as the station name is copied from database
     *
     * @return The value of the field "sPSName"
     */
    inline const ::std::string& getSPSName () const;

    /**
     * Retrieves the value of the field "sPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPSName".
     */
    inline ::std::string& getSPSNameMutable ();

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1. But For IVI japan variant, more bytes can be expected as the station name is copied from database
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const ::std::string& sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1. But For IVI japan variant, more bytes can be expected as the station name is copied from database
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* sPSName_);

    /**
     * Sets the value of the member "sPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1. But For IVI japan variant, more bytes can be expected as the station name is copied from database
     *
     * @param sPSName The value which will be set
     */
    inline void setSPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPSName"
     */
    inline ::std::string* releaseSPSName();

    /**
     * Replace the field "sPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPSName (::std::string* sPSName_);

    // API of field "e8Band"

    static const int kE8Band = 5;

    /**
     * Clears the field "e8Band".
     *
     * The field will be set to its default value. The hasE8Band()
     * method will return false.
     */
    inline void clearE8Band();

    /**
     * Checks whether the field "e8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Band()). Otherwise it will return false.
     */
    inline bool hasE8Band () const;

    /**
     * Returns the value of the member "e8Band".
     *
     *
     *
     * @return The value of the field "e8Band"
     */
    inline T_e8_Tun_TunerBand getE8Band () const;

    /**
     * Sets the value of the member "e8Band".
     *
     *
     *
     * @param e8Band The value which will be set
     */
    inline void setE8Band (T_e8_Tun_TunerBand e8Band_);

    // API of field "e8AtStationTPinfo"

    static const int kE8AtStationTPinfo = 6;

    /**
     * Clears the field "e8AtStationTPinfo".
     *
     * The field will be set to its default value. The hasE8AtStationTPinfo()
     * method will return false.
     */
    inline void clearE8AtStationTPinfo();

    /**
     * Checks whether the field "e8AtStationTPinfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AtStationTPinfo()). Otherwise it will return false.
     */
    inline bool hasE8AtStationTPinfo () const;

    /**
     * Returns the value of the member "e8AtStationTPinfo".
     *
     * Provides the TP status of station
     *
     * @return The value of the field "e8AtStationTPinfo"
     */
    inline T_e8_AtStationTPinfo getE8AtStationTPinfo () const;

    /**
     * Sets the value of the member "e8AtStationTPinfo".
     *
     * Provides the TP status of station
     *
     * @param e8AtStationTPinfo The value which will be set
     */
    inline void setE8AtStationTPinfo (T_e8_AtStationTPinfo e8AtStationTPinfo_);

    // API of field "u16PresetListID"

    static const int kU16PresetListID = 7;

    /**
     * Clears the field "u16PresetListID".
     *
     * The field will be set to its default value. The hasU16PresetListID()
     * method will return false.
     */
    inline void clearU16PresetListID();

    /**
     * Checks whether the field "u16PresetListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PresetListID()). Otherwise it will return false.
     */
    inline bool hasU16PresetListID () const;

    /**
     * Returns the value of the member "u16PresetListID".
     *
     * The current active preset list of given audio tuner
     *
     * @return The value of the field "u16PresetListID"
     */
    inline uint16 getU16PresetListID () const;

    /**
     * Sets the value of the member "u16PresetListID".
     *
     * The current active preset list of given audio tuner
     *
     * @param u16PresetListID The value which will be set
     */
    inline void setU16PresetListID (uint16 u16PresetListID_);

    // API of field "u8ActiveStationList"

    static const int kU8ActiveStationList = 8;

    /**
     * Clears the field "u8ActiveStationList".
     *
     * The field will be set to its default value. The hasU8ActiveStationList()
     * method will return false.
     */
    inline void clearU8ActiveStationList();

    /**
     * Checks whether the field "u8ActiveStationList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ActiveStationList()). Otherwise it will return false.
     */
    inline bool hasU8ActiveStationList () const;

    /**
     * Returns the value of the member "u8ActiveStationList".
     *
     * The current active stattion list of given audio tuner
     *
     * @return The value of the field "u8ActiveStationList"
     */
    inline uint8 getU8ActiveStationList () const;

    /**
     * Sets the value of the member "u8ActiveStationList".
     *
     * The current active stattion list of given audio tuner
     *
     * @param u8ActiveStationList The value which will be set
     */
    inline void setU8ActiveStationList (uint8 u8ActiveStationList_);

    // API of field "u16StaticListElementID"

    static const int kU16StaticListElementID = 9;

    /**
     * Clears the field "u16StaticListElementID".
     *
     * The field will be set to its default value. The hasU16StaticListElementID()
     * method will return false.
     */
    inline void clearU16StaticListElementID();

    /**
     * Checks whether the field "u16StaticListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16StaticListElementID()). Otherwise it will return false.
     */
    inline bool hasU16StaticListElementID () const;

    /**
     * Returns the value of the member "u16StaticListElementID".
     *
     * .
     *
     * @return The value of the field "u16StaticListElementID"
     */
    inline uint16 getU16StaticListElementID () const;

    /**
     * Sets the value of the member "u16StaticListElementID".
     *
     * .
     *
     * @param u16StaticListElementID The value which will be set
     */
    inline void setU16StaticListElementID (uint16 u16StaticListElementID_);

    // API of field "u16ConfigListElementID"

    static const int kU16ConfigListElementID = 10;

    /**
     * Clears the field "u16ConfigListElementID".
     *
     * The field will be set to its default value. The hasU16ConfigListElementID()
     * method will return false.
     */
    inline void clearU16ConfigListElementID();

    /**
     * Checks whether the field "u16ConfigListElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ConfigListElementID()). Otherwise it will return false.
     */
    inline bool hasU16ConfigListElementID () const;

    /**
     * Returns the value of the member "u16ConfigListElementID".
     *
     * .
     *
     * @return The value of the field "u16ConfigListElementID"
     */
    inline uint16 getU16ConfigListElementID () const;

    /**
     * Sets the value of the member "u16ConfigListElementID".
     *
     * .
     *
     * @param u16ConfigListElementID The value which will be set
     */
    inline void setU16ConfigListElementID (uint16 u16ConfigListElementID_);

    // API of field "u8AtStationInfoBits"

    static const int kU8AtStationInfoBits = 11;

    /**
     * Clears the field "u8AtStationInfoBits".
     *
     * The field will be set to its default value. The hasU8AtStationInfoBits()
     * method will return false.
     */
    inline void clearU8AtStationInfoBits();

    /**
     * Checks whether the field "u8AtStationInfoBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AtStationInfoBits()). Otherwise it will return false.
     */
    inline bool hasU8AtStationInfoBits () const;

    /**
     * Returns the value of the member "u8AtStationInfoBits".
     *
     * Bit 0 False Mono signal
     * True  Stereo signal
     * Bit 1 False Speech is signalled
     * True  Music is signalled
     * Bit 2 False Radiotext not possible
     * True  Radiotext possible
     * Bit 3 False Frequency is not an alternative frequency (AF)
     * True  Frequency is an alternative frequency (AF)
     * Bit 4 False Radiotext not available
     * True  Radiotext available
     * Bit 5 False AF not available
     * True  At least one AF available
     * Bit 6 False Station is not an HD station or an HD station with analogue service.
     * True  Station is an HD station without analogue service (pure digital).
     * Bit 7 False Mono reproduction of received signal.
     * True  Stereo reproduction of received signal.
     *
     * @return The value of the field "u8AtStationInfoBits"
     */
    inline const T_b8_Tun_AtStationInfoBits& getU8AtStationInfoBits () const;

    /**
     * Retrieves the value of the field "u8AtStationInfoBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u8AtStationInfoBits".
     */
    inline T_b8_Tun_AtStationInfoBits& getU8AtStationInfoBitsMutable ();

    /**
     * Sets the value of the member "u8AtStationInfoBits".
     *
     * Bit 0 False Mono signal
     * True  Stereo signal
     * Bit 1 False Speech is signalled
     * True  Music is signalled
     * Bit 2 False Radiotext not possible
     * True  Radiotext possible
     * Bit 3 False Frequency is not an alternative frequency (AF)
     * True  Frequency is an alternative frequency (AF)
     * Bit 4 False Radiotext not available
     * True  Radiotext available
     * Bit 5 False AF not available
     * True  At least one AF available
     * Bit 6 False Station is not an HD station or an HD station with analogue service.
     * True  Station is an HD station without analogue service (pure digital).
     * Bit 7 False Mono reproduction of received signal.
     * True  Stereo reproduction of received signal.
     *
     * @param u8AtStationInfoBits The value which will be set
     */
    inline void setU8AtStationInfoBits (const T_b8_Tun_AtStationInfoBits& u8AtStationInfoBits_);

    /**
     * Release the object stored in the field "u8AtStationInfoBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u8AtStationInfoBits"
     */
    inline T_b8_Tun_AtStationInfoBits* releaseU8AtStationInfoBits();

    /**
     * Replace the field "u8AtStationInfoBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU8AtStationInfoBits (T_b8_Tun_AtStationInfoBits* u8AtStationInfoBits_);

    // API of field "u8PTY"

    static const int kU8PTY = 12;

    /**
     * Clears the field "u8PTY".
     *
     * The field will be set to its default value. The hasU8PTY()
     * method will return false.
     */
    inline void clearU8PTY();

    /**
     * Checks whether the field "u8PTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PTY()). Otherwise it will return false.
     */
    inline bool hasU8PTY () const;

    /**
     * Returns the value of the member "u8PTY".
     *
     * .
     *
     * @return The value of the field "u8PTY"
     */
    inline uint8 getU8PTY () const;

    /**
     * Sets the value of the member "u8PTY".
     *
     * .
     *
     * @param u8PTY The value which will be set
     */
    inline void setU8PTY (uint8 u8PTY_);

    // API of field "u8FieldStrngth"

    static const int kU8FieldStrngth = 13;

    /**
     * Clears the field "u8FieldStrngth".
     *
     * The field will be set to its default value. The hasU8FieldStrngth()
     * method will return false.
     */
    inline void clearU8FieldStrngth();

    /**
     * Checks whether the field "u8FieldStrngth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FieldStrngth()). Otherwise it will return false.
     */
    inline bool hasU8FieldStrngth () const;

    /**
     * Returns the value of the member "u8FieldStrngth".
     *
     * Field strength of currently tuned station
     *
     * @return The value of the field "u8FieldStrngth"
     */
    inline uint8 getU8FieldStrngth () const;

    /**
     * Sets the value of the member "u8FieldStrngth".
     *
     * Field strength of currently tuned station
     *
     * @param u8FieldStrngth The value which will be set
     */
    inline void setU8FieldStrngth (uint8 u8FieldStrngth_);

    // API of field "u8Quality"

    static const int kU8Quality = 14;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * Quality of currently tuned station.
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * Quality of currently tuned station.
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    // API of field "b8HDStationInfoBits"

    static const int kB8HDStationInfoBits = 15;

    /**
     * Clears the field "b8HDStationInfoBits".
     *
     * The field will be set to its default value. The hasB8HDStationInfoBits()
     * method will return false.
     */
    inline void clearB8HDStationInfoBits();

    /**
     * Checks whether the field "b8HDStationInfoBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8HDStationInfoBits()). Otherwise it will return false.
     */
    inline bool hasB8HDStationInfoBits () const;

    /**
     * Returns the value of the member "b8HDStationInfoBits".
     *
     * If the meaning of "b8HDStationInfoBits" isn't clear, then there should be a description here.
     *
     * @return The value of the field "b8HDStationInfoBits"
     */
    inline const T_b8_Tun_HDInfoBits& getB8HDStationInfoBits () const;

    /**
     * Retrieves the value of the field "b8HDStationInfoBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8HDStationInfoBits".
     */
    inline T_b8_Tun_HDInfoBits& getB8HDStationInfoBitsMutable ();

    /**
     * Sets the value of the member "b8HDStationInfoBits".
     *
     * If the meaning of "b8HDStationInfoBits" isn't clear, then there should be a description here.
     *
     * @param b8HDStationInfoBits The value which will be set
     */
    inline void setB8HDStationInfoBits (const T_b8_Tun_HDInfoBits& b8HDStationInfoBits_);

    /**
     * Release the object stored in the field "b8HDStationInfoBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8HDStationInfoBits"
     */
    inline T_b8_Tun_HDInfoBits* releaseB8HDStationInfoBits();

    /**
     * Replace the field "b8HDStationInfoBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8HDStationInfoBits (T_b8_Tun_HDInfoBits* b8HDStationInfoBits_);

    // API of field "u32StationInfoHDStationID"

    static const int kU32StationInfoHDStationID = 16;

    /**
     * Clears the field "u32StationInfoHDStationID".
     *
     * The field will be set to its default value. The hasU32StationInfoHDStationID()
     * method will return false.
     */
    inline void clearU32StationInfoHDStationID();

    /**
     * Checks whether the field "u32StationInfoHDStationID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32StationInfoHDStationID()). Otherwise it will return false.
     */
    inline bool hasU32StationInfoHDStationID () const;

    /**
     * Returns the value of the member "u32StationInfoHDStationID".
     *
     * .
     *
     * @return The value of the field "u32StationInfoHDStationID"
     */
    inline uint32 getU32StationInfoHDStationID () const;

    /**
     * Sets the value of the member "u32StationInfoHDStationID".
     *
     * .
     *
     * @param u32StationInfoHDStationID The value which will be set
     */
    inline void setU32StationInfoHDStationID (uint32 u32StationInfoHDStationID_);

    // API of field "sHDCallSign"

    static const int kSHDCallSign = 17;

    /**
     * Clears the field "sHDCallSign".
     *
     * The field will be set to its default value. The hasSHDCallSign()
     * method will return false.
     */
    inline void clearSHDCallSign();

    /**
     * Checks whether the field "sHDCallSign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDCallSign()). Otherwise it will return false.
     */
    inline bool hasSHDCallSign () const;

    /**
     * Returns the value of the member "sHDCallSign".
     *
     * If the meaning of "sHDCallSign" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sHDCallSign"
     */
    inline const ::std::string& getSHDCallSign () const;

    /**
     * Retrieves the value of the field "sHDCallSign" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDCallSign".
     */
    inline ::std::string& getSHDCallSignMutable ();

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * If the meaning of "sHDCallSign" isn't clear, then there should be a description here.
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const ::std::string& sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * If the meaning of "sHDCallSign" isn't clear, then there should be a description here.
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * If the meaning of "sHDCallSign" isn't clear, then there should be a description here.
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* value, size_t size);

    /**
     * Release the object stored in the field "sHDCallSign".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sHDCallSign"
     */
    inline ::std::string* releaseSHDCallSign();

    /**
     * Replace the field "sHDCallSign".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSHDCallSign (::std::string* sHDCallSign_);

    // API of field "e8HDCallSignTextEncoding"

    static const int kE8HDCallSignTextEncoding = 18;

    /**
     * Clears the field "e8HDCallSignTextEncoding".
     *
     * The field will be set to its default value. The hasE8HDCallSignTextEncoding()
     * method will return false.
     */
    inline void clearE8HDCallSignTextEncoding();

    /**
     * Checks whether the field "e8HDCallSignTextEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDCallSignTextEncoding()). Otherwise it will return false.
     */
    inline bool hasE8HDCallSignTextEncoding () const;

    /**
     * Returns the value of the member "e8HDCallSignTextEncoding".
     *
     * If the meaning of "e8HDCallSignTextEncoding" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8HDCallSignTextEncoding"
     */
    inline T_e8_Tun_HD_TextEncodingType getE8HDCallSignTextEncoding () const;

    /**
     * Sets the value of the member "e8HDCallSignTextEncoding".
     *
     * If the meaning of "e8HDCallSignTextEncoding" isn't clear, then there should be a description here.
     *
     * @param e8HDCallSignTextEncoding The value which will be set
     */
    inline void setE8HDCallSignTextEncoding (T_e8_Tun_HD_TextEncodingType e8HDCallSignTextEncoding_);

    // API of field "u8HDStationGenre"

    static const int kU8HDStationGenre = 19;

    /**
     * Clears the field "u8HDStationGenre".
     *
     * The field will be set to its default value. The hasU8HDStationGenre()
     * method will return false.
     */
    inline void clearU8HDStationGenre();

    /**
     * Checks whether the field "u8HDStationGenre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HDStationGenre()). Otherwise it will return false.
     */
    inline bool hasU8HDStationGenre () const;

    /**
     * Returns the value of the member "u8HDStationGenre".
     *
     * If the meaning of "u8HDStationGenre" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8HDStationGenre"
     */
    inline uint8 getU8HDStationGenre () const;

    /**
     * Sets the value of the member "u8HDStationGenre".
     *
     * If the meaning of "u8HDStationGenre" isn't clear, then there should be a description here.
     *
     * @param u8HDStationGenre The value which will be set
     */
    inline void setU8HDStationGenre (uint8 u8HDStationGenre_);

    // API of field "b8HDAudioPrgmAvail"

    static const int kB8HDAudioPrgmAvail = 20;

    /**
     * Clears the field "b8HDAudioPrgmAvail".
     *
     * The field will be set to its default value. The hasB8HDAudioPrgmAvail()
     * method will return false.
     */
    inline void clearB8HDAudioPrgmAvail();

    /**
     * Checks whether the field "b8HDAudioPrgmAvail" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8HDAudioPrgmAvail()). Otherwise it will return false.
     */
    inline bool hasB8HDAudioPrgmAvail () const;

    /**
     * Returns the value of the member "b8HDAudioPrgmAvail".
     *
     * If the meaning of "b8HDAudioPrgmAvail" isn't clear, then there should be a description here.
     *
     * @return The value of the field "b8HDAudioPrgmAvail"
     */
    inline const T_b8_Tun_HDPrgmAvail& getB8HDAudioPrgmAvail () const;

    /**
     * Retrieves the value of the field "b8HDAudioPrgmAvail" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8HDAudioPrgmAvail".
     */
    inline T_b8_Tun_HDPrgmAvail& getB8HDAudioPrgmAvailMutable ();

    /**
     * Sets the value of the member "b8HDAudioPrgmAvail".
     *
     * If the meaning of "b8HDAudioPrgmAvail" isn't clear, then there should be a description here.
     *
     * @param b8HDAudioPrgmAvail The value which will be set
     */
    inline void setB8HDAudioPrgmAvail (const T_b8_Tun_HDPrgmAvail& b8HDAudioPrgmAvail_);

    /**
     * Release the object stored in the field "b8HDAudioPrgmAvail".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8HDAudioPrgmAvail"
     */
    inline T_b8_Tun_HDPrgmAvail* releaseB8HDAudioPrgmAvail();

    /**
     * Replace the field "b8HDAudioPrgmAvail".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8HDAudioPrgmAvail (T_b8_Tun_HDPrgmAvail* b8HDAudioPrgmAvail_);

    // API of field "u8HDQuality"

    static const int kU8HDQuality = 21;

    /**
     * Clears the field "u8HDQuality".
     *
     * The field will be set to its default value. The hasU8HDQuality()
     * method will return false.
     */
    inline void clearU8HDQuality();

    /**
     * Checks whether the field "u8HDQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HDQuality()). Otherwise it will return false.
     */
    inline bool hasU8HDQuality () const;

    /**
     * Returns the value of the member "u8HDQuality".
     *
     * If the meaning of "u8HDQuality" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8HDQuality"
     */
    inline uint8 getU8HDQuality () const;

    /**
     * Sets the value of the member "u8HDQuality".
     *
     * If the meaning of "u8HDQuality" isn't clear, then there should be a description here.
     *
     * @param u8HDQuality The value which will be set
     */
    inline void setU8HDQuality (uint8 u8HDQuality_);

    // API of field "e8ActiveHDAudPrgm"

    static const int kE8ActiveHDAudPrgm = 22;

    /**
     * Clears the field "e8ActiveHDAudPrgm".
     *
     * The field will be set to its default value. The hasE8ActiveHDAudPrgm()
     * method will return false.
     */
    inline void clearE8ActiveHDAudPrgm();

    /**
     * Checks whether the field "e8ActiveHDAudPrgm" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ActiveHDAudPrgm()). Otherwise it will return false.
     */
    inline bool hasE8ActiveHDAudPrgm () const;

    /**
     * Returns the value of the member "e8ActiveHDAudPrgm".
     *
     * 0: Audio Program 1 (MPS), 1-7 : Audio Program 2 to 8 (SPS)
     *
     * @return The value of the field "e8ActiveHDAudPrgm"
     */
    inline T_e8_Tun_HDAudioProgram getE8ActiveHDAudPrgm () const;

    /**
     * Sets the value of the member "e8ActiveHDAudPrgm".
     *
     * 0: Audio Program 1 (MPS), 1-7 : Audio Program 2 to 8 (SPS)
     *
     * @param e8ActiveHDAudPrgm The value which will be set
     */
    inline void setE8ActiveHDAudPrgm (T_e8_Tun_HDAudioProgram e8ActiveHDAudPrgm_);

    // API of field "StationLogo"

    static const int kStationLogo = 23;

    /**
     * Clears the field "StationLogo".
     *
     * The field will be set to its default value. The hasStationLogo()
     * method will return false.
     */
    inline void clearStationLogo();

    /**
     * Checks whether the field "StationLogo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStationLogo()). Otherwise it will return false.
     */
    inline bool hasStationLogo () const;

    /**
     * Returns the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @return The value of the field "StationLogo"
     */
    inline const ::std::string& getStationLogo () const;

    /**
     * Retrieves the value of the field "StationLogo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StationLogo".
     */
    inline ::std::string& getStationLogoMutable ();

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const ::std::string& StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* StationLogo_);

    /**
     * Sets the value of the member "StationLogo".
     *
     * Contains the link info where the LOGO is stored
     *
     * @param StationLogo The value which will be set
     */
    inline void setStationLogo (const char* value, size_t size);

    /**
     * Release the object stored in the field "StationLogo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "StationLogo"
     */
    inline ::std::string* releaseStationLogo();

    /**
     * Replace the field "StationLogo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceStationLogo (::std::string* StationLogo_);

    // API of field "b8DRMStationInfoBits"

    static const int kB8DRMStationInfoBits = 24;

    /**
     * Clears the field "b8DRMStationInfoBits".
     *
     * The field will be set to its default value. The hasB8DRMStationInfoBits()
     * method will return false.
     */
    inline void clearB8DRMStationInfoBits();

    /**
     * Checks whether the field "b8DRMStationInfoBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8DRMStationInfoBits()). Otherwise it will return false.
     */
    inline bool hasB8DRMStationInfoBits () const;

    /**
     * Returns the value of the member "b8DRMStationInfoBits".
     *
     * If the meaning of "b8DRMStationInfoBits" isn't clear, then there should be a description here.
     *
     * @return The value of the field "b8DRMStationInfoBits"
     */
    inline const T_b8_Tun_DRMStationInfoBits& getB8DRMStationInfoBits () const;

    /**
     * Retrieves the value of the field "b8DRMStationInfoBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8DRMStationInfoBits".
     */
    inline T_b8_Tun_DRMStationInfoBits& getB8DRMStationInfoBitsMutable ();

    /**
     * Sets the value of the member "b8DRMStationInfoBits".
     *
     * If the meaning of "b8DRMStationInfoBits" isn't clear, then there should be a description here.
     *
     * @param b8DRMStationInfoBits The value which will be set
     */
    inline void setB8DRMStationInfoBits (const T_b8_Tun_DRMStationInfoBits& b8DRMStationInfoBits_);

    /**
     * Release the object stored in the field "b8DRMStationInfoBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8DRMStationInfoBits"
     */
    inline T_b8_Tun_DRMStationInfoBits* releaseB8DRMStationInfoBits();

    /**
     * Replace the field "b8DRMStationInfoBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8DRMStationInfoBits (T_b8_Tun_DRMStationInfoBits* b8DRMStationInfoBits_);

    // API of field "u32DRMServiceId"

    static const int kU32DRMServiceId = 25;

    /**
     * Clears the field "u32DRMServiceId".
     *
     * The field will be set to its default value. The hasU32DRMServiceId()
     * method will return false.
     */
    inline void clearU32DRMServiceId();

    /**
     * Checks whether the field "u32DRMServiceId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DRMServiceId()). Otherwise it will return false.
     */
    inline bool hasU32DRMServiceId () const;

    /**
     * Returns the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32DRMServiceId"
     */
    inline uint32 getU32DRMServiceId () const;

    /**
     * Sets the value of the member "u32DRMServiceId".
     *
     * If the meaning of "u32DRMServiceId" isn't clear, then there should be a description here.
     *
     * @param u32DRMServiceId The value which will be set
     */
    inline void setU32DRMServiceId (uint32 u32DRMServiceId_);

    // API of field "sDRMServiceLabel"

    static const int kSDRMServiceLabel = 26;

    /**
     * Clears the field "sDRMServiceLabel".
     *
     * The field will be set to its default value. The hasSDRMServiceLabel()
     * method will return false.
     */
    inline void clearSDRMServiceLabel();

    /**
     * Checks whether the field "sDRMServiceLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDRMServiceLabel()). Otherwise it will return false.
     */
    inline bool hasSDRMServiceLabel () const;

    /**
     * Returns the value of the member "sDRMServiceLabel".
     *
     * If the meaning of "sDRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "sDRMServiceLabel"
     */
    inline const ::std::string& getSDRMServiceLabel () const;

    /**
     * Retrieves the value of the field "sDRMServiceLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDRMServiceLabel".
     */
    inline ::std::string& getSDRMServiceLabelMutable ();

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * If the meaning of "sDRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const ::std::string& sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * If the meaning of "sDRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* sDRMServiceLabel_);

    /**
     * Sets the value of the member "sDRMServiceLabel".
     *
     * If the meaning of "sDRMServiceLabel" isn't clear, then there should be a description here.
     *
     * @param sDRMServiceLabel The value which will be set
     */
    inline void setSDRMServiceLabel (const char* value, size_t size);

    /**
     * Release the object stored in the field "sDRMServiceLabel".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sDRMServiceLabel"
     */
    inline ::std::string* releaseSDRMServiceLabel();

    /**
     * Replace the field "sDRMServiceLabel".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSDRMServiceLabel (::std::string* sDRMServiceLabel_);

    // API of field "u8DRMPTY"

    static const int kU8DRMPTY = 27;

    /**
     * Clears the field "u8DRMPTY".
     *
     * The field will be set to its default value. The hasU8DRMPTY()
     * method will return false.
     */
    inline void clearU8DRMPTY();

    /**
     * Checks whether the field "u8DRMPTY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMPTY()). Otherwise it will return false.
     */
    inline bool hasU8DRMPTY () const;

    /**
     * Returns the value of the member "u8DRMPTY".
     *
     * If the meaning of "u8DRMPTY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMPTY"
     */
    inline uint8 getU8DRMPTY () const;

    /**
     * Sets the value of the member "u8DRMPTY".
     *
     * If the meaning of "u8DRMPTY" isn't clear, then there should be a description here.
     *
     * @param u8DRMPTY The value which will be set
     */
    inline void setU8DRMPTY (uint8 u8DRMPTY_);

    // API of field "b16DRMAnnouBits"

    static const int kB16DRMAnnouBits = 28;

    /**
     * Clears the field "b16DRMAnnouBits".
     *
     * The field will be set to its default value. The hasB16DRMAnnouBits()
     * method will return false.
     */
    inline void clearB16DRMAnnouBits();

    /**
     * Checks whether the field "b16DRMAnnouBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB16DRMAnnouBits()). Otherwise it will return false.
     */
    inline bool hasB16DRMAnnouBits () const;

    /**
     * Returns the value of the member "b16DRMAnnouBits".
     *
     * If the meaning of "b16DRMAnnouBits" isn't clear, then there should be a description here.
     *
     * @return The value of the field "b16DRMAnnouBits"
     */
    inline const T_b16_Tun_DRMAnnouBits& getB16DRMAnnouBits () const;

    /**
     * Retrieves the value of the field "b16DRMAnnouBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b16DRMAnnouBits".
     */
    inline T_b16_Tun_DRMAnnouBits& getB16DRMAnnouBitsMutable ();

    /**
     * Sets the value of the member "b16DRMAnnouBits".
     *
     * If the meaning of "b16DRMAnnouBits" isn't clear, then there should be a description here.
     *
     * @param b16DRMAnnouBits The value which will be set
     */
    inline void setB16DRMAnnouBits (const T_b16_Tun_DRMAnnouBits& b16DRMAnnouBits_);

    /**
     * Release the object stored in the field "b16DRMAnnouBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b16DRMAnnouBits"
     */
    inline T_b16_Tun_DRMAnnouBits* releaseB16DRMAnnouBits();

    /**
     * Replace the field "b16DRMAnnouBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB16DRMAnnouBits (T_b16_Tun_DRMAnnouBits* b16DRMAnnouBits_);

    // API of field "b8DRMNumberOfAudioServices"

    static const int kB8DRMNumberOfAudioServices = 29;

    /**
     * Clears the field "b8DRMNumberOfAudioServices".
     *
     * The field will be set to its default value. The hasB8DRMNumberOfAudioServices()
     * method will return false.
     */
    inline void clearB8DRMNumberOfAudioServices();

    /**
     * Checks whether the field "b8DRMNumberOfAudioServices" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8DRMNumberOfAudioServices()). Otherwise it will return false.
     */
    inline bool hasB8DRMNumberOfAudioServices () const;

    /**
     * Returns the value of the member "b8DRMNumberOfAudioServices".
     *
     * If the meaning of "b8DRMNumberOfAudioServices" isn't clear, then there should be a description here.
     *
     * @return The value of the field "b8DRMNumberOfAudioServices"
     */
    inline const T_b8_Tun_DRMNumberOfAudioServices& getB8DRMNumberOfAudioServices () const;

    /**
     * Retrieves the value of the field "b8DRMNumberOfAudioServices" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8DRMNumberOfAudioServices".
     */
    inline T_b8_Tun_DRMNumberOfAudioServices& getB8DRMNumberOfAudioServicesMutable ();

    /**
     * Sets the value of the member "b8DRMNumberOfAudioServices".
     *
     * If the meaning of "b8DRMNumberOfAudioServices" isn't clear, then there should be a description here.
     *
     * @param b8DRMNumberOfAudioServices The value which will be set
     */
    inline void setB8DRMNumberOfAudioServices (const T_b8_Tun_DRMNumberOfAudioServices& b8DRMNumberOfAudioServices_);

    /**
     * Release the object stored in the field "b8DRMNumberOfAudioServices".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8DRMNumberOfAudioServices"
     */
    inline T_b8_Tun_DRMNumberOfAudioServices* releaseB8DRMNumberOfAudioServices();

    /**
     * Replace the field "b8DRMNumberOfAudioServices".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8DRMNumberOfAudioServices (T_b8_Tun_DRMNumberOfAudioServices* b8DRMNumberOfAudioServices_);

    // API of field "u8DRMQuality"

    static const int kU8DRMQuality = 30;

    /**
     * Clears the field "u8DRMQuality".
     *
     * The field will be set to its default value. The hasU8DRMQuality()
     * method will return false.
     */
    inline void clearU8DRMQuality();

    /**
     * Checks whether the field "u8DRMQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMQuality()). Otherwise it will return false.
     */
    inline bool hasU8DRMQuality () const;

    /**
     * Returns the value of the member "u8DRMQuality".
     *
     * If the meaning of "u8DRMQuality" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMQuality"
     */
    inline uint8 getU8DRMQuality () const;

    /**
     * Sets the value of the member "u8DRMQuality".
     *
     * If the meaning of "u8DRMQuality" isn't clear, then there should be a description here.
     *
     * @param u8DRMQuality The value which will be set
     */
    inline void setU8DRMQuality (uint8 u8DRMQuality_);

    // API of field "u8DRMServiceShortId"

    static const int kU8DRMServiceShortId = 31;

    /**
     * Clears the field "u8DRMServiceShortId".
     *
     * The field will be set to its default value. The hasU8DRMServiceShortId()
     * method will return false.
     */
    inline void clearU8DRMServiceShortId();

    /**
     * Checks whether the field "u8DRMServiceShortId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DRMServiceShortId()). Otherwise it will return false.
     */
    inline bool hasU8DRMServiceShortId () const;

    /**
     * Returns the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8DRMServiceShortId"
     */
    inline uint8 getU8DRMServiceShortId () const;

    /**
     * Sets the value of the member "u8DRMServiceShortId".
     *
     * If the meaning of "u8DRMServiceShortId" isn't clear, then there should be a description here.
     *
     * @param u8DRMServiceShortId The value which will be set
     */
    inline void setU8DRMServiceShortId (uint8 u8DRMServiceShortId_);

    // API of field "u8Drmlanguage"

    static const int kU8Drmlanguage = 32;

    /**
     * Clears the field "u8Drmlanguage".
     *
     * The field will be set to its default value. The hasU8Drmlanguage()
     * method will return false.
     */
    inline void clearU8Drmlanguage();

    /**
     * Checks whether the field "u8Drmlanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Drmlanguage()). Otherwise it will return false.
     */
    inline bool hasU8Drmlanguage () const;

    /**
     * Returns the value of the member "u8Drmlanguage".
     *
     * If the meaning of "u8Drmlanguage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u8Drmlanguage"
     */
    inline uint8 getU8Drmlanguage () const;

    /**
     * Sets the value of the member "u8Drmlanguage".
     *
     * If the meaning of "u8Drmlanguage" isn't clear, then there should be a description here.
     *
     * @param u8Drmlanguage The value which will be set
     */
    inline void setU8Drmlanguage (uint8 u8Drmlanguage_);

    // API of field "u32DrmlanguageCode"

    static const int kU32DrmlanguageCode = 33;

    /**
     * Clears the field "u32DrmlanguageCode".
     *
     * The field will be set to its default value. The hasU32DrmlanguageCode()
     * method will return false.
     */
    inline void clearU32DrmlanguageCode();

    /**
     * Checks whether the field "u32DrmlanguageCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DrmlanguageCode()). Otherwise it will return false.
     */
    inline bool hasU32DrmlanguageCode () const;

    /**
     * Returns the value of the member "u32DrmlanguageCode".
     *
     * If the meaning of "u32DrmlanguageCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32DrmlanguageCode"
     */
    inline uint32 getU32DrmlanguageCode () const;

    /**
     * Sets the value of the member "u32DrmlanguageCode".
     *
     * If the meaning of "u32DrmlanguageCode" isn't clear, then there should be a description here.
     *
     * @param u32DrmlanguageCode The value which will be set
     */
    inline void setU32DrmlanguageCode (uint32 u32DrmlanguageCode_);

    // API of field "u16DrmCountryCode"

    static const int kU16DrmCountryCode = 34;

    /**
     * Clears the field "u16DrmCountryCode".
     *
     * The field will be set to its default value. The hasU16DrmCountryCode()
     * method will return false.
     */
    inline void clearU16DrmCountryCode();

    /**
     * Checks whether the field "u16DrmCountryCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16DrmCountryCode()). Otherwise it will return false.
     */
    inline bool hasU16DrmCountryCode () const;

    /**
     * Returns the value of the member "u16DrmCountryCode".
     *
     * If the meaning of "u16DrmCountryCode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u16DrmCountryCode"
     */
    inline uint16 getU16DrmCountryCode () const;

    /**
     * Sets the value of the member "u16DrmCountryCode".
     *
     * If the meaning of "u16DrmCountryCode" isn't clear, then there should be a description here.
     *
     * @param u16DrmCountryCode The value which will be set
     */
    inline void setU16DrmCountryCode (uint16 u16DrmCountryCode_);

    // API of field "s8DrmFrequencyCorrection"

    static const int kS8DrmFrequencyCorrection = 35;

    /**
     * Clears the field "s8DrmFrequencyCorrection".
     *
     * The field will be set to its default value. The hasS8DrmFrequencyCorrection()
     * method will return false.
     */
    inline void clearS8DrmFrequencyCorrection();

    /**
     * Checks whether the field "s8DrmFrequencyCorrection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8DrmFrequencyCorrection()). Otherwise it will return false.
     */
    inline bool hasS8DrmFrequencyCorrection () const;

    /**
     * Returns the value of the member "s8DrmFrequencyCorrection".
     *
     * If the meaning of "s8DrmFrequencyCorrection" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s8DrmFrequencyCorrection"
     */
    inline int8 getS8DrmFrequencyCorrection () const;

    /**
     * Sets the value of the member "s8DrmFrequencyCorrection".
     *
     * If the meaning of "s8DrmFrequencyCorrection" isn't clear, then there should be a description here.
     *
     * @param s8DrmFrequencyCorrection The value which will be set
     */
    inline void setS8DrmFrequencyCorrection (int8 s8DrmFrequencyCorrection_);

    // API of field "u8JapanStationCount"

    static const int kU8JapanStationCount = 36;

    /**
     * Clears the field "u8JapanStationCount".
     *
     * The field will be set to its default value. The hasU8JapanStationCount()
     * method will return false.
     */
    inline void clearU8JapanStationCount();

    /**
     * Checks whether the field "u8JapanStationCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8JapanStationCount()). Otherwise it will return false.
     */
    inline bool hasU8JapanStationCount () const;

    /**
     * Returns the value of the member "u8JapanStationCount".
     *
     * Provides the total number of Japan stations available at current frequency and selected area code
     *
     * @return The value of the field "u8JapanStationCount"
     */
    inline uint8 getU8JapanStationCount () const;

    /**
     * Sets the value of the member "u8JapanStationCount".
     *
     * Provides the total number of Japan stations available at current frequency and selected area code
     *
     * @param u8JapanStationCount The value which will be set
     */
    inline void setU8JapanStationCount (uint8 u8JapanStationCount_);

    // API of field "bUserPresetAction"

    static const int kBUserPresetAction = 37;

    /**
     * Clears the field "bUserPresetAction".
     *
     * The field will be set to its default value. The hasBUserPresetAction()
     * method will return false.
     */
    inline void clearBUserPresetAction();

    /**
     * Checks whether the field "bUserPresetAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUserPresetAction()). Otherwise it will return false.
     */
    inline bool hasBUserPresetAction () const;

    /**
     * Returns the value of the member "bUserPresetAction".
     *
     * Indicates if the u16StaticListElementID update is due to user preset action or not
     *
     * @return The value of the field "bUserPresetAction"
     */
    inline bool getBUserPresetAction () const;

    /**
     * Sets the value of the member "bUserPresetAction".
     *
     * Indicates if the u16StaticListElementID update is due to user preset action or not
     *
     * @param bUserPresetAction The value which will be set
     */
    inline void setBUserPresetAction (bool bUserPresetAction_);

    static const T_Atstationinfo &getDefaultInstance();

private:

    inline void set_has_u8TunerHeader ();

    inline void clear_has_u8TunerHeader ();

    inline void set_has_u32AvailFlags ();

    inline void clear_has_u32AvailFlags ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_sPSName ();

    inline void clear_has_sPSName ();

    inline void set_has_e8Band ();

    inline void clear_has_e8Band ();

    inline void set_has_e8AtStationTPinfo ();

    inline void clear_has_e8AtStationTPinfo ();

    inline void set_has_u16PresetListID ();

    inline void clear_has_u16PresetListID ();

    inline void set_has_u8ActiveStationList ();

    inline void clear_has_u8ActiveStationList ();

    inline void set_has_u16StaticListElementID ();

    inline void clear_has_u16StaticListElementID ();

    inline void set_has_u16ConfigListElementID ();

    inline void clear_has_u16ConfigListElementID ();

    inline void set_has_u8AtStationInfoBits ();

    inline void clear_has_u8AtStationInfoBits ();

    inline void set_has_u8PTY ();

    inline void clear_has_u8PTY ();

    inline void set_has_u8FieldStrngth ();

    inline void clear_has_u8FieldStrngth ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    inline void set_has_b8HDStationInfoBits ();

    inline void clear_has_b8HDStationInfoBits ();

    inline void set_has_u32StationInfoHDStationID ();

    inline void clear_has_u32StationInfoHDStationID ();

    inline void set_has_sHDCallSign ();

    inline void clear_has_sHDCallSign ();

    inline void set_has_e8HDCallSignTextEncoding ();

    inline void clear_has_e8HDCallSignTextEncoding ();

    inline void set_has_u8HDStationGenre ();

    inline void clear_has_u8HDStationGenre ();

    inline void set_has_b8HDAudioPrgmAvail ();

    inline void clear_has_b8HDAudioPrgmAvail ();

    inline void set_has_u8HDQuality ();

    inline void clear_has_u8HDQuality ();

    inline void set_has_e8ActiveHDAudPrgm ();

    inline void clear_has_e8ActiveHDAudPrgm ();

    inline void set_has_StationLogo ();

    inline void clear_has_StationLogo ();

    inline void set_has_b8DRMStationInfoBits ();

    inline void clear_has_b8DRMStationInfoBits ();

    inline void set_has_u32DRMServiceId ();

    inline void clear_has_u32DRMServiceId ();

    inline void set_has_sDRMServiceLabel ();

    inline void clear_has_sDRMServiceLabel ();

    inline void set_has_u8DRMPTY ();

    inline void clear_has_u8DRMPTY ();

    inline void set_has_b16DRMAnnouBits ();

    inline void clear_has_b16DRMAnnouBits ();

    inline void set_has_b8DRMNumberOfAudioServices ();

    inline void clear_has_b8DRMNumberOfAudioServices ();

    inline void set_has_u8DRMQuality ();

    inline void clear_has_u8DRMQuality ();

    inline void set_has_u8DRMServiceShortId ();

    inline void clear_has_u8DRMServiceShortId ();

    inline void set_has_u8Drmlanguage ();

    inline void clear_has_u8Drmlanguage ();

    inline void set_has_u32DrmlanguageCode ();

    inline void clear_has_u32DrmlanguageCode ();

    inline void set_has_u16DrmCountryCode ();

    inline void clear_has_u16DrmCountryCode ();

    inline void set_has_s8DrmFrequencyCorrection ();

    inline void clear_has_s8DrmFrequencyCorrection ();

    inline void set_has_u8JapanStationCount ();

    inline void clear_has_u8JapanStationCount ();

    inline void set_has_bUserPresetAction ();

    inline void clear_has_bUserPresetAction ();

    uint32 _has_bits_[ (38 + 31) / 32];

    T_e8_Tun_TunerHeader _u8TunerHeader;

    T_b32_Tun_AvailFlags* _u32AvailFlags;

    uint32 _u32Frequency;

    uint16 _u16PI;

    ::std::string* _sPSName;

    T_e8_Tun_TunerBand _e8Band;

    T_e8_AtStationTPinfo _e8AtStationTPinfo;

    uint16 _u16PresetListID;

    uint8 _u8ActiveStationList;

    uint16 _u16StaticListElementID;

    uint16 _u16ConfigListElementID;

    T_b8_Tun_AtStationInfoBits* _u8AtStationInfoBits;

    uint8 _u8PTY;

    uint8 _u8FieldStrngth;

    uint8 _u8Quality;

    T_b8_Tun_HDInfoBits* _b8HDStationInfoBits;

    uint32 _u32StationInfoHDStationID;

    ::std::string* _sHDCallSign;

    T_e8_Tun_HD_TextEncodingType _e8HDCallSignTextEncoding;

    uint8 _u8HDStationGenre;

    T_b8_Tun_HDPrgmAvail* _b8HDAudioPrgmAvail;

    uint8 _u8HDQuality;

    T_e8_Tun_HDAudioProgram _e8ActiveHDAudPrgm;

    ::std::string* _StationLogo;

    T_b8_Tun_DRMStationInfoBits* _b8DRMStationInfoBits;

    uint32 _u32DRMServiceId;

    ::std::string* _sDRMServiceLabel;

    uint8 _u8DRMPTY;

    T_b16_Tun_DRMAnnouBits* _b16DRMAnnouBits;

    T_b8_Tun_DRMNumberOfAudioServices* _b8DRMNumberOfAudioServices;

    uint8 _u8DRMQuality;

    uint8 _u8DRMServiceShortId;

    uint8 _u8Drmlanguage;

    uint32 _u32DrmlanguageCode;

    uint16 _u16DrmCountryCode;

    int8 _s8DrmFrequencyCorrection;

    uint8 _u8JapanStationCount;

    bool _bUserPresetAction;

};

/**
 * TunerTest Mode Data with the DDA/DDS parameter Added.
 */
class T_TunerTestModeData_DDADDS {
public:

    /**
     * Default constructor
     */
    inline  T_TunerTestModeData_DDADDS ();

    /**
     * Copy constructor
     */
    inline  T_TunerTestModeData_DDADDS (const T_TunerTestModeData_DDADDS &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerTestModeData_DDADDS (T_e8_Tun_PhysicalTuner u8PhysicalTuner_, T_e8_Tun_Testmode_TunerBand u8Source_, uint32 u32AFFrequency_, uint16 u16CurrentPI_, uint16 u16TargetPI_, uint8 u8Quality_, uint8 u8Fieldstrength_, uint8 u8Multipath_, uint8 u8Neighbour_, uint8 u8AFListLength_, uint8 u8HiCut_, uint8 u8Sharx_, const ::std::string& sCurrentStationName_, const ::std::string& sFixPSName_, bool bScrollPSStatus_, bool bAFStatus_, uint8 u8FMDeviation_, uint8 u8RDSDeviation_, int8 s8IFOffset_, int8 s8RDSOffset_, uint8 u8CoChannelStatus_, uint8 u8AGC_, uint8 u8ChannelSeparation_, uint8 u8RdsErrorRate_, T_e8_Tun_DiversityState e8DiversityState_, T_e8_Tun_AntennaPathSwitch1 e8AntennaPathSwitch1_, T_e8_Tun_AntennaPathSwitch2 e8AntennaPathSwitch2_, const T_b8_Tun_TestmodeBits& u8TestmodeBits_, uint8 u8HicutExtender_);

    /**
     * Destructor
     */
    inline  ~T_TunerTestModeData_DDADDS();

    /**
     * Assignment operator
     */
    inline T_TunerTestModeData_DDADDS& operator = (const T_TunerTestModeData_DDADDS& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerTestModeData_DDADDS& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerTestModeData_DDADDS& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerTestModeData_DDADDS& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerTestModeData_DDADDS& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8PhysicalTuner"

    static const int kU8PhysicalTuner = 0;

    /**
     * Clears the field "u8PhysicalTuner".
     *
     * The field will be set to its default value. The hasU8PhysicalTuner()
     * method will return false.
     */
    inline void clearU8PhysicalTuner();

    /**
     * Checks whether the field "u8PhysicalTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PhysicalTuner()). Otherwise it will return false.
     */
    inline bool hasU8PhysicalTuner () const;

    /**
     * Returns the value of the member "u8PhysicalTuner".
     *
     * This element describes which physical tuner is used.
     *
     * @return The value of the field "u8PhysicalTuner"
     */
    inline T_e8_Tun_PhysicalTuner getU8PhysicalTuner () const;

    /**
     * Sets the value of the member "u8PhysicalTuner".
     *
     * This element describes which physical tuner is used.
     *
     * @param u8PhysicalTuner The value which will be set
     */
    inline void setU8PhysicalTuner (T_e8_Tun_PhysicalTuner u8PhysicalTuner_);

    // API of field "u8Source"

    static const int kU8Source = 1;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * .
     *
     * @return The value of the field "u8Source"
     */
    inline T_e8_Tun_Testmode_TunerBand getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * .
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (T_e8_Tun_Testmode_TunerBand u8Source_);

    // API of field "u32AFFrequency"

    static const int kU32AFFrequency = 2;

    /**
     * Clears the field "u32AFFrequency".
     *
     * The field will be set to its default value. The hasU32AFFrequency()
     * method will return false.
     */
    inline void clearU32AFFrequency();

    /**
     * Checks whether the field "u32AFFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AFFrequency()). Otherwise it will return false.
     */
    inline bool hasU32AFFrequency () const;

    /**
     * Returns the value of the member "u32AFFrequency".
     *
     * .
     *
     * @return The value of the field "u32AFFrequency"
     */
    inline uint32 getU32AFFrequency () const;

    /**
     * Sets the value of the member "u32AFFrequency".
     *
     * .
     *
     * @param u32AFFrequency The value which will be set
     */
    inline void setU32AFFrequency (uint32 u32AFFrequency_);

    // API of field "u16CurrentPI"

    static const int kU16CurrentPI = 3;

    /**
     * Clears the field "u16CurrentPI".
     *
     * The field will be set to its default value. The hasU16CurrentPI()
     * method will return false.
     */
    inline void clearU16CurrentPI();

    /**
     * Checks whether the field "u16CurrentPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16CurrentPI()). Otherwise it will return false.
     */
    inline bool hasU16CurrentPI () const;

    /**
     * Returns the value of the member "u16CurrentPI".
     *
     * .
     *
     * @return The value of the field "u16CurrentPI"
     */
    inline uint16 getU16CurrentPI () const;

    /**
     * Sets the value of the member "u16CurrentPI".
     *
     * .
     *
     * @param u16CurrentPI The value which will be set
     */
    inline void setU16CurrentPI (uint16 u16CurrentPI_);

    // API of field "u16TargetPI"

    static const int kU16TargetPI = 4;

    /**
     * Clears the field "u16TargetPI".
     *
     * The field will be set to its default value. The hasU16TargetPI()
     * method will return false.
     */
    inline void clearU16TargetPI();

    /**
     * Checks whether the field "u16TargetPI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TargetPI()). Otherwise it will return false.
     */
    inline bool hasU16TargetPI () const;

    /**
     * Returns the value of the member "u16TargetPI".
     *
     * .
     *
     * @return The value of the field "u16TargetPI"
     */
    inline uint16 getU16TargetPI () const;

    /**
     * Sets the value of the member "u16TargetPI".
     *
     * .
     *
     * @param u16TargetPI The value which will be set
     */
    inline void setU16TargetPI (uint16 u16TargetPI_);

    // API of field "u8Quality"

    static const int kU8Quality = 5;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * .
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * .
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    // API of field "u8Fieldstrength"

    static const int kU8Fieldstrength = 6;

    /**
     * Clears the field "u8Fieldstrength".
     *
     * The field will be set to its default value. The hasU8Fieldstrength()
     * method will return false.
     */
    inline void clearU8Fieldstrength();

    /**
     * Checks whether the field "u8Fieldstrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Fieldstrength()). Otherwise it will return false.
     */
    inline bool hasU8Fieldstrength () const;

    /**
     * Returns the value of the member "u8Fieldstrength".
     *
     * .
     *
     * @return The value of the field "u8Fieldstrength"
     */
    inline uint8 getU8Fieldstrength () const;

    /**
     * Sets the value of the member "u8Fieldstrength".
     *
     * .
     *
     * @param u8Fieldstrength The value which will be set
     */
    inline void setU8Fieldstrength (uint8 u8Fieldstrength_);

    // API of field "u8Multipath"

    static const int kU8Multipath = 7;

    /**
     * Clears the field "u8Multipath".
     *
     * The field will be set to its default value. The hasU8Multipath()
     * method will return false.
     */
    inline void clearU8Multipath();

    /**
     * Checks whether the field "u8Multipath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Multipath()). Otherwise it will return false.
     */
    inline bool hasU8Multipath () const;

    /**
     * Returns the value of the member "u8Multipath".
     *
     * .
     *
     * @return The value of the field "u8Multipath"
     */
    inline uint8 getU8Multipath () const;

    /**
     * Sets the value of the member "u8Multipath".
     *
     * .
     *
     * @param u8Multipath The value which will be set
     */
    inline void setU8Multipath (uint8 u8Multipath_);

    // API of field "u8Neighbour"

    static const int kU8Neighbour = 8;

    /**
     * Clears the field "u8Neighbour".
     *
     * The field will be set to its default value. The hasU8Neighbour()
     * method will return false.
     */
    inline void clearU8Neighbour();

    /**
     * Checks whether the field "u8Neighbour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Neighbour()). Otherwise it will return false.
     */
    inline bool hasU8Neighbour () const;

    /**
     * Returns the value of the member "u8Neighbour".
     *
     * .
     *
     * @return The value of the field "u8Neighbour"
     */
    inline uint8 getU8Neighbour () const;

    /**
     * Sets the value of the member "u8Neighbour".
     *
     * .
     *
     * @param u8Neighbour The value which will be set
     */
    inline void setU8Neighbour (uint8 u8Neighbour_);

    // API of field "u8AFListLength"

    static const int kU8AFListLength = 9;

    /**
     * Clears the field "u8AFListLength".
     *
     * The field will be set to its default value. The hasU8AFListLength()
     * method will return false.
     */
    inline void clearU8AFListLength();

    /**
     * Checks whether the field "u8AFListLength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AFListLength()). Otherwise it will return false.
     */
    inline bool hasU8AFListLength () const;

    /**
     * Returns the value of the member "u8AFListLength".
     *
     * .
     *
     * @return The value of the field "u8AFListLength"
     */
    inline uint8 getU8AFListLength () const;

    /**
     * Sets the value of the member "u8AFListLength".
     *
     * .
     *
     * @param u8AFListLength The value which will be set
     */
    inline void setU8AFListLength (uint8 u8AFListLength_);

    // API of field "u8HiCut"

    static const int kU8HiCut = 10;

    /**
     * Clears the field "u8HiCut".
     *
     * The field will be set to its default value. The hasU8HiCut()
     * method will return false.
     */
    inline void clearU8HiCut();

    /**
     * Checks whether the field "u8HiCut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HiCut()). Otherwise it will return false.
     */
    inline bool hasU8HiCut () const;

    /**
     * Returns the value of the member "u8HiCut".
     *
     * .
     *
     * @return The value of the field "u8HiCut"
     */
    inline uint8 getU8HiCut () const;

    /**
     * Sets the value of the member "u8HiCut".
     *
     * .
     *
     * @param u8HiCut The value which will be set
     */
    inline void setU8HiCut (uint8 u8HiCut_);

    // API of field "u8Sharx"

    static const int kU8Sharx = 11;

    /**
     * Clears the field "u8Sharx".
     *
     * The field will be set to its default value. The hasU8Sharx()
     * method will return false.
     */
    inline void clearU8Sharx();

    /**
     * Checks whether the field "u8Sharx" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Sharx()). Otherwise it will return false.
     */
    inline bool hasU8Sharx () const;

    /**
     * Returns the value of the member "u8Sharx".
     *
     * .
     *
     * @return The value of the field "u8Sharx"
     */
    inline uint8 getU8Sharx () const;

    /**
     * Sets the value of the member "u8Sharx".
     *
     * .
     *
     * @param u8Sharx The value which will be set
     */
    inline void setU8Sharx (uint8 u8Sharx_);

    // API of field "sCurrentStationName"

    static const int kSCurrentStationName = 12;

    /**
     * Clears the field "sCurrentStationName".
     *
     * The field will be set to its default value. The hasSCurrentStationName()
     * method will return false.
     */
    inline void clearSCurrentStationName();

    /**
     * Checks whether the field "sCurrentStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSCurrentStationName()). Otherwise it will return false.
     */
    inline bool hasSCurrentStationName () const;

    /**
     * Returns the value of the member "sCurrentStationName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sCurrentStationName"
     */
    inline const ::std::string& getSCurrentStationName () const;

    /**
     * Retrieves the value of the field "sCurrentStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sCurrentStationName".
     */
    inline ::std::string& getSCurrentStationNameMutable ();

    /**
     * Sets the value of the member "sCurrentStationName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sCurrentStationName The value which will be set
     */
    inline void setSCurrentStationName (const ::std::string& sCurrentStationName_);

    /**
     * Sets the value of the member "sCurrentStationName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sCurrentStationName The value which will be set
     */
    inline void setSCurrentStationName (const char* sCurrentStationName_);

    /**
     * Sets the value of the member "sCurrentStationName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sCurrentStationName The value which will be set
     */
    inline void setSCurrentStationName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sCurrentStationName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sCurrentStationName"
     */
    inline ::std::string* releaseSCurrentStationName();

    /**
     * Replace the field "sCurrentStationName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSCurrentStationName (::std::string* sCurrentStationName_);

    // API of field "sFixPSName"

    static const int kSFixPSName = 13;

    /**
     * Clears the field "sFixPSName".
     *
     * The field will be set to its default value. The hasSFixPSName()
     * method will return false.
     */
    inline void clearSFixPSName();

    /**
     * Checks whether the field "sFixPSName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSFixPSName()). Otherwise it will return false.
     */
    inline bool hasSFixPSName () const;

    /**
     * Returns the value of the member "sFixPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "sFixPSName"
     */
    inline const ::std::string& getSFixPSName () const;

    /**
     * Retrieves the value of the field "sFixPSName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sFixPSName".
     */
    inline ::std::string& getSFixPSNameMutable ();

    /**
     * Sets the value of the member "sFixPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sFixPSName The value which will be set
     */
    inline void setSFixPSName (const ::std::string& sFixPSName_);

    /**
     * Sets the value of the member "sFixPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sFixPSName The value which will be set
     */
    inline void setSFixPSName (const char* sFixPSName_);

    /**
     * Sets the value of the member "sFixPSName".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param sFixPSName The value which will be set
     */
    inline void setSFixPSName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sFixPSName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sFixPSName"
     */
    inline ::std::string* releaseSFixPSName();

    /**
     * Replace the field "sFixPSName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSFixPSName (::std::string* sFixPSName_);

    // API of field "bScrollPSStatus"

    static const int kBScrollPSStatus = 14;

    /**
     * Clears the field "bScrollPSStatus".
     *
     * The field will be set to its default value. The hasBScrollPSStatus()
     * method will return false.
     */
    inline void clearBScrollPSStatus();

    /**
     * Checks whether the field "bScrollPSStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBScrollPSStatus()). Otherwise it will return false.
     */
    inline bool hasBScrollPSStatus () const;

    /**
     * Returns the value of the member "bScrollPSStatus".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "bScrollPSStatus"
     */
    inline bool getBScrollPSStatus () const;

    /**
     * Sets the value of the member "bScrollPSStatus".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param bScrollPSStatus The value which will be set
     */
    inline void setBScrollPSStatus (bool bScrollPSStatus_);

    // API of field "bAFStatus"

    static const int kBAFStatus = 15;

    /**
     * Clears the field "bAFStatus".
     *
     * The field will be set to its default value. The hasBAFStatus()
     * method will return false.
     */
    inline void clearBAFStatus();

    /**
     * Checks whether the field "bAFStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBAFStatus()). Otherwise it will return false.
     */
    inline bool hasBAFStatus () const;

    /**
     * Returns the value of the member "bAFStatus".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @return The value of the field "bAFStatus"
     */
    inline bool getBAFStatus () const;

    /**
     * Sets the value of the member "bAFStatus".
     *
     * Gives the PSName of the station in UTF8 Format. Max Length: 32 + 1
     *
     * @param bAFStatus The value which will be set
     */
    inline void setBAFStatus (bool bAFStatus_);

    // API of field "u8FMDeviation"

    static const int kU8FMDeviation = 16;

    /**
     * Clears the field "u8FMDeviation".
     *
     * The field will be set to its default value. The hasU8FMDeviation()
     * method will return false.
     */
    inline void clearU8FMDeviation();

    /**
     * Checks whether the field "u8FMDeviation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FMDeviation()). Otherwise it will return false.
     */
    inline bool hasU8FMDeviation () const;

    /**
     * Returns the value of the member "u8FMDeviation".
     *
     * .
     *
     * @return The value of the field "u8FMDeviation"
     */
    inline uint8 getU8FMDeviation () const;

    /**
     * Sets the value of the member "u8FMDeviation".
     *
     * .
     *
     * @param u8FMDeviation The value which will be set
     */
    inline void setU8FMDeviation (uint8 u8FMDeviation_);

    // API of field "u8RDSDeviation"

    static const int kU8RDSDeviation = 17;

    /**
     * Clears the field "u8RDSDeviation".
     *
     * The field will be set to its default value. The hasU8RDSDeviation()
     * method will return false.
     */
    inline void clearU8RDSDeviation();

    /**
     * Checks whether the field "u8RDSDeviation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RDSDeviation()). Otherwise it will return false.
     */
    inline bool hasU8RDSDeviation () const;

    /**
     * Returns the value of the member "u8RDSDeviation".
     *
     * .
     *
     * @return The value of the field "u8RDSDeviation"
     */
    inline uint8 getU8RDSDeviation () const;

    /**
     * Sets the value of the member "u8RDSDeviation".
     *
     * .
     *
     * @param u8RDSDeviation The value which will be set
     */
    inline void setU8RDSDeviation (uint8 u8RDSDeviation_);

    // API of field "s8IFOffset"

    static const int kS8IFOffset = 18;

    /**
     * Clears the field "s8IFOffset".
     *
     * The field will be set to its default value. The hasS8IFOffset()
     * method will return false.
     */
    inline void clearS8IFOffset();

    /**
     * Checks whether the field "s8IFOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8IFOffset()). Otherwise it will return false.
     */
    inline bool hasS8IFOffset () const;

    /**
     * Returns the value of the member "s8IFOffset".
     *
     * .
     *
     * @return The value of the field "s8IFOffset"
     */
    inline int8 getS8IFOffset () const;

    /**
     * Sets the value of the member "s8IFOffset".
     *
     * .
     *
     * @param s8IFOffset The value which will be set
     */
    inline void setS8IFOffset (int8 s8IFOffset_);

    // API of field "s8RDSOffset"

    static const int kS8RDSOffset = 19;

    /**
     * Clears the field "s8RDSOffset".
     *
     * The field will be set to its default value. The hasS8RDSOffset()
     * method will return false.
     */
    inline void clearS8RDSOffset();

    /**
     * Checks whether the field "s8RDSOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8RDSOffset()). Otherwise it will return false.
     */
    inline bool hasS8RDSOffset () const;

    /**
     * Returns the value of the member "s8RDSOffset".
     *
     * .
     *
     * @return The value of the field "s8RDSOffset"
     */
    inline int8 getS8RDSOffset () const;

    /**
     * Sets the value of the member "s8RDSOffset".
     *
     * .
     *
     * @param s8RDSOffset The value which will be set
     */
    inline void setS8RDSOffset (int8 s8RDSOffset_);

    // API of field "u8CoChannelStatus"

    static const int kU8CoChannelStatus = 20;

    /**
     * Clears the field "u8CoChannelStatus".
     *
     * The field will be set to its default value. The hasU8CoChannelStatus()
     * method will return false.
     */
    inline void clearU8CoChannelStatus();

    /**
     * Checks whether the field "u8CoChannelStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CoChannelStatus()). Otherwise it will return false.
     */
    inline bool hasU8CoChannelStatus () const;

    /**
     * Returns the value of the member "u8CoChannelStatus".
     *
     * .
     *
     * @return The value of the field "u8CoChannelStatus"
     */
    inline uint8 getU8CoChannelStatus () const;

    /**
     * Sets the value of the member "u8CoChannelStatus".
     *
     * .
     *
     * @param u8CoChannelStatus The value which will be set
     */
    inline void setU8CoChannelStatus (uint8 u8CoChannelStatus_);

    // API of field "u8AGC"

    static const int kU8AGC = 21;

    /**
     * Clears the field "u8AGC".
     *
     * The field will be set to its default value. The hasU8AGC()
     * method will return false.
     */
    inline void clearU8AGC();

    /**
     * Checks whether the field "u8AGC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AGC()). Otherwise it will return false.
     */
    inline bool hasU8AGC () const;

    /**
     * Returns the value of the member "u8AGC".
     *
     * .
     *
     * @return The value of the field "u8AGC"
     */
    inline uint8 getU8AGC () const;

    /**
     * Sets the value of the member "u8AGC".
     *
     * .
     *
     * @param u8AGC The value which will be set
     */
    inline void setU8AGC (uint8 u8AGC_);

    // API of field "u8ChannelSeparation"

    static const int kU8ChannelSeparation = 22;

    /**
     * Clears the field "u8ChannelSeparation".
     *
     * The field will be set to its default value. The hasU8ChannelSeparation()
     * method will return false.
     */
    inline void clearU8ChannelSeparation();

    /**
     * Checks whether the field "u8ChannelSeparation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ChannelSeparation()). Otherwise it will return false.
     */
    inline bool hasU8ChannelSeparation () const;

    /**
     * Returns the value of the member "u8ChannelSeparation".
     *
     *
     *
     * @return The value of the field "u8ChannelSeparation"
     */
    inline uint8 getU8ChannelSeparation () const;

    /**
     * Sets the value of the member "u8ChannelSeparation".
     *
     *
     *
     * @param u8ChannelSeparation The value which will be set
     */
    inline void setU8ChannelSeparation (uint8 u8ChannelSeparation_);

    // API of field "u8RdsErrorRate"

    static const int kU8RdsErrorRate = 23;

    /**
     * Clears the field "u8RdsErrorRate".
     *
     * The field will be set to its default value. The hasU8RdsErrorRate()
     * method will return false.
     */
    inline void clearU8RdsErrorRate();

    /**
     * Checks whether the field "u8RdsErrorRate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8RdsErrorRate()). Otherwise it will return false.
     */
    inline bool hasU8RdsErrorRate () const;

    /**
     * Returns the value of the member "u8RdsErrorRate".
     *
     *
     *
     * @return The value of the field "u8RdsErrorRate"
     */
    inline uint8 getU8RdsErrorRate () const;

    /**
     * Sets the value of the member "u8RdsErrorRate".
     *
     *
     *
     * @param u8RdsErrorRate The value which will be set
     */
    inline void setU8RdsErrorRate (uint8 u8RdsErrorRate_);

    // API of field "e8DiversityState"

    static const int kE8DiversityState = 24;

    /**
     * Clears the field "e8DiversityState".
     *
     * The field will be set to its default value. The hasE8DiversityState()
     * method will return false.
     */
    inline void clearE8DiversityState();

    /**
     * Checks whether the field "e8DiversityState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DiversityState()). Otherwise it will return false.
     */
    inline bool hasE8DiversityState () const;

    /**
     * Returns the value of the member "e8DiversityState".
     *
     *
     *
     * @return The value of the field "e8DiversityState"
     */
    inline T_e8_Tun_DiversityState getE8DiversityState () const;

    /**
     * Sets the value of the member "e8DiversityState".
     *
     *
     *
     * @param e8DiversityState The value which will be set
     */
    inline void setE8DiversityState (T_e8_Tun_DiversityState e8DiversityState_);

    // API of field "e8AntennaPathSwitch1"

    static const int kE8AntennaPathSwitch1 = 25;

    /**
     * Clears the field "e8AntennaPathSwitch1".
     *
     * The field will be set to its default value. The hasE8AntennaPathSwitch1()
     * method will return false.
     */
    inline void clearE8AntennaPathSwitch1();

    /**
     * Checks whether the field "e8AntennaPathSwitch1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AntennaPathSwitch1()). Otherwise it will return false.
     */
    inline bool hasE8AntennaPathSwitch1 () const;

    /**
     * Returns the value of the member "e8AntennaPathSwitch1".
     *
     *
     *
     * @return The value of the field "e8AntennaPathSwitch1"
     */
    inline T_e8_Tun_AntennaPathSwitch1 getE8AntennaPathSwitch1 () const;

    /**
     * Sets the value of the member "e8AntennaPathSwitch1".
     *
     *
     *
     * @param e8AntennaPathSwitch1 The value which will be set
     */
    inline void setE8AntennaPathSwitch1 (T_e8_Tun_AntennaPathSwitch1 e8AntennaPathSwitch1_);

    // API of field "e8AntennaPathSwitch2"

    static const int kE8AntennaPathSwitch2 = 26;

    /**
     * Clears the field "e8AntennaPathSwitch2".
     *
     * The field will be set to its default value. The hasE8AntennaPathSwitch2()
     * method will return false.
     */
    inline void clearE8AntennaPathSwitch2();

    /**
     * Checks whether the field "e8AntennaPathSwitch2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AntennaPathSwitch2()). Otherwise it will return false.
     */
    inline bool hasE8AntennaPathSwitch2 () const;

    /**
     * Returns the value of the member "e8AntennaPathSwitch2".
     *
     *
     *
     * @return The value of the field "e8AntennaPathSwitch2"
     */
    inline T_e8_Tun_AntennaPathSwitch2 getE8AntennaPathSwitch2 () const;

    /**
     * Sets the value of the member "e8AntennaPathSwitch2".
     *
     *
     *
     * @param e8AntennaPathSwitch2 The value which will be set
     */
    inline void setE8AntennaPathSwitch2 (T_e8_Tun_AntennaPathSwitch2 e8AntennaPathSwitch2_);

    // API of field "u8TestmodeBits"

    static const int kU8TestmodeBits = 27;

    /**
     * Clears the field "u8TestmodeBits".
     *
     * The field will be set to its default value. The hasU8TestmodeBits()
     * method will return false.
     */
    inline void clearU8TestmodeBits();

    /**
     * Checks whether the field "u8TestmodeBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TestmodeBits()). Otherwise it will return false.
     */
    inline bool hasU8TestmodeBits () const;

    /**
     * Returns the value of the member "u8TestmodeBits".
     *
     * TP_BIT      (BIT1)
     * TA_BIT      (BIT2)
     * TMC_BIT		(BIT3)
     * UNUSED_BIT  (BIT4)
     * AUDIO_TUNER_BIT  (BIT5)
     *
     * @return The value of the field "u8TestmodeBits"
     */
    inline const T_b8_Tun_TestmodeBits& getU8TestmodeBits () const;

    /**
     * Retrieves the value of the field "u8TestmodeBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u8TestmodeBits".
     */
    inline T_b8_Tun_TestmodeBits& getU8TestmodeBitsMutable ();

    /**
     * Sets the value of the member "u8TestmodeBits".
     *
     * TP_BIT      (BIT1)
     * TA_BIT      (BIT2)
     * TMC_BIT		(BIT3)
     * UNUSED_BIT  (BIT4)
     * AUDIO_TUNER_BIT  (BIT5)
     *
     * @param u8TestmodeBits The value which will be set
     */
    inline void setU8TestmodeBits (const T_b8_Tun_TestmodeBits& u8TestmodeBits_);

    /**
     * Release the object stored in the field "u8TestmodeBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "u8TestmodeBits"
     */
    inline T_b8_Tun_TestmodeBits* releaseU8TestmodeBits();

    /**
     * Replace the field "u8TestmodeBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceU8TestmodeBits (T_b8_Tun_TestmodeBits* u8TestmodeBits_);

    // API of field "u8HicutExtender"

    static const int kU8HicutExtender = 28;

    /**
     * Clears the field "u8HicutExtender".
     *
     * The field will be set to its default value. The hasU8HicutExtender()
     * method will return false.
     */
    inline void clearU8HicutExtender();

    /**
     * Checks whether the field "u8HicutExtender" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8HicutExtender()). Otherwise it will return false.
     */
    inline bool hasU8HicutExtender () const;

    /**
     * Returns the value of the member "u8HicutExtender".
     *
     * Hicut extender value
     *
     * @return The value of the field "u8HicutExtender"
     */
    inline uint8 getU8HicutExtender () const;

    /**
     * Sets the value of the member "u8HicutExtender".
     *
     * Hicut extender value
     *
     * @param u8HicutExtender The value which will be set
     */
    inline void setU8HicutExtender (uint8 u8HicutExtender_);

    static const T_TunerTestModeData_DDADDS &getDefaultInstance();

private:

    inline void set_has_u8PhysicalTuner ();

    inline void clear_has_u8PhysicalTuner ();

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u32AFFrequency ();

    inline void clear_has_u32AFFrequency ();

    inline void set_has_u16CurrentPI ();

    inline void clear_has_u16CurrentPI ();

    inline void set_has_u16TargetPI ();

    inline void clear_has_u16TargetPI ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    inline void set_has_u8Fieldstrength ();

    inline void clear_has_u8Fieldstrength ();

    inline void set_has_u8Multipath ();

    inline void clear_has_u8Multipath ();

    inline void set_has_u8Neighbour ();

    inline void clear_has_u8Neighbour ();

    inline void set_has_u8AFListLength ();

    inline void clear_has_u8AFListLength ();

    inline void set_has_u8HiCut ();

    inline void clear_has_u8HiCut ();

    inline void set_has_u8Sharx ();

    inline void clear_has_u8Sharx ();

    inline void set_has_sCurrentStationName ();

    inline void clear_has_sCurrentStationName ();

    inline void set_has_sFixPSName ();

    inline void clear_has_sFixPSName ();

    inline void set_has_bScrollPSStatus ();

    inline void clear_has_bScrollPSStatus ();

    inline void set_has_bAFStatus ();

    inline void clear_has_bAFStatus ();

    inline void set_has_u8FMDeviation ();

    inline void clear_has_u8FMDeviation ();

    inline void set_has_u8RDSDeviation ();

    inline void clear_has_u8RDSDeviation ();

    inline void set_has_s8IFOffset ();

    inline void clear_has_s8IFOffset ();

    inline void set_has_s8RDSOffset ();

    inline void clear_has_s8RDSOffset ();

    inline void set_has_u8CoChannelStatus ();

    inline void clear_has_u8CoChannelStatus ();

    inline void set_has_u8AGC ();

    inline void clear_has_u8AGC ();

    inline void set_has_u8ChannelSeparation ();

    inline void clear_has_u8ChannelSeparation ();

    inline void set_has_u8RdsErrorRate ();

    inline void clear_has_u8RdsErrorRate ();

    inline void set_has_e8DiversityState ();

    inline void clear_has_e8DiversityState ();

    inline void set_has_e8AntennaPathSwitch1 ();

    inline void clear_has_e8AntennaPathSwitch1 ();

    inline void set_has_e8AntennaPathSwitch2 ();

    inline void clear_has_e8AntennaPathSwitch2 ();

    inline void set_has_u8TestmodeBits ();

    inline void clear_has_u8TestmodeBits ();

    inline void set_has_u8HicutExtender ();

    inline void clear_has_u8HicutExtender ();

    uint32 _has_bits_[ (29 + 31) / 32];

    T_e8_Tun_PhysicalTuner _u8PhysicalTuner;

    T_e8_Tun_Testmode_TunerBand _u8Source;

    uint32 _u32AFFrequency;

    uint16 _u16CurrentPI;

    uint16 _u16TargetPI;

    uint8 _u8Quality;

    uint8 _u8Fieldstrength;

    uint8 _u8Multipath;

    uint8 _u8Neighbour;

    uint8 _u8AFListLength;

    uint8 _u8HiCut;

    uint8 _u8Sharx;

    ::std::string* _sCurrentStationName;

    ::std::string* _sFixPSName;

    bool _bScrollPSStatus;

    bool _bAFStatus;

    uint8 _u8FMDeviation;

    uint8 _u8RDSDeviation;

    int8 _s8IFOffset;

    int8 _s8RDSOffset;

    uint8 _u8CoChannelStatus;

    uint8 _u8AGC;

    uint8 _u8ChannelSeparation;

    uint8 _u8RdsErrorRate;

    T_e8_Tun_DiversityState _e8DiversityState;

    T_e8_Tun_AntennaPathSwitch1 _e8AntennaPathSwitch1;

    T_e8_Tun_AntennaPathSwitch2 _e8AntennaPathSwitch2;

    T_b8_Tun_TestmodeBits* _u8TestmodeBits;

    uint8 _u8HicutExtender;

};

/**
 * Tuning Action Config Parameter and its value.
 */
class T_TuningActionConfigParam {
public:

    /**
     * Default constructor
     */
    inline  T_TuningActionConfigParam ();

    /**
     * Copy constructor
     */
    inline  T_TuningActionConfigParam (const T_TuningActionConfigParam &rhs);

    /**
     * All fields constructor
     */
    inline  T_TuningActionConfigParam (T_e8_Tun_ConfigParam_Type e8ConfigParamType_, uint32 u32ConfigParamValue_);

    /**
     * Destructor
     */
    inline  ~T_TuningActionConfigParam();

    /**
     * Assignment operator
     */
    inline T_TuningActionConfigParam& operator = (const T_TuningActionConfigParam& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TuningActionConfigParam& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TuningActionConfigParam& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TuningActionConfigParam& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TuningActionConfigParam& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ConfigParamType"

    static const int kE8ConfigParamType = 0;

    /**
     * Clears the field "e8ConfigParamType".
     *
     * The field will be set to its default value. The hasE8ConfigParamType()
     * method will return false.
     */
    inline void clearE8ConfigParamType();

    /**
     * Checks whether the field "e8ConfigParamType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigParamType()). Otherwise it will return false.
     */
    inline bool hasE8ConfigParamType () const;

    /**
     * Returns the value of the member "e8ConfigParamType".
     *
     * If the meaning of "e8ConfigParamType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8ConfigParamType"
     */
    inline T_e8_Tun_ConfigParam_Type getE8ConfigParamType () const;

    /**
     * Sets the value of the member "e8ConfigParamType".
     *
     * If the meaning of "e8ConfigParamType" isn't clear, then there should be a description here.
     *
     * @param e8ConfigParamType The value which will be set
     */
    inline void setE8ConfigParamType (T_e8_Tun_ConfigParam_Type e8ConfigParamType_);

    // API of field "u32ConfigParamValue"

    static const int kU32ConfigParamValue = 1;

    /**
     * Clears the field "u32ConfigParamValue".
     *
     * The field will be set to its default value. The hasU32ConfigParamValue()
     * method will return false.
     */
    inline void clearU32ConfigParamValue();

    /**
     * Checks whether the field "u32ConfigParamValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ConfigParamValue()). Otherwise it will return false.
     */
    inline bool hasU32ConfigParamValue () const;

    /**
     * Returns the value of the member "u32ConfigParamValue".
     *
     * If the meaning of "u32ConfigParamValue" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ConfigParamValue"
     */
    inline uint32 getU32ConfigParamValue () const;

    /**
     * Sets the value of the member "u32ConfigParamValue".
     *
     * If the meaning of "u32ConfigParamValue" isn't clear, then there should be a description here.
     *
     * @param u32ConfigParamValue The value which will be set
     */
    inline void setU32ConfigParamValue (uint32 u32ConfigParamValue_);

    static const T_TuningActionConfigParam &getDefaultInstance();

private:

    inline void set_has_e8ConfigParamType ();

    inline void clear_has_e8ConfigParamType ();

    inline void set_has_u32ConfigParamValue ();

    inline void clear_has_u32ConfigParamValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_ConfigParam_Type _e8ConfigParamType;

    uint32 _u32ConfigParamValue;

};

/**
 * Indicates the announcement type. Bit 2- WeatherAlert from weather Band
 */
class T_b8_AnnoTypes {
public:

    /**
     * Default constructor
     */
    inline  T_b8_AnnoTypes ();

    /**
     * Copy constructor
     */
    inline  T_b8_AnnoTypes (const T_b8_AnnoTypes &c);

    /**
     * Field constructor
     */
    inline  T_b8_AnnoTypes (bool TP, bool PTY, bool WeatherAlert);

    /**
     * Assignment operator
     */
    inline T_b8_AnnoTypes& operator = (const T_b8_AnnoTypes& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_AnnoTypes& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_AnnoTypes& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_AnnoTypes& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_AnnoTypes& rhs) const;

    /**
     * Sets the value of the member "TP".
     *
     * If the meaning of "TP" isn't clear, then there should be a description here.
     *
     * @param TP The value which will be set
     */
    inline void setTP (bool TP);

    /**
     * Returns the value of the member "TP".
     *
     * If the meaning of "TP" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TP"
     */
    inline bool getTP () const;

    /**
     * Sets the value of the member "PTY".
     *
     * If the meaning of "PTY" isn't clear, then there should be a description here.
     *
     * @param PTY The value which will be set
     */
    inline void setPTY (bool PTY);

    /**
     * Returns the value of the member "PTY".
     *
     * If the meaning of "PTY" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PTY"
     */
    inline bool getPTY () const;

    /**
     * Sets the value of the member "WeatherAlert".
     *
     * If the meaning of "WeatherAlert" isn't clear, then there should be a description here.
     *
     * @param WeatherAlert The value which will be set
     */
    inline void setWeatherAlert (bool WeatherAlert);

    /**
     * Returns the value of the member "WeatherAlert".
     *
     * If the meaning of "WeatherAlert" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WeatherAlert"
     */
    inline bool getWeatherAlert () const;

    static const T_b8_AnnoTypes &getDefaultInstance();

private:

    bool _TP:1;

    bool _PTY:1;

    bool _WeatherAlert:1;

};

/**
 * Indictes if the announcement type is Activate/Deactivated. Bit 2- WeatherAlert from weather Band
 */
class T_b8_Anno_Message {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Anno_Message ();

    /**
     * Copy constructor
     */
    inline  T_b8_Anno_Message (const T_b8_Anno_Message &c);

    /**
     * Field constructor
     */
    inline  T_b8_Anno_Message (bool TA, bool PTY31, bool WeatherAlert);

    /**
     * Assignment operator
     */
    inline T_b8_Anno_Message& operator = (const T_b8_Anno_Message& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Anno_Message& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Anno_Message& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Anno_Message& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Anno_Message& rhs) const;

    /**
     * Sets the value of the member "TA".
     *
     * If the meaning of "TA" isn't clear, then there should be a description here.
     *
     * @param TA The value which will be set
     */
    inline void setTA (bool TA);

    /**
     * Returns the value of the member "TA".
     *
     * If the meaning of "TA" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TA"
     */
    inline bool getTA () const;

    /**
     * Sets the value of the member "PTY31".
     *
     * If the meaning of "PTY31" isn't clear, then there should be a description here.
     *
     * @param PTY31 The value which will be set
     */
    inline void setPTY31 (bool PTY31);

    /**
     * Returns the value of the member "PTY31".
     *
     * If the meaning of "PTY31" isn't clear, then there should be a description here.
     *
     * @return The value of the field "PTY31"
     */
    inline bool getPTY31 () const;

    /**
     * Sets the value of the member "WeatherAlert".
     *
     * If the meaning of "WeatherAlert" isn't clear, then there should be a description here.
     *
     * @param WeatherAlert The value which will be set
     */
    inline void setWeatherAlert (bool WeatherAlert);

    /**
     * Returns the value of the member "WeatherAlert".
     *
     * If the meaning of "WeatherAlert" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WeatherAlert"
     */
    inline bool getWeatherAlert () const;

    static const T_b8_Anno_Message &getDefaultInstance();

private:

    bool _TA:1;

    bool _PTY31:1;

    bool _WeatherAlert:1;

};

/**
 * Announcement Info data is contained in this structure
 */
class T_AnnoInfostatus {
public:

    /**
     * Default constructor
     */
    inline  T_AnnoInfostatus ();

    /**
     * Copy constructor
     */
    inline  T_AnnoInfostatus (const T_AnnoInfostatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_AnnoInfostatus (const ::std::string& sAnnoStationName_, uint32 u32Frequency_, uint16 u16PI_, uint8 u8Quality_);

    /**
     * Destructor
     */
    inline  ~T_AnnoInfostatus();

    /**
     * Assignment operator
     */
    inline T_AnnoInfostatus& operator = (const T_AnnoInfostatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AnnoInfostatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AnnoInfostatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AnnoInfostatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AnnoInfostatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sAnnoStationName"

    static const int kSAnnoStationName = 0;

    /**
     * Clears the field "sAnnoStationName".
     *
     * The field will be set to its default value. The hasSAnnoStationName()
     * method will return false.
     */
    inline void clearSAnnoStationName();

    /**
     * Checks whether the field "sAnnoStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAnnoStationName()). Otherwise it will return false.
     */
    inline bool hasSAnnoStationName () const;

    /**
     * Returns the value of the member "sAnnoStationName".
     *
     * provides the stationname of the station currently received by the given audio tuner or
     * currently surveilled by background.
     *
     * @return The value of the field "sAnnoStationName"
     */
    inline const ::std::string& getSAnnoStationName () const;

    /**
     * Retrieves the value of the field "sAnnoStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAnnoStationName".
     */
    inline ::std::string& getSAnnoStationNameMutable ();

    /**
     * Sets the value of the member "sAnnoStationName".
     *
     * provides the stationname of the station currently received by the given audio tuner or
     * currently surveilled by background.
     *
     * @param sAnnoStationName The value which will be set
     */
    inline void setSAnnoStationName (const ::std::string& sAnnoStationName_);

    /**
     * Sets the value of the member "sAnnoStationName".
     *
     * provides the stationname of the station currently received by the given audio tuner or
     * currently surveilled by background.
     *
     * @param sAnnoStationName The value which will be set
     */
    inline void setSAnnoStationName (const char* sAnnoStationName_);

    /**
     * Sets the value of the member "sAnnoStationName".
     *
     * provides the stationname of the station currently received by the given audio tuner or
     * currently surveilled by background.
     *
     * @param sAnnoStationName The value which will be set
     */
    inline void setSAnnoStationName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sAnnoStationName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sAnnoStationName"
     */
    inline ::std::string* releaseSAnnoStationName();

    /**
     * Replace the field "sAnnoStationName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSAnnoStationName (::std::string* sAnnoStationName_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 1;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * provides the frequency of the station currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * provides the frequency of the station currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u16PI"

    static const int kU16PI = 2;

    /**
     * Clears the field "u16PI".
     *
     * The field will be set to its default value. The hasU16PI()
     * method will return false.
     */
    inline void clearU16PI();

    /**
     * Checks whether the field "u16PI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16PI()). Otherwise it will return false.
     */
    inline bool hasU16PI () const;

    /**
     * Returns the value of the member "u16PI".
     *
     * provides the PI of the station currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @return The value of the field "u16PI"
     */
    inline uint16 getU16PI () const;

    /**
     * Sets the value of the member "u16PI".
     *
     * provides the PI of the station currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @param u16PI The value which will be set
     */
    inline void setU16PI (uint16 u16PI_);

    // API of field "u8Quality"

    static const int kU8Quality = 3;

    /**
     * Clears the field "u8Quality".
     *
     * The field will be set to its default value. The hasU8Quality()
     * method will return false.
     */
    inline void clearU8Quality();

    /**
     * Checks whether the field "u8Quality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Quality()). Otherwise it will return false.
     */
    inline bool hasU8Quality () const;

    /**
     * Returns the value of the member "u8Quality".
     *
     * provides the Quality of the station currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @return The value of the field "u8Quality"
     */
    inline uint8 getU8Quality () const;

    /**
     * Sets the value of the member "u8Quality".
     *
     * provides the Quality of the station currently received by the given audio tuner or
     * currently surveilled by background
     *
     * @param u8Quality The value which will be set
     */
    inline void setU8Quality (uint8 u8Quality_);

    static const T_AnnoInfostatus &getDefaultInstance();

private:

    inline void set_has_sAnnoStationName ();

    inline void clear_has_sAnnoStationName ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u16PI ();

    inline void clear_has_u16PI ();

    inline void set_has_u8Quality ();

    inline void clear_has_u8Quality ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string* _sAnnoStationName;

    uint32 _u32Frequency;

    uint16 _u16PI;

    uint8 _u8Quality;

};

/**
 * Engg Param ID and its value are contained in this structure
 */
class T_Tun_Engg_Param_List_Elem {
public:

    /**
     * Default constructor
     */
    inline  T_Tun_Engg_Param_List_Elem ();

    /**
     * Copy constructor
     */
    inline  T_Tun_Engg_Param_List_Elem (const T_Tun_Engg_Param_List_Elem &rhs);

    /**
     * All fields constructor
     */
    inline  T_Tun_Engg_Param_List_Elem (T_e8_Tun_Engg_Param_ID e8ParameterID_, uint32 u32ParameterValue_);

    /**
     * Destructor
     */
    inline  ~T_Tun_Engg_Param_List_Elem();

    /**
     * Assignment operator
     */
    inline T_Tun_Engg_Param_List_Elem& operator = (const T_Tun_Engg_Param_List_Elem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_Tun_Engg_Param_List_Elem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_Tun_Engg_Param_List_Elem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_Tun_Engg_Param_List_Elem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_Tun_Engg_Param_List_Elem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ParameterID"

    static const int kE8ParameterID = 0;

    /**
     * Clears the field "e8ParameterID".
     *
     * The field will be set to its default value. The hasE8ParameterID()
     * method will return false.
     */
    inline void clearE8ParameterID();

    /**
     * Checks whether the field "e8ParameterID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ParameterID()). Otherwise it will return false.
     */
    inline bool hasE8ParameterID () const;

    /**
     * Returns the value of the member "e8ParameterID".
     *
     * This Parameter indicates the index of Engg Parameter.
     *
     * @return The value of the field "e8ParameterID"
     */
    inline T_e8_Tun_Engg_Param_ID getE8ParameterID () const;

    /**
     * Sets the value of the member "e8ParameterID".
     *
     * This Parameter indicates the index of Engg Parameter.
     *
     * @param e8ParameterID The value which will be set
     */
    inline void setE8ParameterID (T_e8_Tun_Engg_Param_ID e8ParameterID_);

    // API of field "u32ParameterValue"

    static const int kU32ParameterValue = 1;

    /**
     * Clears the field "u32ParameterValue".
     *
     * The field will be set to its default value. The hasU32ParameterValue()
     * method will return false.
     */
    inline void clearU32ParameterValue();

    /**
     * Checks whether the field "u32ParameterValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ParameterValue()). Otherwise it will return false.
     */
    inline bool hasU32ParameterValue () const;

    /**
     * Returns the value of the member "u32ParameterValue".
     *
     * The value set to the Engineering Parameter.
     *
     * @return The value of the field "u32ParameterValue"
     */
    inline uint32 getU32ParameterValue () const;

    /**
     * Sets the value of the member "u32ParameterValue".
     *
     * The value set to the Engineering Parameter.
     *
     * @param u32ParameterValue The value which will be set
     */
    inline void setU32ParameterValue (uint32 u32ParameterValue_);

    static const T_Tun_Engg_Param_List_Elem &getDefaultInstance();

private:

    inline void set_has_e8ParameterID ();

    inline void clear_has_e8ParameterID ();

    inline void set_has_u32ParameterValue ();

    inline void clear_has_u32ParameterValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_Tun_Engg_Param_ID _e8ParameterID;

    uint32 _u32ParameterValue;

};

/**
 * This structure provides the info regarding High Low frequencies of each band, and step sizes(manual/auto).
 */
class T_AvailableBandInfoElement {
public:

    /**
     * Default constructor
     */
    inline  T_AvailableBandInfoElement ();

    /**
     * Copy constructor
     */
    inline  T_AvailableBandInfoElement (const T_AvailableBandInfoElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_AvailableBandInfoElement (T_e8_Tun_TunerBand e8Band_, uint32 u32HighFrequency_, uint32 u32LowFrequency_, uint16 u16AutoSeekStepWidth_, uint16 u16ManualStepWidth_);

    /**
     * Destructor
     */
    inline  ~T_AvailableBandInfoElement();

    /**
     * Assignment operator
     */
    inline T_AvailableBandInfoElement& operator = (const T_AvailableBandInfoElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_AvailableBandInfoElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_AvailableBandInfoElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_AvailableBandInfoElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_AvailableBandInfoElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Band"

    static const int kE8Band = 0;

    /**
     * Clears the field "e8Band".
     *
     * The field will be set to its default value. The hasE8Band()
     * method will return false.
     */
    inline void clearE8Band();

    /**
     * Checks whether the field "e8Band" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Band()). Otherwise it will return false.
     */
    inline bool hasE8Band () const;

    /**
     * Returns the value of the member "e8Band".
     *
     *
     *
     * @return The value of the field "e8Band"
     */
    inline T_e8_Tun_TunerBand getE8Band () const;

    /**
     * Sets the value of the member "e8Band".
     *
     *
     *
     * @param e8Band The value which will be set
     */
    inline void setE8Band (T_e8_Tun_TunerBand e8Band_);

    // API of field "u32HighFrequency"

    static const int kU32HighFrequency = 1;

    /**
     * Clears the field "u32HighFrequency".
     *
     * The field will be set to its default value. The hasU32HighFrequency()
     * method will return false.
     */
    inline void clearU32HighFrequency();

    /**
     * Checks whether the field "u32HighFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HighFrequency()). Otherwise it will return false.
     */
    inline bool hasU32HighFrequency () const;

    /**
     * Returns the value of the member "u32HighFrequency".
     *
     *
     *
     * @return The value of the field "u32HighFrequency"
     */
    inline uint32 getU32HighFrequency () const;

    /**
     * Sets the value of the member "u32HighFrequency".
     *
     *
     *
     * @param u32HighFrequency The value which will be set
     */
    inline void setU32HighFrequency (uint32 u32HighFrequency_);

    // API of field "u32LowFrequency"

    static const int kU32LowFrequency = 2;

    /**
     * Clears the field "u32LowFrequency".
     *
     * The field will be set to its default value. The hasU32LowFrequency()
     * method will return false.
     */
    inline void clearU32LowFrequency();

    /**
     * Checks whether the field "u32LowFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32LowFrequency()). Otherwise it will return false.
     */
    inline bool hasU32LowFrequency () const;

    /**
     * Returns the value of the member "u32LowFrequency".
     *
     *
     *
     * @return The value of the field "u32LowFrequency"
     */
    inline uint32 getU32LowFrequency () const;

    /**
     * Sets the value of the member "u32LowFrequency".
     *
     *
     *
     * @param u32LowFrequency The value which will be set
     */
    inline void setU32LowFrequency (uint32 u32LowFrequency_);

    // API of field "u16AutoSeekStepWidth"

    static const int kU16AutoSeekStepWidth = 3;

    /**
     * Clears the field "u16AutoSeekStepWidth".
     *
     * The field will be set to its default value. The hasU16AutoSeekStepWidth()
     * method will return false.
     */
    inline void clearU16AutoSeekStepWidth();

    /**
     * Checks whether the field "u16AutoSeekStepWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AutoSeekStepWidth()). Otherwise it will return false.
     */
    inline bool hasU16AutoSeekStepWidth () const;

    /**
     * Returns the value of the member "u16AutoSeekStepWidth".
     *
     *
     *
     * @return The value of the field "u16AutoSeekStepWidth"
     */
    inline uint16 getU16AutoSeekStepWidth () const;

    /**
     * Sets the value of the member "u16AutoSeekStepWidth".
     *
     *
     *
     * @param u16AutoSeekStepWidth The value which will be set
     */
    inline void setU16AutoSeekStepWidth (uint16 u16AutoSeekStepWidth_);

    // API of field "u16ManualStepWidth"

    static const int kU16ManualStepWidth = 4;

    /**
     * Clears the field "u16ManualStepWidth".
     *
     * The field will be set to its default value. The hasU16ManualStepWidth()
     * method will return false.
     */
    inline void clearU16ManualStepWidth();

    /**
     * Checks whether the field "u16ManualStepWidth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ManualStepWidth()). Otherwise it will return false.
     */
    inline bool hasU16ManualStepWidth () const;

    /**
     * Returns the value of the member "u16ManualStepWidth".
     *
     *
     *
     * @return The value of the field "u16ManualStepWidth"
     */
    inline uint16 getU16ManualStepWidth () const;

    /**
     * Sets the value of the member "u16ManualStepWidth".
     *
     *
     *
     * @param u16ManualStepWidth The value which will be set
     */
    inline void setU16ManualStepWidth (uint16 u16ManualStepWidth_);

    static const T_AvailableBandInfoElement &getDefaultInstance();

private:

    inline void set_has_e8Band ();

    inline void clear_has_e8Band ();

    inline void set_has_u32HighFrequency ();

    inline void clear_has_u32HighFrequency ();

    inline void set_has_u32LowFrequency ();

    inline void clear_has_u32LowFrequency ();

    inline void set_has_u16AutoSeekStepWidth ();

    inline void clear_has_u16AutoSeekStepWidth ();

    inline void set_has_u16ManualStepWidth ();

    inline void clear_has_u16ManualStepWidth ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_Tun_TunerBand _e8Band;

    uint32 _u32HighFrequency;

    uint32 _u32LowFrequency;

    uint16 _u16AutoSeekStepWidth;

    uint16 _u16ManualStepWidth;

};

/**
 * Bit 0- FM and AM demodulation status, Bit 1- FM-HD demodulation status, Bit 2- AM-HD demodulation status, Bit 3- DRM30 demodulation status
 */
class T_b8_Tun_DemodSwitch {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_DemodSwitch ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_DemodSwitch (const T_b8_Tun_DemodSwitch &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_DemodSwitch (bool FM_AM, bool FM_HD, bool AM_HD, bool DRM30);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_DemodSwitch& operator = (const T_b8_Tun_DemodSwitch& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_DemodSwitch& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_DemodSwitch& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_DemodSwitch& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_DemodSwitch& rhs) const;

    /**
     * Sets the value of the member "FM_AM".
     *
     * If the meaning of "FM_AM" isn't clear, then there should be a description here.
     *
     * @param FM_AM The value which will be set
     */
    inline void setFM_AM (bool FM_AM);

    /**
     * Returns the value of the member "FM_AM".
     *
     * If the meaning of "FM_AM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FM_AM"
     */
    inline bool getFM_AM () const;

    /**
     * Sets the value of the member "FM_HD".
     *
     * If the meaning of "FM_HD" isn't clear, then there should be a description here.
     *
     * @param FM_HD The value which will be set
     */
    inline void setFM_HD (bool FM_HD);

    /**
     * Returns the value of the member "FM_HD".
     *
     * If the meaning of "FM_HD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FM_HD"
     */
    inline bool getFM_HD () const;

    /**
     * Sets the value of the member "AM_HD".
     *
     * If the meaning of "AM_HD" isn't clear, then there should be a description here.
     *
     * @param AM_HD The value which will be set
     */
    inline void setAM_HD (bool AM_HD);

    /**
     * Returns the value of the member "AM_HD".
     *
     * If the meaning of "AM_HD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AM_HD"
     */
    inline bool getAM_HD () const;

    /**
     * Sets the value of the member "DRM30".
     *
     * If the meaning of "DRM30" isn't clear, then there should be a description here.
     *
     * @param DRM30 The value which will be set
     */
    inline void setDRM30 (bool DRM30);

    /**
     * Returns the value of the member "DRM30".
     *
     * If the meaning of "DRM30" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DRM30"
     */
    inline bool getDRM30 () const;

    static const T_b8_Tun_DemodSwitch &getDefaultInstance();

private:

    bool _FM_AM:1;

    bool _FM_HD:1;

    bool _AM_HD:1;

    bool _DRM30:1;

};

/**
 * This structure describes config list element
 */
class T_TunerHDTestModeData {
public:

    /**
     * Default constructor
     */
    inline  T_TunerHDTestModeData ();

    /**
     * Copy constructor
     */
    inline  T_TunerHDTestModeData (const T_TunerHDTestModeData &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerHDTestModeData (T_e8_Tun_PhysicalTuner e8PhysicalTuner_, const ::std::string& sHDCallSign_, uint32 u32HDStationId_, const T_b8_Tun_HDNumOfAudioPrograms& b8HDAvailableAudioPrograms_, T_e8_Tun_HDAudioProgram e8HDActiveAudioProgram_, uint8 u8AudioQuality_, const T_b8_Tun_HDInfoBits& b8HDStationInfoBits_, uint8 u8ACQStates_, uint8 u8CD_NO_, uint8 u8TransitionCount_);

    /**
     * Destructor
     */
    inline  ~T_TunerHDTestModeData();

    /**
     * Assignment operator
     */
    inline T_TunerHDTestModeData& operator = (const T_TunerHDTestModeData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerHDTestModeData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerHDTestModeData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerHDTestModeData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerHDTestModeData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PhysicalTuner"

    static const int kE8PhysicalTuner = 0;

    /**
     * Clears the field "e8PhysicalTuner".
     *
     * The field will be set to its default value. The hasE8PhysicalTuner()
     * method will return false.
     */
    inline void clearE8PhysicalTuner();

    /**
     * Checks whether the field "e8PhysicalTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PhysicalTuner()). Otherwise it will return false.
     */
    inline bool hasE8PhysicalTuner () const;

    /**
     * Returns the value of the member "e8PhysicalTuner".
     *
     * Provides Station name of HD station
     *
     * @return The value of the field "e8PhysicalTuner"
     */
    inline T_e8_Tun_PhysicalTuner getE8PhysicalTuner () const;

    /**
     * Sets the value of the member "e8PhysicalTuner".
     *
     * Provides Station name of HD station
     *
     * @param e8PhysicalTuner The value which will be set
     */
    inline void setE8PhysicalTuner (T_e8_Tun_PhysicalTuner e8PhysicalTuner_);

    // API of field "sHDCallSign"

    static const int kSHDCallSign = 1;

    /**
     * Clears the field "sHDCallSign".
     *
     * The field will be set to its default value. The hasSHDCallSign()
     * method will return false.
     */
    inline void clearSHDCallSign();

    /**
     * Checks whether the field "sHDCallSign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSHDCallSign()). Otherwise it will return false.
     */
    inline bool hasSHDCallSign () const;

    /**
     * Returns the value of the member "sHDCallSign".
     *
     * Provides Station name of HD station
     *
     * @return The value of the field "sHDCallSign"
     */
    inline const ::std::string& getSHDCallSign () const;

    /**
     * Retrieves the value of the field "sHDCallSign" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sHDCallSign".
     */
    inline ::std::string& getSHDCallSignMutable ();

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Provides Station name of HD station
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const ::std::string& sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Provides Station name of HD station
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* sHDCallSign_);

    /**
     * Sets the value of the member "sHDCallSign".
     *
     * Provides Station name of HD station
     *
     * @param sHDCallSign The value which will be set
     */
    inline void setSHDCallSign (const char* value, size_t size);

    /**
     * Release the object stored in the field "sHDCallSign".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sHDCallSign"
     */
    inline ::std::string* releaseSHDCallSign();

    /**
     * Replace the field "sHDCallSign".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSHDCallSign (::std::string* sHDCallSign_);

    // API of field "u32HDStationId"

    static const int kU32HDStationId = 2;

    /**
     * Clears the field "u32HDStationId".
     *
     * The field will be set to its default value. The hasU32HDStationId()
     * method will return false.
     */
    inline void clearU32HDStationId();

    /**
     * Checks whether the field "u32HDStationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId () const;

    /**
     * Returns the value of the member "u32HDStationId".
     *
     * Provides Station ID
     *
     * @return The value of the field "u32HDStationId"
     */
    inline uint32 getU32HDStationId () const;

    /**
     * Sets the value of the member "u32HDStationId".
     *
     * Provides Station ID
     *
     * @param u32HDStationId The value which will be set
     */
    inline void setU32HDStationId (uint32 u32HDStationId_);

    // API of field "b8HDAvailableAudioPrograms"

    static const int kB8HDAvailableAudioPrograms = 3;

    /**
     * Clears the field "b8HDAvailableAudioPrograms".
     *
     * The field will be set to its default value. The hasB8HDAvailableAudioPrograms()
     * method will return false.
     */
    inline void clearB8HDAvailableAudioPrograms();

    /**
     * Checks whether the field "b8HDAvailableAudioPrograms" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8HDAvailableAudioPrograms()). Otherwise it will return false.
     */
    inline bool hasB8HDAvailableAudioPrograms () const;

    /**
     * Returns the value of the member "b8HDAvailableAudioPrograms".
     *
     * Provides available MPS  and SPS stations
     *
     * @return The value of the field "b8HDAvailableAudioPrograms"
     */
    inline const T_b8_Tun_HDNumOfAudioPrograms& getB8HDAvailableAudioPrograms () const;

    /**
     * Retrieves the value of the field "b8HDAvailableAudioPrograms" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8HDAvailableAudioPrograms".
     */
    inline T_b8_Tun_HDNumOfAudioPrograms& getB8HDAvailableAudioProgramsMutable ();

    /**
     * Sets the value of the member "b8HDAvailableAudioPrograms".
     *
     * Provides available MPS  and SPS stations
     *
     * @param b8HDAvailableAudioPrograms The value which will be set
     */
    inline void setB8HDAvailableAudioPrograms (const T_b8_Tun_HDNumOfAudioPrograms& b8HDAvailableAudioPrograms_);

    /**
     * Release the object stored in the field "b8HDAvailableAudioPrograms".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8HDAvailableAudioPrograms"
     */
    inline T_b8_Tun_HDNumOfAudioPrograms* releaseB8HDAvailableAudioPrograms();

    /**
     * Replace the field "b8HDAvailableAudioPrograms".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8HDAvailableAudioPrograms (T_b8_Tun_HDNumOfAudioPrograms* b8HDAvailableAudioPrograms_);

    // API of field "e8HDActiveAudioProgram"

    static const int kE8HDActiveAudioProgram = 4;

    /**
     * Clears the field "e8HDActiveAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDActiveAudioProgram()
     * method will return false.
     */
    inline void clearE8HDActiveAudioProgram();

    /**
     * Checks whether the field "e8HDActiveAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDActiveAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDActiveAudioProgram () const;

    /**
     * Returns the value of the member "e8HDActiveAudioProgram".
     *
     * Provides currently active audio program.
     *
     * @return The value of the field "e8HDActiveAudioProgram"
     */
    inline T_e8_Tun_HDAudioProgram getE8HDActiveAudioProgram () const;

    /**
     * Sets the value of the member "e8HDActiveAudioProgram".
     *
     * Provides currently active audio program.
     *
     * @param e8HDActiveAudioProgram The value which will be set
     */
    inline void setE8HDActiveAudioProgram (T_e8_Tun_HDAudioProgram e8HDActiveAudioProgram_);

    // API of field "u8AudioQuality"

    static const int kU8AudioQuality = 5;

    /**
     * Clears the field "u8AudioQuality".
     *
     * The field will be set to its default value. The hasU8AudioQuality()
     * method will return false.
     */
    inline void clearU8AudioQuality();

    /**
     * Checks whether the field "u8AudioQuality" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AudioQuality()). Otherwise it will return false.
     */
    inline bool hasU8AudioQuality () const;

    /**
     * Returns the value of the member "u8AudioQuality".
     *
     * 0: poorest quality ï¿½ 0xf: highest quality
     *
     * @return The value of the field "u8AudioQuality"
     */
    inline uint8 getU8AudioQuality () const;

    /**
     * Sets the value of the member "u8AudioQuality".
     *
     * 0: poorest quality ï¿½ 0xf: highest quality
     *
     * @param u8AudioQuality The value which will be set
     */
    inline void setU8AudioQuality (uint8 u8AudioQuality_);

    // API of field "b8HDStationInfoBits"

    static const int kB8HDStationInfoBits = 6;

    /**
     * Clears the field "b8HDStationInfoBits".
     *
     * The field will be set to its default value. The hasB8HDStationInfoBits()
     * method will return false.
     */
    inline void clearB8HDStationInfoBits();

    /**
     * Checks whether the field "b8HDStationInfoBits" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8HDStationInfoBits()). Otherwise it will return false.
     */
    inline bool hasB8HDStationInfoBits () const;

    /**
     * Returns the value of the member "b8HDStationInfoBits".
     *
     * SIS information
     *
     * @return The value of the field "b8HDStationInfoBits"
     */
    inline const T_b8_Tun_HDInfoBits& getB8HDStationInfoBits () const;

    /**
     * Retrieves the value of the field "b8HDStationInfoBits" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8HDStationInfoBits".
     */
    inline T_b8_Tun_HDInfoBits& getB8HDStationInfoBitsMutable ();

    /**
     * Sets the value of the member "b8HDStationInfoBits".
     *
     * SIS information
     *
     * @param b8HDStationInfoBits The value which will be set
     */
    inline void setB8HDStationInfoBits (const T_b8_Tun_HDInfoBits& b8HDStationInfoBits_);

    /**
     * Release the object stored in the field "b8HDStationInfoBits".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8HDStationInfoBits"
     */
    inline T_b8_Tun_HDInfoBits* releaseB8HDStationInfoBits();

    /**
     * Replace the field "b8HDStationInfoBits".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8HDStationInfoBits (T_b8_Tun_HDInfoBits* b8HDStationInfoBits_);

    // API of field "u8ACQStates"

    static const int kU8ACQStates = 7;

    /**
     * Clears the field "u8ACQStates".
     *
     * The field will be set to its default value. The hasU8ACQStates()
     * method will return false.
     */
    inline void clearU8ACQStates();

    /**
     * Checks whether the field "u8ACQStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ACQStates()). Otherwise it will return false.
     */
    inline bool hasU8ACQStates () const;

    /**
     * Returns the value of the member "u8ACQStates".
     *
     * Do not use this field. It will be removed in CW 20
     *
     * @return The value of the field "u8ACQStates"
     */
    inline uint8 getU8ACQStates () const;

    /**
     * Sets the value of the member "u8ACQStates".
     *
     * Do not use this field. It will be removed in CW 20
     *
     * @param u8ACQStates The value which will be set
     */
    inline void setU8ACQStates (uint8 u8ACQStates_);

    // API of field "u8CD_NO"

    static const int kU8CD_NO = 8;

    /**
     * Clears the field "u8CD_NO".
     *
     * The field will be set to its default value. The hasU8CD_NO()
     * method will return false.
     */
    inline void clearU8CD_NO();

    /**
     * Checks whether the field "u8CD_NO" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8CD_NO()). Otherwise it will return false.
     */
    inline bool hasU8CD_NO () const;

    /**
     * Returns the value of the member "u8CD_NO".
     *
     * .
     *
     * @return The value of the field "u8CD_NO"
     */
    inline uint8 getU8CD_NO () const;

    /**
     * Sets the value of the member "u8CD_NO".
     *
     * .
     *
     * @param u8CD_NO The value which will be set
     */
    inline void setU8CD_NO (uint8 u8CD_NO_);

    // API of field "u8TransitionCount"

    static const int kU8TransitionCount = 9;

    /**
     * Clears the field "u8TransitionCount".
     *
     * The field will be set to its default value. The hasU8TransitionCount()
     * method will return false.
     */
    inline void clearU8TransitionCount();

    /**
     * Checks whether the field "u8TransitionCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8TransitionCount()). Otherwise it will return false.
     */
    inline bool hasU8TransitionCount () const;

    /**
     * Returns the value of the member "u8TransitionCount".
     *
     * Number of digital to analog audio transitions
     *
     * @return The value of the field "u8TransitionCount"
     */
    inline uint8 getU8TransitionCount () const;

    /**
     * Sets the value of the member "u8TransitionCount".
     *
     * Number of digital to analog audio transitions
     *
     * @param u8TransitionCount The value which will be set
     */
    inline void setU8TransitionCount (uint8 u8TransitionCount_);

    static const T_TunerHDTestModeData &getDefaultInstance();

private:

    inline void set_has_e8PhysicalTuner ();

    inline void clear_has_e8PhysicalTuner ();

    inline void set_has_sHDCallSign ();

    inline void clear_has_sHDCallSign ();

    inline void set_has_u32HDStationId ();

    inline void clear_has_u32HDStationId ();

    inline void set_has_b8HDAvailableAudioPrograms ();

    inline void clear_has_b8HDAvailableAudioPrograms ();

    inline void set_has_e8HDActiveAudioProgram ();

    inline void clear_has_e8HDActiveAudioProgram ();

    inline void set_has_u8AudioQuality ();

    inline void clear_has_u8AudioQuality ();

    inline void set_has_b8HDStationInfoBits ();

    inline void clear_has_b8HDStationInfoBits ();

    inline void set_has_u8ACQStates ();

    inline void clear_has_u8ACQStates ();

    inline void set_has_u8CD_NO ();

    inline void clear_has_u8CD_NO ();

    inline void set_has_u8TransitionCount ();

    inline void clear_has_u8TransitionCount ();

    uint32 _has_bits_[ (10 + 31) / 32];

    T_e8_Tun_PhysicalTuner _e8PhysicalTuner;

    ::std::string* _sHDCallSign;

    uint32 _u32HDStationId;

    T_b8_Tun_HDNumOfAudioPrograms* _b8HDAvailableAudioPrograms;

    T_e8_Tun_HDAudioProgram _e8HDActiveAudioProgram;

    uint8 _u8AudioQuality;

    T_b8_Tun_HDInfoBits* _b8HDStationInfoBits;

    uint8 _u8ACQStates;

    uint8 _u8CD_NO;

    uint8 _u8TransitionCount;

};

/**
 * This structure describes Info regarding covert art / station logo image
 */
class T_ImageFileInfo {
public:

    /**
     * Default constructor
     */
    inline  T_ImageFileInfo ();

    /**
     * Copy constructor
     */
    inline  T_ImageFileInfo (const T_ImageFileInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_ImageFileInfo (uint32 u32HDStationId_, T_e8_Tun_HDImageType e8HDImageType_, T_e8_Tun_HDImageCoding e8HDImageCoding_, T_e8_Tun_HDAudioProgram e8HDAudioProgram_, uint32 u32NoOfImageFileBytes_, const ::std::vector< uint8 >& ImageFileBytes_);

    /**
     * Destructor
     */
    inline  ~T_ImageFileInfo();

    /**
     * Assignment operator
     */
    inline T_ImageFileInfo& operator = (const T_ImageFileInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ImageFileInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ImageFileInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ImageFileInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ImageFileInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32HDStationId"

    static const int kU32HDStationId = 0;

    /**
     * Clears the field "u32HDStationId".
     *
     * The field will be set to its default value. The hasU32HDStationId()
     * method will return false.
     */
    inline void clearU32HDStationId();

    /**
     * Checks whether the field "u32HDStationId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32HDStationId()). Otherwise it will return false.
     */
    inline bool hasU32HDStationId () const;

    /**
     * Returns the value of the member "u32HDStationId".
     *
     * Provides Station ID
     *
     * @return The value of the field "u32HDStationId"
     */
    inline uint32 getU32HDStationId () const;

    /**
     * Sets the value of the member "u32HDStationId".
     *
     * Provides Station ID
     *
     * @param u32HDStationId The value which will be set
     */
    inline void setU32HDStationId (uint32 u32HDStationId_);

    // API of field "e8HDImageType"

    static const int kE8HDImageType = 1;

    /**
     * Clears the field "e8HDImageType".
     *
     * The field will be set to its default value. The hasE8HDImageType()
     * method will return false.
     */
    inline void clearE8HDImageType();

    /**
     * Checks whether the field "e8HDImageType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDImageType()). Otherwise it will return false.
     */
    inline bool hasE8HDImageType () const;

    /**
     * Returns the value of the member "e8HDImageType".
     *
     * Provides type of image
     *
     * @return The value of the field "e8HDImageType"
     */
    inline T_e8_Tun_HDImageType getE8HDImageType () const;

    /**
     * Sets the value of the member "e8HDImageType".
     *
     * Provides type of image
     *
     * @param e8HDImageType The value which will be set
     */
    inline void setE8HDImageType (T_e8_Tun_HDImageType e8HDImageType_);

    // API of field "e8HDImageCoding"

    static const int kE8HDImageCoding = 2;

    /**
     * Clears the field "e8HDImageCoding".
     *
     * The field will be set to its default value. The hasE8HDImageCoding()
     * method will return false.
     */
    inline void clearE8HDImageCoding();

    /**
     * Checks whether the field "e8HDImageCoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDImageCoding()). Otherwise it will return false.
     */
    inline bool hasE8HDImageCoding () const;

    /**
     * Returns the value of the member "e8HDImageCoding".
     *
     * Provides format of image
     *
     * @return The value of the field "e8HDImageCoding"
     */
    inline T_e8_Tun_HDImageCoding getE8HDImageCoding () const;

    /**
     * Sets the value of the member "e8HDImageCoding".
     *
     * Provides format of image
     *
     * @param e8HDImageCoding The value which will be set
     */
    inline void setE8HDImageCoding (T_e8_Tun_HDImageCoding e8HDImageCoding_);

    // API of field "e8HDAudioProgram"

    static const int kE8HDAudioProgram = 3;

    /**
     * Clears the field "e8HDAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDAudioProgram()
     * method will return false.
     */
    inline void clearE8HDAudioProgram();

    /**
     * Checks whether the field "e8HDAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioProgram () const;

    /**
     * Returns the value of the member "e8HDAudioProgram".
     *
     * Provides audio program.
     *
     * @return The value of the field "e8HDAudioProgram"
     */
    inline T_e8_Tun_HDAudioProgram getE8HDAudioProgram () const;

    /**
     * Sets the value of the member "e8HDAudioProgram".
     *
     * Provides audio program.
     *
     * @param e8HDAudioProgram The value which will be set
     */
    inline void setE8HDAudioProgram (T_e8_Tun_HDAudioProgram e8HDAudioProgram_);

    // API of field "u32NoOfImageFileBytes"

    static const int kU32NoOfImageFileBytes = 4;

    /**
     * Clears the field "u32NoOfImageFileBytes".
     *
     * The field will be set to its default value. The hasU32NoOfImageFileBytes()
     * method will return false.
     */
    inline void clearU32NoOfImageFileBytes();

    /**
     * Checks whether the field "u32NoOfImageFileBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NoOfImageFileBytes()). Otherwise it will return false.
     */
    inline bool hasU32NoOfImageFileBytes () const;

    /**
     * Returns the value of the member "u32NoOfImageFileBytes".
     *
     * Number of image file data bytes
     *
     * @return The value of the field "u32NoOfImageFileBytes"
     */
    inline uint32 getU32NoOfImageFileBytes () const;

    /**
     * Sets the value of the member "u32NoOfImageFileBytes".
     *
     * Number of image file data bytes
     *
     * @param u32NoOfImageFileBytes The value which will be set
     */
    inline void setU32NoOfImageFileBytes (uint32 u32NoOfImageFileBytes_);

    // API of field "ImageFileBytes"

    static const int kImageFileBytes = 5;

    /**
     * Clears the field "ImageFileBytes".
     *
     * The field will be set to its default value. The hasImageFileBytes()
     * method will return false.
     */
    inline void clearImageFileBytes();

    /**
     * Checks whether the field "ImageFileBytes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setImageFileBytes()). Otherwise it will return false.
     */
    inline bool hasImageFileBytes () const;

    /**
     * Returns the value of the member "ImageFileBytes".
     *
     * List of image data bytes
     *
     * @return The value of the field "ImageFileBytes"
     */
    inline const ::std::vector< uint8 >& getImageFileBytes () const;

    /**
     * Retrieves the value of the field "ImageFileBytes" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ImageFileBytes".
     */
    inline ::std::vector< uint8 >& getImageFileBytesMutable ();

    /**
     * Sets the value of the member "ImageFileBytes".
     *
     * List of image data bytes
     *
     * @param ImageFileBytes The value which will be set
     */
    inline void setImageFileBytes (const ::std::vector< uint8 >& ImageFileBytes_);

    /**
     * Release the object stored in the field "ImageFileBytes".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "ImageFileBytes"
     */
    inline ::std::vector< uint8 >* releaseImageFileBytes();

    /**
     * Replace the field "ImageFileBytes".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceImageFileBytes (::std::vector< uint8 >* ImageFileBytes_);

    static const T_ImageFileInfo &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_u32HDStationId ();

    inline void clear_has_u32HDStationId ();

    inline void set_has_e8HDImageType ();

    inline void clear_has_e8HDImageType ();

    inline void set_has_e8HDImageCoding ();

    inline void clear_has_e8HDImageCoding ();

    inline void set_has_e8HDAudioProgram ();

    inline void clear_has_e8HDAudioProgram ();

    inline void set_has_u32NoOfImageFileBytes ();

    inline void clear_has_u32NoOfImageFileBytes ();

    inline void set_has_ImageFileBytes ();

    inline void clear_has_ImageFileBytes ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint32 _u32HDStationId;

    T_e8_Tun_HDImageType _e8HDImageType;

    T_e8_Tun_HDImageCoding _e8HDImageCoding;

    T_e8_Tun_HDAudioProgram _e8HDAudioProgram;

    uint32 _u32NoOfImageFileBytes;

    ::std::vector< uint8 >* _ImageFileBytes;

};

/**
 * This Provides PSD Commercial data
 */
class T_TunPSDCommercial {
public:

    /**
     * Default constructor
     */
    inline  T_TunPSDCommercial ();

    /**
     * Copy constructor
     */
    inline  T_TunPSDCommercial (const T_TunPSDCommercial &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunPSDCommercial (const ::std::string& sPriceString_, const ::std::string& sValidUntil_, const ::std::string& sContactURL_, const ::std::string& sReceivedAs_, const ::std::string& sNameOfSeller_, const ::std::string& sDescription_);

    /**
     * Destructor
     */
    inline  ~T_TunPSDCommercial();

    /**
     * Assignment operator
     */
    inline T_TunPSDCommercial& operator = (const T_TunPSDCommercial& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunPSDCommercial& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunPSDCommercial& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunPSDCommercial& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunPSDCommercial& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sPriceString"

    static const int kSPriceString = 0;

    /**
     * Clears the field "sPriceString".
     *
     * The field will be set to its default value. The hasSPriceString()
     * method will return false.
     */
    inline void clearSPriceString();

    /**
     * Checks whether the field "sPriceString" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSPriceString()). Otherwise it will return false.
     */
    inline bool hasSPriceString () const;

    /**
     * Returns the value of the member "sPriceString".
     *
     * Price
     *
     * @return The value of the field "sPriceString"
     */
    inline const ::std::string& getSPriceString () const;

    /**
     * Retrieves the value of the field "sPriceString" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sPriceString".
     */
    inline ::std::string& getSPriceStringMutable ();

    /**
     * Sets the value of the member "sPriceString".
     *
     * Price
     *
     * @param sPriceString The value which will be set
     */
    inline void setSPriceString (const ::std::string& sPriceString_);

    /**
     * Sets the value of the member "sPriceString".
     *
     * Price
     *
     * @param sPriceString The value which will be set
     */
    inline void setSPriceString (const char* sPriceString_);

    /**
     * Sets the value of the member "sPriceString".
     *
     * Price
     *
     * @param sPriceString The value which will be set
     */
    inline void setSPriceString (const char* value, size_t size);

    /**
     * Release the object stored in the field "sPriceString".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sPriceString"
     */
    inline ::std::string* releaseSPriceString();

    /**
     * Replace the field "sPriceString".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSPriceString (::std::string* sPriceString_);

    // API of field "sValidUntil"

    static const int kSValidUntil = 1;

    /**
     * Clears the field "sValidUntil".
     *
     * The field will be set to its default value. The hasSValidUntil()
     * method will return false.
     */
    inline void clearSValidUntil();

    /**
     * Checks whether the field "sValidUntil" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSValidUntil()). Otherwise it will return false.
     */
    inline bool hasSValidUntil () const;

    /**
     * Returns the value of the member "sValidUntil".
     *
     * Validity
     *
     * @return The value of the field "sValidUntil"
     */
    inline const ::std::string& getSValidUntil () const;

    /**
     * Retrieves the value of the field "sValidUntil" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sValidUntil".
     */
    inline ::std::string& getSValidUntilMutable ();

    /**
     * Sets the value of the member "sValidUntil".
     *
     * Validity
     *
     * @param sValidUntil The value which will be set
     */
    inline void setSValidUntil (const ::std::string& sValidUntil_);

    /**
     * Sets the value of the member "sValidUntil".
     *
     * Validity
     *
     * @param sValidUntil The value which will be set
     */
    inline void setSValidUntil (const char* sValidUntil_);

    /**
     * Sets the value of the member "sValidUntil".
     *
     * Validity
     *
     * @param sValidUntil The value which will be set
     */
    inline void setSValidUntil (const char* value, size_t size);

    /**
     * Release the object stored in the field "sValidUntil".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sValidUntil"
     */
    inline ::std::string* releaseSValidUntil();

    /**
     * Replace the field "sValidUntil".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSValidUntil (::std::string* sValidUntil_);

    // API of field "sContactURL"

    static const int kSContactURL = 2;

    /**
     * Clears the field "sContactURL".
     *
     * The field will be set to its default value. The hasSContactURL()
     * method will return false.
     */
    inline void clearSContactURL();

    /**
     * Checks whether the field "sContactURL" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSContactURL()). Otherwise it will return false.
     */
    inline bool hasSContactURL () const;

    /**
     * Returns the value of the member "sContactURL".
     *
     * Contact info
     *
     * @return The value of the field "sContactURL"
     */
    inline const ::std::string& getSContactURL () const;

    /**
     * Retrieves the value of the field "sContactURL" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sContactURL".
     */
    inline ::std::string& getSContactURLMutable ();

    /**
     * Sets the value of the member "sContactURL".
     *
     * Contact info
     *
     * @param sContactURL The value which will be set
     */
    inline void setSContactURL (const ::std::string& sContactURL_);

    /**
     * Sets the value of the member "sContactURL".
     *
     * Contact info
     *
     * @param sContactURL The value which will be set
     */
    inline void setSContactURL (const char* sContactURL_);

    /**
     * Sets the value of the member "sContactURL".
     *
     * Contact info
     *
     * @param sContactURL The value which will be set
     */
    inline void setSContactURL (const char* value, size_t size);

    /**
     * Release the object stored in the field "sContactURL".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sContactURL"
     */
    inline ::std::string* releaseSContactURL();

    /**
     * Replace the field "sContactURL".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSContactURL (::std::string* sContactURL_);

    // API of field "sReceivedAs"

    static const int kSReceivedAs = 3;

    /**
     * Clears the field "sReceivedAs".
     *
     * The field will be set to its default value. The hasSReceivedAs()
     * method will return false.
     */
    inline void clearSReceivedAs();

    /**
     * Checks whether the field "sReceivedAs" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSReceivedAs()). Otherwise it will return false.
     */
    inline bool hasSReceivedAs () const;

    /**
     * Returns the value of the member "sReceivedAs".
     *
     *
     *
     * @return The value of the field "sReceivedAs"
     */
    inline const ::std::string& getSReceivedAs () const;

    /**
     * Retrieves the value of the field "sReceivedAs" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sReceivedAs".
     */
    inline ::std::string& getSReceivedAsMutable ();

    /**
     * Sets the value of the member "sReceivedAs".
     *
     *
     *
     * @param sReceivedAs The value which will be set
     */
    inline void setSReceivedAs (const ::std::string& sReceivedAs_);

    /**
     * Sets the value of the member "sReceivedAs".
     *
     *
     *
     * @param sReceivedAs The value which will be set
     */
    inline void setSReceivedAs (const char* sReceivedAs_);

    /**
     * Sets the value of the member "sReceivedAs".
     *
     *
     *
     * @param sReceivedAs The value which will be set
     */
    inline void setSReceivedAs (const char* value, size_t size);

    /**
     * Release the object stored in the field "sReceivedAs".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sReceivedAs"
     */
    inline ::std::string* releaseSReceivedAs();

    /**
     * Replace the field "sReceivedAs".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSReceivedAs (::std::string* sReceivedAs_);

    // API of field "sNameOfSeller"

    static const int kSNameOfSeller = 4;

    /**
     * Clears the field "sNameOfSeller".
     *
     * The field will be set to its default value. The hasSNameOfSeller()
     * method will return false.
     */
    inline void clearSNameOfSeller();

    /**
     * Checks whether the field "sNameOfSeller" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSNameOfSeller()). Otherwise it will return false.
     */
    inline bool hasSNameOfSeller () const;

    /**
     * Returns the value of the member "sNameOfSeller".
     *
     * Name Of Seller
     *
     * @return The value of the field "sNameOfSeller"
     */
    inline const ::std::string& getSNameOfSeller () const;

    /**
     * Retrieves the value of the field "sNameOfSeller" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sNameOfSeller".
     */
    inline ::std::string& getSNameOfSellerMutable ();

    /**
     * Sets the value of the member "sNameOfSeller".
     *
     * Name Of Seller
     *
     * @param sNameOfSeller The value which will be set
     */
    inline void setSNameOfSeller (const ::std::string& sNameOfSeller_);

    /**
     * Sets the value of the member "sNameOfSeller".
     *
     * Name Of Seller
     *
     * @param sNameOfSeller The value which will be set
     */
    inline void setSNameOfSeller (const char* sNameOfSeller_);

    /**
     * Sets the value of the member "sNameOfSeller".
     *
     * Name Of Seller
     *
     * @param sNameOfSeller The value which will be set
     */
    inline void setSNameOfSeller (const char* value, size_t size);

    /**
     * Release the object stored in the field "sNameOfSeller".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sNameOfSeller"
     */
    inline ::std::string* releaseSNameOfSeller();

    /**
     * Replace the field "sNameOfSeller".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSNameOfSeller (::std::string* sNameOfSeller_);

    // API of field "sDescription"

    static const int kSDescription = 5;

    /**
     * Clears the field "sDescription".
     *
     * The field will be set to its default value. The hasSDescription()
     * method will return false.
     */
    inline void clearSDescription();

    /**
     * Checks whether the field "sDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDescription()). Otherwise it will return false.
     */
    inline bool hasSDescription () const;

    /**
     * Returns the value of the member "sDescription".
     *
     * Description
     *
     * @return The value of the field "sDescription"
     */
    inline const ::std::string& getSDescription () const;

    /**
     * Retrieves the value of the field "sDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDescription".
     */
    inline ::std::string& getSDescriptionMutable ();

    /**
     * Sets the value of the member "sDescription".
     *
     * Description
     *
     * @param sDescription The value which will be set
     */
    inline void setSDescription (const ::std::string& sDescription_);

    /**
     * Sets the value of the member "sDescription".
     *
     * Description
     *
     * @param sDescription The value which will be set
     */
    inline void setSDescription (const char* sDescription_);

    /**
     * Sets the value of the member "sDescription".
     *
     * Description
     *
     * @param sDescription The value which will be set
     */
    inline void setSDescription (const char* value, size_t size);

    /**
     * Release the object stored in the field "sDescription".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sDescription"
     */
    inline ::std::string* releaseSDescription();

    /**
     * Replace the field "sDescription".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSDescription (::std::string* sDescription_);

    static const T_TunPSDCommercial &getDefaultInstance();

private:

    inline void set_has_sPriceString ();

    inline void clear_has_sPriceString ();

    inline void set_has_sValidUntil ();

    inline void clear_has_sValidUntil ();

    inline void set_has_sContactURL ();

    inline void clear_has_sContactURL ();

    inline void set_has_sReceivedAs ();

    inline void clear_has_sReceivedAs ();

    inline void set_has_sNameOfSeller ();

    inline void clear_has_sNameOfSeller ();

    inline void set_has_sDescription ();

    inline void clear_has_sDescription ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::std::string* _sPriceString;

    ::std::string* _sValidUntil;

    ::std::string* _sContactURL;

    ::std::string* _sReceivedAs;

    ::std::string* _sNameOfSeller;

    ::std::string* _sDescription;

};

/**
 * This Provides PSD Comment data
 */
class T_TunPSDComment {
public:

    /**
     * Default constructor
     */
    inline  T_TunPSDComment ();

    /**
     * Copy constructor
     */
    inline  T_TunPSDComment (const T_TunPSDComment &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunPSDComment (const ::std::string& sLanguage_, const ::std::string& sShortContentDescription_, const ::std::string& sActualText_);

    /**
     * Destructor
     */
    inline  ~T_TunPSDComment();

    /**
     * Assignment operator
     */
    inline T_TunPSDComment& operator = (const T_TunPSDComment& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunPSDComment& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunPSDComment& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunPSDComment& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunPSDComment& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "sLanguage"

    static const int kSLanguage = 0;

    /**
     * Clears the field "sLanguage".
     *
     * The field will be set to its default value. The hasSLanguage()
     * method will return false.
     */
    inline void clearSLanguage();

    /**
     * Checks whether the field "sLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLanguage()). Otherwise it will return false.
     */
    inline bool hasSLanguage () const;

    /**
     * Returns the value of the member "sLanguage".
     *
     * Language
     *
     * @return The value of the field "sLanguage"
     */
    inline const ::std::string& getSLanguage () const;

    /**
     * Retrieves the value of the field "sLanguage" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLanguage".
     */
    inline ::std::string& getSLanguageMutable ();

    /**
     * Sets the value of the member "sLanguage".
     *
     * Language
     *
     * @param sLanguage The value which will be set
     */
    inline void setSLanguage (const ::std::string& sLanguage_);

    /**
     * Sets the value of the member "sLanguage".
     *
     * Language
     *
     * @param sLanguage The value which will be set
     */
    inline void setSLanguage (const char* sLanguage_);

    /**
     * Sets the value of the member "sLanguage".
     *
     * Language
     *
     * @param sLanguage The value which will be set
     */
    inline void setSLanguage (const char* value, size_t size);

    /**
     * Release the object stored in the field "sLanguage".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sLanguage"
     */
    inline ::std::string* releaseSLanguage();

    /**
     * Replace the field "sLanguage".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSLanguage (::std::string* sLanguage_);

    // API of field "sShortContentDescription"

    static const int kSShortContentDescription = 1;

    /**
     * Clears the field "sShortContentDescription".
     *
     * The field will be set to its default value. The hasSShortContentDescription()
     * method will return false.
     */
    inline void clearSShortContentDescription();

    /**
     * Checks whether the field "sShortContentDescription" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSShortContentDescription()). Otherwise it will return false.
     */
    inline bool hasSShortContentDescription () const;

    /**
     * Returns the value of the member "sShortContentDescription".
     *
     * Short content Description
     *
     * @return The value of the field "sShortContentDescription"
     */
    inline const ::std::string& getSShortContentDescription () const;

    /**
     * Retrieves the value of the field "sShortContentDescription" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sShortContentDescription".
     */
    inline ::std::string& getSShortContentDescriptionMutable ();

    /**
     * Sets the value of the member "sShortContentDescription".
     *
     * Short content Description
     *
     * @param sShortContentDescription The value which will be set
     */
    inline void setSShortContentDescription (const ::std::string& sShortContentDescription_);

    /**
     * Sets the value of the member "sShortContentDescription".
     *
     * Short content Description
     *
     * @param sShortContentDescription The value which will be set
     */
    inline void setSShortContentDescription (const char* sShortContentDescription_);

    /**
     * Sets the value of the member "sShortContentDescription".
     *
     * Short content Description
     *
     * @param sShortContentDescription The value which will be set
     */
    inline void setSShortContentDescription (const char* value, size_t size);

    /**
     * Release the object stored in the field "sShortContentDescription".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sShortContentDescription"
     */
    inline ::std::string* releaseSShortContentDescription();

    /**
     * Replace the field "sShortContentDescription".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSShortContentDescription (::std::string* sShortContentDescription_);

    // API of field "sActualText"

    static const int kSActualText = 2;

    /**
     * Clears the field "sActualText".
     *
     * The field will be set to its default value. The hasSActualText()
     * method will return false.
     */
    inline void clearSActualText();

    /**
     * Checks whether the field "sActualText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSActualText()). Otherwise it will return false.
     */
    inline bool hasSActualText () const;

    /**
     * Returns the value of the member "sActualText".
     *
     * Actual Text
     *
     * @return The value of the field "sActualText"
     */
    inline const ::std::string& getSActualText () const;

    /**
     * Retrieves the value of the field "sActualText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sActualText".
     */
    inline ::std::string& getSActualTextMutable ();

    /**
     * Sets the value of the member "sActualText".
     *
     * Actual Text
     *
     * @param sActualText The value which will be set
     */
    inline void setSActualText (const ::std::string& sActualText_);

    /**
     * Sets the value of the member "sActualText".
     *
     * Actual Text
     *
     * @param sActualText The value which will be set
     */
    inline void setSActualText (const char* sActualText_);

    /**
     * Sets the value of the member "sActualText".
     *
     * Actual Text
     *
     * @param sActualText The value which will be set
     */
    inline void setSActualText (const char* value, size_t size);

    /**
     * Release the object stored in the field "sActualText".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sActualText"
     */
    inline ::std::string* releaseSActualText();

    /**
     * Replace the field "sActualText".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSActualText (::std::string* sActualText_);

    static const T_TunPSDComment &getDefaultInstance();

private:

    inline void set_has_sLanguage ();

    inline void clear_has_sLanguage ();

    inline void set_has_sShortContentDescription ();

    inline void clear_has_sShortContentDescription ();

    inline void set_has_sActualText ();

    inline void clear_has_sActualText ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string* _sLanguage;

    ::std::string* _sShortContentDescription;

    ::std::string* _sActualText;

};

/**
 * This Provides PSD data associated with a single AudioProgram
 */
class T_TunPSDData {
public:

    /**
     * Default constructor
     */
    inline  T_TunPSDData ();

    /**
     * Copy constructor
     */
    inline  T_TunPSDData (const T_TunPSDData &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunPSDData (T_e8_Tun_HDAudioProgram e8HDAudioProgram_, const ::std::string& sTitle_, const ::std::string& sArtist_, const ::std::string& sAlbum_, const ::std::string& sGenre_, const T_TunPSDCommercial& TunPSDCommercial_, const T_TunPSDComment& TunPSDComment_);

    /**
     * Destructor
     */
    inline  ~T_TunPSDData();

    /**
     * Assignment operator
     */
    inline T_TunPSDData& operator = (const T_TunPSDData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunPSDData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunPSDData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunPSDData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunPSDData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8HDAudioProgram"

    static const int kE8HDAudioProgram = 0;

    /**
     * Clears the field "e8HDAudioProgram".
     *
     * The field will be set to its default value. The hasE8HDAudioProgram()
     * method will return false.
     */
    inline void clearE8HDAudioProgram();

    /**
     * Checks whether the field "e8HDAudioProgram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8HDAudioProgram()). Otherwise it will return false.
     */
    inline bool hasE8HDAudioProgram () const;

    /**
     * Returns the value of the member "e8HDAudioProgram".
     *
     * Identifies audio program
     *
     * @return The value of the field "e8HDAudioProgram"
     */
    inline T_e8_Tun_HDAudioProgram getE8HDAudioProgram () const;

    /**
     * Sets the value of the member "e8HDAudioProgram".
     *
     * Identifies audio program
     *
     * @param e8HDAudioProgram The value which will be set
     */
    inline void setE8HDAudioProgram (T_e8_Tun_HDAudioProgram e8HDAudioProgram_);

    // API of field "sTitle"

    static const int kSTitle = 1;

    /**
     * Clears the field "sTitle".
     *
     * The field will be set to its default value. The hasSTitle()
     * method will return false.
     */
    inline void clearSTitle();

    /**
     * Checks whether the field "sTitle" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTitle()). Otherwise it will return false.
     */
    inline bool hasSTitle () const;

    /**
     * Returns the value of the member "sTitle".
     *
     * Title data
     *
     * @return The value of the field "sTitle"
     */
    inline const ::std::string& getSTitle () const;

    /**
     * Retrieves the value of the field "sTitle" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTitle".
     */
    inline ::std::string& getSTitleMutable ();

    /**
     * Sets the value of the member "sTitle".
     *
     * Title data
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const ::std::string& sTitle_);

    /**
     * Sets the value of the member "sTitle".
     *
     * Title data
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const char* sTitle_);

    /**
     * Sets the value of the member "sTitle".
     *
     * Title data
     *
     * @param sTitle The value which will be set
     */
    inline void setSTitle (const char* value, size_t size);

    /**
     * Release the object stored in the field "sTitle".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sTitle"
     */
    inline ::std::string* releaseSTitle();

    /**
     * Replace the field "sTitle".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSTitle (::std::string* sTitle_);

    // API of field "sArtist"

    static const int kSArtist = 2;

    /**
     * Clears the field "sArtist".
     *
     * The field will be set to its default value. The hasSArtist()
     * method will return false.
     */
    inline void clearSArtist();

    /**
     * Checks whether the field "sArtist" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSArtist()). Otherwise it will return false.
     */
    inline bool hasSArtist () const;

    /**
     * Returns the value of the member "sArtist".
     *
     * Artist name
     *
     * @return The value of the field "sArtist"
     */
    inline const ::std::string& getSArtist () const;

    /**
     * Retrieves the value of the field "sArtist" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sArtist".
     */
    inline ::std::string& getSArtistMutable ();

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist name
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const ::std::string& sArtist_);

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist name
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const char* sArtist_);

    /**
     * Sets the value of the member "sArtist".
     *
     * Artist name
     *
     * @param sArtist The value which will be set
     */
    inline void setSArtist (const char* value, size_t size);

    /**
     * Release the object stored in the field "sArtist".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sArtist"
     */
    inline ::std::string* releaseSArtist();

    /**
     * Replace the field "sArtist".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSArtist (::std::string* sArtist_);

    // API of field "sAlbum"

    static const int kSAlbum = 3;

    /**
     * Clears the field "sAlbum".
     *
     * The field will be set to its default value. The hasSAlbum()
     * method will return false.
     */
    inline void clearSAlbum();

    /**
     * Checks whether the field "sAlbum" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSAlbum()). Otherwise it will return false.
     */
    inline bool hasSAlbum () const;

    /**
     * Returns the value of the member "sAlbum".
     *
     * Album name
     *
     * @return The value of the field "sAlbum"
     */
    inline const ::std::string& getSAlbum () const;

    /**
     * Retrieves the value of the field "sAlbum" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sAlbum".
     */
    inline ::std::string& getSAlbumMutable ();

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album name
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const ::std::string& sAlbum_);

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album name
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const char* sAlbum_);

    /**
     * Sets the value of the member "sAlbum".
     *
     * Album name
     *
     * @param sAlbum The value which will be set
     */
    inline void setSAlbum (const char* value, size_t size);

    /**
     * Release the object stored in the field "sAlbum".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sAlbum"
     */
    inline ::std::string* releaseSAlbum();

    /**
     * Replace the field "sAlbum".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSAlbum (::std::string* sAlbum_);

    // API of field "sGenre"

    static const int kSGenre = 4;

    /**
     * Clears the field "sGenre".
     *
     * The field will be set to its default value. The hasSGenre()
     * method will return false.
     */
    inline void clearSGenre();

    /**
     * Checks whether the field "sGenre" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSGenre()). Otherwise it will return false.
     */
    inline bool hasSGenre () const;

    /**
     * Returns the value of the member "sGenre".
     *
     * Genre
     *
     * @return The value of the field "sGenre"
     */
    inline const ::std::string& getSGenre () const;

    /**
     * Retrieves the value of the field "sGenre" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sGenre".
     */
    inline ::std::string& getSGenreMutable ();

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const ::std::string& sGenre_);

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const char* sGenre_);

    /**
     * Sets the value of the member "sGenre".
     *
     * Genre
     *
     * @param sGenre The value which will be set
     */
    inline void setSGenre (const char* value, size_t size);

    /**
     * Release the object stored in the field "sGenre".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sGenre"
     */
    inline ::std::string* releaseSGenre();

    /**
     * Replace the field "sGenre".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSGenre (::std::string* sGenre_);

    // API of field "TunPSDCommercial"

    static const int kTunPSDCommercial = 5;

    /**
     * Clears the field "TunPSDCommercial".
     *
     * The field will be set to its default value. The hasTunPSDCommercial()
     * method will return false.
     */
    inline void clearTunPSDCommercial();

    /**
     * Checks whether the field "TunPSDCommercial" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunPSDCommercial()). Otherwise it will return false.
     */
    inline bool hasTunPSDCommercial () const;

    /**
     * Returns the value of the member "TunPSDCommercial".
     *
     * Commercial  data
     *
     * @return The value of the field "TunPSDCommercial"
     */
    inline const T_TunPSDCommercial& getTunPSDCommercial () const;

    /**
     * Retrieves the value of the field "TunPSDCommercial" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunPSDCommercial".
     */
    inline T_TunPSDCommercial& getTunPSDCommercialMutable ();

    /**
     * Sets the value of the member "TunPSDCommercial".
     *
     * Commercial  data
     *
     * @param TunPSDCommercial The value which will be set
     */
    inline void setTunPSDCommercial (const T_TunPSDCommercial& TunPSDCommercial_);

    /**
     * Release the object stored in the field "TunPSDCommercial".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "TunPSDCommercial"
     */
    inline T_TunPSDCommercial* releaseTunPSDCommercial();

    /**
     * Replace the field "TunPSDCommercial".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTunPSDCommercial (T_TunPSDCommercial* TunPSDCommercial_);

    // API of field "TunPSDComment"

    static const int kTunPSDComment = 6;

    /**
     * Clears the field "TunPSDComment".
     *
     * The field will be set to its default value. The hasTunPSDComment()
     * method will return false.
     */
    inline void clearTunPSDComment();

    /**
     * Checks whether the field "TunPSDComment" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunPSDComment()). Otherwise it will return false.
     */
    inline bool hasTunPSDComment () const;

    /**
     * Returns the value of the member "TunPSDComment".
     *
     * Comment  data
     *
     * @return The value of the field "TunPSDComment"
     */
    inline const T_TunPSDComment& getTunPSDComment () const;

    /**
     * Retrieves the value of the field "TunPSDComment" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunPSDComment".
     */
    inline T_TunPSDComment& getTunPSDCommentMutable ();

    /**
     * Sets the value of the member "TunPSDComment".
     *
     * Comment  data
     *
     * @param TunPSDComment The value which will be set
     */
    inline void setTunPSDComment (const T_TunPSDComment& TunPSDComment_);

    /**
     * Release the object stored in the field "TunPSDComment".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "TunPSDComment"
     */
    inline T_TunPSDComment* releaseTunPSDComment();

    /**
     * Replace the field "TunPSDComment".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceTunPSDComment (T_TunPSDComment* TunPSDComment_);

    static const T_TunPSDData &getDefaultInstance();

private:

    inline void set_has_e8HDAudioProgram ();

    inline void clear_has_e8HDAudioProgram ();

    inline void set_has_sTitle ();

    inline void clear_has_sTitle ();

    inline void set_has_sArtist ();

    inline void clear_has_sArtist ();

    inline void set_has_sAlbum ();

    inline void clear_has_sAlbum ();

    inline void set_has_sGenre ();

    inline void clear_has_sGenre ();

    inline void set_has_TunPSDCommercial ();

    inline void clear_has_TunPSDCommercial ();

    inline void set_has_TunPSDComment ();

    inline void clear_has_TunPSDComment ();

    uint32 _has_bits_[ (7 + 31) / 32];

    T_e8_Tun_HDAudioProgram _e8HDAudioProgram;

    ::std::string* _sTitle;

    ::std::string* _sArtist;

    ::std::string* _sAlbum;

    ::std::string* _sGenre;

    T_TunPSDCommercial* _TunPSDCommercial;

    T_TunPSDComment* _TunPSDComment;

};

class T_PhysicalTunerCalibData {
public:

    /**
     * Default constructor
     */
    inline  T_PhysicalTunerCalibData ();

    /**
     * Copy constructor
     */
    inline  T_PhysicalTunerCalibData (const T_PhysicalTunerCalibData &rhs);

    /**
     * All fields constructor
     */
    inline  T_PhysicalTunerCalibData (const T_b8_Tun_Tunerbandbits& b8AvailableBands_, uint16 u16FMCalibrationValue_, uint16 u16AMCalibrationValue_);

    /**
     * Destructor
     */
    inline  ~T_PhysicalTunerCalibData();

    /**
     * Assignment operator
     */
    inline T_PhysicalTunerCalibData& operator = (const T_PhysicalTunerCalibData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_PhysicalTunerCalibData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_PhysicalTunerCalibData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_PhysicalTunerCalibData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_PhysicalTunerCalibData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b8AvailableBands"

    static const int kB8AvailableBands = 0;

    /**
     * Clears the field "b8AvailableBands".
     *
     * The field will be set to its default value. The hasB8AvailableBands()
     * method will return false.
     */
    inline void clearB8AvailableBands();

    /**
     * Checks whether the field "b8AvailableBands" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8AvailableBands()). Otherwise it will return false.
     */
    inline bool hasB8AvailableBands () const;

    /**
     * Returns the value of the member "b8AvailableBands".
     *
     * Bit 0 False Not DDA master
     * True  DDA master
     * Bit 1 False Not DDA slave
     * True  DDA slave
     * Bit 2 False FM band not supported
     * True  FM band supported
     * Bit 3 False AM band not supported
     * True  AM band supported
     * Bit 4 False DAB3 band not supported
     * True  DAB3 band supported
     * Bit 5 False DABL band not supported
     * True  DABL band supported
     *
     * @return The value of the field "b8AvailableBands"
     */
    inline const T_b8_Tun_Tunerbandbits& getB8AvailableBands () const;

    /**
     * Retrieves the value of the field "b8AvailableBands" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8AvailableBands".
     */
    inline T_b8_Tun_Tunerbandbits& getB8AvailableBandsMutable ();

    /**
     * Sets the value of the member "b8AvailableBands".
     *
     * Bit 0 False Not DDA master
     * True  DDA master
     * Bit 1 False Not DDA slave
     * True  DDA slave
     * Bit 2 False FM band not supported
     * True  FM band supported
     * Bit 3 False AM band not supported
     * True  AM band supported
     * Bit 4 False DAB3 band not supported
     * True  DAB3 band supported
     * Bit 5 False DABL band not supported
     * True  DABL band supported
     *
     * @param b8AvailableBands The value which will be set
     */
    inline void setB8AvailableBands (const T_b8_Tun_Tunerbandbits& b8AvailableBands_);

    /**
     * Release the object stored in the field "b8AvailableBands".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "b8AvailableBands"
     */
    inline T_b8_Tun_Tunerbandbits* releaseB8AvailableBands();

    /**
     * Replace the field "b8AvailableBands".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceB8AvailableBands (T_b8_Tun_Tunerbandbits* b8AvailableBands_);

    // API of field "u16FMCalibrationValue"

    static const int kU16FMCalibrationValue = 1;

    /**
     * Clears the field "u16FMCalibrationValue".
     *
     * The field will be set to its default value. The hasU16FMCalibrationValue()
     * method will return false.
     */
    inline void clearU16FMCalibrationValue();

    /**
     * Checks whether the field "u16FMCalibrationValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FMCalibrationValue()). Otherwise it will return false.
     */
    inline bool hasU16FMCalibrationValue () const;

    /**
     * Returns the value of the member "u16FMCalibrationValue".
     *
     *
     *
     * @return The value of the field "u16FMCalibrationValue"
     */
    inline uint16 getU16FMCalibrationValue () const;

    /**
     * Sets the value of the member "u16FMCalibrationValue".
     *
     *
     *
     * @param u16FMCalibrationValue The value which will be set
     */
    inline void setU16FMCalibrationValue (uint16 u16FMCalibrationValue_);

    // API of field "u16AMCalibrationValue"

    static const int kU16AMCalibrationValue = 2;

    /**
     * Clears the field "u16AMCalibrationValue".
     *
     * The field will be set to its default value. The hasU16AMCalibrationValue()
     * method will return false.
     */
    inline void clearU16AMCalibrationValue();

    /**
     * Checks whether the field "u16AMCalibrationValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AMCalibrationValue()). Otherwise it will return false.
     */
    inline bool hasU16AMCalibrationValue () const;

    /**
     * Returns the value of the member "u16AMCalibrationValue".
     *
     *
     *
     * @return The value of the field "u16AMCalibrationValue"
     */
    inline uint16 getU16AMCalibrationValue () const;

    /**
     * Sets the value of the member "u16AMCalibrationValue".
     *
     *
     *
     * @param u16AMCalibrationValue The value which will be set
     */
    inline void setU16AMCalibrationValue (uint16 u16AMCalibrationValue_);

    static const T_PhysicalTunerCalibData &getDefaultInstance();

private:

    inline void set_has_b8AvailableBands ();

    inline void clear_has_b8AvailableBands ();

    inline void set_has_u16FMCalibrationValue ();

    inline void clear_has_u16FMCalibrationValue ();

    inline void set_has_u16AMCalibrationValue ();

    inline void clear_has_u16AMCalibrationValue ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_b8_Tun_Tunerbandbits* _b8AvailableBands;

    uint16 _u16FMCalibrationValue;

    uint16 _u16AMCalibrationValue;

};

class T_CalibrationData {
public:

    /**
     * Default constructor
     */
    inline  T_CalibrationData ();

    /**
     * Copy constructor
     */
    inline  T_CalibrationData (const T_CalibrationData &rhs);

    /**
     * All fields constructor
     */
    inline  T_CalibrationData (const T_PhysicalTunerCalibData& PhysicalTunerOne_, const T_PhysicalTunerCalibData& PhysicalTunerTwo_, const T_PhysicalTunerCalibData& PhysicalTunerThree_, const T_PhysicalTunerCalibData& PhysicalTunerFour_);

    /**
     * Destructor
     */
    inline  ~T_CalibrationData();

    /**
     * Assignment operator
     */
    inline T_CalibrationData& operator = (const T_CalibrationData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CalibrationData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CalibrationData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CalibrationData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CalibrationData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhysicalTunerOne"

    static const int kPhysicalTunerOne = 0;

    /**
     * Clears the field "PhysicalTunerOne".
     *
     * The field will be set to its default value. The hasPhysicalTunerOne()
     * method will return false.
     */
    inline void clearPhysicalTunerOne();

    /**
     * Checks whether the field "PhysicalTunerOne" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhysicalTunerOne()). Otherwise it will return false.
     */
    inline bool hasPhysicalTunerOne () const;

    /**
     * Returns the value of the member "PhysicalTunerOne".
     *
     *
     *
     * @return The value of the field "PhysicalTunerOne"
     */
    inline const T_PhysicalTunerCalibData& getPhysicalTunerOne () const;

    /**
     * Retrieves the value of the field "PhysicalTunerOne" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhysicalTunerOne".
     */
    inline T_PhysicalTunerCalibData& getPhysicalTunerOneMutable ();

    /**
     * Sets the value of the member "PhysicalTunerOne".
     *
     *
     *
     * @param PhysicalTunerOne The value which will be set
     */
    inline void setPhysicalTunerOne (const T_PhysicalTunerCalibData& PhysicalTunerOne_);

    /**
     * Release the object stored in the field "PhysicalTunerOne".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "PhysicalTunerOne"
     */
    inline T_PhysicalTunerCalibData* releasePhysicalTunerOne();

    /**
     * Replace the field "PhysicalTunerOne".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePhysicalTunerOne (T_PhysicalTunerCalibData* PhysicalTunerOne_);

    // API of field "PhysicalTunerTwo"

    static const int kPhysicalTunerTwo = 1;

    /**
     * Clears the field "PhysicalTunerTwo".
     *
     * The field will be set to its default value. The hasPhysicalTunerTwo()
     * method will return false.
     */
    inline void clearPhysicalTunerTwo();

    /**
     * Checks whether the field "PhysicalTunerTwo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhysicalTunerTwo()). Otherwise it will return false.
     */
    inline bool hasPhysicalTunerTwo () const;

    /**
     * Returns the value of the member "PhysicalTunerTwo".
     *
     *
     *
     * @return The value of the field "PhysicalTunerTwo"
     */
    inline const T_PhysicalTunerCalibData& getPhysicalTunerTwo () const;

    /**
     * Retrieves the value of the field "PhysicalTunerTwo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhysicalTunerTwo".
     */
    inline T_PhysicalTunerCalibData& getPhysicalTunerTwoMutable ();

    /**
     * Sets the value of the member "PhysicalTunerTwo".
     *
     *
     *
     * @param PhysicalTunerTwo The value which will be set
     */
    inline void setPhysicalTunerTwo (const T_PhysicalTunerCalibData& PhysicalTunerTwo_);

    /**
     * Release the object stored in the field "PhysicalTunerTwo".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "PhysicalTunerTwo"
     */
    inline T_PhysicalTunerCalibData* releasePhysicalTunerTwo();

    /**
     * Replace the field "PhysicalTunerTwo".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePhysicalTunerTwo (T_PhysicalTunerCalibData* PhysicalTunerTwo_);

    // API of field "PhysicalTunerThree"

    static const int kPhysicalTunerThree = 2;

    /**
     * Clears the field "PhysicalTunerThree".
     *
     * The field will be set to its default value. The hasPhysicalTunerThree()
     * method will return false.
     */
    inline void clearPhysicalTunerThree();

    /**
     * Checks whether the field "PhysicalTunerThree" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhysicalTunerThree()). Otherwise it will return false.
     */
    inline bool hasPhysicalTunerThree () const;

    /**
     * Returns the value of the member "PhysicalTunerThree".
     *
     *
     *
     * @return The value of the field "PhysicalTunerThree"
     */
    inline const T_PhysicalTunerCalibData& getPhysicalTunerThree () const;

    /**
     * Retrieves the value of the field "PhysicalTunerThree" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhysicalTunerThree".
     */
    inline T_PhysicalTunerCalibData& getPhysicalTunerThreeMutable ();

    /**
     * Sets the value of the member "PhysicalTunerThree".
     *
     *
     *
     * @param PhysicalTunerThree The value which will be set
     */
    inline void setPhysicalTunerThree (const T_PhysicalTunerCalibData& PhysicalTunerThree_);

    /**
     * Release the object stored in the field "PhysicalTunerThree".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "PhysicalTunerThree"
     */
    inline T_PhysicalTunerCalibData* releasePhysicalTunerThree();

    /**
     * Replace the field "PhysicalTunerThree".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePhysicalTunerThree (T_PhysicalTunerCalibData* PhysicalTunerThree_);

    // API of field "PhysicalTunerFour"

    static const int kPhysicalTunerFour = 3;

    /**
     * Clears the field "PhysicalTunerFour".
     *
     * The field will be set to its default value. The hasPhysicalTunerFour()
     * method will return false.
     */
    inline void clearPhysicalTunerFour();

    /**
     * Checks whether the field "PhysicalTunerFour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhysicalTunerFour()). Otherwise it will return false.
     */
    inline bool hasPhysicalTunerFour () const;

    /**
     * Returns the value of the member "PhysicalTunerFour".
     *
     *
     *
     * @return The value of the field "PhysicalTunerFour"
     */
    inline const T_PhysicalTunerCalibData& getPhysicalTunerFour () const;

    /**
     * Retrieves the value of the field "PhysicalTunerFour" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhysicalTunerFour".
     */
    inline T_PhysicalTunerCalibData& getPhysicalTunerFourMutable ();

    /**
     * Sets the value of the member "PhysicalTunerFour".
     *
     *
     *
     * @param PhysicalTunerFour The value which will be set
     */
    inline void setPhysicalTunerFour (const T_PhysicalTunerCalibData& PhysicalTunerFour_);

    /**
     * Release the object stored in the field "PhysicalTunerFour".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "PhysicalTunerFour"
     */
    inline T_PhysicalTunerCalibData* releasePhysicalTunerFour();

    /**
     * Replace the field "PhysicalTunerFour".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replacePhysicalTunerFour (T_PhysicalTunerCalibData* PhysicalTunerFour_);

    static const T_CalibrationData &getDefaultInstance();

private:

    inline void set_has_PhysicalTunerOne ();

    inline void clear_has_PhysicalTunerOne ();

    inline void set_has_PhysicalTunerTwo ();

    inline void clear_has_PhysicalTunerTwo ();

    inline void set_has_PhysicalTunerThree ();

    inline void clear_has_PhysicalTunerThree ();

    inline void set_has_PhysicalTunerFour ();

    inline void clear_has_PhysicalTunerFour ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_PhysicalTunerCalibData* _PhysicalTunerOne;

    T_PhysicalTunerCalibData* _PhysicalTunerTwo;

    T_PhysicalTunerCalibData* _PhysicalTunerThree;

    T_PhysicalTunerCalibData* _PhysicalTunerFour;

};

/**
 * If the meaning of "T_TunerJapanStationName" isn't clear, then there should be a description here.
 */
class T_TunerJapanStationName {
public:

    /**
     * Default constructor
     */
    inline  T_TunerJapanStationName ();

    /**
     * Copy constructor
     */
    inline  T_TunerJapanStationName (const T_TunerJapanStationName &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerJapanStationName (uint16 u16IndexID_, const ::std::string& sJapanStationName_);

    /**
     * Destructor
     */
    inline  ~T_TunerJapanStationName();

    /**
     * Assignment operator
     */
    inline T_TunerJapanStationName& operator = (const T_TunerJapanStationName& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerJapanStationName& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerJapanStationName& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerJapanStationName& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerJapanStationName& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16IndexID"

    static const int kU16IndexID = 0;

    /**
     * Clears the field "u16IndexID".
     *
     * The field will be set to its default value. The hasU16IndexID()
     * method will return false.
     */
    inline void clearU16IndexID();

    /**
     * Checks whether the field "u16IndexID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16IndexID()). Otherwise it will return false.
     */
    inline bool hasU16IndexID () const;

    /**
     * Returns the value of the member "u16IndexID".
     *
     * Gives the element ID based on the location in database
     *
     * @return The value of the field "u16IndexID"
     */
    inline uint16 getU16IndexID () const;

    /**
     * Sets the value of the member "u16IndexID".
     *
     * Gives the element ID based on the location in database
     *
     * @param u16IndexID The value which will be set
     */
    inline void setU16IndexID (uint16 u16IndexID_);

    // API of field "sJapanStationName"

    static const int kSJapanStationName = 1;

    /**
     * Clears the field "sJapanStationName".
     *
     * The field will be set to its default value. The hasSJapanStationName()
     * method will return false.
     */
    inline void clearSJapanStationName();

    /**
     * Checks whether the field "sJapanStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSJapanStationName()). Otherwise it will return false.
     */
    inline bool hasSJapanStationName () const;

    /**
     * Returns the value of the member "sJapanStationName".
     *
     * Gives station name for current frequency and selected area code
     *
     * @return The value of the field "sJapanStationName"
     */
    inline const ::std::string& getSJapanStationName () const;

    /**
     * Retrieves the value of the field "sJapanStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sJapanStationName".
     */
    inline ::std::string& getSJapanStationNameMutable ();

    /**
     * Sets the value of the member "sJapanStationName".
     *
     * Gives station name for current frequency and selected area code
     *
     * @param sJapanStationName The value which will be set
     */
    inline void setSJapanStationName (const ::std::string& sJapanStationName_);

    /**
     * Sets the value of the member "sJapanStationName".
     *
     * Gives station name for current frequency and selected area code
     *
     * @param sJapanStationName The value which will be set
     */
    inline void setSJapanStationName (const char* sJapanStationName_);

    /**
     * Sets the value of the member "sJapanStationName".
     *
     * Gives station name for current frequency and selected area code
     *
     * @param sJapanStationName The value which will be set
     */
    inline void setSJapanStationName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sJapanStationName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sJapanStationName"
     */
    inline ::std::string* releaseSJapanStationName();

    /**
     * Replace the field "sJapanStationName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSJapanStationName (::std::string* sJapanStationName_);

    static const T_TunerJapanStationName &getDefaultInstance();

private:

    inline void set_has_u16IndexID ();

    inline void clear_has_u16IndexID ();

    inline void set_has_sJapanStationName ();

    inline void clear_has_sJapanStationName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _u16IndexID;

    ::std::string* _sJapanStationName;

};

/**
 * Byte 0 STAT - Status Register ( Register to confirm various states) Address 1h.
 * Reset value is 1 for bit 1, all other bits are 0.
 * bit 7 VH  -	Determination on vertically error corrected data.
 * 0 -	Data for which only horizontal correction is perfomed.
 * 1 -	Data for which veritical and sound horizontal correction after horizontal correction are performed.
 *
 * bit 6 BLK -	Block synchronisation state.
 * 0 - Data is received when block synchronisation is not established.
 * 1 - Data is received when block synchronisation is established.
 *
 * bit 5 FRM -	Frame synchronisation state.
 * 0 - Data is received when frame synchronisation is not established.
 * 1 - Data is received when frame synchronisation is established.
 *
 * bit 4 ERR -	Error correction state.
 * 0 - Data whose correction is completed and for which error is not detected by the layer 2 CRC check.
 * 1 -	Data whose correction is impossible on for which error is detected by the layer 2 CRC check.
 *
 * bit 3 PRI -	Determination of parity block.
 * 0 - Data that is estimated to be data block by frame synchronisation circuit.
 * 1 - Data that is estimated to be parity block by frame synchronisation circuit.
 *
 * bit 2 Head -	Frame head determination.
 * 1 - Data that is estimated to be frame head block by frame synchronisation circuit.
 * 0 -	Data other than above.
 *
 * bit 1 CRC4 -	Layer 4 CRC check result.
 * 0 - Error in layer 4 CRC check result.
 * 1 - No error in layer 4 CRC check result.
 *
 * bit 0 	 - 	Reserved.
 */
class T_b8_Tun_STATStatusRegister {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_STATStatusRegister ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_STATStatusRegister (const T_b8_Tun_STATStatusRegister &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_STATStatusRegister (bool Reserved, bool STAT_CRC4, bool STAT_HEAD, bool STAT_PRI, bool STAT_ERR, bool STAT_FRM, bool STAT_BLK, bool STAT_VH);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_STATStatusRegister& operator = (const T_b8_Tun_STATStatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_STATStatusRegister& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_STATStatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_STATStatusRegister& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_STATStatusRegister& rhs) const;

    /**
     * Sets the value of the member "Reserved".
     *
     * If the meaning of "Reserved" isn't clear, then there should be a description here.
     *
     * @param Reserved The value which will be set
     */
    inline void setReserved (bool Reserved);

    /**
     * Returns the value of the member "Reserved".
     *
     * If the meaning of "Reserved" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Reserved"
     */
    inline bool getReserved () const;

    /**
     * Sets the value of the member "STAT_CRC4".
     *
     * If the meaning of "STAT_CRC4" isn't clear, then there should be a description here.
     *
     * @param STAT_CRC4 The value which will be set
     */
    inline void setSTAT_CRC4 (bool STAT_CRC4);

    /**
     * Returns the value of the member "STAT_CRC4".
     *
     * If the meaning of "STAT_CRC4" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_CRC4"
     */
    inline bool getSTAT_CRC4 () const;

    /**
     * Sets the value of the member "STAT_HEAD".
     *
     * If the meaning of "STAT_HEAD" isn't clear, then there should be a description here.
     *
     * @param STAT_HEAD The value which will be set
     */
    inline void setSTAT_HEAD (bool STAT_HEAD);

    /**
     * Returns the value of the member "STAT_HEAD".
     *
     * If the meaning of "STAT_HEAD" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_HEAD"
     */
    inline bool getSTAT_HEAD () const;

    /**
     * Sets the value of the member "STAT_PRI".
     *
     * If the meaning of "STAT_PRI" isn't clear, then there should be a description here.
     *
     * @param STAT_PRI The value which will be set
     */
    inline void setSTAT_PRI (bool STAT_PRI);

    /**
     * Returns the value of the member "STAT_PRI".
     *
     * If the meaning of "STAT_PRI" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_PRI"
     */
    inline bool getSTAT_PRI () const;

    /**
     * Sets the value of the member "STAT_ERR".
     *
     * If the meaning of "STAT_ERR" isn't clear, then there should be a description here.
     *
     * @param STAT_ERR The value which will be set
     */
    inline void setSTAT_ERR (bool STAT_ERR);

    /**
     * Returns the value of the member "STAT_ERR".
     *
     * If the meaning of "STAT_ERR" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_ERR"
     */
    inline bool getSTAT_ERR () const;

    /**
     * Sets the value of the member "STAT_FRM".
     *
     * If the meaning of "STAT_FRM" isn't clear, then there should be a description here.
     *
     * @param STAT_FRM The value which will be set
     */
    inline void setSTAT_FRM (bool STAT_FRM);

    /**
     * Returns the value of the member "STAT_FRM".
     *
     * If the meaning of "STAT_FRM" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_FRM"
     */
    inline bool getSTAT_FRM () const;

    /**
     * Sets the value of the member "STAT_BLK".
     *
     * If the meaning of "STAT_BLK" isn't clear, then there should be a description here.
     *
     * @param STAT_BLK The value which will be set
     */
    inline void setSTAT_BLK (bool STAT_BLK);

    /**
     * Returns the value of the member "STAT_BLK".
     *
     * If the meaning of "STAT_BLK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_BLK"
     */
    inline bool getSTAT_BLK () const;

    /**
     * Sets the value of the member "STAT_VH".
     *
     * If the meaning of "STAT_VH" isn't clear, then there should be a description here.
     *
     * @param STAT_VH The value which will be set
     */
    inline void setSTAT_VH (bool STAT_VH);

    /**
     * Returns the value of the member "STAT_VH".
     *
     * If the meaning of "STAT_VH" isn't clear, then there should be a description here.
     *
     * @return The value of the field "STAT_VH"
     */
    inline bool getSTAT_VH () const;

    static const T_b8_Tun_STATStatusRegister &getDefaultInstance();

private:

    bool _Reserved:1;

    bool _STAT_CRC4:1;

    bool _STAT_HEAD:1;

    bool _STAT_PRI:1;

    bool _STAT_ERR:1;

    bool _STAT_FRM:1;

    bool _STAT_BLK:1;

    bool _STAT_VH:1;

};

/**
 * If the meaning of "T_DARCDataBlock" isn't clear, then there should be a description here.
 */
class T_DARCDataBlock {
public:

    /**
     * Default constructor
     */
    inline  T_DARCDataBlock ();

    /**
     * Copy constructor
     */
    inline  T_DARCDataBlock (const T_DARCDataBlock &rhs);

    /**
     * All fields constructor
     */
    inline  T_DARCDataBlock (const T_b8_Tun_STATStatusRegister& STAT_Status_Register_, uint8 Block_Number_Register_, const ::std::vector< uint8 >& DARCDataList_);

    /**
     * Destructor
     */
    inline  ~T_DARCDataBlock();

    /**
     * Assignment operator
     */
    inline T_DARCDataBlock& operator = (const T_DARCDataBlock& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DARCDataBlock& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DARCDataBlock& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DARCDataBlock& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DARCDataBlock& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "STAT_Status_Register"

    static const int kSTAT_Status_Register = 0;

    /**
     * Clears the field "STAT_Status_Register".
     *
     * The field will be set to its default value. The hasSTAT_Status_Register()
     * method will return false.
     */
    inline void clearSTAT_Status_Register();

    /**
     * Checks whether the field "STAT_Status_Register" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTAT_Status_Register()). Otherwise it will return false.
     */
    inline bool hasSTAT_Status_Register () const;

    /**
     * Returns the value of the member "STAT_Status_Register".
     *
     * Register to confirm various states
     *
     * @return The value of the field "STAT_Status_Register"
     */
    inline const T_b8_Tun_STATStatusRegister& getSTAT_Status_Register () const;

    /**
     * Retrieves the value of the field "STAT_Status_Register" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "STAT_Status_Register".
     */
    inline T_b8_Tun_STATStatusRegister& getSTAT_Status_RegisterMutable ();

    /**
     * Sets the value of the member "STAT_Status_Register".
     *
     * Register to confirm various states
     *
     * @param STAT_Status_Register The value which will be set
     */
    inline void setSTAT_Status_Register (const T_b8_Tun_STATStatusRegister& STAT_Status_Register_);

    /**
     * Release the object stored in the field "STAT_Status_Register".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "STAT_Status_Register"
     */
    inline T_b8_Tun_STATStatusRegister* releaseSTAT_Status_Register();

    /**
     * Replace the field "STAT_Status_Register".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSTAT_Status_Register (T_b8_Tun_STATStatusRegister* STAT_Status_Register_);

    // API of field "Block_Number_Register"

    static const int kBlock_Number_Register = 1;

    /**
     * Clears the field "Block_Number_Register".
     *
     * The field will be set to its default value. The hasBlock_Number_Register()
     * method will return false.
     */
    inline void clearBlock_Number_Register();

    /**
     * Checks whether the field "Block_Number_Register" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBlock_Number_Register()). Otherwise it will return false.
     */
    inline bool hasBlock_Number_Register () const;

    /**
     * Returns the value of the member "Block_Number_Register".
     *
     * Register to confirm the output data block
     * Byte 1 BLNO - Block Number Register ( Register to confirm output data block number) Address 2h.
     * Reset value is 0 for all bits.
     * Indicates the block number or parity block number of output data.
     * Data block number 0 to 189.
     * parity block number 0 to 81.
     * Bit names - BLN7.....BLN0.
     *
     * @return The value of the field "Block_Number_Register"
     */
    inline uint8 getBlock_Number_Register () const;

    /**
     * Sets the value of the member "Block_Number_Register".
     *
     * Register to confirm the output data block
     * Byte 1 BLNO - Block Number Register ( Register to confirm output data block number) Address 2h.
     * Reset value is 0 for all bits.
     * Indicates the block number or parity block number of output data.
     * Data block number 0 to 189.
     * parity block number 0 to 81.
     * Bit names - BLN7.....BLN0.
     *
     * @param Block_Number_Register The value which will be set
     */
    inline void setBlock_Number_Register (uint8 Block_Number_Register_);

    // API of field "DARCDataList"

    static const int kDARCDataList = 2;

    /**
     * Clears the field "DARCDataList".
     *
     * The field will be set to its default value. The hasDARCDataList()
     * method will return false.
     */
    inline void clearDARCDataList();

    /**
     * Checks whether the field "DARCDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDARCDataList()). Otherwise it will return false.
     */
    inline bool hasDARCDataList () const;

    /**
     * Returns the value of the member "DARCDataList".
     *
     * It contains a list of DARC data without leading BIC, CRC and Parity bytes from each DARC data block (from 34 data bytes to 22 data bytes)
     * Only 22 data bytes will be sent.
     *
     * @return The value of the field "DARCDataList"
     */
    inline const ::std::vector< uint8 >& getDARCDataList () const;

    /**
     * Retrieves the value of the field "DARCDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DARCDataList".
     */
    inline ::std::vector< uint8 >& getDARCDataListMutable ();

    /**
     * Sets the value of the member "DARCDataList".
     *
     * It contains a list of DARC data without leading BIC, CRC and Parity bytes from each DARC data block (from 34 data bytes to 22 data bytes)
     * Only 22 data bytes will be sent.
     *
     * @param DARCDataList The value which will be set
     */
    inline void setDARCDataList (const ::std::vector< uint8 >& DARCDataList_);

    /**
     * Release the object stored in the field "DARCDataList".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "DARCDataList"
     */
    inline ::std::vector< uint8 >* releaseDARCDataList();

    /**
     * Replace the field "DARCDataList".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceDARCDataList (::std::vector< uint8 >* DARCDataList_);

    static const T_DARCDataBlock &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_STAT_Status_Register ();

    inline void clear_has_STAT_Status_Register ();

    inline void set_has_Block_Number_Register ();

    inline void clear_has_Block_Number_Register ();

    inline void set_has_DARCDataList ();

    inline void clear_has_DARCDataList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_b8_Tun_STATStatusRegister* _STAT_Status_Register;

    uint8 _Block_Number_Register;

    ::std::vector< uint8 >* _DARCDataList;

};

/**
 * Tuner Preset list elements are contained in this structure.
 */
class T_TunerListElement {
public:

    /**
     * Default constructor
     */
    inline  T_TunerListElement ();

    /**
     * Copy constructor
     */
    inline  T_TunerListElement (const T_TunerListElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_TunerListElement (T_e8_Tun_ListID e8ListID_, uint8 u8ElementID_, T_e8_Tun_ModulationType e8Modulation_, uint32 u32Frequency_, uint32 u32SID_, uint8 u8NumOfCharactersInStationName_, const ::std::string& sStationName_, uint8 u8StationNameEncoding_, uint8 u8ProgramService_);

    /**
     * Destructor
     */
    inline  ~T_TunerListElement();

    /**
     * Assignment operator
     */
    inline T_TunerListElement& operator = (const T_TunerListElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TunerListElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TunerListElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TunerListElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TunerListElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ListID"

    static const int kE8ListID = 0;

    /**
     * Clears the field "e8ListID".
     *
     * The field will be set to its default value. The hasE8ListID()
     * method will return false.
     */
    inline void clearE8ListID();

    /**
     * Checks whether the field "e8ListID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ListID()). Otherwise it will return false.
     */
    inline bool hasE8ListID () const;

    /**
     * Returns the value of the member "e8ListID".
     *
     *
     *
     * @return The value of the field "e8ListID"
     */
    inline T_e8_Tun_ListID getE8ListID () const;

    /**
     * Sets the value of the member "e8ListID".
     *
     *
     *
     * @param e8ListID The value which will be set
     */
    inline void setE8ListID (T_e8_Tun_ListID e8ListID_);

    // API of field "u8ElementID"

    static const int kU8ElementID = 1;

    /**
     * Clears the field "u8ElementID".
     *
     * The field will be set to its default value. The hasU8ElementID()
     * method will return false.
     */
    inline void clearU8ElementID();

    /**
     * Checks whether the field "u8ElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ElementID()). Otherwise it will return false.
     */
    inline bool hasU8ElementID () const;

    /**
     * Returns the value of the member "u8ElementID".
     *
     *
     *
     * @return The value of the field "u8ElementID"
     */
    inline uint8 getU8ElementID () const;

    /**
     * Sets the value of the member "u8ElementID".
     *
     *
     *
     * @param u8ElementID The value which will be set
     */
    inline void setU8ElementID (uint8 u8ElementID_);

    // API of field "e8Modulation"

    static const int kE8Modulation = 2;

    /**
     * Clears the field "e8Modulation".
     *
     * The field will be set to its default value. The hasE8Modulation()
     * method will return false.
     */
    inline void clearE8Modulation();

    /**
     * Checks whether the field "e8Modulation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Modulation()). Otherwise it will return false.
     */
    inline bool hasE8Modulation () const;

    /**
     * Returns the value of the member "e8Modulation".
     *
     * 0- AMFM, 1- HD, 2 - DRM
     *
     * @return The value of the field "e8Modulation"
     */
    inline T_e8_Tun_ModulationType getE8Modulation () const;

    /**
     * Sets the value of the member "e8Modulation".
     *
     * 0- AMFM, 1- HD, 2 - DRM
     *
     * @param e8Modulation The value which will be set
     */
    inline void setE8Modulation (T_e8_Tun_ModulationType e8Modulation_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 3;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     *
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     *
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    // API of field "u32SID"

    static const int kU32SID = 4;

    /**
     * Clears the field "u32SID".
     *
     * The field will be set to its default value. The hasU32SID()
     * method will return false.
     */
    inline void clearU32SID();

    /**
     * Checks whether the field "u32SID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SID()). Otherwise it will return false.
     */
    inline bool hasU32SID () const;

    /**
     * Returns the value of the member "u32SID".
     *
     * If ModulationType 0: RDS PI right oriented
     * If ModulationType 1: HDStationId
     * If ModulationType 2: DRMStationId
     *
     * @return The value of the field "u32SID"
     */
    inline uint32 getU32SID () const;

    /**
     * Sets the value of the member "u32SID".
     *
     * If ModulationType 0: RDS PI right oriented
     * If ModulationType 1: HDStationId
     * If ModulationType 2: DRMStationId
     *
     * @param u32SID The value which will be set
     */
    inline void setU32SID (uint32 u32SID_);

    // API of field "u8NumOfCharactersInStationName"

    static const int kU8NumOfCharactersInStationName = 5;

    /**
     * Clears the field "u8NumOfCharactersInStationName".
     *
     * The field will be set to its default value. The hasU8NumOfCharactersInStationName()
     * method will return false.
     */
    inline void clearU8NumOfCharactersInStationName();

    /**
     * Checks whether the field "u8NumOfCharactersInStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumOfCharactersInStationName()). Otherwise it will return false.
     */
    inline bool hasU8NumOfCharactersInStationName () const;

    /**
     * Returns the value of the member "u8NumOfCharactersInStationName".
     *
     *
     *
     * @return The value of the field "u8NumOfCharactersInStationName"
     */
    inline uint8 getU8NumOfCharactersInStationName () const;

    /**
     * Sets the value of the member "u8NumOfCharactersInStationName".
     *
     *
     *
     * @param u8NumOfCharactersInStationName The value which will be set
     */
    inline void setU8NumOfCharactersInStationName (uint8 u8NumOfCharactersInStationName_);

    // API of field "sStationName"

    static const int kSStationName = 6;

    /**
     * Clears the field "sStationName".
     *
     * The field will be set to its default value. The hasSStationName()
     * method will return false.
     */
    inline void clearSStationName();

    /**
     * Checks whether the field "sStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSStationName()). Otherwise it will return false.
     */
    inline bool hasSStationName () const;

    /**
     * Returns the value of the member "sStationName".
     *
     *
     *
     * @return The value of the field "sStationName"
     */
    inline const ::std::string& getSStationName () const;

    /**
     * Retrieves the value of the field "sStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sStationName".
     */
    inline ::std::string& getSStationNameMutable ();

    /**
     * Sets the value of the member "sStationName".
     *
     *
     *
     * @param sStationName The value which will be set
     */
    inline void setSStationName (const ::std::string& sStationName_);

    /**
     * Sets the value of the member "sStationName".
     *
     *
     *
     * @param sStationName The value which will be set
     */
    inline void setSStationName (const char* sStationName_);

    /**
     * Sets the value of the member "sStationName".
     *
     *
     *
     * @param sStationName The value which will be set
     */
    inline void setSStationName (const char* value, size_t size);

    /**
     * Release the object stored in the field "sStationName".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * @return The object stored in the field "sStationName"
     */
    inline ::std::string* releaseSStationName();

    /**
     * Replace the field "sStationName".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceSStationName (::std::string* sStationName_);

    // API of field "u8StationNameEncoding"

    static const int kU8StationNameEncoding = 7;

    /**
     * Clears the field "u8StationNameEncoding".
     *
     * The field will be set to its default value. The hasU8StationNameEncoding()
     * method will return false.
     */
    inline void clearU8StationNameEncoding();

    /**
     * Checks whether the field "u8StationNameEncoding" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StationNameEncoding()). Otherwise it will return false.
     */
    inline bool hasU8StationNameEncoding () const;

    /**
     * Returns the value of the member "u8StationNameEncoding".
     *
     *
     *
     * @return The value of the field "u8StationNameEncoding"
     */
    inline uint8 getU8StationNameEncoding () const;

    /**
     * Sets the value of the member "u8StationNameEncoding".
     *
     *
     *
     * @param u8StationNameEncoding The value which will be set
     */
    inline void setU8StationNameEncoding (uint8 u8StationNameEncoding_);

    // API of field "u8ProgramService"

    static const int kU8ProgramService = 8;

    /**
     * Clears the field "u8ProgramService".
     *
     * The field will be set to its default value. The hasU8ProgramService()
     * method will return false.
     */
    inline void clearU8ProgramService();

    /**
     * Checks whether the field "u8ProgramService" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ProgramService()). Otherwise it will return false.
     */
    inline bool hasU8ProgramService () const;

    /**
     * Returns the value of the member "u8ProgramService".
     *
     * Range : 0-7
     *
     * @return The value of the field "u8ProgramService"
     */
    inline uint8 getU8ProgramService () const;

    /**
     * Sets the value of the member "u8ProgramService".
     *
     * Range : 0-7
     *
     * @param u8ProgramService The value which will be set
     */
    inline void setU8ProgramService (uint8 u8ProgramService_);

    static const T_TunerListElement &getDefaultInstance();

private:

    inline void set_has_e8ListID ();

    inline void clear_has_e8ListID ();

    inline void set_has_u8ElementID ();

    inline void clear_has_u8ElementID ();

    inline void set_has_e8Modulation ();

    inline void clear_has_e8Modulation ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    inline void set_has_u32SID ();

    inline void clear_has_u32SID ();

    inline void set_has_u8NumOfCharactersInStationName ();

    inline void clear_has_u8NumOfCharactersInStationName ();

    inline void set_has_sStationName ();

    inline void clear_has_sStationName ();

    inline void set_has_u8StationNameEncoding ();

    inline void clear_has_u8StationNameEncoding ();

    inline void set_has_u8ProgramService ();

    inline void clear_has_u8ProgramService ();

    uint32 _has_bits_[ (9 + 31) / 32];

    T_e8_Tun_ListID _e8ListID;

    uint8 _u8ElementID;

    T_e8_Tun_ModulationType _e8Modulation;

    uint32 _u32Frequency;

    uint32 _u32SID;

    uint8 _u8NumOfCharactersInStationName;

    ::std::string* _sStationName;

    uint8 _u8StationNameEncoding;

    uint8 _u8ProgramService;

};

/**
 * .
 */
class T_b8_Tun_SwitchingFrequency {
public:

    /**
     * Default constructor
     */
    inline  T_b8_Tun_SwitchingFrequency ();

    /**
     * Copy constructor
     */
    inline  T_b8_Tun_SwitchingFrequency (const T_b8_Tun_SwitchingFrequency &c);

    /**
     * Field constructor
     */
    inline  T_b8_Tun_SwitchingFrequency (bool FREQUENCY_384kHz, bool FREQUENCY_432kHz);

    /**
     * Assignment operator
     */
    inline T_b8_Tun_SwitchingFrequency& operator = (const T_b8_Tun_SwitchingFrequency& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b8_Tun_SwitchingFrequency& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b8_Tun_SwitchingFrequency& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b8_Tun_SwitchingFrequency& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b8_Tun_SwitchingFrequency& rhs) const;

    /**
     * Sets the value of the member "FREQUENCY_384kHz".
     *
     * If the meaning of "FREQUENCY_384kHz" isn't clear, then there should be a description here.
     *
     * @param FREQUENCY_384kHz The value which will be set
     */
    inline void setFREQUENCY_384kHz (bool FREQUENCY_384kHz);

    /**
     * Returns the value of the member "FREQUENCY_384kHz".
     *
     * If the meaning of "FREQUENCY_384kHz" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FREQUENCY_384kHz"
     */
    inline bool getFREQUENCY_384kHz () const;

    /**
     * Sets the value of the member "FREQUENCY_432kHz".
     *
     * If the meaning of "FREQUENCY_432kHz" isn't clear, then there should be a description here.
     *
     * @param FREQUENCY_432kHz The value which will be set
     */
    inline void setFREQUENCY_432kHz (bool FREQUENCY_432kHz);

    /**
     * Returns the value of the member "FREQUENCY_432kHz".
     *
     * If the meaning of "FREQUENCY_432kHz" isn't clear, then there should be a description here.
     *
     * @return The value of the field "FREQUENCY_432kHz"
     */
    inline bool getFREQUENCY_432kHz () const;

    static const T_b8_Tun_SwitchingFrequency &getDefaultInstance();

private:

    bool _FREQUENCY_384kHz:1;

    bool _FREQUENCY_432kHz:1;

};

inline  T_b8_Tun_AFSwitch::T_b8_Tun_AFSwitch ()  :
    _RDS_AFBEST (false),
    _unused (false),
    _DRM_AFBEST (false)
{
}

inline  T_b8_Tun_AFSwitch::T_b8_Tun_AFSwitch (const T_b8_Tun_AFSwitch &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_AFSwitch::T_b8_Tun_AFSwitch (bool RDS_AFBEST, bool unused, bool DRM_AFBEST) :
    _RDS_AFBEST (RDS_AFBEST),
    _unused (unused),
    _DRM_AFBEST (DRM_AFBEST)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_AFSwitch& T_b8_Tun_AFSwitch::operator = (const T_b8_Tun_AFSwitch& rhs) {
    if( this != &rhs ) {
        _RDS_AFBEST = rhs._RDS_AFBEST;
        _unused = rhs._unused;
        _DRM_AFBEST = rhs._DRM_AFBEST;
    }
    return *this;
}

inline bool T_b8_Tun_AFSwitch::operator == (const T_b8_Tun_AFSwitch& rhs) const {
    return (_RDS_AFBEST == rhs._RDS_AFBEST &&
        _unused == rhs._unused &&
        _DRM_AFBEST == rhs._DRM_AFBEST);
}

inline bool T_b8_Tun_AFSwitch::operator != (const T_b8_Tun_AFSwitch& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_AFSwitch::operator < (const T_b8_Tun_AFSwitch& rhs) const {
    if (getRDS_AFBEST() < rhs.getRDS_AFBEST()) return true;
    if (getRDS_AFBEST() > rhs.getRDS_AFBEST()) return false;

    if (getUnused() < rhs.getUnused()) return true;
    if (getUnused() > rhs.getUnused()) return false;

    if (getDRM_AFBEST() < rhs.getDRM_AFBEST()) return true;
    if (getDRM_AFBEST() > rhs.getDRM_AFBEST()) return false;

    return false;
}

inline bool T_b8_Tun_AFSwitch::operator > (const T_b8_Tun_AFSwitch& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_AFSwitch::setRDS_AFBEST (bool RDS_AFBEST) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RDS_AFBEST = RDS_AFBEST;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AFSwitch::getRDS_AFBEST () const {
    return _RDS_AFBEST;
}

inline void T_b8_Tun_AFSwitch::setUnused (bool unused) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_unused = unused;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AFSwitch::getUnused () const {
    return _unused;
}

inline void T_b8_Tun_AFSwitch::setDRM_AFBEST (bool DRM_AFBEST) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DRM_AFBEST = DRM_AFBEST;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AFSwitch::getDRM_AFBEST () const {
    return _DRM_AFBEST;
}

inline  T_b8_Tun_AudioSink::T_b8_Tun_AudioSink ()  :
    _USR1_SWITCHED_TUN_TOFG (false),
    _TA_SWITCHED_TUN_TOFG (false),
    _TIM_SWITCHED_TUN_TOFG (false),
    _PTY_SWITCHED_TUN_TOFG (false),
    _NEWS_SWITCHED_TUN_TOFG (false),
    _DABTEMP_SWITCHED_TUN_TOFG (false),
    _TEMPFM_SWITCHED_TUN_TOFG (false),
    _RESERVED1 (false)
{
}

inline  T_b8_Tun_AudioSink::T_b8_Tun_AudioSink (const T_b8_Tun_AudioSink &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_AudioSink::T_b8_Tun_AudioSink (bool USR1_SWITCHED_TUN_TOFG, bool TA_SWITCHED_TUN_TOFG, bool TIM_SWITCHED_TUN_TOFG, bool PTY_SWITCHED_TUN_TOFG, bool NEWS_SWITCHED_TUN_TOFG, bool DABTEMP_SWITCHED_TUN_TOFG, bool TEMPFM_SWITCHED_TUN_TOFG, bool RESERVED1) :
    _USR1_SWITCHED_TUN_TOFG (USR1_SWITCHED_TUN_TOFG),
    _TA_SWITCHED_TUN_TOFG (TA_SWITCHED_TUN_TOFG),
    _TIM_SWITCHED_TUN_TOFG (TIM_SWITCHED_TUN_TOFG),
    _PTY_SWITCHED_TUN_TOFG (PTY_SWITCHED_TUN_TOFG),
    _NEWS_SWITCHED_TUN_TOFG (NEWS_SWITCHED_TUN_TOFG),
    _DABTEMP_SWITCHED_TUN_TOFG (DABTEMP_SWITCHED_TUN_TOFG),
    _TEMPFM_SWITCHED_TUN_TOFG (TEMPFM_SWITCHED_TUN_TOFG),
    _RESERVED1 (RESERVED1)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_AudioSink& T_b8_Tun_AudioSink::operator = (const T_b8_Tun_AudioSink& rhs) {
    if( this != &rhs ) {
        _USR1_SWITCHED_TUN_TOFG = rhs._USR1_SWITCHED_TUN_TOFG;
        _TA_SWITCHED_TUN_TOFG = rhs._TA_SWITCHED_TUN_TOFG;
        _TIM_SWITCHED_TUN_TOFG = rhs._TIM_SWITCHED_TUN_TOFG;
        _PTY_SWITCHED_TUN_TOFG = rhs._PTY_SWITCHED_TUN_TOFG;
        _NEWS_SWITCHED_TUN_TOFG = rhs._NEWS_SWITCHED_TUN_TOFG;
        _DABTEMP_SWITCHED_TUN_TOFG = rhs._DABTEMP_SWITCHED_TUN_TOFG;
        _TEMPFM_SWITCHED_TUN_TOFG = rhs._TEMPFM_SWITCHED_TUN_TOFG;
        _RESERVED1 = rhs._RESERVED1;
    }
    return *this;
}

inline bool T_b8_Tun_AudioSink::operator == (const T_b8_Tun_AudioSink& rhs) const {
    return (_USR1_SWITCHED_TUN_TOFG == rhs._USR1_SWITCHED_TUN_TOFG &&
        _TA_SWITCHED_TUN_TOFG == rhs._TA_SWITCHED_TUN_TOFG &&
        _TIM_SWITCHED_TUN_TOFG == rhs._TIM_SWITCHED_TUN_TOFG &&
        _PTY_SWITCHED_TUN_TOFG == rhs._PTY_SWITCHED_TUN_TOFG &&
        _NEWS_SWITCHED_TUN_TOFG == rhs._NEWS_SWITCHED_TUN_TOFG &&
        _DABTEMP_SWITCHED_TUN_TOFG == rhs._DABTEMP_SWITCHED_TUN_TOFG &&
        _TEMPFM_SWITCHED_TUN_TOFG == rhs._TEMPFM_SWITCHED_TUN_TOFG &&
        _RESERVED1 == rhs._RESERVED1);
}

inline bool T_b8_Tun_AudioSink::operator != (const T_b8_Tun_AudioSink& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_AudioSink::operator < (const T_b8_Tun_AudioSink& rhs) const {
    if (getUSR1_SWITCHED_TUN_TOFG() < rhs.getUSR1_SWITCHED_TUN_TOFG()) return true;
    if (getUSR1_SWITCHED_TUN_TOFG() > rhs.getUSR1_SWITCHED_TUN_TOFG()) return false;

    if (getTA_SWITCHED_TUN_TOFG() < rhs.getTA_SWITCHED_TUN_TOFG()) return true;
    if (getTA_SWITCHED_TUN_TOFG() > rhs.getTA_SWITCHED_TUN_TOFG()) return false;

    if (getTIM_SWITCHED_TUN_TOFG() < rhs.getTIM_SWITCHED_TUN_TOFG()) return true;
    if (getTIM_SWITCHED_TUN_TOFG() > rhs.getTIM_SWITCHED_TUN_TOFG()) return false;

    if (getPTY_SWITCHED_TUN_TOFG() < rhs.getPTY_SWITCHED_TUN_TOFG()) return true;
    if (getPTY_SWITCHED_TUN_TOFG() > rhs.getPTY_SWITCHED_TUN_TOFG()) return false;

    if (getNEWS_SWITCHED_TUN_TOFG() < rhs.getNEWS_SWITCHED_TUN_TOFG()) return true;
    if (getNEWS_SWITCHED_TUN_TOFG() > rhs.getNEWS_SWITCHED_TUN_TOFG()) return false;

    if (getDABTEMP_SWITCHED_TUN_TOFG() < rhs.getDABTEMP_SWITCHED_TUN_TOFG()) return true;
    if (getDABTEMP_SWITCHED_TUN_TOFG() > rhs.getDABTEMP_SWITCHED_TUN_TOFG()) return false;

    if (getTEMPFM_SWITCHED_TUN_TOFG() < rhs.getTEMPFM_SWITCHED_TUN_TOFG()) return true;
    if (getTEMPFM_SWITCHED_TUN_TOFG() > rhs.getTEMPFM_SWITCHED_TUN_TOFG()) return false;

    if (getRESERVED1() < rhs.getRESERVED1()) return true;
    if (getRESERVED1() > rhs.getRESERVED1()) return false;

    return false;
}

inline bool T_b8_Tun_AudioSink::operator > (const T_b8_Tun_AudioSink& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_AudioSink::setUSR1_SWITCHED_TUN_TOFG (bool USR1_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_USR1_SWITCHED_TUN_TOFG = USR1_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getUSR1_SWITCHED_TUN_TOFG () const {
    return _USR1_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setTA_SWITCHED_TUN_TOFG (bool TA_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TA_SWITCHED_TUN_TOFG = TA_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getTA_SWITCHED_TUN_TOFG () const {
    return _TA_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setTIM_SWITCHED_TUN_TOFG (bool TIM_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TIM_SWITCHED_TUN_TOFG = TIM_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getTIM_SWITCHED_TUN_TOFG () const {
    return _TIM_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setPTY_SWITCHED_TUN_TOFG (bool PTY_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_PTY_SWITCHED_TUN_TOFG = PTY_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getPTY_SWITCHED_TUN_TOFG () const {
    return _PTY_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setNEWS_SWITCHED_TUN_TOFG (bool NEWS_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_NEWS_SWITCHED_TUN_TOFG = NEWS_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getNEWS_SWITCHED_TUN_TOFG () const {
    return _NEWS_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setDABTEMP_SWITCHED_TUN_TOFG (bool DABTEMP_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DABTEMP_SWITCHED_TUN_TOFG = DABTEMP_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getDABTEMP_SWITCHED_TUN_TOFG () const {
    return _DABTEMP_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setTEMPFM_SWITCHED_TUN_TOFG (bool TEMPFM_SWITCHED_TUN_TOFG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TEMPFM_SWITCHED_TUN_TOFG = TEMPFM_SWITCHED_TUN_TOFG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getTEMPFM_SWITCHED_TUN_TOFG () const {
    return _TEMPFM_SWITCHED_TUN_TOFG;
}

inline void T_b8_Tun_AudioSink::setRESERVED1 (bool RESERVED1) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RESERVED1 = RESERVED1;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AudioSink::getRESERVED1 () const {
    return _RESERVED1;
}

inline  T_b8_Tun_AtStationInfoBits::T_b8_Tun_AtStationInfoBits ()  :
    _MONO_OR_STEREO_BIT (false),
    _SPEECH_OR_MUSIC_BIT (false),
    _RADIOTEXT_POSSIBLE_BIT (false),
    _ALTERNATE_FREQUENCY_BIT (false),
    _RADIOTEXT_AVAILABLE_BIT (false),
    _AF_AVAILABLE_BIT (false),
    _HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE (false),
    _MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL (false)
{
}

inline  T_b8_Tun_AtStationInfoBits::T_b8_Tun_AtStationInfoBits (const T_b8_Tun_AtStationInfoBits &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_AtStationInfoBits::T_b8_Tun_AtStationInfoBits (bool MONO_OR_STEREO_BIT, bool SPEECH_OR_MUSIC_BIT, bool RADIOTEXT_POSSIBLE_BIT, bool ALTERNATE_FREQUENCY_BIT, bool RADIOTEXT_AVAILABLE_BIT, bool AF_AVAILABLE_BIT, bool HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE, bool MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL) :
    _MONO_OR_STEREO_BIT (MONO_OR_STEREO_BIT),
    _SPEECH_OR_MUSIC_BIT (SPEECH_OR_MUSIC_BIT),
    _RADIOTEXT_POSSIBLE_BIT (RADIOTEXT_POSSIBLE_BIT),
    _ALTERNATE_FREQUENCY_BIT (ALTERNATE_FREQUENCY_BIT),
    _RADIOTEXT_AVAILABLE_BIT (RADIOTEXT_AVAILABLE_BIT),
    _AF_AVAILABLE_BIT (AF_AVAILABLE_BIT),
    _HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE (HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE),
    _MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL (MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_AtStationInfoBits& T_b8_Tun_AtStationInfoBits::operator = (const T_b8_Tun_AtStationInfoBits& rhs) {
    if( this != &rhs ) {
        _MONO_OR_STEREO_BIT = rhs._MONO_OR_STEREO_BIT;
        _SPEECH_OR_MUSIC_BIT = rhs._SPEECH_OR_MUSIC_BIT;
        _RADIOTEXT_POSSIBLE_BIT = rhs._RADIOTEXT_POSSIBLE_BIT;
        _ALTERNATE_FREQUENCY_BIT = rhs._ALTERNATE_FREQUENCY_BIT;
        _RADIOTEXT_AVAILABLE_BIT = rhs._RADIOTEXT_AVAILABLE_BIT;
        _AF_AVAILABLE_BIT = rhs._AF_AVAILABLE_BIT;
        _HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE = rhs._HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE;
        _MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL = rhs._MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL;
    }
    return *this;
}

inline bool T_b8_Tun_AtStationInfoBits::operator == (const T_b8_Tun_AtStationInfoBits& rhs) const {
    return (_MONO_OR_STEREO_BIT == rhs._MONO_OR_STEREO_BIT &&
        _SPEECH_OR_MUSIC_BIT == rhs._SPEECH_OR_MUSIC_BIT &&
        _RADIOTEXT_POSSIBLE_BIT == rhs._RADIOTEXT_POSSIBLE_BIT &&
        _ALTERNATE_FREQUENCY_BIT == rhs._ALTERNATE_FREQUENCY_BIT &&
        _RADIOTEXT_AVAILABLE_BIT == rhs._RADIOTEXT_AVAILABLE_BIT &&
        _AF_AVAILABLE_BIT == rhs._AF_AVAILABLE_BIT &&
        _HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE == rhs._HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE &&
        _MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL == rhs._MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL);
}

inline bool T_b8_Tun_AtStationInfoBits::operator != (const T_b8_Tun_AtStationInfoBits& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_AtStationInfoBits::operator < (const T_b8_Tun_AtStationInfoBits& rhs) const {
    if (getMONO_OR_STEREO_BIT() < rhs.getMONO_OR_STEREO_BIT()) return true;
    if (getMONO_OR_STEREO_BIT() > rhs.getMONO_OR_STEREO_BIT()) return false;

    if (getSPEECH_OR_MUSIC_BIT() < rhs.getSPEECH_OR_MUSIC_BIT()) return true;
    if (getSPEECH_OR_MUSIC_BIT() > rhs.getSPEECH_OR_MUSIC_BIT()) return false;

    if (getRADIOTEXT_POSSIBLE_BIT() < rhs.getRADIOTEXT_POSSIBLE_BIT()) return true;
    if (getRADIOTEXT_POSSIBLE_BIT() > rhs.getRADIOTEXT_POSSIBLE_BIT()) return false;

    if (getALTERNATE_FREQUENCY_BIT() < rhs.getALTERNATE_FREQUENCY_BIT()) return true;
    if (getALTERNATE_FREQUENCY_BIT() > rhs.getALTERNATE_FREQUENCY_BIT()) return false;

    if (getRADIOTEXT_AVAILABLE_BIT() < rhs.getRADIOTEXT_AVAILABLE_BIT()) return true;
    if (getRADIOTEXT_AVAILABLE_BIT() > rhs.getRADIOTEXT_AVAILABLE_BIT()) return false;

    if (getAF_AVAILABLE_BIT() < rhs.getAF_AVAILABLE_BIT()) return true;
    if (getAF_AVAILABLE_BIT() > rhs.getAF_AVAILABLE_BIT()) return false;

    if (getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE() < rhs.getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE()) return true;
    if (getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE() > rhs.getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE()) return false;

    if (getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL() < rhs.getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL()) return true;
    if (getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL() > rhs.getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL()) return false;

    return false;
}

inline bool T_b8_Tun_AtStationInfoBits::operator > (const T_b8_Tun_AtStationInfoBits& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_AtStationInfoBits::setMONO_OR_STEREO_BIT (bool MONO_OR_STEREO_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MONO_OR_STEREO_BIT = MONO_OR_STEREO_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getMONO_OR_STEREO_BIT () const {
    return _MONO_OR_STEREO_BIT;
}

inline void T_b8_Tun_AtStationInfoBits::setSPEECH_OR_MUSIC_BIT (bool SPEECH_OR_MUSIC_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_SPEECH_OR_MUSIC_BIT = SPEECH_OR_MUSIC_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getSPEECH_OR_MUSIC_BIT () const {
    return _SPEECH_OR_MUSIC_BIT;
}

inline void T_b8_Tun_AtStationInfoBits::setRADIOTEXT_POSSIBLE_BIT (bool RADIOTEXT_POSSIBLE_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RADIOTEXT_POSSIBLE_BIT = RADIOTEXT_POSSIBLE_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getRADIOTEXT_POSSIBLE_BIT () const {
    return _RADIOTEXT_POSSIBLE_BIT;
}

inline void T_b8_Tun_AtStationInfoBits::setALTERNATE_FREQUENCY_BIT (bool ALTERNATE_FREQUENCY_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_ALTERNATE_FREQUENCY_BIT = ALTERNATE_FREQUENCY_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getALTERNATE_FREQUENCY_BIT () const {
    return _ALTERNATE_FREQUENCY_BIT;
}

inline void T_b8_Tun_AtStationInfoBits::setRADIOTEXT_AVAILABLE_BIT (bool RADIOTEXT_AVAILABLE_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RADIOTEXT_AVAILABLE_BIT = RADIOTEXT_AVAILABLE_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getRADIOTEXT_AVAILABLE_BIT () const {
    return _RADIOTEXT_AVAILABLE_BIT;
}

inline void T_b8_Tun_AtStationInfoBits::setAF_AVAILABLE_BIT (bool AF_AVAILABLE_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AF_AVAILABLE_BIT = AF_AVAILABLE_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getAF_AVAILABLE_BIT () const {
    return _AF_AVAILABLE_BIT;
}

inline void T_b8_Tun_AtStationInfoBits::setHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE (bool HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE = HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getHD_STATION_DIGITAL_OR_ANALOGUE_SERVICE () const {
    return _HD_STATION_DIGITAL_OR_ANALOGUE_SERVICE;
}

inline void T_b8_Tun_AtStationInfoBits::setMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL (bool MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL = MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_AtStationInfoBits::getMONO_OR_STEREO_REPRODUCTION_OF_SIGNAL () const {
    return _MONO_OR_STEREO_REPRODUCTION_OF_SIGNAL;
}

inline  T_b8_Tun_Tunerbandbits::T_b8_Tun_Tunerbandbits ()  :
    _DDAMASTER_OR_NOT_A_DDAMASTER (false),
    _DDASLAVE_OR_NOT_A_DDASLAVE (false),
    _FM_SUPPORTED_OR_FM_NOTSUPPORTED (false),
    _AM_SUPPORTED_OR_AM_NOTSUPPORTED (false),
    _DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED (false),
    _DABL_SUPPORTED_OR_DABL_NOTSUPPORTED (false)
{
}

inline  T_b8_Tun_Tunerbandbits::T_b8_Tun_Tunerbandbits (const T_b8_Tun_Tunerbandbits &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_Tunerbandbits::T_b8_Tun_Tunerbandbits (bool DDAMASTER_OR_NOT_A_DDAMASTER, bool DDASLAVE_OR_NOT_A_DDASLAVE, bool FM_SUPPORTED_OR_FM_NOTSUPPORTED, bool AM_SUPPORTED_OR_AM_NOTSUPPORTED, bool DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED, bool DABL_SUPPORTED_OR_DABL_NOTSUPPORTED) :
    _DDAMASTER_OR_NOT_A_DDAMASTER (DDAMASTER_OR_NOT_A_DDAMASTER),
    _DDASLAVE_OR_NOT_A_DDASLAVE (DDASLAVE_OR_NOT_A_DDASLAVE),
    _FM_SUPPORTED_OR_FM_NOTSUPPORTED (FM_SUPPORTED_OR_FM_NOTSUPPORTED),
    _AM_SUPPORTED_OR_AM_NOTSUPPORTED (AM_SUPPORTED_OR_AM_NOTSUPPORTED),
    _DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED (DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED),
    _DABL_SUPPORTED_OR_DABL_NOTSUPPORTED (DABL_SUPPORTED_OR_DABL_NOTSUPPORTED)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_Tunerbandbits& T_b8_Tun_Tunerbandbits::operator = (const T_b8_Tun_Tunerbandbits& rhs) {
    if( this != &rhs ) {
        _DDAMASTER_OR_NOT_A_DDAMASTER = rhs._DDAMASTER_OR_NOT_A_DDAMASTER;
        _DDASLAVE_OR_NOT_A_DDASLAVE = rhs._DDASLAVE_OR_NOT_A_DDASLAVE;
        _FM_SUPPORTED_OR_FM_NOTSUPPORTED = rhs._FM_SUPPORTED_OR_FM_NOTSUPPORTED;
        _AM_SUPPORTED_OR_AM_NOTSUPPORTED = rhs._AM_SUPPORTED_OR_AM_NOTSUPPORTED;
        _DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED = rhs._DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED;
        _DABL_SUPPORTED_OR_DABL_NOTSUPPORTED = rhs._DABL_SUPPORTED_OR_DABL_NOTSUPPORTED;
    }
    return *this;
}

inline bool T_b8_Tun_Tunerbandbits::operator == (const T_b8_Tun_Tunerbandbits& rhs) const {
    return (_DDAMASTER_OR_NOT_A_DDAMASTER == rhs._DDAMASTER_OR_NOT_A_DDAMASTER &&
        _DDASLAVE_OR_NOT_A_DDASLAVE == rhs._DDASLAVE_OR_NOT_A_DDASLAVE &&
        _FM_SUPPORTED_OR_FM_NOTSUPPORTED == rhs._FM_SUPPORTED_OR_FM_NOTSUPPORTED &&
        _AM_SUPPORTED_OR_AM_NOTSUPPORTED == rhs._AM_SUPPORTED_OR_AM_NOTSUPPORTED &&
        _DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED == rhs._DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED &&
        _DABL_SUPPORTED_OR_DABL_NOTSUPPORTED == rhs._DABL_SUPPORTED_OR_DABL_NOTSUPPORTED);
}

inline bool T_b8_Tun_Tunerbandbits::operator != (const T_b8_Tun_Tunerbandbits& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_Tunerbandbits::operator < (const T_b8_Tun_Tunerbandbits& rhs) const {
    if (getDDAMASTER_OR_NOT_A_DDAMASTER() < rhs.getDDAMASTER_OR_NOT_A_DDAMASTER()) return true;
    if (getDDAMASTER_OR_NOT_A_DDAMASTER() > rhs.getDDAMASTER_OR_NOT_A_DDAMASTER()) return false;

    if (getDDASLAVE_OR_NOT_A_DDASLAVE() < rhs.getDDASLAVE_OR_NOT_A_DDASLAVE()) return true;
    if (getDDASLAVE_OR_NOT_A_DDASLAVE() > rhs.getDDASLAVE_OR_NOT_A_DDASLAVE()) return false;

    if (getFM_SUPPORTED_OR_FM_NOTSUPPORTED() < rhs.getFM_SUPPORTED_OR_FM_NOTSUPPORTED()) return true;
    if (getFM_SUPPORTED_OR_FM_NOTSUPPORTED() > rhs.getFM_SUPPORTED_OR_FM_NOTSUPPORTED()) return false;

    if (getAM_SUPPORTED_OR_AM_NOTSUPPORTED() < rhs.getAM_SUPPORTED_OR_AM_NOTSUPPORTED()) return true;
    if (getAM_SUPPORTED_OR_AM_NOTSUPPORTED() > rhs.getAM_SUPPORTED_OR_AM_NOTSUPPORTED()) return false;

    if (getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED() < rhs.getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED()) return true;
    if (getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED() > rhs.getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED()) return false;

    if (getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED() < rhs.getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED()) return true;
    if (getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED() > rhs.getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED()) return false;

    return false;
}

inline bool T_b8_Tun_Tunerbandbits::operator > (const T_b8_Tun_Tunerbandbits& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_Tunerbandbits::setDDAMASTER_OR_NOT_A_DDAMASTER (bool DDAMASTER_OR_NOT_A_DDAMASTER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DDAMASTER_OR_NOT_A_DDAMASTER = DDAMASTER_OR_NOT_A_DDAMASTER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Tunerbandbits::getDDAMASTER_OR_NOT_A_DDAMASTER () const {
    return _DDAMASTER_OR_NOT_A_DDAMASTER;
}

inline void T_b8_Tun_Tunerbandbits::setDDASLAVE_OR_NOT_A_DDASLAVE (bool DDASLAVE_OR_NOT_A_DDASLAVE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DDASLAVE_OR_NOT_A_DDASLAVE = DDASLAVE_OR_NOT_A_DDASLAVE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Tunerbandbits::getDDASLAVE_OR_NOT_A_DDASLAVE () const {
    return _DDASLAVE_OR_NOT_A_DDASLAVE;
}

inline void T_b8_Tun_Tunerbandbits::setFM_SUPPORTED_OR_FM_NOTSUPPORTED (bool FM_SUPPORTED_OR_FM_NOTSUPPORTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_FM_SUPPORTED_OR_FM_NOTSUPPORTED = FM_SUPPORTED_OR_FM_NOTSUPPORTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Tunerbandbits::getFM_SUPPORTED_OR_FM_NOTSUPPORTED () const {
    return _FM_SUPPORTED_OR_FM_NOTSUPPORTED;
}

inline void T_b8_Tun_Tunerbandbits::setAM_SUPPORTED_OR_AM_NOTSUPPORTED (bool AM_SUPPORTED_OR_AM_NOTSUPPORTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_AM_SUPPORTED_OR_AM_NOTSUPPORTED = AM_SUPPORTED_OR_AM_NOTSUPPORTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Tunerbandbits::getAM_SUPPORTED_OR_AM_NOTSUPPORTED () const {
    return _AM_SUPPORTED_OR_AM_NOTSUPPORTED;
}

inline void T_b8_Tun_Tunerbandbits::setDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED (bool DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED = DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Tunerbandbits::getDAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED () const {
    return _DAB3_SUPPORTED_OR_DAB3_NOTSUPPORTED;
}

inline void T_b8_Tun_Tunerbandbits::setDABL_SUPPORTED_OR_DABL_NOTSUPPORTED (bool DABL_SUPPORTED_OR_DABL_NOTSUPPORTED) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_DABL_SUPPORTED_OR_DABL_NOTSUPPORTED = DABL_SUPPORTED_OR_DABL_NOTSUPPORTED;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Tunerbandbits::getDABL_SUPPORTED_OR_DABL_NOTSUPPORTED () const {
    return _DABL_SUPPORTED_OR_DABL_NOTSUPPORTED;
}

inline  T_Audio_FG_BG::T_Audio_FG_BG ()  :
    _u8SubCommand (::midw_tuner_fi_types::T_e8_Tun_SubCommand__TUN_CHANGE_TO_FG),
    _u8AudioSink (::midw_tuner_fi_types::T_e8_Tun_AudioSink__TUN_USR1_CHANGE_TO_FG_BG)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Audio_FG_BG::T_Audio_FG_BG (const T_Audio_FG_BG &rhs)  :
    _u8SubCommand (::midw_tuner_fi_types::T_e8_Tun_SubCommand__TUN_CHANGE_TO_FG),
    _u8AudioSink (::midw_tuner_fi_types::T_e8_Tun_AudioSink__TUN_USR1_CHANGE_TO_FG_BG)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Audio_FG_BG::T_Audio_FG_BG (T_e8_Tun_SubCommand u8SubCommand_, T_e8_Tun_AudioSink u8AudioSink_)  :
    _u8SubCommand (u8SubCommand_),
    _u8AudioSink (u8AudioSink_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_SubCommand_IsValid(u8SubCommand_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8SubCommand_, "T_e8_Tun_SubCommand", "u8SubCommand", "T_Audio_FG_BG");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AudioSink_IsValid(u8AudioSink_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AudioSink_, "T_e8_Tun_AudioSink", "u8AudioSink", "T_Audio_FG_BG");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Audio_FG_BG::~T_Audio_FG_BG() {
}

inline T_Audio_FG_BG& T_Audio_FG_BG::operator = (const T_Audio_FG_BG& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8SubCommand()) {
            setU8SubCommand(rhs.getU8SubCommand());
        } else {
            clearU8SubCommand();
        }
        if (rhs.hasU8AudioSink()) {
            setU8AudioSink(rhs.getU8AudioSink());
        } else {
            clearU8AudioSink();
        }
    }
    return *this;
}

inline bool T_Audio_FG_BG::operator == (const T_Audio_FG_BG& rhs) const {
    return (((!hasU8SubCommand() && !rhs.hasU8SubCommand()) || getU8SubCommand() == rhs.getU8SubCommand()) &&
        ((!hasU8AudioSink() && !rhs.hasU8AudioSink()) || getU8AudioSink() == rhs.getU8AudioSink()));
}

inline bool T_Audio_FG_BG::operator != (const T_Audio_FG_BG& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Audio_FG_BG::operator < (const T_Audio_FG_BG& rhs) const {
    if (hasU8SubCommand() || rhs.hasU8SubCommand()) {
        if ((uint32)getU8SubCommand() < (uint32)rhs.getU8SubCommand()) return true;
        if ((uint32)getU8SubCommand() > (uint32)rhs.getU8SubCommand()) return false;
    }
    if (hasU8AudioSink() || rhs.hasU8AudioSink()) {
        if ((uint32)getU8AudioSink() < (uint32)rhs.getU8AudioSink()) return true;
        if ((uint32)getU8AudioSink() > (uint32)rhs.getU8AudioSink()) return false;
    }
    return false;
}

inline bool T_Audio_FG_BG::operator > (const T_Audio_FG_BG& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Audio_FG_BG::clear() {
    clearU8SubCommand();
    clearU8AudioSink();
}

inline void T_Audio_FG_BG::clearU8SubCommand() {
    if (hasU8SubCommand()) {
         clear_has_u8SubCommand();
        _u8SubCommand = ::midw_tuner_fi_types::T_e8_Tun_SubCommand__TUN_CHANGE_TO_FG;
     }
}

inline bool T_Audio_FG_BG::hasU8SubCommand () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_SubCommand T_Audio_FG_BG::getU8SubCommand () const {
    return _u8SubCommand;
}

inline void T_Audio_FG_BG::setU8SubCommand (T_e8_Tun_SubCommand u8SubCommand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_SubCommand_IsValid(u8SubCommand_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8SubCommand_, "T_e8_Tun_SubCommand", "u8SubCommand", "T_Audio_FG_BG");
    }
    set_has_u8SubCommand();
    this->_u8SubCommand = u8SubCommand_;
}

inline void T_Audio_FG_BG::clearU8AudioSink() {
    if (hasU8AudioSink()) {
         clear_has_u8AudioSink();
        _u8AudioSink = ::midw_tuner_fi_types::T_e8_Tun_AudioSink__TUN_USR1_CHANGE_TO_FG_BG;
     }
}

inline bool T_Audio_FG_BG::hasU8AudioSink () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Tun_AudioSink T_Audio_FG_BG::getU8AudioSink () const {
    return _u8AudioSink;
}

inline void T_Audio_FG_BG::setU8AudioSink (T_e8_Tun_AudioSink u8AudioSink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AudioSink_IsValid(u8AudioSink_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AudioSink_, "T_e8_Tun_AudioSink", "u8AudioSink", "T_Audio_FG_BG");
    }
    set_has_u8AudioSink();
    this->_u8AudioSink = u8AudioSink_;
}

inline void T_Audio_FG_BG::set_has_u8SubCommand () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Audio_FG_BG::clear_has_u8SubCommand () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Audio_FG_BG::set_has_u8AudioSink () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Audio_FG_BG::clear_has_u8AudioSink () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_u16CalibrationData::T_u16CalibrationData ()  :
    _u8DataLength (0u),
    _CalibrationValues (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_u16CalibrationData::T_u16CalibrationData (const T_u16CalibrationData &rhs)  :
    _u8DataLength (0u),
    _CalibrationValues (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_u16CalibrationData::T_u16CalibrationData (uint8 u8DataLength_, const ::std::vector< uint16 >& CalibrationValues_)  :
    _u8DataLength (u8DataLength_),
    _CalibrationValues (new ::std::vector< uint16 >(CalibrationValues_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_u16CalibrationData::~T_u16CalibrationData() {
    delete _CalibrationValues;
}

inline T_u16CalibrationData& T_u16CalibrationData::operator = (const T_u16CalibrationData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8DataLength()) {
            setU8DataLength(rhs.getU8DataLength());
        } else {
            clearU8DataLength();
        }
        if (rhs.hasCalibrationValues()) {
            setCalibrationValues(rhs.getCalibrationValues());
        } else {
            clearCalibrationValues();
        }
    }
    return *this;
}

inline bool T_u16CalibrationData::operator == (const T_u16CalibrationData& rhs) const {
    return (((!hasU8DataLength() && !rhs.hasU8DataLength()) || getU8DataLength() == rhs.getU8DataLength()) &&
        ((!hasCalibrationValues() && !rhs.hasCalibrationValues()) || getCalibrationValues() == rhs.getCalibrationValues()));
}

inline bool T_u16CalibrationData::operator != (const T_u16CalibrationData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_u16CalibrationData::operator < (const T_u16CalibrationData& rhs) const {
    if (hasU8DataLength() || rhs.hasU8DataLength()) {
        if (getU8DataLength() < rhs.getU8DataLength()) return true;
        if (getU8DataLength() > rhs.getU8DataLength()) return false;
    }
    if (hasCalibrationValues() || rhs.hasCalibrationValues()) {
        if (getCalibrationValues() < rhs.getCalibrationValues()) return true;
        if (getCalibrationValues() > rhs.getCalibrationValues()) return false;
    }
    return false;
}

inline bool T_u16CalibrationData::operator > (const T_u16CalibrationData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_u16CalibrationData::clear() {
    clearU8DataLength();
    clearCalibrationValues();
}

inline void T_u16CalibrationData::clearU8DataLength() {
    if (hasU8DataLength()) {
         clear_has_u8DataLength();
        _u8DataLength = 0u;
     }
}

inline bool T_u16CalibrationData::hasU8DataLength () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_u16CalibrationData::getU8DataLength () const {
    return _u8DataLength;
}

inline void T_u16CalibrationData::setU8DataLength (uint8 u8DataLength_) {
    set_has_u8DataLength();
    this->_u8DataLength = u8DataLength_;
}

inline void T_u16CalibrationData::clearCalibrationValues() {
    if (hasCalibrationValues()) {
         clear_has_CalibrationValues();
        if (_CalibrationValues != NULL) {
            _CalibrationValues->clear();
        }
     }
}

inline bool T_u16CalibrationData::hasCalibrationValues () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint16 >& T_u16CalibrationData::getCalibrationValues () const {
    if (_CalibrationValues == NULL) {
        return getUint16List_DefaultInstance();
    }
    return *_CalibrationValues;
}

inline ::std::vector< uint16 >& T_u16CalibrationData::getCalibrationValuesMutable () {
    set_has_CalibrationValues();
    if (_CalibrationValues == NULL) {
        _CalibrationValues = new ::std::vector< uint16 > ();
        CHECK_ALLOCATION( _CalibrationValues );
    }
    return *_CalibrationValues;
}

inline void T_u16CalibrationData::setCalibrationValues (const ::std::vector< uint16 >& CalibrationValues_) {
    set_has_CalibrationValues();
    if (this->_CalibrationValues == NULL) {
        this->_CalibrationValues = new ::std::vector< uint16 > (CalibrationValues_);
        CHECK_ALLOCATION( this->_CalibrationValues );
    } else {
        *this->_CalibrationValues = CalibrationValues_;
    }
}

inline ::std::vector< uint16 >* T_u16CalibrationData::releaseCalibrationValues() {
    clear_has_CalibrationValues();
    ::std::vector< uint16 >* temp = _CalibrationValues;
    this->_CalibrationValues = NULL;
    return temp;
}

inline void T_u16CalibrationData::replaceCalibrationValues (::std::vector< uint16 >* CalibrationValues_) {
    set_has_CalibrationValues();
    if (this->_CalibrationValues != CalibrationValues_) {
        if (this->_CalibrationValues != NULL) {
            delete this->_CalibrationValues;
        }
        this->_CalibrationValues = CalibrationValues_;
    }
}

inline void T_u16CalibrationData::set_has_u8DataLength () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_u16CalibrationData::clear_has_u8DataLength () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_u16CalibrationData::set_has_CalibrationValues () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_u16CalibrationData::clear_has_CalibrationValues () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_Aud_FGBG_New::T_Aud_FGBG_New ()  :
    _u8_TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8SubCommand (::midw_tuner_fi_types::T_e8_Tun_SubCommand__TUN_CHANGE_TO_FG),
    _u8AudioSink (::midw_tuner_fi_types::T_e8_Tun_AudioSink__TUN_USR1_CHANGE_TO_FG_BG),
    _bTunerState (false),
    _u8_PhysicalTuner (::midw_tuner_fi_types::T_e8_Tun_PhysicalTuner__TUNER_0),
    _e8Band (::midw_tuner_fi_types::T_e8_Tun_TunerBand__TUN_BAND_FM),
    _e8MTCAudioSource (::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource__TUN_LastAudioSource)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Aud_FGBG_New::T_Aud_FGBG_New (const T_Aud_FGBG_New &rhs)  :
    _u8_TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8SubCommand (::midw_tuner_fi_types::T_e8_Tun_SubCommand__TUN_CHANGE_TO_FG),
    _u8AudioSink (::midw_tuner_fi_types::T_e8_Tun_AudioSink__TUN_USR1_CHANGE_TO_FG_BG),
    _bTunerState (false),
    _u8_PhysicalTuner (::midw_tuner_fi_types::T_e8_Tun_PhysicalTuner__TUNER_0),
    _e8Band (::midw_tuner_fi_types::T_e8_Tun_TunerBand__TUN_BAND_FM),
    _e8MTCAudioSource (::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource__TUN_LastAudioSource)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Aud_FGBG_New::T_Aud_FGBG_New (T_e8_Tun_TunerHeader u8_TunerHeader_, T_e8_Tun_SubCommand u8SubCommand_, T_e8_Tun_AudioSink u8AudioSink_, bool bTunerState_, T_e8_Tun_PhysicalTuner u8_PhysicalTuner_, T_e8_Tun_TunerBand e8Band_, T_e8_Tun_MTCAudioSource e8MTCAudioSource_)  :
    _u8_TunerHeader (u8_TunerHeader_),
    _u8SubCommand (u8SubCommand_),
    _u8AudioSink (u8AudioSink_),
    _bTunerState (bTunerState_),
    _u8_PhysicalTuner (u8_PhysicalTuner_),
    _e8Band (e8Band_),
    _e8MTCAudioSource (e8MTCAudioSource_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8_TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8_TunerHeader_, "T_e8_Tun_TunerHeader", "u8_TunerHeader", "T_Aud_FGBG_New");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_SubCommand_IsValid(u8SubCommand_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8SubCommand_, "T_e8_Tun_SubCommand", "u8SubCommand", "T_Aud_FGBG_New");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AudioSink_IsValid(u8AudioSink_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AudioSink_, "T_e8_Tun_AudioSink", "u8AudioSink", "T_Aud_FGBG_New");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_PhysicalTuner_IsValid(u8_PhysicalTuner_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8_PhysicalTuner_, "T_e8_Tun_PhysicalTuner", "u8_PhysicalTuner", "T_Aud_FGBG_New");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerBand_IsValid(e8Band_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Band_, "T_e8_Tun_TunerBand", "e8Band", "T_Aud_FGBG_New");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_MTCAudioSource_IsValid(e8MTCAudioSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MTCAudioSource_, "T_e8_Tun_MTCAudioSource", "e8MTCAudioSource", "T_Aud_FGBG_New");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Aud_FGBG_New::~T_Aud_FGBG_New() {
}

inline T_Aud_FGBG_New& T_Aud_FGBG_New::operator = (const T_Aud_FGBG_New& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8_TunerHeader()) {
            setU8_TunerHeader(rhs.getU8_TunerHeader());
        } else {
            clearU8_TunerHeader();
        }
        if (rhs.hasU8SubCommand()) {
            setU8SubCommand(rhs.getU8SubCommand());
        } else {
            clearU8SubCommand();
        }
        if (rhs.hasU8AudioSink()) {
            setU8AudioSink(rhs.getU8AudioSink());
        } else {
            clearU8AudioSink();
        }
        if (rhs.hasBTunerState()) {
            setBTunerState(rhs.getBTunerState());
        } else {
            clearBTunerState();
        }
        if (rhs.hasU8_PhysicalTuner()) {
            setU8_PhysicalTuner(rhs.getU8_PhysicalTuner());
        } else {
            clearU8_PhysicalTuner();
        }
        if (rhs.hasE8Band()) {
            setE8Band(rhs.getE8Band());
        } else {
            clearE8Band();
        }
        if (rhs.hasE8MTCAudioSource()) {
            setE8MTCAudioSource(rhs.getE8MTCAudioSource());
        } else {
            clearE8MTCAudioSource();
        }
    }
    return *this;
}

inline bool T_Aud_FGBG_New::operator == (const T_Aud_FGBG_New& rhs) const {
    return (((!hasU8_TunerHeader() && !rhs.hasU8_TunerHeader()) || getU8_TunerHeader() == rhs.getU8_TunerHeader()) &&
        ((!hasU8SubCommand() && !rhs.hasU8SubCommand()) || getU8SubCommand() == rhs.getU8SubCommand()) &&
        ((!hasU8AudioSink() && !rhs.hasU8AudioSink()) || getU8AudioSink() == rhs.getU8AudioSink()) &&
        ((!hasBTunerState() && !rhs.hasBTunerState()) || getBTunerState() == rhs.getBTunerState()) &&
        ((!hasU8_PhysicalTuner() && !rhs.hasU8_PhysicalTuner()) || getU8_PhysicalTuner() == rhs.getU8_PhysicalTuner()) &&
        ((!hasE8Band() && !rhs.hasE8Band()) || getE8Band() == rhs.getE8Band()) &&
        ((!hasE8MTCAudioSource() && !rhs.hasE8MTCAudioSource()) || getE8MTCAudioSource() == rhs.getE8MTCAudioSource()));
}

inline bool T_Aud_FGBG_New::operator != (const T_Aud_FGBG_New& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Aud_FGBG_New::operator < (const T_Aud_FGBG_New& rhs) const {
    if (hasU8_TunerHeader() || rhs.hasU8_TunerHeader()) {
        if ((uint32)getU8_TunerHeader() < (uint32)rhs.getU8_TunerHeader()) return true;
        if ((uint32)getU8_TunerHeader() > (uint32)rhs.getU8_TunerHeader()) return false;
    }
    if (hasU8SubCommand() || rhs.hasU8SubCommand()) {
        if ((uint32)getU8SubCommand() < (uint32)rhs.getU8SubCommand()) return true;
        if ((uint32)getU8SubCommand() > (uint32)rhs.getU8SubCommand()) return false;
    }
    if (hasU8AudioSink() || rhs.hasU8AudioSink()) {
        if ((uint32)getU8AudioSink() < (uint32)rhs.getU8AudioSink()) return true;
        if ((uint32)getU8AudioSink() > (uint32)rhs.getU8AudioSink()) return false;
    }
    if (hasBTunerState() || rhs.hasBTunerState()) {
        if (getBTunerState() < rhs.getBTunerState()) return true;
        if (getBTunerState() > rhs.getBTunerState()) return false;
    }
    if (hasU8_PhysicalTuner() || rhs.hasU8_PhysicalTuner()) {
        if ((uint32)getU8_PhysicalTuner() < (uint32)rhs.getU8_PhysicalTuner()) return true;
        if ((uint32)getU8_PhysicalTuner() > (uint32)rhs.getU8_PhysicalTuner()) return false;
    }
    if (hasE8Band() || rhs.hasE8Band()) {
        if ((uint32)getE8Band() < (uint32)rhs.getE8Band()) return true;
        if ((uint32)getE8Band() > (uint32)rhs.getE8Band()) return false;
    }
    if (hasE8MTCAudioSource() || rhs.hasE8MTCAudioSource()) {
        if ((uint32)getE8MTCAudioSource() < (uint32)rhs.getE8MTCAudioSource()) return true;
        if ((uint32)getE8MTCAudioSource() > (uint32)rhs.getE8MTCAudioSource()) return false;
    }
    return false;
}

inline bool T_Aud_FGBG_New::operator > (const T_Aud_FGBG_New& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Aud_FGBG_New::clear() {
    clearU8_TunerHeader();
    clearU8SubCommand();
    clearU8AudioSink();
    clearBTunerState();
    clearU8_PhysicalTuner();
    clearE8Band();
    clearE8MTCAudioSource();
}

inline void T_Aud_FGBG_New::clearU8_TunerHeader() {
    if (hasU8_TunerHeader()) {
         clear_has_u8_TunerHeader();
        _u8_TunerHeader = ::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool T_Aud_FGBG_New::hasU8_TunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_TunerHeader T_Aud_FGBG_New::getU8_TunerHeader () const {
    return _u8_TunerHeader;
}

inline void T_Aud_FGBG_New::setU8_TunerHeader (T_e8_Tun_TunerHeader u8_TunerHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8_TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8_TunerHeader_, "T_e8_Tun_TunerHeader", "u8_TunerHeader", "T_Aud_FGBG_New");
    }
    set_has_u8_TunerHeader();
    this->_u8_TunerHeader = u8_TunerHeader_;
}

inline void T_Aud_FGBG_New::clearU8SubCommand() {
    if (hasU8SubCommand()) {
         clear_has_u8SubCommand();
        _u8SubCommand = ::midw_tuner_fi_types::T_e8_Tun_SubCommand__TUN_CHANGE_TO_FG;
     }
}

inline bool T_Aud_FGBG_New::hasU8SubCommand () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Tun_SubCommand T_Aud_FGBG_New::getU8SubCommand () const {
    return _u8SubCommand;
}

inline void T_Aud_FGBG_New::setU8SubCommand (T_e8_Tun_SubCommand u8SubCommand_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_SubCommand_IsValid(u8SubCommand_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8SubCommand_, "T_e8_Tun_SubCommand", "u8SubCommand", "T_Aud_FGBG_New");
    }
    set_has_u8SubCommand();
    this->_u8SubCommand = u8SubCommand_;
}

inline void T_Aud_FGBG_New::clearU8AudioSink() {
    if (hasU8AudioSink()) {
         clear_has_u8AudioSink();
        _u8AudioSink = ::midw_tuner_fi_types::T_e8_Tun_AudioSink__TUN_USR1_CHANGE_TO_FG_BG;
     }
}

inline bool T_Aud_FGBG_New::hasU8AudioSink () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_Tun_AudioSink T_Aud_FGBG_New::getU8AudioSink () const {
    return _u8AudioSink;
}

inline void T_Aud_FGBG_New::setU8AudioSink (T_e8_Tun_AudioSink u8AudioSink_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AudioSink_IsValid(u8AudioSink_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AudioSink_, "T_e8_Tun_AudioSink", "u8AudioSink", "T_Aud_FGBG_New");
    }
    set_has_u8AudioSink();
    this->_u8AudioSink = u8AudioSink_;
}

inline void T_Aud_FGBG_New::clearBTunerState() {
    if (hasBTunerState()) {
         clear_has_bTunerState();
        _bTunerState = false;
     }
}

inline bool T_Aud_FGBG_New::hasBTunerState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool T_Aud_FGBG_New::getBTunerState () const {
    return _bTunerState;
}

inline void T_Aud_FGBG_New::setBTunerState (bool bTunerState_) {
    set_has_bTunerState();
    this->_bTunerState = bTunerState_;
}

inline void T_Aud_FGBG_New::clearU8_PhysicalTuner() {
    if (hasU8_PhysicalTuner()) {
         clear_has_u8_PhysicalTuner();
        _u8_PhysicalTuner = ::midw_tuner_fi_types::T_e8_Tun_PhysicalTuner__TUNER_0;
     }
}

inline bool T_Aud_FGBG_New::hasU8_PhysicalTuner () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline T_e8_Tun_PhysicalTuner T_Aud_FGBG_New::getU8_PhysicalTuner () const {
    return _u8_PhysicalTuner;
}

inline void T_Aud_FGBG_New::setU8_PhysicalTuner (T_e8_Tun_PhysicalTuner u8_PhysicalTuner_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_PhysicalTuner_IsValid(u8_PhysicalTuner_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8_PhysicalTuner_, "T_e8_Tun_PhysicalTuner", "u8_PhysicalTuner", "T_Aud_FGBG_New");
    }
    set_has_u8_PhysicalTuner();
    this->_u8_PhysicalTuner = u8_PhysicalTuner_;
}

inline void T_Aud_FGBG_New::clearE8Band() {
    if (hasE8Band()) {
         clear_has_e8Band();
        _e8Band = ::midw_tuner_fi_types::T_e8_Tun_TunerBand__TUN_BAND_FM;
     }
}

inline bool T_Aud_FGBG_New::hasE8Band () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_Tun_TunerBand T_Aud_FGBG_New::getE8Band () const {
    return _e8Band;
}

inline void T_Aud_FGBG_New::setE8Band (T_e8_Tun_TunerBand e8Band_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerBand_IsValid(e8Band_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Band_, "T_e8_Tun_TunerBand", "e8Band", "T_Aud_FGBG_New");
    }
    set_has_e8Band();
    this->_e8Band = e8Band_;
}

inline void T_Aud_FGBG_New::clearE8MTCAudioSource() {
    if (hasE8MTCAudioSource()) {
         clear_has_e8MTCAudioSource();
        _e8MTCAudioSource = ::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource__TUN_LastAudioSource;
     }
}

inline bool T_Aud_FGBG_New::hasE8MTCAudioSource () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_Tun_MTCAudioSource T_Aud_FGBG_New::getE8MTCAudioSource () const {
    return _e8MTCAudioSource;
}

inline void T_Aud_FGBG_New::setE8MTCAudioSource (T_e8_Tun_MTCAudioSource e8MTCAudioSource_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_MTCAudioSource_IsValid(e8MTCAudioSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MTCAudioSource_, "T_e8_Tun_MTCAudioSource", "e8MTCAudioSource", "T_Aud_FGBG_New");
    }
    set_has_e8MTCAudioSource();
    this->_e8MTCAudioSource = e8MTCAudioSource_;
}

inline void T_Aud_FGBG_New::set_has_u8_TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Aud_FGBG_New::clear_has_u8_TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Aud_FGBG_New::set_has_u8SubCommand () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Aud_FGBG_New::clear_has_u8SubCommand () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_Aud_FGBG_New::set_has_u8AudioSink () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_Aud_FGBG_New::clear_has_u8AudioSink () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_Aud_FGBG_New::set_has_bTunerState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_Aud_FGBG_New::clear_has_bTunerState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_Aud_FGBG_New::set_has_u8_PhysicalTuner () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_Aud_FGBG_New::clear_has_u8_PhysicalTuner () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_Aud_FGBG_New::set_has_e8Band () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_Aud_FGBG_New::clear_has_e8Band () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_Aud_FGBG_New::set_has_e8MTCAudioSource () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_Aud_FGBG_New::clear_has_e8MTCAudioSource () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_AudFGBGStatus::T_AudFGBGStatus ()  :
    _u8_TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8AudioSink (NULL),
    _e8MTCAudioSource (::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource__TUN_LastAudioSource)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_AudFGBGStatus::T_AudFGBGStatus (const T_AudFGBGStatus &rhs)  :
    _u8_TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8AudioSink (NULL),
    _e8MTCAudioSource (::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource__TUN_LastAudioSource)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_AudFGBGStatus::T_AudFGBGStatus (T_e8_Tun_TunerHeader u8_TunerHeader_, const T_b8_Tun_AudioSink& u8AudioSink_, T_e8_Tun_MTCAudioSource e8MTCAudioSource_)  :
    _u8_TunerHeader (u8_TunerHeader_),
    _u8AudioSink (new T_b8_Tun_AudioSink(u8AudioSink_)),
    _e8MTCAudioSource (e8MTCAudioSource_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8_TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8_TunerHeader_, "T_e8_Tun_TunerHeader", "u8_TunerHeader", "T_AudFGBGStatus");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_MTCAudioSource_IsValid(e8MTCAudioSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MTCAudioSource_, "T_e8_Tun_MTCAudioSource", "e8MTCAudioSource", "T_AudFGBGStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_AudFGBGStatus::~T_AudFGBGStatus() {
    delete _u8AudioSink;
}

inline T_AudFGBGStatus& T_AudFGBGStatus::operator = (const T_AudFGBGStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8_TunerHeader()) {
            setU8_TunerHeader(rhs.getU8_TunerHeader());
        } else {
            clearU8_TunerHeader();
        }
        if (rhs.hasU8AudioSink()) {
            setU8AudioSink(rhs.getU8AudioSink());
        } else {
            clearU8AudioSink();
        }
        if (rhs.hasE8MTCAudioSource()) {
            setE8MTCAudioSource(rhs.getE8MTCAudioSource());
        } else {
            clearE8MTCAudioSource();
        }
    }
    return *this;
}

inline bool T_AudFGBGStatus::operator == (const T_AudFGBGStatus& rhs) const {
    return (((!hasU8_TunerHeader() && !rhs.hasU8_TunerHeader()) || getU8_TunerHeader() == rhs.getU8_TunerHeader()) &&
        ((!hasU8AudioSink() && !rhs.hasU8AudioSink()) || getU8AudioSink() == rhs.getU8AudioSink()) &&
        ((!hasE8MTCAudioSource() && !rhs.hasE8MTCAudioSource()) || getE8MTCAudioSource() == rhs.getE8MTCAudioSource()));
}

inline bool T_AudFGBGStatus::operator != (const T_AudFGBGStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_AudFGBGStatus::operator < (const T_AudFGBGStatus& rhs) const {
    if (hasU8_TunerHeader() || rhs.hasU8_TunerHeader()) {
        if ((uint32)getU8_TunerHeader() < (uint32)rhs.getU8_TunerHeader()) return true;
        if ((uint32)getU8_TunerHeader() > (uint32)rhs.getU8_TunerHeader()) return false;
    }
    if (hasU8AudioSink() || rhs.hasU8AudioSink()) {
        if (getU8AudioSink() < rhs.getU8AudioSink()) return true;
        if (getU8AudioSink() > rhs.getU8AudioSink()) return false;
    }
    if (hasE8MTCAudioSource() || rhs.hasE8MTCAudioSource()) {
        if ((uint32)getE8MTCAudioSource() < (uint32)rhs.getE8MTCAudioSource()) return true;
        if ((uint32)getE8MTCAudioSource() > (uint32)rhs.getE8MTCAudioSource()) return false;
    }
    return false;
}

inline bool T_AudFGBGStatus::operator > (const T_AudFGBGStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_AudFGBGStatus::clear() {
    clearU8_TunerHeader();
    clearU8AudioSink();
    clearE8MTCAudioSource();
}

inline void T_AudFGBGStatus::clearU8_TunerHeader() {
    if (hasU8_TunerHeader()) {
         clear_has_u8_TunerHeader();
        _u8_TunerHeader = ::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool T_AudFGBGStatus::hasU8_TunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_TunerHeader T_AudFGBGStatus::getU8_TunerHeader () const {
    return _u8_TunerHeader;
}

inline void T_AudFGBGStatus::setU8_TunerHeader (T_e8_Tun_TunerHeader u8_TunerHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8_TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8_TunerHeader_, "T_e8_Tun_TunerHeader", "u8_TunerHeader", "T_AudFGBGStatus");
    }
    set_has_u8_TunerHeader();
    this->_u8_TunerHeader = u8_TunerHeader_;
}

inline void T_AudFGBGStatus::clearU8AudioSink() {
    if (hasU8AudioSink()) {
         clear_has_u8AudioSink();
        delete _u8AudioSink;
        _u8AudioSink = NULL;
     }
}

inline bool T_AudFGBGStatus::hasU8AudioSink () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_b8_Tun_AudioSink& T_AudFGBGStatus::getU8AudioSink () const {
    if (_u8AudioSink == NULL) {
        return T_b8_Tun_AudioSink::getDefaultInstance();
    }
    return *_u8AudioSink;
}

inline T_b8_Tun_AudioSink& T_AudFGBGStatus::getU8AudioSinkMutable () {
    set_has_u8AudioSink();
    if (_u8AudioSink == NULL) {
        _u8AudioSink = new T_b8_Tun_AudioSink ();
        CHECK_ALLOCATION( _u8AudioSink );
    }
    return *_u8AudioSink;
}

inline void T_AudFGBGStatus::setU8AudioSink (const T_b8_Tun_AudioSink& u8AudioSink_) {
    set_has_u8AudioSink();
    if (this->_u8AudioSink == NULL) {
        this->_u8AudioSink = new T_b8_Tun_AudioSink (u8AudioSink_);
        CHECK_ALLOCATION( this->_u8AudioSink );
    } else {
        *this->_u8AudioSink = u8AudioSink_;
    }
}

inline T_b8_Tun_AudioSink* T_AudFGBGStatus::releaseU8AudioSink() {
    clear_has_u8AudioSink();
    T_b8_Tun_AudioSink* temp = _u8AudioSink;
    this->_u8AudioSink = NULL;
    return temp;
}

inline void T_AudFGBGStatus::replaceU8AudioSink (T_b8_Tun_AudioSink* u8AudioSink_) {
    set_has_u8AudioSink();
    if (this->_u8AudioSink != u8AudioSink_) {
        if (this->_u8AudioSink != NULL) {
            delete this->_u8AudioSink;
        }
        this->_u8AudioSink = u8AudioSink_;
    }
}

inline void T_AudFGBGStatus::clearE8MTCAudioSource() {
    if (hasE8MTCAudioSource()) {
         clear_has_e8MTCAudioSource();
        _e8MTCAudioSource = ::midw_tuner_fi_types::T_e8_Tun_MTCAudioSource__TUN_LastAudioSource;
     }
}

inline bool T_AudFGBGStatus::hasE8MTCAudioSource () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_Tun_MTCAudioSource T_AudFGBGStatus::getE8MTCAudioSource () const {
    return _e8MTCAudioSource;
}

inline void T_AudFGBGStatus::setE8MTCAudioSource (T_e8_Tun_MTCAudioSource e8MTCAudioSource_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_MTCAudioSource_IsValid(e8MTCAudioSource_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MTCAudioSource_, "T_e8_Tun_MTCAudioSource", "e8MTCAudioSource", "T_AudFGBGStatus");
    }
    set_has_e8MTCAudioSource();
    this->_e8MTCAudioSource = e8MTCAudioSource_;
}

inline void T_AudFGBGStatus::set_has_u8_TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_AudFGBGStatus::clear_has_u8_TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_AudFGBGStatus::set_has_u8AudioSink () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_AudFGBGStatus::clear_has_u8AudioSink () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_AudFGBGStatus::set_has_e8MTCAudioSource () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_AudFGBGStatus::clear_has_e8MTCAudioSource () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_TunerServer_StatusResponse::T_TunerServer_StatusResponse ()  :
    _u8TunerStatus (::midw_tuner_fi_types::T_e8_Tun_ResponseStatus__TUN_RES_REQ_SUCCEED),
    _u8TunerState (::midw_tuner_fi_types::T_e8_Tun_ResponseState__TUN_TUN_STATE_NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerServer_StatusResponse::T_TunerServer_StatusResponse (const T_TunerServer_StatusResponse &rhs)  :
    _u8TunerStatus (::midw_tuner_fi_types::T_e8_Tun_ResponseStatus__TUN_RES_REQ_SUCCEED),
    _u8TunerState (::midw_tuner_fi_types::T_e8_Tun_ResponseState__TUN_TUN_STATE_NORMAL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerServer_StatusResponse::T_TunerServer_StatusResponse (T_e8_Tun_ResponseStatus u8TunerStatus_, T_e8_Tun_ResponseState u8TunerState_)  :
    _u8TunerStatus (u8TunerStatus_),
    _u8TunerState (u8TunerState_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ResponseStatus_IsValid(u8TunerStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerStatus_, "T_e8_Tun_ResponseStatus", "u8TunerStatus", "T_TunerServer_StatusResponse");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ResponseState_IsValid(u8TunerState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerState_, "T_e8_Tun_ResponseState", "u8TunerState", "T_TunerServer_StatusResponse");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerServer_StatusResponse::~T_TunerServer_StatusResponse() {
}

inline T_TunerServer_StatusResponse& T_TunerServer_StatusResponse::operator = (const T_TunerServer_StatusResponse& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TunerStatus()) {
            setU8TunerStatus(rhs.getU8TunerStatus());
        } else {
            clearU8TunerStatus();
        }
        if (rhs.hasU8TunerState()) {
            setU8TunerState(rhs.getU8TunerState());
        } else {
            clearU8TunerState();
        }
    }
    return *this;
}

inline bool T_TunerServer_StatusResponse::operator == (const T_TunerServer_StatusResponse& rhs) const {
    return (((!hasU8TunerStatus() && !rhs.hasU8TunerStatus()) || getU8TunerStatus() == rhs.getU8TunerStatus()) &&
        ((!hasU8TunerState() && !rhs.hasU8TunerState()) || getU8TunerState() == rhs.getU8TunerState()));
}

inline bool T_TunerServer_StatusResponse::operator != (const T_TunerServer_StatusResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerServer_StatusResponse::operator < (const T_TunerServer_StatusResponse& rhs) const {
    if (hasU8TunerStatus() || rhs.hasU8TunerStatus()) {
        if ((uint32)getU8TunerStatus() < (uint32)rhs.getU8TunerStatus()) return true;
        if ((uint32)getU8TunerStatus() > (uint32)rhs.getU8TunerStatus()) return false;
    }
    if (hasU8TunerState() || rhs.hasU8TunerState()) {
        if ((uint32)getU8TunerState() < (uint32)rhs.getU8TunerState()) return true;
        if ((uint32)getU8TunerState() > (uint32)rhs.getU8TunerState()) return false;
    }
    return false;
}

inline bool T_TunerServer_StatusResponse::operator > (const T_TunerServer_StatusResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerServer_StatusResponse::clear() {
    clearU8TunerStatus();
    clearU8TunerState();
}

inline void T_TunerServer_StatusResponse::clearU8TunerStatus() {
    if (hasU8TunerStatus()) {
         clear_has_u8TunerStatus();
        _u8TunerStatus = ::midw_tuner_fi_types::T_e8_Tun_ResponseStatus__TUN_RES_REQ_SUCCEED;
     }
}

inline bool T_TunerServer_StatusResponse::hasU8TunerStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_ResponseStatus T_TunerServer_StatusResponse::getU8TunerStatus () const {
    return _u8TunerStatus;
}

inline void T_TunerServer_StatusResponse::setU8TunerStatus (T_e8_Tun_ResponseStatus u8TunerStatus_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ResponseStatus_IsValid(u8TunerStatus_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerStatus_, "T_e8_Tun_ResponseStatus", "u8TunerStatus", "T_TunerServer_StatusResponse");
    }
    set_has_u8TunerStatus();
    this->_u8TunerStatus = u8TunerStatus_;
}

inline void T_TunerServer_StatusResponse::clearU8TunerState() {
    if (hasU8TunerState()) {
         clear_has_u8TunerState();
        _u8TunerState = ::midw_tuner_fi_types::T_e8_Tun_ResponseState__TUN_TUN_STATE_NORMAL;
     }
}

inline bool T_TunerServer_StatusResponse::hasU8TunerState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Tun_ResponseState T_TunerServer_StatusResponse::getU8TunerState () const {
    return _u8TunerState;
}

inline void T_TunerServer_StatusResponse::setU8TunerState (T_e8_Tun_ResponseState u8TunerState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ResponseState_IsValid(u8TunerState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerState_, "T_e8_Tun_ResponseState", "u8TunerState", "T_TunerServer_StatusResponse");
    }
    set_has_u8TunerState();
    this->_u8TunerState = u8TunerState_;
}

inline void T_TunerServer_StatusResponse::set_has_u8TunerStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerServer_StatusResponse::clear_has_u8TunerStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerServer_StatusResponse::set_has_u8TunerState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerServer_StatusResponse::clear_has_u8TunerState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b32_Tun_AvailFlags::T_b32_Tun_AvailFlags ()  :
    _TUN_FRQ_AVAILABLE (false),
    _TUN_PS_AVAILABLE (false),
    _TUN_PI_AVAILABLE (false),
    _TUN_PTY_AVAILABLE (false),
    _TUN_CT_AVAILABLE (false),
    _TUN_TMC_AVAILABLE (false),
    _TUN_RDS_AVAILABLE (false),
    _TUN_REG_AVAILABLE (false),
    _TUN_AF_AVAILABLE (false),
    _TUN_PTY_EON_AVAILABLE (false),
    _TUN_RT_AVAILABLE (false),
    _TUN_JAPAN_PS_AVAILABLE (false),
    _TUN_AUTO_COMPARE_AVAILABLE (false)
{
}

inline  T_b32_Tun_AvailFlags::T_b32_Tun_AvailFlags (const T_b32_Tun_AvailFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_Tun_AvailFlags::T_b32_Tun_AvailFlags (bool TUN_FRQ_AVAILABLE, bool TUN_PS_AVAILABLE, bool TUN_PI_AVAILABLE, bool TUN_PTY_AVAILABLE, bool TUN_CT_AVAILABLE, bool TUN_TMC_AVAILABLE, bool TUN_RDS_AVAILABLE, bool TUN_REG_AVAILABLE, bool TUN_AF_AVAILABLE, bool TUN_PTY_EON_AVAILABLE, bool TUN_RT_AVAILABLE, bool TUN_JAPAN_PS_AVAILABLE, bool TUN_AUTO_COMPARE_AVAILABLE) :
    _TUN_FRQ_AVAILABLE (TUN_FRQ_AVAILABLE),
    _TUN_PS_AVAILABLE (TUN_PS_AVAILABLE),
    _TUN_PI_AVAILABLE (TUN_PI_AVAILABLE),
    _TUN_PTY_AVAILABLE (TUN_PTY_AVAILABLE),
    _TUN_CT_AVAILABLE (TUN_CT_AVAILABLE),
    _TUN_TMC_AVAILABLE (TUN_TMC_AVAILABLE),
    _TUN_RDS_AVAILABLE (TUN_RDS_AVAILABLE),
    _TUN_REG_AVAILABLE (TUN_REG_AVAILABLE),
    _TUN_AF_AVAILABLE (TUN_AF_AVAILABLE),
    _TUN_PTY_EON_AVAILABLE (TUN_PTY_EON_AVAILABLE),
    _TUN_RT_AVAILABLE (TUN_RT_AVAILABLE),
    _TUN_JAPAN_PS_AVAILABLE (TUN_JAPAN_PS_AVAILABLE),
    _TUN_AUTO_COMPARE_AVAILABLE (TUN_AUTO_COMPARE_AVAILABLE)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_Tun_AvailFlags& T_b32_Tun_AvailFlags::operator = (const T_b32_Tun_AvailFlags& rhs) {
    if( this != &rhs ) {
        _TUN_FRQ_AVAILABLE = rhs._TUN_FRQ_AVAILABLE;
        _TUN_PS_AVAILABLE = rhs._TUN_PS_AVAILABLE;
        _TUN_PI_AVAILABLE = rhs._TUN_PI_AVAILABLE;
        _TUN_PTY_AVAILABLE = rhs._TUN_PTY_AVAILABLE;
        _TUN_CT_AVAILABLE = rhs._TUN_CT_AVAILABLE;
        _TUN_TMC_AVAILABLE = rhs._TUN_TMC_AVAILABLE;
        _TUN_RDS_AVAILABLE = rhs._TUN_RDS_AVAILABLE;
        _TUN_REG_AVAILABLE = rhs._TUN_REG_AVAILABLE;
        _TUN_AF_AVAILABLE = rhs._TUN_AF_AVAILABLE;
        _TUN_PTY_EON_AVAILABLE = rhs._TUN_PTY_EON_AVAILABLE;
        _TUN_RT_AVAILABLE = rhs._TUN_RT_AVAILABLE;
        _TUN_JAPAN_PS_AVAILABLE = rhs._TUN_JAPAN_PS_AVAILABLE;
        _TUN_AUTO_COMPARE_AVAILABLE = rhs._TUN_AUTO_COMPARE_AVAILABLE;
    }
    return *this;
}

inline bool T_b32_Tun_AvailFlags::operator == (const T_b32_Tun_AvailFlags& rhs) const {
    return (_TUN_FRQ_AVAILABLE == rhs._TUN_FRQ_AVAILABLE &&
        _TUN_PS_AVAILABLE == rhs._TUN_PS_AVAILABLE &&
        _TUN_PI_AVAILABLE == rhs._TUN_PI_AVAILABLE &&
        _TUN_PTY_AVAILABLE == rhs._TUN_PTY_AVAILABLE &&
        _TUN_CT_AVAILABLE == rhs._TUN_CT_AVAILABLE &&
        _TUN_TMC_AVAILABLE == rhs._TUN_TMC_AVAILABLE &&
        _TUN_RDS_AVAILABLE == rhs._TUN_RDS_AVAILABLE &&
        _TUN_REG_AVAILABLE == rhs._TUN_REG_AVAILABLE &&
        _TUN_AF_AVAILABLE == rhs._TUN_AF_AVAILABLE &&
        _TUN_PTY_EON_AVAILABLE == rhs._TUN_PTY_EON_AVAILABLE &&
        _TUN_RT_AVAILABLE == rhs._TUN_RT_AVAILABLE &&
        _TUN_JAPAN_PS_AVAILABLE == rhs._TUN_JAPAN_PS_AVAILABLE &&
        _TUN_AUTO_COMPARE_AVAILABLE == rhs._TUN_AUTO_COMPARE_AVAILABLE);
}

inline bool T_b32_Tun_AvailFlags::operator != (const T_b32_Tun_AvailFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_Tun_AvailFlags::operator < (const T_b32_Tun_AvailFlags& rhs) const {
    if (getTUN_FRQ_AVAILABLE() < rhs.getTUN_FRQ_AVAILABLE()) return true;
    if (getTUN_FRQ_AVAILABLE() > rhs.getTUN_FRQ_AVAILABLE()) return false;

    if (getTUN_PS_AVAILABLE() < rhs.getTUN_PS_AVAILABLE()) return true;
    if (getTUN_PS_AVAILABLE() > rhs.getTUN_PS_AVAILABLE()) return false;

    if (getTUN_PI_AVAILABLE() < rhs.getTUN_PI_AVAILABLE()) return true;
    if (getTUN_PI_AVAILABLE() > rhs.getTUN_PI_AVAILABLE()) return false;

    if (getTUN_PTY_AVAILABLE() < rhs.getTUN_PTY_AVAILABLE()) return true;
    if (getTUN_PTY_AVAILABLE() > rhs.getTUN_PTY_AVAILABLE()) return false;

    if (getTUN_CT_AVAILABLE() < rhs.getTUN_CT_AVAILABLE()) return true;
    if (getTUN_CT_AVAILABLE() > rhs.getTUN_CT_AVAILABLE()) return false;

    if (getTUN_TMC_AVAILABLE() < rhs.getTUN_TMC_AVAILABLE()) return true;
    if (getTUN_TMC_AVAILABLE() > rhs.getTUN_TMC_AVAILABLE()) return false;

    if (getTUN_RDS_AVAILABLE() < rhs.getTUN_RDS_AVAILABLE()) return true;
    if (getTUN_RDS_AVAILABLE() > rhs.getTUN_RDS_AVAILABLE()) return false;

    if (getTUN_REG_AVAILABLE() < rhs.getTUN_REG_AVAILABLE()) return true;
    if (getTUN_REG_AVAILABLE() > rhs.getTUN_REG_AVAILABLE()) return false;

    if (getTUN_AF_AVAILABLE() < rhs.getTUN_AF_AVAILABLE()) return true;
    if (getTUN_AF_AVAILABLE() > rhs.getTUN_AF_AVAILABLE()) return false;

    if (getTUN_PTY_EON_AVAILABLE() < rhs.getTUN_PTY_EON_AVAILABLE()) return true;
    if (getTUN_PTY_EON_AVAILABLE() > rhs.getTUN_PTY_EON_AVAILABLE()) return false;

    if (getTUN_RT_AVAILABLE() < rhs.getTUN_RT_AVAILABLE()) return true;
    if (getTUN_RT_AVAILABLE() > rhs.getTUN_RT_AVAILABLE()) return false;

    if (getTUN_JAPAN_PS_AVAILABLE() < rhs.getTUN_JAPAN_PS_AVAILABLE()) return true;
    if (getTUN_JAPAN_PS_AVAILABLE() > rhs.getTUN_JAPAN_PS_AVAILABLE()) return false;

    if (getTUN_AUTO_COMPARE_AVAILABLE() < rhs.getTUN_AUTO_COMPARE_AVAILABLE()) return true;
    if (getTUN_AUTO_COMPARE_AVAILABLE() > rhs.getTUN_AUTO_COMPARE_AVAILABLE()) return false;

    return false;
}

inline bool T_b32_Tun_AvailFlags::operator > (const T_b32_Tun_AvailFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_Tun_AvailFlags::setTUN_FRQ_AVAILABLE (bool TUN_FRQ_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FRQ_AVAILABLE = TUN_FRQ_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_FRQ_AVAILABLE () const {
    return _TUN_FRQ_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_PS_AVAILABLE (bool TUN_PS_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_PS_AVAILABLE = TUN_PS_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_PS_AVAILABLE () const {
    return _TUN_PS_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_PI_AVAILABLE (bool TUN_PI_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_PI_AVAILABLE = TUN_PI_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_PI_AVAILABLE () const {
    return _TUN_PI_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_PTY_AVAILABLE (bool TUN_PTY_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_PTY_AVAILABLE = TUN_PTY_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_PTY_AVAILABLE () const {
    return _TUN_PTY_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_CT_AVAILABLE (bool TUN_CT_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_CT_AVAILABLE = TUN_CT_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_CT_AVAILABLE () const {
    return _TUN_CT_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_TMC_AVAILABLE (bool TUN_TMC_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_TMC_AVAILABLE = TUN_TMC_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_TMC_AVAILABLE () const {
    return _TUN_TMC_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_RDS_AVAILABLE (bool TUN_RDS_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_RDS_AVAILABLE = TUN_RDS_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_RDS_AVAILABLE () const {
    return _TUN_RDS_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_REG_AVAILABLE (bool TUN_REG_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_REG_AVAILABLE = TUN_REG_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_REG_AVAILABLE () const {
    return _TUN_REG_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_AF_AVAILABLE (bool TUN_AF_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_AF_AVAILABLE = TUN_AF_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_AF_AVAILABLE () const {
    return _TUN_AF_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_PTY_EON_AVAILABLE (bool TUN_PTY_EON_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_PTY_EON_AVAILABLE = TUN_PTY_EON_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_PTY_EON_AVAILABLE () const {
    return _TUN_PTY_EON_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_RT_AVAILABLE (bool TUN_RT_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_RT_AVAILABLE = TUN_RT_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_RT_AVAILABLE () const {
    return _TUN_RT_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_JAPAN_PS_AVAILABLE (bool TUN_JAPAN_PS_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_JAPAN_PS_AVAILABLE = TUN_JAPAN_PS_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_JAPAN_PS_AVAILABLE () const {
    return _TUN_JAPAN_PS_AVAILABLE;
}

inline void T_b32_Tun_AvailFlags::setTUN_AUTO_COMPARE_AVAILABLE (bool TUN_AUTO_COMPARE_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_AUTO_COMPARE_AVAILABLE = TUN_AUTO_COMPARE_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailFlags::getTUN_AUTO_COMPARE_AVAILABLE () const {
    return _TUN_AUTO_COMPARE_AVAILABLE;
}

inline  T_b32_Tun_Features::T_b32_Tun_Features ()  :
    _TUN_FEATURE_AF_MODE (false),
    _TUN_FEATURE_CT_MODE (false),
    _TUN_FEATURE_LOC_MODE (false),
    _TUN_FEATURE_unused (false),
    _TUN_FEATURE_MONO_MODE (false),
    _TUN_FEATURE_PSFIX_MODE (false),
    _TUN_FEATURE_REG_MODE (false),
    _TUN_FEATURE_RT_MODE (false),
    _TUN_FEATURE_SEARCH_MODE (false),
    _TUN_FEATURE_SEEK_SENSE_MODE (false),
    _TUN_FEATURE_SHARX_MODE (false),
    _TUN_FEATURE_TM_DATA_MODE (false),
    _TUN_FEATURE_TMC_MODE (false),
    _TUN_FEATURE_KHZ50_MODE (false),
    _TUN_FEATURE_REG_AUTO_MODE (false),
    _TUN_FEATURE_NEWS_MODE (false),
    _TUN_FEATURE_RDS_AUTO_MODE (false),
    _TUN_FEATURE_DDA_MODE (false),
    _TUN_FEATURE_DDS_MODE (false),
    _TUN_FEATURE_reserved (false),
    _TUN_FEATURE_MEASURE_MODE (false),
    _TUN_FEATURE_AMFMSETUP_MODE (false),
    _TUN_FEATURE_PERSISTENTSTORAGE_MODE (false)
{
}

inline  T_b32_Tun_Features::T_b32_Tun_Features (const T_b32_Tun_Features &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_Tun_Features::T_b32_Tun_Features (bool TUN_FEATURE_AF_MODE, bool TUN_FEATURE_CT_MODE, bool TUN_FEATURE_LOC_MODE, bool TUN_FEATURE_unused, bool TUN_FEATURE_MONO_MODE, bool TUN_FEATURE_PSFIX_MODE, bool TUN_FEATURE_REG_MODE, bool TUN_FEATURE_RT_MODE, bool TUN_FEATURE_SEARCH_MODE, bool TUN_FEATURE_SEEK_SENSE_MODE, bool TUN_FEATURE_SHARX_MODE, bool TUN_FEATURE_TM_DATA_MODE, bool TUN_FEATURE_TMC_MODE, bool TUN_FEATURE_KHZ50_MODE, bool TUN_FEATURE_REG_AUTO_MODE, bool TUN_FEATURE_NEWS_MODE, bool TUN_FEATURE_RDS_AUTO_MODE, bool TUN_FEATURE_DDA_MODE, bool TUN_FEATURE_DDS_MODE, bool TUN_FEATURE_reserved, bool TUN_FEATURE_MEASURE_MODE, bool TUN_FEATURE_AMFMSETUP_MODE, bool TUN_FEATURE_PERSISTENTSTORAGE_MODE) :
    _TUN_FEATURE_AF_MODE (TUN_FEATURE_AF_MODE),
    _TUN_FEATURE_CT_MODE (TUN_FEATURE_CT_MODE),
    _TUN_FEATURE_LOC_MODE (TUN_FEATURE_LOC_MODE),
    _TUN_FEATURE_unused (TUN_FEATURE_unused),
    _TUN_FEATURE_MONO_MODE (TUN_FEATURE_MONO_MODE),
    _TUN_FEATURE_PSFIX_MODE (TUN_FEATURE_PSFIX_MODE),
    _TUN_FEATURE_REG_MODE (TUN_FEATURE_REG_MODE),
    _TUN_FEATURE_RT_MODE (TUN_FEATURE_RT_MODE),
    _TUN_FEATURE_SEARCH_MODE (TUN_FEATURE_SEARCH_MODE),
    _TUN_FEATURE_SEEK_SENSE_MODE (TUN_FEATURE_SEEK_SENSE_MODE),
    _TUN_FEATURE_SHARX_MODE (TUN_FEATURE_SHARX_MODE),
    _TUN_FEATURE_TM_DATA_MODE (TUN_FEATURE_TM_DATA_MODE),
    _TUN_FEATURE_TMC_MODE (TUN_FEATURE_TMC_MODE),
    _TUN_FEATURE_KHZ50_MODE (TUN_FEATURE_KHZ50_MODE),
    _TUN_FEATURE_REG_AUTO_MODE (TUN_FEATURE_REG_AUTO_MODE),
    _TUN_FEATURE_NEWS_MODE (TUN_FEATURE_NEWS_MODE),
    _TUN_FEATURE_RDS_AUTO_MODE (TUN_FEATURE_RDS_AUTO_MODE),
    _TUN_FEATURE_DDA_MODE (TUN_FEATURE_DDA_MODE),
    _TUN_FEATURE_DDS_MODE (TUN_FEATURE_DDS_MODE),
    _TUN_FEATURE_reserved (TUN_FEATURE_reserved),
    _TUN_FEATURE_MEASURE_MODE (TUN_FEATURE_MEASURE_MODE),
    _TUN_FEATURE_AMFMSETUP_MODE (TUN_FEATURE_AMFMSETUP_MODE),
    _TUN_FEATURE_PERSISTENTSTORAGE_MODE (TUN_FEATURE_PERSISTENTSTORAGE_MODE)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_Tun_Features& T_b32_Tun_Features::operator = (const T_b32_Tun_Features& rhs) {
    if( this != &rhs ) {
        _TUN_FEATURE_AF_MODE = rhs._TUN_FEATURE_AF_MODE;
        _TUN_FEATURE_CT_MODE = rhs._TUN_FEATURE_CT_MODE;
        _TUN_FEATURE_LOC_MODE = rhs._TUN_FEATURE_LOC_MODE;
        _TUN_FEATURE_unused = rhs._TUN_FEATURE_unused;
        _TUN_FEATURE_MONO_MODE = rhs._TUN_FEATURE_MONO_MODE;
        _TUN_FEATURE_PSFIX_MODE = rhs._TUN_FEATURE_PSFIX_MODE;
        _TUN_FEATURE_REG_MODE = rhs._TUN_FEATURE_REG_MODE;
        _TUN_FEATURE_RT_MODE = rhs._TUN_FEATURE_RT_MODE;
        _TUN_FEATURE_SEARCH_MODE = rhs._TUN_FEATURE_SEARCH_MODE;
        _TUN_FEATURE_SEEK_SENSE_MODE = rhs._TUN_FEATURE_SEEK_SENSE_MODE;
        _TUN_FEATURE_SHARX_MODE = rhs._TUN_FEATURE_SHARX_MODE;
        _TUN_FEATURE_TM_DATA_MODE = rhs._TUN_FEATURE_TM_DATA_MODE;
        _TUN_FEATURE_TMC_MODE = rhs._TUN_FEATURE_TMC_MODE;
        _TUN_FEATURE_KHZ50_MODE = rhs._TUN_FEATURE_KHZ50_MODE;
        _TUN_FEATURE_REG_AUTO_MODE = rhs._TUN_FEATURE_REG_AUTO_MODE;
        _TUN_FEATURE_NEWS_MODE = rhs._TUN_FEATURE_NEWS_MODE;
        _TUN_FEATURE_RDS_AUTO_MODE = rhs._TUN_FEATURE_RDS_AUTO_MODE;
        _TUN_FEATURE_DDA_MODE = rhs._TUN_FEATURE_DDA_MODE;
        _TUN_FEATURE_DDS_MODE = rhs._TUN_FEATURE_DDS_MODE;
        _TUN_FEATURE_reserved = rhs._TUN_FEATURE_reserved;
        _TUN_FEATURE_MEASURE_MODE = rhs._TUN_FEATURE_MEASURE_MODE;
        _TUN_FEATURE_AMFMSETUP_MODE = rhs._TUN_FEATURE_AMFMSETUP_MODE;
        _TUN_FEATURE_PERSISTENTSTORAGE_MODE = rhs._TUN_FEATURE_PERSISTENTSTORAGE_MODE;
    }
    return *this;
}

inline bool T_b32_Tun_Features::operator == (const T_b32_Tun_Features& rhs) const {
    return (_TUN_FEATURE_AF_MODE == rhs._TUN_FEATURE_AF_MODE &&
        _TUN_FEATURE_CT_MODE == rhs._TUN_FEATURE_CT_MODE &&
        _TUN_FEATURE_LOC_MODE == rhs._TUN_FEATURE_LOC_MODE &&
        _TUN_FEATURE_unused == rhs._TUN_FEATURE_unused &&
        _TUN_FEATURE_MONO_MODE == rhs._TUN_FEATURE_MONO_MODE &&
        _TUN_FEATURE_PSFIX_MODE == rhs._TUN_FEATURE_PSFIX_MODE &&
        _TUN_FEATURE_REG_MODE == rhs._TUN_FEATURE_REG_MODE &&
        _TUN_FEATURE_RT_MODE == rhs._TUN_FEATURE_RT_MODE &&
        _TUN_FEATURE_SEARCH_MODE == rhs._TUN_FEATURE_SEARCH_MODE &&
        _TUN_FEATURE_SEEK_SENSE_MODE == rhs._TUN_FEATURE_SEEK_SENSE_MODE &&
        _TUN_FEATURE_SHARX_MODE == rhs._TUN_FEATURE_SHARX_MODE &&
        _TUN_FEATURE_TM_DATA_MODE == rhs._TUN_FEATURE_TM_DATA_MODE &&
        _TUN_FEATURE_TMC_MODE == rhs._TUN_FEATURE_TMC_MODE &&
        _TUN_FEATURE_KHZ50_MODE == rhs._TUN_FEATURE_KHZ50_MODE &&
        _TUN_FEATURE_REG_AUTO_MODE == rhs._TUN_FEATURE_REG_AUTO_MODE &&
        _TUN_FEATURE_NEWS_MODE == rhs._TUN_FEATURE_NEWS_MODE &&
        _TUN_FEATURE_RDS_AUTO_MODE == rhs._TUN_FEATURE_RDS_AUTO_MODE &&
        _TUN_FEATURE_DDA_MODE == rhs._TUN_FEATURE_DDA_MODE &&
        _TUN_FEATURE_DDS_MODE == rhs._TUN_FEATURE_DDS_MODE &&
        _TUN_FEATURE_reserved == rhs._TUN_FEATURE_reserved &&
        _TUN_FEATURE_MEASURE_MODE == rhs._TUN_FEATURE_MEASURE_MODE &&
        _TUN_FEATURE_AMFMSETUP_MODE == rhs._TUN_FEATURE_AMFMSETUP_MODE &&
        _TUN_FEATURE_PERSISTENTSTORAGE_MODE == rhs._TUN_FEATURE_PERSISTENTSTORAGE_MODE);
}

inline bool T_b32_Tun_Features::operator != (const T_b32_Tun_Features& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_Tun_Features::operator < (const T_b32_Tun_Features& rhs) const {
    if (getTUN_FEATURE_AF_MODE() < rhs.getTUN_FEATURE_AF_MODE()) return true;
    if (getTUN_FEATURE_AF_MODE() > rhs.getTUN_FEATURE_AF_MODE()) return false;

    if (getTUN_FEATURE_CT_MODE() < rhs.getTUN_FEATURE_CT_MODE()) return true;
    if (getTUN_FEATURE_CT_MODE() > rhs.getTUN_FEATURE_CT_MODE()) return false;

    if (getTUN_FEATURE_LOC_MODE() < rhs.getTUN_FEATURE_LOC_MODE()) return true;
    if (getTUN_FEATURE_LOC_MODE() > rhs.getTUN_FEATURE_LOC_MODE()) return false;

    if (getTUN_FEATURE_unused() < rhs.getTUN_FEATURE_unused()) return true;
    if (getTUN_FEATURE_unused() > rhs.getTUN_FEATURE_unused()) return false;

    if (getTUN_FEATURE_MONO_MODE() < rhs.getTUN_FEATURE_MONO_MODE()) return true;
    if (getTUN_FEATURE_MONO_MODE() > rhs.getTUN_FEATURE_MONO_MODE()) return false;

    if (getTUN_FEATURE_PSFIX_MODE() < rhs.getTUN_FEATURE_PSFIX_MODE()) return true;
    if (getTUN_FEATURE_PSFIX_MODE() > rhs.getTUN_FEATURE_PSFIX_MODE()) return false;

    if (getTUN_FEATURE_REG_MODE() < rhs.getTUN_FEATURE_REG_MODE()) return true;
    if (getTUN_FEATURE_REG_MODE() > rhs.getTUN_FEATURE_REG_MODE()) return false;

    if (getTUN_FEATURE_RT_MODE() < rhs.getTUN_FEATURE_RT_MODE()) return true;
    if (getTUN_FEATURE_RT_MODE() > rhs.getTUN_FEATURE_RT_MODE()) return false;

    if (getTUN_FEATURE_SEARCH_MODE() < rhs.getTUN_FEATURE_SEARCH_MODE()) return true;
    if (getTUN_FEATURE_SEARCH_MODE() > rhs.getTUN_FEATURE_SEARCH_MODE()) return false;

    if (getTUN_FEATURE_SEEK_SENSE_MODE() < rhs.getTUN_FEATURE_SEEK_SENSE_MODE()) return true;
    if (getTUN_FEATURE_SEEK_SENSE_MODE() > rhs.getTUN_FEATURE_SEEK_SENSE_MODE()) return false;

    if (getTUN_FEATURE_SHARX_MODE() < rhs.getTUN_FEATURE_SHARX_MODE()) return true;
    if (getTUN_FEATURE_SHARX_MODE() > rhs.getTUN_FEATURE_SHARX_MODE()) return false;

    if (getTUN_FEATURE_TM_DATA_MODE() < rhs.getTUN_FEATURE_TM_DATA_MODE()) return true;
    if (getTUN_FEATURE_TM_DATA_MODE() > rhs.getTUN_FEATURE_TM_DATA_MODE()) return false;

    if (getTUN_FEATURE_TMC_MODE() < rhs.getTUN_FEATURE_TMC_MODE()) return true;
    if (getTUN_FEATURE_TMC_MODE() > rhs.getTUN_FEATURE_TMC_MODE()) return false;

    if (getTUN_FEATURE_KHZ50_MODE() < rhs.getTUN_FEATURE_KHZ50_MODE()) return true;
    if (getTUN_FEATURE_KHZ50_MODE() > rhs.getTUN_FEATURE_KHZ50_MODE()) return false;

    if (getTUN_FEATURE_REG_AUTO_MODE() < rhs.getTUN_FEATURE_REG_AUTO_MODE()) return true;
    if (getTUN_FEATURE_REG_AUTO_MODE() > rhs.getTUN_FEATURE_REG_AUTO_MODE()) return false;

    if (getTUN_FEATURE_NEWS_MODE() < rhs.getTUN_FEATURE_NEWS_MODE()) return true;
    if (getTUN_FEATURE_NEWS_MODE() > rhs.getTUN_FEATURE_NEWS_MODE()) return false;

    if (getTUN_FEATURE_RDS_AUTO_MODE() < rhs.getTUN_FEATURE_RDS_AUTO_MODE()) return true;
    if (getTUN_FEATURE_RDS_AUTO_MODE() > rhs.getTUN_FEATURE_RDS_AUTO_MODE()) return false;

    if (getTUN_FEATURE_DDA_MODE() < rhs.getTUN_FEATURE_DDA_MODE()) return true;
    if (getTUN_FEATURE_DDA_MODE() > rhs.getTUN_FEATURE_DDA_MODE()) return false;

    if (getTUN_FEATURE_DDS_MODE() < rhs.getTUN_FEATURE_DDS_MODE()) return true;
    if (getTUN_FEATURE_DDS_MODE() > rhs.getTUN_FEATURE_DDS_MODE()) return false;

    if (getTUN_FEATURE_reserved() < rhs.getTUN_FEATURE_reserved()) return true;
    if (getTUN_FEATURE_reserved() > rhs.getTUN_FEATURE_reserved()) return false;

    if (getTUN_FEATURE_MEASURE_MODE() < rhs.getTUN_FEATURE_MEASURE_MODE()) return true;
    if (getTUN_FEATURE_MEASURE_MODE() > rhs.getTUN_FEATURE_MEASURE_MODE()) return false;

    if (getTUN_FEATURE_AMFMSETUP_MODE() < rhs.getTUN_FEATURE_AMFMSETUP_MODE()) return true;
    if (getTUN_FEATURE_AMFMSETUP_MODE() > rhs.getTUN_FEATURE_AMFMSETUP_MODE()) return false;

    if (getTUN_FEATURE_PERSISTENTSTORAGE_MODE() < rhs.getTUN_FEATURE_PERSISTENTSTORAGE_MODE()) return true;
    if (getTUN_FEATURE_PERSISTENTSTORAGE_MODE() > rhs.getTUN_FEATURE_PERSISTENTSTORAGE_MODE()) return false;

    return false;
}

inline bool T_b32_Tun_Features::operator > (const T_b32_Tun_Features& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_Tun_Features::setTUN_FEATURE_AF_MODE (bool TUN_FEATURE_AF_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_AF_MODE = TUN_FEATURE_AF_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_AF_MODE () const {
    return _TUN_FEATURE_AF_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_CT_MODE (bool TUN_FEATURE_CT_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_CT_MODE = TUN_FEATURE_CT_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_CT_MODE () const {
    return _TUN_FEATURE_CT_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_LOC_MODE (bool TUN_FEATURE_LOC_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_LOC_MODE = TUN_FEATURE_LOC_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_LOC_MODE () const {
    return _TUN_FEATURE_LOC_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_unused (bool TUN_FEATURE_unused) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_unused = TUN_FEATURE_unused;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_unused () const {
    return _TUN_FEATURE_unused;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_MONO_MODE (bool TUN_FEATURE_MONO_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_MONO_MODE = TUN_FEATURE_MONO_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_MONO_MODE () const {
    return _TUN_FEATURE_MONO_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_PSFIX_MODE (bool TUN_FEATURE_PSFIX_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_PSFIX_MODE = TUN_FEATURE_PSFIX_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_PSFIX_MODE () const {
    return _TUN_FEATURE_PSFIX_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_REG_MODE (bool TUN_FEATURE_REG_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_REG_MODE = TUN_FEATURE_REG_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_REG_MODE () const {
    return _TUN_FEATURE_REG_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_RT_MODE (bool TUN_FEATURE_RT_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_RT_MODE = TUN_FEATURE_RT_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_RT_MODE () const {
    return _TUN_FEATURE_RT_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_SEARCH_MODE (bool TUN_FEATURE_SEARCH_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_SEARCH_MODE = TUN_FEATURE_SEARCH_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_SEARCH_MODE () const {
    return _TUN_FEATURE_SEARCH_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_SEEK_SENSE_MODE (bool TUN_FEATURE_SEEK_SENSE_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_SEEK_SENSE_MODE = TUN_FEATURE_SEEK_SENSE_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_SEEK_SENSE_MODE () const {
    return _TUN_FEATURE_SEEK_SENSE_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_SHARX_MODE (bool TUN_FEATURE_SHARX_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_SHARX_MODE = TUN_FEATURE_SHARX_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_SHARX_MODE () const {
    return _TUN_FEATURE_SHARX_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_TM_DATA_MODE (bool TUN_FEATURE_TM_DATA_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_TM_DATA_MODE = TUN_FEATURE_TM_DATA_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_TM_DATA_MODE () const {
    return _TUN_FEATURE_TM_DATA_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_TMC_MODE (bool TUN_FEATURE_TMC_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_TMC_MODE = TUN_FEATURE_TMC_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_TMC_MODE () const {
    return _TUN_FEATURE_TMC_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_KHZ50_MODE (bool TUN_FEATURE_KHZ50_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_KHZ50_MODE = TUN_FEATURE_KHZ50_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_KHZ50_MODE () const {
    return _TUN_FEATURE_KHZ50_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_REG_AUTO_MODE (bool TUN_FEATURE_REG_AUTO_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_REG_AUTO_MODE = TUN_FEATURE_REG_AUTO_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_REG_AUTO_MODE () const {
    return _TUN_FEATURE_REG_AUTO_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_NEWS_MODE (bool TUN_FEATURE_NEWS_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_NEWS_MODE = TUN_FEATURE_NEWS_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_NEWS_MODE () const {
    return _TUN_FEATURE_NEWS_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_RDS_AUTO_MODE (bool TUN_FEATURE_RDS_AUTO_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_RDS_AUTO_MODE = TUN_FEATURE_RDS_AUTO_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_RDS_AUTO_MODE () const {
    return _TUN_FEATURE_RDS_AUTO_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_DDA_MODE (bool TUN_FEATURE_DDA_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_DDA_MODE = TUN_FEATURE_DDA_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_DDA_MODE () const {
    return _TUN_FEATURE_DDA_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_DDS_MODE (bool TUN_FEATURE_DDS_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_DDS_MODE = TUN_FEATURE_DDS_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_DDS_MODE () const {
    return _TUN_FEATURE_DDS_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_reserved (bool TUN_FEATURE_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_reserved = TUN_FEATURE_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_reserved () const {
    return _TUN_FEATURE_reserved;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_MEASURE_MODE (bool TUN_FEATURE_MEASURE_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_MEASURE_MODE = TUN_FEATURE_MEASURE_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_MEASURE_MODE () const {
    return _TUN_FEATURE_MEASURE_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_AMFMSETUP_MODE (bool TUN_FEATURE_AMFMSETUP_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_AMFMSETUP_MODE = TUN_FEATURE_AMFMSETUP_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_AMFMSETUP_MODE () const {
    return _TUN_FEATURE_AMFMSETUP_MODE;
}

inline void T_b32_Tun_Features::setTUN_FEATURE_PERSISTENTSTORAGE_MODE (bool TUN_FEATURE_PERSISTENTSTORAGE_MODE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_FEATURE_PERSISTENTSTORAGE_MODE = TUN_FEATURE_PERSISTENTSTORAGE_MODE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_Features::getTUN_FEATURE_PERSISTENTSTORAGE_MODE () const {
    return _TUN_FEATURE_PERSISTENTSTORAGE_MODE;
}

inline  T_b8_Tun_Antenna::T_b8_Tun_Antenna ()  :
    _TUNER_ANTENNA1 (false),
    _TUNER_ANTENNA2 (false)
{
}

inline  T_b8_Tun_Antenna::T_b8_Tun_Antenna (const T_b8_Tun_Antenna &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_Antenna::T_b8_Tun_Antenna (bool TUNER_ANTENNA1, bool TUNER_ANTENNA2) :
    _TUNER_ANTENNA1 (TUNER_ANTENNA1),
    _TUNER_ANTENNA2 (TUNER_ANTENNA2)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_Antenna& T_b8_Tun_Antenna::operator = (const T_b8_Tun_Antenna& rhs) {
    if( this != &rhs ) {
        _TUNER_ANTENNA1 = rhs._TUNER_ANTENNA1;
        _TUNER_ANTENNA2 = rhs._TUNER_ANTENNA2;
    }
    return *this;
}

inline bool T_b8_Tun_Antenna::operator == (const T_b8_Tun_Antenna& rhs) const {
    return (_TUNER_ANTENNA1 == rhs._TUNER_ANTENNA1 &&
        _TUNER_ANTENNA2 == rhs._TUNER_ANTENNA2);
}

inline bool T_b8_Tun_Antenna::operator != (const T_b8_Tun_Antenna& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_Antenna::operator < (const T_b8_Tun_Antenna& rhs) const {
    if (getTUNER_ANTENNA1() < rhs.getTUNER_ANTENNA1()) return true;
    if (getTUNER_ANTENNA1() > rhs.getTUNER_ANTENNA1()) return false;

    if (getTUNER_ANTENNA2() < rhs.getTUNER_ANTENNA2()) return true;
    if (getTUNER_ANTENNA2() > rhs.getTUNER_ANTENNA2()) return false;

    return false;
}

inline bool T_b8_Tun_Antenna::operator > (const T_b8_Tun_Antenna& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_Antenna::setTUNER_ANTENNA1 (bool TUNER_ANTENNA1) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNER_ANTENNA1 = TUNER_ANTENNA1;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Antenna::getTUNER_ANTENNA1 () const {
    return _TUNER_ANTENNA1;
}

inline void T_b8_Tun_Antenna::setTUNER_ANTENNA2 (bool TUNER_ANTENNA2) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUNER_ANTENNA2 = TUNER_ANTENNA2;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Antenna::getTUNER_ANTENNA2 () const {
    return _TUNER_ANTENNA2;
}

inline  T_TunerStationData::T_TunerStationData ()  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8PTY (0u),
    _u16PackedInfo (0u),
    _u32AvailFlags (NULL),
    _u32Frequency (0u),
    _u32PI (0u),
    _u8PSName1 (0u),
    _u8PSName2 (0u),
    _u8PSName3 (0u),
    _u8PSName4 (0u),
    _u8PSName5 (0u),
    _u8PSName6 (0u),
    _u8PSName7 (0u),
    _u8PSName8 (0u),
    _sPSName (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerStationData::T_TunerStationData (const T_TunerStationData &rhs)  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8PTY (0u),
    _u16PackedInfo (0u),
    _u32AvailFlags (NULL),
    _u32Frequency (0u),
    _u32PI (0u),
    _u8PSName1 (0u),
    _u8PSName2 (0u),
    _u8PSName3 (0u),
    _u8PSName4 (0u),
    _u8PSName5 (0u),
    _u8PSName6 (0u),
    _u8PSName7 (0u),
    _u8PSName8 (0u),
    _sPSName (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerStationData::T_TunerStationData (T_e8_Tun_TunerHeader u8TunerHeader_, uint8 u8PTY_, uint16 u16PackedInfo_, const T_b32_Tun_AvailFlags& u32AvailFlags_, uint32 u32Frequency_, uint32 u32PI_, uint8 u8PSName1_, uint8 u8PSName2_, uint8 u8PSName3_, uint8 u8PSName4_, uint8 u8PSName5_, uint8 u8PSName6_, uint8 u8PSName7_, uint8 u8PSName8_, const ::std::string& sPSName_)  :
    _u8TunerHeader (u8TunerHeader_),
    _u8PTY (u8PTY_),
    _u16PackedInfo (u16PackedInfo_),
    _u32AvailFlags (new T_b32_Tun_AvailFlags(u32AvailFlags_)),
    _u32Frequency (u32Frequency_),
    _u32PI (u32PI_),
    _u8PSName1 (u8PSName1_),
    _u8PSName2 (u8PSName2_),
    _u8PSName3 (u8PSName3_),
    _u8PSName4 (u8PSName4_),
    _u8PSName5 (u8PSName5_),
    _u8PSName6 (u8PSName6_),
    _u8PSName7 (u8PSName7_),
    _u8PSName8 (u8PSName8_),
    _sPSName (new ::std::string(sPSName_))
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_TunerStationData");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPSName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerStationData::~T_TunerStationData() {
    delete _u32AvailFlags;
    delete _sPSName;
}

inline T_TunerStationData& T_TunerStationData::operator = (const T_TunerStationData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TunerHeader()) {
            setU8TunerHeader(rhs.getU8TunerHeader());
        } else {
            clearU8TunerHeader();
        }
        if (rhs.hasU8PTY()) {
            setU8PTY(rhs.getU8PTY());
        } else {
            clearU8PTY();
        }
        if (rhs.hasU16PackedInfo()) {
            setU16PackedInfo(rhs.getU16PackedInfo());
        } else {
            clearU16PackedInfo();
        }
        if (rhs.hasU32AvailFlags()) {
            setU32AvailFlags(rhs.getU32AvailFlags());
        } else {
            clearU32AvailFlags();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasU32PI()) {
            setU32PI(rhs.getU32PI());
        } else {
            clearU32PI();
        }
        if (rhs.hasU8PSName1()) {
            setU8PSName1(rhs.getU8PSName1());
        } else {
            clearU8PSName1();
        }
        if (rhs.hasU8PSName2()) {
            setU8PSName2(rhs.getU8PSName2());
        } else {
            clearU8PSName2();
        }
        if (rhs.hasU8PSName3()) {
            setU8PSName3(rhs.getU8PSName3());
        } else {
            clearU8PSName3();
        }
        if (rhs.hasU8PSName4()) {
            setU8PSName4(rhs.getU8PSName4());
        } else {
            clearU8PSName4();
        }
        if (rhs.hasU8PSName5()) {
            setU8PSName5(rhs.getU8PSName5());
        } else {
            clearU8PSName5();
        }
        if (rhs.hasU8PSName6()) {
            setU8PSName6(rhs.getU8PSName6());
        } else {
            clearU8PSName6();
        }
        if (rhs.hasU8PSName7()) {
            setU8PSName7(rhs.getU8PSName7());
        } else {
            clearU8PSName7();
        }
        if (rhs.hasU8PSName8()) {
            setU8PSName8(rhs.getU8PSName8());
        } else {
            clearU8PSName8();
        }
        if (rhs.hasSPSName()) {
            setSPSName(rhs.getSPSName());
        } else {
            clearSPSName();
        }
    }
    return *this;
}

inline bool T_TunerStationData::operator == (const T_TunerStationData& rhs) const {
    return (((!hasU8TunerHeader() && !rhs.hasU8TunerHeader()) || getU8TunerHeader() == rhs.getU8TunerHeader()) &&
        ((!hasU8PTY() && !rhs.hasU8PTY()) || getU8PTY() == rhs.getU8PTY()) &&
        ((!hasU16PackedInfo() && !rhs.hasU16PackedInfo()) || getU16PackedInfo() == rhs.getU16PackedInfo()) &&
        ((!hasU32AvailFlags() && !rhs.hasU32AvailFlags()) || getU32AvailFlags() == rhs.getU32AvailFlags()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasU32PI() && !rhs.hasU32PI()) || getU32PI() == rhs.getU32PI()) &&
        ((!hasU8PSName1() && !rhs.hasU8PSName1()) || getU8PSName1() == rhs.getU8PSName1()) &&
        ((!hasU8PSName2() && !rhs.hasU8PSName2()) || getU8PSName2() == rhs.getU8PSName2()) &&
        ((!hasU8PSName3() && !rhs.hasU8PSName3()) || getU8PSName3() == rhs.getU8PSName3()) &&
        ((!hasU8PSName4() && !rhs.hasU8PSName4()) || getU8PSName4() == rhs.getU8PSName4()) &&
        ((!hasU8PSName5() && !rhs.hasU8PSName5()) || getU8PSName5() == rhs.getU8PSName5()) &&
        ((!hasU8PSName6() && !rhs.hasU8PSName6()) || getU8PSName6() == rhs.getU8PSName6()) &&
        ((!hasU8PSName7() && !rhs.hasU8PSName7()) || getU8PSName7() == rhs.getU8PSName7()) &&
        ((!hasU8PSName8() && !rhs.hasU8PSName8()) || getU8PSName8() == rhs.getU8PSName8()) &&
        ((!hasSPSName() && !rhs.hasSPSName()) || getSPSName() == rhs.getSPSName()));
}

inline bool T_TunerStationData::operator != (const T_TunerStationData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerStationData::operator < (const T_TunerStationData& rhs) const {
    if (hasU8TunerHeader() || rhs.hasU8TunerHeader()) {
        if ((uint32)getU8TunerHeader() < (uint32)rhs.getU8TunerHeader()) return true;
        if ((uint32)getU8TunerHeader() > (uint32)rhs.getU8TunerHeader()) return false;
    }
    if (hasU8PTY() || rhs.hasU8PTY()) {
        if (getU8PTY() < rhs.getU8PTY()) return true;
        if (getU8PTY() > rhs.getU8PTY()) return false;
    }
    if (hasU16PackedInfo() || rhs.hasU16PackedInfo()) {
        if (getU16PackedInfo() < rhs.getU16PackedInfo()) return true;
        if (getU16PackedInfo() > rhs.getU16PackedInfo()) return false;
    }
    if (hasU32AvailFlags() || rhs.hasU32AvailFlags()) {
        if (getU32AvailFlags() < rhs.getU32AvailFlags()) return true;
        if (getU32AvailFlags() > rhs.getU32AvailFlags()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasU32PI() || rhs.hasU32PI()) {
        if (getU32PI() < rhs.getU32PI()) return true;
        if (getU32PI() > rhs.getU32PI()) return false;
    }
    if (hasU8PSName1() || rhs.hasU8PSName1()) {
        if (getU8PSName1() < rhs.getU8PSName1()) return true;
        if (getU8PSName1() > rhs.getU8PSName1()) return false;
    }
    if (hasU8PSName2() || rhs.hasU8PSName2()) {
        if (getU8PSName2() < rhs.getU8PSName2()) return true;
        if (getU8PSName2() > rhs.getU8PSName2()) return false;
    }
    if (hasU8PSName3() || rhs.hasU8PSName3()) {
        if (getU8PSName3() < rhs.getU8PSName3()) return true;
        if (getU8PSName3() > rhs.getU8PSName3()) return false;
    }
    if (hasU8PSName4() || rhs.hasU8PSName4()) {
        if (getU8PSName4() < rhs.getU8PSName4()) return true;
        if (getU8PSName4() > rhs.getU8PSName4()) return false;
    }
    if (hasU8PSName5() || rhs.hasU8PSName5()) {
        if (getU8PSName5() < rhs.getU8PSName5()) return true;
        if (getU8PSName5() > rhs.getU8PSName5()) return false;
    }
    if (hasU8PSName6() || rhs.hasU8PSName6()) {
        if (getU8PSName6() < rhs.getU8PSName6()) return true;
        if (getU8PSName6() > rhs.getU8PSName6()) return false;
    }
    if (hasU8PSName7() || rhs.hasU8PSName7()) {
        if (getU8PSName7() < rhs.getU8PSName7()) return true;
        if (getU8PSName7() > rhs.getU8PSName7()) return false;
    }
    if (hasU8PSName8() || rhs.hasU8PSName8()) {
        if (getU8PSName8() < rhs.getU8PSName8()) return true;
        if (getU8PSName8() > rhs.getU8PSName8()) return false;
    }
    if (hasSPSName() || rhs.hasSPSName()) {
        if (getSPSName() < rhs.getSPSName()) return true;
        if (getSPSName() > rhs.getSPSName()) return false;
    }
    return false;
}

inline bool T_TunerStationData::operator > (const T_TunerStationData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerStationData::clear() {
    clearU8TunerHeader();
    clearU8PTY();
    clearU16PackedInfo();
    clearU32AvailFlags();
    clearU32Frequency();
    clearU32PI();
    clearU8PSName1();
    clearU8PSName2();
    clearU8PSName3();
    clearU8PSName4();
    clearU8PSName5();
    clearU8PSName6();
    clearU8PSName7();
    clearU8PSName8();
    clearSPSName();
}

inline void T_TunerStationData::clearU8TunerHeader() {
    if (hasU8TunerHeader()) {
         clear_has_u8TunerHeader();
        _u8TunerHeader = ::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool T_TunerStationData::hasU8TunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_TunerHeader T_TunerStationData::getU8TunerHeader () const {
    return _u8TunerHeader;
}

inline void T_TunerStationData::setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_TunerStationData");
    }
    set_has_u8TunerHeader();
    this->_u8TunerHeader = u8TunerHeader_;
}

inline void T_TunerStationData::clearU8PTY() {
    if (hasU8PTY()) {
         clear_has_u8PTY();
        _u8PTY = 0u;
     }
}

inline bool T_TunerStationData::hasU8PTY () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TunerStationData::getU8PTY () const {
    return _u8PTY;
}

inline void T_TunerStationData::setU8PTY (uint8 u8PTY_) {
    set_has_u8PTY();
    this->_u8PTY = u8PTY_;
}

inline void T_TunerStationData::clearU16PackedInfo() {
    if (hasU16PackedInfo()) {
         clear_has_u16PackedInfo();
        _u16PackedInfo = 0u;
     }
}

inline bool T_TunerStationData::hasU16PackedInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 T_TunerStationData::getU16PackedInfo () const {
    return _u16PackedInfo;
}

inline void T_TunerStationData::setU16PackedInfo (uint16 u16PackedInfo_) {
    set_has_u16PackedInfo();
    this->_u16PackedInfo = u16PackedInfo_;
}

inline void T_TunerStationData::clearU32AvailFlags() {
    if (hasU32AvailFlags()) {
         clear_has_u32AvailFlags();
        delete _u32AvailFlags;
        _u32AvailFlags = NULL;
     }
}

inline bool T_TunerStationData::hasU32AvailFlags () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b32_Tun_AvailFlags& T_TunerStationData::getU32AvailFlags () const {
    if (_u32AvailFlags == NULL) {
        return T_b32_Tun_AvailFlags::getDefaultInstance();
    }
    return *_u32AvailFlags;
}

inline T_b32_Tun_AvailFlags& T_TunerStationData::getU32AvailFlagsMutable () {
    set_has_u32AvailFlags();
    if (_u32AvailFlags == NULL) {
        _u32AvailFlags = new T_b32_Tun_AvailFlags ();
        CHECK_ALLOCATION( _u32AvailFlags );
    }
    return *_u32AvailFlags;
}

inline void T_TunerStationData::setU32AvailFlags (const T_b32_Tun_AvailFlags& u32AvailFlags_) {
    set_has_u32AvailFlags();
    if (this->_u32AvailFlags == NULL) {
        this->_u32AvailFlags = new T_b32_Tun_AvailFlags (u32AvailFlags_);
        CHECK_ALLOCATION( this->_u32AvailFlags );
    } else {
        *this->_u32AvailFlags = u32AvailFlags_;
    }
}

inline T_b32_Tun_AvailFlags* T_TunerStationData::releaseU32AvailFlags() {
    clear_has_u32AvailFlags();
    T_b32_Tun_AvailFlags* temp = _u32AvailFlags;
    this->_u32AvailFlags = NULL;
    return temp;
}

inline void T_TunerStationData::replaceU32AvailFlags (T_b32_Tun_AvailFlags* u32AvailFlags_) {
    set_has_u32AvailFlags();
    if (this->_u32AvailFlags != u32AvailFlags_) {
        if (this->_u32AvailFlags != NULL) {
            delete this->_u32AvailFlags;
        }
        this->_u32AvailFlags = u32AvailFlags_;
    }
}

inline void T_TunerStationData::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_TunerStationData::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_TunerStationData::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_TunerStationData::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_TunerStationData::clearU32PI() {
    if (hasU32PI()) {
         clear_has_u32PI();
        _u32PI = 0u;
     }
}

inline bool T_TunerStationData::hasU32PI () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint32 T_TunerStationData::getU32PI () const {
    return _u32PI;
}

inline void T_TunerStationData::setU32PI (uint32 u32PI_) {
    set_has_u32PI();
    this->_u32PI = u32PI_;
}

inline void T_TunerStationData::clearU8PSName1() {
    if (hasU8PSName1()) {
         clear_has_u8PSName1();
        _u8PSName1 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName1 () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName1 () const {
    return _u8PSName1;
}

inline void T_TunerStationData::setU8PSName1 (uint8 u8PSName1_) {
    set_has_u8PSName1();
    this->_u8PSName1 = u8PSName1_;
}

inline void T_TunerStationData::clearU8PSName2() {
    if (hasU8PSName2()) {
         clear_has_u8PSName2();
        _u8PSName2 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName2 () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName2 () const {
    return _u8PSName2;
}

inline void T_TunerStationData::setU8PSName2 (uint8 u8PSName2_) {
    set_has_u8PSName2();
    this->_u8PSName2 = u8PSName2_;
}

inline void T_TunerStationData::clearU8PSName3() {
    if (hasU8PSName3()) {
         clear_has_u8PSName3();
        _u8PSName3 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName3 () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName3 () const {
    return _u8PSName3;
}

inline void T_TunerStationData::setU8PSName3 (uint8 u8PSName3_) {
    set_has_u8PSName3();
    this->_u8PSName3 = u8PSName3_;
}

inline void T_TunerStationData::clearU8PSName4() {
    if (hasU8PSName4()) {
         clear_has_u8PSName4();
        _u8PSName4 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName4 () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName4 () const {
    return _u8PSName4;
}

inline void T_TunerStationData::setU8PSName4 (uint8 u8PSName4_) {
    set_has_u8PSName4();
    this->_u8PSName4 = u8PSName4_;
}

inline void T_TunerStationData::clearU8PSName5() {
    if (hasU8PSName5()) {
         clear_has_u8PSName5();
        _u8PSName5 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName5 () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName5 () const {
    return _u8PSName5;
}

inline void T_TunerStationData::setU8PSName5 (uint8 u8PSName5_) {
    set_has_u8PSName5();
    this->_u8PSName5 = u8PSName5_;
}

inline void T_TunerStationData::clearU8PSName6() {
    if (hasU8PSName6()) {
         clear_has_u8PSName6();
        _u8PSName6 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName6 () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName6 () const {
    return _u8PSName6;
}

inline void T_TunerStationData::setU8PSName6 (uint8 u8PSName6_) {
    set_has_u8PSName6();
    this->_u8PSName6 = u8PSName6_;
}

inline void T_TunerStationData::clearU8PSName7() {
    if (hasU8PSName7()) {
         clear_has_u8PSName7();
        _u8PSName7 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName7 () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName7 () const {
    return _u8PSName7;
}

inline void T_TunerStationData::setU8PSName7 (uint8 u8PSName7_) {
    set_has_u8PSName7();
    this->_u8PSName7 = u8PSName7_;
}

inline void T_TunerStationData::clearU8PSName8() {
    if (hasU8PSName8()) {
         clear_has_u8PSName8();
        _u8PSName8 = 0u;
     }
}

inline bool T_TunerStationData::hasU8PSName8 () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_TunerStationData::getU8PSName8 () const {
    return _u8PSName8;
}

inline void T_TunerStationData::setU8PSName8 (uint8 u8PSName8_) {
    set_has_u8PSName8();
    this->_u8PSName8 = u8PSName8_;
}

inline void T_TunerStationData::clearSPSName() {
    if (hasSPSName()) {
         clear_has_sPSName();
        if (_sPSName != NULL) {
            _sPSName->clear();
        }
     }
}

inline bool T_TunerStationData::hasSPSName () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline const ::std::string& T_TunerStationData::getSPSName () const {
    if (_sPSName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sPSName;
}

inline ::std::string& T_TunerStationData::getSPSNameMutable () {
    set_has_sPSName();
    if (_sPSName == NULL) {
        _sPSName = new ::std::string ();
        CHECK_ALLOCATION( _sPSName );
    }
    return *_sPSName;
}

inline void T_TunerStationData::setSPSName (const ::std::string& sPSName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPSName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPSName();
    if (this->_sPSName == NULL) {
        this->_sPSName = new ::std::string (sPSName_);
        CHECK_ALLOCATION( this->_sPSName );
    } else {
        *this->_sPSName = sPSName_;
    }
}

inline void T_TunerStationData::setSPSName (const char* sPSName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPSName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPSName();
    if (this->_sPSName == NULL) {
        this->_sPSName = new ::std::string (sPSName_);
        CHECK_ALLOCATION( this->_sPSName );
    } else {
        this->_sPSName->assign(sPSName_);
    }
}

inline void T_TunerStationData::setSPSName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPSName();
    if (this->_sPSName == NULL) {
        this->_sPSName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sPSName );
    } else {
        this->_sPSName->assign(value, size);
    }
}

inline ::std::string* T_TunerStationData::releaseSPSName() {
    clear_has_sPSName();
    ::std::string* temp = _sPSName;
    this->_sPSName = NULL;
    return temp;
}

inline void T_TunerStationData::replaceSPSName (::std::string* sPSName_) {
    set_has_sPSName();
    if (this->_sPSName != sPSName_) {
        if (this->_sPSName != NULL) {
            delete this->_sPSName;
        }
        this->_sPSName = sPSName_;
    }
}

inline void T_TunerStationData::set_has_u8TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerStationData::clear_has_u8TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerStationData::set_has_u8PTY () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerStationData::clear_has_u8PTY () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TunerStationData::set_has_u16PackedInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TunerStationData::clear_has_u16PackedInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TunerStationData::set_has_u32AvailFlags () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TunerStationData::clear_has_u32AvailFlags () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TunerStationData::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TunerStationData::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TunerStationData::set_has_u32PI () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TunerStationData::clear_has_u32PI () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TunerStationData::set_has_u8PSName1 () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TunerStationData::clear_has_u8PSName1 () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TunerStationData::set_has_u8PSName2 () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TunerStationData::clear_has_u8PSName2 () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TunerStationData::set_has_u8PSName3 () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TunerStationData::clear_has_u8PSName3 () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TunerStationData::set_has_u8PSName4 () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TunerStationData::clear_has_u8PSName4 () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_TunerStationData::set_has_u8PSName5 () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_TunerStationData::clear_has_u8PSName5 () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_TunerStationData::set_has_u8PSName6 () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_TunerStationData::clear_has_u8PSName6 () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_TunerStationData::set_has_u8PSName7 () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_TunerStationData::clear_has_u8PSName7 () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_TunerStationData::set_has_u8PSName8 () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_TunerStationData::clear_has_u8PSName8 () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_TunerStationData::set_has_sPSName () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_TunerStationData::clear_has_sPSName () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline  T_TunerFeature::T_TunerFeature ()  :
    _b32Features (NULL),
    _b32MaskFeatures (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerFeature::T_TunerFeature (const T_TunerFeature &rhs)  :
    _b32Features (NULL),
    _b32MaskFeatures (NULL)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerFeature::T_TunerFeature (const T_b32_Tun_Features& b32Features_, const T_b32_Tun_Features& b32MaskFeatures_)  :
    _b32Features (new T_b32_Tun_Features(b32Features_)),
    _b32MaskFeatures (new T_b32_Tun_Features(b32MaskFeatures_))
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerFeature::~T_TunerFeature() {
    delete _b32Features;
    delete _b32MaskFeatures;
}

inline T_TunerFeature& T_TunerFeature::operator = (const T_TunerFeature& rhs) {
    if( this != &rhs ) {
        if (rhs.hasB32Features()) {
            setB32Features(rhs.getB32Features());
        } else {
            clearB32Features();
        }
        if (rhs.hasB32MaskFeatures()) {
            setB32MaskFeatures(rhs.getB32MaskFeatures());
        } else {
            clearB32MaskFeatures();
        }
    }
    return *this;
}

inline bool T_TunerFeature::operator == (const T_TunerFeature& rhs) const {
    return (((!hasB32Features() && !rhs.hasB32Features()) || getB32Features() == rhs.getB32Features()) &&
        ((!hasB32MaskFeatures() && !rhs.hasB32MaskFeatures()) || getB32MaskFeatures() == rhs.getB32MaskFeatures()));
}

inline bool T_TunerFeature::operator != (const T_TunerFeature& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerFeature::operator < (const T_TunerFeature& rhs) const {
    if (hasB32Features() || rhs.hasB32Features()) {
        if (getB32Features() < rhs.getB32Features()) return true;
        if (getB32Features() > rhs.getB32Features()) return false;
    }
    if (hasB32MaskFeatures() || rhs.hasB32MaskFeatures()) {
        if (getB32MaskFeatures() < rhs.getB32MaskFeatures()) return true;
        if (getB32MaskFeatures() > rhs.getB32MaskFeatures()) return false;
    }
    return false;
}

inline bool T_TunerFeature::operator > (const T_TunerFeature& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerFeature::clear() {
    clearB32Features();
    clearB32MaskFeatures();
}

inline void T_TunerFeature::clearB32Features() {
    if (hasB32Features()) {
         clear_has_b32Features();
        delete _b32Features;
        _b32Features = NULL;
     }
}

inline bool T_TunerFeature::hasB32Features () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const T_b32_Tun_Features& T_TunerFeature::getB32Features () const {
    if (_b32Features == NULL) {
        return T_b32_Tun_Features::getDefaultInstance();
    }
    return *_b32Features;
}

inline T_b32_Tun_Features& T_TunerFeature::getB32FeaturesMutable () {
    set_has_b32Features();
    if (_b32Features == NULL) {
        _b32Features = new T_b32_Tun_Features ();
        CHECK_ALLOCATION( _b32Features );
    }
    return *_b32Features;
}

inline void T_TunerFeature::setB32Features (const T_b32_Tun_Features& b32Features_) {
    set_has_b32Features();
    if (this->_b32Features == NULL) {
        this->_b32Features = new T_b32_Tun_Features (b32Features_);
        CHECK_ALLOCATION( this->_b32Features );
    } else {
        *this->_b32Features = b32Features_;
    }
}

inline T_b32_Tun_Features* T_TunerFeature::releaseB32Features() {
    clear_has_b32Features();
    T_b32_Tun_Features* temp = _b32Features;
    this->_b32Features = NULL;
    return temp;
}

inline void T_TunerFeature::replaceB32Features (T_b32_Tun_Features* b32Features_) {
    set_has_b32Features();
    if (this->_b32Features != b32Features_) {
        if (this->_b32Features != NULL) {
            delete this->_b32Features;
        }
        this->_b32Features = b32Features_;
    }
}

inline void T_TunerFeature::clearB32MaskFeatures() {
    if (hasB32MaskFeatures()) {
         clear_has_b32MaskFeatures();
        delete _b32MaskFeatures;
        _b32MaskFeatures = NULL;
     }
}

inline bool T_TunerFeature::hasB32MaskFeatures () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_b32_Tun_Features& T_TunerFeature::getB32MaskFeatures () const {
    if (_b32MaskFeatures == NULL) {
        return T_b32_Tun_Features::getDefaultInstance();
    }
    return *_b32MaskFeatures;
}

inline T_b32_Tun_Features& T_TunerFeature::getB32MaskFeaturesMutable () {
    set_has_b32MaskFeatures();
    if (_b32MaskFeatures == NULL) {
        _b32MaskFeatures = new T_b32_Tun_Features ();
        CHECK_ALLOCATION( _b32MaskFeatures );
    }
    return *_b32MaskFeatures;
}

inline void T_TunerFeature::setB32MaskFeatures (const T_b32_Tun_Features& b32MaskFeatures_) {
    set_has_b32MaskFeatures();
    if (this->_b32MaskFeatures == NULL) {
        this->_b32MaskFeatures = new T_b32_Tun_Features (b32MaskFeatures_);
        CHECK_ALLOCATION( this->_b32MaskFeatures );
    } else {
        *this->_b32MaskFeatures = b32MaskFeatures_;
    }
}

inline T_b32_Tun_Features* T_TunerFeature::releaseB32MaskFeatures() {
    clear_has_b32MaskFeatures();
    T_b32_Tun_Features* temp = _b32MaskFeatures;
    this->_b32MaskFeatures = NULL;
    return temp;
}

inline void T_TunerFeature::replaceB32MaskFeatures (T_b32_Tun_Features* b32MaskFeatures_) {
    set_has_b32MaskFeatures();
    if (this->_b32MaskFeatures != b32MaskFeatures_) {
        if (this->_b32MaskFeatures != NULL) {
            delete this->_b32MaskFeatures;
        }
        this->_b32MaskFeatures = b32MaskFeatures_;
    }
}

inline void T_TunerFeature::set_has_b32Features () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerFeature::clear_has_b32Features () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerFeature::set_has_b32MaskFeatures () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerFeature::clear_has_b32MaskFeatures () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b32_Tun_AvailableFlags::T_b32_Tun_AvailableFlags ()  :
    _TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (false),
    _TUN_AVAILABLE_FLAGS_reserved (false),
    _TUN_AVAILABLE_FLAGS_PS_AVAILABLE (false)
{
}

inline  T_b32_Tun_AvailableFlags::T_b32_Tun_AvailableFlags (const T_b32_Tun_AvailableFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32_Tun_AvailableFlags::T_b32_Tun_AvailableFlags (bool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE, bool TUN_AVAILABLE_FLAGS_reserved, bool TUN_AVAILABLE_FLAGS_PS_AVAILABLE) :
    _TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE),
    _TUN_AVAILABLE_FLAGS_reserved (TUN_AVAILABLE_FLAGS_reserved),
    _TUN_AVAILABLE_FLAGS_PS_AVAILABLE (TUN_AVAILABLE_FLAGS_PS_AVAILABLE)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32_Tun_AvailableFlags& T_b32_Tun_AvailableFlags::operator = (const T_b32_Tun_AvailableFlags& rhs) {
    if( this != &rhs ) {
        _TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE = rhs._TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE;
        _TUN_AVAILABLE_FLAGS_reserved = rhs._TUN_AVAILABLE_FLAGS_reserved;
        _TUN_AVAILABLE_FLAGS_PS_AVAILABLE = rhs._TUN_AVAILABLE_FLAGS_PS_AVAILABLE;
    }
    return *this;
}

inline bool T_b32_Tun_AvailableFlags::operator == (const T_b32_Tun_AvailableFlags& rhs) const {
    return (_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE == rhs._TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE &&
        _TUN_AVAILABLE_FLAGS_reserved == rhs._TUN_AVAILABLE_FLAGS_reserved &&
        _TUN_AVAILABLE_FLAGS_PS_AVAILABLE == rhs._TUN_AVAILABLE_FLAGS_PS_AVAILABLE);
}

inline bool T_b32_Tun_AvailableFlags::operator != (const T_b32_Tun_AvailableFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32_Tun_AvailableFlags::operator < (const T_b32_Tun_AvailableFlags& rhs) const {
    if (getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE() < rhs.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE()) return true;
    if (getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE() > rhs.getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE()) return false;

    if (getTUN_AVAILABLE_FLAGS_reserved() < rhs.getTUN_AVAILABLE_FLAGS_reserved()) return true;
    if (getTUN_AVAILABLE_FLAGS_reserved() > rhs.getTUN_AVAILABLE_FLAGS_reserved()) return false;

    if (getTUN_AVAILABLE_FLAGS_PS_AVAILABLE() < rhs.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE()) return true;
    if (getTUN_AVAILABLE_FLAGS_PS_AVAILABLE() > rhs.getTUN_AVAILABLE_FLAGS_PS_AVAILABLE()) return false;

    return false;
}

inline bool T_b32_Tun_AvailableFlags::operator > (const T_b32_Tun_AvailableFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32_Tun_AvailableFlags::setTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE (bool TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE = TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailableFlags::getTUN_AVAILABLE_FLAGS_FRQ_AVAILABLE () const {
    return _TUN_AVAILABLE_FLAGS_FRQ_AVAILABLE;
}

inline void T_b32_Tun_AvailableFlags::setTUN_AVAILABLE_FLAGS_reserved (bool TUN_AVAILABLE_FLAGS_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_AVAILABLE_FLAGS_reserved = TUN_AVAILABLE_FLAGS_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailableFlags::getTUN_AVAILABLE_FLAGS_reserved () const {
    return _TUN_AVAILABLE_FLAGS_reserved;
}

inline void T_b32_Tun_AvailableFlags::setTUN_AVAILABLE_FLAGS_PS_AVAILABLE (bool TUN_AVAILABLE_FLAGS_PS_AVAILABLE) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_AVAILABLE_FLAGS_PS_AVAILABLE = TUN_AVAILABLE_FLAGS_PS_AVAILABLE;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32_Tun_AvailableFlags::getTUN_AVAILABLE_FLAGS_PS_AVAILABLE () const {
    return _TUN_AVAILABLE_FLAGS_PS_AVAILABLE;
}

inline  T_TunerManualSingleStep::T_TunerManualSingleStep ()  :
    _ManualFreqAdjustment (::midw_tuner_fi_types::T_e8_Tun_ManualFreqAdjustment__TUN_SEEK_DIRECTION_UP),
    _u8NumberOfTicks (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerManualSingleStep::T_TunerManualSingleStep (const T_TunerManualSingleStep &rhs)  :
    _ManualFreqAdjustment (::midw_tuner_fi_types::T_e8_Tun_ManualFreqAdjustment__TUN_SEEK_DIRECTION_UP),
    _u8NumberOfTicks (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerManualSingleStep::T_TunerManualSingleStep (T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_, uint8 u8NumberOfTicks_)  :
    _ManualFreqAdjustment (ManualFreqAdjustment_),
    _u8NumberOfTicks (u8NumberOfTicks_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ManualFreqAdjustment_IsValid(ManualFreqAdjustment_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ManualFreqAdjustment_, "T_e8_Tun_ManualFreqAdjustment", "ManualFreqAdjustment", "T_TunerManualSingleStep");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerManualSingleStep::~T_TunerManualSingleStep() {
}

inline T_TunerManualSingleStep& T_TunerManualSingleStep::operator = (const T_TunerManualSingleStep& rhs) {
    if( this != &rhs ) {
        if (rhs.hasManualFreqAdjustment()) {
            setManualFreqAdjustment(rhs.getManualFreqAdjustment());
        } else {
            clearManualFreqAdjustment();
        }
        if (rhs.hasU8NumberOfTicks()) {
            setU8NumberOfTicks(rhs.getU8NumberOfTicks());
        } else {
            clearU8NumberOfTicks();
        }
    }
    return *this;
}

inline bool T_TunerManualSingleStep::operator == (const T_TunerManualSingleStep& rhs) const {
    return (((!hasManualFreqAdjustment() && !rhs.hasManualFreqAdjustment()) || getManualFreqAdjustment() == rhs.getManualFreqAdjustment()) &&
        ((!hasU8NumberOfTicks() && !rhs.hasU8NumberOfTicks()) || getU8NumberOfTicks() == rhs.getU8NumberOfTicks()));
}

inline bool T_TunerManualSingleStep::operator != (const T_TunerManualSingleStep& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerManualSingleStep::operator < (const T_TunerManualSingleStep& rhs) const {
    if (hasManualFreqAdjustment() || rhs.hasManualFreqAdjustment()) {
        if ((uint32)getManualFreqAdjustment() < (uint32)rhs.getManualFreqAdjustment()) return true;
        if ((uint32)getManualFreqAdjustment() > (uint32)rhs.getManualFreqAdjustment()) return false;
    }
    if (hasU8NumberOfTicks() || rhs.hasU8NumberOfTicks()) {
        if (getU8NumberOfTicks() < rhs.getU8NumberOfTicks()) return true;
        if (getU8NumberOfTicks() > rhs.getU8NumberOfTicks()) return false;
    }
    return false;
}

inline bool T_TunerManualSingleStep::operator > (const T_TunerManualSingleStep& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerManualSingleStep::clear() {
    clearManualFreqAdjustment();
    clearU8NumberOfTicks();
}

inline void T_TunerManualSingleStep::clearManualFreqAdjustment() {
    if (hasManualFreqAdjustment()) {
         clear_has_ManualFreqAdjustment();
        _ManualFreqAdjustment = ::midw_tuner_fi_types::T_e8_Tun_ManualFreqAdjustment__TUN_SEEK_DIRECTION_UP;
     }
}

inline bool T_TunerManualSingleStep::hasManualFreqAdjustment () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_ManualFreqAdjustment T_TunerManualSingleStep::getManualFreqAdjustment () const {
    return _ManualFreqAdjustment;
}

inline void T_TunerManualSingleStep::setManualFreqAdjustment (T_e8_Tun_ManualFreqAdjustment ManualFreqAdjustment_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ManualFreqAdjustment_IsValid(ManualFreqAdjustment_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ManualFreqAdjustment_, "T_e8_Tun_ManualFreqAdjustment", "ManualFreqAdjustment", "T_TunerManualSingleStep");
    }
    set_has_ManualFreqAdjustment();
    this->_ManualFreqAdjustment = ManualFreqAdjustment_;
}

inline void T_TunerManualSingleStep::clearU8NumberOfTicks() {
    if (hasU8NumberOfTicks()) {
         clear_has_u8NumberOfTicks();
        _u8NumberOfTicks = 0u;
     }
}

inline bool T_TunerManualSingleStep::hasU8NumberOfTicks () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TunerManualSingleStep::getU8NumberOfTicks () const {
    return _u8NumberOfTicks;
}

inline void T_TunerManualSingleStep::setU8NumberOfTicks (uint8 u8NumberOfTicks_) {
    set_has_u8NumberOfTicks();
    this->_u8NumberOfTicks = u8NumberOfTicks_;
}

inline void T_TunerManualSingleStep::set_has_ManualFreqAdjustment () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerManualSingleStep::clear_has_ManualFreqAdjustment () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerManualSingleStep::set_has_u8NumberOfTicks () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerManualSingleStep::clear_has_u8NumberOfTicks () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_b8_Tun_OperationFlags::T_b8_Tun_OperationFlags ()  :
    _TUN_OPERATION_AFBEST (false),
    _TUN_OPERATION_PTY (false),
    _TUN_OPERATION_SEARCH (false),
    _TUN_OPERATION_TA (false),
    _TUN_OPERATION_TPSEEK (false),
    _TUN_OPERATION_ACTION (false),
    _TUN_OPERATION_SEEK_LEVEL_LOGIC (false),
    _TUN_OPERATION_reserved (false)
{
}

inline  T_b8_Tun_OperationFlags::T_b8_Tun_OperationFlags (const T_b8_Tun_OperationFlags &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_OperationFlags::T_b8_Tun_OperationFlags (bool TUN_OPERATION_AFBEST, bool TUN_OPERATION_PTY, bool TUN_OPERATION_SEARCH, bool TUN_OPERATION_TA, bool TUN_OPERATION_TPSEEK, bool TUN_OPERATION_ACTION, bool TUN_OPERATION_SEEK_LEVEL_LOGIC, bool TUN_OPERATION_reserved) :
    _TUN_OPERATION_AFBEST (TUN_OPERATION_AFBEST),
    _TUN_OPERATION_PTY (TUN_OPERATION_PTY),
    _TUN_OPERATION_SEARCH (TUN_OPERATION_SEARCH),
    _TUN_OPERATION_TA (TUN_OPERATION_TA),
    _TUN_OPERATION_TPSEEK (TUN_OPERATION_TPSEEK),
    _TUN_OPERATION_ACTION (TUN_OPERATION_ACTION),
    _TUN_OPERATION_SEEK_LEVEL_LOGIC (TUN_OPERATION_SEEK_LEVEL_LOGIC),
    _TUN_OPERATION_reserved (TUN_OPERATION_reserved)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_OperationFlags& T_b8_Tun_OperationFlags::operator = (const T_b8_Tun_OperationFlags& rhs) {
    if( this != &rhs ) {
        _TUN_OPERATION_AFBEST = rhs._TUN_OPERATION_AFBEST;
        _TUN_OPERATION_PTY = rhs._TUN_OPERATION_PTY;
        _TUN_OPERATION_SEARCH = rhs._TUN_OPERATION_SEARCH;
        _TUN_OPERATION_TA = rhs._TUN_OPERATION_TA;
        _TUN_OPERATION_TPSEEK = rhs._TUN_OPERATION_TPSEEK;
        _TUN_OPERATION_ACTION = rhs._TUN_OPERATION_ACTION;
        _TUN_OPERATION_SEEK_LEVEL_LOGIC = rhs._TUN_OPERATION_SEEK_LEVEL_LOGIC;
        _TUN_OPERATION_reserved = rhs._TUN_OPERATION_reserved;
    }
    return *this;
}

inline bool T_b8_Tun_OperationFlags::operator == (const T_b8_Tun_OperationFlags& rhs) const {
    return (_TUN_OPERATION_AFBEST == rhs._TUN_OPERATION_AFBEST &&
        _TUN_OPERATION_PTY == rhs._TUN_OPERATION_PTY &&
        _TUN_OPERATION_SEARCH == rhs._TUN_OPERATION_SEARCH &&
        _TUN_OPERATION_TA == rhs._TUN_OPERATION_TA &&
        _TUN_OPERATION_TPSEEK == rhs._TUN_OPERATION_TPSEEK &&
        _TUN_OPERATION_ACTION == rhs._TUN_OPERATION_ACTION &&
        _TUN_OPERATION_SEEK_LEVEL_LOGIC == rhs._TUN_OPERATION_SEEK_LEVEL_LOGIC &&
        _TUN_OPERATION_reserved == rhs._TUN_OPERATION_reserved);
}

inline bool T_b8_Tun_OperationFlags::operator != (const T_b8_Tun_OperationFlags& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_OperationFlags::operator < (const T_b8_Tun_OperationFlags& rhs) const {
    if (getTUN_OPERATION_AFBEST() < rhs.getTUN_OPERATION_AFBEST()) return true;
    if (getTUN_OPERATION_AFBEST() > rhs.getTUN_OPERATION_AFBEST()) return false;

    if (getTUN_OPERATION_PTY() < rhs.getTUN_OPERATION_PTY()) return true;
    if (getTUN_OPERATION_PTY() > rhs.getTUN_OPERATION_PTY()) return false;

    if (getTUN_OPERATION_SEARCH() < rhs.getTUN_OPERATION_SEARCH()) return true;
    if (getTUN_OPERATION_SEARCH() > rhs.getTUN_OPERATION_SEARCH()) return false;

    if (getTUN_OPERATION_TA() < rhs.getTUN_OPERATION_TA()) return true;
    if (getTUN_OPERATION_TA() > rhs.getTUN_OPERATION_TA()) return false;

    if (getTUN_OPERATION_TPSEEK() < rhs.getTUN_OPERATION_TPSEEK()) return true;
    if (getTUN_OPERATION_TPSEEK() > rhs.getTUN_OPERATION_TPSEEK()) return false;

    if (getTUN_OPERATION_ACTION() < rhs.getTUN_OPERATION_ACTION()) return true;
    if (getTUN_OPERATION_ACTION() > rhs.getTUN_OPERATION_ACTION()) return false;

    if (getTUN_OPERATION_SEEK_LEVEL_LOGIC() < rhs.getTUN_OPERATION_SEEK_LEVEL_LOGIC()) return true;
    if (getTUN_OPERATION_SEEK_LEVEL_LOGIC() > rhs.getTUN_OPERATION_SEEK_LEVEL_LOGIC()) return false;

    if (getTUN_OPERATION_reserved() < rhs.getTUN_OPERATION_reserved()) return true;
    if (getTUN_OPERATION_reserved() > rhs.getTUN_OPERATION_reserved()) return false;

    return false;
}

inline bool T_b8_Tun_OperationFlags::operator > (const T_b8_Tun_OperationFlags& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_AFBEST (bool TUN_OPERATION_AFBEST) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_AFBEST = TUN_OPERATION_AFBEST;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_AFBEST () const {
    return _TUN_OPERATION_AFBEST;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_PTY (bool TUN_OPERATION_PTY) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_PTY = TUN_OPERATION_PTY;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_PTY () const {
    return _TUN_OPERATION_PTY;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_SEARCH (bool TUN_OPERATION_SEARCH) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_SEARCH = TUN_OPERATION_SEARCH;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_SEARCH () const {
    return _TUN_OPERATION_SEARCH;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_TA (bool TUN_OPERATION_TA) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_TA = TUN_OPERATION_TA;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_TA () const {
    return _TUN_OPERATION_TA;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_TPSEEK (bool TUN_OPERATION_TPSEEK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_TPSEEK = TUN_OPERATION_TPSEEK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_TPSEEK () const {
    return _TUN_OPERATION_TPSEEK;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_ACTION (bool TUN_OPERATION_ACTION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_ACTION = TUN_OPERATION_ACTION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_ACTION () const {
    return _TUN_OPERATION_ACTION;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_SEEK_LEVEL_LOGIC (bool TUN_OPERATION_SEEK_LEVEL_LOGIC) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_SEEK_LEVEL_LOGIC = TUN_OPERATION_SEEK_LEVEL_LOGIC;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_SEEK_LEVEL_LOGIC () const {
    return _TUN_OPERATION_SEEK_LEVEL_LOGIC;
}

inline void T_b8_Tun_OperationFlags::setTUN_OPERATION_reserved (bool TUN_OPERATION_reserved) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_OPERATION_reserved = TUN_OPERATION_reserved;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_OperationFlags::getTUN_OPERATION_reserved () const {
    return _TUN_OPERATION_reserved;
}

inline  T_TunerOperation::T_TunerOperation ()  :
    _u8EnableOrDisable (::midw_tuner_fi_types::T_e8_Tun_EnableOrDisable__DISABLE),
    _u8OperationFlags (::midw_tuner_fi_types::T_e8_Tun_OperationFlags__TUN_OPERATION_AFBEST)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerOperation::T_TunerOperation (const T_TunerOperation &rhs)  :
    _u8EnableOrDisable (::midw_tuner_fi_types::T_e8_Tun_EnableOrDisable__DISABLE),
    _u8OperationFlags (::midw_tuner_fi_types::T_e8_Tun_OperationFlags__TUN_OPERATION_AFBEST)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerOperation::T_TunerOperation (T_e8_Tun_EnableOrDisable u8EnableOrDisable_, T_e8_Tun_OperationFlags u8OperationFlags_)  :
    _u8EnableOrDisable (u8EnableOrDisable_),
    _u8OperationFlags (u8OperationFlags_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_EnableOrDisable_IsValid(u8EnableOrDisable_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8EnableOrDisable_, "T_e8_Tun_EnableOrDisable", "u8EnableOrDisable", "T_TunerOperation");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_OperationFlags_IsValid(u8OperationFlags_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8OperationFlags_, "T_e8_Tun_OperationFlags", "u8OperationFlags", "T_TunerOperation");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerOperation::~T_TunerOperation() {
}

inline T_TunerOperation& T_TunerOperation::operator = (const T_TunerOperation& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8EnableOrDisable()) {
            setU8EnableOrDisable(rhs.getU8EnableOrDisable());
        } else {
            clearU8EnableOrDisable();
        }
        if (rhs.hasU8OperationFlags()) {
            setU8OperationFlags(rhs.getU8OperationFlags());
        } else {
            clearU8OperationFlags();
        }
    }
    return *this;
}

inline bool T_TunerOperation::operator == (const T_TunerOperation& rhs) const {
    return (((!hasU8EnableOrDisable() && !rhs.hasU8EnableOrDisable()) || getU8EnableOrDisable() == rhs.getU8EnableOrDisable()) &&
        ((!hasU8OperationFlags() && !rhs.hasU8OperationFlags()) || getU8OperationFlags() == rhs.getU8OperationFlags()));
}

inline bool T_TunerOperation::operator != (const T_TunerOperation& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerOperation::operator < (const T_TunerOperation& rhs) const {
    if (hasU8EnableOrDisable() || rhs.hasU8EnableOrDisable()) {
        if ((uint32)getU8EnableOrDisable() < (uint32)rhs.getU8EnableOrDisable()) return true;
        if ((uint32)getU8EnableOrDisable() > (uint32)rhs.getU8EnableOrDisable()) return false;
    }
    if (hasU8OperationFlags() || rhs.hasU8OperationFlags()) {
        if ((uint32)getU8OperationFlags() < (uint32)rhs.getU8OperationFlags()) return true;
        if ((uint32)getU8OperationFlags() > (uint32)rhs.getU8OperationFlags()) return false;
    }
    return false;
}

inline bool T_TunerOperation::operator > (const T_TunerOperation& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerOperation::clear() {
    clearU8EnableOrDisable();
    clearU8OperationFlags();
}

inline void T_TunerOperation::clearU8EnableOrDisable() {
    if (hasU8EnableOrDisable()) {
         clear_has_u8EnableOrDisable();
        _u8EnableOrDisable = ::midw_tuner_fi_types::T_e8_Tun_EnableOrDisable__DISABLE;
     }
}

inline bool T_TunerOperation::hasU8EnableOrDisable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_EnableOrDisable T_TunerOperation::getU8EnableOrDisable () const {
    return _u8EnableOrDisable;
}

inline void T_TunerOperation::setU8EnableOrDisable (T_e8_Tun_EnableOrDisable u8EnableOrDisable_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_EnableOrDisable_IsValid(u8EnableOrDisable_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8EnableOrDisable_, "T_e8_Tun_EnableOrDisable", "u8EnableOrDisable", "T_TunerOperation");
    }
    set_has_u8EnableOrDisable();
    this->_u8EnableOrDisable = u8EnableOrDisable_;
}

inline void T_TunerOperation::clearU8OperationFlags() {
    if (hasU8OperationFlags()) {
         clear_has_u8OperationFlags();
        _u8OperationFlags = ::midw_tuner_fi_types::T_e8_Tun_OperationFlags__TUN_OPERATION_AFBEST;
     }
}

inline bool T_TunerOperation::hasU8OperationFlags () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Tun_OperationFlags T_TunerOperation::getU8OperationFlags () const {
    return _u8OperationFlags;
}

inline void T_TunerOperation::setU8OperationFlags (T_e8_Tun_OperationFlags u8OperationFlags_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_OperationFlags_IsValid(u8OperationFlags_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8OperationFlags_, "T_e8_Tun_OperationFlags", "u8OperationFlags", "T_TunerOperation");
    }
    set_has_u8OperationFlags();
    this->_u8OperationFlags = u8OperationFlags_;
}

inline void T_TunerOperation::set_has_u8EnableOrDisable () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerOperation::clear_has_u8EnableOrDisable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerOperation::set_has_u8OperationFlags () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerOperation::clear_has_u8OperationFlags () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TunerAFList::T_TunerAFList ()  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8AFListElementID (0u),
    _u32AFFrequency (0u),
    _u8AFQualityLevel (0u),
    _u8AFFieldStrength (0u),
    _u8AFBitErrorRate (0u),
    _u8AFInfo (::midw_tuner_fi_types::T_e8_Tun_AFInformation__TUN_AF_UNKNOWN),
    _u16AFPI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerAFList::T_TunerAFList (const T_TunerAFList &rhs)  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8AFListElementID (0u),
    _u32AFFrequency (0u),
    _u8AFQualityLevel (0u),
    _u8AFFieldStrength (0u),
    _u8AFBitErrorRate (0u),
    _u8AFInfo (::midw_tuner_fi_types::T_e8_Tun_AFInformation__TUN_AF_UNKNOWN),
    _u16AFPI (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerAFList::T_TunerAFList (T_e8_Tun_TunerHeader u8TunerHeader_, uint8 u8AFListElementID_, uint32 u32AFFrequency_, uint8 u8AFQualityLevel_, uint8 u8AFFieldStrength_, uint8 u8AFBitErrorRate_, T_e8_Tun_AFInformation u8AFInfo_, uint16 u16AFPI_)  :
    _u8TunerHeader (u8TunerHeader_),
    _u8AFListElementID (u8AFListElementID_),
    _u32AFFrequency (u32AFFrequency_),
    _u8AFQualityLevel (u8AFQualityLevel_),
    _u8AFFieldStrength (u8AFFieldStrength_),
    _u8AFBitErrorRate (u8AFBitErrorRate_),
    _u8AFInfo (u8AFInfo_),
    _u16AFPI (u16AFPI_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_TunerAFList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AFInformation_IsValid(u8AFInfo_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AFInfo_, "T_e8_Tun_AFInformation", "u8AFInfo", "T_TunerAFList");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerAFList::~T_TunerAFList() {
}

inline T_TunerAFList& T_TunerAFList::operator = (const T_TunerAFList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TunerHeader()) {
            setU8TunerHeader(rhs.getU8TunerHeader());
        } else {
            clearU8TunerHeader();
        }
        if (rhs.hasU8AFListElementID()) {
            setU8AFListElementID(rhs.getU8AFListElementID());
        } else {
            clearU8AFListElementID();
        }
        if (rhs.hasU32AFFrequency()) {
            setU32AFFrequency(rhs.getU32AFFrequency());
        } else {
            clearU32AFFrequency();
        }
        if (rhs.hasU8AFQualityLevel()) {
            setU8AFQualityLevel(rhs.getU8AFQualityLevel());
        } else {
            clearU8AFQualityLevel();
        }
        if (rhs.hasU8AFFieldStrength()) {
            setU8AFFieldStrength(rhs.getU8AFFieldStrength());
        } else {
            clearU8AFFieldStrength();
        }
        if (rhs.hasU8AFBitErrorRate()) {
            setU8AFBitErrorRate(rhs.getU8AFBitErrorRate());
        } else {
            clearU8AFBitErrorRate();
        }
        if (rhs.hasU8AFInfo()) {
            setU8AFInfo(rhs.getU8AFInfo());
        } else {
            clearU8AFInfo();
        }
        if (rhs.hasU16AFPI()) {
            setU16AFPI(rhs.getU16AFPI());
        } else {
            clearU16AFPI();
        }
    }
    return *this;
}

inline bool T_TunerAFList::operator == (const T_TunerAFList& rhs) const {
    return (((!hasU8TunerHeader() && !rhs.hasU8TunerHeader()) || getU8TunerHeader() == rhs.getU8TunerHeader()) &&
        ((!hasU8AFListElementID() && !rhs.hasU8AFListElementID()) || getU8AFListElementID() == rhs.getU8AFListElementID()) &&
        ((!hasU32AFFrequency() && !rhs.hasU32AFFrequency()) || getU32AFFrequency() == rhs.getU32AFFrequency()) &&
        ((!hasU8AFQualityLevel() && !rhs.hasU8AFQualityLevel()) || getU8AFQualityLevel() == rhs.getU8AFQualityLevel()) &&
        ((!hasU8AFFieldStrength() && !rhs.hasU8AFFieldStrength()) || getU8AFFieldStrength() == rhs.getU8AFFieldStrength()) &&
        ((!hasU8AFBitErrorRate() && !rhs.hasU8AFBitErrorRate()) || getU8AFBitErrorRate() == rhs.getU8AFBitErrorRate()) &&
        ((!hasU8AFInfo() && !rhs.hasU8AFInfo()) || getU8AFInfo() == rhs.getU8AFInfo()) &&
        ((!hasU16AFPI() && !rhs.hasU16AFPI()) || getU16AFPI() == rhs.getU16AFPI()));
}

inline bool T_TunerAFList::operator != (const T_TunerAFList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerAFList::operator < (const T_TunerAFList& rhs) const {
    if (hasU8TunerHeader() || rhs.hasU8TunerHeader()) {
        if ((uint32)getU8TunerHeader() < (uint32)rhs.getU8TunerHeader()) return true;
        if ((uint32)getU8TunerHeader() > (uint32)rhs.getU8TunerHeader()) return false;
    }
    if (hasU8AFListElementID() || rhs.hasU8AFListElementID()) {
        if (getU8AFListElementID() < rhs.getU8AFListElementID()) return true;
        if (getU8AFListElementID() > rhs.getU8AFListElementID()) return false;
    }
    if (hasU32AFFrequency() || rhs.hasU32AFFrequency()) {
        if (getU32AFFrequency() < rhs.getU32AFFrequency()) return true;
        if (getU32AFFrequency() > rhs.getU32AFFrequency()) return false;
    }
    if (hasU8AFQualityLevel() || rhs.hasU8AFQualityLevel()) {
        if (getU8AFQualityLevel() < rhs.getU8AFQualityLevel()) return true;
        if (getU8AFQualityLevel() > rhs.getU8AFQualityLevel()) return false;
    }
    if (hasU8AFFieldStrength() || rhs.hasU8AFFieldStrength()) {
        if (getU8AFFieldStrength() < rhs.getU8AFFieldStrength()) return true;
        if (getU8AFFieldStrength() > rhs.getU8AFFieldStrength()) return false;
    }
    if (hasU8AFBitErrorRate() || rhs.hasU8AFBitErrorRate()) {
        if (getU8AFBitErrorRate() < rhs.getU8AFBitErrorRate()) return true;
        if (getU8AFBitErrorRate() > rhs.getU8AFBitErrorRate()) return false;
    }
    if (hasU8AFInfo() || rhs.hasU8AFInfo()) {
        if ((uint32)getU8AFInfo() < (uint32)rhs.getU8AFInfo()) return true;
        if ((uint32)getU8AFInfo() > (uint32)rhs.getU8AFInfo()) return false;
    }
    if (hasU16AFPI() || rhs.hasU16AFPI()) {
        if (getU16AFPI() < rhs.getU16AFPI()) return true;
        if (getU16AFPI() > rhs.getU16AFPI()) return false;
    }
    return false;
}

inline bool T_TunerAFList::operator > (const T_TunerAFList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerAFList::clear() {
    clearU8TunerHeader();
    clearU8AFListElementID();
    clearU32AFFrequency();
    clearU8AFQualityLevel();
    clearU8AFFieldStrength();
    clearU8AFBitErrorRate();
    clearU8AFInfo();
    clearU16AFPI();
}

inline void T_TunerAFList::clearU8TunerHeader() {
    if (hasU8TunerHeader()) {
         clear_has_u8TunerHeader();
        _u8TunerHeader = ::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool T_TunerAFList::hasU8TunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_TunerHeader T_TunerAFList::getU8TunerHeader () const {
    return _u8TunerHeader;
}

inline void T_TunerAFList::setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_TunerAFList");
    }
    set_has_u8TunerHeader();
    this->_u8TunerHeader = u8TunerHeader_;
}

inline void T_TunerAFList::clearU8AFListElementID() {
    if (hasU8AFListElementID()) {
         clear_has_u8AFListElementID();
        _u8AFListElementID = 0u;
     }
}

inline bool T_TunerAFList::hasU8AFListElementID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_TunerAFList::getU8AFListElementID () const {
    return _u8AFListElementID;
}

inline void T_TunerAFList::setU8AFListElementID (uint8 u8AFListElementID_) {
    set_has_u8AFListElementID();
    this->_u8AFListElementID = u8AFListElementID_;
}

inline void T_TunerAFList::clearU32AFFrequency() {
    if (hasU32AFFrequency()) {
         clear_has_u32AFFrequency();
        _u32AFFrequency = 0u;
     }
}

inline bool T_TunerAFList::hasU32AFFrequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_TunerAFList::getU32AFFrequency () const {
    return _u32AFFrequency;
}

inline void T_TunerAFList::setU32AFFrequency (uint32 u32AFFrequency_) {
    set_has_u32AFFrequency();
    this->_u32AFFrequency = u32AFFrequency_;
}

inline void T_TunerAFList::clearU8AFQualityLevel() {
    if (hasU8AFQualityLevel()) {
         clear_has_u8AFQualityLevel();
        _u8AFQualityLevel = 0u;
     }
}

inline bool T_TunerAFList::hasU8AFQualityLevel () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_TunerAFList::getU8AFQualityLevel () const {
    return _u8AFQualityLevel;
}

inline void T_TunerAFList::setU8AFQualityLevel (uint8 u8AFQualityLevel_) {
    set_has_u8AFQualityLevel();
    this->_u8AFQualityLevel = u8AFQualityLevel_;
}

inline void T_TunerAFList::clearU8AFFieldStrength() {
    if (hasU8AFFieldStrength()) {
         clear_has_u8AFFieldStrength();
        _u8AFFieldStrength = 0u;
     }
}

inline bool T_TunerAFList::hasU8AFFieldStrength () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TunerAFList::getU8AFFieldStrength () const {
    return _u8AFFieldStrength;
}

inline void T_TunerAFList::setU8AFFieldStrength (uint8 u8AFFieldStrength_) {
    set_has_u8AFFieldStrength();
    this->_u8AFFieldStrength = u8AFFieldStrength_;
}

inline void T_TunerAFList::clearU8AFBitErrorRate() {
    if (hasU8AFBitErrorRate()) {
         clear_has_u8AFBitErrorRate();
        _u8AFBitErrorRate = 0u;
     }
}

inline bool T_TunerAFList::hasU8AFBitErrorRate () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TunerAFList::getU8AFBitErrorRate () const {
    return _u8AFBitErrorRate;
}

inline void T_TunerAFList::setU8AFBitErrorRate (uint8 u8AFBitErrorRate_) {
    set_has_u8AFBitErrorRate();
    this->_u8AFBitErrorRate = u8AFBitErrorRate_;
}

inline void T_TunerAFList::clearU8AFInfo() {
    if (hasU8AFInfo()) {
         clear_has_u8AFInfo();
        _u8AFInfo = ::midw_tuner_fi_types::T_e8_Tun_AFInformation__TUN_AF_UNKNOWN;
     }
}

inline bool T_TunerAFList::hasU8AFInfo () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_Tun_AFInformation T_TunerAFList::getU8AFInfo () const {
    return _u8AFInfo;
}

inline void T_TunerAFList::setU8AFInfo (T_e8_Tun_AFInformation u8AFInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AFInformation_IsValid(u8AFInfo_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AFInfo_, "T_e8_Tun_AFInformation", "u8AFInfo", "T_TunerAFList");
    }
    set_has_u8AFInfo();
    this->_u8AFInfo = u8AFInfo_;
}

inline void T_TunerAFList::clearU16AFPI() {
    if (hasU16AFPI()) {
         clear_has_u16AFPI();
        _u16AFPI = 0u;
     }
}

inline bool T_TunerAFList::hasU16AFPI () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint16 T_TunerAFList::getU16AFPI () const {
    return _u16AFPI;
}

inline void T_TunerAFList::setU16AFPI (uint16 u16AFPI_) {
    set_has_u16AFPI();
    this->_u16AFPI = u16AFPI_;
}

inline void T_TunerAFList::set_has_u8TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerAFList::clear_has_u8TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerAFList::set_has_u8AFListElementID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerAFList::clear_has_u8AFListElementID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TunerAFList::set_has_u32AFFrequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TunerAFList::clear_has_u32AFFrequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TunerAFList::set_has_u8AFQualityLevel () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TunerAFList::clear_has_u8AFQualityLevel () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TunerAFList::set_has_u8AFFieldStrength () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TunerAFList::clear_has_u8AFFieldStrength () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TunerAFList::set_has_u8AFBitErrorRate () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TunerAFList::clear_has_u8AFBitErrorRate () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TunerAFList::set_has_u8AFInfo () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TunerAFList::clear_has_u8AFInfo () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TunerAFList::set_has_u16AFPI () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TunerAFList::clear_has_u16AFPI () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_b8_Tun_TestmodeBits::T_b8_Tun_TestmodeBits ()  :
    _TUN_TP_BIT (false),
    _TUN_TA_BIT (false),
    _TUN_TMC_BIT (false),
    _TUN_UNUSED_BIT (false),
    _TUN_AUDIO_TUNER_BIT (false)
{
}

inline  T_b8_Tun_TestmodeBits::T_b8_Tun_TestmodeBits (const T_b8_Tun_TestmodeBits &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_TestmodeBits::T_b8_Tun_TestmodeBits (bool TUN_TP_BIT, bool TUN_TA_BIT, bool TUN_TMC_BIT, bool TUN_UNUSED_BIT, bool TUN_AUDIO_TUNER_BIT) :
    _TUN_TP_BIT (TUN_TP_BIT),
    _TUN_TA_BIT (TUN_TA_BIT),
    _TUN_TMC_BIT (TUN_TMC_BIT),
    _TUN_UNUSED_BIT (TUN_UNUSED_BIT),
    _TUN_AUDIO_TUNER_BIT (TUN_AUDIO_TUNER_BIT)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_TestmodeBits& T_b8_Tun_TestmodeBits::operator = (const T_b8_Tun_TestmodeBits& rhs) {
    if( this != &rhs ) {
        _TUN_TP_BIT = rhs._TUN_TP_BIT;
        _TUN_TA_BIT = rhs._TUN_TA_BIT;
        _TUN_TMC_BIT = rhs._TUN_TMC_BIT;
        _TUN_UNUSED_BIT = rhs._TUN_UNUSED_BIT;
        _TUN_AUDIO_TUNER_BIT = rhs._TUN_AUDIO_TUNER_BIT;
    }
    return *this;
}

inline bool T_b8_Tun_TestmodeBits::operator == (const T_b8_Tun_TestmodeBits& rhs) const {
    return (_TUN_TP_BIT == rhs._TUN_TP_BIT &&
        _TUN_TA_BIT == rhs._TUN_TA_BIT &&
        _TUN_TMC_BIT == rhs._TUN_TMC_BIT &&
        _TUN_UNUSED_BIT == rhs._TUN_UNUSED_BIT &&
        _TUN_AUDIO_TUNER_BIT == rhs._TUN_AUDIO_TUNER_BIT);
}

inline bool T_b8_Tun_TestmodeBits::operator != (const T_b8_Tun_TestmodeBits& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_TestmodeBits::operator < (const T_b8_Tun_TestmodeBits& rhs) const {
    if (getTUN_TP_BIT() < rhs.getTUN_TP_BIT()) return true;
    if (getTUN_TP_BIT() > rhs.getTUN_TP_BIT()) return false;

    if (getTUN_TA_BIT() < rhs.getTUN_TA_BIT()) return true;
    if (getTUN_TA_BIT() > rhs.getTUN_TA_BIT()) return false;

    if (getTUN_TMC_BIT() < rhs.getTUN_TMC_BIT()) return true;
    if (getTUN_TMC_BIT() > rhs.getTUN_TMC_BIT()) return false;

    if (getTUN_UNUSED_BIT() < rhs.getTUN_UNUSED_BIT()) return true;
    if (getTUN_UNUSED_BIT() > rhs.getTUN_UNUSED_BIT()) return false;

    if (getTUN_AUDIO_TUNER_BIT() < rhs.getTUN_AUDIO_TUNER_BIT()) return true;
    if (getTUN_AUDIO_TUNER_BIT() > rhs.getTUN_AUDIO_TUNER_BIT()) return false;

    return false;
}

inline bool T_b8_Tun_TestmodeBits::operator > (const T_b8_Tun_TestmodeBits& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_TestmodeBits::setTUN_TP_BIT (bool TUN_TP_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_TP_BIT = TUN_TP_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_TestmodeBits::getTUN_TP_BIT () const {
    return _TUN_TP_BIT;
}

inline void T_b8_Tun_TestmodeBits::setTUN_TA_BIT (bool TUN_TA_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_TA_BIT = TUN_TA_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_TestmodeBits::getTUN_TA_BIT () const {
    return _TUN_TA_BIT;
}

inline void T_b8_Tun_TestmodeBits::setTUN_TMC_BIT (bool TUN_TMC_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_TMC_BIT = TUN_TMC_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_TestmodeBits::getTUN_TMC_BIT () const {
    return _TUN_TMC_BIT;
}

inline void T_b8_Tun_TestmodeBits::setTUN_UNUSED_BIT (bool TUN_UNUSED_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_UNUSED_BIT = TUN_UNUSED_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_TestmodeBits::getTUN_UNUSED_BIT () const {
    return _TUN_UNUSED_BIT;
}

inline void T_b8_Tun_TestmodeBits::setTUN_AUDIO_TUNER_BIT (bool TUN_AUDIO_TUNER_BIT) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_TUN_AUDIO_TUNER_BIT = TUN_AUDIO_TUNER_BIT;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_TestmodeBits::getTUN_AUDIO_TUNER_BIT () const {
    return _TUN_AUDIO_TUNER_BIT;
}

inline  T_TunerTestModeData::T_TunerTestModeData ()  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8AdditionalInfo (::midw_tuner_fi_types::T_e8_Tun_AdditionalInfo__TUN_RDS_SYNC),
    _u32AFFrequency (0u),
    _u32PI (0u),
    _u8Quality (0u),
    _u8Fieldstrength (0u),
    _u8Multipath (0u),
    _u8Neighbour (0u),
    _u8AFListLength (0u),
    _u8TestmodeBits (NULL),
    _u8TMCStationCount (0u),
    _u8TMCGroupState (::midw_tuner_fi_types::T_e8_Tun_TMCGroupState__TUN_NO_DATA_AVAILABLE),
    _u8AntennaState (::midw_tuner_fi_types::T_e8_Tun_AntennaState__TUN_PHANTOM_SUPPLY_OFF),
    _u8PSName1 (0u),
    _u8PSName2 (0u),
    _u8PSName3 (0u),
    _u8PSName4 (0u),
    _u8PSName5 (0u),
    _u8PSName6 (0u),
    _u8PSName7 (0u),
    _u8PSName8 (0u),
    _sPSName (NULL),
    _u8IFState (::midw_tuner_fi_types::T_e8_Tun_IfState__TUN_OFF),
    _u8ChannelSeparation (0u),
    _u8Hub (0u),
    _u8RdsErrorRate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TunerTestModeData::T_TunerTestModeData (const T_TunerTestModeData &rhs)  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _u8AdditionalInfo (::midw_tuner_fi_types::T_e8_Tun_AdditionalInfo__TUN_RDS_SYNC),
    _u32AFFrequency (0u),
    _u32PI (0u),
    _u8Quality (0u),
    _u8Fieldstrength (0u),
    _u8Multipath (0u),
    _u8Neighbour (0u),
    _u8AFListLength (0u),
    _u8TestmodeBits (NULL),
    _u8TMCStationCount (0u),
    _u8TMCGroupState (::midw_tuner_fi_types::T_e8_Tun_TMCGroupState__TUN_NO_DATA_AVAILABLE),
    _u8AntennaState (::midw_tuner_fi_types::T_e8_Tun_AntennaState__TUN_PHANTOM_SUPPLY_OFF),
    _u8PSName1 (0u),
    _u8PSName2 (0u),
    _u8PSName3 (0u),
    _u8PSName4 (0u),
    _u8PSName5 (0u),
    _u8PSName6 (0u),
    _u8PSName7 (0u),
    _u8PSName8 (0u),
    _sPSName (NULL),
    _u8IFState (::midw_tuner_fi_types::T_e8_Tun_IfState__TUN_OFF),
    _u8ChannelSeparation (0u),
    _u8Hub (0u),
    _u8RdsErrorRate (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TunerTestModeData::T_TunerTestModeData (T_e8_Tun_TunerHeader u8TunerHeader_, T_e8_Tun_AdditionalInfo u8AdditionalInfo_, uint32 u32AFFrequency_, uint32 u32PI_, uint8 u8Quality_, uint8 u8Fieldstrength_, uint8 u8Multipath_, uint8 u8Neighbour_, uint8 u8AFListLength_, const T_b8_Tun_TestmodeBits& u8TestmodeBits_, uint8 u8TMCStationCount_, T_e8_Tun_TMCGroupState u8TMCGroupState_, T_e8_Tun_AntennaState u8AntennaState_, uint8 u8PSName1_, uint8 u8PSName2_, uint8 u8PSName3_, uint8 u8PSName4_, uint8 u8PSName5_, uint8 u8PSName6_, uint8 u8PSName7_, uint8 u8PSName8_, const ::std::string& sPSName_, T_e8_Tun_IfState u8IFState_, uint8 u8ChannelSeparation_, uint8 u8Hub_, uint8 u8RdsErrorRate_)  :
    _u8TunerHeader (u8TunerHeader_),
    _u8AdditionalInfo (u8AdditionalInfo_),
    _u32AFFrequency (u32AFFrequency_),
    _u32PI (u32PI_),
    _u8Quality (u8Quality_),
    _u8Fieldstrength (u8Fieldstrength_),
    _u8Multipath (u8Multipath_),
    _u8Neighbour (u8Neighbour_),
    _u8AFListLength (u8AFListLength_),
    _u8TestmodeBits (new T_b8_Tun_TestmodeBits(u8TestmodeBits_)),
    _u8TMCStationCount (u8TMCStationCount_),
    _u8TMCGroupState (u8TMCGroupState_),
    _u8AntennaState (u8AntennaState_),
    _u8PSName1 (u8PSName1_),
    _u8PSName2 (u8PSName2_),
    _u8PSName3 (u8PSName3_),
    _u8PSName4 (u8PSName4_),
    _u8PSName5 (u8PSName5_),
    _u8PSName6 (u8PSName6_),
    _u8PSName7 (u8PSName7_),
    _u8PSName8 (u8PSName8_),
    _sPSName (new ::std::string(sPSName_)),
    _u8IFState (u8IFState_),
    _u8ChannelSeparation (u8ChannelSeparation_),
    _u8Hub (u8Hub_),
    _u8RdsErrorRate (u8RdsErrorRate_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_TunerTestModeData");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AdditionalInfo_IsValid(u8AdditionalInfo_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AdditionalInfo_, "T_e8_Tun_AdditionalInfo", "u8AdditionalInfo", "T_TunerTestModeData");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TMCGroupState_IsValid(u8TMCGroupState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TMCGroupState_, "T_e8_Tun_TMCGroupState", "u8TMCGroupState", "T_TunerTestModeData");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AntennaState_IsValid(u8AntennaState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AntennaState_, "T_e8_Tun_AntennaState", "u8AntennaState", "T_TunerTestModeData");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPSName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_IfState_IsValid(u8IFState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8IFState_, "T_e8_Tun_IfState", "u8IFState", "T_TunerTestModeData");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TunerTestModeData::~T_TunerTestModeData() {
    delete _u8TestmodeBits;
    delete _sPSName;
}

inline T_TunerTestModeData& T_TunerTestModeData::operator = (const T_TunerTestModeData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TunerHeader()) {
            setU8TunerHeader(rhs.getU8TunerHeader());
        } else {
            clearU8TunerHeader();
        }
        if (rhs.hasU8AdditionalInfo()) {
            setU8AdditionalInfo(rhs.getU8AdditionalInfo());
        } else {
            clearU8AdditionalInfo();
        }
        if (rhs.hasU32AFFrequency()) {
            setU32AFFrequency(rhs.getU32AFFrequency());
        } else {
            clearU32AFFrequency();
        }
        if (rhs.hasU32PI()) {
            setU32PI(rhs.getU32PI());
        } else {
            clearU32PI();
        }
        if (rhs.hasU8Quality()) {
            setU8Quality(rhs.getU8Quality());
        } else {
            clearU8Quality();
        }
        if (rhs.hasU8Fieldstrength()) {
            setU8Fieldstrength(rhs.getU8Fieldstrength());
        } else {
            clearU8Fieldstrength();
        }
        if (rhs.hasU8Multipath()) {
            setU8Multipath(rhs.getU8Multipath());
        } else {
            clearU8Multipath();
        }
        if (rhs.hasU8Neighbour()) {
            setU8Neighbour(rhs.getU8Neighbour());
        } else {
            clearU8Neighbour();
        }
        if (rhs.hasU8AFListLength()) {
            setU8AFListLength(rhs.getU8AFListLength());
        } else {
            clearU8AFListLength();
        }
        if (rhs.hasU8TestmodeBits()) {
            setU8TestmodeBits(rhs.getU8TestmodeBits());
        } else {
            clearU8TestmodeBits();
        }
        if (rhs.hasU8TMCStationCount()) {
            setU8TMCStationCount(rhs.getU8TMCStationCount());
        } else {
            clearU8TMCStationCount();
        }
        if (rhs.hasU8TMCGroupState()) {
            setU8TMCGroupState(rhs.getU8TMCGroupState());
        } else {
            clearU8TMCGroupState();
        }
        if (rhs.hasU8AntennaState()) {
            setU8AntennaState(rhs.getU8AntennaState());
        } else {
            clearU8AntennaState();
        }
        if (rhs.hasU8PSName1()) {
            setU8PSName1(rhs.getU8PSName1());
        } else {
            clearU8PSName1();
        }
        if (rhs.hasU8PSName2()) {
            setU8PSName2(rhs.getU8PSName2());
        } else {
            clearU8PSName2();
        }
        if (rhs.hasU8PSName3()) {
            setU8PSName3(rhs.getU8PSName3());
        } else {
            clearU8PSName3();
        }
        if (rhs.hasU8PSName4()) {
            setU8PSName4(rhs.getU8PSName4());
        } else {
            clearU8PSName4();
        }
        if (rhs.hasU8PSName5()) {
            setU8PSName5(rhs.getU8PSName5());
        } else {
            clearU8PSName5();
        }
        if (rhs.hasU8PSName6()) {
            setU8PSName6(rhs.getU8PSName6());
        } else {
            clearU8PSName6();
        }
        if (rhs.hasU8PSName7()) {
            setU8PSName7(rhs.getU8PSName7());
        } else {
            clearU8PSName7();
        }
        if (rhs.hasU8PSName8()) {
            setU8PSName8(rhs.getU8PSName8());
        } else {
            clearU8PSName8();
        }
        if (rhs.hasSPSName()) {
            setSPSName(rhs.getSPSName());
        } else {
            clearSPSName();
        }
        if (rhs.hasU8IFState()) {
            setU8IFState(rhs.getU8IFState());
        } else {
            clearU8IFState();
        }
        if (rhs.hasU8ChannelSeparation()) {
            setU8ChannelSeparation(rhs.getU8ChannelSeparation());
        } else {
            clearU8ChannelSeparation();
        }
        if (rhs.hasU8Hub()) {
            setU8Hub(rhs.getU8Hub());
        } else {
            clearU8Hub();
        }
        if (rhs.hasU8RdsErrorRate()) {
            setU8RdsErrorRate(rhs.getU8RdsErrorRate());
        } else {
            clearU8RdsErrorRate();
        }
    }
    return *this;
}

inline bool T_TunerTestModeData::operator == (const T_TunerTestModeData& rhs) const {
    return (((!hasU8TunerHeader() && !rhs.hasU8TunerHeader()) || getU8TunerHeader() == rhs.getU8TunerHeader()) &&
        ((!hasU8AdditionalInfo() && !rhs.hasU8AdditionalInfo()) || getU8AdditionalInfo() == rhs.getU8AdditionalInfo()) &&
        ((!hasU32AFFrequency() && !rhs.hasU32AFFrequency()) || getU32AFFrequency() == rhs.getU32AFFrequency()) &&
        ((!hasU32PI() && !rhs.hasU32PI()) || getU32PI() == rhs.getU32PI()) &&
        ((!hasU8Quality() && !rhs.hasU8Quality()) || getU8Quality() == rhs.getU8Quality()) &&
        ((!hasU8Fieldstrength() && !rhs.hasU8Fieldstrength()) || getU8Fieldstrength() == rhs.getU8Fieldstrength()) &&
        ((!hasU8Multipath() && !rhs.hasU8Multipath()) || getU8Multipath() == rhs.getU8Multipath()) &&
        ((!hasU8Neighbour() && !rhs.hasU8Neighbour()) || getU8Neighbour() == rhs.getU8Neighbour()) &&
        ((!hasU8AFListLength() && !rhs.hasU8AFListLength()) || getU8AFListLength() == rhs.getU8AFListLength()) &&
        ((!hasU8TestmodeBits() && !rhs.hasU8TestmodeBits()) || getU8TestmodeBits() == rhs.getU8TestmodeBits()) &&
        ((!hasU8TMCStationCount() && !rhs.hasU8TMCStationCount()) || getU8TMCStationCount() == rhs.getU8TMCStationCount()) &&
        ((!hasU8TMCGroupState() && !rhs.hasU8TMCGroupState()) || getU8TMCGroupState() == rhs.getU8TMCGroupState()) &&
        ((!hasU8AntennaState() && !rhs.hasU8AntennaState()) || getU8AntennaState() == rhs.getU8AntennaState()) &&
        ((!hasU8PSName1() && !rhs.hasU8PSName1()) || getU8PSName1() == rhs.getU8PSName1()) &&
        ((!hasU8PSName2() && !rhs.hasU8PSName2()) || getU8PSName2() == rhs.getU8PSName2()) &&
        ((!hasU8PSName3() && !rhs.hasU8PSName3()) || getU8PSName3() == rhs.getU8PSName3()) &&
        ((!hasU8PSName4() && !rhs.hasU8PSName4()) || getU8PSName4() == rhs.getU8PSName4()) &&
        ((!hasU8PSName5() && !rhs.hasU8PSName5()) || getU8PSName5() == rhs.getU8PSName5()) &&
        ((!hasU8PSName6() && !rhs.hasU8PSName6()) || getU8PSName6() == rhs.getU8PSName6()) &&
        ((!hasU8PSName7() && !rhs.hasU8PSName7()) || getU8PSName7() == rhs.getU8PSName7()) &&
        ((!hasU8PSName8() && !rhs.hasU8PSName8()) || getU8PSName8() == rhs.getU8PSName8()) &&
        ((!hasSPSName() && !rhs.hasSPSName()) || getSPSName() == rhs.getSPSName()) &&
        ((!hasU8IFState() && !rhs.hasU8IFState()) || getU8IFState() == rhs.getU8IFState()) &&
        ((!hasU8ChannelSeparation() && !rhs.hasU8ChannelSeparation()) || getU8ChannelSeparation() == rhs.getU8ChannelSeparation()) &&
        ((!hasU8Hub() && !rhs.hasU8Hub()) || getU8Hub() == rhs.getU8Hub()) &&
        ((!hasU8RdsErrorRate() && !rhs.hasU8RdsErrorRate()) || getU8RdsErrorRate() == rhs.getU8RdsErrorRate()));
}

inline bool T_TunerTestModeData::operator != (const T_TunerTestModeData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TunerTestModeData::operator < (const T_TunerTestModeData& rhs) const {
    if (hasU8TunerHeader() || rhs.hasU8TunerHeader()) {
        if ((uint32)getU8TunerHeader() < (uint32)rhs.getU8TunerHeader()) return true;
        if ((uint32)getU8TunerHeader() > (uint32)rhs.getU8TunerHeader()) return false;
    }
    if (hasU8AdditionalInfo() || rhs.hasU8AdditionalInfo()) {
        if ((uint32)getU8AdditionalInfo() < (uint32)rhs.getU8AdditionalInfo()) return true;
        if ((uint32)getU8AdditionalInfo() > (uint32)rhs.getU8AdditionalInfo()) return false;
    }
    if (hasU32AFFrequency() || rhs.hasU32AFFrequency()) {
        if (getU32AFFrequency() < rhs.getU32AFFrequency()) return true;
        if (getU32AFFrequency() > rhs.getU32AFFrequency()) return false;
    }
    if (hasU32PI() || rhs.hasU32PI()) {
        if (getU32PI() < rhs.getU32PI()) return true;
        if (getU32PI() > rhs.getU32PI()) return false;
    }
    if (hasU8Quality() || rhs.hasU8Quality()) {
        if (getU8Quality() < rhs.getU8Quality()) return true;
        if (getU8Quality() > rhs.getU8Quality()) return false;
    }
    if (hasU8Fieldstrength() || rhs.hasU8Fieldstrength()) {
        if (getU8Fieldstrength() < rhs.getU8Fieldstrength()) return true;
        if (getU8Fieldstrength() > rhs.getU8Fieldstrength()) return false;
    }
    if (hasU8Multipath() || rhs.hasU8Multipath()) {
        if (getU8Multipath() < rhs.getU8Multipath()) return true;
        if (getU8Multipath() > rhs.getU8Multipath()) return false;
    }
    if (hasU8Neighbour() || rhs.hasU8Neighbour()) {
        if (getU8Neighbour() < rhs.getU8Neighbour()) return true;
        if (getU8Neighbour() > rhs.getU8Neighbour()) return false;
    }
    if (hasU8AFListLength() || rhs.hasU8AFListLength()) {
        if (getU8AFListLength() < rhs.getU8AFListLength()) return true;
        if (getU8AFListLength() > rhs.getU8AFListLength()) return false;
    }
    if (hasU8TestmodeBits() || rhs.hasU8TestmodeBits()) {
        if (getU8TestmodeBits() < rhs.getU8TestmodeBits()) return true;
        if (getU8TestmodeBits() > rhs.getU8TestmodeBits()) return false;
    }
    if (hasU8TMCStationCount() || rhs.hasU8TMCStationCount()) {
        if (getU8TMCStationCount() < rhs.getU8TMCStationCount()) return true;
        if (getU8TMCStationCount() > rhs.getU8TMCStationCount()) return false;
    }
    if (hasU8TMCGroupState() || rhs.hasU8TMCGroupState()) {
        if ((uint32)getU8TMCGroupState() < (uint32)rhs.getU8TMCGroupState()) return true;
        if ((uint32)getU8TMCGroupState() > (uint32)rhs.getU8TMCGroupState()) return false;
    }
    if (hasU8AntennaState() || rhs.hasU8AntennaState()) {
        if ((uint32)getU8AntennaState() < (uint32)rhs.getU8AntennaState()) return true;
        if ((uint32)getU8AntennaState() > (uint32)rhs.getU8AntennaState()) return false;
    }
    if (hasU8PSName1() || rhs.hasU8PSName1()) {
        if (getU8PSName1() < rhs.getU8PSName1()) return true;
        if (getU8PSName1() > rhs.getU8PSName1()) return false;
    }
    if (hasU8PSName2() || rhs.hasU8PSName2()) {
        if (getU8PSName2() < rhs.getU8PSName2()) return true;
        if (getU8PSName2() > rhs.getU8PSName2()) return false;
    }
    if (hasU8PSName3() || rhs.hasU8PSName3()) {
        if (getU8PSName3() < rhs.getU8PSName3()) return true;
        if (getU8PSName3() > rhs.getU8PSName3()) return false;
    }
    if (hasU8PSName4() || rhs.hasU8PSName4()) {
        if (getU8PSName4() < rhs.getU8PSName4()) return true;
        if (getU8PSName4() > rhs.getU8PSName4()) return false;
    }
    if (hasU8PSName5() || rhs.hasU8PSName5()) {
        if (getU8PSName5() < rhs.getU8PSName5()) return true;
        if (getU8PSName5() > rhs.getU8PSName5()) return false;
    }
    if (hasU8PSName6() || rhs.hasU8PSName6()) {
        if (getU8PSName6() < rhs.getU8PSName6()) return true;
        if (getU8PSName6() > rhs.getU8PSName6()) return false;
    }
    if (hasU8PSName7() || rhs.hasU8PSName7()) {
        if (getU8PSName7() < rhs.getU8PSName7()) return true;
        if (getU8PSName7() > rhs.getU8PSName7()) return false;
    }
    if (hasU8PSName8() || rhs.hasU8PSName8()) {
        if (getU8PSName8() < rhs.getU8PSName8()) return true;
        if (getU8PSName8() > rhs.getU8PSName8()) return false;
    }
    if (hasSPSName() || rhs.hasSPSName()) {
        if (getSPSName() < rhs.getSPSName()) return true;
        if (getSPSName() > rhs.getSPSName()) return false;
    }
    if (hasU8IFState() || rhs.hasU8IFState()) {
        if ((uint32)getU8IFState() < (uint32)rhs.getU8IFState()) return true;
        if ((uint32)getU8IFState() > (uint32)rhs.getU8IFState()) return false;
    }
    if (hasU8ChannelSeparation() || rhs.hasU8ChannelSeparation()) {
        if (getU8ChannelSeparation() < rhs.getU8ChannelSeparation()) return true;
        if (getU8ChannelSeparation() > rhs.getU8ChannelSeparation()) return false;
    }
    if (hasU8Hub() || rhs.hasU8Hub()) {
        if (getU8Hub() < rhs.getU8Hub()) return true;
        if (getU8Hub() > rhs.getU8Hub()) return false;
    }
    if (hasU8RdsErrorRate() || rhs.hasU8RdsErrorRate()) {
        if (getU8RdsErrorRate() < rhs.getU8RdsErrorRate()) return true;
        if (getU8RdsErrorRate() > rhs.getU8RdsErrorRate()) return false;
    }
    return false;
}

inline bool T_TunerTestModeData::operator > (const T_TunerTestModeData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TunerTestModeData::clear() {
    clearU8TunerHeader();
    clearU8AdditionalInfo();
    clearU32AFFrequency();
    clearU32PI();
    clearU8Quality();
    clearU8Fieldstrength();
    clearU8Multipath();
    clearU8Neighbour();
    clearU8AFListLength();
    clearU8TestmodeBits();
    clearU8TMCStationCount();
    clearU8TMCGroupState();
    clearU8AntennaState();
    clearU8PSName1();
    clearU8PSName2();
    clearU8PSName3();
    clearU8PSName4();
    clearU8PSName5();
    clearU8PSName6();
    clearU8PSName7();
    clearU8PSName8();
    clearSPSName();
    clearU8IFState();
    clearU8ChannelSeparation();
    clearU8Hub();
    clearU8RdsErrorRate();
}

inline void T_TunerTestModeData::clearU8TunerHeader() {
    if (hasU8TunerHeader()) {
         clear_has_u8TunerHeader();
        _u8TunerHeader = ::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool T_TunerTestModeData::hasU8TunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_TunerHeader T_TunerTestModeData::getU8TunerHeader () const {
    return _u8TunerHeader;
}

inline void T_TunerTestModeData::setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_TunerTestModeData");
    }
    set_has_u8TunerHeader();
    this->_u8TunerHeader = u8TunerHeader_;
}

inline void T_TunerTestModeData::clearU8AdditionalInfo() {
    if (hasU8AdditionalInfo()) {
         clear_has_u8AdditionalInfo();
        _u8AdditionalInfo = ::midw_tuner_fi_types::T_e8_Tun_AdditionalInfo__TUN_RDS_SYNC;
     }
}

inline bool T_TunerTestModeData::hasU8AdditionalInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Tun_AdditionalInfo T_TunerTestModeData::getU8AdditionalInfo () const {
    return _u8AdditionalInfo;
}

inline void T_TunerTestModeData::setU8AdditionalInfo (T_e8_Tun_AdditionalInfo u8AdditionalInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AdditionalInfo_IsValid(u8AdditionalInfo_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AdditionalInfo_, "T_e8_Tun_AdditionalInfo", "u8AdditionalInfo", "T_TunerTestModeData");
    }
    set_has_u8AdditionalInfo();
    this->_u8AdditionalInfo = u8AdditionalInfo_;
}

inline void T_TunerTestModeData::clearU32AFFrequency() {
    if (hasU32AFFrequency()) {
         clear_has_u32AFFrequency();
        _u32AFFrequency = 0u;
     }
}

inline bool T_TunerTestModeData::hasU32AFFrequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_TunerTestModeData::getU32AFFrequency () const {
    return _u32AFFrequency;
}

inline void T_TunerTestModeData::setU32AFFrequency (uint32 u32AFFrequency_) {
    set_has_u32AFFrequency();
    this->_u32AFFrequency = u32AFFrequency_;
}

inline void T_TunerTestModeData::clearU32PI() {
    if (hasU32PI()) {
         clear_has_u32PI();
        _u32PI = 0u;
     }
}

inline bool T_TunerTestModeData::hasU32PI () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_TunerTestModeData::getU32PI () const {
    return _u32PI;
}

inline void T_TunerTestModeData::setU32PI (uint32 u32PI_) {
    set_has_u32PI();
    this->_u32PI = u32PI_;
}

inline void T_TunerTestModeData::clearU8Quality() {
    if (hasU8Quality()) {
         clear_has_u8Quality();
        _u8Quality = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8Quality () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_TunerTestModeData::getU8Quality () const {
    return _u8Quality;
}

inline void T_TunerTestModeData::setU8Quality (uint8 u8Quality_) {
    set_has_u8Quality();
    this->_u8Quality = u8Quality_;
}

inline void T_TunerTestModeData::clearU8Fieldstrength() {
    if (hasU8Fieldstrength()) {
         clear_has_u8Fieldstrength();
        _u8Fieldstrength = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8Fieldstrength () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_TunerTestModeData::getU8Fieldstrength () const {
    return _u8Fieldstrength;
}

inline void T_TunerTestModeData::setU8Fieldstrength (uint8 u8Fieldstrength_) {
    set_has_u8Fieldstrength();
    this->_u8Fieldstrength = u8Fieldstrength_;
}

inline void T_TunerTestModeData::clearU8Multipath() {
    if (hasU8Multipath()) {
         clear_has_u8Multipath();
        _u8Multipath = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8Multipath () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_TunerTestModeData::getU8Multipath () const {
    return _u8Multipath;
}

inline void T_TunerTestModeData::setU8Multipath (uint8 u8Multipath_) {
    set_has_u8Multipath();
    this->_u8Multipath = u8Multipath_;
}

inline void T_TunerTestModeData::clearU8Neighbour() {
    if (hasU8Neighbour()) {
         clear_has_u8Neighbour();
        _u8Neighbour = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8Neighbour () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_TunerTestModeData::getU8Neighbour () const {
    return _u8Neighbour;
}

inline void T_TunerTestModeData::setU8Neighbour (uint8 u8Neighbour_) {
    set_has_u8Neighbour();
    this->_u8Neighbour = u8Neighbour_;
}

inline void T_TunerTestModeData::clearU8AFListLength() {
    if (hasU8AFListLength()) {
         clear_has_u8AFListLength();
        _u8AFListLength = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8AFListLength () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline uint8 T_TunerTestModeData::getU8AFListLength () const {
    return _u8AFListLength;
}

inline void T_TunerTestModeData::setU8AFListLength (uint8 u8AFListLength_) {
    set_has_u8AFListLength();
    this->_u8AFListLength = u8AFListLength_;
}

inline void T_TunerTestModeData::clearU8TestmodeBits() {
    if (hasU8TestmodeBits()) {
         clear_has_u8TestmodeBits();
        delete _u8TestmodeBits;
        _u8TestmodeBits = NULL;
     }
}

inline bool T_TunerTestModeData::hasU8TestmodeBits () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline const T_b8_Tun_TestmodeBits& T_TunerTestModeData::getU8TestmodeBits () const {
    if (_u8TestmodeBits == NULL) {
        return T_b8_Tun_TestmodeBits::getDefaultInstance();
    }
    return *_u8TestmodeBits;
}

inline T_b8_Tun_TestmodeBits& T_TunerTestModeData::getU8TestmodeBitsMutable () {
    set_has_u8TestmodeBits();
    if (_u8TestmodeBits == NULL) {
        _u8TestmodeBits = new T_b8_Tun_TestmodeBits ();
        CHECK_ALLOCATION( _u8TestmodeBits );
    }
    return *_u8TestmodeBits;
}

inline void T_TunerTestModeData::setU8TestmodeBits (const T_b8_Tun_TestmodeBits& u8TestmodeBits_) {
    set_has_u8TestmodeBits();
    if (this->_u8TestmodeBits == NULL) {
        this->_u8TestmodeBits = new T_b8_Tun_TestmodeBits (u8TestmodeBits_);
        CHECK_ALLOCATION( this->_u8TestmodeBits );
    } else {
        *this->_u8TestmodeBits = u8TestmodeBits_;
    }
}

inline T_b8_Tun_TestmodeBits* T_TunerTestModeData::releaseU8TestmodeBits() {
    clear_has_u8TestmodeBits();
    T_b8_Tun_TestmodeBits* temp = _u8TestmodeBits;
    this->_u8TestmodeBits = NULL;
    return temp;
}

inline void T_TunerTestModeData::replaceU8TestmodeBits (T_b8_Tun_TestmodeBits* u8TestmodeBits_) {
    set_has_u8TestmodeBits();
    if (this->_u8TestmodeBits != u8TestmodeBits_) {
        if (this->_u8TestmodeBits != NULL) {
            delete this->_u8TestmodeBits;
        }
        this->_u8TestmodeBits = u8TestmodeBits_;
    }
}

inline void T_TunerTestModeData::clearU8TMCStationCount() {
    if (hasU8TMCStationCount()) {
         clear_has_u8TMCStationCount();
        _u8TMCStationCount = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8TMCStationCount () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline uint8 T_TunerTestModeData::getU8TMCStationCount () const {
    return _u8TMCStationCount;
}

inline void T_TunerTestModeData::setU8TMCStationCount (uint8 u8TMCStationCount_) {
    set_has_u8TMCStationCount();
    this->_u8TMCStationCount = u8TMCStationCount_;
}

inline void T_TunerTestModeData::clearU8TMCGroupState() {
    if (hasU8TMCGroupState()) {
         clear_has_u8TMCGroupState();
        _u8TMCGroupState = ::midw_tuner_fi_types::T_e8_Tun_TMCGroupState__TUN_NO_DATA_AVAILABLE;
     }
}

inline bool T_TunerTestModeData::hasU8TMCGroupState () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline T_e8_Tun_TMCGroupState T_TunerTestModeData::getU8TMCGroupState () const {
    return _u8TMCGroupState;
}

inline void T_TunerTestModeData::setU8TMCGroupState (T_e8_Tun_TMCGroupState u8TMCGroupState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TMCGroupState_IsValid(u8TMCGroupState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TMCGroupState_, "T_e8_Tun_TMCGroupState", "u8TMCGroupState", "T_TunerTestModeData");
    }
    set_has_u8TMCGroupState();
    this->_u8TMCGroupState = u8TMCGroupState_;
}

inline void T_TunerTestModeData::clearU8AntennaState() {
    if (hasU8AntennaState()) {
         clear_has_u8AntennaState();
        _u8AntennaState = ::midw_tuner_fi_types::T_e8_Tun_AntennaState__TUN_PHANTOM_SUPPLY_OFF;
     }
}

inline bool T_TunerTestModeData::hasU8AntennaState () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline T_e8_Tun_AntennaState T_TunerTestModeData::getU8AntennaState () const {
    return _u8AntennaState;
}

inline void T_TunerTestModeData::setU8AntennaState (T_e8_Tun_AntennaState u8AntennaState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_AntennaState_IsValid(u8AntennaState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8AntennaState_, "T_e8_Tun_AntennaState", "u8AntennaState", "T_TunerTestModeData");
    }
    set_has_u8AntennaState();
    this->_u8AntennaState = u8AntennaState_;
}

inline void T_TunerTestModeData::clearU8PSName1() {
    if (hasU8PSName1()) {
         clear_has_u8PSName1();
        _u8PSName1 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName1 () const {
    return (_has_bits_[0] & (1u << 13)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName1 () const {
    return _u8PSName1;
}

inline void T_TunerTestModeData::setU8PSName1 (uint8 u8PSName1_) {
    set_has_u8PSName1();
    this->_u8PSName1 = u8PSName1_;
}

inline void T_TunerTestModeData::clearU8PSName2() {
    if (hasU8PSName2()) {
         clear_has_u8PSName2();
        _u8PSName2 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName2 () const {
    return (_has_bits_[0] & (1u << 14)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName2 () const {
    return _u8PSName2;
}

inline void T_TunerTestModeData::setU8PSName2 (uint8 u8PSName2_) {
    set_has_u8PSName2();
    this->_u8PSName2 = u8PSName2_;
}

inline void T_TunerTestModeData::clearU8PSName3() {
    if (hasU8PSName3()) {
         clear_has_u8PSName3();
        _u8PSName3 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName3 () const {
    return (_has_bits_[0] & (1u << 15)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName3 () const {
    return _u8PSName3;
}

inline void T_TunerTestModeData::setU8PSName3 (uint8 u8PSName3_) {
    set_has_u8PSName3();
    this->_u8PSName3 = u8PSName3_;
}

inline void T_TunerTestModeData::clearU8PSName4() {
    if (hasU8PSName4()) {
         clear_has_u8PSName4();
        _u8PSName4 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName4 () const {
    return (_has_bits_[0] & (1u << 16)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName4 () const {
    return _u8PSName4;
}

inline void T_TunerTestModeData::setU8PSName4 (uint8 u8PSName4_) {
    set_has_u8PSName4();
    this->_u8PSName4 = u8PSName4_;
}

inline void T_TunerTestModeData::clearU8PSName5() {
    if (hasU8PSName5()) {
         clear_has_u8PSName5();
        _u8PSName5 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName5 () const {
    return (_has_bits_[0] & (1u << 17)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName5 () const {
    return _u8PSName5;
}

inline void T_TunerTestModeData::setU8PSName5 (uint8 u8PSName5_) {
    set_has_u8PSName5();
    this->_u8PSName5 = u8PSName5_;
}

inline void T_TunerTestModeData::clearU8PSName6() {
    if (hasU8PSName6()) {
         clear_has_u8PSName6();
        _u8PSName6 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName6 () const {
    return (_has_bits_[0] & (1u << 18)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName6 () const {
    return _u8PSName6;
}

inline void T_TunerTestModeData::setU8PSName6 (uint8 u8PSName6_) {
    set_has_u8PSName6();
    this->_u8PSName6 = u8PSName6_;
}

inline void T_TunerTestModeData::clearU8PSName7() {
    if (hasU8PSName7()) {
         clear_has_u8PSName7();
        _u8PSName7 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName7 () const {
    return (_has_bits_[0] & (1u << 19)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName7 () const {
    return _u8PSName7;
}

inline void T_TunerTestModeData::setU8PSName7 (uint8 u8PSName7_) {
    set_has_u8PSName7();
    this->_u8PSName7 = u8PSName7_;
}

inline void T_TunerTestModeData::clearU8PSName8() {
    if (hasU8PSName8()) {
         clear_has_u8PSName8();
        _u8PSName8 = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8PSName8 () const {
    return (_has_bits_[0] & (1u << 20)) > 0;
}

inline uint8 T_TunerTestModeData::getU8PSName8 () const {
    return _u8PSName8;
}

inline void T_TunerTestModeData::setU8PSName8 (uint8 u8PSName8_) {
    set_has_u8PSName8();
    this->_u8PSName8 = u8PSName8_;
}

inline void T_TunerTestModeData::clearSPSName() {
    if (hasSPSName()) {
         clear_has_sPSName();
        if (_sPSName != NULL) {
            _sPSName->clear();
        }
     }
}

inline bool T_TunerTestModeData::hasSPSName () const {
    return (_has_bits_[0] & (1u << 21)) > 0;
}

inline const ::std::string& T_TunerTestModeData::getSPSName () const {
    if (_sPSName == NULL) {
        return ::asf::core::theEmptyString;
    }
    return *_sPSName;
}

inline ::std::string& T_TunerTestModeData::getSPSNameMutable () {
    set_has_sPSName();
    if (_sPSName == NULL) {
        _sPSName = new ::std::string ();
        CHECK_ALLOCATION( _sPSName );
    }
    return *_sPSName;
}

inline void T_TunerTestModeData::setSPSName (const ::std::string& sPSName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPSName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPSName();
    if (this->_sPSName == NULL) {
        this->_sPSName = new ::std::string (sPSName_);
        CHECK_ALLOCATION( this->_sPSName );
    } else {
        *this->_sPSName = sPSName_;
    }
}

inline void T_TunerTestModeData::setSPSName (const char* sPSName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (sPSName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPSName();
    if (this->_sPSName == NULL) {
        this->_sPSName = new ::std::string (sPSName_);
        CHECK_ALLOCATION( this->_sPSName );
    } else {
        this->_sPSName->assign(sPSName_);
    }
}

inline void T_TunerTestModeData::setSPSName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_sPSName();
    if (this->_sPSName == NULL) {
        this->_sPSName = new ::std::string (value, size);
        CHECK_ALLOCATION( this->_sPSName );
    } else {
        this->_sPSName->assign(value, size);
    }
}

inline ::std::string* T_TunerTestModeData::releaseSPSName() {
    clear_has_sPSName();
    ::std::string* temp = _sPSName;
    this->_sPSName = NULL;
    return temp;
}

inline void T_TunerTestModeData::replaceSPSName (::std::string* sPSName_) {
    set_has_sPSName();
    if (this->_sPSName != sPSName_) {
        if (this->_sPSName != NULL) {
            delete this->_sPSName;
        }
        this->_sPSName = sPSName_;
    }
}

inline void T_TunerTestModeData::clearU8IFState() {
    if (hasU8IFState()) {
         clear_has_u8IFState();
        _u8IFState = ::midw_tuner_fi_types::T_e8_Tun_IfState__TUN_OFF;
     }
}

inline bool T_TunerTestModeData::hasU8IFState () const {
    return (_has_bits_[0] & (1u << 22)) > 0;
}

inline T_e8_Tun_IfState T_TunerTestModeData::getU8IFState () const {
    return _u8IFState;
}

inline void T_TunerTestModeData::setU8IFState (T_e8_Tun_IfState u8IFState_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_IfState_IsValid(u8IFState_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8IFState_, "T_e8_Tun_IfState", "u8IFState", "T_TunerTestModeData");
    }
    set_has_u8IFState();
    this->_u8IFState = u8IFState_;
}

inline void T_TunerTestModeData::clearU8ChannelSeparation() {
    if (hasU8ChannelSeparation()) {
         clear_has_u8ChannelSeparation();
        _u8ChannelSeparation = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8ChannelSeparation () const {
    return (_has_bits_[0] & (1u << 23)) > 0;
}

inline uint8 T_TunerTestModeData::getU8ChannelSeparation () const {
    return _u8ChannelSeparation;
}

inline void T_TunerTestModeData::setU8ChannelSeparation (uint8 u8ChannelSeparation_) {
    set_has_u8ChannelSeparation();
    this->_u8ChannelSeparation = u8ChannelSeparation_;
}

inline void T_TunerTestModeData::clearU8Hub() {
    if (hasU8Hub()) {
         clear_has_u8Hub();
        _u8Hub = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8Hub () const {
    return (_has_bits_[0] & (1u << 24)) > 0;
}

inline uint8 T_TunerTestModeData::getU8Hub () const {
    return _u8Hub;
}

inline void T_TunerTestModeData::setU8Hub (uint8 u8Hub_) {
    set_has_u8Hub();
    this->_u8Hub = u8Hub_;
}

inline void T_TunerTestModeData::clearU8RdsErrorRate() {
    if (hasU8RdsErrorRate()) {
         clear_has_u8RdsErrorRate();
        _u8RdsErrorRate = 0u;
     }
}

inline bool T_TunerTestModeData::hasU8RdsErrorRate () const {
    return (_has_bits_[0] & (1u << 25)) > 0;
}

inline uint8 T_TunerTestModeData::getU8RdsErrorRate () const {
    return _u8RdsErrorRate;
}

inline void T_TunerTestModeData::setU8RdsErrorRate (uint8 u8RdsErrorRate_) {
    set_has_u8RdsErrorRate();
    this->_u8RdsErrorRate = u8RdsErrorRate_;
}

inline void T_TunerTestModeData::set_has_u8TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TunerTestModeData::clear_has_u8TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TunerTestModeData::set_has_u8AdditionalInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TunerTestModeData::clear_has_u8AdditionalInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TunerTestModeData::set_has_u32AFFrequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TunerTestModeData::clear_has_u32AFFrequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_TunerTestModeData::set_has_u32PI () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_TunerTestModeData::clear_has_u32PI () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_TunerTestModeData::set_has_u8Quality () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_TunerTestModeData::clear_has_u8Quality () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_TunerTestModeData::set_has_u8Fieldstrength () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_TunerTestModeData::clear_has_u8Fieldstrength () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_TunerTestModeData::set_has_u8Multipath () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_TunerTestModeData::clear_has_u8Multipath () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_TunerTestModeData::set_has_u8Neighbour () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_TunerTestModeData::clear_has_u8Neighbour () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void T_TunerTestModeData::set_has_u8AFListLength () {
    _has_bits_[0] |= 1u << 8;
}

inline void T_TunerTestModeData::clear_has_u8AFListLength () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void T_TunerTestModeData::set_has_u8TestmodeBits () {
    _has_bits_[0] |= 1u << 9;
}

inline void T_TunerTestModeData::clear_has_u8TestmodeBits () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void T_TunerTestModeData::set_has_u8TMCStationCount () {
    _has_bits_[0] |= 1u << 10;
}

inline void T_TunerTestModeData::clear_has_u8TMCStationCount () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void T_TunerTestModeData::set_has_u8TMCGroupState () {
    _has_bits_[0] |= 1u << 11;
}

inline void T_TunerTestModeData::clear_has_u8TMCGroupState () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void T_TunerTestModeData::set_has_u8AntennaState () {
    _has_bits_[0] |= 1u << 12;
}

inline void T_TunerTestModeData::clear_has_u8AntennaState () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline void T_TunerTestModeData::set_has_u8PSName1 () {
    _has_bits_[0] |= 1u << 13;
}

inline void T_TunerTestModeData::clear_has_u8PSName1 () {
    _has_bits_[0] &= ~ (1u << 13);
}

inline void T_TunerTestModeData::set_has_u8PSName2 () {
    _has_bits_[0] |= 1u << 14;
}

inline void T_TunerTestModeData::clear_has_u8PSName2 () {
    _has_bits_[0] &= ~ (1u << 14);
}

inline void T_TunerTestModeData::set_has_u8PSName3 () {
    _has_bits_[0] |= 1u << 15;
}

inline void T_TunerTestModeData::clear_has_u8PSName3 () {
    _has_bits_[0] &= ~ (1u << 15);
}

inline void T_TunerTestModeData::set_has_u8PSName4 () {
    _has_bits_[0] |= 1u << 16;
}

inline void T_TunerTestModeData::clear_has_u8PSName4 () {
    _has_bits_[0] &= ~ (1u << 16);
}

inline void T_TunerTestModeData::set_has_u8PSName5 () {
    _has_bits_[0] |= 1u << 17;
}

inline void T_TunerTestModeData::clear_has_u8PSName5 () {
    _has_bits_[0] &= ~ (1u << 17);
}

inline void T_TunerTestModeData::set_has_u8PSName6 () {
    _has_bits_[0] |= 1u << 18;
}

inline void T_TunerTestModeData::clear_has_u8PSName6 () {
    _has_bits_[0] &= ~ (1u << 18);
}

inline void T_TunerTestModeData::set_has_u8PSName7 () {
    _has_bits_[0] |= 1u << 19;
}

inline void T_TunerTestModeData::clear_has_u8PSName7 () {
    _has_bits_[0] &= ~ (1u << 19);
}

inline void T_TunerTestModeData::set_has_u8PSName8 () {
    _has_bits_[0] |= 1u << 20;
}

inline void T_TunerTestModeData::clear_has_u8PSName8 () {
    _has_bits_[0] &= ~ (1u << 20);
}

inline void T_TunerTestModeData::set_has_sPSName () {
    _has_bits_[0] |= 1u << 21;
}

inline void T_TunerTestModeData::clear_has_sPSName () {
    _has_bits_[0] &= ~ (1u << 21);
}

inline void T_TunerTestModeData::set_has_u8IFState () {
    _has_bits_[0] |= 1u << 22;
}

inline void T_TunerTestModeData::clear_has_u8IFState () {
    _has_bits_[0] &= ~ (1u << 22);
}

inline void T_TunerTestModeData::set_has_u8ChannelSeparation () {
    _has_bits_[0] |= 1u << 23;
}

inline void T_TunerTestModeData::clear_has_u8ChannelSeparation () {
    _has_bits_[0] &= ~ (1u << 23);
}

inline void T_TunerTestModeData::set_has_u8Hub () {
    _has_bits_[0] |= 1u << 24;
}

inline void T_TunerTestModeData::clear_has_u8Hub () {
    _has_bits_[0] &= ~ (1u << 24);
}

inline void T_TunerTestModeData::set_has_u8RdsErrorRate () {
    _has_bits_[0] |= 1u << 25;
}

inline void T_TunerTestModeData::clear_has_u8RdsErrorRate () {
    _has_bits_[0] &= ~ (1u << 25);
}

inline  T_Sel_List_Elem::T_Sel_List_Elem ()  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _eConfigListID (::midw_tuner_fi_types::T_e8_Tun_ConfigListID__TUN_TUN_CONFIG_LIST_FM),
    _u32Frequency (0u),
    _u16PICode (0u),
    _u8ListElementID (0u),
    _u8Listtype (::midw_tuner_fi_types::T_e8_Tun_ListType__TUN_LIST_TYPE_STATIC),
    _u32HDStnID_DRMSrvID (0u),
    _e8ModulationType (::midw_tuner_fi_types::T_e8_Tun_ModulationType__TUN_MODULATION_ANALOG)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Sel_List_Elem::T_Sel_List_Elem (const T_Sel_List_Elem &rhs)  :
    _u8TunerHeader (::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND),
    _eConfigListID (::midw_tuner_fi_types::T_e8_Tun_ConfigListID__TUN_TUN_CONFIG_LIST_FM),
    _u32Frequency (0u),
    _u16PICode (0u),
    _u8ListElementID (0u),
    _u8Listtype (::midw_tuner_fi_types::T_e8_Tun_ListType__TUN_LIST_TYPE_STATIC),
    _u32HDStnID_DRMSrvID (0u),
    _e8ModulationType (::midw_tuner_fi_types::T_e8_Tun_ModulationType__TUN_MODULATION_ANALOG)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Sel_List_Elem::T_Sel_List_Elem (T_e8_Tun_TunerHeader u8TunerHeader_, T_e8_Tun_ConfigListID eConfigListID_, uint32 u32Frequency_, uint16 u16PICode_, uint8 u8ListElementID_, T_e8_Tun_ListType u8Listtype_, uint32 u32HDStnID_DRMSrvID_, T_e8_Tun_ModulationType e8ModulationType_)  :
    _u8TunerHeader (u8TunerHeader_),
    _eConfigListID (eConfigListID_),
    _u32Frequency (u32Frequency_),
    _u16PICode (u16PICode_),
    _u8ListElementID (u8ListElementID_),
    _u8Listtype (u8Listtype_),
    _u32HDStnID_DRMSrvID (u32HDStnID_DRMSrvID_),
    _e8ModulationType (e8ModulationType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_Sel_List_Elem");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ConfigListID_IsValid(eConfigListID_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", eConfigListID_, "T_e8_Tun_ConfigListID", "eConfigListID", "T_Sel_List_Elem");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ListType_IsValid(u8Listtype_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Listtype_, "T_e8_Tun_ListType", "u8Listtype", "T_Sel_List_Elem");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ModulationType_IsValid(e8ModulationType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ModulationType_, "T_e8_Tun_ModulationType", "e8ModulationType", "T_Sel_List_Elem");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Sel_List_Elem::~T_Sel_List_Elem() {
}

inline T_Sel_List_Elem& T_Sel_List_Elem::operator = (const T_Sel_List_Elem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8TunerHeader()) {
            setU8TunerHeader(rhs.getU8TunerHeader());
        } else {
            clearU8TunerHeader();
        }
        if (rhs.hasEConfigListID()) {
            setEConfigListID(rhs.getEConfigListID());
        } else {
            clearEConfigListID();
        }
        if (rhs.hasU32Frequency()) {
            setU32Frequency(rhs.getU32Frequency());
        } else {
            clearU32Frequency();
        }
        if (rhs.hasU16PICode()) {
            setU16PICode(rhs.getU16PICode());
        } else {
            clearU16PICode();
        }
        if (rhs.hasU8ListElementID()) {
            setU8ListElementID(rhs.getU8ListElementID());
        } else {
            clearU8ListElementID();
        }
        if (rhs.hasU8Listtype()) {
            setU8Listtype(rhs.getU8Listtype());
        } else {
            clearU8Listtype();
        }
        if (rhs.hasU32HDStnID_DRMSrvID()) {
            setU32HDStnID_DRMSrvID(rhs.getU32HDStnID_DRMSrvID());
        } else {
            clearU32HDStnID_DRMSrvID();
        }
        if (rhs.hasE8ModulationType()) {
            setE8ModulationType(rhs.getE8ModulationType());
        } else {
            clearE8ModulationType();
        }
    }
    return *this;
}

inline bool T_Sel_List_Elem::operator == (const T_Sel_List_Elem& rhs) const {
    return (((!hasU8TunerHeader() && !rhs.hasU8TunerHeader()) || getU8TunerHeader() == rhs.getU8TunerHeader()) &&
        ((!hasEConfigListID() && !rhs.hasEConfigListID()) || getEConfigListID() == rhs.getEConfigListID()) &&
        ((!hasU32Frequency() && !rhs.hasU32Frequency()) || getU32Frequency() == rhs.getU32Frequency()) &&
        ((!hasU16PICode() && !rhs.hasU16PICode()) || getU16PICode() == rhs.getU16PICode()) &&
        ((!hasU8ListElementID() && !rhs.hasU8ListElementID()) || getU8ListElementID() == rhs.getU8ListElementID()) &&
        ((!hasU8Listtype() && !rhs.hasU8Listtype()) || getU8Listtype() == rhs.getU8Listtype()) &&
        ((!hasU32HDStnID_DRMSrvID() && !rhs.hasU32HDStnID_DRMSrvID()) || getU32HDStnID_DRMSrvID() == rhs.getU32HDStnID_DRMSrvID()) &&
        ((!hasE8ModulationType() && !rhs.hasE8ModulationType()) || getE8ModulationType() == rhs.getE8ModulationType()));
}

inline bool T_Sel_List_Elem::operator != (const T_Sel_List_Elem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Sel_List_Elem::operator < (const T_Sel_List_Elem& rhs) const {
    if (hasU8TunerHeader() || rhs.hasU8TunerHeader()) {
        if ((uint32)getU8TunerHeader() < (uint32)rhs.getU8TunerHeader()) return true;
        if ((uint32)getU8TunerHeader() > (uint32)rhs.getU8TunerHeader()) return false;
    }
    if (hasEConfigListID() || rhs.hasEConfigListID()) {
        if ((uint32)getEConfigListID() < (uint32)rhs.getEConfigListID()) return true;
        if ((uint32)getEConfigListID() > (uint32)rhs.getEConfigListID()) return false;
    }
    if (hasU32Frequency() || rhs.hasU32Frequency()) {
        if (getU32Frequency() < rhs.getU32Frequency()) return true;
        if (getU32Frequency() > rhs.getU32Frequency()) return false;
    }
    if (hasU16PICode() || rhs.hasU16PICode()) {
        if (getU16PICode() < rhs.getU16PICode()) return true;
        if (getU16PICode() > rhs.getU16PICode()) return false;
    }
    if (hasU8ListElementID() || rhs.hasU8ListElementID()) {
        if (getU8ListElementID() < rhs.getU8ListElementID()) return true;
        if (getU8ListElementID() > rhs.getU8ListElementID()) return false;
    }
    if (hasU8Listtype() || rhs.hasU8Listtype()) {
        if ((uint32)getU8Listtype() < (uint32)rhs.getU8Listtype()) return true;
        if ((uint32)getU8Listtype() > (uint32)rhs.getU8Listtype()) return false;
    }
    if (hasU32HDStnID_DRMSrvID() || rhs.hasU32HDStnID_DRMSrvID()) {
        if (getU32HDStnID_DRMSrvID() < rhs.getU32HDStnID_DRMSrvID()) return true;
        if (getU32HDStnID_DRMSrvID() > rhs.getU32HDStnID_DRMSrvID()) return false;
    }
    if (hasE8ModulationType() || rhs.hasE8ModulationType()) {
        if ((uint32)getE8ModulationType() < (uint32)rhs.getE8ModulationType()) return true;
        if ((uint32)getE8ModulationType() > (uint32)rhs.getE8ModulationType()) return false;
    }
    return false;
}

inline bool T_Sel_List_Elem::operator > (const T_Sel_List_Elem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Sel_List_Elem::clear() {
    clearU8TunerHeader();
    clearEConfigListID();
    clearU32Frequency();
    clearU16PICode();
    clearU8ListElementID();
    clearU8Listtype();
    clearU32HDStnID_DRMSrvID();
    clearE8ModulationType();
}

inline void T_Sel_List_Elem::clearU8TunerHeader() {
    if (hasU8TunerHeader()) {
         clear_has_u8TunerHeader();
        _u8TunerHeader = ::midw_tuner_fi_types::T_e8_Tun_TunerHeader__TUN_FOREGROUND;
     }
}

inline bool T_Sel_List_Elem::hasU8TunerHeader () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_TunerHeader T_Sel_List_Elem::getU8TunerHeader () const {
    return _u8TunerHeader;
}

inline void T_Sel_List_Elem::setU8TunerHeader (T_e8_Tun_TunerHeader u8TunerHeader_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_TunerHeader_IsValid(u8TunerHeader_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8TunerHeader_, "T_e8_Tun_TunerHeader", "u8TunerHeader", "T_Sel_List_Elem");
    }
    set_has_u8TunerHeader();
    this->_u8TunerHeader = u8TunerHeader_;
}

inline void T_Sel_List_Elem::clearEConfigListID() {
    if (hasEConfigListID()) {
         clear_has_eConfigListID();
        _eConfigListID = ::midw_tuner_fi_types::T_e8_Tun_ConfigListID__TUN_TUN_CONFIG_LIST_FM;
     }
}

inline bool T_Sel_List_Elem::hasEConfigListID () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Tun_ConfigListID T_Sel_List_Elem::getEConfigListID () const {
    return _eConfigListID;
}

inline void T_Sel_List_Elem::setEConfigListID (T_e8_Tun_ConfigListID eConfigListID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ConfigListID_IsValid(eConfigListID_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", eConfigListID_, "T_e8_Tun_ConfigListID", "eConfigListID", "T_Sel_List_Elem");
    }
    set_has_eConfigListID();
    this->_eConfigListID = eConfigListID_;
}

inline void T_Sel_List_Elem::clearU32Frequency() {
    if (hasU32Frequency()) {
         clear_has_u32Frequency();
        _u32Frequency = 0u;
     }
}

inline bool T_Sel_List_Elem::hasU32Frequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 T_Sel_List_Elem::getU32Frequency () const {
    return _u32Frequency;
}

inline void T_Sel_List_Elem::setU32Frequency (uint32 u32Frequency_) {
    set_has_u32Frequency();
    this->_u32Frequency = u32Frequency_;
}

inline void T_Sel_List_Elem::clearU16PICode() {
    if (hasU16PICode()) {
         clear_has_u16PICode();
        _u16PICode = 0u;
     }
}

inline bool T_Sel_List_Elem::hasU16PICode () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 T_Sel_List_Elem::getU16PICode () const {
    return _u16PICode;
}

inline void T_Sel_List_Elem::setU16PICode (uint16 u16PICode_) {
    set_has_u16PICode();
    this->_u16PICode = u16PICode_;
}

inline void T_Sel_List_Elem::clearU8ListElementID() {
    if (hasU8ListElementID()) {
         clear_has_u8ListElementID();
        _u8ListElementID = 0u;
     }
}

inline bool T_Sel_List_Elem::hasU8ListElementID () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 T_Sel_List_Elem::getU8ListElementID () const {
    return _u8ListElementID;
}

inline void T_Sel_List_Elem::setU8ListElementID (uint8 u8ListElementID_) {
    set_has_u8ListElementID();
    this->_u8ListElementID = u8ListElementID_;
}

inline void T_Sel_List_Elem::clearU8Listtype() {
    if (hasU8Listtype()) {
         clear_has_u8Listtype();
        _u8Listtype = ::midw_tuner_fi_types::T_e8_Tun_ListType__TUN_LIST_TYPE_STATIC;
     }
}

inline bool T_Sel_List_Elem::hasU8Listtype () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline T_e8_Tun_ListType T_Sel_List_Elem::getU8Listtype () const {
    return _u8Listtype;
}

inline void T_Sel_List_Elem::setU8Listtype (T_e8_Tun_ListType u8Listtype_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ListType_IsValid(u8Listtype_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Listtype_, "T_e8_Tun_ListType", "u8Listtype", "T_Sel_List_Elem");
    }
    set_has_u8Listtype();
    this->_u8Listtype = u8Listtype_;
}

inline void T_Sel_List_Elem::clearU32HDStnID_DRMSrvID() {
    if (hasU32HDStnID_DRMSrvID()) {
         clear_has_u32HDStnID_DRMSrvID();
        _u32HDStnID_DRMSrvID = 0u;
     }
}

inline bool T_Sel_List_Elem::hasU32HDStnID_DRMSrvID () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint32 T_Sel_List_Elem::getU32HDStnID_DRMSrvID () const {
    return _u32HDStnID_DRMSrvID;
}

inline void T_Sel_List_Elem::setU32HDStnID_DRMSrvID (uint32 u32HDStnID_DRMSrvID_) {
    set_has_u32HDStnID_DRMSrvID();
    this->_u32HDStnID_DRMSrvID = u32HDStnID_DRMSrvID_;
}

inline void T_Sel_List_Elem::clearE8ModulationType() {
    if (hasE8ModulationType()) {
         clear_has_e8ModulationType();
        _e8ModulationType = ::midw_tuner_fi_types::T_e8_Tun_ModulationType__TUN_MODULATION_ANALOG;
     }
}

inline bool T_Sel_List_Elem::hasE8ModulationType () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_Tun_ModulationType T_Sel_List_Elem::getE8ModulationType () const {
    return _e8ModulationType;
}

inline void T_Sel_List_Elem::setE8ModulationType (T_e8_Tun_ModulationType e8ModulationType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ModulationType_IsValid(e8ModulationType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ModulationType_, "T_e8_Tun_ModulationType", "e8ModulationType", "T_Sel_List_Elem");
    }
    set_has_e8ModulationType();
    this->_e8ModulationType = e8ModulationType_;
}

inline void T_Sel_List_Elem::set_has_u8TunerHeader () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_Sel_List_Elem::clear_has_u8TunerHeader () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_Sel_List_Elem::set_has_eConfigListID () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_Sel_List_Elem::clear_has_eConfigListID () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_Sel_List_Elem::set_has_u32Frequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_Sel_List_Elem::clear_has_u32Frequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_Sel_List_Elem::set_has_u16PICode () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_Sel_List_Elem::clear_has_u16PICode () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_Sel_List_Elem::set_has_u8ListElementID () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_Sel_List_Elem::clear_has_u8ListElementID () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_Sel_List_Elem::set_has_u8Listtype () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_Sel_List_Elem::clear_has_u8Listtype () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_Sel_List_Elem::set_has_u32HDStnID_DRMSrvID () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_Sel_List_Elem::clear_has_u32HDStnID_DRMSrvID () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_Sel_List_Elem::set_has_e8ModulationType () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_Sel_List_Elem::clear_has_e8ModulationType () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_b8_Tun_Digital_Filters::T_b8_Tun_Digital_Filters ()  :
    _STATIONLIST_WITHONLY_HDMPS (false),
    _STATIONLIST_WITH_HDMPS_SPS (false),
    _STATIONLIST_WITH_DRM (false),
    _RESERVED_1 (false),
    _RESERVED_2 (false),
    _RESERVED_3 (false),
    _RESERVED_4 (false),
    _RESERVED_5 (false)
{
}

inline  T_b8_Tun_Digital_Filters::T_b8_Tun_Digital_Filters (const T_b8_Tun_Digital_Filters &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b8_Tun_Digital_Filters::T_b8_Tun_Digital_Filters (bool STATIONLIST_WITHONLY_HDMPS, bool STATIONLIST_WITH_HDMPS_SPS, bool STATIONLIST_WITH_DRM, bool RESERVED_1, bool RESERVED_2, bool RESERVED_3, bool RESERVED_4, bool RESERVED_5) :
    _STATIONLIST_WITHONLY_HDMPS (STATIONLIST_WITHONLY_HDMPS),
    _STATIONLIST_WITH_HDMPS_SPS (STATIONLIST_WITH_HDMPS_SPS),
    _STATIONLIST_WITH_DRM (STATIONLIST_WITH_DRM),
    _RESERVED_1 (RESERVED_1),
    _RESERVED_2 (RESERVED_2),
    _RESERVED_3 (RESERVED_3),
    _RESERVED_4 (RESERVED_4),
    _RESERVED_5 (RESERVED_5)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b8_Tun_Digital_Filters& T_b8_Tun_Digital_Filters::operator = (const T_b8_Tun_Digital_Filters& rhs) {
    if( this != &rhs ) {
        _STATIONLIST_WITHONLY_HDMPS = rhs._STATIONLIST_WITHONLY_HDMPS;
        _STATIONLIST_WITH_HDMPS_SPS = rhs._STATIONLIST_WITH_HDMPS_SPS;
        _STATIONLIST_WITH_DRM = rhs._STATIONLIST_WITH_DRM;
        _RESERVED_1 = rhs._RESERVED_1;
        _RESERVED_2 = rhs._RESERVED_2;
        _RESERVED_3 = rhs._RESERVED_3;
        _RESERVED_4 = rhs._RESERVED_4;
        _RESERVED_5 = rhs._RESERVED_5;
    }
    return *this;
}

inline bool T_b8_Tun_Digital_Filters::operator == (const T_b8_Tun_Digital_Filters& rhs) const {
    return (_STATIONLIST_WITHONLY_HDMPS == rhs._STATIONLIST_WITHONLY_HDMPS &&
        _STATIONLIST_WITH_HDMPS_SPS == rhs._STATIONLIST_WITH_HDMPS_SPS &&
        _STATIONLIST_WITH_DRM == rhs._STATIONLIST_WITH_DRM &&
        _RESERVED_1 == rhs._RESERVED_1 &&
        _RESERVED_2 == rhs._RESERVED_2 &&
        _RESERVED_3 == rhs._RESERVED_3 &&
        _RESERVED_4 == rhs._RESERVED_4 &&
        _RESERVED_5 == rhs._RESERVED_5);
}

inline bool T_b8_Tun_Digital_Filters::operator != (const T_b8_Tun_Digital_Filters& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b8_Tun_Digital_Filters::operator < (const T_b8_Tun_Digital_Filters& rhs) const {
    if (getSTATIONLIST_WITHONLY_HDMPS() < rhs.getSTATIONLIST_WITHONLY_HDMPS()) return true;
    if (getSTATIONLIST_WITHONLY_HDMPS() > rhs.getSTATIONLIST_WITHONLY_HDMPS()) return false;

    if (getSTATIONLIST_WITH_HDMPS_SPS() < rhs.getSTATIONLIST_WITH_HDMPS_SPS()) return true;
    if (getSTATIONLIST_WITH_HDMPS_SPS() > rhs.getSTATIONLIST_WITH_HDMPS_SPS()) return false;

    if (getSTATIONLIST_WITH_DRM() < rhs.getSTATIONLIST_WITH_DRM()) return true;
    if (getSTATIONLIST_WITH_DRM() > rhs.getSTATIONLIST_WITH_DRM()) return false;

    if (getRESERVED_1() < rhs.getRESERVED_1()) return true;
    if (getRESERVED_1() > rhs.getRESERVED_1()) return false;

    if (getRESERVED_2() < rhs.getRESERVED_2()) return true;
    if (getRESERVED_2() > rhs.getRESERVED_2()) return false;

    if (getRESERVED_3() < rhs.getRESERVED_3()) return true;
    if (getRESERVED_3() > rhs.getRESERVED_3()) return false;

    if (getRESERVED_4() < rhs.getRESERVED_4()) return true;
    if (getRESERVED_4() > rhs.getRESERVED_4()) return false;

    if (getRESERVED_5() < rhs.getRESERVED_5()) return true;
    if (getRESERVED_5() > rhs.getRESERVED_5()) return false;

    return false;
}

inline bool T_b8_Tun_Digital_Filters::operator > (const T_b8_Tun_Digital_Filters& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b8_Tun_Digital_Filters::setSTATIONLIST_WITHONLY_HDMPS (bool STATIONLIST_WITHONLY_HDMPS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_STATIONLIST_WITHONLY_HDMPS = STATIONLIST_WITHONLY_HDMPS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getSTATIONLIST_WITHONLY_HDMPS () const {
    return _STATIONLIST_WITHONLY_HDMPS;
}

inline void T_b8_Tun_Digital_Filters::setSTATIONLIST_WITH_HDMPS_SPS (bool STATIONLIST_WITH_HDMPS_SPS) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_STATIONLIST_WITH_HDMPS_SPS = STATIONLIST_WITH_HDMPS_SPS;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getSTATIONLIST_WITH_HDMPS_SPS () const {
    return _STATIONLIST_WITH_HDMPS_SPS;
}

inline void T_b8_Tun_Digital_Filters::setSTATIONLIST_WITH_DRM (bool STATIONLIST_WITH_DRM) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_STATIONLIST_WITH_DRM = STATIONLIST_WITH_DRM;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getSTATIONLIST_WITH_DRM () const {
    return _STATIONLIST_WITH_DRM;
}

inline void T_b8_Tun_Digital_Filters::setRESERVED_1 (bool RESERVED_1) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RESERVED_1 = RESERVED_1;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getRESERVED_1 () const {
    return _RESERVED_1;
}

inline void T_b8_Tun_Digital_Filters::setRESERVED_2 (bool RESERVED_2) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RESERVED_2 = RESERVED_2;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getRESERVED_2 () const {
    return _RESERVED_2;
}

inline void T_b8_Tun_Digital_Filters::setRESERVED_3 (bool RESERVED_3) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RESERVED_3 = RESERVED_3;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getRESERVED_3 () const {
    return _RESERVED_3;
}

inline void T_b8_Tun_Digital_Filters::setRESERVED_4 (bool RESERVED_4) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RESERVED_4 = RESERVED_4;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getRESERVED_4 () const {
    return _RESERVED_4;
}

inline void T_b8_Tun_Digital_Filters::setRESERVED_5 (bool RESERVED_5) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_RESERVED_5 = RESERVED_5;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b8_Tun_Digital_Filters::getRESERVED_5 () const {
    return _RESERVED_5;
}

inline  T_Tun_MakeConfigList::T_Tun_MakeConfigList ()  :
    _eConfigListID (::midw_tuner_fi_types::T_e8_Tun_ConfigListID__TUN_TUN_CONFIG_LIST_FM),
    _u32PTY (0u),
    _eSortingCriteria (::midw_tuner_fi_types::T_e8_Tun_SortingCriteria__TUN_TUN_SORT_PS_ASCENDING),
    _u8DigitalFilters (NULL),
    _bFrozenList (true)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_Tun_MakeConfigList::T_Tun_MakeConfigList (const T_Tun_MakeConfigList &rhs)  :
    _eConfigListID (::midw_tuner_fi_types::T_e8_Tun_ConfigListID__TUN_TUN_CONFIG_LIST_FM),
    _u32PTY (0u),
    _eSortingCriteria (::midw_tuner_fi_types::T_e8_Tun_SortingCriteria__TUN_TUN_SORT_PS_ASCENDING),
    _u8DigitalFilters (NULL),
    _bFrozenList (true)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_Tun_MakeConfigList::T_Tun_MakeConfigList (T_e8_Tun_ConfigListID eConfigListID_, uint32 u32PTY_, T_e8_Tun_SortingCriteria eSortingCriteria_, const T_b8_Tun_Digital_Filters& u8DigitalFilters_, bool bFrozenList_)  :
    _eConfigListID (eConfigListID_),
    _u32PTY (u32PTY_),
    _eSortingCriteria (eSortingCriteria_),
    _u8DigitalFilters (new T_b8_Tun_Digital_Filters(u8DigitalFilters_)),
    _bFrozenList (bFrozenList_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ConfigListID_IsValid(eConfigListID_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", eConfigListID_, "T_e8_Tun_ConfigListID", "eConfigListID", "T_Tun_MakeConfigList");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_SortingCriteria_IsValid(eSortingCriteria_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSortingCriteria_, "T_e8_Tun_SortingCriteria", "eSortingCriteria", "T_Tun_MakeConfigList");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_Tun_MakeConfigList::~T_Tun_MakeConfigList() {
    delete _u8DigitalFilters;
}

inline T_Tun_MakeConfigList& T_Tun_MakeConfigList::operator = (const T_Tun_MakeConfigList& rhs) {
    if( this != &rhs ) {
        if (rhs.hasEConfigListID()) {
            setEConfigListID(rhs.getEConfigListID());
        } else {
            clearEConfigListID();
        }
        if (rhs.hasU32PTY()) {
            setU32PTY(rhs.getU32PTY());
        } else {
            clearU32PTY();
        }
        if (rhs.hasESortingCriteria()) {
            setESortingCriteria(rhs.getESortingCriteria());
        } else {
            clearESortingCriteria();
        }
        if (rhs.hasU8DigitalFilters()) {
            setU8DigitalFilters(rhs.getU8DigitalFilters());
        } else {
            clearU8DigitalFilters();
        }
        if (rhs.hasBFrozenList()) {
            setBFrozenList(rhs.getBFrozenList());
        } else {
            clearBFrozenList();
        }
    }
    return *this;
}

inline bool T_Tun_MakeConfigList::operator == (const T_Tun_MakeConfigList& rhs) const {
    return (((!hasEConfigListID() && !rhs.hasEConfigListID()) || getEConfigListID() == rhs.getEConfigListID()) &&
        ((!hasU32PTY() && !rhs.hasU32PTY()) || getU32PTY() == rhs.getU32PTY()) &&
        ((!hasESortingCriteria() && !rhs.hasESortingCriteria()) || getESortingCriteria() == rhs.getESortingCriteria()) &&
        ((!hasU8DigitalFilters() && !rhs.hasU8DigitalFilters()) || getU8DigitalFilters() == rhs.getU8DigitalFilters()) &&
        ((!hasBFrozenList() && !rhs.hasBFrozenList()) || getBFrozenList() == rhs.getBFrozenList()));
}

inline bool T_Tun_MakeConfigList::operator != (const T_Tun_MakeConfigList& rhs) const {
    return ! (*this == rhs);
}

inline bool T_Tun_MakeConfigList::operator < (const T_Tun_MakeConfigList& rhs) const {
    if (hasEConfigListID() || rhs.hasEConfigListID()) {
        if ((uint32)getEConfigListID() < (uint32)rhs.getEConfigListID()) return true;
        if ((uint32)getEConfigListID() > (uint32)rhs.getEConfigListID()) return false;
    }
    if (hasU32PTY() || rhs.hasU32PTY()) {
        if (getU32PTY() < rhs.getU32PTY()) return true;
        if (getU32PTY() > rhs.getU32PTY()) return false;
    }
    if (hasESortingCriteria() || rhs.hasESortingCriteria()) {
        if ((uint32)getESortingCriteria() < (uint32)rhs.getESortingCriteria()) return true;
        if ((uint32)getESortingCriteria() > (uint32)rhs.getESortingCriteria()) return false;
    }
    if (hasU8DigitalFilters() || rhs.hasU8DigitalFilters()) {
        if (getU8DigitalFilters() < rhs.getU8DigitalFilters()) return true;
        if (getU8DigitalFilters() > rhs.getU8DigitalFilters()) return false;
    }
    if (hasBFrozenList() || rhs.hasBFrozenList()) {
        if (getBFrozenList() < rhs.getBFrozenList()) return true;
        if (getBFrozenList() > rhs.getBFrozenList()) return false;
    }
    return false;
}

inline bool T_Tun_MakeConfigList::operator > (const T_Tun_MakeConfigList& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_Tun_MakeConfigList::clear() {
    clearEConfigListID();
    clearU32PTY();
    clearESortingCriteria();
    clearU8DigitalFilters();
    clearBFrozenList();
}

inline void T_Tun_MakeConfigList::clearEConfigListID() {
    if (hasEConfigListID()) {
         clear_has_eConfigListID();
        _eConfigListID = ::midw_tuner_fi_types::T_e8_Tun_ConfigListID__TUN_TUN_CONFIG_LIST_FM;
     }
}

inline bool T_Tun_MakeConfigList::hasEConfigListID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_Tun_ConfigListID T_Tun_MakeConfigList::getEConfigListID () const {
    return _eConfigListID;
}

inline void T_Tun_MakeConfigList::setEConfigListID (T_e8_Tun_ConfigListID eConfigListID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_ConfigListID_IsValid(eConfigListID_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", eConfigListID_, "T_e8_Tun_ConfigListID", "eConfigListID", "T_Tun_MakeConfigList");
    }
    set_has_eConfigListID();
    this->_eConfigListID = eConfigListID_;
}

inline void T_Tun_MakeConfigList::clearU32PTY() {
    if (hasU32PTY()) {
         clear_has_u32PTY();
        _u32PTY = 0u;
     }
}

inline bool T_Tun_MakeConfigList::hasU32PTY () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_Tun_MakeConfigList::getU32PTY () const {
    return _u32PTY;
}

inline void T_Tun_MakeConfigList::setU32PTY (uint32 u32PTY_) {
    set_has_u32PTY();
    this->_u32PTY = u32PTY_;
}

inline void T_Tun_MakeConfigList::clearESortingCriteria() {
    if (hasESortingCriteria()) {
         clear_has_eSortingCriteria();
        _eSortingCriteria = ::midw_tuner_fi_types::T_e8_Tun_SortingCriteria__TUN_TUN_SORT_PS_ASCENDING;
     }
}

inline bool T_Tun_MakeConfigList::hasESortingCriteria () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_Tun_SortingCriteria T_Tun_MakeConfigList::getESortingCriteria () const {
    return _eSortingCriteria;
}

inline void T_Tun_MakeConfigList::setESortingCriteria (T_e8_Tun_SortingCriteria eSortingCriteria_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(T_e8_Tun_SortingCriteria_IsValid(eSortingCriteria_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSortingCriteria_, "T_e8_Tun_SortingCriteria", "eSortingCriteria", "T_Tun_MakeConfigList");
    }
    set_has_eSortingCriteria();
    this->_eSortingCriteria = eSortingCriteria_;
}

inline void T_Tun_MakeConfigList::clearU8DigitalFilters() {
    if (hasU8DigitalFilters()) {
         clear_has_u8DigitalFilters();
        delete _u8DigitalFilters;
        _u8DigitalFilters = NULL;
     }
}

inline bool T_Tun_MakeConfigList::hasU8DigitalFilters () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_b8_Tun_Digital_Filte