/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_STC_STCSERVICESPROXY_H
#define ORG_BOSCH_STC_STCSERVICESPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bosch/stc/stcservices.h"
#include <dbus/dbus.h>

namespace org {
namespace bosch {
namespace stc {
namespace stcservices {

class StcservicesProxy;

class GetTimeCallbackIF {
public:
    virtual ~GetTimeCallbackIF() {}

    virtual void onGetTimeError(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< GetTimeError >& error) = 0;

    virtual void onGetTimeResponse(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< GetTimeResponse >& response) = 0;
};

class ProvideCEAtimeCallbackIF {
public:
    virtual ~ProvideCEAtimeCallbackIF() {}

    virtual void onProvideCEAtimeError(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< ProvideCEAtimeError >& error) = 0;

    virtual void onProvideCEAtimeResponse(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< ProvideCEAtimeResponse >& response) = 0;
};

class SetCEATokenTimeCallbackIF {
public:
    virtual ~SetCEATokenTimeCallbackIF() {}

    virtual void onSetCEATokenTimeError(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< SetCEATokenTimeError >& error) = 0;

    virtual void onSetCEATokenTimeResponse(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< SetCEATokenTimeResponse >& response) = 0;
};

class SetTimeCallbackIF {
public:
    virtual ~SetTimeCallbackIF() {}

    virtual void onSetTimeError(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< SetTimeError >& error) = 0;

    virtual void onSetTimeResponse(const ::boost::shared_ptr< StcservicesProxy >& proxy, const ::boost::shared_ptr< SetTimeResponse >& response) = 0;
};


/**
 * StcservicesProxy is the client side representation of the D-Bus service
 * interface 'org.bosch.stc.stcservices' (specified in file
 * midw_psa_FC_STC_dbus_api.xml).
 *
 * If the meaning of "org.bosch.stc.stcservices" isn't clear, then there should be a description here.
 */
class StcservicesProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of StcservicesProxy.
     */
    static ::boost::shared_ptr< StcservicesProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of StcservicesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< StcservicesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of StcservicesProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< StcservicesProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< StcservicesProxy > proxyNew(new StcservicesProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~StcservicesProxy ();




    // Method 'GetTime'

    /**
     * Call the method 'GetTime'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetTime'</b>:
     *
     * If the meaning of "GetTime" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTimeRequest(GetTimeCallbackIF& cb) const;

    // Method 'SetTime'

    /**
     * Call the method 'SetTime'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetTime'</b>:
     *
     * If the meaning of "SetTime" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetTimeRequest(SetTimeCallbackIF& cb, uint64 value) const;

    // Method 'ProvideCEAtime'

    /**
     * Call the method 'ProvideCEAtime'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ProvideCEAtime'</b>:
     *
     * If the meaning of "ProvideCEAtime" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProvideCEAtimeRequest(ProvideCEAtimeCallbackIF& cb, uint64 value) const;

    // Method 'SetCEATokenTime'

    /**
     * Call the method 'SetCEATokenTime'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'SetCEATokenTime'</b>:
     *
     * If the meaning of "SetCEATokenTime" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetCEATokenTimeRequest(SetCEATokenTimeCallbackIF& cb, uint64 value) const;


private:

    StcservicesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class StcservicesProxyCallback;
};

} // namespace stcservices
} // namespace stc
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_STC_STCSERVICESPROXY_H
