/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/stc/stcservices.h"
#include "org/bosch/stc/stcservicesDBus.h"
#include "org/bosch/stc/stcservicesJson.h"
#include "org/bosch/stc/stcservicesProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace stc {
namespace stcservices {

DEFINE_CLASS_LOGGER("/org/bosch/stc/org/bosch/stc/stcservices", StcservicesProxy);

class StcservicesProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    StcservicesProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< StcservicesProxy >& proxyShared = ::boost::static_pointer_cast< StcservicesProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_GetTime:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetTimeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTimeError> payload = ::boost::static_pointer_cast<GetTimeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTimeCallbackIF*) _callback)->onGetTimeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTimeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetTimeResponse> payload = ::boost::static_pointer_cast<GetTimeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetTimeCallbackIF*) _callback)->onGetTimeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetTime:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetTimeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetTimeError> payload = ::boost::static_pointer_cast<SetTimeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetTimeCallbackIF*) _callback)->onSetTimeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetTimeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetTimeResponse> payload = ::boost::static_pointer_cast<SetTimeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetTimeCallbackIF*) _callback)->onSetTimeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ProvideCEAtime:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ProvideCEAtimeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ProvideCEAtime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProvideCEAtimeError> payload = ::boost::static_pointer_cast<ProvideCEAtimeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ProvideCEAtimeCallbackIF*) _callback)->onProvideCEAtimeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProvideCEAtimeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ProvideCEAtime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProvideCEAtimeResponse> payload = ::boost::static_pointer_cast<ProvideCEAtimeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ProvideCEAtimeCallbackIF*) _callback)->onProvideCEAtimeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetCEATokenTime:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetCEATokenTimeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCEATokenTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCEATokenTimeError> payload = ::boost::static_pointer_cast<SetCEATokenTimeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCEATokenTimeCallbackIF*) _callback)->onSetCEATokenTimeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetCEATokenTimeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetCEATokenTime", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetCEATokenTimeResponse> payload = ::boost::static_pointer_cast<SetCEATokenTimeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetCEATokenTimeCallbackIF*) _callback)->onSetCEATokenTimeResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_GetTime: {
                ::boost::shared_ptr< GetTimeError > payload = ::boost::shared_ptr< GetTimeError >
                (new GetTimeError(DBUS_ERROR_NO_SERVER, "The DBus service Stcservices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StcservicesProxy> proxyShared = ::boost::static_pointer_cast<StcservicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetTimeCallbackIF*) _callback)->onGetTimeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetTime: {
                ::boost::shared_ptr< SetTimeError > payload = ::boost::shared_ptr< SetTimeError >
                (new SetTimeError(DBUS_ERROR_NO_SERVER, "The DBus service Stcservices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StcservicesProxy> proxyShared = ::boost::static_pointer_cast<StcservicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetTimeCallbackIF*) _callback)->onSetTimeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ProvideCEAtime: {
                ::boost::shared_ptr< ProvideCEAtimeError > payload = ::boost::shared_ptr< ProvideCEAtimeError >
                (new ProvideCEAtimeError(DBUS_ERROR_NO_SERVER, "The DBus service Stcservices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProvideCEAtime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StcservicesProxy> proxyShared = ::boost::static_pointer_cast<StcservicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProvideCEAtimeCallbackIF*) _callback)->onProvideCEAtimeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetCEATokenTime: {
                ::boost::shared_ptr< SetCEATokenTimeError > payload = ::boost::shared_ptr< SetCEATokenTimeError >
                (new SetCEATokenTimeError(DBUS_ERROR_NO_SERVER, "The DBus service Stcservices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetCEATokenTime", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<StcservicesProxy> proxyShared = ::boost::static_pointer_cast<StcservicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetCEATokenTimeCallbackIF*) _callback)->onSetCEATokenTimeError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& StcservicesProxyCallback::_logger (StcservicesProxy::_logger);

StcservicesProxy::StcservicesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.stc.stcservices", serviceAvailable, _logger) {
}

StcservicesProxy::~StcservicesProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< StcservicesProxy > StcservicesProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<StcservicesProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< StcservicesProxy > proxyNew(new StcservicesProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t StcservicesProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    StcservicesProxyCallback* callback = new StcservicesProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t StcservicesProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    StcservicesProxyCallback* callback = new StcservicesProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t StcservicesProxy::sendGetTimeRequest(GetTimeCallbackIF& cb) const {
    GetTimeRequest* payload = new GetTimeRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetTime", GetTimeRequest, payload, true)
    act_t act = addMethodCallback(ID_GetTime, dbusMessage.getUniqueSerial(), "GetTime", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetTime", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t StcservicesProxy::sendSetTimeRequest(SetTimeCallbackIF& cb, uint64 value) const {
    SetTimeRequest* payload = new SetTimeRequest();
    CHECK_ALLOCATION(payload);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetTime", SetTimeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetTime, dbusMessage.getUniqueSerial(), "SetTime", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetTime", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t StcservicesProxy::sendProvideCEAtimeRequest(ProvideCEAtimeCallbackIF& cb, uint64 value) const {
    ProvideCEAtimeRequest* payload = new ProvideCEAtimeRequest();
    CHECK_ALLOCATION(payload);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "ProvideCEAtime", ProvideCEAtimeRequest, payload, true)
    act_t act = addMethodCallback(ID_ProvideCEAtime, dbusMessage.getUniqueSerial(), "ProvideCEAtime", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ProvideCEAtime", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t StcservicesProxy::sendSetCEATokenTimeRequest(SetCEATokenTimeCallbackIF& cb, uint64 value) const {
    SetCEATokenTimeRequest* payload = new SetCEATokenTimeRequest();
    CHECK_ALLOCATION(payload);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetCEATokenTime", SetCEATokenTimeRequest, payload, true)
    act_t act = addMethodCallback(ID_SetCEATokenTime, dbusMessage.getUniqueSerial(), "SetCEATokenTime", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetCEATokenTime", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace stcservices
} // namespace stc
} // namespace bosch
} // namespace org
