#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MASCF_AUD_SRC_ROUTE_FI_TYPES_H
#define MASCF_AUD_SRC_ROUTE_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "mascf_aud_src_route_fi_typesConst.h"
#include <cstring>

/**
 * Types mascf_aud_src_route_fi_types
 */

namespace mascf_aud_src_route_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_SourceAvailablityItem;

class T_b32MuteReason;

class T_MuteRequestItem;

class T_RequestAudioRouteItem;

class T_SetAudioPropertyItem;


/**
 * Mute Request of a Source
 */
class T_SourceAvailablityItem {
public:

    /**
     * Default constructor
     */
    inline  T_SourceAvailablityItem ();

    /**
     * Copy constructor
     */
    inline  T_SourceAvailablityItem (const T_SourceAvailablityItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SourceAvailablityItem (T_e8_AudSource u8Source_, uint16 u16SubSource_, T_e8_SrcAvailabilityReason e8Reason_, T_e8_SrcAvailability e8Availability_);

    /**
     * Destructor
     */
    inline  ~T_SourceAvailablityItem();

    /**
     * Assignment operator
     */
    inline T_SourceAvailablityItem& operator = (const T_SourceAvailablityItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SourceAvailablityItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SourceAvailablityItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SourceAvailablityItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SourceAvailablityItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Source"

    static const int kU8Source = 0;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * Number of a data source (within one Application there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8Source"
     */
    inline T_e8_AudSource getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * Number of a data source (within one Application there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (T_e8_AudSource u8Source_);

    // API of field "u16SubSource"

    static const int kU16SubSource = 1;

    /**
     * Clears the field "u16SubSource".
     *
     * The field will be set to its default value. The hasU16SubSource()
     * method will return false.
     */
    inline void clearU16SubSource();

    /**
     * Checks whether the field "u16SubSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SubSource()). Otherwise it will return false.
     */
    inline bool hasU16SubSource () const;

    /**
     * Returns the value of the member "u16SubSource".
     *
     * SubSource of Source
     *
     * @return The value of the field "u16SubSource"
     */
    inline uint16 getU16SubSource () const;

    /**
     * Sets the value of the member "u16SubSource".
     *
     * SubSource of Source
     *
     * @param u16SubSource The value which will be set
     */
    inline void setU16SubSource (uint16 u16SubSource_);

    // API of field "e8Reason"

    static const int kE8Reason = 2;

    /**
     * Clears the field "e8Reason".
     *
     * The field will be set to its default value. The hasE8Reason()
     * method will return false.
     */
    inline void clearE8Reason();

    /**
     * Checks whether the field "e8Reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Reason()). Otherwise it will return false.
     */
    inline bool hasE8Reason () const;

    /**
     * Returns the value of the member "e8Reason".
     *
     * Reason for the availability
     *
     * @return The value of the field "e8Reason"
     */
    inline T_e8_SrcAvailabilityReason getE8Reason () const;

    /**
     * Sets the value of the member "e8Reason".
     *
     * Reason for the availability
     *
     * @param e8Reason The value which will be set
     */
    inline void setE8Reason (T_e8_SrcAvailabilityReason e8Reason_);

    // API of field "e8Availability"

    static const int kE8Availability = 3;

    /**
     * Clears the field "e8Availability".
     *
     * The field will be set to its default value. The hasE8Availability()
     * method will return false.
     */
    inline void clearE8Availability();

    /**
     * Checks whether the field "e8Availability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Availability()). Otherwise it will return false.
     */
    inline bool hasE8Availability () const;

    /**
     * Returns the value of the member "e8Availability".
     *
     * The source availability
     *
     * @return The value of the field "e8Availability"
     */
    inline T_e8_SrcAvailability getE8Availability () const;

    /**
     * Sets the value of the member "e8Availability".
     *
     * The source availability
     *
     * @param e8Availability The value which will be set
     */
    inline void setE8Availability (T_e8_SrcAvailability e8Availability_);

    static const T_SourceAvailablityItem &getDefaultInstance();

private:

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u16SubSource ();

    inline void clear_has_u16SubSource ();

    inline void set_has_e8Reason ();

    inline void clear_has_e8Reason ();

    inline void set_has_e8Availability ();

    inline void clear_has_e8Availability ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_AudSource _u8Source;

    uint16 _u16SubSource;

    T_e8_SrcAvailabilityReason _e8Reason;

    T_e8_SrcAvailability _e8Availability;

};

/**
 * gives the reason that for starting mute or Demute. Different reasons can be combined in the bitfield.
 */
class T_b32MuteReason {
public:

    /**
     * Default constructor
     */
    inline  T_b32MuteReason ();

    /**
     * Copy constructor
     */
    inline  T_b32MuteReason (const T_b32MuteReason &c);

    /**
     * Field constructor
     */
    inline  T_b32MuteReason (bool MUTE_REAS_USER_ACTION, bool MUTE_REAS_START_OF_TRACK, bool MUTE_REAS_SOURCE_SEL, bool MUTE_REAS_DIAG, bool MUTE_REAS_OTHER);

    /**
     * Assignment operator
     */
    inline T_b32MuteReason& operator = (const T_b32MuteReason& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32MuteReason& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32MuteReason& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32MuteReason& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32MuteReason& rhs) const;

    /**
     * Sets the value of the member "MUTE_REAS_USER_ACTION".
     *
     * If the meaning of "MUTE_REAS_USER_ACTION" isn't clear, then there should be a description here.
     *
     * @param MUTE_REAS_USER_ACTION The value which will be set
     */
    inline void setMUTE_REAS_USER_ACTION (bool MUTE_REAS_USER_ACTION);

    /**
     * Returns the value of the member "MUTE_REAS_USER_ACTION".
     *
     * If the meaning of "MUTE_REAS_USER_ACTION" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MUTE_REAS_USER_ACTION"
     */
    inline bool getMUTE_REAS_USER_ACTION () const;

    /**
     * Sets the value of the member "MUTE_REAS_START_OF_TRACK".
     *
     * If the meaning of "MUTE_REAS_START_OF_TRACK" isn't clear, then there should be a description here.
     *
     * @param MUTE_REAS_START_OF_TRACK The value which will be set
     */
    inline void setMUTE_REAS_START_OF_TRACK (bool MUTE_REAS_START_OF_TRACK);

    /**
     * Returns the value of the member "MUTE_REAS_START_OF_TRACK".
     *
     * If the meaning of "MUTE_REAS_START_OF_TRACK" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MUTE_REAS_START_OF_TRACK"
     */
    inline bool getMUTE_REAS_START_OF_TRACK () const;

    /**
     * Sets the value of the member "MUTE_REAS_SOURCE_SEL".
     *
     * If the meaning of "MUTE_REAS_SOURCE_SEL" isn't clear, then there should be a description here.
     *
     * @param MUTE_REAS_SOURCE_SEL The value which will be set
     */
    inline void setMUTE_REAS_SOURCE_SEL (bool MUTE_REAS_SOURCE_SEL);

    /**
     * Returns the value of the member "MUTE_REAS_SOURCE_SEL".
     *
     * If the meaning of "MUTE_REAS_SOURCE_SEL" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MUTE_REAS_SOURCE_SEL"
     */
    inline bool getMUTE_REAS_SOURCE_SEL () const;

    /**
     * Sets the value of the member "MUTE_REAS_DIAG".
     *
     * If the meaning of "MUTE_REAS_DIAG" isn't clear, then there should be a description here.
     *
     * @param MUTE_REAS_DIAG The value which will be set
     */
    inline void setMUTE_REAS_DIAG (bool MUTE_REAS_DIAG);

    /**
     * Returns the value of the member "MUTE_REAS_DIAG".
     *
     * If the meaning of "MUTE_REAS_DIAG" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MUTE_REAS_DIAG"
     */
    inline bool getMUTE_REAS_DIAG () const;

    /**
     * Sets the value of the member "MUTE_REAS_OTHER".
     *
     * If the meaning of "MUTE_REAS_OTHER" isn't clear, then there should be a description here.
     *
     * @param MUTE_REAS_OTHER The value which will be set
     */
    inline void setMUTE_REAS_OTHER (bool MUTE_REAS_OTHER);

    /**
     * Returns the value of the member "MUTE_REAS_OTHER".
     *
     * If the meaning of "MUTE_REAS_OTHER" isn't clear, then there should be a description here.
     *
     * @return The value of the field "MUTE_REAS_OTHER"
     */
    inline bool getMUTE_REAS_OTHER () const;

    static const T_b32MuteReason &getDefaultInstance();

private:

    bool _MUTE_REAS_USER_ACTION:1;

    bool _MUTE_REAS_START_OF_TRACK:1;

    bool _MUTE_REAS_SOURCE_SEL:1;

    bool _MUTE_REAS_DIAG:1;

    bool _MUTE_REAS_OTHER:1;

};

/**
 * Mute Request of a Source
 */
class T_MuteRequestItem {
public:

    /**
     * Default constructor
     */
    inline  T_MuteRequestItem ();

    /**
     * Copy constructor
     */
    inline  T_MuteRequestItem (const T_MuteRequestItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_MuteRequestItem (T_e8_AudSource u8Source_, T_e8MuteAction u8Action_, const T_b32MuteReason& u32Reason_);

    /**
     * Destructor
     */
    inline  ~T_MuteRequestItem();

    /**
     * Assignment operator
     */
    inline T_MuteRequestItem& operator = (const T_MuteRequestItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_MuteRequestItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_MuteRequestItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_MuteRequestItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_MuteRequestItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Source"

    static const int kU8Source = 0;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * The u8Source gives the source, a new mute state is requested for.
     *
     * @return The value of the field "u8Source"
     */
    inline T_e8_AudSource getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * The u8Source gives the source, a new mute state is requested for.
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (T_e8_AudSource u8Source_);

    // API of field "u8Action"

    static const int kU8Action = 1;

    /**
     * Clears the field "u8Action".
     *
     * The field will be set to its default value. The hasU8Action()
     * method will return false.
     */
    inline void clearU8Action();

    /**
     * Checks whether the field "u8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Action()). Otherwise it will return false.
     */
    inline bool hasU8Action () const;

    /**
     * Returns the value of the member "u8Action".
     *
     * Give the new action of the request. With "Mute" a mute is requested, with "Demute" a Demute is requested.
     *
     * @return The value of the field "u8Action"
     */
    inline T_e8MuteAction getU8Action () const;

    /**
     * Sets the value of the member "u8Action".
     *
     * Give the new action of the request. With "Mute" a mute is requested, with "Demute" a Demute is requested.
     *
     * @param u8Action The value which will be set
     */
    inline void setU8Action (T_e8MuteAction u8Action_);

    // API of field "u32Reason"

    static const int kU32Reason = 2;

    /**
     * Clears the field "u32Reason".
     *
     * The field will be set to its default value. The hasU32Reason()
     * method will return false.
     */
    inline void clearU32Reason();

    /**
     * Checks whether the field "u32Reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Reason()). Otherwise it will return false.
     */
    inline bool hasU32Reason () const;

    /**
     * Returns the value of the member "u32Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling the mute ramp.
     *
     * @return The value of the field "u32Reason"
     */
    inline const T_b32MuteReason& getU32Reason () const;

    /**
     * Retrieves the value of the field "u32Reason" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "u32Reason".
     */
    inline T_b32MuteReason& getU32ReasonMutable ();

    /**
     * Sets the value of the member "u32Reason".
     *
     * Give the reason of a mute request this parameter can be used for controlling the mute ramp.
     *
     * @param u32Reason The value which will be set
     */
    inline void setU32Reason (const T_b32MuteReason& u32Reason_);

    static const T_MuteRequestItem &getDefaultInstance();

private:

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u8Action ();

    inline void clear_has_u8Action ();

    inline void set_has_u32Reason ();

    inline void clear_has_u32Reason ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_AudSource _u8Source;

    T_e8MuteAction _u8Action;

    T_b32MuteReason _u32Reason;

};

/**
 * Mute Request of a Source
 */
class T_RequestAudioRouteItem {
public:

    /**
     * Default constructor
     */
    inline  T_RequestAudioRouteItem ();

    /**
     * Copy constructor
     */
    inline  T_RequestAudioRouteItem (const T_RequestAudioRouteItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_RequestAudioRouteItem (T_e8_AudSource u8Source_, uint16 u16SubSource_, uint8 u8Reason_, T_e8_SrcActivity e8Activity_);

    /**
     * Destructor
     */
    inline  ~T_RequestAudioRouteItem();

    /**
     * Assignment operator
     */
    inline T_RequestAudioRouteItem& operator = (const T_RequestAudioRouteItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_RequestAudioRouteItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_RequestAudioRouteItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_RequestAudioRouteItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_RequestAudioRouteItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Source"

    static const int kU8Source = 0;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * Number of a data source (within one Application there can be more than one), for example, 0x01 for the first source.
     *
     * @return The value of the field "u8Source"
     */
    inline T_e8_AudSource getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * Number of a data source (within one Application there can be more than one), for example, 0x01 for the first source.
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (T_e8_AudSource u8Source_);

    // API of field "u16SubSource"

    static const int kU16SubSource = 1;

    /**
     * Clears the field "u16SubSource".
     *
     * The field will be set to its default value. The hasU16SubSource()
     * method will return false.
     */
    inline void clearU16SubSource();

    /**
     * Checks whether the field "u16SubSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SubSource()). Otherwise it will return false.
     */
    inline bool hasU16SubSource () const;

    /**
     * Returns the value of the member "u16SubSource".
     *
     * Sub-Source number, e.g. USB 42 or IPod 23
     *
     * @return The value of the field "u16SubSource"
     */
    inline uint16 getU16SubSource () const;

    /**
     * Sets the value of the member "u16SubSource".
     *
     * Sub-Source number, e.g. USB 42 or IPod 23
     *
     * @param u16SubSource The value which will be set
     */
    inline void setU16SubSource (uint16 u16SubSource_);

    // API of field "u8Reason"

    static const int kU8Reason = 2;

    /**
     * Clears the field "u8Reason".
     *
     * The field will be set to its default value. The hasU8Reason()
     * method will return false.
     */
    inline void clearU8Reason();

    /**
     * Checks whether the field "u8Reason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Reason()). Otherwise it will return false.
     */
    inline bool hasU8Reason () const;

    /**
     * Returns the value of the member "u8Reason".
     *
     * Reason for route request can be given to HMI-Api or -Stack. Values are source and project specific
     *
     * @return The value of the field "u8Reason"
     */
    inline uint8 getU8Reason () const;

    /**
     * Sets the value of the member "u8Reason".
     *
     * Reason for route request can be given to HMI-Api or -Stack. Values are source and project specific
     *
     * @param u8Reason The value which will be set
     */
    inline void setU8Reason (uint8 u8Reason_);

    // API of field "e8Activity"

    static const int kE8Activity = 3;

    /**
     * Clears the field "e8Activity".
     *
     * The field will be set to its default value. The hasE8Activity()
     * method will return false.
     */
    inline void clearE8Activity();

    /**
     * Checks whether the field "e8Activity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Activity()). Otherwise it will return false.
     */
    inline bool hasE8Activity () const;

    /**
     * Returns the value of the member "e8Activity".
     *
     * Request can be set to On or Off. Other values are not supported.
     *
     * @return The value of the field "e8Activity"
     */
    inline T_e8_SrcActivity getE8Activity () const;

    /**
     * Sets the value of the member "e8Activity".
     *
     * Request can be set to On or Off. Other values are not supported.
     *
     * @param e8Activity The value which will be set
     */
    inline void setE8Activity (T_e8_SrcActivity e8Activity_);

    static const T_RequestAudioRouteItem &getDefaultInstance();

private:

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u16SubSource ();

    inline void clear_has_u16SubSource ();

    inline void set_has_u8Reason ();

    inline void clear_has_u8Reason ();

    inline void set_has_e8Activity ();

    inline void clear_has_e8Activity ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_AudSource _u8Source;

    uint16 _u16SubSource;

    uint8 _u8Reason;

    T_e8_SrcActivity _e8Activity;

};

/**
 * Audio property request of a Source
 */
class T_SetAudioPropertyItem {
public:

    /**
     * Default constructor
     */
    inline  T_SetAudioPropertyItem ();

    /**
     * Copy constructor
     */
    inline  T_SetAudioPropertyItem (const T_SetAudioPropertyItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SetAudioPropertyItem (T_e8_AudSource u8Source_, uint16 u16SubSource_, T_e8_AudioProperty u8Property_, int32 s32PropValue_);

    /**
     * Destructor
     */
    inline  ~T_SetAudioPropertyItem();

    /**
     * Assignment operator
     */
    inline T_SetAudioPropertyItem& operator = (const T_SetAudioPropertyItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SetAudioPropertyItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SetAudioPropertyItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SetAudioPropertyItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SetAudioPropertyItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Source"

    static const int kU8Source = 0;

    /**
     * Clears the field "u8Source".
     *
     * The field will be set to its default value. The hasU8Source()
     * method will return false.
     */
    inline void clearU8Source();

    /**
     * Checks whether the field "u8Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Source()). Otherwise it will return false.
     */
    inline bool hasU8Source () const;

    /**
     * Returns the value of the member "u8Source".
     *
     * The u8Source gives the source ID.
     *
     * @return The value of the field "u8Source"
     */
    inline T_e8_AudSource getU8Source () const;

    /**
     * Sets the value of the member "u8Source".
     *
     * The u8Source gives the source ID.
     *
     * @param u8Source The value which will be set
     */
    inline void setU8Source (T_e8_AudSource u8Source_);

    // API of field "u16SubSource"

    static const int kU16SubSource = 1;

    /**
     * Clears the field "u16SubSource".
     *
     * The field will be set to its default value. The hasU16SubSource()
     * method will return false.
     */
    inline void clearU16SubSource();

    /**
     * Checks whether the field "u16SubSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SubSource()). Otherwise it will return false.
     */
    inline bool hasU16SubSource () const;

    /**
     * Returns the value of the member "u16SubSource".
     *
     * The u16SubSource gives the Sub-source ID.
     *
     * @return The value of the field "u16SubSource"
     */
    inline uint16 getU16SubSource () const;

    /**
     * Sets the value of the member "u16SubSource".
     *
     * The u16SubSource gives the Sub-source ID.
     *
     * @param u16SubSource The value which will be set
     */
    inline void setU16SubSource (uint16 u16SubSource_);

    // API of field "u8Property"

    static const int kU8Property = 2;

    /**
     * Clears the field "u8Property".
     *
     * The field will be set to its default value. The hasU8Property()
     * method will return false.
     */
    inline void clearU8Property();

    /**
     * Checks whether the field "u8Property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Property()). Otherwise it will return false.
     */
    inline bool hasU8Property () const;

    /**
     * Returns the value of the member "u8Property".
     *
     * The u8Property gives the AudioProperty to be set by the Source.
     *
     * @return The value of the field "u8Property"
     */
    inline T_e8_AudioProperty getU8Property () const;

    /**
     * Sets the value of the member "u8Property".
     *
     * The u8Property gives the AudioProperty to be set by the Source.
     *
     * @param u8Property The value which will be set
     */
    inline void setU8Property (T_e8_AudioProperty u8Property_);

    // API of field "s32PropValue"

    static const int kS32PropValue = 3;

    /**
     * Clears the field "s32PropValue".
     *
     * The field will be set to its default value. The hasS32PropValue()
     * method will return false.
     */
    inline void clearS32PropValue();

    /**
     * Checks whether the field "s32PropValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32PropValue()). Otherwise it will return false.
     */
    inline bool hasS32PropValue () const;

    /**
     * Returns the value of the member "s32PropValue".
     *
     * The s32PropValue gives the Value of the Audio Property to be Set.
     * Dependent on the used value for T_e8_AudioProperty, this valu is interpreted as follows:
     * <p>AUDIO_PROP_VOLUME_LOCK: this property locks the volume control
     * 0 -> Volume Lock OFF. Volume control in normal operation
     * 1 -> Volume Lock total. Volume control is blocked completely
     * 2 -> Volume Lock increasing. Volume control is blocked for increasing request. Volume decreasing is still possible.
     * This parameter is stored for each source separately. Only the value of the active source will be used.
     * -------------------------------</p>
     * <p>AUDIO_PROP_INPUT_GAIN:
     * Gives an additional relative gain to the audio channel on which the source is playing. Resolution is 1dB, positive value leads to higher volume-level, negative values will lead to an attenuation.
     * This parameter is stored for each source separately. Only the value of the active source will be used.</p>
     * -------------------------------
     * <p>AUDIO_PROP_IPOD_DUCKING:
     * This property specially designed for Ipod-Out also known as CarPlay. It is used to attenuate the main stream while an announcement on the mix stream is played. This feature is called "ducking" by Apple Inc.
     * To transfer all required parameter in one message the 32 bit parameter will be used to pass the parameters from Apple duck/unduck functions as follows:
     * byte 0 and 1: ramp duration in ms
     * byte 2: volume level in dB
     * byte 3: Boolean value: duck=1, unduck=0
     * (byte 0 is LSB)</p>
     *
     * @return The value of the field "s32PropValue"
     */
    inline int32 getS32PropValue () const;

    /**
     * Sets the value of the member "s32PropValue".
     *
     * The s32PropValue gives the Value of the Audio Property to be Set.
     * Dependent on the used value for T_e8_AudioProperty, this valu is interpreted as follows:
     * <p>AUDIO_PROP_VOLUME_LOCK: this property locks the volume control
     * 0 -> Volume Lock OFF. Volume control in normal operation
     * 1 -> Volume Lock total. Volume control is blocked completely
     * 2 -> Volume Lock increasing. Volume control is blocked for increasing request. Volume decreasing is still possible.
     * This parameter is stored for each source separately. Only the value of the active source will be used.
     * -------------------------------</p>
     * <p>AUDIO_PROP_INPUT_GAIN:
     * Gives an additional relative gain to the audio channel on which the source is playing. Resolution is 1dB, positive value leads to higher volume-level, negative values will lead to an attenuation.
     * This parameter is stored for each source separately. Only the value of the active source will be used.</p>
     * -------------------------------
     * <p>AUDIO_PROP_IPOD_DUCKING:
     * This property specially designed for Ipod-Out also known as CarPlay. It is used to attenuate the main stream while an announcement on the mix stream is played. This feature is called "ducking" by Apple Inc.
     * To transfer all required parameter in one message the 32 bit parameter will be used to pass the parameters from Apple duck/unduck functions as follows:
     * byte 0 and 1: ramp duration in ms
     * byte 2: volume level in dB
     * byte 3: Boolean value: duck=1, unduck=0
     * (byte 0 is LSB)</p>
     *
     * @param s32PropValue The value which will be set
     */
    inline void setS32PropValue (int32 s32PropValue_);

    static const T_SetAudioPropertyItem &getDefaultInstance();

private:

    inline void set_has_u8Source ();

    inline void clear_has_u8Source ();

    inline void set_has_u16SubSource ();

    inline void clear_has_u16SubSource ();

    inline void set_has_u8Property ();

    inline void clear_has_u8Property ();

    inline void set_has_s32PropValue ();

    inline void clear_has_s32PropValue ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_AudSource _u8Source;

    uint16 _u16SubSource;

    T_e8_AudioProperty _u8Property;

    int32 _s32PropValue;

};

inline  T_SourceAvailablityItem::T_SourceAvailablityItem ()  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u16SubSource (0u),
    _e8Reason (::mascf_aud_src_route_fi_types::T_e8_SrcAvailabilityReason__NEWMEDIA),
    _e8Availability (::mascf_aud_src_route_fi_types::T_e8_SrcAvailability__NOT_AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SourceAvailablityItem::T_SourceAvailablityItem (const T_SourceAvailablityItem &rhs)  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u16SubSource (0u),
    _e8Reason (::mascf_aud_src_route_fi_types::T_e8_SrcAvailabilityReason__NEWMEDIA),
    _e8Availability (::mascf_aud_src_route_fi_types::T_e8_SrcAvailability__NOT_AVAILABLE)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SourceAvailablityItem::T_SourceAvailablityItem (T_e8_AudSource u8Source_, uint16 u16SubSource_, T_e8_SrcAvailabilityReason e8Reason_, T_e8_SrcAvailability e8Availability_)  :
    _u8Source (u8Source_),
    _u16SubSource (u16SubSource_),
    _e8Reason (e8Reason_),
    _e8Availability (e8Availability_)
{
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_SourceAvailablityItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SrcAvailabilityReason_IsValid(e8Reason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Reason_, "T_e8_SrcAvailabilityReason", "e8Reason", "T_SourceAvailablityItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SrcAvailability_IsValid(e8Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Availability_, "T_e8_SrcAvailability", "e8Availability", "T_SourceAvailablityItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SourceAvailablityItem::~T_SourceAvailablityItem() {
}

inline T_SourceAvailablityItem& T_SourceAvailablityItem::operator = (const T_SourceAvailablityItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Source()) {
            setU8Source(rhs.getU8Source());
        } else {
            clearU8Source();
        }
        if (rhs.hasU16SubSource()) {
            setU16SubSource(rhs.getU16SubSource());
        } else {
            clearU16SubSource();
        }
        if (rhs.hasE8Reason()) {
            setE8Reason(rhs.getE8Reason());
        } else {
            clearE8Reason();
        }
        if (rhs.hasE8Availability()) {
            setE8Availability(rhs.getE8Availability());
        } else {
            clearE8Availability();
        }
    }
    return *this;
}

inline bool T_SourceAvailablityItem::operator == (const T_SourceAvailablityItem& rhs) const {
    return (((!hasU8Source() && !rhs.hasU8Source()) || getU8Source() == rhs.getU8Source()) &&
        ((!hasU16SubSource() && !rhs.hasU16SubSource()) || getU16SubSource() == rhs.getU16SubSource()) &&
        ((!hasE8Reason() && !rhs.hasE8Reason()) || getE8Reason() == rhs.getE8Reason()) &&
        ((!hasE8Availability() && !rhs.hasE8Availability()) || getE8Availability() == rhs.getE8Availability()));
}

inline bool T_SourceAvailablityItem::operator != (const T_SourceAvailablityItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SourceAvailablityItem::operator < (const T_SourceAvailablityItem& rhs) const {
    if (hasU8Source() || rhs.hasU8Source()) {
        if ((uint32)getU8Source() < (uint32)rhs.getU8Source()) return true;
        if ((uint32)getU8Source() > (uint32)rhs.getU8Source()) return false;
    }
    if (hasU16SubSource() || rhs.hasU16SubSource()) {
        if (getU16SubSource() < rhs.getU16SubSource()) return true;
        if (getU16SubSource() > rhs.getU16SubSource()) return false;
    }
    if (hasE8Reason() || rhs.hasE8Reason()) {
        if ((uint32)getE8Reason() < (uint32)rhs.getE8Reason()) return true;
        if ((uint32)getE8Reason() > (uint32)rhs.getE8Reason()) return false;
    }
    if (hasE8Availability() || rhs.hasE8Availability()) {
        if ((uint32)getE8Availability() < (uint32)rhs.getE8Availability()) return true;
        if ((uint32)getE8Availability() > (uint32)rhs.getE8Availability()) return false;
    }
    return false;
}

inline bool T_SourceAvailablityItem::operator > (const T_SourceAvailablityItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SourceAvailablityItem::clear() {
    clearU8Source();
    clearU16SubSource();
    clearE8Reason();
    clearE8Availability();
}

inline void T_SourceAvailablityItem::clearU8Source() {
    if (hasU8Source()) {
         clear_has_u8Source();
        _u8Source = ::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE;
     }
}

inline bool T_SourceAvailablityItem::hasU8Source () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AudSource T_SourceAvailablityItem::getU8Source () const {
    return _u8Source;
}

inline void T_SourceAvailablityItem::setU8Source (T_e8_AudSource u8Source_) {
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_SourceAvailablityItem");
    }
    #endif
    set_has_u8Source();
    this->_u8Source = u8Source_;
}

inline void T_SourceAvailablityItem::clearU16SubSource() {
    if (hasU16SubSource()) {
         clear_has_u16SubSource();
        _u16SubSource = 0u;
     }
}

inline bool T_SourceAvailablityItem::hasU16SubSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_SourceAvailablityItem::getU16SubSource () const {
    return _u16SubSource;
}

inline void T_SourceAvailablityItem::setU16SubSource (uint16 u16SubSource_) {
    set_has_u16SubSource();
    this->_u16SubSource = u16SubSource_;
}

inline void T_SourceAvailablityItem::clearE8Reason() {
    if (hasE8Reason()) {
         clear_has_e8Reason();
        _e8Reason = ::mascf_aud_src_route_fi_types::T_e8_SrcAvailabilityReason__NEWMEDIA;
     }
}

inline bool T_SourceAvailablityItem::hasE8Reason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_SrcAvailabilityReason T_SourceAvailablityItem::getE8Reason () const {
    return _e8Reason;
}

inline void T_SourceAvailablityItem::setE8Reason (T_e8_SrcAvailabilityReason e8Reason_) {
    #ifndef NDEBUG
    if (!(T_e8_SrcAvailabilityReason_IsValid(e8Reason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Reason_, "T_e8_SrcAvailabilityReason", "e8Reason", "T_SourceAvailablityItem");
    }
    #endif
    set_has_e8Reason();
    this->_e8Reason = e8Reason_;
}

inline void T_SourceAvailablityItem::clearE8Availability() {
    if (hasE8Availability()) {
         clear_has_e8Availability();
        _e8Availability = ::mascf_aud_src_route_fi_types::T_e8_SrcAvailability__NOT_AVAILABLE;
     }
}

inline bool T_SourceAvailablityItem::hasE8Availability () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_SrcAvailability T_SourceAvailablityItem::getE8Availability () const {
    return _e8Availability;
}

inline void T_SourceAvailablityItem::setE8Availability (T_e8_SrcAvailability e8Availability_) {
    #ifndef NDEBUG
    if (!(T_e8_SrcAvailability_IsValid(e8Availability_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Availability_, "T_e8_SrcAvailability", "e8Availability", "T_SourceAvailablityItem");
    }
    #endif
    set_has_e8Availability();
    this->_e8Availability = e8Availability_;
}

inline void T_SourceAvailablityItem::set_has_u8Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SourceAvailablityItem::clear_has_u8Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SourceAvailablityItem::set_has_u16SubSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SourceAvailablityItem::clear_has_u16SubSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SourceAvailablityItem::set_has_e8Reason () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SourceAvailablityItem::clear_has_e8Reason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SourceAvailablityItem::set_has_e8Availability () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SourceAvailablityItem::clear_has_e8Availability () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_b32MuteReason::T_b32MuteReason ()  :
    _MUTE_REAS_USER_ACTION (false),
    _MUTE_REAS_START_OF_TRACK (false),
    _MUTE_REAS_SOURCE_SEL (false),
    _MUTE_REAS_DIAG (false),
    _MUTE_REAS_OTHER (false)
{
}

inline  T_b32MuteReason::T_b32MuteReason (const T_b32MuteReason &c) {
    *this = c;
}

// Disbale conversion check for setting the bitfield due to incorrect behavior.
// See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wconversion"
#endif
inline  T_b32MuteReason::T_b32MuteReason (bool MUTE_REAS_USER_ACTION, bool MUTE_REAS_START_OF_TRACK, bool MUTE_REAS_SOURCE_SEL, bool MUTE_REAS_DIAG, bool MUTE_REAS_OTHER) :
    _MUTE_REAS_USER_ACTION (MUTE_REAS_USER_ACTION),
    _MUTE_REAS_START_OF_TRACK (MUTE_REAS_START_OF_TRACK),
    _MUTE_REAS_SOURCE_SEL (MUTE_REAS_SOURCE_SEL),
    _MUTE_REAS_DIAG (MUTE_REAS_DIAG),
    _MUTE_REAS_OTHER (MUTE_REAS_OTHER)
{
}
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif

inline T_b32MuteReason& T_b32MuteReason::operator = (const T_b32MuteReason& rhs) {
    if( this != &rhs ) {
        _MUTE_REAS_USER_ACTION = rhs._MUTE_REAS_USER_ACTION;
        _MUTE_REAS_START_OF_TRACK = rhs._MUTE_REAS_START_OF_TRACK;
        _MUTE_REAS_SOURCE_SEL = rhs._MUTE_REAS_SOURCE_SEL;
        _MUTE_REAS_DIAG = rhs._MUTE_REAS_DIAG;
        _MUTE_REAS_OTHER = rhs._MUTE_REAS_OTHER;
    }
    return *this;
}

inline bool T_b32MuteReason::operator == (const T_b32MuteReason& rhs) const {
    return (_MUTE_REAS_USER_ACTION == rhs._MUTE_REAS_USER_ACTION &&
        _MUTE_REAS_START_OF_TRACK == rhs._MUTE_REAS_START_OF_TRACK &&
        _MUTE_REAS_SOURCE_SEL == rhs._MUTE_REAS_SOURCE_SEL &&
        _MUTE_REAS_DIAG == rhs._MUTE_REAS_DIAG &&
        _MUTE_REAS_OTHER == rhs._MUTE_REAS_OTHER);
}

inline bool T_b32MuteReason::operator != (const T_b32MuteReason& rhs) const {
    return ! (*this == rhs);
}

inline bool T_b32MuteReason::operator < (const T_b32MuteReason& rhs) const {
    if (getMUTE_REAS_USER_ACTION() < rhs.getMUTE_REAS_USER_ACTION()) return true;
    if (getMUTE_REAS_USER_ACTION() > rhs.getMUTE_REAS_USER_ACTION()) return false;

    if (getMUTE_REAS_START_OF_TRACK() < rhs.getMUTE_REAS_START_OF_TRACK()) return true;
    if (getMUTE_REAS_START_OF_TRACK() > rhs.getMUTE_REAS_START_OF_TRACK()) return false;

    if (getMUTE_REAS_SOURCE_SEL() < rhs.getMUTE_REAS_SOURCE_SEL()) return true;
    if (getMUTE_REAS_SOURCE_SEL() > rhs.getMUTE_REAS_SOURCE_SEL()) return false;

    if (getMUTE_REAS_DIAG() < rhs.getMUTE_REAS_DIAG()) return true;
    if (getMUTE_REAS_DIAG() > rhs.getMUTE_REAS_DIAG()) return false;

    if (getMUTE_REAS_OTHER() < rhs.getMUTE_REAS_OTHER()) return true;
    if (getMUTE_REAS_OTHER() > rhs.getMUTE_REAS_OTHER()) return false;

    return false;
}

inline bool T_b32MuteReason::operator > (const T_b32MuteReason& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_b32MuteReason::setMUTE_REAS_USER_ACTION (bool MUTE_REAS_USER_ACTION) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MUTE_REAS_USER_ACTION = MUTE_REAS_USER_ACTION;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32MuteReason::getMUTE_REAS_USER_ACTION () const {
    return _MUTE_REAS_USER_ACTION;
}

inline void T_b32MuteReason::setMUTE_REAS_START_OF_TRACK (bool MUTE_REAS_START_OF_TRACK) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MUTE_REAS_START_OF_TRACK = MUTE_REAS_START_OF_TRACK;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32MuteReason::getMUTE_REAS_START_OF_TRACK () const {
    return _MUTE_REAS_START_OF_TRACK;
}

inline void T_b32MuteReason::setMUTE_REAS_SOURCE_SEL (bool MUTE_REAS_SOURCE_SEL) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MUTE_REAS_SOURCE_SEL = MUTE_REAS_SOURCE_SEL;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32MuteReason::getMUTE_REAS_SOURCE_SEL () const {
    return _MUTE_REAS_SOURCE_SEL;
}

inline void T_b32MuteReason::setMUTE_REAS_DIAG (bool MUTE_REAS_DIAG) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MUTE_REAS_DIAG = MUTE_REAS_DIAG;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32MuteReason::getMUTE_REAS_DIAG () const {
    return _MUTE_REAS_DIAG;
}

inline void T_b32MuteReason::setMUTE_REAS_OTHER (bool MUTE_REAS_OTHER) {
    // Disbale conversion check for setting the bitfield due to incorrect behavior.
    // See https://gcc.gnu.org/bugzilla/show_bug.cgi?id=39170
    #if defined(__GNUC__)
        #pragma GCC diagnostic push
        #pragma GCC diagnostic ignored "-Wconversion"
    #endif
    this->_MUTE_REAS_OTHER = MUTE_REAS_OTHER;
    #if defined(__GNUC__)
        #pragma GCC diagnostic pop
    #endif
}

inline bool T_b32MuteReason::getMUTE_REAS_OTHER () const {
    return _MUTE_REAS_OTHER;
}

inline  T_MuteRequestItem::T_MuteRequestItem ()  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u8Action (::mascf_aud_src_route_fi_types::T_e8MuteAction__Mute),
    _u32Reason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_MuteRequestItem::T_MuteRequestItem (const T_MuteRequestItem &rhs)  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u8Action (::mascf_aud_src_route_fi_types::T_e8MuteAction__Mute),
    _u32Reason ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_MuteRequestItem::T_MuteRequestItem (T_e8_AudSource u8Source_, T_e8MuteAction u8Action_, const T_b32MuteReason& u32Reason_)  :
    _u8Source (u8Source_),
    _u8Action (u8Action_),
    _u32Reason (u32Reason_)
{
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_MuteRequestItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8MuteAction_IsValid(u8Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Action_, "T_e8MuteAction", "u8Action", "T_MuteRequestItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_MuteRequestItem::~T_MuteRequestItem() {
}

inline T_MuteRequestItem& T_MuteRequestItem::operator = (const T_MuteRequestItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Source()) {
            setU8Source(rhs.getU8Source());
        } else {
            clearU8Source();
        }
        if (rhs.hasU8Action()) {
            setU8Action(rhs.getU8Action());
        } else {
            clearU8Action();
        }
        if (rhs.hasU32Reason()) {
            setU32Reason(rhs.getU32Reason());
        } else {
            clearU32Reason();
        }
    }
    return *this;
}

inline bool T_MuteRequestItem::operator == (const T_MuteRequestItem& rhs) const {
    return (((!hasU8Source() && !rhs.hasU8Source()) || getU8Source() == rhs.getU8Source()) &&
        ((!hasU8Action() && !rhs.hasU8Action()) || getU8Action() == rhs.getU8Action()) &&
        ((!hasU32Reason() && !rhs.hasU32Reason()) || getU32Reason() == rhs.getU32Reason()));
}

inline bool T_MuteRequestItem::operator != (const T_MuteRequestItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_MuteRequestItem::operator < (const T_MuteRequestItem& rhs) const {
    if (hasU8Source() || rhs.hasU8Source()) {
        if ((uint32)getU8Source() < (uint32)rhs.getU8Source()) return true;
        if ((uint32)getU8Source() > (uint32)rhs.getU8Source()) return false;
    }
    if (hasU8Action() || rhs.hasU8Action()) {
        if ((uint32)getU8Action() < (uint32)rhs.getU8Action()) return true;
        if ((uint32)getU8Action() > (uint32)rhs.getU8Action()) return false;
    }
    if (hasU32Reason() || rhs.hasU32Reason()) {
        if (getU32Reason() < rhs.getU32Reason()) return true;
        if (getU32Reason() > rhs.getU32Reason()) return false;
    }
    return false;
}

inline bool T_MuteRequestItem::operator > (const T_MuteRequestItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_MuteRequestItem::clear() {
    clearU8Source();
    clearU8Action();
    clearU32Reason();
}

inline void T_MuteRequestItem::clearU8Source() {
    if (hasU8Source()) {
         clear_has_u8Source();
        _u8Source = ::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE;
     }
}

inline bool T_MuteRequestItem::hasU8Source () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AudSource T_MuteRequestItem::getU8Source () const {
    return _u8Source;
}

inline void T_MuteRequestItem::setU8Source (T_e8_AudSource u8Source_) {
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_MuteRequestItem");
    }
    #endif
    set_has_u8Source();
    this->_u8Source = u8Source_;
}

inline void T_MuteRequestItem::clearU8Action() {
    if (hasU8Action()) {
         clear_has_u8Action();
        _u8Action = ::mascf_aud_src_route_fi_types::T_e8MuteAction__Mute;
     }
}

inline bool T_MuteRequestItem::hasU8Action () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8MuteAction T_MuteRequestItem::getU8Action () const {
    return _u8Action;
}

inline void T_MuteRequestItem::setU8Action (T_e8MuteAction u8Action_) {
    #ifndef NDEBUG
    if (!(T_e8MuteAction_IsValid(u8Action_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Action_, "T_e8MuteAction", "u8Action", "T_MuteRequestItem");
    }
    #endif
    set_has_u8Action();
    this->_u8Action = u8Action_;
}

inline void T_MuteRequestItem::clearU32Reason() {
    if (hasU32Reason()) {
         clear_has_u32Reason();
        _u32Reason = T_b32MuteReason ();
     }
}

inline bool T_MuteRequestItem::hasU32Reason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_b32MuteReason& T_MuteRequestItem::getU32Reason () const {
    return _u32Reason;
}

inline T_b32MuteReason& T_MuteRequestItem::getU32ReasonMutable () {
    set_has_u32Reason();
    return _u32Reason;
}

inline void T_MuteRequestItem::setU32Reason (const T_b32MuteReason& u32Reason_) {
    set_has_u32Reason();
    this->_u32Reason = u32Reason_;
}

inline void T_MuteRequestItem::set_has_u8Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_MuteRequestItem::clear_has_u8Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_MuteRequestItem::set_has_u8Action () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_MuteRequestItem::clear_has_u8Action () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_MuteRequestItem::set_has_u32Reason () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_MuteRequestItem::clear_has_u32Reason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_RequestAudioRouteItem::T_RequestAudioRouteItem ()  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u16SubSource (0u),
    _u8Reason (0u),
    _e8Activity (::mascf_aud_src_route_fi_types::T_e8_SrcActivity__Pause)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_RequestAudioRouteItem::T_RequestAudioRouteItem (const T_RequestAudioRouteItem &rhs)  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u16SubSource (0u),
    _u8Reason (0u),
    _e8Activity (::mascf_aud_src_route_fi_types::T_e8_SrcActivity__Pause)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_RequestAudioRouteItem::T_RequestAudioRouteItem (T_e8_AudSource u8Source_, uint16 u16SubSource_, uint8 u8Reason_, T_e8_SrcActivity e8Activity_)  :
    _u8Source (u8Source_),
    _u16SubSource (u16SubSource_),
    _u8Reason (u8Reason_),
    _e8Activity (e8Activity_)
{
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_RequestAudioRouteItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_SrcActivity_IsValid(e8Activity_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Activity_, "T_e8_SrcActivity", "e8Activity", "T_RequestAudioRouteItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_RequestAudioRouteItem::~T_RequestAudioRouteItem() {
}

inline T_RequestAudioRouteItem& T_RequestAudioRouteItem::operator = (const T_RequestAudioRouteItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Source()) {
            setU8Source(rhs.getU8Source());
        } else {
            clearU8Source();
        }
        if (rhs.hasU16SubSource()) {
            setU16SubSource(rhs.getU16SubSource());
        } else {
            clearU16SubSource();
        }
        if (rhs.hasU8Reason()) {
            setU8Reason(rhs.getU8Reason());
        } else {
            clearU8Reason();
        }
        if (rhs.hasE8Activity()) {
            setE8Activity(rhs.getE8Activity());
        } else {
            clearE8Activity();
        }
    }
    return *this;
}

inline bool T_RequestAudioRouteItem::operator == (const T_RequestAudioRouteItem& rhs) const {
    return (((!hasU8Source() && !rhs.hasU8Source()) || getU8Source() == rhs.getU8Source()) &&
        ((!hasU16SubSource() && !rhs.hasU16SubSource()) || getU16SubSource() == rhs.getU16SubSource()) &&
        ((!hasU8Reason() && !rhs.hasU8Reason()) || getU8Reason() == rhs.getU8Reason()) &&
        ((!hasE8Activity() && !rhs.hasE8Activity()) || getE8Activity() == rhs.getE8Activity()));
}

inline bool T_RequestAudioRouteItem::operator != (const T_RequestAudioRouteItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_RequestAudioRouteItem::operator < (const T_RequestAudioRouteItem& rhs) const {
    if (hasU8Source() || rhs.hasU8Source()) {
        if ((uint32)getU8Source() < (uint32)rhs.getU8Source()) return true;
        if ((uint32)getU8Source() > (uint32)rhs.getU8Source()) return false;
    }
    if (hasU16SubSource() || rhs.hasU16SubSource()) {
        if (getU16SubSource() < rhs.getU16SubSource()) return true;
        if (getU16SubSource() > rhs.getU16SubSource()) return false;
    }
    if (hasU8Reason() || rhs.hasU8Reason()) {
        if (getU8Reason() < rhs.getU8Reason()) return true;
        if (getU8Reason() > rhs.getU8Reason()) return false;
    }
    if (hasE8Activity() || rhs.hasE8Activity()) {
        if ((uint32)getE8Activity() < (uint32)rhs.getE8Activity()) return true;
        if ((uint32)getE8Activity() > (uint32)rhs.getE8Activity()) return false;
    }
    return false;
}

inline bool T_RequestAudioRouteItem::operator > (const T_RequestAudioRouteItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_RequestAudioRouteItem::clear() {
    clearU8Source();
    clearU16SubSource();
    clearU8Reason();
    clearE8Activity();
}

inline void T_RequestAudioRouteItem::clearU8Source() {
    if (hasU8Source()) {
         clear_has_u8Source();
        _u8Source = ::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE;
     }
}

inline bool T_RequestAudioRouteItem::hasU8Source () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AudSource T_RequestAudioRouteItem::getU8Source () const {
    return _u8Source;
}

inline void T_RequestAudioRouteItem::setU8Source (T_e8_AudSource u8Source_) {
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_RequestAudioRouteItem");
    }
    #endif
    set_has_u8Source();
    this->_u8Source = u8Source_;
}

inline void T_RequestAudioRouteItem::clearU16SubSource() {
    if (hasU16SubSource()) {
         clear_has_u16SubSource();
        _u16SubSource = 0u;
     }
}

inline bool T_RequestAudioRouteItem::hasU16SubSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_RequestAudioRouteItem::getU16SubSource () const {
    return _u16SubSource;
}

inline void T_RequestAudioRouteItem::setU16SubSource (uint16 u16SubSource_) {
    set_has_u16SubSource();
    this->_u16SubSource = u16SubSource_;
}

inline void T_RequestAudioRouteItem::clearU8Reason() {
    if (hasU8Reason()) {
         clear_has_u8Reason();
        _u8Reason = 0u;
     }
}

inline bool T_RequestAudioRouteItem::hasU8Reason () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_RequestAudioRouteItem::getU8Reason () const {
    return _u8Reason;
}

inline void T_RequestAudioRouteItem::setU8Reason (uint8 u8Reason_) {
    set_has_u8Reason();
    this->_u8Reason = u8Reason_;
}

inline void T_RequestAudioRouteItem::clearE8Activity() {
    if (hasE8Activity()) {
         clear_has_e8Activity();
        _e8Activity = ::mascf_aud_src_route_fi_types::T_e8_SrcActivity__Pause;
     }
}

inline bool T_RequestAudioRouteItem::hasE8Activity () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_SrcActivity T_RequestAudioRouteItem::getE8Activity () const {
    return _e8Activity;
}

inline void T_RequestAudioRouteItem::setE8Activity (T_e8_SrcActivity e8Activity_) {
    #ifndef NDEBUG
    if (!(T_e8_SrcActivity_IsValid(e8Activity_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Activity_, "T_e8_SrcActivity", "e8Activity", "T_RequestAudioRouteItem");
    }
    #endif
    set_has_e8Activity();
    this->_e8Activity = e8Activity_;
}

inline void T_RequestAudioRouteItem::set_has_u8Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_RequestAudioRouteItem::clear_has_u8Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_RequestAudioRouteItem::set_has_u16SubSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_RequestAudioRouteItem::clear_has_u16SubSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_RequestAudioRouteItem::set_has_u8Reason () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_RequestAudioRouteItem::clear_has_u8Reason () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_RequestAudioRouteItem::set_has_e8Activity () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_RequestAudioRouteItem::clear_has_e8Activity () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_SetAudioPropertyItem::T_SetAudioPropertyItem ()  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u16SubSource (0u),
    _u8Property (::mascf_aud_src_route_fi_types::T_e8_AudioProperty__AUDIO_PROP_VOLUME_LOCK),
    _s32PropValue (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SetAudioPropertyItem::T_SetAudioPropertyItem (const T_SetAudioPropertyItem &rhs)  :
    _u8Source (::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE),
    _u16SubSource (0u),
    _u8Property (::mascf_aud_src_route_fi_types::T_e8_AudioProperty__AUDIO_PROP_VOLUME_LOCK),
    _s32PropValue (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SetAudioPropertyItem::T_SetAudioPropertyItem (T_e8_AudSource u8Source_, uint16 u16SubSource_, T_e8_AudioProperty u8Property_, int32 s32PropValue_)  :
    _u8Source (u8Source_),
    _u16SubSource (u16SubSource_),
    _u8Property (u8Property_),
    _s32PropValue (s32PropValue_)
{
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_SetAudioPropertyItem");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_AudioProperty_IsValid(u8Property_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Property_, "T_e8_AudioProperty", "u8Property", "T_SetAudioPropertyItem");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SetAudioPropertyItem::~T_SetAudioPropertyItem() {
}

inline T_SetAudioPropertyItem& T_SetAudioPropertyItem::operator = (const T_SetAudioPropertyItem& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Source()) {
            setU8Source(rhs.getU8Source());
        } else {
            clearU8Source();
        }
        if (rhs.hasU16SubSource()) {
            setU16SubSource(rhs.getU16SubSource());
        } else {
            clearU16SubSource();
        }
        if (rhs.hasU8Property()) {
            setU8Property(rhs.getU8Property());
        } else {
            clearU8Property();
        }
        if (rhs.hasS32PropValue()) {
            setS32PropValue(rhs.getS32PropValue());
        } else {
            clearS32PropValue();
        }
    }
    return *this;
}

inline bool T_SetAudioPropertyItem::operator == (const T_SetAudioPropertyItem& rhs) const {
    return (((!hasU8Source() && !rhs.hasU8Source()) || getU8Source() == rhs.getU8Source()) &&
        ((!hasU16SubSource() && !rhs.hasU16SubSource()) || getU16SubSource() == rhs.getU16SubSource()) &&
        ((!hasU8Property() && !rhs.hasU8Property()) || getU8Property() == rhs.getU8Property()) &&
        ((!hasS32PropValue() && !rhs.hasS32PropValue()) || getS32PropValue() == rhs.getS32PropValue()));
}

inline bool T_SetAudioPropertyItem::operator != (const T_SetAudioPropertyItem& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SetAudioPropertyItem::operator < (const T_SetAudioPropertyItem& rhs) const {
    if (hasU8Source() || rhs.hasU8Source()) {
        if ((uint32)getU8Source() < (uint32)rhs.getU8Source()) return true;
        if ((uint32)getU8Source() > (uint32)rhs.getU8Source()) return false;
    }
    if (hasU16SubSource() || rhs.hasU16SubSource()) {
        if (getU16SubSource() < rhs.getU16SubSource()) return true;
        if (getU16SubSource() > rhs.getU16SubSource()) return false;
    }
    if (hasU8Property() || rhs.hasU8Property()) {
        if ((uint32)getU8Property() < (uint32)rhs.getU8Property()) return true;
        if ((uint32)getU8Property() > (uint32)rhs.getU8Property()) return false;
    }
    if (hasS32PropValue() || rhs.hasS32PropValue()) {
        if (getS32PropValue() < rhs.getS32PropValue()) return true;
        if (getS32PropValue() > rhs.getS32PropValue()) return false;
    }
    return false;
}

inline bool T_SetAudioPropertyItem::operator > (const T_SetAudioPropertyItem& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SetAudioPropertyItem::clear() {
    clearU8Source();
    clearU16SubSource();
    clearU8Property();
    clearS32PropValue();
}

inline void T_SetAudioPropertyItem::clearU8Source() {
    if (hasU8Source()) {
         clear_has_u8Source();
        _u8Source = ::mascf_aud_src_route_fi_types::T_e8_AudSource__NONE;
     }
}

inline bool T_SetAudioPropertyItem::hasU8Source () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_AudSource T_SetAudioPropertyItem::getU8Source () const {
    return _u8Source;
}

inline void T_SetAudioPropertyItem::setU8Source (T_e8_AudSource u8Source_) {
    #ifndef NDEBUG
    if (!(T_e8_AudSource_IsValid(u8Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Source_, "T_e8_AudSource", "u8Source", "T_SetAudioPropertyItem");
    }
    #endif
    set_has_u8Source();
    this->_u8Source = u8Source_;
}

inline void T_SetAudioPropertyItem::clearU16SubSource() {
    if (hasU16SubSource()) {
         clear_has_u16SubSource();
        _u16SubSource = 0u;
     }
}

inline bool T_SetAudioPropertyItem::hasU16SubSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_SetAudioPropertyItem::getU16SubSource () const {
    return _u16SubSource;
}

inline void T_SetAudioPropertyItem::setU16SubSource (uint16 u16SubSource_) {
    set_has_u16SubSource();
    this->_u16SubSource = u16SubSource_;
}

inline void T_SetAudioPropertyItem::clearU8Property() {
    if (hasU8Property()) {
         clear_has_u8Property();
        _u8Property = ::mascf_aud_src_route_fi_types::T_e8_AudioProperty__AUDIO_PROP_VOLUME_LOCK;
     }
}

inline bool T_SetAudioPropertyItem::hasU8Property () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline T_e8_AudioProperty T_SetAudioPropertyItem::getU8Property () const {
    return _u8Property;
}

inline void T_SetAudioPropertyItem::setU8Property (T_e8_AudioProperty u8Property_) {
    #ifndef NDEBUG
    if (!(T_e8_AudioProperty_IsValid(u8Property_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", u8Property_, "T_e8_AudioProperty", "u8Property", "T_SetAudioPropertyItem");
    }
    #endif
    set_has_u8Property();
    this->_u8Property = u8Property_;
}

inline void T_SetAudioPropertyItem::clearS32PropValue() {
    if (hasS32PropValue()) {
         clear_has_s32PropValue();
        _s32PropValue = 0;
     }
}

inline bool T_SetAudioPropertyItem::hasS32PropValue () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 T_SetAudioPropertyItem::getS32PropValue () const {
    return _s32PropValue;
}

inline void T_SetAudioPropertyItem::setS32PropValue (int32 s32PropValue_) {
    set_has_s32PropValue();
    this->_s32PropValue = s32PropValue_;
}

inline void T_SetAudioPropertyItem::set_has_u8Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SetAudioPropertyItem::clear_has_u8Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SetAudioPropertyItem::set_has_u16SubSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SetAudioPropertyItem::clear_has_u16SubSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SetAudioPropertyItem::set_has_u8Property () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SetAudioPropertyItem::clear_has_u8Property () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_SetAudioPropertyItem::set_has_s32PropValue () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_SetAudioPropertyItem::clear_has_s32PropValue () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace mascf_aud_src_route_fi_types

#endif // MASCF_AUD_SRC_ROUTE_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
