/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "lcmdbusclient_main_fiCca.h"
#include "lcmdbusclient_main_fiJson.h"
#include "lcmdbusclient_main_fiProxy.h"
#include "lcmdbusclient_main_fi_types.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace lcmdbusclient_main_fi {

/*static*/ ::asf::core::Logger Lcmdbusclient_main_fiProxy::_logger ("/lcmdbusclient_main_fi/Lcmdbusclient_main_fiProxy");


class Lcmdbusclient_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Lcmdbusclient_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Lcmdbusclient_main_fiProxy> proxy = ::boost::static_pointer_cast<Lcmdbusclient_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_CurrentSource: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::CurrentSourceStatus);
                                setActAndLogStatus(message, "CurrentSource", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CurrentSourceStatus> payload = ::boost::static_pointer_cast<CurrentSourceStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CurrentSourceStatus >& refNullableStatus = proxy->_currentSource;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CurrentSourceCallbackIF*) _callback)->onCurrentSourceStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CurrentSourceCallbackIF*) _callback)->onCurrentSourceStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::CurrentSourceError);
                                setActAndLogError(message, "CurrentSource", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((CurrentSourceCallbackIF*) _callback)->onCurrentSourceError(proxy, ::boost::static_pointer_cast<CurrentSourceError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_NanomsgStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::NanomsgStatusStatus);
                                setActAndLogStatus(message, "NanomsgStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<NanomsgStatusStatus> payload = ::boost::static_pointer_cast<NanomsgStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< NanomsgStatusStatus >& refNullableStatus = proxy->_nanomsgStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((NanomsgStatusCallbackIF*) _callback)->onNanomsgStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((NanomsgStatusCallbackIF*) _callback)->onNanomsgStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::NanomsgStatusError);
                                setActAndLogError(message, "NanomsgStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((NanomsgStatusCallbackIF*) _callback)->onNanomsgStatusError(proxy, ::boost::static_pointer_cast<NanomsgStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_SubsystemerrorStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::SubsystemerrorStatusStatus);
                                setActAndLogStatus(message, "SubsystemerrorStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<SubsystemerrorStatusStatus> payload = ::boost::static_pointer_cast<SubsystemerrorStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< SubsystemerrorStatusStatus >& refNullableStatus = proxy->_subsystemerrorStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((SubsystemerrorStatusCallbackIF*) _callback)->onSubsystemerrorStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SubsystemerrorStatusCallbackIF*) _callback)->onSubsystemerrorStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::SubsystemerrorStatusError);
                                setActAndLogError(message, "SubsystemerrorStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((SubsystemerrorStatusCallbackIF*) _callback)->onSubsystemerrorStatusError(proxy, ::boost::static_pointer_cast<SubsystemerrorStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_VoltagelevelStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::VoltagelevelStatusStatus);
                                setActAndLogStatus(message, "VoltagelevelStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<VoltagelevelStatusStatus> payload = ::boost::static_pointer_cast<VoltagelevelStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< VoltagelevelStatusStatus >& refNullableStatus = proxy->_voltagelevelStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((VoltagelevelStatusCallbackIF*) _callback)->onVoltagelevelStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VoltagelevelStatusCallbackIF*) _callback)->onVoltagelevelStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::VoltagelevelStatusError);
                                setActAndLogError(message, "VoltagelevelStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((VoltagelevelStatusCallbackIF*) _callback)->onVoltagelevelStatusError(proxy, ::boost::static_pointer_cast<VoltagelevelStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_CockpitmodeStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::CockpitmodeStatusStatus);
                                setActAndLogStatus(message, "CockpitmodeStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<CockpitmodeStatusStatus> payload = ::boost::static_pointer_cast<CockpitmodeStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< CockpitmodeStatusStatus >& refNullableStatus = proxy->_cockpitmodeStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((CockpitmodeStatusCallbackIF*) _callback)->onCockpitmodeStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CockpitmodeStatusCallbackIF*) _callback)->onCockpitmodeStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::CockpitmodeStatusError);
                                setActAndLogError(message, "CockpitmodeStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((CockpitmodeStatusCallbackIF*) _callback)->onCockpitmodeStatusError(proxy, ::boost::static_pointer_cast<CockpitmodeStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_ThermallevelStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::ThermallevelStatusStatus);
                                setActAndLogStatus(message, "ThermallevelStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<ThermallevelStatusStatus> payload = ::boost::static_pointer_cast<ThermallevelStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< ThermallevelStatusStatus >& refNullableStatus = proxy->_thermallevelStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((ThermallevelStatusCallbackIF*) _callback)->onThermallevelStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ThermallevelStatusCallbackIF*) _callback)->onThermallevelStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::ThermallevelStatusError);
                                setActAndLogError(message, "ThermallevelStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((ThermallevelStatusCallbackIF*) _callback)->onThermallevelStatusError(proxy, ::boost::static_pointer_cast<ThermallevelStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DoorUnlockStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::DoorUnlockStatusStatus);
                                setActAndLogStatus(message, "DoorUnlockStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<DoorUnlockStatusStatus> payload = ::boost::static_pointer_cast<DoorUnlockStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< DoorUnlockStatusStatus >& refNullableStatus = proxy->_doorUnlockStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((DoorUnlockStatusCallbackIF*) _callback)->onDoorUnlockStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DoorUnlockStatusCallbackIF*) _callback)->onDoorUnlockStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::DoorUnlockStatusError);
                                setActAndLogError(message, "DoorUnlockStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((DoorUnlockStatusCallbackIF*) _callback)->onDoorUnlockStatusError(proxy, ::boost::static_pointer_cast<DoorUnlockStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PNMGRP10SignalStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::PNMGRP10SignalStatusStatus);
                                setActAndLogStatus(message, "PNMGRP10SignalStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PNMGRP10SignalStatusStatus> payload = ::boost::static_pointer_cast<PNMGRP10SignalStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PNMGRP10SignalStatusStatus >& refNullableStatus = proxy->_pNMGRP10SignalStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PNMGRP10SignalStatusCallbackIF*) _callback)->onPNMGRP10SignalStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PNMGRP10SignalStatusCallbackIF*) _callback)->onPNMGRP10SignalStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::lcmdbusclient_main_fi::PNMGRP10SignalStatusError);
                                setActAndLogError(message, "PNMGRP10SignalStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((PNMGRP10SignalStatusCallbackIF*) _callback)->onPNMGRP10SignalStatusError(proxy, ::boost::static_pointer_cast<PNMGRP10SignalStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Lcmdbusclient_main_fiProxy> proxy = ::boost::static_pointer_cast<Lcmdbusclient_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_CurrentSource: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< CurrentSourceError > payload (new CurrentSourceError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CurrentSource", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CurrentSourceCallbackIF*) _callback)->onCurrentSourceError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_NanomsgStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< NanomsgStatusError > payload (new NanomsgStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NanomsgStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((NanomsgStatusCallbackIF*) _callback)->onNanomsgStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_SubsystemerrorStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< SubsystemerrorStatusError > payload (new SubsystemerrorStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SubsystemerrorStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((SubsystemerrorStatusCallbackIF*) _callback)->onSubsystemerrorStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_VoltagelevelStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< VoltagelevelStatusError > payload (new VoltagelevelStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "VoltagelevelStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((VoltagelevelStatusCallbackIF*) _callback)->onVoltagelevelStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_CockpitmodeStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< CockpitmodeStatusError > payload (new CockpitmodeStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CockpitmodeStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((CockpitmodeStatusCallbackIF*) _callback)->onCockpitmodeStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_ThermallevelStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< ThermallevelStatusError > payload (new ThermallevelStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ThermallevelStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((ThermallevelStatusCallbackIF*) _callback)->onThermallevelStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_DoorUnlockStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< DoorUnlockStatusError > payload (new DoorUnlockStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DoorUnlockStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((DoorUnlockStatusCallbackIF*) _callback)->onDoorUnlockStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_PNMGRP10SignalStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< PNMGRP10SignalStatusError > payload (new PNMGRP10SignalStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PNMGRP10SignalStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PNMGRP10SignalStatusCallbackIF*) _callback)->onPNMGRP10SignalStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Lcmdbusclient_main_fiProxyCallback::_logger (Lcmdbusclient_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Lcmdbusclient_main_fiProxy > Lcmdbusclient_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Lcmdbusclient_main_fiProxy >  proxyNew(new Lcmdbusclient_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Lcmdbusclient_main_fiProxy > Lcmdbusclient_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Lcmdbusclient_main_fiProxy >  proxyNew(new Lcmdbusclient_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Lcmdbusclient_main_fiProxy > Lcmdbusclient_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Lcmdbusclient_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Lcmdbusclient_main_fiProxy >  proxyNew(new Lcmdbusclient_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Lcmdbusclient_main_fiProxy::Lcmdbusclient_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Lcmdbusclient_main_fiProxy::~Lcmdbusclient_main_fiProxy()
{
    LOG_INFO ("Entering ~Lcmdbusclient_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Lcmdbusclient_main_fiProxy::sendCurrentSourceUpReg(CurrentSourceCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CurrentSource);
        ::boost::shared_ptr< CurrentSourceUpReg > payload (new CurrentSourceUpReg());
        CCA_MESSAGE(ccaMessage,header,CurrentSourceUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CurrentSourceRelUpReg > payloadRelUpRegHeap (new CurrentSourceRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CurrentSource, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::CurrentSourceRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CurrentSource, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CurrentSource", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CurrentSource", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCurrentSource()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CurrentSource, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CurrentSourceStatus > payloadLoopback (new CurrentSourceStatus(getCurrentSource()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CurrentSourceStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CurrentSource);
        ::boost::shared_ptr< CurrentSourceError > payload (new CurrentSourceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CurrentSourceError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CurrentSource", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendCurrentSourceRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CurrentSource,"CurrentSource");
}

void Lcmdbusclient_main_fiProxy::sendCurrentSourceRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CurrentSource);
}

const CurrentSourceStatus& Lcmdbusclient_main_fiProxy::getCurrentSource() const {
    return _currentSource.get();
}

bool Lcmdbusclient_main_fiProxy::hasCurrentSource() const {
    return _currentSource.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendCurrentSourceGet(CurrentSourceCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CurrentSource);
        ::boost::shared_ptr< CurrentSourceGet > payload (new CurrentSourceGet());
        CCA_MESSAGE(ccaMessage,header,CurrentSourceGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CurrentSource", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CurrentSource);
        ::boost::shared_ptr< CurrentSourceError > payload (new CurrentSourceError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CurrentSourceError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CurrentSource", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendNanomsgStatusUpReg(NanomsgStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_NanomsgStatus);
        ::boost::shared_ptr< NanomsgStatusUpReg > payload (new NanomsgStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,NanomsgStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< NanomsgStatusRelUpReg > payloadRelUpRegHeap (new NanomsgStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_NanomsgStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::NanomsgStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_NanomsgStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "NanomsgStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "NanomsgStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasNanomsgStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_NanomsgStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< NanomsgStatusStatus > payloadLoopback (new NanomsgStatusStatus(getNanomsgStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,NanomsgStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NanomsgStatus);
        ::boost::shared_ptr< NanomsgStatusError > payload (new NanomsgStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NanomsgStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "NanomsgStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendNanomsgStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_NanomsgStatus,"NanomsgStatus");
}

void Lcmdbusclient_main_fiProxy::sendNanomsgStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_NanomsgStatus);
}

const NanomsgStatusStatus& Lcmdbusclient_main_fiProxy::getNanomsgStatus() const {
    return _nanomsgStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasNanomsgStatus() const {
    return _nanomsgStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendNanomsgStatusGet(NanomsgStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_NanomsgStatus);
        ::boost::shared_ptr< NanomsgStatusGet > payload (new NanomsgStatusGet());
        CCA_MESSAGE(ccaMessage,header,NanomsgStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "NanomsgStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NanomsgStatus);
        ::boost::shared_ptr< NanomsgStatusError > payload (new NanomsgStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NanomsgStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "NanomsgStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendNanomsgStatusSet(NanomsgStatusCallbackIF& cb, bool nanomsgconstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_NanomsgStatus);
        ::boost::shared_ptr< NanomsgStatusSet > payload (new NanomsgStatusSet());
        payload->setNanomsgconstate(nanomsgconstate);
        CCA_MESSAGE(ccaMessage,header,NanomsgStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "NanomsgStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_NanomsgStatus);
        ::boost::shared_ptr< NanomsgStatusError > payload (new NanomsgStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,NanomsgStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "NanomsgStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendSubsystemerrorStatusUpReg(SubsystemerrorStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_SubsystemerrorStatus);
        ::boost::shared_ptr< SubsystemerrorStatusUpReg > payload (new SubsystemerrorStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,SubsystemerrorStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< SubsystemerrorStatusRelUpReg > payloadRelUpRegHeap (new SubsystemerrorStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_SubsystemerrorStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::SubsystemerrorStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_SubsystemerrorStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "SubsystemerrorStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "SubsystemerrorStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasSubsystemerrorStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_SubsystemerrorStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< SubsystemerrorStatusStatus > payloadLoopback (new SubsystemerrorStatusStatus(getSubsystemerrorStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,SubsystemerrorStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubsystemerrorStatus);
        ::boost::shared_ptr< SubsystemerrorStatusError > payload (new SubsystemerrorStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubsystemerrorStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "SubsystemerrorStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendSubsystemerrorStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_SubsystemerrorStatus,"SubsystemerrorStatus");
}

void Lcmdbusclient_main_fiProxy::sendSubsystemerrorStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_SubsystemerrorStatus);
}

const SubsystemerrorStatusStatus& Lcmdbusclient_main_fiProxy::getSubsystemerrorStatus() const {
    return _subsystemerrorStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasSubsystemerrorStatus() const {
    return _subsystemerrorStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendSubsystemerrorStatusGet(SubsystemerrorStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_SubsystemerrorStatus);
        ::boost::shared_ptr< SubsystemerrorStatusGet > payload (new SubsystemerrorStatusGet());
        CCA_MESSAGE(ccaMessage,header,SubsystemerrorStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "SubsystemerrorStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubsystemerrorStatus);
        ::boost::shared_ptr< SubsystemerrorStatusError > payload (new SubsystemerrorStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubsystemerrorStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "SubsystemerrorStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendSubsystemerrorStatusSet(SubsystemerrorStatusCallbackIF& cb, const ::lcmdbusclient_main_fi_types::TheSubsystemList& subsystemerrorconstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_SubsystemerrorStatus);
        ::boost::shared_ptr< SubsystemerrorStatusSet > payload (new SubsystemerrorStatusSet());
        payload->setSubsystemerrorconstate(subsystemerrorconstate);
        CCA_MESSAGE(ccaMessage,header,SubsystemerrorStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "SubsystemerrorStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_SubsystemerrorStatus);
        ::boost::shared_ptr< SubsystemerrorStatusError > payload (new SubsystemerrorStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SubsystemerrorStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "SubsystemerrorStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendVoltagelevelStatusUpReg(VoltagelevelStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_VoltagelevelStatus);
        ::boost::shared_ptr< VoltagelevelStatusUpReg > payload (new VoltagelevelStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,VoltagelevelStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< VoltagelevelStatusRelUpReg > payloadRelUpRegHeap (new VoltagelevelStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_VoltagelevelStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::VoltagelevelStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_VoltagelevelStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "VoltagelevelStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "VoltagelevelStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasVoltagelevelStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_VoltagelevelStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< VoltagelevelStatusStatus > payloadLoopback (new VoltagelevelStatusStatus(getVoltagelevelStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,VoltagelevelStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltagelevelStatus);
        ::boost::shared_ptr< VoltagelevelStatusError > payload (new VoltagelevelStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltagelevelStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "VoltagelevelStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendVoltagelevelStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_VoltagelevelStatus,"VoltagelevelStatus");
}

void Lcmdbusclient_main_fiProxy::sendVoltagelevelStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_VoltagelevelStatus);
}

const VoltagelevelStatusStatus& Lcmdbusclient_main_fiProxy::getVoltagelevelStatus() const {
    return _voltagelevelStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasVoltagelevelStatus() const {
    return _voltagelevelStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendVoltagelevelStatusGet(VoltagelevelStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_VoltagelevelStatus);
        ::boost::shared_ptr< VoltagelevelStatusGet > payload (new VoltagelevelStatusGet());
        CCA_MESSAGE(ccaMessage,header,VoltagelevelStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "VoltagelevelStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltagelevelStatus);
        ::boost::shared_ptr< VoltagelevelStatusError > payload (new VoltagelevelStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltagelevelStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "VoltagelevelStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendVoltagelevelStatusSet(VoltagelevelStatusCallbackIF& cb, uint8 voltagelevelconstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_VoltagelevelStatus);
        ::boost::shared_ptr< VoltagelevelStatusSet > payload (new VoltagelevelStatusSet());
        payload->setVoltagelevelconstate(voltagelevelconstate);
        CCA_MESSAGE(ccaMessage,header,VoltagelevelStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "VoltagelevelStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_VoltagelevelStatus);
        ::boost::shared_ptr< VoltagelevelStatusError > payload (new VoltagelevelStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,VoltagelevelStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "VoltagelevelStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendCockpitmodeStatusUpReg(CockpitmodeStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_CockpitmodeStatus);
        ::boost::shared_ptr< CockpitmodeStatusUpReg > payload (new CockpitmodeStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,CockpitmodeStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< CockpitmodeStatusRelUpReg > payloadRelUpRegHeap (new CockpitmodeStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_CockpitmodeStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::CockpitmodeStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_CockpitmodeStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "CockpitmodeStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "CockpitmodeStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasCockpitmodeStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_CockpitmodeStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< CockpitmodeStatusStatus > payloadLoopback (new CockpitmodeStatusStatus(getCockpitmodeStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,CockpitmodeStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CockpitmodeStatus);
        ::boost::shared_ptr< CockpitmodeStatusError > payload (new CockpitmodeStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CockpitmodeStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "CockpitmodeStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendCockpitmodeStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_CockpitmodeStatus,"CockpitmodeStatus");
}

void Lcmdbusclient_main_fiProxy::sendCockpitmodeStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_CockpitmodeStatus);
}

const CockpitmodeStatusStatus& Lcmdbusclient_main_fiProxy::getCockpitmodeStatus() const {
    return _cockpitmodeStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasCockpitmodeStatus() const {
    return _cockpitmodeStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendCockpitmodeStatusGet(CockpitmodeStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_CockpitmodeStatus);
        ::boost::shared_ptr< CockpitmodeStatusGet > payload (new CockpitmodeStatusGet());
        CCA_MESSAGE(ccaMessage,header,CockpitmodeStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "CockpitmodeStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CockpitmodeStatus);
        ::boost::shared_ptr< CockpitmodeStatusError > payload (new CockpitmodeStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CockpitmodeStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "CockpitmodeStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendCockpitmodeStatusSet(CockpitmodeStatusCallbackIF& cb, uint8 cockpitmodeconstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_CockpitmodeStatus);
        ::boost::shared_ptr< CockpitmodeStatusSet > payload (new CockpitmodeStatusSet());
        payload->setCockpitmodeconstate(cockpitmodeconstate);
        CCA_MESSAGE(ccaMessage,header,CockpitmodeStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "CockpitmodeStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_CockpitmodeStatus);
        ::boost::shared_ptr< CockpitmodeStatusError > payload (new CockpitmodeStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,CockpitmodeStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "CockpitmodeStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendThermallevelStatusUpReg(ThermallevelStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_ThermallevelStatus);
        ::boost::shared_ptr< ThermallevelStatusUpReg > payload (new ThermallevelStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,ThermallevelStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< ThermallevelStatusRelUpReg > payloadRelUpRegHeap (new ThermallevelStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_ThermallevelStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::ThermallevelStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_ThermallevelStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "ThermallevelStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "ThermallevelStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasThermallevelStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_ThermallevelStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< ThermallevelStatusStatus > payloadLoopback (new ThermallevelStatusStatus(getThermallevelStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,ThermallevelStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ThermallevelStatus);
        ::boost::shared_ptr< ThermallevelStatusError > payload (new ThermallevelStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ThermallevelStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "ThermallevelStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendThermallevelStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_ThermallevelStatus,"ThermallevelStatus");
}

void Lcmdbusclient_main_fiProxy::sendThermallevelStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_ThermallevelStatus);
}

const ThermallevelStatusStatus& Lcmdbusclient_main_fiProxy::getThermallevelStatus() const {
    return _thermallevelStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasThermallevelStatus() const {
    return _thermallevelStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendThermallevelStatusGet(ThermallevelStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_ThermallevelStatus);
        ::boost::shared_ptr< ThermallevelStatusGet > payload (new ThermallevelStatusGet());
        CCA_MESSAGE(ccaMessage,header,ThermallevelStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "ThermallevelStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ThermallevelStatus);
        ::boost::shared_ptr< ThermallevelStatusError > payload (new ThermallevelStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ThermallevelStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "ThermallevelStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendThermallevelStatusSet(ThermallevelStatusCallbackIF& cb, uint16 thermallevelconstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_ThermallevelStatus);
        ::boost::shared_ptr< ThermallevelStatusSet > payload (new ThermallevelStatusSet());
        payload->setThermallevelconstate(thermallevelconstate);
        CCA_MESSAGE(ccaMessage,header,ThermallevelStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "ThermallevelStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_ThermallevelStatus);
        ::boost::shared_ptr< ThermallevelStatusError > payload (new ThermallevelStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,ThermallevelStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "ThermallevelStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendDoorUnlockStatusUpReg(DoorUnlockStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_DoorUnlockStatus);
        ::boost::shared_ptr< DoorUnlockStatusUpReg > payload (new DoorUnlockStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,DoorUnlockStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< DoorUnlockStatusRelUpReg > payloadRelUpRegHeap (new DoorUnlockStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_DoorUnlockStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::DoorUnlockStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_DoorUnlockStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "DoorUnlockStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "DoorUnlockStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasDoorUnlockStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_DoorUnlockStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< DoorUnlockStatusStatus > payloadLoopback (new DoorUnlockStatusStatus(getDoorUnlockStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,DoorUnlockStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoorUnlockStatus);
        ::boost::shared_ptr< DoorUnlockStatusError > payload (new DoorUnlockStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoorUnlockStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "DoorUnlockStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendDoorUnlockStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_DoorUnlockStatus,"DoorUnlockStatus");
}

void Lcmdbusclient_main_fiProxy::sendDoorUnlockStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_DoorUnlockStatus);
}

const DoorUnlockStatusStatus& Lcmdbusclient_main_fiProxy::getDoorUnlockStatus() const {
    return _doorUnlockStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasDoorUnlockStatus() const {
    return _doorUnlockStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendDoorUnlockStatusGet(DoorUnlockStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_DoorUnlockStatus);
        ::boost::shared_ptr< DoorUnlockStatusGet > payload (new DoorUnlockStatusGet());
        CCA_MESSAGE(ccaMessage,header,DoorUnlockStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "DoorUnlockStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoorUnlockStatus);
        ::boost::shared_ptr< DoorUnlockStatusError > payload (new DoorUnlockStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoorUnlockStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "DoorUnlockStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendDoorUnlockStatusSet(DoorUnlockStatusCallbackIF& cb, bool doorUnlockconstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_DoorUnlockStatus);
        ::boost::shared_ptr< DoorUnlockStatusSet > payload (new DoorUnlockStatusSet());
        payload->setDoorUnlockconstate(doorUnlockconstate);
        CCA_MESSAGE(ccaMessage,header,DoorUnlockStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "DoorUnlockStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DoorUnlockStatus);
        ::boost::shared_ptr< DoorUnlockStatusError > payload (new DoorUnlockStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DoorUnlockStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "DoorUnlockStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendPNMGRP10SignalStatusUpReg(PNMGRP10SignalStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PNMGRP10SignalStatus);
        ::boost::shared_ptr< PNMGRP10SignalStatusUpReg > payload (new PNMGRP10SignalStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,PNMGRP10SignalStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PNMGRP10SignalStatusRelUpReg > payloadRelUpRegHeap (new PNMGRP10SignalStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PNMGRP10SignalStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::lcmdbusclient_main_fi::PNMGRP10SignalStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PNMGRP10SignalStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PNMGRP10SignalStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PNMGRP10SignalStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPNMGRP10SignalStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PNMGRP10SignalStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PNMGRP10SignalStatusStatus > payloadLoopback (new PNMGRP10SignalStatusStatus(getPNMGRP10SignalStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PNMGRP10SignalStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PNMGRP10SignalStatus);
        ::boost::shared_ptr< PNMGRP10SignalStatusError > payload (new PNMGRP10SignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PNMGRP10SignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PNMGRP10SignalStatus", &cb);
    }
}

bool Lcmdbusclient_main_fiProxy::sendPNMGRP10SignalStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PNMGRP10SignalStatus,"PNMGRP10SignalStatus");
}

void Lcmdbusclient_main_fiProxy::sendPNMGRP10SignalStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PNMGRP10SignalStatus);
}

const PNMGRP10SignalStatusStatus& Lcmdbusclient_main_fiProxy::getPNMGRP10SignalStatus() const {
    return _pNMGRP10SignalStatus.get();
}

bool Lcmdbusclient_main_fiProxy::hasPNMGRP10SignalStatus() const {
    return _pNMGRP10SignalStatus.hasValue();
}

act_t Lcmdbusclient_main_fiProxy::sendPNMGRP10SignalStatusGet(PNMGRP10SignalStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PNMGRP10SignalStatus);
        ::boost::shared_ptr< PNMGRP10SignalStatusGet > payload (new PNMGRP10SignalStatusGet());
        CCA_MESSAGE(ccaMessage,header,PNMGRP10SignalStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PNMGRP10SignalStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PNMGRP10SignalStatus);
        ::boost::shared_ptr< PNMGRP10SignalStatusError > payload (new PNMGRP10SignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PNMGRP10SignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PNMGRP10SignalStatus", &cb);
    }
}

act_t Lcmdbusclient_main_fiProxy::sendPNMGRP10SignalStatusSet(PNMGRP10SignalStatusCallbackIF& cb, uint8 pNMGRP10Signalstate) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_PNMGRP10SignalStatus);
        ::boost::shared_ptr< PNMGRP10SignalStatusSet > payload (new PNMGRP10SignalStatusSet());
        payload->setPNMGRP10Signalstate(pNMGRP10Signalstate);
        CCA_MESSAGE(ccaMessage,header,PNMGRP10SignalStatusSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "PNMGRP10SignalStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PNMGRP10SignalStatus);
        ::boost::shared_ptr< PNMGRP10SignalStatusError > payload (new PNMGRP10SignalStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PNMGRP10SignalStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "PNMGRP10SignalStatus", &cb);
    }
}


void Lcmdbusclient_main_fiProxy::clearAllProperties ()
{
    _currentSource = ::asf::core::nullable<CurrentSourceStatus>();
    _nanomsgStatus = ::asf::core::nullable<NanomsgStatusStatus>();
    _subsystemerrorStatus = ::asf::core::nullable<SubsystemerrorStatusStatus>();
    _voltagelevelStatus = ::asf::core::nullable<VoltagelevelStatusStatus>();
    _cockpitmodeStatus = ::asf::core::nullable<CockpitmodeStatusStatus>();
    _thermallevelStatus = ::asf::core::nullable<ThermallevelStatusStatus>();
    _doorUnlockStatus = ::asf::core::nullable<DoorUnlockStatusStatus>();
    _pNMGRP10SignalStatus = ::asf::core::nullable<PNMGRP10SignalStatusStatus>();
}

void Lcmdbusclient_main_fiProxy::sendRelUpRegAll()
{
    sendCurrentSourceRelUpRegAll();
    sendNanomsgStatusRelUpRegAll();
    sendSubsystemerrorStatusRelUpRegAll();
    sendVoltagelevelStatusRelUpRegAll();
    sendCockpitmodeStatusRelUpRegAll();
    sendThermallevelStatusRelUpRegAll();
    sendDoorUnlockStatusRelUpRegAll();
    sendPNMGRP10SignalStatusRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Lcmdbusclient_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Lcmdbusclient_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace lcmdbusclient_main_fi
