/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef LCM_DBUSCTRL_FIPROXY_H
#define LCM_DBUSCTRL_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "lcm_dbusctrl_fi.h"
#include "lcm_dbusctrl_fi_typesConst.h"
#include <string>

namespace lcm_dbusctrl_fi {

class Lcm_dbusctrl_fiProxy;

class AppEndCallbackIF {
public:
    virtual ~AppEndCallbackIF() {}

    virtual void onAppEndError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppEndError >& error) = 0;

    virtual void onAppEndStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppEndStatus >& status) = 0;
};

class AppInitializedCallbackIF {
public:
    virtual ~AppInitializedCallbackIF() {}

    virtual void onAppInitializedError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppInitializedError >& error) = 0;

    virtual void onAppInitializedStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppInitializedStatus >& status) = 0;
};

class AppStartRequestCallbackIF {
public:
    virtual ~AppStartRequestCallbackIF() {}

    virtual void onAppStartRequestError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppStartRequestError >& error) = 0;

    virtual void onAppStartRequestStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppStartRequestStatus >& status) = 0;
};

class AppStateChangeCallbackIF {
public:
    virtual ~AppStateChangeCallbackIF() {}

    virtual void onAppStateChangeError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppStateChangeError >& error) = 0;

    virtual void onAppStateChangeStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< AppStateChangeStatus >& status) = 0;
};

class FailedServicesListCallbackIF {
public:
    virtual ~FailedServicesListCallbackIF() {}

    virtual void onFailedServicesListError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< FailedServicesListError >& error) = 0;

    virtual void onFailedServicesListStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< FailedServicesListStatus >& status) = 0;
};

class GetProcessIdCallbackIF {
public:
    virtual ~GetProcessIdCallbackIF() {}

    virtual void onGetProcessIdError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< GetProcessIdError >& error) = 0;

    virtual void onGetProcessIdResult(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< GetProcessIdResult >& result) = 0;
};

class NewProcessIdCallbackIF {
public:
    virtual ~NewProcessIdCallbackIF() {}

    virtual void onNewProcessIdError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< NewProcessIdError >& error) = 0;

    virtual void onNewProcessIdStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< NewProcessIdStatus >& status) = 0;
};

class NewServiceLoadedCallbackIF {
public:
    virtual ~NewServiceLoadedCallbackIF() {}

    virtual void onNewServiceLoadedError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< NewServiceLoadedError >& error) = 0;

    virtual void onNewServiceLoadedStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< NewServiceLoadedStatus >& status) = 0;
};

class RestartProcessCallbackIF {
public:
    virtual ~RestartProcessCallbackIF() {}

    virtual void onRestartProcessError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< RestartProcessError >& error) = 0;

    virtual void onRestartProcessResult(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< RestartProcessResult >& result) = 0;
};

class StartProcessCallbackIF {
public:
    virtual ~StartProcessCallbackIF() {}

    virtual void onStartProcessError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StartProcessError >& error) = 0;

    virtual void onStartProcessResult(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StartProcessResult >& result) = 0;
};

class StartupFailureIndicationCallbackIF {
public:
    virtual ~StartupFailureIndicationCallbackIF() {}

    virtual void onStartupFailureIndicationError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StartupFailureIndicationError >& error) = 0;

    virtual void onStartupFailureIndicationStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StartupFailureIndicationStatus >& status) = 0;
};

class StartupFinishedCallbackIF {
public:
    virtual ~StartupFinishedCallbackIF() {}

    virtual void onStartupFinishedError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StartupFinishedError >& error) = 0;

    virtual void onStartupFinishedResult(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StartupFinishedResult >& result) = 0;
};

class StopProcessCallbackIF {
public:
    virtual ~StopProcessCallbackIF() {}

    virtual void onStopProcessError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StopProcessError >& error) = 0;

    virtual void onStopProcessResult(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< StopProcessResult >& result) = 0;
};

class SupervisionStateChangeCallbackIF {
public:
    virtual ~SupervisionStateChangeCallbackIF() {}

    virtual void onSupervisionStateChangeError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< SupervisionStateChangeError >& error) = 0;

    virtual void onSupervisionStateChangeStatus(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< SupervisionStateChangeStatus >& status) = 0;
};

class TriggerGetUnitListCallbackIF {
public:
    virtual ~TriggerGetUnitListCallbackIF() {}

    virtual void onTriggerGetUnitListError(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< TriggerGetUnitListError >& error) = 0;

    virtual void onTriggerGetUnitListResult(const ::boost::shared_ptr< Lcm_dbusctrl_fiProxy >& proxy, const ::boost::shared_ptr< TriggerGetUnitListResult >& result) = 0;
};

class Lcm_dbusctrl_fiProxyCallback;

/**
 * Lcm_dbusctrl_fiProxy is the client side representation of the CCA
 * Functional Interface 'lcm_dbusctrl_fi' (specified in file
 * lcm_dbusctrl_fi.xml).
 *
 * CCA Functional Interface 'lcm_dbusctrl_fi'
 *
 * Fullname: LCM Late CCA Service, Application Functional Interface
 *
 * Version: $Revision:   1.1.0  $
 *
 * Author: Klaus-Peter Kollai (kol2hi) CM-AI/PJ-EPB2
 *
 * Date: $Date:  04.03.2015  $
 *
 * Department:
 *
 * Title: dbusctrl_fi
 *
 * <b>Description of 'lcm_dbusctrl_fi':</b>
 *
 * LCM service for ...
 */
class Lcm_dbusctrl_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Lcm_dbusctrl_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Lcm_dbusctrl_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Lcm_dbusctrl_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Lcm_dbusctrl_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Lcm_dbusctrl_fiProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Lcm_dbusctrl_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Lcm_dbusctrl_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Lcm_dbusctrl_fiProxy();

    // Method 'StartProcess'

    /**
     * Call the method 'StartProcess'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'StartProcess'</b>:
     *
     * Trigger to start a process.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param strLocation If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param u32Prio If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @param u32Affinity If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @param u32AffinityEnd If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevel If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevelEnd If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @param u32Type If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @param u32Info If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartProcessStart(StartProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32Prio, uint32 u32Affinity, uint32 u32AffinityEnd, uint32 u32NiceLevel, uint32 u32NiceLevelEnd, ::lcm_dbusctrl_fi_types::T_e32_LCM_START_PROC_TYPE u32Type, uint32 u32Info);

    // Method 'StopProcess'

    /**
     * Call the method 'StopProcess'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'StopProcess'</b>:
     *
     * Trigger to stop a process.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param strLocation If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param u32ProcId If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStopProcessStart(StopProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32ProcId);

    // Method 'StartupFinished'

    /**
     * Call the method 'StartupFinished'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'StartupFinished'</b>:
     *
     * Set Startup State.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param eStartUpParam If the meaning of "eStartUpParam" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFinishedStart(StartupFinishedCallbackIF& cb, ::lcm_dbusctrl_fi_types::T_e32_LCM_STARTUP_TYPE eStartUpParam);

    // Method 'GetProcessId'

    /**
     * Call the method 'GetProcessId'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'GetProcessId'</b>:
     *
     * Get the process ID of the main thread started by given service file. The response is only an acknowledge that the request was received.
     * The actual ProcessID is set via property NewProcessId, to have the same handling for spontanously registered services
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param strServiceName If the meaning of "strServiceName" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetProcessIdStart(GetProcessIdCallbackIF& cb, const ::std::string& strServiceName);

    // Method 'TriggerGetUnitList'

    /**
     * Call the method 'TriggerGetUnitList'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'TriggerGetUnitList'</b>:
     *
     * Get list of units available in the system.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTriggerGetUnitListStart(TriggerGetUnitListCallbackIF& cb);

    // Method 'RestartProcess'

    /**
     * Call the method 'RestartProcess'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'RestartProcess'</b>:
     *
     * Trigger to restart a process.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param strLocation If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param u32ProcId If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRestartProcessStart(RestartProcessCallbackIF& cb, const ::std::string& strLocation, uint32 u32ProcId);

    // Property 'AppStartRequest'

    /**
     * Notify on the property 'AppStartRequest'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AppStartRequest'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppStartRequestUpReg(AppStartRequestCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AppStartRequest'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AppStartRequest'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendAppStartRequestUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAppStartRequestRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AppStartRequest'.
     */
    void sendAppStartRequestRelUpRegAll ();

    /**
     * Returns the current value of the property 'AppStartRequest' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAppStartRequest() returns true.
     *
     * @return the previously received value of the property 'AppStartRequest'.
     */
    const AppStartRequestStatus& getAppStartRequest() const;

    /**
     * Determines whether a status message for the property 'AppStartRequest' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAppStartRequest() const;

    /**
     * Request the value of the property 'AppStartRequest' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AppStartRequest'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppStartRequestGet(AppStartRequestCallbackIF& cb);

    // Property 'AppInitialized'

    /**
     * Notify on the property 'AppInitialized'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AppInitialized'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppInitializedUpReg(AppInitializedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AppInitialized'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AppInitialized'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendAppInitializedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAppInitializedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AppInitialized'.
     */
    void sendAppInitializedRelUpRegAll ();

    /**
     * Returns the current value of the property 'AppInitialized' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAppInitialized() returns true.
     *
     * @return the previously received value of the property 'AppInitialized'.
     */
    const AppInitializedStatus& getAppInitialized() const;

    /**
     * Determines whether a status message for the property 'AppInitialized' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAppInitialized() const;

    /**
     * Request the value of the property 'AppInitialized' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AppInitialized'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppInitializedGet(AppInitializedCallbackIF& cb);

    // Property 'AppStateChange'

    /**
     * Notify on the property 'AppStateChange'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'AppStateChange'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppStateChangeUpReg(AppStateChangeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AppStateChange'. This method sends
     * a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AppStateChange'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendAppStateChangeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAppStateChangeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AppStateChange'.
     */
    void sendAppStateChangeRelUpRegAll ();

    /**
     * Returns the current value of the property 'AppStateChange' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAppStateChange() returns true.
     *
     * @return the previously received value of the property 'AppStateChange'.
     */
    const AppStateChangeStatus& getAppStateChange() const;

    /**
     * Determines whether a status message for the property 'AppStateChange' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAppStateChange() const;

    /**
     * Request the value of the property 'AppStateChange' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AppStateChange'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppStateChangeGet(AppStateChangeCallbackIF& cb);

    /**
     * Set the value of the property 'AppStateChange'. This method sends a Set
     * message to the CCA server.
     *
     * <b>Documentation of 'AppStateChange'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param u32AppId If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @param u32State If the meaning of "u32State" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppStateChangeSet(AppStateChangeCallbackIF& cb, uint32 u32AppId, uint32 u32State);

    // Property 'AppEnd'

    /**
     * Notify on the property 'AppEnd'. This method sends a UpReg message to
     * the CCA server.
     *
     * <b>Documentation of 'AppEnd'</b>:
     *
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppEndUpReg(AppEndCallbackIF& cb);

    /**
     * Remove the notifcation on property 'AppEnd'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'AppEnd'</b>:
     *
     *
     * @param act The act which was previously returned by the
     * sendAppEndUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendAppEndRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'AppEnd'.
     */
    void sendAppEndRelUpRegAll ();

    /**
     * Returns the current value of the property 'AppEnd' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAppEnd()
     * returns true.
     *
     * @return the previously received value of the property 'AppEnd'.
     */
    const AppEndStatus& getAppEnd() const;

    /**
     * Determines whether a status message for the property 'AppEnd' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAppEnd() const;

    /**
     * Request the value of the property 'AppEnd' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'AppEnd'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppEndGet(AppEndCallbackIF& cb);

    /**
     * Set the value of the property 'AppEnd'. This method sends a Set message
     * to the CCA server.
     *
     * <b>Documentation of 'AppEnd'</b>:
     *
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param u32AppId If the meaning of "u32AppId" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAppEndSet(AppEndCallbackIF& cb, uint32 u32AppId);

    // Property 'NewServiceLoaded'

    /**
     * Notify on the property 'NewServiceLoaded'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'NewServiceLoaded'</b>:
     *
     * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewServiceLoadedUpReg(NewServiceLoadedCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NewServiceLoaded'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NewServiceLoaded'</b>:
     *
     * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
     *
     * @param act The act which was previously returned by the
     * sendNewServiceLoadedUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNewServiceLoadedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NewServiceLoaded'.
     */
    void sendNewServiceLoadedRelUpRegAll ();

    /**
     * Returns the current value of the property 'NewServiceLoaded' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNewServiceLoaded() returns true.
     *
     * @return the previously received value of the property 'NewServiceLoaded'.
     */
    const NewServiceLoadedStatus& getNewServiceLoaded() const;

    /**
     * Determines whether a status message for the property 'NewServiceLoaded' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNewServiceLoaded() const;

    /**
     * Request the value of the property 'NewServiceLoaded' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NewServiceLoaded'</b>:
     *
     * Indicates that the state of a Service is "loaded" - systemd has called ExecStart of this service
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewServiceLoadedGet(NewServiceLoadedCallbackIF& cb);

    // Property 'FailedServicesList'

    /**
     * Notify on the property 'FailedServicesList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'FailedServicesList'</b>:
     *
     * Contains a list of all services that are in "failed" state
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServicesListUpReg(FailedServicesListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'FailedServicesList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'FailedServicesList'</b>:
     *
     * Contains a list of all services that are in "failed" state
     *
     * @param act The act which was previously returned by the
     * sendFailedServicesListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendFailedServicesListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'FailedServicesList'.
     */
    void sendFailedServicesListRelUpRegAll ();

    /**
     * Returns the current value of the property 'FailedServicesList' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasFailedServicesList() returns true.
     *
     * @return the previously received value of the property 'FailedServicesList'.
     */
    const FailedServicesListStatus& getFailedServicesList() const;

    /**
     * Determines whether a status message for the property 'FailedServicesList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasFailedServicesList() const;

    /**
     * Request the value of the property 'FailedServicesList' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'FailedServicesList'</b>:
     *
     * Contains a list of all services that are in "failed" state
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendFailedServicesListGet(FailedServicesListCallbackIF& cb);

    // Property 'NewProcessId'

    /**
     * Notify on the property 'NewProcessId'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'NewProcessId'</b>:
     *
     * sets a processID for a new systemd service that is registered
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewProcessIdUpReg(NewProcessIdCallbackIF& cb);

    /**
     * Remove the notifcation on property 'NewProcessId'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'NewProcessId'</b>:
     *
     * sets a processID for a new systemd service that is registered
     *
     * @param act The act which was previously returned by the
     * sendNewProcessIdUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendNewProcessIdRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'NewProcessId'.
     */
    void sendNewProcessIdRelUpRegAll ();

    /**
     * Returns the current value of the property 'NewProcessId' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNewProcessId() returns true.
     *
     * @return the previously received value of the property 'NewProcessId'.
     */
    const NewProcessIdStatus& getNewProcessId() const;

    /**
     * Determines whether a status message for the property 'NewProcessId' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNewProcessId() const;

    /**
     * Request the value of the property 'NewProcessId' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'NewProcessId'</b>:
     *
     * sets a processID for a new systemd service that is registered
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewProcessIdGet(NewProcessIdCallbackIF& cb);

    // Property 'StartupFailureIndication'

    /**
     * Notify on the property 'StartupFailureIndication'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * The information indicates why the StartupController failed
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFailureIndicationUpReg(StartupFailureIndicationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'StartupFailureIndication'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * The information indicates why the StartupController failed
     *
     * @param act The act which was previously returned by the
     * sendStartupFailureIndicationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendStartupFailureIndicationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'StartupFailureIndication'.
     */
    void sendStartupFailureIndicationRelUpRegAll ();

    /**
     * Returns the current value of the property 'StartupFailureIndication'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasStartupFailureIndication() returns true.
     *
     * @return the previously received value of the property 'StartupFailureIndication'.
     */
    const StartupFailureIndicationStatus& getStartupFailureIndication() const;

    /**
     * Determines whether a status message for the property 'StartupFailureIndication' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasStartupFailureIndication() const;

    /**
     * Request the value of the property 'StartupFailureIndication' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'StartupFailureIndication'</b>:
     *
     * The information indicates why the StartupController failed
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStartupFailureIndicationGet(StartupFailureIndicationCallbackIF& cb);

    // Property 'SupervisionStateChange'

    /**
     * Notify on the property 'SupervisionStateChange'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'SupervisionStateChange'</b>:
     *
     * The status of Supervision from lcmEarly to lcmLate
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSupervisionStateChangeUpReg(SupervisionStateChangeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SupervisionStateChange'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SupervisionStateChange'</b>:
     *
     * The status of Supervision from lcmEarly to lcmLate
     *
     * @param act The act which was previously returned by the
     * sendSupervisionStateChangeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSupervisionStateChangeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SupervisionStateChange'.
     */
    void sendSupervisionStateChangeRelUpRegAll ();

    /**
     * Returns the current value of the property 'SupervisionStateChange' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSupervisionStateChange() returns true.
     *
     * @return the previously received value of the property 'SupervisionStateChange'.
     */
    const SupervisionStateChangeStatus& getSupervisionStateChange() const;

    /**
     * Determines whether a status message for the property 'SupervisionStateChange' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSupervisionStateChange() const;

    /**
     * Set the value of the property 'SupervisionStateChange'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'SupervisionStateChange'</b>:
     *
     * The status of Supervision from lcmEarly to lcmLate
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     * @param bSupervisionActive If the meaning of "bSupervisionActive" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSupervisionStateChangeSet(SupervisionStateChangeCallbackIF& cb, bool bSupervisionActive);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Lcm_dbusctrl_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'AppStartRequest'

    ::asf::core::nullable< AppStartRequestStatus > _appStartRequest;

    // Property 'AppInitialized'

    ::asf::core::nullable< AppInitializedStatus > _appInitialized;

    // Property 'AppStateChange'

    ::asf::core::nullable< AppStateChangeStatus > _appStateChange;

    // Property 'AppEnd'

    ::asf::core::nullable< AppEndStatus > _appEnd;

    // Property 'NewServiceLoaded'

    ::asf::core::nullable< NewServiceLoadedStatus > _newServiceLoaded;

    // Property 'FailedServicesList'

    ::asf::core::nullable< FailedServicesListStatus > _failedServicesList;

    // Property 'NewProcessId'

    ::asf::core::nullable< NewProcessIdStatus > _newProcessId;

    // Property 'StartupFailureIndication'

    ::asf::core::nullable< StartupFailureIndicationStatus > _startupFailureIndication;

    // Property 'SupervisionStateChange'

    ::asf::core::nullable< SupervisionStateChangeStatus > _supervisionStateChange;

    DECLARE_CLASS_LOGGER();

    friend class Lcm_dbusctrl_fiProxyCallback;
};

} // namespace lcm_dbusctrl_fi

#endif // LCM_DBUSCTRL_FIPROXY_H
