/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_service.h"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceConst.h"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceDBus.h"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceJson.h"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm_dbus_fi {
namespace lcm_dbus_fi_service {

DEFINE_CLASS_LOGGER("/org/bosch/cm/lcm_dbus_fi/org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_service", Lcm_dbus_fi_serviceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "ClearVIN", 18 },
    { 9, "ClearList", 8 },
    { 10, "SystemMode", 0 },
    { 10, "UpdateLock", 2 },
    { 11, "EndDownload", 20 },
    { 11, "StopProcess", 5 },
    { 12, "OnOffTrigger", 3 },
    { 12, "StartProcess", 4 },
    { 13, "RestartSystem", 9 },
    { 14, "ChangeSpiState", 13 },
    { 14, "RestartProcess", 6 },
    { 15, "ChangeWifiState", 15 },
    { 15, "EntertainDeMute", 23 },
    { 15, "PrepareDownload", 19 },
    { 16, "ChangeAudioState", 12 },
    { 16, "ChangeTunerState", 14 },
    { 17, "AudioSourceChange", 10 },
    { 17, "DownloadLockState", 1 },
    { 18, "SetOnConfiguration", 21 },
    { 20, "ChangeBluetoothState", 11 },
    { 20, "EntertainMuteRequest", 24 },
    { 21, "SetFactorySettingsNew", 17 },
    { 22, "WelcomeAudioActivation", 25 },
    { 23, "SetProcessConfiguration", 22 },
    { 23, "StartUpSyncPointReached", 7 },
    { 27, "ShutdownAndTerminateCcaApps", 16 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 3, "VIN", 81 },
    { 7, "Restart", 51 },
    { 8, "CvmEvent", 26 },
    { 8, "DimState", 55 },
    { 8, "HmiState", 53 },
    { 8, "Lifesign", 52 },
    { 8, "RVCState", 68 },
    { 8, "SpiState", 59 },
    { 8, "SysState", 65 },
    { 9, "Alphacode", 72 },
    { 9, "MostState", 66 },
    { 9, "ResetList", 32 },
    { 9, "SubStates", 4 },
    { 9, "UBatSense", 27 },
    { 9, "VehicleID", 83 },
    { 9, "WifiState", 61 },
    { 10, "Alphacodes", 73 },
    { 10, "AudioState", 58 },
    { 10, "CoproState", 28 },
    { 10, "Partnumber", 70 },
    { 10, "SysPwrMode", 11 },
    { 10, "TunerState", 60 },
    { 10, "WakeupList", 63 },
    { 11, "InsertState", 6 },
    { 11, "MostVersion", 67 },
    { 11, "OnOffReason", 62 },
    { 11, "Partnumbers", 71 },
    { 11, "ProcessList", 20 },
    { 11, "StandbyTime", 14 },
    { 11, "SystemState", 0 },
    { 12, "DegradedTime", 93 },
    { 12, "DimmingState", 56 },
    { 12, "DoorOpenTime", 17 },
    { 12, "ResetCounter", 33 },
    { 12, "ResetHistory", 35 },
    { 12, "StartupState", 86 },
    { 12, "StateHistory", 37 },
    { 12, "WakeupReason", 21 },
    { 13, "DegradedCount", 92 },
    { 13, "EntertainMute", 87 },
    { 13, "OnTipperState", 9 },
    { 13, "RunlevelState", 50 },
    { 13, "SecurityState", 82 },
    { 13, "StartupReason", 22 },
    { 13, "WakeupHistory", 36 },
    { 14, "BluetoothState", 57 },
    { 14, "DisplayVariant", 84 },
    { 14, "HistoryTrigger", 5 },
    { 14, "IgnitionCycles", 10 },
    { 14, "PhoneMuteState", 8 },
    { 14, "ReductionLevel", 85 },
    { 14, "SysPwrSaveMode", 12 },
    { 15, "DeviceOnCounter", 44 },
    { 15, "IgnitionOffTime", 16 },
    { 15, "MediaEjectState", 7 },
    { 15, "StartupFinished", 64 },
    { 15, "SwitchOnHistory", 43 },
    { 15, "SystemStateTime", 19 },
    { 16, "ClockDisplayTime", 18 },
    { 16, "CodeRequestState", 24 },
    { 16, "ConnectToBattery", 23 },
    { 16, "UpdateLockStates", 2 },
    { 17, "CpuUsageStatistic", 47 },
    { 17, "DevicePowerOnTime", 29 },
    { 17, "ErrStateHistory01", 38 },
    { 17, "ErrStateHistory02", 39 },
    { 17, "ErrStateHistory03", 40 },
    { 17, "ErrStateHistory04", 41 },
    { 17, "ErrStateHistory05", 42 },
    { 17, "LastSystemRuntime", 30 },
    { 17, "RamUsageStatistic", 48 },
    { 17, "SecurityCommError", 76 },
    { 17, "TransportModeList", 34 },
    { 17, "WelcomeAudioState", 88 },
    { 18, "ActiveOnOffTrigger", 3 },
    { 18, "DownloadLockStates", 1 },
    { 18, "NoCalibrationState", 75 },
    { 18, "SecurityCurrentVin", 79 },
    { 18, "SecurityInvalidVin", 78 },
    { 18, "SecurityVinHistory", 80 },
    { 19, "VoltageEventCounter", 45 },
    { 20, "CurrentSystemRuntime", 31 },
    { 20, "MapDownloadLockState", 13 },
    { 20, "PersitentStandbyTime", 15 },
    { 20, "StartupTimeStatistic", 49 },
    { 20, "SystemPowerBehaviour", 54 },
    { 20, "UnballastWarningTime", 91 },
    { 21, "PhoneHandoverWarnTime", 94 },
    { 21, "SecurityMoreThan10Vin", 77 },
    { 21, "VoltageRangeHistogram", 46 },
    { 22, "TriggerMostRemoteReset", 69 },
    { 23, "ActiveStartUpSyncPoints", 25 },
    { 26, "ManufacturersEnableCounter", 74 },
    { 28, "UnballastTimeBeforeUnballast", 90 },
    { 30, "UnballastTimeFromEngineStopped", 89 },
};

class Lcm_dbus_fi_serviceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Lcm_dbus_fi_serviceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Lcm_dbus_fi_serviceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Lcm_dbus_fi_serviceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service"),
          _logger(logger) {}

    virtual ~Lcm_dbus_fi_serviceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Lcm_dbus_fi_serviceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 26, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SystemMode'

            LOG_DEBUG_STUB("process method '%s'", "SystemMode");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SystemModeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SystemMode", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SystemModeRequest > payload = ::boost::static_pointer_cast<SystemModeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSystemModeRequest(payload);
            return;
        }
        case 1: {

            // method 'DownloadLockState'

            LOG_DEBUG_STUB("process method '%s'", "DownloadLockState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DownloadLockStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DownloadLockState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DownloadLockStateRequest > payload = ::boost::static_pointer_cast<DownloadLockStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDownloadLockStateRequest(payload);
            return;
        }
        case 2: {

            // method 'UpdateLock'

            LOG_DEBUG_STUB("process method '%s'", "UpdateLock");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateLockRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateLock", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateLockRequest > payload = ::boost::static_pointer_cast<UpdateLockRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onUpdateLockRequest(payload);
            return;
        }
        case 3: {

            // method 'OnOffTrigger'

            LOG_DEBUG_STUB("process method '%s'", "OnOffTrigger");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), OnOffTriggerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "OnOffTrigger", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< OnOffTriggerRequest > payload = ::boost::static_pointer_cast<OnOffTriggerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onOnOffTriggerRequest(payload);
            return;
        }
        case 4: {

            // method 'StartProcess'

            LOG_DEBUG_STUB("process method '%s'", "StartProcess");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartProcessRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartProcess", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartProcessRequest > payload = ::boost::static_pointer_cast<StartProcessRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStartProcessRequest(payload);
            return;
        }
        case 5: {

            // method 'StopProcess'

            LOG_DEBUG_STUB("process method '%s'", "StopProcess");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopProcessRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StopProcess", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StopProcessRequest > payload = ::boost::static_pointer_cast<StopProcessRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStopProcessRequest(payload);
            return;
        }
        case 6: {

            // method 'RestartProcess'

            LOG_DEBUG_STUB("process method '%s'", "RestartProcess");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartProcessRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RestartProcess", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestartProcessRequest > payload = ::boost::static_pointer_cast<RestartProcessRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onRestartProcessRequest(payload);
            return;
        }
        case 7: {

            // method 'StartUpSyncPointReached'

            LOG_DEBUG_STUB("process method '%s'", "StartUpSyncPointReached");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartUpSyncPointReachedRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "StartUpSyncPointReached", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< StartUpSyncPointReachedRequest > payload = ::boost::static_pointer_cast<StartUpSyncPointReachedRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStartUpSyncPointReachedRequest(payload);
            return;
        }
        case 8: {

            // method 'ClearList'

            LOG_DEBUG_STUB("process method '%s'", "ClearList");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClearList", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClearListRequest > payload = ::boost::static_pointer_cast<ClearListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onClearListRequest(payload);
            return;
        }
        case 9: {

            // method 'RestartSystem'

            LOG_DEBUG_STUB("process method '%s'", "RestartSystem");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RestartSystemRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RestartSystem", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RestartSystemRequest > payload = ::boost::static_pointer_cast<RestartSystemRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onRestartSystemRequest(payload);
            return;
        }
        case 10: {

            // method 'AudioSourceChange'

            LOG_DEBUG_STUB("process method '%s'", "AudioSourceChange");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AudioSourceChangeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "AudioSourceChange", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AudioSourceChangeRequest > payload = ::boost::static_pointer_cast<AudioSourceChangeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onAudioSourceChangeRequest(payload);
            return;
        }
        case 11: {

            // method 'ChangeBluetoothState'

            LOG_DEBUG_STUB("process method '%s'", "ChangeBluetoothState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeBluetoothStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ChangeBluetoothState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChangeBluetoothStateRequest > payload = ::boost::static_pointer_cast<ChangeBluetoothStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onChangeBluetoothStateRequest(payload);
            return;
        }
        case 12: {

            // method 'ChangeAudioState'

            LOG_DEBUG_STUB("process method '%s'", "ChangeAudioState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeAudioStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ChangeAudioState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChangeAudioStateRequest > payload = ::boost::static_pointer_cast<ChangeAudioStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onChangeAudioStateRequest(payload);
            return;
        }
        case 13: {

            // method 'ChangeSpiState'

            LOG_DEBUG_STUB("process method '%s'", "ChangeSpiState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeSpiStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ChangeSpiState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChangeSpiStateRequest > payload = ::boost::static_pointer_cast<ChangeSpiStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onChangeSpiStateRequest(payload);
            return;
        }
        case 14: {

            // method 'ChangeTunerState'

            LOG_DEBUG_STUB("process method '%s'", "ChangeTunerState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeTunerStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ChangeTunerState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChangeTunerStateRequest > payload = ::boost::static_pointer_cast<ChangeTunerStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onChangeTunerStateRequest(payload);
            return;
        }
        case 15: {

            // method 'ChangeWifiState'

            LOG_DEBUG_STUB("process method '%s'", "ChangeWifiState");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeWifiStateRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ChangeWifiState", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChangeWifiStateRequest > payload = ::boost::static_pointer_cast<ChangeWifiStateRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onChangeWifiStateRequest(payload);
            return;
        }
        case 16: {

            // method 'ShutdownAndTerminateCcaApps'

            LOG_DEBUG_STUB("process method '%s'", "ShutdownAndTerminateCcaApps");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ShutdownAndTerminateCcaAppsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ShutdownAndTerminateCcaApps", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ShutdownAndTerminateCcaAppsRequest > payload = ::boost::static_pointer_cast<ShutdownAndTerminateCcaAppsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onShutdownAndTerminateCcaAppsRequest(payload);
            return;
        }
        case 17: {

            // method 'SetFactorySettingsNew'

            LOG_DEBUG_STUB("process method '%s'", "SetFactorySettingsNew");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFactorySettingsNewRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetFactorySettingsNew", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetFactorySettingsNewRequest > payload = ::boost::static_pointer_cast<SetFactorySettingsNewRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSetFactorySettingsNewRequest(payload);
            return;
        }
        case 18: {

            // method 'ClearVIN'

            LOG_DEBUG_STUB("process method '%s'", "ClearVIN");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClearVINRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ClearVIN", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ClearVINRequest > payload = ::boost::static_pointer_cast<ClearVINRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onClearVINRequest(payload);
            return;
        }
        case 19: {

            // method 'PrepareDownload'

            LOG_DEBUG_STUB("process method '%s'", "PrepareDownload");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrepareDownloadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PrepareDownload", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PrepareDownloadRequest > payload = ::boost::static_pointer_cast<PrepareDownloadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onPrepareDownloadRequest(payload);
            return;
        }
        case 20: {

            // method 'EndDownload'

            LOG_DEBUG_STUB("process method '%s'", "EndDownload");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EndDownloadRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EndDownload", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EndDownloadRequest > payload = ::boost::static_pointer_cast<EndDownloadRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onEndDownloadRequest(payload);
            return;
        }
        case 21: {

            // method 'SetOnConfiguration'

            LOG_DEBUG_STUB("process method '%s'", "SetOnConfiguration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetOnConfigurationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetOnConfiguration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetOnConfigurationRequest > payload = ::boost::static_pointer_cast<SetOnConfigurationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSetOnConfigurationRequest(payload);
            return;
        }
        case 22: {

            // method 'SetProcessConfiguration'

            LOG_DEBUG_STUB("process method '%s'", "SetProcessConfiguration");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetProcessConfigurationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProcessConfiguration", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetProcessConfigurationRequest > payload = ::boost::static_pointer_cast<SetProcessConfigurationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSetProcessConfigurationRequest(payload);
            return;
        }
        case 23: {

            // method 'EntertainDeMute'

            LOG_DEBUG_STUB("process method '%s'", "EntertainDeMute");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EntertainDeMuteRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EntertainDeMute", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EntertainDeMuteRequest > payload = ::boost::static_pointer_cast<EntertainDeMuteRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onEntertainDeMuteRequest(payload);
            return;
        }
        case 24: {

            // method 'EntertainMuteRequest'

            LOG_DEBUG_STUB("process method '%s'", "EntertainMuteRequest");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EntertainMuteRequestRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "EntertainMuteRequest", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< EntertainMuteRequestRequest > payload = ::boost::static_pointer_cast<EntertainMuteRequestRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onEntertainMuteRequestRequest(payload);
            return;
        }
        case 25: {

            // method 'WelcomeAudioActivation'

            LOG_DEBUG_STUB("process method '%s'", "WelcomeAudioActivation");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WelcomeAudioActivationRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "WelcomeAudioActivation", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< WelcomeAudioActivationRequest > payload = ::boost::static_pointer_cast<WelcomeAudioActivationRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onWelcomeAudioActivationRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Lcm_dbus_fi_serviceStubDelegate::introspect() const {
    return     "<interface name=\"org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service\">\n"
            "    <property access=\"read\" name=\"SystemState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DownloadLockStates\" type=\"a(sqq)\"/>\n"
            "    <property access=\"read\" name=\"UpdateLockStates\" type=\"a(suqaq)\"/>\n"
            "    <property access=\"read\" name=\"ActiveOnOffTrigger\" type=\"au\"/>\n"
            "    <property access=\"read\" name=\"SubStates\" type=\"(uuu)\"/>\n"
            "    <property access=\"read\" name=\"HistoryTrigger\" type=\"a(uu)\"/>\n"
            "    <property access=\"read\" name=\"InsertState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"MediaEjectState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"PhoneMuteState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"OnTipperState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"IgnitionCycles\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"SysPwrMode\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"SysPwrSaveMode\" type=\"(u)\"/>\n"
            "    <property access=\"read\" name=\"MapDownloadLockState\" type=\"q\"/>\n"
            "    <property access=\"read\" name=\"StandbyTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"PersitentStandbyTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"IgnitionOffTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DoorOpenTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ClockDisplayTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"SystemStateTime\" type=\"(uu)\"/>\n"
            "    <property access=\"read\" name=\"ProcessList\" type=\"(a(ssuu(nyyyyy)))\"/>\n"
            "    <property access=\"read\" name=\"WakeupReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"StartupReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ConnectToBattery\" type=\"(bq)\"/>\n"
            "    <property access=\"read\" name=\"CodeRequestState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ActiveStartUpSyncPoints\" type=\"as\"/>\n"
            "    <property access=\"read\" name=\"CvmEvent\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"UBatSense\" type=\"q\"/>\n"
            "    <property access=\"read\" name=\"CoproState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DevicePowerOnTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"LastSystemRuntime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"CurrentSystemRuntime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ResetList\" type=\"(uyyyyqyyyyyyyyyyyy)\"/>\n"
            "    <property access=\"read\" name=\"ResetCounter\" type=\"((nyyyyy)uuuuuuuuuuuuuuuuuuuuuuu)\"/>\n"
            "    <property access=\"read\" name=\"TransportModeList\" type=\"(a(uuuuu))\"/>\n"
            "    <property access=\"read\" name=\"ResetHistory\" type=\"a((nyyyyy)(ss)u)\"/>\n"
            "    <property access=\"read\" name=\"WakeupHistory\" type=\"a((nyyyyy)u)\"/>\n"
            "    <property access=\"read\" name=\"StateHistory\" type=\"a((nyyyyy)uuuu((u)(u)(u)(u)(u)(u)(u)(u)))\"/>\n"
            "    <property access=\"read\" name=\"ErrStateHistory01\" type=\"a((nyyyyy)uuuu((u)(u)(u)(u)(u)(u)(u)(u)))\"/>\n"
            "    <property access=\"read\" name=\"ErrStateHistory02\" type=\"a((nyyyyy)uuuu((u)(u)(u)(u)(u)(u)(u)(u)))\"/>\n"
            "    <property access=\"read\" name=\"ErrStateHistory03\" type=\"a((nyyyyy)uuuu((u)(u)(u)(u)(u)(u)(u)(u)))\"/>\n"
            "    <property access=\"read\" name=\"ErrStateHistory04\" type=\"a((nyyyyy)uuuu((u)(u)(u)(u)(u)(u)(u)(u)))\"/>\n"
            "    <property access=\"read\" name=\"ErrStateHistory05\" type=\"a((nyyyyy)uuuu((u)(u)(u)(u)(u)(u)(u)(u)))\"/>\n"
            "    <property access=\"read\" name=\"SwitchOnHistory\" type=\"a((nyyyyy)u)\"/>\n"
            "    <property access=\"read\" name=\"DeviceOnCounter\" type=\"(uu)\"/>\n"
            "    <property access=\"read\" name=\"VoltageEventCounter\" type=\"(uuuu)\"/>\n"
            "    <property access=\"read\" name=\"VoltageRangeHistogram\" type=\"a(qu)\"/>\n"
            "    <property access=\"read\" name=\"CpuUsageStatistic\" type=\"(uuub)\"/>\n"
            "    <property access=\"read\" name=\"RamUsageStatistic\" type=\"(uuub)\"/>\n"
            "    <property access=\"read\" name=\"StartupTimeStatistic\" type=\"(uuub)\"/>\n"
            "    <property access=\"read\" name=\"RunlevelState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"Restart\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"Lifesign\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"HmiState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"SystemPowerBehaviour\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DimState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DimmingState\" type=\"(u)\"/>\n"
            "    <property access=\"read\" name=\"BluetoothState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"AudioState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"SpiState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"TunerState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"WifiState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"OnOffReason\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"WakeupList\" type=\"(uuuuuuuuuu)\"/>\n"
            "    <property access=\"read\" name=\"StartupFinished\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"SysState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"MostState\" type=\"(uuuub)\"/>\n"
            "    <property access=\"read\" name=\"MostVersion\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"RVCState\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"TriggerMostRemoteReset\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"Partnumber\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"Partnumbers\" type=\"(a(su))\"/>\n"
            "    <property access=\"read\" name=\"Alphacode\" type=\"(yy)\"/>\n"
            "    <property access=\"read\" name=\"Alphacodes\" type=\"(a(syy))\"/>\n"
            "    <property access=\"read\" name=\"ManufacturersEnableCounter\" type=\"y\"/>\n"
            "    <property access=\"read\" name=\"NoCalibrationState\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"SecurityCommError\" type=\"q\"/>\n"
            "    <property access=\"read\" name=\"SecurityMoreThan10Vin\" type=\"q\"/>\n"
            "    <property access=\"read\" name=\"SecurityInvalidVin\" type=\"q\"/>\n"
            "    <property access=\"read\" name=\"SecurityCurrentVin\" type=\"(ay)\"/>\n"
            "    <property access=\"read\" name=\"SecurityVinHistory\" type=\"(a(ay))\"/>\n"
            "    <property access=\"read\" name=\"VIN\" type=\"s\"/>\n"
            "    <property access=\"read\" name=\"SecurityState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"VehicleID\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DisplayVariant\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"ReductionLevel\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"StartupState\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"EntertainMute\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"WelcomeAudioState\" type=\"b\"/>\n"
            "    <property access=\"read\" name=\"UnballastTimeFromEngineStopped\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"UnballastTimeBeforeUnballast\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"UnballastWarningTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DegradedCount\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"DegradedTime\" type=\"u\"/>\n"
            "    <property access=\"read\" name=\"PhoneHandoverWarnTime\" type=\"u\"/>\n"
            "    <method name=\"SystemMode\">\n"
            "      <doc>\n"
            "        <line>SystemMode = Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.  (CCA FID: 0x1000)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"eSystemMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eSystemMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"DownloadLockState\">\n"
            "      <doc>\n"
            "        <line>DownloadLockState = !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLock !!! Method to lock specific resources for restricted downloads.  (CCA FID: 0x1001)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"strRestrictedDlState\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strRestrictedDlState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"eRestrictedDlMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eRestrictedDlMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"UpdateLock\">\n"
            "      <doc>\n"
            "        <line>UpdateLock = Method to modify a lock. Not existing locks will be created. Locks that are no longer owned nor used will be deleted. Owner and state of a lock will be stored persistently  (CCA FID: 0x1003)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"strLockName\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strLockName = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"eLockRequest\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eLockRequest = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"OnOffTrigger\">\n"
            "      <doc>\n"
            "        <line>OnOffTrigger = Set a new OnOff reason. A new system state will be calculated. (CCA FID: 0x100f)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"eSwitchOnTrigger\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eSwitchOnTrigger = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"bState\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartProcess\">\n"
            "      <doc>\n"
            "        <line>StartProcess = Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes. (CCA FID: 0x01fe)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"strLocation\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strLocation = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32Prio\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32Prio = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32Affinity\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32Affinity = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32AffinityEnd\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32AffinityEnd = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32NiceLevel\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32NiceLevel = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32NiceLevelEnd\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32NiceLevelEnd = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32Type\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32Type = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32Info\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32Info = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"strLocationOut\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strLocationOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"u32ProcIdOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32ProcIdOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"u32SpawnDurationOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32SpawnDurationOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StopProcess\">\n"
            "      <doc>\n"
            "        <line>StopProcess = Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes. (CCA FID: 0x01fd)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"strLocation\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strLocation = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32ProcId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32ProcId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RestartProcess\">\n"
            "      <doc>\n"
            "        <line>RestartProcess = Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes. (CCA FID: 0x01fc)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"strLocation\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strLocation = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"u32ProcId\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>u32ProcId = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"StartUpSyncPointReached\">\n"
            "      <doc>\n"
            "        <line>StartUpSyncPointReached = Inform about a new reached sync point. (CCA FID: 0x160)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"strNewSyncPoint\" type=\"s\">\n"
            "        <doc>\n"
            "          <line>strNewSyncPoint = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ClearList\">\n"
            "      <doc>\n"
            "        <line>ClearList = Method to clear engineering date (All at once or a selected one).  (CCA FID: 0x1040)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"eList2Clear\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eList2Clear = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"RestartSystem\">\n"
            "      <doc>\n"
            "        <line>RestartSystem = Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.  (CCA FID: 0x1042)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"eRestartType\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eRestartType = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"e32ReturnValOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>e32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"AudioSourceChange\">\n"
            "      <doc>\n"
            "        <line>AudioSourceChange = Method to trigger a source change by HMI. Used to change start configuration for next start-up.  (CCA FID: 0x1017)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"eAudioSrc\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>eAudioSrc = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ChangeBluetoothState\">\n"
            "      <doc>\n"
            "        <line>ChangeBluetoothState = Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x413)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"BtState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>BtState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ChangeAudioState\">\n"
            "      <doc>\n"
            "        <line>ChangeAudioState = Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x414)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"AudioState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>AudioState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ChangeSpiState\">\n"
            "      <doc>\n"
            "        <line>ChangeSpiState = Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x415)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"SpiState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>SpiState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ChangeTunerState\">\n"
            "      <doc>\n"
            "        <line>ChangeTunerState = Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x417)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"TunerState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>TunerState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ChangeWifiState\">\n"
            "      <doc>\n"
            "        <line>ChangeWifiState = Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x419)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"WiFiState\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>WiFiState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ShutdownAndTerminateCcaApps\">\n"
            "      <doc>\n"
            "        <line>ShutdownAndTerminateCcaApps = (CCA FID: 0x0004)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"tAppIdList\" type=\"(aq)\">\n"
            "        <doc>\n"
            "          <line>tAppIdList = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ResOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ResOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetFactorySettingsNew\">\n"
            "      <doc>\n"
            "        <line>SetFactorySettingsNew = (CCA FID: 0x89)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"DefSetStateGroup\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DefSetStateGroup = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"DefSetStateMode\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DefSetStateMode = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"DefSetStateGroupOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DefSetStateGroupOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"DefSetStateModeOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>DefSetStateModeOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"DefSetStateSuccessfulOut\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>DefSetStateSuccessfulOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"DefSetStateFirstDifferentParameterIdOut\" type=\"q\">\n"
            "        <doc>\n"
            "          <line>DefSetStateFirstDifferentParameterIdOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"ClearVIN\">\n"
            "      <doc>\n"
            "        <line>ClearVIN = Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.  (CCA FID: 0x0522)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ResultOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ResultOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"PrepareDownload\">\n"
            "      <doc>\n"
            "        <line>PrepareDownload = This function prepares the system for download. All components that are not needed are unloaded.   (CCA FID: 0x0900)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Configuration\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Configuration = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"SuspendBusShutdown\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>SuspendBusShutdown = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"in\" name=\"Timeout\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Timeout = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ResultOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ResultOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EndDownload\">\n"
            "      <doc>\n"
            "        <line>EndDownload = This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.   (CCA FID: 0x0901)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"ResultOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ResultOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetOnConfiguration\">\n"
            "      <doc>\n"
            "        <line>SetOnConfiguration = (CCA FID: 0x0902)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Configuration\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Configuration = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ResultOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ResultOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"SetProcessConfiguration\">\n"
            "      <doc>\n"
            "        <line>SetProcessConfiguration = (CCA FID: 0x0903)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"Configuration\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>Configuration = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"ResultOut\" type=\"u\">\n"
            "        <doc>\n"
            "          <line>ResultOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EntertainDeMute\">\n"
            "      <doc>\n"
            "        <line>EntertainDeMute = Method to trigger a demute by HMI.  (CCA FID: 0x1016)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"EntertainMuteRequest\">\n"
            "      <doc>\n"
            "        <line>EntertainMuteRequest = Method to trigger a mute by HMI.  (CCA FID: 0x1015)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "    <method name=\"WelcomeAudioActivation\">\n"
            "      <doc>\n"
            "        <line>WelcomeAudioActivation = Method to trigger a mute by HMI.  (CCA FID: 0x1025)</line>\n"
            "      </doc>\n"
            "      <arg direction=\"in\" name=\"bActivateState\" type=\"b\">\n"
            "        <doc>\n"
            "          <line>bActivateState = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "      <arg direction=\"out\" name=\"s32ReturnValOut\" type=\"i\">\n"
            "        <doc>\n"
            "          <line>s32ReturnValOut = Description missing</line>\n"
            "        </doc>\n"
            "      </arg>\n"
            "    </method>\n"
            "</interface>\n";
}

void Lcm_dbus_fi_serviceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Lcm_dbus_fi_serviceStub*>(getStub()))->onGetAll (properties);
}

void Lcm_dbus_fi_serviceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 95, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SystemState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DownloadLockStates");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateLockStates");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveOnOffTrigger");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "SubStates");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "HistoryTrigger");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "InsertState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "MediaEjectState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "PhoneMuteState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "OnTipperState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "IgnitionCycles");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "SysPwrMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "SysPwrSaveMode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "MapDownloadLockState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "StandbyTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "PersitentStandbyTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "IgnitionOffTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "DoorOpenTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "ClockDisplayTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "SystemStateTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "ProcessList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "WakeupReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "StartupReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "ConnectToBattery");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "CodeRequestState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveStartUpSyncPoints");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "CvmEvent");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "UBatSense");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "CoproState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "DevicePowerOnTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "LastSystemRuntime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentSystemRuntime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "ResetList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "ResetCounter");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "TransportModeList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "ResetHistory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "WakeupHistory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "StateHistory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory01");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory02");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory03");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory04");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory05");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "SwitchOnHistory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceOnCounter");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "VoltageEventCounter");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "VoltageRangeHistogram");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "CpuUsageStatistic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "RamUsageStatistic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 49: {
            LOG_DEBUG_STUB("process property '%s'", "StartupTimeStatistic");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 50: {
            LOG_DEBUG_STUB("process property '%s'", "RunlevelState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 51: {
            LOG_DEBUG_STUB("process property '%s'", "Restart");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 52: {
            LOG_DEBUG_STUB("process property '%s'", "Lifesign");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 53: {
            LOG_DEBUG_STUB("process property '%s'", "HmiState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 54: {
            LOG_DEBUG_STUB("process property '%s'", "SystemPowerBehaviour");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 55: {
            LOG_DEBUG_STUB("process property '%s'", "DimState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 56: {
            LOG_DEBUG_STUB("process property '%s'", "DimmingState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 57: {
            LOG_DEBUG_STUB("process property '%s'", "BluetoothState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 58: {
            LOG_DEBUG_STUB("process property '%s'", "AudioState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 59: {
            LOG_DEBUG_STUB("process property '%s'", "SpiState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 60: {
            LOG_DEBUG_STUB("process property '%s'", "TunerState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 61: {
            LOG_DEBUG_STUB("process property '%s'", "WifiState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 62: {
            LOG_DEBUG_STUB("process property '%s'", "OnOffReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 63: {
            LOG_DEBUG_STUB("process property '%s'", "WakeupList");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 64: {
            LOG_DEBUG_STUB("process property '%s'", "StartupFinished");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 65: {
            LOG_DEBUG_STUB("process property '%s'", "SysState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 66: {
            LOG_DEBUG_STUB("process property '%s'", "MostState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 67: {
            LOG_DEBUG_STUB("process property '%s'", "MostVersion");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 68: {
            LOG_DEBUG_STUB("process property '%s'", "RVCState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 69: {
            LOG_DEBUG_STUB("process property '%s'", "TriggerMostRemoteReset");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 70: {
            LOG_DEBUG_STUB("process property '%s'", "Partnumber");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 71: {
            LOG_DEBUG_STUB("process property '%s'", "Partnumbers");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 72: {
            LOG_DEBUG_STUB("process property '%s'", "Alphacode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 73: {
            LOG_DEBUG_STUB("process property '%s'", "Alphacodes");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 74: {
            LOG_DEBUG_STUB("process property '%s'", "ManufacturersEnableCounter");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 75: {
            LOG_DEBUG_STUB("process property '%s'", "NoCalibrationState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 76: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityCommError");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 77: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityMoreThan10Vin");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 78: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityInvalidVin");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 79: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityCurrentVin");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 80: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityVinHistory");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 81: {
            LOG_DEBUG_STUB("process property '%s'", "VIN");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 82: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 83: {
            LOG_DEBUG_STUB("process property '%s'", "VehicleID");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 84: {
            LOG_DEBUG_STUB("process property '%s'", "DisplayVariant");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 85: {
            LOG_DEBUG_STUB("process property '%s'", "ReductionLevel");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 86: {
            LOG_DEBUG_STUB("process property '%s'", "StartupState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 87: {
            LOG_DEBUG_STUB("process property '%s'", "EntertainMute");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 88: {
            LOG_DEBUG_STUB("process property '%s'", "WelcomeAudioState");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 89: {
            LOG_DEBUG_STUB("process property '%s'", "UnballastTimeFromEngineStopped");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 90: {
            LOG_DEBUG_STUB("process property '%s'", "UnballastTimeBeforeUnballast");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 91: {
            LOG_DEBUG_STUB("process property '%s'", "UnballastWarningTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 92: {
            LOG_DEBUG_STUB("process property '%s'", "DegradedCount");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 93: {
            LOG_DEBUG_STUB("process property '%s'", "DegradedTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 94: {
            LOG_DEBUG_STUB("process property '%s'", "PhoneHandoverWarnTime");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Lcm_dbus_fi_serviceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 95, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "SystemState");
            ::boost::shared_ptr< SystemStateGet > payload(new SystemStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSystemStateGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DownloadLockStates");
            ::boost::shared_ptr< DownloadLockStatesGet > payload(new DownloadLockStatesGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDownloadLockStatesGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "UpdateLockStates");
            ::boost::shared_ptr< UpdateLockStatesGet > payload(new UpdateLockStatesGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onUpdateLockStatesGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveOnOffTrigger");
            ::boost::shared_ptr< ActiveOnOffTriggerGet > payload(new ActiveOnOffTriggerGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onActiveOnOffTriggerGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "SubStates");
            ::boost::shared_ptr< SubStatesGet > payload(new SubStatesGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSubStatesGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "HistoryTrigger");
            ::boost::shared_ptr< HistoryTriggerGet > payload(new HistoryTriggerGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onHistoryTriggerGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "InsertState");
            ::boost::shared_ptr< InsertStateGet > payload(new InsertStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onInsertStateGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "MediaEjectState");
            ::boost::shared_ptr< MediaEjectStateGet > payload(new MediaEjectStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onMediaEjectStateGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "PhoneMuteState");
            ::boost::shared_ptr< PhoneMuteStateGet > payload(new PhoneMuteStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onPhoneMuteStateGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "OnTipperState");
            ::boost::shared_ptr< OnTipperStateGet > payload(new OnTipperStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onOnTipperStateGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "IgnitionCycles");
            ::boost::shared_ptr< IgnitionCyclesGet > payload(new IgnitionCyclesGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onIgnitionCyclesGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "SysPwrMode");
            ::boost::shared_ptr< SysPwrModeGet > payload(new SysPwrModeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSysPwrModeGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "SysPwrSaveMode");
            ::boost::shared_ptr< SysPwrSaveModeGet > payload(new SysPwrSaveModeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSysPwrSaveModeGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "MapDownloadLockState");
            ::boost::shared_ptr< MapDownloadLockStateGet > payload(new MapDownloadLockStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onMapDownloadLockStateGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "StandbyTime");
            ::boost::shared_ptr< StandbyTimeGet > payload(new StandbyTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStandbyTimeGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "PersitentStandbyTime");
            ::boost::shared_ptr< PersitentStandbyTimeGet > payload(new PersitentStandbyTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onPersitentStandbyTimeGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "IgnitionOffTime");
            ::boost::shared_ptr< IgnitionOffTimeGet > payload(new IgnitionOffTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onIgnitionOffTimeGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "DoorOpenTime");
            ::boost::shared_ptr< DoorOpenTimeGet > payload(new DoorOpenTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDoorOpenTimeGet (payload);
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "ClockDisplayTime");
            ::boost::shared_ptr< ClockDisplayTimeGet > payload(new ClockDisplayTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onClockDisplayTimeGet (payload);
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "SystemStateTime");
            ::boost::shared_ptr< SystemStateTimeGet > payload(new SystemStateTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSystemStateTimeGet (payload);
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "ProcessList");
            ::boost::shared_ptr< ProcessListGet > payload(new ProcessListGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onProcessListGet (payload);
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "WakeupReason");
            ::boost::shared_ptr< WakeupReasonGet > payload(new WakeupReasonGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onWakeupReasonGet (payload);
            return;
        }
        case 22: {
            LOG_DEBUG_STUB("process property '%s'", "StartupReason");
            ::boost::shared_ptr< StartupReasonGet > payload(new StartupReasonGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStartupReasonGet (payload);
            return;
        }
        case 23: {
            LOG_DEBUG_STUB("process property '%s'", "ConnectToBattery");
            ::boost::shared_ptr< ConnectToBatteryGet > payload(new ConnectToBatteryGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onConnectToBatteryGet (payload);
            return;
        }
        case 24: {
            LOG_DEBUG_STUB("process property '%s'", "CodeRequestState");
            ::boost::shared_ptr< CodeRequestStateGet > payload(new CodeRequestStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onCodeRequestStateGet (payload);
            return;
        }
        case 25: {
            LOG_DEBUG_STUB("process property '%s'", "ActiveStartUpSyncPoints");
            ::boost::shared_ptr< ActiveStartUpSyncPointsGet > payload(new ActiveStartUpSyncPointsGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onActiveStartUpSyncPointsGet (payload);
            return;
        }
        case 26: {
            LOG_DEBUG_STUB("process property '%s'", "CvmEvent");
            ::boost::shared_ptr< CvmEventGet > payload(new CvmEventGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onCvmEventGet (payload);
            return;
        }
        case 27: {
            LOG_DEBUG_STUB("process property '%s'", "UBatSense");
            ::boost::shared_ptr< UBatSenseGet > payload(new UBatSenseGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onUBatSenseGet (payload);
            return;
        }
        case 28: {
            LOG_DEBUG_STUB("process property '%s'", "CoproState");
            ::boost::shared_ptr< CoproStateGet > payload(new CoproStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onCoproStateGet (payload);
            return;
        }
        case 29: {
            LOG_DEBUG_STUB("process property '%s'", "DevicePowerOnTime");
            ::boost::shared_ptr< DevicePowerOnTimeGet > payload(new DevicePowerOnTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDevicePowerOnTimeGet (payload);
            return;
        }
        case 30: {
            LOG_DEBUG_STUB("process property '%s'", "LastSystemRuntime");
            ::boost::shared_ptr< LastSystemRuntimeGet > payload(new LastSystemRuntimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onLastSystemRuntimeGet (payload);
            return;
        }
        case 31: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentSystemRuntime");
            ::boost::shared_ptr< CurrentSystemRuntimeGet > payload(new CurrentSystemRuntimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onCurrentSystemRuntimeGet (payload);
            return;
        }
        case 32: {
            LOG_DEBUG_STUB("process property '%s'", "ResetList");
            ::boost::shared_ptr< ResetListGet > payload(new ResetListGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onResetListGet (payload);
            return;
        }
        case 33: {
            LOG_DEBUG_STUB("process property '%s'", "ResetCounter");
            ::boost::shared_ptr< ResetCounterGet > payload(new ResetCounterGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onResetCounterGet (payload);
            return;
        }
        case 34: {
            LOG_DEBUG_STUB("process property '%s'", "TransportModeList");
            ::boost::shared_ptr< TransportModeListGet > payload(new TransportModeListGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onTransportModeListGet (payload);
            return;
        }
        case 35: {
            LOG_DEBUG_STUB("process property '%s'", "ResetHistory");
            ::boost::shared_ptr< ResetHistoryGet > payload(new ResetHistoryGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onResetHistoryGet (payload);
            return;
        }
        case 36: {
            LOG_DEBUG_STUB("process property '%s'", "WakeupHistory");
            ::boost::shared_ptr< WakeupHistoryGet > payload(new WakeupHistoryGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onWakeupHistoryGet (payload);
            return;
        }
        case 37: {
            LOG_DEBUG_STUB("process property '%s'", "StateHistory");
            ::boost::shared_ptr< StateHistoryGet > payload(new StateHistoryGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStateHistoryGet (payload);
            return;
        }
        case 38: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory01");
            ::boost::shared_ptr< ErrStateHistory01Get > payload(new ErrStateHistory01Get());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onErrStateHistory01Get (payload);
            return;
        }
        case 39: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory02");
            ::boost::shared_ptr< ErrStateHistory02Get > payload(new ErrStateHistory02Get());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onErrStateHistory02Get (payload);
            return;
        }
        case 40: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory03");
            ::boost::shared_ptr< ErrStateHistory03Get > payload(new ErrStateHistory03Get());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onErrStateHistory03Get (payload);
            return;
        }
        case 41: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory04");
            ::boost::shared_ptr< ErrStateHistory04Get > payload(new ErrStateHistory04Get());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onErrStateHistory04Get (payload);
            return;
        }
        case 42: {
            LOG_DEBUG_STUB("process property '%s'", "ErrStateHistory05");
            ::boost::shared_ptr< ErrStateHistory05Get > payload(new ErrStateHistory05Get());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onErrStateHistory05Get (payload);
            return;
        }
        case 43: {
            LOG_DEBUG_STUB("process property '%s'", "SwitchOnHistory");
            ::boost::shared_ptr< SwitchOnHistoryGet > payload(new SwitchOnHistoryGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSwitchOnHistoryGet (payload);
            return;
        }
        case 44: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceOnCounter");
            ::boost::shared_ptr< DeviceOnCounterGet > payload(new DeviceOnCounterGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDeviceOnCounterGet (payload);
            return;
        }
        case 45: {
            LOG_DEBUG_STUB("process property '%s'", "VoltageEventCounter");
            ::boost::shared_ptr< VoltageEventCounterGet > payload(new VoltageEventCounterGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onVoltageEventCounterGet (payload);
            return;
        }
        case 46: {
            LOG_DEBUG_STUB("process property '%s'", "VoltageRangeHistogram");
            ::boost::shared_ptr< VoltageRangeHistogramGet > payload(new VoltageRangeHistogramGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onVoltageRangeHistogramGet (payload);
            return;
        }
        case 47: {
            LOG_DEBUG_STUB("process property '%s'", "CpuUsageStatistic");
            ::boost::shared_ptr< CpuUsageStatisticGet > payload(new CpuUsageStatisticGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onCpuUsageStatisticGet (payload);
            return;
        }
        case 48: {
            LOG_DEBUG_STUB("process property '%s'", "RamUsageStatistic");
            ::boost::shared_ptr< RamUsageStatisticGet > payload(new RamUsageStatisticGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onRamUsageStatisticGet (payload);
            return;
        }
        case 49: {
            LOG_DEBUG_STUB("process property '%s'", "StartupTimeStatistic");
            ::boost::shared_ptr< StartupTimeStatisticGet > payload(new StartupTimeStatisticGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStartupTimeStatisticGet (payload);
            return;
        }
        case 50: {
            LOG_DEBUG_STUB("process property '%s'", "RunlevelState");
            ::boost::shared_ptr< RunlevelStateGet > payload(new RunlevelStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onRunlevelStateGet (payload);
            return;
        }
        case 51: {
            LOG_DEBUG_STUB("process property '%s'", "Restart");
            ::boost::shared_ptr< RestartGet > payload(new RestartGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onRestartGet (payload);
            return;
        }
        case 52: {
            LOG_DEBUG_STUB("process property '%s'", "Lifesign");
            ::boost::shared_ptr< LifesignGet > payload(new LifesignGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onLifesignGet (payload);
            return;
        }
        case 53: {
            LOG_DEBUG_STUB("process property '%s'", "HmiState");
            ::boost::shared_ptr< HmiStateGet > payload(new HmiStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onHmiStateGet (payload);
            return;
        }
        case 54: {
            LOG_DEBUG_STUB("process property '%s'", "SystemPowerBehaviour");
            ::boost::shared_ptr< SystemPowerBehaviourGet > payload(new SystemPowerBehaviourGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSystemPowerBehaviourGet (payload);
            return;
        }
        case 55: {
            LOG_DEBUG_STUB("process property '%s'", "DimState");
            ::boost::shared_ptr< DimStateGet > payload(new DimStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDimStateGet (payload);
            return;
        }
        case 56: {
            LOG_DEBUG_STUB("process property '%s'", "DimmingState");
            ::boost::shared_ptr< DimmingStateGet > payload(new DimmingStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDimmingStateGet (payload);
            return;
        }
        case 57: {
            LOG_DEBUG_STUB("process property '%s'", "BluetoothState");
            ::boost::shared_ptr< BluetoothStateGet > payload(new BluetoothStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onBluetoothStateGet (payload);
            return;
        }
        case 58: {
            LOG_DEBUG_STUB("process property '%s'", "AudioState");
            ::boost::shared_ptr< AudioStateGet > payload(new AudioStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onAudioStateGet (payload);
            return;
        }
        case 59: {
            LOG_DEBUG_STUB("process property '%s'", "SpiState");
            ::boost::shared_ptr< SpiStateGet > payload(new SpiStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSpiStateGet (payload);
            return;
        }
        case 60: {
            LOG_DEBUG_STUB("process property '%s'", "TunerState");
            ::boost::shared_ptr< TunerStateGet > payload(new TunerStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onTunerStateGet (payload);
            return;
        }
        case 61: {
            LOG_DEBUG_STUB("process property '%s'", "WifiState");
            ::boost::shared_ptr< WifiStateGet > payload(new WifiStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onWifiStateGet (payload);
            return;
        }
        case 62: {
            LOG_DEBUG_STUB("process property '%s'", "OnOffReason");
            ::boost::shared_ptr< OnOffReasonGet > payload(new OnOffReasonGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onOnOffReasonGet (payload);
            return;
        }
        case 63: {
            LOG_DEBUG_STUB("process property '%s'", "WakeupList");
            ::boost::shared_ptr< WakeupListGet > payload(new WakeupListGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onWakeupListGet (payload);
            return;
        }
        case 64: {
            LOG_DEBUG_STUB("process property '%s'", "StartupFinished");
            ::boost::shared_ptr< StartupFinishedGet > payload(new StartupFinishedGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStartupFinishedGet (payload);
            return;
        }
        case 65: {
            LOG_DEBUG_STUB("process property '%s'", "SysState");
            ::boost::shared_ptr< SysStateGet > payload(new SysStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSysStateGet (payload);
            return;
        }
        case 66: {
            LOG_DEBUG_STUB("process property '%s'", "MostState");
            ::boost::shared_ptr< MostStateGet > payload(new MostStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onMostStateGet (payload);
            return;
        }
        case 67: {
            LOG_DEBUG_STUB("process property '%s'", "MostVersion");
            ::boost::shared_ptr< MostVersionGet > payload(new MostVersionGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onMostVersionGet (payload);
            return;
        }
        case 68: {
            LOG_DEBUG_STUB("process property '%s'", "RVCState");
            ::boost::shared_ptr< RVCStateGet > payload(new RVCStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onRVCStateGet (payload);
            return;
        }
        case 69: {
            LOG_DEBUG_STUB("process property '%s'", "TriggerMostRemoteReset");
            ::boost::shared_ptr< TriggerMostRemoteResetGet > payload(new TriggerMostRemoteResetGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onTriggerMostRemoteResetGet (payload);
            return;
        }
        case 70: {
            LOG_DEBUG_STUB("process property '%s'", "Partnumber");
            ::boost::shared_ptr< PartnumberGet > payload(new PartnumberGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onPartnumberGet (payload);
            return;
        }
        case 71: {
            LOG_DEBUG_STUB("process property '%s'", "Partnumbers");
            ::boost::shared_ptr< PartnumbersGet > payload(new PartnumbersGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onPartnumbersGet (payload);
            return;
        }
        case 72: {
            LOG_DEBUG_STUB("process property '%s'", "Alphacode");
            ::boost::shared_ptr< AlphacodeGet > payload(new AlphacodeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onAlphacodeGet (payload);
            return;
        }
        case 73: {
            LOG_DEBUG_STUB("process property '%s'", "Alphacodes");
            ::boost::shared_ptr< AlphacodesGet > payload(new AlphacodesGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onAlphacodesGet (payload);
            return;
        }
        case 74: {
            LOG_DEBUG_STUB("process property '%s'", "ManufacturersEnableCounter");
            ::boost::shared_ptr< ManufacturersEnableCounterGet > payload(new ManufacturersEnableCounterGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onManufacturersEnableCounterGet (payload);
            return;
        }
        case 75: {
            LOG_DEBUG_STUB("process property '%s'", "NoCalibrationState");
            ::boost::shared_ptr< NoCalibrationStateGet > payload(new NoCalibrationStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onNoCalibrationStateGet (payload);
            return;
        }
        case 76: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityCommError");
            ::boost::shared_ptr< SecurityCommErrorGet > payload(new SecurityCommErrorGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSecurityCommErrorGet (payload);
            return;
        }
        case 77: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityMoreThan10Vin");
            ::boost::shared_ptr< SecurityMoreThan10VinGet > payload(new SecurityMoreThan10VinGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSecurityMoreThan10VinGet (payload);
            return;
        }
        case 78: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityInvalidVin");
            ::boost::shared_ptr< SecurityInvalidVinGet > payload(new SecurityInvalidVinGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSecurityInvalidVinGet (payload);
            return;
        }
        case 79: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityCurrentVin");
            ::boost::shared_ptr< SecurityCurrentVinGet > payload(new SecurityCurrentVinGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSecurityCurrentVinGet (payload);
            return;
        }
        case 80: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityVinHistory");
            ::boost::shared_ptr< SecurityVinHistoryGet > payload(new SecurityVinHistoryGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSecurityVinHistoryGet (payload);
            return;
        }
        case 81: {
            LOG_DEBUG_STUB("process property '%s'", "VIN");
            ::boost::shared_ptr< VINGet > payload(new VINGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onVINGet (payload);
            return;
        }
        case 82: {
            LOG_DEBUG_STUB("process property '%s'", "SecurityState");
            ::boost::shared_ptr< SecurityStateGet > payload(new SecurityStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onSecurityStateGet (payload);
            return;
        }
        case 83: {
            LOG_DEBUG_STUB("process property '%s'", "VehicleID");
            ::boost::shared_ptr< VehicleIDGet > payload(new VehicleIDGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onVehicleIDGet (payload);
            return;
        }
        case 84: {
            LOG_DEBUG_STUB("process property '%s'", "DisplayVariant");
            ::boost::shared_ptr< DisplayVariantGet > payload(new DisplayVariantGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDisplayVariantGet (payload);
            return;
        }
        case 85: {
            LOG_DEBUG_STUB("process property '%s'", "ReductionLevel");
            ::boost::shared_ptr< ReductionLevelGet > payload(new ReductionLevelGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onReductionLevelGet (payload);
            return;
        }
        case 86: {
            LOG_DEBUG_STUB("process property '%s'", "StartupState");
            ::boost::shared_ptr< StartupStateGet > payload(new StartupStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onStartupStateGet (payload);
            return;
        }
        case 87: {
            LOG_DEBUG_STUB("process property '%s'", "EntertainMute");
            ::boost::shared_ptr< EntertainMuteGet > payload(new EntertainMuteGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onEntertainMuteGet (payload);
            return;
        }
        case 88: {
            LOG_DEBUG_STUB("process property '%s'", "WelcomeAudioState");
            ::boost::shared_ptr< WelcomeAudioStateGet > payload(new WelcomeAudioStateGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onWelcomeAudioStateGet (payload);
            return;
        }
        case 89: {
            LOG_DEBUG_STUB("process property '%s'", "UnballastTimeFromEngineStopped");
            ::boost::shared_ptr< UnballastTimeFromEngineStoppedGet > payload(new UnballastTimeFromEngineStoppedGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onUnballastTimeFromEngineStoppedGet (payload);
            return;
        }
        case 90: {
            LOG_DEBUG_STUB("process property '%s'", "UnballastTimeBeforeUnballast");
            ::boost::shared_ptr< UnballastTimeBeforeUnballastGet > payload(new UnballastTimeBeforeUnballastGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onUnballastTimeBeforeUnballastGet (payload);
            return;
        }
        case 91: {
            LOG_DEBUG_STUB("process property '%s'", "UnballastWarningTime");
            ::boost::shared_ptr< UnballastWarningTimeGet > payload(new UnballastWarningTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onUnballastWarningTimeGet (payload);
            return;
        }
        case 92: {
            LOG_DEBUG_STUB("process property '%s'", "DegradedCount");
            ::boost::shared_ptr< DegradedCountGet > payload(new DegradedCountGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDegradedCountGet (payload);
            return;
        }
        case 93: {
            LOG_DEBUG_STUB("process property '%s'", "DegradedTime");
            ::boost::shared_ptr< DegradedTimeGet > payload(new DegradedTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onDegradedTimeGet (payload);
            return;
        }
        case 94: {
            LOG_DEBUG_STUB("process property '%s'", "PhoneHandoverWarnTime");
            ::boost::shared_ptr< PhoneHandoverWarnTimeGet > payload(new PhoneHandoverWarnTimeGet());
            payload->setAct(act);
            static_cast<Lcm_dbus_fi_serviceStub*>(getStub())->onPhoneHandoverWarnTimeGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Lcm_dbus_fi_serviceStub::Lcm_dbus_fi_serviceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Lcm_dbus_fi_serviceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Lcm_dbus_fi_serviceStub::Lcm_dbus_fi_serviceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Lcm_dbus_fi_serviceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Lcm_dbus_fi_serviceStub::~Lcm_dbus_fi_serviceStub() {
    delete _stubDelegate;
}

void Lcm_dbus_fi_serviceStub::sendSystemStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemStateUpdate payload(_SystemStateProperty);

        LOG_INFO ("-> send%s", "SystemStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSystemStateGet(const ::boost::shared_ptr< SystemStateGet >& systemState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemStateGet", systemState->getAct());
    sendSystemStateGetUpdate(_SystemStateProperty.getSystemState(), systemState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSystemStateGetUpdate(T_SPM_e32_SYSTEM_STATES systemState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemStateGet payload(systemState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSystemState(T_SPM_e32_SYSTEM_STATES systemState) {
    if(systemState!=_SystemStateProperty.getSystemState()) {
        _SystemStateProperty.setSystemState(systemState);
        sendSystemStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_SYSTEM_STATES Lcm_dbus_fi_serviceStub::getSystemState() const {
    return _SystemStateProperty.getSystemState();
}

void Lcm_dbus_fi_serviceStub::sendDownloadLockStatesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DownloadLockStatesUpdate payload(_DownloadLockStatesProperty);

        LOG_INFO ("-> send%s", "DownloadLockStatesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DownloadLockStates", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DownloadLockStatesUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDownloadLockStatesGet(const ::boost::shared_ptr< DownloadLockStatesGet >& downloadLockStates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DownloadLockStatesGet", downloadLockStates->getAct());
    sendDownloadLockStatesGetUpdate(_DownloadLockStatesProperty.getDownloadLockStates(), downloadLockStates->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDownloadLockStatesGetUpdate(const ::std::vector< T_SPM_RestrictedDlLock >& downloadLockStates, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DownloadLockStatesGet payload(downloadLockStates);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DownloadLockStatesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDownloadLockStates(const ::std::vector< T_SPM_RestrictedDlLock >& downloadLockStates) {
    if(downloadLockStates!=_DownloadLockStatesProperty.getDownloadLockStates()) {
        _DownloadLockStatesProperty.setDownloadLockStates(downloadLockStates);
        sendDownloadLockStatesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_SPM_RestrictedDlLock >& Lcm_dbus_fi_serviceStub::getDownloadLockStates() const {
    return _DownloadLockStatesProperty.getDownloadLockStates();
}

::std::vector< T_SPM_RestrictedDlLock >& Lcm_dbus_fi_serviceStub::getDownloadLockStatesMutable() {
    return _DownloadLockStatesProperty.getDownloadLockStatesMutable();
}

void Lcm_dbus_fi_serviceStub::sendUpdateLockStatesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UpdateLockStatesUpdate payload(_UpdateLockStatesProperty);

        LOG_INFO ("-> send%s", "UpdateLockStatesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UpdateLockStates", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UpdateLockStatesUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onUpdateLockStatesGet(const ::boost::shared_ptr< UpdateLockStatesGet >& updateLockStates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UpdateLockStatesGet", updateLockStates->getAct());
    sendUpdateLockStatesGetUpdate(_UpdateLockStatesProperty.getUpdateLockStates(), updateLockStates->getAct());
}

void Lcm_dbus_fi_serviceStub::sendUpdateLockStatesGetUpdate(const ::std::vector< T_SPM_UpdateLockState >& updateLockStates, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UpdateLockStatesGet payload(updateLockStates);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UpdateLockStatesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setUpdateLockStates(const ::std::vector< T_SPM_UpdateLockState >& updateLockStates) {
    if(updateLockStates!=_UpdateLockStatesProperty.getUpdateLockStates()) {
        _UpdateLockStatesProperty.setUpdateLockStates(updateLockStates);
        sendUpdateLockStatesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_SPM_UpdateLockState >& Lcm_dbus_fi_serviceStub::getUpdateLockStates() const {
    return _UpdateLockStatesProperty.getUpdateLockStates();
}

::std::vector< T_SPM_UpdateLockState >& Lcm_dbus_fi_serviceStub::getUpdateLockStatesMutable() {
    return _UpdateLockStatesProperty.getUpdateLockStatesMutable();
}

void Lcm_dbus_fi_serviceStub::sendActiveOnOffTriggerUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveOnOffTriggerUpdate payload(_ActiveOnOffTriggerProperty);

        LOG_INFO ("-> send%s", "ActiveOnOffTriggerUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveOnOffTrigger", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveOnOffTriggerUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onActiveOnOffTriggerGet(const ::boost::shared_ptr< ActiveOnOffTriggerGet >& activeOnOffTrigger) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveOnOffTriggerGet", activeOnOffTrigger->getAct());
    sendActiveOnOffTriggerGetUpdate(_ActiveOnOffTriggerProperty.getActiveOnOffTrigger(), activeOnOffTrigger->getAct());
}

void Lcm_dbus_fi_serviceStub::sendActiveOnOffTriggerGetUpdate(const ::std::vector< T_SPM_e32_SubStateType >& activeOnOffTrigger, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveOnOffTriggerGet payload(activeOnOffTrigger);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveOnOffTriggerGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setActiveOnOffTrigger(const ::std::vector< T_SPM_e32_SubStateType >& activeOnOffTrigger) {
    if(activeOnOffTrigger!=_ActiveOnOffTriggerProperty.getActiveOnOffTrigger()) {
        _ActiveOnOffTriggerProperty.setActiveOnOffTrigger(activeOnOffTrigger);
        sendActiveOnOffTriggerUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_SPM_e32_SubStateType >& Lcm_dbus_fi_serviceStub::getActiveOnOffTrigger() const {
    return _ActiveOnOffTriggerProperty.getActiveOnOffTrigger();
}

::std::vector< T_SPM_e32_SubStateType >& Lcm_dbus_fi_serviceStub::getActiveOnOffTriggerMutable() {
    return _ActiveOnOffTriggerProperty.getActiveOnOffTriggerMutable();
}

void Lcm_dbus_fi_serviceStub::sendSubStatesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SubStatesUpdate payload(_SubStatesProperty);

        LOG_INFO ("-> send%s", "SubStatesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SubStates", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SubStatesUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSubStatesGet(const ::boost::shared_ptr< SubStatesGet >& subStates) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SubStatesGet", subStates->getAct());
    sendSubStatesGetUpdate(_SubStatesProperty.getSubStates(), subStates->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSubStatesGetUpdate(const TSubStates& subStates, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SubStatesGet payload(subStates);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SubStatesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSubStates(const TSubStates& subStates) {
    if(subStates!=_SubStatesProperty.getSubStates()) {
        _SubStatesProperty.setSubStates(subStates);
        sendSubStatesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TSubStates& Lcm_dbus_fi_serviceStub::getSubStates() const {
    return _SubStatesProperty.getSubStates();
}

TSubStates& Lcm_dbus_fi_serviceStub::getSubStatesMutable() {
    return _SubStatesProperty.getSubStatesMutable();
}

void Lcm_dbus_fi_serviceStub::sendHistoryTriggerUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HistoryTriggerUpdate payload(_HistoryTriggerProperty);

        LOG_INFO ("-> send%s", "HistoryTriggerUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("HistoryTrigger", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HistoryTriggerUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onHistoryTriggerGet(const ::boost::shared_ptr< HistoryTriggerGet >& historyTrigger) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HistoryTriggerGet", historyTrigger->getAct());
    sendHistoryTriggerGetUpdate(_HistoryTriggerProperty.getHistoryTrigger(), historyTrigger->getAct());
}

void Lcm_dbus_fi_serviceStub::sendHistoryTriggerGetUpdate(const ::std::vector< T_SPM_HistoryTrigger >& historyTrigger, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HistoryTriggerGet payload(historyTrigger);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HistoryTriggerGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setHistoryTrigger(const ::std::vector< T_SPM_HistoryTrigger >& historyTrigger) {
    if(historyTrigger!=_HistoryTriggerProperty.getHistoryTrigger()) {
        _HistoryTriggerProperty.setHistoryTrigger(historyTrigger);
        sendHistoryTriggerUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_SPM_HistoryTrigger >& Lcm_dbus_fi_serviceStub::getHistoryTrigger() const {
    return _HistoryTriggerProperty.getHistoryTrigger();
}

::std::vector< T_SPM_HistoryTrigger >& Lcm_dbus_fi_serviceStub::getHistoryTriggerMutable() {
    return _HistoryTriggerProperty.getHistoryTriggerMutable();
}

void Lcm_dbus_fi_serviceStub::sendInsertStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        InsertStateUpdate payload(_InsertStateProperty);

        LOG_INFO ("-> send%s", "InsertStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("InsertState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "InsertStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onInsertStateGet(const ::boost::shared_ptr< InsertStateGet >& insertState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "InsertStateGet", insertState->getAct());
    sendInsertStateGetUpdate(_InsertStateProperty.getInsertState(), insertState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendInsertStateGetUpdate(T_SPM_e32_CD_INSERT_STATE insertState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    InsertStateGet payload(insertState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "InsertStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setInsertState(T_SPM_e32_CD_INSERT_STATE insertState) {
    if(insertState!=_InsertStateProperty.getInsertState()) {
        _InsertStateProperty.setInsertState(insertState);
        sendInsertStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_CD_INSERT_STATE Lcm_dbus_fi_serviceStub::getInsertState() const {
    return _InsertStateProperty.getInsertState();
}

void Lcm_dbus_fi_serviceStub::sendMediaEjectStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MediaEjectStateUpdate payload(_MediaEjectStateProperty);

        LOG_INFO ("-> send%s", "MediaEjectStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MediaEjectState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MediaEjectStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onMediaEjectStateGet(const ::boost::shared_ptr< MediaEjectStateGet >& mediaEjectState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MediaEjectStateGet", mediaEjectState->getAct());
    sendMediaEjectStateGetUpdate(_MediaEjectStateProperty.getMediaEjectState(), mediaEjectState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendMediaEjectStateGetUpdate(T_SPM_e32_MEDIA_EJECT_STATE mediaEjectState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MediaEjectStateGet payload(mediaEjectState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MediaEjectStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setMediaEjectState(T_SPM_e32_MEDIA_EJECT_STATE mediaEjectState) {
    if(mediaEjectState!=_MediaEjectStateProperty.getMediaEjectState()) {
        _MediaEjectStateProperty.setMediaEjectState(mediaEjectState);
        sendMediaEjectStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_MEDIA_EJECT_STATE Lcm_dbus_fi_serviceStub::getMediaEjectState() const {
    return _MediaEjectStateProperty.getMediaEjectState();
}

void Lcm_dbus_fi_serviceStub::sendPhoneMuteStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PhoneMuteStateUpdate payload(_PhoneMuteStateProperty);

        LOG_INFO ("-> send%s", "PhoneMuteStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PhoneMuteState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PhoneMuteStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onPhoneMuteStateGet(const ::boost::shared_ptr< PhoneMuteStateGet >& phoneMuteState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PhoneMuteStateGet", phoneMuteState->getAct());
    sendPhoneMuteStateGetUpdate(_PhoneMuteStateProperty.getPhoneMuteState(), phoneMuteState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendPhoneMuteStateGetUpdate(T_SPM_e32_PHONE_MUTE_STATE phoneMuteState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PhoneMuteStateGet payload(phoneMuteState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PhoneMuteStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setPhoneMuteState(T_SPM_e32_PHONE_MUTE_STATE phoneMuteState) {
    if(phoneMuteState!=_PhoneMuteStateProperty.getPhoneMuteState()) {
        _PhoneMuteStateProperty.setPhoneMuteState(phoneMuteState);
        sendPhoneMuteStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_PHONE_MUTE_STATE Lcm_dbus_fi_serviceStub::getPhoneMuteState() const {
    return _PhoneMuteStateProperty.getPhoneMuteState();
}

void Lcm_dbus_fi_serviceStub::sendOnTipperStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        OnTipperStateUpdate payload(_OnTipperStateProperty);

        LOG_INFO ("-> send%s", "OnTipperStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("OnTipperState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "OnTipperStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onOnTipperStateGet(const ::boost::shared_ptr< OnTipperStateGet >& onTipperState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "OnTipperStateGet", onTipperState->getAct());
    sendOnTipperStateGetUpdate(_OnTipperStateProperty.getOnTipperState(), onTipperState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendOnTipperStateGetUpdate(T_SPM_e32_KEY_STATE onTipperState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    OnTipperStateGet payload(onTipperState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "OnTipperStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setOnTipperState(T_SPM_e32_KEY_STATE onTipperState) {
    if(onTipperState!=_OnTipperStateProperty.getOnTipperState()) {
        _OnTipperStateProperty.setOnTipperState(onTipperState);
        sendOnTipperStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_KEY_STATE Lcm_dbus_fi_serviceStub::getOnTipperState() const {
    return _OnTipperStateProperty.getOnTipperState();
}

void Lcm_dbus_fi_serviceStub::sendIgnitionCyclesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IgnitionCyclesUpdate payload(_IgnitionCyclesProperty);

        LOG_INFO ("-> send%s", "IgnitionCyclesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IgnitionCycles", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IgnitionCyclesUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onIgnitionCyclesGet(const ::boost::shared_ptr< IgnitionCyclesGet >& ignitionCycles) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IgnitionCyclesGet", ignitionCycles->getAct());
    sendIgnitionCyclesGetUpdate(_IgnitionCyclesProperty.getIgnitionCycles(), ignitionCycles->getAct());
}

void Lcm_dbus_fi_serviceStub::sendIgnitionCyclesGetUpdate(uint32 ignitionCycles, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IgnitionCyclesGet payload(ignitionCycles);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IgnitionCyclesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setIgnitionCycles(uint32 ignitionCycles) {
    if(ignitionCycles!=_IgnitionCyclesProperty.getIgnitionCycles()) {
        _IgnitionCyclesProperty.setIgnitionCycles(ignitionCycles);
        sendIgnitionCyclesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getIgnitionCycles() const {
    return _IgnitionCyclesProperty.getIgnitionCycles();
}

void Lcm_dbus_fi_serviceStub::sendSysPwrModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SysPwrModeUpdate payload(_SysPwrModeProperty);

        LOG_INFO ("-> send%s", "SysPwrModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SysPwrMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SysPwrModeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSysPwrModeGet(const ::boost::shared_ptr< SysPwrModeGet >& sysPwrMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SysPwrModeGet", sysPwrMode->getAct());
    sendSysPwrModeGetUpdate(_SysPwrModeProperty.getSysPwrMode(), sysPwrMode->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSysPwrModeGetUpdate(T_SPM_e32_SYSPWRMODE sysPwrMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SysPwrModeGet payload(sysPwrMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SysPwrModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSysPwrMode(T_SPM_e32_SYSPWRMODE sysPwrMode) {
    if(sysPwrMode!=_SysPwrModeProperty.getSysPwrMode()) {
        _SysPwrModeProperty.setSysPwrMode(sysPwrMode);
        sendSysPwrModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_SYSPWRMODE Lcm_dbus_fi_serviceStub::getSysPwrMode() const {
    return _SysPwrModeProperty.getSysPwrMode();
}

void Lcm_dbus_fi_serviceStub::sendSysPwrSaveModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SysPwrSaveModeUpdate payload(_SysPwrSaveModeProperty);

        LOG_INFO ("-> send%s", "SysPwrSaveModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SysPwrSaveMode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SysPwrSaveModeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSysPwrSaveModeGet(const ::boost::shared_ptr< SysPwrSaveModeGet >& sysPwrSaveMode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SysPwrSaveModeGet", sysPwrSaveMode->getAct());
    sendSysPwrSaveModeGetUpdate(_SysPwrSaveModeProperty.getSysPwrSaveMode(), sysPwrSaveMode->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSysPwrSaveModeGetUpdate(const T_SPM_b32_SYSPWRSAVEMODE& sysPwrSaveMode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SysPwrSaveModeGet payload(sysPwrSaveMode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SysPwrSaveModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSysPwrSaveMode(const T_SPM_b32_SYSPWRSAVEMODE& sysPwrSaveMode) {
    if(sysPwrSaveMode!=_SysPwrSaveModeProperty.getSysPwrSaveMode()) {
        _SysPwrSaveModeProperty.setSysPwrSaveMode(sysPwrSaveMode);
        sendSysPwrSaveModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_b32_SYSPWRSAVEMODE& Lcm_dbus_fi_serviceStub::getSysPwrSaveMode() const {
    return _SysPwrSaveModeProperty.getSysPwrSaveMode();
}

T_SPM_b32_SYSPWRSAVEMODE& Lcm_dbus_fi_serviceStub::getSysPwrSaveModeMutable() {
    return _SysPwrSaveModeProperty.getSysPwrSaveModeMutable();
}

void Lcm_dbus_fi_serviceStub::sendMapDownloadLockStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MapDownloadLockStateUpdate payload(_MapDownloadLockStateProperty);

        LOG_INFO ("-> send%s", "MapDownloadLockStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MapDownloadLockState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MapDownloadLockStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onMapDownloadLockStateGet(const ::boost::shared_ptr< MapDownloadLockStateGet >& mapDownloadLockState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MapDownloadLockStateGet", mapDownloadLockState->getAct());
    sendMapDownloadLockStateGetUpdate(_MapDownloadLockStateProperty.getMapDownloadLockState(), mapDownloadLockState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendMapDownloadLockStateGetUpdate(uint16 mapDownloadLockState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MapDownloadLockStateGet payload(mapDownloadLockState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MapDownloadLockStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setMapDownloadLockState(uint16 mapDownloadLockState) {
    if(mapDownloadLockState!=_MapDownloadLockStateProperty.getMapDownloadLockState()) {
        _MapDownloadLockStateProperty.setMapDownloadLockState(mapDownloadLockState);
        sendMapDownloadLockStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Lcm_dbus_fi_serviceStub::getMapDownloadLockState() const {
    return _MapDownloadLockStateProperty.getMapDownloadLockState();
}

void Lcm_dbus_fi_serviceStub::sendStandbyTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StandbyTimeUpdate payload(_StandbyTimeProperty);

        LOG_INFO ("-> send%s", "StandbyTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StandbyTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StandbyTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onStandbyTimeGet(const ::boost::shared_ptr< StandbyTimeGet >& standbyTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StandbyTimeGet", standbyTime->getAct());
    sendStandbyTimeGetUpdate(_StandbyTimeProperty.getStandbyTime(), standbyTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendStandbyTimeGetUpdate(uint32 standbyTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StandbyTimeGet payload(standbyTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StandbyTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setStandbyTime(uint32 standbyTime) {
    if(standbyTime!=_StandbyTimeProperty.getStandbyTime()) {
        _StandbyTimeProperty.setStandbyTime(standbyTime);
        sendStandbyTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getStandbyTime() const {
    return _StandbyTimeProperty.getStandbyTime();
}

void Lcm_dbus_fi_serviceStub::sendPersitentStandbyTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PersitentStandbyTimeUpdate payload(_PersitentStandbyTimeProperty);

        LOG_INFO ("-> send%s", "PersitentStandbyTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PersitentStandbyTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PersitentStandbyTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onPersitentStandbyTimeGet(const ::boost::shared_ptr< PersitentStandbyTimeGet >& persitentStandbyTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PersitentStandbyTimeGet", persitentStandbyTime->getAct());
    sendPersitentStandbyTimeGetUpdate(_PersitentStandbyTimeProperty.getPersitentStandbyTime(), persitentStandbyTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendPersitentStandbyTimeGetUpdate(uint32 persitentStandbyTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PersitentStandbyTimeGet payload(persitentStandbyTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PersitentStandbyTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setPersitentStandbyTime(uint32 persitentStandbyTime) {
    if(persitentStandbyTime!=_PersitentStandbyTimeProperty.getPersitentStandbyTime()) {
        _PersitentStandbyTimeProperty.setPersitentStandbyTime(persitentStandbyTime);
        sendPersitentStandbyTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getPersitentStandbyTime() const {
    return _PersitentStandbyTimeProperty.getPersitentStandbyTime();
}

void Lcm_dbus_fi_serviceStub::sendIgnitionOffTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IgnitionOffTimeUpdate payload(_IgnitionOffTimeProperty);

        LOG_INFO ("-> send%s", "IgnitionOffTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IgnitionOffTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IgnitionOffTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onIgnitionOffTimeGet(const ::boost::shared_ptr< IgnitionOffTimeGet >& ignitionOffTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IgnitionOffTimeGet", ignitionOffTime->getAct());
    sendIgnitionOffTimeGetUpdate(_IgnitionOffTimeProperty.getIgnitionOffTime(), ignitionOffTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendIgnitionOffTimeGetUpdate(uint32 ignitionOffTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IgnitionOffTimeGet payload(ignitionOffTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IgnitionOffTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setIgnitionOffTime(uint32 ignitionOffTime) {
    if(ignitionOffTime!=_IgnitionOffTimeProperty.getIgnitionOffTime()) {
        _IgnitionOffTimeProperty.setIgnitionOffTime(ignitionOffTime);
        sendIgnitionOffTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getIgnitionOffTime() const {
    return _IgnitionOffTimeProperty.getIgnitionOffTime();
}

void Lcm_dbus_fi_serviceStub::sendDoorOpenTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DoorOpenTimeUpdate payload(_DoorOpenTimeProperty);

        LOG_INFO ("-> send%s", "DoorOpenTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DoorOpenTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DoorOpenTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDoorOpenTimeGet(const ::boost::shared_ptr< DoorOpenTimeGet >& doorOpenTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DoorOpenTimeGet", doorOpenTime->getAct());
    sendDoorOpenTimeGetUpdate(_DoorOpenTimeProperty.getDoorOpenTime(), doorOpenTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDoorOpenTimeGetUpdate(uint32 doorOpenTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DoorOpenTimeGet payload(doorOpenTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DoorOpenTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDoorOpenTime(uint32 doorOpenTime) {
    if(doorOpenTime!=_DoorOpenTimeProperty.getDoorOpenTime()) {
        _DoorOpenTimeProperty.setDoorOpenTime(doorOpenTime);
        sendDoorOpenTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getDoorOpenTime() const {
    return _DoorOpenTimeProperty.getDoorOpenTime();
}

void Lcm_dbus_fi_serviceStub::sendClockDisplayTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ClockDisplayTimeUpdate payload(_ClockDisplayTimeProperty);

        LOG_INFO ("-> send%s", "ClockDisplayTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ClockDisplayTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ClockDisplayTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onClockDisplayTimeGet(const ::boost::shared_ptr< ClockDisplayTimeGet >& clockDisplayTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ClockDisplayTimeGet", clockDisplayTime->getAct());
    sendClockDisplayTimeGetUpdate(_ClockDisplayTimeProperty.getClockDisplayTime(), clockDisplayTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendClockDisplayTimeGetUpdate(uint32 clockDisplayTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ClockDisplayTimeGet payload(clockDisplayTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ClockDisplayTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setClockDisplayTime(uint32 clockDisplayTime) {
    if(clockDisplayTime!=_ClockDisplayTimeProperty.getClockDisplayTime()) {
        _ClockDisplayTimeProperty.setClockDisplayTime(clockDisplayTime);
        sendClockDisplayTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getClockDisplayTime() const {
    return _ClockDisplayTimeProperty.getClockDisplayTime();
}

void Lcm_dbus_fi_serviceStub::sendSystemStateTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemStateTimeUpdate payload(_SystemStateTimeProperty);

        LOG_INFO ("-> send%s", "SystemStateTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemStateTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemStateTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSystemStateTimeGet(const ::boost::shared_ptr< SystemStateTimeGet >& systemStateTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemStateTimeGet", systemStateTime->getAct());
    sendSystemStateTimeGetUpdate(_SystemStateTimeProperty.getSystemStateTime(), systemStateTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSystemStateTimeGetUpdate(const TSystemStateTime& systemStateTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemStateTimeGet payload(systemStateTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemStateTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSystemStateTime(const TSystemStateTime& systemStateTime) {
    if(systemStateTime!=_SystemStateTimeProperty.getSystemStateTime()) {
        _SystemStateTimeProperty.setSystemStateTime(systemStateTime);
        sendSystemStateTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TSystemStateTime& Lcm_dbus_fi_serviceStub::getSystemStateTime() const {
    return _SystemStateTimeProperty.getSystemStateTime();
}

TSystemStateTime& Lcm_dbus_fi_serviceStub::getSystemStateTimeMutable() {
    return _SystemStateTimeProperty.getSystemStateTimeMutable();
}

void Lcm_dbus_fi_serviceStub::sendProcessListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProcessListUpdate payload(_ProcessListProperty);

        LOG_INFO ("-> send%s", "ProcessListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ProcessList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProcessListUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onProcessListGet(const ::boost::shared_ptr< ProcessListGet >& processList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProcessListGet", processList->getAct());
    sendProcessListGetUpdate(_ProcessListProperty.getProcessList(), processList->getAct());
}

void Lcm_dbus_fi_serviceStub::sendProcessListGetUpdate(const T_SPM_ProcessInfo& processList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProcessListGet payload(processList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProcessListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setProcessList(const T_SPM_ProcessInfo& processList) {
    if(processList!=_ProcessListProperty.getProcessList()) {
        _ProcessListProperty.setProcessList(processList);
        sendProcessListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_ProcessInfo& Lcm_dbus_fi_serviceStub::getProcessList() const {
    return _ProcessListProperty.getProcessList();
}

T_SPM_ProcessInfo& Lcm_dbus_fi_serviceStub::getProcessListMutable() {
    return _ProcessListProperty.getProcessListMutable();
}

void Lcm_dbus_fi_serviceStub::sendWakeupReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WakeupReasonUpdate payload(_WakeupReasonProperty);

        LOG_INFO ("-> send%s", "WakeupReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WakeupReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WakeupReasonUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onWakeupReasonGet(const ::boost::shared_ptr< WakeupReasonGet >& wakeupReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WakeupReasonGet", wakeupReason->getAct());
    sendWakeupReasonGetUpdate(_WakeupReasonProperty.getWakeupReason(), wakeupReason->getAct());
}

void Lcm_dbus_fi_serviceStub::sendWakeupReasonGetUpdate(T_SPM_e32_WAKEUP_REASON wakeupReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WakeupReasonGet payload(wakeupReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WakeupReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setWakeupReason(T_SPM_e32_WAKEUP_REASON wakeupReason) {
    if(wakeupReason!=_WakeupReasonProperty.getWakeupReason()) {
        _WakeupReasonProperty.setWakeupReason(wakeupReason);
        sendWakeupReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_WAKEUP_REASON Lcm_dbus_fi_serviceStub::getWakeupReason() const {
    return _WakeupReasonProperty.getWakeupReason();
}

void Lcm_dbus_fi_serviceStub::sendStartupReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupReasonUpdate payload(_StartupReasonProperty);

        LOG_INFO ("-> send%s", "StartupReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupReasonUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onStartupReasonGet(const ::boost::shared_ptr< StartupReasonGet >& startupReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupReasonGet", startupReason->getAct());
    sendStartupReasonGetUpdate(_StartupReasonProperty.getStartupReason(), startupReason->getAct());
}

void Lcm_dbus_fi_serviceStub::sendStartupReasonGetUpdate(T_SPM_e32_STARTUP_REASON startupReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupReasonGet payload(startupReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setStartupReason(T_SPM_e32_STARTUP_REASON startupReason) {
    if(startupReason!=_StartupReasonProperty.getStartupReason()) {
        _StartupReasonProperty.setStartupReason(startupReason);
        sendStartupReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_STARTUP_REASON Lcm_dbus_fi_serviceStub::getStartupReason() const {
    return _StartupReasonProperty.getStartupReason();
}

void Lcm_dbus_fi_serviceStub::sendConnectToBatteryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectToBatteryUpdate payload(_ConnectToBatteryProperty);

        LOG_INFO ("-> send%s", "ConnectToBatteryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConnectToBattery", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectToBatteryUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onConnectToBatteryGet(const ::boost::shared_ptr< ConnectToBatteryGet >& connectToBattery) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectToBatteryGet", connectToBattery->getAct());
    sendConnectToBatteryGetUpdate(_ConnectToBatteryProperty.getConnectToBattery(), connectToBattery->getAct());
}

void Lcm_dbus_fi_serviceStub::sendConnectToBatteryGetUpdate(const TConnectToBattery& connectToBattery, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectToBatteryGet payload(connectToBattery);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectToBatteryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setConnectToBattery(const TConnectToBattery& connectToBattery) {
    if(connectToBattery!=_ConnectToBatteryProperty.getConnectToBattery()) {
        _ConnectToBatteryProperty.setConnectToBattery(connectToBattery);
        sendConnectToBatteryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TConnectToBattery& Lcm_dbus_fi_serviceStub::getConnectToBattery() const {
    return _ConnectToBatteryProperty.getConnectToBattery();
}

TConnectToBattery& Lcm_dbus_fi_serviceStub::getConnectToBatteryMutable() {
    return _ConnectToBatteryProperty.getConnectToBatteryMutable();
}

void Lcm_dbus_fi_serviceStub::sendCodeRequestStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CodeRequestStateUpdate payload(_CodeRequestStateProperty);

        LOG_INFO ("-> send%s", "CodeRequestStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CodeRequestState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CodeRequestStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onCodeRequestStateGet(const ::boost::shared_ptr< CodeRequestStateGet >& codeRequestState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CodeRequestStateGet", codeRequestState->getAct());
    sendCodeRequestStateGetUpdate(_CodeRequestStateProperty.getCodeRequestState(), codeRequestState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendCodeRequestStateGetUpdate(T_SPM_e32_CODE_REQUEST codeRequestState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CodeRequestStateGet payload(codeRequestState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CodeRequestStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setCodeRequestState(T_SPM_e32_CODE_REQUEST codeRequestState) {
    if(codeRequestState!=_CodeRequestStateProperty.getCodeRequestState()) {
        _CodeRequestStateProperty.setCodeRequestState(codeRequestState);
        sendCodeRequestStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_CODE_REQUEST Lcm_dbus_fi_serviceStub::getCodeRequestState() const {
    return _CodeRequestStateProperty.getCodeRequestState();
}

void Lcm_dbus_fi_serviceStub::sendActiveStartUpSyncPointsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ActiveStartUpSyncPointsUpdate payload(_ActiveStartUpSyncPointsProperty);

        LOG_INFO ("-> send%s", "ActiveStartUpSyncPointsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ActiveStartUpSyncPoints", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ActiveStartUpSyncPointsUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onActiveStartUpSyncPointsGet(const ::boost::shared_ptr< ActiveStartUpSyncPointsGet >& activeStartUpSyncPoints) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ActiveStartUpSyncPointsGet", activeStartUpSyncPoints->getAct());
    sendActiveStartUpSyncPointsGetUpdate(_ActiveStartUpSyncPointsProperty.getActiveStartUpSyncPoints(), activeStartUpSyncPoints->getAct());
}

void Lcm_dbus_fi_serviceStub::sendActiveStartUpSyncPointsGetUpdate(const ::std::vector< ::std::string >& activeStartUpSyncPoints, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ActiveStartUpSyncPointsGet payload(activeStartUpSyncPoints);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ActiveStartUpSyncPointsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setActiveStartUpSyncPoints(const ::std::vector< ::std::string >& activeStartUpSyncPoints) {
    if(activeStartUpSyncPoints!=_ActiveStartUpSyncPointsProperty.getActiveStartUpSyncPoints()) {
        _ActiveStartUpSyncPointsProperty.setActiveStartUpSyncPoints(activeStartUpSyncPoints);
        sendActiveStartUpSyncPointsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Lcm_dbus_fi_serviceStub::getActiveStartUpSyncPoints() const {
    return _ActiveStartUpSyncPointsProperty.getActiveStartUpSyncPoints();
}

::std::vector< ::std::string >& Lcm_dbus_fi_serviceStub::getActiveStartUpSyncPointsMutable() {
    return _ActiveStartUpSyncPointsProperty.getActiveStartUpSyncPointsMutable();
}

void Lcm_dbus_fi_serviceStub::sendCvmEventUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CvmEventUpdate payload(_CvmEventProperty);

        LOG_INFO ("-> send%s", "CvmEventUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CvmEvent", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CvmEventUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onCvmEventGet(const ::boost::shared_ptr< CvmEventGet >& cvmEvent) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CvmEventGet", cvmEvent->getAct());
    sendCvmEventGetUpdate(_CvmEventProperty.getCvmEvent(), cvmEvent->getAct());
}

void Lcm_dbus_fi_serviceStub::sendCvmEventGetUpdate(T_SPM_e32_CVM_EVENT cvmEvent, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CvmEventGet payload(cvmEvent);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CvmEventGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setCvmEvent(T_SPM_e32_CVM_EVENT cvmEvent) {
    if(cvmEvent!=_CvmEventProperty.getCvmEvent()) {
        _CvmEventProperty.setCvmEvent(cvmEvent);
        sendCvmEventUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_CVM_EVENT Lcm_dbus_fi_serviceStub::getCvmEvent() const {
    return _CvmEventProperty.getCvmEvent();
}

void Lcm_dbus_fi_serviceStub::sendUBatSenseUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UBatSenseUpdate payload(_UBatSenseProperty);

        LOG_INFO ("-> send%s", "UBatSenseUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UBatSense", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UBatSenseUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onUBatSenseGet(const ::boost::shared_ptr< UBatSenseGet >& uBatSense) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UBatSenseGet", uBatSense->getAct());
    sendUBatSenseGetUpdate(_UBatSenseProperty.getUBatSense(), uBatSense->getAct());
}

void Lcm_dbus_fi_serviceStub::sendUBatSenseGetUpdate(uint16 uBatSense, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UBatSenseGet payload(uBatSense);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UBatSenseGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setUBatSense(uint16 uBatSense) {
    if(uBatSense!=_UBatSenseProperty.getUBatSense()) {
        _UBatSenseProperty.setUBatSense(uBatSense);
        sendUBatSenseUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Lcm_dbus_fi_serviceStub::getUBatSense() const {
    return _UBatSenseProperty.getUBatSense();
}

void Lcm_dbus_fi_serviceStub::sendCoproStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CoproStateUpdate payload(_CoproStateProperty);

        LOG_INFO ("-> send%s", "CoproStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CoproState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CoproStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onCoproStateGet(const ::boost::shared_ptr< CoproStateGet >& coproState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CoproStateGet", coproState->getAct());
    sendCoproStateGetUpdate(_CoproStateProperty.getCoproState(), coproState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendCoproStateGetUpdate(T_SPM_e32_PROCESSOR_STATE coproState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CoproStateGet payload(coproState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CoproStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setCoproState(T_SPM_e32_PROCESSOR_STATE coproState) {
    if(coproState!=_CoproStateProperty.getCoproState()) {
        _CoproStateProperty.setCoproState(coproState);
        sendCoproStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_PROCESSOR_STATE Lcm_dbus_fi_serviceStub::getCoproState() const {
    return _CoproStateProperty.getCoproState();
}

void Lcm_dbus_fi_serviceStub::sendDevicePowerOnTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DevicePowerOnTimeUpdate payload(_DevicePowerOnTimeProperty);

        LOG_INFO ("-> send%s", "DevicePowerOnTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DevicePowerOnTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DevicePowerOnTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDevicePowerOnTimeGet(const ::boost::shared_ptr< DevicePowerOnTimeGet >& devicePowerOnTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DevicePowerOnTimeGet", devicePowerOnTime->getAct());
    sendDevicePowerOnTimeGetUpdate(_DevicePowerOnTimeProperty.getDevicePowerOnTime(), devicePowerOnTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDevicePowerOnTimeGetUpdate(uint32 devicePowerOnTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DevicePowerOnTimeGet payload(devicePowerOnTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DevicePowerOnTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDevicePowerOnTime(uint32 devicePowerOnTime) {
    if(devicePowerOnTime!=_DevicePowerOnTimeProperty.getDevicePowerOnTime()) {
        _DevicePowerOnTimeProperty.setDevicePowerOnTime(devicePowerOnTime);
        sendDevicePowerOnTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getDevicePowerOnTime() const {
    return _DevicePowerOnTimeProperty.getDevicePowerOnTime();
}

void Lcm_dbus_fi_serviceStub::sendLastSystemRuntimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LastSystemRuntimeUpdate payload(_LastSystemRuntimeProperty);

        LOG_INFO ("-> send%s", "LastSystemRuntimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("LastSystemRuntime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LastSystemRuntimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onLastSystemRuntimeGet(const ::boost::shared_ptr< LastSystemRuntimeGet >& lastSystemRuntime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LastSystemRuntimeGet", lastSystemRuntime->getAct());
    sendLastSystemRuntimeGetUpdate(_LastSystemRuntimeProperty.getLastSystemRuntime(), lastSystemRuntime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendLastSystemRuntimeGetUpdate(uint32 lastSystemRuntime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LastSystemRuntimeGet payload(lastSystemRuntime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LastSystemRuntimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setLastSystemRuntime(uint32 lastSystemRuntime) {
    if(lastSystemRuntime!=_LastSystemRuntimeProperty.getLastSystemRuntime()) {
        _LastSystemRuntimeProperty.setLastSystemRuntime(lastSystemRuntime);
        sendLastSystemRuntimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getLastSystemRuntime() const {
    return _LastSystemRuntimeProperty.getLastSystemRuntime();
}

void Lcm_dbus_fi_serviceStub::sendCurrentSystemRuntimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentSystemRuntimeUpdate payload(_CurrentSystemRuntimeProperty);

        LOG_INFO ("-> send%s", "CurrentSystemRuntimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CurrentSystemRuntime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentSystemRuntimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onCurrentSystemRuntimeGet(const ::boost::shared_ptr< CurrentSystemRuntimeGet >& currentSystemRuntime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentSystemRuntimeGet", currentSystemRuntime->getAct());
    sendCurrentSystemRuntimeGetUpdate(_CurrentSystemRuntimeProperty.getCurrentSystemRuntime(), currentSystemRuntime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendCurrentSystemRuntimeGetUpdate(uint32 currentSystemRuntime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentSystemRuntimeGet payload(currentSystemRuntime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentSystemRuntimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setCurrentSystemRuntime(uint32 currentSystemRuntime) {
    if(currentSystemRuntime!=_CurrentSystemRuntimeProperty.getCurrentSystemRuntime()) {
        _CurrentSystemRuntimeProperty.setCurrentSystemRuntime(currentSystemRuntime);
        sendCurrentSystemRuntimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getCurrentSystemRuntime() const {
    return _CurrentSystemRuntimeProperty.getCurrentSystemRuntime();
}

void Lcm_dbus_fi_serviceStub::sendResetListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ResetListUpdate payload(_ResetListProperty);

        LOG_INFO ("-> send%s", "ResetListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ResetList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ResetListUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onResetListGet(const ::boost::shared_ptr< ResetListGet >& resetList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ResetListGet", resetList->getAct());
    sendResetListGetUpdate(_ResetListProperty.getResetList(), resetList->getAct());
}

void Lcm_dbus_fi_serviceStub::sendResetListGetUpdate(const TResetList& resetList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ResetListGet payload(resetList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ResetListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setResetList(const TResetList& resetList) {
    if(resetList!=_ResetListProperty.getResetList()) {
        _ResetListProperty.setResetList(resetList);
        sendResetListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TResetList& Lcm_dbus_fi_serviceStub::getResetList() const {
    return _ResetListProperty.getResetList();
}

TResetList& Lcm_dbus_fi_serviceStub::getResetListMutable() {
    return _ResetListProperty.getResetListMutable();
}

void Lcm_dbus_fi_serviceStub::sendResetCounterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ResetCounterUpdate payload(_ResetCounterProperty);

        LOG_INFO ("-> send%s", "ResetCounterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ResetCounter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ResetCounterUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onResetCounterGet(const ::boost::shared_ptr< ResetCounterGet >& resetCounter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ResetCounterGet", resetCounter->getAct());
    sendResetCounterGetUpdate(_ResetCounterProperty.getResetCounter(), resetCounter->getAct());
}

void Lcm_dbus_fi_serviceStub::sendResetCounterGetUpdate(const TResetCounter& resetCounter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ResetCounterGet payload(resetCounter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ResetCounterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setResetCounter(const TResetCounter& resetCounter) {
    if(resetCounter!=_ResetCounterProperty.getResetCounter()) {
        _ResetCounterProperty.setResetCounter(resetCounter);
        sendResetCounterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TResetCounter& Lcm_dbus_fi_serviceStub::getResetCounter() const {
    return _ResetCounterProperty.getResetCounter();
}

TResetCounter& Lcm_dbus_fi_serviceStub::getResetCounterMutable() {
    return _ResetCounterProperty.getResetCounterMutable();
}

void Lcm_dbus_fi_serviceStub::sendTransportModeListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TransportModeListUpdate payload(_TransportModeListProperty);

        LOG_INFO ("-> send%s", "TransportModeListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TransportModeList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TransportModeListUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onTransportModeListGet(const ::boost::shared_ptr< TransportModeListGet >& transportModeList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TransportModeListGet", transportModeList->getAct());
    sendTransportModeListGetUpdate(_TransportModeListProperty.getTransportModeList(), transportModeList->getAct());
}

void Lcm_dbus_fi_serviceStub::sendTransportModeListGetUpdate(const T_SPM_TransPortModeList& transportModeList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TransportModeListGet payload(transportModeList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TransportModeListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setTransportModeList(const T_SPM_TransPortModeList& transportModeList) {
    if(transportModeList!=_TransportModeListProperty.getTransportModeList()) {
        _TransportModeListProperty.setTransportModeList(transportModeList);
        sendTransportModeListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_TransPortModeList& Lcm_dbus_fi_serviceStub::getTransportModeList() const {
    return _TransportModeListProperty.getTransportModeList();
}

T_SPM_TransPortModeList& Lcm_dbus_fi_serviceStub::getTransportModeListMutable() {
    return _TransportModeListProperty.getTransportModeListMutable();
}

void Lcm_dbus_fi_serviceStub::sendResetHistoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ResetHistoryUpdate payload(_ResetHistoryProperty);

        LOG_INFO ("-> send%s", "ResetHistoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ResetHistory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ResetHistoryUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onResetHistoryGet(const ::boost::shared_ptr< ResetHistoryGet >& resetHistory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ResetHistoryGet", resetHistory->getAct());
    sendResetHistoryGetUpdate(_ResetHistoryProperty.getResetHistory(), resetHistory->getAct());
}

void Lcm_dbus_fi_serviceStub::sendResetHistoryGetUpdate(const ::std::vector< T_ResetElement >& resetHistory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ResetHistoryGet payload(resetHistory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ResetHistoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setResetHistory(const ::std::vector< T_ResetElement >& resetHistory) {
    if(resetHistory!=_ResetHistoryProperty.getResetHistory()) {
        _ResetHistoryProperty.setResetHistory(resetHistory);
        sendResetHistoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_ResetElement >& Lcm_dbus_fi_serviceStub::getResetHistory() const {
    return _ResetHistoryProperty.getResetHistory();
}

::std::vector< T_ResetElement >& Lcm_dbus_fi_serviceStub::getResetHistoryMutable() {
    return _ResetHistoryProperty.getResetHistoryMutable();
}

void Lcm_dbus_fi_serviceStub::sendWakeupHistoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WakeupHistoryUpdate payload(_WakeupHistoryProperty);

        LOG_INFO ("-> send%s", "WakeupHistoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WakeupHistory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WakeupHistoryUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onWakeupHistoryGet(const ::boost::shared_ptr< WakeupHistoryGet >& wakeupHistory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WakeupHistoryGet", wakeupHistory->getAct());
    sendWakeupHistoryGetUpdate(_WakeupHistoryProperty.getWakeupHistory(), wakeupHistory->getAct());
}

void Lcm_dbus_fi_serviceStub::sendWakeupHistoryGetUpdate(const ::std::vector< T_WakeupElement >& wakeupHistory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WakeupHistoryGet payload(wakeupHistory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WakeupHistoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setWakeupHistory(const ::std::vector< T_WakeupElement >& wakeupHistory) {
    if(wakeupHistory!=_WakeupHistoryProperty.getWakeupHistory()) {
        _WakeupHistoryProperty.setWakeupHistory(wakeupHistory);
        sendWakeupHistoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_WakeupElement >& Lcm_dbus_fi_serviceStub::getWakeupHistory() const {
    return _WakeupHistoryProperty.getWakeupHistory();
}

::std::vector< T_WakeupElement >& Lcm_dbus_fi_serviceStub::getWakeupHistoryMutable() {
    return _WakeupHistoryProperty.getWakeupHistoryMutable();
}

void Lcm_dbus_fi_serviceStub::sendStateHistoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StateHistoryUpdate payload(_StateHistoryProperty);

        LOG_INFO ("-> send%s", "StateHistoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StateHistory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StateHistoryUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onStateHistoryGet(const ::boost::shared_ptr< StateHistoryGet >& stateHistory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StateHistoryGet", stateHistory->getAct());
    sendStateHistoryGetUpdate(_StateHistoryProperty.getStateHistory(), stateHistory->getAct());
}

void Lcm_dbus_fi_serviceStub::sendStateHistoryGetUpdate(const ::std::vector< T_StateChangeElement >& stateHistory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StateHistoryGet payload(stateHistory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StateHistoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setStateHistory(const ::std::vector< T_StateChangeElement >& stateHistory) {
    if(stateHistory!=_StateHistoryProperty.getStateHistory()) {
        _StateHistoryProperty.setStateHistory(stateHistory);
        sendStateHistoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getStateHistory() const {
    return _StateHistoryProperty.getStateHistory();
}

::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getStateHistoryMutable() {
    return _StateHistoryProperty.getStateHistoryMutable();
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory01Update() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory01Update payload(_ErrStateHistory01Property);

        LOG_INFO ("-> send%s", "ErrStateHistory01Update");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ErrStateHistory01", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ErrStateHistory01Update");
    }
}

void Lcm_dbus_fi_serviceStub::onErrStateHistory01Get(const ::boost::shared_ptr< ErrStateHistory01Get >& errStateHistory01) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ErrStateHistory01Get", errStateHistory01->getAct());
    sendErrStateHistory01GetUpdate(_ErrStateHistory01Property.getErrStateHistory01(), errStateHistory01->getAct());
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory01GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory01, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ErrStateHistory01Get payload(errStateHistory01);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ErrStateHistory01GetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setErrStateHistory01(const ::std::vector< T_StateChangeElement >& errStateHistory01) {
    if(errStateHistory01!=_ErrStateHistory01Property.getErrStateHistory01()) {
        _ErrStateHistory01Property.setErrStateHistory01(errStateHistory01);
        sendErrStateHistory01Update();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory01() const {
    return _ErrStateHistory01Property.getErrStateHistory01();
}

::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory01Mutable() {
    return _ErrStateHistory01Property.getErrStateHistory01Mutable();
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory02Update() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory02Update payload(_ErrStateHistory02Property);

        LOG_INFO ("-> send%s", "ErrStateHistory02Update");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ErrStateHistory02", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ErrStateHistory02Update");
    }
}

void Lcm_dbus_fi_serviceStub::onErrStateHistory02Get(const ::boost::shared_ptr< ErrStateHistory02Get >& errStateHistory02) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ErrStateHistory02Get", errStateHistory02->getAct());
    sendErrStateHistory02GetUpdate(_ErrStateHistory02Property.getErrStateHistory02(), errStateHistory02->getAct());
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory02GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory02, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ErrStateHistory02Get payload(errStateHistory02);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ErrStateHistory02GetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setErrStateHistory02(const ::std::vector< T_StateChangeElement >& errStateHistory02) {
    if(errStateHistory02!=_ErrStateHistory02Property.getErrStateHistory02()) {
        _ErrStateHistory02Property.setErrStateHistory02(errStateHistory02);
        sendErrStateHistory02Update();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory02() const {
    return _ErrStateHistory02Property.getErrStateHistory02();
}

::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory02Mutable() {
    return _ErrStateHistory02Property.getErrStateHistory02Mutable();
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory03Update() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory03Update payload(_ErrStateHistory03Property);

        LOG_INFO ("-> send%s", "ErrStateHistory03Update");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ErrStateHistory03", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ErrStateHistory03Update");
    }
}

void Lcm_dbus_fi_serviceStub::onErrStateHistory03Get(const ::boost::shared_ptr< ErrStateHistory03Get >& errStateHistory03) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ErrStateHistory03Get", errStateHistory03->getAct());
    sendErrStateHistory03GetUpdate(_ErrStateHistory03Property.getErrStateHistory03(), errStateHistory03->getAct());
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory03GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory03, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ErrStateHistory03Get payload(errStateHistory03);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ErrStateHistory03GetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setErrStateHistory03(const ::std::vector< T_StateChangeElement >& errStateHistory03) {
    if(errStateHistory03!=_ErrStateHistory03Property.getErrStateHistory03()) {
        _ErrStateHistory03Property.setErrStateHistory03(errStateHistory03);
        sendErrStateHistory03Update();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory03() const {
    return _ErrStateHistory03Property.getErrStateHistory03();
}

::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory03Mutable() {
    return _ErrStateHistory03Property.getErrStateHistory03Mutable();
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory04Update() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory04Update payload(_ErrStateHistory04Property);

        LOG_INFO ("-> send%s", "ErrStateHistory04Update");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ErrStateHistory04", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ErrStateHistory04Update");
    }
}

void Lcm_dbus_fi_serviceStub::onErrStateHistory04Get(const ::boost::shared_ptr< ErrStateHistory04Get >& errStateHistory04) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ErrStateHistory04Get", errStateHistory04->getAct());
    sendErrStateHistory04GetUpdate(_ErrStateHistory04Property.getErrStateHistory04(), errStateHistory04->getAct());
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory04GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory04, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ErrStateHistory04Get payload(errStateHistory04);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ErrStateHistory04GetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setErrStateHistory04(const ::std::vector< T_StateChangeElement >& errStateHistory04) {
    if(errStateHistory04!=_ErrStateHistory04Property.getErrStateHistory04()) {
        _ErrStateHistory04Property.setErrStateHistory04(errStateHistory04);
        sendErrStateHistory04Update();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory04() const {
    return _ErrStateHistory04Property.getErrStateHistory04();
}

::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory04Mutable() {
    return _ErrStateHistory04Property.getErrStateHistory04Mutable();
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory05Update() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory05Update payload(_ErrStateHistory05Property);

        LOG_INFO ("-> send%s", "ErrStateHistory05Update");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ErrStateHistory05", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ErrStateHistory05Update");
    }
}

void Lcm_dbus_fi_serviceStub::onErrStateHistory05Get(const ::boost::shared_ptr< ErrStateHistory05Get >& errStateHistory05) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ErrStateHistory05Get", errStateHistory05->getAct());
    sendErrStateHistory05GetUpdate(_ErrStateHistory05Property.getErrStateHistory05(), errStateHistory05->getAct());
}

void Lcm_dbus_fi_serviceStub::sendErrStateHistory05GetUpdate(const ::std::vector< T_StateChangeElement >& errStateHistory05, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ErrStateHistory05Get payload(errStateHistory05);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ErrStateHistory05GetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setErrStateHistory05(const ::std::vector< T_StateChangeElement >& errStateHistory05) {
    if(errStateHistory05!=_ErrStateHistory05Property.getErrStateHistory05()) {
        _ErrStateHistory05Property.setErrStateHistory05(errStateHistory05);
        sendErrStateHistory05Update();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory05() const {
    return _ErrStateHistory05Property.getErrStateHistory05();
}

::std::vector< T_StateChangeElement >& Lcm_dbus_fi_serviceStub::getErrStateHistory05Mutable() {
    return _ErrStateHistory05Property.getErrStateHistory05Mutable();
}

void Lcm_dbus_fi_serviceStub::sendSwitchOnHistoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SwitchOnHistoryUpdate payload(_SwitchOnHistoryProperty);

        LOG_INFO ("-> send%s", "SwitchOnHistoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SwitchOnHistory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SwitchOnHistoryUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSwitchOnHistoryGet(const ::boost::shared_ptr< SwitchOnHistoryGet >& switchOnHistory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SwitchOnHistoryGet", switchOnHistory->getAct());
    sendSwitchOnHistoryGetUpdate(_SwitchOnHistoryProperty.getSwitchOnHistory(), switchOnHistory->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSwitchOnHistoryGetUpdate(const ::std::vector< T_SwitchOnElement >& switchOnHistory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SwitchOnHistoryGet payload(switchOnHistory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SwitchOnHistoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSwitchOnHistory(const ::std::vector< T_SwitchOnElement >& switchOnHistory) {
    if(switchOnHistory!=_SwitchOnHistoryProperty.getSwitchOnHistory()) {
        _SwitchOnHistoryProperty.setSwitchOnHistory(switchOnHistory);
        sendSwitchOnHistoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_SwitchOnElement >& Lcm_dbus_fi_serviceStub::getSwitchOnHistory() const {
    return _SwitchOnHistoryProperty.getSwitchOnHistory();
}

::std::vector< T_SwitchOnElement >& Lcm_dbus_fi_serviceStub::getSwitchOnHistoryMutable() {
    return _SwitchOnHistoryProperty.getSwitchOnHistoryMutable();
}

void Lcm_dbus_fi_serviceStub::sendDeviceOnCounterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceOnCounterUpdate payload(_DeviceOnCounterProperty);

        LOG_INFO ("-> send%s", "DeviceOnCounterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DeviceOnCounter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceOnCounterUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDeviceOnCounterGet(const ::boost::shared_ptr< DeviceOnCounterGet >& deviceOnCounter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceOnCounterGet", deviceOnCounter->getAct());
    sendDeviceOnCounterGetUpdate(_DeviceOnCounterProperty.getDeviceOnCounter(), deviceOnCounter->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDeviceOnCounterGetUpdate(const TDeviceOnCounter& deviceOnCounter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceOnCounterGet payload(deviceOnCounter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceOnCounterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDeviceOnCounter(const TDeviceOnCounter& deviceOnCounter) {
    if(deviceOnCounter!=_DeviceOnCounterProperty.getDeviceOnCounter()) {
        _DeviceOnCounterProperty.setDeviceOnCounter(deviceOnCounter);
        sendDeviceOnCounterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TDeviceOnCounter& Lcm_dbus_fi_serviceStub::getDeviceOnCounter() const {
    return _DeviceOnCounterProperty.getDeviceOnCounter();
}

TDeviceOnCounter& Lcm_dbus_fi_serviceStub::getDeviceOnCounterMutable() {
    return _DeviceOnCounterProperty.getDeviceOnCounterMutable();
}

void Lcm_dbus_fi_serviceStub::sendVoltageEventCounterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VoltageEventCounterUpdate payload(_VoltageEventCounterProperty);

        LOG_INFO ("-> send%s", "VoltageEventCounterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VoltageEventCounter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VoltageEventCounterUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onVoltageEventCounterGet(const ::boost::shared_ptr< VoltageEventCounterGet >& voltageEventCounter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoltageEventCounterGet", voltageEventCounter->getAct());
    sendVoltageEventCounterGetUpdate(_VoltageEventCounterProperty.getVoltageEventCounter(), voltageEventCounter->getAct());
}

void Lcm_dbus_fi_serviceStub::sendVoltageEventCounterGetUpdate(const T_SPM_VoltageEventCounter& voltageEventCounter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VoltageEventCounterGet payload(voltageEventCounter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoltageEventCounterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setVoltageEventCounter(const T_SPM_VoltageEventCounter& voltageEventCounter) {
    if(voltageEventCounter!=_VoltageEventCounterProperty.getVoltageEventCounter()) {
        _VoltageEventCounterProperty.setVoltageEventCounter(voltageEventCounter);
        sendVoltageEventCounterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_VoltageEventCounter& Lcm_dbus_fi_serviceStub::getVoltageEventCounter() const {
    return _VoltageEventCounterProperty.getVoltageEventCounter();
}

T_SPM_VoltageEventCounter& Lcm_dbus_fi_serviceStub::getVoltageEventCounterMutable() {
    return _VoltageEventCounterProperty.getVoltageEventCounterMutable();
}

void Lcm_dbus_fi_serviceStub::sendVoltageRangeHistogramUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VoltageRangeHistogramUpdate payload(_VoltageRangeHistogramProperty);

        LOG_INFO ("-> send%s", "VoltageRangeHistogramUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VoltageRangeHistogram", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VoltageRangeHistogramUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onVoltageRangeHistogramGet(const ::boost::shared_ptr< VoltageRangeHistogramGet >& voltageRangeHistogram) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VoltageRangeHistogramGet", voltageRangeHistogram->getAct());
    sendVoltageRangeHistogramGetUpdate(_VoltageRangeHistogramProperty.getVoltageRangeHistogram(), voltageRangeHistogram->getAct());
}

void Lcm_dbus_fi_serviceStub::sendVoltageRangeHistogramGetUpdate(const ::std::vector< T_SPM_VoltageRange >& voltageRangeHistogram, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VoltageRangeHistogramGet payload(voltageRangeHistogram);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VoltageRangeHistogramGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setVoltageRangeHistogram(const ::std::vector< T_SPM_VoltageRange >& voltageRangeHistogram) {
    if(voltageRangeHistogram!=_VoltageRangeHistogramProperty.getVoltageRangeHistogram()) {
        _VoltageRangeHistogramProperty.setVoltageRangeHistogram(voltageRangeHistogram);
        sendVoltageRangeHistogramUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< T_SPM_VoltageRange >& Lcm_dbus_fi_serviceStub::getVoltageRangeHistogram() const {
    return _VoltageRangeHistogramProperty.getVoltageRangeHistogram();
}

::std::vector< T_SPM_VoltageRange >& Lcm_dbus_fi_serviceStub::getVoltageRangeHistogramMutable() {
    return _VoltageRangeHistogramProperty.getVoltageRangeHistogramMutable();
}

void Lcm_dbus_fi_serviceStub::sendCpuUsageStatisticUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CpuUsageStatisticUpdate payload(_CpuUsageStatisticProperty);

        LOG_INFO ("-> send%s", "CpuUsageStatisticUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CpuUsageStatistic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CpuUsageStatisticUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onCpuUsageStatisticGet(const ::boost::shared_ptr< CpuUsageStatisticGet >& cpuUsageStatistic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CpuUsageStatisticGet", cpuUsageStatistic->getAct());
    sendCpuUsageStatisticGetUpdate(_CpuUsageStatisticProperty.getCpuUsageStatistic(), cpuUsageStatistic->getAct());
}

void Lcm_dbus_fi_serviceStub::sendCpuUsageStatisticGetUpdate(const T_SPM_SystemStatisticsData& cpuUsageStatistic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CpuUsageStatisticGet payload(cpuUsageStatistic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CpuUsageStatisticGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setCpuUsageStatistic(const T_SPM_SystemStatisticsData& cpuUsageStatistic) {
    if(cpuUsageStatistic!=_CpuUsageStatisticProperty.getCpuUsageStatistic()) {
        _CpuUsageStatisticProperty.setCpuUsageStatistic(cpuUsageStatistic);
        sendCpuUsageStatisticUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_SystemStatisticsData& Lcm_dbus_fi_serviceStub::getCpuUsageStatistic() const {
    return _CpuUsageStatisticProperty.getCpuUsageStatistic();
}

T_SPM_SystemStatisticsData& Lcm_dbus_fi_serviceStub::getCpuUsageStatisticMutable() {
    return _CpuUsageStatisticProperty.getCpuUsageStatisticMutable();
}

void Lcm_dbus_fi_serviceStub::sendRamUsageStatisticUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RamUsageStatisticUpdate payload(_RamUsageStatisticProperty);

        LOG_INFO ("-> send%s", "RamUsageStatisticUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RamUsageStatistic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RamUsageStatisticUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onRamUsageStatisticGet(const ::boost::shared_ptr< RamUsageStatisticGet >& ramUsageStatistic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RamUsageStatisticGet", ramUsageStatistic->getAct());
    sendRamUsageStatisticGetUpdate(_RamUsageStatisticProperty.getRamUsageStatistic(), ramUsageStatistic->getAct());
}

void Lcm_dbus_fi_serviceStub::sendRamUsageStatisticGetUpdate(const T_SPM_SystemStatisticsData& ramUsageStatistic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RamUsageStatisticGet payload(ramUsageStatistic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RamUsageStatisticGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setRamUsageStatistic(const T_SPM_SystemStatisticsData& ramUsageStatistic) {
    if(ramUsageStatistic!=_RamUsageStatisticProperty.getRamUsageStatistic()) {
        _RamUsageStatisticProperty.setRamUsageStatistic(ramUsageStatistic);
        sendRamUsageStatisticUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_SystemStatisticsData& Lcm_dbus_fi_serviceStub::getRamUsageStatistic() const {
    return _RamUsageStatisticProperty.getRamUsageStatistic();
}

T_SPM_SystemStatisticsData& Lcm_dbus_fi_serviceStub::getRamUsageStatisticMutable() {
    return _RamUsageStatisticProperty.getRamUsageStatisticMutable();
}

void Lcm_dbus_fi_serviceStub::sendStartupTimeStatisticUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupTimeStatisticUpdate payload(_StartupTimeStatisticProperty);

        LOG_INFO ("-> send%s", "StartupTimeStatisticUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupTimeStatistic", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupTimeStatisticUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onStartupTimeStatisticGet(const ::boost::shared_ptr< StartupTimeStatisticGet >& startupTimeStatistic) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupTimeStatisticGet", startupTimeStatistic->getAct());
    sendStartupTimeStatisticGetUpdate(_StartupTimeStatisticProperty.getStartupTimeStatistic(), startupTimeStatistic->getAct());
}

void Lcm_dbus_fi_serviceStub::sendStartupTimeStatisticGetUpdate(const T_SPM_SystemStatisticsData& startupTimeStatistic, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupTimeStatisticGet payload(startupTimeStatistic);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupTimeStatisticGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setStartupTimeStatistic(const T_SPM_SystemStatisticsData& startupTimeStatistic) {
    if(startupTimeStatistic!=_StartupTimeStatisticProperty.getStartupTimeStatistic()) {
        _StartupTimeStatisticProperty.setStartupTimeStatistic(startupTimeStatistic);
        sendStartupTimeStatisticUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_SystemStatisticsData& Lcm_dbus_fi_serviceStub::getStartupTimeStatistic() const {
    return _StartupTimeStatisticProperty.getStartupTimeStatistic();
}

T_SPM_SystemStatisticsData& Lcm_dbus_fi_serviceStub::getStartupTimeStatisticMutable() {
    return _StartupTimeStatisticProperty.getStartupTimeStatisticMutable();
}

void Lcm_dbus_fi_serviceStub::sendRunlevelStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RunlevelStateUpdate payload(_RunlevelStateProperty);

        LOG_INFO ("-> send%s", "RunlevelStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RunlevelState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RunlevelStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onRunlevelStateGet(const ::boost::shared_ptr< RunlevelStateGet >& runlevelState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RunlevelStateGet", runlevelState->getAct());
    sendRunlevelStateGetUpdate(_RunlevelStateProperty.getRunlevelState(), runlevelState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendRunlevelStateGetUpdate(T_SPM_e32_RUNLEVEL runlevelState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RunlevelStateGet payload(runlevelState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RunlevelStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setRunlevelState(T_SPM_e32_RUNLEVEL runlevelState) {
    if(runlevelState!=_RunlevelStateProperty.getRunlevelState()) {
        _RunlevelStateProperty.setRunlevelState(runlevelState);
        sendRunlevelStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_RUNLEVEL Lcm_dbus_fi_serviceStub::getRunlevelState() const {
    return _RunlevelStateProperty.getRunlevelState();
}

void Lcm_dbus_fi_serviceStub::sendRestartUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RestartUpdate payload(_RestartProperty);

        LOG_INFO ("-> send%s", "RestartUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Restart", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RestartUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onRestartGet(const ::boost::shared_ptr< RestartGet >& restart) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RestartGet", restart->getAct());
    sendRestartGetUpdate(_RestartProperty.getRestart(), restart->getAct());
}

void Lcm_dbus_fi_serviceStub::sendRestartGetUpdate(T_SPM_e32_RESTART_TYPE restart, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RestartGet payload(restart);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RestartGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setRestart(T_SPM_e32_RESTART_TYPE restart) {
    if(restart!=_RestartProperty.getRestart()) {
        _RestartProperty.setRestart(restart);
        sendRestartUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_RESTART_TYPE Lcm_dbus_fi_serviceStub::getRestart() const {
    return _RestartProperty.getRestart();
}

void Lcm_dbus_fi_serviceStub::sendLifesignUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        LifesignUpdate payload(_LifesignProperty);

        LOG_INFO ("-> send%s", "LifesignUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Lifesign", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "LifesignUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onLifesignGet(const ::boost::shared_ptr< LifesignGet >& lifesign) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "LifesignGet", lifesign->getAct());
    sendLifesignGetUpdate(_LifesignProperty.getLifesign(), lifesign->getAct());
}

void Lcm_dbus_fi_serviceStub::sendLifesignGetUpdate(uint32 lifesign, act_t act) {
    ::asf::dbus::DBusVariant variant;
    LifesignGet payload(lifesign);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "LifesignGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setLifesign(uint32 lifesign) {
    if(lifesign!=_LifesignProperty.getLifesign()) {
        _LifesignProperty.setLifesign(lifesign);
        sendLifesignUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getLifesign() const {
    return _LifesignProperty.getLifesign();
}

void Lcm_dbus_fi_serviceStub::sendHmiStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        HmiStateUpdate payload(_HmiStateProperty);

        LOG_INFO ("-> send%s", "HmiStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("HmiState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "HmiStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onHmiStateGet(const ::boost::shared_ptr< HmiStateGet >& hmiState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "HmiStateGet", hmiState->getAct());
    sendHmiStateGetUpdate(_HmiStateProperty.getHmiState(), hmiState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendHmiStateGetUpdate(T_SPM_e32_HMI_STATE hmiState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    HmiStateGet payload(hmiState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "HmiStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setHmiState(T_SPM_e32_HMI_STATE hmiState) {
    if(hmiState!=_HmiStateProperty.getHmiState()) {
        _HmiStateProperty.setHmiState(hmiState);
        sendHmiStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_HMI_STATE Lcm_dbus_fi_serviceStub::getHmiState() const {
    return _HmiStateProperty.getHmiState();
}

void Lcm_dbus_fi_serviceStub::sendSystemPowerBehaviourUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SystemPowerBehaviourUpdate payload(_SystemPowerBehaviourProperty);

        LOG_INFO ("-> send%s", "SystemPowerBehaviourUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SystemPowerBehaviour", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SystemPowerBehaviourUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSystemPowerBehaviourGet(const ::boost::shared_ptr< SystemPowerBehaviourGet >& systemPowerBehaviour) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SystemPowerBehaviourGet", systemPowerBehaviour->getAct());
    sendSystemPowerBehaviourGetUpdate(_SystemPowerBehaviourProperty.getSystemPowerBehaviour(), systemPowerBehaviour->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSystemPowerBehaviourGetUpdate(T_SPM_e32_SYSPWR_BEHAVIOUR systemPowerBehaviour, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SystemPowerBehaviourGet payload(systemPowerBehaviour);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SystemPowerBehaviourGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSystemPowerBehaviour(T_SPM_e32_SYSPWR_BEHAVIOUR systemPowerBehaviour) {
    if(systemPowerBehaviour!=_SystemPowerBehaviourProperty.getSystemPowerBehaviour()) {
        _SystemPowerBehaviourProperty.setSystemPowerBehaviour(systemPowerBehaviour);
        sendSystemPowerBehaviourUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_SYSPWR_BEHAVIOUR Lcm_dbus_fi_serviceStub::getSystemPowerBehaviour() const {
    return _SystemPowerBehaviourProperty.getSystemPowerBehaviour();
}

void Lcm_dbus_fi_serviceStub::sendDimStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DimStateUpdate payload(_DimStateProperty);

        LOG_INFO ("-> send%s", "DimStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DimState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DimStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDimStateGet(const ::boost::shared_ptr< DimStateGet >& dimState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DimStateGet", dimState->getAct());
    sendDimStateGetUpdate(_DimStateProperty.getDimState(), dimState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDimStateGetUpdate(T_SPM_e32_DIM_STATE dimState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DimStateGet payload(dimState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DimStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDimState(T_SPM_e32_DIM_STATE dimState) {
    if(dimState!=_DimStateProperty.getDimState()) {
        _DimStateProperty.setDimState(dimState);
        sendDimStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_DIM_STATE Lcm_dbus_fi_serviceStub::getDimState() const {
    return _DimStateProperty.getDimState();
}

void Lcm_dbus_fi_serviceStub::sendDimmingStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DimmingStateUpdate payload(_DimmingStateProperty);

        LOG_INFO ("-> send%s", "DimmingStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DimmingState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DimmingStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDimmingStateGet(const ::boost::shared_ptr< DimmingStateGet >& dimmingState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DimmingStateGet", dimmingState->getAct());
    sendDimmingStateGetUpdate(_DimmingStateProperty.getDimmingState(), dimmingState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDimmingStateGetUpdate(const T_SPM_b32_DIM_STATE& dimmingState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DimmingStateGet payload(dimmingState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DimmingStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDimmingState(const T_SPM_b32_DIM_STATE& dimmingState) {
    if(dimmingState!=_DimmingStateProperty.getDimmingState()) {
        _DimmingStateProperty.setDimmingState(dimmingState);
        sendDimmingStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_b32_DIM_STATE& Lcm_dbus_fi_serviceStub::getDimmingState() const {
    return _DimmingStateProperty.getDimmingState();
}

T_SPM_b32_DIM_STATE& Lcm_dbus_fi_serviceStub::getDimmingStateMutable() {
    return _DimmingStateProperty.getDimmingStateMutable();
}

void Lcm_dbus_fi_serviceStub::sendBluetoothStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BluetoothStateUpdate payload(_BluetoothStateProperty);

        LOG_INFO ("-> send%s", "BluetoothStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("BluetoothState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BluetoothStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onBluetoothStateGet(const ::boost::shared_ptr< BluetoothStateGet >& bluetoothState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BluetoothStateGet", bluetoothState->getAct());
    sendBluetoothStateGetUpdate(_BluetoothStateProperty.getBluetoothState(), bluetoothState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendBluetoothStateGetUpdate(T_SPM_e32_BT_STATE bluetoothState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BluetoothStateGet payload(bluetoothState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BluetoothStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setBluetoothState(T_SPM_e32_BT_STATE bluetoothState) {
    if(bluetoothState!=_BluetoothStateProperty.getBluetoothState()) {
        _BluetoothStateProperty.setBluetoothState(bluetoothState);
        sendBluetoothStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_BT_STATE Lcm_dbus_fi_serviceStub::getBluetoothState() const {
    return _BluetoothStateProperty.getBluetoothState();
}

void Lcm_dbus_fi_serviceStub::sendAudioStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AudioStateUpdate payload(_AudioStateProperty);

        LOG_INFO ("-> send%s", "AudioStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AudioState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AudioStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onAudioStateGet(const ::boost::shared_ptr< AudioStateGet >& audioState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AudioStateGet", audioState->getAct());
    sendAudioStateGetUpdate(_AudioStateProperty.getAudioState(), audioState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendAudioStateGetUpdate(T_SPM_e32_AUDIO_STATE audioState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AudioStateGet payload(audioState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AudioStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setAudioState(T_SPM_e32_AUDIO_STATE audioState) {
    if(audioState!=_AudioStateProperty.getAudioState()) {
        _AudioStateProperty.setAudioState(audioState);
        sendAudioStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_AUDIO_STATE Lcm_dbus_fi_serviceStub::getAudioState() const {
    return _AudioStateProperty.getAudioState();
}

void Lcm_dbus_fi_serviceStub::sendSpiStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SpiStateUpdate payload(_SpiStateProperty);

        LOG_INFO ("-> send%s", "SpiStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SpiState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SpiStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSpiStateGet(const ::boost::shared_ptr< SpiStateGet >& spiState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SpiStateGet", spiState->getAct());
    sendSpiStateGetUpdate(_SpiStateProperty.getSpiState(), spiState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSpiStateGetUpdate(T_SPM_e32_SPI_STATE spiState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SpiStateGet payload(spiState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SpiStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSpiState(T_SPM_e32_SPI_STATE spiState) {
    if(spiState!=_SpiStateProperty.getSpiState()) {
        _SpiStateProperty.setSpiState(spiState);
        sendSpiStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_SPI_STATE Lcm_dbus_fi_serviceStub::getSpiState() const {
    return _SpiStateProperty.getSpiState();
}

void Lcm_dbus_fi_serviceStub::sendTunerStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TunerStateUpdate payload(_TunerStateProperty);

        LOG_INFO ("-> send%s", "TunerStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TunerState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TunerStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onTunerStateGet(const ::boost::shared_ptr< TunerStateGet >& tunerState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TunerStateGet", tunerState->getAct());
    sendTunerStateGetUpdate(_TunerStateProperty.getTunerState(), tunerState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendTunerStateGetUpdate(T_SPM_e32_TUNER_STATE tunerState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TunerStateGet payload(tunerState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TunerStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setTunerState(T_SPM_e32_TUNER_STATE tunerState) {
    if(tunerState!=_TunerStateProperty.getTunerState()) {
        _TunerStateProperty.setTunerState(tunerState);
        sendTunerStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_TUNER_STATE Lcm_dbus_fi_serviceStub::getTunerState() const {
    return _TunerStateProperty.getTunerState();
}

void Lcm_dbus_fi_serviceStub::sendWifiStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WifiStateUpdate payload(_WifiStateProperty);

        LOG_INFO ("-> send%s", "WifiStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WifiState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WifiStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onWifiStateGet(const ::boost::shared_ptr< WifiStateGet >& wifiState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WifiStateGet", wifiState->getAct());
    sendWifiStateGetUpdate(_WifiStateProperty.getWifiState(), wifiState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendWifiStateGetUpdate(T_SPM_e32_WIFI_STATE wifiState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WifiStateGet payload(wifiState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WifiStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setWifiState(T_SPM_e32_WIFI_STATE wifiState) {
    if(wifiState!=_WifiStateProperty.getWifiState()) {
        _WifiStateProperty.setWifiState(wifiState);
        sendWifiStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_WIFI_STATE Lcm_dbus_fi_serviceStub::getWifiState() const {
    return _WifiStateProperty.getWifiState();
}

void Lcm_dbus_fi_serviceStub::sendOnOffReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        OnOffReasonUpdate payload(_OnOffReasonProperty);

        LOG_INFO ("-> send%s", "OnOffReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("OnOffReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "OnOffReasonUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onOnOffReasonGet(const ::boost::shared_ptr< OnOffReasonGet >& onOffReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "OnOffReasonGet", onOffReason->getAct());
    sendOnOffReasonGetUpdate(_OnOffReasonProperty.getOnOffReason(), onOffReason->getAct());
}

void Lcm_dbus_fi_serviceStub::sendOnOffReasonGetUpdate(T_SPM_e32_OnOffReason onOffReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    OnOffReasonGet payload(onOffReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "OnOffReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setOnOffReason(T_SPM_e32_OnOffReason onOffReason) {
    if(onOffReason!=_OnOffReasonProperty.getOnOffReason()) {
        _OnOffReasonProperty.setOnOffReason(onOffReason);
        sendOnOffReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_OnOffReason Lcm_dbus_fi_serviceStub::getOnOffReason() const {
    return _OnOffReasonProperty.getOnOffReason();
}

void Lcm_dbus_fi_serviceStub::sendWakeupListUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WakeupListUpdate payload(_WakeupListProperty);

        LOG_INFO ("-> send%s", "WakeupListUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WakeupList", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WakeupListUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onWakeupListGet(const ::boost::shared_ptr< WakeupListGet >& wakeupList) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WakeupListGet", wakeupList->getAct());
    sendWakeupListGetUpdate(_WakeupListProperty.getWakeupList(), wakeupList->getAct());
}

void Lcm_dbus_fi_serviceStub::sendWakeupListGetUpdate(const TWakeupList& wakeupList, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WakeupListGet payload(wakeupList);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WakeupListGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setWakeupList(const TWakeupList& wakeupList) {
    if(wakeupList!=_WakeupListProperty.getWakeupList()) {
        _WakeupListProperty.setWakeupList(wakeupList);
        sendWakeupListUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TWakeupList& Lcm_dbus_fi_serviceStub::getWakeupList() const {
    return _WakeupListProperty.getWakeupList();
}

TWakeupList& Lcm_dbus_fi_serviceStub::getWakeupListMutable() {
    return _WakeupListProperty.getWakeupListMutable();
}

void Lcm_dbus_fi_serviceStub::sendStartupFinishedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupFinishedUpdate payload(_StartupFinishedProperty);

        LOG_INFO ("-> send%s", "StartupFinishedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupFinished", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupFinishedUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onStartupFinishedGet(const ::boost::shared_ptr< StartupFinishedGet >& startupFinished) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupFinishedGet", startupFinished->getAct());
    sendStartupFinishedGetUpdate(_StartupFinishedProperty.getStartupFinished(), startupFinished->getAct());
}

void Lcm_dbus_fi_serviceStub::sendStartupFinishedGetUpdate(bool startupFinished, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupFinishedGet payload(startupFinished);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupFinishedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setStartupFinished(bool startupFinished) {
    if(startupFinished!=_StartupFinishedProperty.getStartupFinished()) {
        _StartupFinishedProperty.setStartupFinished(startupFinished);
        sendStartupFinishedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Lcm_dbus_fi_serviceStub::getStartupFinished() const {
    return _StartupFinishedProperty.getStartupFinished();
}

void Lcm_dbus_fi_serviceStub::sendSysStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SysStateUpdate payload(_SysStateProperty);

        LOG_INFO ("-> send%s", "SysStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SysState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SysStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSysStateGet(const ::boost::shared_ptr< SysStateGet >& sysState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SysStateGet", sysState->getAct());
    sendSysStateGetUpdate(_SysStateProperty.getSysState(), sysState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSysStateGetUpdate(T_SPM_e32_SYS_STATE sysState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SysStateGet payload(sysState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SysStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSysState(T_SPM_e32_SYS_STATE sysState) {
    if(sysState!=_SysStateProperty.getSysState()) {
        _SysStateProperty.setSysState(sysState);
        sendSysStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_SYS_STATE Lcm_dbus_fi_serviceStub::getSysState() const {
    return _SysStateProperty.getSysState();
}

void Lcm_dbus_fi_serviceStub::sendMostStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MostStateUpdate payload(_MostStateProperty);

        LOG_INFO ("-> send%s", "MostStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MostState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MostStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onMostStateGet(const ::boost::shared_ptr< MostStateGet >& mostState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MostStateGet", mostState->getAct());
    sendMostStateGetUpdate(_MostStateProperty.getMostState(), mostState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendMostStateGetUpdate(const TMostState& mostState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MostStateGet payload(mostState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MostStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setMostState(const TMostState& mostState) {
    if(mostState!=_MostStateProperty.getMostState()) {
        _MostStateProperty.setMostState(mostState);
        sendMostStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TMostState& Lcm_dbus_fi_serviceStub::getMostState() const {
    return _MostStateProperty.getMostState();
}

TMostState& Lcm_dbus_fi_serviceStub::getMostStateMutable() {
    return _MostStateProperty.getMostStateMutable();
}

void Lcm_dbus_fi_serviceStub::sendMostVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MostVersionUpdate payload(_MostVersionProperty);

        LOG_INFO ("-> send%s", "MostVersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MostVersion", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MostVersionUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onMostVersionGet(const ::boost::shared_ptr< MostVersionGet >& mostVersion) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MostVersionGet", mostVersion->getAct());
    sendMostVersionGetUpdate(_MostVersionProperty.getMostVersion(), mostVersion->getAct());
}

void Lcm_dbus_fi_serviceStub::sendMostVersionGetUpdate(const ::std::string& mostVersion, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MostVersionGet payload(mostVersion);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MostVersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setMostVersion(const ::std::string& mostVersion) {
    if(mostVersion!=_MostVersionProperty.getMostVersion()) {
        _MostVersionProperty.setMostVersion(mostVersion);
        sendMostVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Lcm_dbus_fi_serviceStub::getMostVersion() const {
    return _MostVersionProperty.getMostVersion();
}

::std::string& Lcm_dbus_fi_serviceStub::getMostVersionMutable() {
    return _MostVersionProperty.getMostVersionMutable();
}

void Lcm_dbus_fi_serviceStub::sendRVCStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RVCStateUpdate payload(_RVCStateProperty);

        LOG_INFO ("-> send%s", "RVCStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RVCState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RVCStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onRVCStateGet(const ::boost::shared_ptr< RVCStateGet >& rVCState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RVCStateGet", rVCState->getAct());
    sendRVCStateGetUpdate(_RVCStateProperty.getRVCState(), rVCState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendRVCStateGetUpdate(bool rVCState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RVCStateGet payload(rVCState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RVCStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setRVCState(bool rVCState) {
    if(rVCState!=_RVCStateProperty.getRVCState()) {
        _RVCStateProperty.setRVCState(rVCState);
        sendRVCStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Lcm_dbus_fi_serviceStub::getRVCState() const {
    return _RVCStateProperty.getRVCState();
}

void Lcm_dbus_fi_serviceStub::sendTriggerMostRemoteResetUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TriggerMostRemoteResetUpdate payload(_TriggerMostRemoteResetProperty);

        LOG_INFO ("-> send%s", "TriggerMostRemoteResetUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("TriggerMostRemoteReset", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TriggerMostRemoteResetUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onTriggerMostRemoteResetGet(const ::boost::shared_ptr< TriggerMostRemoteResetGet >& triggerMostRemoteReset) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TriggerMostRemoteResetGet", triggerMostRemoteReset->getAct());
    sendTriggerMostRemoteResetGetUpdate(_TriggerMostRemoteResetProperty.getTriggerMostRemoteReset(), triggerMostRemoteReset->getAct());
}

void Lcm_dbus_fi_serviceStub::sendTriggerMostRemoteResetGetUpdate(uint32 triggerMostRemoteReset, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TriggerMostRemoteResetGet payload(triggerMostRemoteReset);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TriggerMostRemoteResetGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setTriggerMostRemoteReset(uint32 triggerMostRemoteReset) {
    if(triggerMostRemoteReset!=_TriggerMostRemoteResetProperty.getTriggerMostRemoteReset()) {
        _TriggerMostRemoteResetProperty.setTriggerMostRemoteReset(triggerMostRemoteReset);
        sendTriggerMostRemoteResetUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getTriggerMostRemoteReset() const {
    return _TriggerMostRemoteResetProperty.getTriggerMostRemoteReset();
}

void Lcm_dbus_fi_serviceStub::sendPartnumberUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PartnumberUpdate payload(_PartnumberProperty);

        LOG_INFO ("-> send%s", "PartnumberUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Partnumber", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PartnumberUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onPartnumberGet(const ::boost::shared_ptr< PartnumberGet >& partnumber) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PartnumberGet", partnumber->getAct());
    sendPartnumberGetUpdate(_PartnumberProperty.getPartnumber(), partnumber->getAct());
}

void Lcm_dbus_fi_serviceStub::sendPartnumberGetUpdate(uint32 partnumber, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PartnumberGet payload(partnumber);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PartnumberGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setPartnumber(uint32 partnumber) {
    if(partnumber!=_PartnumberProperty.getPartnumber()) {
        _PartnumberProperty.setPartnumber(partnumber);
        sendPartnumberUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getPartnumber() const {
    return _PartnumberProperty.getPartnumber();
}

void Lcm_dbus_fi_serviceStub::sendPartnumbersUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PartnumbersUpdate payload(_PartnumbersProperty);

        LOG_INFO ("-> send%s", "PartnumbersUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Partnumbers", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PartnumbersUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onPartnumbersGet(const ::boost::shared_ptr< PartnumbersGet >& partnumbers) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PartnumbersGet", partnumbers->getAct());
    sendPartnumbersGetUpdate(_PartnumbersProperty.getPartnumbers(), partnumbers->getAct());
}

void Lcm_dbus_fi_serviceStub::sendPartnumbersGetUpdate(const T_SPM_PartnumberList& partnumbers, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PartnumbersGet payload(partnumbers);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PartnumbersGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setPartnumbers(const T_SPM_PartnumberList& partnumbers) {
    if(partnumbers!=_PartnumbersProperty.getPartnumbers()) {
        _PartnumbersProperty.setPartnumbers(partnumbers);
        sendPartnumbersUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_PartnumberList& Lcm_dbus_fi_serviceStub::getPartnumbers() const {
    return _PartnumbersProperty.getPartnumbers();
}

T_SPM_PartnumberList& Lcm_dbus_fi_serviceStub::getPartnumbersMutable() {
    return _PartnumbersProperty.getPartnumbersMutable();
}

void Lcm_dbus_fi_serviceStub::sendAlphacodeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AlphacodeUpdate payload(_AlphacodeProperty);

        LOG_INFO ("-> send%s", "AlphacodeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Alphacode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AlphacodeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onAlphacodeGet(const ::boost::shared_ptr< AlphacodeGet >& alphacode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AlphacodeGet", alphacode->getAct());
    sendAlphacodeGetUpdate(_AlphacodeProperty.getAlphacode(), alphacode->getAct());
}

void Lcm_dbus_fi_serviceStub::sendAlphacodeGetUpdate(const TAlphacode& alphacode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AlphacodeGet payload(alphacode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AlphacodeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setAlphacode(const TAlphacode& alphacode) {
    if(alphacode!=_AlphacodeProperty.getAlphacode()) {
        _AlphacodeProperty.setAlphacode(alphacode);
        sendAlphacodeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const TAlphacode& Lcm_dbus_fi_serviceStub::getAlphacode() const {
    return _AlphacodeProperty.getAlphacode();
}

TAlphacode& Lcm_dbus_fi_serviceStub::getAlphacodeMutable() {
    return _AlphacodeProperty.getAlphacodeMutable();
}

void Lcm_dbus_fi_serviceStub::sendAlphacodesUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AlphacodesUpdate payload(_AlphacodesProperty);

        LOG_INFO ("-> send%s", "AlphacodesUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Alphacodes", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AlphacodesUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onAlphacodesGet(const ::boost::shared_ptr< AlphacodesGet >& alphacodes) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AlphacodesGet", alphacodes->getAct());
    sendAlphacodesGetUpdate(_AlphacodesProperty.getAlphacodes(), alphacodes->getAct());
}

void Lcm_dbus_fi_serviceStub::sendAlphacodesGetUpdate(const T_SPM_AlphacodeList& alphacodes, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AlphacodesGet payload(alphacodes);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AlphacodesGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setAlphacodes(const T_SPM_AlphacodeList& alphacodes) {
    if(alphacodes!=_AlphacodesProperty.getAlphacodes()) {
        _AlphacodesProperty.setAlphacodes(alphacodes);
        sendAlphacodesUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_AlphacodeList& Lcm_dbus_fi_serviceStub::getAlphacodes() const {
    return _AlphacodesProperty.getAlphacodes();
}

T_SPM_AlphacodeList& Lcm_dbus_fi_serviceStub::getAlphacodesMutable() {
    return _AlphacodesProperty.getAlphacodesMutable();
}

void Lcm_dbus_fi_serviceStub::sendManufacturersEnableCounterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ManufacturersEnableCounterUpdate payload(_ManufacturersEnableCounterProperty);

        LOG_INFO ("-> send%s", "ManufacturersEnableCounterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ManufacturersEnableCounter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ManufacturersEnableCounterUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onManufacturersEnableCounterGet(const ::boost::shared_ptr< ManufacturersEnableCounterGet >& manufacturersEnableCounter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ManufacturersEnableCounterGet", manufacturersEnableCounter->getAct());
    sendManufacturersEnableCounterGetUpdate(_ManufacturersEnableCounterProperty.getManufacturersEnableCounter(), manufacturersEnableCounter->getAct());
}

void Lcm_dbus_fi_serviceStub::sendManufacturersEnableCounterGetUpdate(uint8 manufacturersEnableCounter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ManufacturersEnableCounterGet payload(manufacturersEnableCounter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ManufacturersEnableCounterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setManufacturersEnableCounter(uint8 manufacturersEnableCounter) {
    if(manufacturersEnableCounter!=_ManufacturersEnableCounterProperty.getManufacturersEnableCounter()) {
        _ManufacturersEnableCounterProperty.setManufacturersEnableCounter(manufacturersEnableCounter);
        sendManufacturersEnableCounterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 Lcm_dbus_fi_serviceStub::getManufacturersEnableCounter() const {
    return _ManufacturersEnableCounterProperty.getManufacturersEnableCounter();
}

void Lcm_dbus_fi_serviceStub::sendNoCalibrationStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NoCalibrationStateUpdate payload(_NoCalibrationStateProperty);

        LOG_INFO ("-> send%s", "NoCalibrationStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("NoCalibrationState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NoCalibrationStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onNoCalibrationStateGet(const ::boost::shared_ptr< NoCalibrationStateGet >& noCalibrationState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NoCalibrationStateGet", noCalibrationState->getAct());
    sendNoCalibrationStateGetUpdate(_NoCalibrationStateProperty.getNoCalibrationState(), noCalibrationState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendNoCalibrationStateGetUpdate(bool noCalibrationState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NoCalibrationStateGet payload(noCalibrationState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NoCalibrationStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setNoCalibrationState(bool noCalibrationState) {
    if(noCalibrationState!=_NoCalibrationStateProperty.getNoCalibrationState()) {
        _NoCalibrationStateProperty.setNoCalibrationState(noCalibrationState);
        sendNoCalibrationStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Lcm_dbus_fi_serviceStub::getNoCalibrationState() const {
    return _NoCalibrationStateProperty.getNoCalibrationState();
}

void Lcm_dbus_fi_serviceStub::sendSecurityCommErrorUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityCommErrorUpdate payload(_SecurityCommErrorProperty);

        LOG_INFO ("-> send%s", "SecurityCommErrorUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityCommError", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityCommErrorUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSecurityCommErrorGet(const ::boost::shared_ptr< SecurityCommErrorGet >& securityCommError) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityCommErrorGet", securityCommError->getAct());
    sendSecurityCommErrorGetUpdate(_SecurityCommErrorProperty.getSecurityCommError(), securityCommError->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSecurityCommErrorGetUpdate(uint16 securityCommError, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityCommErrorGet payload(securityCommError);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityCommErrorGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSecurityCommError(uint16 securityCommError) {
    if(securityCommError!=_SecurityCommErrorProperty.getSecurityCommError()) {
        _SecurityCommErrorProperty.setSecurityCommError(securityCommError);
        sendSecurityCommErrorUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Lcm_dbus_fi_serviceStub::getSecurityCommError() const {
    return _SecurityCommErrorProperty.getSecurityCommError();
}

void Lcm_dbus_fi_serviceStub::sendSecurityMoreThan10VinUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityMoreThan10VinUpdate payload(_SecurityMoreThan10VinProperty);

        LOG_INFO ("-> send%s", "SecurityMoreThan10VinUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityMoreThan10Vin", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityMoreThan10VinUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSecurityMoreThan10VinGet(const ::boost::shared_ptr< SecurityMoreThan10VinGet >& securityMoreThan10Vin) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityMoreThan10VinGet", securityMoreThan10Vin->getAct());
    sendSecurityMoreThan10VinGetUpdate(_SecurityMoreThan10VinProperty.getSecurityMoreThan10Vin(), securityMoreThan10Vin->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSecurityMoreThan10VinGetUpdate(uint16 securityMoreThan10Vin, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityMoreThan10VinGet payload(securityMoreThan10Vin);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityMoreThan10VinGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSecurityMoreThan10Vin(uint16 securityMoreThan10Vin) {
    if(securityMoreThan10Vin!=_SecurityMoreThan10VinProperty.getSecurityMoreThan10Vin()) {
        _SecurityMoreThan10VinProperty.setSecurityMoreThan10Vin(securityMoreThan10Vin);
        sendSecurityMoreThan10VinUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Lcm_dbus_fi_serviceStub::getSecurityMoreThan10Vin() const {
    return _SecurityMoreThan10VinProperty.getSecurityMoreThan10Vin();
}

void Lcm_dbus_fi_serviceStub::sendSecurityInvalidVinUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityInvalidVinUpdate payload(_SecurityInvalidVinProperty);

        LOG_INFO ("-> send%s", "SecurityInvalidVinUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityInvalidVin", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityInvalidVinUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSecurityInvalidVinGet(const ::boost::shared_ptr< SecurityInvalidVinGet >& securityInvalidVin) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityInvalidVinGet", securityInvalidVin->getAct());
    sendSecurityInvalidVinGetUpdate(_SecurityInvalidVinProperty.getSecurityInvalidVin(), securityInvalidVin->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSecurityInvalidVinGetUpdate(uint16 securityInvalidVin, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityInvalidVinGet payload(securityInvalidVin);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityInvalidVinGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSecurityInvalidVin(uint16 securityInvalidVin) {
    if(securityInvalidVin!=_SecurityInvalidVinProperty.getSecurityInvalidVin()) {
        _SecurityInvalidVinProperty.setSecurityInvalidVin(securityInvalidVin);
        sendSecurityInvalidVinUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Lcm_dbus_fi_serviceStub::getSecurityInvalidVin() const {
    return _SecurityInvalidVinProperty.getSecurityInvalidVin();
}

void Lcm_dbus_fi_serviceStub::sendSecurityCurrentVinUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityCurrentVinUpdate payload(_SecurityCurrentVinProperty);

        LOG_INFO ("-> send%s", "SecurityCurrentVinUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityCurrentVin", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityCurrentVinUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSecurityCurrentVinGet(const ::boost::shared_ptr< SecurityCurrentVinGet >& securityCurrentVin) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityCurrentVinGet", securityCurrentVin->getAct());
    sendSecurityCurrentVinGetUpdate(_SecurityCurrentVinProperty.getSecurityCurrentVin(), securityCurrentVin->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSecurityCurrentVinGetUpdate(const T_SPM_Vin& securityCurrentVin, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityCurrentVinGet payload(securityCurrentVin);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityCurrentVinGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSecurityCurrentVin(const T_SPM_Vin& securityCurrentVin) {
    if(securityCurrentVin!=_SecurityCurrentVinProperty.getSecurityCurrentVin()) {
        _SecurityCurrentVinProperty.setSecurityCurrentVin(securityCurrentVin);
        sendSecurityCurrentVinUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_Vin& Lcm_dbus_fi_serviceStub::getSecurityCurrentVin() const {
    return _SecurityCurrentVinProperty.getSecurityCurrentVin();
}

T_SPM_Vin& Lcm_dbus_fi_serviceStub::getSecurityCurrentVinMutable() {
    return _SecurityCurrentVinProperty.getSecurityCurrentVinMutable();
}

void Lcm_dbus_fi_serviceStub::sendSecurityVinHistoryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityVinHistoryUpdate payload(_SecurityVinHistoryProperty);

        LOG_INFO ("-> send%s", "SecurityVinHistoryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityVinHistory", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityVinHistoryUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSecurityVinHistoryGet(const ::boost::shared_ptr< SecurityVinHistoryGet >& securityVinHistory) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityVinHistoryGet", securityVinHistory->getAct());
    sendSecurityVinHistoryGetUpdate(_SecurityVinHistoryProperty.getSecurityVinHistory(), securityVinHistory->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSecurityVinHistoryGetUpdate(const T_SPM_VinHistory& securityVinHistory, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityVinHistoryGet payload(securityVinHistory);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityVinHistoryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSecurityVinHistory(const T_SPM_VinHistory& securityVinHistory) {
    if(securityVinHistory!=_SecurityVinHistoryProperty.getSecurityVinHistory()) {
        _SecurityVinHistoryProperty.setSecurityVinHistory(securityVinHistory);
        sendSecurityVinHistoryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const T_SPM_VinHistory& Lcm_dbus_fi_serviceStub::getSecurityVinHistory() const {
    return _SecurityVinHistoryProperty.getSecurityVinHistory();
}

T_SPM_VinHistory& Lcm_dbus_fi_serviceStub::getSecurityVinHistoryMutable() {
    return _SecurityVinHistoryProperty.getSecurityVinHistoryMutable();
}

void Lcm_dbus_fi_serviceStub::sendVINUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VINUpdate payload(_VINProperty);

        LOG_INFO ("-> send%s", "VINUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VIN", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VINUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onVINGet(const ::boost::shared_ptr< VINGet >& vIN) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VINGet", vIN->getAct());
    sendVINGetUpdate(_VINProperty.getVIN(), vIN->getAct());
}

void Lcm_dbus_fi_serviceStub::sendVINGetUpdate(const ::std::string& vIN, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VINGet payload(vIN);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VINGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setVIN(const ::std::string& vIN) {
    if(vIN!=_VINProperty.getVIN()) {
        _VINProperty.setVIN(vIN);
        sendVINUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Lcm_dbus_fi_serviceStub::getVIN() const {
    return _VINProperty.getVIN();
}

::std::string& Lcm_dbus_fi_serviceStub::getVINMutable() {
    return _VINProperty.getVINMutable();
}

void Lcm_dbus_fi_serviceStub::sendSecurityStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SecurityStateUpdate payload(_SecurityStateProperty);

        LOG_INFO ("-> send%s", "SecurityStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SecurityState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SecurityStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onSecurityStateGet(const ::boost::shared_ptr< SecurityStateGet >& securityState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SecurityStateGet", securityState->getAct());
    sendSecurityStateGetUpdate(_SecurityStateProperty.getSecurityState(), securityState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendSecurityStateGetUpdate(T_SPM_e32_SECURITY_STATE securityState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SecurityStateGet payload(securityState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SecurityStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setSecurityState(T_SPM_e32_SECURITY_STATE securityState) {
    if(securityState!=_SecurityStateProperty.getSecurityState()) {
        _SecurityStateProperty.setSecurityState(securityState);
        sendSecurityStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_SECURITY_STATE Lcm_dbus_fi_serviceStub::getSecurityState() const {
    return _SecurityStateProperty.getSecurityState();
}

void Lcm_dbus_fi_serviceStub::sendVehicleIDUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VehicleIDUpdate payload(_VehicleIDProperty);

        LOG_INFO ("-> send%s", "VehicleIDUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VehicleID", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VehicleIDUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onVehicleIDGet(const ::boost::shared_ptr< VehicleIDGet >& vehicleID) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VehicleIDGet", vehicleID->getAct());
    sendVehicleIDGetUpdate(_VehicleIDProperty.getVehicleID(), vehicleID->getAct());
}

void Lcm_dbus_fi_serviceStub::sendVehicleIDGetUpdate(uint32 vehicleID, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VehicleIDGet payload(vehicleID);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VehicleIDGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setVehicleID(uint32 vehicleID) {
    if(vehicleID!=_VehicleIDProperty.getVehicleID()) {
        _VehicleIDProperty.setVehicleID(vehicleID);
        sendVehicleIDUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getVehicleID() const {
    return _VehicleIDProperty.getVehicleID();
}

void Lcm_dbus_fi_serviceStub::sendDisplayVariantUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DisplayVariantUpdate payload(_DisplayVariantProperty);

        LOG_INFO ("-> send%s", "DisplayVariantUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DisplayVariant", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DisplayVariantUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDisplayVariantGet(const ::boost::shared_ptr< DisplayVariantGet >& displayVariant) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DisplayVariantGet", displayVariant->getAct());
    sendDisplayVariantGetUpdate(_DisplayVariantProperty.getDisplayVariant(), displayVariant->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDisplayVariantGetUpdate(uint32 displayVariant, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DisplayVariantGet payload(displayVariant);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DisplayVariantGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDisplayVariant(uint32 displayVariant) {
    if(displayVariant!=_DisplayVariantProperty.getDisplayVariant()) {
        _DisplayVariantProperty.setDisplayVariant(displayVariant);
        sendDisplayVariantUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getDisplayVariant() const {
    return _DisplayVariantProperty.getDisplayVariant();
}

void Lcm_dbus_fi_serviceStub::sendReductionLevelUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReductionLevelUpdate payload(_ReductionLevelProperty);

        LOG_INFO ("-> send%s", "ReductionLevelUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReductionLevel", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReductionLevelUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onReductionLevelGet(const ::boost::shared_ptr< ReductionLevelGet >& reductionLevel) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReductionLevelGet", reductionLevel->getAct());
    sendReductionLevelGetUpdate(_ReductionLevelProperty.getReductionLevel(), reductionLevel->getAct());
}

void Lcm_dbus_fi_serviceStub::sendReductionLevelGetUpdate(T_SPM_e32_REDUCTION_LEVEL reductionLevel, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReductionLevelGet payload(reductionLevel);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReductionLevelGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setReductionLevel(T_SPM_e32_REDUCTION_LEVEL reductionLevel) {
    if(reductionLevel!=_ReductionLevelProperty.getReductionLevel()) {
        _ReductionLevelProperty.setReductionLevel(reductionLevel);
        sendReductionLevelUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_REDUCTION_LEVEL Lcm_dbus_fi_serviceStub::getReductionLevel() const {
    return _ReductionLevelProperty.getReductionLevel();
}

void Lcm_dbus_fi_serviceStub::sendStartupStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StartupStateUpdate payload(_StartupStateProperty);

        LOG_INFO ("-> send%s", "StartupStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("StartupState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StartupStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onStartupStateGet(const ::boost::shared_ptr< StartupStateGet >& startupState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StartupStateGet", startupState->getAct());
    sendStartupStateGetUpdate(_StartupStateProperty.getStartupState(), startupState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendStartupStateGetUpdate(T_SPM_e32_STARTUP_STATE startupState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StartupStateGet payload(startupState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StartupStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setStartupState(T_SPM_e32_STARTUP_STATE startupState) {
    if(startupState!=_StartupStateProperty.getStartupState()) {
        _StartupStateProperty.setStartupState(startupState);
        sendStartupStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

T_SPM_e32_STARTUP_STATE Lcm_dbus_fi_serviceStub::getStartupState() const {
    return _StartupStateProperty.getStartupState();
}

void Lcm_dbus_fi_serviceStub::sendEntertainMuteUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EntertainMuteUpdate payload(_EntertainMuteProperty);

        LOG_INFO ("-> send%s", "EntertainMuteUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("EntertainMute", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EntertainMuteUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onEntertainMuteGet(const ::boost::shared_ptr< EntertainMuteGet >& entertainMute) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EntertainMuteGet", entertainMute->getAct());
    sendEntertainMuteGetUpdate(_EntertainMuteProperty.getEntertainMute(), entertainMute->getAct());
}

void Lcm_dbus_fi_serviceStub::sendEntertainMuteGetUpdate(bool entertainMute, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EntertainMuteGet payload(entertainMute);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EntertainMuteGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setEntertainMute(bool entertainMute) {
    if(entertainMute!=_EntertainMuteProperty.getEntertainMute()) {
        _EntertainMuteProperty.setEntertainMute(entertainMute);
        sendEntertainMuteUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Lcm_dbus_fi_serviceStub::getEntertainMute() const {
    return _EntertainMuteProperty.getEntertainMute();
}

void Lcm_dbus_fi_serviceStub::sendWelcomeAudioStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        WelcomeAudioStateUpdate payload(_WelcomeAudioStateProperty);

        LOG_INFO ("-> send%s", "WelcomeAudioStateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("WelcomeAudioState", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "WelcomeAudioStateUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onWelcomeAudioStateGet(const ::boost::shared_ptr< WelcomeAudioStateGet >& welcomeAudioState) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "WelcomeAudioStateGet", welcomeAudioState->getAct());
    sendWelcomeAudioStateGetUpdate(_WelcomeAudioStateProperty.getWelcomeAudioState(), welcomeAudioState->getAct());
}

void Lcm_dbus_fi_serviceStub::sendWelcomeAudioStateGetUpdate(bool welcomeAudioState, act_t act) {
    ::asf::dbus::DBusVariant variant;
    WelcomeAudioStateGet payload(welcomeAudioState);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "WelcomeAudioStateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setWelcomeAudioState(bool welcomeAudioState) {
    if(welcomeAudioState!=_WelcomeAudioStateProperty.getWelcomeAudioState()) {
        _WelcomeAudioStateProperty.setWelcomeAudioState(welcomeAudioState);
        sendWelcomeAudioStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Lcm_dbus_fi_serviceStub::getWelcomeAudioState() const {
    return _WelcomeAudioStateProperty.getWelcomeAudioState();
}

void Lcm_dbus_fi_serviceStub::sendUnballastTimeFromEngineStoppedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnballastTimeFromEngineStoppedUpdate payload(_UnballastTimeFromEngineStoppedProperty);

        LOG_INFO ("-> send%s", "UnballastTimeFromEngineStoppedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnballastTimeFromEngineStopped", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnballastTimeFromEngineStoppedUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onUnballastTimeFromEngineStoppedGet(const ::boost::shared_ptr< UnballastTimeFromEngineStoppedGet >& unballastTimeFromEngineStopped) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnballastTimeFromEngineStoppedGet", unballastTimeFromEngineStopped->getAct());
    sendUnballastTimeFromEngineStoppedGetUpdate(_UnballastTimeFromEngineStoppedProperty.getUnballastTimeFromEngineStopped(), unballastTimeFromEngineStopped->getAct());
}

void Lcm_dbus_fi_serviceStub::sendUnballastTimeFromEngineStoppedGetUpdate(uint32 unballastTimeFromEngineStopped, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnballastTimeFromEngineStoppedGet payload(unballastTimeFromEngineStopped);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnballastTimeFromEngineStoppedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setUnballastTimeFromEngineStopped(uint32 unballastTimeFromEngineStopped) {
    if(unballastTimeFromEngineStopped!=_UnballastTimeFromEngineStoppedProperty.getUnballastTimeFromEngineStopped()) {
        _UnballastTimeFromEngineStoppedProperty.setUnballastTimeFromEngineStopped(unballastTimeFromEngineStopped);
        sendUnballastTimeFromEngineStoppedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getUnballastTimeFromEngineStopped() const {
    return _UnballastTimeFromEngineStoppedProperty.getUnballastTimeFromEngineStopped();
}

void Lcm_dbus_fi_serviceStub::sendUnballastTimeBeforeUnballastUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnballastTimeBeforeUnballastUpdate payload(_UnballastTimeBeforeUnballastProperty);

        LOG_INFO ("-> send%s", "UnballastTimeBeforeUnballastUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnballastTimeBeforeUnballast", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnballastTimeBeforeUnballastUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onUnballastTimeBeforeUnballastGet(const ::boost::shared_ptr< UnballastTimeBeforeUnballastGet >& unballastTimeBeforeUnballast) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnballastTimeBeforeUnballastGet", unballastTimeBeforeUnballast->getAct());
    sendUnballastTimeBeforeUnballastGetUpdate(_UnballastTimeBeforeUnballastProperty.getUnballastTimeBeforeUnballast(), unballastTimeBeforeUnballast->getAct());
}

void Lcm_dbus_fi_serviceStub::sendUnballastTimeBeforeUnballastGetUpdate(uint32 unballastTimeBeforeUnballast, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnballastTimeBeforeUnballastGet payload(unballastTimeBeforeUnballast);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnballastTimeBeforeUnballastGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setUnballastTimeBeforeUnballast(uint32 unballastTimeBeforeUnballast) {
    if(unballastTimeBeforeUnballast!=_UnballastTimeBeforeUnballastProperty.getUnballastTimeBeforeUnballast()) {
        _UnballastTimeBeforeUnballastProperty.setUnballastTimeBeforeUnballast(unballastTimeBeforeUnballast);
        sendUnballastTimeBeforeUnballastUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getUnballastTimeBeforeUnballast() const {
    return _UnballastTimeBeforeUnballastProperty.getUnballastTimeBeforeUnballast();
}

void Lcm_dbus_fi_serviceStub::sendUnballastWarningTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UnballastWarningTimeUpdate payload(_UnballastWarningTimeProperty);

        LOG_INFO ("-> send%s", "UnballastWarningTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UnballastWarningTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UnballastWarningTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onUnballastWarningTimeGet(const ::boost::shared_ptr< UnballastWarningTimeGet >& unballastWarningTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UnballastWarningTimeGet", unballastWarningTime->getAct());
    sendUnballastWarningTimeGetUpdate(_UnballastWarningTimeProperty.getUnballastWarningTime(), unballastWarningTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendUnballastWarningTimeGetUpdate(uint32 unballastWarningTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UnballastWarningTimeGet payload(unballastWarningTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UnballastWarningTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setUnballastWarningTime(uint32 unballastWarningTime) {
    if(unballastWarningTime!=_UnballastWarningTimeProperty.getUnballastWarningTime()) {
        _UnballastWarningTimeProperty.setUnballastWarningTime(unballastWarningTime);
        sendUnballastWarningTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getUnballastWarningTime() const {
    return _UnballastWarningTimeProperty.getUnballastWarningTime();
}

void Lcm_dbus_fi_serviceStub::sendDegradedCountUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DegradedCountUpdate payload(_DegradedCountProperty);

        LOG_INFO ("-> send%s", "DegradedCountUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DegradedCount", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DegradedCountUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDegradedCountGet(const ::boost::shared_ptr< DegradedCountGet >& degradedCount) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DegradedCountGet", degradedCount->getAct());
    sendDegradedCountGetUpdate(_DegradedCountProperty.getDegradedCount(), degradedCount->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDegradedCountGetUpdate(uint32 degradedCount, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DegradedCountGet payload(degradedCount);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DegradedCountGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDegradedCount(uint32 degradedCount) {
    if(degradedCount!=_DegradedCountProperty.getDegradedCount()) {
        _DegradedCountProperty.setDegradedCount(degradedCount);
        sendDegradedCountUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getDegradedCount() const {
    return _DegradedCountProperty.getDegradedCount();
}

void Lcm_dbus_fi_serviceStub::sendDegradedTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DegradedTimeUpdate payload(_DegradedTimeProperty);

        LOG_INFO ("-> send%s", "DegradedTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DegradedTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DegradedTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onDegradedTimeGet(const ::boost::shared_ptr< DegradedTimeGet >& degradedTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DegradedTimeGet", degradedTime->getAct());
    sendDegradedTimeGetUpdate(_DegradedTimeProperty.getDegradedTime(), degradedTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendDegradedTimeGetUpdate(uint32 degradedTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DegradedTimeGet payload(degradedTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DegradedTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setDegradedTime(uint32 degradedTime) {
    if(degradedTime!=_DegradedTimeProperty.getDegradedTime()) {
        _DegradedTimeProperty.setDegradedTime(degradedTime);
        sendDegradedTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getDegradedTime() const {
    return _DegradedTimeProperty.getDegradedTime();
}

void Lcm_dbus_fi_serviceStub::sendPhoneHandoverWarnTimeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PhoneHandoverWarnTimeUpdate payload(_PhoneHandoverWarnTimeProperty);

        LOG_INFO ("-> send%s", "PhoneHandoverWarnTimeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PhoneHandoverWarnTime", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PhoneHandoverWarnTimeUpdate");
    }
}

void Lcm_dbus_fi_serviceStub::onPhoneHandoverWarnTimeGet(const ::boost::shared_ptr< PhoneHandoverWarnTimeGet >& phoneHandoverWarnTime) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PhoneHandoverWarnTimeGet", phoneHandoverWarnTime->getAct());
    sendPhoneHandoverWarnTimeGetUpdate(_PhoneHandoverWarnTimeProperty.getPhoneHandoverWarnTime(), phoneHandoverWarnTime->getAct());
}

void Lcm_dbus_fi_serviceStub::sendPhoneHandoverWarnTimeGetUpdate(uint32 phoneHandoverWarnTime, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PhoneHandoverWarnTimeGet payload(phoneHandoverWarnTime);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PhoneHandoverWarnTimeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Lcm_dbus_fi_serviceStub::setPhoneHandoverWarnTime(uint32 phoneHandoverWarnTime) {
    if(phoneHandoverWarnTime!=_PhoneHandoverWarnTimeProperty.getPhoneHandoverWarnTime()) {
        _PhoneHandoverWarnTimeProperty.setPhoneHandoverWarnTime(phoneHandoverWarnTime);
        sendPhoneHandoverWarnTimeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Lcm_dbus_fi_serviceStub::getPhoneHandoverWarnTime() const {
    return _PhoneHandoverWarnTimeProperty.getPhoneHandoverWarnTime();
}

void  Lcm_dbus_fi_serviceStub::sendSystemModeResponse (int32 s32ReturnValOut, act_t act) {
    SystemModeResponse* payload = new SystemModeResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "SystemMode", SystemModeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SystemMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSystemModeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SystemModeError* payload = new SystemModeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SystemMode", SystemModeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SystemMode", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendDownloadLockStateResponse (int32 s32ReturnValOut, act_t act) {
    DownloadLockStateResponse* payload = new DownloadLockStateResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "DownloadLockState", DownloadLockStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DownloadLockState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendDownloadLockStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DownloadLockStateError* payload = new DownloadLockStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DownloadLockState", DownloadLockStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DownloadLockState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendUpdateLockResponse (int32 s32ReturnValOut, act_t act) {
    UpdateLockResponse* payload = new UpdateLockResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateLock", UpdateLockResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateLock", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendUpdateLockError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateLockError* payload = new UpdateLockError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateLock", UpdateLockError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateLock", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendOnOffTriggerResponse (int32 s32ResOut, act_t act) {
    OnOffTriggerResponse* payload = new OnOffTriggerResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "OnOffTrigger", OnOffTriggerResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "OnOffTrigger", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendOnOffTriggerError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    OnOffTriggerError* payload = new OnOffTriggerError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "OnOffTrigger", OnOffTriggerError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "OnOffTrigger", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendStartProcessResponse (int32 s32ReturnValOut, const ::std::string& strLocationOut, uint32 u32ProcIdOut, uint32 u32SpawnDurationOut, act_t act) {
    StartProcessResponse* payload = new StartProcessResponse(s32ReturnValOut, strLocationOut, u32ProcIdOut, u32SpawnDurationOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartProcess", StartProcessResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartProcess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendStartProcessError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartProcessError* payload = new StartProcessError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartProcess", StartProcessError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartProcess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendStopProcessResponse (int32 s32ReturnValOut, act_t act) {
    StopProcessResponse* payload = new StopProcessResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "StopProcess", StopProcessResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StopProcess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendStopProcessError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StopProcessError* payload = new StopProcessError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StopProcess", StopProcessError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StopProcess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendRestartProcessResponse (int32 s32ReturnValOut, act_t act) {
    RestartProcessResponse* payload = new RestartProcessResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "RestartProcess", RestartProcessResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RestartProcess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendRestartProcessError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestartProcessError* payload = new RestartProcessError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RestartProcess", RestartProcessError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RestartProcess", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendStartUpSyncPointReachedResponse (int32 s32ResOut, act_t act) {
    StartUpSyncPointReachedResponse* payload = new StartUpSyncPointReachedResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "StartUpSyncPointReached", StartUpSyncPointReachedResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "StartUpSyncPointReached", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendStartUpSyncPointReachedError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    StartUpSyncPointReachedError* payload = new StartUpSyncPointReachedError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "StartUpSyncPointReached", StartUpSyncPointReachedError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "StartUpSyncPointReached", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendClearListResponse (int32 s32ResOut, act_t act) {
    ClearListResponse* payload = new ClearListResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ClearList", ClearListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ClearList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendClearListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ClearListError* payload = new ClearListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ClearList", ClearListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ClearList", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendRestartSystemResponse (T_SPM_e32_MRESULT e32ReturnValOut, act_t act) {
    RestartSystemResponse* payload = new RestartSystemResponse(e32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "RestartSystem", RestartSystemResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RestartSystem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendRestartSystemError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RestartSystemError* payload = new RestartSystemError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RestartSystem", RestartSystemError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RestartSystem", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendAudioSourceChangeResponse (int32 s32ResOut, act_t act) {
    AudioSourceChangeResponse* payload = new AudioSourceChangeResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "AudioSourceChange", AudioSourceChangeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "AudioSourceChange", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendAudioSourceChangeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AudioSourceChangeError* payload = new AudioSourceChangeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "AudioSourceChange", AudioSourceChangeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "AudioSourceChange", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeBluetoothStateResponse (int32 s32ResOut, act_t act) {
    ChangeBluetoothStateResponse* payload = new ChangeBluetoothStateResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ChangeBluetoothState", ChangeBluetoothStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ChangeBluetoothState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeBluetoothStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChangeBluetoothStateError* payload = new ChangeBluetoothStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ChangeBluetoothState", ChangeBluetoothStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ChangeBluetoothState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeAudioStateResponse (int32 s32ResOut, act_t act) {
    ChangeAudioStateResponse* payload = new ChangeAudioStateResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ChangeAudioState", ChangeAudioStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ChangeAudioState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeAudioStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChangeAudioStateError* payload = new ChangeAudioStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ChangeAudioState", ChangeAudioStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ChangeAudioState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeSpiStateResponse (int32 s32ResOut, act_t act) {
    ChangeSpiStateResponse* payload = new ChangeSpiStateResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ChangeSpiState", ChangeSpiStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ChangeSpiState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeSpiStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChangeSpiStateError* payload = new ChangeSpiStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ChangeSpiState", ChangeSpiStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ChangeSpiState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeTunerStateResponse (int32 s32ResOut, act_t act) {
    ChangeTunerStateResponse* payload = new ChangeTunerStateResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ChangeTunerState", ChangeTunerStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ChangeTunerState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeTunerStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChangeTunerStateError* payload = new ChangeTunerStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ChangeTunerState", ChangeTunerStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ChangeTunerState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeWifiStateResponse (int32 s32ResOut, act_t act) {
    ChangeWifiStateResponse* payload = new ChangeWifiStateResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ChangeWifiState", ChangeWifiStateResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ChangeWifiState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendChangeWifiStateError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChangeWifiStateError* payload = new ChangeWifiStateError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ChangeWifiState", ChangeWifiStateError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ChangeWifiState", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendShutdownAndTerminateCcaAppsResponse (int32 s32ResOut, act_t act) {
    ShutdownAndTerminateCcaAppsResponse* payload = new ShutdownAndTerminateCcaAppsResponse(s32ResOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ShutdownAndTerminateCcaApps", ShutdownAndTerminateCcaAppsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ShutdownAndTerminateCcaApps", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendShutdownAndTerminateCcaAppsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ShutdownAndTerminateCcaAppsError* payload = new ShutdownAndTerminateCcaAppsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ShutdownAndTerminateCcaApps", ShutdownAndTerminateCcaAppsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ShutdownAndTerminateCcaApps", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSetFactorySettingsNewResponse (T_e8_DiaglogDefsetType defSetStateGroupOut, T_e8_DefSetMode defSetStateModeOut, bool defSetStateSuccessfulOut, uint16 defSetStateFirstDifferentParameterIdOut, act_t act) {
    SetFactorySettingsNewResponse* payload = new SetFactorySettingsNewResponse(defSetStateGroupOut, defSetStateModeOut, defSetStateSuccessfulOut, defSetStateFirstDifferentParameterIdOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetFactorySettingsNew", SetFactorySettingsNewResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetFactorySettingsNew", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSetFactorySettingsNewError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetFactorySettingsNewError* payload = new SetFactorySettingsNewError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetFactorySettingsNew", SetFactorySettingsNewError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetFactorySettingsNew", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendClearVINResponse (uint32 resultOut, act_t act) {
    ClearVINResponse* payload = new ClearVINResponse(resultOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "ClearVIN", ClearVINResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ClearVIN", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendClearVINError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ClearVINError* payload = new ClearVINError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ClearVIN", ClearVINError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ClearVIN", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendPrepareDownloadResponse (uint32 resultOut, act_t act) {
    PrepareDownloadResponse* payload = new PrepareDownloadResponse(resultOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "PrepareDownload", PrepareDownloadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PrepareDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendPrepareDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PrepareDownloadError* payload = new PrepareDownloadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PrepareDownload", PrepareDownloadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PrepareDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendEndDownloadResponse (uint32 resultOut, act_t act) {
    EndDownloadResponse* payload = new EndDownloadResponse(resultOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "EndDownload", EndDownloadResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EndDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendEndDownloadError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EndDownloadError* payload = new EndDownloadError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EndDownload", EndDownloadError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EndDownload", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSetOnConfigurationResponse (uint32 resultOut, act_t act) {
    SetOnConfigurationResponse* payload = new SetOnConfigurationResponse(resultOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetOnConfiguration", SetOnConfigurationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetOnConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSetOnConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetOnConfigurationError* payload = new SetOnConfigurationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetOnConfiguration", SetOnConfigurationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetOnConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSetProcessConfigurationResponse (uint32 resultOut, act_t act) {
    SetProcessConfigurationResponse* payload = new SetProcessConfigurationResponse(resultOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProcessConfiguration", SetProcessConfigurationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProcessConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendSetProcessConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetProcessConfigurationError* payload = new SetProcessConfigurationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProcessConfiguration", SetProcessConfigurationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProcessConfiguration", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendEntertainDeMuteResponse (int32 s32ReturnValOut, act_t act) {
    EntertainDeMuteResponse* payload = new EntertainDeMuteResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "EntertainDeMute", EntertainDeMuteResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EntertainDeMute", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendEntertainDeMuteError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EntertainDeMuteError* payload = new EntertainDeMuteError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EntertainDeMute", EntertainDeMuteError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EntertainDeMute", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendEntertainMuteRequestResponse (int32 s32ReturnValOut, act_t act) {
    EntertainMuteRequestResponse* payload = new EntertainMuteRequestResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "EntertainMuteRequest", EntertainMuteRequestResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "EntertainMuteRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendEntertainMuteRequestError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    EntertainMuteRequestError* payload = new EntertainMuteRequestError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "EntertainMuteRequest", EntertainMuteRequestError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "EntertainMuteRequest", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendWelcomeAudioActivationResponse (int32 s32ReturnValOut, act_t act) {
    WelcomeAudioActivationResponse* payload = new WelcomeAudioActivationResponse(s32ReturnValOut);
    DBUS_MESSAGE_REPLY(dbusMessage, "WelcomeAudioActivation", WelcomeAudioActivationResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "WelcomeAudioActivation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Lcm_dbus_fi_serviceStub::sendWelcomeAudioActivationError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    WelcomeAudioActivationError* payload = new WelcomeAudioActivationError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "WelcomeAudioActivation", WelcomeAudioActivationError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "WelcomeAudioActivation", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Lcm_dbus_fi_serviceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'SystemState'
    {
        ::asf::dbus::DBusVariant variant;
        SystemStateGet payload(_SystemStateProperty.getSystemState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemState", variant));
    }

    //property 'DownloadLockStates'
    {
        ::asf::dbus::DBusVariant variant;
        DownloadLockStatesGet payload(_DownloadLockStatesProperty.getDownloadLockStates());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DownloadLockStates", variant));
    }

    //property 'UpdateLockStates'
    {
        ::asf::dbus::DBusVariant variant;
        UpdateLockStatesGet payload(_UpdateLockStatesProperty.getUpdateLockStates());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UpdateLockStates", variant));
    }

    //property 'ActiveOnOffTrigger'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveOnOffTriggerGet payload(_ActiveOnOffTriggerProperty.getActiveOnOffTrigger());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveOnOffTrigger", variant));
    }

    //property 'SubStates'
    {
        ::asf::dbus::DBusVariant variant;
        SubStatesGet payload(_SubStatesProperty.getSubStates());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SubStates", variant));
    }

    //property 'HistoryTrigger'
    {
        ::asf::dbus::DBusVariant variant;
        HistoryTriggerGet payload(_HistoryTriggerProperty.getHistoryTrigger());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("HistoryTrigger", variant));
    }

    //property 'InsertState'
    {
        ::asf::dbus::DBusVariant variant;
        InsertStateGet payload(_InsertStateProperty.getInsertState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("InsertState", variant));
    }

    //property 'MediaEjectState'
    {
        ::asf::dbus::DBusVariant variant;
        MediaEjectStateGet payload(_MediaEjectStateProperty.getMediaEjectState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MediaEjectState", variant));
    }

    //property 'PhoneMuteState'
    {
        ::asf::dbus::DBusVariant variant;
        PhoneMuteStateGet payload(_PhoneMuteStateProperty.getPhoneMuteState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PhoneMuteState", variant));
    }

    //property 'OnTipperState'
    {
        ::asf::dbus::DBusVariant variant;
        OnTipperStateGet payload(_OnTipperStateProperty.getOnTipperState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("OnTipperState", variant));
    }

    //property 'IgnitionCycles'
    {
        ::asf::dbus::DBusVariant variant;
        IgnitionCyclesGet payload(_IgnitionCyclesProperty.getIgnitionCycles());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IgnitionCycles", variant));
    }

    //property 'SysPwrMode'
    {
        ::asf::dbus::DBusVariant variant;
        SysPwrModeGet payload(_SysPwrModeProperty.getSysPwrMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SysPwrMode", variant));
    }

    //property 'SysPwrSaveMode'
    {
        ::asf::dbus::DBusVariant variant;
        SysPwrSaveModeGet payload(_SysPwrSaveModeProperty.getSysPwrSaveMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SysPwrSaveMode", variant));
    }

    //property 'MapDownloadLockState'
    {
        ::asf::dbus::DBusVariant variant;
        MapDownloadLockStateGet payload(_MapDownloadLockStateProperty.getMapDownloadLockState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MapDownloadLockState", variant));
    }

    //property 'StandbyTime'
    {
        ::asf::dbus::DBusVariant variant;
        StandbyTimeGet payload(_StandbyTimeProperty.getStandbyTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StandbyTime", variant));
    }

    //property 'PersitentStandbyTime'
    {
        ::asf::dbus::DBusVariant variant;
        PersitentStandbyTimeGet payload(_PersitentStandbyTimeProperty.getPersitentStandbyTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PersitentStandbyTime", variant));
    }

    //property 'IgnitionOffTime'
    {
        ::asf::dbus::DBusVariant variant;
        IgnitionOffTimeGet payload(_IgnitionOffTimeProperty.getIgnitionOffTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IgnitionOffTime", variant));
    }

    //property 'DoorOpenTime'
    {
        ::asf::dbus::DBusVariant variant;
        DoorOpenTimeGet payload(_DoorOpenTimeProperty.getDoorOpenTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DoorOpenTime", variant));
    }

    //property 'ClockDisplayTime'
    {
        ::asf::dbus::DBusVariant variant;
        ClockDisplayTimeGet payload(_ClockDisplayTimeProperty.getClockDisplayTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ClockDisplayTime", variant));
    }

    //property 'SystemStateTime'
    {
        ::asf::dbus::DBusVariant variant;
        SystemStateTimeGet payload(_SystemStateTimeProperty.getSystemStateTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemStateTime", variant));
    }

    //property 'ProcessList'
    {
        ::asf::dbus::DBusVariant variant;
        ProcessListGet payload(_ProcessListProperty.getProcessList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ProcessList", variant));
    }

    //property 'WakeupReason'
    {
        ::asf::dbus::DBusVariant variant;
        WakeupReasonGet payload(_WakeupReasonProperty.getWakeupReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WakeupReason", variant));
    }

    //property 'StartupReason'
    {
        ::asf::dbus::DBusVariant variant;
        StartupReasonGet payload(_StartupReasonProperty.getStartupReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupReason", variant));
    }

    //property 'ConnectToBattery'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectToBatteryGet payload(_ConnectToBatteryProperty.getConnectToBattery());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConnectToBattery", variant));
    }

    //property 'CodeRequestState'
    {
        ::asf::dbus::DBusVariant variant;
        CodeRequestStateGet payload(_CodeRequestStateProperty.getCodeRequestState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CodeRequestState", variant));
    }

    //property 'ActiveStartUpSyncPoints'
    {
        ::asf::dbus::DBusVariant variant;
        ActiveStartUpSyncPointsGet payload(_ActiveStartUpSyncPointsProperty.getActiveStartUpSyncPoints());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ActiveStartUpSyncPoints", variant));
    }

    //property 'CvmEvent'
    {
        ::asf::dbus::DBusVariant variant;
        CvmEventGet payload(_CvmEventProperty.getCvmEvent());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CvmEvent", variant));
    }

    //property 'UBatSense'
    {
        ::asf::dbus::DBusVariant variant;
        UBatSenseGet payload(_UBatSenseProperty.getUBatSense());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UBatSense", variant));
    }

    //property 'CoproState'
    {
        ::asf::dbus::DBusVariant variant;
        CoproStateGet payload(_CoproStateProperty.getCoproState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CoproState", variant));
    }

    //property 'DevicePowerOnTime'
    {
        ::asf::dbus::DBusVariant variant;
        DevicePowerOnTimeGet payload(_DevicePowerOnTimeProperty.getDevicePowerOnTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DevicePowerOnTime", variant));
    }

    //property 'LastSystemRuntime'
    {
        ::asf::dbus::DBusVariant variant;
        LastSystemRuntimeGet payload(_LastSystemRuntimeProperty.getLastSystemRuntime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("LastSystemRuntime", variant));
    }

    //property 'CurrentSystemRuntime'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentSystemRuntimeGet payload(_CurrentSystemRuntimeProperty.getCurrentSystemRuntime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CurrentSystemRuntime", variant));
    }

    //property 'ResetList'
    {
        ::asf::dbus::DBusVariant variant;
        ResetListGet payload(_ResetListProperty.getResetList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ResetList", variant));
    }

    //property 'ResetCounter'
    {
        ::asf::dbus::DBusVariant variant;
        ResetCounterGet payload(_ResetCounterProperty.getResetCounter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ResetCounter", variant));
    }

    //property 'TransportModeList'
    {
        ::asf::dbus::DBusVariant variant;
        TransportModeListGet payload(_TransportModeListProperty.getTransportModeList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TransportModeList", variant));
    }

    //property 'ResetHistory'
    {
        ::asf::dbus::DBusVariant variant;
        ResetHistoryGet payload(_ResetHistoryProperty.getResetHistory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ResetHistory", variant));
    }

    //property 'WakeupHistory'
    {
        ::asf::dbus::DBusVariant variant;
        WakeupHistoryGet payload(_WakeupHistoryProperty.getWakeupHistory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WakeupHistory", variant));
    }

    //property 'StateHistory'
    {
        ::asf::dbus::DBusVariant variant;
        StateHistoryGet payload(_StateHistoryProperty.getStateHistory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StateHistory", variant));
    }

    //property 'ErrStateHistory01'
    {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory01Get payload(_ErrStateHistory01Property.getErrStateHistory01());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ErrStateHistory01", variant));
    }

    //property 'ErrStateHistory02'
    {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory02Get payload(_ErrStateHistory02Property.getErrStateHistory02());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ErrStateHistory02", variant));
    }

    //property 'ErrStateHistory03'
    {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory03Get payload(_ErrStateHistory03Property.getErrStateHistory03());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ErrStateHistory03", variant));
    }

    //property 'ErrStateHistory04'
    {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory04Get payload(_ErrStateHistory04Property.getErrStateHistory04());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ErrStateHistory04", variant));
    }

    //property 'ErrStateHistory05'
    {
        ::asf::dbus::DBusVariant variant;
        ErrStateHistory05Get payload(_ErrStateHistory05Property.getErrStateHistory05());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ErrStateHistory05", variant));
    }

    //property 'SwitchOnHistory'
    {
        ::asf::dbus::DBusVariant variant;
        SwitchOnHistoryGet payload(_SwitchOnHistoryProperty.getSwitchOnHistory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SwitchOnHistory", variant));
    }

    //property 'DeviceOnCounter'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceOnCounterGet payload(_DeviceOnCounterProperty.getDeviceOnCounter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DeviceOnCounter", variant));
    }

    //property 'VoltageEventCounter'
    {
        ::asf::dbus::DBusVariant variant;
        VoltageEventCounterGet payload(_VoltageEventCounterProperty.getVoltageEventCounter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VoltageEventCounter", variant));
    }

    //property 'VoltageRangeHistogram'
    {
        ::asf::dbus::DBusVariant variant;
        VoltageRangeHistogramGet payload(_VoltageRangeHistogramProperty.getVoltageRangeHistogram());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VoltageRangeHistogram", variant));
    }

    //property 'CpuUsageStatistic'
    {
        ::asf::dbus::DBusVariant variant;
        CpuUsageStatisticGet payload(_CpuUsageStatisticProperty.getCpuUsageStatistic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CpuUsageStatistic", variant));
    }

    //property 'RamUsageStatistic'
    {
        ::asf::dbus::DBusVariant variant;
        RamUsageStatisticGet payload(_RamUsageStatisticProperty.getRamUsageStatistic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RamUsageStatistic", variant));
    }

    //property 'StartupTimeStatistic'
    {
        ::asf::dbus::DBusVariant variant;
        StartupTimeStatisticGet payload(_StartupTimeStatisticProperty.getStartupTimeStatistic());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupTimeStatistic", variant));
    }

    //property 'RunlevelState'
    {
        ::asf::dbus::DBusVariant variant;
        RunlevelStateGet payload(_RunlevelStateProperty.getRunlevelState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RunlevelState", variant));
    }

    //property 'Restart'
    {
        ::asf::dbus::DBusVariant variant;
        RestartGet payload(_RestartProperty.getRestart());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Restart", variant));
    }

    //property 'Lifesign'
    {
        ::asf::dbus::DBusVariant variant;
        LifesignGet payload(_LifesignProperty.getLifesign());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Lifesign", variant));
    }

    //property 'HmiState'
    {
        ::asf::dbus::DBusVariant variant;
        HmiStateGet payload(_HmiStateProperty.getHmiState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("HmiState", variant));
    }

    //property 'SystemPowerBehaviour'
    {
        ::asf::dbus::DBusVariant variant;
        SystemPowerBehaviourGet payload(_SystemPowerBehaviourProperty.getSystemPowerBehaviour());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SystemPowerBehaviour", variant));
    }

    //property 'DimState'
    {
        ::asf::dbus::DBusVariant variant;
        DimStateGet payload(_DimStateProperty.getDimState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DimState", variant));
    }

    //property 'DimmingState'
    {
        ::asf::dbus::DBusVariant variant;
        DimmingStateGet payload(_DimmingStateProperty.getDimmingState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DimmingState", variant));
    }

    //property 'BluetoothState'
    {
        ::asf::dbus::DBusVariant variant;
        BluetoothStateGet payload(_BluetoothStateProperty.getBluetoothState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("BluetoothState", variant));
    }

    //property 'AudioState'
    {
        ::asf::dbus::DBusVariant variant;
        AudioStateGet payload(_AudioStateProperty.getAudioState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AudioState", variant));
    }

    //property 'SpiState'
    {
        ::asf::dbus::DBusVariant variant;
        SpiStateGet payload(_SpiStateProperty.getSpiState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SpiState", variant));
    }

    //property 'TunerState'
    {
        ::asf::dbus::DBusVariant variant;
        TunerStateGet payload(_TunerStateProperty.getTunerState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TunerState", variant));
    }

    //property 'WifiState'
    {
        ::asf::dbus::DBusVariant variant;
        WifiStateGet payload(_WifiStateProperty.getWifiState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WifiState", variant));
    }

    //property 'OnOffReason'
    {
        ::asf::dbus::DBusVariant variant;
        OnOffReasonGet payload(_OnOffReasonProperty.getOnOffReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("OnOffReason", variant));
    }

    //property 'WakeupList'
    {
        ::asf::dbus::DBusVariant variant;
        WakeupListGet payload(_WakeupListProperty.getWakeupList());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WakeupList", variant));
    }

    //property 'StartupFinished'
    {
        ::asf::dbus::DBusVariant variant;
        StartupFinishedGet payload(_StartupFinishedProperty.getStartupFinished());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupFinished", variant));
    }

    //property 'SysState'
    {
        ::asf::dbus::DBusVariant variant;
        SysStateGet payload(_SysStateProperty.getSysState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SysState", variant));
    }

    //property 'MostState'
    {
        ::asf::dbus::DBusVariant variant;
        MostStateGet payload(_MostStateProperty.getMostState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MostState", variant));
    }

    //property 'MostVersion'
    {
        ::asf::dbus::DBusVariant variant;
        MostVersionGet payload(_MostVersionProperty.getMostVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MostVersion", variant));
    }

    //property 'RVCState'
    {
        ::asf::dbus::DBusVariant variant;
        RVCStateGet payload(_RVCStateProperty.getRVCState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RVCState", variant));
    }

    //property 'TriggerMostRemoteReset'
    {
        ::asf::dbus::DBusVariant variant;
        TriggerMostRemoteResetGet payload(_TriggerMostRemoteResetProperty.getTriggerMostRemoteReset());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("TriggerMostRemoteReset", variant));
    }

    //property 'Partnumber'
    {
        ::asf::dbus::DBusVariant variant;
        PartnumberGet payload(_PartnumberProperty.getPartnumber());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Partnumber", variant));
    }

    //property 'Partnumbers'
    {
        ::asf::dbus::DBusVariant variant;
        PartnumbersGet payload(_PartnumbersProperty.getPartnumbers());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Partnumbers", variant));
    }

    //property 'Alphacode'
    {
        ::asf::dbus::DBusVariant variant;
        AlphacodeGet payload(_AlphacodeProperty.getAlphacode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Alphacode", variant));
    }

    //property 'Alphacodes'
    {
        ::asf::dbus::DBusVariant variant;
        AlphacodesGet payload(_AlphacodesProperty.getAlphacodes());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Alphacodes", variant));
    }

    //property 'ManufacturersEnableCounter'
    {
        ::asf::dbus::DBusVariant variant;
        ManufacturersEnableCounterGet payload(_ManufacturersEnableCounterProperty.getManufacturersEnableCounter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ManufacturersEnableCounter", variant));
    }

    //property 'NoCalibrationState'
    {
        ::asf::dbus::DBusVariant variant;
        NoCalibrationStateGet payload(_NoCalibrationStateProperty.getNoCalibrationState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("NoCalibrationState", variant));
    }

    //property 'SecurityCommError'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityCommErrorGet payload(_SecurityCommErrorProperty.getSecurityCommError());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityCommError", variant));
    }

    //property 'SecurityMoreThan10Vin'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityMoreThan10VinGet payload(_SecurityMoreThan10VinProperty.getSecurityMoreThan10Vin());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityMoreThan10Vin", variant));
    }

    //property 'SecurityInvalidVin'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityInvalidVinGet payload(_SecurityInvalidVinProperty.getSecurityInvalidVin());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityInvalidVin", variant));
    }

    //property 'SecurityCurrentVin'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityCurrentVinGet payload(_SecurityCurrentVinProperty.getSecurityCurrentVin());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityCurrentVin", variant));
    }

    //property 'SecurityVinHistory'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityVinHistoryGet payload(_SecurityVinHistoryProperty.getSecurityVinHistory());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityVinHistory", variant));
    }

    //property 'VIN'
    {
        ::asf::dbus::DBusVariant variant;
        VINGet payload(_VINProperty.getVIN());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VIN", variant));
    }

    //property 'SecurityState'
    {
        ::asf::dbus::DBusVariant variant;
        SecurityStateGet payload(_SecurityStateProperty.getSecurityState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SecurityState", variant));
    }

    //property 'VehicleID'
    {
        ::asf::dbus::DBusVariant variant;
        VehicleIDGet payload(_VehicleIDProperty.getVehicleID());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VehicleID", variant));
    }

    //property 'DisplayVariant'
    {
        ::asf::dbus::DBusVariant variant;
        DisplayVariantGet payload(_DisplayVariantProperty.getDisplayVariant());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DisplayVariant", variant));
    }

    //property 'ReductionLevel'
    {
        ::asf::dbus::DBusVariant variant;
        ReductionLevelGet payload(_ReductionLevelProperty.getReductionLevel());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReductionLevel", variant));
    }

    //property 'StartupState'
    {
        ::asf::dbus::DBusVariant variant;
        StartupStateGet payload(_StartupStateProperty.getStartupState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("StartupState", variant));
    }

    //property 'EntertainMute'
    {
        ::asf::dbus::DBusVariant variant;
        EntertainMuteGet payload(_EntertainMuteProperty.getEntertainMute());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("EntertainMute", variant));
    }

    //property 'WelcomeAudioState'
    {
        ::asf::dbus::DBusVariant variant;
        WelcomeAudioStateGet payload(_WelcomeAudioStateProperty.getWelcomeAudioState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("WelcomeAudioState", variant));
    }

    //property 'UnballastTimeFromEngineStopped'
    {
        ::asf::dbus::DBusVariant variant;
        UnballastTimeFromEngineStoppedGet payload(_UnballastTimeFromEngineStoppedProperty.getUnballastTimeFromEngineStopped());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnballastTimeFromEngineStopped", variant));
    }

    //property 'UnballastTimeBeforeUnballast'
    {
        ::asf::dbus::DBusVariant variant;
        UnballastTimeBeforeUnballastGet payload(_UnballastTimeBeforeUnballastProperty.getUnballastTimeBeforeUnballast());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnballastTimeBeforeUnballast", variant));
    }

    //property 'UnballastWarningTime'
    {
        ::asf::dbus::DBusVariant variant;
        UnballastWarningTimeGet payload(_UnballastWarningTimeProperty.getUnballastWarningTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UnballastWarningTime", variant));
    }

    //property 'DegradedCount'
    {
        ::asf::dbus::DBusVariant variant;
        DegradedCountGet payload(_DegradedCountProperty.getDegradedCount());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DegradedCount", variant));
    }

    //property 'DegradedTime'
    {
        ::asf::dbus::DBusVariant variant;
        DegradedTimeGet payload(_DegradedTimeProperty.getDegradedTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DegradedTime", variant));
    }

    //property 'PhoneHandoverWarnTime'
    {
        ::asf::dbus::DBusVariant variant;
        PhoneHandoverWarnTimeGet payload(_PhoneHandoverWarnTimeProperty.getPhoneHandoverWarnTime());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PhoneHandoverWarnTime", variant));
    }
}

} // namespace lcm_dbus_fi_service
} // namespace lcm_dbus_fi
} // namespace cm
} // namespace bosch
} // namespace org
