#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_CM_LCM_DBUS_FI_LCM_DBUS_FI_SERVICE_H
#define ORG_BOSCH_CM_LCM_DBUS_FI_LCM_DBUS_FI_SERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "org.bosch.cm.lcm_dbus_fi.lcm_dbus_fi_service" isn't clear, then there should be a description here.
 */

namespace org {
namespace bosch {
namespace cm {
namespace lcm_dbus_fi {
namespace lcm_dbus_fi_service {

// method IDs
static const uint16 ID_SystemMode = 0;
static const uint16 ID_DownloadLockState = 1;
static const uint16 ID_UpdateLock = 2;
static const uint16 ID_OnOffTrigger = 3;
static const uint16 ID_StartProcess = 4;
static const uint16 ID_StopProcess = 5;
static const uint16 ID_RestartProcess = 6;
static const uint16 ID_StartUpSyncPointReached = 7;
static const uint16 ID_ClearList = 8;
static const uint16 ID_RestartSystem = 9;
static const uint16 ID_AudioSourceChange = 10;
static const uint16 ID_ChangeBluetoothState = 11;
static const uint16 ID_ChangeAudioState = 12;
static const uint16 ID_ChangeSpiState = 13;
static const uint16 ID_ChangeTunerState = 14;
static const uint16 ID_ChangeWifiState = 15;
static const uint16 ID_ShutdownAndTerminateCcaApps = 16;
static const uint16 ID_SetFactorySettingsNew = 17;
static const uint16 ID_ClearVIN = 18;
static const uint16 ID_PrepareDownload = 19;
static const uint16 ID_EndDownload = 20;
static const uint16 ID_SetOnConfiguration = 21;
static const uint16 ID_SetProcessConfiguration = 22;
static const uint16 ID_EntertainDeMute = 23;
static const uint16 ID_EntertainMuteRequest = 24;
static const uint16 ID_WelcomeAudioActivation = 25;

// signal IDs

// property IDs
static const uint16 ID_SystemState = 26;
static const uint16 ID_DownloadLockStates = 27;
static const uint16 ID_UpdateLockStates = 28;
static const uint16 ID_ActiveOnOffTrigger = 29;
static const uint16 ID_SubStates = 30;
static const uint16 ID_HistoryTrigger = 31;
static const uint16 ID_InsertState = 32;
static const uint16 ID_MediaEjectState = 33;
static const uint16 ID_PhoneMuteState = 34;
static const uint16 ID_OnTipperState = 35;
static const uint16 ID_IgnitionCycles = 36;
static const uint16 ID_SysPwrMode = 37;
static const uint16 ID_SysPwrSaveMode = 38;
static const uint16 ID_MapDownloadLockState = 39;
static const uint16 ID_StandbyTime = 40;
static const uint16 ID_PersitentStandbyTime = 41;
static const uint16 ID_IgnitionOffTime = 42;
static const uint16 ID_DoorOpenTime = 43;
static const uint16 ID_ClockDisplayTime = 44;
static const uint16 ID_SystemStateTime = 45;
static const uint16 ID_ProcessList = 46;
static const uint16 ID_WakeupReason = 47;
static const uint16 ID_StartupReason = 48;
static const uint16 ID_ConnectToBattery = 49;
static const uint16 ID_CodeRequestState = 50;
static const uint16 ID_ActiveStartUpSyncPoints = 51;
static const uint16 ID_CvmEvent = 52;
static const uint16 ID_UBatSense = 53;
static const uint16 ID_CoproState = 54;
static const uint16 ID_DevicePowerOnTime = 55;
static const uint16 ID_LastSystemRuntime = 56;
static const uint16 ID_CurrentSystemRuntime = 57;
static const uint16 ID_ResetList = 58;
static const uint16 ID_ResetCounter = 59;
static const uint16 ID_TransportModeList = 60;
static const uint16 ID_ResetHistory = 61;
static const uint16 ID_WakeupHistory = 62;
static const uint16 ID_StateHistory = 63;
static const uint16 ID_ErrStateHistory01 = 64;
static const uint16 ID_ErrStateHistory02 = 65;
static const uint16 ID_ErrStateHistory03 = 66;
static const uint16 ID_ErrStateHistory04 = 67;
static const uint16 ID_ErrStateHistory05 = 68;
static const uint16 ID_SwitchOnHistory = 69;
static const uint16 ID_DeviceOnCounter = 70;
static const uint16 ID_VoltageEventCounter = 71;
static const uint16 ID_VoltageRangeHistogram = 72;
static const uint16 ID_CpuUsageStatistic = 73;
static const uint16 ID_RamUsageStatistic = 74;
static const uint16 ID_StartupTimeStatistic = 75;
static const uint16 ID_RunlevelState = 76;
static const uint16 ID_Restart = 77;
static const uint16 ID_Lifesign = 78;
static const uint16 ID_HmiState = 79;
static const uint16 ID_SystemPowerBehaviour = 80;
static const uint16 ID_DimState = 81;
static const uint16 ID_DimmingState = 82;
static const uint16 ID_BluetoothState = 83;
static const uint16 ID_AudioState = 84;
static const uint16 ID_SpiState = 85;
static const uint16 ID_TunerState = 86;
static const uint16 ID_WifiState = 87;
static const uint16 ID_OnOffReason = 88;
static const uint16 ID_WakeupList = 89;
static const uint16 ID_StartupFinished = 90;
static const uint16 ID_SysState = 91;
static const uint16 ID_MostState = 92;
static const uint16 ID_MostVersion = 93;
static const uint16 ID_RVCState = 94;
static const uint16 ID_TriggerMostRemoteReset = 95;
static const uint16 ID_Partnumber = 96;
static const uint16 ID_Partnumbers = 97;
static const uint16 ID_Alphacode = 98;
static const uint16 ID_Alphacodes = 99;
static const uint16 ID_ManufacturersEnableCounter = 100;
static const uint16 ID_NoCalibrationState = 101;
static const uint16 ID_SecurityCommError = 102;
static const uint16 ID_SecurityMoreThan10Vin = 103;
static const uint16 ID_SecurityInvalidVin = 104;
static const uint16 ID_SecurityCurrentVin = 105;
static const uint16 ID_SecurityVinHistory = 106;
static const uint16 ID_VIN = 107;
static const uint16 ID_SecurityState = 108;
static const uint16 ID_VehicleID = 109;
static const uint16 ID_DisplayVariant = 110;
static const uint16 ID_ReductionLevel = 111;
static const uint16 ID_StartupState = 112;
static const uint16 ID_EntertainMute = 113;
static const uint16 ID_WelcomeAudioState = 114;
static const uint16 ID_UnballastTimeFromEngineStopped = 115;
static const uint16 ID_UnballastTimeBeforeUnballast = 116;
static const uint16 ID_UnballastWarningTime = 117;
static const uint16 ID_DegradedCount = 118;
static const uint16 ID_DegradedTime = 119;
static const uint16 ID_PhoneHandoverWarnTime = 120;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class TSubStates;

class TSystemStateTime;

class TConnectToBattery;

class TResetList;

class TTimeDate;

class TResetCounter;

class TDeviceOnCounter;

class TWakeupList;

class TMostState;

class TAlphacode;

class T_b32_SubState0;

class T_b32_SubState1;

class T_b32_SubState2;

class T_b32_SubState3;

class T_SPM_b32_DIM_STATE;

class T_SPM_b32_SYSPWRSAVEMODE;

class TSwVersionInfo;

class T_SPM_HistoryTrigger;

class T_SPM_TransPortMode;

class T_SPM_TransPortModeList;

class T_SubStateEntry;

class T_ProcessElement;

class T_SPM_ProcessInfo;

class T_SPM_Vin;

class T_SPM_VinHistory;

class T_ResetElement;

class T_WakeupElement;

class T_StateChangeElement;

class T_SwitchOnElement;

class T_SPM_PartnumberItem;

class T_SPM_PartnumberList;

class T_SPM_AlphacodeItem;

class T_SPM_AlphacodeList;

class T_SPM_AppIdList;

class T_SPM_RestrictedDlLock;

class T_SPM_UpdateLockState;

class T_SPM_VoltageEventCounter;

class T_SPM_VoltageRange;

class T_SPM_SystemStatisticsData;

class T_SPM_ResetInfoStatisticData;

class SystemModeRequest;

class SystemModeResponse;

class DownloadLockStateRequest;

class DownloadLockStateResponse;

class UpdateLockRequest;

class UpdateLockResponse;

class OnOffTriggerRequest;

class OnOffTriggerResponse;

class StartProcessRequest;

class StartProcessResponse;

class StopProcessRequest;

class StopProcessResponse;

class RestartProcessRequest;

class RestartProcessResponse;

class StartUpSyncPointReachedRequest;

class StartUpSyncPointReachedResponse;

class ClearListRequest;

class ClearListResponse;

class RestartSystemRequest;

class RestartSystemResponse;

class AudioSourceChangeRequest;

class AudioSourceChangeResponse;

class ChangeBluetoothStateRequest;

class ChangeBluetoothStateResponse;

class ChangeAudioStateRequest;

class ChangeAudioStateResponse;

class ChangeSpiStateRequest;

class ChangeSpiStateResponse;

class ChangeTunerStateRequest;

class ChangeTunerStateResponse;

class ChangeWifiStateRequest;

class ChangeWifiStateResponse;

class ShutdownAndTerminateCcaAppsRequest;

class ShutdownAndTerminateCcaAppsResponse;

class SetFactorySettingsNewRequest;

class SetFactorySettingsNewResponse;

class ClearVINResponse;

class PrepareDownloadRequest;

class PrepareDownloadResponse;

class EndDownloadResponse;

class SetOnConfigurationRequest;

class SetOnConfigurationResponse;

class SetProcessConfigurationRequest;

class SetProcessConfigurationResponse;

class EntertainDeMuteResponse;

class EntertainMuteRequestResponse;

class WelcomeAudioActivationRequest;

class WelcomeAudioActivationResponse;

class SystemStateUpdate;

class SystemStateRegister;

class DownloadLockStatesUpdate;

class DownloadLockStatesRegister;

class UpdateLockStatesUpdate;

class UpdateLockStatesRegister;

class ActiveOnOffTriggerUpdate;

class ActiveOnOffTriggerRegister;

class SubStatesUpdate;

class SubStatesRegister;

class HistoryTriggerUpdate;

class HistoryTriggerRegister;

class InsertStateUpdate;

class InsertStateRegister;

class MediaEjectStateUpdate;

class MediaEjectStateRegister;

class PhoneMuteStateUpdate;

class PhoneMuteStateRegister;

class OnTipperStateUpdate;

class OnTipperStateRegister;

class IgnitionCyclesUpdate;

class IgnitionCyclesRegister;

class SysPwrModeUpdate;

class SysPwrModeRegister;

class SysPwrSaveModeUpdate;

class SysPwrSaveModeRegister;

class MapDownloadLockStateUpdate;

class MapDownloadLockStateRegister;

class StandbyTimeUpdate;

class StandbyTimeRegister;

class PersitentStandbyTimeUpdate;

class PersitentStandbyTimeRegister;

class IgnitionOffTimeUpdate;

class IgnitionOffTimeRegister;

class DoorOpenTimeUpdate;

class DoorOpenTimeRegister;

class ClockDisplayTimeUpdate;

class ClockDisplayTimeRegister;

class SystemStateTimeUpdate;

class SystemStateTimeRegister;

class ProcessListUpdate;

class ProcessListRegister;

class WakeupReasonUpdate;

class WakeupReasonRegister;

class StartupReasonUpdate;

class StartupReasonRegister;

class ConnectToBatteryUpdate;

class ConnectToBatteryRegister;

class CodeRequestStateUpdate;

class CodeRequestStateRegister;

class ActiveStartUpSyncPointsUpdate;

class ActiveStartUpSyncPointsRegister;

class CvmEventUpdate;

class CvmEventRegister;

class UBatSenseUpdate;

class UBatSenseRegister;

class CoproStateUpdate;

class CoproStateRegister;

class DevicePowerOnTimeUpdate;

class DevicePowerOnTimeRegister;

class LastSystemRuntimeUpdate;

class LastSystemRuntimeRegister;

class CurrentSystemRuntimeUpdate;

class CurrentSystemRuntimeRegister;

class ResetListUpdate;

class ResetListRegister;

class ResetCounterUpdate;

class ResetCounterRegister;

class TransportModeListUpdate;

class TransportModeListRegister;

class ResetHistoryUpdate;

class ResetHistoryRegister;

class WakeupHistoryUpdate;

class WakeupHistoryRegister;

class StateHistoryUpdate;

class StateHistoryRegister;

class ErrStateHistory01Update;

class ErrStateHistory01Register;

class ErrStateHistory02Update;

class ErrStateHistory02Register;

class ErrStateHistory03Update;

class ErrStateHistory03Register;

class ErrStateHistory04Update;

class ErrStateHistory04Register;

class ErrStateHistory05Update;

class ErrStateHistory05Register;

class SwitchOnHistoryUpdate;

class SwitchOnHistoryRegister;

class DeviceOnCounterUpdate;

class DeviceOnCounterRegister;

class VoltageEventCounterUpdate;

class VoltageEventCounterRegister;

class VoltageRangeHistogramUpdate;

class VoltageRangeHistogramRegister;

class CpuUsageStatisticUpdate;

class CpuUsageStatisticRegister;

class RamUsageStatisticUpdate;

class RamUsageStatisticRegister;

class StartupTimeStatisticUpdate;

class StartupTimeStatisticRegister;

class RunlevelStateUpdate;

class RunlevelStateRegister;

class RestartUpdate;

class RestartRegister;

class LifesignUpdate;

class LifesignRegister;

class HmiStateUpdate;

class HmiStateRegister;

class SystemPowerBehaviourUpdate;

class SystemPowerBehaviourRegister;

class DimStateUpdate;

class DimStateRegister;

class DimmingStateUpdate;

class DimmingStateRegister;

class BluetoothStateUpdate;

class BluetoothStateRegister;

class AudioStateUpdate;

class AudioStateRegister;

class SpiStateUpdate;

class SpiStateRegister;

class TunerStateUpdate;

class TunerStateRegister;

class WifiStateUpdate;

class WifiStateRegister;

class OnOffReasonUpdate;

class OnOffReasonRegister;

class WakeupListUpdate;

class WakeupListRegister;

class StartupFinishedUpdate;

class StartupFinishedRegister;

class SysStateUpdate;

class SysStateRegister;

class MostStateUpdate;

class MostStateRegister;

class MostVersionUpdate;

class MostVersionRegister;

class RVCStateUpdate;

class RVCStateRegister;

class TriggerMostRemoteResetUpdate;

class TriggerMostRemoteResetRegister;

class PartnumberUpdate;

class PartnumberRegister;

class PartnumbersUpdate;

class PartnumbersRegister;

class AlphacodeUpdate;

class AlphacodeRegister;

class AlphacodesUpdate;

class AlphacodesRegister;

class ManufacturersEnableCounterUpdate;

class ManufacturersEnableCounterRegister;

class NoCalibrationStateUpdate;

class NoCalibrationStateRegister;

class SecurityCommErrorUpdate;

class SecurityCommErrorRegister;

class SecurityMoreThan10VinUpdate;

class SecurityMoreThan10VinRegister;

class SecurityInvalidVinUpdate;

class SecurityInvalidVinRegister;

class SecurityCurrentVinUpdate;

class SecurityCurrentVinRegister;

class SecurityVinHistoryUpdate;

class SecurityVinHistoryRegister;

class VINUpdate;

class VINRegister;

class SecurityStateUpdate;

class SecurityStateRegister;

class VehicleIDUpdate;

class VehicleIDRegister;

class DisplayVariantUpdate;

class DisplayVariantRegister;

class ReductionLevelUpdate;

class ReductionLevelRegister;

class StartupStateUpdate;

class StartupStateRegister;

class EntertainMuteUpdate;

class EntertainMuteRegister;

class WelcomeAudioStateUpdate;

class WelcomeAudioStateRegister;

class UnballastTimeFromEngineStoppedUpdate;

class UnballastTimeFromEngineStoppedRegister;

class UnballastTimeBeforeUnballastUpdate;

class UnballastTimeBeforeUnballastRegister;

class UnballastWarningTimeUpdate;

class UnballastWarningTimeRegister;

class DegradedCountUpdate;

class DegradedCountRegister;

class DegradedTimeUpdate;

class DegradedTimeRegister;

class PhoneHandoverWarnTimeUpdate;

class PhoneHandoverWarnTimeRegister;

// type definitions
/**
 * If the meaning of "SystemModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemModeError;

/**
 * If the meaning of "DownloadLockStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DownloadLockStateError;

/**
 * If the meaning of "UpdateLockError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateLockError;

/**
 * If the meaning of "OnOffTriggerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnOffTriggerError;

/**
 * If the meaning of "StartProcessError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartProcessError;

/**
 * If the meaning of "StopProcessError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StopProcessError;

/**
 * If the meaning of "RestartProcessError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestartProcessError;

/**
 * If the meaning of "StartUpSyncPointReachedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartUpSyncPointReachedError;

/**
 * If the meaning of "ClearListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClearListError;

/**
 * If the meaning of "RestartSystemError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestartSystemError;

/**
 * If the meaning of "AudioSourceChangeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudioSourceChangeError;

/**
 * If the meaning of "ChangeBluetoothStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChangeBluetoothStateError;

/**
 * If the meaning of "ChangeAudioStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChangeAudioStateError;

/**
 * If the meaning of "ChangeSpiStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChangeSpiStateError;

/**
 * If the meaning of "ChangeTunerStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChangeTunerStateError;

/**
 * If the meaning of "ChangeWifiStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChangeWifiStateError;

/**
 * If the meaning of "ShutdownAndTerminateCcaAppsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ShutdownAndTerminateCcaAppsError;

/**
 * If the meaning of "SetFactorySettingsNewError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetFactorySettingsNewError;

/**
 * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.  (CCA FID: 0x0522)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ClearVINRequest;

/**
 * If the meaning of "ClearVINError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClearVINError;

/**
 * If the meaning of "PrepareDownloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PrepareDownloadError;

/**
 * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.   (CCA FID: 0x0901)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EndDownloadRequest;

/**
 * If the meaning of "EndDownloadError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EndDownloadError;

/**
 * If the meaning of "SetOnConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetOnConfigurationError;

/**
 * If the meaning of "SetProcessConfigurationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetProcessConfigurationError;

/**
 * Method to trigger a demute by HMI.  (CCA FID: 0x1016)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EntertainDeMuteRequest;

/**
 * If the meaning of "EntertainDeMuteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EntertainDeMuteError;

/**
 * Method to trigger a mute by HMI.  (CCA FID: 0x1015)
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage EntertainMuteRequestRequest;

/**
 * If the meaning of "EntertainMuteRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EntertainMuteRequestError;

/**
 * If the meaning of "WelcomeAudioActivationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WelcomeAudioActivationError;

/**
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
 */
typedef SystemStateUpdate SystemStateSet;

/**
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
 */
typedef SystemStateUpdate SystemStateGet;

/**
 * If the meaning of "SystemStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemStateError;

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
 */
typedef DownloadLockStatesUpdate DownloadLockStatesSet;

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
 */
typedef DownloadLockStatesUpdate DownloadLockStatesGet;

/**
 * If the meaning of "DownloadLockStatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DownloadLockStatesError;

/**
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
 */
typedef UpdateLockStatesUpdate UpdateLockStatesSet;

/**
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
 */
typedef UpdateLockStatesUpdate UpdateLockStatesGet;

/**
 * If the meaning of "UpdateLockStatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UpdateLockStatesError;

/**
 * A list of all active trigger. (CCA FID: 0x110f)
 */
typedef ActiveOnOffTriggerUpdate ActiveOnOffTriggerSet;

/**
 * A list of all active trigger. (CCA FID: 0x110f)
 */
typedef ActiveOnOffTriggerUpdate ActiveOnOffTriggerGet;

/**
 * If the meaning of "ActiveOnOffTriggerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveOnOffTriggerError;

/**
 * (CCA FID: 0x000f)
 */
typedef SubStatesUpdate SubStatesSet;

/**
 * (CCA FID: 0x000f)
 */
typedef SubStatesUpdate SubStatesGet;

/**
 * If the meaning of "SubStatesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SubStatesError;

/**
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
 */
typedef HistoryTriggerUpdate HistoryTriggerSet;

/**
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
 */
typedef HistoryTriggerUpdate HistoryTriggerGet;

/**
 * If the meaning of "HistoryTriggerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HistoryTriggerError;

/**
 * Insert key state. (CCA FID: 0x21)
 */
typedef InsertStateUpdate InsertStateSet;

/**
 * Insert key state. (CCA FID: 0x21)
 */
typedef InsertStateUpdate InsertStateGet;

/**
 * If the meaning of "InsertStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InsertStateError;

/**
 * Media Eject key state. (CCA FID: 0x22)
 */
typedef MediaEjectStateUpdate MediaEjectStateSet;

/**
 * Media Eject key state. (CCA FID: 0x22)
 */
typedef MediaEjectStateUpdate MediaEjectStateGet;

/**
 * If the meaning of "MediaEjectStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MediaEjectStateError;

/**
 * State of the hard-wired phone line. (CCA FID: 0x23)
 */
typedef PhoneMuteStateUpdate PhoneMuteStateSet;

/**
 * State of the hard-wired phone line. (CCA FID: 0x23)
 */
typedef PhoneMuteStateUpdate PhoneMuteStateGet;

/**
 * If the meaning of "PhoneMuteStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PhoneMuteStateError;

/**
 * Media Eject key state. (CCA FID: 0x25)
 */
typedef OnTipperStateUpdate OnTipperStateSet;

/**
 * Media Eject key state. (CCA FID: 0x25)
 */
typedef OnTipperStateUpdate OnTipperStateGet;

/**
 * If the meaning of "OnTipperStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnTipperStateError;

/**
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
 */
typedef IgnitionCyclesUpdate IgnitionCyclesSet;

/**
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
 */
typedef IgnitionCyclesUpdate IgnitionCyclesGet;

/**
 * If the meaning of "IgnitionCyclesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IgnitionCyclesError;

/**
 * (CCA FID: 0x0204)
 */
typedef SysPwrModeUpdate SysPwrModeSet;

/**
 * (CCA FID: 0x0204)
 */
typedef SysPwrModeUpdate SysPwrModeGet;

/**
 * If the meaning of "SysPwrModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SysPwrModeError;

/**
 * (CCA FID: 0x0205)
 */
typedef SysPwrSaveModeUpdate SysPwrSaveModeSet;

/**
 * (CCA FID: 0x0205)
 */
typedef SysPwrSaveModeUpdate SysPwrSaveModeGet;

/**
 * If the meaning of "SysPwrSaveModeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SysPwrSaveModeError;

/**
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
 */
typedef MapDownloadLockStateUpdate MapDownloadLockStateSet;

/**
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
 */
typedef MapDownloadLockStateUpdate MapDownloadLockStateGet;

/**
 * If the meaning of "MapDownloadLockStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MapDownloadLockStateError;

/**
 * (CCA FID: 0x05)
 */
typedef StandbyTimeUpdate StandbyTimeSet;

/**
 * (CCA FID: 0x05)
 */
typedef StandbyTimeUpdate StandbyTimeGet;

/**
 * If the meaning of "StandbyTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StandbyTimeError;

/**
 * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
 */
typedef PersitentStandbyTimeUpdate PersitentStandbyTimeSet;

/**
 * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
 */
typedef PersitentStandbyTimeUpdate PersitentStandbyTimeGet;

/**
 * If the meaning of "PersitentStandbyTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PersitentStandbyTimeError;

/**
 * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
 */
typedef IgnitionOffTimeUpdate IgnitionOffTimeSet;

/**
 * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
 */
typedef IgnitionOffTimeUpdate IgnitionOffTimeGet;

/**
 * If the meaning of "IgnitionOffTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IgnitionOffTimeError;

/**
 * Set door open time. (CCA FID: 0x0a)
 */
typedef DoorOpenTimeUpdate DoorOpenTimeSet;

/**
 * Set door open time. (CCA FID: 0x0a)
 */
typedef DoorOpenTimeUpdate DoorOpenTimeGet;

/**
 * If the meaning of "DoorOpenTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DoorOpenTimeError;

/**
 * Set clock display time. (CCA FID: 0x0b)
 */
typedef ClockDisplayTimeUpdate ClockDisplayTimeSet;

/**
 * Set clock display time. (CCA FID: 0x0b)
 */
typedef ClockDisplayTimeUpdate ClockDisplayTimeGet;

/**
 * If the meaning of "ClockDisplayTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ClockDisplayTimeError;

/**
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
 */
typedef SystemStateTimeUpdate SystemStateTimeSet;

/**
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
 */
typedef SystemStateTimeUpdate SystemStateTimeGet;

/**
 * If the meaning of "SystemStateTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemStateTimeError;

/**
 * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
 */
typedef ProcessListUpdate ProcessListSet;

/**
 * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
 */
typedef ProcessListUpdate ProcessListGet;

/**
 * If the meaning of "ProcessListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ProcessListError;

/**
 * (CCA FID: 0x70)
 */
typedef WakeupReasonUpdate WakeupReasonSet;

/**
 * (CCA FID: 0x70)
 */
typedef WakeupReasonUpdate WakeupReasonGet;

/**
 * If the meaning of "WakeupReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WakeupReasonError;

/**
 * (CCA FID: 0x71)
 */
typedef StartupReasonUpdate StartupReasonSet;

/**
 * (CCA FID: 0x71)
 */
typedef StartupReasonUpdate StartupReasonGet;

/**
 * If the meaning of "StartupReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupReasonError;

/**
 * (CCA FID: 0x72)
 */
typedef ConnectToBatteryUpdate ConnectToBatterySet;

/**
 * (CCA FID: 0x72)
 */
typedef ConnectToBatteryUpdate ConnectToBatteryGet;

/**
 * If the meaning of "ConnectToBatteryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectToBatteryError;

/**
 * Current code request state. (CCA FID: 0x60)
 */
typedef CodeRequestStateUpdate CodeRequestStateSet;

/**
 * Current code request state. (CCA FID: 0x60)
 */
typedef CodeRequestStateUpdate CodeRequestStateGet;

/**
 * If the meaning of "CodeRequestStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CodeRequestStateError;

/**
 * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
 */
typedef ActiveStartUpSyncPointsUpdate ActiveStartUpSyncPointsSet;

/**
 * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
 */
typedef ActiveStartUpSyncPointsUpdate ActiveStartUpSyncPointsGet;

/**
 * If the meaning of "ActiveStartUpSyncPointsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ActiveStartUpSyncPointsError;

/**
 * (CCA FID: 0x38)
 */
typedef CvmEventUpdate CvmEventSet;

/**
 * (CCA FID: 0x38)
 */
typedef CvmEventUpdate CvmEventGet;

/**
 * If the meaning of "CvmEventError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CvmEventError;

/**
 * Current measured voltage level in mV. (CCA FID: 0x83)
 */
typedef UBatSenseUpdate UBatSenseSet;

/**
 * Current measured voltage level in mV. (CCA FID: 0x83)
 */
typedef UBatSenseUpdate UBatSenseGet;

/**
 * If the meaning of "UBatSenseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UBatSenseError;

/**
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
 */
typedef CoproStateUpdate CoproStateSet;

/**
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
 */
typedef CoproStateUpdate CoproStateGet;

/**
 * If the meaning of "CoproStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CoproStateError;

/**
 * (CCA FID: 0x18)
 */
typedef DevicePowerOnTimeUpdate DevicePowerOnTimeSet;

/**
 * (CCA FID: 0x18)
 */
typedef DevicePowerOnTimeUpdate DevicePowerOnTimeGet;

/**
 * If the meaning of "DevicePowerOnTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DevicePowerOnTimeError;

/**
 * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
 */
typedef LastSystemRuntimeUpdate LastSystemRuntimeSet;

/**
 * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
 */
typedef LastSystemRuntimeUpdate LastSystemRuntimeGet;

/**
 * If the meaning of "LastSystemRuntimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LastSystemRuntimeError;

/**
 * Time in s the system is currently active. (CCA FID: 0x1101)
 */
typedef CurrentSystemRuntimeUpdate CurrentSystemRuntimeSet;

/**
 * Time in s the system is currently active. (CCA FID: 0x1101)
 */
typedef CurrentSystemRuntimeUpdate CurrentSystemRuntimeGet;

/**
 * If the meaning of "CurrentSystemRuntimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentSystemRuntimeError;

/**
 * (CCA FID: 0x41)
 */
typedef ResetListUpdate ResetListSet;

/**
 * (CCA FID: 0x41)
 */
typedef ResetListUpdate ResetListGet;

/**
 * If the meaning of "ResetListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResetListError;

/**
 * Information about detected reset reasons.  (CCA FID: 0x1041)
 */
typedef ResetCounterUpdate ResetCounterSet;

/**
 * Information about detected reset reasons.  (CCA FID: 0x1041)
 */
typedef ResetCounterUpdate ResetCounterGet;

/**
 * If the meaning of "ResetCounterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResetCounterError;

/**
 * History of recent Transportmode trigger.  (CCA FID: 0x43)
 */
typedef TransportModeListUpdate TransportModeListSet;

/**
 * History of recent Transportmode trigger.  (CCA FID: 0x43)
 */
typedef TransportModeListUpdate TransportModeListGet;

/**
 * If the meaning of "TransportModeListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TransportModeListError;

/**
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
 */
typedef ResetHistoryUpdate ResetHistorySet;

/**
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
 */
typedef ResetHistoryUpdate ResetHistoryGet;

/**
 * If the meaning of "ResetHistoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ResetHistoryError;

/**
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
 */
typedef WakeupHistoryUpdate WakeupHistorySet;

/**
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
 */
typedef WakeupHistoryUpdate WakeupHistoryGet;

/**
 * If the meaning of "WakeupHistoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WakeupHistoryError;

/**
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
 */
typedef StateHistoryUpdate StateHistorySet;

/**
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
 */
typedef StateHistoryUpdate StateHistoryGet;

/**
 * If the meaning of "StateHistoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StateHistoryError;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
 */
typedef ErrStateHistory01Update ErrStateHistory01Set;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
 */
typedef ErrStateHistory01Update ErrStateHistory01Get;

/**
 * If the meaning of "ErrStateHistory01Error" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ErrStateHistory01Error;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
 */
typedef ErrStateHistory02Update ErrStateHistory02Set;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
 */
typedef ErrStateHistory02Update ErrStateHistory02Get;

/**
 * If the meaning of "ErrStateHistory02Error" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ErrStateHistory02Error;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
 */
typedef ErrStateHistory03Update ErrStateHistory03Set;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
 */
typedef ErrStateHistory03Update ErrStateHistory03Get;

/**
 * If the meaning of "ErrStateHistory03Error" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ErrStateHistory03Error;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
 */
typedef ErrStateHistory04Update ErrStateHistory04Set;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
 */
typedef ErrStateHistory04Update ErrStateHistory04Get;

/**
 * If the meaning of "ErrStateHistory04Error" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ErrStateHistory04Error;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
 */
typedef ErrStateHistory05Update ErrStateHistory05Set;

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
 */
typedef ErrStateHistory05Update ErrStateHistory05Get;

/**
 * If the meaning of "ErrStateHistory05Error" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ErrStateHistory05Error;

/**
 * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
 */
typedef SwitchOnHistoryUpdate SwitchOnHistorySet;

/**
 * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
 */
typedef SwitchOnHistoryUpdate SwitchOnHistoryGet;

/**
 * If the meaning of "SwitchOnHistoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SwitchOnHistoryError;

/**
 * (CCA FID: 0x1050)
 */
typedef DeviceOnCounterUpdate DeviceOnCounterSet;

/**
 * (CCA FID: 0x1050)
 */
typedef DeviceOnCounterUpdate DeviceOnCounterGet;

/**
 * If the meaning of "DeviceOnCounterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceOnCounterError;

/**
 * Counts system voltage events. (CCA FID: 0x1051)
 */
typedef VoltageEventCounterUpdate VoltageEventCounterSet;

/**
 * Counts system voltage events. (CCA FID: 0x1051)
 */
typedef VoltageEventCounterUpdate VoltageEventCounterGet;

/**
 * If the meaning of "VoltageEventCounterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoltageEventCounterError;

/**
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
 */
typedef VoltageRangeHistogramUpdate VoltageRangeHistogramSet;

/**
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
 */
typedef VoltageRangeHistogramUpdate VoltageRangeHistogramGet;

/**
 * If the meaning of "VoltageRangeHistogramError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VoltageRangeHistogramError;

/**
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
 */
typedef CpuUsageStatisticUpdate CpuUsageStatisticSet;

/**
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
 */
typedef CpuUsageStatisticUpdate CpuUsageStatisticGet;

/**
 * If the meaning of "CpuUsageStatisticError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CpuUsageStatisticError;

/**
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
 */
typedef RamUsageStatisticUpdate RamUsageStatisticSet;

/**
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
 */
typedef RamUsageStatisticUpdate RamUsageStatisticGet;

/**
 * If the meaning of "RamUsageStatisticError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RamUsageStatisticError;

/**
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
 */
typedef StartupTimeStatisticUpdate StartupTimeStatisticSet;

/**
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
 */
typedef StartupTimeStatisticUpdate StartupTimeStatisticGet;

/**
 * If the meaning of "StartupTimeStatisticError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupTimeStatisticError;

/**
 * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
 */
typedef RunlevelStateUpdate RunlevelStateSet;

/**
 * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
 */
typedef RunlevelStateUpdate RunlevelStateGet;

/**
 * If the meaning of "RunlevelStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RunlevelStateError;

/**
 * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
 */
typedef RestartUpdate RestartSet;

/**
 * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
 */
typedef RestartUpdate RestartGet;

/**
 * If the meaning of "RestartError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RestartError;

/**
 * (CCA FID: 0x0275)
 */
typedef LifesignUpdate LifesignSet;

/**
 * (CCA FID: 0x0275)
 */
typedef LifesignUpdate LifesignGet;

/**
 * If the meaning of "LifesignError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError LifesignError;

/**
 * Set substate of the HMI application.  (CCA FID: 0x10)
 */
typedef HmiStateUpdate HmiStateSet;

/**
 * Set substate of the HMI application.  (CCA FID: 0x10)
 */
typedef HmiStateUpdate HmiStateGet;

/**
 * If the meaning of "HmiStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HmiStateError;

/**
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
 */
typedef SystemPowerBehaviourUpdate SystemPowerBehaviourSet;

/**
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
 */
typedef SystemPowerBehaviourUpdate SystemPowerBehaviourGet;

/**
 * If the meaning of "SystemPowerBehaviourError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SystemPowerBehaviourError;

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
 */
typedef DimStateUpdate DimStateSet;

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
 */
typedef DimStateUpdate DimStateGet;

/**
 * If the meaning of "DimStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DimStateError;

/**
 * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
 */
typedef DimmingStateUpdate DimmingStateSet;

/**
 * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
 */
typedef DimmingStateUpdate DimmingStateGet;

/**
 * If the meaning of "DimmingStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DimmingStateError;

/**
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
 */
typedef BluetoothStateUpdate BluetoothStateSet;

/**
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
 */
typedef BluetoothStateUpdate BluetoothStateGet;

/**
 * If the meaning of "BluetoothStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BluetoothStateError;

/**
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
 */
typedef AudioStateUpdate AudioStateSet;

/**
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
 */
typedef AudioStateUpdate AudioStateGet;

/**
 * If the meaning of "AudioStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AudioStateError;

/**
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
 */
typedef SpiStateUpdate SpiStateSet;

/**
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
 */
typedef SpiStateUpdate SpiStateGet;

/**
 * If the meaning of "SpiStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SpiStateError;

/**
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
 */
typedef TunerStateUpdate TunerStateSet;

/**
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
 */
typedef TunerStateUpdate TunerStateGet;

/**
 * If the meaning of "TunerStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TunerStateError;

/**
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
 */
typedef WifiStateUpdate WifiStateSet;

/**
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
 */
typedef WifiStateUpdate WifiStateGet;

/**
 * If the meaning of "WifiStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WifiStateError;

/**
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
 */
typedef OnOffReasonUpdate OnOffReasonSet;

/**
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
 */
typedef OnOffReasonUpdate OnOffReasonGet;

/**
 * If the meaning of "OnOffReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError OnOffReasonError;

/**
 * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
 */
typedef WakeupListUpdate WakeupListSet;

/**
 * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
 */
typedef WakeupListUpdate WakeupListGet;

/**
 * If the meaning of "WakeupListError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WakeupListError;

/**
 * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
 */
typedef StartupFinishedUpdate StartupFinishedSet;

/**
 * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
 */
typedef StartupFinishedUpdate StartupFinishedGet;

/**
 * If the meaning of "StartupFinishedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupFinishedError;

/**
 * Set substate of the HMI application.  (CCA FID: 0x0302)
 */
typedef SysStateUpdate SysStateSet;

/**
 * Set substate of the HMI application.  (CCA FID: 0x0302)
 */
typedef SysStateUpdate SysStateGet;

/**
 * If the meaning of "SysStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SysStateError;

/**
 * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
 */
typedef MostStateUpdate MostStateSet;

/**
 * The CMA (CCA Most Adapter) shall be the only component which handles this MOST event.  (CCA FID: 0x0303)
 */
typedef MostStateUpdate MostStateGet;

/**
 * If the meaning of "MostStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MostStateError;

/**
 * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
 */
typedef MostVersionUpdate MostVersionSet;

/**
 * The MOST version of the MOST stack used in the system  (CCA FID: 0x0304)
 */
typedef MostVersionUpdate MostVersionGet;

/**
 * If the meaning of "MostVersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MostVersionError;

/**
 * Rear View Camera state of the system  (CCA FID: 0x0235)
 */
typedef RVCStateUpdate RVCStateSet;

/**
 * Rear View Camera state of the system  (CCA FID: 0x0235)
 */
typedef RVCStateUpdate RVCStateGet;

/**
 * If the meaning of "RVCStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RVCStateError;

/**
 * (CCA FID: 0x0701)
 */
typedef TriggerMostRemoteResetUpdate TriggerMostRemoteResetSet;

/**
 * (CCA FID: 0x0701)
 */
typedef TriggerMostRemoteResetUpdate TriggerMostRemoteResetGet;

/**
 * If the meaning of "TriggerMostRemoteResetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TriggerMostRemoteResetError;

/**
 * (CCA FID: 0x0702)
 */
typedef PartnumberUpdate PartnumberSet;

/**
 * (CCA FID: 0x0702)
 */
typedef PartnumberUpdate PartnumberGet;

/**
 * If the meaning of "PartnumberError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PartnumberError;

/**
 * (CCA FID: 0x0703)
 */
typedef PartnumbersUpdate PartnumbersSet;

/**
 * (CCA FID: 0x0703)
 */
typedef PartnumbersUpdate PartnumbersGet;

/**
 * If the meaning of "PartnumbersError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PartnumbersError;

/**
 * (CCA FID: 0x0704)
 */
typedef AlphacodeUpdate AlphacodeSet;

/**
 * (CCA FID: 0x0704)
 */
typedef AlphacodeUpdate AlphacodeGet;

/**
 * If the meaning of "AlphacodeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AlphacodeError;

/**
 * (CCA FID: 0x0705)
 */
typedef AlphacodesUpdate AlphacodesSet;

/**
 * (CCA FID: 0x0705)
 */
typedef AlphacodesUpdate AlphacodesGet;

/**
 * If the meaning of "AlphacodesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AlphacodesError;

/**
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
 */
typedef ManufacturersEnableCounterUpdate ManufacturersEnableCounterSet;

/**
 * This property is used to set/get the Manufacturer's Enable Counter (InternalMEC).  (CCA FID: 0x0604)
 */
typedef ManufacturersEnableCounterUpdate ManufacturersEnableCounterGet;

/**
 * If the meaning of "ManufacturersEnableCounterError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ManufacturersEnableCounterError;

/**
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
 */
typedef NoCalibrationStateUpdate NoCalibrationStateSet;

/**
 * This property is used to inform the FC SPM about the No Calibration State of Maintenance (FC DIAGNOSIS). (CCA FID: 0x0605)
 */
typedef NoCalibrationStateUpdate NoCalibrationStateGet;

/**
 * If the meaning of "NoCalibrationStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NoCalibrationStateError;

/**
 * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
 */
typedef SecurityCommErrorUpdate SecurityCommErrorSet;

/**
 * Communication error count detected by SPM security component. FUNCID = FID_SPM_SEC_COMM_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x84)
 */
typedef SecurityCommErrorUpdate SecurityCommErrorGet;

/**
 * If the meaning of "SecurityCommErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityCommErrorError;

/**
 * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
 */
typedef SecurityMoreThan10VinUpdate SecurityMoreThan10VinSet;

/**
 * More than 10 VINs detected by SPM security component. FUNCID = FID_SPM_SEC_MORE_10VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x85)
 */
typedef SecurityMoreThan10VinUpdate SecurityMoreThan10VinGet;

/**
 * If the meaning of "SecurityMoreThan10VinError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityMoreThan10VinError;

/**
 * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
 */
typedef SecurityInvalidVinUpdate SecurityInvalidVinSet;

/**
 * Number of invalid VINs detected by SPM security component. FUNCID = FID_SPM_SEC_INVALID_VIN_ERROR, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x86)
 */
typedef SecurityInvalidVinUpdate SecurityInvalidVinGet;

/**
 * If the meaning of "SecurityInvalidVinError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityInvalidVinError;

/**
 * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
 */
typedef SecurityCurrentVinUpdate SecurityCurrentVinSet;

/**
 * Current VIN detected by SPM security component (17 bytes). FUNCID = FID_SPM_SEC_CURRENT_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x87)
 */
typedef SecurityCurrentVinUpdate SecurityCurrentVinGet;

/**
 * If the meaning of "SecurityCurrentVinError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityCurrentVinError;

/**
 * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
 */
typedef SecurityVinHistoryUpdate SecurityVinHistorySet;

/**
 * List of received VINs detected by SPM security component. FUNCID = FID_SPM_SEC_VIN_HISTORY, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x88)
 */
typedef SecurityVinHistoryUpdate SecurityVinHistoryGet;

/**
 * If the meaning of "SecurityVinHistoryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityVinHistoryError;

/**
 * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
 */
typedef VINUpdate VINSet;

/**
 * Vehicle Identification Number. FUNCID = FID_SPM_VIN, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= ...  (CCA FID: 0x0521)
 */
typedef VINUpdate VINGet;

/**
 * If the meaning of "VINError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VINError;

/**
 * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
 */
typedef SecurityStateUpdate SecurityStateSet;

/**
 * The SPM tells registered clients the current security state of the system.  (CCA FID: 0x0523)
 */
typedef SecurityStateUpdate SecurityStateGet;

/**
 * If the meaning of "SecurityStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SecurityStateError;

/**
 * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
 */
typedef VehicleIDUpdate VehicleIDSet;

/**
 * Current stored Vehicle ID (4 Byte value --> similar to string based VIN).  (CCA FID: 0x0524)
 */
typedef VehicleIDUpdate VehicleIDGet;

/**
 * If the meaning of "VehicleIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VehicleIDError;

/**
 * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
 */
typedef DisplayVariantUpdate DisplayVariantSet;

/**
 * Sets the given display variant number in the datapool and performs a restart of the system. FUNCID = FID_SPM_DISPLAY_VARIANT, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	=  (CCA FID: 0x0406)
 */
typedef DisplayVariantUpdate DisplayVariantGet;

/**
 * If the meaning of "DisplayVariantError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayVariantError;

/**
 * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
 */
typedef ReductionLevelUpdate ReductionLevelSet;

/**
 * The reduction level is used to tell components to provide normal operation or a reduced operation level.  (CCA FID: 0x0802)
 */
typedef ReductionLevelUpdate ReductionLevelGet;

/**
 * If the meaning of "ReductionLevelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReductionLevelError;

/**
 * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
 */
typedef StartupStateUpdate StartupStateSet;

/**
 * Informs about current startup state. All applications of one sw block acknowledged the state "Initialized".  (CCA FID: 0x03)
 */
typedef StartupStateUpdate StartupStateGet;

/**
 * If the meaning of "StartupStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StartupStateError;

/**
 * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
 */
typedef EntertainMuteUpdate EntertainMuteSet;

/**
 * NISSAN related mute handling. SPM handles Tipper and calculates MuteState. HMI has to follow mute state.  (CCA FID: 0x16)
 */
typedef EntertainMuteUpdate EntertainMuteGet;

/**
 * If the meaning of "EntertainMuteError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError EntertainMuteError;

/**
 * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
 */
typedef WelcomeAudioStateUpdate WelcomeAudioStateSet;

/**
 * Welcome audio is currently enabled or not.  (CCA FID: 0x2026)
 */
typedef WelcomeAudioStateUpdate WelcomeAudioStateGet;

/**
 * If the meaning of "WelcomeAudioStateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError WelcomeAudioStateError;

/**
 * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
 */
typedef UnballastTimeFromEngineStoppedUpdate UnballastTimeFromEngineStoppedSet;

/**
 * Timer which starts when engine is not running before unballast.  (CCA FID: 0x760)
 */
typedef UnballastTimeFromEngineStoppedUpdate UnballastTimeFromEngineStoppedGet;

/**
 * If the meaning of "UnballastTimeFromEngineStoppedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnballastTimeFromEngineStoppedError;

/**
 * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
 */
typedef UnballastTimeBeforeUnballastUpdate UnballastTimeBeforeUnballastSet;

/**
 * Time before unballast. Configuration parameter.  (CCA FID: 0x761)
 */
typedef UnballastTimeBeforeUnballastUpdate UnballastTimeBeforeUnballastGet;

/**
 * If the meaning of "UnballastTimeBeforeUnballastError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnballastTimeBeforeUnballastError;

/**
 * Time warning message is displayed.  (CCA FID: 0x762)
 */
typedef UnballastWarningTimeUpdate UnballastWarningTimeSet;

/**
 * Time warning message is displayed.  (CCA FID: 0x762)
 */
typedef UnballastWarningTimeUpdate UnballastWarningTimeGet;

/**
 * If the meaning of "UnballastWarningTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError UnballastWarningTimeError;

/**
 * Number of Unballast trigger.  (CCA FID: 0x763)
 */
typedef DegradedCountUpdate DegradedCountSet;

/**
 * Number of Unballast trigger.  (CCA FID: 0x763)
 */
typedef DegradedCountUpdate DegradedCountGet;

/**
 * If the meaning of "DegradedCountError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DegradedCountError;

/**
 * Accumulated time in Unballast situation.  (CCA FID: 0x764)
 */
typedef DegradedTimeUpdate DegradedTimeSet;

/**
 * Accumulated time in Unballast situation.  (CCA FID: 0x764)
 */
typedef DegradedTimeUpdate DegradedTimeGet;

/**
 * If the meaning of "DegradedTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DegradedTimeError;

/**
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
 */
typedef PhoneHandoverWarnTimeUpdate PhoneHandoverWarnTimeSet;

/**
 * Time in seconds before the system shutdown starts. Trigger "SPM_U32_SYSPWR_PHONE_HANDOVER_WARN" via property "SystemPowerBehaviour" will be send only if a phone call is active. (CCA FID: 0x1018)
 */
typedef PhoneHandoverWarnTimeUpdate PhoneHandoverWarnTimeGet;

/**
 * If the meaning of "PhoneHandoverWarnTimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PhoneHandoverWarnTimeError;


/**
 * If the meaning of "TSubStates" isn't clear, then there should be a description here.
 */
class TSubStates {
public:

    /**
     * Default constructor
     */
    inline  TSubStates ();

    /**
     * Copy constructor
     */
    inline  TSubStates (const TSubStates &rhs);

    /**
     * All fields constructor
     */
    inline  TSubStates (uint32 SubState_, uint32 HwSubState_, uint32 InternSubState_);

    /**
     * Destructor
     */
    inline  ~TSubStates();

    /**
     * Assignment operator
     */
    inline TSubStates& operator = (const TSubStates& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TSubStates& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TSubStates& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TSubStates& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TSubStates& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubState"

    static const int kSubState = 0;

    /**
     * Clears the field "SubState".
     *
     * The field will be set to its default value. The hasSubState()
     * method will return false.
     */
    inline void clearSubState();

    /**
     * Checks whether the field "SubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubState()). Otherwise it will return false.
     */
    inline bool hasSubState () const;

    /**
     * Returns the value of the member "SubState".
     *
     *
     *
     * @return The value of the field "SubState"
     */
    inline uint32 getSubState () const;

    /**
     * Sets the value of the member "SubState".
     *
     *
     *
     * @param SubState The value which will be set
     */
    inline void setSubState (uint32 SubState_);

    // API of field "HwSubState"

    static const int kHwSubState = 1;

    /**
     * Clears the field "HwSubState".
     *
     * The field will be set to its default value. The hasHwSubState()
     * method will return false.
     */
    inline void clearHwSubState();

    /**
     * Checks whether the field "HwSubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHwSubState()). Otherwise it will return false.
     */
    inline bool hasHwSubState () const;

    /**
     * Returns the value of the member "HwSubState".
     *
     *
     *
     * @return The value of the field "HwSubState"
     */
    inline uint32 getHwSubState () const;

    /**
     * Sets the value of the member "HwSubState".
     *
     *
     *
     * @param HwSubState The value which will be set
     */
    inline void setHwSubState (uint32 HwSubState_);

    // API of field "InternSubState"

    static const int kInternSubState = 2;

    /**
     * Clears the field "InternSubState".
     *
     * The field will be set to its default value. The hasInternSubState()
     * method will return false.
     */
    inline void clearInternSubState();

    /**
     * Checks whether the field "InternSubState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInternSubState()). Otherwise it will return false.
     */
    inline bool hasInternSubState () const;

    /**
     * Returns the value of the member "InternSubState".
     *
     *
     *
     * @return The value of the field "InternSubState"
     */
    inline uint32 getInternSubState () const;

    /**
     * Sets the value of the member "InternSubState".
     *
     *
     *
     * @param InternSubState The value which will be set
     */
    inline void setInternSubState (uint32 InternSubState_);

    static const TSubStates &getDefaultInstance();

private:

    inline void set_has_SubState ();

    inline void clear_has_SubState ();

    inline void set_has_HwSubState ();

    inline void clear_has_HwSubState ();

    inline void set_has_InternSubState ();

    inline void clear_has_InternSubState ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _SubState;

    uint32 _HwSubState;

    uint32 _InternSubState;

};

/**
 * If the meaning of "TSystemStateTime" isn't clear, then there should be a description here.
 */
class TSystemStateTime {
public:

    /**
     * Default constructor
     */
    inline  TSystemStateTime ();

    /**
     * Copy constructor
     */
    inline  TSystemStateTime (const TSystemStateTime &rhs);

    /**
     * All fields constructor
     */
    inline  TSystemStateTime (T_SPM_e32_SYSTEM_STATES tSystemState_, uint32 tStateTimerValue_);

    /**
     * Destructor
     */
    inline  ~TSystemStateTime();

    /**
     * Assignment operator
     */
    inline TSystemStateTime& operator = (const TSystemStateTime& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TSystemStateTime& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TSystemStateTime& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TSystemStateTime& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TSystemStateTime& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSystemState"

    static const int kTSystemState = 0;

    /**
     * Clears the field "tSystemState".
     *
     * The field will be set to its default value. The hasTSystemState()
     * method will return false.
     */
    inline void clearTSystemState();

    /**
     * Checks whether the field "tSystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSystemState()). Otherwise it will return false.
     */
    inline bool hasTSystemState () const;

    /**
     * Returns the value of the member "tSystemState".
     *
     *
     *
     * @return The value of the field "tSystemState"
     */
    inline T_SPM_e32_SYSTEM_STATES getTSystemState () const;

    /**
     * Sets the value of the member "tSystemState".
     *
     *
     *
     * @param tSystemState The value which will be set
     */
    inline void setTSystemState (T_SPM_e32_SYSTEM_STATES tSystemState_);

    // API of field "tStateTimerValue"

    static const int kTStateTimerValue = 1;

    /**
     * Clears the field "tStateTimerValue".
     *
     * The field will be set to its default value. The hasTStateTimerValue()
     * method will return false.
     */
    inline void clearTStateTimerValue();

    /**
     * Checks whether the field "tStateTimerValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTStateTimerValue()). Otherwise it will return false.
     */
    inline bool hasTStateTimerValue () const;

    /**
     * Returns the value of the member "tStateTimerValue".
     *
     * Timeout value in seconds.
     *
     * @return The value of the field "tStateTimerValue"
     */
    inline uint32 getTStateTimerValue () const;

    /**
     * Sets the value of the member "tStateTimerValue".
     *
     * Timeout value in seconds.
     *
     * @param tStateTimerValue The value which will be set
     */
    inline void setTStateTimerValue (uint32 tStateTimerValue_);

    static const TSystemStateTime &getDefaultInstance();

private:

    inline void set_has_tSystemState ();

    inline void clear_has_tSystemState ();

    inline void set_has_tStateTimerValue ();

    inline void clear_has_tStateTimerValue ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_SPM_e32_SYSTEM_STATES _tSystemState;

    uint32 _tStateTimerValue;

};

/**
 * If the meaning of "TConnectToBattery" isn't clear, then there should be a description here.
 */
class TConnectToBattery {
public:

    /**
     * Default constructor
     */
    inline  TConnectToBattery ();

    /**
     * Copy constructor
     */
    inline  TConnectToBattery (const TConnectToBattery &rhs);

    /**
     * All fields constructor
     */
    inline  TConnectToBattery (bool ConnectToBatteryState_, uint16 ConnectToBatteryCount_);

    /**
     * Destructor
     */
    inline  ~TConnectToBattery();

    /**
     * Assignment operator
     */
    inline TConnectToBattery& operator = (const TConnectToBattery& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TConnectToBattery& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TConnectToBattery& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TConnectToBattery& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TConnectToBattery& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectToBatteryState"

    static const int kConnectToBatteryState = 0;

    /**
     * Clears the field "ConnectToBatteryState".
     *
     * The field will be set to its default value. The hasConnectToBatteryState()
     * method will return false.
     */
    inline void clearConnectToBatteryState();

    /**
     * Checks whether the field "ConnectToBatteryState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectToBatteryState()). Otherwise it will return false.
     */
    inline bool hasConnectToBatteryState () const;

    /**
     * Returns the value of the member "ConnectToBatteryState".
     *
     * Connected to battery is detected.
     *
     * @return The value of the field "ConnectToBatteryState"
     */
    inline bool getConnectToBatteryState () const;

    /**
     * Sets the value of the member "ConnectToBatteryState".
     *
     * Connected to battery is detected.
     *
     * @param ConnectToBatteryState The value which will be set
     */
    inline void setConnectToBatteryState (bool ConnectToBatteryState_);

    // API of field "ConnectToBatteryCount"

    static const int kConnectToBatteryCount = 1;

    /**
     * Clears the field "ConnectToBatteryCount".
     *
     * The field will be set to its default value. The hasConnectToBatteryCount()
     * method will return false.
     */
    inline void clearConnectToBatteryCount();

    /**
     * Checks whether the field "ConnectToBatteryCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectToBatteryCount()). Otherwise it will return false.
     */
    inline bool hasConnectToBatteryCount () const;

    /**
     * Returns the value of the member "ConnectToBatteryCount".
     *
     * Connect to battery count.
     *
     * @return The value of the field "ConnectToBatteryCount"
     */
    inline uint16 getConnectToBatteryCount () const;

    /**
     * Sets the value of the member "ConnectToBatteryCount".
     *
     * Connect to battery count.
     *
     * @param ConnectToBatteryCount The value which will be set
     */
    inline void setConnectToBatteryCount (uint16 ConnectToBatteryCount_);

    static const TConnectToBattery &getDefaultInstance();

private:

    inline void set_has_ConnectToBatteryState ();

    inline void clear_has_ConnectToBatteryState ();

    inline void set_has_ConnectToBatteryCount ();

    inline void clear_has_ConnectToBatteryCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _ConnectToBatteryState;

    uint16 _ConnectToBatteryCount;

};

/**
 * If the meaning of "TResetList" isn't clear, then there should be a description here.
 */
class TResetList {
public:

    /**
     * Default constructor
     */
    inline  TResetList ();

    /**
     * Copy constructor
     */
    inline  TResetList (const TResetList &rhs);

    /**
     * All fields constructor
     */
    inline  TResetList (T_e8_LcmResetReason LastResetReason_, uint8 DateHour_, uint8 DateMinute_, uint8 DateDay_, uint8 DateMonth_, uint16 DateYear_, uint8 CoproResetByHmi_, uint8 CoproResetByUndervoltage_, uint8 HmiResetByCoproStartup_, uint8 HmiResetByCoproRun_, uint8 HmiResetByCoproShutdown_, uint8 HmiResetByHmiWdg_, uint8 HmiResetByHmiApp_, uint8 HmiResetByHmiException_, uint8 HmiResetByHmiExtern_, uint8 HmiResetByHmiDownload_, uint8 HmiResetByHmiDiag_, uint8 FgsResetByHmi_);

    /**
     * Destructor
     */
    inline  ~TResetList();

    /**
     * Assignment operator
     */
    inline TResetList& operator = (const TResetList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TResetList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TResetList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TResetList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TResetList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LastResetReason"

    static const int kLastResetReason = 0;

    /**
     * Clears the field "LastResetReason".
     *
     * The field will be set to its default value. The hasLastResetReason()
     * method will return false.
     */
    inline void clearLastResetReason();

    /**
     * Checks whether the field "LastResetReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastResetReason()). Otherwise it will return false.
     */
    inline bool hasLastResetReason () const;

    /**
     * Returns the value of the member "LastResetReason".
     *
     * last detected reset reason
     *
     * @return The value of the field "LastResetReason"
     */
    inline T_e8_LcmResetReason getLastResetReason () const;

    /**
     * Sets the value of the member "LastResetReason".
     *
     * last detected reset reason
     *
     * @param LastResetReason The value which will be set
     */
    inline void setLastResetReason (T_e8_LcmResetReason LastResetReason_);

    // API of field "DateHour"

    static const int kDateHour = 1;

    /**
     * Clears the field "DateHour".
     *
     * The field will be set to its default value. The hasDateHour()
     * method will return false.
     */
    inline void clearDateHour();

    /**
     * Checks whether the field "DateHour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateHour()). Otherwise it will return false.
     */
    inline bool hasDateHour () const;

    /**
     * Returns the value of the member "DateHour".
     *
     * Date: hour format HH:mm dd.mm.yyyy
     *
     * @return The value of the field "DateHour"
     */
    inline uint8 getDateHour () const;

    /**
     * Sets the value of the member "DateHour".
     *
     * Date: hour format HH:mm dd.mm.yyyy
     *
     * @param DateHour The value which will be set
     */
    inline void setDateHour (uint8 DateHour_);

    // API of field "DateMinute"

    static const int kDateMinute = 2;

    /**
     * Clears the field "DateMinute".
     *
     * The field will be set to its default value. The hasDateMinute()
     * method will return false.
     */
    inline void clearDateMinute();

    /**
     * Checks whether the field "DateMinute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateMinute()). Otherwise it will return false.
     */
    inline bool hasDateMinute () const;

    /**
     * Returns the value of the member "DateMinute".
     *
     * Date: minute format hh:MM dd.mm.yyyy
     *
     * @return The value of the field "DateMinute"
     */
    inline uint8 getDateMinute () const;

    /**
     * Sets the value of the member "DateMinute".
     *
     * Date: minute format hh:MM dd.mm.yyyy
     *
     * @param DateMinute The value which will be set
     */
    inline void setDateMinute (uint8 DateMinute_);

    // API of field "DateDay"

    static const int kDateDay = 3;

    /**
     * Clears the field "DateDay".
     *
     * The field will be set to its default value. The hasDateDay()
     * method will return false.
     */
    inline void clearDateDay();

    /**
     * Checks whether the field "DateDay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateDay()). Otherwise it will return false.
     */
    inline bool hasDateDay () const;

    /**
     * Returns the value of the member "DateDay".
     *
     * Date: Day format hh:mm DD.mm.yyyy
     *
     * @return The value of the field "DateDay"
     */
    inline uint8 getDateDay () const;

    /**
     * Sets the value of the member "DateDay".
     *
     * Date: Day format hh:mm DD.mm.yyyy
     *
     * @param DateDay The value which will be set
     */
    inline void setDateDay (uint8 DateDay_);

    // API of field "DateMonth"

    static const int kDateMonth = 4;

    /**
     * Clears the field "DateMonth".
     *
     * The field will be set to its default value. The hasDateMonth()
     * method will return false.
     */
    inline void clearDateMonth();

    /**
     * Checks whether the field "DateMonth" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateMonth()). Otherwise it will return false.
     */
    inline bool hasDateMonth () const;

    /**
     * Returns the value of the member "DateMonth".
     *
     * Date: month format hh:mm dd.MM.yyyy
     *
     * @return The value of the field "DateMonth"
     */
    inline uint8 getDateMonth () const;

    /**
     * Sets the value of the member "DateMonth".
     *
     * Date: month format hh:mm dd.MM.yyyy
     *
     * @param DateMonth The value which will be set
     */
    inline void setDateMonth (uint8 DateMonth_);

    // API of field "DateYear"

    static const int kDateYear = 5;

    /**
     * Clears the field "DateYear".
     *
     * The field will be set to its default value. The hasDateYear()
     * method will return false.
     */
    inline void clearDateYear();

    /**
     * Checks whether the field "DateYear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDateYear()). Otherwise it will return false.
     */
    inline bool hasDateYear () const;

    /**
     * Returns the value of the member "DateYear".
     *
     * Date: year format hh:mm dd.mm.YYYY
     *
     * @return The value of the field "DateYear"
     */
    inline uint16 getDateYear () const;

    /**
     * Sets the value of the member "DateYear".
     *
     * Date: year format hh:mm dd.mm.YYYY
     *
     * @param DateYear The value which will be set
     */
    inline void setDateYear (uint16 DateYear_);

    // API of field "CoproResetByHmi"

    static const int kCoproResetByHmi = 6;

    /**
     * Clears the field "CoproResetByHmi".
     *
     * The field will be set to its default value. The hasCoproResetByHmi()
     * method will return false.
     */
    inline void clearCoproResetByHmi();

    /**
     * Checks whether the field "CoproResetByHmi" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproResetByHmi()). Otherwise it will return false.
     */
    inline bool hasCoproResetByHmi () const;

    /**
     * Returns the value of the member "CoproResetByHmi".
     *
     * Count of all Copro resets triggered by HMI.
     *
     * @return The value of the field "CoproResetByHmi"
     */
    inline uint8 getCoproResetByHmi () const;

    /**
     * Sets the value of the member "CoproResetByHmi".
     *
     * Count of all Copro resets triggered by HMI.
     *
     * @param CoproResetByHmi The value which will be set
     */
    inline void setCoproResetByHmi (uint8 CoproResetByHmi_);

    // API of field "CoproResetByUndervoltage"

    static const int kCoproResetByUndervoltage = 7;

    /**
     * Clears the field "CoproResetByUndervoltage".
     *
     * The field will be set to its default value. The hasCoproResetByUndervoltage()
     * method will return false.
     */
    inline void clearCoproResetByUndervoltage();

    /**
     * Checks whether the field "CoproResetByUndervoltage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproResetByUndervoltage()). Otherwise it will return false.
     */
    inline bool hasCoproResetByUndervoltage () const;

    /**
     * Returns the value of the member "CoproResetByUndervoltage".
     *
     * Count of all Copro resets caused by undervoltage.
     *
     * @return The value of the field "CoproResetByUndervoltage"
     */
    inline uint8 getCoproResetByUndervoltage () const;

    /**
     * Sets the value of the member "CoproResetByUndervoltage".
     *
     * Count of all Copro resets caused by undervoltage.
     *
     * @param CoproResetByUndervoltage The value which will be set
     */
    inline void setCoproResetByUndervoltage (uint8 CoproResetByUndervoltage_);

    // API of field "HmiResetByCoproStartup"

    static const int kHmiResetByCoproStartup = 8;

    /**
     * Clears the field "HmiResetByCoproStartup".
     *
     * The field will be set to its default value. The hasHmiResetByCoproStartup()
     * method will return false.
     */
    inline void clearHmiResetByCoproStartup();

    /**
     * Checks whether the field "HmiResetByCoproStartup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByCoproStartup()). Otherwise it will return false.
     */
    inline bool hasHmiResetByCoproStartup () const;

    /**
     * Returns the value of the member "HmiResetByCoproStartup".
     *
     * Count of all in the startup detected resets triggered by the Copro.
     *
     * @return The value of the field "HmiResetByCoproStartup"
     */
    inline uint8 getHmiResetByCoproStartup () const;

    /**
     * Sets the value of the member "HmiResetByCoproStartup".
     *
     * Count of all in the startup detected resets triggered by the Copro.
     *
     * @param HmiResetByCoproStartup The value which will be set
     */
    inline void setHmiResetByCoproStartup (uint8 HmiResetByCoproStartup_);

    // API of field "HmiResetByCoproRun"

    static const int kHmiResetByCoproRun = 9;

    /**
     * Clears the field "HmiResetByCoproRun".
     *
     * The field will be set to its default value. The hasHmiResetByCoproRun()
     * method will return false.
     */
    inline void clearHmiResetByCoproRun();

    /**
     * Checks whether the field "HmiResetByCoproRun" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByCoproRun()). Otherwise it will return false.
     */
    inline bool hasHmiResetByCoproRun () const;

    /**
     * Returns the value of the member "HmiResetByCoproRun".
     *
     * Count of all in normal running mode detected resets triggered by the Copro.
     *
     * @return The value of the field "HmiResetByCoproRun"
     */
    inline uint8 getHmiResetByCoproRun () const;

    /**
     * Sets the value of the member "HmiResetByCoproRun".
     *
     * Count of all in normal running mode detected resets triggered by the Copro.
     *
     * @param HmiResetByCoproRun The value which will be set
     */
    inline void setHmiResetByCoproRun (uint8 HmiResetByCoproRun_);

    // API of field "HmiResetByCoproShutdown"

    static const int kHmiResetByCoproShutdown = 10;

    /**
     * Clears the field "HmiResetByCoproShutdown".
     *
     * The field will be set to its default value. The hasHmiResetByCoproShutdown()
     * method will return false.
     */
    inline void clearHmiResetByCoproShutdown();

    /**
     * Checks whether the field "HmiResetByCoproShutdown" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByCoproShutdown()). Otherwise it will return false.
     */
    inline bool hasHmiResetByCoproShutdown () const;

    /**
     * Returns the value of the member "HmiResetByCoproShutdown".
     *
     * Count of all in the shutdown detected resets triggered by the Copro.
     *
     * @return The value of the field "HmiResetByCoproShutdown"
     */
    inline uint8 getHmiResetByCoproShutdown () const;

    /**
     * Sets the value of the member "HmiResetByCoproShutdown".
     *
     * Count of all in the shutdown detected resets triggered by the Copro.
     *
     * @param HmiResetByCoproShutdown The value which will be set
     */
    inline void setHmiResetByCoproShutdown (uint8 HmiResetByCoproShutdown_);

    // API of field "HmiResetByHmiWdg"

    static const int kHmiResetByHmiWdg = 11;

    /**
     * Clears the field "HmiResetByHmiWdg".
     *
     * The field will be set to its default value. The hasHmiResetByHmiWdg()
     * method will return false.
     */
    inline void clearHmiResetByHmiWdg();

    /**
     * Checks whether the field "HmiResetByHmiWdg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiWdg()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiWdg () const;

    /**
     * Returns the value of the member "HmiResetByHmiWdg".
     *
     * Count of all ApplicationProcessor watchdog resets.
     *
     * @return The value of the field "HmiResetByHmiWdg"
     */
    inline uint8 getHmiResetByHmiWdg () const;

    /**
     * Sets the value of the member "HmiResetByHmiWdg".
     *
     * Count of all ApplicationProcessor watchdog resets.
     *
     * @param HmiResetByHmiWdg The value which will be set
     */
    inline void setHmiResetByHmiWdg (uint8 HmiResetByHmiWdg_);

    // API of field "HmiResetByHmiApp"

    static const int kHmiResetByHmiApp = 12;

    /**
     * Clears the field "HmiResetByHmiApp".
     *
     * The field will be set to its default value. The hasHmiResetByHmiApp()
     * method will return false.
     */
    inline void clearHmiResetByHmiApp();

    /**
     * Checks whether the field "HmiResetByHmiApp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiApp()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiApp () const;

    /**
     * Returns the value of the member "HmiResetByHmiApp".
     *
     * Count of all ApplicationProcessor resets caused by application fault.
     *
     * @return The value of the field "HmiResetByHmiApp"
     */
    inline uint8 getHmiResetByHmiApp () const;

    /**
     * Sets the value of the member "HmiResetByHmiApp".
     *
     * Count of all ApplicationProcessor resets caused by application fault.
     *
     * @param HmiResetByHmiApp The value which will be set
     */
    inline void setHmiResetByHmiApp (uint8 HmiResetByHmiApp_);

    // API of field "HmiResetByHmiException"

    static const int kHmiResetByHmiException = 13;

    /**
     * Clears the field "HmiResetByHmiException".
     *
     * The field will be set to its default value. The hasHmiResetByHmiException()
     * method will return false.
     */
    inline void clearHmiResetByHmiException();

    /**
     * Checks whether the field "HmiResetByHmiException" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiException()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiException () const;

    /**
     * Returns the value of the member "HmiResetByHmiException".
     *
     * Count of all ApplicationProcessor resets caused by an exception.
     *
     * @return The value of the field "HmiResetByHmiException"
     */
    inline uint8 getHmiResetByHmiException () const;

    /**
     * Sets the value of the member "HmiResetByHmiException".
     *
     * Count of all ApplicationProcessor resets caused by an exception.
     *
     * @param HmiResetByHmiException The value which will be set
     */
    inline void setHmiResetByHmiException (uint8 HmiResetByHmiException_);

    // API of field "HmiResetByHmiExtern"

    static const int kHmiResetByHmiExtern = 14;

    /**
     * Clears the field "HmiResetByHmiExtern".
     *
     * The field will be set to its default value. The hasHmiResetByHmiExtern()
     * method will return false.
     */
    inline void clearHmiResetByHmiExtern();

    /**
     * Checks whether the field "HmiResetByHmiExtern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiExtern()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiExtern () const;

    /**
     * Returns the value of the member "HmiResetByHmiExtern".
     *
     * Count of all ApplicationProcessor resets caused by extern/unknown.
     *
     * @return The value of the field "HmiResetByHmiExtern"
     */
    inline uint8 getHmiResetByHmiExtern () const;

    /**
     * Sets the value of the member "HmiResetByHmiExtern".
     *
     * Count of all ApplicationProcessor resets caused by extern/unknown.
     *
     * @param HmiResetByHmiExtern The value which will be set
     */
    inline void setHmiResetByHmiExtern (uint8 HmiResetByHmiExtern_);

    // API of field "HmiResetByHmiDownload"

    static const int kHmiResetByHmiDownload = 15;

    /**
     * Clears the field "HmiResetByHmiDownload".
     *
     * The field will be set to its default value. The hasHmiResetByHmiDownload()
     * method will return false.
     */
    inline void clearHmiResetByHmiDownload();

    /**
     * Checks whether the field "HmiResetByHmiDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiDownload()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiDownload () const;

    /**
     * Returns the value of the member "HmiResetByHmiDownload".
     *
     * Count of all ApplicationProcessor resets caused by download.
     *
     * @return The value of the field "HmiResetByHmiDownload"
     */
    inline uint8 getHmiResetByHmiDownload () const;

    /**
     * Sets the value of the member "HmiResetByHmiDownload".
     *
     * Count of all ApplicationProcessor resets caused by download.
     *
     * @param HmiResetByHmiDownload The value which will be set
     */
    inline void setHmiResetByHmiDownload (uint8 HmiResetByHmiDownload_);

    // API of field "HmiResetByHmiDiag"

    static const int kHmiResetByHmiDiag = 16;

    /**
     * Clears the field "HmiResetByHmiDiag".
     *
     * The field will be set to its default value. The hasHmiResetByHmiDiag()
     * method will return false.
     */
    inline void clearHmiResetByHmiDiag();

    /**
     * Checks whether the field "HmiResetByHmiDiag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiResetByHmiDiag()). Otherwise it will return false.
     */
    inline bool hasHmiResetByHmiDiag () const;

    /**
     * Returns the value of the member "HmiResetByHmiDiag".
     *
     * Count of all ApplicationProcessor resets caused by diagnostics.
     *
     * @return The value of the field "HmiResetByHmiDiag"
     */
    inline uint8 getHmiResetByHmiDiag () const;

    /**
     * Sets the value of the member "HmiResetByHmiDiag".
     *
     * Count of all ApplicationProcessor resets caused by diagnostics.
     *
     * @param HmiResetByHmiDiag The value which will be set
     */
    inline void setHmiResetByHmiDiag (uint8 HmiResetByHmiDiag_);

    // API of field "FgsResetByHmi"

    static const int kFgsResetByHmi = 17;

    /**
     * Clears the field "FgsResetByHmi".
     *
     * The field will be set to its default value. The hasFgsResetByHmi()
     * method will return false.
     */
    inline void clearFgsResetByHmi();

    /**
     * Checks whether the field "FgsResetByHmi" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFgsResetByHmi()). Otherwise it will return false.
     */
    inline bool hasFgsResetByHmi () const;

    /**
     * Returns the value of the member "FgsResetByHmi".
     *
     * Count of all FGS resets triggered by the HMI.
     *
     * @return The value of the field "FgsResetByHmi"
     */
    inline uint8 getFgsResetByHmi () const;

    /**
     * Sets the value of the member "FgsResetByHmi".
     *
     * Count of all FGS resets triggered by the HMI.
     *
     * @param FgsResetByHmi The value which will be set
     */
    inline void setFgsResetByHmi (uint8 FgsResetByHmi_);

    static const TResetList &getDefaultInstance();

private:

    inline void set_has_LastResetReason ();

    inline void clear_has_LastResetReason ();

    inline void set_has_DateHour ();

    inline void clear_has_DateHour ();

    inline void set_has_DateMinute ();

    inline void clear_has_DateMinute ();

    inline void set_has_DateDay ();

    inline void clear_has_DateDay ();

    inline void set_has_DateMonth ();

    inline void clear_has_DateMonth ();

    inline void set_has_DateYear ();

    inline void clear_has_DateYear ();

    inline void set_has_CoproResetByHmi ();

    inline void clear_has_CoproResetByHmi ();

    inline void set_has_CoproResetByUndervoltage ();

    inline void clear_has_CoproResetByUndervoltage ();

    inline void set_has_HmiResetByCoproStartup ();

    inline void clear_has_HmiResetByCoproStartup ();

    inline void set_has_HmiResetByCoproRun ();

    inline void clear_has_HmiResetByCoproRun ();

    inline void set_has_HmiResetByCoproShutdown ();

    inline void clear_has_HmiResetByCoproShutdown ();

    inline void set_has_HmiResetByHmiWdg ();

    inline void clear_has_HmiResetByHmiWdg ();

    inline void set_has_HmiResetByHmiApp ();

    inline void clear_has_HmiResetByHmiApp ();

    inline void set_has_HmiResetByHmiException ();

    inline void clear_has_HmiResetByHmiException ();

    inline void set_has_HmiResetByHmiExtern ();

    inline void clear_has_HmiResetByHmiExtern ();

    inline void set_has_HmiResetByHmiDownload ();

    inline void clear_has_HmiResetByHmiDownload ();

    inline void set_has_HmiResetByHmiDiag ();

    inline void clear_has_HmiResetByHmiDiag ();

    inline void set_has_FgsResetByHmi ();

    inline void clear_has_FgsResetByHmi ();

    uint32 _has_bits_[ (18 + 31) / 32];

    T_e8_LcmResetReason _LastResetReason;

    uint8 _DateHour;

    uint8 _DateMinute;

    uint8 _DateDay;

    uint8 _DateMonth;

    uint16 _DateYear;

    uint8 _CoproResetByHmi;

    uint8 _CoproResetByUndervoltage;

    uint8 _HmiResetByCoproStartup;

    uint8 _HmiResetByCoproRun;

    uint8 _HmiResetByCoproShutdown;

    uint8 _HmiResetByHmiWdg;

    uint8 _HmiResetByHmiApp;

    uint8 _HmiResetByHmiException;

    uint8 _HmiResetByHmiExtern;

    uint8 _HmiResetByHmiDownload;

    uint8 _HmiResetByHmiDiag;

    uint8 _FgsResetByHmi;

};

/**
 * If the meaning of "TTimeDate" isn't clear, then there should be a description here.
 */
class TTimeDate {
public:

    /**
     * Default constructor
     */
    inline  TTimeDate ();

    /**
     * Copy constructor
     */
    inline  TTimeDate (const TTimeDate &rhs);

    /**
     * All fields constructor
     */
    inline  TTimeDate (int16 s16Year_, uint8 u8Month_, uint8 u8Day_, uint8 u8Hour_, uint8 u8Minute_, uint8 u8Second_);

    /**
     * Destructor
     */
    inline  ~TTimeDate();

    /**
     * Assignment operator
     */
    inline TTimeDate& operator = (const TTimeDate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TTimeDate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TTimeDate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TTimeDate& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TTimeDate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s16Year"

    static const int kS16Year = 0;

    /**
     * Clears the field "s16Year".
     *
     * The field will be set to its default value. The hasS16Year()
     * method will return false.
     */
    inline void clearS16Year();

    /**
     * Checks whether the field "s16Year" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS16Year()). Otherwise it will return false.
     */
    inline bool hasS16Year () const;

    /**
     * Returns the value of the member "s16Year".
     *
     *
     *
     * @return The value of the field "s16Year"
     */
    inline int16 getS16Year () const;

    /**
     * Sets the value of the member "s16Year".
     *
     *
     *
     * @param s16Year The value which will be set
     */
    inline void setS16Year (int16 s16Year_);

    // API of field "u8Month"

    static const int kU8Month = 1;

    /**
     * Clears the field "u8Month".
     *
     * The field will be set to its default value. The hasU8Month()
     * method will return false.
     */
    inline void clearU8Month();

    /**
     * Checks whether the field "u8Month" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Month()). Otherwise it will return false.
     */
    inline bool hasU8Month () const;

    /**
     * Returns the value of the member "u8Month".
     *
     *
     *
     * @return The value of the field "u8Month"
     */
    inline uint8 getU8Month () const;

    /**
     * Sets the value of the member "u8Month".
     *
     *
     *
     * @param u8Month The value which will be set
     */
    inline void setU8Month (uint8 u8Month_);

    // API of field "u8Day"

    static const int kU8Day = 2;

    /**
     * Clears the field "u8Day".
     *
     * The field will be set to its default value. The hasU8Day()
     * method will return false.
     */
    inline void clearU8Day();

    /**
     * Checks whether the field "u8Day" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Day()). Otherwise it will return false.
     */
    inline bool hasU8Day () const;

    /**
     * Returns the value of the member "u8Day".
     *
     *
     *
     * @return The value of the field "u8Day"
     */
    inline uint8 getU8Day () const;

    /**
     * Sets the value of the member "u8Day".
     *
     *
     *
     * @param u8Day The value which will be set
     */
    inline void setU8Day (uint8 u8Day_);

    // API of field "u8Hour"

    static const int kU8Hour = 3;

    /**
     * Clears the field "u8Hour".
     *
     * The field will be set to its default value. The hasU8Hour()
     * method will return false.
     */
    inline void clearU8Hour();

    /**
     * Checks whether the field "u8Hour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hour()). Otherwise it will return false.
     */
    inline bool hasU8Hour () const;

    /**
     * Returns the value of the member "u8Hour".
     *
     *
     *
     * @return The value of the field "u8Hour"
     */
    inline uint8 getU8Hour () const;

    /**
     * Sets the value of the member "u8Hour".
     *
     *
     *
     * @param u8Hour The value which will be set
     */
    inline void setU8Hour (uint8 u8Hour_);

    // API of field "u8Minute"

    static const int kU8Minute = 4;

    /**
     * Clears the field "u8Minute".
     *
     * The field will be set to its default value. The hasU8Minute()
     * method will return false.
     */
    inline void clearU8Minute();

    /**
     * Checks whether the field "u8Minute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Minute()). Otherwise it will return false.
     */
    inline bool hasU8Minute () const;

    /**
     * Returns the value of the member "u8Minute".
     *
     *
     *
     * @return The value of the field "u8Minute"
     */
    inline uint8 getU8Minute () const;

    /**
     * Sets the value of the member "u8Minute".
     *
     *
     *
     * @param u8Minute The value which will be set
     */
    inline void setU8Minute (uint8 u8Minute_);

    // API of field "u8Second"

    static const int kU8Second = 5;

    /**
     * Clears the field "u8Second".
     *
     * The field will be set to its default value. The hasU8Second()
     * method will return false.
     */
    inline void clearU8Second();

    /**
     * Checks whether the field "u8Second" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Second()). Otherwise it will return false.
     */
    inline bool hasU8Second () const;

    /**
     * Returns the value of the member "u8Second".
     *
     *
     *
     * @return The value of the field "u8Second"
     */
    inline uint8 getU8Second () const;

    /**
     * Sets the value of the member "u8Second".
     *
     *
     *
     * @param u8Second The value which will be set
     */
    inline void setU8Second (uint8 u8Second_);

    static const TTimeDate &getDefaultInstance();

private:

    inline void set_has_s16Year ();

    inline void clear_has_s16Year ();

    inline void set_has_u8Month ();

    inline void clear_has_u8Month ();

    inline void set_has_u8Day ();

    inline void clear_has_u8Day ();

    inline void set_has_u8Hour ();

    inline void clear_has_u8Hour ();

    inline void set_has_u8Minute ();

    inline void clear_has_u8Minute ();

    inline void set_has_u8Second ();

    inline void clear_has_u8Second ();

    uint32 _has_bits_[ (6 + 31) / 32];

    int16 _s16Year;

    uint8 _u8Month;

    uint8 _u8Day;

    uint8 _u8Hour;

    uint8 _u8Minute;

    uint8 _u8Second;

};

/**
 * If the meaning of "TResetCounter" isn't clear, then there should be a description here.
 */
class TResetCounter {
public:

    /**
     * Default constructor
     */
    inline  TResetCounter ();

    /**
     * Copy constructor
     */
    inline  TResetCounter (const TResetCounter &rhs);

    /**
     * All fields constructor
     */
    inline  TResetCounter (const TTimeDate& tLastResetDate_, T_e8_LcmResetReason tLastResetReason_, uint32 u32ApApplicationError_, uint32 u32ApSoftware_, uint32 u32ApEcuReset_, uint32 u32ApDownload_, uint32 u32ApDownloadError_, uint32 u32ApOvertemperature_, uint32 u32ApUser_, uint32 u32ApLcmIntern_, uint32 u32ApWarmstartCount_, uint32 u32ApPowerOnCount_, uint32 u32ApPowerLossCount_, uint32 u32ApPowerOffCount_, uint32 u32ApSccCount_, uint32 u32ApUnknownCount_, uint32 u32SccHwWdtCount_, uint32 u32SccPowerOnCount_, uint32 u32SccColdstartCount_, uint32 u32SccAppmodeChangeCount_, uint32 u32SccDuringLpwCount_, uint32 u32SccDuringPllOszCount_, uint32 u32SccDuringSWCount_, uint32 u32SccWarmstartCount_);

    /**
     * Destructor
     */
    inline  ~TResetCounter();

    /**
     * Assignment operator
     */
    inline TResetCounter& operator = (const TResetCounter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TResetCounter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TResetCounter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TResetCounter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TResetCounter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tLastResetDate"

    static const int kTLastResetDate = 0;

    /**
     * Clears the field "tLastResetDate".
     *
     * The field will be set to its default value. The hasTLastResetDate()
     * method will return false.
     */
    inline void clearTLastResetDate();

    /**
     * Checks whether the field "tLastResetDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetDate()). Otherwise it will return false.
     */
    inline bool hasTLastResetDate () const;

    /**
     * Returns the value of the member "tLastResetDate".
     *
     *
     *
     * @return The value of the field "tLastResetDate"
     */
    inline const TTimeDate& getTLastResetDate () const;

    /**
     * Retrieves the value of the field "tLastResetDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tLastResetDate".
     */
    inline TTimeDate& getTLastResetDateMutable ();

    /**
     * Sets the value of the member "tLastResetDate".
     *
     *
     *
     * @param tLastResetDate The value which will be set
     */
    inline void setTLastResetDate (const TTimeDate& tLastResetDate_);

    // API of field "tLastResetReason"

    static const int kTLastResetReason = 1;

    /**
     * Clears the field "tLastResetReason".
     *
     * The field will be set to its default value. The hasTLastResetReason()
     * method will return false.
     */
    inline void clearTLastResetReason();

    /**
     * Checks whether the field "tLastResetReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetReason()). Otherwise it will return false.
     */
    inline bool hasTLastResetReason () const;

    /**
     * Returns the value of the member "tLastResetReason".
     *
     *
     *
     * @return The value of the field "tLastResetReason"
     */
    inline T_e8_LcmResetReason getTLastResetReason () const;

    /**
     * Sets the value of the member "tLastResetReason".
     *
     *
     *
     * @param tLastResetReason The value which will be set
     */
    inline void setTLastResetReason (T_e8_LcmResetReason tLastResetReason_);

    // API of field "u32ApApplicationError"

    static const int kU32ApApplicationError = 2;

    /**
     * Clears the field "u32ApApplicationError".
     *
     * The field will be set to its default value. The hasU32ApApplicationError()
     * method will return false.
     */
    inline void clearU32ApApplicationError();

    /**
     * Checks whether the field "u32ApApplicationError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApApplicationError()). Otherwise it will return false.
     */
    inline bool hasU32ApApplicationError () const;

    /**
     * Returns the value of the member "u32ApApplicationError".
     *
     *
     *
     * @return The value of the field "u32ApApplicationError"
     */
    inline uint32 getU32ApApplicationError () const;

    /**
     * Sets the value of the member "u32ApApplicationError".
     *
     *
     *
     * @param u32ApApplicationError The value which will be set
     */
    inline void setU32ApApplicationError (uint32 u32ApApplicationError_);

    // API of field "u32ApSoftware"

    static const int kU32ApSoftware = 3;

    /**
     * Clears the field "u32ApSoftware".
     *
     * The field will be set to its default value. The hasU32ApSoftware()
     * method will return false.
     */
    inline void clearU32ApSoftware();

    /**
     * Checks whether the field "u32ApSoftware" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSoftware()). Otherwise it will return false.
     */
    inline bool hasU32ApSoftware () const;

    /**
     * Returns the value of the member "u32ApSoftware".
     *
     *
     *
     * @return The value of the field "u32ApSoftware"
     */
    inline uint32 getU32ApSoftware () const;

    /**
     * Sets the value of the member "u32ApSoftware".
     *
     *
     *
     * @param u32ApSoftware The value which will be set
     */
    inline void setU32ApSoftware (uint32 u32ApSoftware_);

    // API of field "u32ApEcuReset"

    static const int kU32ApEcuReset = 4;

    /**
     * Clears the field "u32ApEcuReset".
     *
     * The field will be set to its default value. The hasU32ApEcuReset()
     * method will return false.
     */
    inline void clearU32ApEcuReset();

    /**
     * Checks whether the field "u32ApEcuReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApEcuReset()). Otherwise it will return false.
     */
    inline bool hasU32ApEcuReset () const;

    /**
     * Returns the value of the member "u32ApEcuReset".
     *
     *
     *
     * @return The value of the field "u32ApEcuReset"
     */
    inline uint32 getU32ApEcuReset () const;

    /**
     * Sets the value of the member "u32ApEcuReset".
     *
     *
     *
     * @param u32ApEcuReset The value which will be set
     */
    inline void setU32ApEcuReset (uint32 u32ApEcuReset_);

    // API of field "u32ApDownload"

    static const int kU32ApDownload = 5;

    /**
     * Clears the field "u32ApDownload".
     *
     * The field will be set to its default value. The hasU32ApDownload()
     * method will return false.
     */
    inline void clearU32ApDownload();

    /**
     * Checks whether the field "u32ApDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownload()). Otherwise it will return false.
     */
    inline bool hasU32ApDownload () const;

    /**
     * Returns the value of the member "u32ApDownload".
     *
     *
     *
     * @return The value of the field "u32ApDownload"
     */
    inline uint32 getU32ApDownload () const;

    /**
     * Sets the value of the member "u32ApDownload".
     *
     *
     *
     * @param u32ApDownload The value which will be set
     */
    inline void setU32ApDownload (uint32 u32ApDownload_);

    // API of field "u32ApDownloadError"

    static const int kU32ApDownloadError = 6;

    /**
     * Clears the field "u32ApDownloadError".
     *
     * The field will be set to its default value. The hasU32ApDownloadError()
     * method will return false.
     */
    inline void clearU32ApDownloadError();

    /**
     * Checks whether the field "u32ApDownloadError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownloadError()). Otherwise it will return false.
     */
    inline bool hasU32ApDownloadError () const;

    /**
     * Returns the value of the member "u32ApDownloadError".
     *
     *
     *
     * @return The value of the field "u32ApDownloadError"
     */
    inline uint32 getU32ApDownloadError () const;

    /**
     * Sets the value of the member "u32ApDownloadError".
     *
     *
     *
     * @param u32ApDownloadError The value which will be set
     */
    inline void setU32ApDownloadError (uint32 u32ApDownloadError_);

    // API of field "u32ApOvertemperature"

    static const int kU32ApOvertemperature = 7;

    /**
     * Clears the field "u32ApOvertemperature".
     *
     * The field will be set to its default value. The hasU32ApOvertemperature()
     * method will return false.
     */
    inline void clearU32ApOvertemperature();

    /**
     * Checks whether the field "u32ApOvertemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApOvertemperature()). Otherwise it will return false.
     */
    inline bool hasU32ApOvertemperature () const;

    /**
     * Returns the value of the member "u32ApOvertemperature".
     *
     *
     *
     * @return The value of the field "u32ApOvertemperature"
     */
    inline uint32 getU32ApOvertemperature () const;

    /**
     * Sets the value of the member "u32ApOvertemperature".
     *
     *
     *
     * @param u32ApOvertemperature The value which will be set
     */
    inline void setU32ApOvertemperature (uint32 u32ApOvertemperature_);

    // API of field "u32ApUser"

    static const int kU32ApUser = 8;

    /**
     * Clears the field "u32ApUser".
     *
     * The field will be set to its default value. The hasU32ApUser()
     * method will return false.
     */
    inline void clearU32ApUser();

    /**
     * Checks whether the field "u32ApUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUser()). Otherwise it will return false.
     */
    inline bool hasU32ApUser () const;

    /**
     * Returns the value of the member "u32ApUser".
     *
     *
     *
     * @return The value of the field "u32ApUser"
     */
    inline uint32 getU32ApUser () const;

    /**
     * Sets the value of the member "u32ApUser".
     *
     *
     *
     * @param u32ApUser The value which will be set
     */
    inline void setU32ApUser (uint32 u32ApUser_);

    // API of field "u32ApLcmIntern"

    static const int kU32ApLcmIntern = 9;

    /**
     * Clears the field "u32ApLcmIntern".
     *
     * The field will be set to its default value. The hasU32ApLcmIntern()
     * method will return false.
     */
    inline void clearU32ApLcmIntern();

    /**
     * Checks whether the field "u32ApLcmIntern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApLcmIntern()). Otherwise it will return false.
     */
    inline bool hasU32ApLcmIntern () const;

    /**
     * Returns the value of the member "u32ApLcmIntern".
     *
     *
     *
     * @return The value of the field "u32ApLcmIntern"
     */
    inline uint32 getU32ApLcmIntern () const;

    /**
     * Sets the value of the member "u32ApLcmIntern".
     *
     *
     *
     * @param u32ApLcmIntern The value which will be set
     */
    inline void setU32ApLcmIntern (uint32 u32ApLcmIntern_);

    // API of field "u32ApWarmstartCount"

    static const int kU32ApWarmstartCount = 10;

    /**
     * Clears the field "u32ApWarmstartCount".
     *
     * The field will be set to its default value. The hasU32ApWarmstartCount()
     * method will return false.
     */
    inline void clearU32ApWarmstartCount();

    /**
     * Checks whether the field "u32ApWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32ApWarmstartCount () const;

    /**
     * Returns the value of the member "u32ApWarmstartCount".
     *
     *
     *
     * @return The value of the field "u32ApWarmstartCount"
     */
    inline uint32 getU32ApWarmstartCount () const;

    /**
     * Sets the value of the member "u32ApWarmstartCount".
     *
     *
     *
     * @param u32ApWarmstartCount The value which will be set
     */
    inline void setU32ApWarmstartCount (uint32 u32ApWarmstartCount_);

    // API of field "u32ApPowerOnCount"

    static const int kU32ApPowerOnCount = 11;

    /**
     * Clears the field "u32ApPowerOnCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOnCount()
     * method will return false.
     */
    inline void clearU32ApPowerOnCount();

    /**
     * Checks whether the field "u32ApPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOnCount () const;

    /**
     * Returns the value of the member "u32ApPowerOnCount".
     *
     *
     *
     * @return The value of the field "u32ApPowerOnCount"
     */
    inline uint32 getU32ApPowerOnCount () const;

    /**
     * Sets the value of the member "u32ApPowerOnCount".
     *
     *
     *
     * @param u32ApPowerOnCount The value which will be set
     */
    inline void setU32ApPowerOnCount (uint32 u32ApPowerOnCount_);

    // API of field "u32ApPowerLossCount"

    static const int kU32ApPowerLossCount = 12;

    /**
     * Clears the field "u32ApPowerLossCount".
     *
     * The field will be set to its default value. The hasU32ApPowerLossCount()
     * method will return false.
     */
    inline void clearU32ApPowerLossCount();

    /**
     * Checks whether the field "u32ApPowerLossCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerLossCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerLossCount () const;

    /**
     * Returns the value of the member "u32ApPowerLossCount".
     *
     *
     *
     * @return The value of the field "u32ApPowerLossCount"
     */
    inline uint32 getU32ApPowerLossCount () const;

    /**
     * Sets the value of the member "u32ApPowerLossCount".
     *
     *
     *
     * @param u32ApPowerLossCount The value which will be set
     */
    inline void setU32ApPowerLossCount (uint32 u32ApPowerLossCount_);

    // API of field "u32ApPowerOffCount"

    static const int kU32ApPowerOffCount = 13;

    /**
     * Clears the field "u32ApPowerOffCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOffCount()
     * method will return false.
     */
    inline void clearU32ApPowerOffCount();

    /**
     * Checks whether the field "u32ApPowerOffCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOffCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOffCount () const;

    /**
     * Returns the value of the member "u32ApPowerOffCount".
     *
     *
     *
     * @return The value of the field "u32ApPowerOffCount"
     */
    inline uint32 getU32ApPowerOffCount () const;

    /**
     * Sets the value of the member "u32ApPowerOffCount".
     *
     *
     *
     * @param u32ApPowerOffCount The value which will be set
     */
    inline void setU32ApPowerOffCount (uint32 u32ApPowerOffCount_);

    // API of field "u32ApSccCount"

    static const int kU32ApSccCount = 14;

    /**
     * Clears the field "u32ApSccCount".
     *
     * The field will be set to its default value. The hasU32ApSccCount()
     * method will return false.
     */
    inline void clearU32ApSccCount();

    /**
     * Checks whether the field "u32ApSccCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSccCount()). Otherwise it will return false.
     */
    inline bool hasU32ApSccCount () const;

    /**
     * Returns the value of the member "u32ApSccCount".
     *
     *
     *
     * @return The value of the field "u32ApSccCount"
     */
    inline uint32 getU32ApSccCount () const;

    /**
     * Sets the value of the member "u32ApSccCount".
     *
     *
     *
     * @param u32ApSccCount The value which will be set
     */
    inline void setU32ApSccCount (uint32 u32ApSccCount_);

    // API of field "u32ApUnknownCount"

    static const int kU32ApUnknownCount = 15;

    /**
     * Clears the field "u32ApUnknownCount".
     *
     * The field will be set to its default value. The hasU32ApUnknownCount()
     * method will return false.
     */
    inline void clearU32ApUnknownCount();

    /**
     * Checks whether the field "u32ApUnknownCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUnknownCount()). Otherwise it will return false.
     */
    inline bool hasU32ApUnknownCount () const;

    /**
     * Returns the value of the member "u32ApUnknownCount".
     *
     *
     *
     * @return The value of the field "u32ApUnknownCount"
     */
    inline uint32 getU32ApUnknownCount () const;

    /**
     * Sets the value of the member "u32ApUnknownCount".
     *
     *
     *
     * @param u32ApUnknownCount The value which will be set
     */
    inline void setU32ApUnknownCount (uint32 u32ApUnknownCount_);

    // API of field "u32SccHwWdtCount"

    static const int kU32SccHwWdtCount = 16;

    /**
     * Clears the field "u32SccHwWdtCount".
     *
     * The field will be set to its default value. The hasU32SccHwWdtCount()
     * method will return false.
     */
    inline void clearU32SccHwWdtCount();

    /**
     * Checks whether the field "u32SccHwWdtCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccHwWdtCount()). Otherwise it will return false.
     */
    inline bool hasU32SccHwWdtCount () const;

    /**
     * Returns the value of the member "u32SccHwWdtCount".
     *
     *
     *
     * @return The value of the field "u32SccHwWdtCount"
     */
    inline uint32 getU32SccHwWdtCount () const;

    /**
     * Sets the value of the member "u32SccHwWdtCount".
     *
     *
     *
     * @param u32SccHwWdtCount The value which will be set
     */
    inline void setU32SccHwWdtCount (uint32 u32SccHwWdtCount_);

    // API of field "u32SccPowerOnCount"

    static const int kU32SccPowerOnCount = 17;

    /**
     * Clears the field "u32SccPowerOnCount".
     *
     * The field will be set to its default value. The hasU32SccPowerOnCount()
     * method will return false.
     */
    inline void clearU32SccPowerOnCount();

    /**
     * Checks whether the field "u32SccPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32SccPowerOnCount () const;

    /**
     * Returns the value of the member "u32SccPowerOnCount".
     *
     *
     *
     * @return The value of the field "u32SccPowerOnCount"
     */
    inline uint32 getU32SccPowerOnCount () const;

    /**
     * Sets the value of the member "u32SccPowerOnCount".
     *
     *
     *
     * @param u32SccPowerOnCount The value which will be set
     */
    inline void setU32SccPowerOnCount (uint32 u32SccPowerOnCount_);

    // API of field "u32SccColdstartCount"

    static const int kU32SccColdstartCount = 18;

    /**
     * Clears the field "u32SccColdstartCount".
     *
     * The field will be set to its default value. The hasU32SccColdstartCount()
     * method will return false.
     */
    inline void clearU32SccColdstartCount();

    /**
     * Checks whether the field "u32SccColdstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccColdstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccColdstartCount () const;

    /**
     * Returns the value of the member "u32SccColdstartCount".
     *
     *
     *
     * @return The value of the field "u32SccColdstartCount"
     */
    inline uint32 getU32SccColdstartCount () const;

    /**
     * Sets the value of the member "u32SccColdstartCount".
     *
     *
     *
     * @param u32SccColdstartCount The value which will be set
     */
    inline void setU32SccColdstartCount (uint32 u32SccColdstartCount_);

    // API of field "u32SccAppmodeChangeCount"

    static const int kU32SccAppmodeChangeCount = 19;

    /**
     * Clears the field "u32SccAppmodeChangeCount".
     *
     * The field will be set to its default value. The hasU32SccAppmodeChangeCount()
     * method will return false.
     */
    inline void clearU32SccAppmodeChangeCount();

    /**
     * Checks whether the field "u32SccAppmodeChangeCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccAppmodeChangeCount()). Otherwise it will return false.
     */
    inline bool hasU32SccAppmodeChangeCount () const;

    /**
     * Returns the value of the member "u32SccAppmodeChangeCount".
     *
     *
     *
     * @return The value of the field "u32SccAppmodeChangeCount"
     */
    inline uint32 getU32SccAppmodeChangeCount () const;

    /**
     * Sets the value of the member "u32SccAppmodeChangeCount".
     *
     *
     *
     * @param u32SccAppmodeChangeCount The value which will be set
     */
    inline void setU32SccAppmodeChangeCount (uint32 u32SccAppmodeChangeCount_);

    // API of field "u32SccDuringLpwCount"

    static const int kU32SccDuringLpwCount = 20;

    /**
     * Clears the field "u32SccDuringLpwCount".
     *
     * The field will be set to its default value. The hasU32SccDuringLpwCount()
     * method will return false.
     */
    inline void clearU32SccDuringLpwCount();

    /**
     * Checks whether the field "u32SccDuringLpwCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringLpwCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringLpwCount () const;

    /**
     * Returns the value of the member "u32SccDuringLpwCount".
     *
     *
     *
     * @return The value of the field "u32SccDuringLpwCount"
     */
    inline uint32 getU32SccDuringLpwCount () const;

    /**
     * Sets the value of the member "u32SccDuringLpwCount".
     *
     *
     *
     * @param u32SccDuringLpwCount The value which will be set
     */
    inline void setU32SccDuringLpwCount (uint32 u32SccDuringLpwCount_);

    // API of field "u32SccDuringPllOszCount"

    static const int kU32SccDuringPllOszCount = 21;

    /**
     * Clears the field "u32SccDuringPllOszCount".
     *
     * The field will be set to its default value. The hasU32SccDuringPllOszCount()
     * method will return false.
     */
    inline void clearU32SccDuringPllOszCount();

    /**
     * Checks whether the field "u32SccDuringPllOszCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringPllOszCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringPllOszCount () const;

    /**
     * Returns the value of the member "u32SccDuringPllOszCount".
     *
     *
     *
     * @return The value of the field "u32SccDuringPllOszCount"
     */
    inline uint32 getU32SccDuringPllOszCount () const;

    /**
     * Sets the value of the member "u32SccDuringPllOszCount".
     *
     *
     *
     * @param u32SccDuringPllOszCount The value which will be set
     */
    inline void setU32SccDuringPllOszCount (uint32 u32SccDuringPllOszCount_);

    // API of field "u32SccDuringSWCount"

    static const int kU32SccDuringSWCount = 22;

    /**
     * Clears the field "u32SccDuringSWCount".
     *
     * The field will be set to its default value. The hasU32SccDuringSWCount()
     * method will return false.
     */
    inline void clearU32SccDuringSWCount();

    /**
     * Checks whether the field "u32SccDuringSWCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringSWCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringSWCount () const;

    /**
     * Returns the value of the member "u32SccDuringSWCount".
     *
     *
     *
     * @return The value of the field "u32SccDuringSWCount"
     */
    inline uint32 getU32SccDuringSWCount () const;

    /**
     * Sets the value of the member "u32SccDuringSWCount".
     *
     *
     *
     * @param u32SccDuringSWCount The value which will be set
     */
    inline void setU32SccDuringSWCount (uint32 u32SccDuringSWCount_);

    // API of field "u32SccWarmstartCount"

    static const int kU32SccWarmstartCount = 23;

    /**
     * Clears the field "u32SccWarmstartCount".
     *
     * The field will be set to its default value. The hasU32SccWarmstartCount()
     * method will return false.
     */
    inline void clearU32SccWarmstartCount();

    /**
     * Checks whether the field "u32SccWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccWarmstartCount () const;

    /**
     * Returns the value of the member "u32SccWarmstartCount".
     *
     *
     *
     * @return The value of the field "u32SccWarmstartCount"
     */
    inline uint32 getU32SccWarmstartCount () const;

    /**
     * Sets the value of the member "u32SccWarmstartCount".
     *
     *
     *
     * @param u32SccWarmstartCount The value which will be set
     */
    inline void setU32SccWarmstartCount (uint32 u32SccWarmstartCount_);

    static const TResetCounter &getDefaultInstance();

private:

    inline void set_has_tLastResetDate ();

    inline void clear_has_tLastResetDate ();

    inline void set_has_tLastResetReason ();

    inline void clear_has_tLastResetReason ();

    inline void set_has_u32ApApplicationError ();

    inline void clear_has_u32ApApplicationError ();

    inline void set_has_u32ApSoftware ();

    inline void clear_has_u32ApSoftware ();

    inline void set_has_u32ApEcuReset ();

    inline void clear_has_u32ApEcuReset ();

    inline void set_has_u32ApDownload ();

    inline void clear_has_u32ApDownload ();

    inline void set_has_u32ApDownloadError ();

    inline void clear_has_u32ApDownloadError ();

    inline void set_has_u32ApOvertemperature ();

    inline void clear_has_u32ApOvertemperature ();

    inline void set_has_u32ApUser ();

    inline void clear_has_u32ApUser ();

    inline void set_has_u32ApLcmIntern ();

    inline void clear_has_u32ApLcmIntern ();

    inline void set_has_u32ApWarmstartCount ();

    inline void clear_has_u32ApWarmstartCount ();

    inline void set_has_u32ApPowerOnCount ();

    inline void clear_has_u32ApPowerOnCount ();

    inline void set_has_u32ApPowerLossCount ();

    inline void clear_has_u32ApPowerLossCount ();

    inline void set_has_u32ApPowerOffCount ();

    inline void clear_has_u32ApPowerOffCount ();

    inline void set_has_u32ApSccCount ();

    inline void clear_has_u32ApSccCount ();

    inline void set_has_u32ApUnknownCount ();

    inline void clear_has_u32ApUnknownCount ();

    inline void set_has_u32SccHwWdtCount ();

    inline void clear_has_u32SccHwWdtCount ();

    inline void set_has_u32SccPowerOnCount ();

    inline void clear_has_u32SccPowerOnCount ();

    inline void set_has_u32SccColdstartCount ();

    inline void clear_has_u32SccColdstartCount ();

    inline void set_has_u32SccAppmodeChangeCount ();

    inline void clear_has_u32SccAppmodeChangeCount ();

    inline void set_has_u32SccDuringLpwCount ();

    inline void clear_has_u32SccDuringLpwCount ();

    inline void set_has_u32SccDuringPllOszCount ();

    inline void clear_has_u32SccDuringPllOszCount ();

    inline void set_has_u32SccDuringSWCount ();

    inline void clear_has_u32SccDuringSWCount ();

    inline void set_has_u32SccWarmstartCount ();

    inline void clear_has_u32SccWarmstartCount ();

    uint32 _has_bits_[ (24 + 31) / 32];

    TTimeDate _tLastResetDate;

    T_e8_LcmResetReason _tLastResetReason;

    uint32 _u32ApApplicationError;

    uint32 _u32ApSoftware;

    uint32 _u32ApEcuReset;

    uint32 _u32ApDownload;

    uint32 _u32ApDownloadError;

    uint32 _u32ApOvertemperature;

    uint32 _u32ApUser;

    uint32 _u32ApLcmIntern;

    uint32 _u32ApWarmstartCount;

    uint32 _u32ApPowerOnCount;

    uint32 _u32ApPowerLossCount;

    uint32 _u32ApPowerOffCount;

    uint32 _u32ApSccCount;

    uint32 _u32ApUnknownCount;

    uint32 _u32SccHwWdtCount;

    uint32 _u32SccPowerOnCount;

    uint32 _u32SccColdstartCount;

    uint32 _u32SccAppmodeChangeCount;

    uint32 _u32SccDuringLpwCount;

    uint32 _u32SccDuringPllOszCount;

    uint32 _u32SccDuringSWCount;

    uint32 _u32SccWarmstartCount;

};

/**
 * If the meaning of "TDeviceOnCounter" isn't clear, then there should be a description here.
 */
class TDeviceOnCounter {
public:

    /**
     * Default constructor
     */
    inline  TDeviceOnCounter ();

    /**
     * Copy constructor
     */
    inline  TDeviceOnCounter (const TDeviceOnCounter &rhs);

    /**
     * All fields constructor
     */
    inline  TDeviceOnCounter (uint32 u32DeviceWakeupCount_, uint32 u32DeviceUserOnCount_);

    /**
     * Destructor
     */
    inline  ~TDeviceOnCounter();

    /**
     * Assignment operator
     */
    inline TDeviceOnCounter& operator = (const TDeviceOnCounter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TDeviceOnCounter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TDeviceOnCounter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TDeviceOnCounter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TDeviceOnCounter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32DeviceWakeupCount"

    static const int kU32DeviceWakeupCount = 0;

    /**
     * Clears the field "u32DeviceWakeupCount".
     *
     * The field will be set to its default value. The hasU32DeviceWakeupCount()
     * method will return false.
     */
    inline void clearU32DeviceWakeupCount();

    /**
     * Checks whether the field "u32DeviceWakeupCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceWakeupCount()). Otherwise it will return false.
     */
    inline bool hasU32DeviceWakeupCount () const;

    /**
     * Returns the value of the member "u32DeviceWakeupCount".
     *
     * Counts how often the application processor was woken up.
     *
     * @return The value of the field "u32DeviceWakeupCount"
     */
    inline uint32 getU32DeviceWakeupCount () const;

    /**
     * Sets the value of the member "u32DeviceWakeupCount".
     *
     * Counts how often the application processor was woken up.
     *
     * @param u32DeviceWakeupCount The value which will be set
     */
    inline void setU32DeviceWakeupCount (uint32 u32DeviceWakeupCount_);

    // API of field "u32DeviceUserOnCount"

    static const int kU32DeviceUserOnCount = 1;

    /**
     * Clears the field "u32DeviceUserOnCount".
     *
     * The field will be set to its default value. The hasU32DeviceUserOnCount()
     * method will return false.
     */
    inline void clearU32DeviceUserOnCount();

    /**
     * Checks whether the field "u32DeviceUserOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32DeviceUserOnCount()). Otherwise it will return false.
     */
    inline bool hasU32DeviceUserOnCount () const;

    /**
     * Returns the value of the member "u32DeviceUserOnCount".
     *
     * Counts how often the device was turned UserOn. This might be increased multiple times for one Wakeup.
     *
     * @return The value of the field "u32DeviceUserOnCount"
     */
    inline uint32 getU32DeviceUserOnCount () const;

    /**
     * Sets the value of the member "u32DeviceUserOnCount".
     *
     * Counts how often the device was turned UserOn. This might be increased multiple times for one Wakeup.
     *
     * @param u32DeviceUserOnCount The value which will be set
     */
    inline void setU32DeviceUserOnCount (uint32 u32DeviceUserOnCount_);

    static const TDeviceOnCounter &getDefaultInstance();

private:

    inline void set_has_u32DeviceWakeupCount ();

    inline void clear_has_u32DeviceWakeupCount ();

    inline void set_has_u32DeviceUserOnCount ();

    inline void clear_has_u32DeviceUserOnCount ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32DeviceWakeupCount;

    uint32 _u32DeviceUserOnCount;

};

/**
 * If the meaning of "TWakeupList" isn't clear, then there should be a description here.
 */
class TWakeupList {
public:

    /**
     * Default constructor
     */
    inline  TWakeupList ();

    /**
     * Copy constructor
     */
    inline  TWakeupList (const TWakeupList &rhs);

    /**
     * All fields constructor
     */
    inline  TWakeupList (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason1_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason2_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason3_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason4_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason5_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason6_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason7_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason8_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason9_, T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason10_);

    /**
     * Destructor
     */
    inline  ~TWakeupList();

    /**
     * Assignment operator
     */
    inline TWakeupList& operator = (const TWakeupList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TWakeupList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TWakeupList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TWakeupList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TWakeupList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeUpReason1"

    static const int kWakeUpReason1 = 0;

    /**
     * Clears the field "WakeUpReason1".
     *
     * The field will be set to its default value. The hasWakeUpReason1()
     * method will return false.
     */
    inline void clearWakeUpReason1();

    /**
     * Checks whether the field "WakeUpReason1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason1()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason1 () const;

    /**
     * Returns the value of the member "WakeUpReason1".
     *
     * last detected wakeup reason
     *
     * @return The value of the field "WakeUpReason1"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason1 () const;

    /**
     * Sets the value of the member "WakeUpReason1".
     *
     * last detected wakeup reason
     *
     * @param WakeUpReason1 The value which will be set
     */
    inline void setWakeUpReason1 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason1_);

    // API of field "WakeUpReason2"

    static const int kWakeUpReason2 = 1;

    /**
     * Clears the field "WakeUpReason2".
     *
     * The field will be set to its default value. The hasWakeUpReason2()
     * method will return false.
     */
    inline void clearWakeUpReason2();

    /**
     * Checks whether the field "WakeUpReason2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason2()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason2 () const;

    /**
     * Returns the value of the member "WakeUpReason2".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason2"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason2 () const;

    /**
     * Sets the value of the member "WakeUpReason2".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason2 The value which will be set
     */
    inline void setWakeUpReason2 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason2_);

    // API of field "WakeUpReason3"

    static const int kWakeUpReason3 = 2;

    /**
     * Clears the field "WakeUpReason3".
     *
     * The field will be set to its default value. The hasWakeUpReason3()
     * method will return false.
     */
    inline void clearWakeUpReason3();

    /**
     * Checks whether the field "WakeUpReason3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason3()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason3 () const;

    /**
     * Returns the value of the member "WakeUpReason3".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason3"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason3 () const;

    /**
     * Sets the value of the member "WakeUpReason3".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason3 The value which will be set
     */
    inline void setWakeUpReason3 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason3_);

    // API of field "WakeUpReason4"

    static const int kWakeUpReason4 = 3;

    /**
     * Clears the field "WakeUpReason4".
     *
     * The field will be set to its default value. The hasWakeUpReason4()
     * method will return false.
     */
    inline void clearWakeUpReason4();

    /**
     * Checks whether the field "WakeUpReason4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason4()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason4 () const;

    /**
     * Returns the value of the member "WakeUpReason4".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason4"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason4 () const;

    /**
     * Sets the value of the member "WakeUpReason4".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason4 The value which will be set
     */
    inline void setWakeUpReason4 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason4_);

    // API of field "WakeUpReason5"

    static const int kWakeUpReason5 = 4;

    /**
     * Clears the field "WakeUpReason5".
     *
     * The field will be set to its default value. The hasWakeUpReason5()
     * method will return false.
     */
    inline void clearWakeUpReason5();

    /**
     * Checks whether the field "WakeUpReason5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason5()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason5 () const;

    /**
     * Returns the value of the member "WakeUpReason5".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason5"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason5 () const;

    /**
     * Sets the value of the member "WakeUpReason5".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason5 The value which will be set
     */
    inline void setWakeUpReason5 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason5_);

    // API of field "WakeUpReason6"

    static const int kWakeUpReason6 = 5;

    /**
     * Clears the field "WakeUpReason6".
     *
     * The field will be set to its default value. The hasWakeUpReason6()
     * method will return false.
     */
    inline void clearWakeUpReason6();

    /**
     * Checks whether the field "WakeUpReason6" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason6()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason6 () const;

    /**
     * Returns the value of the member "WakeUpReason6".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason6"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason6 () const;

    /**
     * Sets the value of the member "WakeUpReason6".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason6 The value which will be set
     */
    inline void setWakeUpReason6 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason6_);

    // API of field "WakeUpReason7"

    static const int kWakeUpReason7 = 6;

    /**
     * Clears the field "WakeUpReason7".
     *
     * The field will be set to its default value. The hasWakeUpReason7()
     * method will return false.
     */
    inline void clearWakeUpReason7();

    /**
     * Checks whether the field "WakeUpReason7" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason7()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason7 () const;

    /**
     * Returns the value of the member "WakeUpReason7".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason7"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason7 () const;

    /**
     * Sets the value of the member "WakeUpReason7".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason7 The value which will be set
     */
    inline void setWakeUpReason7 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason7_);

    // API of field "WakeUpReason8"

    static const int kWakeUpReason8 = 7;

    /**
     * Clears the field "WakeUpReason8".
     *
     * The field will be set to its default value. The hasWakeUpReason8()
     * method will return false.
     */
    inline void clearWakeUpReason8();

    /**
     * Checks whether the field "WakeUpReason8" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason8()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason8 () const;

    /**
     * Returns the value of the member "WakeUpReason8".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason8"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason8 () const;

    /**
     * Sets the value of the member "WakeUpReason8".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason8 The value which will be set
     */
    inline void setWakeUpReason8 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason8_);

    // API of field "WakeUpReason9"

    static const int kWakeUpReason9 = 8;

    /**
     * Clears the field "WakeUpReason9".
     *
     * The field will be set to its default value. The hasWakeUpReason9()
     * method will return false.
     */
    inline void clearWakeUpReason9();

    /**
     * Checks whether the field "WakeUpReason9" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason9()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason9 () const;

    /**
     * Returns the value of the member "WakeUpReason9".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason9"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason9 () const;

    /**
     * Sets the value of the member "WakeUpReason9".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason9 The value which will be set
     */
    inline void setWakeUpReason9 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason9_);

    // API of field "WakeUpReason10"

    static const int kWakeUpReason10 = 9;

    /**
     * Clears the field "WakeUpReason10".
     *
     * The field will be set to its default value. The hasWakeUpReason10()
     * method will return false.
     */
    inline void clearWakeUpReason10();

    /**
     * Checks whether the field "WakeUpReason10" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeUpReason10()). Otherwise it will return false.
     */
    inline bool hasWakeUpReason10 () const;

    /**
     * Returns the value of the member "WakeUpReason10".
     *
     * next detected wakeup reason
     *
     * @return The value of the field "WakeUpReason10"
     */
    inline T_SPM_e8_WAKEUP_LIST_REASON getWakeUpReason10 () const;

    /**
     * Sets the value of the member "WakeUpReason10".
     *
     * next detected wakeup reason
     *
     * @param WakeUpReason10 The value which will be set
     */
    inline void setWakeUpReason10 (T_SPM_e8_WAKEUP_LIST_REASON WakeUpReason10_);

    static const TWakeupList &getDefaultInstance();

private:

    inline void set_has_WakeUpReason1 ();

    inline void clear_has_WakeUpReason1 ();

    inline void set_has_WakeUpReason2 ();

    inline void clear_has_WakeUpReason2 ();

    inline void set_has_WakeUpReason3 ();

    inline void clear_has_WakeUpReason3 ();

    inline void set_has_WakeUpReason4 ();

    inline void clear_has_WakeUpReason4 ();

    inline void set_has_WakeUpReason5 ();

    inline void clear_has_WakeUpReason5 ();

    inline void set_has_WakeUpReason6 ();

    inline void clear_has_WakeUpReason6 ();

    inline void set_has_WakeUpReason7 ();

    inline void clear_has_WakeUpReason7 ();

    inline void set_has_WakeUpReason8 ();

    inline void clear_has_WakeUpReason8 ();

    inline void set_has_WakeUpReason9 ();

    inline void clear_has_WakeUpReason9 ();

    inline void set_has_WakeUpReason10 ();

    inline void clear_has_WakeUpReason10 ();

    uint32 _has_bits_[ (10 + 31) / 32];

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason1;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason2;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason3;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason4;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason5;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason6;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason7;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason8;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason9;

    T_SPM_e8_WAKEUP_LIST_REASON _WakeUpReason10;

};

/**
 * If the meaning of "TMostState" isn't clear, then there should be a description here.
 */
class TMostState {
public:

    /**
     * Default constructor
     */
    inline  TMostState ();

    /**
     * Copy constructor
     */
    inline  TMostState (const TMostState &rhs);

    /**
     * All fields constructor
     */
    inline  TMostState (T_SPM_e32_MOST_EVENT MostEvent_, T_SPM_e32_MOST_CONFIG_STATE MostConfigurationState_, uint32 FirstReceiveTime_, T_SPM_e32_TLA_STATE TLAState_, bool OvertemperatureMostOff_);

    /**
     * Destructor
     */
    inline  ~TMostState();

    /**
     * Assignment operator
     */
    inline TMostState& operator = (const TMostState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TMostState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TMostState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TMostState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TMostState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MostEvent"

    static const int kMostEvent = 0;

    /**
     * Clears the field "MostEvent".
     *
     * The field will be set to its default value. The hasMostEvent()
     * method will return false.
     */
    inline void clearMostEvent();

    /**
     * Checks whether the field "MostEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMostEvent()). Otherwise it will return false.
     */
    inline bool hasMostEvent () const;

    /**
     * Returns the value of the member "MostEvent".
     *
     * Latest MOST Event of the system.
     *
     * @return The value of the field "MostEvent"
     */
    inline T_SPM_e32_MOST_EVENT getMostEvent () const;

    /**
     * Sets the value of the member "MostEvent".
     *
     * Latest MOST Event of the system.
     *
     * @param MostEvent The value which will be set
     */
    inline void setMostEvent (T_SPM_e32_MOST_EVENT MostEvent_);

    // API of field "MostConfigurationState"

    static const int kMostConfigurationState = 1;

    /**
     * Clears the field "MostConfigurationState".
     *
     * The field will be set to its default value. The hasMostConfigurationState()
     * method will return false.
     */
    inline void clearMostConfigurationState();

    /**
     * Checks whether the field "MostConfigurationState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMostConfigurationState()). Otherwise it will return false.
     */
    inline bool hasMostConfigurationState () const;

    /**
     * Returns the value of the member "MostConfigurationState".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent.
     *
     * @return The value of the field "MostConfigurationState"
     */
    inline T_SPM_e32_MOST_CONFIG_STATE getMostConfigurationState () const;

    /**
     * Sets the value of the member "MostConfigurationState".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent.
     *
     * @param MostConfigurationState The value which will be set
     */
    inline void setMostConfigurationState (T_SPM_e32_MOST_CONFIG_STATE MostConfigurationState_);

    // API of field "FirstReceiveTime"

    static const int kFirstReceiveTime = 2;

    /**
     * Clears the field "FirstReceiveTime".
     *
     * The field will be set to its default value. The hasFirstReceiveTime()
     * method will return false.
     */
    inline void clearFirstReceiveTime();

    /**
     * Checks whether the field "FirstReceiveTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFirstReceiveTime()). Otherwise it will return false.
     */
    inline bool hasFirstReceiveTime () const;

    /**
     * Returns the value of the member "FirstReceiveTime".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent. It indicates the point in time when the first configuration was sent by the network master.
     *                 If not valid then the time information is set to 0. Resolution is always in ms.
     *
     * @return The value of the field "FirstReceiveTime"
     */
    inline uint32 getFirstReceiveTime () const;

    /**
     * Sets the value of the member "FirstReceiveTime".
     *
     * Additional information if the event SPM_U32_MOST_EVENT_CONFIG_STATE was sent. It indicates the point in time when the first configuration was sent by the network master.
     *                 If not valid then the time information is set to 0. Resolution is always in ms.
     *
     * @param FirstReceiveTime The value which will be set
     */
    inline void setFirstReceiveTime (uint32 FirstReceiveTime_);

    // API of field "TLAState"

    static const int kTLAState = 3;

    /**
     * Clears the field "TLAState".
     *
     * The field will be set to its default value. The hasTLAState()
     * method will return false.
     */
    inline void clearTLAState();

    /**
     * Checks whether the field "TLAState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLAState()). Otherwise it will return false.
     */
    inline bool hasTLAState () const;

    /**
     * Returns the value of the member "TLAState".
     *
     * Gives back the current TLA connected state
     *
     * @return The value of the field "TLAState"
     */
    inline T_SPM_e32_TLA_STATE getTLAState () const;

    /**
     * Sets the value of the member "TLAState".
     *
     * Gives back the current TLA connected state
     *
     * @param TLAState The value which will be set
     */
    inline void setTLAState (T_SPM_e32_TLA_STATE TLAState_);

    // API of field "OvertemperatureMostOff"

    static const int kOvertemperatureMostOff = 4;

    /**
     * Clears the field "OvertemperatureMostOff".
     *
     * The field will be set to its default value. The hasOvertemperatureMostOff()
     * method will return false.
     */
    inline void clearOvertemperatureMostOff();

    /**
     * Checks whether the field "OvertemperatureMostOff" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOvertemperatureMostOff()). Otherwise it will return false.
     */
    inline bool hasOvertemperatureMostOff () const;

    /**
     * Returns the value of the member "OvertemperatureMostOff".
     *
     * If set then all applications have reached "OFF" state. The CMA is requested to send all Netblocks off, and then disallows further communication between CCA and most. This state is stable until restart of the system.
     *
     * @return The value of the field "OvertemperatureMostOff"
     */
    inline bool getOvertemperatureMostOff () const;

    /**
     * Sets the value of the member "OvertemperatureMostOff".
     *
     * If set then all applications have reached "OFF" state. The CMA is requested to send all Netblocks off, and then disallows further communication between CCA and most. This state is stable until restart of the system.
     *
     * @param OvertemperatureMostOff The value which will be set
     */
    inline void setOvertemperatureMostOff (bool OvertemperatureMostOff_);

    static const TMostState &getDefaultInstance();

private:

    inline void set_has_MostEvent ();

    inline void clear_has_MostEvent ();

    inline void set_has_MostConfigurationState ();

    inline void clear_has_MostConfigurationState ();

    inline void set_has_FirstReceiveTime ();

    inline void clear_has_FirstReceiveTime ();

    inline void set_has_TLAState ();

    inline void clear_has_TLAState ();

    inline void set_has_OvertemperatureMostOff ();

    inline void clear_has_OvertemperatureMostOff ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_SPM_e32_MOST_EVENT _MostEvent;

    T_SPM_e32_MOST_CONFIG_STATE _MostConfigurationState;

    uint32 _FirstReceiveTime;

    T_SPM_e32_TLA_STATE _TLAState;

    bool _OvertemperatureMostOff;

};

/**
 * If the meaning of "TAlphacode" isn't clear, then there should be a description here.
 */
class TAlphacode {
public:

    /**
     * Default constructor
     */
    inline  TAlphacode ();

    /**
     * Copy constructor
     */
    inline  TAlphacode (const TAlphacode &rhs);

    /**
     * All fields constructor
     */
    inline  TAlphacode (uint8 Alphacode1_, uint8 Alphacode2_);

    /**
     * Destructor
     */
    inline  ~TAlphacode();

    /**
     * Assignment operator
     */
    inline TAlphacode& operator = (const TAlphacode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TAlphacode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TAlphacode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TAlphacode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TAlphacode& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Alphacode1"

    static const int kAlphacode1 = 0;

    /**
     * Clears the field "Alphacode1".
     *
     * The field will be set to its default value. The hasAlphacode1()
     * method will return false.
     */
    inline void clearAlphacode1();

    /**
     * Checks whether the field "Alphacode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode1()). Otherwise it will return false.
     */
    inline bool hasAlphacode1 () const;

    /**
     * Returns the value of the member "Alphacode1".
     *
     * First character of alphacode.
     *
     * @return The value of the field "Alphacode1"
     */
    inline uint8 getAlphacode1 () const;

    /**
     * Sets the value of the member "Alphacode1".
     *
     * First character of alphacode.
     *
     * @param Alphacode1 The value which will be set
     */
    inline void setAlphacode1 (uint8 Alphacode1_);

    // API of field "Alphacode2"

    static const int kAlphacode2 = 1;

    /**
     * Clears the field "Alphacode2".
     *
     * The field will be set to its default value. The hasAlphacode2()
     * method will return false.
     */
    inline void clearAlphacode2();

    /**
     * Checks whether the field "Alphacode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode2()). Otherwise it will return false.
     */
    inline bool hasAlphacode2 () const;

    /**
     * Returns the value of the member "Alphacode2".
     *
     * Second character of alphacode.
     *
     * @return The value of the field "Alphacode2"
     */
    inline uint8 getAlphacode2 () const;

    /**
     * Sets the value of the member "Alphacode2".
     *
     * Second character of alphacode.
     *
     * @param Alphacode2 The value which will be set
     */
    inline void setAlphacode2 (uint8 Alphacode2_);

    static const TAlphacode &getDefaultInstance();

private:

    inline void set_has_Alphacode1 ();

    inline void clear_has_Alphacode1 ();

    inline void set_has_Alphacode2 ();

    inline void clear_has_Alphacode2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Alphacode1;

    uint8 _Alphacode2;

};

/**
 * If the meaning of "T_b32_SubState0" isn't clear, then there should be a description here.
 */
class T_b32_SubState0 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState0 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState0 (const T_b32_SubState0 &rhs);

    /**
     * All fields constructor
     */
    inline  T_b32_SubState0 (uint32 u32Bitfield_);

    /**
     * Destructor
     */
    inline  ~T_b32_SubState0();

    /**
     * Assignment operator
     */
    inline T_b32_SubState0& operator = (const T_b32_SubState0& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState0& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState0& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState0& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState0& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Bitfield"

    static const int kU32Bitfield = 0;

    /**
     * Clears the field "u32Bitfield".
     *
     * The field will be set to its default value. The hasU32Bitfield()
     * method will return false.
     */
    inline void clearU32Bitfield();

    /**
     * Checks whether the field "u32Bitfield" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Bitfield()). Otherwise it will return false.
     */
    inline bool hasU32Bitfield () const;

    /**
     * Returns the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @return The value of the field "u32Bitfield"
     */
    inline uint32 getU32Bitfield () const;

    /**
     * Sets the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @param u32Bitfield The value which will be set
     */
    inline void setU32Bitfield (uint32 u32Bitfield_);

    static const T_b32_SubState0 &getDefaultInstance();

private:

    inline void set_has_u32Bitfield ();

    inline void clear_has_u32Bitfield ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Bitfield;

};

/**
 * If the meaning of "T_b32_SubState1" isn't clear, then there should be a description here.
 */
class T_b32_SubState1 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState1 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState1 (const T_b32_SubState1 &rhs);

    /**
     * All fields constructor
     */
    inline  T_b32_SubState1 (uint32 u32Bitfield_);

    /**
     * Destructor
     */
    inline  ~T_b32_SubState1();

    /**
     * Assignment operator
     */
    inline T_b32_SubState1& operator = (const T_b32_SubState1& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState1& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState1& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState1& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState1& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Bitfield"

    static const int kU32Bitfield = 0;

    /**
     * Clears the field "u32Bitfield".
     *
     * The field will be set to its default value. The hasU32Bitfield()
     * method will return false.
     */
    inline void clearU32Bitfield();

    /**
     * Checks whether the field "u32Bitfield" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Bitfield()). Otherwise it will return false.
     */
    inline bool hasU32Bitfield () const;

    /**
     * Returns the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @return The value of the field "u32Bitfield"
     */
    inline uint32 getU32Bitfield () const;

    /**
     * Sets the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @param u32Bitfield The value which will be set
     */
    inline void setU32Bitfield (uint32 u32Bitfield_);

    static const T_b32_SubState1 &getDefaultInstance();

private:

    inline void set_has_u32Bitfield ();

    inline void clear_has_u32Bitfield ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Bitfield;

};

/**
 * If the meaning of "T_b32_SubState2" isn't clear, then there should be a description here.
 */
class T_b32_SubState2 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState2 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState2 (const T_b32_SubState2 &rhs);

    /**
     * All fields constructor
     */
    inline  T_b32_SubState2 (uint32 u32Bitfield_);

    /**
     * Destructor
     */
    inline  ~T_b32_SubState2();

    /**
     * Assignment operator
     */
    inline T_b32_SubState2& operator = (const T_b32_SubState2& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState2& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState2& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState2& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState2& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Bitfield"

    static const int kU32Bitfield = 0;

    /**
     * Clears the field "u32Bitfield".
     *
     * The field will be set to its default value. The hasU32Bitfield()
     * method will return false.
     */
    inline void clearU32Bitfield();

    /**
     * Checks whether the field "u32Bitfield" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Bitfield()). Otherwise it will return false.
     */
    inline bool hasU32Bitfield () const;

    /**
     * Returns the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @return The value of the field "u32Bitfield"
     */
    inline uint32 getU32Bitfield () const;

    /**
     * Sets the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @param u32Bitfield The value which will be set
     */
    inline void setU32Bitfield (uint32 u32Bitfield_);

    static const T_b32_SubState2 &getDefaultInstance();

private:

    inline void set_has_u32Bitfield ();

    inline void clear_has_u32Bitfield ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Bitfield;

};

/**
 * If the meaning of "T_b32_SubState3" isn't clear, then there should be a description here.
 */
class T_b32_SubState3 {
public:

    /**
     * Default constructor
     */
    inline  T_b32_SubState3 ();

    /**
     * Copy constructor
     */
    inline  T_b32_SubState3 (const T_b32_SubState3 &rhs);

    /**
     * All fields constructor
     */
    inline  T_b32_SubState3 (uint32 u32Bitfield_);

    /**
     * Destructor
     */
    inline  ~T_b32_SubState3();

    /**
     * Assignment operator
     */
    inline T_b32_SubState3& operator = (const T_b32_SubState3& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_b32_SubState3& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_b32_SubState3& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_b32_SubState3& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_b32_SubState3& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Bitfield"

    static const int kU32Bitfield = 0;

    /**
     * Clears the field "u32Bitfield".
     *
     * The field will be set to its default value. The hasU32Bitfield()
     * method will return false.
     */
    inline void clearU32Bitfield();

    /**
     * Checks whether the field "u32Bitfield" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Bitfield()). Otherwise it will return false.
     */
    inline bool hasU32Bitfield () const;

    /**
     * Returns the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @return The value of the field "u32Bitfield"
     */
    inline uint32 getU32Bitfield () const;

    /**
     * Sets the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @param u32Bitfield The value which will be set
     */
    inline void setU32Bitfield (uint32 u32Bitfield_);

    static const T_b32_SubState3 &getDefaultInstance();

private:

    inline void set_has_u32Bitfield ();

    inline void clear_has_u32Bitfield ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Bitfield;

};

/**
 * If the meaning of "T_SPM_b32_DIM_STATE" isn't clear, then there should be a description here.
 */
class T_SPM_b32_DIM_STATE {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_b32_DIM_STATE ();

    /**
     * Copy constructor
     */
    inline  T_SPM_b32_DIM_STATE (const T_SPM_b32_DIM_STATE &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_b32_DIM_STATE (uint32 u32Bitfield_);

    /**
     * Destructor
     */
    inline  ~T_SPM_b32_DIM_STATE();

    /**
     * Assignment operator
     */
    inline T_SPM_b32_DIM_STATE& operator = (const T_SPM_b32_DIM_STATE& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_b32_DIM_STATE& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Bitfield"

    static const int kU32Bitfield = 0;

    /**
     * Clears the field "u32Bitfield".
     *
     * The field will be set to its default value. The hasU32Bitfield()
     * method will return false.
     */
    inline void clearU32Bitfield();

    /**
     * Checks whether the field "u32Bitfield" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Bitfield()). Otherwise it will return false.
     */
    inline bool hasU32Bitfield () const;

    /**
     * Returns the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @return The value of the field "u32Bitfield"
     */
    inline uint32 getU32Bitfield () const;

    /**
     * Sets the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @param u32Bitfield The value which will be set
     */
    inline void setU32Bitfield (uint32 u32Bitfield_);

    static const T_SPM_b32_DIM_STATE &getDefaultInstance();

private:

    inline void set_has_u32Bitfield ();

    inline void clear_has_u32Bitfield ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Bitfield;

};

/**
 * If the meaning of "T_SPM_b32_SYSPWRSAVEMODE" isn't clear, then there should be a description here.
 */
class T_SPM_b32_SYSPWRSAVEMODE {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_b32_SYSPWRSAVEMODE ();

    /**
     * Copy constructor
     */
    inline  T_SPM_b32_SYSPWRSAVEMODE (const T_SPM_b32_SYSPWRSAVEMODE &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_b32_SYSPWRSAVEMODE (uint32 u32Bitfield_);

    /**
     * Destructor
     */
    inline  ~T_SPM_b32_SYSPWRSAVEMODE();

    /**
     * Assignment operator
     */
    inline T_SPM_b32_SYSPWRSAVEMODE& operator = (const T_SPM_b32_SYSPWRSAVEMODE& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_b32_SYSPWRSAVEMODE& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Bitfield"

    static const int kU32Bitfield = 0;

    /**
     * Clears the field "u32Bitfield".
     *
     * The field will be set to its default value. The hasU32Bitfield()
     * method will return false.
     */
    inline void clearU32Bitfield();

    /**
     * Checks whether the field "u32Bitfield" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Bitfield()). Otherwise it will return false.
     */
    inline bool hasU32Bitfield () const;

    /**
     * Returns the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @return The value of the field "u32Bitfield"
     */
    inline uint32 getU32Bitfield () const;

    /**
     * Sets the value of the member "u32Bitfield".
     *
     * bitfield type mapped to UInt32
     *
     * @param u32Bitfield The value which will be set
     */
    inline void setU32Bitfield (uint32 u32Bitfield_);

    static const T_SPM_b32_SYSPWRSAVEMODE &getDefaultInstance();

private:

    inline void set_has_u32Bitfield ();

    inline void clear_has_u32Bitfield ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _u32Bitfield;

};

/**
 * If the meaning of "TSwVersionInfo" isn't clear, then there should be a description here.
 */
class TSwVersionInfo {
public:

    /**
     * Default constructor
     */
    inline  TSwVersionInfo ();

    /**
     * Copy constructor
     */
    inline  TSwVersionInfo (const TSwVersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  TSwVersionInfo (const ::std::string& tSwBuildVersion_, const ::std::string& tSwCustomerVersion_);

    /**
     * Destructor
     */
    inline  ~TSwVersionInfo();

    /**
     * Assignment operator
     */
    inline TSwVersionInfo& operator = (const TSwVersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TSwVersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TSwVersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TSwVersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TSwVersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSwBuildVersion"

    static const int kTSwBuildVersion = 0;

    /**
     * Clears the field "tSwBuildVersion".
     *
     * The field will be set to its default value. The hasTSwBuildVersion()
     * method will return false.
     */
    inline void clearTSwBuildVersion();

    /**
     * Checks whether the field "tSwBuildVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwBuildVersion()). Otherwise it will return false.
     */
    inline bool hasTSwBuildVersion () const;

    /**
     * Returns the value of the member "tSwBuildVersion".
     *
     *
     *
     * @return The value of the field "tSwBuildVersion"
     */
    inline const ::std::string& getTSwBuildVersion () const;

    /**
     * Retrieves the value of the field "tSwBuildVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwBuildVersion".
     */
    inline ::std::string& getTSwBuildVersionMutable ();

    /**
     * Sets the value of the member "tSwBuildVersion".
     *
     *
     *
     * @param tSwBuildVersion The value which will be set
     */
    inline void setTSwBuildVersion (const ::std::string& tSwBuildVersion_);

    /**
     * Sets the value of the member "tSwBuildVersion".
     *
     *
     *
     * @param tSwBuildVersion The value which will be set
     */
    inline void setTSwBuildVersion (const char* tSwBuildVersion_);

    /**
     * Sets the value of the member "tSwBuildVersion".
     *
     *
     *
     * @param tSwBuildVersion The value which will be set
     */
    inline void setTSwBuildVersion (const char* value, size_t size);

    // API of field "tSwCustomerVersion"

    static const int kTSwCustomerVersion = 1;

    /**
     * Clears the field "tSwCustomerVersion".
     *
     * The field will be set to its default value. The hasTSwCustomerVersion()
     * method will return false.
     */
    inline void clearTSwCustomerVersion();

    /**
     * Checks whether the field "tSwCustomerVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwCustomerVersion()). Otherwise it will return false.
     */
    inline bool hasTSwCustomerVersion () const;

    /**
     * Returns the value of the member "tSwCustomerVersion".
     *
     *
     *
     * @return The value of the field "tSwCustomerVersion"
     */
    inline const ::std::string& getTSwCustomerVersion () const;

    /**
     * Retrieves the value of the field "tSwCustomerVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwCustomerVersion".
     */
    inline ::std::string& getTSwCustomerVersionMutable ();

    /**
     * Sets the value of the member "tSwCustomerVersion".
     *
     *
     *
     * @param tSwCustomerVersion The value which will be set
     */
    inline void setTSwCustomerVersion (const ::std::string& tSwCustomerVersion_);

    /**
     * Sets the value of the member "tSwCustomerVersion".
     *
     *
     *
     * @param tSwCustomerVersion The value which will be set
     */
    inline void setTSwCustomerVersion (const char* tSwCustomerVersion_);

    /**
     * Sets the value of the member "tSwCustomerVersion".
     *
     *
     *
     * @param tSwCustomerVersion The value which will be set
     */
    inline void setTSwCustomerVersion (const char* value, size_t size);

    static const TSwVersionInfo &getDefaultInstance();

private:

    inline void set_has_tSwBuildVersion ();

    inline void clear_has_tSwBuildVersion ();

    inline void set_has_tSwCustomerVersion ();

    inline void clear_has_tSwCustomerVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _tSwBuildVersion;

    ::std::string _tSwCustomerVersion;

};

/**
 * If the meaning of "T_SPM_HistoryTrigger" isn't clear, then there should be a description here.
 */
class T_SPM_HistoryTrigger {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_HistoryTrigger ();

    /**
     * Copy constructor
     */
    inline  T_SPM_HistoryTrigger (const T_SPM_HistoryTrigger &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_HistoryTrigger (uint32 u32Timestamp_, T_SPM_e32_SubStateType eTriggerType_);

    /**
     * Destructor
     */
    inline  ~T_SPM_HistoryTrigger();

    /**
     * Assignment operator
     */
    inline T_SPM_HistoryTrigger& operator = (const T_SPM_HistoryTrigger& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_HistoryTrigger& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32Timestamp"

    static const int kU32Timestamp = 0;

    /**
     * Clears the field "u32Timestamp".
     *
     * The field will be set to its default value. The hasU32Timestamp()
     * method will return false.
     */
    inline void clearU32Timestamp();

    /**
     * Checks whether the field "u32Timestamp" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Timestamp()). Otherwise it will return false.
     */
    inline bool hasU32Timestamp () const;

    /**
     * Returns the value of the member "u32Timestamp".
     *
     *
     *
     * @return The value of the field "u32Timestamp"
     */
    inline uint32 getU32Timestamp () const;

    /**
     * Sets the value of the member "u32Timestamp".
     *
     *
     *
     * @param u32Timestamp The value which will be set
     */
    inline void setU32Timestamp (uint32 u32Timestamp_);

    // API of field "eTriggerType"

    static const int kETriggerType = 1;

    /**
     * Clears the field "eTriggerType".
     *
     * The field will be set to its default value. The hasETriggerType()
     * method will return false.
     */
    inline void clearETriggerType();

    /**
     * Checks whether the field "eTriggerType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setETriggerType()). Otherwise it will return false.
     */
    inline bool hasETriggerType () const;

    /**
     * Returns the value of the member "eTriggerType".
     *
     *
     *
     * @return The value of the field "eTriggerType"
     */
    inline T_SPM_e32_SubStateType getETriggerType () const;

    /**
     * Sets the value of the member "eTriggerType".
     *
     *
     *
     * @param eTriggerType The value which will be set
     */
    inline void setETriggerType (T_SPM_e32_SubStateType eTriggerType_);

    static const T_SPM_HistoryTrigger &getDefaultInstance();

private:

    inline void set_has_u32Timestamp ();

    inline void clear_has_u32Timestamp ();

    inline void set_has_eTriggerType ();

    inline void clear_has_eTriggerType ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32Timestamp;

    T_SPM_e32_SubStateType _eTriggerType;

};

/**
 * If the meaning of "T_SPM_TransPortMode" isn't clear, then there should be a description here.
 */
class T_SPM_TransPortMode {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_TransPortMode ();

    /**
     * Copy constructor
     */
    inline  T_SPM_TransPortMode (const T_SPM_TransPortMode &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_TransPortMode (uint32 YEAR_, uint32 MONTH_, uint32 DAY_, uint32 HOUR_, uint32 MINUTE_);

    /**
     * Destructor
     */
    inline  ~T_SPM_TransPortMode();

    /**
     * Assignment operator
     */
    inline T_SPM_TransPortMode& operator = (const T_SPM_TransPortMode& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_TransPortMode& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_TransPortMode& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_TransPortMode& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_TransPortMode& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "YEAR"

    static const int kYEAR = 0;

    /**
     * Clears the field "YEAR".
     *
     * The field will be set to its default value. The hasYEAR()
     * method will return false.
     */
    inline void clearYEAR();

    /**
     * Checks whether the field "YEAR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setYEAR()). Otherwise it will return false.
     */
    inline bool hasYEAR () const;

    /**
     * Returns the value of the member "YEAR".
     *
     *
     *
     * @return The value of the field "YEAR"
     */
    inline uint32 getYEAR () const;

    /**
     * Sets the value of the member "YEAR".
     *
     *
     *
     * @param YEAR The value which will be set
     */
    inline void setYEAR (uint32 YEAR_);

    // API of field "MONTH"

    static const int kMONTH = 1;

    /**
     * Clears the field "MONTH".
     *
     * The field will be set to its default value. The hasMONTH()
     * method will return false.
     */
    inline void clearMONTH();

    /**
     * Checks whether the field "MONTH" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMONTH()). Otherwise it will return false.
     */
    inline bool hasMONTH () const;

    /**
     * Returns the value of the member "MONTH".
     *
     *
     *
     * @return The value of the field "MONTH"
     */
    inline uint32 getMONTH () const;

    /**
     * Sets the value of the member "MONTH".
     *
     *
     *
     * @param MONTH The value which will be set
     */
    inline void setMONTH (uint32 MONTH_);

    // API of field "DAY"

    static const int kDAY = 2;

    /**
     * Clears the field "DAY".
     *
     * The field will be set to its default value. The hasDAY()
     * method will return false.
     */
    inline void clearDAY();

    /**
     * Checks whether the field "DAY" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDAY()). Otherwise it will return false.
     */
    inline bool hasDAY () const;

    /**
     * Returns the value of the member "DAY".
     *
     *
     *
     * @return The value of the field "DAY"
     */
    inline uint32 getDAY () const;

    /**
     * Sets the value of the member "DAY".
     *
     *
     *
     * @param DAY The value which will be set
     */
    inline void setDAY (uint32 DAY_);

    // API of field "HOUR"

    static const int kHOUR = 3;

    /**
     * Clears the field "HOUR".
     *
     * The field will be set to its default value. The hasHOUR()
     * method will return false.
     */
    inline void clearHOUR();

    /**
     * Checks whether the field "HOUR" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHOUR()). Otherwise it will return false.
     */
    inline bool hasHOUR () const;

    /**
     * Returns the value of the member "HOUR".
     *
     *
     *
     * @return The value of the field "HOUR"
     */
    inline uint32 getHOUR () const;

    /**
     * Sets the value of the member "HOUR".
     *
     *
     *
     * @param HOUR The value which will be set
     */
    inline void setHOUR (uint32 HOUR_);

    // API of field "MINUTE"

    static const int kMINUTE = 4;

    /**
     * Clears the field "MINUTE".
     *
     * The field will be set to its default value. The hasMINUTE()
     * method will return false.
     */
    inline void clearMINUTE();

    /**
     * Checks whether the field "MINUTE" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMINUTE()). Otherwise it will return false.
     */
    inline bool hasMINUTE () const;

    /**
     * Returns the value of the member "MINUTE".
     *
     *
     *
     * @return The value of the field "MINUTE"
     */
    inline uint32 getMINUTE () const;

    /**
     * Sets the value of the member "MINUTE".
     *
     *
     *
     * @param MINUTE The value which will be set
     */
    inline void setMINUTE (uint32 MINUTE_);

    static const T_SPM_TransPortMode &getDefaultInstance();

private:

    inline void set_has_YEAR ();

    inline void clear_has_YEAR ();

    inline void set_has_MONTH ();

    inline void clear_has_MONTH ();

    inline void set_has_DAY ();

    inline void clear_has_DAY ();

    inline void set_has_HOUR ();

    inline void clear_has_HOUR ();

    inline void set_has_MINUTE ();

    inline void clear_has_MINUTE ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint32 _YEAR;

    uint32 _MONTH;

    uint32 _DAY;

    uint32 _HOUR;

    uint32 _MINUTE;

};

/**
 * If the meaning of "T_SPM_TransPortModeList" isn't clear, then there should be a description here.
 */
class T_SPM_TransPortModeList {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_TransPortModeList ();

    /**
     * Copy constructor
     */
    inline  T_SPM_TransPortModeList (const T_SPM_TransPortModeList &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_TransPortModeList (const ::std::vector< T_SPM_TransPortMode >& TransPortModeList_);

    /**
     * Destructor
     */
    inline  ~T_SPM_TransPortModeList();

    /**
     * Assignment operator
     */
    inline T_SPM_TransPortModeList& operator = (const T_SPM_TransPortModeList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_TransPortModeList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_TransPortModeList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_TransPortModeList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_TransPortModeList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TransPortModeList"

    static const int kTransPortModeList = 0;

    /**
     * Clears the field "TransPortModeList".
     *
     * The field will be set to its default value. The hasTransPortModeList()
     * method will return false.
     */
    inline void clearTransPortModeList();

    /**
     * Checks whether the field "TransPortModeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransPortModeList()). Otherwise it will return false.
     */
    inline bool hasTransPortModeList () const;

    /**
     * Returns the value of the member "TransPortModeList".
     *
     * The TransPortModeList contains a number of TransportModeDate.
     *
     * @return The value of the field "TransPortModeList"
     */
    inline const ::std::vector< T_SPM_TransPortMode >& getTransPortModeList () const;

    /**
     * Retrieves the value of the field "TransPortModeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TransPortModeList".
     */
    inline ::std::vector< T_SPM_TransPortMode >& getTransPortModeListMutable ();

    /**
     * Sets the value of the member "TransPortModeList".
     *
     * The TransPortModeList contains a number of TransportModeDate.
     *
     * @param TransPortModeList The value which will be set
     */
    inline void setTransPortModeList (const ::std::vector< T_SPM_TransPortMode >& TransPortModeList_);

    static const T_SPM_TransPortModeList &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_TransPortMode >& getT_SPM_TransPortModeList_DefaultInstance ();

    inline void set_has_TransPortModeList ();

    inline void clear_has_TransPortModeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_TransPortMode > _TransPortModeList;

};

/**
 * If the meaning of "T_SubStateEntry" isn't clear, then there should be a description here.
 */
class T_SubStateEntry {
public:

    /**
     * Default constructor
     */
    inline  T_SubStateEntry ();

    /**
     * Copy constructor
     */
    inline  T_SubStateEntry (const T_SubStateEntry &rhs);

    /**
     * All fields constructor
     */
    inline  T_SubStateEntry (const T_b32_SubState0& tSubStateMask0_, const T_b32_SubState0& tSubStateData0_, const T_b32_SubState1& tSubStateMask1_, const T_b32_SubState1& tSubStateData1_, const T_b32_SubState2& tSubStateMask2_, const T_b32_SubState2& tSubStateData2_, const T_b32_SubState3& tSubStateMask3_, const T_b32_SubState3& tSubStateData3_);

    /**
     * Destructor
     */
    inline  ~T_SubStateEntry();

    /**
     * Assignment operator
     */
    inline T_SubStateEntry& operator = (const T_SubStateEntry& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SubStateEntry& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SubStateEntry& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SubStateEntry& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SubStateEntry& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSubStateMask0"

    static const int kTSubStateMask0 = 0;

    /**
     * Clears the field "tSubStateMask0".
     *
     * The field will be set to its default value. The hasTSubStateMask0()
     * method will return false.
     */
    inline void clearTSubStateMask0();

    /**
     * Checks whether the field "tSubStateMask0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask0()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask0 () const;

    /**
     * Returns the value of the member "tSubStateMask0".
     *
     *
     *
     * @return The value of the field "tSubStateMask0"
     */
    inline const T_b32_SubState0& getTSubStateMask0 () const;

    /**
     * Retrieves the value of the field "tSubStateMask0" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask0".
     */
    inline T_b32_SubState0& getTSubStateMask0Mutable ();

    /**
     * Sets the value of the member "tSubStateMask0".
     *
     *
     *
     * @param tSubStateMask0 The value which will be set
     */
    inline void setTSubStateMask0 (const T_b32_SubState0& tSubStateMask0_);

    // API of field "tSubStateData0"

    static const int kTSubStateData0 = 1;

    /**
     * Clears the field "tSubStateData0".
     *
     * The field will be set to its default value. The hasTSubStateData0()
     * method will return false.
     */
    inline void clearTSubStateData0();

    /**
     * Checks whether the field "tSubStateData0" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData0()). Otherwise it will return false.
     */
    inline bool hasTSubStateData0 () const;

    /**
     * Returns the value of the member "tSubStateData0".
     *
     *
     *
     * @return The value of the field "tSubStateData0"
     */
    inline const T_b32_SubState0& getTSubStateData0 () const;

    /**
     * Retrieves the value of the field "tSubStateData0" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData0".
     */
    inline T_b32_SubState0& getTSubStateData0Mutable ();

    /**
     * Sets the value of the member "tSubStateData0".
     *
     *
     *
     * @param tSubStateData0 The value which will be set
     */
    inline void setTSubStateData0 (const T_b32_SubState0& tSubStateData0_);

    // API of field "tSubStateMask1"

    static const int kTSubStateMask1 = 2;

    /**
     * Clears the field "tSubStateMask1".
     *
     * The field will be set to its default value. The hasTSubStateMask1()
     * method will return false.
     */
    inline void clearTSubStateMask1();

    /**
     * Checks whether the field "tSubStateMask1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask1()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask1 () const;

    /**
     * Returns the value of the member "tSubStateMask1".
     *
     *
     *
     * @return The value of the field "tSubStateMask1"
     */
    inline const T_b32_SubState1& getTSubStateMask1 () const;

    /**
     * Retrieves the value of the field "tSubStateMask1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask1".
     */
    inline T_b32_SubState1& getTSubStateMask1Mutable ();

    /**
     * Sets the value of the member "tSubStateMask1".
     *
     *
     *
     * @param tSubStateMask1 The value which will be set
     */
    inline void setTSubStateMask1 (const T_b32_SubState1& tSubStateMask1_);

    // API of field "tSubStateData1"

    static const int kTSubStateData1 = 3;

    /**
     * Clears the field "tSubStateData1".
     *
     * The field will be set to its default value. The hasTSubStateData1()
     * method will return false.
     */
    inline void clearTSubStateData1();

    /**
     * Checks whether the field "tSubStateData1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData1()). Otherwise it will return false.
     */
    inline bool hasTSubStateData1 () const;

    /**
     * Returns the value of the member "tSubStateData1".
     *
     *
     *
     * @return The value of the field "tSubStateData1"
     */
    inline const T_b32_SubState1& getTSubStateData1 () const;

    /**
     * Retrieves the value of the field "tSubStateData1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData1".
     */
    inline T_b32_SubState1& getTSubStateData1Mutable ();

    /**
     * Sets the value of the member "tSubStateData1".
     *
     *
     *
     * @param tSubStateData1 The value which will be set
     */
    inline void setTSubStateData1 (const T_b32_SubState1& tSubStateData1_);

    // API of field "tSubStateMask2"

    static const int kTSubStateMask2 = 4;

    /**
     * Clears the field "tSubStateMask2".
     *
     * The field will be set to its default value. The hasTSubStateMask2()
     * method will return false.
     */
    inline void clearTSubStateMask2();

    /**
     * Checks whether the field "tSubStateMask2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask2()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask2 () const;

    /**
     * Returns the value of the member "tSubStateMask2".
     *
     *
     *
     * @return The value of the field "tSubStateMask2"
     */
    inline const T_b32_SubState2& getTSubStateMask2 () const;

    /**
     * Retrieves the value of the field "tSubStateMask2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask2".
     */
    inline T_b32_SubState2& getTSubStateMask2Mutable ();

    /**
     * Sets the value of the member "tSubStateMask2".
     *
     *
     *
     * @param tSubStateMask2 The value which will be set
     */
    inline void setTSubStateMask2 (const T_b32_SubState2& tSubStateMask2_);

    // API of field "tSubStateData2"

    static const int kTSubStateData2 = 5;

    /**
     * Clears the field "tSubStateData2".
     *
     * The field will be set to its default value. The hasTSubStateData2()
     * method will return false.
     */
    inline void clearTSubStateData2();

    /**
     * Checks whether the field "tSubStateData2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData2()). Otherwise it will return false.
     */
    inline bool hasTSubStateData2 () const;

    /**
     * Returns the value of the member "tSubStateData2".
     *
     *
     *
     * @return The value of the field "tSubStateData2"
     */
    inline const T_b32_SubState2& getTSubStateData2 () const;

    /**
     * Retrieves the value of the field "tSubStateData2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData2".
     */
    inline T_b32_SubState2& getTSubStateData2Mutable ();

    /**
     * Sets the value of the member "tSubStateData2".
     *
     *
     *
     * @param tSubStateData2 The value which will be set
     */
    inline void setTSubStateData2 (const T_b32_SubState2& tSubStateData2_);

    // API of field "tSubStateMask3"

    static const int kTSubStateMask3 = 6;

    /**
     * Clears the field "tSubStateMask3".
     *
     * The field will be set to its default value. The hasTSubStateMask3()
     * method will return false.
     */
    inline void clearTSubStateMask3();

    /**
     * Checks whether the field "tSubStateMask3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateMask3()). Otherwise it will return false.
     */
    inline bool hasTSubStateMask3 () const;

    /**
     * Returns the value of the member "tSubStateMask3".
     *
     *
     *
     * @return The value of the field "tSubStateMask3"
     */
    inline const T_b32_SubState3& getTSubStateMask3 () const;

    /**
     * Retrieves the value of the field "tSubStateMask3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateMask3".
     */
    inline T_b32_SubState3& getTSubStateMask3Mutable ();

    /**
     * Sets the value of the member "tSubStateMask3".
     *
     *
     *
     * @param tSubStateMask3 The value which will be set
     */
    inline void setTSubStateMask3 (const T_b32_SubState3& tSubStateMask3_);

    // API of field "tSubStateData3"

    static const int kTSubStateData3 = 7;

    /**
     * Clears the field "tSubStateData3".
     *
     * The field will be set to its default value. The hasTSubStateData3()
     * method will return false.
     */
    inline void clearTSubStateData3();

    /**
     * Checks whether the field "tSubStateData3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStateData3()). Otherwise it will return false.
     */
    inline bool hasTSubStateData3 () const;

    /**
     * Returns the value of the member "tSubStateData3".
     *
     *
     *
     * @return The value of the field "tSubStateData3"
     */
    inline const T_b32_SubState3& getTSubStateData3 () const;

    /**
     * Retrieves the value of the field "tSubStateData3" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStateData3".
     */
    inline T_b32_SubState3& getTSubStateData3Mutable ();

    /**
     * Sets the value of the member "tSubStateData3".
     *
     *
     *
     * @param tSubStateData3 The value which will be set
     */
    inline void setTSubStateData3 (const T_b32_SubState3& tSubStateData3_);

    static const T_SubStateEntry &getDefaultInstance();

private:

    inline void set_has_tSubStateMask0 ();

    inline void clear_has_tSubStateMask0 ();

    inline void set_has_tSubStateData0 ();

    inline void clear_has_tSubStateData0 ();

    inline void set_has_tSubStateMask1 ();

    inline void clear_has_tSubStateMask1 ();

    inline void set_has_tSubStateData1 ();

    inline void clear_has_tSubStateData1 ();

    inline void set_has_tSubStateMask2 ();

    inline void clear_has_tSubStateMask2 ();

    inline void set_has_tSubStateData2 ();

    inline void clear_has_tSubStateData2 ();

    inline void set_has_tSubStateMask3 ();

    inline void clear_has_tSubStateMask3 ();

    inline void set_has_tSubStateData3 ();

    inline void clear_has_tSubStateData3 ();

    uint32 _has_bits_[ (8 + 31) / 32];

    T_b32_SubState0 _tSubStateMask0;

    T_b32_SubState0 _tSubStateData0;

    T_b32_SubState1 _tSubStateMask1;

    T_b32_SubState1 _tSubStateData1;

    T_b32_SubState2 _tSubStateMask2;

    T_b32_SubState2 _tSubStateData2;

    T_b32_SubState3 _tSubStateMask3;

    T_b32_SubState3 _tSubStateData3;

};

/**
 * If the meaning of "T_ProcessElement" isn't clear, then there should be a description here.
 */
class T_ProcessElement {
public:

    /**
     * Default constructor
     */
    inline  T_ProcessElement ();

    /**
     * Copy constructor
     */
    inline  T_ProcessElement (const T_ProcessElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProcessElement (const ::std::string& tProcessName_, const ::std::string& tConfiguredProcessName_, T_e8_ProcessState eProcState_, uint32 u32StartTimeSinceStart_, const TTimeDate& tSwitchOnDate_);

    /**
     * Destructor
     */
    inline  ~T_ProcessElement();

    /**
     * Assignment operator
     */
    inline T_ProcessElement& operator = (const T_ProcessElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProcessElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProcessElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProcessElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProcessElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tProcessName"

    static const int kTProcessName = 0;

    /**
     * Clears the field "tProcessName".
     *
     * The field will be set to its default value. The hasTProcessName()
     * method will return false.
     */
    inline void clearTProcessName();

    /**
     * Checks whether the field "tProcessName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTProcessName()). Otherwise it will return false.
     */
    inline bool hasTProcessName () const;

    /**
     * Returns the value of the member "tProcessName".
     *
     *
     *
     * @return The value of the field "tProcessName"
     */
    inline const ::std::string& getTProcessName () const;

    /**
     * Retrieves the value of the field "tProcessName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tProcessName".
     */
    inline ::std::string& getTProcessNameMutable ();

    /**
     * Sets the value of the member "tProcessName".
     *
     *
     *
     * @param tProcessName The value which will be set
     */
    inline void setTProcessName (const ::std::string& tProcessName_);

    /**
     * Sets the value of the member "tProcessName".
     *
     *
     *
     * @param tProcessName The value which will be set
     */
    inline void setTProcessName (const char* tProcessName_);

    /**
     * Sets the value of the member "tProcessName".
     *
     *
     *
     * @param tProcessName The value which will be set
     */
    inline void setTProcessName (const char* value, size_t size);

    // API of field "tConfiguredProcessName"

    static const int kTConfiguredProcessName = 1;

    /**
     * Clears the field "tConfiguredProcessName".
     *
     * The field will be set to its default value. The hasTConfiguredProcessName()
     * method will return false.
     */
    inline void clearTConfiguredProcessName();

    /**
     * Checks whether the field "tConfiguredProcessName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTConfiguredProcessName()). Otherwise it will return false.
     */
    inline bool hasTConfiguredProcessName () const;

    /**
     * Returns the value of the member "tConfiguredProcessName".
     *
     *
     *
     * @return The value of the field "tConfiguredProcessName"
     */
    inline const ::std::string& getTConfiguredProcessName () const;

    /**
     * Retrieves the value of the field "tConfiguredProcessName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tConfiguredProcessName".
     */
    inline ::std::string& getTConfiguredProcessNameMutable ();

    /**
     * Sets the value of the member "tConfiguredProcessName".
     *
     *
     *
     * @param tConfiguredProcessName The value which will be set
     */
    inline void setTConfiguredProcessName (const ::std::string& tConfiguredProcessName_);

    /**
     * Sets the value of the member "tConfiguredProcessName".
     *
     *
     *
     * @param tConfiguredProcessName The value which will be set
     */
    inline void setTConfiguredProcessName (const char* tConfiguredProcessName_);

    /**
     * Sets the value of the member "tConfiguredProcessName".
     *
     *
     *
     * @param tConfiguredProcessName The value which will be set
     */
    inline void setTConfiguredProcessName (const char* value, size_t size);

    // API of field "eProcState"

    static const int kEProcState = 2;

    /**
     * Clears the field "eProcState".
     *
     * The field will be set to its default value. The hasEProcState()
     * method will return false.
     */
    inline void clearEProcState();

    /**
     * Checks whether the field "eProcState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEProcState()). Otherwise it will return false.
     */
    inline bool hasEProcState () const;

    /**
     * Returns the value of the member "eProcState".
     *
     *
     *
     * @return The value of the field "eProcState"
     */
    inline T_e8_ProcessState getEProcState () const;

    /**
     * Sets the value of the member "eProcState".
     *
     *
     *
     * @param eProcState The value which will be set
     */
    inline void setEProcState (T_e8_ProcessState eProcState_);

    // API of field "u32StartTimeSinceStart"

    static const int kU32StartTimeSinceStart = 3;

    /**
     * Clears the field "u32StartTimeSinceStart".
     *
     * The field will be set to its default value. The hasU32StartTimeSinceStart()
     * method will return false.
     */
    inline void clearU32StartTimeSinceStart();

    /**
     * Checks whether the field "u32StartTimeSinceStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32StartTimeSinceStart()). Otherwise it will return false.
     */
    inline bool hasU32StartTimeSinceStart () const;

    /**
     * Returns the value of the member "u32StartTimeSinceStart".
     *
     *
     *
     * @return The value of the field "u32StartTimeSinceStart"
     */
    inline uint32 getU32StartTimeSinceStart () const;

    /**
     * Sets the value of the member "u32StartTimeSinceStart".
     *
     *
     *
     * @param u32StartTimeSinceStart The value which will be set
     */
    inline void setU32StartTimeSinceStart (uint32 u32StartTimeSinceStart_);

    // API of field "tSwitchOnDate"

    static const int kTSwitchOnDate = 4;

    /**
     * Clears the field "tSwitchOnDate".
     *
     * The field will be set to its default value. The hasTSwitchOnDate()
     * method will return false.
     */
    inline void clearTSwitchOnDate();

    /**
     * Checks whether the field "tSwitchOnDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwitchOnDate()). Otherwise it will return false.
     */
    inline bool hasTSwitchOnDate () const;

    /**
     * Returns the value of the member "tSwitchOnDate".
     *
     *
     *
     * @return The value of the field "tSwitchOnDate"
     */
    inline const TTimeDate& getTSwitchOnDate () const;

    /**
     * Retrieves the value of the field "tSwitchOnDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwitchOnDate".
     */
    inline TTimeDate& getTSwitchOnDateMutable ();

    /**
     * Sets the value of the member "tSwitchOnDate".
     *
     *
     *
     * @param tSwitchOnDate The value which will be set
     */
    inline void setTSwitchOnDate (const TTimeDate& tSwitchOnDate_);

    static const T_ProcessElement &getDefaultInstance();

private:

    inline void set_has_tProcessName ();

    inline void clear_has_tProcessName ();

    inline void set_has_tConfiguredProcessName ();

    inline void clear_has_tConfiguredProcessName ();

    inline void set_has_eProcState ();

    inline void clear_has_eProcState ();

    inline void set_has_u32StartTimeSinceStart ();

    inline void clear_has_u32StartTimeSinceStart ();

    inline void set_has_tSwitchOnDate ();

    inline void clear_has_tSwitchOnDate ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::std::string _tProcessName;

    ::std::string _tConfiguredProcessName;

    T_e8_ProcessState _eProcState;

    uint32 _u32StartTimeSinceStart;

    TTimeDate _tSwitchOnDate;

};

/**
 * If the meaning of "T_SPM_ProcessInfo" isn't clear, then there should be a description here.
 */
class T_SPM_ProcessInfo {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_ProcessInfo ();

    /**
     * Copy constructor
     */
    inline  T_SPM_ProcessInfo (const T_SPM_ProcessInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_ProcessInfo (const ::std::vector< T_ProcessElement >& tProcesses_);

    /**
     * Destructor
     */
    inline  ~T_SPM_ProcessInfo();

    /**
     * Assignment operator
     */
    inline T_SPM_ProcessInfo& operator = (const T_SPM_ProcessInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_ProcessInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_ProcessInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_ProcessInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_ProcessInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tProcesses"

    static const int kTProcesses = 0;

    /**
     * Clears the field "tProcesses".
     *
     * The field will be set to its default value. The hasTProcesses()
     * method will return false.
     */
    inline void clearTProcesses();

    /**
     * Checks whether the field "tProcesses" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTProcesses()). Otherwise it will return false.
     */
    inline bool hasTProcesses () const;

    /**
     * Returns the value of the member "tProcesses".
     *
     * List of all processes configured in start configuration of SPM.
     *
     * @return The value of the field "tProcesses"
     */
    inline const ::std::vector< T_ProcessElement >& getTProcesses () const;

    /**
     * Retrieves the value of the field "tProcesses" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tProcesses".
     */
    inline ::std::vector< T_ProcessElement >& getTProcessesMutable ();

    /**
     * Sets the value of the member "tProcesses".
     *
     * List of all processes configured in start configuration of SPM.
     *
     * @param tProcesses The value which will be set
     */
    inline void setTProcesses (const ::std::vector< T_ProcessElement >& tProcesses_);

    static const T_SPM_ProcessInfo &getDefaultInstance();

private:

    static const ::std::vector< T_ProcessElement >& getT_ProcessElementList_DefaultInstance ();

    inline void set_has_tProcesses ();

    inline void clear_has_tProcesses ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_ProcessElement > _tProcesses;

};

/**
 * If the meaning of "T_SPM_Vin" isn't clear, then there should be a description here.
 */
class T_SPM_Vin {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_Vin ();

    /**
     * Copy constructor
     */
    inline  T_SPM_Vin (const T_SPM_Vin &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_Vin (const ::std::vector< uint8 >& Vin_);

    /**
     * Destructor
     */
    inline  ~T_SPM_Vin();

    /**
     * Assignment operator
     */
    inline T_SPM_Vin& operator = (const T_SPM_Vin& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_Vin& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_Vin& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_Vin& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_Vin& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Vin"

    static const int kVin = 0;

    /**
     * Clears the field "Vin".
     *
     * The field will be set to its default value. The hasVin()
     * method will return false.
     */
    inline void clearVin();

    /**
     * Checks whether the field "Vin" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVin()). Otherwise it will return false.
     */
    inline bool hasVin () const;

    /**
     * Returns the value of the member "Vin".
     *
     * VIN type.
     *
     * @return The value of the field "Vin"
     */
    inline const ::std::vector< uint8 >& getVin () const;

    /**
     * Retrieves the value of the field "Vin" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Vin".
     */
    inline ::std::vector< uint8 >& getVinMutable ();

    /**
     * Sets the value of the member "Vin".
     *
     * VIN type.
     *
     * @param Vin The value which will be set
     */
    inline void setVin (const ::std::vector< uint8 >& Vin_);

    static const T_SPM_Vin &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_Vin ();

    inline void clear_has_Vin ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _Vin;

};

/**
 * If the meaning of "T_SPM_VinHistory" isn't clear, then there should be a description here.
 */
class T_SPM_VinHistory {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_VinHistory ();

    /**
     * Copy constructor
     */
    inline  T_SPM_VinHistory (const T_SPM_VinHistory &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_VinHistory (const ::std::vector< T_SPM_Vin >& VinHistory_);

    /**
     * Destructor
     */
    inline  ~T_SPM_VinHistory();

    /**
     * Assignment operator
     */
    inline T_SPM_VinHistory& operator = (const T_SPM_VinHistory& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_VinHistory& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_VinHistory& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_VinHistory& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_VinHistory& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VinHistory"

    static const int kVinHistory = 0;

    /**
     * Clears the field "VinHistory".
     *
     * The field will be set to its default value. The hasVinHistory()
     * method will return false.
     */
    inline void clearVinHistory();

    /**
     * Checks whether the field "VinHistory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVinHistory()). Otherwise it will return false.
     */
    inline bool hasVinHistory () const;

    /**
     * Returns the value of the member "VinHistory".
     *
     * History of VIN type.
     *
     * @return The value of the field "VinHistory"
     */
    inline const ::std::vector< T_SPM_Vin >& getVinHistory () const;

    /**
     * Retrieves the value of the field "VinHistory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VinHistory".
     */
    inline ::std::vector< T_SPM_Vin >& getVinHistoryMutable ();

    /**
     * Sets the value of the member "VinHistory".
     *
     * History of VIN type.
     *
     * @param VinHistory The value which will be set
     */
    inline void setVinHistory (const ::std::vector< T_SPM_Vin >& VinHistory_);

    static const T_SPM_VinHistory &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_Vin >& getT_SPM_VinList_DefaultInstance ();

    inline void set_has_VinHistory ();

    inline void clear_has_VinHistory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_Vin > _VinHistory;

};

/**
 * If the meaning of "T_ResetElement" isn't clear, then there should be a description here.
 */
class T_ResetElement {
public:

    /**
     * Default constructor
     */
    inline  T_ResetElement ();

    /**
     * Copy constructor
     */
    inline  T_ResetElement (const T_ResetElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_ResetElement (const TTimeDate& tResetDate_, const TSwVersionInfo& tSwVersionInfo_, T_e8_LcmResetReason eReset_);

    /**
     * Destructor
     */
    inline  ~T_ResetElement();

    /**
     * Assignment operator
     */
    inline T_ResetElement& operator = (const T_ResetElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ResetElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ResetElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ResetElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ResetElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tResetDate"

    static const int kTResetDate = 0;

    /**
     * Clears the field "tResetDate".
     *
     * The field will be set to its default value. The hasTResetDate()
     * method will return false.
     */
    inline void clearTResetDate();

    /**
     * Checks whether the field "tResetDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTResetDate()). Otherwise it will return false.
     */
    inline bool hasTResetDate () const;

    /**
     * Returns the value of the member "tResetDate".
     *
     *
     *
     * @return The value of the field "tResetDate"
     */
    inline const TTimeDate& getTResetDate () const;

    /**
     * Retrieves the value of the field "tResetDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tResetDate".
     */
    inline TTimeDate& getTResetDateMutable ();

    /**
     * Sets the value of the member "tResetDate".
     *
     *
     *
     * @param tResetDate The value which will be set
     */
    inline void setTResetDate (const TTimeDate& tResetDate_);

    // API of field "tSwVersionInfo"

    static const int kTSwVersionInfo = 1;

    /**
     * Clears the field "tSwVersionInfo".
     *
     * The field will be set to its default value. The hasTSwVersionInfo()
     * method will return false.
     */
    inline void clearTSwVersionInfo();

    /**
     * Checks whether the field "tSwVersionInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwVersionInfo()). Otherwise it will return false.
     */
    inline bool hasTSwVersionInfo () const;

    /**
     * Returns the value of the member "tSwVersionInfo".
     *
     *
     *
     * @return The value of the field "tSwVersionInfo"
     */
    inline const TSwVersionInfo& getTSwVersionInfo () const;

    /**
     * Retrieves the value of the field "tSwVersionInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwVersionInfo".
     */
    inline TSwVersionInfo& getTSwVersionInfoMutable ();

    /**
     * Sets the value of the member "tSwVersionInfo".
     *
     *
     *
     * @param tSwVersionInfo The value which will be set
     */
    inline void setTSwVersionInfo (const TSwVersionInfo& tSwVersionInfo_);

    // API of field "eReset"

    static const int kEReset = 2;

    /**
     * Clears the field "eReset".
     *
     * The field will be set to its default value. The hasEReset()
     * method will return false.
     */
    inline void clearEReset();

    /**
     * Checks whether the field "eReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEReset()). Otherwise it will return false.
     */
    inline bool hasEReset () const;

    /**
     * Returns the value of the member "eReset".
     *
     *
     *
     * @return The value of the field "eReset"
     */
    inline T_e8_LcmResetReason getEReset () const;

    /**
     * Sets the value of the member "eReset".
     *
     *
     *
     * @param eReset The value which will be set
     */
    inline void setEReset (T_e8_LcmResetReason eReset_);

    static const T_ResetElement &getDefaultInstance();

private:

    inline void set_has_tResetDate ();

    inline void clear_has_tResetDate ();

    inline void set_has_tSwVersionInfo ();

    inline void clear_has_tSwVersionInfo ();

    inline void set_has_eReset ();

    inline void clear_has_eReset ();

    uint32 _has_bits_[ (3 + 31) / 32];

    TTimeDate _tResetDate;

    TSwVersionInfo _tSwVersionInfo;

    T_e8_LcmResetReason _eReset;

};

/**
 * If the meaning of "T_WakeupElement" isn't clear, then there should be a description here.
 */
class T_WakeupElement {
public:

    /**
     * Default constructor
     */
    inline  T_WakeupElement ();

    /**
     * Copy constructor
     */
    inline  T_WakeupElement (const T_WakeupElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_WakeupElement (const TTimeDate& tWakeupDate_, T_SPM_e32_WAKEUP_REASON eWakeupReason_);

    /**
     * Destructor
     */
    inline  ~T_WakeupElement();

    /**
     * Assignment operator
     */
    inline T_WakeupElement& operator = (const T_WakeupElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_WakeupElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_WakeupElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_WakeupElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_WakeupElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tWakeupDate"

    static const int kTWakeupDate = 0;

    /**
     * Clears the field "tWakeupDate".
     *
     * The field will be set to its default value. The hasTWakeupDate()
     * method will return false.
     */
    inline void clearTWakeupDate();

    /**
     * Checks whether the field "tWakeupDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeupDate()). Otherwise it will return false.
     */
    inline bool hasTWakeupDate () const;

    /**
     * Returns the value of the member "tWakeupDate".
     *
     *
     *
     * @return The value of the field "tWakeupDate"
     */
    inline const TTimeDate& getTWakeupDate () const;

    /**
     * Retrieves the value of the field "tWakeupDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tWakeupDate".
     */
    inline TTimeDate& getTWakeupDateMutable ();

    /**
     * Sets the value of the member "tWakeupDate".
     *
     *
     *
     * @param tWakeupDate The value which will be set
     */
    inline void setTWakeupDate (const TTimeDate& tWakeupDate_);

    // API of field "eWakeupReason"

    static const int kEWakeupReason = 1;

    /**
     * Clears the field "eWakeupReason".
     *
     * The field will be set to its default value. The hasEWakeupReason()
     * method will return false.
     */
    inline void clearEWakeupReason();

    /**
     * Checks whether the field "eWakeupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEWakeupReason()). Otherwise it will return false.
     */
    inline bool hasEWakeupReason () const;

    /**
     * Returns the value of the member "eWakeupReason".
     *
     *
     *
     * @return The value of the field "eWakeupReason"
     */
    inline T_SPM_e32_WAKEUP_REASON getEWakeupReason () const;

    /**
     * Sets the value of the member "eWakeupReason".
     *
     *
     *
     * @param eWakeupReason The value which will be set
     */
    inline void setEWakeupReason (T_SPM_e32_WAKEUP_REASON eWakeupReason_);

    static const T_WakeupElement &getDefaultInstance();

private:

    inline void set_has_tWakeupDate ();

    inline void clear_has_tWakeupDate ();

    inline void set_has_eWakeupReason ();

    inline void clear_has_eWakeupReason ();

    uint32 _has_bits_[ (2 + 31) / 32];

    TTimeDate _tWakeupDate;

    T_SPM_e32_WAKEUP_REASON _eWakeupReason;

};

/**
 * If the meaning of "T_StateChangeElement" isn't clear, then there should be a description here.
 */
class T_StateChangeElement {
public:

    /**
     * Default constructor
     */
    inline  T_StateChangeElement ();

    /**
     * Copy constructor
     */
    inline  T_StateChangeElement (const T_StateChangeElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_StateChangeElement (const TTimeDate& tWakeupDate_, T_SPM_e32_SYSTEM_STATES tSysState_, T_e8_StateEntryType tElemType_, T_SPM_e32_WAKEUP_REASON tWakeup_, T_e8_LcmResetReason tReset_, const T_SubStateEntry& tSubStates_);

    /**
     * Destructor
     */
    inline  ~T_StateChangeElement();

    /**
     * Assignment operator
     */
    inline T_StateChangeElement& operator = (const T_StateChangeElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_StateChangeElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_StateChangeElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_StateChangeElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_StateChangeElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tWakeupDate"

    static const int kTWakeupDate = 0;

    /**
     * Clears the field "tWakeupDate".
     *
     * The field will be set to its default value. The hasTWakeupDate()
     * method will return false.
     */
    inline void clearTWakeupDate();

    /**
     * Checks whether the field "tWakeupDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeupDate()). Otherwise it will return false.
     */
    inline bool hasTWakeupDate () const;

    /**
     * Returns the value of the member "tWakeupDate".
     *
     *
     *
     * @return The value of the field "tWakeupDate"
     */
    inline const TTimeDate& getTWakeupDate () const;

    /**
     * Retrieves the value of the field "tWakeupDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tWakeupDate".
     */
    inline TTimeDate& getTWakeupDateMutable ();

    /**
     * Sets the value of the member "tWakeupDate".
     *
     *
     *
     * @param tWakeupDate The value which will be set
     */
    inline void setTWakeupDate (const TTimeDate& tWakeupDate_);

    // API of field "tSysState"

    static const int kTSysState = 1;

    /**
     * Clears the field "tSysState".
     *
     * The field will be set to its default value. The hasTSysState()
     * method will return false.
     */
    inline void clearTSysState();

    /**
     * Checks whether the field "tSysState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSysState()). Otherwise it will return false.
     */
    inline bool hasTSysState () const;

    /**
     * Returns the value of the member "tSysState".
     *
     *
     *
     * @return The value of the field "tSysState"
     */
    inline T_SPM_e32_SYSTEM_STATES getTSysState () const;

    /**
     * Sets the value of the member "tSysState".
     *
     *
     *
     * @param tSysState The value which will be set
     */
    inline void setTSysState (T_SPM_e32_SYSTEM_STATES tSysState_);

    // API of field "tElemType"

    static const int kTElemType = 2;

    /**
     * Clears the field "tElemType".
     *
     * The field will be set to its default value. The hasTElemType()
     * method will return false.
     */
    inline void clearTElemType();

    /**
     * Checks whether the field "tElemType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTElemType()). Otherwise it will return false.
     */
    inline bool hasTElemType () const;

    /**
     * Returns the value of the member "tElemType".
     *
     *
     *
     * @return The value of the field "tElemType"
     */
    inline T_e8_StateEntryType getTElemType () const;

    /**
     * Sets the value of the member "tElemType".
     *
     *
     *
     * @param tElemType The value which will be set
     */
    inline void setTElemType (T_e8_StateEntryType tElemType_);

    // API of field "tWakeup"

    static const int kTWakeup = 3;

    /**
     * Clears the field "tWakeup".
     *
     * The field will be set to its default value. The hasTWakeup()
     * method will return false.
     */
    inline void clearTWakeup();

    /**
     * Checks whether the field "tWakeup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTWakeup()). Otherwise it will return false.
     */
    inline bool hasTWakeup () const;

    /**
     * Returns the value of the member "tWakeup".
     *
     *
     *
     * @return The value of the field "tWakeup"
     */
    inline T_SPM_e32_WAKEUP_REASON getTWakeup () const;

    /**
     * Sets the value of the member "tWakeup".
     *
     *
     *
     * @param tWakeup The value which will be set
     */
    inline void setTWakeup (T_SPM_e32_WAKEUP_REASON tWakeup_);

    // API of field "tReset"

    static const int kTReset = 4;

    /**
     * Clears the field "tReset".
     *
     * The field will be set to its default value. The hasTReset()
     * method will return false.
     */
    inline void clearTReset();

    /**
     * Checks whether the field "tReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTReset()). Otherwise it will return false.
     */
    inline bool hasTReset () const;

    /**
     * Returns the value of the member "tReset".
     *
     *
     *
     * @return The value of the field "tReset"
     */
    inline T_e8_LcmResetReason getTReset () const;

    /**
     * Sets the value of the member "tReset".
     *
     *
     *
     * @param tReset The value which will be set
     */
    inline void setTReset (T_e8_LcmResetReason tReset_);

    // API of field "tSubStates"

    static const int kTSubStates = 5;

    /**
     * Clears the field "tSubStates".
     *
     * The field will be set to its default value. The hasTSubStates()
     * method will return false.
     */
    inline void clearTSubStates();

    /**
     * Checks whether the field "tSubStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSubStates()). Otherwise it will return false.
     */
    inline bool hasTSubStates () const;

    /**
     * Returns the value of the member "tSubStates".
     *
     *
     *
     * @return The value of the field "tSubStates"
     */
    inline const T_SubStateEntry& getTSubStates () const;

    /**
     * Retrieves the value of the field "tSubStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSubStates".
     */
    inline T_SubStateEntry& getTSubStatesMutable ();

    /**
     * Sets the value of the member "tSubStates".
     *
     *
     *
     * @param tSubStates The value which will be set
     */
    inline void setTSubStates (const T_SubStateEntry& tSubStates_);

    static const T_StateChangeElement &getDefaultInstance();

private:

    inline void set_has_tWakeupDate ();

    inline void clear_has_tWakeupDate ();

    inline void set_has_tSysState ();

    inline void clear_has_tSysState ();

    inline void set_has_tElemType ();

    inline void clear_has_tElemType ();

    inline void set_has_tWakeup ();

    inline void clear_has_tWakeup ();

    inline void set_has_tReset ();

    inline void clear_has_tReset ();

    inline void set_has_tSubStates ();

    inline void clear_has_tSubStates ();

    uint32 _has_bits_[ (6 + 31) / 32];

    TTimeDate _tWakeupDate;

    T_SPM_e32_SYSTEM_STATES _tSysState;

    T_e8_StateEntryType _tElemType;

    T_SPM_e32_WAKEUP_REASON _tWakeup;

    T_e8_LcmResetReason _tReset;

    T_SubStateEntry _tSubStates;

};

/**
 * If the meaning of "T_SwitchOnElement" isn't clear, then there should be a description here.
 */
class T_SwitchOnElement {
public:

    /**
     * Default constructor
     */
    inline  T_SwitchOnElement ();

    /**
     * Copy constructor
     */
    inline  T_SwitchOnElement (const T_SwitchOnElement &rhs);

    /**
     * All fields constructor
     */
    inline  T_SwitchOnElement (const TTimeDate& tSwitchOnDate_, T_SPM_e32_SubStateType eSwitchOnReason_);

    /**
     * Destructor
     */
    inline  ~T_SwitchOnElement();

    /**
     * Assignment operator
     */
    inline T_SwitchOnElement& operator = (const T_SwitchOnElement& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SwitchOnElement& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SwitchOnElement& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SwitchOnElement& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SwitchOnElement& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSwitchOnDate"

    static const int kTSwitchOnDate = 0;

    /**
     * Clears the field "tSwitchOnDate".
     *
     * The field will be set to its default value. The hasTSwitchOnDate()
     * method will return false.
     */
    inline void clearTSwitchOnDate();

    /**
     * Checks whether the field "tSwitchOnDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSwitchOnDate()). Otherwise it will return false.
     */
    inline bool hasTSwitchOnDate () const;

    /**
     * Returns the value of the member "tSwitchOnDate".
     *
     *
     *
     * @return The value of the field "tSwitchOnDate"
     */
    inline const TTimeDate& getTSwitchOnDate () const;

    /**
     * Retrieves the value of the field "tSwitchOnDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSwitchOnDate".
     */
    inline TTimeDate& getTSwitchOnDateMutable ();

    /**
     * Sets the value of the member "tSwitchOnDate".
     *
     *
     *
     * @param tSwitchOnDate The value which will be set
     */
    inline void setTSwitchOnDate (const TTimeDate& tSwitchOnDate_);

    // API of field "eSwitchOnReason"

    static const int kESwitchOnReason = 1;

    /**
     * Clears the field "eSwitchOnReason".
     *
     * The field will be set to its default value. The hasESwitchOnReason()
     * method will return false.
     */
    inline void clearESwitchOnReason();

    /**
     * Checks whether the field "eSwitchOnReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESwitchOnReason()). Otherwise it will return false.
     */
    inline bool hasESwitchOnReason () const;

    /**
     * Returns the value of the member "eSwitchOnReason".
     *
     *
     *
     * @return The value of the field "eSwitchOnReason"
     */
    inline T_SPM_e32_SubStateType getESwitchOnReason () const;

    /**
     * Sets the value of the member "eSwitchOnReason".
     *
     *
     *
     * @param eSwitchOnReason The value which will be set
     */
    inline void setESwitchOnReason (T_SPM_e32_SubStateType eSwitchOnReason_);

    static const T_SwitchOnElement &getDefaultInstance();

private:

    inline void set_has_tSwitchOnDate ();

    inline void clear_has_tSwitchOnDate ();

    inline void set_has_eSwitchOnReason ();

    inline void clear_has_eSwitchOnReason ();

    uint32 _has_bits_[ (2 + 31) / 32];

    TTimeDate _tSwitchOnDate;

    T_SPM_e32_SubStateType _eSwitchOnReason;

};

/**
 * If the meaning of "T_SPM_PartnumberItem" isn't clear, then there should be a description here.
 */
class T_SPM_PartnumberItem {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_PartnumberItem ();

    /**
     * Copy constructor
     */
    inline  T_SPM_PartnumberItem (const T_SPM_PartnumberItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_PartnumberItem (const ::std::string& Part_, uint32 Number_);

    /**
     * Destructor
     */
    inline  ~T_SPM_PartnumberItem();

    /**
     * Assignment operator
     */
    inline T_SPM_PartnumberItem& operator = (const T_SPM_PartnumberItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_PartnumberItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     *
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     *
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     *
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     *
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    // API of field "Number"

    static const int kNumber = 1;

    /**
     * Clears the field "Number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "Number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "Number".
     *
     *
     *
     * @return The value of the field "Number"
     */
    inline uint32 getNumber () const;

    /**
     * Sets the value of the member "Number".
     *
     *
     *
     * @param Number The value which will be set
     */
    inline void setNumber (uint32 Number_);

    static const T_SPM_PartnumberItem &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    inline void set_has_Number ();

    inline void clear_has_Number ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _Part;

    uint32 _Number;

};

/**
 * If the meaning of "T_SPM_PartnumberList" isn't clear, then there should be a description here.
 */
class T_SPM_PartnumberList {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_PartnumberList ();

    /**
     * Copy constructor
     */
    inline  T_SPM_PartnumberList (const T_SPM_PartnumberList &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_PartnumberList (const ::std::vector< T_SPM_PartnumberItem >& Items_);

    /**
     * Destructor
     */
    inline  ~T_SPM_PartnumberList();

    /**
     * Assignment operator
     */
    inline T_SPM_PartnumberList& operator = (const T_SPM_PartnumberList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_PartnumberList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_PartnumberList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_PartnumberList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_PartnumberList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Items"

    static const int kItems = 0;

    /**
     * Clears the field "Items".
     *
     * The field will be set to its default value. The hasItems()
     * method will return false.
     */
    inline void clearItems();

    /**
     * Checks whether the field "Items" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setItems()). Otherwise it will return false.
     */
    inline bool hasItems () const;

    /**
     * Returns the value of the member "Items".
     *
     *
     *
     * @return The value of the field "Items"
     */
    inline const ::std::vector< T_SPM_PartnumberItem >& getItems () const;

    /**
     * Retrieves the value of the field "Items" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Items".
     */
    inline ::std::vector< T_SPM_PartnumberItem >& getItemsMutable ();

    /**
     * Sets the value of the member "Items".
     *
     *
     *
     * @param Items The value which will be set
     */
    inline void setItems (const ::std::vector< T_SPM_PartnumberItem >& Items_);

    static const T_SPM_PartnumberList &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_PartnumberItem >& getT_SPM_PartnumberItemList_DefaultInstance ();

    inline void set_has_Items ();

    inline void clear_has_Items ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_PartnumberItem > _Items;

};

/**
 * If the meaning of "T_SPM_AlphacodeItem" isn't clear, then there should be a description here.
 */
class T_SPM_AlphacodeItem {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_AlphacodeItem ();

    /**
     * Copy constructor
     */
    inline  T_SPM_AlphacodeItem (const T_SPM_AlphacodeItem &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_AlphacodeItem (const ::std::string& Part_, uint8 Alphacode1_, uint8 Alphacode2_);

    /**
     * Destructor
     */
    inline  ~T_SPM_AlphacodeItem();

    /**
     * Assignment operator
     */
    inline T_SPM_AlphacodeItem& operator = (const T_SPM_AlphacodeItem& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_AlphacodeItem& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Part"

    static const int kPart = 0;

    /**
     * Clears the field "Part".
     *
     * The field will be set to its default value. The hasPart()
     * method will return false.
     */
    inline void clearPart();

    /**
     * Checks whether the field "Part" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPart()). Otherwise it will return false.
     */
    inline bool hasPart () const;

    /**
     * Returns the value of the member "Part".
     *
     *
     *
     * @return The value of the field "Part"
     */
    inline const ::std::string& getPart () const;

    /**
     * Retrieves the value of the field "Part" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Part".
     */
    inline ::std::string& getPartMutable ();

    /**
     * Sets the value of the member "Part".
     *
     *
     *
     * @param Part The value which will be set
     */
    inline void setPart (const ::std::string& Part_);

    /**
     * Sets the value of the member "Part".
     *
     *
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* Part_);

    /**
     * Sets the value of the member "Part".
     *
     *
     *
     * @param Part The value which will be set
     */
    inline void setPart (const char* value, size_t size);

    // API of field "Alphacode1"

    static const int kAlphacode1 = 1;

    /**
     * Clears the field "Alphacode1".
     *
     * The field will be set to its default value. The hasAlphacode1()
     * method will return false.
     */
    inline void clearAlphacode1();

    /**
     * Checks whether the field "Alphacode1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode1()). Otherwise it will return false.
     */
    inline bool hasAlphacode1 () const;

    /**
     * Returns the value of the member "Alphacode1".
     *
     *
     *
     * @return The value of the field "Alphacode1"
     */
    inline uint8 getAlphacode1 () const;

    /**
     * Sets the value of the member "Alphacode1".
     *
     *
     *
     * @param Alphacode1 The value which will be set
     */
    inline void setAlphacode1 (uint8 Alphacode1_);

    // API of field "Alphacode2"

    static const int kAlphacode2 = 2;

    /**
     * Clears the field "Alphacode2".
     *
     * The field will be set to its default value. The hasAlphacode2()
     * method will return false.
     */
    inline void clearAlphacode2();

    /**
     * Checks whether the field "Alphacode2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAlphacode2()). Otherwise it will return false.
     */
    inline bool hasAlphacode2 () const;

    /**
     * Returns the value of the member "Alphacode2".
     *
     *
     *
     * @return The value of the field "Alphacode2"
     */
    inline uint8 getAlphacode2 () const;

    /**
     * Sets the value of the member "Alphacode2".
     *
     *
     *
     * @param Alphacode2 The value which will be set
     */
    inline void setAlphacode2 (uint8 Alphacode2_);

    static const T_SPM_AlphacodeItem &getDefaultInstance();

private:

    inline void set_has_Part ();

    inline void clear_has_Part ();

    inline void set_has_Alphacode1 ();

    inline void clear_has_Alphacode1 ();

    inline void set_has_Alphacode2 ();

    inline void clear_has_Alphacode2 ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _Part;

    uint8 _Alphacode1;

    uint8 _Alphacode2;

};

/**
 * If the meaning of "T_SPM_AlphacodeList" isn't clear, then there should be a description here.
 */
class T_SPM_AlphacodeList {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_AlphacodeList ();

    /**
     * Copy constructor
     */
    inline  T_SPM_AlphacodeList (const T_SPM_AlphacodeList &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_AlphacodeList (const ::std::vector< T_SPM_AlphacodeItem >& Items_);

    /**
     * Destructor
     */
    inline  ~T_SPM_AlphacodeList();

    /**
     * Assignment operator
     */
    inline T_SPM_AlphacodeList& operator = (const T_SPM_AlphacodeList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_AlphacodeList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_AlphacodeList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_AlphacodeList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_AlphacodeList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Items"

    static const int kItems = 0;

    /**
     * Clears the field "Items".
     *
     * The field will be set to its default value. The hasItems()
     * method will return false.
     */
    inline void clearItems();

    /**
     * Checks whether the field "Items" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setItems()). Otherwise it will return false.
     */
    inline bool hasItems () const;

    /**
     * Returns the value of the member "Items".
     *
     *
     *
     * @return The value of the field "Items"
     */
    inline const ::std::vector< T_SPM_AlphacodeItem >& getItems () const;

    /**
     * Retrieves the value of the field "Items" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Items".
     */
    inline ::std::vector< T_SPM_AlphacodeItem >& getItemsMutable ();

    /**
     * Sets the value of the member "Items".
     *
     *
     *
     * @param Items The value which will be set
     */
    inline void setItems (const ::std::vector< T_SPM_AlphacodeItem >& Items_);

    static const T_SPM_AlphacodeList &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_AlphacodeItem >& getT_SPM_AlphacodeItemList_DefaultInstance ();

    inline void set_has_Items ();

    inline void clear_has_Items ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_AlphacodeItem > _Items;

};

/**
 * If the meaning of "T_SPM_AppIdList" isn't clear, then there should be a description here.
 */
class T_SPM_AppIdList {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_AppIdList ();

    /**
     * Copy constructor
     */
    inline  T_SPM_AppIdList (const T_SPM_AppIdList &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_AppIdList (const ::std::vector< uint16 >& tAppIdList_);

    /**
     * Destructor
     */
    inline  ~T_SPM_AppIdList();

    /**
     * Assignment operator
     */
    inline T_SPM_AppIdList& operator = (const T_SPM_AppIdList& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_AppIdList& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_AppIdList& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_AppIdList& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_AppIdList& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tAppIdList"

    static const int kTAppIdList = 0;

    /**
     * Clears the field "tAppIdList".
     *
     * The field will be set to its default value. The hasTAppIdList()
     * method will return false.
     */
    inline void clearTAppIdList();

    /**
     * Checks whether the field "tAppIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTAppIdList()). Otherwise it will return false.
     */
    inline bool hasTAppIdList () const;

    /**
     * Returns the value of the member "tAppIdList".
     *
     *
     *
     * @return The value of the field "tAppIdList"
     */
    inline const ::std::vector< uint16 >& getTAppIdList () const;

    /**
     * Retrieves the value of the field "tAppIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tAppIdList".
     */
    inline ::std::vector< uint16 >& getTAppIdListMutable ();

    /**
     * Sets the value of the member "tAppIdList".
     *
     *
     *
     * @param tAppIdList The value which will be set
     */
    inline void setTAppIdList (const ::std::vector< uint16 >& tAppIdList_);

    static const T_SPM_AppIdList &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_tAppIdList ();

    inline void clear_has_tAppIdList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint16 > _tAppIdList;

};

/**
 * If the meaning of "T_SPM_RestrictedDlLock" isn't clear, then there should be a description here.
 */
class T_SPM_RestrictedDlLock {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_RestrictedDlLock ();

    /**
     * Copy constructor
     */
    inline  T_SPM_RestrictedDlLock (const T_SPM_RestrictedDlLock &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_RestrictedDlLock (const ::std::string& strRestrictedLockArea_, uint16 u16AppIdLockOwner_, uint16 u16AppIdLockRequester_);

    /**
     * Destructor
     */
    inline  ~T_SPM_RestrictedDlLock();

    /**
     * Assignment operator
     */
    inline T_SPM_RestrictedDlLock& operator = (const T_SPM_RestrictedDlLock& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_RestrictedDlLock& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strRestrictedLockArea"

    static const int kStrRestrictedLockArea = 0;

    /**
     * Clears the field "strRestrictedLockArea".
     *
     * The field will be set to its default value. The hasStrRestrictedLockArea()
     * method will return false.
     */
    inline void clearStrRestrictedLockArea();

    /**
     * Checks whether the field "strRestrictedLockArea" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrRestrictedLockArea()). Otherwise it will return false.
     */
    inline bool hasStrRestrictedLockArea () const;

    /**
     * Returns the value of the member "strRestrictedLockArea".
     *
     *
     *
     * @return The value of the field "strRestrictedLockArea"
     */
    inline const ::std::string& getStrRestrictedLockArea () const;

    /**
     * Retrieves the value of the field "strRestrictedLockArea" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strRestrictedLockArea".
     */
    inline ::std::string& getStrRestrictedLockAreaMutable ();

    /**
     * Sets the value of the member "strRestrictedLockArea".
     *
     *
     *
     * @param strRestrictedLockArea The value which will be set
     */
    inline void setStrRestrictedLockArea (const ::std::string& strRestrictedLockArea_);

    /**
     * Sets the value of the member "strRestrictedLockArea".
     *
     *
     *
     * @param strRestrictedLockArea The value which will be set
     */
    inline void setStrRestrictedLockArea (const char* strRestrictedLockArea_);

    /**
     * Sets the value of the member "strRestrictedLockArea".
     *
     *
     *
     * @param strRestrictedLockArea The value which will be set
     */
    inline void setStrRestrictedLockArea (const char* value, size_t size);

    // API of field "u16AppIdLockOwner"

    static const int kU16AppIdLockOwner = 1;

    /**
     * Clears the field "u16AppIdLockOwner".
     *
     * The field will be set to its default value. The hasU16AppIdLockOwner()
     * method will return false.
     */
    inline void clearU16AppIdLockOwner();

    /**
     * Checks whether the field "u16AppIdLockOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AppIdLockOwner()). Otherwise it will return false.
     */
    inline bool hasU16AppIdLockOwner () const;

    /**
     * Returns the value of the member "u16AppIdLockOwner".
     *
     *
     *
     * @return The value of the field "u16AppIdLockOwner"
     */
    inline uint16 getU16AppIdLockOwner () const;

    /**
     * Sets the value of the member "u16AppIdLockOwner".
     *
     *
     *
     * @param u16AppIdLockOwner The value which will be set
     */
    inline void setU16AppIdLockOwner (uint16 u16AppIdLockOwner_);

    // API of field "u16AppIdLockRequester"

    static const int kU16AppIdLockRequester = 2;

    /**
     * Clears the field "u16AppIdLockRequester".
     *
     * The field will be set to its default value. The hasU16AppIdLockRequester()
     * method will return false.
     */
    inline void clearU16AppIdLockRequester();

    /**
     * Checks whether the field "u16AppIdLockRequester" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AppIdLockRequester()). Otherwise it will return false.
     */
    inline bool hasU16AppIdLockRequester () const;

    /**
     * Returns the value of the member "u16AppIdLockRequester".
     *
     *
     *
     * @return The value of the field "u16AppIdLockRequester"
     */
    inline uint16 getU16AppIdLockRequester () const;

    /**
     * Sets the value of the member "u16AppIdLockRequester".
     *
     *
     *
     * @param u16AppIdLockRequester The value which will be set
     */
    inline void setU16AppIdLockRequester (uint16 u16AppIdLockRequester_);

    static const T_SPM_RestrictedDlLock &getDefaultInstance();

private:

    inline void set_has_strRestrictedLockArea ();

    inline void clear_has_strRestrictedLockArea ();

    inline void set_has_u16AppIdLockOwner ();

    inline void clear_has_u16AppIdLockOwner ();

    inline void set_has_u16AppIdLockRequester ();

    inline void clear_has_u16AppIdLockRequester ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _strRestrictedLockArea;

    uint16 _u16AppIdLockOwner;

    uint16 _u16AppIdLockRequester;

};

/**
 * If the meaning of "T_SPM_UpdateLockState" isn't clear, then there should be a description here.
 */
class T_SPM_UpdateLockState {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_UpdateLockState ();

    /**
     * Copy constructor
     */
    inline  T_SPM_UpdateLockState (const T_SPM_UpdateLockState &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_UpdateLockState (const ::std::string& strLockName_, T_e8_UpdateLockState eLockState_, uint16 u16LockOwner_, const ::std::vector< uint16 >& lu16LockUsers_);

    /**
     * Destructor
     */
    inline  ~T_SPM_UpdateLockState();

    /**
     * Assignment operator
     */
    inline T_SPM_UpdateLockState& operator = (const T_SPM_UpdateLockState& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_UpdateLockState& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLockName"

    static const int kStrLockName = 0;

    /**
     * Clears the field "strLockName".
     *
     * The field will be set to its default value. The hasStrLockName()
     * method will return false.
     */
    inline void clearStrLockName();

    /**
     * Checks whether the field "strLockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLockName()). Otherwise it will return false.
     */
    inline bool hasStrLockName () const;

    /**
     * Returns the value of the member "strLockName".
     *
     *
     *
     * @return The value of the field "strLockName"
     */
    inline const ::std::string& getStrLockName () const;

    /**
     * Retrieves the value of the field "strLockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLockName".
     */
    inline ::std::string& getStrLockNameMutable ();

    /**
     * Sets the value of the member "strLockName".
     *
     *
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const ::std::string& strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     *
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     *
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* value, size_t size);

    // API of field "eLockState"

    static const int kELockState = 1;

    /**
     * Clears the field "eLockState".
     *
     * The field will be set to its default value. The hasELockState()
     * method will return false.
     */
    inline void clearELockState();

    /**
     * Checks whether the field "eLockState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setELockState()). Otherwise it will return false.
     */
    inline bool hasELockState () const;

    /**
     * Returns the value of the member "eLockState".
     *
     *
     *
     * @return The value of the field "eLockState"
     */
    inline T_e8_UpdateLockState getELockState () const;

    /**
     * Sets the value of the member "eLockState".
     *
     *
     *
     * @param eLockState The value which will be set
     */
    inline void setELockState (T_e8_UpdateLockState eLockState_);

    // API of field "u16LockOwner"

    static const int kU16LockOwner = 2;

    /**
     * Clears the field "u16LockOwner".
     *
     * The field will be set to its default value. The hasU16LockOwner()
     * method will return false.
     */
    inline void clearU16LockOwner();

    /**
     * Checks whether the field "u16LockOwner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16LockOwner()). Otherwise it will return false.
     */
    inline bool hasU16LockOwner () const;

    /**
     * Returns the value of the member "u16LockOwner".
     *
     *
     *
     * @return The value of the field "u16LockOwner"
     */
    inline uint16 getU16LockOwner () const;

    /**
     * Sets the value of the member "u16LockOwner".
     *
     *
     *
     * @param u16LockOwner The value which will be set
     */
    inline void setU16LockOwner (uint16 u16LockOwner_);

    // API of field "lu16LockUsers"

    static const int kLu16LockUsers = 3;

    /**
     * Clears the field "lu16LockUsers".
     *
     * The field will be set to its default value. The hasLu16LockUsers()
     * method will return false.
     */
    inline void clearLu16LockUsers();

    /**
     * Checks whether the field "lu16LockUsers" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLu16LockUsers()). Otherwise it will return false.
     */
    inline bool hasLu16LockUsers () const;

    /**
     * Returns the value of the member "lu16LockUsers".
     *
     *
     *
     * @return The value of the field "lu16LockUsers"
     */
    inline const ::std::vector< uint16 >& getLu16LockUsers () const;

    /**
     * Retrieves the value of the field "lu16LockUsers" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "lu16LockUsers".
     */
    inline ::std::vector< uint16 >& getLu16LockUsersMutable ();

    /**
     * Sets the value of the member "lu16LockUsers".
     *
     *
     *
     * @param lu16LockUsers The value which will be set
     */
    inline void setLu16LockUsers (const ::std::vector< uint16 >& lu16LockUsers_);

    static const T_SPM_UpdateLockState &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_strLockName ();

    inline void clear_has_strLockName ();

    inline void set_has_eLockState ();

    inline void clear_has_eLockState ();

    inline void set_has_u16LockOwner ();

    inline void clear_has_u16LockOwner ();

    inline void set_has_lu16LockUsers ();

    inline void clear_has_lu16LockUsers ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _strLockName;

    T_e8_UpdateLockState _eLockState;

    uint16 _u16LockOwner;

    ::std::vector< uint16 > _lu16LockUsers;

};

/**
 * If the meaning of "T_SPM_VoltageEventCounter" isn't clear, then there should be a description here.
 */
class T_SPM_VoltageEventCounter {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_VoltageEventCounter ();

    /**
     * Copy constructor
     */
    inline  T_SPM_VoltageEventCounter (const T_SPM_VoltageEventCounter &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_VoltageEventCounter (uint32 LowVoltageCount_, uint32 CrLowVoltageCount_, uint32 HighVoltageCount_, uint32 CrHighVoltageCount_);

    /**
     * Destructor
     */
    inline  ~T_SPM_VoltageEventCounter();

    /**
     * Assignment operator
     */
    inline T_SPM_VoltageEventCounter& operator = (const T_SPM_VoltageEventCounter& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_VoltageEventCounter& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LowVoltageCount"

    static const int kLowVoltageCount = 0;

    /**
     * Clears the field "LowVoltageCount".
     *
     * The field will be set to its default value. The hasLowVoltageCount()
     * method will return false.
     */
    inline void clearLowVoltageCount();

    /**
     * Checks whether the field "LowVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLowVoltageCount()). Otherwise it will return false.
     */
    inline bool hasLowVoltageCount () const;

    /**
     * Returns the value of the member "LowVoltageCount".
     *
     * Low voltage event counter
     *
     * @return The value of the field "LowVoltageCount"
     */
    inline uint32 getLowVoltageCount () const;

    /**
     * Sets the value of the member "LowVoltageCount".
     *
     * Low voltage event counter
     *
     * @param LowVoltageCount The value which will be set
     */
    inline void setLowVoltageCount (uint32 LowVoltageCount_);

    // API of field "CrLowVoltageCount"

    static const int kCrLowVoltageCount = 1;

    /**
     * Clears the field "CrLowVoltageCount".
     *
     * The field will be set to its default value. The hasCrLowVoltageCount()
     * method will return false.
     */
    inline void clearCrLowVoltageCount();

    /**
     * Checks whether the field "CrLowVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCrLowVoltageCount()). Otherwise it will return false.
     */
    inline bool hasCrLowVoltageCount () const;

    /**
     * Returns the value of the member "CrLowVoltageCount".
     *
     * Critical low voltage event counter
     *
     * @return The value of the field "CrLowVoltageCount"
     */
    inline uint32 getCrLowVoltageCount () const;

    /**
     * Sets the value of the member "CrLowVoltageCount".
     *
     * Critical low voltage event counter
     *
     * @param CrLowVoltageCount The value which will be set
     */
    inline void setCrLowVoltageCount (uint32 CrLowVoltageCount_);

    // API of field "HighVoltageCount"

    static const int kHighVoltageCount = 2;

    /**
     * Clears the field "HighVoltageCount".
     *
     * The field will be set to its default value. The hasHighVoltageCount()
     * method will return false.
     */
    inline void clearHighVoltageCount();

    /**
     * Checks whether the field "HighVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHighVoltageCount()). Otherwise it will return false.
     */
    inline bool hasHighVoltageCount () const;

    /**
     * Returns the value of the member "HighVoltageCount".
     *
     * High voltage event counter
     *
     * @return The value of the field "HighVoltageCount"
     */
    inline uint32 getHighVoltageCount () const;

    /**
     * Sets the value of the member "HighVoltageCount".
     *
     * High voltage event counter
     *
     * @param HighVoltageCount The value which will be set
     */
    inline void setHighVoltageCount (uint32 HighVoltageCount_);

    // API of field "CrHighVoltageCount"

    static const int kCrHighVoltageCount = 3;

    /**
     * Clears the field "CrHighVoltageCount".
     *
     * The field will be set to its default value. The hasCrHighVoltageCount()
     * method will return false.
     */
    inline void clearCrHighVoltageCount();

    /**
     * Checks whether the field "CrHighVoltageCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCrHighVoltageCount()). Otherwise it will return false.
     */
    inline bool hasCrHighVoltageCount () const;

    /**
     * Returns the value of the member "CrHighVoltageCount".
     *
     * Critical high voltage event counter
     *
     * @return The value of the field "CrHighVoltageCount"
     */
    inline uint32 getCrHighVoltageCount () const;

    /**
     * Sets the value of the member "CrHighVoltageCount".
     *
     * Critical high voltage event counter
     *
     * @param CrHighVoltageCount The value which will be set
     */
    inline void setCrHighVoltageCount (uint32 CrHighVoltageCount_);

    static const T_SPM_VoltageEventCounter &getDefaultInstance();

private:

    inline void set_has_LowVoltageCount ();

    inline void clear_has_LowVoltageCount ();

    inline void set_has_CrLowVoltageCount ();

    inline void clear_has_CrLowVoltageCount ();

    inline void set_has_HighVoltageCount ();

    inline void clear_has_HighVoltageCount ();

    inline void set_has_CrHighVoltageCount ();

    inline void clear_has_CrHighVoltageCount ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _LowVoltageCount;

    uint32 _CrLowVoltageCount;

    uint32 _HighVoltageCount;

    uint32 _CrHighVoltageCount;

};

/**
 * If the meaning of "T_SPM_VoltageRange" isn't clear, then there should be a description here.
 */
class T_SPM_VoltageRange {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_VoltageRange ();

    /**
     * Copy constructor
     */
    inline  T_SPM_VoltageRange (const T_SPM_VoltageRange &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_VoltageRange (uint16 VoltageValue_, uint32 OperationTime_);

    /**
     * Destructor
     */
    inline  ~T_SPM_VoltageRange();

    /**
     * Assignment operator
     */
    inline T_SPM_VoltageRange& operator = (const T_SPM_VoltageRange& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_VoltageRange& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_VoltageRange& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_VoltageRange& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_VoltageRange& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoltageValue"

    static const int kVoltageValue = 0;

    /**
     * Clears the field "VoltageValue".
     *
     * The field will be set to its default value. The hasVoltageValue()
     * method will return false.
     */
    inline void clearVoltageValue();

    /**
     * Checks whether the field "VoltageValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageValue()). Otherwise it will return false.
     */
    inline bool hasVoltageValue () const;

    /**
     * Returns the value of the member "VoltageValue".
     *
     * Voltage value in Mv
     *
     * @return The value of the field "VoltageValue"
     */
    inline uint16 getVoltageValue () const;

    /**
     * Sets the value of the member "VoltageValue".
     *
     * Voltage value in Mv
     *
     * @param VoltageValue The value which will be set
     */
    inline void setVoltageValue (uint16 VoltageValue_);

    // API of field "OperationTime"

    static const int kOperationTime = 1;

    /**
     * Clears the field "OperationTime".
     *
     * The field will be set to its default value. The hasOperationTime()
     * method will return false.
     */
    inline void clearOperationTime();

    /**
     * Checks whether the field "OperationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOperationTime()). Otherwise it will return false.
     */
    inline bool hasOperationTime () const;

    /**
     * Returns the value of the member "OperationTime".
     *
     * Operation time in second corresponding voltage value
     *
     * @return The value of the field "OperationTime"
     */
    inline uint32 getOperationTime () const;

    /**
     * Sets the value of the member "OperationTime".
     *
     * Operation time in second corresponding voltage value
     *
     * @param OperationTime The value which will be set
     */
    inline void setOperationTime (uint32 OperationTime_);

    static const T_SPM_VoltageRange &getDefaultInstance();

private:

    inline void set_has_VoltageValue ();

    inline void clear_has_VoltageValue ();

    inline void set_has_OperationTime ();

    inline void clear_has_OperationTime ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _VoltageValue;

    uint32 _OperationTime;

};

/**
 * If the meaning of "T_SPM_SystemStatisticsData" isn't clear, then there should be a description here.
 */
class T_SPM_SystemStatisticsData {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_SystemStatisticsData ();

    /**
     * Copy constructor
     */
    inline  T_SPM_SystemStatisticsData (const T_SPM_SystemStatisticsData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_SystemStatisticsData (uint32 MaxValue_, uint32 AvgValue_, uint32 MinValue_, bool StatisticDataDisabled_);

    /**
     * Destructor
     */
    inline  ~T_SPM_SystemStatisticsData();

    /**
     * Assignment operator
     */
    inline T_SPM_SystemStatisticsData& operator = (const T_SPM_SystemStatisticsData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_SystemStatisticsData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MaxValue"

    static const int kMaxValue = 0;

    /**
     * Clears the field "MaxValue".
     *
     * The field will be set to its default value. The hasMaxValue()
     * method will return false.
     */
    inline void clearMaxValue();

    /**
     * Checks whether the field "MaxValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMaxValue()). Otherwise it will return false.
     */
    inline bool hasMaxValue () const;

    /**
     * Returns the value of the member "MaxValue".
     *
     * Maximum value of statistic data
     *
     * @return The value of the field "MaxValue"
     */
    inline uint32 getMaxValue () const;

    /**
     * Sets the value of the member "MaxValue".
     *
     * Maximum value of statistic data
     *
     * @param MaxValue The value which will be set
     */
    inline void setMaxValue (uint32 MaxValue_);

    // API of field "AvgValue"

    static const int kAvgValue = 1;

    /**
     * Clears the field "AvgValue".
     *
     * The field will be set to its default value. The hasAvgValue()
     * method will return false.
     */
    inline void clearAvgValue();

    /**
     * Checks whether the field "AvgValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAvgValue()). Otherwise it will return false.
     */
    inline bool hasAvgValue () const;

    /**
     * Returns the value of the member "AvgValue".
     *
     * Average value of statistic data
     *
     * @return The value of the field "AvgValue"
     */
    inline uint32 getAvgValue () const;

    /**
     * Sets the value of the member "AvgValue".
     *
     * Average value of statistic data
     *
     * @param AvgValue The value which will be set
     */
    inline void setAvgValue (uint32 AvgValue_);

    // API of field "MinValue"

    static const int kMinValue = 2;

    /**
     * Clears the field "MinValue".
     *
     * The field will be set to its default value. The hasMinValue()
     * method will return false.
     */
    inline void clearMinValue();

    /**
     * Checks whether the field "MinValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMinValue()). Otherwise it will return false.
     */
    inline bool hasMinValue () const;

    /**
     * Returns the value of the member "MinValue".
     *
     * Minimum value of statistic data
     *
     * @return The value of the field "MinValue"
     */
    inline uint32 getMinValue () const;

    /**
     * Sets the value of the member "MinValue".
     *
     * Minimum value of statistic data
     *
     * @param MinValue The value which will be set
     */
    inline void setMinValue (uint32 MinValue_);

    // API of field "StatisticDataDisabled"

    static const int kStatisticDataDisabled = 3;

    /**
     * Clears the field "StatisticDataDisabled".
     *
     * The field will be set to its default value. The hasStatisticDataDisabled()
     * method will return false.
     */
    inline void clearStatisticDataDisabled();

    /**
     * Checks whether the field "StatisticDataDisabled" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatisticDataDisabled()). Otherwise it will return false.
     */
    inline bool hasStatisticDataDisabled () const;

    /**
     * Returns the value of the member "StatisticDataDisabled".
     *
     * True when project decided to disable this feature.
     *
     * @return The value of the field "StatisticDataDisabled"
     */
    inline bool getStatisticDataDisabled () const;

    /**
     * Sets the value of the member "StatisticDataDisabled".
     *
     * True when project decided to disable this feature.
     *
     * @param StatisticDataDisabled The value which will be set
     */
    inline void setStatisticDataDisabled (bool StatisticDataDisabled_);

    static const T_SPM_SystemStatisticsData &getDefaultInstance();

private:

    inline void set_has_MaxValue ();

    inline void clear_has_MaxValue ();

    inline void set_has_AvgValue ();

    inline void clear_has_AvgValue ();

    inline void set_has_MinValue ();

    inline void clear_has_MinValue ();

    inline void set_has_StatisticDataDisabled ();

    inline void clear_has_StatisticDataDisabled ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _MaxValue;

    uint32 _AvgValue;

    uint32 _MinValue;

    bool _StatisticDataDisabled;

};

/**
 * If the meaning of "T_SPM_ResetInfoStatisticData" isn't clear, then there should be a description here.
 */
class T_SPM_ResetInfoStatisticData {
public:

    /**
     * Default constructor
     */
    inline  T_SPM_ResetInfoStatisticData ();

    /**
     * Copy constructor
     */
    inline  T_SPM_ResetInfoStatisticData (const T_SPM_ResetInfoStatisticData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SPM_ResetInfoStatisticData (const TTimeDate& tLastResetDate_, T_e8_LcmResetReason tLastResetReason_, uint32 u32ApApplicationError_, uint32 u32ApSoftware_, uint32 u32ApEcuReset_, uint32 u32ApDownload_, uint32 u32ApDownloadError_, uint32 u32ApOvertemperature_, uint32 u32ApUser_, uint32 u32ApLcmIntern_, uint32 u32ApWarmstartCount_, uint32 u32ApPowerOnCount_, uint32 u32ApPowerLossCount_, uint32 u32ApPowerOffCount_, uint32 u32ApSccCount_, uint32 u32ApUnknownCount_, uint32 u32SccHwWdtCount_, uint32 u32SccPowerOnCount_, uint32 u32SccColdstartCount_, uint32 u32SccAppmodeChangeCount_, uint32 u32SccDuringLpwCount_, uint32 u32SccDuringPllOszCount_, uint32 u32SccDuringSWCount_, uint32 u32SccWarmstartCount_);

    /**
     * Destructor
     */
    inline  ~T_SPM_ResetInfoStatisticData();

    /**
     * Assignment operator
     */
    inline T_SPM_ResetInfoStatisticData& operator = (const T_SPM_ResetInfoStatisticData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SPM_ResetInfoStatisticData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tLastResetDate"

    static const int kTLastResetDate = 0;

    /**
     * Clears the field "tLastResetDate".
     *
     * The field will be set to its default value. The hasTLastResetDate()
     * method will return false.
     */
    inline void clearTLastResetDate();

    /**
     * Checks whether the field "tLastResetDate" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetDate()). Otherwise it will return false.
     */
    inline bool hasTLastResetDate () const;

    /**
     * Returns the value of the member "tLastResetDate".
     *
     *
     *
     * @return The value of the field "tLastResetDate"
     */
    inline const TTimeDate& getTLastResetDate () const;

    /**
     * Retrieves the value of the field "tLastResetDate" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tLastResetDate".
     */
    inline TTimeDate& getTLastResetDateMutable ();

    /**
     * Sets the value of the member "tLastResetDate".
     *
     *
     *
     * @param tLastResetDate The value which will be set
     */
    inline void setTLastResetDate (const TTimeDate& tLastResetDate_);

    // API of field "tLastResetReason"

    static const int kTLastResetReason = 1;

    /**
     * Clears the field "tLastResetReason".
     *
     * The field will be set to its default value. The hasTLastResetReason()
     * method will return false.
     */
    inline void clearTLastResetReason();

    /**
     * Checks whether the field "tLastResetReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTLastResetReason()). Otherwise it will return false.
     */
    inline bool hasTLastResetReason () const;

    /**
     * Returns the value of the member "tLastResetReason".
     *
     *
     *
     * @return The value of the field "tLastResetReason"
     */
    inline T_e8_LcmResetReason getTLastResetReason () const;

    /**
     * Sets the value of the member "tLastResetReason".
     *
     *
     *
     * @param tLastResetReason The value which will be set
     */
    inline void setTLastResetReason (T_e8_LcmResetReason tLastResetReason_);

    // API of field "u32ApApplicationError"

    static const int kU32ApApplicationError = 2;

    /**
     * Clears the field "u32ApApplicationError".
     *
     * The field will be set to its default value. The hasU32ApApplicationError()
     * method will return false.
     */
    inline void clearU32ApApplicationError();

    /**
     * Checks whether the field "u32ApApplicationError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApApplicationError()). Otherwise it will return false.
     */
    inline bool hasU32ApApplicationError () const;

    /**
     * Returns the value of the member "u32ApApplicationError".
     *
     *
     *
     * @return The value of the field "u32ApApplicationError"
     */
    inline uint32 getU32ApApplicationError () const;

    /**
     * Sets the value of the member "u32ApApplicationError".
     *
     *
     *
     * @param u32ApApplicationError The value which will be set
     */
    inline void setU32ApApplicationError (uint32 u32ApApplicationError_);

    // API of field "u32ApSoftware"

    static const int kU32ApSoftware = 3;

    /**
     * Clears the field "u32ApSoftware".
     *
     * The field will be set to its default value. The hasU32ApSoftware()
     * method will return false.
     */
    inline void clearU32ApSoftware();

    /**
     * Checks whether the field "u32ApSoftware" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSoftware()). Otherwise it will return false.
     */
    inline bool hasU32ApSoftware () const;

    /**
     * Returns the value of the member "u32ApSoftware".
     *
     *
     *
     * @return The value of the field "u32ApSoftware"
     */
    inline uint32 getU32ApSoftware () const;

    /**
     * Sets the value of the member "u32ApSoftware".
     *
     *
     *
     * @param u32ApSoftware The value which will be set
     */
    inline void setU32ApSoftware (uint32 u32ApSoftware_);

    // API of field "u32ApEcuReset"

    static const int kU32ApEcuReset = 4;

    /**
     * Clears the field "u32ApEcuReset".
     *
     * The field will be set to its default value. The hasU32ApEcuReset()
     * method will return false.
     */
    inline void clearU32ApEcuReset();

    /**
     * Checks whether the field "u32ApEcuReset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApEcuReset()). Otherwise it will return false.
     */
    inline bool hasU32ApEcuReset () const;

    /**
     * Returns the value of the member "u32ApEcuReset".
     *
     *
     *
     * @return The value of the field "u32ApEcuReset"
     */
    inline uint32 getU32ApEcuReset () const;

    /**
     * Sets the value of the member "u32ApEcuReset".
     *
     *
     *
     * @param u32ApEcuReset The value which will be set
     */
    inline void setU32ApEcuReset (uint32 u32ApEcuReset_);

    // API of field "u32ApDownload"

    static const int kU32ApDownload = 5;

    /**
     * Clears the field "u32ApDownload".
     *
     * The field will be set to its default value. The hasU32ApDownload()
     * method will return false.
     */
    inline void clearU32ApDownload();

    /**
     * Checks whether the field "u32ApDownload" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownload()). Otherwise it will return false.
     */
    inline bool hasU32ApDownload () const;

    /**
     * Returns the value of the member "u32ApDownload".
     *
     *
     *
     * @return The value of the field "u32ApDownload"
     */
    inline uint32 getU32ApDownload () const;

    /**
     * Sets the value of the member "u32ApDownload".
     *
     *
     *
     * @param u32ApDownload The value which will be set
     */
    inline void setU32ApDownload (uint32 u32ApDownload_);

    // API of field "u32ApDownloadError"

    static const int kU32ApDownloadError = 6;

    /**
     * Clears the field "u32ApDownloadError".
     *
     * The field will be set to its default value. The hasU32ApDownloadError()
     * method will return false.
     */
    inline void clearU32ApDownloadError();

    /**
     * Checks whether the field "u32ApDownloadError" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApDownloadError()). Otherwise it will return false.
     */
    inline bool hasU32ApDownloadError () const;

    /**
     * Returns the value of the member "u32ApDownloadError".
     *
     *
     *
     * @return The value of the field "u32ApDownloadError"
     */
    inline uint32 getU32ApDownloadError () const;

    /**
     * Sets the value of the member "u32ApDownloadError".
     *
     *
     *
     * @param u32ApDownloadError The value which will be set
     */
    inline void setU32ApDownloadError (uint32 u32ApDownloadError_);

    // API of field "u32ApOvertemperature"

    static const int kU32ApOvertemperature = 7;

    /**
     * Clears the field "u32ApOvertemperature".
     *
     * The field will be set to its default value. The hasU32ApOvertemperature()
     * method will return false.
     */
    inline void clearU32ApOvertemperature();

    /**
     * Checks whether the field "u32ApOvertemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApOvertemperature()). Otherwise it will return false.
     */
    inline bool hasU32ApOvertemperature () const;

    /**
     * Returns the value of the member "u32ApOvertemperature".
     *
     *
     *
     * @return The value of the field "u32ApOvertemperature"
     */
    inline uint32 getU32ApOvertemperature () const;

    /**
     * Sets the value of the member "u32ApOvertemperature".
     *
     *
     *
     * @param u32ApOvertemperature The value which will be set
     */
    inline void setU32ApOvertemperature (uint32 u32ApOvertemperature_);

    // API of field "u32ApUser"

    static const int kU32ApUser = 8;

    /**
     * Clears the field "u32ApUser".
     *
     * The field will be set to its default value. The hasU32ApUser()
     * method will return false.
     */
    inline void clearU32ApUser();

    /**
     * Checks whether the field "u32ApUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUser()). Otherwise it will return false.
     */
    inline bool hasU32ApUser () const;

    /**
     * Returns the value of the member "u32ApUser".
     *
     *
     *
     * @return The value of the field "u32ApUser"
     */
    inline uint32 getU32ApUser () const;

    /**
     * Sets the value of the member "u32ApUser".
     *
     *
     *
     * @param u32ApUser The value which will be set
     */
    inline void setU32ApUser (uint32 u32ApUser_);

    // API of field "u32ApLcmIntern"

    static const int kU32ApLcmIntern = 9;

    /**
     * Clears the field "u32ApLcmIntern".
     *
     * The field will be set to its default value. The hasU32ApLcmIntern()
     * method will return false.
     */
    inline void clearU32ApLcmIntern();

    /**
     * Checks whether the field "u32ApLcmIntern" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApLcmIntern()). Otherwise it will return false.
     */
    inline bool hasU32ApLcmIntern () const;

    /**
     * Returns the value of the member "u32ApLcmIntern".
     *
     *
     *
     * @return The value of the field "u32ApLcmIntern"
     */
    inline uint32 getU32ApLcmIntern () const;

    /**
     * Sets the value of the member "u32ApLcmIntern".
     *
     *
     *
     * @param u32ApLcmIntern The value which will be set
     */
    inline void setU32ApLcmIntern (uint32 u32ApLcmIntern_);

    // API of field "u32ApWarmstartCount"

    static const int kU32ApWarmstartCount = 10;

    /**
     * Clears the field "u32ApWarmstartCount".
     *
     * The field will be set to its default value. The hasU32ApWarmstartCount()
     * method will return false.
     */
    inline void clearU32ApWarmstartCount();

    /**
     * Checks whether the field "u32ApWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32ApWarmstartCount () const;

    /**
     * Returns the value of the member "u32ApWarmstartCount".
     *
     *
     *
     * @return The value of the field "u32ApWarmstartCount"
     */
    inline uint32 getU32ApWarmstartCount () const;

    /**
     * Sets the value of the member "u32ApWarmstartCount".
     *
     *
     *
     * @param u32ApWarmstartCount The value which will be set
     */
    inline void setU32ApWarmstartCount (uint32 u32ApWarmstartCount_);

    // API of field "u32ApPowerOnCount"

    static const int kU32ApPowerOnCount = 11;

    /**
     * Clears the field "u32ApPowerOnCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOnCount()
     * method will return false.
     */
    inline void clearU32ApPowerOnCount();

    /**
     * Checks whether the field "u32ApPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOnCount () const;

    /**
     * Returns the value of the member "u32ApPowerOnCount".
     *
     *
     *
     * @return The value of the field "u32ApPowerOnCount"
     */
    inline uint32 getU32ApPowerOnCount () const;

    /**
     * Sets the value of the member "u32ApPowerOnCount".
     *
     *
     *
     * @param u32ApPowerOnCount The value which will be set
     */
    inline void setU32ApPowerOnCount (uint32 u32ApPowerOnCount_);

    // API of field "u32ApPowerLossCount"

    static const int kU32ApPowerLossCount = 12;

    /**
     * Clears the field "u32ApPowerLossCount".
     *
     * The field will be set to its default value. The hasU32ApPowerLossCount()
     * method will return false.
     */
    inline void clearU32ApPowerLossCount();

    /**
     * Checks whether the field "u32ApPowerLossCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerLossCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerLossCount () const;

    /**
     * Returns the value of the member "u32ApPowerLossCount".
     *
     *
     *
     * @return The value of the field "u32ApPowerLossCount"
     */
    inline uint32 getU32ApPowerLossCount () const;

    /**
     * Sets the value of the member "u32ApPowerLossCount".
     *
     *
     *
     * @param u32ApPowerLossCount The value which will be set
     */
    inline void setU32ApPowerLossCount (uint32 u32ApPowerLossCount_);

    // API of field "u32ApPowerOffCount"

    static const int kU32ApPowerOffCount = 13;

    /**
     * Clears the field "u32ApPowerOffCount".
     *
     * The field will be set to its default value. The hasU32ApPowerOffCount()
     * method will return false.
     */
    inline void clearU32ApPowerOffCount();

    /**
     * Checks whether the field "u32ApPowerOffCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApPowerOffCount()). Otherwise it will return false.
     */
    inline bool hasU32ApPowerOffCount () const;

    /**
     * Returns the value of the member "u32ApPowerOffCount".
     *
     *
     *
     * @return The value of the field "u32ApPowerOffCount"
     */
    inline uint32 getU32ApPowerOffCount () const;

    /**
     * Sets the value of the member "u32ApPowerOffCount".
     *
     *
     *
     * @param u32ApPowerOffCount The value which will be set
     */
    inline void setU32ApPowerOffCount (uint32 u32ApPowerOffCount_);

    // API of field "u32ApSccCount"

    static const int kU32ApSccCount = 14;

    /**
     * Clears the field "u32ApSccCount".
     *
     * The field will be set to its default value. The hasU32ApSccCount()
     * method will return false.
     */
    inline void clearU32ApSccCount();

    /**
     * Checks whether the field "u32ApSccCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApSccCount()). Otherwise it will return false.
     */
    inline bool hasU32ApSccCount () const;

    /**
     * Returns the value of the member "u32ApSccCount".
     *
     *
     *
     * @return The value of the field "u32ApSccCount"
     */
    inline uint32 getU32ApSccCount () const;

    /**
     * Sets the value of the member "u32ApSccCount".
     *
     *
     *
     * @param u32ApSccCount The value which will be set
     */
    inline void setU32ApSccCount (uint32 u32ApSccCount_);

    // API of field "u32ApUnknownCount"

    static const int kU32ApUnknownCount = 15;

    /**
     * Clears the field "u32ApUnknownCount".
     *
     * The field will be set to its default value. The hasU32ApUnknownCount()
     * method will return false.
     */
    inline void clearU32ApUnknownCount();

    /**
     * Checks whether the field "u32ApUnknownCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ApUnknownCount()). Otherwise it will return false.
     */
    inline bool hasU32ApUnknownCount () const;

    /**
     * Returns the value of the member "u32ApUnknownCount".
     *
     *
     *
     * @return The value of the field "u32ApUnknownCount"
     */
    inline uint32 getU32ApUnknownCount () const;

    /**
     * Sets the value of the member "u32ApUnknownCount".
     *
     *
     *
     * @param u32ApUnknownCount The value which will be set
     */
    inline void setU32ApUnknownCount (uint32 u32ApUnknownCount_);

    // API of field "u32SccHwWdtCount"

    static const int kU32SccHwWdtCount = 16;

    /**
     * Clears the field "u32SccHwWdtCount".
     *
     * The field will be set to its default value. The hasU32SccHwWdtCount()
     * method will return false.
     */
    inline void clearU32SccHwWdtCount();

    /**
     * Checks whether the field "u32SccHwWdtCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccHwWdtCount()). Otherwise it will return false.
     */
    inline bool hasU32SccHwWdtCount () const;

    /**
     * Returns the value of the member "u32SccHwWdtCount".
     *
     *
     *
     * @return The value of the field "u32SccHwWdtCount"
     */
    inline uint32 getU32SccHwWdtCount () const;

    /**
     * Sets the value of the member "u32SccHwWdtCount".
     *
     *
     *
     * @param u32SccHwWdtCount The value which will be set
     */
    inline void setU32SccHwWdtCount (uint32 u32SccHwWdtCount_);

    // API of field "u32SccPowerOnCount"

    static const int kU32SccPowerOnCount = 17;

    /**
     * Clears the field "u32SccPowerOnCount".
     *
     * The field will be set to its default value. The hasU32SccPowerOnCount()
     * method will return false.
     */
    inline void clearU32SccPowerOnCount();

    /**
     * Checks whether the field "u32SccPowerOnCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccPowerOnCount()). Otherwise it will return false.
     */
    inline bool hasU32SccPowerOnCount () const;

    /**
     * Returns the value of the member "u32SccPowerOnCount".
     *
     *
     *
     * @return The value of the field "u32SccPowerOnCount"
     */
    inline uint32 getU32SccPowerOnCount () const;

    /**
     * Sets the value of the member "u32SccPowerOnCount".
     *
     *
     *
     * @param u32SccPowerOnCount The value which will be set
     */
    inline void setU32SccPowerOnCount (uint32 u32SccPowerOnCount_);

    // API of field "u32SccColdstartCount"

    static const int kU32SccColdstartCount = 18;

    /**
     * Clears the field "u32SccColdstartCount".
     *
     * The field will be set to its default value. The hasU32SccColdstartCount()
     * method will return false.
     */
    inline void clearU32SccColdstartCount();

    /**
     * Checks whether the field "u32SccColdstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccColdstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccColdstartCount () const;

    /**
     * Returns the value of the member "u32SccColdstartCount".
     *
     *
     *
     * @return The value of the field "u32SccColdstartCount"
     */
    inline uint32 getU32SccColdstartCount () const;

    /**
     * Sets the value of the member "u32SccColdstartCount".
     *
     *
     *
     * @param u32SccColdstartCount The value which will be set
     */
    inline void setU32SccColdstartCount (uint32 u32SccColdstartCount_);

    // API of field "u32SccAppmodeChangeCount"

    static const int kU32SccAppmodeChangeCount = 19;

    /**
     * Clears the field "u32SccAppmodeChangeCount".
     *
     * The field will be set to its default value. The hasU32SccAppmodeChangeCount()
     * method will return false.
     */
    inline void clearU32SccAppmodeChangeCount();

    /**
     * Checks whether the field "u32SccAppmodeChangeCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccAppmodeChangeCount()). Otherwise it will return false.
     */
    inline bool hasU32SccAppmodeChangeCount () const;

    /**
     * Returns the value of the member "u32SccAppmodeChangeCount".
     *
     *
     *
     * @return The value of the field "u32SccAppmodeChangeCount"
     */
    inline uint32 getU32SccAppmodeChangeCount () const;

    /**
     * Sets the value of the member "u32SccAppmodeChangeCount".
     *
     *
     *
     * @param u32SccAppmodeChangeCount The value which will be set
     */
    inline void setU32SccAppmodeChangeCount (uint32 u32SccAppmodeChangeCount_);

    // API of field "u32SccDuringLpwCount"

    static const int kU32SccDuringLpwCount = 20;

    /**
     * Clears the field "u32SccDuringLpwCount".
     *
     * The field will be set to its default value. The hasU32SccDuringLpwCount()
     * method will return false.
     */
    inline void clearU32SccDuringLpwCount();

    /**
     * Checks whether the field "u32SccDuringLpwCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringLpwCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringLpwCount () const;

    /**
     * Returns the value of the member "u32SccDuringLpwCount".
     *
     *
     *
     * @return The value of the field "u32SccDuringLpwCount"
     */
    inline uint32 getU32SccDuringLpwCount () const;

    /**
     * Sets the value of the member "u32SccDuringLpwCount".
     *
     *
     *
     * @param u32SccDuringLpwCount The value which will be set
     */
    inline void setU32SccDuringLpwCount (uint32 u32SccDuringLpwCount_);

    // API of field "u32SccDuringPllOszCount"

    static const int kU32SccDuringPllOszCount = 21;

    /**
     * Clears the field "u32SccDuringPllOszCount".
     *
     * The field will be set to its default value. The hasU32SccDuringPllOszCount()
     * method will return false.
     */
    inline void clearU32SccDuringPllOszCount();

    /**
     * Checks whether the field "u32SccDuringPllOszCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringPllOszCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringPllOszCount () const;

    /**
     * Returns the value of the member "u32SccDuringPllOszCount".
     *
     *
     *
     * @return The value of the field "u32SccDuringPllOszCount"
     */
    inline uint32 getU32SccDuringPllOszCount () const;

    /**
     * Sets the value of the member "u32SccDuringPllOszCount".
     *
     *
     *
     * @param u32SccDuringPllOszCount The value which will be set
     */
    inline void setU32SccDuringPllOszCount (uint32 u32SccDuringPllOszCount_);

    // API of field "u32SccDuringSWCount"

    static const int kU32SccDuringSWCount = 22;

    /**
     * Clears the field "u32SccDuringSWCount".
     *
     * The field will be set to its default value. The hasU32SccDuringSWCount()
     * method will return false.
     */
    inline void clearU32SccDuringSWCount();

    /**
     * Checks whether the field "u32SccDuringSWCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccDuringSWCount()). Otherwise it will return false.
     */
    inline bool hasU32SccDuringSWCount () const;

    /**
     * Returns the value of the member "u32SccDuringSWCount".
     *
     *
     *
     * @return The value of the field "u32SccDuringSWCount"
     */
    inline uint32 getU32SccDuringSWCount () const;

    /**
     * Sets the value of the member "u32SccDuringSWCount".
     *
     *
     *
     * @param u32SccDuringSWCount The value which will be set
     */
    inline void setU32SccDuringSWCount (uint32 u32SccDuringSWCount_);

    // API of field "u32SccWarmstartCount"

    static const int kU32SccWarmstartCount = 23;

    /**
     * Clears the field "u32SccWarmstartCount".
     *
     * The field will be set to its default value. The hasU32SccWarmstartCount()
     * method will return false.
     */
    inline void clearU32SccWarmstartCount();

    /**
     * Checks whether the field "u32SccWarmstartCount" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SccWarmstartCount()). Otherwise it will return false.
     */
    inline bool hasU32SccWarmstartCount () const;

    /**
     * Returns the value of the member "u32SccWarmstartCount".
     *
     *
     *
     * @return The value of the field "u32SccWarmstartCount"
     */
    inline uint32 getU32SccWarmstartCount () const;

    /**
     * Sets the value of the member "u32SccWarmstartCount".
     *
     *
     *
     * @param u32SccWarmstartCount The value which will be set
     */
    inline void setU32SccWarmstartCount (uint32 u32SccWarmstartCount_);

    static const T_SPM_ResetInfoStatisticData &getDefaultInstance();

private:

    inline void set_has_tLastResetDate ();

    inline void clear_has_tLastResetDate ();

    inline void set_has_tLastResetReason ();

    inline void clear_has_tLastResetReason ();

    inline void set_has_u32ApApplicationError ();

    inline void clear_has_u32ApApplicationError ();

    inline void set_has_u32ApSoftware ();

    inline void clear_has_u32ApSoftware ();

    inline void set_has_u32ApEcuReset ();

    inline void clear_has_u32ApEcuReset ();

    inline void set_has_u32ApDownload ();

    inline void clear_has_u32ApDownload ();

    inline void set_has_u32ApDownloadError ();

    inline void clear_has_u32ApDownloadError ();

    inline void set_has_u32ApOvertemperature ();

    inline void clear_has_u32ApOvertemperature ();

    inline void set_has_u32ApUser ();

    inline void clear_has_u32ApUser ();

    inline void set_has_u32ApLcmIntern ();

    inline void clear_has_u32ApLcmIntern ();

    inline void set_has_u32ApWarmstartCount ();

    inline void clear_has_u32ApWarmstartCount ();

    inline void set_has_u32ApPowerOnCount ();

    inline void clear_has_u32ApPowerOnCount ();

    inline void set_has_u32ApPowerLossCount ();

    inline void clear_has_u32ApPowerLossCount ();

    inline void set_has_u32ApPowerOffCount ();

    inline void clear_has_u32ApPowerOffCount ();

    inline void set_has_u32ApSccCount ();

    inline void clear_has_u32ApSccCount ();

    inline void set_has_u32ApUnknownCount ();

    inline void clear_has_u32ApUnknownCount ();

    inline void set_has_u32SccHwWdtCount ();

    inline void clear_has_u32SccHwWdtCount ();

    inline void set_has_u32SccPowerOnCount ();

    inline void clear_has_u32SccPowerOnCount ();

    inline void set_has_u32SccColdstartCount ();

    inline void clear_has_u32SccColdstartCount ();

    inline void set_has_u32SccAppmodeChangeCount ();

    inline void clear_has_u32SccAppmodeChangeCount ();

    inline void set_has_u32SccDuringLpwCount ();

    inline void clear_has_u32SccDuringLpwCount ();

    inline void set_has_u32SccDuringPllOszCount ();

    inline void clear_has_u32SccDuringPllOszCount ();

    inline void set_has_u32SccDuringSWCount ();

    inline void clear_has_u32SccDuringSWCount ();

    inline void set_has_u32SccWarmstartCount ();

    inline void clear_has_u32SccWarmstartCount ();

    uint32 _has_bits_[ (24 + 31) / 32];

    TTimeDate _tLastResetDate;

    T_e8_LcmResetReason _tLastResetReason;

    uint32 _u32ApApplicationError;

    uint32 _u32ApSoftware;

    uint32 _u32ApEcuReset;

    uint32 _u32ApDownload;

    uint32 _u32ApDownloadError;

    uint32 _u32ApOvertemperature;

    uint32 _u32ApUser;

    uint32 _u32ApLcmIntern;

    uint32 _u32ApWarmstartCount;

    uint32 _u32ApPowerOnCount;

    uint32 _u32ApPowerLossCount;

    uint32 _u32ApPowerOffCount;

    uint32 _u32ApSccCount;

    uint32 _u32ApUnknownCount;

    uint32 _u32SccHwWdtCount;

    uint32 _u32SccPowerOnCount;

    uint32 _u32SccColdstartCount;

    uint32 _u32SccAppmodeChangeCount;

    uint32 _u32SccDuringLpwCount;

    uint32 _u32SccDuringPllOszCount;

    uint32 _u32SccDuringSWCount;

    uint32 _u32SccWarmstartCount;

};

/**
 * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.  (CCA FID: 0x1000)
 */
class SystemModeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemModeRequest ();

    /**
     * Copy constructor
     */
    inline  SystemModeRequest (const SystemModeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SystemModeRequest (T_e8_StateModes eSystemMode_);

    /**
     * Destructor
     */
    inline virtual  ~SystemModeRequest();

    /**
     * Assignment operator
     */
    inline SystemModeRequest& operator = (const SystemModeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemModeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemModeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemModeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemModeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eSystemMode"

    static const int kESystemMode = 0;

    /**
     * Clears the field "eSystemMode".
     *
     * The field will be set to its default value. The hasESystemMode()
     * method will return false.
     */
    inline void clearESystemMode();

    /**
     * Checks whether the field "eSystemMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESystemMode()). Otherwise it will return false.
     */
    inline bool hasESystemMode () const;

    /**
     * Returns the value of the member "eSystemMode".
     *
     * If the meaning of "eSystemMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eSystemMode"
     */
    inline T_e8_StateModes getESystemMode () const;

    /**
     * Sets the value of the member "eSystemMode".
     *
     * If the meaning of "eSystemMode" isn't clear, then there should be a description here.
     *
     * @param eSystemMode The value which will be set
     */
    inline void setESystemMode (T_e8_StateModes eSystemMode_);

    static const SystemModeRequest &getDefaultInstance();

private:

    inline void set_has_eSystemMode ();

    inline void clear_has_eSystemMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_e8_StateModes _eSystemMode;

};

/**
 * Method to trigger a system state change e.g. DOWNLOAD / Diagnosis.  (CCA FID: 0x1000)
 */
class SystemModeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemModeResponse ();

    /**
     * Copy constructor
     */
    inline  SystemModeResponse (const SystemModeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SystemModeResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~SystemModeResponse();

    /**
     * Assignment operator
     */
    inline SystemModeResponse& operator = (const SystemModeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemModeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemModeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemModeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemModeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const SystemModeResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLock !!! Method to lock specific resources for restricted downloads.  (CCA FID: 0x1001)
 */
class DownloadLockStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStateRequest ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStateRequest (const DownloadLockStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadLockStateRequest (const ::std::string& strRestrictedDlState_, T_e8_DownloadLockStates eRestrictedDlMode_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStateRequest();

    /**
     * Assignment operator
     */
    inline DownloadLockStateRequest& operator = (const DownloadLockStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strRestrictedDlState"

    static const int kStrRestrictedDlState = 0;

    /**
     * Clears the field "strRestrictedDlState".
     *
     * The field will be set to its default value. The hasStrRestrictedDlState()
     * method will return false.
     */
    inline void clearStrRestrictedDlState();

    /**
     * Checks whether the field "strRestrictedDlState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrRestrictedDlState()). Otherwise it will return false.
     */
    inline bool hasStrRestrictedDlState () const;

    /**
     * Returns the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strRestrictedDlState"
     */
    inline const ::std::string& getStrRestrictedDlState () const;

    /**
     * Retrieves the value of the field "strRestrictedDlState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strRestrictedDlState".
     */
    inline ::std::string& getStrRestrictedDlStateMutable ();

    /**
     * Sets the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @param strRestrictedDlState The value which will be set
     */
    inline void setStrRestrictedDlState (const ::std::string& strRestrictedDlState_);

    /**
     * Sets the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @param strRestrictedDlState The value which will be set
     */
    inline void setStrRestrictedDlState (const char* strRestrictedDlState_);

    /**
     * Sets the value of the member "strRestrictedDlState".
     *
     * If the meaning of "strRestrictedDlState" isn't clear, then there should be a description here.
     *
     * @param strRestrictedDlState The value which will be set
     */
    inline void setStrRestrictedDlState (const char* value, size_t size);

    // API of field "eRestrictedDlMode"

    static const int kERestrictedDlMode = 1;

    /**
     * Clears the field "eRestrictedDlMode".
     *
     * The field will be set to its default value. The hasERestrictedDlMode()
     * method will return false.
     */
    inline void clearERestrictedDlMode();

    /**
     * Checks whether the field "eRestrictedDlMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERestrictedDlMode()). Otherwise it will return false.
     */
    inline bool hasERestrictedDlMode () const;

    /**
     * Returns the value of the member "eRestrictedDlMode".
     *
     * If the meaning of "eRestrictedDlMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eRestrictedDlMode"
     */
    inline T_e8_DownloadLockStates getERestrictedDlMode () const;

    /**
     * Sets the value of the member "eRestrictedDlMode".
     *
     * If the meaning of "eRestrictedDlMode" isn't clear, then there should be a description here.
     *
     * @param eRestrictedDlMode The value which will be set
     */
    inline void setERestrictedDlMode (T_e8_DownloadLockStates eRestrictedDlMode_);

    static const DownloadLockStateRequest &getDefaultInstance();

private:

    inline void set_has_strRestrictedDlState ();

    inline void clear_has_strRestrictedDlState ();

    inline void set_has_eRestrictedDlMode ();

    inline void clear_has_eRestrictedDlMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strRestrictedDlState;

    T_e8_DownloadLockStates _eRestrictedDlMode;

};

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLock !!! Method to lock specific resources for restricted downloads.  (CCA FID: 0x1001)
 */
class DownloadLockStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStateResponse ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStateResponse (const DownloadLockStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadLockStateResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStateResponse();

    /**
     * Assignment operator
     */
    inline DownloadLockStateResponse& operator = (const DownloadLockStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const DownloadLockStateResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Method to modify a lock. Not existing locks will be created. Locks that are no longer owned nor used will be deleted. Owner and state of a lock will be stored persistently  (CCA FID: 0x1003)
 */
class UpdateLockRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockRequest ();

    /**
     * Copy constructor
     */
    inline  UpdateLockRequest (const UpdateLockRequest &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateLockRequest (const ::std::string& strLockName_, T_e8_UpdateLockCommand eLockRequest_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockRequest();

    /**
     * Assignment operator
     */
    inline UpdateLockRequest& operator = (const UpdateLockRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLockName"

    static const int kStrLockName = 0;

    /**
     * Clears the field "strLockName".
     *
     * The field will be set to its default value. The hasStrLockName()
     * method will return false.
     */
    inline void clearStrLockName();

    /**
     * Checks whether the field "strLockName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLockName()). Otherwise it will return false.
     */
    inline bool hasStrLockName () const;

    /**
     * Returns the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLockName"
     */
    inline const ::std::string& getStrLockName () const;

    /**
     * Retrieves the value of the field "strLockName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLockName".
     */
    inline ::std::string& getStrLockNameMutable ();

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const ::std::string& strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* strLockName_);

    /**
     * Sets the value of the member "strLockName".
     *
     * If the meaning of "strLockName" isn't clear, then there should be a description here.
     *
     * @param strLockName The value which will be set
     */
    inline void setStrLockName (const char* value, size_t size);

    // API of field "eLockRequest"

    static const int kELockRequest = 1;

    /**
     * Clears the field "eLockRequest".
     *
     * The field will be set to its default value. The hasELockRequest()
     * method will return false.
     */
    inline void clearELockRequest();

    /**
     * Checks whether the field "eLockRequest" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setELockRequest()). Otherwise it will return false.
     */
    inline bool hasELockRequest () const;

    /**
     * Returns the value of the member "eLockRequest".
     *
     * If the meaning of "eLockRequest" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eLockRequest"
     */
    inline T_e8_UpdateLockCommand getELockRequest () const;

    /**
     * Sets the value of the member "eLockRequest".
     *
     * If the meaning of "eLockRequest" isn't clear, then there should be a description here.
     *
     * @param eLockRequest The value which will be set
     */
    inline void setELockRequest (T_e8_UpdateLockCommand eLockRequest_);

    static const UpdateLockRequest &getDefaultInstance();

private:

    inline void set_has_strLockName ();

    inline void clear_has_strLockName ();

    inline void set_has_eLockRequest ();

    inline void clear_has_eLockRequest ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strLockName;

    T_e8_UpdateLockCommand _eLockRequest;

};

/**
 * Method to modify a lock. Not existing locks will be created. Locks that are no longer owned nor used will be deleted. Owner and state of a lock will be stored persistently  (CCA FID: 0x1003)
 */
class UpdateLockResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockResponse ();

    /**
     * Copy constructor
     */
    inline  UpdateLockResponse (const UpdateLockResponse &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateLockResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockResponse();

    /**
     * Assignment operator
     */
    inline UpdateLockResponse& operator = (const UpdateLockResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const UpdateLockResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Set a new OnOff reason. A new system state will be calculated. (CCA FID: 0x100f)
 */
class OnOffTriggerRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffTriggerRequest ();

    /**
     * Copy constructor
     */
    inline  OnOffTriggerRequest (const OnOffTriggerRequest &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffTriggerRequest (T_SPM_e32_SubStateType eSwitchOnTrigger_, bool bState_);

    /**
     * Destructor
     */
    inline virtual  ~OnOffTriggerRequest();

    /**
     * Assignment operator
     */
    inline OnOffTriggerRequest& operator = (const OnOffTriggerRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffTriggerRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffTriggerRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffTriggerRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffTriggerRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eSwitchOnTrigger"

    static const int kESwitchOnTrigger = 0;

    /**
     * Clears the field "eSwitchOnTrigger".
     *
     * The field will be set to its default value. The hasESwitchOnTrigger()
     * method will return false.
     */
    inline void clearESwitchOnTrigger();

    /**
     * Checks whether the field "eSwitchOnTrigger" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESwitchOnTrigger()). Otherwise it will return false.
     */
    inline bool hasESwitchOnTrigger () const;

    /**
     * Returns the value of the member "eSwitchOnTrigger".
     *
     * If the meaning of "eSwitchOnTrigger" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eSwitchOnTrigger"
     */
    inline T_SPM_e32_SubStateType getESwitchOnTrigger () const;

    /**
     * Sets the value of the member "eSwitchOnTrigger".
     *
     * If the meaning of "eSwitchOnTrigger" isn't clear, then there should be a description here.
     *
     * @param eSwitchOnTrigger The value which will be set
     */
    inline void setESwitchOnTrigger (T_SPM_e32_SubStateType eSwitchOnTrigger_);

    // API of field "bState"

    static const int kBState = 1;

    /**
     * Clears the field "bState".
     *
     * The field will be set to its default value. The hasBState()
     * method will return false.
     */
    inline void clearBState();

    /**
     * Checks whether the field "bState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBState()). Otherwise it will return false.
     */
    inline bool hasBState () const;

    /**
     * Returns the value of the member "bState".
     *
     * If the meaning of "bState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bState"
     */
    inline bool getBState () const;

    /**
     * Sets the value of the member "bState".
     *
     * If the meaning of "bState" isn't clear, then there should be a description here.
     *
     * @param bState The value which will be set
     */
    inline void setBState (bool bState_);

    static const OnOffTriggerRequest &getDefaultInstance();

private:

    inline void set_has_eSwitchOnTrigger ();

    inline void clear_has_eSwitchOnTrigger ();

    inline void set_has_bState ();

    inline void clear_has_bState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_SPM_e32_SubStateType _eSwitchOnTrigger;

    bool _bState;

};

/**
 * Set a new OnOff reason. A new system state will be calculated. (CCA FID: 0x100f)
 */
class OnOffTriggerResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffTriggerResponse ();

    /**
     * Copy constructor
     */
    inline  OnOffTriggerResponse (const OnOffTriggerResponse &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffTriggerResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~OnOffTriggerResponse();

    /**
     * Assignment operator
     */
    inline OnOffTriggerResponse& operator = (const OnOffTriggerResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffTriggerResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffTriggerResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffTriggerResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffTriggerResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const OnOffTriggerResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes. (CCA FID: 0x01fe)
 */
class StartProcessRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartProcessRequest ();

    /**
     * Copy constructor
     */
    inline  StartProcessRequest (const StartProcessRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartProcessRequest (const ::std::string& strLocation_, uint32 u32Prio_, uint32 u32Affinity_, uint32 u32AffinityEnd_, uint32 u32NiceLevel_, uint32 u32NiceLevelEnd_, T_SPM_e32_START_PROC_TYPE u32Type_, uint32 u32Info_);

    /**
     * Destructor
     */
    inline virtual  ~StartProcessRequest();

    /**
     * Assignment operator
     */
    inline StartProcessRequest& operator = (const StartProcessRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartProcessRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartProcessRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartProcessRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartProcessRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32Prio"

    static const int kU32Prio = 1;

    /**
     * Clears the field "u32Prio".
     *
     * The field will be set to its default value. The hasU32Prio()
     * method will return false.
     */
    inline void clearU32Prio();

    /**
     * Checks whether the field "u32Prio" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Prio()). Otherwise it will return false.
     */
    inline bool hasU32Prio () const;

    /**
     * Returns the value of the member "u32Prio".
     *
     * If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Prio"
     */
    inline uint32 getU32Prio () const;

    /**
     * Sets the value of the member "u32Prio".
     *
     * If the meaning of "u32Prio" isn't clear, then there should be a description here.
     *
     * @param u32Prio The value which will be set
     */
    inline void setU32Prio (uint32 u32Prio_);

    // API of field "u32Affinity"

    static const int kU32Affinity = 2;

    /**
     * Clears the field "u32Affinity".
     *
     * The field will be set to its default value. The hasU32Affinity()
     * method will return false.
     */
    inline void clearU32Affinity();

    /**
     * Checks whether the field "u32Affinity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Affinity()). Otherwise it will return false.
     */
    inline bool hasU32Affinity () const;

    /**
     * Returns the value of the member "u32Affinity".
     *
     * If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Affinity"
     */
    inline uint32 getU32Affinity () const;

    /**
     * Sets the value of the member "u32Affinity".
     *
     * If the meaning of "u32Affinity" isn't clear, then there should be a description here.
     *
     * @param u32Affinity The value which will be set
     */
    inline void setU32Affinity (uint32 u32Affinity_);

    // API of field "u32AffinityEnd"

    static const int kU32AffinityEnd = 3;

    /**
     * Clears the field "u32AffinityEnd".
     *
     * The field will be set to its default value. The hasU32AffinityEnd()
     * method will return false.
     */
    inline void clearU32AffinityEnd();

    /**
     * Checks whether the field "u32AffinityEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32AffinityEnd()). Otherwise it will return false.
     */
    inline bool hasU32AffinityEnd () const;

    /**
     * Returns the value of the member "u32AffinityEnd".
     *
     * If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32AffinityEnd"
     */
    inline uint32 getU32AffinityEnd () const;

    /**
     * Sets the value of the member "u32AffinityEnd".
     *
     * If the meaning of "u32AffinityEnd" isn't clear, then there should be a description here.
     *
     * @param u32AffinityEnd The value which will be set
     */
    inline void setU32AffinityEnd (uint32 u32AffinityEnd_);

    // API of field "u32NiceLevel"

    static const int kU32NiceLevel = 4;

    /**
     * Clears the field "u32NiceLevel".
     *
     * The field will be set to its default value. The hasU32NiceLevel()
     * method will return false.
     */
    inline void clearU32NiceLevel();

    /**
     * Checks whether the field "u32NiceLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NiceLevel()). Otherwise it will return false.
     */
    inline bool hasU32NiceLevel () const;

    /**
     * Returns the value of the member "u32NiceLevel".
     *
     * If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NiceLevel"
     */
    inline uint32 getU32NiceLevel () const;

    /**
     * Sets the value of the member "u32NiceLevel".
     *
     * If the meaning of "u32NiceLevel" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevel The value which will be set
     */
    inline void setU32NiceLevel (uint32 u32NiceLevel_);

    // API of field "u32NiceLevelEnd"

    static const int kU32NiceLevelEnd = 5;

    /**
     * Clears the field "u32NiceLevelEnd".
     *
     * The field will be set to its default value. The hasU32NiceLevelEnd()
     * method will return false.
     */
    inline void clearU32NiceLevelEnd();

    /**
     * Checks whether the field "u32NiceLevelEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32NiceLevelEnd()). Otherwise it will return false.
     */
    inline bool hasU32NiceLevelEnd () const;

    /**
     * Returns the value of the member "u32NiceLevelEnd".
     *
     * If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32NiceLevelEnd"
     */
    inline uint32 getU32NiceLevelEnd () const;

    /**
     * Sets the value of the member "u32NiceLevelEnd".
     *
     * If the meaning of "u32NiceLevelEnd" isn't clear, then there should be a description here.
     *
     * @param u32NiceLevelEnd The value which will be set
     */
    inline void setU32NiceLevelEnd (uint32 u32NiceLevelEnd_);

    // API of field "u32Type"

    static const int kU32Type = 6;

    /**
     * Clears the field "u32Type".
     *
     * The field will be set to its default value. The hasU32Type()
     * method will return false.
     */
    inline void clearU32Type();

    /**
     * Checks whether the field "u32Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Type()). Otherwise it will return false.
     */
    inline bool hasU32Type () const;

    /**
     * Returns the value of the member "u32Type".
     *
     * If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Type"
     */
    inline T_SPM_e32_START_PROC_TYPE getU32Type () const;

    /**
     * Sets the value of the member "u32Type".
     *
     * If the meaning of "u32Type" isn't clear, then there should be a description here.
     *
     * @param u32Type The value which will be set
     */
    inline void setU32Type (T_SPM_e32_START_PROC_TYPE u32Type_);

    // API of field "u32Info"

    static const int kU32Info = 7;

    /**
     * Clears the field "u32Info".
     *
     * The field will be set to its default value. The hasU32Info()
     * method will return false.
     */
    inline void clearU32Info();

    /**
     * Checks whether the field "u32Info" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Info()). Otherwise it will return false.
     */
    inline bool hasU32Info () const;

    /**
     * Returns the value of the member "u32Info".
     *
     * If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32Info"
     */
    inline uint32 getU32Info () const;

    /**
     * Sets the value of the member "u32Info".
     *
     * If the meaning of "u32Info" isn't clear, then there should be a description here.
     *
     * @param u32Info The value which will be set
     */
    inline void setU32Info (uint32 u32Info_);

    static const StartProcessRequest &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32Prio ();

    inline void clear_has_u32Prio ();

    inline void set_has_u32Affinity ();

    inline void clear_has_u32Affinity ();

    inline void set_has_u32AffinityEnd ();

    inline void clear_has_u32AffinityEnd ();

    inline void set_has_u32NiceLevel ();

    inline void clear_has_u32NiceLevel ();

    inline void set_has_u32NiceLevelEnd ();

    inline void clear_has_u32NiceLevelEnd ();

    inline void set_has_u32Type ();

    inline void clear_has_u32Type ();

    inline void set_has_u32Info ();

    inline void clear_has_u32Info ();

    uint32 _has_bits_[ (8 + 31) / 32];

    ::std::string _strLocation;

    uint32 _u32Prio;

    uint32 _u32Affinity;

    uint32 _u32AffinityEnd;

    uint32 _u32NiceLevel;

    uint32 _u32NiceLevelEnd;

    T_SPM_e32_START_PROC_TYPE _u32Type;

    uint32 _u32Info;

};

/**
 * Trigger to start a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger start process at the right time for their purposes. (CCA FID: 0x01fe)
 */
class StartProcessResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartProcessResponse ();

    /**
     * Copy constructor
     */
    inline  StartProcessResponse (const StartProcessResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartProcessResponse (int32 s32ReturnValOut_, const ::std::string& strLocationOut_, uint32 u32ProcIdOut_, uint32 u32SpawnDurationOut_);

    /**
     * Destructor
     */
    inline virtual  ~StartProcessResponse();

    /**
     * Assignment operator
     */
    inline StartProcessResponse& operator = (const StartProcessResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartProcessResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartProcessResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartProcessResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartProcessResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    // API of field "strLocationOut"

    static const int kStrLocationOut = 1;

    /**
     * Clears the field "strLocationOut".
     *
     * The field will be set to its default value. The hasStrLocationOut()
     * method will return false.
     */
    inline void clearStrLocationOut();

    /**
     * Checks whether the field "strLocationOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocationOut()). Otherwise it will return false.
     */
    inline bool hasStrLocationOut () const;

    /**
     * Returns the value of the member "strLocationOut".
     *
     * If the meaning of "strLocationOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocationOut"
     */
    inline const ::std::string& getStrLocationOut () const;

    /**
     * Retrieves the value of the field "strLocationOut" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocationOut".
     */
    inline ::std::string& getStrLocationOutMutable ();

    /**
     * Sets the value of the member "strLocationOut".
     *
     * If the meaning of "strLocationOut" isn't clear, then there should be a description here.
     *
     * @param strLocationOut The value which will be set
     */
    inline void setStrLocationOut (const ::std::string& strLocationOut_);

    /**
     * Sets the value of the member "strLocationOut".
     *
     * If the meaning of "strLocationOut" isn't clear, then there should be a description here.
     *
     * @param strLocationOut The value which will be set
     */
    inline void setStrLocationOut (const char* strLocationOut_);

    /**
     * Sets the value of the member "strLocationOut".
     *
     * If the meaning of "strLocationOut" isn't clear, then there should be a description here.
     *
     * @param strLocationOut The value which will be set
     */
    inline void setStrLocationOut (const char* value, size_t size);

    // API of field "u32ProcIdOut"

    static const int kU32ProcIdOut = 2;

    /**
     * Clears the field "u32ProcIdOut".
     *
     * The field will be set to its default value. The hasU32ProcIdOut()
     * method will return false.
     */
    inline void clearU32ProcIdOut();

    /**
     * Checks whether the field "u32ProcIdOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcIdOut()). Otherwise it will return false.
     */
    inline bool hasU32ProcIdOut () const;

    /**
     * Returns the value of the member "u32ProcIdOut".
     *
     * If the meaning of "u32ProcIdOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcIdOut"
     */
    inline uint32 getU32ProcIdOut () const;

    /**
     * Sets the value of the member "u32ProcIdOut".
     *
     * If the meaning of "u32ProcIdOut" isn't clear, then there should be a description here.
     *
     * @param u32ProcIdOut The value which will be set
     */
    inline void setU32ProcIdOut (uint32 u32ProcIdOut_);

    // API of field "u32SpawnDurationOut"

    static const int kU32SpawnDurationOut = 3;

    /**
     * Clears the field "u32SpawnDurationOut".
     *
     * The field will be set to its default value. The hasU32SpawnDurationOut()
     * method will return false.
     */
    inline void clearU32SpawnDurationOut();

    /**
     * Checks whether the field "u32SpawnDurationOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32SpawnDurationOut()). Otherwise it will return false.
     */
    inline bool hasU32SpawnDurationOut () const;

    /**
     * Returns the value of the member "u32SpawnDurationOut".
     *
     * If the meaning of "u32SpawnDurationOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32SpawnDurationOut"
     */
    inline uint32 getU32SpawnDurationOut () const;

    /**
     * Sets the value of the member "u32SpawnDurationOut".
     *
     * If the meaning of "u32SpawnDurationOut" isn't clear, then there should be a description here.
     *
     * @param u32SpawnDurationOut The value which will be set
     */
    inline void setU32SpawnDurationOut (uint32 u32SpawnDurationOut_);

    static const StartProcessResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    inline void set_has_strLocationOut ();

    inline void clear_has_strLocationOut ();

    inline void set_has_u32ProcIdOut ();

    inline void clear_has_u32ProcIdOut ();

    inline void set_has_u32SpawnDurationOut ();

    inline void clear_has_u32SpawnDurationOut ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _s32ReturnValOut;

    ::std::string _strLocationOut;

    uint32 _u32ProcIdOut;

    uint32 _u32SpawnDurationOut;

};

/**
 * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes. (CCA FID: 0x01fd)
 */
class StopProcessRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopProcessRequest ();

    /**
     * Copy constructor
     */
    inline  StopProcessRequest (const StopProcessRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StopProcessRequest (const ::std::string& strLocation_, uint32 u32ProcId_);

    /**
     * Destructor
     */
    inline virtual  ~StopProcessRequest();

    /**
     * Assignment operator
     */
    inline StopProcessRequest& operator = (const StopProcessRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopProcessRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopProcessRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopProcessRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopProcessRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32ProcId"

    static const int kU32ProcId = 1;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    static const StopProcessRequest &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strLocation;

    uint32 _u32ProcId;

};

/**
 * Trigger to stop a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger stop process at the right time for their purposes. (CCA FID: 0x01fd)
 */
class StopProcessResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StopProcessResponse ();

    /**
     * Copy constructor
     */
    inline  StopProcessResponse (const StopProcessResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StopProcessResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~StopProcessResponse();

    /**
     * Assignment operator
     */
    inline StopProcessResponse& operator = (const StopProcessResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StopProcessResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StopProcessResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StopProcessResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StopProcessResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const StopProcessResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes. (CCA FID: 0x01fc)
 */
class RestartProcessRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartProcessRequest ();

    /**
     * Copy constructor
     */
    inline  RestartProcessRequest (const RestartProcessRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RestartProcessRequest (const ::std::string& strLocation_, uint32 u32ProcId_);

    /**
     * Destructor
     */
    inline virtual  ~RestartProcessRequest();

    /**
     * Assignment operator
     */
    inline RestartProcessRequest& operator = (const RestartProcessRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartProcessRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartProcessRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartProcessRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartProcessRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strLocation"

    static const int kStrLocation = 0;

    /**
     * Clears the field "strLocation".
     *
     * The field will be set to its default value. The hasStrLocation()
     * method will return false.
     */
    inline void clearStrLocation();

    /**
     * Checks whether the field "strLocation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrLocation()). Otherwise it will return false.
     */
    inline bool hasStrLocation () const;

    /**
     * Returns the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strLocation"
     */
    inline const ::std::string& getStrLocation () const;

    /**
     * Retrieves the value of the field "strLocation" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strLocation".
     */
    inline ::std::string& getStrLocationMutable ();

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const ::std::string& strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* strLocation_);

    /**
     * Sets the value of the member "strLocation".
     *
     * If the meaning of "strLocation" isn't clear, then there should be a description here.
     *
     * @param strLocation The value which will be set
     */
    inline void setStrLocation (const char* value, size_t size);

    // API of field "u32ProcId"

    static const int kU32ProcId = 1;

    /**
     * Clears the field "u32ProcId".
     *
     * The field will be set to its default value. The hasU32ProcId()
     * method will return false.
     */
    inline void clearU32ProcId();

    /**
     * Checks whether the field "u32ProcId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32ProcId()). Otherwise it will return false.
     */
    inline bool hasU32ProcId () const;

    /**
     * Returns the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @return The value of the field "u32ProcId"
     */
    inline uint32 getU32ProcId () const;

    /**
     * Sets the value of the member "u32ProcId".
     *
     * If the meaning of "u32ProcId" isn't clear, then there should be a description here.
     *
     * @param u32ProcId The value which will be set
     */
    inline void setU32ProcId (uint32 u32ProcId_);

    static const RestartProcessRequest &getDefaultInstance();

private:

    inline void set_has_strLocation ();

    inline void clear_has_strLocation ();

    inline void set_has_u32ProcId ();

    inline void clear_has_u32ProcId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _strLocation;

    uint32 _u32ProcId;

};

/**
 * Trigger to restart a process. This public interface is for internal LCM use, also for (preconfigured) external LCM applications which allowed to trigger restart process at the right time for their purposes. (CCA FID: 0x01fc)
 */
class RestartProcessResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartProcessResponse ();

    /**
     * Copy constructor
     */
    inline  RestartProcessResponse (const RestartProcessResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RestartProcessResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~RestartProcessResponse();

    /**
     * Assignment operator
     */
    inline RestartProcessResponse& operator = (const RestartProcessResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartProcessResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartProcessResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartProcessResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartProcessResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const RestartProcessResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Inform about a new reached sync point. (CCA FID: 0x160)
 */
class StartUpSyncPointReachedRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUpSyncPointReachedRequest ();

    /**
     * Copy constructor
     */
    inline  StartUpSyncPointReachedRequest (const StartUpSyncPointReachedRequest &rhs);

    /**
     * All fields constructor
     */
    inline  StartUpSyncPointReachedRequest (const ::std::string& strNewSyncPoint_);

    /**
     * Destructor
     */
    inline virtual  ~StartUpSyncPointReachedRequest();

    /**
     * Assignment operator
     */
    inline StartUpSyncPointReachedRequest& operator = (const StartUpSyncPointReachedRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUpSyncPointReachedRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUpSyncPointReachedRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUpSyncPointReachedRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUpSyncPointReachedRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strNewSyncPoint"

    static const int kStrNewSyncPoint = 0;

    /**
     * Clears the field "strNewSyncPoint".
     *
     * The field will be set to its default value. The hasStrNewSyncPoint()
     * method will return false.
     */
    inline void clearStrNewSyncPoint();

    /**
     * Checks whether the field "strNewSyncPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrNewSyncPoint()). Otherwise it will return false.
     */
    inline bool hasStrNewSyncPoint () const;

    /**
     * Returns the value of the member "strNewSyncPoint".
     *
     * If the meaning of "strNewSyncPoint" isn't clear, then there should be a description here.
     *
     * @return The value of the field "strNewSyncPoint"
     */
    inline const ::std::string& getStrNewSyncPoint () const;

    /**
     * Retrieves the value of the field "strNewSyncPoint" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strNewSyncPoint".
     */
    inline ::std::string& getStrNewSyncPointMutable ();

    /**
     * Sets the value of the member "strNewSyncPoint".
     *
     * If the meaning of "strNewSyncPoint" isn't clear, then there should be a description here.
     *
     * @param strNewSyncPoint The value which will be set
     */
    inline void setStrNewSyncPoint (const ::std::string& strNewSyncPoint_);

    /**
     * Sets the value of the member "strNewSyncPoint".
     *
     * If the meaning of "strNewSyncPoint" isn't clear, then there should be a description here.
     *
     * @param strNewSyncPoint The value which will be set
     */
    inline void setStrNewSyncPoint (const char* strNewSyncPoint_);

    /**
     * Sets the value of the member "strNewSyncPoint".
     *
     * If the meaning of "strNewSyncPoint" isn't clear, then there should be a description here.
     *
     * @param strNewSyncPoint The value which will be set
     */
    inline void setStrNewSyncPoint (const char* value, size_t size);

    static const StartUpSyncPointReachedRequest &getDefaultInstance();

private:

    inline void set_has_strNewSyncPoint ();

    inline void clear_has_strNewSyncPoint ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _strNewSyncPoint;

};

/**
 * Inform about a new reached sync point. (CCA FID: 0x160)
 */
class StartUpSyncPointReachedResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartUpSyncPointReachedResponse ();

    /**
     * Copy constructor
     */
    inline  StartUpSyncPointReachedResponse (const StartUpSyncPointReachedResponse &rhs);

    /**
     * All fields constructor
     */
    inline  StartUpSyncPointReachedResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~StartUpSyncPointReachedResponse();

    /**
     * Assignment operator
     */
    inline StartUpSyncPointReachedResponse& operator = (const StartUpSyncPointReachedResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartUpSyncPointReachedResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartUpSyncPointReachedResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartUpSyncPointReachedResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartUpSyncPointReachedResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const StartUpSyncPointReachedResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Method to clear engineering date (All at once or a selected one).  (CCA FID: 0x1040)
 */
class ClearListRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearListRequest ();

    /**
     * Copy constructor
     */
    inline  ClearListRequest (const ClearListRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ClearListRequest (T_SPM_e32_CLEAR_LIST eList2Clear_);

    /**
     * Destructor
     */
    inline virtual  ~ClearListRequest();

    /**
     * Assignment operator
     */
    inline ClearListRequest& operator = (const ClearListRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearListRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearListRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearListRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearListRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eList2Clear"

    static const int kEList2Clear = 0;

    /**
     * Clears the field "eList2Clear".
     *
     * The field will be set to its default value. The hasEList2Clear()
     * method will return false.
     */
    inline void clearEList2Clear();

    /**
     * Checks whether the field "eList2Clear" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEList2Clear()). Otherwise it will return false.
     */
    inline bool hasEList2Clear () const;

    /**
     * Returns the value of the member "eList2Clear".
     *
     * If the meaning of "eList2Clear" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eList2Clear"
     */
    inline T_SPM_e32_CLEAR_LIST getEList2Clear () const;

    /**
     * Sets the value of the member "eList2Clear".
     *
     * If the meaning of "eList2Clear" isn't clear, then there should be a description here.
     *
     * @param eList2Clear The value which will be set
     */
    inline void setEList2Clear (T_SPM_e32_CLEAR_LIST eList2Clear_);

    static const ClearListRequest &getDefaultInstance();

private:

    inline void set_has_eList2Clear ();

    inline void clear_has_eList2Clear ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_CLEAR_LIST _eList2Clear;

};

/**
 * Method to clear engineering date (All at once or a selected one).  (CCA FID: 0x1040)
 */
class ClearListResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearListResponse ();

    /**
     * Copy constructor
     */
    inline  ClearListResponse (const ClearListResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ClearListResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ClearListResponse();

    /**
     * Assignment operator
     */
    inline ClearListResponse& operator = (const ClearListResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearListResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearListResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearListResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearListResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ClearListResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.  (CCA FID: 0x1042)
 */
class RestartSystemRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartSystemRequest ();

    /**
     * Copy constructor
     */
    inline  RestartSystemRequest (const RestartSystemRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RestartSystemRequest (T_SPM_e32_RESTART_TYPE eRestartType_);

    /**
     * Destructor
     */
    inline virtual  ~RestartSystemRequest();

    /**
     * Assignment operator
     */
    inline RestartSystemRequest& operator = (const RestartSystemRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartSystemRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartSystemRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartSystemRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartSystemRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eRestartType"

    static const int kERestartType = 0;

    /**
     * Clears the field "eRestartType".
     *
     * The field will be set to its default value. The hasERestartType()
     * method will return false.
     */
    inline void clearERestartType();

    /**
     * Checks whether the field "eRestartType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setERestartType()). Otherwise it will return false.
     */
    inline bool hasERestartType () const;

    /**
     * Returns the value of the member "eRestartType".
     *
     * If the meaning of "eRestartType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eRestartType"
     */
    inline T_SPM_e32_RESTART_TYPE getERestartType () const;

    /**
     * Sets the value of the member "eRestartType".
     *
     * If the meaning of "eRestartType" isn't clear, then there should be a description here.
     *
     * @param eRestartType The value which will be set
     */
    inline void setERestartType (T_SPM_e32_RESTART_TYPE eRestartType_);

    static const RestartSystemRequest &getDefaultInstance();

private:

    inline void set_has_eRestartType ();

    inline void clear_has_eRestartType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_RESTART_TYPE _eRestartType;

};

/**
 * Method to trigger a Restart (Reset) by application e.g. DownloadFinished, DiagEcuReset, ... . No result will be received, as a reset is done inbetween.  (CCA FID: 0x1042)
 */
class RestartSystemResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartSystemResponse ();

    /**
     * Copy constructor
     */
    inline  RestartSystemResponse (const RestartSystemResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RestartSystemResponse (T_SPM_e32_MRESULT e32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~RestartSystemResponse();

    /**
     * Assignment operator
     */
    inline RestartSystemResponse& operator = (const RestartSystemResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartSystemResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartSystemResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartSystemResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartSystemResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e32ReturnValOut"

    static const int kE32ReturnValOut = 0;

    /**
     * Clears the field "e32ReturnValOut".
     *
     * The field will be set to its default value. The hasE32ReturnValOut()
     * method will return false.
     */
    inline void clearE32ReturnValOut();

    /**
     * Checks whether the field "e32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasE32ReturnValOut () const;

    /**
     * Returns the value of the member "e32ReturnValOut".
     *
     * If the meaning of "e32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e32ReturnValOut"
     */
    inline T_SPM_e32_MRESULT getE32ReturnValOut () const;

    /**
     * Sets the value of the member "e32ReturnValOut".
     *
     * If the meaning of "e32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param e32ReturnValOut The value which will be set
     */
    inline void setE32ReturnValOut (T_SPM_e32_MRESULT e32ReturnValOut_);

    static const RestartSystemResponse &getDefaultInstance();

private:

    inline void set_has_e32ReturnValOut ();

    inline void clear_has_e32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_MRESULT _e32ReturnValOut;

};

/**
 * Method to trigger a source change by HMI. Used to change start configuration for next start-up.  (CCA FID: 0x1017)
 */
class AudioSourceChangeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioSourceChangeRequest ();

    /**
     * Copy constructor
     */
    inline  AudioSourceChangeRequest (const AudioSourceChangeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AudioSourceChangeRequest (T_SPM_e32_AUDIO_SOURCE eAudioSrc_);

    /**
     * Destructor
     */
    inline virtual  ~AudioSourceChangeRequest();

    /**
     * Assignment operator
     */
    inline AudioSourceChangeRequest& operator = (const AudioSourceChangeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioSourceChangeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioSourceChangeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioSourceChangeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioSourceChangeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eAudioSrc"

    static const int kEAudioSrc = 0;

    /**
     * Clears the field "eAudioSrc".
     *
     * The field will be set to its default value. The hasEAudioSrc()
     * method will return false.
     */
    inline void clearEAudioSrc();

    /**
     * Checks whether the field "eAudioSrc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEAudioSrc()). Otherwise it will return false.
     */
    inline bool hasEAudioSrc () const;

    /**
     * Returns the value of the member "eAudioSrc".
     *
     * If the meaning of "eAudioSrc" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eAudioSrc"
     */
    inline T_SPM_e32_AUDIO_SOURCE getEAudioSrc () const;

    /**
     * Sets the value of the member "eAudioSrc".
     *
     * If the meaning of "eAudioSrc" isn't clear, then there should be a description here.
     *
     * @param eAudioSrc The value which will be set
     */
    inline void setEAudioSrc (T_SPM_e32_AUDIO_SOURCE eAudioSrc_);

    static const AudioSourceChangeRequest &getDefaultInstance();

private:

    inline void set_has_eAudioSrc ();

    inline void clear_has_eAudioSrc ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_AUDIO_SOURCE _eAudioSrc;

};

/**
 * Method to trigger a source change by HMI. Used to change start configuration for next start-up.  (CCA FID: 0x1017)
 */
class AudioSourceChangeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioSourceChangeResponse ();

    /**
     * Copy constructor
     */
    inline  AudioSourceChangeResponse (const AudioSourceChangeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  AudioSourceChangeResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~AudioSourceChangeResponse();

    /**
     * Assignment operator
     */
    inline AudioSourceChangeResponse& operator = (const AudioSourceChangeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioSourceChangeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioSourceChangeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioSourceChangeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioSourceChangeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const AudioSourceChangeResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x413)
 */
class ChangeBluetoothStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeBluetoothStateRequest ();

    /**
     * Copy constructor
     */
    inline  ChangeBluetoothStateRequest (const ChangeBluetoothStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeBluetoothStateRequest (T_SPM_e32_BT_STATE BtState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeBluetoothStateRequest();

    /**
     * Assignment operator
     */
    inline ChangeBluetoothStateRequest& operator = (const ChangeBluetoothStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeBluetoothStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeBluetoothStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeBluetoothStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeBluetoothStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BtState"

    static const int kBtState = 0;

    /**
     * Clears the field "BtState".
     *
     * The field will be set to its default value. The hasBtState()
     * method will return false.
     */
    inline void clearBtState();

    /**
     * Checks whether the field "BtState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBtState()). Otherwise it will return false.
     */
    inline bool hasBtState () const;

    /**
     * Returns the value of the member "BtState".
     *
     * If the meaning of "BtState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "BtState"
     */
    inline T_SPM_e32_BT_STATE getBtState () const;

    /**
     * Sets the value of the member "BtState".
     *
     * If the meaning of "BtState" isn't clear, then there should be a description here.
     *
     * @param BtState The value which will be set
     */
    inline void setBtState (T_SPM_e32_BT_STATE BtState_);

    static const ChangeBluetoothStateRequest &getDefaultInstance();

private:

    inline void set_has_BtState ();

    inline void clear_has_BtState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_BT_STATE _BtState;

};

/**
 * Specific substate of the phone applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x413)
 */
class ChangeBluetoothStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeBluetoothStateResponse ();

    /**
     * Copy constructor
     */
    inline  ChangeBluetoothStateResponse (const ChangeBluetoothStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeBluetoothStateResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeBluetoothStateResponse();

    /**
     * Assignment operator
     */
    inline ChangeBluetoothStateResponse& operator = (const ChangeBluetoothStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeBluetoothStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeBluetoothStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeBluetoothStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeBluetoothStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ChangeBluetoothStateResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x414)
 */
class ChangeAudioStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeAudioStateRequest ();

    /**
     * Copy constructor
     */
    inline  ChangeAudioStateRequest (const ChangeAudioStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeAudioStateRequest (T_SPM_e32_AUDIO_STATE AudioState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeAudioStateRequest();

    /**
     * Assignment operator
     */
    inline ChangeAudioStateRequest& operator = (const ChangeAudioStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAudioStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAudioStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAudioStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAudioStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioState"

    static const int kAudioState = 0;

    /**
     * Clears the field "AudioState".
     *
     * The field will be set to its default value. The hasAudioState()
     * method will return false.
     */
    inline void clearAudioState();

    /**
     * Checks whether the field "AudioState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioState()). Otherwise it will return false.
     */
    inline bool hasAudioState () const;

    /**
     * Returns the value of the member "AudioState".
     *
     * If the meaning of "AudioState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "AudioState"
     */
    inline T_SPM_e32_AUDIO_STATE getAudioState () const;

    /**
     * Sets the value of the member "AudioState".
     *
     * If the meaning of "AudioState" isn't clear, then there should be a description here.
     *
     * @param AudioState The value which will be set
     */
    inline void setAudioState (T_SPM_e32_AUDIO_STATE AudioState_);

    static const ChangeAudioStateRequest &getDefaultInstance();

private:

    inline void set_has_AudioState ();

    inline void clear_has_AudioState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_AUDIO_STATE _AudioState;

};

/**
 * Specific substate of the audio applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x414)
 */
class ChangeAudioStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeAudioStateResponse ();

    /**
     * Copy constructor
     */
    inline  ChangeAudioStateResponse (const ChangeAudioStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeAudioStateResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeAudioStateResponse();

    /**
     * Assignment operator
     */
    inline ChangeAudioStateResponse& operator = (const ChangeAudioStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeAudioStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeAudioStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeAudioStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeAudioStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ChangeAudioStateResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x415)
 */
class ChangeSpiStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeSpiStateRequest ();

    /**
     * Copy constructor
     */
    inline  ChangeSpiStateRequest (const ChangeSpiStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeSpiStateRequest (T_SPM_e32_SPI_STATE SpiState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeSpiStateRequest();

    /**
     * Assignment operator
     */
    inline ChangeSpiStateRequest& operator = (const ChangeSpiStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeSpiStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeSpiStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeSpiStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeSpiStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpiState"

    static const int kSpiState = 0;

    /**
     * Clears the field "SpiState".
     *
     * The field will be set to its default value. The hasSpiState()
     * method will return false.
     */
    inline void clearSpiState();

    /**
     * Checks whether the field "SpiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpiState()). Otherwise it will return false.
     */
    inline bool hasSpiState () const;

    /**
     * Returns the value of the member "SpiState".
     *
     * If the meaning of "SpiState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SpiState"
     */
    inline T_SPM_e32_SPI_STATE getSpiState () const;

    /**
     * Sets the value of the member "SpiState".
     *
     * If the meaning of "SpiState" isn't clear, then there should be a description here.
     *
     * @param SpiState The value which will be set
     */
    inline void setSpiState (T_SPM_e32_SPI_STATE SpiState_);

    static const ChangeSpiStateRequest &getDefaultInstance();

private:

    inline void set_has_SpiState ();

    inline void clear_has_SpiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_SPI_STATE _SpiState;

};

/**
 * Specific substate of the SmartPhoneIntegration applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x415)
 */
class ChangeSpiStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeSpiStateResponse ();

    /**
     * Copy constructor
     */
    inline  ChangeSpiStateResponse (const ChangeSpiStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeSpiStateResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeSpiStateResponse();

    /**
     * Assignment operator
     */
    inline ChangeSpiStateResponse& operator = (const ChangeSpiStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeSpiStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeSpiStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeSpiStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeSpiStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ChangeSpiStateResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x417)
 */
class ChangeTunerStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeTunerStateRequest ();

    /**
     * Copy constructor
     */
    inline  ChangeTunerStateRequest (const ChangeTunerStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeTunerStateRequest (T_SPM_e32_TUNER_STATE TunerState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeTunerStateRequest();

    /**
     * Assignment operator
     */
    inline ChangeTunerStateRequest& operator = (const ChangeTunerStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeTunerStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeTunerStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeTunerStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeTunerStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerState"

    static const int kTunerState = 0;

    /**
     * Clears the field "TunerState".
     *
     * The field will be set to its default value. The hasTunerState()
     * method will return false.
     */
    inline void clearTunerState();

    /**
     * Checks whether the field "TunerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerState()). Otherwise it will return false.
     */
    inline bool hasTunerState () const;

    /**
     * Returns the value of the member "TunerState".
     *
     * If the meaning of "TunerState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "TunerState"
     */
    inline T_SPM_e32_TUNER_STATE getTunerState () const;

    /**
     * Sets the value of the member "TunerState".
     *
     * If the meaning of "TunerState" isn't clear, then there should be a description here.
     *
     * @param TunerState The value which will be set
     */
    inline void setTunerState (T_SPM_e32_TUNER_STATE TunerState_);

    static const ChangeTunerStateRequest &getDefaultInstance();

private:

    inline void set_has_TunerState ();

    inline void clear_has_TunerState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_TUNER_STATE _TunerState;

};

/**
 * Specific substate of the Tuner applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x417)
 */
class ChangeTunerStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeTunerStateResponse ();

    /**
     * Copy constructor
     */
    inline  ChangeTunerStateResponse (const ChangeTunerStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeTunerStateResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeTunerStateResponse();

    /**
     * Assignment operator
     */
    inline ChangeTunerStateResponse& operator = (const ChangeTunerStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeTunerStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeTunerStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeTunerStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeTunerStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ChangeTunerStateResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x419)
 */
class ChangeWifiStateRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeWifiStateRequest ();

    /**
     * Copy constructor
     */
    inline  ChangeWifiStateRequest (const ChangeWifiStateRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeWifiStateRequest (T_SPM_e32_WIFI_STATE WiFiState_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeWifiStateRequest();

    /**
     * Assignment operator
     */
    inline ChangeWifiStateRequest& operator = (const ChangeWifiStateRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiStateRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiStateRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiStateRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiStateRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WiFiState"

    static const int kWiFiState = 0;

    /**
     * Clears the field "WiFiState".
     *
     * The field will be set to its default value. The hasWiFiState()
     * method will return false.
     */
    inline void clearWiFiState();

    /**
     * Checks whether the field "WiFiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWiFiState()). Otherwise it will return false.
     */
    inline bool hasWiFiState () const;

    /**
     * Returns the value of the member "WiFiState".
     *
     * If the meaning of "WiFiState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "WiFiState"
     */
    inline T_SPM_e32_WIFI_STATE getWiFiState () const;

    /**
     * Sets the value of the member "WiFiState".
     *
     * If the meaning of "WiFiState" isn't clear, then there should be a description here.
     *
     * @param WiFiState The value which will be set
     */
    inline void setWiFiState (T_SPM_e32_WIFI_STATE WiFiState_);

    static const ChangeWifiStateRequest &getDefaultInstance();

private:

    inline void set_has_WiFiState ();

    inline void clear_has_WiFiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_WIFI_STATE _WiFiState;

};

/**
 * Specific substate of the connectivity applications should be changed. LCM will trigger a state change if necessary. This will be project specific.  (CCA FID: 0x419)
 */
class ChangeWifiStateResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeWifiStateResponse ();

    /**
     * Copy constructor
     */
    inline  ChangeWifiStateResponse (const ChangeWifiStateResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeWifiStateResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeWifiStateResponse();

    /**
     * Assignment operator
     */
    inline ChangeWifiStateResponse& operator = (const ChangeWifiStateResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeWifiStateResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeWifiStateResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeWifiStateResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeWifiStateResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ChangeWifiStateResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * (CCA FID: 0x0004)
 */
class ShutdownAndTerminateCcaAppsRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownAndTerminateCcaAppsRequest ();

    /**
     * Copy constructor
     */
    inline  ShutdownAndTerminateCcaAppsRequest (const ShutdownAndTerminateCcaAppsRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ShutdownAndTerminateCcaAppsRequest (const T_SPM_AppIdList& tAppIdList_);

    /**
     * Destructor
     */
    inline virtual  ~ShutdownAndTerminateCcaAppsRequest();

    /**
     * Assignment operator
     */
    inline ShutdownAndTerminateCcaAppsRequest& operator = (const ShutdownAndTerminateCcaAppsRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownAndTerminateCcaAppsRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownAndTerminateCcaAppsRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownAndTerminateCcaAppsRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownAndTerminateCcaAppsRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tAppIdList"

    static const int kTAppIdList = 0;

    /**
     * Clears the field "tAppIdList".
     *
     * The field will be set to its default value. The hasTAppIdList()
     * method will return false.
     */
    inline void clearTAppIdList();

    /**
     * Checks whether the field "tAppIdList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTAppIdList()). Otherwise it will return false.
     */
    inline bool hasTAppIdList () const;

    /**
     * Returns the value of the member "tAppIdList".
     *
     * If the meaning of "tAppIdList" isn't clear, then there should be a description here.
     *
     * @return The value of the field "tAppIdList"
     */
    inline const T_SPM_AppIdList& getTAppIdList () const;

    /**
     * Retrieves the value of the field "tAppIdList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tAppIdList".
     */
    inline T_SPM_AppIdList& getTAppIdListMutable ();

    /**
     * Sets the value of the member "tAppIdList".
     *
     * If the meaning of "tAppIdList" isn't clear, then there should be a description here.
     *
     * @param tAppIdList The value which will be set
     */
    inline void setTAppIdList (const T_SPM_AppIdList& tAppIdList_);

    static const ShutdownAndTerminateCcaAppsRequest &getDefaultInstance();

private:

    inline void set_has_tAppIdList ();

    inline void clear_has_tAppIdList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_AppIdList _tAppIdList;

};

/**
 * (CCA FID: 0x0004)
 */
class ShutdownAndTerminateCcaAppsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ShutdownAndTerminateCcaAppsResponse ();

    /**
     * Copy constructor
     */
    inline  ShutdownAndTerminateCcaAppsResponse (const ShutdownAndTerminateCcaAppsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ShutdownAndTerminateCcaAppsResponse (int32 s32ResOut_);

    /**
     * Destructor
     */
    inline virtual  ~ShutdownAndTerminateCcaAppsResponse();

    /**
     * Assignment operator
     */
    inline ShutdownAndTerminateCcaAppsResponse& operator = (const ShutdownAndTerminateCcaAppsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ShutdownAndTerminateCcaAppsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ShutdownAndTerminateCcaAppsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ShutdownAndTerminateCcaAppsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ShutdownAndTerminateCcaAppsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ResOut"

    static const int kS32ResOut = 0;

    /**
     * Clears the field "s32ResOut".
     *
     * The field will be set to its default value. The hasS32ResOut()
     * method will return false.
     */
    inline void clearS32ResOut();

    /**
     * Checks whether the field "s32ResOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ResOut()). Otherwise it will return false.
     */
    inline bool hasS32ResOut () const;

    /**
     * Returns the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ResOut"
     */
    inline int32 getS32ResOut () const;

    /**
     * Sets the value of the member "s32ResOut".
     *
     * If the meaning of "s32ResOut" isn't clear, then there should be a description here.
     *
     * @param s32ResOut The value which will be set
     */
    inline void setS32ResOut (int32 s32ResOut_);

    static const ShutdownAndTerminateCcaAppsResponse &getDefaultInstance();

private:

    inline void set_has_s32ResOut ();

    inline void clear_has_s32ResOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ResOut;

};

/**
 * (CCA FID: 0x89)
 */
class SetFactorySettingsNewRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewRequest ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewRequest (const SetFactorySettingsNewRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewRequest (T_e8_DiaglogDefsetType DefSetStateGroup_, T_e8_DefSetMode DefSetStateMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewRequest();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewRequest& operator = (const SetFactorySettingsNewRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * If the meaning of "DefSetStateGroup" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline T_e8_DiaglogDefsetType getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * If the meaning of "DefSetStateGroup" isn't clear, then there should be a description here.
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (T_e8_DiaglogDefsetType DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * If the meaning of "DefSetStateMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * If the meaning of "DefSetStateMode" isn't clear, then there should be a description here.
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (T_e8_DefSetMode DefSetStateMode_);

    static const SetFactorySettingsNewRequest &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_DiaglogDefsetType _DefSetStateGroup;

    T_e8_DefSetMode _DefSetStateMode;

};

/**
 * (CCA FID: 0x89)
 */
class SetFactorySettingsNewResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewResponse ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewResponse (const SetFactorySettingsNewResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewResponse (T_e8_DiaglogDefsetType DefSetStateGroupOut_, T_e8_DefSetMode DefSetStateModeOut_, bool DefSetStateSuccessfulOut_, uint16 DefSetStateFirstDifferentParameterIdOut_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewResponse();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewResponse& operator = (const SetFactorySettingsNewResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroupOut"

    static const int kDefSetStateGroupOut = 0;

    /**
     * Clears the field "DefSetStateGroupOut".
     *
     * The field will be set to its default value. The hasDefSetStateGroupOut()
     * method will return false.
     */
    inline void clearDefSetStateGroupOut();

    /**
     * Checks whether the field "DefSetStateGroupOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroupOut()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroupOut () const;

    /**
     * Returns the value of the member "DefSetStateGroupOut".
     *
     * If the meaning of "DefSetStateGroupOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DefSetStateGroupOut"
     */
    inline T_e8_DiaglogDefsetType getDefSetStateGroupOut () const;

    /**
     * Sets the value of the member "DefSetStateGroupOut".
     *
     * If the meaning of "DefSetStateGroupOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateGroupOut The value which will be set
     */
    inline void setDefSetStateGroupOut (T_e8_DiaglogDefsetType DefSetStateGroupOut_);

    // API of field "DefSetStateModeOut"

    static const int kDefSetStateModeOut = 1;

    /**
     * Clears the field "DefSetStateModeOut".
     *
     * The field will be set to its default value. The hasDefSetStateModeOut()
     * method will return false.
     */
    inline void clearDefSetStateModeOut();

    /**
     * Checks whether the field "DefSetStateModeOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateModeOut()). Otherwise it will return false.
     */
    inline bool hasDefSetStateModeOut () const;

    /**
     * Returns the value of the member "DefSetStateModeOut".
     *
     * If the meaning of "DefSetStateModeOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DefSetStateModeOut"
     */
    inline T_e8_DefSetMode getDefSetStateModeOut () const;

    /**
     * Sets the value of the member "DefSetStateModeOut".
     *
     * If the meaning of "DefSetStateModeOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateModeOut The value which will be set
     */
    inline void setDefSetStateModeOut (T_e8_DefSetMode DefSetStateModeOut_);

    // API of field "DefSetStateSuccessfulOut"

    static const int kDefSetStateSuccessfulOut = 2;

    /**
     * Clears the field "DefSetStateSuccessfulOut".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessfulOut()
     * method will return false.
     */
    inline void clearDefSetStateSuccessfulOut();

    /**
     * Checks whether the field "DefSetStateSuccessfulOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessfulOut()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessfulOut () const;

    /**
     * Returns the value of the member "DefSetStateSuccessfulOut".
     *
     * If the meaning of "DefSetStateSuccessfulOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DefSetStateSuccessfulOut"
     */
    inline bool getDefSetStateSuccessfulOut () const;

    /**
     * Sets the value of the member "DefSetStateSuccessfulOut".
     *
     * If the meaning of "DefSetStateSuccessfulOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateSuccessfulOut The value which will be set
     */
    inline void setDefSetStateSuccessfulOut (bool DefSetStateSuccessfulOut_);

    // API of field "DefSetStateFirstDifferentParameterIdOut"

    static const int kDefSetStateFirstDifferentParameterIdOut = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterIdOut".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterIdOut()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterIdOut();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterIdOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterIdOut()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterIdOut () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterIdOut".
     *
     * If the meaning of "DefSetStateFirstDifferentParameterIdOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterIdOut"
     */
    inline uint16 getDefSetStateFirstDifferentParameterIdOut () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterIdOut".
     *
     * If the meaning of "DefSetStateFirstDifferentParameterIdOut" isn't clear, then there should be a description here.
     *
     * @param DefSetStateFirstDifferentParameterIdOut The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterIdOut (uint16 DefSetStateFirstDifferentParameterIdOut_);

    static const SetFactorySettingsNewResponse &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroupOut ();

    inline void clear_has_DefSetStateGroupOut ();

    inline void set_has_DefSetStateModeOut ();

    inline void clear_has_DefSetStateModeOut ();

    inline void set_has_DefSetStateSuccessfulOut ();

    inline void clear_has_DefSetStateSuccessfulOut ();

    inline void set_has_DefSetStateFirstDifferentParameterIdOut ();

    inline void clear_has_DefSetStateFirstDifferentParameterIdOut ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_DiaglogDefsetType _DefSetStateGroupOut;

    T_e8_DefSetMode _DefSetStateModeOut;

    bool _DefSetStateSuccessfulOut;

    uint16 _DefSetStateFirstDifferentParameterIdOut;

};

/**
 * Clear Vehicle Identification Number if the EOL value is set or the internal manufacturersenablecounter is unequal to 0.  (CCA FID: 0x0522)
 */
class ClearVINResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearVINResponse ();

    /**
     * Copy constructor
     */
    inline  ClearVINResponse (const ClearVINResponse &rhs);

    /**
     * All fields constructor
     */
    inline  ClearVINResponse (uint32 ResultOut_);

    /**
     * Destructor
     */
    inline virtual  ~ClearVINResponse();

    /**
     * Assignment operator
     */
    inline ClearVINResponse& operator = (const ClearVINResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearVINResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearVINResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearVINResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearVINResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResultOut"

    static const int kResultOut = 0;

    /**
     * Clears the field "ResultOut".
     *
     * The field will be set to its default value. The hasResultOut()
     * method will return false.
     */
    inline void clearResultOut();

    /**
     * Checks whether the field "ResultOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultOut()). Otherwise it will return false.
     */
    inline bool hasResultOut () const;

    /**
     * Returns the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ResultOut"
     */
    inline uint32 getResultOut () const;

    /**
     * Sets the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param ResultOut The value which will be set
     */
    inline void setResultOut (uint32 ResultOut_);

    static const ClearVINResponse &getDefaultInstance();

private:

    inline void set_has_ResultOut ();

    inline void clear_has_ResultOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResultOut;

};

/**
 * This function prepares the system for download. All components that are not needed are unloaded.   (CCA FID: 0x0900)
 */
class PrepareDownloadRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrepareDownloadRequest ();

    /**
     * Copy constructor
     */
    inline  PrepareDownloadRequest (const PrepareDownloadRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PrepareDownloadRequest (uint32 Configuration_, bool SuspendBusShutdown_, uint32 Timeout_);

    /**
     * Destructor
     */
    inline virtual  ~PrepareDownloadRequest();

    /**
     * Assignment operator
     */
    inline PrepareDownloadRequest& operator = (const PrepareDownloadRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareDownloadRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareDownloadRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareDownloadRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareDownloadRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * If the meaning of "Configuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Configuration"
     */
    inline uint32 getConfiguration () const;

    /**
     * Sets the value of the member "Configuration".
     *
     * If the meaning of "Configuration" isn't clear, then there should be a description here.
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (uint32 Configuration_);

    // API of field "SuspendBusShutdown"

    static const int kSuspendBusShutdown = 1;

    /**
     * Clears the field "SuspendBusShutdown".
     *
     * The field will be set to its default value. The hasSuspendBusShutdown()
     * method will return false.
     */
    inline void clearSuspendBusShutdown();

    /**
     * Checks whether the field "SuspendBusShutdown" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSuspendBusShutdown()). Otherwise it will return false.
     */
    inline bool hasSuspendBusShutdown () const;

    /**
     * Returns the value of the member "SuspendBusShutdown".
     *
     * If the meaning of "SuspendBusShutdown" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SuspendBusShutdown"
     */
    inline bool getSuspendBusShutdown () const;

    /**
     * Sets the value of the member "SuspendBusShutdown".
     *
     * If the meaning of "SuspendBusShutdown" isn't clear, then there should be a description here.
     *
     * @param SuspendBusShutdown The value which will be set
     */
    inline void setSuspendBusShutdown (bool SuspendBusShutdown_);

    // API of field "Timeout"

    static const int kTimeout = 2;

    /**
     * Clears the field "Timeout".
     *
     * The field will be set to its default value. The hasTimeout()
     * method will return false.
     */
    inline void clearTimeout();

    /**
     * Checks whether the field "Timeout" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeout()). Otherwise it will return false.
     */
    inline bool hasTimeout () const;

    /**
     * Returns the value of the member "Timeout".
     *
     * If the meaning of "Timeout" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Timeout"
     */
    inline uint32 getTimeout () const;

    /**
     * Sets the value of the member "Timeout".
     *
     * If the meaning of "Timeout" isn't clear, then there should be a description here.
     *
     * @param Timeout The value which will be set
     */
    inline void setTimeout (uint32 Timeout_);

    static const PrepareDownloadRequest &getDefaultInstance();

private:

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    inline void set_has_SuspendBusShutdown ();

    inline void clear_has_SuspendBusShutdown ();

    inline void set_has_Timeout ();

    inline void clear_has_Timeout ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _Configuration;

    bool _SuspendBusShutdown;

    uint32 _Timeout;

};

/**
 * This function prepares the system for download. All components that are not needed are unloaded.   (CCA FID: 0x0900)
 */
class PrepareDownloadResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrepareDownloadResponse ();

    /**
     * Copy constructor
     */
    inline  PrepareDownloadResponse (const PrepareDownloadResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PrepareDownloadResponse (uint32 ResultOut_);

    /**
     * Destructor
     */
    inline virtual  ~PrepareDownloadResponse();

    /**
     * Assignment operator
     */
    inline PrepareDownloadResponse& operator = (const PrepareDownloadResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrepareDownloadResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrepareDownloadResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrepareDownloadResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrepareDownloadResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResultOut"

    static const int kResultOut = 0;

    /**
     * Clears the field "ResultOut".
     *
     * The field will be set to its default value. The hasResultOut()
     * method will return false.
     */
    inline void clearResultOut();

    /**
     * Checks whether the field "ResultOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultOut()). Otherwise it will return false.
     */
    inline bool hasResultOut () const;

    /**
     * Returns the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ResultOut"
     */
    inline uint32 getResultOut () const;

    /**
     * Sets the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param ResultOut The value which will be set
     */
    inline void setResultOut (uint32 ResultOut_);

    static const PrepareDownloadResponse &getDefaultInstance();

private:

    inline void set_has_ResultOut ();

    inline void clear_has_ResultOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResultOut;

};

/**
 * This function is used to end a download session where internal data was not changed so that a leave from download state is without risks.   (CCA FID: 0x0901)
 */
class EndDownloadResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EndDownloadResponse ();

    /**
     * Copy constructor
     */
    inline  EndDownloadResponse (const EndDownloadResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EndDownloadResponse (uint32 ResultOut_);

    /**
     * Destructor
     */
    inline virtual  ~EndDownloadResponse();

    /**
     * Assignment operator
     */
    inline EndDownloadResponse& operator = (const EndDownloadResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EndDownloadResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EndDownloadResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EndDownloadResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EndDownloadResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResultOut"

    static const int kResultOut = 0;

    /**
     * Clears the field "ResultOut".
     *
     * The field will be set to its default value. The hasResultOut()
     * method will return false.
     */
    inline void clearResultOut();

    /**
     * Checks whether the field "ResultOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultOut()). Otherwise it will return false.
     */
    inline bool hasResultOut () const;

    /**
     * Returns the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ResultOut"
     */
    inline uint32 getResultOut () const;

    /**
     * Sets the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param ResultOut The value which will be set
     */
    inline void setResultOut (uint32 ResultOut_);

    static const EndDownloadResponse &getDefaultInstance();

private:

    inline void set_has_ResultOut ();

    inline void clear_has_ResultOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResultOut;

};

/**
 * (CCA FID: 0x0902)
 */
class SetOnConfigurationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOnConfigurationRequest ();

    /**
     * Copy constructor
     */
    inline  SetOnConfigurationRequest (const SetOnConfigurationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetOnConfigurationRequest (uint32 Configuration_);

    /**
     * Destructor
     */
    inline virtual  ~SetOnConfigurationRequest();

    /**
     * Assignment operator
     */
    inline SetOnConfigurationRequest& operator = (const SetOnConfigurationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOnConfigurationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOnConfigurationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOnConfigurationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOnConfigurationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * If the meaning of "Configuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Configuration"
     */
    inline uint32 getConfiguration () const;

    /**
     * Sets the value of the member "Configuration".
     *
     * If the meaning of "Configuration" isn't clear, then there should be a description here.
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (uint32 Configuration_);

    static const SetOnConfigurationRequest &getDefaultInstance();

private:

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Configuration;

};

/**
 * (CCA FID: 0x0902)
 */
class SetOnConfigurationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetOnConfigurationResponse ();

    /**
     * Copy constructor
     */
    inline  SetOnConfigurationResponse (const SetOnConfigurationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetOnConfigurationResponse (uint32 ResultOut_);

    /**
     * Destructor
     */
    inline virtual  ~SetOnConfigurationResponse();

    /**
     * Assignment operator
     */
    inline SetOnConfigurationResponse& operator = (const SetOnConfigurationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetOnConfigurationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetOnConfigurationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetOnConfigurationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetOnConfigurationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResultOut"

    static const int kResultOut = 0;

    /**
     * Clears the field "ResultOut".
     *
     * The field will be set to its default value. The hasResultOut()
     * method will return false.
     */
    inline void clearResultOut();

    /**
     * Checks whether the field "ResultOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultOut()). Otherwise it will return false.
     */
    inline bool hasResultOut () const;

    /**
     * Returns the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ResultOut"
     */
    inline uint32 getResultOut () const;

    /**
     * Sets the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param ResultOut The value which will be set
     */
    inline void setResultOut (uint32 ResultOut_);

    static const SetOnConfigurationResponse &getDefaultInstance();

private:

    inline void set_has_ResultOut ();

    inline void clear_has_ResultOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResultOut;

};

/**
 * (CCA FID: 0x0903)
 */
class SetProcessConfigurationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProcessConfigurationRequest ();

    /**
     * Copy constructor
     */
    inline  SetProcessConfigurationRequest (const SetProcessConfigurationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetProcessConfigurationRequest (uint32 Configuration_);

    /**
     * Destructor
     */
    inline virtual  ~SetProcessConfigurationRequest();

    /**
     * Assignment operator
     */
    inline SetProcessConfigurationRequest& operator = (const SetProcessConfigurationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProcessConfigurationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProcessConfigurationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProcessConfigurationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProcessConfigurationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Configuration"

    static const int kConfiguration = 0;

    /**
     * Clears the field "Configuration".
     *
     * The field will be set to its default value. The hasConfiguration()
     * method will return false.
     */
    inline void clearConfiguration();

    /**
     * Checks whether the field "Configuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConfiguration()). Otherwise it will return false.
     */
    inline bool hasConfiguration () const;

    /**
     * Returns the value of the member "Configuration".
     *
     * If the meaning of "Configuration" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Configuration"
     */
    inline uint32 getConfiguration () const;

    /**
     * Sets the value of the member "Configuration".
     *
     * If the meaning of "Configuration" isn't clear, then there should be a description here.
     *
     * @param Configuration The value which will be set
     */
    inline void setConfiguration (uint32 Configuration_);

    static const SetProcessConfigurationRequest &getDefaultInstance();

private:

    inline void set_has_Configuration ();

    inline void clear_has_Configuration ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Configuration;

};

/**
 * (CCA FID: 0x0903)
 */
class SetProcessConfigurationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetProcessConfigurationResponse ();

    /**
     * Copy constructor
     */
    inline  SetProcessConfigurationResponse (const SetProcessConfigurationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  SetProcessConfigurationResponse (uint32 ResultOut_);

    /**
     * Destructor
     */
    inline virtual  ~SetProcessConfigurationResponse();

    /**
     * Assignment operator
     */
    inline SetProcessConfigurationResponse& operator = (const SetProcessConfigurationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetProcessConfigurationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetProcessConfigurationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetProcessConfigurationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetProcessConfigurationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResultOut"

    static const int kResultOut = 0;

    /**
     * Clears the field "ResultOut".
     *
     * The field will be set to its default value. The hasResultOut()
     * method will return false.
     */
    inline void clearResultOut();

    /**
     * Checks whether the field "ResultOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResultOut()). Otherwise it will return false.
     */
    inline bool hasResultOut () const;

    /**
     * Returns the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ResultOut"
     */
    inline uint32 getResultOut () const;

    /**
     * Sets the value of the member "ResultOut".
     *
     * If the meaning of "ResultOut" isn't clear, then there should be a description here.
     *
     * @param ResultOut The value which will be set
     */
    inline void setResultOut (uint32 ResultOut_);

    static const SetProcessConfigurationResponse &getDefaultInstance();

private:

    inline void set_has_ResultOut ();

    inline void clear_has_ResultOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ResultOut;

};

/**
 * Method to trigger a demute by HMI.  (CCA FID: 0x1016)
 */
class EntertainDeMuteResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainDeMuteResponse ();

    /**
     * Copy constructor
     */
    inline  EntertainDeMuteResponse (const EntertainDeMuteResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainDeMuteResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainDeMuteResponse();

    /**
     * Assignment operator
     */
    inline EntertainDeMuteResponse& operator = (const EntertainDeMuteResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainDeMuteResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainDeMuteResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainDeMuteResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainDeMuteResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const EntertainDeMuteResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Method to trigger a mute by HMI.  (CCA FID: 0x1015)
 */
class EntertainMuteRequestResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EntertainMuteRequestResponse ();

    /**
     * Copy constructor
     */
    inline  EntertainMuteRequestResponse (const EntertainMuteRequestResponse &rhs);

    /**
     * All fields constructor
     */
    inline  EntertainMuteRequestResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~EntertainMuteRequestResponse();

    /**
     * Assignment operator
     */
    inline EntertainMuteRequestResponse& operator = (const EntertainMuteRequestResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EntertainMuteRequestResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EntertainMuteRequestResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EntertainMuteRequestResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EntertainMuteRequestResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const EntertainMuteRequestResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Method to trigger a mute by HMI.  (CCA FID: 0x1025)
 */
class WelcomeAudioActivationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeAudioActivationRequest ();

    /**
     * Copy constructor
     */
    inline  WelcomeAudioActivationRequest (const WelcomeAudioActivationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  WelcomeAudioActivationRequest (bool bActivateState_);

    /**
     * Destructor
     */
    inline virtual  ~WelcomeAudioActivationRequest();

    /**
     * Assignment operator
     */
    inline WelcomeAudioActivationRequest& operator = (const WelcomeAudioActivationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeAudioActivationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeAudioActivationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeAudioActivationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeAudioActivationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bActivateState"

    static const int kBActivateState = 0;

    /**
     * Clears the field "bActivateState".
     *
     * The field will be set to its default value. The hasBActivateState()
     * method will return false.
     */
    inline void clearBActivateState();

    /**
     * Checks whether the field "bActivateState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActivateState()). Otherwise it will return false.
     */
    inline bool hasBActivateState () const;

    /**
     * Returns the value of the member "bActivateState".
     *
     * If the meaning of "bActivateState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "bActivateState"
     */
    inline bool getBActivateState () const;

    /**
     * Sets the value of the member "bActivateState".
     *
     * If the meaning of "bActivateState" isn't clear, then there should be a description here.
     *
     * @param bActivateState The value which will be set
     */
    inline void setBActivateState (bool bActivateState_);

    static const WelcomeAudioActivationRequest &getDefaultInstance();

private:

    inline void set_has_bActivateState ();

    inline void clear_has_bActivateState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bActivateState;

};

/**
 * Method to trigger a mute by HMI.  (CCA FID: 0x1025)
 */
class WelcomeAudioActivationResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WelcomeAudioActivationResponse ();

    /**
     * Copy constructor
     */
    inline  WelcomeAudioActivationResponse (const WelcomeAudioActivationResponse &rhs);

    /**
     * All fields constructor
     */
    inline  WelcomeAudioActivationResponse (int32 s32ReturnValOut_);

    /**
     * Destructor
     */
    inline virtual  ~WelcomeAudioActivationResponse();

    /**
     * Assignment operator
     */
    inline WelcomeAudioActivationResponse& operator = (const WelcomeAudioActivationResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WelcomeAudioActivationResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WelcomeAudioActivationResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WelcomeAudioActivationResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WelcomeAudioActivationResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32ReturnValOut"

    static const int kS32ReturnValOut = 0;

    /**
     * Clears the field "s32ReturnValOut".
     *
     * The field will be set to its default value. The hasS32ReturnValOut()
     * method will return false.
     */
    inline void clearS32ReturnValOut();

    /**
     * Checks whether the field "s32ReturnValOut" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ReturnValOut()). Otherwise it will return false.
     */
    inline bool hasS32ReturnValOut () const;

    /**
     * Returns the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @return The value of the field "s32ReturnValOut"
     */
    inline int32 getS32ReturnValOut () const;

    /**
     * Sets the value of the member "s32ReturnValOut".
     *
     * If the meaning of "s32ReturnValOut" isn't clear, then there should be a description here.
     *
     * @param s32ReturnValOut The value which will be set
     */
    inline void setS32ReturnValOut (int32 s32ReturnValOut_);

    static const WelcomeAudioActivationResponse &getDefaultInstance();

private:

    inline void set_has_s32ReturnValOut ();

    inline void clear_has_s32ReturnValOut ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _s32ReturnValOut;

};

/**
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
 */
class SystemStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateUpdate ();

    /**
     * Copy constructor
     */
    inline  SystemStateUpdate (const SystemStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateUpdate (T_SPM_e32_SYSTEM_STATES SystemState_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateUpdate();

    /**
     * Assignment operator
     */
    inline SystemStateUpdate& operator = (const SystemStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemState"

    static const int kSystemState = 0;

    /**
     * Clears the field "SystemState".
     *
     * The field will be set to its default value. The hasSystemState()
     * method will return false.
     */
    inline void clearSystemState();

    /**
     * Checks whether the field "SystemState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemState()). Otherwise it will return false.
     */
    inline bool hasSystemState () const;

    /**
     * Returns the value of the member "SystemState".
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     *
     * @return The value of the field "SystemState"
     */
    inline T_SPM_e32_SYSTEM_STATES getSystemState () const;

    /**
     * Sets the value of the member "SystemState".
     *
     * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
     *
     * @param SystemState The value which will be set
     */
    inline void setSystemState (T_SPM_e32_SYSTEM_STATES SystemState_);

    static const SystemStateUpdate &getDefaultInstance();

private:

    inline void set_has_SystemState ();

    inline void clear_has_SystemState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_SYSTEM_STATES _SystemState;

};

/**
 * Informs about system state changes. Update is send when a new system state has reached (all applications have acknowledged requested application state).  (CCA FID: 0x0001)
 */
class SystemStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateRegister ();

    /**
     * Copy constructor
     */
    inline  SystemStateRegister (const SystemStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SystemStateRegister();

    /**
     * Assignment operator
     */
    inline SystemStateRegister& operator = (const SystemStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SystemStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
 */
class DownloadLockStatesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStatesUpdate ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStatesUpdate (const DownloadLockStatesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DownloadLockStatesUpdate (const ::std::vector< T_SPM_RestrictedDlLock >& DownloadLockStates_);

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStatesUpdate();

    /**
     * Assignment operator
     */
    inline DownloadLockStatesUpdate& operator = (const DownloadLockStatesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStatesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStatesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStatesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStatesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DownloadLockStates"

    static const int kDownloadLockStates = 0;

    /**
     * Clears the field "DownloadLockStates".
     *
     * The field will be set to its default value. The hasDownloadLockStates()
     * method will return false.
     */
    inline void clearDownloadLockStates();

    /**
     * Checks whether the field "DownloadLockStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadLockStates()). Otherwise it will return false.
     */
    inline bool hasDownloadLockStates () const;

    /**
     * Returns the value of the member "DownloadLockStates".
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     *
     * @return The value of the field "DownloadLockStates"
     */
    inline const ::std::vector< T_SPM_RestrictedDlLock >& getDownloadLockStates () const;

    /**
     * Retrieves the value of the field "DownloadLockStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DownloadLockStates".
     */
    inline ::std::vector< T_SPM_RestrictedDlLock >& getDownloadLockStatesMutable ();

    /**
     * Sets the value of the member "DownloadLockStates".
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
     *
     * @param DownloadLockStates The value which will be set
     */
    inline void setDownloadLockStates (const ::std::vector< T_SPM_RestrictedDlLock >& DownloadLockStates_);

    static const DownloadLockStatesUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_RestrictedDlLock >& getT_SPM_RestrictedDlLockList_DefaultInstance ();

    inline void set_has_DownloadLockStates ();

    inline void clear_has_DownloadLockStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_RestrictedDlLock > _DownloadLockStates;

};

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! !!! replaced by UpdateLockStates !!! Current state of the DownloadLock. Will return a list of the current CCA application ID of the owner of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1002)
 */
class DownloadLockStatesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DownloadLockStatesRegister ();

    /**
     * Copy constructor
     */
    inline  DownloadLockStatesRegister (const DownloadLockStatesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DownloadLockStatesRegister();

    /**
     * Assignment operator
     */
    inline DownloadLockStatesRegister& operator = (const DownloadLockStatesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DownloadLockStatesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DownloadLockStatesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DownloadLockStatesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DownloadLockStatesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DownloadLockStatesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
 */
class UpdateLockStatesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockStatesUpdate ();

    /**
     * Copy constructor
     */
    inline  UpdateLockStatesUpdate (const UpdateLockStatesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UpdateLockStatesUpdate (const ::std::vector< T_SPM_UpdateLockState >& UpdateLockStates_);

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockStatesUpdate();

    /**
     * Assignment operator
     */
    inline UpdateLockStatesUpdate& operator = (const UpdateLockStatesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockStatesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockStatesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockStatesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockStatesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UpdateLockStates"

    static const int kUpdateLockStates = 0;

    /**
     * Clears the field "UpdateLockStates".
     *
     * The field will be set to its default value. The hasUpdateLockStates()
     * method will return false.
     */
    inline void clearUpdateLockStates();

    /**
     * Checks whether the field "UpdateLockStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateLockStates()). Otherwise it will return false.
     */
    inline bool hasUpdateLockStates () const;

    /**
     * Returns the value of the member "UpdateLockStates".
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     *
     * @return The value of the field "UpdateLockStates"
     */
    inline const ::std::vector< T_SPM_UpdateLockState >& getUpdateLockStates () const;

    /**
     * Retrieves the value of the field "UpdateLockStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UpdateLockStates".
     */
    inline ::std::vector< T_SPM_UpdateLockState >& getUpdateLockStatesMutable ();

    /**
     * Sets the value of the member "UpdateLockStates".
     *
     * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
     *
     * @param UpdateLockStates The value which will be set
     */
    inline void setUpdateLockStates (const ::std::vector< T_SPM_UpdateLockState >& UpdateLockStates_);

    static const UpdateLockStatesUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_UpdateLockState >& getT_SPM_UpdateLockStateList_DefaultInstance ();

    inline void set_has_UpdateLockStates ();

    inline void clear_has_UpdateLockStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_UpdateLockState > _UpdateLockStates;

};

/**
 * Current state of the Locks. Will return a list of the current CCA application ID of the owner and users of a specific lock area or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free.  (CCA FID: 0x1004)
 */
class UpdateLockStatesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UpdateLockStatesRegister ();

    /**
     * Copy constructor
     */
    inline  UpdateLockStatesRegister (const UpdateLockStatesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UpdateLockStatesRegister();

    /**
     * Assignment operator
     */
    inline UpdateLockStatesRegister& operator = (const UpdateLockStatesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UpdateLockStatesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UpdateLockStatesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UpdateLockStatesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UpdateLockStatesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UpdateLockStatesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of all active trigger. (CCA FID: 0x110f)
 */
class ActiveOnOffTriggerUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveOnOffTriggerUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveOnOffTriggerUpdate (const ActiveOnOffTriggerUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveOnOffTriggerUpdate (const ::std::vector< T_SPM_e32_SubStateType >& ActiveOnOffTrigger_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveOnOffTriggerUpdate();

    /**
     * Assignment operator
     */
    inline ActiveOnOffTriggerUpdate& operator = (const ActiveOnOffTriggerUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveOnOffTriggerUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveOnOffTriggerUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveOnOffTriggerUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveOnOffTriggerUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveOnOffTrigger"

    static const int kActiveOnOffTrigger = 0;

    /**
     * Clears the field "ActiveOnOffTrigger".
     *
     * The field will be set to its default value. The hasActiveOnOffTrigger()
     * method will return false.
     */
    inline void clearActiveOnOffTrigger();

    /**
     * Checks whether the field "ActiveOnOffTrigger" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveOnOffTrigger()). Otherwise it will return false.
     */
    inline bool hasActiveOnOffTrigger () const;

    /**
     * Returns the value of the member "ActiveOnOffTrigger".
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     *
     * @return The value of the field "ActiveOnOffTrigger"
     */
    inline const ::std::vector< T_SPM_e32_SubStateType >& getActiveOnOffTrigger () const;

    /**
     * Retrieves the value of the field "ActiveOnOffTrigger" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActiveOnOffTrigger".
     */
    inline ::std::vector< T_SPM_e32_SubStateType >& getActiveOnOffTriggerMutable ();

    /**
     * Sets the value of the member "ActiveOnOffTrigger".
     *
     * A list of all active trigger. (CCA FID: 0x110f)
     *
     * @param ActiveOnOffTrigger The value which will be set
     */
    inline void setActiveOnOffTrigger (const ::std::vector< T_SPM_e32_SubStateType >& ActiveOnOffTrigger_);

    static const ActiveOnOffTriggerUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_e32_SubStateType >& getT_SPM_e32_SubStateTypeList_DefaultInstance ();

    inline void set_has_ActiveOnOffTrigger ();

    inline void clear_has_ActiveOnOffTrigger ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_e32_SubStateType > _ActiveOnOffTrigger;

};

/**
 * A list of all active trigger. (CCA FID: 0x110f)
 */
class ActiveOnOffTriggerRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveOnOffTriggerRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveOnOffTriggerRegister (const ActiveOnOffTriggerRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveOnOffTriggerRegister();

    /**
     * Assignment operator
     */
    inline ActiveOnOffTriggerRegister& operator = (const ActiveOnOffTriggerRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveOnOffTriggerRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveOnOffTriggerRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveOnOffTriggerRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveOnOffTriggerRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveOnOffTriggerRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x000f)
 */
class SubStatesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubStatesUpdate ();

    /**
     * Copy constructor
     */
    inline  SubStatesUpdate (const SubStatesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SubStatesUpdate (const TSubStates& SubStates_);

    /**
     * Destructor
     */
    inline virtual  ~SubStatesUpdate();

    /**
     * Assignment operator
     */
    inline SubStatesUpdate& operator = (const SubStatesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubStatesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubStatesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubStatesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubStatesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SubStates"

    static const int kSubStates = 0;

    /**
     * Clears the field "SubStates".
     *
     * The field will be set to its default value. The hasSubStates()
     * method will return false.
     */
    inline void clearSubStates();

    /**
     * Checks whether the field "SubStates" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSubStates()). Otherwise it will return false.
     */
    inline bool hasSubStates () const;

    /**
     * Returns the value of the member "SubStates".
     *
     * (CCA FID: 0x000f)
     *
     * @return The value of the field "SubStates"
     */
    inline const TSubStates& getSubStates () const;

    /**
     * Retrieves the value of the field "SubStates" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SubStates".
     */
    inline TSubStates& getSubStatesMutable ();

    /**
     * Sets the value of the member "SubStates".
     *
     * (CCA FID: 0x000f)
     *
     * @param SubStates The value which will be set
     */
    inline void setSubStates (const TSubStates& SubStates_);

    static const SubStatesUpdate &getDefaultInstance();

private:

    inline void set_has_SubStates ();

    inline void clear_has_SubStates ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TSubStates _SubStates;

};

/**
 * (CCA FID: 0x000f)
 */
class SubStatesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SubStatesRegister ();

    /**
     * Copy constructor
     */
    inline  SubStatesRegister (const SubStatesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SubStatesRegister();

    /**
     * Assignment operator
     */
    inline SubStatesRegister& operator = (const SubStatesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SubStatesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SubStatesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SubStatesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SubStatesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SubStatesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
 */
class HistoryTriggerUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HistoryTriggerUpdate ();

    /**
     * Copy constructor
     */
    inline  HistoryTriggerUpdate (const HistoryTriggerUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HistoryTriggerUpdate (const ::std::vector< T_SPM_HistoryTrigger >& HistoryTrigger_);

    /**
     * Destructor
     */
    inline virtual  ~HistoryTriggerUpdate();

    /**
     * Assignment operator
     */
    inline HistoryTriggerUpdate& operator = (const HistoryTriggerUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HistoryTriggerUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HistoryTriggerUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HistoryTriggerUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HistoryTriggerUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HistoryTrigger"

    static const int kHistoryTrigger = 0;

    /**
     * Clears the field "HistoryTrigger".
     *
     * The field will be set to its default value. The hasHistoryTrigger()
     * method will return false.
     */
    inline void clearHistoryTrigger();

    /**
     * Checks whether the field "HistoryTrigger" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHistoryTrigger()). Otherwise it will return false.
     */
    inline bool hasHistoryTrigger () const;

    /**
     * Returns the value of the member "HistoryTrigger".
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     *
     * @return The value of the field "HistoryTrigger"
     */
    inline const ::std::vector< T_SPM_HistoryTrigger >& getHistoryTrigger () const;

    /**
     * Retrieves the value of the field "HistoryTrigger" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HistoryTrigger".
     */
    inline ::std::vector< T_SPM_HistoryTrigger >& getHistoryTriggerMutable ();

    /**
     * Sets the value of the member "HistoryTrigger".
     *
     * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
     *
     * @param HistoryTrigger The value which will be set
     */
    inline void setHistoryTrigger (const ::std::vector< T_SPM_HistoryTrigger >& HistoryTrigger_);

    static const HistoryTriggerUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_HistoryTrigger >& getT_SPM_HistoryTriggerList_DefaultInstance ();

    inline void set_has_HistoryTrigger ();

    inline void clear_has_HistoryTrigger ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_HistoryTrigger > _HistoryTrigger;

};

/**
 * A list of triggered states e.g. eject or insert. If trigger is seen once it will never be cleared from the list. (CCA FID: 0x20)
 */
class HistoryTriggerRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HistoryTriggerRegister ();

    /**
     * Copy constructor
     */
    inline  HistoryTriggerRegister (const HistoryTriggerRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HistoryTriggerRegister();

    /**
     * Assignment operator
     */
    inline HistoryTriggerRegister& operator = (const HistoryTriggerRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HistoryTriggerRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HistoryTriggerRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HistoryTriggerRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HistoryTriggerRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HistoryTriggerRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Insert key state. (CCA FID: 0x21)
 */
class InsertStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InsertStateUpdate ();

    /**
     * Copy constructor
     */
    inline  InsertStateUpdate (const InsertStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InsertStateUpdate (T_SPM_e32_CD_INSERT_STATE InsertState_);

    /**
     * Destructor
     */
    inline virtual  ~InsertStateUpdate();

    /**
     * Assignment operator
     */
    inline InsertStateUpdate& operator = (const InsertStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InsertStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InsertStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InsertStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InsertStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InsertState"

    static const int kInsertState = 0;

    /**
     * Clears the field "InsertState".
     *
     * The field will be set to its default value. The hasInsertState()
     * method will return false.
     */
    inline void clearInsertState();

    /**
     * Checks whether the field "InsertState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInsertState()). Otherwise it will return false.
     */
    inline bool hasInsertState () const;

    /**
     * Returns the value of the member "InsertState".
     *
     * Insert key state. (CCA FID: 0x21)
     *
     * @return The value of the field "InsertState"
     */
    inline T_SPM_e32_CD_INSERT_STATE getInsertState () const;

    /**
     * Sets the value of the member "InsertState".
     *
     * Insert key state. (CCA FID: 0x21)
     *
     * @param InsertState The value which will be set
     */
    inline void setInsertState (T_SPM_e32_CD_INSERT_STATE InsertState_);

    static const InsertStateUpdate &getDefaultInstance();

private:

    inline void set_has_InsertState ();

    inline void clear_has_InsertState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_CD_INSERT_STATE _InsertState;

};

/**
 * Insert key state. (CCA FID: 0x21)
 */
class InsertStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InsertStateRegister ();

    /**
     * Copy constructor
     */
    inline  InsertStateRegister (const InsertStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InsertStateRegister();

    /**
     * Assignment operator
     */
    inline InsertStateRegister& operator = (const InsertStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InsertStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InsertStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InsertStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InsertStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InsertStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Media Eject key state. (CCA FID: 0x22)
 */
class MediaEjectStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaEjectStateUpdate ();

    /**
     * Copy constructor
     */
    inline  MediaEjectStateUpdate (const MediaEjectStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MediaEjectStateUpdate (T_SPM_e32_MEDIA_EJECT_STATE MediaEjectState_);

    /**
     * Destructor
     */
    inline virtual  ~MediaEjectStateUpdate();

    /**
     * Assignment operator
     */
    inline MediaEjectStateUpdate& operator = (const MediaEjectStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaEjectStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaEjectStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaEjectStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaEjectStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MediaEjectState"

    static const int kMediaEjectState = 0;

    /**
     * Clears the field "MediaEjectState".
     *
     * The field will be set to its default value. The hasMediaEjectState()
     * method will return false.
     */
    inline void clearMediaEjectState();

    /**
     * Checks whether the field "MediaEjectState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMediaEjectState()). Otherwise it will return false.
     */
    inline bool hasMediaEjectState () const;

    /**
     * Returns the value of the member "MediaEjectState".
     *
     * Media Eject key state. (CCA FID: 0x22)
     *
     * @return The value of the field "MediaEjectState"
     */
    inline T_SPM_e32_MEDIA_EJECT_STATE getMediaEjectState () const;

    /**
     * Sets the value of the member "MediaEjectState".
     *
     * Media Eject key state. (CCA FID: 0x22)
     *
     * @param MediaEjectState The value which will be set
     */
    inline void setMediaEjectState (T_SPM_e32_MEDIA_EJECT_STATE MediaEjectState_);

    static const MediaEjectStateUpdate &getDefaultInstance();

private:

    inline void set_has_MediaEjectState ();

    inline void clear_has_MediaEjectState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_MEDIA_EJECT_STATE _MediaEjectState;

};

/**
 * Media Eject key state. (CCA FID: 0x22)
 */
class MediaEjectStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MediaEjectStateRegister ();

    /**
     * Copy constructor
     */
    inline  MediaEjectStateRegister (const MediaEjectStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MediaEjectStateRegister();

    /**
     * Assignment operator
     */
    inline MediaEjectStateRegister& operator = (const MediaEjectStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MediaEjectStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MediaEjectStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MediaEjectStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MediaEjectStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MediaEjectStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * State of the hard-wired phone line. (CCA FID: 0x23)
 */
class PhoneMuteStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneMuteStateUpdate ();

    /**
     * Copy constructor
     */
    inline  PhoneMuteStateUpdate (const PhoneMuteStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PhoneMuteStateUpdate (T_SPM_e32_PHONE_MUTE_STATE PhoneMuteState_);

    /**
     * Destructor
     */
    inline virtual  ~PhoneMuteStateUpdate();

    /**
     * Assignment operator
     */
    inline PhoneMuteStateUpdate& operator = (const PhoneMuteStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneMuteStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneMuteStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneMuteStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneMuteStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PhoneMuteState"

    static const int kPhoneMuteState = 0;

    /**
     * Clears the field "PhoneMuteState".
     *
     * The field will be set to its default value. The hasPhoneMuteState()
     * method will return false.
     */
    inline void clearPhoneMuteState();

    /**
     * Checks whether the field "PhoneMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneMuteState()). Otherwise it will return false.
     */
    inline bool hasPhoneMuteState () const;

    /**
     * Returns the value of the member "PhoneMuteState".
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     *
     * @return The value of the field "PhoneMuteState"
     */
    inline T_SPM_e32_PHONE_MUTE_STATE getPhoneMuteState () const;

    /**
     * Sets the value of the member "PhoneMuteState".
     *
     * State of the hard-wired phone line. (CCA FID: 0x23)
     *
     * @param PhoneMuteState The value which will be set
     */
    inline void setPhoneMuteState (T_SPM_e32_PHONE_MUTE_STATE PhoneMuteState_);

    static const PhoneMuteStateUpdate &getDefaultInstance();

private:

    inline void set_has_PhoneMuteState ();

    inline void clear_has_PhoneMuteState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_PHONE_MUTE_STATE _PhoneMuteState;

};

/**
 * State of the hard-wired phone line. (CCA FID: 0x23)
 */
class PhoneMuteStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PhoneMuteStateRegister ();

    /**
     * Copy constructor
     */
    inline  PhoneMuteStateRegister (const PhoneMuteStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PhoneMuteStateRegister();

    /**
     * Assignment operator
     */
    inline PhoneMuteStateRegister& operator = (const PhoneMuteStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PhoneMuteStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PhoneMuteStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PhoneMuteStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PhoneMuteStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PhoneMuteStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Media Eject key state. (CCA FID: 0x25)
 */
class OnTipperStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnTipperStateUpdate ();

    /**
     * Copy constructor
     */
    inline  OnTipperStateUpdate (const OnTipperStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  OnTipperStateUpdate (T_SPM_e32_KEY_STATE OnTipperState_);

    /**
     * Destructor
     */
    inline virtual  ~OnTipperStateUpdate();

    /**
     * Assignment operator
     */
    inline OnTipperStateUpdate& operator = (const OnTipperStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnTipperStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnTipperStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnTipperStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnTipperStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnTipperState"

    static const int kOnTipperState = 0;

    /**
     * Clears the field "OnTipperState".
     *
     * The field will be set to its default value. The hasOnTipperState()
     * method will return false.
     */
    inline void clearOnTipperState();

    /**
     * Checks whether the field "OnTipperState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnTipperState()). Otherwise it will return false.
     */
    inline bool hasOnTipperState () const;

    /**
     * Returns the value of the member "OnTipperState".
     *
     * Media Eject key state. (CCA FID: 0x25)
     *
     * @return The value of the field "OnTipperState"
     */
    inline T_SPM_e32_KEY_STATE getOnTipperState () const;

    /**
     * Sets the value of the member "OnTipperState".
     *
     * Media Eject key state. (CCA FID: 0x25)
     *
     * @param OnTipperState The value which will be set
     */
    inline void setOnTipperState (T_SPM_e32_KEY_STATE OnTipperState_);

    static const OnTipperStateUpdate &getDefaultInstance();

private:

    inline void set_has_OnTipperState ();

    inline void clear_has_OnTipperState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_KEY_STATE _OnTipperState;

};

/**
 * Media Eject key state. (CCA FID: 0x25)
 */
class OnTipperStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnTipperStateRegister ();

    /**
     * Copy constructor
     */
    inline  OnTipperStateRegister (const OnTipperStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~OnTipperStateRegister();

    /**
     * Assignment operator
     */
    inline OnTipperStateRegister& operator = (const OnTipperStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnTipperStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnTipperStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnTipperStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnTipperStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const OnTipperStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
 */
class IgnitionCyclesUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionCyclesUpdate ();

    /**
     * Copy constructor
     */
    inline  IgnitionCyclesUpdate (const IgnitionCyclesUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IgnitionCyclesUpdate (uint32 IgnitionCycles_);

    /**
     * Destructor
     */
    inline virtual  ~IgnitionCyclesUpdate();

    /**
     * Assignment operator
     */
    inline IgnitionCyclesUpdate& operator = (const IgnitionCyclesUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionCyclesUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionCyclesUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionCyclesUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionCyclesUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnitionCycles"

    static const int kIgnitionCycles = 0;

    /**
     * Clears the field "IgnitionCycles".
     *
     * The field will be set to its default value. The hasIgnitionCycles()
     * method will return false.
     */
    inline void clearIgnitionCycles();

    /**
     * Checks whether the field "IgnitionCycles" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnitionCycles()). Otherwise it will return false.
     */
    inline bool hasIgnitionCycles () const;

    /**
     * Returns the value of the member "IgnitionCycles".
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     *
     * @return The value of the field "IgnitionCycles"
     */
    inline uint32 getIgnitionCycles () const;

    /**
     * Sets the value of the member "IgnitionCycles".
     *
     * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
     *
     * @param IgnitionCycles The value which will be set
     */
    inline void setIgnitionCycles (uint32 IgnitionCycles_);

    static const IgnitionCyclesUpdate &getDefaultInstance();

private:

    inline void set_has_IgnitionCycles ();

    inline void clear_has_IgnitionCycles ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _IgnitionCycles;

};

/**
 * Current number of ignition cycles seen after start-up. This value is incremented if another ignition cycle is seen. (CCA FID: 0x0203)
 */
class IgnitionCyclesRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionCyclesRegister ();

    /**
     * Copy constructor
     */
    inline  IgnitionCyclesRegister (const IgnitionCyclesRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IgnitionCyclesRegister();

    /**
     * Assignment operator
     */
    inline IgnitionCyclesRegister& operator = (const IgnitionCyclesRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionCyclesRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionCyclesRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionCyclesRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionCyclesRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IgnitionCyclesRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x0204)
 */
class SysPwrModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysPwrModeUpdate ();

    /**
     * Copy constructor
     */
    inline  SysPwrModeUpdate (const SysPwrModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SysPwrModeUpdate (T_SPM_e32_SYSPWRMODE SysPwrMode_);

    /**
     * Destructor
     */
    inline virtual  ~SysPwrModeUpdate();

    /**
     * Assignment operator
     */
    inline SysPwrModeUpdate& operator = (const SysPwrModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysPwrModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysPwrModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysPwrModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysPwrModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SysPwrMode"

    static const int kSysPwrMode = 0;

    /**
     * Clears the field "SysPwrMode".
     *
     * The field will be set to its default value. The hasSysPwrMode()
     * method will return false.
     */
    inline void clearSysPwrMode();

    /**
     * Checks whether the field "SysPwrMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysPwrMode()). Otherwise it will return false.
     */
    inline bool hasSysPwrMode () const;

    /**
     * Returns the value of the member "SysPwrMode".
     *
     * (CCA FID: 0x0204)
     *
     * @return The value of the field "SysPwrMode"
     */
    inline T_SPM_e32_SYSPWRMODE getSysPwrMode () const;

    /**
     * Sets the value of the member "SysPwrMode".
     *
     * (CCA FID: 0x0204)
     *
     * @param SysPwrMode The value which will be set
     */
    inline void setSysPwrMode (T_SPM_e32_SYSPWRMODE SysPwrMode_);

    static const SysPwrModeUpdate &getDefaultInstance();

private:

    inline void set_has_SysPwrMode ();

    inline void clear_has_SysPwrMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_SYSPWRMODE _SysPwrMode;

};

/**
 * (CCA FID: 0x0204)
 */
class SysPwrModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysPwrModeRegister ();

    /**
     * Copy constructor
     */
    inline  SysPwrModeRegister (const SysPwrModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SysPwrModeRegister();

    /**
     * Assignment operator
     */
    inline SysPwrModeRegister& operator = (const SysPwrModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysPwrModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysPwrModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysPwrModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysPwrModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SysPwrModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x0205)
 */
class SysPwrSaveModeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysPwrSaveModeUpdate ();

    /**
     * Copy constructor
     */
    inline  SysPwrSaveModeUpdate (const SysPwrSaveModeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SysPwrSaveModeUpdate (const T_SPM_b32_SYSPWRSAVEMODE& SysPwrSaveMode_);

    /**
     * Destructor
     */
    inline virtual  ~SysPwrSaveModeUpdate();

    /**
     * Assignment operator
     */
    inline SysPwrSaveModeUpdate& operator = (const SysPwrSaveModeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysPwrSaveModeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysPwrSaveModeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysPwrSaveModeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysPwrSaveModeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SysPwrSaveMode"

    static const int kSysPwrSaveMode = 0;

    /**
     * Clears the field "SysPwrSaveMode".
     *
     * The field will be set to its default value. The hasSysPwrSaveMode()
     * method will return false.
     */
    inline void clearSysPwrSaveMode();

    /**
     * Checks whether the field "SysPwrSaveMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSysPwrSaveMode()). Otherwise it will return false.
     */
    inline bool hasSysPwrSaveMode () const;

    /**
     * Returns the value of the member "SysPwrSaveMode".
     *
     * (CCA FID: 0x0205)
     *
     * @return The value of the field "SysPwrSaveMode"
     */
    inline const T_SPM_b32_SYSPWRSAVEMODE& getSysPwrSaveMode () const;

    /**
     * Retrieves the value of the field "SysPwrSaveMode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SysPwrSaveMode".
     */
    inline T_SPM_b32_SYSPWRSAVEMODE& getSysPwrSaveModeMutable ();

    /**
     * Sets the value of the member "SysPwrSaveMode".
     *
     * (CCA FID: 0x0205)
     *
     * @param SysPwrSaveMode The value which will be set
     */
    inline void setSysPwrSaveMode (const T_SPM_b32_SYSPWRSAVEMODE& SysPwrSaveMode_);

    static const SysPwrSaveModeUpdate &getDefaultInstance();

private:

    inline void set_has_SysPwrSaveMode ();

    inline void clear_has_SysPwrSaveMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_b32_SYSPWRSAVEMODE _SysPwrSaveMode;

};

/**
 * (CCA FID: 0x0205)
 */
class SysPwrSaveModeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SysPwrSaveModeRegister ();

    /**
     * Copy constructor
     */
    inline  SysPwrSaveModeRegister (const SysPwrSaveModeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SysPwrSaveModeRegister();

    /**
     * Assignment operator
     */
    inline SysPwrSaveModeRegister& operator = (const SysPwrSaveModeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SysPwrSaveModeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SysPwrSaveModeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SysPwrSaveModeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SysPwrSaveModeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SysPwrSaveModeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
 */
class MapDownloadLockStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapDownloadLockStateUpdate ();

    /**
     * Copy constructor
     */
    inline  MapDownloadLockStateUpdate (const MapDownloadLockStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  MapDownloadLockStateUpdate (uint16 MapDownloadLockState_);

    /**
     * Destructor
     */
    inline virtual  ~MapDownloadLockStateUpdate();

    /**
     * Assignment operator
     */
    inline MapDownloadLockStateUpdate& operator = (const MapDownloadLockStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapDownloadLockStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapDownloadLockStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapDownloadLockStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapDownloadLockStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "MapDownloadLockState"

    static const int kMapDownloadLockState = 0;

    /**
     * Clears the field "MapDownloadLockState".
     *
     * The field will be set to its default value. The hasMapDownloadLockState()
     * method will return false.
     */
    inline void clearMapDownloadLockState();

    /**
     * Checks whether the field "MapDownloadLockState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMapDownloadLockState()). Otherwise it will return false.
     */
    inline bool hasMapDownloadLockState () const;

    /**
     * Returns the value of the member "MapDownloadLockState".
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     *
     * @return The value of the field "MapDownloadLockState"
     */
    inline uint16 getMapDownloadLockState () const;

    /**
     * Sets the value of the member "MapDownloadLockState".
     *
     * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
     *
     * @param MapDownloadLockState The value which will be set
     */
    inline void setMapDownloadLockState (uint16 MapDownloadLockState_);

    static const MapDownloadLockStateUpdate &getDefaultInstance();

private:

    inline void set_has_MapDownloadLockState ();

    inline void clear_has_MapDownloadLockState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _MapDownloadLockState;

};

/**
 * Current state of the MapDownloadLock. Will return the current CCA application ID of the owner or "AMT_C_U16_APPID_INVALID (0xFFFF)" if free. (CCA FID: 0x206)
 */
class MapDownloadLockStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MapDownloadLockStateRegister ();

    /**
     * Copy constructor
     */
    inline  MapDownloadLockStateRegister (const MapDownloadLockStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~MapDownloadLockStateRegister();

    /**
     * Assignment operator
     */
    inline MapDownloadLockStateRegister& operator = (const MapDownloadLockStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MapDownloadLockStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MapDownloadLockStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MapDownloadLockStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MapDownloadLockStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const MapDownloadLockStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x05)
 */
class StandbyTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StandbyTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  StandbyTimeUpdate (const StandbyTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StandbyTimeUpdate (uint32 StandbyTime_);

    /**
     * Destructor
     */
    inline virtual  ~StandbyTimeUpdate();

    /**
     * Assignment operator
     */
    inline StandbyTimeUpdate& operator = (const StandbyTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StandbyTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StandbyTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StandbyTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StandbyTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StandbyTime"

    static const int kStandbyTime = 0;

    /**
     * Clears the field "StandbyTime".
     *
     * The field will be set to its default value. The hasStandbyTime()
     * method will return false.
     */
    inline void clearStandbyTime();

    /**
     * Checks whether the field "StandbyTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStandbyTime()). Otherwise it will return false.
     */
    inline bool hasStandbyTime () const;

    /**
     * Returns the value of the member "StandbyTime".
     *
     * (CCA FID: 0x05)
     *
     * @return The value of the field "StandbyTime"
     */
    inline uint32 getStandbyTime () const;

    /**
     * Sets the value of the member "StandbyTime".
     *
     * (CCA FID: 0x05)
     *
     * @param StandbyTime The value which will be set
     */
    inline void setStandbyTime (uint32 StandbyTime_);

    static const StandbyTimeUpdate &getDefaultInstance();

private:

    inline void set_has_StandbyTime ();

    inline void clear_has_StandbyTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _StandbyTime;

};

/**
 * (CCA FID: 0x05)
 */
class StandbyTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StandbyTimeRegister ();

    /**
     * Copy constructor
     */
    inline  StandbyTimeRegister (const StandbyTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StandbyTimeRegister();

    /**
     * Assignment operator
     */
    inline StandbyTimeRegister& operator = (const StandbyTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StandbyTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StandbyTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StandbyTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StandbyTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StandbyTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
 */
class PersitentStandbyTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PersitentStandbyTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  PersitentStandbyTimeUpdate (const PersitentStandbyTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  PersitentStandbyTimeUpdate (uint32 PersitentStandbyTime_);

    /**
     * Destructor
     */
    inline virtual  ~PersitentStandbyTimeUpdate();

    /**
     * Assignment operator
     */
    inline PersitentStandbyTimeUpdate& operator = (const PersitentStandbyTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PersitentStandbyTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PersitentStandbyTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PersitentStandbyTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PersitentStandbyTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PersitentStandbyTime"

    static const int kPersitentStandbyTime = 0;

    /**
     * Clears the field "PersitentStandbyTime".
     *
     * The field will be set to its default value. The hasPersitentStandbyTime()
     * method will return false.
     */
    inline void clearPersitentStandbyTime();

    /**
     * Checks whether the field "PersitentStandbyTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPersitentStandbyTime()). Otherwise it will return false.
     */
    inline bool hasPersitentStandbyTime () const;

    /**
     * Returns the value of the member "PersitentStandbyTime".
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     *
     * @return The value of the field "PersitentStandbyTime"
     */
    inline uint32 getPersitentStandbyTime () const;

    /**
     * Sets the value of the member "PersitentStandbyTime".
     *
     * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
     *
     * @param PersitentStandbyTime The value which will be set
     */
    inline void setPersitentStandbyTime (uint32 PersitentStandbyTime_);

    static const PersitentStandbyTimeUpdate &getDefaultInstance();

private:

    inline void set_has_PersitentStandbyTime ();

    inline void clear_has_PersitentStandbyTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _PersitentStandbyTime;

};

/**
 * Set standby time persistent. Must be set before entering the standby state.  (CCA FID: 0x06)
 */
class PersitentStandbyTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PersitentStandbyTimeRegister ();

    /**
     * Copy constructor
     */
    inline  PersitentStandbyTimeRegister (const PersitentStandbyTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~PersitentStandbyTimeRegister();

    /**
     * Assignment operator
     */
    inline PersitentStandbyTimeRegister& operator = (const PersitentStandbyTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PersitentStandbyTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PersitentStandbyTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PersitentStandbyTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PersitentStandbyTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const PersitentStandbyTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
 */
class IgnitionOffTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionOffTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  IgnitionOffTimeUpdate (const IgnitionOffTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  IgnitionOffTimeUpdate (uint32 IgnitionOffTime_);

    /**
     * Destructor
     */
    inline virtual  ~IgnitionOffTimeUpdate();

    /**
     * Assignment operator
     */
    inline IgnitionOffTimeUpdate& operator = (const IgnitionOffTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionOffTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionOffTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionOffTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionOffTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IgnitionOffTime"

    static const int kIgnitionOffTime = 0;

    /**
     * Clears the field "IgnitionOffTime".
     *
     * The field will be set to its default value. The hasIgnitionOffTime()
     * method will return false.
     */
    inline void clearIgnitionOffTime();

    /**
     * Checks whether the field "IgnitionOffTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIgnitionOffTime()). Otherwise it will return false.
     */
    inline bool hasIgnitionOffTime () const;

    /**
     * Returns the value of the member "IgnitionOffTime".
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     *
     * @return The value of the field "IgnitionOffTime"
     */
    inline uint32 getIgnitionOffTime () const;

    /**
     * Sets the value of the member "IgnitionOffTime".
     *
     * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
     *
     * @param IgnitionOffTime The value which will be set
     */
    inline void setIgnitionOffTime (uint32 IgnitionOffTime_);

    static const IgnitionOffTimeUpdate &getDefaultInstance();

private:

    inline void set_has_IgnitionOffTime ();

    inline void clear_has_IgnitionOffTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _IgnitionOffTime;

};

/**
 * Set ignition off time. A restart is necessary. (CCA FID: 0x08)
 */
class IgnitionOffTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IgnitionOffTimeRegister ();

    /**
     * Copy constructor
     */
    inline  IgnitionOffTimeRegister (const IgnitionOffTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~IgnitionOffTimeRegister();

    /**
     * Assignment operator
     */
    inline IgnitionOffTimeRegister& operator = (const IgnitionOffTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IgnitionOffTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IgnitionOffTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IgnitionOffTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IgnitionOffTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const IgnitionOffTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set door open time. (CCA FID: 0x0a)
 */
class DoorOpenTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoorOpenTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  DoorOpenTimeUpdate (const DoorOpenTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DoorOpenTimeUpdate (uint32 DoorOpenTime_);

    /**
     * Destructor
     */
    inline virtual  ~DoorOpenTimeUpdate();

    /**
     * Assignment operator
     */
    inline DoorOpenTimeUpdate& operator = (const DoorOpenTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoorOpenTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoorOpenTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoorOpenTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoorOpenTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DoorOpenTime"

    static const int kDoorOpenTime = 0;

    /**
     * Clears the field "DoorOpenTime".
     *
     * The field will be set to its default value. The hasDoorOpenTime()
     * method will return false.
     */
    inline void clearDoorOpenTime();

    /**
     * Checks whether the field "DoorOpenTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDoorOpenTime()). Otherwise it will return false.
     */
    inline bool hasDoorOpenTime () const;

    /**
     * Returns the value of the member "DoorOpenTime".
     *
     * Set door open time. (CCA FID: 0x0a)
     *
     * @return The value of the field "DoorOpenTime"
     */
    inline uint32 getDoorOpenTime () const;

    /**
     * Sets the value of the member "DoorOpenTime".
     *
     * Set door open time. (CCA FID: 0x0a)
     *
     * @param DoorOpenTime The value which will be set
     */
    inline void setDoorOpenTime (uint32 DoorOpenTime_);

    static const DoorOpenTimeUpdate &getDefaultInstance();

private:

    inline void set_has_DoorOpenTime ();

    inline void clear_has_DoorOpenTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DoorOpenTime;

};

/**
 * Set door open time. (CCA FID: 0x0a)
 */
class DoorOpenTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DoorOpenTimeRegister ();

    /**
     * Copy constructor
     */
    inline  DoorOpenTimeRegister (const DoorOpenTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DoorOpenTimeRegister();

    /**
     * Assignment operator
     */
    inline DoorOpenTimeRegister& operator = (const DoorOpenTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DoorOpenTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DoorOpenTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DoorOpenTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DoorOpenTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DoorOpenTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set clock display time. (CCA FID: 0x0b)
 */
class ClockDisplayTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClockDisplayTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  ClockDisplayTimeUpdate (const ClockDisplayTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ClockDisplayTimeUpdate (uint32 ClockDisplayTime_);

    /**
     * Destructor
     */
    inline virtual  ~ClockDisplayTimeUpdate();

    /**
     * Assignment operator
     */
    inline ClockDisplayTimeUpdate& operator = (const ClockDisplayTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClockDisplayTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClockDisplayTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClockDisplayTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClockDisplayTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClockDisplayTime"

    static const int kClockDisplayTime = 0;

    /**
     * Clears the field "ClockDisplayTime".
     *
     * The field will be set to its default value. The hasClockDisplayTime()
     * method will return false.
     */
    inline void clearClockDisplayTime();

    /**
     * Checks whether the field "ClockDisplayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClockDisplayTime()). Otherwise it will return false.
     */
    inline bool hasClockDisplayTime () const;

    /**
     * Returns the value of the member "ClockDisplayTime".
     *
     * Set clock display time. (CCA FID: 0x0b)
     *
     * @return The value of the field "ClockDisplayTime"
     */
    inline uint32 getClockDisplayTime () const;

    /**
     * Sets the value of the member "ClockDisplayTime".
     *
     * Set clock display time. (CCA FID: 0x0b)
     *
     * @param ClockDisplayTime The value which will be set
     */
    inline void setClockDisplayTime (uint32 ClockDisplayTime_);

    static const ClockDisplayTimeUpdate &getDefaultInstance();

private:

    inline void set_has_ClockDisplayTime ();

    inline void clear_has_ClockDisplayTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _ClockDisplayTime;

};

/**
 * Set clock display time. (CCA FID: 0x0b)
 */
class ClockDisplayTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClockDisplayTimeRegister ();

    /**
     * Copy constructor
     */
    inline  ClockDisplayTimeRegister (const ClockDisplayTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ClockDisplayTimeRegister();

    /**
     * Assignment operator
     */
    inline ClockDisplayTimeRegister& operator = (const ClockDisplayTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClockDisplayTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClockDisplayTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClockDisplayTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClockDisplayTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ClockDisplayTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
 */
class SystemStateTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  SystemStateTimeUpdate (const SystemStateTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SystemStateTimeUpdate (const TSystemStateTime& SystemStateTime_);

    /**
     * Destructor
     */
    inline virtual  ~SystemStateTimeUpdate();

    /**
     * Assignment operator
     */
    inline SystemStateTimeUpdate& operator = (const SystemStateTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemStateTime"

    static const int kSystemStateTime = 0;

    /**
     * Clears the field "SystemStateTime".
     *
     * The field will be set to its default value. The hasSystemStateTime()
     * method will return false.
     */
    inline void clearSystemStateTime();

    /**
     * Checks whether the field "SystemStateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemStateTime()). Otherwise it will return false.
     */
    inline bool hasSystemStateTime () const;

    /**
     * Returns the value of the member "SystemStateTime".
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     *
     * @return The value of the field "SystemStateTime"
     */
    inline const TSystemStateTime& getSystemStateTime () const;

    /**
     * Retrieves the value of the field "SystemStateTime" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SystemStateTime".
     */
    inline TSystemStateTime& getSystemStateTimeMutable ();

    /**
     * Sets the value of the member "SystemStateTime".
     *
     * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
     *
     * @param SystemStateTime The value which will be set
     */
    inline void setSystemStateTime (const TSystemStateTime& SystemStateTime_);

    static const SystemStateTimeUpdate &getDefaultInstance();

private:

    inline void set_has_SystemStateTime ();

    inline void clear_has_SystemStateTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TSystemStateTime _SystemStateTime;

};

/**
 * Set the time-out value for a system state. This time describes the max. time a system state is valid without re-trigger. (CCA FID: 0xe8)
 */
class SystemStateTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemStateTimeRegister ();

    /**
     * Copy constructor
     */
    inline  SystemStateTimeRegister (const SystemStateTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SystemStateTimeRegister();

    /**
     * Assignment operator
     */
    inline SystemStateTimeRegister& operator = (const SystemStateTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemStateTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemStateTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemStateTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemStateTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SystemStateTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
 */
class ProcessListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProcessListUpdate ();

    /**
     * Copy constructor
     */
    inline  ProcessListUpdate (const ProcessListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ProcessListUpdate (const T_SPM_ProcessInfo& ProcessList_);

    /**
     * Destructor
     */
    inline virtual  ~ProcessListUpdate();

    /**
     * Assignment operator
     */
    inline ProcessListUpdate& operator = (const ProcessListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProcessListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProcessListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProcessListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProcessListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProcessList"

    static const int kProcessList = 0;

    /**
     * Clears the field "ProcessList".
     *
     * The field will be set to its default value. The hasProcessList()
     * method will return false.
     */
    inline void clearProcessList();

    /**
     * Checks whether the field "ProcessList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProcessList()). Otherwise it will return false.
     */
    inline bool hasProcessList () const;

    /**
     * Returns the value of the member "ProcessList".
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     *
     * @return The value of the field "ProcessList"
     */
    inline const T_SPM_ProcessInfo& getProcessList () const;

    /**
     * Retrieves the value of the field "ProcessList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ProcessList".
     */
    inline T_SPM_ProcessInfo& getProcessListMutable ();

    /**
     * Sets the value of the member "ProcessList".
     *
     * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
     *
     * @param ProcessList The value which will be set
     */
    inline void setProcessList (const T_SPM_ProcessInfo& ProcessList_);

    static const ProcessListUpdate &getDefaultInstance();

private:

    inline void set_has_ProcessList ();

    inline void clear_has_ProcessList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_ProcessInfo _ProcessList;

};

/**
 * Informs about all processes configured in start configuration of SPM. (CCA FID: 0x1ff)
 */
class ProcessListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProcessListRegister ();

    /**
     * Copy constructor
     */
    inline  ProcessListRegister (const ProcessListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ProcessListRegister();

    /**
     * Assignment operator
     */
    inline ProcessListRegister& operator = (const ProcessListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProcessListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProcessListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProcessListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProcessListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ProcessListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x70)
 */
class WakeupReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  WakeupReasonUpdate (const WakeupReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupReasonUpdate (T_SPM_e32_WAKEUP_REASON WakeupReason_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupReasonUpdate();

    /**
     * Assignment operator
     */
    inline WakeupReasonUpdate& operator = (const WakeupReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeupReason"

    static const int kWakeupReason = 0;

    /**
     * Clears the field "WakeupReason".
     *
     * The field will be set to its default value. The hasWakeupReason()
     * method will return false.
     */
    inline void clearWakeupReason();

    /**
     * Checks whether the field "WakeupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeupReason()). Otherwise it will return false.
     */
    inline bool hasWakeupReason () const;

    /**
     * Returns the value of the member "WakeupReason".
     *
     * (CCA FID: 0x70)
     *
     * @return The value of the field "WakeupReason"
     */
    inline T_SPM_e32_WAKEUP_REASON getWakeupReason () const;

    /**
     * Sets the value of the member "WakeupReason".
     *
     * (CCA FID: 0x70)
     *
     * @param WakeupReason The value which will be set
     */
    inline void setWakeupReason (T_SPM_e32_WAKEUP_REASON WakeupReason_);

    static const WakeupReasonUpdate &getDefaultInstance();

private:

    inline void set_has_WakeupReason ();

    inline void clear_has_WakeupReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_WAKEUP_REASON _WakeupReason;

};

/**
 * (CCA FID: 0x70)
 */
class WakeupReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupReasonRegister ();

    /**
     * Copy constructor
     */
    inline  WakeupReasonRegister (const WakeupReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WakeupReasonRegister();

    /**
     * Assignment operator
     */
    inline WakeupReasonRegister& operator = (const WakeupReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WakeupReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x71)
 */
class StartupReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  StartupReasonUpdate (const StartupReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StartupReasonUpdate (T_SPM_e32_STARTUP_REASON StartupReason_);

    /**
     * Destructor
     */
    inline virtual  ~StartupReasonUpdate();

    /**
     * Assignment operator
     */
    inline StartupReasonUpdate& operator = (const StartupReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupReason"

    static const int kStartupReason = 0;

    /**
     * Clears the field "StartupReason".
     *
     * The field will be set to its default value. The hasStartupReason()
     * method will return false.
     */
    inline void clearStartupReason();

    /**
     * Checks whether the field "StartupReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupReason()). Otherwise it will return false.
     */
    inline bool hasStartupReason () const;

    /**
     * Returns the value of the member "StartupReason".
     *
     * (CCA FID: 0x71)
     *
     * @return The value of the field "StartupReason"
     */
    inline T_SPM_e32_STARTUP_REASON getStartupReason () const;

    /**
     * Sets the value of the member "StartupReason".
     *
     * (CCA FID: 0x71)
     *
     * @param StartupReason The value which will be set
     */
    inline void setStartupReason (T_SPM_e32_STARTUP_REASON StartupReason_);

    static const StartupReasonUpdate &getDefaultInstance();

private:

    inline void set_has_StartupReason ();

    inline void clear_has_StartupReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_STARTUP_REASON _StartupReason;

};

/**
 * (CCA FID: 0x71)
 */
class StartupReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupReasonRegister ();

    /**
     * Copy constructor
     */
    inline  StartupReasonRegister (const StartupReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StartupReasonRegister();

    /**
     * Assignment operator
     */
    inline StartupReasonRegister& operator = (const StartupReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StartupReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x72)
 */
class ConnectToBatteryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectToBatteryUpdate ();

    /**
     * Copy constructor
     */
    inline  ConnectToBatteryUpdate (const ConnectToBatteryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ConnectToBatteryUpdate (const TConnectToBattery& ConnectToBattery_);

    /**
     * Destructor
     */
    inline virtual  ~ConnectToBatteryUpdate();

    /**
     * Assignment operator
     */
    inline ConnectToBatteryUpdate& operator = (const ConnectToBatteryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectToBatteryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectToBatteryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectToBatteryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectToBatteryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ConnectToBattery"

    static const int kConnectToBattery = 0;

    /**
     * Clears the field "ConnectToBattery".
     *
     * The field will be set to its default value. The hasConnectToBattery()
     * method will return false.
     */
    inline void clearConnectToBattery();

    /**
     * Checks whether the field "ConnectToBattery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setConnectToBattery()). Otherwise it will return false.
     */
    inline bool hasConnectToBattery () const;

    /**
     * Returns the value of the member "ConnectToBattery".
     *
     * (CCA FID: 0x72)
     *
     * @return The value of the field "ConnectToBattery"
     */
    inline const TConnectToBattery& getConnectToBattery () const;

    /**
     * Retrieves the value of the field "ConnectToBattery" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ConnectToBattery".
     */
    inline TConnectToBattery& getConnectToBatteryMutable ();

    /**
     * Sets the value of the member "ConnectToBattery".
     *
     * (CCA FID: 0x72)
     *
     * @param ConnectToBattery The value which will be set
     */
    inline void setConnectToBattery (const TConnectToBattery& ConnectToBattery_);

    static const ConnectToBatteryUpdate &getDefaultInstance();

private:

    inline void set_has_ConnectToBattery ();

    inline void clear_has_ConnectToBattery ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TConnectToBattery _ConnectToBattery;

};

/**
 * (CCA FID: 0x72)
 */
class ConnectToBatteryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ConnectToBatteryRegister ();

    /**
     * Copy constructor
     */
    inline  ConnectToBatteryRegister (const ConnectToBatteryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ConnectToBatteryRegister();

    /**
     * Assignment operator
     */
    inline ConnectToBatteryRegister& operator = (const ConnectToBatteryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ConnectToBatteryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ConnectToBatteryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ConnectToBatteryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ConnectToBatteryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ConnectToBatteryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Current code request state. (CCA FID: 0x60)
 */
class CodeRequestStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CodeRequestStateUpdate ();

    /**
     * Copy constructor
     */
    inline  CodeRequestStateUpdate (const CodeRequestStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CodeRequestStateUpdate (T_SPM_e32_CODE_REQUEST CodeRequestState_);

    /**
     * Destructor
     */
    inline virtual  ~CodeRequestStateUpdate();

    /**
     * Assignment operator
     */
    inline CodeRequestStateUpdate& operator = (const CodeRequestStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CodeRequestStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CodeRequestStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CodeRequestStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CodeRequestStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CodeRequestState"

    static const int kCodeRequestState = 0;

    /**
     * Clears the field "CodeRequestState".
     *
     * The field will be set to its default value. The hasCodeRequestState()
     * method will return false.
     */
    inline void clearCodeRequestState();

    /**
     * Checks whether the field "CodeRequestState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCodeRequestState()). Otherwise it will return false.
     */
    inline bool hasCodeRequestState () const;

    /**
     * Returns the value of the member "CodeRequestState".
     *
     * Current code request state. (CCA FID: 0x60)
     *
     * @return The value of the field "CodeRequestState"
     */
    inline T_SPM_e32_CODE_REQUEST getCodeRequestState () const;

    /**
     * Sets the value of the member "CodeRequestState".
     *
     * Current code request state. (CCA FID: 0x60)
     *
     * @param CodeRequestState The value which will be set
     */
    inline void setCodeRequestState (T_SPM_e32_CODE_REQUEST CodeRequestState_);

    static const CodeRequestStateUpdate &getDefaultInstance();

private:

    inline void set_has_CodeRequestState ();

    inline void clear_has_CodeRequestState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_CODE_REQUEST _CodeRequestState;

};

/**
 * Current code request state. (CCA FID: 0x60)
 */
class CodeRequestStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CodeRequestStateRegister ();

    /**
     * Copy constructor
     */
    inline  CodeRequestStateRegister (const CodeRequestStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CodeRequestStateRegister();

    /**
     * Assignment operator
     */
    inline CodeRequestStateRegister& operator = (const CodeRequestStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CodeRequestStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CodeRequestStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CodeRequestStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CodeRequestStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CodeRequestStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
 */
class ActiveStartUpSyncPointsUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveStartUpSyncPointsUpdate ();

    /**
     * Copy constructor
     */
    inline  ActiveStartUpSyncPointsUpdate (const ActiveStartUpSyncPointsUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ActiveStartUpSyncPointsUpdate (const ::std::vector< ::std::string >& ActiveStartUpSyncPoints_);

    /**
     * Destructor
     */
    inline virtual  ~ActiveStartUpSyncPointsUpdate();

    /**
     * Assignment operator
     */
    inline ActiveStartUpSyncPointsUpdate& operator = (const ActiveStartUpSyncPointsUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveStartUpSyncPointsUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveStartUpSyncPointsUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveStartUpSyncPointsUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveStartUpSyncPointsUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveStartUpSyncPoints"

    static const int kActiveStartUpSyncPoints = 0;

    /**
     * Clears the field "ActiveStartUpSyncPoints".
     *
     * The field will be set to its default value. The hasActiveStartUpSyncPoints()
     * method will return false.
     */
    inline void clearActiveStartUpSyncPoints();

    /**
     * Checks whether the field "ActiveStartUpSyncPoints" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveStartUpSyncPoints()). Otherwise it will return false.
     */
    inline bool hasActiveStartUpSyncPoints () const;

    /**
     * Returns the value of the member "ActiveStartUpSyncPoints".
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     *
     * @return The value of the field "ActiveStartUpSyncPoints"
     */
    inline const ::std::vector< ::std::string >& getActiveStartUpSyncPoints () const;

    /**
     * Retrieves the value of the field "ActiveStartUpSyncPoints" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActiveStartUpSyncPoints".
     */
    inline ::std::vector< ::std::string >& getActiveStartUpSyncPointsMutable ();

    /**
     * Sets the value of the member "ActiveStartUpSyncPoints".
     *
     * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
     *
     * @param ActiveStartUpSyncPoints The value which will be set
     */
    inline void setActiveStartUpSyncPoints (const ::std::vector< ::std::string >& ActiveStartUpSyncPoints_);

    static const ActiveStartUpSyncPointsUpdate &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_ActiveStartUpSyncPoints ();

    inline void clear_has_ActiveStartUpSyncPoints ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _ActiveStartUpSyncPoints;

};

/**
 * Informs about all StartupSyncPoints since last wakeup. (CCA FID: 0x161)
 */
class ActiveStartUpSyncPointsRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ActiveStartUpSyncPointsRegister ();

    /**
     * Copy constructor
     */
    inline  ActiveStartUpSyncPointsRegister (const ActiveStartUpSyncPointsRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ActiveStartUpSyncPointsRegister();

    /**
     * Assignment operator
     */
    inline ActiveStartUpSyncPointsRegister& operator = (const ActiveStartUpSyncPointsRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ActiveStartUpSyncPointsRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ActiveStartUpSyncPointsRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ActiveStartUpSyncPointsRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ActiveStartUpSyncPointsRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ActiveStartUpSyncPointsRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x38)
 */
class CvmEventUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CvmEventUpdate ();

    /**
     * Copy constructor
     */
    inline  CvmEventUpdate (const CvmEventUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CvmEventUpdate (T_SPM_e32_CVM_EVENT CvmEvent_);

    /**
     * Destructor
     */
    inline virtual  ~CvmEventUpdate();

    /**
     * Assignment operator
     */
    inline CvmEventUpdate& operator = (const CvmEventUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CvmEventUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CvmEventUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CvmEventUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CvmEventUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CvmEvent"

    static const int kCvmEvent = 0;

    /**
     * Clears the field "CvmEvent".
     *
     * The field will be set to its default value. The hasCvmEvent()
     * method will return false.
     */
    inline void clearCvmEvent();

    /**
     * Checks whether the field "CvmEvent" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCvmEvent()). Otherwise it will return false.
     */
    inline bool hasCvmEvent () const;

    /**
     * Returns the value of the member "CvmEvent".
     *
     * (CCA FID: 0x38)
     *
     * @return The value of the field "CvmEvent"
     */
    inline T_SPM_e32_CVM_EVENT getCvmEvent () const;

    /**
     * Sets the value of the member "CvmEvent".
     *
     * (CCA FID: 0x38)
     *
     * @param CvmEvent The value which will be set
     */
    inline void setCvmEvent (T_SPM_e32_CVM_EVENT CvmEvent_);

    static const CvmEventUpdate &getDefaultInstance();

private:

    inline void set_has_CvmEvent ();

    inline void clear_has_CvmEvent ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_CVM_EVENT _CvmEvent;

};

/**
 * (CCA FID: 0x38)
 */
class CvmEventRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CvmEventRegister ();

    /**
     * Copy constructor
     */
    inline  CvmEventRegister (const CvmEventRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CvmEventRegister();

    /**
     * Assignment operator
     */
    inline CvmEventRegister& operator = (const CvmEventRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CvmEventRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CvmEventRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CvmEventRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CvmEventRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CvmEventRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Current measured voltage level in mV. (CCA FID: 0x83)
 */
class UBatSenseUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UBatSenseUpdate ();

    /**
     * Copy constructor
     */
    inline  UBatSenseUpdate (const UBatSenseUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  UBatSenseUpdate (uint16 UBatSense_);

    /**
     * Destructor
     */
    inline virtual  ~UBatSenseUpdate();

    /**
     * Assignment operator
     */
    inline UBatSenseUpdate& operator = (const UBatSenseUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UBatSenseUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UBatSenseUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UBatSenseUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UBatSenseUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "UBatSense"

    static const int kUBatSense = 0;

    /**
     * Clears the field "UBatSense".
     *
     * The field will be set to its default value. The hasUBatSense()
     * method will return false.
     */
    inline void clearUBatSense();

    /**
     * Checks whether the field "UBatSense" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUBatSense()). Otherwise it will return false.
     */
    inline bool hasUBatSense () const;

    /**
     * Returns the value of the member "UBatSense".
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     *
     * @return The value of the field "UBatSense"
     */
    inline uint16 getUBatSense () const;

    /**
     * Sets the value of the member "UBatSense".
     *
     * Current measured voltage level in mV. (CCA FID: 0x83)
     *
     * @param UBatSense The value which will be set
     */
    inline void setUBatSense (uint16 UBatSense_);

    static const UBatSenseUpdate &getDefaultInstance();

private:

    inline void set_has_UBatSense ();

    inline void clear_has_UBatSense ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _UBatSense;

};

/**
 * Current measured voltage level in mV. (CCA FID: 0x83)
 */
class UBatSenseRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  UBatSenseRegister ();

    /**
     * Copy constructor
     */
    inline  UBatSenseRegister (const UBatSenseRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~UBatSenseRegister();

    /**
     * Assignment operator
     */
    inline UBatSenseRegister& operator = (const UBatSenseRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const UBatSenseRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const UBatSenseRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const UBatSenseRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const UBatSenseRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const UBatSenseRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
 */
class CoproStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CoproStateUpdate ();

    /**
     * Copy constructor
     */
    inline  CoproStateUpdate (const CoproStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CoproStateUpdate (T_SPM_e32_PROCESSOR_STATE CoproState_);

    /**
     * Destructor
     */
    inline virtual  ~CoproStateUpdate();

    /**
     * Assignment operator
     */
    inline CoproStateUpdate& operator = (const CoproStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CoproStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CoproStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CoproStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CoproStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CoproState"

    static const int kCoproState = 0;

    /**
     * Clears the field "CoproState".
     *
     * The field will be set to its default value. The hasCoproState()
     * method will return false.
     */
    inline void clearCoproState();

    /**
     * Checks whether the field "CoproState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCoproState()). Otherwise it will return false.
     */
    inline bool hasCoproState () const;

    /**
     * Returns the value of the member "CoproState".
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     *
     * @return The value of the field "CoproState"
     */
    inline T_SPM_e32_PROCESSOR_STATE getCoproState () const;

    /**
     * Sets the value of the member "CoproState".
     *
     * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
     *
     * @param CoproState The value which will be set
     */
    inline void setCoproState (T_SPM_e32_PROCESSOR_STATE CoproState_);

    static const CoproStateUpdate &getDefaultInstance();

private:

    inline void set_has_CoproState ();

    inline void clear_has_CoproState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_PROCESSOR_STATE _CoproState;

};

/**
 * State of communication controller (V850). A reset of the copro will be signalled by sending SPM_U32_PROC_STATE_NORMAL -- SPM_U32_PROC_STATE_DOWN -- SPM_U32_PROC_STATE_NORMAL.  (CCA FID: 0x31)
 */
class CoproStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CoproStateRegister ();

    /**
     * Copy constructor
     */
    inline  CoproStateRegister (const CoproStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CoproStateRegister();

    /**
     * Assignment operator
     */
    inline CoproStateRegister& operator = (const CoproStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CoproStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CoproStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CoproStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CoproStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CoproStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x18)
 */
class DevicePowerOnTimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevicePowerOnTimeUpdate ();

    /**
     * Copy constructor
     */
    inline  DevicePowerOnTimeUpdate (const DevicePowerOnTimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DevicePowerOnTimeUpdate (uint32 DevicePowerOnTime_);

    /**
     * Destructor
     */
    inline virtual  ~DevicePowerOnTimeUpdate();

    /**
     * Assignment operator
     */
    inline DevicePowerOnTimeUpdate& operator = (const DevicePowerOnTimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePowerOnTimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePowerOnTimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePowerOnTimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePowerOnTimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DevicePowerOnTime"

    static const int kDevicePowerOnTime = 0;

    /**
     * Clears the field "DevicePowerOnTime".
     *
     * The field will be set to its default value. The hasDevicePowerOnTime()
     * method will return false.
     */
    inline void clearDevicePowerOnTime();

    /**
     * Checks whether the field "DevicePowerOnTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevicePowerOnTime()). Otherwise it will return false.
     */
    inline bool hasDevicePowerOnTime () const;

    /**
     * Returns the value of the member "DevicePowerOnTime".
     *
     * (CCA FID: 0x18)
     *
     * @return The value of the field "DevicePowerOnTime"
     */
    inline uint32 getDevicePowerOnTime () const;

    /**
     * Sets the value of the member "DevicePowerOnTime".
     *
     * (CCA FID: 0x18)
     *
     * @param DevicePowerOnTime The value which will be set
     */
    inline void setDevicePowerOnTime (uint32 DevicePowerOnTime_);

    static const DevicePowerOnTimeUpdate &getDefaultInstance();

private:

    inline void set_has_DevicePowerOnTime ();

    inline void clear_has_DevicePowerOnTime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _DevicePowerOnTime;

};

/**
 * (CCA FID: 0x18)
 */
class DevicePowerOnTimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevicePowerOnTimeRegister ();

    /**
     * Copy constructor
     */
    inline  DevicePowerOnTimeRegister (const DevicePowerOnTimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DevicePowerOnTimeRegister();

    /**
     * Assignment operator
     */
    inline DevicePowerOnTimeRegister& operator = (const DevicePowerOnTimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevicePowerOnTimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevicePowerOnTimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevicePowerOnTimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevicePowerOnTimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DevicePowerOnTimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
 */
class LastSystemRuntimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LastSystemRuntimeUpdate ();

    /**
     * Copy constructor
     */
    inline  LastSystemRuntimeUpdate (const LastSystemRuntimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LastSystemRuntimeUpdate (uint32 LastSystemRuntime_);

    /**
     * Destructor
     */
    inline virtual  ~LastSystemRuntimeUpdate();

    /**
     * Assignment operator
     */
    inline LastSystemRuntimeUpdate& operator = (const LastSystemRuntimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LastSystemRuntimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LastSystemRuntimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LastSystemRuntimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LastSystemRuntimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LastSystemRuntime"

    static const int kLastSystemRuntime = 0;

    /**
     * Clears the field "LastSystemRuntime".
     *
     * The field will be set to its default value. The hasLastSystemRuntime()
     * method will return false.
     */
    inline void clearLastSystemRuntime();

    /**
     * Checks whether the field "LastSystemRuntime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLastSystemRuntime()). Otherwise it will return false.
     */
    inline bool hasLastSystemRuntime () const;

    /**
     * Returns the value of the member "LastSystemRuntime".
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     *
     * @return The value of the field "LastSystemRuntime"
     */
    inline uint32 getLastSystemRuntime () const;

    /**
     * Sets the value of the member "LastSystemRuntime".
     *
     * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
     *
     * @param LastSystemRuntime The value which will be set
     */
    inline void setLastSystemRuntime (uint32 LastSystemRuntime_);

    static const LastSystemRuntimeUpdate &getDefaultInstance();

private:

    inline void set_has_LastSystemRuntime ();

    inline void clear_has_LastSystemRuntime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _LastSystemRuntime;

};

/**
 * Time in s the system was running in the last power cycle. (CCA FID: 0x1100)
 */
class LastSystemRuntimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LastSystemRuntimeRegister ();

    /**
     * Copy constructor
     */
    inline  LastSystemRuntimeRegister (const LastSystemRuntimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LastSystemRuntimeRegister();

    /**
     * Assignment operator
     */
    inline LastSystemRuntimeRegister& operator = (const LastSystemRuntimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LastSystemRuntimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LastSystemRuntimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LastSystemRuntimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LastSystemRuntimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LastSystemRuntimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Time in s the system is currently active. (CCA FID: 0x1101)
 */
class CurrentSystemRuntimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentSystemRuntimeUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentSystemRuntimeUpdate (const CurrentSystemRuntimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentSystemRuntimeUpdate (uint32 CurrentSystemRuntime_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentSystemRuntimeUpdate();

    /**
     * Assignment operator
     */
    inline CurrentSystemRuntimeUpdate& operator = (const CurrentSystemRuntimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentSystemRuntimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentSystemRuntimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentSystemRuntimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentSystemRuntimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentSystemRuntime"

    static const int kCurrentSystemRuntime = 0;

    /**
     * Clears the field "CurrentSystemRuntime".
     *
     * The field will be set to its default value. The hasCurrentSystemRuntime()
     * method will return false.
     */
    inline void clearCurrentSystemRuntime();

    /**
     * Checks whether the field "CurrentSystemRuntime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentSystemRuntime()). Otherwise it will return false.
     */
    inline bool hasCurrentSystemRuntime () const;

    /**
     * Returns the value of the member "CurrentSystemRuntime".
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     *
     * @return The value of the field "CurrentSystemRuntime"
     */
    inline uint32 getCurrentSystemRuntime () const;

    /**
     * Sets the value of the member "CurrentSystemRuntime".
     *
     * Time in s the system is currently active. (CCA FID: 0x1101)
     *
     * @param CurrentSystemRuntime The value which will be set
     */
    inline void setCurrentSystemRuntime (uint32 CurrentSystemRuntime_);

    static const CurrentSystemRuntimeUpdate &getDefaultInstance();

private:

    inline void set_has_CurrentSystemRuntime ();

    inline void clear_has_CurrentSystemRuntime ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _CurrentSystemRuntime;

};

/**
 * Time in s the system is currently active. (CCA FID: 0x1101)
 */
class CurrentSystemRuntimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentSystemRuntimeRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentSystemRuntimeRegister (const CurrentSystemRuntimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentSystemRuntimeRegister();

    /**
     * Assignment operator
     */
    inline CurrentSystemRuntimeRegister& operator = (const CurrentSystemRuntimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentSystemRuntimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentSystemRuntimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentSystemRuntimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentSystemRuntimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentSystemRuntimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x41)
 */
class ResetListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetListUpdate ();

    /**
     * Copy constructor
     */
    inline  ResetListUpdate (const ResetListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ResetListUpdate (const TResetList& ResetList_);

    /**
     * Destructor
     */
    inline virtual  ~ResetListUpdate();

    /**
     * Assignment operator
     */
    inline ResetListUpdate& operator = (const ResetListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetList"

    static const int kResetList = 0;

    /**
     * Clears the field "ResetList".
     *
     * The field will be set to its default value. The hasResetList()
     * method will return false.
     */
    inline void clearResetList();

    /**
     * Checks whether the field "ResetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetList()). Otherwise it will return false.
     */
    inline bool hasResetList () const;

    /**
     * Returns the value of the member "ResetList".
     *
     * (CCA FID: 0x41)
     *
     * @return The value of the field "ResetList"
     */
    inline const TResetList& getResetList () const;

    /**
     * Retrieves the value of the field "ResetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ResetList".
     */
    inline TResetList& getResetListMutable ();

    /**
     * Sets the value of the member "ResetList".
     *
     * (CCA FID: 0x41)
     *
     * @param ResetList The value which will be set
     */
    inline void setResetList (const TResetList& ResetList_);

    static const ResetListUpdate &getDefaultInstance();

private:

    inline void set_has_ResetList ();

    inline void clear_has_ResetList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TResetList _ResetList;

};

/**
 * (CCA FID: 0x41)
 */
class ResetListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetListRegister ();

    /**
     * Copy constructor
     */
    inline  ResetListRegister (const ResetListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ResetListRegister();

    /**
     * Assignment operator
     */
    inline ResetListRegister& operator = (const ResetListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ResetListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Information about detected reset reasons.  (CCA FID: 0x1041)
 */
class ResetCounterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetCounterUpdate ();

    /**
     * Copy constructor
     */
    inline  ResetCounterUpdate (const ResetCounterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ResetCounterUpdate (const TResetCounter& ResetCounter_);

    /**
     * Destructor
     */
    inline virtual  ~ResetCounterUpdate();

    /**
     * Assignment operator
     */
    inline ResetCounterUpdate& operator = (const ResetCounterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetCounterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetCounterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetCounterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetCounterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetCounter"

    static const int kResetCounter = 0;

    /**
     * Clears the field "ResetCounter".
     *
     * The field will be set to its default value. The hasResetCounter()
     * method will return false.
     */
    inline void clearResetCounter();

    /**
     * Checks whether the field "ResetCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetCounter()). Otherwise it will return false.
     */
    inline bool hasResetCounter () const;

    /**
     * Returns the value of the member "ResetCounter".
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     *
     * @return The value of the field "ResetCounter"
     */
    inline const TResetCounter& getResetCounter () const;

    /**
     * Retrieves the value of the field "ResetCounter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ResetCounter".
     */
    inline TResetCounter& getResetCounterMutable ();

    /**
     * Sets the value of the member "ResetCounter".
     *
     * Information about detected reset reasons.  (CCA FID: 0x1041)
     *
     * @param ResetCounter The value which will be set
     */
    inline void setResetCounter (const TResetCounter& ResetCounter_);

    static const ResetCounterUpdate &getDefaultInstance();

private:

    inline void set_has_ResetCounter ();

    inline void clear_has_ResetCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TResetCounter _ResetCounter;

};

/**
 * Information about detected reset reasons.  (CCA FID: 0x1041)
 */
class ResetCounterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetCounterRegister ();

    /**
     * Copy constructor
     */
    inline  ResetCounterRegister (const ResetCounterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ResetCounterRegister();

    /**
     * Assignment operator
     */
    inline ResetCounterRegister& operator = (const ResetCounterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetCounterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetCounterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetCounterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetCounterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ResetCounterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * History of recent Transportmode trigger.  (CCA FID: 0x43)
 */
class TransportModeListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransportModeListUpdate ();

    /**
     * Copy constructor
     */
    inline  TransportModeListUpdate (const TransportModeListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TransportModeListUpdate (const T_SPM_TransPortModeList& TransportModeList_);

    /**
     * Destructor
     */
    inline virtual  ~TransportModeListUpdate();

    /**
     * Assignment operator
     */
    inline TransportModeListUpdate& operator = (const TransportModeListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransportModeListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransportModeListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransportModeListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransportModeListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TransportModeList"

    static const int kTransportModeList = 0;

    /**
     * Clears the field "TransportModeList".
     *
     * The field will be set to its default value. The hasTransportModeList()
     * method will return false.
     */
    inline void clearTransportModeList();

    /**
     * Checks whether the field "TransportModeList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransportModeList()). Otherwise it will return false.
     */
    inline bool hasTransportModeList () const;

    /**
     * Returns the value of the member "TransportModeList".
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     *
     * @return The value of the field "TransportModeList"
     */
    inline const T_SPM_TransPortModeList& getTransportModeList () const;

    /**
     * Retrieves the value of the field "TransportModeList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TransportModeList".
     */
    inline T_SPM_TransPortModeList& getTransportModeListMutable ();

    /**
     * Sets the value of the member "TransportModeList".
     *
     * History of recent Transportmode trigger.  (CCA FID: 0x43)
     *
     * @param TransportModeList The value which will be set
     */
    inline void setTransportModeList (const T_SPM_TransPortModeList& TransportModeList_);

    static const TransportModeListUpdate &getDefaultInstance();

private:

    inline void set_has_TransportModeList ();

    inline void clear_has_TransportModeList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_TransPortModeList _TransportModeList;

};

/**
 * History of recent Transportmode trigger.  (CCA FID: 0x43)
 */
class TransportModeListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransportModeListRegister ();

    /**
     * Copy constructor
     */
    inline  TransportModeListRegister (const TransportModeListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TransportModeListRegister();

    /**
     * Assignment operator
     */
    inline TransportModeListRegister& operator = (const TransportModeListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransportModeListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransportModeListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransportModeListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransportModeListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TransportModeListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
 */
class ResetHistoryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetHistoryUpdate ();

    /**
     * Copy constructor
     */
    inline  ResetHistoryUpdate (const ResetHistoryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ResetHistoryUpdate (const ::std::vector< T_ResetElement >& ResetHistory_);

    /**
     * Destructor
     */
    inline virtual  ~ResetHistoryUpdate();

    /**
     * Assignment operator
     */
    inline ResetHistoryUpdate& operator = (const ResetHistoryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetHistoryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetHistoryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetHistoryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetHistoryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ResetHistory"

    static const int kResetHistory = 0;

    /**
     * Clears the field "ResetHistory".
     *
     * The field will be set to its default value. The hasResetHistory()
     * method will return false.
     */
    inline void clearResetHistory();

    /**
     * Checks whether the field "ResetHistory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResetHistory()). Otherwise it will return false.
     */
    inline bool hasResetHistory () const;

    /**
     * Returns the value of the member "ResetHistory".
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     *
     * @return The value of the field "ResetHistory"
     */
    inline const ::std::vector< T_ResetElement >& getResetHistory () const;

    /**
     * Retrieves the value of the field "ResetHistory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ResetHistory".
     */
    inline ::std::vector< T_ResetElement >& getResetHistoryMutable ();

    /**
     * Sets the value of the member "ResetHistory".
     *
     * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
     *
     * @param ResetHistory The value which will be set
     */
    inline void setResetHistory (const ::std::vector< T_ResetElement >& ResetHistory_);

    static const ResetHistoryUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_ResetElement >& getT_ResetElementList_DefaultInstance ();

    inline void set_has_ResetHistory ();

    inline void clear_has_ResetHistory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_ResetElement > _ResetHistory;

};

/**
 * Get a list of the latest reset reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x44)
 */
class ResetHistoryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ResetHistoryRegister ();

    /**
     * Copy constructor
     */
    inline  ResetHistoryRegister (const ResetHistoryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ResetHistoryRegister();

    /**
     * Assignment operator
     */
    inline ResetHistoryRegister& operator = (const ResetHistoryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ResetHistoryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ResetHistoryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ResetHistoryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ResetHistoryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ResetHistoryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
 */
class WakeupHistoryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupHistoryUpdate ();

    /**
     * Copy constructor
     */
    inline  WakeupHistoryUpdate (const WakeupHistoryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupHistoryUpdate (const ::std::vector< T_WakeupElement >& WakeupHistory_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupHistoryUpdate();

    /**
     * Assignment operator
     */
    inline WakeupHistoryUpdate& operator = (const WakeupHistoryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupHistoryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupHistoryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupHistoryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupHistoryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeupHistory"

    static const int kWakeupHistory = 0;

    /**
     * Clears the field "WakeupHistory".
     *
     * The field will be set to its default value. The hasWakeupHistory()
     * method will return false.
     */
    inline void clearWakeupHistory();

    /**
     * Checks whether the field "WakeupHistory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeupHistory()). Otherwise it will return false.
     */
    inline bool hasWakeupHistory () const;

    /**
     * Returns the value of the member "WakeupHistory".
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     *
     * @return The value of the field "WakeupHistory"
     */
    inline const ::std::vector< T_WakeupElement >& getWakeupHistory () const;

    /**
     * Retrieves the value of the field "WakeupHistory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WakeupHistory".
     */
    inline ::std::vector< T_WakeupElement >& getWakeupHistoryMutable ();

    /**
     * Sets the value of the member "WakeupHistory".
     *
     * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
     *
     * @param WakeupHistory The value which will be set
     */
    inline void setWakeupHistory (const ::std::vector< T_WakeupElement >& WakeupHistory_);

    static const WakeupHistoryUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_WakeupElement >& getT_WakeupElementList_DefaultInstance ();

    inline void set_has_WakeupHistory ();

    inline void clear_has_WakeupHistory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_WakeupElement > _WakeupHistory;

};

/**
 * Get a list of the latest wakeup reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x45)
 */
class WakeupHistoryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupHistoryRegister ();

    /**
     * Copy constructor
     */
    inline  WakeupHistoryRegister (const WakeupHistoryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WakeupHistoryRegister();

    /**
     * Assignment operator
     */
    inline WakeupHistoryRegister& operator = (const WakeupHistoryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupHistoryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupHistoryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupHistoryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupHistoryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WakeupHistoryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
 */
class StateHistoryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateHistoryUpdate ();

    /**
     * Copy constructor
     */
    inline  StateHistoryUpdate (const StateHistoryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StateHistoryUpdate (const ::std::vector< T_StateChangeElement >& StateHistory_);

    /**
     * Destructor
     */
    inline virtual  ~StateHistoryUpdate();

    /**
     * Assignment operator
     */
    inline StateHistoryUpdate& operator = (const StateHistoryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateHistoryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateHistoryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateHistoryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateHistoryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StateHistory"

    static const int kStateHistory = 0;

    /**
     * Clears the field "StateHistory".
     *
     * The field will be set to its default value. The hasStateHistory()
     * method will return false.
     */
    inline void clearStateHistory();

    /**
     * Checks whether the field "StateHistory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStateHistory()). Otherwise it will return false.
     */
    inline bool hasStateHistory () const;

    /**
     * Returns the value of the member "StateHistory".
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     *
     * @return The value of the field "StateHistory"
     */
    inline const ::std::vector< T_StateChangeElement >& getStateHistory () const;

    /**
     * Retrieves the value of the field "StateHistory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StateHistory".
     */
    inline ::std::vector< T_StateChangeElement >& getStateHistoryMutable ();

    /**
     * Sets the value of the member "StateHistory".
     *
     * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
     *
     * @param StateHistory The value which will be set
     */
    inline void setStateHistory (const ::std::vector< T_StateChangeElement >& StateHistory_);

    static const StateHistoryUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_StateChangeElement >& getT_StateChangeElementList_DefaultInstance ();

    inline void set_has_StateHistory ();

    inline void clear_has_StateHistory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_StateChangeElement > _StateHistory;

};

/**
 * Get a list of the latest wakeup/reset events and on/off reasons. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x46)
 */
class StateHistoryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateHistoryRegister ();

    /**
     * Copy constructor
     */
    inline  StateHistoryRegister (const StateHistoryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StateHistoryRegister();

    /**
     * Assignment operator
     */
    inline StateHistoryRegister& operator = (const StateHistoryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateHistoryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateHistoryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateHistoryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateHistoryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StateHistoryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
 */
class ErrStateHistory01Update  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory01Update ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory01Update (const ErrStateHistory01Update &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory01Update (const ::std::vector< T_StateChangeElement >& ErrStateHistory01_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory01Update();

    /**
     * Assignment operator
     */
    inline ErrStateHistory01Update& operator = (const ErrStateHistory01Update& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory01Update& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory01Update& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory01Update& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory01Update& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrStateHistory01"

    static const int kErrStateHistory01 = 0;

    /**
     * Clears the field "ErrStateHistory01".
     *
     * The field will be set to its default value. The hasErrStateHistory01()
     * method will return false.
     */
    inline void clearErrStateHistory01();

    /**
     * Checks whether the field "ErrStateHistory01" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrStateHistory01()). Otherwise it will return false.
     */
    inline bool hasErrStateHistory01 () const;

    /**
     * Returns the value of the member "ErrStateHistory01".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     *
     * @return The value of the field "ErrStateHistory01"
     */
    inline const ::std::vector< T_StateChangeElement >& getErrStateHistory01 () const;

    /**
     * Retrieves the value of the field "ErrStateHistory01" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ErrStateHistory01".
     */
    inline ::std::vector< T_StateChangeElement >& getErrStateHistory01Mutable ();

    /**
     * Sets the value of the member "ErrStateHistory01".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
     *
     * @param ErrStateHistory01 The value which will be set
     */
    inline void setErrStateHistory01 (const ::std::vector< T_StateChangeElement >& ErrStateHistory01_);

    static const ErrStateHistory01Update &getDefaultInstance();

private:

    static const ::std::vector< T_StateChangeElement >& getT_StateChangeElementList_DefaultInstance ();

    inline void set_has_ErrStateHistory01 ();

    inline void clear_has_ErrStateHistory01 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_StateChangeElement > _ErrStateHistory01;

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x47)
 */
class ErrStateHistory01Register  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory01Register ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory01Register (const ErrStateHistory01Register &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory01Register();

    /**
     * Assignment operator
     */
    inline ErrStateHistory01Register& operator = (const ErrStateHistory01Register& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory01Register& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory01Register& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory01Register& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory01Register& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ErrStateHistory01Register &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
 */
class ErrStateHistory02Update  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory02Update ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory02Update (const ErrStateHistory02Update &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory02Update (const ::std::vector< T_StateChangeElement >& ErrStateHistory02_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory02Update();

    /**
     * Assignment operator
     */
    inline ErrStateHistory02Update& operator = (const ErrStateHistory02Update& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory02Update& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory02Update& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory02Update& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory02Update& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrStateHistory02"

    static const int kErrStateHistory02 = 0;

    /**
     * Clears the field "ErrStateHistory02".
     *
     * The field will be set to its default value. The hasErrStateHistory02()
     * method will return false.
     */
    inline void clearErrStateHistory02();

    /**
     * Checks whether the field "ErrStateHistory02" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrStateHistory02()). Otherwise it will return false.
     */
    inline bool hasErrStateHistory02 () const;

    /**
     * Returns the value of the member "ErrStateHistory02".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     *
     * @return The value of the field "ErrStateHistory02"
     */
    inline const ::std::vector< T_StateChangeElement >& getErrStateHistory02 () const;

    /**
     * Retrieves the value of the field "ErrStateHistory02" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ErrStateHistory02".
     */
    inline ::std::vector< T_StateChangeElement >& getErrStateHistory02Mutable ();

    /**
     * Sets the value of the member "ErrStateHistory02".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
     *
     * @param ErrStateHistory02 The value which will be set
     */
    inline void setErrStateHistory02 (const ::std::vector< T_StateChangeElement >& ErrStateHistory02_);

    static const ErrStateHistory02Update &getDefaultInstance();

private:

    static const ::std::vector< T_StateChangeElement >& getT_StateChangeElementList_DefaultInstance ();

    inline void set_has_ErrStateHistory02 ();

    inline void clear_has_ErrStateHistory02 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_StateChangeElement > _ErrStateHistory02;

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x48)
 */
class ErrStateHistory02Register  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory02Register ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory02Register (const ErrStateHistory02Register &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory02Register();

    /**
     * Assignment operator
     */
    inline ErrStateHistory02Register& operator = (const ErrStateHistory02Register& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory02Register& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory02Register& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory02Register& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory02Register& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ErrStateHistory02Register &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
 */
class ErrStateHistory03Update  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory03Update ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory03Update (const ErrStateHistory03Update &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory03Update (const ::std::vector< T_StateChangeElement >& ErrStateHistory03_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory03Update();

    /**
     * Assignment operator
     */
    inline ErrStateHistory03Update& operator = (const ErrStateHistory03Update& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory03Update& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory03Update& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory03Update& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory03Update& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrStateHistory03"

    static const int kErrStateHistory03 = 0;

    /**
     * Clears the field "ErrStateHistory03".
     *
     * The field will be set to its default value. The hasErrStateHistory03()
     * method will return false.
     */
    inline void clearErrStateHistory03();

    /**
     * Checks whether the field "ErrStateHistory03" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrStateHistory03()). Otherwise it will return false.
     */
    inline bool hasErrStateHistory03 () const;

    /**
     * Returns the value of the member "ErrStateHistory03".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     *
     * @return The value of the field "ErrStateHistory03"
     */
    inline const ::std::vector< T_StateChangeElement >& getErrStateHistory03 () const;

    /**
     * Retrieves the value of the field "ErrStateHistory03" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ErrStateHistory03".
     */
    inline ::std::vector< T_StateChangeElement >& getErrStateHistory03Mutable ();

    /**
     * Sets the value of the member "ErrStateHistory03".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
     *
     * @param ErrStateHistory03 The value which will be set
     */
    inline void setErrStateHistory03 (const ::std::vector< T_StateChangeElement >& ErrStateHistory03_);

    static const ErrStateHistory03Update &getDefaultInstance();

private:

    static const ::std::vector< T_StateChangeElement >& getT_StateChangeElementList_DefaultInstance ();

    inline void set_has_ErrStateHistory03 ();

    inline void clear_has_ErrStateHistory03 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_StateChangeElement > _ErrStateHistory03;

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x49)
 */
class ErrStateHistory03Register  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory03Register ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory03Register (const ErrStateHistory03Register &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory03Register();

    /**
     * Assignment operator
     */
    inline ErrStateHistory03Register& operator = (const ErrStateHistory03Register& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory03Register& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory03Register& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory03Register& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory03Register& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ErrStateHistory03Register &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
 */
class ErrStateHistory04Update  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory04Update ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory04Update (const ErrStateHistory04Update &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory04Update (const ::std::vector< T_StateChangeElement >& ErrStateHistory04_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory04Update();

    /**
     * Assignment operator
     */
    inline ErrStateHistory04Update& operator = (const ErrStateHistory04Update& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory04Update& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory04Update& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory04Update& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory04Update& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrStateHistory04"

    static const int kErrStateHistory04 = 0;

    /**
     * Clears the field "ErrStateHistory04".
     *
     * The field will be set to its default value. The hasErrStateHistory04()
     * method will return false.
     */
    inline void clearErrStateHistory04();

    /**
     * Checks whether the field "ErrStateHistory04" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrStateHistory04()). Otherwise it will return false.
     */
    inline bool hasErrStateHistory04 () const;

    /**
     * Returns the value of the member "ErrStateHistory04".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     *
     * @return The value of the field "ErrStateHistory04"
     */
    inline const ::std::vector< T_StateChangeElement >& getErrStateHistory04 () const;

    /**
     * Retrieves the value of the field "ErrStateHistory04" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ErrStateHistory04".
     */
    inline ::std::vector< T_StateChangeElement >& getErrStateHistory04Mutable ();

    /**
     * Sets the value of the member "ErrStateHistory04".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
     *
     * @param ErrStateHistory04 The value which will be set
     */
    inline void setErrStateHistory04 (const ::std::vector< T_StateChangeElement >& ErrStateHistory04_);

    static const ErrStateHistory04Update &getDefaultInstance();

private:

    static const ::std::vector< T_StateChangeElement >& getT_StateChangeElementList_DefaultInstance ();

    inline void set_has_ErrStateHistory04 ();

    inline void clear_has_ErrStateHistory04 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_StateChangeElement > _ErrStateHistory04;

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4a)
 */
class ErrStateHistory04Register  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory04Register ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory04Register (const ErrStateHistory04Register &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory04Register();

    /**
     * Assignment operator
     */
    inline ErrStateHistory04Register& operator = (const ErrStateHistory04Register& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory04Register& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory04Register& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory04Register& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory04Register& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ErrStateHistory04Register &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
 */
class ErrStateHistory05Update  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory05Update ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory05Update (const ErrStateHistory05Update &rhs);

    /**
     * All fields constructor
     */
    inline  ErrStateHistory05Update (const ::std::vector< T_StateChangeElement >& ErrStateHistory05_);

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory05Update();

    /**
     * Assignment operator
     */
    inline ErrStateHistory05Update& operator = (const ErrStateHistory05Update& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory05Update& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory05Update& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory05Update& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory05Update& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrStateHistory05"

    static const int kErrStateHistory05 = 0;

    /**
     * Clears the field "ErrStateHistory05".
     *
     * The field will be set to its default value. The hasErrStateHistory05()
     * method will return false.
     */
    inline void clearErrStateHistory05();

    /**
     * Checks whether the field "ErrStateHistory05" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrStateHistory05()). Otherwise it will return false.
     */
    inline bool hasErrStateHistory05 () const;

    /**
     * Returns the value of the member "ErrStateHistory05".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     *
     * @return The value of the field "ErrStateHistory05"
     */
    inline const ::std::vector< T_StateChangeElement >& getErrStateHistory05 () const;

    /**
     * Retrieves the value of the field "ErrStateHistory05" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ErrStateHistory05".
     */
    inline ::std::vector< T_StateChangeElement >& getErrStateHistory05Mutable ();

    /**
     * Sets the value of the member "ErrStateHistory05".
     *
     * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
     *
     * @param ErrStateHistory05 The value which will be set
     */
    inline void setErrStateHistory05 (const ::std::vector< T_StateChangeElement >& ErrStateHistory05_);

    static const ErrStateHistory05Update &getDefaultInstance();

private:

    static const ::std::vector< T_StateChangeElement >& getT_StateChangeElementList_DefaultInstance ();

    inline void set_has_ErrStateHistory05 ();

    inline void clear_has_ErrStateHistory05 ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_StateChangeElement > _ErrStateHistory05;

};

/**
 * A list of the wakeup/reset events and on/off reasons. List is generated when when an error situation is detected by SPM/LCM. Information is stored with time and date of occurrence (if available).  (CCA FID: 0x4b)
 */
class ErrStateHistory05Register  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ErrStateHistory05Register ();

    /**
     * Copy constructor
     */
    inline  ErrStateHistory05Register (const ErrStateHistory05Register &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ErrStateHistory05Register();

    /**
     * Assignment operator
     */
    inline ErrStateHistory05Register& operator = (const ErrStateHistory05Register& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ErrStateHistory05Register& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ErrStateHistory05Register& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ErrStateHistory05Register& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ErrStateHistory05Register& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ErrStateHistory05Register &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
 */
class SwitchOnHistoryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchOnHistoryUpdate ();

    /**
     * Copy constructor
     */
    inline  SwitchOnHistoryUpdate (const SwitchOnHistoryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SwitchOnHistoryUpdate (const ::std::vector< T_SwitchOnElement >& SwitchOnHistory_);

    /**
     * Destructor
     */
    inline virtual  ~SwitchOnHistoryUpdate();

    /**
     * Assignment operator
     */
    inline SwitchOnHistoryUpdate& operator = (const SwitchOnHistoryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchOnHistoryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchOnHistoryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchOnHistoryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchOnHistoryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SwitchOnHistory"

    static const int kSwitchOnHistory = 0;

    /**
     * Clears the field "SwitchOnHistory".
     *
     * The field will be set to its default value. The hasSwitchOnHistory()
     * method will return false.
     */
    inline void clearSwitchOnHistory();

    /**
     * Checks whether the field "SwitchOnHistory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSwitchOnHistory()). Otherwise it will return false.
     */
    inline bool hasSwitchOnHistory () const;

    /**
     * Returns the value of the member "SwitchOnHistory".
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     *
     * @return The value of the field "SwitchOnHistory"
     */
    inline const ::std::vector< T_SwitchOnElement >& getSwitchOnHistory () const;

    /**
     * Retrieves the value of the field "SwitchOnHistory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SwitchOnHistory".
     */
    inline ::std::vector< T_SwitchOnElement >& getSwitchOnHistoryMutable ();

    /**
     * Sets the value of the member "SwitchOnHistory".
     *
     * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
     *
     * @param SwitchOnHistory The value which will be set
     */
    inline void setSwitchOnHistory (const ::std::vector< T_SwitchOnElement >& SwitchOnHistory_);

    static const SwitchOnHistoryUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_SwitchOnElement >& getT_SwitchOnElementList_DefaultInstance ();

    inline void set_has_SwitchOnHistory ();

    inline void clear_has_SwitchOnHistory ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SwitchOnElement > _SwitchOnHistory;

};

/**
 * List of ON reasons why target is switched on (display on).  (CCA FID: 0x4c)
 */
class SwitchOnHistoryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SwitchOnHistoryRegister ();

    /**
     * Copy constructor
     */
    inline  SwitchOnHistoryRegister (const SwitchOnHistoryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SwitchOnHistoryRegister();

    /**
     * Assignment operator
     */
    inline SwitchOnHistoryRegister& operator = (const SwitchOnHistoryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SwitchOnHistoryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SwitchOnHistoryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SwitchOnHistoryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SwitchOnHistoryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SwitchOnHistoryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x1050)
 */
class DeviceOnCounterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceOnCounterUpdate ();

    /**
     * Copy constructor
     */
    inline  DeviceOnCounterUpdate (const DeviceOnCounterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceOnCounterUpdate (const TDeviceOnCounter& DeviceOnCounter_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceOnCounterUpdate();

    /**
     * Assignment operator
     */
    inline DeviceOnCounterUpdate& operator = (const DeviceOnCounterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceOnCounterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceOnCounterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceOnCounterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceOnCounterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceOnCounter"

    static const int kDeviceOnCounter = 0;

    /**
     * Clears the field "DeviceOnCounter".
     *
     * The field will be set to its default value. The hasDeviceOnCounter()
     * method will return false.
     */
    inline void clearDeviceOnCounter();

    /**
     * Checks whether the field "DeviceOnCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceOnCounter()). Otherwise it will return false.
     */
    inline bool hasDeviceOnCounter () const;

    /**
     * Returns the value of the member "DeviceOnCounter".
     *
     * (CCA FID: 0x1050)
     *
     * @return The value of the field "DeviceOnCounter"
     */
    inline const TDeviceOnCounter& getDeviceOnCounter () const;

    /**
     * Retrieves the value of the field "DeviceOnCounter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceOnCounter".
     */
    inline TDeviceOnCounter& getDeviceOnCounterMutable ();

    /**
     * Sets the value of the member "DeviceOnCounter".
     *
     * (CCA FID: 0x1050)
     *
     * @param DeviceOnCounter The value which will be set
     */
    inline void setDeviceOnCounter (const TDeviceOnCounter& DeviceOnCounter_);

    static const DeviceOnCounterUpdate &getDefaultInstance();

private:

    inline void set_has_DeviceOnCounter ();

    inline void clear_has_DeviceOnCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TDeviceOnCounter _DeviceOnCounter;

};

/**
 * (CCA FID: 0x1050)
 */
class DeviceOnCounterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceOnCounterRegister ();

    /**
     * Copy constructor
     */
    inline  DeviceOnCounterRegister (const DeviceOnCounterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeviceOnCounterRegister();

    /**
     * Assignment operator
     */
    inline DeviceOnCounterRegister& operator = (const DeviceOnCounterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceOnCounterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceOnCounterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceOnCounterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceOnCounterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeviceOnCounterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Counts system voltage events. (CCA FID: 0x1051)
 */
class VoltageEventCounterUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltageEventCounterUpdate ();

    /**
     * Copy constructor
     */
    inline  VoltageEventCounterUpdate (const VoltageEventCounterUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VoltageEventCounterUpdate (const T_SPM_VoltageEventCounter& VoltageEventCounter_);

    /**
     * Destructor
     */
    inline virtual  ~VoltageEventCounterUpdate();

    /**
     * Assignment operator
     */
    inline VoltageEventCounterUpdate& operator = (const VoltageEventCounterUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltageEventCounterUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltageEventCounterUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltageEventCounterUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltageEventCounterUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoltageEventCounter"

    static const int kVoltageEventCounter = 0;

    /**
     * Clears the field "VoltageEventCounter".
     *
     * The field will be set to its default value. The hasVoltageEventCounter()
     * method will return false.
     */
    inline void clearVoltageEventCounter();

    /**
     * Checks whether the field "VoltageEventCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageEventCounter()). Otherwise it will return false.
     */
    inline bool hasVoltageEventCounter () const;

    /**
     * Returns the value of the member "VoltageEventCounter".
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     *
     * @return The value of the field "VoltageEventCounter"
     */
    inline const T_SPM_VoltageEventCounter& getVoltageEventCounter () const;

    /**
     * Retrieves the value of the field "VoltageEventCounter" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoltageEventCounter".
     */
    inline T_SPM_VoltageEventCounter& getVoltageEventCounterMutable ();

    /**
     * Sets the value of the member "VoltageEventCounter".
     *
     * Counts system voltage events. (CCA FID: 0x1051)
     *
     * @param VoltageEventCounter The value which will be set
     */
    inline void setVoltageEventCounter (const T_SPM_VoltageEventCounter& VoltageEventCounter_);

    static const VoltageEventCounterUpdate &getDefaultInstance();

private:

    inline void set_has_VoltageEventCounter ();

    inline void clear_has_VoltageEventCounter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_VoltageEventCounter _VoltageEventCounter;

};

/**
 * Counts system voltage events. (CCA FID: 0x1051)
 */
class VoltageEventCounterRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltageEventCounterRegister ();

    /**
     * Copy constructor
     */
    inline  VoltageEventCounterRegister (const VoltageEventCounterRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VoltageEventCounterRegister();

    /**
     * Assignment operator
     */
    inline VoltageEventCounterRegister& operator = (const VoltageEventCounterRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltageEventCounterRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltageEventCounterRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltageEventCounterRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltageEventCounterRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VoltageEventCounterRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
 */
class VoltageRangeHistogramUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltageRangeHistogramUpdate ();

    /**
     * Copy constructor
     */
    inline  VoltageRangeHistogramUpdate (const VoltageRangeHistogramUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VoltageRangeHistogramUpdate (const ::std::vector< T_SPM_VoltageRange >& VoltageRangeHistogram_);

    /**
     * Destructor
     */
    inline virtual  ~VoltageRangeHistogramUpdate();

    /**
     * Assignment operator
     */
    inline VoltageRangeHistogramUpdate& operator = (const VoltageRangeHistogramUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltageRangeHistogramUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltageRangeHistogramUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltageRangeHistogramUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltageRangeHistogramUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "VoltageRangeHistogram"

    static const int kVoltageRangeHistogram = 0;

    /**
     * Clears the field "VoltageRangeHistogram".
     *
     * The field will be set to its default value. The hasVoltageRangeHistogram()
     * method will return false.
     */
    inline void clearVoltageRangeHistogram();

    /**
     * Checks whether the field "VoltageRangeHistogram" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVoltageRangeHistogram()). Otherwise it will return false.
     */
    inline bool hasVoltageRangeHistogram () const;

    /**
     * Returns the value of the member "VoltageRangeHistogram".
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     *
     * @return The value of the field "VoltageRangeHistogram"
     */
    inline const ::std::vector< T_SPM_VoltageRange >& getVoltageRangeHistogram () const;

    /**
     * Retrieves the value of the field "VoltageRangeHistogram" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "VoltageRangeHistogram".
     */
    inline ::std::vector< T_SPM_VoltageRange >& getVoltageRangeHistogramMutable ();

    /**
     * Sets the value of the member "VoltageRangeHistogram".
     *
     * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
     *
     * @param VoltageRangeHistogram The value which will be set
     */
    inline void setVoltageRangeHistogram (const ::std::vector< T_SPM_VoltageRange >& VoltageRangeHistogram_);

    static const VoltageRangeHistogramUpdate &getDefaultInstance();

private:

    static const ::std::vector< T_SPM_VoltageRange >& getT_SPM_VoltageRangeList_DefaultInstance ();

    inline void set_has_VoltageRangeHistogram ();

    inline void clear_has_VoltageRangeHistogram ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< T_SPM_VoltageRange > _VoltageRangeHistogram;

};

/**
 * The histogram of system voltage. The histogram contains a set of 50 voltage ranges in mV and operation time in sec (CCA FID: 0x1052)
 */
class VoltageRangeHistogramRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VoltageRangeHistogramRegister ();

    /**
     * Copy constructor
     */
    inline  VoltageRangeHistogramRegister (const VoltageRangeHistogramRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VoltageRangeHistogramRegister();

    /**
     * Assignment operator
     */
    inline VoltageRangeHistogramRegister& operator = (const VoltageRangeHistogramRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VoltageRangeHistogramRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VoltageRangeHistogramRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VoltageRangeHistogramRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VoltageRangeHistogramRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VoltageRangeHistogramRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
 */
class CpuUsageStatisticUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CpuUsageStatisticUpdate ();

    /**
     * Copy constructor
     */
    inline  CpuUsageStatisticUpdate (const CpuUsageStatisticUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CpuUsageStatisticUpdate (const T_SPM_SystemStatisticsData& CpuUsageStatistic_);

    /**
     * Destructor
     */
    inline virtual  ~CpuUsageStatisticUpdate();

    /**
     * Assignment operator
     */
    inline CpuUsageStatisticUpdate& operator = (const CpuUsageStatisticUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CpuUsageStatisticUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CpuUsageStatisticUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CpuUsageStatisticUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CpuUsageStatisticUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CpuUsageStatistic"

    static const int kCpuUsageStatistic = 0;

    /**
     * Clears the field "CpuUsageStatistic".
     *
     * The field will be set to its default value. The hasCpuUsageStatistic()
     * method will return false.
     */
    inline void clearCpuUsageStatistic();

    /**
     * Checks whether the field "CpuUsageStatistic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCpuUsageStatistic()). Otherwise it will return false.
     */
    inline bool hasCpuUsageStatistic () const;

    /**
     * Returns the value of the member "CpuUsageStatistic".
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     *
     * @return The value of the field "CpuUsageStatistic"
     */
    inline const T_SPM_SystemStatisticsData& getCpuUsageStatistic () const;

    /**
     * Retrieves the value of the field "CpuUsageStatistic" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CpuUsageStatistic".
     */
    inline T_SPM_SystemStatisticsData& getCpuUsageStatisticMutable ();

    /**
     * Sets the value of the member "CpuUsageStatistic".
     *
     * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
     *
     * @param CpuUsageStatistic The value which will be set
     */
    inline void setCpuUsageStatistic (const T_SPM_SystemStatisticsData& CpuUsageStatistic_);

    static const CpuUsageStatisticUpdate &getDefaultInstance();

private:

    inline void set_has_CpuUsageStatistic ();

    inline void clear_has_CpuUsageStatistic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_SystemStatisticsData _CpuUsageStatistic;

};

/**
 * CPU usage of device. The return values are Max/Average/Min percentage of CPU usage ( CPU consumption tick / CPU overall tick ).  The data will be updated in periodically which is corresponding CPU supervision period (default is 10 sec).  (CCA FID: 0x1053)
 */
class CpuUsageStatisticRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CpuUsageStatisticRegister ();

    /**
     * Copy constructor
     */
    inline  CpuUsageStatisticRegister (const CpuUsageStatisticRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CpuUsageStatisticRegister();

    /**
     * Assignment operator
     */
    inline CpuUsageStatisticRegister& operator = (const CpuUsageStatisticRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CpuUsageStatisticRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CpuUsageStatisticRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CpuUsageStatisticRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CpuUsageStatisticRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CpuUsageStatisticRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
 */
class RamUsageStatisticUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RamUsageStatisticUpdate ();

    /**
     * Copy constructor
     */
    inline  RamUsageStatisticUpdate (const RamUsageStatisticUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RamUsageStatisticUpdate (const T_SPM_SystemStatisticsData& RamUsageStatistic_);

    /**
     * Destructor
     */
    inline virtual  ~RamUsageStatisticUpdate();

    /**
     * Assignment operator
     */
    inline RamUsageStatisticUpdate& operator = (const RamUsageStatisticUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RamUsageStatisticUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RamUsageStatisticUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RamUsageStatisticUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RamUsageStatisticUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RamUsageStatistic"

    static const int kRamUsageStatistic = 0;

    /**
     * Clears the field "RamUsageStatistic".
     *
     * The field will be set to its default value. The hasRamUsageStatistic()
     * method will return false.
     */
    inline void clearRamUsageStatistic();

    /**
     * Checks whether the field "RamUsageStatistic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRamUsageStatistic()). Otherwise it will return false.
     */
    inline bool hasRamUsageStatistic () const;

    /**
     * Returns the value of the member "RamUsageStatistic".
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     *
     * @return The value of the field "RamUsageStatistic"
     */
    inline const T_SPM_SystemStatisticsData& getRamUsageStatistic () const;

    /**
     * Retrieves the value of the field "RamUsageStatistic" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RamUsageStatistic".
     */
    inline T_SPM_SystemStatisticsData& getRamUsageStatisticMutable ();

    /**
     * Sets the value of the member "RamUsageStatistic".
     *
     * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
     *
     * @param RamUsageStatistic The value which will be set
     */
    inline void setRamUsageStatistic (const T_SPM_SystemStatisticsData& RamUsageStatistic_);

    static const RamUsageStatisticUpdate &getDefaultInstance();

private:

    inline void set_has_RamUsageStatistic ();

    inline void clear_has_RamUsageStatistic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_SystemStatisticsData _RamUsageStatistic;

};

/**
 * RAM usage of device. The return values are Max/Average/Min percentage of RAM usage ( RAM consumption size / total RAM size ).  The data will be updated in periodically which is corresponding RAM supervision period (default is 10 sec).  (CCA FID: 0x1054)
 */
class RamUsageStatisticRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RamUsageStatisticRegister ();

    /**
     * Copy constructor
     */
    inline  RamUsageStatisticRegister (const RamUsageStatisticRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RamUsageStatisticRegister();

    /**
     * Assignment operator
     */
    inline RamUsageStatisticRegister& operator = (const RamUsageStatisticRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RamUsageStatisticRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RamUsageStatisticRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RamUsageStatisticRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RamUsageStatisticRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RamUsageStatisticRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
 */
class StartupTimeStatisticUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupTimeStatisticUpdate ();

    /**
     * Copy constructor
     */
    inline  StartupTimeStatisticUpdate (const StartupTimeStatisticUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StartupTimeStatisticUpdate (const T_SPM_SystemStatisticsData& StartupTimeStatistic_);

    /**
     * Destructor
     */
    inline virtual  ~StartupTimeStatisticUpdate();

    /**
     * Assignment operator
     */
    inline StartupTimeStatisticUpdate& operator = (const StartupTimeStatisticUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupTimeStatisticUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupTimeStatisticUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupTimeStatisticUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupTimeStatisticUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartupTimeStatistic"

    static const int kStartupTimeStatistic = 0;

    /**
     * Clears the field "StartupTimeStatistic".
     *
     * The field will be set to its default value. The hasStartupTimeStatistic()
     * method will return false.
     */
    inline void clearStartupTimeStatistic();

    /**
     * Checks whether the field "StartupTimeStatistic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartupTimeStatistic()). Otherwise it will return false.
     */
    inline bool hasStartupTimeStatistic () const;

    /**
     * Returns the value of the member "StartupTimeStatistic".
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     *
     * @return The value of the field "StartupTimeStatistic"
     */
    inline const T_SPM_SystemStatisticsData& getStartupTimeStatistic () const;

    /**
     * Retrieves the value of the field "StartupTimeStatistic" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "StartupTimeStatistic".
     */
    inline T_SPM_SystemStatisticsData& getStartupTimeStatisticMutable ();

    /**
     * Sets the value of the member "StartupTimeStatistic".
     *
     * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
     *
     * @param StartupTimeStatistic The value which will be set
     */
    inline void setStartupTimeStatistic (const T_SPM_SystemStatisticsData& StartupTimeStatistic_);

    static const StartupTimeStatisticUpdate &getDefaultInstance();

private:

    inline void set_has_StartupTimeStatistic ();

    inline void clear_has_StartupTimeStatistic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_SystemStatisticsData _StartupTimeStatistic;

};

/**
 * Startup time of device. The return values are Max/Average/Min of start-up time in milliseconds.  The data will be updated every start-up when the STARTUP_STATE_SYSTEM_UP is reached.  (CCA FID: 0x1055)
 */
class StartupTimeStatisticRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupTimeStatisticRegister ();

    /**
     * Copy constructor
     */
    inline  StartupTimeStatisticRegister (const StartupTimeStatisticRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StartupTimeStatisticRegister();

    /**
     * Assignment operator
     */
    inline StartupTimeStatisticRegister& operator = (const StartupTimeStatisticRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StartupTimeStatisticRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StartupTimeStatisticRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StartupTimeStatisticRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StartupTimeStatisticRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StartupTimeStatisticRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
 */
class RunlevelStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RunlevelStateUpdate ();

    /**
     * Copy constructor
     */
    inline  RunlevelStateUpdate (const RunlevelStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RunlevelStateUpdate (T_SPM_e32_RUNLEVEL RunlevelState_);

    /**
     * Destructor
     */
    inline virtual  ~RunlevelStateUpdate();

    /**
     * Assignment operator
     */
    inline RunlevelStateUpdate& operator = (const RunlevelStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RunlevelStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RunlevelStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RunlevelStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RunlevelStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RunlevelState"

    static const int kRunlevelState = 0;

    /**
     * Clears the field "RunlevelState".
     *
     * The field will be set to its default value. The hasRunlevelState()
     * method will return false.
     */
    inline void clearRunlevelState();

    /**
     * Checks whether the field "RunlevelState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRunlevelState()). Otherwise it will return false.
     */
    inline bool hasRunlevelState () const;

    /**
     * Returns the value of the member "RunlevelState".
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     *
     * @return The value of the field "RunlevelState"
     */
    inline T_SPM_e32_RUNLEVEL getRunlevelState () const;

    /**
     * Sets the value of the member "RunlevelState".
     *
     * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
     *
     * @param RunlevelState The value which will be set
     */
    inline void setRunlevelState (T_SPM_e32_RUNLEVEL RunlevelState_);

    static const RunlevelStateUpdate &getDefaultInstance();

private:

    inline void set_has_RunlevelState ();

    inline void clear_has_RunlevelState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_RUNLEVEL _RunlevelState;

};

/**
 * Informs about the current runlevel of the system.  (CCA FID: 0x1141)
 */
class RunlevelStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RunlevelStateRegister ();

    /**
     * Copy constructor
     */
    inline  RunlevelStateRegister (const RunlevelStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RunlevelStateRegister();

    /**
     * Assignment operator
     */
    inline RunlevelStateRegister& operator = (const RunlevelStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RunlevelStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RunlevelStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RunlevelStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RunlevelStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RunlevelStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
 */
class RestartUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartUpdate ();

    /**
     * Copy constructor
     */
    inline  RestartUpdate (const RestartUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RestartUpdate (T_SPM_e32_RESTART_TYPE Restart_);

    /**
     * Destructor
     */
    inline virtual  ~RestartUpdate();

    /**
     * Assignment operator
     */
    inline RestartUpdate& operator = (const RestartUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Restart"

    static const int kRestart = 0;

    /**
     * Clears the field "Restart".
     *
     * The field will be set to its default value. The hasRestart()
     * method will return false.
     */
    inline void clearRestart();

    /**
     * Checks whether the field "Restart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRestart()). Otherwise it will return false.
     */
    inline bool hasRestart () const;

    /**
     * Returns the value of the member "Restart".
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     *
     * @return The value of the field "Restart"
     */
    inline T_SPM_e32_RESTART_TYPE getRestart () const;

    /**
     * Sets the value of the member "Restart".
     *
     * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
     *
     * @param Restart The value which will be set
     */
    inline void setRestart (T_SPM_e32_RESTART_TYPE Restart_);

    static const RestartUpdate &getDefaultInstance();

private:

    inline void set_has_Restart ();

    inline void clear_has_Restart ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_RESTART_TYPE _Restart;

};

/**
 * OBSOLETE do not use anymore, replaced by Method RestartSystem  (CCA FID: 0x40)
 */
class RestartRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RestartRegister ();

    /**
     * Copy constructor
     */
    inline  RestartRegister (const RestartRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RestartRegister();

    /**
     * Assignment operator
     */
    inline RestartRegister& operator = (const RestartRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RestartRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RestartRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RestartRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RestartRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RestartRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * (CCA FID: 0x0275)
 */
class LifesignUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifesignUpdate ();

    /**
     * Copy constructor
     */
    inline  LifesignUpdate (const LifesignUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  LifesignUpdate (uint32 Lifesign_);

    /**
     * Destructor
     */
    inline virtual  ~LifesignUpdate();

    /**
     * Assignment operator
     */
    inline LifesignUpdate& operator = (const LifesignUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifesignUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifesignUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifesignUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifesignUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Lifesign"

    static const int kLifesign = 0;

    /**
     * Clears the field "Lifesign".
     *
     * The field will be set to its default value. The hasLifesign()
     * method will return false.
     */
    inline void clearLifesign();

    /**
     * Checks whether the field "Lifesign" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLifesign()). Otherwise it will return false.
     */
    inline bool hasLifesign () const;

    /**
     * Returns the value of the member "Lifesign".
     *
     * (CCA FID: 0x0275)
     *
     * @return The value of the field "Lifesign"
     */
    inline uint32 getLifesign () const;

    /**
     * Sets the value of the member "Lifesign".
     *
     * (CCA FID: 0x0275)
     *
     * @param Lifesign The value which will be set
     */
    inline void setLifesign (uint32 Lifesign_);

    static const LifesignUpdate &getDefaultInstance();

private:

    inline void set_has_Lifesign ();

    inline void clear_has_Lifesign ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _Lifesign;

};

/**
 * (CCA FID: 0x0275)
 */
class LifesignRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  LifesignRegister ();

    /**
     * Copy constructor
     */
    inline  LifesignRegister (const LifesignRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~LifesignRegister();

    /**
     * Assignment operator
     */
    inline LifesignRegister& operator = (const LifesignRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const LifesignRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const LifesignRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const LifesignRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const LifesignRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const LifesignRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set substate of the HMI application.  (CCA FID: 0x10)
 */
class HmiStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HmiStateUpdate ();

    /**
     * Copy constructor
     */
    inline  HmiStateUpdate (const HmiStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  HmiStateUpdate (T_SPM_e32_HMI_STATE HmiState_);

    /**
     * Destructor
     */
    inline virtual  ~HmiStateUpdate();

    /**
     * Assignment operator
     */
    inline HmiStateUpdate& operator = (const HmiStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HmiStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HmiStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HmiStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HmiStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HmiState"

    static const int kHmiState = 0;

    /**
     * Clears the field "HmiState".
     *
     * The field will be set to its default value. The hasHmiState()
     * method will return false.
     */
    inline void clearHmiState();

    /**
     * Checks whether the field "HmiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHmiState()). Otherwise it will return false.
     */
    inline bool hasHmiState () const;

    /**
     * Returns the value of the member "HmiState".
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     *
     * @return The value of the field "HmiState"
     */
    inline T_SPM_e32_HMI_STATE getHmiState () const;

    /**
     * Sets the value of the member "HmiState".
     *
     * Set substate of the HMI application.  (CCA FID: 0x10)
     *
     * @param HmiState The value which will be set
     */
    inline void setHmiState (T_SPM_e32_HMI_STATE HmiState_);

    static const HmiStateUpdate &getDefaultInstance();

private:

    inline void set_has_HmiState ();

    inline void clear_has_HmiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_HMI_STATE _HmiState;

};

/**
 * Set substate of the HMI application.  (CCA FID: 0x10)
 */
class HmiStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  HmiStateRegister ();

    /**
     * Copy constructor
     */
    inline  HmiStateRegister (const HmiStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~HmiStateRegister();

    /**
     * Assignment operator
     */
    inline HmiStateRegister& operator = (const HmiStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const HmiStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const HmiStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const HmiStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const HmiStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const HmiStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
 */
class SystemPowerBehaviourUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPowerBehaviourUpdate ();

    /**
     * Copy constructor
     */
    inline  SystemPowerBehaviourUpdate (const SystemPowerBehaviourUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SystemPowerBehaviourUpdate (T_SPM_e32_SYSPWR_BEHAVIOUR SystemPowerBehaviour_);

    /**
     * Destructor
     */
    inline virtual  ~SystemPowerBehaviourUpdate();

    /**
     * Assignment operator
     */
    inline SystemPowerBehaviourUpdate& operator = (const SystemPowerBehaviourUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPowerBehaviourUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPowerBehaviourUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPowerBehaviourUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPowerBehaviourUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SystemPowerBehaviour"

    static const int kSystemPowerBehaviour = 0;

    /**
     * Clears the field "SystemPowerBehaviour".
     *
     * The field will be set to its default value. The hasSystemPowerBehaviour()
     * method will return false.
     */
    inline void clearSystemPowerBehaviour();

    /**
     * Checks whether the field "SystemPowerBehaviour" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSystemPowerBehaviour()). Otherwise it will return false.
     */
    inline bool hasSystemPowerBehaviour () const;

    /**
     * Returns the value of the member "SystemPowerBehaviour".
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     *
     * @return The value of the field "SystemPowerBehaviour"
     */
    inline T_SPM_e32_SYSPWR_BEHAVIOUR getSystemPowerBehaviour () const;

    /**
     * Sets the value of the member "SystemPowerBehaviour".
     *
     * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
     *
     * @param SystemPowerBehaviour The value which will be set
     */
    inline void setSystemPowerBehaviour (T_SPM_e32_SYSPWR_BEHAVIOUR SystemPowerBehaviour_);

    static const SystemPowerBehaviourUpdate &getDefaultInstance();

private:

    inline void set_has_SystemPowerBehaviour ();

    inline void clear_has_SystemPowerBehaviour ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_SYSPWR_BEHAVIOUR _SystemPowerBehaviour;

};

/**
 * Information about special SPM/LCM handled events. E.g. in VW HMI has to display a pop-up when incoming LowBattery status message via CAN is received.  (CCA FID: 0x1010)
 */
class SystemPowerBehaviourRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SystemPowerBehaviourRegister ();

    /**
     * Copy constructor
     */
    inline  SystemPowerBehaviourRegister (const SystemPowerBehaviourRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SystemPowerBehaviourRegister();

    /**
     * Assignment operator
     */
    inline SystemPowerBehaviourRegister& operator = (const SystemPowerBehaviourRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SystemPowerBehaviourRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SystemPowerBehaviourRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SystemPowerBehaviourRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SystemPowerBehaviourRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SystemPowerBehaviourRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
 */
class DimStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimStateUpdate ();

    /**
     * Copy constructor
     */
    inline  DimStateUpdate (const DimStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DimStateUpdate (T_SPM_e32_DIM_STATE DimState_);

    /**
     * Destructor
     */
    inline virtual  ~DimStateUpdate();

    /**
     * Assignment operator
     */
    inline DimStateUpdate& operator = (const DimStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimState"

    static const int kDimState = 0;

    /**
     * Clears the field "DimState".
     *
     * The field will be set to its default value. The hasDimState()
     * method will return false.
     */
    inline void clearDimState();

    /**
     * Checks whether the field "DimState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimState()). Otherwise it will return false.
     */
    inline bool hasDimState () const;

    /**
     * Returns the value of the member "DimState".
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     *
     * @return The value of the field "DimState"
     */
    inline T_SPM_e32_DIM_STATE getDimState () const;

    /**
     * Sets the value of the member "DimState".
     *
     * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
     *
     * @param DimState The value which will be set
     */
    inline void setDimState (T_SPM_e32_DIM_STATE DimState_);

    static const DimStateUpdate &getDefaultInstance();

private:

    inline void set_has_DimState ();

    inline void clear_has_DimState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_DIM_STATE _DimState;

};

/**
 * !!! OBSOLETE DO NOT USE ANYMORE !!! -- use bit-coded property DimmingState with same functionality. Set substate of the DIMMING application.  (CCA FID: 0x11)
 */
class DimStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimStateRegister ();

    /**
     * Copy constructor
     */
    inline  DimStateRegister (const DimStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DimStateRegister();

    /**
     * Assignment operator
     */
    inline DimStateRegister& operator = (const DimStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DimStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
 */
class DimmingStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimmingStateUpdate ();

    /**
     * Copy constructor
     */
    inline  DimmingStateUpdate (const DimmingStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DimmingStateUpdate (const T_SPM_b32_DIM_STATE& DimmingState_);

    /**
     * Destructor
     */
    inline virtual  ~DimmingStateUpdate();

    /**
     * Assignment operator
     */
    inline DimmingStateUpdate& operator = (const DimmingStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimmingStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimmingStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimmingStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimmingStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DimmingState"

    static const int kDimmingState = 0;

    /**
     * Clears the field "DimmingState".
     *
     * The field will be set to its default value. The hasDimmingState()
     * method will return false.
     */
    inline void clearDimmingState();

    /**
     * Checks whether the field "DimmingState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDimmingState()). Otherwise it will return false.
     */
    inline bool hasDimmingState () const;

    /**
     * Returns the value of the member "DimmingState".
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     *
     * @return The value of the field "DimmingState"
     */
    inline const T_SPM_b32_DIM_STATE& getDimmingState () const;

    /**
     * Retrieves the value of the field "DimmingState" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DimmingState".
     */
    inline T_SPM_b32_DIM_STATE& getDimmingStateMutable ();

    /**
     * Sets the value of the member "DimmingState".
     *
     * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
     *
     * @param DimmingState The value which will be set
     */
    inline void setDimmingState (const T_SPM_b32_DIM_STATE& DimmingState_);

    static const DimmingStateUpdate &getDefaultInstance();

private:

    inline void set_has_DimmingState ();

    inline void clear_has_DimmingState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_b32_DIM_STATE _DimmingState;

};

/**
 * Information about dimming states from LCM point of view for e.g. backlight.  (CCA FID: 0x1011)
 */
class DimmingStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DimmingStateRegister ();

    /**
     * Copy constructor
     */
    inline  DimmingStateRegister (const DimmingStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DimmingStateRegister();

    /**
     * Assignment operator
     */
    inline DimmingStateRegister& operator = (const DimmingStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DimmingStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DimmingStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DimmingStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DimmingStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DimmingStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
 */
class BluetoothStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothStateUpdate ();

    /**
     * Copy constructor
     */
    inline  BluetoothStateUpdate (const BluetoothStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  BluetoothStateUpdate (T_SPM_e32_BT_STATE BluetoothState_);

    /**
     * Destructor
     */
    inline virtual  ~BluetoothStateUpdate();

    /**
     * Assignment operator
     */
    inline BluetoothStateUpdate& operator = (const BluetoothStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BluetoothState"

    static const int kBluetoothState = 0;

    /**
     * Clears the field "BluetoothState".
     *
     * The field will be set to its default value. The hasBluetoothState()
     * method will return false.
     */
    inline void clearBluetoothState();

    /**
     * Checks whether the field "BluetoothState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBluetoothState()). Otherwise it will return false.
     */
    inline bool hasBluetoothState () const;

    /**
     * Returns the value of the member "BluetoothState".
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     *
     * @return The value of the field "BluetoothState"
     */
    inline T_SPM_e32_BT_STATE getBluetoothState () const;

    /**
     * Sets the value of the member "BluetoothState".
     *
     * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
     *
     * @param BluetoothState The value which will be set
     */
    inline void setBluetoothState (T_SPM_e32_BT_STATE BluetoothState_);

    static const BluetoothStateUpdate &getDefaultInstance();

private:

    inline void set_has_BluetoothState ();

    inline void clear_has_BluetoothState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_BT_STATE _BluetoothState;

};

/**
 * Set application specific substate of the phone applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x13)
 */
class BluetoothStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BluetoothStateRegister ();

    /**
     * Copy constructor
     */
    inline  BluetoothStateRegister (const BluetoothStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~BluetoothStateRegister();

    /**
     * Assignment operator
     */
    inline BluetoothStateRegister& operator = (const BluetoothStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BluetoothStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BluetoothStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BluetoothStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BluetoothStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const BluetoothStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
 */
class AudioStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateUpdate ();

    /**
     * Copy constructor
     */
    inline  AudioStateUpdate (const AudioStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  AudioStateUpdate (T_SPM_e32_AUDIO_STATE AudioState_);

    /**
     * Destructor
     */
    inline virtual  ~AudioStateUpdate();

    /**
     * Assignment operator
     */
    inline AudioStateUpdate& operator = (const AudioStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AudioState"

    static const int kAudioState = 0;

    /**
     * Clears the field "AudioState".
     *
     * The field will be set to its default value. The hasAudioState()
     * method will return false.
     */
    inline void clearAudioState();

    /**
     * Checks whether the field "AudioState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioState()). Otherwise it will return false.
     */
    inline bool hasAudioState () const;

    /**
     * Returns the value of the member "AudioState".
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     *
     * @return The value of the field "AudioState"
     */
    inline T_SPM_e32_AUDIO_STATE getAudioState () const;

    /**
     * Sets the value of the member "AudioState".
     *
     * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
     *
     * @param AudioState The value which will be set
     */
    inline void setAudioState (T_SPM_e32_AUDIO_STATE AudioState_);

    static const AudioStateUpdate &getDefaultInstance();

private:

    inline void set_has_AudioState ();

    inline void clear_has_AudioState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_AUDIO_STATE _AudioState;

};

/**
 * Set application specific substate of the audio applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x14)
 */
class AudioStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AudioStateRegister ();

    /**
     * Copy constructor
     */
    inline  AudioStateRegister (const AudioStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~AudioStateRegister();

    /**
     * Assignment operator
     */
    inline AudioStateRegister& operator = (const AudioStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AudioStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AudioStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AudioStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AudioStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const AudioStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
 */
class SpiStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpiStateUpdate ();

    /**
     * Copy constructor
     */
    inline  SpiStateUpdate (const SpiStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SpiStateUpdate (T_SPM_e32_SPI_STATE SpiState_);

    /**
     * Destructor
     */
    inline virtual  ~SpiStateUpdate();

    /**
     * Assignment operator
     */
    inline SpiStateUpdate& operator = (const SpiStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpiStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpiStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpiStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpiStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SpiState"

    static const int kSpiState = 0;

    /**
     * Clears the field "SpiState".
     *
     * The field will be set to its default value. The hasSpiState()
     * method will return false.
     */
    inline void clearSpiState();

    /**
     * Checks whether the field "SpiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSpiState()). Otherwise it will return false.
     */
    inline bool hasSpiState () const;

    /**
     * Returns the value of the member "SpiState".
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     *
     * @return The value of the field "SpiState"
     */
    inline T_SPM_e32_SPI_STATE getSpiState () const;

    /**
     * Sets the value of the member "SpiState".
     *
     * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
     *
     * @param SpiState The value which will be set
     */
    inline void setSpiState (T_SPM_e32_SPI_STATE SpiState_);

    static const SpiStateUpdate &getDefaultInstance();

private:

    inline void set_has_SpiState ();

    inline void clear_has_SpiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_SPI_STATE _SpiState;

};

/**
 * Set application specific substate of the SmartPhoneIntegration applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x15)
 */
class SpiStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SpiStateRegister ();

    /**
     * Copy constructor
     */
    inline  SpiStateRegister (const SpiStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SpiStateRegister();

    /**
     * Assignment operator
     */
    inline SpiStateRegister& operator = (const SpiStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SpiStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SpiStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SpiStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SpiStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SpiStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
 */
class TunerStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TunerStateUpdate ();

    /**
     * Copy constructor
     */
    inline  TunerStateUpdate (const TunerStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TunerStateUpdate (T_SPM_e32_TUNER_STATE TunerState_);

    /**
     * Destructor
     */
    inline virtual  ~TunerStateUpdate();

    /**
     * Assignment operator
     */
    inline TunerStateUpdate& operator = (const TunerStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TunerStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TunerStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TunerStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TunerStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerState"

    static const int kTunerState = 0;

    /**
     * Clears the field "TunerState".
     *
     * The field will be set to its default value. The hasTunerState()
     * method will return false.
     */
    inline void clearTunerState();

    /**
     * Checks whether the field "TunerState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerState()). Otherwise it will return false.
     */
    inline bool hasTunerState () const;

    /**
     * Returns the value of the member "TunerState".
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     *
     * @return The value of the field "TunerState"
     */
    inline T_SPM_e32_TUNER_STATE getTunerState () const;

    /**
     * Sets the value of the member "TunerState".
     *
     * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
     *
     * @param TunerState The value which will be set
     */
    inline void setTunerState (T_SPM_e32_TUNER_STATE TunerState_);

    static const TunerStateUpdate &getDefaultInstance();

private:

    inline void set_has_TunerState ();

    inline void clear_has_TunerState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_TUNER_STATE _TunerState;

};

/**
 * Set application specific substate of the Tuner applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x17)
 */
class TunerStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TunerStateRegister ();

    /**
     * Copy constructor
     */
    inline  TunerStateRegister (const TunerStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TunerStateRegister();

    /**
     * Assignment operator
     */
    inline TunerStateRegister& operator = (const TunerStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TunerStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TunerStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TunerStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TunerStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TunerStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
 */
class WifiStateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiStateUpdate ();

    /**
     * Copy constructor
     */
    inline  WifiStateUpdate (const WifiStateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WifiStateUpdate (T_SPM_e32_WIFI_STATE WifiState_);

    /**
     * Destructor
     */
    inline virtual  ~WifiStateUpdate();

    /**
     * Assignment operator
     */
    inline WifiStateUpdate& operator = (const WifiStateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiStateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiStateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiStateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiStateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WifiState"

    static const int kWifiState = 0;

    /**
     * Clears the field "WifiState".
     *
     * The field will be set to its default value. The hasWifiState()
     * method will return false.
     */
    inline void clearWifiState();

    /**
     * Checks whether the field "WifiState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWifiState()). Otherwise it will return false.
     */
    inline bool hasWifiState () const;

    /**
     * Returns the value of the member "WifiState".
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     *
     * @return The value of the field "WifiState"
     */
    inline T_SPM_e32_WIFI_STATE getWifiState () const;

    /**
     * Sets the value of the member "WifiState".
     *
     * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
     *
     * @param WifiState The value which will be set
     */
    inline void setWifiState (T_SPM_e32_WIFI_STATE WifiState_);

    static const WifiStateUpdate &getDefaultInstance();

private:

    inline void set_has_WifiState ();

    inline void clear_has_WifiState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_WIFI_STATE _WifiState;

};

/**
 * Set application specific substate of the connectivity applications. LCM sets this State according to the SystemState. This will be project specific.  (CCA FID: 0x19)
 */
class WifiStateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WifiStateRegister ();

    /**
     * Copy constructor
     */
    inline  WifiStateRegister (const WifiStateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WifiStateRegister();

    /**
     * Assignment operator
     */
    inline WifiStateRegister& operator = (const WifiStateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WifiStateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WifiStateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WifiStateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WifiStateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WifiStateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
 */
class OnOffReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  OnOffReasonUpdate (const OnOffReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  OnOffReasonUpdate (T_SPM_e32_OnOffReason OnOffReason_);

    /**
     * Destructor
     */
    inline virtual  ~OnOffReasonUpdate();

    /**
     * Assignment operator
     */
    inline OnOffReasonUpdate& operator = (const OnOffReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "OnOffReason"

    static const int kOnOffReason = 0;

    /**
     * Clears the field "OnOffReason".
     *
     * The field will be set to its default value. The hasOnOffReason()
     * method will return false.
     */
    inline void clearOnOffReason();

    /**
     * Checks whether the field "OnOffReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOnOffReason()). Otherwise it will return false.
     */
    inline bool hasOnOffReason () const;

    /**
     * Returns the value of the member "OnOffReason".
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     *
     * @return The value of the field "OnOffReason"
     */
    inline T_SPM_e32_OnOffReason getOnOffReason () const;

    /**
     * Sets the value of the member "OnOffReason".
     *
     * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
     *
     * @param OnOffReason The value which will be set
     */
    inline void setOnOffReason (T_SPM_e32_OnOffReason OnOffReason_);

    static const OnOffReasonUpdate &getDefaultInstance();

private:

    inline void set_has_OnOffReason ();

    inline void clear_has_OnOffReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_SPM_e32_OnOffReason _OnOffReason;

};

/**
 * OBSOLETE INTERFACE, ONLY STILL HERE FOR MY16 DIAGNOSIS, will be removed soon! Set a new OnOff reason. New system state will be calculated. FUNCID = FID_SPM_SUBSTATE, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAGDEBUG, CCA_C_U16_APP_DOWNLOAD  (CCA FID: 0x02)
 */
class OnOffReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  OnOffReasonRegister ();

    /**
     * Copy constructor
     */
    inline  OnOffReasonRegister (const OnOffReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~OnOffReasonRegister();

    /**
     * Assignment operator
     */
    inline OnOffReasonRegister& operator = (const OnOffReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const OnOffReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const OnOffReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const OnOffReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const OnOffReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const OnOffReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
 */
class WakeupListUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupListUpdate ();

    /**
     * Copy constructor
     */
    inline  WakeupListUpdate (const WakeupListUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  WakeupListUpdate (const TWakeupList& WakeupList_);

    /**
     * Destructor
     */
    inline virtual  ~WakeupListUpdate();

    /**
     * Assignment operator
     */
    inline WakeupListUpdate& operator = (const WakeupListUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupListUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupListUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupListUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupListUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "WakeupList"

    static const int kWakeupList = 0;

    /**
     * Clears the field "WakeupList".
     *
     * The field will be set to its default value. The hasWakeupList()
     * method will return false.
     */
    inline void clearWakeupList();

    /**
     * Checks whether the field "WakeupList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setWakeupList()). Otherwise it will return false.
     */
    inline bool hasWakeupList () const;

    /**
     * Returns the value of the member "WakeupList".
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     *
     * @return The value of the field "WakeupList"
     */
    inline const TWakeupList& getWakeupList () const;

    /**
     * Retrieves the value of the field "WakeupList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "WakeupList".
     */
    inline TWakeupList& getWakeupListMutable ();

    /**
     * Sets the value of the member "WakeupList".
     *
     * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
     *
     * @param WakeupList The value which will be set
     */
    inline void setWakeupList (const TWakeupList& WakeupList_);

    static const WakeupListUpdate &getDefaultInstance();

private:

    inline void set_has_WakeupList ();

    inline void clear_has_WakeupList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    TWakeupList _WakeupList;

};

/**
 * Get reset count. FUNCID = FID_SPM_WAKEUP_LIST, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_DIAG  (CCA FID: 0x42)
 */
class WakeupListRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WakeupListRegister ();

    /**
     * Copy constructor
     */
    inline  WakeupListRegister (const WakeupListRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~WakeupListRegister();

    /**
     * Assignment operator
     */
    inline WakeupListRegister& operator = (const WakeupListRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WakeupListRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WakeupListRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WakeupListRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WakeupListRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const WakeupListRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * FUNCID = FID_SPM_STARTUP_FINISHED, SERVICEID = CCA_C_U16_SRV_SPM, APPID = CCA_C_U16_APP_SPM, TARGETID	= CCA_C_U16_APP_xx   (CCA FID: 0x0105)
 */
class StartupFinishedUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StartupFinishedUpdate ();

    /**
     * Copy constructor
     */
    inline  StartupFinishedUpdate (const StartupFinishedUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StartupFinishedUpdate (bool StartupFinished_);

    /**
     * Destructor
     */
    inline virtual  ~StartupFinishedUpdate();

    /**
     * Assignment operator
     */
    inline StartupFinishedUpdate& operator = (const StartupFinishedUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True 