#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef INPUT_MAIN_FI_TYPES_H
#define INPUT_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "input_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * Types input_main_fi_types
 */

namespace input_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_KeyInfo;

class T_EncInfo;

class T_EncoderStatus;

class T_TouchInfo;

class T_DevManager_DeviceProperty;

// type definitions
/**
 * If the meaning of "T_DiagKeyList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_KeyInfo > T_DiagKeyList;

/**
 * If the meaning of "T_EncoderDirectionList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_EncInfo > T_EncoderDirectionList;

/**
 * If the meaning of "T_TouchDataList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TouchInfo > T_TouchDataList;


/**
 * This structure contains the all key information
 */
class T_KeyInfo {
public:

    /**
     * Default constructor
     */
    inline  T_KeyInfo ();

    /**
     * Copy constructor
     */
    inline  T_KeyInfo (const T_KeyInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_KeyInfo (T_e16_KeyCode e16KeyCode_, uint8 u8KeyStatus_);

    /**
     * Destructor
     */
    inline  ~T_KeyInfo();

    /**
     * Assignment operator
     */
    inline T_KeyInfo& operator = (const T_KeyInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_KeyInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_KeyInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_KeyInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_KeyInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e16KeyCode"

    static const int kE16KeyCode = 0;

    /**
     * Clears the field "e16KeyCode".
     *
     * The field will be set to its default value. The hasE16KeyCode()
     * method will return false.
     */
    inline void clearE16KeyCode();

    /**
     * Checks whether the field "e16KeyCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE16KeyCode()). Otherwise it will return false.
     */
    inline bool hasE16KeyCode () const;

    /**
     * Returns the value of the member "e16KeyCode".
     *
     * Contains HMI Key Code Value
     *
     * @return The value of the field "e16KeyCode"
     */
    inline T_e16_KeyCode getE16KeyCode () const;

    /**
     * Sets the value of the member "e16KeyCode".
     *
     * Contains HMI Key Code Value
     *
     * @param e16KeyCode The value which will be set
     */
    inline void setE16KeyCode (T_e16_KeyCode e16KeyCode_);

    // API of field "u8KeyStatus"

    static const int kU8KeyStatus = 1;

    /**
     * Clears the field "u8KeyStatus".
     *
     * The field will be set to its default value. The hasU8KeyStatus()
     * method will return false.
     */
    inline void clearU8KeyStatus();

    /**
     * Checks whether the field "u8KeyStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8KeyStatus()). Otherwise it will return false.
     */
    inline bool hasU8KeyStatus () const;

    /**
     * Returns the value of the member "u8KeyStatus".
     *
     * Status = 1 indicates key Press and 0 Indicates Release. Status = 2 Indicates delayed release used for 2sec requirement.
     *
     * @return The value of the field "u8KeyStatus"
     */
    inline uint8 getU8KeyStatus () const;

    /**
     * Sets the value of the member "u8KeyStatus".
     *
     * Status = 1 indicates key Press and 0 Indicates Release. Status = 2 Indicates delayed release used for 2sec requirement.
     *
     * @param u8KeyStatus The value which will be set
     */
    inline void setU8KeyStatus (uint8 u8KeyStatus_);

    static const T_KeyInfo &getDefaultInstance();

private:

    inline void set_has_e16KeyCode ();

    inline void clear_has_e16KeyCode ();

    inline void set_has_u8KeyStatus ();

    inline void clear_has_u8KeyStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e16_KeyCode _e16KeyCode;

    uint8 _u8KeyStatus;

};

/**
 * This structure contains the all Encoder information
 */
class T_EncInfo {
public:

    /**
     * Default constructor
     */
    inline  T_EncInfo ();

    /**
     * Copy constructor
     */
    inline  T_EncInfo (const T_EncInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_EncInfo (T_e8_EncoderType e8EncoderType_, int8 s8EncSteps_);

    /**
     * Destructor
     */
    inline  ~T_EncInfo();

    /**
     * Assignment operator
     */
    inline T_EncInfo& operator = (const T_EncInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EncInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EncInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EncInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EncInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8EncoderType"

    static const int kE8EncoderType = 0;

    /**
     * Clears the field "e8EncoderType".
     *
     * The field will be set to its default value. The hasE8EncoderType()
     * method will return false.
     */
    inline void clearE8EncoderType();

    /**
     * Checks whether the field "e8EncoderType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EncoderType()). Otherwise it will return false.
     */
    inline bool hasE8EncoderType () const;

    /**
     * Returns the value of the member "e8EncoderType".
     *
     * Contains Encoder Type LEFT or RIGHT or MSM or JOYSTICK or SWRC
     *
     * @return The value of the field "e8EncoderType"
     */
    inline T_e8_EncoderType getE8EncoderType () const;

    /**
     * Sets the value of the member "e8EncoderType".
     *
     * Contains Encoder Type LEFT or RIGHT or MSM or JOYSTICK or SWRC
     *
     * @param e8EncoderType The value which will be set
     */
    inline void setE8EncoderType (T_e8_EncoderType e8EncoderType_);

    // API of field "s8EncSteps"

    static const int kS8EncSteps = 1;

    /**
     * Clears the field "s8EncSteps".
     *
     * The field will be set to its default value. The hasS8EncSteps()
     * method will return false.
     */
    inline void clearS8EncSteps();

    /**
     * Checks whether the field "s8EncSteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncSteps()). Otherwise it will return false.
     */
    inline bool hasS8EncSteps () const;

    /**
     * Returns the value of the member "s8EncSteps".
     *
     * <p>+ve Value indicates ClockWise Rotation.</p>
     * <p>-ve Value Indicates Anticlockwise Rotation.</p>
     *
     * @return The value of the field "s8EncSteps"
     */
    inline int8 getS8EncSteps () const;

    /**
     * Sets the value of the member "s8EncSteps".
     *
     * <p>+ve Value indicates ClockWise Rotation.</p>
     * <p>-ve Value Indicates Anticlockwise Rotation.</p>
     *
     * @param s8EncSteps The value which will be set
     */
    inline void setS8EncSteps (int8 s8EncSteps_);

    static const T_EncInfo &getDefaultInstance();

private:

    inline void set_has_e8EncoderType ();

    inline void clear_has_e8EncoderType ();

    inline void set_has_s8EncSteps ();

    inline void clear_has_s8EncSteps ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_EncoderType _e8EncoderType;

    int8 _s8EncSteps;

};

/**
 * <p>Enc_1 - Volume or Left Encoder Value</p>
 * <p>Enc_2 - Browse or Right Encoder Value</p>
 * <p>T_EncoderStatus is a structure presently 2 encoders value range from -128 to 127</p>
 */
class T_EncoderStatus {
public:

    /**
     * Default constructor
     */
    inline  T_EncoderStatus ();

    /**
     * Copy constructor
     */
    inline  T_EncoderStatus (const T_EncoderStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_EncoderStatus (int8 s8EncVal_1_, int8 s8EncVal_2_, int8 s8EncVal_3_, int8 s8EncVal_4_, int8 s8EncVal_5_);

    /**
     * Destructor
     */
    inline  ~T_EncoderStatus();

    /**
     * Assignment operator
     */
    inline T_EncoderStatus& operator = (const T_EncoderStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_EncoderStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_EncoderStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_EncoderStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_EncoderStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s8EncVal_1"

    static const int kS8EncVal_1 = 0;

    /**
     * Clears the field "s8EncVal_1".
     *
     * The field will be set to its default value. The hasS8EncVal_1()
     * method will return false.
     */
    inline void clearS8EncVal_1();

    /**
     * Checks whether the field "s8EncVal_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncVal_1()). Otherwise it will return false.
     */
    inline bool hasS8EncVal_1 () const;

    /**
     * Returns the value of the member "s8EncVal_1".
     *
     * Value of Left or Volume encoder
     *
     * @return The value of the field "s8EncVal_1"
     */
    inline int8 getS8EncVal_1 () const;

    /**
     * Sets the value of the member "s8EncVal_1".
     *
     * Value of Left or Volume encoder
     *
     * @param s8EncVal_1 The value which will be set
     */
    inline void setS8EncVal_1 (int8 s8EncVal_1_);

    // API of field "s8EncVal_2"

    static const int kS8EncVal_2 = 1;

    /**
     * Clears the field "s8EncVal_2".
     *
     * The field will be set to its default value. The hasS8EncVal_2()
     * method will return false.
     */
    inline void clearS8EncVal_2();

    /**
     * Checks whether the field "s8EncVal_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncVal_2()). Otherwise it will return false.
     */
    inline bool hasS8EncVal_2 () const;

    /**
     * Returns the value of the member "s8EncVal_2".
     *
     * Value of Right or Browse encoder
     *
     * @return The value of the field "s8EncVal_2"
     */
    inline int8 getS8EncVal_2 () const;

    /**
     * Sets the value of the member "s8EncVal_2".
     *
     * Value of Right or Browse encoder
     *
     * @param s8EncVal_2 The value which will be set
     */
    inline void setS8EncVal_2 (int8 s8EncVal_2_);

    // API of field "s8EncVal_3"

    static const int kS8EncVal_3 = 2;

    /**
     * Clears the field "s8EncVal_3".
     *
     * The field will be set to its default value. The hasS8EncVal_3()
     * method will return false.
     */
    inline void clearS8EncVal_3();

    /**
     * Checks whether the field "s8EncVal_3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncVal_3()). Otherwise it will return false.
     */
    inline bool hasS8EncVal_3 () const;

    /**
     * Returns the value of the member "s8EncVal_3".
     *
     * Value of MSM encoder
     *
     * @return The value of the field "s8EncVal_3"
     */
    inline int8 getS8EncVal_3 () const;

    /**
     * Sets the value of the member "s8EncVal_3".
     *
     * Value of MSM encoder
     *
     * @param s8EncVal_3 The value which will be set
     */
    inline void setS8EncVal_3 (int8 s8EncVal_3_);

    // API of field "s8EncVal_4"

    static const int kS8EncVal_4 = 3;

    /**
     * Clears the field "s8EncVal_4".
     *
     * The field will be set to its default value. The hasS8EncVal_4()
     * method will return false.
     */
    inline void clearS8EncVal_4();

    /**
     * Checks whether the field "s8EncVal_4" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncVal_4()). Otherwise it will return false.
     */
    inline bool hasS8EncVal_4 () const;

    /**
     * Returns the value of the member "s8EncVal_4".
     *
     * Value of Joystick encoder
     *
     * @return The value of the field "s8EncVal_4"
     */
    inline int8 getS8EncVal_4 () const;

    /**
     * Sets the value of the member "s8EncVal_4".
     *
     * Value of Joystick encoder
     *
     * @param s8EncVal_4 The value which will be set
     */
    inline void setS8EncVal_4 (int8 s8EncVal_4_);

    // API of field "s8EncVal_5"

    static const int kS8EncVal_5 = 4;

    /**
     * Clears the field "s8EncVal_5".
     *
     * The field will be set to its default value. The hasS8EncVal_5()
     * method will return false.
     */
    inline void clearS8EncVal_5();

    /**
     * Checks whether the field "s8EncVal_5" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncVal_5()). Otherwise it will return false.
     */
    inline bool hasS8EncVal_5 () const;

    /**
     * Returns the value of the member "s8EncVal_5".
     *
     * Value of SWRC encoder
     *
     * @return The value of the field "s8EncVal_5"
     */
    inline int8 getS8EncVal_5 () const;

    /**
     * Sets the value of the member "s8EncVal_5".
     *
     * Value of SWRC encoder
     *
     * @param s8EncVal_5 The value which will be set
     */
    inline void setS8EncVal_5 (int8 s8EncVal_5_);

    static const T_EncoderStatus &getDefaultInstance();

private:

    inline void set_has_s8EncVal_1 ();

    inline void clear_has_s8EncVal_1 ();

    inline void set_has_s8EncVal_2 ();

    inline void clear_has_s8EncVal_2 ();

    inline void set_has_s8EncVal_3 ();

    inline void clear_has_s8EncVal_3 ();

    inline void set_has_s8EncVal_4 ();

    inline void clear_has_s8EncVal_4 ();

    inline void set_has_s8EncVal_5 ();

    inline void clear_has_s8EncVal_5 ();

    uint32 _has_bits_[ (5 + 31) / 32];

    int8 _s8EncVal_1;

    int8 _s8EncVal_2;

    int8 _s8EncVal_3;

    int8 _s8EncVal_4;

    int8 _s8EncVal_5;

};

/**
 * This structure contains the all Touch information
 */
class T_TouchInfo {
public:

    /**
     * Default constructor
     */
    inline  T_TouchInfo ();

    /**
     * Copy constructor
     */
    inline  T_TouchInfo (const T_TouchInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_TouchInfo (T_e8_TouchStatus e8TouchStatus_, int32 s32XCoord_, int32 s32YCoord_);

    /**
     * Destructor
     */
    inline  ~T_TouchInfo();

    /**
     * Assignment operator
     */
    inline T_TouchInfo& operator = (const T_TouchInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TouchInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TouchInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TouchInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TouchInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TouchStatus"

    static const int kE8TouchStatus = 0;

    /**
     * Clears the field "e8TouchStatus".
     *
     * The field will be set to its default value. The hasE8TouchStatus()
     * method will return false.
     */
    inline void clearE8TouchStatus();

    /**
     * Checks whether the field "e8TouchStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TouchStatus()). Otherwise it will return false.
     */
    inline bool hasE8TouchStatus () const;

    /**
     * Returns the value of the member "e8TouchStatus".
     *
     * <p>0 - Touch Released.</p>
     * <p>1 - Touch Pressed</p>
     *
     * @return The value of the field "e8TouchStatus"
     */
    inline T_e8_TouchStatus getE8TouchStatus () const;

    /**
     * Sets the value of the member "e8TouchStatus".
     *
     * <p>0 - Touch Released.</p>
     * <p>1 - Touch Pressed</p>
     *
     * @param e8TouchStatus The value which will be set
     */
    inline void setE8TouchStatus (T_e8_TouchStatus e8TouchStatus_);

    // API of field "s32XCoord"

    static const int kS32XCoord = 1;

    /**
     * Clears the field "s32XCoord".
     *
     * The field will be set to its default value. The hasS32XCoord()
     * method will return false.
     */
    inline void clearS32XCoord();

    /**
     * Checks whether the field "s32XCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XCoord()). Otherwise it will return false.
     */
    inline bool hasS32XCoord () const;

    /**
     * Returns the value of the member "s32XCoord".
     *
     * Contains X coordinate value
     *
     * @return The value of the field "s32XCoord"
     */
    inline int32 getS32XCoord () const;

    /**
     * Sets the value of the member "s32XCoord".
     *
     * Contains X coordinate value
     *
     * @param s32XCoord The value which will be set
     */
    inline void setS32XCoord (int32 s32XCoord_);

    // API of field "s32YCoord"

    static const int kS32YCoord = 2;

    /**
     * Clears the field "s32YCoord".
     *
     * The field will be set to its default value. The hasS32YCoord()
     * method will return false.
     */
    inline void clearS32YCoord();

    /**
     * Checks whether the field "s32YCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YCoord()). Otherwise it will return false.
     */
    inline bool hasS32YCoord () const;

    /**
     * Returns the value of the member "s32YCoord".
     *
     * Contains Y Coordinate Value
     *
     * @return The value of the field "s32YCoord"
     */
    inline int32 getS32YCoord () const;

    /**
     * Sets the value of the member "s32YCoord".
     *
     * Contains Y Coordinate Value
     *
     * @param s32YCoord The value which will be set
     */
    inline void setS32YCoord (int32 s32YCoord_);

    static const T_TouchInfo &getDefaultInstance();

private:

    inline void set_has_e8TouchStatus ();

    inline void clear_has_e8TouchStatus ();

    inline void set_has_s32XCoord ();

    inline void clear_has_s32XCoord ();

    inline void set_has_s32YCoord ();

    inline void clear_has_s32YCoord ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_TouchStatus _e8TouchStatus;

    int32 _s32XCoord;

    int32 _s32YCoord;

};

/**
 * Type of the device connected
 */
class T_DevManager_DeviceProperty {
public:

    /**
     * Default constructor
     */
    inline  T_DevManager_DeviceProperty ();

    /**
     * Copy constructor
     */
    inline  T_DevManager_DeviceProperty (const T_DevManager_DeviceProperty &rhs);

    /**
     * All fields constructor
     */
    inline  T_DevManager_DeviceProperty (T_e8_DeviceConnectStatus DeviceConnectStatus_, T_e8_Device DeviceType_, const ::std::string& DeviceName_);

    /**
     * Destructor
     */
    inline  ~T_DevManager_DeviceProperty();

    /**
     * Assignment operator
     */
    inline T_DevManager_DeviceProperty& operator = (const T_DevManager_DeviceProperty& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_DevManager_DeviceProperty& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceConnectStatus"

    static const int kDeviceConnectStatus = 0;

    /**
     * Clears the field "DeviceConnectStatus".
     *
     * The field will be set to its default value. The hasDeviceConnectStatus()
     * method will return false.
     */
    inline void clearDeviceConnectStatus();

    /**
     * Checks whether the field "DeviceConnectStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectStatus () const;

    /**
     * Returns the value of the member "DeviceConnectStatus".
     *
     * The connect status of device e.g. plugged in but disabled due to low volt or connected to be usable etc.
     *
     * @return The value of the field "DeviceConnectStatus"
     */
    inline T_e8_DeviceConnectStatus getDeviceConnectStatus () const;

    /**
     * Sets the value of the member "DeviceConnectStatus".
     *
     * The connect status of device e.g. plugged in but disabled due to low volt or connected to be usable etc.
     *
     * @param DeviceConnectStatus The value which will be set
     */
    inline void setDeviceConnectStatus (T_e8_DeviceConnectStatus DeviceConnectStatus_);

    // API of field "DeviceType"

    static const int kDeviceType = 1;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * Type of device connected
     *
     * @return The value of the field "DeviceType"
     */
    inline T_e8_Device getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * Type of device connected
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (T_e8_Device DeviceType_);

    // API of field "DeviceName"

    static const int kDeviceName = 2;

    /**
     * Clears the field "DeviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "DeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @return The value of the field "DeviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "DeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * The friendly name of the device inserted or removed from the system
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    static const T_DevManager_DeviceProperty &getDefaultInstance();

private:

    inline void set_has_DeviceConnectStatus ();

    inline void clear_has_DeviceConnectStatus ();

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    inline void set_has_DeviceName ();

    inline void clear_has_DeviceName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_DeviceConnectStatus _DeviceConnectStatus;

    T_e8_Device _DeviceType;

    ::std::string _DeviceName;

};

inline  T_KeyInfo::T_KeyInfo ()  :
    _e16KeyCode (::input_main_fi_types::T_e16_KeyCode__INPUT_HK_APP),
    _u8KeyStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_KeyInfo::T_KeyInfo (const T_KeyInfo &rhs)  :
    _e16KeyCode (::input_main_fi_types::T_e16_KeyCode__INPUT_HK_APP),
    _u8KeyStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_KeyInfo::T_KeyInfo (T_e16_KeyCode e16KeyCode_, uint8 u8KeyStatus_)  :
    _e16KeyCode (e16KeyCode_),
    _u8KeyStatus (u8KeyStatus_)
{
    #ifndef NDEBUG
    if (!(T_e16_KeyCode_IsValid(e16KeyCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e16KeyCode_, "T_e16_KeyCode", "e16KeyCode", "T_KeyInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_KeyInfo::~T_KeyInfo() {
}

inline T_KeyInfo& T_KeyInfo::operator = (const T_KeyInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE16KeyCode()) {
            setE16KeyCode(rhs.getE16KeyCode());
        } else {
            clearE16KeyCode();
        }
        if (rhs.hasU8KeyStatus()) {
            setU8KeyStatus(rhs.getU8KeyStatus());
        } else {
            clearU8KeyStatus();
        }
    }
    return *this;
}

inline bool T_KeyInfo::operator == (const T_KeyInfo& rhs) const {
    return (((!hasE16KeyCode() && !rhs.hasE16KeyCode()) || getE16KeyCode() == rhs.getE16KeyCode()) &&
        ((!hasU8KeyStatus() && !rhs.hasU8KeyStatus()) || getU8KeyStatus() == rhs.getU8KeyStatus()));
}

inline bool T_KeyInfo::operator != (const T_KeyInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_KeyInfo::operator < (const T_KeyInfo& rhs) const {
    if (hasE16KeyCode() || rhs.hasE16KeyCode()) {
        if ((uint32)getE16KeyCode() < (uint32)rhs.getE16KeyCode()) return true;
        if ((uint32)getE16KeyCode() > (uint32)rhs.getE16KeyCode()) return false;
    }
    if (hasU8KeyStatus() || rhs.hasU8KeyStatus()) {
        if (getU8KeyStatus() < rhs.getU8KeyStatus()) return true;
        if (getU8KeyStatus() > rhs.getU8KeyStatus()) return false;
    }
    return false;
}

inline bool T_KeyInfo::operator > (const T_KeyInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_KeyInfo::clear() {
    clearE16KeyCode();
    clearU8KeyStatus();
}

inline void T_KeyInfo::clearE16KeyCode() {
    if (hasE16KeyCode()) {
         clear_has_e16KeyCode();
        _e16KeyCode = ::input_main_fi_types::T_e16_KeyCode__INPUT_HK_APP;
     }
}

inline bool T_KeyInfo::hasE16KeyCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e16_KeyCode T_KeyInfo::getE16KeyCode () const {
    return _e16KeyCode;
}

inline void T_KeyInfo::setE16KeyCode (T_e16_KeyCode e16KeyCode_) {
    #ifndef NDEBUG
    if (!(T_e16_KeyCode_IsValid(e16KeyCode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e16KeyCode_, "T_e16_KeyCode", "e16KeyCode", "T_KeyInfo");
    }
    #endif
    set_has_e16KeyCode();
    this->_e16KeyCode = e16KeyCode_;
}

inline void T_KeyInfo::clearU8KeyStatus() {
    if (hasU8KeyStatus()) {
         clear_has_u8KeyStatus();
        _u8KeyStatus = 0u;
     }
}

inline bool T_KeyInfo::hasU8KeyStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_KeyInfo::getU8KeyStatus () const {
    return _u8KeyStatus;
}

inline void T_KeyInfo::setU8KeyStatus (uint8 u8KeyStatus_) {
    set_has_u8KeyStatus();
    this->_u8KeyStatus = u8KeyStatus_;
}

inline void T_KeyInfo::set_has_e16KeyCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_KeyInfo::clear_has_e16KeyCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_KeyInfo::set_has_u8KeyStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_KeyInfo::clear_has_u8KeyStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_EncInfo::T_EncInfo ()  :
    _e8EncoderType (::input_main_fi_types::T_e8_EncoderType__LEFT_ENCODER),
    _s8EncSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EncInfo::T_EncInfo (const T_EncInfo &rhs)  :
    _e8EncoderType (::input_main_fi_types::T_e8_EncoderType__LEFT_ENCODER),
    _s8EncSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EncInfo::T_EncInfo (T_e8_EncoderType e8EncoderType_, int8 s8EncSteps_)  :
    _e8EncoderType (e8EncoderType_),
    _s8EncSteps (s8EncSteps_)
{
    #ifndef NDEBUG
    if (!(T_e8_EncoderType_IsValid(e8EncoderType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8EncoderType_, "T_e8_EncoderType", "e8EncoderType", "T_EncInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EncInfo::~T_EncInfo() {
}

inline T_EncInfo& T_EncInfo::operator = (const T_EncInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8EncoderType()) {
            setE8EncoderType(rhs.getE8EncoderType());
        } else {
            clearE8EncoderType();
        }
        if (rhs.hasS8EncSteps()) {
            setS8EncSteps(rhs.getS8EncSteps());
        } else {
            clearS8EncSteps();
        }
    }
    return *this;
}

inline bool T_EncInfo::operator == (const T_EncInfo& rhs) const {
    return (((!hasE8EncoderType() && !rhs.hasE8EncoderType()) || getE8EncoderType() == rhs.getE8EncoderType()) &&
        ((!hasS8EncSteps() && !rhs.hasS8EncSteps()) || getS8EncSteps() == rhs.getS8EncSteps()));
}

inline bool T_EncInfo::operator != (const T_EncInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EncInfo::operator < (const T_EncInfo& rhs) const {
    if (hasE8EncoderType() || rhs.hasE8EncoderType()) {
        if ((uint32)getE8EncoderType() < (uint32)rhs.getE8EncoderType()) return true;
        if ((uint32)getE8EncoderType() > (uint32)rhs.getE8EncoderType()) return false;
    }
    if (hasS8EncSteps() || rhs.hasS8EncSteps()) {
        if (getS8EncSteps() < rhs.getS8EncSteps()) return true;
        if (getS8EncSteps() > rhs.getS8EncSteps()) return false;
    }
    return false;
}

inline bool T_EncInfo::operator > (const T_EncInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EncInfo::clear() {
    clearE8EncoderType();
    clearS8EncSteps();
}

inline void T_EncInfo::clearE8EncoderType() {
    if (hasE8EncoderType()) {
         clear_has_e8EncoderType();
        _e8EncoderType = ::input_main_fi_types::T_e8_EncoderType__LEFT_ENCODER;
     }
}

inline bool T_EncInfo::hasE8EncoderType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_EncoderType T_EncInfo::getE8EncoderType () const {
    return _e8EncoderType;
}

inline void T_EncInfo::setE8EncoderType (T_e8_EncoderType e8EncoderType_) {
    #ifndef NDEBUG
    if (!(T_e8_EncoderType_IsValid(e8EncoderType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8EncoderType_, "T_e8_EncoderType", "e8EncoderType", "T_EncInfo");
    }
    #endif
    set_has_e8EncoderType();
    this->_e8EncoderType = e8EncoderType_;
}

inline void T_EncInfo::clearS8EncSteps() {
    if (hasS8EncSteps()) {
         clear_has_s8EncSteps();
        _s8EncSteps = 0;
     }
}

inline bool T_EncInfo::hasS8EncSteps () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 T_EncInfo::getS8EncSteps () const {
    return _s8EncSteps;
}

inline void T_EncInfo::setS8EncSteps (int8 s8EncSteps_) {
    set_has_s8EncSteps();
    this->_s8EncSteps = s8EncSteps_;
}

inline void T_EncInfo::set_has_e8EncoderType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EncInfo::clear_has_e8EncoderType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EncInfo::set_has_s8EncSteps () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EncInfo::clear_has_s8EncSteps () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_EncoderStatus::T_EncoderStatus ()  :
    _s8EncVal_1 (0),
    _s8EncVal_2 (0),
    _s8EncVal_3 (0),
    _s8EncVal_4 (0),
    _s8EncVal_5 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_EncoderStatus::T_EncoderStatus (const T_EncoderStatus &rhs)  :
    _s8EncVal_1 (0),
    _s8EncVal_2 (0),
    _s8EncVal_3 (0),
    _s8EncVal_4 (0),
    _s8EncVal_5 (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_EncoderStatus::T_EncoderStatus (int8 s8EncVal_1_, int8 s8EncVal_2_, int8 s8EncVal_3_, int8 s8EncVal_4_, int8 s8EncVal_5_)  :
    _s8EncVal_1 (s8EncVal_1_),
    _s8EncVal_2 (s8EncVal_2_),
    _s8EncVal_3 (s8EncVal_3_),
    _s8EncVal_4 (s8EncVal_4_),
    _s8EncVal_5 (s8EncVal_5_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_EncoderStatus::~T_EncoderStatus() {
}

inline T_EncoderStatus& T_EncoderStatus::operator = (const T_EncoderStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasS8EncVal_1()) {
            setS8EncVal_1(rhs.getS8EncVal_1());
        } else {
            clearS8EncVal_1();
        }
        if (rhs.hasS8EncVal_2()) {
            setS8EncVal_2(rhs.getS8EncVal_2());
        } else {
            clearS8EncVal_2();
        }
        if (rhs.hasS8EncVal_3()) {
            setS8EncVal_3(rhs.getS8EncVal_3());
        } else {
            clearS8EncVal_3();
        }
        if (rhs.hasS8EncVal_4()) {
            setS8EncVal_4(rhs.getS8EncVal_4());
        } else {
            clearS8EncVal_4();
        }
        if (rhs.hasS8EncVal_5()) {
            setS8EncVal_5(rhs.getS8EncVal_5());
        } else {
            clearS8EncVal_5();
        }
    }
    return *this;
}

inline bool T_EncoderStatus::operator == (const T_EncoderStatus& rhs) const {
    return (((!hasS8EncVal_1() && !rhs.hasS8EncVal_1()) || getS8EncVal_1() == rhs.getS8EncVal_1()) &&
        ((!hasS8EncVal_2() && !rhs.hasS8EncVal_2()) || getS8EncVal_2() == rhs.getS8EncVal_2()) &&
        ((!hasS8EncVal_3() && !rhs.hasS8EncVal_3()) || getS8EncVal_3() == rhs.getS8EncVal_3()) &&
        ((!hasS8EncVal_4() && !rhs.hasS8EncVal_4()) || getS8EncVal_4() == rhs.getS8EncVal_4()) &&
        ((!hasS8EncVal_5() && !rhs.hasS8EncVal_5()) || getS8EncVal_5() == rhs.getS8EncVal_5()));
}

inline bool T_EncoderStatus::operator != (const T_EncoderStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_EncoderStatus::operator < (const T_EncoderStatus& rhs) const {
    if (hasS8EncVal_1() || rhs.hasS8EncVal_1()) {
        if (getS8EncVal_1() < rhs.getS8EncVal_1()) return true;
        if (getS8EncVal_1() > rhs.getS8EncVal_1()) return false;
    }
    if (hasS8EncVal_2() || rhs.hasS8EncVal_2()) {
        if (getS8EncVal_2() < rhs.getS8EncVal_2()) return true;
        if (getS8EncVal_2() > rhs.getS8EncVal_2()) return false;
    }
    if (hasS8EncVal_3() || rhs.hasS8EncVal_3()) {
        if (getS8EncVal_3() < rhs.getS8EncVal_3()) return true;
        if (getS8EncVal_3() > rhs.getS8EncVal_3()) return false;
    }
    if (hasS8EncVal_4() || rhs.hasS8EncVal_4()) {
        if (getS8EncVal_4() < rhs.getS8EncVal_4()) return true;
        if (getS8EncVal_4() > rhs.getS8EncVal_4()) return false;
    }
    if (hasS8EncVal_5() || rhs.hasS8EncVal_5()) {
        if (getS8EncVal_5() < rhs.getS8EncVal_5()) return true;
        if (getS8EncVal_5() > rhs.getS8EncVal_5()) return false;
    }
    return false;
}

inline bool T_EncoderStatus::operator > (const T_EncoderStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_EncoderStatus::clear() {
    clearS8EncVal_1();
    clearS8EncVal_2();
    clearS8EncVal_3();
    clearS8EncVal_4();
    clearS8EncVal_5();
}

inline void T_EncoderStatus::clearS8EncVal_1() {
    if (hasS8EncVal_1()) {
         clear_has_s8EncVal_1();
        _s8EncVal_1 = 0;
     }
}

inline bool T_EncoderStatus::hasS8EncVal_1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int8 T_EncoderStatus::getS8EncVal_1 () const {
    return _s8EncVal_1;
}

inline void T_EncoderStatus::setS8EncVal_1 (int8 s8EncVal_1_) {
    set_has_s8EncVal_1();
    this->_s8EncVal_1 = s8EncVal_1_;
}

inline void T_EncoderStatus::clearS8EncVal_2() {
    if (hasS8EncVal_2()) {
         clear_has_s8EncVal_2();
        _s8EncVal_2 = 0;
     }
}

inline bool T_EncoderStatus::hasS8EncVal_2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 T_EncoderStatus::getS8EncVal_2 () const {
    return _s8EncVal_2;
}

inline void T_EncoderStatus::setS8EncVal_2 (int8 s8EncVal_2_) {
    set_has_s8EncVal_2();
    this->_s8EncVal_2 = s8EncVal_2_;
}

inline void T_EncoderStatus::clearS8EncVal_3() {
    if (hasS8EncVal_3()) {
         clear_has_s8EncVal_3();
        _s8EncVal_3 = 0;
     }
}

inline bool T_EncoderStatus::hasS8EncVal_3 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int8 T_EncoderStatus::getS8EncVal_3 () const {
    return _s8EncVal_3;
}

inline void T_EncoderStatus::setS8EncVal_3 (int8 s8EncVal_3_) {
    set_has_s8EncVal_3();
    this->_s8EncVal_3 = s8EncVal_3_;
}

inline void T_EncoderStatus::clearS8EncVal_4() {
    if (hasS8EncVal_4()) {
         clear_has_s8EncVal_4();
        _s8EncVal_4 = 0;
     }
}

inline bool T_EncoderStatus::hasS8EncVal_4 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int8 T_EncoderStatus::getS8EncVal_4 () const {
    return _s8EncVal_4;
}

inline void T_EncoderStatus::setS8EncVal_4 (int8 s8EncVal_4_) {
    set_has_s8EncVal_4();
    this->_s8EncVal_4 = s8EncVal_4_;
}

inline void T_EncoderStatus::clearS8EncVal_5() {
    if (hasS8EncVal_5()) {
         clear_has_s8EncVal_5();
        _s8EncVal_5 = 0;
     }
}

inline bool T_EncoderStatus::hasS8EncVal_5 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline int8 T_EncoderStatus::getS8EncVal_5 () const {
    return _s8EncVal_5;
}

inline void T_EncoderStatus::setS8EncVal_5 (int8 s8EncVal_5_) {
    set_has_s8EncVal_5();
    this->_s8EncVal_5 = s8EncVal_5_;
}

inline void T_EncoderStatus::set_has_s8EncVal_1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_EncoderStatus::clear_has_s8EncVal_1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_EncoderStatus::set_has_s8EncVal_2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_EncoderStatus::clear_has_s8EncVal_2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_EncoderStatus::set_has_s8EncVal_3 () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_EncoderStatus::clear_has_s8EncVal_3 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_EncoderStatus::set_has_s8EncVal_4 () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_EncoderStatus::clear_has_s8EncVal_4 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_EncoderStatus::set_has_s8EncVal_5 () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_EncoderStatus::clear_has_s8EncVal_5 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_TouchInfo::T_TouchInfo ()  :
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID),
    _s32XCoord (0),
    _s32YCoord (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TouchInfo::T_TouchInfo (const T_TouchInfo &rhs)  :
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID),
    _s32XCoord (0),
    _s32YCoord (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TouchInfo::T_TouchInfo (T_e8_TouchStatus e8TouchStatus_, int32 s32XCoord_, int32 s32YCoord_)  :
    _e8TouchStatus (e8TouchStatus_),
    _s32XCoord (s32XCoord_),
    _s32YCoord (s32YCoord_)
{
    #ifndef NDEBUG
    if (!(T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "T_TouchInfo");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TouchInfo::~T_TouchInfo() {
}

inline T_TouchInfo& T_TouchInfo::operator = (const T_TouchInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8TouchStatus()) {
            setE8TouchStatus(rhs.getE8TouchStatus());
        } else {
            clearE8TouchStatus();
        }
        if (rhs.hasS32XCoord()) {
            setS32XCoord(rhs.getS32XCoord());
        } else {
            clearS32XCoord();
        }
        if (rhs.hasS32YCoord()) {
            setS32YCoord(rhs.getS32YCoord());
        } else {
            clearS32YCoord();
        }
    }
    return *this;
}

inline bool T_TouchInfo::operator == (const T_TouchInfo& rhs) const {
    return (((!hasE8TouchStatus() && !rhs.hasE8TouchStatus()) || getE8TouchStatus() == rhs.getE8TouchStatus()) &&
        ((!hasS32XCoord() && !rhs.hasS32XCoord()) || getS32XCoord() == rhs.getS32XCoord()) &&
        ((!hasS32YCoord() && !rhs.hasS32YCoord()) || getS32YCoord() == rhs.getS32YCoord()));
}

inline bool T_TouchInfo::operator != (const T_TouchInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TouchInfo::operator < (const T_TouchInfo& rhs) const {
    if (hasE8TouchStatus() || rhs.hasE8TouchStatus()) {
        if ((uint32)getE8TouchStatus() < (uint32)rhs.getE8TouchStatus()) return true;
        if ((uint32)getE8TouchStatus() > (uint32)rhs.getE8TouchStatus()) return false;
    }
    if (hasS32XCoord() || rhs.hasS32XCoord()) {
        if (getS32XCoord() < rhs.getS32XCoord()) return true;
        if (getS32XCoord() > rhs.getS32XCoord()) return false;
    }
    if (hasS32YCoord() || rhs.hasS32YCoord()) {
        if (getS32YCoord() < rhs.getS32YCoord()) return true;
        if (getS32YCoord() > rhs.getS32YCoord()) return false;
    }
    return false;
}

inline bool T_TouchInfo::operator > (const T_TouchInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TouchInfo::clear() {
    clearE8TouchStatus();
    clearS32XCoord();
    clearS32YCoord();
}

inline void T_TouchInfo::clearE8TouchStatus() {
    if (hasE8TouchStatus()) {
         clear_has_e8TouchStatus();
        _e8TouchStatus = ::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID;
     }
}

inline bool T_TouchInfo::hasE8TouchStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_TouchStatus T_TouchInfo::getE8TouchStatus () const {
    return _e8TouchStatus;
}

inline void T_TouchInfo::setE8TouchStatus (T_e8_TouchStatus e8TouchStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "T_TouchInfo");
    }
    #endif
    set_has_e8TouchStatus();
    this->_e8TouchStatus = e8TouchStatus_;
}

inline void T_TouchInfo::clearS32XCoord() {
    if (hasS32XCoord()) {
         clear_has_s32XCoord();
        _s32XCoord = 0;
     }
}

inline bool T_TouchInfo::hasS32XCoord () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 T_TouchInfo::getS32XCoord () const {
    return _s32XCoord;
}

inline void T_TouchInfo::setS32XCoord (int32 s32XCoord_) {
    set_has_s32XCoord();
    this->_s32XCoord = s32XCoord_;
}

inline void T_TouchInfo::clearS32YCoord() {
    if (hasS32YCoord()) {
         clear_has_s32YCoord();
        _s32YCoord = 0;
     }
}

inline bool T_TouchInfo::hasS32YCoord () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 T_TouchInfo::getS32YCoord () const {
    return _s32YCoord;
}

inline void T_TouchInfo::setS32YCoord (int32 s32YCoord_) {
    set_has_s32YCoord();
    this->_s32YCoord = s32YCoord_;
}

inline void T_TouchInfo::set_has_e8TouchStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TouchInfo::clear_has_e8TouchStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TouchInfo::set_has_s32XCoord () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TouchInfo::clear_has_s32XCoord () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TouchInfo::set_has_s32YCoord () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TouchInfo::clear_has_s32YCoord () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_DevManager_DeviceProperty::T_DevManager_DeviceProperty ()  :
    _DeviceConnectStatus (::input_main_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED),
    _DeviceType (::input_main_fi_types::T_e8_Device__DTY_BTA),
    _DeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_DevManager_DeviceProperty::T_DevManager_DeviceProperty (const T_DevManager_DeviceProperty &rhs)  :
    _DeviceConnectStatus (::input_main_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED),
    _DeviceType (::input_main_fi_types::T_e8_Device__DTY_BTA),
    _DeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_DevManager_DeviceProperty::T_DevManager_DeviceProperty (T_e8_DeviceConnectStatus DeviceConnectStatus_, T_e8_Device DeviceType_, const ::std::string& DeviceName_)  :
    _DeviceConnectStatus (DeviceConnectStatus_),
    _DeviceType (DeviceType_),
    _DeviceName (DeviceName_)
{
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectStatus_IsValid(DeviceConnectStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceConnectStatus_, "T_e8_DeviceConnectStatus", "DeviceConnectStatus", "T_DevManager_DeviceProperty");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_Device_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "T_e8_Device", "DeviceType", "T_DevManager_DeviceProperty");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_DevManager_DeviceProperty::~T_DevManager_DeviceProperty() {
}

inline T_DevManager_DeviceProperty& T_DevManager_DeviceProperty::operator = (const T_DevManager_DeviceProperty& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDeviceConnectStatus()) {
            setDeviceConnectStatus(rhs.getDeviceConnectStatus());
        } else {
            clearDeviceConnectStatus();
        }
        if (rhs.hasDeviceType()) {
            setDeviceType(rhs.getDeviceType());
        } else {
            clearDeviceType();
        }
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
    }
    return *this;
}

inline bool T_DevManager_DeviceProperty::operator == (const T_DevManager_DeviceProperty& rhs) const {
    return (((!hasDeviceConnectStatus() && !rhs.hasDeviceConnectStatus()) || getDeviceConnectStatus() == rhs.getDeviceConnectStatus()) &&
        ((!hasDeviceType() && !rhs.hasDeviceType()) || getDeviceType() == rhs.getDeviceType()) &&
        ((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()));
}

inline bool T_DevManager_DeviceProperty::operator != (const T_DevManager_DeviceProperty& rhs) const {
    return ! (*this == rhs);
}

inline bool T_DevManager_DeviceProperty::operator < (const T_DevManager_DeviceProperty& rhs) const {
    if (hasDeviceConnectStatus() || rhs.hasDeviceConnectStatus()) {
        if ((uint32)getDeviceConnectStatus() < (uint32)rhs.getDeviceConnectStatus()) return true;
        if ((uint32)getDeviceConnectStatus() > (uint32)rhs.getDeviceConnectStatus()) return false;
    }
    if (hasDeviceType() || rhs.hasDeviceType()) {
        if ((uint32)getDeviceType() < (uint32)rhs.getDeviceType()) return true;
        if ((uint32)getDeviceType() > (uint32)rhs.getDeviceType()) return false;
    }
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    return false;
}

inline bool T_DevManager_DeviceProperty::operator > (const T_DevManager_DeviceProperty& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_DevManager_DeviceProperty::clear() {
    clearDeviceConnectStatus();
    clearDeviceType();
    clearDeviceName();
}

inline void T_DevManager_DeviceProperty::clearDeviceConnectStatus() {
    if (hasDeviceConnectStatus()) {
         clear_has_DeviceConnectStatus();
        _DeviceConnectStatus = ::input_main_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED;
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceConnectStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_DeviceConnectStatus T_DevManager_DeviceProperty::getDeviceConnectStatus () const {
    return _DeviceConnectStatus;
}

inline void T_DevManager_DeviceProperty::setDeviceConnectStatus (T_e8_DeviceConnectStatus DeviceConnectStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_DeviceConnectStatus_IsValid(DeviceConnectStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceConnectStatus_, "T_e8_DeviceConnectStatus", "DeviceConnectStatus", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_DeviceConnectStatus();
    this->_DeviceConnectStatus = DeviceConnectStatus_;
}

inline void T_DevManager_DeviceProperty::clearDeviceType() {
    if (hasDeviceType()) {
         clear_has_DeviceType();
        _DeviceType = ::input_main_fi_types::T_e8_Device__DTY_BTA;
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_Device T_DevManager_DeviceProperty::getDeviceType () const {
    return _DeviceType;
}

inline void T_DevManager_DeviceProperty::setDeviceType (T_e8_Device DeviceType_) {
    #ifndef NDEBUG
    if (!(T_e8_Device_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "T_e8_Device", "DeviceType", "T_DevManager_DeviceProperty");
    }
    #endif
    set_has_DeviceType();
    this->_DeviceType = DeviceType_;
}

inline void T_DevManager_DeviceProperty::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_DeviceName();
        _DeviceName.clear();
     }
}

inline bool T_DevManager_DeviceProperty::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_DevManager_DeviceProperty::getDeviceName () const {
    return _DeviceName;
}

inline ::std::string& T_DevManager_DeviceProperty::getDeviceNameMutable () {
    set_has_DeviceName();
    return _DeviceName;
}

inline void T_DevManager_DeviceProperty::setDeviceName (const ::std::string& DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName = DeviceName_;
}

inline void T_DevManager_DeviceProperty::setDeviceName (const char* DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(DeviceName_);
}

inline void T_DevManager_DeviceProperty::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(value, size);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceConnectStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceConnectStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceType () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_DevManager_DeviceProperty::set_has_DeviceName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_DevManager_DeviceProperty::clear_has_DeviceName () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace input_main_fi_types

#endif // INPUT_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
