/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef INPUT_MAIN_FIPROXY_H
#define INPUT_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "input_main_fi.h"
#include "input_main_fi_typesConst.h"
#include <string>

namespace input_main_fi {

class Input_main_fiProxy;

class DevInputNotifyConnectionCallbackIF {
public:
    virtual ~DevInputNotifyConnectionCallbackIF() {}

    virtual void onDevInputNotifyConnectionError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< DevInputNotifyConnectionError >& error) = 0;

    virtual void onDevInputNotifyConnectionResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< DevInputNotifyConnectionResult >& result) = 0;
};

class DisableInputEventsCallbackIF {
public:
    virtual ~DisableInputEventsCallbackIF() {}

    virtual void onDisableInputEventsError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< DisableInputEventsError >& error) = 0;

    virtual void onDisableInputEventsResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< DisableInputEventsResult >& result) = 0;
};

class EnableInputEventsCallbackIF {
public:
    virtual ~EnableInputEventsCallbackIF() {}

    virtual void onEnableInputEventsError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< EnableInputEventsError >& error) = 0;

    virtual void onEnableInputEventsResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< EnableInputEventsResult >& result) = 0;
};

class EncoderDirStatusCallbackIF {
public:
    virtual ~EncoderDirStatusCallbackIF() {}

    virtual void onEncoderDirStatusError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< EncoderDirStatusError >& error) = 0;

    virtual void onEncoderDirStatusStatus(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< EncoderDirStatusStatus >& status) = 0;
};

class EncoderStatusCallbackIF {
public:
    virtual ~EncoderStatusCallbackIF() {}

    virtual void onEncoderStatusError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< EncoderStatusError >& error) = 0;

    virtual void onEncoderStatusStatus(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< EncoderStatusStatus >& status) = 0;
};

class GestureRecordCallbackIF {
public:
    virtual ~GestureRecordCallbackIF() {}

    virtual void onGestureRecordError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< GestureRecordError >& error) = 0;

    virtual void onGestureRecordResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< GestureRecordResult >& result) = 0;
};

class GestureReplayCallbackIF {
public:
    virtual ~GestureReplayCallbackIF() {}

    virtual void onGestureReplayError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< GestureReplayError >& error) = 0;

    virtual void onGestureReplayResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< GestureReplayResult >& result) = 0;
};

class PressedKeysCallbackIF {
public:
    virtual ~PressedKeysCallbackIF() {}

    virtual void onPressedKeysError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< PressedKeysError >& error) = 0;

    virtual void onPressedKeysStatus(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< PressedKeysStatus >& status) = 0;
};

class SimulateEncRotationCallbackIF {
public:
    virtual ~SimulateEncRotationCallbackIF() {}

    virtual void onSimulateEncRotationError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateEncRotationError >& error) = 0;

    virtual void onSimulateEncRotationResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateEncRotationResult >& result) = 0;
};

class SimulateKeyInjectionCallbackIF {
public:
    virtual ~SimulateKeyInjectionCallbackIF() {}

    virtual void onSimulateKeyInjectionError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateKeyInjectionError >& error) = 0;

    virtual void onSimulateKeyInjectionResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateKeyInjectionResult >& result) = 0;
};

class SimulateMultiTouchCallbackIF {
public:
    virtual ~SimulateMultiTouchCallbackIF() {}

    virtual void onSimulateMultiTouchError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateMultiTouchError >& error) = 0;

    virtual void onSimulateMultiTouchResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateMultiTouchResult >& result) = 0;
};

class SimulatePIVITouchCallbackIF {
public:
    virtual ~SimulatePIVITouchCallbackIF() {}

    virtual void onSimulatePIVITouchError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulatePIVITouchError >& error) = 0;

    virtual void onSimulatePIVITouchResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulatePIVITouchResult >& result) = 0;
};

class SimulatePIVITouchSlideCallbackIF {
public:
    virtual ~SimulatePIVITouchSlideCallbackIF() {}

    virtual void onSimulatePIVITouchSlideError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulatePIVITouchSlideError >& error) = 0;

    virtual void onSimulatePIVITouchSlideResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulatePIVITouchSlideResult >& result) = 0;
};

class SimulateSingleTouchCallbackIF {
public:
    virtual ~SimulateSingleTouchCallbackIF() {}

    virtual void onSimulateSingleTouchError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateSingleTouchError >& error) = 0;

    virtual void onSimulateSingleTouchResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateSingleTouchResult >& result) = 0;
};

class SimulateTouchSlideCallbackIF {
public:
    virtual ~SimulateTouchSlideCallbackIF() {}

    virtual void onSimulateTouchSlideError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateTouchSlideError >& error) = 0;

    virtual void onSimulateTouchSlideResult(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< SimulateTouchSlideResult >& result) = 0;
};

class TouchStatusCallbackIF {
public:
    virtual ~TouchStatusCallbackIF() {}

    virtual void onTouchStatusError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< TouchStatusError >& error) = 0;

    virtual void onTouchStatusStatus(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< TouchStatusStatus >& status) = 0;
};

class TouchStatusPIVISecondaryCallbackIF {
public:
    virtual ~TouchStatusPIVISecondaryCallbackIF() {}

    virtual void onTouchStatusPIVISecondaryError(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< TouchStatusPIVISecondaryError >& error) = 0;

    virtual void onTouchStatusPIVISecondaryStatus(const ::boost::shared_ptr< Input_main_fiProxy >& proxy, const ::boost::shared_ptr< TouchStatusPIVISecondaryStatus >& status) = 0;
};

class Input_main_fiProxyCallback;

/**
 * Input_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'input_main_fi' (specified in file
 * input_main_fi.xml).
 *
 * CCA Functional Interface 'input_main_fi'
 *
 * Fullname: VD_Input CCA Service, Application Functional Interface
 *
 * Version:
 *
 * Author: Sandeep Gupta
 *
 * Date: $Date: 03 Sep 2015 09:00:00  $
 *
 * Department:
 *
 * Title: VD_INPUT_FI
 *
 * <b>Description of 'input_main_fi':</b>
 *
 * VD_Input messages for CCA applications
 */
class Input_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Input_main_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Input_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Input_main_fiProxy. The caller has to pass the
     * port name and the service information. It is only possible to use this
     * function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Input_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Input_main_fiProxy. The caller has to pass the
     * port name. The port name is defined in the "Car Multimedia Component"
     * model. With the help of the port name it is possible to address the
     * concrete proxy, which is defined in the CMC model description.
     */
    static ::boost::shared_ptr< Input_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Input_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Input_main_fiProxy();

    // Method 'EnableInputEvents'

    /**
     * Call the method 'EnableInputEvents'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'EnableInputEvents'</b>:
     *
     * <p>Client Shall First Enable Input Events by calling this method to receive events and also for injecting events</p>
     * <p>Input Events are Key,Encoder and Touch</p>
     * <p>Also this Method shall enable Event Observer Module to fetch and feedback Input Events</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEnableInputEventsStart(EnableInputEventsCallbackIF& cb);

    // Method 'DisableInputEvents'

    /**
     * Call the method 'DisableInputEvents'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'DisableInputEvents'</b>:
     *
     * <p>Client Shall disable Input Events by calling this method to stop receiving events and also injecting of events</p>
     * <p>Input Events are Key,Encoder and Touch</p>
     * <p>Also this Method shall Stop Event Observer Module to fetch and feedback Input Events</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisableInputEventsStart(DisableInputEventsCallbackIF& cb);

    // Method 'simulateKeyInjection'

    /**
     * Call the method 'simulateKeyInjection'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'simulateKeyInjection'</b>:
     *
     * This method is used to simulate HardKey, SWC Key, System and Encoder Keys Press or Release in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e16Keycode Enum containing HMI Key code.
     *
     * @param u8KeyStatus Status 1 indicates Key Press and 0 indicates Key Release.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateKeyInjectionStart(SimulateKeyInjectionCallbackIF& cb, ::input_main_fi_types::T_e16_KeyCode e16Keycode, uint8 u8KeyStatus);

    // Method 'simulateEncRotation'

    /**
     * Call the method 'simulateEncRotation'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'simulateEncRotation'</b>:
     *
     * This method is used to simulate Left and Right Encoder Rotation in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8EncoderType Enum containing Type of Encoder Left or Right.
     *
     * @param s8EncSteps No of steps with +ve/-ve value indicating direction of rotation.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateEncRotationStart(SimulateEncRotationCallbackIF& cb, ::input_main_fi_types::T_e8_EncoderType e8EncoderType, int8 s8EncSteps);

    // Method 'simulateSingleTouch'

    /**
     * Call the method 'simulateSingleTouch'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'simulateSingleTouch'</b>:
     *
     * This method is used to simulate Single Touch Press or Release in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s32XCoord signed value of X coord
     *
     * @param s32YCoord signed value of Y coord.
     *
     * @param e8TouchStatus Enum of touch status press/release or invalid.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateSingleTouchStart(SimulateSingleTouchCallbackIF& cb, int32 s32XCoord, int32 s32YCoord, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus);

    // Method 'simulateTouchSlide'

    /**
     * Call the method 'simulateTouchSlide'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'simulateTouchSlide'</b>:
     *
     * This method is used to simulate Touch slide gesture in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s32XStart signed value of starting X coord
     *
     * @param s32YStart signed value of starting Y coord.
     *
     * @param s32XEnd signed value of end X coord
     *
     * @param s32YEnd signed value of end Y coord.
     *
     * @param u16Duration Duration shall be in milliseconds and multiple of 10
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateTouchSlideStart(SimulateTouchSlideCallbackIF& cb, int32 s32XStart, int32 s32YStart, int32 s32XEnd, int32 s32YEnd, uint16 u16Duration);

    // Method 'simulateMultiTouch'

    /**
     * Call the method 'simulateMultiTouch'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'simulateMultiTouch'</b>:
     *
     * This method is used to simulate Multi Touch Press or Release in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s32SlotId <p>signed value of Slot ID indicating finger ID</p>
     * <p>1 finger by fefault means Slot ID 0 and 2nd finger touch indicated by SlotID 1 and so on..</p>
     *
     * @param s32XCoord signed value of X coord
     *
     * @param s32YCoord signed value of Y coord.
     *
     * @param e8TouchStatus Enum of touch status press/release or invalid.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulateMultiTouchStart(SimulateMultiTouchCallbackIF& cb, int32 s32SlotId, int32 s32XCoord, int32 s32YCoord, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus);

    // Method 'GestureRecord'

    /**
     * Call the method 'GestureRecord'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GestureRecord'</b>:
     *
     * <p>This method is used to Record Sequence of User Inputs, Touch, Key, Encoder.</p>
     * <p>This can be used to record series of touch events and store them in some eg:/tmp/GuestureName(optional .txt or .ev file extension) file in target.</p>
     * <p>User can then save this file and use to replay Guestures.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8StartStop u8StartStop = 1 : Start Recording Input Events
     * u8StartStop = 0 : Stop Recording Input Events
     *
     * @param FilePath File path is needed as string. This shall contain full file path along with directory in which user wants to save file.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGestureRecordStart(GestureRecordCallbackIF& cb, uint8 u8StartStop, const ::std::string& filePath);

    // Method 'GestureReplay'

    /**
     * Call the method 'GestureReplay'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'GestureReplay'</b>:
     *
     * <p>This method is used to Replay Sequence of User Inputs, Touch, Key, Encoder.</p>
     * <p>This can be used to Replay series of touch events from file stored in Target File system eg: /tmp/GuestureName(optional .txt or .ev file extension).</p>
     * <p>User shall ensure this file is present at specified path in target file system and accessible.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param u8StartStop u8StartStop = 1 : Start Replay of Input Events
     * u8StartStop = 0 : Stop Replay of Input Events in between.
     *
     * @param FilePath File path is needed as string. This shall contain full file path along with directory in which user has saved file.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGestureReplayStart(GestureReplayCallbackIF& cb, uint8 u8StartStop, const ::std::string& filePath);

    // Method 'simulatePIVITouch'

    /**
     * Call the method 'simulatePIVITouch'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'simulatePIVITouch'</b>:
     *
     * This method is used to simulate PIVI Touch Press or Release in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s32XCoord signed value of X coord
     *
     * @param s32YCoord signed value of Y coord.
     *
     * @param s32ScreenNumber <p>1 -for Primary Screen</p>
     * <p>2 -for Secondary Screen</p>
     *
     * @param e8TouchStatus Enum of touch status press/release or invalid.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulatePIVITouchStart(SimulatePIVITouchCallbackIF& cb, int32 s32XCoord, int32 s32YCoord, int32 s32ScreenNumber, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus);

    // Method 'DevInputNotifyConnection'

    /**
     * Call the method 'DevInputNotifyConnection'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'DevInputNotifyConnection'</b>:
     *
     * This method is used to get trigger DevManagerNotifyConnection from vd_device manager via switchctrl
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DeviceType DeviceType Properties
     *
     * @param DeviceConnectStatus Device Connection Status Properties
     *
     * @param DeviceName Device Name Properties
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDevInputNotifyConnectionStart(DevInputNotifyConnectionCallbackIF& cb, ::input_main_fi_types::T_e8_Device deviceType, ::input_main_fi_types::T_e8_DeviceConnectStatus deviceConnectStatus, const ::std::string& deviceName);

    // Method 'simulatePIVITouchSlide'

    /**
     * Call the method 'simulatePIVITouchSlide'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'simulatePIVITouchSlide'</b>:
     *
     * This method is used to simulate PIVI Touch slide gesture in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param s32XStart signed value of starting X coord
     *
     * @param s32YStart signed value of starting Y coord.
     *
     * @param s32XEnd signed value of end X coord
     *
     * @param s32YEnd signed value of end Y coord.
     *
     * @param u16Duration Duration shall be in milliseconds and multiple of 10
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSimulatePIVITouchSlideStart(SimulatePIVITouchSlideCallbackIF& cb, int32 s32XStart, int32 s32YStart, int32 s32XEnd, int32 s32YEnd, uint16 u16Duration);

    // Property 'PressedKeys'

    /**
     * Notify on the property 'PressedKeys'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'PressedKeys'</b>:
     *
     * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
     * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
     * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
     * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
     * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPressedKeysUpReg(PressedKeysCallbackIF& cb);

    /**
     * Remove the notifcation on property 'PressedKeys'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'PressedKeys'</b>:
     *
     * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
     * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
     * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
     * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
     * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
     *
     * @param act The act which was previously returned by the
     * sendPressedKeysUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendPressedKeysRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'PressedKeys'.
     */
    void sendPressedKeysRelUpRegAll ();

    /**
     * Returns the current value of the property 'PressedKeys' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasPressedKeys() returns true.
     *
     * @return the previously received value of the property 'PressedKeys'.
     */
    const PressedKeysStatus& getPressedKeys() const;

    /**
     * Determines whether a status message for the property 'PressedKeys' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasPressedKeys() const;

    /**
     * Request the value of the property 'PressedKeys' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'PressedKeys'</b>:
     *
     * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
     * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
     * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
     * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
     * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPressedKeysGet(PressedKeysCallbackIF& cb);

    // Property 'EncoderDirStatus'

    /**
     * Notify on the property 'EncoderDirStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'EncoderDirStatus'</b>:
     *
     * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
     * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
     * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEncoderDirStatusUpReg(EncoderDirStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'EncoderDirStatus'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'EncoderDirStatus'</b>:
     *
     * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
     * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
     * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
     *
     * @param act The act which was previously returned by the
     * sendEncoderDirStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendEncoderDirStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'EncoderDirStatus'.
     */
    void sendEncoderDirStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'EncoderDirStatus' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasEncoderDirStatus() returns true.
     *
     * @return the previously received value of the property 'EncoderDirStatus'.
     */
    const EncoderDirStatusStatus& getEncoderDirStatus() const;

    /**
     * Determines whether a status message for the property 'EncoderDirStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEncoderDirStatus() const;

    /**
     * Request the value of the property 'EncoderDirStatus' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'EncoderDirStatus'</b>:
     *
     * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
     * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
     * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEncoderDirStatusGet(EncoderDirStatusCallbackIF& cb);

    // Property 'EncoderStatus'

    /**
     * Notify on the property 'EncoderStatus'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'EncoderStatus'</b>:
     *
     * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
     * <p>Enc type: Left or Right Encoder</p>
     * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
     * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
     * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEncoderStatusUpReg(EncoderStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'EncoderStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'EncoderStatus'</b>:
     *
     * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
     * <p>Enc type: Left or Right Encoder</p>
     * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
     * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
     * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
     *
     * @param act The act which was previously returned by the
     * sendEncoderStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendEncoderStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'EncoderStatus'.
     */
    void sendEncoderStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'EncoderStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasEncoderStatus() returns true.
     *
     * @return the previously received value of the property 'EncoderStatus'.
     */
    const EncoderStatusStatus& getEncoderStatus() const;

    /**
     * Determines whether a status message for the property 'EncoderStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasEncoderStatus() const;

    /**
     * Request the value of the property 'EncoderStatus' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'EncoderStatus'</b>:
     *
     * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
     * <p>Enc type: Left or Right Encoder</p>
     * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
     * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
     * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendEncoderStatusGet(EncoderStatusCallbackIF& cb);

    // Property 'TouchStatus'

    /**
     * Notify on the property 'TouchStatus'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'TouchStatus'</b>:
     *
     * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
     * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
     * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTouchStatusUpReg(TouchStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TouchStatus'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TouchStatus'</b>:
     *
     * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
     * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
     * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
     *
     * @param act The act which was previously returned by the
     * sendTouchStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTouchStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TouchStatus'.
     */
    void sendTouchStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'TouchStatus' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasTouchStatus() returns true.
     *
     * @return the previously received value of the property 'TouchStatus'.
     */
    const TouchStatusStatus& getTouchStatus() const;

    /**
     * Determines whether a status message for the property 'TouchStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTouchStatus() const;

    /**
     * Request the value of the property 'TouchStatus' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TouchStatus'</b>:
     *
     * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
     * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
     * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTouchStatusGet(TouchStatusCallbackIF& cb);

    // Property 'TouchStatusPIVISecondary'

    /**
     * Notify on the property 'TouchStatusPIVISecondary'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'TouchStatusPIVISecondary'</b>:
     *
     * <p>This contains touch Info for PIVI Secondary Screen</p>
     * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
     * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
     * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTouchStatusPIVISecondaryUpReg(TouchStatusPIVISecondaryCallbackIF& cb);

    /**
     * Remove the notifcation on property 'TouchStatusPIVISecondary'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'TouchStatusPIVISecondary'</b>:
     *
     * <p>This contains touch Info for PIVI Secondary Screen</p>
     * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
     * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
     * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
     *
     * @param act The act which was previously returned by the
     * sendTouchStatusPIVISecondaryUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendTouchStatusPIVISecondaryRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'TouchStatusPIVISecondary'.
     */
    void sendTouchStatusPIVISecondaryRelUpRegAll ();

    /**
     * Returns the current value of the property 'TouchStatusPIVISecondary'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasTouchStatusPIVISecondary() returns true.
     *
     * @return the previously received value of the property 'TouchStatusPIVISecondary'.
     */
    const TouchStatusPIVISecondaryStatus& getTouchStatusPIVISecondary() const;

    /**
     * Determines whether a status message for the property 'TouchStatusPIVISecondary' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTouchStatusPIVISecondary() const;

    /**
     * Request the value of the property 'TouchStatusPIVISecondary' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'TouchStatusPIVISecondary'</b>:
     *
     * <p>This contains touch Info for PIVI Secondary Screen</p>
     * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
     * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
     * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTouchStatusPIVISecondaryGet(TouchStatusPIVISecondaryCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Input_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'PressedKeys'

    ::asf::core::nullable< PressedKeysStatus > _pressedKeys;

    // Property 'EncoderDirStatus'

    ::asf::core::nullable< EncoderDirStatusStatus > _encoderDirStatus;

    // Property 'EncoderStatus'

    ::asf::core::nullable< EncoderStatusStatus > _encoderStatus;

    // Property 'TouchStatus'

    ::asf::core::nullable< TouchStatusStatus > _touchStatus;

    // Property 'TouchStatusPIVISecondary'

    ::asf::core::nullable< TouchStatusPIVISecondaryStatus > _touchStatusPIVISecondary;

    DECLARE_CLASS_LOGGER();

    friend class Input_main_fiProxyCallback;
};

} // namespace input_main_fi

#endif // INPUT_MAIN_FIPROXY_H
