/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "input_main_fiCca.h"
#include "input_main_fiJson.h"
#include "input_main_fiProxy.h"
#include "input_main_fi_typesConst.h"
#include <string>

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace input_main_fi {

/*static*/ ::asf::core::Logger Input_main_fiProxy::_logger ("/input_main_fi/Input_main_fiProxy");


class Input_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Input_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Input_main_fiProxy> proxy = ::boost::static_pointer_cast<Input_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_EnableInputEvents: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::EnableInputEventsResult);
                                setActAndLogResult(message, "EnableInputEvents", reinterpret_cast<act_t>(this), _logger);
                                ((EnableInputEventsCallbackIF*) _callback)->onEnableInputEventsResult (proxy, ::boost::static_pointer_cast<EnableInputEventsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::EnableInputEventsError);
                                setActAndLogError(message, "EnableInputEvents", reinterpret_cast<act_t>(this), _logger);
                                ((EnableInputEventsCallbackIF*) _callback)->onEnableInputEventsError (proxy, ::boost::static_pointer_cast<EnableInputEventsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DisableInputEvents: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::DisableInputEventsResult);
                                setActAndLogResult(message, "DisableInputEvents", reinterpret_cast<act_t>(this), _logger);
                                ((DisableInputEventsCallbackIF*) _callback)->onDisableInputEventsResult (proxy, ::boost::static_pointer_cast<DisableInputEventsResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::DisableInputEventsError);
                                setActAndLogError(message, "DisableInputEvents", reinterpret_cast<act_t>(this), _logger);
                                ((DisableInputEventsCallbackIF*) _callback)->onDisableInputEventsError (proxy, ::boost::static_pointer_cast<DisableInputEventsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulateKeyInjection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateKeyInjectionResult);
                                setActAndLogResult(message, "SimulateKeyInjection", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateKeyInjectionCallbackIF*) _callback)->onSimulateKeyInjectionResult (proxy, ::boost::static_pointer_cast<SimulateKeyInjectionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateKeyInjectionError);
                                setActAndLogError(message, "SimulateKeyInjection", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateKeyInjectionCallbackIF*) _callback)->onSimulateKeyInjectionError (proxy, ::boost::static_pointer_cast<SimulateKeyInjectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulateEncRotation: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateEncRotationResult);
                                setActAndLogResult(message, "SimulateEncRotation", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateEncRotationCallbackIF*) _callback)->onSimulateEncRotationResult (proxy, ::boost::static_pointer_cast<SimulateEncRotationResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateEncRotationError);
                                setActAndLogError(message, "SimulateEncRotation", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateEncRotationCallbackIF*) _callback)->onSimulateEncRotationError (proxy, ::boost::static_pointer_cast<SimulateEncRotationError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulateSingleTouch: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateSingleTouchResult);
                                setActAndLogResult(message, "SimulateSingleTouch", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateSingleTouchCallbackIF*) _callback)->onSimulateSingleTouchResult (proxy, ::boost::static_pointer_cast<SimulateSingleTouchResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateSingleTouchError);
                                setActAndLogError(message, "SimulateSingleTouch", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateSingleTouchCallbackIF*) _callback)->onSimulateSingleTouchError (proxy, ::boost::static_pointer_cast<SimulateSingleTouchError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulateTouchSlide: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateTouchSlideResult);
                                setActAndLogResult(message, "SimulateTouchSlide", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateTouchSlideCallbackIF*) _callback)->onSimulateTouchSlideResult (proxy, ::boost::static_pointer_cast<SimulateTouchSlideResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateTouchSlideError);
                                setActAndLogError(message, "SimulateTouchSlide", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateTouchSlideCallbackIF*) _callback)->onSimulateTouchSlideError (proxy, ::boost::static_pointer_cast<SimulateTouchSlideError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulateMultiTouch: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateMultiTouchResult);
                                setActAndLogResult(message, "SimulateMultiTouch", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateMultiTouchCallbackIF*) _callback)->onSimulateMultiTouchResult (proxy, ::boost::static_pointer_cast<SimulateMultiTouchResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulateMultiTouchError);
                                setActAndLogError(message, "SimulateMultiTouch", reinterpret_cast<act_t>(this), _logger);
                                ((SimulateMultiTouchCallbackIF*) _callback)->onSimulateMultiTouchError (proxy, ::boost::static_pointer_cast<SimulateMultiTouchError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GestureRecord: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::GestureRecordResult);
                                setActAndLogResult(message, "GestureRecord", reinterpret_cast<act_t>(this), _logger);
                                ((GestureRecordCallbackIF*) _callback)->onGestureRecordResult (proxy, ::boost::static_pointer_cast<GestureRecordResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::GestureRecordError);
                                setActAndLogError(message, "GestureRecord", reinterpret_cast<act_t>(this), _logger);
                                ((GestureRecordCallbackIF*) _callback)->onGestureRecordError (proxy, ::boost::static_pointer_cast<GestureRecordError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_GestureReplay: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::GestureReplayResult);
                                setActAndLogResult(message, "GestureReplay", reinterpret_cast<act_t>(this), _logger);
                                ((GestureReplayCallbackIF*) _callback)->onGestureReplayResult (proxy, ::boost::static_pointer_cast<GestureReplayResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::GestureReplayError);
                                setActAndLogError(message, "GestureReplay", reinterpret_cast<act_t>(this), _logger);
                                ((GestureReplayCallbackIF*) _callback)->onGestureReplayError (proxy, ::boost::static_pointer_cast<GestureReplayError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulatePIVITouch: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulatePIVITouchResult);
                                setActAndLogResult(message, "SimulatePIVITouch", reinterpret_cast<act_t>(this), _logger);
                                ((SimulatePIVITouchCallbackIF*) _callback)->onSimulatePIVITouchResult (proxy, ::boost::static_pointer_cast<SimulatePIVITouchResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulatePIVITouchError);
                                setActAndLogError(message, "SimulatePIVITouch", reinterpret_cast<act_t>(this), _logger);
                                ((SimulatePIVITouchCallbackIF*) _callback)->onSimulatePIVITouchError (proxy, ::boost::static_pointer_cast<SimulatePIVITouchError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_DevInputNotifyConnection: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::DevInputNotifyConnectionResult);
                                setActAndLogResult(message, "DevInputNotifyConnection", reinterpret_cast<act_t>(this), _logger);
                                ((DevInputNotifyConnectionCallbackIF*) _callback)->onDevInputNotifyConnectionResult (proxy, ::boost::static_pointer_cast<DevInputNotifyConnectionResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::DevInputNotifyConnectionError);
                                setActAndLogError(message, "DevInputNotifyConnection", reinterpret_cast<act_t>(this), _logger);
                                ((DevInputNotifyConnectionCallbackIF*) _callback)->onDevInputNotifyConnectionError (proxy, ::boost::static_pointer_cast<DevInputNotifyConnectionError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_simulatePIVITouchSlide: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulatePIVITouchSlideResult);
                                setActAndLogResult(message, "SimulatePIVITouchSlide", reinterpret_cast<act_t>(this), _logger);
                                ((SimulatePIVITouchSlideCallbackIF*) _callback)->onSimulatePIVITouchSlideResult (proxy, ::boost::static_pointer_cast<SimulatePIVITouchSlideResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::SimulatePIVITouchSlideError);
                                setActAndLogError(message, "SimulatePIVITouchSlide", reinterpret_cast<act_t>(this), _logger);
                                ((SimulatePIVITouchSlideCallbackIF*) _callback)->onSimulatePIVITouchSlideError (proxy, ::boost::static_pointer_cast<SimulatePIVITouchSlideError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_PressedKeys: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::PressedKeysStatus);
                                setActAndLogStatus(message, "PressedKeys", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<PressedKeysStatus> payload = ::boost::static_pointer_cast<PressedKeysStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< PressedKeysStatus >& refNullableStatus = proxy->_pressedKeys;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((PressedKeysCallbackIF*) _callback)->onPressedKeysStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PressedKeysCallbackIF*) _callback)->onPressedKeysStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::PressedKeysError);
                                setActAndLogError(message, "PressedKeys", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((PressedKeysCallbackIF*) _callback)->onPressedKeysError(proxy, ::boost::static_pointer_cast<PressedKeysError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EncoderDirStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::EncoderDirStatusStatus);
                                setActAndLogStatus(message, "EncoderDirStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EncoderDirStatusStatus> payload = ::boost::static_pointer_cast<EncoderDirStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EncoderDirStatusStatus >& refNullableStatus = proxy->_encoderDirStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EncoderDirStatusCallbackIF*) _callback)->onEncoderDirStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EncoderDirStatusCallbackIF*) _callback)->onEncoderDirStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::EncoderDirStatusError);
                                setActAndLogError(message, "EncoderDirStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EncoderDirStatusCallbackIF*) _callback)->onEncoderDirStatusError(proxy, ::boost::static_pointer_cast<EncoderDirStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EncoderStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::EncoderStatusStatus);
                                setActAndLogStatus(message, "EncoderStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EncoderStatusStatus> payload = ::boost::static_pointer_cast<EncoderStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EncoderStatusStatus >& refNullableStatus = proxy->_encoderStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EncoderStatusCallbackIF*) _callback)->onEncoderStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EncoderStatusCallbackIF*) _callback)->onEncoderStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::EncoderStatusError);
                                setActAndLogError(message, "EncoderStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EncoderStatusCallbackIF*) _callback)->onEncoderStatusError(proxy, ::boost::static_pointer_cast<EncoderStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TouchStatus: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::TouchStatusStatus);
                                setActAndLogStatus(message, "TouchStatus", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TouchStatusStatus> payload = ::boost::static_pointer_cast<TouchStatusStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TouchStatusStatus >& refNullableStatus = proxy->_touchStatus;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TouchStatusCallbackIF*) _callback)->onTouchStatusStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TouchStatusCallbackIF*) _callback)->onTouchStatusStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::TouchStatusError);
                                setActAndLogError(message, "TouchStatus", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TouchStatusCallbackIF*) _callback)->onTouchStatusError(proxy, ::boost::static_pointer_cast<TouchStatusError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_TouchStatusPIVISecondary: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::TouchStatusPIVISecondaryStatus);
                                setActAndLogStatus(message, "TouchStatusPIVISecondary", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<TouchStatusPIVISecondaryStatus> payload = ::boost::static_pointer_cast<TouchStatusPIVISecondaryStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< TouchStatusPIVISecondaryStatus >& refNullableStatus = proxy->_touchStatusPIVISecondary;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((TouchStatusPIVISecondaryCallbackIF*) _callback)->onTouchStatusPIVISecondaryStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TouchStatusPIVISecondaryCallbackIF*) _callback)->onTouchStatusPIVISecondaryStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::input_main_fi::TouchStatusPIVISecondaryError);
                                setActAndLogError(message, "TouchStatusPIVISecondary", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((TouchStatusPIVISecondaryCallbackIF*) _callback)->onTouchStatusPIVISecondaryError(proxy, ::boost::static_pointer_cast<TouchStatusPIVISecondaryError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Input_main_fiProxy> proxy = ::boost::static_pointer_cast<Input_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_EnableInputEvents: {
                ::boost::shared_ptr< EnableInputEventsError > payload (new EnableInputEventsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EnableInputEvents", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((EnableInputEventsCallbackIF*) _callback)->onEnableInputEventsError (proxy, payload);
                return true;
            }
            case FID_DisableInputEvents: {
                ::boost::shared_ptr< DisableInputEventsError > payload (new DisableInputEventsError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisableInputEvents", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DisableInputEventsCallbackIF*) _callback)->onDisableInputEventsError (proxy, payload);
                return true;
            }
            case FID_simulateKeyInjection: {
                ::boost::shared_ptr< SimulateKeyInjectionError > payload (new SimulateKeyInjectionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulateKeyInjection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulateKeyInjectionCallbackIF*) _callback)->onSimulateKeyInjectionError (proxy, payload);
                return true;
            }
            case FID_simulateEncRotation: {
                ::boost::shared_ptr< SimulateEncRotationError > payload (new SimulateEncRotationError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulateEncRotation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulateEncRotationCallbackIF*) _callback)->onSimulateEncRotationError (proxy, payload);
                return true;
            }
            case FID_simulateSingleTouch: {
                ::boost::shared_ptr< SimulateSingleTouchError > payload (new SimulateSingleTouchError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulateSingleTouch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulateSingleTouchCallbackIF*) _callback)->onSimulateSingleTouchError (proxy, payload);
                return true;
            }
            case FID_simulateTouchSlide: {
                ::boost::shared_ptr< SimulateTouchSlideError > payload (new SimulateTouchSlideError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulateTouchSlide", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulateTouchSlideCallbackIF*) _callback)->onSimulateTouchSlideError (proxy, payload);
                return true;
            }
            case FID_simulateMultiTouch: {
                ::boost::shared_ptr< SimulateMultiTouchError > payload (new SimulateMultiTouchError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulateMultiTouch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulateMultiTouchCallbackIF*) _callback)->onSimulateMultiTouchError (proxy, payload);
                return true;
            }
            case FID_GestureRecord: {
                ::boost::shared_ptr< GestureRecordError > payload (new GestureRecordError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GestureRecord", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GestureRecordCallbackIF*) _callback)->onGestureRecordError (proxy, payload);
                return true;
            }
            case FID_GestureReplay: {
                ::boost::shared_ptr< GestureReplayError > payload (new GestureReplayError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GestureReplay", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((GestureReplayCallbackIF*) _callback)->onGestureReplayError (proxy, payload);
                return true;
            }
            case FID_simulatePIVITouch: {
                ::boost::shared_ptr< SimulatePIVITouchError > payload (new SimulatePIVITouchError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulatePIVITouch", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulatePIVITouchCallbackIF*) _callback)->onSimulatePIVITouchError (proxy, payload);
                return true;
            }
            case FID_DevInputNotifyConnection: {
                ::boost::shared_ptr< DevInputNotifyConnectionError > payload (new DevInputNotifyConnectionError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DevInputNotifyConnection", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((DevInputNotifyConnectionCallbackIF*) _callback)->onDevInputNotifyConnectionError (proxy, payload);
                return true;
            }
            case FID_simulatePIVITouchSlide: {
                ::boost::shared_ptr< SimulatePIVITouchSlideError > payload (new SimulatePIVITouchSlideError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SimulatePIVITouchSlide", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((SimulatePIVITouchSlideCallbackIF*) _callback)->onSimulatePIVITouchSlideError (proxy, payload);
                return true;
            }
            case FID_PressedKeys: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< PressedKeysError > payload (new PressedKeysError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PressedKeys", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((PressedKeysCallbackIF*) _callback)->onPressedKeysError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EncoderDirStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< EncoderDirStatusError > payload (new EncoderDirStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EncoderDirStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EncoderDirStatusCallbackIF*) _callback)->onEncoderDirStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EncoderStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< EncoderStatusError > payload (new EncoderStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EncoderStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EncoderStatusCallbackIF*) _callback)->onEncoderStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TouchStatus: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TouchStatusError > payload (new TouchStatusError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TouchStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TouchStatusCallbackIF*) _callback)->onTouchStatusError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_TouchStatusPIVISecondary: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< TouchStatusPIVISecondaryError > payload (new TouchStatusPIVISecondaryError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "TouchStatusPIVISecondary", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((TouchStatusPIVISecondaryCallbackIF*) _callback)->onTouchStatusPIVISecondaryError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Input_main_fiProxyCallback::_logger (Input_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Input_main_fiProxy > Input_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Input_main_fiProxy >  proxyNew(new Input_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Input_main_fiProxy > Input_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Input_main_fiProxy >  proxyNew(new Input_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Input_main_fiProxy > Input_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Input_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Input_main_fiProxy >  proxyNew(new Input_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Input_main_fiProxy::Input_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Input_main_fiProxy::~Input_main_fiProxy()
{
    LOG_INFO ("Entering ~Input_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Input_main_fiProxy::sendEnableInputEventsStart(EnableInputEventsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_EnableInputEvents);
        ::boost::shared_ptr< EnableInputEventsStart > payload (new EnableInputEventsStart());
        CCA_MESSAGE(ccaMessage,header,EnableInputEventsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "EnableInputEvents", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EnableInputEvents);
        ::boost::shared_ptr< EnableInputEventsError > payload (new EnableInputEventsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EnableInputEventsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "EnableInputEvents", &cb);
    }
}

act_t Input_main_fiProxy::sendDisableInputEventsStart(DisableInputEventsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DisableInputEvents);
        ::boost::shared_ptr< DisableInputEventsStart > payload (new DisableInputEventsStart());
        CCA_MESSAGE(ccaMessage,header,DisableInputEventsStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DisableInputEvents", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DisableInputEvents);
        ::boost::shared_ptr< DisableInputEventsError > payload (new DisableInputEventsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DisableInputEventsError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DisableInputEvents", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulateKeyInjectionStart(SimulateKeyInjectionCallbackIF& cb, ::input_main_fi_types::T_e16_KeyCode e16Keycode, uint8 u8KeyStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulateKeyInjection);
        ::boost::shared_ptr< SimulateKeyInjectionStart > payload (new SimulateKeyInjectionStart());
        payload->setE16Keycode(e16Keycode);
        payload->setU8KeyStatus(u8KeyStatus);
        CCA_MESSAGE(ccaMessage,header,SimulateKeyInjectionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulateKeyInjection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulateKeyInjection);
        ::boost::shared_ptr< SimulateKeyInjectionError > payload (new SimulateKeyInjectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateKeyInjectionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulateKeyInjection", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulateEncRotationStart(SimulateEncRotationCallbackIF& cb, ::input_main_fi_types::T_e8_EncoderType e8EncoderType, int8 s8EncSteps) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulateEncRotation);
        ::boost::shared_ptr< SimulateEncRotationStart > payload (new SimulateEncRotationStart());
        payload->setE8EncoderType(e8EncoderType);
        payload->setS8EncSteps(s8EncSteps);
        CCA_MESSAGE(ccaMessage,header,SimulateEncRotationStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulateEncRotation", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulateEncRotation);
        ::boost::shared_ptr< SimulateEncRotationError > payload (new SimulateEncRotationError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateEncRotationError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulateEncRotation", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulateSingleTouchStart(SimulateSingleTouchCallbackIF& cb, int32 s32XCoord, int32 s32YCoord, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulateSingleTouch);
        ::boost::shared_ptr< SimulateSingleTouchStart > payload (new SimulateSingleTouchStart());
        payload->setS32XCoord(s32XCoord);
        payload->setS32YCoord(s32YCoord);
        payload->setE8TouchStatus(e8TouchStatus);
        CCA_MESSAGE(ccaMessage,header,SimulateSingleTouchStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulateSingleTouch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulateSingleTouch);
        ::boost::shared_ptr< SimulateSingleTouchError > payload (new SimulateSingleTouchError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateSingleTouchError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulateSingleTouch", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulateTouchSlideStart(SimulateTouchSlideCallbackIF& cb, int32 s32XStart, int32 s32YStart, int32 s32XEnd, int32 s32YEnd, uint16 u16Duration) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulateTouchSlide);
        ::boost::shared_ptr< SimulateTouchSlideStart > payload (new SimulateTouchSlideStart());
        payload->setS32XStart(s32XStart);
        payload->setS32YStart(s32YStart);
        payload->setS32XEnd(s32XEnd);
        payload->setS32YEnd(s32YEnd);
        payload->setU16Duration(u16Duration);
        CCA_MESSAGE(ccaMessage,header,SimulateTouchSlideStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulateTouchSlide", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulateTouchSlide);
        ::boost::shared_ptr< SimulateTouchSlideError > payload (new SimulateTouchSlideError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateTouchSlideError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulateTouchSlide", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulateMultiTouchStart(SimulateMultiTouchCallbackIF& cb, int32 s32SlotId, int32 s32XCoord, int32 s32YCoord, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulateMultiTouch);
        ::boost::shared_ptr< SimulateMultiTouchStart > payload (new SimulateMultiTouchStart());
        payload->setS32SlotId(s32SlotId);
        payload->setS32XCoord(s32XCoord);
        payload->setS32YCoord(s32YCoord);
        payload->setE8TouchStatus(e8TouchStatus);
        CCA_MESSAGE(ccaMessage,header,SimulateMultiTouchStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulateMultiTouch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulateMultiTouch);
        ::boost::shared_ptr< SimulateMultiTouchError > payload (new SimulateMultiTouchError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulateMultiTouchError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulateMultiTouch", &cb);
    }
}

act_t Input_main_fiProxy::sendGestureRecordStart(GestureRecordCallbackIF& cb, uint8 u8StartStop, const ::std::string& filePath) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GestureRecord);
        ::boost::shared_ptr< GestureRecordStart > payload (new GestureRecordStart());
        payload->setU8StartStop(u8StartStop);
        payload->setFilePath(filePath);
        CCA_MESSAGE(ccaMessage,header,GestureRecordStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GestureRecord", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GestureRecord);
        ::boost::shared_ptr< GestureRecordError > payload (new GestureRecordError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GestureRecordError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GestureRecord", &cb);
    }
}

act_t Input_main_fiProxy::sendGestureReplayStart(GestureReplayCallbackIF& cb, uint8 u8StartStop, const ::std::string& filePath) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_GestureReplay);
        ::boost::shared_ptr< GestureReplayStart > payload (new GestureReplayStart());
        payload->setU8StartStop(u8StartStop);
        payload->setFilePath(filePath);
        CCA_MESSAGE(ccaMessage,header,GestureReplayStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "GestureReplay", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_GestureReplay);
        ::boost::shared_ptr< GestureReplayError > payload (new GestureReplayError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,GestureReplayError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "GestureReplay", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulatePIVITouchStart(SimulatePIVITouchCallbackIF& cb, int32 s32XCoord, int32 s32YCoord, int32 s32ScreenNumber, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulatePIVITouch);
        ::boost::shared_ptr< SimulatePIVITouchStart > payload (new SimulatePIVITouchStart());
        payload->setS32XCoord(s32XCoord);
        payload->setS32YCoord(s32YCoord);
        payload->setS32ScreenNumber(s32ScreenNumber);
        payload->setE8TouchStatus(e8TouchStatus);
        CCA_MESSAGE(ccaMessage,header,SimulatePIVITouchStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulatePIVITouch", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulatePIVITouch);
        ::boost::shared_ptr< SimulatePIVITouchError > payload (new SimulatePIVITouchError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulatePIVITouchError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulatePIVITouch", &cb);
    }
}

act_t Input_main_fiProxy::sendDevInputNotifyConnectionStart(DevInputNotifyConnectionCallbackIF& cb, ::input_main_fi_types::T_e8_Device deviceType, ::input_main_fi_types::T_e8_DeviceConnectStatus deviceConnectStatus, const ::std::string& deviceName) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_DevInputNotifyConnection);
        ::boost::shared_ptr< DevInputNotifyConnectionStart > payload (new DevInputNotifyConnectionStart());
        payload->setDeviceType(deviceType);
        payload->setDeviceConnectStatus(deviceConnectStatus);
        payload->setDeviceName(deviceName);
        CCA_MESSAGE(ccaMessage,header,DevInputNotifyConnectionStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "DevInputNotifyConnection", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_DevInputNotifyConnection);
        ::boost::shared_ptr< DevInputNotifyConnectionError > payload (new DevInputNotifyConnectionError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,DevInputNotifyConnectionError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "DevInputNotifyConnection", &cb);
    }
}

act_t Input_main_fiProxy::sendSimulatePIVITouchSlideStart(SimulatePIVITouchSlideCallbackIF& cb, int32 s32XStart, int32 s32YStart, int32 s32XEnd, int32 s32YEnd, uint16 u16Duration) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_simulatePIVITouchSlide);
        ::boost::shared_ptr< SimulatePIVITouchSlideStart > payload (new SimulatePIVITouchSlideStart());
        payload->setS32XStart(s32XStart);
        payload->setS32YStart(s32YStart);
        payload->setS32XEnd(s32XEnd);
        payload->setS32YEnd(s32YEnd);
        payload->setU16Duration(u16Duration);
        CCA_MESSAGE(ccaMessage,header,SimulatePIVITouchSlideStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "SimulatePIVITouchSlide", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_simulatePIVITouchSlide);
        ::boost::shared_ptr< SimulatePIVITouchSlideError > payload (new SimulatePIVITouchSlideError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,SimulatePIVITouchSlideError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "SimulatePIVITouchSlide", &cb);
    }
}

act_t Input_main_fiProxy::sendPressedKeysUpReg(PressedKeysCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_PressedKeys);
        ::boost::shared_ptr< PressedKeysUpReg > payload (new PressedKeysUpReg());
        CCA_MESSAGE(ccaMessage,header,PressedKeysUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< PressedKeysRelUpReg > payloadRelUpRegHeap (new PressedKeysRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_PressedKeys, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::input_main_fi::PressedKeysRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_PressedKeys, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "PressedKeys", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "PressedKeys", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasPressedKeys()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_PressedKeys, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< PressedKeysStatus > payloadLoopback (new PressedKeysStatus(getPressedKeys()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,PressedKeysStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PressedKeys);
        ::boost::shared_ptr< PressedKeysError > payload (new PressedKeysError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PressedKeysError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "PressedKeys", &cb);
    }
}

bool Input_main_fiProxy::sendPressedKeysRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_PressedKeys,"PressedKeys");
}

void Input_main_fiProxy::sendPressedKeysRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_PressedKeys);
}

const PressedKeysStatus& Input_main_fiProxy::getPressedKeys() const {
    return _pressedKeys.get();
}

bool Input_main_fiProxy::hasPressedKeys() const {
    return _pressedKeys.hasValue();
}

act_t Input_main_fiProxy::sendPressedKeysGet(PressedKeysCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_PressedKeys);
        ::boost::shared_ptr< PressedKeysGet > payload (new PressedKeysGet());
        CCA_MESSAGE(ccaMessage,header,PressedKeysGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "PressedKeys", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_PressedKeys);
        ::boost::shared_ptr< PressedKeysError > payload (new PressedKeysError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,PressedKeysError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "PressedKeys", &cb);
    }
}

act_t Input_main_fiProxy::sendEncoderDirStatusUpReg(EncoderDirStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EncoderDirStatus);
        ::boost::shared_ptr< EncoderDirStatusUpReg > payload (new EncoderDirStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,EncoderDirStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EncoderDirStatusRelUpReg > payloadRelUpRegHeap (new EncoderDirStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EncoderDirStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::input_main_fi::EncoderDirStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EncoderDirStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EncoderDirStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EncoderDirStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEncoderDirStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EncoderDirStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EncoderDirStatusStatus > payloadLoopback (new EncoderDirStatusStatus(getEncoderDirStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EncoderDirStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EncoderDirStatus);
        ::boost::shared_ptr< EncoderDirStatusError > payload (new EncoderDirStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EncoderDirStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EncoderDirStatus", &cb);
    }
}

bool Input_main_fiProxy::sendEncoderDirStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EncoderDirStatus,"EncoderDirStatus");
}

void Input_main_fiProxy::sendEncoderDirStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EncoderDirStatus);
}

const EncoderDirStatusStatus& Input_main_fiProxy::getEncoderDirStatus() const {
    return _encoderDirStatus.get();
}

bool Input_main_fiProxy::hasEncoderDirStatus() const {
    return _encoderDirStatus.hasValue();
}

act_t Input_main_fiProxy::sendEncoderDirStatusGet(EncoderDirStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_EncoderDirStatus);
        ::boost::shared_ptr< EncoderDirStatusGet > payload (new EncoderDirStatusGet());
        CCA_MESSAGE(ccaMessage,header,EncoderDirStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "EncoderDirStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EncoderDirStatus);
        ::boost::shared_ptr< EncoderDirStatusError > payload (new EncoderDirStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EncoderDirStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "EncoderDirStatus", &cb);
    }
}

act_t Input_main_fiProxy::sendEncoderStatusUpReg(EncoderStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EncoderStatus);
        ::boost::shared_ptr< EncoderStatusUpReg > payload (new EncoderStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,EncoderStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EncoderStatusRelUpReg > payloadRelUpRegHeap (new EncoderStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EncoderStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::input_main_fi::EncoderStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EncoderStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EncoderStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EncoderStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEncoderStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EncoderStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EncoderStatusStatus > payloadLoopback (new EncoderStatusStatus(getEncoderStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EncoderStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EncoderStatus);
        ::boost::shared_ptr< EncoderStatusError > payload (new EncoderStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EncoderStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EncoderStatus", &cb);
    }
}

bool Input_main_fiProxy::sendEncoderStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EncoderStatus,"EncoderStatus");
}

void Input_main_fiProxy::sendEncoderStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EncoderStatus);
}

const EncoderStatusStatus& Input_main_fiProxy::getEncoderStatus() const {
    return _encoderStatus.get();
}

bool Input_main_fiProxy::hasEncoderStatus() const {
    return _encoderStatus.hasValue();
}

act_t Input_main_fiProxy::sendEncoderStatusGet(EncoderStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_EncoderStatus);
        ::boost::shared_ptr< EncoderStatusGet > payload (new EncoderStatusGet());
        CCA_MESSAGE(ccaMessage,header,EncoderStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "EncoderStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EncoderStatus);
        ::boost::shared_ptr< EncoderStatusError > payload (new EncoderStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EncoderStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "EncoderStatus", &cb);
    }
}

act_t Input_main_fiProxy::sendTouchStatusUpReg(TouchStatusCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TouchStatus);
        ::boost::shared_ptr< TouchStatusUpReg > payload (new TouchStatusUpReg());
        CCA_MESSAGE(ccaMessage,header,TouchStatusUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TouchStatusRelUpReg > payloadRelUpRegHeap (new TouchStatusRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TouchStatus, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::input_main_fi::TouchStatusRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TouchStatus, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TouchStatus", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TouchStatus", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTouchStatus()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TouchStatus, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TouchStatusStatus > payloadLoopback (new TouchStatusStatus(getTouchStatus()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TouchStatusStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TouchStatus);
        ::boost::shared_ptr< TouchStatusError > payload (new TouchStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TouchStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TouchStatus", &cb);
    }
}

bool Input_main_fiProxy::sendTouchStatusRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TouchStatus,"TouchStatus");
}

void Input_main_fiProxy::sendTouchStatusRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TouchStatus);
}

const TouchStatusStatus& Input_main_fiProxy::getTouchStatus() const {
    return _touchStatus.get();
}

bool Input_main_fiProxy::hasTouchStatus() const {
    return _touchStatus.hasValue();
}

act_t Input_main_fiProxy::sendTouchStatusGet(TouchStatusCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TouchStatus);
        ::boost::shared_ptr< TouchStatusGet > payload (new TouchStatusGet());
        CCA_MESSAGE(ccaMessage,header,TouchStatusGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TouchStatus", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TouchStatus);
        ::boost::shared_ptr< TouchStatusError > payload (new TouchStatusError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TouchStatusError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TouchStatus", &cb);
    }
}

act_t Input_main_fiProxy::sendTouchStatusPIVISecondaryUpReg(TouchStatusPIVISecondaryCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_TouchStatusPIVISecondary);
        ::boost::shared_ptr< TouchStatusPIVISecondaryUpReg > payload (new TouchStatusPIVISecondaryUpReg());
        CCA_MESSAGE(ccaMessage,header,TouchStatusPIVISecondaryUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< TouchStatusPIVISecondaryRelUpReg > payloadRelUpRegHeap (new TouchStatusPIVISecondaryRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_TouchStatusPIVISecondary, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::input_main_fi::TouchStatusPIVISecondaryRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_TouchStatusPIVISecondary, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "TouchStatusPIVISecondary", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "TouchStatusPIVISecondary", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasTouchStatusPIVISecondary()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_TouchStatusPIVISecondary, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< TouchStatusPIVISecondaryStatus > payloadLoopback (new TouchStatusPIVISecondaryStatus(getTouchStatusPIVISecondary()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,TouchStatusPIVISecondaryStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TouchStatusPIVISecondary);
        ::boost::shared_ptr< TouchStatusPIVISecondaryError > payload (new TouchStatusPIVISecondaryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TouchStatusPIVISecondaryError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "TouchStatusPIVISecondary", &cb);
    }
}

bool Input_main_fiProxy::sendTouchStatusPIVISecondaryRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_TouchStatusPIVISecondary,"TouchStatusPIVISecondary");
}

void Input_main_fiProxy::sendTouchStatusPIVISecondaryRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_TouchStatusPIVISecondary);
}

const TouchStatusPIVISecondaryStatus& Input_main_fiProxy::getTouchStatusPIVISecondary() const {
    return _touchStatusPIVISecondary.get();
}

bool Input_main_fiProxy::hasTouchStatusPIVISecondary() const {
    return _touchStatusPIVISecondary.hasValue();
}

act_t Input_main_fiProxy::sendTouchStatusPIVISecondaryGet(TouchStatusPIVISecondaryCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_TouchStatusPIVISecondary);
        ::boost::shared_ptr< TouchStatusPIVISecondaryGet > payload (new TouchStatusPIVISecondaryGet());
        CCA_MESSAGE(ccaMessage,header,TouchStatusPIVISecondaryGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "TouchStatusPIVISecondary", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_TouchStatusPIVISecondary);
        ::boost::shared_ptr< TouchStatusPIVISecondaryError > payload (new TouchStatusPIVISecondaryError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,TouchStatusPIVISecondaryError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "TouchStatusPIVISecondary", &cb);
    }
}


void Input_main_fiProxy::clearAllProperties ()
{
    _pressedKeys = ::asf::core::nullable<PressedKeysStatus>();
    _encoderDirStatus = ::asf::core::nullable<EncoderDirStatusStatus>();
    _encoderStatus = ::asf::core::nullable<EncoderStatusStatus>();
    _touchStatus = ::asf::core::nullable<TouchStatusStatus>();
    _touchStatusPIVISecondary = ::asf::core::nullable<TouchStatusPIVISecondaryStatus>();
}

void Input_main_fiProxy::sendRelUpRegAll()
{
    sendPressedKeysRelUpRegAll();
    sendEncoderDirStatusRelUpRegAll();
    sendEncoderStatusRelUpRegAll();
    sendTouchStatusRelUpRegAll();
    sendTouchStatusPIVISecondaryRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Input_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Input_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace input_main_fi
