#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef INPUT_MAIN_FI_H
#define INPUT_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "input_main_fi_types.h"
#include "input_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'input_main_fi'
 *
 * Fullname: VD_Input CCA Service, Application Functional Interface
 *
 * Version:
 *
 * Author: Sandeep Gupta
 *
 * Date: $Date: 03 Sep 2015 09:00:00  $
 *
 * Department:
 *
 * Title: VD_INPUT_FI
 *
 * <b>Description of 'input_main_fi':</b>
 *
 * VD_Input messages for CCA applications
 */

namespace input_main_fi {

static const int SERVICE_ID = 181;

static const int FID_PressedKeys = 4097;

static const int FID_EncoderDirStatus = 4098;

static const int FID_EncoderStatus = 4099;

static const int FID_TouchStatus = 4100;

static const int FID_TouchStatusPIVISecondary = 4101;

static const int FID_EnableInputEvents = 20480;

static const int FID_DisableInputEvents = 20481;

static const int FID_simulateKeyInjection = 20482;

static const int FID_simulateEncRotation = 20483;

static const int FID_simulateSingleTouch = 20484;

static const int FID_simulateTouchSlide = 20485;

static const int FID_simulateMultiTouch = 20486;

static const int FID_GestureRecord = 20487;

static const int FID_GestureReplay = 20488;

static const int FID_simulatePIVITouch = 20489;

static const int FID_DevInputNotifyConnection = 20496;

static const int FID_simulatePIVITouchSlide = 20497;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 3;

// forward declarations
class PressedKeysStatus;

class PressedKeysErrorStructure;

class PressedKeysError;

class EncoderDirStatusStatus;

class EncoderDirStatusErrorStructure;

class EncoderDirStatusError;

class EncoderStatusStatus;

class EncoderStatusErrorStructure;

class EncoderStatusError;

class TouchStatusStatus;

class TouchStatusErrorStructure;

class TouchStatusError;

class TouchStatusPIVISecondaryStatus;

class TouchStatusPIVISecondaryErrorStructure;

class TouchStatusPIVISecondaryError;

class EnableInputEventsResult;

class DisableInputEventsResult;

class SimulateKeyInjectionStart;

class SimulateEncRotationStart;

class SimulateSingleTouchStart;

class SimulateTouchSlideStart;

class SimulateMultiTouchStart;

class GestureRecordStart;

class GestureRecordResult;

class GestureReplayStart;

class GestureReplayResult;

class SimulatePIVITouchStart;

class DevInputNotifyConnectionStart;

class SimulatePIVITouchSlideStart;

// type definitions
/**
 * The get message of the property "PressedKeys"
 * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
 * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
 * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
 * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
 * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
 * Message to request the current KeyPressed List
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PressedKeysGet;

/**
 * The upreg message of the property "PressedKeys"
 * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
 * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
 * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
 * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
 * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PressedKeysUpReg;

/**
 * The relUpReg message of the property "PressedKeys"
 * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
 * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
 * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
 * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
 * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage PressedKeysRelUpReg;

/**
 * The get message of the property "EncoderDirStatus"
 * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
 * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
 * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
 * Message to request the current Encoder Direction List
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EncoderDirStatusGet;

/**
 * The upreg message of the property "EncoderDirStatus"
 * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
 * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
 * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EncoderDirStatusUpReg;

/**
 * The relUpReg message of the property "EncoderDirStatus"
 * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
 * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
 * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EncoderDirStatusRelUpReg;

/**
 * The get message of the property "EncoderStatus"
 * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
 * <p>Enc type: Left or Right Encoder</p>
 * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
 * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
 * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
 * Message to request the current Encoder Event Status
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EncoderStatusGet;

/**
 * The upreg message of the property "EncoderStatus"
 * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
 * <p>Enc type: Left or Right Encoder</p>
 * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
 * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
 * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EncoderStatusUpReg;

/**
 * The relUpReg message of the property "EncoderStatus"
 * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
 * <p>Enc type: Left or Right Encoder</p>
 * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
 * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
 * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EncoderStatusRelUpReg;

/**
 * The get message of the property "TouchStatus"
 * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 * Message to request the current Touch Status List
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TouchStatusGet;

/**
 * The upreg message of the property "TouchStatus"
 * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TouchStatusUpReg;

/**
 * The relUpReg message of the property "TouchStatus"
 * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TouchStatusRelUpReg;

/**
 * The get message of the property "TouchStatusPIVISecondary"
 * <p>This contains touch Info for PIVI Secondary Screen</p>
 * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 * Message to request the current Touch Status List
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TouchStatusPIVISecondaryGet;

/**
 * The upreg message of the property "TouchStatusPIVISecondary"
 * <p>This contains touch Info for PIVI Secondary Screen</p>
 * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TouchStatusPIVISecondaryUpReg;

/**
 * The relUpReg message of the property "TouchStatusPIVISecondary"
 * <p>This contains touch Info for PIVI Secondary Screen</p>
 * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage TouchStatusPIVISecondaryRelUpReg;

/**
 * The start message of the method "EnableInputEvents"
 * <p>Client Shall First Enable Input Events by calling this method to receive events and also for injecting events</p>
 * <p>Input Events are Key,Encoder and Touch</p>
 * <p>Also this Method shall enable Event Observer Module to fetch and feedback Input Events</p>
 * Enable Simulation of Key, Encoder and touch events
 */
typedef ::asf::cca::CcaTypes::DefaultMessage EnableInputEventsStart;

/**
 * The abort error message of the method "EnableInputEvents"
 * <p>Client Shall First Enable Input Events by calling this method to receive events and also for injecting events</p>
 * <p>Input Events are Key,Encoder and Touch</p>
 * <p>Also this Method shall enable Event Observer Module to fetch and feedback Input Events</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError EnableInputEventsAbortError;

/**
 * The error message of 'EnableInputEvents'
 */
typedef ::asf::cca::CcaTypes::DefaultError EnableInputEventsError;

/**
 * The start message of the method "DisableInputEvents"
 * <p>Client Shall disable Input Events by calling this method to stop receiving events and also injecting of events</p>
 * <p>Input Events are Key,Encoder and Touch</p>
 * <p>Also this Method shall Stop Event Observer Module to fetch and feedback Input Events</p>
 * Disable Simulation of Key, Encoder and touch events
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DisableInputEventsStart;

/**
 * The abort error message of the method "DisableInputEvents"
 * <p>Client Shall disable Input Events by calling this method to stop receiving events and also injecting of events</p>
 * <p>Input Events are Key,Encoder and Touch</p>
 * <p>Also this Method shall Stop Event Observer Module to fetch and feedback Input Events</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError DisableInputEventsAbortError;

/**
 * The error message of 'DisableInputEvents'
 */
typedef ::asf::cca::CcaTypes::DefaultError DisableInputEventsError;

/**
 * The result message of the method "simulateKeyInjection"
 * This method is used to simulate HardKey, SWC Key, System and Encoder Keys Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateKeyInjectionResult;

/**
 * The abort error message of the method "simulateKeyInjection"
 * This method is used to simulate HardKey, SWC Key, System and Encoder Keys Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateKeyInjectionAbortError;

/**
 * The error message of 'simulateKeyInjection'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateKeyInjectionError;

/**
 * The result message of the method "simulateEncRotation"
 * This method is used to simulate Left and Right Encoder Rotation in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateEncRotationResult;

/**
 * The abort error message of the method "simulateEncRotation"
 * This method is used to simulate Left and Right Encoder Rotation in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateEncRotationAbortError;

/**
 * The error message of 'simulateEncRotation'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateEncRotationError;

/**
 * The result message of the method "simulateSingleTouch"
 * This method is used to simulate Single Touch Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateSingleTouchResult;

/**
 * The abort error message of the method "simulateSingleTouch"
 * This method is used to simulate Single Touch Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateSingleTouchAbortError;

/**
 * The error message of 'simulateSingleTouch'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateSingleTouchError;

/**
 * The result message of the method "simulateTouchSlide"
 * This method is used to simulate Touch slide gesture in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateTouchSlideResult;

/**
 * The abort error message of the method "simulateTouchSlide"
 * This method is used to simulate Touch slide gesture in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateTouchSlideAbortError;

/**
 * The error message of 'simulateTouchSlide'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateTouchSlideError;

/**
 * The result message of the method "simulateMultiTouch"
 * This method is used to simulate Multi Touch Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulateMultiTouchResult;

/**
 * The abort error message of the method "simulateMultiTouch"
 * This method is used to simulate Multi Touch Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateMultiTouchAbortError;

/**
 * The error message of 'simulateMultiTouch'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulateMultiTouchError;

/**
 * The abort error message of the method "GestureRecord"
 * <p>This method is used to Record Sequence of User Inputs, Touch, Key, Encoder.</p>
 * <p>This can be used to record series of touch events and store them in some eg:/tmp/GuestureName(optional .txt or .ev file extension) file in target.</p>
 * <p>User can then save this file and use to replay Guestures.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GestureRecordAbortError;

/**
 * The error message of 'GestureRecord'
 */
typedef ::asf::cca::CcaTypes::DefaultError GestureRecordError;

/**
 * The abort error message of the method "GestureReplay"
 * <p>This method is used to Replay Sequence of User Inputs, Touch, Key, Encoder.</p>
 * <p>This can be used to Replay series of touch events from file stored in Target File system eg: /tmp/GuestureName(optional .txt or .ev file extension).</p>
 * <p>User shall ensure this file is present at specified path in target file system and accessible.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError GestureReplayAbortError;

/**
 * The error message of 'GestureReplay'
 */
typedef ::asf::cca::CcaTypes::DefaultError GestureReplayError;

/**
 * The result message of the method "simulatePIVITouch"
 * This method is used to simulate PIVI Touch Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulatePIVITouchResult;

/**
 * The abort error message of the method "simulatePIVITouch"
 * This method is used to simulate PIVI Touch Press or Release in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulatePIVITouchAbortError;

/**
 * The error message of 'simulatePIVITouch'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulatePIVITouchError;

/**
 * The result message of the method "DevInputNotifyConnection"
 * This method is used to get trigger DevManagerNotifyConnection from vd_device manager via switchctrl
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DevInputNotifyConnectionResult;

/**
 * The abort error message of the method "DevInputNotifyConnection"
 * This method is used to get trigger DevManagerNotifyConnection from vd_device manager via switchctrl
 */
typedef ::asf::cca::CcaTypes::DefaultError DevInputNotifyConnectionAbortError;

/**
 * The error message of 'DevInputNotifyConnection'
 */
typedef ::asf::cca::CcaTypes::DefaultError DevInputNotifyConnectionError;

/**
 * The result message of the method "simulatePIVITouchSlide"
 * This method is used to simulate PIVI Touch slide gesture in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SimulatePIVITouchSlideResult;

/**
 * The abort error message of the method "simulatePIVITouchSlide"
 * This method is used to simulate PIVI Touch slide gesture in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulatePIVITouchSlideAbortError;

/**
 * The error message of 'simulatePIVITouchSlide'
 */
typedef ::asf::cca::CcaTypes::DefaultError SimulatePIVITouchSlideError;


/**
 * The status message of the property "PressedKeys"
 * <p>Property PressedKeys contains a list of structure with the logical HMI key codes Enum(2 bytes), Status (1 Byte)</p>
 * <p>The list shall be sorted with the oldest key first. If no key is pressed the list shall be empty</p>
 * <p>The key status 1 indicates Pressed and 2 indicates delayed state.</p>
 * <p>This list will have All Hardkeys, SWC Keys and Encoder Press ENTER Key</p>
 * <p>This list will have Key information till 2 secs and all Key info > 2secs shall be deleted</p>
 */
class PressedKeysStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PressedKeysStatus ();

    /**
     * Copy constructor
     */
    inline  PressedKeysStatus (const PressedKeysStatus &rhs);

    /**
     * All fields constructor
     */
    inline  PressedKeysStatus (const ::input_main_fi_types::T_DiagKeyList& KeyInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~PressedKeysStatus();

    /**
     * Assignment operator
     */
    inline PressedKeysStatus& operator = (const PressedKeysStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PressedKeysStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PressedKeysStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PressedKeysStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PressedKeysStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "KeyInfoList"

    static const int kKeyInfoList = 0;

    /**
     * Clears the field "KeyInfoList".
     *
     * The field will be set to its default value. The hasKeyInfoList()
     * method will return false.
     */
    inline void clearKeyInfoList();

    /**
     * Checks whether the field "KeyInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setKeyInfoList()). Otherwise it will return false.
     */
    inline bool hasKeyInfoList () const;

    /**
     * Returns the value of the member "KeyInfoList".
     *
     * Key information
     *
     * @return The value of the field "KeyInfoList"
     */
    inline const ::input_main_fi_types::T_DiagKeyList& getKeyInfoList () const;

    /**
     * Retrieves the value of the field "KeyInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "KeyInfoList".
     */
    inline ::input_main_fi_types::T_DiagKeyList& getKeyInfoListMutable ();

    /**
     * Sets the value of the member "KeyInfoList".
     *
     * Key information
     *
     * @param KeyInfoList The value which will be set
     */
    inline void setKeyInfoList (const ::input_main_fi_types::T_DiagKeyList& KeyInfoList_);

    static const PressedKeysStatus &getDefaultInstance();

private:

    static const ::std::vector< ::input_main_fi_types::T_KeyInfo >& getT_KeyInfoList_DefaultInstance ();

    inline void set_has_KeyInfoList ();

    inline void clear_has_KeyInfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::input_main_fi_types::T_DiagKeyList _KeyInfoList;

};

/**
 * The error message of 'PressedKeys'
 */
class PressedKeysErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  PressedKeysErrorStructure ();

    /**
     * Copy constructor
     */
    inline  PressedKeysErrorStructure (const PressedKeysErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  PressedKeysErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~PressedKeysErrorStructure();

    /**
     * Assignment operator
     */
    inline PressedKeysErrorStructure& operator = (const PressedKeysErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PressedKeysErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PressedKeysErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PressedKeysErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PressedKeysErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const PressedKeysErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'PressedKeys'
 */
class PressedKeysError  : public ::asf::core::Payload {
public:

    enum PressedKeysErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  PressedKeysError ();

   /**
     * Copy constructor
     */
    inline  PressedKeysError (const PressedKeysError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~PressedKeysError();

    /**
     * Assigns a new value to this object.
     */
    inline PressedKeysError& operator = (const PressedKeysError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PressedKeysError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PressedKeysError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PressedKeysError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PressedKeysError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline PressedKeysError::PressedKeysErrorField getField () const;

    inline void setField(PressedKeysError::PressedKeysErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "PressedKeysErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "PressedKeysErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const PressedKeysErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline PressedKeysErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline PressedKeysErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (PressedKeysErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "PressedKeysErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const PressedKeysErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const PressedKeysError &getDefaultInstance();

private:

    inline void cloneData (const PressedKeysError& rhs);

    inline void deleteData ();

    PressedKeysErrorField __field;

    union {
        PressedKeysErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "EncoderDirStatus"
 * <p>Property EncoderDirStatus contains a list of structure with the EncType Enum(1 byte), s8Value (1 Byte)</p>
 * <p>The Enc Value +ve indicates Clockwise and -ve value indicates Anticlockwise rotation.</p>
 * <p>This list will have encoder information till 2 secs and all encoder entries > 2secs shall be deleted</p>
 */
class EncoderDirStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EncoderDirStatusStatus ();

    /**
     * Copy constructor
     */
    inline  EncoderDirStatusStatus (const EncoderDirStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EncoderDirStatusStatus (const ::input_main_fi_types::T_EncoderDirectionList& tEncoderDirectionList_);

    /**
     * Destructor
     */
    inline virtual  ~EncoderDirStatusStatus();

    /**
     * Assignment operator
     */
    inline EncoderDirStatusStatus& operator = (const EncoderDirStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderDirStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderDirStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderDirStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderDirStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tEncoderDirectionList"

    static const int kTEncoderDirectionList = 0;

    /**
     * Clears the field "tEncoderDirectionList".
     *
     * The field will be set to its default value. The hasTEncoderDirectionList()
     * method will return false.
     */
    inline void clearTEncoderDirectionList();

    /**
     * Checks whether the field "tEncoderDirectionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTEncoderDirectionList()). Otherwise it will return false.
     */
    inline bool hasTEncoderDirectionList () const;

    /**
     * Returns the value of the member "tEncoderDirectionList".
     *
     * List of structure for Encoder direction rotation information
     *
     * @return The value of the field "tEncoderDirectionList"
     */
    inline const ::input_main_fi_types::T_EncoderDirectionList& getTEncoderDirectionList () const;

    /**
     * Retrieves the value of the field "tEncoderDirectionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tEncoderDirectionList".
     */
    inline ::input_main_fi_types::T_EncoderDirectionList& getTEncoderDirectionListMutable ();

    /**
     * Sets the value of the member "tEncoderDirectionList".
     *
     * List of structure for Encoder direction rotation information
     *
     * @param tEncoderDirectionList The value which will be set
     */
    inline void setTEncoderDirectionList (const ::input_main_fi_types::T_EncoderDirectionList& tEncoderDirectionList_);

    static const EncoderDirStatusStatus &getDefaultInstance();

private:

    static const ::std::vector< ::input_main_fi_types::T_EncInfo >& getT_EncInfoList_DefaultInstance ();

    inline void set_has_tEncoderDirectionList ();

    inline void clear_has_tEncoderDirectionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::input_main_fi_types::T_EncoderDirectionList _tEncoderDirectionList;

};

/**
 * The error message of 'EncoderDirStatus'
 */
class EncoderDirStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EncoderDirStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EncoderDirStatusErrorStructure (const EncoderDirStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EncoderDirStatusErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~EncoderDirStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline EncoderDirStatusErrorStructure& operator = (const EncoderDirStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderDirStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderDirStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderDirStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderDirStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const EncoderDirStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'EncoderDirStatus'
 */
class EncoderDirStatusError  : public ::asf::core::Payload {
public:

    enum EncoderDirStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EncoderDirStatusError ();

   /**
     * Copy constructor
     */
    inline  EncoderDirStatusError (const EncoderDirStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EncoderDirStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline EncoderDirStatusError& operator = (const EncoderDirStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderDirStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderDirStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderDirStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderDirStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EncoderDirStatusError::EncoderDirStatusErrorField getField () const;

    inline void setField(EncoderDirStatusError::EncoderDirStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EncoderDirStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EncoderDirStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EncoderDirStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EncoderDirStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EncoderDirStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EncoderDirStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EncoderDirStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EncoderDirStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EncoderDirStatusError &getDefaultInstance();

private:

    inline void cloneData (const EncoderDirStatusError& rhs);

    inline void deleteData ();

    EncoderDirStatusErrorField __field;

    union {
        EncoderDirStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "EncoderStatus"
 * <p>EncoderStatus Property provides Encoder Value of Rotation in steps at current state.</p>
 * <p>Enc type: Left or Right Encoder</p>
 * <p>Enc_1 and Enc_2 Value shall start with 0 on startup of EventObserver when diag will call Method EnableInputEvents.</p>
 * <p>Then each value increments or decrements depending on direction of rotation. Range of Enc Values -128 to 127</p>
 * <p>Client can also use this property to inject Encoder events by passing SimulatedEncoderData</p>
 */
class EncoderStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EncoderStatusStatus ();

    /**
     * Copy constructor
     */
    inline  EncoderStatusStatus (const EncoderStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  EncoderStatusStatus (const ::input_main_fi_types::T_EncoderStatus& tEncoderStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EncoderStatusStatus();

    /**
     * Assignment operator
     */
    inline EncoderStatusStatus& operator = (const EncoderStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tEncoderStatus"

    static const int kTEncoderStatus = 0;

    /**
     * Clears the field "tEncoderStatus".
     *
     * The field will be set to its default value. The hasTEncoderStatus()
     * method will return false.
     */
    inline void clearTEncoderStatus();

    /**
     * Checks whether the field "tEncoderStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTEncoderStatus()). Otherwise it will return false.
     */
    inline bool hasTEncoderStatus () const;

    /**
     * Returns the value of the member "tEncoderStatus".
     *
     * <p>Encoder information in a structure presently 2 encoders</p>
     * <p>Enc_1 - Volume or Left Encoder Value</p>
     * <p>Enc_2 - Browse or Right Encoder Value</p>
     *
     * @return The value of the field "tEncoderStatus"
     */
    inline const ::input_main_fi_types::T_EncoderStatus& getTEncoderStatus () const;

    /**
     * Retrieves the value of the field "tEncoderStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tEncoderStatus".
     */
    inline ::input_main_fi_types::T_EncoderStatus& getTEncoderStatusMutable ();

    /**
     * Sets the value of the member "tEncoderStatus".
     *
     * <p>Encoder information in a structure presently 2 encoders</p>
     * <p>Enc_1 - Volume or Left Encoder Value</p>
     * <p>Enc_2 - Browse or Right Encoder Value</p>
     *
     * @param tEncoderStatus The value which will be set
     */
    inline void setTEncoderStatus (const ::input_main_fi_types::T_EncoderStatus& tEncoderStatus_);

    static const EncoderStatusStatus &getDefaultInstance();

private:

    inline void set_has_tEncoderStatus ();

    inline void clear_has_tEncoderStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::input_main_fi_types::T_EncoderStatus _tEncoderStatus;

};

/**
 * The error message of 'EncoderStatus'
 */
class EncoderStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  EncoderStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  EncoderStatusErrorStructure (const EncoderStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  EncoderStatusErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~EncoderStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline EncoderStatusErrorStructure& operator = (const EncoderStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const EncoderStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'EncoderStatus'
 */
class EncoderStatusError  : public ::asf::core::Payload {
public:

    enum EncoderStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  EncoderStatusError ();

   /**
     * Copy constructor
     */
    inline  EncoderStatusError (const EncoderStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~EncoderStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline EncoderStatusError& operator = (const EncoderStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EncoderStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EncoderStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EncoderStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EncoderStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline EncoderStatusError::EncoderStatusErrorField getField () const;

    inline void setField(EncoderStatusError::EncoderStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "EncoderStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "EncoderStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const EncoderStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline EncoderStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline EncoderStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (EncoderStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "EncoderStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const EncoderStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const EncoderStatusError &getDefaultInstance();

private:

    inline void cloneData (const EncoderStatusError& rhs);

    inline void deleteData ();

    EncoderStatusErrorField __field;

    union {
        EncoderStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TouchStatus"
 * <p>Property TouchStatus contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 */
class TouchStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TouchStatusStatus ();

    /**
     * Copy constructor
     */
    inline  TouchStatusStatus (const TouchStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TouchStatusStatus (const ::input_main_fi_types::T_TouchDataList& tTouchDataList_);

    /**
     * Destructor
     */
    inline virtual  ~TouchStatusStatus();

    /**
     * Assignment operator
     */
    inline TouchStatusStatus& operator = (const TouchStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TouchStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TouchStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TouchStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TouchStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tTouchDataList"

    static const int kTTouchDataList = 0;

    /**
     * Clears the field "tTouchDataList".
     *
     * The field will be set to its default value. The hasTTouchDataList()
     * method will return false.
     */
    inline void clearTTouchDataList();

    /**
     * Checks whether the field "tTouchDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTTouchDataList()). Otherwise it will return false.
     */
    inline bool hasTTouchDataList () const;

    /**
     * Returns the value of the member "tTouchDataList".
     *
     * List of structure for Touch co-ordinates and Status information
     *
     * @return The value of the field "tTouchDataList"
     */
    inline const ::input_main_fi_types::T_TouchDataList& getTTouchDataList () const;

    /**
     * Retrieves the value of the field "tTouchDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tTouchDataList".
     */
    inline ::input_main_fi_types::T_TouchDataList& getTTouchDataListMutable ();

    /**
     * Sets the value of the member "tTouchDataList".
     *
     * List of structure for Touch co-ordinates and Status information
     *
     * @param tTouchDataList The value which will be set
     */
    inline void setTTouchDataList (const ::input_main_fi_types::T_TouchDataList& tTouchDataList_);

    static const TouchStatusStatus &getDefaultInstance();

private:

    static const ::std::vector< ::input_main_fi_types::T_TouchInfo >& getT_TouchInfoList_DefaultInstance ();

    inline void set_has_tTouchDataList ();

    inline void clear_has_tTouchDataList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::input_main_fi_types::T_TouchDataList _tTouchDataList;

};

/**
 * The error message of 'TouchStatus'
 */
class TouchStatusErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TouchStatusErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TouchStatusErrorStructure (const TouchStatusErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TouchStatusErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TouchStatusErrorStructure();

    /**
     * Assignment operator
     */
    inline TouchStatusErrorStructure& operator = (const TouchStatusErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TouchStatusErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TouchStatusErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TouchStatusErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TouchStatusErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const TouchStatusErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'TouchStatus'
 */
class TouchStatusError  : public ::asf::core::Payload {
public:

    enum TouchStatusErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TouchStatusError ();

   /**
     * Copy constructor
     */
    inline  TouchStatusError (const TouchStatusError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TouchStatusError();

    /**
     * Assigns a new value to this object.
     */
    inline TouchStatusError& operator = (const TouchStatusError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TouchStatusError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TouchStatusError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TouchStatusError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TouchStatusError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TouchStatusError::TouchStatusErrorField getField () const;

    inline void setField(TouchStatusError::TouchStatusErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TouchStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TouchStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TouchStatusErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TouchStatusErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TouchStatusErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TouchStatusErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TouchStatusErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TouchStatusErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TouchStatusError &getDefaultInstance();

private:

    inline void cloneData (const TouchStatusError& rhs);

    inline void deleteData ();

    TouchStatusErrorField __field;

    union {
        TouchStatusErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "TouchStatusPIVISecondary"
 * <p>This contains touch Info for PIVI Secondary Screen</p>
 * <p>Property TouchStatusPIVISecondary contains a list of structure with Co-ordinates X:Y tS32(4Bytes) and Status Enum Value (1 Byte) 0 - Release Touch and 1- Touch Press</p>
 * <p>This list shall contain Touch History of points pressed / released in Last 2 secs and Max No of Entries shall be 5</p>
 * <p>Touch Entries older than 2 secs and beyond MAX No of entries will not be present in List</p>
 */
class TouchStatusPIVISecondaryStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TouchStatusPIVISecondaryStatus ();

    /**
     * Copy constructor
     */
    inline  TouchStatusPIVISecondaryStatus (const TouchStatusPIVISecondaryStatus &rhs);

    /**
     * All fields constructor
     */
    inline  TouchStatusPIVISecondaryStatus (const ::input_main_fi_types::T_TouchDataList& tSecondaryTouchDataList_);

    /**
     * Destructor
     */
    inline virtual  ~TouchStatusPIVISecondaryStatus();

    /**
     * Assignment operator
     */
    inline TouchStatusPIVISecondaryStatus& operator = (const TouchStatusPIVISecondaryStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TouchStatusPIVISecondaryStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TouchStatusPIVISecondaryStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TouchStatusPIVISecondaryStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TouchStatusPIVISecondaryStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "tSecondaryTouchDataList"

    static const int kTSecondaryTouchDataList = 0;

    /**
     * Clears the field "tSecondaryTouchDataList".
     *
     * The field will be set to its default value. The hasTSecondaryTouchDataList()
     * method will return false.
     */
    inline void clearTSecondaryTouchDataList();

    /**
     * Checks whether the field "tSecondaryTouchDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTSecondaryTouchDataList()). Otherwise it will return false.
     */
    inline bool hasTSecondaryTouchDataList () const;

    /**
     * Returns the value of the member "tSecondaryTouchDataList".
     *
     * List of structure for Touch co-ordinates and Status information for PIVI Secondary Screen
     *
     * @return The value of the field "tSecondaryTouchDataList"
     */
    inline const ::input_main_fi_types::T_TouchDataList& getTSecondaryTouchDataList () const;

    /**
     * Retrieves the value of the field "tSecondaryTouchDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "tSecondaryTouchDataList".
     */
    inline ::input_main_fi_types::T_TouchDataList& getTSecondaryTouchDataListMutable ();

    /**
     * Sets the value of the member "tSecondaryTouchDataList".
     *
     * List of structure for Touch co-ordinates and Status information for PIVI Secondary Screen
     *
     * @param tSecondaryTouchDataList The value which will be set
     */
    inline void setTSecondaryTouchDataList (const ::input_main_fi_types::T_TouchDataList& tSecondaryTouchDataList_);

    static const TouchStatusPIVISecondaryStatus &getDefaultInstance();

private:

    static const ::std::vector< ::input_main_fi_types::T_TouchInfo >& getT_TouchInfoList_DefaultInstance ();

    inline void set_has_tSecondaryTouchDataList ();

    inline void clear_has_tSecondaryTouchDataList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::input_main_fi_types::T_TouchDataList _tSecondaryTouchDataList;

};

/**
 * The error message of 'TouchStatusPIVISecondary'
 */
class TouchStatusPIVISecondaryErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  TouchStatusPIVISecondaryErrorStructure ();

    /**
     * Copy constructor
     */
    inline  TouchStatusPIVISecondaryErrorStructure (const TouchStatusPIVISecondaryErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  TouchStatusPIVISecondaryErrorStructure (uint8 ErrorCode_);

    /**
     * Destructor
     */
    inline  ~TouchStatusPIVISecondaryErrorStructure();

    /**
     * Assignment operator
     */
    inline TouchStatusPIVISecondaryErrorStructure& operator = (const TouchStatusPIVISecondaryErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TouchStatusPIVISecondaryErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TouchStatusPIVISecondaryErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TouchStatusPIVISecondaryErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TouchStatusPIVISecondaryErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ErrorCode"

    static const int kErrorCode = 0;

    /**
     * Clears the field "ErrorCode".
     *
     * The field will be set to its default value. The hasErrorCode()
     * method will return false.
     */
    inline void clearErrorCode();

    /**
     * Checks whether the field "ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErrorCode()). Otherwise it will return false.
     */
    inline bool hasErrorCode () const;

    /**
     * Returns the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @return The value of the field "ErrorCode"
     */
    inline uint8 getErrorCode () const;

    /**
     * Sets the value of the member "ErrorCode".
     *
     * Possible errors of a CCA call from the client
     *
     * @param ErrorCode The value which will be set
     */
    inline void setErrorCode (uint8 ErrorCode_);

    static const TouchStatusPIVISecondaryErrorStructure &getDefaultInstance();

private:

    inline void set_has_ErrorCode ();

    inline void clear_has_ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _ErrorCode;

};

/**
 * The error message of 'TouchStatusPIVISecondary'
 */
class TouchStatusPIVISecondaryError  : public ::asf::core::Payload {
public:

    enum TouchStatusPIVISecondaryErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  TouchStatusPIVISecondaryError ();

   /**
     * Copy constructor
     */
    inline  TouchStatusPIVISecondaryError (const TouchStatusPIVISecondaryError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~TouchStatusPIVISecondaryError();

    /**
     * Assigns a new value to this object.
     */
    inline TouchStatusPIVISecondaryError& operator = (const TouchStatusPIVISecondaryError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TouchStatusPIVISecondaryError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TouchStatusPIVISecondaryError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TouchStatusPIVISecondaryError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TouchStatusPIVISecondaryError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline TouchStatusPIVISecondaryError::TouchStatusPIVISecondaryErrorField getField () const;

    inline void setField(TouchStatusPIVISecondaryError::TouchStatusPIVISecondaryErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "TouchStatusPIVISecondaryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "TouchStatusPIVISecondaryErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const TouchStatusPIVISecondaryErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline TouchStatusPIVISecondaryErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline TouchStatusPIVISecondaryErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (TouchStatusPIVISecondaryErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "TouchStatusPIVISecondaryErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const TouchStatusPIVISecondaryErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const TouchStatusPIVISecondaryError &getDefaultInstance();

private:

    inline void cloneData (const TouchStatusPIVISecondaryError& rhs);

    inline void deleteData ();

    TouchStatusPIVISecondaryErrorField __field;

    union {
        TouchStatusPIVISecondaryErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "EnableInputEvents"
 * <p>Client Shall First Enable Input Events by calling this method to receive events and also for injecting events</p>
 * <p>Input Events are Key,Encoder and Touch</p>
 * <p>Also this Method shall enable Event Observer Module to fetch and feedback Input Events</p>
 * This will return a Success or failure status indicating simulation is enabled or not
 */
class EnableInputEventsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  EnableInputEventsResult ();

    /**
     * Copy constructor
     */
    inline  EnableInputEventsResult (const EnableInputEventsResult &rhs);

    /**
     * All fields constructor
     */
    inline  EnableInputEventsResult (bool SimulationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~EnableInputEventsResult();

    /**
     * Assignment operator
     */
    inline EnableInputEventsResult& operator = (const EnableInputEventsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const EnableInputEventsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const EnableInputEventsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const EnableInputEventsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const EnableInputEventsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SimulationStatus"

    static const int kSimulationStatus = 0;

    /**
     * Clears the field "SimulationStatus".
     *
     * The field will be set to its default value. The hasSimulationStatus()
     * method will return false.
     */
    inline void clearSimulationStatus();

    /**
     * Checks whether the field "SimulationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSimulationStatus()). Otherwise it will return false.
     */
    inline bool hasSimulationStatus () const;

    /**
     * Returns the value of the member "SimulationStatus".
     *
     * TRUE or FALSE to ensure simulation is enabled
     *
     * @return The value of the field "SimulationStatus"
     */
    inline bool getSimulationStatus () const;

    /**
     * Sets the value of the member "SimulationStatus".
     *
     * TRUE or FALSE to ensure simulation is enabled
     *
     * @param SimulationStatus The value which will be set
     */
    inline void setSimulationStatus (bool SimulationStatus_);

    static const EnableInputEventsResult &getDefaultInstance();

private:

    inline void set_has_SimulationStatus ();

    inline void clear_has_SimulationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SimulationStatus;

};

/**
 * The result message of the method "DisableInputEvents"
 * <p>Client Shall disable Input Events by calling this method to stop receiving events and also injecting of events</p>
 * <p>Input Events are Key,Encoder and Touch</p>
 * <p>Also this Method shall Stop Event Observer Module to fetch and feedback Input Events</p>
 * This will return a Success or failure status indicating simulation is enabled or not
 */
class DisableInputEventsResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisableInputEventsResult ();

    /**
     * Copy constructor
     */
    inline  DisableInputEventsResult (const DisableInputEventsResult &rhs);

    /**
     * All fields constructor
     */
    inline  DisableInputEventsResult (bool SimulationStatus_);

    /**
     * Destructor
     */
    inline virtual  ~DisableInputEventsResult();

    /**
     * Assignment operator
     */
    inline DisableInputEventsResult& operator = (const DisableInputEventsResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisableInputEventsResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisableInputEventsResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisableInputEventsResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisableInputEventsResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SimulationStatus"

    static const int kSimulationStatus = 0;

    /**
     * Clears the field "SimulationStatus".
     *
     * The field will be set to its default value. The hasSimulationStatus()
     * method will return false.
     */
    inline void clearSimulationStatus();

    /**
     * Checks whether the field "SimulationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSimulationStatus()). Otherwise it will return false.
     */
    inline bool hasSimulationStatus () const;

    /**
     * Returns the value of the member "SimulationStatus".
     *
     * TRUE or FALSE to ensure simulation is Disable
     *
     * @return The value of the field "SimulationStatus"
     */
    inline bool getSimulationStatus () const;

    /**
     * Sets the value of the member "SimulationStatus".
     *
     * TRUE or FALSE to ensure simulation is Disable
     *
     * @param SimulationStatus The value which will be set
     */
    inline void setSimulationStatus (bool SimulationStatus_);

    static const DisableInputEventsResult &getDefaultInstance();

private:

    inline void set_has_SimulationStatus ();

    inline void clear_has_SimulationStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _SimulationStatus;

};

/**
 * The start message of the method "simulateKeyInjection"
 * This method is used to simulate HardKey, SWC Key, System and Encoder Keys Press or Release in the HMI.
 */
class SimulateKeyInjectionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateKeyInjectionStart ();

    /**
     * Copy constructor
     */
    inline  SimulateKeyInjectionStart (const SimulateKeyInjectionStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateKeyInjectionStart (::input_main_fi_types::T_e16_KeyCode e16Keycode_, uint8 u8KeyStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateKeyInjectionStart();

    /**
     * Assignment operator
     */
    inline SimulateKeyInjectionStart& operator = (const SimulateKeyInjectionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateKeyInjectionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateKeyInjectionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateKeyInjectionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateKeyInjectionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e16Keycode"

    static const int kE16Keycode = 0;

    /**
     * Clears the field "e16Keycode".
     *
     * The field will be set to its default value. The hasE16Keycode()
     * method will return false.
     */
    inline void clearE16Keycode();

    /**
     * Checks whether the field "e16Keycode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE16Keycode()). Otherwise it will return false.
     */
    inline bool hasE16Keycode () const;

    /**
     * Returns the value of the member "e16Keycode".
     *
     * Enum containing HMI Key code.
     *
     * @return The value of the field "e16Keycode"
     */
    inline ::input_main_fi_types::T_e16_KeyCode getE16Keycode () const;

    /**
     * Sets the value of the member "e16Keycode".
     *
     * Enum containing HMI Key code.
     *
     * @param e16Keycode The value which will be set
     */
    inline void setE16Keycode (::input_main_fi_types::T_e16_KeyCode e16Keycode_);

    // API of field "u8KeyStatus"

    static const int kU8KeyStatus = 1;

    /**
     * Clears the field "u8KeyStatus".
     *
     * The field will be set to its default value. The hasU8KeyStatus()
     * method will return false.
     */
    inline void clearU8KeyStatus();

    /**
     * Checks whether the field "u8KeyStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8KeyStatus()). Otherwise it will return false.
     */
    inline bool hasU8KeyStatus () const;

    /**
     * Returns the value of the member "u8KeyStatus".
     *
     * Status 1 indicates Key Press and 0 indicates Key Release.
     *
     * @return The value of the field "u8KeyStatus"
     */
    inline uint8 getU8KeyStatus () const;

    /**
     * Sets the value of the member "u8KeyStatus".
     *
     * Status 1 indicates Key Press and 0 indicates Key Release.
     *
     * @param u8KeyStatus The value which will be set
     */
    inline void setU8KeyStatus (uint8 u8KeyStatus_);

    static const SimulateKeyInjectionStart &getDefaultInstance();

private:

    inline void set_has_e16Keycode ();

    inline void clear_has_e16Keycode ();

    inline void set_has_u8KeyStatus ();

    inline void clear_has_u8KeyStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::input_main_fi_types::T_e16_KeyCode _e16Keycode;

    uint8 _u8KeyStatus;

};

/**
 * The start message of the method "simulateEncRotation"
 * This method is used to simulate Left and Right Encoder Rotation in the HMI.
 */
class SimulateEncRotationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateEncRotationStart ();

    /**
     * Copy constructor
     */
    inline  SimulateEncRotationStart (const SimulateEncRotationStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateEncRotationStart (::input_main_fi_types::T_e8_EncoderType e8EncoderType_, int8 s8EncSteps_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateEncRotationStart();

    /**
     * Assignment operator
     */
    inline SimulateEncRotationStart& operator = (const SimulateEncRotationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateEncRotationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateEncRotationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateEncRotationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateEncRotationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8EncoderType"

    static const int kE8EncoderType = 0;

    /**
     * Clears the field "e8EncoderType".
     *
     * The field will be set to its default value. The hasE8EncoderType()
     * method will return false.
     */
    inline void clearE8EncoderType();

    /**
     * Checks whether the field "e8EncoderType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8EncoderType()). Otherwise it will return false.
     */
    inline bool hasE8EncoderType () const;

    /**
     * Returns the value of the member "e8EncoderType".
     *
     * Enum containing Type of Encoder Left or Right.
     *
     * @return The value of the field "e8EncoderType"
     */
    inline ::input_main_fi_types::T_e8_EncoderType getE8EncoderType () const;

    /**
     * Sets the value of the member "e8EncoderType".
     *
     * Enum containing Type of Encoder Left or Right.
     *
     * @param e8EncoderType The value which will be set
     */
    inline void setE8EncoderType (::input_main_fi_types::T_e8_EncoderType e8EncoderType_);

    // API of field "s8EncSteps"

    static const int kS8EncSteps = 1;

    /**
     * Clears the field "s8EncSteps".
     *
     * The field will be set to its default value. The hasS8EncSteps()
     * method will return false.
     */
    inline void clearS8EncSteps();

    /**
     * Checks whether the field "s8EncSteps" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8EncSteps()). Otherwise it will return false.
     */
    inline bool hasS8EncSteps () const;

    /**
     * Returns the value of the member "s8EncSteps".
     *
     * No of steps with +ve/-ve value indicating direction of rotation.
     *
     * @return The value of the field "s8EncSteps"
     */
    inline int8 getS8EncSteps () const;

    /**
     * Sets the value of the member "s8EncSteps".
     *
     * No of steps with +ve/-ve value indicating direction of rotation.
     *
     * @param s8EncSteps The value which will be set
     */
    inline void setS8EncSteps (int8 s8EncSteps_);

    static const SimulateEncRotationStart &getDefaultInstance();

private:

    inline void set_has_e8EncoderType ();

    inline void clear_has_e8EncoderType ();

    inline void set_has_s8EncSteps ();

    inline void clear_has_s8EncSteps ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::input_main_fi_types::T_e8_EncoderType _e8EncoderType;

    int8 _s8EncSteps;

};

/**
 * The start message of the method "simulateSingleTouch"
 * This method is used to simulate Single Touch Press or Release in the HMI.
 */
class SimulateSingleTouchStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateSingleTouchStart ();

    /**
     * Copy constructor
     */
    inline  SimulateSingleTouchStart (const SimulateSingleTouchStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateSingleTouchStart (int32 s32XCoord_, int32 s32YCoord_, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateSingleTouchStart();

    /**
     * Assignment operator
     */
    inline SimulateSingleTouchStart& operator = (const SimulateSingleTouchStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateSingleTouchStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateSingleTouchStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateSingleTouchStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateSingleTouchStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32XCoord"

    static const int kS32XCoord = 0;

    /**
     * Clears the field "s32XCoord".
     *
     * The field will be set to its default value. The hasS32XCoord()
     * method will return false.
     */
    inline void clearS32XCoord();

    /**
     * Checks whether the field "s32XCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XCoord()). Otherwise it will return false.
     */
    inline bool hasS32XCoord () const;

    /**
     * Returns the value of the member "s32XCoord".
     *
     * signed value of X coord
     *
     * @return The value of the field "s32XCoord"
     */
    inline int32 getS32XCoord () const;

    /**
     * Sets the value of the member "s32XCoord".
     *
     * signed value of X coord
     *
     * @param s32XCoord The value which will be set
     */
    inline void setS32XCoord (int32 s32XCoord_);

    // API of field "s32YCoord"

    static const int kS32YCoord = 1;

    /**
     * Clears the field "s32YCoord".
     *
     * The field will be set to its default value. The hasS32YCoord()
     * method will return false.
     */
    inline void clearS32YCoord();

    /**
     * Checks whether the field "s32YCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YCoord()). Otherwise it will return false.
     */
    inline bool hasS32YCoord () const;

    /**
     * Returns the value of the member "s32YCoord".
     *
     * signed value of Y coord.
     *
     * @return The value of the field "s32YCoord"
     */
    inline int32 getS32YCoord () const;

    /**
     * Sets the value of the member "s32YCoord".
     *
     * signed value of Y coord.
     *
     * @param s32YCoord The value which will be set
     */
    inline void setS32YCoord (int32 s32YCoord_);

    // API of field "e8TouchStatus"

    static const int kE8TouchStatus = 2;

    /**
     * Clears the field "e8TouchStatus".
     *
     * The field will be set to its default value. The hasE8TouchStatus()
     * method will return false.
     */
    inline void clearE8TouchStatus();

    /**
     * Checks whether the field "e8TouchStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TouchStatus()). Otherwise it will return false.
     */
    inline bool hasE8TouchStatus () const;

    /**
     * Returns the value of the member "e8TouchStatus".
     *
     * Enum of touch status press/release or invalid.
     *
     * @return The value of the field "e8TouchStatus"
     */
    inline ::input_main_fi_types::T_e8_TouchStatus getE8TouchStatus () const;

    /**
     * Sets the value of the member "e8TouchStatus".
     *
     * Enum of touch status press/release or invalid.
     *
     * @param e8TouchStatus The value which will be set
     */
    inline void setE8TouchStatus (::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_);

    static const SimulateSingleTouchStart &getDefaultInstance();

private:

    inline void set_has_s32XCoord ();

    inline void clear_has_s32XCoord ();

    inline void set_has_s32YCoord ();

    inline void clear_has_s32YCoord ();

    inline void set_has_e8TouchStatus ();

    inline void clear_has_e8TouchStatus ();

    uint32 _has_bits_[ (3 + 31) / 32];

    int32 _s32XCoord;

    int32 _s32YCoord;

    ::input_main_fi_types::T_e8_TouchStatus _e8TouchStatus;

};

/**
 * The start message of the method "simulateTouchSlide"
 * This method is used to simulate Touch slide gesture in the HMI.
 */
class SimulateTouchSlideStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateTouchSlideStart ();

    /**
     * Copy constructor
     */
    inline  SimulateTouchSlideStart (const SimulateTouchSlideStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateTouchSlideStart (int32 s32XStart_, int32 s32YStart_, int32 s32XEnd_, int32 s32YEnd_, uint16 u16Duration_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateTouchSlideStart();

    /**
     * Assignment operator
     */
    inline SimulateTouchSlideStart& operator = (const SimulateTouchSlideStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateTouchSlideStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateTouchSlideStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateTouchSlideStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateTouchSlideStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32XStart"

    static const int kS32XStart = 0;

    /**
     * Clears the field "s32XStart".
     *
     * The field will be set to its default value. The hasS32XStart()
     * method will return false.
     */
    inline void clearS32XStart();

    /**
     * Checks whether the field "s32XStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XStart()). Otherwise it will return false.
     */
    inline bool hasS32XStart () const;

    /**
     * Returns the value of the member "s32XStart".
     *
     * signed value of starting X coord
     *
     * @return The value of the field "s32XStart"
     */
    inline int32 getS32XStart () const;

    /**
     * Sets the value of the member "s32XStart".
     *
     * signed value of starting X coord
     *
     * @param s32XStart The value which will be set
     */
    inline void setS32XStart (int32 s32XStart_);

    // API of field "s32YStart"

    static const int kS32YStart = 1;

    /**
     * Clears the field "s32YStart".
     *
     * The field will be set to its default value. The hasS32YStart()
     * method will return false.
     */
    inline void clearS32YStart();

    /**
     * Checks whether the field "s32YStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YStart()). Otherwise it will return false.
     */
    inline bool hasS32YStart () const;

    /**
     * Returns the value of the member "s32YStart".
     *
     * signed value of starting Y coord.
     *
     * @return The value of the field "s32YStart"
     */
    inline int32 getS32YStart () const;

    /**
     * Sets the value of the member "s32YStart".
     *
     * signed value of starting Y coord.
     *
     * @param s32YStart The value which will be set
     */
    inline void setS32YStart (int32 s32YStart_);

    // API of field "s32XEnd"

    static const int kS32XEnd = 2;

    /**
     * Clears the field "s32XEnd".
     *
     * The field will be set to its default value. The hasS32XEnd()
     * method will return false.
     */
    inline void clearS32XEnd();

    /**
     * Checks whether the field "s32XEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XEnd()). Otherwise it will return false.
     */
    inline bool hasS32XEnd () const;

    /**
     * Returns the value of the member "s32XEnd".
     *
     * signed value of end X coord
     *
     * @return The value of the field "s32XEnd"
     */
    inline int32 getS32XEnd () const;

    /**
     * Sets the value of the member "s32XEnd".
     *
     * signed value of end X coord
     *
     * @param s32XEnd The value which will be set
     */
    inline void setS32XEnd (int32 s32XEnd_);

    // API of field "s32YEnd"

    static const int kS32YEnd = 3;

    /**
     * Clears the field "s32YEnd".
     *
     * The field will be set to its default value. The hasS32YEnd()
     * method will return false.
     */
    inline void clearS32YEnd();

    /**
     * Checks whether the field "s32YEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YEnd()). Otherwise it will return false.
     */
    inline bool hasS32YEnd () const;

    /**
     * Returns the value of the member "s32YEnd".
     *
     * signed value of end Y coord.
     *
     * @return The value of the field "s32YEnd"
     */
    inline int32 getS32YEnd () const;

    /**
     * Sets the value of the member "s32YEnd".
     *
     * signed value of end Y coord.
     *
     * @param s32YEnd The value which will be set
     */
    inline void setS32YEnd (int32 s32YEnd_);

    // API of field "u16Duration"

    static const int kU16Duration = 4;

    /**
     * Clears the field "u16Duration".
     *
     * The field will be set to its default value. The hasU16Duration()
     * method will return false.
     */
    inline void clearU16Duration();

    /**
     * Checks whether the field "u16Duration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Duration()). Otherwise it will return false.
     */
    inline bool hasU16Duration () const;

    /**
     * Returns the value of the member "u16Duration".
     *
     * Duration shall be in milliseconds and multiple of 10
     *
     * @return The value of the field "u16Duration"
     */
    inline uint16 getU16Duration () const;

    /**
     * Sets the value of the member "u16Duration".
     *
     * Duration shall be in milliseconds and multiple of 10
     *
     * @param u16Duration The value which will be set
     */
    inline void setU16Duration (uint16 u16Duration_);

    static const SimulateTouchSlideStart &getDefaultInstance();

private:

    inline void set_has_s32XStart ();

    inline void clear_has_s32XStart ();

    inline void set_has_s32YStart ();

    inline void clear_has_s32YStart ();

    inline void set_has_s32XEnd ();

    inline void clear_has_s32XEnd ();

    inline void set_has_s32YEnd ();

    inline void clear_has_s32YEnd ();

    inline void set_has_u16Duration ();

    inline void clear_has_u16Duration ();

    uint32 _has_bits_[ (5 + 31) / 32];

    int32 _s32XStart;

    int32 _s32YStart;

    int32 _s32XEnd;

    int32 _s32YEnd;

    uint16 _u16Duration;

};

/**
 * The start message of the method "simulateMultiTouch"
 * This method is used to simulate Multi Touch Press or Release in the HMI.
 */
class SimulateMultiTouchStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulateMultiTouchStart ();

    /**
     * Copy constructor
     */
    inline  SimulateMultiTouchStart (const SimulateMultiTouchStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulateMultiTouchStart (int32 s32SlotId_, int32 s32XCoord_, int32 s32YCoord_, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SimulateMultiTouchStart();

    /**
     * Assignment operator
     */
    inline SimulateMultiTouchStart& operator = (const SimulateMultiTouchStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulateMultiTouchStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulateMultiTouchStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulateMultiTouchStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulateMultiTouchStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32SlotId"

    static const int kS32SlotId = 0;

    /**
     * Clears the field "s32SlotId".
     *
     * The field will be set to its default value. The hasS32SlotId()
     * method will return false.
     */
    inline void clearS32SlotId();

    /**
     * Checks whether the field "s32SlotId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32SlotId()). Otherwise it will return false.
     */
    inline bool hasS32SlotId () const;

    /**
     * Returns the value of the member "s32SlotId".
     *
     * <p>signed value of Slot ID indicating finger ID</p>
     * <p>1 finger by fefault means Slot ID 0 and 2nd finger touch indicated by SlotID 1 and so on..</p>
     *
     * @return The value of the field "s32SlotId"
     */
    inline int32 getS32SlotId () const;

    /**
     * Sets the value of the member "s32SlotId".
     *
     * <p>signed value of Slot ID indicating finger ID</p>
     * <p>1 finger by fefault means Slot ID 0 and 2nd finger touch indicated by SlotID 1 and so on..</p>
     *
     * @param s32SlotId The value which will be set
     */
    inline void setS32SlotId (int32 s32SlotId_);

    // API of field "s32XCoord"

    static const int kS32XCoord = 1;

    /**
     * Clears the field "s32XCoord".
     *
     * The field will be set to its default value. The hasS32XCoord()
     * method will return false.
     */
    inline void clearS32XCoord();

    /**
     * Checks whether the field "s32XCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XCoord()). Otherwise it will return false.
     */
    inline bool hasS32XCoord () const;

    /**
     * Returns the value of the member "s32XCoord".
     *
     * signed value of X coord
     *
     * @return The value of the field "s32XCoord"
     */
    inline int32 getS32XCoord () const;

    /**
     * Sets the value of the member "s32XCoord".
     *
     * signed value of X coord
     *
     * @param s32XCoord The value which will be set
     */
    inline void setS32XCoord (int32 s32XCoord_);

    // API of field "s32YCoord"

    static const int kS32YCoord = 2;

    /**
     * Clears the field "s32YCoord".
     *
     * The field will be set to its default value. The hasS32YCoord()
     * method will return false.
     */
    inline void clearS32YCoord();

    /**
     * Checks whether the field "s32YCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YCoord()). Otherwise it will return false.
     */
    inline bool hasS32YCoord () const;

    /**
     * Returns the value of the member "s32YCoord".
     *
     * signed value of Y coord.
     *
     * @return The value of the field "s32YCoord"
     */
    inline int32 getS32YCoord () const;

    /**
     * Sets the value of the member "s32YCoord".
     *
     * signed value of Y coord.
     *
     * @param s32YCoord The value which will be set
     */
    inline void setS32YCoord (int32 s32YCoord_);

    // API of field "e8TouchStatus"

    static const int kE8TouchStatus = 3;

    /**
     * Clears the field "e8TouchStatus".
     *
     * The field will be set to its default value. The hasE8TouchStatus()
     * method will return false.
     */
    inline void clearE8TouchStatus();

    /**
     * Checks whether the field "e8TouchStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TouchStatus()). Otherwise it will return false.
     */
    inline bool hasE8TouchStatus () const;

    /**
     * Returns the value of the member "e8TouchStatus".
     *
     * Enum of touch status press/release or invalid.
     *
     * @return The value of the field "e8TouchStatus"
     */
    inline ::input_main_fi_types::T_e8_TouchStatus getE8TouchStatus () const;

    /**
     * Sets the value of the member "e8TouchStatus".
     *
     * Enum of touch status press/release or invalid.
     *
     * @param e8TouchStatus The value which will be set
     */
    inline void setE8TouchStatus (::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_);

    static const SimulateMultiTouchStart &getDefaultInstance();

private:

    inline void set_has_s32SlotId ();

    inline void clear_has_s32SlotId ();

    inline void set_has_s32XCoord ();

    inline void clear_has_s32XCoord ();

    inline void set_has_s32YCoord ();

    inline void clear_has_s32YCoord ();

    inline void set_has_e8TouchStatus ();

    inline void clear_has_e8TouchStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _s32SlotId;

    int32 _s32XCoord;

    int32 _s32YCoord;

    ::input_main_fi_types::T_e8_TouchStatus _e8TouchStatus;

};

/**
 * The start message of the method "GestureRecord"
 * <p>This method is used to Record Sequence of User Inputs, Touch, Key, Encoder.</p>
 * <p>This can be used to record series of touch events and store them in some eg:/tmp/GuestureName(optional .txt or .ev file extension) file in target.</p>
 * <p>User can then save this file and use to replay Guestures.</p>
 */
class GestureRecordStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GestureRecordStart ();

    /**
     * Copy constructor
     */
    inline  GestureRecordStart (const GestureRecordStart &rhs);

    /**
     * All fields constructor
     */
    inline  GestureRecordStart (uint8 u8StartStop_, const ::std::string& FilePath_);

    /**
     * Destructor
     */
    inline virtual  ~GestureRecordStart();

    /**
     * Assignment operator
     */
    inline GestureRecordStart& operator = (const GestureRecordStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GestureRecordStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GestureRecordStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GestureRecordStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GestureRecordStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8StartStop"

    static const int kU8StartStop = 0;

    /**
     * Clears the field "u8StartStop".
     *
     * The field will be set to its default value. The hasU8StartStop()
     * method will return false.
     */
    inline void clearU8StartStop();

    /**
     * Checks whether the field "u8StartStop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StartStop()). Otherwise it will return false.
     */
    inline bool hasU8StartStop () const;

    /**
     * Returns the value of the member "u8StartStop".
     *
     * u8StartStop = 1 : Start Recording Input Events
     * u8StartStop = 0 : Stop Recording Input Events
     *
     * @return The value of the field "u8StartStop"
     */
    inline uint8 getU8StartStop () const;

    /**
     * Sets the value of the member "u8StartStop".
     *
     * u8StartStop = 1 : Start Recording Input Events
     * u8StartStop = 0 : Stop Recording Input Events
     *
     * @param u8StartStop The value which will be set
     */
    inline void setU8StartStop (uint8 u8StartStop_);

    // API of field "FilePath"

    static const int kFilePath = 1;

    /**
     * Clears the field "FilePath".
     *
     * The field will be set to its default value. The hasFilePath()
     * method will return false.
     */
    inline void clearFilePath();

    /**
     * Checks whether the field "FilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilePath()). Otherwise it will return false.
     */
    inline bool hasFilePath () const;

    /**
     * Returns the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user wants to save file.
     *
     * @return The value of the field "FilePath"
     */
    inline const ::std::string& getFilePath () const;

    /**
     * Retrieves the value of the field "FilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FilePath".
     */
    inline ::std::string& getFilePathMutable ();

    /**
     * Sets the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user wants to save file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const ::std::string& FilePath_);

    /**
     * Sets the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user wants to save file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const char* FilePath_);

    /**
     * Sets the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user wants to save file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const char* value, size_t size);

    static const GestureRecordStart &getDefaultInstance();

private:

    inline void set_has_u8StartStop ();

    inline void clear_has_u8StartStop ();

    inline void set_has_FilePath ();

    inline void clear_has_FilePath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8StartStop;

    ::std::string _FilePath;

};

/**
 * The result message of the method "GestureRecord"
 * <p>This method is used to Record Sequence of User Inputs, Touch, Key, Encoder.</p>
 * <p>This can be used to record series of touch events and store them in some eg:/tmp/GuestureName(optional .txt or .ev file extension) file in target.</p>
 * <p>User can then save this file and use to replay Guestures.</p>
 */
class GestureRecordResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GestureRecordResult ();

    /**
     * Copy constructor
     */
    inline  GestureRecordResult (const GestureRecordResult &rhs);

    /**
     * All fields constructor
     */
    inline  GestureRecordResult (bool bSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~GestureRecordResult();

    /**
     * Assignment operator
     */
    inline GestureRecordResult& operator = (const GestureRecordResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GestureRecordResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GestureRecordResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GestureRecordResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GestureRecordResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSuccess"

    static const int kBSuccess = 0;

    /**
     * Clears the field "bSuccess".
     *
     * The field will be set to its default value. The hasBSuccess()
     * method will return false.
     */
    inline void clearBSuccess();

    /**
     * Checks whether the field "bSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuccess()). Otherwise it will return false.
     */
    inline bool hasBSuccess () const;

    /**
     * Returns the value of the member "bSuccess".
     *
     * Success or Failure of the operation record.
     *
     * @return The value of the field "bSuccess"
     */
    inline bool getBSuccess () const;

    /**
     * Sets the value of the member "bSuccess".
     *
     * Success or Failure of the operation record.
     *
     * @param bSuccess The value which will be set
     */
    inline void setBSuccess (bool bSuccess_);

    static const GestureRecordResult &getDefaultInstance();

private:

    inline void set_has_bSuccess ();

    inline void clear_has_bSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSuccess;

};

/**
 * The start message of the method "GestureReplay"
 * <p>This method is used to Replay Sequence of User Inputs, Touch, Key, Encoder.</p>
 * <p>This can be used to Replay series of touch events from file stored in Target File system eg: /tmp/GuestureName(optional .txt or .ev file extension).</p>
 * <p>User shall ensure this file is present at specified path in target file system and accessible.</p>
 */
class GestureReplayStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GestureReplayStart ();

    /**
     * Copy constructor
     */
    inline  GestureReplayStart (const GestureReplayStart &rhs);

    /**
     * All fields constructor
     */
    inline  GestureReplayStart (uint8 u8StartStop_, const ::std::string& FilePath_);

    /**
     * Destructor
     */
    inline virtual  ~GestureReplayStart();

    /**
     * Assignment operator
     */
    inline GestureReplayStart& operator = (const GestureReplayStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GestureReplayStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GestureReplayStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GestureReplayStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GestureReplayStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8StartStop"

    static const int kU8StartStop = 0;

    /**
     * Clears the field "u8StartStop".
     *
     * The field will be set to its default value. The hasU8StartStop()
     * method will return false.
     */
    inline void clearU8StartStop();

    /**
     * Checks whether the field "u8StartStop" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8StartStop()). Otherwise it will return false.
     */
    inline bool hasU8StartStop () const;

    /**
     * Returns the value of the member "u8StartStop".
     *
     * u8StartStop = 1 : Start Replay of Input Events
     * u8StartStop = 0 : Stop Replay of Input Events in between.
     *
     * @return The value of the field "u8StartStop"
     */
    inline uint8 getU8StartStop () const;

    /**
     * Sets the value of the member "u8StartStop".
     *
     * u8StartStop = 1 : Start Replay of Input Events
     * u8StartStop = 0 : Stop Replay of Input Events in between.
     *
     * @param u8StartStop The value which will be set
     */
    inline void setU8StartStop (uint8 u8StartStop_);

    // API of field "FilePath"

    static const int kFilePath = 1;

    /**
     * Clears the field "FilePath".
     *
     * The field will be set to its default value. The hasFilePath()
     * method will return false.
     */
    inline void clearFilePath();

    /**
     * Checks whether the field "FilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilePath()). Otherwise it will return false.
     */
    inline bool hasFilePath () const;

    /**
     * Returns the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user has saved file.
     *
     * @return The value of the field "FilePath"
     */
    inline const ::std::string& getFilePath () const;

    /**
     * Retrieves the value of the field "FilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FilePath".
     */
    inline ::std::string& getFilePathMutable ();

    /**
     * Sets the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user has saved file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const ::std::string& FilePath_);

    /**
     * Sets the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user has saved file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const char* FilePath_);

    /**
     * Sets the value of the member "FilePath".
     *
     * File path is needed as string. This shall contain full file path along with directory in which user has saved file.
     *
     * @param FilePath The value which will be set
     */
    inline void setFilePath (const char* value, size_t size);

    static const GestureReplayStart &getDefaultInstance();

private:

    inline void set_has_u8StartStop ();

    inline void clear_has_u8StartStop ();

    inline void set_has_FilePath ();

    inline void clear_has_FilePath ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8StartStop;

    ::std::string _FilePath;

};

/**
 * The result message of the method "GestureReplay"
 * <p>This method is used to Replay Sequence of User Inputs, Touch, Key, Encoder.</p>
 * <p>This can be used to Replay series of touch events from file stored in Target File system eg: /tmp/GuestureName(optional .txt or .ev file extension).</p>
 * <p>User shall ensure this file is present at specified path in target file system and accessible.</p>
 */
class GestureReplayResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GestureReplayResult ();

    /**
     * Copy constructor
     */
    inline  GestureReplayResult (const GestureReplayResult &rhs);

    /**
     * All fields constructor
     */
    inline  GestureReplayResult (bool bSuccess_);

    /**
     * Destructor
     */
    inline virtual  ~GestureReplayResult();

    /**
     * Assignment operator
     */
    inline GestureReplayResult& operator = (const GestureReplayResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GestureReplayResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GestureReplayResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GestureReplayResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GestureReplayResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSuccess"

    static const int kBSuccess = 0;

    /**
     * Clears the field "bSuccess".
     *
     * The field will be set to its default value. The hasBSuccess()
     * method will return false.
     */
    inline void clearBSuccess();

    /**
     * Checks whether the field "bSuccess" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSuccess()). Otherwise it will return false.
     */
    inline bool hasBSuccess () const;

    /**
     * Returns the value of the member "bSuccess".
     *
     * Success or Failure of the operation Replay.
     *
     * @return The value of the field "bSuccess"
     */
    inline bool getBSuccess () const;

    /**
     * Sets the value of the member "bSuccess".
     *
     * Success or Failure of the operation Replay.
     *
     * @param bSuccess The value which will be set
     */
    inline void setBSuccess (bool bSuccess_);

    static const GestureReplayResult &getDefaultInstance();

private:

    inline void set_has_bSuccess ();

    inline void clear_has_bSuccess ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSuccess;

};

/**
 * The start message of the method "simulatePIVITouch"
 * This method is used to simulate PIVI Touch Press or Release in the HMI.
 */
class SimulatePIVITouchStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulatePIVITouchStart ();

    /**
     * Copy constructor
     */
    inline  SimulatePIVITouchStart (const SimulatePIVITouchStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulatePIVITouchStart (int32 s32XCoord_, int32 s32YCoord_, int32 s32ScreenNumber_, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_);

    /**
     * Destructor
     */
    inline virtual  ~SimulatePIVITouchStart();

    /**
     * Assignment operator
     */
    inline SimulatePIVITouchStart& operator = (const SimulatePIVITouchStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulatePIVITouchStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulatePIVITouchStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulatePIVITouchStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulatePIVITouchStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32XCoord"

    static const int kS32XCoord = 0;

    /**
     * Clears the field "s32XCoord".
     *
     * The field will be set to its default value. The hasS32XCoord()
     * method will return false.
     */
    inline void clearS32XCoord();

    /**
     * Checks whether the field "s32XCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XCoord()). Otherwise it will return false.
     */
    inline bool hasS32XCoord () const;

    /**
     * Returns the value of the member "s32XCoord".
     *
     * signed value of X coord
     *
     * @return The value of the field "s32XCoord"
     */
    inline int32 getS32XCoord () const;

    /**
     * Sets the value of the member "s32XCoord".
     *
     * signed value of X coord
     *
     * @param s32XCoord The value which will be set
     */
    inline void setS32XCoord (int32 s32XCoord_);

    // API of field "s32YCoord"

    static const int kS32YCoord = 1;

    /**
     * Clears the field "s32YCoord".
     *
     * The field will be set to its default value. The hasS32YCoord()
     * method will return false.
     */
    inline void clearS32YCoord();

    /**
     * Checks whether the field "s32YCoord" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YCoord()). Otherwise it will return false.
     */
    inline bool hasS32YCoord () const;

    /**
     * Returns the value of the member "s32YCoord".
     *
     * signed value of Y coord.
     *
     * @return The value of the field "s32YCoord"
     */
    inline int32 getS32YCoord () const;

    /**
     * Sets the value of the member "s32YCoord".
     *
     * signed value of Y coord.
     *
     * @param s32YCoord The value which will be set
     */
    inline void setS32YCoord (int32 s32YCoord_);

    // API of field "s32ScreenNumber"

    static const int kS32ScreenNumber = 2;

    /**
     * Clears the field "s32ScreenNumber".
     *
     * The field will be set to its default value. The hasS32ScreenNumber()
     * method will return false.
     */
    inline void clearS32ScreenNumber();

    /**
     * Checks whether the field "s32ScreenNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32ScreenNumber()). Otherwise it will return false.
     */
    inline bool hasS32ScreenNumber () const;

    /**
     * Returns the value of the member "s32ScreenNumber".
     *
     * <p>1 -for Primary Screen</p>
     * <p>2 -for Secondary Screen</p>
     *
     * @return The value of the field "s32ScreenNumber"
     */
    inline int32 getS32ScreenNumber () const;

    /**
     * Sets the value of the member "s32ScreenNumber".
     *
     * <p>1 -for Primary Screen</p>
     * <p>2 -for Secondary Screen</p>
     *
     * @param s32ScreenNumber The value which will be set
     */
    inline void setS32ScreenNumber (int32 s32ScreenNumber_);

    // API of field "e8TouchStatus"

    static const int kE8TouchStatus = 3;

    /**
     * Clears the field "e8TouchStatus".
     *
     * The field will be set to its default value. The hasE8TouchStatus()
     * method will return false.
     */
    inline void clearE8TouchStatus();

    /**
     * Checks whether the field "e8TouchStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TouchStatus()). Otherwise it will return false.
     */
    inline bool hasE8TouchStatus () const;

    /**
     * Returns the value of the member "e8TouchStatus".
     *
     * Enum of touch status press/release or invalid.
     *
     * @return The value of the field "e8TouchStatus"
     */
    inline ::input_main_fi_types::T_e8_TouchStatus getE8TouchStatus () const;

    /**
     * Sets the value of the member "e8TouchStatus".
     *
     * Enum of touch status press/release or invalid.
     *
     * @param e8TouchStatus The value which will be set
     */
    inline void setE8TouchStatus (::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_);

    static const SimulatePIVITouchStart &getDefaultInstance();

private:

    inline void set_has_s32XCoord ();

    inline void clear_has_s32XCoord ();

    inline void set_has_s32YCoord ();

    inline void clear_has_s32YCoord ();

    inline void set_has_s32ScreenNumber ();

    inline void clear_has_s32ScreenNumber ();

    inline void set_has_e8TouchStatus ();

    inline void clear_has_e8TouchStatus ();

    uint32 _has_bits_[ (4 + 31) / 32];

    int32 _s32XCoord;

    int32 _s32YCoord;

    int32 _s32ScreenNumber;

    ::input_main_fi_types::T_e8_TouchStatus _e8TouchStatus;

};

/**
 * The start message of the method "DevInputNotifyConnection"
 * This method is used to get trigger DevManagerNotifyConnection from vd_device manager via switchctrl
 */
class DevInputNotifyConnectionStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DevInputNotifyConnectionStart ();

    /**
     * Copy constructor
     */
    inline  DevInputNotifyConnectionStart (const DevInputNotifyConnectionStart &rhs);

    /**
     * All fields constructor
     */
    inline  DevInputNotifyConnectionStart (::input_main_fi_types::T_e8_Device DeviceType_, ::input_main_fi_types::T_e8_DeviceConnectStatus DeviceConnectStatus_, const ::std::string& DeviceName_);

    /**
     * Destructor
     */
    inline virtual  ~DevInputNotifyConnectionStart();

    /**
     * Assignment operator
     */
    inline DevInputNotifyConnectionStart& operator = (const DevInputNotifyConnectionStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DevInputNotifyConnectionStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DevInputNotifyConnectionStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DevInputNotifyConnectionStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DevInputNotifyConnectionStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceType"

    static const int kDeviceType = 0;

    /**
     * Clears the field "DeviceType".
     *
     * The field will be set to its default value. The hasDeviceType()
     * method will return false.
     */
    inline void clearDeviceType();

    /**
     * Checks whether the field "DeviceType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceType()). Otherwise it will return false.
     */
    inline bool hasDeviceType () const;

    /**
     * Returns the value of the member "DeviceType".
     *
     * DeviceType Properties
     *
     * @return The value of the field "DeviceType"
     */
    inline ::input_main_fi_types::T_e8_Device getDeviceType () const;

    /**
     * Sets the value of the member "DeviceType".
     *
     * DeviceType Properties
     *
     * @param DeviceType The value which will be set
     */
    inline void setDeviceType (::input_main_fi_types::T_e8_Device DeviceType_);

    // API of field "DeviceConnectStatus"

    static const int kDeviceConnectStatus = 1;

    /**
     * Clears the field "DeviceConnectStatus".
     *
     * The field will be set to its default value. The hasDeviceConnectStatus()
     * method will return false.
     */
    inline void clearDeviceConnectStatus();

    /**
     * Checks whether the field "DeviceConnectStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceConnectStatus()). Otherwise it will return false.
     */
    inline bool hasDeviceConnectStatus () const;

    /**
     * Returns the value of the member "DeviceConnectStatus".
     *
     * Device Connection Status Properties
     *
     * @return The value of the field "DeviceConnectStatus"
     */
    inline ::input_main_fi_types::T_e8_DeviceConnectStatus getDeviceConnectStatus () const;

    /**
     * Sets the value of the member "DeviceConnectStatus".
     *
     * Device Connection Status Properties
     *
     * @param DeviceConnectStatus The value which will be set
     */
    inline void setDeviceConnectStatus (::input_main_fi_types::T_e8_DeviceConnectStatus DeviceConnectStatus_);

    // API of field "DeviceName"

    static const int kDeviceName = 2;

    /**
     * Clears the field "DeviceName".
     *
     * The field will be set to its default value. The hasDeviceName()
     * method will return false.
     */
    inline void clearDeviceName();

    /**
     * Checks whether the field "DeviceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceName()). Otherwise it will return false.
     */
    inline bool hasDeviceName () const;

    /**
     * Returns the value of the member "DeviceName".
     *
     * Device Name Properties
     *
     * @return The value of the field "DeviceName"
     */
    inline const ::std::string& getDeviceName () const;

    /**
     * Retrieves the value of the field "DeviceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceName".
     */
    inline ::std::string& getDeviceNameMutable ();

    /**
     * Sets the value of the member "DeviceName".
     *
     * Device Name Properties
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const ::std::string& DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * Device Name Properties
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* DeviceName_);

    /**
     * Sets the value of the member "DeviceName".
     *
     * Device Name Properties
     *
     * @param DeviceName The value which will be set
     */
    inline void setDeviceName (const char* value, size_t size);

    static const DevInputNotifyConnectionStart &getDefaultInstance();

private:

    inline void set_has_DeviceType ();

    inline void clear_has_DeviceType ();

    inline void set_has_DeviceConnectStatus ();

    inline void clear_has_DeviceConnectStatus ();

    inline void set_has_DeviceName ();

    inline void clear_has_DeviceName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::input_main_fi_types::T_e8_Device _DeviceType;

    ::input_main_fi_types::T_e8_DeviceConnectStatus _DeviceConnectStatus;

    ::std::string _DeviceName;

};

/**
 * The start message of the method "simulatePIVITouchSlide"
 * This method is used to simulate PIVI Touch slide gesture in the HMI.
 */
class SimulatePIVITouchSlideStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SimulatePIVITouchSlideStart ();

    /**
     * Copy constructor
     */
    inline  SimulatePIVITouchSlideStart (const SimulatePIVITouchSlideStart &rhs);

    /**
     * All fields constructor
     */
    inline  SimulatePIVITouchSlideStart (int32 s32XStart_, int32 s32YStart_, int32 s32XEnd_, int32 s32YEnd_, uint16 u16Duration_);

    /**
     * Destructor
     */
    inline virtual  ~SimulatePIVITouchSlideStart();

    /**
     * Assignment operator
     */
    inline SimulatePIVITouchSlideStart& operator = (const SimulatePIVITouchSlideStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SimulatePIVITouchSlideStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SimulatePIVITouchSlideStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SimulatePIVITouchSlideStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SimulatePIVITouchSlideStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "s32XStart"

    static const int kS32XStart = 0;

    /**
     * Clears the field "s32XStart".
     *
     * The field will be set to its default value. The hasS32XStart()
     * method will return false.
     */
    inline void clearS32XStart();

    /**
     * Checks whether the field "s32XStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XStart()). Otherwise it will return false.
     */
    inline bool hasS32XStart () const;

    /**
     * Returns the value of the member "s32XStart".
     *
     * signed value of starting X coord
     *
     * @return The value of the field "s32XStart"
     */
    inline int32 getS32XStart () const;

    /**
     * Sets the value of the member "s32XStart".
     *
     * signed value of starting X coord
     *
     * @param s32XStart The value which will be set
     */
    inline void setS32XStart (int32 s32XStart_);

    // API of field "s32YStart"

    static const int kS32YStart = 1;

    /**
     * Clears the field "s32YStart".
     *
     * The field will be set to its default value. The hasS32YStart()
     * method will return false.
     */
    inline void clearS32YStart();

    /**
     * Checks whether the field "s32YStart" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YStart()). Otherwise it will return false.
     */
    inline bool hasS32YStart () const;

    /**
     * Returns the value of the member "s32YStart".
     *
     * signed value of starting Y coord.
     *
     * @return The value of the field "s32YStart"
     */
    inline int32 getS32YStart () const;

    /**
     * Sets the value of the member "s32YStart".
     *
     * signed value of starting Y coord.
     *
     * @param s32YStart The value which will be set
     */
    inline void setS32YStart (int32 s32YStart_);

    // API of field "s32XEnd"

    static const int kS32XEnd = 2;

    /**
     * Clears the field "s32XEnd".
     *
     * The field will be set to its default value. The hasS32XEnd()
     * method will return false.
     */
    inline void clearS32XEnd();

    /**
     * Checks whether the field "s32XEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32XEnd()). Otherwise it will return false.
     */
    inline bool hasS32XEnd () const;

    /**
     * Returns the value of the member "s32XEnd".
     *
     * signed value of end X coord
     *
     * @return The value of the field "s32XEnd"
     */
    inline int32 getS32XEnd () const;

    /**
     * Sets the value of the member "s32XEnd".
     *
     * signed value of end X coord
     *
     * @param s32XEnd The value which will be set
     */
    inline void setS32XEnd (int32 s32XEnd_);

    // API of field "s32YEnd"

    static const int kS32YEnd = 3;

    /**
     * Clears the field "s32YEnd".
     *
     * The field will be set to its default value. The hasS32YEnd()
     * method will return false.
     */
    inline void clearS32YEnd();

    /**
     * Checks whether the field "s32YEnd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS32YEnd()). Otherwise it will return false.
     */
    inline bool hasS32YEnd () const;

    /**
     * Returns the value of the member "s32YEnd".
     *
     * signed value of end Y coord.
     *
     * @return The value of the field "s32YEnd"
     */
    inline int32 getS32YEnd () const;

    /**
     * Sets the value of the member "s32YEnd".
     *
     * signed value of end Y coord.
     *
     * @param s32YEnd The value which will be set
     */
    inline void setS32YEnd (int32 s32YEnd_);

    // API of field "u16Duration"

    static const int kU16Duration = 4;

    /**
     * Clears the field "u16Duration".
     *
     * The field will be set to its default value. The hasU16Duration()
     * method will return false.
     */
    inline void clearU16Duration();

    /**
     * Checks whether the field "u16Duration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Duration()). Otherwise it will return false.
     */
    inline bool hasU16Duration () const;

    /**
     * Returns the value of the member "u16Duration".
     *
     * Duration shall be in milliseconds and multiple of 10
     *
     * @return The value of the field "u16Duration"
     */
    inline uint16 getU16Duration () const;

    /**
     * Sets the value of the member "u16Duration".
     *
     * Duration shall be in milliseconds and multiple of 10
     *
     * @param u16Duration The value which will be set
     */
    inline void setU16Duration (uint16 u16Duration_);

    static const SimulatePIVITouchSlideStart &getDefaultInstance();

private:

    inline void set_has_s32XStart ();

    inline void clear_has_s32XStart ();

    inline void set_has_s32YStart ();

    inline void clear_has_s32YStart ();

    inline void set_has_s32XEnd ();

    inline void clear_has_s32XEnd ();

    inline void set_has_s32YEnd ();

    inline void clear_has_s32YEnd ();

    inline void set_has_u16Duration ();

    inline void clear_has_u16Duration ();

    uint32 _has_bits_[ (5 + 31) / 32];

    int32 _s32XStart;

    int32 _s32YStart;

    int32 _s32XEnd;

    int32 _s32YEnd;

    uint16 _u16Duration;

};

inline  PressedKeysStatus::PressedKeysStatus ()  :
    _KeyInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PressedKeysStatus::PressedKeysStatus (const PressedKeysStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _KeyInfoList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PressedKeysStatus::PressedKeysStatus (const ::input_main_fi_types::T_DiagKeyList& KeyInfoList_)  :
    _KeyInfoList (KeyInfoList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PressedKeysStatus::~PressedKeysStatus() {
}

inline PressedKeysStatus& PressedKeysStatus::operator = (const PressedKeysStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasKeyInfoList()) {
            setKeyInfoList(rhs.getKeyInfoList());
        } else {
            clearKeyInfoList();
        }
    }
    return *this;
}

inline bool PressedKeysStatus::operator == (const PressedKeysStatus& rhs) const {
    return (((!hasKeyInfoList() && !rhs.hasKeyInfoList()) || getKeyInfoList() == rhs.getKeyInfoList()));
}

inline bool PressedKeysStatus::operator != (const PressedKeysStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool PressedKeysStatus::operator < (const PressedKeysStatus& rhs) const {
    if (hasKeyInfoList() || rhs.hasKeyInfoList()) {
        if (getKeyInfoList() < rhs.getKeyInfoList()) return true;
        if (getKeyInfoList() > rhs.getKeyInfoList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PressedKeysStatus::clone() {
    return new PressedKeysStatus(*this);
}

inline bool PressedKeysStatus::operator > (const PressedKeysStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PressedKeysStatus::clear() {
    clearKeyInfoList();
}

inline void PressedKeysStatus::clearKeyInfoList() {
    if (hasKeyInfoList()) {
         clear_has_KeyInfoList();
        _KeyInfoList.clear();
     }
}

inline bool PressedKeysStatus::hasKeyInfoList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::input_main_fi_types::T_DiagKeyList& PressedKeysStatus::getKeyInfoList () const {
    return _KeyInfoList;
}

inline ::input_main_fi_types::T_DiagKeyList& PressedKeysStatus::getKeyInfoListMutable () {
    set_has_KeyInfoList();
    return _KeyInfoList;
}

inline void PressedKeysStatus::setKeyInfoList (const ::input_main_fi_types::T_DiagKeyList& KeyInfoList_) {
    set_has_KeyInfoList();
    this->_KeyInfoList = KeyInfoList_;
}

inline void PressedKeysStatus::set_has_KeyInfoList () {
    _has_bits_[0] |= 1u << 0;
}

inline void PressedKeysStatus::clear_has_KeyInfoList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PressedKeysErrorStructure::PressedKeysErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PressedKeysErrorStructure::PressedKeysErrorStructure (const PressedKeysErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PressedKeysErrorStructure::PressedKeysErrorStructure (uint8 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PressedKeysErrorStructure::~PressedKeysErrorStructure() {
}

inline PressedKeysErrorStructure& PressedKeysErrorStructure::operator = (const PressedKeysErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool PressedKeysErrorStructure::operator == (const PressedKeysErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool PressedKeysErrorStructure::operator != (const PressedKeysErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool PressedKeysErrorStructure::operator < (const PressedKeysErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool PressedKeysErrorStructure::operator > (const PressedKeysErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PressedKeysErrorStructure::clear() {
    clearErrorCode();
}

inline void PressedKeysErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool PressedKeysErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 PressedKeysErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void PressedKeysErrorStructure::setErrorCode (uint8 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void PressedKeysErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void PressedKeysErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PressedKeysError::PressedKeysError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  PressedKeysError::PressedKeysError (const PressedKeysError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  PressedKeysError::~PressedKeysError() {
    deleteData ();
}

inline PressedKeysError& PressedKeysError::operator = (const PressedKeysError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool PressedKeysError::operator == (const PressedKeysError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool PressedKeysError::operator != (const PressedKeysError& rhs) const {
    return ! (*this == rhs);
}

inline bool PressedKeysError::operator < (const PressedKeysError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool PressedKeysError::operator > (const PressedKeysError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline PressedKeysError::PressedKeysErrorField PressedKeysError::getField () const {
    return __field;
}

inline void PressedKeysError::setField(PressedKeysError::PressedKeysErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* PressedKeysError::clone() {
    return new PressedKeysError(*this);
}

inline bool PressedKeysError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const PressedKeysErrorStructure& PressedKeysError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "PressedKeysError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return PressedKeysErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline PressedKeysErrorStructure& PressedKeysError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "PressedKeysError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new PressedKeysErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline PressedKeysErrorStructure* PressedKeysError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'PressedKeysError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new PressedKeysErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        PressedKeysErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void PressedKeysError::replaceCcaErrorCode (PressedKeysErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void PressedKeysError::setCcaErrorCode (const PressedKeysErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new PressedKeysErrorStructure(value);
    }
}

inline bool PressedKeysError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode PressedKeysError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "PressedKeysError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void PressedKeysError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "PressedKeysError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void PressedKeysError::cloneData (const PressedKeysError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new PressedKeysErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new PressedKeysErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void PressedKeysError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  EncoderDirStatusStatus::EncoderDirStatusStatus ()  :
    _tEncoderDirectionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EncoderDirStatusStatus::EncoderDirStatusStatus (const EncoderDirStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tEncoderDirectionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EncoderDirStatusStatus::EncoderDirStatusStatus (const ::input_main_fi_types::T_EncoderDirectionList& tEncoderDirectionList_)  :
    _tEncoderDirectionList (tEncoderDirectionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EncoderDirStatusStatus::~EncoderDirStatusStatus() {
}

inline EncoderDirStatusStatus& EncoderDirStatusStatus::operator = (const EncoderDirStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTEncoderDirectionList()) {
            setTEncoderDirectionList(rhs.getTEncoderDirectionList());
        } else {
            clearTEncoderDirectionList();
        }
    }
    return *this;
}

inline bool EncoderDirStatusStatus::operator == (const EncoderDirStatusStatus& rhs) const {
    return (((!hasTEncoderDirectionList() && !rhs.hasTEncoderDirectionList()) || getTEncoderDirectionList() == rhs.getTEncoderDirectionList()));
}

inline bool EncoderDirStatusStatus::operator != (const EncoderDirStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderDirStatusStatus::operator < (const EncoderDirStatusStatus& rhs) const {
    if (hasTEncoderDirectionList() || rhs.hasTEncoderDirectionList()) {
        if (getTEncoderDirectionList() < rhs.getTEncoderDirectionList()) return true;
        if (getTEncoderDirectionList() > rhs.getTEncoderDirectionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EncoderDirStatusStatus::clone() {
    return new EncoderDirStatusStatus(*this);
}

inline bool EncoderDirStatusStatus::operator > (const EncoderDirStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EncoderDirStatusStatus::clear() {
    clearTEncoderDirectionList();
}

inline void EncoderDirStatusStatus::clearTEncoderDirectionList() {
    if (hasTEncoderDirectionList()) {
         clear_has_tEncoderDirectionList();
        _tEncoderDirectionList.clear();
     }
}

inline bool EncoderDirStatusStatus::hasTEncoderDirectionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::input_main_fi_types::T_EncoderDirectionList& EncoderDirStatusStatus::getTEncoderDirectionList () const {
    return _tEncoderDirectionList;
}

inline ::input_main_fi_types::T_EncoderDirectionList& EncoderDirStatusStatus::getTEncoderDirectionListMutable () {
    set_has_tEncoderDirectionList();
    return _tEncoderDirectionList;
}

inline void EncoderDirStatusStatus::setTEncoderDirectionList (const ::input_main_fi_types::T_EncoderDirectionList& tEncoderDirectionList_) {
    set_has_tEncoderDirectionList();
    this->_tEncoderDirectionList = tEncoderDirectionList_;
}

inline void EncoderDirStatusStatus::set_has_tEncoderDirectionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void EncoderDirStatusStatus::clear_has_tEncoderDirectionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EncoderDirStatusErrorStructure::EncoderDirStatusErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EncoderDirStatusErrorStructure::EncoderDirStatusErrorStructure (const EncoderDirStatusErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EncoderDirStatusErrorStructure::EncoderDirStatusErrorStructure (uint8 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EncoderDirStatusErrorStructure::~EncoderDirStatusErrorStructure() {
}

inline EncoderDirStatusErrorStructure& EncoderDirStatusErrorStructure::operator = (const EncoderDirStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool EncoderDirStatusErrorStructure::operator == (const EncoderDirStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool EncoderDirStatusErrorStructure::operator != (const EncoderDirStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderDirStatusErrorStructure::operator < (const EncoderDirStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool EncoderDirStatusErrorStructure::operator > (const EncoderDirStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EncoderDirStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void EncoderDirStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool EncoderDirStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EncoderDirStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void EncoderDirStatusErrorStructure::setErrorCode (uint8 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void EncoderDirStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void EncoderDirStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EncoderDirStatusError::EncoderDirStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  EncoderDirStatusError::EncoderDirStatusError (const EncoderDirStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  EncoderDirStatusError::~EncoderDirStatusError() {
    deleteData ();
}

inline EncoderDirStatusError& EncoderDirStatusError::operator = (const EncoderDirStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool EncoderDirStatusError::operator == (const EncoderDirStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool EncoderDirStatusError::operator != (const EncoderDirStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderDirStatusError::operator < (const EncoderDirStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool EncoderDirStatusError::operator > (const EncoderDirStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline EncoderDirStatusError::EncoderDirStatusErrorField EncoderDirStatusError::getField () const {
    return __field;
}

inline void EncoderDirStatusError::setField(EncoderDirStatusError::EncoderDirStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* EncoderDirStatusError::clone() {
    return new EncoderDirStatusError(*this);
}

inline bool EncoderDirStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const EncoderDirStatusErrorStructure& EncoderDirStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "EncoderDirStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return EncoderDirStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline EncoderDirStatusErrorStructure& EncoderDirStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "EncoderDirStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new EncoderDirStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline EncoderDirStatusErrorStructure* EncoderDirStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'EncoderDirStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new EncoderDirStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        EncoderDirStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void EncoderDirStatusError::replaceCcaErrorCode (EncoderDirStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void EncoderDirStatusError::setCcaErrorCode (const EncoderDirStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new EncoderDirStatusErrorStructure(value);
    }
}

inline bool EncoderDirStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode EncoderDirStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "EncoderDirStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void EncoderDirStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "EncoderDirStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void EncoderDirStatusError::cloneData (const EncoderDirStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new EncoderDirStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new EncoderDirStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void EncoderDirStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  EncoderStatusStatus::EncoderStatusStatus ()  :
    _tEncoderStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EncoderStatusStatus::EncoderStatusStatus (const EncoderStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tEncoderStatus ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EncoderStatusStatus::EncoderStatusStatus (const ::input_main_fi_types::T_EncoderStatus& tEncoderStatus_)  :
    _tEncoderStatus (tEncoderStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EncoderStatusStatus::~EncoderStatusStatus() {
}

inline EncoderStatusStatus& EncoderStatusStatus::operator = (const EncoderStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTEncoderStatus()) {
            setTEncoderStatus(rhs.getTEncoderStatus());
        } else {
            clearTEncoderStatus();
        }
    }
    return *this;
}

inline bool EncoderStatusStatus::operator == (const EncoderStatusStatus& rhs) const {
    return (((!hasTEncoderStatus() && !rhs.hasTEncoderStatus()) || getTEncoderStatus() == rhs.getTEncoderStatus()));
}

inline bool EncoderStatusStatus::operator != (const EncoderStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderStatusStatus::operator < (const EncoderStatusStatus& rhs) const {
    if (hasTEncoderStatus() || rhs.hasTEncoderStatus()) {
        if (getTEncoderStatus() < rhs.getTEncoderStatus()) return true;
        if (getTEncoderStatus() > rhs.getTEncoderStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EncoderStatusStatus::clone() {
    return new EncoderStatusStatus(*this);
}

inline bool EncoderStatusStatus::operator > (const EncoderStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EncoderStatusStatus::clear() {
    clearTEncoderStatus();
}

inline void EncoderStatusStatus::clearTEncoderStatus() {
    if (hasTEncoderStatus()) {
         clear_has_tEncoderStatus();
        _tEncoderStatus.clear();
     }
}

inline bool EncoderStatusStatus::hasTEncoderStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::input_main_fi_types::T_EncoderStatus& EncoderStatusStatus::getTEncoderStatus () const {
    return _tEncoderStatus;
}

inline ::input_main_fi_types::T_EncoderStatus& EncoderStatusStatus::getTEncoderStatusMutable () {
    set_has_tEncoderStatus();
    return _tEncoderStatus;
}

inline void EncoderStatusStatus::setTEncoderStatus (const ::input_main_fi_types::T_EncoderStatus& tEncoderStatus_) {
    set_has_tEncoderStatus();
    this->_tEncoderStatus = tEncoderStatus_;
}

inline void EncoderStatusStatus::set_has_tEncoderStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void EncoderStatusStatus::clear_has_tEncoderStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EncoderStatusErrorStructure::EncoderStatusErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EncoderStatusErrorStructure::EncoderStatusErrorStructure (const EncoderStatusErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EncoderStatusErrorStructure::EncoderStatusErrorStructure (uint8 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EncoderStatusErrorStructure::~EncoderStatusErrorStructure() {
}

inline EncoderStatusErrorStructure& EncoderStatusErrorStructure::operator = (const EncoderStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool EncoderStatusErrorStructure::operator == (const EncoderStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool EncoderStatusErrorStructure::operator != (const EncoderStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderStatusErrorStructure::operator < (const EncoderStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool EncoderStatusErrorStructure::operator > (const EncoderStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EncoderStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void EncoderStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool EncoderStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 EncoderStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void EncoderStatusErrorStructure::setErrorCode (uint8 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void EncoderStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void EncoderStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  EncoderStatusError::EncoderStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  EncoderStatusError::EncoderStatusError (const EncoderStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  EncoderStatusError::~EncoderStatusError() {
    deleteData ();
}

inline EncoderStatusError& EncoderStatusError::operator = (const EncoderStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool EncoderStatusError::operator == (const EncoderStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool EncoderStatusError::operator != (const EncoderStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool EncoderStatusError::operator < (const EncoderStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool EncoderStatusError::operator > (const EncoderStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline EncoderStatusError::EncoderStatusErrorField EncoderStatusError::getField () const {
    return __field;
}

inline void EncoderStatusError::setField(EncoderStatusError::EncoderStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* EncoderStatusError::clone() {
    return new EncoderStatusError(*this);
}

inline bool EncoderStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const EncoderStatusErrorStructure& EncoderStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "EncoderStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return EncoderStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline EncoderStatusErrorStructure& EncoderStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "EncoderStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new EncoderStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline EncoderStatusErrorStructure* EncoderStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'EncoderStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new EncoderStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        EncoderStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void EncoderStatusError::replaceCcaErrorCode (EncoderStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void EncoderStatusError::setCcaErrorCode (const EncoderStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new EncoderStatusErrorStructure(value);
    }
}

inline bool EncoderStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode EncoderStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "EncoderStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void EncoderStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "EncoderStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void EncoderStatusError::cloneData (const EncoderStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new EncoderStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new EncoderStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void EncoderStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  TouchStatusStatus::TouchStatusStatus ()  :
    _tTouchDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TouchStatusStatus::TouchStatusStatus (const TouchStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tTouchDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TouchStatusStatus::TouchStatusStatus (const ::input_main_fi_types::T_TouchDataList& tTouchDataList_)  :
    _tTouchDataList (tTouchDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TouchStatusStatus::~TouchStatusStatus() {
}

inline TouchStatusStatus& TouchStatusStatus::operator = (const TouchStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTTouchDataList()) {
            setTTouchDataList(rhs.getTTouchDataList());
        } else {
            clearTTouchDataList();
        }
    }
    return *this;
}

inline bool TouchStatusStatus::operator == (const TouchStatusStatus& rhs) const {
    return (((!hasTTouchDataList() && !rhs.hasTTouchDataList()) || getTTouchDataList() == rhs.getTTouchDataList()));
}

inline bool TouchStatusStatus::operator != (const TouchStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TouchStatusStatus::operator < (const TouchStatusStatus& rhs) const {
    if (hasTTouchDataList() || rhs.hasTTouchDataList()) {
        if (getTTouchDataList() < rhs.getTTouchDataList()) return true;
        if (getTTouchDataList() > rhs.getTTouchDataList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TouchStatusStatus::clone() {
    return new TouchStatusStatus(*this);
}

inline bool TouchStatusStatus::operator > (const TouchStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TouchStatusStatus::clear() {
    clearTTouchDataList();
}

inline void TouchStatusStatus::clearTTouchDataList() {
    if (hasTTouchDataList()) {
         clear_has_tTouchDataList();
        _tTouchDataList.clear();
     }
}

inline bool TouchStatusStatus::hasTTouchDataList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::input_main_fi_types::T_TouchDataList& TouchStatusStatus::getTTouchDataList () const {
    return _tTouchDataList;
}

inline ::input_main_fi_types::T_TouchDataList& TouchStatusStatus::getTTouchDataListMutable () {
    set_has_tTouchDataList();
    return _tTouchDataList;
}

inline void TouchStatusStatus::setTTouchDataList (const ::input_main_fi_types::T_TouchDataList& tTouchDataList_) {
    set_has_tTouchDataList();
    this->_tTouchDataList = tTouchDataList_;
}

inline void TouchStatusStatus::set_has_tTouchDataList () {
    _has_bits_[0] |= 1u << 0;
}

inline void TouchStatusStatus::clear_has_tTouchDataList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TouchStatusErrorStructure::TouchStatusErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TouchStatusErrorStructure::TouchStatusErrorStructure (const TouchStatusErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TouchStatusErrorStructure::TouchStatusErrorStructure (uint8 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TouchStatusErrorStructure::~TouchStatusErrorStructure() {
}

inline TouchStatusErrorStructure& TouchStatusErrorStructure::operator = (const TouchStatusErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool TouchStatusErrorStructure::operator == (const TouchStatusErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool TouchStatusErrorStructure::operator != (const TouchStatusErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool TouchStatusErrorStructure::operator < (const TouchStatusErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool TouchStatusErrorStructure::operator > (const TouchStatusErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TouchStatusErrorStructure::clear() {
    clearErrorCode();
}

inline void TouchStatusErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool TouchStatusErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TouchStatusErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void TouchStatusErrorStructure::setErrorCode (uint8 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void TouchStatusErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void TouchStatusErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TouchStatusError::TouchStatusError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  TouchStatusError::TouchStatusError (const TouchStatusError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  TouchStatusError::~TouchStatusError() {
    deleteData ();
}

inline TouchStatusError& TouchStatusError::operator = (const TouchStatusError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool TouchStatusError::operator == (const TouchStatusError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool TouchStatusError::operator != (const TouchStatusError& rhs) const {
    return ! (*this == rhs);
}

inline bool TouchStatusError::operator < (const TouchStatusError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool TouchStatusError::operator > (const TouchStatusError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline TouchStatusError::TouchStatusErrorField TouchStatusError::getField () const {
    return __field;
}

inline void TouchStatusError::setField(TouchStatusError::TouchStatusErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* TouchStatusError::clone() {
    return new TouchStatusError(*this);
}

inline bool TouchStatusError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const TouchStatusErrorStructure& TouchStatusError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "TouchStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return TouchStatusErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline TouchStatusErrorStructure& TouchStatusError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "TouchStatusError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new TouchStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline TouchStatusErrorStructure* TouchStatusError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'TouchStatusError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new TouchStatusErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        TouchStatusErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void TouchStatusError::replaceCcaErrorCode (TouchStatusErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void TouchStatusError::setCcaErrorCode (const TouchStatusErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new TouchStatusErrorStructure(value);
    }
}

inline bool TouchStatusError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode TouchStatusError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "TouchStatusError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void TouchStatusError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "TouchStatusError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void TouchStatusError::cloneData (const TouchStatusError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new TouchStatusErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new TouchStatusErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void TouchStatusError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  TouchStatusPIVISecondaryStatus::TouchStatusPIVISecondaryStatus ()  :
    _tSecondaryTouchDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TouchStatusPIVISecondaryStatus::TouchStatusPIVISecondaryStatus (const TouchStatusPIVISecondaryStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _tSecondaryTouchDataList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TouchStatusPIVISecondaryStatus::TouchStatusPIVISecondaryStatus (const ::input_main_fi_types::T_TouchDataList& tSecondaryTouchDataList_)  :
    _tSecondaryTouchDataList (tSecondaryTouchDataList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TouchStatusPIVISecondaryStatus::~TouchStatusPIVISecondaryStatus() {
}

inline TouchStatusPIVISecondaryStatus& TouchStatusPIVISecondaryStatus::operator = (const TouchStatusPIVISecondaryStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTSecondaryTouchDataList()) {
            setTSecondaryTouchDataList(rhs.getTSecondaryTouchDataList());
        } else {
            clearTSecondaryTouchDataList();
        }
    }
    return *this;
}

inline bool TouchStatusPIVISecondaryStatus::operator == (const TouchStatusPIVISecondaryStatus& rhs) const {
    return (((!hasTSecondaryTouchDataList() && !rhs.hasTSecondaryTouchDataList()) || getTSecondaryTouchDataList() == rhs.getTSecondaryTouchDataList()));
}

inline bool TouchStatusPIVISecondaryStatus::operator != (const TouchStatusPIVISecondaryStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool TouchStatusPIVISecondaryStatus::operator < (const TouchStatusPIVISecondaryStatus& rhs) const {
    if (hasTSecondaryTouchDataList() || rhs.hasTSecondaryTouchDataList()) {
        if (getTSecondaryTouchDataList() < rhs.getTSecondaryTouchDataList()) return true;
        if (getTSecondaryTouchDataList() > rhs.getTSecondaryTouchDataList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TouchStatusPIVISecondaryStatus::clone() {
    return new TouchStatusPIVISecondaryStatus(*this);
}

inline bool TouchStatusPIVISecondaryStatus::operator > (const TouchStatusPIVISecondaryStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TouchStatusPIVISecondaryStatus::clear() {
    clearTSecondaryTouchDataList();
}

inline void TouchStatusPIVISecondaryStatus::clearTSecondaryTouchDataList() {
    if (hasTSecondaryTouchDataList()) {
         clear_has_tSecondaryTouchDataList();
        _tSecondaryTouchDataList.clear();
     }
}

inline bool TouchStatusPIVISecondaryStatus::hasTSecondaryTouchDataList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::input_main_fi_types::T_TouchDataList& TouchStatusPIVISecondaryStatus::getTSecondaryTouchDataList () const {
    return _tSecondaryTouchDataList;
}

inline ::input_main_fi_types::T_TouchDataList& TouchStatusPIVISecondaryStatus::getTSecondaryTouchDataListMutable () {
    set_has_tSecondaryTouchDataList();
    return _tSecondaryTouchDataList;
}

inline void TouchStatusPIVISecondaryStatus::setTSecondaryTouchDataList (const ::input_main_fi_types::T_TouchDataList& tSecondaryTouchDataList_) {
    set_has_tSecondaryTouchDataList();
    this->_tSecondaryTouchDataList = tSecondaryTouchDataList_;
}

inline void TouchStatusPIVISecondaryStatus::set_has_tSecondaryTouchDataList () {
    _has_bits_[0] |= 1u << 0;
}

inline void TouchStatusPIVISecondaryStatus::clear_has_tSecondaryTouchDataList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TouchStatusPIVISecondaryErrorStructure::TouchStatusPIVISecondaryErrorStructure ()  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TouchStatusPIVISecondaryErrorStructure::TouchStatusPIVISecondaryErrorStructure (const TouchStatusPIVISecondaryErrorStructure &rhs)  :
    _ErrorCode (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TouchStatusPIVISecondaryErrorStructure::TouchStatusPIVISecondaryErrorStructure (uint8 ErrorCode_)  :
    _ErrorCode (ErrorCode_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TouchStatusPIVISecondaryErrorStructure::~TouchStatusPIVISecondaryErrorStructure() {
}

inline TouchStatusPIVISecondaryErrorStructure& TouchStatusPIVISecondaryErrorStructure::operator = (const TouchStatusPIVISecondaryErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasErrorCode()) {
            setErrorCode(rhs.getErrorCode());
        } else {
            clearErrorCode();
        }
    }
    return *this;
}

inline bool TouchStatusPIVISecondaryErrorStructure::operator == (const TouchStatusPIVISecondaryErrorStructure& rhs) const {
    return (((!hasErrorCode() && !rhs.hasErrorCode()) || getErrorCode() == rhs.getErrorCode()));
}

inline bool TouchStatusPIVISecondaryErrorStructure::operator != (const TouchStatusPIVISecondaryErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool TouchStatusPIVISecondaryErrorStructure::operator < (const TouchStatusPIVISecondaryErrorStructure& rhs) const {
    if (hasErrorCode() || rhs.hasErrorCode()) {
        if (getErrorCode() < rhs.getErrorCode()) return true;
        if (getErrorCode() > rhs.getErrorCode()) return false;
    }
    return false;
}

inline bool TouchStatusPIVISecondaryErrorStructure::operator > (const TouchStatusPIVISecondaryErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TouchStatusPIVISecondaryErrorStructure::clear() {
    clearErrorCode();
}

inline void TouchStatusPIVISecondaryErrorStructure::clearErrorCode() {
    if (hasErrorCode()) {
         clear_has_ErrorCode();
        _ErrorCode = 0u;
     }
}

inline bool TouchStatusPIVISecondaryErrorStructure::hasErrorCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TouchStatusPIVISecondaryErrorStructure::getErrorCode () const {
    return _ErrorCode;
}

inline void TouchStatusPIVISecondaryErrorStructure::setErrorCode (uint8 ErrorCode_) {
    set_has_ErrorCode();
    this->_ErrorCode = ErrorCode_;
}

inline void TouchStatusPIVISecondaryErrorStructure::set_has_ErrorCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void TouchStatusPIVISecondaryErrorStructure::clear_has_ErrorCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TouchStatusPIVISecondaryError::TouchStatusPIVISecondaryError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  TouchStatusPIVISecondaryError::TouchStatusPIVISecondaryError (const TouchStatusPIVISecondaryError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  TouchStatusPIVISecondaryError::~TouchStatusPIVISecondaryError() {
    deleteData ();
}

inline TouchStatusPIVISecondaryError& TouchStatusPIVISecondaryError::operator = (const TouchStatusPIVISecondaryError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool TouchStatusPIVISecondaryError::operator == (const TouchStatusPIVISecondaryError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool TouchStatusPIVISecondaryError::operator != (const TouchStatusPIVISecondaryError& rhs) const {
    return ! (*this == rhs);
}

inline bool TouchStatusPIVISecondaryError::operator < (const TouchStatusPIVISecondaryError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool TouchStatusPIVISecondaryError::operator > (const TouchStatusPIVISecondaryError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline TouchStatusPIVISecondaryError::TouchStatusPIVISecondaryErrorField TouchStatusPIVISecondaryError::getField () const {
    return __field;
}

inline void TouchStatusPIVISecondaryError::setField(TouchStatusPIVISecondaryError::TouchStatusPIVISecondaryErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* TouchStatusPIVISecondaryError::clone() {
    return new TouchStatusPIVISecondaryError(*this);
}

inline bool TouchStatusPIVISecondaryError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const TouchStatusPIVISecondaryErrorStructure& TouchStatusPIVISecondaryError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "TouchStatusPIVISecondaryError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return TouchStatusPIVISecondaryErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline TouchStatusPIVISecondaryErrorStructure& TouchStatusPIVISecondaryError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "TouchStatusPIVISecondaryError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new TouchStatusPIVISecondaryErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline TouchStatusPIVISecondaryErrorStructure* TouchStatusPIVISecondaryError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'TouchStatusPIVISecondaryError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new TouchStatusPIVISecondaryErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        TouchStatusPIVISecondaryErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void TouchStatusPIVISecondaryError::replaceCcaErrorCode (TouchStatusPIVISecondaryErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void TouchStatusPIVISecondaryError::setCcaErrorCode (const TouchStatusPIVISecondaryErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new TouchStatusPIVISecondaryErrorStructure(value);
    }
}

inline bool TouchStatusPIVISecondaryError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode TouchStatusPIVISecondaryError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "TouchStatusPIVISecondaryError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void TouchStatusPIVISecondaryError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "TouchStatusPIVISecondaryError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void TouchStatusPIVISecondaryError::cloneData (const TouchStatusPIVISecondaryError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new TouchStatusPIVISecondaryErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new TouchStatusPIVISecondaryErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void TouchStatusPIVISecondaryError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  EnableInputEventsResult::EnableInputEventsResult ()  :
    _SimulationStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  EnableInputEventsResult::EnableInputEventsResult (const EnableInputEventsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _SimulationStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  EnableInputEventsResult::EnableInputEventsResult (bool SimulationStatus_)  :
    _SimulationStatus (SimulationStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  EnableInputEventsResult::~EnableInputEventsResult() {
}

inline EnableInputEventsResult& EnableInputEventsResult::operator = (const EnableInputEventsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSimulationStatus()) {
            setSimulationStatus(rhs.getSimulationStatus());
        } else {
            clearSimulationStatus();
        }
    }
    return *this;
}

inline bool EnableInputEventsResult::operator == (const EnableInputEventsResult& rhs) const {
    return (((!hasSimulationStatus() && !rhs.hasSimulationStatus()) || getSimulationStatus() == rhs.getSimulationStatus()));
}

inline bool EnableInputEventsResult::operator != (const EnableInputEventsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool EnableInputEventsResult::operator < (const EnableInputEventsResult& rhs) const {
    if (hasSimulationStatus() || rhs.hasSimulationStatus()) {
        if (getSimulationStatus() < rhs.getSimulationStatus()) return true;
        if (getSimulationStatus() > rhs.getSimulationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* EnableInputEventsResult::clone() {
    return new EnableInputEventsResult(*this);
}

inline bool EnableInputEventsResult::operator > (const EnableInputEventsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void EnableInputEventsResult::clear() {
    clearSimulationStatus();
}

inline void EnableInputEventsResult::clearSimulationStatus() {
    if (hasSimulationStatus()) {
         clear_has_SimulationStatus();
        _SimulationStatus = false;
     }
}

inline bool EnableInputEventsResult::hasSimulationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool EnableInputEventsResult::getSimulationStatus () const {
    return _SimulationStatus;
}

inline void EnableInputEventsResult::setSimulationStatus (bool SimulationStatus_) {
    set_has_SimulationStatus();
    this->_SimulationStatus = SimulationStatus_;
}

inline void EnableInputEventsResult::set_has_SimulationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void EnableInputEventsResult::clear_has_SimulationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisableInputEventsResult::DisableInputEventsResult ()  :
    _SimulationStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisableInputEventsResult::DisableInputEventsResult (const DisableInputEventsResult &rhs)  :
    ::asf::core::Payload(rhs),
    _SimulationStatus (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisableInputEventsResult::DisableInputEventsResult (bool SimulationStatus_)  :
    _SimulationStatus (SimulationStatus_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisableInputEventsResult::~DisableInputEventsResult() {
}

inline DisableInputEventsResult& DisableInputEventsResult::operator = (const DisableInputEventsResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSimulationStatus()) {
            setSimulationStatus(rhs.getSimulationStatus());
        } else {
            clearSimulationStatus();
        }
    }
    return *this;
}

inline bool DisableInputEventsResult::operator == (const DisableInputEventsResult& rhs) const {
    return (((!hasSimulationStatus() && !rhs.hasSimulationStatus()) || getSimulationStatus() == rhs.getSimulationStatus()));
}

inline bool DisableInputEventsResult::operator != (const DisableInputEventsResult& rhs) const {
    return ! (*this == rhs);
}

inline bool DisableInputEventsResult::operator < (const DisableInputEventsResult& rhs) const {
    if (hasSimulationStatus() || rhs.hasSimulationStatus()) {
        if (getSimulationStatus() < rhs.getSimulationStatus()) return true;
        if (getSimulationStatus() > rhs.getSimulationStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisableInputEventsResult::clone() {
    return new DisableInputEventsResult(*this);
}

inline bool DisableInputEventsResult::operator > (const DisableInputEventsResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisableInputEventsResult::clear() {
    clearSimulationStatus();
}

inline void DisableInputEventsResult::clearSimulationStatus() {
    if (hasSimulationStatus()) {
         clear_has_SimulationStatus();
        _SimulationStatus = false;
     }
}

inline bool DisableInputEventsResult::hasSimulationStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DisableInputEventsResult::getSimulationStatus () const {
    return _SimulationStatus;
}

inline void DisableInputEventsResult::setSimulationStatus (bool SimulationStatus_) {
    set_has_SimulationStatus();
    this->_SimulationStatus = SimulationStatus_;
}

inline void DisableInputEventsResult::set_has_SimulationStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisableInputEventsResult::clear_has_SimulationStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimulateKeyInjectionStart::SimulateKeyInjectionStart ()  :
    _e16Keycode (::input_main_fi_types::T_e16_KeyCode__INPUT_HK_APP),
    _u8KeyStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateKeyInjectionStart::SimulateKeyInjectionStart (const SimulateKeyInjectionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e16Keycode (::input_main_fi_types::T_e16_KeyCode__INPUT_HK_APP),
    _u8KeyStatus (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateKeyInjectionStart::SimulateKeyInjectionStart (::input_main_fi_types::T_e16_KeyCode e16Keycode_, uint8 u8KeyStatus_)  :
    _e16Keycode (e16Keycode_),
    _u8KeyStatus (u8KeyStatus_)
{
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e16_KeyCode_IsValid(e16Keycode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e16Keycode_, "T_e16_KeyCode", "e16Keycode", "SimulateKeyInjectionStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateKeyInjectionStart::~SimulateKeyInjectionStart() {
}

inline SimulateKeyInjectionStart& SimulateKeyInjectionStart::operator = (const SimulateKeyInjectionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE16Keycode()) {
            setE16Keycode(rhs.getE16Keycode());
        } else {
            clearE16Keycode();
        }
        if (rhs.hasU8KeyStatus()) {
            setU8KeyStatus(rhs.getU8KeyStatus());
        } else {
            clearU8KeyStatus();
        }
    }
    return *this;
}

inline bool SimulateKeyInjectionStart::operator == (const SimulateKeyInjectionStart& rhs) const {
    return (((!hasE16Keycode() && !rhs.hasE16Keycode()) || getE16Keycode() == rhs.getE16Keycode()) &&
        ((!hasU8KeyStatus() && !rhs.hasU8KeyStatus()) || getU8KeyStatus() == rhs.getU8KeyStatus()));
}

inline bool SimulateKeyInjectionStart::operator != (const SimulateKeyInjectionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateKeyInjectionStart::operator < (const SimulateKeyInjectionStart& rhs) const {
    if (hasE16Keycode() || rhs.hasE16Keycode()) {
        if ((uint32)getE16Keycode() < (uint32)rhs.getE16Keycode()) return true;
        if ((uint32)getE16Keycode() > (uint32)rhs.getE16Keycode()) return false;
    }
    if (hasU8KeyStatus() || rhs.hasU8KeyStatus()) {
        if (getU8KeyStatus() < rhs.getU8KeyStatus()) return true;
        if (getU8KeyStatus() > rhs.getU8KeyStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateKeyInjectionStart::clone() {
    return new SimulateKeyInjectionStart(*this);
}

inline bool SimulateKeyInjectionStart::operator > (const SimulateKeyInjectionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateKeyInjectionStart::clear() {
    clearE16Keycode();
    clearU8KeyStatus();
}

inline void SimulateKeyInjectionStart::clearE16Keycode() {
    if (hasE16Keycode()) {
         clear_has_e16Keycode();
        _e16Keycode = ::input_main_fi_types::T_e16_KeyCode__INPUT_HK_APP;
     }
}

inline bool SimulateKeyInjectionStart::hasE16Keycode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::input_main_fi_types::T_e16_KeyCode SimulateKeyInjectionStart::getE16Keycode () const {
    return _e16Keycode;
}

inline void SimulateKeyInjectionStart::setE16Keycode (::input_main_fi_types::T_e16_KeyCode e16Keycode_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e16_KeyCode_IsValid(e16Keycode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e16Keycode_, "T_e16_KeyCode", "e16Keycode", "SimulateKeyInjectionStart");
    }
    #endif
    set_has_e16Keycode();
    this->_e16Keycode = e16Keycode_;
}

inline void SimulateKeyInjectionStart::clearU8KeyStatus() {
    if (hasU8KeyStatus()) {
         clear_has_u8KeyStatus();
        _u8KeyStatus = 0u;
     }
}

inline bool SimulateKeyInjectionStart::hasU8KeyStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 SimulateKeyInjectionStart::getU8KeyStatus () const {
    return _u8KeyStatus;
}

inline void SimulateKeyInjectionStart::setU8KeyStatus (uint8 u8KeyStatus_) {
    set_has_u8KeyStatus();
    this->_u8KeyStatus = u8KeyStatus_;
}

inline void SimulateKeyInjectionStart::set_has_e16Keycode () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateKeyInjectionStart::clear_has_e16Keycode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulateKeyInjectionStart::set_has_u8KeyStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulateKeyInjectionStart::clear_has_u8KeyStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SimulateEncRotationStart::SimulateEncRotationStart ()  :
    _e8EncoderType (::input_main_fi_types::T_e8_EncoderType__LEFT_ENCODER),
    _s8EncSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateEncRotationStart::SimulateEncRotationStart (const SimulateEncRotationStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8EncoderType (::input_main_fi_types::T_e8_EncoderType__LEFT_ENCODER),
    _s8EncSteps (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateEncRotationStart::SimulateEncRotationStart (::input_main_fi_types::T_e8_EncoderType e8EncoderType_, int8 s8EncSteps_)  :
    _e8EncoderType (e8EncoderType_),
    _s8EncSteps (s8EncSteps_)
{
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_EncoderType_IsValid(e8EncoderType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8EncoderType_, "T_e8_EncoderType", "e8EncoderType", "SimulateEncRotationStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateEncRotationStart::~SimulateEncRotationStart() {
}

inline SimulateEncRotationStart& SimulateEncRotationStart::operator = (const SimulateEncRotationStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8EncoderType()) {
            setE8EncoderType(rhs.getE8EncoderType());
        } else {
            clearE8EncoderType();
        }
        if (rhs.hasS8EncSteps()) {
            setS8EncSteps(rhs.getS8EncSteps());
        } else {
            clearS8EncSteps();
        }
    }
    return *this;
}

inline bool SimulateEncRotationStart::operator == (const SimulateEncRotationStart& rhs) const {
    return (((!hasE8EncoderType() && !rhs.hasE8EncoderType()) || getE8EncoderType() == rhs.getE8EncoderType()) &&
        ((!hasS8EncSteps() && !rhs.hasS8EncSteps()) || getS8EncSteps() == rhs.getS8EncSteps()));
}

inline bool SimulateEncRotationStart::operator != (const SimulateEncRotationStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateEncRotationStart::operator < (const SimulateEncRotationStart& rhs) const {
    if (hasE8EncoderType() || rhs.hasE8EncoderType()) {
        if ((uint32)getE8EncoderType() < (uint32)rhs.getE8EncoderType()) return true;
        if ((uint32)getE8EncoderType() > (uint32)rhs.getE8EncoderType()) return false;
    }
    if (hasS8EncSteps() || rhs.hasS8EncSteps()) {
        if (getS8EncSteps() < rhs.getS8EncSteps()) return true;
        if (getS8EncSteps() > rhs.getS8EncSteps()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateEncRotationStart::clone() {
    return new SimulateEncRotationStart(*this);
}

inline bool SimulateEncRotationStart::operator > (const SimulateEncRotationStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateEncRotationStart::clear() {
    clearE8EncoderType();
    clearS8EncSteps();
}

inline void SimulateEncRotationStart::clearE8EncoderType() {
    if (hasE8EncoderType()) {
         clear_has_e8EncoderType();
        _e8EncoderType = ::input_main_fi_types::T_e8_EncoderType__LEFT_ENCODER;
     }
}

inline bool SimulateEncRotationStart::hasE8EncoderType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::input_main_fi_types::T_e8_EncoderType SimulateEncRotationStart::getE8EncoderType () const {
    return _e8EncoderType;
}

inline void SimulateEncRotationStart::setE8EncoderType (::input_main_fi_types::T_e8_EncoderType e8EncoderType_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_EncoderType_IsValid(e8EncoderType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8EncoderType_, "T_e8_EncoderType", "e8EncoderType", "SimulateEncRotationStart");
    }
    #endif
    set_has_e8EncoderType();
    this->_e8EncoderType = e8EncoderType_;
}

inline void SimulateEncRotationStart::clearS8EncSteps() {
    if (hasS8EncSteps()) {
         clear_has_s8EncSteps();
        _s8EncSteps = 0;
     }
}

inline bool SimulateEncRotationStart::hasS8EncSteps () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int8 SimulateEncRotationStart::getS8EncSteps () const {
    return _s8EncSteps;
}

inline void SimulateEncRotationStart::setS8EncSteps (int8 s8EncSteps_) {
    set_has_s8EncSteps();
    this->_s8EncSteps = s8EncSteps_;
}

inline void SimulateEncRotationStart::set_has_e8EncoderType () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateEncRotationStart::clear_has_e8EncoderType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulateEncRotationStart::set_has_s8EncSteps () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulateEncRotationStart::clear_has_s8EncSteps () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SimulateSingleTouchStart::SimulateSingleTouchStart ()  :
    _s32XCoord (0),
    _s32YCoord (0),
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateSingleTouchStart::SimulateSingleTouchStart (const SimulateSingleTouchStart &rhs)  :
    ::asf::core::Payload(rhs),
    _s32XCoord (0),
    _s32YCoord (0),
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateSingleTouchStart::SimulateSingleTouchStart (int32 s32XCoord_, int32 s32YCoord_, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_)  :
    _s32XCoord (s32XCoord_),
    _s32YCoord (s32YCoord_),
    _e8TouchStatus (e8TouchStatus_)
{
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "SimulateSingleTouchStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateSingleTouchStart::~SimulateSingleTouchStart() {
}

inline SimulateSingleTouchStart& SimulateSingleTouchStart::operator = (const SimulateSingleTouchStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32XCoord()) {
            setS32XCoord(rhs.getS32XCoord());
        } else {
            clearS32XCoord();
        }
        if (rhs.hasS32YCoord()) {
            setS32YCoord(rhs.getS32YCoord());
        } else {
            clearS32YCoord();
        }
        if (rhs.hasE8TouchStatus()) {
            setE8TouchStatus(rhs.getE8TouchStatus());
        } else {
            clearE8TouchStatus();
        }
    }
    return *this;
}

inline bool SimulateSingleTouchStart::operator == (const SimulateSingleTouchStart& rhs) const {
    return (((!hasS32XCoord() && !rhs.hasS32XCoord()) || getS32XCoord() == rhs.getS32XCoord()) &&
        ((!hasS32YCoord() && !rhs.hasS32YCoord()) || getS32YCoord() == rhs.getS32YCoord()) &&
        ((!hasE8TouchStatus() && !rhs.hasE8TouchStatus()) || getE8TouchStatus() == rhs.getE8TouchStatus()));
}

inline bool SimulateSingleTouchStart::operator != (const SimulateSingleTouchStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateSingleTouchStart::operator < (const SimulateSingleTouchStart& rhs) const {
    if (hasS32XCoord() || rhs.hasS32XCoord()) {
        if (getS32XCoord() < rhs.getS32XCoord()) return true;
        if (getS32XCoord() > rhs.getS32XCoord()) return false;
    }
    if (hasS32YCoord() || rhs.hasS32YCoord()) {
        if (getS32YCoord() < rhs.getS32YCoord()) return true;
        if (getS32YCoord() > rhs.getS32YCoord()) return false;
    }
    if (hasE8TouchStatus() || rhs.hasE8TouchStatus()) {
        if ((uint32)getE8TouchStatus() < (uint32)rhs.getE8TouchStatus()) return true;
        if ((uint32)getE8TouchStatus() > (uint32)rhs.getE8TouchStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateSingleTouchStart::clone() {
    return new SimulateSingleTouchStart(*this);
}

inline bool SimulateSingleTouchStart::operator > (const SimulateSingleTouchStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateSingleTouchStart::clear() {
    clearS32XCoord();
    clearS32YCoord();
    clearE8TouchStatus();
}

inline void SimulateSingleTouchStart::clearS32XCoord() {
    if (hasS32XCoord()) {
         clear_has_s32XCoord();
        _s32XCoord = 0;
     }
}

inline bool SimulateSingleTouchStart::hasS32XCoord () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimulateSingleTouchStart::getS32XCoord () const {
    return _s32XCoord;
}

inline void SimulateSingleTouchStart::setS32XCoord (int32 s32XCoord_) {
    set_has_s32XCoord();
    this->_s32XCoord = s32XCoord_;
}

inline void SimulateSingleTouchStart::clearS32YCoord() {
    if (hasS32YCoord()) {
         clear_has_s32YCoord();
        _s32YCoord = 0;
     }
}

inline bool SimulateSingleTouchStart::hasS32YCoord () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SimulateSingleTouchStart::getS32YCoord () const {
    return _s32YCoord;
}

inline void SimulateSingleTouchStart::setS32YCoord (int32 s32YCoord_) {
    set_has_s32YCoord();
    this->_s32YCoord = s32YCoord_;
}

inline void SimulateSingleTouchStart::clearE8TouchStatus() {
    if (hasE8TouchStatus()) {
         clear_has_e8TouchStatus();
        _e8TouchStatus = ::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID;
     }
}

inline bool SimulateSingleTouchStart::hasE8TouchStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::input_main_fi_types::T_e8_TouchStatus SimulateSingleTouchStart::getE8TouchStatus () const {
    return _e8TouchStatus;
}

inline void SimulateSingleTouchStart::setE8TouchStatus (::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "SimulateSingleTouchStart");
    }
    #endif
    set_has_e8TouchStatus();
    this->_e8TouchStatus = e8TouchStatus_;
}

inline void SimulateSingleTouchStart::set_has_s32XCoord () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateSingleTouchStart::clear_has_s32XCoord () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulateSingleTouchStart::set_has_s32YCoord () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulateSingleTouchStart::clear_has_s32YCoord () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimulateSingleTouchStart::set_has_e8TouchStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimulateSingleTouchStart::clear_has_e8TouchStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimulateTouchSlideStart::SimulateTouchSlideStart ()  :
    _s32XStart (0),
    _s32YStart (0),
    _s32XEnd (0),
    _s32YEnd (0),
    _u16Duration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateTouchSlideStart::SimulateTouchSlideStart (const SimulateTouchSlideStart &rhs)  :
    ::asf::core::Payload(rhs),
    _s32XStart (0),
    _s32YStart (0),
    _s32XEnd (0),
    _s32YEnd (0),
    _u16Duration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateTouchSlideStart::SimulateTouchSlideStart (int32 s32XStart_, int32 s32YStart_, int32 s32XEnd_, int32 s32YEnd_, uint16 u16Duration_)  :
    _s32XStart (s32XStart_),
    _s32YStart (s32YStart_),
    _s32XEnd (s32XEnd_),
    _s32YEnd (s32YEnd_),
    _u16Duration (u16Duration_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateTouchSlideStart::~SimulateTouchSlideStart() {
}

inline SimulateTouchSlideStart& SimulateTouchSlideStart::operator = (const SimulateTouchSlideStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32XStart()) {
            setS32XStart(rhs.getS32XStart());
        } else {
            clearS32XStart();
        }
        if (rhs.hasS32YStart()) {
            setS32YStart(rhs.getS32YStart());
        } else {
            clearS32YStart();
        }
        if (rhs.hasS32XEnd()) {
            setS32XEnd(rhs.getS32XEnd());
        } else {
            clearS32XEnd();
        }
        if (rhs.hasS32YEnd()) {
            setS32YEnd(rhs.getS32YEnd());
        } else {
            clearS32YEnd();
        }
        if (rhs.hasU16Duration()) {
            setU16Duration(rhs.getU16Duration());
        } else {
            clearU16Duration();
        }
    }
    return *this;
}

inline bool SimulateTouchSlideStart::operator == (const SimulateTouchSlideStart& rhs) const {
    return (((!hasS32XStart() && !rhs.hasS32XStart()) || getS32XStart() == rhs.getS32XStart()) &&
        ((!hasS32YStart() && !rhs.hasS32YStart()) || getS32YStart() == rhs.getS32YStart()) &&
        ((!hasS32XEnd() && !rhs.hasS32XEnd()) || getS32XEnd() == rhs.getS32XEnd()) &&
        ((!hasS32YEnd() && !rhs.hasS32YEnd()) || getS32YEnd() == rhs.getS32YEnd()) &&
        ((!hasU16Duration() && !rhs.hasU16Duration()) || getU16Duration() == rhs.getU16Duration()));
}

inline bool SimulateTouchSlideStart::operator != (const SimulateTouchSlideStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateTouchSlideStart::operator < (const SimulateTouchSlideStart& rhs) const {
    if (hasS32XStart() || rhs.hasS32XStart()) {
        if (getS32XStart() < rhs.getS32XStart()) return true;
        if (getS32XStart() > rhs.getS32XStart()) return false;
    }
    if (hasS32YStart() || rhs.hasS32YStart()) {
        if (getS32YStart() < rhs.getS32YStart()) return true;
        if (getS32YStart() > rhs.getS32YStart()) return false;
    }
    if (hasS32XEnd() || rhs.hasS32XEnd()) {
        if (getS32XEnd() < rhs.getS32XEnd()) return true;
        if (getS32XEnd() > rhs.getS32XEnd()) return false;
    }
    if (hasS32YEnd() || rhs.hasS32YEnd()) {
        if (getS32YEnd() < rhs.getS32YEnd()) return true;
        if (getS32YEnd() > rhs.getS32YEnd()) return false;
    }
    if (hasU16Duration() || rhs.hasU16Duration()) {
        if (getU16Duration() < rhs.getU16Duration()) return true;
        if (getU16Duration() > rhs.getU16Duration()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateTouchSlideStart::clone() {
    return new SimulateTouchSlideStart(*this);
}

inline bool SimulateTouchSlideStart::operator > (const SimulateTouchSlideStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateTouchSlideStart::clear() {
    clearS32XStart();
    clearS32YStart();
    clearS32XEnd();
    clearS32YEnd();
    clearU16Duration();
}

inline void SimulateTouchSlideStart::clearS32XStart() {
    if (hasS32XStart()) {
         clear_has_s32XStart();
        _s32XStart = 0;
     }
}

inline bool SimulateTouchSlideStart::hasS32XStart () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimulateTouchSlideStart::getS32XStart () const {
    return _s32XStart;
}

inline void SimulateTouchSlideStart::setS32XStart (int32 s32XStart_) {
    set_has_s32XStart();
    this->_s32XStart = s32XStart_;
}

inline void SimulateTouchSlideStart::clearS32YStart() {
    if (hasS32YStart()) {
         clear_has_s32YStart();
        _s32YStart = 0;
     }
}

inline bool SimulateTouchSlideStart::hasS32YStart () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SimulateTouchSlideStart::getS32YStart () const {
    return _s32YStart;
}

inline void SimulateTouchSlideStart::setS32YStart (int32 s32YStart_) {
    set_has_s32YStart();
    this->_s32YStart = s32YStart_;
}

inline void SimulateTouchSlideStart::clearS32XEnd() {
    if (hasS32XEnd()) {
         clear_has_s32XEnd();
        _s32XEnd = 0;
     }
}

inline bool SimulateTouchSlideStart::hasS32XEnd () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimulateTouchSlideStart::getS32XEnd () const {
    return _s32XEnd;
}

inline void SimulateTouchSlideStart::setS32XEnd (int32 s32XEnd_) {
    set_has_s32XEnd();
    this->_s32XEnd = s32XEnd_;
}

inline void SimulateTouchSlideStart::clearS32YEnd() {
    if (hasS32YEnd()) {
         clear_has_s32YEnd();
        _s32YEnd = 0;
     }
}

inline bool SimulateTouchSlideStart::hasS32YEnd () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 SimulateTouchSlideStart::getS32YEnd () const {
    return _s32YEnd;
}

inline void SimulateTouchSlideStart::setS32YEnd (int32 s32YEnd_) {
    set_has_s32YEnd();
    this->_s32YEnd = s32YEnd_;
}

inline void SimulateTouchSlideStart::clearU16Duration() {
    if (hasU16Duration()) {
         clear_has_u16Duration();
        _u16Duration = 0u;
     }
}

inline bool SimulateTouchSlideStart::hasU16Duration () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 SimulateTouchSlideStart::getU16Duration () const {
    return _u16Duration;
}

inline void SimulateTouchSlideStart::setU16Duration (uint16 u16Duration_) {
    set_has_u16Duration();
    this->_u16Duration = u16Duration_;
}

inline void SimulateTouchSlideStart::set_has_s32XStart () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateTouchSlideStart::clear_has_s32XStart () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulateTouchSlideStart::set_has_s32YStart () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulateTouchSlideStart::clear_has_s32YStart () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimulateTouchSlideStart::set_has_s32XEnd () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimulateTouchSlideStart::clear_has_s32XEnd () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimulateTouchSlideStart::set_has_s32YEnd () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimulateTouchSlideStart::clear_has_s32YEnd () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SimulateTouchSlideStart::set_has_u16Duration () {
    _has_bits_[0] |= 1u << 4;
}

inline void SimulateTouchSlideStart::clear_has_u16Duration () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  SimulateMultiTouchStart::SimulateMultiTouchStart ()  :
    _s32SlotId (0),
    _s32XCoord (0),
    _s32YCoord (0),
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulateMultiTouchStart::SimulateMultiTouchStart (const SimulateMultiTouchStart &rhs)  :
    ::asf::core::Payload(rhs),
    _s32SlotId (0),
    _s32XCoord (0),
    _s32YCoord (0),
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulateMultiTouchStart::SimulateMultiTouchStart (int32 s32SlotId_, int32 s32XCoord_, int32 s32YCoord_, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_)  :
    _s32SlotId (s32SlotId_),
    _s32XCoord (s32XCoord_),
    _s32YCoord (s32YCoord_),
    _e8TouchStatus (e8TouchStatus_)
{
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "SimulateMultiTouchStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulateMultiTouchStart::~SimulateMultiTouchStart() {
}

inline SimulateMultiTouchStart& SimulateMultiTouchStart::operator = (const SimulateMultiTouchStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32SlotId()) {
            setS32SlotId(rhs.getS32SlotId());
        } else {
            clearS32SlotId();
        }
        if (rhs.hasS32XCoord()) {
            setS32XCoord(rhs.getS32XCoord());
        } else {
            clearS32XCoord();
        }
        if (rhs.hasS32YCoord()) {
            setS32YCoord(rhs.getS32YCoord());
        } else {
            clearS32YCoord();
        }
        if (rhs.hasE8TouchStatus()) {
            setE8TouchStatus(rhs.getE8TouchStatus());
        } else {
            clearE8TouchStatus();
        }
    }
    return *this;
}

inline bool SimulateMultiTouchStart::operator == (const SimulateMultiTouchStart& rhs) const {
    return (((!hasS32SlotId() && !rhs.hasS32SlotId()) || getS32SlotId() == rhs.getS32SlotId()) &&
        ((!hasS32XCoord() && !rhs.hasS32XCoord()) || getS32XCoord() == rhs.getS32XCoord()) &&
        ((!hasS32YCoord() && !rhs.hasS32YCoord()) || getS32YCoord() == rhs.getS32YCoord()) &&
        ((!hasE8TouchStatus() && !rhs.hasE8TouchStatus()) || getE8TouchStatus() == rhs.getE8TouchStatus()));
}

inline bool SimulateMultiTouchStart::operator != (const SimulateMultiTouchStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulateMultiTouchStart::operator < (const SimulateMultiTouchStart& rhs) const {
    if (hasS32SlotId() || rhs.hasS32SlotId()) {
        if (getS32SlotId() < rhs.getS32SlotId()) return true;
        if (getS32SlotId() > rhs.getS32SlotId()) return false;
    }
    if (hasS32XCoord() || rhs.hasS32XCoord()) {
        if (getS32XCoord() < rhs.getS32XCoord()) return true;
        if (getS32XCoord() > rhs.getS32XCoord()) return false;
    }
    if (hasS32YCoord() || rhs.hasS32YCoord()) {
        if (getS32YCoord() < rhs.getS32YCoord()) return true;
        if (getS32YCoord() > rhs.getS32YCoord()) return false;
    }
    if (hasE8TouchStatus() || rhs.hasE8TouchStatus()) {
        if ((uint32)getE8TouchStatus() < (uint32)rhs.getE8TouchStatus()) return true;
        if ((uint32)getE8TouchStatus() > (uint32)rhs.getE8TouchStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulateMultiTouchStart::clone() {
    return new SimulateMultiTouchStart(*this);
}

inline bool SimulateMultiTouchStart::operator > (const SimulateMultiTouchStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulateMultiTouchStart::clear() {
    clearS32SlotId();
    clearS32XCoord();
    clearS32YCoord();
    clearE8TouchStatus();
}

inline void SimulateMultiTouchStart::clearS32SlotId() {
    if (hasS32SlotId()) {
         clear_has_s32SlotId();
        _s32SlotId = 0;
     }
}

inline bool SimulateMultiTouchStart::hasS32SlotId () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimulateMultiTouchStart::getS32SlotId () const {
    return _s32SlotId;
}

inline void SimulateMultiTouchStart::setS32SlotId (int32 s32SlotId_) {
    set_has_s32SlotId();
    this->_s32SlotId = s32SlotId_;
}

inline void SimulateMultiTouchStart::clearS32XCoord() {
    if (hasS32XCoord()) {
         clear_has_s32XCoord();
        _s32XCoord = 0;
     }
}

inline bool SimulateMultiTouchStart::hasS32XCoord () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SimulateMultiTouchStart::getS32XCoord () const {
    return _s32XCoord;
}

inline void SimulateMultiTouchStart::setS32XCoord (int32 s32XCoord_) {
    set_has_s32XCoord();
    this->_s32XCoord = s32XCoord_;
}

inline void SimulateMultiTouchStart::clearS32YCoord() {
    if (hasS32YCoord()) {
         clear_has_s32YCoord();
        _s32YCoord = 0;
     }
}

inline bool SimulateMultiTouchStart::hasS32YCoord () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimulateMultiTouchStart::getS32YCoord () const {
    return _s32YCoord;
}

inline void SimulateMultiTouchStart::setS32YCoord (int32 s32YCoord_) {
    set_has_s32YCoord();
    this->_s32YCoord = s32YCoord_;
}

inline void SimulateMultiTouchStart::clearE8TouchStatus() {
    if (hasE8TouchStatus()) {
         clear_has_e8TouchStatus();
        _e8TouchStatus = ::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID;
     }
}

inline bool SimulateMultiTouchStart::hasE8TouchStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::input_main_fi_types::T_e8_TouchStatus SimulateMultiTouchStart::getE8TouchStatus () const {
    return _e8TouchStatus;
}

inline void SimulateMultiTouchStart::setE8TouchStatus (::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "SimulateMultiTouchStart");
    }
    #endif
    set_has_e8TouchStatus();
    this->_e8TouchStatus = e8TouchStatus_;
}

inline void SimulateMultiTouchStart::set_has_s32SlotId () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulateMultiTouchStart::clear_has_s32SlotId () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulateMultiTouchStart::set_has_s32XCoord () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulateMultiTouchStart::clear_has_s32XCoord () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimulateMultiTouchStart::set_has_s32YCoord () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimulateMultiTouchStart::clear_has_s32YCoord () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimulateMultiTouchStart::set_has_e8TouchStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimulateMultiTouchStart::clear_has_e8TouchStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GestureRecordStart::GestureRecordStart ()  :
    _u8StartStop (0u),
    _FilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GestureRecordStart::GestureRecordStart (const GestureRecordStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8StartStop (0u),
    _FilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GestureRecordStart::GestureRecordStart (uint8 u8StartStop_, const ::std::string& FilePath_)  :
    _u8StartStop (u8StartStop_),
    _FilePath (FilePath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GestureRecordStart::~GestureRecordStart() {
}

inline GestureRecordStart& GestureRecordStart::operator = (const GestureRecordStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8StartStop()) {
            setU8StartStop(rhs.getU8StartStop());
        } else {
            clearU8StartStop();
        }
        if (rhs.hasFilePath()) {
            setFilePath(rhs.getFilePath());
        } else {
            clearFilePath();
        }
    }
    return *this;
}

inline bool GestureRecordStart::operator == (const GestureRecordStart& rhs) const {
    return (((!hasU8StartStop() && !rhs.hasU8StartStop()) || getU8StartStop() == rhs.getU8StartStop()) &&
        ((!hasFilePath() && !rhs.hasFilePath()) || getFilePath() == rhs.getFilePath()));
}

inline bool GestureRecordStart::operator != (const GestureRecordStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GestureRecordStart::operator < (const GestureRecordStart& rhs) const {
    if (hasU8StartStop() || rhs.hasU8StartStop()) {
        if (getU8StartStop() < rhs.getU8StartStop()) return true;
        if (getU8StartStop() > rhs.getU8StartStop()) return false;
    }
    if (hasFilePath() || rhs.hasFilePath()) {
        if (getFilePath() < rhs.getFilePath()) return true;
        if (getFilePath() > rhs.getFilePath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GestureRecordStart::clone() {
    return new GestureRecordStart(*this);
}

inline bool GestureRecordStart::operator > (const GestureRecordStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GestureRecordStart::clear() {
    clearU8StartStop();
    clearFilePath();
}

inline void GestureRecordStart::clearU8StartStop() {
    if (hasU8StartStop()) {
         clear_has_u8StartStop();
        _u8StartStop = 0u;
     }
}

inline bool GestureRecordStart::hasU8StartStop () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GestureRecordStart::getU8StartStop () const {
    return _u8StartStop;
}

inline void GestureRecordStart::setU8StartStop (uint8 u8StartStop_) {
    set_has_u8StartStop();
    this->_u8StartStop = u8StartStop_;
}

inline void GestureRecordStart::clearFilePath() {
    if (hasFilePath()) {
         clear_has_FilePath();
        _FilePath.clear();
     }
}

inline bool GestureRecordStart::hasFilePath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GestureRecordStart::getFilePath () const {
    return _FilePath;
}

inline ::std::string& GestureRecordStart::getFilePathMutable () {
    set_has_FilePath();
    return _FilePath;
}

inline void GestureRecordStart::setFilePath (const ::std::string& FilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath = FilePath_;
}

inline void GestureRecordStart::setFilePath (const char* FilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath.assign(FilePath_);
}

inline void GestureRecordStart::setFilePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath.assign(value, size);
}

inline void GestureRecordStart::set_has_u8StartStop () {
    _has_bits_[0] |= 1u << 0;
}

inline void GestureRecordStart::clear_has_u8StartStop () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GestureRecordStart::set_has_FilePath () {
    _has_bits_[0] |= 1u << 1;
}

inline void GestureRecordStart::clear_has_FilePath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GestureRecordResult::GestureRecordResult ()  :
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GestureRecordResult::GestureRecordResult (const GestureRecordResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GestureRecordResult::GestureRecordResult (bool bSuccess_)  :
    _bSuccess (bSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GestureRecordResult::~GestureRecordResult() {
}

inline GestureRecordResult& GestureRecordResult::operator = (const GestureRecordResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSuccess()) {
            setBSuccess(rhs.getBSuccess());
        } else {
            clearBSuccess();
        }
    }
    return *this;
}

inline bool GestureRecordResult::operator == (const GestureRecordResult& rhs) const {
    return (((!hasBSuccess() && !rhs.hasBSuccess()) || getBSuccess() == rhs.getBSuccess()));
}

inline bool GestureRecordResult::operator != (const GestureRecordResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GestureRecordResult::operator < (const GestureRecordResult& rhs) const {
    if (hasBSuccess() || rhs.hasBSuccess()) {
        if (getBSuccess() < rhs.getBSuccess()) return true;
        if (getBSuccess() > rhs.getBSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GestureRecordResult::clone() {
    return new GestureRecordResult(*this);
}

inline bool GestureRecordResult::operator > (const GestureRecordResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GestureRecordResult::clear() {
    clearBSuccess();
}

inline void GestureRecordResult::clearBSuccess() {
    if (hasBSuccess()) {
         clear_has_bSuccess();
        _bSuccess = false;
     }
}

inline bool GestureRecordResult::hasBSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GestureRecordResult::getBSuccess () const {
    return _bSuccess;
}

inline void GestureRecordResult::setBSuccess (bool bSuccess_) {
    set_has_bSuccess();
    this->_bSuccess = bSuccess_;
}

inline void GestureRecordResult::set_has_bSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void GestureRecordResult::clear_has_bSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GestureReplayStart::GestureReplayStart ()  :
    _u8StartStop (0u),
    _FilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GestureReplayStart::GestureReplayStart (const GestureReplayStart &rhs)  :
    ::asf::core::Payload(rhs),
    _u8StartStop (0u),
    _FilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GestureReplayStart::GestureReplayStart (uint8 u8StartStop_, const ::std::string& FilePath_)  :
    _u8StartStop (u8StartStop_),
    _FilePath (FilePath_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GestureReplayStart::~GestureReplayStart() {
}

inline GestureReplayStart& GestureReplayStart::operator = (const GestureReplayStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasU8StartStop()) {
            setU8StartStop(rhs.getU8StartStop());
        } else {
            clearU8StartStop();
        }
        if (rhs.hasFilePath()) {
            setFilePath(rhs.getFilePath());
        } else {
            clearFilePath();
        }
    }
    return *this;
}

inline bool GestureReplayStart::operator == (const GestureReplayStart& rhs) const {
    return (((!hasU8StartStop() && !rhs.hasU8StartStop()) || getU8StartStop() == rhs.getU8StartStop()) &&
        ((!hasFilePath() && !rhs.hasFilePath()) || getFilePath() == rhs.getFilePath()));
}

inline bool GestureReplayStart::operator != (const GestureReplayStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GestureReplayStart::operator < (const GestureReplayStart& rhs) const {
    if (hasU8StartStop() || rhs.hasU8StartStop()) {
        if (getU8StartStop() < rhs.getU8StartStop()) return true;
        if (getU8StartStop() > rhs.getU8StartStop()) return false;
    }
    if (hasFilePath() || rhs.hasFilePath()) {
        if (getFilePath() < rhs.getFilePath()) return true;
        if (getFilePath() > rhs.getFilePath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GestureReplayStart::clone() {
    return new GestureReplayStart(*this);
}

inline bool GestureReplayStart::operator > (const GestureReplayStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GestureReplayStart::clear() {
    clearU8StartStop();
    clearFilePath();
}

inline void GestureReplayStart::clearU8StartStop() {
    if (hasU8StartStop()) {
         clear_has_u8StartStop();
        _u8StartStop = 0u;
     }
}

inline bool GestureReplayStart::hasU8StartStop () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GestureReplayStart::getU8StartStop () const {
    return _u8StartStop;
}

inline void GestureReplayStart::setU8StartStop (uint8 u8StartStop_) {
    set_has_u8StartStop();
    this->_u8StartStop = u8StartStop_;
}

inline void GestureReplayStart::clearFilePath() {
    if (hasFilePath()) {
         clear_has_FilePath();
        _FilePath.clear();
     }
}

inline bool GestureReplayStart::hasFilePath () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& GestureReplayStart::getFilePath () const {
    return _FilePath;
}

inline ::std::string& GestureReplayStart::getFilePathMutable () {
    set_has_FilePath();
    return _FilePath;
}

inline void GestureReplayStart::setFilePath (const ::std::string& FilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath = FilePath_;
}

inline void GestureReplayStart::setFilePath (const char* FilePath_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (FilePath_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath.assign(FilePath_);
}

inline void GestureReplayStart::setFilePath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_FilePath();
    this->_FilePath.assign(value, size);
}

inline void GestureReplayStart::set_has_u8StartStop () {
    _has_bits_[0] |= 1u << 0;
}

inline void GestureReplayStart::clear_has_u8StartStop () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GestureReplayStart::set_has_FilePath () {
    _has_bits_[0] |= 1u << 1;
}

inline void GestureReplayStart::clear_has_FilePath () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GestureReplayResult::GestureReplayResult ()  :
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GestureReplayResult::GestureReplayResult (const GestureReplayResult &rhs)  :
    ::asf::core::Payload(rhs),
    _bSuccess (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GestureReplayResult::GestureReplayResult (bool bSuccess_)  :
    _bSuccess (bSuccess_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GestureReplayResult::~GestureReplayResult() {
}

inline GestureReplayResult& GestureReplayResult::operator = (const GestureReplayResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSuccess()) {
            setBSuccess(rhs.getBSuccess());
        } else {
            clearBSuccess();
        }
    }
    return *this;
}

inline bool GestureReplayResult::operator == (const GestureReplayResult& rhs) const {
    return (((!hasBSuccess() && !rhs.hasBSuccess()) || getBSuccess() == rhs.getBSuccess()));
}

inline bool GestureReplayResult::operator != (const GestureReplayResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GestureReplayResult::operator < (const GestureReplayResult& rhs) const {
    if (hasBSuccess() || rhs.hasBSuccess()) {
        if (getBSuccess() < rhs.getBSuccess()) return true;
        if (getBSuccess() > rhs.getBSuccess()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GestureReplayResult::clone() {
    return new GestureReplayResult(*this);
}

inline bool GestureReplayResult::operator > (const GestureReplayResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GestureReplayResult::clear() {
    clearBSuccess();
}

inline void GestureReplayResult::clearBSuccess() {
    if (hasBSuccess()) {
         clear_has_bSuccess();
        _bSuccess = false;
     }
}

inline bool GestureReplayResult::hasBSuccess () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool GestureReplayResult::getBSuccess () const {
    return _bSuccess;
}

inline void GestureReplayResult::setBSuccess (bool bSuccess_) {
    set_has_bSuccess();
    this->_bSuccess = bSuccess_;
}

inline void GestureReplayResult::set_has_bSuccess () {
    _has_bits_[0] |= 1u << 0;
}

inline void GestureReplayResult::clear_has_bSuccess () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SimulatePIVITouchStart::SimulatePIVITouchStart ()  :
    _s32XCoord (0),
    _s32YCoord (0),
    _s32ScreenNumber (0),
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulatePIVITouchStart::SimulatePIVITouchStart (const SimulatePIVITouchStart &rhs)  :
    ::asf::core::Payload(rhs),
    _s32XCoord (0),
    _s32YCoord (0),
    _s32ScreenNumber (0),
    _e8TouchStatus (::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulatePIVITouchStart::SimulatePIVITouchStart (int32 s32XCoord_, int32 s32YCoord_, int32 s32ScreenNumber_, ::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_)  :
    _s32XCoord (s32XCoord_),
    _s32YCoord (s32YCoord_),
    _s32ScreenNumber (s32ScreenNumber_),
    _e8TouchStatus (e8TouchStatus_)
{
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "SimulatePIVITouchStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulatePIVITouchStart::~SimulatePIVITouchStart() {
}

inline SimulatePIVITouchStart& SimulatePIVITouchStart::operator = (const SimulatePIVITouchStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32XCoord()) {
            setS32XCoord(rhs.getS32XCoord());
        } else {
            clearS32XCoord();
        }
        if (rhs.hasS32YCoord()) {
            setS32YCoord(rhs.getS32YCoord());
        } else {
            clearS32YCoord();
        }
        if (rhs.hasS32ScreenNumber()) {
            setS32ScreenNumber(rhs.getS32ScreenNumber());
        } else {
            clearS32ScreenNumber();
        }
        if (rhs.hasE8TouchStatus()) {
            setE8TouchStatus(rhs.getE8TouchStatus());
        } else {
            clearE8TouchStatus();
        }
    }
    return *this;
}

inline bool SimulatePIVITouchStart::operator == (const SimulatePIVITouchStart& rhs) const {
    return (((!hasS32XCoord() && !rhs.hasS32XCoord()) || getS32XCoord() == rhs.getS32XCoord()) &&
        ((!hasS32YCoord() && !rhs.hasS32YCoord()) || getS32YCoord() == rhs.getS32YCoord()) &&
        ((!hasS32ScreenNumber() && !rhs.hasS32ScreenNumber()) || getS32ScreenNumber() == rhs.getS32ScreenNumber()) &&
        ((!hasE8TouchStatus() && !rhs.hasE8TouchStatus()) || getE8TouchStatus() == rhs.getE8TouchStatus()));
}

inline bool SimulatePIVITouchStart::operator != (const SimulatePIVITouchStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulatePIVITouchStart::operator < (const SimulatePIVITouchStart& rhs) const {
    if (hasS32XCoord() || rhs.hasS32XCoord()) {
        if (getS32XCoord() < rhs.getS32XCoord()) return true;
        if (getS32XCoord() > rhs.getS32XCoord()) return false;
    }
    if (hasS32YCoord() || rhs.hasS32YCoord()) {
        if (getS32YCoord() < rhs.getS32YCoord()) return true;
        if (getS32YCoord() > rhs.getS32YCoord()) return false;
    }
    if (hasS32ScreenNumber() || rhs.hasS32ScreenNumber()) {
        if (getS32ScreenNumber() < rhs.getS32ScreenNumber()) return true;
        if (getS32ScreenNumber() > rhs.getS32ScreenNumber()) return false;
    }
    if (hasE8TouchStatus() || rhs.hasE8TouchStatus()) {
        if ((uint32)getE8TouchStatus() < (uint32)rhs.getE8TouchStatus()) return true;
        if ((uint32)getE8TouchStatus() > (uint32)rhs.getE8TouchStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulatePIVITouchStart::clone() {
    return new SimulatePIVITouchStart(*this);
}

inline bool SimulatePIVITouchStart::operator > (const SimulatePIVITouchStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulatePIVITouchStart::clear() {
    clearS32XCoord();
    clearS32YCoord();
    clearS32ScreenNumber();
    clearE8TouchStatus();
}

inline void SimulatePIVITouchStart::clearS32XCoord() {
    if (hasS32XCoord()) {
         clear_has_s32XCoord();
        _s32XCoord = 0;
     }
}

inline bool SimulatePIVITouchStart::hasS32XCoord () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimulatePIVITouchStart::getS32XCoord () const {
    return _s32XCoord;
}

inline void SimulatePIVITouchStart::setS32XCoord (int32 s32XCoord_) {
    set_has_s32XCoord();
    this->_s32XCoord = s32XCoord_;
}

inline void SimulatePIVITouchStart::clearS32YCoord() {
    if (hasS32YCoord()) {
         clear_has_s32YCoord();
        _s32YCoord = 0;
     }
}

inline bool SimulatePIVITouchStart::hasS32YCoord () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SimulatePIVITouchStart::getS32YCoord () const {
    return _s32YCoord;
}

inline void SimulatePIVITouchStart::setS32YCoord (int32 s32YCoord_) {
    set_has_s32YCoord();
    this->_s32YCoord = s32YCoord_;
}

inline void SimulatePIVITouchStart::clearS32ScreenNumber() {
    if (hasS32ScreenNumber()) {
         clear_has_s32ScreenNumber();
        _s32ScreenNumber = 0;
     }
}

inline bool SimulatePIVITouchStart::hasS32ScreenNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimulatePIVITouchStart::getS32ScreenNumber () const {
    return _s32ScreenNumber;
}

inline void SimulatePIVITouchStart::setS32ScreenNumber (int32 s32ScreenNumber_) {
    set_has_s32ScreenNumber();
    this->_s32ScreenNumber = s32ScreenNumber_;
}

inline void SimulatePIVITouchStart::clearE8TouchStatus() {
    if (hasE8TouchStatus()) {
         clear_has_e8TouchStatus();
        _e8TouchStatus = ::input_main_fi_types::T_e8_TouchStatus__TOUCH_INVALID;
     }
}

inline bool SimulatePIVITouchStart::hasE8TouchStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::input_main_fi_types::T_e8_TouchStatus SimulatePIVITouchStart::getE8TouchStatus () const {
    return _e8TouchStatus;
}

inline void SimulatePIVITouchStart::setE8TouchStatus (::input_main_fi_types::T_e8_TouchStatus e8TouchStatus_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_TouchStatus_IsValid(e8TouchStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TouchStatus_, "T_e8_TouchStatus", "e8TouchStatus", "SimulatePIVITouchStart");
    }
    #endif
    set_has_e8TouchStatus();
    this->_e8TouchStatus = e8TouchStatus_;
}

inline void SimulatePIVITouchStart::set_has_s32XCoord () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulatePIVITouchStart::clear_has_s32XCoord () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulatePIVITouchStart::set_has_s32YCoord () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulatePIVITouchStart::clear_has_s32YCoord () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimulatePIVITouchStart::set_has_s32ScreenNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimulatePIVITouchStart::clear_has_s32ScreenNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimulatePIVITouchStart::set_has_e8TouchStatus () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimulatePIVITouchStart::clear_has_e8TouchStatus () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DevInputNotifyConnectionStart::DevInputNotifyConnectionStart ()  :
    _DeviceType (::input_main_fi_types::T_e8_Device__DTY_BTA),
    _DeviceConnectStatus (::input_main_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED),
    _DeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DevInputNotifyConnectionStart::DevInputNotifyConnectionStart (const DevInputNotifyConnectionStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceType (::input_main_fi_types::T_e8_Device__DTY_BTA),
    _DeviceConnectStatus (::input_main_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED),
    _DeviceName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DevInputNotifyConnectionStart::DevInputNotifyConnectionStart (::input_main_fi_types::T_e8_Device DeviceType_, ::input_main_fi_types::T_e8_DeviceConnectStatus DeviceConnectStatus_, const ::std::string& DeviceName_)  :
    _DeviceType (DeviceType_),
    _DeviceConnectStatus (DeviceConnectStatus_),
    _DeviceName (DeviceName_)
{
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_Device_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "T_e8_Device", "DeviceType", "DevInputNotifyConnectionStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_DeviceConnectStatus_IsValid(DeviceConnectStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceConnectStatus_, "T_e8_DeviceConnectStatus", "DeviceConnectStatus", "DevInputNotifyConnectionStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DevInputNotifyConnectionStart::~DevInputNotifyConnectionStart() {
}

inline DevInputNotifyConnectionStart& DevInputNotifyConnectionStart::operator = (const DevInputNotifyConnectionStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceType()) {
            setDeviceType(rhs.getDeviceType());
        } else {
            clearDeviceType();
        }
        if (rhs.hasDeviceConnectStatus()) {
            setDeviceConnectStatus(rhs.getDeviceConnectStatus());
        } else {
            clearDeviceConnectStatus();
        }
        if (rhs.hasDeviceName()) {
            setDeviceName(rhs.getDeviceName());
        } else {
            clearDeviceName();
        }
    }
    return *this;
}

inline bool DevInputNotifyConnectionStart::operator == (const DevInputNotifyConnectionStart& rhs) const {
    return (((!hasDeviceType() && !rhs.hasDeviceType()) || getDeviceType() == rhs.getDeviceType()) &&
        ((!hasDeviceConnectStatus() && !rhs.hasDeviceConnectStatus()) || getDeviceConnectStatus() == rhs.getDeviceConnectStatus()) &&
        ((!hasDeviceName() && !rhs.hasDeviceName()) || getDeviceName() == rhs.getDeviceName()));
}

inline bool DevInputNotifyConnectionStart::operator != (const DevInputNotifyConnectionStart& rhs) const {
    return ! (*this == rhs);
}

inline bool DevInputNotifyConnectionStart::operator < (const DevInputNotifyConnectionStart& rhs) const {
    if (hasDeviceType() || rhs.hasDeviceType()) {
        if ((uint32)getDeviceType() < (uint32)rhs.getDeviceType()) return true;
        if ((uint32)getDeviceType() > (uint32)rhs.getDeviceType()) return false;
    }
    if (hasDeviceConnectStatus() || rhs.hasDeviceConnectStatus()) {
        if ((uint32)getDeviceConnectStatus() < (uint32)rhs.getDeviceConnectStatus()) return true;
        if ((uint32)getDeviceConnectStatus() > (uint32)rhs.getDeviceConnectStatus()) return false;
    }
    if (hasDeviceName() || rhs.hasDeviceName()) {
        if (getDeviceName() < rhs.getDeviceName()) return true;
        if (getDeviceName() > rhs.getDeviceName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DevInputNotifyConnectionStart::clone() {
    return new DevInputNotifyConnectionStart(*this);
}

inline bool DevInputNotifyConnectionStart::operator > (const DevInputNotifyConnectionStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DevInputNotifyConnectionStart::clear() {
    clearDeviceType();
    clearDeviceConnectStatus();
    clearDeviceName();
}

inline void DevInputNotifyConnectionStart::clearDeviceType() {
    if (hasDeviceType()) {
         clear_has_DeviceType();
        _DeviceType = ::input_main_fi_types::T_e8_Device__DTY_BTA;
     }
}

inline bool DevInputNotifyConnectionStart::hasDeviceType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::input_main_fi_types::T_e8_Device DevInputNotifyConnectionStart::getDeviceType () const {
    return _DeviceType;
}

inline void DevInputNotifyConnectionStart::setDeviceType (::input_main_fi_types::T_e8_Device DeviceType_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_Device_IsValid(DeviceType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceType_, "T_e8_Device", "DeviceType", "DevInputNotifyConnectionStart");
    }
    #endif
    set_has_DeviceType();
    this->_DeviceType = DeviceType_;
}

inline void DevInputNotifyConnectionStart::clearDeviceConnectStatus() {
    if (hasDeviceConnectStatus()) {
         clear_has_DeviceConnectStatus();
        _DeviceConnectStatus = ::input_main_fi_types::T_e8_DeviceConnectStatus__USB_DEV_CONNECTED;
     }
}

inline bool DevInputNotifyConnectionStart::hasDeviceConnectStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::input_main_fi_types::T_e8_DeviceConnectStatus DevInputNotifyConnectionStart::getDeviceConnectStatus () const {
    return _DeviceConnectStatus;
}

inline void DevInputNotifyConnectionStart::setDeviceConnectStatus (::input_main_fi_types::T_e8_DeviceConnectStatus DeviceConnectStatus_) {
    #ifndef NDEBUG
    if (!(::input_main_fi_types::T_e8_DeviceConnectStatus_IsValid(DeviceConnectStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", DeviceConnectStatus_, "T_e8_DeviceConnectStatus", "DeviceConnectStatus", "DevInputNotifyConnectionStart");
    }
    #endif
    set_has_DeviceConnectStatus();
    this->_DeviceConnectStatus = DeviceConnectStatus_;
}

inline void DevInputNotifyConnectionStart::clearDeviceName() {
    if (hasDeviceName()) {
         clear_has_DeviceName();
        _DeviceName.clear();
     }
}

inline bool DevInputNotifyConnectionStart::hasDeviceName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& DevInputNotifyConnectionStart::getDeviceName () const {
    return _DeviceName;
}

inline ::std::string& DevInputNotifyConnectionStart::getDeviceNameMutable () {
    set_has_DeviceName();
    return _DeviceName;
}

inline void DevInputNotifyConnectionStart::setDeviceName (const ::std::string& DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName = DeviceName_;
}

inline void DevInputNotifyConnectionStart::setDeviceName (const char* DeviceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (DeviceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(DeviceName_);
}

inline void DevInputNotifyConnectionStart::setDeviceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_DeviceName();
    this->_DeviceName.assign(value, size);
}

inline void DevInputNotifyConnectionStart::set_has_DeviceType () {
    _has_bits_[0] |= 1u << 0;
}

inline void DevInputNotifyConnectionStart::clear_has_DeviceType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DevInputNotifyConnectionStart::set_has_DeviceConnectStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void DevInputNotifyConnectionStart::clear_has_DeviceConnectStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DevInputNotifyConnectionStart::set_has_DeviceName () {
    _has_bits_[0] |= 1u << 2;
}

inline void DevInputNotifyConnectionStart::clear_has_DeviceName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SimulatePIVITouchSlideStart::SimulatePIVITouchSlideStart ()  :
    _s32XStart (0),
    _s32YStart (0),
    _s32XEnd (0),
    _s32YEnd (0),
    _u16Duration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SimulatePIVITouchSlideStart::SimulatePIVITouchSlideStart (const SimulatePIVITouchSlideStart &rhs)  :
    ::asf::core::Payload(rhs),
    _s32XStart (0),
    _s32YStart (0),
    _s32XEnd (0),
    _s32YEnd (0),
    _u16Duration (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SimulatePIVITouchSlideStart::SimulatePIVITouchSlideStart (int32 s32XStart_, int32 s32YStart_, int32 s32XEnd_, int32 s32YEnd_, uint16 u16Duration_)  :
    _s32XStart (s32XStart_),
    _s32YStart (s32YStart_),
    _s32XEnd (s32XEnd_),
    _s32YEnd (s32YEnd_),
    _u16Duration (u16Duration_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SimulatePIVITouchSlideStart::~SimulatePIVITouchSlideStart() {
}

inline SimulatePIVITouchSlideStart& SimulatePIVITouchSlideStart::operator = (const SimulatePIVITouchSlideStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasS32XStart()) {
            setS32XStart(rhs.getS32XStart());
        } else {
            clearS32XStart();
        }
        if (rhs.hasS32YStart()) {
            setS32YStart(rhs.getS32YStart());
        } else {
            clearS32YStart();
        }
        if (rhs.hasS32XEnd()) {
            setS32XEnd(rhs.getS32XEnd());
        } else {
            clearS32XEnd();
        }
        if (rhs.hasS32YEnd()) {
            setS32YEnd(rhs.getS32YEnd());
        } else {
            clearS32YEnd();
        }
        if (rhs.hasU16Duration()) {
            setU16Duration(rhs.getU16Duration());
        } else {
            clearU16Duration();
        }
    }
    return *this;
}

inline bool SimulatePIVITouchSlideStart::operator == (const SimulatePIVITouchSlideStart& rhs) const {
    return (((!hasS32XStart() && !rhs.hasS32XStart()) || getS32XStart() == rhs.getS32XStart()) &&
        ((!hasS32YStart() && !rhs.hasS32YStart()) || getS32YStart() == rhs.getS32YStart()) &&
        ((!hasS32XEnd() && !rhs.hasS32XEnd()) || getS32XEnd() == rhs.getS32XEnd()) &&
        ((!hasS32YEnd() && !rhs.hasS32YEnd()) || getS32YEnd() == rhs.getS32YEnd()) &&
        ((!hasU16Duration() && !rhs.hasU16Duration()) || getU16Duration() == rhs.getU16Duration()));
}

inline bool SimulatePIVITouchSlideStart::operator != (const SimulatePIVITouchSlideStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SimulatePIVITouchSlideStart::operator < (const SimulatePIVITouchSlideStart& rhs) const {
    if (hasS32XStart() || rhs.hasS32XStart()) {
        if (getS32XStart() < rhs.getS32XStart()) return true;
        if (getS32XStart() > rhs.getS32XStart()) return false;
    }
    if (hasS32YStart() || rhs.hasS32YStart()) {
        if (getS32YStart() < rhs.getS32YStart()) return true;
        if (getS32YStart() > rhs.getS32YStart()) return false;
    }
    if (hasS32XEnd() || rhs.hasS32XEnd()) {
        if (getS32XEnd() < rhs.getS32XEnd()) return true;
        if (getS32XEnd() > rhs.getS32XEnd()) return false;
    }
    if (hasS32YEnd() || rhs.hasS32YEnd()) {
        if (getS32YEnd() < rhs.getS32YEnd()) return true;
        if (getS32YEnd() > rhs.getS32YEnd()) return false;
    }
    if (hasU16Duration() || rhs.hasU16Duration()) {
        if (getU16Duration() < rhs.getU16Duration()) return true;
        if (getU16Duration() > rhs.getU16Duration()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SimulatePIVITouchSlideStart::clone() {
    return new SimulatePIVITouchSlideStart(*this);
}

inline bool SimulatePIVITouchSlideStart::operator > (const SimulatePIVITouchSlideStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SimulatePIVITouchSlideStart::clear() {
    clearS32XStart();
    clearS32YStart();
    clearS32XEnd();
    clearS32YEnd();
    clearU16Duration();
}

inline void SimulatePIVITouchSlideStart::clearS32XStart() {
    if (hasS32XStart()) {
         clear_has_s32XStart();
        _s32XStart = 0;
     }
}

inline bool SimulatePIVITouchSlideStart::hasS32XStart () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 SimulatePIVITouchSlideStart::getS32XStart () const {
    return _s32XStart;
}

inline void SimulatePIVITouchSlideStart::setS32XStart (int32 s32XStart_) {
    set_has_s32XStart();
    this->_s32XStart = s32XStart_;
}

inline void SimulatePIVITouchSlideStart::clearS32YStart() {
    if (hasS32YStart()) {
         clear_has_s32YStart();
        _s32YStart = 0;
     }
}

inline bool SimulatePIVITouchSlideStart::hasS32YStart () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline int32 SimulatePIVITouchSlideStart::getS32YStart () const {
    return _s32YStart;
}

inline void SimulatePIVITouchSlideStart::setS32YStart (int32 s32YStart_) {
    set_has_s32YStart();
    this->_s32YStart = s32YStart_;
}

inline void SimulatePIVITouchSlideStart::clearS32XEnd() {
    if (hasS32XEnd()) {
         clear_has_s32XEnd();
        _s32XEnd = 0;
     }
}

inline bool SimulatePIVITouchSlideStart::hasS32XEnd () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline int32 SimulatePIVITouchSlideStart::getS32XEnd () const {
    return _s32XEnd;
}

inline void SimulatePIVITouchSlideStart::setS32XEnd (int32 s32XEnd_) {
    set_has_s32XEnd();
    this->_s32XEnd = s32XEnd_;
}

inline void SimulatePIVITouchSlideStart::clearS32YEnd() {
    if (hasS32YEnd()) {
         clear_has_s32YEnd();
        _s32YEnd = 0;
     }
}

inline bool SimulatePIVITouchSlideStart::hasS32YEnd () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline int32 SimulatePIVITouchSlideStart::getS32YEnd () const {
    return _s32YEnd;
}

inline void SimulatePIVITouchSlideStart::setS32YEnd (int32 s32YEnd_) {
    set_has_s32YEnd();
    this->_s32YEnd = s32YEnd_;
}

inline void SimulatePIVITouchSlideStart::clearU16Duration() {
    if (hasU16Duration()) {
         clear_has_u16Duration();
        _u16Duration = 0u;
     }
}

inline bool SimulatePIVITouchSlideStart::hasU16Duration () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 SimulatePIVITouchSlideStart::getU16Duration () const {
    return _u16Duration;
}

inline void SimulatePIVITouchSlideStart::setU16Duration (uint16 u16Duration_) {
    set_has_u16Duration();
    this->_u16Duration = u16Duration_;
}

inline void SimulatePIVITouchSlideStart::set_has_s32XStart () {
    _has_bits_[0] |= 1u << 0;
}

inline void SimulatePIVITouchSlideStart::clear_has_s32XStart () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SimulatePIVITouchSlideStart::set_has_s32YStart () {
    _has_bits_[0] |= 1u << 1;
}

inline void SimulatePIVITouchSlideStart::clear_has_s32YStart () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SimulatePIVITouchSlideStart::set_has_s32XEnd () {
    _has_bits_[0] |= 1u << 2;
}

inline void SimulatePIVITouchSlideStart::clear_has_s32XEnd () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SimulatePIVITouchSlideStart::set_has_s32YEnd () {
    _has_bits_[0] |= 1u << 3;
}

inline void SimulatePIVITouchSlideStart::clear_has_s32YEnd () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void SimulatePIVITouchSlideStart::set_has_u16Duration () {
    _has_bits_[0] |= 1u << 4;
}

inline void SimulatePIVITouchSlideStart::clear_has_u16Duration () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace input_main_fi

#endif // INPUT_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
