/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/cca/DefaultTypesCca.h"
#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/stream/MemoryStream.h"
#include "asf/threading/Guard.h"
#include "heatctrl_main_fiCca.h"
#include "heatctrl_main_fiJson.h"
#include "heatctrl_main_fiProxy.h"
#include "heatctrl_main_fi_types.h"

#include "asf/cca/CcaMessage.h"
#include "asf/cca/CcaProxyDelegate.h"
#include "asf/cca/CcaProxyRegistry.h"

namespace heatctrl_main_fi {

/*static*/ ::asf::core::Logger Heatctrl_main_fiProxy::_logger ("/heatctrl_main_fi/Heatctrl_main_fiProxy");


class Heatctrl_main_fiProxyCallback : public ::asf::cca::CcaProxyCallback {
public:

    Heatctrl_main_fiProxyCallback(uint16 functionId, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, void* callback) :
        ::asf::cca::CcaProxyCallback (functionId, opCode, (reinterpret_cast<act_t>(this)), callback)
    {}

    bool processMessage (::asf::cca::CcaMessage &message) {
        if (message.getHeader().getExtension().getField() == ::asf::cca::CcaTypes::CcaMessageExtension::E_SERVICE_DATA) {
            if (message.getHeader().getExtension().getServiceData().getFunctionId() == _functionId) {
                ::boost::shared_ptr<Heatctrl_main_fiProxy> proxy = ::boost::static_pointer_cast<Heatctrl_main_fiProxy>(message.getProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                switch (_functionId) {
                    case FID_FI_FC_HEATCTRL_DEFAULT: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__MethodResult: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::FI_FC_HEATCTRL_DEFAULTResult);
                                setActAndLogResult(message, "FI_FC_HEATCTRL_DEFAULT", reinterpret_cast<act_t>(this), _logger);
                                ((FI_FC_HEATCTRL_DEFAULTCallbackIF*) _callback)->onFI_FC_HEATCTRL_DEFAULTResult (proxy, ::boost::static_pointer_cast<FI_FC_HEATCTRL_DEFAULTResult>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::FI_FC_HEATCTRL_DEFAULTError);
                                setActAndLogError(message, "FI_FC_HEATCTRL_DEFAULT", reinterpret_cast<act_t>(this), _logger);
                                ((FI_FC_HEATCTRL_DEFAULTCallbackIF*) _callback)->onFI_FC_HEATCTRL_DEFAULTError (proxy, ::boost::static_pointer_cast<FI_FC_HEATCTRL_DEFAULTError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RealSensorTemperatures: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::RealSensorTemperaturesStatus);
                                setActAndLogStatus(message, "RealSensorTemperatures", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RealSensorTemperaturesStatus> payload = ::boost::static_pointer_cast<RealSensorTemperaturesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RealSensorTemperaturesStatus >& refNullableStatus = proxy->_realSensorTemperatures;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RealSensorTemperaturesCallbackIF*) _callback)->onRealSensorTemperaturesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RealSensorTemperaturesCallbackIF*) _callback)->onRealSensorTemperaturesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::RealSensorTemperaturesError);
                                setActAndLogError(message, "RealSensorTemperatures", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RealSensorTemperaturesCallbackIF*) _callback)->onRealSensorTemperaturesError(proxy, ::boost::static_pointer_cast<RealSensorTemperaturesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_RealSensorStates: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::RealSensorStatesStatus);
                                setActAndLogStatus(message, "RealSensorStates", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<RealSensorStatesStatus> payload = ::boost::static_pointer_cast<RealSensorStatesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< RealSensorStatesStatus >& refNullableStatus = proxy->_realSensorStates;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((RealSensorStatesCallbackIF*) _callback)->onRealSensorStatesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RealSensorStatesCallbackIF*) _callback)->onRealSensorStatesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::RealSensorStatesError);
                                setActAndLogError(message, "RealSensorStates", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((RealSensorStatesCallbackIF*) _callback)->onRealSensorStatesError(proxy, ::boost::static_pointer_cast<RealSensorStatesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AbstractSensorTemperatures: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::AbstractSensorTemperaturesStatus);
                                setActAndLogStatus(message, "AbstractSensorTemperatures", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AbstractSensorTemperaturesStatus> payload = ::boost::static_pointer_cast<AbstractSensorTemperaturesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AbstractSensorTemperaturesStatus >& refNullableStatus = proxy->_abstractSensorTemperatures;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AbstractSensorTemperaturesCallbackIF*) _callback)->onAbstractSensorTemperaturesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AbstractSensorTemperaturesCallbackIF*) _callback)->onAbstractSensorTemperaturesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::AbstractSensorTemperaturesError);
                                setActAndLogError(message, "AbstractSensorTemperatures", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AbstractSensorTemperaturesCallbackIF*) _callback)->onAbstractSensorTemperaturesError(proxy, ::boost::static_pointer_cast<AbstractSensorTemperaturesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_AbstractSensorStates: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::AbstractSensorStatesStatus);
                                setActAndLogStatus(message, "AbstractSensorStates", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<AbstractSensorStatesStatus> payload = ::boost::static_pointer_cast<AbstractSensorStatesStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< AbstractSensorStatesStatus >& refNullableStatus = proxy->_abstractSensorStates;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((AbstractSensorStatesCallbackIF*) _callback)->onAbstractSensorStatesStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AbstractSensorStatesCallbackIF*) _callback)->onAbstractSensorStatesStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::AbstractSensorStatesError);
                                setActAndLogError(message, "AbstractSensorStates", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((AbstractSensorStatesCallbackIF*) _callback)->onAbstractSensorStatesError(proxy, ::boost::static_pointer_cast<AbstractSensorStatesError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_EmergencyFunctions: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::EmergencyFunctionsStatus);
                                setActAndLogStatus(message, "EmergencyFunctions", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<EmergencyFunctionsStatus> payload = ::boost::static_pointer_cast<EmergencyFunctionsStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< EmergencyFunctionsStatus >& refNullableStatus = proxy->_emergencyFunctions;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((EmergencyFunctionsCallbackIF*) _callback)->onEmergencyFunctionsStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EmergencyFunctionsCallbackIF*) _callback)->onEmergencyFunctionsStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::EmergencyFunctionsError);
                                setActAndLogError(message, "EmergencyFunctions", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    {
                                        ((EmergencyFunctionsCallbackIF*) _callback)->onEmergencyFunctionsError(proxy, ::boost::static_pointer_cast<EmergencyFunctionsError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    case FID_FANControl: {
                        switch (message.getHeader().getExtension().getServiceData().getOpCode()) {
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Status: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::FANControlStatus);
                                setActAndLogStatus(message, "FANControl", reinterpret_cast<act_t>(this), _logger);
                                ::boost::shared_ptr<FANControlStatus> payload = ::boost::static_pointer_cast<FANControlStatus>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg: {
                                        // invoke the callback
                                        ::asf::core::nullable< FANControlStatus >& refNullableStatus = proxy->_fANControl;
                                        if( refNullableStatus.hasValue() == false || message.isLoopBack() == false || refNullableStatus.get() == *payload.get() ) {
                                            ((FANControlCallbackIF*) _callback)->onFANControlStatus(proxy, payload);
                                            refNullableStatus = *payload.get();
                                        }
                                        return false;
                                    }
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((FANControlCallbackIF*) _callback)->onFANControlStatus(proxy, payload);
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case ::asf::cca::CcaTypes::ServiceData::OpCode__Error: {
                                INIT_CCA_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ::heatctrl_main_fi::FANControlError);
                                setActAndLogError(message, "FANControl", reinterpret_cast<act_t>(this), _logger);
                                switch (_opCode) {
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                                    {
                                        ((FANControlCallbackIF*) _callback)->onFANControlError(proxy, ::boost::static_pointer_cast<FANControlError>(message.getPayload())); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                                        return true;
                                    }
                                    default:
                                        break;
                                }
                                return true;
                            }
                            default:
                                break;
                        }
                        break;
                    }
                    default:
                        break;
                }
            }
            LOG_FATAL ("Can't process service data message, commandCounter %u belongs to functionId %u, but message has functionId %u (opcode '%s')",
                message.getHeader().getExtension().getServiceData().getCommandCounter(),
                _functionId,
                message.getHeader().getExtension().getServiceData().getFunctionId(),
                ServiceData_OpCode_Name(message.getHeader().getExtension().getServiceData().getOpCode()));
            return false;
        }
        LOG_FATAL("Can't process message of type: %d", message.getHeader().getExtension().getField());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy>& baseProxy) {
        ::boost::shared_ptr<Heatctrl_main_fiProxy> proxy = ::boost::static_pointer_cast<Heatctrl_main_fiProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case FID_FI_FC_HEATCTRL_DEFAULT: {
                ::boost::shared_ptr< FI_FC_HEATCTRL_DEFAULTError > payload (new FI_FC_HEATCTRL_DEFAULTError());
                payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                payload->setAct(reinterpret_cast<act_t>(this));
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FI_FC_HEATCTRL_DEFAULT", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }
                ((FI_FC_HEATCTRL_DEFAULTCallbackIF*) _callback)->onFI_FC_HEATCTRL_DEFAULTError (proxy, payload);
                return true;
            }
            case FID_RealSensorTemperatures: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< RealSensorTemperaturesError > payload (new RealSensorTemperaturesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RealSensorTemperatures", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RealSensorTemperaturesCallbackIF*) _callback)->onRealSensorTemperaturesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_RealSensorStates: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< RealSensorStatesError > payload (new RealSensorStatesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RealSensorStates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((RealSensorStatesCallbackIF*) _callback)->onRealSensorStatesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AbstractSensorTemperatures: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AbstractSensorTemperaturesError > payload (new AbstractSensorTemperaturesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbstractSensorTemperatures", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AbstractSensorTemperaturesCallbackIF*) _callback)->onAbstractSensorTemperaturesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_AbstractSensorStates: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< AbstractSensorStatesError > payload (new AbstractSensorStatesError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AbstractSensorStates", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((AbstractSensorStatesCallbackIF*) _callback)->onAbstractSensorStatesError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_EmergencyFunctions: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    {
                        ::boost::shared_ptr< EmergencyFunctionsError > payload (new EmergencyFunctionsError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "EmergencyFunctions", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((EmergencyFunctionsCallbackIF*) _callback)->onEmergencyFunctionsError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            case FID_FANControl: {
                switch (_opCode) {
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__UpReg:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Get:
                    case ::asf::cca::CcaTypes::ServiceData::OpCode__Set:
                    {
                        ::boost::shared_ptr< FANControlError > payload (new FANControlError());
                        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
                        payload->setAct(reinterpret_cast<act_t>(this));
                        if (IS_LOG_INFO_ENABLED()) {
                            LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FANControl", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                            std::string jsonPayload;
                            serializeJson(*payload,jsonPayload);
                            LOG_INFO("payload: %s", jsonPayload.c_str());
                        }
                        ((FANControlCallbackIF*) _callback)->onFANControlError (proxy, payload);
                        return true;
                    }
                    default:
                        break;
                }
                return true;
            }
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Heatctrl_main_fiProxyCallback::_logger (Heatctrl_main_fiProxy::_logger);

/*static*/ ::boost::shared_ptr< Heatctrl_main_fiProxy > Heatctrl_main_fiProxy::createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Heatctrl_main_fiProxy >  proxyNew(new Heatctrl_main_fiProxy(portName, 0, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, 0, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Heatctrl_main_fiProxy > Heatctrl_main_fiProxy::createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) {
        ::boost::shared_ptr< Heatctrl_main_fiProxy >  proxyNew(new Heatctrl_main_fiProxy(portName, appId, majorVersion, minorVersion, serviceAvailable, flags));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew, appId, majorVersion, minorVersion, flags);
        return proxyNew;
    }

/*static*/ ::boost::shared_ptr< Heatctrl_main_fiProxy > Heatctrl_main_fiProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::boost::shared_ptr< Proxy > proxyReuse = ::asf::cca::CcaProxyRegistry::getInstance().getProxy(portName, serviceAvailable);
        if(proxyReuse) {
            LOG_INFO_STATIC ("createProxy, reuse existing proxy");
            return ::boost::static_pointer_cast<Heatctrl_main_fiProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        }
        // create new proxy object
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< Heatctrl_main_fiProxy >  proxyNew(new Heatctrl_main_fiProxy(portName, 0, 0, 0, serviceAvailable, 0));
        ::asf::cca::CcaProxyRegistry::getInstance().registerProxy(proxyNew->_ccaProxyDelegate, proxyNew);
        return proxyNew;
    }

Heatctrl_main_fiProxy::Heatctrl_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags) :
    ::asf::cca::CcaProxy(portName, appId, SERVICE_ID, majorVersion, minorVersion, serviceAvailable, _logger, flags) {
}

Heatctrl_main_fiProxy::~Heatctrl_main_fiProxy()
{
    LOG_INFO ("Entering ~Heatctrl_main_fiProxy");
    sendRelUpRegAll ();
}

act_t Heatctrl_main_fiProxy::sendFI_FC_HEATCTRL_DEFAULTStart(FI_FC_HEATCTRL_DEFAULTCallbackIF& cb, uint8 defaultSettingsGroup, uint8 defaultSettingsMode) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__MethodStart, FID_FI_FC_HEATCTRL_DEFAULT);
        ::boost::shared_ptr< FI_FC_HEATCTRL_DEFAULTStart > payload (new FI_FC_HEATCTRL_DEFAULTStart());
        payload->setDefaultSettingsGroup(defaultSettingsGroup);
        payload->setDefaultSettingsMode(defaultSettingsMode);
        CCA_MESSAGE(ccaMessage,header,FI_FC_HEATCTRL_DEFAULTStart,payload)
        return _ccaProxyDelegate->sendMethodStartMessage (ccaMessage, "FI_FC_HEATCTRL_DEFAULT", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FI_FC_HEATCTRL_DEFAULT);
        ::boost::shared_ptr< FI_FC_HEATCTRL_DEFAULTError > payload (new FI_FC_HEATCTRL_DEFAULTError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FI_FC_HEATCTRL_DEFAULTError,payload)
        return _ccaProxyDelegate->sendLoopBackMethodStart (ccaMessage, "FI_FC_HEATCTRL_DEFAULT", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendRealSensorTemperaturesUpReg(RealSensorTemperaturesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RealSensorTemperatures);
        ::boost::shared_ptr< RealSensorTemperaturesUpReg > payload (new RealSensorTemperaturesUpReg());
        CCA_MESSAGE(ccaMessage,header,RealSensorTemperaturesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RealSensorTemperaturesRelUpReg > payloadRelUpRegHeap (new RealSensorTemperaturesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RealSensorTemperatures, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::heatctrl_main_fi::RealSensorTemperaturesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RealSensorTemperatures, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RealSensorTemperatures", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RealSensorTemperatures", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRealSensorTemperatures()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RealSensorTemperatures, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RealSensorTemperaturesStatus > payloadLoopback (new RealSensorTemperaturesStatus(getRealSensorTemperatures()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RealSensorTemperaturesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RealSensorTemperatures);
        ::boost::shared_ptr< RealSensorTemperaturesError > payload (new RealSensorTemperaturesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RealSensorTemperaturesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RealSensorTemperatures", &cb);
    }
}

bool Heatctrl_main_fiProxy::sendRealSensorTemperaturesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RealSensorTemperatures,"RealSensorTemperatures");
}

void Heatctrl_main_fiProxy::sendRealSensorTemperaturesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RealSensorTemperatures);
}

const RealSensorTemperaturesStatus& Heatctrl_main_fiProxy::getRealSensorTemperatures() const {
    return _realSensorTemperatures.get();
}

bool Heatctrl_main_fiProxy::hasRealSensorTemperatures() const {
    return _realSensorTemperatures.hasValue();
}

act_t Heatctrl_main_fiProxy::sendRealSensorTemperaturesGet(RealSensorTemperaturesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RealSensorTemperatures);
        ::boost::shared_ptr< RealSensorTemperaturesGet > payload (new RealSensorTemperaturesGet());
        CCA_MESSAGE(ccaMessage,header,RealSensorTemperaturesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RealSensorTemperatures", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RealSensorTemperatures);
        ::boost::shared_ptr< RealSensorTemperaturesError > payload (new RealSensorTemperaturesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RealSensorTemperaturesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RealSensorTemperatures", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendRealSensorStatesUpReg(RealSensorStatesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_RealSensorStates);
        ::boost::shared_ptr< RealSensorStatesUpReg > payload (new RealSensorStatesUpReg());
        CCA_MESSAGE(ccaMessage,header,RealSensorStatesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< RealSensorStatesRelUpReg > payloadRelUpRegHeap (new RealSensorStatesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_RealSensorStates, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::heatctrl_main_fi::RealSensorStatesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_RealSensorStates, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "RealSensorStates", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "RealSensorStates", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasRealSensorStates()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_RealSensorStates, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< RealSensorStatesStatus > payloadLoopback (new RealSensorStatesStatus(getRealSensorStates()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,RealSensorStatesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RealSensorStates);
        ::boost::shared_ptr< RealSensorStatesError > payload (new RealSensorStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RealSensorStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "RealSensorStates", &cb);
    }
}

bool Heatctrl_main_fiProxy::sendRealSensorStatesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_RealSensorStates,"RealSensorStates");
}

void Heatctrl_main_fiProxy::sendRealSensorStatesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_RealSensorStates);
}

const RealSensorStatesStatus& Heatctrl_main_fiProxy::getRealSensorStates() const {
    return _realSensorStates.get();
}

bool Heatctrl_main_fiProxy::hasRealSensorStates() const {
    return _realSensorStates.hasValue();
}

act_t Heatctrl_main_fiProxy::sendRealSensorStatesGet(RealSensorStatesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_RealSensorStates);
        ::boost::shared_ptr< RealSensorStatesGet > payload (new RealSensorStatesGet());
        CCA_MESSAGE(ccaMessage,header,RealSensorStatesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "RealSensorStates", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_RealSensorStates);
        ::boost::shared_ptr< RealSensorStatesError > payload (new RealSensorStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,RealSensorStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "RealSensorStates", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendAbstractSensorTemperaturesUpReg(AbstractSensorTemperaturesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AbstractSensorTemperatures);
        ::boost::shared_ptr< AbstractSensorTemperaturesUpReg > payload (new AbstractSensorTemperaturesUpReg());
        CCA_MESSAGE(ccaMessage,header,AbstractSensorTemperaturesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AbstractSensorTemperaturesRelUpReg > payloadRelUpRegHeap (new AbstractSensorTemperaturesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AbstractSensorTemperatures, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::heatctrl_main_fi::AbstractSensorTemperaturesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AbstractSensorTemperatures, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AbstractSensorTemperatures", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AbstractSensorTemperatures", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAbstractSensorTemperatures()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AbstractSensorTemperatures, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AbstractSensorTemperaturesStatus > payloadLoopback (new AbstractSensorTemperaturesStatus(getAbstractSensorTemperatures()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AbstractSensorTemperaturesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbstractSensorTemperatures);
        ::boost::shared_ptr< AbstractSensorTemperaturesError > payload (new AbstractSensorTemperaturesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbstractSensorTemperaturesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AbstractSensorTemperatures", &cb);
    }
}

bool Heatctrl_main_fiProxy::sendAbstractSensorTemperaturesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AbstractSensorTemperatures,"AbstractSensorTemperatures");
}

void Heatctrl_main_fiProxy::sendAbstractSensorTemperaturesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AbstractSensorTemperatures);
}

const AbstractSensorTemperaturesStatus& Heatctrl_main_fiProxy::getAbstractSensorTemperatures() const {
    return _abstractSensorTemperatures.get();
}

bool Heatctrl_main_fiProxy::hasAbstractSensorTemperatures() const {
    return _abstractSensorTemperatures.hasValue();
}

act_t Heatctrl_main_fiProxy::sendAbstractSensorTemperaturesGet(AbstractSensorTemperaturesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AbstractSensorTemperatures);
        ::boost::shared_ptr< AbstractSensorTemperaturesGet > payload (new AbstractSensorTemperaturesGet());
        CCA_MESSAGE(ccaMessage,header,AbstractSensorTemperaturesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AbstractSensorTemperatures", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbstractSensorTemperatures);
        ::boost::shared_ptr< AbstractSensorTemperaturesError > payload (new AbstractSensorTemperaturesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbstractSensorTemperaturesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AbstractSensorTemperatures", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendAbstractSensorStatesUpReg(AbstractSensorStatesCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_AbstractSensorStates);
        ::boost::shared_ptr< AbstractSensorStatesUpReg > payload (new AbstractSensorStatesUpReg());
        CCA_MESSAGE(ccaMessage,header,AbstractSensorStatesUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< AbstractSensorStatesRelUpReg > payloadRelUpRegHeap (new AbstractSensorStatesRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_AbstractSensorStates, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::heatctrl_main_fi::AbstractSensorStatesRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_AbstractSensorStates, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "AbstractSensorStates", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "AbstractSensorStates", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasAbstractSensorStates()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_AbstractSensorStates, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< AbstractSensorStatesStatus > payloadLoopback (new AbstractSensorStatesStatus(getAbstractSensorStates()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,AbstractSensorStatesStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbstractSensorStates);
        ::boost::shared_ptr< AbstractSensorStatesError > payload (new AbstractSensorStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbstractSensorStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "AbstractSensorStates", &cb);
    }
}

bool Heatctrl_main_fiProxy::sendAbstractSensorStatesRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_AbstractSensorStates,"AbstractSensorStates");
}

void Heatctrl_main_fiProxy::sendAbstractSensorStatesRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_AbstractSensorStates);
}

const AbstractSensorStatesStatus& Heatctrl_main_fiProxy::getAbstractSensorStates() const {
    return _abstractSensorStates.get();
}

bool Heatctrl_main_fiProxy::hasAbstractSensorStates() const {
    return _abstractSensorStates.hasValue();
}

act_t Heatctrl_main_fiProxy::sendAbstractSensorStatesGet(AbstractSensorStatesCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_AbstractSensorStates);
        ::boost::shared_ptr< AbstractSensorStatesGet > payload (new AbstractSensorStatesGet());
        CCA_MESSAGE(ccaMessage,header,AbstractSensorStatesGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "AbstractSensorStates", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_AbstractSensorStates);
        ::boost::shared_ptr< AbstractSensorStatesError > payload (new AbstractSensorStatesError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,AbstractSensorStatesError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "AbstractSensorStates", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendEmergencyFunctionsUpReg(EmergencyFunctionsCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_EmergencyFunctions);
        ::boost::shared_ptr< EmergencyFunctionsUpReg > payload (new EmergencyFunctionsUpReg());
        CCA_MESSAGE(ccaMessage,header,EmergencyFunctionsUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< EmergencyFunctionsRelUpReg > payloadRelUpRegHeap (new EmergencyFunctionsRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_EmergencyFunctions, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::heatctrl_main_fi::EmergencyFunctionsRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_EmergencyFunctions, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "EmergencyFunctions", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "EmergencyFunctions", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasEmergencyFunctions()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_EmergencyFunctions, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< EmergencyFunctionsStatus > payloadLoopback (new EmergencyFunctionsStatus(getEmergencyFunctions()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,EmergencyFunctionsStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EmergencyFunctions);
        ::boost::shared_ptr< EmergencyFunctionsError > payload (new EmergencyFunctionsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EmergencyFunctionsError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "EmergencyFunctions", &cb);
    }
}

bool Heatctrl_main_fiProxy::sendEmergencyFunctionsRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_EmergencyFunctions,"EmergencyFunctions");
}

void Heatctrl_main_fiProxy::sendEmergencyFunctionsRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_EmergencyFunctions);
}

const EmergencyFunctionsStatus& Heatctrl_main_fiProxy::getEmergencyFunctions() const {
    return _emergencyFunctions.get();
}

bool Heatctrl_main_fiProxy::hasEmergencyFunctions() const {
    return _emergencyFunctions.hasValue();
}

act_t Heatctrl_main_fiProxy::sendEmergencyFunctionsGet(EmergencyFunctionsCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_EmergencyFunctions);
        ::boost::shared_ptr< EmergencyFunctionsGet > payload (new EmergencyFunctionsGet());
        CCA_MESSAGE(ccaMessage,header,EmergencyFunctionsGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "EmergencyFunctions", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_EmergencyFunctions);
        ::boost::shared_ptr< EmergencyFunctionsError > payload (new EmergencyFunctionsError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,EmergencyFunctionsError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "EmergencyFunctions", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendFANControlUpReg(FANControlCallbackIF& cb) {
    ::asf::threading::Guard < ::asf::threading::Mutex > guard(_ccaProxyDelegate->getLock());

    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        // prepare UpReg message
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__UpReg, FID_FANControl);
        ::boost::shared_ptr< FANControlUpReg > payload (new FANControlUpReg());
        CCA_MESSAGE(ccaMessage,header,FANControlUpReg,payload)

        // Create a RelUpReg message for later use
        // The ASF CCA proxy ignores the Status sent by the CCA server to an RelUpReg.
        // RelUpReg is used as fire and forget message by the ASF CCA proxy. If the special command counter token is 0
        // it is not used for dispatching a status message from the CCA server to a callback later.
        ::boost::shared_ptr< FANControlRelUpReg > payloadRelUpRegHeap (new FANControlRelUpReg());
        ::asf::cca::CcaTypes::CcaMessageHeader *relUpRegHeader = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__RelUpReg, FID_FANControl, 0u);
        ::boost::shared_ptr< ::asf::cca::CcaMessage > relUpRegMessage (new ::asf::cca::CcaMessage(::boost::shared_ptr< ::asf::cca::CcaTypes::CcaMessageHeader >(relUpRegHeader), _ccaProxyDelegate));
        INIT_CCA_PAYLOAD_DECORATOR_FOR_SERIALIZATION((*relUpRegMessage.get()).getPayloadDecorator(), ::heatctrl_main_fi::FANControlRelUpReg, payloadRelUpRegHeap);

        // check if a registration for this property already exists with the same payload (register options)
        if (!_ccaProxyDelegate->upRegAlreadySent(FID_FANControl, *payloadRelUpRegHeap)) {
            // no previous registration exists, send a UpReg message to the CCA server
            return _ccaProxyDelegate->sendUpRegMessage (ccaMessage, "FANControl", &cb, relUpRegMessage);
        } else {
            // a previous registration exists, add a new callback to get status updates in future
            ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback = _ccaProxyDelegate->addAdditionalStatusCallback (ccaMessage, payloadRelUpRegHeap, "FANControl", relUpRegMessage, &cb);

            // check if the propertyValue was already received before
            if (hasFANControl()) {
                // we already have the property value, send a loop back message to simulate a status message from the server
                ::asf::cca::CcaTypes::CcaMessageHeader *headerStatus = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Status, FID_FANControl, header->getExtension().getServiceData().getCommandCounter());
                ::boost::shared_ptr< FANControlStatus > payloadLoopback (new FANControlStatus(getFANControl()));
                CCA_LOOPBACK_MESSAGE(ccaMessageLoopback,headerStatus,FANControlStatus,payloadLoopback)
                _ccaProxyDelegate->sendStatusLoopBack (ccaMessageLoopback, callback);
            } else {
                // do nothing as a status message from another UpReg is pending
            }
            return _ccaProxyDelegate->callback2act (callback);
        }
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FANControl);
        ::boost::shared_ptr< FANControlError > payload (new FANControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FANControlError,payload)
        return _ccaProxyDelegate->sendLoopBackUpReg (ccaMessage, "FANControl", &cb);
    }
}

bool Heatctrl_main_fiProxy::sendFANControlRelUpReg(act_t act) {
    return _ccaProxyDelegate->sendRelUpReg(act, FID_FANControl,"FANControl");
}

void Heatctrl_main_fiProxy::sendFANControlRelUpRegAll()
{
    _ccaProxyDelegate->sendRelUpRegForFunctionId(FID_FANControl);
}

const FANControlStatus& Heatctrl_main_fiProxy::getFANControl() const {
    return _fANControl.get();
}

bool Heatctrl_main_fiProxy::hasFANControl() const {
    return _fANControl.hasValue();
}

act_t Heatctrl_main_fiProxy::sendFANControlGet(FANControlCallbackIF& cb) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Get, FID_FANControl);
        ::boost::shared_ptr< FANControlGet > payload (new FANControlGet());
        CCA_MESSAGE(ccaMessage,header,FANControlGet,payload)
        return _ccaProxyDelegate->sendGetMessage (ccaMessage, "FANControl", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FANControl);
        ::boost::shared_ptr< FANControlError > payload (new FANControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FANControlError,payload)
        return _ccaProxyDelegate->sendLoopBackGet (ccaMessage, "FANControl", &cb);
    }
}

act_t Heatctrl_main_fiProxy::sendFANControlSet(FANControlCallbackIF& cb, const ::heatctrl_main_fi_types::T_FANReq& fAN, const ::heatctrl_main_fi_types::T_FANCtrlReq& fANCtrl) {
    if (_ccaProxyDelegate->_state == ::asf::cca::CcaTypes::ProxyState__ServiceAvailable) {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Set, FID_FANControl);
        ::boost::shared_ptr< FANControlSet > payload (new FANControlSet());
        payload->setFAN(fAN);
        payload->setFANCtrl(fANCtrl);
        CCA_MESSAGE(ccaMessage,header,FANControlSet,payload)
        return _ccaProxyDelegate->sendSetMessage (ccaMessage, "FANControl", &cb);
    } else {
        ::asf::cca::CcaTypes::CcaMessageHeader *header = _ccaProxyDelegate->createCcaServiceDataReplyHeader (::asf::cca::CcaTypes::ServiceData::OpCode__Error, FID_FANControl);
        ::boost::shared_ptr< FANControlError > payload (new FANControlError());
        payload->setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable);
        CCA_LOOPBACK_MESSAGE(ccaMessage,header,FANControlError,payload)
        return _ccaProxyDelegate->sendLoopBackSet (ccaMessage, "FANControl", &cb);
    }
}


void Heatctrl_main_fiProxy::clearAllProperties ()
{
    _realSensorTemperatures = ::asf::core::nullable<RealSensorTemperaturesStatus>();
    _realSensorStates = ::asf::core::nullable<RealSensorStatesStatus>();
    _abstractSensorTemperatures = ::asf::core::nullable<AbstractSensorTemperaturesStatus>();
    _abstractSensorStates = ::asf::core::nullable<AbstractSensorStatesStatus>();
    _emergencyFunctions = ::asf::core::nullable<EmergencyFunctionsStatus>();
    _fANControl = ::asf::core::nullable<FANControlStatus>();
}

void Heatctrl_main_fiProxy::sendRelUpRegAll()
{
    sendRealSensorTemperaturesRelUpRegAll();
    sendRealSensorStatesRelUpRegAll();
    sendAbstractSensorTemperaturesRelUpRegAll();
    sendAbstractSensorStatesRelUpRegAll();
    sendEmergencyFunctionsRelUpRegAll();
    sendFANControlRelUpRegAll();
}

::boost::shared_ptr< ::asf::cca::CcaProxyCallback > Heatctrl_main_fiProxy::createCallback(uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb)
{
     ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > callback(new Heatctrl_main_fiProxyCallback(fid, opCode, cb));
     _ccaProxyDelegate->addCallback (commandCounter, callback);
    return callback;
}

} // namespace heatctrl_main_fi
