/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef COM_BOSCH_CM_DUMM_DUMMSERVICESTUB_H
#define COM_BOSCH_CM_DUMM_DUMMSERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/dumm/DummService.h"
#include "com/bosch/cm/dumm/DummServiceConst.h"
#include <string>

namespace com {
namespace bosch {
namespace cm {
namespace dumm {
namespace DummService {

class DummServiceStubDelegate;

class DummServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DummServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DummServiceStub (const std::string& portName);

    /**
     * Create an instance of the DummServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DummServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~DummServiceStub();

    // signal 'mqttConnectionStatus'

    /**
     * Raise the signal 'mqttConnectionStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'mqttConnectionStatus'</b>:
     *
     * Signal to inform MQTT connection status change
     *
     * @param connectionStatus If the meaning of "connectionStatus" isn't clear, then there should be a description here.
     */
    void sendMqttConnectionStatusSignal(ConnectionStatus connectionStatus);

    // signal 'requestStateChanged'

    /**
     * Raise the signal 'requestStateChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'requestStateChanged'</b>:
     *
     * Signal to inform request status change
     * 		TODO: Need to avoid broadcasting update of a request to all the clients
     *
     * @param requestInfo If the meaning of "requestInfo" isn't clear, then there should be a description here.
     */
    void sendRequestStateChangedSignal(const RequestInfo& requestInfo);

    // signal 'serviceActivationAcknowledged'

    /**
     * Raise the signal 'serviceActivationAcknowledged' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'serviceActivationAcknowledged'</b>:
     *
     * Signal to inform ServiceActivationAck
     *
     * @param jsonDownloadHeader Sample jsonDownloadHeader
     * 			{
     * 				"CorrelationId":"2fff6fa91f414229b829e4f612f79a27",
     * 				"UserId":"Renault",
     * 				"Token":"12345"
     * 			}
     *
     * 		  CorrelationId [Optional] - This is optional. If present, clients must send this in the response message to this request.
     * 		  UserId [Optional] - User ID.
     * 		  Token [Optional] - Access Token.
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"ServiceActivation/Data/Status":"KO",
     * 				"ServiceActivation/Data/ErrorCode":2
     * 			}
     */
    void sendServiceActivationAcknowledgedSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'remoteDataWipeReceived'

    /**
     * Raise the signal 'remoteDataWipeReceived' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'remoteDataWipeReceived'</b>:
     *
     * Signal to inform DataWipe
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     */
    void sendRemoteDataWipeReceivedSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'pushMessageReceived'

    /**
     * Raise the signal 'pushMessageReceived' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'pushMessageReceived'</b>:
     *
     * Signal to inform PushMessage received
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessage/Data/messageIdentifier":"0",
     * 				"PushMessage/Data/b2bSender":"0",
     * 				"PushMessage/Data/serviceSender":"PushMessageManager",
     * 				"PushMessage/Data/userDependent":"0",
     * 				"PushMessage/Data/userIdentifier":"0",
     * 				"PushMessage/Data/messageType":"0",
     * 				"PushMessage/Data/domain":"Assistance",
     * 				"PushMessage/Data/intent":"inform",
     * 				"PushMessage/Data/maximumLifetime":"2419200",
     * 				"PushMessage/Data/textLine1":"Information",
     * 				"PushMessage/Data/textLine2":"",
     * 				"PushMessage/Data/actionButtonNumber":"0",
     * 				"PushMessage/Data/actionButton1":"Accept",
     * 				"PushMessage/Data/actionButton1Description":"",
     * 				"PushMessage/Data/actionButton1Semantics":"OK",
     * 				"PushMessage/Data/actionButton2":"",
     * 				"PushMessage/Data/actionButton2Description":"",
     * 				"PushMessage/Data/actionButton2Semantics":"",
     * 				"PushMessage/Data/targetedApplication":"Navi",
     * 				"PushMessage/Data/invokedFunction":"guideTo",
     * 				"PushMessage/Data/parameterList":"",
     * 				"PushMessage/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessage/Data/pictureType":"URL",
     * 				"PushMessage/Data/feedbackRequired":"true",
     * 				"PushMessage/Data/HMI_template_ID":"0",
     * 				"PushMessage/Data/priorityLevel":"50",
     * 				"PushMessage/Data/minPriorityLevel":"0",
     * 				"PushMessage/Data/maxPriorityLevel":"99",
     * 				"PushMessage/Data/preDrivePriority":"50",
     * 				"PushMessage/Data/drivingPriority":"50",
     * 				"PushMessage/Data/notDrivingPriority":"50",
     * 				"PushMessage/Data/postDriverPriority":"50",
     * 				"PushMessage/Data/behaviorWhileDriving":"Driving"
     * 			}
     */
    void sendPushMessageReceivedSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'pushMessageDelete'

    /**
     * Raise the signal 'pushMessageDelete' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'pushMessageDelete'</b>:
     *
     * Signal to inform PushMessageDelete
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageDelete/Data/messageIdentifier":"0",
     * 				"PushMessageDelete/Data/userDependent":"false",
     * 				"PushMessageDelete/Data/userIdentifier":"0"
     * 			}
     */
    void sendPushMessageDeleteSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'pushMessageUpdate'

    /**
     * Raise the signal 'pushMessageUpdate' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'pushMessageUpdate'</b>:
     *
     * Signal to inform PushMessageUpdate
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"PushMessageUpdate/Data/messageIdentifier":"0",
     * 				"PushMessageUpdate/Data/userDependent":"False",
     * 				"PushMessageUpdate/Data/userIdentifier":"0",
     * 				"PushMessageUpdate/Data/intent":"inform",
     * 				"PushMessageUpdate/Data/maximumLifetime":"2419200",
     * 				"PushMessageUpdate/Data/textLine1":"Information",
     * 				"PushMessageUpdate/Data/textLine2":"",
     * 				"PushMessageUpdate/Data/actionButtonNumber":"0",
     * 				"PushMessageUpdate/Data/actionButton1":"Accept",
     * 				"PushMessageUpdate/Data/actionButton1Description":"",
     * 				"PushMessageUpdate/Data/actionButton1Semantics":"OK",
     * 				"PushMessageUpdate/Data/actionButton2":"",
     * 				"PushMessageUpdate/Data/actionButton2Description":"",
     * 				"PushMessageUpdate/Data/actionButton2Semantics":"",
     * 				"PushMessageUpdate/Data/targetedApplication":"Navi",
     * 				"PushMessageUpdate/Data/invokedFunction":"guideTo",
     * 				"PushMessageUpdate/Data/parameterList":"",
     * 				"PushMessageUpdate/Data/picture":"https://www.cdn.renault.com/content/dam/Renault/master/new-logo/renault_french_logo_desktop.png",
     * 				"PushMessageUpdate/Data/pictureType":"URL",
     * 				"PushMessageUpdate/Data/feedback required":"true",
     * 				"PushMessageUpdate/Data/HMI_template_ID":"0",
     * 				"PushMessageUpdate/Data/priorityLevel":"50",
     * 				"PushMessageUpdate/Data/minPriorityLevel":"0",
     * 				"PushMessageUpdate/Data/maxPriorityLevel":"99",
     * 				"PushMessageUpdate/Data/preDrivePriority":"50",
     * 				"PushMessageUpdate/Data/drivingPriority":"50",
     * 				"PushMessageUpdate/Data/notDrivingPriority":"50",
     * 				"PushMessageUpdate/Data/postDriverPriority":"50",
     * 				"PushMessageUpdate/Data/behaviorWhileDriving":"Driving"
     * 			}
     */
    void sendPushMessageUpdateSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'xCALL_POI_Received'

    /**
     * Raise the signal 'xCALL_POI_Received' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'xCALL_POI_Received'</b>:
     *
     * Signal to inform xCALL to alliance_telematics
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param xCallType Refer to XCallType
     *
     * @param jsonDownloadData Sample jsonDownloadData
     */
    void sendXCALL_POI_ReceivedSignal(const ::std::string& jsonDownloadHeader, XCallType xCallType, const ::std::string& jsonDownloadData);

    // signal 'RemoteDataWipe'

    /**
     * Raise the signal 'RemoteDataWipe' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'RemoteDataWipe'</b>:
     *
     * Signal to inform Remote Data Wipe
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"DataWipe/Data/Action":"Wipe"
     * 			}
     */
    void sendRemoteDataWipeSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'profileSyncResponse'

    /**
     * Raise the signal 'profileSyncResponse' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'profileSyncResponse'</b>:
     *
     * Signal to inform ProfileSyncResponse
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"NewSyncTimeStamp":"2018-07-14T19:40:37+0000",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"UserProfile/Custom/MeterLanguageStatus":{
     * 					"val":0,
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				},
     * 				"UserProfile/Custom/MEXModeState":{
     * 					"val":"0",
     * 					"ts":"2018-07-14T19:43:37+123Z"
     * 				}
     * 			}
     */
    void sendProfileSyncResponseSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'profileSyncNeeded'

    /**
     * Raise the signal 'profileSyncNeeded' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'profileSyncNeeded'</b>:
     *
     * Signal to inform ProfileSyncNeeded
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000"
     * 			}
     */
    void sendProfileSyncNeededSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'profileRemoteLinkResponse'

    /**
     * Raise the signal 'profileRemoteLinkResponse' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'profileRemoteLinkResponse'</b>:
     *
     * Signal to inform RemoteLinkResponse
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteLink/Action":"Link",
     * 				"RemoteOrder/Received/UPRemoteLink/CloudSettings":"Yes"
     * 			}
     */
    void sendProfileRemoteLinkResponseSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'profileRemoteReset'

    /**
     * Raise the signal 'profileRemoteReset' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'profileRemoteReset'</b>:
     *
     * Signal to inform RemoteReset
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2018-07-14T19:40:37+123Z",
     * 				"RemoteOrder/Received/UPRemoteReset/Action":"Reset"
     * 			}
     */
    void sendProfileRemoteResetSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'profileLocalLinkAck'

    /**
     * Raise the signal 'profileLocalLinkAck' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'profileLocalLinkAck'</b>:
     *
     * Signal to inform UPLocalLink Ack
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalLink/Status":1,
     * 				"RemoteOrder/Received/ACK/UPLocalLink/CloudSettings":"Yes"
     * 			}
     */
    void sendProfileLocalLinkAckSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'profileLocalUnLinkAck'

    /**
     * Raise the signal 'profileLocalUnLinkAck' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'profileLocalUnLinkAck'</b>:
     *
     * Signal to inform UPLocalUnLink Ack
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2018-07-14T19:40:37+0000",
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/Status":0,
     * 				"RemoteOrder/Received/ACK/UPLocalUnLink/ErrorCode":2
     * 			}
     */
    void sendProfileLocalUnLinkAckSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'EVPresoakAVNextSynchroResp'

    /**
     * Raise the signal 'EVPresoakAVNextSynchroResp' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'EVPresoakAVNextSynchroResp'</b>:
     *
     * Signal to inform EVPresoakAVNextSynchroResp
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/HVAC/Presoak/Calendar1/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar1/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar2/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar2/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar3/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar3/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar4/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar4/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/Calendar5/ActivationState":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalHour":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/ArrivalMinute":0,
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Monday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Tuesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Wednesday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Thursday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Friday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Saturday":"NO",
     * 				"Vehicle/Received/HVAC/PreSoak/Calendar5/Sunday":"NO",
     * 				"Vehicle/Received/HVAC/Presoak/TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Vehicle/Received/HVAC/Presoak/PreSoakTempValue_MMI":23
     * 			}
     */
    void sendEVPresoakAVNextSynchroRespSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'EVPresoakAVNextSynchroNeeded'

    /**
     * Raise the signal 'EVPresoakAVNextSynchroNeeded' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'EVPresoakAVNextSynchroNeeded'</b>:
     *
     * Signal to inform EVPresoakAVNextSynchroNeeded
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     */
    void sendEVPresoakAVNextSynchroNeededSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'EVChargeAVNextSynchroResp'

    /**
     * Raise the signal 'EVChargeAVNextSynchroResp' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'EVChargeAVNextSynchroResp'</b>:
     *
     * Signal to inform EVChargeAVNextSynchroResp
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"NewSyncTimeStamp":"2016-07-27T09:37:14Z",
     * 				"Status":0,
     * 				"ErrorCode":2,
     * 				"Vehicle/Received/EVCharge/ProgrammedStatus":"Always authorized charge",
     * 				"Vehicle/Received/EVCharge/DelayedValue":0,
     * 				"Vehicle/Received/EVCharge/ActivationState1":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour1":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute1":0,
     * 				"Vehicle/Received/EVCharge/Duration1":0,
     * 				"Vehicle/Received/EVCharge/Monday1":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday1":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday1":"NO",
     * 				"Vehicle/Received/EVCharge/Friday1":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday1":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday1":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState2":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour2":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute2":0,
     * 				"Vehicle/Received/EVCharge/Duration2":0,
     * 				"Vehicle/Received/EVCharge/Monday2":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday2":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday2":"NO",
     * 				"Vehicle/Received/EVCharge/Friday2":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday2":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday2":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState3":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour3":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute3":0,
     * 				"Vehicle/Received/EVCharge/Duration3":0,
     * 				"Vehicle/Received/EVCharge/Monday3":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday3":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday3":"NO",
     * 				"Vehicle/Received/EVCharge/Friday3":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday3":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday3":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState4":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour4":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute4":0,
     * 				"Vehicle/Received/EVCharge/Duration4":0,
     * 				"Vehicle/Received/EVCharge/Monday4":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday4":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday4":"NO",
     * 				"Vehicle/Received/EVCharge/Friday4":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday4":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday4":"NO",
     * 				"Vehicle/Received/EVCharge/ActivationState5":"NO",
     * 				"Vehicle/Received/EVCharge/BeginHour5":0,
     * 				"Vehicle/Received/EVCharge/BeginMinute5":0,
     * 				"Vehicle/Received/EVCharge/Duration5":0,
     * 				"Vehicle/Received/EVCharge/Monday5":"NO",
     * 				"Vehicle/Received/EVCharge/Tuesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Wednesday5":"NO",
     * 				"Vehicle/Received/EVCharge/Thursday5":"NO",
     * 				"Vehicle/Received/EVCharge/Friday5":"NO",
     * 				"Vehicle/Received/EVCharge/Saturday5":"NO",
     * 				"Vehicle/Received/EVCharge/Sunday5":"NO"
     *
     * 			}
     */
    void sendEVChargeAVNextSynchroRespSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'EVChargeAVNextSynchroNeeded'

    /**
     * Raise the signal 'EVChargeAVNextSynchroNeeded' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'EVChargeAVNextSynchroNeeded'</b>:
     *
     * Signal to inform EVChargeAVNextSynchroNeeded
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     */
    void sendEVChargeAVNextSynchroNeededSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'remotePushE2E_POIAck'

    /**
     * Raise the signal 'remotePushE2E_POIAck' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'remotePushE2E_POIAck'</b>:
     *
     * Signal to inform E2E_POI Ack
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/POI/Name1":"RN Showroom",
     * 				"E2E/Sent/POI/TTS1":"Hello",
     * 				"E2E/Sent/POI/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber1":"133166363",
     * 				"E2E/Sent/POI/Latitude1":40.7127837,
     * 				"E2E/Sent/POI/Longitude1":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode1":"South",
     * 				"E2E/Sent/POI/LongitudeMode1":"East",
     * 				"E2E/Sent/POI/LocationType1":"Tokyo",
     * 				"E2E/Sent/POI/Name2":"RN Showroom",
     * 				"E2E/Sent/POI/TTS2":"Hello",
     * 				"E2E/Sent/POI/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber2":"133166363",
     * 				"E2E/Sent/POI/Latitude2":40.7127837,
     * 				"E2E/Sent/POI/Longitude2":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode2":"South",
     * 				"E2E/Sent/POI/LongitudeMode2":"East",
     * 				"E2E/Sent/POI/LocationType2":"Tokyo",
     * 				"E2E/Sent/POI/Name3":"RN Showroom",
     * 				"E2E/Sent/POI/TTS3":"Hello",
     * 				"E2E/Sent/POI/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber3":"133166363",
     * 				"E2E/Sent/POI/Latitude3":40.7127837,
     * 				"E2E/Sent/POI/Longitude3":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode3":"South",
     * 				"E2E/Sent/POI/LongitudeMode3":"East",
     * 				"E2E/Sent/POI/LocationType3":"Tokyo",
     * 				"E2E/Sent/POI/Name4":"RN Showroom",
     * 				"E2E/Sent/POI/TTS4":"Hello",
     * 				"E2E/Sent/POI/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber4":"133166363",
     * 				"E2E/Sent/POI/Latitude4":40.7127837,
     * 				"E2E/Sent/POI/Longitude4":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode4":"South",
     * 				"E2E/Sent/POI/LongitudeMode4":"East",
     * 				"E2E/Sent/POI/LocationType4":"Tokyo",
     * 				"E2E/Sent/POI/Name5":"RN Showroom",
     * 				"E2E/Sent/POI/TTS5":"Hello",
     * 				"E2E/Sent/POI/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber5":"133166363",
     * 				"E2E/Sent/POI/Latitude5":40.7127837,
     * 				"E2E/Sent/POI/Longitude5":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode5":"South",
     * 				"E2E/Sent/POI/LongitudeMode5":"East",
     * 				"E2E/Sent/POI/LocationType5":"Tokyo",
     * 				"E2E/Sent/POI/Name6":"RN Showroom",
     * 				"E2E/Sent/POI/TTS6":"Hello",
     * 				"E2E/Sent/POI/Address6":"Renault Nissan Techno Center",
     * 				"E2E/Sent/POI/PhoneNumber6":"133166363",
     * 				"E2E/Sent/POI/Latitude6":40.7127837,
     * 				"E2E/Sent/POI/Longitude6":-74.0059413,
     * 				"E2E/Sent/POI/LatitudeMode6":"South",
     * 				"E2E/Sent/POI/LongitudeMode6":"East",
     * 				"E2E/Sent/POI/LocationType6":"Tokyo"
     * 			}
     */
    void sendRemotePushE2E_POIAckSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'remotePushE2E_Destination'

    /**
     * Raise the signal 'remotePushE2E_Destination' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'remotePushE2E_Destination'</b>:
     *
     * Signal to inform remotePush E2E_Destination
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"E2E/Sent/Destination/DownloadTrafficInfo":"Yes",
     * 				"E2E/Sent/Destination/Name1":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS1":"Hello",
     * 				"E2E/Sent/Destination/Address1":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber1":"133166363",
     * 				"E2E/Sent/Destination/Latitude1":40.7127837,
     * 				"E2E/Sent/Destination/Longitude1":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode1":"South",
     * 				"E2E/Sent/Destination/LongitudeMode1":"East",
     * 				"E2E/Sent/Destination/LocationType1":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition1":"EcoRoute",
     * 				"E2E/Sent/Destination/Name2":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS2":"Hello",
     * 				"E2E/Sent/Destination/Address2":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber2":"133166363",
     * 				"E2E/Sent/Destination/Latitude2":40.7127837,
     * 				"E2E/Sent/Destination/Longitude2":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode2":"South",
     * 				"E2E/Sent/Destination/LongitudeMode2":"East",
     * 				"E2E/Sent/Destination/LocationType2":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition2":"EcoRoute",
     * 				"E2E/Sent/Destination/Name3":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS3":"Hello",
     * 				"E2E/Sent/Destination/Address3":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber3":"133166363",
     * 				"E2E/Sent/Destination/Latitude3":40.7127837,
     * 				"E2E/Sent/Destination/Longitude3":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode3":"South",
     * 				"E2E/Sent/Destination/LongitudeMode3":"East",
     * 				"E2E/Sent/Destination/LocationType3":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition3":"EcoRoute",
     * 				"E2E/Sent/Destination/Name4":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS4":"Hello",
     * 				"E2E/Sent/Destination/Address4":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber4":"133166363",
     * 				"E2E/Sent/Destination/Latitude4":40.7127837,
     * 				"E2E/Sent/Destination/Longitude4":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode4":"South",
     * 				"E2E/Sent/Destination/LongitudeMode4":"East",
     * 				"E2E/Sent/Destination/LocationType4":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition4":"EcoRoute",
     * 				"E2E/Sent/Destination/Name5":"RN Showroom",
     * 				"E2E/Sent/Destination/TTS5":"Hello",
     * 				"E2E/Sent/Destination/Address5":"Renault Nissan Techno Center",
     * 				"E2E/Sent/Destination/PhoneNumber5":"133166363",
     * 				"E2E/Sent/Destination/Latitude5":40.7127837,
     * 				"E2E/Sent/Destination/Longitude5":-74.0059413,
     * 				"E2E/Sent/Destination/LatitudeMode5":"South",
     * 				"E2E/Sent/Destination/LongitudeMode5":"East",
     * 				"E2E/Sent/Destination/LocationType5":"Tokyo",
     * 				"E2E/Sent/Destination/CalculationCondition5":"EcoRoute"
     * 			}
     */
    void sendRemotePushE2E_DestinationSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'ManagedApps_RemoteOrder'

    /**
     * Raise the signal 'ManagedApps_RemoteOrder' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'ManagedApps_RemoteOrder'</b>:
     *
     * Signal to inform Remote Order Managed Apps
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     *
     * 			}
     */
    void sendManagedApps_RemoteOrderSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'ManagedApps_RemoteRequest'

    /**
     * Raise the signal 'ManagedApps_RemoteRequest' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'ManagedApps_RemoteRequest'</b>:
     *
     * Signal to inform Remote Request Managed Apps
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps/Received/RemoteRequest/Parameters":"0"
     * 			}
     */
    void sendManagedApps_RemoteRequestSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'ManagedApps_RemoteSetting'

    /**
     * Raise the signal 'ManagedApps_RemoteSetting' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'ManagedApps_RemoteSetting'</b>:
     *
     * Signal to inform Remote Setting Managed Apps
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 				"ManagedApps_[1..20]/Received/RemoteSetting/Parameters":"values"
     * 			}
     */
    void sendManagedApps_RemoteSettingSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'VPALogs'

    /**
     * Raise the signal 'VPALogs' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'VPALogs'</b>:
     *
     * Signal to inform VPALogs
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     */
    void sendVPALogsSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'VPATelemetry'

    /**
     * Raise the signal 'VPATelemetry' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'VPATelemetry'</b>:
     *
     * Signal to inform VPATelemetry
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z"
     * 			}
     */
    void sendVPATelemetrySignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'ValetMode'

    /**
     * Raise the signal 'ValetMode' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'ValetMode'</b>:
     *
     * Signal to inform ValetMode
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"Version":"1",
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"ValetMode/Received/RemoteOrder/Action":"1"
     *
     * 			}
     */
    void sendValetModeSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'LogActivation'

    /**
     * Raise the signal 'LogActivation' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LogActivation'</b>:
     *
     * Signal to inform LogActivation
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteOrder/LogType":"0",
     * 				"Log/Received/RemoteOrder/Command":"0",
     * 				"Log/Received/RemoteOrder/ComponentName":"1",
     * 				"Log/Received/RemoteOrder/LogLevel":"T",
     * 				"Log/Received/RemoteOrder/LogId":"1",
     * 				"Log/Received/RemoteOrder/StartDate":"0",
     * 				"Log/Received/RemoteOrder/EndDate":"0"
     *
     * 			}
     */
    void sendLogActivationSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'LogRequest'

    /**
     * Raise the signal 'LogRequest' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'LogRequest'</b>:
     *
     * Signal to inform LogRequest
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteRequest/LogType":"0",
     * 				"Log/Received/RemoteRequest/ComponentName":"VPA",
     * 				"Log/Received/RemoteRequest/LogLevel":"T",
     * 				"Log/Received/RemoteRequest/LogBufferClean":"0"
     * 			}
     */
    void sendLogRequestSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'LogTune'

    /**
     * Raise the signal 'LogTune' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'LogTune'</b>:
     *
     * Signal to inform LogTune
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogId":0,
     * 				"Log/Received/RemoteSetting/LogBody":"0",
     * 				"Log/Received/RemoteSetting/LogTriggers":"periodic",
     * 				"Log/Received/RemoteSetting/LogPriority":"1",
     * 				"Log/Received/RemoteSetting/LogCategory":"1",
     * 				"Log/Received/RemoteSetting/LogGatheringPeriodicity":0,
     * 				"Log/Received/RemoteSetting/LogSendingPeriodicity":0,
     * 				"Log/Received/RemoteSetting/StartDate":"0",
     * 				"Log/Received/RemoteSetting/EndDate":"0"
     * 			}
     */
    void sendLogTuneSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'LogSetProbeVerbosity'

    /**
     * Raise the signal 'LogSetProbeVerbosity' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LogSetProbeVerbosity'</b>:
     *
     * Signal to inform LogSetProbeVerbosity
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityId":"0",
     * 				"Log/Received/RemoteSetting/LogSetProbeVerbosityFreq":"0"
     * 			}
     */
    void sendLogSetProbeVerbositySignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'LogSetSLogBufferSize'

    /**
     * Raise the signal 'LogSetSLogBufferSize' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LogSetSLogBufferSize'</b>:
     *
     * Signal to inform LogSetSLogBufferSize
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogBufferName":"0",
     * 				"Log/Received/RemoteSetting/LogBufferSize":"0"
     * 			}
     */
    void sendLogSetSLogBufferSizeSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'LogSetDefaultLogConfig'

    /**
     * Raise the signal 'LogSetDefaultLogConfig' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LogSetDefaultLogConfig'</b>:
     *
     * Signal to inform LogSetDefaultLogConfig
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"Log/Received/RemoteSetting/LogConfigFile":"0"
     * 			}
     */
    void sendLogSetDefaultLogConfigSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'MapInstallRequestACK'

    /**
     * Raise the signal 'MapInstallRequestACK' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'MapInstallRequestACK'</b>:
     *
     * Signal to inform Navigation - Map Install Request ACK
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     */
    void sendMapInstallRequestACKSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // signal 'MapInstallStatusRequestACK'

    /**
     * Raise the signal 'MapInstallStatusRequestACK' and send an update
     * message to registered clients.
     *
     * <b>Documentation of 'MapInstallStatusRequestACK'</b>:
     *
     * Signal to inform Navigation - Map Install Status Request ACK
     *
     * @param jsonDownloadHeader Refer to jsonDownloadHeader of serviceActivationAcknowledged
     *
     * @param jsonDownloadData Sample jsonDownloadData
     * 			{
     * 				"TimeStamp":"2016-07-27T09:37:14Z",
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/Status":0,
     * 				"RemoteOrder/Received/ACK/MapInstallRequest/ErrorCode":2
     * 			}
     */
    void sendMapInstallStatusRequestACKSignal(const ::std::string& jsonDownloadHeader, const ::std::string& jsonDownloadData);

    // method 'genCorrelationId'

    /**
     * The method onGenCorrelationId() is called by ASF when a client invokes
     * the method 'genCorrelationId'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGenCorrelationId() or sendGenCorrelationIdError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'genCorrelationId'</b>:
     *
     * Method to generate the correlation Id
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGenCorrelationIdRequest (const ::boost::shared_ptr< GenCorrelationIdRequest >& request) = 0;

    /**
     * The method sendGenCorrelationIdResponse() sends a response of a
     * previous method invocation of 'genCorrelationId' back to the client.
     *
     * <b>Documentation of 'genCorrelationId'</b>:
     *
     * Method to generate the correlation Id
     *
     * @param CorrelationId If the meaning of "CorrelationId" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGenCorrelationId(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGenCorrelationIdResponse (const ::std::string& correlationId, act_t act = 0);

    /**
     * The method sendGenCorrelationIdError() sends an error response of a
     * previous method invocation of 'genCorrelationId' back to the client.
     *
     * <b>Documentation of 'genCorrelationId'</b>:
     *
     * Method to generate the correlation Id
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGenCorrelationId(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGenCorrelationIdError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'uploadData'

    /**
     * The method onUploadData() is called by ASF when a client invokes the
     * method 'uploadData'. A subclass has to implement this method and send
     * back a response to the client either with the sendUploadData() or
     * sendUploadDataError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'uploadData'</b>:
     *
     * Method to upload data
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUploadDataRequest (const ::boost::shared_ptr< UploadDataRequest >& request) = 0;

    /**
     * The method sendUploadDataResponse() sends a response of a previous
     * method invocation of 'uploadData' back to the client.
     *
     * <b>Documentation of 'uploadData'</b>:
     *
     * Method to upload data
     *
     * @param requestInfo If the meaning of "requestInfo" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUploadData(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUploadDataResponse (const RequestInfo& requestInfo, act_t act = 0);

    /**
     * The method sendUploadDataError() sends an error response of a previous
     * method invocation of 'uploadData' back to the client.
     *
     * <b>Documentation of 'uploadData'</b>:
     *
     * Method to upload data
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUploadData(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUploadDataError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'cancelUploadRequest'

    /**
     * The method onCancelUploadRequest() is called by ASF when a client
     * invokes the method 'cancelUploadRequest'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendCancelUploadRequest() or sendCancelUploadRequestError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'cancelUploadRequest'</b>:
     *
     * Method to cancel a upload request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelUploadRequestRequest (const ::boost::shared_ptr< CancelUploadRequestRequest >& request) = 0;

    /**
     * The method sendCancelUploadRequestResponse() sends a response of a
     * previous method invocation of 'cancelUploadRequest' back to the client.
     *
     * <b>Documentation of 'cancelUploadRequest'</b>:
     *
     * Method to cancel a upload request
     *
     * @param outRequestInfo If the meaning of "outRequestInfo" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelUploadRequest(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendCancelUploadRequestResponse (const RequestInfo& outRequestInfo, act_t act = 0);

    /**
     * The method sendCancelUploadRequestError() sends an error response of a
     * previous method invocation of 'cancelUploadRequest' back to the client.
     *
     * <b>Documentation of 'cancelUploadRequest'</b>:
     *
     * Method to cancel a upload request
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelUploadRequest().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelUploadRequestError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'getUploadRequestStatus'

    /**
     * The method onGetUploadRequestStatus() is called by ASF when a client
     * invokes the method 'getUploadRequestStatus'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendGetUploadRequestStatus() or
     * sendGetUploadRequestStatusError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'getUploadRequestStatus'</b>:
     *
     * Method to get the current status of a request
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetUploadRequestStatusRequest (const ::boost::shared_ptr< GetUploadRequestStatusRequest >& request) = 0;

    /**
     * The method sendGetUploadRequestStatusResponse() sends a response of a
     * previous method invocation of 'getUploadRequestStatus' back to the
     * client.
     *
     * <b>Documentation of 'getUploadRequestStatus'</b>:
     *
     * Method to get the current status of a request
     *
     * @param outRequestInfo If the meaning of "outRequestInfo" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetUploadRequestStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetUploadRequestStatusResponse (const RequestInfo& outRequestInfo, act_t act = 0);

    /**
     * The method sendGetUploadRequestStatusError() sends an error response of
     * a previous method invocation of 'getUploadRequestStatus' back to the
     * client.
     *
     * <b>Documentation of 'getUploadRequestStatus'</b>:
     *
     * Method to get the current status of a request
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onGetUploadRequestStatus(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetUploadRequestStatusError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DummServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DummService
} // namespace dumm
} // namespace cm
} // namespace bosch
} // namespace com

#endif // COM_BOSCH_CM_DUMM_DUMMSERVICESTUB_H
