/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/dumm/DummService.h"
#include "com/bosch/cm/dumm/DummServiceDBus.h"
#include "com/bosch/cm/dumm/DummServiceJson.h"
#include "com/bosch/cm/dumm/DummServiceProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace com {
namespace bosch {
namespace cm {
namespace dumm {
namespace DummService {

DEFINE_CLASS_LOGGER("/com/bosch/cm/dumm/com/bosch/cm/dumm/DummService", DummServiceProxy);

class DummServiceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DummServiceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DummServiceProxy >& proxyShared = ::boost::static_pointer_cast< DummServiceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_mqttConnectionStatus:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MqttConnectionStatusSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MqttConnectionStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MqttConnectionStatusSignal> payload = ::boost::static_pointer_cast<MqttConnectionStatusSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MqttConnectionStatusCallbackIF*) _callback)->onMqttConnectionStatusSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_requestStateChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestStateChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RequestStateChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RequestStateChangedSignal> payload = ::boost::static_pointer_cast<RequestStateChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RequestStateChangedCallbackIF*) _callback)->onRequestStateChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_serviceActivationAcknowledged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ServiceActivationAcknowledgedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ServiceActivationAcknowledged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ServiceActivationAcknowledgedSignal> payload = ::boost::static_pointer_cast<ServiceActivationAcknowledgedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ServiceActivationAcknowledgedCallbackIF*) _callback)->onServiceActivationAcknowledgedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_remoteDataWipeReceived:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteDataWipeReceivedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemoteDataWipeReceived", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RemoteDataWipeReceivedSignal> payload = ::boost::static_pointer_cast<RemoteDataWipeReceivedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RemoteDataWipeReceivedCallbackIF*) _callback)->onRemoteDataWipeReceivedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_pushMessageReceived:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PushMessageReceivedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PushMessageReceived", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PushMessageReceivedSignal> payload = ::boost::static_pointer_cast<PushMessageReceivedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PushMessageReceivedCallbackIF*) _callback)->onPushMessageReceivedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_pushMessageDelete:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PushMessageDeleteSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PushMessageDelete", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PushMessageDeleteSignal> payload = ::boost::static_pointer_cast<PushMessageDeleteSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PushMessageDeleteCallbackIF*) _callback)->onPushMessageDeleteSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_pushMessageUpdate:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PushMessageUpdateSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PushMessageUpdate", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PushMessageUpdateSignal> payload = ::boost::static_pointer_cast<PushMessageUpdateSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PushMessageUpdateCallbackIF*) _callback)->onPushMessageUpdateSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_xCALL_POI_Received:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), XCALL_POI_ReceivedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "XCALL_POI_Received", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<XCALL_POI_ReceivedSignal> payload = ::boost::static_pointer_cast<XCALL_POI_ReceivedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((XCALL_POI_ReceivedCallbackIF*) _callback)->onXCALL_POI_ReceivedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_RemoteDataWipe:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoteDataWipeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemoteDataWipe", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RemoteDataWipeSignal> payload = ::boost::static_pointer_cast<RemoteDataWipeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RemoteDataWipeCallbackIF*) _callback)->onRemoteDataWipeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_profileSyncResponse:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileSyncResponseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileSyncResponse", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProfileSyncResponseSignal> payload = ::boost::static_pointer_cast<ProfileSyncResponseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProfileSyncResponseCallbackIF*) _callback)->onProfileSyncResponseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_profileSyncNeeded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileSyncNeededSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileSyncNeeded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProfileSyncNeededSignal> payload = ::boost::static_pointer_cast<ProfileSyncNeededSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProfileSyncNeededCallbackIF*) _callback)->onProfileSyncNeededSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_profileRemoteLinkResponse:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileRemoteLinkResponseSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileRemoteLinkResponse", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProfileRemoteLinkResponseSignal> payload = ::boost::static_pointer_cast<ProfileRemoteLinkResponseSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProfileRemoteLinkResponseCallbackIF*) _callback)->onProfileRemoteLinkResponseSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_profileRemoteReset:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileRemoteResetSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileRemoteReset", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProfileRemoteResetSignal> payload = ::boost::static_pointer_cast<ProfileRemoteResetSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProfileRemoteResetCallbackIF*) _callback)->onProfileRemoteResetSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_profileLocalLinkAck:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileLocalLinkAckSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileLocalLinkAck", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProfileLocalLinkAckSignal> payload = ::boost::static_pointer_cast<ProfileLocalLinkAckSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProfileLocalLinkAckCallbackIF*) _callback)->onProfileLocalLinkAckSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_profileLocalUnLinkAck:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProfileLocalUnLinkAckSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ProfileLocalUnLinkAck", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ProfileLocalUnLinkAckSignal> payload = ::boost::static_pointer_cast<ProfileLocalUnLinkAckSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ProfileLocalUnLinkAckCallbackIF*) _callback)->onProfileLocalUnLinkAckSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EVPresoakAVNextSynchroResp:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EVPresoakAVNextSynchroRespSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EVPresoakAVNextSynchroResp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EVPresoakAVNextSynchroRespSignal> payload = ::boost::static_pointer_cast<EVPresoakAVNextSynchroRespSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EVPresoakAVNextSynchroRespCallbackIF*) _callback)->onEVPresoakAVNextSynchroRespSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EVPresoakAVNextSynchroNeeded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EVPresoakAVNextSynchroNeededSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EVPresoakAVNextSynchroNeeded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EVPresoakAVNextSynchroNeededSignal> payload = ::boost::static_pointer_cast<EVPresoakAVNextSynchroNeededSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EVPresoakAVNextSynchroNeededCallbackIF*) _callback)->onEVPresoakAVNextSynchroNeededSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EVChargeAVNextSynchroResp:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EVChargeAVNextSynchroRespSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EVChargeAVNextSynchroResp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EVChargeAVNextSynchroRespSignal> payload = ::boost::static_pointer_cast<EVChargeAVNextSynchroRespSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EVChargeAVNextSynchroRespCallbackIF*) _callback)->onEVChargeAVNextSynchroRespSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_EVChargeAVNextSynchroNeeded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), EVChargeAVNextSynchroNeededSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "EVChargeAVNextSynchroNeeded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<EVChargeAVNextSynchroNeededSignal> payload = ::boost::static_pointer_cast<EVChargeAVNextSynchroNeededSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((EVChargeAVNextSynchroNeededCallbackIF*) _callback)->onEVChargeAVNextSynchroNeededSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_remotePushE2E_POIAck:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemotePushE2E_POIAckSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemotePushE2E_POIAck", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RemotePushE2E_POIAckSignal> payload = ::boost::static_pointer_cast<RemotePushE2E_POIAckSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RemotePushE2E_POIAckCallbackIF*) _callback)->onRemotePushE2E_POIAckSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_remotePushE2E_Destination:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemotePushE2E_DestinationSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RemotePushE2E_Destination", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<RemotePushE2E_DestinationSignal> payload = ::boost::static_pointer_cast<RemotePushE2E_DestinationSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((RemotePushE2E_DestinationCallbackIF*) _callback)->onRemotePushE2E_DestinationSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ManagedApps_RemoteOrder:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManagedApps_RemoteOrderSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManagedApps_RemoteOrder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ManagedApps_RemoteOrderSignal> payload = ::boost::static_pointer_cast<ManagedApps_RemoteOrderSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ManagedApps_RemoteOrderCallbackIF*) _callback)->onManagedApps_RemoteOrderSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ManagedApps_RemoteRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManagedApps_RemoteRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManagedApps_RemoteRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ManagedApps_RemoteRequestSignal> payload = ::boost::static_pointer_cast<ManagedApps_RemoteRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ManagedApps_RemoteRequestCallbackIF*) _callback)->onManagedApps_RemoteRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ManagedApps_RemoteSetting:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ManagedApps_RemoteSettingSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ManagedApps_RemoteSetting", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ManagedApps_RemoteSettingSignal> payload = ::boost::static_pointer_cast<ManagedApps_RemoteSettingSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ManagedApps_RemoteSettingCallbackIF*) _callback)->onManagedApps_RemoteSettingSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_VPALogs:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VPALogsSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VPALogs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<VPALogsSignal> payload = ::boost::static_pointer_cast<VPALogsSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((VPALogsCallbackIF*) _callback)->onVPALogsSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_VPATelemetry:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VPATelemetrySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "VPATelemetry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<VPATelemetrySignal> payload = ::boost::static_pointer_cast<VPATelemetrySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((VPATelemetryCallbackIF*) _callback)->onVPATelemetrySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_ValetMode:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ValetModeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ValetMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ValetModeSignal> payload = ::boost::static_pointer_cast<ValetModeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ValetModeCallbackIF*) _callback)->onValetModeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LogActivation:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogActivationSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogActivation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LogActivationSignal> payload = ::boost::static_pointer_cast<LogActivationSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LogActivationCallbackIF*) _callback)->onLogActivationSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LogRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LogRequestSignal> payload = ::boost::static_pointer_cast<LogRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LogRequestCallbackIF*) _callback)->onLogRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LogTune:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogTuneSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogTune", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LogTuneSignal> payload = ::boost::static_pointer_cast<LogTuneSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LogTuneCallbackIF*) _callback)->onLogTuneSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LogSetProbeVerbosity:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogSetProbeVerbositySignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogSetProbeVerbosity", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LogSetProbeVerbositySignal> payload = ::boost::static_pointer_cast<LogSetProbeVerbositySignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LogSetProbeVerbosityCallbackIF*) _callback)->onLogSetProbeVerbositySignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LogSetSLogBufferSize:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogSetSLogBufferSizeSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogSetSLogBufferSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LogSetSLogBufferSizeSignal> payload = ::boost::static_pointer_cast<LogSetSLogBufferSizeSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LogSetSLogBufferSizeCallbackIF*) _callback)->onLogSetSLogBufferSizeSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LogSetDefaultLogConfig:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LogSetDefaultLogConfigSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LogSetDefaultLogConfig", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LogSetDefaultLogConfigSignal> payload = ::boost::static_pointer_cast<LogSetDefaultLogConfigSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LogSetDefaultLogConfigCallbackIF*) _callback)->onLogSetDefaultLogConfigSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_MapInstallRequestACK:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapInstallRequestACKSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapInstallRequestACK", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MapInstallRequestACKSignal> payload = ::boost::static_pointer_cast<MapInstallRequestACKSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MapInstallRequestACKCallbackIF*) _callback)->onMapInstallRequestACKSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_MapInstallStatusRequestACK:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MapInstallStatusRequestACKSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "MapInstallStatusRequestACK", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<MapInstallStatusRequestACKSignal> payload = ::boost::static_pointer_cast<MapInstallStatusRequestACKSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((MapInstallStatusRequestACKCallbackIF*) _callback)->onMapInstallStatusRequestACKSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_genCorrelationId:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GenCorrelationIdError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GenCorrelationId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GenCorrelationIdError> payload = ::boost::static_pointer_cast<GenCorrelationIdError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GenCorrelationIdCallbackIF*) _callback)->onGenCorrelationIdError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GenCorrelationIdResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GenCorrelationId", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GenCorrelationIdResponse> payload = ::boost::static_pointer_cast<GenCorrelationIdResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GenCorrelationIdCallbackIF*) _callback)->onGenCorrelationIdResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_uploadData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UploadDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UploadData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UploadDataError> payload = ::boost::static_pointer_cast<UploadDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UploadDataCallbackIF*) _callback)->onUploadDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UploadDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UploadData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UploadDataResponse> payload = ::boost::static_pointer_cast<UploadDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UploadDataCallbackIF*) _callback)->onUploadDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_cancelUploadRequest:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelUploadRequestError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelUploadRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelUploadRequestError> payload = ::boost::static_pointer_cast<CancelUploadRequestError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelUploadRequestCallbackIF*) _callback)->onCancelUploadRequestError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelUploadRequestResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelUploadRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelUploadRequestResponse> payload = ::boost::static_pointer_cast<CancelUploadRequestResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelUploadRequestCallbackIF*) _callback)->onCancelUploadRequestResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_getUploadRequestStatus:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetUploadRequestStatusError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUploadRequestStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUploadRequestStatusError> payload = ::boost::static_pointer_cast<GetUploadRequestStatusError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUploadRequestStatusCallbackIF*) _callback)->onGetUploadRequestStatusError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetUploadRequestStatusResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetUploadRequestStatus", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetUploadRequestStatusResponse> payload = ::boost::static_pointer_cast<GetUploadRequestStatusResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetUploadRequestStatusCallbackIF*) _callback)->onGetUploadRequestStatusResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_mqttConnectionStatus: {
                ::boost::shared_ptr< MqttConnectionStatusError > payload = ::boost::shared_ptr< MqttConnectionStatusError >
                (new MqttConnectionStatusError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MqttConnectionStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MqttConnectionStatusCallbackIF*) _callback)->onMqttConnectionStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_requestStateChanged: {
                ::boost::shared_ptr< RequestStateChangedError > payload = ::boost::shared_ptr< RequestStateChangedError >
                (new RequestStateChangedError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestStateChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestStateChangedCallbackIF*) _callback)->onRequestStateChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_serviceActivationAcknowledged: {
                ::boost::shared_ptr< ServiceActivationAcknowledgedError > payload = ::boost::shared_ptr< ServiceActivationAcknowledgedError >
                (new ServiceActivationAcknowledgedError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ServiceActivationAcknowledged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ServiceActivationAcknowledgedCallbackIF*) _callback)->onServiceActivationAcknowledgedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_remoteDataWipeReceived: {
                ::boost::shared_ptr< RemoteDataWipeReceivedError > payload = ::boost::shared_ptr< RemoteDataWipeReceivedError >
                (new RemoteDataWipeReceivedError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoteDataWipeReceived", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoteDataWipeReceivedCallbackIF*) _callback)->onRemoteDataWipeReceivedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pushMessageReceived: {
                ::boost::shared_ptr< PushMessageReceivedError > payload = ::boost::shared_ptr< PushMessageReceivedError >
                (new PushMessageReceivedError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PushMessageReceived", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PushMessageReceivedCallbackIF*) _callback)->onPushMessageReceivedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pushMessageDelete: {
                ::boost::shared_ptr< PushMessageDeleteError > payload = ::boost::shared_ptr< PushMessageDeleteError >
                (new PushMessageDeleteError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PushMessageDelete", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PushMessageDeleteCallbackIF*) _callback)->onPushMessageDeleteError (proxyShared,payload);
                return true;
            }
            break;
            case ID_pushMessageUpdate: {
                ::boost::shared_ptr< PushMessageUpdateError > payload = ::boost::shared_ptr< PushMessageUpdateError >
                (new PushMessageUpdateError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PushMessageUpdate", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PushMessageUpdateCallbackIF*) _callback)->onPushMessageUpdateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_xCALL_POI_Received: {
                ::boost::shared_ptr< XCALL_POI_ReceivedError > payload = ::boost::shared_ptr< XCALL_POI_ReceivedError >
                (new XCALL_POI_ReceivedError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "XCALL_POI_Received", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((XCALL_POI_ReceivedCallbackIF*) _callback)->onXCALL_POI_ReceivedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoteDataWipe: {
                ::boost::shared_ptr< RemoteDataWipeError > payload = ::boost::shared_ptr< RemoteDataWipeError >
                (new RemoteDataWipeError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoteDataWipe", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoteDataWipeCallbackIF*) _callback)->onRemoteDataWipeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileSyncResponse: {
                ::boost::shared_ptr< ProfileSyncResponseError > payload = ::boost::shared_ptr< ProfileSyncResponseError >
                (new ProfileSyncResponseError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileSyncResponse", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileSyncResponseCallbackIF*) _callback)->onProfileSyncResponseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileSyncNeeded: {
                ::boost::shared_ptr< ProfileSyncNeededError > payload = ::boost::shared_ptr< ProfileSyncNeededError >
                (new ProfileSyncNeededError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileSyncNeeded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileSyncNeededCallbackIF*) _callback)->onProfileSyncNeededError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileRemoteLinkResponse: {
                ::boost::shared_ptr< ProfileRemoteLinkResponseError > payload = ::boost::shared_ptr< ProfileRemoteLinkResponseError >
                (new ProfileRemoteLinkResponseError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileRemoteLinkResponse", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileRemoteLinkResponseCallbackIF*) _callback)->onProfileRemoteLinkResponseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileRemoteReset: {
                ::boost::shared_ptr< ProfileRemoteResetError > payload = ::boost::shared_ptr< ProfileRemoteResetError >
                (new ProfileRemoteResetError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileRemoteReset", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileRemoteResetCallbackIF*) _callback)->onProfileRemoteResetError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileLocalLinkAck: {
                ::boost::shared_ptr< ProfileLocalLinkAckError > payload = ::boost::shared_ptr< ProfileLocalLinkAckError >
                (new ProfileLocalLinkAckError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileLocalLinkAck", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileLocalLinkAckCallbackIF*) _callback)->onProfileLocalLinkAckError (proxyShared,payload);
                return true;
            }
            break;
            case ID_profileLocalUnLinkAck: {
                ::boost::shared_ptr< ProfileLocalUnLinkAckError > payload = ::boost::shared_ptr< ProfileLocalUnLinkAckError >
                (new ProfileLocalUnLinkAckError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ProfileLocalUnLinkAck", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProfileLocalUnLinkAckCallbackIF*) _callback)->onProfileLocalUnLinkAckError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EVPresoakAVNextSynchroResp: {
                ::boost::shared_ptr< EVPresoakAVNextSynchroRespError > payload = ::boost::shared_ptr< EVPresoakAVNextSynchroRespError >
                (new EVPresoakAVNextSynchroRespError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EVPresoakAVNextSynchroResp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EVPresoakAVNextSynchroRespCallbackIF*) _callback)->onEVPresoakAVNextSynchroRespError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EVPresoakAVNextSynchroNeeded: {
                ::boost::shared_ptr< EVPresoakAVNextSynchroNeededError > payload = ::boost::shared_ptr< EVPresoakAVNextSynchroNeededError >
                (new EVPresoakAVNextSynchroNeededError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EVPresoakAVNextSynchroNeeded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EVPresoakAVNextSynchroNeededCallbackIF*) _callback)->onEVPresoakAVNextSynchroNeededError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EVChargeAVNextSynchroResp: {
                ::boost::shared_ptr< EVChargeAVNextSynchroRespError > payload = ::boost::shared_ptr< EVChargeAVNextSynchroRespError >
                (new EVChargeAVNextSynchroRespError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EVChargeAVNextSynchroResp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EVChargeAVNextSynchroRespCallbackIF*) _callback)->onEVChargeAVNextSynchroRespError (proxyShared,payload);
                return true;
            }
            break;
            case ID_EVChargeAVNextSynchroNeeded: {
                ::boost::shared_ptr< EVChargeAVNextSynchroNeededError > payload = ::boost::shared_ptr< EVChargeAVNextSynchroNeededError >
                (new EVChargeAVNextSynchroNeededError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "EVChargeAVNextSynchroNeeded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((EVChargeAVNextSynchroNeededCallbackIF*) _callback)->onEVChargeAVNextSynchroNeededError (proxyShared,payload);
                return true;
            }
            break;
            case ID_remotePushE2E_POIAck: {
                ::boost::shared_ptr< RemotePushE2E_POIAckError > payload = ::boost::shared_ptr< RemotePushE2E_POIAckError >
                (new RemotePushE2E_POIAckError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemotePushE2E_POIAck", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemotePushE2E_POIAckCallbackIF*) _callback)->onRemotePushE2E_POIAckError (proxyShared,payload);
                return true;
            }
            break;
            case ID_remotePushE2E_Destination: {
                ::boost::shared_ptr< RemotePushE2E_DestinationError > payload = ::boost::shared_ptr< RemotePushE2E_DestinationError >
                (new RemotePushE2E_DestinationError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemotePushE2E_Destination", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemotePushE2E_DestinationCallbackIF*) _callback)->onRemotePushE2E_DestinationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ManagedApps_RemoteOrder: {
                ::boost::shared_ptr< ManagedApps_RemoteOrderError > payload = ::boost::shared_ptr< ManagedApps_RemoteOrderError >
                (new ManagedApps_RemoteOrderError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManagedApps_RemoteOrder", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManagedApps_RemoteOrderCallbackIF*) _callback)->onManagedApps_RemoteOrderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ManagedApps_RemoteRequest: {
                ::boost::shared_ptr< ManagedApps_RemoteRequestError > payload = ::boost::shared_ptr< ManagedApps_RemoteRequestError >
                (new ManagedApps_RemoteRequestError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManagedApps_RemoteRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManagedApps_RemoteRequestCallbackIF*) _callback)->onManagedApps_RemoteRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ManagedApps_RemoteSetting: {
                ::boost::shared_ptr< ManagedApps_RemoteSettingError > payload = ::boost::shared_ptr< ManagedApps_RemoteSettingError >
                (new ManagedApps_RemoteSettingError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ManagedApps_RemoteSetting", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ManagedApps_RemoteSettingCallbackIF*) _callback)->onManagedApps_RemoteSettingError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VPALogs: {
                ::boost::shared_ptr< VPALogsError > payload = ::boost::shared_ptr< VPALogsError >
                (new VPALogsError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VPALogs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VPALogsCallbackIF*) _callback)->onVPALogsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_VPATelemetry: {
                ::boost::shared_ptr< VPATelemetryError > payload = ::boost::shared_ptr< VPATelemetryError >
                (new VPATelemetryError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "VPATelemetry", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VPATelemetryCallbackIF*) _callback)->onVPATelemetryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ValetMode: {
                ::boost::shared_ptr< ValetModeError > payload = ::boost::shared_ptr< ValetModeError >
                (new ValetModeError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ValetMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ValetModeCallbackIF*) _callback)->onValetModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogActivation: {
                ::boost::shared_ptr< LogActivationError > payload = ::boost::shared_ptr< LogActivationError >
                (new LogActivationError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogActivation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogActivationCallbackIF*) _callback)->onLogActivationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogRequest: {
                ::boost::shared_ptr< LogRequestError > payload = ::boost::shared_ptr< LogRequestError >
                (new LogRequestError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogRequestCallbackIF*) _callback)->onLogRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogTune: {
                ::boost::shared_ptr< LogTuneError > payload = ::boost::shared_ptr< LogTuneError >
                (new LogTuneError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogTune", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogTuneCallbackIF*) _callback)->onLogTuneError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogSetProbeVerbosity: {
                ::boost::shared_ptr< LogSetProbeVerbosityError > payload = ::boost::shared_ptr< LogSetProbeVerbosityError >
                (new LogSetProbeVerbosityError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogSetProbeVerbosity", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogSetProbeVerbosityCallbackIF*) _callback)->onLogSetProbeVerbosityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogSetSLogBufferSize: {
                ::boost::shared_ptr< LogSetSLogBufferSizeError > payload = ::boost::shared_ptr< LogSetSLogBufferSizeError >
                (new LogSetSLogBufferSizeError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogSetSLogBufferSize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogSetSLogBufferSizeCallbackIF*) _callback)->onLogSetSLogBufferSizeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LogSetDefaultLogConfig: {
                ::boost::shared_ptr< LogSetDefaultLogConfigError > payload = ::boost::shared_ptr< LogSetDefaultLogConfigError >
                (new LogSetDefaultLogConfigError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LogSetDefaultLogConfig", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LogSetDefaultLogConfigCallbackIF*) _callback)->onLogSetDefaultLogConfigError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MapInstallRequestACK: {
                ::boost::shared_ptr< MapInstallRequestACKError > payload = ::boost::shared_ptr< MapInstallRequestACKError >
                (new MapInstallRequestACKError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapInstallRequestACK", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapInstallRequestACKCallbackIF*) _callback)->onMapInstallRequestACKError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MapInstallStatusRequestACK: {
                ::boost::shared_ptr< MapInstallStatusRequestACKError > payload = ::boost::shared_ptr< MapInstallStatusRequestACKError >
                (new MapInstallStatusRequestACKError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MapInstallStatusRequestACK", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MapInstallStatusRequestACKCallbackIF*) _callback)->onMapInstallStatusRequestACKError (proxyShared,payload);
                return true;
            }
            break;
            case ID_genCorrelationId: {
                ::boost::shared_ptr< GenCorrelationIdError > payload = ::boost::shared_ptr< GenCorrelationIdError >
                (new GenCorrelationIdError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GenCorrelationId", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GenCorrelationIdCallbackIF*) _callback)->onGenCorrelationIdError (proxyShared,payload);
                return true;
            }
            break;
            case ID_uploadData: {
                ::boost::shared_ptr< UploadDataError > payload = ::boost::shared_ptr< UploadDataError >
                (new UploadDataError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UploadData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UploadDataCallbackIF*) _callback)->onUploadDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_cancelUploadRequest: {
                ::boost::shared_ptr< CancelUploadRequestError > payload = ::boost::shared_ptr< CancelUploadRequestError >
                (new CancelUploadRequestError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelUploadRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelUploadRequestCallbackIF*) _callback)->onCancelUploadRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_getUploadRequestStatus: {
                ::boost::shared_ptr< GetUploadRequestStatusError > payload = ::boost::shared_ptr< GetUploadRequestStatusError >
                (new GetUploadRequestStatusError(DBUS_ERROR_NO_SERVER, "The DBus service DummService is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetUploadRequestStatus", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DummServiceProxy> proxyShared = ::boost::static_pointer_cast<DummServiceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetUploadRequestStatusCallbackIF*) _callback)->onGetUploadRequestStatusError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DummServiceProxyCallback::_logger (DummServiceProxy::_logger);

DummServiceProxy::DummServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "com.bosch.cm.dumm.DummService", serviceAvailable, _logger) {
}

DummServiceProxy::~DummServiceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DummServiceProxy > DummServiceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DummServiceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DummServiceProxy > proxyNew(new DummServiceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DummServiceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DummServiceProxyCallback* callback = new DummServiceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DummServiceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DummServiceProxyCallback* callback = new DummServiceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void DummServiceProxy::sendDeregisterAll () const
{
    sendMqttConnectionStatusDeregisterAll();
    sendRequestStateChangedDeregisterAll();
    sendServiceActivationAcknowledgedDeregisterAll();
    sendRemoteDataWipeReceivedDeregisterAll();
    sendPushMessageReceivedDeregisterAll();
    sendPushMessageDeleteDeregisterAll();
    sendPushMessageUpdateDeregisterAll();
    sendXCALL_POI_ReceivedDeregisterAll();
    sendRemoteDataWipeDeregisterAll();
    sendProfileSyncResponseDeregisterAll();
    sendProfileSyncNeededDeregisterAll();
    sendProfileRemoteLinkResponseDeregisterAll();
    sendProfileRemoteResetDeregisterAll();
    sendProfileLocalLinkAckDeregisterAll();
    sendProfileLocalUnLinkAckDeregisterAll();
    sendEVPresoakAVNextSynchroRespDeregisterAll();
    sendEVPresoakAVNextSynchroNeededDeregisterAll();
    sendEVChargeAVNextSynchroRespDeregisterAll();
    sendEVChargeAVNextSynchroNeededDeregisterAll();
    sendRemotePushE2E_POIAckDeregisterAll();
    sendRemotePushE2E_DestinationDeregisterAll();
    sendManagedApps_RemoteOrderDeregisterAll();
    sendManagedApps_RemoteRequestDeregisterAll();
    sendManagedApps_RemoteSettingDeregisterAll();
    sendVPALogsDeregisterAll();
    sendVPATelemetryDeregisterAll();
    sendValetModeDeregisterAll();
    sendLogActivationDeregisterAll();
    sendLogRequestDeregisterAll();
    sendLogTuneDeregisterAll();
    sendLogSetProbeVerbosityDeregisterAll();
    sendLogSetSLogBufferSizeDeregisterAll();
    sendLogSetDefaultLogConfigDeregisterAll();
    sendMapInstallRequestACKDeregisterAll();
    sendMapInstallStatusRequestACKDeregisterAll();
}

act_t DummServiceProxy::sendMqttConnectionStatusRegister(MqttConnectionStatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "mqttConnectionStatus");
    act_t act = addSignalCallback(ID_mqttConnectionStatus, "mqttConnectionStatus", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MqttConnectionStatus", &cb, act);
    return act;
}

bool DummServiceProxy::sendMqttConnectionStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("mqttConnectionStatus", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MqttConnectionStatus", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendMqttConnectionStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MqttConnectionStatus");
    _dbusProxyDelegate->deregisterSignalCallback("mqttConnectionStatus", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendRequestStateChangedRegister(RequestStateChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "requestStateChanged");
    act_t act = addSignalCallback(ID_requestStateChanged, "requestStateChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RequestStateChanged", &cb, act);
    return act;
}

bool DummServiceProxy::sendRequestStateChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("requestStateChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RequestStateChanged", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendRequestStateChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RequestStateChanged");
    _dbusProxyDelegate->deregisterSignalCallback("requestStateChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendServiceActivationAcknowledgedRegister(ServiceActivationAcknowledgedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "serviceActivationAcknowledged");
    act_t act = addSignalCallback(ID_serviceActivationAcknowledged, "serviceActivationAcknowledged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ServiceActivationAcknowledged", &cb, act);
    return act;
}

bool DummServiceProxy::sendServiceActivationAcknowledgedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("serviceActivationAcknowledged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ServiceActivationAcknowledged", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendServiceActivationAcknowledgedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ServiceActivationAcknowledged");
    _dbusProxyDelegate->deregisterSignalCallback("serviceActivationAcknowledged", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendRemoteDataWipeReceivedRegister(RemoteDataWipeReceivedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "remoteDataWipeReceived");
    act_t act = addSignalCallback(ID_remoteDataWipeReceived, "remoteDataWipeReceived", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemoteDataWipeReceived", &cb, act);
    return act;
}

bool DummServiceProxy::sendRemoteDataWipeReceivedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("remoteDataWipeReceived", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemoteDataWipeReceived", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendRemoteDataWipeReceivedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemoteDataWipeReceived");
    _dbusProxyDelegate->deregisterSignalCallback("remoteDataWipeReceived", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendPushMessageReceivedRegister(PushMessageReceivedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "pushMessageReceived");
    act_t act = addSignalCallback(ID_pushMessageReceived, "pushMessageReceived", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PushMessageReceived", &cb, act);
    return act;
}

bool DummServiceProxy::sendPushMessageReceivedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("pushMessageReceived", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PushMessageReceived", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendPushMessageReceivedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PushMessageReceived");
    _dbusProxyDelegate->deregisterSignalCallback("pushMessageReceived", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendPushMessageDeleteRegister(PushMessageDeleteCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "pushMessageDelete");
    act_t act = addSignalCallback(ID_pushMessageDelete, "pushMessageDelete", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PushMessageDelete", &cb, act);
    return act;
}

bool DummServiceProxy::sendPushMessageDeleteDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("pushMessageDelete", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PushMessageDelete", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendPushMessageDeleteDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PushMessageDelete");
    _dbusProxyDelegate->deregisterSignalCallback("pushMessageDelete", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendPushMessageUpdateRegister(PushMessageUpdateCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "pushMessageUpdate");
    act_t act = addSignalCallback(ID_pushMessageUpdate, "pushMessageUpdate", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PushMessageUpdate", &cb, act);
    return act;
}

bool DummServiceProxy::sendPushMessageUpdateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("pushMessageUpdate", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PushMessageUpdate", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendPushMessageUpdateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PushMessageUpdate");
    _dbusProxyDelegate->deregisterSignalCallback("pushMessageUpdate", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendXCALL_POI_ReceivedRegister(XCALL_POI_ReceivedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "xCALL_POI_Received");
    act_t act = addSignalCallback(ID_xCALL_POI_Received, "xCALL_POI_Received", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "XCALL_POI_Received", &cb, act);
    return act;
}

bool DummServiceProxy::sendXCALL_POI_ReceivedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("xCALL_POI_Received", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "XCALL_POI_Received", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendXCALL_POI_ReceivedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "XCALL_POI_Received");
    _dbusProxyDelegate->deregisterSignalCallback("xCALL_POI_Received", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendRemoteDataWipeRegister(RemoteDataWipeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "RemoteDataWipe");
    act_t act = addSignalCallback(ID_RemoteDataWipe, "RemoteDataWipe", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemoteDataWipe", &cb, act);
    return act;
}

bool DummServiceProxy::sendRemoteDataWipeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RemoteDataWipe", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemoteDataWipe", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendRemoteDataWipeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemoteDataWipe");
    _dbusProxyDelegate->deregisterSignalCallback("RemoteDataWipe", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendProfileSyncResponseRegister(ProfileSyncResponseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "profileSyncResponse");
    act_t act = addSignalCallback(ID_profileSyncResponse, "profileSyncResponse", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileSyncResponse", &cb, act);
    return act;
}

bool DummServiceProxy::sendProfileSyncResponseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileSyncResponse", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileSyncResponse", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendProfileSyncResponseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileSyncResponse");
    _dbusProxyDelegate->deregisterSignalCallback("profileSyncResponse", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendProfileSyncNeededRegister(ProfileSyncNeededCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "profileSyncNeeded");
    act_t act = addSignalCallback(ID_profileSyncNeeded, "profileSyncNeeded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileSyncNeeded", &cb, act);
    return act;
}

bool DummServiceProxy::sendProfileSyncNeededDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileSyncNeeded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileSyncNeeded", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendProfileSyncNeededDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileSyncNeeded");
    _dbusProxyDelegate->deregisterSignalCallback("profileSyncNeeded", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendProfileRemoteLinkResponseRegister(ProfileRemoteLinkResponseCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "profileRemoteLinkResponse");
    act_t act = addSignalCallback(ID_profileRemoteLinkResponse, "profileRemoteLinkResponse", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileRemoteLinkResponse", &cb, act);
    return act;
}

bool DummServiceProxy::sendProfileRemoteLinkResponseDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileRemoteLinkResponse", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileRemoteLinkResponse", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendProfileRemoteLinkResponseDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileRemoteLinkResponse");
    _dbusProxyDelegate->deregisterSignalCallback("profileRemoteLinkResponse", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendProfileRemoteResetRegister(ProfileRemoteResetCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "profileRemoteReset");
    act_t act = addSignalCallback(ID_profileRemoteReset, "profileRemoteReset", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileRemoteReset", &cb, act);
    return act;
}

bool DummServiceProxy::sendProfileRemoteResetDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileRemoteReset", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileRemoteReset", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendProfileRemoteResetDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileRemoteReset");
    _dbusProxyDelegate->deregisterSignalCallback("profileRemoteReset", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendProfileLocalLinkAckRegister(ProfileLocalLinkAckCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "profileLocalLinkAck");
    act_t act = addSignalCallback(ID_profileLocalLinkAck, "profileLocalLinkAck", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileLocalLinkAck", &cb, act);
    return act;
}

bool DummServiceProxy::sendProfileLocalLinkAckDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileLocalLinkAck", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileLocalLinkAck", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendProfileLocalLinkAckDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileLocalLinkAck");
    _dbusProxyDelegate->deregisterSignalCallback("profileLocalLinkAck", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendProfileLocalUnLinkAckRegister(ProfileLocalUnLinkAckCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "profileLocalUnLinkAck");
    act_t act = addSignalCallback(ID_profileLocalUnLinkAck, "profileLocalUnLinkAck", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ProfileLocalUnLinkAck", &cb, act);
    return act;
}

bool DummServiceProxy::sendProfileLocalUnLinkAckDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("profileLocalUnLinkAck", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ProfileLocalUnLinkAck", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendProfileLocalUnLinkAckDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ProfileLocalUnLinkAck");
    _dbusProxyDelegate->deregisterSignalCallback("profileLocalUnLinkAck", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendEVPresoakAVNextSynchroRespRegister(EVPresoakAVNextSynchroRespCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EVPresoakAVNextSynchroResp");
    act_t act = addSignalCallback(ID_EVPresoakAVNextSynchroResp, "EVPresoakAVNextSynchroResp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EVPresoakAVNextSynchroResp", &cb, act);
    return act;
}

bool DummServiceProxy::sendEVPresoakAVNextSynchroRespDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EVPresoakAVNextSynchroResp", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EVPresoakAVNextSynchroResp", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendEVPresoakAVNextSynchroRespDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EVPresoakAVNextSynchroResp");
    _dbusProxyDelegate->deregisterSignalCallback("EVPresoakAVNextSynchroResp", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendEVPresoakAVNextSynchroNeededRegister(EVPresoakAVNextSynchroNeededCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EVPresoakAVNextSynchroNeeded");
    act_t act = addSignalCallback(ID_EVPresoakAVNextSynchroNeeded, "EVPresoakAVNextSynchroNeeded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EVPresoakAVNextSynchroNeeded", &cb, act);
    return act;
}

bool DummServiceProxy::sendEVPresoakAVNextSynchroNeededDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EVPresoakAVNextSynchroNeeded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EVPresoakAVNextSynchroNeeded", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendEVPresoakAVNextSynchroNeededDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EVPresoakAVNextSynchroNeeded");
    _dbusProxyDelegate->deregisterSignalCallback("EVPresoakAVNextSynchroNeeded", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendEVChargeAVNextSynchroRespRegister(EVChargeAVNextSynchroRespCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EVChargeAVNextSynchroResp");
    act_t act = addSignalCallback(ID_EVChargeAVNextSynchroResp, "EVChargeAVNextSynchroResp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EVChargeAVNextSynchroResp", &cb, act);
    return act;
}

bool DummServiceProxy::sendEVChargeAVNextSynchroRespDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EVChargeAVNextSynchroResp", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EVChargeAVNextSynchroResp", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendEVChargeAVNextSynchroRespDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EVChargeAVNextSynchroResp");
    _dbusProxyDelegate->deregisterSignalCallback("EVChargeAVNextSynchroResp", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendEVChargeAVNextSynchroNeededRegister(EVChargeAVNextSynchroNeededCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "EVChargeAVNextSynchroNeeded");
    act_t act = addSignalCallback(ID_EVChargeAVNextSynchroNeeded, "EVChargeAVNextSynchroNeeded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "EVChargeAVNextSynchroNeeded", &cb, act);
    return act;
}

bool DummServiceProxy::sendEVChargeAVNextSynchroNeededDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("EVChargeAVNextSynchroNeeded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "EVChargeAVNextSynchroNeeded", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendEVChargeAVNextSynchroNeededDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "EVChargeAVNextSynchroNeeded");
    _dbusProxyDelegate->deregisterSignalCallback("EVChargeAVNextSynchroNeeded", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendRemotePushE2E_POIAckRegister(RemotePushE2E_POIAckCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "remotePushE2E_POIAck");
    act_t act = addSignalCallback(ID_remotePushE2E_POIAck, "remotePushE2E_POIAck", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemotePushE2E_POIAck", &cb, act);
    return act;
}

bool DummServiceProxy::sendRemotePushE2E_POIAckDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("remotePushE2E_POIAck", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemotePushE2E_POIAck", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendRemotePushE2E_POIAckDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemotePushE2E_POIAck");
    _dbusProxyDelegate->deregisterSignalCallback("remotePushE2E_POIAck", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendRemotePushE2E_DestinationRegister(RemotePushE2E_DestinationCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "remotePushE2E_Destination");
    act_t act = addSignalCallback(ID_remotePushE2E_Destination, "remotePushE2E_Destination", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RemotePushE2E_Destination", &cb, act);
    return act;
}

bool DummServiceProxy::sendRemotePushE2E_DestinationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("remotePushE2E_Destination", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RemotePushE2E_Destination", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendRemotePushE2E_DestinationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RemotePushE2E_Destination");
    _dbusProxyDelegate->deregisterSignalCallback("remotePushE2E_Destination", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendManagedApps_RemoteOrderRegister(ManagedApps_RemoteOrderCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ManagedApps_RemoteOrder");
    act_t act = addSignalCallback(ID_ManagedApps_RemoteOrder, "ManagedApps_RemoteOrder", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ManagedApps_RemoteOrder", &cb, act);
    return act;
}

bool DummServiceProxy::sendManagedApps_RemoteOrderDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ManagedApps_RemoteOrder", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ManagedApps_RemoteOrder", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendManagedApps_RemoteOrderDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ManagedApps_RemoteOrder");
    _dbusProxyDelegate->deregisterSignalCallback("ManagedApps_RemoteOrder", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendManagedApps_RemoteRequestRegister(ManagedApps_RemoteRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ManagedApps_RemoteRequest");
    act_t act = addSignalCallback(ID_ManagedApps_RemoteRequest, "ManagedApps_RemoteRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ManagedApps_RemoteRequest", &cb, act);
    return act;
}

bool DummServiceProxy::sendManagedApps_RemoteRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ManagedApps_RemoteRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ManagedApps_RemoteRequest", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendManagedApps_RemoteRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ManagedApps_RemoteRequest");
    _dbusProxyDelegate->deregisterSignalCallback("ManagedApps_RemoteRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendManagedApps_RemoteSettingRegister(ManagedApps_RemoteSettingCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ManagedApps_RemoteSetting");
    act_t act = addSignalCallback(ID_ManagedApps_RemoteSetting, "ManagedApps_RemoteSetting", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ManagedApps_RemoteSetting", &cb, act);
    return act;
}

bool DummServiceProxy::sendManagedApps_RemoteSettingDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ManagedApps_RemoteSetting", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ManagedApps_RemoteSetting", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendManagedApps_RemoteSettingDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ManagedApps_RemoteSetting");
    _dbusProxyDelegate->deregisterSignalCallback("ManagedApps_RemoteSetting", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendVPALogsRegister(VPALogsCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "VPALogs");
    act_t act = addSignalCallback(ID_VPALogs, "VPALogs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VPALogs", &cb, act);
    return act;
}

bool DummServiceProxy::sendVPALogsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VPALogs", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VPALogs", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendVPALogsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VPALogs");
    _dbusProxyDelegate->deregisterSignalCallback("VPALogs", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendVPATelemetryRegister(VPATelemetryCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "VPATelemetry");
    act_t act = addSignalCallback(ID_VPATelemetry, "VPATelemetry", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "VPATelemetry", &cb, act);
    return act;
}

bool DummServiceProxy::sendVPATelemetryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("VPATelemetry", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "VPATelemetry", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendVPATelemetryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "VPATelemetry");
    _dbusProxyDelegate->deregisterSignalCallback("VPATelemetry", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendValetModeRegister(ValetModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ValetMode");
    act_t act = addSignalCallback(ID_ValetMode, "ValetMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ValetMode", &cb, act);
    return act;
}

bool DummServiceProxy::sendValetModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ValetMode", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ValetMode", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendValetModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ValetMode");
    _dbusProxyDelegate->deregisterSignalCallback("ValetMode", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendLogActivationRegister(LogActivationCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LogActivation");
    act_t act = addSignalCallback(ID_LogActivation, "LogActivation", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogActivation", &cb, act);
    return act;
}

bool DummServiceProxy::sendLogActivationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogActivation", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogActivation", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendLogActivationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogActivation");
    _dbusProxyDelegate->deregisterSignalCallback("LogActivation", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendLogRequestRegister(LogRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LogRequest");
    act_t act = addSignalCallback(ID_LogRequest, "LogRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogRequest", &cb, act);
    return act;
}

bool DummServiceProxy::sendLogRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogRequest", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendLogRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogRequest");
    _dbusProxyDelegate->deregisterSignalCallback("LogRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendLogTuneRegister(LogTuneCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LogTune");
    act_t act = addSignalCallback(ID_LogTune, "LogTune", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogTune", &cb, act);
    return act;
}

bool DummServiceProxy::sendLogTuneDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogTune", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogTune", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendLogTuneDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogTune");
    _dbusProxyDelegate->deregisterSignalCallback("LogTune", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendLogSetProbeVerbosityRegister(LogSetProbeVerbosityCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LogSetProbeVerbosity");
    act_t act = addSignalCallback(ID_LogSetProbeVerbosity, "LogSetProbeVerbosity", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogSetProbeVerbosity", &cb, act);
    return act;
}

bool DummServiceProxy::sendLogSetProbeVerbosityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogSetProbeVerbosity", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogSetProbeVerbosity", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendLogSetProbeVerbosityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogSetProbeVerbosity");
    _dbusProxyDelegate->deregisterSignalCallback("LogSetProbeVerbosity", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendLogSetSLogBufferSizeRegister(LogSetSLogBufferSizeCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LogSetSLogBufferSize");
    act_t act = addSignalCallback(ID_LogSetSLogBufferSize, "LogSetSLogBufferSize", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogSetSLogBufferSize", &cb, act);
    return act;
}

bool DummServiceProxy::sendLogSetSLogBufferSizeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogSetSLogBufferSize", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogSetSLogBufferSize", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendLogSetSLogBufferSizeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogSetSLogBufferSize");
    _dbusProxyDelegate->deregisterSignalCallback("LogSetSLogBufferSize", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendLogSetDefaultLogConfigRegister(LogSetDefaultLogConfigCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LogSetDefaultLogConfig");
    act_t act = addSignalCallback(ID_LogSetDefaultLogConfig, "LogSetDefaultLogConfig", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LogSetDefaultLogConfig", &cb, act);
    return act;
}

bool DummServiceProxy::sendLogSetDefaultLogConfigDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LogSetDefaultLogConfig", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LogSetDefaultLogConfig", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendLogSetDefaultLogConfigDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LogSetDefaultLogConfig");
    _dbusProxyDelegate->deregisterSignalCallback("LogSetDefaultLogConfig", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendMapInstallRequestACKRegister(MapInstallRequestACKCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "MapInstallRequestACK");
    act_t act = addSignalCallback(ID_MapInstallRequestACK, "MapInstallRequestACK", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapInstallRequestACK", &cb, act);
    return act;
}

bool DummServiceProxy::sendMapInstallRequestACKDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MapInstallRequestACK", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapInstallRequestACK", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendMapInstallRequestACKDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapInstallRequestACK");
    _dbusProxyDelegate->deregisterSignalCallback("MapInstallRequestACK", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendMapInstallStatusRequestACKRegister(MapInstallStatusRequestACKCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "MapInstallStatusRequestACK");
    act_t act = addSignalCallback(ID_MapInstallStatusRequestACK, "MapInstallStatusRequestACK", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "MapInstallStatusRequestACK", &cb, act);
    return act;
}

bool DummServiceProxy::sendMapInstallStatusRequestACKDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("MapInstallStatusRequestACK", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "MapInstallStatusRequestACK", act, static_cast<int>(rv));
    return rv;
}

void DummServiceProxy::sendMapInstallStatusRequestACKDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "MapInstallStatusRequestACK");
    _dbusProxyDelegate->deregisterSignalCallback("MapInstallStatusRequestACK", 0, _dbusDaemonProxy.get(), false);
}

act_t DummServiceProxy::sendGenCorrelationIdRequest(GenCorrelationIdCallbackIF& cb) const {
    GenCorrelationIdRequest* payload = new GenCorrelationIdRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "genCorrelationId", GenCorrelationIdRequest, payload, true)
    act_t act = addMethodCallback(ID_genCorrelationId, dbusMessage.getUniqueSerial(), "genCorrelationId", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GenCorrelationId", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DummServiceProxy::sendUploadDataRequest(UploadDataCallbackIF& cb, const ::std::string& jsonUploadHeader, const ::std::string& jsonUploadData) const {
    UploadDataRequest* payload = new UploadDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setJsonUploadHeader(jsonUploadHeader);
    payload->setJsonUploadData(jsonUploadData);
    DBUS_MESSAGE_CALL(dbusMessage, "uploadData", UploadDataRequest, payload, true)
    act_t act = addMethodCallback(ID_uploadData, dbusMessage.getUniqueSerial(), "uploadData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UploadData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DummServiceProxy::sendCancelUploadRequestRequest(CancelUploadRequestCallbackIF& cb, const ::std::string& correlationId) const {
    CancelUploadRequestRequest* payload = new CancelUploadRequestRequest();
    CHECK_ALLOCATION(payload);
    payload->setCorrelationId(correlationId);
    DBUS_MESSAGE_CALL(dbusMessage, "cancelUploadRequest", CancelUploadRequestRequest, payload, true)
    act_t act = addMethodCallback(ID_cancelUploadRequest, dbusMessage.getUniqueSerial(), "cancelUploadRequest", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelUploadRequest", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DummServiceProxy::sendGetUploadRequestStatusRequest(GetUploadRequestStatusCallbackIF& cb, const ::std::string& correlationId) const {
    GetUploadRequestStatusRequest* payload = new GetUploadRequestStatusRequest();
    CHECK_ALLOCATION(payload);
    payload->setCorrelationId(correlationId);
    DBUS_MESSAGE_CALL(dbusMessage, "getUploadRequestStatus", GetUploadRequestStatusRequest, payload, true)
    act_t act = addMethodCallback(ID_getUploadRequestStatus, dbusMessage.getUniqueSerial(), "getUploadRequestStatus", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetUploadRequestStatus", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DummService
} // namespace dumm
} // namespace cm
} // namespace bosch
} // namespace com
