#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DIAGLOG_MAIN_FI_TYPES_H
#define DIAGLOG_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "diaglog_main_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * Types diaglog_main_fi_types
 */

namespace diaglog_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_FreezeFrameData;

class T_TestResult;

class T_ReadResultStructure;

class T_ITC_Information;

class T_ProductionReadResultStructure;

class T_CustomerReadResultStructure;

class T_SnapshotData;

class T_SnapshotIdentification;

class T_SendNextTestResultStructure;

// type definitions
/**
 * If the meaning of "T_FreezeFrameList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_FreezeFrameData > T_FreezeFrameList;

/**
 * If the meaning of "T_TestResultList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_TestResult > T_TestResultList;

/**
 * If the meaning of "T_ReadRequestBuffer" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ReadRequestBuffer;

/**
 * If the meaning of "T_ReadResultBuffer" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ReadResultBuffer;

/**
 * If the meaning of "T_ReadResultList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_ReadResultStructure > T_ReadResultList;

/**
 * If the meaning of "T_ProductionReadResultList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_ProductionReadResultStructure > T_ProductionReadResultList;

/**
 * If the meaning of "T_CustomerReadResultList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_CustomerReadResultStructure > T_CustomerReadResultList;

/**
 * If the meaning of "T_SnapshotDataList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SnapshotData > T_SnapshotDataList;

/**
 * If the meaning of "T_SnapshotIdentificationList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< T_SnapshotIdentification > T_SnapshotIdentificationList;

/**
 * If the meaning of "T_ClearRequestBuffer" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ClearRequestBuffer;

/**
 * If the meaning of "T_ClearResultBuffer" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint8 > T_ClearResultBuffer;

/**
 * If the meaning of "T_ControlList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_ControlList;

/**
 * If the meaning of "T_ActiveDTCList" isn't clear, then there should be a description here.
 */
typedef ::std::vector< uint32 > T_ActiveDTCList;


/**
 * If the meaning of "T_FreezeFrameData" isn't clear, then there should be a description here.
 */
class T_FreezeFrameData {
public:

    /**
     * Default constructor
     */
    inline  T_FreezeFrameData ();

    /**
     * Copy constructor
     */
    inline  T_FreezeFrameData (const T_FreezeFrameData &rhs);

    /**
     * All fields constructor
     */
    inline  T_FreezeFrameData (uint8 ID_, const ::std::vector< uint8 >& Data_);

    /**
     * Destructor
     */
    inline  ~T_FreezeFrameData();

    /**
     * Assignment operator
     */
    inline T_FreezeFrameData& operator = (const T_FreezeFrameData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_FreezeFrameData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_FreezeFrameData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_FreezeFrameData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_FreezeFrameData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ID"

    static const int kID = 0;

    /**
     * Clears the field "ID".
     *
     * The field will be set to its default value. The hasID()
     * method will return false.
     */
    inline void clearID();

    /**
     * Checks whether the field "ID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setID()). Otherwise it will return false.
     */
    inline bool hasID () const;

    /**
     * Returns the value of the member "ID".
     *
     * Unique Freeze Frame ID
     *
     * @return The value of the field "ID"
     */
    inline uint8 getID () const;

    /**
     * Sets the value of the member "ID".
     *
     * Unique Freeze Frame ID
     *
     * @param ID The value which will be set
     */
    inline void setID (uint8 ID_);

    // API of field "Data"

    static const int kData = 1;

    /**
     * Clears the field "Data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "Data".
     *
     * Data Buffer. Data and length depends on ID
     *
     * @return The value of the field "Data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "Data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "Data".
     *
     * Data Buffer. Data and length depends on ID
     *
     * @param Data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& Data_);

    static const T_FreezeFrameData &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_ID ();

    inline void clear_has_ID ();

    inline void set_has_Data ();

    inline void clear_has_Data ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _ID;

    ::std::vector< uint8 > _Data;

};

/**
 * If the meaning of "T_TestResult" isn't clear, then there should be a description here.
 */
class T_TestResult {
public:

    /**
     * Default constructor
     */
    inline  T_TestResult ();

    /**
     * Copy constructor
     */
    inline  T_TestResult (const T_TestResult &rhs);

    /**
     * All fields constructor
     */
    inline  T_TestResult (uint32 TroubleCode_, T_e8_TestResult Result_, const T_FreezeFrameList& FreezeFrameList_);

    /**
     * Destructor
     */
    inline  ~T_TestResult();

    /**
     * Assignment operator
     */
    inline T_TestResult& operator = (const T_TestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_TestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_TestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_TestResult& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_TestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TroubleCode"

    static const int kTroubleCode = 0;

    /**
     * Clears the field "TroubleCode".
     *
     * The field will be set to its default value. The hasTroubleCode()
     * method will return false.
     */
    inline void clearTroubleCode();

    /**
     * Checks whether the field "TroubleCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTroubleCode()). Otherwise it will return false.
     */
    inline bool hasTroubleCode () const;

    /**
     * Returns the value of the member "TroubleCode".
     *
     * TroubleCodes are internal codes referring to error sites and kind of errors.
     * These system wide codes are unique for all projects.
     * The maintainer of the client application is responsible to assign TroubleCodes for all errors.
     * Error codes are mapped on customer specific DTCs by DiagLog.
     * If used as Dynamical DTC this one includes the real DTC ID.
     *
     * @return The value of the field "TroubleCode"
     */
    inline uint32 getTroubleCode () const;

    /**
     * Sets the value of the member "TroubleCode".
     *
     * TroubleCodes are internal codes referring to error sites and kind of errors.
     * These system wide codes are unique for all projects.
     * The maintainer of the client application is responsible to assign TroubleCodes for all errors.
     * Error codes are mapped on customer specific DTCs by DiagLog.
     * If used as Dynamical DTC this one includes the real DTC ID.
     *
     * @param TroubleCode The value which will be set
     */
    inline void setTroubleCode (uint32 TroubleCode_);

    // API of field "Result"

    static const int kResult = 1;

    /**
     * Clears the field "Result".
     *
     * The field will be set to its default value. The hasResult()
     * method will return false.
     */
    inline void clearResult();

    /**
     * Checks whether the field "Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setResult()). Otherwise it will return false.
     */
    inline bool hasResult () const;

    /**
     * Returns the value of the member "Result".
     *
     * The result of the test. Valid values are Passed                                       0x8200  Failed                                       0x8200  No Result etc.
     *
     * @return The value of the field "Result"
     */
    inline T_e8_TestResult getResult () const;

    /**
     * Sets the value of the member "Result".
     *
     * The result of the test. Valid values are Passed                                       0x8200  Failed                                       0x8200  No Result etc.
     *
     * @param Result The value which will be set
     */
    inline void setResult (T_e8_TestResult Result_);

    // API of field "FreezeFrameList"

    static const int kFreezeFrameList = 2;

    /**
     * Clears the field "FreezeFrameList".
     *
     * The field will be set to its default value. The hasFreezeFrameList()
     * method will return false.
     */
    inline void clearFreezeFrameList();

    /**
     * Checks whether the field "FreezeFrameList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFreezeFrameList()). Otherwise it will return false.
     */
    inline bool hasFreezeFrameList () const;

    /**
     * Returns the value of the member "FreezeFrameList".
     *
     * The FreezeFrameList contains a number of FreezeFrames
     *
     * @return The value of the field "FreezeFrameList"
     */
    inline const T_FreezeFrameList& getFreezeFrameList () const;

    /**
     * Retrieves the value of the field "FreezeFrameList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FreezeFrameList".
     */
    inline T_FreezeFrameList& getFreezeFrameListMutable ();

    /**
     * Sets the value of the member "FreezeFrameList".
     *
     * The FreezeFrameList contains a number of FreezeFrames
     *
     * @param FreezeFrameList The value which will be set
     */
    inline void setFreezeFrameList (const T_FreezeFrameList& FreezeFrameList_);

    static const T_TestResult &getDefaultInstance();

private:

    static const ::std::vector< T_FreezeFrameData >& getT_FreezeFrameDataList_DefaultInstance ();

    inline void set_has_TroubleCode ();

    inline void clear_has_TroubleCode ();

    inline void set_has_Result ();

    inline void clear_has_Result ();

    inline void set_has_FreezeFrameList ();

    inline void clear_has_FreezeFrameList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint32 _TroubleCode;

    T_e8_TestResult _Result;

    T_FreezeFrameList _FreezeFrameList;

};

/**
 * If the meaning of "T_ReadResultStructure" isn't clear, then there should be a description here.
 */
class T_ReadResultStructure {
public:

    /**
     * Default constructor
     */
    inline  T_ReadResultStructure ();

    /**
     * Copy constructor
     */
    inline  T_ReadResultStructure (const T_ReadResultStructure &rhs);

    /**
     * All fields constructor
     */
    inline  T_ReadResultStructure (uint32 DTC_, uint8 StatusOfDtc_);

    /**
     * Destructor
     */
    inline  ~T_ReadResultStructure();

    /**
     * Assignment operator
     */
    inline T_ReadResultStructure& operator = (const T_ReadResultStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ReadResultStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ReadResultStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ReadResultStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ReadResultStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTC"

    static const int kDTC = 0;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * Value of the DTC.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * Value of the DTC.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "StatusOfDtc"

    static const int kStatusOfDtc = 1;

    /**
     * Clears the field "StatusOfDtc".
     *
     * The field will be set to its default value. The hasStatusOfDtc()
     * method will return false.
     */
    inline void clearStatusOfDtc();

    /**
     * Checks whether the field "StatusOfDtc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusOfDtc()). Otherwise it will return false.
     */
    inline bool hasStatusOfDtc () const;

    /**
     * Returns the value of the member "StatusOfDtc".
     *
     * The status byte of the DTC.
     *
     * @return The value of the field "StatusOfDtc"
     */
    inline uint8 getStatusOfDtc () const;

    /**
     * Sets the value of the member "StatusOfDtc".
     *
     * The status byte of the DTC.
     *
     * @param StatusOfDtc The value which will be set
     */
    inline void setStatusOfDtc (uint8 StatusOfDtc_);

    static const T_ReadResultStructure &getDefaultInstance();

private:

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_StatusOfDtc ();

    inline void clear_has_StatusOfDtc ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DTC;

    uint8 _StatusOfDtc;

};

/**
 * If the meaning of "T_ITC_Information" isn't clear, then there should be a description here.
 */
class T_ITC_Information {
public:

    /**
     * Default constructor
     */
    inline  T_ITC_Information ();

    /**
     * Copy constructor
     */
    inline  T_ITC_Information (const T_ITC_Information &rhs);

    /**
     * All fields constructor
     */
    inline  T_ITC_Information (uint16 ITC_, uint32 DTC_, uint8 StatusOfItc_, uint32 AgeingCounter_, uint32 OccurenceCounter_);

    /**
     * Destructor
     */
    inline  ~T_ITC_Information();

    /**
     * Assignment operator
     */
    inline T_ITC_Information& operator = (const T_ITC_Information& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ITC_Information& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ITC_Information& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ITC_Information& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ITC_Information& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ITC"

    static const int kITC = 0;

    /**
     * Clears the field "ITC".
     *
     * The field will be set to its default value. The hasITC()
     * method will return false.
     */
    inline void clearITC();

    /**
     * Checks whether the field "ITC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITC()). Otherwise it will return false.
     */
    inline bool hasITC () const;

    /**
     * Returns the value of the member "ITC".
     *
     * Value of the DTC.
     *
     * @return The value of the field "ITC"
     */
    inline uint16 getITC () const;

    /**
     * Sets the value of the member "ITC".
     *
     * Value of the DTC.
     *
     * @param ITC The value which will be set
     */
    inline void setITC (uint16 ITC_);

    // API of field "DTC"

    static const int kDTC = 1;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * Value of the DTC.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * Value of the DTC.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "StatusOfItc"

    static const int kStatusOfItc = 2;

    /**
     * Clears the field "StatusOfItc".
     *
     * The field will be set to its default value. The hasStatusOfItc()
     * method will return false.
     */
    inline void clearStatusOfItc();

    /**
     * Checks whether the field "StatusOfItc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusOfItc()). Otherwise it will return false.
     */
    inline bool hasStatusOfItc () const;

    /**
     * Returns the value of the member "StatusOfItc".
     *
     * The status byte of the DTC.
     *
     * @return The value of the field "StatusOfItc"
     */
    inline uint8 getStatusOfItc () const;

    /**
     * Sets the value of the member "StatusOfItc".
     *
     * The status byte of the DTC.
     *
     * @param StatusOfItc The value which will be set
     */
    inline void setStatusOfItc (uint8 StatusOfItc_);

    // API of field "AgeingCounter"

    static const int kAgeingCounter = 3;

    /**
     * Clears the field "AgeingCounter".
     *
     * The field will be set to its default value. The hasAgeingCounter()
     * method will return false.
     */
    inline void clearAgeingCounter();

    /**
     * Checks whether the field "AgeingCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAgeingCounter()). Otherwise it will return false.
     */
    inline bool hasAgeingCounter () const;

    /**
     * Returns the value of the member "AgeingCounter".
     *
     * Value of Ageningcounter
     *
     * @return The value of the field "AgeingCounter"
     */
    inline uint32 getAgeingCounter () const;

    /**
     * Sets the value of the member "AgeingCounter".
     *
     * Value of Ageningcounter
     *
     * @param AgeingCounter The value which will be set
     */
    inline void setAgeingCounter (uint32 AgeingCounter_);

    // API of field "OccurenceCounter"

    static const int kOccurenceCounter = 4;

    /**
     * Clears the field "OccurenceCounter".
     *
     * The field will be set to its default value. The hasOccurenceCounter()
     * method will return false.
     */
    inline void clearOccurenceCounter();

    /**
     * Checks whether the field "OccurenceCounter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOccurenceCounter()). Otherwise it will return false.
     */
    inline bool hasOccurenceCounter () const;

    /**
     * Returns the value of the member "OccurenceCounter".
     *
     * Value of Occurence Counter
     *
     * @return The value of the field "OccurenceCounter"
     */
    inline uint32 getOccurenceCounter () const;

    /**
     * Sets the value of the member "OccurenceCounter".
     *
     * Value of Occurence Counter
     *
     * @param OccurenceCounter The value which will be set
     */
    inline void setOccurenceCounter (uint32 OccurenceCounter_);

    static const T_ITC_Information &getDefaultInstance();

private:

    inline void set_has_ITC ();

    inline void clear_has_ITC ();

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_StatusOfItc ();

    inline void clear_has_StatusOfItc ();

    inline void set_has_AgeingCounter ();

    inline void clear_has_AgeingCounter ();

    inline void set_has_OccurenceCounter ();

    inline void clear_has_OccurenceCounter ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _ITC;

    uint32 _DTC;

    uint8 _StatusOfItc;

    uint32 _AgeingCounter;

    uint32 _OccurenceCounter;

};

/**
 * If the meaning of "T_ProductionReadResultStructure" isn't clear, then there should be a description here.
 */
class T_ProductionReadResultStructure {
public:

    /**
     * Default constructor
     */
    inline  T_ProductionReadResultStructure ();

    /**
     * Copy constructor
     */
    inline  T_ProductionReadResultStructure (const T_ProductionReadResultStructure &rhs);

    /**
     * All fields constructor
     */
    inline  T_ProductionReadResultStructure (uint16 ITC_, uint8 Status_);

    /**
     * Destructor
     */
    inline  ~T_ProductionReadResultStructure();

    /**
     * Assignment operator
     */
    inline T_ProductionReadResultStructure& operator = (const T_ProductionReadResultStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_ProductionReadResultStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_ProductionReadResultStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_ProductionReadResultStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_ProductionReadResultStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ITC"

    static const int kITC = 0;

    /**
     * Clears the field "ITC".
     *
     * The field will be set to its default value. The hasITC()
     * method will return false.
     */
    inline void clearITC();

    /**
     * Checks whether the field "ITC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITC()). Otherwise it will return false.
     */
    inline bool hasITC () const;

    /**
     * Returns the value of the member "ITC".
     *
     * Value of the ITC.
     *
     * @return The value of the field "ITC"
     */
    inline uint16 getITC () const;

    /**
     * Sets the value of the member "ITC".
     *
     * Value of the ITC.
     *
     * @param ITC The value which will be set
     */
    inline void setITC (uint16 ITC_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * The status byte of the ITC.
     *
     * @return The value of the field "Status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * The status byte of the ITC.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (uint8 Status_);

    static const T_ProductionReadResultStructure &getDefaultInstance();

private:

    inline void set_has_ITC ();

    inline void clear_has_ITC ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _ITC;

    uint8 _Status;

};

/**
 * If the meaning of "T_CustomerReadResultStructure" isn't clear, then there should be a description here.
 */
class T_CustomerReadResultStructure {
public:

    /**
     * Default constructor
     */
    inline  T_CustomerReadResultStructure ();

    /**
     * Copy constructor
     */
    inline  T_CustomerReadResultStructure (const T_CustomerReadResultStructure &rhs);

    /**
     * All fields constructor
     */
    inline  T_CustomerReadResultStructure (uint32 DTC_, uint8 Status_);

    /**
     * Destructor
     */
    inline  ~T_CustomerReadResultStructure();

    /**
     * Assignment operator
     */
    inline T_CustomerReadResultStructure& operator = (const T_CustomerReadResultStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_CustomerReadResultStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_CustomerReadResultStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_CustomerReadResultStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_CustomerReadResultStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTC"

    static const int kDTC = 0;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * Value of the DTC.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * Value of the DTC.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * The status byte of the DTC.
     *
     * @return The value of the field "Status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * The status byte of the DTC.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (uint8 Status_);

    static const T_CustomerReadResultStructure &getDefaultInstance();

private:

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DTC;

    uint8 _Status;

};

/**
 * If the meaning of "T_SnapshotData" isn't clear, then there should be a description here.
 */
class T_SnapshotData {
public:

    /**
     * Default constructor
     */
    inline  T_SnapshotData ();

    /**
     * Copy constructor
     */
    inline  T_SnapshotData (const T_SnapshotData &rhs);

    /**
     * All fields constructor
     */
    inline  T_SnapshotData (uint8 RecordNumber_, uint8 NumberOfData_, const ::std::vector< uint8 >& Data_);

    /**
     * Destructor
     */
    inline  ~T_SnapshotData();

    /**
     * Assignment operator
     */
    inline T_SnapshotData& operator = (const T_SnapshotData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SnapshotData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SnapshotData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SnapshotData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SnapshotData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RecordNumber"

    static const int kRecordNumber = 0;

    /**
     * Clears the field "RecordNumber".
     *
     * The field will be set to its default value. The hasRecordNumber()
     * method will return false.
     */
    inline void clearRecordNumber();

    /**
     * Checks whether the field "RecordNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecordNumber()). Otherwise it will return false.
     */
    inline bool hasRecordNumber () const;

    /**
     * Returns the value of the member "RecordNumber".
     *
     * unique Snapshot ID
     *
     * @return The value of the field "RecordNumber"
     */
    inline uint8 getRecordNumber () const;

    /**
     * Sets the value of the member "RecordNumber".
     *
     * unique Snapshot ID
     *
     * @param RecordNumber The value which will be set
     */
    inline void setRecordNumber (uint8 RecordNumber_);

    // API of field "NumberOfData"

    static const int kNumberOfData = 1;

    /**
     * Clears the field "NumberOfData".
     *
     * The field will be set to its default value. The hasNumberOfData()
     * method will return false.
     */
    inline void clearNumberOfData();

    /**
     * Checks whether the field "NumberOfData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfData()). Otherwise it will return false.
     */
    inline bool hasNumberOfData () const;

    /**
     * Returns the value of the member "NumberOfData".
     *
     * length of following Data
     *
     * @return The value of the field "NumberOfData"
     */
    inline uint8 getNumberOfData () const;

    /**
     * Sets the value of the member "NumberOfData".
     *
     * length of following Data
     *
     * @param NumberOfData The value which will be set
     */
    inline void setNumberOfData (uint8 NumberOfData_);

    // API of field "Data"

    static const int kData = 2;

    /**
     * Clears the field "Data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "Data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "Data".
     *
     * Data Buffer. Data and length depends on ID
     *
     * @return The value of the field "Data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "Data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "Data".
     *
     * Data Buffer. Data and length depends on ID
     *
     * @param Data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& Data_);

    static const T_SnapshotData &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_RecordNumber ();

    inline void clear_has_RecordNumber ();

    inline void set_has_NumberOfData ();

    inline void clear_has_NumberOfData ();

    inline void set_has_Data ();

    inline void clear_has_Data ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _RecordNumber;

    uint8 _NumberOfData;

    ::std::vector< uint8 > _Data;

};

/**
 * If the meaning of "T_SnapshotIdentification" isn't clear, then there should be a description here.
 */
class T_SnapshotIdentification {
public:

    /**
     * Default constructor
     */
    inline  T_SnapshotIdentification ();

    /**
     * Copy constructor
     */
    inline  T_SnapshotIdentification (const T_SnapshotIdentification &rhs);

    /**
     * All fields constructor
     */
    inline  T_SnapshotIdentification (uint32 DTC_, uint8 RecordNumber_);

    /**
     * Destructor
     */
    inline  ~T_SnapshotIdentification();

    /**
     * Assignment operator
     */
    inline T_SnapshotIdentification& operator = (const T_SnapshotIdentification& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SnapshotIdentification& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SnapshotIdentification& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SnapshotIdentification& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SnapshotIdentification& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTC"

    static const int kDTC = 0;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * unique Snapshot ID
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * unique Snapshot ID
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "RecordNumber"

    static const int kRecordNumber = 1;

    /**
     * Clears the field "RecordNumber".
     *
     * The field will be set to its default value. The hasRecordNumber()
     * method will return false.
     */
    inline void clearRecordNumber();

    /**
     * Checks whether the field "RecordNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRecordNumber()). Otherwise it will return false.
     */
    inline bool hasRecordNumber () const;

    /**
     * Returns the value of the member "RecordNumber".
     *
     * length of following Data
     *
     * @return The value of the field "RecordNumber"
     */
    inline uint8 getRecordNumber () const;

    /**
     * Sets the value of the member "RecordNumber".
     *
     * length of following Data
     *
     * @param RecordNumber The value which will be set
     */
    inline void setRecordNumber (uint8 RecordNumber_);

    static const T_SnapshotIdentification &getDefaultInstance();

private:

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_RecordNumber ();

    inline void clear_has_RecordNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _DTC;

    uint8 _RecordNumber;

};

/**
 * This structure contains the list of the DTCs that shall be updated.
 */
class T_SendNextTestResultStructure {
public:

    /**
     * Default constructor
     */
    inline  T_SendNextTestResultStructure ();

    /**
     * Copy constructor
     */
    inline  T_SendNextTestResultStructure (const T_SendNextTestResultStructure &rhs);

    /**
     * All fields constructor
     */
    inline  T_SendNextTestResultStructure (bool Status_, T_e8_SendNextTestResReason SendNextTestResReason_, const ::std::vector< uint16 >& ITCList_);

    /**
     * Destructor
     */
    inline  ~T_SendNextTestResultStructure();

    /**
     * Assignment operator
     */
    inline T_SendNextTestResultStructure& operator = (const T_SendNextTestResultStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_SendNextTestResultStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_SendNextTestResultStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_SendNextTestResultStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_SendNextTestResultStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Status = false if this is a confirmation message from the Diaglog that the UpReg has been succesful. Status = true if client is required to send next test result to DiagLog.
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Status = false if this is a confirmation message from the Diaglog that the UpReg has been succesful. Status = true if client is required to send next test result to DiagLog.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    // API of field "SendNextTestResReason"

    static const int kSendNextTestResReason = 1;

    /**
     * Clears the field "SendNextTestResReason".
     *
     * The field will be set to its default value. The hasSendNextTestResReason()
     * method will return false.
     */
    inline void clearSendNextTestResReason();

    /**
     * Checks whether the field "SendNextTestResReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSendNextTestResReason()). Otherwise it will return false.
     */
    inline bool hasSendNextTestResReason () const;

    /**
     * Returns the value of the member "SendNextTestResReason".
     *
     * This filed indicates the reason behind requesting the next test result: Either due a DTC Clearing Code 04 oder due to reset of the Blocking Mode of the DTC
     *
     * @return The value of the field "SendNextTestResReason"
     */
    inline T_e8_SendNextTestResReason getSendNextTestResReason () const;

    /**
     * Sets the value of the member "SendNextTestResReason".
     *
     * This filed indicates the reason behind requesting the next test result: Either due a DTC Clearing Code 04 oder due to reset of the Blocking Mode of the DTC
     *
     * @param SendNextTestResReason The value which will be set
     */
    inline void setSendNextTestResReason (T_e8_SendNextTestResReason SendNextTestResReason_);

    // API of field "ITCList"

    static const int kITCList = 2;

    /**
     * Clears the field "ITCList".
     *
     * The field will be set to its default value. The hasITCList()
     * method will return false.
     */
    inline void clearITCList();

    /**
     * Checks whether the field "ITCList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITCList()). Otherwise it will return false.
     */
    inline bool hasITCList () const;

    /**
     * Returns the value of the member "ITCList".
     *
     * This is the list of the DTCs for which the next test result has to be sent. if the List is empty and "Status == True" then the client should report all the DTCs for which he is reponsible.
     * For the DTCs that are listed in the ITCList: correponding tests must be immediately cancelled (if they are running) when the CCA message is received. New Tests have to be carried out and the results of these Tests must be reported to the Diaglog.
     *
     * @return The value of the field "ITCList"
     */
    inline const ::std::vector< uint16 >& getITCList () const;

    /**
     * Retrieves the value of the field "ITCList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ITCList".
     */
    inline ::std::vector< uint16 >& getITCListMutable ();

    /**
     * Sets the value of the member "ITCList".
     *
     * This is the list of the DTCs for which the next test result has to be sent. if the List is empty and "Status == True" then the client should report all the DTCs for which he is reponsible.
     * For the DTCs that are listed in the ITCList: correponding tests must be immediately cancelled (if they are running) when the CCA message is received. New Tests have to be carried out and the results of these Tests must be reported to the Diaglog.
     *
     * @param ITCList The value which will be set
     */
    inline void setITCList (const ::std::vector< uint16 >& ITCList_);

    static const T_SendNextTestResultStructure &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    inline void set_has_SendNextTestResReason ();

    inline void clear_has_SendNextTestResReason ();

    inline void set_has_ITCList ();

    inline void clear_has_ITCList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _Status;

    T_e8_SendNextTestResReason _SendNextTestResReason;

    ::std::vector< uint16 > _ITCList;

};

inline  T_FreezeFrameData::T_FreezeFrameData ()  :
    _ID (0u),
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_FreezeFrameData::T_FreezeFrameData (const T_FreezeFrameData &rhs)  :
    _ID (0u),
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_FreezeFrameData::T_FreezeFrameData (uint8 ID_, const ::std::vector< uint8 >& Data_)  :
    _ID (ID_),
    _Data (Data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_FreezeFrameData::~T_FreezeFrameData() {
}

inline T_FreezeFrameData& T_FreezeFrameData::operator = (const T_FreezeFrameData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasID()) {
            setID(rhs.getID());
        } else {
            clearID();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool T_FreezeFrameData::operator == (const T_FreezeFrameData& rhs) const {
    return (((!hasID() && !rhs.hasID()) || getID() == rhs.getID()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool T_FreezeFrameData::operator != (const T_FreezeFrameData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_FreezeFrameData::operator < (const T_FreezeFrameData& rhs) const {
    if (hasID() || rhs.hasID()) {
        if (getID() < rhs.getID()) return true;
        if (getID() > rhs.getID()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline bool T_FreezeFrameData::operator > (const T_FreezeFrameData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_FreezeFrameData::clear() {
    clearID();
    clearData();
}

inline void T_FreezeFrameData::clearID() {
    if (hasID()) {
         clear_has_ID();
        _ID = 0u;
     }
}

inline bool T_FreezeFrameData::hasID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_FreezeFrameData::getID () const {
    return _ID;
}

inline void T_FreezeFrameData::setID (uint8 ID_) {
    set_has_ID();
    this->_ID = ID_;
}

inline void T_FreezeFrameData::clearData() {
    if (hasData()) {
         clear_has_Data();
        _Data.clear();
     }
}

inline bool T_FreezeFrameData::hasData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint8 >& T_FreezeFrameData::getData () const {
    return _Data;
}

inline ::std::vector< uint8 >& T_FreezeFrameData::getDataMutable () {
    set_has_Data();
    return _Data;
}

inline void T_FreezeFrameData::setData (const ::std::vector< uint8 >& Data_) {
    set_has_Data();
    this->_Data = Data_;
}

inline void T_FreezeFrameData::set_has_ID () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_FreezeFrameData::clear_has_ID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_FreezeFrameData::set_has_Data () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_FreezeFrameData::clear_has_Data () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_TestResult::T_TestResult ()  :
    _TroubleCode (0u),
    _Result (::diaglog_main_fi_types::T_e8_TestResult__Passed),
    _FreezeFrameList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_TestResult::T_TestResult (const T_TestResult &rhs)  :
    _TroubleCode (0u),
    _Result (::diaglog_main_fi_types::T_e8_TestResult__Passed),
    _FreezeFrameList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_TestResult::T_TestResult (uint32 TroubleCode_, T_e8_TestResult Result_, const T_FreezeFrameList& FreezeFrameList_)  :
    _TroubleCode (TroubleCode_),
    _Result (Result_),
    _FreezeFrameList (FreezeFrameList_)
{
    #ifndef NDEBUG
    if (!(T_e8_TestResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "T_e8_TestResult", "Result", "T_TestResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_TestResult::~T_TestResult() {
}

inline T_TestResult& T_TestResult::operator = (const T_TestResult& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTroubleCode()) {
            setTroubleCode(rhs.getTroubleCode());
        } else {
            clearTroubleCode();
        }
        if (rhs.hasResult()) {
            setResult(rhs.getResult());
        } else {
            clearResult();
        }
        if (rhs.hasFreezeFrameList()) {
            setFreezeFrameList(rhs.getFreezeFrameList());
        } else {
            clearFreezeFrameList();
        }
    }
    return *this;
}

inline bool T_TestResult::operator == (const T_TestResult& rhs) const {
    return (((!hasTroubleCode() && !rhs.hasTroubleCode()) || getTroubleCode() == rhs.getTroubleCode()) &&
        ((!hasResult() && !rhs.hasResult()) || getResult() == rhs.getResult()) &&
        ((!hasFreezeFrameList() && !rhs.hasFreezeFrameList()) || getFreezeFrameList() == rhs.getFreezeFrameList()));
}

inline bool T_TestResult::operator != (const T_TestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool T_TestResult::operator < (const T_TestResult& rhs) const {
    if (hasTroubleCode() || rhs.hasTroubleCode()) {
        if (getTroubleCode() < rhs.getTroubleCode()) return true;
        if (getTroubleCode() > rhs.getTroubleCode()) return false;
    }
    if (hasResult() || rhs.hasResult()) {
        if ((uint32)getResult() < (uint32)rhs.getResult()) return true;
        if ((uint32)getResult() > (uint32)rhs.getResult()) return false;
    }
    if (hasFreezeFrameList() || rhs.hasFreezeFrameList()) {
        if (getFreezeFrameList() < rhs.getFreezeFrameList()) return true;
        if (getFreezeFrameList() > rhs.getFreezeFrameList()) return false;
    }
    return false;
}

inline bool T_TestResult::operator > (const T_TestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_TestResult::clear() {
    clearTroubleCode();
    clearResult();
    clearFreezeFrameList();
}

inline void T_TestResult::clearTroubleCode() {
    if (hasTroubleCode()) {
         clear_has_TroubleCode();
        _TroubleCode = 0u;
     }
}

inline bool T_TestResult::hasTroubleCode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_TestResult::getTroubleCode () const {
    return _TroubleCode;
}

inline void T_TestResult::setTroubleCode (uint32 TroubleCode_) {
    set_has_TroubleCode();
    this->_TroubleCode = TroubleCode_;
}

inline void T_TestResult::clearResult() {
    if (hasResult()) {
         clear_has_Result();
        _Result = ::diaglog_main_fi_types::T_e8_TestResult__Passed;
     }
}

inline bool T_TestResult::hasResult () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_TestResult T_TestResult::getResult () const {
    return _Result;
}

inline void T_TestResult::setResult (T_e8_TestResult Result_) {
    #ifndef NDEBUG
    if (!(T_e8_TestResult_IsValid(Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", Result_, "T_e8_TestResult", "Result", "T_TestResult");
    }
    #endif
    set_has_Result();
    this->_Result = Result_;
}

inline void T_TestResult::clearFreezeFrameList() {
    if (hasFreezeFrameList()) {
         clear_has_FreezeFrameList();
        _FreezeFrameList.clear();
     }
}

inline bool T_TestResult::hasFreezeFrameList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_FreezeFrameList& T_TestResult::getFreezeFrameList () const {
    return _FreezeFrameList;
}

inline T_FreezeFrameList& T_TestResult::getFreezeFrameListMutable () {
    set_has_FreezeFrameList();
    return _FreezeFrameList;
}

inline void T_TestResult::setFreezeFrameList (const T_FreezeFrameList& FreezeFrameList_) {
    set_has_FreezeFrameList();
    this->_FreezeFrameList = FreezeFrameList_;
}

inline void T_TestResult::set_has_TroubleCode () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_TestResult::clear_has_TroubleCode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_TestResult::set_has_Result () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_TestResult::clear_has_Result () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_TestResult::set_has_FreezeFrameList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_TestResult::clear_has_FreezeFrameList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_ReadResultStructure::T_ReadResultStructure ()  :
    _DTC (0u),
    _StatusOfDtc (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ReadResultStructure::T_ReadResultStructure (const T_ReadResultStructure &rhs)  :
    _DTC (0u),
    _StatusOfDtc (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ReadResultStructure::T_ReadResultStructure (uint32 DTC_, uint8 StatusOfDtc_)  :
    _DTC (DTC_),
    _StatusOfDtc (StatusOfDtc_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ReadResultStructure::~T_ReadResultStructure() {
}

inline T_ReadResultStructure& T_ReadResultStructure::operator = (const T_ReadResultStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasStatusOfDtc()) {
            setStatusOfDtc(rhs.getStatusOfDtc());
        } else {
            clearStatusOfDtc();
        }
    }
    return *this;
}

inline bool T_ReadResultStructure::operator == (const T_ReadResultStructure& rhs) const {
    return (((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasStatusOfDtc() && !rhs.hasStatusOfDtc()) || getStatusOfDtc() == rhs.getStatusOfDtc()));
}

inline bool T_ReadResultStructure::operator != (const T_ReadResultStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ReadResultStructure::operator < (const T_ReadResultStructure& rhs) const {
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasStatusOfDtc() || rhs.hasStatusOfDtc()) {
        if (getStatusOfDtc() < rhs.getStatusOfDtc()) return true;
        if (getStatusOfDtc() > rhs.getStatusOfDtc()) return false;
    }
    return false;
}

inline bool T_ReadResultStructure::operator > (const T_ReadResultStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ReadResultStructure::clear() {
    clearDTC();
    clearStatusOfDtc();
}

inline void T_ReadResultStructure::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool T_ReadResultStructure::hasDTC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_ReadResultStructure::getDTC () const {
    return _DTC;
}

inline void T_ReadResultStructure::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void T_ReadResultStructure::clearStatusOfDtc() {
    if (hasStatusOfDtc()) {
         clear_has_StatusOfDtc();
        _StatusOfDtc = 0u;
     }
}

inline bool T_ReadResultStructure::hasStatusOfDtc () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_ReadResultStructure::getStatusOfDtc () const {
    return _StatusOfDtc;
}

inline void T_ReadResultStructure::setStatusOfDtc (uint8 StatusOfDtc_) {
    set_has_StatusOfDtc();
    this->_StatusOfDtc = StatusOfDtc_;
}

inline void T_ReadResultStructure::set_has_DTC () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ReadResultStructure::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ReadResultStructure::set_has_StatusOfDtc () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ReadResultStructure::clear_has_StatusOfDtc () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_ITC_Information::T_ITC_Information ()  :
    _ITC (0u),
    _DTC (0u),
    _StatusOfItc (0u),
    _AgeingCounter (0u),
    _OccurenceCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ITC_Information::T_ITC_Information (const T_ITC_Information &rhs)  :
    _ITC (0u),
    _DTC (0u),
    _StatusOfItc (0u),
    _AgeingCounter (0u),
    _OccurenceCounter (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ITC_Information::T_ITC_Information (uint16 ITC_, uint32 DTC_, uint8 StatusOfItc_, uint32 AgeingCounter_, uint32 OccurenceCounter_)  :
    _ITC (ITC_),
    _DTC (DTC_),
    _StatusOfItc (StatusOfItc_),
    _AgeingCounter (AgeingCounter_),
    _OccurenceCounter (OccurenceCounter_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ITC_Information::~T_ITC_Information() {
}

inline T_ITC_Information& T_ITC_Information::operator = (const T_ITC_Information& rhs) {
    if( this != &rhs ) {
        if (rhs.hasITC()) {
            setITC(rhs.getITC());
        } else {
            clearITC();
        }
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasStatusOfItc()) {
            setStatusOfItc(rhs.getStatusOfItc());
        } else {
            clearStatusOfItc();
        }
        if (rhs.hasAgeingCounter()) {
            setAgeingCounter(rhs.getAgeingCounter());
        } else {
            clearAgeingCounter();
        }
        if (rhs.hasOccurenceCounter()) {
            setOccurenceCounter(rhs.getOccurenceCounter());
        } else {
            clearOccurenceCounter();
        }
    }
    return *this;
}

inline bool T_ITC_Information::operator == (const T_ITC_Information& rhs) const {
    return (((!hasITC() && !rhs.hasITC()) || getITC() == rhs.getITC()) &&
        ((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasStatusOfItc() && !rhs.hasStatusOfItc()) || getStatusOfItc() == rhs.getStatusOfItc()) &&
        ((!hasAgeingCounter() && !rhs.hasAgeingCounter()) || getAgeingCounter() == rhs.getAgeingCounter()) &&
        ((!hasOccurenceCounter() && !rhs.hasOccurenceCounter()) || getOccurenceCounter() == rhs.getOccurenceCounter()));
}

inline bool T_ITC_Information::operator != (const T_ITC_Information& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ITC_Information::operator < (const T_ITC_Information& rhs) const {
    if (hasITC() || rhs.hasITC()) {
        if (getITC() < rhs.getITC()) return true;
        if (getITC() > rhs.getITC()) return false;
    }
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasStatusOfItc() || rhs.hasStatusOfItc()) {
        if (getStatusOfItc() < rhs.getStatusOfItc()) return true;
        if (getStatusOfItc() > rhs.getStatusOfItc()) return false;
    }
    if (hasAgeingCounter() || rhs.hasAgeingCounter()) {
        if (getAgeingCounter() < rhs.getAgeingCounter()) return true;
        if (getAgeingCounter() > rhs.getAgeingCounter()) return false;
    }
    if (hasOccurenceCounter() || rhs.hasOccurenceCounter()) {
        if (getOccurenceCounter() < rhs.getOccurenceCounter()) return true;
        if (getOccurenceCounter() > rhs.getOccurenceCounter()) return false;
    }
    return false;
}

inline bool T_ITC_Information::operator > (const T_ITC_Information& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ITC_Information::clear() {
    clearITC();
    clearDTC();
    clearStatusOfItc();
    clearAgeingCounter();
    clearOccurenceCounter();
}

inline void T_ITC_Information::clearITC() {
    if (hasITC()) {
         clear_has_ITC();
        _ITC = 0u;
     }
}

inline bool T_ITC_Information::hasITC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ITC_Information::getITC () const {
    return _ITC;
}

inline void T_ITC_Information::setITC (uint16 ITC_) {
    set_has_ITC();
    this->_ITC = ITC_;
}

inline void T_ITC_Information::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool T_ITC_Information::hasDTC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_ITC_Information::getDTC () const {
    return _DTC;
}

inline void T_ITC_Information::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void T_ITC_Information::clearStatusOfItc() {
    if (hasStatusOfItc()) {
         clear_has_StatusOfItc();
        _StatusOfItc = 0u;
     }
}

inline bool T_ITC_Information::hasStatusOfItc () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_ITC_Information::getStatusOfItc () const {
    return _StatusOfItc;
}

inline void T_ITC_Information::setStatusOfItc (uint8 StatusOfItc_) {
    set_has_StatusOfItc();
    this->_StatusOfItc = StatusOfItc_;
}

inline void T_ITC_Information::clearAgeingCounter() {
    if (hasAgeingCounter()) {
         clear_has_AgeingCounter();
        _AgeingCounter = 0u;
     }
}

inline bool T_ITC_Information::hasAgeingCounter () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 T_ITC_Information::getAgeingCounter () const {
    return _AgeingCounter;
}

inline void T_ITC_Information::setAgeingCounter (uint32 AgeingCounter_) {
    set_has_AgeingCounter();
    this->_AgeingCounter = AgeingCounter_;
}

inline void T_ITC_Information::clearOccurenceCounter() {
    if (hasOccurenceCounter()) {
         clear_has_OccurenceCounter();
        _OccurenceCounter = 0u;
     }
}

inline bool T_ITC_Information::hasOccurenceCounter () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint32 T_ITC_Information::getOccurenceCounter () const {
    return _OccurenceCounter;
}

inline void T_ITC_Information::setOccurenceCounter (uint32 OccurenceCounter_) {
    set_has_OccurenceCounter();
    this->_OccurenceCounter = OccurenceCounter_;
}

inline void T_ITC_Information::set_has_ITC () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ITC_Information::clear_has_ITC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ITC_Information::set_has_DTC () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ITC_Information::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_ITC_Information::set_has_StatusOfItc () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_ITC_Information::clear_has_StatusOfItc () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_ITC_Information::set_has_AgeingCounter () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_ITC_Information::clear_has_AgeingCounter () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_ITC_Information::set_has_OccurenceCounter () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_ITC_Information::clear_has_OccurenceCounter () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_ProductionReadResultStructure::T_ProductionReadResultStructure ()  :
    _ITC (0u),
    _Status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_ProductionReadResultStructure::T_ProductionReadResultStructure (const T_ProductionReadResultStructure &rhs)  :
    _ITC (0u),
    _Status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_ProductionReadResultStructure::T_ProductionReadResultStructure (uint16 ITC_, uint8 Status_)  :
    _ITC (ITC_),
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_ProductionReadResultStructure::~T_ProductionReadResultStructure() {
}

inline T_ProductionReadResultStructure& T_ProductionReadResultStructure::operator = (const T_ProductionReadResultStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasITC()) {
            setITC(rhs.getITC());
        } else {
            clearITC();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_ProductionReadResultStructure::operator == (const T_ProductionReadResultStructure& rhs) const {
    return (((!hasITC() && !rhs.hasITC()) || getITC() == rhs.getITC()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_ProductionReadResultStructure::operator != (const T_ProductionReadResultStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool T_ProductionReadResultStructure::operator < (const T_ProductionReadResultStructure& rhs) const {
    if (hasITC() || rhs.hasITC()) {
        if (getITC() < rhs.getITC()) return true;
        if (getITC() > rhs.getITC()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_ProductionReadResultStructure::operator > (const T_ProductionReadResultStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_ProductionReadResultStructure::clear() {
    clearITC();
    clearStatus();
}

inline void T_ProductionReadResultStructure::clearITC() {
    if (hasITC()) {
         clear_has_ITC();
        _ITC = 0u;
     }
}

inline bool T_ProductionReadResultStructure::hasITC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 T_ProductionReadResultStructure::getITC () const {
    return _ITC;
}

inline void T_ProductionReadResultStructure::setITC (uint16 ITC_) {
    set_has_ITC();
    this->_ITC = ITC_;
}

inline void T_ProductionReadResultStructure::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = 0u;
     }
}

inline bool T_ProductionReadResultStructure::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_ProductionReadResultStructure::getStatus () const {
    return _Status;
}

inline void T_ProductionReadResultStructure::setStatus (uint8 Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void T_ProductionReadResultStructure::set_has_ITC () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_ProductionReadResultStructure::clear_has_ITC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_ProductionReadResultStructure::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_ProductionReadResultStructure::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_CustomerReadResultStructure::T_CustomerReadResultStructure ()  :
    _DTC (0u),
    _Status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_CustomerReadResultStructure::T_CustomerReadResultStructure (const T_CustomerReadResultStructure &rhs)  :
    _DTC (0u),
    _Status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_CustomerReadResultStructure::T_CustomerReadResultStructure (uint32 DTC_, uint8 Status_)  :
    _DTC (DTC_),
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_CustomerReadResultStructure::~T_CustomerReadResultStructure() {
}

inline T_CustomerReadResultStructure& T_CustomerReadResultStructure::operator = (const T_CustomerReadResultStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool T_CustomerReadResultStructure::operator == (const T_CustomerReadResultStructure& rhs) const {
    return (((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool T_CustomerReadResultStructure::operator != (const T_CustomerReadResultStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool T_CustomerReadResultStructure::operator < (const T_CustomerReadResultStructure& rhs) const {
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline bool T_CustomerReadResultStructure::operator > (const T_CustomerReadResultStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_CustomerReadResultStructure::clear() {
    clearDTC();
    clearStatus();
}

inline void T_CustomerReadResultStructure::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool T_CustomerReadResultStructure::hasDTC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_CustomerReadResultStructure::getDTC () const {
    return _DTC;
}

inline void T_CustomerReadResultStructure::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void T_CustomerReadResultStructure::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = 0u;
     }
}

inline bool T_CustomerReadResultStructure::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_CustomerReadResultStructure::getStatus () const {
    return _Status;
}

inline void T_CustomerReadResultStructure::setStatus (uint8 Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void T_CustomerReadResultStructure::set_has_DTC () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_CustomerReadResultStructure::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_CustomerReadResultStructure::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_CustomerReadResultStructure::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SnapshotData::T_SnapshotData ()  :
    _RecordNumber (0u),
    _NumberOfData (0u),
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SnapshotData::T_SnapshotData (const T_SnapshotData &rhs)  :
    _RecordNumber (0u),
    _NumberOfData (0u),
    _Data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SnapshotData::T_SnapshotData (uint8 RecordNumber_, uint8 NumberOfData_, const ::std::vector< uint8 >& Data_)  :
    _RecordNumber (RecordNumber_),
    _NumberOfData (NumberOfData_),
    _Data (Data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SnapshotData::~T_SnapshotData() {
}

inline T_SnapshotData& T_SnapshotData::operator = (const T_SnapshotData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasRecordNumber()) {
            setRecordNumber(rhs.getRecordNumber());
        } else {
            clearRecordNumber();
        }
        if (rhs.hasNumberOfData()) {
            setNumberOfData(rhs.getNumberOfData());
        } else {
            clearNumberOfData();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool T_SnapshotData::operator == (const T_SnapshotData& rhs) const {
    return (((!hasRecordNumber() && !rhs.hasRecordNumber()) || getRecordNumber() == rhs.getRecordNumber()) &&
        ((!hasNumberOfData() && !rhs.hasNumberOfData()) || getNumberOfData() == rhs.getNumberOfData()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool T_SnapshotData::operator != (const T_SnapshotData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SnapshotData::operator < (const T_SnapshotData& rhs) const {
    if (hasRecordNumber() || rhs.hasRecordNumber()) {
        if (getRecordNumber() < rhs.getRecordNumber()) return true;
        if (getRecordNumber() > rhs.getRecordNumber()) return false;
    }
    if (hasNumberOfData() || rhs.hasNumberOfData()) {
        if (getNumberOfData() < rhs.getNumberOfData()) return true;
        if (getNumberOfData() > rhs.getNumberOfData()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline bool T_SnapshotData::operator > (const T_SnapshotData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SnapshotData::clear() {
    clearRecordNumber();
    clearNumberOfData();
    clearData();
}

inline void T_SnapshotData::clearRecordNumber() {
    if (hasRecordNumber()) {
         clear_has_RecordNumber();
        _RecordNumber = 0u;
     }
}

inline bool T_SnapshotData::hasRecordNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_SnapshotData::getRecordNumber () const {
    return _RecordNumber;
}

inline void T_SnapshotData::setRecordNumber (uint8 RecordNumber_) {
    set_has_RecordNumber();
    this->_RecordNumber = RecordNumber_;
}

inline void T_SnapshotData::clearNumberOfData() {
    if (hasNumberOfData()) {
         clear_has_NumberOfData();
        _NumberOfData = 0u;
     }
}

inline bool T_SnapshotData::hasNumberOfData () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SnapshotData::getNumberOfData () const {
    return _NumberOfData;
}

inline void T_SnapshotData::setNumberOfData (uint8 NumberOfData_) {
    set_has_NumberOfData();
    this->_NumberOfData = NumberOfData_;
}

inline void T_SnapshotData::clearData() {
    if (hasData()) {
         clear_has_Data();
        _Data.clear();
     }
}

inline bool T_SnapshotData::hasData () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint8 >& T_SnapshotData::getData () const {
    return _Data;
}

inline ::std::vector< uint8 >& T_SnapshotData::getDataMutable () {
    set_has_Data();
    return _Data;
}

inline void T_SnapshotData::setData (const ::std::vector< uint8 >& Data_) {
    set_has_Data();
    this->_Data = Data_;
}

inline void T_SnapshotData::set_has_RecordNumber () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SnapshotData::clear_has_RecordNumber () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SnapshotData::set_has_NumberOfData () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SnapshotData::clear_has_NumberOfData () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SnapshotData::set_has_Data () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SnapshotData::clear_has_Data () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_SnapshotIdentification::T_SnapshotIdentification ()  :
    _DTC (0u),
    _RecordNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SnapshotIdentification::T_SnapshotIdentification (const T_SnapshotIdentification &rhs)  :
    _DTC (0u),
    _RecordNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SnapshotIdentification::T_SnapshotIdentification (uint32 DTC_, uint8 RecordNumber_)  :
    _DTC (DTC_),
    _RecordNumber (RecordNumber_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SnapshotIdentification::~T_SnapshotIdentification() {
}

inline T_SnapshotIdentification& T_SnapshotIdentification::operator = (const T_SnapshotIdentification& rhs) {
    if( this != &rhs ) {
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasRecordNumber()) {
            setRecordNumber(rhs.getRecordNumber());
        } else {
            clearRecordNumber();
        }
    }
    return *this;
}

inline bool T_SnapshotIdentification::operator == (const T_SnapshotIdentification& rhs) const {
    return (((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasRecordNumber() && !rhs.hasRecordNumber()) || getRecordNumber() == rhs.getRecordNumber()));
}

inline bool T_SnapshotIdentification::operator != (const T_SnapshotIdentification& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SnapshotIdentification::operator < (const T_SnapshotIdentification& rhs) const {
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasRecordNumber() || rhs.hasRecordNumber()) {
        if (getRecordNumber() < rhs.getRecordNumber()) return true;
        if (getRecordNumber() > rhs.getRecordNumber()) return false;
    }
    return false;
}

inline bool T_SnapshotIdentification::operator > (const T_SnapshotIdentification& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SnapshotIdentification::clear() {
    clearDTC();
    clearRecordNumber();
}

inline void T_SnapshotIdentification::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool T_SnapshotIdentification::hasDTC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 T_SnapshotIdentification::getDTC () const {
    return _DTC;
}

inline void T_SnapshotIdentification::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void T_SnapshotIdentification::clearRecordNumber() {
    if (hasRecordNumber()) {
         clear_has_RecordNumber();
        _RecordNumber = 0u;
     }
}

inline bool T_SnapshotIdentification::hasRecordNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_SnapshotIdentification::getRecordNumber () const {
    return _RecordNumber;
}

inline void T_SnapshotIdentification::setRecordNumber (uint8 RecordNumber_) {
    set_has_RecordNumber();
    this->_RecordNumber = RecordNumber_;
}

inline void T_SnapshotIdentification::set_has_DTC () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SnapshotIdentification::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SnapshotIdentification::set_has_RecordNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SnapshotIdentification::clear_has_RecordNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_SendNextTestResultStructure::T_SendNextTestResultStructure ()  :
    _Status (false),
    _SendNextTestResReason (::diaglog_main_fi_types::T_e8_SendNextTestResReason__CLEAR_CODE),
    _ITCList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_SendNextTestResultStructure::T_SendNextTestResultStructure (const T_SendNextTestResultStructure &rhs)  :
    _Status (false),
    _SendNextTestResReason (::diaglog_main_fi_types::T_e8_SendNextTestResReason__CLEAR_CODE),
    _ITCList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_SendNextTestResultStructure::T_SendNextTestResultStructure (bool Status_, T_e8_SendNextTestResReason SendNextTestResReason_, const ::std::vector< uint16 >& ITCList_)  :
    _Status (Status_),
    _SendNextTestResReason (SendNextTestResReason_),
    _ITCList (ITCList_)
{
    #ifndef NDEBUG
    if (!(T_e8_SendNextTestResReason_IsValid(SendNextTestResReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SendNextTestResReason_, "T_e8_SendNextTestResReason", "SendNextTestResReason", "T_SendNextTestResultStructure");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_SendNextTestResultStructure::~T_SendNextTestResultStructure() {
}

inline T_SendNextTestResultStructure& T_SendNextTestResultStructure::operator = (const T_SendNextTestResultStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
        if (rhs.hasSendNextTestResReason()) {
            setSendNextTestResReason(rhs.getSendNextTestResReason());
        } else {
            clearSendNextTestResReason();
        }
        if (rhs.hasITCList()) {
            setITCList(rhs.getITCList());
        } else {
            clearITCList();
        }
    }
    return *this;
}

inline bool T_SendNextTestResultStructure::operator == (const T_SendNextTestResultStructure& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()) &&
        ((!hasSendNextTestResReason() && !rhs.hasSendNextTestResReason()) || getSendNextTestResReason() == rhs.getSendNextTestResReason()) &&
        ((!hasITCList() && !rhs.hasITCList()) || getITCList() == rhs.getITCList()));
}

inline bool T_SendNextTestResultStructure::operator != (const T_SendNextTestResultStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool T_SendNextTestResultStructure::operator < (const T_SendNextTestResultStructure& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    if (hasSendNextTestResReason() || rhs.hasSendNextTestResReason()) {
        if ((uint32)getSendNextTestResReason() < (uint32)rhs.getSendNextTestResReason()) return true;
        if ((uint32)getSendNextTestResReason() > (uint32)rhs.getSendNextTestResReason()) return false;
    }
    if (hasITCList() || rhs.hasITCList()) {
        if (getITCList() < rhs.getITCList()) return true;
        if (getITCList() > rhs.getITCList()) return false;
    }
    return false;
}

inline bool T_SendNextTestResultStructure::operator > (const T_SendNextTestResultStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_SendNextTestResultStructure::clear() {
    clearStatus();
    clearSendNextTestResReason();
    clearITCList();
}

inline void T_SendNextTestResultStructure::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool T_SendNextTestResultStructure::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_SendNextTestResultStructure::getStatus () const {
    return _Status;
}

inline void T_SendNextTestResultStructure::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void T_SendNextTestResultStructure::clearSendNextTestResReason() {
    if (hasSendNextTestResReason()) {
         clear_has_SendNextTestResReason();
        _SendNextTestResReason = ::diaglog_main_fi_types::T_e8_SendNextTestResReason__CLEAR_CODE;
     }
}

inline bool T_SendNextTestResultStructure::hasSendNextTestResReason () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_SendNextTestResReason T_SendNextTestResultStructure::getSendNextTestResReason () const {
    return _SendNextTestResReason;
}

inline void T_SendNextTestResultStructure::setSendNextTestResReason (T_e8_SendNextTestResReason SendNextTestResReason_) {
    #ifndef NDEBUG
    if (!(T_e8_SendNextTestResReason_IsValid(SendNextTestResReason_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", SendNextTestResReason_, "T_e8_SendNextTestResReason", "SendNextTestResReason", "T_SendNextTestResultStructure");
    }
    #endif
    set_has_SendNextTestResReason();
    this->_SendNextTestResReason = SendNextTestResReason_;
}

inline void T_SendNextTestResultStructure::clearITCList() {
    if (hasITCList()) {
         clear_has_ITCList();
        _ITCList.clear();
     }
}

inline bool T_SendNextTestResultStructure::hasITCList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::vector< uint16 >& T_SendNextTestResultStructure::getITCList () const {
    return _ITCList;
}

inline ::std::vector< uint16 >& T_SendNextTestResultStructure::getITCListMutable () {
    set_has_ITCList();
    return _ITCList;
}

inline void T_SendNextTestResultStructure::setITCList (const ::std::vector< uint16 >& ITCList_) {
    set_has_ITCList();
    this->_ITCList = ITCList_;
}

inline void T_SendNextTestResultStructure::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_SendNextTestResultStructure::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_SendNextTestResultStructure::set_has_SendNextTestResReason () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_SendNextTestResultStructure::clear_has_SendNextTestResReason () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_SendNextTestResultStructure::set_has_ITCList () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_SendNextTestResultStructure::clear_has_ITCList () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace diaglog_main_fi_types

#endif // DIAGLOG_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
