/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DIAGLOG_MAIN_FIPROXY_H
#define DIAGLOG_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "diaglog_diagnostics_fi_typesConst.h"
#include "diaglog_main_fi.h"
#include "diaglog_main_fi_types.h"
#include "diaglog_main_fi_typesConst.h"
#include <map>
#include <vector>

namespace diaglog_main_fi {

class Diaglog_main_fiProxy;

class ClearDTCCallbackIF {
public:
    virtual ~ClearDTCCallbackIF() {}

    virtual void onClearDTCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ClearDTCError >& error) = 0;

    virtual void onClearDTCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ClearDTCResult >& result) = 0;
};

class ControlCallbackIF {
public:
    virtual ~ControlCallbackIF() {}

    virtual void onControlError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ControlError >& error) = 0;

    virtual void onControlResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ControlResult >& result) = 0;
};

class ControlDtcSettingCallbackIF {
public:
    virtual ~ControlDtcSettingCallbackIF() {}

    virtual void onControlDtcSettingError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ControlDtcSettingError >& error) = 0;

    virtual void onControlDtcSettingResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ControlDtcSettingResult >& result) = 0;
};

class CustomerClearRequestCallbackIF {
public:
    virtual ~CustomerClearRequestCallbackIF() {}

    virtual void onCustomerClearRequestError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< CustomerClearRequestError >& error) = 0;

    virtual void onCustomerClearRequestResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< CustomerClearRequestResult >& result) = 0;
};

class CustomerReadRequestCallbackIF {
public:
    virtual ~CustomerReadRequestCallbackIF() {}

    virtual void onCustomerReadRequestError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< CustomerReadRequestError >& error) = 0;

    virtual void onCustomerReadRequestResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< CustomerReadRequestResult >& result) = 0;
};

class DTCActiveCallbackIF {
public:
    virtual ~DTCActiveCallbackIF() {}

    virtual void onDTCActiveError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< DTCActiveError >& error) = 0;

    virtual void onDTCActiveStatus(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< DTCActiveStatus >& status) = 0;
};

class DTCTriggeredCallbackIF {
public:
    virtual ~DTCTriggeredCallbackIF() {}

    virtual void onDTCTriggeredError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< DTCTriggeredError >& error) = 0;

    virtual void onDTCTriggeredStatus(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< DTCTriggeredStatus >& status) = 0;
};

class DtcStatusChangedCallbackIF {
public:
    virtual ~DtcStatusChangedCallbackIF() {}

    virtual void onDtcStatusChangedError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< DtcStatusChangedError >& error) = 0;

    virtual void onDtcStatusChangedStatus(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< DtcStatusChangedStatus >& status) = 0;
};

class GetDTCbyStatusMaskCallbackIF {
public:
    virtual ~GetDTCbyStatusMaskCallbackIF() {}

    virtual void onGetDTCbyStatusMaskError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDTCbyStatusMaskError >& error) = 0;

    virtual void onGetDTCbyStatusMaskResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetDTCbyStatusMaskResult >& result) = 0;
};

class GetExtendedDataByDTCCallbackIF {
public:
    virtual ~GetExtendedDataByDTCCallbackIF() {}

    virtual void onGetExtendedDataByDTCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetExtendedDataByDTCError >& error) = 0;

    virtual void onGetExtendedDataByDTCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetExtendedDataByDTCResult >& result) = 0;
};

class GetItcInformationCallbackIF {
public:
    virtual ~GetItcInformationCallbackIF() {}

    virtual void onGetItcInformationError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetItcInformationError >& error) = 0;

    virtual void onGetItcInformationResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetItcInformationResult >& result) = 0;
};

class GetLastConfirmedDTCCallbackIF {
public:
    virtual ~GetLastConfirmedDTCCallbackIF() {}

    virtual void onGetLastConfirmedDTCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetLastConfirmedDTCError >& error) = 0;

    virtual void onGetLastConfirmedDTCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetLastConfirmedDTCResult >& result) = 0;
};

class GetNumberOfDTCByStatusMaskCallbackIF {
public:
    virtual ~GetNumberOfDTCByStatusMaskCallbackIF() {}

    virtual void onGetNumberOfDTCByStatusMaskError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetNumberOfDTCByStatusMaskError >& error) = 0;

    virtual void onGetNumberOfDTCByStatusMaskResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetNumberOfDTCByStatusMaskResult >& result) = 0;
};

class GetStatusByDTCCallbackIF {
public:
    virtual ~GetStatusByDTCCallbackIF() {}

    virtual void onGetStatusByDTCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStatusByDTCError >& error) = 0;

    virtual void onGetStatusByDTCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStatusByDTCResult >& result) = 0;
};

class GetStatusByITCCallbackIF {
public:
    virtual ~GetStatusByITCCallbackIF() {}

    virtual void onGetStatusByITCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStatusByITCError >& error) = 0;

    virtual void onGetStatusByITCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetStatusByITCResult >& result) = 0;
};

class GetSupportedDTCCallbackIF {
public:
    virtual ~GetSupportedDTCCallbackIF() {}

    virtual void onGetSupportedDTCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSupportedDTCError >& error) = 0;

    virtual void onGetSupportedDTCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< GetSupportedDTCResult >& result) = 0;
};

class ProductionClearRequestCallbackIF {
public:
    virtual ~ProductionClearRequestCallbackIF() {}

    virtual void onProductionClearRequestError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ProductionClearRequestError >& error) = 0;

    virtual void onProductionClearRequestResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ProductionClearRequestResult >& result) = 0;
};

class ProductionReadRequestCallbackIF {
public:
    virtual ~ProductionReadRequestCallbackIF() {}

    virtual void onProductionReadRequestError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ProductionReadRequestError >& error) = 0;

    virtual void onProductionReadRequestResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ProductionReadRequestResult >& result) = 0;
};

class ReportDTCSnapshotIdentificationCallbackIF {
public:
    virtual ~ReportDTCSnapshotIdentificationCallbackIF() {}

    virtual void onReportDTCSnapshotIdentificationError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ReportDTCSnapshotIdentificationError >& error) = 0;

    virtual void onReportDTCSnapshotIdentificationResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ReportDTCSnapshotIdentificationResult >& result) = 0;
};

class ReportDTCSnapshotRecordByDTCNumberCallbackIF {
public:
    virtual ~ReportDTCSnapshotRecordByDTCNumberCallbackIF() {}

    virtual void onReportDTCSnapshotRecordByDTCNumberError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ReportDTCSnapshotRecordByDTCNumberError >& error) = 0;

    virtual void onReportDTCSnapshotRecordByDTCNumberResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< ReportDTCSnapshotRecordByDTCNumberResult >& result) = 0;
};

class SaveTestResultCallbackIF {
public:
    virtual ~SaveTestResultCallbackIF() {}

    virtual void onSaveTestResultError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SaveTestResultError >& error) = 0;

    virtual void onSaveTestResultResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SaveTestResultResult >& result) = 0;
};

class SaveTestResultDynamicalDTCCallbackIF {
public:
    virtual ~SaveTestResultDynamicalDTCCallbackIF() {}

    virtual void onSaveTestResultDynamicalDTCError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SaveTestResultDynamicalDTCError >& error) = 0;

    virtual void onSaveTestResultDynamicalDTCResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SaveTestResultDynamicalDTCResult >& result) = 0;
};

class SendActiveDTCListCallbackIF {
public:
    virtual ~SendActiveDTCListCallbackIF() {}

    virtual void onSendActiveDTCListError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SendActiveDTCListError >& error) = 0;

    virtual void onSendActiveDTCListStatus(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SendActiveDTCListStatus >& status) = 0;
};

class SendNextTestResultCallbackIF {
public:
    virtual ~SendNextTestResultCallbackIF() {}

    virtual void onSendNextTestResultError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SendNextTestResultError >& error) = 0;

    virtual void onSendNextTestResultStatus(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SendNextTestResultStatus >& status) = 0;
};

class SetFactorySettingsNewCallbackIF {
public:
    virtual ~SetFactorySettingsNewCallbackIF() {}

    virtual void onSetFactorySettingsNewError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsNewError >& error) = 0;

    virtual void onSetFactorySettingsNewResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< SetFactorySettingsNewResult >& result) = 0;
};

class WriteToMediaCallbackIF {
public:
    virtual ~WriteToMediaCallbackIF() {}

    virtual void onWriteToMediaError(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< WriteToMediaError >& error) = 0;

    virtual void onWriteToMediaResult(const ::boost::shared_ptr< Diaglog_main_fiProxy >& proxy, const ::boost::shared_ptr< WriteToMediaResult >& result) = 0;
};

class Diaglog_main_fiProxyCallback;

/**
 * Diaglog_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'diaglog_main_fi' (specified in file
 * diaglog_main_fi.xml).
 *
 * CCA Functional Interface 'diaglog_main_fi'
 *
 * Fullname: Middleware DiagLog Application Functional Interface
 *
 * Version: v$Revision:   3.1.0.0  $
 *
 * Author: Lars Plischke
 *
 * Date: $Date:   Aug 29 2013 12:00:00  $
 *
 * Department:
 *
 * Title: diaglog_main_fi
 *
 * <b>Description of 'diaglog_main_fi':</b>
 *
 * ..
 */
class Diaglog_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Diaglog_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Diaglog_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Diaglog_main_fiProxy. The caller has to pass
     * the port name and the service information. It is only possible to use
     * this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Diaglog_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Diaglog_main_fiProxy. The caller has to pass
     * the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Diaglog_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Diaglog_main_fiProxy. The destructor will send RelUpReg
     * messages for all property notifications and call the error callback of
     * all pending method invocations.
     */
    ~Diaglog_main_fiProxy();

    // Method 'SaveTestResult'

    /**
     * Call the method 'SaveTestResult'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'SaveTestResult'</b>:
     *
     * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_SAVETESTRESULT
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TestResultList A list of test results.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveTestResultStart(SaveTestResultCallbackIF& cb, const ::diaglog_main_fi_types::T_TestResultList& testResultList);

    // Method 'SaveTestResultDynamicalDTC'

    /**
     * Call the method 'SaveTestResultDynamicalDTC'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SaveTestResultDynamicalDTC'</b>:
     *
     * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
     * This given TroubleCode Number is a real DTC Number and will not checked by Diaglog on validity. They will still added to the DTC List                                       0x8200  if reserved memory is still available.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_SAVETESTRESULTDYNAMICALDTC
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param TestResultList A list of test results.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSaveTestResultDynamicalDTCStart(SaveTestResultDynamicalDTCCallbackIF& cb, const ::diaglog_main_fi_types::T_TestResultList& testResultList);

    // Method 'ProductionReadRequest'

    /**
     * Call the method 'ProductionReadRequest'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ProductionReadRequest'</b>:
     *
     * This method forwards the status mask of a production read request message from external production test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Protocol Protocol to use
     *
     * @param StatusMask The status mask as received from the production tester equipment.
     *
     * @param ITCMask The ITC mask as received from the production tester equipment. DEFAULT:0xFFFFFFFF
     *
     * @param Option The Option for special behaviour DEFAULT:0x00.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProductionReadRequestStart(ProductionReadRequestCallbackIF& cb, ::diaglog_main_fi_types::T_e8_Protocol protocol, uint8 statusMask, uint32 iTCMask, uint32 option);

    // Method 'CustomerReadRequest'

    /**
     * Call the method 'CustomerReadRequest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CustomerReadRequest'</b>:
     *
     * This method forwards the status mask of a customer read request message from external production test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_CUSTOMERREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Protocol Protocol to use
     *
     * @param StatusMask The status mask as received from the customer tester equipment.
     *
     * @param DTCMask The DTC mask as received from the production tester equipment.
     *
     * @param Option The Option for special behaviour (for further use).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCustomerReadRequestStart(CustomerReadRequestCallbackIF& cb, ::diaglog_main_fi_types::T_e8_Protocol protocol, uint8 statusMask, uint32 dTCMask, uint32 option);

    // Method 'getItcInformation'

    /**
     * Call the method 'getItcInformation'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getItcInformation'</b>:
     *
     * This method read out all ITC information given by an List of ITC's
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_GETITCINFORMATION
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param ITCList List of the ITCs
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetItcInformationStart(GetItcInformationCallbackIF& cb, uint8 group, const ::std::vector< uint16 >& iTCList);

    // Method 'ProductionClearRequest'

    /**
     * Call the method 'ProductionClearRequest'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'ProductionClearRequest'</b>:
     *
     * This method forwards a production clear request message from external production test equipment to the DiagLog component. Only to be used by the Diagnostic component!
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONCLEARREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProductionClearRequestStart(ProductionClearRequestCallbackIF& cb);

    // Method 'CustomerClearRequest'

    /**
     * Call the method 'CustomerClearRequest'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'CustomerClearRequest'</b>:
     *
     * This method forwards a customer clear request message from external customer test equipment to the DiagLog component. Only to be used by the Diagnostic component!
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_CUSTOMERCLEARREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCustomerClearRequestStart(CustomerClearRequestCallbackIF& cb);

    // Method 'WriteToMedia'

    /**
     * Call the method 'WriteToMedia'. This method sends a MethodStart message
     * to the CCA server.
     *
     * <b>Documentation of 'WriteToMedia'</b>:
     *
     * This methods writes the Diaglog contents to the specified media.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_WRITETOMEDIA
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Media Specifies the media to be written to.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendWriteToMediaStart(WriteToMediaCallbackIF& cb, ::diaglog_main_fi_types::T_e8_VDLMediaType media);

    // Method 'getDTCbyStatusMask'

    /**
     * Call the method 'getDTCbyStatusMask'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getDTCbyStatusMask'</b>:
     *
     * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param StatusMask The status mask as received from the production tester equipment.
     *
     * @param DTCMask The DTC mask as received from the production tester equipment.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetDTCbyStatusMaskStart(GetDTCbyStatusMaskCallbackIF& cb, uint8 group, uint8 statusMask, uint32 dTCMask);

    // Method 'getLastConfirmedDTC'

    /**
     * Call the method 'getLastConfirmedDTC'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getLastConfirmedDTC'</b>:
     *
     * This method forwards the last confirmed DTC from external test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetLastConfirmedDTCStart(GetLastConfirmedDTCCallbackIF& cb, uint8 group);

    // Method 'getSupportedDTC'

    /**
     * Call the method 'getSupportedDTC'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getSupportedDTC'</b>:
     *
     * This method forwards the supported DTC List from external production test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSupportedDTCStart(GetSupportedDTCCallbackIF& cb, uint8 group);

    // Method 'getNumberOfDTCByStatusMask'

    /**
     * Call the method 'getNumberOfDTCByStatusMask'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'getNumberOfDTCByStatusMask'</b>:
     *
     * This method forwards the Number of DTC's matched with StatusMask from external production test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param StatusMask The status mask as received from the production tester equipment.
     *
     * @param DTCMask The DTC mask as received from the production tester equipment.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetNumberOfDTCByStatusMaskStart(GetNumberOfDTCByStatusMaskCallbackIF& cb, uint8 group, uint8 statusMask, uint32 dTCMask);

    // Method 'getStatusByDTC'

    /**
     * Call the method 'getStatusByDTC'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getStatusByDTC'</b>:
     *
     * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param DTCMask The status mask as received from the production tester equipment.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetStatusByDTCStart(GetStatusByDTCCallbackIF& cb, uint8 group, uint32 dTCMask);

    // Method 'getExtendedDataByDTC'

    /**
     * Call the method 'getExtendedDataByDTC'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getExtendedDataByDTC'</b>:
     *
     * This method forwards the Extended Data of a given DTC's from external test equipment to the DiagLog component.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param DTC The DTC as received from the production tester equipment.
     *
     * @param DTCExtDataRecordNumber Defines the ExtData to Read.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetExtendedDataByDTCStart(GetExtendedDataByDTCCallbackIF& cb, uint8 group, uint32 dTC, uint8 dTCExtDataRecordNumber);

    // Method 'getStatusByITC'

    /**
     * Call the method 'getStatusByITC'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'getStatusByITC'</b>:
     *
     * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param ITCMask The status mask as received from the production tester equipment.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetStatusByITCStart(GetStatusByITCCallbackIF& cb, uint8 group, uint32 iTCMask);

    // Method 'reportDTCSnapshotIdentification'

    /**
     * Call the method 'reportDTCSnapshotIdentification'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'reportDTCSnapshotIdentification'</b>:
     *
     * This method forwards the SnapShot Data for all captured DTCSnapshots
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReportDTCSnapshotIdentificationStart(ReportDTCSnapshotIdentificationCallbackIF& cb, uint8 group);

    // Method 'reportDTCSnapshotRecordByDTCNumber'

    /**
     * Call the method 'reportDTCSnapshotRecordByDTCNumber'. This method sends
     * a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'reportDTCSnapshotRecordByDTCNumber'</b>:
     *
     * This method forwards the SnapShot Data for a specific DTC
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group
     *
     * @param DTC The DTC as received from the production tester equipment.
     *
     * @param DTCSnapshotRecordNumber Defines the ExtData to Read.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReportDTCSnapshotRecordByDTCNumberStart(ReportDTCSnapshotRecordByDTCNumberCallbackIF& cb, uint8 group, uint32 dTC, uint8 dTCSnapshotRecordNumber);

    // Method 'clearDTC'

    /**
     * Call the method 'clearDTC'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'clearDTC'</b>:
     *
     * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_PRODUCTIONREADREQUEST
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param Group Errormemory Group; 0xFF = All
     *
     * @param DTCMask DTC Mask 0xFFFFFF = no mask
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearDTCStart(ClearDTCCallbackIF& cb, uint8 group, uint32 dTCMask);

    // Method 'Control'

    /**
     * Call the method 'Control'. This method sends a MethodStart message to
     * the CCA server.
     *
     * <b>Documentation of 'Control'</b>:
     *
     * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_CONTROL
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ControlParameter Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendControlStart(ControlCallbackIF& cb, ::diaglog_main_fi_types::T_e8_ControlParameter controlParameter);

    // Method 'ControlDtcSetting'

    /**
     * Call the method 'ControlDtcSetting'. This method sends a MethodStart
     * message to the CCA server.
     *
     * <b>Documentation of 'ControlDtcSetting'</b>:
     *
     * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_CONTROL
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ControlParameter Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @param DTC_List Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendControlDtcSettingStart(ControlDtcSettingCallbackIF& cb, ::diaglog_main_fi_types::T_e8_ControlParameter controlParameter, const ::diaglog_main_fi_types::T_ControlList& dTC_List);

    // Method 'SetFactorySettingsNew'

    /**
     * Call the method 'SetFactorySettingsNew'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetFactorySettingsNew'</b>:
     *
     * This function request the component to set all Variables (depending on USER                                       0x8200  TEF or OEM) to default
     * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS                                       0x8200</p>
     * <p>Service ID - CCA_C_U16_SRV_DIAGLOG                                       0x8200</p>
     * <p>App ID - CCA_C_U16_APP_DIAGLOG                                       0x8200</p>
     * <p>Function ID - DIAGLOG_MAINFI_C_U16_SETFACTORYSETTINGSNEW</p>
     * <p>The following points have to support by each component:</p>
     * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components                                       0x8200  else a Timeout occurred.
     * The Answer SetFactorySettings MessageResult must be send immediately.
     * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param DefSetStateGroup Unique Diaglog Group
     *
     * @param DefSetStateMode current Default Setting Id.
     * <p>E.g. USER                                       0x8200  TEF                                       0x8200  OEM                                       0x8200  GET</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFactorySettingsNewStart(SetFactorySettingsNewCallbackIF& cb, ::diaglog_main_fi_types::T_e8_DiaglogDefsetType defSetStateGroup, ::diaglog_diagnostics_fi_types::T_e8_DefSetMode defSetStateMode);

    // Property 'DTCActive'

    /**
     * Notify on the property 'DTCActive'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'DTCActive'</b>:
     *
     * This property indicates that at least one DTC is active.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_DTCACTIVE
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTCActiveUpReg(DTCActiveCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DTCActive'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DTCActive'</b>:
     *
     * This property indicates that at least one DTC is active.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_DTCACTIVE
     *
     * @param act The act which was previously returned by the
     * sendDTCActiveUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDTCActiveRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DTCActive'.
     */
    void sendDTCActiveRelUpRegAll ();

    /**
     * Returns the current value of the property 'DTCActive' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDTCActive()
     * returns true.
     *
     * @return the previously received value of the property 'DTCActive'.
     */
    const DTCActiveStatus& getDTCActive() const;

    /**
     * Determines whether a status message for the property 'DTCActive' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDTCActive() const;

    /**
     * Request the value of the property 'DTCActive' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DTCActive'</b>:
     *
     * This property indicates that at least one DTC is active.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_DTCACTIVE
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     * @param IsDTCActive True if at least one DTC is active.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTCActiveGet(DTCActiveCallbackIF& cb, bool isDTCActive);

    // Property 'SendNextTestResult'

    /**
     * Notify on the property 'SendNextTestResult'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SendNextTestResult'</b>:
     *
     * This property indicates that the client should update the DiagLog with the status of DTCs AFTER the next tests to determine that status.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_SENDNEXTTESTRESULT
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendNextTestResultUpReg(SendNextTestResultCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SendNextTestResult'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SendNextTestResult'</b>:
     *
     * This property indicates that the client should update the DiagLog with the status of DTCs AFTER the next tests to determine that status.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_SENDNEXTTESTRESULT
     *
     * @param act The act which was previously returned by the
     * sendSendNextTestResultUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSendNextTestResultRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SendNextTestResult'.
     */
    void sendSendNextTestResultRelUpRegAll ();

    /**
     * Returns the current value of the property 'SendNextTestResult' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasSendNextTestResult() returns true.
     *
     * @return the previously received value of the property 'SendNextTestResult'.
     */
    const SendNextTestResultStatus& getSendNextTestResult() const;

    /**
     * Determines whether a status message for the property 'SendNextTestResult' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSendNextTestResult() const;

    // Property 'DTCTriggered'

    /**
     * Notify on the property 'DTCTriggered'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DTCTriggered'</b>:
     *
     * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
     * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
     * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTCTriggeredUpReg(DTCTriggeredCallbackIF& cb);

    /**
     * Remove the notifcation on property 'DTCTriggered'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DTCTriggered'</b>:
     *
     * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
     * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
     * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
     *
     * @param act The act which was previously returned by the
     * sendDTCTriggeredUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDTCTriggeredRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DTCTriggered'.
     */
    void sendDTCTriggeredRelUpRegAll ();

    /**
     * Returns the current value of the property 'DTCTriggered' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDTCTriggered() returns true.
     *
     * @return the previously received value of the property 'DTCTriggered'.
     */
    const DTCTriggeredStatus& getDTCTriggered() const;

    /**
     * Determines whether a status message for the property 'DTCTriggered' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDTCTriggered() const;

    /**
     * Request the value of the property 'DTCTriggered' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'DTCTriggered'</b>:
     *
     * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
     * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
     * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDTCTriggeredGet(DTCTriggeredCallbackIF& cb);

    // Property 'SendActiveDTCList'

    /**
     * Notify on the property 'SendActiveDTCList'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'SendActiveDTCList'</b>:
     *
     * This property indicates that there has been a change in status of a DTC and new list of active DTCs is sentto the clients.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_SENDACTIVEDTCLIST
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSendActiveDTCListUpReg(SendActiveDTCListCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SendActiveDTCList'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SendActiveDTCList'</b>:
     *
     * This property indicates that there has been a change in status of a DTC and new list of active DTCs is sentto the clients.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_SENDACTIVEDTCLIST
     *
     * @param act The act which was previously returned by the
     * sendSendActiveDTCListUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSendActiveDTCListRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SendActiveDTCList'.
     */
    void sendSendActiveDTCListRelUpRegAll ();

    /**
     * Returns the current value of the property 'SendActiveDTCList' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSendActiveDTCList() returns true.
     *
     * @return the previously received value of the property 'SendActiveDTCList'.
     */
    const SendActiveDTCListStatus& getSendActiveDTCList() const;

    /**
     * Determines whether a status message for the property 'SendActiveDTCList' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSendActiveDTCList() const;

    // Property 'DtcStatusChanged'

    /**
     * Notify on the property 'DtcStatusChanged'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'DtcStatusChanged'</b>:
     *
     * This property indicates that there has been a change in status of one specific DTC and current status of DTC is sent to the clients.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_DTCSTATUSCHANGED
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     * @param Group Errormemory Group
     *
     * @param DTCNumber This is three bytes number of the specific DTC to be notified.
     *
     * @param DTCStatusBitMask This is mask for the DTC to be used for notification (DTC Status Bit Mask 0xFF = no mask).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDtcStatusChangedUpReg(DtcStatusChangedCallbackIF& cb, uint8 group, uint32 dTCNumber, uint8 dTCStatusBitMask);

    /**
     * Remove the notifcation on property 'DtcStatusChanged'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'DtcStatusChanged'</b>:
     *
     * This property indicates that there has been a change in status of one specific DTC and current status of DTC is sent to the clients.
     * App ID - CCA_C_U16_APP_DIAGLOG
     * Service ID - CCA_C_U16_SRV_DIAGLOG
     * Function ID - DIAGLOG_MAINFI_C_U16_DTCSTATUSCHANGED
     *
     * @param act The act which was previously returned by the
     * sendDtcStatusChangedUpReg() method.
     *
     * @param Group Errormemory Group
     *
     * @param DTCNumber This is three bytes number of the specific DTC to be notified.
     *
     * @param DTCStatusBitMask This is mask for the DTC to be used for notification (DTC Status Bit Mask 0xFF = no mask).
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendDtcStatusChangedRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'DtcStatusChanged'.
     */
    void sendDtcStatusChangedRelUpRegAll ();

    /**
     * Returns the current value of the property 'DtcStatusChanged' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDtcStatusChanged(uint8 group, uint32 dTCNumber, uint8
     * dTCStatusBitMask) returns true.
     *
     * @return the previously received value of the property 'DtcStatusChanged'.
     */
    const DtcStatusChangedStatus& getDtcStatusChanged(uint8 group, uint32 dTCNumber, uint8 dTCStatusBitMask) const;

    /**
     * Determines whether a status message for the property 'DtcStatusChanged'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDtcStatusChanged(uint8 group, uint32 dTCNumber, uint8 dTCStatusBitMask) const;

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Diaglog_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'DTCActive'

    ::asf::core::nullable< DTCActiveStatus > _dTCActive;

    // Property 'SendNextTestResult'

    ::asf::core::nullable< SendNextTestResultStatus > _sendNextTestResult;

    // Property 'DTCTriggered'

    ::asf::core::nullable< DTCTriggeredStatus > _dTCTriggered;

    // Property 'SendActiveDTCList'

    ::asf::core::nullable< SendActiveDTCListStatus > _sendActiveDTCList;

    // Property 'DtcStatusChanged'

    typedef std::map<DtcStatusChangedRelUpReg, DtcStatusChangedStatus > DtcStatusChangedMap;
    DtcStatusChangedMap _dtcStatusChangedMap;

    DECLARE_CLASS_LOGGER();

    friend class Diaglog_main_fiProxyCallback;
};

} // namespace diaglog_main_fi

#endif // DIAGLOG_MAIN_FIPROXY_H
