#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef MIDW_DIAGLOG_FI_H
#define MIDW_DIAGLOG_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "midw_diaglog_fi_types.h"
#include "midw_diaglog_fi_typesConst.h"
#include "midw_diagnostics_fi_typesConst.h"
#include <cstring>
#include <vector>

/**
 * CCA Functional Interface 'Midw_DiagLog_FI'
 *
 * Fullname: Middleware DiagLog Application Functional Interface
 *
 * Version: v$Revision:   3.1.0.0  $
 *
 * Author: Lars Plischke
 *
 * Date: $Date:   Aug 29 2013 12:00:00  $
 *
 * Department:
 *
 * Title: Midw_Diaglog_FI
 *
 * <b>Description of 'Midw_DiagLog_FI':</b>
 *
 * ..
 */

namespace Midw_DiagLog_FI {

static const int SERVICE_ID = 112;

static const int FID_SaveTestResult = 1;

static const int FID_SaveTestResultDynamicalDTC = 2;

static const int FID_ProductionReadRequest = 33;

static const int FID_CustomerReadRequest = 34;

static const int FID_getItcInformation = 35;

static const int FID_ProductionClearRequest = 49;

static const int FID_CustomerClearRequest = 50;

static const int FID_WriteToMedia = 9;

static const int FID_DTCActive = 8;

static const int FID_SendNextTestResult = 10;

static const int FID_getDTCbyStatusMask = 80;

static const int FID_getLastConfirmedDTC = 81;

static const int FID_getSupportedDTC = 82;

static const int FID_getNumberOfDTCByStatusMask = 83;

static const int FID_getStatusByDTC = 84;

static const int FID_getExtendedDataByDTC = 85;

static const int FID_getStatusByITC = 87;

static const int FID_reportDTCSnapshotIdentification = 88;

static const int FID_reportDTCSnapshotRecordByDTCNumber = 89;

static const int FID_clearDTC = 96;

static const int FID_Control = 4;

static const int FID_ControlDtcSetting = 112;

static const int FID_DTCTriggered = 560;

static const int FID_SetFactorySettingsNew = 128;

static const int FID_SendActiveDTCList = 3;

static const int FID_DtcStatusChanged = 5;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 6;

static const int VERSION_PATCH = 0;

// forward declarations
class SaveTestResultStart;

class SaveTestResultResult;

class SaveTestResultDynamicalDTCStart;

class SaveTestResultDynamicalDTCResult;

class ProductionReadRequestStart;

class ProductionReadRequestResult;

class CustomerReadRequestStart;

class CustomerReadRequestResult;

class GetItcInformationStart;

class GetItcInformationResult;

class ProductionClearRequestResult;

class CustomerClearRequestResult;

class WriteToMediaStart;

class WriteToMediaResult;

class DTCActiveStatus;

class DTCActiveGet;

class SendNextTestResultStatus;

class GetDTCbyStatusMaskStart;

class GetDTCbyStatusMaskResult;

class GetLastConfirmedDTCStart;

class GetLastConfirmedDTCResult;

class GetSupportedDTCStart;

class GetSupportedDTCResult;

class GetNumberOfDTCByStatusMaskStart;

class GetNumberOfDTCByStatusMaskResult;

class GetStatusByDTCStart;

class GetStatusByDTCResult;

class GetExtendedDataByDTCStart;

class GetExtendedDataByDTCResult;

class GetStatusByITCStart;

class GetStatusByITCResult;

class ReportDTCSnapshotIdentificationStart;

class ReportDTCSnapshotIdentificationResult;

class ReportDTCSnapshotRecordByDTCNumberStart;

class ReportDTCSnapshotRecordByDTCNumberResult;

class ClearDTCStart;

class ClearDTCResult;

class ControlStart;

class ControlResult;

class ControlDtcSettingStart;

class ControlDtcSettingResult;

class DTCTriggeredStatus;

class SetFactorySettingsNewStart;

class SetFactorySettingsNewResult;

class SendActiveDTCListStatus;

class DtcStatusChangedStatus;

class DtcStatusChangedUpReg;

class DtcStatusChangedRelUpReg;

// type definitions
/**
 * The abort error message of the method "SaveTestResult"
 * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
 */
typedef ::asf::cca::CcaTypes::DefaultError SaveTestResultAbortError;

/**
 * The error message of 'SaveTestResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError SaveTestResultError;

/**
 * The abort error message of the method "SaveTestResultDynamicalDTC"
 * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
 * This given TroubleCode Number is a real DTC Number and will not checked by Diaglog on validity. They will still added to the DTC List                                       0x8200  if reserved memory is still available.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SAVETESTRESULTDYNAMICALDTC
 */
typedef ::asf::cca::CcaTypes::DefaultError SaveTestResultDynamicalDTCAbortError;

/**
 * The error message of 'SaveTestResultDynamicalDTC'
 */
typedef ::asf::cca::CcaTypes::DefaultError SaveTestResultDynamicalDTCError;

/**
 * The abort error message of the method "ProductionReadRequest"
 * This method forwards the status mask of a production read request message from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError ProductionReadRequestAbortError;

/**
 * The error message of 'ProductionReadRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ProductionReadRequestError;

/**
 * The abort error message of the method "CustomerReadRequest"
 * This method forwards the status mask of a customer read request message from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CUSTOMERREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError CustomerReadRequestAbortError;

/**
 * The error message of 'CustomerReadRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError CustomerReadRequestError;

/**
 * The abort error message of the method "getItcInformation"
 * This method read out all ITC information given by an List of ITC's
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_GETITCINFORMATION
 */
typedef ::asf::cca::CcaTypes::DefaultError GetItcInformationAbortError;

/**
 * The error message of 'getItcInformation'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetItcInformationError;

/**
 * The start message of the method "ProductionClearRequest"
 * This method forwards a production clear request message from external production test equipment to the DiagLog component. Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONCLEARREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultMessage ProductionClearRequestStart;

/**
 * The abort error message of the method "ProductionClearRequest"
 * This method forwards a production clear request message from external production test equipment to the DiagLog component. Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONCLEARREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError ProductionClearRequestAbortError;

/**
 * The error message of 'ProductionClearRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError ProductionClearRequestError;

/**
 * The start message of the method "CustomerClearRequest"
 * This method forwards a customer clear request message from external customer test equipment to the DiagLog component. Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CUSTOMERCLEARREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultMessage CustomerClearRequestStart;

/**
 * The abort error message of the method "CustomerClearRequest"
 * This method forwards a customer clear request message from external customer test equipment to the DiagLog component. Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CUSTOMERCLEARREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError CustomerClearRequestAbortError;

/**
 * The error message of 'CustomerClearRequest'
 */
typedef ::asf::cca::CcaTypes::DefaultError CustomerClearRequestError;

/**
 * The abort error message of the method "WriteToMedia"
 * This methods writes the Diaglog contents to the specified media.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_WRITETOMEDIA
 */
typedef ::asf::cca::CcaTypes::DefaultError WriteToMediaAbortError;

/**
 * The error message of 'WriteToMedia'
 */
typedef ::asf::cca::CcaTypes::DefaultError WriteToMediaError;

/**
 * The upreg message of the property "DTCActive"
 * This property indicates that at least one DTC is active.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCACTIVE
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTCActiveUpReg;

/**
 * The relUpReg message of the property "DTCActive"
 * This property indicates that at least one DTC is active.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCACTIVE
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTCActiveRelUpReg;

/**
 * The error message of 'DTCActive'
 */
typedef ::asf::cca::CcaTypes::DefaultError DTCActiveError;

/**
 * The upreg message of the property "SendNextTestResult"
 * This property indicates that the client should update the DiagLog with the status of DTCs AFTER the next tests to determine that status.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendNextTestResultUpReg;

/**
 * The relUpReg message of the property "SendNextTestResult"
 * This property indicates that the client should update the DiagLog with the status of DTCs AFTER the next tests to determine that status.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendNextTestResultRelUpReg;

/**
 * The error message of 'SendNextTestResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendNextTestResultError;

/**
 * The abort error message of the method "getDTCbyStatusMask"
 * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDTCbyStatusMaskAbortError;

/**
 * The error message of 'getDTCbyStatusMask'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetDTCbyStatusMaskError;

/**
 * The abort error message of the method "getLastConfirmedDTC"
 * This method forwards the last confirmed DTC from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError GetLastConfirmedDTCAbortError;

/**
 * The error message of 'getLastConfirmedDTC'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetLastConfirmedDTCError;

/**
 * The abort error message of the method "getSupportedDTC"
 * This method forwards the supported DTC List from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSupportedDTCAbortError;

/**
 * The error message of 'getSupportedDTC'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetSupportedDTCError;

/**
 * The abort error message of the method "getNumberOfDTCByStatusMask"
 * This method forwards the Number of DTC's matched with StatusMask from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError GetNumberOfDTCByStatusMaskAbortError;

/**
 * The error message of 'getNumberOfDTCByStatusMask'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetNumberOfDTCByStatusMaskError;

/**
 * The abort error message of the method "getStatusByDTC"
 * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStatusByDTCAbortError;

/**
 * The error message of 'getStatusByDTC'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStatusByDTCError;

/**
 * The abort error message of the method "getExtendedDataByDTC"
 * This method forwards the Extended Data of a given DTC's from external test equipment to the DiagLog component.
 */
typedef ::asf::cca::CcaTypes::DefaultError GetExtendedDataByDTCAbortError;

/**
 * The error message of 'getExtendedDataByDTC'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetExtendedDataByDTCError;

/**
 * The abort error message of the method "getStatusByITC"
 * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStatusByITCAbortError;

/**
 * The error message of 'getStatusByITC'
 */
typedef ::asf::cca::CcaTypes::DefaultError GetStatusByITCError;

/**
 * The abort error message of the method "reportDTCSnapshotIdentification"
 * This method forwards the SnapShot Data for all captured DTCSnapshots
 */
typedef ::asf::cca::CcaTypes::DefaultError ReportDTCSnapshotIdentificationAbortError;

/**
 * The error message of 'reportDTCSnapshotIdentification'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReportDTCSnapshotIdentificationError;

/**
 * The abort error message of the method "reportDTCSnapshotRecordByDTCNumber"
 * This method forwards the SnapShot Data for a specific DTC
 */
typedef ::asf::cca::CcaTypes::DefaultError ReportDTCSnapshotRecordByDTCNumberAbortError;

/**
 * The error message of 'reportDTCSnapshotRecordByDTCNumber'
 */
typedef ::asf::cca::CcaTypes::DefaultError ReportDTCSnapshotRecordByDTCNumberError;

/**
 * The abort error message of the method "clearDTC"
 * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearDTCAbortError;

/**
 * The error message of 'clearDTC'
 */
typedef ::asf::cca::CcaTypes::DefaultError ClearDTCError;

/**
 * The abort error message of the method "Control"
 * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CONTROL
 */
typedef ::asf::cca::CcaTypes::DefaultError ControlAbortError;

/**
 * The error message of 'Control'
 */
typedef ::asf::cca::CcaTypes::DefaultError ControlError;

/**
 * The abort error message of the method "ControlDtcSetting"
 * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CONTROL
 */
typedef ::asf::cca::CcaTypes::DefaultError ControlDtcSettingAbortError;

/**
 * The error message of 'ControlDtcSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError ControlDtcSettingError;

/**
 * The get message of the property "DTCTriggered"
 * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
 * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
 * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTCTriggeredGet;

/**
 * The upreg message of the property "DTCTriggered"
 * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
 * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
 * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTCTriggeredUpReg;

/**
 * The relUpReg message of the property "DTCTriggered"
 * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
 * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
 * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage DTCTriggeredRelUpReg;

/**
 * The error message of 'DTCTriggered'
 */
typedef ::asf::cca::CcaTypes::DefaultError DTCTriggeredError;

/**
 * The abort error message of the method "SetFactorySettingsNew"
 * This function request the component to set all Variables (depending on USER                                       0x8200  TEF or OEM) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS                                       0x8200</p>
 * <p>Service ID - CCA_C_U16_SRV_DIAGLOG                                       0x8200</p>
 * <p>App ID - CCA_C_U16_APP_DIAGLOG                                       0x8200</p>
 * <p>Function ID - MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components                                       0x8200  else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsNewAbortError;

/**
 * The error message of 'SetFactorySettingsNew'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetFactorySettingsNewError;

/**
 * The upreg message of the property "SendActiveDTCList"
 * This property indicates that there has been a change in status of a DTC and new list of active DTCs is sentto the clients.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SENDACTIVEDTCLIST
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendActiveDTCListUpReg;

/**
 * The relUpReg message of the property "SendActiveDTCList"
 * This property indicates that there has been a change in status of a DTC and new list of active DTCs is sentto the clients.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SENDACTIVEDTCLIST
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SendActiveDTCListRelUpReg;

/**
 * The error message of 'SendActiveDTCList'
 */
typedef ::asf::cca::CcaTypes::DefaultError SendActiveDTCListError;

/**
 * The error message of 'DtcStatusChanged'
 */
typedef ::asf::cca::CcaTypes::DefaultError DtcStatusChangedError;


/**
 * The start message of the method "SaveTestResult"
 * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
 */
class SaveTestResultStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveTestResultStart ();

    /**
     * Copy constructor
     */
    inline  SaveTestResultStart (const SaveTestResultStart &rhs);

    /**
     * All fields constructor
     */
    inline  SaveTestResultStart (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_);

    /**
     * Destructor
     */
    inline virtual  ~SaveTestResultStart();

    /**
     * Assignment operator
     */
    inline SaveTestResultStart& operator = (const SaveTestResultStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveTestResultStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveTestResultStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveTestResultStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveTestResultStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestResultList"

    static const int kTestResultList = 0;

    /**
     * Clears the field "TestResultList".
     *
     * The field will be set to its default value. The hasTestResultList()
     * method will return false.
     */
    inline void clearTestResultList();

    /**
     * Checks whether the field "TestResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestResultList()). Otherwise it will return false.
     */
    inline bool hasTestResultList () const;

    /**
     * Returns the value of the member "TestResultList".
     *
     * A list of test results.
     *
     * @return The value of the field "TestResultList"
     */
    inline const ::midw_diaglog_fi_types::T_TestResultList& getTestResultList () const;

    /**
     * Retrieves the value of the field "TestResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TestResultList".
     */
    inline ::midw_diaglog_fi_types::T_TestResultList& getTestResultListMutable ();

    /**
     * Sets the value of the member "TestResultList".
     *
     * A list of test results.
     *
     * @param TestResultList The value which will be set
     */
    inline void setTestResultList (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_);

    static const SaveTestResultStart &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_TestResult >& getT_TestResultList_DefaultInstance ();

    inline void set_has_TestResultList ();

    inline void clear_has_TestResultList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_TestResultList _TestResultList;

};

/**
 * The result message of the method "SaveTestResult"
 * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
 */
class SaveTestResultResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveTestResultResult ();

    /**
     * Copy constructor
     */
    inline  SaveTestResultResult (const SaveTestResultResult &rhs);

    /**
     * All fields constructor
     */
    inline  SaveTestResultResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~SaveTestResultResult();

    /**
     * Assignment operator
     */
    inline SaveTestResultResult& operator = (const SaveTestResultResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveTestResultResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveTestResultResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveTestResultResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveTestResultResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const SaveTestResultResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "SaveTestResultDynamicalDTC"
 * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
 * This given TroubleCode Number is a real DTC Number and will not checked by Diaglog on validity. They will still added to the DTC List                                       0x8200  if reserved memory is still available.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SAVETESTRESULTDYNAMICALDTC
 */
class SaveTestResultDynamicalDTCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveTestResultDynamicalDTCStart ();

    /**
     * Copy constructor
     */
    inline  SaveTestResultDynamicalDTCStart (const SaveTestResultDynamicalDTCStart &rhs);

    /**
     * All fields constructor
     */
    inline  SaveTestResultDynamicalDTCStart (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_);

    /**
     * Destructor
     */
    inline virtual  ~SaveTestResultDynamicalDTCStart();

    /**
     * Assignment operator
     */
    inline SaveTestResultDynamicalDTCStart& operator = (const SaveTestResultDynamicalDTCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveTestResultDynamicalDTCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveTestResultDynamicalDTCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveTestResultDynamicalDTCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveTestResultDynamicalDTCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestResultList"

    static const int kTestResultList = 0;

    /**
     * Clears the field "TestResultList".
     *
     * The field will be set to its default value. The hasTestResultList()
     * method will return false.
     */
    inline void clearTestResultList();

    /**
     * Checks whether the field "TestResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestResultList()). Otherwise it will return false.
     */
    inline bool hasTestResultList () const;

    /**
     * Returns the value of the member "TestResultList".
     *
     * A list of test results.
     *
     * @return The value of the field "TestResultList"
     */
    inline const ::midw_diaglog_fi_types::T_TestResultList& getTestResultList () const;

    /**
     * Retrieves the value of the field "TestResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TestResultList".
     */
    inline ::midw_diaglog_fi_types::T_TestResultList& getTestResultListMutable ();

    /**
     * Sets the value of the member "TestResultList".
     *
     * A list of test results.
     *
     * @param TestResultList The value which will be set
     */
    inline void setTestResultList (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_);

    static const SaveTestResultDynamicalDTCStart &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_TestResult >& getT_TestResultList_DefaultInstance ();

    inline void set_has_TestResultList ();

    inline void clear_has_TestResultList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_TestResultList _TestResultList;

};

/**
 * The result message of the method "SaveTestResultDynamicalDTC"
 * This method is used by a client to inform DiagLog of test results. The client can send a list of results to save on message traffic if it has several reports to send.
 * This given TroubleCode Number is a real DTC Number and will not checked by Diaglog on validity. They will still added to the DTC List                                       0x8200  if reserved memory is still available.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SAVETESTRESULTDYNAMICALDTC
 */
class SaveTestResultDynamicalDTCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SaveTestResultDynamicalDTCResult ();

    /**
     * Copy constructor
     */
    inline  SaveTestResultDynamicalDTCResult (const SaveTestResultDynamicalDTCResult &rhs);

    /**
     * All fields constructor
     */
    inline  SaveTestResultDynamicalDTCResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~SaveTestResultDynamicalDTCResult();

    /**
     * Assignment operator
     */
    inline SaveTestResultDynamicalDTCResult& operator = (const SaveTestResultDynamicalDTCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SaveTestResultDynamicalDTCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SaveTestResultDynamicalDTCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SaveTestResultDynamicalDTCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SaveTestResultDynamicalDTCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const SaveTestResultDynamicalDTCResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "ProductionReadRequest"
 * This method forwards the status mask of a production read request message from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class ProductionReadRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProductionReadRequestStart ();

    /**
     * Copy constructor
     */
    inline  ProductionReadRequestStart (const ProductionReadRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  ProductionReadRequestStart (::midw_diaglog_fi_types::T_e8_Protocol Protocol_, uint8 StatusMask_, uint32 ITCMask_, uint32 Option_);

    /**
     * Destructor
     */
    inline virtual  ~ProductionReadRequestStart();

    /**
     * Assignment operator
     */
    inline ProductionReadRequestStart& operator = (const ProductionReadRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProductionReadRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProductionReadRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProductionReadRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProductionReadRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Protocol"

    static const int kProtocol = 0;

    /**
     * Clears the field "Protocol".
     *
     * The field will be set to its default value. The hasProtocol()
     * method will return false.
     */
    inline void clearProtocol();

    /**
     * Checks whether the field "Protocol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtocol()). Otherwise it will return false.
     */
    inline bool hasProtocol () const;

    /**
     * Returns the value of the member "Protocol".
     *
     * Protocol to use
     *
     * @return The value of the field "Protocol"
     */
    inline ::midw_diaglog_fi_types::T_e8_Protocol getProtocol () const;

    /**
     * Sets the value of the member "Protocol".
     *
     * Protocol to use
     *
     * @param Protocol The value which will be set
     */
    inline void setProtocol (::midw_diaglog_fi_types::T_e8_Protocol Protocol_);

    // API of field "StatusMask"

    static const int kStatusMask = 1;

    /**
     * Clears the field "StatusMask".
     *
     * The field will be set to its default value. The hasStatusMask()
     * method will return false.
     */
    inline void clearStatusMask();

    /**
     * Checks whether the field "StatusMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMask()). Otherwise it will return false.
     */
    inline bool hasStatusMask () const;

    /**
     * Returns the value of the member "StatusMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @return The value of the field "StatusMask"
     */
    inline uint8 getStatusMask () const;

    /**
     * Sets the value of the member "StatusMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @param StatusMask The value which will be set
     */
    inline void setStatusMask (uint8 StatusMask_);

    // API of field "ITCMask"

    static const int kITCMask = 2;

    /**
     * Clears the field "ITCMask".
     *
     * The field will be set to its default value. The hasITCMask()
     * method will return false.
     */
    inline void clearITCMask();

    /**
     * Checks whether the field "ITCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITCMask()). Otherwise it will return false.
     */
    inline bool hasITCMask () const;

    /**
     * Returns the value of the member "ITCMask".
     *
     * The ITC mask as received from the production tester equipment. DEFAULT:0xFFFFFFFF
     *
     * @return The value of the field "ITCMask"
     */
    inline uint32 getITCMask () const;

    /**
     * Sets the value of the member "ITCMask".
     *
     * The ITC mask as received from the production tester equipment. DEFAULT:0xFFFFFFFF
     *
     * @param ITCMask The value which will be set
     */
    inline void setITCMask (uint32 ITCMask_);

    // API of field "Option"

    static const int kOption = 3;

    /**
     * Clears the field "Option".
     *
     * The field will be set to its default value. The hasOption()
     * method will return false.
     */
    inline void clearOption();

    /**
     * Checks whether the field "Option" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOption()). Otherwise it will return false.
     */
    inline bool hasOption () const;

    /**
     * Returns the value of the member "Option".
     *
     * The Option for special behaviour DEFAULT:0x00.
     *
     * @return The value of the field "Option"
     */
    inline uint32 getOption () const;

    /**
     * Sets the value of the member "Option".
     *
     * The Option for special behaviour DEFAULT:0x00.
     *
     * @param Option The value which will be set
     */
    inline void setOption (uint32 Option_);

    static const ProductionReadRequestStart &getDefaultInstance();

private:

    inline void set_has_Protocol ();

    inline void clear_has_Protocol ();

    inline void set_has_StatusMask ();

    inline void clear_has_StatusMask ();

    inline void set_has_ITCMask ();

    inline void clear_has_ITCMask ();

    inline void set_has_Option ();

    inline void clear_has_Option ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_Protocol _Protocol;

    uint8 _StatusMask;

    uint32 _ITCMask;

    uint32 _Option;

};

/**
 * The result message of the method "ProductionReadRequest"
 * This method forwards the status mask of a production read request message from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class ProductionReadRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProductionReadRequestResult ();

    /**
     * Copy constructor
     */
    inline  ProductionReadRequestResult (const ProductionReadRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  ProductionReadRequestResult (const ::midw_diaglog_fi_types::T_ProductionReadResultList& ProductionReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ProductionReadRequestResult();

    /**
     * Assignment operator
     */
    inline ProductionReadRequestResult& operator = (const ProductionReadRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProductionReadRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProductionReadRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProductionReadRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProductionReadRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ProductionReadResultList"

    static const int kProductionReadResultList = 0;

    /**
     * Clears the field "ProductionReadResultList".
     *
     * The field will be set to its default value. The hasProductionReadResultList()
     * method will return false.
     */
    inline void clearProductionReadResultList();

    /**
     * Checks whether the field "ProductionReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProductionReadResultList()). Otherwise it will return false.
     */
    inline bool hasProductionReadResultList () const;

    /**
     * Returns the value of the member "ProductionReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "ProductionReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_ProductionReadResultList& getProductionReadResultList () const;

    /**
     * Retrieves the value of the field "ProductionReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ProductionReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_ProductionReadResultList& getProductionReadResultListMutable ();

    /**
     * Sets the value of the member "ProductionReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param ProductionReadResultList The value which will be set
     */
    inline void setProductionReadResultList (const ::midw_diaglog_fi_types::T_ProductionReadResultList& ProductionReadResultList_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ProductionReadRequestResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ProductionReadResultStructure >& getT_ProductionReadResultStructureList_DefaultInstance ();

    inline void set_has_ProductionReadResultList ();

    inline void clear_has_ProductionReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_ProductionReadResultList _ProductionReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "CustomerReadRequest"
 * This method forwards the status mask of a customer read request message from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CUSTOMERREADREQUEST
 */
class CustomerReadRequestStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CustomerReadRequestStart ();

    /**
     * Copy constructor
     */
    inline  CustomerReadRequestStart (const CustomerReadRequestStart &rhs);

    /**
     * All fields constructor
     */
    inline  CustomerReadRequestStart (::midw_diaglog_fi_types::T_e8_Protocol Protocol_, uint8 StatusMask_, uint32 DTCMask_, uint32 Option_);

    /**
     * Destructor
     */
    inline virtual  ~CustomerReadRequestStart();

    /**
     * Assignment operator
     */
    inline CustomerReadRequestStart& operator = (const CustomerReadRequestStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CustomerReadRequestStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CustomerReadRequestStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CustomerReadRequestStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CustomerReadRequestStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Protocol"

    static const int kProtocol = 0;

    /**
     * Clears the field "Protocol".
     *
     * The field will be set to its default value. The hasProtocol()
     * method will return false.
     */
    inline void clearProtocol();

    /**
     * Checks whether the field "Protocol" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProtocol()). Otherwise it will return false.
     */
    inline bool hasProtocol () const;

    /**
     * Returns the value of the member "Protocol".
     *
     * Protocol to use
     *
     * @return The value of the field "Protocol"
     */
    inline ::midw_diaglog_fi_types::T_e8_Protocol getProtocol () const;

    /**
     * Sets the value of the member "Protocol".
     *
     * Protocol to use
     *
     * @param Protocol The value which will be set
     */
    inline void setProtocol (::midw_diaglog_fi_types::T_e8_Protocol Protocol_);

    // API of field "StatusMask"

    static const int kStatusMask = 1;

    /**
     * Clears the field "StatusMask".
     *
     * The field will be set to its default value. The hasStatusMask()
     * method will return false.
     */
    inline void clearStatusMask();

    /**
     * Checks whether the field "StatusMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMask()). Otherwise it will return false.
     */
    inline bool hasStatusMask () const;

    /**
     * Returns the value of the member "StatusMask".
     *
     * The status mask as received from the customer tester equipment.
     *
     * @return The value of the field "StatusMask"
     */
    inline uint8 getStatusMask () const;

    /**
     * Sets the value of the member "StatusMask".
     *
     * The status mask as received from the customer tester equipment.
     *
     * @param StatusMask The value which will be set
     */
    inline void setStatusMask (uint8 StatusMask_);

    // API of field "DTCMask"

    static const int kDTCMask = 2;

    /**
     * Clears the field "DTCMask".
     *
     * The field will be set to its default value. The hasDTCMask()
     * method will return false.
     */
    inline void clearDTCMask();

    /**
     * Checks whether the field "DTCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCMask()). Otherwise it will return false.
     */
    inline bool hasDTCMask () const;

    /**
     * Returns the value of the member "DTCMask".
     *
     * The DTC mask as received from the production tester equipment.
     *
     * @return The value of the field "DTCMask"
     */
    inline uint32 getDTCMask () const;

    /**
     * Sets the value of the member "DTCMask".
     *
     * The DTC mask as received from the production tester equipment.
     *
     * @param DTCMask The value which will be set
     */
    inline void setDTCMask (uint32 DTCMask_);

    // API of field "Option"

    static const int kOption = 3;

    /**
     * Clears the field "Option".
     *
     * The field will be set to its default value. The hasOption()
     * method will return false.
     */
    inline void clearOption();

    /**
     * Checks whether the field "Option" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOption()). Otherwise it will return false.
     */
    inline bool hasOption () const;

    /**
     * Returns the value of the member "Option".
     *
     * The Option for special behaviour (for further use).
     *
     * @return The value of the field "Option"
     */
    inline uint32 getOption () const;

    /**
     * Sets the value of the member "Option".
     *
     * The Option for special behaviour (for further use).
     *
     * @param Option The value which will be set
     */
    inline void setOption (uint32 Option_);

    static const CustomerReadRequestStart &getDefaultInstance();

private:

    inline void set_has_Protocol ();

    inline void clear_has_Protocol ();

    inline void set_has_StatusMask ();

    inline void clear_has_StatusMask ();

    inline void set_has_DTCMask ();

    inline void clear_has_DTCMask ();

    inline void set_has_Option ();

    inline void clear_has_Option ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_Protocol _Protocol;

    uint8 _StatusMask;

    uint32 _DTCMask;

    uint32 _Option;

};

/**
 * The result message of the method "CustomerReadRequest"
 * This method forwards the status mask of a customer read request message from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CUSTOMERREADREQUEST
 */
class CustomerReadRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CustomerReadRequestResult ();

    /**
     * Copy constructor
     */
    inline  CustomerReadRequestResult (const CustomerReadRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  CustomerReadRequestResult (const ::midw_diaglog_fi_types::T_CustomerReadResultList& CustomerReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~CustomerReadRequestResult();

    /**
     * Assignment operator
     */
    inline CustomerReadRequestResult& operator = (const CustomerReadRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CustomerReadRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CustomerReadRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CustomerReadRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CustomerReadRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CustomerReadResultList"

    static const int kCustomerReadResultList = 0;

    /**
     * Clears the field "CustomerReadResultList".
     *
     * The field will be set to its default value. The hasCustomerReadResultList()
     * method will return false.
     */
    inline void clearCustomerReadResultList();

    /**
     * Checks whether the field "CustomerReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCustomerReadResultList()). Otherwise it will return false.
     */
    inline bool hasCustomerReadResultList () const;

    /**
     * Returns the value of the member "CustomerReadResultList".
     *
     * List of DTCs that correspond to the mask.
     *
     * @return The value of the field "CustomerReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_CustomerReadResultList& getCustomerReadResultList () const;

    /**
     * Retrieves the value of the field "CustomerReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CustomerReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_CustomerReadResultList& getCustomerReadResultListMutable ();

    /**
     * Sets the value of the member "CustomerReadResultList".
     *
     * List of DTCs that correspond to the mask.
     *
     * @param CustomerReadResultList The value which will be set
     */
    inline void setCustomerReadResultList (const ::midw_diaglog_fi_types::T_CustomerReadResultList& CustomerReadResultList_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const CustomerReadRequestResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_CustomerReadResultStructure >& getT_CustomerReadResultStructureList_DefaultInstance ();

    inline void set_has_CustomerReadResultList ();

    inline void clear_has_CustomerReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_CustomerReadResultList _CustomerReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getItcInformation"
 * This method read out all ITC information given by an List of ITC's
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_GETITCINFORMATION
 */
class GetItcInformationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetItcInformationStart ();

    /**
     * Copy constructor
     */
    inline  GetItcInformationStart (const GetItcInformationStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetItcInformationStart (uint8 Group_, const ::std::vector< uint16 >& ITCList_);

    /**
     * Destructor
     */
    inline virtual  ~GetItcInformationStart();

    /**
     * Assignment operator
     */
    inline GetItcInformationStart& operator = (const GetItcInformationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetItcInformationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetItcInformationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetItcInformationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetItcInformationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "ITCList"

    static const int kITCList = 1;

    /**
     * Clears the field "ITCList".
     *
     * The field will be set to its default value. The hasITCList()
     * method will return false.
     */
    inline void clearITCList();

    /**
     * Checks whether the field "ITCList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITCList()). Otherwise it will return false.
     */
    inline bool hasITCList () const;

    /**
     * Returns the value of the member "ITCList".
     *
     * List of the ITCs
     *
     * @return The value of the field "ITCList"
     */
    inline const ::std::vector< uint16 >& getITCList () const;

    /**
     * Retrieves the value of the field "ITCList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ITCList".
     */
    inline ::std::vector< uint16 >& getITCListMutable ();

    /**
     * Sets the value of the member "ITCList".
     *
     * List of the ITCs
     *
     * @param ITCList The value which will be set
     */
    inline void setITCList (const ::std::vector< uint16 >& ITCList_);

    static const GetItcInformationStart &getDefaultInstance();

private:

    static const ::std::vector< uint16 >& getUint16List_DefaultInstance ();

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_ITCList ();

    inline void clear_has_ITCList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Group;

    ::std::vector< uint16 > _ITCList;

};

/**
 * The result message of the method "getItcInformation"
 * This method read out all ITC information given by an List of ITC's
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_GETITCINFORMATION
 */
class GetItcInformationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetItcInformationResult ();

    /**
     * Copy constructor
     */
    inline  GetItcInformationResult (const GetItcInformationResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetItcInformationResult (const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& ItcInformationList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetItcInformationResult();

    /**
     * Assignment operator
     */
    inline GetItcInformationResult& operator = (const GetItcInformationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetItcInformationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetItcInformationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetItcInformationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetItcInformationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ItcInformationList"

    static const int kItcInformationList = 0;

    /**
     * Clears the field "ItcInformationList".
     *
     * The field will be set to its default value. The hasItcInformationList()
     * method will return false.
     */
    inline void clearItcInformationList();

    /**
     * Checks whether the field "ItcInformationList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setItcInformationList()). Otherwise it will return false.
     */
    inline bool hasItcInformationList () const;

    /**
     * Returns the value of the member "ItcInformationList".
     *
     * List of ITC Information that correspond to the given List
     *
     * @return The value of the field "ItcInformationList"
     */
    inline const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& getItcInformationList () const;

    /**
     * Retrieves the value of the field "ItcInformationList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ItcInformationList".
     */
    inline ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& getItcInformationListMutable ();

    /**
     * Sets the value of the member "ItcInformationList".
     *
     * List of ITC Information that correspond to the given List
     *
     * @param ItcInformationList The value which will be set
     */
    inline void setItcInformationList (const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& ItcInformationList_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetItcInformationResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& getT_ITC_InformationList_DefaultInstance ();

    inline void set_has_ItcInformationList ();

    inline void clear_has_ItcInformationList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information > _ItcInformationList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The result message of the method "ProductionClearRequest"
 * This method forwards a production clear request message from external production test equipment to the DiagLog component. Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONCLEARREQUEST
 */
class ProductionClearRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ProductionClearRequestResult ();

    /**
     * Copy constructor
     */
    inline  ProductionClearRequestResult (const ProductionClearRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  ProductionClearRequestResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ProductionClearRequestResult();

    /**
     * Assignment operator
     */
    inline ProductionClearRequestResult& operator = (const ProductionClearRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ProductionClearRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ProductionClearRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ProductionClearRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ProductionClearRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ProductionClearRequestResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The result message of the method "CustomerClearRequest"
 * This method forwards a customer clear request message from external customer test equipment to the DiagLog component. Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CUSTOMERCLEARREQUEST
 */
class CustomerClearRequestResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CustomerClearRequestResult ();

    /**
     * Copy constructor
     */
    inline  CustomerClearRequestResult (const CustomerClearRequestResult &rhs);

    /**
     * All fields constructor
     */
    inline  CustomerClearRequestResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~CustomerClearRequestResult();

    /**
     * Assignment operator
     */
    inline CustomerClearRequestResult& operator = (const CustomerClearRequestResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CustomerClearRequestResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CustomerClearRequestResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CustomerClearRequestResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CustomerClearRequestResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const CustomerClearRequestResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "WriteToMedia"
 * This methods writes the Diaglog contents to the specified media.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_WRITETOMEDIA
 */
class WriteToMediaStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WriteToMediaStart ();

    /**
     * Copy constructor
     */
    inline  WriteToMediaStart (const WriteToMediaStart &rhs);

    /**
     * All fields constructor
     */
    inline  WriteToMediaStart (::midw_diaglog_fi_types::T_e8_VDLMediaType Media_);

    /**
     * Destructor
     */
    inline virtual  ~WriteToMediaStart();

    /**
     * Assignment operator
     */
    inline WriteToMediaStart& operator = (const WriteToMediaStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WriteToMediaStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WriteToMediaStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WriteToMediaStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WriteToMediaStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Media"

    static const int kMedia = 0;

    /**
     * Clears the field "Media".
     *
     * The field will be set to its default value. The hasMedia()
     * method will return false.
     */
    inline void clearMedia();

    /**
     * Checks whether the field "Media" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setMedia()). Otherwise it will return false.
     */
    inline bool hasMedia () const;

    /**
     * Returns the value of the member "Media".
     *
     * Specifies the media to be written to.
     *
     * @return The value of the field "Media"
     */
    inline ::midw_diaglog_fi_types::T_e8_VDLMediaType getMedia () const;

    /**
     * Sets the value of the member "Media".
     *
     * Specifies the media to be written to.
     *
     * @param Media The value which will be set
     */
    inline void setMedia (::midw_diaglog_fi_types::T_e8_VDLMediaType Media_);

    static const WriteToMediaStart &getDefaultInstance();

private:

    inline void set_has_Media ();

    inline void clear_has_Media ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_VDLMediaType _Media;

};

/**
 * The result message of the method "WriteToMedia"
 * This methods writes the Diaglog contents to the specified media.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_WRITETOMEDIA
 */
class WriteToMediaResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  WriteToMediaResult ();

    /**
     * Copy constructor
     */
    inline  WriteToMediaResult (const WriteToMediaResult &rhs);

    /**
     * All fields constructor
     */
    inline  WriteToMediaResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~WriteToMediaResult();

    /**
     * Assignment operator
     */
    inline WriteToMediaResult& operator = (const WriteToMediaResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const WriteToMediaResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const WriteToMediaResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const WriteToMediaResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const WriteToMediaResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const WriteToMediaResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The status message of the property "DTCActive"
 * This property indicates that at least one DTC is active.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCACTIVE
 */
class DTCActiveStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DTCActiveStatus ();

    /**
     * Copy constructor
     */
    inline  DTCActiveStatus (const DTCActiveStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DTCActiveStatus (bool IsDTCActive_, uint32 DTC_, uint8 DTCStatus_, uint8 DTCFailureType_);

    /**
     * Destructor
     */
    inline virtual  ~DTCActiveStatus();

    /**
     * Assignment operator
     */
    inline DTCActiveStatus& operator = (const DTCActiveStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTCActiveStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTCActiveStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTCActiveStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTCActiveStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IsDTCActive"

    static const int kIsDTCActive = 0;

    /**
     * Clears the field "IsDTCActive".
     *
     * The field will be set to its default value. The hasIsDTCActive()
     * method will return false.
     */
    inline void clearIsDTCActive();

    /**
     * Checks whether the field "IsDTCActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDTCActive()). Otherwise it will return false.
     */
    inline bool hasIsDTCActive () const;

    /**
     * Returns the value of the member "IsDTCActive".
     *
     * True if at least one DTC is active.
     *
     * @return The value of the field "IsDTCActive"
     */
    inline bool getIsDTCActive () const;

    /**
     * Sets the value of the member "IsDTCActive".
     *
     * True if at least one DTC is active.
     *
     * @param IsDTCActive The value which will be set
     */
    inline void setIsDTCActive (bool IsDTCActive_);

    // API of field "DTC"

    static const int kDTC = 1;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * Diagnostic Trouble code causing this status update.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * Diagnostic Trouble code causing this status update.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "DTCStatus"

    static const int kDTCStatus = 2;

    /**
     * Clears the field "DTCStatus".
     *
     * The field will be set to its default value. The hasDTCStatus()
     * method will return false.
     */
    inline void clearDTCStatus();

    /**
     * Checks whether the field "DTCStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCStatus()). Otherwise it will return false.
     */
    inline bool hasDTCStatus () const;

    /**
     * Returns the value of the member "DTCStatus".
     *
     * Status byte of Diagnostic Trouble code causing this status update.
     *
     * @return The value of the field "DTCStatus"
     */
    inline uint8 getDTCStatus () const;

    /**
     * Sets the value of the member "DTCStatus".
     *
     * Status byte of Diagnostic Trouble code causing this status update.
     *
     * @param DTCStatus The value which will be set
     */
    inline void setDTCStatus (uint8 DTCStatus_);

    // API of field "DTCFailureType"

    static const int kDTCFailureType = 3;

    /**
     * Clears the field "DTCFailureType".
     *
     * The field will be set to its default value. The hasDTCFailureType()
     * method will return false.
     */
    inline void clearDTCFailureType();

    /**
     * Checks whether the field "DTCFailureType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCFailureType()). Otherwise it will return false.
     */
    inline bool hasDTCFailureType () const;

    /**
     * Returns the value of the member "DTCFailureType".
     *
     * Failure type byte of Diagnostic Trouble code causing this status update.
     *
     * @return The value of the field "DTCFailureType"
     */
    inline uint8 getDTCFailureType () const;

    /**
     * Sets the value of the member "DTCFailureType".
     *
     * Failure type byte of Diagnostic Trouble code causing this status update.
     *
     * @param DTCFailureType The value which will be set
     */
    inline void setDTCFailureType (uint8 DTCFailureType_);

    static const DTCActiveStatus &getDefaultInstance();

private:

    inline void set_has_IsDTCActive ();

    inline void clear_has_IsDTCActive ();

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_DTCStatus ();

    inline void clear_has_DTCStatus ();

    inline void set_has_DTCFailureType ();

    inline void clear_has_DTCFailureType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _IsDTCActive;

    uint32 _DTC;

    uint8 _DTCStatus;

    uint8 _DTCFailureType;

};

/**
 * The get message of the property "DTCActive"
 * This property indicates that at least one DTC is active.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCACTIVE
 */
class DTCActiveGet  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DTCActiveGet ();

    /**
     * Copy constructor
     */
    inline  DTCActiveGet (const DTCActiveGet &rhs);

    /**
     * All fields constructor
     */
    inline  DTCActiveGet (bool IsDTCActive_);

    /**
     * Destructor
     */
    inline virtual  ~DTCActiveGet();

    /**
     * Assignment operator
     */
    inline DTCActiveGet& operator = (const DTCActiveGet& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTCActiveGet& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTCActiveGet& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTCActiveGet& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTCActiveGet& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IsDTCActive"

    static const int kIsDTCActive = 0;

    /**
     * Clears the field "IsDTCActive".
     *
     * The field will be set to its default value. The hasIsDTCActive()
     * method will return false.
     */
    inline void clearIsDTCActive();

    /**
     * Checks whether the field "IsDTCActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDTCActive()). Otherwise it will return false.
     */
    inline bool hasIsDTCActive () const;

    /**
     * Returns the value of the member "IsDTCActive".
     *
     * True if at least one DTC is active.
     *
     * @return The value of the field "IsDTCActive"
     */
    inline bool getIsDTCActive () const;

    /**
     * Sets the value of the member "IsDTCActive".
     *
     * True if at least one DTC is active.
     *
     * @param IsDTCActive The value which will be set
     */
    inline void setIsDTCActive (bool IsDTCActive_);

    static const DTCActiveGet &getDefaultInstance();

private:

    inline void set_has_IsDTCActive ();

    inline void clear_has_IsDTCActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _IsDTCActive;

};

/**
 * The status message of the property "SendNextTestResult"
 * This property indicates that the client should update the DiagLog with the status of DTCs AFTER the next tests to determine that status.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
 */
class SendNextTestResultStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendNextTestResultStatus ();

    /**
     * Copy constructor
     */
    inline  SendNextTestResultStatus (const SendNextTestResultStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SendNextTestResultStatus (const ::midw_diaglog_fi_types::T_SendNextTestResultStructure& NextTestResultStruct_, bool Status_);

    /**
     * Destructor
     */
    inline virtual  ~SendNextTestResultStatus();

    /**
     * Assignment operator
     */
    inline SendNextTestResultStatus& operator = (const SendNextTestResultStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendNextTestResultStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendNextTestResultStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendNextTestResultStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendNextTestResultStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NextTestResultStruct"

    static const int kNextTestResultStruct = 0;

    /**
     * Clears the field "NextTestResultStruct".
     *
     * The field will be set to its default value. The hasNextTestResultStruct()
     * method will return false.
     */
    inline void clearNextTestResultStruct();

    /**
     * Checks whether the field "NextTestResultStruct" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNextTestResultStruct()). Otherwise it will return false.
     */
    inline bool hasNextTestResultStruct () const;

    /**
     * Returns the value of the member "NextTestResultStruct".
     *
     * NextTestResultStruct.Status = false if this is a confirmation message from the Diaglog that the UpReg has been succesful.
     * NextTestResultStruct.Status = True if client is required to send next test result to DiagLog.
     * NextTestResultStruct.SendNextTestResReason = T_e8_SendNextTestResReason::CLEAR_CODE if the Next Test result is required due to a Clearing of the DTC
     * NextTestResultStruct.SendNextTestResReason = T_e8_SendNextTestResReason::BLOCKING_MODE_RESET if the Next Test result is required due to a reset of the Blocking Modes
     * NextTestResultStruct.ITCList:  This is the list of the DTCs for which the next test result has to be sent. if the List is empty and "NextTestResultStruct.Status == True" then the client should report all the DTCs for which he is reponsible.
     * For the DTCs that are listed in the ITCList: correponding tests must be immediately cancelled (if they are running) when the CCA message is received. New Tests have to be carried out and the results of these Tests must be reported to the Diaglog.
     *
     * @return The value of the field "NextTestResultStruct"
     */
    inline const ::midw_diaglog_fi_types::T_SendNextTestResultStructure& getNextTestResultStruct () const;

    /**
     * Retrieves the value of the field "NextTestResultStruct" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "NextTestResultStruct".
     */
    inline ::midw_diaglog_fi_types::T_SendNextTestResultStructure& getNextTestResultStructMutable ();

    /**
     * Sets the value of the member "NextTestResultStruct".
     *
     * NextTestResultStruct.Status = false if this is a confirmation message from the Diaglog that the UpReg has been succesful.
     * NextTestResultStruct.Status = True if client is required to send next test result to DiagLog.
     * NextTestResultStruct.SendNextTestResReason = T_e8_SendNextTestResReason::CLEAR_CODE if the Next Test result is required due to a Clearing of the DTC
     * NextTestResultStruct.SendNextTestResReason = T_e8_SendNextTestResReason::BLOCKING_MODE_RESET if the Next Test result is required due to a reset of the Blocking Modes
     * NextTestResultStruct.ITCList:  This is the list of the DTCs for which the next test result has to be sent. if the List is empty and "NextTestResultStruct.Status == True" then the client should report all the DTCs for which he is reponsible.
     * For the DTCs that are listed in the ITCList: correponding tests must be immediately cancelled (if they are running) when the CCA message is received. New Tests have to be carried out and the results of these Tests must be reported to the Diaglog.
     *
     * @param NextTestResultStruct The value which will be set
     */
    inline void setNextTestResultStruct (const ::midw_diaglog_fi_types::T_SendNextTestResultStructure& NextTestResultStruct_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * True if client is required to send next test result to DiagLog. same as NextTestResultStruct.Status for old projects only
     *
     * @return The value of the field "Status"
     */
    inline bool getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * True if client is required to send next test result to DiagLog. same as NextTestResultStruct.Status for old projects only
     *
     * @param Status The value which will be set
     */
    inline void setStatus (bool Status_);

    static const SendNextTestResultStatus &getDefaultInstance();

private:

    inline void set_has_NextTestResultStruct ();

    inline void clear_has_NextTestResultStruct ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_SendNextTestResultStructure _NextTestResultStruct;

    bool _Status;

};

/**
 * The start message of the method "getDTCbyStatusMask"
 * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetDTCbyStatusMaskStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDTCbyStatusMaskStart ();

    /**
     * Copy constructor
     */
    inline  GetDTCbyStatusMaskStart (const GetDTCbyStatusMaskStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetDTCbyStatusMaskStart (uint8 Group_, uint8 StatusMask_, uint32 DTCMask_);

    /**
     * Destructor
     */
    inline virtual  ~GetDTCbyStatusMaskStart();

    /**
     * Assignment operator
     */
    inline GetDTCbyStatusMaskStart& operator = (const GetDTCbyStatusMaskStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDTCbyStatusMaskStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDTCbyStatusMaskStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDTCbyStatusMaskStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDTCbyStatusMaskStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "StatusMask"

    static const int kStatusMask = 1;

    /**
     * Clears the field "StatusMask".
     *
     * The field will be set to its default value. The hasStatusMask()
     * method will return false.
     */
    inline void clearStatusMask();

    /**
     * Checks whether the field "StatusMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMask()). Otherwise it will return false.
     */
    inline bool hasStatusMask () const;

    /**
     * Returns the value of the member "StatusMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @return The value of the field "StatusMask"
     */
    inline uint8 getStatusMask () const;

    /**
     * Sets the value of the member "StatusMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @param StatusMask The value which will be set
     */
    inline void setStatusMask (uint8 StatusMask_);

    // API of field "DTCMask"

    static const int kDTCMask = 2;

    /**
     * Clears the field "DTCMask".
     *
     * The field will be set to its default value. The hasDTCMask()
     * method will return false.
     */
    inline void clearDTCMask();

    /**
     * Checks whether the field "DTCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCMask()). Otherwise it will return false.
     */
    inline bool hasDTCMask () const;

    /**
     * Returns the value of the member "DTCMask".
     *
     * The DTC mask as received from the production tester equipment.
     *
     * @return The value of the field "DTCMask"
     */
    inline uint32 getDTCMask () const;

    /**
     * Sets the value of the member "DTCMask".
     *
     * The DTC mask as received from the production tester equipment.
     *
     * @param DTCMask The value which will be set
     */
    inline void setDTCMask (uint32 DTCMask_);

    static const GetDTCbyStatusMaskStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_StatusMask ();

    inline void clear_has_StatusMask ();

    inline void set_has_DTCMask ();

    inline void clear_has_DTCMask ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Group;

    uint8 _StatusMask;

    uint32 _DTCMask;

};

/**
 * The result message of the method "getDTCbyStatusMask"
 * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetDTCbyStatusMaskResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetDTCbyStatusMaskResult ();

    /**
     * Copy constructor
     */
    inline  GetDTCbyStatusMaskResult (const GetDTCbyStatusMaskResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetDTCbyStatusMaskResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetDTCbyStatusMaskResult();

    /**
     * Assignment operator
     */
    inline GetDTCbyStatusMaskResult& operator = (const GetDTCbyStatusMaskResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetDTCbyStatusMaskResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetDTCbyStatusMaskResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetDTCbyStatusMaskResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetDTCbyStatusMaskResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusAvailabilityMask"

    static const int kStatusAvailabilityMask = 0;

    /**
     * Clears the field "StatusAvailabilityMask".
     *
     * The field will be set to its default value. The hasStatusAvailabilityMask()
     * method will return false.
     */
    inline void clearStatusAvailabilityMask();

    /**
     * Checks whether the field "StatusAvailabilityMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusAvailabilityMask()). Otherwise it will return false.
     */
    inline bool hasStatusAvailabilityMask () const;

    /**
     * Returns the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @return The value of the field "StatusAvailabilityMask"
     */
    inline uint8 getStatusAvailabilityMask () const;

    /**
     * Sets the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @param StatusAvailabilityMask The value which will be set
     */
    inline void setStatusAvailabilityMask (uint8 StatusAvailabilityMask_);

    // API of field "ReadResultList"

    static const int kReadResultList = 1;

    /**
     * Clears the field "ReadResultList".
     *
     * The field will be set to its default value. The hasReadResultList()
     * method will return false.
     */
    inline void clearReadResultList();

    /**
     * Checks whether the field "ReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReadResultList()). Otherwise it will return false.
     */
    inline bool hasReadResultList () const;

    /**
     * Returns the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "ReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_ReadResultList& getReadResultList () const;

    /**
     * Retrieves the value of the field "ReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_ReadResultList& getReadResultListMutable ();

    /**
     * Sets the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param ReadResultList The value which will be set
     */
    inline void setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetDTCbyStatusMaskResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ReadResultStructure >& getT_ReadResultStructureList_DefaultInstance ();

    inline void set_has_StatusAvailabilityMask ();

    inline void clear_has_StatusAvailabilityMask ();

    inline void set_has_ReadResultList ();

    inline void clear_has_ReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _StatusAvailabilityMask;

    ::midw_diaglog_fi_types::T_ReadResultList _ReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getLastConfirmedDTC"
 * This method forwards the last confirmed DTC from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetLastConfirmedDTCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetLastConfirmedDTCStart ();

    /**
     * Copy constructor
     */
    inline  GetLastConfirmedDTCStart (const GetLastConfirmedDTCStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetLastConfirmedDTCStart (uint8 Group_);

    /**
     * Destructor
     */
    inline virtual  ~GetLastConfirmedDTCStart();

    /**
     * Assignment operator
     */
    inline GetLastConfirmedDTCStart& operator = (const GetLastConfirmedDTCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetLastConfirmedDTCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetLastConfirmedDTCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetLastConfirmedDTCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetLastConfirmedDTCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    static const GetLastConfirmedDTCStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Group;

};

/**
 * The result message of the method "getLastConfirmedDTC"
 * This method forwards the last confirmed DTC from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetLastConfirmedDTCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetLastConfirmedDTCResult ();

    /**
     * Copy constructor
     */
    inline  GetLastConfirmedDTCResult (const GetLastConfirmedDTCResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetLastConfirmedDTCResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetLastConfirmedDTCResult();

    /**
     * Assignment operator
     */
    inline GetLastConfirmedDTCResult& operator = (const GetLastConfirmedDTCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetLastConfirmedDTCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetLastConfirmedDTCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetLastConfirmedDTCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetLastConfirmedDTCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusAvailabilityMask"

    static const int kStatusAvailabilityMask = 0;

    /**
     * Clears the field "StatusAvailabilityMask".
     *
     * The field will be set to its default value. The hasStatusAvailabilityMask()
     * method will return false.
     */
    inline void clearStatusAvailabilityMask();

    /**
     * Checks whether the field "StatusAvailabilityMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusAvailabilityMask()). Otherwise it will return false.
     */
    inline bool hasStatusAvailabilityMask () const;

    /**
     * Returns the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @return The value of the field "StatusAvailabilityMask"
     */
    inline uint8 getStatusAvailabilityMask () const;

    /**
     * Sets the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @param StatusAvailabilityMask The value which will be set
     */
    inline void setStatusAvailabilityMask (uint8 StatusAvailabilityMask_);

    // API of field "ReadResultList"

    static const int kReadResultList = 1;

    /**
     * Clears the field "ReadResultList".
     *
     * The field will be set to its default value. The hasReadResultList()
     * method will return false.
     */
    inline void clearReadResultList();

    /**
     * Checks whether the field "ReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReadResultList()). Otherwise it will return false.
     */
    inline bool hasReadResultList () const;

    /**
     * Returns the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "ReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_ReadResultList& getReadResultList () const;

    /**
     * Retrieves the value of the field "ReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_ReadResultList& getReadResultListMutable ();

    /**
     * Sets the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param ReadResultList The value which will be set
     */
    inline void setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetLastConfirmedDTCResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ReadResultStructure >& getT_ReadResultStructureList_DefaultInstance ();

    inline void set_has_StatusAvailabilityMask ();

    inline void clear_has_StatusAvailabilityMask ();

    inline void set_has_ReadResultList ();

    inline void clear_has_ReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _StatusAvailabilityMask;

    ::midw_diaglog_fi_types::T_ReadResultList _ReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getSupportedDTC"
 * This method forwards the supported DTC List from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetSupportedDTCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSupportedDTCStart ();

    /**
     * Copy constructor
     */
    inline  GetSupportedDTCStart (const GetSupportedDTCStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetSupportedDTCStart (uint8 Group_);

    /**
     * Destructor
     */
    inline virtual  ~GetSupportedDTCStart();

    /**
     * Assignment operator
     */
    inline GetSupportedDTCStart& operator = (const GetSupportedDTCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSupportedDTCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSupportedDTCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSupportedDTCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSupportedDTCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    static const GetSupportedDTCStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Group;

};

/**
 * The result message of the method "getSupportedDTC"
 * This method forwards the supported DTC List from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetSupportedDTCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetSupportedDTCResult ();

    /**
     * Copy constructor
     */
    inline  GetSupportedDTCResult (const GetSupportedDTCResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetSupportedDTCResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetSupportedDTCResult();

    /**
     * Assignment operator
     */
    inline GetSupportedDTCResult& operator = (const GetSupportedDTCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetSupportedDTCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetSupportedDTCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetSupportedDTCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetSupportedDTCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusAvailabilityMask"

    static const int kStatusAvailabilityMask = 0;

    /**
     * Clears the field "StatusAvailabilityMask".
     *
     * The field will be set to its default value. The hasStatusAvailabilityMask()
     * method will return false.
     */
    inline void clearStatusAvailabilityMask();

    /**
     * Checks whether the field "StatusAvailabilityMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusAvailabilityMask()). Otherwise it will return false.
     */
    inline bool hasStatusAvailabilityMask () const;

    /**
     * Returns the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @return The value of the field "StatusAvailabilityMask"
     */
    inline uint8 getStatusAvailabilityMask () const;

    /**
     * Sets the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @param StatusAvailabilityMask The value which will be set
     */
    inline void setStatusAvailabilityMask (uint8 StatusAvailabilityMask_);

    // API of field "ReadResultList"

    static const int kReadResultList = 1;

    /**
     * Clears the field "ReadResultList".
     *
     * The field will be set to its default value. The hasReadResultList()
     * method will return false.
     */
    inline void clearReadResultList();

    /**
     * Checks whether the field "ReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReadResultList()). Otherwise it will return false.
     */
    inline bool hasReadResultList () const;

    /**
     * Returns the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "ReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_ReadResultList& getReadResultList () const;

    /**
     * Retrieves the value of the field "ReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_ReadResultList& getReadResultListMutable ();

    /**
     * Sets the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param ReadResultList The value which will be set
     */
    inline void setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetSupportedDTCResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ReadResultStructure >& getT_ReadResultStructureList_DefaultInstance ();

    inline void set_has_StatusAvailabilityMask ();

    inline void clear_has_StatusAvailabilityMask ();

    inline void set_has_ReadResultList ();

    inline void clear_has_ReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _StatusAvailabilityMask;

    ::midw_diaglog_fi_types::T_ReadResultList _ReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getNumberOfDTCByStatusMask"
 * This method forwards the Number of DTC's matched with StatusMask from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetNumberOfDTCByStatusMaskStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNumberOfDTCByStatusMaskStart ();

    /**
     * Copy constructor
     */
    inline  GetNumberOfDTCByStatusMaskStart (const GetNumberOfDTCByStatusMaskStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetNumberOfDTCByStatusMaskStart (uint8 Group_, uint8 StatusMask_, uint32 DTCMask_);

    /**
     * Destructor
     */
    inline virtual  ~GetNumberOfDTCByStatusMaskStart();

    /**
     * Assignment operator
     */
    inline GetNumberOfDTCByStatusMaskStart& operator = (const GetNumberOfDTCByStatusMaskStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNumberOfDTCByStatusMaskStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNumberOfDTCByStatusMaskStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNumberOfDTCByStatusMaskStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNumberOfDTCByStatusMaskStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "StatusMask"

    static const int kStatusMask = 1;

    /**
     * Clears the field "StatusMask".
     *
     * The field will be set to its default value. The hasStatusMask()
     * method will return false.
     */
    inline void clearStatusMask();

    /**
     * Checks whether the field "StatusMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusMask()). Otherwise it will return false.
     */
    inline bool hasStatusMask () const;

    /**
     * Returns the value of the member "StatusMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @return The value of the field "StatusMask"
     */
    inline uint8 getStatusMask () const;

    /**
     * Sets the value of the member "StatusMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @param StatusMask The value which will be set
     */
    inline void setStatusMask (uint8 StatusMask_);

    // API of field "DTCMask"

    static const int kDTCMask = 2;

    /**
     * Clears the field "DTCMask".
     *
     * The field will be set to its default value. The hasDTCMask()
     * method will return false.
     */
    inline void clearDTCMask();

    /**
     * Checks whether the field "DTCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCMask()). Otherwise it will return false.
     */
    inline bool hasDTCMask () const;

    /**
     * Returns the value of the member "DTCMask".
     *
     * The DTC mask as received from the production tester equipment.
     *
     * @return The value of the field "DTCMask"
     */
    inline uint32 getDTCMask () const;

    /**
     * Sets the value of the member "DTCMask".
     *
     * The DTC mask as received from the production tester equipment.
     *
     * @param DTCMask The value which will be set
     */
    inline void setDTCMask (uint32 DTCMask_);

    static const GetNumberOfDTCByStatusMaskStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_StatusMask ();

    inline void clear_has_StatusMask ();

    inline void set_has_DTCMask ();

    inline void clear_has_DTCMask ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Group;

    uint8 _StatusMask;

    uint32 _DTCMask;

};

/**
 * The result message of the method "getNumberOfDTCByStatusMask"
 * This method forwards the Number of DTC's matched with StatusMask from external production test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetNumberOfDTCByStatusMaskResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNumberOfDTCByStatusMaskResult ();

    /**
     * Copy constructor
     */
    inline  GetNumberOfDTCByStatusMaskResult (const GetNumberOfDTCByStatusMaskResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetNumberOfDTCByStatusMaskResult (uint8 StatusAvailabilityMask_, uint32 NumberOfDTC_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetNumberOfDTCByStatusMaskResult();

    /**
     * Assignment operator
     */
    inline GetNumberOfDTCByStatusMaskResult& operator = (const GetNumberOfDTCByStatusMaskResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNumberOfDTCByStatusMaskResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNumberOfDTCByStatusMaskResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNumberOfDTCByStatusMaskResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNumberOfDTCByStatusMaskResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusAvailabilityMask"

    static const int kStatusAvailabilityMask = 0;

    /**
     * Clears the field "StatusAvailabilityMask".
     *
     * The field will be set to its default value. The hasStatusAvailabilityMask()
     * method will return false.
     */
    inline void clearStatusAvailabilityMask();

    /**
     * Checks whether the field "StatusAvailabilityMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusAvailabilityMask()). Otherwise it will return false.
     */
    inline bool hasStatusAvailabilityMask () const;

    /**
     * Returns the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @return The value of the field "StatusAvailabilityMask"
     */
    inline uint8 getStatusAvailabilityMask () const;

    /**
     * Sets the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @param StatusAvailabilityMask The value which will be set
     */
    inline void setStatusAvailabilityMask (uint8 StatusAvailabilityMask_);

    // API of field "NumberOfDTC"

    static const int kNumberOfDTC = 1;

    /**
     * Clears the field "NumberOfDTC".
     *
     * The field will be set to its default value. The hasNumberOfDTC()
     * method will return false.
     */
    inline void clearNumberOfDTC();

    /**
     * Checks whether the field "NumberOfDTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfDTC()). Otherwise it will return false.
     */
    inline bool hasNumberOfDTC () const;

    /**
     * Returns the value of the member "NumberOfDTC".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "NumberOfDTC"
     */
    inline uint32 getNumberOfDTC () const;

    /**
     * Sets the value of the member "NumberOfDTC".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param NumberOfDTC The value which will be set
     */
    inline void setNumberOfDTC (uint32 NumberOfDTC_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetNumberOfDTCByStatusMaskResult &getDefaultInstance();

private:

    inline void set_has_StatusAvailabilityMask ();

    inline void clear_has_StatusAvailabilityMask ();

    inline void set_has_NumberOfDTC ();

    inline void clear_has_NumberOfDTC ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _StatusAvailabilityMask;

    uint32 _NumberOfDTC;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getStatusByDTC"
 * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetStatusByDTCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStatusByDTCStart ();

    /**
     * Copy constructor
     */
    inline  GetStatusByDTCStart (const GetStatusByDTCStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetStatusByDTCStart (uint8 Group_, uint32 DTCMask_);

    /**
     * Destructor
     */
    inline virtual  ~GetStatusByDTCStart();

    /**
     * Assignment operator
     */
    inline GetStatusByDTCStart& operator = (const GetStatusByDTCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStatusByDTCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStatusByDTCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStatusByDTCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStatusByDTCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "DTCMask"

    static const int kDTCMask = 1;

    /**
     * Clears the field "DTCMask".
     *
     * The field will be set to its default value. The hasDTCMask()
     * method will return false.
     */
    inline void clearDTCMask();

    /**
     * Checks whether the field "DTCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCMask()). Otherwise it will return false.
     */
    inline bool hasDTCMask () const;

    /**
     * Returns the value of the member "DTCMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @return The value of the field "DTCMask"
     */
    inline uint32 getDTCMask () const;

    /**
     * Sets the value of the member "DTCMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @param DTCMask The value which will be set
     */
    inline void setDTCMask (uint32 DTCMask_);

    static const GetStatusByDTCStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_DTCMask ();

    inline void clear_has_DTCMask ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Group;

    uint32 _DTCMask;

};

/**
 * The result message of the method "getStatusByDTC"
 * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetStatusByDTCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStatusByDTCResult ();

    /**
     * Copy constructor
     */
    inline  GetStatusByDTCResult (const GetStatusByDTCResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetStatusByDTCResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetStatusByDTCResult();

    /**
     * Assignment operator
     */
    inline GetStatusByDTCResult& operator = (const GetStatusByDTCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStatusByDTCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStatusByDTCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStatusByDTCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStatusByDTCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StatusAvailabilityMask"

    static const int kStatusAvailabilityMask = 0;

    /**
     * Clears the field "StatusAvailabilityMask".
     *
     * The field will be set to its default value. The hasStatusAvailabilityMask()
     * method will return false.
     */
    inline void clearStatusAvailabilityMask();

    /**
     * Checks whether the field "StatusAvailabilityMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusAvailabilityMask()). Otherwise it will return false.
     */
    inline bool hasStatusAvailabilityMask () const;

    /**
     * Returns the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @return The value of the field "StatusAvailabilityMask"
     */
    inline uint8 getStatusAvailabilityMask () const;

    /**
     * Sets the value of the member "StatusAvailabilityMask".
     *
     * The status mask which will be supported by the SW.
     *
     * @param StatusAvailabilityMask The value which will be set
     */
    inline void setStatusAvailabilityMask (uint8 StatusAvailabilityMask_);

    // API of field "ReadResultList"

    static const int kReadResultList = 1;

    /**
     * Clears the field "ReadResultList".
     *
     * The field will be set to its default value. The hasReadResultList()
     * method will return false.
     */
    inline void clearReadResultList();

    /**
     * Checks whether the field "ReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReadResultList()). Otherwise it will return false.
     */
    inline bool hasReadResultList () const;

    /**
     * Returns the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "ReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_ReadResultList& getReadResultList () const;

    /**
     * Retrieves the value of the field "ReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_ReadResultList& getReadResultListMutable ();

    /**
     * Sets the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param ReadResultList The value which will be set
     */
    inline void setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_);

    // API of field "Status"

    static const int kStatus = 2;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetStatusByDTCResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ReadResultStructure >& getT_ReadResultStructureList_DefaultInstance ();

    inline void set_has_StatusAvailabilityMask ();

    inline void clear_has_StatusAvailabilityMask ();

    inline void set_has_ReadResultList ();

    inline void clear_has_ReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _StatusAvailabilityMask;

    ::midw_diaglog_fi_types::T_ReadResultList _ReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getExtendedDataByDTC"
 * This method forwards the Extended Data of a given DTC's from external test equipment to the DiagLog component.
 */
class GetExtendedDataByDTCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetExtendedDataByDTCStart ();

    /**
     * Copy constructor
     */
    inline  GetExtendedDataByDTCStart (const GetExtendedDataByDTCStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetExtendedDataByDTCStart (uint8 Group_, uint32 DTC_, uint8 DTCExtDataRecordNumber_);

    /**
     * Destructor
     */
    inline virtual  ~GetExtendedDataByDTCStart();

    /**
     * Assignment operator
     */
    inline GetExtendedDataByDTCStart& operator = (const GetExtendedDataByDTCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetExtendedDataByDTCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetExtendedDataByDTCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetExtendedDataByDTCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetExtendedDataByDTCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "DTC"

    static const int kDTC = 1;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * The DTC as received from the production tester equipment.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * The DTC as received from the production tester equipment.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "DTCExtDataRecordNumber"

    static const int kDTCExtDataRecordNumber = 2;

    /**
     * Clears the field "DTCExtDataRecordNumber".
     *
     * The field will be set to its default value. The hasDTCExtDataRecordNumber()
     * method will return false.
     */
    inline void clearDTCExtDataRecordNumber();

    /**
     * Checks whether the field "DTCExtDataRecordNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCExtDataRecordNumber()). Otherwise it will return false.
     */
    inline bool hasDTCExtDataRecordNumber () const;

    /**
     * Returns the value of the member "DTCExtDataRecordNumber".
     *
     * Defines the ExtData to Read.
     *
     * @return The value of the field "DTCExtDataRecordNumber"
     */
    inline uint8 getDTCExtDataRecordNumber () const;

    /**
     * Sets the value of the member "DTCExtDataRecordNumber".
     *
     * Defines the ExtData to Read.
     *
     * @param DTCExtDataRecordNumber The value which will be set
     */
    inline void setDTCExtDataRecordNumber (uint8 DTCExtDataRecordNumber_);

    static const GetExtendedDataByDTCStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_DTCExtDataRecordNumber ();

    inline void clear_has_DTCExtDataRecordNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Group;

    uint32 _DTC;

    uint8 _DTCExtDataRecordNumber;

};

/**
 * The result message of the method "getExtendedDataByDTC"
 * This method forwards the Extended Data of a given DTC's from external test equipment to the DiagLog component.
 */
class GetExtendedDataByDTCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetExtendedDataByDTCResult ();

    /**
     * Copy constructor
     */
    inline  GetExtendedDataByDTCResult (const GetExtendedDataByDTCResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetExtendedDataByDTCResult (uint32 DTC_, uint8 StatusOfDtc_, const ::midw_diaglog_fi_types::T_FreezeFrameList& FreezeFrameList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetExtendedDataByDTCResult();

    /**
     * Assignment operator
     */
    inline GetExtendedDataByDTCResult& operator = (const GetExtendedDataByDTCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetExtendedDataByDTCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetExtendedDataByDTCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetExtendedDataByDTCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetExtendedDataByDTCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTC"

    static const int kDTC = 0;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * The status mask as received from the production tester equipment.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * The status mask as received from the production tester equipment.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "StatusOfDtc"

    static const int kStatusOfDtc = 1;

    /**
     * Clears the field "StatusOfDtc".
     *
     * The field will be set to its default value. The hasStatusOfDtc()
     * method will return false.
     */
    inline void clearStatusOfDtc();

    /**
     * Checks whether the field "StatusOfDtc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusOfDtc()). Otherwise it will return false.
     */
    inline bool hasStatusOfDtc () const;

    /**
     * Returns the value of the member "StatusOfDtc".
     *
     * The status byte of the DTC.
     *
     * @return The value of the field "StatusOfDtc"
     */
    inline uint8 getStatusOfDtc () const;

    /**
     * Sets the value of the member "StatusOfDtc".
     *
     * The status byte of the DTC.
     *
     * @param StatusOfDtc The value which will be set
     */
    inline void setStatusOfDtc (uint8 StatusOfDtc_);

    // API of field "FreezeFrameList"

    static const int kFreezeFrameList = 2;

    /**
     * Clears the field "FreezeFrameList".
     *
     * The field will be set to its default value. The hasFreezeFrameList()
     * method will return false.
     */
    inline void clearFreezeFrameList();

    /**
     * Checks whether the field "FreezeFrameList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFreezeFrameList()). Otherwise it will return false.
     */
    inline bool hasFreezeFrameList () const;

    /**
     * Returns the value of the member "FreezeFrameList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "FreezeFrameList"
     */
    inline const ::midw_diaglog_fi_types::T_FreezeFrameList& getFreezeFrameList () const;

    /**
     * Retrieves the value of the field "FreezeFrameList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FreezeFrameList".
     */
    inline ::midw_diaglog_fi_types::T_FreezeFrameList& getFreezeFrameListMutable ();

    /**
     * Sets the value of the member "FreezeFrameList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param FreezeFrameList The value which will be set
     */
    inline void setFreezeFrameList (const ::midw_diaglog_fi_types::T_FreezeFrameList& FreezeFrameList_);

    // API of field "Status"

    static const int kStatus = 3;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetExtendedDataByDTCResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_FreezeFrameData >& getT_FreezeFrameDataList_DefaultInstance ();

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_StatusOfDtc ();

    inline void clear_has_StatusOfDtc ();

    inline void set_has_FreezeFrameList ();

    inline void clear_has_FreezeFrameList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DTC;

    uint8 _StatusOfDtc;

    ::midw_diaglog_fi_types::T_FreezeFrameList _FreezeFrameList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "getStatusByITC"
 * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetStatusByITCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStatusByITCStart ();

    /**
     * Copy constructor
     */
    inline  GetStatusByITCStart (const GetStatusByITCStart &rhs);

    /**
     * All fields constructor
     */
    inline  GetStatusByITCStart (uint8 Group_, uint32 ITCMask_);

    /**
     * Destructor
     */
    inline virtual  ~GetStatusByITCStart();

    /**
     * Assignment operator
     */
    inline GetStatusByITCStart& operator = (const GetStatusByITCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStatusByITCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStatusByITCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStatusByITCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStatusByITCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "ITCMask"

    static const int kITCMask = 1;

    /**
     * Clears the field "ITCMask".
     *
     * The field will be set to its default value. The hasITCMask()
     * method will return false.
     */
    inline void clearITCMask();

    /**
     * Checks whether the field "ITCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setITCMask()). Otherwise it will return false.
     */
    inline bool hasITCMask () const;

    /**
     * Returns the value of the member "ITCMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @return The value of the field "ITCMask"
     */
    inline uint32 getITCMask () const;

    /**
     * Sets the value of the member "ITCMask".
     *
     * The status mask as received from the production tester equipment.
     *
     * @param ITCMask The value which will be set
     */
    inline void setITCMask (uint32 ITCMask_);

    static const GetStatusByITCStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_ITCMask ();

    inline void clear_has_ITCMask ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Group;

    uint32 _ITCMask;

};

/**
 * The result message of the method "getStatusByITC"
 * This method forwards the Status of a given DTC's from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class GetStatusByITCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetStatusByITCResult ();

    /**
     * Copy constructor
     */
    inline  GetStatusByITCResult (const GetStatusByITCResult &rhs);

    /**
     * All fields constructor
     */
    inline  GetStatusByITCResult (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~GetStatusByITCResult();

    /**
     * Assignment operator
     */
    inline GetStatusByITCResult& operator = (const GetStatusByITCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetStatusByITCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetStatusByITCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetStatusByITCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetStatusByITCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReadResultList"

    static const int kReadResultList = 0;

    /**
     * Clears the field "ReadResultList".
     *
     * The field will be set to its default value. The hasReadResultList()
     * method will return false.
     */
    inline void clearReadResultList();

    /**
     * Checks whether the field "ReadResultList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReadResultList()). Otherwise it will return false.
     */
    inline bool hasReadResultList () const;

    /**
     * Returns the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @return The value of the field "ReadResultList"
     */
    inline const ::midw_diaglog_fi_types::T_ReadResultList& getReadResultList () const;

    /**
     * Retrieves the value of the field "ReadResultList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ReadResultList".
     */
    inline ::midw_diaglog_fi_types::T_ReadResultList& getReadResultListMutable ();

    /**
     * Sets the value of the member "ReadResultList".
     *
     * List of ITCs that correspond to the mask.
     *
     * @param ReadResultList The value which will be set
     */
    inline void setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const GetStatusByITCResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_ReadResultStructure >& getT_ReadResultStructureList_DefaultInstance ();

    inline void set_has_ReadResultList ();

    inline void clear_has_ReadResultList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_ReadResultList _ReadResultList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "reportDTCSnapshotIdentification"
 * This method forwards the SnapShot Data for all captured DTCSnapshots
 */
class ReportDTCSnapshotIdentificationStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportDTCSnapshotIdentificationStart ();

    /**
     * Copy constructor
     */
    inline  ReportDTCSnapshotIdentificationStart (const ReportDTCSnapshotIdentificationStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReportDTCSnapshotIdentificationStart (uint8 Group_);

    /**
     * Destructor
     */
    inline virtual  ~ReportDTCSnapshotIdentificationStart();

    /**
     * Assignment operator
     */
    inline ReportDTCSnapshotIdentificationStart& operator = (const ReportDTCSnapshotIdentificationStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportDTCSnapshotIdentificationStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportDTCSnapshotIdentificationStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportDTCSnapshotIdentificationStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportDTCSnapshotIdentificationStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    static const ReportDTCSnapshotIdentificationStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Group;

};

/**
 * The result message of the method "reportDTCSnapshotIdentification"
 * This method forwards the SnapShot Data for all captured DTCSnapshots
 */
class ReportDTCSnapshotIdentificationResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportDTCSnapshotIdentificationResult ();

    /**
     * Copy constructor
     */
    inline  ReportDTCSnapshotIdentificationResult (const ReportDTCSnapshotIdentificationResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReportDTCSnapshotIdentificationResult (const ::midw_diaglog_fi_types::T_SnapshotIdentificationList& SnapshotIdentificationList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ReportDTCSnapshotIdentificationResult();

    /**
     * Assignment operator
     */
    inline ReportDTCSnapshotIdentificationResult& operator = (const ReportDTCSnapshotIdentificationResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportDTCSnapshotIdentificationResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportDTCSnapshotIdentificationResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportDTCSnapshotIdentificationResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportDTCSnapshotIdentificationResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SnapshotIdentificationList"

    static const int kSnapshotIdentificationList = 0;

    /**
     * Clears the field "SnapshotIdentificationList".
     *
     * The field will be set to its default value. The hasSnapshotIdentificationList()
     * method will return false.
     */
    inline void clearSnapshotIdentificationList();

    /**
     * Checks whether the field "SnapshotIdentificationList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSnapshotIdentificationList()). Otherwise it will return false.
     */
    inline bool hasSnapshotIdentificationList () const;

    /**
     * Returns the value of the member "SnapshotIdentificationList".
     *
     * List of DTCs that correspond to the mask.
     *
     * @return The value of the field "SnapshotIdentificationList"
     */
    inline const ::midw_diaglog_fi_types::T_SnapshotIdentificationList& getSnapshotIdentificationList () const;

    /**
     * Retrieves the value of the field "SnapshotIdentificationList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SnapshotIdentificationList".
     */
    inline ::midw_diaglog_fi_types::T_SnapshotIdentificationList& getSnapshotIdentificationListMutable ();

    /**
     * Sets the value of the member "SnapshotIdentificationList".
     *
     * List of DTCs that correspond to the mask.
     *
     * @param SnapshotIdentificationList The value which will be set
     */
    inline void setSnapshotIdentificationList (const ::midw_diaglog_fi_types::T_SnapshotIdentificationList& SnapshotIdentificationList_);

    // API of field "Status"

    static const int kStatus = 1;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ReportDTCSnapshotIdentificationResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_SnapshotIdentification >& getT_SnapshotIdentificationList_DefaultInstance ();

    inline void set_has_SnapshotIdentificationList ();

    inline void clear_has_SnapshotIdentificationList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_SnapshotIdentificationList _SnapshotIdentificationList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "reportDTCSnapshotRecordByDTCNumber"
 * This method forwards the SnapShot Data for a specific DTC
 */
class ReportDTCSnapshotRecordByDTCNumberStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportDTCSnapshotRecordByDTCNumberStart ();

    /**
     * Copy constructor
     */
    inline  ReportDTCSnapshotRecordByDTCNumberStart (const ReportDTCSnapshotRecordByDTCNumberStart &rhs);

    /**
     * All fields constructor
     */
    inline  ReportDTCSnapshotRecordByDTCNumberStart (uint8 Group_, uint32 DTC_, uint8 DTCSnapshotRecordNumber_);

    /**
     * Destructor
     */
    inline virtual  ~ReportDTCSnapshotRecordByDTCNumberStart();

    /**
     * Assignment operator
     */
    inline ReportDTCSnapshotRecordByDTCNumberStart& operator = (const ReportDTCSnapshotRecordByDTCNumberStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "DTC"

    static const int kDTC = 1;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * The DTC as received from the production tester equipment.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * The DTC as received from the production tester equipment.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "DTCSnapshotRecordNumber"

    static const int kDTCSnapshotRecordNumber = 2;

    /**
     * Clears the field "DTCSnapshotRecordNumber".
     *
     * The field will be set to its default value. The hasDTCSnapshotRecordNumber()
     * method will return false.
     */
    inline void clearDTCSnapshotRecordNumber();

    /**
     * Checks whether the field "DTCSnapshotRecordNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCSnapshotRecordNumber()). Otherwise it will return false.
     */
    inline bool hasDTCSnapshotRecordNumber () const;

    /**
     * Returns the value of the member "DTCSnapshotRecordNumber".
     *
     * Defines the ExtData to Read.
     *
     * @return The value of the field "DTCSnapshotRecordNumber"
     */
    inline uint8 getDTCSnapshotRecordNumber () const;

    /**
     * Sets the value of the member "DTCSnapshotRecordNumber".
     *
     * Defines the ExtData to Read.
     *
     * @param DTCSnapshotRecordNumber The value which will be set
     */
    inline void setDTCSnapshotRecordNumber (uint8 DTCSnapshotRecordNumber_);

    static const ReportDTCSnapshotRecordByDTCNumberStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_DTCSnapshotRecordNumber ();

    inline void clear_has_DTCSnapshotRecordNumber ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Group;

    uint32 _DTC;

    uint8 _DTCSnapshotRecordNumber;

};

/**
 * The result message of the method "reportDTCSnapshotRecordByDTCNumber"
 * This method forwards the SnapShot Data for a specific DTC
 */
class ReportDTCSnapshotRecordByDTCNumberResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportDTCSnapshotRecordByDTCNumberResult ();

    /**
     * Copy constructor
     */
    inline  ReportDTCSnapshotRecordByDTCNumberResult (const ReportDTCSnapshotRecordByDTCNumberResult &rhs);

    /**
     * All fields constructor
     */
    inline  ReportDTCSnapshotRecordByDTCNumberResult (uint32 DTC_, uint8 StatusOfDtc_, const ::midw_diaglog_fi_types::T_SnapshotDataList& SnapshotDataList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ReportDTCSnapshotRecordByDTCNumberResult();

    /**
     * Assignment operator
     */
    inline ReportDTCSnapshotRecordByDTCNumberResult& operator = (const ReportDTCSnapshotRecordByDTCNumberResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTC"

    static const int kDTC = 0;

    /**
     * Clears the field "DTC".
     *
     * The field will be set to its default value. The hasDTC()
     * method will return false.
     */
    inline void clearDTC();

    /**
     * Checks whether the field "DTC" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC()). Otherwise it will return false.
     */
    inline bool hasDTC () const;

    /**
     * Returns the value of the member "DTC".
     *
     * The DTC as received from the production tester equipment.
     *
     * @return The value of the field "DTC"
     */
    inline uint32 getDTC () const;

    /**
     * Sets the value of the member "DTC".
     *
     * The DTC as received from the production tester equipment.
     *
     * @param DTC The value which will be set
     */
    inline void setDTC (uint32 DTC_);

    // API of field "StatusOfDtc"

    static const int kStatusOfDtc = 1;

    /**
     * Clears the field "StatusOfDtc".
     *
     * The field will be set to its default value. The hasStatusOfDtc()
     * method will return false.
     */
    inline void clearStatusOfDtc();

    /**
     * Checks whether the field "StatusOfDtc" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatusOfDtc()). Otherwise it will return false.
     */
    inline bool hasStatusOfDtc () const;

    /**
     * Returns the value of the member "StatusOfDtc".
     *
     * The status byte of the DTC.
     *
     * @return The value of the field "StatusOfDtc"
     */
    inline uint8 getStatusOfDtc () const;

    /**
     * Sets the value of the member "StatusOfDtc".
     *
     * The status byte of the DTC.
     *
     * @param StatusOfDtc The value which will be set
     */
    inline void setStatusOfDtc (uint8 StatusOfDtc_);

    // API of field "SnapshotDataList"

    static const int kSnapshotDataList = 2;

    /**
     * Clears the field "SnapshotDataList".
     *
     * The field will be set to its default value. The hasSnapshotDataList()
     * method will return false.
     */
    inline void clearSnapshotDataList();

    /**
     * Checks whether the field "SnapshotDataList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSnapshotDataList()). Otherwise it will return false.
     */
    inline bool hasSnapshotDataList () const;

    /**
     * Returns the value of the member "SnapshotDataList".
     *
     * List of DTCs that correspond to the mask.
     *
     * @return The value of the field "SnapshotDataList"
     */
    inline const ::midw_diaglog_fi_types::T_SnapshotDataList& getSnapshotDataList () const;

    /**
     * Retrieves the value of the field "SnapshotDataList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SnapshotDataList".
     */
    inline ::midw_diaglog_fi_types::T_SnapshotDataList& getSnapshotDataListMutable ();

    /**
     * Sets the value of the member "SnapshotDataList".
     *
     * List of DTCs that correspond to the mask.
     *
     * @param SnapshotDataList The value which will be set
     */
    inline void setSnapshotDataList (const ::midw_diaglog_fi_types::T_SnapshotDataList& SnapshotDataList_);

    // API of field "Status"

    static const int kStatus = 3;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ReportDTCSnapshotRecordByDTCNumberResult &getDefaultInstance();

private:

    static const ::std::vector< ::midw_diaglog_fi_types::T_SnapshotData >& getT_SnapshotDataList_DefaultInstance ();

    inline void set_has_DTC ();

    inline void clear_has_DTC ();

    inline void set_has_StatusOfDtc ();

    inline void clear_has_StatusOfDtc ();

    inline void set_has_SnapshotDataList ();

    inline void clear_has_SnapshotDataList ();

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (4 + 31) / 32];

    uint32 _DTC;

    uint8 _StatusOfDtc;

    ::midw_diaglog_fi_types::T_SnapshotDataList _SnapshotDataList;

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "clearDTC"
 * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class ClearDTCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDTCStart ();

    /**
     * Copy constructor
     */
    inline  ClearDTCStart (const ClearDTCStart &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDTCStart (uint8 Group_, uint32 DTCMask_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDTCStart();

    /**
     * Assignment operator
     */
    inline ClearDTCStart& operator = (const ClearDTCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDTCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDTCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDTCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDTCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group; 0xFF = All
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group; 0xFF = All
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "DTCMask"

    static const int kDTCMask = 1;

    /**
     * Clears the field "DTCMask".
     *
     * The field will be set to its default value. The hasDTCMask()
     * method will return false.
     */
    inline void clearDTCMask();

    /**
     * Checks whether the field "DTCMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCMask()). Otherwise it will return false.
     */
    inline bool hasDTCMask () const;

    /**
     * Returns the value of the member "DTCMask".
     *
     * DTC Mask 0xFFFFFF = no mask
     *
     * @return The value of the field "DTCMask"
     */
    inline uint32 getDTCMask () const;

    /**
     * Sets the value of the member "DTCMask".
     *
     * DTC Mask 0xFFFFFF = no mask
     *
     * @param DTCMask The value which will be set
     */
    inline void setDTCMask (uint32 DTCMask_);

    static const ClearDTCStart &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_DTCMask ();

    inline void clear_has_DTCMask ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _Group;

    uint32 _DTCMask;

};

/**
 * The result message of the method "clearDTC"
 * This method forwards the status mask of a read request message from external test equipment to the DiagLog component.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_PRODUCTIONREADREQUEST
 */
class ClearDTCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ClearDTCResult ();

    /**
     * Copy constructor
     */
    inline  ClearDTCResult (const ClearDTCResult &rhs);

    /**
     * All fields constructor
     */
    inline  ClearDTCResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ClearDTCResult();

    /**
     * Assignment operator
     */
    inline ClearDTCResult& operator = (const ClearDTCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ClearDTCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ClearDTCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ClearDTCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ClearDTCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameters.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ClearDTCResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "Control"
 * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CONTROL
 */
class ControlStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ControlStart ();

    /**
     * Copy constructor
     */
    inline  ControlStart (const ControlStart &rhs);

    /**
     * All fields constructor
     */
    inline  ControlStart (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_);

    /**
     * Destructor
     */
    inline virtual  ~ControlStart();

    /**
     * Assignment operator
     */
    inline ControlStart& operator = (const ControlStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ControlStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ControlStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ControlStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ControlStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ControlParameter"

    static const int kControlParameter = 0;

    /**
     * Clears the field "ControlParameter".
     *
     * The field will be set to its default value. The hasControlParameter()
     * method will return false.
     */
    inline void clearControlParameter();

    /**
     * Checks whether the field "ControlParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlParameter()). Otherwise it will return false.
     */
    inline bool hasControlParameter () const;

    /**
     * Returns the value of the member "ControlParameter".
     *
     * Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @return The value of the field "ControlParameter"
     */
    inline ::midw_diaglog_fi_types::T_e8_ControlParameter getControlParameter () const;

    /**
     * Sets the value of the member "ControlParameter".
     *
     * Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @param ControlParameter The value which will be set
     */
    inline void setControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_);

    static const ControlStart &getDefaultInstance();

private:

    inline void set_has_ControlParameter ();

    inline void clear_has_ControlParameter ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_ControlParameter _ControlParameter;

};

/**
 * The result message of the method "Control"
 * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CONTROL
 */
class ControlResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ControlResult ();

    /**
     * Copy constructor
     */
    inline  ControlResult (const ControlResult &rhs);

    /**
     * All fields constructor
     */
    inline  ControlResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ControlResult();

    /**
     * Assignment operator
     */
    inline ControlResult& operator = (const ControlResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ControlResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ControlResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ControlResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ControlResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ControlResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The start message of the method "ControlDtcSetting"
 * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CONTROL
 */
class ControlDtcSettingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ControlDtcSettingStart ();

    /**
     * Copy constructor
     */
    inline  ControlDtcSettingStart (const ControlDtcSettingStart &rhs);

    /**
     * All fields constructor
     */
    inline  ControlDtcSettingStart (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_, const ::midw_diaglog_fi_types::T_ControlList& DTC_List_);

    /**
     * Destructor
     */
    inline virtual  ~ControlDtcSettingStart();

    /**
     * Assignment operator
     */
    inline ControlDtcSettingStart& operator = (const ControlDtcSettingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ControlDtcSettingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ControlDtcSettingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ControlDtcSettingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ControlDtcSettingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ControlParameter"

    static const int kControlParameter = 0;

    /**
     * Clears the field "ControlParameter".
     *
     * The field will be set to its default value. The hasControlParameter()
     * method will return false.
     */
    inline void clearControlParameter();

    /**
     * Checks whether the field "ControlParameter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setControlParameter()). Otherwise it will return false.
     */
    inline bool hasControlParameter () const;

    /**
     * Returns the value of the member "ControlParameter".
     *
     * Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @return The value of the field "ControlParameter"
     */
    inline ::midw_diaglog_fi_types::T_e8_ControlParameter getControlParameter () const;

    /**
     * Sets the value of the member "ControlParameter".
     *
     * Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @param ControlParameter The value which will be set
     */
    inline void setControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_);

    // API of field "DTC_List"

    static const int kDTC_List = 1;

    /**
     * Clears the field "DTC_List".
     *
     * The field will be set to its default value. The hasDTC_List()
     * method will return false.
     */
    inline void clearDTC_List();

    /**
     * Checks whether the field "DTC_List" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTC_List()). Otherwise it will return false.
     */
    inline bool hasDTC_List () const;

    /**
     * Returns the value of the member "DTC_List".
     *
     * Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @return The value of the field "DTC_List"
     */
    inline const ::midw_diaglog_fi_types::T_ControlList& getDTC_List () const;

    /**
     * Retrieves the value of the field "DTC_List" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DTC_List".
     */
    inline ::midw_diaglog_fi_types::T_ControlList& getDTC_ListMutable ();

    /**
     * Sets the value of the member "DTC_List".
     *
     * Configures Diaglog operational modes. e.g. Instructs DiagLog to enable or disable logging of TestResults.
     *
     * @param DTC_List The value which will be set
     */
    inline void setDTC_List (const ::midw_diaglog_fi_types::T_ControlList& DTC_List_);

    static const ControlDtcSettingStart &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_ControlParameter ();

    inline void clear_has_ControlParameter ();

    inline void set_has_DTC_List ();

    inline void clear_has_DTC_List ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_ControlParameter _ControlParameter;

    ::midw_diaglog_fi_types::T_ControlList _DTC_List;

};

/**
 * The result message of the method "ControlDtcSetting"
 * The diagnostic component can use this method to control various aspects of DiagLog functionality.  Only to be used by the Diagnostic component!
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_CONTROL
 */
class ControlDtcSettingResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ControlDtcSettingResult ();

    /**
     * Copy constructor
     */
    inline  ControlDtcSettingResult (const ControlDtcSettingResult &rhs);

    /**
     * All fields constructor
     */
    inline  ControlDtcSettingResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    /**
     * Destructor
     */
    inline virtual  ~ControlDtcSettingResult();

    /**
     * Assignment operator
     */
    inline ControlDtcSettingResult& operator = (const ControlDtcSettingResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ControlDtcSettingResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ControlDtcSettingResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ControlDtcSettingResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ControlDtcSettingResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @return The value of the field "Status"
     */
    inline ::midw_diaglog_fi_types::T_e8_MethodResultReply getStatus () const;

    /**
     * Sets the value of the member "Status".
     *
     * Indicates the validity of the MethodStart parameter.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_);

    static const ControlDtcSettingResult &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_MethodResultReply _Status;

};

/**
 * The status message of the property "DTCTriggered"
 * The DTCTriggered property forward DTC notifications from HSGMLAN modules via gating of the signals within the DTC_Triggered_HS frame.
 * This property is defined for use by the InternetApplications FBlock to allow applications to receive this vehicle-related information.
 * The gateway shall insure that the  DTCTriggeredFlag = FALSE at initialization.  HMI controller shadows shall interpret this to mean that no DTC was actually triggered on the initial Status response after notification.
 */
class DTCTriggeredStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DTCTriggeredStatus ();

    /**
     * Copy constructor
     */
    inline  DTCTriggeredStatus (const DTCTriggeredStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DTCTriggeredStatus (bool bDTCTriggeredFlag_, uint8 u8DTCSource_, uint16 u16DTCNumber_, uint8 u8DTCFailureType_, bool bDTCWarningIndicatorRequestedStatus_, bool bDTCTestFailedSincePowerUpStatus_, bool bDTCTestNotPassedSincePowerUpStatus_, bool bDTCHistoryStatus_, bool bDTCTestFailedSinceCodeClearedStatus_, bool bDTCTestNotPassedSinceCodeClearedStatus_, bool bDTCCurrentStatus_, bool bDTCCodeSupported_, ::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType e8DTCFaultType_);

    /**
     * Destructor
     */
    inline virtual  ~DTCTriggeredStatus();

    /**
     * Assignment operator
     */
    inline DTCTriggeredStatus& operator = (const DTCTriggeredStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DTCTriggeredStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DTCTriggeredStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DTCTriggeredStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DTCTriggeredStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bDTCTriggeredFlag"

    static const int kBDTCTriggeredFlag = 0;

    /**
     * Clears the field "bDTCTriggeredFlag".
     *
     * The field will be set to its default value. The hasBDTCTriggeredFlag()
     * method will return false.
     */
    inline void clearBDTCTriggeredFlag();

    /**
     * Checks whether the field "bDTCTriggeredFlag" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCTriggeredFlag()). Otherwise it will return false.
     */
    inline bool hasBDTCTriggeredFlag () const;

    /**
     * Returns the value of the member "bDTCTriggeredFlag".
     *
     * This is the DTC Triggered flag
     * The default value at initialization for the gateway and for registered controllers shall be False                                       0x8200  DTC_NOT_TRIGGERED.
     *
     * @return The value of the field "bDTCTriggeredFlag"
     */
    inline bool getBDTCTriggeredFlag () const;

    /**
     * Sets the value of the member "bDTCTriggeredFlag".
     *
     * This is the DTC Triggered flag
     * The default value at initialization for the gateway and for registered controllers shall be False                                       0x8200  DTC_NOT_TRIGGERED.
     *
     * @param bDTCTriggeredFlag The value which will be set
     */
    inline void setBDTCTriggeredFlag (bool bDTCTriggeredFlag_);

    // API of field "u8DTCSource"

    static const int kU8DTCSource = 1;

    /**
     * Clears the field "u8DTCSource".
     *
     * The field will be set to its default value. The hasU8DTCSource()
     * method will return false.
     */
    inline void clearU8DTCSource();

    /**
     * Checks whether the field "u8DTCSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DTCSource()). Otherwise it will return false.
     */
    inline bool hasU8DTCSource () const;

    /**
     * Returns the value of the member "u8DTCSource".
     *
     * ID of the Device
     *
     * @return The value of the field "u8DTCSource"
     */
    inline uint8 getU8DTCSource () const;

    /**
     * Sets the value of the member "u8DTCSource".
     *
     * ID of the Device
     *
     * @param u8DTCSource The value which will be set
     */
    inline void setU8DTCSource (uint8 u8DTCSource_);

    // API of field "u16DTCNumber"

    static const int kU16DTCNumber = 2;

    /**
     * Clears the field "u16DTCNumber".
     *
     * The field will be set to its default value. The hasU16DTCNumber()
     * method will return false.
     */
    inline void clearU16DTCNumber();

    /**
     * Checks whether the field "u16DTCNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16DTCNumber()). Otherwise it will return false.
     */
    inline bool hasU16DTCNumber () const;

    /**
     * Returns the value of the member "u16DTCNumber".
     *
     * DTC identification Number
     *
     * @return The value of the field "u16DTCNumber"
     */
    inline uint16 getU16DTCNumber () const;

    /**
     * Sets the value of the member "u16DTCNumber".
     *
     * DTC identification Number
     *
     * @param u16DTCNumber The value which will be set
     */
    inline void setU16DTCNumber (uint16 u16DTCNumber_);

    // API of field "u8DTCFailureType"

    static const int kU8DTCFailureType = 3;

    /**
     * Clears the field "u8DTCFailureType".
     *
     * The field will be set to its default value. The hasU8DTCFailureType()
     * method will return false.
     */
    inline void clearU8DTCFailureType();

    /**
     * Checks whether the field "u8DTCFailureType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DTCFailureType()). Otherwise it will return false.
     */
    inline bool hasU8DTCFailureType () const;

    /**
     * Returns the value of the member "u8DTCFailureType".
     *
     * DTC Failure Type                                       0x8200  short FTB. This is the addional Parameter to the DTCNumber for unique identifacation of the fault e.g. 02=ShortToGround 04=Open
     *
     * @return The value of the field "u8DTCFailureType"
     */
    inline uint8 getU8DTCFailureType () const;

    /**
     * Sets the value of the member "u8DTCFailureType".
     *
     * DTC Failure Type                                       0x8200  short FTB. This is the addional Parameter to the DTCNumber for unique identifacation of the fault e.g. 02=ShortToGround 04=Open
     *
     * @param u8DTCFailureType The value which will be set
     */
    inline void setU8DTCFailureType (uint8 u8DTCFailureType_);

    // API of field "bDTCWarningIndicatorRequestedStatus"

    static const int kBDTCWarningIndicatorRequestedStatus = 4;

    /**
     * Clears the field "bDTCWarningIndicatorRequestedStatus".
     *
     * The field will be set to its default value. The hasBDTCWarningIndicatorRequestedStatus()
     * method will return false.
     */
    inline void clearBDTCWarningIndicatorRequestedStatus();

    /**
     * Checks whether the field "bDTCWarningIndicatorRequestedStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCWarningIndicatorRequestedStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCWarningIndicatorRequestedStatus () const;

    /**
     * Returns the value of the member "bDTCWarningIndicatorRequestedStatus".
     *
     * Part of DTC Status Information. Not supported in GM see GIS321 Chapter 3.4.5.
     *
     * @return The value of the field "bDTCWarningIndicatorRequestedStatus"
     */
    inline bool getBDTCWarningIndicatorRequestedStatus () const;

    /**
     * Sets the value of the member "bDTCWarningIndicatorRequestedStatus".
     *
     * Part of DTC Status Information. Not supported in GM see GIS321 Chapter 3.4.5.
     *
     * @param bDTCWarningIndicatorRequestedStatus The value which will be set
     */
    inline void setBDTCWarningIndicatorRequestedStatus (bool bDTCWarningIndicatorRequestedStatus_);

    // API of field "bDTCTestFailedSincePowerUpStatus"

    static const int kBDTCTestFailedSincePowerUpStatus = 5;

    /**
     * Clears the field "bDTCTestFailedSincePowerUpStatus".
     *
     * The field will be set to its default value. The hasBDTCTestFailedSincePowerUpStatus()
     * method will return false.
     */
    inline void clearBDTCTestFailedSincePowerUpStatus();

    /**
     * Checks whether the field "bDTCTestFailedSincePowerUpStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCTestFailedSincePowerUpStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCTestFailedSincePowerUpStatus () const;

    /**
     * Returns the value of the member "bDTCTestFailedSincePowerUpStatus".
     *
     * Part of DTC Status Information. TRUE if DTC Failed since Power up. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCTestFailedSincePowerUpStatus"
     */
    inline bool getBDTCTestFailedSincePowerUpStatus () const;

    /**
     * Sets the value of the member "bDTCTestFailedSincePowerUpStatus".
     *
     * Part of DTC Status Information. TRUE if DTC Failed since Power up. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCTestFailedSincePowerUpStatus The value which will be set
     */
    inline void setBDTCTestFailedSincePowerUpStatus (bool bDTCTestFailedSincePowerUpStatus_);

    // API of field "bDTCTestNotPassedSincePowerUpStatus"

    static const int kBDTCTestNotPassedSincePowerUpStatus = 6;

    /**
     * Clears the field "bDTCTestNotPassedSincePowerUpStatus".
     *
     * The field will be set to its default value. The hasBDTCTestNotPassedSincePowerUpStatus()
     * method will return false.
     */
    inline void clearBDTCTestNotPassedSincePowerUpStatus();

    /**
     * Checks whether the field "bDTCTestNotPassedSincePowerUpStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCTestNotPassedSincePowerUpStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCTestNotPassedSincePowerUpStatus () const;

    /**
     * Returns the value of the member "bDTCTestNotPassedSincePowerUpStatus".
     *
     * Part of DTC Status Information. TRUE if DTC not Passed since Power up. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCTestNotPassedSincePowerUpStatus"
     */
    inline bool getBDTCTestNotPassedSincePowerUpStatus () const;

    /**
     * Sets the value of the member "bDTCTestNotPassedSincePowerUpStatus".
     *
     * Part of DTC Status Information. TRUE if DTC not Passed since Power up. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCTestNotPassedSincePowerUpStatus The value which will be set
     */
    inline void setBDTCTestNotPassedSincePowerUpStatus (bool bDTCTestNotPassedSincePowerUpStatus_);

    // API of field "bDTCHistoryStatus"

    static const int kBDTCHistoryStatus = 7;

    /**
     * Clears the field "bDTCHistoryStatus".
     *
     * The field will be set to its default value. The hasBDTCHistoryStatus()
     * method will return false.
     */
    inline void clearBDTCHistoryStatus();

    /**
     * Checks whether the field "bDTCHistoryStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCHistoryStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCHistoryStatus () const;

    /**
     * Returns the value of the member "bDTCHistoryStatus".
     *
     * Part of DTC Status Information. TRUE if DTC is verified Detected in the System now or Detected earlyer at not longer active. MUST in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCHistoryStatus"
     */
    inline bool getBDTCHistoryStatus () const;

    /**
     * Sets the value of the member "bDTCHistoryStatus".
     *
     * Part of DTC Status Information. TRUE if DTC is verified Detected in the System now or Detected earlyer at not longer active. MUST in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCHistoryStatus The value which will be set
     */
    inline void setBDTCHistoryStatus (bool bDTCHistoryStatus_);

    // API of field "bDTCTestFailedSinceCodeClearedStatus"

    static const int kBDTCTestFailedSinceCodeClearedStatus = 8;

    /**
     * Clears the field "bDTCTestFailedSinceCodeClearedStatus".
     *
     * The field will be set to its default value. The hasBDTCTestFailedSinceCodeClearedStatus()
     * method will return false.
     */
    inline void clearBDTCTestFailedSinceCodeClearedStatus();

    /**
     * Checks whether the field "bDTCTestFailedSinceCodeClearedStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCTestFailedSinceCodeClearedStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCTestFailedSinceCodeClearedStatus () const;

    /**
     * Returns the value of the member "bDTCTestFailedSinceCodeClearedStatus".
     *
     * Part of DTC Status Information. TRUE if DTC Failed since last Clear. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCTestFailedSinceCodeClearedStatus"
     */
    inline bool getBDTCTestFailedSinceCodeClearedStatus () const;

    /**
     * Sets the value of the member "bDTCTestFailedSinceCodeClearedStatus".
     *
     * Part of DTC Status Information. TRUE if DTC Failed since last Clear. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCTestFailedSinceCodeClearedStatus The value which will be set
     */
    inline void setBDTCTestFailedSinceCodeClearedStatus (bool bDTCTestFailedSinceCodeClearedStatus_);

    // API of field "bDTCTestNotPassedSinceCodeClearedStatus"

    static const int kBDTCTestNotPassedSinceCodeClearedStatus = 9;

    /**
     * Clears the field "bDTCTestNotPassedSinceCodeClearedStatus".
     *
     * The field will be set to its default value. The hasBDTCTestNotPassedSinceCodeClearedStatus()
     * method will return false.
     */
    inline void clearBDTCTestNotPassedSinceCodeClearedStatus();

    /**
     * Checks whether the field "bDTCTestNotPassedSinceCodeClearedStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCTestNotPassedSinceCodeClearedStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCTestNotPassedSinceCodeClearedStatus () const;

    /**
     * Returns the value of the member "bDTCTestNotPassedSinceCodeClearedStatus".
     *
     * Part of DTC Status Information. TRUE if DTC not Passed since last Clear. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCTestNotPassedSinceCodeClearedStatus"
     */
    inline bool getBDTCTestNotPassedSinceCodeClearedStatus () const;

    /**
     * Sets the value of the member "bDTCTestNotPassedSinceCodeClearedStatus".
     *
     * Part of DTC Status Information. TRUE if DTC not Passed since last Clear. Optional in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCTestNotPassedSinceCodeClearedStatus The value which will be set
     */
    inline void setBDTCTestNotPassedSinceCodeClearedStatus (bool bDTCTestNotPassedSinceCodeClearedStatus_);

    // API of field "bDTCCurrentStatus"

    static const int kBDTCCurrentStatus = 10;

    /**
     * Clears the field "bDTCCurrentStatus".
     *
     * The field will be set to its default value. The hasBDTCCurrentStatus()
     * method will return false.
     */
    inline void clearBDTCCurrentStatus();

    /**
     * Checks whether the field "bDTCCurrentStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCCurrentStatus()). Otherwise it will return false.
     */
    inline bool hasBDTCCurrentStatus () const;

    /**
     * Returns the value of the member "bDTCCurrentStatus".
     *
     * Part of DTC Status Information. TRUE if DTC currently Failed. MUST in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCCurrentStatus"
     */
    inline bool getBDTCCurrentStatus () const;

    /**
     * Sets the value of the member "bDTCCurrentStatus".
     *
     * Part of DTC Status Information. TRUE if DTC currently Failed. MUST in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCCurrentStatus The value which will be set
     */
    inline void setBDTCCurrentStatus (bool bDTCCurrentStatus_);

    // API of field "bDTCCodeSupported"

    static const int kBDTCCodeSupported = 11;

    /**
     * Clears the field "bDTCCodeSupported".
     *
     * The field will be set to its default value. The hasBDTCCodeSupported()
     * method will return false.
     */
    inline void clearBDTCCodeSupported();

    /**
     * Checks whether the field "bDTCCodeSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDTCCodeSupported()). Otherwise it will return false.
     */
    inline bool hasBDTCCodeSupported () const;

    /**
     * Returns the value of the member "bDTCCodeSupported".
     *
     * Part of DTC Status Information. TRUE if DTC is calibrated in the Device. MUST in GM see GIS321 Chapter 3.4.5
     *
     * @return The value of the field "bDTCCodeSupported"
     */
    inline bool getBDTCCodeSupported () const;

    /**
     * Sets the value of the member "bDTCCodeSupported".
     *
     * Part of DTC Status Information. TRUE if DTC is calibrated in the Device. MUST in GM see GIS321 Chapter 3.4.5
     *
     * @param bDTCCodeSupported The value which will be set
     */
    inline void setBDTCCodeSupported (bool bDTCCodeSupported_);

    // API of field "e8DTCFaultType"

    static const int kE8DTCFaultType = 12;

    /**
     * Clears the field "e8DTCFaultType".
     *
     * The field will be set to its default value. The hasE8DTCFaultType()
     * method will return false.
     */
    inline void clearE8DTCFaultType();

    /**
     * Checks whether the field "e8DTCFaultType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DTCFaultType()). Otherwise it will return false.
     */
    inline bool hasE8DTCFaultType () const;

    /**
     * Returns the value of the member "e8DTCFaultType".
     *
     * This is the DTC Fault Type gated from the the LSGMLAN signal DTCI_DTCFaultType.
     * MOST Enumerations match those in the GMLAN signal.
     *
     * @return The value of the field "e8DTCFaultType"
     */
    inline ::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType getE8DTCFaultType () const;

    /**
     * Sets the value of the member "e8DTCFaultType".
     *
     * This is the DTC Fault Type gated from the the LSGMLAN signal DTCI_DTCFaultType.
     * MOST Enumerations match those in the GMLAN signal.
     *
     * @param e8DTCFaultType The value which will be set
     */
    inline void setE8DTCFaultType (::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType e8DTCFaultType_);

    static const DTCTriggeredStatus &getDefaultInstance();

private:

    inline void set_has_bDTCTriggeredFlag ();

    inline void clear_has_bDTCTriggeredFlag ();

    inline void set_has_u8DTCSource ();

    inline void clear_has_u8DTCSource ();

    inline void set_has_u16DTCNumber ();

    inline void clear_has_u16DTCNumber ();

    inline void set_has_u8DTCFailureType ();

    inline void clear_has_u8DTCFailureType ();

    inline void set_has_bDTCWarningIndicatorRequestedStatus ();

    inline void clear_has_bDTCWarningIndicatorRequestedStatus ();

    inline void set_has_bDTCTestFailedSincePowerUpStatus ();

    inline void clear_has_bDTCTestFailedSincePowerUpStatus ();

    inline void set_has_bDTCTestNotPassedSincePowerUpStatus ();

    inline void clear_has_bDTCTestNotPassedSincePowerUpStatus ();

    inline void set_has_bDTCHistoryStatus ();

    inline void clear_has_bDTCHistoryStatus ();

    inline void set_has_bDTCTestFailedSinceCodeClearedStatus ();

    inline void clear_has_bDTCTestFailedSinceCodeClearedStatus ();

    inline void set_has_bDTCTestNotPassedSinceCodeClearedStatus ();

    inline void clear_has_bDTCTestNotPassedSinceCodeClearedStatus ();

    inline void set_has_bDTCCurrentStatus ();

    inline void clear_has_bDTCCurrentStatus ();

    inline void set_has_bDTCCodeSupported ();

    inline void clear_has_bDTCCodeSupported ();

    inline void set_has_e8DTCFaultType ();

    inline void clear_has_e8DTCFaultType ();

    uint32 _has_bits_[ (13 + 31) / 32];

    bool _bDTCTriggeredFlag;

    uint8 _u8DTCSource;

    uint16 _u16DTCNumber;

    uint8 _u8DTCFailureType;

    bool _bDTCWarningIndicatorRequestedStatus;

    bool _bDTCTestFailedSincePowerUpStatus;

    bool _bDTCTestNotPassedSincePowerUpStatus;

    bool _bDTCHistoryStatus;

    bool _bDTCTestFailedSinceCodeClearedStatus;

    bool _bDTCTestNotPassedSinceCodeClearedStatus;

    bool _bDTCCurrentStatus;

    bool _bDTCCodeSupported;

    ::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType _e8DTCFaultType;

};

/**
 * The start message of the method "SetFactorySettingsNew"
 * This function request the component to set all Variables (depending on USER                                       0x8200  TEF or OEM) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS                                       0x8200</p>
 * <p>Service ID - CCA_C_U16_SRV_DIAGLOG                                       0x8200</p>
 * <p>App ID - CCA_C_U16_APP_DIAGLOG                                       0x8200</p>
 * <p>Function ID - MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components                                       0x8200  else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetFactorySettingsNewStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewStart ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewStart (const SetFactorySettingsNewStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewStart (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewStart();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewStart& operator = (const SetFactorySettingsNewStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Unique Diaglog Group
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Unique Diaglog Group
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER                                       0x8200  TEF                                       0x8200  OEM                                       0x8200  GET</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER                                       0x8200  TEF                                       0x8200  OEM                                       0x8200  GET</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    static const SetFactorySettingsNewStart &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

};

/**
 * The result message of the method "SetFactorySettingsNew"
 * This function request the component to set all Variables (depending on USER                                       0x8200  TEF or OEM) to default
 * <p>FUNCID = e.g. AUDIO_C_U16_FKTID_SET_FACTORY_SETTINGS                                       0x8200</p>
 * <p>Service ID - CCA_C_U16_SRV_DIAGLOG                                       0x8200</p>
 * <p>App ID - CCA_C_U16_APP_DIAGLOG                                       0x8200</p>
 * <p>Function ID - MIDW_DIAGLOGFI_C_U16_SETFACTORYSETTINGSNEW</p>
 * <p>The following points have to support by each component:</p>
 * The property answer "SetFactorySettingsStatus" must be available in max 10 sec over all Components                                       0x8200  else a Timeout occurred.
 * The Answer SetFactorySettings MessageResult must be send immediately.
 * The command must accept a new reuqest if the process is still running. The Component itself must decide what to do. Normaly the component itself have do decide if it has to retrigger or wait for the last answer. Independend of that it has to confirm the new request.
 */
class SetFactorySettingsNewResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetFactorySettingsNewResult ();

    /**
     * Copy constructor
     */
    inline  SetFactorySettingsNewResult (const SetFactorySettingsNewResult &rhs);

    /**
     * All fields constructor
     */
    inline  SetFactorySettingsNewResult (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_);

    /**
     * Destructor
     */
    inline virtual  ~SetFactorySettingsNewResult();

    /**
     * Assignment operator
     */
    inline SetFactorySettingsNewResult& operator = (const SetFactorySettingsNewResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetFactorySettingsNewResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DefSetStateGroup"

    static const int kDefSetStateGroup = 0;

    /**
     * Clears the field "DefSetStateGroup".
     *
     * The field will be set to its default value. The hasDefSetStateGroup()
     * method will return false.
     */
    inline void clearDefSetStateGroup();

    /**
     * Checks whether the field "DefSetStateGroup" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateGroup()). Otherwise it will return false.
     */
    inline bool hasDefSetStateGroup () const;

    /**
     * Returns the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>Unique Diaglog Group</p>
     *
     * @return The value of the field "DefSetStateGroup"
     */
    inline ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType getDefSetStateGroup () const;

    /**
     * Sets the value of the member "DefSetStateGroup".
     *
     * Identifier of the Default Setting Group.
     * <p>Unique Diaglog Group</p>
     *
     * @param DefSetStateGroup The value which will be set
     */
    inline void setDefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_);

    // API of field "DefSetStateMode"

    static const int kDefSetStateMode = 1;

    /**
     * Clears the field "DefSetStateMode".
     *
     * The field will be set to its default value. The hasDefSetStateMode()
     * method will return false.
     */
    inline void clearDefSetStateMode();

    /**
     * Checks whether the field "DefSetStateMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateMode()). Otherwise it will return false.
     */
    inline bool hasDefSetStateMode () const;

    /**
     * Returns the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER                                       0x8200  TEF                                       0x8200  OEM                                       0x8200  GET</p>
     *
     * @return The value of the field "DefSetStateMode"
     */
    inline ::midw_diagnostics_fi_types::T_e8_DefSetMode getDefSetStateMode () const;

    /**
     * Sets the value of the member "DefSetStateMode".
     *
     * current Default Setting Id.
     * <p>E.g. USER                                       0x8200  TEF                                       0x8200  OEM                                       0x8200  GET</p>
     *
     * @param DefSetStateMode The value which will be set
     */
    inline void setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_);

    // API of field "DefSetStateSuccessful"

    static const int kDefSetStateSuccessful = 2;

    /**
     * Clears the field "DefSetStateSuccessful".
     *
     * The field will be set to its default value. The hasDefSetStateSuccessful()
     * method will return false.
     */
    inline void clearDefSetStateSuccessful();

    /**
     * Checks whether the field "DefSetStateSuccessful" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateSuccessful()). Otherwise it will return false.
     */
    inline bool hasDefSetStateSuccessful () const;

    /**
     * Returns the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     *
     * @return The value of the field "DefSetStateSuccessful"
     */
    inline bool getDefSetStateSuccessful () const;

    /**
     * Sets the value of the member "DefSetStateSuccessful".
     *
     * DefSet State True means: all parameter have their default state.
     *
     * @param DefSetStateSuccessful The value which will be set
     */
    inline void setDefSetStateSuccessful (bool DefSetStateSuccessful_);

    // API of field "DefSetStateFirstDifferentParameterId"

    static const int kDefSetStateFirstDifferentParameterId = 3;

    /**
     * Clears the field "DefSetStateFirstDifferentParameterId".
     *
     * The field will be set to its default value. The hasDefSetStateFirstDifferentParameterId()
     * method will return false.
     */
    inline void clearDefSetStateFirstDifferentParameterId();

    /**
     * Checks whether the field "DefSetStateFirstDifferentParameterId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDefSetStateFirstDifferentParameterId()). Otherwise it will return false.
     */
    inline bool hasDefSetStateFirstDifferentParameterId () const;

    /**
     * Returns the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>not supported.</p>
     *
     * @return The value of the field "DefSetStateFirstDifferentParameterId"
     */
    inline uint16 getDefSetStateFirstDifferentParameterId () const;

    /**
     * Sets the value of the member "DefSetStateFirstDifferentParameterId".
     *
     * <p>not supported.</p>
     *
     * @param DefSetStateFirstDifferentParameterId The value which will be set
     */
    inline void setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_);

    static const SetFactorySettingsNewResult &getDefaultInstance();

private:

    inline void set_has_DefSetStateGroup ();

    inline void clear_has_DefSetStateGroup ();

    inline void set_has_DefSetStateMode ();

    inline void clear_has_DefSetStateMode ();

    inline void set_has_DefSetStateSuccessful ();

    inline void clear_has_DefSetStateSuccessful ();

    inline void set_has_DefSetStateFirstDifferentParameterId ();

    inline void clear_has_DefSetStateFirstDifferentParameterId ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType _DefSetStateGroup;

    ::midw_diagnostics_fi_types::T_e8_DefSetMode _DefSetStateMode;

    bool _DefSetStateSuccessful;

    uint16 _DefSetStateFirstDifferentParameterId;

};

/**
 * The status message of the property "SendActiveDTCList"
 * This property indicates that there has been a change in status of a DTC and new list of active DTCs is sentto the clients.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_SENDACTIVEDTCLIST
 */
class SendActiveDTCListStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendActiveDTCListStatus ();

    /**
     * Copy constructor
     */
    inline  SendActiveDTCListStatus (const SendActiveDTCListStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SendActiveDTCListStatus (const ::midw_diaglog_fi_types::T_ActiveDTCList& ActiveDTCList_);

    /**
     * Destructor
     */
    inline virtual  ~SendActiveDTCListStatus();

    /**
     * Assignment operator
     */
    inline SendActiveDTCListStatus& operator = (const SendActiveDTCListStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendActiveDTCListStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendActiveDTCListStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendActiveDTCListStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendActiveDTCListStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ActiveDTCList"

    static const int kActiveDTCList = 0;

    /**
     * Clears the field "ActiveDTCList".
     *
     * The field will be set to its default value. The hasActiveDTCList()
     * method will return false.
     */
    inline void clearActiveDTCList();

    /**
     * Checks whether the field "ActiveDTCList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveDTCList()). Otherwise it will return false.
     */
    inline bool hasActiveDTCList () const;

    /**
     * Returns the value of the member "ActiveDTCList".
     *
     * T_ActiveDTCList.ActiveDTCList:  This is the list of the DTCs which are currently active.
     *
     * @return The value of the field "ActiveDTCList"
     */
    inline const ::midw_diaglog_fi_types::T_ActiveDTCList& getActiveDTCList () const;

    /**
     * Retrieves the value of the field "ActiveDTCList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ActiveDTCList".
     */
    inline ::midw_diaglog_fi_types::T_ActiveDTCList& getActiveDTCListMutable ();

    /**
     * Sets the value of the member "ActiveDTCList".
     *
     * T_ActiveDTCList.ActiveDTCList:  This is the list of the DTCs which are currently active.
     *
     * @param ActiveDTCList The value which will be set
     */
    inline void setActiveDTCList (const ::midw_diaglog_fi_types::T_ActiveDTCList& ActiveDTCList_);

    static const SendActiveDTCListStatus &getDefaultInstance();

private:

    static const ::std::vector< uint32 >& getUint32List_DefaultInstance ();

    inline void set_has_ActiveDTCList ();

    inline void clear_has_ActiveDTCList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_ActiveDTCList _ActiveDTCList;

};

/**
 * The status message of the property "DtcStatusChanged"
 * This property indicates that there has been a change in status of one specific DTC and current status of DTC is sent to the clients.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED
 */
class DtcStatusChangedStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DtcStatusChangedStatus ();

    /**
     * Copy constructor
     */
    inline  DtcStatusChangedStatus (const DtcStatusChangedStatus &rhs);

    /**
     * All fields constructor
     */
    inline  DtcStatusChangedStatus (const ::midw_diaglog_fi_types::T_ReadResultStructure& DTCResponse_);

    /**
     * Destructor
     */
    inline virtual  ~DtcStatusChangedStatus();

    /**
     * Assignment operator
     */
    inline DtcStatusChangedStatus& operator = (const DtcStatusChangedStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DtcStatusChangedStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DtcStatusChangedStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DtcStatusChangedStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DtcStatusChangedStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DTCResponse"

    static const int kDTCResponse = 0;

    /**
     * Clears the field "DTCResponse".
     *
     * The field will be set to its default value. The hasDTCResponse()
     * method will return false.
     */
    inline void clearDTCResponse();

    /**
     * Checks whether the field "DTCResponse" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCResponse()). Otherwise it will return false.
     */
    inline bool hasDTCResponse () const;

    /**
     * Returns the value of the member "DTCResponse".
     *
     * T_ReadResultStructure.DTC:          Value of DTC.
     * T_ReadResultStructure.StatusOfDtc:  This is the current status of DTC.
     *
     * @return The value of the field "DTCResponse"
     */
    inline const ::midw_diaglog_fi_types::T_ReadResultStructure& getDTCResponse () const;

    /**
     * Retrieves the value of the field "DTCResponse" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DTCResponse".
     */
    inline ::midw_diaglog_fi_types::T_ReadResultStructure& getDTCResponseMutable ();

    /**
     * Sets the value of the member "DTCResponse".
     *
     * T_ReadResultStructure.DTC:          Value of DTC.
     * T_ReadResultStructure.StatusOfDtc:  This is the current status of DTC.
     *
     * @param DTCResponse The value which will be set
     */
    inline void setDTCResponse (const ::midw_diaglog_fi_types::T_ReadResultStructure& DTCResponse_);

    static const DtcStatusChangedStatus &getDefaultInstance();

private:

    inline void set_has_DTCResponse ();

    inline void clear_has_DTCResponse ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::midw_diaglog_fi_types::T_ReadResultStructure _DTCResponse;

};

/**
 * The upreg message of the property "DtcStatusChanged"
 * This property indicates that there has been a change in status of one specific DTC and current status of DTC is sent to the clients.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED
 */
class DtcStatusChangedUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DtcStatusChangedUpReg ();

    /**
     * Copy constructor
     */
    inline  DtcStatusChangedUpReg (const DtcStatusChangedUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  DtcStatusChangedUpReg (uint8 Group_, uint32 DTCNumber_, uint8 DTCStatusBitMask_);

    /**
     * Destructor
     */
    inline virtual  ~DtcStatusChangedUpReg();

    /**
     * Assignment operator
     */
    inline DtcStatusChangedUpReg& operator = (const DtcStatusChangedUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DtcStatusChangedUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DtcStatusChangedUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DtcStatusChangedUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DtcStatusChangedUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "DTCNumber"

    static const int kDTCNumber = 1;

    /**
     * Clears the field "DTCNumber".
     *
     * The field will be set to its default value. The hasDTCNumber()
     * method will return false.
     */
    inline void clearDTCNumber();

    /**
     * Checks whether the field "DTCNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCNumber()). Otherwise it will return false.
     */
    inline bool hasDTCNumber () const;

    /**
     * Returns the value of the member "DTCNumber".
     *
     * This is three bytes number of the specific DTC to be notified.
     *
     * @return The value of the field "DTCNumber"
     */
    inline uint32 getDTCNumber () const;

    /**
     * Sets the value of the member "DTCNumber".
     *
     * This is three bytes number of the specific DTC to be notified.
     *
     * @param DTCNumber The value which will be set
     */
    inline void setDTCNumber (uint32 DTCNumber_);

    // API of field "DTCStatusBitMask"

    static const int kDTCStatusBitMask = 2;

    /**
     * Clears the field "DTCStatusBitMask".
     *
     * The field will be set to its default value. The hasDTCStatusBitMask()
     * method will return false.
     */
    inline void clearDTCStatusBitMask();

    /**
     * Checks whether the field "DTCStatusBitMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCStatusBitMask()). Otherwise it will return false.
     */
    inline bool hasDTCStatusBitMask () const;

    /**
     * Returns the value of the member "DTCStatusBitMask".
     *
     * This is mask for the DTC to be used for notification (DTC Status Bit Mask 0xFF = no mask).
     *
     * @return The value of the field "DTCStatusBitMask"
     */
    inline uint8 getDTCStatusBitMask () const;

    /**
     * Sets the value of the member "DTCStatusBitMask".
     *
     * This is mask for the DTC to be used for notification (DTC Status Bit Mask 0xFF = no mask).
     *
     * @param DTCStatusBitMask The value which will be set
     */
    inline void setDTCStatusBitMask (uint8 DTCStatusBitMask_);

    static const DtcStatusChangedUpReg &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_DTCNumber ();

    inline void clear_has_DTCNumber ();

    inline void set_has_DTCStatusBitMask ();

    inline void clear_has_DTCStatusBitMask ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Group;

    uint32 _DTCNumber;

    uint8 _DTCStatusBitMask;

};

/**
 * The relUpReg message of the property "DtcStatusChanged"
 * This property indicates that there has been a change in status of one specific DTC and current status of DTC is sent to the clients.
 * App ID - CCA_C_U16_APP_DIAGLOG
 * Service ID - CCA_C_U16_SRV_DIAGLOG
 * Function ID - MIDW_DIAGLOGFI_C_U16_DTCSTATUSCHANGED
 */
class DtcStatusChangedRelUpReg  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DtcStatusChangedRelUpReg ();

    /**
     * Copy constructor
     */
    inline  DtcStatusChangedRelUpReg (const DtcStatusChangedRelUpReg &rhs);

    /**
     * All fields constructor
     */
    inline  DtcStatusChangedRelUpReg (uint8 Group_, uint32 DTCNumber_, uint8 DTCStatusBitMask_);

    /**
     * Destructor
     */
    inline virtual  ~DtcStatusChangedRelUpReg();

    /**
     * Assignment operator
     */
    inline DtcStatusChangedRelUpReg& operator = (const DtcStatusChangedRelUpReg& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DtcStatusChangedRelUpReg& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DtcStatusChangedRelUpReg& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DtcStatusChangedRelUpReg& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DtcStatusChangedRelUpReg& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Group"

    static const int kGroup = 0;

    /**
     * Clears the field "Group".
     *
     * The field will be set to its default value. The hasGroup()
     * method will return false.
     */
    inline void clearGroup();

    /**
     * Checks whether the field "Group" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setGroup()). Otherwise it will return false.
     */
    inline bool hasGroup () const;

    /**
     * Returns the value of the member "Group".
     *
     * Errormemory Group
     *
     * @return The value of the field "Group"
     */
    inline uint8 getGroup () const;

    /**
     * Sets the value of the member "Group".
     *
     * Errormemory Group
     *
     * @param Group The value which will be set
     */
    inline void setGroup (uint8 Group_);

    // API of field "DTCNumber"

    static const int kDTCNumber = 1;

    /**
     * Clears the field "DTCNumber".
     *
     * The field will be set to its default value. The hasDTCNumber()
     * method will return false.
     */
    inline void clearDTCNumber();

    /**
     * Checks whether the field "DTCNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCNumber()). Otherwise it will return false.
     */
    inline bool hasDTCNumber () const;

    /**
     * Returns the value of the member "DTCNumber".
     *
     * This is three bytes number of the specific DTC to be notified.
     *
     * @return The value of the field "DTCNumber"
     */
    inline uint32 getDTCNumber () const;

    /**
     * Sets the value of the member "DTCNumber".
     *
     * This is three bytes number of the specific DTC to be notified.
     *
     * @param DTCNumber The value which will be set
     */
    inline void setDTCNumber (uint32 DTCNumber_);

    // API of field "DTCStatusBitMask"

    static const int kDTCStatusBitMask = 2;

    /**
     * Clears the field "DTCStatusBitMask".
     *
     * The field will be set to its default value. The hasDTCStatusBitMask()
     * method will return false.
     */
    inline void clearDTCStatusBitMask();

    /**
     * Checks whether the field "DTCStatusBitMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDTCStatusBitMask()). Otherwise it will return false.
     */
    inline bool hasDTCStatusBitMask () const;

    /**
     * Returns the value of the member "DTCStatusBitMask".
     *
     * This is mask for the DTC to be used for notification (DTC Status Bit Mask 0xFF = no mask).
     *
     * @return The value of the field "DTCStatusBitMask"
     */
    inline uint8 getDTCStatusBitMask () const;

    /**
     * Sets the value of the member "DTCStatusBitMask".
     *
     * This is mask for the DTC to be used for notification (DTC Status Bit Mask 0xFF = no mask).
     *
     * @param DTCStatusBitMask The value which will be set
     */
    inline void setDTCStatusBitMask (uint8 DTCStatusBitMask_);

    static const DtcStatusChangedRelUpReg &getDefaultInstance();

private:

    inline void set_has_Group ();

    inline void clear_has_Group ();

    inline void set_has_DTCNumber ();

    inline void clear_has_DTCNumber ();

    inline void set_has_DTCStatusBitMask ();

    inline void clear_has_DTCStatusBitMask ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _Group;

    uint32 _DTCNumber;

    uint8 _DTCStatusBitMask;

};

inline  SaveTestResultStart::SaveTestResultStart ()  :
    _TestResultList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SaveTestResultStart::SaveTestResultStart (const SaveTestResultStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TestResultList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SaveTestResultStart::SaveTestResultStart (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_)  :
    _TestResultList (TestResultList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SaveTestResultStart::~SaveTestResultStart() {
}

inline SaveTestResultStart& SaveTestResultStart::operator = (const SaveTestResultStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestResultList()) {
            setTestResultList(rhs.getTestResultList());
        } else {
            clearTestResultList();
        }
    }
    return *this;
}

inline bool SaveTestResultStart::operator == (const SaveTestResultStart& rhs) const {
    return (((!hasTestResultList() && !rhs.hasTestResultList()) || getTestResultList() == rhs.getTestResultList()));
}

inline bool SaveTestResultStart::operator != (const SaveTestResultStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SaveTestResultStart::operator < (const SaveTestResultStart& rhs) const {
    if (hasTestResultList() || rhs.hasTestResultList()) {
        if (getTestResultList() < rhs.getTestResultList()) return true;
        if (getTestResultList() > rhs.getTestResultList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SaveTestResultStart::clone() {
    return new SaveTestResultStart(*this);
}

inline bool SaveTestResultStart::operator > (const SaveTestResultStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SaveTestResultStart::clear() {
    clearTestResultList();
}

inline void SaveTestResultStart::clearTestResultList() {
    if (hasTestResultList()) {
         clear_has_TestResultList();
        _TestResultList.clear();
     }
}

inline bool SaveTestResultStart::hasTestResultList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_TestResultList& SaveTestResultStart::getTestResultList () const {
    return _TestResultList;
}

inline ::midw_diaglog_fi_types::T_TestResultList& SaveTestResultStart::getTestResultListMutable () {
    set_has_TestResultList();
    return _TestResultList;
}

inline void SaveTestResultStart::setTestResultList (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_) {
    set_has_TestResultList();
    this->_TestResultList = TestResultList_;
}

inline void SaveTestResultStart::set_has_TestResultList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SaveTestResultStart::clear_has_TestResultList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SaveTestResultResult::SaveTestResultResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SaveTestResultResult::SaveTestResultResult (const SaveTestResultResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SaveTestResultResult::SaveTestResultResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "SaveTestResultResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SaveTestResultResult::~SaveTestResultResult() {
}

inline SaveTestResultResult& SaveTestResultResult::operator = (const SaveTestResultResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SaveTestResultResult::operator == (const SaveTestResultResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SaveTestResultResult::operator != (const SaveTestResultResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SaveTestResultResult::operator < (const SaveTestResultResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SaveTestResultResult::clone() {
    return new SaveTestResultResult(*this);
}

inline bool SaveTestResultResult::operator > (const SaveTestResultResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SaveTestResultResult::clear() {
    clearStatus();
}

inline void SaveTestResultResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool SaveTestResultResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply SaveTestResultResult::getStatus () const {
    return _Status;
}

inline void SaveTestResultResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "SaveTestResultResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void SaveTestResultResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SaveTestResultResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SaveTestResultDynamicalDTCStart::SaveTestResultDynamicalDTCStart ()  :
    _TestResultList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SaveTestResultDynamicalDTCStart::SaveTestResultDynamicalDTCStart (const SaveTestResultDynamicalDTCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _TestResultList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SaveTestResultDynamicalDTCStart::SaveTestResultDynamicalDTCStart (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_)  :
    _TestResultList (TestResultList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SaveTestResultDynamicalDTCStart::~SaveTestResultDynamicalDTCStart() {
}

inline SaveTestResultDynamicalDTCStart& SaveTestResultDynamicalDTCStart::operator = (const SaveTestResultDynamicalDTCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTestResultList()) {
            setTestResultList(rhs.getTestResultList());
        } else {
            clearTestResultList();
        }
    }
    return *this;
}

inline bool SaveTestResultDynamicalDTCStart::operator == (const SaveTestResultDynamicalDTCStart& rhs) const {
    return (((!hasTestResultList() && !rhs.hasTestResultList()) || getTestResultList() == rhs.getTestResultList()));
}

inline bool SaveTestResultDynamicalDTCStart::operator != (const SaveTestResultDynamicalDTCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SaveTestResultDynamicalDTCStart::operator < (const SaveTestResultDynamicalDTCStart& rhs) const {
    if (hasTestResultList() || rhs.hasTestResultList()) {
        if (getTestResultList() < rhs.getTestResultList()) return true;
        if (getTestResultList() > rhs.getTestResultList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SaveTestResultDynamicalDTCStart::clone() {
    return new SaveTestResultDynamicalDTCStart(*this);
}

inline bool SaveTestResultDynamicalDTCStart::operator > (const SaveTestResultDynamicalDTCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SaveTestResultDynamicalDTCStart::clear() {
    clearTestResultList();
}

inline void SaveTestResultDynamicalDTCStart::clearTestResultList() {
    if (hasTestResultList()) {
         clear_has_TestResultList();
        _TestResultList.clear();
     }
}

inline bool SaveTestResultDynamicalDTCStart::hasTestResultList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_TestResultList& SaveTestResultDynamicalDTCStart::getTestResultList () const {
    return _TestResultList;
}

inline ::midw_diaglog_fi_types::T_TestResultList& SaveTestResultDynamicalDTCStart::getTestResultListMutable () {
    set_has_TestResultList();
    return _TestResultList;
}

inline void SaveTestResultDynamicalDTCStart::setTestResultList (const ::midw_diaglog_fi_types::T_TestResultList& TestResultList_) {
    set_has_TestResultList();
    this->_TestResultList = TestResultList_;
}

inline void SaveTestResultDynamicalDTCStart::set_has_TestResultList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SaveTestResultDynamicalDTCStart::clear_has_TestResultList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SaveTestResultDynamicalDTCResult::SaveTestResultDynamicalDTCResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SaveTestResultDynamicalDTCResult::SaveTestResultDynamicalDTCResult (const SaveTestResultDynamicalDTCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SaveTestResultDynamicalDTCResult::SaveTestResultDynamicalDTCResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "SaveTestResultDynamicalDTCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SaveTestResultDynamicalDTCResult::~SaveTestResultDynamicalDTCResult() {
}

inline SaveTestResultDynamicalDTCResult& SaveTestResultDynamicalDTCResult::operator = (const SaveTestResultDynamicalDTCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SaveTestResultDynamicalDTCResult::operator == (const SaveTestResultDynamicalDTCResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SaveTestResultDynamicalDTCResult::operator != (const SaveTestResultDynamicalDTCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SaveTestResultDynamicalDTCResult::operator < (const SaveTestResultDynamicalDTCResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SaveTestResultDynamicalDTCResult::clone() {
    return new SaveTestResultDynamicalDTCResult(*this);
}

inline bool SaveTestResultDynamicalDTCResult::operator > (const SaveTestResultDynamicalDTCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SaveTestResultDynamicalDTCResult::clear() {
    clearStatus();
}

inline void SaveTestResultDynamicalDTCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool SaveTestResultDynamicalDTCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply SaveTestResultDynamicalDTCResult::getStatus () const {
    return _Status;
}

inline void SaveTestResultDynamicalDTCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "SaveTestResultDynamicalDTCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void SaveTestResultDynamicalDTCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void SaveTestResultDynamicalDTCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ProductionReadRequestStart::ProductionReadRequestStart ()  :
    _Protocol (::midw_diaglog_fi_types::T_e8_Protocol__UDS),
    _StatusMask (0u),
    _ITCMask (0u),
    _Option (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProductionReadRequestStart::ProductionReadRequestStart (const ProductionReadRequestStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Protocol (::midw_diaglog_fi_types::T_e8_Protocol__UDS),
    _StatusMask (0u),
    _ITCMask (0u),
    _Option (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProductionReadRequestStart::ProductionReadRequestStart (::midw_diaglog_fi_types::T_e8_Protocol Protocol_, uint8 StatusMask_, uint32 ITCMask_, uint32 Option_)  :
    _Protocol (Protocol_),
    _StatusMask (StatusMask_),
    _ITCMask (ITCMask_),
    _Option (Option_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_Protocol_IsValid(Protocol_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Protocol_, "T_e8_Protocol", "Protocol", "ProductionReadRequestStart");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProductionReadRequestStart::~ProductionReadRequestStart() {
}

inline ProductionReadRequestStart& ProductionReadRequestStart::operator = (const ProductionReadRequestStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtocol()) {
            setProtocol(rhs.getProtocol());
        } else {
            clearProtocol();
        }
        if (rhs.hasStatusMask()) {
            setStatusMask(rhs.getStatusMask());
        } else {
            clearStatusMask();
        }
        if (rhs.hasITCMask()) {
            setITCMask(rhs.getITCMask());
        } else {
            clearITCMask();
        }
        if (rhs.hasOption()) {
            setOption(rhs.getOption());
        } else {
            clearOption();
        }
    }
    return *this;
}

inline bool ProductionReadRequestStart::operator == (const ProductionReadRequestStart& rhs) const {
    return (((!hasProtocol() && !rhs.hasProtocol()) || getProtocol() == rhs.getProtocol()) &&
        ((!hasStatusMask() && !rhs.hasStatusMask()) || getStatusMask() == rhs.getStatusMask()) &&
        ((!hasITCMask() && !rhs.hasITCMask()) || getITCMask() == rhs.getITCMask()) &&
        ((!hasOption() && !rhs.hasOption()) || getOption() == rhs.getOption()));
}

inline bool ProductionReadRequestStart::operator != (const ProductionReadRequestStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ProductionReadRequestStart::operator < (const ProductionReadRequestStart& rhs) const {
    if (hasProtocol() || rhs.hasProtocol()) {
        if ((uint32)getProtocol() < (uint32)rhs.getProtocol()) return true;
        if ((uint32)getProtocol() > (uint32)rhs.getProtocol()) return false;
    }
    if (hasStatusMask() || rhs.hasStatusMask()) {
        if (getStatusMask() < rhs.getStatusMask()) return true;
        if (getStatusMask() > rhs.getStatusMask()) return false;
    }
    if (hasITCMask() || rhs.hasITCMask()) {
        if (getITCMask() < rhs.getITCMask()) return true;
        if (getITCMask() > rhs.getITCMask()) return false;
    }
    if (hasOption() || rhs.hasOption()) {
        if (getOption() < rhs.getOption()) return true;
        if (getOption() > rhs.getOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProductionReadRequestStart::clone() {
    return new ProductionReadRequestStart(*this);
}

inline bool ProductionReadRequestStart::operator > (const ProductionReadRequestStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProductionReadRequestStart::clear() {
    clearProtocol();
    clearStatusMask();
    clearITCMask();
    clearOption();
}

inline void ProductionReadRequestStart::clearProtocol() {
    if (hasProtocol()) {
         clear_has_Protocol();
        _Protocol = ::midw_diaglog_fi_types::T_e8_Protocol__UDS;
     }
}

inline bool ProductionReadRequestStart::hasProtocol () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_Protocol ProductionReadRequestStart::getProtocol () const {
    return _Protocol;
}

inline void ProductionReadRequestStart::setProtocol (::midw_diaglog_fi_types::T_e8_Protocol Protocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_Protocol_IsValid(Protocol_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Protocol_, "T_e8_Protocol", "Protocol", "ProductionReadRequestStart");
    }
    set_has_Protocol();
    this->_Protocol = Protocol_;
}

inline void ProductionReadRequestStart::clearStatusMask() {
    if (hasStatusMask()) {
         clear_has_StatusMask();
        _StatusMask = 0u;
     }
}

inline bool ProductionReadRequestStart::hasStatusMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ProductionReadRequestStart::getStatusMask () const {
    return _StatusMask;
}

inline void ProductionReadRequestStart::setStatusMask (uint8 StatusMask_) {
    set_has_StatusMask();
    this->_StatusMask = StatusMask_;
}

inline void ProductionReadRequestStart::clearITCMask() {
    if (hasITCMask()) {
         clear_has_ITCMask();
        _ITCMask = 0u;
     }
}

inline bool ProductionReadRequestStart::hasITCMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 ProductionReadRequestStart::getITCMask () const {
    return _ITCMask;
}

inline void ProductionReadRequestStart::setITCMask (uint32 ITCMask_) {
    set_has_ITCMask();
    this->_ITCMask = ITCMask_;
}

inline void ProductionReadRequestStart::clearOption() {
    if (hasOption()) {
         clear_has_Option();
        _Option = 0u;
     }
}

inline bool ProductionReadRequestStart::hasOption () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 ProductionReadRequestStart::getOption () const {
    return _Option;
}

inline void ProductionReadRequestStart::setOption (uint32 Option_) {
    set_has_Option();
    this->_Option = Option_;
}

inline void ProductionReadRequestStart::set_has_Protocol () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProductionReadRequestStart::clear_has_Protocol () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProductionReadRequestStart::set_has_StatusMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProductionReadRequestStart::clear_has_StatusMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ProductionReadRequestStart::set_has_ITCMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void ProductionReadRequestStart::clear_has_ITCMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ProductionReadRequestStart::set_has_Option () {
    _has_bits_[0] |= 1u << 3;
}

inline void ProductionReadRequestStart::clear_has_Option () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ProductionReadRequestResult::ProductionReadRequestResult ()  :
    _ProductionReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProductionReadRequestResult::ProductionReadRequestResult (const ProductionReadRequestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ProductionReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProductionReadRequestResult::ProductionReadRequestResult (const ::midw_diaglog_fi_types::T_ProductionReadResultList& ProductionReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _ProductionReadResultList (ProductionReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ProductionReadRequestResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProductionReadRequestResult::~ProductionReadRequestResult() {
}

inline ProductionReadRequestResult& ProductionReadRequestResult::operator = (const ProductionReadRequestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProductionReadResultList()) {
            setProductionReadResultList(rhs.getProductionReadResultList());
        } else {
            clearProductionReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ProductionReadRequestResult::operator == (const ProductionReadRequestResult& rhs) const {
    return (((!hasProductionReadResultList() && !rhs.hasProductionReadResultList()) || getProductionReadResultList() == rhs.getProductionReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ProductionReadRequestResult::operator != (const ProductionReadRequestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ProductionReadRequestResult::operator < (const ProductionReadRequestResult& rhs) const {
    if (hasProductionReadResultList() || rhs.hasProductionReadResultList()) {
        if (getProductionReadResultList() < rhs.getProductionReadResultList()) return true;
        if (getProductionReadResultList() > rhs.getProductionReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProductionReadRequestResult::clone() {
    return new ProductionReadRequestResult(*this);
}

inline bool ProductionReadRequestResult::operator > (const ProductionReadRequestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProductionReadRequestResult::clear() {
    clearProductionReadResultList();
    clearStatus();
}

inline void ProductionReadRequestResult::clearProductionReadResultList() {
    if (hasProductionReadResultList()) {
         clear_has_ProductionReadResultList();
        _ProductionReadResultList.clear();
     }
}

inline bool ProductionReadRequestResult::hasProductionReadResultList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ProductionReadResultList& ProductionReadRequestResult::getProductionReadResultList () const {
    return _ProductionReadResultList;
}

inline ::midw_diaglog_fi_types::T_ProductionReadResultList& ProductionReadRequestResult::getProductionReadResultListMutable () {
    set_has_ProductionReadResultList();
    return _ProductionReadResultList;
}

inline void ProductionReadRequestResult::setProductionReadResultList (const ::midw_diaglog_fi_types::T_ProductionReadResultList& ProductionReadResultList_) {
    set_has_ProductionReadResultList();
    this->_ProductionReadResultList = ProductionReadResultList_;
}

inline void ProductionReadRequestResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ProductionReadRequestResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ProductionReadRequestResult::getStatus () const {
    return _Status;
}

inline void ProductionReadRequestResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ProductionReadRequestResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ProductionReadRequestResult::set_has_ProductionReadResultList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProductionReadRequestResult::clear_has_ProductionReadResultList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ProductionReadRequestResult::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void ProductionReadRequestResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CustomerReadRequestStart::CustomerReadRequestStart ()  :
    _Protocol (::midw_diaglog_fi_types::T_e8_Protocol__UDS),
    _StatusMask (0u),
    _DTCMask (0u),
    _Option (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CustomerReadRequestStart::CustomerReadRequestStart (const CustomerReadRequestStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Protocol (::midw_diaglog_fi_types::T_e8_Protocol__UDS),
    _StatusMask (0u),
    _DTCMask (0u),
    _Option (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CustomerReadRequestStart::CustomerReadRequestStart (::midw_diaglog_fi_types::T_e8_Protocol Protocol_, uint8 StatusMask_, uint32 DTCMask_, uint32 Option_)  :
    _Protocol (Protocol_),
    _StatusMask (StatusMask_),
    _DTCMask (DTCMask_),
    _Option (Option_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_Protocol_IsValid(Protocol_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Protocol_, "T_e8_Protocol", "Protocol", "CustomerReadRequestStart");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CustomerReadRequestStart::~CustomerReadRequestStart() {
}

inline CustomerReadRequestStart& CustomerReadRequestStart::operator = (const CustomerReadRequestStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProtocol()) {
            setProtocol(rhs.getProtocol());
        } else {
            clearProtocol();
        }
        if (rhs.hasStatusMask()) {
            setStatusMask(rhs.getStatusMask());
        } else {
            clearStatusMask();
        }
        if (rhs.hasDTCMask()) {
            setDTCMask(rhs.getDTCMask());
        } else {
            clearDTCMask();
        }
        if (rhs.hasOption()) {
            setOption(rhs.getOption());
        } else {
            clearOption();
        }
    }
    return *this;
}

inline bool CustomerReadRequestStart::operator == (const CustomerReadRequestStart& rhs) const {
    return (((!hasProtocol() && !rhs.hasProtocol()) || getProtocol() == rhs.getProtocol()) &&
        ((!hasStatusMask() && !rhs.hasStatusMask()) || getStatusMask() == rhs.getStatusMask()) &&
        ((!hasDTCMask() && !rhs.hasDTCMask()) || getDTCMask() == rhs.getDTCMask()) &&
        ((!hasOption() && !rhs.hasOption()) || getOption() == rhs.getOption()));
}

inline bool CustomerReadRequestStart::operator != (const CustomerReadRequestStart& rhs) const {
    return ! (*this == rhs);
}

inline bool CustomerReadRequestStart::operator < (const CustomerReadRequestStart& rhs) const {
    if (hasProtocol() || rhs.hasProtocol()) {
        if ((uint32)getProtocol() < (uint32)rhs.getProtocol()) return true;
        if ((uint32)getProtocol() > (uint32)rhs.getProtocol()) return false;
    }
    if (hasStatusMask() || rhs.hasStatusMask()) {
        if (getStatusMask() < rhs.getStatusMask()) return true;
        if (getStatusMask() > rhs.getStatusMask()) return false;
    }
    if (hasDTCMask() || rhs.hasDTCMask()) {
        if (getDTCMask() < rhs.getDTCMask()) return true;
        if (getDTCMask() > rhs.getDTCMask()) return false;
    }
    if (hasOption() || rhs.hasOption()) {
        if (getOption() < rhs.getOption()) return true;
        if (getOption() > rhs.getOption()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CustomerReadRequestStart::clone() {
    return new CustomerReadRequestStart(*this);
}

inline bool CustomerReadRequestStart::operator > (const CustomerReadRequestStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CustomerReadRequestStart::clear() {
    clearProtocol();
    clearStatusMask();
    clearDTCMask();
    clearOption();
}

inline void CustomerReadRequestStart::clearProtocol() {
    if (hasProtocol()) {
         clear_has_Protocol();
        _Protocol = ::midw_diaglog_fi_types::T_e8_Protocol__UDS;
     }
}

inline bool CustomerReadRequestStart::hasProtocol () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_Protocol CustomerReadRequestStart::getProtocol () const {
    return _Protocol;
}

inline void CustomerReadRequestStart::setProtocol (::midw_diaglog_fi_types::T_e8_Protocol Protocol_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_Protocol_IsValid(Protocol_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Protocol_, "T_e8_Protocol", "Protocol", "CustomerReadRequestStart");
    }
    set_has_Protocol();
    this->_Protocol = Protocol_;
}

inline void CustomerReadRequestStart::clearStatusMask() {
    if (hasStatusMask()) {
         clear_has_StatusMask();
        _StatusMask = 0u;
     }
}

inline bool CustomerReadRequestStart::hasStatusMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 CustomerReadRequestStart::getStatusMask () const {
    return _StatusMask;
}

inline void CustomerReadRequestStart::setStatusMask (uint8 StatusMask_) {
    set_has_StatusMask();
    this->_StatusMask = StatusMask_;
}

inline void CustomerReadRequestStart::clearDTCMask() {
    if (hasDTCMask()) {
         clear_has_DTCMask();
        _DTCMask = 0u;
     }
}

inline bool CustomerReadRequestStart::hasDTCMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 CustomerReadRequestStart::getDTCMask () const {
    return _DTCMask;
}

inline void CustomerReadRequestStart::setDTCMask (uint32 DTCMask_) {
    set_has_DTCMask();
    this->_DTCMask = DTCMask_;
}

inline void CustomerReadRequestStart::clearOption() {
    if (hasOption()) {
         clear_has_Option();
        _Option = 0u;
     }
}

inline bool CustomerReadRequestStart::hasOption () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 CustomerReadRequestStart::getOption () const {
    return _Option;
}

inline void CustomerReadRequestStart::setOption (uint32 Option_) {
    set_has_Option();
    this->_Option = Option_;
}

inline void CustomerReadRequestStart::set_has_Protocol () {
    _has_bits_[0] |= 1u << 0;
}

inline void CustomerReadRequestStart::clear_has_Protocol () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CustomerReadRequestStart::set_has_StatusMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void CustomerReadRequestStart::clear_has_StatusMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void CustomerReadRequestStart::set_has_DTCMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void CustomerReadRequestStart::clear_has_DTCMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void CustomerReadRequestStart::set_has_Option () {
    _has_bits_[0] |= 1u << 3;
}

inline void CustomerReadRequestStart::clear_has_Option () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  CustomerReadRequestResult::CustomerReadRequestResult ()  :
    _CustomerReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CustomerReadRequestResult::CustomerReadRequestResult (const CustomerReadRequestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _CustomerReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CustomerReadRequestResult::CustomerReadRequestResult (const ::midw_diaglog_fi_types::T_CustomerReadResultList& CustomerReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _CustomerReadResultList (CustomerReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "CustomerReadRequestResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CustomerReadRequestResult::~CustomerReadRequestResult() {
}

inline CustomerReadRequestResult& CustomerReadRequestResult::operator = (const CustomerReadRequestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCustomerReadResultList()) {
            setCustomerReadResultList(rhs.getCustomerReadResultList());
        } else {
            clearCustomerReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool CustomerReadRequestResult::operator == (const CustomerReadRequestResult& rhs) const {
    return (((!hasCustomerReadResultList() && !rhs.hasCustomerReadResultList()) || getCustomerReadResultList() == rhs.getCustomerReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool CustomerReadRequestResult::operator != (const CustomerReadRequestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool CustomerReadRequestResult::operator < (const CustomerReadRequestResult& rhs) const {
    if (hasCustomerReadResultList() || rhs.hasCustomerReadResultList()) {
        if (getCustomerReadResultList() < rhs.getCustomerReadResultList()) return true;
        if (getCustomerReadResultList() > rhs.getCustomerReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CustomerReadRequestResult::clone() {
    return new CustomerReadRequestResult(*this);
}

inline bool CustomerReadRequestResult::operator > (const CustomerReadRequestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CustomerReadRequestResult::clear() {
    clearCustomerReadResultList();
    clearStatus();
}

inline void CustomerReadRequestResult::clearCustomerReadResultList() {
    if (hasCustomerReadResultList()) {
         clear_has_CustomerReadResultList();
        _CustomerReadResultList.clear();
     }
}

inline bool CustomerReadRequestResult::hasCustomerReadResultList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_CustomerReadResultList& CustomerReadRequestResult::getCustomerReadResultList () const {
    return _CustomerReadResultList;
}

inline ::midw_diaglog_fi_types::T_CustomerReadResultList& CustomerReadRequestResult::getCustomerReadResultListMutable () {
    set_has_CustomerReadResultList();
    return _CustomerReadResultList;
}

inline void CustomerReadRequestResult::setCustomerReadResultList (const ::midw_diaglog_fi_types::T_CustomerReadResultList& CustomerReadResultList_) {
    set_has_CustomerReadResultList();
    this->_CustomerReadResultList = CustomerReadResultList_;
}

inline void CustomerReadRequestResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool CustomerReadRequestResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply CustomerReadRequestResult::getStatus () const {
    return _Status;
}

inline void CustomerReadRequestResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "CustomerReadRequestResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void CustomerReadRequestResult::set_has_CustomerReadResultList () {
    _has_bits_[0] |= 1u << 0;
}

inline void CustomerReadRequestResult::clear_has_CustomerReadResultList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CustomerReadRequestResult::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void CustomerReadRequestResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetItcInformationStart::GetItcInformationStart ()  :
    _Group (0u),
    _ITCList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetItcInformationStart::GetItcInformationStart (const GetItcInformationStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _ITCList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetItcInformationStart::GetItcInformationStart (uint8 Group_, const ::std::vector< uint16 >& ITCList_)  :
    _Group (Group_),
    _ITCList (ITCList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetItcInformationStart::~GetItcInformationStart() {
}

inline GetItcInformationStart& GetItcInformationStart::operator = (const GetItcInformationStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasITCList()) {
            setITCList(rhs.getITCList());
        } else {
            clearITCList();
        }
    }
    return *this;
}

inline bool GetItcInformationStart::operator == (const GetItcInformationStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasITCList() && !rhs.hasITCList()) || getITCList() == rhs.getITCList()));
}

inline bool GetItcInformationStart::operator != (const GetItcInformationStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetItcInformationStart::operator < (const GetItcInformationStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasITCList() || rhs.hasITCList()) {
        if (getITCList() < rhs.getITCList()) return true;
        if (getITCList() > rhs.getITCList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetItcInformationStart::clone() {
    return new GetItcInformationStart(*this);
}

inline bool GetItcInformationStart::operator > (const GetItcInformationStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetItcInformationStart::clear() {
    clearGroup();
    clearITCList();
}

inline void GetItcInformationStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetItcInformationStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetItcInformationStart::getGroup () const {
    return _Group;
}

inline void GetItcInformationStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetItcInformationStart::clearITCList() {
    if (hasITCList()) {
         clear_has_ITCList();
        _ITCList.clear();
     }
}

inline bool GetItcInformationStart::hasITCList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< uint16 >& GetItcInformationStart::getITCList () const {
    return _ITCList;
}

inline ::std::vector< uint16 >& GetItcInformationStart::getITCListMutable () {
    set_has_ITCList();
    return _ITCList;
}

inline void GetItcInformationStart::setITCList (const ::std::vector< uint16 >& ITCList_) {
    set_has_ITCList();
    this->_ITCList = ITCList_;
}

inline void GetItcInformationStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetItcInformationStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetItcInformationStart::set_has_ITCList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetItcInformationStart::clear_has_ITCList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetItcInformationResult::GetItcInformationResult ()  :
    _ItcInformationList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetItcInformationResult::GetItcInformationResult (const GetItcInformationResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ItcInformationList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetItcInformationResult::GetItcInformationResult (const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& ItcInformationList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _ItcInformationList (ItcInformationList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetItcInformationResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetItcInformationResult::~GetItcInformationResult() {
}

inline GetItcInformationResult& GetItcInformationResult::operator = (const GetItcInformationResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasItcInformationList()) {
            setItcInformationList(rhs.getItcInformationList());
        } else {
            clearItcInformationList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetItcInformationResult::operator == (const GetItcInformationResult& rhs) const {
    return (((!hasItcInformationList() && !rhs.hasItcInformationList()) || getItcInformationList() == rhs.getItcInformationList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetItcInformationResult::operator != (const GetItcInformationResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetItcInformationResult::operator < (const GetItcInformationResult& rhs) const {
    if (hasItcInformationList() || rhs.hasItcInformationList()) {
        if (getItcInformationList() < rhs.getItcInformationList()) return true;
        if (getItcInformationList() > rhs.getItcInformationList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetItcInformationResult::clone() {
    return new GetItcInformationResult(*this);
}

inline bool GetItcInformationResult::operator > (const GetItcInformationResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetItcInformationResult::clear() {
    clearItcInformationList();
    clearStatus();
}

inline void GetItcInformationResult::clearItcInformationList() {
    if (hasItcInformationList()) {
         clear_has_ItcInformationList();
        _ItcInformationList.clear();
     }
}

inline bool GetItcInformationResult::hasItcInformationList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& GetItcInformationResult::getItcInformationList () const {
    return _ItcInformationList;
}

inline ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& GetItcInformationResult::getItcInformationListMutable () {
    set_has_ItcInformationList();
    return _ItcInformationList;
}

inline void GetItcInformationResult::setItcInformationList (const ::std::vector< ::midw_diaglog_fi_types::T_ITC_Information >& ItcInformationList_) {
    set_has_ItcInformationList();
    this->_ItcInformationList = ItcInformationList_;
}

inline void GetItcInformationResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetItcInformationResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetItcInformationResult::getStatus () const {
    return _Status;
}

inline void GetItcInformationResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetItcInformationResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetItcInformationResult::set_has_ItcInformationList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetItcInformationResult::clear_has_ItcInformationList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetItcInformationResult::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetItcInformationResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ProductionClearRequestResult::ProductionClearRequestResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ProductionClearRequestResult::ProductionClearRequestResult (const ProductionClearRequestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ProductionClearRequestResult::ProductionClearRequestResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ProductionClearRequestResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ProductionClearRequestResult::~ProductionClearRequestResult() {
}

inline ProductionClearRequestResult& ProductionClearRequestResult::operator = (const ProductionClearRequestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ProductionClearRequestResult::operator == (const ProductionClearRequestResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ProductionClearRequestResult::operator != (const ProductionClearRequestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ProductionClearRequestResult::operator < (const ProductionClearRequestResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ProductionClearRequestResult::clone() {
    return new ProductionClearRequestResult(*this);
}

inline bool ProductionClearRequestResult::operator > (const ProductionClearRequestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ProductionClearRequestResult::clear() {
    clearStatus();
}

inline void ProductionClearRequestResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ProductionClearRequestResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ProductionClearRequestResult::getStatus () const {
    return _Status;
}

inline void ProductionClearRequestResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ProductionClearRequestResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ProductionClearRequestResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void ProductionClearRequestResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CustomerClearRequestResult::CustomerClearRequestResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CustomerClearRequestResult::CustomerClearRequestResult (const CustomerClearRequestResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CustomerClearRequestResult::CustomerClearRequestResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "CustomerClearRequestResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CustomerClearRequestResult::~CustomerClearRequestResult() {
}

inline CustomerClearRequestResult& CustomerClearRequestResult::operator = (const CustomerClearRequestResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool CustomerClearRequestResult::operator == (const CustomerClearRequestResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool CustomerClearRequestResult::operator != (const CustomerClearRequestResult& rhs) const {
    return ! (*this == rhs);
}

inline bool CustomerClearRequestResult::operator < (const CustomerClearRequestResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CustomerClearRequestResult::clone() {
    return new CustomerClearRequestResult(*this);
}

inline bool CustomerClearRequestResult::operator > (const CustomerClearRequestResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CustomerClearRequestResult::clear() {
    clearStatus();
}

inline void CustomerClearRequestResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool CustomerClearRequestResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply CustomerClearRequestResult::getStatus () const {
    return _Status;
}

inline void CustomerClearRequestResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "CustomerClearRequestResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void CustomerClearRequestResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void CustomerClearRequestResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WriteToMediaStart::WriteToMediaStart ()  :
    _Media (::midw_diaglog_fi_types::T_e8_VDLMediaType__FFS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WriteToMediaStart::WriteToMediaStart (const WriteToMediaStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Media (::midw_diaglog_fi_types::T_e8_VDLMediaType__FFS)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WriteToMediaStart::WriteToMediaStart (::midw_diaglog_fi_types::T_e8_VDLMediaType Media_)  :
    _Media (Media_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_VDLMediaType_IsValid(Media_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Media_, "T_e8_VDLMediaType", "Media", "WriteToMediaStart");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WriteToMediaStart::~WriteToMediaStart() {
}

inline WriteToMediaStart& WriteToMediaStart::operator = (const WriteToMediaStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasMedia()) {
            setMedia(rhs.getMedia());
        } else {
            clearMedia();
        }
    }
    return *this;
}

inline bool WriteToMediaStart::operator == (const WriteToMediaStart& rhs) const {
    return (((!hasMedia() && !rhs.hasMedia()) || getMedia() == rhs.getMedia()));
}

inline bool WriteToMediaStart::operator != (const WriteToMediaStart& rhs) const {
    return ! (*this == rhs);
}

inline bool WriteToMediaStart::operator < (const WriteToMediaStart& rhs) const {
    if (hasMedia() || rhs.hasMedia()) {
        if ((uint32)getMedia() < (uint32)rhs.getMedia()) return true;
        if ((uint32)getMedia() > (uint32)rhs.getMedia()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WriteToMediaStart::clone() {
    return new WriteToMediaStart(*this);
}

inline bool WriteToMediaStart::operator > (const WriteToMediaStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WriteToMediaStart::clear() {
    clearMedia();
}

inline void WriteToMediaStart::clearMedia() {
    if (hasMedia()) {
         clear_has_Media();
        _Media = ::midw_diaglog_fi_types::T_e8_VDLMediaType__FFS;
     }
}

inline bool WriteToMediaStart::hasMedia () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_VDLMediaType WriteToMediaStart::getMedia () const {
    return _Media;
}

inline void WriteToMediaStart::setMedia (::midw_diaglog_fi_types::T_e8_VDLMediaType Media_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_VDLMediaType_IsValid(Media_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Media_, "T_e8_VDLMediaType", "Media", "WriteToMediaStart");
    }
    set_has_Media();
    this->_Media = Media_;
}

inline void WriteToMediaStart::set_has_Media () {
    _has_bits_[0] |= 1u << 0;
}

inline void WriteToMediaStart::clear_has_Media () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  WriteToMediaResult::WriteToMediaResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  WriteToMediaResult::WriteToMediaResult (const WriteToMediaResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  WriteToMediaResult::WriteToMediaResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "WriteToMediaResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  WriteToMediaResult::~WriteToMediaResult() {
}

inline WriteToMediaResult& WriteToMediaResult::operator = (const WriteToMediaResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool WriteToMediaResult::operator == (const WriteToMediaResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool WriteToMediaResult::operator != (const WriteToMediaResult& rhs) const {
    return ! (*this == rhs);
}

inline bool WriteToMediaResult::operator < (const WriteToMediaResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* WriteToMediaResult::clone() {
    return new WriteToMediaResult(*this);
}

inline bool WriteToMediaResult::operator > (const WriteToMediaResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void WriteToMediaResult::clear() {
    clearStatus();
}

inline void WriteToMediaResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool WriteToMediaResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply WriteToMediaResult::getStatus () const {
    return _Status;
}

inline void WriteToMediaResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "WriteToMediaResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void WriteToMediaResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void WriteToMediaResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DTCActiveStatus::DTCActiveStatus ()  :
    _IsDTCActive (false),
    _DTC (0u),
    _DTCStatus (0u),
    _DTCFailureType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DTCActiveStatus::DTCActiveStatus (const DTCActiveStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _IsDTCActive (false),
    _DTC (0u),
    _DTCStatus (0u),
    _DTCFailureType (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DTCActiveStatus::DTCActiveStatus (bool IsDTCActive_, uint32 DTC_, uint8 DTCStatus_, uint8 DTCFailureType_)  :
    _IsDTCActive (IsDTCActive_),
    _DTC (DTC_),
    _DTCStatus (DTCStatus_),
    _DTCFailureType (DTCFailureType_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DTCActiveStatus::~DTCActiveStatus() {
}

inline DTCActiveStatus& DTCActiveStatus::operator = (const DTCActiveStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIsDTCActive()) {
            setIsDTCActive(rhs.getIsDTCActive());
        } else {
            clearIsDTCActive();
        }
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasDTCStatus()) {
            setDTCStatus(rhs.getDTCStatus());
        } else {
            clearDTCStatus();
        }
        if (rhs.hasDTCFailureType()) {
            setDTCFailureType(rhs.getDTCFailureType());
        } else {
            clearDTCFailureType();
        }
    }
    return *this;
}

inline bool DTCActiveStatus::operator == (const DTCActiveStatus& rhs) const {
    return (((!hasIsDTCActive() && !rhs.hasIsDTCActive()) || getIsDTCActive() == rhs.getIsDTCActive()) &&
        ((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasDTCStatus() && !rhs.hasDTCStatus()) || getDTCStatus() == rhs.getDTCStatus()) &&
        ((!hasDTCFailureType() && !rhs.hasDTCFailureType()) || getDTCFailureType() == rhs.getDTCFailureType()));
}

inline bool DTCActiveStatus::operator != (const DTCActiveStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DTCActiveStatus::operator < (const DTCActiveStatus& rhs) const {
    if (hasIsDTCActive() || rhs.hasIsDTCActive()) {
        if (getIsDTCActive() < rhs.getIsDTCActive()) return true;
        if (getIsDTCActive() > rhs.getIsDTCActive()) return false;
    }
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasDTCStatus() || rhs.hasDTCStatus()) {
        if (getDTCStatus() < rhs.getDTCStatus()) return true;
        if (getDTCStatus() > rhs.getDTCStatus()) return false;
    }
    if (hasDTCFailureType() || rhs.hasDTCFailureType()) {
        if (getDTCFailureType() < rhs.getDTCFailureType()) return true;
        if (getDTCFailureType() > rhs.getDTCFailureType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DTCActiveStatus::clone() {
    return new DTCActiveStatus(*this);
}

inline bool DTCActiveStatus::operator > (const DTCActiveStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DTCActiveStatus::clear() {
    clearIsDTCActive();
    clearDTC();
    clearDTCStatus();
    clearDTCFailureType();
}

inline void DTCActiveStatus::clearIsDTCActive() {
    if (hasIsDTCActive()) {
         clear_has_IsDTCActive();
        _IsDTCActive = false;
     }
}

inline bool DTCActiveStatus::hasIsDTCActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DTCActiveStatus::getIsDTCActive () const {
    return _IsDTCActive;
}

inline void DTCActiveStatus::setIsDTCActive (bool IsDTCActive_) {
    set_has_IsDTCActive();
    this->_IsDTCActive = IsDTCActive_;
}

inline void DTCActiveStatus::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool DTCActiveStatus::hasDTC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DTCActiveStatus::getDTC () const {
    return _DTC;
}

inline void DTCActiveStatus::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void DTCActiveStatus::clearDTCStatus() {
    if (hasDTCStatus()) {
         clear_has_DTCStatus();
        _DTCStatus = 0u;
     }
}

inline bool DTCActiveStatus::hasDTCStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DTCActiveStatus::getDTCStatus () const {
    return _DTCStatus;
}

inline void DTCActiveStatus::setDTCStatus (uint8 DTCStatus_) {
    set_has_DTCStatus();
    this->_DTCStatus = DTCStatus_;
}

inline void DTCActiveStatus::clearDTCFailureType() {
    if (hasDTCFailureType()) {
         clear_has_DTCFailureType();
        _DTCFailureType = 0u;
     }
}

inline bool DTCActiveStatus::hasDTCFailureType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 DTCActiveStatus::getDTCFailureType () const {
    return _DTCFailureType;
}

inline void DTCActiveStatus::setDTCFailureType (uint8 DTCFailureType_) {
    set_has_DTCFailureType();
    this->_DTCFailureType = DTCFailureType_;
}

inline void DTCActiveStatus::set_has_IsDTCActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void DTCActiveStatus::clear_has_IsDTCActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DTCActiveStatus::set_has_DTC () {
    _has_bits_[0] |= 1u << 1;
}

inline void DTCActiveStatus::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DTCActiveStatus::set_has_DTCStatus () {
    _has_bits_[0] |= 1u << 2;
}

inline void DTCActiveStatus::clear_has_DTCStatus () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DTCActiveStatus::set_has_DTCFailureType () {
    _has_bits_[0] |= 1u << 3;
}

inline void DTCActiveStatus::clear_has_DTCFailureType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  DTCActiveGet::DTCActiveGet ()  :
    _IsDTCActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DTCActiveGet::DTCActiveGet (const DTCActiveGet &rhs)  :
    ::asf::core::Payload(rhs),
    _IsDTCActive (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DTCActiveGet::DTCActiveGet (bool IsDTCActive_)  :
    _IsDTCActive (IsDTCActive_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DTCActiveGet::~DTCActiveGet() {
}

inline DTCActiveGet& DTCActiveGet::operator = (const DTCActiveGet& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasIsDTCActive()) {
            setIsDTCActive(rhs.getIsDTCActive());
        } else {
            clearIsDTCActive();
        }
    }
    return *this;
}

inline bool DTCActiveGet::operator == (const DTCActiveGet& rhs) const {
    return (((!hasIsDTCActive() && !rhs.hasIsDTCActive()) || getIsDTCActive() == rhs.getIsDTCActive()));
}

inline bool DTCActiveGet::operator != (const DTCActiveGet& rhs) const {
    return ! (*this == rhs);
}

inline bool DTCActiveGet::operator < (const DTCActiveGet& rhs) const {
    if (hasIsDTCActive() || rhs.hasIsDTCActive()) {
        if (getIsDTCActive() < rhs.getIsDTCActive()) return true;
        if (getIsDTCActive() > rhs.getIsDTCActive()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DTCActiveGet::clone() {
    return new DTCActiveGet(*this);
}

inline bool DTCActiveGet::operator > (const DTCActiveGet& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DTCActiveGet::clear() {
    clearIsDTCActive();
}

inline void DTCActiveGet::clearIsDTCActive() {
    if (hasIsDTCActive()) {
         clear_has_IsDTCActive();
        _IsDTCActive = false;
     }
}

inline bool DTCActiveGet::hasIsDTCActive () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DTCActiveGet::getIsDTCActive () const {
    return _IsDTCActive;
}

inline void DTCActiveGet::setIsDTCActive (bool IsDTCActive_) {
    set_has_IsDTCActive();
    this->_IsDTCActive = IsDTCActive_;
}

inline void DTCActiveGet::set_has_IsDTCActive () {
    _has_bits_[0] |= 1u << 0;
}

inline void DTCActiveGet::clear_has_IsDTCActive () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendNextTestResultStatus::SendNextTestResultStatus ()  :
    _NextTestResultStruct (),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendNextTestResultStatus::SendNextTestResultStatus (const SendNextTestResultStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _NextTestResultStruct (),
    _Status (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendNextTestResultStatus::SendNextTestResultStatus (const ::midw_diaglog_fi_types::T_SendNextTestResultStructure& NextTestResultStruct_, bool Status_)  :
    _NextTestResultStruct (NextTestResultStruct_),
    _Status (Status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendNextTestResultStatus::~SendNextTestResultStatus() {
}

inline SendNextTestResultStatus& SendNextTestResultStatus::operator = (const SendNextTestResultStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNextTestResultStruct()) {
            setNextTestResultStruct(rhs.getNextTestResultStruct());
        } else {
            clearNextTestResultStruct();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool SendNextTestResultStatus::operator == (const SendNextTestResultStatus& rhs) const {
    return (((!hasNextTestResultStruct() && !rhs.hasNextTestResultStruct()) || getNextTestResultStruct() == rhs.getNextTestResultStruct()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool SendNextTestResultStatus::operator != (const SendNextTestResultStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SendNextTestResultStatus::operator < (const SendNextTestResultStatus& rhs) const {
    if (hasNextTestResultStruct() || rhs.hasNextTestResultStruct()) {
        if (getNextTestResultStruct() < rhs.getNextTestResultStruct()) return true;
        if (getNextTestResultStruct() > rhs.getNextTestResultStruct()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendNextTestResultStatus::clone() {
    return new SendNextTestResultStatus(*this);
}

inline bool SendNextTestResultStatus::operator > (const SendNextTestResultStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendNextTestResultStatus::clear() {
    clearNextTestResultStruct();
    clearStatus();
}

inline void SendNextTestResultStatus::clearNextTestResultStruct() {
    if (hasNextTestResultStruct()) {
         clear_has_NextTestResultStruct();
        _NextTestResultStruct.clear();
     }
}

inline bool SendNextTestResultStatus::hasNextTestResultStruct () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_SendNextTestResultStructure& SendNextTestResultStatus::getNextTestResultStruct () const {
    return _NextTestResultStruct;
}

inline ::midw_diaglog_fi_types::T_SendNextTestResultStructure& SendNextTestResultStatus::getNextTestResultStructMutable () {
    set_has_NextTestResultStruct();
    return _NextTestResultStruct;
}

inline void SendNextTestResultStatus::setNextTestResultStruct (const ::midw_diaglog_fi_types::T_SendNextTestResultStructure& NextTestResultStruct_) {
    set_has_NextTestResultStruct();
    this->_NextTestResultStruct = NextTestResultStruct_;
}

inline void SendNextTestResultStatus::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = false;
     }
}

inline bool SendNextTestResultStatus::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool SendNextTestResultStatus::getStatus () const {
    return _Status;
}

inline void SendNextTestResultStatus::setStatus (bool Status_) {
    set_has_Status();
    this->_Status = Status_;
}

inline void SendNextTestResultStatus::set_has_NextTestResultStruct () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendNextTestResultStatus::clear_has_NextTestResultStruct () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SendNextTestResultStatus::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void SendNextTestResultStatus::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetDTCbyStatusMaskStart::GetDTCbyStatusMaskStart ()  :
    _Group (0u),
    _StatusMask (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDTCbyStatusMaskStart::GetDTCbyStatusMaskStart (const GetDTCbyStatusMaskStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _StatusMask (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDTCbyStatusMaskStart::GetDTCbyStatusMaskStart (uint8 Group_, uint8 StatusMask_, uint32 DTCMask_)  :
    _Group (Group_),
    _StatusMask (StatusMask_),
    _DTCMask (DTCMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDTCbyStatusMaskStart::~GetDTCbyStatusMaskStart() {
}

inline GetDTCbyStatusMaskStart& GetDTCbyStatusMaskStart::operator = (const GetDTCbyStatusMaskStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasStatusMask()) {
            setStatusMask(rhs.getStatusMask());
        } else {
            clearStatusMask();
        }
        if (rhs.hasDTCMask()) {
            setDTCMask(rhs.getDTCMask());
        } else {
            clearDTCMask();
        }
    }
    return *this;
}

inline bool GetDTCbyStatusMaskStart::operator == (const GetDTCbyStatusMaskStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasStatusMask() && !rhs.hasStatusMask()) || getStatusMask() == rhs.getStatusMask()) &&
        ((!hasDTCMask() && !rhs.hasDTCMask()) || getDTCMask() == rhs.getDTCMask()));
}

inline bool GetDTCbyStatusMaskStart::operator != (const GetDTCbyStatusMaskStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDTCbyStatusMaskStart::operator < (const GetDTCbyStatusMaskStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasStatusMask() || rhs.hasStatusMask()) {
        if (getStatusMask() < rhs.getStatusMask()) return true;
        if (getStatusMask() > rhs.getStatusMask()) return false;
    }
    if (hasDTCMask() || rhs.hasDTCMask()) {
        if (getDTCMask() < rhs.getDTCMask()) return true;
        if (getDTCMask() > rhs.getDTCMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDTCbyStatusMaskStart::clone() {
    return new GetDTCbyStatusMaskStart(*this);
}

inline bool GetDTCbyStatusMaskStart::operator > (const GetDTCbyStatusMaskStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDTCbyStatusMaskStart::clear() {
    clearGroup();
    clearStatusMask();
    clearDTCMask();
}

inline void GetDTCbyStatusMaskStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetDTCbyStatusMaskStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetDTCbyStatusMaskStart::getGroup () const {
    return _Group;
}

inline void GetDTCbyStatusMaskStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetDTCbyStatusMaskStart::clearStatusMask() {
    if (hasStatusMask()) {
         clear_has_StatusMask();
        _StatusMask = 0u;
     }
}

inline bool GetDTCbyStatusMaskStart::hasStatusMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetDTCbyStatusMaskStart::getStatusMask () const {
    return _StatusMask;
}

inline void GetDTCbyStatusMaskStart::setStatusMask (uint8 StatusMask_) {
    set_has_StatusMask();
    this->_StatusMask = StatusMask_;
}

inline void GetDTCbyStatusMaskStart::clearDTCMask() {
    if (hasDTCMask()) {
         clear_has_DTCMask();
        _DTCMask = 0u;
     }
}

inline bool GetDTCbyStatusMaskStart::hasDTCMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetDTCbyStatusMaskStart::getDTCMask () const {
    return _DTCMask;
}

inline void GetDTCbyStatusMaskStart::setDTCMask (uint32 DTCMask_) {
    set_has_DTCMask();
    this->_DTCMask = DTCMask_;
}

inline void GetDTCbyStatusMaskStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDTCbyStatusMaskStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetDTCbyStatusMaskStart::set_has_StatusMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetDTCbyStatusMaskStart::clear_has_StatusMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetDTCbyStatusMaskStart::set_has_DTCMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetDTCbyStatusMaskStart::clear_has_DTCMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetDTCbyStatusMaskResult::GetDTCbyStatusMaskResult ()  :
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetDTCbyStatusMaskResult::GetDTCbyStatusMaskResult (const GetDTCbyStatusMaskResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetDTCbyStatusMaskResult::GetDTCbyStatusMaskResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _StatusAvailabilityMask (StatusAvailabilityMask_),
    _ReadResultList (ReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetDTCbyStatusMaskResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetDTCbyStatusMaskResult::~GetDTCbyStatusMaskResult() {
}

inline GetDTCbyStatusMaskResult& GetDTCbyStatusMaskResult::operator = (const GetDTCbyStatusMaskResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusAvailabilityMask()) {
            setStatusAvailabilityMask(rhs.getStatusAvailabilityMask());
        } else {
            clearStatusAvailabilityMask();
        }
        if (rhs.hasReadResultList()) {
            setReadResultList(rhs.getReadResultList());
        } else {
            clearReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetDTCbyStatusMaskResult::operator == (const GetDTCbyStatusMaskResult& rhs) const {
    return (((!hasStatusAvailabilityMask() && !rhs.hasStatusAvailabilityMask()) || getStatusAvailabilityMask() == rhs.getStatusAvailabilityMask()) &&
        ((!hasReadResultList() && !rhs.hasReadResultList()) || getReadResultList() == rhs.getReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetDTCbyStatusMaskResult::operator != (const GetDTCbyStatusMaskResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetDTCbyStatusMaskResult::operator < (const GetDTCbyStatusMaskResult& rhs) const {
    if (hasStatusAvailabilityMask() || rhs.hasStatusAvailabilityMask()) {
        if (getStatusAvailabilityMask() < rhs.getStatusAvailabilityMask()) return true;
        if (getStatusAvailabilityMask() > rhs.getStatusAvailabilityMask()) return false;
    }
    if (hasReadResultList() || rhs.hasReadResultList()) {
        if (getReadResultList() < rhs.getReadResultList()) return true;
        if (getReadResultList() > rhs.getReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetDTCbyStatusMaskResult::clone() {
    return new GetDTCbyStatusMaskResult(*this);
}

inline bool GetDTCbyStatusMaskResult::operator > (const GetDTCbyStatusMaskResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetDTCbyStatusMaskResult::clear() {
    clearStatusAvailabilityMask();
    clearReadResultList();
    clearStatus();
}

inline void GetDTCbyStatusMaskResult::clearStatusAvailabilityMask() {
    if (hasStatusAvailabilityMask()) {
         clear_has_StatusAvailabilityMask();
        _StatusAvailabilityMask = 0u;
     }
}

inline bool GetDTCbyStatusMaskResult::hasStatusAvailabilityMask () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetDTCbyStatusMaskResult::getStatusAvailabilityMask () const {
    return _StatusAvailabilityMask;
}

inline void GetDTCbyStatusMaskResult::setStatusAvailabilityMask (uint8 StatusAvailabilityMask_) {
    set_has_StatusAvailabilityMask();
    this->_StatusAvailabilityMask = StatusAvailabilityMask_;
}

inline void GetDTCbyStatusMaskResult::clearReadResultList() {
    if (hasReadResultList()) {
         clear_has_ReadResultList();
        _ReadResultList.clear();
     }
}

inline bool GetDTCbyStatusMaskResult::hasReadResultList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ReadResultList& GetDTCbyStatusMaskResult::getReadResultList () const {
    return _ReadResultList;
}

inline ::midw_diaglog_fi_types::T_ReadResultList& GetDTCbyStatusMaskResult::getReadResultListMutable () {
    set_has_ReadResultList();
    return _ReadResultList;
}

inline void GetDTCbyStatusMaskResult::setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_) {
    set_has_ReadResultList();
    this->_ReadResultList = ReadResultList_;
}

inline void GetDTCbyStatusMaskResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetDTCbyStatusMaskResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetDTCbyStatusMaskResult::getStatus () const {
    return _Status;
}

inline void GetDTCbyStatusMaskResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetDTCbyStatusMaskResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetDTCbyStatusMaskResult::set_has_StatusAvailabilityMask () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetDTCbyStatusMaskResult::clear_has_StatusAvailabilityMask () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetDTCbyStatusMaskResult::set_has_ReadResultList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetDTCbyStatusMaskResult::clear_has_ReadResultList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetDTCbyStatusMaskResult::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetDTCbyStatusMaskResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetLastConfirmedDTCStart::GetLastConfirmedDTCStart ()  :
    _Group (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetLastConfirmedDTCStart::GetLastConfirmedDTCStart (const GetLastConfirmedDTCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetLastConfirmedDTCStart::GetLastConfirmedDTCStart (uint8 Group_)  :
    _Group (Group_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetLastConfirmedDTCStart::~GetLastConfirmedDTCStart() {
}

inline GetLastConfirmedDTCStart& GetLastConfirmedDTCStart::operator = (const GetLastConfirmedDTCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
    }
    return *this;
}

inline bool GetLastConfirmedDTCStart::operator == (const GetLastConfirmedDTCStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()));
}

inline bool GetLastConfirmedDTCStart::operator != (const GetLastConfirmedDTCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetLastConfirmedDTCStart::operator < (const GetLastConfirmedDTCStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetLastConfirmedDTCStart::clone() {
    return new GetLastConfirmedDTCStart(*this);
}

inline bool GetLastConfirmedDTCStart::operator > (const GetLastConfirmedDTCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetLastConfirmedDTCStart::clear() {
    clearGroup();
}

inline void GetLastConfirmedDTCStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetLastConfirmedDTCStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetLastConfirmedDTCStart::getGroup () const {
    return _Group;
}

inline void GetLastConfirmedDTCStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetLastConfirmedDTCStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetLastConfirmedDTCStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetLastConfirmedDTCResult::GetLastConfirmedDTCResult ()  :
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetLastConfirmedDTCResult::GetLastConfirmedDTCResult (const GetLastConfirmedDTCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetLastConfirmedDTCResult::GetLastConfirmedDTCResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _StatusAvailabilityMask (StatusAvailabilityMask_),
    _ReadResultList (ReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetLastConfirmedDTCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetLastConfirmedDTCResult::~GetLastConfirmedDTCResult() {
}

inline GetLastConfirmedDTCResult& GetLastConfirmedDTCResult::operator = (const GetLastConfirmedDTCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusAvailabilityMask()) {
            setStatusAvailabilityMask(rhs.getStatusAvailabilityMask());
        } else {
            clearStatusAvailabilityMask();
        }
        if (rhs.hasReadResultList()) {
            setReadResultList(rhs.getReadResultList());
        } else {
            clearReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetLastConfirmedDTCResult::operator == (const GetLastConfirmedDTCResult& rhs) const {
    return (((!hasStatusAvailabilityMask() && !rhs.hasStatusAvailabilityMask()) || getStatusAvailabilityMask() == rhs.getStatusAvailabilityMask()) &&
        ((!hasReadResultList() && !rhs.hasReadResultList()) || getReadResultList() == rhs.getReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetLastConfirmedDTCResult::operator != (const GetLastConfirmedDTCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetLastConfirmedDTCResult::operator < (const GetLastConfirmedDTCResult& rhs) const {
    if (hasStatusAvailabilityMask() || rhs.hasStatusAvailabilityMask()) {
        if (getStatusAvailabilityMask() < rhs.getStatusAvailabilityMask()) return true;
        if (getStatusAvailabilityMask() > rhs.getStatusAvailabilityMask()) return false;
    }
    if (hasReadResultList() || rhs.hasReadResultList()) {
        if (getReadResultList() < rhs.getReadResultList()) return true;
        if (getReadResultList() > rhs.getReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetLastConfirmedDTCResult::clone() {
    return new GetLastConfirmedDTCResult(*this);
}

inline bool GetLastConfirmedDTCResult::operator > (const GetLastConfirmedDTCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetLastConfirmedDTCResult::clear() {
    clearStatusAvailabilityMask();
    clearReadResultList();
    clearStatus();
}

inline void GetLastConfirmedDTCResult::clearStatusAvailabilityMask() {
    if (hasStatusAvailabilityMask()) {
         clear_has_StatusAvailabilityMask();
        _StatusAvailabilityMask = 0u;
     }
}

inline bool GetLastConfirmedDTCResult::hasStatusAvailabilityMask () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetLastConfirmedDTCResult::getStatusAvailabilityMask () const {
    return _StatusAvailabilityMask;
}

inline void GetLastConfirmedDTCResult::setStatusAvailabilityMask (uint8 StatusAvailabilityMask_) {
    set_has_StatusAvailabilityMask();
    this->_StatusAvailabilityMask = StatusAvailabilityMask_;
}

inline void GetLastConfirmedDTCResult::clearReadResultList() {
    if (hasReadResultList()) {
         clear_has_ReadResultList();
        _ReadResultList.clear();
     }
}

inline bool GetLastConfirmedDTCResult::hasReadResultList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ReadResultList& GetLastConfirmedDTCResult::getReadResultList () const {
    return _ReadResultList;
}

inline ::midw_diaglog_fi_types::T_ReadResultList& GetLastConfirmedDTCResult::getReadResultListMutable () {
    set_has_ReadResultList();
    return _ReadResultList;
}

inline void GetLastConfirmedDTCResult::setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_) {
    set_has_ReadResultList();
    this->_ReadResultList = ReadResultList_;
}

inline void GetLastConfirmedDTCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetLastConfirmedDTCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetLastConfirmedDTCResult::getStatus () const {
    return _Status;
}

inline void GetLastConfirmedDTCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetLastConfirmedDTCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetLastConfirmedDTCResult::set_has_StatusAvailabilityMask () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetLastConfirmedDTCResult::clear_has_StatusAvailabilityMask () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetLastConfirmedDTCResult::set_has_ReadResultList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetLastConfirmedDTCResult::clear_has_ReadResultList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetLastConfirmedDTCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetLastConfirmedDTCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetSupportedDTCStart::GetSupportedDTCStart ()  :
    _Group (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSupportedDTCStart::GetSupportedDTCStart (const GetSupportedDTCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSupportedDTCStart::GetSupportedDTCStart (uint8 Group_)  :
    _Group (Group_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSupportedDTCStart::~GetSupportedDTCStart() {
}

inline GetSupportedDTCStart& GetSupportedDTCStart::operator = (const GetSupportedDTCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
    }
    return *this;
}

inline bool GetSupportedDTCStart::operator == (const GetSupportedDTCStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()));
}

inline bool GetSupportedDTCStart::operator != (const GetSupportedDTCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSupportedDTCStart::operator < (const GetSupportedDTCStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSupportedDTCStart::clone() {
    return new GetSupportedDTCStart(*this);
}

inline bool GetSupportedDTCStart::operator > (const GetSupportedDTCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSupportedDTCStart::clear() {
    clearGroup();
}

inline void GetSupportedDTCStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetSupportedDTCStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetSupportedDTCStart::getGroup () const {
    return _Group;
}

inline void GetSupportedDTCStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetSupportedDTCStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSupportedDTCStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetSupportedDTCResult::GetSupportedDTCResult ()  :
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetSupportedDTCResult::GetSupportedDTCResult (const GetSupportedDTCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetSupportedDTCResult::GetSupportedDTCResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _StatusAvailabilityMask (StatusAvailabilityMask_),
    _ReadResultList (ReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetSupportedDTCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetSupportedDTCResult::~GetSupportedDTCResult() {
}

inline GetSupportedDTCResult& GetSupportedDTCResult::operator = (const GetSupportedDTCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusAvailabilityMask()) {
            setStatusAvailabilityMask(rhs.getStatusAvailabilityMask());
        } else {
            clearStatusAvailabilityMask();
        }
        if (rhs.hasReadResultList()) {
            setReadResultList(rhs.getReadResultList());
        } else {
            clearReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetSupportedDTCResult::operator == (const GetSupportedDTCResult& rhs) const {
    return (((!hasStatusAvailabilityMask() && !rhs.hasStatusAvailabilityMask()) || getStatusAvailabilityMask() == rhs.getStatusAvailabilityMask()) &&
        ((!hasReadResultList() && !rhs.hasReadResultList()) || getReadResultList() == rhs.getReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetSupportedDTCResult::operator != (const GetSupportedDTCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetSupportedDTCResult::operator < (const GetSupportedDTCResult& rhs) const {
    if (hasStatusAvailabilityMask() || rhs.hasStatusAvailabilityMask()) {
        if (getStatusAvailabilityMask() < rhs.getStatusAvailabilityMask()) return true;
        if (getStatusAvailabilityMask() > rhs.getStatusAvailabilityMask()) return false;
    }
    if (hasReadResultList() || rhs.hasReadResultList()) {
        if (getReadResultList() < rhs.getReadResultList()) return true;
        if (getReadResultList() > rhs.getReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetSupportedDTCResult::clone() {
    return new GetSupportedDTCResult(*this);
}

inline bool GetSupportedDTCResult::operator > (const GetSupportedDTCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetSupportedDTCResult::clear() {
    clearStatusAvailabilityMask();
    clearReadResultList();
    clearStatus();
}

inline void GetSupportedDTCResult::clearStatusAvailabilityMask() {
    if (hasStatusAvailabilityMask()) {
         clear_has_StatusAvailabilityMask();
        _StatusAvailabilityMask = 0u;
     }
}

inline bool GetSupportedDTCResult::hasStatusAvailabilityMask () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetSupportedDTCResult::getStatusAvailabilityMask () const {
    return _StatusAvailabilityMask;
}

inline void GetSupportedDTCResult::setStatusAvailabilityMask (uint8 StatusAvailabilityMask_) {
    set_has_StatusAvailabilityMask();
    this->_StatusAvailabilityMask = StatusAvailabilityMask_;
}

inline void GetSupportedDTCResult::clearReadResultList() {
    if (hasReadResultList()) {
         clear_has_ReadResultList();
        _ReadResultList.clear();
     }
}

inline bool GetSupportedDTCResult::hasReadResultList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ReadResultList& GetSupportedDTCResult::getReadResultList () const {
    return _ReadResultList;
}

inline ::midw_diaglog_fi_types::T_ReadResultList& GetSupportedDTCResult::getReadResultListMutable () {
    set_has_ReadResultList();
    return _ReadResultList;
}

inline void GetSupportedDTCResult::setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_) {
    set_has_ReadResultList();
    this->_ReadResultList = ReadResultList_;
}

inline void GetSupportedDTCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetSupportedDTCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetSupportedDTCResult::getStatus () const {
    return _Status;
}

inline void GetSupportedDTCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetSupportedDTCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetSupportedDTCResult::set_has_StatusAvailabilityMask () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetSupportedDTCResult::clear_has_StatusAvailabilityMask () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetSupportedDTCResult::set_has_ReadResultList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetSupportedDTCResult::clear_has_ReadResultList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetSupportedDTCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetSupportedDTCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetNumberOfDTCByStatusMaskStart::GetNumberOfDTCByStatusMaskStart ()  :
    _Group (0u),
    _StatusMask (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNumberOfDTCByStatusMaskStart::GetNumberOfDTCByStatusMaskStart (const GetNumberOfDTCByStatusMaskStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _StatusMask (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNumberOfDTCByStatusMaskStart::GetNumberOfDTCByStatusMaskStart (uint8 Group_, uint8 StatusMask_, uint32 DTCMask_)  :
    _Group (Group_),
    _StatusMask (StatusMask_),
    _DTCMask (DTCMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNumberOfDTCByStatusMaskStart::~GetNumberOfDTCByStatusMaskStart() {
}

inline GetNumberOfDTCByStatusMaskStart& GetNumberOfDTCByStatusMaskStart::operator = (const GetNumberOfDTCByStatusMaskStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasStatusMask()) {
            setStatusMask(rhs.getStatusMask());
        } else {
            clearStatusMask();
        }
        if (rhs.hasDTCMask()) {
            setDTCMask(rhs.getDTCMask());
        } else {
            clearDTCMask();
        }
    }
    return *this;
}

inline bool GetNumberOfDTCByStatusMaskStart::operator == (const GetNumberOfDTCByStatusMaskStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasStatusMask() && !rhs.hasStatusMask()) || getStatusMask() == rhs.getStatusMask()) &&
        ((!hasDTCMask() && !rhs.hasDTCMask()) || getDTCMask() == rhs.getDTCMask()));
}

inline bool GetNumberOfDTCByStatusMaskStart::operator != (const GetNumberOfDTCByStatusMaskStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNumberOfDTCByStatusMaskStart::operator < (const GetNumberOfDTCByStatusMaskStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasStatusMask() || rhs.hasStatusMask()) {
        if (getStatusMask() < rhs.getStatusMask()) return true;
        if (getStatusMask() > rhs.getStatusMask()) return false;
    }
    if (hasDTCMask() || rhs.hasDTCMask()) {
        if (getDTCMask() < rhs.getDTCMask()) return true;
        if (getDTCMask() > rhs.getDTCMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNumberOfDTCByStatusMaskStart::clone() {
    return new GetNumberOfDTCByStatusMaskStart(*this);
}

inline bool GetNumberOfDTCByStatusMaskStart::operator > (const GetNumberOfDTCByStatusMaskStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNumberOfDTCByStatusMaskStart::clear() {
    clearGroup();
    clearStatusMask();
    clearDTCMask();
}

inline void GetNumberOfDTCByStatusMaskStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetNumberOfDTCByStatusMaskStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetNumberOfDTCByStatusMaskStart::getGroup () const {
    return _Group;
}

inline void GetNumberOfDTCByStatusMaskStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetNumberOfDTCByStatusMaskStart::clearStatusMask() {
    if (hasStatusMask()) {
         clear_has_StatusMask();
        _StatusMask = 0u;
     }
}

inline bool GetNumberOfDTCByStatusMaskStart::hasStatusMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetNumberOfDTCByStatusMaskStart::getStatusMask () const {
    return _StatusMask;
}

inline void GetNumberOfDTCByStatusMaskStart::setStatusMask (uint8 StatusMask_) {
    set_has_StatusMask();
    this->_StatusMask = StatusMask_;
}

inline void GetNumberOfDTCByStatusMaskStart::clearDTCMask() {
    if (hasDTCMask()) {
         clear_has_DTCMask();
        _DTCMask = 0u;
     }
}

inline bool GetNumberOfDTCByStatusMaskStart::hasDTCMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint32 GetNumberOfDTCByStatusMaskStart::getDTCMask () const {
    return _DTCMask;
}

inline void GetNumberOfDTCByStatusMaskStart::setDTCMask (uint32 DTCMask_) {
    set_has_DTCMask();
    this->_DTCMask = DTCMask_;
}

inline void GetNumberOfDTCByStatusMaskStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNumberOfDTCByStatusMaskStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetNumberOfDTCByStatusMaskStart::set_has_StatusMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetNumberOfDTCByStatusMaskStart::clear_has_StatusMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetNumberOfDTCByStatusMaskStart::set_has_DTCMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetNumberOfDTCByStatusMaskStart::clear_has_DTCMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetNumberOfDTCByStatusMaskResult::GetNumberOfDTCByStatusMaskResult ()  :
    _StatusAvailabilityMask (0u),
    _NumberOfDTC (0u),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNumberOfDTCByStatusMaskResult::GetNumberOfDTCByStatusMaskResult (const GetNumberOfDTCByStatusMaskResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusAvailabilityMask (0u),
    _NumberOfDTC (0u),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNumberOfDTCByStatusMaskResult::GetNumberOfDTCByStatusMaskResult (uint8 StatusAvailabilityMask_, uint32 NumberOfDTC_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _StatusAvailabilityMask (StatusAvailabilityMask_),
    _NumberOfDTC (NumberOfDTC_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetNumberOfDTCByStatusMaskResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNumberOfDTCByStatusMaskResult::~GetNumberOfDTCByStatusMaskResult() {
}

inline GetNumberOfDTCByStatusMaskResult& GetNumberOfDTCByStatusMaskResult::operator = (const GetNumberOfDTCByStatusMaskResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusAvailabilityMask()) {
            setStatusAvailabilityMask(rhs.getStatusAvailabilityMask());
        } else {
            clearStatusAvailabilityMask();
        }
        if (rhs.hasNumberOfDTC()) {
            setNumberOfDTC(rhs.getNumberOfDTC());
        } else {
            clearNumberOfDTC();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetNumberOfDTCByStatusMaskResult::operator == (const GetNumberOfDTCByStatusMaskResult& rhs) const {
    return (((!hasStatusAvailabilityMask() && !rhs.hasStatusAvailabilityMask()) || getStatusAvailabilityMask() == rhs.getStatusAvailabilityMask()) &&
        ((!hasNumberOfDTC() && !rhs.hasNumberOfDTC()) || getNumberOfDTC() == rhs.getNumberOfDTC()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetNumberOfDTCByStatusMaskResult::operator != (const GetNumberOfDTCByStatusMaskResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNumberOfDTCByStatusMaskResult::operator < (const GetNumberOfDTCByStatusMaskResult& rhs) const {
    if (hasStatusAvailabilityMask() || rhs.hasStatusAvailabilityMask()) {
        if (getStatusAvailabilityMask() < rhs.getStatusAvailabilityMask()) return true;
        if (getStatusAvailabilityMask() > rhs.getStatusAvailabilityMask()) return false;
    }
    if (hasNumberOfDTC() || rhs.hasNumberOfDTC()) {
        if (getNumberOfDTC() < rhs.getNumberOfDTC()) return true;
        if (getNumberOfDTC() > rhs.getNumberOfDTC()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNumberOfDTCByStatusMaskResult::clone() {
    return new GetNumberOfDTCByStatusMaskResult(*this);
}

inline bool GetNumberOfDTCByStatusMaskResult::operator > (const GetNumberOfDTCByStatusMaskResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNumberOfDTCByStatusMaskResult::clear() {
    clearStatusAvailabilityMask();
    clearNumberOfDTC();
    clearStatus();
}

inline void GetNumberOfDTCByStatusMaskResult::clearStatusAvailabilityMask() {
    if (hasStatusAvailabilityMask()) {
         clear_has_StatusAvailabilityMask();
        _StatusAvailabilityMask = 0u;
     }
}

inline bool GetNumberOfDTCByStatusMaskResult::hasStatusAvailabilityMask () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetNumberOfDTCByStatusMaskResult::getStatusAvailabilityMask () const {
    return _StatusAvailabilityMask;
}

inline void GetNumberOfDTCByStatusMaskResult::setStatusAvailabilityMask (uint8 StatusAvailabilityMask_) {
    set_has_StatusAvailabilityMask();
    this->_StatusAvailabilityMask = StatusAvailabilityMask_;
}

inline void GetNumberOfDTCByStatusMaskResult::clearNumberOfDTC() {
    if (hasNumberOfDTC()) {
         clear_has_NumberOfDTC();
        _NumberOfDTC = 0u;
     }
}

inline bool GetNumberOfDTCByStatusMaskResult::hasNumberOfDTC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetNumberOfDTCByStatusMaskResult::getNumberOfDTC () const {
    return _NumberOfDTC;
}

inline void GetNumberOfDTCByStatusMaskResult::setNumberOfDTC (uint32 NumberOfDTC_) {
    set_has_NumberOfDTC();
    this->_NumberOfDTC = NumberOfDTC_;
}

inline void GetNumberOfDTCByStatusMaskResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetNumberOfDTCByStatusMaskResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetNumberOfDTCByStatusMaskResult::getStatus () const {
    return _Status;
}

inline void GetNumberOfDTCByStatusMaskResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetNumberOfDTCByStatusMaskResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetNumberOfDTCByStatusMaskResult::set_has_StatusAvailabilityMask () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNumberOfDTCByStatusMaskResult::clear_has_StatusAvailabilityMask () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetNumberOfDTCByStatusMaskResult::set_has_NumberOfDTC () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetNumberOfDTCByStatusMaskResult::clear_has_NumberOfDTC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetNumberOfDTCByStatusMaskResult::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetNumberOfDTCByStatusMaskResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetStatusByDTCStart::GetStatusByDTCStart ()  :
    _Group (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStatusByDTCStart::GetStatusByDTCStart (const GetStatusByDTCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStatusByDTCStart::GetStatusByDTCStart (uint8 Group_, uint32 DTCMask_)  :
    _Group (Group_),
    _DTCMask (DTCMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStatusByDTCStart::~GetStatusByDTCStart() {
}

inline GetStatusByDTCStart& GetStatusByDTCStart::operator = (const GetStatusByDTCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasDTCMask()) {
            setDTCMask(rhs.getDTCMask());
        } else {
            clearDTCMask();
        }
    }
    return *this;
}

inline bool GetStatusByDTCStart::operator == (const GetStatusByDTCStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasDTCMask() && !rhs.hasDTCMask()) || getDTCMask() == rhs.getDTCMask()));
}

inline bool GetStatusByDTCStart::operator != (const GetStatusByDTCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStatusByDTCStart::operator < (const GetStatusByDTCStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasDTCMask() || rhs.hasDTCMask()) {
        if (getDTCMask() < rhs.getDTCMask()) return true;
        if (getDTCMask() > rhs.getDTCMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStatusByDTCStart::clone() {
    return new GetStatusByDTCStart(*this);
}

inline bool GetStatusByDTCStart::operator > (const GetStatusByDTCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStatusByDTCStart::clear() {
    clearGroup();
    clearDTCMask();
}

inline void GetStatusByDTCStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetStatusByDTCStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetStatusByDTCStart::getGroup () const {
    return _Group;
}

inline void GetStatusByDTCStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetStatusByDTCStart::clearDTCMask() {
    if (hasDTCMask()) {
         clear_has_DTCMask();
        _DTCMask = 0u;
     }
}

inline bool GetStatusByDTCStart::hasDTCMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetStatusByDTCStart::getDTCMask () const {
    return _DTCMask;
}

inline void GetStatusByDTCStart::setDTCMask (uint32 DTCMask_) {
    set_has_DTCMask();
    this->_DTCMask = DTCMask_;
}

inline void GetStatusByDTCStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStatusByDTCStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStatusByDTCStart::set_has_DTCMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStatusByDTCStart::clear_has_DTCMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetStatusByDTCResult::GetStatusByDTCResult ()  :
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStatusByDTCResult::GetStatusByDTCResult (const GetStatusByDTCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _StatusAvailabilityMask (0u),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStatusByDTCResult::GetStatusByDTCResult (uint8 StatusAvailabilityMask_, const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _StatusAvailabilityMask (StatusAvailabilityMask_),
    _ReadResultList (ReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetStatusByDTCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStatusByDTCResult::~GetStatusByDTCResult() {
}

inline GetStatusByDTCResult& GetStatusByDTCResult::operator = (const GetStatusByDTCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatusAvailabilityMask()) {
            setStatusAvailabilityMask(rhs.getStatusAvailabilityMask());
        } else {
            clearStatusAvailabilityMask();
        }
        if (rhs.hasReadResultList()) {
            setReadResultList(rhs.getReadResultList());
        } else {
            clearReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetStatusByDTCResult::operator == (const GetStatusByDTCResult& rhs) const {
    return (((!hasStatusAvailabilityMask() && !rhs.hasStatusAvailabilityMask()) || getStatusAvailabilityMask() == rhs.getStatusAvailabilityMask()) &&
        ((!hasReadResultList() && !rhs.hasReadResultList()) || getReadResultList() == rhs.getReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetStatusByDTCResult::operator != (const GetStatusByDTCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStatusByDTCResult::operator < (const GetStatusByDTCResult& rhs) const {
    if (hasStatusAvailabilityMask() || rhs.hasStatusAvailabilityMask()) {
        if (getStatusAvailabilityMask() < rhs.getStatusAvailabilityMask()) return true;
        if (getStatusAvailabilityMask() > rhs.getStatusAvailabilityMask()) return false;
    }
    if (hasReadResultList() || rhs.hasReadResultList()) {
        if (getReadResultList() < rhs.getReadResultList()) return true;
        if (getReadResultList() > rhs.getReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStatusByDTCResult::clone() {
    return new GetStatusByDTCResult(*this);
}

inline bool GetStatusByDTCResult::operator > (const GetStatusByDTCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStatusByDTCResult::clear() {
    clearStatusAvailabilityMask();
    clearReadResultList();
    clearStatus();
}

inline void GetStatusByDTCResult::clearStatusAvailabilityMask() {
    if (hasStatusAvailabilityMask()) {
         clear_has_StatusAvailabilityMask();
        _StatusAvailabilityMask = 0u;
     }
}

inline bool GetStatusByDTCResult::hasStatusAvailabilityMask () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetStatusByDTCResult::getStatusAvailabilityMask () const {
    return _StatusAvailabilityMask;
}

inline void GetStatusByDTCResult::setStatusAvailabilityMask (uint8 StatusAvailabilityMask_) {
    set_has_StatusAvailabilityMask();
    this->_StatusAvailabilityMask = StatusAvailabilityMask_;
}

inline void GetStatusByDTCResult::clearReadResultList() {
    if (hasReadResultList()) {
         clear_has_ReadResultList();
        _ReadResultList.clear();
     }
}

inline bool GetStatusByDTCResult::hasReadResultList () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ReadResultList& GetStatusByDTCResult::getReadResultList () const {
    return _ReadResultList;
}

inline ::midw_diaglog_fi_types::T_ReadResultList& GetStatusByDTCResult::getReadResultListMutable () {
    set_has_ReadResultList();
    return _ReadResultList;
}

inline void GetStatusByDTCResult::setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_) {
    set_has_ReadResultList();
    this->_ReadResultList = ReadResultList_;
}

inline void GetStatusByDTCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetStatusByDTCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetStatusByDTCResult::getStatus () const {
    return _Status;
}

inline void GetStatusByDTCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetStatusByDTCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetStatusByDTCResult::set_has_StatusAvailabilityMask () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStatusByDTCResult::clear_has_StatusAvailabilityMask () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStatusByDTCResult::set_has_ReadResultList () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStatusByDTCResult::clear_has_ReadResultList () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetStatusByDTCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetStatusByDTCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetExtendedDataByDTCStart::GetExtendedDataByDTCStart ()  :
    _Group (0u),
    _DTC (0u),
    _DTCExtDataRecordNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetExtendedDataByDTCStart::GetExtendedDataByDTCStart (const GetExtendedDataByDTCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _DTC (0u),
    _DTCExtDataRecordNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetExtendedDataByDTCStart::GetExtendedDataByDTCStart (uint8 Group_, uint32 DTC_, uint8 DTCExtDataRecordNumber_)  :
    _Group (Group_),
    _DTC (DTC_),
    _DTCExtDataRecordNumber (DTCExtDataRecordNumber_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetExtendedDataByDTCStart::~GetExtendedDataByDTCStart() {
}

inline GetExtendedDataByDTCStart& GetExtendedDataByDTCStart::operator = (const GetExtendedDataByDTCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasDTCExtDataRecordNumber()) {
            setDTCExtDataRecordNumber(rhs.getDTCExtDataRecordNumber());
        } else {
            clearDTCExtDataRecordNumber();
        }
    }
    return *this;
}

inline bool GetExtendedDataByDTCStart::operator == (const GetExtendedDataByDTCStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasDTCExtDataRecordNumber() && !rhs.hasDTCExtDataRecordNumber()) || getDTCExtDataRecordNumber() == rhs.getDTCExtDataRecordNumber()));
}

inline bool GetExtendedDataByDTCStart::operator != (const GetExtendedDataByDTCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetExtendedDataByDTCStart::operator < (const GetExtendedDataByDTCStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasDTCExtDataRecordNumber() || rhs.hasDTCExtDataRecordNumber()) {
        if (getDTCExtDataRecordNumber() < rhs.getDTCExtDataRecordNumber()) return true;
        if (getDTCExtDataRecordNumber() > rhs.getDTCExtDataRecordNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetExtendedDataByDTCStart::clone() {
    return new GetExtendedDataByDTCStart(*this);
}

inline bool GetExtendedDataByDTCStart::operator > (const GetExtendedDataByDTCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetExtendedDataByDTCStart::clear() {
    clearGroup();
    clearDTC();
    clearDTCExtDataRecordNumber();
}

inline void GetExtendedDataByDTCStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetExtendedDataByDTCStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetExtendedDataByDTCStart::getGroup () const {
    return _Group;
}

inline void GetExtendedDataByDTCStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetExtendedDataByDTCStart::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool GetExtendedDataByDTCStart::hasDTC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetExtendedDataByDTCStart::getDTC () const {
    return _DTC;
}

inline void GetExtendedDataByDTCStart::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void GetExtendedDataByDTCStart::clearDTCExtDataRecordNumber() {
    if (hasDTCExtDataRecordNumber()) {
         clear_has_DTCExtDataRecordNumber();
        _DTCExtDataRecordNumber = 0u;
     }
}

inline bool GetExtendedDataByDTCStart::hasDTCExtDataRecordNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 GetExtendedDataByDTCStart::getDTCExtDataRecordNumber () const {
    return _DTCExtDataRecordNumber;
}

inline void GetExtendedDataByDTCStart::setDTCExtDataRecordNumber (uint8 DTCExtDataRecordNumber_) {
    set_has_DTCExtDataRecordNumber();
    this->_DTCExtDataRecordNumber = DTCExtDataRecordNumber_;
}

inline void GetExtendedDataByDTCStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetExtendedDataByDTCStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetExtendedDataByDTCStart::set_has_DTC () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetExtendedDataByDTCStart::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetExtendedDataByDTCStart::set_has_DTCExtDataRecordNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetExtendedDataByDTCStart::clear_has_DTCExtDataRecordNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  GetExtendedDataByDTCResult::GetExtendedDataByDTCResult ()  :
    _DTC (0u),
    _StatusOfDtc (0u),
    _FreezeFrameList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetExtendedDataByDTCResult::GetExtendedDataByDTCResult (const GetExtendedDataByDTCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DTC (0u),
    _StatusOfDtc (0u),
    _FreezeFrameList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetExtendedDataByDTCResult::GetExtendedDataByDTCResult (uint32 DTC_, uint8 StatusOfDtc_, const ::midw_diaglog_fi_types::T_FreezeFrameList& FreezeFrameList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _DTC (DTC_),
    _StatusOfDtc (StatusOfDtc_),
    _FreezeFrameList (FreezeFrameList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetExtendedDataByDTCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetExtendedDataByDTCResult::~GetExtendedDataByDTCResult() {
}

inline GetExtendedDataByDTCResult& GetExtendedDataByDTCResult::operator = (const GetExtendedDataByDTCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasStatusOfDtc()) {
            setStatusOfDtc(rhs.getStatusOfDtc());
        } else {
            clearStatusOfDtc();
        }
        if (rhs.hasFreezeFrameList()) {
            setFreezeFrameList(rhs.getFreezeFrameList());
        } else {
            clearFreezeFrameList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetExtendedDataByDTCResult::operator == (const GetExtendedDataByDTCResult& rhs) const {
    return (((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasStatusOfDtc() && !rhs.hasStatusOfDtc()) || getStatusOfDtc() == rhs.getStatusOfDtc()) &&
        ((!hasFreezeFrameList() && !rhs.hasFreezeFrameList()) || getFreezeFrameList() == rhs.getFreezeFrameList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetExtendedDataByDTCResult::operator != (const GetExtendedDataByDTCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetExtendedDataByDTCResult::operator < (const GetExtendedDataByDTCResult& rhs) const {
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasStatusOfDtc() || rhs.hasStatusOfDtc()) {
        if (getStatusOfDtc() < rhs.getStatusOfDtc()) return true;
        if (getStatusOfDtc() > rhs.getStatusOfDtc()) return false;
    }
    if (hasFreezeFrameList() || rhs.hasFreezeFrameList()) {
        if (getFreezeFrameList() < rhs.getFreezeFrameList()) return true;
        if (getFreezeFrameList() > rhs.getFreezeFrameList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetExtendedDataByDTCResult::clone() {
    return new GetExtendedDataByDTCResult(*this);
}

inline bool GetExtendedDataByDTCResult::operator > (const GetExtendedDataByDTCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetExtendedDataByDTCResult::clear() {
    clearDTC();
    clearStatusOfDtc();
    clearFreezeFrameList();
    clearStatus();
}

inline void GetExtendedDataByDTCResult::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool GetExtendedDataByDTCResult::hasDTC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 GetExtendedDataByDTCResult::getDTC () const {
    return _DTC;
}

inline void GetExtendedDataByDTCResult::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void GetExtendedDataByDTCResult::clearStatusOfDtc() {
    if (hasStatusOfDtc()) {
         clear_has_StatusOfDtc();
        _StatusOfDtc = 0u;
     }
}

inline bool GetExtendedDataByDTCResult::hasStatusOfDtc () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 GetExtendedDataByDTCResult::getStatusOfDtc () const {
    return _StatusOfDtc;
}

inline void GetExtendedDataByDTCResult::setStatusOfDtc (uint8 StatusOfDtc_) {
    set_has_StatusOfDtc();
    this->_StatusOfDtc = StatusOfDtc_;
}

inline void GetExtendedDataByDTCResult::clearFreezeFrameList() {
    if (hasFreezeFrameList()) {
         clear_has_FreezeFrameList();
        _FreezeFrameList.clear();
     }
}

inline bool GetExtendedDataByDTCResult::hasFreezeFrameList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diaglog_fi_types::T_FreezeFrameList& GetExtendedDataByDTCResult::getFreezeFrameList () const {
    return _FreezeFrameList;
}

inline ::midw_diaglog_fi_types::T_FreezeFrameList& GetExtendedDataByDTCResult::getFreezeFrameListMutable () {
    set_has_FreezeFrameList();
    return _FreezeFrameList;
}

inline void GetExtendedDataByDTCResult::setFreezeFrameList (const ::midw_diaglog_fi_types::T_FreezeFrameList& FreezeFrameList_) {
    set_has_FreezeFrameList();
    this->_FreezeFrameList = FreezeFrameList_;
}

inline void GetExtendedDataByDTCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetExtendedDataByDTCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetExtendedDataByDTCResult::getStatus () const {
    return _Status;
}

inline void GetExtendedDataByDTCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetExtendedDataByDTCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetExtendedDataByDTCResult::set_has_DTC () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetExtendedDataByDTCResult::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetExtendedDataByDTCResult::set_has_StatusOfDtc () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetExtendedDataByDTCResult::clear_has_StatusOfDtc () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void GetExtendedDataByDTCResult::set_has_FreezeFrameList () {
    _has_bits_[0] |= 1u << 2;
}

inline void GetExtendedDataByDTCResult::clear_has_FreezeFrameList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void GetExtendedDataByDTCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 3;
}

inline void GetExtendedDataByDTCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  GetStatusByITCStart::GetStatusByITCStart ()  :
    _Group (0u),
    _ITCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStatusByITCStart::GetStatusByITCStart (const GetStatusByITCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _ITCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStatusByITCStart::GetStatusByITCStart (uint8 Group_, uint32 ITCMask_)  :
    _Group (Group_),
    _ITCMask (ITCMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStatusByITCStart::~GetStatusByITCStart() {
}

inline GetStatusByITCStart& GetStatusByITCStart::operator = (const GetStatusByITCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasITCMask()) {
            setITCMask(rhs.getITCMask());
        } else {
            clearITCMask();
        }
    }
    return *this;
}

inline bool GetStatusByITCStart::operator == (const GetStatusByITCStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasITCMask() && !rhs.hasITCMask()) || getITCMask() == rhs.getITCMask()));
}

inline bool GetStatusByITCStart::operator != (const GetStatusByITCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStatusByITCStart::operator < (const GetStatusByITCStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasITCMask() || rhs.hasITCMask()) {
        if (getITCMask() < rhs.getITCMask()) return true;
        if (getITCMask() > rhs.getITCMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStatusByITCStart::clone() {
    return new GetStatusByITCStart(*this);
}

inline bool GetStatusByITCStart::operator > (const GetStatusByITCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStatusByITCStart::clear() {
    clearGroup();
    clearITCMask();
}

inline void GetStatusByITCStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool GetStatusByITCStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 GetStatusByITCStart::getGroup () const {
    return _Group;
}

inline void GetStatusByITCStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void GetStatusByITCStart::clearITCMask() {
    if (hasITCMask()) {
         clear_has_ITCMask();
        _ITCMask = 0u;
     }
}

inline bool GetStatusByITCStart::hasITCMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 GetStatusByITCStart::getITCMask () const {
    return _ITCMask;
}

inline void GetStatusByITCStart::setITCMask (uint32 ITCMask_) {
    set_has_ITCMask();
    this->_ITCMask = ITCMask_;
}

inline void GetStatusByITCStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStatusByITCStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStatusByITCStart::set_has_ITCMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStatusByITCStart::clear_has_ITCMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetStatusByITCResult::GetStatusByITCResult ()  :
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetStatusByITCResult::GetStatusByITCResult (const GetStatusByITCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _ReadResultList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetStatusByITCResult::GetStatusByITCResult (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _ReadResultList (ReadResultList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetStatusByITCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetStatusByITCResult::~GetStatusByITCResult() {
}

inline GetStatusByITCResult& GetStatusByITCResult::operator = (const GetStatusByITCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReadResultList()) {
            setReadResultList(rhs.getReadResultList());
        } else {
            clearReadResultList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool GetStatusByITCResult::operator == (const GetStatusByITCResult& rhs) const {
    return (((!hasReadResultList() && !rhs.hasReadResultList()) || getReadResultList() == rhs.getReadResultList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool GetStatusByITCResult::operator != (const GetStatusByITCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool GetStatusByITCResult::operator < (const GetStatusByITCResult& rhs) const {
    if (hasReadResultList() || rhs.hasReadResultList()) {
        if (getReadResultList() < rhs.getReadResultList()) return true;
        if (getReadResultList() > rhs.getReadResultList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetStatusByITCResult::clone() {
    return new GetStatusByITCResult(*this);
}

inline bool GetStatusByITCResult::operator > (const GetStatusByITCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetStatusByITCResult::clear() {
    clearReadResultList();
    clearStatus();
}

inline void GetStatusByITCResult::clearReadResultList() {
    if (hasReadResultList()) {
         clear_has_ReadResultList();
        _ReadResultList.clear();
     }
}

inline bool GetStatusByITCResult::hasReadResultList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ReadResultList& GetStatusByITCResult::getReadResultList () const {
    return _ReadResultList;
}

inline ::midw_diaglog_fi_types::T_ReadResultList& GetStatusByITCResult::getReadResultListMutable () {
    set_has_ReadResultList();
    return _ReadResultList;
}

inline void GetStatusByITCResult::setReadResultList (const ::midw_diaglog_fi_types::T_ReadResultList& ReadResultList_) {
    set_has_ReadResultList();
    this->_ReadResultList = ReadResultList_;
}

inline void GetStatusByITCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool GetStatusByITCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply GetStatusByITCResult::getStatus () const {
    return _Status;
}

inline void GetStatusByITCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "GetStatusByITCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void GetStatusByITCResult::set_has_ReadResultList () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetStatusByITCResult::clear_has_ReadResultList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetStatusByITCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetStatusByITCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ReportDTCSnapshotIdentificationStart::ReportDTCSnapshotIdentificationStart ()  :
    _Group (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotIdentificationStart::ReportDTCSnapshotIdentificationStart (const ReportDTCSnapshotIdentificationStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportDTCSnapshotIdentificationStart::ReportDTCSnapshotIdentificationStart (uint8 Group_)  :
    _Group (Group_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotIdentificationStart::~ReportDTCSnapshotIdentificationStart() {
}

inline ReportDTCSnapshotIdentificationStart& ReportDTCSnapshotIdentificationStart::operator = (const ReportDTCSnapshotIdentificationStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
    }
    return *this;
}

inline bool ReportDTCSnapshotIdentificationStart::operator == (const ReportDTCSnapshotIdentificationStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()));
}

inline bool ReportDTCSnapshotIdentificationStart::operator != (const ReportDTCSnapshotIdentificationStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportDTCSnapshotIdentificationStart::operator < (const ReportDTCSnapshotIdentificationStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportDTCSnapshotIdentificationStart::clone() {
    return new ReportDTCSnapshotIdentificationStart(*this);
}

inline bool ReportDTCSnapshotIdentificationStart::operator > (const ReportDTCSnapshotIdentificationStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportDTCSnapshotIdentificationStart::clear() {
    clearGroup();
}

inline void ReportDTCSnapshotIdentificationStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool ReportDTCSnapshotIdentificationStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReportDTCSnapshotIdentificationStart::getGroup () const {
    return _Group;
}

inline void ReportDTCSnapshotIdentificationStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void ReportDTCSnapshotIdentificationStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportDTCSnapshotIdentificationStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ReportDTCSnapshotIdentificationResult::ReportDTCSnapshotIdentificationResult ()  :
    _SnapshotIdentificationList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotIdentificationResult::ReportDTCSnapshotIdentificationResult (const ReportDTCSnapshotIdentificationResult &rhs)  :
    ::asf::core::Payload(rhs),
    _SnapshotIdentificationList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportDTCSnapshotIdentificationResult::ReportDTCSnapshotIdentificationResult (const ::midw_diaglog_fi_types::T_SnapshotIdentificationList& SnapshotIdentificationList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _SnapshotIdentificationList (SnapshotIdentificationList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ReportDTCSnapshotIdentificationResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotIdentificationResult::~ReportDTCSnapshotIdentificationResult() {
}

inline ReportDTCSnapshotIdentificationResult& ReportDTCSnapshotIdentificationResult::operator = (const ReportDTCSnapshotIdentificationResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSnapshotIdentificationList()) {
            setSnapshotIdentificationList(rhs.getSnapshotIdentificationList());
        } else {
            clearSnapshotIdentificationList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ReportDTCSnapshotIdentificationResult::operator == (const ReportDTCSnapshotIdentificationResult& rhs) const {
    return (((!hasSnapshotIdentificationList() && !rhs.hasSnapshotIdentificationList()) || getSnapshotIdentificationList() == rhs.getSnapshotIdentificationList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ReportDTCSnapshotIdentificationResult::operator != (const ReportDTCSnapshotIdentificationResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportDTCSnapshotIdentificationResult::operator < (const ReportDTCSnapshotIdentificationResult& rhs) const {
    if (hasSnapshotIdentificationList() || rhs.hasSnapshotIdentificationList()) {
        if (getSnapshotIdentificationList() < rhs.getSnapshotIdentificationList()) return true;
        if (getSnapshotIdentificationList() > rhs.getSnapshotIdentificationList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportDTCSnapshotIdentificationResult::clone() {
    return new ReportDTCSnapshotIdentificationResult(*this);
}

inline bool ReportDTCSnapshotIdentificationResult::operator > (const ReportDTCSnapshotIdentificationResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportDTCSnapshotIdentificationResult::clear() {
    clearSnapshotIdentificationList();
    clearStatus();
}

inline void ReportDTCSnapshotIdentificationResult::clearSnapshotIdentificationList() {
    if (hasSnapshotIdentificationList()) {
         clear_has_SnapshotIdentificationList();
        _SnapshotIdentificationList.clear();
     }
}

inline bool ReportDTCSnapshotIdentificationResult::hasSnapshotIdentificationList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_SnapshotIdentificationList& ReportDTCSnapshotIdentificationResult::getSnapshotIdentificationList () const {
    return _SnapshotIdentificationList;
}

inline ::midw_diaglog_fi_types::T_SnapshotIdentificationList& ReportDTCSnapshotIdentificationResult::getSnapshotIdentificationListMutable () {
    set_has_SnapshotIdentificationList();
    return _SnapshotIdentificationList;
}

inline void ReportDTCSnapshotIdentificationResult::setSnapshotIdentificationList (const ::midw_diaglog_fi_types::T_SnapshotIdentificationList& SnapshotIdentificationList_) {
    set_has_SnapshotIdentificationList();
    this->_SnapshotIdentificationList = SnapshotIdentificationList_;
}

inline void ReportDTCSnapshotIdentificationResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ReportDTCSnapshotIdentificationResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ReportDTCSnapshotIdentificationResult::getStatus () const {
    return _Status;
}

inline void ReportDTCSnapshotIdentificationResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ReportDTCSnapshotIdentificationResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ReportDTCSnapshotIdentificationResult::set_has_SnapshotIdentificationList () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportDTCSnapshotIdentificationResult::clear_has_SnapshotIdentificationList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportDTCSnapshotIdentificationResult::set_has_Status () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportDTCSnapshotIdentificationResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ReportDTCSnapshotRecordByDTCNumberStart::ReportDTCSnapshotRecordByDTCNumberStart ()  :
    _Group (0u),
    _DTC (0u),
    _DTCSnapshotRecordNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotRecordByDTCNumberStart::ReportDTCSnapshotRecordByDTCNumberStart (const ReportDTCSnapshotRecordByDTCNumberStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _DTC (0u),
    _DTCSnapshotRecordNumber (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportDTCSnapshotRecordByDTCNumberStart::ReportDTCSnapshotRecordByDTCNumberStart (uint8 Group_, uint32 DTC_, uint8 DTCSnapshotRecordNumber_)  :
    _Group (Group_),
    _DTC (DTC_),
    _DTCSnapshotRecordNumber (DTCSnapshotRecordNumber_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotRecordByDTCNumberStart::~ReportDTCSnapshotRecordByDTCNumberStart() {
}

inline ReportDTCSnapshotRecordByDTCNumberStart& ReportDTCSnapshotRecordByDTCNumberStart::operator = (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasDTCSnapshotRecordNumber()) {
            setDTCSnapshotRecordNumber(rhs.getDTCSnapshotRecordNumber());
        } else {
            clearDTCSnapshotRecordNumber();
        }
    }
    return *this;
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::operator == (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasDTCSnapshotRecordNumber() && !rhs.hasDTCSnapshotRecordNumber()) || getDTCSnapshotRecordNumber() == rhs.getDTCSnapshotRecordNumber()));
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::operator != (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::operator < (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasDTCSnapshotRecordNumber() || rhs.hasDTCSnapshotRecordNumber()) {
        if (getDTCSnapshotRecordNumber() < rhs.getDTCSnapshotRecordNumber()) return true;
        if (getDTCSnapshotRecordNumber() > rhs.getDTCSnapshotRecordNumber()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportDTCSnapshotRecordByDTCNumberStart::clone() {
    return new ReportDTCSnapshotRecordByDTCNumberStart(*this);
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::operator > (const ReportDTCSnapshotRecordByDTCNumberStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clear() {
    clearGroup();
    clearDTC();
    clearDTCSnapshotRecordNumber();
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ReportDTCSnapshotRecordByDTCNumberStart::getGroup () const {
    return _Group;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::hasDTC () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ReportDTCSnapshotRecordByDTCNumberStart::getDTC () const {
    return _DTC;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clearDTCSnapshotRecordNumber() {
    if (hasDTCSnapshotRecordNumber()) {
         clear_has_DTCSnapshotRecordNumber();
        _DTCSnapshotRecordNumber = 0u;
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberStart::hasDTCSnapshotRecordNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 ReportDTCSnapshotRecordByDTCNumberStart::getDTCSnapshotRecordNumber () const {
    return _DTCSnapshotRecordNumber;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::setDTCSnapshotRecordNumber (uint8 DTCSnapshotRecordNumber_) {
    set_has_DTCSnapshotRecordNumber();
    this->_DTCSnapshotRecordNumber = DTCSnapshotRecordNumber_;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::set_has_DTC () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::set_has_DTCSnapshotRecordNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReportDTCSnapshotRecordByDTCNumberStart::clear_has_DTCSnapshotRecordNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  ReportDTCSnapshotRecordByDTCNumberResult::ReportDTCSnapshotRecordByDTCNumberResult ()  :
    _DTC (0u),
    _StatusOfDtc (0u),
    _SnapshotDataList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotRecordByDTCNumberResult::ReportDTCSnapshotRecordByDTCNumberResult (const ReportDTCSnapshotRecordByDTCNumberResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DTC (0u),
    _StatusOfDtc (0u),
    _SnapshotDataList (),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportDTCSnapshotRecordByDTCNumberResult::ReportDTCSnapshotRecordByDTCNumberResult (uint32 DTC_, uint8 StatusOfDtc_, const ::midw_diaglog_fi_types::T_SnapshotDataList& SnapshotDataList_, ::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _DTC (DTC_),
    _StatusOfDtc (StatusOfDtc_),
    _SnapshotDataList (SnapshotDataList_),
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ReportDTCSnapshotRecordByDTCNumberResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportDTCSnapshotRecordByDTCNumberResult::~ReportDTCSnapshotRecordByDTCNumberResult() {
}

inline ReportDTCSnapshotRecordByDTCNumberResult& ReportDTCSnapshotRecordByDTCNumberResult::operator = (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDTC()) {
            setDTC(rhs.getDTC());
        } else {
            clearDTC();
        }
        if (rhs.hasStatusOfDtc()) {
            setStatusOfDtc(rhs.getStatusOfDtc());
        } else {
            clearStatusOfDtc();
        }
        if (rhs.hasSnapshotDataList()) {
            setSnapshotDataList(rhs.getSnapshotDataList());
        } else {
            clearSnapshotDataList();
        }
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::operator == (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const {
    return (((!hasDTC() && !rhs.hasDTC()) || getDTC() == rhs.getDTC()) &&
        ((!hasStatusOfDtc() && !rhs.hasStatusOfDtc()) || getStatusOfDtc() == rhs.getStatusOfDtc()) &&
        ((!hasSnapshotDataList() && !rhs.hasSnapshotDataList()) || getSnapshotDataList() == rhs.getSnapshotDataList()) &&
        ((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::operator != (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::operator < (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const {
    if (hasDTC() || rhs.hasDTC()) {
        if (getDTC() < rhs.getDTC()) return true;
        if (getDTC() > rhs.getDTC()) return false;
    }
    if (hasStatusOfDtc() || rhs.hasStatusOfDtc()) {
        if (getStatusOfDtc() < rhs.getStatusOfDtc()) return true;
        if (getStatusOfDtc() > rhs.getStatusOfDtc()) return false;
    }
    if (hasSnapshotDataList() || rhs.hasSnapshotDataList()) {
        if (getSnapshotDataList() < rhs.getSnapshotDataList()) return true;
        if (getSnapshotDataList() > rhs.getSnapshotDataList()) return false;
    }
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportDTCSnapshotRecordByDTCNumberResult::clone() {
    return new ReportDTCSnapshotRecordByDTCNumberResult(*this);
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::operator > (const ReportDTCSnapshotRecordByDTCNumberResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clear() {
    clearDTC();
    clearStatusOfDtc();
    clearSnapshotDataList();
    clearStatus();
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clearDTC() {
    if (hasDTC()) {
         clear_has_DTC();
        _DTC = 0u;
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::hasDTC () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 ReportDTCSnapshotRecordByDTCNumberResult::getDTC () const {
    return _DTC;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::setDTC (uint32 DTC_) {
    set_has_DTC();
    this->_DTC = DTC_;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clearStatusOfDtc() {
    if (hasStatusOfDtc()) {
         clear_has_StatusOfDtc();
        _StatusOfDtc = 0u;
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::hasStatusOfDtc () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 ReportDTCSnapshotRecordByDTCNumberResult::getStatusOfDtc () const {
    return _StatusOfDtc;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::setStatusOfDtc (uint8 StatusOfDtc_) {
    set_has_StatusOfDtc();
    this->_StatusOfDtc = StatusOfDtc_;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clearSnapshotDataList() {
    if (hasSnapshotDataList()) {
         clear_has_SnapshotDataList();
        _SnapshotDataList.clear();
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::hasSnapshotDataList () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::midw_diaglog_fi_types::T_SnapshotDataList& ReportDTCSnapshotRecordByDTCNumberResult::getSnapshotDataList () const {
    return _SnapshotDataList;
}

inline ::midw_diaglog_fi_types::T_SnapshotDataList& ReportDTCSnapshotRecordByDTCNumberResult::getSnapshotDataListMutable () {
    set_has_SnapshotDataList();
    return _SnapshotDataList;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::setSnapshotDataList (const ::midw_diaglog_fi_types::T_SnapshotDataList& SnapshotDataList_) {
    set_has_SnapshotDataList();
    this->_SnapshotDataList = SnapshotDataList_;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ReportDTCSnapshotRecordByDTCNumberResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ReportDTCSnapshotRecordByDTCNumberResult::getStatus () const {
    return _Status;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ReportDTCSnapshotRecordByDTCNumberResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::set_has_DTC () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clear_has_DTC () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::set_has_StatusOfDtc () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clear_has_StatusOfDtc () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::set_has_SnapshotDataList () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clear_has_SnapshotDataList () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::set_has_Status () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReportDTCSnapshotRecordByDTCNumberResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  ClearDTCStart::ClearDTCStart ()  :
    _Group (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearDTCStart::ClearDTCStart (const ClearDTCStart &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _DTCMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearDTCStart::ClearDTCStart (uint8 Group_, uint32 DTCMask_)  :
    _Group (Group_),
    _DTCMask (DTCMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearDTCStart::~ClearDTCStart() {
}

inline ClearDTCStart& ClearDTCStart::operator = (const ClearDTCStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasDTCMask()) {
            setDTCMask(rhs.getDTCMask());
        } else {
            clearDTCMask();
        }
    }
    return *this;
}

inline bool ClearDTCStart::operator == (const ClearDTCStart& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasDTCMask() && !rhs.hasDTCMask()) || getDTCMask() == rhs.getDTCMask()));
}

inline bool ClearDTCStart::operator != (const ClearDTCStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearDTCStart::operator < (const ClearDTCStart& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasDTCMask() || rhs.hasDTCMask()) {
        if (getDTCMask() < rhs.getDTCMask()) return true;
        if (getDTCMask() > rhs.getDTCMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearDTCStart::clone() {
    return new ClearDTCStart(*this);
}

inline bool ClearDTCStart::operator > (const ClearDTCStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearDTCStart::clear() {
    clearGroup();
    clearDTCMask();
}

inline void ClearDTCStart::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool ClearDTCStart::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ClearDTCStart::getGroup () const {
    return _Group;
}

inline void ClearDTCStart::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void ClearDTCStart::clearDTCMask() {
    if (hasDTCMask()) {
         clear_has_DTCMask();
        _DTCMask = 0u;
     }
}

inline bool ClearDTCStart::hasDTCMask () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 ClearDTCStart::getDTCMask () const {
    return _DTCMask;
}

inline void ClearDTCStart::setDTCMask (uint32 DTCMask_) {
    set_has_DTCMask();
    this->_DTCMask = DTCMask_;
}

inline void ClearDTCStart::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearDTCStart::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ClearDTCStart::set_has_DTCMask () {
    _has_bits_[0] |= 1u << 1;
}

inline void ClearDTCStart::clear_has_DTCMask () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ClearDTCResult::ClearDTCResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ClearDTCResult::ClearDTCResult (const ClearDTCResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ClearDTCResult::ClearDTCResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ClearDTCResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ClearDTCResult::~ClearDTCResult() {
}

inline ClearDTCResult& ClearDTCResult::operator = (const ClearDTCResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ClearDTCResult::operator == (const ClearDTCResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ClearDTCResult::operator != (const ClearDTCResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ClearDTCResult::operator < (const ClearDTCResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ClearDTCResult::clone() {
    return new ClearDTCResult(*this);
}

inline bool ClearDTCResult::operator > (const ClearDTCResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ClearDTCResult::clear() {
    clearStatus();
}

inline void ClearDTCResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ClearDTCResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ClearDTCResult::getStatus () const {
    return _Status;
}

inline void ClearDTCResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ClearDTCResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ClearDTCResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void ClearDTCResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ControlStart::ControlStart ()  :
    _ControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter__DisableLogging)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ControlStart::ControlStart (const ControlStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter__DisableLogging)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ControlStart::ControlStart (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_)  :
    _ControlParameter (ControlParameter_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_ControlParameter_IsValid(ControlParameter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ControlParameter_, "T_e8_ControlParameter", "ControlParameter", "ControlStart");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ControlStart::~ControlStart() {
}

inline ControlStart& ControlStart::operator = (const ControlStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasControlParameter()) {
            setControlParameter(rhs.getControlParameter());
        } else {
            clearControlParameter();
        }
    }
    return *this;
}

inline bool ControlStart::operator == (const ControlStart& rhs) const {
    return (((!hasControlParameter() && !rhs.hasControlParameter()) || getControlParameter() == rhs.getControlParameter()));
}

inline bool ControlStart::operator != (const ControlStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ControlStart::operator < (const ControlStart& rhs) const {
    if (hasControlParameter() || rhs.hasControlParameter()) {
        if ((uint32)getControlParameter() < (uint32)rhs.getControlParameter()) return true;
        if ((uint32)getControlParameter() > (uint32)rhs.getControlParameter()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ControlStart::clone() {
    return new ControlStart(*this);
}

inline bool ControlStart::operator > (const ControlStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ControlStart::clear() {
    clearControlParameter();
}

inline void ControlStart::clearControlParameter() {
    if (hasControlParameter()) {
         clear_has_ControlParameter();
        _ControlParameter = ::midw_diaglog_fi_types::T_e8_ControlParameter__DisableLogging;
     }
}

inline bool ControlStart::hasControlParameter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_ControlParameter ControlStart::getControlParameter () const {
    return _ControlParameter;
}

inline void ControlStart::setControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_ControlParameter_IsValid(ControlParameter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ControlParameter_, "T_e8_ControlParameter", "ControlParameter", "ControlStart");
    }
    set_has_ControlParameter();
    this->_ControlParameter = ControlParameter_;
}

inline void ControlStart::set_has_ControlParameter () {
    _has_bits_[0] |= 1u << 0;
}

inline void ControlStart::clear_has_ControlParameter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ControlResult::ControlResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ControlResult::ControlResult (const ControlResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ControlResult::ControlResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ControlResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ControlResult::~ControlResult() {
}

inline ControlResult& ControlResult::operator = (const ControlResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ControlResult::operator == (const ControlResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ControlResult::operator != (const ControlResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ControlResult::operator < (const ControlResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ControlResult::clone() {
    return new ControlResult(*this);
}

inline bool ControlResult::operator > (const ControlResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ControlResult::clear() {
    clearStatus();
}

inline void ControlResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ControlResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ControlResult::getStatus () const {
    return _Status;
}

inline void ControlResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ControlResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ControlResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void ControlResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ControlDtcSettingStart::ControlDtcSettingStart ()  :
    _ControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter__DisableLogging),
    _DTC_List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ControlDtcSettingStart::ControlDtcSettingStart (const ControlDtcSettingStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter__DisableLogging),
    _DTC_List ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ControlDtcSettingStart::ControlDtcSettingStart (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_, const ::midw_diaglog_fi_types::T_ControlList& DTC_List_)  :
    _ControlParameter (ControlParameter_),
    _DTC_List (DTC_List_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_ControlParameter_IsValid(ControlParameter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ControlParameter_, "T_e8_ControlParameter", "ControlParameter", "ControlDtcSettingStart");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ControlDtcSettingStart::~ControlDtcSettingStart() {
}

inline ControlDtcSettingStart& ControlDtcSettingStart::operator = (const ControlDtcSettingStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasControlParameter()) {
            setControlParameter(rhs.getControlParameter());
        } else {
            clearControlParameter();
        }
        if (rhs.hasDTC_List()) {
            setDTC_List(rhs.getDTC_List());
        } else {
            clearDTC_List();
        }
    }
    return *this;
}

inline bool ControlDtcSettingStart::operator == (const ControlDtcSettingStart& rhs) const {
    return (((!hasControlParameter() && !rhs.hasControlParameter()) || getControlParameter() == rhs.getControlParameter()) &&
        ((!hasDTC_List() && !rhs.hasDTC_List()) || getDTC_List() == rhs.getDTC_List()));
}

inline bool ControlDtcSettingStart::operator != (const ControlDtcSettingStart& rhs) const {
    return ! (*this == rhs);
}

inline bool ControlDtcSettingStart::operator < (const ControlDtcSettingStart& rhs) const {
    if (hasControlParameter() || rhs.hasControlParameter()) {
        if ((uint32)getControlParameter() < (uint32)rhs.getControlParameter()) return true;
        if ((uint32)getControlParameter() > (uint32)rhs.getControlParameter()) return false;
    }
    if (hasDTC_List() || rhs.hasDTC_List()) {
        if (getDTC_List() < rhs.getDTC_List()) return true;
        if (getDTC_List() > rhs.getDTC_List()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ControlDtcSettingStart::clone() {
    return new ControlDtcSettingStart(*this);
}

inline bool ControlDtcSettingStart::operator > (const ControlDtcSettingStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ControlDtcSettingStart::clear() {
    clearControlParameter();
    clearDTC_List();
}

inline void ControlDtcSettingStart::clearControlParameter() {
    if (hasControlParameter()) {
         clear_has_ControlParameter();
        _ControlParameter = ::midw_diaglog_fi_types::T_e8_ControlParameter__DisableLogging;
     }
}

inline bool ControlDtcSettingStart::hasControlParameter () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_ControlParameter ControlDtcSettingStart::getControlParameter () const {
    return _ControlParameter;
}

inline void ControlDtcSettingStart::setControlParameter (::midw_diaglog_fi_types::T_e8_ControlParameter ControlParameter_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_ControlParameter_IsValid(ControlParameter_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", ControlParameter_, "T_e8_ControlParameter", "ControlParameter", "ControlDtcSettingStart");
    }
    set_has_ControlParameter();
    this->_ControlParameter = ControlParameter_;
}

inline void ControlDtcSettingStart::clearDTC_List() {
    if (hasDTC_List()) {
         clear_has_DTC_List();
        _DTC_List.clear();
     }
}

inline bool ControlDtcSettingStart::hasDTC_List () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ControlList& ControlDtcSettingStart::getDTC_List () const {
    return _DTC_List;
}

inline ::midw_diaglog_fi_types::T_ControlList& ControlDtcSettingStart::getDTC_ListMutable () {
    set_has_DTC_List();
    return _DTC_List;
}

inline void ControlDtcSettingStart::setDTC_List (const ::midw_diaglog_fi_types::T_ControlList& DTC_List_) {
    set_has_DTC_List();
    this->_DTC_List = DTC_List_;
}

inline void ControlDtcSettingStart::set_has_ControlParameter () {
    _has_bits_[0] |= 1u << 0;
}

inline void ControlDtcSettingStart::clear_has_ControlParameter () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ControlDtcSettingStart::set_has_DTC_List () {
    _has_bits_[0] |= 1u << 1;
}

inline void ControlDtcSettingStart::clear_has_DTC_List () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  ControlDtcSettingResult::ControlDtcSettingResult ()  :
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ControlDtcSettingResult::ControlDtcSettingResult (const ControlDtcSettingResult &rhs)  :
    ::asf::core::Payload(rhs),
    _Status (::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ControlDtcSettingResult::ControlDtcSettingResult (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ControlDtcSettingResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ControlDtcSettingResult::~ControlDtcSettingResult() {
}

inline ControlDtcSettingResult& ControlDtcSettingResult::operator = (const ControlDtcSettingResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool ControlDtcSettingResult::operator == (const ControlDtcSettingResult& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool ControlDtcSettingResult::operator != (const ControlDtcSettingResult& rhs) const {
    return ! (*this == rhs);
}

inline bool ControlDtcSettingResult::operator < (const ControlDtcSettingResult& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if ((uint32)getStatus() < (uint32)rhs.getStatus()) return true;
        if ((uint32)getStatus() > (uint32)rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ControlDtcSettingResult::clone() {
    return new ControlDtcSettingResult(*this);
}

inline bool ControlDtcSettingResult::operator > (const ControlDtcSettingResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ControlDtcSettingResult::clear() {
    clearStatus();
}

inline void ControlDtcSettingResult::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status = ::midw_diaglog_fi_types::T_e8_MethodResultReply__Accepted;
     }
}

inline bool ControlDtcSettingResult::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_MethodResultReply ControlDtcSettingResult::getStatus () const {
    return _Status;
}

inline void ControlDtcSettingResult::setStatus (::midw_diaglog_fi_types::T_e8_MethodResultReply Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_MethodResultReply_IsValid(Status_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", Status_, "T_e8_MethodResultReply", "Status", "ControlDtcSettingResult");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void ControlDtcSettingResult::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void ControlDtcSettingResult::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DTCTriggeredStatus::DTCTriggeredStatus ()  :
    _bDTCTriggeredFlag (false),
    _u8DTCSource (0u),
    _u16DTCNumber (0u),
    _u8DTCFailureType (0u),
    _bDTCWarningIndicatorRequestedStatus (false),
    _bDTCTestFailedSincePowerUpStatus (false),
    _bDTCTestNotPassedSincePowerUpStatus (false),
    _bDTCHistoryStatus (false),
    _bDTCTestFailedSinceCodeClearedStatus (false),
    _bDTCTestNotPassedSinceCodeClearedStatus (false),
    _bDTCCurrentStatus (false),
    _bDTCCodeSupported (false),
    _e8DTCFaultType (::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType__e8NOT_SUPPORTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DTCTriggeredStatus::DTCTriggeredStatus (const DTCTriggeredStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bDTCTriggeredFlag (false),
    _u8DTCSource (0u),
    _u16DTCNumber (0u),
    _u8DTCFailureType (0u),
    _bDTCWarningIndicatorRequestedStatus (false),
    _bDTCTestFailedSincePowerUpStatus (false),
    _bDTCTestNotPassedSincePowerUpStatus (false),
    _bDTCHistoryStatus (false),
    _bDTCTestFailedSinceCodeClearedStatus (false),
    _bDTCTestNotPassedSinceCodeClearedStatus (false),
    _bDTCCurrentStatus (false),
    _bDTCCodeSupported (false),
    _e8DTCFaultType (::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType__e8NOT_SUPPORTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DTCTriggeredStatus::DTCTriggeredStatus (bool bDTCTriggeredFlag_, uint8 u8DTCSource_, uint16 u16DTCNumber_, uint8 u8DTCFailureType_, bool bDTCWarningIndicatorRequestedStatus_, bool bDTCTestFailedSincePowerUpStatus_, bool bDTCTestNotPassedSincePowerUpStatus_, bool bDTCHistoryStatus_, bool bDTCTestFailedSinceCodeClearedStatus_, bool bDTCTestNotPassedSinceCodeClearedStatus_, bool bDTCCurrentStatus_, bool bDTCCodeSupported_, ::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType e8DTCFaultType_)  :
    _bDTCTriggeredFlag (bDTCTriggeredFlag_),
    _u8DTCSource (u8DTCSource_),
    _u16DTCNumber (u16DTCNumber_),
    _u8DTCFailureType (u8DTCFailureType_),
    _bDTCWarningIndicatorRequestedStatus (bDTCWarningIndicatorRequestedStatus_),
    _bDTCTestFailedSincePowerUpStatus (bDTCTestFailedSincePowerUpStatus_),
    _bDTCTestNotPassedSincePowerUpStatus (bDTCTestNotPassedSincePowerUpStatus_),
    _bDTCHistoryStatus (bDTCHistoryStatus_),
    _bDTCTestFailedSinceCodeClearedStatus (bDTCTestFailedSinceCodeClearedStatus_),
    _bDTCTestNotPassedSinceCodeClearedStatus (bDTCTestNotPassedSinceCodeClearedStatus_),
    _bDTCCurrentStatus (bDTCCurrentStatus_),
    _bDTCCodeSupported (bDTCCodeSupported_),
    _e8DTCFaultType (e8DTCFaultType_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType_IsValid(e8DTCFaultType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DTCFaultType_, "T_e8_GMLnGWDTCFaultType", "e8DTCFaultType", "DTCTriggeredStatus");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DTCTriggeredStatus::~DTCTriggeredStatus() {
}

inline DTCTriggeredStatus& DTCTriggeredStatus::operator = (const DTCTriggeredStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBDTCTriggeredFlag()) {
            setBDTCTriggeredFlag(rhs.getBDTCTriggeredFlag());
        } else {
            clearBDTCTriggeredFlag();
        }
        if (rhs.hasU8DTCSource()) {
            setU8DTCSource(rhs.getU8DTCSource());
        } else {
            clearU8DTCSource();
        }
        if (rhs.hasU16DTCNumber()) {
            setU16DTCNumber(rhs.getU16DTCNumber());
        } else {
            clearU16DTCNumber();
        }
        if (rhs.hasU8DTCFailureType()) {
            setU8DTCFailureType(rhs.getU8DTCFailureType());
        } else {
            clearU8DTCFailureType();
        }
        if (rhs.hasBDTCWarningIndicatorRequestedStatus()) {
            setBDTCWarningIndicatorRequestedStatus(rhs.getBDTCWarningIndicatorRequestedStatus());
        } else {
            clearBDTCWarningIndicatorRequestedStatus();
        }
        if (rhs.hasBDTCTestFailedSincePowerUpStatus()) {
            setBDTCTestFailedSincePowerUpStatus(rhs.getBDTCTestFailedSincePowerUpStatus());
        } else {
            clearBDTCTestFailedSincePowerUpStatus();
        }
        if (rhs.hasBDTCTestNotPassedSincePowerUpStatus()) {
            setBDTCTestNotPassedSincePowerUpStatus(rhs.getBDTCTestNotPassedSincePowerUpStatus());
        } else {
            clearBDTCTestNotPassedSincePowerUpStatus();
        }
        if (rhs.hasBDTCHistoryStatus()) {
            setBDTCHistoryStatus(rhs.getBDTCHistoryStatus());
        } else {
            clearBDTCHistoryStatus();
        }
        if (rhs.hasBDTCTestFailedSinceCodeClearedStatus()) {
            setBDTCTestFailedSinceCodeClearedStatus(rhs.getBDTCTestFailedSinceCodeClearedStatus());
        } else {
            clearBDTCTestFailedSinceCodeClearedStatus();
        }
        if (rhs.hasBDTCTestNotPassedSinceCodeClearedStatus()) {
            setBDTCTestNotPassedSinceCodeClearedStatus(rhs.getBDTCTestNotPassedSinceCodeClearedStatus());
        } else {
            clearBDTCTestNotPassedSinceCodeClearedStatus();
        }
        if (rhs.hasBDTCCurrentStatus()) {
            setBDTCCurrentStatus(rhs.getBDTCCurrentStatus());
        } else {
            clearBDTCCurrentStatus();
        }
        if (rhs.hasBDTCCodeSupported()) {
            setBDTCCodeSupported(rhs.getBDTCCodeSupported());
        } else {
            clearBDTCCodeSupported();
        }
        if (rhs.hasE8DTCFaultType()) {
            setE8DTCFaultType(rhs.getE8DTCFaultType());
        } else {
            clearE8DTCFaultType();
        }
    }
    return *this;
}

inline bool DTCTriggeredStatus::operator == (const DTCTriggeredStatus& rhs) const {
    return (((!hasBDTCTriggeredFlag() && !rhs.hasBDTCTriggeredFlag()) || getBDTCTriggeredFlag() == rhs.getBDTCTriggeredFlag()) &&
        ((!hasU8DTCSource() && !rhs.hasU8DTCSource()) || getU8DTCSource() == rhs.getU8DTCSource()) &&
        ((!hasU16DTCNumber() && !rhs.hasU16DTCNumber()) || getU16DTCNumber() == rhs.getU16DTCNumber()) &&
        ((!hasU8DTCFailureType() && !rhs.hasU8DTCFailureType()) || getU8DTCFailureType() == rhs.getU8DTCFailureType()) &&
        ((!hasBDTCWarningIndicatorRequestedStatus() && !rhs.hasBDTCWarningIndicatorRequestedStatus()) || getBDTCWarningIndicatorRequestedStatus() == rhs.getBDTCWarningIndicatorRequestedStatus()) &&
        ((!hasBDTCTestFailedSincePowerUpStatus() && !rhs.hasBDTCTestFailedSincePowerUpStatus()) || getBDTCTestFailedSincePowerUpStatus() == rhs.getBDTCTestFailedSincePowerUpStatus()) &&
        ((!hasBDTCTestNotPassedSincePowerUpStatus() && !rhs.hasBDTCTestNotPassedSincePowerUpStatus()) || getBDTCTestNotPassedSincePowerUpStatus() == rhs.getBDTCTestNotPassedSincePowerUpStatus()) &&
        ((!hasBDTCHistoryStatus() && !rhs.hasBDTCHistoryStatus()) || getBDTCHistoryStatus() == rhs.getBDTCHistoryStatus()) &&
        ((!hasBDTCTestFailedSinceCodeClearedStatus() && !rhs.hasBDTCTestFailedSinceCodeClearedStatus()) || getBDTCTestFailedSinceCodeClearedStatus() == rhs.getBDTCTestFailedSinceCodeClearedStatus()) &&
        ((!hasBDTCTestNotPassedSinceCodeClearedStatus() && !rhs.hasBDTCTestNotPassedSinceCodeClearedStatus()) || getBDTCTestNotPassedSinceCodeClearedStatus() == rhs.getBDTCTestNotPassedSinceCodeClearedStatus()) &&
        ((!hasBDTCCurrentStatus() && !rhs.hasBDTCCurrentStatus()) || getBDTCCurrentStatus() == rhs.getBDTCCurrentStatus()) &&
        ((!hasBDTCCodeSupported() && !rhs.hasBDTCCodeSupported()) || getBDTCCodeSupported() == rhs.getBDTCCodeSupported()) &&
        ((!hasE8DTCFaultType() && !rhs.hasE8DTCFaultType()) || getE8DTCFaultType() == rhs.getE8DTCFaultType()));
}

inline bool DTCTriggeredStatus::operator != (const DTCTriggeredStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DTCTriggeredStatus::operator < (const DTCTriggeredStatus& rhs) const {
    if (hasBDTCTriggeredFlag() || rhs.hasBDTCTriggeredFlag()) {
        if (getBDTCTriggeredFlag() < rhs.getBDTCTriggeredFlag()) return true;
        if (getBDTCTriggeredFlag() > rhs.getBDTCTriggeredFlag()) return false;
    }
    if (hasU8DTCSource() || rhs.hasU8DTCSource()) {
        if (getU8DTCSource() < rhs.getU8DTCSource()) return true;
        if (getU8DTCSource() > rhs.getU8DTCSource()) return false;
    }
    if (hasU16DTCNumber() || rhs.hasU16DTCNumber()) {
        if (getU16DTCNumber() < rhs.getU16DTCNumber()) return true;
        if (getU16DTCNumber() > rhs.getU16DTCNumber()) return false;
    }
    if (hasU8DTCFailureType() || rhs.hasU8DTCFailureType()) {
        if (getU8DTCFailureType() < rhs.getU8DTCFailureType()) return true;
        if (getU8DTCFailureType() > rhs.getU8DTCFailureType()) return false;
    }
    if (hasBDTCWarningIndicatorRequestedStatus() || rhs.hasBDTCWarningIndicatorRequestedStatus()) {
        if (getBDTCWarningIndicatorRequestedStatus() < rhs.getBDTCWarningIndicatorRequestedStatus()) return true;
        if (getBDTCWarningIndicatorRequestedStatus() > rhs.getBDTCWarningIndicatorRequestedStatus()) return false;
    }
    if (hasBDTCTestFailedSincePowerUpStatus() || rhs.hasBDTCTestFailedSincePowerUpStatus()) {
        if (getBDTCTestFailedSincePowerUpStatus() < rhs.getBDTCTestFailedSincePowerUpStatus()) return true;
        if (getBDTCTestFailedSincePowerUpStatus() > rhs.getBDTCTestFailedSincePowerUpStatus()) return false;
    }
    if (hasBDTCTestNotPassedSincePowerUpStatus() || rhs.hasBDTCTestNotPassedSincePowerUpStatus()) {
        if (getBDTCTestNotPassedSincePowerUpStatus() < rhs.getBDTCTestNotPassedSincePowerUpStatus()) return true;
        if (getBDTCTestNotPassedSincePowerUpStatus() > rhs.getBDTCTestNotPassedSincePowerUpStatus()) return false;
    }
    if (hasBDTCHistoryStatus() || rhs.hasBDTCHistoryStatus()) {
        if (getBDTCHistoryStatus() < rhs.getBDTCHistoryStatus()) return true;
        if (getBDTCHistoryStatus() > rhs.getBDTCHistoryStatus()) return false;
    }
    if (hasBDTCTestFailedSinceCodeClearedStatus() || rhs.hasBDTCTestFailedSinceCodeClearedStatus()) {
        if (getBDTCTestFailedSinceCodeClearedStatus() < rhs.getBDTCTestFailedSinceCodeClearedStatus()) return true;
        if (getBDTCTestFailedSinceCodeClearedStatus() > rhs.getBDTCTestFailedSinceCodeClearedStatus()) return false;
    }
    if (hasBDTCTestNotPassedSinceCodeClearedStatus() || rhs.hasBDTCTestNotPassedSinceCodeClearedStatus()) {
        if (getBDTCTestNotPassedSinceCodeClearedStatus() < rhs.getBDTCTestNotPassedSinceCodeClearedStatus()) return true;
        if (getBDTCTestNotPassedSinceCodeClearedStatus() > rhs.getBDTCTestNotPassedSinceCodeClearedStatus()) return false;
    }
    if (hasBDTCCurrentStatus() || rhs.hasBDTCCurrentStatus()) {
        if (getBDTCCurrentStatus() < rhs.getBDTCCurrentStatus()) return true;
        if (getBDTCCurrentStatus() > rhs.getBDTCCurrentStatus()) return false;
    }
    if (hasBDTCCodeSupported() || rhs.hasBDTCCodeSupported()) {
        if (getBDTCCodeSupported() < rhs.getBDTCCodeSupported()) return true;
        if (getBDTCCodeSupported() > rhs.getBDTCCodeSupported()) return false;
    }
    if (hasE8DTCFaultType() || rhs.hasE8DTCFaultType()) {
        if ((uint32)getE8DTCFaultType() < (uint32)rhs.getE8DTCFaultType()) return true;
        if ((uint32)getE8DTCFaultType() > (uint32)rhs.getE8DTCFaultType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DTCTriggeredStatus::clone() {
    return new DTCTriggeredStatus(*this);
}

inline bool DTCTriggeredStatus::operator > (const DTCTriggeredStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DTCTriggeredStatus::clear() {
    clearBDTCTriggeredFlag();
    clearU8DTCSource();
    clearU16DTCNumber();
    clearU8DTCFailureType();
    clearBDTCWarningIndicatorRequestedStatus();
    clearBDTCTestFailedSincePowerUpStatus();
    clearBDTCTestNotPassedSincePowerUpStatus();
    clearBDTCHistoryStatus();
    clearBDTCTestFailedSinceCodeClearedStatus();
    clearBDTCTestNotPassedSinceCodeClearedStatus();
    clearBDTCCurrentStatus();
    clearBDTCCodeSupported();
    clearE8DTCFaultType();
}

inline void DTCTriggeredStatus::clearBDTCTriggeredFlag() {
    if (hasBDTCTriggeredFlag()) {
         clear_has_bDTCTriggeredFlag();
        _bDTCTriggeredFlag = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCTriggeredFlag () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCTriggeredFlag () const {
    return _bDTCTriggeredFlag;
}

inline void DTCTriggeredStatus::setBDTCTriggeredFlag (bool bDTCTriggeredFlag_) {
    set_has_bDTCTriggeredFlag();
    this->_bDTCTriggeredFlag = bDTCTriggeredFlag_;
}

inline void DTCTriggeredStatus::clearU8DTCSource() {
    if (hasU8DTCSource()) {
         clear_has_u8DTCSource();
        _u8DTCSource = 0u;
     }
}

inline bool DTCTriggeredStatus::hasU8DTCSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 DTCTriggeredStatus::getU8DTCSource () const {
    return _u8DTCSource;
}

inline void DTCTriggeredStatus::setU8DTCSource (uint8 u8DTCSource_) {
    set_has_u8DTCSource();
    this->_u8DTCSource = u8DTCSource_;
}

inline void DTCTriggeredStatus::clearU16DTCNumber() {
    if (hasU16DTCNumber()) {
         clear_has_u16DTCNumber();
        _u16DTCNumber = 0u;
     }
}

inline bool DTCTriggeredStatus::hasU16DTCNumber () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 DTCTriggeredStatus::getU16DTCNumber () const {
    return _u16DTCNumber;
}

inline void DTCTriggeredStatus::setU16DTCNumber (uint16 u16DTCNumber_) {
    set_has_u16DTCNumber();
    this->_u16DTCNumber = u16DTCNumber_;
}

inline void DTCTriggeredStatus::clearU8DTCFailureType() {
    if (hasU8DTCFailureType()) {
         clear_has_u8DTCFailureType();
        _u8DTCFailureType = 0u;
     }
}

inline bool DTCTriggeredStatus::hasU8DTCFailureType () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 DTCTriggeredStatus::getU8DTCFailureType () const {
    return _u8DTCFailureType;
}

inline void DTCTriggeredStatus::setU8DTCFailureType (uint8 u8DTCFailureType_) {
    set_has_u8DTCFailureType();
    this->_u8DTCFailureType = u8DTCFailureType_;
}

inline void DTCTriggeredStatus::clearBDTCWarningIndicatorRequestedStatus() {
    if (hasBDTCWarningIndicatorRequestedStatus()) {
         clear_has_bDTCWarningIndicatorRequestedStatus();
        _bDTCWarningIndicatorRequestedStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCWarningIndicatorRequestedStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCWarningIndicatorRequestedStatus () const {
    return _bDTCWarningIndicatorRequestedStatus;
}

inline void DTCTriggeredStatus::setBDTCWarningIndicatorRequestedStatus (bool bDTCWarningIndicatorRequestedStatus_) {
    set_has_bDTCWarningIndicatorRequestedStatus();
    this->_bDTCWarningIndicatorRequestedStatus = bDTCWarningIndicatorRequestedStatus_;
}

inline void DTCTriggeredStatus::clearBDTCTestFailedSincePowerUpStatus() {
    if (hasBDTCTestFailedSincePowerUpStatus()) {
         clear_has_bDTCTestFailedSincePowerUpStatus();
        _bDTCTestFailedSincePowerUpStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCTestFailedSincePowerUpStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCTestFailedSincePowerUpStatus () const {
    return _bDTCTestFailedSincePowerUpStatus;
}

inline void DTCTriggeredStatus::setBDTCTestFailedSincePowerUpStatus (bool bDTCTestFailedSincePowerUpStatus_) {
    set_has_bDTCTestFailedSincePowerUpStatus();
    this->_bDTCTestFailedSincePowerUpStatus = bDTCTestFailedSincePowerUpStatus_;
}

inline void DTCTriggeredStatus::clearBDTCTestNotPassedSincePowerUpStatus() {
    if (hasBDTCTestNotPassedSincePowerUpStatus()) {
         clear_has_bDTCTestNotPassedSincePowerUpStatus();
        _bDTCTestNotPassedSincePowerUpStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCTestNotPassedSincePowerUpStatus () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCTestNotPassedSincePowerUpStatus () const {
    return _bDTCTestNotPassedSincePowerUpStatus;
}

inline void DTCTriggeredStatus::setBDTCTestNotPassedSincePowerUpStatus (bool bDTCTestNotPassedSincePowerUpStatus_) {
    set_has_bDTCTestNotPassedSincePowerUpStatus();
    this->_bDTCTestNotPassedSincePowerUpStatus = bDTCTestNotPassedSincePowerUpStatus_;
}

inline void DTCTriggeredStatus::clearBDTCHistoryStatus() {
    if (hasBDTCHistoryStatus()) {
         clear_has_bDTCHistoryStatus();
        _bDTCHistoryStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCHistoryStatus () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCHistoryStatus () const {
    return _bDTCHistoryStatus;
}

inline void DTCTriggeredStatus::setBDTCHistoryStatus (bool bDTCHistoryStatus_) {
    set_has_bDTCHistoryStatus();
    this->_bDTCHistoryStatus = bDTCHistoryStatus_;
}

inline void DTCTriggeredStatus::clearBDTCTestFailedSinceCodeClearedStatus() {
    if (hasBDTCTestFailedSinceCodeClearedStatus()) {
         clear_has_bDTCTestFailedSinceCodeClearedStatus();
        _bDTCTestFailedSinceCodeClearedStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCTestFailedSinceCodeClearedStatus () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCTestFailedSinceCodeClearedStatus () const {
    return _bDTCTestFailedSinceCodeClearedStatus;
}

inline void DTCTriggeredStatus::setBDTCTestFailedSinceCodeClearedStatus (bool bDTCTestFailedSinceCodeClearedStatus_) {
    set_has_bDTCTestFailedSinceCodeClearedStatus();
    this->_bDTCTestFailedSinceCodeClearedStatus = bDTCTestFailedSinceCodeClearedStatus_;
}

inline void DTCTriggeredStatus::clearBDTCTestNotPassedSinceCodeClearedStatus() {
    if (hasBDTCTestNotPassedSinceCodeClearedStatus()) {
         clear_has_bDTCTestNotPassedSinceCodeClearedStatus();
        _bDTCTestNotPassedSinceCodeClearedStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCTestNotPassedSinceCodeClearedStatus () const {
    return (_has_bits_[0] & (1u << 9)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCTestNotPassedSinceCodeClearedStatus () const {
    return _bDTCTestNotPassedSinceCodeClearedStatus;
}

inline void DTCTriggeredStatus::setBDTCTestNotPassedSinceCodeClearedStatus (bool bDTCTestNotPassedSinceCodeClearedStatus_) {
    set_has_bDTCTestNotPassedSinceCodeClearedStatus();
    this->_bDTCTestNotPassedSinceCodeClearedStatus = bDTCTestNotPassedSinceCodeClearedStatus_;
}

inline void DTCTriggeredStatus::clearBDTCCurrentStatus() {
    if (hasBDTCCurrentStatus()) {
         clear_has_bDTCCurrentStatus();
        _bDTCCurrentStatus = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCCurrentStatus () const {
    return (_has_bits_[0] & (1u << 10)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCCurrentStatus () const {
    return _bDTCCurrentStatus;
}

inline void DTCTriggeredStatus::setBDTCCurrentStatus (bool bDTCCurrentStatus_) {
    set_has_bDTCCurrentStatus();
    this->_bDTCCurrentStatus = bDTCCurrentStatus_;
}

inline void DTCTriggeredStatus::clearBDTCCodeSupported() {
    if (hasBDTCCodeSupported()) {
         clear_has_bDTCCodeSupported();
        _bDTCCodeSupported = false;
     }
}

inline bool DTCTriggeredStatus::hasBDTCCodeSupported () const {
    return (_has_bits_[0] & (1u << 11)) > 0;
}

inline bool DTCTriggeredStatus::getBDTCCodeSupported () const {
    return _bDTCCodeSupported;
}

inline void DTCTriggeredStatus::setBDTCCodeSupported (bool bDTCCodeSupported_) {
    set_has_bDTCCodeSupported();
    this->_bDTCCodeSupported = bDTCCodeSupported_;
}

inline void DTCTriggeredStatus::clearE8DTCFaultType() {
    if (hasE8DTCFaultType()) {
         clear_has_e8DTCFaultType();
        _e8DTCFaultType = ::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType__e8NOT_SUPPORTED;
     }
}

inline bool DTCTriggeredStatus::hasE8DTCFaultType () const {
    return (_has_bits_[0] & (1u << 12)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType DTCTriggeredStatus::getE8DTCFaultType () const {
    return _e8DTCFaultType;
}

inline void DTCTriggeredStatus::setE8DTCFaultType (::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType e8DTCFaultType_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_GMLnGWDTCFaultType_IsValid(e8DTCFaultType_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DTCFaultType_, "T_e8_GMLnGWDTCFaultType", "e8DTCFaultType", "DTCTriggeredStatus");
    }
    set_has_e8DTCFaultType();
    this->_e8DTCFaultType = e8DTCFaultType_;
}

inline void DTCTriggeredStatus::set_has_bDTCTriggeredFlag () {
    _has_bits_[0] |= 1u << 0;
}

inline void DTCTriggeredStatus::clear_has_bDTCTriggeredFlag () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DTCTriggeredStatus::set_has_u8DTCSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void DTCTriggeredStatus::clear_has_u8DTCSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DTCTriggeredStatus::set_has_u16DTCNumber () {
    _has_bits_[0] |= 1u << 2;
}

inline void DTCTriggeredStatus::clear_has_u16DTCNumber () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void DTCTriggeredStatus::set_has_u8DTCFailureType () {
    _has_bits_[0] |= 1u << 3;
}

inline void DTCTriggeredStatus::clear_has_u8DTCFailureType () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void DTCTriggeredStatus::set_has_bDTCWarningIndicatorRequestedStatus () {
    _has_bits_[0] |= 1u << 4;
}

inline void DTCTriggeredStatus::clear_has_bDTCWarningIndicatorRequestedStatus () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void DTCTriggeredStatus::set_has_bDTCTestFailedSincePowerUpStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void DTCTriggeredStatus::clear_has_bDTCTestFailedSincePowerUpStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void DTCTriggeredStatus::set_has_bDTCTestNotPassedSincePowerUpStatus () {
    _has_bits_[0] |= 1u << 6;
}

inline void DTCTriggeredStatus::clear_has_bDTCTestNotPassedSincePowerUpStatus () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void DTCTriggeredStatus::set_has_bDTCHistoryStatus () {
    _has_bits_[0] |= 1u << 7;
}

inline void DTCTriggeredStatus::clear_has_bDTCHistoryStatus () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void DTCTriggeredStatus::set_has_bDTCTestFailedSinceCodeClearedStatus () {
    _has_bits_[0] |= 1u << 8;
}

inline void DTCTriggeredStatus::clear_has_bDTCTestFailedSinceCodeClearedStatus () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline void DTCTriggeredStatus::set_has_bDTCTestNotPassedSinceCodeClearedStatus () {
    _has_bits_[0] |= 1u << 9;
}

inline void DTCTriggeredStatus::clear_has_bDTCTestNotPassedSinceCodeClearedStatus () {
    _has_bits_[0] &= ~ (1u << 9);
}

inline void DTCTriggeredStatus::set_has_bDTCCurrentStatus () {
    _has_bits_[0] |= 1u << 10;
}

inline void DTCTriggeredStatus::clear_has_bDTCCurrentStatus () {
    _has_bits_[0] &= ~ (1u << 10);
}

inline void DTCTriggeredStatus::set_has_bDTCCodeSupported () {
    _has_bits_[0] |= 1u << 11;
}

inline void DTCTriggeredStatus::clear_has_bDTCCodeSupported () {
    _has_bits_[0] &= ~ (1u << 11);
}

inline void DTCTriggeredStatus::set_has_e8DTCFaultType () {
    _has_bits_[0] |= 1u << 12;
}

inline void DTCTriggeredStatus::clear_has_e8DTCFaultType () {
    _has_bits_[0] &= ~ (1u << 12);
}

inline  SetFactorySettingsNewStart::SetFactorySettingsNewStart ()  :
    _DefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType__CLEAR_ERRMEM),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewStart::SetFactorySettingsNewStart (const SetFactorySettingsNewStart &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType__CLEAR_ERRMEM),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsNewStart::SetFactorySettingsNewStart (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_DiaglogDefsetType_IsValid(DefSetStateGroup_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DiaglogDefsetType", "DefSetStateGroup", "SetFactorySettingsNewStart");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewStart");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewStart::~SetFactorySettingsNewStart() {
}

inline SetFactorySettingsNewStart& SetFactorySettingsNewStart::operator = (const SetFactorySettingsNewStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
    }
    return *this;
}

inline bool SetFactorySettingsNewStart::operator == (const SetFactorySettingsNewStart& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()));
}

inline bool SetFactorySettingsNewStart::operator != (const SetFactorySettingsNewStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsNewStart::operator < (const SetFactorySettingsNewStart& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if ((uint32)getDefSetStateGroup() < (uint32)rhs.getDefSetStateGroup()) return true;
        if ((uint32)getDefSetStateGroup() > (uint32)rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsNewStart::clone() {
    return new SetFactorySettingsNewStart(*this);
}

inline bool SetFactorySettingsNewStart::operator > (const SetFactorySettingsNewStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsNewStart::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
}

inline void SetFactorySettingsNewStart::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType__CLEAR_ERRMEM;
     }
}

inline bool SetFactorySettingsNewStart::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType SetFactorySettingsNewStart::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsNewStart::setDefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_DiaglogDefsetType_IsValid(DefSetStateGroup_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DiaglogDefsetType", "DefSetStateGroup", "SetFactorySettingsNewStart");
    }
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsNewStart::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsNewStart::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsNewStart::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsNewStart::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewStart");
    }
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsNewStart::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsNewStart::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsNewStart::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsNewStart::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SetFactorySettingsNewResult::SetFactorySettingsNewResult ()  :
    _DefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType__CLEAR_ERRMEM),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewResult::SetFactorySettingsNewResult (const SetFactorySettingsNewResult &rhs)  :
    ::asf::core::Payload(rhs),
    _DefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType__CLEAR_ERRMEM),
    _DefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF),
    _DefSetStateSuccessful (false),
    _DefSetStateFirstDifferentParameterId (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetFactorySettingsNewResult::SetFactorySettingsNewResult (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_, ::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_, bool DefSetStateSuccessful_, uint16 DefSetStateFirstDifferentParameterId_)  :
    _DefSetStateGroup (DefSetStateGroup_),
    _DefSetStateMode (DefSetStateMode_),
    _DefSetStateSuccessful (DefSetStateSuccessful_),
    _DefSetStateFirstDifferentParameterId (DefSetStateFirstDifferentParameterId_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_DiaglogDefsetType_IsValid(DefSetStateGroup_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DiaglogDefsetType", "DefSetStateGroup", "SetFactorySettingsNewResult");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewResult");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetFactorySettingsNewResult::~SetFactorySettingsNewResult() {
}

inline SetFactorySettingsNewResult& SetFactorySettingsNewResult::operator = (const SetFactorySettingsNewResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDefSetStateGroup()) {
            setDefSetStateGroup(rhs.getDefSetStateGroup());
        } else {
            clearDefSetStateGroup();
        }
        if (rhs.hasDefSetStateMode()) {
            setDefSetStateMode(rhs.getDefSetStateMode());
        } else {
            clearDefSetStateMode();
        }
        if (rhs.hasDefSetStateSuccessful()) {
            setDefSetStateSuccessful(rhs.getDefSetStateSuccessful());
        } else {
            clearDefSetStateSuccessful();
        }
        if (rhs.hasDefSetStateFirstDifferentParameterId()) {
            setDefSetStateFirstDifferentParameterId(rhs.getDefSetStateFirstDifferentParameterId());
        } else {
            clearDefSetStateFirstDifferentParameterId();
        }
    }
    return *this;
}

inline bool SetFactorySettingsNewResult::operator == (const SetFactorySettingsNewResult& rhs) const {
    return (((!hasDefSetStateGroup() && !rhs.hasDefSetStateGroup()) || getDefSetStateGroup() == rhs.getDefSetStateGroup()) &&
        ((!hasDefSetStateMode() && !rhs.hasDefSetStateMode()) || getDefSetStateMode() == rhs.getDefSetStateMode()) &&
        ((!hasDefSetStateSuccessful() && !rhs.hasDefSetStateSuccessful()) || getDefSetStateSuccessful() == rhs.getDefSetStateSuccessful()) &&
        ((!hasDefSetStateFirstDifferentParameterId() && !rhs.hasDefSetStateFirstDifferentParameterId()) || getDefSetStateFirstDifferentParameterId() == rhs.getDefSetStateFirstDifferentParameterId()));
}

inline bool SetFactorySettingsNewResult::operator != (const SetFactorySettingsNewResult& rhs) const {
    return ! (*this == rhs);
}

inline bool SetFactorySettingsNewResult::operator < (const SetFactorySettingsNewResult& rhs) const {
    if (hasDefSetStateGroup() || rhs.hasDefSetStateGroup()) {
        if ((uint32)getDefSetStateGroup() < (uint32)rhs.getDefSetStateGroup()) return true;
        if ((uint32)getDefSetStateGroup() > (uint32)rhs.getDefSetStateGroup()) return false;
    }
    if (hasDefSetStateMode() || rhs.hasDefSetStateMode()) {
        if ((uint32)getDefSetStateMode() < (uint32)rhs.getDefSetStateMode()) return true;
        if ((uint32)getDefSetStateMode() > (uint32)rhs.getDefSetStateMode()) return false;
    }
    if (hasDefSetStateSuccessful() || rhs.hasDefSetStateSuccessful()) {
        if (getDefSetStateSuccessful() < rhs.getDefSetStateSuccessful()) return true;
        if (getDefSetStateSuccessful() > rhs.getDefSetStateSuccessful()) return false;
    }
    if (hasDefSetStateFirstDifferentParameterId() || rhs.hasDefSetStateFirstDifferentParameterId()) {
        if (getDefSetStateFirstDifferentParameterId() < rhs.getDefSetStateFirstDifferentParameterId()) return true;
        if (getDefSetStateFirstDifferentParameterId() > rhs.getDefSetStateFirstDifferentParameterId()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetFactorySettingsNewResult::clone() {
    return new SetFactorySettingsNewResult(*this);
}

inline bool SetFactorySettingsNewResult::operator > (const SetFactorySettingsNewResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetFactorySettingsNewResult::clear() {
    clearDefSetStateGroup();
    clearDefSetStateMode();
    clearDefSetStateSuccessful();
    clearDefSetStateFirstDifferentParameterId();
}

inline void SetFactorySettingsNewResult::clearDefSetStateGroup() {
    if (hasDefSetStateGroup()) {
         clear_has_DefSetStateGroup();
        _DefSetStateGroup = ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType__CLEAR_ERRMEM;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::midw_diaglog_fi_types::T_e8_DiaglogDefsetType SetFactorySettingsNewResult::getDefSetStateGroup () const {
    return _DefSetStateGroup;
}

inline void SetFactorySettingsNewResult::setDefSetStateGroup (::midw_diaglog_fi_types::T_e8_DiaglogDefsetType DefSetStateGroup_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diaglog_fi_types::T_e8_DiaglogDefsetType_IsValid(DefSetStateGroup_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateGroup_, "T_e8_DiaglogDefsetType", "DefSetStateGroup", "SetFactorySettingsNewResult");
    }
    set_has_DefSetStateGroup();
    this->_DefSetStateGroup = DefSetStateGroup_;
}

inline void SetFactorySettingsNewResult::clearDefSetStateMode() {
    if (hasDefSetStateMode()) {
         clear_has_DefSetStateMode();
        _DefSetStateMode = ::midw_diagnostics_fi_types::T_e8_DefSetMode__DEFSET_SRC_NOT_DEF;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateMode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::midw_diagnostics_fi_types::T_e8_DefSetMode SetFactorySettingsNewResult::getDefSetStateMode () const {
    return _DefSetStateMode;
}

inline void SetFactorySettingsNewResult::setDefSetStateMode (::midw_diagnostics_fi_types::T_e8_DefSetMode DefSetStateMode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(::midw_diagnostics_fi_types::T_e8_DefSetMode_IsValid(DefSetStateMode_), "Invalid value %d for enumeration '%s' in field '%s' of '%s'", DefSetStateMode_, "T_e8_DefSetMode", "DefSetStateMode", "SetFactorySettingsNewResult");
    }
    set_has_DefSetStateMode();
    this->_DefSetStateMode = DefSetStateMode_;
}

inline void SetFactorySettingsNewResult::clearDefSetStateSuccessful() {
    if (hasDefSetStateSuccessful()) {
         clear_has_DefSetStateSuccessful();
        _DefSetStateSuccessful = false;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateSuccessful () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool SetFactorySettingsNewResult::getDefSetStateSuccessful () const {
    return _DefSetStateSuccessful;
}

inline void SetFactorySettingsNewResult::setDefSetStateSuccessful (bool DefSetStateSuccessful_) {
    set_has_DefSetStateSuccessful();
    this->_DefSetStateSuccessful = DefSetStateSuccessful_;
}

inline void SetFactorySettingsNewResult::clearDefSetStateFirstDifferentParameterId() {
    if (hasDefSetStateFirstDifferentParameterId()) {
         clear_has_DefSetStateFirstDifferentParameterId();
        _DefSetStateFirstDifferentParameterId = 0u;
     }
}

inline bool SetFactorySettingsNewResult::hasDefSetStateFirstDifferentParameterId () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint16 SetFactorySettingsNewResult::getDefSetStateFirstDifferentParameterId () const {
    return _DefSetStateFirstDifferentParameterId;
}

inline void SetFactorySettingsNewResult::setDefSetStateFirstDifferentParameterId (uint16 DefSetStateFirstDifferentParameterId_) {
    set_has_DefSetStateFirstDifferentParameterId();
    this->_DefSetStateFirstDifferentParameterId = DefSetStateFirstDifferentParameterId_;
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateGroup () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateGroup () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateMode () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateMode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateSuccessful () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateSuccessful () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SetFactorySettingsNewResult::set_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] |= 1u << 3;
}

inline void SetFactorySettingsNewResult::clear_has_DefSetStateFirstDifferentParameterId () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SendActiveDTCListStatus::SendActiveDTCListStatus ()  :
    _ActiveDTCList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendActiveDTCListStatus::SendActiveDTCListStatus (const SendActiveDTCListStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ActiveDTCList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendActiveDTCListStatus::SendActiveDTCListStatus (const ::midw_diaglog_fi_types::T_ActiveDTCList& ActiveDTCList_)  :
    _ActiveDTCList (ActiveDTCList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendActiveDTCListStatus::~SendActiveDTCListStatus() {
}

inline SendActiveDTCListStatus& SendActiveDTCListStatus::operator = (const SendActiveDTCListStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasActiveDTCList()) {
            setActiveDTCList(rhs.getActiveDTCList());
        } else {
            clearActiveDTCList();
        }
    }
    return *this;
}

inline bool SendActiveDTCListStatus::operator == (const SendActiveDTCListStatus& rhs) const {
    return (((!hasActiveDTCList() && !rhs.hasActiveDTCList()) || getActiveDTCList() == rhs.getActiveDTCList()));
}

inline bool SendActiveDTCListStatus::operator != (const SendActiveDTCListStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SendActiveDTCListStatus::operator < (const SendActiveDTCListStatus& rhs) const {
    if (hasActiveDTCList() || rhs.hasActiveDTCList()) {
        if (getActiveDTCList() < rhs.getActiveDTCList()) return true;
        if (getActiveDTCList() > rhs.getActiveDTCList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendActiveDTCListStatus::clone() {
    return new SendActiveDTCListStatus(*this);
}

inline bool SendActiveDTCListStatus::operator > (const SendActiveDTCListStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendActiveDTCListStatus::clear() {
    clearActiveDTCList();
}

inline void SendActiveDTCListStatus::clearActiveDTCList() {
    if (hasActiveDTCList()) {
         clear_has_ActiveDTCList();
        _ActiveDTCList.clear();
     }
}

inline bool SendActiveDTCListStatus::hasActiveDTCList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ActiveDTCList& SendActiveDTCListStatus::getActiveDTCList () const {
    return _ActiveDTCList;
}

inline ::midw_diaglog_fi_types::T_ActiveDTCList& SendActiveDTCListStatus::getActiveDTCListMutable () {
    set_has_ActiveDTCList();
    return _ActiveDTCList;
}

inline void SendActiveDTCListStatus::setActiveDTCList (const ::midw_diaglog_fi_types::T_ActiveDTCList& ActiveDTCList_) {
    set_has_ActiveDTCList();
    this->_ActiveDTCList = ActiveDTCList_;
}

inline void SendActiveDTCListStatus::set_has_ActiveDTCList () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendActiveDTCListStatus::clear_has_ActiveDTCList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DtcStatusChangedStatus::DtcStatusChangedStatus ()  :
    _DTCResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DtcStatusChangedStatus::DtcStatusChangedStatus (const DtcStatusChangedStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _DTCResponse ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DtcStatusChangedStatus::DtcStatusChangedStatus (const ::midw_diaglog_fi_types::T_ReadResultStructure& DTCResponse_)  :
    _DTCResponse (DTCResponse_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DtcStatusChangedStatus::~DtcStatusChangedStatus() {
}

inline DtcStatusChangedStatus& DtcStatusChangedStatus::operator = (const DtcStatusChangedStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDTCResponse()) {
            setDTCResponse(rhs.getDTCResponse());
        } else {
            clearDTCResponse();
        }
    }
    return *this;
}

inline bool DtcStatusChangedStatus::operator == (const DtcStatusChangedStatus& rhs) const {
    return (((!hasDTCResponse() && !rhs.hasDTCResponse()) || getDTCResponse() == rhs.getDTCResponse()));
}

inline bool DtcStatusChangedStatus::operator != (const DtcStatusChangedStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool DtcStatusChangedStatus::operator < (const DtcStatusChangedStatus& rhs) const {
    if (hasDTCResponse() || rhs.hasDTCResponse()) {
        if (getDTCResponse() < rhs.getDTCResponse()) return true;
        if (getDTCResponse() > rhs.getDTCResponse()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DtcStatusChangedStatus::clone() {
    return new DtcStatusChangedStatus(*this);
}

inline bool DtcStatusChangedStatus::operator > (const DtcStatusChangedStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DtcStatusChangedStatus::clear() {
    clearDTCResponse();
}

inline void DtcStatusChangedStatus::clearDTCResponse() {
    if (hasDTCResponse()) {
         clear_has_DTCResponse();
        _DTCResponse.clear();
     }
}

inline bool DtcStatusChangedStatus::hasDTCResponse () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::midw_diaglog_fi_types::T_ReadResultStructure& DtcStatusChangedStatus::getDTCResponse () const {
    return _DTCResponse;
}

inline ::midw_diaglog_fi_types::T_ReadResultStructure& DtcStatusChangedStatus::getDTCResponseMutable () {
    set_has_DTCResponse();
    return _DTCResponse;
}

inline void DtcStatusChangedStatus::setDTCResponse (const ::midw_diaglog_fi_types::T_ReadResultStructure& DTCResponse_) {
    set_has_DTCResponse();
    this->_DTCResponse = DTCResponse_;
}

inline void DtcStatusChangedStatus::set_has_DTCResponse () {
    _has_bits_[0] |= 1u << 0;
}

inline void DtcStatusChangedStatus::clear_has_DTCResponse () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DtcStatusChangedUpReg::DtcStatusChangedUpReg ()  :
    _Group (0u),
    _DTCNumber (0u),
    _DTCStatusBitMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DtcStatusChangedUpReg::DtcStatusChangedUpReg (const DtcStatusChangedUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _DTCNumber (0u),
    _DTCStatusBitMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DtcStatusChangedUpReg::DtcStatusChangedUpReg (uint8 Group_, uint32 DTCNumber_, uint8 DTCStatusBitMask_)  :
    _Group (Group_),
    _DTCNumber (DTCNumber_),
    _DTCStatusBitMask (DTCStatusBitMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DtcStatusChangedUpReg::~DtcStatusChangedUpReg() {
}

inline DtcStatusChangedUpReg& DtcStatusChangedUpReg::operator = (const DtcStatusChangedUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasDTCNumber()) {
            setDTCNumber(rhs.getDTCNumber());
        } else {
            clearDTCNumber();
        }
        if (rhs.hasDTCStatusBitMask()) {
            setDTCStatusBitMask(rhs.getDTCStatusBitMask());
        } else {
            clearDTCStatusBitMask();
        }
    }
    return *this;
}

inline bool DtcStatusChangedUpReg::operator == (const DtcStatusChangedUpReg& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasDTCNumber() && !rhs.hasDTCNumber()) || getDTCNumber() == rhs.getDTCNumber()) &&
        ((!hasDTCStatusBitMask() && !rhs.hasDTCStatusBitMask()) || getDTCStatusBitMask() == rhs.getDTCStatusBitMask()));
}

inline bool DtcStatusChangedUpReg::operator != (const DtcStatusChangedUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool DtcStatusChangedUpReg::operator < (const DtcStatusChangedUpReg& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasDTCNumber() || rhs.hasDTCNumber()) {
        if (getDTCNumber() < rhs.getDTCNumber()) return true;
        if (getDTCNumber() > rhs.getDTCNumber()) return false;
    }
    if (hasDTCStatusBitMask() || rhs.hasDTCStatusBitMask()) {
        if (getDTCStatusBitMask() < rhs.getDTCStatusBitMask()) return true;
        if (getDTCStatusBitMask() > rhs.getDTCStatusBitMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DtcStatusChangedUpReg::clone() {
    return new DtcStatusChangedUpReg(*this);
}

inline bool DtcStatusChangedUpReg::operator > (const DtcStatusChangedUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DtcStatusChangedUpReg::clear() {
    clearGroup();
    clearDTCNumber();
    clearDTCStatusBitMask();
}

inline void DtcStatusChangedUpReg::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool DtcStatusChangedUpReg::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DtcStatusChangedUpReg::getGroup () const {
    return _Group;
}

inline void DtcStatusChangedUpReg::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void DtcStatusChangedUpReg::clearDTCNumber() {
    if (hasDTCNumber()) {
         clear_has_DTCNumber();
        _DTCNumber = 0u;
     }
}

inline bool DtcStatusChangedUpReg::hasDTCNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DtcStatusChangedUpReg::getDTCNumber () const {
    return _DTCNumber;
}

inline void DtcStatusChangedUpReg::setDTCNumber (uint32 DTCNumber_) {
    set_has_DTCNumber();
    this->_DTCNumber = DTCNumber_;
}

inline void DtcStatusChangedUpReg::clearDTCStatusBitMask() {
    if (hasDTCStatusBitMask()) {
         clear_has_DTCStatusBitMask();
        _DTCStatusBitMask = 0u;
     }
}

inline bool DtcStatusChangedUpReg::hasDTCStatusBitMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DtcStatusChangedUpReg::getDTCStatusBitMask () const {
    return _DTCStatusBitMask;
}

inline void DtcStatusChangedUpReg::setDTCStatusBitMask (uint8 DTCStatusBitMask_) {
    set_has_DTCStatusBitMask();
    this->_DTCStatusBitMask = DTCStatusBitMask_;
}

inline void DtcStatusChangedUpReg::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void DtcStatusChangedUpReg::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DtcStatusChangedUpReg::set_has_DTCNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void DtcStatusChangedUpReg::clear_has_DTCNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DtcStatusChangedUpReg::set_has_DTCStatusBitMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void DtcStatusChangedUpReg::clear_has_DTCStatusBitMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  DtcStatusChangedRelUpReg::DtcStatusChangedRelUpReg ()  :
    _Group (0u),
    _DTCNumber (0u),
    _DTCStatusBitMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DtcStatusChangedRelUpReg::DtcStatusChangedRelUpReg (const DtcStatusChangedRelUpReg &rhs)  :
    ::asf::core::Payload(rhs),
    _Group (0u),
    _DTCNumber (0u),
    _DTCStatusBitMask (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DtcStatusChangedRelUpReg::DtcStatusChangedRelUpReg (uint8 Group_, uint32 DTCNumber_, uint8 DTCStatusBitMask_)  :
    _Group (Group_),
    _DTCNumber (DTCNumber_),
    _DTCStatusBitMask (DTCStatusBitMask_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DtcStatusChangedRelUpReg::~DtcStatusChangedRelUpReg() {
}

inline DtcStatusChangedRelUpReg& DtcStatusChangedRelUpReg::operator = (const DtcStatusChangedRelUpReg& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasGroup()) {
            setGroup(rhs.getGroup());
        } else {
            clearGroup();
        }
        if (rhs.hasDTCNumber()) {
            setDTCNumber(rhs.getDTCNumber());
        } else {
            clearDTCNumber();
        }
        if (rhs.hasDTCStatusBitMask()) {
            setDTCStatusBitMask(rhs.getDTCStatusBitMask());
        } else {
            clearDTCStatusBitMask();
        }
    }
    return *this;
}

inline bool DtcStatusChangedRelUpReg::operator == (const DtcStatusChangedRelUpReg& rhs) const {
    return (((!hasGroup() && !rhs.hasGroup()) || getGroup() == rhs.getGroup()) &&
        ((!hasDTCNumber() && !rhs.hasDTCNumber()) || getDTCNumber() == rhs.getDTCNumber()) &&
        ((!hasDTCStatusBitMask() && !rhs.hasDTCStatusBitMask()) || getDTCStatusBitMask() == rhs.getDTCStatusBitMask()));
}

inline bool DtcStatusChangedRelUpReg::operator != (const DtcStatusChangedRelUpReg& rhs) const {
    return ! (*this == rhs);
}

inline bool DtcStatusChangedRelUpReg::operator < (const DtcStatusChangedRelUpReg& rhs) const {
    if (hasGroup() || rhs.hasGroup()) {
        if (getGroup() < rhs.getGroup()) return true;
        if (getGroup() > rhs.getGroup()) return false;
    }
    if (hasDTCNumber() || rhs.hasDTCNumber()) {
        if (getDTCNumber() < rhs.getDTCNumber()) return true;
        if (getDTCNumber() > rhs.getDTCNumber()) return false;
    }
    if (hasDTCStatusBitMask() || rhs.hasDTCStatusBitMask()) {
        if (getDTCStatusBitMask() < rhs.getDTCStatusBitMask()) return true;
        if (getDTCStatusBitMask() > rhs.getDTCStatusBitMask()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DtcStatusChangedRelUpReg::clone() {
    return new DtcStatusChangedRelUpReg(*this);
}

inline bool DtcStatusChangedRelUpReg::operator > (const DtcStatusChangedRelUpReg& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DtcStatusChangedRelUpReg::clear() {
    clearGroup();
    clearDTCNumber();
    clearDTCStatusBitMask();
}

inline void DtcStatusChangedRelUpReg::clearGroup() {
    if (hasGroup()) {
         clear_has_Group();
        _Group = 0u;
     }
}

inline bool DtcStatusChangedRelUpReg::hasGroup () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 DtcStatusChangedRelUpReg::getGroup () const {
    return _Group;
}

inline void DtcStatusChangedRelUpReg::setGroup (uint8 Group_) {
    set_has_Group();
    this->_Group = Group_;
}

inline void DtcStatusChangedRelUpReg::clearDTCNumber() {
    if (hasDTCNumber()) {
         clear_has_DTCNumber();
        _DTCNumber = 0u;
     }
}

inline bool DtcStatusChangedRelUpReg::hasDTCNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DtcStatusChangedRelUpReg::getDTCNumber () const {
    return _DTCNumber;
}

inline void DtcStatusChangedRelUpReg::setDTCNumber (uint32 DTCNumber_) {
    set_has_DTCNumber();
    this->_DTCNumber = DTCNumber_;
}

inline void DtcStatusChangedRelUpReg::clearDTCStatusBitMask() {
    if (hasDTCStatusBitMask()) {
         clear_has_DTCStatusBitMask();
        _DTCStatusBitMask = 0u;
     }
}

inline bool DtcStatusChangedRelUpReg::hasDTCStatusBitMask () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DtcStatusChangedRelUpReg::getDTCStatusBitMask () const {
    return _DTCStatusBitMask;
}

inline void DtcStatusChangedRelUpReg::setDTCStatusBitMask (uint8 DTCStatusBitMask_) {
    set_has_DTCStatusBitMask();
    this->_DTCStatusBitMask = DTCStatusBitMask_;
}

inline void DtcStatusChangedRelUpReg::set_has_Group () {
    _has_bits_[0] |= 1u << 0;
}

inline void DtcStatusChangedRelUpReg::clear_has_Group () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DtcStatusChangedRelUpReg::set_has_DTCNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void DtcStatusChangedRelUpReg::clear_has_DTCNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DtcStatusChangedRelUpReg::set_has_DTCStatusBitMask () {
    _has_bits_[0] |= 1u << 2;
}

inline void DtcStatusChangedRelUpReg::clear_has_DTCStatusBitMask () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace Midw_DiagLog_FI

#endif // MIDW_DIAGLOG_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
