/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/DataServices.h"
#include "org/bosch/cm/DataServicesDBus.h"
#include "org/bosch/cm/DataServicesJson.h"
#include "org/bosch/cm/DataServicesProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bosch {
namespace cm {
namespace DataServices {

DEFINE_CLASS_LOGGER("/org/bosch/cm/org/bosch/cm/DataServices", DataServicesProxy);

class DataServicesProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DataServicesProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DataServicesProxy >& proxyShared = ::boost::static_pointer_cast< DataServicesProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_FID_G_LOGOLIST:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_G_LOGOLISTSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FID_G_LOGOLIST", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FID_G_LOGOLISTSignal> payload = ::boost::static_pointer_cast<FID_G_LOGOLISTSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FID_G_LOGOLISTCallbackIF*) _callback)->onFID_G_LOGOLISTSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FID_G_LOGO:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_G_LOGOSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FID_G_LOGO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FID_G_LOGOSignal> payload = ::boost::static_pointer_cast<FID_G_LOGOSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FID_G_LOGOCallbackIF*) _callback)->onFID_G_LOGOSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FID_G_SLIDE:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_G_SLIDESignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FID_G_SLIDE", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FID_G_SLIDESignal> payload = ::boost::static_pointer_cast<FID_G_SLIDESignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FID_G_SLIDECallbackIF*) _callback)->onFID_G_SLIDESignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FID_G_USERAPP_STATUS:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_G_USERAPP_STATUSSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FID_G_USERAPP_STATUS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FID_G_USERAPP_STATUSSignal> payload = ::boost::static_pointer_cast<FID_G_USERAPP_STATUSSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FID_G_USERAPP_STATUSCallbackIF*) _callback)->onFID_G_USERAPP_STATUSSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FID_DAB_S_GET_USERAPP_EPG:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_S_GET_USERAPP_EPGError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_S_GET_USERAPP_EPG", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_S_GET_USERAPP_EPGError> payload = ::boost::static_pointer_cast<FID_DAB_S_GET_USERAPP_EPGError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_S_GET_USERAPP_EPGCallbackIF*) _callback)->onFID_DAB_S_GET_USERAPP_EPGError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_S_GET_USERAPP_EPGResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_S_GET_USERAPP_EPG", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_S_GET_USERAPP_EPGResponse> payload = ::boost::static_pointer_cast<FID_DAB_S_GET_USERAPP_EPGResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_S_GET_USERAPP_EPGCallbackIF*) _callback)->onFID_DAB_S_GET_USERAPP_EPGResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_FID_DAB_S_ENABLE_USERAPP:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_S_ENABLE_USERAPPError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_S_ENABLE_USERAPP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_S_ENABLE_USERAPPError> payload = ::boost::static_pointer_cast<FID_DAB_S_ENABLE_USERAPPError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_S_ENABLE_USERAPPCallbackIF*) _callback)->onFID_DAB_S_ENABLE_USERAPPError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_S_ENABLE_USERAPPResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_S_ENABLE_USERAPP", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_S_ENABLE_USERAPPResponse> payload = ::boost::static_pointer_cast<FID_DAB_S_ENABLE_USERAPPResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_S_ENABLE_USERAPPCallbackIF*) _callback)->onFID_DAB_S_ENABLE_USERAPPResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_FID_DAB_GET_LOGOLIST:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_GET_LOGOLISTError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_GET_LOGOLIST", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_GET_LOGOLISTError> payload = ::boost::static_pointer_cast<FID_DAB_GET_LOGOLISTError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_GET_LOGOLISTCallbackIF*) _callback)->onFID_DAB_GET_LOGOLISTError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_GET_LOGOLISTResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_GET_LOGOLIST", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_GET_LOGOLISTResponse> payload = ::boost::static_pointer_cast<FID_DAB_GET_LOGOLISTResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_GET_LOGOLISTCallbackIF*) _callback)->onFID_DAB_GET_LOGOLISTResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_FID_DAB_GET_LOGO:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_GET_LOGOError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_GET_LOGO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_GET_LOGOError> payload = ::boost::static_pointer_cast<FID_DAB_GET_LOGOError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_GET_LOGOCallbackIF*) _callback)->onFID_DAB_GET_LOGOError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FID_DAB_GET_LOGOResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "FID_DAB_GET_LOGO", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FID_DAB_GET_LOGOResponse> payload = ::boost::static_pointer_cast<FID_DAB_GET_LOGOResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((FID_DAB_GET_LOGOCallbackIF*) _callback)->onFID_DAB_GET_LOGOResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_FID_G_LOGOLIST: {
                ::boost::shared_ptr< FID_G_LOGOLISTError > payload = ::boost::shared_ptr< FID_G_LOGOLISTError >
                (new FID_G_LOGOLISTError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_G_LOGOLIST", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_G_LOGOLISTCallbackIF*) _callback)->onFID_G_LOGOLISTError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_G_LOGO: {
                ::boost::shared_ptr< FID_G_LOGOError > payload = ::boost::shared_ptr< FID_G_LOGOError >
                (new FID_G_LOGOError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_G_LOGO", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_G_LOGOCallbackIF*) _callback)->onFID_G_LOGOError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_G_SLIDE: {
                ::boost::shared_ptr< FID_G_SLIDEError > payload = ::boost::shared_ptr< FID_G_SLIDEError >
                (new FID_G_SLIDEError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_G_SLIDE", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_G_SLIDECallbackIF*) _callback)->onFID_G_SLIDEError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_G_USERAPP_STATUS: {
                ::boost::shared_ptr< FID_G_USERAPP_STATUSError > payload = ::boost::shared_ptr< FID_G_USERAPP_STATUSError >
                (new FID_G_USERAPP_STATUSError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_G_USERAPP_STATUS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_G_USERAPP_STATUSCallbackIF*) _callback)->onFID_G_USERAPP_STATUSError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_DAB_S_GET_USERAPP_EPG: {
                ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGError > payload = ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGError >
                (new FID_DAB_S_GET_USERAPP_EPGError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_DAB_S_GET_USERAPP_EPG", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_DAB_S_GET_USERAPP_EPGCallbackIF*) _callback)->onFID_DAB_S_GET_USERAPP_EPGError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_DAB_S_ENABLE_USERAPP: {
                ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPError > payload = ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPError >
                (new FID_DAB_S_ENABLE_USERAPPError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_DAB_S_ENABLE_USERAPP", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_DAB_S_ENABLE_USERAPPCallbackIF*) _callback)->onFID_DAB_S_ENABLE_USERAPPError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_DAB_GET_LOGOLIST: {
                ::boost::shared_ptr< FID_DAB_GET_LOGOLISTError > payload = ::boost::shared_ptr< FID_DAB_GET_LOGOLISTError >
                (new FID_DAB_GET_LOGOLISTError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_DAB_GET_LOGOLIST", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_DAB_GET_LOGOLISTCallbackIF*) _callback)->onFID_DAB_GET_LOGOLISTError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FID_DAB_GET_LOGO: {
                ::boost::shared_ptr< FID_DAB_GET_LOGOError > payload = ::boost::shared_ptr< FID_DAB_GET_LOGOError >
                (new FID_DAB_GET_LOGOError(DBUS_ERROR_NO_SERVER, "The DBus service DataServices is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FID_DAB_GET_LOGO", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DataServicesProxy> proxyShared = ::boost::static_pointer_cast<DataServicesProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FID_DAB_GET_LOGOCallbackIF*) _callback)->onFID_DAB_GET_LOGOError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DataServicesProxyCallback::_logger (DataServicesProxy::_logger);

DataServicesProxy::DataServicesProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bosch.cm.DataServices", serviceAvailable, _logger) {
}

DataServicesProxy::~DataServicesProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DataServicesProxy > DataServicesProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DataServicesProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DataServicesProxy > proxyNew(new DataServicesProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DataServicesProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DataServicesProxyCallback* callback = new DataServicesProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DataServicesProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DataServicesProxyCallback* callback = new DataServicesProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void DataServicesProxy::sendDeregisterAll () const
{
    sendFID_G_LOGOLISTDeregisterAll();
    sendFID_G_LOGODeregisterAll();
    sendFID_G_SLIDEDeregisterAll();
    sendFID_G_USERAPP_STATUSDeregisterAll();
}

act_t DataServicesProxy::sendFID_G_LOGOLISTRegister(FID_G_LOGOLISTCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FID_G_LOGOLIST");
    act_t act = addSignalCallback(ID_FID_G_LOGOLIST, "FID_G_LOGOLIST", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FID_G_LOGOLIST", &cb, act);
    return act;
}

bool DataServicesProxy::sendFID_G_LOGOLISTDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FID_G_LOGOLIST", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FID_G_LOGOLIST", act, static_cast<int>(rv));
    return rv;
}

void DataServicesProxy::sendFID_G_LOGOLISTDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FID_G_LOGOLIST");
    _dbusProxyDelegate->deregisterSignalCallback("FID_G_LOGOLIST", 0, _dbusDaemonProxy.get(), false);
}

act_t DataServicesProxy::sendFID_G_LOGORegister(FID_G_LOGOCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FID_G_LOGO");
    act_t act = addSignalCallback(ID_FID_G_LOGO, "FID_G_LOGO", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FID_G_LOGO", &cb, act);
    return act;
}

bool DataServicesProxy::sendFID_G_LOGODeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FID_G_LOGO", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FID_G_LOGO", act, static_cast<int>(rv));
    return rv;
}

void DataServicesProxy::sendFID_G_LOGODeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FID_G_LOGO");
    _dbusProxyDelegate->deregisterSignalCallback("FID_G_LOGO", 0, _dbusDaemonProxy.get(), false);
}

act_t DataServicesProxy::sendFID_G_SLIDERegister(FID_G_SLIDECallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FID_G_SLIDE");
    act_t act = addSignalCallback(ID_FID_G_SLIDE, "FID_G_SLIDE", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FID_G_SLIDE", &cb, act);
    return act;
}

bool DataServicesProxy::sendFID_G_SLIDEDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FID_G_SLIDE", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FID_G_SLIDE", act, static_cast<int>(rv));
    return rv;
}

void DataServicesProxy::sendFID_G_SLIDEDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FID_G_SLIDE");
    _dbusProxyDelegate->deregisterSignalCallback("FID_G_SLIDE", 0, _dbusDaemonProxy.get(), false);
}

act_t DataServicesProxy::sendFID_G_USERAPP_STATUSRegister(FID_G_USERAPP_STATUSCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FID_G_USERAPP_STATUS");
    act_t act = addSignalCallback(ID_FID_G_USERAPP_STATUS, "FID_G_USERAPP_STATUS", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FID_G_USERAPP_STATUS", &cb, act);
    return act;
}

bool DataServicesProxy::sendFID_G_USERAPP_STATUSDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FID_G_USERAPP_STATUS", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FID_G_USERAPP_STATUS", act, static_cast<int>(rv));
    return rv;
}

void DataServicesProxy::sendFID_G_USERAPP_STATUSDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FID_G_USERAPP_STATUS");
    _dbusProxyDelegate->deregisterSignalCallback("FID_G_USERAPP_STATUS", 0, _dbusDaemonProxy.get(), false);
}

act_t DataServicesProxy::sendFID_DAB_S_GET_USERAPP_EPGRequest(FID_DAB_S_GET_USERAPP_EPGCallbackIF& cb, uint32 e8EPGInfoType, uint32 u32ServiceId, const FID_DAB_S_GET_USERAPP_EPGRequestRScheduleInfoConfigStruct& rScheduleInfoConfig) const {
    FID_DAB_S_GET_USERAPP_EPGRequest* payload = new FID_DAB_S_GET_USERAPP_EPGRequest();
    CHECK_ALLOCATION(payload);
    payload->setE8EPGInfoType(e8EPGInfoType);
    payload->setU32ServiceId(u32ServiceId);
    payload->setRScheduleInfoConfig(rScheduleInfoConfig);
    DBUS_MESSAGE_CALL(dbusMessage, "FID_DAB_S_GET_USERAPP_EPG", FID_DAB_S_GET_USERAPP_EPGRequest, payload, true)
    act_t act = addMethodCallback(ID_FID_DAB_S_GET_USERAPP_EPG, dbusMessage.getUniqueSerial(), "FID_DAB_S_GET_USERAPP_EPG", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "FID_DAB_S_GET_USERAPP_EPG", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DataServicesProxy::sendFID_DAB_S_ENABLE_USERAPPRequest(FID_DAB_S_ENABLE_USERAPPCallbackIF& cb, uint32 e8UserApp, bool bEnable) const {
    FID_DAB_S_ENABLE_USERAPPRequest* payload = new FID_DAB_S_ENABLE_USERAPPRequest();
    CHECK_ALLOCATION(payload);
    payload->setE8UserApp(e8UserApp);
    payload->setBEnable(bEnable);
    DBUS_MESSAGE_CALL(dbusMessage, "FID_DAB_S_ENABLE_USERAPP", FID_DAB_S_ENABLE_USERAPPRequest, payload, true)
    act_t act = addMethodCallback(ID_FID_DAB_S_ENABLE_USERAPP, dbusMessage.getUniqueSerial(), "FID_DAB_S_ENABLE_USERAPP", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "FID_DAB_S_ENABLE_USERAPP", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DataServicesProxy::sendFID_DAB_GET_LOGOLISTRequest(FID_DAB_GET_LOGOLISTCallbackIF& cb, uint32 e8LogoListType, uint32 u8LogoType) const {
    FID_DAB_GET_LOGOLISTRequest* payload = new FID_DAB_GET_LOGOLISTRequest();
    CHECK_ALLOCATION(payload);
    payload->setE8LogoListType(e8LogoListType);
    payload->setU8LogoType(u8LogoType);
    DBUS_MESSAGE_CALL(dbusMessage, "FID_DAB_GET_LOGOLIST", FID_DAB_GET_LOGOLISTRequest, payload, true)
    act_t act = addMethodCallback(ID_FID_DAB_GET_LOGOLIST, dbusMessage.getUniqueSerial(), "FID_DAB_GET_LOGOLIST", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "FID_DAB_GET_LOGOLIST", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DataServicesProxy::sendFID_DAB_GET_LOGORequest(FID_DAB_GET_LOGOCallbackIF& cb, uint32 e8LogoListType, uint32 u8LogoType, uint32 u32ServiceId) const {
    FID_DAB_GET_LOGORequest* payload = new FID_DAB_GET_LOGORequest();
    CHECK_ALLOCATION(payload);
    payload->setE8LogoListType(e8LogoListType);
    payload->setU8LogoType(u8LogoType);
    payload->setU32ServiceId(u32ServiceId);
    DBUS_MESSAGE_CALL(dbusMessage, "FID_DAB_GET_LOGO", FID_DAB_GET_LOGORequest, payload, true)
    act_t act = addMethodCallback(ID_FID_DAB_GET_LOGO, dbusMessage.getUniqueSerial(), "FID_DAB_GET_LOGO", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "FID_DAB_GET_LOGO", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DataServices
} // namespace cm
} // namespace bosch
} // namespace org
