/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "datacollector_main_fi_types.h"
#include "datacollector_main_fi_typesConst.h"
#include "datacollector_main_fi_typesJson.h"
#include "datacollector_main_fi_typesJsonPrivate.h"
#include "yajl/yajl_gen.h"
#include <cstddef>
#include <cstring>
#include <string>

using namespace ::asf::stream::json;


// Json serialization of "T_datacollector_VersionInfo"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_VersionInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Upper()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Upper" , 7);
        yajl_gen_integer(g, (long long)value.getU8Upper());
    }
    if (!isSparse || value.hasU8Mid()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Mid" , 5);
        yajl_gen_integer(g, (long long)value.getU8Mid());
    }
    if (!isSparse || value.hasU8Lower()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Lower" , 7);
        yajl_gen_integer(g, (long long)value.getU8Lower());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_VersionInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_UnitConnectionStatus"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8UnitType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8UnitType" , 10);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_UnitType_Name(value.getE8UnitType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8UnitType());
    }
    if (!isSparse || value.hasBConnected()) {
        yajl_gen_string(g, (const unsigned char*)  "bConnected" , 10);
        yajl_gen_bool(g, (bool)value.getBConnected());
    }
    if (!isSparse || value.hasU8AbsenceState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8AbsenceState" , 14);
        yajl_gen_integer(g, (long long)value.getU8AbsenceState());
    }
    if (!isSparse || value.hasU8MuteState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8MuteState" , 11);
        yajl_gen_integer(g, (long long)value.getU8MuteState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_UnitConfiguration"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitConfiguration& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8UnitType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8UnitType" , 10);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_UnitType_Name(value.getE8UnitType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8UnitType());
    }
    if (!isSparse || value.hasE8ConfigurationStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "e8ConfigurationStatus" , 21);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_ConfigurationStatus_Name(value.getE8ConfigurationStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8ConfigurationStatus());
    }
    if (!isSparse || value.hasU8UnitId()) {
        yajl_gen_string(g, (const unsigned char*)  "u8UnitId" , 8);
        yajl_gen_integer(g, (long long)value.getU8UnitId());
    }
    if (!isSparse || value.hasRMessageVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "rMessageVersion" , 15);
        serializeJson(value.getRMessageVersion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitConfiguration& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_UnitVersion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitVersion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8UnitType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8UnitType" , 10);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_UnitType_Name(value.getE8UnitType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8UnitType());
    }
    if (!isSparse || value.hasRVersion()) {
        yajl_gen_string(g, (const unsigned char*)  "rVersion" , 8);
        serializeJson(value.getRVersion(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitVersion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_UnitDataTransmissionStatus"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8UnitType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8UnitType" , 10);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_UnitType_Name(value.getE8UnitType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8UnitType());
    }
    if (!isSparse || value.hasU8MPDTMuteState()) {
        yajl_gen_string(g, (const unsigned char*)  "u8MPDTMuteState" , 15);
        yajl_gen_integer(g, (long long)value.getU8MPDTMuteState());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_NoData"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_NoData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_NoData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_RadioLabel"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioLabel& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Type" , 6);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioLabelType_Name(value.getE8Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Type());
    }
    if (!isSparse || value.hasU8Id()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Id" , 4);
        yajl_gen_integer(g, (long long)value.getU8Id());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioLabel& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_RadioFrequency"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioFrequency& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasU8Thousands()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Thousands" , 11);
        yajl_gen_integer(g, (long long)value.getU8Thousands());
    }
    if (!isSparse || value.hasU8Hundreds()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hundreds" , 10);
        yajl_gen_integer(g, (long long)value.getU8Hundreds());
    }
    if (!isSparse || value.hasU8Tens()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Tens" , 6);
        yajl_gen_integer(g, (long long)value.getU8Tens());
    }
    if (!isSparse || value.hasU8Ones()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Ones" , 6);
        yajl_gen_integer(g, (long long)value.getU8Ones());
    }
    if (!isSparse || value.hasBShowDecimalPoint()) {
        yajl_gen_string(g, (const unsigned char*)  "bShowDecimalPoint" , 17);
        yajl_gen_bool(g, (bool)value.getBShowDecimalPoint());
    }
    if (!isSparse || value.hasU8Tenths()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Tenths" , 8);
        yajl_gen_integer(g, (long long)value.getU8Tenths());
    }
    if (!isSparse || value.hasU8Hundredths()) {
        yajl_gen_string(g, (const unsigned char*)  "u8Hundredths" , 12);
        yajl_gen_integer(g, (long long)value.getU8Hundredths());
    }
    if (!isSparse || value.hasE8Unit()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Unit" , 6);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit_Name(value.getE8Unit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Unit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioFrequency& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_RadioCategory"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioCategory& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8Type()) {
        yajl_gen_string(g, (const unsigned char*)  "e8Type" , 6);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioCategoryType_Name(value.getE8Type());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8Type());
    }
    if (!isSparse || value.hasStrCategoryName()) {
        yajl_gen_string(g, (const unsigned char*)  "strCategoryName" , 15);
        const char *s = value.getStrCategoryName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioCategory& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_RadioData"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8RadioSource()) {
        yajl_gen_string(g, (const unsigned char*)  "e8RadioSource" , 13);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioSource_Name(value.getE8RadioSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8RadioSource());
    }
    if (!isSparse || value.hasRLabel()) {
        yajl_gen_string(g, (const unsigned char*)  "rLabel" , 6);
        serializeJson(value.getRLabel(), g, options);
    }
    if (!isSparse || value.hasRFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "rFrequency" , 10);
        serializeJson(value.getRFrequency(), g, options);
    }
    if (!isSparse || value.hasRCategory()) {
        yajl_gen_string(g, (const unsigned char*)  "rCategory" , 9);
        serializeJson(value.getRCategory(), g, options);
    }
    if (!isSparse || value.hasStrStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "strStationName" , 14);
        const char *s = value.getStrStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_RadioData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_TrackInfo"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_TrackInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8LabelType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LabelType" , 11);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_TrackLabelType_Name(value.getE8LabelType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LabelType());
    }
    if (!isSparse || value.hasU32TrackNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u32TrackNumber" , 14);
        yajl_gen_integer(g, (long long)value.getU32TrackNumber());
    }
    if (!isSparse || value.hasStrTrackName()) {
        yajl_gen_string(g, (const unsigned char*)  "strTrackName" , 12);
        const char *s = value.getStrTrackName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_TrackInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_GroupInfo"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_GroupInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8LabelType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LabelType" , 11);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_GroupLabelType_Name(value.getE8LabelType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LabelType());
    }
    if (!isSparse || value.hasU16GroupNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "u16GroupNumber" , 14);
        yajl_gen_integer(g, (long long)value.getU16GroupNumber());
    }
    if (!isSparse || value.hasStrGroupName()) {
        yajl_gen_string(g, (const unsigned char*)  "strGroupName" , 12);
        const char *s = value.getStrGroupName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_GroupInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_ArtistInfo"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_ArtistInfo& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8LabelType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8LabelType" , 11);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_ArtistLabelType_Name(value.getE8LabelType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8LabelType());
    }
    if (!isSparse || value.hasStrArtistName()) {
        yajl_gen_string(g, (const unsigned char*)  "strArtistName" , 13);
        const char *s = value.getStrArtistName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_ArtistInfo& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_MediaData"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_MediaData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8MediaType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8MediaType" , 11);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaType_Name(value.getE8MediaType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8MediaType());
    }
    if (!isSparse || value.hasRTrackInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rTrackInfo" , 10);
        serializeJson(value.getRTrackInfo(), g, options);
    }
    if (!isSparse || value.hasRGroupInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rGroupInfo" , 10);
        serializeJson(value.getRGroupInfo(), g, options);
    }
    if (!isSparse || value.hasRArtistInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rArtistInfo" , 11);
        serializeJson(value.getRArtistInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_MediaData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_AuxData"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_AuxData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasE8AuxType()) {
        yajl_gen_string(g, (const unsigned char*)  "e8AuxType" , 9);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_AuxType_Name(value.getE8AuxType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getE8AuxType());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_AuxData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_ExternalSoundData"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_ExternalSoundData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_ExternalSoundData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_InternetRadioData"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_InternetRadioData& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasStrSourceName()) {
        yajl_gen_string(g, (const unsigned char*)  "strSourceName" , 13);
        const char *s = value.getStrSourceName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasRTrackInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rTrackInfo" , 10);
        serializeJson(value.getRTrackInfo(), g, options);
    }
    if (!isSparse || value.hasRGroupInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rGroupInfo" , 10);
        serializeJson(value.getRGroupInfo(), g, options);
    }
    if (!isSparse || value.hasRArtistInfo()) {
        yajl_gen_string(g, (const unsigned char*)  "rArtistInfo" , 11);
        serializeJson(value.getRArtistInfo(), g, options);
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_InternetRadioData& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_Audio_SourceInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    switch (value.getField()) {
    case ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion::E_T_DATACOLLECTOR_AUDIO_NO_DATA:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_datacollector_Audio_NoData" , 28);
            serializeJson(value.getT_datacollector_Audio_NoData(), g, options);
            break;
        }
    case ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion::E_T_DATACOLLECTOR_AUDIO_RADIO_DATA:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_datacollector_Audio_RadioData" , 31);
            serializeJson(value.getT_datacollector_Audio_RadioData(), g, options);
            break;
        }
    case ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion::E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_datacollector_Audio_MediaData" , 31);
            serializeJson(value.getT_datacollector_Audio_MediaData(), g, options);
            break;
        }
    case ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion::E_T_DATACOLLECTOR_AUDIO_AUX_DATA:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_datacollector_Audio_AuxData" , 29);
            serializeJson(value.getT_datacollector_Audio_AuxData(), g, options);
            break;
        }
    case ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion::E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_datacollector_Audio_ExternalSoundData" , 39);
            serializeJson(value.getT_datacollector_Audio_ExternalSoundData(), g, options);
            break;
        }
    case ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion::E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA:
        {
            yajl_gen_string(g, (const unsigned char*)  "T_datacollector_Audio_InternetRadioData" , 39);
            serializeJson(value.getT_datacollector_Audio_InternetRadioData(), g, options);
            break;
        }
    }
    yajl_gen_map_close(g);
}

void serializeJson(const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_TimeInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTimeFormatType()) {
        yajl_gen_string(g, (const unsigned char*)  "TimeFormatType" , 14);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_TimeInfoType_Name(value.getTimeFormatType());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTimeFormatType());
    }
    if (!isSparse || value.hasCurrentHours()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentHours" , 12);
        yajl_gen_integer(g, (long long)value.getCurrentHours());
    }
    if (!isSparse || value.hasCurrentMinutes()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentMinutes" , 14);
        yajl_gen_integer(g, (long long)value.getCurrentMinutes());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_PhoneInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasBTConnectionState()) {
        yajl_gen_string(g, (const unsigned char*)  "BTConnectionState" , 17);
        yajl_gen_bool(g, (bool)value.getBTConnectionState());
    }
    if (!isSparse || value.hasBatteryResidualQuantity()) {
        yajl_gen_string(g, (const unsigned char*)  "BatteryResidualQuantity" , 23);
        yajl_gen_integer(g, (long long)value.getBatteryResidualQuantity());
    }
    if (!isSparse || value.hasPhoneSignalStrength()) {
        yajl_gen_string(g, (const unsigned char*)  "PhoneSignalStrength" , 19);
        yajl_gen_integer(g, (long long)value.getPhoneSignalStrength());
    }
    if (!isSparse || value.hasCallerName()) {
        yajl_gen_string(g, (const unsigned char*)  "CallerName" , 10);
        const char *s = value.getCallerName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCallerNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "CallerNumber" , 12);
        const char *s = value.getCallerNumber().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasCallDuration()) {
        yajl_gen_string(g, (const unsigned char*)  "CallDuration" , 12);
        yajl_gen_integer(g, (long long)value.getCallDuration());
    }
    if (!isSparse || value.hasCallStatus()) {
        yajl_gen_string(g, (const unsigned char*)  "CallStatus" , 10);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_CallStatus_Name(value.getCallStatus());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCallStatus());
    }
    if (!isSparse || value.hasNoOfConnectedDevice()) {
        yajl_gen_string(g, (const unsigned char*)  "NoOfConnectedDevice" , 19);
        yajl_gen_integer(g, (long long)value.getNoOfConnectedDevice());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_SMSInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasNewSMSNotification()) {
        yajl_gen_string(g, (const unsigned char*)  "NewSMSNotification" , 18);
        yajl_gen_bool(g, (bool)value.getNewSMSNotification());
    }
    if (!isSparse || value.hasNumberOfUnreadSMS()) {
        yajl_gen_string(g, (const unsigned char*)  "NumberOfUnreadSMS" , 17);
        yajl_gen_integer(g, (long long)value.getNumberOfUnreadSMS());
    }
    if (!isSparse || value.hasSMSSendersName()) {
        yajl_gen_string(g, (const unsigned char*)  "SMSSendersName" , 14);
        const char *s = value.getSMSSendersName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_HVACInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasHVACTemperature()) {
        yajl_gen_string(g, (const unsigned char*)  "HVACTemperature" , 15);
        yajl_gen_integer(g, (long long)value.getHVACTemperature());
    }
    if (!isSparse || value.hasTemperatureUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "TemperatureUnit" , 15);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_HVACTemperatureUnit_Name(value.getTemperatureUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getTemperatureUnit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_AudioInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasTrackName()) {
        yajl_gen_string(g, (const unsigned char*)  "TrackName" , 9);
        const char *s = value.getTrackName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasTrackNumber()) {
        yajl_gen_string(g, (const unsigned char*)  "TrackNumber" , 11);
        yajl_gen_integer(g, (long long)value.getTrackNumber());
    }
    if (!isSparse || value.hasTrackPlayTime()) {
        yajl_gen_string(g, (const unsigned char*)  "TrackPlayTime" , 13);
        yajl_gen_integer(g, (long long)value.getTrackPlayTime());
    }
    if (!isSparse || value.hasCurrentRadioSource()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentRadioSource" , 18);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_CuurentRadioSource_Name(value.getCurrentRadioSource());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getCurrentRadioSource());
    }
    if (!isSparse || value.hasCurrentStationName()) {
        yajl_gen_string(g, (const unsigned char*)  "CurrentStationName" , 18);
        const char *s = value.getCurrentStationName().c_str();
        genStringAndCheck(g, (const unsigned char*) s , strlen(s));
    }
    if (!isSparse || value.hasAM_FMFrequency()) {
        yajl_gen_string(g, (const unsigned char*)  "AM_FMFrequency" , 14);
        serializeJson(value.getAM_FMFrequency(), g, options);
    }
    if (!isSparse || value.hasAM_FMFrequencyUnit()) {
        yajl_gen_string(g, (const unsigned char*)  "AM_FMFrequencyUnit" , 18);
        const char* s = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit_Name(value.getAM_FMFrequencyUnit());
        if (s != NULL)
            yajl_gen_string(g, (const unsigned char*)  s, strlen(s));
        else
            yajl_gen_integer(g, (long long)value.getAM_FMFrequencyUnit());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

// Json serialization of "T_datacollector_DownloadInfoUnion"

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& value, yajl_gen &g, ::asf::stream::json::JsonSerializationOptions options)
{
    (void)value; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)g; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases
    (void)options; // check parameter as used to prevent warning -Wunused-parameter for generated source code in conditional cases

    yajl_gen_map_open(g);
    bool isSparse = (options & JSON_SERIALIZATION_OPTION_SPARSE) > 0;
    if (!isSparse || value.hasIsDownloadAvailable()) {
        yajl_gen_string(g, (const unsigned char*)  "IsDownloadAvailable" , 19);
        yajl_gen_bool(g, (bool)value.getIsDownloadAvailable());
    }
    if (!isSparse || value.hasDownloadConnection()) {
        yajl_gen_string(g, (const unsigned char*)  "DownloadConnection" , 18);
        yajl_gen_bool(g, (bool)value.getDownloadConnection());
    }
    if (!isSparse || value.hasDownloadProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "DownloadProgress" , 16);
        yajl_gen_integer(g, (long long)value.getDownloadProgress());
    }
    if (!isSparse || value.hasUpdateProgress()) {
        yajl_gen_string(g, (const unsigned char*)  "UpdateProgress" , 14);
        yajl_gen_integer(g, (long long)value.getUpdateProgress());
    }
    yajl_gen_map_close(g);
}

void serializeJson (const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& value, ::std::string &jsonString, ::asf::stream::json::JsonSerializationOptions options)
{
    yajl_gen g;
    g = yajl_gen_alloc(NULL);
    yajl_gen_config(g, yajl_gen_indent_string, "\t");
    yajl_gen_config(g, yajl_gen_beautify, 1);

    serializeJson (value, g, options);

    const unsigned char* buf;
    size_t len;
    yajl_gen_get_buf(g, &buf, &len);
    jsonString = std::string ((const char*) buf, len);

    yajl_gen_free(g);
}

using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_VersionInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_UnitConfiguration& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_UnitVersion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_NoData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_RadioLabel& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_RadioFrequency& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_RadioCategory& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_RadioData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_TrackInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_GroupInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_ArtistInfo& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_MediaData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_AuxData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_ExternalSoundData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_InternetRadioData& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types
using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

std::ostream& operator<<(std::ostream& o, const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& value) {
    std::string jsonString;
    serializeJson(value, jsonString);
    o << jsonString;
    return o;
}

} // namespace datacollector_main_fi_types

