/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DATACOLLECTOR_MAIN_FIPROXY_H
#define DATACOLLECTOR_MAIN_FIPROXY_H

#include "asf/cca/CcaProxy.h"
#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "datacollector_main_fi.h"
#include "datacollector_main_fi_types.h"
#include "datacollector_main_fi_typesConst.h"
#include <string>

namespace datacollector_main_fi {

class Datacollector_main_fiProxy;

class Method_CurrentHeadUnitTunerModeCallbackIF {
public:
    virtual ~Method_CurrentHeadUnitTunerModeCallbackIF() {}

    virtual void onMethod_CurrentHeadUnitTunerModeError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_CurrentHeadUnitTunerModeError >& error) = 0;

    virtual void onMethod_CurrentHeadUnitTunerModeResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_CurrentHeadUnitTunerModeResult >& result) = 0;
};

class Method_GetLanguageAvailabilityCallbackIF {
public:
    virtual ~Method_GetLanguageAvailabilityCallbackIF() {}

    virtual void onMethod_GetLanguageAvailabilityError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_GetLanguageAvailabilityError >& error) = 0;

    virtual void onMethod_GetLanguageAvailabilityResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_GetLanguageAvailabilityResult >& result) = 0;
};

class Method_GetLanguageSettingsRequestfromLCNCallbackIF {
public:
    virtual ~Method_GetLanguageSettingsRequestfromLCNCallbackIF() {}

    virtual void onMethod_GetLanguageSettingsRequestfromLCNError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_GetLanguageSettingsRequestfromLCNError >& error) = 0;

    virtual void onMethod_GetLanguageSettingsRequestfromLCNResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_GetLanguageSettingsRequestfromLCNResult >& result) = 0;
};

class Method_GetMeterLanguageCallbackIF {
public:
    virtual ~Method_GetMeterLanguageCallbackIF() {}

    virtual void onMethod_GetMeterLanguageError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_GetMeterLanguageError >& error) = 0;

    virtual void onMethod_GetMeterLanguageResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_GetMeterLanguageResult >& result) = 0;
};

class Method_RenaultUpdateListStatusCallbackIF {
public:
    virtual ~Method_RenaultUpdateListStatusCallbackIF() {}

    virtual void onMethod_RenaultUpdateListStatusError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_RenaultUpdateListStatusError >& error) = 0;

    virtual void onMethod_RenaultUpdateListStatusResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_RenaultUpdateListStatusResult >& result) = 0;
};

class Method_SetAudioSourceInfoCallbackIF {
public:
    virtual ~Method_SetAudioSourceInfoCallbackIF() {}

    virtual void onMethod_SetAudioSourceInfoError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetAudioSourceInfoError >& error) = 0;

    virtual void onMethod_SetAudioSourceInfoResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetAudioSourceInfoResult >& result) = 0;
};

class Method_SetAudioSpecialModeCallbackIF {
public:
    virtual ~Method_SetAudioSpecialModeCallbackIF() {}

    virtual void onMethod_SetAudioSpecialModeError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetAudioSpecialModeError >& error) = 0;

    virtual void onMethod_SetAudioSpecialModeResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetAudioSpecialModeResult >& result) = 0;
};

class Method_SetAudioWarningCallbackIF {
public:
    virtual ~Method_SetAudioWarningCallbackIF() {}

    virtual void onMethod_SetAudioWarningError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetAudioWarningError >& error) = 0;

    virtual void onMethod_SetAudioWarningResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetAudioWarningResult >& result) = 0;
};

class Method_SetHMIDistanceUnitCallbackIF {
public:
    virtual ~Method_SetHMIDistanceUnitCallbackIF() {}

    virtual void onMethod_SetHMIDistanceUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMIDistanceUnitError >& error) = 0;

    virtual void onMethod_SetHMIDistanceUnitResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMIDistanceUnitResult >& result) = 0;
};

class Method_SetHMIFuelConsumptionUnitCallbackIF {
public:
    virtual ~Method_SetHMIFuelConsumptionUnitCallbackIF() {}

    virtual void onMethod_SetHMIFuelConsumptionUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMIFuelConsumptionUnitError >& error) = 0;

    virtual void onMethod_SetHMIFuelConsumptionUnitResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMIFuelConsumptionUnitResult >& result) = 0;
};

class Method_SetHMIPressureUnitCallbackIF {
public:
    virtual ~Method_SetHMIPressureUnitCallbackIF() {}

    virtual void onMethod_SetHMIPressureUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMIPressureUnitError >& error) = 0;

    virtual void onMethod_SetHMIPressureUnitResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMIPressureUnitResult >& result) = 0;
};

class Method_SetHMITemperatureUnitCallbackIF {
public:
    virtual ~Method_SetHMITemperatureUnitCallbackIF() {}

    virtual void onMethod_SetHMITemperatureUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMITemperatureUnitError >& error) = 0;

    virtual void onMethod_SetHMITemperatureUnitResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetHMITemperatureUnitResult >& result) = 0;
};

class Method_SetLanguageSettingsfromLCNCallbackIF {
public:
    virtual ~Method_SetLanguageSettingsfromLCNCallbackIF() {}

    virtual void onMethod_SetLanguageSettingsfromLCNError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetLanguageSettingsfromLCNError >& error) = 0;

    virtual void onMethod_SetLanguageSettingsfromLCNResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetLanguageSettingsfromLCNResult >& result) = 0;
};

class Method_SetMediaBrowserList_HighlightedElementCallbackIF {
public:
    virtual ~Method_SetMediaBrowserList_HighlightedElementCallbackIF() {}

    virtual void onMethod_SetMediaBrowserList_HighlightedElementError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetMediaBrowserList_HighlightedElementError >& error) = 0;

    virtual void onMethod_SetMediaBrowserList_HighlightedElementResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetMediaBrowserList_HighlightedElementResult >& result) = 0;
};

class Method_SetMeterLanguageCallbackIF {
public:
    virtual ~Method_SetMeterLanguageCallbackIF() {}

    virtual void onMethod_SetMeterLanguageError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetMeterLanguageError >& error) = 0;

    virtual void onMethod_SetMeterLanguageResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetMeterLanguageResult >& result) = 0;
};

class Method_SetRequestedLanguageResultCallbackIF {
public:
    virtual ~Method_SetRequestedLanguageResultCallbackIF() {}

    virtual void onMethod_SetRequestedLanguageResultError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetRequestedLanguageResultError >& error) = 0;

    virtual void onMethod_SetRequestedLanguageResultResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_SetRequestedLanguageResultResult >& result) = 0;
};

class Method_TriggerVersionInfotoMeterCallbackIF {
public:
    virtual ~Method_TriggerVersionInfotoMeterCallbackIF() {}

    virtual void onMethod_TriggerVersionInfotoMeterError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_TriggerVersionInfotoMeterError >& error) = 0;

    virtual void onMethod_TriggerVersionInfotoMeterResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Method_TriggerVersionInfotoMeterResult >& result) = 0;
};

class Property_AvailableFuelConsumptionUnitsCallbackIF {
public:
    virtual ~Property_AvailableFuelConsumptionUnitsCallbackIF() {}

    virtual void onProperty_AvailableFuelConsumptionUnitsError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_AvailableFuelConsumptionUnitsError >& error) = 0;

    virtual void onProperty_AvailableFuelConsumptionUnitsStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_AvailableFuelConsumptionUnitsStatus >& status) = 0;
};

class Property_AvailablePressureUnitsCallbackIF {
public:
    virtual ~Property_AvailablePressureUnitsCallbackIF() {}

    virtual void onProperty_AvailablePressureUnitsError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_AvailablePressureUnitsError >& error) = 0;

    virtual void onProperty_AvailablePressureUnitsStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_AvailablePressureUnitsStatus >& status) = 0;
};

class Property_AvailableTemperatureUnitsCallbackIF {
public:
    virtual ~Property_AvailableTemperatureUnitsCallbackIF() {}

    virtual void onProperty_AvailableTemperatureUnitsError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_AvailableTemperatureUnitsError >& error) = 0;

    virtual void onProperty_AvailableTemperatureUnitsStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_AvailableTemperatureUnitsStatus >& status) = 0;
};

class Property_ConfigurationCallbackIF {
public:
    virtual ~Property_ConfigurationCallbackIF() {}

    virtual void onProperty_ConfigurationError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_ConfigurationError >& error) = 0;

    virtual void onProperty_ConfigurationStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_ConfigurationStatus >& status) = 0;
};

class Property_ConnectionCallbackIF {
public:
    virtual ~Property_ConnectionCallbackIF() {}

    virtual void onProperty_ConnectionError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_ConnectionError >& error) = 0;

    virtual void onProperty_ConnectionStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_ConnectionStatus >& status) = 0;
};

class Property_CurrentMeterSettingsCallbackIF {
public:
    virtual ~Property_CurrentMeterSettingsCallbackIF() {}

    virtual void onProperty_CurrentMeterSettingsError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_CurrentMeterSettingsError >& error) = 0;

    virtual void onProperty_CurrentMeterSettingsStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_CurrentMeterSettingsStatus >& status) = 0;
};

class Property_DataTransmissionCallbackIF {
public:
    virtual ~Property_DataTransmissionCallbackIF() {}

    virtual void onProperty_DataTransmissionError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_DataTransmissionError >& error) = 0;

    virtual void onProperty_DataTransmissionStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_DataTransmissionStatus >& status) = 0;
};

class Property_HMIStatusBarInfoCallbackIF {
public:
    virtual ~Property_HMIStatusBarInfoCallbackIF() {}

    virtual void onProperty_HMIStatusBarInfoError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_HMIStatusBarInfoError >& error) = 0;

    virtual void onProperty_HMIStatusBarInfoStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_HMIStatusBarInfoStatus >& status) = 0;
};

class Property_HardwareVersionCallbackIF {
public:
    virtual ~Property_HardwareVersionCallbackIF() {}

    virtual void onProperty_HardwareVersionError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_HardwareVersionError >& error) = 0;

    virtual void onProperty_HardwareVersionStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_HardwareVersionStatus >& status) = 0;
};

class Property_RequestedFuelConsumptionUnitCallbackIF {
public:
    virtual ~Property_RequestedFuelConsumptionUnitCallbackIF() {}

    virtual void onProperty_RequestedFuelConsumptionUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedFuelConsumptionUnitError >& error) = 0;

    virtual void onProperty_RequestedFuelConsumptionUnitStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedFuelConsumptionUnitStatus >& status) = 0;
};

class Property_RequestedLanguageCallbackIF {
public:
    virtual ~Property_RequestedLanguageCallbackIF() {}

    virtual void onProperty_RequestedLanguageError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedLanguageError >& error) = 0;

    virtual void onProperty_RequestedLanguageStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedLanguageStatus >& status) = 0;
};

class Property_RequestedPressureUnitCallbackIF {
public:
    virtual ~Property_RequestedPressureUnitCallbackIF() {}

    virtual void onProperty_RequestedPressureUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedPressureUnitError >& error) = 0;

    virtual void onProperty_RequestedPressureUnitStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedPressureUnitStatus >& status) = 0;
};

class Property_RequestedTemperatureUnitCallbackIF {
public:
    virtual ~Property_RequestedTemperatureUnitCallbackIF() {}

    virtual void onProperty_RequestedTemperatureUnitError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedTemperatureUnitError >& error) = 0;

    virtual void onProperty_RequestedTemperatureUnitStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_RequestedTemperatureUnitStatus >& status) = 0;
};

class Property_SetAudioSourceInfoCallbackIF {
public:
    virtual ~Property_SetAudioSourceInfoCallbackIF() {}

    virtual void onProperty_SetAudioSourceInfoError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SetAudioSourceInfoError >& error) = 0;

    virtual void onProperty_SetAudioSourceInfoStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SetAudioSourceInfoStatus >& status) = 0;
};

class Property_SetNaviSwipeCallbackIF {
public:
    virtual ~Property_SetNaviSwipeCallbackIF() {}

    virtual void onProperty_SetNaviSwipeError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SetNaviSwipeError >& error) = 0;

    virtual void onProperty_SetNaviSwipeStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SetNaviSwipeStatus >& status) = 0;
};

class Property_SmsSendStatusCallbackIF {
public:
    virtual ~Property_SmsSendStatusCallbackIF() {}

    virtual void onProperty_SmsSendStatusError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SmsSendStatusError >& error) = 0;

    virtual void onProperty_SmsSendStatusStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SmsSendStatusStatus >& status) = 0;
};

class Property_SoftwareVersionCallbackIF {
public:
    virtual ~Property_SoftwareVersionCallbackIF() {}

    virtual void onProperty_SoftwareVersionError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SoftwareVersionError >& error) = 0;

    virtual void onProperty_SoftwareVersionStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SoftwareVersionStatus >& status) = 0;
};

class Property_SupportedLangSyncModeCallbackIF {
public:
    virtual ~Property_SupportedLangSyncModeCallbackIF() {}

    virtual void onProperty_SupportedLangSyncModeError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SupportedLangSyncModeError >& error) = 0;

    virtual void onProperty_SupportedLangSyncModeStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< Property_SupportedLangSyncModeStatus >& status) = 0;
};

class SMSSettingsCallbackIF {
public:
    virtual ~SMSSettingsCallbackIF() {}

    virtual void onSMSSettingsError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SMSSettingsError >& error) = 0;

    virtual void onSMSSettingsStatus(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SMSSettingsStatus >& status) = 0;
};

class SetInterrupt_to_MeterCallbackIF {
public:
    virtual ~SetInterrupt_to_MeterCallbackIF() {}

    virtual void onSetInterrupt_to_MeterError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetInterrupt_to_MeterError >& error) = 0;

    virtual void onSetInterrupt_to_MeterResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetInterrupt_to_MeterResult >& result) = 0;
};

class SetIsWaitmodeSupportedByPhoneCallbackIF {
public:
    virtual ~SetIsWaitmodeSupportedByPhoneCallbackIF() {}

    virtual void onSetIsWaitmodeSupportedByPhoneError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetIsWaitmodeSupportedByPhoneError >& error) = 0;

    virtual void onSetIsWaitmodeSupportedByPhoneResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetIsWaitmodeSupportedByPhoneResult >& result) = 0;
};

class SetPhoneIncomingCallInfoCallbackIF {
public:
    virtual ~SetPhoneIncomingCallInfoCallbackIF() {}

    virtual void onSetPhoneIncomingCallInfoError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetPhoneIncomingCallInfoError >& error) = 0;

    virtual void onSetPhoneIncomingCallInfoResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetPhoneIncomingCallInfoResult >& result) = 0;
};

class SetPhonePrivateModeSettingsCallbackIF {
public:
    virtual ~SetPhonePrivateModeSettingsCallbackIF() {}

    virtual void onSetPhonePrivateModeSettingsError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetPhonePrivateModeSettingsError >& error) = 0;

    virtual void onSetPhonePrivateModeSettingsResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetPhonePrivateModeSettingsResult >& result) = 0;
};

class SetPhoneWaitingModeSettingCallbackIF {
public:
    virtual ~SetPhoneWaitingModeSettingCallbackIF() {}

    virtual void onSetPhoneWaitingModeSettingError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetPhoneWaitingModeSettingError >& error) = 0;

    virtual void onSetPhoneWaitingModeSettingResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetPhoneWaitingModeSettingResult >& result) = 0;
};

class SetVoiceRecognitionStatusCallbackIF {
public:
    virtual ~SetVoiceRecognitionStatusCallbackIF() {}

    virtual void onSetVoiceRecognitionStatusError(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVoiceRecognitionStatusError >& error) = 0;

    virtual void onSetVoiceRecognitionStatusResult(const ::boost::shared_ptr< Datacollector_main_fiProxy >& proxy, const ::boost::shared_ptr< SetVoiceRecognitionStatusResult >& result) = 0;
};

class Datacollector_main_fiProxyCallback;

/**
 * Datacollector_main_fiProxy is the client side representation of the CCA
 * Functional Interface 'datacollector_main_fi' (specified in file
 * datacollector_main_fi.xml).
 *
 * CCA Functional Interface 'datacollector_main_fi'
 *
 * Fullname: Datacollector MIDW component's Functional Interface
 *
 * Version: $Revision:   1.0.1  $
 *
 * Author: Suman Kaup
 *
 * Date: $Date:  31.03.2015  $
 *
 * Department:
 *
 * Title: datacollector_main_fi
 *
 * <b>Description of 'datacollector_main_fi':</b>
 *
 * ..
 */
class Datacollector_main_fiProxy : public ::asf::cca::CcaProxy
{
public:

    /**
     * Create a new instance of Datacollector_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The application id of the CCA Server will be determined
     * with help of the CCA SrvSupplier messages. It's guranteed that the
     * corresponding CCA server will have the specified major version and at
     * least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Datacollector_main_fiProxy > createProxy(const std::string& portName, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Datacollector_main_fiProxy. The caller has to
     * pass the port name and the service information. It is only possible to
     * use this function if the port is defined in the CMC model as "wired at
     * runtime"-port. The proxy will connect to the CCA application specified
     * by appId. The CCA SrvSupplier messages will be used to determine the
     * availability of this application and the service. It's guranteed that
     * the corresponding CCA server will have the specified major version and
     * at least the specified minor version of that interface.
     */
    static ::boost::shared_ptr< Datacollector_main_fiProxy > createProxy(const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags = ::asf::cca::CcaProxy::SERVICE_REGISTER);

    /**
     * Create a new instance of Datacollector_main_fiProxy. The caller has to
     * pass the port name. The port name is defined in the "Car Multimedia
     * Component" model. With the help of the port name it is possible to
     * address the concrete proxy, which is defined in the CMC model
     * description.
     */
    static ::boost::shared_ptr< Datacollector_main_fiProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Destructor of Datacollector_main_fiProxy. The destructor will send
     * RelUpReg messages for all property notifications and call the error
     * callback of all pending method invocations.
     */
    ~Datacollector_main_fiProxy();

    // Method 'Method_TriggerVersionInfotoMeter'

    /**
     * Call the method 'Method_TriggerVersionInfotoMeter'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_TriggerVersionInfotoMeter'</b>:
     *
     * <p>This method is used to Trigger the GET for Version Info to FC_Meter.</p>
     * <p>This method is used as a Internal Communication between HALL_Applications, DC and FC_Meter.</p>
     * <p>This will result in Trigger of MCAN Message to GET the Hardware and Software Version</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Version Actual Needed Version Info by HALL Applications. This may be Hardware or Software Version request.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_TriggerVersionInfotoMeterStart(Method_TriggerVersionInfotoMeterCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_VersionInfo e8Version);

    // Method 'Method_SetHMIDistanceUnit'

    /**
     * Call the method 'Method_SetHMIDistanceUnit'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetHMIDistanceUnit'</b>:
     *
     * This method is used to transmit the current distance unit used in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8DistanceUnit Actual distance unit used by the HMI: Unknown, m (metric), mi (imperial).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetHMIDistanceUnitStart(Method_SetHMIDistanceUnitCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit e8DistanceUnit);

    // Method 'Method_SetHMIFuelConsumptionUnit'

    /**
     * Call the method 'Method_SetHMIFuelConsumptionUnit'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetHMIFuelConsumptionUnit'</b>:
     *
     * This method is used to transmit the current fuel consumption unit used in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8FuelConsumptionUnit Actual fuel consumption unit used by the HMI: km_per_l, l_per_100km, US_MPG, UK_MPG
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetHMIFuelConsumptionUnitStart(Method_SetHMIFuelConsumptionUnitCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit);

    // Method 'Method_SetHMITemperatureUnit'

    /**
     * Call the method 'Method_SetHMITemperatureUnit'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetHMITemperatureUnit'</b>:
     *
     * This method is used to transmit the current temperature unit used in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8TemperatureUnit Actual temperature unit used by the HMI: deg_C (ï¿½C) or deg_F (ï¿½F)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetHMITemperatureUnitStart(Method_SetHMITemperatureUnitCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit);

    // Method 'Method_SetHMIPressureUnit'

    /**
     * Call the method 'Method_SetHMIPressureUnit'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetHMIPressureUnit'</b>:
     *
     * This method is used to transmit the current pressure unit used in the HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8PressureUnit Actual pressure unit used by the HMI: kPa, PSI, bar, kgf_cm2
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetHMIPressureUnitStart(Method_SetHMIPressureUnitCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit);

    // Method 'Method_SetRequestedLanguageResult'

    /**
     * Call the method 'Method_SetRequestedLanguageResult'. This method sends
     * a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetRequestedLanguageResult'</b>:
     *
     * This method is used to report the result of a former language request.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Result <p>Result of a former language request:</p>
     * <p>UnchangedNotAuto, UnchangedAuto, Changed</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetRequestedLanguageResultStart(Method_SetRequestedLanguageResultCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult e8Result);

    // Method 'Method_GetMeterLanguage'

    /**
     * Call the method 'Method_GetMeterLanguage'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_GetMeterLanguage'</b>:
     *
     * This method is used to ask the meter explicitly for its current language.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_GetMeterLanguageStart(Method_GetMeterLanguageCallbackIF& cb);

    // Method 'Method_GetLanguageSettingsRequestfromLCN'

    /**
     * Call the method 'Method_GetLanguageSettingsRequestfromLCN'. This method
     * sends a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_GetLanguageSettingsRequestfromLCN'</b>:
     *
     * This method is called by ITM when there is a switching to language settings screen in ITM (MCAN Fct Id:606h).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_GetLanguageSettingsRequestfromLCNStart(Method_GetLanguageSettingsRequestfromLCNCallbackIF& cb);

    // Method 'Method_SetLanguageSettingsfromLCN'

    /**
     * Call the method 'Method_SetLanguageSettingsfromLCN'. This method sends
     * a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetLanguageSettingsfromLCN'</b>:
     *
     * This method is called by ITM when there is change in Language from ITM side(MCAN Fct Id:606h).
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Language Language setting.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetLanguageSettingsfromLCNStart(Method_SetLanguageSettingsfromLCNCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_Language e8Language);

    // Method 'Method_GetLanguageAvailability'

    /**
     * Call the method 'Method_GetLanguageAvailability'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_GetLanguageAvailability'</b>:
     *
     * This Method is called by the client to know the language availability in the Meter
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Language Language selected by the user on HeadUnit
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_GetLanguageAvailabilityStart(Method_GetLanguageAvailabilityCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_Language e8Language);

    // Method 'Method_SetMeterLanguage'

    /**
     * Call the method 'Method_SetMeterLanguage'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetMeterLanguage'</b>:
     *
     * This Method is called by the client to set language in the Meter
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8Language Language to be set on the Meter
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetMeterLanguageStart(Method_SetMeterLanguageCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_Language e8Language);

    // Method 'Method_SetAudioSourceInfo'

    /**
     * Call the method 'Method_SetAudioSourceInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetAudioSourceInfo'</b>:
     *
     * <p>This method is used to transmit the information about the current audio source.</p>
     * <p>As there is always only one audio source active at the same time, a switching of the audio
     * source will just end up in sending one method containing the current data of the new source.</p>
     * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
     * <p>The data differ according to the current type of source. Therefore, they will be transmitted
     * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bCausedByUser The changes of the audio source data are caused by a user action.
     *
     * @param SourceInfo Union containing all information about the audio info.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetAudioSourceInfoStart(Method_SetAudioSourceInfoCallbackIF& cb, bool bCausedByUser, const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& sourceInfo);

    // Method 'Method_SetAudioWarning'

    /**
     * Call the method 'Method_SetAudioWarning'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetAudioWarning'</b>:
     *
     * <p>This method is used to transmit the information about an audio warning.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bCausedByUser The audio warning is a result of a user action.
     *
     * @param e8WarningSource Audio source which is the origin of the warning.
     *
     * @param e8WarningState State of the warning describing the warning type.
     *
     * @param strWarningText Free text string describing the warning.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetAudioWarningStart(Method_SetAudioWarningCallbackIF& cb, bool bCausedByUser, ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8WarningSource, ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState e8WarningState, const ::std::string& strWarningText);

    // Method 'Method_SetAudioSpecialMode'

    /**
     * Call the method 'Method_SetAudioSpecialMode'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetAudioSpecialMode'</b>:
     *
     * <p>This method is used to transmit the information about a currently active special audio mode
     * (Scan, Search, FastForward, Rewind).</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8SpecialMode Type of special audio mode, "None" if no special audio mode is active.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetAudioSpecialModeStart(Method_SetAudioSpecialModeCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode e8SpecialMode);

    // Method 'Method_SetMediaBrowserList_HighlightedElement'

    /**
     * Call the method 'Method_SetMediaBrowserList_HighlightedElement'. This
     * method sends a MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_SetMediaBrowserList_HighlightedElement'</b>:
     *
     * <p>This method is used to show what's been highlighted in HMI media browser list and about which input device is been used for doing the same.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param ElementName Text of currently highlighted element. E.g. folder or track name
     *
     * @param ElementType Type of the highlighted element.
     *
     * @param InputDevice Input device which was used to move to the element
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_SetMediaBrowserList_HighlightedElementStart(Method_SetMediaBrowserList_HighlightedElementCallbackIF& cb, const ::std::string& elementName, ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType elementType, ::datacollector_main_fi_types::T_e8_datacollector_InputDevice inputDevice);

    // Method 'Method_CurrentHeadUnitTunerMode'

    /**
     * Call the method 'Method_CurrentHeadUnitTunerMode'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_CurrentHeadUnitTunerMode'</b>:
     *
     * <p>This method is used to show which Tuner HMI mode is shown. The options include List, Frequency, and Preset.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8CurrentHeadUnitTunerMode Currently selected Tuner HMI screen i.e. List, Frequency of Preset
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_CurrentHeadUnitTunerModeStart(Method_CurrentHeadUnitTunerModeCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode e8CurrentHeadUnitTunerMode);

    // Method 'Method_RenaultUpdateListStatus'

    /**
     * Call the method 'Method_RenaultUpdateListStatus'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'Method_RenaultUpdateListStatus'</b>:
     *
     * <p>This method is to provide the status of the "Updating List" from the Renault Tuner screen.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8RenaultUpdateListStatus Current status of the Updating List screen from the Renault Tuner HMI.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMethod_RenaultUpdateListStatusStart(Method_RenaultUpdateListStatusCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value e8RenaultUpdateListStatus);

    // Method 'SetPhoneIncomingCallInfo'

    /**
     * Call the method 'SetPhoneIncomingCallInfo'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetPhoneIncomingCallInfo'</b>:
     *
     * <p>This method is used to transmit the information about a currently received incoming call
     * leading to a popup in the meter instrument analogous to the popup on the LCN main screen.</p>
     * <p>The parameter bIncoming shall be set to "true" as long as the call is incoming (ringing).
     * When it changes to active or end, the parameter shall be set to "false" again.</p>
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bIncoming <p>FALSE: No incoming call, i.e. either no call at all or the call is active.</p>
     * <p>TRUE: Call is currently incoming (ringing).</p>
     *
     * @param strCallerInfo <p>String giving either the name of the caller when the number is found in the phonebook
     * or the phone number when no matching entry could be found. If no info about the caller
     * is available (not even the number), the string shall be cleared.</p>
     * <p>During an active call, i.e. when the parameter bIncoming is set to "false", the string
     * may be filled with the caller info, but currently this is not necessary, because the
     * information is used by the meter only to show a popup during an incoming call.</p>
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPhoneIncomingCallInfoStart(SetPhoneIncomingCallInfoCallbackIF& cb, bool bIncoming, const ::std::string& strCallerInfo);

    // Method 'SetPhoneWaitingModeSetting'

    /**
     * Call the method 'SetPhoneWaitingModeSetting'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetPhoneWaitingModeSetting'</b>:
     *
     * This method is used to transmit the status of a waiting mode .
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bIsAutomatic bIsAutomatic - 0 - Automatic is selected for waiting mode
     * bIsAutomatic - 1 - Manual is selected for waiting mode
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPhoneWaitingModeSettingStart(SetPhoneWaitingModeSettingCallbackIF& cb, bool bIsAutomatic);

    // Method 'SetPhonePrivateModeSettings'

    /**
     * Call the method 'SetPhonePrivateModeSettings'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetPhonePrivateModeSettings'</b>:
     *
     * This method is used to transmit the status of a Private mode(Driver only profile) set in Phone HMI.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bIsPrivateModeOn bIsPrivateModeOn - 0 - Driver only profile is set in HMI
     * bIsPrivateModeOn - 1 - Driver only profile is NOT set in HMI (Normal Mode)
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPhonePrivateModeSettingsStart(SetPhonePrivateModeSettingsCallbackIF& cb, bool bIsPrivateModeOn);

    // Method 'SetIsWaitmodeSupportedByPhone'

    /**
     * Call the method 'SetIsWaitmodeSupportedByPhone'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetIsWaitmodeSupportedByPhone'</b>:
     *
     * This method is used to transmit the status of  whether or not connected phone supports waiting mode feature
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bIsWaitModeSupported bIsWaitModeSupported - 0 - Waiting mode feature is supported by connected phone
     * bIsWaitModeSupported - 1 - Waiting mode feature is NOT supported by connected phone
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetIsWaitmodeSupportedByPhoneStart(SetIsWaitmodeSupportedByPhoneCallbackIF& cb, bool bIsWaitModeSupported);

    // Method 'SetVoiceRecognitionStatus'

    /**
     * Call the method 'SetVoiceRecognitionStatus'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetVoiceRecognitionStatus'</b>:
     *
     * This method is used to transmit the status of a currently running voice recognition session
     * leading to a popup in the meter instrument.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param e8VRState Status of the voice recognition (Idle, Listening, Processing).
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetVoiceRecognitionStatusStart(SetVoiceRecognitionStatusCallbackIF& cb, ::datacollector_main_fi_types::T_e8_datacollector_VR_State e8VRState);

    // Method 'SetInterrupt_to_Meter'

    /**
     * Call the method 'SetInterrupt_to_Meter'. This method sends a
     * MethodStart message to the CCA server.
     *
     * <b>Documentation of 'SetInterrupt_to_Meter'</b>:
     *
     * This method is used to collect the Info rgarding the User Action and whether it is through SWC Key action.
     * The HALL application which gives us the info regarding the User Action should also tell us their Source.
     * And also the Type of the User Action corresponding to their Source.
     *
     * @param cb this callback will be called when a MethodResult or Error
     * message is received in return to the MethodStart message.
     *
     * @param bCausedBy_SWC_UserAction TRUE  : If the Interrupt is a result of a user action through SWC.
     * FALSE : If the Interrupt is a result of a User action by any other means
     *
     * @param e8Interrupt_Source Audio source which is the origin of the Interrupt.
     *
     * @param e8Interrupt_Type Type of the Interrupt which is currently active.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetInterrupt_to_MeterStart(SetInterrupt_to_MeterCallbackIF& cb, bool bCausedBy_SWC_UserAction, ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8Interrupt_Source, ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type e8Interrupt_Type);

    // Property 'Property_Connection'

    /**
     * Notify on the property 'Property_Connection'. This method sends a UpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Property_Connection'</b>:
     *
     * This property gives information about the connection status to the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_ConnectionUpReg(Property_ConnectionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_Connection'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_Connection'</b>:
     *
     * This property gives information about the connection status to the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendProperty_ConnectionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_ConnectionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_Connection'.
     */
    void sendProperty_ConnectionRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_Connection' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_Connection() returns true.
     *
     * @return the previously received value of the property 'Property_Connection'.
     */
    const Property_ConnectionStatus& getProperty_Connection() const;

    /**
     * Determines whether a status message for the property 'Property_Connection' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_Connection() const;

    /**
     * Request the value of the property 'Property_Connection' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_Connection'</b>:
     *
     * This property gives information about the connection status to the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_ConnectionGet(Property_ConnectionCallbackIF& cb);

    // Property 'Property_Configuration'

    /**
     * Notify on the property 'Property_Configuration'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_Configuration'</b>:
     *
     * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
     * <p>We can only communicate with a unit when the configuration is valid.</p>
     * <p>The additional information about the unit ID and the used message version is not really
     * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_ConfigurationUpReg(Property_ConfigurationCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_Configuration'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_Configuration'</b>:
     *
     * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
     * <p>We can only communicate with a unit when the configuration is valid.</p>
     * <p>The additional information about the unit ID and the used message version is not really
     * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
     *
     * @param act The act which was previously returned by the
     * sendProperty_ConfigurationUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_ConfigurationRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_Configuration'.
     */
    void sendProperty_ConfigurationRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_Configuration' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_Configuration() returns true.
     *
     * @return the previously received value of the property 'Property_Configuration'.
     */
    const Property_ConfigurationStatus& getProperty_Configuration() const;

    /**
     * Determines whether a status message for the property 'Property_Configuration' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_Configuration() const;

    /**
     * Request the value of the property 'Property_Configuration' from the CCA
     * server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_Configuration'</b>:
     *
     * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
     * <p>We can only communicate with a unit when the configuration is valid.</p>
     * <p>The additional information about the unit ID and the used message version is not really
     * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_ConfigurationGet(Property_ConfigurationCallbackIF& cb);

    // Property 'Property_HardwareVersion'

    /**
     * Notify on the property 'Property_HardwareVersion'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_HardwareVersionUpReg(Property_HardwareVersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_HardwareVersion'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendProperty_HardwareVersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_HardwareVersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_HardwareVersion'.
     */
    void sendProperty_HardwareVersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_HardwareVersion'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_HardwareVersion() returns true.
     *
     * @return the previously received value of the property 'Property_HardwareVersion'.
     */
    const Property_HardwareVersionStatus& getProperty_HardwareVersion() const;

    /**
     * Determines whether a status message for the property 'Property_HardwareVersion' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_HardwareVersion() const;

    /**
     * Request the value of the property 'Property_HardwareVersion' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_HardwareVersion'</b>:
     *
     * This property gives information about the hardware version of the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_HardwareVersionGet(Property_HardwareVersionCallbackIF& cb);

    // Property 'Property_SoftwareVersion'

    /**
     * Notify on the property 'Property_SoftwareVersion'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SoftwareVersionUpReg(Property_SoftwareVersionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_SoftwareVersion'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param act The act which was previously returned by the
     * sendProperty_SoftwareVersionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_SoftwareVersionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_SoftwareVersion'.
     */
    void sendProperty_SoftwareVersionRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_SoftwareVersion'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_SoftwareVersion() returns true.
     *
     * @return the previously received value of the property 'Property_SoftwareVersion'.
     */
    const Property_SoftwareVersionStatus& getProperty_SoftwareVersion() const;

    /**
     * Determines whether a status message for the property 'Property_SoftwareVersion' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_SoftwareVersion() const;

    /**
     * Request the value of the property 'Property_SoftwareVersion' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_SoftwareVersion'</b>:
     *
     * This property gives information about the software version of the various MCAN units.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SoftwareVersionGet(Property_SoftwareVersionCallbackIF& cb);

    // Property 'Property_DataTransmission'

    /**
     * Notify on the property 'Property_DataTransmission'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_DataTransmission'</b>:
     *
     * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_DataTransmissionUpReg(Property_DataTransmissionCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_DataTransmission'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_DataTransmission'</b>:
     *
     * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
     *
     * @param act The act which was previously returned by the
     * sendProperty_DataTransmissionUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_DataTransmissionRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_DataTransmission'.
     */
    void sendProperty_DataTransmissionRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_DataTransmission'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_DataTransmission() returns true.
     *
     * @return the previously received value of the property 'Property_DataTransmission'.
     */
    const Property_DataTransmissionStatus& getProperty_DataTransmission() const;

    /**
     * Determines whether a status message for the property 'Property_DataTransmission' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_DataTransmission() const;

    /**
     * Request the value of the property 'Property_DataTransmission' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_DataTransmission'</b>:
     *
     * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_DataTransmissionGet(Property_DataTransmissionCallbackIF& cb);

    // Property 'Property_CurrentMeterSettings'

    /**
     * Notify on the property 'Property_CurrentMeterSettings'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_CurrentMeterSettings'</b>:
     *
     * This property gives information about the current settings of the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_CurrentMeterSettingsUpReg(Property_CurrentMeterSettingsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_CurrentMeterSettings'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_CurrentMeterSettings'</b>:
     *
     * This property gives information about the current settings of the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_CurrentMeterSettingsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_CurrentMeterSettingsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_CurrentMeterSettings'.
     */
    void sendProperty_CurrentMeterSettingsRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_CurrentMeterSettings' (as known by the proxy). This method is
     * only allowed to be called when a status message for this property was
     * received before. Otherwise the behavior of this method is undefined. It
     * is safe to call this method when hasProperty_CurrentMeterSettings()
     * returns true.
     *
     * @return the previously received value of the property 'Property_CurrentMeterSettings'.
     */
    const Property_CurrentMeterSettingsStatus& getProperty_CurrentMeterSettings() const;

    /**
     * Determines whether a status message for the property 'Property_CurrentMeterSettings' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_CurrentMeterSettings() const;

    /**
     * Request the value of the property 'Property_CurrentMeterSettings' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_CurrentMeterSettings'</b>:
     *
     * This property gives information about the current settings of the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_CurrentMeterSettingsGet(Property_CurrentMeterSettingsCallbackIF& cb);

    // Property 'Property_AvailableFuelConsumptionUnits'

    /**
     * Notify on the property 'Property_AvailableFuelConsumptionUnits'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailableFuelConsumptionUnits'</b>:
     *
     * This property gives information about fuel consumption units supported by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_AvailableFuelConsumptionUnitsUpReg(Property_AvailableFuelConsumptionUnitsCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'Property_AvailableFuelConsumptionUnits'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailableFuelConsumptionUnits'</b>:
     *
     * This property gives information about fuel consumption units supported by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_AvailableFuelConsumptionUnitsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_AvailableFuelConsumptionUnitsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_AvailableFuelConsumptionUnits'.
     */
    void sendProperty_AvailableFuelConsumptionUnitsRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_AvailableFuelConsumptionUnits' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_AvailableFuelConsumptionUnits() returns true.
     *
     * @return the previously received value of the property 'Property_AvailableFuelConsumptionUnits'.
     */
    const Property_AvailableFuelConsumptionUnitsStatus& getProperty_AvailableFuelConsumptionUnits() const;

    /**
     * Determines whether a status message for the property 'Property_AvailableFuelConsumptionUnits' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_AvailableFuelConsumptionUnits() const;

    /**
     * Request the value of the property
     * 'Property_AvailableFuelConsumptionUnits' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailableFuelConsumptionUnits'</b>:
     *
     * This property gives information about fuel consumption units supported by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_AvailableFuelConsumptionUnitsGet(Property_AvailableFuelConsumptionUnitsCallbackIF& cb);

    // Property 'Property_AvailableTemperatureUnits'

    /**
     * Notify on the property 'Property_AvailableTemperatureUnits'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailableTemperatureUnits'</b>:
     *
     * This property gives information about temperature units supported by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_AvailableTemperatureUnitsUpReg(Property_AvailableTemperatureUnitsCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'Property_AvailableTemperatureUnits'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailableTemperatureUnits'</b>:
     *
     * This property gives information about temperature units supported by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_AvailableTemperatureUnitsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_AvailableTemperatureUnitsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_AvailableTemperatureUnits'.
     */
    void sendProperty_AvailableTemperatureUnitsRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_AvailableTemperatureUnits' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_AvailableTemperatureUnits() returns true.
     *
     * @return the previously received value of the property 'Property_AvailableTemperatureUnits'.
     */
    const Property_AvailableTemperatureUnitsStatus& getProperty_AvailableTemperatureUnits() const;

    /**
     * Determines whether a status message for the property 'Property_AvailableTemperatureUnits' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_AvailableTemperatureUnits() const;

    /**
     * Request the value of the property 'Property_AvailableTemperatureUnits'
     * from the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailableTemperatureUnits'</b>:
     *
     * This property gives information about temperature units supported by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_AvailableTemperatureUnitsGet(Property_AvailableTemperatureUnitsCallbackIF& cb);

    // Property 'Property_AvailablePressureUnits'

    /**
     * Notify on the property 'Property_AvailablePressureUnits'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailablePressureUnits'</b>:
     *
     * This property gives information about pressure units supported by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_AvailablePressureUnitsUpReg(Property_AvailablePressureUnitsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_AvailablePressureUnits'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailablePressureUnits'</b>:
     *
     * This property gives information about pressure units supported by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_AvailablePressureUnitsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_AvailablePressureUnitsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_AvailablePressureUnits'.
     */
    void sendProperty_AvailablePressureUnitsRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_AvailablePressureUnits' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_AvailablePressureUnits() returns true.
     *
     * @return the previously received value of the property 'Property_AvailablePressureUnits'.
     */
    const Property_AvailablePressureUnitsStatus& getProperty_AvailablePressureUnits() const;

    /**
     * Determines whether a status message for the property 'Property_AvailablePressureUnits' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_AvailablePressureUnits() const;

    /**
     * Request the value of the property 'Property_AvailablePressureUnits'
     * from the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_AvailablePressureUnits'</b>:
     *
     * This property gives information about pressure units supported by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_AvailablePressureUnitsGet(Property_AvailablePressureUnitsCallbackIF& cb);

    // Property 'Property_RequestedFuelConsumptionUnit'

    /**
     * Notify on the property 'Property_RequestedFuelConsumptionUnit'. This
     * method sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedFuelConsumptionUnit'</b>:
     *
     * This property gives information about the fuel consumption unit requested by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedFuelConsumptionUnitUpReg(Property_RequestedFuelConsumptionUnitCallbackIF& cb);

    /**
     * Remove the notifcation on property
     * 'Property_RequestedFuelConsumptionUnit'. This method sends a RelUpReg
     * message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedFuelConsumptionUnit'</b>:
     *
     * This property gives information about the fuel consumption unit requested by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_RequestedFuelConsumptionUnitUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_RequestedFuelConsumptionUnitRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_RequestedFuelConsumptionUnit'.
     */
    void sendProperty_RequestedFuelConsumptionUnitRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_RequestedFuelConsumptionUnit' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_RequestedFuelConsumptionUnit() returns true.
     *
     * @return the previously received value of the property 'Property_RequestedFuelConsumptionUnit'.
     */
    const Property_RequestedFuelConsumptionUnitStatus& getProperty_RequestedFuelConsumptionUnit() const;

    /**
     * Determines whether a status message for the property 'Property_RequestedFuelConsumptionUnit' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_RequestedFuelConsumptionUnit() const;

    /**
     * Request the value of the property
     * 'Property_RequestedFuelConsumptionUnit' from the CCA server. This
     * method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedFuelConsumptionUnit'</b>:
     *
     * This property gives information about the fuel consumption unit requested by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedFuelConsumptionUnitGet(Property_RequestedFuelConsumptionUnitCallbackIF& cb);

    // Property 'Property_RequestedTemperatureUnit'

    /**
     * Notify on the property 'Property_RequestedTemperatureUnit'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedTemperatureUnit'</b>:
     *
     * This property gives information about the temperature unit requested by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedTemperatureUnitUpReg(Property_RequestedTemperatureUnitCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_RequestedTemperatureUnit'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedTemperatureUnit'</b>:
     *
     * This property gives information about the temperature unit requested by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_RequestedTemperatureUnitUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_RequestedTemperatureUnitRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_RequestedTemperatureUnit'.
     */
    void sendProperty_RequestedTemperatureUnitRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_RequestedTemperatureUnit' (as known by the proxy). This
     * method is only allowed to be called when a status message for this
     * property was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_RequestedTemperatureUnit() returns true.
     *
     * @return the previously received value of the property 'Property_RequestedTemperatureUnit'.
     */
    const Property_RequestedTemperatureUnitStatus& getProperty_RequestedTemperatureUnit() const;

    /**
     * Determines whether a status message for the property 'Property_RequestedTemperatureUnit' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_RequestedTemperatureUnit() const;

    /**
     * Request the value of the property 'Property_RequestedTemperatureUnit'
     * from the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedTemperatureUnit'</b>:
     *
     * This property gives information about the temperature unit requested by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedTemperatureUnitGet(Property_RequestedTemperatureUnitCallbackIF& cb);

    // Property 'Property_RequestedPressureUnit'

    /**
     * Notify on the property 'Property_RequestedPressureUnit'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedPressureUnit'</b>:
     *
     * This property gives information about the pressure unit requested by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedPressureUnitUpReg(Property_RequestedPressureUnitCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_RequestedPressureUnit'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedPressureUnit'</b>:
     *
     * This property gives information about the pressure unit requested by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_RequestedPressureUnitUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_RequestedPressureUnitRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_RequestedPressureUnit'.
     */
    void sendProperty_RequestedPressureUnitRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_RequestedPressureUnit' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_RequestedPressureUnit() returns true.
     *
     * @return the previously received value of the property 'Property_RequestedPressureUnit'.
     */
    const Property_RequestedPressureUnitStatus& getProperty_RequestedPressureUnit() const;

    /**
     * Determines whether a status message for the property 'Property_RequestedPressureUnit' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_RequestedPressureUnit() const;

    /**
     * Request the value of the property 'Property_RequestedPressureUnit' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedPressureUnit'</b>:
     *
     * This property gives information about the pressure unit requested by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedPressureUnitGet(Property_RequestedPressureUnitCallbackIF& cb);

    // Property 'Property_SupportedLangSyncMode'

    /**
     * Notify on the property 'Property_SupportedLangSyncMode'. This method
     * sends a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SupportedLangSyncMode'</b>:
     *
     * This property gives information about the language synchronization modes supported by the meter.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SupportedLangSyncModeUpReg(Property_SupportedLangSyncModeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_SupportedLangSyncMode'.
     * This method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SupportedLangSyncMode'</b>:
     *
     * This property gives information about the language synchronization modes supported by the meter.
     *
     * @param act The act which was previously returned by the
     * sendProperty_SupportedLangSyncModeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_SupportedLangSyncModeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_SupportedLangSyncMode'.
     */
    void sendProperty_SupportedLangSyncModeRelUpRegAll ();

    /**
     * Returns the current value of the property
     * 'Property_SupportedLangSyncMode' (as known by the proxy). This method
     * is only allowed to be called when a status message for this property
     * was received before. Otherwise the behavior of this method is
     * undefined. It is safe to call this method when
     * hasProperty_SupportedLangSyncMode() returns true.
     *
     * @return the previously received value of the property 'Property_SupportedLangSyncMode'.
     */
    const Property_SupportedLangSyncModeStatus& getProperty_SupportedLangSyncMode() const;

    /**
     * Determines whether a status message for the property 'Property_SupportedLangSyncMode' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_SupportedLangSyncMode() const;

    /**
     * Request the value of the property 'Property_SupportedLangSyncMode' from
     * the CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_SupportedLangSyncMode'</b>:
     *
     * This property gives information about the language synchronization modes supported by the meter.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SupportedLangSyncModeGet(Property_SupportedLangSyncModeCallbackIF& cb);

    // Property 'Property_RequestedLanguage'

    /**
     * Notify on the property 'Property_RequestedLanguage'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedLanguage'</b>:
     *
     * <p>This property gives information about the language requested by the meter.</p>
     * <p>A language request of the meter will only lead to a modificaion of the
     * LCN language when the language selection in LCN is set to automatic mode.</p>
     * <p>The result of a request with a language value unequal to "Unknown"
     * has to be reported by method SetRequestedLanguageResult.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedLanguageUpReg(Property_RequestedLanguageCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_RequestedLanguage'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedLanguage'</b>:
     *
     * <p>This property gives information about the language requested by the meter.</p>
     * <p>A language request of the meter will only lead to a modificaion of the
     * LCN language when the language selection in LCN is set to automatic mode.</p>
     * <p>The result of a request with a language value unequal to "Unknown"
     * has to be reported by method SetRequestedLanguageResult.</p>
     *
     * @param act The act which was previously returned by the
     * sendProperty_RequestedLanguageUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_RequestedLanguageRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_RequestedLanguage'.
     */
    void sendProperty_RequestedLanguageRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_RequestedLanguage'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_RequestedLanguage() returns true.
     *
     * @return the previously received value of the property 'Property_RequestedLanguage'.
     */
    const Property_RequestedLanguageStatus& getProperty_RequestedLanguage() const;

    /**
     * Determines whether a status message for the property 'Property_RequestedLanguage' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_RequestedLanguage() const;

    /**
     * Request the value of the property 'Property_RequestedLanguage' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_RequestedLanguage'</b>:
     *
     * <p>This property gives information about the language requested by the meter.</p>
     * <p>A language request of the meter will only lead to a modificaion of the
     * LCN language when the language selection in LCN is set to automatic mode.</p>
     * <p>The result of a request with a language value unequal to "Unknown"
     * has to be reported by method SetRequestedLanguageResult.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_RequestedLanguageGet(Property_RequestedLanguageCallbackIF& cb);

    // Property 'Property_SetAudioSourceInfo'

    /**
     * Notify on the property 'Property_SetAudioSourceInfo'. This method sends
     * a UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SetAudioSourceInfo'</b>:
     *
     * <p>This property is used to transmit the information about the current audio source.</p>
     * <p>As there is always only one audio source active at the same time, a switching of the audio
     * source will just end up in sending one method containing the current data of the new source.</p>
     * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
     * <p>The data differ according to the current type of source. Therefore, they will be transmitted
     * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SetAudioSourceInfoUpReg(Property_SetAudioSourceInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_SetAudioSourceInfo'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SetAudioSourceInfo'</b>:
     *
     * <p>This property is used to transmit the information about the current audio source.</p>
     * <p>As there is always only one audio source active at the same time, a switching of the audio
     * source will just end up in sending one method containing the current data of the new source.</p>
     * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
     * <p>The data differ according to the current type of source. Therefore, they will be transmitted
     * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
     *
     * @param act The act which was previously returned by the
     * sendProperty_SetAudioSourceInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_SetAudioSourceInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_SetAudioSourceInfo'.
     */
    void sendProperty_SetAudioSourceInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_SetAudioSourceInfo'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_SetAudioSourceInfo() returns true.
     *
     * @return the previously received value of the property 'Property_SetAudioSourceInfo'.
     */
    const Property_SetAudioSourceInfoStatus& getProperty_SetAudioSourceInfo() const;

    /**
     * Determines whether a status message for the property 'Property_SetAudioSourceInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_SetAudioSourceInfo() const;

    /**
     * Set the value of the property 'Property_SetAudioSourceInfo'. This
     * method sends a Set message to the CCA server.
     *
     * <b>Documentation of 'Property_SetAudioSourceInfo'</b>:
     *
     * <p>This property is used to transmit the information about the current audio source.</p>
     * <p>As there is always only one audio source active at the same time, a switching of the audio
     * source will just end up in sending one method containing the current data of the new source.</p>
     * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
     * <p>The data differ according to the current type of source. Therefore, they will be transmitted
     * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SetAudioSourceInfoSet(Property_SetAudioSourceInfoCallbackIF& cb);

    // Property 'Property_SetNaviSwipe'

    /**
     * Notify on the property 'Property_SetNaviSwipe'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SetNaviSwipe'</b>:
     *
     * This Property is used to trigger Swipe Command to Meter
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SetNaviSwipeUpReg(Property_SetNaviSwipeCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_SetNaviSwipe'. This method
     * sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SetNaviSwipe'</b>:
     *
     * This Property is used to trigger Swipe Command to Meter
     *
     * @param act The act which was previously returned by the
     * sendProperty_SetNaviSwipeUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_SetNaviSwipeRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_SetNaviSwipe'.
     */
    void sendProperty_SetNaviSwipeRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_SetNaviSwipe' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_SetNaviSwipe() returns true.
     *
     * @return the previously received value of the property 'Property_SetNaviSwipe'.
     */
    const Property_SetNaviSwipeStatus& getProperty_SetNaviSwipe() const;

    /**
     * Determines whether a status message for the property 'Property_SetNaviSwipe' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_SetNaviSwipe() const;

    /**
     * Set the value of the property 'Property_SetNaviSwipe'. This method
     * sends a Set message to the CCA server.
     *
     * <b>Documentation of 'Property_SetNaviSwipe'</b>:
     *
     * This Property is used to trigger Swipe Command to Meter
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Set message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SetNaviSwipeSet(Property_SetNaviSwipeCallbackIF& cb);

    // Property 'Property_SmsSendStatus'

    /**
     * Notify on the property 'Property_SmsSendStatus'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SmsSendStatus'</b>:
     *
     * This property gives information about state of sending SMSs.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_SmsSendStatusUpReg(Property_SmsSendStatusCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_SmsSendStatus'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_SmsSendStatus'</b>:
     *
     * This property gives information about state of sending SMSs.
     *
     * @param act The act which was previously returned by the
     * sendProperty_SmsSendStatusUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_SmsSendStatusRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_SmsSendStatus'.
     */
    void sendProperty_SmsSendStatusRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_SmsSendStatus' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_SmsSendStatus() returns true.
     *
     * @return the previously received value of the property 'Property_SmsSendStatus'.
     */
    const Property_SmsSendStatusStatus& getProperty_SmsSendStatus() const;

    /**
     * Determines whether a status message for the property 'Property_SmsSendStatus' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_SmsSendStatus() const;

    // Property 'Property_HMIStatusBarInfo'

    /**
     * Notify on the property 'Property_HMIStatusBarInfo'. This method sends a
     * UpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_HMIStatusBarInfo'</b>:
     *
     * This property gives information about the content of the status header to be displayed on the Head Unit.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_HMIStatusBarInfoUpReg(Property_HMIStatusBarInfoCallbackIF& cb);

    /**
     * Remove the notifcation on property 'Property_HMIStatusBarInfo'. This
     * method sends a RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'Property_HMIStatusBarInfo'</b>:
     *
     * This property gives information about the content of the status header to be displayed on the Head Unit.
     *
     * @param act The act which was previously returned by the
     * sendProperty_HMIStatusBarInfoUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendProperty_HMIStatusBarInfoRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'Property_HMIStatusBarInfo'.
     */
    void sendProperty_HMIStatusBarInfoRelUpRegAll ();

    /**
     * Returns the current value of the property 'Property_HMIStatusBarInfo'
     * (as known by the proxy). This method is only allowed to be called when
     * a status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasProperty_HMIStatusBarInfo() returns true.
     *
     * @return the previously received value of the property 'Property_HMIStatusBarInfo'.
     */
    const Property_HMIStatusBarInfoStatus& getProperty_HMIStatusBarInfo() const;

    /**
     * Determines whether a status message for the property 'Property_HMIStatusBarInfo' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasProperty_HMIStatusBarInfo() const;

    /**
     * Request the value of the property 'Property_HMIStatusBarInfo' from the
     * CCA server. This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'Property_HMIStatusBarInfo'</b>:
     *
     * This property gives information about the content of the status header to be displayed on the Head Unit.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendProperty_HMIStatusBarInfoGet(Property_HMIStatusBarInfoCallbackIF& cb);

    // Property 'SMSSettings'

    /**
     * Notify on the property 'SMSSettings'. This method sends a UpReg message
     * to the CCA server.
     *
     * <b>Documentation of 'SMSSettings'</b>:
     *
     * This property gives information about the content of the status header to be displayed on the Head Unit.
     *
     * @param cb this callback will be called when any Status or Error
     * messages are received in return to the UpReg message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSMSSettingsUpReg(SMSSettingsCallbackIF& cb);

    /**
     * Remove the notifcation on property 'SMSSettings'. This method sends a
     * RelUpReg message to the CCA server.
     *
     * <b>Documentation of 'SMSSettings'</b>:
     *
     * This property gives information about the content of the status header to be displayed on the Head Unit.
     *
     * @param act The act which was previously returned by the
     * sendSMSSettingsUpReg() method.
     *
     *
     * @return true, if the act was valid and the RelUpReg was done
     */
    bool sendSMSSettingsRelUpReg(act_t act);

    /**
     * Send ReulUpReg messages for all registrations on property 'SMSSettings'.
     */
    void sendSMSSettingsRelUpRegAll ();

    /**
     * Returns the current value of the property 'SMSSettings' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasSMSSettings() returns true.
     *
     * @return the previously received value of the property 'SMSSettings'.
     */
    const SMSSettingsStatus& getSMSSettings() const;

    /**
     * Determines whether a status message for the property 'SMSSettings' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSMSSettings() const;

    /**
     * Request the value of the property 'SMSSettings' from the CCA server.
     * This method sends a Get message to the CCA server.
     *
     * <b>Documentation of 'SMSSettings'</b>:
     *
     * This property gives information about the content of the status header to be displayed on the Head Unit.
     *
     * @param cb this callback will be called when a Status or Error message
     * is received in return to the Get message.
     *
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSMSSettingsGet(SMSSettingsCallbackIF& cb);

    /**
     * Release all property notifications (on all properties).
     */
    void sendRelUpRegAll ();

private:

    Datacollector_main_fiProxy (const std::string& portName, uint16 appId, uint16 majorVersion, uint16 minorVersion, ::asf::core::ServiceAvailableIF& serviceAvailable, uint32 flags);

    virtual void clearAllProperties ();

    ::boost::shared_ptr< ::asf::cca::CcaProxyCallback > createCallback (uint16 fid, ::asf::cca::CcaTypes::ServiceData::OpCode opCode, uint16 commandCounter, void* cb);

    // Property 'Property_Connection'

    ::asf::core::nullable< Property_ConnectionStatus > _property_Connection;

    // Property 'Property_Configuration'

    ::asf::core::nullable< Property_ConfigurationStatus > _property_Configuration;

    // Property 'Property_HardwareVersion'

    ::asf::core::nullable< Property_HardwareVersionStatus > _property_HardwareVersion;

    // Property 'Property_SoftwareVersion'

    ::asf::core::nullable< Property_SoftwareVersionStatus > _property_SoftwareVersion;

    // Property 'Property_DataTransmission'

    ::asf::core::nullable< Property_DataTransmissionStatus > _property_DataTransmission;

    // Property 'Property_CurrentMeterSettings'

    ::asf::core::nullable< Property_CurrentMeterSettingsStatus > _property_CurrentMeterSettings;

    // Property 'Property_AvailableFuelConsumptionUnits'

    ::asf::core::nullable< Property_AvailableFuelConsumptionUnitsStatus > _property_AvailableFuelConsumptionUnits;

    // Property 'Property_AvailableTemperatureUnits'

    ::asf::core::nullable< Property_AvailableTemperatureUnitsStatus > _property_AvailableTemperatureUnits;

    // Property 'Property_AvailablePressureUnits'

    ::asf::core::nullable< Property_AvailablePressureUnitsStatus > _property_AvailablePressureUnits;

    // Property 'Property_RequestedFuelConsumptionUnit'

    ::asf::core::nullable< Property_RequestedFuelConsumptionUnitStatus > _property_RequestedFuelConsumptionUnit;

    // Property 'Property_RequestedTemperatureUnit'

    ::asf::core::nullable< Property_RequestedTemperatureUnitStatus > _property_RequestedTemperatureUnit;

    // Property 'Property_RequestedPressureUnit'

    ::asf::core::nullable< Property_RequestedPressureUnitStatus > _property_RequestedPressureUnit;

    // Property 'Property_SupportedLangSyncMode'

    ::asf::core::nullable< Property_SupportedLangSyncModeStatus > _property_SupportedLangSyncMode;

    // Property 'Property_RequestedLanguage'

    ::asf::core::nullable< Property_RequestedLanguageStatus > _property_RequestedLanguage;

    // Property 'Property_SetAudioSourceInfo'

    ::asf::core::nullable< Property_SetAudioSourceInfoStatus > _property_SetAudioSourceInfo;

    // Property 'Property_SetNaviSwipe'

    ::asf::core::nullable< Property_SetNaviSwipeStatus > _property_SetNaviSwipe;

    // Property 'Property_SmsSendStatus'

    ::asf::core::nullable< Property_SmsSendStatusStatus > _property_SmsSendStatus;

    // Property 'Property_HMIStatusBarInfo'

    ::asf::core::nullable< Property_HMIStatusBarInfoStatus > _property_HMIStatusBarInfo;

    // Property 'SMSSettings'

    ::asf::core::nullable< SMSSettingsStatus > _sMSSettings;

    DECLARE_CLASS_LOGGER();

    friend class Datacollector_main_fiProxyCallback;
};

} // namespace datacollector_main_fi

#endif // DATACOLLECTOR_MAIN_FIPROXY_H
