#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DATACOLLECTOR_MAIN_FI_H
#define DATACOLLECTOR_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "datacollector_main_fi_types.h"
#include "datacollector_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'datacollector_main_fi'
 *
 * Fullname: Datacollector MIDW component's Functional Interface
 *
 * Version: $Revision:   1.0.1  $
 *
 * Author: Suman Kaup
 *
 * Date: $Date:  31.03.2015  $
 *
 * Department:
 *
 * Title: datacollector_main_fi
 *
 * <b>Description of 'datacollector_main_fi':</b>
 *
 * ..
 */

namespace datacollector_main_fi {

static const int SERVICE_ID = 191;

static const int FID_Property_Connection = 1;

static const int FID_Property_Configuration = 2;

static const int FID_Property_HardwareVersion = 3;

static const int FID_Property_SoftwareVersion = 4;

static const int FID_Property_DataTransmission = 5;

static const int FID_Method_TriggerVersionInfotoMeter = 6;

static const int FID_Property_CurrentMeterSettings = 4097;

static const int FID_Property_AvailableFuelConsumptionUnits = 4113;

static const int FID_Property_AvailableTemperatureUnits = 4114;

static const int FID_Property_AvailablePressureUnits = 4115;

static const int FID_Property_RequestedFuelConsumptionUnit = 4121;

static const int FID_Property_RequestedTemperatureUnit = 4122;

static const int FID_Property_RequestedPressureUnit = 4123;

static const int FID_Property_SupportedLangSyncMode = 4124;

static const int FID_Method_SetHMIDistanceUnit = 4128;

static const int FID_Method_SetHMIFuelConsumptionUnit = 4129;

static const int FID_Method_SetHMITemperatureUnit = 4130;

static const int FID_Method_SetHMIPressureUnit = 4131;

static const int FID_Property_RequestedLanguage = 4144;

static const int FID_Method_SetRequestedLanguageResult = 4145;

static const int FID_Method_GetMeterLanguage = 4146;

static const int FID_Method_GetLanguageSettingsRequestfromLCN = 4147;

static const int FID_Method_SetLanguageSettingsfromLCN = 4148;

static const int FID_Method_GetLanguageAvailability = 4150;

static const int FID_Method_SetMeterLanguage = 4151;

static const int FID_Method_SetAudioSourceInfo = 8193;

static const int FID_Method_SetAudioWarning = 8194;

static const int FID_Method_SetAudioSpecialMode = 8195;

static const int FID_Method_SetMediaBrowserList_HighlightedElement = 8196;

static const int FID_Method_CurrentHeadUnitTunerMode = 8199;

static const int FID_Method_RenaultUpdateListStatus = 8208;

static const int FID_Property_SetAudioSourceInfo = 8449;

static const int FID_Property_SetNaviSwipe = 12307;

static const int FID_SetPhoneIncomingCallInfo = 20481;

static const int FID_Property_SmsSendStatus = 20482;

static const int FID_SetPhoneWaitingModeSetting = 20483;

static const int FID_SetPhonePrivateModeSettings = 20484;

static const int FID_SetIsWaitmodeSupportedByPhone = 20485;

static const int FID_SetVoiceRecognitionStatus = 24577;

static const int FID_Property_HMIStatusBarInfo = 28673;

static const int FID_SetInterrupt_to_Meter = 36880;

static const int FID_SMSSettings = 32769;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 1;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 1;

// forward declarations
class Property_ConnectionStatus;

class Property_ConfigurationStatus;

class Property_HardwareVersionStatus;

class Property_SoftwareVersionStatus;

class Property_DataTransmissionStatus;

class Method_TriggerVersionInfotoMeterStart;

class Property_CurrentMeterSettingsStatus;

class Property_AvailableFuelConsumptionUnitsStatus;

class Property_AvailableTemperatureUnitsStatus;

class Property_AvailablePressureUnitsStatus;

class Property_RequestedFuelConsumptionUnitStatus;

class Property_RequestedTemperatureUnitStatus;

class Property_RequestedPressureUnitStatus;

class Property_SupportedLangSyncModeStatus;

class Method_SetHMIDistanceUnitStart;

class Method_SetHMIFuelConsumptionUnitStart;

class Method_SetHMITemperatureUnitStart;

class Method_SetHMIPressureUnitStart;

class Property_RequestedLanguageStatus;

class Method_SetRequestedLanguageResultStart;

class Method_GetMeterLanguageResult;

class Method_GetLanguageSettingsRequestfromLCNResult;

class Method_GetLanguageSettingsRequestfromLCNErrorStructure;

class Method_GetLanguageSettingsRequestfromLCNError;

class Method_SetLanguageSettingsfromLCNStart;

class Method_SetLanguageSettingsfromLCNErrorStructure;

class Method_SetLanguageSettingsfromLCNError;

class Method_GetLanguageAvailabilityStart;

class Method_GetLanguageAvailabilityResult;

class Method_GetLanguageAvailabilityErrorStructure;

class Method_GetLanguageAvailabilityError;

class Method_SetMeterLanguageStart;

class Method_SetMeterLanguageResult;

class Method_SetMeterLanguageErrorStructure;

class Method_SetMeterLanguageError;

class Method_SetAudioSourceInfoStart;

class Method_SetAudioWarningStart;

class Method_SetAudioSpecialModeStart;

class Method_SetMediaBrowserList_HighlightedElementStart;

class Method_CurrentHeadUnitTunerModeStart;

class Method_RenaultUpdateListStatusStart;

class Property_SetAudioSourceInfoStatus;

class Property_SetNaviSwipeStatus;

class SetPhoneIncomingCallInfoStart;

class Property_SmsSendStatusStatus;

class SetPhoneWaitingModeSettingStart;

class SetPhonePrivateModeSettingsStart;

class SetIsWaitmodeSupportedByPhoneStart;

class SetVoiceRecognitionStatusStart;

class Property_HMIStatusBarInfoStatus;

class SetInterrupt_to_MeterStart;

class SMSSettingsStatus;

// type definitions
/**
 * The get message of the property "Property_Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_ConnectionGet;

/**
 * The upreg message of the property "Property_Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_ConnectionUpReg;

/**
 * The relUpReg message of the property "Property_Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_ConnectionRelUpReg;

/**
 * The error message of 'Property_Connection'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_ConnectionError;

/**
 * The get message of the property "Property_Configuration"
 * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
 * <p>We can only communicate with a unit when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_ConfigurationGet;

/**
 * The upreg message of the property "Property_Configuration"
 * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
 * <p>We can only communicate with a unit when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_ConfigurationUpReg;

/**
 * The relUpReg message of the property "Property_Configuration"
 * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
 * <p>We can only communicate with a unit when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_ConfigurationRelUpReg;

/**
 * The error message of 'Property_Configuration'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_ConfigurationError;

/**
 * The get message of the property "Property_HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_HardwareVersionGet;

/**
 * The upreg message of the property "Property_HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_HardwareVersionUpReg;

/**
 * The relUpReg message of the property "Property_HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_HardwareVersionRelUpReg;

/**
 * The error message of 'Property_HardwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_HardwareVersionError;

/**
 * The get message of the property "Property_SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SoftwareVersionGet;

/**
 * The upreg message of the property "Property_SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SoftwareVersionUpReg;

/**
 * The relUpReg message of the property "Property_SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SoftwareVersionRelUpReg;

/**
 * The error message of 'Property_SoftwareVersion'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_SoftwareVersionError;

/**
 * The get message of the property "Property_DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_DataTransmissionGet;

/**
 * The upreg message of the property "Property_DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_DataTransmissionUpReg;

/**
 * The relUpReg message of the property "Property_DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_DataTransmissionRelUpReg;

/**
 * The error message of 'Property_DataTransmission'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_DataTransmissionError;

/**
 * The result message of the method "Method_TriggerVersionInfotoMeter"
 * <p>This method is used to Trigger the GET for Version Info to FC_Meter.</p>
 * <p>This method is used as a Internal Communication between HALL_Applications, DC and FC_Meter.</p>
 * <p>This will result in Trigger of MCAN Message to GET the Hardware and Software Version</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_TriggerVersionInfotoMeterResult;

/**
 * The abort error message of the method "Method_TriggerVersionInfotoMeter"
 * <p>This method is used to Trigger the GET for Version Info to FC_Meter.</p>
 * <p>This method is used as a Internal Communication between HALL_Applications, DC and FC_Meter.</p>
 * <p>This will result in Trigger of MCAN Message to GET the Hardware and Software Version</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_TriggerVersionInfotoMeterAbortError;

/**
 * The error message of 'Method_TriggerVersionInfotoMeter'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_TriggerVersionInfotoMeterError;

/**
 * The get message of the property "Property_CurrentMeterSettings"
 * This property gives information about the current settings of the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_CurrentMeterSettingsGet;

/**
 * The upreg message of the property "Property_CurrentMeterSettings"
 * This property gives information about the current settings of the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_CurrentMeterSettingsUpReg;

/**
 * The relUpReg message of the property "Property_CurrentMeterSettings"
 * This property gives information about the current settings of the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_CurrentMeterSettingsRelUpReg;

/**
 * The error message of 'Property_CurrentMeterSettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_CurrentMeterSettingsError;

/**
 * The get message of the property "Property_AvailableFuelConsumptionUnits"
 * This property gives information about fuel consumption units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailableFuelConsumptionUnitsGet;

/**
 * The upreg message of the property "Property_AvailableFuelConsumptionUnits"
 * This property gives information about fuel consumption units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailableFuelConsumptionUnitsUpReg;

/**
 * The relUpReg message of the property "Property_AvailableFuelConsumptionUnits"
 * This property gives information about fuel consumption units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailableFuelConsumptionUnitsRelUpReg;

/**
 * The error message of 'Property_AvailableFuelConsumptionUnits'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_AvailableFuelConsumptionUnitsError;

/**
 * The get message of the property "Property_AvailableTemperatureUnits"
 * This property gives information about temperature units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailableTemperatureUnitsGet;

/**
 * The upreg message of the property "Property_AvailableTemperatureUnits"
 * This property gives information about temperature units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailableTemperatureUnitsUpReg;

/**
 * The relUpReg message of the property "Property_AvailableTemperatureUnits"
 * This property gives information about temperature units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailableTemperatureUnitsRelUpReg;

/**
 * The error message of 'Property_AvailableTemperatureUnits'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_AvailableTemperatureUnitsError;

/**
 * The get message of the property "Property_AvailablePressureUnits"
 * This property gives information about pressure units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailablePressureUnitsGet;

/**
 * The upreg message of the property "Property_AvailablePressureUnits"
 * This property gives information about pressure units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailablePressureUnitsUpReg;

/**
 * The relUpReg message of the property "Property_AvailablePressureUnits"
 * This property gives information about pressure units supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_AvailablePressureUnitsRelUpReg;

/**
 * The error message of 'Property_AvailablePressureUnits'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_AvailablePressureUnitsError;

/**
 * The get message of the property "Property_RequestedFuelConsumptionUnit"
 * This property gives information about the fuel consumption unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedFuelConsumptionUnitGet;

/**
 * The upreg message of the property "Property_RequestedFuelConsumptionUnit"
 * This property gives information about the fuel consumption unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedFuelConsumptionUnitUpReg;

/**
 * The relUpReg message of the property "Property_RequestedFuelConsumptionUnit"
 * This property gives information about the fuel consumption unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedFuelConsumptionUnitRelUpReg;

/**
 * The error message of 'Property_RequestedFuelConsumptionUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_RequestedFuelConsumptionUnitError;

/**
 * The get message of the property "Property_RequestedTemperatureUnit"
 * This property gives information about the temperature unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedTemperatureUnitGet;

/**
 * The upreg message of the property "Property_RequestedTemperatureUnit"
 * This property gives information about the temperature unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedTemperatureUnitUpReg;

/**
 * The relUpReg message of the property "Property_RequestedTemperatureUnit"
 * This property gives information about the temperature unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedTemperatureUnitRelUpReg;

/**
 * The error message of 'Property_RequestedTemperatureUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_RequestedTemperatureUnitError;

/**
 * The get message of the property "Property_RequestedPressureUnit"
 * This property gives information about the pressure unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedPressureUnitGet;

/**
 * The upreg message of the property "Property_RequestedPressureUnit"
 * This property gives information about the pressure unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedPressureUnitUpReg;

/**
 * The relUpReg message of the property "Property_RequestedPressureUnit"
 * This property gives information about the pressure unit requested by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedPressureUnitRelUpReg;

/**
 * The error message of 'Property_RequestedPressureUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_RequestedPressureUnitError;

/**
 * The get message of the property "Property_SupportedLangSyncMode"
 * This property gives information about the language synchronization modes supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SupportedLangSyncModeGet;

/**
 * The upreg message of the property "Property_SupportedLangSyncMode"
 * This property gives information about the language synchronization modes supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SupportedLangSyncModeUpReg;

/**
 * The relUpReg message of the property "Property_SupportedLangSyncMode"
 * This property gives information about the language synchronization modes supported by the meter.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SupportedLangSyncModeRelUpReg;

/**
 * The error message of 'Property_SupportedLangSyncMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_SupportedLangSyncModeError;

/**
 * The result message of the method "Method_SetHMIDistanceUnit"
 * This method is used to transmit the current distance unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetHMIDistanceUnitResult;

/**
 * The abort error message of the method "Method_SetHMIDistanceUnit"
 * This method is used to transmit the current distance unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMIDistanceUnitAbortError;

/**
 * The error message of 'Method_SetHMIDistanceUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMIDistanceUnitError;

/**
 * The result message of the method "Method_SetHMIFuelConsumptionUnit"
 * This method is used to transmit the current fuel consumption unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetHMIFuelConsumptionUnitResult;

/**
 * The abort error message of the method "Method_SetHMIFuelConsumptionUnit"
 * This method is used to transmit the current fuel consumption unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMIFuelConsumptionUnitAbortError;

/**
 * The error message of 'Method_SetHMIFuelConsumptionUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMIFuelConsumptionUnitError;

/**
 * The result message of the method "Method_SetHMITemperatureUnit"
 * This method is used to transmit the current temperature unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetHMITemperatureUnitResult;

/**
 * The abort error message of the method "Method_SetHMITemperatureUnit"
 * This method is used to transmit the current temperature unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMITemperatureUnitAbortError;

/**
 * The error message of 'Method_SetHMITemperatureUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMITemperatureUnitError;

/**
 * The result message of the method "Method_SetHMIPressureUnit"
 * This method is used to transmit the current pressure unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetHMIPressureUnitResult;

/**
 * The abort error message of the method "Method_SetHMIPressureUnit"
 * This method is used to transmit the current pressure unit used in the HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMIPressureUnitAbortError;

/**
 * The error message of 'Method_SetHMIPressureUnit'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetHMIPressureUnitError;

/**
 * The get message of the property "Property_RequestedLanguage"
 * <p>This property gives information about the language requested by the meter.</p>
 * <p>A language request of the meter will only lead to a modificaion of the
 * LCN language when the language selection in LCN is set to automatic mode.</p>
 * <p>The result of a request with a language value unequal to "Unknown"
 * has to be reported by method SetRequestedLanguageResult.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedLanguageGet;

/**
 * The upreg message of the property "Property_RequestedLanguage"
 * <p>This property gives information about the language requested by the meter.</p>
 * <p>A language request of the meter will only lead to a modificaion of the
 * LCN language when the language selection in LCN is set to automatic mode.</p>
 * <p>The result of a request with a language value unequal to "Unknown"
 * has to be reported by method SetRequestedLanguageResult.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedLanguageUpReg;

/**
 * The relUpReg message of the property "Property_RequestedLanguage"
 * <p>This property gives information about the language requested by the meter.</p>
 * <p>A language request of the meter will only lead to a modificaion of the
 * LCN language when the language selection in LCN is set to automatic mode.</p>
 * <p>The result of a request with a language value unequal to "Unknown"
 * has to be reported by method SetRequestedLanguageResult.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_RequestedLanguageRelUpReg;

/**
 * The error message of 'Property_RequestedLanguage'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_RequestedLanguageError;

/**
 * The result message of the method "Method_SetRequestedLanguageResult"
 * This method is used to report the result of a former language request.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetRequestedLanguageResultResult;

/**
 * The abort error message of the method "Method_SetRequestedLanguageResult"
 * This method is used to report the result of a former language request.
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetRequestedLanguageResultAbortError;

/**
 * The error message of 'Method_SetRequestedLanguageResult'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetRequestedLanguageResultError;

/**
 * The start message of the method "Method_GetMeterLanguage"
 * This method is used to ask the meter explicitly for its current language.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_GetMeterLanguageStart;

/**
 * The abort error message of the method "Method_GetMeterLanguage"
 * This method is used to ask the meter explicitly for its current language.
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_GetMeterLanguageAbortError;

/**
 * The error message of 'Method_GetMeterLanguage'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_GetMeterLanguageError;

/**
 * The start message of the method "Method_GetLanguageSettingsRequestfromLCN"
 * This method is called by ITM when there is a switching to language settings screen in ITM (MCAN Fct Id:606h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_GetLanguageSettingsRequestfromLCNStart;

/**
 * The abort error message of the method "Method_GetLanguageSettingsRequestfromLCN"
 * This method is called by ITM when there is a switching to language settings screen in ITM (MCAN Fct Id:606h).
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_GetLanguageSettingsRequestfromLCNAbortError;

/**
 * The result message of the method "Method_SetLanguageSettingsfromLCN"
 * This method is called by ITM when there is change in Language from ITM side(MCAN Fct Id:606h).
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetLanguageSettingsfromLCNResult;

/**
 * The abort error message of the method "Method_SetLanguageSettingsfromLCN"
 * This method is called by ITM when there is change in Language from ITM side(MCAN Fct Id:606h).
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetLanguageSettingsfromLCNAbortError;

/**
 * The abort error message of the method "Method_GetLanguageAvailability"
 * This Method is called by the client to know the language availability in the Meter
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_GetLanguageAvailabilityAbortError;

/**
 * The abort error message of the method "Method_SetMeterLanguage"
 * This Method is called by the client to set language in the Meter
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetMeterLanguageAbortError;

/**
 * The result message of the method "Method_SetAudioSourceInfo"
 * <p>This method is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetAudioSourceInfoResult;

/**
 * The abort error message of the method "Method_SetAudioSourceInfo"
 * <p>This method is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetAudioSourceInfoAbortError;

/**
 * The error message of 'Method_SetAudioSourceInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetAudioSourceInfoError;

/**
 * The result message of the method "Method_SetAudioWarning"
 * <p>This method is used to transmit the information about an audio warning.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetAudioWarningResult;

/**
 * The abort error message of the method "Method_SetAudioWarning"
 * <p>This method is used to transmit the information about an audio warning.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetAudioWarningAbortError;

/**
 * The error message of 'Method_SetAudioWarning'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetAudioWarningError;

/**
 * The result message of the method "Method_SetAudioSpecialMode"
 * <p>This method is used to transmit the information about a currently active special audio mode
 * (Scan, Search, FastForward, Rewind).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetAudioSpecialModeResult;

/**
 * The abort error message of the method "Method_SetAudioSpecialMode"
 * <p>This method is used to transmit the information about a currently active special audio mode
 * (Scan, Search, FastForward, Rewind).</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetAudioSpecialModeAbortError;

/**
 * The error message of 'Method_SetAudioSpecialMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetAudioSpecialModeError;

/**
 * The result message of the method "Method_SetMediaBrowserList_HighlightedElement"
 * <p>This method is used to show what's been highlighted in HMI media browser list and about which input device is been used for doing the same.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_SetMediaBrowserList_HighlightedElementResult;

/**
 * The abort error message of the method "Method_SetMediaBrowserList_HighlightedElement"
 * <p>This method is used to show what's been highlighted in HMI media browser list and about which input device is been used for doing the same.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetMediaBrowserList_HighlightedElementAbortError;

/**
 * The error message of 'Method_SetMediaBrowserList_HighlightedElement'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_SetMediaBrowserList_HighlightedElementError;

/**
 * The result message of the method "Method_CurrentHeadUnitTunerMode"
 * <p>This method is used to show which Tuner HMI mode is shown. The options include List, Frequency, and Preset.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_CurrentHeadUnitTunerModeResult;

/**
 * The abort error message of the method "Method_CurrentHeadUnitTunerMode"
 * <p>This method is used to show which Tuner HMI mode is shown. The options include List, Frequency, and Preset.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_CurrentHeadUnitTunerModeAbortError;

/**
 * The error message of 'Method_CurrentHeadUnitTunerMode'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_CurrentHeadUnitTunerModeError;

/**
 * The result message of the method "Method_RenaultUpdateListStatus"
 * <p>This method is to provide the status of the "Updating List" from the Renault Tuner screen.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Method_RenaultUpdateListStatusResult;

/**
 * The abort error message of the method "Method_RenaultUpdateListStatus"
 * <p>This method is to provide the status of the "Updating List" from the Renault Tuner screen.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_RenaultUpdateListStatusAbortError;

/**
 * The error message of 'Method_RenaultUpdateListStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError Method_RenaultUpdateListStatusError;

/**
 * The set message of the property "Property_SetAudioSourceInfo"
 * <p>This property is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SetAudioSourceInfoSet;

/**
 * The upreg message of the property "Property_SetAudioSourceInfo"
 * <p>This property is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SetAudioSourceInfoUpReg;

/**
 * The relUpReg message of the property "Property_SetAudioSourceInfo"
 * <p>This property is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SetAudioSourceInfoRelUpReg;

/**
 * The error message of 'Property_SetAudioSourceInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_SetAudioSourceInfoError;

/**
 * The set message of the property "Property_SetNaviSwipe"
 * This Property is used to trigger Swipe Command to Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SetNaviSwipeSet;

/**
 * The upreg message of the property "Property_SetNaviSwipe"
 * This Property is used to trigger Swipe Command to Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SetNaviSwipeUpReg;

/**
 * The relUpReg message of the property "Property_SetNaviSwipe"
 * This Property is used to trigger Swipe Command to Meter
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SetNaviSwipeRelUpReg;

/**
 * The error message of 'Property_SetNaviSwipe'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_SetNaviSwipeError;

/**
 * The result message of the method "SetPhoneIncomingCallInfo"
 * <p>This method is used to transmit the information about a currently received incoming call
 * leading to a popup in the meter instrument analogous to the popup on the LCN main screen.</p>
 * <p>The parameter bIncoming shall be set to "true" as long as the call is incoming (ringing).
 * When it changes to active or end, the parameter shall be set to "false" again.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetPhoneIncomingCallInfoResult;

/**
 * The abort error message of the method "SetPhoneIncomingCallInfo"
 * <p>This method is used to transmit the information about a currently received incoming call
 * leading to a popup in the meter instrument analogous to the popup on the LCN main screen.</p>
 * <p>The parameter bIncoming shall be set to "true" as long as the call is incoming (ringing).
 * When it changes to active or end, the parameter shall be set to "false" again.</p>
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPhoneIncomingCallInfoAbortError;

/**
 * The error message of 'SetPhoneIncomingCallInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPhoneIncomingCallInfoError;

/**
 * The upreg message of the property "Property_SmsSendStatus"
 * This property gives information about state of sending SMSs.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SmsSendStatusUpReg;

/**
 * The relUpReg message of the property "Property_SmsSendStatus"
 * This property gives information about state of sending SMSs.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_SmsSendStatusRelUpReg;

/**
 * The error message of 'Property_SmsSendStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_SmsSendStatusError;

/**
 * The result message of the method "SetPhoneWaitingModeSetting"
 * This method is used to transmit the status of a waiting mode .
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetPhoneWaitingModeSettingResult;

/**
 * The abort error message of the method "SetPhoneWaitingModeSetting"
 * This method is used to transmit the status of a waiting mode .
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPhoneWaitingModeSettingAbortError;

/**
 * The error message of 'SetPhoneWaitingModeSetting'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPhoneWaitingModeSettingError;

/**
 * The result message of the method "SetPhonePrivateModeSettings"
 * This method is used to transmit the status of a Private mode(Driver only profile) set in Phone HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetPhonePrivateModeSettingsResult;

/**
 * The abort error message of the method "SetPhonePrivateModeSettings"
 * This method is used to transmit the status of a Private mode(Driver only profile) set in Phone HMI.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPhonePrivateModeSettingsAbortError;

/**
 * The error message of 'SetPhonePrivateModeSettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetPhonePrivateModeSettingsError;

/**
 * The result message of the method "SetIsWaitmodeSupportedByPhone"
 * This method is used to transmit the status of  whether or not connected phone supports waiting mode feature
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetIsWaitmodeSupportedByPhoneResult;

/**
 * The abort error message of the method "SetIsWaitmodeSupportedByPhone"
 * This method is used to transmit the status of  whether or not connected phone supports waiting mode feature
 */
typedef ::asf::cca::CcaTypes::DefaultError SetIsWaitmodeSupportedByPhoneAbortError;

/**
 * The error message of 'SetIsWaitmodeSupportedByPhone'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetIsWaitmodeSupportedByPhoneError;

/**
 * The result message of the method "SetVoiceRecognitionStatus"
 * This method is used to transmit the status of a currently running voice recognition session
 * leading to a popup in the meter instrument.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetVoiceRecognitionStatusResult;

/**
 * The abort error message of the method "SetVoiceRecognitionStatus"
 * This method is used to transmit the status of a currently running voice recognition session
 * leading to a popup in the meter instrument.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVoiceRecognitionStatusAbortError;

/**
 * The error message of 'SetVoiceRecognitionStatus'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetVoiceRecognitionStatusError;

/**
 * The get message of the property "Property_HMIStatusBarInfo"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_HMIStatusBarInfoGet;

/**
 * The upreg message of the property "Property_HMIStatusBarInfo"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_HMIStatusBarInfoUpReg;

/**
 * The relUpReg message of the property "Property_HMIStatusBarInfo"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage Property_HMIStatusBarInfoRelUpReg;

/**
 * The error message of 'Property_HMIStatusBarInfo'
 */
typedef ::asf::cca::CcaTypes::DefaultError Property_HMIStatusBarInfoError;

/**
 * The result message of the method "SetInterrupt_to_Meter"
 * This method is used to collect the Info rgarding the User Action and whether it is through SWC Key action.
 * The HALL application which gives us the info regarding the User Action should also tell us their Source.
 * And also the Type of the User Action corresponding to their Source.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SetInterrupt_to_MeterResult;

/**
 * The abort error message of the method "SetInterrupt_to_Meter"
 * This method is used to collect the Info rgarding the User Action and whether it is through SWC Key action.
 * The HALL application which gives us the info regarding the User Action should also tell us their Source.
 * And also the Type of the User Action corresponding to their Source.
 */
typedef ::asf::cca::CcaTypes::DefaultError SetInterrupt_to_MeterAbortError;

/**
 * The error message of 'SetInterrupt_to_Meter'
 */
typedef ::asf::cca::CcaTypes::DefaultError SetInterrupt_to_MeterError;

/**
 * The get message of the property "SMSSettings"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMSSettingsGet;

/**
 * The upreg message of the property "SMSSettings"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMSSettingsUpReg;

/**
 * The relUpReg message of the property "SMSSettings"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage SMSSettingsRelUpReg;

/**
 * The error message of 'SMSSettings'
 */
typedef ::asf::cca::CcaTypes::DefaultError SMSSettingsError;


/**
 * The status message of the property "Property_Connection"
 * This property gives information about the connection status to the various MCAN units.
 */
class Property_ConnectionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_ConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  Property_ConnectionStatus (const Property_ConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_ConnectionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& arConnectionStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~Property_ConnectionStatus();

    /**
     * Assignment operator
     */
    inline Property_ConnectionStatus& operator = (const Property_ConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_ConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_ConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_ConnectionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_ConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arConnectionStatusList"

    static const int kArConnectionStatusList = 0;

    /**
     * Clears the field "arConnectionStatusList".
     *
     * The field will be set to its default value. The hasArConnectionStatusList()
     * method will return false.
     */
    inline void clearArConnectionStatusList();

    /**
     * Checks whether the field "arConnectionStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArConnectionStatusList()). Otherwise it will return false.
     */
    inline bool hasArConnectionStatusList () const;

    /**
     * Returns the value of the member "arConnectionStatusList".
     *
     * List with connection status of each MCAN unit.
     *
     * @return The value of the field "arConnectionStatusList"
     */
    inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& getArConnectionStatusList () const;

    /**
     * Retrieves the value of the field "arConnectionStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arConnectionStatusList".
     */
    inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& getArConnectionStatusListMutable ();

    /**
     * Sets the value of the member "arConnectionStatusList".
     *
     * List with connection status of each MCAN unit.
     *
     * @param arConnectionStatusList The value which will be set
     */
    inline void setArConnectionStatusList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& arConnectionStatusList_);

    static const Property_ConnectionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& getT_datacollector_UnitConnectionStatusList_DefaultInstance ();

    inline void set_has_arConnectionStatusList ();

    inline void clear_has_arConnectionStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus > _arConnectionStatusList;

};

/**
 * The status message of the property "Property_Configuration"
 * <p>This property gives information whether the configuration of the various MCAN units are valid for us.</p>
 * <p>We can only communicate with a unit when the configuration is valid.</p>
 * <p>The additional information about the unit ID and the used message version is not really
 * relevant for the communication, but it can be used for debug purposes e.g. in a service menu.</p>
 */
class Property_ConfigurationStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_ConfigurationStatus ();

    /**
     * Copy constructor
     */
    inline  Property_ConfigurationStatus (const Property_ConfigurationStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_ConfigurationStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& arConfigurationList_);

    /**
     * Destructor
     */
    inline virtual  ~Property_ConfigurationStatus();

    /**
     * Assignment operator
     */
    inline Property_ConfigurationStatus& operator = (const Property_ConfigurationStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_ConfigurationStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_ConfigurationStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_ConfigurationStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_ConfigurationStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arConfigurationList"

    static const int kArConfigurationList = 0;

    /**
     * Clears the field "arConfigurationList".
     *
     * The field will be set to its default value. The hasArConfigurationList()
     * method will return false.
     */
    inline void clearArConfigurationList();

    /**
     * Checks whether the field "arConfigurationList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArConfigurationList()). Otherwise it will return false.
     */
    inline bool hasArConfigurationList () const;

    /**
     * Returns the value of the member "arConfigurationList".
     *
     * List with configuration data of each MCAN unit.
     *
     * @return The value of the field "arConfigurationList"
     */
    inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& getArConfigurationList () const;

    /**
     * Retrieves the value of the field "arConfigurationList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arConfigurationList".
     */
    inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& getArConfigurationListMutable ();

    /**
     * Sets the value of the member "arConfigurationList".
     *
     * List with configuration data of each MCAN unit.
     *
     * @param arConfigurationList The value which will be set
     */
    inline void setArConfigurationList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& arConfigurationList_);

    static const Property_ConfigurationStatus &getDefaultInstance();

private:

    static const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& getT_datacollector_UnitConfigurationList_DefaultInstance ();

    inline void set_has_arConfigurationList ();

    inline void clear_has_arConfigurationList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration > _arConfigurationList;

};

/**
 * The status message of the property "Property_HardwareVersion"
 * This property gives information about the hardware version of the various MCAN units.
 */
class Property_HardwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_HardwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  Property_HardwareVersionStatus (const Property_HardwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_HardwareVersionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arHardwareVersionList_);

    /**
     * Destructor
     */
    inline virtual  ~Property_HardwareVersionStatus();

    /**
     * Assignment operator
     */
    inline Property_HardwareVersionStatus& operator = (const Property_HardwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_HardwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_HardwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_HardwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_HardwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arHardwareVersionList"

    static const int kArHardwareVersionList = 0;

    /**
     * Clears the field "arHardwareVersionList".
     *
     * The field will be set to its default value. The hasArHardwareVersionList()
     * method will return false.
     */
    inline void clearArHardwareVersionList();

    /**
     * Checks whether the field "arHardwareVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArHardwareVersionList()). Otherwise it will return false.
     */
    inline bool hasArHardwareVersionList () const;

    /**
     * Returns the value of the member "arHardwareVersionList".
     *
     * List with hardware version of each MCAN unit.
     *
     * @return The value of the field "arHardwareVersionList"
     */
    inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& getArHardwareVersionList () const;

    /**
     * Retrieves the value of the field "arHardwareVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arHardwareVersionList".
     */
    inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& getArHardwareVersionListMutable ();

    /**
     * Sets the value of the member "arHardwareVersionList".
     *
     * List with hardware version of each MCAN unit.
     *
     * @param arHardwareVersionList The value which will be set
     */
    inline void setArHardwareVersionList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arHardwareVersionList_);

    static const Property_HardwareVersionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& getT_datacollector_UnitVersionList_DefaultInstance ();

    inline void set_has_arHardwareVersionList ();

    inline void clear_has_arHardwareVersionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion > _arHardwareVersionList;

};

/**
 * The status message of the property "Property_SoftwareVersion"
 * This property gives information about the software version of the various MCAN units.
 */
class Property_SoftwareVersionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_SoftwareVersionStatus ();

    /**
     * Copy constructor
     */
    inline  Property_SoftwareVersionStatus (const Property_SoftwareVersionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_SoftwareVersionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arSoftwareVersionList_);

    /**
     * Destructor
     */
    inline virtual  ~Property_SoftwareVersionStatus();

    /**
     * Assignment operator
     */
    inline Property_SoftwareVersionStatus& operator = (const Property_SoftwareVersionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_SoftwareVersionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_SoftwareVersionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_SoftwareVersionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_SoftwareVersionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arSoftwareVersionList"

    static const int kArSoftwareVersionList = 0;

    /**
     * Clears the field "arSoftwareVersionList".
     *
     * The field will be set to its default value. The hasArSoftwareVersionList()
     * method will return false.
     */
    inline void clearArSoftwareVersionList();

    /**
     * Checks whether the field "arSoftwareVersionList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArSoftwareVersionList()). Otherwise it will return false.
     */
    inline bool hasArSoftwareVersionList () const;

    /**
     * Returns the value of the member "arSoftwareVersionList".
     *
     * List with software version of each MCAN unit.
     *
     * @return The value of the field "arSoftwareVersionList"
     */
    inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& getArSoftwareVersionList () const;

    /**
     * Retrieves the value of the field "arSoftwareVersionList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arSoftwareVersionList".
     */
    inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& getArSoftwareVersionListMutable ();

    /**
     * Sets the value of the member "arSoftwareVersionList".
     *
     * List with software version of each MCAN unit.
     *
     * @param arSoftwareVersionList The value which will be set
     */
    inline void setArSoftwareVersionList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arSoftwareVersionList_);

    static const Property_SoftwareVersionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& getT_datacollector_UnitVersionList_DefaultInstance ();

    inline void set_has_arSoftwareVersionList ();

    inline void clear_has_arSoftwareVersionList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion > _arSoftwareVersionList;

};

/**
 * The status message of the property "Property_DataTransmission"
 * This property gives information about the data transmission status used to indicate transmission errors of MPDT messages.
 */
class Property_DataTransmissionStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_DataTransmissionStatus ();

    /**
     * Copy constructor
     */
    inline  Property_DataTransmissionStatus (const Property_DataTransmissionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_DataTransmissionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& arDataTransmissionStatusList_);

    /**
     * Destructor
     */
    inline virtual  ~Property_DataTransmissionStatus();

    /**
     * Assignment operator
     */
    inline Property_DataTransmissionStatus& operator = (const Property_DataTransmissionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_DataTransmissionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_DataTransmissionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_DataTransmissionStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_DataTransmissionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "arDataTransmissionStatusList"

    static const int kArDataTransmissionStatusList = 0;

    /**
     * Clears the field "arDataTransmissionStatusList".
     *
     * The field will be set to its default value. The hasArDataTransmissionStatusList()
     * method will return false.
     */
    inline void clearArDataTransmissionStatusList();

    /**
     * Checks whether the field "arDataTransmissionStatusList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArDataTransmissionStatusList()). Otherwise it will return false.
     */
    inline bool hasArDataTransmissionStatusList () const;

    /**
     * Returns the value of the member "arDataTransmissionStatusList".
     *
     * List with data transmission status of each MCAN unit.
     *
     * @return The value of the field "arDataTransmissionStatusList"
     */
    inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& getArDataTransmissionStatusList () const;

    /**
     * Retrieves the value of the field "arDataTransmissionStatusList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "arDataTransmissionStatusList".
     */
    inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& getArDataTransmissionStatusListMutable ();

    /**
     * Sets the value of the member "arDataTransmissionStatusList".
     *
     * List with data transmission status of each MCAN unit.
     *
     * @param arDataTransmissionStatusList The value which will be set
     */
    inline void setArDataTransmissionStatusList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& arDataTransmissionStatusList_);

    static const Property_DataTransmissionStatus &getDefaultInstance();

private:

    static const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& getT_datacollector_UnitDataTransmissionStatusList_DefaultInstance ();

    inline void set_has_arDataTransmissionStatusList ();

    inline void clear_has_arDataTransmissionStatusList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus > _arDataTransmissionStatusList;

};

/**
 * The start message of the method "Method_TriggerVersionInfotoMeter"
 * <p>This method is used to Trigger the GET for Version Info to FC_Meter.</p>
 * <p>This method is used as a Internal Communication between HALL_Applications, DC and FC_Meter.</p>
 * <p>This will result in Trigger of MCAN Message to GET the Hardware and Software Version</p>
 */
class Method_TriggerVersionInfotoMeterStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_TriggerVersionInfotoMeterStart ();

    /**
     * Copy constructor
     */
    inline  Method_TriggerVersionInfotoMeterStart (const Method_TriggerVersionInfotoMeterStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_TriggerVersionInfotoMeterStart (::datacollector_main_fi_types::T_e8_datacollector_VersionInfo e8Version_);

    /**
     * Destructor
     */
    inline virtual  ~Method_TriggerVersionInfotoMeterStart();

    /**
     * Assignment operator
     */
    inline Method_TriggerVersionInfotoMeterStart& operator = (const Method_TriggerVersionInfotoMeterStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_TriggerVersionInfotoMeterStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_TriggerVersionInfotoMeterStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_TriggerVersionInfotoMeterStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_TriggerVersionInfotoMeterStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Version"

    static const int kE8Version = 0;

    /**
     * Clears the field "e8Version".
     *
     * The field will be set to its default value. The hasE8Version()
     * method will return false.
     */
    inline void clearE8Version();

    /**
     * Checks whether the field "e8Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Version()). Otherwise it will return false.
     */
    inline bool hasE8Version () const;

    /**
     * Returns the value of the member "e8Version".
     *
     * Actual Needed Version Info by HALL Applications. This may be Hardware or Software Version request.
     *
     * @return The value of the field "e8Version"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_VersionInfo getE8Version () const;

    /**
     * Sets the value of the member "e8Version".
     *
     * Actual Needed Version Info by HALL Applications. This may be Hardware or Software Version request.
     *
     * @param e8Version The value which will be set
     */
    inline void setE8Version (::datacollector_main_fi_types::T_e8_datacollector_VersionInfo e8Version_);

    static const Method_TriggerVersionInfotoMeterStart &getDefaultInstance();

private:

    inline void set_has_e8Version ();

    inline void clear_has_e8Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_VersionInfo _e8Version;

};

/**
 * The status message of the property "Property_CurrentMeterSettings"
 * This property gives information about the current settings of the meter.
 */
class Property_CurrentMeterSettingsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_CurrentMeterSettingsStatus ();

    /**
     * Copy constructor
     */
    inline  Property_CurrentMeterSettingsStatus (const Property_CurrentMeterSettingsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_CurrentMeterSettingsStatus (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_, ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_, ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_, ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Property_CurrentMeterSettingsStatus();

    /**
     * Assignment operator
     */
    inline Property_CurrentMeterSettingsStatus& operator = (const Property_CurrentMeterSettingsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_CurrentMeterSettingsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_CurrentMeterSettingsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_CurrentMeterSettingsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_CurrentMeterSettingsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * If the meaning of "e8Language" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Language"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * If the meaning of "e8Language" isn't clear, then there should be a description here.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    // API of field "e8FuelConsumptionUnit"

    static const int kE8FuelConsumptionUnit = 1;

    /**
     * Clears the field "e8FuelConsumptionUnit".
     *
     * The field will be set to its default value. The hasE8FuelConsumptionUnit()
     * method will return false.
     */
    inline void clearE8FuelConsumptionUnit();

    /**
     * Checks whether the field "e8FuelConsumptionUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FuelConsumptionUnit()). Otherwise it will return false.
     */
    inline bool hasE8FuelConsumptionUnit () const;

    /**
     * Returns the value of the member "e8FuelConsumptionUnit".
     *
     * If the meaning of "e8FuelConsumptionUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8FuelConsumptionUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit getE8FuelConsumptionUnit () const;

    /**
     * Sets the value of the member "e8FuelConsumptionUnit".
     *
     * If the meaning of "e8FuelConsumptionUnit" isn't clear, then there should be a description here.
     *
     * @param e8FuelConsumptionUnit The value which will be set
     */
    inline void setE8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_);

    // API of field "e8TemperatureUnit"

    static const int kE8TemperatureUnit = 2;

    /**
     * Clears the field "e8TemperatureUnit".
     *
     * The field will be set to its default value. The hasE8TemperatureUnit()
     * method will return false.
     */
    inline void clearE8TemperatureUnit();

    /**
     * Checks whether the field "e8TemperatureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TemperatureUnit()). Otherwise it will return false.
     */
    inline bool hasE8TemperatureUnit () const;

    /**
     * Returns the value of the member "e8TemperatureUnit".
     *
     * If the meaning of "e8TemperatureUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8TemperatureUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit getE8TemperatureUnit () const;

    /**
     * Sets the value of the member "e8TemperatureUnit".
     *
     * If the meaning of "e8TemperatureUnit" isn't clear, then there should be a description here.
     *
     * @param e8TemperatureUnit The value which will be set
     */
    inline void setE8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_);

    // API of field "e8PressureUnit"

    static const int kE8PressureUnit = 3;

    /**
     * Clears the field "e8PressureUnit".
     *
     * The field will be set to its default value. The hasE8PressureUnit()
     * method will return false.
     */
    inline void clearE8PressureUnit();

    /**
     * Checks whether the field "e8PressureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PressureUnit()). Otherwise it will return false.
     */
    inline bool hasE8PressureUnit () const;

    /**
     * Returns the value of the member "e8PressureUnit".
     *
     * If the meaning of "e8PressureUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8PressureUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit getE8PressureUnit () const;

    /**
     * Sets the value of the member "e8PressureUnit".
     *
     * If the meaning of "e8PressureUnit" isn't clear, then there should be a description here.
     *
     * @param e8PressureUnit The value which will be set
     */
    inline void setE8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_);

    static const Property_CurrentMeterSettingsStatus &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    inline void set_has_e8FuelConsumptionUnit ();

    inline void clear_has_e8FuelConsumptionUnit ();

    inline void set_has_e8TemperatureUnit ();

    inline void clear_has_e8TemperatureUnit ();

    inline void set_has_e8PressureUnit ();

    inline void clear_has_e8PressureUnit ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8Language;

    ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit _e8FuelConsumptionUnit;

    ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit _e8TemperatureUnit;

    ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit _e8PressureUnit;

};

/**
 * The status message of the property "Property_AvailableFuelConsumptionUnits"
 * This property gives information about fuel consumption units supported by the meter.
 */
class Property_AvailableFuelConsumptionUnitsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_AvailableFuelConsumptionUnitsStatus ();

    /**
     * Copy constructor
     */
    inline  Property_AvailableFuelConsumptionUnitsStatus (const Property_AvailableFuelConsumptionUnitsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_AvailableFuelConsumptionUnitsStatus (bool b_km_per_l_, bool b_l_per_100km_, bool b_US_MPG_, bool b_UK_MPG_);

    /**
     * Destructor
     */
    inline virtual  ~Property_AvailableFuelConsumptionUnitsStatus();

    /**
     * Assignment operator
     */
    inline Property_AvailableFuelConsumptionUnitsStatus& operator = (const Property_AvailableFuelConsumptionUnitsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b_km_per_l"

    static const int kB_km_per_l = 0;

    /**
     * Clears the field "b_km_per_l".
     *
     * The field will be set to its default value. The hasB_km_per_l()
     * method will return false.
     */
    inline void clearB_km_per_l();

    /**
     * Checks whether the field "b_km_per_l" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_km_per_l()). Otherwise it will return false.
     */
    inline bool hasB_km_per_l () const;

    /**
     * Returns the value of the member "b_km_per_l".
     *
     * meter supports the unit "kilometers per liter"
     *
     * @return The value of the field "b_km_per_l"
     */
    inline bool getB_km_per_l () const;

    /**
     * Sets the value of the member "b_km_per_l".
     *
     * meter supports the unit "kilometers per liter"
     *
     * @param b_km_per_l The value which will be set
     */
    inline void setB_km_per_l (bool b_km_per_l_);

    // API of field "b_l_per_100km"

    static const int kB_l_per_100km = 1;

    /**
     * Clears the field "b_l_per_100km".
     *
     * The field will be set to its default value. The hasB_l_per_100km()
     * method will return false.
     */
    inline void clearB_l_per_100km();

    /**
     * Checks whether the field "b_l_per_100km" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_l_per_100km()). Otherwise it will return false.
     */
    inline bool hasB_l_per_100km () const;

    /**
     * Returns the value of the member "b_l_per_100km".
     *
     * meter supports the unit "liter per 100 kilometers"
     *
     * @return The value of the field "b_l_per_100km"
     */
    inline bool getB_l_per_100km () const;

    /**
     * Sets the value of the member "b_l_per_100km".
     *
     * meter supports the unit "liter per 100 kilometers"
     *
     * @param b_l_per_100km The value which will be set
     */
    inline void setB_l_per_100km (bool b_l_per_100km_);

    // API of field "b_US_MPG"

    static const int kB_US_MPG = 2;

    /**
     * Clears the field "b_US_MPG".
     *
     * The field will be set to its default value. The hasB_US_MPG()
     * method will return false.
     */
    inline void clearB_US_MPG();

    /**
     * Checks whether the field "b_US_MPG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_US_MPG()). Otherwise it will return false.
     */
    inline bool hasB_US_MPG () const;

    /**
     * Returns the value of the member "b_US_MPG".
     *
     * meter supports the unit "miles per US-gallon"
     *
     * @return The value of the field "b_US_MPG"
     */
    inline bool getB_US_MPG () const;

    /**
     * Sets the value of the member "b_US_MPG".
     *
     * meter supports the unit "miles per US-gallon"
     *
     * @param b_US_MPG The value which will be set
     */
    inline void setB_US_MPG (bool b_US_MPG_);

    // API of field "b_UK_MPG"

    static const int kB_UK_MPG = 3;

    /**
     * Clears the field "b_UK_MPG".
     *
     * The field will be set to its default value. The hasB_UK_MPG()
     * method will return false.
     */
    inline void clearB_UK_MPG();

    /**
     * Checks whether the field "b_UK_MPG" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_UK_MPG()). Otherwise it will return false.
     */
    inline bool hasB_UK_MPG () const;

    /**
     * Returns the value of the member "b_UK_MPG".
     *
     * meter supports the unit "miles per UK-gallon"
     *
     * @return The value of the field "b_UK_MPG"
     */
    inline bool getB_UK_MPG () const;

    /**
     * Sets the value of the member "b_UK_MPG".
     *
     * meter supports the unit "miles per UK-gallon"
     *
     * @param b_UK_MPG The value which will be set
     */
    inline void setB_UK_MPG (bool b_UK_MPG_);

    static const Property_AvailableFuelConsumptionUnitsStatus &getDefaultInstance();

private:

    inline void set_has_b_km_per_l ();

    inline void clear_has_b_km_per_l ();

    inline void set_has_b_l_per_100km ();

    inline void clear_has_b_l_per_100km ();

    inline void set_has_b_US_MPG ();

    inline void clear_has_b_US_MPG ();

    inline void set_has_b_UK_MPG ();

    inline void clear_has_b_UK_MPG ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _b_km_per_l;

    bool _b_l_per_100km;

    bool _b_US_MPG;

    bool _b_UK_MPG;

};

/**
 * The status message of the property "Property_AvailableTemperatureUnits"
 * This property gives information about temperature units supported by the meter.
 */
class Property_AvailableTemperatureUnitsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_AvailableTemperatureUnitsStatus ();

    /**
     * Copy constructor
     */
    inline  Property_AvailableTemperatureUnitsStatus (const Property_AvailableTemperatureUnitsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_AvailableTemperatureUnitsStatus (bool b_deg_C_, bool b_deg_F_);

    /**
     * Destructor
     */
    inline virtual  ~Property_AvailableTemperatureUnitsStatus();

    /**
     * Assignment operator
     */
    inline Property_AvailableTemperatureUnitsStatus& operator = (const Property_AvailableTemperatureUnitsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_AvailableTemperatureUnitsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_AvailableTemperatureUnitsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_AvailableTemperatureUnitsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_AvailableTemperatureUnitsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b_deg_C"

    static const int kB_deg_C = 0;

    /**
     * Clears the field "b_deg_C".
     *
     * The field will be set to its default value. The hasB_deg_C()
     * method will return false.
     */
    inline void clearB_deg_C();

    /**
     * Checks whether the field "b_deg_C" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_deg_C()). Otherwise it will return false.
     */
    inline bool hasB_deg_C () const;

    /**
     * Returns the value of the member "b_deg_C".
     *
     * meter supports the unit "degrees Celsius"
     *
     * @return The value of the field "b_deg_C"
     */
    inline bool getB_deg_C () const;

    /**
     * Sets the value of the member "b_deg_C".
     *
     * meter supports the unit "degrees Celsius"
     *
     * @param b_deg_C The value which will be set
     */
    inline void setB_deg_C (bool b_deg_C_);

    // API of field "b_deg_F"

    static const int kB_deg_F = 1;

    /**
     * Clears the field "b_deg_F".
     *
     * The field will be set to its default value. The hasB_deg_F()
     * method will return false.
     */
    inline void clearB_deg_F();

    /**
     * Checks whether the field "b_deg_F" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_deg_F()). Otherwise it will return false.
     */
    inline bool hasB_deg_F () const;

    /**
     * Returns the value of the member "b_deg_F".
     *
     * meter supports the unit "degrees Fahrenheit"
     *
     * @return The value of the field "b_deg_F"
     */
    inline bool getB_deg_F () const;

    /**
     * Sets the value of the member "b_deg_F".
     *
     * meter supports the unit "degrees Fahrenheit"
     *
     * @param b_deg_F The value which will be set
     */
    inline void setB_deg_F (bool b_deg_F_);

    static const Property_AvailableTemperatureUnitsStatus &getDefaultInstance();

private:

    inline void set_has_b_deg_C ();

    inline void clear_has_b_deg_C ();

    inline void set_has_b_deg_F ();

    inline void clear_has_b_deg_F ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _b_deg_C;

    bool _b_deg_F;

};

/**
 * The status message of the property "Property_AvailablePressureUnits"
 * This property gives information about pressure units supported by the meter.
 */
class Property_AvailablePressureUnitsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_AvailablePressureUnitsStatus ();

    /**
     * Copy constructor
     */
    inline  Property_AvailablePressureUnitsStatus (const Property_AvailablePressureUnitsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_AvailablePressureUnitsStatus (bool b_kPa_, bool b_PSI_, bool b_bar_, bool b_kgf_cm2_);

    /**
     * Destructor
     */
    inline virtual  ~Property_AvailablePressureUnitsStatus();

    /**
     * Assignment operator
     */
    inline Property_AvailablePressureUnitsStatus& operator = (const Property_AvailablePressureUnitsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_AvailablePressureUnitsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_AvailablePressureUnitsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_AvailablePressureUnitsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_AvailablePressureUnitsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b_kPa"

    static const int kB_kPa = 0;

    /**
     * Clears the field "b_kPa".
     *
     * The field will be set to its default value. The hasB_kPa()
     * method will return false.
     */
    inline void clearB_kPa();

    /**
     * Checks whether the field "b_kPa" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_kPa()). Otherwise it will return false.
     */
    inline bool hasB_kPa () const;

    /**
     * Returns the value of the member "b_kPa".
     *
     * meter supports the unit "kilo-Pascal"
     *
     * @return The value of the field "b_kPa"
     */
    inline bool getB_kPa () const;

    /**
     * Sets the value of the member "b_kPa".
     *
     * meter supports the unit "kilo-Pascal"
     *
     * @param b_kPa The value which will be set
     */
    inline void setB_kPa (bool b_kPa_);

    // API of field "b_PSI"

    static const int kB_PSI = 1;

    /**
     * Clears the field "b_PSI".
     *
     * The field will be set to its default value. The hasB_PSI()
     * method will return false.
     */
    inline void clearB_PSI();

    /**
     * Checks whether the field "b_PSI" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_PSI()). Otherwise it will return false.
     */
    inline bool hasB_PSI () const;

    /**
     * Returns the value of the member "b_PSI".
     *
     * meter supports the unit "pounds per square inch"
     *
     * @return The value of the field "b_PSI"
     */
    inline bool getB_PSI () const;

    /**
     * Sets the value of the member "b_PSI".
     *
     * meter supports the unit "pounds per square inch"
     *
     * @param b_PSI The value which will be set
     */
    inline void setB_PSI (bool b_PSI_);

    // API of field "b_bar"

    static const int kB_bar = 2;

    /**
     * Clears the field "b_bar".
     *
     * The field will be set to its default value. The hasB_bar()
     * method will return false.
     */
    inline void clearB_bar();

    /**
     * Checks whether the field "b_bar" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_bar()). Otherwise it will return false.
     */
    inline bool hasB_bar () const;

    /**
     * Returns the value of the member "b_bar".
     *
     * meter supports the unit "bar"
     *
     * @return The value of the field "b_bar"
     */
    inline bool getB_bar () const;

    /**
     * Sets the value of the member "b_bar".
     *
     * meter supports the unit "bar"
     *
     * @param b_bar The value which will be set
     */
    inline void setB_bar (bool b_bar_);

    // API of field "b_kgf_cm2"

    static const int kB_kgf_cm2 = 3;

    /**
     * Clears the field "b_kgf_cm2".
     *
     * The field will be set to its default value. The hasB_kgf_cm2()
     * method will return false.
     */
    inline void clearB_kgf_cm2();

    /**
     * Checks whether the field "b_kgf_cm2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB_kgf_cm2()). Otherwise it will return false.
     */
    inline bool hasB_kgf_cm2 () const;

    /**
     * Returns the value of the member "b_kgf_cm2".
     *
     * meter supports the unit "kilogrammforce per square centimeter"
     *
     * @return The value of the field "b_kgf_cm2"
     */
    inline bool getB_kgf_cm2 () const;

    /**
     * Sets the value of the member "b_kgf_cm2".
     *
     * meter supports the unit "kilogrammforce per square centimeter"
     *
     * @param b_kgf_cm2 The value which will be set
     */
    inline void setB_kgf_cm2 (bool b_kgf_cm2_);

    static const Property_AvailablePressureUnitsStatus &getDefaultInstance();

private:

    inline void set_has_b_kPa ();

    inline void clear_has_b_kPa ();

    inline void set_has_b_PSI ();

    inline void clear_has_b_PSI ();

    inline void set_has_b_bar ();

    inline void clear_has_b_bar ();

    inline void set_has_b_kgf_cm2 ();

    inline void clear_has_b_kgf_cm2 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _b_kPa;

    bool _b_PSI;

    bool _b_bar;

    bool _b_kgf_cm2;

};

/**
 * The status message of the property "Property_RequestedFuelConsumptionUnit"
 * This property gives information about the fuel consumption unit requested by the meter.
 */
class Property_RequestedFuelConsumptionUnitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_RequestedFuelConsumptionUnitStatus ();

    /**
     * Copy constructor
     */
    inline  Property_RequestedFuelConsumptionUnitStatus (const Property_RequestedFuelConsumptionUnitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_RequestedFuelConsumptionUnitStatus (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Property_RequestedFuelConsumptionUnitStatus();

    /**
     * Assignment operator
     */
    inline Property_RequestedFuelConsumptionUnitStatus& operator = (const Property_RequestedFuelConsumptionUnitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_RequestedFuelConsumptionUnitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_RequestedFuelConsumptionUnitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_RequestedFuelConsumptionUnitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_RequestedFuelConsumptionUnitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FuelConsumptionUnit"

    static const int kE8FuelConsumptionUnit = 0;

    /**
     * Clears the field "e8FuelConsumptionUnit".
     *
     * The field will be set to its default value. The hasE8FuelConsumptionUnit()
     * method will return false.
     */
    inline void clearE8FuelConsumptionUnit();

    /**
     * Checks whether the field "e8FuelConsumptionUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FuelConsumptionUnit()). Otherwise it will return false.
     */
    inline bool hasE8FuelConsumptionUnit () const;

    /**
     * Returns the value of the member "e8FuelConsumptionUnit".
     *
     * If the meaning of "e8FuelConsumptionUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8FuelConsumptionUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit getE8FuelConsumptionUnit () const;

    /**
     * Sets the value of the member "e8FuelConsumptionUnit".
     *
     * If the meaning of "e8FuelConsumptionUnit" isn't clear, then there should be a description here.
     *
     * @param e8FuelConsumptionUnit The value which will be set
     */
    inline void setE8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_);

    static const Property_RequestedFuelConsumptionUnitStatus &getDefaultInstance();

private:

    inline void set_has_e8FuelConsumptionUnit ();

    inline void clear_has_e8FuelConsumptionUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit _e8FuelConsumptionUnit;

};

/**
 * The status message of the property "Property_RequestedTemperatureUnit"
 * This property gives information about the temperature unit requested by the meter.
 */
class Property_RequestedTemperatureUnitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_RequestedTemperatureUnitStatus ();

    /**
     * Copy constructor
     */
    inline  Property_RequestedTemperatureUnitStatus (const Property_RequestedTemperatureUnitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_RequestedTemperatureUnitStatus (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Property_RequestedTemperatureUnitStatus();

    /**
     * Assignment operator
     */
    inline Property_RequestedTemperatureUnitStatus& operator = (const Property_RequestedTemperatureUnitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_RequestedTemperatureUnitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_RequestedTemperatureUnitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_RequestedTemperatureUnitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_RequestedTemperatureUnitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TemperatureUnit"

    static const int kE8TemperatureUnit = 0;

    /**
     * Clears the field "e8TemperatureUnit".
     *
     * The field will be set to its default value. The hasE8TemperatureUnit()
     * method will return false.
     */
    inline void clearE8TemperatureUnit();

    /**
     * Checks whether the field "e8TemperatureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TemperatureUnit()). Otherwise it will return false.
     */
    inline bool hasE8TemperatureUnit () const;

    /**
     * Returns the value of the member "e8TemperatureUnit".
     *
     * If the meaning of "e8TemperatureUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8TemperatureUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit getE8TemperatureUnit () const;

    /**
     * Sets the value of the member "e8TemperatureUnit".
     *
     * If the meaning of "e8TemperatureUnit" isn't clear, then there should be a description here.
     *
     * @param e8TemperatureUnit The value which will be set
     */
    inline void setE8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_);

    static const Property_RequestedTemperatureUnitStatus &getDefaultInstance();

private:

    inline void set_has_e8TemperatureUnit ();

    inline void clear_has_e8TemperatureUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit _e8TemperatureUnit;

};

/**
 * The status message of the property "Property_RequestedPressureUnit"
 * This property gives information about the pressure unit requested by the meter.
 */
class Property_RequestedPressureUnitStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_RequestedPressureUnitStatus ();

    /**
     * Copy constructor
     */
    inline  Property_RequestedPressureUnitStatus (const Property_RequestedPressureUnitStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_RequestedPressureUnitStatus (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Property_RequestedPressureUnitStatus();

    /**
     * Assignment operator
     */
    inline Property_RequestedPressureUnitStatus& operator = (const Property_RequestedPressureUnitStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_RequestedPressureUnitStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_RequestedPressureUnitStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_RequestedPressureUnitStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_RequestedPressureUnitStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PressureUnit"

    static const int kE8PressureUnit = 0;

    /**
     * Clears the field "e8PressureUnit".
     *
     * The field will be set to its default value. The hasE8PressureUnit()
     * method will return false.
     */
    inline void clearE8PressureUnit();

    /**
     * Checks whether the field "e8PressureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PressureUnit()). Otherwise it will return false.
     */
    inline bool hasE8PressureUnit () const;

    /**
     * Returns the value of the member "e8PressureUnit".
     *
     * If the meaning of "e8PressureUnit" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8PressureUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit getE8PressureUnit () const;

    /**
     * Sets the value of the member "e8PressureUnit".
     *
     * If the meaning of "e8PressureUnit" isn't clear, then there should be a description here.
     *
     * @param e8PressureUnit The value which will be set
     */
    inline void setE8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_);

    static const Property_RequestedPressureUnitStatus &getDefaultInstance();

private:

    inline void set_has_e8PressureUnit ();

    inline void clear_has_e8PressureUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit _e8PressureUnit;

};

/**
 * The status message of the property "Property_SupportedLangSyncMode"
 * This property gives information about the language synchronization modes supported by the meter.
 */
class Property_SupportedLangSyncModeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_SupportedLangSyncModeStatus ();

    /**
     * Copy constructor
     */
    inline  Property_SupportedLangSyncModeStatus (const Property_SupportedLangSyncModeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_SupportedLangSyncModeStatus (::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type e8LangSyncMode_);

    /**
     * Destructor
     */
    inline virtual  ~Property_SupportedLangSyncModeStatus();

    /**
     * Assignment operator
     */
    inline Property_SupportedLangSyncModeStatus& operator = (const Property_SupportedLangSyncModeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_SupportedLangSyncModeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_SupportedLangSyncModeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_SupportedLangSyncModeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_SupportedLangSyncModeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LangSyncMode"

    static const int kE8LangSyncMode = 0;

    /**
     * Clears the field "e8LangSyncMode".
     *
     * The field will be set to its default value. The hasE8LangSyncMode()
     * method will return false.
     */
    inline void clearE8LangSyncMode();

    /**
     * Checks whether the field "e8LangSyncMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LangSyncMode()). Otherwise it will return false.
     */
    inline bool hasE8LangSyncMode () const;

    /**
     * Returns the value of the member "e8LangSyncMode".
     *
     * If the meaning of "e8LangSyncMode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8LangSyncMode"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type getE8LangSyncMode () const;

    /**
     * Sets the value of the member "e8LangSyncMode".
     *
     * If the meaning of "e8LangSyncMode" isn't clear, then there should be a description here.
     *
     * @param e8LangSyncMode The value which will be set
     */
    inline void setE8LangSyncMode (::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type e8LangSyncMode_);

    static const Property_SupportedLangSyncModeStatus &getDefaultInstance();

private:

    inline void set_has_e8LangSyncMode ();

    inline void clear_has_e8LangSyncMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type _e8LangSyncMode;

};

/**
 * The start message of the method "Method_SetHMIDistanceUnit"
 * This method is used to transmit the current distance unit used in the HMI.
 */
class Method_SetHMIDistanceUnitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetHMIDistanceUnitStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetHMIDistanceUnitStart (const Method_SetHMIDistanceUnitStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetHMIDistanceUnitStart (::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit e8DistanceUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetHMIDistanceUnitStart();

    /**
     * Assignment operator
     */
    inline Method_SetHMIDistanceUnitStart& operator = (const Method_SetHMIDistanceUnitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetHMIDistanceUnitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetHMIDistanceUnitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetHMIDistanceUnitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetHMIDistanceUnitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DistanceUnit"

    static const int kE8DistanceUnit = 0;

    /**
     * Clears the field "e8DistanceUnit".
     *
     * The field will be set to its default value. The hasE8DistanceUnit()
     * method will return false.
     */
    inline void clearE8DistanceUnit();

    /**
     * Checks whether the field "e8DistanceUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DistanceUnit()). Otherwise it will return false.
     */
    inline bool hasE8DistanceUnit () const;

    /**
     * Returns the value of the member "e8DistanceUnit".
     *
     * Actual distance unit used by the HMI: Unknown, m (metric), mi (imperial).
     *
     * @return The value of the field "e8DistanceUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit getE8DistanceUnit () const;

    /**
     * Sets the value of the member "e8DistanceUnit".
     *
     * Actual distance unit used by the HMI: Unknown, m (metric), mi (imperial).
     *
     * @param e8DistanceUnit The value which will be set
     */
    inline void setE8DistanceUnit (::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit e8DistanceUnit_);

    static const Method_SetHMIDistanceUnitStart &getDefaultInstance();

private:

    inline void set_has_e8DistanceUnit ();

    inline void clear_has_e8DistanceUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit _e8DistanceUnit;

};

/**
 * The start message of the method "Method_SetHMIFuelConsumptionUnit"
 * This method is used to transmit the current fuel consumption unit used in the HMI.
 */
class Method_SetHMIFuelConsumptionUnitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetHMIFuelConsumptionUnitStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetHMIFuelConsumptionUnitStart (const Method_SetHMIFuelConsumptionUnitStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetHMIFuelConsumptionUnitStart (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetHMIFuelConsumptionUnitStart();

    /**
     * Assignment operator
     */
    inline Method_SetHMIFuelConsumptionUnitStart& operator = (const Method_SetHMIFuelConsumptionUnitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetHMIFuelConsumptionUnitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetHMIFuelConsumptionUnitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetHMIFuelConsumptionUnitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetHMIFuelConsumptionUnitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8FuelConsumptionUnit"

    static const int kE8FuelConsumptionUnit = 0;

    /**
     * Clears the field "e8FuelConsumptionUnit".
     *
     * The field will be set to its default value. The hasE8FuelConsumptionUnit()
     * method will return false.
     */
    inline void clearE8FuelConsumptionUnit();

    /**
     * Checks whether the field "e8FuelConsumptionUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8FuelConsumptionUnit()). Otherwise it will return false.
     */
    inline bool hasE8FuelConsumptionUnit () const;

    /**
     * Returns the value of the member "e8FuelConsumptionUnit".
     *
     * Actual fuel consumption unit used by the HMI: km_per_l, l_per_100km, US_MPG, UK_MPG
     *
     * @return The value of the field "e8FuelConsumptionUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit getE8FuelConsumptionUnit () const;

    /**
     * Sets the value of the member "e8FuelConsumptionUnit".
     *
     * Actual fuel consumption unit used by the HMI: km_per_l, l_per_100km, US_MPG, UK_MPG
     *
     * @param e8FuelConsumptionUnit The value which will be set
     */
    inline void setE8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_);

    static const Method_SetHMIFuelConsumptionUnitStart &getDefaultInstance();

private:

    inline void set_has_e8FuelConsumptionUnit ();

    inline void clear_has_e8FuelConsumptionUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit _e8FuelConsumptionUnit;

};

/**
 * The start message of the method "Method_SetHMITemperatureUnit"
 * This method is used to transmit the current temperature unit used in the HMI.
 */
class Method_SetHMITemperatureUnitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetHMITemperatureUnitStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetHMITemperatureUnitStart (const Method_SetHMITemperatureUnitStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetHMITemperatureUnitStart (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetHMITemperatureUnitStart();

    /**
     * Assignment operator
     */
    inline Method_SetHMITemperatureUnitStart& operator = (const Method_SetHMITemperatureUnitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetHMITemperatureUnitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetHMITemperatureUnitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetHMITemperatureUnitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetHMITemperatureUnitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8TemperatureUnit"

    static const int kE8TemperatureUnit = 0;

    /**
     * Clears the field "e8TemperatureUnit".
     *
     * The field will be set to its default value. The hasE8TemperatureUnit()
     * method will return false.
     */
    inline void clearE8TemperatureUnit();

    /**
     * Checks whether the field "e8TemperatureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8TemperatureUnit()). Otherwise it will return false.
     */
    inline bool hasE8TemperatureUnit () const;

    /**
     * Returns the value of the member "e8TemperatureUnit".
     *
     * Actual temperature unit used by the HMI: deg_C (ï¿½C) or deg_F (ï¿½F)
     *
     * @return The value of the field "e8TemperatureUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit getE8TemperatureUnit () const;

    /**
     * Sets the value of the member "e8TemperatureUnit".
     *
     * Actual temperature unit used by the HMI: deg_C (ï¿½C) or deg_F (ï¿½F)
     *
     * @param e8TemperatureUnit The value which will be set
     */
    inline void setE8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_);

    static const Method_SetHMITemperatureUnitStart &getDefaultInstance();

private:

    inline void set_has_e8TemperatureUnit ();

    inline void clear_has_e8TemperatureUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit _e8TemperatureUnit;

};

/**
 * The start message of the method "Method_SetHMIPressureUnit"
 * This method is used to transmit the current pressure unit used in the HMI.
 */
class Method_SetHMIPressureUnitStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetHMIPressureUnitStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetHMIPressureUnitStart (const Method_SetHMIPressureUnitStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetHMIPressureUnitStart (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetHMIPressureUnitStart();

    /**
     * Assignment operator
     */
    inline Method_SetHMIPressureUnitStart& operator = (const Method_SetHMIPressureUnitStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetHMIPressureUnitStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetHMIPressureUnitStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetHMIPressureUnitStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetHMIPressureUnitStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8PressureUnit"

    static const int kE8PressureUnit = 0;

    /**
     * Clears the field "e8PressureUnit".
     *
     * The field will be set to its default value. The hasE8PressureUnit()
     * method will return false.
     */
    inline void clearE8PressureUnit();

    /**
     * Checks whether the field "e8PressureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8PressureUnit()). Otherwise it will return false.
     */
    inline bool hasE8PressureUnit () const;

    /**
     * Returns the value of the member "e8PressureUnit".
     *
     * Actual pressure unit used by the HMI: kPa, PSI, bar, kgf_cm2
     *
     * @return The value of the field "e8PressureUnit"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit getE8PressureUnit () const;

    /**
     * Sets the value of the member "e8PressureUnit".
     *
     * Actual pressure unit used by the HMI: kPa, PSI, bar, kgf_cm2
     *
     * @param e8PressureUnit The value which will be set
     */
    inline void setE8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_);

    static const Method_SetHMIPressureUnitStart &getDefaultInstance();

private:

    inline void set_has_e8PressureUnit ();

    inline void clear_has_e8PressureUnit ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit _e8PressureUnit;

};

/**
 * The status message of the property "Property_RequestedLanguage"
 * <p>This property gives information about the language requested by the meter.</p>
 * <p>A language request of the meter will only lead to a modificaion of the
 * LCN language when the language selection in LCN is set to automatic mode.</p>
 * <p>The result of a request with a language value unequal to "Unknown"
 * has to be reported by method SetRequestedLanguageResult.</p>
 */
class Property_RequestedLanguageStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_RequestedLanguageStatus ();

    /**
     * Copy constructor
     */
    inline  Property_RequestedLanguageStatus (const Property_RequestedLanguageStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_RequestedLanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~Property_RequestedLanguageStatus();

    /**
     * Assignment operator
     */
    inline Property_RequestedLanguageStatus& operator = (const Property_RequestedLanguageStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_RequestedLanguageStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_RequestedLanguageStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_RequestedLanguageStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_RequestedLanguageStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * If the meaning of "e8Language" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Language"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * If the meaning of "e8Language" isn't clear, then there should be a description here.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    static const Property_RequestedLanguageStatus &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8Language;

};

/**
 * The start message of the method "Method_SetRequestedLanguageResult"
 * This method is used to report the result of a former language request.
 */
class Method_SetRequestedLanguageResultStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetRequestedLanguageResultStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetRequestedLanguageResultStart (const Method_SetRequestedLanguageResultStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetRequestedLanguageResultStart (::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult e8Result_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetRequestedLanguageResultStart();

    /**
     * Assignment operator
     */
    inline Method_SetRequestedLanguageResultStart& operator = (const Method_SetRequestedLanguageResultStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetRequestedLanguageResultStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetRequestedLanguageResultStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetRequestedLanguageResultStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetRequestedLanguageResultStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Result"

    static const int kE8Result = 0;

    /**
     * Clears the field "e8Result".
     *
     * The field will be set to its default value. The hasE8Result()
     * method will return false.
     */
    inline void clearE8Result();

    /**
     * Checks whether the field "e8Result" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Result()). Otherwise it will return false.
     */
    inline bool hasE8Result () const;

    /**
     * Returns the value of the member "e8Result".
     *
     * <p>Result of a former language request:</p>
     * <p>UnchangedNotAuto, UnchangedAuto, Changed</p>
     *
     * @return The value of the field "e8Result"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult getE8Result () const;

    /**
     * Sets the value of the member "e8Result".
     *
     * <p>Result of a former language request:</p>
     * <p>UnchangedNotAuto, UnchangedAuto, Changed</p>
     *
     * @param e8Result The value which will be set
     */
    inline void setE8Result (::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult e8Result_);

    static const Method_SetRequestedLanguageResultStart &getDefaultInstance();

private:

    inline void set_has_e8Result ();

    inline void clear_has_e8Result ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult _e8Result;

};

/**
 * The result message of the method "Method_GetMeterLanguage"
 * This method is used to ask the meter explicitly for its current language.
 */
class Method_GetMeterLanguageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_GetMeterLanguageResult ();

    /**
     * Copy constructor
     */
    inline  Method_GetMeterLanguageResult (const Method_GetMeterLanguageResult &rhs);

    /**
     * All fields constructor
     */
    inline  Method_GetMeterLanguageResult (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~Method_GetMeterLanguageResult();

    /**
     * Assignment operator
     */
    inline Method_GetMeterLanguageResult& operator = (const Method_GetMeterLanguageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetMeterLanguageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetMeterLanguageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetMeterLanguageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetMeterLanguageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * If the meaning of "e8Language" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8Language"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * If the meaning of "e8Language" isn't clear, then there should be a description here.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    static const Method_GetMeterLanguageResult &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8Language;

};

/**
 * The result message of the method "Method_GetLanguageSettingsRequestfromLCN"
 * This method is called by ITM when there is a switching to language settings screen in ITM (MCAN Fct Id:606h).
 */
class Method_GetLanguageSettingsRequestfromLCNResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNResult ();

    /**
     * Copy constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNResult (const Method_GetLanguageSettingsRequestfromLCNResult &rhs);

    /**
     * All fields constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNResult (::datacollector_main_fi_types::T_e8_datacollector_Language e8DefaultLanguage_, ::datacollector_main_fi_types::T_e8_datacollector_Language e8CurrentLanguage_, uint8 e8LanguageAvailable_Byte_1_, uint8 e8LanguageAvailable_Byte_2_, uint8 e8LanguageAvailable_Byte_3_);

    /**
     * Destructor
     */
    inline virtual  ~Method_GetLanguageSettingsRequestfromLCNResult();

    /**
     * Assignment operator
     */
    inline Method_GetLanguageSettingsRequestfromLCNResult& operator = (const Method_GetLanguageSettingsRequestfromLCNResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DefaultLanguage"

    static const int kE8DefaultLanguage = 0;

    /**
     * Clears the field "e8DefaultLanguage".
     *
     * The field will be set to its default value. The hasE8DefaultLanguage()
     * method will return false.
     */
    inline void clearE8DefaultLanguage();

    /**
     * Checks whether the field "e8DefaultLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DefaultLanguage()). Otherwise it will return false.
     */
    inline bool hasE8DefaultLanguage () const;

    /**
     * Returns the value of the member "e8DefaultLanguage".
     *
     * If the meaning of "e8DefaultLanguage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8DefaultLanguage"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8DefaultLanguage () const;

    /**
     * Sets the value of the member "e8DefaultLanguage".
     *
     * If the meaning of "e8DefaultLanguage" isn't clear, then there should be a description here.
     *
     * @param e8DefaultLanguage The value which will be set
     */
    inline void setE8DefaultLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language e8DefaultLanguage_);

    // API of field "e8CurrentLanguage"

    static const int kE8CurrentLanguage = 1;

    /**
     * Clears the field "e8CurrentLanguage".
     *
     * The field will be set to its default value. The hasE8CurrentLanguage()
     * method will return false.
     */
    inline void clearE8CurrentLanguage();

    /**
     * Checks whether the field "e8CurrentLanguage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CurrentLanguage()). Otherwise it will return false.
     */
    inline bool hasE8CurrentLanguage () const;

    /**
     * Returns the value of the member "e8CurrentLanguage".
     *
     * If the meaning of "e8CurrentLanguage" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8CurrentLanguage"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8CurrentLanguage () const;

    /**
     * Sets the value of the member "e8CurrentLanguage".
     *
     * If the meaning of "e8CurrentLanguage" isn't clear, then there should be a description here.
     *
     * @param e8CurrentLanguage The value which will be set
     */
    inline void setE8CurrentLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language e8CurrentLanguage_);

    // API of field "e8LanguageAvailable_Byte_1"

    static const int kE8LanguageAvailable_Byte_1 = 2;

    /**
     * Clears the field "e8LanguageAvailable_Byte_1".
     *
     * The field will be set to its default value. The hasE8LanguageAvailable_Byte_1()
     * method will return false.
     */
    inline void clearE8LanguageAvailable_Byte_1();

    /**
     * Checks whether the field "e8LanguageAvailable_Byte_1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LanguageAvailable_Byte_1()). Otherwise it will return false.
     */
    inline bool hasE8LanguageAvailable_Byte_1 () const;

    /**
     * Returns the value of the member "e8LanguageAvailable_Byte_1".
     *
     * If the meaning of "e8LanguageAvailable_Byte_1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8LanguageAvailable_Byte_1"
     */
    inline uint8 getE8LanguageAvailable_Byte_1 () const;

    /**
     * Sets the value of the member "e8LanguageAvailable_Byte_1".
     *
     * If the meaning of "e8LanguageAvailable_Byte_1" isn't clear, then there should be a description here.
     *
     * @param e8LanguageAvailable_Byte_1 The value which will be set
     */
    inline void setE8LanguageAvailable_Byte_1 (uint8 e8LanguageAvailable_Byte_1_);

    // API of field "e8LanguageAvailable_Byte_2"

    static const int kE8LanguageAvailable_Byte_2 = 3;

    /**
     * Clears the field "e8LanguageAvailable_Byte_2".
     *
     * The field will be set to its default value. The hasE8LanguageAvailable_Byte_2()
     * method will return false.
     */
    inline void clearE8LanguageAvailable_Byte_2();

    /**
     * Checks whether the field "e8LanguageAvailable_Byte_2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LanguageAvailable_Byte_2()). Otherwise it will return false.
     */
    inline bool hasE8LanguageAvailable_Byte_2 () const;

    /**
     * Returns the value of the member "e8LanguageAvailable_Byte_2".
     *
     * If the meaning of "e8LanguageAvailable_Byte_2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8LanguageAvailable_Byte_2"
     */
    inline uint8 getE8LanguageAvailable_Byte_2 () const;

    /**
     * Sets the value of the member "e8LanguageAvailable_Byte_2".
     *
     * If the meaning of "e8LanguageAvailable_Byte_2" isn't clear, then there should be a description here.
     *
     * @param e8LanguageAvailable_Byte_2 The value which will be set
     */
    inline void setE8LanguageAvailable_Byte_2 (uint8 e8LanguageAvailable_Byte_2_);

    // API of field "e8LanguageAvailable_Byte_3"

    static const int kE8LanguageAvailable_Byte_3 = 4;

    /**
     * Clears the field "e8LanguageAvailable_Byte_3".
     *
     * The field will be set to its default value. The hasE8LanguageAvailable_Byte_3()
     * method will return false.
     */
    inline void clearE8LanguageAvailable_Byte_3();

    /**
     * Checks whether the field "e8LanguageAvailable_Byte_3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LanguageAvailable_Byte_3()). Otherwise it will return false.
     */
    inline bool hasE8LanguageAvailable_Byte_3 () const;

    /**
     * Returns the value of the member "e8LanguageAvailable_Byte_3".
     *
     * If the meaning of "e8LanguageAvailable_Byte_3" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8LanguageAvailable_Byte_3"
     */
    inline uint8 getE8LanguageAvailable_Byte_3 () const;

    /**
     * Sets the value of the member "e8LanguageAvailable_Byte_3".
     *
     * If the meaning of "e8LanguageAvailable_Byte_3" isn't clear, then there should be a description here.
     *
     * @param e8LanguageAvailable_Byte_3 The value which will be set
     */
    inline void setE8LanguageAvailable_Byte_3 (uint8 e8LanguageAvailable_Byte_3_);

    static const Method_GetLanguageSettingsRequestfromLCNResult &getDefaultInstance();

private:

    inline void set_has_e8DefaultLanguage ();

    inline void clear_has_e8DefaultLanguage ();

    inline void set_has_e8CurrentLanguage ();

    inline void clear_has_e8CurrentLanguage ();

    inline void set_has_e8LanguageAvailable_Byte_1 ();

    inline void clear_has_e8LanguageAvailable_Byte_1 ();

    inline void set_has_e8LanguageAvailable_Byte_2 ();

    inline void clear_has_e8LanguageAvailable_Byte_2 ();

    inline void set_has_e8LanguageAvailable_Byte_3 ();

    inline void clear_has_e8LanguageAvailable_Byte_3 ();

    uint32 _has_bits_[ (5 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8DefaultLanguage;

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8CurrentLanguage;

    uint8 _e8LanguageAvailable_Byte_1;

    uint8 _e8LanguageAvailable_Byte_2;

    uint8 _e8LanguageAvailable_Byte_3;

};

/**
 * The error message of 'Method_GetLanguageSettingsRequestfromLCN'
 * Error Message
 */
class Method_GetLanguageSettingsRequestfromLCNErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure (const Method_GetLanguageSettingsRequestfromLCNErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~Method_GetLanguageSettingsRequestfromLCNErrorStructure();

    /**
     * Assignment operator
     */
    inline Method_GetLanguageSettingsRequestfromLCNErrorStructure& operator = (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const Method_GetLanguageSettingsRequestfromLCNErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'Method_GetLanguageSettingsRequestfromLCN'
 * Error Message
 */
class Method_GetLanguageSettingsRequestfromLCNError  : public ::asf::core::Payload {
public:

    enum Method_GetLanguageSettingsRequestfromLCNErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Method_GetLanguageSettingsRequestfromLCNError ();

   /**
     * Copy constructor
     */
    inline  Method_GetLanguageSettingsRequestfromLCNError (const Method_GetLanguageSettingsRequestfromLCNError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Method_GetLanguageSettingsRequestfromLCNError();

    /**
     * Assigns a new value to this object.
     */
    inline Method_GetLanguageSettingsRequestfromLCNError& operator = (const Method_GetLanguageSettingsRequestfromLCNError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Method_GetLanguageSettingsRequestfromLCNError::Method_GetLanguageSettingsRequestfromLCNErrorField getField () const;

    inline void setField(Method_GetLanguageSettingsRequestfromLCNError::Method_GetLanguageSettingsRequestfromLCNErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Method_GetLanguageSettingsRequestfromLCNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Method_GetLanguageSettingsRequestfromLCNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Method_GetLanguageSettingsRequestfromLCNErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Method_GetLanguageSettingsRequestfromLCNErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Method_GetLanguageSettingsRequestfromLCNErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Method_GetLanguageSettingsRequestfromLCNErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Method_GetLanguageSettingsRequestfromLCNErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Method_GetLanguageSettingsRequestfromLCNError &getDefaultInstance();

private:

    inline void cloneData (const Method_GetLanguageSettingsRequestfromLCNError& rhs);

    inline void deleteData ();

    Method_GetLanguageSettingsRequestfromLCNErrorField __field;

    union {
        Method_GetLanguageSettingsRequestfromLCNErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Method_SetLanguageSettingsfromLCN"
 * This method is called by ITM when there is change in Language from ITM side(MCAN Fct Id:606h).
 */
class Method_SetLanguageSettingsfromLCNStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetLanguageSettingsfromLCNStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetLanguageSettingsfromLCNStart (const Method_SetLanguageSettingsfromLCNStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetLanguageSettingsfromLCNStart (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetLanguageSettingsfromLCNStart();

    /**
     * Assignment operator
     */
    inline Method_SetLanguageSettingsfromLCNStart& operator = (const Method_SetLanguageSettingsfromLCNStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetLanguageSettingsfromLCNStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetLanguageSettingsfromLCNStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetLanguageSettingsfromLCNStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetLanguageSettingsfromLCNStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * Language setting.
     *
     * @return The value of the field "e8Language"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * Language setting.
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    static const Method_SetLanguageSettingsfromLCNStart &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8Language;

};

/**
 * The error message of 'Method_SetLanguageSettingsfromLCN'
 * Error Message
 */
class Method_SetLanguageSettingsfromLCNErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Method_SetLanguageSettingsfromLCNErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Method_SetLanguageSettingsfromLCNErrorStructure (const Method_SetLanguageSettingsfromLCNErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetLanguageSettingsfromLCNErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~Method_SetLanguageSettingsfromLCNErrorStructure();

    /**
     * Assignment operator
     */
    inline Method_SetLanguageSettingsfromLCNErrorStructure& operator = (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const Method_SetLanguageSettingsfromLCNErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'Method_SetLanguageSettingsfromLCN'
 * Error Message
 */
class Method_SetLanguageSettingsfromLCNError  : public ::asf::core::Payload {
public:

    enum Method_SetLanguageSettingsfromLCNErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Method_SetLanguageSettingsfromLCNError ();

   /**
     * Copy constructor
     */
    inline  Method_SetLanguageSettingsfromLCNError (const Method_SetLanguageSettingsfromLCNError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetLanguageSettingsfromLCNError();

    /**
     * Assigns a new value to this object.
     */
    inline Method_SetLanguageSettingsfromLCNError& operator = (const Method_SetLanguageSettingsfromLCNError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetLanguageSettingsfromLCNError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetLanguageSettingsfromLCNError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetLanguageSettingsfromLCNError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetLanguageSettingsfromLCNError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Method_SetLanguageSettingsfromLCNError::Method_SetLanguageSettingsfromLCNErrorField getField () const;

    inline void setField(Method_SetLanguageSettingsfromLCNError::Method_SetLanguageSettingsfromLCNErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Method_SetLanguageSettingsfromLCNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Method_SetLanguageSettingsfromLCNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Method_SetLanguageSettingsfromLCNErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Method_SetLanguageSettingsfromLCNErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Method_SetLanguageSettingsfromLCNErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Method_SetLanguageSettingsfromLCNErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Method_SetLanguageSettingsfromLCNErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Method_SetLanguageSettingsfromLCNErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Method_SetLanguageSettingsfromLCNError &getDefaultInstance();

private:

    inline void cloneData (const Method_SetLanguageSettingsfromLCNError& rhs);

    inline void deleteData ();

    Method_SetLanguageSettingsfromLCNErrorField __field;

    union {
        Method_SetLanguageSettingsfromLCNErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Method_GetLanguageAvailability"
 * This Method is called by the client to know the language availability in the Meter
 */
class Method_GetLanguageAvailabilityStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_GetLanguageAvailabilityStart ();

    /**
     * Copy constructor
     */
    inline  Method_GetLanguageAvailabilityStart (const Method_GetLanguageAvailabilityStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_GetLanguageAvailabilityStart (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~Method_GetLanguageAvailabilityStart();

    /**
     * Assignment operator
     */
    inline Method_GetLanguageAvailabilityStart& operator = (const Method_GetLanguageAvailabilityStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageAvailabilityStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageAvailabilityStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageAvailabilityStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageAvailabilityStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * Language selected by the user on HeadUnit
     *
     * @return The value of the field "e8Language"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * Language selected by the user on HeadUnit
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    static const Method_GetLanguageAvailabilityStart &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8Language;

};

/**
 * The result message of the method "Method_GetLanguageAvailability"
 * This Method is called by the client to know the language availability in the Meter
 */
class Method_GetLanguageAvailabilityResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_GetLanguageAvailabilityResult ();

    /**
     * Copy constructor
     */
    inline  Method_GetLanguageAvailabilityResult (const Method_GetLanguageAvailabilityResult &rhs);

    /**
     * All fields constructor
     */
    inline  Method_GetLanguageAvailabilityResult (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_);

    /**
     * Destructor
     */
    inline virtual  ~Method_GetLanguageAvailabilityResult();

    /**
     * Assignment operator
     */
    inline Method_GetLanguageAvailabilityResult& operator = (const Method_GetLanguageAvailabilityResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageAvailabilityResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageAvailabilityResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageAvailabilityResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageAvailabilityResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LanguageStatus"

    static const int kE8LanguageStatus = 0;

    /**
     * Clears the field "e8LanguageStatus".
     *
     * The field will be set to its default value. The hasE8LanguageStatus()
     * method will return false.
     */
    inline void clearE8LanguageStatus();

    /**
     * Checks whether the field "e8LanguageStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LanguageStatus()). Otherwise it will return false.
     */
    inline bool hasE8LanguageStatus () const;

    /**
     * Returns the value of the member "e8LanguageStatus".
     *
     * Language availability status in the Meter
     *
     * @return The value of the field "e8LanguageStatus"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language_Status getE8LanguageStatus () const;

    /**
     * Sets the value of the member "e8LanguageStatus".
     *
     * Language availability status in the Meter
     *
     * @param e8LanguageStatus The value which will be set
     */
    inline void setE8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_);

    static const Method_GetLanguageAvailabilityResult &getDefaultInstance();

private:

    inline void set_has_e8LanguageStatus ();

    inline void clear_has_e8LanguageStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language_Status _e8LanguageStatus;

};

/**
 * The error message of 'Method_GetLanguageAvailability'
 * Error Message
 */
class Method_GetLanguageAvailabilityErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Method_GetLanguageAvailabilityErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Method_GetLanguageAvailabilityErrorStructure (const Method_GetLanguageAvailabilityErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Method_GetLanguageAvailabilityErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~Method_GetLanguageAvailabilityErrorStructure();

    /**
     * Assignment operator
     */
    inline Method_GetLanguageAvailabilityErrorStructure& operator = (const Method_GetLanguageAvailabilityErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageAvailabilityErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageAvailabilityErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageAvailabilityErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageAvailabilityErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const Method_GetLanguageAvailabilityErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'Method_GetLanguageAvailability'
 * Error Message
 */
class Method_GetLanguageAvailabilityError  : public ::asf::core::Payload {
public:

    enum Method_GetLanguageAvailabilityErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Method_GetLanguageAvailabilityError ();

   /**
     * Copy constructor
     */
    inline  Method_GetLanguageAvailabilityError (const Method_GetLanguageAvailabilityError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Method_GetLanguageAvailabilityError();

    /**
     * Assigns a new value to this object.
     */
    inline Method_GetLanguageAvailabilityError& operator = (const Method_GetLanguageAvailabilityError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_GetLanguageAvailabilityError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_GetLanguageAvailabilityError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_GetLanguageAvailabilityError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_GetLanguageAvailabilityError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Method_GetLanguageAvailabilityError::Method_GetLanguageAvailabilityErrorField getField () const;

    inline void setField(Method_GetLanguageAvailabilityError::Method_GetLanguageAvailabilityErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Method_GetLanguageAvailabilityErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Method_GetLanguageAvailabilityErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Method_GetLanguageAvailabilityErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Method_GetLanguageAvailabilityErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Method_GetLanguageAvailabilityErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Method_GetLanguageAvailabilityErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Method_GetLanguageAvailabilityErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Method_GetLanguageAvailabilityErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Method_GetLanguageAvailabilityError &getDefaultInstance();

private:

    inline void cloneData (const Method_GetLanguageAvailabilityError& rhs);

    inline void deleteData ();

    Method_GetLanguageAvailabilityErrorField __field;

    union {
        Method_GetLanguageAvailabilityErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Method_SetMeterLanguage"
 * This Method is called by the client to set language in the Meter
 */
class Method_SetMeterLanguageStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetMeterLanguageStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetMeterLanguageStart (const Method_SetMeterLanguageStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetMeterLanguageStart (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetMeterLanguageStart();

    /**
     * Assignment operator
     */
    inline Method_SetMeterLanguageStart& operator = (const Method_SetMeterLanguageStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetMeterLanguageStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetMeterLanguageStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetMeterLanguageStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetMeterLanguageStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Language"

    static const int kE8Language = 0;

    /**
     * Clears the field "e8Language".
     *
     * The field will be set to its default value. The hasE8Language()
     * method will return false.
     */
    inline void clearE8Language();

    /**
     * Checks whether the field "e8Language" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Language()). Otherwise it will return false.
     */
    inline bool hasE8Language () const;

    /**
     * Returns the value of the member "e8Language".
     *
     * Language to be set on the Meter
     *
     * @return The value of the field "e8Language"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language getE8Language () const;

    /**
     * Sets the value of the member "e8Language".
     *
     * Language to be set on the Meter
     *
     * @param e8Language The value which will be set
     */
    inline void setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_);

    static const Method_SetMeterLanguageStart &getDefaultInstance();

private:

    inline void set_has_e8Language ();

    inline void clear_has_e8Language ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language _e8Language;

};

/**
 * The result message of the method "Method_SetMeterLanguage"
 * This Method is called by the client to set language in the Meter
 */
class Method_SetMeterLanguageResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetMeterLanguageResult ();

    /**
     * Copy constructor
     */
    inline  Method_SetMeterLanguageResult (const Method_SetMeterLanguageResult &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetMeterLanguageResult (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetMeterLanguageResult();

    /**
     * Assignment operator
     */
    inline Method_SetMeterLanguageResult& operator = (const Method_SetMeterLanguageResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetMeterLanguageResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetMeterLanguageResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetMeterLanguageResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetMeterLanguageResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LanguageStatus"

    static const int kE8LanguageStatus = 0;

    /**
     * Clears the field "e8LanguageStatus".
     *
     * The field will be set to its default value. The hasE8LanguageStatus()
     * method will return false.
     */
    inline void clearE8LanguageStatus();

    /**
     * Checks whether the field "e8LanguageStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LanguageStatus()). Otherwise it will return false.
     */
    inline bool hasE8LanguageStatus () const;

    /**
     * Returns the value of the member "e8LanguageStatus".
     *
     * Language synchronization status on the Meter
     *
     * @return The value of the field "e8LanguageStatus"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Language_Status getE8LanguageStatus () const;

    /**
     * Sets the value of the member "e8LanguageStatus".
     *
     * Language synchronization status on the Meter
     *
     * @param e8LanguageStatus The value which will be set
     */
    inline void setE8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_);

    static const Method_SetMeterLanguageResult &getDefaultInstance();

private:

    inline void set_has_e8LanguageStatus ();

    inline void clear_has_e8LanguageStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Language_Status _e8LanguageStatus;

};

/**
 * The error message of 'Method_SetMeterLanguage'
 * Error Message
 */
class Method_SetMeterLanguageErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  Method_SetMeterLanguageErrorStructure ();

    /**
     * Copy constructor
     */
    inline  Method_SetMeterLanguageErrorStructure (const Method_SetMeterLanguageErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetMeterLanguageErrorStructure (uint16 Error_);

    /**
     * Destructor
     */
    inline  ~Method_SetMeterLanguageErrorStructure();

    /**
     * Assignment operator
     */
    inline Method_SetMeterLanguageErrorStructure& operator = (const Method_SetMeterLanguageErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetMeterLanguageErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetMeterLanguageErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetMeterLanguageErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetMeterLanguageErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Error"

    static const int kError = 0;

    /**
     * Clears the field "Error".
     *
     * The field will be set to its default value. The hasError()
     * method will return false.
     */
    inline void clearError();

    /**
     * Checks whether the field "Error" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError()). Otherwise it will return false.
     */
    inline bool hasError () const;

    /**
     * Returns the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @return The value of the field "Error"
     */
    inline uint16 getError () const;

    /**
     * Sets the value of the member "Error".
     *
     * Possible errors of a cca call from the client.
     *
     * @param Error The value which will be set
     */
    inline void setError (uint16 Error_);

    static const Method_SetMeterLanguageErrorStructure &getDefaultInstance();

private:

    inline void set_has_Error ();

    inline void clear_has_Error ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Error;

};

/**
 * The error message of 'Method_SetMeterLanguage'
 * Error Message
 */
class Method_SetMeterLanguageError  : public ::asf::core::Payload {
public:

    enum Method_SetMeterLanguageErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  Method_SetMeterLanguageError ();

   /**
     * Copy constructor
     */
    inline  Method_SetMeterLanguageError (const Method_SetMeterLanguageError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetMeterLanguageError();

    /**
     * Assigns a new value to this object.
     */
    inline Method_SetMeterLanguageError& operator = (const Method_SetMeterLanguageError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetMeterLanguageError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetMeterLanguageError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetMeterLanguageError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetMeterLanguageError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline Method_SetMeterLanguageError::Method_SetMeterLanguageErrorField getField () const;

    inline void setField(Method_SetMeterLanguageError::Method_SetMeterLanguageErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "Method_SetMeterLanguageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "Method_SetMeterLanguageErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const Method_SetMeterLanguageErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline Method_SetMeterLanguageErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline Method_SetMeterLanguageErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (Method_SetMeterLanguageErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "Method_SetMeterLanguageErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const Method_SetMeterLanguageErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const Method_SetMeterLanguageError &getDefaultInstance();

private:

    inline void cloneData (const Method_SetMeterLanguageError& rhs);

    inline void deleteData ();

    Method_SetMeterLanguageErrorField __field;

    union {
        Method_SetMeterLanguageErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "Method_SetAudioSourceInfo"
 * <p>This method is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
class Method_SetAudioSourceInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetAudioSourceInfoStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetAudioSourceInfoStart (const Method_SetAudioSourceInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetAudioSourceInfoStart (bool bCausedByUser_, const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetAudioSourceInfoStart();

    /**
     * Assignment operator
     */
    inline Method_SetAudioSourceInfoStart& operator = (const Method_SetAudioSourceInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetAudioSourceInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetAudioSourceInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetAudioSourceInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetAudioSourceInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCausedByUser"

    static const int kBCausedByUser = 0;

    /**
     * Clears the field "bCausedByUser".
     *
     * The field will be set to its default value. The hasBCausedByUser()
     * method will return false.
     */
    inline void clearBCausedByUser();

    /**
     * Checks whether the field "bCausedByUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCausedByUser()). Otherwise it will return false.
     */
    inline bool hasBCausedByUser () const;

    /**
     * Returns the value of the member "bCausedByUser".
     *
     * The changes of the audio source data are caused by a user action.
     *
     * @return The value of the field "bCausedByUser"
     */
    inline bool getBCausedByUser () const;

    /**
     * Sets the value of the member "bCausedByUser".
     *
     * The changes of the audio source data are caused by a user action.
     *
     * @param bCausedByUser The value which will be set
     */
    inline void setBCausedByUser (bool bCausedByUser_);

    // API of field "SourceInfo"

    static const int kSourceInfo = 1;

    /**
     * Clears the field "SourceInfo".
     *
     * The field will be set to its default value. The hasSourceInfo()
     * method will return false.
     */
    inline void clearSourceInfo();

    /**
     * Checks whether the field "SourceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceInfo()). Otherwise it will return false.
     */
    inline bool hasSourceInfo () const;

    /**
     * Returns the value of the member "SourceInfo".
     *
     * Union containing all information about the audio info.
     *
     * @return The value of the field "SourceInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& getSourceInfo () const;

    /**
     * Retrieves the value of the field "SourceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SourceInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& getSourceInfoMutable ();

    /**
     * Sets the value of the member "SourceInfo".
     *
     * Union containing all information about the audio info.
     *
     * @param SourceInfo The value which will be set
     */
    inline void setSourceInfo (const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_);

    static const Method_SetAudioSourceInfoStart &getDefaultInstance();

private:

    inline void set_has_bCausedByUser ();

    inline void clear_has_bCausedByUser ();

    inline void set_has_SourceInfo ();

    inline void clear_has_SourceInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bCausedByUser;

    ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion _SourceInfo;

};

/**
 * The start message of the method "Method_SetAudioWarning"
 * <p>This method is used to transmit the information about an audio warning.</p>
 */
class Method_SetAudioWarningStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetAudioWarningStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetAudioWarningStart (const Method_SetAudioWarningStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetAudioWarningStart (bool bCausedByUser_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8WarningSource_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState e8WarningState_, const ::std::string& strWarningText_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetAudioWarningStart();

    /**
     * Assignment operator
     */
    inline Method_SetAudioWarningStart& operator = (const Method_SetAudioWarningStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetAudioWarningStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetAudioWarningStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetAudioWarningStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetAudioWarningStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCausedByUser"

    static const int kBCausedByUser = 0;

    /**
     * Clears the field "bCausedByUser".
     *
     * The field will be set to its default value. The hasBCausedByUser()
     * method will return false.
     */
    inline void clearBCausedByUser();

    /**
     * Checks whether the field "bCausedByUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCausedByUser()). Otherwise it will return false.
     */
    inline bool hasBCausedByUser () const;

    /**
     * Returns the value of the member "bCausedByUser".
     *
     * The audio warning is a result of a user action.
     *
     * @return The value of the field "bCausedByUser"
     */
    inline bool getBCausedByUser () const;

    /**
     * Sets the value of the member "bCausedByUser".
     *
     * The audio warning is a result of a user action.
     *
     * @param bCausedByUser The value which will be set
     */
    inline void setBCausedByUser (bool bCausedByUser_);

    // API of field "e8WarningSource"

    static const int kE8WarningSource = 1;

    /**
     * Clears the field "e8WarningSource".
     *
     * The field will be set to its default value. The hasE8WarningSource()
     * method will return false.
     */
    inline void clearE8WarningSource();

    /**
     * Checks whether the field "e8WarningSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WarningSource()). Otherwise it will return false.
     */
    inline bool hasE8WarningSource () const;

    /**
     * Returns the value of the member "e8WarningSource".
     *
     * Audio source which is the origin of the warning.
     *
     * @return The value of the field "e8WarningSource"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source getE8WarningSource () const;

    /**
     * Sets the value of the member "e8WarningSource".
     *
     * Audio source which is the origin of the warning.
     *
     * @param e8WarningSource The value which will be set
     */
    inline void setE8WarningSource (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8WarningSource_);

    // API of field "e8WarningState"

    static const int kE8WarningState = 2;

    /**
     * Clears the field "e8WarningState".
     *
     * The field will be set to its default value. The hasE8WarningState()
     * method will return false.
     */
    inline void clearE8WarningState();

    /**
     * Checks whether the field "e8WarningState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8WarningState()). Otherwise it will return false.
     */
    inline bool hasE8WarningState () const;

    /**
     * Returns the value of the member "e8WarningState".
     *
     * State of the warning describing the warning type.
     *
     * @return The value of the field "e8WarningState"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState getE8WarningState () const;

    /**
     * Sets the value of the member "e8WarningState".
     *
     * State of the warning describing the warning type.
     *
     * @param e8WarningState The value which will be set
     */
    inline void setE8WarningState (::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState e8WarningState_);

    // API of field "strWarningText"

    static const int kStrWarningText = 3;

    /**
     * Clears the field "strWarningText".
     *
     * The field will be set to its default value. The hasStrWarningText()
     * method will return false.
     */
    inline void clearStrWarningText();

    /**
     * Checks whether the field "strWarningText" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrWarningText()). Otherwise it will return false.
     */
    inline bool hasStrWarningText () const;

    /**
     * Returns the value of the member "strWarningText".
     *
     * Free text string describing the warning.
     *
     * @return The value of the field "strWarningText"
     */
    inline const ::std::string& getStrWarningText () const;

    /**
     * Retrieves the value of the field "strWarningText" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strWarningText".
     */
    inline ::std::string& getStrWarningTextMutable ();

    /**
     * Sets the value of the member "strWarningText".
     *
     * Free text string describing the warning.
     *
     * @param strWarningText The value which will be set
     */
    inline void setStrWarningText (const ::std::string& strWarningText_);

    /**
     * Sets the value of the member "strWarningText".
     *
     * Free text string describing the warning.
     *
     * @param strWarningText The value which will be set
     */
    inline void setStrWarningText (const char* strWarningText_);

    /**
     * Sets the value of the member "strWarningText".
     *
     * Free text string describing the warning.
     *
     * @param strWarningText The value which will be set
     */
    inline void setStrWarningText (const char* value, size_t size);

    static const Method_SetAudioWarningStart &getDefaultInstance();

private:

    inline void set_has_bCausedByUser ();

    inline void clear_has_bCausedByUser ();

    inline void set_has_e8WarningSource ();

    inline void clear_has_e8WarningSource ();

    inline void set_has_e8WarningState ();

    inline void clear_has_e8WarningState ();

    inline void set_has_strWarningText ();

    inline void clear_has_strWarningText ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bCausedByUser;

    ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source _e8WarningSource;

    ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState _e8WarningState;

    ::std::string _strWarningText;

};

/**
 * The start message of the method "Method_SetAudioSpecialMode"
 * <p>This method is used to transmit the information about a currently active special audio mode
 * (Scan, Search, FastForward, Rewind).</p>
 */
class Method_SetAudioSpecialModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetAudioSpecialModeStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetAudioSpecialModeStart (const Method_SetAudioSpecialModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetAudioSpecialModeStart (::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode e8SpecialMode_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetAudioSpecialModeStart();

    /**
     * Assignment operator
     */
    inline Method_SetAudioSpecialModeStart& operator = (const Method_SetAudioSpecialModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetAudioSpecialModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetAudioSpecialModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetAudioSpecialModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetAudioSpecialModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SpecialMode"

    static const int kE8SpecialMode = 0;

    /**
     * Clears the field "e8SpecialMode".
     *
     * The field will be set to its default value. The hasE8SpecialMode()
     * method will return false.
     */
    inline void clearE8SpecialMode();

    /**
     * Checks whether the field "e8SpecialMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SpecialMode()). Otherwise it will return false.
     */
    inline bool hasE8SpecialMode () const;

    /**
     * Returns the value of the member "e8SpecialMode".
     *
     * Type of special audio mode, "None" if no special audio mode is active.
     *
     * @return The value of the field "e8SpecialMode"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode getE8SpecialMode () const;

    /**
     * Sets the value of the member "e8SpecialMode".
     *
     * Type of special audio mode, "None" if no special audio mode is active.
     *
     * @param e8SpecialMode The value which will be set
     */
    inline void setE8SpecialMode (::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode e8SpecialMode_);

    static const Method_SetAudioSpecialModeStart &getDefaultInstance();

private:

    inline void set_has_e8SpecialMode ();

    inline void clear_has_e8SpecialMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode _e8SpecialMode;

};

/**
 * The start message of the method "Method_SetMediaBrowserList_HighlightedElement"
 * <p>This method is used to show what's been highlighted in HMI media browser list and about which input device is been used for doing the same.</p>
 */
class Method_SetMediaBrowserList_HighlightedElementStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_SetMediaBrowserList_HighlightedElementStart ();

    /**
     * Copy constructor
     */
    inline  Method_SetMediaBrowserList_HighlightedElementStart (const Method_SetMediaBrowserList_HighlightedElementStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_SetMediaBrowserList_HighlightedElementStart (const ::std::string& ElementName_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType ElementType_, ::datacollector_main_fi_types::T_e8_datacollector_InputDevice InputDevice_);

    /**
     * Destructor
     */
    inline virtual  ~Method_SetMediaBrowserList_HighlightedElementStart();

    /**
     * Assignment operator
     */
    inline Method_SetMediaBrowserList_HighlightedElementStart& operator = (const Method_SetMediaBrowserList_HighlightedElementStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ElementName"

    static const int kElementName = 0;

    /**
     * Clears the field "ElementName".
     *
     * The field will be set to its default value. The hasElementName()
     * method will return false.
     */
    inline void clearElementName();

    /**
     * Checks whether the field "ElementName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElementName()). Otherwise it will return false.
     */
    inline bool hasElementName () const;

    /**
     * Returns the value of the member "ElementName".
     *
     * Text of currently highlighted element. E.g. folder or track name
     *
     * @return The value of the field "ElementName"
     */
    inline const ::std::string& getElementName () const;

    /**
     * Retrieves the value of the field "ElementName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ElementName".
     */
    inline ::std::string& getElementNameMutable ();

    /**
     * Sets the value of the member "ElementName".
     *
     * Text of currently highlighted element. E.g. folder or track name
     *
     * @param ElementName The value which will be set
     */
    inline void setElementName (const ::std::string& ElementName_);

    /**
     * Sets the value of the member "ElementName".
     *
     * Text of currently highlighted element. E.g. folder or track name
     *
     * @param ElementName The value which will be set
     */
    inline void setElementName (const char* ElementName_);

    /**
     * Sets the value of the member "ElementName".
     *
     * Text of currently highlighted element. E.g. folder or track name
     *
     * @param ElementName The value which will be set
     */
    inline void setElementName (const char* value, size_t size);

    // API of field "ElementType"

    static const int kElementType = 1;

    /**
     * Clears the field "ElementType".
     *
     * The field will be set to its default value. The hasElementType()
     * method will return false.
     */
    inline void clearElementType();

    /**
     * Checks whether the field "ElementType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElementType()). Otherwise it will return false.
     */
    inline bool hasElementType () const;

    /**
     * Returns the value of the member "ElementType".
     *
     * Type of the highlighted element.
     *
     * @return The value of the field "ElementType"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType getElementType () const;

    /**
     * Sets the value of the member "ElementType".
     *
     * Type of the highlighted element.
     *
     * @param ElementType The value which will be set
     */
    inline void setElementType (::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType ElementType_);

    // API of field "InputDevice"

    static const int kInputDevice = 2;

    /**
     * Clears the field "InputDevice".
     *
     * The field will be set to its default value. The hasInputDevice()
     * method will return false.
     */
    inline void clearInputDevice();

    /**
     * Checks whether the field "InputDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInputDevice()). Otherwise it will return false.
     */
    inline bool hasInputDevice () const;

    /**
     * Returns the value of the member "InputDevice".
     *
     * Input device which was used to move to the element
     *
     * @return The value of the field "InputDevice"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_InputDevice getInputDevice () const;

    /**
     * Sets the value of the member "InputDevice".
     *
     * Input device which was used to move to the element
     *
     * @param InputDevice The value which will be set
     */
    inline void setInputDevice (::datacollector_main_fi_types::T_e8_datacollector_InputDevice InputDevice_);

    static const Method_SetMediaBrowserList_HighlightedElementStart &getDefaultInstance();

private:

    inline void set_has_ElementName ();

    inline void clear_has_ElementName ();

    inline void set_has_ElementType ();

    inline void clear_has_ElementType ();

    inline void set_has_InputDevice ();

    inline void clear_has_InputDevice ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _ElementName;

    ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType _ElementType;

    ::datacollector_main_fi_types::T_e8_datacollector_InputDevice _InputDevice;

};

/**
 * The start message of the method "Method_CurrentHeadUnitTunerMode"
 * <p>This method is used to show which Tuner HMI mode is shown. The options include List, Frequency, and Preset.</p>
 */
class Method_CurrentHeadUnitTunerModeStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_CurrentHeadUnitTunerModeStart ();

    /**
     * Copy constructor
     */
    inline  Method_CurrentHeadUnitTunerModeStart (const Method_CurrentHeadUnitTunerModeStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_CurrentHeadUnitTunerModeStart (::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode e8CurrentHeadUnitTunerMode_);

    /**
     * Destructor
     */
    inline virtual  ~Method_CurrentHeadUnitTunerModeStart();

    /**
     * Assignment operator
     */
    inline Method_CurrentHeadUnitTunerModeStart& operator = (const Method_CurrentHeadUnitTunerModeStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_CurrentHeadUnitTunerModeStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_CurrentHeadUnitTunerModeStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_CurrentHeadUnitTunerModeStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_CurrentHeadUnitTunerModeStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8CurrentHeadUnitTunerMode"

    static const int kE8CurrentHeadUnitTunerMode = 0;

    /**
     * Clears the field "e8CurrentHeadUnitTunerMode".
     *
     * The field will be set to its default value. The hasE8CurrentHeadUnitTunerMode()
     * method will return false.
     */
    inline void clearE8CurrentHeadUnitTunerMode();

    /**
     * Checks whether the field "e8CurrentHeadUnitTunerMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8CurrentHeadUnitTunerMode()). Otherwise it will return false.
     */
    inline bool hasE8CurrentHeadUnitTunerMode () const;

    /**
     * Returns the value of the member "e8CurrentHeadUnitTunerMode".
     *
     * Currently selected Tuner HMI screen i.e. List, Frequency of Preset
     *
     * @return The value of the field "e8CurrentHeadUnitTunerMode"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode getE8CurrentHeadUnitTunerMode () const;

    /**
     * Sets the value of the member "e8CurrentHeadUnitTunerMode".
     *
     * Currently selected Tuner HMI screen i.e. List, Frequency of Preset
     *
     * @param e8CurrentHeadUnitTunerMode The value which will be set
     */
    inline void setE8CurrentHeadUnitTunerMode (::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode e8CurrentHeadUnitTunerMode_);

    static const Method_CurrentHeadUnitTunerModeStart &getDefaultInstance();

private:

    inline void set_has_e8CurrentHeadUnitTunerMode ();

    inline void clear_has_e8CurrentHeadUnitTunerMode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode _e8CurrentHeadUnitTunerMode;

};

/**
 * The start message of the method "Method_RenaultUpdateListStatus"
 * <p>This method is to provide the status of the "Updating List" from the Renault Tuner screen.</p>
 */
class Method_RenaultUpdateListStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Method_RenaultUpdateListStatusStart ();

    /**
     * Copy constructor
     */
    inline  Method_RenaultUpdateListStatusStart (const Method_RenaultUpdateListStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  Method_RenaultUpdateListStatusStart (::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value e8RenaultUpdateListStatus_);

    /**
     * Destructor
     */
    inline virtual  ~Method_RenaultUpdateListStatusStart();

    /**
     * Assignment operator
     */
    inline Method_RenaultUpdateListStatusStart& operator = (const Method_RenaultUpdateListStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Method_RenaultUpdateListStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Method_RenaultUpdateListStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Method_RenaultUpdateListStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Method_RenaultUpdateListStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RenaultUpdateListStatus"

    static const int kE8RenaultUpdateListStatus = 0;

    /**
     * Clears the field "e8RenaultUpdateListStatus".
     *
     * The field will be set to its default value. The hasE8RenaultUpdateListStatus()
     * method will return false.
     */
    inline void clearE8RenaultUpdateListStatus();

    /**
     * Checks whether the field "e8RenaultUpdateListStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RenaultUpdateListStatus()). Otherwise it will return false.
     */
    inline bool hasE8RenaultUpdateListStatus () const;

    /**
     * Returns the value of the member "e8RenaultUpdateListStatus".
     *
     * Current status of the Updating List screen from the Renault Tuner HMI.
     *
     * @return The value of the field "e8RenaultUpdateListStatus"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value getE8RenaultUpdateListStatus () const;

    /**
     * Sets the value of the member "e8RenaultUpdateListStatus".
     *
     * Current status of the Updating List screen from the Renault Tuner HMI.
     *
     * @param e8RenaultUpdateListStatus The value which will be set
     */
    inline void setE8RenaultUpdateListStatus (::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value e8RenaultUpdateListStatus_);

    static const Method_RenaultUpdateListStatusStart &getDefaultInstance();

private:

    inline void set_has_e8RenaultUpdateListStatus ();

    inline void clear_has_e8RenaultUpdateListStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value _e8RenaultUpdateListStatus;

};

/**
 * The status message of the property "Property_SetAudioSourceInfo"
 * <p>This property is used to transmit the information about the current audio source.</p>
 * <p>As there is always only one audio source active at the same time, a switching of the audio
 * source will just end up in sending one method containing the current data of the new source.</p>
 * <p>By using only one method for the complete data set inconsistency of the data is avoided.</p>
 * <p>The data differ according to the current type of source. Therefore, they will be transmitted
 * as a union distinguishing between four types: Radio, Media, Aux, and External Sound.</p>
 */
class Property_SetAudioSourceInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_SetAudioSourceInfoStatus ();

    /**
     * Copy constructor
     */
    inline  Property_SetAudioSourceInfoStatus (const Property_SetAudioSourceInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_SetAudioSourceInfoStatus (bool bCausedByUser_, const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~Property_SetAudioSourceInfoStatus();

    /**
     * Assignment operator
     */
    inline Property_SetAudioSourceInfoStatus& operator = (const Property_SetAudioSourceInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_SetAudioSourceInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_SetAudioSourceInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_SetAudioSourceInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_SetAudioSourceInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCausedByUser"

    static const int kBCausedByUser = 0;

    /**
     * Clears the field "bCausedByUser".
     *
     * The field will be set to its default value. The hasBCausedByUser()
     * method will return false.
     */
    inline void clearBCausedByUser();

    /**
     * Checks whether the field "bCausedByUser" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCausedByUser()). Otherwise it will return false.
     */
    inline bool hasBCausedByUser () const;

    /**
     * Returns the value of the member "bCausedByUser".
     *
     * The changes of the audio source data are caused by a user action.
     *
     * @return The value of the field "bCausedByUser"
     */
    inline bool getBCausedByUser () const;

    /**
     * Sets the value of the member "bCausedByUser".
     *
     * The changes of the audio source data are caused by a user action.
     *
     * @param bCausedByUser The value which will be set
     */
    inline void setBCausedByUser (bool bCausedByUser_);

    // API of field "SourceInfo"

    static const int kSourceInfo = 1;

    /**
     * Clears the field "SourceInfo".
     *
     * The field will be set to its default value. The hasSourceInfo()
     * method will return false.
     */
    inline void clearSourceInfo();

    /**
     * Checks whether the field "SourceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSourceInfo()). Otherwise it will return false.
     */
    inline bool hasSourceInfo () const;

    /**
     * Returns the value of the member "SourceInfo".
     *
     * Union containing all information about the audio info.
     *
     * @return The value of the field "SourceInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& getSourceInfo () const;

    /**
     * Retrieves the value of the field "SourceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SourceInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& getSourceInfoMutable ();

    /**
     * Sets the value of the member "SourceInfo".
     *
     * Union containing all information about the audio info.
     *
     * @param SourceInfo The value which will be set
     */
    inline void setSourceInfo (const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_);

    static const Property_SetAudioSourceInfoStatus &getDefaultInstance();

private:

    inline void set_has_bCausedByUser ();

    inline void clear_has_bCausedByUser ();

    inline void set_has_SourceInfo ();

    inline void clear_has_SourceInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bCausedByUser;

    ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion _SourceInfo;

};

/**
 * The status message of the property "Property_SetNaviSwipe"
 * This Property is used to trigger Swipe Command to Meter
 */
class Property_SetNaviSwipeStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_SetNaviSwipeStatus ();

    /**
     * Copy constructor
     */
    inline  Property_SetNaviSwipeStatus (const Property_SetNaviSwipeStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_SetNaviSwipeStatus (bool bSwipeBeep_);

    /**
     * Destructor
     */
    inline virtual  ~Property_SetNaviSwipeStatus();

    /**
     * Assignment operator
     */
    inline Property_SetNaviSwipeStatus& operator = (const Property_SetNaviSwipeStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_SetNaviSwipeStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_SetNaviSwipeStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_SetNaviSwipeStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_SetNaviSwipeStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSwipeBeep"

    static const int kBSwipeBeep = 0;

    /**
     * Clears the field "bSwipeBeep".
     *
     * The field will be set to its default value. The hasBSwipeBeep()
     * method will return false.
     */
    inline void clearBSwipeBeep();

    /**
     * Checks whether the field "bSwipeBeep" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSwipeBeep()). Otherwise it will return false.
     */
    inline bool hasBSwipeBeep () const;

    /**
     * Returns the value of the member "bSwipeBeep".
     *
     * <p>FALSE: Beep is not active</p>
     * <p>TRUE: Beep is active</p>
     *
     * @return The value of the field "bSwipeBeep"
     */
    inline bool getBSwipeBeep () const;

    /**
     * Sets the value of the member "bSwipeBeep".
     *
     * <p>FALSE: Beep is not active</p>
     * <p>TRUE: Beep is active</p>
     *
     * @param bSwipeBeep The value which will be set
     */
    inline void setBSwipeBeep (bool bSwipeBeep_);

    static const Property_SetNaviSwipeStatus &getDefaultInstance();

private:

    inline void set_has_bSwipeBeep ();

    inline void clear_has_bSwipeBeep ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSwipeBeep;

};

/**
 * The start message of the method "SetPhoneIncomingCallInfo"
 * <p>This method is used to transmit the information about a currently received incoming call
 * leading to a popup in the meter instrument analogous to the popup on the LCN main screen.</p>
 * <p>The parameter bIncoming shall be set to "true" as long as the call is incoming (ringing).
 * When it changes to active or end, the parameter shall be set to "false" again.</p>
 */
class SetPhoneIncomingCallInfoStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPhoneIncomingCallInfoStart ();

    /**
     * Copy constructor
     */
    inline  SetPhoneIncomingCallInfoStart (const SetPhoneIncomingCallInfoStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetPhoneIncomingCallInfoStart (bool bIncoming_, const ::std::string& strCallerInfo_);

    /**
     * Destructor
     */
    inline virtual  ~SetPhoneIncomingCallInfoStart();

    /**
     * Assignment operator
     */
    inline SetPhoneIncomingCallInfoStart& operator = (const SetPhoneIncomingCallInfoStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPhoneIncomingCallInfoStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPhoneIncomingCallInfoStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPhoneIncomingCallInfoStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPhoneIncomingCallInfoStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bIncoming"

    static const int kBIncoming = 0;

    /**
     * Clears the field "bIncoming".
     *
     * The field will be set to its default value. The hasBIncoming()
     * method will return false.
     */
    inline void clearBIncoming();

    /**
     * Checks whether the field "bIncoming" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIncoming()). Otherwise it will return false.
     */
    inline bool hasBIncoming () const;

    /**
     * Returns the value of the member "bIncoming".
     *
     * <p>FALSE: No incoming call, i.e. either no call at all or the call is active.</p>
     * <p>TRUE: Call is currently incoming (ringing).</p>
     *
     * @return The value of the field "bIncoming"
     */
    inline bool getBIncoming () const;

    /**
     * Sets the value of the member "bIncoming".
     *
     * <p>FALSE: No incoming call, i.e. either no call at all or the call is active.</p>
     * <p>TRUE: Call is currently incoming (ringing).</p>
     *
     * @param bIncoming The value which will be set
     */
    inline void setBIncoming (bool bIncoming_);

    // API of field "strCallerInfo"

    static const int kStrCallerInfo = 1;

    /**
     * Clears the field "strCallerInfo".
     *
     * The field will be set to its default value. The hasStrCallerInfo()
     * method will return false.
     */
    inline void clearStrCallerInfo();

    /**
     * Checks whether the field "strCallerInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrCallerInfo()). Otherwise it will return false.
     */
    inline bool hasStrCallerInfo () const;

    /**
     * Returns the value of the member "strCallerInfo".
     *
     * <p>String giving either the name of the caller when the number is found in the phonebook
     * or the phone number when no matching entry could be found. If no info about the caller
     * is available (not even the number), the string shall be cleared.</p>
     * <p>During an active call, i.e. when the parameter bIncoming is set to "false", the string
     * may be filled with the caller info, but currently this is not necessary, because the
     * information is used by the meter only to show a popup during an incoming call.</p>
     *
     * @return The value of the field "strCallerInfo"
     */
    inline const ::std::string& getStrCallerInfo () const;

    /**
     * Retrieves the value of the field "strCallerInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strCallerInfo".
     */
    inline ::std::string& getStrCallerInfoMutable ();

    /**
     * Sets the value of the member "strCallerInfo".
     *
     * <p>String giving either the name of the caller when the number is found in the phonebook
     * or the phone number when no matching entry could be found. If no info about the caller
     * is available (not even the number), the string shall be cleared.</p>
     * <p>During an active call, i.e. when the parameter bIncoming is set to "false", the string
     * may be filled with the caller info, but currently this is not necessary, because the
     * information is used by the meter only to show a popup during an incoming call.</p>
     *
     * @param strCallerInfo The value which will be set
     */
    inline void setStrCallerInfo (const ::std::string& strCallerInfo_);

    /**
     * Sets the value of the member "strCallerInfo".
     *
     * <p>String giving either the name of the caller when the number is found in the phonebook
     * or the phone number when no matching entry could be found. If no info about the caller
     * is available (not even the number), the string shall be cleared.</p>
     * <p>During an active call, i.e. when the parameter bIncoming is set to "false", the string
     * may be filled with the caller info, but currently this is not necessary, because the
     * information is used by the meter only to show a popup during an incoming call.</p>
     *
     * @param strCallerInfo The value which will be set
     */
    inline void setStrCallerInfo (const char* strCallerInfo_);

    /**
     * Sets the value of the member "strCallerInfo".
     *
     * <p>String giving either the name of the caller when the number is found in the phonebook
     * or the phone number when no matching entry could be found. If no info about the caller
     * is available (not even the number), the string shall be cleared.</p>
     * <p>During an active call, i.e. when the parameter bIncoming is set to "false", the string
     * may be filled with the caller info, but currently this is not necessary, because the
     * information is used by the meter only to show a popup during an incoming call.</p>
     *
     * @param strCallerInfo The value which will be set
     */
    inline void setStrCallerInfo (const char* value, size_t size);

    static const SetPhoneIncomingCallInfoStart &getDefaultInstance();

private:

    inline void set_has_bIncoming ();

    inline void clear_has_bIncoming ();

    inline void set_has_strCallerInfo ();

    inline void clear_has_strCallerInfo ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bIncoming;

    ::std::string _strCallerInfo;

};

/**
 * The status message of the property "Property_SmsSendStatus"
 * This property gives information about state of sending SMSs.
 */
class Property_SmsSendStatusStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_SmsSendStatusStatus ();

    /**
     * Copy constructor
     */
    inline  Property_SmsSendStatusStatus (const Property_SmsSendStatusStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_SmsSendStatusStatus (::datacollector_main_fi_types::T_e8_datacollector_SmsSendState eSmsSendState_);

    /**
     * Destructor
     */
    inline virtual  ~Property_SmsSendStatusStatus();

    /**
     * Assignment operator
     */
    inline Property_SmsSendStatusStatus& operator = (const Property_SmsSendStatusStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_SmsSendStatusStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_SmsSendStatusStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_SmsSendStatusStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_SmsSendStatusStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "eSmsSendState"

    static const int kESmsSendState = 0;

    /**
     * Clears the field "eSmsSendState".
     *
     * The field will be set to its default value. The hasESmsSendState()
     * method will return false.
     */
    inline void clearESmsSendState();

    /**
     * Checks whether the field "eSmsSendState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setESmsSendState()). Otherwise it will return false.
     */
    inline bool hasESmsSendState () const;

    /**
     * Returns the value of the member "eSmsSendState".
     *
     * If the meaning of "eSmsSendState" isn't clear, then there should be a description here.
     *
     * @return The value of the field "eSmsSendState"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_SmsSendState getESmsSendState () const;

    /**
     * Sets the value of the member "eSmsSendState".
     *
     * If the meaning of "eSmsSendState" isn't clear, then there should be a description here.
     *
     * @param eSmsSendState The value which will be set
     */
    inline void setESmsSendState (::datacollector_main_fi_types::T_e8_datacollector_SmsSendState eSmsSendState_);

    static const Property_SmsSendStatusStatus &getDefaultInstance();

private:

    inline void set_has_eSmsSendState ();

    inline void clear_has_eSmsSendState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_SmsSendState _eSmsSendState;

};

/**
 * The start message of the method "SetPhoneWaitingModeSetting"
 * This method is used to transmit the status of a waiting mode .
 */
class SetPhoneWaitingModeSettingStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPhoneWaitingModeSettingStart ();

    /**
     * Copy constructor
     */
    inline  SetPhoneWaitingModeSettingStart (const SetPhoneWaitingModeSettingStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetPhoneWaitingModeSettingStart (bool bIsAutomatic_);

    /**
     * Destructor
     */
    inline virtual  ~SetPhoneWaitingModeSettingStart();

    /**
     * Assignment operator
     */
    inline SetPhoneWaitingModeSettingStart& operator = (const SetPhoneWaitingModeSettingStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPhoneWaitingModeSettingStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPhoneWaitingModeSettingStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPhoneWaitingModeSettingStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPhoneWaitingModeSettingStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bIsAutomatic"

    static const int kBIsAutomatic = 0;

    /**
     * Clears the field "bIsAutomatic".
     *
     * The field will be set to its default value. The hasBIsAutomatic()
     * method will return false.
     */
    inline void clearBIsAutomatic();

    /**
     * Checks whether the field "bIsAutomatic" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsAutomatic()). Otherwise it will return false.
     */
    inline bool hasBIsAutomatic () const;

    /**
     * Returns the value of the member "bIsAutomatic".
     *
     * bIsAutomatic - 0 - Automatic is selected for waiting mode
     * bIsAutomatic - 1 - Manual is selected for waiting mode
     *
     * @return The value of the field "bIsAutomatic"
     */
    inline bool getBIsAutomatic () const;

    /**
     * Sets the value of the member "bIsAutomatic".
     *
     * bIsAutomatic - 0 - Automatic is selected for waiting mode
     * bIsAutomatic - 1 - Manual is selected for waiting mode
     *
     * @param bIsAutomatic The value which will be set
     */
    inline void setBIsAutomatic (bool bIsAutomatic_);

    static const SetPhoneWaitingModeSettingStart &getDefaultInstance();

private:

    inline void set_has_bIsAutomatic ();

    inline void clear_has_bIsAutomatic ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bIsAutomatic;

};

/**
 * The start message of the method "SetPhonePrivateModeSettings"
 * This method is used to transmit the status of a Private mode(Driver only profile) set in Phone HMI.
 */
class SetPhonePrivateModeSettingsStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPhonePrivateModeSettingsStart ();

    /**
     * Copy constructor
     */
    inline  SetPhonePrivateModeSettingsStart (const SetPhonePrivateModeSettingsStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetPhonePrivateModeSettingsStart (bool bIsPrivateModeOn_);

    /**
     * Destructor
     */
    inline virtual  ~SetPhonePrivateModeSettingsStart();

    /**
     * Assignment operator
     */
    inline SetPhonePrivateModeSettingsStart& operator = (const SetPhonePrivateModeSettingsStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPhonePrivateModeSettingsStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPhonePrivateModeSettingsStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPhonePrivateModeSettingsStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPhonePrivateModeSettingsStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bIsPrivateModeOn"

    static const int kBIsPrivateModeOn = 0;

    /**
     * Clears the field "bIsPrivateModeOn".
     *
     * The field will be set to its default value. The hasBIsPrivateModeOn()
     * method will return false.
     */
    inline void clearBIsPrivateModeOn();

    /**
     * Checks whether the field "bIsPrivateModeOn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsPrivateModeOn()). Otherwise it will return false.
     */
    inline bool hasBIsPrivateModeOn () const;

    /**
     * Returns the value of the member "bIsPrivateModeOn".
     *
     * bIsPrivateModeOn - 0 - Driver only profile is set in HMI
     * bIsPrivateModeOn - 1 - Driver only profile is NOT set in HMI (Normal Mode)
     *
     * @return The value of the field "bIsPrivateModeOn"
     */
    inline bool getBIsPrivateModeOn () const;

    /**
     * Sets the value of the member "bIsPrivateModeOn".
     *
     * bIsPrivateModeOn - 0 - Driver only profile is set in HMI
     * bIsPrivateModeOn - 1 - Driver only profile is NOT set in HMI (Normal Mode)
     *
     * @param bIsPrivateModeOn The value which will be set
     */
    inline void setBIsPrivateModeOn (bool bIsPrivateModeOn_);

    static const SetPhonePrivateModeSettingsStart &getDefaultInstance();

private:

    inline void set_has_bIsPrivateModeOn ();

    inline void clear_has_bIsPrivateModeOn ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bIsPrivateModeOn;

};

/**
 * The start message of the method "SetIsWaitmodeSupportedByPhone"
 * This method is used to transmit the status of  whether or not connected phone supports waiting mode feature
 */
class SetIsWaitmodeSupportedByPhoneStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetIsWaitmodeSupportedByPhoneStart ();

    /**
     * Copy constructor
     */
    inline  SetIsWaitmodeSupportedByPhoneStart (const SetIsWaitmodeSupportedByPhoneStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetIsWaitmodeSupportedByPhoneStart (bool bIsWaitModeSupported_);

    /**
     * Destructor
     */
    inline virtual  ~SetIsWaitmodeSupportedByPhoneStart();

    /**
     * Assignment operator
     */
    inline SetIsWaitmodeSupportedByPhoneStart& operator = (const SetIsWaitmodeSupportedByPhoneStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetIsWaitmodeSupportedByPhoneStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetIsWaitmodeSupportedByPhoneStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetIsWaitmodeSupportedByPhoneStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetIsWaitmodeSupportedByPhoneStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bIsWaitModeSupported"

    static const int kBIsWaitModeSupported = 0;

    /**
     * Clears the field "bIsWaitModeSupported".
     *
     * The field will be set to its default value. The hasBIsWaitModeSupported()
     * method will return false.
     */
    inline void clearBIsWaitModeSupported();

    /**
     * Checks whether the field "bIsWaitModeSupported" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsWaitModeSupported()). Otherwise it will return false.
     */
    inline bool hasBIsWaitModeSupported () const;

    /**
     * Returns the value of the member "bIsWaitModeSupported".
     *
     * bIsWaitModeSupported - 0 - Waiting mode feature is supported by connected phone
     * bIsWaitModeSupported - 1 - Waiting mode feature is NOT supported by connected phone
     *
     * @return The value of the field "bIsWaitModeSupported"
     */
    inline bool getBIsWaitModeSupported () const;

    /**
     * Sets the value of the member "bIsWaitModeSupported".
     *
     * bIsWaitModeSupported - 0 - Waiting mode feature is supported by connected phone
     * bIsWaitModeSupported - 1 - Waiting mode feature is NOT supported by connected phone
     *
     * @param bIsWaitModeSupported The value which will be set
     */
    inline void setBIsWaitModeSupported (bool bIsWaitModeSupported_);

    static const SetIsWaitmodeSupportedByPhoneStart &getDefaultInstance();

private:

    inline void set_has_bIsWaitModeSupported ();

    inline void clear_has_bIsWaitModeSupported ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bIsWaitModeSupported;

};

/**
 * The start message of the method "SetVoiceRecognitionStatus"
 * This method is used to transmit the status of a currently running voice recognition session
 * leading to a popup in the meter instrument.
 */
class SetVoiceRecognitionStatusStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetVoiceRecognitionStatusStart ();

    /**
     * Copy constructor
     */
    inline  SetVoiceRecognitionStatusStart (const SetVoiceRecognitionStatusStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetVoiceRecognitionStatusStart (::datacollector_main_fi_types::T_e8_datacollector_VR_State e8VRState_);

    /**
     * Destructor
     */
    inline virtual  ~SetVoiceRecognitionStatusStart();

    /**
     * Assignment operator
     */
    inline SetVoiceRecognitionStatusStart& operator = (const SetVoiceRecognitionStatusStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetVoiceRecognitionStatusStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetVoiceRecognitionStatusStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetVoiceRecognitionStatusStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetVoiceRecognitionStatusStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8VRState"

    static const int kE8VRState = 0;

    /**
     * Clears the field "e8VRState".
     *
     * The field will be set to its default value. The hasE8VRState()
     * method will return false.
     */
    inline void clearE8VRState();

    /**
     * Checks whether the field "e8VRState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8VRState()). Otherwise it will return false.
     */
    inline bool hasE8VRState () const;

    /**
     * Returns the value of the member "e8VRState".
     *
     * Status of the voice recognition (Idle, Listening, Processing).
     *
     * @return The value of the field "e8VRState"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_VR_State getE8VRState () const;

    /**
     * Sets the value of the member "e8VRState".
     *
     * Status of the voice recognition (Idle, Listening, Processing).
     *
     * @param e8VRState The value which will be set
     */
    inline void setE8VRState (::datacollector_main_fi_types::T_e8_datacollector_VR_State e8VRState_);

    static const SetVoiceRecognitionStatusStart &getDefaultInstance();

private:

    inline void set_has_e8VRState ();

    inline void clear_has_e8VRState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::datacollector_main_fi_types::T_e8_datacollector_VR_State _e8VRState;

};

/**
 * The status message of the property "Property_HMIStatusBarInfo"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
class Property_HMIStatusBarInfoStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  Property_HMIStatusBarInfoStatus ();

    /**
     * Copy constructor
     */
    inline  Property_HMIStatusBarInfoStatus (const Property_HMIStatusBarInfoStatus &rhs);

    /**
     * All fields constructor
     */
    inline  Property_HMIStatusBarInfoStatus (const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& ClockTimeInfo_, const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& PhoneInfo_, uint8 TAInfo_, const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& SMSInfo_, bool TCUStatus_, const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& DownloadStatus_, const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& HVACInfo_, const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& AudioInfo_, ::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState PhoneBookDownloadState_);

    /**
     * Destructor
     */
    inline virtual  ~Property_HMIStatusBarInfoStatus();

    /**
     * Assignment operator
     */
    inline Property_HMIStatusBarInfoStatus& operator = (const Property_HMIStatusBarInfoStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const Property_HMIStatusBarInfoStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const Property_HMIStatusBarInfoStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const Property_HMIStatusBarInfoStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const Property_HMIStatusBarInfoStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ClockTimeInfo"

    static const int kClockTimeInfo = 0;

    /**
     * Clears the field "ClockTimeInfo".
     *
     * The field will be set to its default value. The hasClockTimeInfo()
     * method will return false.
     */
    inline void clearClockTimeInfo();

    /**
     * Checks whether the field "ClockTimeInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setClockTimeInfo()). Otherwise it will return false.
     */
    inline bool hasClockTimeInfo () const;

    /**
     * Returns the value of the member "ClockTimeInfo".
     *
     * This structure gives current time in hours and minutes based on the time and time format received from VD_Clock.
     * Also it gives information on AM,PM if time format is in 12 hour mode.
     *
     * @return The value of the field "ClockTimeInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& getClockTimeInfo () const;

    /**
     * Retrieves the value of the field "ClockTimeInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ClockTimeInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& getClockTimeInfoMutable ();

    /**
     * Sets the value of the member "ClockTimeInfo".
     *
     * This structure gives current time in hours and minutes based on the time and time format received from VD_Clock.
     * Also it gives information on AM,PM if time format is in 12 hour mode.
     *
     * @param ClockTimeInfo The value which will be set
     */
    inline void setClockTimeInfo (const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& ClockTimeInfo_);

    // API of field "PhoneInfo"

    static const int kPhoneInfo = 1;

    /**
     * Clears the field "PhoneInfo".
     *
     * The field will be set to its default value. The hasPhoneInfo()
     * method will return false.
     */
    inline void clearPhoneInfo();

    /**
     * Checks whether the field "PhoneInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneInfo()). Otherwise it will return false.
     */
    inline bool hasPhoneInfo () const;

    /**
     * Returns the value of the member "PhoneInfo".
     *
     * This structure gives info on BT connection status, Battery residual quantity and Mobile phone field strength.
     *
     * @return The value of the field "PhoneInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& getPhoneInfo () const;

    /**
     * Retrieves the value of the field "PhoneInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PhoneInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& getPhoneInfoMutable ();

    /**
     * Sets the value of the member "PhoneInfo".
     *
     * This structure gives info on BT connection status, Battery residual quantity and Mobile phone field strength.
     *
     * @param PhoneInfo The value which will be set
     */
    inline void setPhoneInfo (const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& PhoneInfo_);

    // API of field "TAInfo"

    static const int kTAInfo = 2;

    /**
     * Clears the field "TAInfo".
     *
     * The field will be set to its default value. The hasTAInfo()
     * method will return false.
     */
    inline void clearTAInfo();

    /**
     * Checks whether the field "TAInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTAInfo()). Otherwise it will return false.
     */
    inline bool hasTAInfo () const;

    /**
     * Returns the value of the member "TAInfo".
     *
     * This parameter gives TA status.
     * 0 --> TA NO Display
     * 1--> Display TA and TP station
     * 2--> Display TA and Non TP station
     *
     * @return The value of the field "TAInfo"
     */
    inline uint8 getTAInfo () const;

    /**
     * Sets the value of the member "TAInfo".
     *
     * This parameter gives TA status.
     * 0 --> TA NO Display
     * 1--> Display TA and TP station
     * 2--> Display TA and Non TP station
     *
     * @param TAInfo The value which will be set
     */
    inline void setTAInfo (uint8 TAInfo_);

    // API of field "SMSInfo"

    static const int kSMSInfo = 3;

    /**
     * Clears the field "SMSInfo".
     *
     * The field will be set to its default value. The hasSMSInfo()
     * method will return false.
     */
    inline void clearSMSInfo();

    /**
     * Checks whether the field "SMSInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMSInfo()). Otherwise it will return false.
     */
    inline bool hasSMSInfo () const;

    /**
     * Returns the value of the member "SMSInfo".
     *
     * This structure gives info on number of unread SMS, notification on new SMS and senders name etc.
     *
     * @return The value of the field "SMSInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& getSMSInfo () const;

    /**
     * Retrieves the value of the field "SMSInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SMSInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& getSMSInfoMutable ();

    /**
     * Sets the value of the member "SMSInfo".
     *
     * This structure gives info on number of unread SMS, notification on new SMS and senders name etc.
     *
     * @param SMSInfo The value which will be set
     */
    inline void setSMSInfo (const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& SMSInfo_);

    // API of field "TCUStatus"

    static const int kTCUStatus = 4;

    /**
     * Clears the field "TCUStatus".
     *
     * The field will be set to its default value. The hasTCUStatus()
     * method will return false.
     */
    inline void clearTCUStatus();

    /**
     * Checks whether the field "TCUStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTCUStatus()). Otherwise it will return false.
     */
    inline bool hasTCUStatus () const;

    /**
     * Returns the value of the member "TCUStatus".
     *
     * TRUE : TCU is ON
     * FALSE : TCU is OFF
     *
     * @return The value of the field "TCUStatus"
     */
    inline bool getTCUStatus () const;

    /**
     * Sets the value of the member "TCUStatus".
     *
     * TRUE : TCU is ON
     * FALSE : TCU is OFF
     *
     * @param TCUStatus The value which will be set
     */
    inline void setTCUStatus (bool TCUStatus_);

    // API of field "DownloadStatus"

    static const int kDownloadStatus = 5;

    /**
     * Clears the field "DownloadStatus".
     *
     * The field will be set to its default value. The hasDownloadStatus()
     * method will return false.
     */
    inline void clearDownloadStatus();

    /**
     * Checks whether the field "DownloadStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadStatus()). Otherwise it will return false.
     */
    inline bool hasDownloadStatus () const;

    /**
     * Returns the value of the member "DownloadStatus".
     *
     * This structure gives info about download details
     *
     * @return The value of the field "DownloadStatus"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& getDownloadStatus () const;

    /**
     * Retrieves the value of the field "DownloadStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DownloadStatus".
     */
    inline ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& getDownloadStatusMutable ();

    /**
     * Sets the value of the member "DownloadStatus".
     *
     * This structure gives info about download details
     *
     * @param DownloadStatus The value which will be set
     */
    inline void setDownloadStatus (const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& DownloadStatus_);

    // API of field "HVACInfo"

    static const int kHVACInfo = 6;

    /**
     * Clears the field "HVACInfo".
     *
     * The field will be set to its default value. The hasHVACInfo()
     * method will return false.
     */
    inline void clearHVACInfo();

    /**
     * Checks whether the field "HVACInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHVACInfo()). Otherwise it will return false.
     */
    inline bool hasHVACInfo () const;

    /**
     * Returns the value of the member "HVACInfo".
     *
     * This structure gives info on temperature and the unit from HVAC component.
     *
     * @return The value of the field "HVACInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& getHVACInfo () const;

    /**
     * Retrieves the value of the field "HVACInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "HVACInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& getHVACInfoMutable ();

    /**
     * Sets the value of the member "HVACInfo".
     *
     * This structure gives info on temperature and the unit from HVAC component.
     *
     * @param HVACInfo The value which will be set
     */
    inline void setHVACInfo (const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& HVACInfo_);

    // API of field "AudioInfo"

    static const int kAudioInfo = 7;

    /**
     * Clears the field "AudioInfo".
     *
     * The field will be set to its default value. The hasAudioInfo()
     * method will return false.
     */
    inline void clearAudioInfo();

    /**
     * Checks whether the field "AudioInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAudioInfo()). Otherwise it will return false.
     */
    inline bool hasAudioInfo () const;

    /**
     * Returns the value of the member "AudioInfo".
     *
     * This structure gives info on current radio or media source, station name, frequency,track name , track number, playtime etc.
     *
     * @return The value of the field "AudioInfo"
     */
    inline const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& getAudioInfo () const;

    /**
     * Retrieves the value of the field "AudioInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AudioInfo".
     */
    inline ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& getAudioInfoMutable ();

    /**
     * Sets the value of the member "AudioInfo".
     *
     * This structure gives info on current radio or media source, station name, frequency,track name , track number, playtime etc.
     *
     * @param AudioInfo The value which will be set
     */
    inline void setAudioInfo (const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& AudioInfo_);

    // API of field "PhoneBookDownloadState"

    static const int kPhoneBookDownloadState = 8;

    /**
     * Clears the field "PhoneBookDownloadState".
     *
     * The field will be set to its default value. The hasPhoneBookDownloadState()
     * method will return false.
     */
    inline void clearPhoneBookDownloadState();

    /**
     * Checks whether the field "PhoneBookDownloadState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneBookDownloadState()). Otherwise it will return false.
     */
    inline bool hasPhoneBookDownloadState () const;

    /**
     * Returns the value of the member "PhoneBookDownloadState".
     *
     * This structure gives info about the state of phonebook download
     *
     * @return The value of the field "PhoneBookDownloadState"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState getPhoneBookDownloadState () const;

    /**
     * Sets the value of the member "PhoneBookDownloadState".
     *
     * This structure gives info about the state of phonebook download
     *
     * @param PhoneBookDownloadState The value which will be set
     */
    inline void setPhoneBookDownloadState (::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState PhoneBookDownloadState_);

    static const Property_HMIStatusBarInfoStatus &getDefaultInstance();

private:

    inline void set_has_ClockTimeInfo ();

    inline void clear_has_ClockTimeInfo ();

    inline void set_has_PhoneInfo ();

    inline void clear_has_PhoneInfo ();

    inline void set_has_TAInfo ();

    inline void clear_has_TAInfo ();

    inline void set_has_SMSInfo ();

    inline void clear_has_SMSInfo ();

    inline void set_has_TCUStatus ();

    inline void clear_has_TCUStatus ();

    inline void set_has_DownloadStatus ();

    inline void clear_has_DownloadStatus ();

    inline void set_has_HVACInfo ();

    inline void clear_has_HVACInfo ();

    inline void set_has_AudioInfo ();

    inline void clear_has_AudioInfo ();

    inline void set_has_PhoneBookDownloadState ();

    inline void clear_has_PhoneBookDownloadState ();

    uint32 _has_bits_[ (9 + 31) / 32];

    ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion _ClockTimeInfo;

    ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion _PhoneInfo;

    uint8 _TAInfo;

    ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion _SMSInfo;

    bool _TCUStatus;

    ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion _DownloadStatus;

    ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion _HVACInfo;

    ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion _AudioInfo;

    ::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState _PhoneBookDownloadState;

};

/**
 * The start message of the method "SetInterrupt_to_Meter"
 * This method is used to collect the Info rgarding the User Action and whether it is through SWC Key action.
 * The HALL application which gives us the info regarding the User Action should also tell us their Source.
 * And also the Type of the User Action corresponding to their Source.
 */
class SetInterrupt_to_MeterStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetInterrupt_to_MeterStart ();

    /**
     * Copy constructor
     */
    inline  SetInterrupt_to_MeterStart (const SetInterrupt_to_MeterStart &rhs);

    /**
     * All fields constructor
     */
    inline  SetInterrupt_to_MeterStart (bool bCausedBy_SWC_UserAction_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8Interrupt_Source_, ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type e8Interrupt_Type_);

    /**
     * Destructor
     */
    inline virtual  ~SetInterrupt_to_MeterStart();

    /**
     * Assignment operator
     */
    inline SetInterrupt_to_MeterStart& operator = (const SetInterrupt_to_MeterStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetInterrupt_to_MeterStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetInterrupt_to_MeterStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetInterrupt_to_MeterStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetInterrupt_to_MeterStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bCausedBy_SWC_UserAction"

    static const int kBCausedBy_SWC_UserAction = 0;

    /**
     * Clears the field "bCausedBy_SWC_UserAction".
     *
     * The field will be set to its default value. The hasBCausedBy_SWC_UserAction()
     * method will return false.
     */
    inline void clearBCausedBy_SWC_UserAction();

    /**
     * Checks whether the field "bCausedBy_SWC_UserAction" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBCausedBy_SWC_UserAction()). Otherwise it will return false.
     */
    inline bool hasBCausedBy_SWC_UserAction () const;

    /**
     * Returns the value of the member "bCausedBy_SWC_UserAction".
     *
     * TRUE  : If the Interrupt is a result of a user action through SWC.
     * FALSE : If the Interrupt is a result of a User action by any other means
     *
     * @return The value of the field "bCausedBy_SWC_UserAction"
     */
    inline bool getBCausedBy_SWC_UserAction () const;

    /**
     * Sets the value of the member "bCausedBy_SWC_UserAction".
     *
     * TRUE  : If the Interrupt is a result of a user action through SWC.
     * FALSE : If the Interrupt is a result of a User action by any other means
     *
     * @param bCausedBy_SWC_UserAction The value which will be set
     */
    inline void setBCausedBy_SWC_UserAction (bool bCausedBy_SWC_UserAction_);

    // API of field "e8Interrupt_Source"

    static const int kE8Interrupt_Source = 1;

    /**
     * Clears the field "e8Interrupt_Source".
     *
     * The field will be set to its default value. The hasE8Interrupt_Source()
     * method will return false.
     */
    inline void clearE8Interrupt_Source();

    /**
     * Checks whether the field "e8Interrupt_Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Interrupt_Source()). Otherwise it will return false.
     */
    inline bool hasE8Interrupt_Source () const;

    /**
     * Returns the value of the member "e8Interrupt_Source".
     *
     * Audio source which is the origin of the Interrupt.
     *
     * @return The value of the field "e8Interrupt_Source"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source getE8Interrupt_Source () const;

    /**
     * Sets the value of the member "e8Interrupt_Source".
     *
     * Audio source which is the origin of the Interrupt.
     *
     * @param e8Interrupt_Source The value which will be set
     */
    inline void setE8Interrupt_Source (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8Interrupt_Source_);

    // API of field "e8Interrupt_Type"

    static const int kE8Interrupt_Type = 2;

    /**
     * Clears the field "e8Interrupt_Type".
     *
     * The field will be set to its default value. The hasE8Interrupt_Type()
     * method will return false.
     */
    inline void clearE8Interrupt_Type();

    /**
     * Checks whether the field "e8Interrupt_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Interrupt_Type()). Otherwise it will return false.
     */
    inline bool hasE8Interrupt_Type () const;

    /**
     * Returns the value of the member "e8Interrupt_Type".
     *
     * Type of the Interrupt which is currently active.
     *
     * @return The value of the field "e8Interrupt_Type"
     */
    inline ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type getE8Interrupt_Type () const;

    /**
     * Sets the value of the member "e8Interrupt_Type".
     *
     * Type of the Interrupt which is currently active.
     *
     * @param e8Interrupt_Type The value which will be set
     */
    inline void setE8Interrupt_Type (::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type e8Interrupt_Type_);

    static const SetInterrupt_to_MeterStart &getDefaultInstance();

private:

    inline void set_has_bCausedBy_SWC_UserAction ();

    inline void clear_has_bCausedBy_SWC_UserAction ();

    inline void set_has_e8Interrupt_Source ();

    inline void clear_has_e8Interrupt_Source ();

    inline void set_has_e8Interrupt_Type ();

    inline void clear_has_e8Interrupt_Type ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _bCausedBy_SWC_UserAction;

    ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source _e8Interrupt_Source;

    ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type _e8Interrupt_Type;

};

/**
 * The status message of the property "SMSSettings"
 * This property gives information about the content of the status header to be displayed on the Head Unit.
 */
class SMSSettingsStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SMSSettingsStatus ();

    /**
     * Copy constructor
     */
    inline  SMSSettingsStatus (const SMSSettingsStatus &rhs);

    /**
     * All fields constructor
     */
    inline  SMSSettingsStatus (bool ReplayFeatureAvailability_);

    /**
     * Destructor
     */
    inline virtual  ~SMSSettingsStatus();

    /**
     * Assignment operator
     */
    inline SMSSettingsStatus& operator = (const SMSSettingsStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SMSSettingsStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SMSSettingsStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SMSSettingsStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SMSSettingsStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ReplayFeatureAvailability"

    static const int kReplayFeatureAvailability = 0;

    /**
     * Clears the field "ReplayFeatureAvailability".
     *
     * The field will be set to its default value. The hasReplayFeatureAvailability()
     * method will return false.
     */
    inline void clearReplayFeatureAvailability();

    /**
     * Checks whether the field "ReplayFeatureAvailability" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setReplayFeatureAvailability()). Otherwise it will return false.
     */
    inline bool hasReplayFeatureAvailability () const;

    /**
     * Returns the value of the member "ReplayFeatureAvailability".
     *
     * This Parameter will inofrms the clients that connected phone supports SMS Replay Feature.
     *
     * @return The value of the field "ReplayFeatureAvailability"
     */
    inline bool getReplayFeatureAvailability () const;

    /**
     * Sets the value of the member "ReplayFeatureAvailability".
     *
     * This Parameter will inofrms the clients that connected phone supports SMS Replay Feature.
     *
     * @param ReplayFeatureAvailability The value which will be set
     */
    inline void setReplayFeatureAvailability (bool ReplayFeatureAvailability_);

    static const SMSSettingsStatus &getDefaultInstance();

private:

    inline void set_has_ReplayFeatureAvailability ();

    inline void clear_has_ReplayFeatureAvailability ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _ReplayFeatureAvailability;

};

inline  Property_ConnectionStatus::Property_ConnectionStatus ()  :
    _arConnectionStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_ConnectionStatus::Property_ConnectionStatus (const Property_ConnectionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arConnectionStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_ConnectionStatus::Property_ConnectionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& arConnectionStatusList_)  :
    _arConnectionStatusList (arConnectionStatusList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_ConnectionStatus::~Property_ConnectionStatus() {
}

inline Property_ConnectionStatus& Property_ConnectionStatus::operator = (const Property_ConnectionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArConnectionStatusList()) {
            setArConnectionStatusList(rhs.getArConnectionStatusList());
        } else {
            clearArConnectionStatusList();
        }
    }
    return *this;
}

inline bool Property_ConnectionStatus::operator == (const Property_ConnectionStatus& rhs) const {
    return (((!hasArConnectionStatusList() && !rhs.hasArConnectionStatusList()) || getArConnectionStatusList() == rhs.getArConnectionStatusList()));
}

inline bool Property_ConnectionStatus::operator != (const Property_ConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_ConnectionStatus::operator < (const Property_ConnectionStatus& rhs) const {
    if (hasArConnectionStatusList() || rhs.hasArConnectionStatusList()) {
        if (getArConnectionStatusList() < rhs.getArConnectionStatusList()) return true;
        if (getArConnectionStatusList() > rhs.getArConnectionStatusList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_ConnectionStatus::clone() {
    return new Property_ConnectionStatus(*this);
}

inline bool Property_ConnectionStatus::operator > (const Property_ConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_ConnectionStatus::clear() {
    clearArConnectionStatusList();
}

inline void Property_ConnectionStatus::clearArConnectionStatusList() {
    if (hasArConnectionStatusList()) {
         clear_has_arConnectionStatusList();
        _arConnectionStatusList.clear();
     }
}

inline bool Property_ConnectionStatus::hasArConnectionStatusList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& Property_ConnectionStatus::getArConnectionStatusList () const {
    return _arConnectionStatusList;
}

inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& Property_ConnectionStatus::getArConnectionStatusListMutable () {
    set_has_arConnectionStatusList();
    return _arConnectionStatusList;
}

inline void Property_ConnectionStatus::setArConnectionStatusList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConnectionStatus >& arConnectionStatusList_) {
    set_has_arConnectionStatusList();
    this->_arConnectionStatusList = arConnectionStatusList_;
}

inline void Property_ConnectionStatus::set_has_arConnectionStatusList () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_ConnectionStatus::clear_has_arConnectionStatusList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_ConfigurationStatus::Property_ConfigurationStatus ()  :
    _arConfigurationList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_ConfigurationStatus::Property_ConfigurationStatus (const Property_ConfigurationStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arConfigurationList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_ConfigurationStatus::Property_ConfigurationStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& arConfigurationList_)  :
    _arConfigurationList (arConfigurationList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_ConfigurationStatus::~Property_ConfigurationStatus() {
}

inline Property_ConfigurationStatus& Property_ConfigurationStatus::operator = (const Property_ConfigurationStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArConfigurationList()) {
            setArConfigurationList(rhs.getArConfigurationList());
        } else {
            clearArConfigurationList();
        }
    }
    return *this;
}

inline bool Property_ConfigurationStatus::operator == (const Property_ConfigurationStatus& rhs) const {
    return (((!hasArConfigurationList() && !rhs.hasArConfigurationList()) || getArConfigurationList() == rhs.getArConfigurationList()));
}

inline bool Property_ConfigurationStatus::operator != (const Property_ConfigurationStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_ConfigurationStatus::operator < (const Property_ConfigurationStatus& rhs) const {
    if (hasArConfigurationList() || rhs.hasArConfigurationList()) {
        if (getArConfigurationList() < rhs.getArConfigurationList()) return true;
        if (getArConfigurationList() > rhs.getArConfigurationList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_ConfigurationStatus::clone() {
    return new Property_ConfigurationStatus(*this);
}

inline bool Property_ConfigurationStatus::operator > (const Property_ConfigurationStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_ConfigurationStatus::clear() {
    clearArConfigurationList();
}

inline void Property_ConfigurationStatus::clearArConfigurationList() {
    if (hasArConfigurationList()) {
         clear_has_arConfigurationList();
        _arConfigurationList.clear();
     }
}

inline bool Property_ConfigurationStatus::hasArConfigurationList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& Property_ConfigurationStatus::getArConfigurationList () const {
    return _arConfigurationList;
}

inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& Property_ConfigurationStatus::getArConfigurationListMutable () {
    set_has_arConfigurationList();
    return _arConfigurationList;
}

inline void Property_ConfigurationStatus::setArConfigurationList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitConfiguration >& arConfigurationList_) {
    set_has_arConfigurationList();
    this->_arConfigurationList = arConfigurationList_;
}

inline void Property_ConfigurationStatus::set_has_arConfigurationList () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_ConfigurationStatus::clear_has_arConfigurationList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_HardwareVersionStatus::Property_HardwareVersionStatus ()  :
    _arHardwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_HardwareVersionStatus::Property_HardwareVersionStatus (const Property_HardwareVersionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arHardwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_HardwareVersionStatus::Property_HardwareVersionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arHardwareVersionList_)  :
    _arHardwareVersionList (arHardwareVersionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_HardwareVersionStatus::~Property_HardwareVersionStatus() {
}

inline Property_HardwareVersionStatus& Property_HardwareVersionStatus::operator = (const Property_HardwareVersionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArHardwareVersionList()) {
            setArHardwareVersionList(rhs.getArHardwareVersionList());
        } else {
            clearArHardwareVersionList();
        }
    }
    return *this;
}

inline bool Property_HardwareVersionStatus::operator == (const Property_HardwareVersionStatus& rhs) const {
    return (((!hasArHardwareVersionList() && !rhs.hasArHardwareVersionList()) || getArHardwareVersionList() == rhs.getArHardwareVersionList()));
}

inline bool Property_HardwareVersionStatus::operator != (const Property_HardwareVersionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_HardwareVersionStatus::operator < (const Property_HardwareVersionStatus& rhs) const {
    if (hasArHardwareVersionList() || rhs.hasArHardwareVersionList()) {
        if (getArHardwareVersionList() < rhs.getArHardwareVersionList()) return true;
        if (getArHardwareVersionList() > rhs.getArHardwareVersionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_HardwareVersionStatus::clone() {
    return new Property_HardwareVersionStatus(*this);
}

inline bool Property_HardwareVersionStatus::operator > (const Property_HardwareVersionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_HardwareVersionStatus::clear() {
    clearArHardwareVersionList();
}

inline void Property_HardwareVersionStatus::clearArHardwareVersionList() {
    if (hasArHardwareVersionList()) {
         clear_has_arHardwareVersionList();
        _arHardwareVersionList.clear();
     }
}

inline bool Property_HardwareVersionStatus::hasArHardwareVersionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& Property_HardwareVersionStatus::getArHardwareVersionList () const {
    return _arHardwareVersionList;
}

inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& Property_HardwareVersionStatus::getArHardwareVersionListMutable () {
    set_has_arHardwareVersionList();
    return _arHardwareVersionList;
}

inline void Property_HardwareVersionStatus::setArHardwareVersionList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arHardwareVersionList_) {
    set_has_arHardwareVersionList();
    this->_arHardwareVersionList = arHardwareVersionList_;
}

inline void Property_HardwareVersionStatus::set_has_arHardwareVersionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_HardwareVersionStatus::clear_has_arHardwareVersionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_SoftwareVersionStatus::Property_SoftwareVersionStatus ()  :
    _arSoftwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_SoftwareVersionStatus::Property_SoftwareVersionStatus (const Property_SoftwareVersionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arSoftwareVersionList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_SoftwareVersionStatus::Property_SoftwareVersionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arSoftwareVersionList_)  :
    _arSoftwareVersionList (arSoftwareVersionList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_SoftwareVersionStatus::~Property_SoftwareVersionStatus() {
}

inline Property_SoftwareVersionStatus& Property_SoftwareVersionStatus::operator = (const Property_SoftwareVersionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArSoftwareVersionList()) {
            setArSoftwareVersionList(rhs.getArSoftwareVersionList());
        } else {
            clearArSoftwareVersionList();
        }
    }
    return *this;
}

inline bool Property_SoftwareVersionStatus::operator == (const Property_SoftwareVersionStatus& rhs) const {
    return (((!hasArSoftwareVersionList() && !rhs.hasArSoftwareVersionList()) || getArSoftwareVersionList() == rhs.getArSoftwareVersionList()));
}

inline bool Property_SoftwareVersionStatus::operator != (const Property_SoftwareVersionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_SoftwareVersionStatus::operator < (const Property_SoftwareVersionStatus& rhs) const {
    if (hasArSoftwareVersionList() || rhs.hasArSoftwareVersionList()) {
        if (getArSoftwareVersionList() < rhs.getArSoftwareVersionList()) return true;
        if (getArSoftwareVersionList() > rhs.getArSoftwareVersionList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_SoftwareVersionStatus::clone() {
    return new Property_SoftwareVersionStatus(*this);
}

inline bool Property_SoftwareVersionStatus::operator > (const Property_SoftwareVersionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_SoftwareVersionStatus::clear() {
    clearArSoftwareVersionList();
}

inline void Property_SoftwareVersionStatus::clearArSoftwareVersionList() {
    if (hasArSoftwareVersionList()) {
         clear_has_arSoftwareVersionList();
        _arSoftwareVersionList.clear();
     }
}

inline bool Property_SoftwareVersionStatus::hasArSoftwareVersionList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& Property_SoftwareVersionStatus::getArSoftwareVersionList () const {
    return _arSoftwareVersionList;
}

inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& Property_SoftwareVersionStatus::getArSoftwareVersionListMutable () {
    set_has_arSoftwareVersionList();
    return _arSoftwareVersionList;
}

inline void Property_SoftwareVersionStatus::setArSoftwareVersionList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitVersion >& arSoftwareVersionList_) {
    set_has_arSoftwareVersionList();
    this->_arSoftwareVersionList = arSoftwareVersionList_;
}

inline void Property_SoftwareVersionStatus::set_has_arSoftwareVersionList () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_SoftwareVersionStatus::clear_has_arSoftwareVersionList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_DataTransmissionStatus::Property_DataTransmissionStatus ()  :
    _arDataTransmissionStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_DataTransmissionStatus::Property_DataTransmissionStatus (const Property_DataTransmissionStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _arDataTransmissionStatusList ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_DataTransmissionStatus::Property_DataTransmissionStatus (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& arDataTransmissionStatusList_)  :
    _arDataTransmissionStatusList (arDataTransmissionStatusList_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_DataTransmissionStatus::~Property_DataTransmissionStatus() {
}

inline Property_DataTransmissionStatus& Property_DataTransmissionStatus::operator = (const Property_DataTransmissionStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArDataTransmissionStatusList()) {
            setArDataTransmissionStatusList(rhs.getArDataTransmissionStatusList());
        } else {
            clearArDataTransmissionStatusList();
        }
    }
    return *this;
}

inline bool Property_DataTransmissionStatus::operator == (const Property_DataTransmissionStatus& rhs) const {
    return (((!hasArDataTransmissionStatusList() && !rhs.hasArDataTransmissionStatusList()) || getArDataTransmissionStatusList() == rhs.getArDataTransmissionStatusList()));
}

inline bool Property_DataTransmissionStatus::operator != (const Property_DataTransmissionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_DataTransmissionStatus::operator < (const Property_DataTransmissionStatus& rhs) const {
    if (hasArDataTransmissionStatusList() || rhs.hasArDataTransmissionStatusList()) {
        if (getArDataTransmissionStatusList() < rhs.getArDataTransmissionStatusList()) return true;
        if (getArDataTransmissionStatusList() > rhs.getArDataTransmissionStatusList()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_DataTransmissionStatus::clone() {
    return new Property_DataTransmissionStatus(*this);
}

inline bool Property_DataTransmissionStatus::operator > (const Property_DataTransmissionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_DataTransmissionStatus::clear() {
    clearArDataTransmissionStatusList();
}

inline void Property_DataTransmissionStatus::clearArDataTransmissionStatusList() {
    if (hasArDataTransmissionStatusList()) {
         clear_has_arDataTransmissionStatusList();
        _arDataTransmissionStatusList.clear();
     }
}

inline bool Property_DataTransmissionStatus::hasArDataTransmissionStatusList () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& Property_DataTransmissionStatus::getArDataTransmissionStatusList () const {
    return _arDataTransmissionStatusList;
}

inline ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& Property_DataTransmissionStatus::getArDataTransmissionStatusListMutable () {
    set_has_arDataTransmissionStatusList();
    return _arDataTransmissionStatusList;
}

inline void Property_DataTransmissionStatus::setArDataTransmissionStatusList (const ::std::vector< ::datacollector_main_fi_types::T_datacollector_UnitDataTransmissionStatus >& arDataTransmissionStatusList_) {
    set_has_arDataTransmissionStatusList();
    this->_arDataTransmissionStatusList = arDataTransmissionStatusList_;
}

inline void Property_DataTransmissionStatus::set_has_arDataTransmissionStatusList () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_DataTransmissionStatus::clear_has_arDataTransmissionStatusList () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_TriggerVersionInfotoMeterStart::Method_TriggerVersionInfotoMeterStart ()  :
    _e8Version (::datacollector_main_fi_types::T_e8_datacollector_VersionInfo__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_TriggerVersionInfotoMeterStart::Method_TriggerVersionInfotoMeterStart (const Method_TriggerVersionInfotoMeterStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Version (::datacollector_main_fi_types::T_e8_datacollector_VersionInfo__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_TriggerVersionInfotoMeterStart::Method_TriggerVersionInfotoMeterStart (::datacollector_main_fi_types::T_e8_datacollector_VersionInfo e8Version_)  :
    _e8Version (e8Version_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_VersionInfo_IsValid(e8Version_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Version_, "T_e8_datacollector_VersionInfo", "e8Version", "Method_TriggerVersionInfotoMeterStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_TriggerVersionInfotoMeterStart::~Method_TriggerVersionInfotoMeterStart() {
}

inline Method_TriggerVersionInfotoMeterStart& Method_TriggerVersionInfotoMeterStart::operator = (const Method_TriggerVersionInfotoMeterStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Version()) {
            setE8Version(rhs.getE8Version());
        } else {
            clearE8Version();
        }
    }
    return *this;
}

inline bool Method_TriggerVersionInfotoMeterStart::operator == (const Method_TriggerVersionInfotoMeterStart& rhs) const {
    return (((!hasE8Version() && !rhs.hasE8Version()) || getE8Version() == rhs.getE8Version()));
}

inline bool Method_TriggerVersionInfotoMeterStart::operator != (const Method_TriggerVersionInfotoMeterStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_TriggerVersionInfotoMeterStart::operator < (const Method_TriggerVersionInfotoMeterStart& rhs) const {
    if (hasE8Version() || rhs.hasE8Version()) {
        if ((uint32)getE8Version() < (uint32)rhs.getE8Version()) return true;
        if ((uint32)getE8Version() > (uint32)rhs.getE8Version()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_TriggerVersionInfotoMeterStart::clone() {
    return new Method_TriggerVersionInfotoMeterStart(*this);
}

inline bool Method_TriggerVersionInfotoMeterStart::operator > (const Method_TriggerVersionInfotoMeterStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_TriggerVersionInfotoMeterStart::clear() {
    clearE8Version();
}

inline void Method_TriggerVersionInfotoMeterStart::clearE8Version() {
    if (hasE8Version()) {
         clear_has_e8Version();
        _e8Version = ::datacollector_main_fi_types::T_e8_datacollector_VersionInfo__Unknown;
     }
}

inline bool Method_TriggerVersionInfotoMeterStart::hasE8Version () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_VersionInfo Method_TriggerVersionInfotoMeterStart::getE8Version () const {
    return _e8Version;
}

inline void Method_TriggerVersionInfotoMeterStart::setE8Version (::datacollector_main_fi_types::T_e8_datacollector_VersionInfo e8Version_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_VersionInfo_IsValid(e8Version_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Version_, "T_e8_datacollector_VersionInfo", "e8Version", "Method_TriggerVersionInfotoMeterStart");
    }
    #endif
    set_has_e8Version();
    this->_e8Version = e8Version_;
}

inline void Method_TriggerVersionInfotoMeterStart::set_has_e8Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_TriggerVersionInfotoMeterStart::clear_has_e8Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_CurrentMeterSettingsStatus::Property_CurrentMeterSettingsStatus ()  :
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown),
    _e8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown),
    _e8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown),
    _e8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_CurrentMeterSettingsStatus::Property_CurrentMeterSettingsStatus (const Property_CurrentMeterSettingsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown),
    _e8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown),
    _e8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown),
    _e8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_CurrentMeterSettingsStatus::Property_CurrentMeterSettingsStatus (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_, ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_, ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_, ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_)  :
    _e8Language (e8Language_),
    _e8FuelConsumptionUnit (e8FuelConsumptionUnit_),
    _e8TemperatureUnit (e8TemperatureUnit_),
    _e8PressureUnit (e8PressureUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit_IsValid(e8FuelConsumptionUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FuelConsumptionUnit_, "T_e8_datacollector_FuelConsumptionUnit", "e8FuelConsumptionUnit", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit_IsValid(e8TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TemperatureUnit_, "T_e8_datacollector_TemperatureUnit", "e8TemperatureUnit", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PressureUnit_IsValid(e8PressureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PressureUnit_, "T_e8_datacollector_PressureUnit", "e8PressureUnit", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_CurrentMeterSettingsStatus::~Property_CurrentMeterSettingsStatus() {
}

inline Property_CurrentMeterSettingsStatus& Property_CurrentMeterSettingsStatus::operator = (const Property_CurrentMeterSettingsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Language()) {
            setE8Language(rhs.getE8Language());
        } else {
            clearE8Language();
        }
        if (rhs.hasE8FuelConsumptionUnit()) {
            setE8FuelConsumptionUnit(rhs.getE8FuelConsumptionUnit());
        } else {
            clearE8FuelConsumptionUnit();
        }
        if (rhs.hasE8TemperatureUnit()) {
            setE8TemperatureUnit(rhs.getE8TemperatureUnit());
        } else {
            clearE8TemperatureUnit();
        }
        if (rhs.hasE8PressureUnit()) {
            setE8PressureUnit(rhs.getE8PressureUnit());
        } else {
            clearE8PressureUnit();
        }
    }
    return *this;
}

inline bool Property_CurrentMeterSettingsStatus::operator == (const Property_CurrentMeterSettingsStatus& rhs) const {
    return (((!hasE8Language() && !rhs.hasE8Language()) || getE8Language() == rhs.getE8Language()) &&
        ((!hasE8FuelConsumptionUnit() && !rhs.hasE8FuelConsumptionUnit()) || getE8FuelConsumptionUnit() == rhs.getE8FuelConsumptionUnit()) &&
        ((!hasE8TemperatureUnit() && !rhs.hasE8TemperatureUnit()) || getE8TemperatureUnit() == rhs.getE8TemperatureUnit()) &&
        ((!hasE8PressureUnit() && !rhs.hasE8PressureUnit()) || getE8PressureUnit() == rhs.getE8PressureUnit()));
}

inline bool Property_CurrentMeterSettingsStatus::operator != (const Property_CurrentMeterSettingsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_CurrentMeterSettingsStatus::operator < (const Property_CurrentMeterSettingsStatus& rhs) const {
    if (hasE8Language() || rhs.hasE8Language()) {
        if ((uint32)getE8Language() < (uint32)rhs.getE8Language()) return true;
        if ((uint32)getE8Language() > (uint32)rhs.getE8Language()) return false;
    }
    if (hasE8FuelConsumptionUnit() || rhs.hasE8FuelConsumptionUnit()) {
        if ((uint32)getE8FuelConsumptionUnit() < (uint32)rhs.getE8FuelConsumptionUnit()) return true;
        if ((uint32)getE8FuelConsumptionUnit() > (uint32)rhs.getE8FuelConsumptionUnit()) return false;
    }
    if (hasE8TemperatureUnit() || rhs.hasE8TemperatureUnit()) {
        if ((uint32)getE8TemperatureUnit() < (uint32)rhs.getE8TemperatureUnit()) return true;
        if ((uint32)getE8TemperatureUnit() > (uint32)rhs.getE8TemperatureUnit()) return false;
    }
    if (hasE8PressureUnit() || rhs.hasE8PressureUnit()) {
        if ((uint32)getE8PressureUnit() < (uint32)rhs.getE8PressureUnit()) return true;
        if ((uint32)getE8PressureUnit() > (uint32)rhs.getE8PressureUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_CurrentMeterSettingsStatus::clone() {
    return new Property_CurrentMeterSettingsStatus(*this);
}

inline bool Property_CurrentMeterSettingsStatus::operator > (const Property_CurrentMeterSettingsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_CurrentMeterSettingsStatus::clear() {
    clearE8Language();
    clearE8FuelConsumptionUnit();
    clearE8TemperatureUnit();
    clearE8PressureUnit();
}

inline void Property_CurrentMeterSettingsStatus::clearE8Language() {
    if (hasE8Language()) {
         clear_has_e8Language();
        _e8Language = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Property_CurrentMeterSettingsStatus::hasE8Language () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Property_CurrentMeterSettingsStatus::getE8Language () const {
    return _e8Language;
}

inline void Property_CurrentMeterSettingsStatus::setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    set_has_e8Language();
    this->_e8Language = e8Language_;
}

inline void Property_CurrentMeterSettingsStatus::clearE8FuelConsumptionUnit() {
    if (hasE8FuelConsumptionUnit()) {
         clear_has_e8FuelConsumptionUnit();
        _e8FuelConsumptionUnit = ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown;
     }
}

inline bool Property_CurrentMeterSettingsStatus::hasE8FuelConsumptionUnit () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit Property_CurrentMeterSettingsStatus::getE8FuelConsumptionUnit () const {
    return _e8FuelConsumptionUnit;
}

inline void Property_CurrentMeterSettingsStatus::setE8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit_IsValid(e8FuelConsumptionUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FuelConsumptionUnit_, "T_e8_datacollector_FuelConsumptionUnit", "e8FuelConsumptionUnit", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    set_has_e8FuelConsumptionUnit();
    this->_e8FuelConsumptionUnit = e8FuelConsumptionUnit_;
}

inline void Property_CurrentMeterSettingsStatus::clearE8TemperatureUnit() {
    if (hasE8TemperatureUnit()) {
         clear_has_e8TemperatureUnit();
        _e8TemperatureUnit = ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown;
     }
}

inline bool Property_CurrentMeterSettingsStatus::hasE8TemperatureUnit () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit Property_CurrentMeterSettingsStatus::getE8TemperatureUnit () const {
    return _e8TemperatureUnit;
}

inline void Property_CurrentMeterSettingsStatus::setE8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit_IsValid(e8TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TemperatureUnit_, "T_e8_datacollector_TemperatureUnit", "e8TemperatureUnit", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    set_has_e8TemperatureUnit();
    this->_e8TemperatureUnit = e8TemperatureUnit_;
}

inline void Property_CurrentMeterSettingsStatus::clearE8PressureUnit() {
    if (hasE8PressureUnit()) {
         clear_has_e8PressureUnit();
        _e8PressureUnit = ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown;
     }
}

inline bool Property_CurrentMeterSettingsStatus::hasE8PressureUnit () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit Property_CurrentMeterSettingsStatus::getE8PressureUnit () const {
    return _e8PressureUnit;
}

inline void Property_CurrentMeterSettingsStatus::setE8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PressureUnit_IsValid(e8PressureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PressureUnit_, "T_e8_datacollector_PressureUnit", "e8PressureUnit", "Property_CurrentMeterSettingsStatus");
    }
    #endif
    set_has_e8PressureUnit();
    this->_e8PressureUnit = e8PressureUnit_;
}

inline void Property_CurrentMeterSettingsStatus::set_has_e8Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_CurrentMeterSettingsStatus::clear_has_e8Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Property_CurrentMeterSettingsStatus::set_has_e8FuelConsumptionUnit () {
    _has_bits_[0] |= 1u << 1;
}

inline void Property_CurrentMeterSettingsStatus::clear_has_e8FuelConsumptionUnit () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Property_CurrentMeterSettingsStatus::set_has_e8TemperatureUnit () {
    _has_bits_[0] |= 1u << 2;
}

inline void Property_CurrentMeterSettingsStatus::clear_has_e8TemperatureUnit () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Property_CurrentMeterSettingsStatus::set_has_e8PressureUnit () {
    _has_bits_[0] |= 1u << 3;
}

inline void Property_CurrentMeterSettingsStatus::clear_has_e8PressureUnit () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  Property_AvailableFuelConsumptionUnitsStatus::Property_AvailableFuelConsumptionUnitsStatus ()  :
    _b_km_per_l (false),
    _b_l_per_100km (false),
    _b_US_MPG (false),
    _b_UK_MPG (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_AvailableFuelConsumptionUnitsStatus::Property_AvailableFuelConsumptionUnitsStatus (const Property_AvailableFuelConsumptionUnitsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _b_km_per_l (false),
    _b_l_per_100km (false),
    _b_US_MPG (false),
    _b_UK_MPG (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_AvailableFuelConsumptionUnitsStatus::Property_AvailableFuelConsumptionUnitsStatus (bool b_km_per_l_, bool b_l_per_100km_, bool b_US_MPG_, bool b_UK_MPG_)  :
    _b_km_per_l (b_km_per_l_),
    _b_l_per_100km (b_l_per_100km_),
    _b_US_MPG (b_US_MPG_),
    _b_UK_MPG (b_UK_MPG_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_AvailableFuelConsumptionUnitsStatus::~Property_AvailableFuelConsumptionUnitsStatus() {
}

inline Property_AvailableFuelConsumptionUnitsStatus& Property_AvailableFuelConsumptionUnitsStatus::operator = (const Property_AvailableFuelConsumptionUnitsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasB_km_per_l()) {
            setB_km_per_l(rhs.getB_km_per_l());
        } else {
            clearB_km_per_l();
        }
        if (rhs.hasB_l_per_100km()) {
            setB_l_per_100km(rhs.getB_l_per_100km());
        } else {
            clearB_l_per_100km();
        }
        if (rhs.hasB_US_MPG()) {
            setB_US_MPG(rhs.getB_US_MPG());
        } else {
            clearB_US_MPG();
        }
        if (rhs.hasB_UK_MPG()) {
            setB_UK_MPG(rhs.getB_UK_MPG());
        } else {
            clearB_UK_MPG();
        }
    }
    return *this;
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::operator == (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const {
    return (((!hasB_km_per_l() && !rhs.hasB_km_per_l()) || getB_km_per_l() == rhs.getB_km_per_l()) &&
        ((!hasB_l_per_100km() && !rhs.hasB_l_per_100km()) || getB_l_per_100km() == rhs.getB_l_per_100km()) &&
        ((!hasB_US_MPG() && !rhs.hasB_US_MPG()) || getB_US_MPG() == rhs.getB_US_MPG()) &&
        ((!hasB_UK_MPG() && !rhs.hasB_UK_MPG()) || getB_UK_MPG() == rhs.getB_UK_MPG()));
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::operator != (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::operator < (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const {
    if (hasB_km_per_l() || rhs.hasB_km_per_l()) {
        if (getB_km_per_l() < rhs.getB_km_per_l()) return true;
        if (getB_km_per_l() > rhs.getB_km_per_l()) return false;
    }
    if (hasB_l_per_100km() || rhs.hasB_l_per_100km()) {
        if (getB_l_per_100km() < rhs.getB_l_per_100km()) return true;
        if (getB_l_per_100km() > rhs.getB_l_per_100km()) return false;
    }
    if (hasB_US_MPG() || rhs.hasB_US_MPG()) {
        if (getB_US_MPG() < rhs.getB_US_MPG()) return true;
        if (getB_US_MPG() > rhs.getB_US_MPG()) return false;
    }
    if (hasB_UK_MPG() || rhs.hasB_UK_MPG()) {
        if (getB_UK_MPG() < rhs.getB_UK_MPG()) return true;
        if (getB_UK_MPG() > rhs.getB_UK_MPG()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_AvailableFuelConsumptionUnitsStatus::clone() {
    return new Property_AvailableFuelConsumptionUnitsStatus(*this);
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::operator > (const Property_AvailableFuelConsumptionUnitsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clear() {
    clearB_km_per_l();
    clearB_l_per_100km();
    clearB_US_MPG();
    clearB_UK_MPG();
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clearB_km_per_l() {
    if (hasB_km_per_l()) {
         clear_has_b_km_per_l();
        _b_km_per_l = false;
     }
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::hasB_km_per_l () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::getB_km_per_l () const {
    return _b_km_per_l;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::setB_km_per_l (bool b_km_per_l_) {
    set_has_b_km_per_l();
    this->_b_km_per_l = b_km_per_l_;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clearB_l_per_100km() {
    if (hasB_l_per_100km()) {
         clear_has_b_l_per_100km();
        _b_l_per_100km = false;
     }
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::hasB_l_per_100km () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::getB_l_per_100km () const {
    return _b_l_per_100km;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::setB_l_per_100km (bool b_l_per_100km_) {
    set_has_b_l_per_100km();
    this->_b_l_per_100km = b_l_per_100km_;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clearB_US_MPG() {
    if (hasB_US_MPG()) {
         clear_has_b_US_MPG();
        _b_US_MPG = false;
     }
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::hasB_US_MPG () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::getB_US_MPG () const {
    return _b_US_MPG;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::setB_US_MPG (bool b_US_MPG_) {
    set_has_b_US_MPG();
    this->_b_US_MPG = b_US_MPG_;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clearB_UK_MPG() {
    if (hasB_UK_MPG()) {
         clear_has_b_UK_MPG();
        _b_UK_MPG = false;
     }
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::hasB_UK_MPG () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool Property_AvailableFuelConsumptionUnitsStatus::getB_UK_MPG () const {
    return _b_UK_MPG;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::setB_UK_MPG (bool b_UK_MPG_) {
    set_has_b_UK_MPG();
    this->_b_UK_MPG = b_UK_MPG_;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::set_has_b_km_per_l () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clear_has_b_km_per_l () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Property_AvailableFuelConsumptionUnitsStatus::set_has_b_l_per_100km () {
    _has_bits_[0] |= 1u << 1;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clear_has_b_l_per_100km () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Property_AvailableFuelConsumptionUnitsStatus::set_has_b_US_MPG () {
    _has_bits_[0] |= 1u << 2;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clear_has_b_US_MPG () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Property_AvailableFuelConsumptionUnitsStatus::set_has_b_UK_MPG () {
    _has_bits_[0] |= 1u << 3;
}

inline void Property_AvailableFuelConsumptionUnitsStatus::clear_has_b_UK_MPG () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  Property_AvailableTemperatureUnitsStatus::Property_AvailableTemperatureUnitsStatus ()  :
    _b_deg_C (false),
    _b_deg_F (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_AvailableTemperatureUnitsStatus::Property_AvailableTemperatureUnitsStatus (const Property_AvailableTemperatureUnitsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _b_deg_C (false),
    _b_deg_F (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_AvailableTemperatureUnitsStatus::Property_AvailableTemperatureUnitsStatus (bool b_deg_C_, bool b_deg_F_)  :
    _b_deg_C (b_deg_C_),
    _b_deg_F (b_deg_F_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_AvailableTemperatureUnitsStatus::~Property_AvailableTemperatureUnitsStatus() {
}

inline Property_AvailableTemperatureUnitsStatus& Property_AvailableTemperatureUnitsStatus::operator = (const Property_AvailableTemperatureUnitsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasB_deg_C()) {
            setB_deg_C(rhs.getB_deg_C());
        } else {
            clearB_deg_C();
        }
        if (rhs.hasB_deg_F()) {
            setB_deg_F(rhs.getB_deg_F());
        } else {
            clearB_deg_F();
        }
    }
    return *this;
}

inline bool Property_AvailableTemperatureUnitsStatus::operator == (const Property_AvailableTemperatureUnitsStatus& rhs) const {
    return (((!hasB_deg_C() && !rhs.hasB_deg_C()) || getB_deg_C() == rhs.getB_deg_C()) &&
        ((!hasB_deg_F() && !rhs.hasB_deg_F()) || getB_deg_F() == rhs.getB_deg_F()));
}

inline bool Property_AvailableTemperatureUnitsStatus::operator != (const Property_AvailableTemperatureUnitsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_AvailableTemperatureUnitsStatus::operator < (const Property_AvailableTemperatureUnitsStatus& rhs) const {
    if (hasB_deg_C() || rhs.hasB_deg_C()) {
        if (getB_deg_C() < rhs.getB_deg_C()) return true;
        if (getB_deg_C() > rhs.getB_deg_C()) return false;
    }
    if (hasB_deg_F() || rhs.hasB_deg_F()) {
        if (getB_deg_F() < rhs.getB_deg_F()) return true;
        if (getB_deg_F() > rhs.getB_deg_F()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_AvailableTemperatureUnitsStatus::clone() {
    return new Property_AvailableTemperatureUnitsStatus(*this);
}

inline bool Property_AvailableTemperatureUnitsStatus::operator > (const Property_AvailableTemperatureUnitsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_AvailableTemperatureUnitsStatus::clear() {
    clearB_deg_C();
    clearB_deg_F();
}

inline void Property_AvailableTemperatureUnitsStatus::clearB_deg_C() {
    if (hasB_deg_C()) {
         clear_has_b_deg_C();
        _b_deg_C = false;
     }
}

inline bool Property_AvailableTemperatureUnitsStatus::hasB_deg_C () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Property_AvailableTemperatureUnitsStatus::getB_deg_C () const {
    return _b_deg_C;
}

inline void Property_AvailableTemperatureUnitsStatus::setB_deg_C (bool b_deg_C_) {
    set_has_b_deg_C();
    this->_b_deg_C = b_deg_C_;
}

inline void Property_AvailableTemperatureUnitsStatus::clearB_deg_F() {
    if (hasB_deg_F()) {
         clear_has_b_deg_F();
        _b_deg_F = false;
     }
}

inline bool Property_AvailableTemperatureUnitsStatus::hasB_deg_F () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool Property_AvailableTemperatureUnitsStatus::getB_deg_F () const {
    return _b_deg_F;
}

inline void Property_AvailableTemperatureUnitsStatus::setB_deg_F (bool b_deg_F_) {
    set_has_b_deg_F();
    this->_b_deg_F = b_deg_F_;
}

inline void Property_AvailableTemperatureUnitsStatus::set_has_b_deg_C () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_AvailableTemperatureUnitsStatus::clear_has_b_deg_C () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Property_AvailableTemperatureUnitsStatus::set_has_b_deg_F () {
    _has_bits_[0] |= 1u << 1;
}

inline void Property_AvailableTemperatureUnitsStatus::clear_has_b_deg_F () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Property_AvailablePressureUnitsStatus::Property_AvailablePressureUnitsStatus ()  :
    _b_kPa (false),
    _b_PSI (false),
    _b_bar (false),
    _b_kgf_cm2 (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_AvailablePressureUnitsStatus::Property_AvailablePressureUnitsStatus (const Property_AvailablePressureUnitsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _b_kPa (false),
    _b_PSI (false),
    _b_bar (false),
    _b_kgf_cm2 (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_AvailablePressureUnitsStatus::Property_AvailablePressureUnitsStatus (bool b_kPa_, bool b_PSI_, bool b_bar_, bool b_kgf_cm2_)  :
    _b_kPa (b_kPa_),
    _b_PSI (b_PSI_),
    _b_bar (b_bar_),
    _b_kgf_cm2 (b_kgf_cm2_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_AvailablePressureUnitsStatus::~Property_AvailablePressureUnitsStatus() {
}

inline Property_AvailablePressureUnitsStatus& Property_AvailablePressureUnitsStatus::operator = (const Property_AvailablePressureUnitsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasB_kPa()) {
            setB_kPa(rhs.getB_kPa());
        } else {
            clearB_kPa();
        }
        if (rhs.hasB_PSI()) {
            setB_PSI(rhs.getB_PSI());
        } else {
            clearB_PSI();
        }
        if (rhs.hasB_bar()) {
            setB_bar(rhs.getB_bar());
        } else {
            clearB_bar();
        }
        if (rhs.hasB_kgf_cm2()) {
            setB_kgf_cm2(rhs.getB_kgf_cm2());
        } else {
            clearB_kgf_cm2();
        }
    }
    return *this;
}

inline bool Property_AvailablePressureUnitsStatus::operator == (const Property_AvailablePressureUnitsStatus& rhs) const {
    return (((!hasB_kPa() && !rhs.hasB_kPa()) || getB_kPa() == rhs.getB_kPa()) &&
        ((!hasB_PSI() && !rhs.hasB_PSI()) || getB_PSI() == rhs.getB_PSI()) &&
        ((!hasB_bar() && !rhs.hasB_bar()) || getB_bar() == rhs.getB_bar()) &&
        ((!hasB_kgf_cm2() && !rhs.hasB_kgf_cm2()) || getB_kgf_cm2() == rhs.getB_kgf_cm2()));
}

inline bool Property_AvailablePressureUnitsStatus::operator != (const Property_AvailablePressureUnitsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_AvailablePressureUnitsStatus::operator < (const Property_AvailablePressureUnitsStatus& rhs) const {
    if (hasB_kPa() || rhs.hasB_kPa()) {
        if (getB_kPa() < rhs.getB_kPa()) return true;
        if (getB_kPa() > rhs.getB_kPa()) return false;
    }
    if (hasB_PSI() || rhs.hasB_PSI()) {
        if (getB_PSI() < rhs.getB_PSI()) return true;
        if (getB_PSI() > rhs.getB_PSI()) return false;
    }
    if (hasB_bar() || rhs.hasB_bar()) {
        if (getB_bar() < rhs.getB_bar()) return true;
        if (getB_bar() > rhs.getB_bar()) return false;
    }
    if (hasB_kgf_cm2() || rhs.hasB_kgf_cm2()) {
        if (getB_kgf_cm2() < rhs.getB_kgf_cm2()) return true;
        if (getB_kgf_cm2() > rhs.getB_kgf_cm2()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_AvailablePressureUnitsStatus::clone() {
    return new Property_AvailablePressureUnitsStatus(*this);
}

inline bool Property_AvailablePressureUnitsStatus::operator > (const Property_AvailablePressureUnitsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_AvailablePressureUnitsStatus::clear() {
    clearB_kPa();
    clearB_PSI();
    clearB_bar();
    clearB_kgf_cm2();
}

inline void Property_AvailablePressureUnitsStatus::clearB_kPa() {
    if (hasB_kPa()) {
         clear_has_b_kPa();
        _b_kPa = false;
     }
}

inline bool Property_AvailablePressureUnitsStatus::hasB_kPa () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Property_AvailablePressureUnitsStatus::getB_kPa () const {
    return _b_kPa;
}

inline void Property_AvailablePressureUnitsStatus::setB_kPa (bool b_kPa_) {
    set_has_b_kPa();
    this->_b_kPa = b_kPa_;
}

inline void Property_AvailablePressureUnitsStatus::clearB_PSI() {
    if (hasB_PSI()) {
         clear_has_b_PSI();
        _b_PSI = false;
     }
}

inline bool Property_AvailablePressureUnitsStatus::hasB_PSI () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool Property_AvailablePressureUnitsStatus::getB_PSI () const {
    return _b_PSI;
}

inline void Property_AvailablePressureUnitsStatus::setB_PSI (bool b_PSI_) {
    set_has_b_PSI();
    this->_b_PSI = b_PSI_;
}

inline void Property_AvailablePressureUnitsStatus::clearB_bar() {
    if (hasB_bar()) {
         clear_has_b_bar();
        _b_bar = false;
     }
}

inline bool Property_AvailablePressureUnitsStatus::hasB_bar () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline bool Property_AvailablePressureUnitsStatus::getB_bar () const {
    return _b_bar;
}

inline void Property_AvailablePressureUnitsStatus::setB_bar (bool b_bar_) {
    set_has_b_bar();
    this->_b_bar = b_bar_;
}

inline void Property_AvailablePressureUnitsStatus::clearB_kgf_cm2() {
    if (hasB_kgf_cm2()) {
         clear_has_b_kgf_cm2();
        _b_kgf_cm2 = false;
     }
}

inline bool Property_AvailablePressureUnitsStatus::hasB_kgf_cm2 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline bool Property_AvailablePressureUnitsStatus::getB_kgf_cm2 () const {
    return _b_kgf_cm2;
}

inline void Property_AvailablePressureUnitsStatus::setB_kgf_cm2 (bool b_kgf_cm2_) {
    set_has_b_kgf_cm2();
    this->_b_kgf_cm2 = b_kgf_cm2_;
}

inline void Property_AvailablePressureUnitsStatus::set_has_b_kPa () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_AvailablePressureUnitsStatus::clear_has_b_kPa () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Property_AvailablePressureUnitsStatus::set_has_b_PSI () {
    _has_bits_[0] |= 1u << 1;
}

inline void Property_AvailablePressureUnitsStatus::clear_has_b_PSI () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Property_AvailablePressureUnitsStatus::set_has_b_bar () {
    _has_bits_[0] |= 1u << 2;
}

inline void Property_AvailablePressureUnitsStatus::clear_has_b_bar () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Property_AvailablePressureUnitsStatus::set_has_b_kgf_cm2 () {
    _has_bits_[0] |= 1u << 3;
}

inline void Property_AvailablePressureUnitsStatus::clear_has_b_kgf_cm2 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  Property_RequestedFuelConsumptionUnitStatus::Property_RequestedFuelConsumptionUnitStatus ()  :
    _e8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_RequestedFuelConsumptionUnitStatus::Property_RequestedFuelConsumptionUnitStatus (const Property_RequestedFuelConsumptionUnitStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _e8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_RequestedFuelConsumptionUnitStatus::Property_RequestedFuelConsumptionUnitStatus (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_)  :
    _e8FuelConsumptionUnit (e8FuelConsumptionUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit_IsValid(e8FuelConsumptionUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FuelConsumptionUnit_, "T_e8_datacollector_FuelConsumptionUnit", "e8FuelConsumptionUnit", "Property_RequestedFuelConsumptionUnitStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_RequestedFuelConsumptionUnitStatus::~Property_RequestedFuelConsumptionUnitStatus() {
}

inline Property_RequestedFuelConsumptionUnitStatus& Property_RequestedFuelConsumptionUnitStatus::operator = (const Property_RequestedFuelConsumptionUnitStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8FuelConsumptionUnit()) {
            setE8FuelConsumptionUnit(rhs.getE8FuelConsumptionUnit());
        } else {
            clearE8FuelConsumptionUnit();
        }
    }
    return *this;
}

inline bool Property_RequestedFuelConsumptionUnitStatus::operator == (const Property_RequestedFuelConsumptionUnitStatus& rhs) const {
    return (((!hasE8FuelConsumptionUnit() && !rhs.hasE8FuelConsumptionUnit()) || getE8FuelConsumptionUnit() == rhs.getE8FuelConsumptionUnit()));
}

inline bool Property_RequestedFuelConsumptionUnitStatus::operator != (const Property_RequestedFuelConsumptionUnitStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_RequestedFuelConsumptionUnitStatus::operator < (const Property_RequestedFuelConsumptionUnitStatus& rhs) const {
    if (hasE8FuelConsumptionUnit() || rhs.hasE8FuelConsumptionUnit()) {
        if ((uint32)getE8FuelConsumptionUnit() < (uint32)rhs.getE8FuelConsumptionUnit()) return true;
        if ((uint32)getE8FuelConsumptionUnit() > (uint32)rhs.getE8FuelConsumptionUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_RequestedFuelConsumptionUnitStatus::clone() {
    return new Property_RequestedFuelConsumptionUnitStatus(*this);
}

inline bool Property_RequestedFuelConsumptionUnitStatus::operator > (const Property_RequestedFuelConsumptionUnitStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_RequestedFuelConsumptionUnitStatus::clear() {
    clearE8FuelConsumptionUnit();
}

inline void Property_RequestedFuelConsumptionUnitStatus::clearE8FuelConsumptionUnit() {
    if (hasE8FuelConsumptionUnit()) {
         clear_has_e8FuelConsumptionUnit();
        _e8FuelConsumptionUnit = ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown;
     }
}

inline bool Property_RequestedFuelConsumptionUnitStatus::hasE8FuelConsumptionUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit Property_RequestedFuelConsumptionUnitStatus::getE8FuelConsumptionUnit () const {
    return _e8FuelConsumptionUnit;
}

inline void Property_RequestedFuelConsumptionUnitStatus::setE8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit_IsValid(e8FuelConsumptionUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FuelConsumptionUnit_, "T_e8_datacollector_FuelConsumptionUnit", "e8FuelConsumptionUnit", "Property_RequestedFuelConsumptionUnitStatus");
    }
    #endif
    set_has_e8FuelConsumptionUnit();
    this->_e8FuelConsumptionUnit = e8FuelConsumptionUnit_;
}

inline void Property_RequestedFuelConsumptionUnitStatus::set_has_e8FuelConsumptionUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_RequestedFuelConsumptionUnitStatus::clear_has_e8FuelConsumptionUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_RequestedTemperatureUnitStatus::Property_RequestedTemperatureUnitStatus ()  :
    _e8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_RequestedTemperatureUnitStatus::Property_RequestedTemperatureUnitStatus (const Property_RequestedTemperatureUnitStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _e8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_RequestedTemperatureUnitStatus::Property_RequestedTemperatureUnitStatus (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_)  :
    _e8TemperatureUnit (e8TemperatureUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit_IsValid(e8TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TemperatureUnit_, "T_e8_datacollector_TemperatureUnit", "e8TemperatureUnit", "Property_RequestedTemperatureUnitStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_RequestedTemperatureUnitStatus::~Property_RequestedTemperatureUnitStatus() {
}

inline Property_RequestedTemperatureUnitStatus& Property_RequestedTemperatureUnitStatus::operator = (const Property_RequestedTemperatureUnitStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8TemperatureUnit()) {
            setE8TemperatureUnit(rhs.getE8TemperatureUnit());
        } else {
            clearE8TemperatureUnit();
        }
    }
    return *this;
}

inline bool Property_RequestedTemperatureUnitStatus::operator == (const Property_RequestedTemperatureUnitStatus& rhs) const {
    return (((!hasE8TemperatureUnit() && !rhs.hasE8TemperatureUnit()) || getE8TemperatureUnit() == rhs.getE8TemperatureUnit()));
}

inline bool Property_RequestedTemperatureUnitStatus::operator != (const Property_RequestedTemperatureUnitStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_RequestedTemperatureUnitStatus::operator < (const Property_RequestedTemperatureUnitStatus& rhs) const {
    if (hasE8TemperatureUnit() || rhs.hasE8TemperatureUnit()) {
        if ((uint32)getE8TemperatureUnit() < (uint32)rhs.getE8TemperatureUnit()) return true;
        if ((uint32)getE8TemperatureUnit() > (uint32)rhs.getE8TemperatureUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_RequestedTemperatureUnitStatus::clone() {
    return new Property_RequestedTemperatureUnitStatus(*this);
}

inline bool Property_RequestedTemperatureUnitStatus::operator > (const Property_RequestedTemperatureUnitStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_RequestedTemperatureUnitStatus::clear() {
    clearE8TemperatureUnit();
}

inline void Property_RequestedTemperatureUnitStatus::clearE8TemperatureUnit() {
    if (hasE8TemperatureUnit()) {
         clear_has_e8TemperatureUnit();
        _e8TemperatureUnit = ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown;
     }
}

inline bool Property_RequestedTemperatureUnitStatus::hasE8TemperatureUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit Property_RequestedTemperatureUnitStatus::getE8TemperatureUnit () const {
    return _e8TemperatureUnit;
}

inline void Property_RequestedTemperatureUnitStatus::setE8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit_IsValid(e8TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TemperatureUnit_, "T_e8_datacollector_TemperatureUnit", "e8TemperatureUnit", "Property_RequestedTemperatureUnitStatus");
    }
    #endif
    set_has_e8TemperatureUnit();
    this->_e8TemperatureUnit = e8TemperatureUnit_;
}

inline void Property_RequestedTemperatureUnitStatus::set_has_e8TemperatureUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_RequestedTemperatureUnitStatus::clear_has_e8TemperatureUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_RequestedPressureUnitStatus::Property_RequestedPressureUnitStatus ()  :
    _e8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_RequestedPressureUnitStatus::Property_RequestedPressureUnitStatus (const Property_RequestedPressureUnitStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _e8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_RequestedPressureUnitStatus::Property_RequestedPressureUnitStatus (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_)  :
    _e8PressureUnit (e8PressureUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PressureUnit_IsValid(e8PressureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PressureUnit_, "T_e8_datacollector_PressureUnit", "e8PressureUnit", "Property_RequestedPressureUnitStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_RequestedPressureUnitStatus::~Property_RequestedPressureUnitStatus() {
}

inline Property_RequestedPressureUnitStatus& Property_RequestedPressureUnitStatus::operator = (const Property_RequestedPressureUnitStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8PressureUnit()) {
            setE8PressureUnit(rhs.getE8PressureUnit());
        } else {
            clearE8PressureUnit();
        }
    }
    return *this;
}

inline bool Property_RequestedPressureUnitStatus::operator == (const Property_RequestedPressureUnitStatus& rhs) const {
    return (((!hasE8PressureUnit() && !rhs.hasE8PressureUnit()) || getE8PressureUnit() == rhs.getE8PressureUnit()));
}

inline bool Property_RequestedPressureUnitStatus::operator != (const Property_RequestedPressureUnitStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_RequestedPressureUnitStatus::operator < (const Property_RequestedPressureUnitStatus& rhs) const {
    if (hasE8PressureUnit() || rhs.hasE8PressureUnit()) {
        if ((uint32)getE8PressureUnit() < (uint32)rhs.getE8PressureUnit()) return true;
        if ((uint32)getE8PressureUnit() > (uint32)rhs.getE8PressureUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_RequestedPressureUnitStatus::clone() {
    return new Property_RequestedPressureUnitStatus(*this);
}

inline bool Property_RequestedPressureUnitStatus::operator > (const Property_RequestedPressureUnitStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_RequestedPressureUnitStatus::clear() {
    clearE8PressureUnit();
}

inline void Property_RequestedPressureUnitStatus::clearE8PressureUnit() {
    if (hasE8PressureUnit()) {
         clear_has_e8PressureUnit();
        _e8PressureUnit = ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown;
     }
}

inline bool Property_RequestedPressureUnitStatus::hasE8PressureUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit Property_RequestedPressureUnitStatus::getE8PressureUnit () const {
    return _e8PressureUnit;
}

inline void Property_RequestedPressureUnitStatus::setE8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PressureUnit_IsValid(e8PressureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PressureUnit_, "T_e8_datacollector_PressureUnit", "e8PressureUnit", "Property_RequestedPressureUnitStatus");
    }
    #endif
    set_has_e8PressureUnit();
    this->_e8PressureUnit = e8PressureUnit_;
}

inline void Property_RequestedPressureUnitStatus::set_has_e8PressureUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_RequestedPressureUnitStatus::clear_has_e8PressureUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_SupportedLangSyncModeStatus::Property_SupportedLangSyncModeStatus ()  :
    _e8LangSyncMode (::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type__Not_Available)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_SupportedLangSyncModeStatus::Property_SupportedLangSyncModeStatus (const Property_SupportedLangSyncModeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _e8LangSyncMode (::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type__Not_Available)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_SupportedLangSyncModeStatus::Property_SupportedLangSyncModeStatus (::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type e8LangSyncMode_)  :
    _e8LangSyncMode (e8LangSyncMode_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type_IsValid(e8LangSyncMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LangSyncMode_, "T_e8_datacollector_Lang_Sync_Mode_Type", "e8LangSyncMode", "Property_SupportedLangSyncModeStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_SupportedLangSyncModeStatus::~Property_SupportedLangSyncModeStatus() {
}

inline Property_SupportedLangSyncModeStatus& Property_SupportedLangSyncModeStatus::operator = (const Property_SupportedLangSyncModeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8LangSyncMode()) {
            setE8LangSyncMode(rhs.getE8LangSyncMode());
        } else {
            clearE8LangSyncMode();
        }
    }
    return *this;
}

inline bool Property_SupportedLangSyncModeStatus::operator == (const Property_SupportedLangSyncModeStatus& rhs) const {
    return (((!hasE8LangSyncMode() && !rhs.hasE8LangSyncMode()) || getE8LangSyncMode() == rhs.getE8LangSyncMode()));
}

inline bool Property_SupportedLangSyncModeStatus::operator != (const Property_SupportedLangSyncModeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_SupportedLangSyncModeStatus::operator < (const Property_SupportedLangSyncModeStatus& rhs) const {
    if (hasE8LangSyncMode() || rhs.hasE8LangSyncMode()) {
        if ((uint32)getE8LangSyncMode() < (uint32)rhs.getE8LangSyncMode()) return true;
        if ((uint32)getE8LangSyncMode() > (uint32)rhs.getE8LangSyncMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_SupportedLangSyncModeStatus::clone() {
    return new Property_SupportedLangSyncModeStatus(*this);
}

inline bool Property_SupportedLangSyncModeStatus::operator > (const Property_SupportedLangSyncModeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_SupportedLangSyncModeStatus::clear() {
    clearE8LangSyncMode();
}

inline void Property_SupportedLangSyncModeStatus::clearE8LangSyncMode() {
    if (hasE8LangSyncMode()) {
         clear_has_e8LangSyncMode();
        _e8LangSyncMode = ::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type__Not_Available;
     }
}

inline bool Property_SupportedLangSyncModeStatus::hasE8LangSyncMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type Property_SupportedLangSyncModeStatus::getE8LangSyncMode () const {
    return _e8LangSyncMode;
}

inline void Property_SupportedLangSyncModeStatus::setE8LangSyncMode (::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type e8LangSyncMode_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Lang_Sync_Mode_Type_IsValid(e8LangSyncMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LangSyncMode_, "T_e8_datacollector_Lang_Sync_Mode_Type", "e8LangSyncMode", "Property_SupportedLangSyncModeStatus");
    }
    #endif
    set_has_e8LangSyncMode();
    this->_e8LangSyncMode = e8LangSyncMode_;
}

inline void Property_SupportedLangSyncModeStatus::set_has_e8LangSyncMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_SupportedLangSyncModeStatus::clear_has_e8LangSyncMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetHMIDistanceUnitStart::Method_SetHMIDistanceUnitStart ()  :
    _e8DistanceUnit (::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetHMIDistanceUnitStart::Method_SetHMIDistanceUnitStart (const Method_SetHMIDistanceUnitStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8DistanceUnit (::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetHMIDistanceUnitStart::Method_SetHMIDistanceUnitStart (::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit e8DistanceUnit_)  :
    _e8DistanceUnit (e8DistanceUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit_IsValid(e8DistanceUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceUnit_, "T_e8_datacollector_DistanceUnit", "e8DistanceUnit", "Method_SetHMIDistanceUnitStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetHMIDistanceUnitStart::~Method_SetHMIDistanceUnitStart() {
}

inline Method_SetHMIDistanceUnitStart& Method_SetHMIDistanceUnitStart::operator = (const Method_SetHMIDistanceUnitStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8DistanceUnit()) {
            setE8DistanceUnit(rhs.getE8DistanceUnit());
        } else {
            clearE8DistanceUnit();
        }
    }
    return *this;
}

inline bool Method_SetHMIDistanceUnitStart::operator == (const Method_SetHMIDistanceUnitStart& rhs) const {
    return (((!hasE8DistanceUnit() && !rhs.hasE8DistanceUnit()) || getE8DistanceUnit() == rhs.getE8DistanceUnit()));
}

inline bool Method_SetHMIDistanceUnitStart::operator != (const Method_SetHMIDistanceUnitStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetHMIDistanceUnitStart::operator < (const Method_SetHMIDistanceUnitStart& rhs) const {
    if (hasE8DistanceUnit() || rhs.hasE8DistanceUnit()) {
        if ((uint32)getE8DistanceUnit() < (uint32)rhs.getE8DistanceUnit()) return true;
        if ((uint32)getE8DistanceUnit() > (uint32)rhs.getE8DistanceUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetHMIDistanceUnitStart::clone() {
    return new Method_SetHMIDistanceUnitStart(*this);
}

inline bool Method_SetHMIDistanceUnitStart::operator > (const Method_SetHMIDistanceUnitStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetHMIDistanceUnitStart::clear() {
    clearE8DistanceUnit();
}

inline void Method_SetHMIDistanceUnitStart::clearE8DistanceUnit() {
    if (hasE8DistanceUnit()) {
         clear_has_e8DistanceUnit();
        _e8DistanceUnit = ::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit__Unknown;
     }
}

inline bool Method_SetHMIDistanceUnitStart::hasE8DistanceUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit Method_SetHMIDistanceUnitStart::getE8DistanceUnit () const {
    return _e8DistanceUnit;
}

inline void Method_SetHMIDistanceUnitStart::setE8DistanceUnit (::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit e8DistanceUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_DistanceUnit_IsValid(e8DistanceUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DistanceUnit_, "T_e8_datacollector_DistanceUnit", "e8DistanceUnit", "Method_SetHMIDistanceUnitStart");
    }
    #endif
    set_has_e8DistanceUnit();
    this->_e8DistanceUnit = e8DistanceUnit_;
}

inline void Method_SetHMIDistanceUnitStart::set_has_e8DistanceUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetHMIDistanceUnitStart::clear_has_e8DistanceUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetHMIFuelConsumptionUnitStart::Method_SetHMIFuelConsumptionUnitStart ()  :
    _e8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetHMIFuelConsumptionUnitStart::Method_SetHMIFuelConsumptionUnitStart (const Method_SetHMIFuelConsumptionUnitStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetHMIFuelConsumptionUnitStart::Method_SetHMIFuelConsumptionUnitStart (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_)  :
    _e8FuelConsumptionUnit (e8FuelConsumptionUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit_IsValid(e8FuelConsumptionUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FuelConsumptionUnit_, "T_e8_datacollector_FuelConsumptionUnit", "e8FuelConsumptionUnit", "Method_SetHMIFuelConsumptionUnitStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetHMIFuelConsumptionUnitStart::~Method_SetHMIFuelConsumptionUnitStart() {
}

inline Method_SetHMIFuelConsumptionUnitStart& Method_SetHMIFuelConsumptionUnitStart::operator = (const Method_SetHMIFuelConsumptionUnitStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8FuelConsumptionUnit()) {
            setE8FuelConsumptionUnit(rhs.getE8FuelConsumptionUnit());
        } else {
            clearE8FuelConsumptionUnit();
        }
    }
    return *this;
}

inline bool Method_SetHMIFuelConsumptionUnitStart::operator == (const Method_SetHMIFuelConsumptionUnitStart& rhs) const {
    return (((!hasE8FuelConsumptionUnit() && !rhs.hasE8FuelConsumptionUnit()) || getE8FuelConsumptionUnit() == rhs.getE8FuelConsumptionUnit()));
}

inline bool Method_SetHMIFuelConsumptionUnitStart::operator != (const Method_SetHMIFuelConsumptionUnitStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetHMIFuelConsumptionUnitStart::operator < (const Method_SetHMIFuelConsumptionUnitStart& rhs) const {
    if (hasE8FuelConsumptionUnit() || rhs.hasE8FuelConsumptionUnit()) {
        if ((uint32)getE8FuelConsumptionUnit() < (uint32)rhs.getE8FuelConsumptionUnit()) return true;
        if ((uint32)getE8FuelConsumptionUnit() > (uint32)rhs.getE8FuelConsumptionUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetHMIFuelConsumptionUnitStart::clone() {
    return new Method_SetHMIFuelConsumptionUnitStart(*this);
}

inline bool Method_SetHMIFuelConsumptionUnitStart::operator > (const Method_SetHMIFuelConsumptionUnitStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetHMIFuelConsumptionUnitStart::clear() {
    clearE8FuelConsumptionUnit();
}

inline void Method_SetHMIFuelConsumptionUnitStart::clearE8FuelConsumptionUnit() {
    if (hasE8FuelConsumptionUnit()) {
         clear_has_e8FuelConsumptionUnit();
        _e8FuelConsumptionUnit = ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit__Unknown;
     }
}

inline bool Method_SetHMIFuelConsumptionUnitStart::hasE8FuelConsumptionUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit Method_SetHMIFuelConsumptionUnitStart::getE8FuelConsumptionUnit () const {
    return _e8FuelConsumptionUnit;
}

inline void Method_SetHMIFuelConsumptionUnitStart::setE8FuelConsumptionUnit (::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit e8FuelConsumptionUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_FuelConsumptionUnit_IsValid(e8FuelConsumptionUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8FuelConsumptionUnit_, "T_e8_datacollector_FuelConsumptionUnit", "e8FuelConsumptionUnit", "Method_SetHMIFuelConsumptionUnitStart");
    }
    #endif
    set_has_e8FuelConsumptionUnit();
    this->_e8FuelConsumptionUnit = e8FuelConsumptionUnit_;
}

inline void Method_SetHMIFuelConsumptionUnitStart::set_has_e8FuelConsumptionUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetHMIFuelConsumptionUnitStart::clear_has_e8FuelConsumptionUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetHMITemperatureUnitStart::Method_SetHMITemperatureUnitStart ()  :
    _e8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetHMITemperatureUnitStart::Method_SetHMITemperatureUnitStart (const Method_SetHMITemperatureUnitStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetHMITemperatureUnitStart::Method_SetHMITemperatureUnitStart (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_)  :
    _e8TemperatureUnit (e8TemperatureUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit_IsValid(e8TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TemperatureUnit_, "T_e8_datacollector_TemperatureUnit", "e8TemperatureUnit", "Method_SetHMITemperatureUnitStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetHMITemperatureUnitStart::~Method_SetHMITemperatureUnitStart() {
}

inline Method_SetHMITemperatureUnitStart& Method_SetHMITemperatureUnitStart::operator = (const Method_SetHMITemperatureUnitStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8TemperatureUnit()) {
            setE8TemperatureUnit(rhs.getE8TemperatureUnit());
        } else {
            clearE8TemperatureUnit();
        }
    }
    return *this;
}

inline bool Method_SetHMITemperatureUnitStart::operator == (const Method_SetHMITemperatureUnitStart& rhs) const {
    return (((!hasE8TemperatureUnit() && !rhs.hasE8TemperatureUnit()) || getE8TemperatureUnit() == rhs.getE8TemperatureUnit()));
}

inline bool Method_SetHMITemperatureUnitStart::operator != (const Method_SetHMITemperatureUnitStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetHMITemperatureUnitStart::operator < (const Method_SetHMITemperatureUnitStart& rhs) const {
    if (hasE8TemperatureUnit() || rhs.hasE8TemperatureUnit()) {
        if ((uint32)getE8TemperatureUnit() < (uint32)rhs.getE8TemperatureUnit()) return true;
        if ((uint32)getE8TemperatureUnit() > (uint32)rhs.getE8TemperatureUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetHMITemperatureUnitStart::clone() {
    return new Method_SetHMITemperatureUnitStart(*this);
}

inline bool Method_SetHMITemperatureUnitStart::operator > (const Method_SetHMITemperatureUnitStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetHMITemperatureUnitStart::clear() {
    clearE8TemperatureUnit();
}

inline void Method_SetHMITemperatureUnitStart::clearE8TemperatureUnit() {
    if (hasE8TemperatureUnit()) {
         clear_has_e8TemperatureUnit();
        _e8TemperatureUnit = ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit__Unknown;
     }
}

inline bool Method_SetHMITemperatureUnitStart::hasE8TemperatureUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit Method_SetHMITemperatureUnitStart::getE8TemperatureUnit () const {
    return _e8TemperatureUnit;
}

inline void Method_SetHMITemperatureUnitStart::setE8TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit e8TemperatureUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_TemperatureUnit_IsValid(e8TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8TemperatureUnit_, "T_e8_datacollector_TemperatureUnit", "e8TemperatureUnit", "Method_SetHMITemperatureUnitStart");
    }
    #endif
    set_has_e8TemperatureUnit();
    this->_e8TemperatureUnit = e8TemperatureUnit_;
}

inline void Method_SetHMITemperatureUnitStart::set_has_e8TemperatureUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetHMITemperatureUnitStart::clear_has_e8TemperatureUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetHMIPressureUnitStart::Method_SetHMIPressureUnitStart ()  :
    _e8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetHMIPressureUnitStart::Method_SetHMIPressureUnitStart (const Method_SetHMIPressureUnitStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetHMIPressureUnitStart::Method_SetHMIPressureUnitStart (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_)  :
    _e8PressureUnit (e8PressureUnit_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PressureUnit_IsValid(e8PressureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PressureUnit_, "T_e8_datacollector_PressureUnit", "e8PressureUnit", "Method_SetHMIPressureUnitStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetHMIPressureUnitStart::~Method_SetHMIPressureUnitStart() {
}

inline Method_SetHMIPressureUnitStart& Method_SetHMIPressureUnitStart::operator = (const Method_SetHMIPressureUnitStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8PressureUnit()) {
            setE8PressureUnit(rhs.getE8PressureUnit());
        } else {
            clearE8PressureUnit();
        }
    }
    return *this;
}

inline bool Method_SetHMIPressureUnitStart::operator == (const Method_SetHMIPressureUnitStart& rhs) const {
    return (((!hasE8PressureUnit() && !rhs.hasE8PressureUnit()) || getE8PressureUnit() == rhs.getE8PressureUnit()));
}

inline bool Method_SetHMIPressureUnitStart::operator != (const Method_SetHMIPressureUnitStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetHMIPressureUnitStart::operator < (const Method_SetHMIPressureUnitStart& rhs) const {
    if (hasE8PressureUnit() || rhs.hasE8PressureUnit()) {
        if ((uint32)getE8PressureUnit() < (uint32)rhs.getE8PressureUnit()) return true;
        if ((uint32)getE8PressureUnit() > (uint32)rhs.getE8PressureUnit()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetHMIPressureUnitStart::clone() {
    return new Method_SetHMIPressureUnitStart(*this);
}

inline bool Method_SetHMIPressureUnitStart::operator > (const Method_SetHMIPressureUnitStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetHMIPressureUnitStart::clear() {
    clearE8PressureUnit();
}

inline void Method_SetHMIPressureUnitStart::clearE8PressureUnit() {
    if (hasE8PressureUnit()) {
         clear_has_e8PressureUnit();
        _e8PressureUnit = ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit__Unknown;
     }
}

inline bool Method_SetHMIPressureUnitStart::hasE8PressureUnit () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_PressureUnit Method_SetHMIPressureUnitStart::getE8PressureUnit () const {
    return _e8PressureUnit;
}

inline void Method_SetHMIPressureUnitStart::setE8PressureUnit (::datacollector_main_fi_types::T_e8_datacollector_PressureUnit e8PressureUnit_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PressureUnit_IsValid(e8PressureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8PressureUnit_, "T_e8_datacollector_PressureUnit", "e8PressureUnit", "Method_SetHMIPressureUnitStart");
    }
    #endif
    set_has_e8PressureUnit();
    this->_e8PressureUnit = e8PressureUnit_;
}

inline void Method_SetHMIPressureUnitStart::set_has_e8PressureUnit () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetHMIPressureUnitStart::clear_has_e8PressureUnit () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_RequestedLanguageStatus::Property_RequestedLanguageStatus ()  :
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_RequestedLanguageStatus::Property_RequestedLanguageStatus (const Property_RequestedLanguageStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_RequestedLanguageStatus::Property_RequestedLanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_)  :
    _e8Language (e8Language_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Property_RequestedLanguageStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_RequestedLanguageStatus::~Property_RequestedLanguageStatus() {
}

inline Property_RequestedLanguageStatus& Property_RequestedLanguageStatus::operator = (const Property_RequestedLanguageStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Language()) {
            setE8Language(rhs.getE8Language());
        } else {
            clearE8Language();
        }
    }
    return *this;
}

inline bool Property_RequestedLanguageStatus::operator == (const Property_RequestedLanguageStatus& rhs) const {
    return (((!hasE8Language() && !rhs.hasE8Language()) || getE8Language() == rhs.getE8Language()));
}

inline bool Property_RequestedLanguageStatus::operator != (const Property_RequestedLanguageStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_RequestedLanguageStatus::operator < (const Property_RequestedLanguageStatus& rhs) const {
    if (hasE8Language() || rhs.hasE8Language()) {
        if ((uint32)getE8Language() < (uint32)rhs.getE8Language()) return true;
        if ((uint32)getE8Language() > (uint32)rhs.getE8Language()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_RequestedLanguageStatus::clone() {
    return new Property_RequestedLanguageStatus(*this);
}

inline bool Property_RequestedLanguageStatus::operator > (const Property_RequestedLanguageStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_RequestedLanguageStatus::clear() {
    clearE8Language();
}

inline void Property_RequestedLanguageStatus::clearE8Language() {
    if (hasE8Language()) {
         clear_has_e8Language();
        _e8Language = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Property_RequestedLanguageStatus::hasE8Language () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Property_RequestedLanguageStatus::getE8Language () const {
    return _e8Language;
}

inline void Property_RequestedLanguageStatus::setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Property_RequestedLanguageStatus");
    }
    #endif
    set_has_e8Language();
    this->_e8Language = e8Language_;
}

inline void Property_RequestedLanguageStatus::set_has_e8Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_RequestedLanguageStatus::clear_has_e8Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetRequestedLanguageResultStart::Method_SetRequestedLanguageResultStart ()  :
    _e8Result (::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult__Invalid_Parameter)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetRequestedLanguageResultStart::Method_SetRequestedLanguageResultStart (const Method_SetRequestedLanguageResultStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Result (::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult__Invalid_Parameter)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetRequestedLanguageResultStart::Method_SetRequestedLanguageResultStart (::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult e8Result_)  :
    _e8Result (e8Result_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult_IsValid(e8Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Result_, "T_e8_datacollector_RequestedLanguageResult", "e8Result", "Method_SetRequestedLanguageResultStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetRequestedLanguageResultStart::~Method_SetRequestedLanguageResultStart() {
}

inline Method_SetRequestedLanguageResultStart& Method_SetRequestedLanguageResultStart::operator = (const Method_SetRequestedLanguageResultStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Result()) {
            setE8Result(rhs.getE8Result());
        } else {
            clearE8Result();
        }
    }
    return *this;
}

inline bool Method_SetRequestedLanguageResultStart::operator == (const Method_SetRequestedLanguageResultStart& rhs) const {
    return (((!hasE8Result() && !rhs.hasE8Result()) || getE8Result() == rhs.getE8Result()));
}

inline bool Method_SetRequestedLanguageResultStart::operator != (const Method_SetRequestedLanguageResultStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetRequestedLanguageResultStart::operator < (const Method_SetRequestedLanguageResultStart& rhs) const {
    if (hasE8Result() || rhs.hasE8Result()) {
        if ((uint32)getE8Result() < (uint32)rhs.getE8Result()) return true;
        if ((uint32)getE8Result() > (uint32)rhs.getE8Result()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetRequestedLanguageResultStart::clone() {
    return new Method_SetRequestedLanguageResultStart(*this);
}

inline bool Method_SetRequestedLanguageResultStart::operator > (const Method_SetRequestedLanguageResultStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetRequestedLanguageResultStart::clear() {
    clearE8Result();
}

inline void Method_SetRequestedLanguageResultStart::clearE8Result() {
    if (hasE8Result()) {
         clear_has_e8Result();
        _e8Result = ::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult__Invalid_Parameter;
     }
}

inline bool Method_SetRequestedLanguageResultStart::hasE8Result () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult Method_SetRequestedLanguageResultStart::getE8Result () const {
    return _e8Result;
}

inline void Method_SetRequestedLanguageResultStart::setE8Result (::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult e8Result_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_RequestedLanguageResult_IsValid(e8Result_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Result_, "T_e8_datacollector_RequestedLanguageResult", "e8Result", "Method_SetRequestedLanguageResultStart");
    }
    #endif
    set_has_e8Result();
    this->_e8Result = e8Result_;
}

inline void Method_SetRequestedLanguageResultStart::set_has_e8Result () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetRequestedLanguageResultStart::clear_has_e8Result () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_GetMeterLanguageResult::Method_GetMeterLanguageResult ()  :
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_GetMeterLanguageResult::Method_GetMeterLanguageResult (const Method_GetMeterLanguageResult &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_GetMeterLanguageResult::Method_GetMeterLanguageResult (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_)  :
    _e8Language (e8Language_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_GetMeterLanguageResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_GetMeterLanguageResult::~Method_GetMeterLanguageResult() {
}

inline Method_GetMeterLanguageResult& Method_GetMeterLanguageResult::operator = (const Method_GetMeterLanguageResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Language()) {
            setE8Language(rhs.getE8Language());
        } else {
            clearE8Language();
        }
    }
    return *this;
}

inline bool Method_GetMeterLanguageResult::operator == (const Method_GetMeterLanguageResult& rhs) const {
    return (((!hasE8Language() && !rhs.hasE8Language()) || getE8Language() == rhs.getE8Language()));
}

inline bool Method_GetMeterLanguageResult::operator != (const Method_GetMeterLanguageResult& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetMeterLanguageResult::operator < (const Method_GetMeterLanguageResult& rhs) const {
    if (hasE8Language() || rhs.hasE8Language()) {
        if ((uint32)getE8Language() < (uint32)rhs.getE8Language()) return true;
        if ((uint32)getE8Language() > (uint32)rhs.getE8Language()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_GetMeterLanguageResult::clone() {
    return new Method_GetMeterLanguageResult(*this);
}

inline bool Method_GetMeterLanguageResult::operator > (const Method_GetMeterLanguageResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_GetMeterLanguageResult::clear() {
    clearE8Language();
}

inline void Method_GetMeterLanguageResult::clearE8Language() {
    if (hasE8Language()) {
         clear_has_e8Language();
        _e8Language = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Method_GetMeterLanguageResult::hasE8Language () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Method_GetMeterLanguageResult::getE8Language () const {
    return _e8Language;
}

inline void Method_GetMeterLanguageResult::setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_GetMeterLanguageResult");
    }
    #endif
    set_has_e8Language();
    this->_e8Language = e8Language_;
}

inline void Method_GetMeterLanguageResult::set_has_e8Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_GetMeterLanguageResult::clear_has_e8Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_GetLanguageSettingsRequestfromLCNResult::Method_GetLanguageSettingsRequestfromLCNResult ()  :
    _e8DefaultLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown),
    _e8CurrentLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown),
    _e8LanguageAvailable_Byte_1 (0u),
    _e8LanguageAvailable_Byte_2 (0u),
    _e8LanguageAvailable_Byte_3 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_GetLanguageSettingsRequestfromLCNResult::Method_GetLanguageSettingsRequestfromLCNResult (const Method_GetLanguageSettingsRequestfromLCNResult &rhs)  :
    ::asf::core::Payload(rhs),
    _e8DefaultLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown),
    _e8CurrentLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown),
    _e8LanguageAvailable_Byte_1 (0u),
    _e8LanguageAvailable_Byte_2 (0u),
    _e8LanguageAvailable_Byte_3 (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_GetLanguageSettingsRequestfromLCNResult::Method_GetLanguageSettingsRequestfromLCNResult (::datacollector_main_fi_types::T_e8_datacollector_Language e8DefaultLanguage_, ::datacollector_main_fi_types::T_e8_datacollector_Language e8CurrentLanguage_, uint8 e8LanguageAvailable_Byte_1_, uint8 e8LanguageAvailable_Byte_2_, uint8 e8LanguageAvailable_Byte_3_)  :
    _e8DefaultLanguage (e8DefaultLanguage_),
    _e8CurrentLanguage (e8CurrentLanguage_),
    _e8LanguageAvailable_Byte_1 (e8LanguageAvailable_Byte_1_),
    _e8LanguageAvailable_Byte_2 (e8LanguageAvailable_Byte_2_),
    _e8LanguageAvailable_Byte_3 (e8LanguageAvailable_Byte_3_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8DefaultLanguage_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DefaultLanguage_, "T_e8_datacollector_Language", "e8DefaultLanguage", "Method_GetLanguageSettingsRequestfromLCNResult");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8CurrentLanguage_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CurrentLanguage_, "T_e8_datacollector_Language", "e8CurrentLanguage", "Method_GetLanguageSettingsRequestfromLCNResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_GetLanguageSettingsRequestfromLCNResult::~Method_GetLanguageSettingsRequestfromLCNResult() {
}

inline Method_GetLanguageSettingsRequestfromLCNResult& Method_GetLanguageSettingsRequestfromLCNResult::operator = (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8DefaultLanguage()) {
            setE8DefaultLanguage(rhs.getE8DefaultLanguage());
        } else {
            clearE8DefaultLanguage();
        }
        if (rhs.hasE8CurrentLanguage()) {
            setE8CurrentLanguage(rhs.getE8CurrentLanguage());
        } else {
            clearE8CurrentLanguage();
        }
        if (rhs.hasE8LanguageAvailable_Byte_1()) {
            setE8LanguageAvailable_Byte_1(rhs.getE8LanguageAvailable_Byte_1());
        } else {
            clearE8LanguageAvailable_Byte_1();
        }
        if (rhs.hasE8LanguageAvailable_Byte_2()) {
            setE8LanguageAvailable_Byte_2(rhs.getE8LanguageAvailable_Byte_2());
        } else {
            clearE8LanguageAvailable_Byte_2();
        }
        if (rhs.hasE8LanguageAvailable_Byte_3()) {
            setE8LanguageAvailable_Byte_3(rhs.getE8LanguageAvailable_Byte_3());
        } else {
            clearE8LanguageAvailable_Byte_3();
        }
    }
    return *this;
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::operator == (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const {
    return (((!hasE8DefaultLanguage() && !rhs.hasE8DefaultLanguage()) || getE8DefaultLanguage() == rhs.getE8DefaultLanguage()) &&
        ((!hasE8CurrentLanguage() && !rhs.hasE8CurrentLanguage()) || getE8CurrentLanguage() == rhs.getE8CurrentLanguage()) &&
        ((!hasE8LanguageAvailable_Byte_1() && !rhs.hasE8LanguageAvailable_Byte_1()) || getE8LanguageAvailable_Byte_1() == rhs.getE8LanguageAvailable_Byte_1()) &&
        ((!hasE8LanguageAvailable_Byte_2() && !rhs.hasE8LanguageAvailable_Byte_2()) || getE8LanguageAvailable_Byte_2() == rhs.getE8LanguageAvailable_Byte_2()) &&
        ((!hasE8LanguageAvailable_Byte_3() && !rhs.hasE8LanguageAvailable_Byte_3()) || getE8LanguageAvailable_Byte_3() == rhs.getE8LanguageAvailable_Byte_3()));
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::operator != (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::operator < (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const {
    if (hasE8DefaultLanguage() || rhs.hasE8DefaultLanguage()) {
        if ((uint32)getE8DefaultLanguage() < (uint32)rhs.getE8DefaultLanguage()) return true;
        if ((uint32)getE8DefaultLanguage() > (uint32)rhs.getE8DefaultLanguage()) return false;
    }
    if (hasE8CurrentLanguage() || rhs.hasE8CurrentLanguage()) {
        if ((uint32)getE8CurrentLanguage() < (uint32)rhs.getE8CurrentLanguage()) return true;
        if ((uint32)getE8CurrentLanguage() > (uint32)rhs.getE8CurrentLanguage()) return false;
    }
    if (hasE8LanguageAvailable_Byte_1() || rhs.hasE8LanguageAvailable_Byte_1()) {
        if (getE8LanguageAvailable_Byte_1() < rhs.getE8LanguageAvailable_Byte_1()) return true;
        if (getE8LanguageAvailable_Byte_1() > rhs.getE8LanguageAvailable_Byte_1()) return false;
    }
    if (hasE8LanguageAvailable_Byte_2() || rhs.hasE8LanguageAvailable_Byte_2()) {
        if (getE8LanguageAvailable_Byte_2() < rhs.getE8LanguageAvailable_Byte_2()) return true;
        if (getE8LanguageAvailable_Byte_2() > rhs.getE8LanguageAvailable_Byte_2()) return false;
    }
    if (hasE8LanguageAvailable_Byte_3() || rhs.hasE8LanguageAvailable_Byte_3()) {
        if (getE8LanguageAvailable_Byte_3() < rhs.getE8LanguageAvailable_Byte_3()) return true;
        if (getE8LanguageAvailable_Byte_3() > rhs.getE8LanguageAvailable_Byte_3()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_GetLanguageSettingsRequestfromLCNResult::clone() {
    return new Method_GetLanguageSettingsRequestfromLCNResult(*this);
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::operator > (const Method_GetLanguageSettingsRequestfromLCNResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clear() {
    clearE8DefaultLanguage();
    clearE8CurrentLanguage();
    clearE8LanguageAvailable_Byte_1();
    clearE8LanguageAvailable_Byte_2();
    clearE8LanguageAvailable_Byte_3();
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clearE8DefaultLanguage() {
    if (hasE8DefaultLanguage()) {
         clear_has_e8DefaultLanguage();
        _e8DefaultLanguage = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::hasE8DefaultLanguage () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Method_GetLanguageSettingsRequestfromLCNResult::getE8DefaultLanguage () const {
    return _e8DefaultLanguage;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::setE8DefaultLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language e8DefaultLanguage_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8DefaultLanguage_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8DefaultLanguage_, "T_e8_datacollector_Language", "e8DefaultLanguage", "Method_GetLanguageSettingsRequestfromLCNResult");
    }
    #endif
    set_has_e8DefaultLanguage();
    this->_e8DefaultLanguage = e8DefaultLanguage_;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clearE8CurrentLanguage() {
    if (hasE8CurrentLanguage()) {
         clear_has_e8CurrentLanguage();
        _e8CurrentLanguage = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::hasE8CurrentLanguage () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Method_GetLanguageSettingsRequestfromLCNResult::getE8CurrentLanguage () const {
    return _e8CurrentLanguage;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::setE8CurrentLanguage (::datacollector_main_fi_types::T_e8_datacollector_Language e8CurrentLanguage_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8CurrentLanguage_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CurrentLanguage_, "T_e8_datacollector_Language", "e8CurrentLanguage", "Method_GetLanguageSettingsRequestfromLCNResult");
    }
    #endif
    set_has_e8CurrentLanguage();
    this->_e8CurrentLanguage = e8CurrentLanguage_;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clearE8LanguageAvailable_Byte_1() {
    if (hasE8LanguageAvailable_Byte_1()) {
         clear_has_e8LanguageAvailable_Byte_1();
        _e8LanguageAvailable_Byte_1 = 0u;
     }
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::hasE8LanguageAvailable_Byte_1 () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Method_GetLanguageSettingsRequestfromLCNResult::getE8LanguageAvailable_Byte_1 () const {
    return _e8LanguageAvailable_Byte_1;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::setE8LanguageAvailable_Byte_1 (uint8 e8LanguageAvailable_Byte_1_) {
    set_has_e8LanguageAvailable_Byte_1();
    this->_e8LanguageAvailable_Byte_1 = e8LanguageAvailable_Byte_1_;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clearE8LanguageAvailable_Byte_2() {
    if (hasE8LanguageAvailable_Byte_2()) {
         clear_has_e8LanguageAvailable_Byte_2();
        _e8LanguageAvailable_Byte_2 = 0u;
     }
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::hasE8LanguageAvailable_Byte_2 () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 Method_GetLanguageSettingsRequestfromLCNResult::getE8LanguageAvailable_Byte_2 () const {
    return _e8LanguageAvailable_Byte_2;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::setE8LanguageAvailable_Byte_2 (uint8 e8LanguageAvailable_Byte_2_) {
    set_has_e8LanguageAvailable_Byte_2();
    this->_e8LanguageAvailable_Byte_2 = e8LanguageAvailable_Byte_2_;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clearE8LanguageAvailable_Byte_3() {
    if (hasE8LanguageAvailable_Byte_3()) {
         clear_has_e8LanguageAvailable_Byte_3();
        _e8LanguageAvailable_Byte_3 = 0u;
     }
}

inline bool Method_GetLanguageSettingsRequestfromLCNResult::hasE8LanguageAvailable_Byte_3 () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint8 Method_GetLanguageSettingsRequestfromLCNResult::getE8LanguageAvailable_Byte_3 () const {
    return _e8LanguageAvailable_Byte_3;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::setE8LanguageAvailable_Byte_3 (uint8 e8LanguageAvailable_Byte_3_) {
    set_has_e8LanguageAvailable_Byte_3();
    this->_e8LanguageAvailable_Byte_3 = e8LanguageAvailable_Byte_3_;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::set_has_e8DefaultLanguage () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clear_has_e8DefaultLanguage () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::set_has_e8CurrentLanguage () {
    _has_bits_[0] |= 1u << 1;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clear_has_e8CurrentLanguage () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::set_has_e8LanguageAvailable_Byte_1 () {
    _has_bits_[0] |= 1u << 2;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clear_has_e8LanguageAvailable_Byte_1 () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::set_has_e8LanguageAvailable_Byte_2 () {
    _has_bits_[0] |= 1u << 3;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clear_has_e8LanguageAvailable_Byte_2 () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::set_has_e8LanguageAvailable_Byte_3 () {
    _has_bits_[0] |= 1u << 4;
}

inline void Method_GetLanguageSettingsRequestfromLCNResult::clear_has_e8LanguageAvailable_Byte_3 () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure::Method_GetLanguageSettingsRequestfromLCNErrorStructure ()  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure::Method_GetLanguageSettingsRequestfromLCNErrorStructure (const Method_GetLanguageSettingsRequestfromLCNErrorStructure &rhs)  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure::Method_GetLanguageSettingsRequestfromLCNErrorStructure (uint16 Error_)  :
    _Error (Error_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_GetLanguageSettingsRequestfromLCNErrorStructure::~Method_GetLanguageSettingsRequestfromLCNErrorStructure() {
}

inline Method_GetLanguageSettingsRequestfromLCNErrorStructure& Method_GetLanguageSettingsRequestfromLCNErrorStructure::operator = (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasError()) {
            setError(rhs.getError());
        } else {
            clearError();
        }
    }
    return *this;
}

inline bool Method_GetLanguageSettingsRequestfromLCNErrorStructure::operator == (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const {
    return (((!hasError() && !rhs.hasError()) || getError() == rhs.getError()));
}

inline bool Method_GetLanguageSettingsRequestfromLCNErrorStructure::operator != (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageSettingsRequestfromLCNErrorStructure::operator < (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const {
    if (hasError() || rhs.hasError()) {
        if (getError() < rhs.getError()) return true;
        if (getError() > rhs.getError()) return false;
    }
    return false;
}

inline bool Method_GetLanguageSettingsRequestfromLCNErrorStructure::operator > (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_GetLanguageSettingsRequestfromLCNErrorStructure::clear() {
    clearError();
}

inline void Method_GetLanguageSettingsRequestfromLCNErrorStructure::clearError() {
    if (hasError()) {
         clear_has_Error();
        _Error = 0u;
     }
}

inline bool Method_GetLanguageSettingsRequestfromLCNErrorStructure::hasError () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Method_GetLanguageSettingsRequestfromLCNErrorStructure::getError () const {
    return _Error;
}

inline void Method_GetLanguageSettingsRequestfromLCNErrorStructure::setError (uint16 Error_) {
    set_has_Error();
    this->_Error = Error_;
}

inline void Method_GetLanguageSettingsRequestfromLCNErrorStructure::set_has_Error () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_GetLanguageSettingsRequestfromLCNErrorStructure::clear_has_Error () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_GetLanguageSettingsRequestfromLCNError::Method_GetLanguageSettingsRequestfromLCNError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  Method_GetLanguageSettingsRequestfromLCNError::Method_GetLanguageSettingsRequestfromLCNError (const Method_GetLanguageSettingsRequestfromLCNError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  Method_GetLanguageSettingsRequestfromLCNError::~Method_GetLanguageSettingsRequestfromLCNError() {
    deleteData ();
}

inline Method_GetLanguageSettingsRequestfromLCNError& Method_GetLanguageSettingsRequestfromLCNError::operator = (const Method_GetLanguageSettingsRequestfromLCNError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool Method_GetLanguageSettingsRequestfromLCNError::operator == (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool Method_GetLanguageSettingsRequestfromLCNError::operator != (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageSettingsRequestfromLCNError::operator < (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool Method_GetLanguageSettingsRequestfromLCNError::operator > (const Method_GetLanguageSettingsRequestfromLCNError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline Method_GetLanguageSettingsRequestfromLCNError::Method_GetLanguageSettingsRequestfromLCNErrorField Method_GetLanguageSettingsRequestfromLCNError::getField () const {
    return __field;
}

inline void Method_GetLanguageSettingsRequestfromLCNError::setField(Method_GetLanguageSettingsRequestfromLCNError::Method_GetLanguageSettingsRequestfromLCNErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* Method_GetLanguageSettingsRequestfromLCNError::clone() {
    return new Method_GetLanguageSettingsRequestfromLCNError(*this);
}

inline bool Method_GetLanguageSettingsRequestfromLCNError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const Method_GetLanguageSettingsRequestfromLCNErrorStructure& Method_GetLanguageSettingsRequestfromLCNError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_GetLanguageSettingsRequestfromLCNError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return Method_GetLanguageSettingsRequestfromLCNErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_GetLanguageSettingsRequestfromLCNErrorStructure& Method_GetLanguageSettingsRequestfromLCNError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_GetLanguageSettingsRequestfromLCNError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_GetLanguageSettingsRequestfromLCNErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_GetLanguageSettingsRequestfromLCNErrorStructure* Method_GetLanguageSettingsRequestfromLCNError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'Method_GetLanguageSettingsRequestfromLCNError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_GetLanguageSettingsRequestfromLCNErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        Method_GetLanguageSettingsRequestfromLCNErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void Method_GetLanguageSettingsRequestfromLCNError::replaceCcaErrorCode (Method_GetLanguageSettingsRequestfromLCNErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void Method_GetLanguageSettingsRequestfromLCNError::setCcaErrorCode (const Method_GetLanguageSettingsRequestfromLCNErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new Method_GetLanguageSettingsRequestfromLCNErrorStructure(value);
    }
}

inline bool Method_GetLanguageSettingsRequestfromLCNError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode Method_GetLanguageSettingsRequestfromLCNError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "Method_GetLanguageSettingsRequestfromLCNError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void Method_GetLanguageSettingsRequestfromLCNError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "Method_GetLanguageSettingsRequestfromLCNError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void Method_GetLanguageSettingsRequestfromLCNError::cloneData (const Method_GetLanguageSettingsRequestfromLCNError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new Method_GetLanguageSettingsRequestfromLCNErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new Method_GetLanguageSettingsRequestfromLCNErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void Method_GetLanguageSettingsRequestfromLCNError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  Method_SetLanguageSettingsfromLCNStart::Method_SetLanguageSettingsfromLCNStart ()  :
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetLanguageSettingsfromLCNStart::Method_SetLanguageSettingsfromLCNStart (const Method_SetLanguageSettingsfromLCNStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetLanguageSettingsfromLCNStart::Method_SetLanguageSettingsfromLCNStart (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_)  :
    _e8Language (e8Language_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_SetLanguageSettingsfromLCNStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetLanguageSettingsfromLCNStart::~Method_SetLanguageSettingsfromLCNStart() {
}

inline Method_SetLanguageSettingsfromLCNStart& Method_SetLanguageSettingsfromLCNStart::operator = (const Method_SetLanguageSettingsfromLCNStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Language()) {
            setE8Language(rhs.getE8Language());
        } else {
            clearE8Language();
        }
    }
    return *this;
}

inline bool Method_SetLanguageSettingsfromLCNStart::operator == (const Method_SetLanguageSettingsfromLCNStart& rhs) const {
    return (((!hasE8Language() && !rhs.hasE8Language()) || getE8Language() == rhs.getE8Language()));
}

inline bool Method_SetLanguageSettingsfromLCNStart::operator != (const Method_SetLanguageSettingsfromLCNStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetLanguageSettingsfromLCNStart::operator < (const Method_SetLanguageSettingsfromLCNStart& rhs) const {
    if (hasE8Language() || rhs.hasE8Language()) {
        if ((uint32)getE8Language() < (uint32)rhs.getE8Language()) return true;
        if ((uint32)getE8Language() > (uint32)rhs.getE8Language()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetLanguageSettingsfromLCNStart::clone() {
    return new Method_SetLanguageSettingsfromLCNStart(*this);
}

inline bool Method_SetLanguageSettingsfromLCNStart::operator > (const Method_SetLanguageSettingsfromLCNStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetLanguageSettingsfromLCNStart::clear() {
    clearE8Language();
}

inline void Method_SetLanguageSettingsfromLCNStart::clearE8Language() {
    if (hasE8Language()) {
         clear_has_e8Language();
        _e8Language = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Method_SetLanguageSettingsfromLCNStart::hasE8Language () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Method_SetLanguageSettingsfromLCNStart::getE8Language () const {
    return _e8Language;
}

inline void Method_SetLanguageSettingsfromLCNStart::setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_SetLanguageSettingsfromLCNStart");
    }
    #endif
    set_has_e8Language();
    this->_e8Language = e8Language_;
}

inline void Method_SetLanguageSettingsfromLCNStart::set_has_e8Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetLanguageSettingsfromLCNStart::clear_has_e8Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetLanguageSettingsfromLCNErrorStructure::Method_SetLanguageSettingsfromLCNErrorStructure ()  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetLanguageSettingsfromLCNErrorStructure::Method_SetLanguageSettingsfromLCNErrorStructure (const Method_SetLanguageSettingsfromLCNErrorStructure &rhs)  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetLanguageSettingsfromLCNErrorStructure::Method_SetLanguageSettingsfromLCNErrorStructure (uint16 Error_)  :
    _Error (Error_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetLanguageSettingsfromLCNErrorStructure::~Method_SetLanguageSettingsfromLCNErrorStructure() {
}

inline Method_SetLanguageSettingsfromLCNErrorStructure& Method_SetLanguageSettingsfromLCNErrorStructure::operator = (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasError()) {
            setError(rhs.getError());
        } else {
            clearError();
        }
    }
    return *this;
}

inline bool Method_SetLanguageSettingsfromLCNErrorStructure::operator == (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const {
    return (((!hasError() && !rhs.hasError()) || getError() == rhs.getError()));
}

inline bool Method_SetLanguageSettingsfromLCNErrorStructure::operator != (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetLanguageSettingsfromLCNErrorStructure::operator < (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const {
    if (hasError() || rhs.hasError()) {
        if (getError() < rhs.getError()) return true;
        if (getError() > rhs.getError()) return false;
    }
    return false;
}

inline bool Method_SetLanguageSettingsfromLCNErrorStructure::operator > (const Method_SetLanguageSettingsfromLCNErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetLanguageSettingsfromLCNErrorStructure::clear() {
    clearError();
}

inline void Method_SetLanguageSettingsfromLCNErrorStructure::clearError() {
    if (hasError()) {
         clear_has_Error();
        _Error = 0u;
     }
}

inline bool Method_SetLanguageSettingsfromLCNErrorStructure::hasError () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Method_SetLanguageSettingsfromLCNErrorStructure::getError () const {
    return _Error;
}

inline void Method_SetLanguageSettingsfromLCNErrorStructure::setError (uint16 Error_) {
    set_has_Error();
    this->_Error = Error_;
}

inline void Method_SetLanguageSettingsfromLCNErrorStructure::set_has_Error () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetLanguageSettingsfromLCNErrorStructure::clear_has_Error () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetLanguageSettingsfromLCNError::Method_SetLanguageSettingsfromLCNError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  Method_SetLanguageSettingsfromLCNError::Method_SetLanguageSettingsfromLCNError (const Method_SetLanguageSettingsfromLCNError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  Method_SetLanguageSettingsfromLCNError::~Method_SetLanguageSettingsfromLCNError() {
    deleteData ();
}

inline Method_SetLanguageSettingsfromLCNError& Method_SetLanguageSettingsfromLCNError::operator = (const Method_SetLanguageSettingsfromLCNError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool Method_SetLanguageSettingsfromLCNError::operator == (const Method_SetLanguageSettingsfromLCNError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool Method_SetLanguageSettingsfromLCNError::operator != (const Method_SetLanguageSettingsfromLCNError& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetLanguageSettingsfromLCNError::operator < (const Method_SetLanguageSettingsfromLCNError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool Method_SetLanguageSettingsfromLCNError::operator > (const Method_SetLanguageSettingsfromLCNError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline Method_SetLanguageSettingsfromLCNError::Method_SetLanguageSettingsfromLCNErrorField Method_SetLanguageSettingsfromLCNError::getField () const {
    return __field;
}

inline void Method_SetLanguageSettingsfromLCNError::setField(Method_SetLanguageSettingsfromLCNError::Method_SetLanguageSettingsfromLCNErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* Method_SetLanguageSettingsfromLCNError::clone() {
    return new Method_SetLanguageSettingsfromLCNError(*this);
}

inline bool Method_SetLanguageSettingsfromLCNError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const Method_SetLanguageSettingsfromLCNErrorStructure& Method_SetLanguageSettingsfromLCNError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_SetLanguageSettingsfromLCNError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return Method_SetLanguageSettingsfromLCNErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_SetLanguageSettingsfromLCNErrorStructure& Method_SetLanguageSettingsfromLCNError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_SetLanguageSettingsfromLCNError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_SetLanguageSettingsfromLCNErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_SetLanguageSettingsfromLCNErrorStructure* Method_SetLanguageSettingsfromLCNError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'Method_SetLanguageSettingsfromLCNError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_SetLanguageSettingsfromLCNErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        Method_SetLanguageSettingsfromLCNErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void Method_SetLanguageSettingsfromLCNError::replaceCcaErrorCode (Method_SetLanguageSettingsfromLCNErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void Method_SetLanguageSettingsfromLCNError::setCcaErrorCode (const Method_SetLanguageSettingsfromLCNErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new Method_SetLanguageSettingsfromLCNErrorStructure(value);
    }
}

inline bool Method_SetLanguageSettingsfromLCNError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode Method_SetLanguageSettingsfromLCNError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "Method_SetLanguageSettingsfromLCNError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void Method_SetLanguageSettingsfromLCNError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "Method_SetLanguageSettingsfromLCNError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void Method_SetLanguageSettingsfromLCNError::cloneData (const Method_SetLanguageSettingsfromLCNError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new Method_SetLanguageSettingsfromLCNErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new Method_SetLanguageSettingsfromLCNErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void Method_SetLanguageSettingsfromLCNError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  Method_GetLanguageAvailabilityStart::Method_GetLanguageAvailabilityStart ()  :
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_GetLanguageAvailabilityStart::Method_GetLanguageAvailabilityStart (const Method_GetLanguageAvailabilityStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_GetLanguageAvailabilityStart::Method_GetLanguageAvailabilityStart (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_)  :
    _e8Language (e8Language_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_GetLanguageAvailabilityStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_GetLanguageAvailabilityStart::~Method_GetLanguageAvailabilityStart() {
}

inline Method_GetLanguageAvailabilityStart& Method_GetLanguageAvailabilityStart::operator = (const Method_GetLanguageAvailabilityStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Language()) {
            setE8Language(rhs.getE8Language());
        } else {
            clearE8Language();
        }
    }
    return *this;
}

inline bool Method_GetLanguageAvailabilityStart::operator == (const Method_GetLanguageAvailabilityStart& rhs) const {
    return (((!hasE8Language() && !rhs.hasE8Language()) || getE8Language() == rhs.getE8Language()));
}

inline bool Method_GetLanguageAvailabilityStart::operator != (const Method_GetLanguageAvailabilityStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageAvailabilityStart::operator < (const Method_GetLanguageAvailabilityStart& rhs) const {
    if (hasE8Language() || rhs.hasE8Language()) {
        if ((uint32)getE8Language() < (uint32)rhs.getE8Language()) return true;
        if ((uint32)getE8Language() > (uint32)rhs.getE8Language()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_GetLanguageAvailabilityStart::clone() {
    return new Method_GetLanguageAvailabilityStart(*this);
}

inline bool Method_GetLanguageAvailabilityStart::operator > (const Method_GetLanguageAvailabilityStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_GetLanguageAvailabilityStart::clear() {
    clearE8Language();
}

inline void Method_GetLanguageAvailabilityStart::clearE8Language() {
    if (hasE8Language()) {
         clear_has_e8Language();
        _e8Language = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Method_GetLanguageAvailabilityStart::hasE8Language () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Method_GetLanguageAvailabilityStart::getE8Language () const {
    return _e8Language;
}

inline void Method_GetLanguageAvailabilityStart::setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_GetLanguageAvailabilityStart");
    }
    #endif
    set_has_e8Language();
    this->_e8Language = e8Language_;
}

inline void Method_GetLanguageAvailabilityStart::set_has_e8Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_GetLanguageAvailabilityStart::clear_has_e8Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_GetLanguageAvailabilityResult::Method_GetLanguageAvailabilityResult ()  :
    _e8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_GetLanguageAvailabilityResult::Method_GetLanguageAvailabilityResult (const Method_GetLanguageAvailabilityResult &rhs)  :
    ::asf::core::Payload(rhs),
    _e8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_GetLanguageAvailabilityResult::Method_GetLanguageAvailabilityResult (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_)  :
    _e8LanguageStatus (e8LanguageStatus_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_Status_IsValid(e8LanguageStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LanguageStatus_, "T_e8_datacollector_Language_Status", "e8LanguageStatus", "Method_GetLanguageAvailabilityResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_GetLanguageAvailabilityResult::~Method_GetLanguageAvailabilityResult() {
}

inline Method_GetLanguageAvailabilityResult& Method_GetLanguageAvailabilityResult::operator = (const Method_GetLanguageAvailabilityResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8LanguageStatus()) {
            setE8LanguageStatus(rhs.getE8LanguageStatus());
        } else {
            clearE8LanguageStatus();
        }
    }
    return *this;
}

inline bool Method_GetLanguageAvailabilityResult::operator == (const Method_GetLanguageAvailabilityResult& rhs) const {
    return (((!hasE8LanguageStatus() && !rhs.hasE8LanguageStatus()) || getE8LanguageStatus() == rhs.getE8LanguageStatus()));
}

inline bool Method_GetLanguageAvailabilityResult::operator != (const Method_GetLanguageAvailabilityResult& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageAvailabilityResult::operator < (const Method_GetLanguageAvailabilityResult& rhs) const {
    if (hasE8LanguageStatus() || rhs.hasE8LanguageStatus()) {
        if ((uint32)getE8LanguageStatus() < (uint32)rhs.getE8LanguageStatus()) return true;
        if ((uint32)getE8LanguageStatus() > (uint32)rhs.getE8LanguageStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_GetLanguageAvailabilityResult::clone() {
    return new Method_GetLanguageAvailabilityResult(*this);
}

inline bool Method_GetLanguageAvailabilityResult::operator > (const Method_GetLanguageAvailabilityResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_GetLanguageAvailabilityResult::clear() {
    clearE8LanguageStatus();
}

inline void Method_GetLanguageAvailabilityResult::clearE8LanguageStatus() {
    if (hasE8LanguageStatus()) {
         clear_has_e8LanguageStatus();
        _e8LanguageStatus = ::datacollector_main_fi_types::T_e8_datacollector_Language_Status__Unavailable;
     }
}

inline bool Method_GetLanguageAvailabilityResult::hasE8LanguageStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language_Status Method_GetLanguageAvailabilityResult::getE8LanguageStatus () const {
    return _e8LanguageStatus;
}

inline void Method_GetLanguageAvailabilityResult::setE8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_Status_IsValid(e8LanguageStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LanguageStatus_, "T_e8_datacollector_Language_Status", "e8LanguageStatus", "Method_GetLanguageAvailabilityResult");
    }
    #endif
    set_has_e8LanguageStatus();
    this->_e8LanguageStatus = e8LanguageStatus_;
}

inline void Method_GetLanguageAvailabilityResult::set_has_e8LanguageStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_GetLanguageAvailabilityResult::clear_has_e8LanguageStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_GetLanguageAvailabilityErrorStructure::Method_GetLanguageAvailabilityErrorStructure ()  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_GetLanguageAvailabilityErrorStructure::Method_GetLanguageAvailabilityErrorStructure (const Method_GetLanguageAvailabilityErrorStructure &rhs)  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_GetLanguageAvailabilityErrorStructure::Method_GetLanguageAvailabilityErrorStructure (uint16 Error_)  :
    _Error (Error_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_GetLanguageAvailabilityErrorStructure::~Method_GetLanguageAvailabilityErrorStructure() {
}

inline Method_GetLanguageAvailabilityErrorStructure& Method_GetLanguageAvailabilityErrorStructure::operator = (const Method_GetLanguageAvailabilityErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasError()) {
            setError(rhs.getError());
        } else {
            clearError();
        }
    }
    return *this;
}

inline bool Method_GetLanguageAvailabilityErrorStructure::operator == (const Method_GetLanguageAvailabilityErrorStructure& rhs) const {
    return (((!hasError() && !rhs.hasError()) || getError() == rhs.getError()));
}

inline bool Method_GetLanguageAvailabilityErrorStructure::operator != (const Method_GetLanguageAvailabilityErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageAvailabilityErrorStructure::operator < (const Method_GetLanguageAvailabilityErrorStructure& rhs) const {
    if (hasError() || rhs.hasError()) {
        if (getError() < rhs.getError()) return true;
        if (getError() > rhs.getError()) return false;
    }
    return false;
}

inline bool Method_GetLanguageAvailabilityErrorStructure::operator > (const Method_GetLanguageAvailabilityErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_GetLanguageAvailabilityErrorStructure::clear() {
    clearError();
}

inline void Method_GetLanguageAvailabilityErrorStructure::clearError() {
    if (hasError()) {
         clear_has_Error();
        _Error = 0u;
     }
}

inline bool Method_GetLanguageAvailabilityErrorStructure::hasError () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Method_GetLanguageAvailabilityErrorStructure::getError () const {
    return _Error;
}

inline void Method_GetLanguageAvailabilityErrorStructure::setError (uint16 Error_) {
    set_has_Error();
    this->_Error = Error_;
}

inline void Method_GetLanguageAvailabilityErrorStructure::set_has_Error () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_GetLanguageAvailabilityErrorStructure::clear_has_Error () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_GetLanguageAvailabilityError::Method_GetLanguageAvailabilityError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  Method_GetLanguageAvailabilityError::Method_GetLanguageAvailabilityError (const Method_GetLanguageAvailabilityError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  Method_GetLanguageAvailabilityError::~Method_GetLanguageAvailabilityError() {
    deleteData ();
}

inline Method_GetLanguageAvailabilityError& Method_GetLanguageAvailabilityError::operator = (const Method_GetLanguageAvailabilityError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool Method_GetLanguageAvailabilityError::operator == (const Method_GetLanguageAvailabilityError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool Method_GetLanguageAvailabilityError::operator != (const Method_GetLanguageAvailabilityError& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_GetLanguageAvailabilityError::operator < (const Method_GetLanguageAvailabilityError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool Method_GetLanguageAvailabilityError::operator > (const Method_GetLanguageAvailabilityError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline Method_GetLanguageAvailabilityError::Method_GetLanguageAvailabilityErrorField Method_GetLanguageAvailabilityError::getField () const {
    return __field;
}

inline void Method_GetLanguageAvailabilityError::setField(Method_GetLanguageAvailabilityError::Method_GetLanguageAvailabilityErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* Method_GetLanguageAvailabilityError::clone() {
    return new Method_GetLanguageAvailabilityError(*this);
}

inline bool Method_GetLanguageAvailabilityError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const Method_GetLanguageAvailabilityErrorStructure& Method_GetLanguageAvailabilityError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_GetLanguageAvailabilityError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return Method_GetLanguageAvailabilityErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_GetLanguageAvailabilityErrorStructure& Method_GetLanguageAvailabilityError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_GetLanguageAvailabilityError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_GetLanguageAvailabilityErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_GetLanguageAvailabilityErrorStructure* Method_GetLanguageAvailabilityError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'Method_GetLanguageAvailabilityError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_GetLanguageAvailabilityErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        Method_GetLanguageAvailabilityErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void Method_GetLanguageAvailabilityError::replaceCcaErrorCode (Method_GetLanguageAvailabilityErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void Method_GetLanguageAvailabilityError::setCcaErrorCode (const Method_GetLanguageAvailabilityErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new Method_GetLanguageAvailabilityErrorStructure(value);
    }
}

inline bool Method_GetLanguageAvailabilityError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode Method_GetLanguageAvailabilityError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "Method_GetLanguageAvailabilityError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void Method_GetLanguageAvailabilityError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "Method_GetLanguageAvailabilityError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void Method_GetLanguageAvailabilityError::cloneData (const Method_GetLanguageAvailabilityError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new Method_GetLanguageAvailabilityErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new Method_GetLanguageAvailabilityErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void Method_GetLanguageAvailabilityError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  Method_SetMeterLanguageStart::Method_SetMeterLanguageStart ()  :
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetMeterLanguageStart::Method_SetMeterLanguageStart (const Method_SetMeterLanguageStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8Language (::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetMeterLanguageStart::Method_SetMeterLanguageStart (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_)  :
    _e8Language (e8Language_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_SetMeterLanguageStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetMeterLanguageStart::~Method_SetMeterLanguageStart() {
}

inline Method_SetMeterLanguageStart& Method_SetMeterLanguageStart::operator = (const Method_SetMeterLanguageStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8Language()) {
            setE8Language(rhs.getE8Language());
        } else {
            clearE8Language();
        }
    }
    return *this;
}

inline bool Method_SetMeterLanguageStart::operator == (const Method_SetMeterLanguageStart& rhs) const {
    return (((!hasE8Language() && !rhs.hasE8Language()) || getE8Language() == rhs.getE8Language()));
}

inline bool Method_SetMeterLanguageStart::operator != (const Method_SetMeterLanguageStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetMeterLanguageStart::operator < (const Method_SetMeterLanguageStart& rhs) const {
    if (hasE8Language() || rhs.hasE8Language()) {
        if ((uint32)getE8Language() < (uint32)rhs.getE8Language()) return true;
        if ((uint32)getE8Language() > (uint32)rhs.getE8Language()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetMeterLanguageStart::clone() {
    return new Method_SetMeterLanguageStart(*this);
}

inline bool Method_SetMeterLanguageStart::operator > (const Method_SetMeterLanguageStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetMeterLanguageStart::clear() {
    clearE8Language();
}

inline void Method_SetMeterLanguageStart::clearE8Language() {
    if (hasE8Language()) {
         clear_has_e8Language();
        _e8Language = ::datacollector_main_fi_types::T_e8_datacollector_Language__Unknown;
     }
}

inline bool Method_SetMeterLanguageStart::hasE8Language () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language Method_SetMeterLanguageStart::getE8Language () const {
    return _e8Language;
}

inline void Method_SetMeterLanguageStart::setE8Language (::datacollector_main_fi_types::T_e8_datacollector_Language e8Language_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_IsValid(e8Language_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Language_, "T_e8_datacollector_Language", "e8Language", "Method_SetMeterLanguageStart");
    }
    #endif
    set_has_e8Language();
    this->_e8Language = e8Language_;
}

inline void Method_SetMeterLanguageStart::set_has_e8Language () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetMeterLanguageStart::clear_has_e8Language () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetMeterLanguageResult::Method_SetMeterLanguageResult ()  :
    _e8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetMeterLanguageResult::Method_SetMeterLanguageResult (const Method_SetMeterLanguageResult &rhs)  :
    ::asf::core::Payload(rhs),
    _e8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status__Unavailable)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetMeterLanguageResult::Method_SetMeterLanguageResult (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_)  :
    _e8LanguageStatus (e8LanguageStatus_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_Status_IsValid(e8LanguageStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LanguageStatus_, "T_e8_datacollector_Language_Status", "e8LanguageStatus", "Method_SetMeterLanguageResult");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetMeterLanguageResult::~Method_SetMeterLanguageResult() {
}

inline Method_SetMeterLanguageResult& Method_SetMeterLanguageResult::operator = (const Method_SetMeterLanguageResult& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8LanguageStatus()) {
            setE8LanguageStatus(rhs.getE8LanguageStatus());
        } else {
            clearE8LanguageStatus();
        }
    }
    return *this;
}

inline bool Method_SetMeterLanguageResult::operator == (const Method_SetMeterLanguageResult& rhs) const {
    return (((!hasE8LanguageStatus() && !rhs.hasE8LanguageStatus()) || getE8LanguageStatus() == rhs.getE8LanguageStatus()));
}

inline bool Method_SetMeterLanguageResult::operator != (const Method_SetMeterLanguageResult& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetMeterLanguageResult::operator < (const Method_SetMeterLanguageResult& rhs) const {
    if (hasE8LanguageStatus() || rhs.hasE8LanguageStatus()) {
        if ((uint32)getE8LanguageStatus() < (uint32)rhs.getE8LanguageStatus()) return true;
        if ((uint32)getE8LanguageStatus() > (uint32)rhs.getE8LanguageStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetMeterLanguageResult::clone() {
    return new Method_SetMeterLanguageResult(*this);
}

inline bool Method_SetMeterLanguageResult::operator > (const Method_SetMeterLanguageResult& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetMeterLanguageResult::clear() {
    clearE8LanguageStatus();
}

inline void Method_SetMeterLanguageResult::clearE8LanguageStatus() {
    if (hasE8LanguageStatus()) {
         clear_has_e8LanguageStatus();
        _e8LanguageStatus = ::datacollector_main_fi_types::T_e8_datacollector_Language_Status__Unavailable;
     }
}

inline bool Method_SetMeterLanguageResult::hasE8LanguageStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Language_Status Method_SetMeterLanguageResult::getE8LanguageStatus () const {
    return _e8LanguageStatus;
}

inline void Method_SetMeterLanguageResult::setE8LanguageStatus (::datacollector_main_fi_types::T_e8_datacollector_Language_Status e8LanguageStatus_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Language_Status_IsValid(e8LanguageStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LanguageStatus_, "T_e8_datacollector_Language_Status", "e8LanguageStatus", "Method_SetMeterLanguageResult");
    }
    #endif
    set_has_e8LanguageStatus();
    this->_e8LanguageStatus = e8LanguageStatus_;
}

inline void Method_SetMeterLanguageResult::set_has_e8LanguageStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetMeterLanguageResult::clear_has_e8LanguageStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetMeterLanguageErrorStructure::Method_SetMeterLanguageErrorStructure ()  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetMeterLanguageErrorStructure::Method_SetMeterLanguageErrorStructure (const Method_SetMeterLanguageErrorStructure &rhs)  :
    _Error (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetMeterLanguageErrorStructure::Method_SetMeterLanguageErrorStructure (uint16 Error_)  :
    _Error (Error_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetMeterLanguageErrorStructure::~Method_SetMeterLanguageErrorStructure() {
}

inline Method_SetMeterLanguageErrorStructure& Method_SetMeterLanguageErrorStructure::operator = (const Method_SetMeterLanguageErrorStructure& rhs) {
    if( this != &rhs ) {
        if (rhs.hasError()) {
            setError(rhs.getError());
        } else {
            clearError();
        }
    }
    return *this;
}

inline bool Method_SetMeterLanguageErrorStructure::operator == (const Method_SetMeterLanguageErrorStructure& rhs) const {
    return (((!hasError() && !rhs.hasError()) || getError() == rhs.getError()));
}

inline bool Method_SetMeterLanguageErrorStructure::operator != (const Method_SetMeterLanguageErrorStructure& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetMeterLanguageErrorStructure::operator < (const Method_SetMeterLanguageErrorStructure& rhs) const {
    if (hasError() || rhs.hasError()) {
        if (getError() < rhs.getError()) return true;
        if (getError() > rhs.getError()) return false;
    }
    return false;
}

inline bool Method_SetMeterLanguageErrorStructure::operator > (const Method_SetMeterLanguageErrorStructure& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetMeterLanguageErrorStructure::clear() {
    clearError();
}

inline void Method_SetMeterLanguageErrorStructure::clearError() {
    if (hasError()) {
         clear_has_Error();
        _Error = 0u;
     }
}

inline bool Method_SetMeterLanguageErrorStructure::hasError () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 Method_SetMeterLanguageErrorStructure::getError () const {
    return _Error;
}

inline void Method_SetMeterLanguageErrorStructure::setError (uint16 Error_) {
    set_has_Error();
    this->_Error = Error_;
}

inline void Method_SetMeterLanguageErrorStructure::set_has_Error () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetMeterLanguageErrorStructure::clear_has_Error () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetMeterLanguageError::Method_SetMeterLanguageError () :
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
}

inline  Method_SetMeterLanguageError::Method_SetMeterLanguageError (const Method_SetMeterLanguageError& rhs) :
::asf::core::Payload(rhs),
    __field (E_CCA_ERROR_CODE),
    _data()
{
    _data.ccaErrorCode_ = NULL;
    *this = rhs;
}

inline  Method_SetMeterLanguageError::~Method_SetMeterLanguageError() {
    deleteData ();
}

inline Method_SetMeterLanguageError& Method_SetMeterLanguageError::operator = (const Method_SetMeterLanguageError& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool Method_SetMeterLanguageError::operator == (const Method_SetMeterLanguageError& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_CCA_ERROR_CODE:
            if (_data.ccaErrorCode_ == NULL && rhs._data.ccaErrorCode_ == NULL) {
                return true;
            }
            return (getCcaErrorCode() == rhs.getCcaErrorCode());
        case E_SYSTEM_ERROR_CODE:
            return (getSystemErrorCode() == rhs.getSystemErrorCode());
        default:
            return false;
        }
    }
    return false;
}

inline bool Method_SetMeterLanguageError::operator != (const Method_SetMeterLanguageError& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetMeterLanguageError::operator < (const Method_SetMeterLanguageError& rhs) const  {
    if (hasCcaErrorCode() && rhs.hasCcaErrorCode()) {
        if (getCcaErrorCode() < rhs.getCcaErrorCode()) return true;
        if (getCcaErrorCode() > rhs.getCcaErrorCode()) return false;
    } else {
        if (hasCcaErrorCode() && !rhs.hasCcaErrorCode())
            return true;
        else if (!hasCcaErrorCode() && rhs.hasCcaErrorCode())
            return false;
    }

    if (hasSystemErrorCode() && rhs.hasSystemErrorCode()) {
        if ((uint32)getSystemErrorCode() < (uint32)rhs.getSystemErrorCode()) return true;
        if ((uint32)getSystemErrorCode() > (uint32)rhs.getSystemErrorCode()) return false;
    } else {
        if (hasSystemErrorCode() && !rhs.hasSystemErrorCode())
            return true;
        else if (!hasSystemErrorCode() && rhs.hasSystemErrorCode())
            return false;
    }

    return false;
}

inline bool Method_SetMeterLanguageError::operator > (const Method_SetMeterLanguageError& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline Method_SetMeterLanguageError::Method_SetMeterLanguageErrorField Method_SetMeterLanguageError::getField () const {
    return __field;
}

inline void Method_SetMeterLanguageError::setField(Method_SetMeterLanguageError::Method_SetMeterLanguageErrorField field) {
    deleteData();
    __field = field;
    switch (__field) {
    case E_CCA_ERROR_CODE:
        _data.ccaErrorCode_ = NULL;
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = ::asf::cca::CcaTypes::SystemErrorCode__ServiceNotAvailable;
        break;
    default:
        break;
    }
}

inline ::asf::core::Payload* Method_SetMeterLanguageError::clone() {
    return new Method_SetMeterLanguageError(*this);
}

inline bool Method_SetMeterLanguageError::hasCcaErrorCode () const {
    return __field == E_CCA_ERROR_CODE;
}

inline const Method_SetMeterLanguageErrorStructure& Method_SetMeterLanguageError::getCcaErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_SetMeterLanguageError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            return Method_SetMeterLanguageErrorStructure::getDefaultInstance();
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_SetMeterLanguageErrorStructure& Method_SetMeterLanguageError::getCcaErrorCodeMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasCcaErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "ccaErrorCode", "Method_SetMeterLanguageError", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_SetMeterLanguageErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        return *_data.ccaErrorCode_;
    }
    abort();
}

inline Method_SetMeterLanguageErrorStructure* Method_SetMeterLanguageError::releaseCcaErrorCode() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasCcaErrorCode(), "Can't release value for field 'Method_SetMeterLanguageError', have field %d", getField());
    }
    if (hasCcaErrorCode()) {
        if (_data.ccaErrorCode_ == NULL) {
            _data.ccaErrorCode_ = new Method_SetMeterLanguageErrorStructure();
            CHECK_ALLOCATION( _data.ccaErrorCode_ );
        }
        Method_SetMeterLanguageErrorStructure* temp = _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        return temp;
    }
    return 0;
}

inline void Method_SetMeterLanguageError::replaceCcaErrorCode (Method_SetMeterLanguageErrorStructure* ccaErrorCode) {
    if (__field != E_CCA_ERROR_CODE || _data.ccaErrorCode_ != ccaErrorCode) {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = ccaErrorCode;
    }
}

inline void Method_SetMeterLanguageError::setCcaErrorCode (const Method_SetMeterLanguageErrorStructure& value) {
    if (__field == E_CCA_ERROR_CODE && _data.ccaErrorCode_ != NULL) {
        *_data.ccaErrorCode_ = value;
    } else {
        deleteData ();
        __field = E_CCA_ERROR_CODE;
        _data.ccaErrorCode_ = new Method_SetMeterLanguageErrorStructure(value);
    }
}

inline bool Method_SetMeterLanguageError::hasSystemErrorCode () const {
    return __field == E_SYSTEM_ERROR_CODE;
}

inline ::asf::cca::CcaTypes::SystemErrorCode Method_SetMeterLanguageError::getSystemErrorCode() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasSystemErrorCode(), "Can't provide value for union field '%s' of union '%s', have field %d", "systemErrorCode", "Method_SetMeterLanguageError", getField());
    }
    return (::asf::cca::CcaTypes::SystemErrorCode) _data.systemErrorCode_;
}

inline void Method_SetMeterLanguageError::setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value) {
    #ifndef NDEBUG
    if (!(::asf::cca::CcaTypes::SystemErrorCode_IsValid(value))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", value, "SystemErrorCode", "systemErrorCode", "Method_SetMeterLanguageError");
    }
    #endif
    if (__field != E_SYSTEM_ERROR_CODE) {
        deleteData ();
        __field = E_SYSTEM_ERROR_CODE;
    }
    _data.systemErrorCode_ = (int32)value;
}

inline void Method_SetMeterLanguageError::cloneData (const Method_SetMeterLanguageError& rhs) {
    switch (rhs.__field) {
    case E_CCA_ERROR_CODE:
        if (__field == E_CCA_ERROR_CODE) {
            if (rhs._data.ccaErrorCode_ == NULL)
                deleteData ();
            else {
                if (_data.ccaErrorCode_ != NULL) {
                    *_data.ccaErrorCode_ =  *rhs._data.ccaErrorCode_;
                } else {
                    _data.ccaErrorCode_ = new Method_SetMeterLanguageErrorStructure(*rhs._data.ccaErrorCode_);
                }
            }
        } else {
            if (_data.ccaErrorCode_ != 0) deleteData ();
            if (rhs._data.ccaErrorCode_ != NULL) {
                _data.ccaErrorCode_ = new Method_SetMeterLanguageErrorStructure(*rhs._data.ccaErrorCode_);
            }
        }
        break;
    case E_SYSTEM_ERROR_CODE:
        _data.systemErrorCode_ = rhs._data.systemErrorCode_;
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void Method_SetMeterLanguageError::deleteData () {
    switch (__field) {
    case E_CCA_ERROR_CODE:
        delete _data.ccaErrorCode_;
        _data.ccaErrorCode_ = NULL;
        break;
    default:
        break;
    }
}

inline  Method_SetAudioSourceInfoStart::Method_SetAudioSourceInfoStart ()  :
    _bCausedByUser (false),
    _SourceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetAudioSourceInfoStart::Method_SetAudioSourceInfoStart (const Method_SetAudioSourceInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bCausedByUser (false),
    _SourceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetAudioSourceInfoStart::Method_SetAudioSourceInfoStart (bool bCausedByUser_, const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_)  :
    _bCausedByUser (bCausedByUser_),
    _SourceInfo (SourceInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetAudioSourceInfoStart::~Method_SetAudioSourceInfoStart() {
}

inline Method_SetAudioSourceInfoStart& Method_SetAudioSourceInfoStart::operator = (const Method_SetAudioSourceInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBCausedByUser()) {
            setBCausedByUser(rhs.getBCausedByUser());
        } else {
            clearBCausedByUser();
        }
        if (rhs.hasSourceInfo()) {
            setSourceInfo(rhs.getSourceInfo());
        } else {
            clearSourceInfo();
        }
    }
    return *this;
}

inline bool Method_SetAudioSourceInfoStart::operator == (const Method_SetAudioSourceInfoStart& rhs) const {
    return (((!hasBCausedByUser() && !rhs.hasBCausedByUser()) || getBCausedByUser() == rhs.getBCausedByUser()) &&
        ((!hasSourceInfo() && !rhs.hasSourceInfo()) || getSourceInfo() == rhs.getSourceInfo()));
}

inline bool Method_SetAudioSourceInfoStart::operator != (const Method_SetAudioSourceInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetAudioSourceInfoStart::operator < (const Method_SetAudioSourceInfoStart& rhs) const {
    if (hasBCausedByUser() || rhs.hasBCausedByUser()) {
        if (getBCausedByUser() < rhs.getBCausedByUser()) return true;
        if (getBCausedByUser() > rhs.getBCausedByUser()) return false;
    }
    if (hasSourceInfo() || rhs.hasSourceInfo()) {
        if (getSourceInfo() < rhs.getSourceInfo()) return true;
        if (getSourceInfo() > rhs.getSourceInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetAudioSourceInfoStart::clone() {
    return new Method_SetAudioSourceInfoStart(*this);
}

inline bool Method_SetAudioSourceInfoStart::operator > (const Method_SetAudioSourceInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetAudioSourceInfoStart::clear() {
    clearBCausedByUser();
    clearSourceInfo();
}

inline void Method_SetAudioSourceInfoStart::clearBCausedByUser() {
    if (hasBCausedByUser()) {
         clear_has_bCausedByUser();
        _bCausedByUser = false;
     }
}

inline bool Method_SetAudioSourceInfoStart::hasBCausedByUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Method_SetAudioSourceInfoStart::getBCausedByUser () const {
    return _bCausedByUser;
}

inline void Method_SetAudioSourceInfoStart::setBCausedByUser (bool bCausedByUser_) {
    set_has_bCausedByUser();
    this->_bCausedByUser = bCausedByUser_;
}

inline void Method_SetAudioSourceInfoStart::clearSourceInfo() {
    if (hasSourceInfo()) {
         clear_has_SourceInfo();
        _SourceInfo = ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion ();
     }
}

inline bool Method_SetAudioSourceInfoStart::hasSourceInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& Method_SetAudioSourceInfoStart::getSourceInfo () const {
    return _SourceInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& Method_SetAudioSourceInfoStart::getSourceInfoMutable () {
    set_has_SourceInfo();
    return _SourceInfo;
}

inline void Method_SetAudioSourceInfoStart::setSourceInfo (const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_) {
    set_has_SourceInfo();
    this->_SourceInfo = SourceInfo_;
}

inline void Method_SetAudioSourceInfoStart::set_has_bCausedByUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetAudioSourceInfoStart::clear_has_bCausedByUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Method_SetAudioSourceInfoStart::set_has_SourceInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void Method_SetAudioSourceInfoStart::clear_has_SourceInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Method_SetAudioWarningStart::Method_SetAudioWarningStart ()  :
    _bCausedByUser (false),
    _e8WarningSource (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source__None),
    _e8WarningState (::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState__None),
    _strWarningText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetAudioWarningStart::Method_SetAudioWarningStart (const Method_SetAudioWarningStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bCausedByUser (false),
    _e8WarningSource (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source__None),
    _e8WarningState (::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState__None),
    _strWarningText ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetAudioWarningStart::Method_SetAudioWarningStart (bool bCausedByUser_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8WarningSource_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState e8WarningState_, const ::std::string& strWarningText_)  :
    _bCausedByUser (bCausedByUser_),
    _e8WarningSource (e8WarningSource_),
    _e8WarningState (e8WarningState_),
    _strWarningText (strWarningText_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_Source_IsValid(e8WarningSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8WarningSource_, "T_e8_datacollector_Audio_Source", "e8WarningSource", "Method_SetAudioWarningStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState_IsValid(e8WarningState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8WarningState_, "T_e8_datacollector_Audio_WarningState", "e8WarningState", "Method_SetAudioWarningStart");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strWarningText_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetAudioWarningStart::~Method_SetAudioWarningStart() {
}

inline Method_SetAudioWarningStart& Method_SetAudioWarningStart::operator = (const Method_SetAudioWarningStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBCausedByUser()) {
            setBCausedByUser(rhs.getBCausedByUser());
        } else {
            clearBCausedByUser();
        }
        if (rhs.hasE8WarningSource()) {
            setE8WarningSource(rhs.getE8WarningSource());
        } else {
            clearE8WarningSource();
        }
        if (rhs.hasE8WarningState()) {
            setE8WarningState(rhs.getE8WarningState());
        } else {
            clearE8WarningState();
        }
        if (rhs.hasStrWarningText()) {
            setStrWarningText(rhs.getStrWarningText());
        } else {
            clearStrWarningText();
        }
    }
    return *this;
}

inline bool Method_SetAudioWarningStart::operator == (const Method_SetAudioWarningStart& rhs) const {
    return (((!hasBCausedByUser() && !rhs.hasBCausedByUser()) || getBCausedByUser() == rhs.getBCausedByUser()) &&
        ((!hasE8WarningSource() && !rhs.hasE8WarningSource()) || getE8WarningSource() == rhs.getE8WarningSource()) &&
        ((!hasE8WarningState() && !rhs.hasE8WarningState()) || getE8WarningState() == rhs.getE8WarningState()) &&
        ((!hasStrWarningText() && !rhs.hasStrWarningText()) || getStrWarningText() == rhs.getStrWarningText()));
}

inline bool Method_SetAudioWarningStart::operator != (const Method_SetAudioWarningStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetAudioWarningStart::operator < (const Method_SetAudioWarningStart& rhs) const {
    if (hasBCausedByUser() || rhs.hasBCausedByUser()) {
        if (getBCausedByUser() < rhs.getBCausedByUser()) return true;
        if (getBCausedByUser() > rhs.getBCausedByUser()) return false;
    }
    if (hasE8WarningSource() || rhs.hasE8WarningSource()) {
        if ((uint32)getE8WarningSource() < (uint32)rhs.getE8WarningSource()) return true;
        if ((uint32)getE8WarningSource() > (uint32)rhs.getE8WarningSource()) return false;
    }
    if (hasE8WarningState() || rhs.hasE8WarningState()) {
        if ((uint32)getE8WarningState() < (uint32)rhs.getE8WarningState()) return true;
        if ((uint32)getE8WarningState() > (uint32)rhs.getE8WarningState()) return false;
    }
    if (hasStrWarningText() || rhs.hasStrWarningText()) {
        if (getStrWarningText() < rhs.getStrWarningText()) return true;
        if (getStrWarningText() > rhs.getStrWarningText()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetAudioWarningStart::clone() {
    return new Method_SetAudioWarningStart(*this);
}

inline bool Method_SetAudioWarningStart::operator > (const Method_SetAudioWarningStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetAudioWarningStart::clear() {
    clearBCausedByUser();
    clearE8WarningSource();
    clearE8WarningState();
    clearStrWarningText();
}

inline void Method_SetAudioWarningStart::clearBCausedByUser() {
    if (hasBCausedByUser()) {
         clear_has_bCausedByUser();
        _bCausedByUser = false;
     }
}

inline bool Method_SetAudioWarningStart::hasBCausedByUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Method_SetAudioWarningStart::getBCausedByUser () const {
    return _bCausedByUser;
}

inline void Method_SetAudioWarningStart::setBCausedByUser (bool bCausedByUser_) {
    set_has_bCausedByUser();
    this->_bCausedByUser = bCausedByUser_;
}

inline void Method_SetAudioWarningStart::clearE8WarningSource() {
    if (hasE8WarningSource()) {
         clear_has_e8WarningSource();
        _e8WarningSource = ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source__None;
     }
}

inline bool Method_SetAudioWarningStart::hasE8WarningSource () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source Method_SetAudioWarningStart::getE8WarningSource () const {
    return _e8WarningSource;
}

inline void Method_SetAudioWarningStart::setE8WarningSource (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8WarningSource_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_Source_IsValid(e8WarningSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8WarningSource_, "T_e8_datacollector_Audio_Source", "e8WarningSource", "Method_SetAudioWarningStart");
    }
    #endif
    set_has_e8WarningSource();
    this->_e8WarningSource = e8WarningSource_;
}

inline void Method_SetAudioWarningStart::clearE8WarningState() {
    if (hasE8WarningState()) {
         clear_has_e8WarningState();
        _e8WarningState = ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState__None;
     }
}

inline bool Method_SetAudioWarningStart::hasE8WarningState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState Method_SetAudioWarningStart::getE8WarningState () const {
    return _e8WarningState;
}

inline void Method_SetAudioWarningStart::setE8WarningState (::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState e8WarningState_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_WarningState_IsValid(e8WarningState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8WarningState_, "T_e8_datacollector_Audio_WarningState", "e8WarningState", "Method_SetAudioWarningStart");
    }
    #endif
    set_has_e8WarningState();
    this->_e8WarningState = e8WarningState_;
}

inline void Method_SetAudioWarningStart::clearStrWarningText() {
    if (hasStrWarningText()) {
         clear_has_strWarningText();
        _strWarningText.clear();
     }
}

inline bool Method_SetAudioWarningStart::hasStrWarningText () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& Method_SetAudioWarningStart::getStrWarningText () const {
    return _strWarningText;
}

inline ::std::string& Method_SetAudioWarningStart::getStrWarningTextMutable () {
    set_has_strWarningText();
    return _strWarningText;
}

inline void Method_SetAudioWarningStart::setStrWarningText (const ::std::string& strWarningText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strWarningText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strWarningText();
    this->_strWarningText = strWarningText_;
}

inline void Method_SetAudioWarningStart::setStrWarningText (const char* strWarningText_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strWarningText_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strWarningText();
    this->_strWarningText.assign(strWarningText_);
}

inline void Method_SetAudioWarningStart::setStrWarningText (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strWarningText();
    this->_strWarningText.assign(value, size);
}

inline void Method_SetAudioWarningStart::set_has_bCausedByUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetAudioWarningStart::clear_has_bCausedByUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Method_SetAudioWarningStart::set_has_e8WarningSource () {
    _has_bits_[0] |= 1u << 1;
}

inline void Method_SetAudioWarningStart::clear_has_e8WarningSource () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Method_SetAudioWarningStart::set_has_e8WarningState () {
    _has_bits_[0] |= 1u << 2;
}

inline void Method_SetAudioWarningStart::clear_has_e8WarningState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Method_SetAudioWarningStart::set_has_strWarningText () {
    _has_bits_[0] |= 1u << 3;
}

inline void Method_SetAudioWarningStart::clear_has_strWarningText () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  Method_SetAudioSpecialModeStart::Method_SetAudioSpecialModeStart ()  :
    _e8SpecialMode (::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode__None)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetAudioSpecialModeStart::Method_SetAudioSpecialModeStart (const Method_SetAudioSpecialModeStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8SpecialMode (::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode__None)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetAudioSpecialModeStart::Method_SetAudioSpecialModeStart (::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode e8SpecialMode_)  :
    _e8SpecialMode (e8SpecialMode_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode_IsValid(e8SpecialMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SpecialMode_, "T_e8_datacollector_Audio_SpecialMode", "e8SpecialMode", "Method_SetAudioSpecialModeStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetAudioSpecialModeStart::~Method_SetAudioSpecialModeStart() {
}

inline Method_SetAudioSpecialModeStart& Method_SetAudioSpecialModeStart::operator = (const Method_SetAudioSpecialModeStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8SpecialMode()) {
            setE8SpecialMode(rhs.getE8SpecialMode());
        } else {
            clearE8SpecialMode();
        }
    }
    return *this;
}

inline bool Method_SetAudioSpecialModeStart::operator == (const Method_SetAudioSpecialModeStart& rhs) const {
    return (((!hasE8SpecialMode() && !rhs.hasE8SpecialMode()) || getE8SpecialMode() == rhs.getE8SpecialMode()));
}

inline bool Method_SetAudioSpecialModeStart::operator != (const Method_SetAudioSpecialModeStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetAudioSpecialModeStart::operator < (const Method_SetAudioSpecialModeStart& rhs) const {
    if (hasE8SpecialMode() || rhs.hasE8SpecialMode()) {
        if ((uint32)getE8SpecialMode() < (uint32)rhs.getE8SpecialMode()) return true;
        if ((uint32)getE8SpecialMode() > (uint32)rhs.getE8SpecialMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetAudioSpecialModeStart::clone() {
    return new Method_SetAudioSpecialModeStart(*this);
}

inline bool Method_SetAudioSpecialModeStart::operator > (const Method_SetAudioSpecialModeStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetAudioSpecialModeStart::clear() {
    clearE8SpecialMode();
}

inline void Method_SetAudioSpecialModeStart::clearE8SpecialMode() {
    if (hasE8SpecialMode()) {
         clear_has_e8SpecialMode();
        _e8SpecialMode = ::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode__None;
     }
}

inline bool Method_SetAudioSpecialModeStart::hasE8SpecialMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode Method_SetAudioSpecialModeStart::getE8SpecialMode () const {
    return _e8SpecialMode;
}

inline void Method_SetAudioSpecialModeStart::setE8SpecialMode (::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode e8SpecialMode_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_SpecialMode_IsValid(e8SpecialMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8SpecialMode_, "T_e8_datacollector_Audio_SpecialMode", "e8SpecialMode", "Method_SetAudioSpecialModeStart");
    }
    #endif
    set_has_e8SpecialMode();
    this->_e8SpecialMode = e8SpecialMode_;
}

inline void Method_SetAudioSpecialModeStart::set_has_e8SpecialMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetAudioSpecialModeStart::clear_has_e8SpecialMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_SetMediaBrowserList_HighlightedElementStart::Method_SetMediaBrowserList_HighlightedElementStart ()  :
    _ElementName (),
    _ElementType (::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType__Undefined),
    _InputDevice (::datacollector_main_fi_types::T_e8_datacollector_InputDevice__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_SetMediaBrowserList_HighlightedElementStart::Method_SetMediaBrowserList_HighlightedElementStart (const Method_SetMediaBrowserList_HighlightedElementStart &rhs)  :
    ::asf::core::Payload(rhs),
    _ElementName (),
    _ElementType (::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType__Undefined),
    _InputDevice (::datacollector_main_fi_types::T_e8_datacollector_InputDevice__Undefined)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_SetMediaBrowserList_HighlightedElementStart::Method_SetMediaBrowserList_HighlightedElementStart (const ::std::string& ElementName_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType ElementType_, ::datacollector_main_fi_types::T_e8_datacollector_InputDevice InputDevice_)  :
    _ElementName (ElementName_),
    _ElementType (ElementType_),
    _InputDevice (InputDevice_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ElementName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType_IsValid(ElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ElementType_, "T_e8_datacollector_Audio_MediaElementType", "ElementType", "Method_SetMediaBrowserList_HighlightedElementStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_InputDevice_IsValid(InputDevice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", InputDevice_, "T_e8_datacollector_InputDevice", "InputDevice", "Method_SetMediaBrowserList_HighlightedElementStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_SetMediaBrowserList_HighlightedElementStart::~Method_SetMediaBrowserList_HighlightedElementStart() {
}

inline Method_SetMediaBrowserList_HighlightedElementStart& Method_SetMediaBrowserList_HighlightedElementStart::operator = (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasElementName()) {
            setElementName(rhs.getElementName());
        } else {
            clearElementName();
        }
        if (rhs.hasElementType()) {
            setElementType(rhs.getElementType());
        } else {
            clearElementType();
        }
        if (rhs.hasInputDevice()) {
            setInputDevice(rhs.getInputDevice());
        } else {
            clearInputDevice();
        }
    }
    return *this;
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::operator == (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const {
    return (((!hasElementName() && !rhs.hasElementName()) || getElementName() == rhs.getElementName()) &&
        ((!hasElementType() && !rhs.hasElementType()) || getElementType() == rhs.getElementType()) &&
        ((!hasInputDevice() && !rhs.hasInputDevice()) || getInputDevice() == rhs.getInputDevice()));
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::operator != (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::operator < (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const {
    if (hasElementName() || rhs.hasElementName()) {
        if (getElementName() < rhs.getElementName()) return true;
        if (getElementName() > rhs.getElementName()) return false;
    }
    if (hasElementType() || rhs.hasElementType()) {
        if ((uint32)getElementType() < (uint32)rhs.getElementType()) return true;
        if ((uint32)getElementType() > (uint32)rhs.getElementType()) return false;
    }
    if (hasInputDevice() || rhs.hasInputDevice()) {
        if ((uint32)getInputDevice() < (uint32)rhs.getInputDevice()) return true;
        if ((uint32)getInputDevice() > (uint32)rhs.getInputDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_SetMediaBrowserList_HighlightedElementStart::clone() {
    return new Method_SetMediaBrowserList_HighlightedElementStart(*this);
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::operator > (const Method_SetMediaBrowserList_HighlightedElementStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clear() {
    clearElementName();
    clearElementType();
    clearInputDevice();
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clearElementName() {
    if (hasElementName()) {
         clear_has_ElementName();
        _ElementName.clear();
     }
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::hasElementName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& Method_SetMediaBrowserList_HighlightedElementStart::getElementName () const {
    return _ElementName;
}

inline ::std::string& Method_SetMediaBrowserList_HighlightedElementStart::getElementNameMutable () {
    set_has_ElementName();
    return _ElementName;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::setElementName (const ::std::string& ElementName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ElementName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ElementName();
    this->_ElementName = ElementName_;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::setElementName (const char* ElementName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (ElementName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ElementName();
    this->_ElementName.assign(ElementName_);
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::setElementName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_ElementName();
    this->_ElementName.assign(value, size);
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clearElementType() {
    if (hasElementType()) {
         clear_has_ElementType();
        _ElementType = ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType__Undefined;
     }
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::hasElementType () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType Method_SetMediaBrowserList_HighlightedElementStart::getElementType () const {
    return _ElementType;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::setElementType (::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType ElementType_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaElementType_IsValid(ElementType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", ElementType_, "T_e8_datacollector_Audio_MediaElementType", "ElementType", "Method_SetMediaBrowserList_HighlightedElementStart");
    }
    #endif
    set_has_ElementType();
    this->_ElementType = ElementType_;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clearInputDevice() {
    if (hasInputDevice()) {
         clear_has_InputDevice();
        _InputDevice = ::datacollector_main_fi_types::T_e8_datacollector_InputDevice__Undefined;
     }
}

inline bool Method_SetMediaBrowserList_HighlightedElementStart::hasInputDevice () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_InputDevice Method_SetMediaBrowserList_HighlightedElementStart::getInputDevice () const {
    return _InputDevice;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::setInputDevice (::datacollector_main_fi_types::T_e8_datacollector_InputDevice InputDevice_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_InputDevice_IsValid(InputDevice_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", InputDevice_, "T_e8_datacollector_InputDevice", "InputDevice", "Method_SetMediaBrowserList_HighlightedElementStart");
    }
    #endif
    set_has_InputDevice();
    this->_InputDevice = InputDevice_;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::set_has_ElementName () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clear_has_ElementName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::set_has_ElementType () {
    _has_bits_[0] |= 1u << 1;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clear_has_ElementType () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::set_has_InputDevice () {
    _has_bits_[0] |= 1u << 2;
}

inline void Method_SetMediaBrowserList_HighlightedElementStart::clear_has_InputDevice () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  Method_CurrentHeadUnitTunerModeStart::Method_CurrentHeadUnitTunerModeStart ()  :
    _e8CurrentHeadUnitTunerMode (::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode__List)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_CurrentHeadUnitTunerModeStart::Method_CurrentHeadUnitTunerModeStart (const Method_CurrentHeadUnitTunerModeStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8CurrentHeadUnitTunerMode (::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode__List)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_CurrentHeadUnitTunerModeStart::Method_CurrentHeadUnitTunerModeStart (::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode e8CurrentHeadUnitTunerMode_)  :
    _e8CurrentHeadUnitTunerMode (e8CurrentHeadUnitTunerMode_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode_IsValid(e8CurrentHeadUnitTunerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CurrentHeadUnitTunerMode_, "T_e8_datacollector_Current_Radio_Mode", "e8CurrentHeadUnitTunerMode", "Method_CurrentHeadUnitTunerModeStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_CurrentHeadUnitTunerModeStart::~Method_CurrentHeadUnitTunerModeStart() {
}

inline Method_CurrentHeadUnitTunerModeStart& Method_CurrentHeadUnitTunerModeStart::operator = (const Method_CurrentHeadUnitTunerModeStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8CurrentHeadUnitTunerMode()) {
            setE8CurrentHeadUnitTunerMode(rhs.getE8CurrentHeadUnitTunerMode());
        } else {
            clearE8CurrentHeadUnitTunerMode();
        }
    }
    return *this;
}

inline bool Method_CurrentHeadUnitTunerModeStart::operator == (const Method_CurrentHeadUnitTunerModeStart& rhs) const {
    return (((!hasE8CurrentHeadUnitTunerMode() && !rhs.hasE8CurrentHeadUnitTunerMode()) || getE8CurrentHeadUnitTunerMode() == rhs.getE8CurrentHeadUnitTunerMode()));
}

inline bool Method_CurrentHeadUnitTunerModeStart::operator != (const Method_CurrentHeadUnitTunerModeStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_CurrentHeadUnitTunerModeStart::operator < (const Method_CurrentHeadUnitTunerModeStart& rhs) const {
    if (hasE8CurrentHeadUnitTunerMode() || rhs.hasE8CurrentHeadUnitTunerMode()) {
        if ((uint32)getE8CurrentHeadUnitTunerMode() < (uint32)rhs.getE8CurrentHeadUnitTunerMode()) return true;
        if ((uint32)getE8CurrentHeadUnitTunerMode() > (uint32)rhs.getE8CurrentHeadUnitTunerMode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_CurrentHeadUnitTunerModeStart::clone() {
    return new Method_CurrentHeadUnitTunerModeStart(*this);
}

inline bool Method_CurrentHeadUnitTunerModeStart::operator > (const Method_CurrentHeadUnitTunerModeStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_CurrentHeadUnitTunerModeStart::clear() {
    clearE8CurrentHeadUnitTunerMode();
}

inline void Method_CurrentHeadUnitTunerModeStart::clearE8CurrentHeadUnitTunerMode() {
    if (hasE8CurrentHeadUnitTunerMode()) {
         clear_has_e8CurrentHeadUnitTunerMode();
        _e8CurrentHeadUnitTunerMode = ::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode__List;
     }
}

inline bool Method_CurrentHeadUnitTunerModeStart::hasE8CurrentHeadUnitTunerMode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode Method_CurrentHeadUnitTunerModeStart::getE8CurrentHeadUnitTunerMode () const {
    return _e8CurrentHeadUnitTunerMode;
}

inline void Method_CurrentHeadUnitTunerModeStart::setE8CurrentHeadUnitTunerMode (::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode e8CurrentHeadUnitTunerMode_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Current_Radio_Mode_IsValid(e8CurrentHeadUnitTunerMode_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8CurrentHeadUnitTunerMode_, "T_e8_datacollector_Current_Radio_Mode", "e8CurrentHeadUnitTunerMode", "Method_CurrentHeadUnitTunerModeStart");
    }
    #endif
    set_has_e8CurrentHeadUnitTunerMode();
    this->_e8CurrentHeadUnitTunerMode = e8CurrentHeadUnitTunerMode_;
}

inline void Method_CurrentHeadUnitTunerModeStart::set_has_e8CurrentHeadUnitTunerMode () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_CurrentHeadUnitTunerModeStart::clear_has_e8CurrentHeadUnitTunerMode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Method_RenaultUpdateListStatusStart::Method_RenaultUpdateListStatusStart ()  :
    _e8RenaultUpdateListStatus (::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value__Updating_NotActive)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Method_RenaultUpdateListStatusStart::Method_RenaultUpdateListStatusStart (const Method_RenaultUpdateListStatusStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8RenaultUpdateListStatus (::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value__Updating_NotActive)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Method_RenaultUpdateListStatusStart::Method_RenaultUpdateListStatusStart (::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value e8RenaultUpdateListStatus_)  :
    _e8RenaultUpdateListStatus (e8RenaultUpdateListStatus_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value_IsValid(e8RenaultUpdateListStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RenaultUpdateListStatus_, "T_e8_datacollector_Renault_Update_List_Value", "e8RenaultUpdateListStatus", "Method_RenaultUpdateListStatusStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Method_RenaultUpdateListStatusStart::~Method_RenaultUpdateListStatusStart() {
}

inline Method_RenaultUpdateListStatusStart& Method_RenaultUpdateListStatusStart::operator = (const Method_RenaultUpdateListStatusStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8RenaultUpdateListStatus()) {
            setE8RenaultUpdateListStatus(rhs.getE8RenaultUpdateListStatus());
        } else {
            clearE8RenaultUpdateListStatus();
        }
    }
    return *this;
}

inline bool Method_RenaultUpdateListStatusStart::operator == (const Method_RenaultUpdateListStatusStart& rhs) const {
    return (((!hasE8RenaultUpdateListStatus() && !rhs.hasE8RenaultUpdateListStatus()) || getE8RenaultUpdateListStatus() == rhs.getE8RenaultUpdateListStatus()));
}

inline bool Method_RenaultUpdateListStatusStart::operator != (const Method_RenaultUpdateListStatusStart& rhs) const {
    return ! (*this == rhs);
}

inline bool Method_RenaultUpdateListStatusStart::operator < (const Method_RenaultUpdateListStatusStart& rhs) const {
    if (hasE8RenaultUpdateListStatus() || rhs.hasE8RenaultUpdateListStatus()) {
        if ((uint32)getE8RenaultUpdateListStatus() < (uint32)rhs.getE8RenaultUpdateListStatus()) return true;
        if ((uint32)getE8RenaultUpdateListStatus() > (uint32)rhs.getE8RenaultUpdateListStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Method_RenaultUpdateListStatusStart::clone() {
    return new Method_RenaultUpdateListStatusStart(*this);
}

inline bool Method_RenaultUpdateListStatusStart::operator > (const Method_RenaultUpdateListStatusStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Method_RenaultUpdateListStatusStart::clear() {
    clearE8RenaultUpdateListStatus();
}

inline void Method_RenaultUpdateListStatusStart::clearE8RenaultUpdateListStatus() {
    if (hasE8RenaultUpdateListStatus()) {
         clear_has_e8RenaultUpdateListStatus();
        _e8RenaultUpdateListStatus = ::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value__Updating_NotActive;
     }
}

inline bool Method_RenaultUpdateListStatusStart::hasE8RenaultUpdateListStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value Method_RenaultUpdateListStatusStart::getE8RenaultUpdateListStatus () const {
    return _e8RenaultUpdateListStatus;
}

inline void Method_RenaultUpdateListStatusStart::setE8RenaultUpdateListStatus (::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value e8RenaultUpdateListStatus_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Renault_Update_List_Value_IsValid(e8RenaultUpdateListStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RenaultUpdateListStatus_, "T_e8_datacollector_Renault_Update_List_Value", "e8RenaultUpdateListStatus", "Method_RenaultUpdateListStatusStart");
    }
    #endif
    set_has_e8RenaultUpdateListStatus();
    this->_e8RenaultUpdateListStatus = e8RenaultUpdateListStatus_;
}

inline void Method_RenaultUpdateListStatusStart::set_has_e8RenaultUpdateListStatus () {
    _has_bits_[0] |= 1u << 0;
}

inline void Method_RenaultUpdateListStatusStart::clear_has_e8RenaultUpdateListStatus () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_SetAudioSourceInfoStatus::Property_SetAudioSourceInfoStatus ()  :
    _bCausedByUser (false),
    _SourceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_SetAudioSourceInfoStatus::Property_SetAudioSourceInfoStatus (const Property_SetAudioSourceInfoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bCausedByUser (false),
    _SourceInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_SetAudioSourceInfoStatus::Property_SetAudioSourceInfoStatus (bool bCausedByUser_, const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_)  :
    _bCausedByUser (bCausedByUser_),
    _SourceInfo (SourceInfo_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_SetAudioSourceInfoStatus::~Property_SetAudioSourceInfoStatus() {
}

inline Property_SetAudioSourceInfoStatus& Property_SetAudioSourceInfoStatus::operator = (const Property_SetAudioSourceInfoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBCausedByUser()) {
            setBCausedByUser(rhs.getBCausedByUser());
        } else {
            clearBCausedByUser();
        }
        if (rhs.hasSourceInfo()) {
            setSourceInfo(rhs.getSourceInfo());
        } else {
            clearSourceInfo();
        }
    }
    return *this;
}

inline bool Property_SetAudioSourceInfoStatus::operator == (const Property_SetAudioSourceInfoStatus& rhs) const {
    return (((!hasBCausedByUser() && !rhs.hasBCausedByUser()) || getBCausedByUser() == rhs.getBCausedByUser()) &&
        ((!hasSourceInfo() && !rhs.hasSourceInfo()) || getSourceInfo() == rhs.getSourceInfo()));
}

inline bool Property_SetAudioSourceInfoStatus::operator != (const Property_SetAudioSourceInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_SetAudioSourceInfoStatus::operator < (const Property_SetAudioSourceInfoStatus& rhs) const {
    if (hasBCausedByUser() || rhs.hasBCausedByUser()) {
        if (getBCausedByUser() < rhs.getBCausedByUser()) return true;
        if (getBCausedByUser() > rhs.getBCausedByUser()) return false;
    }
    if (hasSourceInfo() || rhs.hasSourceInfo()) {
        if (getSourceInfo() < rhs.getSourceInfo()) return true;
        if (getSourceInfo() > rhs.getSourceInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_SetAudioSourceInfoStatus::clone() {
    return new Property_SetAudioSourceInfoStatus(*this);
}

inline bool Property_SetAudioSourceInfoStatus::operator > (const Property_SetAudioSourceInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_SetAudioSourceInfoStatus::clear() {
    clearBCausedByUser();
    clearSourceInfo();
}

inline void Property_SetAudioSourceInfoStatus::clearBCausedByUser() {
    if (hasBCausedByUser()) {
         clear_has_bCausedByUser();
        _bCausedByUser = false;
     }
}

inline bool Property_SetAudioSourceInfoStatus::hasBCausedByUser () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Property_SetAudioSourceInfoStatus::getBCausedByUser () const {
    return _bCausedByUser;
}

inline void Property_SetAudioSourceInfoStatus::setBCausedByUser (bool bCausedByUser_) {
    set_has_bCausedByUser();
    this->_bCausedByUser = bCausedByUser_;
}

inline void Property_SetAudioSourceInfoStatus::clearSourceInfo() {
    if (hasSourceInfo()) {
         clear_has_SourceInfo();
        _SourceInfo = ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion ();
     }
}

inline bool Property_SetAudioSourceInfoStatus::hasSourceInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& Property_SetAudioSourceInfoStatus::getSourceInfo () const {
    return _SourceInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& Property_SetAudioSourceInfoStatus::getSourceInfoMutable () {
    set_has_SourceInfo();
    return _SourceInfo;
}

inline void Property_SetAudioSourceInfoStatus::setSourceInfo (const ::datacollector_main_fi_types::T_datacollector_Audio_SourceInfoUnion& SourceInfo_) {
    set_has_SourceInfo();
    this->_SourceInfo = SourceInfo_;
}

inline void Property_SetAudioSourceInfoStatus::set_has_bCausedByUser () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_SetAudioSourceInfoStatus::clear_has_bCausedByUser () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Property_SetAudioSourceInfoStatus::set_has_SourceInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void Property_SetAudioSourceInfoStatus::clear_has_SourceInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Property_SetNaviSwipeStatus::Property_SetNaviSwipeStatus ()  :
    _bSwipeBeep (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_SetNaviSwipeStatus::Property_SetNaviSwipeStatus (const Property_SetNaviSwipeStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _bSwipeBeep (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_SetNaviSwipeStatus::Property_SetNaviSwipeStatus (bool bSwipeBeep_)  :
    _bSwipeBeep (bSwipeBeep_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_SetNaviSwipeStatus::~Property_SetNaviSwipeStatus() {
}

inline Property_SetNaviSwipeStatus& Property_SetNaviSwipeStatus::operator = (const Property_SetNaviSwipeStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBSwipeBeep()) {
            setBSwipeBeep(rhs.getBSwipeBeep());
        } else {
            clearBSwipeBeep();
        }
    }
    return *this;
}

inline bool Property_SetNaviSwipeStatus::operator == (const Property_SetNaviSwipeStatus& rhs) const {
    return (((!hasBSwipeBeep() && !rhs.hasBSwipeBeep()) || getBSwipeBeep() == rhs.getBSwipeBeep()));
}

inline bool Property_SetNaviSwipeStatus::operator != (const Property_SetNaviSwipeStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_SetNaviSwipeStatus::operator < (const Property_SetNaviSwipeStatus& rhs) const {
    if (hasBSwipeBeep() || rhs.hasBSwipeBeep()) {
        if (getBSwipeBeep() < rhs.getBSwipeBeep()) return true;
        if (getBSwipeBeep() > rhs.getBSwipeBeep()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_SetNaviSwipeStatus::clone() {
    return new Property_SetNaviSwipeStatus(*this);
}

inline bool Property_SetNaviSwipeStatus::operator > (const Property_SetNaviSwipeStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_SetNaviSwipeStatus::clear() {
    clearBSwipeBeep();
}

inline void Property_SetNaviSwipeStatus::clearBSwipeBeep() {
    if (hasBSwipeBeep()) {
         clear_has_bSwipeBeep();
        _bSwipeBeep = false;
     }
}

inline bool Property_SetNaviSwipeStatus::hasBSwipeBeep () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool Property_SetNaviSwipeStatus::getBSwipeBeep () const {
    return _bSwipeBeep;
}

inline void Property_SetNaviSwipeStatus::setBSwipeBeep (bool bSwipeBeep_) {
    set_has_bSwipeBeep();
    this->_bSwipeBeep = bSwipeBeep_;
}

inline void Property_SetNaviSwipeStatus::set_has_bSwipeBeep () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_SetNaviSwipeStatus::clear_has_bSwipeBeep () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPhoneIncomingCallInfoStart::SetPhoneIncomingCallInfoStart ()  :
    _bIncoming (false),
    _strCallerInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPhoneIncomingCallInfoStart::SetPhoneIncomingCallInfoStart (const SetPhoneIncomingCallInfoStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bIncoming (false),
    _strCallerInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPhoneIncomingCallInfoStart::SetPhoneIncomingCallInfoStart (bool bIncoming_, const ::std::string& strCallerInfo_)  :
    _bIncoming (bIncoming_),
    _strCallerInfo (strCallerInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCallerInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPhoneIncomingCallInfoStart::~SetPhoneIncomingCallInfoStart() {
}

inline SetPhoneIncomingCallInfoStart& SetPhoneIncomingCallInfoStart::operator = (const SetPhoneIncomingCallInfoStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBIncoming()) {
            setBIncoming(rhs.getBIncoming());
        } else {
            clearBIncoming();
        }
        if (rhs.hasStrCallerInfo()) {
            setStrCallerInfo(rhs.getStrCallerInfo());
        } else {
            clearStrCallerInfo();
        }
    }
    return *this;
}

inline bool SetPhoneIncomingCallInfoStart::operator == (const SetPhoneIncomingCallInfoStart& rhs) const {
    return (((!hasBIncoming() && !rhs.hasBIncoming()) || getBIncoming() == rhs.getBIncoming()) &&
        ((!hasStrCallerInfo() && !rhs.hasStrCallerInfo()) || getStrCallerInfo() == rhs.getStrCallerInfo()));
}

inline bool SetPhoneIncomingCallInfoStart::operator != (const SetPhoneIncomingCallInfoStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPhoneIncomingCallInfoStart::operator < (const SetPhoneIncomingCallInfoStart& rhs) const {
    if (hasBIncoming() || rhs.hasBIncoming()) {
        if (getBIncoming() < rhs.getBIncoming()) return true;
        if (getBIncoming() > rhs.getBIncoming()) return false;
    }
    if (hasStrCallerInfo() || rhs.hasStrCallerInfo()) {
        if (getStrCallerInfo() < rhs.getStrCallerInfo()) return true;
        if (getStrCallerInfo() > rhs.getStrCallerInfo()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPhoneIncomingCallInfoStart::clone() {
    return new SetPhoneIncomingCallInfoStart(*this);
}

inline bool SetPhoneIncomingCallInfoStart::operator > (const SetPhoneIncomingCallInfoStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPhoneIncomingCallInfoStart::clear() {
    clearBIncoming();
    clearStrCallerInfo();
}

inline void SetPhoneIncomingCallInfoStart::clearBIncoming() {
    if (hasBIncoming()) {
         clear_has_bIncoming();
        _bIncoming = false;
     }
}

inline bool SetPhoneIncomingCallInfoStart::hasBIncoming () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetPhoneIncomingCallInfoStart::getBIncoming () const {
    return _bIncoming;
}

inline void SetPhoneIncomingCallInfoStart::setBIncoming (bool bIncoming_) {
    set_has_bIncoming();
    this->_bIncoming = bIncoming_;
}

inline void SetPhoneIncomingCallInfoStart::clearStrCallerInfo() {
    if (hasStrCallerInfo()) {
         clear_has_strCallerInfo();
        _strCallerInfo.clear();
     }
}

inline bool SetPhoneIncomingCallInfoStart::hasStrCallerInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SetPhoneIncomingCallInfoStart::getStrCallerInfo () const {
    return _strCallerInfo;
}

inline ::std::string& SetPhoneIncomingCallInfoStart::getStrCallerInfoMutable () {
    set_has_strCallerInfo();
    return _strCallerInfo;
}

inline void SetPhoneIncomingCallInfoStart::setStrCallerInfo (const ::std::string& strCallerInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCallerInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCallerInfo();
    this->_strCallerInfo = strCallerInfo_;
}

inline void SetPhoneIncomingCallInfoStart::setStrCallerInfo (const char* strCallerInfo_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCallerInfo_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCallerInfo();
    this->_strCallerInfo.assign(strCallerInfo_);
}

inline void SetPhoneIncomingCallInfoStart::setStrCallerInfo (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCallerInfo();
    this->_strCallerInfo.assign(value, size);
}

inline void SetPhoneIncomingCallInfoStart::set_has_bIncoming () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPhoneIncomingCallInfoStart::clear_has_bIncoming () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPhoneIncomingCallInfoStart::set_has_strCallerInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPhoneIncomingCallInfoStart::clear_has_strCallerInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  Property_SmsSendStatusStatus::Property_SmsSendStatusStatus ()  :
    _eSmsSendState (::datacollector_main_fi_types::T_e8_datacollector_SmsSendState__NotInSending)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_SmsSendStatusStatus::Property_SmsSendStatusStatus (const Property_SmsSendStatusStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _eSmsSendState (::datacollector_main_fi_types::T_e8_datacollector_SmsSendState__NotInSending)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_SmsSendStatusStatus::Property_SmsSendStatusStatus (::datacollector_main_fi_types::T_e8_datacollector_SmsSendState eSmsSendState_)  :
    _eSmsSendState (eSmsSendState_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_SmsSendState_IsValid(eSmsSendState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSmsSendState_, "T_e8_datacollector_SmsSendState", "eSmsSendState", "Property_SmsSendStatusStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_SmsSendStatusStatus::~Property_SmsSendStatusStatus() {
}

inline Property_SmsSendStatusStatus& Property_SmsSendStatusStatus::operator = (const Property_SmsSendStatusStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasESmsSendState()) {
            setESmsSendState(rhs.getESmsSendState());
        } else {
            clearESmsSendState();
        }
    }
    return *this;
}

inline bool Property_SmsSendStatusStatus::operator == (const Property_SmsSendStatusStatus& rhs) const {
    return (((!hasESmsSendState() && !rhs.hasESmsSendState()) || getESmsSendState() == rhs.getESmsSendState()));
}

inline bool Property_SmsSendStatusStatus::operator != (const Property_SmsSendStatusStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_SmsSendStatusStatus::operator < (const Property_SmsSendStatusStatus& rhs) const {
    if (hasESmsSendState() || rhs.hasESmsSendState()) {
        if ((uint32)getESmsSendState() < (uint32)rhs.getESmsSendState()) return true;
        if ((uint32)getESmsSendState() > (uint32)rhs.getESmsSendState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_SmsSendStatusStatus::clone() {
    return new Property_SmsSendStatusStatus(*this);
}

inline bool Property_SmsSendStatusStatus::operator > (const Property_SmsSendStatusStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_SmsSendStatusStatus::clear() {
    clearESmsSendState();
}

inline void Property_SmsSendStatusStatus::clearESmsSendState() {
    if (hasESmsSendState()) {
         clear_has_eSmsSendState();
        _eSmsSendState = ::datacollector_main_fi_types::T_e8_datacollector_SmsSendState__NotInSending;
     }
}

inline bool Property_SmsSendStatusStatus::hasESmsSendState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_SmsSendState Property_SmsSendStatusStatus::getESmsSendState () const {
    return _eSmsSendState;
}

inline void Property_SmsSendStatusStatus::setESmsSendState (::datacollector_main_fi_types::T_e8_datacollector_SmsSendState eSmsSendState_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_SmsSendState_IsValid(eSmsSendState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", eSmsSendState_, "T_e8_datacollector_SmsSendState", "eSmsSendState", "Property_SmsSendStatusStatus");
    }
    #endif
    set_has_eSmsSendState();
    this->_eSmsSendState = eSmsSendState_;
}

inline void Property_SmsSendStatusStatus::set_has_eSmsSendState () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_SmsSendStatusStatus::clear_has_eSmsSendState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPhoneWaitingModeSettingStart::SetPhoneWaitingModeSettingStart ()  :
    _bIsAutomatic (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPhoneWaitingModeSettingStart::SetPhoneWaitingModeSettingStart (const SetPhoneWaitingModeSettingStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bIsAutomatic (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPhoneWaitingModeSettingStart::SetPhoneWaitingModeSettingStart (bool bIsAutomatic_)  :
    _bIsAutomatic (bIsAutomatic_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPhoneWaitingModeSettingStart::~SetPhoneWaitingModeSettingStart() {
}

inline SetPhoneWaitingModeSettingStart& SetPhoneWaitingModeSettingStart::operator = (const SetPhoneWaitingModeSettingStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBIsAutomatic()) {
            setBIsAutomatic(rhs.getBIsAutomatic());
        } else {
            clearBIsAutomatic();
        }
    }
    return *this;
}

inline bool SetPhoneWaitingModeSettingStart::operator == (const SetPhoneWaitingModeSettingStart& rhs) const {
    return (((!hasBIsAutomatic() && !rhs.hasBIsAutomatic()) || getBIsAutomatic() == rhs.getBIsAutomatic()));
}

inline bool SetPhoneWaitingModeSettingStart::operator != (const SetPhoneWaitingModeSettingStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPhoneWaitingModeSettingStart::operator < (const SetPhoneWaitingModeSettingStart& rhs) const {
    if (hasBIsAutomatic() || rhs.hasBIsAutomatic()) {
        if (getBIsAutomatic() < rhs.getBIsAutomatic()) return true;
        if (getBIsAutomatic() > rhs.getBIsAutomatic()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPhoneWaitingModeSettingStart::clone() {
    return new SetPhoneWaitingModeSettingStart(*this);
}

inline bool SetPhoneWaitingModeSettingStart::operator > (const SetPhoneWaitingModeSettingStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPhoneWaitingModeSettingStart::clear() {
    clearBIsAutomatic();
}

inline void SetPhoneWaitingModeSettingStart::clearBIsAutomatic() {
    if (hasBIsAutomatic()) {
         clear_has_bIsAutomatic();
        _bIsAutomatic = false;
     }
}

inline bool SetPhoneWaitingModeSettingStart::hasBIsAutomatic () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetPhoneWaitingModeSettingStart::getBIsAutomatic () const {
    return _bIsAutomatic;
}

inline void SetPhoneWaitingModeSettingStart::setBIsAutomatic (bool bIsAutomatic_) {
    set_has_bIsAutomatic();
    this->_bIsAutomatic = bIsAutomatic_;
}

inline void SetPhoneWaitingModeSettingStart::set_has_bIsAutomatic () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPhoneWaitingModeSettingStart::clear_has_bIsAutomatic () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPhonePrivateModeSettingsStart::SetPhonePrivateModeSettingsStart ()  :
    _bIsPrivateModeOn (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPhonePrivateModeSettingsStart::SetPhonePrivateModeSettingsStart (const SetPhonePrivateModeSettingsStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bIsPrivateModeOn (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPhonePrivateModeSettingsStart::SetPhonePrivateModeSettingsStart (bool bIsPrivateModeOn_)  :
    _bIsPrivateModeOn (bIsPrivateModeOn_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPhonePrivateModeSettingsStart::~SetPhonePrivateModeSettingsStart() {
}

inline SetPhonePrivateModeSettingsStart& SetPhonePrivateModeSettingsStart::operator = (const SetPhonePrivateModeSettingsStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBIsPrivateModeOn()) {
            setBIsPrivateModeOn(rhs.getBIsPrivateModeOn());
        } else {
            clearBIsPrivateModeOn();
        }
    }
    return *this;
}

inline bool SetPhonePrivateModeSettingsStart::operator == (const SetPhonePrivateModeSettingsStart& rhs) const {
    return (((!hasBIsPrivateModeOn() && !rhs.hasBIsPrivateModeOn()) || getBIsPrivateModeOn() == rhs.getBIsPrivateModeOn()));
}

inline bool SetPhonePrivateModeSettingsStart::operator != (const SetPhonePrivateModeSettingsStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPhonePrivateModeSettingsStart::operator < (const SetPhonePrivateModeSettingsStart& rhs) const {
    if (hasBIsPrivateModeOn() || rhs.hasBIsPrivateModeOn()) {
        if (getBIsPrivateModeOn() < rhs.getBIsPrivateModeOn()) return true;
        if (getBIsPrivateModeOn() > rhs.getBIsPrivateModeOn()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPhonePrivateModeSettingsStart::clone() {
    return new SetPhonePrivateModeSettingsStart(*this);
}

inline bool SetPhonePrivateModeSettingsStart::operator > (const SetPhonePrivateModeSettingsStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPhonePrivateModeSettingsStart::clear() {
    clearBIsPrivateModeOn();
}

inline void SetPhonePrivateModeSettingsStart::clearBIsPrivateModeOn() {
    if (hasBIsPrivateModeOn()) {
         clear_has_bIsPrivateModeOn();
        _bIsPrivateModeOn = false;
     }
}

inline bool SetPhonePrivateModeSettingsStart::hasBIsPrivateModeOn () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetPhonePrivateModeSettingsStart::getBIsPrivateModeOn () const {
    return _bIsPrivateModeOn;
}

inline void SetPhonePrivateModeSettingsStart::setBIsPrivateModeOn (bool bIsPrivateModeOn_) {
    set_has_bIsPrivateModeOn();
    this->_bIsPrivateModeOn = bIsPrivateModeOn_;
}

inline void SetPhonePrivateModeSettingsStart::set_has_bIsPrivateModeOn () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPhonePrivateModeSettingsStart::clear_has_bIsPrivateModeOn () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetIsWaitmodeSupportedByPhoneStart::SetIsWaitmodeSupportedByPhoneStart ()  :
    _bIsWaitModeSupported (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetIsWaitmodeSupportedByPhoneStart::SetIsWaitmodeSupportedByPhoneStart (const SetIsWaitmodeSupportedByPhoneStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bIsWaitModeSupported (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetIsWaitmodeSupportedByPhoneStart::SetIsWaitmodeSupportedByPhoneStart (bool bIsWaitModeSupported_)  :
    _bIsWaitModeSupported (bIsWaitModeSupported_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetIsWaitmodeSupportedByPhoneStart::~SetIsWaitmodeSupportedByPhoneStart() {
}

inline SetIsWaitmodeSupportedByPhoneStart& SetIsWaitmodeSupportedByPhoneStart::operator = (const SetIsWaitmodeSupportedByPhoneStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBIsWaitModeSupported()) {
            setBIsWaitModeSupported(rhs.getBIsWaitModeSupported());
        } else {
            clearBIsWaitModeSupported();
        }
    }
    return *this;
}

inline bool SetIsWaitmodeSupportedByPhoneStart::operator == (const SetIsWaitmodeSupportedByPhoneStart& rhs) const {
    return (((!hasBIsWaitModeSupported() && !rhs.hasBIsWaitModeSupported()) || getBIsWaitModeSupported() == rhs.getBIsWaitModeSupported()));
}

inline bool SetIsWaitmodeSupportedByPhoneStart::operator != (const SetIsWaitmodeSupportedByPhoneStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetIsWaitmodeSupportedByPhoneStart::operator < (const SetIsWaitmodeSupportedByPhoneStart& rhs) const {
    if (hasBIsWaitModeSupported() || rhs.hasBIsWaitModeSupported()) {
        if (getBIsWaitModeSupported() < rhs.getBIsWaitModeSupported()) return true;
        if (getBIsWaitModeSupported() > rhs.getBIsWaitModeSupported()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetIsWaitmodeSupportedByPhoneStart::clone() {
    return new SetIsWaitmodeSupportedByPhoneStart(*this);
}

inline bool SetIsWaitmodeSupportedByPhoneStart::operator > (const SetIsWaitmodeSupportedByPhoneStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetIsWaitmodeSupportedByPhoneStart::clear() {
    clearBIsWaitModeSupported();
}

inline void SetIsWaitmodeSupportedByPhoneStart::clearBIsWaitModeSupported() {
    if (hasBIsWaitModeSupported()) {
         clear_has_bIsWaitModeSupported();
        _bIsWaitModeSupported = false;
     }
}

inline bool SetIsWaitmodeSupportedByPhoneStart::hasBIsWaitModeSupported () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetIsWaitmodeSupportedByPhoneStart::getBIsWaitModeSupported () const {
    return _bIsWaitModeSupported;
}

inline void SetIsWaitmodeSupportedByPhoneStart::setBIsWaitModeSupported (bool bIsWaitModeSupported_) {
    set_has_bIsWaitModeSupported();
    this->_bIsWaitModeSupported = bIsWaitModeSupported_;
}

inline void SetIsWaitmodeSupportedByPhoneStart::set_has_bIsWaitModeSupported () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetIsWaitmodeSupportedByPhoneStart::clear_has_bIsWaitModeSupported () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetVoiceRecognitionStatusStart::SetVoiceRecognitionStatusStart ()  :
    _e8VRState (::datacollector_main_fi_types::T_e8_datacollector_VR_State__Idle)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetVoiceRecognitionStatusStart::SetVoiceRecognitionStatusStart (const SetVoiceRecognitionStatusStart &rhs)  :
    ::asf::core::Payload(rhs),
    _e8VRState (::datacollector_main_fi_types::T_e8_datacollector_VR_State__Idle)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetVoiceRecognitionStatusStart::SetVoiceRecognitionStatusStart (::datacollector_main_fi_types::T_e8_datacollector_VR_State e8VRState_)  :
    _e8VRState (e8VRState_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_VR_State_IsValid(e8VRState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VRState_, "T_e8_datacollector_VR_State", "e8VRState", "SetVoiceRecognitionStatusStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetVoiceRecognitionStatusStart::~SetVoiceRecognitionStatusStart() {
}

inline SetVoiceRecognitionStatusStart& SetVoiceRecognitionStatusStart::operator = (const SetVoiceRecognitionStatusStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasE8VRState()) {
            setE8VRState(rhs.getE8VRState());
        } else {
            clearE8VRState();
        }
    }
    return *this;
}

inline bool SetVoiceRecognitionStatusStart::operator == (const SetVoiceRecognitionStatusStart& rhs) const {
    return (((!hasE8VRState() && !rhs.hasE8VRState()) || getE8VRState() == rhs.getE8VRState()));
}

inline bool SetVoiceRecognitionStatusStart::operator != (const SetVoiceRecognitionStatusStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetVoiceRecognitionStatusStart::operator < (const SetVoiceRecognitionStatusStart& rhs) const {
    if (hasE8VRState() || rhs.hasE8VRState()) {
        if ((uint32)getE8VRState() < (uint32)rhs.getE8VRState()) return true;
        if ((uint32)getE8VRState() > (uint32)rhs.getE8VRState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetVoiceRecognitionStatusStart::clone() {
    return new SetVoiceRecognitionStatusStart(*this);
}

inline bool SetVoiceRecognitionStatusStart::operator > (const SetVoiceRecognitionStatusStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetVoiceRecognitionStatusStart::clear() {
    clearE8VRState();
}

inline void SetVoiceRecognitionStatusStart::clearE8VRState() {
    if (hasE8VRState()) {
         clear_has_e8VRState();
        _e8VRState = ::datacollector_main_fi_types::T_e8_datacollector_VR_State__Idle;
     }
}

inline bool SetVoiceRecognitionStatusStart::hasE8VRState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_VR_State SetVoiceRecognitionStatusStart::getE8VRState () const {
    return _e8VRState;
}

inline void SetVoiceRecognitionStatusStart::setE8VRState (::datacollector_main_fi_types::T_e8_datacollector_VR_State e8VRState_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_VR_State_IsValid(e8VRState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8VRState_, "T_e8_datacollector_VR_State", "e8VRState", "SetVoiceRecognitionStatusStart");
    }
    #endif
    set_has_e8VRState();
    this->_e8VRState = e8VRState_;
}

inline void SetVoiceRecognitionStatusStart::set_has_e8VRState () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetVoiceRecognitionStatusStart::clear_has_e8VRState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  Property_HMIStatusBarInfoStatus::Property_HMIStatusBarInfoStatus ()  :
    _ClockTimeInfo (),
    _PhoneInfo (),
    _TAInfo (0u),
    _SMSInfo (),
    _TCUStatus (false),
    _DownloadStatus (),
    _HVACInfo (),
    _AudioInfo (),
    _PhoneBookDownloadState (::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState__NOT_STARTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  Property_HMIStatusBarInfoStatus::Property_HMIStatusBarInfoStatus (const Property_HMIStatusBarInfoStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ClockTimeInfo (),
    _PhoneInfo (),
    _TAInfo (0u),
    _SMSInfo (),
    _TCUStatus (false),
    _DownloadStatus (),
    _HVACInfo (),
    _AudioInfo (),
    _PhoneBookDownloadState (::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState__NOT_STARTED)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  Property_HMIStatusBarInfoStatus::Property_HMIStatusBarInfoStatus (const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& ClockTimeInfo_, const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& PhoneInfo_, uint8 TAInfo_, const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& SMSInfo_, bool TCUStatus_, const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& DownloadStatus_, const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& HVACInfo_, const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& AudioInfo_, ::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState PhoneBookDownloadState_)  :
    _ClockTimeInfo (ClockTimeInfo_),
    _PhoneInfo (PhoneInfo_),
    _TAInfo (TAInfo_),
    _SMSInfo (SMSInfo_),
    _TCUStatus (TCUStatus_),
    _DownloadStatus (DownloadStatus_),
    _HVACInfo (HVACInfo_),
    _AudioInfo (AudioInfo_),
    _PhoneBookDownloadState (PhoneBookDownloadState_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState_IsValid(PhoneBookDownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PhoneBookDownloadState_, "T_e8_datacollector_PhoneBkDownloadState", "PhoneBookDownloadState", "Property_HMIStatusBarInfoStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  Property_HMIStatusBarInfoStatus::~Property_HMIStatusBarInfoStatus() {
}

inline Property_HMIStatusBarInfoStatus& Property_HMIStatusBarInfoStatus::operator = (const Property_HMIStatusBarInfoStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasClockTimeInfo()) {
            setClockTimeInfo(rhs.getClockTimeInfo());
        } else {
            clearClockTimeInfo();
        }
        if (rhs.hasPhoneInfo()) {
            setPhoneInfo(rhs.getPhoneInfo());
        } else {
            clearPhoneInfo();
        }
        if (rhs.hasTAInfo()) {
            setTAInfo(rhs.getTAInfo());
        } else {
            clearTAInfo();
        }
        if (rhs.hasSMSInfo()) {
            setSMSInfo(rhs.getSMSInfo());
        } else {
            clearSMSInfo();
        }
        if (rhs.hasTCUStatus()) {
            setTCUStatus(rhs.getTCUStatus());
        } else {
            clearTCUStatus();
        }
        if (rhs.hasDownloadStatus()) {
            setDownloadStatus(rhs.getDownloadStatus());
        } else {
            clearDownloadStatus();
        }
        if (rhs.hasHVACInfo()) {
            setHVACInfo(rhs.getHVACInfo());
        } else {
            clearHVACInfo();
        }
        if (rhs.hasAudioInfo()) {
            setAudioInfo(rhs.getAudioInfo());
        } else {
            clearAudioInfo();
        }
        if (rhs.hasPhoneBookDownloadState()) {
            setPhoneBookDownloadState(rhs.getPhoneBookDownloadState());
        } else {
            clearPhoneBookDownloadState();
        }
    }
    return *this;
}

inline bool Property_HMIStatusBarInfoStatus::operator == (const Property_HMIStatusBarInfoStatus& rhs) const {
    return (((!hasClockTimeInfo() && !rhs.hasClockTimeInfo()) || getClockTimeInfo() == rhs.getClockTimeInfo()) &&
        ((!hasPhoneInfo() && !rhs.hasPhoneInfo()) || getPhoneInfo() == rhs.getPhoneInfo()) &&
        ((!hasTAInfo() && !rhs.hasTAInfo()) || getTAInfo() == rhs.getTAInfo()) &&
        ((!hasSMSInfo() && !rhs.hasSMSInfo()) || getSMSInfo() == rhs.getSMSInfo()) &&
        ((!hasTCUStatus() && !rhs.hasTCUStatus()) || getTCUStatus() == rhs.getTCUStatus()) &&
        ((!hasDownloadStatus() && !rhs.hasDownloadStatus()) || getDownloadStatus() == rhs.getDownloadStatus()) &&
        ((!hasHVACInfo() && !rhs.hasHVACInfo()) || getHVACInfo() == rhs.getHVACInfo()) &&
        ((!hasAudioInfo() && !rhs.hasAudioInfo()) || getAudioInfo() == rhs.getAudioInfo()) &&
        ((!hasPhoneBookDownloadState() && !rhs.hasPhoneBookDownloadState()) || getPhoneBookDownloadState() == rhs.getPhoneBookDownloadState()));
}

inline bool Property_HMIStatusBarInfoStatus::operator != (const Property_HMIStatusBarInfoStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool Property_HMIStatusBarInfoStatus::operator < (const Property_HMIStatusBarInfoStatus& rhs) const {
    if (hasClockTimeInfo() || rhs.hasClockTimeInfo()) {
        if (getClockTimeInfo() < rhs.getClockTimeInfo()) return true;
        if (getClockTimeInfo() > rhs.getClockTimeInfo()) return false;
    }
    if (hasPhoneInfo() || rhs.hasPhoneInfo()) {
        if (getPhoneInfo() < rhs.getPhoneInfo()) return true;
        if (getPhoneInfo() > rhs.getPhoneInfo()) return false;
    }
    if (hasTAInfo() || rhs.hasTAInfo()) {
        if (getTAInfo() < rhs.getTAInfo()) return true;
        if (getTAInfo() > rhs.getTAInfo()) return false;
    }
    if (hasSMSInfo() || rhs.hasSMSInfo()) {
        if (getSMSInfo() < rhs.getSMSInfo()) return true;
        if (getSMSInfo() > rhs.getSMSInfo()) return false;
    }
    if (hasTCUStatus() || rhs.hasTCUStatus()) {
        if (getTCUStatus() < rhs.getTCUStatus()) return true;
        if (getTCUStatus() > rhs.getTCUStatus()) return false;
    }
    if (hasDownloadStatus() || rhs.hasDownloadStatus()) {
        if (getDownloadStatus() < rhs.getDownloadStatus()) return true;
        if (getDownloadStatus() > rhs.getDownloadStatus()) return false;
    }
    if (hasHVACInfo() || rhs.hasHVACInfo()) {
        if (getHVACInfo() < rhs.getHVACInfo()) return true;
        if (getHVACInfo() > rhs.getHVACInfo()) return false;
    }
    if (hasAudioInfo() || rhs.hasAudioInfo()) {
        if (getAudioInfo() < rhs.getAudioInfo()) return true;
        if (getAudioInfo() > rhs.getAudioInfo()) return false;
    }
    if (hasPhoneBookDownloadState() || rhs.hasPhoneBookDownloadState()) {
        if ((uint32)getPhoneBookDownloadState() < (uint32)rhs.getPhoneBookDownloadState()) return true;
        if ((uint32)getPhoneBookDownloadState() > (uint32)rhs.getPhoneBookDownloadState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* Property_HMIStatusBarInfoStatus::clone() {
    return new Property_HMIStatusBarInfoStatus(*this);
}

inline bool Property_HMIStatusBarInfoStatus::operator > (const Property_HMIStatusBarInfoStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void Property_HMIStatusBarInfoStatus::clear() {
    clearClockTimeInfo();
    clearPhoneInfo();
    clearTAInfo();
    clearSMSInfo();
    clearTCUStatus();
    clearDownloadStatus();
    clearHVACInfo();
    clearAudioInfo();
    clearPhoneBookDownloadState();
}

inline void Property_HMIStatusBarInfoStatus::clearClockTimeInfo() {
    if (hasClockTimeInfo()) {
         clear_has_ClockTimeInfo();
        _ClockTimeInfo.clear();
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasClockTimeInfo () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& Property_HMIStatusBarInfoStatus::getClockTimeInfo () const {
    return _ClockTimeInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& Property_HMIStatusBarInfoStatus::getClockTimeInfoMutable () {
    set_has_ClockTimeInfo();
    return _ClockTimeInfo;
}

inline void Property_HMIStatusBarInfoStatus::setClockTimeInfo (const ::datacollector_main_fi_types::T_datacollector_TimeInfoUnion& ClockTimeInfo_) {
    set_has_ClockTimeInfo();
    this->_ClockTimeInfo = ClockTimeInfo_;
}

inline void Property_HMIStatusBarInfoStatus::clearPhoneInfo() {
    if (hasPhoneInfo()) {
         clear_has_PhoneInfo();
        _PhoneInfo.clear();
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasPhoneInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& Property_HMIStatusBarInfoStatus::getPhoneInfo () const {
    return _PhoneInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& Property_HMIStatusBarInfoStatus::getPhoneInfoMutable () {
    set_has_PhoneInfo();
    return _PhoneInfo;
}

inline void Property_HMIStatusBarInfoStatus::setPhoneInfo (const ::datacollector_main_fi_types::T_datacollector_PhoneInfoUnion& PhoneInfo_) {
    set_has_PhoneInfo();
    this->_PhoneInfo = PhoneInfo_;
}

inline void Property_HMIStatusBarInfoStatus::clearTAInfo() {
    if (hasTAInfo()) {
         clear_has_TAInfo();
        _TAInfo = 0u;
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasTAInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 Property_HMIStatusBarInfoStatus::getTAInfo () const {
    return _TAInfo;
}

inline void Property_HMIStatusBarInfoStatus::setTAInfo (uint8 TAInfo_) {
    set_has_TAInfo();
    this->_TAInfo = TAInfo_;
}

inline void Property_HMIStatusBarInfoStatus::clearSMSInfo() {
    if (hasSMSInfo()) {
         clear_has_SMSInfo();
        _SMSInfo.clear();
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasSMSInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& Property_HMIStatusBarInfoStatus::getSMSInfo () const {
    return _SMSInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& Property_HMIStatusBarInfoStatus::getSMSInfoMutable () {
    set_has_SMSInfo();
    return _SMSInfo;
}

inline void Property_HMIStatusBarInfoStatus::setSMSInfo (const ::datacollector_main_fi_types::T_datacollector_SMSInfoUnion& SMSInfo_) {
    set_has_SMSInfo();
    this->_SMSInfo = SMSInfo_;
}

inline void Property_HMIStatusBarInfoStatus::clearTCUStatus() {
    if (hasTCUStatus()) {
         clear_has_TCUStatus();
        _TCUStatus = false;
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasTCUStatus () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool Property_HMIStatusBarInfoStatus::getTCUStatus () const {
    return _TCUStatus;
}

inline void Property_HMIStatusBarInfoStatus::setTCUStatus (bool TCUStatus_) {
    set_has_TCUStatus();
    this->_TCUStatus = TCUStatus_;
}

inline void Property_HMIStatusBarInfoStatus::clearDownloadStatus() {
    if (hasDownloadStatus()) {
         clear_has_DownloadStatus();
        _DownloadStatus.clear();
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasDownloadStatus () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& Property_HMIStatusBarInfoStatus::getDownloadStatus () const {
    return _DownloadStatus;
}

inline ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& Property_HMIStatusBarInfoStatus::getDownloadStatusMutable () {
    set_has_DownloadStatus();
    return _DownloadStatus;
}

inline void Property_HMIStatusBarInfoStatus::setDownloadStatus (const ::datacollector_main_fi_types::T_datacollector_DownloadInfoUnion& DownloadStatus_) {
    set_has_DownloadStatus();
    this->_DownloadStatus = DownloadStatus_;
}

inline void Property_HMIStatusBarInfoStatus::clearHVACInfo() {
    if (hasHVACInfo()) {
         clear_has_HVACInfo();
        _HVACInfo.clear();
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasHVACInfo () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& Property_HMIStatusBarInfoStatus::getHVACInfo () const {
    return _HVACInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& Property_HMIStatusBarInfoStatus::getHVACInfoMutable () {
    set_has_HVACInfo();
    return _HVACInfo;
}

inline void Property_HMIStatusBarInfoStatus::setHVACInfo (const ::datacollector_main_fi_types::T_datacollector_HVACInfoUnion& HVACInfo_) {
    set_has_HVACInfo();
    this->_HVACInfo = HVACInfo_;
}

inline void Property_HMIStatusBarInfoStatus::clearAudioInfo() {
    if (hasAudioInfo()) {
         clear_has_AudioInfo();
        _AudioInfo.clear();
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasAudioInfo () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& Property_HMIStatusBarInfoStatus::getAudioInfo () const {
    return _AudioInfo;
}

inline ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& Property_HMIStatusBarInfoStatus::getAudioInfoMutable () {
    set_has_AudioInfo();
    return _AudioInfo;
}

inline void Property_HMIStatusBarInfoStatus::setAudioInfo (const ::datacollector_main_fi_types::T_datacollector_AudioInfoUnion& AudioInfo_) {
    set_has_AudioInfo();
    this->_AudioInfo = AudioInfo_;
}

inline void Property_HMIStatusBarInfoStatus::clearPhoneBookDownloadState() {
    if (hasPhoneBookDownloadState()) {
         clear_has_PhoneBookDownloadState();
        _PhoneBookDownloadState = ::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState__NOT_STARTED;
     }
}

inline bool Property_HMIStatusBarInfoStatus::hasPhoneBookDownloadState () const {
    return (_has_bits_[0] & (1u << 8)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState Property_HMIStatusBarInfoStatus::getPhoneBookDownloadState () const {
    return _PhoneBookDownloadState;
}

inline void Property_HMIStatusBarInfoStatus::setPhoneBookDownloadState (::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState PhoneBookDownloadState_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_PhoneBkDownloadState_IsValid(PhoneBookDownloadState_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", PhoneBookDownloadState_, "T_e8_datacollector_PhoneBkDownloadState", "PhoneBookDownloadState", "Property_HMIStatusBarInfoStatus");
    }
    #endif
    set_has_PhoneBookDownloadState();
    this->_PhoneBookDownloadState = PhoneBookDownloadState_;
}

inline void Property_HMIStatusBarInfoStatus::set_has_ClockTimeInfo () {
    _has_bits_[0] |= 1u << 0;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_ClockTimeInfo () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void Property_HMIStatusBarInfoStatus::set_has_PhoneInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_PhoneInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void Property_HMIStatusBarInfoStatus::set_has_TAInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_TAInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void Property_HMIStatusBarInfoStatus::set_has_SMSInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_SMSInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void Property_HMIStatusBarInfoStatus::set_has_TCUStatus () {
    _has_bits_[0] |= 1u << 4;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_TCUStatus () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void Property_HMIStatusBarInfoStatus::set_has_DownloadStatus () {
    _has_bits_[0] |= 1u << 5;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_DownloadStatus () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void Property_HMIStatusBarInfoStatus::set_has_HVACInfo () {
    _has_bits_[0] |= 1u << 6;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_HVACInfo () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void Property_HMIStatusBarInfoStatus::set_has_AudioInfo () {
    _has_bits_[0] |= 1u << 7;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_AudioInfo () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline void Property_HMIStatusBarInfoStatus::set_has_PhoneBookDownloadState () {
    _has_bits_[0] |= 1u << 8;
}

inline void Property_HMIStatusBarInfoStatus::clear_has_PhoneBookDownloadState () {
    _has_bits_[0] &= ~ (1u << 8);
}

inline  SetInterrupt_to_MeterStart::SetInterrupt_to_MeterStart ()  :
    _bCausedBy_SWC_UserAction (false),
    _e8Interrupt_Source (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source__None),
    _e8Interrupt_Type (::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type__Seek_Start)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetInterrupt_to_MeterStart::SetInterrupt_to_MeterStart (const SetInterrupt_to_MeterStart &rhs)  :
    ::asf::core::Payload(rhs),
    _bCausedBy_SWC_UserAction (false),
    _e8Interrupt_Source (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source__None),
    _e8Interrupt_Type (::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type__Seek_Start)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetInterrupt_to_MeterStart::SetInterrupt_to_MeterStart (bool bCausedBy_SWC_UserAction_, ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8Interrupt_Source_, ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type e8Interrupt_Type_)  :
    _bCausedBy_SWC_UserAction (bCausedBy_SWC_UserAction_),
    _e8Interrupt_Source (e8Interrupt_Source_),
    _e8Interrupt_Type (e8Interrupt_Type_)
{
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_Source_IsValid(e8Interrupt_Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Interrupt_Source_, "T_e8_datacollector_Audio_Source", "e8Interrupt_Source", "SetInterrupt_to_MeterStart");
    }
    #endif
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type_IsValid(e8Interrupt_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Interrupt_Type_, "T_e8_datacollector_Interrupt_Type", "e8Interrupt_Type", "SetInterrupt_to_MeterStart");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetInterrupt_to_MeterStart::~SetInterrupt_to_MeterStart() {
}

inline SetInterrupt_to_MeterStart& SetInterrupt_to_MeterStart::operator = (const SetInterrupt_to_MeterStart& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasBCausedBy_SWC_UserAction()) {
            setBCausedBy_SWC_UserAction(rhs.getBCausedBy_SWC_UserAction());
        } else {
            clearBCausedBy_SWC_UserAction();
        }
        if (rhs.hasE8Interrupt_Source()) {
            setE8Interrupt_Source(rhs.getE8Interrupt_Source());
        } else {
            clearE8Interrupt_Source();
        }
        if (rhs.hasE8Interrupt_Type()) {
            setE8Interrupt_Type(rhs.getE8Interrupt_Type());
        } else {
            clearE8Interrupt_Type();
        }
    }
    return *this;
}

inline bool SetInterrupt_to_MeterStart::operator == (const SetInterrupt_to_MeterStart& rhs) const {
    return (((!hasBCausedBy_SWC_UserAction() && !rhs.hasBCausedBy_SWC_UserAction()) || getBCausedBy_SWC_UserAction() == rhs.getBCausedBy_SWC_UserAction()) &&
        ((!hasE8Interrupt_Source() && !rhs.hasE8Interrupt_Source()) || getE8Interrupt_Source() == rhs.getE8Interrupt_Source()) &&
        ((!hasE8Interrupt_Type() && !rhs.hasE8Interrupt_Type()) || getE8Interrupt_Type() == rhs.getE8Interrupt_Type()));
}

inline bool SetInterrupt_to_MeterStart::operator != (const SetInterrupt_to_MeterStart& rhs) const {
    return ! (*this == rhs);
}

inline bool SetInterrupt_to_MeterStart::operator < (const SetInterrupt_to_MeterStart& rhs) const {
    if (hasBCausedBy_SWC_UserAction() || rhs.hasBCausedBy_SWC_UserAction()) {
        if (getBCausedBy_SWC_UserAction() < rhs.getBCausedBy_SWC_UserAction()) return true;
        if (getBCausedBy_SWC_UserAction() > rhs.getBCausedBy_SWC_UserAction()) return false;
    }
    if (hasE8Interrupt_Source() || rhs.hasE8Interrupt_Source()) {
        if ((uint32)getE8Interrupt_Source() < (uint32)rhs.getE8Interrupt_Source()) return true;
        if ((uint32)getE8Interrupt_Source() > (uint32)rhs.getE8Interrupt_Source()) return false;
    }
    if (hasE8Interrupt_Type() || rhs.hasE8Interrupt_Type()) {
        if ((uint32)getE8Interrupt_Type() < (uint32)rhs.getE8Interrupt_Type()) return true;
        if ((uint32)getE8Interrupt_Type() > (uint32)rhs.getE8Interrupt_Type()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetInterrupt_to_MeterStart::clone() {
    return new SetInterrupt_to_MeterStart(*this);
}

inline bool SetInterrupt_to_MeterStart::operator > (const SetInterrupt_to_MeterStart& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetInterrupt_to_MeterStart::clear() {
    clearBCausedBy_SWC_UserAction();
    clearE8Interrupt_Source();
    clearE8Interrupt_Type();
}

inline void SetInterrupt_to_MeterStart::clearBCausedBy_SWC_UserAction() {
    if (hasBCausedBy_SWC_UserAction()) {
         clear_has_bCausedBy_SWC_UserAction();
        _bCausedBy_SWC_UserAction = false;
     }
}

inline bool SetInterrupt_to_MeterStart::hasBCausedBy_SWC_UserAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SetInterrupt_to_MeterStart::getBCausedBy_SWC_UserAction () const {
    return _bCausedBy_SWC_UserAction;
}

inline void SetInterrupt_to_MeterStart::setBCausedBy_SWC_UserAction (bool bCausedBy_SWC_UserAction_) {
    set_has_bCausedBy_SWC_UserAction();
    this->_bCausedBy_SWC_UserAction = bCausedBy_SWC_UserAction_;
}

inline void SetInterrupt_to_MeterStart::clearE8Interrupt_Source() {
    if (hasE8Interrupt_Source()) {
         clear_has_e8Interrupt_Source();
        _e8Interrupt_Source = ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source__None;
     }
}

inline bool SetInterrupt_to_MeterStart::hasE8Interrupt_Source () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Audio_Source SetInterrupt_to_MeterStart::getE8Interrupt_Source () const {
    return _e8Interrupt_Source;
}

inline void SetInterrupt_to_MeterStart::setE8Interrupt_Source (::datacollector_main_fi_types::T_e8_datacollector_Audio_Source e8Interrupt_Source_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Audio_Source_IsValid(e8Interrupt_Source_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Interrupt_Source_, "T_e8_datacollector_Audio_Source", "e8Interrupt_Source", "SetInterrupt_to_MeterStart");
    }
    #endif
    set_has_e8Interrupt_Source();
    this->_e8Interrupt_Source = e8Interrupt_Source_;
}

inline void SetInterrupt_to_MeterStart::clearE8Interrupt_Type() {
    if (hasE8Interrupt_Type()) {
         clear_has_e8Interrupt_Type();
        _e8Interrupt_Type = ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type__Seek_Start;
     }
}

inline bool SetInterrupt_to_MeterStart::hasE8Interrupt_Type () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline ::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type SetInterrupt_to_MeterStart::getE8Interrupt_Type () const {
    return _e8Interrupt_Type;
}

inline void SetInterrupt_to_MeterStart::setE8Interrupt_Type (::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type e8Interrupt_Type_) {
    #ifndef NDEBUG
    if (!(::datacollector_main_fi_types::T_e8_datacollector_Interrupt_Type_IsValid(e8Interrupt_Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Interrupt_Type_, "T_e8_datacollector_Interrupt_Type", "e8Interrupt_Type", "SetInterrupt_to_MeterStart");
    }
    #endif
    set_has_e8Interrupt_Type();
    this->_e8Interrupt_Type = e8Interrupt_Type_;
}

inline void SetInterrupt_to_MeterStart::set_has_bCausedBy_SWC_UserAction () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetInterrupt_to_MeterStart::clear_has_bCausedBy_SWC_UserAction () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetInterrupt_to_MeterStart::set_has_e8Interrupt_Source () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetInterrupt_to_MeterStart::clear_has_e8Interrupt_Source () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SetInterrupt_to_MeterStart::set_has_e8Interrupt_Type () {
    _has_bits_[0] |= 1u << 2;
}

inline void SetInterrupt_to_MeterStart::clear_has_e8Interrupt_Type () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  SMSSettingsStatus::SMSSettingsStatus ()  :
    _ReplayFeatureAvailability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SMSSettingsStatus::SMSSettingsStatus (const SMSSettingsStatus &rhs)  :
    ::asf::core::Payload(rhs),
    _ReplayFeatureAvailability (false)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SMSSettingsStatus::SMSSettingsStatus (bool ReplayFeatureAvailability_)  :
    _ReplayFeatureAvailability (ReplayFeatureAvailability_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SMSSettingsStatus::~SMSSettingsStatus() {
}

inline SMSSettingsStatus& SMSSettingsStatus::operator = (const SMSSettingsStatus& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasReplayFeatureAvailability()) {
            setReplayFeatureAvailability(rhs.getReplayFeatureAvailability());
        } else {
            clearReplayFeatureAvailability();
        }
    }
    return *this;
}

inline bool SMSSettingsStatus::operator == (const SMSSettingsStatus& rhs) const {
    return (((!hasReplayFeatureAvailability() && !rhs.hasReplayFeatureAvailability()) || getReplayFeatureAvailability() == rhs.getReplayFeatureAvailability()));
}

inline bool SMSSettingsStatus::operator != (const SMSSettingsStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool SMSSettingsStatus::operator < (const SMSSettingsStatus& rhs) const {
    if (hasReplayFeatureAvailability() || rhs.hasReplayFeatureAvailability()) {
        if (getReplayFeatureAvailability() < rhs.getReplayFeatureAvailability()) return true;
        if (getReplayFeatureAvailability() > rhs.getReplayFeatureAvailability()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SMSSettingsStatus::clone() {
    return new SMSSettingsStatus(*this);
}

inline bool SMSSettingsStatus::operator > (const SMSSettingsStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SMSSettingsStatus::clear() {
    clearReplayFeatureAvailability();
}

inline void SMSSettingsStatus::clearReplayFeatureAvailability() {
    if (hasReplayFeatureAvailability()) {
         clear_has_ReplayFeatureAvailability();
        _ReplayFeatureAvailability = false;
     }
}

inline bool SMSSettingsStatus::hasReplayFeatureAvailability () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool SMSSettingsStatus::getReplayFeatureAvailability () const {
    return _ReplayFeatureAvailability;
}

inline void SMSSettingsStatus::setReplayFeatureAvailability (bool ReplayFeatureAvailability_) {
    set_has_ReplayFeatureAvailability();
    this->_ReplayFeatureAvailability = ReplayFeatureAvailability_;
}

inline void SMSSettingsStatus::set_has_ReplayFeatureAvailability () {
    _has_bits_[0] |= 1u << 0;
}

inline void SMSSettingsStatus::clear_has_ReplayFeatureAvailability () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace datacollector_main_fi

#endif // DATACOLLECTOR_MAIN_FI_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
