#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DABTUNER_MAIN_FI_H
#define DABTUNER_MAIN_FI_H

#include "asf/cca/CcaTypes.h"
#include "asf/cca/CcaTypesConst.h"
#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "dabtuner_main_fi_types.h"
#include "dabtuner_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * CCA Functional Interface 'dabtuner_main_fi'
 *
 * Fullname: Middleware FC DAB Tuner Server Functional Interface
 *
 * Version: $Revision:   2.0  $
 *
 * Author: Liebanas, Hassmann
 *
 * Date: $Date:   Feb 18 2011 17:00:00  $
 *
 * Department:
 *
 * Title: dabtuner_main_fi
 *
 * <b>Description of 'dabtuner_main_fi':</b>
 *
 * Interface description for FC DABTuner service.
 */

namespace dabtuner_main_fi {

static const int SERVICE_ID = 124;

static const int FID_FID_DAB_S_START_SCAN = 2;

static const int FID_FID_DAB_S_LEARN = 3;

static const int FID_FID_DAB_S_GET_TIILIST = 4;

static const int FID_FID_DAB_S_ENS_SELECT = 17;

static const int FID_FID_DAB_S_SRV_SELECT = 18;

static const int FID_FID_DAB_S_COMP_SELECT = 19;

static const int FID_FID_DAB_S_SOURCE_STATE = 32;

static const int FID_FID_DAB_S_GET_FIELDSTRENGTH = 33;

static const int FID_FID_DAB_S_SETUP = 34;

static const int FID_FID_DAB_S_ANNO_CONFIG = 36;

static const int FID_FID_DAB_S_SELECT_ANNO = 37;

static const int FID_FID_DAB_S_SELECT_BANK = 39;

static const int FID_FID_DAB_S_SAVE_PRESET_LIST_ELEM = 64;

static const int FID_FID_DAB_S_DELETE_PRESET_LIST_ELEM = 65;

static const int FID_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM = 66;

static const int FID_FID_DAB_S_SAVE_PRESET_LIST = 72;

static const int FID_FID_DAB_S_GET_PRESET_LIST = 67;

static const int FID_FID_DAB_S_AUTOSTORE = 68;

static const int FID_FID_DAB_S_SET_ENS_LIST = 81;

static const int FID_FID_DAB_S_SET_SRV_LIST = 83;

static const int FID_FID_DAB_S_SET_COMP_LIST = 84;

static const int FID_FID_DAB_S_TEST_OPERATION = 96;

static const int FID_FID_DAB_S_DEFAULT_SETTINGS = 98;

static const int FID_FID_DAB_S_STOP_ANNO = 112;

static const int FID_FID_DAB_S_SELECT_TMC = 128;

static const int FID_FID_DAB_S_TPEG_URI_LIST = 133;

static const int FID_FID_DAB_S_SET_TPEG_CHN = 134;

static const int FID_FID_DAB_S_RDBID_WISH_LIST = 129;

static const int FID_FID_DAB_S_SET_TESTMODE = 144;

static const int FID_FID_DAB_S_GET_EXP_API_INFO = 145;

static const int FID_FID_DAB_S_DB_QUERY = 146;

static const int FID_FID_DAB_S_SEEK_ENSEMBLE = 149;

static const int FID_FID_DAB_S_SEEK_SERVICE = 150;

static const int FID_FID_DAB_S_TARGET_SEEK = 151;

static const int FID_FID_DAB_S_SET_MUTE_STATUS = 153;

static const int FID_FID_DAB_S_DATASERVICES_DATA = 265;

static const int FID_FID_DAB_S_DSM_MSG = 272;

static const int FID_FID_DAB_S_MTC_SETMODE = 273;

static const int FID_FID_DAB_S_TUNE_FREQUENCY_LABEL = 276;

static const int FID_FID_DAB_G_TUNER_STATUS = 256;

static const int FID_FID_DAB_G_AVAILABILITY = 288;

static const int FID_FID_DAB_G_ADR_MSG = 336;

static const int FID_FID_DAB_G_LOCAL_OFFSET = 337;

static const int FID_FID_DAB_S_USER_PROFILE_UPDATE = 277;

static const int FID_FID_DAB_G_ANNO_STATUS = 816;

static const int FID_FID_DAB_G_CHANNEL_INFO = 832;

static const int FID_FID_DAB_G_COMP_LIST = 848;

static const int FID_FID_DAB_G_PRESET_LIST = 864;

static const int FID_FID_DAB_G_SETUP_STATUS = 1024;

static const int FID_FID_DAB_G_SERVICE_FOLLOWING_STATUS = 1041;

static const int FID_FID_DAB_G_MUTE_STATUS = 1056;

static const int FID_FID_DAB_G_MUTE_REQUEST = 1072;

static const int FID_FID_DAB_G_LEARNUPDATE_PROGRESS = 1073;

static const int FID_FID_DAB_G_SRV_LIST_UPDATE = 1537;

static const int FID_FID_DAB_G_TESTMODE_DATA = 1792;

static const int FID_FID_DAB_G_ACTIVE_ENSEMBLE_INFO = 768;

static const int FID_FID_DAB_G_ACTIVE_SERVICE_INFO = 784;

static const int FID_FID_DAB_G_ACTIVE_COMPONENT_INFO = 800;

static const int FID_FID_DAB_G_BG_TESTMODE_DATA = 1808;

static const int FID_FID_DAB_G_TMC_TPEG_DATA = 1824;

static const int FID_FID_DAB_G_TMC_DATA = 1920;

static const int FID_FID_DAB_G_TMC_AVAIL_LIST = 1921;

static const int FID_FID_DAB_G_TPEG_DATA = 1936;

static const int FID_FID_DAB_G_TPEG_URI_LIST = 1937;

static const int FID_FID_DAB_G_MTC_SETMODE_STATUS = 1938;

static const int FID_FID_DAB_G_MTC_TUNER_STATUS = 1940;

static const int FID_FID_DAB_G_MTC_SURVEILLANCE_MONITOR = 1942;

static const int FID_FID_DAB_G_SRVLIST_NOTIFICATION = 1538;

static const int FID_FID_DAB_G_LIST_UPDATE = 1539;


ASF_GENERATOR_VERSION_CHECK_DECLARE

static const int VERSION_MAJOR = 2;

static const int VERSION_MINOR = 0;

static const int VERSION_PATCH = 0;

// forward declarations
class FID_DAB_S_START_SCANStart;

class FID_DAB_S_START_SCANResult;

class FID_DAB_S_START_SCANErrorStructure;

class FID_DAB_S_START_SCANError;

class FID_DAB_S_LEARNStart;

class FID_DAB_S_LEARNResult;

class FID_DAB_S_LEARNErrorStructure;

class FID_DAB_S_LEARNError;

class FID_DAB_S_GET_TIILISTResult;

class FID_DAB_S_GET_TIILISTErrorStructure;

class FID_DAB_S_GET_TIILISTError;

class FID_DAB_S_ENS_SELECTStart;

class FID_DAB_S_ENS_SELECTResult;

class FID_DAB_S_ENS_SELECTErrorStructure;

class FID_DAB_S_ENS_SELECTError;

class FID_DAB_S_SRV_SELECTStart;

class FID_DAB_S_SRV_SELECTResult;

class FID_DAB_S_SRV_SELECTErrorStructure;

class FID_DAB_S_SRV_SELECTError;

class FID_DAB_S_COMP_SELECTStart;

class FID_DAB_S_COMP_SELECTResult;

class FID_DAB_S_COMP_SELECTErrorStructure;

class FID_DAB_S_COMP_SELECTError;

class FID_DAB_S_SOURCE_STATEStart;

class FID_DAB_S_SOURCE_STATEResult;

class FID_DAB_S_SOURCE_STATEErrorStructure;

class FID_DAB_S_SOURCE_STATEError;

class FID_DAB_S_GET_FIELDSTRENGTHResult;

class FID_DAB_S_GET_FIELDSTRENGTHErrorStructure;

class FID_DAB_S_GET_FIELDSTRENGTHError;

class FID_DAB_S_SETUPStart;

class FID_DAB_S_SETUPResult;

class FID_DAB_S_SETUPErrorStructure;

class FID_DAB_S_SETUPError;

class FID_DAB_S_ANNO_CONFIGStart;

class FID_DAB_S_ANNO_CONFIGResult;

class FID_DAB_S_ANNO_CONFIGErrorStructure;

class FID_DAB_S_ANNO_CONFIGError;

class FID_DAB_S_SELECT_ANNOStart;

class FID_DAB_S_SELECT_ANNOResult;

class FID_DAB_S_SELECT_ANNOErrorStructure;

class FID_DAB_S_SELECT_ANNOError;

class FID_DAB_S_SELECT_BANKStart;

class FID_DAB_S_SELECT_BANKResult;

class FID_DAB_S_SELECT_BANKErrorStructure;

class FID_DAB_S_SELECT_BANKError;

class FID_DAB_S_SAVE_PRESET_LIST_ELEMStart;

class FID_DAB_S_SAVE_PRESET_LIST_ELEMResult;

class FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure;

class FID_DAB_S_SAVE_PRESET_LIST_ELEMError;

class FID_DAB_S_DELETE_PRESET_LIST_ELEMStart;

class FID_DAB_S_DELETE_PRESET_LIST_ELEMResult;

class FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure;

class FID_DAB_S_DELETE_PRESET_LIST_ELEMError;

class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart;

class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult;

class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure;

class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError;

class FID_DAB_S_SAVE_PRESET_LISTStart;

class FID_DAB_S_SAVE_PRESET_LISTResult;

class FID_DAB_S_SAVE_PRESET_LISTErrorStructure;

class FID_DAB_S_SAVE_PRESET_LISTError;

class FID_DAB_S_GET_PRESET_LISTStart;

class FID_DAB_S_GET_PRESET_LISTResult;

class FID_DAB_S_GET_PRESET_LISTErrorStructure;

class FID_DAB_S_GET_PRESET_LISTError;

class FID_DAB_S_AUTOSTOREStart;

class FID_DAB_S_AUTOSTOREResult;

class FID_DAB_S_AUTOSTOREErrorStructure;

class FID_DAB_S_AUTOSTOREError;

class FID_DAB_S_SET_ENS_LISTStart;

class FID_DAB_S_SET_ENS_LISTResult;

class FID_DAB_S_SET_ENS_LISTErrorStructure;

class FID_DAB_S_SET_ENS_LISTError;

class FID_DAB_S_SET_SRV_LISTStart;

class FID_DAB_S_SET_SRV_LISTResult;

class FID_DAB_S_SET_SRV_LISTErrorStructure;

class FID_DAB_S_SET_SRV_LISTError;

class FID_DAB_S_SET_COMP_LISTStart;

class FID_DAB_S_SET_COMP_LISTResult;

class FID_DAB_S_SET_COMP_LISTErrorStructure;

class FID_DAB_S_SET_COMP_LISTError;

class FID_DAB_S_TEST_OPERATIONStart;

class FID_DAB_S_TEST_OPERATIONResult;

class FID_DAB_S_TEST_OPERATIONErrorStructure;

class FID_DAB_S_TEST_OPERATIONError;

class FID_DAB_S_DEFAULT_SETTINGSStart;

class FID_DAB_S_DEFAULT_SETTINGSResult;

class FID_DAB_S_DEFAULT_SETTINGSErrorStructure;

class FID_DAB_S_DEFAULT_SETTINGSError;

class FID_DAB_S_STOP_ANNOResult;

class FID_DAB_S_STOP_ANNOErrorStructure;

class FID_DAB_S_STOP_ANNOError;

class FID_DAB_S_SELECT_TMCStart;

class FID_DAB_S_SELECT_TMCResult;

class FID_DAB_S_SELECT_TMCErrorStructure;

class FID_DAB_S_SELECT_TMCError;

class FID_DAB_S_TPEG_URI_LISTStart;

class FID_DAB_S_TPEG_URI_LISTResult;

class FID_DAB_S_TPEG_URI_LISTErrorStructure;

class FID_DAB_S_TPEG_URI_LISTError;

class FID_DAB_S_SET_TPEG_CHNStart;

class FID_DAB_S_SET_TPEG_CHNResult;

class FID_DAB_S_SET_TPEG_CHNErrorStructure;

class FID_DAB_S_SET_TPEG_CHNError;

class FID_DAB_S_RDBID_WISH_LISTStart;

class FID_DAB_S_RDBID_WISH_LISTResult;

class FID_DAB_S_RDBID_WISH_LISTErrorStructure;

class FID_DAB_S_RDBID_WISH_LISTError;

class FID_DAB_S_SET_TESTMODEStart;

class FID_DAB_S_SET_TESTMODEResult;

class FID_DAB_S_SET_TESTMODEErrorStructure;

class FID_DAB_S_SET_TESTMODEError;

class FID_DAB_S_GET_EXP_API_INFOStart;

class FID_DAB_S_GET_EXP_API_INFOResult;

class FID_DAB_S_GET_EXP_API_INFOErrorStructure;

class FID_DAB_S_GET_EXP_API_INFOError;

class FID_DAB_S_DB_QUERYStart;

class FID_DAB_S_DB_QUERYResult;

class FID_DAB_S_DB_QUERYErrorStructure;

class FID_DAB_S_DB_QUERYError;

class FID_DAB_S_SEEK_ENSEMBLEStart;

class FID_DAB_S_SEEK_ENSEMBLEResult;

class FID_DAB_S_SEEK_ENSEMBLEErrorStructure;

class FID_DAB_S_SEEK_ENSEMBLEError;

class FID_DAB_S_SEEK_SERVICEStart;

class FID_DAB_S_SEEK_SERVICEResult;

class FID_DAB_S_SEEK_SERVICEErrorStructure;

class FID_DAB_S_SEEK_SERVICEError;

class FID_DAB_S_TARGET_SEEKStart;

class FID_DAB_S_TARGET_SEEKResult;

class FID_DAB_S_TARGET_SEEKErrorStructure;

class FID_DAB_S_TARGET_SEEKError;

class FID_DAB_S_SET_MUTE_STATUSStart;

class FID_DAB_S_SET_MUTE_STATUSResult;

class FID_DAB_S_SET_MUTE_STATUSErrorStructure;

class FID_DAB_S_SET_MUTE_STATUSError;

class FID_DAB_S_DATASERVICES_DATAStart;

class FID_DAB_S_DATASERVICES_DATAResult;

class FID_DAB_S_DATASERVICES_DATAErrorStructure;

class FID_DAB_S_DATASERVICES_DATAError;

class FID_DAB_S_DSM_MSGStart;

class FID_DAB_S_DSM_MSGResult;

class FID_DAB_S_DSM_MSGErrorStructure;

class FID_DAB_S_DSM_MSGError;

class FID_DAB_S_MTC_SETMODEStart;

class FID_DAB_S_MTC_SETMODEResult;

class FID_DAB_S_MTC_SETMODEErrorStructure;

class FID_DAB_S_MTC_SETMODEError;

class FID_DAB_S_TUNE_FREQUENCY_LABELStart;

class FID_DAB_S_TUNE_FREQUENCY_LABELResult;

class FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure;

class FID_DAB_S_TUNE_FREQUENCY_LABELError;

class FID_DAB_G_TUNER_STATUSStatus;

class FID_DAB_G_AVAILABILITYStatus;

class FID_DAB_G_ADR_MSGStatus;

class FID_DAB_G_LOCAL_OFFSETStatus;

class FID_DAB_S_USER_PROFILE_UPDATEStart;

class FID_DAB_S_USER_PROFILE_UPDATEResult;

class FID_DAB_S_USER_PROFILE_UPDATEErrorStructure;

class FID_DAB_S_USER_PROFILE_UPDATEError;

class FID_DAB_G_ANNO_STATUSStatus;

class FID_DAB_G_CHANNEL_INFOStatus;

class FID_DAB_G_COMP_LISTStatus;

class FID_DAB_G_PRESET_LISTStatus;

class FID_DAB_G_SETUP_STATUSStatus;

class FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus;

class FID_DAB_G_MUTE_STATUSStatus;

class FID_DAB_G_MUTE_REQUESTStatus;

class FID_DAB_G_LEARNUPDATE_PROGRESSStatus;

class FID_DAB_G_SRV_LIST_UPDATEStatus;

class FID_DAB_G_TESTMODE_DATAStatus;

class FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus;

class FID_DAB_G_ACTIVE_SERVICE_INFOStatus;

class FID_DAB_G_ACTIVE_COMPONENT_INFOStatus;

class FID_DAB_G_BG_TESTMODE_DATAStatus;

class FID_DAB_G_TMC_TPEG_DATAStatus;

class FID_DAB_G_TMC_DATAStatus;

class FID_DAB_G_TMC_AVAIL_LISTStatus;

class FID_DAB_G_TPEG_DATAStatus;

class FID_DAB_G_TPEG_URI_LISTStatus;

class FID_DAB_G_MTC_SETMODE_STATUSStatus;

class FID_DAB_G_MTC_TUNER_STATUSStatus;

class FID_DAB_G_MTC_SURVEILLANCE_MONITORStatus;

class FID_DAB_G_SRVLIST_NOTIFICATIONStatus;

class FID_DAB_G_LIST_UPDATEStatus;

// type definitions
/**
 * The abort error message of the method "FID_DAB_S_START_SCAN"
 * With this command, different tunes can be started or the tune operation can be stopped.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_START_SCANAbortError;

/**
 * The abort error message of the method "FID_DAB_S_LEARN"
 * Update the internal learn memory of the DAB module with information about receivable ensembles and services.
 * LCN2: Method for HMI (e.g. first item of service-list)
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_LEARNAbortError;

/**
 * The start message of the method "FID_DAB_S_GET_TIILIST"
 * With this method, TII list can be retrieved
 * The currently available TII List would be retrieved
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_S_GET_TIILISTStart;

/**
 * The abort error message of the method "FID_DAB_S_GET_TIILIST"
 * With this method, TII list can be retrieved
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_GET_TIILISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_ENS_SELECT"
 * With this command a ensemble can be selected.
 * G3g: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_ENS_SELECTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SRV_SELECT"
 * With this command a service can be selected.
 * LCN2: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SRV_SELECTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_COMP_SELECT"
 * With this command a component can be selected.
 * LCN2: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_COMP_SELECTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SOURCE_STATE"
 * With this command we set the DAB Module in Foreground or Background.
 * LCN2: method is used by Tuner-Master
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SOURCE_STATEAbortError;

/**
 * The start message of the method "FID_DAB_S_GET_FIELDSTRENGTH"
 * Field Strength of the current tuned service.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_S_GET_FIELDSTRENGTHStart;

/**
 * The abort error message of the method "FID_DAB_S_GET_FIELDSTRENGTH"
 * Field Strength of the current tuned service.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_GET_FIELDSTRENGTHAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SETUP"
 * Switches to configure fc_dabtuner
 * No Setups-Commands are currently supported in setup-mask
 * LCN2: Method for HMI to set concealment-level (test-mode)
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SETUPAbortError;

/**
 * The abort error message of the method "FID_DAB_S_ANNO_CONFIG"
 * Configure handling of announcements
 * LCN2: Method for TunerMaster
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_ANNO_CONFIGAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SELECT_ANNO"
 * selects a particular Announcement
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SELECT_ANNOAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SELECT_BANK"
 * Selects a particular Bank
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SELECT_BANKAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SAVE_PRESET_LIST_ELEM"
 * Saves the current DAB service to the preset list.
 * LCN2: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SAVE_PRESET_LIST_ELEMAbortError;

/**
 * The abort error message of the method "FID_DAB_S_DELETE_PRESET_LIST_ELEM"
 * This method is used to delete the elements from the DAB preset list.
 * LCN2: Method for Diagnosis or not used
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_DELETE_PRESET_LIST_ELEMAbortError;

/**
 * The abort error message of the method "FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM"
 * Activates the selected element of the DAB preset list.
 * LCN2: Method for TunerMaster
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SAVE_PRESET_LIST"
 * Saves the current list to DAB preset list
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SAVE_PRESET_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_GET_PRESET_LIST"
 * With this command we can get the DAB preset list elements based on request.
 * LCN2: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_GET_PRESET_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_AUTOSTORE"
 * With this command we can start/stop autostore
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_AUTOSTOREAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SET_ENS_LIST"
 * Open/Close/Get the frozen Ensemble-list.
 * G3g: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SET_ENS_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SET_SRV_LIST"
 * Open/Close/Get the frozen service-list with/without PTY filter.
 * Gen3G: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SET_SRV_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SET_COMP_LIST"
 * Open/Close a frozen component-list.
 * LCN2: Method for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SET_COMP_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_TEST_OPERATION"
 * Generic interface for test-commands
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_TEST_OPERATIONAbortError;

/**
 * The abort error message of the method "FID_DAB_S_DEFAULT_SETTINGS"
 * Interface to set default settings
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_DEFAULT_SETTINGSAbortError;

/**
 * The start message of the method "FID_DAB_S_STOP_ANNO"
 * Stop an selected announcement
 * The currently playing announcement shall be stopped, the anno-state is set back to idle.
 * The state will be set to pending again, if a new announcement is indicated from the dab-module
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_S_STOP_ANNOStart;

/**
 * The abort error message of the method "FID_DAB_S_STOP_ANNO"
 * Stop an selected announcement
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_STOP_ANNOAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SELECT_TMC"
 * Select an ensemble with corresponding RDBID for tmc-data.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SELECT_TMCAbortError;

/**
 * The abort error message of the method "FID_DAB_S_TPEG_URI_LIST"
 * With this command we get the DAB TPEG URI list with all receivable TPEG services.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_TPEG_URI_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SET_TPEG_CHN"
 * With this command the DAB TPEG URI can be selected.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SET_TPEG_CHNAbortError;

/**
 * The abort error message of the method "FID_DAB_S_RDBID_WISH_LIST"
 * These RDBIDs should be handled.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_RDBID_WISH_LISTAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SET_TESTMODE"
 * Starts/Stops receiving of testmode-data
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SET_TESTMODEAbortError;

/**
 * The abort error message of the method "FID_DAB_S_GET_EXP_API_INFO"
 * Gets labeltext and expert value for ADR3 internal expert id
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_GET_EXP_API_INFOAbortError;

/**
 * The abort error message of the method "FID_DAB_S_DB_QUERY"
 * requests a database query from adr3
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_DB_QUERYAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SEEK_ENSEMBLE"
 * Seek to next/prev ensemble (only in testmode)
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SEEK_ENSEMBLEAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SEEK_SERVICE"
 * Seek to next/prev service (only in testmode)
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SEEK_SERVICEAbortError;

/**
 * The abort error message of the method "FID_DAB_S_TARGET_SEEK"
 * Start target seek
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_TARGET_SEEKAbortError;

/**
 * The abort error message of the method "FID_DAB_S_SET_MUTE_STATUS"
 * Informs fc_dabtuner that Mute status is activ/inactiv.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_SET_MUTE_STATUSAbortError;

/**
 * The abort error message of the method "FID_DAB_S_DATASERVICES_DATA"
 * Informs FC DAB logo list, content id list
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_DATASERVICES_DATAAbortError;

/**
 * The abort error message of the method "FID_DAB_S_DSM_MSG"
 * Informs fc_dabtuner that there is a message from DSM.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_DSM_MSGAbortError;

/**
 * The abort error message of the method "FID_DAB_S_MTC_SETMODE"
 * Sets the mode for the service switch request.
 * It can be OFF, DAB to FM switching or FM to DAB switching.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_MTC_SETMODEAbortError;

/**
 * The abort error message of the method "FID_DAB_S_TUNE_FREQUENCY_LABEL"
 * Client requests the Direct Tune the DAB Frequency.
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_TUNE_FREQUENCY_LABELAbortError;

/**
 * The get message of the property "FID_DAB_G_TUNER_STATUS"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TUNER_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_TUNER_STATUS"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TUNER_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TUNER_STATUS"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TUNER_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_TUNER_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TUNER_STATUSError;

/**
 * The get message of the property "FID_DAB_G_AVAILABILITY"
 * DAB Availability status.
 * LCN2: Property for HMI, TunerMaster ...
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_AVAILABILITYGet;

/**
 * The upreg message of the property "FID_DAB_G_AVAILABILITY"
 * DAB Availability status.
 * LCN2: Property for HMI, TunerMaster ...
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_AVAILABILITYUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_AVAILABILITY"
 * DAB Availability status.
 * LCN2: Property for HMI, TunerMaster ...
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_AVAILABILITYRelUpReg;

/**
 * The error message of 'FID_DAB_G_AVAILABILITY'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_AVAILABILITYError;

/**
 * The get message of the property "FID_DAB_G_ADR_MSG"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ADR_MSGGet;

/**
 * The upreg message of the property "FID_DAB_G_ADR_MSG"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ADR_MSGUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_ADR_MSG"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ADR_MSGRelUpReg;

/**
 * The error message of 'FID_DAB_G_ADR_MSG'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_ADR_MSGError;

/**
 * The get message of the property "FID_DAB_G_LOCAL_OFFSET"
 * Gives local offset with respect to UTC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LOCAL_OFFSETGet;

/**
 * The upreg message of the property "FID_DAB_G_LOCAL_OFFSET"
 * Gives local offset with respect to UTC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LOCAL_OFFSETUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_LOCAL_OFFSET"
 * Gives local offset with respect to UTC
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LOCAL_OFFSETRelUpReg;

/**
 * The error message of 'FID_DAB_G_LOCAL_OFFSET'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_LOCAL_OFFSETError;

/**
 * The abort error message of the method "FID_DAB_S_USER_PROFILE_UPDATE"
 * Method for Tunermaster. This method is used to copy, delete or activate a user profile
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_S_USER_PROFILE_UPDATEAbortError;

/**
 * The get message of the property "FID_DAB_G_ANNO_STATUS"
 * Current announcement status
 * LCN2: Property for TunerMaster
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ANNO_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_ANNO_STATUS"
 * Current announcement status
 * LCN2: Property for TunerMaster
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ANNO_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_ANNO_STATUS"
 * Current announcement status
 * LCN2: Property for TunerMaster
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ANNO_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_ANNO_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_ANNO_STATUSError;

/**
 * The get message of the property "FID_DAB_G_CHANNEL_INFO"
 * Service Info to be displayed in Main-Sreen
 * LCN2: Property for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_CHANNEL_INFOGet;

/**
 * The upreg message of the property "FID_DAB_G_CHANNEL_INFO"
 * Service Info to be displayed in Main-Sreen
 * LCN2: Property for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_CHANNEL_INFOUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_CHANNEL_INFO"
 * Service Info to be displayed in Main-Sreen
 * LCN2: Property for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_CHANNEL_INFORelUpReg;

/**
 * The error message of 'FID_DAB_G_CHANNEL_INFO'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_CHANNEL_INFOError;

/**
 * The get message of the property "FID_DAB_G_COMP_LIST"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_COMP_LISTGet;

/**
 * The upreg message of the property "FID_DAB_G_COMP_LIST"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_COMP_LISTUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_COMP_LIST"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_COMP_LISTRelUpReg;

/**
 * The error message of 'FID_DAB_G_COMP_LIST'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_COMP_LISTError;

/**
 * The get message of the property "FID_DAB_G_PRESET_LIST"
 * Response regarding preset list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_PRESET_LISTGet;

/**
 * The upreg message of the property "FID_DAB_G_PRESET_LIST"
 * Response regarding preset list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_PRESET_LISTUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_PRESET_LIST"
 * Response regarding preset list.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_PRESET_LISTRelUpReg;

/**
 * The error message of 'FID_DAB_G_PRESET_LIST'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_PRESET_LISTError;

/**
 * The get message of the property "FID_DAB_G_SETUP_STATUS"
 * The current operation set up can be requested by the client with
 * this property.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SETUP_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_SETUP_STATUS"
 * The current operation set up can be requested by the client with
 * this property.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SETUP_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_SETUP_STATUS"
 * The current operation set up can be requested by the client with
 * this property.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SETUP_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_SETUP_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_SETUP_STATUSError;

/**
 * The get message of the property "FID_DAB_G_SERVICE_FOLLOWING_STATUS"
 * Property indicating the tuner status of adr3 if dab or fm is active.
 * This is only for HMI to signal for example in dab-screnn that FM is playing.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SERVICE_FOLLOWING_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_SERVICE_FOLLOWING_STATUS"
 * Property indicating the tuner status of adr3 if dab or fm is active.
 * This is only for HMI to signal for example in dab-screnn that FM is playing.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SERVICE_FOLLOWING_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_SERVICE_FOLLOWING_STATUS"
 * Property indicating the tuner status of adr3 if dab or fm is active.
 * This is only for HMI to signal for example in dab-screnn that FM is playing.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SERVICE_FOLLOWING_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_SERVICE_FOLLOWING_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_SERVICE_FOLLOWING_STATUSError;

/**
 * The get message of the property "FID_DAB_G_MUTE_STATUS"
 * Property indicating the mute-status that fc_dabtuner wants to have.
 * LCN2: Property for FC_Audio
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MUTE_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_MUTE_STATUS"
 * Property indicating the mute-status that fc_dabtuner wants to have.
 * LCN2: Property for FC_Audio
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MUTE_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_MUTE_STATUS"
 * Property indicating the mute-status that fc_dabtuner wants to have.
 * LCN2: Property for FC_Audio
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MUTE_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_MUTE_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_MUTE_STATUSError;

/**
 * The get message of the property "FID_DAB_G_MUTE_REQUEST"
 * Property indicating the mute-request for fc_dabtuner.
 * LCN2kai: Property for FC_Tunermaster
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MUTE_REQUESTGet;

/**
 * The upreg message of the property "FID_DAB_G_MUTE_REQUEST"
 * Property indicating the mute-request for fc_dabtuner.
 * LCN2kai: Property for FC_Tunermaster
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MUTE_REQUESTUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_MUTE_REQUEST"
 * Property indicating the mute-request for fc_dabtuner.
 * LCN2kai: Property for FC_Tunermaster
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MUTE_REQUESTRelUpReg;

/**
 * The error message of 'FID_DAB_G_MUTE_REQUEST'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_MUTE_REQUESTError;

/**
 * The get message of the property "FID_DAB_G_LEARNUPDATE_PROGRESS"
 * Provides the progress of the learn update in percentage.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LEARNUPDATE_PROGRESSGet;

/**
 * The upreg message of the property "FID_DAB_G_LEARNUPDATE_PROGRESS"
 * Provides the progress of the learn update in percentage.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LEARNUPDATE_PROGRESSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_LEARNUPDATE_PROGRESS"
 * Provides the progress of the learn update in percentage.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LEARNUPDATE_PROGRESSRelUpReg;

/**
 * The error message of 'FID_DAB_G_LEARNUPDATE_PROGRESS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_LEARNUPDATE_PROGRESSError;

/**
 * The get message of the property "FID_DAB_G_SRV_LIST_UPDATE"
 * Information about the service list.
 * LCN2: Property for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SRV_LIST_UPDATEGet;

/**
 * The upreg message of the property "FID_DAB_G_SRV_LIST_UPDATE"
 * Information about the service list.
 * LCN2: Property for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SRV_LIST_UPDATEUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_SRV_LIST_UPDATE"
 * Information about the service list.
 * LCN2: Property for HMI
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SRV_LIST_UPDATERelUpReg;

/**
 * The error message of 'FID_DAB_G_SRV_LIST_UPDATE'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_SRV_LIST_UPDATEError;

/**
 * The get message of the property "FID_DAB_G_TESTMODE_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TESTMODE_DATAGet;

/**
 * The upreg message of the property "FID_DAB_G_TESTMODE_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TESTMODE_DATAUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TESTMODE_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TESTMODE_DATARelUpReg;

/**
 * The error message of 'FID_DAB_G_TESTMODE_DATA'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TESTMODE_DATAError;

/**
 * The upreg message of the property "FID_DAB_G_ACTIVE_ENSEMBLE_INFO"
 * The radio unit sends information regarding the current ensemble whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_ENSEMBLE_INFOUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_ACTIVE_ENSEMBLE_INFO"
 * The radio unit sends information regarding the current ensemble whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_ENSEMBLE_INFORelUpReg;

/**
 * The error message of 'FID_DAB_G_ACTIVE_ENSEMBLE_INFO'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_ACTIVE_ENSEMBLE_INFOError;

/**
 * The get message of the property "FID_DAB_G_ACTIVE_SERVICE_INFO"
 * The radio unit sends information regarding the current service whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_SERVICE_INFOGet;

/**
 * The upreg message of the property "FID_DAB_G_ACTIVE_SERVICE_INFO"
 * The radio unit sends information regarding the current service whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_SERVICE_INFOUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_ACTIVE_SERVICE_INFO"
 * The radio unit sends information regarding the current service whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_SERVICE_INFORelUpReg;

/**
 * The error message of 'FID_DAB_G_ACTIVE_SERVICE_INFO'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_ACTIVE_SERVICE_INFOError;

/**
 * The get message of the property "FID_DAB_G_ACTIVE_COMPONENT_INFO"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_COMPONENT_INFOGet;

/**
 * The upreg message of the property "FID_DAB_G_ACTIVE_COMPONENT_INFO"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_COMPONENT_INFOUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_ACTIVE_COMPONENT_INFO"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_ACTIVE_COMPONENT_INFORelUpReg;

/**
 * The error message of 'FID_DAB_G_ACTIVE_COMPONENT_INFO'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_ACTIVE_COMPONENT_INFOError;

/**
 * The get message of the property "FID_DAB_G_BG_TESTMODE_DATA"
 * The radio unit sends this background dab tuner information only when test mode has been activated.
 * "Get" is not possible, only a spontaneous response is supported as response to the activated Test
 * Mode with FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_BG_TESTMODE_DATAGet;

/**
 * The upreg message of the property "FID_DAB_G_BG_TESTMODE_DATA"
 * The radio unit sends this background dab tuner information only when test mode has been activated.
 * "Get" is not possible, only a spontaneous response is supported as response to the activated Test
 * Mode with FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_BG_TESTMODE_DATAUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_BG_TESTMODE_DATA"
 * The radio unit sends this background dab tuner information only when test mode has been activated.
 * "Get" is not possible, only a spontaneous response is supported as response to the activated Test
 * Mode with FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_BG_TESTMODE_DATARelUpReg;

/**
 * The error message of 'FID_DAB_G_BG_TESTMODE_DATA'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_BG_TESTMODE_DATAError;

/**
 * The upreg message of the property "FID_DAB_G_TMC_TPEG_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_TPEG_DATAUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TMC_TPEG_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_TPEG_DATARelUpReg;

/**
 * The error message of 'FID_DAB_G_TMC_TPEG_DATA'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TMC_TPEG_DATAError;

/**
 * The upreg message of the property "FID_DAB_G_TMC_DATA"
 * The radio unit sends this information only when tmc data has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated TMC.
 * LCN2: Property for HMI (TMC)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_DATAUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TMC_DATA"
 * The radio unit sends this information only when tmc data has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated TMC.
 * LCN2: Property for HMI (TMC)
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_DATARelUpReg;

/**
 * The error message of 'FID_DAB_G_TMC_DATA'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TMC_DATAError;

/**
 * The get message of the property "FID_DAB_G_TMC_AVAIL_LIST"
 * List of ensembles with provided rdbIds
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_AVAIL_LISTGet;

/**
 * The upreg message of the property "FID_DAB_G_TMC_AVAIL_LIST"
 * List of ensembles with provided rdbIds
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_AVAIL_LISTUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TMC_AVAIL_LIST"
 * List of ensembles with provided rdbIds
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TMC_AVAIL_LISTRelUpReg;

/**
 * The error message of 'FID_DAB_G_TMC_AVAIL_LIST'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TMC_AVAIL_LISTError;

/**
 * The upreg message of the property "FID_DAB_G_TPEG_DATA"
 * The radio unit sends this information only when tpeg data has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated TPEG service.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TPEG_DATAUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TPEG_DATA"
 * The radio unit sends this information only when tpeg data has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated TPEG service.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TPEG_DATARelUpReg;

/**
 * The error message of 'FID_DAB_G_TPEG_DATA'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TPEG_DATAError;

/**
 * The upreg message of the property "FID_DAB_G_TPEG_URI_LIST"
 * With this command the DAB TPEG URI list with all receivable TPEG services will be replied.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TPEG_URI_LISTUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_TPEG_URI_LIST"
 * With this command the DAB TPEG URI list with all receivable TPEG services will be replied.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_TPEG_URI_LISTRelUpReg;

/**
 * The error message of 'FID_DAB_G_TPEG_URI_LIST'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_TPEG_URI_LISTError;

/**
 * The get message of the property "FID_DAB_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_SETMODE_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_SETMODE_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_SETMODE_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_MTC_SETMODE_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_MTC_SETMODE_STATUSError;

/**
 * The get message of the property "FID_DAB_G_MTC_TUNER_STATUS"
 * This property sends a notification to the clients if the tuner has performed an automatic tuner change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_TUNER_STATUSGet;

/**
 * The upreg message of the property "FID_DAB_G_MTC_TUNER_STATUS"
 * This property sends a notification to the clients if the tuner has performed an automatic tuner change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_TUNER_STATUSUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_MTC_TUNER_STATUS"
 * This property sends a notification to the clients if the tuner has performed an automatic tuner change.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_TUNER_STATUSRelUpReg;

/**
 * The error message of 'FID_DAB_G_MTC_TUNER_STATUS'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_MTC_TUNER_STATUSError;

/**
 * The get message of the property "FID_DAB_G_MTC_SURVEILLANCE_MONITOR"
 * If a DAB station is being played and if a matching FM service is avialable,
 * the parameters of the property are notified for that FM station if atleast
 * one of them changes.
 * Vice versa is also true.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_SURVEILLANCE_MONITORGet;

/**
 * The upreg message of the property "FID_DAB_G_MTC_SURVEILLANCE_MONITOR"
 * If a DAB station is being played and if a matching FM service is avialable,
 * the parameters of the property are notified for that FM station if atleast
 * one of them changes.
 * Vice versa is also true.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_SURVEILLANCE_MONITORUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_MTC_SURVEILLANCE_MONITOR"
 * If a DAB station is being played and if a matching FM service is avialable,
 * the parameters of the property are notified for that FM station if atleast
 * one of them changes.
 * Vice versa is also true.
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_MTC_SURVEILLANCE_MONITORRelUpReg;

/**
 * The error message of 'FID_DAB_G_MTC_SURVEILLANCE_MONITOR'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_MTC_SURVEILLANCE_MONITORError;

/**
 * The upreg message of the property "FID_DAB_G_SRVLIST_NOTIFICATION"
 * List update notification whenever there is a change in service list.
 * Property for SDS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SRVLIST_NOTIFICATIONUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_SRVLIST_NOTIFICATION"
 * List update notification whenever there is a change in service list.
 * Property for SDS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_SRVLIST_NOTIFICATIONRelUpReg;

/**
 * The error message of 'FID_DAB_G_SRVLIST_NOTIFICATION'
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_SRVLIST_NOTIFICATIONError;

/**
 * The get message of the property "FID_DAB_G_LIST_UPDATE"
 * Information about the service list.
 * Property for SDS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LIST_UPDATEGet;

/**
 * The upreg message of the property "FID_DAB_G_LIST_UPDATE"
 * Information about the service list.
 * Property for SDS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LIST_UPDATEUpReg;

/**
 * The relUpReg message of the property "FID_DAB_G_LIST_UPDATE"
 * Information about the service list.
 * Property for SDS
 */
typedef ::asf::cca::CcaTypes::DefaultMessage FID_DAB_G_LIST_UPDATERelUpReg;

/**
 * The error message of 'FID_DAB_G_LIST_UPDATE'
 * possible errors of a cca call from the client
 */
typedef ::asf::cca::CcaTypes::DefaultError FID_DAB_G_LIST_UPDATEError;


/**
 * The start message of the method "FID_DAB_S_START_SCAN"
 * With this command, different tunes can be started or the tune operation can be stopped.
 */
class FID_DAB_S_START_SCANStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_START_SCANStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_START_SCANStart (const FID_DAB_S_START_SCANStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_START_SCANStart (bool StartScan_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_START_SCANStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_START_SCANStart& operator = (const FID_DAB_S_START_SCANStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_START_SCANStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_START_SCANStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_START_SCANStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_START_SCANStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartScan"

    static const int kStartScan = 0;

    /**
     * Clears the field "StartScan".
     *
     * The field will be set to its default value. The hasStartScan()
     * method will return false.
     */
    inline void clearStartScan();

    /**
     * Checks whether the field "StartScan" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartScan()). Otherwise it will return false.
     */
    inline bool hasStartScan () const;

    /**
     * Returns the value of the member "StartScan".
     *
     * Starts/stops scan if value is 1/0
     *
     * @return The value of the field "StartScan"
     */
    inline bool getStartScan () const;

    /**
     * Sets the value of the member "StartScan".
     *
     * Starts/stops scan if value is 1/0
     *
     * @param StartScan The value which will be set
     */
    inline void setStartScan (bool StartScan_);

    static const FID_DAB_S_START_SCANStart &getDefaultInstance();

private:

    inline void set_has_StartScan ();

    inline void clear_has_StartScan ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _StartScan;

};

/**
 * The result message of the method "FID_DAB_S_START_SCAN"
 * With this command, different tunes can be started or the tune operation can be stopped.
 * .
 */
class FID_DAB_S_START_SCANResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_START_SCANResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_START_SCANResult (const FID_DAB_S_START_SCANResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_START_SCANResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_START_SCANResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_START_SCANResult& operator = (const FID_DAB_S_START_SCANResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_START_SCANResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_START_SCANResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_START_SCANResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_START_SCANResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_START_SCANResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_START_SCAN'
 */
class FID_DAB_S_START_SCANErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_START_SCANErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_START_SCANErrorStructure (const FID_DAB_S_START_SCANErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_START_SCANErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_START_SCANErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_START_SCANErrorStructure& operator = (const FID_DAB_S_START_SCANErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_START_SCANErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_START_SCANErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_START_SCANErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_START_SCANErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_START_SCANErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_START_SCAN'
 */
class FID_DAB_S_START_SCANError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_START_SCANErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_START_SCANError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_START_SCANError (const FID_DAB_S_START_SCANError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_START_SCANError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_START_SCANError& operator = (const FID_DAB_S_START_SCANError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_START_SCANError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_START_SCANError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_START_SCANError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_START_SCANError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_START_SCANError::FID_DAB_S_START_SCANErrorField getField () const;

    inline void setField(FID_DAB_S_START_SCANError::FID_DAB_S_START_SCANErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_START_SCANErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_START_SCANErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_START_SCANErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_START_SCANErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_START_SCANErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_START_SCANErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_START_SCANErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_START_SCANErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_START_SCANError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_START_SCANError& rhs);

    inline void deleteData ();

    FID_DAB_S_START_SCANErrorField __field;

    union {
        FID_DAB_S_START_SCANErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_LEARN"
 * Update the internal learn memory of the DAB module with information about receivable ensembles and services.
 * LCN2: Method for HMI (e.g. first item of service-list)
 */
class FID_DAB_S_LEARNStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_LEARNStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_LEARNStart (const FID_DAB_S_LEARNStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_LEARNStart (const ::dabtuner_main_fi_types::T_DAB_LearnParam& LearnParam_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_LEARNStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_LEARNStart& operator = (const FID_DAB_S_LEARNStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_LEARNStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_LEARNStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_LEARNStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_LEARNStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LearnParam"

    static const int kLearnParam = 0;

    /**
     * Clears the field "LearnParam".
     *
     * The field will be set to its default value. The hasLearnParam()
     * method will return false.
     */
    inline void clearLearnParam();

    /**
     * Checks whether the field "LearnParam" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLearnParam()). Otherwise it will return false.
     */
    inline bool hasLearnParam () const;

    /**
     * Returns the value of the member "LearnParam".
     *
     * .
     *
     * @return The value of the field "LearnParam"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_LearnParam& getLearnParam () const;

    /**
     * Retrieves the value of the field "LearnParam" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LearnParam".
     */
    inline ::dabtuner_main_fi_types::T_DAB_LearnParam& getLearnParamMutable ();

    /**
     * Sets the value of the member "LearnParam".
     *
     * .
     *
     * @param LearnParam The value which will be set
     */
    inline void setLearnParam (const ::dabtuner_main_fi_types::T_DAB_LearnParam& LearnParam_);

    static const FID_DAB_S_LEARNStart &getDefaultInstance();

private:

    inline void set_has_LearnParam ();

    inline void clear_has_LearnParam ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_LearnParam _LearnParam;

};

/**
 * The result message of the method "FID_DAB_S_LEARN"
 * Update the internal learn memory of the DAB module with information about receivable ensembles and services.
 * LCN2: Method for HMI (e.g. first item of service-list)
 * .
 */
class FID_DAB_S_LEARNResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_LEARNResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_LEARNResult (const FID_DAB_S_LEARNResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_LEARNResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_LEARNResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_LEARNResult& operator = (const FID_DAB_S_LEARNResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_LEARNResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_LEARNResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_LEARNResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_LEARNResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_LEARNResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_LEARN'
 */
class FID_DAB_S_LEARNErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_LEARNErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_LEARNErrorStructure (const FID_DAB_S_LEARNErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_LEARNErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_LEARNErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_LEARNErrorStructure& operator = (const FID_DAB_S_LEARNErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_LEARNErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_LEARNErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_LEARNErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_LEARNErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_LEARNErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_LEARN'
 */
class FID_DAB_S_LEARNError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_LEARNErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_LEARNError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_LEARNError (const FID_DAB_S_LEARNError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_LEARNError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_LEARNError& operator = (const FID_DAB_S_LEARNError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_LEARNError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_LEARNError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_LEARNError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_LEARNError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_LEARNError::FID_DAB_S_LEARNErrorField getField () const;

    inline void setField(FID_DAB_S_LEARNError::FID_DAB_S_LEARNErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_LEARNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_LEARNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_LEARNErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_LEARNErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_LEARNErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_LEARNErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_LEARNErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_LEARNErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_LEARNError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_LEARNError& rhs);

    inline void deleteData ();

    FID_DAB_S_LEARNErrorField __field;

    union {
        FID_DAB_S_LEARNErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "FID_DAB_S_GET_TIILIST"
 * With this method, TII list can be retrieved
 * .
 */
class FID_DAB_S_GET_TIILISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_TIILISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_TIILISTResult (const FID_DAB_S_GET_TIILISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_TIILISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TIIListElement >& TIIList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_TIILISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_TIILISTResult& operator = (const FID_DAB_S_GET_TIILISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_TIILISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_TIILISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_TIILISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_TIILISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "TIIList"

    static const int kTIIList = 1;

    /**
     * Clears the field "TIIList".
     *
     * The field will be set to its default value. The hasTIIList()
     * method will return false.
     */
    inline void clearTIIList();

    /**
     * Checks whether the field "TIIList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTIIList()). Otherwise it will return false.
     */
    inline bool hasTIIList () const;

    /**
     * Returns the value of the member "TIIList".
     *
     * List of available transmitter identification information
     *
     * @return The value of the field "TIIList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TIIListElement >& getTIIList () const;

    /**
     * Retrieves the value of the field "TIIList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TIIList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_TIIListElement >& getTIIListMutable ();

    /**
     * Sets the value of the member "TIIList".
     *
     * List of available transmitter identification information
     *
     * @param TIIList The value which will be set
     */
    inline void setTIIList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TIIListElement >& TIIList_);

    static const FID_DAB_S_GET_TIILISTResult &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TIIListElement >& getT_DAB_TIIListElementList_DefaultInstance ();

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_TIIList ();

    inline void clear_has_TIIList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_TIIListElement > _TIIList;

};

/**
 * The error message of 'FID_DAB_S_GET_TIILIST'
 */
class FID_DAB_S_GET_TIILISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_TIILISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_TIILISTErrorStructure (const FID_DAB_S_GET_TIILISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_TIILISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_GET_TIILISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_TIILISTErrorStructure& operator = (const FID_DAB_S_GET_TIILISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_TIILISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_TIILISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_TIILISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_TIILISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_GET_TIILISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_GET_TIILIST'
 */
class FID_DAB_S_GET_TIILISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_GET_TIILISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_GET_TIILISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_TIILISTError (const FID_DAB_S_GET_TIILISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_TIILISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_GET_TIILISTError& operator = (const FID_DAB_S_GET_TIILISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_TIILISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_TIILISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_TIILISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_TIILISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_GET_TIILISTError::FID_DAB_S_GET_TIILISTErrorField getField () const;

    inline void setField(FID_DAB_S_GET_TIILISTError::FID_DAB_S_GET_TIILISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_GET_TIILISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_GET_TIILISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_GET_TIILISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_GET_TIILISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_GET_TIILISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_GET_TIILISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_GET_TIILISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_GET_TIILISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_GET_TIILISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_GET_TIILISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_GET_TIILISTErrorField __field;

    union {
        FID_DAB_S_GET_TIILISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_ENS_SELECT"
 * With this command a ensemble can be selected.
 * G3g: Method for HMI
 */
class FID_DAB_S_ENS_SELECTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ENS_SELECTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ENS_SELECTStart (const FID_DAB_S_ENS_SELECTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ENS_SELECTStart (::dabtuner_main_fi_types::T_e8_DAB_EnsSelectMode SelectMode_, uint32 u32Value_, bool bNegative_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ENS_SELECTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ENS_SELECTStart& operator = (const FID_DAB_S_ENS_SELECTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ENS_SELECTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ENS_SELECTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ENS_SELECTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ENS_SELECTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectMode"

    static const int kSelectMode = 0;

    /**
     * Clears the field "SelectMode".
     *
     * The field will be set to its default value. The hasSelectMode()
     * method will return false.
     */
    inline void clearSelectMode();

    /**
     * Checks whether the field "SelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectMode()). Otherwise it will return false.
     */
    inline bool hasSelectMode () const;

    /**
     * Returns the value of the member "SelectMode".
     *
     * .
     *
     * @return The value of the field "SelectMode"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_EnsSelectMode getSelectMode () const;

    /**
     * Sets the value of the member "SelectMode".
     *
     * .
     *
     * @param SelectMode The value which will be set
     */
    inline void setSelectMode (::dabtuner_main_fi_types::T_e8_DAB_EnsSelectMode SelectMode_);

    // API of field "u32Value"

    static const int kU32Value = 1;

    /**
     * Clears the field "u32Value".
     *
     * The field will be set to its default value. The hasU32Value()
     * method will return false.
     */
    inline void clearU32Value();

    /**
     * Checks whether the field "u32Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value()). Otherwise it will return false.
     */
    inline bool hasU32Value () const;

    /**
     * Returns the value of the member "u32Value".
     *
     * EnsID, listID or steps
     *
     * @return The value of the field "u32Value"
     */
    inline uint32 getU32Value () const;

    /**
     * Sets the value of the member "u32Value".
     *
     * EnsID, listID or steps
     *
     * @param u32Value The value which will be set
     */
    inline void setU32Value (uint32 u32Value_);

    // API of field "bNegative"

    static const int kBNegative = 2;

    /**
     * Clears the field "bNegative".
     *
     * The field will be set to its default value. The hasBNegative()
     * method will return false.
     */
    inline void clearBNegative();

    /**
     * Checks whether the field "bNegative" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBNegative()). Otherwise it will return false.
     */
    inline bool hasBNegative () const;

    /**
     * Returns the value of the member "bNegative".
     *
     * only for steps: negative steps
     *
     * @return The value of the field "bNegative"
     */
    inline bool getBNegative () const;

    /**
     * Sets the value of the member "bNegative".
     *
     * only for steps: negative steps
     *
     * @param bNegative The value which will be set
     */
    inline void setBNegative (bool bNegative_);

    static const FID_DAB_S_ENS_SELECTStart &getDefaultInstance();

private:

    inline void set_has_SelectMode ();

    inline void clear_has_SelectMode ();

    inline void set_has_u32Value ();

    inline void clear_has_u32Value ();

    inline void set_has_bNegative ();

    inline void clear_has_bNegative ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_EnsSelectMode _SelectMode;

    uint32 _u32Value;

    bool _bNegative;

};

/**
 * The result message of the method "FID_DAB_S_ENS_SELECT"
 * With this command a ensemble can be selected.
 * G3g: Method for HMI
 * .
 */
class FID_DAB_S_ENS_SELECTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ENS_SELECTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ENS_SELECTResult (const FID_DAB_S_ENS_SELECTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ENS_SELECTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ENS_SELECTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ENS_SELECTResult& operator = (const FID_DAB_S_ENS_SELECTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ENS_SELECTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ENS_SELECTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ENS_SELECTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ENS_SELECTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_ENS_SELECTResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_ENS_SELECT'
 */
class FID_DAB_S_ENS_SELECTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ENS_SELECTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ENS_SELECTErrorStructure (const FID_DAB_S_ENS_SELECTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ENS_SELECTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_ENS_SELECTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ENS_SELECTErrorStructure& operator = (const FID_DAB_S_ENS_SELECTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ENS_SELECTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ENS_SELECTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ENS_SELECTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ENS_SELECTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_ENS_SELECTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_ENS_SELECT'
 */
class FID_DAB_S_ENS_SELECTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_ENS_SELECTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_ENS_SELECTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_ENS_SELECTError (const FID_DAB_S_ENS_SELECTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ENS_SELECTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_ENS_SELECTError& operator = (const FID_DAB_S_ENS_SELECTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ENS_SELECTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ENS_SELECTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ENS_SELECTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ENS_SELECTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_ENS_SELECTError::FID_DAB_S_ENS_SELECTErrorField getField () const;

    inline void setField(FID_DAB_S_ENS_SELECTError::FID_DAB_S_ENS_SELECTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_ENS_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_ENS_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_ENS_SELECTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_ENS_SELECTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_ENS_SELECTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_ENS_SELECTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_ENS_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_ENS_SELECTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_ENS_SELECTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_ENS_SELECTError& rhs);

    inline void deleteData ();

    FID_DAB_S_ENS_SELECTErrorField __field;

    union {
        FID_DAB_S_ENS_SELECTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SRV_SELECT"
 * With this command a service can be selected.
 * LCN2: Method for HMI
 */
class FID_DAB_S_SRV_SELECTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SRV_SELECTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SRV_SELECTStart (const FID_DAB_S_SRV_SELECTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SRV_SELECTStart (::dabtuner_main_fi_types::T_e8_DAB_ChnSelectMode SelectMode_, uint32 u32Value_, uint16 u16Scids_, bool bNegative_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SRV_SELECTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SRV_SELECTStart& operator = (const FID_DAB_S_SRV_SELECTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SRV_SELECTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SRV_SELECTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SRV_SELECTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SRV_SELECTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectMode"

    static const int kSelectMode = 0;

    /**
     * Clears the field "SelectMode".
     *
     * The field will be set to its default value. The hasSelectMode()
     * method will return false.
     */
    inline void clearSelectMode();

    /**
     * Checks whether the field "SelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectMode()). Otherwise it will return false.
     */
    inline bool hasSelectMode () const;

    /**
     * Returns the value of the member "SelectMode".
     *
     * .
     *
     * @return The value of the field "SelectMode"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ChnSelectMode getSelectMode () const;

    /**
     * Sets the value of the member "SelectMode".
     *
     * .
     *
     * @param SelectMode The value which will be set
     */
    inline void setSelectMode (::dabtuner_main_fi_types::T_e8_DAB_ChnSelectMode SelectMode_);

    // API of field "u32Value"

    static const int kU32Value = 1;

    /**
     * Clears the field "u32Value".
     *
     * The field will be set to its default value. The hasU32Value()
     * method will return false.
     */
    inline void clearU32Value();

    /**
     * Checks whether the field "u32Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value()). Otherwise it will return false.
     */
    inline bool hasU32Value () const;

    /**
     * Returns the value of the member "u32Value".
     *
     * PSID, listID or steps
     *
     * @return The value of the field "u32Value"
     */
    inline uint32 getU32Value () const;

    /**
     * Sets the value of the member "u32Value".
     *
     * PSID, listID or steps
     *
     * @param u32Value The value which will be set
     */
    inline void setU32Value (uint32 u32Value_);

    // API of field "u16Scids"

    static const int kU16Scids = 2;

    /**
     * Clears the field "u16Scids".
     *
     * The field will be set to its default value. The hasU16Scids()
     * method will return false.
     */
    inline void clearU16Scids();

    /**
     * Checks whether the field "u16Scids" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16Scids()). Otherwise it will return false.
     */
    inline bool hasU16Scids () const;

    /**
     * Returns the value of the member "u16Scids".
     *
     * SCIDS, Secondary Component Id
     *
     * @return The value of the field "u16Scids"
     */
    inline uint16 getU16Scids () const;

    /**
     * Sets the value of the member "u16Scids".
     *
     * SCIDS, Secondary Component Id
     *
     * @param u16Scids The value which will be set
     */
    inline void setU16Scids (uint16 u16Scids_);

    // API of field "bNegative"

    static const int kBNegative = 3;

    /**
     * Clears the field "bNegative".
     *
     * The field will be set to its default value. The hasBNegative()
     * method will return false.
     */
    inline void clearBNegative();

    /**
     * Checks whether the field "bNegative" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBNegative()). Otherwise it will return false.
     */
    inline bool hasBNegative () const;

    /**
     * Returns the value of the member "bNegative".
     *
     * only for steps: negative steps
     *
     * @return The value of the field "bNegative"
     */
    inline bool getBNegative () const;

    /**
     * Sets the value of the member "bNegative".
     *
     * only for steps: negative steps
     *
     * @param bNegative The value which will be set
     */
    inline void setBNegative (bool bNegative_);

    static const FID_DAB_S_SRV_SELECTStart &getDefaultInstance();

private:

    inline void set_has_SelectMode ();

    inline void clear_has_SelectMode ();

    inline void set_has_u32Value ();

    inline void clear_has_u32Value ();

    inline void set_has_u16Scids ();

    inline void clear_has_u16Scids ();

    inline void set_has_bNegative ();

    inline void clear_has_bNegative ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_ChnSelectMode _SelectMode;

    uint32 _u32Value;

    uint16 _u16Scids;

    bool _bNegative;

};

/**
 * The result message of the method "FID_DAB_S_SRV_SELECT"
 * With this command a service can be selected.
 * LCN2: Method for HMI
 * .
 */
class FID_DAB_S_SRV_SELECTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SRV_SELECTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SRV_SELECTResult (const FID_DAB_S_SRV_SELECTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SRV_SELECTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SRV_SELECTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SRV_SELECTResult& operator = (const FID_DAB_S_SRV_SELECTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SRV_SELECTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SRV_SELECTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SRV_SELECTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SRV_SELECTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SRV_SELECTResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SRV_SELECT'
 */
class FID_DAB_S_SRV_SELECTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SRV_SELECTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SRV_SELECTErrorStructure (const FID_DAB_S_SRV_SELECTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SRV_SELECTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SRV_SELECTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SRV_SELECTErrorStructure& operator = (const FID_DAB_S_SRV_SELECTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SRV_SELECTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SRV_SELECTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SRV_SELECTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SRV_SELECTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SRV_SELECTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SRV_SELECT'
 */
class FID_DAB_S_SRV_SELECTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SRV_SELECTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SRV_SELECTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SRV_SELECTError (const FID_DAB_S_SRV_SELECTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SRV_SELECTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SRV_SELECTError& operator = (const FID_DAB_S_SRV_SELECTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SRV_SELECTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SRV_SELECTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SRV_SELECTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SRV_SELECTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SRV_SELECTError::FID_DAB_S_SRV_SELECTErrorField getField () const;

    inline void setField(FID_DAB_S_SRV_SELECTError::FID_DAB_S_SRV_SELECTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SRV_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SRV_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SRV_SELECTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SRV_SELECTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SRV_SELECTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SRV_SELECTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SRV_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SRV_SELECTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SRV_SELECTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SRV_SELECTError& rhs);

    inline void deleteData ();

    FID_DAB_S_SRV_SELECTErrorField __field;

    union {
        FID_DAB_S_SRV_SELECTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_COMP_SELECT"
 * With this command a component can be selected.
 * LCN2: Method for HMI
 */
class FID_DAB_S_COMP_SELECTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_COMP_SELECTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_COMP_SELECTStart (const FID_DAB_S_COMP_SELECTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_COMP_SELECTStart (::dabtuner_main_fi_types::T_e8_DAB_CompSelectMode SelectMode_, uint32 u32Value_, bool bNegative_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_COMP_SELECTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_COMP_SELECTStart& operator = (const FID_DAB_S_COMP_SELECTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_COMP_SELECTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_COMP_SELECTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_COMP_SELECTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_COMP_SELECTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SelectMode"

    static const int kSelectMode = 0;

    /**
     * Clears the field "SelectMode".
     *
     * The field will be set to its default value. The hasSelectMode()
     * method will return false.
     */
    inline void clearSelectMode();

    /**
     * Checks whether the field "SelectMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSelectMode()). Otherwise it will return false.
     */
    inline bool hasSelectMode () const;

    /**
     * Returns the value of the member "SelectMode".
     *
     * .
     *
     * @return The value of the field "SelectMode"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_CompSelectMode getSelectMode () const;

    /**
     * Sets the value of the member "SelectMode".
     *
     * .
     *
     * @param SelectMode The value which will be set
     */
    inline void setSelectMode (::dabtuner_main_fi_types::T_e8_DAB_CompSelectMode SelectMode_);

    // API of field "u32Value"

    static const int kU32Value = 1;

    /**
     * Clears the field "u32Value".
     *
     * The field will be set to its default value. The hasU32Value()
     * method will return false.
     */
    inline void clearU32Value();

    /**
     * Checks whether the field "u32Value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value()). Otherwise it will return false.
     */
    inline bool hasU32Value () const;

    /**
     * Returns the value of the member "u32Value".
     *
     * PSDI, listID or steps
     *
     * @return The value of the field "u32Value"
     */
    inline uint32 getU32Value () const;

    /**
     * Sets the value of the member "u32Value".
     *
     * PSDI, listID or steps
     *
     * @param u32Value The value which will be set
     */
    inline void setU32Value (uint32 u32Value_);

    // API of field "bNegative"

    static const int kBNegative = 2;

    /**
     * Clears the field "bNegative".
     *
     * The field will be set to its default value. The hasBNegative()
     * method will return false.
     */
    inline void clearBNegative();

    /**
     * Checks whether the field "bNegative" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBNegative()). Otherwise it will return false.
     */
    inline bool hasBNegative () const;

    /**
     * Returns the value of the member "bNegative".
     *
     * only for steps: negative steps
     *
     * @return The value of the field "bNegative"
     */
    inline bool getBNegative () const;

    /**
     * Sets the value of the member "bNegative".
     *
     * only for steps: negative steps
     *
     * @param bNegative The value which will be set
     */
    inline void setBNegative (bool bNegative_);

    static const FID_DAB_S_COMP_SELECTStart &getDefaultInstance();

private:

    inline void set_has_SelectMode ();

    inline void clear_has_SelectMode ();

    inline void set_has_u32Value ();

    inline void clear_has_u32Value ();

    inline void set_has_bNegative ();

    inline void clear_has_bNegative ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_CompSelectMode _SelectMode;

    uint32 _u32Value;

    bool _bNegative;

};

/**
 * The result message of the method "FID_DAB_S_COMP_SELECT"
 * With this command a component can be selected.
 * LCN2: Method for HMI
 * .
 */
class FID_DAB_S_COMP_SELECTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_COMP_SELECTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_COMP_SELECTResult (const FID_DAB_S_COMP_SELECTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_COMP_SELECTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_COMP_SELECTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_COMP_SELECTResult& operator = (const FID_DAB_S_COMP_SELECTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_COMP_SELECTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_COMP_SELECTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_COMP_SELECTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_COMP_SELECTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_COMP_SELECTResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_COMP_SELECT'
 */
class FID_DAB_S_COMP_SELECTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_COMP_SELECTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_COMP_SELECTErrorStructure (const FID_DAB_S_COMP_SELECTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_COMP_SELECTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_COMP_SELECTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_COMP_SELECTErrorStructure& operator = (const FID_DAB_S_COMP_SELECTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_COMP_SELECTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_COMP_SELECTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_COMP_SELECTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_COMP_SELECTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_COMP_SELECTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_COMP_SELECT'
 */
class FID_DAB_S_COMP_SELECTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_COMP_SELECTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_COMP_SELECTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_COMP_SELECTError (const FID_DAB_S_COMP_SELECTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_COMP_SELECTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_COMP_SELECTError& operator = (const FID_DAB_S_COMP_SELECTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_COMP_SELECTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_COMP_SELECTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_COMP_SELECTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_COMP_SELECTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_COMP_SELECTError::FID_DAB_S_COMP_SELECTErrorField getField () const;

    inline void setField(FID_DAB_S_COMP_SELECTError::FID_DAB_S_COMP_SELECTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_COMP_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_COMP_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_COMP_SELECTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_COMP_SELECTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_COMP_SELECTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_COMP_SELECTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_COMP_SELECTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_COMP_SELECTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_COMP_SELECTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_COMP_SELECTError& rhs);

    inline void deleteData ();

    FID_DAB_S_COMP_SELECTErrorField __field;

    union {
        FID_DAB_S_COMP_SELECTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SOURCE_STATE"
 * With this command we set the DAB Module in Foreground or Background.
 * LCN2: method is used by Tuner-Master
 */
class FID_DAB_S_SOURCE_STATEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SOURCE_STATEStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SOURCE_STATEStart (const FID_DAB_S_SOURCE_STATEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SOURCE_STATEStart (::dabtuner_main_fi_types::T_e8_DAB_SourceState e8SourceState_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SOURCE_STATEStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SOURCE_STATEStart& operator = (const FID_DAB_S_SOURCE_STATEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SOURCE_STATEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SOURCE_STATEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SOURCE_STATEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SOURCE_STATEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8SourceState"

    static const int kE8SourceState = 0;

    /**
     * Clears the field "e8SourceState".
     *
     * The field will be set to its default value. The hasE8SourceState()
     * method will return false.
     */
    inline void clearE8SourceState();

    /**
     * Checks whether the field "e8SourceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SourceState()). Otherwise it will return false.
     */
    inline bool hasE8SourceState () const;

    /**
     * Returns the value of the member "e8SourceState".
     *
     * This parameter switches the source state of DAB Module according to T_e8_DAB_SourceState.
     *
     * @return The value of the field "e8SourceState"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_SourceState getE8SourceState () const;

    /**
     * Sets the value of the member "e8SourceState".
     *
     * This parameter switches the source state of DAB Module according to T_e8_DAB_SourceState.
     *
     * @param e8SourceState The value which will be set
     */
    inline void setE8SourceState (::dabtuner_main_fi_types::T_e8_DAB_SourceState e8SourceState_);

    static const FID_DAB_S_SOURCE_STATEStart &getDefaultInstance();

private:

    inline void set_has_e8SourceState ();

    inline void clear_has_e8SourceState ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_SourceState _e8SourceState;

};

/**
 * The result message of the method "FID_DAB_S_SOURCE_STATE"
 * With this command we set the DAB Module in Foreground or Background.
 * LCN2: method is used by Tuner-Master
 * .
 */
class FID_DAB_S_SOURCE_STATEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SOURCE_STATEResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SOURCE_STATEResult (const FID_DAB_S_SOURCE_STATEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SOURCE_STATEResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, ::dabtuner_main_fi_types::T_e8_DAB_SourceState e8SourceState_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SOURCE_STATEResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SOURCE_STATEResult& operator = (const FID_DAB_S_SOURCE_STATEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SOURCE_STATEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SOURCE_STATEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SOURCE_STATEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SOURCE_STATEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "e8SourceState"

    static const int kE8SourceState = 1;

    /**
     * Clears the field "e8SourceState".
     *
     * The field will be set to its default value. The hasE8SourceState()
     * method will return false.
     */
    inline void clearE8SourceState();

    /**
     * Checks whether the field "e8SourceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SourceState()). Otherwise it will return false.
     */
    inline bool hasE8SourceState () const;

    /**
     * Returns the value of the member "e8SourceState".
     *
     * This parameter switches the source state of DAB Module according to T_e8_DAB_SourceState.
     *
     * @return The value of the field "e8SourceState"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_SourceState getE8SourceState () const;

    /**
     * Sets the value of the member "e8SourceState".
     *
     * This parameter switches the source state of DAB Module according to T_e8_DAB_SourceState.
     *
     * @param e8SourceState The value which will be set
     */
    inline void setE8SourceState (::dabtuner_main_fi_types::T_e8_DAB_SourceState e8SourceState_);

    static const FID_DAB_S_SOURCE_STATEResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_e8SourceState ();

    inline void clear_has_e8SourceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    ::dabtuner_main_fi_types::T_e8_DAB_SourceState _e8SourceState;

};

/**
 * The error message of 'FID_DAB_S_SOURCE_STATE'
 */
class FID_DAB_S_SOURCE_STATEErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SOURCE_STATEErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SOURCE_STATEErrorStructure (const FID_DAB_S_SOURCE_STATEErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SOURCE_STATEErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SOURCE_STATEErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SOURCE_STATEErrorStructure& operator = (const FID_DAB_S_SOURCE_STATEErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SOURCE_STATEErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SOURCE_STATEErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SOURCE_STATEErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SOURCE_STATEErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SOURCE_STATEErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SOURCE_STATE'
 */
class FID_DAB_S_SOURCE_STATEError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SOURCE_STATEErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SOURCE_STATEError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SOURCE_STATEError (const FID_DAB_S_SOURCE_STATEError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SOURCE_STATEError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SOURCE_STATEError& operator = (const FID_DAB_S_SOURCE_STATEError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SOURCE_STATEError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SOURCE_STATEError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SOURCE_STATEError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SOURCE_STATEError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SOURCE_STATEError::FID_DAB_S_SOURCE_STATEErrorField getField () const;

    inline void setField(FID_DAB_S_SOURCE_STATEError::FID_DAB_S_SOURCE_STATEErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SOURCE_STATEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SOURCE_STATEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SOURCE_STATEErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SOURCE_STATEErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SOURCE_STATEErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SOURCE_STATEErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SOURCE_STATEErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SOURCE_STATEErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SOURCE_STATEError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SOURCE_STATEError& rhs);

    inline void deleteData ();

    FID_DAB_S_SOURCE_STATEErrorField __field;

    union {
        FID_DAB_S_SOURCE_STATEErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "FID_DAB_S_GET_FIELDSTRENGTH"
 * Field Strength of the current tuned service.
 * .
 */
class FID_DAB_S_GET_FIELDSTRENGTHResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHResult (const FID_DAB_S_GET_FIELDSTRENGTHResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, int8 s8FieldStrength_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_FIELDSTRENGTHResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_FIELDSTRENGTHResult& operator = (const FID_DAB_S_GET_FIELDSTRENGTHResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_FIELDSTRENGTHResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_FIELDSTRENGTHResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_FIELDSTRENGTHResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_FIELDSTRENGTHResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "s8FieldStrength"

    static const int kS8FieldStrength = 1;

    /**
     * Clears the field "s8FieldStrength".
     *
     * The field will be set to its default value. The hasS8FieldStrength()
     * method will return false.
     */
    inline void clearS8FieldStrength();

    /**
     * Checks whether the field "s8FieldStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setS8FieldStrength()). Otherwise it will return false.
     */
    inline bool hasS8FieldStrength () const;

    /**
     * Returns the value of the member "s8FieldStrength".
     *
     * Field strength in dBm
     *
     * @return The value of the field "s8FieldStrength"
     */
    inline int8 getS8FieldStrength () const;

    /**
     * Sets the value of the member "s8FieldStrength".
     *
     * Field strength in dBm
     *
     * @param s8FieldStrength The value which will be set
     */
    inline void setS8FieldStrength (int8 s8FieldStrength_);

    static const FID_DAB_S_GET_FIELDSTRENGTHResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_s8FieldStrength ();

    inline void clear_has_s8FieldStrength ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    int8 _s8FieldStrength;

};

/**
 * The error message of 'FID_DAB_S_GET_FIELDSTRENGTH'
 */
class FID_DAB_S_GET_FIELDSTRENGTHErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHErrorStructure (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_GET_FIELDSTRENGTHErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& operator = (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_GET_FIELDSTRENGTH'
 */
class FID_DAB_S_GET_FIELDSTRENGTHError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_GET_FIELDSTRENGTHErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_FIELDSTRENGTHError (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_FIELDSTRENGTHError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_GET_FIELDSTRENGTHError& operator = (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_GET_FIELDSTRENGTHError::FID_DAB_S_GET_FIELDSTRENGTHErrorField getField () const;

    inline void setField(FID_DAB_S_GET_FIELDSTRENGTHError::FID_DAB_S_GET_FIELDSTRENGTHErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_GET_FIELDSTRENGTHErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_GET_FIELDSTRENGTHErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_GET_FIELDSTRENGTHErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_GET_FIELDSTRENGTHErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_GET_FIELDSTRENGTHErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_GET_FIELDSTRENGTHErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_GET_FIELDSTRENGTHError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_GET_FIELDSTRENGTHError& rhs);

    inline void deleteData ();

    FID_DAB_S_GET_FIELDSTRENGTHErrorField __field;

    union {
        FID_DAB_S_GET_FIELDSTRENGTHErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SETUP"
 * Switches to configure fc_dabtuner
 * No Setups-Commands are currently supported in setup-mask
 * LCN2: Method for HMI to set concealment-level (test-mode)
 */
class FID_DAB_S_SETUPStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SETUPStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SETUPStart (const FID_DAB_S_SETUPStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SETUPStart (const ::dabtuner_main_fi_types::T_b32_DAB_SetupMask& b32SetupMask_, const ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& b32SetupFlags_, bool bUseConcealmentLevel_, uint8 u8ConcealmentLevel_, bool bUseServiceLinkingMode_, ::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_, bool bUseEnsInsertThreshold_, uint8 u8EnsInsertThreshold_, bool bUseEnsDeleteThreshold_, uint8 u8EnsDeleteThreshold_, bool bBgLearnUpdateTime_, uint8 u8BgLearnUpdateTime_, bool bDABScanThreshold_, uint8 u8DABScanThreshold_, bool bSwitchMeasurementMode_, const ::dabtuner_main_fi_types::T_b8_DAB_LinkingSetupMask& b8LinkingSetupMask_, uint8 u8DABFMLinkingThreshold_, uint8 u8DABFMLinkingBackThreshold_, uint8 u8DABFMLinkingBackValidationTime_, uint8 u8DABFMLinkBackDelay_, bool bIsTestmode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SETUPStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SETUPStart& operator = (const FID_DAB_S_SETUPStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SETUPStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SETUPStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SETUPStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SETUPStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b32SetupMask"

    static const int kB32SetupMask = 0;

    /**
     * Clears the field "b32SetupMask".
     *
     * The field will be set to its default value. The hasB32SetupMask()
     * method will return false.
     */
    inline void clearB32SetupMask();

    /**
     * Checks whether the field "b32SetupMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32SetupMask()). Otherwise it will return false.
     */
    inline bool hasB32SetupMask () const;

    /**
     * Returns the value of the member "b32SetupMask".
     *
     * Bitfield. A value of 1 indicates that the corresponding feature is to be activated or
     * deactivated (depending on the corresponding bit in b32SetupFlags).
     *
     * @return The value of the field "b32SetupMask"
     */
    inline const ::dabtuner_main_fi_types::T_b32_DAB_SetupMask& getB32SetupMask () const;

    /**
     * Retrieves the value of the field "b32SetupMask" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32SetupMask".
     */
    inline ::dabtuner_main_fi_types::T_b32_DAB_SetupMask& getB32SetupMaskMutable ();

    /**
     * Sets the value of the member "b32SetupMask".
     *
     * Bitfield. A value of 1 indicates that the corresponding feature is to be activated or
     * deactivated (depending on the corresponding bit in b32SetupFlags).
     *
     * @param b32SetupMask The value which will be set
     */
    inline void setB32SetupMask (const ::dabtuner_main_fi_types::T_b32_DAB_SetupMask& b32SetupMask_);

    // API of field "b32SetupFlags"

    static const int kB32SetupFlags = 1;

    /**
     * Clears the field "b32SetupFlags".
     *
     * The field will be set to its default value. The hasB32SetupFlags()
     * method will return false.
     */
    inline void clearB32SetupFlags();

    /**
     * Checks whether the field "b32SetupFlags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32SetupFlags()). Otherwise it will return false.
     */
    inline bool hasB32SetupFlags () const;

    /**
     * Returns the value of the member "b32SetupFlags".
     *
     * Bitfield. A value of 1 indicates that the corresponding feature is to be activated, a value
     * of 0 indicates that is to be deactivated (its configuration is to be changed only if the
     * corresponding bit in b8SetupMask is set to 1).
     *
     * @return The value of the field "b32SetupFlags"
     */
    inline const ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& getB32SetupFlags () const;

    /**
     * Retrieves the value of the field "b32SetupFlags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32SetupFlags".
     */
    inline ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& getB32SetupFlagsMutable ();

    /**
     * Sets the value of the member "b32SetupFlags".
     *
     * Bitfield. A value of 1 indicates that the corresponding feature is to be activated, a value
     * of 0 indicates that is to be deactivated (its configuration is to be changed only if the
     * corresponding bit in b8SetupMask is set to 1).
     *
     * @param b32SetupFlags The value which will be set
     */
    inline void setB32SetupFlags (const ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& b32SetupFlags_);

    // API of field "bUseConcealmentLevel"

    static const int kBUseConcealmentLevel = 2;

    /**
     * Clears the field "bUseConcealmentLevel".
     *
     * The field will be set to its default value. The hasBUseConcealmentLevel()
     * method will return false.
     */
    inline void clearBUseConcealmentLevel();

    /**
     * Checks whether the field "bUseConcealmentLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUseConcealmentLevel()). Otherwise it will return false.
     */
    inline bool hasBUseConcealmentLevel () const;

    /**
     * Returns the value of the member "bUseConcealmentLevel".
     *
     * TRUE if following concealment-level shall be applied
     *
     * @return The value of the field "bUseConcealmentLevel"
     */
    inline bool getBUseConcealmentLevel () const;

    /**
     * Sets the value of the member "bUseConcealmentLevel".
     *
     * TRUE if following concealment-level shall be applied
     *
     * @param bUseConcealmentLevel The value which will be set
     */
    inline void setBUseConcealmentLevel (bool bUseConcealmentLevel_);

    // API of field "u8ConcealmentLevel"

    static const int kU8ConcealmentLevel = 3;

    /**
     * Clears the field "u8ConcealmentLevel".
     *
     * The field will be set to its default value. The hasU8ConcealmentLevel()
     * method will return false.
     */
    inline void clearU8ConcealmentLevel();

    /**
     * Checks whether the field "u8ConcealmentLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ConcealmentLevel()). Otherwise it will return false.
     */
    inline bool hasU8ConcealmentLevel () const;

    /**
     * Returns the value of the member "u8ConcealmentLevel".
     *
     * The concealmentLevel according to Meca (range=0...7)
     *
     * @return The value of the field "u8ConcealmentLevel"
     */
    inline uint8 getU8ConcealmentLevel () const;

    /**
     * Sets the value of the member "u8ConcealmentLevel".
     *
     * The concealmentLevel according to Meca (range=0...7)
     *
     * @param u8ConcealmentLevel The value which will be set
     */
    inline void setU8ConcealmentLevel (uint8 u8ConcealmentLevel_);

    // API of field "bUseServiceLinkingMode"

    static const int kBUseServiceLinkingMode = 4;

    /**
     * Clears the field "bUseServiceLinkingMode".
     *
     * The field will be set to its default value. The hasBUseServiceLinkingMode()
     * method will return false.
     */
    inline void clearBUseServiceLinkingMode();

    /**
     * Checks whether the field "bUseServiceLinkingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUseServiceLinkingMode()). Otherwise it will return false.
     */
    inline bool hasBUseServiceLinkingMode () const;

    /**
     * Returns the value of the member "bUseServiceLinkingMode".
     *
     * TRUE if following servicelinking-mode shall be applied
     *
     * @return The value of the field "bUseServiceLinkingMode"
     */
    inline bool getBUseServiceLinkingMode () const;

    /**
     * Sets the value of the member "bUseServiceLinkingMode".
     *
     * TRUE if following servicelinking-mode shall be applied
     *
     * @param bUseServiceLinkingMode The value which will be set
     */
    inline void setBUseServiceLinkingMode (bool bUseServiceLinkingMode_);

    // API of field "e8ServiceLinkingMode"

    static const int kE8ServiceLinkingMode = 5;

    /**
     * Clears the field "e8ServiceLinkingMode".
     *
     * The field will be set to its default value. The hasE8ServiceLinkingMode()
     * method will return false.
     */
    inline void clearE8ServiceLinkingMode();

    /**
     * Checks whether the field "e8ServiceLinkingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceLinkingMode()). Otherwise it will return false.
     */
    inline bool hasE8ServiceLinkingMode () const;

    /**
     * Returns the value of the member "e8ServiceLinkingMode".
     *
     * The ServiceLinkingMode llows cross-referencing to other modes of
     * reception of the same programme, such as FM and other DAB ensembles.
     *
     * @return The value of the field "e8ServiceLinkingMode"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode getE8ServiceLinkingMode () const;

    /**
     * Sets the value of the member "e8ServiceLinkingMode".
     *
     * The ServiceLinkingMode llows cross-referencing to other modes of
     * reception of the same programme, such as FM and other DAB ensembles.
     *
     * @param e8ServiceLinkingMode The value which will be set
     */
    inline void setE8ServiceLinkingMode (::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_);

    // API of field "bUseEnsInsertThreshold"

    static const int kBUseEnsInsertThreshold = 6;

    /**
     * Clears the field "bUseEnsInsertThreshold".
     *
     * The field will be set to its default value. The hasBUseEnsInsertThreshold()
     * method will return false.
     */
    inline void clearBUseEnsInsertThreshold();

    /**
     * Checks whether the field "bUseEnsInsertThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUseEnsInsertThreshold()). Otherwise it will return false.
     */
    inline bool hasBUseEnsInsertThreshold () const;

    /**
     * Returns the value of the member "bUseEnsInsertThreshold".
     *
     * TRUE if following Ensemble Insertion Threshold shall be applied
     *
     * @return The value of the field "bUseEnsInsertThreshold"
     */
    inline bool getBUseEnsInsertThreshold () const;

    /**
     * Sets the value of the member "bUseEnsInsertThreshold".
     *
     * TRUE if following Ensemble Insertion Threshold shall be applied
     *
     * @param bUseEnsInsertThreshold The value which will be set
     */
    inline void setBUseEnsInsertThreshold (bool bUseEnsInsertThreshold_);

    // API of field "u8EnsInsertThreshold"

    static const int kU8EnsInsertThreshold = 7;

    /**
     * Clears the field "u8EnsInsertThreshold".
     *
     * The field will be set to its default value. The hasU8EnsInsertThreshold()
     * method will return false.
     */
    inline void clearU8EnsInsertThreshold();

    /**
     * Checks whether the field "u8EnsInsertThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EnsInsertThreshold()). Otherwise it will return false.
     */
    inline bool hasU8EnsInsertThreshold () const;

    /**
     * Returns the value of the member "u8EnsInsertThreshold".
     *
     * The threshold for insertion of an ensemble into the HMI ensemble-list (range=00..99)
     *
     * @return The value of the field "u8EnsInsertThreshold"
     */
    inline uint8 getU8EnsInsertThreshold () const;

    /**
     * Sets the value of the member "u8EnsInsertThreshold".
     *
     * The threshold for insertion of an ensemble into the HMI ensemble-list (range=00..99)
     *
     * @param u8EnsInsertThreshold The value which will be set
     */
    inline void setU8EnsInsertThreshold (uint8 u8EnsInsertThreshold_);

    // API of field "bUseEnsDeleteThreshold"

    static const int kBUseEnsDeleteThreshold = 8;

    /**
     * Clears the field "bUseEnsDeleteThreshold".
     *
     * The field will be set to its default value. The hasBUseEnsDeleteThreshold()
     * method will return false.
     */
    inline void clearBUseEnsDeleteThreshold();

    /**
     * Checks whether the field "bUseEnsDeleteThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUseEnsDeleteThreshold()). Otherwise it will return false.
     */
    inline bool hasBUseEnsDeleteThreshold () const;

    /**
     * Returns the value of the member "bUseEnsDeleteThreshold".
     *
     * TRUE if following Ensemble Deletion Threshold shall be applied
     *
     * @return The value of the field "bUseEnsDeleteThreshold"
     */
    inline bool getBUseEnsDeleteThreshold () const;

    /**
     * Sets the value of the member "bUseEnsDeleteThreshold".
     *
     * TRUE if following Ensemble Deletion Threshold shall be applied
     *
     * @param bUseEnsDeleteThreshold The value which will be set
     */
    inline void setBUseEnsDeleteThreshold (bool bUseEnsDeleteThreshold_);

    // API of field "u8EnsDeleteThreshold"

    static const int kU8EnsDeleteThreshold = 9;

    /**
     * Clears the field "u8EnsDeleteThreshold".
     *
     * The field will be set to its default value. The hasU8EnsDeleteThreshold()
     * method will return false.
     */
    inline void clearU8EnsDeleteThreshold();

    /**
     * Checks whether the field "u8EnsDeleteThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EnsDeleteThreshold()). Otherwise it will return false.
     */
    inline bool hasU8EnsDeleteThreshold () const;

    /**
     * Returns the value of the member "u8EnsDeleteThreshold".
     *
     * The threshold for removing of an ensemble from the HMI ensemble-list  (range=00..99)
     *
     * @return The value of the field "u8EnsDeleteThreshold"
     */
    inline uint8 getU8EnsDeleteThreshold () const;

    /**
     * Sets the value of the member "u8EnsDeleteThreshold".
     *
     * The threshold for removing of an ensemble from the HMI ensemble-list  (range=00..99)
     *
     * @param u8EnsDeleteThreshold The value which will be set
     */
    inline void setU8EnsDeleteThreshold (uint8 u8EnsDeleteThreshold_);

    // API of field "bBgLearnUpdateTime"

    static const int kBBgLearnUpdateTime = 10;

    /**
     * Clears the field "bBgLearnUpdateTime".
     *
     * The field will be set to its default value. The hasBBgLearnUpdateTime()
     * method will return false.
     */
    inline void clearBBgLearnUpdateTime();

    /**
     * Checks whether the field "bBgLearnUpdateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBBgLearnUpdateTime()). Otherwise it will return false.
     */
    inline bool hasBBgLearnUpdateTime () const;

    /**
     * Returns the value of the member "bBgLearnUpdateTime".
     *
     * TRUE if following Bg Learn Update Time shall be applied
     *
     * @return The value of the field "bBgLearnUpdateTime"
     */
    inline bool getBBgLearnUpdateTime () const;

    /**
     * Sets the value of the member "bBgLearnUpdateTime".
     *
     * TRUE if following Bg Learn Update Time shall be applied
     *
     * @param bBgLearnUpdateTime The value which will be set
     */
    inline void setBBgLearnUpdateTime (bool bBgLearnUpdateTime_);

    // API of field "u8BgLearnUpdateTime"

    static const int kU8BgLearnUpdateTime = 11;

    /**
     * Clears the field "u8BgLearnUpdateTime".
     *
     * The field will be set to its default value. The hasU8BgLearnUpdateTime()
     * method will return false.
     */
    inline void clearU8BgLearnUpdateTime();

    /**
     * Checks whether the field "u8BgLearnUpdateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BgLearnUpdateTime()). Otherwise it will return false.
     */
    inline bool hasU8BgLearnUpdateTime () const;

    /**
     * Returns the value of the member "u8BgLearnUpdateTime".
     *
     * The Background learn update time   (range=0..100 sec)
     *
     * @return The value of the field "u8BgLearnUpdateTime"
     */
    inline uint8 getU8BgLearnUpdateTime () const;

    /**
     * Sets the value of the member "u8BgLearnUpdateTime".
     *
     * The Background learn update time   (range=0..100 sec)
     *
     * @param u8BgLearnUpdateTime The value which will be set
     */
    inline void setU8BgLearnUpdateTime (uint8 u8BgLearnUpdateTime_);

    // API of field "bDABScanThreshold"

    static const int kBDABScanThreshold = 12;

    /**
     * Clears the field "bDABScanThreshold".
     *
     * The field will be set to its default value. The hasBDABScanThreshold()
     * method will return false.
     */
    inline void clearBDABScanThreshold();

    /**
     * Checks whether the field "bDABScanThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDABScanThreshold()). Otherwise it will return false.
     */
    inline bool hasBDABScanThreshold () const;

    /**
     * Returns the value of the member "bDABScanThreshold".
     *
     * TRUE if following DAB Scan Threshold shall be applied
     *
     * @return The value of the field "bDABScanThreshold"
     */
    inline bool getBDABScanThreshold () const;

    /**
     * Sets the value of the member "bDABScanThreshold".
     *
     * TRUE if following DAB Scan Threshold shall be applied
     *
     * @param bDABScanThreshold The value which will be set
     */
    inline void setBDABScanThreshold (bool bDABScanThreshold_);

    // API of field "u8DABScanThreshold"

    static const int kU8DABScanThreshold = 13;

    /**
     * Clears the field "u8DABScanThreshold".
     *
     * The field will be set to its default value. The hasU8DABScanThreshold()
     * method will return false.
     */
    inline void clearU8DABScanThreshold();

    /**
     * Checks whether the field "u8DABScanThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABScanThreshold()). Otherwise it will return false.
     */
    inline bool hasU8DABScanThreshold () const;

    /**
     * Returns the value of the member "u8DABScanThreshold".
     *
     * The DAB Scan Threshold
     *
     * @return The value of the field "u8DABScanThreshold"
     */
    inline uint8 getU8DABScanThreshold () const;

    /**
     * Sets the value of the member "u8DABScanThreshold".
     *
     * The DAB Scan Threshold
     *
     * @param u8DABScanThreshold The value which will be set
     */
    inline void setU8DABScanThreshold (uint8 u8DABScanThreshold_);

    // API of field "bSwitchMeasurementMode"

    static const int kBSwitchMeasurementMode = 14;

    /**
     * Clears the field "bSwitchMeasurementMode".
     *
     * The field will be set to its default value. The hasBSwitchMeasurementMode()
     * method will return false.
     */
    inline void clearBSwitchMeasurementMode();

    /**
     * Checks whether the field "bSwitchMeasurementMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSwitchMeasurementMode()). Otherwise it will return false.
     */
    inline bool hasBSwitchMeasurementMode () const;

    /**
     * Returns the value of the member "bSwitchMeasurementMode".
     *
     * TRUE=Measurement Mode has to be turned On
     * FALSE=Measurement Mode has to be turned OFF
     *
     * @return The value of the field "bSwitchMeasurementMode"
     */
    inline bool getBSwitchMeasurementMode () const;

    /**
     * Sets the value of the member "bSwitchMeasurementMode".
     *
     * TRUE=Measurement Mode has to be turned On
     * FALSE=Measurement Mode has to be turned OFF
     *
     * @param bSwitchMeasurementMode The value which will be set
     */
    inline void setBSwitchMeasurementMode (bool bSwitchMeasurementMode_);

    // API of field "b8LinkingSetupMask"

    static const int kB8LinkingSetupMask = 15;

    /**
     * Clears the field "b8LinkingSetupMask".
     *
     * The field will be set to its default value. The hasB8LinkingSetupMask()
     * method will return false.
     */
    inline void clearB8LinkingSetupMask();

    /**
     * Checks whether the field "b8LinkingSetupMask" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8LinkingSetupMask()). Otherwise it will return false.
     */
    inline bool hasB8LinkingSetupMask () const;

    /**
     * Returns the value of the member "b8LinkingSetupMask".
     *
     * Bitfield. A value of 1 indicates that the corresponding linking threshold shall be applied.
     *
     * @return The value of the field "b8LinkingSetupMask"
     */
    inline const ::dabtuner_main_fi_types::T_b8_DAB_LinkingSetupMask& getB8LinkingSetupMask () const;

    /**
     * Retrieves the value of the field "b8LinkingSetupMask" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8LinkingSetupMask".
     */
    inline ::dabtuner_main_fi_types::T_b8_DAB_LinkingSetupMask& getB8LinkingSetupMaskMutable ();

    /**
     * Sets the value of the member "b8LinkingSetupMask".
     *
     * Bitfield. A value of 1 indicates that the corresponding linking threshold shall be applied.
     *
     * @param b8LinkingSetupMask The value which will be set
     */
    inline void setB8LinkingSetupMask (const ::dabtuner_main_fi_types::T_b8_DAB_LinkingSetupMask& b8LinkingSetupMask_);

    // API of field "u8DABFMLinkingThreshold"

    static const int kU8DABFMLinkingThreshold = 16;

    /**
     * Clears the field "u8DABFMLinkingThreshold".
     *
     * The field will be set to its default value. The hasU8DABFMLinkingThreshold()
     * method will return false.
     */
    inline void clearU8DABFMLinkingThreshold();

    /**
     * Checks whether the field "u8DABFMLinkingThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkingThreshold()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkingThreshold () const;

    /**
     * Returns the value of the member "u8DABFMLinkingThreshold".
     *
     * The DAB FM linking threshold (0-100).
     *
     * @return The value of the field "u8DABFMLinkingThreshold"
     */
    inline uint8 getU8DABFMLinkingThreshold () const;

    /**
     * Sets the value of the member "u8DABFMLinkingThreshold".
     *
     * The DAB FM linking threshold (0-100).
     *
     * @param u8DABFMLinkingThreshold The value which will be set
     */
    inline void setU8DABFMLinkingThreshold (uint8 u8DABFMLinkingThreshold_);

    // API of field "u8DABFMLinkingBackThreshold"

    static const int kU8DABFMLinkingBackThreshold = 17;

    /**
     * Clears the field "u8DABFMLinkingBackThreshold".
     *
     * The field will be set to its default value. The hasU8DABFMLinkingBackThreshold()
     * method will return false.
     */
    inline void clearU8DABFMLinkingBackThreshold();

    /**
     * Checks whether the field "u8DABFMLinkingBackThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkingBackThreshold()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkingBackThreshold () const;

    /**
     * Returns the value of the member "u8DABFMLinkingBackThreshold".
     *
     * The DAB FM linking back threshold (0-100).
     *
     * @return The value of the field "u8DABFMLinkingBackThreshold"
     */
    inline uint8 getU8DABFMLinkingBackThreshold () const;

    /**
     * Sets the value of the member "u8DABFMLinkingBackThreshold".
     *
     * The DAB FM linking back threshold (0-100).
     *
     * @param u8DABFMLinkingBackThreshold The value which will be set
     */
    inline void setU8DABFMLinkingBackThreshold (uint8 u8DABFMLinkingBackThreshold_);

    // API of field "u8DABFMLinkingBackValidationTime"

    static const int kU8DABFMLinkingBackValidationTime = 18;

    /**
     * Clears the field "u8DABFMLinkingBackValidationTime".
     *
     * The field will be set to its default value. The hasU8DABFMLinkingBackValidationTime()
     * method will return false.
     */
    inline void clearU8DABFMLinkingBackValidationTime();

    /**
     * Checks whether the field "u8DABFMLinkingBackValidationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkingBackValidationTime()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkingBackValidationTime () const;

    /**
     * Returns the value of the member "u8DABFMLinkingBackValidationTime".
     *
     * The DAB-FM-linking-back-validation-time 	(0 - 5000ms)
     *
     * @return The value of the field "u8DABFMLinkingBackValidationTime"
     */
    inline uint8 getU8DABFMLinkingBackValidationTime () const;

    /**
     * Sets the value of the member "u8DABFMLinkingBackValidationTime".
     *
     * The DAB-FM-linking-back-validation-time 	(0 - 5000ms)
     *
     * @param u8DABFMLinkingBackValidationTime The value which will be set
     */
    inline void setU8DABFMLinkingBackValidationTime (uint8 u8DABFMLinkingBackValidationTime_);

    // API of field "u8DABFMLinkBackDelay"

    static const int kU8DABFMLinkBackDelay = 19;

    /**
     * Clears the field "u8DABFMLinkBackDelay".
     *
     * The field will be set to its default value. The hasU8DABFMLinkBackDelay()
     * method will return false.
     */
    inline void clearU8DABFMLinkBackDelay();

    /**
     * Checks whether the field "u8DABFMLinkBackDelay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkBackDelay()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkBackDelay () const;

    /**
     * Returns the value of the member "u8DABFMLinkBackDelay".
     *
     * The DAB-FM-link-back-delay		(0-60s)
     *
     * @return The value of the field "u8DABFMLinkBackDelay"
     */
    inline uint8 getU8DABFMLinkBackDelay () const;

    /**
     * Sets the value of the member "u8DABFMLinkBackDelay".
     *
     * The DAB-FM-link-back-delay		(0-60s)
     *
     * @param u8DABFMLinkBackDelay The value which will be set
     */
    inline void setU8DABFMLinkBackDelay (uint8 u8DABFMLinkBackDelay_);

    // API of field "bIsTestmode"

    static const int kBIsTestmode = 20;

    /**
     * Clears the field "bIsTestmode".
     *
     * The field will be set to its default value. The hasBIsTestmode()
     * method will return false.
     */
    inline void clearBIsTestmode();

    /**
     * Checks whether the field "bIsTestmode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsTestmode()). Otherwise it will return false.
     */
    inline bool hasBIsTestmode () const;

    /**
     * Returns the value of the member "bIsTestmode".
     *
     * TRUE - Testmode is active.
     * FALSE - Testmode is not active.
     * The default value is FALSE.
     *
     * @return The value of the field "bIsTestmode"
     */
    inline bool getBIsTestmode () const;

    /**
     * Sets the value of the member "bIsTestmode".
     *
     * TRUE - Testmode is active.
     * FALSE - Testmode is not active.
     * The default value is FALSE.
     *
     * @param bIsTestmode The value which will be set
     */
    inline void setBIsTestmode (bool bIsTestmode_);

    static const FID_DAB_S_SETUPStart &getDefaultInstance();

private:

    inline void set_has_b32SetupMask ();

    inline void clear_has_b32SetupMask ();

    inline void set_has_b32SetupFlags ();

    inline void clear_has_b32SetupFlags ();

    inline void set_has_bUseConcealmentLevel ();

    inline void clear_has_bUseConcealmentLevel ();

    inline void set_has_u8ConcealmentLevel ();

    inline void clear_has_u8ConcealmentLevel ();

    inline void set_has_bUseServiceLinkingMode ();

    inline void clear_has_bUseServiceLinkingMode ();

    inline void set_has_e8ServiceLinkingMode ();

    inline void clear_has_e8ServiceLinkingMode ();

    inline void set_has_bUseEnsInsertThreshold ();

    inline void clear_has_bUseEnsInsertThreshold ();

    inline void set_has_u8EnsInsertThreshold ();

    inline void clear_has_u8EnsInsertThreshold ();

    inline void set_has_bUseEnsDeleteThreshold ();

    inline void clear_has_bUseEnsDeleteThreshold ();

    inline void set_has_u8EnsDeleteThreshold ();

    inline void clear_has_u8EnsDeleteThreshold ();

    inline void set_has_bBgLearnUpdateTime ();

    inline void clear_has_bBgLearnUpdateTime ();

    inline void set_has_u8BgLearnUpdateTime ();

    inline void clear_has_u8BgLearnUpdateTime ();

    inline void set_has_bDABScanThreshold ();

    inline void clear_has_bDABScanThreshold ();

    inline void set_has_u8DABScanThreshold ();

    inline void clear_has_u8DABScanThreshold ();

    inline void set_has_bSwitchMeasurementMode ();

    inline void clear_has_bSwitchMeasurementMode ();

    inline void set_has_b8LinkingSetupMask ();

    inline void clear_has_b8LinkingSetupMask ();

    inline void set_has_u8DABFMLinkingThreshold ();

    inline void clear_has_u8DABFMLinkingThreshold ();

    inline void set_has_u8DABFMLinkingBackThreshold ();

    inline void clear_has_u8DABFMLinkingBackThreshold ();

    inline void set_has_u8DABFMLinkingBackValidationTime ();

    inline void clear_has_u8DABFMLinkingBackValidationTime ();

    inline void set_has_u8DABFMLinkBackDelay ();

    inline void clear_has_u8DABFMLinkBackDelay ();

    inline void set_has_bIsTestmode ();

    inline void clear_has_bIsTestmode ();

    uint32 _has_bits_[ (21 + 31) / 32];

    ::dabtuner_main_fi_types::T_b32_DAB_SetupMask _b32SetupMask;

    ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags _b32SetupFlags;

    bool _bUseConcealmentLevel;

    uint8 _u8ConcealmentLevel;

    bool _bUseServiceLinkingMode;

    ::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode _e8ServiceLinkingMode;

    bool _bUseEnsInsertThreshold;

    uint8 _u8EnsInsertThreshold;

    bool _bUseEnsDeleteThreshold;

    uint8 _u8EnsDeleteThreshold;

    bool _bBgLearnUpdateTime;

    uint8 _u8BgLearnUpdateTime;

    bool _bDABScanThreshold;

    uint8 _u8DABScanThreshold;

    bool _bSwitchMeasurementMode;

    ::dabtuner_main_fi_types::T_b8_DAB_LinkingSetupMask _b8LinkingSetupMask;

    uint8 _u8DABFMLinkingThreshold;

    uint8 _u8DABFMLinkingBackThreshold;

    uint8 _u8DABFMLinkingBackValidationTime;

    uint8 _u8DABFMLinkBackDelay;

    bool _bIsTestmode;

};

/**
 * The result message of the method "FID_DAB_S_SETUP"
 * Switches to configure fc_dabtuner
 * No Setups-Commands are currently supported in setup-mask
 * LCN2: Method for HMI to set concealment-level (test-mode)
 */
class FID_DAB_S_SETUPResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SETUPResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SETUPResult (const FID_DAB_S_SETUPResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SETUPResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SETUPResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SETUPResult& operator = (const FID_DAB_S_SETUPResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SETUPResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SETUPResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SETUPResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SETUPResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SETUPResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SETUP'
 */
class FID_DAB_S_SETUPErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SETUPErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SETUPErrorStructure (const FID_DAB_S_SETUPErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SETUPErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SETUPErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SETUPErrorStructure& operator = (const FID_DAB_S_SETUPErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SETUPErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SETUPErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SETUPErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SETUPErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SETUPErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SETUP'
 */
class FID_DAB_S_SETUPError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SETUPErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SETUPError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SETUPError (const FID_DAB_S_SETUPError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SETUPError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SETUPError& operator = (const FID_DAB_S_SETUPError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SETUPError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SETUPError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SETUPError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SETUPError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SETUPError::FID_DAB_S_SETUPErrorField getField () const;

    inline void setField(FID_DAB_S_SETUPError::FID_DAB_S_SETUPErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SETUPErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SETUPErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SETUPErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SETUPErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SETUPErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SETUPErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SETUPErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SETUPErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SETUPError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SETUPError& rhs);

    inline void deleteData ();

    FID_DAB_S_SETUPErrorField __field;

    union {
        FID_DAB_S_SETUPErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_ANNO_CONFIG"
 * Configure handling of announcements
 * LCN2: Method for TunerMaster
 */
class FID_DAB_S_ANNO_CONFIGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGStart (const FID_DAB_S_ANNO_CONFIGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGStart (const ::dabtuner_main_fi_types::T_DAB_AnnoConfig& AnnoConfig_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ANNO_CONFIGStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ANNO_CONFIGStart& operator = (const FID_DAB_S_ANNO_CONFIGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ANNO_CONFIGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ANNO_CONFIGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ANNO_CONFIGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ANNO_CONFIGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AnnoConfig"

    static const int kAnnoConfig = 0;

    /**
     * Clears the field "AnnoConfig".
     *
     * The field will be set to its default value. The hasAnnoConfig()
     * method will return false.
     */
    inline void clearAnnoConfig();

    /**
     * Checks whether the field "AnnoConfig" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoConfig()). Otherwise it will return false.
     */
    inline bool hasAnnoConfig () const;

    /**
     * Returns the value of the member "AnnoConfig".
     *
     * Configures types and source of announcements to be selected.
     *
     * @return The value of the field "AnnoConfig"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_AnnoConfig& getAnnoConfig () const;

    /**
     * Retrieves the value of the field "AnnoConfig" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoConfig".
     */
    inline ::dabtuner_main_fi_types::T_DAB_AnnoConfig& getAnnoConfigMutable ();

    /**
     * Sets the value of the member "AnnoConfig".
     *
     * Configures types and source of announcements to be selected.
     *
     * @param AnnoConfig The value which will be set
     */
    inline void setAnnoConfig (const ::dabtuner_main_fi_types::T_DAB_AnnoConfig& AnnoConfig_);

    static const FID_DAB_S_ANNO_CONFIGStart &getDefaultInstance();

private:

    inline void set_has_AnnoConfig ();

    inline void clear_has_AnnoConfig ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_AnnoConfig _AnnoConfig;

};

/**
 * The result message of the method "FID_DAB_S_ANNO_CONFIG"
 * Configure handling of announcements
 * LCN2: Method for TunerMaster
 */
class FID_DAB_S_ANNO_CONFIGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGResult (const FID_DAB_S_ANNO_CONFIGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ANNO_CONFIGResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ANNO_CONFIGResult& operator = (const FID_DAB_S_ANNO_CONFIGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ANNO_CONFIGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ANNO_CONFIGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ANNO_CONFIGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ANNO_CONFIGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_ANNO_CONFIGResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_ANNO_CONFIG'
 */
class FID_DAB_S_ANNO_CONFIGErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGErrorStructure (const FID_DAB_S_ANNO_CONFIGErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_ANNO_CONFIGErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ANNO_CONFIGErrorStructure& operator = (const FID_DAB_S_ANNO_CONFIGErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ANNO_CONFIGErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ANNO_CONFIGErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ANNO_CONFIGErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ANNO_CONFIGErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_ANNO_CONFIGErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_ANNO_CONFIG'
 */
class FID_DAB_S_ANNO_CONFIGError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_ANNO_CONFIGErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_ANNO_CONFIGError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_ANNO_CONFIGError (const FID_DAB_S_ANNO_CONFIGError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ANNO_CONFIGError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_ANNO_CONFIGError& operator = (const FID_DAB_S_ANNO_CONFIGError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ANNO_CONFIGError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ANNO_CONFIGError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ANNO_CONFIGError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ANNO_CONFIGError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_ANNO_CONFIGError::FID_DAB_S_ANNO_CONFIGErrorField getField () const;

    inline void setField(FID_DAB_S_ANNO_CONFIGError::FID_DAB_S_ANNO_CONFIGErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_ANNO_CONFIGErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_ANNO_CONFIGErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_ANNO_CONFIGErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_ANNO_CONFIGErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_ANNO_CONFIGErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_ANNO_CONFIGErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_ANNO_CONFIGErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_ANNO_CONFIGErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_ANNO_CONFIGError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_ANNO_CONFIGError& rhs);

    inline void deleteData ();

    FID_DAB_S_ANNO_CONFIGErrorField __field;

    union {
        FID_DAB_S_ANNO_CONFIGErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SELECT_ANNO"
 * selects a particular Announcement
 */
class FID_DAB_S_SELECT_ANNOStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_ANNOStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_ANNOStart (const FID_DAB_S_SELECT_ANNOStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_ANNOStart (bool bSelect_, uint16 u16AnnoNumber_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_ANNOStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_ANNOStart& operator = (const FID_DAB_S_SELECT_ANNOStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_ANNOStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_ANNOStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_ANNOStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_ANNOStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSelect"

    static const int kBSelect = 0;

    /**
     * Clears the field "bSelect".
     *
     * The field will be set to its default value. The hasBSelect()
     * method will return false.
     */
    inline void clearBSelect();

    /**
     * Checks whether the field "bSelect" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSelect()). Otherwise it will return false.
     */
    inline bool hasBSelect () const;

    /**
     * Returns the value of the member "bSelect".
     *
     * TRUE if announcement has to be selected and false if it has to be deselected
     *
     * @return The value of the field "bSelect"
     */
    inline bool getBSelect () const;

    /**
     * Sets the value of the member "bSelect".
     *
     * TRUE if announcement has to be selected and false if it has to be deselected
     *
     * @param bSelect The value which will be set
     */
    inline void setBSelect (bool bSelect_);

    // API of field "u16AnnoNumber"

    static const int kU16AnnoNumber = 1;

    /**
     * Clears the field "u16AnnoNumber".
     *
     * The field will be set to its default value. The hasU16AnnoNumber()
     * method will return false.
     */
    inline void clearU16AnnoNumber();

    /**
     * Checks whether the field "u16AnnoNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16AnnoNumber()). Otherwise it will return false.
     */
    inline bool hasU16AnnoNumber () const;

    /**
     * Returns the value of the member "u16AnnoNumber".
     *
     * Announcement that has to be selected.Available Announcements are 1- Alarm, 2- Road_traffic , 4-Transport,8-Warning, 16-News,32-Weather,64-Event,128-Specialevent
     * 256-ProgrammeInformation,512-Sport report,1024-Financial report
     *
     * @return The value of the field "u16AnnoNumber"
     */
    inline uint16 getU16AnnoNumber () const;

    /**
     * Sets the value of the member "u16AnnoNumber".
     *
     * Announcement that has to be selected.Available Announcements are 1- Alarm, 2- Road_traffic , 4-Transport,8-Warning, 16-News,32-Weather,64-Event,128-Specialevent
     * 256-ProgrammeInformation,512-Sport report,1024-Financial report
     *
     * @param u16AnnoNumber The value which will be set
     */
    inline void setU16AnnoNumber (uint16 u16AnnoNumber_);

    static const FID_DAB_S_SELECT_ANNOStart &getDefaultInstance();

private:

    inline void set_has_bSelect ();

    inline void clear_has_bSelect ();

    inline void set_has_u16AnnoNumber ();

    inline void clear_has_u16AnnoNumber ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bSelect;

    uint16 _u16AnnoNumber;

};

/**
 * The result message of the method "FID_DAB_S_SELECT_ANNO"
 * selects a particular Announcement
 */
class FID_DAB_S_SELECT_ANNOResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_ANNOResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_ANNOResult (const FID_DAB_S_SELECT_ANNOResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_ANNOResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_ANNOResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_ANNOResult& operator = (const FID_DAB_S_SELECT_ANNOResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_ANNOResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_ANNOResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_ANNOResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_ANNOResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SELECT_ANNOResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SELECT_ANNO'
 */
class FID_DAB_S_SELECT_ANNOErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_ANNOErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_ANNOErrorStructure (const FID_DAB_S_SELECT_ANNOErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_ANNOErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SELECT_ANNOErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_ANNOErrorStructure& operator = (const FID_DAB_S_SELECT_ANNOErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_ANNOErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_ANNOErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_ANNOErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_ANNOErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SELECT_ANNOErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SELECT_ANNO'
 */
class FID_DAB_S_SELECT_ANNOError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SELECT_ANNOErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SELECT_ANNOError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_ANNOError (const FID_DAB_S_SELECT_ANNOError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_ANNOError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SELECT_ANNOError& operator = (const FID_DAB_S_SELECT_ANNOError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_ANNOError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_ANNOError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_ANNOError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_ANNOError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SELECT_ANNOError::FID_DAB_S_SELECT_ANNOErrorField getField () const;

    inline void setField(FID_DAB_S_SELECT_ANNOError::FID_DAB_S_SELECT_ANNOErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SELECT_ANNOErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SELECT_ANNOErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SELECT_ANNOErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SELECT_ANNOErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SELECT_ANNOErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SELECT_ANNOErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SELECT_ANNOErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SELECT_ANNOErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SELECT_ANNOError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SELECT_ANNOError& rhs);

    inline void deleteData ();

    FID_DAB_S_SELECT_ANNOErrorField __field;

    union {
        FID_DAB_S_SELECT_ANNOErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SELECT_BANK"
 * Selects a particular Bank
 */
class FID_DAB_S_SELECT_BANKStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_BANKStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_BANKStart (const FID_DAB_S_SELECT_BANKStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_BANKStart (::dabtuner_main_fi_types::T_e8_DAB_BankList e8BankId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_BANKStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_BANKStart& operator = (const FID_DAB_S_SELECT_BANKStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_BANKStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_BANKStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_BANKStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_BANKStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8BankId"

    static const int kE8BankId = 0;

    /**
     * Clears the field "e8BankId".
     *
     * The field will be set to its default value. The hasE8BankId()
     * method will return false.
     */
    inline void clearE8BankId();

    /**
     * Checks whether the field "e8BankId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8BankId()). Otherwise it will return false.
     */
    inline bool hasE8BankId () const;

    /**
     * Returns the value of the member "e8BankId".
     *
     * This parameter indicates the DAB bank to be selected.
     *
     * @return The value of the field "e8BankId"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_BankList getE8BankId () const;

    /**
     * Sets the value of the member "e8BankId".
     *
     * This parameter indicates the DAB bank to be selected.
     *
     * @param e8BankId The value which will be set
     */
    inline void setE8BankId (::dabtuner_main_fi_types::T_e8_DAB_BankList e8BankId_);

    static const FID_DAB_S_SELECT_BANKStart &getDefaultInstance();

private:

    inline void set_has_e8BankId ();

    inline void clear_has_e8BankId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_BankList _e8BankId;

};

/**
 * The result message of the method "FID_DAB_S_SELECT_BANK"
 * Selects a particular Bank
 */
class FID_DAB_S_SELECT_BANKResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_BANKResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_BANKResult (const FID_DAB_S_SELECT_BANKResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_BANKResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_BANKResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_BANKResult& operator = (const FID_DAB_S_SELECT_BANKResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_BANKResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_BANKResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_BANKResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_BANKResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SELECT_BANKResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SELECT_BANK'
 */
class FID_DAB_S_SELECT_BANKErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_BANKErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_BANKErrorStructure (const FID_DAB_S_SELECT_BANKErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_BANKErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SELECT_BANKErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_BANKErrorStructure& operator = (const FID_DAB_S_SELECT_BANKErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_BANKErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_BANKErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_BANKErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_BANKErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SELECT_BANKErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SELECT_BANK'
 */
class FID_DAB_S_SELECT_BANKError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SELECT_BANKErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SELECT_BANKError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_BANKError (const FID_DAB_S_SELECT_BANKError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_BANKError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SELECT_BANKError& operator = (const FID_DAB_S_SELECT_BANKError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_BANKError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_BANKError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_BANKError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_BANKError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SELECT_BANKError::FID_DAB_S_SELECT_BANKErrorField getField () const;

    inline void setField(FID_DAB_S_SELECT_BANKError::FID_DAB_S_SELECT_BANKErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SELECT_BANKErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SELECT_BANKErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SELECT_BANKErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SELECT_BANKErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SELECT_BANKErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SELECT_BANKErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SELECT_BANKErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SELECT_BANKErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SELECT_BANKError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SELECT_BANKError& rhs);

    inline void deleteData ();

    FID_DAB_S_SELECT_BANKErrorField __field;

    union {
        FID_DAB_S_SELECT_BANKErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SAVE_PRESET_LIST_ELEM"
 * Saves the current DAB service to the preset list.
 * LCN2: Method for HMI
 */
class FID_DAB_S_SAVE_PRESET_LIST_ELEMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMStart (const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMStart (uint8 u8PresetElemId_, uint32 u32PSID_, uint8 u8Scids_, uint32 u32EnsFrequency_, bool bDelete_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SAVE_PRESET_LIST_ELEMStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMStart& operator = (const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8PresetElemId"

    static const int kU8PresetElemId = 0;

    /**
     * Clears the field "u8PresetElemId".
     *
     * The field will be set to its default value. The hasU8PresetElemId()
     * method will return false.
     */
    inline void clearU8PresetElemId();

    /**
     * Checks whether the field "u8PresetElemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8PresetElemId()). Otherwise it will return false.
     */
    inline bool hasU8PresetElemId () const;

    /**
     * Returns the value of the member "u8PresetElemId".
     *
     * Element ID can be the any value within range. But that range varies from project to project.
     *
     * @return The value of the field "u8PresetElemId"
     */
    inline uint8 getU8PresetElemId () const;

    /**
     * Sets the value of the member "u8PresetElemId".
     *
     * Element ID can be the any value within range. But that range varies from project to project.
     *
     * @param u8PresetElemId The value which will be set
     */
    inline void setU8PresetElemId (uint8 u8PresetElemId_);

    // API of field "u32PSID"

    static const int kU32PSID = 1;

    /**
     * Clears the field "u32PSID".
     *
     * The field will be set to its default value. The hasU32PSID()
     * method will return false.
     */
    inline void clearU32PSID();

    /**
     * Checks whether the field "u32PSID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PSID()). Otherwise it will return false.
     */
    inline bool hasU32PSID () const;

    /**
     * Returns the value of the member "u32PSID".
     *
     * PSID of Service. 0 if currently tuned service shall be stored
     *
     * @return The value of the field "u32PSID"
     */
    inline uint32 getU32PSID () const;

    /**
     * Sets the value of the member "u32PSID".
     *
     * PSID of Service. 0 if currently tuned service shall be stored
     *
     * @param u32PSID The value which will be set
     */
    inline void setU32PSID (uint32 u32PSID_);

    // API of field "u8Scids"

    static const int kU8Scids = 2;

    /**
     * Clears the field "u8Scids".
     *
     * The field will be set to its default value. The hasU8Scids()
     * method will return false.
     */
    inline void clearU8Scids();

    /**
     * Checks whether the field "u8Scids" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Scids()). Otherwise it will return false.
     */
    inline bool hasU8Scids () const;

    /**
     * Returns the value of the member "u8Scids".
     *
     * Secondary Service ID, to be used during the special preset save.
     *
     * @return The value of the field "u8Scids"
     */
    inline uint8 getU8Scids () const;

    /**
     * Sets the value of the member "u8Scids".
     *
     * Secondary Service ID, to be used during the special preset save.
     *
     * @param u8Scids The value which will be set
     */
    inline void setU8Scids (uint8 u8Scids_);

    // API of field "u32EnsFrequency"

    static const int kU32EnsFrequency = 3;

    /**
     * Clears the field "u32EnsFrequency".
     *
     * The field will be set to its default value. The hasU32EnsFrequency()
     * method will return false.
     */
    inline void clearU32EnsFrequency();

    /**
     * Checks whether the field "u32EnsFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsFrequency()). Otherwise it will return false.
     */
    inline bool hasU32EnsFrequency () const;

    /**
     * Returns the value of the member "u32EnsFrequency".
     *
     * Ensemble frequency of Service. 0 if currently tuned service shall be stored
     *
     * @return The value of the field "u32EnsFrequency"
     */
    inline uint32 getU32EnsFrequency () const;

    /**
     * Sets the value of the member "u32EnsFrequency".
     *
     * Ensemble frequency of Service. 0 if currently tuned service shall be stored
     *
     * @param u32EnsFrequency The value which will be set
     */
    inline void setU32EnsFrequency (uint32 u32EnsFrequency_);

    // API of field "bDelete"

    static const int kBDelete = 4;

    /**
     * Clears the field "bDelete".
     *
     * The field will be set to its default value. The hasBDelete()
     * method will return false.
     */
    inline void clearBDelete();

    /**
     * Checks whether the field "bDelete" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBDelete()). Otherwise it will return false.
     */
    inline bool hasBDelete () const;

    /**
     * Returns the value of the member "bDelete".
     *
     * TRUE if preset with id u8PresetElemId shall be deleted
     *
     * @return The value of the field "bDelete"
     */
    inline bool getBDelete () const;

    /**
     * Sets the value of the member "bDelete".
     *
     * TRUE if preset with id u8PresetElemId shall be deleted
     *
     * @param bDelete The value which will be set
     */
    inline void setBDelete (bool bDelete_);

    static const FID_DAB_S_SAVE_PRESET_LIST_ELEMStart &getDefaultInstance();

private:

    inline void set_has_u8PresetElemId ();

    inline void clear_has_u8PresetElemId ();

    inline void set_has_u32PSID ();

    inline void clear_has_u32PSID ();

    inline void set_has_u8Scids ();

    inline void clear_has_u8Scids ();

    inline void set_has_u32EnsFrequency ();

    inline void clear_has_u32EnsFrequency ();

    inline void set_has_bDelete ();

    inline void clear_has_bDelete ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint8 _u8PresetElemId;

    uint32 _u32PSID;

    uint8 _u8Scids;

    uint32 _u32EnsFrequency;

    bool _bDelete;

};

/**
 * The result message of the method "FID_DAB_S_SAVE_PRESET_LIST_ELEM"
 * Saves the current DAB service to the preset list.
 * LCN2: Method for HMI
 * .
 */
class FID_DAB_S_SAVE_PRESET_LIST_ELEMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMResult (const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SAVE_PRESET_LIST_ELEMResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMResult& operator = (const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SAVE_PRESET_LIST_ELEMResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SAVE_PRESET_LIST_ELEM'
 */
class FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& operator = (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SAVE_PRESET_LIST_ELEM'
 */
class FID_DAB_S_SAVE_PRESET_LIST_ELEMError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LIST_ELEMError (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SAVE_PRESET_LIST_ELEMError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMError& operator = (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMError::FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorField getField () const;

    inline void setField(FID_DAB_S_SAVE_PRESET_LIST_ELEMError::FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SAVE_PRESET_LIST_ELEMError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SAVE_PRESET_LIST_ELEMError& rhs);

    inline void deleteData ();

    FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorField __field;

    union {
        FID_DAB_S_SAVE_PRESET_LIST_ELEMErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_DELETE_PRESET_LIST_ELEM"
 * This method is used to delete the elements from the DAB preset list.
 * LCN2: Method for Diagnosis or not used
 */
class FID_DAB_S_DELETE_PRESET_LIST_ELEMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMStart (const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMStart (::dabtuner_main_fi_types::T_e8_DAB_DeleteAction e8Action_, uint8 u8DelPresetElemId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DELETE_PRESET_LIST_ELEMStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMStart& operator = (const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Action"

    static const int kE8Action = 0;

    /**
     * Clears the field "e8Action".
     *
     * The field will be set to its default value. The hasE8Action()
     * method will return false.
     */
    inline void clearE8Action();

    /**
     * Checks whether the field "e8Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Action()). Otherwise it will return false.
     */
    inline bool hasE8Action () const;

    /**
     * Returns the value of the member "e8Action".
     *
     * Deletes the elements based on selection.
     *
     * @return The value of the field "e8Action"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_DeleteAction getE8Action () const;

    /**
     * Sets the value of the member "e8Action".
     *
     * Deletes the elements based on selection.
     *
     * @param e8Action The value which will be set
     */
    inline void setE8Action (::dabtuner_main_fi_types::T_e8_DAB_DeleteAction e8Action_);

    // API of field "u8DelPresetElemId"

    static const int kU8DelPresetElemId = 1;

    /**
     * Clears the field "u8DelPresetElemId".
     *
     * The field will be set to its default value. The hasU8DelPresetElemId()
     * method will return false.
     */
    inline void clearU8DelPresetElemId();

    /**
     * Checks whether the field "u8DelPresetElemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DelPresetElemId()). Otherwise it will return false.
     */
    inline bool hasU8DelPresetElemId () const;

    /**
     * Returns the value of the member "u8DelPresetElemId".
     *
     * Element ID to delete. Content will be ignored if all elements are deleted.
     * Element ID can be the any value within range. The range varies from project to project.
     *
     * @return The value of the field "u8DelPresetElemId"
     */
    inline uint8 getU8DelPresetElemId () const;

    /**
     * Sets the value of the member "u8DelPresetElemId".
     *
     * Element ID to delete. Content will be ignored if all elements are deleted.
     * Element ID can be the any value within range. The range varies from project to project.
     *
     * @param u8DelPresetElemId The value which will be set
     */
    inline void setU8DelPresetElemId (uint8 u8DelPresetElemId_);

    static const FID_DAB_S_DELETE_PRESET_LIST_ELEMStart &getDefaultInstance();

private:

    inline void set_has_e8Action ();

    inline void clear_has_e8Action ();

    inline void set_has_u8DelPresetElemId ();

    inline void clear_has_u8DelPresetElemId ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_DeleteAction _e8Action;

    uint8 _u8DelPresetElemId;

};

/**
 * The result message of the method "FID_DAB_S_DELETE_PRESET_LIST_ELEM"
 * This method is used to delete the elements from the DAB preset list.
 * LCN2: Method for Diagnosis or not used
 * .
 */
class FID_DAB_S_DELETE_PRESET_LIST_ELEMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMResult (const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DELETE_PRESET_LIST_ELEMResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMResult& operator = (const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_DELETE_PRESET_LIST_ELEMResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_DELETE_PRESET_LIST_ELEM'
 */
class FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& operator = (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_DELETE_PRESET_LIST_ELEM'
 */
class FID_DAB_S_DELETE_PRESET_LIST_ELEMError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_DELETE_PRESET_LIST_ELEMError (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DELETE_PRESET_LIST_ELEMError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMError& operator = (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMError::FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorField getField () const;

    inline void setField(FID_DAB_S_DELETE_PRESET_LIST_ELEMError::FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_DELETE_PRESET_LIST_ELEMError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_DELETE_PRESET_LIST_ELEMError& rhs);

    inline void deleteData ();

    FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorField __field;

    union {
        FID_DAB_S_DELETE_PRESET_LIST_ELEMErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM"
 * Activates the selected element of the DAB preset list.
 * LCN2: Method for TunerMaster
 */
class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart (uint8 u8ActPresetElemID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart& operator = (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8ActPresetElemID"

    static const int kU8ActPresetElemID = 0;

    /**
     * Clears the field "u8ActPresetElemID".
     *
     * The field will be set to its default value. The hasU8ActPresetElemID()
     * method will return false.
     */
    inline void clearU8ActPresetElemID();

    /**
     * Checks whether the field "u8ActPresetElemID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ActPresetElemID()). Otherwise it will return false.
     */
    inline bool hasU8ActPresetElemID () const;

    /**
     * Returns the value of the member "u8ActPresetElemID".
     *
     * Element ID can be the any value within range. But that range varies from project to project.
     *
     * @return The value of the field "u8ActPresetElemID"
     */
    inline uint8 getU8ActPresetElemID () const;

    /**
     * Sets the value of the member "u8ActPresetElemID".
     *
     * Element ID can be the any value within range. But that range varies from project to project.
     *
     * @param u8ActPresetElemID The value which will be set
     */
    inline void setU8ActPresetElemID (uint8 u8ActPresetElemID_);

    static const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMStart &getDefaultInstance();

private:

    inline void set_has_u8ActPresetElemID ();

    inline void clear_has_u8ActPresetElemID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8ActPresetElemID;

};

/**
 * The result message of the method "FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM"
 * Activates the selected element of the DAB preset list.
 * LCN2: Method for TunerMaster
 * .
 */
class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult& operator = (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM'
 */
class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& operator = (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM'
 */
class FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& operator = (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError::FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorField getField () const;

    inline void setField(FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError::FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError& rhs);

    inline void deleteData ();

    FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorField __field;

    union {
        FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SAVE_PRESET_LIST"
 * Saves the current list to DAB preset list
 */
class FID_DAB_S_SAVE_PRESET_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTStart (const FID_DAB_S_SAVE_PRESET_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTStart (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& PresetList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SAVE_PRESET_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SAVE_PRESET_LISTStart& operator = (const FID_DAB_S_SAVE_PRESET_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "PresetList"

    static const int kPresetList = 0;

    /**
     * Clears the field "PresetList".
     *
     * The field will be set to its default value. The hasPresetList()
     * method will return false.
     */
    inline void clearPresetList();

    /**
     * Checks whether the field "PresetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetList()). Otherwise it will return false.
     */
    inline bool hasPresetList () const;

    /**
     * Returns the value of the member "PresetList".
     *
     * list of preset elements
     *
     * @return The value of the field "PresetList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getPresetList () const;

    /**
     * Retrieves the value of the field "PresetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getPresetListMutable ();

    /**
     * Sets the value of the member "PresetList".
     *
     * list of preset elements
     *
     * @param PresetList The value which will be set
     */
    inline void setPresetList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& PresetList_);

    static const FID_DAB_S_SAVE_PRESET_LISTStart &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getT_DAB_PresetListElementList_DefaultInstance ();

    inline void set_has_PresetList ();

    inline void clear_has_PresetList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement > _PresetList;

};

/**
 * The result message of the method "FID_DAB_S_SAVE_PRESET_LIST"
 * Saves the current list to DAB preset list
 * .
 */
class FID_DAB_S_SAVE_PRESET_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTResult (const FID_DAB_S_SAVE_PRESET_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SAVE_PRESET_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SAVE_PRESET_LISTResult& operator = (const FID_DAB_S_SAVE_PRESET_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SAVE_PRESET_LISTResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SAVE_PRESET_LIST'
 */
class FID_DAB_S_SAVE_PRESET_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTErrorStructure (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SAVE_PRESET_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SAVE_PRESET_LISTErrorStructure& operator = (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SAVE_PRESET_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SAVE_PRESET_LIST'
 */
class FID_DAB_S_SAVE_PRESET_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SAVE_PRESET_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SAVE_PRESET_LISTError (const FID_DAB_S_SAVE_PRESET_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SAVE_PRESET_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SAVE_PRESET_LISTError& operator = (const FID_DAB_S_SAVE_PRESET_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SAVE_PRESET_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SAVE_PRESET_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SAVE_PRESET_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SAVE_PRESET_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SAVE_PRESET_LISTError::FID_DAB_S_SAVE_PRESET_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_SAVE_PRESET_LISTError::FID_DAB_S_SAVE_PRESET_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SAVE_PRESET_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SAVE_PRESET_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SAVE_PRESET_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SAVE_PRESET_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SAVE_PRESET_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SAVE_PRESET_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SAVE_PRESET_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SAVE_PRESET_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SAVE_PRESET_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_SAVE_PRESET_LISTErrorField __field;

    union {
        FID_DAB_S_SAVE_PRESET_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_GET_PRESET_LIST"
 * With this command we can get the DAB preset list elements based on request.
 * LCN2: Method for HMI
 */
class FID_DAB_S_GET_PRESET_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTStart (const FID_DAB_S_GET_PRESET_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTStart (uint8 u8FirstElementID_, uint8 u8NumberOfElements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_PRESET_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_PRESET_LISTStart& operator = (const FID_DAB_S_GET_PRESET_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_PRESET_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_PRESET_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_PRESET_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_PRESET_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8FirstElementID"

    static const int kU8FirstElementID = 0;

    /**
     * Clears the field "u8FirstElementID".
     *
     * The field will be set to its default value. The hasU8FirstElementID()
     * method will return false.
     */
    inline void clearU8FirstElementID();

    /**
     * Checks whether the field "u8FirstElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FirstElementID()). Otherwise it will return false.
     */
    inline bool hasU8FirstElementID () const;

    /**
     * Returns the value of the member "u8FirstElementID".
     *
     * First element ID.(0 means all)
     *
     * @return The value of the field "u8FirstElementID"
     */
    inline uint8 getU8FirstElementID () const;

    /**
     * Sets the value of the member "u8FirstElementID".
     *
     * First element ID.(0 means all)
     *
     * @param u8FirstElementID The value which will be set
     */
    inline void setU8FirstElementID (uint8 u8FirstElementID_);

    // API of field "u8NumberOfElements"

    static const int kU8NumberOfElements = 1;

    /**
     * Clears the field "u8NumberOfElements".
     *
     * The field will be set to its default value. The hasU8NumberOfElements()
     * method will return false.
     */
    inline void clearU8NumberOfElements();

    /**
     * Checks whether the field "u8NumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfElements () const;

    /**
     * Returns the value of the member "u8NumberOfElements".
     *
     * The number of elements requested (0 means all).
     *
     * @return The value of the field "u8NumberOfElements"
     */
    inline uint8 getU8NumberOfElements () const;

    /**
     * Sets the value of the member "u8NumberOfElements".
     *
     * The number of elements requested (0 means all).
     *
     * @param u8NumberOfElements The value which will be set
     */
    inline void setU8NumberOfElements (uint8 u8NumberOfElements_);

    static const FID_DAB_S_GET_PRESET_LISTStart &getDefaultInstance();

private:

    inline void set_has_u8FirstElementID ();

    inline void clear_has_u8FirstElementID ();

    inline void set_has_u8NumberOfElements ();

    inline void clear_has_u8NumberOfElements ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8FirstElementID;

    uint8 _u8NumberOfElements;

};

/**
 * The result message of the method "FID_DAB_S_GET_PRESET_LIST"
 * With this command we can get the DAB preset list elements based on request.
 * LCN2: Method for HMI
 * .
 */
class FID_DAB_S_GET_PRESET_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTResult (const FID_DAB_S_GET_PRESET_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, uint8 u8FirstElementID_, uint8 u8NumberOfElements_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& PresetList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_PRESET_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_PRESET_LISTResult& operator = (const FID_DAB_S_GET_PRESET_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_PRESET_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_PRESET_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_PRESET_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_PRESET_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "u8FirstElementID"

    static const int kU8FirstElementID = 1;

    /**
     * Clears the field "u8FirstElementID".
     *
     * The field will be set to its default value. The hasU8FirstElementID()
     * method will return false.
     */
    inline void clearU8FirstElementID();

    /**
     * Checks whether the field "u8FirstElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FirstElementID()). Otherwise it will return false.
     */
    inline bool hasU8FirstElementID () const;

    /**
     * Returns the value of the member "u8FirstElementID".
     *
     * First element ID in the list.
     *
     * @return The value of the field "u8FirstElementID"
     */
    inline uint8 getU8FirstElementID () const;

    /**
     * Sets the value of the member "u8FirstElementID".
     *
     * First element ID in the list.
     *
     * @param u8FirstElementID The value which will be set
     */
    inline void setU8FirstElementID (uint8 u8FirstElementID_);

    // API of field "u8NumberOfElements"

    static const int kU8NumberOfElements = 2;

    /**
     * Clears the field "u8NumberOfElements".
     *
     * The field will be set to its default value. The hasU8NumberOfElements()
     * method will return false.
     */
    inline void clearU8NumberOfElements();

    /**
     * Checks whether the field "u8NumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfElements () const;

    /**
     * Returns the value of the member "u8NumberOfElements".
     *
     * The number of elements in the this msg.
     *
     * @return The value of the field "u8NumberOfElements"
     */
    inline uint8 getU8NumberOfElements () const;

    /**
     * Sets the value of the member "u8NumberOfElements".
     *
     * The number of elements in the this msg.
     *
     * @param u8NumberOfElements The value which will be set
     */
    inline void setU8NumberOfElements (uint8 u8NumberOfElements_);

    // API of field "PresetList"

    static const int kPresetList = 3;

    /**
     * Clears the field "PresetList".
     *
     * The field will be set to its default value. The hasPresetList()
     * method will return false.
     */
    inline void clearPresetList();

    /**
     * Checks whether the field "PresetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetList()). Otherwise it will return false.
     */
    inline bool hasPresetList () const;

    /**
     * Returns the value of the member "PresetList".
     *
     * Data for the requested section of preset elements
     *
     * @return The value of the field "PresetList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getPresetList () const;

    /**
     * Retrieves the value of the field "PresetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getPresetListMutable ();

    /**
     * Sets the value of the member "PresetList".
     *
     * Data for the requested section of preset elements
     *
     * @param PresetList The value which will be set
     */
    inline void setPresetList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& PresetList_);

    static const FID_DAB_S_GET_PRESET_LISTResult &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getT_DAB_PresetListElementList_DefaultInstance ();

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_u8FirstElementID ();

    inline void clear_has_u8FirstElementID ();

    inline void set_has_u8NumberOfElements ();

    inline void clear_has_u8NumberOfElements ();

    inline void set_has_PresetList ();

    inline void clear_has_PresetList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    uint8 _u8FirstElementID;

    uint8 _u8NumberOfElements;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement > _PresetList;

};

/**
 * The error message of 'FID_DAB_S_GET_PRESET_LIST'
 */
class FID_DAB_S_GET_PRESET_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTErrorStructure (const FID_DAB_S_GET_PRESET_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_GET_PRESET_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_PRESET_LISTErrorStructure& operator = (const FID_DAB_S_GET_PRESET_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_PRESET_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_GET_PRESET_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_GET_PRESET_LIST'
 */
class FID_DAB_S_GET_PRESET_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_GET_PRESET_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_GET_PRESET_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_PRESET_LISTError (const FID_DAB_S_GET_PRESET_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_PRESET_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_GET_PRESET_LISTError& operator = (const FID_DAB_S_GET_PRESET_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_PRESET_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_PRESET_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_PRESET_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_PRESET_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_GET_PRESET_LISTError::FID_DAB_S_GET_PRESET_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_GET_PRESET_LISTError::FID_DAB_S_GET_PRESET_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_GET_PRESET_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_GET_PRESET_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_GET_PRESET_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_GET_PRESET_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_GET_PRESET_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_GET_PRESET_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_GET_PRESET_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_GET_PRESET_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_GET_PRESET_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_GET_PRESET_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_GET_PRESET_LISTErrorField __field;

    union {
        FID_DAB_S_GET_PRESET_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_AUTOSTORE"
 * With this command we can start/stop autostore
 */
class FID_DAB_S_AUTOSTOREStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_AUTOSTOREStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_AUTOSTOREStart (const FID_DAB_S_AUTOSTOREStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_AUTOSTOREStart (bool StartAutostore_, ::dabtuner_main_fi_types::T_e8_DAB_AST_Type AST_Type_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_AUTOSTOREStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_AUTOSTOREStart& operator = (const FID_DAB_S_AUTOSTOREStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_AUTOSTOREStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_AUTOSTOREStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_AUTOSTOREStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_AUTOSTOREStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "StartAutostore"

    static const int kStartAutostore = 0;

    /**
     * Clears the field "StartAutostore".
     *
     * The field will be set to its default value. The hasStartAutostore()
     * method will return false.
     */
    inline void clearStartAutostore();

    /**
     * Checks whether the field "StartAutostore" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStartAutostore()). Otherwise it will return false.
     */
    inline bool hasStartAutostore () const;

    /**
     * Returns the value of the member "StartAutostore".
     *
     * Starts/stops autostore if value is 1/0.
     *
     * @return The value of the field "StartAutostore"
     */
    inline bool getStartAutostore () const;

    /**
     * Sets the value of the member "StartAutostore".
     *
     * Starts/stops autostore if value is 1/0.
     *
     * @param StartAutostore The value which will be set
     */
    inline void setStartAutostore (bool StartAutostore_);

    // API of field "AST_Type"

    static const int kAST_Type = 1;

    /**
     * Clears the field "AST_Type".
     *
     * The field will be set to its default value. The hasAST_Type()
     * method will return false.
     */
    inline void clearAST_Type();

    /**
     * Checks whether the field "AST_Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAST_Type()). Otherwise it will return false.
     */
    inline bool hasAST_Type () const;

    /**
     * Returns the value of the member "AST_Type".
     *
     * indicated normal/initial autostore
     *
     * @return The value of the field "AST_Type"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_AST_Type getAST_Type () const;

    /**
     * Sets the value of the member "AST_Type".
     *
     * indicated normal/initial autostore
     *
     * @param AST_Type The value which will be set
     */
    inline void setAST_Type (::dabtuner_main_fi_types::T_e8_DAB_AST_Type AST_Type_);

    static const FID_DAB_S_AUTOSTOREStart &getDefaultInstance();

private:

    inline void set_has_StartAutostore ();

    inline void clear_has_StartAutostore ();

    inline void set_has_AST_Type ();

    inline void clear_has_AST_Type ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _StartAutostore;

    ::dabtuner_main_fi_types::T_e8_DAB_AST_Type _AST_Type;

};

/**
 * The result message of the method "FID_DAB_S_AUTOSTORE"
 * With this command we can start/stop autostore
 * .
 */
class FID_DAB_S_AUTOSTOREResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_AUTOSTOREResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_AUTOSTOREResult (const FID_DAB_S_AUTOSTOREResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_AUTOSTOREResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, uint8 u8NumberOfStationsFound_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_AUTOSTOREResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_AUTOSTOREResult& operator = (const FID_DAB_S_AUTOSTOREResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_AUTOSTOREResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_AUTOSTOREResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_AUTOSTOREResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_AUTOSTOREResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "u8NumberOfStationsFound"

    static const int kU8NumberOfStationsFound = 1;

    /**
     * Clears the field "u8NumberOfStationsFound".
     *
     * The field will be set to its default value. The hasU8NumberOfStationsFound()
     * method will return false.
     */
    inline void clearU8NumberOfStationsFound();

    /**
     * Checks whether the field "u8NumberOfStationsFound" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfStationsFound()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfStationsFound () const;

    /**
     * Returns the value of the member "u8NumberOfStationsFound".
     *
     * Number of stations stored by autostore.
     *
     * @return The value of the field "u8NumberOfStationsFound"
     */
    inline uint8 getU8NumberOfStationsFound () const;

    /**
     * Sets the value of the member "u8NumberOfStationsFound".
     *
     * Number of stations stored by autostore.
     *
     * @param u8NumberOfStationsFound The value which will be set
     */
    inline void setU8NumberOfStationsFound (uint8 u8NumberOfStationsFound_);

    static const FID_DAB_S_AUTOSTOREResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_u8NumberOfStationsFound ();

    inline void clear_has_u8NumberOfStationsFound ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    uint8 _u8NumberOfStationsFound;

};

/**
 * The error message of 'FID_DAB_S_AUTOSTORE'
 */
class FID_DAB_S_AUTOSTOREErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_AUTOSTOREErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_AUTOSTOREErrorStructure (const FID_DAB_S_AUTOSTOREErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_AUTOSTOREErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_AUTOSTOREErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_AUTOSTOREErrorStructure& operator = (const FID_DAB_S_AUTOSTOREErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_AUTOSTOREErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_AUTOSTOREErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_AUTOSTOREErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_AUTOSTOREErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_AUTOSTOREErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_AUTOSTORE'
 */
class FID_DAB_S_AUTOSTOREError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_AUTOSTOREErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_AUTOSTOREError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_AUTOSTOREError (const FID_DAB_S_AUTOSTOREError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_AUTOSTOREError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_AUTOSTOREError& operator = (const FID_DAB_S_AUTOSTOREError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_AUTOSTOREError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_AUTOSTOREError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_AUTOSTOREError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_AUTOSTOREError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_AUTOSTOREError::FID_DAB_S_AUTOSTOREErrorField getField () const;

    inline void setField(FID_DAB_S_AUTOSTOREError::FID_DAB_S_AUTOSTOREErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_AUTOSTOREErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_AUTOSTOREErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_AUTOSTOREErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_AUTOSTOREErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_AUTOSTOREErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_AUTOSTOREErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_AUTOSTOREErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_AUTOSTOREErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_AUTOSTOREError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_AUTOSTOREError& rhs);

    inline void deleteData ();

    FID_DAB_S_AUTOSTOREErrorField __field;

    union {
        FID_DAB_S_AUTOSTOREErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SET_ENS_LIST"
 * Open/Close/Get the frozen Ensemble-list.
 * G3g: Method for HMI
 */
class FID_DAB_S_SET_ENS_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTStart (const FID_DAB_S_SET_ENS_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTStart (::dabtuner_main_fi_types::T_e8_DAB_ListOperation enOperation_, uint16 u16FirstElemId_, uint16 u16NumElem_, ::dabtuner_main_fi_types::T_e8_DAB_EnsembleListSortingType enSortingType_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_ENS_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_ENS_LISTStart& operator = (const FID_DAB_S_SET_ENS_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_ENS_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_ENS_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_ENS_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_ENS_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enOperation"

    static const int kEnOperation = 0;

    /**
     * Clears the field "enOperation".
     *
     * The field will be set to its default value. The hasEnOperation()
     * method will return false.
     */
    inline void clearEnOperation();

    /**
     * Checks whether the field "enOperation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOperation()). Otherwise it will return false.
     */
    inline bool hasEnOperation () const;

    /**
     * Returns the value of the member "enOperation".
     *
     * Possible operations: open, close,get.
     *
     * @return The value of the field "enOperation"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ListOperation getEnOperation () const;

    /**
     * Sets the value of the member "enOperation".
     *
     * Possible operations: open, close,get.
     *
     * @param enOperation The value which will be set
     */
    inline void setEnOperation (::dabtuner_main_fi_types::T_e8_DAB_ListOperation enOperation_);

    // API of field "u16FirstElemId"

    static const int kU16FirstElemId = 1;

    /**
     * Clears the field "u16FirstElemId".
     *
     * The field will be set to its default value. The hasU16FirstElemId()
     * method will return false.
     */
    inline void clearU16FirstElemId();

    /**
     * Checks whether the field "u16FirstElemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FirstElemId()). Otherwise it will return false.
     */
    inline bool hasU16FirstElemId () const;

    /**
     * Returns the value of the member "u16FirstElemId".
     *
     * First ElemId .
     *
     * @return The value of the field "u16FirstElemId"
     */
    inline uint16 getU16FirstElemId () const;

    /**
     * Sets the value of the member "u16FirstElemId".
     *
     * First ElemId .
     *
     * @param u16FirstElemId The value which will be set
     */
    inline void setU16FirstElemId (uint16 u16FirstElemId_);

    // API of field "u16NumElem"

    static const int kU16NumElem = 2;

    /**
     * Clears the field "u16NumElem".
     *
     * The field will be set to its default value. The hasU16NumElem()
     * method will return false.
     */
    inline void clearU16NumElem();

    /**
     * Checks whether the field "u16NumElem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumElem()). Otherwise it will return false.
     */
    inline bool hasU16NumElem () const;

    /**
     * Returns the value of the member "u16NumElem".
     *
     * Number of Elements to be contained in answer .
     *
     * @return The value of the field "u16NumElem"
     */
    inline uint16 getU16NumElem () const;

    /**
     * Sets the value of the member "u16NumElem".
     *
     * Number of Elements to be contained in answer .
     *
     * @param u16NumElem The value which will be set
     */
    inline void setU16NumElem (uint16 u16NumElem_);

    // API of field "enSortingType"

    static const int kEnSortingType = 3;

    /**
     * Clears the field "enSortingType".
     *
     * The field will be set to its default value. The hasEnSortingType()
     * method will return false.
     */
    inline void clearEnSortingType();

    /**
     * Checks whether the field "enSortingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSortingType()). Otherwise it will return false.
     */
    inline bool hasEnSortingType () const;

    /**
     * Returns the value of the member "enSortingType".
     *
     * sorting type
     *
     * @return The value of the field "enSortingType"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_EnsembleListSortingType getEnSortingType () const;

    /**
     * Sets the value of the member "enSortingType".
     *
     * sorting type
     *
     * @param enSortingType The value which will be set
     */
    inline void setEnSortingType (::dabtuner_main_fi_types::T_e8_DAB_EnsembleListSortingType enSortingType_);

    static const FID_DAB_S_SET_ENS_LISTStart &getDefaultInstance();

private:

    inline void set_has_enOperation ();

    inline void clear_has_enOperation ();

    inline void set_has_u16FirstElemId ();

    inline void clear_has_u16FirstElemId ();

    inline void set_has_u16NumElem ();

    inline void clear_has_u16NumElem ();

    inline void set_has_enSortingType ();

    inline void clear_has_enSortingType ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_ListOperation _enOperation;

    uint16 _u16FirstElemId;

    uint16 _u16NumElem;

    ::dabtuner_main_fi_types::T_e8_DAB_EnsembleListSortingType _enSortingType;

};

/**
 * The result message of the method "FID_DAB_S_SET_ENS_LIST"
 * Open/Close/Get the frozen Ensemble-list.
 * G3g: Method for HMI
 * .
 */
class FID_DAB_S_SET_ENS_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTResult (const FID_DAB_S_SET_ENS_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleInfo >& EnsembleList_, bool bOpen_, uint16 u16TotalNumberOfElements_, uint16 u16SentNumberOfElements_, uint16 u16InitialActivatedElementId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_ENS_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_ENS_LISTResult& operator = (const FID_DAB_S_SET_ENS_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_ENS_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_ENS_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_ENS_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_ENS_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "EnsembleList"

    static const int kEnsembleList = 1;

    /**
     * Clears the field "EnsembleList".
     *
     * The field will be set to its default value. The hasEnsembleList()
     * method will return false.
     */
    inline void clearEnsembleList();

    /**
     * Checks whether the field "EnsembleList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleList()). Otherwise it will return false.
     */
    inline bool hasEnsembleList () const;

    /**
     * Returns the value of the member "EnsembleList".
     *
     * requested range of frozen Ensmble List containing EnsmbleIndex, EnsmbleID, EnsembleName
     *
     * @return The value of the field "EnsembleList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleInfo >& getEnsembleList () const;

    /**
     * Retrieves the value of the field "EnsembleList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleInfo >& getEnsembleListMutable ();

    /**
     * Sets the value of the member "EnsembleList".
     *
     * requested range of frozen Ensmble List containing EnsmbleIndex, EnsmbleID, EnsembleName
     *
     * @param EnsembleList The value which will be set
     */
    inline void setEnsembleList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleInfo >& EnsembleList_);

    // API of field "bOpen"

    static const int kBOpen = 2;

    /**
     * Clears the field "bOpen".
     *
     * The field will be set to its default value. The hasBOpen()
     * method will return false.
     */
    inline void clearBOpen();

    /**
     * Checks whether the field "bOpen" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOpen()). Otherwise it will return false.
     */
    inline bool hasBOpen () const;

    /**
     * Returns the value of the member "bOpen".
     *
     * TRUE==opened, FALSE=Closed.
     *
     * @return The value of the field "bOpen"
     */
    inline bool getBOpen () const;

    /**
     * Sets the value of the member "bOpen".
     *
     * TRUE==opened, FALSE=Closed.
     *
     * @param bOpen The value which will be set
     */
    inline void setBOpen (bool bOpen_);

    // API of field "u16TotalNumberOfElements"

    static const int kU16TotalNumberOfElements = 3;

    /**
     * Clears the field "u16TotalNumberOfElements".
     *
     * The field will be set to its default value. The hasU16TotalNumberOfElements()
     * method will return false.
     */
    inline void clearU16TotalNumberOfElements();

    /**
     * Checks whether the field "u16TotalNumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TotalNumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU16TotalNumberOfElements () const;

    /**
     * Returns the value of the member "u16TotalNumberOfElements".
     *
     * Total Number of elements in the active list.
     *
     * @return The value of the field "u16TotalNumberOfElements"
     */
    inline uint16 getU16TotalNumberOfElements () const;

    /**
     * Sets the value of the member "u16TotalNumberOfElements".
     *
     * Total Number of elements in the active list.
     *
     * @param u16TotalNumberOfElements The value which will be set
     */
    inline void setU16TotalNumberOfElements (uint16 u16TotalNumberOfElements_);

    // API of field "u16SentNumberOfElements"

    static const int kU16SentNumberOfElements = 4;

    /**
     * Clears the field "u16SentNumberOfElements".
     *
     * The field will be set to its default value. The hasU16SentNumberOfElements()
     * method will return false.
     */
    inline void clearU16SentNumberOfElements();

    /**
     * Checks whether the field "u16SentNumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SentNumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU16SentNumberOfElements () const;

    /**
     * Returns the value of the member "u16SentNumberOfElements".
     *
     * Number of elements include in this message.
     *
     * @return The value of the field "u16SentNumberOfElements"
     */
    inline uint16 getU16SentNumberOfElements () const;

    /**
     * Sets the value of the member "u16SentNumberOfElements".
     *
     * Number of elements include in this message.
     *
     * @param u16SentNumberOfElements The value which will be set
     */
    inline void setU16SentNumberOfElements (uint16 u16SentNumberOfElements_);

    // API of field "u16InitialActivatedElementId"

    static const int kU16InitialActivatedElementId = 5;

    /**
     * Clears the field "u16InitialActivatedElementId".
     *
     * The field will be set to its default value. The hasU16InitialActivatedElementId()
     * method will return false.
     */
    inline void clearU16InitialActivatedElementId();

    /**
     * Checks whether the field "u16InitialActivatedElementId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16InitialActivatedElementId()). Otherwise it will return false.
     */
    inline bool hasU16InitialActivatedElementId () const;

    /**
     * Returns the value of the member "u16InitialActivatedElementId".
     *
     * Activated Element in list when it is opened that matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @return The value of the field "u16InitialActivatedElementId"
     */
    inline uint16 getU16InitialActivatedElementId () const;

    /**
     * Sets the value of the member "u16InitialActivatedElementId".
     *
     * Activated Element in list when it is opened that matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @param u16InitialActivatedElementId The value which will be set
     */
    inline void setU16InitialActivatedElementId (uint16 u16InitialActivatedElementId_);

    static const FID_DAB_S_SET_ENS_LISTResult &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleInfo >& getT_DAB_EnsembleInfoList_DefaultInstance ();

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_EnsembleList ();

    inline void clear_has_EnsembleList ();

    inline void set_has_bOpen ();

    inline void clear_has_bOpen ();

    inline void set_has_u16TotalNumberOfElements ();

    inline void clear_has_u16TotalNumberOfElements ();

    inline void set_has_u16SentNumberOfElements ();

    inline void clear_has_u16SentNumberOfElements ();

    inline void set_has_u16InitialActivatedElementId ();

    inline void clear_has_u16InitialActivatedElementId ();

    uint32 _has_bits_[ (6 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleInfo > _EnsembleList;

    bool _bOpen;

    uint16 _u16TotalNumberOfElements;

    uint16 _u16SentNumberOfElements;

    uint16 _u16InitialActivatedElementId;

};

/**
 * The error message of 'FID_DAB_S_SET_ENS_LIST'
 */
class FID_DAB_S_SET_ENS_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTErrorStructure (const FID_DAB_S_SET_ENS_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SET_ENS_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_ENS_LISTErrorStructure& operator = (const FID_DAB_S_SET_ENS_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_ENS_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_ENS_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_ENS_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_ENS_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SET_ENS_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SET_ENS_LIST'
 */
class FID_DAB_S_SET_ENS_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SET_ENS_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SET_ENS_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_ENS_LISTError (const FID_DAB_S_SET_ENS_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_ENS_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SET_ENS_LISTError& operator = (const FID_DAB_S_SET_ENS_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_ENS_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_ENS_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_ENS_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_ENS_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SET_ENS_LISTError::FID_DAB_S_SET_ENS_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_SET_ENS_LISTError::FID_DAB_S_SET_ENS_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SET_ENS_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SET_ENS_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SET_ENS_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SET_ENS_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SET_ENS_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SET_ENS_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SET_ENS_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SET_ENS_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SET_ENS_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SET_ENS_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_SET_ENS_LISTErrorField __field;

    union {
        FID_DAB_S_SET_ENS_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SET_SRV_LIST"
 * Open/Close/Get the frozen service-list with/without PTY filter.
 * Gen3G: Method for HMI
 */
class FID_DAB_S_SET_SRV_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTStart (const FID_DAB_S_SET_SRV_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTStart (::dabtuner_main_fi_types::T_e8_DAB_ListOperation enOperation_, ::dabtuner_main_fi_types::T_e8_DAB_ServiceListType enServiceListType_, uint32 u32PTYFilter_, uint16 u16FirstElemId_, uint16 u16NumElem_, ::dabtuner_main_fi_types::T_e8_DAB_ServiceListSortingType enSortingType_, uint16 u16EnsembleIndex_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_SRV_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_SRV_LISTStart& operator = (const FID_DAB_S_SET_SRV_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_SRV_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_SRV_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_SRV_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_SRV_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enOperation"

    static const int kEnOperation = 0;

    /**
     * Clears the field "enOperation".
     *
     * The field will be set to its default value. The hasEnOperation()
     * method will return false.
     */
    inline void clearEnOperation();

    /**
     * Checks whether the field "enOperation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOperation()). Otherwise it will return false.
     */
    inline bool hasEnOperation () const;

    /**
     * Returns the value of the member "enOperation".
     *
     * Possible operations: open, close,get.
     *
     * @return The value of the field "enOperation"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ListOperation getEnOperation () const;

    /**
     * Sets the value of the member "enOperation".
     *
     * Possible operations: open, close,get.
     *
     * @param enOperation The value which will be set
     */
    inline void setEnOperation (::dabtuner_main_fi_types::T_e8_DAB_ListOperation enOperation_);

    // API of field "enServiceListType"

    static const int kEnServiceListType = 1;

    /**
     * Clears the field "enServiceListType".
     *
     * The field will be set to its default value. The hasEnServiceListType()
     * method will return false.
     */
    inline void clearEnServiceListType();

    /**
     * Checks whether the field "enServiceListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnServiceListType()). Otherwise it will return false.
     */
    inline bool hasEnServiceListType () const;

    /**
     * Returns the value of the member "enServiceListType".
     *
     * Possible list types: globalServiclist, currentEnsembleServiceList
     *
     * @return The value of the field "enServiceListType"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ServiceListType getEnServiceListType () const;

    /**
     * Sets the value of the member "enServiceListType".
     *
     * Possible list types: globalServiclist, currentEnsembleServiceList
     *
     * @param enServiceListType The value which will be set
     */
    inline void setEnServiceListType (::dabtuner_main_fi_types::T_e8_DAB_ServiceListType enServiceListType_);

    // API of field "u32PTYFilter"

    static const int kU32PTYFilter = 2;

    /**
     * Clears the field "u32PTYFilter".
     *
     * The field will be set to its default value. The hasU32PTYFilter()
     * method will return false.
     */
    inline void clearU32PTYFilter();

    /**
     * Checks whether the field "u32PTYFilter" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32PTYFilter()). Otherwise it will return false.
     */
    inline bool hasU32PTYFilter () const;

    /**
     * Returns the value of the member "u32PTYFilter".
     *
     * Below are the supported PTYs
     * 0 - No programme type or undefined,
     * 1 - News,
     * 2 - Current affairs,
     * 3 - Information,
     * 4 - Sport,
     * 5 - Education,
     * 6 - Drama,
     * 7 - Culture,
     * 8 - Science,
     * 9 - Varied,
     * 10 - Pop music,
     * 11 - Rock music,
     * 12 - Easy listening,
     * 13 - Light classical,
     * 14 - Serious classical,
     * 15 - Other music,
     * 16 - Weather,
     * 17 - Finance,
     * 18 - Children's programmes,
     * 19 - Social	affairs,
     * 20 - Religion,
     * 21 - Phone-in,
     * 22 - Travel,
     * 23 - Leisure,
     * 24 - Jazz,
     * 25 - Country,
     * 26 - National,
     * 27 - Oldies,
     * 28 - Folk,
     * 29 - Documentary
     *
     * @return The value of the field "u32PTYFilter"
     */
    inline uint32 getU32PTYFilter () const;

    /**
     * Sets the value of the member "u32PTYFilter".
     *
     * Below are the supported PTYs
     * 0 - No programme type or undefined,
     * 1 - News,
     * 2 - Current affairs,
     * 3 - Information,
     * 4 - Sport,
     * 5 - Education,
     * 6 - Drama,
     * 7 - Culture,
     * 8 - Science,
     * 9 - Varied,
     * 10 - Pop music,
     * 11 - Rock music,
     * 12 - Easy listening,
     * 13 - Light classical,
     * 14 - Serious classical,
     * 15 - Other music,
     * 16 - Weather,
     * 17 - Finance,
     * 18 - Children's programmes,
     * 19 - Social	affairs,
     * 20 - Religion,
     * 21 - Phone-in,
     * 22 - Travel,
     * 23 - Leisure,
     * 24 - Jazz,
     * 25 - Country,
     * 26 - National,
     * 27 - Oldies,
     * 28 - Folk,
     * 29 - Documentary
     *
     * @param u32PTYFilter The value which will be set
     */
    inline void setU32PTYFilter (uint32 u32PTYFilter_);

    // API of field "u16FirstElemId"

    static const int kU16FirstElemId = 3;

    /**
     * Clears the field "u16FirstElemId".
     *
     * The field will be set to its default value. The hasU16FirstElemId()
     * method will return false.
     */
    inline void clearU16FirstElemId();

    /**
     * Checks whether the field "u16FirstElemId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16FirstElemId()). Otherwise it will return false.
     */
    inline bool hasU16FirstElemId () const;

    /**
     * Returns the value of the member "u16FirstElemId".
     *
     * First ElemId .
     *
     * @return The value of the field "u16FirstElemId"
     */
    inline uint16 getU16FirstElemId () const;

    /**
     * Sets the value of the member "u16FirstElemId".
     *
     * First ElemId .
     *
     * @param u16FirstElemId The value which will be set
     */
    inline void setU16FirstElemId (uint16 u16FirstElemId_);

    // API of field "u16NumElem"

    static const int kU16NumElem = 4;

    /**
     * Clears the field "u16NumElem".
     *
     * The field will be set to its default value. The hasU16NumElem()
     * method will return false.
     */
    inline void clearU16NumElem();

    /**
     * Checks whether the field "u16NumElem" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumElem()). Otherwise it will return false.
     */
    inline bool hasU16NumElem () const;

    /**
     * Returns the value of the member "u16NumElem".
     *
     * Number of Elements to be contained in answer .
     *
     * @return The value of the field "u16NumElem"
     */
    inline uint16 getU16NumElem () const;

    /**
     * Sets the value of the member "u16NumElem".
     *
     * Number of Elements to be contained in answer .
     *
     * @param u16NumElem The value which will be set
     */
    inline void setU16NumElem (uint16 u16NumElem_);

    // API of field "enSortingType"

    static const int kEnSortingType = 5;

    /**
     * Clears the field "enSortingType".
     *
     * The field will be set to its default value. The hasEnSortingType()
     * method will return false.
     */
    inline void clearEnSortingType();

    /**
     * Checks whether the field "enSortingType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnSortingType()). Otherwise it will return false.
     */
    inline bool hasEnSortingType () const;

    /**
     * Returns the value of the member "enSortingType".
     *
     * sorting type
     *
     * @return The value of the field "enSortingType"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ServiceListSortingType getEnSortingType () const;

    /**
     * Sets the value of the member "enSortingType".
     *
     * sorting type
     *
     * @param enSortingType The value which will be set
     */
    inline void setEnSortingType (::dabtuner_main_fi_types::T_e8_DAB_ServiceListSortingType enSortingType_);

    // API of field "u16EnsembleIndex"

    static const int kU16EnsembleIndex = 6;

    /**
     * Clears the field "u16EnsembleIndex".
     *
     * The field will be set to its default value. The hasU16EnsembleIndex()
     * method will return false.
     */
    inline void clearU16EnsembleIndex();

    /**
     * Checks whether the field "u16EnsembleIndex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16EnsembleIndex()). Otherwise it will return false.
     */
    inline bool hasU16EnsembleIndex () const;

    /**
     * Returns the value of the member "u16EnsembleIndex".
     *
     * Index of ensemble whose service list has to be opened.If this value is 0, current ensemble's servicelist is opened,
     * else service list of ensemble at requested index is opened.
     * This would be valid only if service lits type is cureentensembleservicelist
     *
     * @return The value of the field "u16EnsembleIndex"
     */
    inline uint16 getU16EnsembleIndex () const;

    /**
     * Sets the value of the member "u16EnsembleIndex".
     *
     * Index of ensemble whose service list has to be opened.If this value is 0, current ensemble's servicelist is opened,
     * else service list of ensemble at requested index is opened.
     * This would be valid only if service lits type is cureentensembleservicelist
     *
     * @param u16EnsembleIndex The value which will be set
     */
    inline void setU16EnsembleIndex (uint16 u16EnsembleIndex_);

    static const FID_DAB_S_SET_SRV_LISTStart &getDefaultInstance();

private:

    inline void set_has_enOperation ();

    inline void clear_has_enOperation ();

    inline void set_has_enServiceListType ();

    inline void clear_has_enServiceListType ();

    inline void set_has_u32PTYFilter ();

    inline void clear_has_u32PTYFilter ();

    inline void set_has_u16FirstElemId ();

    inline void clear_has_u16FirstElemId ();

    inline void set_has_u16NumElem ();

    inline void clear_has_u16NumElem ();

    inline void set_has_enSortingType ();

    inline void clear_has_enSortingType ();

    inline void set_has_u16EnsembleIndex ();

    inline void clear_has_u16EnsembleIndex ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_ListOperation _enOperation;

    ::dabtuner_main_fi_types::T_e8_DAB_ServiceListType _enServiceListType;

    uint32 _u32PTYFilter;

    uint16 _u16FirstElemId;

    uint16 _u16NumElem;

    ::dabtuner_main_fi_types::T_e8_DAB_ServiceListSortingType _enSortingType;

    uint16 _u16EnsembleIndex;

};

/**
 * The result message of the method "FID_DAB_S_SET_SRV_LIST"
 * Open/Close/Get the frozen service-list with/without PTY filter.
 * Gen3G: Method for HMI
 * .
 */
class FID_DAB_S_SET_SRV_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTResult (const FID_DAB_S_SET_SRV_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, ::dabtuner_main_fi_types::T_e8_DAB_ServiceListType enServiceListType_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& ChannelList_, bool bOpen_, uint16 u16TotalNumberOfElements_, uint16 u16SentNumberOfElements_, uint16 u16InitialActivatedElementId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_SRV_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_SRV_LISTResult& operator = (const FID_DAB_S_SET_SRV_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_SRV_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_SRV_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_SRV_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_SRV_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "enServiceListType"

    static const int kEnServiceListType = 1;

    /**
     * Clears the field "enServiceListType".
     *
     * The field will be set to its default value. The hasEnServiceListType()
     * method will return false.
     */
    inline void clearEnServiceListType();

    /**
     * Checks whether the field "enServiceListType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnServiceListType()). Otherwise it will return false.
     */
    inline bool hasEnServiceListType () const;

    /**
     * Returns the value of the member "enServiceListType".
     *
     * Possible list types: globalServiclist, currentEnsembleServiceList
     *
     * @return The value of the field "enServiceListType"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ServiceListType getEnServiceListType () const;

    /**
     * Sets the value of the member "enServiceListType".
     *
     * Possible list types: globalServiclist, currentEnsembleServiceList
     *
     * @param enServiceListType The value which will be set
     */
    inline void setEnServiceListType (::dabtuner_main_fi_types::T_e8_DAB_ServiceListType enServiceListType_);

    // API of field "ChannelList"

    static const int kChannelList = 2;

    /**
     * Clears the field "ChannelList".
     *
     * The field will be set to its default value. The hasChannelList()
     * method will return false.
     */
    inline void clearChannelList();

    /**
     * Checks whether the field "ChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelList()). Otherwise it will return false.
     */
    inline bool hasChannelList () const;

    /**
     * Returns the value of the member "ChannelList".
     *
     * requested range of frozen Channel List containing listIndex, PSID, ChannelName
     * For Current Ensemble Service list only one entry will be present.
     *
     * @return The value of the field "ChannelList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& getChannelList () const;

    /**
     * Retrieves the value of the field "ChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& getChannelListMutable ();

    /**
     * Sets the value of the member "ChannelList".
     *
     * requested range of frozen Channel List containing listIndex, PSID, ChannelName
     * For Current Ensemble Service list only one entry will be present.
     *
     * @param ChannelList The value which will be set
     */
    inline void setChannelList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& ChannelList_);

    // API of field "bOpen"

    static const int kBOpen = 3;

    /**
     * Clears the field "bOpen".
     *
     * The field will be set to its default value. The hasBOpen()
     * method will return false.
     */
    inline void clearBOpen();

    /**
     * Checks whether the field "bOpen" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOpen()). Otherwise it will return false.
     */
    inline bool hasBOpen () const;

    /**
     * Returns the value of the member "bOpen".
     *
     * TRUE==opened, FALSE=Closed.
     *
     * @return The value of the field "bOpen"
     */
    inline bool getBOpen () const;

    /**
     * Sets the value of the member "bOpen".
     *
     * TRUE==opened, FALSE=Closed.
     *
     * @param bOpen The value which will be set
     */
    inline void setBOpen (bool bOpen_);

    // API of field "u16TotalNumberOfElements"

    static const int kU16TotalNumberOfElements = 4;

    /**
     * Clears the field "u16TotalNumberOfElements".
     *
     * The field will be set to its default value. The hasU16TotalNumberOfElements()
     * method will return false.
     */
    inline void clearU16TotalNumberOfElements();

    /**
     * Checks whether the field "u16TotalNumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16TotalNumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU16TotalNumberOfElements () const;

    /**
     * Returns the value of the member "u16TotalNumberOfElements".
     *
     * Total Number of elements in the active list.
     *
     * @return The value of the field "u16TotalNumberOfElements"
     */
    inline uint16 getU16TotalNumberOfElements () const;

    /**
     * Sets the value of the member "u16TotalNumberOfElements".
     *
     * Total Number of elements in the active list.
     *
     * @param u16TotalNumberOfElements The value which will be set
     */
    inline void setU16TotalNumberOfElements (uint16 u16TotalNumberOfElements_);

    // API of field "u16SentNumberOfElements"

    static const int kU16SentNumberOfElements = 5;

    /**
     * Clears the field "u16SentNumberOfElements".
     *
     * The field will be set to its default value. The hasU16SentNumberOfElements()
     * method will return false.
     */
    inline void clearU16SentNumberOfElements();

    /**
     * Checks whether the field "u16SentNumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16SentNumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU16SentNumberOfElements () const;

    /**
     * Returns the value of the member "u16SentNumberOfElements".
     *
     * Number of elements include in this message.
     *
     * @return The value of the field "u16SentNumberOfElements"
     */
    inline uint16 getU16SentNumberOfElements () const;

    /**
     * Sets the value of the member "u16SentNumberOfElements".
     *
     * Number of elements include in this message.
     *
     * @param u16SentNumberOfElements The value which will be set
     */
    inline void setU16SentNumberOfElements (uint16 u16SentNumberOfElements_);

    // API of field "u16InitialActivatedElementId"

    static const int kU16InitialActivatedElementId = 6;

    /**
     * Clears the field "u16InitialActivatedElementId".
     *
     * The field will be set to its default value. The hasU16InitialActivatedElementId()
     * method will return false.
     */
    inline void clearU16InitialActivatedElementId();

    /**
     * Checks whether the field "u16InitialActivatedElementId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16InitialActivatedElementId()). Otherwise it will return false.
     */
    inline bool hasU16InitialActivatedElementId () const;

    /**
     * Returns the value of the member "u16InitialActivatedElementId".
     *
     * Activated Element in list when it is opened that matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @return The value of the field "u16InitialActivatedElementId"
     */
    inline uint16 getU16InitialActivatedElementId () const;

    /**
     * Sets the value of the member "u16InitialActivatedElementId".
     *
     * Activated Element in list when it is opened that matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @param u16InitialActivatedElementId The value which will be set
     */
    inline void setU16InitialActivatedElementId (uint16 u16InitialActivatedElementId_);

    static const FID_DAB_S_SET_SRV_LISTResult &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& getT_DAB_ChnListElementList_DefaultInstance ();

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_enServiceListType ();

    inline void clear_has_enServiceListType ();

    inline void set_has_ChannelList ();

    inline void clear_has_ChannelList ();

    inline void set_has_bOpen ();

    inline void clear_has_bOpen ();

    inline void set_has_u16TotalNumberOfElements ();

    inline void clear_has_u16TotalNumberOfElements ();

    inline void set_has_u16SentNumberOfElements ();

    inline void clear_has_u16SentNumberOfElements ();

    inline void set_has_u16InitialActivatedElementId ();

    inline void clear_has_u16InitialActivatedElementId ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    ::dabtuner_main_fi_types::T_e8_DAB_ServiceListType _enServiceListType;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement > _ChannelList;

    bool _bOpen;

    uint16 _u16TotalNumberOfElements;

    uint16 _u16SentNumberOfElements;

    uint16 _u16InitialActivatedElementId;

};

/**
 * The error message of 'FID_DAB_S_SET_SRV_LIST'
 */
class FID_DAB_S_SET_SRV_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTErrorStructure (const FID_DAB_S_SET_SRV_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SET_SRV_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_SRV_LISTErrorStructure& operator = (const FID_DAB_S_SET_SRV_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_SRV_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_SRV_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_SRV_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_SRV_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SET_SRV_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SET_SRV_LIST'
 */
class FID_DAB_S_SET_SRV_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SET_SRV_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SET_SRV_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_SRV_LISTError (const FID_DAB_S_SET_SRV_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_SRV_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SET_SRV_LISTError& operator = (const FID_DAB_S_SET_SRV_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_SRV_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_SRV_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_SRV_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_SRV_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SET_SRV_LISTError::FID_DAB_S_SET_SRV_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_SET_SRV_LISTError::FID_DAB_S_SET_SRV_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SET_SRV_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SET_SRV_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SET_SRV_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SET_SRV_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SET_SRV_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SET_SRV_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SET_SRV_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SET_SRV_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SET_SRV_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SET_SRV_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_SET_SRV_LISTErrorField __field;

    union {
        FID_DAB_S_SET_SRV_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SET_COMP_LIST"
 * Open/Close a frozen component-list.
 * LCN2: Method for HMI
 */
class FID_DAB_S_SET_COMP_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTStart (const FID_DAB_S_SET_COMP_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTStart (::dabtuner_main_fi_types::T_e8_DAB_ListOperation enOperation_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_COMP_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_COMP_LISTStart& operator = (const FID_DAB_S_SET_COMP_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_COMP_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_COMP_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_COMP_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_COMP_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enOperation"

    static const int kEnOperation = 0;

    /**
     * Clears the field "enOperation".
     *
     * The field will be set to its default value. The hasEnOperation()
     * method will return false.
     */
    inline void clearEnOperation();

    /**
     * Checks whether the field "enOperation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOperation()). Otherwise it will return false.
     */
    inline bool hasEnOperation () const;

    /**
     * Returns the value of the member "enOperation".
     *
     * Possible operations: open, close.
     *
     * @return The value of the field "enOperation"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ListOperation getEnOperation () const;

    /**
     * Sets the value of the member "enOperation".
     *
     * Possible operations: open, close.
     *
     * @param enOperation The value which will be set
     */
    inline void setEnOperation (::dabtuner_main_fi_types::T_e8_DAB_ListOperation enOperation_);

    static const FID_DAB_S_SET_COMP_LISTStart &getDefaultInstance();

private:

    inline void set_has_enOperation ();

    inline void clear_has_enOperation ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_ListOperation _enOperation;

};

/**
 * The result message of the method "FID_DAB_S_SET_COMP_LIST"
 * Open/Close a frozen component-list.
 * LCN2: Method for HMI
 * .
 */
class FID_DAB_S_SET_COMP_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTResult (const FID_DAB_S_SET_COMP_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_COMP_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_COMP_LISTResult& operator = (const FID_DAB_S_SET_COMP_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_COMP_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_COMP_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_COMP_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_COMP_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SET_COMP_LISTResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SET_COMP_LIST'
 */
class FID_DAB_S_SET_COMP_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTErrorStructure (const FID_DAB_S_SET_COMP_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SET_COMP_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_COMP_LISTErrorStructure& operator = (const FID_DAB_S_SET_COMP_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_COMP_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_COMP_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_COMP_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_COMP_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SET_COMP_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SET_COMP_LIST'
 */
class FID_DAB_S_SET_COMP_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SET_COMP_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SET_COMP_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_COMP_LISTError (const FID_DAB_S_SET_COMP_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_COMP_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SET_COMP_LISTError& operator = (const FID_DAB_S_SET_COMP_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_COMP_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_COMP_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_COMP_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_COMP_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SET_COMP_LISTError::FID_DAB_S_SET_COMP_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_SET_COMP_LISTError::FID_DAB_S_SET_COMP_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SET_COMP_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SET_COMP_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SET_COMP_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SET_COMP_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SET_COMP_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SET_COMP_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SET_COMP_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SET_COMP_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SET_COMP_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SET_COMP_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_SET_COMP_LISTErrorField __field;

    union {
        FID_DAB_S_SET_COMP_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_TEST_OPERATION"
 * Generic interface for test-commands
 */
class FID_DAB_S_TEST_OPERATIONStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONStart (const FID_DAB_S_TEST_OPERATIONStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONStart (::dabtuner_main_fi_types::T_e8_DAB_TestOperation enOperation_, uint32 u32Value1_, uint32 u32Value2_, uint32 u32Value3_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TEST_OPERATIONStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TEST_OPERATIONStart& operator = (const FID_DAB_S_TEST_OPERATIONStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TEST_OPERATIONStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TEST_OPERATIONStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TEST_OPERATIONStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TEST_OPERATIONStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enOperation"

    static const int kEnOperation = 0;

    /**
     * Clears the field "enOperation".
     *
     * The field will be set to its default value. The hasEnOperation()
     * method will return false.
     */
    inline void clearEnOperation();

    /**
     * Checks whether the field "enOperation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnOperation()). Otherwise it will return false.
     */
    inline bool hasEnOperation () const;

    /**
     * Returns the value of the member "enOperation".
     *
     * Operation and usage of parameters are described with type enOperation
     *
     * @return The value of the field "enOperation"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_TestOperation getEnOperation () const;

    /**
     * Sets the value of the member "enOperation".
     *
     * Operation and usage of parameters are described with type enOperation
     *
     * @param enOperation The value which will be set
     */
    inline void setEnOperation (::dabtuner_main_fi_types::T_e8_DAB_TestOperation enOperation_);

    // API of field "u32Value1"

    static const int kU32Value1 = 1;

    /**
     * Clears the field "u32Value1".
     *
     * The field will be set to its default value. The hasU32Value1()
     * method will return false.
     */
    inline void clearU32Value1();

    /**
     * Checks whether the field "u32Value1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value1()). Otherwise it will return false.
     */
    inline bool hasU32Value1 () const;

    /**
     * Returns the value of the member "u32Value1".
     *
     *
     *
     * @return The value of the field "u32Value1"
     */
    inline uint32 getU32Value1 () const;

    /**
     * Sets the value of the member "u32Value1".
     *
     *
     *
     * @param u32Value1 The value which will be set
     */
    inline void setU32Value1 (uint32 u32Value1_);

    // API of field "u32Value2"

    static const int kU32Value2 = 2;

    /**
     * Clears the field "u32Value2".
     *
     * The field will be set to its default value. The hasU32Value2()
     * method will return false.
     */
    inline void clearU32Value2();

    /**
     * Checks whether the field "u32Value2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value2()). Otherwise it will return false.
     */
    inline bool hasU32Value2 () const;

    /**
     * Returns the value of the member "u32Value2".
     *
     *
     *
     * @return The value of the field "u32Value2"
     */
    inline uint32 getU32Value2 () const;

    /**
     * Sets the value of the member "u32Value2".
     *
     *
     *
     * @param u32Value2 The value which will be set
     */
    inline void setU32Value2 (uint32 u32Value2_);

    // API of field "u32Value3"

    static const int kU32Value3 = 3;

    /**
     * Clears the field "u32Value3".
     *
     * The field will be set to its default value. The hasU32Value3()
     * method will return false.
     */
    inline void clearU32Value3();

    /**
     * Checks whether the field "u32Value3" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Value3()). Otherwise it will return false.
     */
    inline bool hasU32Value3 () const;

    /**
     * Returns the value of the member "u32Value3".
     *
     *
     *
     * @return The value of the field "u32Value3"
     */
    inline uint32 getU32Value3 () const;

    /**
     * Sets the value of the member "u32Value3".
     *
     *
     *
     * @param u32Value3 The value which will be set
     */
    inline void setU32Value3 (uint32 u32Value3_);

    static const FID_DAB_S_TEST_OPERATIONStart &getDefaultInstance();

private:

    inline void set_has_enOperation ();

    inline void clear_has_enOperation ();

    inline void set_has_u32Value1 ();

    inline void clear_has_u32Value1 ();

    inline void set_has_u32Value2 ();

    inline void clear_has_u32Value2 ();

    inline void set_has_u32Value3 ();

    inline void clear_has_u32Value3 ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_TestOperation _enOperation;

    uint32 _u32Value1;

    uint32 _u32Value2;

    uint32 _u32Value3;

};

/**
 * The result message of the method "FID_DAB_S_TEST_OPERATION"
 * Generic interface for test-commands
 * .
 */
class FID_DAB_S_TEST_OPERATIONResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONResult (const FID_DAB_S_TEST_OPERATIONResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TEST_OPERATIONResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TEST_OPERATIONResult& operator = (const FID_DAB_S_TEST_OPERATIONResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TEST_OPERATIONResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TEST_OPERATIONResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TEST_OPERATIONResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TEST_OPERATIONResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_TEST_OPERATIONResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_TEST_OPERATION'
 */
class FID_DAB_S_TEST_OPERATIONErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONErrorStructure (const FID_DAB_S_TEST_OPERATIONErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_TEST_OPERATIONErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TEST_OPERATIONErrorStructure& operator = (const FID_DAB_S_TEST_OPERATIONErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TEST_OPERATIONErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TEST_OPERATIONErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TEST_OPERATIONErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TEST_OPERATIONErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_TEST_OPERATIONErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_TEST_OPERATION'
 */
class FID_DAB_S_TEST_OPERATIONError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_TEST_OPERATIONErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_TEST_OPERATIONError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_TEST_OPERATIONError (const FID_DAB_S_TEST_OPERATIONError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TEST_OPERATIONError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_TEST_OPERATIONError& operator = (const FID_DAB_S_TEST_OPERATIONError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TEST_OPERATIONError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TEST_OPERATIONError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TEST_OPERATIONError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TEST_OPERATIONError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_TEST_OPERATIONError::FID_DAB_S_TEST_OPERATIONErrorField getField () const;

    inline void setField(FID_DAB_S_TEST_OPERATIONError::FID_DAB_S_TEST_OPERATIONErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_TEST_OPERATIONErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_TEST_OPERATIONErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_TEST_OPERATIONErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_TEST_OPERATIONErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_TEST_OPERATIONErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_TEST_OPERATIONErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_TEST_OPERATIONErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_TEST_OPERATIONErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_TEST_OPERATIONError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_TEST_OPERATIONError& rhs);

    inline void deleteData ();

    FID_DAB_S_TEST_OPERATIONErrorField __field;

    union {
        FID_DAB_S_TEST_OPERATIONErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_DEFAULT_SETTINGS"
 * Interface to set default settings
 */
class FID_DAB_S_DEFAULT_SETTINGSStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSStart (const FID_DAB_S_DEFAULT_SETTINGSStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSStart (bool bSet_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DEFAULT_SETTINGSStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DEFAULT_SETTINGSStart& operator = (const FID_DAB_S_DEFAULT_SETTINGSStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DEFAULT_SETTINGSStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DEFAULT_SETTINGSStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DEFAULT_SETTINGSStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DEFAULT_SETTINGSStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bSet"

    static const int kBSet = 0;

    /**
     * Clears the field "bSet".
     *
     * The field will be set to its default value. The hasBSet()
     * method will return false.
     */
    inline void clearBSet();

    /**
     * Checks whether the field "bSet" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBSet()). Otherwise it will return false.
     */
    inline bool hasBSet () const;

    /**
     * Returns the value of the member "bSet".
     *
     * set to true to set default settings
     *
     * @return The value of the field "bSet"
     */
    inline bool getBSet () const;

    /**
     * Sets the value of the member "bSet".
     *
     * set to true to set default settings
     *
     * @param bSet The value which will be set
     */
    inline void setBSet (bool bSet_);

    static const FID_DAB_S_DEFAULT_SETTINGSStart &getDefaultInstance();

private:

    inline void set_has_bSet ();

    inline void clear_has_bSet ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bSet;

};

/**
 * The result message of the method "FID_DAB_S_DEFAULT_SETTINGS"
 * Interface to set default settings
 * .
 */
class FID_DAB_S_DEFAULT_SETTINGSResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSResult (const FID_DAB_S_DEFAULT_SETTINGSResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DEFAULT_SETTINGSResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DEFAULT_SETTINGSResult& operator = (const FID_DAB_S_DEFAULT_SETTINGSResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DEFAULT_SETTINGSResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DEFAULT_SETTINGSResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DEFAULT_SETTINGSResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DEFAULT_SETTINGSResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_DEFAULT_SETTINGSResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_DEFAULT_SETTINGS'
 */
class FID_DAB_S_DEFAULT_SETTINGSErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSErrorStructure (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_DEFAULT_SETTINGSErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DEFAULT_SETTINGSErrorStructure& operator = (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_DEFAULT_SETTINGSErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_DEFAULT_SETTINGS'
 */
class FID_DAB_S_DEFAULT_SETTINGSError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_DEFAULT_SETTINGSErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_DEFAULT_SETTINGSError (const FID_DAB_S_DEFAULT_SETTINGSError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DEFAULT_SETTINGSError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_DEFAULT_SETTINGSError& operator = (const FID_DAB_S_DEFAULT_SETTINGSError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DEFAULT_SETTINGSError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DEFAULT_SETTINGSError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DEFAULT_SETTINGSError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DEFAULT_SETTINGSError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_DEFAULT_SETTINGSError::FID_DAB_S_DEFAULT_SETTINGSErrorField getField () const;

    inline void setField(FID_DAB_S_DEFAULT_SETTINGSError::FID_DAB_S_DEFAULT_SETTINGSErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_DEFAULT_SETTINGSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_DEFAULT_SETTINGSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_DEFAULT_SETTINGSErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_DEFAULT_SETTINGSErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_DEFAULT_SETTINGSErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_DEFAULT_SETTINGSErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_DEFAULT_SETTINGSErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_DEFAULT_SETTINGSError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_DEFAULT_SETTINGSError& rhs);

    inline void deleteData ();

    FID_DAB_S_DEFAULT_SETTINGSErrorField __field;

    union {
        FID_DAB_S_DEFAULT_SETTINGSErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The result message of the method "FID_DAB_S_STOP_ANNO"
 * Stop an selected announcement
 * .
 */
class FID_DAB_S_STOP_ANNOResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_STOP_ANNOResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_STOP_ANNOResult (const FID_DAB_S_STOP_ANNOResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_STOP_ANNOResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_STOP_ANNOResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_STOP_ANNOResult& operator = (const FID_DAB_S_STOP_ANNOResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_STOP_ANNOResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_STOP_ANNOResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_STOP_ANNOResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_STOP_ANNOResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_STOP_ANNOResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_STOP_ANNO'
 */
class FID_DAB_S_STOP_ANNOErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_STOP_ANNOErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_STOP_ANNOErrorStructure (const FID_DAB_S_STOP_ANNOErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_STOP_ANNOErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_STOP_ANNOErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_STOP_ANNOErrorStructure& operator = (const FID_DAB_S_STOP_ANNOErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_STOP_ANNOErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_STOP_ANNOErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_STOP_ANNOErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_STOP_ANNOErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_STOP_ANNOErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_STOP_ANNO'
 */
class FID_DAB_S_STOP_ANNOError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_STOP_ANNOErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_STOP_ANNOError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_STOP_ANNOError (const FID_DAB_S_STOP_ANNOError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_STOP_ANNOError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_STOP_ANNOError& operator = (const FID_DAB_S_STOP_ANNOError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_STOP_ANNOError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_STOP_ANNOError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_STOP_ANNOError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_STOP_ANNOError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_STOP_ANNOError::FID_DAB_S_STOP_ANNOErrorField getField () const;

    inline void setField(FID_DAB_S_STOP_ANNOError::FID_DAB_S_STOP_ANNOErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_STOP_ANNOErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_STOP_ANNOErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_STOP_ANNOErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_STOP_ANNOErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_STOP_ANNOErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_STOP_ANNOErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_STOP_ANNOErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_STOP_ANNOErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_STOP_ANNOError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_STOP_ANNOError& rhs);

    inline void deleteData ();

    FID_DAB_S_STOP_ANNOErrorField __field;

    union {
        FID_DAB_S_STOP_ANNOErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SELECT_TMC"
 * Select an ensemble with corresponding RDBID for tmc-data.
 * Selects an ensemble and a list rdbId to be decoded from components of this ensemble.
 */
class FID_DAB_S_SELECT_TMCStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_TMCStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_TMCStart (const FID_DAB_S_SELECT_TMCStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_TMCStart (uint32 u32EnsembleId_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& RdbIDList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_TMCStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_TMCStart& operator = (const FID_DAB_S_SELECT_TMCStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_TMCStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_TMCStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_TMCStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_TMCStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u32EnsembleId"

    static const int kU32EnsembleId = 0;

    /**
     * Clears the field "u32EnsembleId".
     *
     * The field will be set to its default value. The hasU32EnsembleId()
     * method will return false.
     */
    inline void clearU32EnsembleId();

    /**
     * Checks whether the field "u32EnsembleId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32EnsembleId()). Otherwise it will return false.
     */
    inline bool hasU32EnsembleId () const;

    /**
     * Returns the value of the member "u32EnsembleId".
     *
     * The ensemble-ID from which tmc-data shall be decoded.
     * If ensemble-ID==0 tmcDecoding will be stopped
     *
     * @return The value of the field "u32EnsembleId"
     */
    inline uint32 getU32EnsembleId () const;

    /**
     * Sets the value of the member "u32EnsembleId".
     *
     * The ensemble-ID from which tmc-data shall be decoded.
     * If ensemble-ID==0 tmcDecoding will be stopped
     *
     * @param u32EnsembleId The value which will be set
     */
    inline void setU32EnsembleId (uint32 u32EnsembleId_);

    // API of field "RdbIDList"

    static const int kRdbIDList = 1;

    /**
     * Clears the field "RdbIDList".
     *
     * The field will be set to its default value. The hasRdbIDList()
     * method will return false.
     */
    inline void clearRdbIDList();

    /**
     * Checks whether the field "RdbIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRdbIDList()). Otherwise it will return false.
     */
    inline bool hasRdbIDList () const;

    /**
     * Returns the value of the member "RdbIDList".
     *
     * List of RdbIds that shall be decoded.
     * For LCN2 only the first element will be used.
     * If list is empty tmcDecoding will be stopped
     *
     * @return The value of the field "RdbIDList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getRdbIDList () const;

    /**
     * Retrieves the value of the field "RdbIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RdbIDList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getRdbIDListMutable ();

    /**
     * Sets the value of the member "RdbIDList".
     *
     * List of RdbIds that shall be decoded.
     * For LCN2 only the first element will be used.
     * If list is empty tmcDecoding will be stopped
     *
     * @param RdbIDList The value which will be set
     */
    inline void setRdbIDList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& RdbIDList_);

    static const FID_DAB_S_SELECT_TMCStart &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getT_DAB_RdbIdList_DefaultInstance ();

    inline void set_has_u32EnsembleId ();

    inline void clear_has_u32EnsembleId ();

    inline void set_has_RdbIDList ();

    inline void clear_has_RdbIDList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint32 _u32EnsembleId;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId > _RdbIDList;

};

/**
 * The result message of the method "FID_DAB_S_SELECT_TMC"
 * Select an ensemble with corresponding RDBID for tmc-data.
 * .
 */
class FID_DAB_S_SELECT_TMCResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_TMCResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_TMCResult (const FID_DAB_S_SELECT_TMCResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_TMCResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_TMCResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_TMCResult& operator = (const FID_DAB_S_SELECT_TMCResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_TMCResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_TMCResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_TMCResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_TMCResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SELECT_TMCResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SELECT_TMC'
 */
class FID_DAB_S_SELECT_TMCErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SELECT_TMCErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_TMCErrorStructure (const FID_DAB_S_SELECT_TMCErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SELECT_TMCErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SELECT_TMCErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SELECT_TMCErrorStructure& operator = (const FID_DAB_S_SELECT_TMCErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_TMCErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_TMCErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_TMCErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_TMCErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SELECT_TMCErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SELECT_TMC'
 */
class FID_DAB_S_SELECT_TMCError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SELECT_TMCErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SELECT_TMCError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SELECT_TMCError (const FID_DAB_S_SELECT_TMCError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SELECT_TMCError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SELECT_TMCError& operator = (const FID_DAB_S_SELECT_TMCError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SELECT_TMCError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SELECT_TMCError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SELECT_TMCError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SELECT_TMCError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SELECT_TMCError::FID_DAB_S_SELECT_TMCErrorField getField () const;

    inline void setField(FID_DAB_S_SELECT_TMCError::FID_DAB_S_SELECT_TMCErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SELECT_TMCErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SELECT_TMCErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SELECT_TMCErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SELECT_TMCErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SELECT_TMCErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SELECT_TMCErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SELECT_TMCErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SELECT_TMCErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SELECT_TMCError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SELECT_TMCError& rhs);

    inline void deleteData ();

    FID_DAB_S_SELECT_TMCErrorField __field;

    union {
        FID_DAB_S_SELECT_TMCErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_TPEG_URI_LIST"
 * With this command we get the DAB TPEG URI list with all receivable TPEG services.
 */
class FID_DAB_S_TPEG_URI_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTStart (const FID_DAB_S_TPEG_URI_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTStart (uint8 u8NumberOfElements_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TPEG_URI_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TPEG_URI_LISTStart& operator = (const FID_DAB_S_TPEG_URI_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TPEG_URI_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TPEG_URI_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TPEG_URI_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TPEG_URI_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8NumberOfElements"

    static const int kU8NumberOfElements = 0;

    /**
     * Clears the field "u8NumberOfElements".
     *
     * The field will be set to its default value. The hasU8NumberOfElements()
     * method will return false.
     */
    inline void clearU8NumberOfElements();

    /**
     * Checks whether the field "u8NumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfElements () const;

    /**
     * Returns the value of the member "u8NumberOfElements".
     *
     * The number of elements requested (0 means all).
     *
     * @return The value of the field "u8NumberOfElements"
     */
    inline uint8 getU8NumberOfElements () const;

    /**
     * Sets the value of the member "u8NumberOfElements".
     *
     * The number of elements requested (0 means all).
     *
     * @param u8NumberOfElements The value which will be set
     */
    inline void setU8NumberOfElements (uint8 u8NumberOfElements_);

    static const FID_DAB_S_TPEG_URI_LISTStart &getDefaultInstance();

private:

    inline void set_has_u8NumberOfElements ();

    inline void clear_has_u8NumberOfElements ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8NumberOfElements;

};

/**
 * The result message of the method "FID_DAB_S_TPEG_URI_LIST"
 * With this command we get the DAB TPEG URI list with all receivable TPEG services.
 * .
 */
class FID_DAB_S_TPEG_URI_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTResult (const FID_DAB_S_TPEG_URI_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& TpegUriChannelList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TPEG_URI_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TPEG_URI_LISTResult& operator = (const FID_DAB_S_TPEG_URI_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TPEG_URI_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TPEG_URI_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TPEG_URI_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TPEG_URI_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    // API of field "TpegUriChannelList"

    static const int kTpegUriChannelList = 1;

    /**
     * Clears the field "TpegUriChannelList".
     *
     * The field will be set to its default value. The hasTpegUriChannelList()
     * method will return false.
     */
    inline void clearTpegUriChannelList();

    /**
     * Checks whether the field "TpegUriChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTpegUriChannelList()). Otherwise it will return false.
     */
    inline bool hasTpegUriChannelList () const;

    /**
     * Returns the value of the member "TpegUriChannelList".
     *
     * Data for the requested section of tpeg elements
     *
     * @return The value of the field "TpegUriChannelList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& getTpegUriChannelList () const;

    /**
     * Retrieves the value of the field "TpegUriChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TpegUriChannelList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& getTpegUriChannelListMutable ();

    /**
     * Sets the value of the member "TpegUriChannelList".
     *
     * Data for the requested section of tpeg elements
     *
     * @param TpegUriChannelList The value which will be set
     */
    inline void setTpegUriChannelList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& TpegUriChannelList_);

    static const FID_DAB_S_TPEG_URI_LISTResult &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& getT_DAB_TpegUriChannelList_DefaultInstance ();

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    inline void set_has_TpegUriChannelList ();

    inline void clear_has_TpegUriChannelList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel > _TpegUriChannelList;

};

/**
 * The error message of 'FID_DAB_S_TPEG_URI_LIST'
 */
class FID_DAB_S_TPEG_URI_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTErrorStructure (const FID_DAB_S_TPEG_URI_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_TPEG_URI_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TPEG_URI_LISTErrorStructure& operator = (const FID_DAB_S_TPEG_URI_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TPEG_URI_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TPEG_URI_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TPEG_URI_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TPEG_URI_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_TPEG_URI_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_TPEG_URI_LIST'
 */
class FID_DAB_S_TPEG_URI_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_TPEG_URI_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_TPEG_URI_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_TPEG_URI_LISTError (const FID_DAB_S_TPEG_URI_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TPEG_URI_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_TPEG_URI_LISTError& operator = (const FID_DAB_S_TPEG_URI_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TPEG_URI_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TPEG_URI_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TPEG_URI_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TPEG_URI_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_TPEG_URI_LISTError::FID_DAB_S_TPEG_URI_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_TPEG_URI_LISTError::FID_DAB_S_TPEG_URI_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_TPEG_URI_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_TPEG_URI_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_TPEG_URI_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_TPEG_URI_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_TPEG_URI_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_TPEG_URI_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_TPEG_URI_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_TPEG_URI_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_TPEG_URI_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_TPEG_URI_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_TPEG_URI_LISTErrorField __field;

    union {
        FID_DAB_S_TPEG_URI_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SET_TPEG_CHN"
 * With this command the DAB TPEG URI can be selected.
 */
class FID_DAB_S_SET_TPEG_CHNStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNStart (const FID_DAB_S_SET_TPEG_CHNStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNStart (bool bActive_, const ::dabtuner_main_fi_types::T_DAB_TpegUriChannel& sTpegUriChn_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_TPEG_CHNStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_TPEG_CHNStart& operator = (const FID_DAB_S_SET_TPEG_CHNStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TPEG_CHNStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TPEG_CHNStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TPEG_CHNStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TPEG_CHNStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bActive"

    static const int kBActive = 0;

    /**
     * Clears the field "bActive".
     *
     * The field will be set to its default value. The hasBActive()
     * method will return false.
     */
    inline void clearBActive();

    /**
     * Checks whether the field "bActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActive()). Otherwise it will return false.
     */
    inline bool hasBActive () const;

    /**
     * Returns the value of the member "bActive".
     *
     * TRUE==activate tpeg channel, FALSE=deactivate tpeg channel.
     *
     * @return The value of the field "bActive"
     */
    inline bool getBActive () const;

    /**
     * Sets the value of the member "bActive".
     *
     * TRUE==activate tpeg channel, FALSE=deactivate tpeg channel.
     *
     * @param bActive The value which will be set
     */
    inline void setBActive (bool bActive_);

    // API of field "sTpegUriChn"

    static const int kSTpegUriChn = 1;

    /**
     * Clears the field "sTpegUriChn".
     *
     * The field will be set to its default value. The hasSTpegUriChn()
     * method will return false.
     */
    inline void clearSTpegUriChn();

    /**
     * Checks whether the field "sTpegUriChn" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSTpegUriChn()). Otherwise it will return false.
     */
    inline bool hasSTpegUriChn () const;

    /**
     * Returns the value of the member "sTpegUriChn".
     *
     * The selected tpeg uri channel.
     *
     * @return The value of the field "sTpegUriChn"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_TpegUriChannel& getSTpegUriChn () const;

    /**
     * Retrieves the value of the field "sTpegUriChn" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sTpegUriChn".
     */
    inline ::dabtuner_main_fi_types::T_DAB_TpegUriChannel& getSTpegUriChnMutable ();

    /**
     * Sets the value of the member "sTpegUriChn".
     *
     * The selected tpeg uri channel.
     *
     * @param sTpegUriChn The value which will be set
     */
    inline void setSTpegUriChn (const ::dabtuner_main_fi_types::T_DAB_TpegUriChannel& sTpegUriChn_);

    static const FID_DAB_S_SET_TPEG_CHNStart &getDefaultInstance();

private:

    inline void set_has_bActive ();

    inline void clear_has_bActive ();

    inline void set_has_sTpegUriChn ();

    inline void clear_has_sTpegUriChn ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bActive;

    ::dabtuner_main_fi_types::T_DAB_TpegUriChannel _sTpegUriChn;

};

/**
 * The result message of the method "FID_DAB_S_SET_TPEG_CHN"
 * With this command the DAB TPEG URI can be selected.
 * .
 */
class FID_DAB_S_SET_TPEG_CHNResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNResult (const FID_DAB_S_SET_TPEG_CHNResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_TPEG_CHNResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_TPEG_CHNResult& operator = (const FID_DAB_S_SET_TPEG_CHNResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TPEG_CHNResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TPEG_CHNResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TPEG_CHNResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TPEG_CHNResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SET_TPEG_CHNResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SET_TPEG_CHN'
 */
class FID_DAB_S_SET_TPEG_CHNErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNErrorStructure (const FID_DAB_S_SET_TPEG_CHNErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SET_TPEG_CHNErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_TPEG_CHNErrorStructure& operator = (const FID_DAB_S_SET_TPEG_CHNErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TPEG_CHNErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TPEG_CHNErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TPEG_CHNErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TPEG_CHNErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SET_TPEG_CHNErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SET_TPEG_CHN'
 */
class FID_DAB_S_SET_TPEG_CHNError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SET_TPEG_CHNErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SET_TPEG_CHNError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TPEG_CHNError (const FID_DAB_S_SET_TPEG_CHNError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_TPEG_CHNError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SET_TPEG_CHNError& operator = (const FID_DAB_S_SET_TPEG_CHNError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TPEG_CHNError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TPEG_CHNError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TPEG_CHNError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TPEG_CHNError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SET_TPEG_CHNError::FID_DAB_S_SET_TPEG_CHNErrorField getField () const;

    inline void setField(FID_DAB_S_SET_TPEG_CHNError::FID_DAB_S_SET_TPEG_CHNErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SET_TPEG_CHNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SET_TPEG_CHNErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SET_TPEG_CHNErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SET_TPEG_CHNErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SET_TPEG_CHNErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SET_TPEG_CHNErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SET_TPEG_CHNErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SET_TPEG_CHNErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SET_TPEG_CHNError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SET_TPEG_CHNError& rhs);

    inline void deleteData ();

    FID_DAB_S_SET_TPEG_CHNErrorField __field;

    union {
        FID_DAB_S_SET_TPEG_CHNErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_RDBID_WISH_LIST"
 * These RDBIDs should be handled.
 * list of rdbIds, which are currently supported by Tima.
 */
class FID_DAB_S_RDBID_WISH_LISTStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTStart (const FID_DAB_S_RDBID_WISH_LISTStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTStart (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& RdbIDList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_RDBID_WISH_LISTStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_RDBID_WISH_LISTStart& operator = (const FID_DAB_S_RDBID_WISH_LISTStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_RDBID_WISH_LISTStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_RDBID_WISH_LISTStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_RDBID_WISH_LISTStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_RDBID_WISH_LISTStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RdbIDList"

    static const int kRdbIDList = 0;

    /**
     * Clears the field "RdbIDList".
     *
     * The field will be set to its default value. The hasRdbIDList()
     * method will return false.
     */
    inline void clearRdbIDList();

    /**
     * Checks whether the field "RdbIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRdbIDList()). Otherwise it will return false.
     */
    inline bool hasRdbIDList () const;

    /**
     * Returns the value of the member "RdbIDList".
     *
     *
     *
     * @return The value of the field "RdbIDList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getRdbIDList () const;

    /**
     * Retrieves the value of the field "RdbIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RdbIDList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getRdbIDListMutable ();

    /**
     * Sets the value of the member "RdbIDList".
     *
     *
     *
     * @param RdbIDList The value which will be set
     */
    inline void setRdbIDList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& RdbIDList_);

    static const FID_DAB_S_RDBID_WISH_LISTStart &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getT_DAB_RdbIdList_DefaultInstance ();

    inline void set_has_RdbIDList ();

    inline void clear_has_RdbIDList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId > _RdbIDList;

};

/**
 * The result message of the method "FID_DAB_S_RDBID_WISH_LIST"
 * These RDBIDs should be handled.
 * list of rdbids, which can be supported.
 */
class FID_DAB_S_RDBID_WISH_LISTResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTResult (const FID_DAB_S_RDBID_WISH_LISTResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTResult (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& RdbIDList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_RDBID_WISH_LISTResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_RDBID_WISH_LISTResult& operator = (const FID_DAB_S_RDBID_WISH_LISTResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_RDBID_WISH_LISTResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_RDBID_WISH_LISTResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_RDBID_WISH_LISTResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_RDBID_WISH_LISTResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RdbIDList"

    static const int kRdbIDList = 0;

    /**
     * Clears the field "RdbIDList".
     *
     * The field will be set to its default value. The hasRdbIDList()
     * method will return false.
     */
    inline void clearRdbIDList();

    /**
     * Checks whether the field "RdbIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRdbIDList()). Otherwise it will return false.
     */
    inline bool hasRdbIDList () const;

    /**
     * Returns the value of the member "RdbIDList".
     *
     *
     *
     * @return The value of the field "RdbIDList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getRdbIDList () const;

    /**
     * Retrieves the value of the field "RdbIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RdbIDList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getRdbIDListMutable ();

    /**
     * Sets the value of the member "RdbIDList".
     *
     *
     *
     * @param RdbIDList The value which will be set
     */
    inline void setRdbIDList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& RdbIDList_);

    static const FID_DAB_S_RDBID_WISH_LISTResult &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId >& getT_DAB_RdbIdList_DefaultInstance ();

    inline void set_has_RdbIDList ();

    inline void clear_has_RdbIDList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_RdbId > _RdbIDList;

};

/**
 * The error message of 'FID_DAB_S_RDBID_WISH_LIST'
 */
class FID_DAB_S_RDBID_WISH_LISTErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTErrorStructure (const FID_DAB_S_RDBID_WISH_LISTErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_RDBID_WISH_LISTErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_RDBID_WISH_LISTErrorStructure& operator = (const FID_DAB_S_RDBID_WISH_LISTErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_RDBID_WISH_LISTErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_RDBID_WISH_LISTErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_RDBID_WISH_LISTErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_RDBID_WISH_LISTErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_RDBID_WISH_LISTErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_RDBID_WISH_LIST'
 */
class FID_DAB_S_RDBID_WISH_LISTError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_RDBID_WISH_LISTErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_RDBID_WISH_LISTError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_RDBID_WISH_LISTError (const FID_DAB_S_RDBID_WISH_LISTError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_RDBID_WISH_LISTError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_RDBID_WISH_LISTError& operator = (const FID_DAB_S_RDBID_WISH_LISTError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_RDBID_WISH_LISTError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_RDBID_WISH_LISTError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_RDBID_WISH_LISTError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_RDBID_WISH_LISTError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_RDBID_WISH_LISTError::FID_DAB_S_RDBID_WISH_LISTErrorField getField () const;

    inline void setField(FID_DAB_S_RDBID_WISH_LISTError::FID_DAB_S_RDBID_WISH_LISTErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_RDBID_WISH_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_RDBID_WISH_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_RDBID_WISH_LISTErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_RDBID_WISH_LISTErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_RDBID_WISH_LISTErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_RDBID_WISH_LISTErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_RDBID_WISH_LISTErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_RDBID_WISH_LISTErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_RDBID_WISH_LISTError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_RDBID_WISH_LISTError& rhs);

    inline void deleteData ();

    FID_DAB_S_RDBID_WISH_LISTErrorField __field;

    union {
        FID_DAB_S_RDBID_WISH_LISTErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SET_TESTMODE"
 * Starts/Stops receiving of testmode-data
 * Select testmode-data.
 */
class FID_DAB_S_SET_TESTMODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_TESTMODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TESTMODEStart (const FID_DAB_S_SET_TESTMODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_TESTMODEStart (bool bActive_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_TESTMODEStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_TESTMODEStart& operator = (const FID_DAB_S_SET_TESTMODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TESTMODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TESTMODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TESTMODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TESTMODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bActive"

    static const int kBActive = 0;

    /**
     * Clears the field "bActive".
     *
     * The field will be set to its default value. The hasBActive()
     * method will return false.
     */
    inline void clearBActive();

    /**
     * Checks whether the field "bActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActive()). Otherwise it will return false.
     */
    inline bool hasBActive () const;

    /**
     * Returns the value of the member "bActive".
     *
     * TRUE==request testmode-data, FALSE=release testmode-data.
     *
     * @return The value of the field "bActive"
     */
    inline bool getBActive () const;

    /**
     * Sets the value of the member "bActive".
     *
     * TRUE==request testmode-data, FALSE=release testmode-data.
     *
     * @param bActive The value which will be set
     */
    inline void setBActive (bool bActive_);

    static const FID_DAB_S_SET_TESTMODEStart &getDefaultInstance();

private:

    inline void set_has_bActive ();

    inline void clear_has_bActive ();

    uint32 _has_bits_[ (1 + 31) / 32];

    bool _bActive;

};

/**
 * The result message of the method "FID_DAB_S_SET_TESTMODE"
 * Starts/Stops receiving of testmode-data
 * .
 */
class FID_DAB_S_SET_TESTMODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_TESTMODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TESTMODEResult (const FID_DAB_S_SET_TESTMODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_TESTMODEResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_TESTMODEResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_TESTMODEResult& operator = (const FID_DAB_S_SET_TESTMODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TESTMODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TESTMODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TESTMODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TESTMODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SET_TESTMODEResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SET_TESTMODE'
 */
class FID_DAB_S_SET_TESTMODEErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_TESTMODEErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TESTMODEErrorStructure (const FID_DAB_S_SET_TESTMODEErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_TESTMODEErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SET_TESTMODEErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_TESTMODEErrorStructure& operator = (const FID_DAB_S_SET_TESTMODEErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TESTMODEErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TESTMODEErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TESTMODEErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TESTMODEErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SET_TESTMODEErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SET_TESTMODE'
 */
class FID_DAB_S_SET_TESTMODEError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SET_TESTMODEErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SET_TESTMODEError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_TESTMODEError (const FID_DAB_S_SET_TESTMODEError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_TESTMODEError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SET_TESTMODEError& operator = (const FID_DAB_S_SET_TESTMODEError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_TESTMODEError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_TESTMODEError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_TESTMODEError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_TESTMODEError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SET_TESTMODEError::FID_DAB_S_SET_TESTMODEErrorField getField () const;

    inline void setField(FID_DAB_S_SET_TESTMODEError::FID_DAB_S_SET_TESTMODEErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SET_TESTMODEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SET_TESTMODEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SET_TESTMODEErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SET_TESTMODEErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SET_TESTMODEErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SET_TESTMODEErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SET_TESTMODEErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SET_TESTMODEErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SET_TESTMODEError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SET_TESTMODEError& rhs);

    inline void deleteData ();

    FID_DAB_S_SET_TESTMODEErrorField __field;

    union {
        FID_DAB_S_SET_TESTMODEErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_GET_EXP_API_INFO"
 * Gets labeltext and expert value for ADR3 internal expert id
 * request data for expert id.
 */
class FID_DAB_S_GET_EXP_API_INFOStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOStart (const FID_DAB_S_GET_EXP_API_INFOStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOStart (uint16 u16ExpApiId_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_EXP_API_INFOStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_EXP_API_INFOStart& operator = (const FID_DAB_S_GET_EXP_API_INFOStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_EXP_API_INFOStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_EXP_API_INFOStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_EXP_API_INFOStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_EXP_API_INFOStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ExpApiId"

    static const int kU16ExpApiId = 0;

    /**
     * Clears the field "u16ExpApiId".
     *
     * The field will be set to its default value. The hasU16ExpApiId()
     * method will return false.
     */
    inline void clearU16ExpApiId();

    /**
     * Checks whether the field "u16ExpApiId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ExpApiId()). Otherwise it will return false.
     */
    inline bool hasU16ExpApiId () const;

    /**
     * Returns the value of the member "u16ExpApiId".
     *
     * expert api id (range 0x0000 - 0xFFFF).
     *
     * @return The value of the field "u16ExpApiId"
     */
    inline uint16 getU16ExpApiId () const;

    /**
     * Sets the value of the member "u16ExpApiId".
     *
     * expert api id (range 0x0000 - 0xFFFF).
     *
     * @param u16ExpApiId The value which will be set
     */
    inline void setU16ExpApiId (uint16 u16ExpApiId_);

    static const FID_DAB_S_GET_EXP_API_INFOStart &getDefaultInstance();

private:

    inline void set_has_u16ExpApiId ();

    inline void clear_has_u16ExpApiId ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ExpApiId;

};

/**
 * The result message of the method "FID_DAB_S_GET_EXP_API_INFO"
 * Gets labeltext and expert value for ADR3 internal expert id
 */
class FID_DAB_S_GET_EXP_API_INFOResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOResult (const FID_DAB_S_GET_EXP_API_INFOResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOResult (uint16 u16ExpApiId_, const ::std::string& sLabel_, const ::std::string& sValue_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_EXP_API_INFOResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_EXP_API_INFOResult& operator = (const FID_DAB_S_GET_EXP_API_INFOResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_EXP_API_INFOResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_EXP_API_INFOResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_EXP_API_INFOResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_EXP_API_INFOResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ExpApiId"

    static const int kU16ExpApiId = 0;

    /**
     * Clears the field "u16ExpApiId".
     *
     * The field will be set to its default value. The hasU16ExpApiId()
     * method will return false.
     */
    inline void clearU16ExpApiId();

    /**
     * Checks whether the field "u16ExpApiId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ExpApiId()). Otherwise it will return false.
     */
    inline bool hasU16ExpApiId () const;

    /**
     * Returns the value of the member "u16ExpApiId".
     *
     * expert api id (range 0x0000 - 0xFFFF).
     *
     * @return The value of the field "u16ExpApiId"
     */
    inline uint16 getU16ExpApiId () const;

    /**
     * Sets the value of the member "u16ExpApiId".
     *
     * expert api id (range 0x0000 - 0xFFFF).
     *
     * @param u16ExpApiId The value which will be set
     */
    inline void setU16ExpApiId (uint16 u16ExpApiId_);

    // API of field "sLabel"

    static const int kSLabel = 1;

    /**
     * Clears the field "sLabel".
     *
     * The field will be set to its default value. The hasSLabel()
     * method will return false.
     */
    inline void clearSLabel();

    /**
     * Checks whether the field "sLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSLabel()). Otherwise it will return false.
     */
    inline bool hasSLabel () const;

    /**
     * Returns the value of the member "sLabel".
     *
     * labeltext to corresponding expert id.
     *
     * @return The value of the field "sLabel"
     */
    inline const ::std::string& getSLabel () const;

    /**
     * Retrieves the value of the field "sLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sLabel".
     */
    inline ::std::string& getSLabelMutable ();

    /**
     * Sets the value of the member "sLabel".
     *
     * labeltext to corresponding expert id.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const ::std::string& sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * labeltext to corresponding expert id.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* sLabel_);

    /**
     * Sets the value of the member "sLabel".
     *
     * labeltext to corresponding expert id.
     *
     * @param sLabel The value which will be set
     */
    inline void setSLabel (const char* value, size_t size);

    // API of field "sValue"

    static const int kSValue = 2;

    /**
     * Clears the field "sValue".
     *
     * The field will be set to its default value. The hasSValue()
     * method will return false.
     */
    inline void clearSValue();

    /**
     * Checks whether the field "sValue" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSValue()). Otherwise it will return false.
     */
    inline bool hasSValue () const;

    /**
     * Returns the value of the member "sValue".
     *
     * value to corresponding expert id.
     *
     * @return The value of the field "sValue"
     */
    inline const ::std::string& getSValue () const;

    /**
     * Retrieves the value of the field "sValue" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sValue".
     */
    inline ::std::string& getSValueMutable ();

    /**
     * Sets the value of the member "sValue".
     *
     * value to corresponding expert id.
     *
     * @param sValue The value which will be set
     */
    inline void setSValue (const ::std::string& sValue_);

    /**
     * Sets the value of the member "sValue".
     *
     * value to corresponding expert id.
     *
     * @param sValue The value which will be set
     */
    inline void setSValue (const char* sValue_);

    /**
     * Sets the value of the member "sValue".
     *
     * value to corresponding expert id.
     *
     * @param sValue The value which will be set
     */
    inline void setSValue (const char* value, size_t size);

    static const FID_DAB_S_GET_EXP_API_INFOResult &getDefaultInstance();

private:

    inline void set_has_u16ExpApiId ();

    inline void clear_has_u16ExpApiId ();

    inline void set_has_sLabel ();

    inline void clear_has_sLabel ();

    inline void set_has_sValue ();

    inline void clear_has_sValue ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint16 _u16ExpApiId;

    ::std::string _sLabel;

    ::std::string _sValue;

};

/**
 * The error message of 'FID_DAB_S_GET_EXP_API_INFO'
 */
class FID_DAB_S_GET_EXP_API_INFOErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOErrorStructure (const FID_DAB_S_GET_EXP_API_INFOErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_GET_EXP_API_INFOErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_GET_EXP_API_INFOErrorStructure& operator = (const FID_DAB_S_GET_EXP_API_INFOErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_EXP_API_INFOErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_EXP_API_INFOErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_EXP_API_INFOErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_EXP_API_INFOErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_GET_EXP_API_INFOErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_GET_EXP_API_INFO'
 */
class FID_DAB_S_GET_EXP_API_INFOError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_GET_EXP_API_INFOErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_GET_EXP_API_INFOError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_GET_EXP_API_INFOError (const FID_DAB_S_GET_EXP_API_INFOError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_GET_EXP_API_INFOError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_GET_EXP_API_INFOError& operator = (const FID_DAB_S_GET_EXP_API_INFOError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_GET_EXP_API_INFOError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_GET_EXP_API_INFOError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_GET_EXP_API_INFOError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_GET_EXP_API_INFOError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_GET_EXP_API_INFOError::FID_DAB_S_GET_EXP_API_INFOErrorField getField () const;

    inline void setField(FID_DAB_S_GET_EXP_API_INFOError::FID_DAB_S_GET_EXP_API_INFOErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_GET_EXP_API_INFOErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_GET_EXP_API_INFOErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_GET_EXP_API_INFOErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_GET_EXP_API_INFOErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_GET_EXP_API_INFOErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_GET_EXP_API_INFOErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_GET_EXP_API_INFOErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_GET_EXP_API_INFOErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_GET_EXP_API_INFOError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_GET_EXP_API_INFOError& rhs);

    inline void deleteData ();

    FID_DAB_S_GET_EXP_API_INFOErrorField __field;

    union {
        FID_DAB_S_GET_EXP_API_INFOErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_DB_QUERY"
 * requests a database query from adr3
 */
class FID_DAB_S_DB_QUERYStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DB_QUERYStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DB_QUERYStart (const FID_DAB_S_DB_QUERYStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DB_QUERYStart (uint8 u8Adr3DbQuery_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DB_QUERYStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DB_QUERYStart& operator = (const FID_DAB_S_DB_QUERYStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DB_QUERYStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DB_QUERYStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DB_QUERYStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DB_QUERYStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Adr3DbQuery"

    static const int kU8Adr3DbQuery = 0;

    /**
     * Clears the field "u8Adr3DbQuery".
     *
     * The field will be set to its default value. The hasU8Adr3DbQuery()
     * method will return false.
     */
    inline void clearU8Adr3DbQuery();

    /**
     * Checks whether the field "u8Adr3DbQuery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Adr3DbQuery()). Otherwise it will return false.
     */
    inline bool hasU8Adr3DbQuery () const;

    /**
     * Returns the value of the member "u8Adr3DbQuery".
     *
     * request number to corresponding screen (range: 1-8)
     *
     * @return The value of the field "u8Adr3DbQuery"
     */
    inline uint8 getU8Adr3DbQuery () const;

    /**
     * Sets the value of the member "u8Adr3DbQuery".
     *
     * request number to corresponding screen (range: 1-8)
     *
     * @param u8Adr3DbQuery The value which will be set
     */
    inline void setU8Adr3DbQuery (uint8 u8Adr3DbQuery_);

    static const FID_DAB_S_DB_QUERYStart &getDefaultInstance();

private:

    inline void set_has_u8Adr3DbQuery ();

    inline void clear_has_u8Adr3DbQuery ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8Adr3DbQuery;

};

/**
 * The result message of the method "FID_DAB_S_DB_QUERY"
 * requests a database query from adr3
 */
class FID_DAB_S_DB_QUERYResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DB_QUERYResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DB_QUERYResult (const FID_DAB_S_DB_QUERYResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DB_QUERYResult (uint8 u8Adr3DbQuery_, const ::std::string& sDbQuery_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DB_QUERYResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DB_QUERYResult& operator = (const FID_DAB_S_DB_QUERYResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DB_QUERYResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DB_QUERYResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DB_QUERYResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DB_QUERYResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Adr3DbQuery"

    static const int kU8Adr3DbQuery = 0;

    /**
     * Clears the field "u8Adr3DbQuery".
     *
     * The field will be set to its default value. The hasU8Adr3DbQuery()
     * method will return false.
     */
    inline void clearU8Adr3DbQuery();

    /**
     * Checks whether the field "u8Adr3DbQuery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Adr3DbQuery()). Otherwise it will return false.
     */
    inline bool hasU8Adr3DbQuery () const;

    /**
     * Returns the value of the member "u8Adr3DbQuery".
     *
     * requested query. (range: 1-8)
     *
     * @return The value of the field "u8Adr3DbQuery"
     */
    inline uint8 getU8Adr3DbQuery () const;

    /**
     * Sets the value of the member "u8Adr3DbQuery".
     *
     * requested query. (range: 1-8)
     *
     * @param u8Adr3DbQuery The value which will be set
     */
    inline void setU8Adr3DbQuery (uint8 u8Adr3DbQuery_);

    // API of field "sDbQuery"

    static const int kSDbQuery = 1;

    /**
     * Clears the field "sDbQuery".
     *
     * The field will be set to its default value. The hasSDbQuery()
     * method will return false.
     */
    inline void clearSDbQuery();

    /**
     * Checks whether the field "sDbQuery" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSDbQuery()). Otherwise it will return false.
     */
    inline bool hasSDbQuery () const;

    /**
     * Returns the value of the member "sDbQuery".
     *
     * formatted string from adr3.
     *
     * @return The value of the field "sDbQuery"
     */
    inline const ::std::string& getSDbQuery () const;

    /**
     * Retrieves the value of the field "sDbQuery" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "sDbQuery".
     */
    inline ::std::string& getSDbQueryMutable ();

    /**
     * Sets the value of the member "sDbQuery".
     *
     * formatted string from adr3.
     *
     * @param sDbQuery The value which will be set
     */
    inline void setSDbQuery (const ::std::string& sDbQuery_);

    /**
     * Sets the value of the member "sDbQuery".
     *
     * formatted string from adr3.
     *
     * @param sDbQuery The value which will be set
     */
    inline void setSDbQuery (const char* sDbQuery_);

    /**
     * Sets the value of the member "sDbQuery".
     *
     * formatted string from adr3.
     *
     * @param sDbQuery The value which will be set
     */
    inline void setSDbQuery (const char* value, size_t size);

    static const FID_DAB_S_DB_QUERYResult &getDefaultInstance();

private:

    inline void set_has_u8Adr3DbQuery ();

    inline void clear_has_u8Adr3DbQuery ();

    inline void set_has_sDbQuery ();

    inline void clear_has_sDbQuery ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _u8Adr3DbQuery;

    ::std::string _sDbQuery;

};

/**
 * The error message of 'FID_DAB_S_DB_QUERY'
 */
class FID_DAB_S_DB_QUERYErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DB_QUERYErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DB_QUERYErrorStructure (const FID_DAB_S_DB_QUERYErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DB_QUERYErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_DB_QUERYErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DB_QUERYErrorStructure& operator = (const FID_DAB_S_DB_QUERYErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DB_QUERYErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DB_QUERYErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DB_QUERYErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DB_QUERYErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_DB_QUERYErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_DB_QUERY'
 */
class FID_DAB_S_DB_QUERYError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_DB_QUERYErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_DB_QUERYError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_DB_QUERYError (const FID_DAB_S_DB_QUERYError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DB_QUERYError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_DB_QUERYError& operator = (const FID_DAB_S_DB_QUERYError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DB_QUERYError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DB_QUERYError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DB_QUERYError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DB_QUERYError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_DB_QUERYError::FID_DAB_S_DB_QUERYErrorField getField () const;

    inline void setField(FID_DAB_S_DB_QUERYError::FID_DAB_S_DB_QUERYErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_DB_QUERYErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_DB_QUERYErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_DB_QUERYErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_DB_QUERYErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_DB_QUERYErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_DB_QUERYErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_DB_QUERYErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_DB_QUERYErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_DB_QUERYError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_DB_QUERYError& rhs);

    inline void deleteData ();

    FID_DAB_S_DB_QUERYErrorField __field;

    union {
        FID_DAB_S_DB_QUERYErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SEEK_ENSEMBLE"
 * Seek to next/prev ensemble (only in testmode)
 */
class FID_DAB_S_SEEK_ENSEMBLEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEStart (const FID_DAB_S_SEEK_ENSEMBLEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEStart (::dabtuner_main_fi_types::T_e8_DAB_TuneCmd enTuneCmd_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SEEK_ENSEMBLEStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SEEK_ENSEMBLEStart& operator = (const FID_DAB_S_SEEK_ENSEMBLEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_ENSEMBLEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_ENSEMBLEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_ENSEMBLEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_ENSEMBLEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTuneCmd"

    static const int kEnTuneCmd = 0;

    /**
     * Clears the field "enTuneCmd".
     *
     * The field will be set to its default value. The hasEnTuneCmd()
     * method will return false.
     */
    inline void clearEnTuneCmd();

    /**
     * Checks whether the field "enTuneCmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTuneCmd()). Otherwise it will return false.
     */
    inline bool hasEnTuneCmd () const;

    /**
     * Returns the value of the member "enTuneCmd".
     *
     * tune command includes the tune direction (next/previous)
     *
     * @return The value of the field "enTuneCmd"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_TuneCmd getEnTuneCmd () const;

    /**
     * Sets the value of the member "enTuneCmd".
     *
     * tune command includes the tune direction (next/previous)
     *
     * @param enTuneCmd The value which will be set
     */
    inline void setEnTuneCmd (::dabtuner_main_fi_types::T_e8_DAB_TuneCmd enTuneCmd_);

    static const FID_DAB_S_SEEK_ENSEMBLEStart &getDefaultInstance();

private:

    inline void set_has_enTuneCmd ();

    inline void clear_has_enTuneCmd ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_TuneCmd _enTuneCmd;

};

/**
 * The result message of the method "FID_DAB_S_SEEK_ENSEMBLE"
 * Seek to next/prev ensemble (only in testmode)
 * .
 */
class FID_DAB_S_SEEK_ENSEMBLEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEResult (const FID_DAB_S_SEEK_ENSEMBLEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SEEK_ENSEMBLEResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SEEK_ENSEMBLEResult& operator = (const FID_DAB_S_SEEK_ENSEMBLEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_ENSEMBLEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_ENSEMBLEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_ENSEMBLEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_ENSEMBLEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     * If the meaning of "e8MethodResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     * If the meaning of "e8MethodResult" isn't clear, then there should be a description here.
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SEEK_ENSEMBLEResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SEEK_ENSEMBLE'
 */
class FID_DAB_S_SEEK_ENSEMBLEErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEErrorStructure (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SEEK_ENSEMBLEErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SEEK_ENSEMBLEErrorStructure& operator = (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SEEK_ENSEMBLEErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SEEK_ENSEMBLE'
 */
class FID_DAB_S_SEEK_ENSEMBLEError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SEEK_ENSEMBLEErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_ENSEMBLEError (const FID_DAB_S_SEEK_ENSEMBLEError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SEEK_ENSEMBLEError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SEEK_ENSEMBLEError& operator = (const FID_DAB_S_SEEK_ENSEMBLEError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_ENSEMBLEError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_ENSEMBLEError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_ENSEMBLEError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_ENSEMBLEError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SEEK_ENSEMBLEError::FID_DAB_S_SEEK_ENSEMBLEErrorField getField () const;

    inline void setField(FID_DAB_S_SEEK_ENSEMBLEError::FID_DAB_S_SEEK_ENSEMBLEErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SEEK_ENSEMBLEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SEEK_ENSEMBLEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SEEK_ENSEMBLEErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SEEK_ENSEMBLEErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SEEK_ENSEMBLEErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SEEK_ENSEMBLEErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SEEK_ENSEMBLEErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SEEK_ENSEMBLEError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SEEK_ENSEMBLEError& rhs);

    inline void deleteData ();

    FID_DAB_S_SEEK_ENSEMBLEErrorField __field;

    union {
        FID_DAB_S_SEEK_ENSEMBLEErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SEEK_SERVICE"
 * Seek to next/prev service (only in testmode)
 */
class FID_DAB_S_SEEK_SERVICEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEStart (const FID_DAB_S_SEEK_SERVICEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEStart (::dabtuner_main_fi_types::T_e8_DAB_TuneCmd enTuneCmd_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SEEK_SERVICEStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SEEK_SERVICEStart& operator = (const FID_DAB_S_SEEK_SERVICEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_SERVICEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_SERVICEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_SERVICEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_SERVICEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTuneCmd"

    static const int kEnTuneCmd = 0;

    /**
     * Clears the field "enTuneCmd".
     *
     * The field will be set to its default value. The hasEnTuneCmd()
     * method will return false.
     */
    inline void clearEnTuneCmd();

    /**
     * Checks whether the field "enTuneCmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTuneCmd()). Otherwise it will return false.
     */
    inline bool hasEnTuneCmd () const;

    /**
     * Returns the value of the member "enTuneCmd".
     *
     * tune command includes the tune direction (next/previous)
     *
     * @return The value of the field "enTuneCmd"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_TuneCmd getEnTuneCmd () const;

    /**
     * Sets the value of the member "enTuneCmd".
     *
     * tune command includes the tune direction (next/previous)
     *
     * @param enTuneCmd The value which will be set
     */
    inline void setEnTuneCmd (::dabtuner_main_fi_types::T_e8_DAB_TuneCmd enTuneCmd_);

    static const FID_DAB_S_SEEK_SERVICEStart &getDefaultInstance();

private:

    inline void set_has_enTuneCmd ();

    inline void clear_has_enTuneCmd ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_TuneCmd _enTuneCmd;

};

/**
 * The result message of the method "FID_DAB_S_SEEK_SERVICE"
 * Seek to next/prev service (only in testmode)
 * .
 */
class FID_DAB_S_SEEK_SERVICEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEResult (const FID_DAB_S_SEEK_SERVICEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SEEK_SERVICEResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SEEK_SERVICEResult& operator = (const FID_DAB_S_SEEK_SERVICEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_SERVICEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_SERVICEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_SERVICEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_SERVICEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     * If the meaning of "e8MethodResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     * If the meaning of "e8MethodResult" isn't clear, then there should be a description here.
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SEEK_SERVICEResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SEEK_SERVICE'
 */
class FID_DAB_S_SEEK_SERVICEErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEErrorStructure (const FID_DAB_S_SEEK_SERVICEErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SEEK_SERVICEErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SEEK_SERVICEErrorStructure& operator = (const FID_DAB_S_SEEK_SERVICEErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_SERVICEErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_SERVICEErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_SERVICEErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_SERVICEErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SEEK_SERVICEErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SEEK_SERVICE'
 */
class FID_DAB_S_SEEK_SERVICEError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SEEK_SERVICEErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SEEK_SERVICEError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SEEK_SERVICEError (const FID_DAB_S_SEEK_SERVICEError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SEEK_SERVICEError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SEEK_SERVICEError& operator = (const FID_DAB_S_SEEK_SERVICEError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SEEK_SERVICEError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SEEK_SERVICEError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SEEK_SERVICEError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SEEK_SERVICEError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SEEK_SERVICEError::FID_DAB_S_SEEK_SERVICEErrorField getField () const;

    inline void setField(FID_DAB_S_SEEK_SERVICEError::FID_DAB_S_SEEK_SERVICEErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SEEK_SERVICEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SEEK_SERVICEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SEEK_SERVICEErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SEEK_SERVICEErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SEEK_SERVICEErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SEEK_SERVICEErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SEEK_SERVICEErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SEEK_SERVICEErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SEEK_SERVICEError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SEEK_SERVICEError& rhs);

    inline void deleteData ();

    FID_DAB_S_SEEK_SERVICEErrorField __field;

    union {
        FID_DAB_S_SEEK_SERVICEErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_TARGET_SEEK"
 * Start target seek
 */
class FID_DAB_S_TARGET_SEEKStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TARGET_SEEKStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TARGET_SEEKStart (const FID_DAB_S_TARGET_SEEKStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TARGET_SEEKStart (::dabtuner_main_fi_types::T_e8_DAB_TuneCmd enTuneCmd_, uint32 u32Frequency_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TARGET_SEEKStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TARGET_SEEKStart& operator = (const FID_DAB_S_TARGET_SEEKStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TARGET_SEEKStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TARGET_SEEKStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TARGET_SEEKStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TARGET_SEEKStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "enTuneCmd"

    static const int kEnTuneCmd = 0;

    /**
     * Clears the field "enTuneCmd".
     *
     * The field will be set to its default value. The hasEnTuneCmd()
     * method will return false.
     */
    inline void clearEnTuneCmd();

    /**
     * Checks whether the field "enTuneCmd" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnTuneCmd()). Otherwise it will return false.
     */
    inline bool hasEnTuneCmd () const;

    /**
     * Returns the value of the member "enTuneCmd".
     *
     * tune command includes the tune direction (next/previous)
     *
     * @return The value of the field "enTuneCmd"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_TuneCmd getEnTuneCmd () const;

    /**
     * Sets the value of the member "enTuneCmd".
     *
     * tune command includes the tune direction (next/previous)
     *
     * @param enTuneCmd The value which will be set
     */
    inline void setEnTuneCmd (::dabtuner_main_fi_types::T_e8_DAB_TuneCmd enTuneCmd_);

    // API of field "u32Frequency"

    static const int kU32Frequency = 1;

    /**
     * Clears the field "u32Frequency".
     *
     * The field will be set to its default value. The hasU32Frequency()
     * method will return false.
     */
    inline void clearU32Frequency();

    /**
     * Checks whether the field "u32Frequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32Frequency()). Otherwise it will return false.
     */
    inline bool hasU32Frequency () const;

    /**
     * Returns the value of the member "u32Frequency".
     *
     * Start frequency in kHz
     *
     * @return The value of the field "u32Frequency"
     */
    inline uint32 getU32Frequency () const;

    /**
     * Sets the value of the member "u32Frequency".
     *
     * Start frequency in kHz
     *
     * @param u32Frequency The value which will be set
     */
    inline void setU32Frequency (uint32 u32Frequency_);

    static const FID_DAB_S_TARGET_SEEKStart &getDefaultInstance();

private:

    inline void set_has_enTuneCmd ();

    inline void clear_has_enTuneCmd ();

    inline void set_has_u32Frequency ();

    inline void clear_has_u32Frequency ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_TuneCmd _enTuneCmd;

    uint32 _u32Frequency;

};

/**
 * The result message of the method "FID_DAB_S_TARGET_SEEK"
 * Start target seek
 * .
 */
class FID_DAB_S_TARGET_SEEKResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TARGET_SEEKResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TARGET_SEEKResult (const FID_DAB_S_TARGET_SEEKResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TARGET_SEEKResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TARGET_SEEKResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TARGET_SEEKResult& operator = (const FID_DAB_S_TARGET_SEEKResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TARGET_SEEKResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TARGET_SEEKResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TARGET_SEEKResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TARGET_SEEKResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     * If the meaning of "e8MethodResult" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     * If the meaning of "e8MethodResult" isn't clear, then there should be a description here.
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_TARGET_SEEKResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_TARGET_SEEK'
 */
class FID_DAB_S_TARGET_SEEKErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TARGET_SEEKErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TARGET_SEEKErrorStructure (const FID_DAB_S_TARGET_SEEKErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TARGET_SEEKErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_TARGET_SEEKErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TARGET_SEEKErrorStructure& operator = (const FID_DAB_S_TARGET_SEEKErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TARGET_SEEKErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TARGET_SEEKErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TARGET_SEEKErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TARGET_SEEKErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_TARGET_SEEKErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_TARGET_SEEK'
 */
class FID_DAB_S_TARGET_SEEKError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_TARGET_SEEKErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_TARGET_SEEKError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_TARGET_SEEKError (const FID_DAB_S_TARGET_SEEKError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TARGET_SEEKError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_TARGET_SEEKError& operator = (const FID_DAB_S_TARGET_SEEKError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TARGET_SEEKError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TARGET_SEEKError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TARGET_SEEKError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TARGET_SEEKError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_TARGET_SEEKError::FID_DAB_S_TARGET_SEEKErrorField getField () const;

    inline void setField(FID_DAB_S_TARGET_SEEKError::FID_DAB_S_TARGET_SEEKErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_TARGET_SEEKErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_TARGET_SEEKErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_TARGET_SEEKErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_TARGET_SEEKErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_TARGET_SEEKErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_TARGET_SEEKErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_TARGET_SEEKErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_TARGET_SEEKErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_TARGET_SEEKError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_TARGET_SEEKError& rhs);

    inline void deleteData ();

    FID_DAB_S_TARGET_SEEKErrorField __field;

    union {
        FID_DAB_S_TARGET_SEEKErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_SET_MUTE_STATUS"
 * Informs fc_dabtuner that Mute status is activ/inactiv.
 */
class FID_DAB_S_SET_MUTE_STATUSStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSStart (const FID_DAB_S_SET_MUTE_STATUSStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSStart (::dabtuner_main_fi_types::T_e8_DAB_Source e8DabSource_, ::dabtuner_main_fi_types::T_e8_DAB_MuteStatus e8MuteStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_MUTE_STATUSStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_MUTE_STATUSStart& operator = (const FID_DAB_S_SET_MUTE_STATUSStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_MUTE_STATUSStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_MUTE_STATUSStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_MUTE_STATUSStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_MUTE_STATUSStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8DabSource"

    static const int kE8DabSource = 0;

    /**
     * Clears the field "e8DabSource".
     *
     * The field will be set to its default value. The hasE8DabSource()
     * method will return false.
     */
    inline void clearE8DabSource();

    /**
     * Checks whether the field "e8DabSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8DabSource()). Otherwise it will return false.
     */
    inline bool hasE8DabSource () const;

    /**
     * Returns the value of the member "e8DabSource".
     *
     * DAB or DAB_TA
     *
     * @return The value of the field "e8DabSource"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Source getE8DabSource () const;

    /**
     * Sets the value of the member "e8DabSource".
     *
     * DAB or DAB_TA
     *
     * @param e8DabSource The value which will be set
     */
    inline void setE8DabSource (::dabtuner_main_fi_types::T_e8_DAB_Source e8DabSource_);

    // API of field "e8MuteStatus"

    static const int kE8MuteStatus = 1;

    /**
     * Clears the field "e8MuteStatus".
     *
     * The field will be set to its default value. The hasE8MuteStatus()
     * method will return false.
     */
    inline void clearE8MuteStatus();

    /**
     * Checks whether the field "e8MuteStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MuteStatus()). Otherwise it will return false.
     */
    inline bool hasE8MuteStatus () const;

    /**
     * Returns the value of the member "e8MuteStatus".
     *
     * status of DAB-source mute/demute/demute running
     *
     * @return The value of the field "e8MuteStatus"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_MuteStatus getE8MuteStatus () const;

    /**
     * Sets the value of the member "e8MuteStatus".
     *
     * status of DAB-source mute/demute/demute running
     *
     * @param e8MuteStatus The value which will be set
     */
    inline void setE8MuteStatus (::dabtuner_main_fi_types::T_e8_DAB_MuteStatus e8MuteStatus_);

    static const FID_DAB_S_SET_MUTE_STATUSStart &getDefaultInstance();

private:

    inline void set_has_e8DabSource ();

    inline void clear_has_e8DabSource ();

    inline void set_has_e8MuteStatus ();

    inline void clear_has_e8MuteStatus ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Source _e8DabSource;

    ::dabtuner_main_fi_types::T_e8_DAB_MuteStatus _e8MuteStatus;

};

/**
 * The result message of the method "FID_DAB_S_SET_MUTE_STATUS"
 * Informs fc_dabtuner that Mute status is activ/inactiv.
 */
class FID_DAB_S_SET_MUTE_STATUSResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSResult (const FID_DAB_S_SET_MUTE_STATUSResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_MUTE_STATUSResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_MUTE_STATUSResult& operator = (const FID_DAB_S_SET_MUTE_STATUSResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_MUTE_STATUSResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_MUTE_STATUSResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_MUTE_STATUSResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_MUTE_STATUSResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_SET_MUTE_STATUSResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_SET_MUTE_STATUS'
 */
class FID_DAB_S_SET_MUTE_STATUSErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSErrorStructure (const FID_DAB_S_SET_MUTE_STATUSErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_SET_MUTE_STATUSErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_SET_MUTE_STATUSErrorStructure& operator = (const FID_DAB_S_SET_MUTE_STATUSErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_MUTE_STATUSErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_MUTE_STATUSErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_MUTE_STATUSErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_MUTE_STATUSErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_SET_MUTE_STATUSErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_SET_MUTE_STATUS'
 */
class FID_DAB_S_SET_MUTE_STATUSError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_SET_MUTE_STATUSErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_SET_MUTE_STATUSError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_SET_MUTE_STATUSError (const FID_DAB_S_SET_MUTE_STATUSError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_SET_MUTE_STATUSError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_SET_MUTE_STATUSError& operator = (const FID_DAB_S_SET_MUTE_STATUSError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_SET_MUTE_STATUSError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_SET_MUTE_STATUSError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_SET_MUTE_STATUSError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_SET_MUTE_STATUSError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_SET_MUTE_STATUSError::FID_DAB_S_SET_MUTE_STATUSErrorField getField () const;

    inline void setField(FID_DAB_S_SET_MUTE_STATUSError::FID_DAB_S_SET_MUTE_STATUSErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_SET_MUTE_STATUSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_SET_MUTE_STATUSErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_SET_MUTE_STATUSErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_SET_MUTE_STATUSErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_SET_MUTE_STATUSErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_SET_MUTE_STATUSErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_SET_MUTE_STATUSErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_SET_MUTE_STATUSErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_SET_MUTE_STATUSError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_SET_MUTE_STATUSError& rhs);

    inline void deleteData ();

    FID_DAB_S_SET_MUTE_STATUSErrorField __field;

    union {
        FID_DAB_S_SET_MUTE_STATUSErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_DATASERVICES_DATA"
 * Informs FC DAB logo list, content id list
 */
class FID_DAB_S_DATASERVICES_DATAStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAStart (const FID_DAB_S_DATASERVICES_DATAStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAStart (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_LogoElement >& LogoList_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ContentID >& ContentIDList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DATASERVICES_DATAStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DATASERVICES_DATAStart& operator = (const FID_DAB_S_DATASERVICES_DATAStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DATASERVICES_DATAStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DATASERVICES_DATAStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DATASERVICES_DATAStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DATASERVICES_DATAStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LogoList"

    static const int kLogoList = 0;

    /**
     * Clears the field "LogoList".
     *
     * The field will be set to its default value. The hasLogoList()
     * method will return false.
     */
    inline void clearLogoList();

    /**
     * Checks whether the field "LogoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLogoList()). Otherwise it will return false.
     */
    inline bool hasLogoList () const;

    /**
     * Returns the value of the member "LogoList".
     *
     * List of available station logos
     *
     * @return The value of the field "LogoList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_LogoElement >& getLogoList () const;

    /**
     * Retrieves the value of the field "LogoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "LogoList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_LogoElement >& getLogoListMutable ();

    /**
     * Sets the value of the member "LogoList".
     *
     * List of available station logos
     *
     * @param LogoList The value which will be set
     */
    inline void setLogoList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_LogoElement >& LogoList_);

    // API of field "ContentIDList"

    static const int kContentIDList = 1;

    /**
     * Clears the field "ContentIDList".
     *
     * The field will be set to its default value. The hasContentIDList()
     * method will return false.
     */
    inline void clearContentIDList();

    /**
     * Checks whether the field "ContentIDList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setContentIDList()). Otherwise it will return false.
     */
    inline bool hasContentIDList () const;

    /**
     * Returns the value of the member "ContentIDList".
     *
     * List of contentids supporting Dataservices
     *
     * @return The value of the field "ContentIDList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ContentID >& getContentIDList () const;

    /**
     * Retrieves the value of the field "ContentIDList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ContentIDList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_ContentID >& getContentIDListMutable ();

    /**
     * Sets the value of the member "ContentIDList".
     *
     * List of contentids supporting Dataservices
     *
     * @param ContentIDList The value which will be set
     */
    inline void setContentIDList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ContentID >& ContentIDList_);

    static const FID_DAB_S_DATASERVICES_DATAStart &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_LogoElement >& getT_DAB_LogoElementList_DefaultInstance ();

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ContentID >& getT_DAB_ContentIDList_DefaultInstance ();

    inline void set_has_LogoList ();

    inline void clear_has_LogoList ();

    inline void set_has_ContentIDList ();

    inline void clear_has_ContentIDList ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_LogoElement > _LogoList;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_ContentID > _ContentIDList;

};

/**
 * The result message of the method "FID_DAB_S_DATASERVICES_DATA"
 * Informs FC DAB logo list, content id list
 */
class FID_DAB_S_DATASERVICES_DATAResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAResult (const FID_DAB_S_DATASERVICES_DATAResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DATASERVICES_DATAResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DATASERVICES_DATAResult& operator = (const FID_DAB_S_DATASERVICES_DATAResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DATASERVICES_DATAResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DATASERVICES_DATAResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DATASERVICES_DATAResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DATASERVICES_DATAResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_DATASERVICES_DATAResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_DATASERVICES_DATA'
 */
class FID_DAB_S_DATASERVICES_DATAErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAErrorStructure (const FID_DAB_S_DATASERVICES_DATAErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_DATASERVICES_DATAErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DATASERVICES_DATAErrorStructure& operator = (const FID_DAB_S_DATASERVICES_DATAErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DATASERVICES_DATAErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DATASERVICES_DATAErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DATASERVICES_DATAErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DATASERVICES_DATAErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_DATASERVICES_DATAErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_DATASERVICES_DATA'
 */
class FID_DAB_S_DATASERVICES_DATAError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_DATASERVICES_DATAErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_DATASERVICES_DATAError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_DATASERVICES_DATAError (const FID_DAB_S_DATASERVICES_DATAError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DATASERVICES_DATAError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_DATASERVICES_DATAError& operator = (const FID_DAB_S_DATASERVICES_DATAError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DATASERVICES_DATAError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DATASERVICES_DATAError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DATASERVICES_DATAError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DATASERVICES_DATAError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_DATASERVICES_DATAError::FID_DAB_S_DATASERVICES_DATAErrorField getField () const;

    inline void setField(FID_DAB_S_DATASERVICES_DATAError::FID_DAB_S_DATASERVICES_DATAErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_DATASERVICES_DATAErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_DATASERVICES_DATAErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_DATASERVICES_DATAErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_DATASERVICES_DATAErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_DATASERVICES_DATAErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_DATASERVICES_DATAErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_DATASERVICES_DATAErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_DATASERVICES_DATAErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_DATASERVICES_DATAError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_DATASERVICES_DATAError& rhs);

    inline void deleteData ();

    FID_DAB_S_DATASERVICES_DATAErrorField __field;

    union {
        FID_DAB_S_DATASERVICES_DATAErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_DSM_MSG"
 * Informs fc_dabtuner that there is a message from DSM.
 */
class FID_DAB_S_DSM_MSGStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DSM_MSGStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DSM_MSGStart (const FID_DAB_S_DSM_MSGStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DSM_MSGStart (const ::dabtuner_main_fi_types::T_DAB_ADRMsg& DSMMsg_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DSM_MSGStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DSM_MSGStart& operator = (const FID_DAB_S_DSM_MSGStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DSM_MSGStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DSM_MSGStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DSM_MSGStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DSM_MSGStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DSMMsg"

    static const int kDSMMsg = 0;

    /**
     * Clears the field "DSMMsg".
     *
     * The field will be set to its default value. The hasDSMMsg()
     * method will return false.
     */
    inline void clearDSMMsg();

    /**
     * Checks whether the field "DSMMsg" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDSMMsg()). Otherwise it will return false.
     */
    inline bool hasDSMMsg () const;

    /**
     * Returns the value of the member "DSMMsg".
     *
     * DSMMsg
     *
     * @return The value of the field "DSMMsg"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_ADRMsg& getDSMMsg () const;

    /**
     * Retrieves the value of the field "DSMMsg" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DSMMsg".
     */
    inline ::dabtuner_main_fi_types::T_DAB_ADRMsg& getDSMMsgMutable ();

    /**
     * Sets the value of the member "DSMMsg".
     *
     * DSMMsg
     *
     * @param DSMMsg The value which will be set
     */
    inline void setDSMMsg (const ::dabtuner_main_fi_types::T_DAB_ADRMsg& DSMMsg_);

    static const FID_DAB_S_DSM_MSGStart &getDefaultInstance();

private:

    inline void set_has_DSMMsg ();

    inline void clear_has_DSMMsg ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_ADRMsg _DSMMsg;

};

/**
 * The result message of the method "FID_DAB_S_DSM_MSG"
 * Informs fc_dabtuner that there is a message from DSM.
 */
class FID_DAB_S_DSM_MSGResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DSM_MSGResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DSM_MSGResult (const FID_DAB_S_DSM_MSGResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DSM_MSGResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DSM_MSGResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DSM_MSGResult& operator = (const FID_DAB_S_DSM_MSGResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DSM_MSGResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DSM_MSGResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DSM_MSGResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DSM_MSGResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_DSM_MSGResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_DSM_MSG'
 */
class FID_DAB_S_DSM_MSGErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_DSM_MSGErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_DSM_MSGErrorStructure (const FID_DAB_S_DSM_MSGErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_DSM_MSGErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_DSM_MSGErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_DSM_MSGErrorStructure& operator = (const FID_DAB_S_DSM_MSGErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DSM_MSGErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DSM_MSGErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DSM_MSGErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DSM_MSGErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_DSM_MSGErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_DSM_MSG'
 */
class FID_DAB_S_DSM_MSGError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_DSM_MSGErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_DSM_MSGError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_DSM_MSGError (const FID_DAB_S_DSM_MSGError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_DSM_MSGError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_DSM_MSGError& operator = (const FID_DAB_S_DSM_MSGError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_DSM_MSGError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_DSM_MSGError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_DSM_MSGError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_DSM_MSGError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_DSM_MSGError::FID_DAB_S_DSM_MSGErrorField getField () const;

    inline void setField(FID_DAB_S_DSM_MSGError::FID_DAB_S_DSM_MSGErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_DSM_MSGErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_DSM_MSGErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_DSM_MSGErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_DSM_MSGErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_DSM_MSGErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_DSM_MSGErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_DSM_MSGErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_DSM_MSGErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_DSM_MSGError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_DSM_MSGError& rhs);

    inline void deleteData ();

    FID_DAB_S_DSM_MSGErrorField __field;

    union {
        FID_DAB_S_DSM_MSGErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_MTC_SETMODE"
 * Sets the mode for the service switch request.
 * It can be OFF, DAB to FM switching or FM to DAB switching.
 */
class FID_DAB_S_MTC_SETMODEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_MTC_SETMODEStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_MTC_SETMODEStart (const FID_DAB_S_MTC_SETMODEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_MTC_SETMODEStart (const ::dabtuner_main_fi_types::T_b8_DAB_MTC_SetMode& b8Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_MTC_SETMODEStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_MTC_SETMODEStart& operator = (const FID_DAB_S_MTC_SETMODEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_MTC_SETMODEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_MTC_SETMODEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_MTC_SETMODEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_MTC_SETMODEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b8Mode"

    static const int kB8Mode = 0;

    /**
     * Clears the field "b8Mode".
     *
     * The field will be set to its default value. The hasB8Mode()
     * method will return false.
     */
    inline void clearB8Mode();

    /**
     * Checks whether the field "b8Mode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB8Mode()). Otherwise it will return false.
     */
    inline bool hasB8Mode () const;

    /**
     * Returns the value of the member "b8Mode".
     *
     * Tells which service linking mode is requested to be set by the HMI.
     *
     * @return The value of the field "b8Mode"
     */
    inline const ::dabtuner_main_fi_types::T_b8_DAB_MTC_SetMode& getB8Mode () const;

    /**
     * Retrieves the value of the field "b8Mode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b8Mode".
     */
    inline ::dabtuner_main_fi_types::T_b8_DAB_MTC_SetMode& getB8ModeMutable ();

    /**
     * Sets the value of the member "b8Mode".
     *
     * Tells which service linking mode is requested to be set by the HMI.
     *
     * @param b8Mode The value which will be set
     */
    inline void setB8Mode (const ::dabtuner_main_fi_types::T_b8_DAB_MTC_SetMode& b8Mode_);

    static const FID_DAB_S_MTC_SETMODEStart &getDefaultInstance();

private:

    inline void set_has_b8Mode ();

    inline void clear_has_b8Mode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_b8_DAB_MTC_SetMode _b8Mode;

};

/**
 * The result message of the method "FID_DAB_S_MTC_SETMODE"
 * Sets the mode for the service switch request.
 * It can be OFF, DAB to FM switching or FM to DAB switching.
 */
class FID_DAB_S_MTC_SETMODEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_MTC_SETMODEResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_MTC_SETMODEResult (const FID_DAB_S_MTC_SETMODEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_MTC_SETMODEResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_MTC_SETMODEResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_MTC_SETMODEResult& operator = (const FID_DAB_S_MTC_SETMODEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_MTC_SETMODEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_MTC_SETMODEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_MTC_SETMODEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_MTC_SETMODEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     * Sends the response to Tuner Master whether the Service Linking Mode is set or not.
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     * Sends the response to Tuner Master whether the Service Linking Mode is set or not.
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_MTC_SETMODEResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_MTC_SETMODE'
 */
class FID_DAB_S_MTC_SETMODEErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_MTC_SETMODEErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_MTC_SETMODEErrorStructure (const FID_DAB_S_MTC_SETMODEErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_MTC_SETMODEErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_MTC_SETMODEErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_MTC_SETMODEErrorStructure& operator = (const FID_DAB_S_MTC_SETMODEErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_MTC_SETMODEErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_MTC_SETMODEErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_MTC_SETMODEErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_MTC_SETMODEErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_MTC_SETMODEErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_MTC_SETMODE'
 */
class FID_DAB_S_MTC_SETMODEError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_MTC_SETMODEErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_MTC_SETMODEError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_MTC_SETMODEError (const FID_DAB_S_MTC_SETMODEError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_MTC_SETMODEError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_MTC_SETMODEError& operator = (const FID_DAB_S_MTC_SETMODEError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_MTC_SETMODEError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_MTC_SETMODEError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_MTC_SETMODEError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_MTC_SETMODEError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_MTC_SETMODEError::FID_DAB_S_MTC_SETMODEErrorField getField () const;

    inline void setField(FID_DAB_S_MTC_SETMODEError::FID_DAB_S_MTC_SETMODEErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_MTC_SETMODEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_MTC_SETMODEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_MTC_SETMODEErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_MTC_SETMODEErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_MTC_SETMODEErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_MTC_SETMODEErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_MTC_SETMODEErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_MTC_SETMODEErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_MTC_SETMODEError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_MTC_SETMODEError& rhs);

    inline void deleteData ();

    FID_DAB_S_MTC_SETMODEErrorField __field;

    union {
        FID_DAB_S_MTC_SETMODEErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The start message of the method "FID_DAB_S_TUNE_FREQUENCY_LABEL"
 * Client requests the Direct Tune the DAB Frequency.
 */
class FID_DAB_S_TUNE_FREQUENCY_LABELStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELStart (const FID_DAB_S_TUNE_FREQUENCY_LABELStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELStart (const ::std::string& FrequencyLabel_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TUNE_FREQUENCY_LABELStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELStart& operator = (const FID_DAB_S_TUNE_FREQUENCY_LABELStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TUNE_FREQUENCY_LABELStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TUNE_FREQUENCY_LABELStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TUNE_FREQUENCY_LABELStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TUNE_FREQUENCY_LABELStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "FrequencyLabel"

    static const int kFrequencyLabel = 0;

    /**
     * Clears the field "FrequencyLabel".
     *
     * The field will be set to its default value. The hasFrequencyLabel()
     * method will return false.
     */
    inline void clearFrequencyLabel();

    /**
     * Checks whether the field "FrequencyLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFrequencyLabel()). Otherwise it will return false.
     */
    inline bool hasFrequencyLabel () const;

    /**
     * Returns the value of the member "FrequencyLabel".
     *
     * Frequency Label to be Tuned.
     *
     * @return The value of the field "FrequencyLabel"
     */
    inline const ::std::string& getFrequencyLabel () const;

    /**
     * Retrieves the value of the field "FrequencyLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "FrequencyLabel".
     */
    inline ::std::string& getFrequencyLabelMutable ();

    /**
     * Sets the value of the member "FrequencyLabel".
     *
     * Frequency Label to be Tuned.
     *
     * @param FrequencyLabel The value which will be set
     */
    inline void setFrequencyLabel (const ::std::string& FrequencyLabel_);

    /**
     * Sets the value of the member "FrequencyLabel".
     *
     * Frequency Label to be Tuned.
     *
     * @param FrequencyLabel The value which will be set
     */
    inline void setFrequencyLabel (const char* FrequencyLabel_);

    /**
     * Sets the value of the member "FrequencyLabel".
     *
     * Frequency Label to be Tuned.
     *
     * @param FrequencyLabel The value which will be set
     */
    inline void setFrequencyLabel (const char* value, size_t size);

    static const FID_DAB_S_TUNE_FREQUENCY_LABELStart &getDefaultInstance();

private:

    inline void set_has_FrequencyLabel ();

    inline void clear_has_FrequencyLabel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _FrequencyLabel;

};

/**
 * The result message of the method "FID_DAB_S_TUNE_FREQUENCY_LABEL"
 * Client requests the Direct Tune the DAB Frequency.
 */
class FID_DAB_S_TUNE_FREQUENCY_LABELResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELResult (const FID_DAB_S_TUNE_FREQUENCY_LABELResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TUNE_FREQUENCY_LABELResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELResult& operator = (const FID_DAB_S_TUNE_FREQUENCY_LABELResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TUNE_FREQUENCY_LABELResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TUNE_FREQUENCY_LABELResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TUNE_FREQUENCY_LABELResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TUNE_FREQUENCY_LABELResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 0;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     * State of announcement.
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     * State of announcement.
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_TUNE_FREQUENCY_LABELResult &getDefaultInstance();

private:

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_TUNE_FREQUENCY_LABEL'
 */
class FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& operator = (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_TUNE_FREQUENCY_LABEL'
 */
class FID_DAB_S_TUNE_FREQUENCY_LABELError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_TUNE_FREQUENCY_LABELErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_TUNE_FREQUENCY_LABELError (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_TUNE_FREQUENCY_LABELError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELError& operator = (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELError::FID_DAB_S_TUNE_FREQUENCY_LABELErrorField getField () const;

    inline void setField(FID_DAB_S_TUNE_FREQUENCY_LABELError::FID_DAB_S_TUNE_FREQUENCY_LABELErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_TUNE_FREQUENCY_LABELError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_TUNE_FREQUENCY_LABELError& rhs);

    inline void deleteData ();

    FID_DAB_S_TUNE_FREQUENCY_LABELErrorField __field;

    union {
        FID_DAB_S_TUNE_FREQUENCY_LABELErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FID_DAB_G_TUNER_STATUS"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_TUNER_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TUNER_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TUNER_STATUSStatus (const FID_DAB_G_TUNER_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TUNER_STATUSStatus (const ::dabtuner_main_fi_types::T_DAB_TunerStatus& TunerStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TUNER_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TUNER_STATUSStatus& operator = (const FID_DAB_G_TUNER_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TUNER_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TUNER_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TUNER_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TUNER_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerStatus"

    static const int kTunerStatus = 0;

    /**
     * Clears the field "TunerStatus".
     *
     * The field will be set to its default value. The hasTunerStatus()
     * method will return false.
     */
    inline void clearTunerStatus();

    /**
     * Checks whether the field "TunerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerStatus()). Otherwise it will return false.
     */
    inline bool hasTunerStatus () const;

    /**
     * Returns the value of the member "TunerStatus".
     *
     * .
     *
     * @return The value of the field "TunerStatus"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_TunerStatus& getTunerStatus () const;

    /**
     * Retrieves the value of the field "TunerStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerStatus".
     */
    inline ::dabtuner_main_fi_types::T_DAB_TunerStatus& getTunerStatusMutable ();

    /**
     * Sets the value of the member "TunerStatus".
     *
     * .
     *
     * @param TunerStatus The value which will be set
     */
    inline void setTunerStatus (const ::dabtuner_main_fi_types::T_DAB_TunerStatus& TunerStatus_);

    static const FID_DAB_G_TUNER_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_TunerStatus ();

    inline void clear_has_TunerStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_TunerStatus _TunerStatus;

};

/**
 * The status message of the property "FID_DAB_G_AVAILABILITY"
 * DAB Availability status.
 * LCN2: Property for HMI, TunerMaster ...
 */
class FID_DAB_G_AVAILABILITYStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_AVAILABILITYStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_AVAILABILITYStatus (const FID_DAB_G_AVAILABILITYStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_AVAILABILITYStatus (bool bIsDABAvailable_, ::dabtuner_main_fi_types::T_e8_DAB_SourceState e8SourceState_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_AVAILABILITYStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_AVAILABILITYStatus& operator = (const FID_DAB_G_AVAILABILITYStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_AVAILABILITYStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_AVAILABILITYStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_AVAILABILITYStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_AVAILABILITYStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bIsDABAvailable"

    static const int kBIsDABAvailable = 0;

    /**
     * Clears the field "bIsDABAvailable".
     *
     * The field will be set to its default value. The hasBIsDABAvailable()
     * method will return false.
     */
    inline void clearBIsDABAvailable();

    /**
     * Checks whether the field "bIsDABAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBIsDABAvailable()). Otherwise it will return false.
     */
    inline bool hasBIsDABAvailable () const;

    /**
     * Returns the value of the member "bIsDABAvailable".
     *
     * TRUE means that the DAB module is available. It indicates that communication to
     * DAB-Module has been established.
     *
     * @return The value of the field "bIsDABAvailable"
     */
    inline bool getBIsDABAvailable () const;

    /**
     * Sets the value of the member "bIsDABAvailable".
     *
     * TRUE means that the DAB module is available. It indicates that communication to
     * DAB-Module has been established.
     *
     * @param bIsDABAvailable The value which will be set
     */
    inline void setBIsDABAvailable (bool bIsDABAvailable_);

    // API of field "e8SourceState"

    static const int kE8SourceState = 1;

    /**
     * Clears the field "e8SourceState".
     *
     * The field will be set to its default value. The hasE8SourceState()
     * method will return false.
     */
    inline void clearE8SourceState();

    /**
     * Checks whether the field "e8SourceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8SourceState()). Otherwise it will return false.
     */
    inline bool hasE8SourceState () const;

    /**
     * Returns the value of the member "e8SourceState".
     *
     * SourceState according to T_e8_DAB_SourceState.
     * Its value is only valid if bIsDABAvailable is TRUE.
     *
     * @return The value of the field "e8SourceState"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_SourceState getE8SourceState () const;

    /**
     * Sets the value of the member "e8SourceState".
     *
     * SourceState according to T_e8_DAB_SourceState.
     * Its value is only valid if bIsDABAvailable is TRUE.
     *
     * @param e8SourceState The value which will be set
     */
    inline void setE8SourceState (::dabtuner_main_fi_types::T_e8_DAB_SourceState e8SourceState_);

    static const FID_DAB_G_AVAILABILITYStatus &getDefaultInstance();

private:

    inline void set_has_bIsDABAvailable ();

    inline void clear_has_bIsDABAvailable ();

    inline void set_has_e8SourceState ();

    inline void clear_has_e8SourceState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    bool _bIsDABAvailable;

    ::dabtuner_main_fi_types::T_e8_DAB_SourceState _e8SourceState;

};

/**
 * The status message of the property "FID_DAB_G_ADR_MSG"
 * Response regarding Tuner status.
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_ADR_MSGStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_ADR_MSGStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_ADR_MSGStatus (const FID_DAB_G_ADR_MSGStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_ADR_MSGStatus (const ::dabtuner_main_fi_types::T_DAB_ADRMsg& TunerStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_ADR_MSGStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_ADR_MSGStatus& operator = (const FID_DAB_G_ADR_MSGStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_ADR_MSGStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_ADR_MSGStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_ADR_MSGStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_ADR_MSGStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TunerStatus"

    static const int kTunerStatus = 0;

    /**
     * Clears the field "TunerStatus".
     *
     * The field will be set to its default value. The hasTunerStatus()
     * method will return false.
     */
    inline void clearTunerStatus();

    /**
     * Checks whether the field "TunerStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTunerStatus()). Otherwise it will return false.
     */
    inline bool hasTunerStatus () const;

    /**
     * Returns the value of the member "TunerStatus".
     *
     * .
     *
     * @return The value of the field "TunerStatus"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_ADRMsg& getTunerStatus () const;

    /**
     * Retrieves the value of the field "TunerStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TunerStatus".
     */
    inline ::dabtuner_main_fi_types::T_DAB_ADRMsg& getTunerStatusMutable ();

    /**
     * Sets the value of the member "TunerStatus".
     *
     * .
     *
     * @param TunerStatus The value which will be set
     */
    inline void setTunerStatus (const ::dabtuner_main_fi_types::T_DAB_ADRMsg& TunerStatus_);

    static const FID_DAB_G_ADR_MSGStatus &getDefaultInstance();

private:

    inline void set_has_TunerStatus ();

    inline void clear_has_TunerStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_ADRMsg _TunerStatus;

};

/**
 * The status message of the property "FID_DAB_G_LOCAL_OFFSET"
 * Gives local offset with respect to UTC
 */
class FID_DAB_G_LOCAL_OFFSETStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_LOCAL_OFFSETStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_LOCAL_OFFSETStatus (const FID_DAB_G_LOCAL_OFFSETStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_LOCAL_OFFSETStatus (int64 LocalOffset_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_LOCAL_OFFSETStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_LOCAL_OFFSETStatus& operator = (const FID_DAB_G_LOCAL_OFFSETStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_LOCAL_OFFSETStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_LOCAL_OFFSETStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_LOCAL_OFFSETStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_LOCAL_OFFSETStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "LocalOffset"

    static const int kLocalOffset = 0;

    /**
     * Clears the field "LocalOffset".
     *
     * The field will be set to its default value. The hasLocalOffset()
     * method will return false.
     */
    inline void clearLocalOffset();

    /**
     * Checks whether the field "LocalOffset" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLocalOffset()). Otherwise it will return false.
     */
    inline bool hasLocalOffset () const;

    /**
     * Returns the value of the member "LocalOffset".
     *
     * .
     *
     * @return The value of the field "LocalOffset"
     */
    inline int64 getLocalOffset () const;

    /**
     * Sets the value of the member "LocalOffset".
     *
     * .
     *
     * @param LocalOffset The value which will be set
     */
    inline void setLocalOffset (int64 LocalOffset_);

    static const FID_DAB_G_LOCAL_OFFSETStatus &getDefaultInstance();

private:

    inline void set_has_LocalOffset ();

    inline void clear_has_LocalOffset ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int64 _LocalOffset;

};

/**
 * The start message of the method "FID_DAB_S_USER_PROFILE_UPDATE"
 * Method for Tunermaster. This method is used to copy, delete or activate a user profile
 */
class FID_DAB_S_USER_PROFILE_UPDATEStart  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEStart ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEStart (const FID_DAB_S_USER_PROFILE_UPDATEStart &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEStart (::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction Action_, uint8 UserID_, uint8 DestinationUserID_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_USER_PROFILE_UPDATEStart();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEStart& operator = (const FID_DAB_S_USER_PROFILE_UPDATEStart& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_USER_PROFILE_UPDATEStart& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Action"

    static const int kAction = 0;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * Change: Changes the current user profile.
     * Copy: Copies a user profile to another user profile.
     * Delete: Deletes a user profile.
     *
     * @return The value of the field "Action"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * Change: Changes the current user profile.
     * Copy: Copies a user profile to another user profile.
     * Delete: Deletes a user profile.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction Action_);

    // API of field "UserID"

    static const int kUserID = 1;

    /**
     * Clears the field "UserID".
     *
     * The field will be set to its default value. The hasUserID()
     * method will return false.
     */
    inline void clearUserID();

    /**
     * Checks whether the field "UserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUserID()). Otherwise it will return false.
     */
    inline bool hasUserID () const;

    /**
     * Returns the value of the member "UserID".
     *
     * The user id to be changed, copied or deleted. Should contain the source user ID in case of copy profile. Supports 0 - 6.
     *
     * @return The value of the field "UserID"
     */
    inline uint8 getUserID () const;

    /**
     * Sets the value of the member "UserID".
     *
     * The user id to be changed, copied or deleted. Should contain the source user ID in case of copy profile. Supports 0 - 6.
     *
     * @param UserID The value which will be set
     */
    inline void setUserID (uint8 UserID_);

    // API of field "DestinationUserID"

    static const int kDestinationUserID = 2;

    /**
     * Clears the field "DestinationUserID".
     *
     * The field will be set to its default value. The hasDestinationUserID()
     * method will return false.
     */
    inline void clearDestinationUserID();

    /**
     * Checks whether the field "DestinationUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestinationUserID()). Otherwise it will return false.
     */
    inline bool hasDestinationUserID () const;

    /**
     * Returns the value of the member "DestinationUserID".
     *
     * Used only for copy profile. Should contain the destination user profile. Supports 0 - 6.
     *
     * @return The value of the field "DestinationUserID"
     */
    inline uint8 getDestinationUserID () const;

    /**
     * Sets the value of the member "DestinationUserID".
     *
     * Used only for copy profile. Should contain the destination user profile. Supports 0 - 6.
     *
     * @param DestinationUserID The value which will be set
     */
    inline void setDestinationUserID (uint8 DestinationUserID_);

    static const FID_DAB_S_USER_PROFILE_UPDATEStart &getDefaultInstance();

private:

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_UserID ();

    inline void clear_has_UserID ();

    inline void set_has_DestinationUserID ();

    inline void clear_has_DestinationUserID ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction _Action;

    uint8 _UserID;

    uint8 _DestinationUserID;

};

/**
 * The result message of the method "FID_DAB_S_USER_PROFILE_UPDATE"
 * Method for Tunermaster. This method is used to copy, delete or activate a user profile
 * .
 */
class FID_DAB_S_USER_PROFILE_UPDATEResult  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEResult ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEResult (const FID_DAB_S_USER_PROFILE_UPDATEResult &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEResult (::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction Action_, uint8 ActiveUserID_, ::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_USER_PROFILE_UPDATEResult();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEResult& operator = (const FID_DAB_S_USER_PROFILE_UPDATEResult& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_USER_PROFILE_UPDATEResult& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Action"

    static const int kAction = 0;

    /**
     * Clears the field "Action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "Action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "Action".
     *
     * If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Action"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction getAction () const;

    /**
     * Sets the value of the member "Action".
     *
     * If the meaning of "Action" isn't clear, then there should be a description here.
     *
     * @param Action The value which will be set
     */
    inline void setAction (::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction Action_);

    // API of field "ActiveUserID"

    static const int kActiveUserID = 1;

    /**
     * Clears the field "ActiveUserID".
     *
     * The field will be set to its default value. The hasActiveUserID()
     * method will return false.
     */
    inline void clearActiveUserID();

    /**
     * Checks whether the field "ActiveUserID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setActiveUserID()). Otherwise it will return false.
     */
    inline bool hasActiveUserID () const;

    /**
     * Returns the value of the member "ActiveUserID".
     *
     * If the meaning of "ActiveUserID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "ActiveUserID"
     */
    inline uint8 getActiveUserID () const;

    /**
     * Sets the value of the member "ActiveUserID".
     *
     * If the meaning of "ActiveUserID" isn't clear, then there should be a description here.
     *
     * @param ActiveUserID The value which will be set
     */
    inline void setActiveUserID (uint8 ActiveUserID_);

    // API of field "e8MethodResult"

    static const int kE8MethodResult = 2;

    /**
     * Clears the field "e8MethodResult".
     *
     * The field will be set to its default value. The hasE8MethodResult()
     * method will return false.
     */
    inline void clearE8MethodResult();

    /**
     * Checks whether the field "e8MethodResult" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MethodResult()). Otherwise it will return false.
     */
    inline bool hasE8MethodResult () const;

    /**
     * Returns the value of the member "e8MethodResult".
     *
     *
     *
     * @return The value of the field "e8MethodResult"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_Response getE8MethodResult () const;

    /**
     * Sets the value of the member "e8MethodResult".
     *
     *
     *
     * @param e8MethodResult The value which will be set
     */
    inline void setE8MethodResult (::dabtuner_main_fi_types::T_e8_DAB_Response e8MethodResult_);

    static const FID_DAB_S_USER_PROFILE_UPDATEResult &getDefaultInstance();

private:

    inline void set_has_Action ();

    inline void clear_has_Action ();

    inline void set_has_ActiveUserID ();

    inline void clear_has_ActiveUserID ();

    inline void set_has_e8MethodResult ();

    inline void clear_has_e8MethodResult ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_UserProfileAction _Action;

    uint8 _ActiveUserID;

    ::dabtuner_main_fi_types::T_e8_DAB_Response _e8MethodResult;

};

/**
 * The error message of 'FID_DAB_S_USER_PROFILE_UPDATE'
 */
class FID_DAB_S_USER_PROFILE_UPDATEErrorStructure {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEErrorStructure ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEErrorStructure (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEErrorStructure (uint16 u16ErrorCode_);

    /**
     * Destructor
     */
    inline  ~FID_DAB_S_USER_PROFILE_UPDATEErrorStructure();

    /**
     * Assignment operator
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& operator = (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u16ErrorCode"

    static const int kU16ErrorCode = 0;

    /**
     * Clears the field "u16ErrorCode".
     *
     * The field will be set to its default value. The hasU16ErrorCode()
     * method will return false.
     */
    inline void clearU16ErrorCode();

    /**
     * Checks whether the field "u16ErrorCode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ErrorCode()). Otherwise it will return false.
     */
    inline bool hasU16ErrorCode () const;

    /**
     * Returns the value of the member "u16ErrorCode".
     *
     *
     *
     * @return The value of the field "u16ErrorCode"
     */
    inline uint16 getU16ErrorCode () const;

    /**
     * Sets the value of the member "u16ErrorCode".
     *
     *
     *
     * @param u16ErrorCode The value which will be set
     */
    inline void setU16ErrorCode (uint16 u16ErrorCode_);

    static const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure &getDefaultInstance();

private:

    inline void set_has_u16ErrorCode ();

    inline void clear_has_u16ErrorCode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _u16ErrorCode;

};

/**
 * The error message of 'FID_DAB_S_USER_PROFILE_UPDATE'
 */
class FID_DAB_S_USER_PROFILE_UPDATEError  : public ::asf::core::Payload {
public:

    enum FID_DAB_S_USER_PROFILE_UPDATEErrorField {
        E_CCA_ERROR_CODE = 0,
        E_SYSTEM_ERROR_CODE = 1
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "ccaErrorCode".
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEError ();

   /**
     * Copy constructor
     */
    inline  FID_DAB_S_USER_PROFILE_UPDATEError (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_S_USER_PROFILE_UPDATEError();

    /**
     * Assigns a new value to this object.
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEError& operator = (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEError::FID_DAB_S_USER_PROFILE_UPDATEErrorField getField () const;

    inline void setField(FID_DAB_S_USER_PROFILE_UPDATEError::FID_DAB_S_USER_PROFILE_UPDATEErrorField field);

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline virtual ::asf::core::Payload* clone();

    // ---- Field accessors -------------------------------------------

    // API of field "ccaErrorCode"

    static const int kCcaErrorCode = 0;

    /**
     * Returns true if the field "ccaErrorCode" has a value.
     *
     * If the meaning of "FID_DAB_S_USER_PROFILE_UPDATEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "ccaErrorCode", otherwise false
     */
    inline bool hasCcaErrorCode () const;

    /**
     * Returns the value of field "ccaErrorCode".It is only valid to call this
     * method if hasCcaErrorCode() returns true. Otherwise the behavior is not
     * specified.
     *
     * If the meaning of "FID_DAB_S_USER_PROFILE_UPDATEErrorStructure" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& getCcaErrorCode() const ;

    /**
     * Retrieves the value of the field "ccaErrorCode" as a mutable object.
     * Any modifications on the returned object will affect the containing
     * object.
     *
     * It is only valid to call this method if isCcaErrorCode() returns true.
     * Otherwise the behavior is not specified.
     *
     * @return The value of the union
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& getCcaErrorCodeMutable();

    /**
     * Release the object stored in the field "ccaErrorCode".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "ccaErrorCode" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "ccaErrorCode"
     */
    inline FID_DAB_S_USER_PROFILE_UPDATEErrorStructure* releaseCcaErrorCode();

    /**
     * Replace the field "ccaErrorCode".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceCcaErrorCode (FID_DAB_S_USER_PROFILE_UPDATEErrorStructure* ccaErrorCode);

    /**
     * Sets the value of the field "ccaErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "FID_DAB_S_USER_PROFILE_UPDATEErrorStructure" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setCcaErrorCode (const FID_DAB_S_USER_PROFILE_UPDATEErrorStructure& value);

    // API of field "systemErrorCode"

    static const int kSystemErrorCode = 1;

    /**
     * Returns true if the field "systemErrorCode" has a value.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "systemErrorCode", otherwise false
     */
    inline bool hasSystemErrorCode () const;

    /**
     * Returns the value of field "systemErrorCode".It is only valid to call
     * this method if hasSystemErrorCode() returns true. Otherwise the
     * behavior is not specified.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline ::asf::cca::CcaTypes::SystemErrorCode getSystemErrorCode() const ;

    /**
     * Sets the value of the field "systemErrorCode". A field which was
     * previously set will be cleared.
     *
     * If the meaning of "asf.cca.CcaTypes.SystemErrorCode" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setSystemErrorCode (::asf::cca::CcaTypes::SystemErrorCode value);

    static const FID_DAB_S_USER_PROFILE_UPDATEError &getDefaultInstance();

private:

    inline void cloneData (const FID_DAB_S_USER_PROFILE_UPDATEError& rhs);

    inline void deleteData ();

    FID_DAB_S_USER_PROFILE_UPDATEErrorField __field;

    union {
        FID_DAB_S_USER_PROFILE_UPDATEErrorStructure* ccaErrorCode_;
        int32 systemErrorCode_;
    } _data;

};

/**
 * The status message of the property "FID_DAB_G_ANNO_STATUS"
 * Current announcement status
 * LCN2: Property for TunerMaster
 */
class FID_DAB_G_ANNO_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_ANNO_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_ANNO_STATUSStatus (const FID_DAB_G_ANNO_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_ANNO_STATUSStatus (const ::dabtuner_main_fi_types::T_DAB_AnnoStatus& AnnoStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_ANNO_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_ANNO_STATUSStatus& operator = (const FID_DAB_G_ANNO_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_ANNO_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_ANNO_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_ANNO_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_ANNO_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "AnnoStatus"

    static const int kAnnoStatus = 0;

    /**
     * Clears the field "AnnoStatus".
     *
     * The field will be set to its default value. The hasAnnoStatus()
     * method will return false.
     */
    inline void clearAnnoStatus();

    /**
     * Checks whether the field "AnnoStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAnnoStatus()). Otherwise it will return false.
     */
    inline bool hasAnnoStatus () const;

    /**
     * Returns the value of the member "AnnoStatus".
     *
     * .
     *
     * @return The value of the field "AnnoStatus"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_AnnoStatus& getAnnoStatus () const;

    /**
     * Retrieves the value of the field "AnnoStatus" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AnnoStatus".
     */
    inline ::dabtuner_main_fi_types::T_DAB_AnnoStatus& getAnnoStatusMutable ();

    /**
     * Sets the value of the member "AnnoStatus".
     *
     * .
     *
     * @param AnnoStatus The value which will be set
     */
    inline void setAnnoStatus (const ::dabtuner_main_fi_types::T_DAB_AnnoStatus& AnnoStatus_);

    static const FID_DAB_G_ANNO_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_AnnoStatus ();

    inline void clear_has_AnnoStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_AnnoStatus _AnnoStatus;

};

/**
 * The status message of the property "FID_DAB_G_CHANNEL_INFO"
 * Service Info to be displayed in Main-Sreen
 * LCN2: Property for HMI
 */
class FID_DAB_G_CHANNEL_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_CHANNEL_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_CHANNEL_INFOStatus (const FID_DAB_G_CHANNEL_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_CHANNEL_INFOStatus (const ::dabtuner_main_fi_types::T_DAB_ChannelInfo& ChannelInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_CHANNEL_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_CHANNEL_INFOStatus& operator = (const FID_DAB_G_CHANNEL_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_CHANNEL_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_CHANNEL_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_CHANNEL_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_CHANNEL_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ChannelInfo"

    static const int kChannelInfo = 0;

    /**
     * Clears the field "ChannelInfo".
     *
     * The field will be set to its default value. The hasChannelInfo()
     * method will return false.
     */
    inline void clearChannelInfo();

    /**
     * Checks whether the field "ChannelInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannelInfo()). Otherwise it will return false.
     */
    inline bool hasChannelInfo () const;

    /**
     * Returns the value of the member "ChannelInfo".
     *
     * .
     *
     * @return The value of the field "ChannelInfo"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_ChannelInfo& getChannelInfo () const;

    /**
     * Retrieves the value of the field "ChannelInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChannelInfo".
     */
    inline ::dabtuner_main_fi_types::T_DAB_ChannelInfo& getChannelInfoMutable ();

    /**
     * Sets the value of the member "ChannelInfo".
     *
     * .
     *
     * @param ChannelInfo The value which will be set
     */
    inline void setChannelInfo (const ::dabtuner_main_fi_types::T_DAB_ChannelInfo& ChannelInfo_);

    static const FID_DAB_G_CHANNEL_INFOStatus &getDefaultInstance();

private:

    inline void set_has_ChannelInfo ();

    inline void clear_has_ChannelInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_ChannelInfo _ChannelInfo;

};

/**
 * The status message of the property "FID_DAB_G_COMP_LIST"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_COMP_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_COMP_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_COMP_LISTStatus (const FID_DAB_G_COMP_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_COMP_LISTStatus (bool bOpen_, uint16 u16NumberOfComponents_, uint16 u16ActivatedElementId_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& ComponentList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_COMP_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_COMP_LISTStatus& operator = (const FID_DAB_G_COMP_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_COMP_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_COMP_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_COMP_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_COMP_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bOpen"

    static const int kBOpen = 0;

    /**
     * Clears the field "bOpen".
     *
     * The field will be set to its default value. The hasBOpen()
     * method will return false.
     */
    inline void clearBOpen();

    /**
     * Checks whether the field "bOpen" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBOpen()). Otherwise it will return false.
     */
    inline bool hasBOpen () const;

    /**
     * Returns the value of the member "bOpen".
     *
     * TRUE==opened, FALSE=Closed.
     *
     * @return The value of the field "bOpen"
     */
    inline bool getBOpen () const;

    /**
     * Sets the value of the member "bOpen".
     *
     * TRUE==opened, FALSE=Closed.
     *
     * @param bOpen The value which will be set
     */
    inline void setBOpen (bool bOpen_);

    // API of field "u16NumberOfComponents"

    static const int kU16NumberOfComponents = 1;

    /**
     * Clears the field "u16NumberOfComponents".
     *
     * The field will be set to its default value. The hasU16NumberOfComponents()
     * method will return false.
     */
    inline void clearU16NumberOfComponents();

    /**
     * Checks whether the field "u16NumberOfComponents" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16NumberOfComponents()). Otherwise it will return false.
     */
    inline bool hasU16NumberOfComponents () const;

    /**
     * Returns the value of the member "u16NumberOfComponents".
     *
     * Total Number of elements in the active list.
     *
     * @return The value of the field "u16NumberOfComponents"
     */
    inline uint16 getU16NumberOfComponents () const;

    /**
     * Sets the value of the member "u16NumberOfComponents".
     *
     * Total Number of elements in the active list.
     *
     * @param u16NumberOfComponents The value which will be set
     */
    inline void setU16NumberOfComponents (uint16 u16NumberOfComponents_);

    // API of field "u16ActivatedElementId"

    static const int kU16ActivatedElementId = 2;

    /**
     * Clears the field "u16ActivatedElementId".
     *
     * The field will be set to its default value. The hasU16ActivatedElementId()
     * method will return false.
     */
    inline void clearU16ActivatedElementId();

    /**
     * Checks whether the field "u16ActivatedElementId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ActivatedElementId()). Otherwise it will return false.
     */
    inline bool hasU16ActivatedElementId () const;

    /**
     * Returns the value of the member "u16ActivatedElementId".
     *
     * Activated Element in list when it is opened that matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @return The value of the field "u16ActivatedElementId"
     */
    inline uint16 getU16ActivatedElementId () const;

    /**
     * Sets the value of the member "u16ActivatedElementId".
     *
     * Activated Element in list when it is opened that matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @param u16ActivatedElementId The value which will be set
     */
    inline void setU16ActivatedElementId (uint16 u16ActivatedElementId_);

    // API of field "ComponentList"

    static const int kComponentList = 3;

    /**
     * Clears the field "ComponentList".
     *
     * The field will be set to its default value. The hasComponentList()
     * method will return false.
     */
    inline void clearComponentList();

    /**
     * Checks whether the field "ComponentList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentList()). Otherwise it will return false.
     */
    inline bool hasComponentList () const;

    /**
     * Returns the value of the member "ComponentList".
     *
     * ElementId 1 will be first element of the list
     *
     * @return The value of the field "ComponentList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& getComponentList () const;

    /**
     * Retrieves the value of the field "ComponentList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ComponentList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& getComponentListMutable ();

    /**
     * Sets the value of the member "ComponentList".
     *
     * ElementId 1 will be first element of the list
     *
     * @param ComponentList The value which will be set
     */
    inline void setComponentList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& ComponentList_);

    static const FID_DAB_G_COMP_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement >& getT_DAB_ChnListElementList_DefaultInstance ();

    inline void set_has_bOpen ();

    inline void clear_has_bOpen ();

    inline void set_has_u16NumberOfComponents ();

    inline void clear_has_u16NumberOfComponents ();

    inline void set_has_u16ActivatedElementId ();

    inline void clear_has_u16ActivatedElementId ();

    inline void set_has_ComponentList ();

    inline void clear_has_ComponentList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bOpen;

    uint16 _u16NumberOfComponents;

    uint16 _u16ActivatedElementId;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_ChnListElement > _ComponentList;

};

/**
 * The status message of the property "FID_DAB_G_PRESET_LIST"
 * Response regarding preset list.
 */
class FID_DAB_G_PRESET_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_PRESET_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_PRESET_LISTStatus (const FID_DAB_G_PRESET_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_PRESET_LISTStatus (uint8 u8FirstElementID_, uint8 u8NumberOfElements_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& PresetList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_PRESET_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_PRESET_LISTStatus& operator = (const FID_DAB_G_PRESET_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_PRESET_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_PRESET_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_PRESET_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_PRESET_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8FirstElementID"

    static const int kU8FirstElementID = 0;

    /**
     * Clears the field "u8FirstElementID".
     *
     * The field will be set to its default value. The hasU8FirstElementID()
     * method will return false.
     */
    inline void clearU8FirstElementID();

    /**
     * Checks whether the field "u8FirstElementID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8FirstElementID()). Otherwise it will return false.
     */
    inline bool hasU8FirstElementID () const;

    /**
     * Returns the value of the member "u8FirstElementID".
     *
     * First element ID in the list.
     *
     * @return The value of the field "u8FirstElementID"
     */
    inline uint8 getU8FirstElementID () const;

    /**
     * Sets the value of the member "u8FirstElementID".
     *
     * First element ID in the list.
     *
     * @param u8FirstElementID The value which will be set
     */
    inline void setU8FirstElementID (uint8 u8FirstElementID_);

    // API of field "u8NumberOfElements"

    static const int kU8NumberOfElements = 1;

    /**
     * Clears the field "u8NumberOfElements".
     *
     * The field will be set to its default value. The hasU8NumberOfElements()
     * method will return false.
     */
    inline void clearU8NumberOfElements();

    /**
     * Checks whether the field "u8NumberOfElements" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8NumberOfElements()). Otherwise it will return false.
     */
    inline bool hasU8NumberOfElements () const;

    /**
     * Returns the value of the member "u8NumberOfElements".
     *
     * The number of elements in the this msg.
     *
     * @return The value of the field "u8NumberOfElements"
     */
    inline uint8 getU8NumberOfElements () const;

    /**
     * Sets the value of the member "u8NumberOfElements".
     *
     * The number of elements in the this msg.
     *
     * @param u8NumberOfElements The value which will be set
     */
    inline void setU8NumberOfElements (uint8 u8NumberOfElements_);

    // API of field "PresetList"

    static const int kPresetList = 2;

    /**
     * Clears the field "PresetList".
     *
     * The field will be set to its default value. The hasPresetList()
     * method will return false.
     */
    inline void clearPresetList();

    /**
     * Checks whether the field "PresetList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPresetList()). Otherwise it will return false.
     */
    inline bool hasPresetList () const;

    /**
     * Returns the value of the member "PresetList".
     *
     * Data of preset elements
     *
     * @return The value of the field "PresetList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getPresetList () const;

    /**
     * Retrieves the value of the field "PresetList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "PresetList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getPresetListMutable ();

    /**
     * Sets the value of the member "PresetList".
     *
     * Data of preset elements
     *
     * @param PresetList The value which will be set
     */
    inline void setPresetList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& PresetList_);

    static const FID_DAB_G_PRESET_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement >& getT_DAB_PresetListElementList_DefaultInstance ();

    inline void set_has_u8FirstElementID ();

    inline void clear_has_u8FirstElementID ();

    inline void set_has_u8NumberOfElements ();

    inline void clear_has_u8NumberOfElements ();

    inline void set_has_PresetList ();

    inline void clear_has_PresetList ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8FirstElementID;

    uint8 _u8NumberOfElements;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_PresetListElement > _PresetList;

};

/**
 * The status message of the property "FID_DAB_G_SETUP_STATUS"
 * The current operation set up can be requested by the client with
 * this property.
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_SETUP_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_SETUP_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_SETUP_STATUSStatus (const FID_DAB_G_SETUP_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_SETUP_STATUSStatus (const ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& b32SetupFlags_, ::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_, uint8 u8ConcealmentLevel_, uint8 u8DABFMLinkingThreshold_, uint8 u8DABFMLinkBackDelay_, uint8 u8DABFMLinkingBackThreshold_, uint8 u8DABFMLinkingBackValidationTime_, uint8 u8EnsInsertThreshold_, uint8 u8EnsDeleteThreshold_, uint8 u8BgLearnUpdateTime_, uint8 u8DABScanThreshold_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_SETUP_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_SETUP_STATUSStatus& operator = (const FID_DAB_G_SETUP_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_SETUP_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_SETUP_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_SETUP_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_SETUP_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "b32SetupFlags"

    static const int kB32SetupFlags = 0;

    /**
     * Clears the field "b32SetupFlags".
     *
     * The field will be set to its default value. The hasB32SetupFlags()
     * method will return false.
     */
    inline void clearB32SetupFlags();

    /**
     * Checks whether the field "b32SetupFlags" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setB32SetupFlags()). Otherwise it will return false.
     */
    inline bool hasB32SetupFlags () const;

    /**
     * Returns the value of the member "b32SetupFlags".
     *
     * Bitfield. Current Operation set up. A value of 1 indicates that the corresponding feature is
     * activated, a value of 0 indicates that it is deactivated.
     *
     * @return The value of the field "b32SetupFlags"
     */
    inline const ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& getB32SetupFlags () const;

    /**
     * Retrieves the value of the field "b32SetupFlags" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "b32SetupFlags".
     */
    inline ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& getB32SetupFlagsMutable ();

    /**
     * Sets the value of the member "b32SetupFlags".
     *
     * Bitfield. Current Operation set up. A value of 1 indicates that the corresponding feature is
     * activated, a value of 0 indicates that it is deactivated.
     *
     * @param b32SetupFlags The value which will be set
     */
    inline void setB32SetupFlags (const ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags& b32SetupFlags_);

    // API of field "e8ServiceLinkingMode"

    static const int kE8ServiceLinkingMode = 1;

    /**
     * Clears the field "e8ServiceLinkingMode".
     *
     * The field will be set to its default value. The hasE8ServiceLinkingMode()
     * method will return false.
     */
    inline void clearE8ServiceLinkingMode();

    /**
     * Checks whether the field "e8ServiceLinkingMode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceLinkingMode()). Otherwise it will return false.
     */
    inline bool hasE8ServiceLinkingMode () const;

    /**
     * Returns the value of the member "e8ServiceLinkingMode".
     *
     * The currently enabled Service Linking Mode.
     *
     * @return The value of the field "e8ServiceLinkingMode"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode getE8ServiceLinkingMode () const;

    /**
     * Sets the value of the member "e8ServiceLinkingMode".
     *
     * The currently enabled Service Linking Mode.
     *
     * @param e8ServiceLinkingMode The value which will be set
     */
    inline void setE8ServiceLinkingMode (::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode e8ServiceLinkingMode_);

    // API of field "u8ConcealmentLevel"

    static const int kU8ConcealmentLevel = 2;

    /**
     * Clears the field "u8ConcealmentLevel".
     *
     * The field will be set to its default value. The hasU8ConcealmentLevel()
     * method will return false.
     */
    inline void clearU8ConcealmentLevel();

    /**
     * Checks whether the field "u8ConcealmentLevel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8ConcealmentLevel()). Otherwise it will return false.
     */
    inline bool hasU8ConcealmentLevel () const;

    /**
     * Returns the value of the member "u8ConcealmentLevel".
     *
     * The concealmentLevel according to Meca (range=0...7)
     *
     * @return The value of the field "u8ConcealmentLevel"
     */
    inline uint8 getU8ConcealmentLevel () const;

    /**
     * Sets the value of the member "u8ConcealmentLevel".
     *
     * The concealmentLevel according to Meca (range=0...7)
     *
     * @param u8ConcealmentLevel The value which will be set
     */
    inline void setU8ConcealmentLevel (uint8 u8ConcealmentLevel_);

    // API of field "u8DABFMLinkingThreshold"

    static const int kU8DABFMLinkingThreshold = 3;

    /**
     * Clears the field "u8DABFMLinkingThreshold".
     *
     * The field will be set to its default value. The hasU8DABFMLinkingThreshold()
     * method will return false.
     */
    inline void clearU8DABFMLinkingThreshold();

    /**
     * Checks whether the field "u8DABFMLinkingThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkingThreshold()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkingThreshold () const;

    /**
     * Returns the value of the member "u8DABFMLinkingThreshold".
     *
     * The DAB-FM Linking Threshold according to Meca (0 to 31)
     *
     * @return The value of the field "u8DABFMLinkingThreshold"
     */
    inline uint8 getU8DABFMLinkingThreshold () const;

    /**
     * Sets the value of the member "u8DABFMLinkingThreshold".
     *
     * The DAB-FM Linking Threshold according to Meca (0 to 31)
     *
     * @param u8DABFMLinkingThreshold The value which will be set
     */
    inline void setU8DABFMLinkingThreshold (uint8 u8DABFMLinkingThreshold_);

    // API of field "u8DABFMLinkBackDelay"

    static const int kU8DABFMLinkBackDelay = 4;

    /**
     * Clears the field "u8DABFMLinkBackDelay".
     *
     * The field will be set to its default value. The hasU8DABFMLinkBackDelay()
     * method will return false.
     */
    inline void clearU8DABFMLinkBackDelay();

    /**
     * Checks whether the field "u8DABFMLinkBackDelay" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkBackDelay()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkBackDelay () const;

    /**
     * Returns the value of the member "u8DABFMLinkBackDelay".
     *
     * The DAB-FM LinkBack Delay according to Meca (in seconds)
     *
     * @return The value of the field "u8DABFMLinkBackDelay"
     */
    inline uint8 getU8DABFMLinkBackDelay () const;

    /**
     * Sets the value of the member "u8DABFMLinkBackDelay".
     *
     * The DAB-FM LinkBack Delay according to Meca (in seconds)
     *
     * @param u8DABFMLinkBackDelay The value which will be set
     */
    inline void setU8DABFMLinkBackDelay (uint8 u8DABFMLinkBackDelay_);

    // API of field "u8DABFMLinkingBackThreshold"

    static const int kU8DABFMLinkingBackThreshold = 5;

    /**
     * Clears the field "u8DABFMLinkingBackThreshold".
     *
     * The field will be set to its default value. The hasU8DABFMLinkingBackThreshold()
     * method will return false.
     */
    inline void clearU8DABFMLinkingBackThreshold();

    /**
     * Checks whether the field "u8DABFMLinkingBackThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkingBackThreshold()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkingBackThreshold () const;

    /**
     * Returns the value of the member "u8DABFMLinkingBackThreshold".
     *
     * The DAB-FM Linking Back Threshold according to Meca (0 to 31)
     *
     * @return The value of the field "u8DABFMLinkingBackThreshold"
     */
    inline uint8 getU8DABFMLinkingBackThreshold () const;

    /**
     * Sets the value of the member "u8DABFMLinkingBackThreshold".
     *
     * The DAB-FM Linking Back Threshold according to Meca (0 to 31)
     *
     * @param u8DABFMLinkingBackThreshold The value which will be set
     */
    inline void setU8DABFMLinkingBackThreshold (uint8 u8DABFMLinkingBackThreshold_);

    // API of field "u8DABFMLinkingBackValidationTime"

    static const int kU8DABFMLinkingBackValidationTime = 6;

    /**
     * Clears the field "u8DABFMLinkingBackValidationTime".
     *
     * The field will be set to its default value. The hasU8DABFMLinkingBackValidationTime()
     * method will return false.
     */
    inline void clearU8DABFMLinkingBackValidationTime();

    /**
     * Checks whether the field "u8DABFMLinkingBackValidationTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABFMLinkingBackValidationTime()). Otherwise it will return false.
     */
    inline bool hasU8DABFMLinkingBackValidationTime () const;

    /**
     * Returns the value of the member "u8DABFMLinkingBackValidationTime".
     *
     * The DAB-FM Linking Back Validation Time according to Meca (with 100 ms step)
     *
     * @return The value of the field "u8DABFMLinkingBackValidationTime"
     */
    inline uint8 getU8DABFMLinkingBackValidationTime () const;

    /**
     * Sets the value of the member "u8DABFMLinkingBackValidationTime".
     *
     * The DAB-FM Linking Back Validation Time according to Meca (with 100 ms step)
     *
     * @param u8DABFMLinkingBackValidationTime The value which will be set
     */
    inline void setU8DABFMLinkingBackValidationTime (uint8 u8DABFMLinkingBackValidationTime_);

    // API of field "u8EnsInsertThreshold"

    static const int kU8EnsInsertThreshold = 7;

    /**
     * Clears the field "u8EnsInsertThreshold".
     *
     * The field will be set to its default value. The hasU8EnsInsertThreshold()
     * method will return false.
     */
    inline void clearU8EnsInsertThreshold();

    /**
     * Checks whether the field "u8EnsInsertThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EnsInsertThreshold()). Otherwise it will return false.
     */
    inline bool hasU8EnsInsertThreshold () const;

    /**
     * Returns the value of the member "u8EnsInsertThreshold".
     *
     * The threshold for inserting an ensemble into the HMI ensemble-list (0-99).
     *
     * @return The value of the field "u8EnsInsertThreshold"
     */
    inline uint8 getU8EnsInsertThreshold () const;

    /**
     * Sets the value of the member "u8EnsInsertThreshold".
     *
     * The threshold for inserting an ensemble into the HMI ensemble-list (0-99).
     *
     * @param u8EnsInsertThreshold The value which will be set
     */
    inline void setU8EnsInsertThreshold (uint8 u8EnsInsertThreshold_);

    // API of field "u8EnsDeleteThreshold"

    static const int kU8EnsDeleteThreshold = 8;

    /**
     * Clears the field "u8EnsDeleteThreshold".
     *
     * The field will be set to its default value. The hasU8EnsDeleteThreshold()
     * method will return false.
     */
    inline void clearU8EnsDeleteThreshold();

    /**
     * Checks whether the field "u8EnsDeleteThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8EnsDeleteThreshold()). Otherwise it will return false.
     */
    inline bool hasU8EnsDeleteThreshold () const;

    /**
     * Returns the value of the member "u8EnsDeleteThreshold".
     *
     * The threshold for removing of an ensemble from the HMI ensemble-list (0-99).
     *
     * @return The value of the field "u8EnsDeleteThreshold"
     */
    inline uint8 getU8EnsDeleteThreshold () const;

    /**
     * Sets the value of the member "u8EnsDeleteThreshold".
     *
     * The threshold for removing of an ensemble from the HMI ensemble-list (0-99).
     *
     * @param u8EnsDeleteThreshold The value which will be set
     */
    inline void setU8EnsDeleteThreshold (uint8 u8EnsDeleteThreshold_);

    // API of field "u8BgLearnUpdateTime"

    static const int kU8BgLearnUpdateTime = 9;

    /**
     * Clears the field "u8BgLearnUpdateTime".
     *
     * The field will be set to its default value. The hasU8BgLearnUpdateTime()
     * method will return false.
     */
    inline void clearU8BgLearnUpdateTime();

    /**
     * Checks whether the field "u8BgLearnUpdateTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8BgLearnUpdateTime()). Otherwise it will return false.
     */
    inline bool hasU8BgLearnUpdateTime () const;

    /**
     * Returns the value of the member "u8BgLearnUpdateTime".
     *
     * The Background learn update time (0..100 sec)
     *
     * @return The value of the field "u8BgLearnUpdateTime"
     */
    inline uint8 getU8BgLearnUpdateTime () const;

    /**
     * Sets the value of the member "u8BgLearnUpdateTime".
     *
     * The Background learn update time (0..100 sec)
     *
     * @param u8BgLearnUpdateTime The value which will be set
     */
    inline void setU8BgLearnUpdateTime (uint8 u8BgLearnUpdateTime_);

    // API of field "u8DABScanThreshold"

    static const int kU8DABScanThreshold = 10;

    /**
     * Clears the field "u8DABScanThreshold".
     *
     * The field will be set to its default value. The hasU8DABScanThreshold()
     * method will return false.
     */
    inline void clearU8DABScanThreshold();

    /**
     * Checks whether the field "u8DABScanThreshold" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8DABScanThreshold()). Otherwise it will return false.
     */
    inline bool hasU8DABScanThreshold () const;

    /**
     * Returns the value of the member "u8DABScanThreshold".
     *
     * The DAB Scan Threshold
     *
     * @return The value of the field "u8DABScanThreshold"
     */
    inline uint8 getU8DABScanThreshold () const;

    /**
     * Sets the value of the member "u8DABScanThreshold".
     *
     * The DAB Scan Threshold
     *
     * @param u8DABScanThreshold The value which will be set
     */
    inline void setU8DABScanThreshold (uint8 u8DABScanThreshold_);

    static const FID_DAB_G_SETUP_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_b32SetupFlags ();

    inline void clear_has_b32SetupFlags ();

    inline void set_has_e8ServiceLinkingMode ();

    inline void clear_has_e8ServiceLinkingMode ();

    inline void set_has_u8ConcealmentLevel ();

    inline void clear_has_u8ConcealmentLevel ();

    inline void set_has_u8DABFMLinkingThreshold ();

    inline void clear_has_u8DABFMLinkingThreshold ();

    inline void set_has_u8DABFMLinkBackDelay ();

    inline void clear_has_u8DABFMLinkBackDelay ();

    inline void set_has_u8DABFMLinkingBackThreshold ();

    inline void clear_has_u8DABFMLinkingBackThreshold ();

    inline void set_has_u8DABFMLinkingBackValidationTime ();

    inline void clear_has_u8DABFMLinkingBackValidationTime ();

    inline void set_has_u8EnsInsertThreshold ();

    inline void clear_has_u8EnsInsertThreshold ();

    inline void set_has_u8EnsDeleteThreshold ();

    inline void clear_has_u8EnsDeleteThreshold ();

    inline void set_has_u8BgLearnUpdateTime ();

    inline void clear_has_u8BgLearnUpdateTime ();

    inline void set_has_u8DABScanThreshold ();

    inline void clear_has_u8DABScanThreshold ();

    uint32 _has_bits_[ (11 + 31) / 32];

    ::dabtuner_main_fi_types::T_b32_DAB_SetupFlags _b32SetupFlags;

    ::dabtuner_main_fi_types::T_e8_DAB_ServiceLinkingMode _e8ServiceLinkingMode;

    uint8 _u8ConcealmentLevel;

    uint8 _u8DABFMLinkingThreshold;

    uint8 _u8DABFMLinkBackDelay;

    uint8 _u8DABFMLinkingBackThreshold;

    uint8 _u8DABFMLinkingBackValidationTime;

    uint8 _u8EnsInsertThreshold;

    uint8 _u8EnsDeleteThreshold;

    uint8 _u8BgLearnUpdateTime;

    uint8 _u8DABScanThreshold;

};

/**
 * The status message of the property "FID_DAB_G_SERVICE_FOLLOWING_STATUS"
 * Property indicating the tuner status of adr3 if dab or fm is active.
 * This is only for HMI to signal for example in dab-screnn that FM is playing.
 */
class FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus (const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus (::dabtuner_main_fi_types::T_e8_DAB_ServiceFollowingTuner e8ServiceFollowingTuner_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& operator = (const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8ServiceFollowingTuner"

    static const int kE8ServiceFollowingTuner = 0;

    /**
     * Clears the field "e8ServiceFollowingTuner".
     *
     * The field will be set to its default value. The hasE8ServiceFollowingTuner()
     * method will return false.
     */
    inline void clearE8ServiceFollowingTuner();

    /**
     * Checks whether the field "e8ServiceFollowingTuner" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ServiceFollowingTuner()). Otherwise it will return false.
     */
    inline bool hasE8ServiceFollowingTuner () const;

    /**
     * Returns the value of the member "e8ServiceFollowingTuner".
     *
     * MAIN_DAB_TUNER: automatic tuner change to dab
     * MAIN_FM_TUNER:  automatic tuner change to fm
     *
     * @return The value of the field "e8ServiceFollowingTuner"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_ServiceFollowingTuner getE8ServiceFollowingTuner () const;

    /**
     * Sets the value of the member "e8ServiceFollowingTuner".
     *
     * MAIN_DAB_TUNER: automatic tuner change to dab
     * MAIN_FM_TUNER:  automatic tuner change to fm
     *
     * @param e8ServiceFollowingTuner The value which will be set
     */
    inline void setE8ServiceFollowingTuner (::dabtuner_main_fi_types::T_e8_DAB_ServiceFollowingTuner e8ServiceFollowingTuner_);

    static const FID_DAB_G_SERVICE_FOLLOWING_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_e8ServiceFollowingTuner ();

    inline void clear_has_e8ServiceFollowingTuner ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_ServiceFollowingTuner _e8ServiceFollowingTuner;

};

/**
 * The status message of the property "FID_DAB_G_MUTE_STATUS"
 * Property indicating the mute-status that fc_dabtuner wants to have.
 * LCN2: Property for FC_Audio
 */
class FID_DAB_G_MUTE_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_MUTE_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_MUTE_STATUSStatus (const FID_DAB_G_MUTE_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_MUTE_STATUSStatus (::dabtuner_main_fi_types::T_e8_DAB_MuteStatus e8MuteStatus_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_MUTE_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_MUTE_STATUSStatus& operator = (const FID_DAB_G_MUTE_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_MUTE_STATUSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_MUTE_STATUSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_MUTE_STATUSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_MUTE_STATUSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MuteStatus"

    static const int kE8MuteStatus = 0;

    /**
     * Clears the field "e8MuteStatus".
     *
     * The field will be set to its default value. The hasE8MuteStatus()
     * method will return false.
     */
    inline void clearE8MuteStatus();

    /**
     * Checks whether the field "e8MuteStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MuteStatus()). Otherwise it will return false.
     */
    inline bool hasE8MuteStatus () const;

    /**
     * Returns the value of the member "e8MuteStatus".
     *
     * DAB_MUTE: fc_dabtuner wants to be muted
     * DAB_DEMUTE: fc_dabtuner wants to be demuted
     *
     * @return The value of the field "e8MuteStatus"
     */
    inline ::dabtuner_main_fi_types::T_e8_DAB_MuteStatus getE8MuteStatus () const;

    /**
     * Sets the value of the member "e8MuteStatus".
     *
     * DAB_MUTE: fc_dabtuner wants to be muted
     * DAB_DEMUTE: fc_dabtuner wants to be demuted
     *
     * @param e8MuteStatus The value which will be set
     */
    inline void setE8MuteStatus (::dabtuner_main_fi_types::T_e8_DAB_MuteStatus e8MuteStatus_);

    static const FID_DAB_G_MUTE_STATUSStatus &getDefaultInstance();

private:

    inline void set_has_e8MuteStatus ();

    inline void clear_has_e8MuteStatus ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_e8_DAB_MuteStatus _e8MuteStatus;

};

/**
 * The status message of the property "FID_DAB_G_MUTE_REQUEST"
 * Property indicating the mute-request for fc_dabtuner.
 * LCN2kai: Property for FC_Tunermaster
 */
class FID_DAB_G_MUTE_REQUESTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_MUTE_REQUESTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_MUTE_REQUESTStatus (const FID_DAB_G_MUTE_REQUESTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_MUTE_REQUESTStatus (bool bRequestMute_, uint8 u8Attenuation_, bool bMute_Interrupt_, bool bTa_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_MUTE_REQUESTStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_MUTE_REQUESTStatus& operator = (const FID_DAB_G_MUTE_REQUESTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_MUTE_REQUESTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bRequestMute"

    static const int kBRequestMute = 0;

    /**
     * Clears the field "bRequestMute".
     *
     * The field will be set to its default value. The hasBRequestMute()
     * method will return false.
     */
    inline void clearBRequestMute();

    /**
     * Checks whether the field "bRequestMute" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBRequestMute()). Otherwise it will return false.
     */
    inline bool hasBRequestMute () const;

    /**
     * Returns the value of the member "bRequestMute".
     *
     * TRUE:  Source shall be muted
     * FALSE: Source shall be demuted
     *
     * @return The value of the field "bRequestMute"
     */
    inline bool getBRequestMute () const;

    /**
     * Sets the value of the member "bRequestMute".
     *
     * TRUE:  Source shall be muted
     * FALSE: Source shall be demuted
     *
     * @param bRequestMute The value which will be set
     */
    inline void setBRequestMute (bool bRequestMute_);

    // API of field "u8Attenuation"

    static const int kU8Attenuation = 1;

    /**
     * Clears the field "u8Attenuation".
     *
     * The field will be set to its default value. The hasU8Attenuation()
     * method will return false.
     */
    inline void clearU8Attenuation();

    /**
     * Checks whether the field "u8Attenuation" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Attenuation()). Otherwise it will return false.
     */
    inline bool hasU8Attenuation () const;

    /**
     * Returns the value of the member "u8Attenuation".
     *
     * Volume attenuation in decibel
     *
     * @return The value of the field "u8Attenuation"
     */
    inline uint8 getU8Attenuation () const;

    /**
     * Sets the value of the member "u8Attenuation".
     *
     * Volume attenuation in decibel
     *
     * @param u8Attenuation The value which will be set
     */
    inline void setU8Attenuation (uint8 u8Attenuation_);

    // API of field "bMute_Interrupt"

    static const int kBMute_Interrupt = 2;

    /**
     * Clears the field "bMute_Interrupt".
     *
     * The field will be set to its default value. The hasBMute_Interrupt()
     * method will return false.
     */
    inline void clearBMute_Interrupt();

    /**
     * Checks whether the field "bMute_Interrupt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBMute_Interrupt()). Otherwise it will return false.
     */
    inline bool hasBMute_Interrupt () const;

    /**
     * Returns the value of the member "bMute_Interrupt".
     *
     * TRUE:  Non Interruptable
     * FALSE: Interruptable
     *
     * @return The value of the field "bMute_Interrupt"
     */
    inline bool getBMute_Interrupt () const;

    /**
     * Sets the value of the member "bMute_Interrupt".
     *
     * TRUE:  Non Interruptable
     * FALSE: Interruptable
     *
     * @param bMute_Interrupt The value which will be set
     */
    inline void setBMute_Interrupt (bool bMute_Interrupt_);

    // API of field "bTa"

    static const int kBTa = 3;

    /**
     * Clears the field "bTa".
     *
     * The field will be set to its default value. The hasBTa()
     * method will return false.
     */
    inline void clearBTa();

    /**
     * Checks whether the field "bTa" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTa()). Otherwise it will return false.
     */
    inline bool hasBTa () const;

    /**
     * Returns the value of the member "bTa".
     *
     * TRUE:  Source is DAB TA
     * FALSE: Source is DAB
     *
     * @return The value of the field "bTa"
     */
    inline bool getBTa () const;

    /**
     * Sets the value of the member "bTa".
     *
     * TRUE:  Source is DAB TA
     * FALSE: Source is DAB
     *
     * @param bTa The value which will be set
     */
    inline void setBTa (bool bTa_);

    static const FID_DAB_G_MUTE_REQUESTStatus &getDefaultInstance();

private:

    inline void set_has_bRequestMute ();

    inline void clear_has_bRequestMute ();

    inline void set_has_u8Attenuation ();

    inline void clear_has_u8Attenuation ();

    inline void set_has_bMute_Interrupt ();

    inline void clear_has_bMute_Interrupt ();

    inline void set_has_bTa ();

    inline void clear_has_bTa ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bRequestMute;

    uint8 _u8Attenuation;

    bool _bMute_Interrupt;

    bool _bTa;

};

/**
 * The status message of the property "FID_DAB_G_LEARNUPDATE_PROGRESS"
 * Provides the progress of the learn update in percentage.
 */
class FID_DAB_G_LEARNUPDATE_PROGRESSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_LEARNUPDATE_PROGRESSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_LEARNUPDATE_PROGRESSStatus (const FID_DAB_G_LEARNUPDATE_PROGRESSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_LEARNUPDATE_PROGRESSStatus (uint8 u8LearnPercentage_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_LEARNUPDATE_PROGRESSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_LEARNUPDATE_PROGRESSStatus& operator = (const FID_DAB_G_LEARNUPDATE_PROGRESSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_LEARNUPDATE_PROGRESSStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_LEARNUPDATE_PROGRESSStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_LEARNUPDATE_PROGRESSStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_LEARNUPDATE_PROGRESSStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8LearnPercentage"

    static const int kU8LearnPercentage = 0;

    /**
     * Clears the field "u8LearnPercentage".
     *
     * The field will be set to its default value. The hasU8LearnPercentage()
     * method will return false.
     */
    inline void clearU8LearnPercentage();

    /**
     * Checks whether the field "u8LearnPercentage" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8LearnPercentage()). Otherwise it will return false.
     */
    inline bool hasU8LearnPercentage () const;

    /**
     * Returns the value of the member "u8LearnPercentage".
     *
     * Percentage of frequencies scanned during learn update
     *
     * @return The value of the field "u8LearnPercentage"
     */
    inline uint8 getU8LearnPercentage () const;

    /**
     * Sets the value of the member "u8LearnPercentage".
     *
     * Percentage of frequencies scanned during learn update
     *
     * @param u8LearnPercentage The value which will be set
     */
    inline void setU8LearnPercentage (uint8 u8LearnPercentage_);

    static const FID_DAB_G_LEARNUPDATE_PROGRESSStatus &getDefaultInstance();

private:

    inline void set_has_u8LearnPercentage ();

    inline void clear_has_u8LearnPercentage ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _u8LearnPercentage;

};

/**
 * The status message of the property "FID_DAB_G_SRV_LIST_UPDATE"
 * Information about the service list.
 * LCN2: Property for HMI
 */
class FID_DAB_G_SRV_LIST_UPDATEStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_SRV_LIST_UPDATEStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_SRV_LIST_UPDATEStatus (const FID_DAB_G_SRV_LIST_UPDATEStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_SRV_LIST_UPDATEStatus (bool bActive_, bool bUpdateRunning_, uint16 u16ActivatedElementId_, const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ListElementAvailInfo >& ChangedSrvAvailList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_SRV_LIST_UPDATEStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_SRV_LIST_UPDATEStatus& operator = (const FID_DAB_G_SRV_LIST_UPDATEStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_SRV_LIST_UPDATEStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_SRV_LIST_UPDATEStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_SRV_LIST_UPDATEStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_SRV_LIST_UPDATEStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "bActive"

    static const int kBActive = 0;

    /**
     * Clears the field "bActive".
     *
     * The field will be set to its default value. The hasBActive()
     * method will return false.
     */
    inline void clearBActive();

    /**
     * Checks whether the field "bActive" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBActive()). Otherwise it will return false.
     */
    inline bool hasBActive () const;

    /**
     * Returns the value of the member "bActive".
     *
     * TRUE: channel list is currently active
     *
     * @return The value of the field "bActive"
     */
    inline bool getBActive () const;

    /**
     * Sets the value of the member "bActive".
     *
     * TRUE: channel list is currently active
     *
     * @param bActive The value which will be set
     */
    inline void setBActive (bool bActive_);

    // API of field "bUpdateRunning"

    static const int kBUpdateRunning = 1;

    /**
     * Clears the field "bUpdateRunning".
     *
     * The field will be set to its default value. The hasBUpdateRunning()
     * method will return false.
     */
    inline void clearBUpdateRunning();

    /**
     * Checks whether the field "bUpdateRunning" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBUpdateRunning()). Otherwise it will return false.
     */
    inline bool hasBUpdateRunning () const;

    /**
     * Returns the value of the member "bUpdateRunning".
     *
     * TRUE: Client has requested an update(learn).
     * HMI shall wait with request of updated chnList until the learn is done
     * an all data have been fethed from DAB-Module.
     *
     * @return The value of the field "bUpdateRunning"
     */
    inline bool getBUpdateRunning () const;

    /**
     * Sets the value of the member "bUpdateRunning".
     *
     * TRUE: Client has requested an update(learn).
     * HMI shall wait with request of updated chnList until the learn is done
     * an all data have been fethed from DAB-Module.
     *
     * @param bUpdateRunning The value which will be set
     */
    inline void setBUpdateRunning (bool bUpdateRunning_);

    // API of field "u16ActivatedElementId"

    static const int kU16ActivatedElementId = 2;

    /**
     * Clears the field "u16ActivatedElementId".
     *
     * The field will be set to its default value. The hasU16ActivatedElementId()
     * method will return false.
     */
    inline void clearU16ActivatedElementId();

    /**
     * Checks whether the field "u16ActivatedElementId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16ActivatedElementId()). Otherwise it will return false.
     */
    inline bool hasU16ActivatedElementId () const;

    /**
     * Returns the value of the member "u16ActivatedElementId".
     *
     * Element of the active list which matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @return The value of the field "u16ActivatedElementId"
     */
    inline uint16 getU16ActivatedElementId () const;

    /**
     * Sets the value of the member "u16ActivatedElementId".
     *
     * Element of the active list which matches with the currently activated element.
     * (0 indicates no matching element, otherwise the element with id u8ActivatedElementId-1 is active)
     *
     * @param u16ActivatedElementId The value which will be set
     */
    inline void setU16ActivatedElementId (uint16 u16ActivatedElementId_);

    // API of field "ChangedSrvAvailList"

    static const int kChangedSrvAvailList = 3;

    /**
     * Clears the field "ChangedSrvAvailList".
     *
     * The field will be set to its default value. The hasChangedSrvAvailList()
     * method will return false.
     */
    inline void clearChangedSrvAvailList();

    /**
     * Checks whether the field "ChangedSrvAvailList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChangedSrvAvailList()). Otherwise it will return false.
     */
    inline bool hasChangedSrvAvailList () const;

    /**
     * Returns the value of the member "ChangedSrvAvailList".
     *
     * Changed availabilities
     *
     * @return The value of the field "ChangedSrvAvailList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ListElementAvailInfo >& getChangedSrvAvailList () const;

    /**
     * Retrieves the value of the field "ChangedSrvAvailList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ChangedSrvAvailList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_ListElementAvailInfo >& getChangedSrvAvailListMutable ();

    /**
     * Sets the value of the member "ChangedSrvAvailList".
     *
     * Changed availabilities
     *
     * @param ChangedSrvAvailList The value which will be set
     */
    inline void setChangedSrvAvailList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ListElementAvailInfo >& ChangedSrvAvailList_);

    static const FID_DAB_G_SRV_LIST_UPDATEStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_ListElementAvailInfo >& getT_DAB_ListElementAvailInfoList_DefaultInstance ();

    inline void set_has_bActive ();

    inline void clear_has_bActive ();

    inline void set_has_bUpdateRunning ();

    inline void clear_has_bUpdateRunning ();

    inline void set_has_u16ActivatedElementId ();

    inline void clear_has_u16ActivatedElementId ();

    inline void set_has_ChangedSrvAvailList ();

    inline void clear_has_ChangedSrvAvailList ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _bActive;

    bool _bUpdateRunning;

    uint16 _u16ActivatedElementId;

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_ListElementAvailInfo > _ChangedSrvAvailList;

};

/**
 * The status message of the property "FID_DAB_G_TESTMODE_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_TESTMODE_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TESTMODE_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TESTMODE_DATAStatus (const FID_DAB_G_TESTMODE_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TESTMODE_DATAStatus (const ::dabtuner_main_fi_types::T_DAB_TestModeData& TestModeData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TESTMODE_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TESTMODE_DATAStatus& operator = (const FID_DAB_G_TESTMODE_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TESTMODE_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TESTMODE_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TESTMODE_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TESTMODE_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestModeData"

    static const int kTestModeData = 0;

    /**
     * Clears the field "TestModeData".
     *
     * The field will be set to its default value. The hasTestModeData()
     * method will return false.
     */
    inline void clearTestModeData();

    /**
     * Checks whether the field "TestModeData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestModeData()). Otherwise it will return false.
     */
    inline bool hasTestModeData () const;

    /**
     * Returns the value of the member "TestModeData".
     *
     * .
     *
     * @return The value of the field "TestModeData"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_TestModeData& getTestModeData () const;

    /**
     * Retrieves the value of the field "TestModeData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TestModeData".
     */
    inline ::dabtuner_main_fi_types::T_DAB_TestModeData& getTestModeDataMutable ();

    /**
     * Sets the value of the member "TestModeData".
     *
     * .
     *
     * @param TestModeData The value which will be set
     */
    inline void setTestModeData (const ::dabtuner_main_fi_types::T_DAB_TestModeData& TestModeData_);

    static const FID_DAB_G_TESTMODE_DATAStatus &getDefaultInstance();

private:

    inline void set_has_TestModeData ();

    inline void clear_has_TestModeData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_TestModeData _TestModeData;

};

/**
 * The status message of the property "FID_DAB_G_ACTIVE_ENSEMBLE_INFO"
 * The radio unit sends information regarding the current ensemble whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus (const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus (const ::dabtuner_main_fi_types::T_DAB_EnsembleInfo& EnsembleInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& operator = (const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EnsembleInfo"

    static const int kEnsembleInfo = 0;

    /**
     * Clears the field "EnsembleInfo".
     *
     * The field will be set to its default value. The hasEnsembleInfo()
     * method will return false.
     */
    inline void clearEnsembleInfo();

    /**
     * Checks whether the field "EnsembleInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleInfo()). Otherwise it will return false.
     */
    inline bool hasEnsembleInfo () const;

    /**
     * Returns the value of the member "EnsembleInfo".
     *
     * .
     *
     * @return The value of the field "EnsembleInfo"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_EnsembleInfo& getEnsembleInfo () const;

    /**
     * Retrieves the value of the field "EnsembleInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleInfo".
     */
    inline ::dabtuner_main_fi_types::T_DAB_EnsembleInfo& getEnsembleInfoMutable ();

    /**
     * Sets the value of the member "EnsembleInfo".
     *
     * .
     *
     * @param EnsembleInfo The value which will be set
     */
    inline void setEnsembleInfo (const ::dabtuner_main_fi_types::T_DAB_EnsembleInfo& EnsembleInfo_);

    static const FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus &getDefaultInstance();

private:

    inline void set_has_EnsembleInfo ();

    inline void clear_has_EnsembleInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_EnsembleInfo _EnsembleInfo;

};

/**
 * The status message of the property "FID_DAB_G_ACTIVE_SERVICE_INFO"
 * The radio unit sends information regarding the current service whenever data changes
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_ACTIVE_SERVICE_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_ACTIVE_SERVICE_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_ACTIVE_SERVICE_INFOStatus (const FID_DAB_G_ACTIVE_SERVICE_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_ACTIVE_SERVICE_INFOStatus (const ::dabtuner_main_fi_types::T_DAB_ServiceInfo& ServiceInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_ACTIVE_SERVICE_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_ACTIVE_SERVICE_INFOStatus& operator = (const FID_DAB_G_ACTIVE_SERVICE_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_ACTIVE_SERVICE_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_ACTIVE_SERVICE_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_ACTIVE_SERVICE_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_ACTIVE_SERVICE_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ServiceInfo"

    static const int kServiceInfo = 0;

    /**
     * Clears the field "ServiceInfo".
     *
     * The field will be set to its default value. The hasServiceInfo()
     * method will return false.
     */
    inline void clearServiceInfo();

    /**
     * Checks whether the field "ServiceInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setServiceInfo()). Otherwise it will return false.
     */
    inline bool hasServiceInfo () const;

    /**
     * Returns the value of the member "ServiceInfo".
     *
     * .
     *
     * @return The value of the field "ServiceInfo"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_ServiceInfo& getServiceInfo () const;

    /**
     * Retrieves the value of the field "ServiceInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ServiceInfo".
     */
    inline ::dabtuner_main_fi_types::T_DAB_ServiceInfo& getServiceInfoMutable ();

    /**
     * Sets the value of the member "ServiceInfo".
     *
     * .
     *
     * @param ServiceInfo The value which will be set
     */
    inline void setServiceInfo (const ::dabtuner_main_fi_types::T_DAB_ServiceInfo& ServiceInfo_);

    static const FID_DAB_G_ACTIVE_SERVICE_INFOStatus &getDefaultInstance();

private:

    inline void set_has_ServiceInfo ();

    inline void clear_has_ServiceInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_ServiceInfo _ServiceInfo;

};

/**
 * The status message of the property "FID_DAB_G_ACTIVE_COMPONENT_INFO"
 * The radio unit sends information regarding the current component whenever data changes.
 * LCN2: Property for HMI (TestMode)
 */
class FID_DAB_G_ACTIVE_COMPONENT_INFOStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_ACTIVE_COMPONENT_INFOStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_ACTIVE_COMPONENT_INFOStatus (const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_ACTIVE_COMPONENT_INFOStatus (const ::dabtuner_main_fi_types::T_DAB_ComponentInfo& ComponentInfo_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_ACTIVE_COMPONENT_INFOStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_ACTIVE_COMPONENT_INFOStatus& operator = (const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "ComponentInfo"

    static const int kComponentInfo = 0;

    /**
     * Clears the field "ComponentInfo".
     *
     * The field will be set to its default value. The hasComponentInfo()
     * method will return false.
     */
    inline void clearComponentInfo();

    /**
     * Checks whether the field "ComponentInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setComponentInfo()). Otherwise it will return false.
     */
    inline bool hasComponentInfo () const;

    /**
     * Returns the value of the member "ComponentInfo".
     *
     * .
     *
     * @return The value of the field "ComponentInfo"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_ComponentInfo& getComponentInfo () const;

    /**
     * Retrieves the value of the field "ComponentInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "ComponentInfo".
     */
    inline ::dabtuner_main_fi_types::T_DAB_ComponentInfo& getComponentInfoMutable ();

    /**
     * Sets the value of the member "ComponentInfo".
     *
     * .
     *
     * @param ComponentInfo The value which will be set
     */
    inline void setComponentInfo (const ::dabtuner_main_fi_types::T_DAB_ComponentInfo& ComponentInfo_);

    static const FID_DAB_G_ACTIVE_COMPONENT_INFOStatus &getDefaultInstance();

private:

    inline void set_has_ComponentInfo ();

    inline void clear_has_ComponentInfo ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_ComponentInfo _ComponentInfo;

};

/**
 * The status message of the property "FID_DAB_G_BG_TESTMODE_DATA"
 * The radio unit sends this background dab tuner information only when test mode has been activated.
 * "Get" is not possible, only a spontaneous response is supported as response to the activated Test
 * Mode with FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
class FID_DAB_G_BG_TESTMODE_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_BG_TESTMODE_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_BG_TESTMODE_DATAStatus (const FID_DAB_G_BG_TESTMODE_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_BG_TESTMODE_DATAStatus (const ::dabtuner_main_fi_types::T_DAB_BG_TestModeData& BG_TestModeData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_BG_TESTMODE_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_BG_TESTMODE_DATAStatus& operator = (const FID_DAB_G_BG_TESTMODE_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_BG_TESTMODE_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_BG_TESTMODE_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_BG_TESTMODE_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_BG_TESTMODE_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BG_TestModeData"

    static const int kBG_TestModeData = 0;

    /**
     * Clears the field "BG_TestModeData".
     *
     * The field will be set to its default value. The hasBG_TestModeData()
     * method will return false.
     */
    inline void clearBG_TestModeData();

    /**
     * Checks whether the field "BG_TestModeData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBG_TestModeData()). Otherwise it will return false.
     */
    inline bool hasBG_TestModeData () const;

    /**
     * Returns the value of the member "BG_TestModeData".
     *
     * .
     *
     * @return The value of the field "BG_TestModeData"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_BG_TestModeData& getBG_TestModeData () const;

    /**
     * Retrieves the value of the field "BG_TestModeData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "BG_TestModeData".
     */
    inline ::dabtuner_main_fi_types::T_DAB_BG_TestModeData& getBG_TestModeDataMutable ();

    /**
     * Sets the value of the member "BG_TestModeData".
     *
     * .
     *
     * @param BG_TestModeData The value which will be set
     */
    inline void setBG_TestModeData (const ::dabtuner_main_fi_types::T_DAB_BG_TestModeData& BG_TestModeData_);

    static const FID_DAB_G_BG_TESTMODE_DATAStatus &getDefaultInstance();

private:

    inline void set_has_BG_TestModeData ();

    inline void clear_has_BG_TestModeData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_BG_TestModeData _BG_TestModeData;

};

/**
 * The status message of the property "FID_DAB_G_TMC_TPEG_DATA"
 * The radio unit sends this information only when test mode has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated Test Mode with
 * FID_DAB_S_SETUP.
 * LCN2kai: Property for HMI (TestMode)
 */
class FID_DAB_G_TMC_TPEG_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TMC_TPEG_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TMC_TPEG_DATAStatus (const FID_DAB_G_TMC_TPEG_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TMC_TPEG_DATAStatus (const ::dabtuner_main_fi_types::T_DAB_TMC_TPEG_TestModeData& TestModeData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TMC_TPEG_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TMC_TPEG_DATAStatus& operator = (const FID_DAB_G_TMC_TPEG_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TMC_TPEG_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TMC_TPEG_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TMC_TPEG_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TMC_TPEG_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TestModeData"

    static const int kTestModeData = 0;

    /**
     * Clears the field "TestModeData".
     *
     * The field will be set to its default value. The hasTestModeData()
     * method will return false.
     */
    inline void clearTestModeData();

    /**
     * Checks whether the field "TestModeData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTestModeData()). Otherwise it will return false.
     */
    inline bool hasTestModeData () const;

    /**
     * Returns the value of the member "TestModeData".
     *
     * .
     *
     * @return The value of the field "TestModeData"
     */
    inline const ::dabtuner_main_fi_types::T_DAB_TMC_TPEG_TestModeData& getTestModeData () const;

    /**
     * Retrieves the value of the field "TestModeData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TestModeData".
     */
    inline ::dabtuner_main_fi_types::T_DAB_TMC_TPEG_TestModeData& getTestModeDataMutable ();

    /**
     * Sets the value of the member "TestModeData".
     *
     * .
     *
     * @param TestModeData The value which will be set
     */
    inline void setTestModeData (const ::dabtuner_main_fi_types::T_DAB_TMC_TPEG_TestModeData& TestModeData_);

    static const FID_DAB_G_TMC_TPEG_DATAStatus &getDefaultInstance();

private:

    inline void set_has_TestModeData ();

    inline void clear_has_TestModeData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::dabtuner_main_fi_types::T_DAB_TMC_TPEG_TestModeData _TestModeData;

};

/**
 * The status message of the property "FID_DAB_G_TMC_DATA"
 * The radio unit sends this information only when tmc data has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated TMC.
 * LCN2: Property for HMI (TMC)
 */
class FID_DAB_G_TMC_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TMC_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TMC_DATAStatus (const FID_DAB_G_TMC_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TMC_DATAStatus (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TmcInfo >& TmcData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TMC_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TMC_DATAStatus& operator = (const FID_DAB_G_TMC_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TMC_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TMC_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TMC_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TMC_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TmcData"

    static const int kTmcData = 0;

    /**
     * Clears the field "TmcData".
     *
     * The field will be set to its default value. The hasTmcData()
     * method will return false.
     */
    inline void clearTmcData();

    /**
     * Checks whether the field "TmcData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTmcData()). Otherwise it will return false.
     */
    inline bool hasTmcData () const;

    /**
     * Returns the value of the member "TmcData".
     *
     * list of tmc-data elements
     *
     * @return The value of the field "TmcData"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TmcInfo >& getTmcData () const;

    /**
     * Retrieves the value of the field "TmcData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TmcData".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_TmcInfo >& getTmcDataMutable ();

    /**
     * Sets the value of the member "TmcData".
     *
     * list of tmc-data elements
     *
     * @param TmcData The value which will be set
     */
    inline void setTmcData (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TmcInfo >& TmcData_);

    static const FID_DAB_G_TMC_DATAStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TmcInfo >& getT_DAB_TmcInfoList_DefaultInstance ();

    inline void set_has_TmcData ();

    inline void clear_has_TmcData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_TmcInfo > _TmcData;

};

/**
 * The status message of the property "FID_DAB_G_TMC_AVAIL_LIST"
 * List of ensembles with provided rdbIds
 */
class FID_DAB_G_TMC_AVAIL_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TMC_AVAIL_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TMC_AVAIL_LISTStatus (const FID_DAB_G_TMC_AVAIL_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TMC_AVAIL_LISTStatus (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleTmcInfo >& EnsembleTmcInfoList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TMC_AVAIL_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TMC_AVAIL_LISTStatus& operator = (const FID_DAB_G_TMC_AVAIL_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TMC_AVAIL_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TMC_AVAIL_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TMC_AVAIL_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TMC_AVAIL_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "EnsembleTmcInfoList"

    static const int kEnsembleTmcInfoList = 0;

    /**
     * Clears the field "EnsembleTmcInfoList".
     *
     * The field will be set to its default value. The hasEnsembleTmcInfoList()
     * method will return false.
     */
    inline void clearEnsembleTmcInfoList();

    /**
     * Checks whether the field "EnsembleTmcInfoList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEnsembleTmcInfoList()). Otherwise it will return false.
     */
    inline bool hasEnsembleTmcInfoList () const;

    /**
     * Returns the value of the member "EnsembleTmcInfoList".
     *
     * Information (ensembleId, rdbIdList) about each ensemble providing tmc-data
     * While DAB is in ForeGround the list will only contain the current ensemble.
     * The list will only contain ensembles with at least one tmc-service
     *
     * @return The value of the field "EnsembleTmcInfoList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleTmcInfo >& getEnsembleTmcInfoList () const;

    /**
     * Retrieves the value of the field "EnsembleTmcInfoList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "EnsembleTmcInfoList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleTmcInfo >& getEnsembleTmcInfoListMutable ();

    /**
     * Sets the value of the member "EnsembleTmcInfoList".
     *
     * Information (ensembleId, rdbIdList) about each ensemble providing tmc-data
     * While DAB is in ForeGround the list will only contain the current ensemble.
     * The list will only contain ensembles with at least one tmc-service
     *
     * @param EnsembleTmcInfoList The value which will be set
     */
    inline void setEnsembleTmcInfoList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleTmcInfo >& EnsembleTmcInfoList_);

    static const FID_DAB_G_TMC_AVAIL_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleTmcInfo >& getT_DAB_EnsembleTmcInfoList_DefaultInstance ();

    inline void set_has_EnsembleTmcInfoList ();

    inline void clear_has_EnsembleTmcInfoList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_EnsembleTmcInfo > _EnsembleTmcInfoList;

};

/**
 * The status message of the property "FID_DAB_G_TPEG_DATA"
 * The radio unit sends this information only when tpeg data has been activated. "Get" is not
 * possible, only a spontaneous response is supported as response to the activated TPEG service.
 */
class FID_DAB_G_TPEG_DATAStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TPEG_DATAStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TPEG_DATAStatus (const FID_DAB_G_TPEG_DATAStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TPEG_DATAStatus (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegInfo >& TpegData_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TPEG_DATAStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TPEG_DATAStatus& operator = (const FID_DAB_G_TPEG_DATAStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TPEG_DATAStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TPEG_DATAStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TPEG_DATAStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TPEG_DATAStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TpegData"

    static const int kTpegData = 0;

    /**
     * Clears the field "TpegData".
     *
     * The field will be set to its default value. The hasTpegData()
     * method will return false.
     */
    inline void clearTpegData();

    /**
     * Checks whether the field "TpegData" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTpegData()). Otherwise it will return false.
     */
    inline bool hasTpegData () const;

    /**
     * Returns the value of the member "TpegData".
     *
     * list of tpeg-data elements
     *
     * @return The value of the field "TpegData"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegInfo >& getTpegData () const;

    /**
     * Retrieves the value of the field "TpegData" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TpegData".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegInfo >& getTpegDataMutable ();

    /**
     * Sets the value of the member "TpegData".
     *
     * list of tpeg-data elements
     *
     * @param TpegData The value which will be set
     */
    inline void setTpegData (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegInfo >& TpegData_);

    static const FID_DAB_G_TPEG_DATAStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegInfo >& getT_DAB_TpegInfoList_DefaultInstance ();

    inline void set_has_TpegData ();

    inline void clear_has_TpegData ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegInfo > _TpegData;

};

/**
 * The status message of the property "FID_DAB_G_TPEG_URI_LIST"
 * With this command the DAB TPEG URI list with all receivable TPEG services will be replied.
 */
class FID_DAB_G_TPEG_URI_LISTStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_TPEG_URI_LISTStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_TPEG_URI_LISTStatus (const FID_DAB_G_TPEG_URI_LISTStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_TPEG_URI_LISTStatus (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& TpegUriChannelList_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_TPEG_URI_LISTStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_TPEG_URI_LISTStatus& operator = (const FID_DAB_G_TPEG_URI_LISTStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FID_DAB_G_TPEG_URI_LISTStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FID_DAB_G_TPEG_URI_LISTStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FID_DAB_G_TPEG_URI_LISTStatus& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FID_DAB_G_TPEG_URI_LISTStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TpegUriChannelList"

    static const int kTpegUriChannelList = 0;

    /**
     * Clears the field "TpegUriChannelList".
     *
     * The field will be set to its default value. The hasTpegUriChannelList()
     * method will return false.
     */
    inline void clearTpegUriChannelList();

    /**
     * Checks whether the field "TpegUriChannelList" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTpegUriChannelList()). Otherwise it will return false.
     */
    inline bool hasTpegUriChannelList () const;

    /**
     * Returns the value of the member "TpegUriChannelList".
     *
     * Data for the requested section of tpeg elements
     *
     * @return The value of the field "TpegUriChannelList"
     */
    inline const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& getTpegUriChannelList () const;

    /**
     * Retrieves the value of the field "TpegUriChannelList" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TpegUriChannelList".
     */
    inline ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& getTpegUriChannelListMutable ();

    /**
     * Sets the value of the member "TpegUriChannelList".
     *
     * Data for the requested section of tpeg elements
     *
     * @param TpegUriChannelList The value which will be set
     */
    inline void setTpegUriChannelList (const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& TpegUriChannelList_);

    static const FID_DAB_G_TPEG_URI_LISTStatus &getDefaultInstance();

private:

    static const ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel >& getT_DAB_TpegUriChannelList_DefaultInstance ();

    inline void set_has_TpegUriChannelList ();

    inline void clear_has_TpegUriChannelList ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::dabtuner_main_fi_types::T_DAB_TpegUriChannel > _TpegUriChannelList;

};

/**
 * The status message of the property "FID_DAB_G_MTC_SETMODE_STATUS"
 * This property sets the service linking in the mode set by FID_DAB_S_SERVICE_LINKING_SETMODE.
 */
class FID_DAB_G_MTC_SETMODE_STATUSStatus  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FID_DAB_G_MTC_SETMODE_STATUSStatus ();

    /**
     * Copy constructor
     */
    inline  FID_DAB_G_MTC_SETMODE_STATUSStatus (const FID_DAB_G_MTC_SETMODE_STATUSStatus &rhs);

    /**
     * All fields constructor
     */
    inline  FID_DAB_G_MTC_SETMODE_STATUSStatus (const ::dabtuner_main_fi_types::T_b8_DAB_MTC_SetMode& Mode_);

    /**
     * Destructor
     */
    inline virtual  ~FID_DAB_G_MTC_SETMODE_STATUSStatus();

    /**
     * Assignment operator
     */
    inline FID_DAB_G_MTC_SETMODE_STATUSStatus& operator = (const FID_DAB_G_MTC_SETMODE_STATUSStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects ar