/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_W1_WPA_SUPPLICANT1_INTERFACESTUB_H
#define FI_W1_WPA_SUPPLICANT1_INTERFACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1/Interface.h"
#include <map>
#include <string>

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace Interface {

class InterfaceStubDelegate;

class InterfaceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the InterfaceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    InterfaceStub (const std::string& portName);

    /**
     * Create an instance of the InterfaceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    InterfaceStub (const std::string& portName, const std::string& objectPath);

    virtual ~InterfaceStub();

    // signal 'BSSAdded'

    /**
     * Raise the signal 'BSSAdded' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'BSSAdded'</b>:
     *
     * If the meaning of "BSSAdded" isn't clear, then there should be a description here.
     */
    void sendBSSAddedSignal(const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    // signal 'BSSRemoved'

    /**
     * Raise the signal 'BSSRemoved' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'BSSRemoved'</b>:
     *
     * If the meaning of "BSSRemoved" isn't clear, then there should be a description here.
     */
    void sendBSSRemovedSignal(const ::std::string& path);

    // property 'Country'

    /**
     * The method onCountryGet() is called by ASF when a client invokes the
     * read method for the property 'Country'. The onCountryGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    virtual void onCountryGet(const ::boost::shared_ptr< CountryGet >& payload);

    /**
     * Sends back the update to a previous onCountryGet().
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onCountryGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCountryGetUpdate(const ::std::string& country, act_t act = 0);

    /**
     * The method onCountrySet() is called by ASF when a client invokes the
     * write method for the property 'Country'. The onCountrySet() method set
     * property value to the given parameter Country by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    virtual void onCountrySet(const ::boost::shared_ptr< CountrySet >& payload);

    /**
     * Sends back the update to a previous onCountrySet().
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onCountrySet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCountrySetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Country' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    void setCountry(const ::std::string& country);

    /**
     * Returns the current value of the property 'Country'.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    const ::std::string& getCountry() const;

    /**
     * Returns the current value of the property 'Country' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCountryUpdate() method.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    ::std::string& getCountryMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCountryUpdate().
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    void sendCountryUpdate();

    // property 'DisconnectReason'

    /**
     * The method onDisconnectReasonGet() is called by ASF when a client
     * invokes the read method for the property 'DisconnectReason'. The
     * onDisconnectReasonGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     */
    virtual void onDisconnectReasonGet(const ::boost::shared_ptr< DisconnectReasonGet >& payload);

    /**
     * Sends back the update to a previous onDisconnectReasonGet().
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDisconnectReasonGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDisconnectReasonGetUpdate(int32 disconnectReason, act_t act = 0);

    /**
     * Set the value of the property 'DisconnectReason' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     */
    void setDisconnectReason(int32 disconnectReason);

    /**
     * Returns the current value of the property 'DisconnectReason'.
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     */
    int32 getDisconnectReason() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDisconnectReasonUpdate().
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     */
    void sendDisconnectReasonUpdate();

    // property 'State'

    /**
     * The method onStateGet() is called by ASF when a client invokes the read
     * method for the property 'State'. The onStateGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    virtual void onStateGet(const ::boost::shared_ptr< StateGet >& payload);

    /**
     * Sends back the update to a previous onStateGet().
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onStateGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStateGetUpdate(const ::std::string& state, act_t act = 0);

    /**
     * Set the value of the property 'State' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    void setState(const ::std::string& state);

    /**
     * Returns the current value of the property 'State'.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    const ::std::string& getState() const;

    /**
     * Returns the current value of the property 'State' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStateUpdate() method.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    ::std::string& getStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStateUpdate().
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    void sendStateUpdate();

    // property 'CurrentBSS'

    /**
     * The method onCurrentBSSGet() is called by ASF when a client invokes the
     * read method for the property 'CurrentBSS'. The onCurrentBSSGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     */
    virtual void onCurrentBSSGet(const ::boost::shared_ptr< CurrentBSSGet >& payload);

    /**
     * Sends back the update to a previous onCurrentBSSGet().
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onCurrentBSSGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCurrentBSSGetUpdate(const ::std::string& currentBSS, act_t act = 0);

    /**
     * Set the value of the property 'CurrentBSS' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     */
    void setCurrentBSS(const ::std::string& currentBSS);

    /**
     * Returns the current value of the property 'CurrentBSS'.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     */
    const ::std::string& getCurrentBSS() const;

    /**
     * Returns the current value of the property 'CurrentBSS' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendCurrentBSSUpdate() method.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     */
    ::std::string& getCurrentBSSMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendCurrentBSSUpdate().
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     */
    void sendCurrentBSSUpdate();

    // method 'Scan'

    /**
     * The method onScan() is called by ASF when a client invokes the method
     * 'Scan'. A subclass has to implement this method and send back a
     * response to the client either with the sendScan() or sendScanError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onScanRequest (const ::boost::shared_ptr< ScanRequest >& request) = 0;

    /**
     * The method sendScanResponse() sends a response of a previous method
     * invocation of 'Scan' back to the client.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onScan(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendScanResponse (act_t act = 0);

    /**
     * The method sendScanError() sends an error response of a previous method
     * invocation of 'Scan' back to the client.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onScan(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendScanError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Disconnect'

    /**
     * The method onDisconnect() is called by ASF when a client invokes the
     * method 'Disconnect'. A subclass has to implement this method and send
     * back a response to the client either with the sendDisconnect() or
     * sendDisconnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisconnectRequest (const ::boost::shared_ptr< DisconnectRequest >& request) = 0;

    /**
     * The method sendDisconnectResponse() sends a response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisconnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisconnectResponse (act_t act = 0);

    /**
     * The method sendDisconnectError() sends an error response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisconnect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    CountryUpdate _CountryProperty;

    DisconnectReasonUpdate _DisconnectReasonProperty;

    StateUpdate _StateProperty;

    CurrentBSSUpdate _CurrentBSSProperty;

    friend class InterfaceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Interface
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi

#endif // FI_W1_WPA_SUPPLICANT1_INTERFACESTUB_H
