/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1/Interface.h"
#include "fi/w1/wpa_supplicant1/InterfaceDBus.h"
#include "fi/w1/wpa_supplicant1/InterfaceJson.h"
#include "fi/w1/wpa_supplicant1/InterfaceStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace Interface {

DEFINE_CLASS_LOGGER("//fi/w1/wpa_supplicant1/Interfaces/XX/fi/w1/wpa_supplicant1/Interface", InterfaceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Scan", 0 },
    { 10, "Disconnect", 1 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 5, "State", 2 },
    { 7, "Country", 0 },
    { 10, "CurrentBSS", 3 },
    { 16, "DisconnectReason", 1 },
};

class InterfaceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    InterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    InterfaceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    InterfaceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "fi.w1.wpa_supplicant1.Interface"),
          _logger(logger) {}

    virtual ~InterfaceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void InterfaceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Scan'

            LOG_DEBUG_STUB("process method '%s'", "Scan");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScanRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Scan", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ScanRequest > payload = ::boost::static_pointer_cast<ScanRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<InterfaceStub*>(getStub())->onScanRequest(payload);
            return;
        }
        case 1: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<InterfaceStub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* InterfaceStubDelegate::introspect() const {
    return     "<interface name=\"fi.w1.wpa_supplicant1.Interface\">\n"
            "      <method name=\"Scan\">\n"
            "        <arg direction=\"in\" name=\"args\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"Disconnect\"/>\n"
            "      <signal name=\"BSSAdded\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "        <arg name=\"properties\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BSSRemoved\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <property access=\"readwrite\" name=\"Country\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"DisconnectReason\" type=\"i\"/>\n"
            "      <property access=\"read\" name=\"State\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"CurrentBSS\" type=\"s\"/>\n"
            "</interface>\n";
}

void InterfaceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<InterfaceStub*>(getStub()))->onGetAll (properties);
}

void InterfaceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Country");
            ::boost::shared_ptr< CountrySet > payload(new CountrySet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<InterfaceStub*>(getStub())->onCountrySet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DisconnectReason");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "State");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentBSS");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void InterfaceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 4, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Country");
            ::boost::shared_ptr< CountryGet > payload(new CountryGet());
            payload->setAct(act);
            static_cast<InterfaceStub*>(getStub())->onCountryGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "DisconnectReason");
            ::boost::shared_ptr< DisconnectReasonGet > payload(new DisconnectReasonGet());
            payload->setAct(act);
            static_cast<InterfaceStub*>(getStub())->onDisconnectReasonGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "State");
            ::boost::shared_ptr< StateGet > payload(new StateGet());
            payload->setAct(act);
            static_cast<InterfaceStub*>(getStub())->onStateGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "CurrentBSS");
            ::boost::shared_ptr< CurrentBSSGet > payload(new CurrentBSSGet());
            payload->setAct(act);
            static_cast<InterfaceStub*>(getStub())->onCurrentBSSGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

InterfaceStub::InterfaceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new InterfaceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

InterfaceStub::InterfaceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new InterfaceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

InterfaceStub::~InterfaceStub() {
    delete _stubDelegate;
}

void InterfaceStub::sendBSSAddedSignal(const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    if (_stubDelegate->isConnected()) {
        BSSAddedSignal* payload = new BSSAddedSignal(path, properties);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BSSAdded", BSSAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "BSSAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BSSAdded");
    }
}

void InterfaceStub::sendBSSRemovedSignal(const ::std::string& path) {
    if (_stubDelegate->isConnected()) {
        BSSRemovedSignal* payload = new BSSRemovedSignal(path);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BSSRemoved", BSSRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "BSSRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BSSRemoved");
    }
}

void InterfaceStub::sendCountryUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CountryUpdate payload(_CountryProperty);

        LOG_INFO ("-> send%s", "CountryUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Country", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fi.w1.wpa_supplicant1.Interface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CountryUpdate");
    }
}

void InterfaceStub::onCountryGet(const ::boost::shared_ptr< CountryGet >& country) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CountryGet", country->getAct());
    sendCountryGetUpdate(_CountryProperty.getCountry(), country->getAct());
}

void InterfaceStub::sendCountryGetUpdate(const ::std::string& country, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CountryGet payload(country);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CountryGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void InterfaceStub::onCountrySet(const ::boost::shared_ptr< CountrySet >& country) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CountrySet", country->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*country, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setCountry (country->getCountry());
    sendCountrySetUpdate(country->getAct());
}

void InterfaceStub::sendCountrySetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CountrySetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void InterfaceStub::setCountry(const ::std::string& country) {
    if(country!=_CountryProperty.getCountry()) {
        _CountryProperty.setCountry(country);
        sendCountryUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& InterfaceStub::getCountry() const {
    return _CountryProperty.getCountry();
}

::std::string& InterfaceStub::getCountryMutable() {
    return _CountryProperty.getCountryMutable();
}

void InterfaceStub::sendDisconnectReasonUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DisconnectReasonUpdate payload(_DisconnectReasonProperty);

        LOG_INFO ("-> send%s", "DisconnectReasonUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DisconnectReason", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fi.w1.wpa_supplicant1.Interface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DisconnectReasonUpdate");
    }
}

void InterfaceStub::onDisconnectReasonGet(const ::boost::shared_ptr< DisconnectReasonGet >& disconnectReason) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DisconnectReasonGet", disconnectReason->getAct());
    sendDisconnectReasonGetUpdate(_DisconnectReasonProperty.getDisconnectReason(), disconnectReason->getAct());
}

void InterfaceStub::sendDisconnectReasonGetUpdate(int32 disconnectReason, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DisconnectReasonGet payload(disconnectReason);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DisconnectReasonGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void InterfaceStub::setDisconnectReason(int32 disconnectReason) {
    if(disconnectReason!=_DisconnectReasonProperty.getDisconnectReason()) {
        _DisconnectReasonProperty.setDisconnectReason(disconnectReason);
        sendDisconnectReasonUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

int32 InterfaceStub::getDisconnectReason() const {
    return _DisconnectReasonProperty.getDisconnectReason();
}

void InterfaceStub::sendStateUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StateUpdate payload(_StateProperty);

        LOG_INFO ("-> send%s", "StateUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("State", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fi.w1.wpa_supplicant1.Interface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StateUpdate");
    }
}

void InterfaceStub::onStateGet(const ::boost::shared_ptr< StateGet >& state) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StateGet", state->getAct());
    sendStateGetUpdate(_StateProperty.getState(), state->getAct());
}

void InterfaceStub::sendStateGetUpdate(const ::std::string& state, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StateGet payload(state);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StateGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void InterfaceStub::setState(const ::std::string& state) {
    if(state!=_StateProperty.getState()) {
        _StateProperty.setState(state);
        sendStateUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& InterfaceStub::getState() const {
    return _StateProperty.getState();
}

::std::string& InterfaceStub::getStateMutable() {
    return _StateProperty.getStateMutable();
}

void InterfaceStub::sendCurrentBSSUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        CurrentBSSUpdate payload(_CurrentBSSProperty);

        LOG_INFO ("-> send%s", "CurrentBSSUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("CurrentBSS", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fi.w1.wpa_supplicant1.Interface", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "CurrentBSSUpdate");
    }
}

void InterfaceStub::onCurrentBSSGet(const ::boost::shared_ptr< CurrentBSSGet >& currentBSS) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "CurrentBSSGet", currentBSS->getAct());
    sendCurrentBSSGetUpdate(_CurrentBSSProperty.getCurrentBSS(), currentBSS->getAct());
}

void InterfaceStub::sendCurrentBSSGetUpdate(const ::std::string& currentBSS, act_t act) {
    ::asf::dbus::DBusVariant variant;
    CurrentBSSGet payload(currentBSS);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "CurrentBSSGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void InterfaceStub::setCurrentBSS(const ::std::string& currentBSS) {
    if(currentBSS!=_CurrentBSSProperty.getCurrentBSS()) {
        _CurrentBSSProperty.setCurrentBSS(currentBSS);
        sendCurrentBSSUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& InterfaceStub::getCurrentBSS() const {
    return _CurrentBSSProperty.getCurrentBSS();
}

::std::string& InterfaceStub::getCurrentBSSMutable() {
    return _CurrentBSSProperty.getCurrentBSSMutable();
}

void  InterfaceStub::sendScanResponse (act_t act) {
    ScanResponse* payload = new ScanResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Scan", ScanResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Scan", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  InterfaceStub::sendScanError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ScanError* payload = new ScanError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Scan", ScanError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Scan", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  InterfaceStub::sendDisconnectResponse (act_t act) {
    DisconnectResponse* payload = new DisconnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  InterfaceStub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void InterfaceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Country'
    {
        ::asf::dbus::DBusVariant variant;
        CountryGet payload(_CountryProperty.getCountry());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Country", variant));
    }

    //property 'DisconnectReason'
    {
        ::asf::dbus::DBusVariant variant;
        DisconnectReasonGet payload(_DisconnectReasonProperty.getDisconnectReason());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DisconnectReason", variant));
    }

    //property 'State'
    {
        ::asf::dbus::DBusVariant variant;
        StateGet payload(_StateProperty.getState());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("State", variant));
    }

    //property 'CurrentBSS'
    {
        ::asf::dbus::DBusVariant variant;
        CurrentBSSGet payload(_CurrentBSSProperty.getCurrentBSS());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("CurrentBSS", variant));
    }
}

} // namespace Interface
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi
