/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1/Interface.h"
#include "fi/w1/wpa_supplicant1/InterfaceDBus.h"
#include "fi/w1/wpa_supplicant1/InterfaceJson.h"
#include "fi/w1/wpa_supplicant1/InterfaceProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace Interface {

DEFINE_CLASS_LOGGER("//fi/w1/wpa_supplicant1/Interfaces/XX/fi/w1/wpa_supplicant1/Interface", InterfaceProxy);

class InterfaceProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    InterfaceProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< InterfaceProxy >& proxyShared = ::boost::static_pointer_cast< InterfaceProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_BSSAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BSSAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BSSAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BSSAddedSignal> payload = ::boost::static_pointer_cast<BSSAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BSSAddedCallbackIF*) _callback)->onBSSAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BSSRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BSSRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BSSRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BSSRemovedSignal> payload = ::boost::static_pointer_cast<BSSRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BSSRemovedCallbackIF*) _callback)->onBSSRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Country:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CountryError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Country", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CountryError> payload = ::boost::static_pointer_cast<CountryError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CountryCallbackIF*) _callback)->onCountryError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CountryUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Country", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CountryUpdate> payload = ::boost::static_pointer_cast<CountryUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CountryCallbackIF*) _callback)->onCountryUpdate(proxyShared, payload);
                        proxyShared->_country = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DisconnectReason:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectReasonError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisconnectReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectReasonError> payload = ::boost::static_pointer_cast<DisconnectReasonError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DisconnectReasonCallbackIF*) _callback)->onDisconnectReasonError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectReasonUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DisconnectReason", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectReasonUpdate> payload = ::boost::static_pointer_cast<DisconnectReasonUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DisconnectReasonCallbackIF*) _callback)->onDisconnectReasonUpdate(proxyShared, payload);
                        proxyShared->_disconnectReason = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_State:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StateError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "State", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StateError> payload = ::boost::static_pointer_cast<StateError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StateCallbackIF*) _callback)->onStateError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StateUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "State", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StateUpdate> payload = ::boost::static_pointer_cast<StateUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StateCallbackIF*) _callback)->onStateUpdate(proxyShared, payload);
                        proxyShared->_state = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CurrentBSS:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentBSSError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentBSS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentBSSError> payload = ::boost::static_pointer_cast<CurrentBSSError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((CurrentBSSCallbackIF*) _callback)->onCurrentBSSError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CurrentBSSUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CurrentBSS", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CurrentBSSUpdate> payload = ::boost::static_pointer_cast<CurrentBSSUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((CurrentBSSCallbackIF*) _callback)->onCurrentBSSUpdate(proxyShared, payload);
                        proxyShared->_currentBSS = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Scan:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ScanError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Scan", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ScanError> payload = ::boost::static_pointer_cast<ScanError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ScanCallbackIF*) _callback)->onScanError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScanResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Scan", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ScanResponse> payload = ::boost::static_pointer_cast<ScanResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ScanCallbackIF*) _callback)->onScanResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Disconnect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectError> payload = ::boost::static_pointer_cast<DisconnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectResponse> payload = ::boost::static_pointer_cast<DisconnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_BSSAdded: {
                ::boost::shared_ptr< BSSAddedError > payload = ::boost::shared_ptr< BSSAddedError >
                (new BSSAddedError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BSSAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BSSAddedCallbackIF*) _callback)->onBSSAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BSSRemoved: {
                ::boost::shared_ptr< BSSRemovedError > payload = ::boost::shared_ptr< BSSRemovedError >
                (new BSSRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BSSRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BSSRemovedCallbackIF*) _callback)->onBSSRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Country: {
                ::boost::shared_ptr< CountryError > payload = ::boost::shared_ptr< CountryError >
                (new CountryError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Country", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CountryCallbackIF*) _callback)->onCountryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisconnectReason: {
                ::boost::shared_ptr< DisconnectReasonError > payload = ::boost::shared_ptr< DisconnectReasonError >
                (new DisconnectReasonError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisconnectReason", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectReasonCallbackIF*) _callback)->onDisconnectReasonError (proxyShared,payload);
                return true;
            }
            break;
            case ID_State: {
                ::boost::shared_ptr< StateError > payload = ::boost::shared_ptr< StateError >
                (new StateError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "State", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StateCallbackIF*) _callback)->onStateError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CurrentBSS: {
                ::boost::shared_ptr< CurrentBSSError > payload = ::boost::shared_ptr< CurrentBSSError >
                (new CurrentBSSError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CurrentBSS", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CurrentBSSCallbackIF*) _callback)->onCurrentBSSError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Scan: {
                ::boost::shared_ptr< ScanError > payload = ::boost::shared_ptr< ScanError >
                (new ScanError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Scan", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ScanCallbackIF*) _callback)->onScanError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Disconnect: {
                ::boost::shared_ptr< DisconnectError > payload = ::boost::shared_ptr< DisconnectError >
                (new DisconnectError(DBUS_ERROR_NO_SERVER, "The DBus service Interface is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Disconnect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<InterfaceProxy> proxyShared = ::boost::static_pointer_cast<InterfaceProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& InterfaceProxyCallback::_logger (InterfaceProxy::_logger);

InterfaceProxy::InterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "fi.w1.wpa_supplicant1.Interface", serviceAvailable, _logger) {
}

InterfaceProxy::~InterfaceProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< InterfaceProxy > InterfaceProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<InterfaceProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< InterfaceProxy > proxyNew(new InterfaceProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t InterfaceProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t InterfaceProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void InterfaceProxy::clearAllProperties ()
{
    _country = ::asf::core::nullable< CountryUpdate >();
    _disconnectReason = ::asf::core::nullable< DisconnectReasonUpdate >();
    _state = ::asf::core::nullable< StateUpdate >();
    _currentBSS = ::asf::core::nullable< CurrentBSSUpdate >();
}

void InterfaceProxy::sendDeregisterAll () const
{
    sendCountryDeregisterAll();
    sendDisconnectReasonDeregisterAll();
    sendStateDeregisterAll();
    sendCurrentBSSDeregisterAll();
    sendBSSAddedDeregisterAll();
    sendBSSRemovedDeregisterAll();
}

act_t InterfaceProxy::sendBSSAddedRegister(BSSAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BSSAdded");
    act_t act = addSignalCallback(ID_BSSAdded, "BSSAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BSSAdded", &cb, act);
    return act;
}

bool InterfaceProxy::sendBSSAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BSSAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BSSAdded", act, static_cast<int>(rv));
    return rv;
}

void InterfaceProxy::sendBSSAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BSSAdded");
    _dbusProxyDelegate->deregisterSignalCallback("BSSAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t InterfaceProxy::sendBSSRemovedRegister(BSSRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BSSRemoved");
    act_t act = addSignalCallback(ID_BSSRemoved, "BSSRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BSSRemoved", &cb, act);
    return act;
}

bool InterfaceProxy::sendBSSRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BSSRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BSSRemoved", act, static_cast<int>(rv));
    return rv;
}

void InterfaceProxy::sendBSSRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BSSRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("BSSRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t InterfaceProxy::sendCountryRegister(CountryCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Country, "Country", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Country", &cb, act);
    return act;
}

bool InterfaceProxy::sendCountryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Country", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Country", act, static_cast<int>(rv));
    return rv;
}

act_t InterfaceProxy::sendCountryGet(CountryCallbackIF& cb) {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(ID_Country, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Country", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Country", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void InterfaceProxy::sendCountrySet(const ::std::string& country) {
    CountrySet parameter(country);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Country");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Country", propertyContent);
}

act_t InterfaceProxy::sendCountrySet(CountryCallbackIF& cb, const ::std::string& country) {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(ID_Country, &cb);
    CountrySet parameter(country);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Country", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Country", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& InterfaceProxy::getCountry() const {
    return _country.get().getCountry();
}

bool InterfaceProxy::hasCountry() const {
    return _country.hasValue();
}

void InterfaceProxy::sendCountryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Country");
    _dbusProxyDelegate->deregisterSignalCallback("Country", 0, _dbusDaemonProxy.get(), true);
}

act_t InterfaceProxy::sendDisconnectReasonRegister(DisconnectReasonCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DisconnectReason, "DisconnectReason", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DisconnectReason", &cb, act);
    return act;
}

bool InterfaceProxy::sendDisconnectReasonDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DisconnectReason", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DisconnectReason", act, static_cast<int>(rv));
    return rv;
}

act_t InterfaceProxy::sendDisconnectReasonGet(DisconnectReasonCallbackIF& cb) {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(ID_DisconnectReason, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DisconnectReason", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DisconnectReason", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


int32 InterfaceProxy::getDisconnectReason() const {
    return _disconnectReason.get().getDisconnectReason();
}

bool InterfaceProxy::hasDisconnectReason() const {
    return _disconnectReason.hasValue();
}

void InterfaceProxy::sendDisconnectReasonDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DisconnectReason");
    _dbusProxyDelegate->deregisterSignalCallback("DisconnectReason", 0, _dbusDaemonProxy.get(), true);
}

act_t InterfaceProxy::sendStateRegister(StateCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_State, "State", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "State", &cb, act);
    return act;
}

bool InterfaceProxy::sendStateDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("State", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "State", act, static_cast<int>(rv));
    return rv;
}

act_t InterfaceProxy::sendStateGet(StateCallbackIF& cb) {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(ID_State, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "State", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("State", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& InterfaceProxy::getState() const {
    return _state.get().getState();
}

bool InterfaceProxy::hasState() const {
    return _state.hasValue();
}

void InterfaceProxy::sendStateDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "State");
    _dbusProxyDelegate->deregisterSignalCallback("State", 0, _dbusDaemonProxy.get(), true);
}

act_t InterfaceProxy::sendCurrentBSSRegister(CurrentBSSCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_CurrentBSS, "CurrentBSS", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CurrentBSS", &cb, act);
    return act;
}

bool InterfaceProxy::sendCurrentBSSDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CurrentBSS", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CurrentBSS", act, static_cast<int>(rv));
    return rv;
}

act_t InterfaceProxy::sendCurrentBSSGet(CurrentBSSCallbackIF& cb) {
    InterfaceProxyCallback* callback = new InterfaceProxyCallback(ID_CurrentBSS, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "CurrentBSS", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("CurrentBSS", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& InterfaceProxy::getCurrentBSS() const {
    return _currentBSS.get().getCurrentBSS();
}

bool InterfaceProxy::hasCurrentBSS() const {
    return _currentBSS.hasValue();
}

void InterfaceProxy::sendCurrentBSSDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CurrentBSS");
    _dbusProxyDelegate->deregisterSignalCallback("CurrentBSS", 0, _dbusDaemonProxy.get(), true);
}

act_t InterfaceProxy::sendScanRequest(ScanCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const {
    ScanRequest* payload = new ScanRequest();
    CHECK_ALLOCATION(payload);
    payload->setArgs(args);
    DBUS_MESSAGE_CALL(dbusMessage, "Scan", ScanRequest, payload, true)
    act_t act = addMethodCallback(ID_Scan, dbusMessage.getUniqueSerial(), "Scan", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Scan", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t InterfaceProxy::sendDisconnectRequest(DisconnectCallbackIF& cb) const {
    DisconnectRequest* payload = new DisconnectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Disconnect", DisconnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Disconnect, dbusMessage.getUniqueSerial(), "Disconnect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Disconnect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Interface
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi
