#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_W1_WPA_SUPPLICANT1_INTERFACE_H
#define FI_W1_WPA_SUPPLICANT1_INTERFACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "Interface" isn't clear, then there should be a description here.
 */

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace Interface {

// method IDs
static const uint16 ID_Scan = 0;
static const uint16 ID_Disconnect = 1;

// signal IDs
static const uint16 ID_BSSAdded = 2;
static const uint16 ID_BSSRemoved = 3;

// property IDs
static const uint16 ID_Country = 4;
static const uint16 ID_DisconnectReason = 5;
static const uint16 ID_State = 6;
static const uint16 ID_CurrentBSS = 7;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class ScanRequest;

class CountryUpdate;

class CountryRegister;

class DisconnectReasonUpdate;

class DisconnectReasonRegister;

class StateUpdate;

class StateRegister;

class CurrentBSSUpdate;

class CurrentBSSRegister;

class BSSAddedSignal;

class BSSRemovedSignal;

// type definitions
/**
 * If the meaning of "ScanResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ScanResponse;

/**
 * If the meaning of "ScanError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ScanError;

/**
 * If the meaning of "DisconnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectRequest;

/**
 * If the meaning of "DisconnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectResponse;

/**
 * If the meaning of "DisconnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectError;

/**
 * If the meaning of "CountrySet" isn't clear, then there should be a description here.
 */
typedef CountryUpdate CountrySet;

/**
 * If the meaning of "CountryGet" isn't clear, then there should be a description here.
 */
typedef CountryUpdate CountryGet;

/**
 * If the meaning of "CountryError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CountryError;

/**
 * If the meaning of "DisconnectReasonSet" isn't clear, then there should be a description here.
 */
typedef DisconnectReasonUpdate DisconnectReasonSet;

/**
 * If the meaning of "DisconnectReasonGet" isn't clear, then there should be a description here.
 */
typedef DisconnectReasonUpdate DisconnectReasonGet;

/**
 * If the meaning of "DisconnectReasonError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectReasonError;

/**
 * If the meaning of "StateSet" isn't clear, then there should be a description here.
 */
typedef StateUpdate StateSet;

/**
 * If the meaning of "StateGet" isn't clear, then there should be a description here.
 */
typedef StateUpdate StateGet;

/**
 * If the meaning of "StateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StateError;

/**
 * If the meaning of "CurrentBSSSet" isn't clear, then there should be a description here.
 */
typedef CurrentBSSUpdate CurrentBSSSet;

/**
 * If the meaning of "CurrentBSSGet" isn't clear, then there should be a description here.
 */
typedef CurrentBSSUpdate CurrentBSSGet;

/**
 * If the meaning of "CurrentBSSError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CurrentBSSError;

/**
 * If the meaning of "BSSAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BSSAddedError;

/**
 * If the meaning of "BSSRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BSSRemovedError;


/**
 * If the meaning of "ScanRequest" isn't clear, then there should be a description here.
 */
class ScanRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ScanRequest ();

    /**
     * Copy constructor
     */
    inline  ScanRequest (const ScanRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ScanRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    /**
     * Destructor
     */
    inline virtual  ~ScanRequest();

    /**
     * Assignment operator
     */
    inline ScanRequest& operator = (const ScanRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ScanRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ScanRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ScanRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ScanRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "args"

    static const int kArgs = 0;

    /**
     * Clears the field "args".
     *
     * The field will be set to its default value. The hasArgs()
     * method will return false.
     */
    inline void clearArgs();

    /**
     * Checks whether the field "args" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArgs()). Otherwise it will return false.
     */
    inline bool hasArgs () const;

    /**
     * Returns the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return The value of the field "args"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgs () const;

    /**
     * Retrieves the value of the field "args" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "args".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgsMutable ();

    /**
     * Sets the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @param args The value which will be set
     */
    inline void setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    static const ScanRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_args ();

    inline void clear_has_args ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _args;

};

/**
 * If the meaning of "CountryUpdate" isn't clear, then there should be a description here.
 */
class CountryUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CountryUpdate ();

    /**
     * Copy constructor
     */
    inline  CountryUpdate (const CountryUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CountryUpdate (const ::std::string& Country_);

    /**
     * Destructor
     */
    inline virtual  ~CountryUpdate();

    /**
     * Assignment operator
     */
    inline CountryUpdate& operator = (const CountryUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CountryUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CountryUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CountryUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CountryUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Country"

    static const int kCountry = 0;

    /**
     * Clears the field "Country".
     *
     * The field will be set to its default value. The hasCountry()
     * method will return false.
     */
    inline void clearCountry();

    /**
     * Checks whether the field "Country" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCountry()). Otherwise it will return false.
     */
    inline bool hasCountry () const;

    /**
     * Returns the value of the member "Country".
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Country"
     */
    inline const ::std::string& getCountry () const;

    /**
     * Retrieves the value of the field "Country" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Country".
     */
    inline ::std::string& getCountryMutable ();

    /**
     * Sets the value of the member "Country".
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param Country The value which will be set
     */
    inline void setCountry (const ::std::string& Country_);

    /**
     * Sets the value of the member "Country".
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param Country The value which will be set
     */
    inline void setCountry (const char* Country_);

    /**
     * Sets the value of the member "Country".
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param Country The value which will be set
     */
    inline void setCountry (const char* value, size_t size);

    static const CountryUpdate &getDefaultInstance();

private:

    inline void set_has_Country ();

    inline void clear_has_Country ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Country;

};

/**
 * If the meaning of "CountryRegister" isn't clear, then there should be a description here.
 */
class CountryRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CountryRegister ();

    /**
     * Copy constructor
     */
    inline  CountryRegister (const CountryRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CountryRegister();

    /**
     * Assignment operator
     */
    inline CountryRegister& operator = (const CountryRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CountryRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CountryRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CountryRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CountryRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CountryRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DisconnectReasonUpdate" isn't clear, then there should be a description here.
 */
class DisconnectReasonUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectReasonUpdate ();

    /**
     * Copy constructor
     */
    inline  DisconnectReasonUpdate (const DisconnectReasonUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DisconnectReasonUpdate (int32 DisconnectReason_);

    /**
     * Destructor
     */
    inline virtual  ~DisconnectReasonUpdate();

    /**
     * Assignment operator
     */
    inline DisconnectReasonUpdate& operator = (const DisconnectReasonUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectReasonUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectReasonUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectReasonUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectReasonUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DisconnectReason"

    static const int kDisconnectReason = 0;

    /**
     * Clears the field "DisconnectReason".
     *
     * The field will be set to its default value. The hasDisconnectReason()
     * method will return false.
     */
    inline void clearDisconnectReason();

    /**
     * Checks whether the field "DisconnectReason" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDisconnectReason()). Otherwise it will return false.
     */
    inline bool hasDisconnectReason () const;

    /**
     * Returns the value of the member "DisconnectReason".
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DisconnectReason"
     */
    inline int32 getDisconnectReason () const;

    /**
     * Sets the value of the member "DisconnectReason".
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     *
     * @param DisconnectReason The value which will be set
     */
    inline void setDisconnectReason (int32 DisconnectReason_);

    static const DisconnectReasonUpdate &getDefaultInstance();

private:

    inline void set_has_DisconnectReason ();

    inline void clear_has_DisconnectReason ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _DisconnectReason;

};

/**
 * If the meaning of "DisconnectReasonRegister" isn't clear, then there should be a description here.
 */
class DisconnectReasonRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisconnectReasonRegister ();

    /**
     * Copy constructor
     */
    inline  DisconnectReasonRegister (const DisconnectReasonRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DisconnectReasonRegister();

    /**
     * Assignment operator
     */
    inline DisconnectReasonRegister& operator = (const DisconnectReasonRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisconnectReasonRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisconnectReasonRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisconnectReasonRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisconnectReasonRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DisconnectReasonRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "StateUpdate" isn't clear, then there should be a description here.
 */
class StateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateUpdate ();

    /**
     * Copy constructor
     */
    inline  StateUpdate (const StateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StateUpdate (const ::std::string& State_);

    /**
     * Destructor
     */
    inline virtual  ~StateUpdate();

    /**
     * Assignment operator
     */
    inline StateUpdate& operator = (const StateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    static const StateUpdate &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _State;

};

/**
 * If the meaning of "StateRegister" isn't clear, then there should be a description here.
 */
class StateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateRegister ();

    /**
     * Copy constructor
     */
    inline  StateRegister (const StateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StateRegister();

    /**
     * Assignment operator
     */
    inline StateRegister& operator = (const StateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "CurrentBSSUpdate" isn't clear, then there should be a description here.
 */
class CurrentBSSUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentBSSUpdate ();

    /**
     * Copy constructor
     */
    inline  CurrentBSSUpdate (const CurrentBSSUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  CurrentBSSUpdate (const ::std::string& CurrentBSS_);

    /**
     * Destructor
     */
    inline virtual  ~CurrentBSSUpdate();

    /**
     * Assignment operator
     */
    inline CurrentBSSUpdate& operator = (const CurrentBSSUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentBSSUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentBSSUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentBSSUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentBSSUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "CurrentBSS"

    static const int kCurrentBSS = 0;

    /**
     * Clears the field "CurrentBSS".
     *
     * The field will be set to its default value. The hasCurrentBSS()
     * method will return false.
     */
    inline void clearCurrentBSS();

    /**
     * Checks whether the field "CurrentBSS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentBSS()). Otherwise it will return false.
     */
    inline bool hasCurrentBSS () const;

    /**
     * Returns the value of the member "CurrentBSS".
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @return The value of the field "CurrentBSS"
     */
    inline const ::std::string& getCurrentBSS () const;

    /**
     * Retrieves the value of the field "CurrentBSS" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentBSS".
     */
    inline ::std::string& getCurrentBSSMutable ();

    /**
     * Sets the value of the member "CurrentBSS".
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param CurrentBSS The value which will be set
     */
    inline void setCurrentBSS (const ::std::string& CurrentBSS_);

    /**
     * Sets the value of the member "CurrentBSS".
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param CurrentBSS The value which will be set
     */
    inline void setCurrentBSS (const char* CurrentBSS_);

    /**
     * Sets the value of the member "CurrentBSS".
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param CurrentBSS The value which will be set
     */
    inline void setCurrentBSS (const char* value, size_t size);

    static const CurrentBSSUpdate &getDefaultInstance();

private:

    inline void set_has_CurrentBSS ();

    inline void clear_has_CurrentBSS ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _CurrentBSS;

};

/**
 * If the meaning of "CurrentBSSRegister" isn't clear, then there should be a description here.
 */
class CurrentBSSRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CurrentBSSRegister ();

    /**
     * Copy constructor
     */
    inline  CurrentBSSRegister (const CurrentBSSRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~CurrentBSSRegister();

    /**
     * Assignment operator
     */
    inline CurrentBSSRegister& operator = (const CurrentBSSRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CurrentBSSRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CurrentBSSRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CurrentBSSRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CurrentBSSRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const CurrentBSSRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "BSSAddedSignal" isn't clear, then there should be a description here.
 */
class BSSAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BSSAddedSignal ();

    /**
     * Copy constructor
     */
    inline  BSSAddedSignal (const BSSAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BSSAddedSignal (const ::std::string& path_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~BSSAddedSignal();

    /**
     * Assignment operator
     */
    inline BSSAddedSignal& operator = (const BSSAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BSSAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BSSAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BSSAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BSSAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    // API of field "properties"

    static const int kProperties = 1;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const BSSAddedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_path ();

    inline void clear_has_path ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _path;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "BSSRemovedSignal" isn't clear, then there should be a description here.
 */
class BSSRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BSSRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  BSSRemovedSignal (const BSSRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BSSRemovedSignal (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~BSSRemovedSignal();

    /**
     * Assignment operator
     */
    inline BSSRemovedSignal& operator = (const BSSRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BSSRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BSSRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BSSRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BSSRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const BSSRemovedSignal &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

inline  ScanRequest::ScanRequest ()  :
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ScanRequest::ScanRequest (const ScanRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ScanRequest::ScanRequest (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_)  :
    _args (args_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ScanRequest::~ScanRequest() {
}

inline ScanRequest& ScanRequest::operator = (const ScanRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasArgs()) {
            setArgs(rhs.getArgs());
        } else {
            clearArgs();
        }
    }
    return *this;
}

inline bool ScanRequest::operator == (const ScanRequest& rhs) const {
    return (((!hasArgs() && !rhs.hasArgs()) || getArgs() == rhs.getArgs()));
}

inline bool ScanRequest::operator != (const ScanRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ScanRequest::operator < (const ScanRequest& rhs) const {
    if (hasArgs() || rhs.hasArgs()) {
        if (getArgs() < rhs.getArgs()) return true;
        if (getArgs() > rhs.getArgs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ScanRequest::clone() {
    return new ScanRequest(*this);
}

inline bool ScanRequest::operator > (const ScanRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ScanRequest::clear() {
    clearArgs();
}

inline void ScanRequest::clearArgs() {
    if (hasArgs()) {
         clear_has_args();
        _args.clear();
     }
}

inline bool ScanRequest::hasArgs () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ScanRequest::getArgs () const {
    return _args;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& ScanRequest::getArgsMutable () {
    set_has_args();
    return _args;
}

inline void ScanRequest::setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_) {
    set_has_args();
    this->_args = args_;
}

inline void ScanRequest::set_has_args () {
    _has_bits_[0] |= 1u << 0;
}

inline void ScanRequest::clear_has_args () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CountryUpdate::CountryUpdate ()  :
    _Country ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CountryUpdate::CountryUpdate (const CountryUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Country ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CountryUpdate::CountryUpdate (const ::std::string& Country_)  :
    _Country (Country_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Country_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CountryUpdate::~CountryUpdate() {
}

inline CountryUpdate& CountryUpdate::operator = (const CountryUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCountry()) {
            setCountry(rhs.getCountry());
        } else {
            clearCountry();
        }
    }
    return *this;
}

inline bool CountryUpdate::operator == (const CountryUpdate& rhs) const {
    return (((!hasCountry() && !rhs.hasCountry()) || getCountry() == rhs.getCountry()));
}

inline bool CountryUpdate::operator != (const CountryUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CountryUpdate::operator < (const CountryUpdate& rhs) const {
    if (hasCountry() || rhs.hasCountry()) {
        if (getCountry() < rhs.getCountry()) return true;
        if (getCountry() > rhs.getCountry()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CountryUpdate::clone() {
    return new CountryUpdate(*this);
}

inline bool CountryUpdate::operator > (const CountryUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CountryUpdate::clear() {
    clearCountry();
}

inline void CountryUpdate::clearCountry() {
    if (hasCountry()) {
         clear_has_Country();
        _Country.clear();
     }
}

inline bool CountryUpdate::hasCountry () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CountryUpdate::getCountry () const {
    return _Country;
}

inline ::std::string& CountryUpdate::getCountryMutable () {
    set_has_Country();
    return _Country;
}

inline void CountryUpdate::setCountry (const ::std::string& Country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Country_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Country();
    this->_Country = Country_;
}

inline void CountryUpdate::setCountry (const char* Country_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Country_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Country();
    this->_Country.assign(Country_);
}

inline void CountryUpdate::setCountry (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Country();
    this->_Country.assign(value, size);
}

inline void CountryUpdate::set_has_Country () {
    _has_bits_[0] |= 1u << 0;
}

inline void CountryUpdate::clear_has_Country () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CountryRegister::CountryRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CountryRegister::CountryRegister (const CountryRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CountryRegister::~CountryRegister() {
}

inline CountryRegister& CountryRegister::operator = (const CountryRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CountryRegister::operator == (const CountryRegister& ) const {
    return true;
}

inline bool CountryRegister::operator != (const CountryRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CountryRegister::operator < (const CountryRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CountryRegister::clone() {
    return new CountryRegister(*this);
}

inline bool CountryRegister::operator > (const CountryRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CountryRegister::clear() {
}

inline  DisconnectReasonUpdate::DisconnectReasonUpdate ()  :
    _DisconnectReason (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisconnectReasonUpdate::DisconnectReasonUpdate (const DisconnectReasonUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DisconnectReason (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisconnectReasonUpdate::DisconnectReasonUpdate (int32 DisconnectReason_)  :
    _DisconnectReason (DisconnectReason_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisconnectReasonUpdate::~DisconnectReasonUpdate() {
}

inline DisconnectReasonUpdate& DisconnectReasonUpdate::operator = (const DisconnectReasonUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDisconnectReason()) {
            setDisconnectReason(rhs.getDisconnectReason());
        } else {
            clearDisconnectReason();
        }
    }
    return *this;
}

inline bool DisconnectReasonUpdate::operator == (const DisconnectReasonUpdate& rhs) const {
    return (((!hasDisconnectReason() && !rhs.hasDisconnectReason()) || getDisconnectReason() == rhs.getDisconnectReason()));
}

inline bool DisconnectReasonUpdate::operator != (const DisconnectReasonUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DisconnectReasonUpdate::operator < (const DisconnectReasonUpdate& rhs) const {
    if (hasDisconnectReason() || rhs.hasDisconnectReason()) {
        if (getDisconnectReason() < rhs.getDisconnectReason()) return true;
        if (getDisconnectReason() > rhs.getDisconnectReason()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisconnectReasonUpdate::clone() {
    return new DisconnectReasonUpdate(*this);
}

inline bool DisconnectReasonUpdate::operator > (const DisconnectReasonUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisconnectReasonUpdate::clear() {
    clearDisconnectReason();
}

inline void DisconnectReasonUpdate::clearDisconnectReason() {
    if (hasDisconnectReason()) {
         clear_has_DisconnectReason();
        _DisconnectReason = 0;
     }
}

inline bool DisconnectReasonUpdate::hasDisconnectReason () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 DisconnectReasonUpdate::getDisconnectReason () const {
    return _DisconnectReason;
}

inline void DisconnectReasonUpdate::setDisconnectReason (int32 DisconnectReason_) {
    set_has_DisconnectReason();
    this->_DisconnectReason = DisconnectReason_;
}

inline void DisconnectReasonUpdate::set_has_DisconnectReason () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisconnectReasonUpdate::clear_has_DisconnectReason () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisconnectReasonRegister::DisconnectReasonRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisconnectReasonRegister::DisconnectReasonRegister (const DisconnectReasonRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisconnectReasonRegister::~DisconnectReasonRegister() {
}

inline DisconnectReasonRegister& DisconnectReasonRegister::operator = (const DisconnectReasonRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DisconnectReasonRegister::operator == (const DisconnectReasonRegister& ) const {
    return true;
}

inline bool DisconnectReasonRegister::operator != (const DisconnectReasonRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DisconnectReasonRegister::operator < (const DisconnectReasonRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DisconnectReasonRegister::clone() {
    return new DisconnectReasonRegister(*this);
}

inline bool DisconnectReasonRegister::operator > (const DisconnectReasonRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisconnectReasonRegister::clear() {
}

inline  StateUpdate::StateUpdate ()  :
    _State ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StateUpdate::StateUpdate (const StateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _State ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StateUpdate::StateUpdate (const ::std::string& State_)  :
    _State (State_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StateUpdate::~StateUpdate() {
}

inline StateUpdate& StateUpdate::operator = (const StateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
    }
    return *this;
}

inline bool StateUpdate::operator == (const StateUpdate& rhs) const {
    return (((!hasState() && !rhs.hasState()) || getState() == rhs.getState()));
}

inline bool StateUpdate::operator != (const StateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StateUpdate::operator < (const StateUpdate& rhs) const {
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StateUpdate::clone() {
    return new StateUpdate(*this);
}

inline bool StateUpdate::operator > (const StateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StateUpdate::clear() {
    clearState();
}

inline void StateUpdate::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool StateUpdate::hasState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StateUpdate::getState () const {
    return _State;
}

inline ::std::string& StateUpdate::getStateMutable () {
    set_has_State();
    return _State;
}

inline void StateUpdate::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void StateUpdate::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void StateUpdate::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void StateUpdate::set_has_State () {
    _has_bits_[0] |= 1u << 0;
}

inline void StateUpdate::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StateRegister::StateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StateRegister::StateRegister (const StateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StateRegister::~StateRegister() {
}

inline StateRegister& StateRegister::operator = (const StateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StateRegister::operator == (const StateRegister& ) const {
    return true;
}

inline bool StateRegister::operator != (const StateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StateRegister::operator < (const StateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StateRegister::clone() {
    return new StateRegister(*this);
}

inline bool StateRegister::operator > (const StateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StateRegister::clear() {
}

inline  CurrentBSSUpdate::CurrentBSSUpdate ()  :
    _CurrentBSS ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentBSSUpdate::CurrentBSSUpdate (const CurrentBSSUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _CurrentBSS ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentBSSUpdate::CurrentBSSUpdate (const ::std::string& CurrentBSS_)  :
    _CurrentBSS (CurrentBSS_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentBSS_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CurrentBSSUpdate::~CurrentBSSUpdate() {
}

inline CurrentBSSUpdate& CurrentBSSUpdate::operator = (const CurrentBSSUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCurrentBSS()) {
            setCurrentBSS(rhs.getCurrentBSS());
        } else {
            clearCurrentBSS();
        }
    }
    return *this;
}

inline bool CurrentBSSUpdate::operator == (const CurrentBSSUpdate& rhs) const {
    return (((!hasCurrentBSS() && !rhs.hasCurrentBSS()) || getCurrentBSS() == rhs.getCurrentBSS()));
}

inline bool CurrentBSSUpdate::operator != (const CurrentBSSUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentBSSUpdate::operator < (const CurrentBSSUpdate& rhs) const {
    if (hasCurrentBSS() || rhs.hasCurrentBSS()) {
        if (getCurrentBSS() < rhs.getCurrentBSS()) return true;
        if (getCurrentBSS() > rhs.getCurrentBSS()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CurrentBSSUpdate::clone() {
    return new CurrentBSSUpdate(*this);
}

inline bool CurrentBSSUpdate::operator > (const CurrentBSSUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentBSSUpdate::clear() {
    clearCurrentBSS();
}

inline void CurrentBSSUpdate::clearCurrentBSS() {
    if (hasCurrentBSS()) {
         clear_has_CurrentBSS();
        _CurrentBSS.clear();
     }
}

inline bool CurrentBSSUpdate::hasCurrentBSS () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CurrentBSSUpdate::getCurrentBSS () const {
    return _CurrentBSS;
}

inline ::std::string& CurrentBSSUpdate::getCurrentBSSMutable () {
    set_has_CurrentBSS();
    return _CurrentBSS;
}

inline void CurrentBSSUpdate::setCurrentBSS (const ::std::string& CurrentBSS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentBSS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentBSS();
    this->_CurrentBSS = CurrentBSS_;
}

inline void CurrentBSSUpdate::setCurrentBSS (const char* CurrentBSS_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentBSS_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentBSS();
    this->_CurrentBSS.assign(CurrentBSS_);
}

inline void CurrentBSSUpdate::setCurrentBSS (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentBSS();
    this->_CurrentBSS.assign(value, size);
}

inline void CurrentBSSUpdate::set_has_CurrentBSS () {
    _has_bits_[0] |= 1u << 0;
}

inline void CurrentBSSUpdate::clear_has_CurrentBSS () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CurrentBSSRegister::CurrentBSSRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CurrentBSSRegister::CurrentBSSRegister (const CurrentBSSRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CurrentBSSRegister::~CurrentBSSRegister() {
}

inline CurrentBSSRegister& CurrentBSSRegister::operator = (const CurrentBSSRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool CurrentBSSRegister::operator == (const CurrentBSSRegister& ) const {
    return true;
}

inline bool CurrentBSSRegister::operator != (const CurrentBSSRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool CurrentBSSRegister::operator < (const CurrentBSSRegister& ) const {
    return false;
}

inline ::asf::core::Payload* CurrentBSSRegister::clone() {
    return new CurrentBSSRegister(*this);
}

inline bool CurrentBSSRegister::operator > (const CurrentBSSRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CurrentBSSRegister::clear() {
}

inline  BSSAddedSignal::BSSAddedSignal ()  :
    _path (),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BSSAddedSignal::BSSAddedSignal (const BSSAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _path (),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BSSAddedSignal::BSSAddedSignal (const ::std::string& path_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _path (path_),
    _properties (properties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BSSAddedSignal::~BSSAddedSignal() {
}

inline BSSAddedSignal& BSSAddedSignal::operator = (const BSSAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool BSSAddedSignal::operator == (const BSSAddedSignal& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()) &&
        ((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool BSSAddedSignal::operator != (const BSSAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BSSAddedSignal::operator < (const BSSAddedSignal& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BSSAddedSignal::clone() {
    return new BSSAddedSignal(*this);
}

inline bool BSSAddedSignal::operator > (const BSSAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BSSAddedSignal::clear() {
    clearPath();
    clearProperties();
}

inline void BSSAddedSignal::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool BSSAddedSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BSSAddedSignal::getPath () const {
    return _path;
}

inline ::std::string& BSSAddedSignal::getPathMutable () {
    set_has_path();
    return _path;
}

inline void BSSAddedSignal::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void BSSAddedSignal::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void BSSAddedSignal::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void BSSAddedSignal::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool BSSAddedSignal::hasProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& BSSAddedSignal::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& BSSAddedSignal::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void BSSAddedSignal::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void BSSAddedSignal::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void BSSAddedSignal::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void BSSAddedSignal::set_has_properties () {
    _has_bits_[0] |= 1u << 1;
}

inline void BSSAddedSignal::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  BSSRemovedSignal::BSSRemovedSignal ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BSSRemovedSignal::BSSRemovedSignal (const BSSRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BSSRemovedSignal::BSSRemovedSignal (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BSSRemovedSignal::~BSSRemovedSignal() {
}

inline BSSRemovedSignal& BSSRemovedSignal::operator = (const BSSRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool BSSRemovedSignal::operator == (const BSSRemovedSignal& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool BSSRemovedSignal::operator != (const BSSRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BSSRemovedSignal::operator < (const BSSRemovedSignal& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BSSRemovedSignal::clone() {
    return new BSSRemovedSignal(*this);
}

inline bool BSSRemovedSignal::operator > (const BSSRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BSSRemovedSignal::clear() {
    clearPath();
}

inline void BSSRemovedSignal::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool BSSRemovedSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& BSSRemovedSignal::getPath () const {
    return _path;
}

inline ::std::string& BSSRemovedSignal::getPathMutable () {
    set_has_path();
    return _path;
}

inline void BSSRemovedSignal::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void BSSRemovedSignal::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void BSSRemovedSignal::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void BSSRemovedSignal::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void BSSRemovedSignal::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Interface
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi

#endif // FI_W1_WPA_SUPPLICANT1_INTERFACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
