/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1/BSS.h"
#include "fi/w1/wpa_supplicant1/BSSDBus.h"
#include "fi/w1/wpa_supplicant1/BSSJson.h"
#include "fi/w1/wpa_supplicant1/BSSStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace BSS {

DEFINE_CLASS_LOGGER("//fi/w1/wpa_supplicant1/Interfaces/XX/BSSs/XXX/fi/w1/wpa_supplicant1/BSS", BSSStub);


static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 3, "IEs", 0 },
};

class BSSStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    BSSStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    BSSStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    BSSStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "fi.w1.wpa_supplicant1.BSS"),
          _logger(logger) {}

    virtual ~BSSStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void BSSStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* BSSStubDelegate::introspect() const {
    return     "<interface name=\"fi.w1.wpa_supplicant1.BSS\">\n"
            "      <property access=\"read\" name=\"IEs\" type=\"ay\"/>\n"
            "</interface>\n";
}

void BSSStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<BSSStub*>(getStub()))->onGetAll (properties);
}

void BSSStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "IEs");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void BSSStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "IEs");
            ::boost::shared_ptr< IEsGet > payload(new IEsGet());
            payload->setAct(act);
            static_cast<BSSStub*>(getStub())->onIEsGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

BSSStub::BSSStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new BSSStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

BSSStub::BSSStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new BSSStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

BSSStub::~BSSStub() {
    delete _stubDelegate;
}

void BSSStub::sendIEsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IEsUpdate payload(_IEsProperty);

        LOG_INFO ("-> send%s", "IEsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("IEs", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("fi.w1.wpa_supplicant1.BSS", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IEsUpdate");
    }
}

void BSSStub::onIEsGet(const ::boost::shared_ptr< IEsGet >& iEs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IEsGet", iEs->getAct());
    sendIEsGetUpdate(_IEsProperty.getIEs(), iEs->getAct());
}

void BSSStub::sendIEsGetUpdate(const ::std::vector< uint8 >& iEs, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IEsGet payload(iEs);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IEsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void BSSStub::setIEs(const ::std::vector< uint8 >& iEs) {
    if(iEs!=_IEsProperty.getIEs()) {
        _IEsProperty.setIEs(iEs);
        sendIEsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& BSSStub::getIEs() const {
    return _IEsProperty.getIEs();
}

::std::vector< uint8 >& BSSStub::getIEsMutable() {
    return _IEsProperty.getIEsMutable();
}

void BSSStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'IEs'
    {
        ::asf::dbus::DBusVariant variant;
        IEsGet payload(_IEsProperty.getIEs());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("IEs", variant));
    }
}

} // namespace BSS
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi
