/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "objmgr/org/freedesktop/DBus/ObjectManager.h"
#include "objmgr/org/freedesktop/DBus/ObjectManagerDBus.h"
#include "objmgr/org/freedesktop/DBus/ObjectManagerJson.h"
#include "objmgr/org/freedesktop/DBus/ObjectManagerStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace objmgr {
namespace org {
namespace freedesktop {
namespace DBus {
namespace ObjectManager {

DEFINE_CLASS_LOGGER("///org/freedesktop/DBus/ObjectManager", ObjectManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 17, "GetManagedObjects", 0 },
};


class ObjectManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ObjectManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ObjectManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ObjectManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.DBus.ObjectManager"),
          _logger(logger) {}

    virtual ~ObjectManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ObjectManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetManagedObjects'

            LOG_DEBUG_STUB("process method '%s'", "GetManagedObjects");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetManagedObjectsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetManagedObjects", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetManagedObjectsRequest > payload = ::boost::static_pointer_cast<GetManagedObjectsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ObjectManagerStub*>(getStub())->onGetManagedObjectsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ObjectManagerStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.DBus.ObjectManager\">\n"
            "      <method name=\"GetManagedObjects\">\n"
            "        <annotation name=\"org.freedesktop.DBus.GLib.Async\" value=\"yes\"/>\n"
            "        <arg direction=\"out\" name=\"objects\" type=\"a{oa{sa{sv}}}\"/>\n"
            "      </method>\n"
            "      <signal name=\"InterfacesAdded\">\n"
            "        <arg name=\"object\" type=\"o\"/>\n"
            "        <arg name=\"interfaces\" type=\"a{sa{sv}}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"InterfacesRemoved\">\n"
            "        <arg name=\"object\" type=\"o\"/>\n"
            "        <arg name=\"interfaces\" type=\"as\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ObjectManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ObjectManagerStub*>(getStub()))->onGetAll (properties);
}

void ObjectManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ObjectManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ObjectManagerStub::ObjectManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ObjectManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ObjectManagerStub::ObjectManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ObjectManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ObjectManagerStub::~ObjectManagerStub() {
    delete _stubDelegate;
}

void ObjectManagerStub::sendInterfacesAddedSignal(const ::std::string& object, const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& interfaces) {
    if (_stubDelegate->isConnected()) {
        InterfacesAddedSignal* payload = new InterfacesAddedSignal(object, interfaces);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "InterfacesAdded", InterfacesAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "InterfacesAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "InterfacesAdded");
    }
}

void ObjectManagerStub::sendInterfacesRemovedSignal(const ::std::string& object, const ::std::vector< ::std::string >& interfaces) {
    if (_stubDelegate->isConnected()) {
        InterfacesRemovedSignal* payload = new InterfacesRemovedSignal(object, interfaces);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "InterfacesRemoved", InterfacesRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "InterfacesRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "InterfacesRemoved");
    }
}

void  ObjectManagerStub::sendGetManagedObjectsResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& objects, act_t act) {
    GetManagedObjectsResponse* payload = new GetManagedObjectsResponse(objects);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetManagedObjects", GetManagedObjectsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetManagedObjects", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ObjectManagerStub::sendGetManagedObjectsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetManagedObjectsError* payload = new GetManagedObjectsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetManagedObjects", GetManagedObjectsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetManagedObjects", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ObjectManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace ObjectManager
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace objmgr
