/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "objmgr/org/freedesktop/DBus/ObjectManager.h"
#include "objmgr/org/freedesktop/DBus/ObjectManagerDBus.h"
#include "objmgr/org/freedesktop/DBus/ObjectManagerJson.h"
#include "objmgr/org/freedesktop/DBus/ObjectManagerProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace objmgr {
namespace org {
namespace freedesktop {
namespace DBus {
namespace ObjectManager {

DEFINE_CLASS_LOGGER("///org/freedesktop/DBus/ObjectManager", ObjectManagerProxy);

class ObjectManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ObjectManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ObjectManagerProxy >& proxyShared = ::boost::static_pointer_cast< ObjectManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_InterfacesAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfacesAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InterfacesAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<InterfacesAddedSignal> payload = ::boost::static_pointer_cast<InterfacesAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((InterfacesAddedCallbackIF*) _callback)->onInterfacesAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_InterfacesRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfacesRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InterfacesRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<InterfacesRemovedSignal> payload = ::boost::static_pointer_cast<InterfacesRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((InterfacesRemovedCallbackIF*) _callback)->onInterfacesRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetManagedObjects:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetManagedObjectsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetManagedObjects", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetManagedObjectsError> payload = ::boost::static_pointer_cast<GetManagedObjectsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetManagedObjectsCallbackIF*) _callback)->onGetManagedObjectsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetManagedObjectsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetManagedObjects", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetManagedObjectsResponse> payload = ::boost::static_pointer_cast<GetManagedObjectsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetManagedObjectsCallbackIF*) _callback)->onGetManagedObjectsResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_InterfacesAdded: {
                ::boost::shared_ptr< InterfacesAddedError > payload = ::boost::shared_ptr< InterfacesAddedError >
                (new InterfacesAddedError(DBUS_ERROR_NO_SERVER, "The DBus service ObjectManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InterfacesAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ObjectManagerProxy> proxyShared = ::boost::static_pointer_cast<ObjectManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfacesAddedCallbackIF*) _callback)->onInterfacesAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InterfacesRemoved: {
                ::boost::shared_ptr< InterfacesRemovedError > payload = ::boost::shared_ptr< InterfacesRemovedError >
                (new InterfacesRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service ObjectManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InterfacesRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ObjectManagerProxy> proxyShared = ::boost::static_pointer_cast<ObjectManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfacesRemovedCallbackIF*) _callback)->onInterfacesRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetManagedObjects: {
                ::boost::shared_ptr< GetManagedObjectsError > payload = ::boost::shared_ptr< GetManagedObjectsError >
                (new GetManagedObjectsError(DBUS_ERROR_NO_SERVER, "The DBus service ObjectManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetManagedObjects", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ObjectManagerProxy> proxyShared = ::boost::static_pointer_cast<ObjectManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetManagedObjectsCallbackIF*) _callback)->onGetManagedObjectsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ObjectManagerProxyCallback::_logger (ObjectManagerProxy::_logger);

ObjectManagerProxy::ObjectManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.freedesktop.DBus.ObjectManager", serviceAvailable, _logger) {
}

ObjectManagerProxy::~ObjectManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ObjectManagerProxy > ObjectManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ObjectManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ObjectManagerProxy > proxyNew(new ObjectManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ObjectManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ObjectManagerProxyCallback* callback = new ObjectManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ObjectManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ObjectManagerProxyCallback* callback = new ObjectManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void ObjectManagerProxy::sendDeregisterAll () const
{
    sendInterfacesAddedDeregisterAll();
    sendInterfacesRemovedDeregisterAll();
}

act_t ObjectManagerProxy::sendInterfacesAddedRegister(InterfacesAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "InterfacesAdded");
    act_t act = addSignalCallback(ID_InterfacesAdded, "InterfacesAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InterfacesAdded", &cb, act);
    return act;
}

bool ObjectManagerProxy::sendInterfacesAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InterfacesAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InterfacesAdded", act, static_cast<int>(rv));
    return rv;
}

void ObjectManagerProxy::sendInterfacesAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InterfacesAdded");
    _dbusProxyDelegate->deregisterSignalCallback("InterfacesAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t ObjectManagerProxy::sendInterfacesRemovedRegister(InterfacesRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "InterfacesRemoved");
    act_t act = addSignalCallback(ID_InterfacesRemoved, "InterfacesRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InterfacesRemoved", &cb, act);
    return act;
}

bool ObjectManagerProxy::sendInterfacesRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InterfacesRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InterfacesRemoved", act, static_cast<int>(rv));
    return rv;
}

void ObjectManagerProxy::sendInterfacesRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InterfacesRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("InterfacesRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ObjectManagerProxy::sendGetManagedObjectsRequest(GetManagedObjectsCallbackIF& cb) const {
    GetManagedObjectsRequest* payload = new GetManagedObjectsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetManagedObjects", GetManagedObjectsRequest, payload, true)
    act_t act = addMethodCallback(ID_GetManagedObjects, dbusMessage.getUniqueSerial(), "GetManagedObjects", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetManagedObjects", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace ObjectManager
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace objmgr
