#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGER_H
#define OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "ObjectManager" isn't clear, then there should be a description here.
 */

namespace objmgr {
namespace org {
namespace freedesktop {
namespace DBus {
namespace ObjectManager {

// method IDs
static const uint16 ID_GetManagedObjects = 0;

// signal IDs
static const uint16 ID_InterfacesAdded = 1;
static const uint16 ID_InterfacesRemoved = 2;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetManagedObjectsResponse;

class InterfacesAddedSignal;

class InterfacesRemovedSignal;

// type definitions
/**
 * If the meaning of "GetManagedObjectsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetManagedObjectsRequest;

/**
 * If the meaning of "GetManagedObjectsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetManagedObjectsError;

/**
 * If the meaning of "InterfacesAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InterfacesAddedError;

/**
 * If the meaning of "InterfacesRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InterfacesRemovedError;


/**
 * If the meaning of "GetManagedObjectsResponse" isn't clear, then there should be a description here.
 */
class GetManagedObjectsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetManagedObjectsResponse ();

    /**
     * Copy constructor
     */
    inline  GetManagedObjectsResponse (const GetManagedObjectsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetManagedObjectsResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& objects_);

    /**
     * Destructor
     */
    inline virtual  ~GetManagedObjectsResponse();

    /**
     * Assignment operator
     */
    inline GetManagedObjectsResponse& operator = (const GetManagedObjectsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetManagedObjectsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetManagedObjectsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetManagedObjectsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetManagedObjectsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "objects"

    static const int kObjects = 0;

    /**
     * Clears the field "objects".
     *
     * The field will be set to its default value. The hasObjects()
     * method will return false.
     */
    inline void clearObjects();

    /**
     * Checks whether the field "objects" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObjects()). Otherwise it will return false.
     */
    inline bool hasObjects () const;

    /**
     * Returns the value of the member "objects".
     *
     * If the meaning of "objects" isn't clear, then there should be a description here.
     *
     * @return The value of the field "objects"
     */
    inline const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& getObjects () const;

    /**
     * Retrieves the value of the field "objects" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "objects".
     */
    inline ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& getObjectsMutable ();

    /**
     * Sets the value of the member "objects".
     *
     * If the meaning of "objects" isn't clear, then there should be a description here.
     *
     * @param objects The value which will be set
     */
    inline void setObjects (const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& objects_);

    static const GetManagedObjectsResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& getStringToStringToStringTo__asf__dbus__DBusVariantMap_Map_Map_DefaultInstance ();

    inline void set_has_objects ();

    inline void clear_has_objects ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > > _objects;

};

/**
 * If the meaning of "InterfacesAddedSignal" isn't clear, then there should be a description here.
 */
class InterfacesAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InterfacesAddedSignal ();

    /**
     * Copy constructor
     */
    inline  InterfacesAddedSignal (const InterfacesAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  InterfacesAddedSignal (const ::std::string& object_, const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& interfaces_);

    /**
     * Destructor
     */
    inline virtual  ~InterfacesAddedSignal();

    /**
     * Assignment operator
     */
    inline InterfacesAddedSignal& operator = (const InterfacesAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InterfacesAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InterfacesAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InterfacesAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InterfacesAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "object"

    static const int kObject = 0;

    /**
     * Clears the field "object".
     *
     * The field will be set to its default value. The hasObject()
     * method will return false.
     */
    inline void clearObject();

    /**
     * Checks whether the field "object" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObject()). Otherwise it will return false.
     */
    inline bool hasObject () const;

    /**
     * Returns the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @return The value of the field "object"
     */
    inline const ::std::string& getObject () const;

    /**
     * Retrieves the value of the field "object" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "object".
     */
    inline ::std::string& getObjectMutable ();

    /**
     * Sets the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @param object The value which will be set
     */
    inline void setObject (const ::std::string& object_);

    /**
     * Sets the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @param object The value which will be set
     */
    inline void setObject (const char* object_);

    /**
     * Sets the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @param object The value which will be set
     */
    inline void setObject (const char* value, size_t size);

    // API of field "interfaces"

    static const int kInterfaces = 1;

    /**
     * Clears the field "interfaces".
     *
     * The field will be set to its default value. The hasInterfaces()
     * method will return false.
     */
    inline void clearInterfaces();

    /**
     * Checks whether the field "interfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterfaces()). Otherwise it will return false.
     */
    inline bool hasInterfaces () const;

    /**
     * Returns the value of the member "interfaces".
     *
     * If the meaning of "interfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interfaces"
     */
    inline const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getInterfaces () const;

    /**
     * Retrieves the value of the field "interfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interfaces".
     */
    inline ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getInterfacesMutable ();

    /**
     * Sets the value of the member "interfaces".
     *
     * If the meaning of "interfaces" isn't clear, then there should be a description here.
     *
     * @param interfaces The value which will be set
     */
    inline void setInterfaces (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& interfaces_);

    static const InterfacesAddedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& getStringToStringTo__asf__dbus__DBusVariantMap_Map_DefaultInstance ();

    inline void set_has_object ();

    inline void clear_has_object ();

    inline void set_has_interfaces ();

    inline void clear_has_interfaces ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _object;

    ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > _interfaces;

};

/**
 * If the meaning of "InterfacesRemovedSignal" isn't clear, then there should be a description here.
 */
class InterfacesRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InterfacesRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  InterfacesRemovedSignal (const InterfacesRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  InterfacesRemovedSignal (const ::std::string& object_, const ::std::vector< ::std::string >& interfaces_);

    /**
     * Destructor
     */
    inline virtual  ~InterfacesRemovedSignal();

    /**
     * Assignment operator
     */
    inline InterfacesRemovedSignal& operator = (const InterfacesRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InterfacesRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InterfacesRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InterfacesRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InterfacesRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "object"

    static const int kObject = 0;

    /**
     * Clears the field "object".
     *
     * The field will be set to its default value. The hasObject()
     * method will return false.
     */
    inline void clearObject();

    /**
     * Checks whether the field "object" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setObject()). Otherwise it will return false.
     */
    inline bool hasObject () const;

    /**
     * Returns the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @return The value of the field "object"
     */
    inline const ::std::string& getObject () const;

    /**
     * Retrieves the value of the field "object" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "object".
     */
    inline ::std::string& getObjectMutable ();

    /**
     * Sets the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @param object The value which will be set
     */
    inline void setObject (const ::std::string& object_);

    /**
     * Sets the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @param object The value which will be set
     */
    inline void setObject (const char* object_);

    /**
     * Sets the value of the member "object".
     *
     * If the meaning of "object" isn't clear, then there should be a description here.
     *
     * @param object The value which will be set
     */
    inline void setObject (const char* value, size_t size);

    // API of field "interfaces"

    static const int kInterfaces = 1;

    /**
     * Clears the field "interfaces".
     *
     * The field will be set to its default value. The hasInterfaces()
     * method will return false.
     */
    inline void clearInterfaces();

    /**
     * Checks whether the field "interfaces" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInterfaces()). Otherwise it will return false.
     */
    inline bool hasInterfaces () const;

    /**
     * Returns the value of the member "interfaces".
     *
     * If the meaning of "interfaces" isn't clear, then there should be a description here.
     *
     * @return The value of the field "interfaces"
     */
    inline const ::std::vector< ::std::string >& getInterfaces () const;

    /**
     * Retrieves the value of the field "interfaces" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "interfaces".
     */
    inline ::std::vector< ::std::string >& getInterfacesMutable ();

    /**
     * Sets the value of the member "interfaces".
     *
     * If the meaning of "interfaces" isn't clear, then there should be a description here.
     *
     * @param interfaces The value which will be set
     */
    inline void setInterfaces (const ::std::vector< ::std::string >& interfaces_);

    static const InterfacesRemovedSignal &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_object ();

    inline void clear_has_object ();

    inline void set_has_interfaces ();

    inline void clear_has_interfaces ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _object;

    ::std::vector< ::std::string > _interfaces;

};

inline  GetManagedObjectsResponse::GetManagedObjectsResponse ()  :
    _objects ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetManagedObjectsResponse::GetManagedObjectsResponse (const GetManagedObjectsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _objects ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetManagedObjectsResponse::GetManagedObjectsResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& objects_)  :
    _objects (objects_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetManagedObjectsResponse::~GetManagedObjectsResponse() {
}

inline GetManagedObjectsResponse& GetManagedObjectsResponse::operator = (const GetManagedObjectsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasObjects()) {
            setObjects(rhs.getObjects());
        } else {
            clearObjects();
        }
    }
    return *this;
}

inline bool GetManagedObjectsResponse::operator == (const GetManagedObjectsResponse& rhs) const {
    return (((!hasObjects() && !rhs.hasObjects()) || getObjects() == rhs.getObjects()));
}

inline bool GetManagedObjectsResponse::operator != (const GetManagedObjectsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetManagedObjectsResponse::operator < (const GetManagedObjectsResponse& rhs) const {
    if (hasObjects() || rhs.hasObjects()) {
        if (getObjects() < rhs.getObjects()) return true;
        if (getObjects() > rhs.getObjects()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetManagedObjectsResponse::clone() {
    return new GetManagedObjectsResponse(*this);
}

inline bool GetManagedObjectsResponse::operator > (const GetManagedObjectsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetManagedObjectsResponse::clear() {
    clearObjects();
}

inline void GetManagedObjectsResponse::clearObjects() {
    if (hasObjects()) {
         clear_has_objects();
        _objects.clear();
     }
}

inline bool GetManagedObjectsResponse::hasObjects () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& GetManagedObjectsResponse::getObjects () const {
    return _objects;
}

inline ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& GetManagedObjectsResponse::getObjectsMutable () {
    set_has_objects();
    return _objects;
}

inline void GetManagedObjectsResponse::setObjects (const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& objects_) {
    set_has_objects();
    this->_objects = objects_;
}

inline void GetManagedObjectsResponse::set_has_objects () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetManagedObjectsResponse::clear_has_objects () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InterfacesAddedSignal::InterfacesAddedSignal ()  :
    _object (),
    _interfaces ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InterfacesAddedSignal::InterfacesAddedSignal (const InterfacesAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _object (),
    _interfaces ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InterfacesAddedSignal::InterfacesAddedSignal (const ::std::string& object_, const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& interfaces_)  :
    _object (object_),
    _interfaces (interfaces_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (object_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InterfacesAddedSignal::~InterfacesAddedSignal() {
}

inline InterfacesAddedSignal& InterfacesAddedSignal::operator = (const InterfacesAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasObject()) {
            setObject(rhs.getObject());
        } else {
            clearObject();
        }
        if (rhs.hasInterfaces()) {
            setInterfaces(rhs.getInterfaces());
        } else {
            clearInterfaces();
        }
    }
    return *this;
}

inline bool InterfacesAddedSignal::operator == (const InterfacesAddedSignal& rhs) const {
    return (((!hasObject() && !rhs.hasObject()) || getObject() == rhs.getObject()) &&
        ((!hasInterfaces() && !rhs.hasInterfaces()) || getInterfaces() == rhs.getInterfaces()));
}

inline bool InterfacesAddedSignal::operator != (const InterfacesAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool InterfacesAddedSignal::operator < (const InterfacesAddedSignal& rhs) const {
    if (hasObject() || rhs.hasObject()) {
        if (getObject() < rhs.getObject()) return true;
        if (getObject() > rhs.getObject()) return false;
    }
    if (hasInterfaces() || rhs.hasInterfaces()) {
        if (getInterfaces() < rhs.getInterfaces()) return true;
        if (getInterfaces() > rhs.getInterfaces()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InterfacesAddedSignal::clone() {
    return new InterfacesAddedSignal(*this);
}

inline bool InterfacesAddedSignal::operator > (const InterfacesAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InterfacesAddedSignal::clear() {
    clearObject();
    clearInterfaces();
}

inline void InterfacesAddedSignal::clearObject() {
    if (hasObject()) {
         clear_has_object();
        _object.clear();
     }
}

inline bool InterfacesAddedSignal::hasObject () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& InterfacesAddedSignal::getObject () const {
    return _object;
}

inline ::std::string& InterfacesAddedSignal::getObjectMutable () {
    set_has_object();
    return _object;
}

inline void InterfacesAddedSignal::setObject (const ::std::string& object_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (object_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_object();
    this->_object = object_;
}

inline void InterfacesAddedSignal::setObject (const char* object_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (object_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_object();
    this->_object.assign(object_);
}

inline void InterfacesAddedSignal::setObject (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_object();
    this->_object.assign(value, size);
}

inline void InterfacesAddedSignal::clearInterfaces() {
    if (hasInterfaces()) {
         clear_has_interfaces();
        _interfaces.clear();
     }
}

inline bool InterfacesAddedSignal::hasInterfaces () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& InterfacesAddedSignal::getInterfaces () const {
    return _interfaces;
}

inline ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& InterfacesAddedSignal::getInterfacesMutable () {
    set_has_interfaces();
    return _interfaces;
}

inline void InterfacesAddedSignal::setInterfaces (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& interfaces_) {
    set_has_interfaces();
    this->_interfaces = interfaces_;
}

inline void InterfacesAddedSignal::set_has_object () {
    _has_bits_[0] |= 1u << 0;
}

inline void InterfacesAddedSignal::clear_has_object () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void InterfacesAddedSignal::set_has_interfaces () {
    _has_bits_[0] |= 1u << 1;
}

inline void InterfacesAddedSignal::clear_has_interfaces () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  InterfacesRemovedSignal::InterfacesRemovedSignal ()  :
    _object (),
    _interfaces ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InterfacesRemovedSignal::InterfacesRemovedSignal (const InterfacesRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _object (),
    _interfaces ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InterfacesRemovedSignal::InterfacesRemovedSignal (const ::std::string& object_, const ::std::vector< ::std::string >& interfaces_)  :
    _object (object_),
    _interfaces (interfaces_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (object_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InterfacesRemovedSignal::~InterfacesRemovedSignal() {
}

inline InterfacesRemovedSignal& InterfacesRemovedSignal::operator = (const InterfacesRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasObject()) {
            setObject(rhs.getObject());
        } else {
            clearObject();
        }
        if (rhs.hasInterfaces()) {
            setInterfaces(rhs.getInterfaces());
        } else {
            clearInterfaces();
        }
    }
    return *this;
}

inline bool InterfacesRemovedSignal::operator == (const InterfacesRemovedSignal& rhs) const {
    return (((!hasObject() && !rhs.hasObject()) || getObject() == rhs.getObject()) &&
        ((!hasInterfaces() && !rhs.hasInterfaces()) || getInterfaces() == rhs.getInterfaces()));
}

inline bool InterfacesRemovedSignal::operator != (const InterfacesRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool InterfacesRemovedSignal::operator < (const InterfacesRemovedSignal& rhs) const {
    if (hasObject() || rhs.hasObject()) {
        if (getObject() < rhs.getObject()) return true;
        if (getObject() > rhs.getObject()) return false;
    }
    if (hasInterfaces() || rhs.hasInterfaces()) {
        if (getInterfaces() < rhs.getInterfaces()) return true;
        if (getInterfaces() > rhs.getInterfaces()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InterfacesRemovedSignal::clone() {
    return new InterfacesRemovedSignal(*this);
}

inline bool InterfacesRemovedSignal::operator > (const InterfacesRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InterfacesRemovedSignal::clear() {
    clearObject();
    clearInterfaces();
}

inline void InterfacesRemovedSignal::clearObject() {
    if (hasObject()) {
         clear_has_object();
        _object.clear();
     }
}

inline bool InterfacesRemovedSignal::hasObject () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& InterfacesRemovedSignal::getObject () const {
    return _object;
}

inline ::std::string& InterfacesRemovedSignal::getObjectMutable () {
    set_has_object();
    return _object;
}

inline void InterfacesRemovedSignal::setObject (const ::std::string& object_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (object_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_object();
    this->_object = object_;
}

inline void InterfacesRemovedSignal::setObject (const char* object_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (object_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_object();
    this->_object.assign(object_);
}

inline void InterfacesRemovedSignal::setObject (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_object();
    this->_object.assign(value, size);
}

inline void InterfacesRemovedSignal::clearInterfaces() {
    if (hasInterfaces()) {
         clear_has_interfaces();
        _interfaces.clear();
     }
}

inline bool InterfacesRemovedSignal::hasInterfaces () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::vector< ::std::string >& InterfacesRemovedSignal::getInterfaces () const {
    return _interfaces;
}

inline ::std::vector< ::std::string >& InterfacesRemovedSignal::getInterfacesMutable () {
    set_has_interfaces();
    return _interfaces;
}

inline void InterfacesRemovedSignal::setInterfaces (const ::std::vector< ::std::string >& interfaces_) {
    set_has_interfaces();
    this->_interfaces = interfaces_;
}

inline void InterfacesRemovedSignal::set_has_object () {
    _has_bits_[0] |= 1u << 0;
}

inline void InterfacesRemovedSignal::clear_has_object () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void InterfacesRemovedSignal::set_has_interfaces () {
    _has_bits_[0] |= 1u << 1;
}

inline void InterfacesRemovedSignal::clear_has_interfaces () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace ObjectManager
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace objmgr

#endif // OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
