/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLESTUB_H
#define INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLESTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "introspect/org/freedesktop/DBus/Introspectable.h"
#include <string>

namespace introspect {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Introspectable {

class IntrospectableStubDelegate;

class IntrospectableStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the IntrospectableStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    IntrospectableStub (const std::string& portName);

    /**
     * Create an instance of the IntrospectableStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    IntrospectableStub (const std::string& portName, const std::string& objectPath);

    /**
     * Create an instance of the IntrospectableStub without a provided port in the cmc file.
     *
     * Not intended to be used outside of ASF itself
     *
     * @param connector the connector used for offering the service
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    IntrospectableStub(::asf::dbus::DBusConnector& connector, const std::string& objectPath);

    virtual ~IntrospectableStub();

    // method 'Introspect'

    /**
     * The method onIntrospect() is called by ASF when a client invokes the
     * method 'Introspect'. A subclass has to implement this method and send
     * back a response to the client either with the sendIntrospect() or
     * sendIntrospectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Introspect'</b>:
     *
     * If the meaning of "Introspect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onIntrospectRequest (const ::boost::shared_ptr< IntrospectRequest >& request) = 0;

    /**
     * The method sendIntrospectResponse() sends a response of a previous
     * method invocation of 'Introspect' back to the client.
     *
     * <b>Documentation of 'Introspect'</b>:
     *
     * If the meaning of "Introspect" isn't clear, then there should be a description here.
     *
     * @param xml If the meaning of "xml" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onIntrospect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendIntrospectResponse (const ::std::string& xml, act_t act = 0);

    /**
     * The method sendIntrospectError() sends an error response of a previous
     * method invocation of 'Introspect' back to the client.
     *
     * <b>Documentation of 'Introspect'</b>:
     *
     * If the meaning of "Introspect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onIntrospect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendIntrospectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class IntrospectableStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Introspectable
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace introspect

#endif // INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLESTUB_H
