/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "introspect/org/freedesktop/DBus/Introspectable.h"
#include "introspect/org/freedesktop/DBus/IntrospectableDBus.h"
#include "introspect/org/freedesktop/DBus/IntrospectableJson.h"
#include "introspect/org/freedesktop/DBus/IntrospectableStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace introspect {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Introspectable {

DEFINE_CLASS_LOGGER("//xyz/org/freedesktop/DBus/Introspectable", IntrospectableStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "Introspect", 0 },
};


class IntrospectableStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    IntrospectableStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    IntrospectableStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    IntrospectableStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.DBus.Introspectable"),
          _logger(logger) {}

    virtual ~IntrospectableStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void IntrospectableStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Introspect'

            LOG_DEBUG_STUB("process method '%s'", "Introspect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IntrospectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Introspect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< IntrospectRequest > payload = ::boost::static_pointer_cast<IntrospectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<IntrospectableStub*>(getStub())->onIntrospectRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* IntrospectableStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.DBus.Introspectable\">\n"
            "      <method name=\"Introspect\">\n"
            "        <arg direction=\"out\" name=\"xml\" type=\"s\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void IntrospectableStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<IntrospectableStub*>(getStub()))->onGetAll (properties);
}

void IntrospectableStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void IntrospectableStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

IntrospectableStub::IntrospectableStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new IntrospectableStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IntrospectableStub::IntrospectableStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new IntrospectableStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IntrospectableStub::IntrospectableStub(::asf::dbus::DBusConnector& connector,
                                       const std::string& objectPath)
    : ::asf::dbus::DBusStub(_logger) {
    _stubDelegate = new IntrospectableStubDelegate(this, _logger, connector, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

IntrospectableStub::~IntrospectableStub() {
    delete _stubDelegate;
}

void  IntrospectableStub::sendIntrospectResponse (const ::std::string& xml, act_t act) {
    IntrospectResponse* payload = new IntrospectResponse(xml);
    DBUS_MESSAGE_REPLY(dbusMessage, "Introspect", IntrospectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Introspect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  IntrospectableStub::sendIntrospectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    IntrospectError* payload = new IntrospectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Introspect", IntrospectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Introspect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void IntrospectableStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Introspectable
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace introspect
